/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000192c0ULL, 0x0000000000018f40ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000017380ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000017500ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000017540ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000017590ULL, 0x00000000000000f0ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000017680ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001738000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x005b700400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001738000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080860828ULL, 0x2880809308288080ULL,
0x8095082880809408ULL, 0x0828808096082880ULL, 0x80809c0828808097ULL, 0xa5082880809f0828ULL,
0x288080a708288080ULL, 0x80ef08288080ec08ULL, 0x08288080f0082880ULL, 0x8080f208288080f1ULL,
0x8808288080f30828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808088920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001750000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9308288080860828ULL, 0x2880809408288080ULL, 0x8096082880809508ULL, 0x0828808097082880ULL,
0x80809f082880809cULL, 0xa708288080a60828ULL, 0x288080ec08288080ULL, 0x80f008288080ef08ULL,
0x08288080f1082880ULL, 0x8080f308288080f2ULL, 0x8016288080a50828ULL, 0x0000000310288082ULL,
0x80a5920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x000001c000000000ULL,
0x0001754000000000ULL, 0x0000005000000000ULL, 0x0000040400000000ULL, 0x80ec288080a50900ULL,
0x0000000000002880ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9308288080860828ULL,
0x2880809408288080ULL, 0x8096082880809508ULL, 0x0828808097082880ULL, 0x80809f082880809cULL,
0xa708288080a50828ULL, 0x288080ec08288080ULL, 0x80f008288080ef08ULL, 0x08288080f1082880ULL,
0x8080f308288080f2ULL, 0x8016288080a60828ULL, 0x0000000310288082ULL, 0x80a6920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000029800000000ULL, 0x0001759000000000ULL,
0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL, 0x00082304000000deULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL,
0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0060016000000016ULL, 0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000b0000043104ULL, 0xffffffff019c2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00000100019c2804ULL,
0x00000580000002d0ULL, 0x00002a50000029a0ULL, 0x00002cd000002b60ULL, 0x00002fa000002e40ULL,
0x00003430000033f0ULL, 0x0000347000003440ULL, 0x00005730000056a0ULL, 0x000059c000005850ULL,
0x00005c9000005b30ULL, 0x0000615000006110ULL, 0x0000619000006160ULL, 0x00008240000081a0ULL,
0x000084d000008360ULL, 0x000087a000008640ULL, 0x00008c6000008c20ULL, 0x00008ca000008c70ULL,
0x0000ae400000ada0ULL, 0x0000b0c00000af50ULL, 0x0000b3900000b230ULL, 0x0000b8600000b820ULL,
0x0000b8a00000b870ULL, 0x0000cd200000cd10ULL, 0x0000cd400000cd30ULL, 0x000150e0000150a0ULL,
0x00015100000150f0ULL, 0x0001517000015150ULL, 0x000151a000015190ULL, 0x0001655000016500ULL,
0x000165e0000165a0ULL, 0x0001666000016620ULL, 0x00016700000166b0ULL, 0x000167a000016750ULL,
0x00016840000167f0ULL, 0x000168d000016890ULL, 0x0001695000016910ULL, 0x000169f0000169a0ULL,
0x00016a9000016a40ULL, 0x00016b3000016ae0ULL, 0x00016bc000016b80ULL, 0x00016c4000016c00ULL,
0x00016ce000016c90ULL, 0x00016d8000016d30ULL, 0x00016e2000016dd0ULL, 0x00016eb000016e70ULL,
0x00016f3000016ef0ULL, 0x00016fd000016f80ULL, 0x0001707000017020ULL, 0x00017120000170c0ULL,
0x000171e000017180ULL, 0x000172a000017240ULL, 0x0001736000017300ULL, 0x000003c004403904ULL,
0x00012600000000ffULL, 0x00000400003f0100ULL, 0x000126080000000fULL, 0x000004f0003f0120ULL,
0x000126880000000fULL, 0x00000510003f0120ULL, 0x000126a80000000fULL, 0x00000540003f0120ULL,
0x000126c80000000fULL, 0x00000b20003f0120ULL, 0x00012600000000ffULL, 0x00000d10003f0107ULL,
0x0000000400000006ULL, 0x00000dc0003f0102ULL, 0x0000000000000006ULL, 0x000017d0003f0101ULL,
0x00000000000000ffULL, 0x0000185000040107ULL, 0x00000000000000ffULL, 0x000018b000040101ULL,
0x0000002000000002ULL, 0x00001a60003f0101ULL, 0x000126cc00000019ULL, 0x00001c40003f0105ULL,
0x000126cc00000019ULL, 0x00002590003f0105ULL, 0x000126b000000020ULL, 0x00002640003f0107ULL,
0x000126b000000020ULL, 0x000026a0003f0101ULL, 0x0001260800000004ULL, 0x000026c0003f0101ULL,
0x0001260c00000004ULL, 0x00002890003f0105ULL, 0x0001260c00000004ULL, 0x00003150003f0105ULL,
0x000126ac00000020ULL, 0x00003320003f0105ULL, 0x000126ac00000020ULL, 0x00004820003f0105ULL,
0x000000000000006cULL, 0x00004880003f0101ULL, 0x0001268800000025ULL, 0x000048b0003f0101ULL,
0x0000000400000005ULL, 0x00004a70003f0105ULL, 0x0000000400000005ULL, 0x00005300003f0105ULL,
0x000126a8000000ffULL, 0x0000538000040107ULL, 0x000126a8000000ffULL, 0x000053e000040101ULL,
0x0001262800000004ULL, 0x00005400003f0101ULL, 0x0001262c00000004ULL, 0x000055d0003f0105ULL,
0x0001262c00000004ULL, 0x00005e80003f0105ULL, 0x000126b40000006cULL, 0x00006050003f0105ULL,
0x000126b40000006cULL, 0x00007310003f0105ULL, 0x000000000000006eULL, 0x00007370003f0101ULL,
0x0001269000000026ULL, 0x000073a0003f0101ULL, 0x0000000400000005ULL, 0x00007560003f0105ULL,
0x0000000400000005ULL, 0x00007db0003f0105ULL, 0x000126b000000025ULL, 0x00007e80003f0107ULL,
0x000126b000000025ULL, 0x00007ee0003f0101ULL, 0x0001264800000004ULL, 0x00007f00003f0101ULL,
0x0001264c00000004ULL, 0x000080d0003f0105ULL, 0x0001264c00000004ULL, 0x00008990003f0105ULL,
0x000126ac00000070ULL, 0x00008b60003f0105ULL, 0x000126ac00000070ULL, 0x00009e40003f0105ULL,
0x0000000000000025ULL, 0x00009ea0003f0101ULL, 0x000126980000001aULL, 0x00009ed0003f0101ULL,
0x0000000400000025ULL, 0x0000a0b0003f0105ULL, 0x0000000400000025ULL, 0x0000a9f0003f0105ULL,
0x000126a800000020ULL, 0x0000aa90003f0107ULL, 0x000126a800000020ULL, 0x0000aaf0003f0101ULL,
0x0001266800000006ULL, 0x0000ab20003f0101ULL, 0x0001266c00000006ULL, 0x0000acf0003f0105ULL,
0x0001266c00000006ULL, 0x0000b580003f0105ULL, 0x000126b400000023ULL, 0x0000b750003f0105ULL,
0x000126b400000023ULL, 0x0000cac0003f0105ULL, 0x0000000000000005ULL, 0x0000cb40003f0101ULL,
0x0000000000000004ULL, 0x0000e8a0003f0101ULL, 0x00012600000000ffULL, 0x0000f4c0003f0101ULL,
0x00012604000000ffULL, 0x0000f690003f0105ULL, 0x00012604000000ffULL, 0x0000fa10003f0105ULL,
0x00012600000000ffULL, 0x0000fa40003f0101ULL, 0x00012604000000ffULL, 0x0000fc00003f0105ULL,
0x00012604000000ffULL, 0x00012560003f0105ULL, 0x0000000000000067ULL, 0x00012690003f0101ULL,
0x0000000400000067ULL, 0x00012860003f0105ULL, 0x0000000400000067ULL, 0x00016360003f0105ULL,
0x0000000000000066ULL, 0x000163c0003f0101ULL, 0x0000000800000066ULL, 0x00016420003f0101ULL,
0x0000001000000066ULL, 0x00016490003f0101ULL, 0x0000001800000066ULL, 0x00053803003f0101ULL,
0x0000dc4000301c04ULL, 0x0000de500000dc70ULL, 0x0000e1100000dfb0ULL, 0x0000e3d00000e270ULL,
0x0000e6c00000e530ULL, 0x0000fc600000e7c0ULL, 0x00000401000164d0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000034cULL, 0x0000001900000002ULL, 0x0000000000000274ULL, 0x0000001900000002ULL,
0x00000000000001acULL, 0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL,
0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000325ULL, 0x0000001900000002ULL,
0x000000000000024dULL, 0x0000001900000002ULL, 0x0000000000000182ULL, 0x0000001900000002ULL,
0x00000000000000a8ULL, 0x0000001900000002ULL, 0x0000000000012700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff147624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x00000000007a7919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000d7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0014867a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL,
0x00000005ff127819ULL, 0x010fc80000011609ULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x00001fff12127589ULL, 0x000fe200000e0000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x010fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e0214ULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007a030b7227ULL, 0x004fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a0bULL,
0x0000000007007224ULL, 0x000fca00078e027aULL, 0x000000070000720cULL, 0x000fe20003f46070ULL,
0x000001000d027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0d0d7589ULL, 0x000e6400000e0000ULL,
0x00000000020f7a24ULL, 0x000fca00078e0209ULL, 0x000000ff0f00720cULL, 0x000fc60003fa5270ULL,
0x0000000100002824ULL, 0x000fe200078e0a07ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x000000070000720cULL, 0x000fe40003f66070ULL,
0x0000007f0f00780cULL, 0x040fe40003f04070ULL, 0x000000030f00780cULL, 0x000fe20003f44070ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fe400078e00ffULL, 0x000000010b0b3810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000007ff0bc212ULL, 0x000fe200078e33ffULL,
0x01260002ff00d388ULL, 0x0005e20000000a00ULL, 0xff317217ff0a8424ULL, 0x000fe200078e00ffULL,
0x000000010f00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff06a424ULL, 0x000fe200078e00ffULL,
0x012608040f009388ULL, 0x0007e20000008a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a0bULL,
0x00005a000b797a19ULL, 0x000fc400000006ffULL, 0x0124000a0f008388ULL, 0x000fe20000004800ULL,
0x00000000077a7224ULL, 0x000fe400078e027aULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x000000207a007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe200078e00ffULL,
0x0000000000047919ULL, 0x008ea20000002700ULL, 0x7fffff80ff07a424ULL, 0x000fe200078e00ffULL,
0x0000000400057c10ULL, 0x040fe2000fffe1ffULL, 0x3fffffc0ff08b424ULL, 0x000fe200078e00ffULL,
0x0000000400007c0cULL, 0x000fe2000bf03070ULL, 0x7fffffc0ff09b424ULL, 0x000fe200078e00ffULL,
0x0000002005057817ULL, 0x000fe20003800000ULL, 0x012688020f00a388ULL, 0x0005e60000008a00ULL,
0x000000ff05787207ULL, 0x000fe20000000000ULL, 0x0126a8060f00a388ULL, 0x000fe20000008a00ULL,
0x000000040d057824ULL, 0x002fc400078e0212ULL, 0x000000207800780cULL, 0x000fe20003f05270ULL,
0x0126c8080f00b388ULL, 0x000fe20000008a00ULL, 0x0000000405057824ULL, 0x000fe400078e00ffULL,
0x0000580004027a24ULL, 0x004fc800078e02ffULL, 0x0000008602027224ULL, 0x000fe200078e0279ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000578067217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000106067824ULL, 0x000fe200078e0a05ULL,
0x00000004ff037819ULL, 0x002fc80000011611ULL, 0x00000002030a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0203ULL, 0x000000060300720cULL, 0x080fe40003f06070ULL,
0x000000060a00720cULL, 0x000fe20003f26070ULL, 0x00000001050c7824ULL, 0x000fe400078e020aULL,
0x0000000100077824ULL, 0x040fe400078e0208ULL, 0x00000001000e7824ULL, 0x000fe400078e020cULL,
0x0000001011057824ULL, 0x000fe200078e00ffULL, 0x0000000407097c12ULL, 0x000fe2000f8e30ffULL,
0x00000001080a7824ULL, 0x000fe200078e0211ULL, 0x000000040e0f7c12ULL, 0x000fc4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fe20000011607ULL, 0x0000000102097824ULL, 0x040fe400078e0209ULL,
0x0000000102107824ULL, 0x000fe200078e020fULL, 0x00005a00ff0f7a19ULL, 0x000fe2000001160eULL,
0x0000008607027224ULL, 0x000fe200078e0209ULL, 0x000000f005097812ULL, 0x000fc600078ec0ffULL,
0x000000860f077224ULL, 0x000fe400078e0210ULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000902027212ULL, 0x000fc600078efcffULL,
0x00000010080f7824ULL, 0x000fe200078e00ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x000000010c087824ULL, 0x000fe200078e0211ULL, 0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c097824ULL, 0x000fe200078e00ffULL, 0xfffffff00f0a7812ULL, 0x000fe400078ee20aULL,
0x00005e0006067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff009087812ULL, 0x000fe200078ee208ULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x00000010080f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000c101c48ULL,
0x00000000060f7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000511087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x0000000108097824ULL, 0x000fe400078e0211ULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe2000f8e30ffULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00005a00ff037a19ULL, 0x000fe20000011603ULL,
0x000000010a087824ULL, 0x000fe200078e0211ULL, 0x0000000406077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0xfffffff00c097812ULL, 0x000fc600078ee209ULL,
0x0000000102027824ULL, 0x000fe200078e0207ULL, 0x00005a00ff077a19ULL, 0x000fe20000011606ULL,
0x0000008603037224ULL, 0x080fe400078e0205ULL, 0x0000001011057824ULL, 0x000fe400078e00ffULL,
0x0000008607077224ULL, 0x000fe400078e0202ULL, 0x0000010003027825ULL, 0x000fe200078e00ffULL,
0x000000f0050f7812ULL, 0x000fc600078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000f02027212ULL, 0x000fc600078efcffULL, 0x0000001009097824ULL, 0x000fe200078e00ffULL,
0x0000000f06067212ULL, 0x000fe200078efcffULL, 0x000000100a0f7824ULL, 0x000fe200078e00ffULL,
0x00005e0002027a10ULL, 0x000fe40007f1e0ffULL, 0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00f087812ULL, 0x000fe400078ee208ULL, 0x00005f0003037a10ULL, 0x000fe400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080f7824ULL, 0x000fc400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c48ULL,
0x00000000060f7faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff237424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600027300ULL, 0x000e7000000e0000ULL,
0x0000000600077309ULL, 0x000ea20000000000ULL, 0x000000030200720cULL, 0x002fe20003f02070ULL,
0x0000660004027625ULL, 0x000fc800078e0023ULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01260407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01260000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000802107981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0d00720cULL, 0x000fe40003f05270ULL, 0x0000003f100f7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff100a7810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff0f7819ULL, 0x000fe4000001160fULL,
0x00000008ff0e7819ULL, 0x000fca000001160aULL, 0x0000db7000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011612ULL, 0x00000003ff077424ULL, 0x002fe200078e00ffULL,
0x0001268812067811ULL, 0x000fe400078e18ffULL, 0x03ffffff0d167812ULL, 0x000fc800078ec0ffULL,
0x0000000f1600720cULL, 0x000fda0003f06070ULL, 0x0000000204008824ULL, 0x000fe400078e00ffULL,
0x00006800ff038624ULL, 0x000fc800078e00ffULL, 0x0000680000038624ULL, 0x000fe400078e0203ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000116038824ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040706ff738cULL, 0x0003e20000000000ULL,
0x0000640003028625ULL, 0x000fe200078e0023ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000802008981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x000000400b0b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011612ULL,
0x0000000006ff7f8cULL, 0x0007e8000c80043fULL, 0x000000200c7b7824ULL, 0x000fca00078e00ffULL,
0x000000200b077812ULL, 0x002fe200078ef87bULL, 0x0000590000087a24ULL, 0x004fe200078e02ffULL,
0x0000000112007812ULL, 0x000fc600078ec0ffULL, 0x00000040081b7824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000001000037824ULL, 0x008fe200078e00ffULL,
0x0000007b10007217ULL, 0x000fe40007800000ULL, 0x00000003ff027819ULL, 0x000fe40000011611ULL,
0x000062001b177a11ULL, 0x000fe200078838ffULL, 0x0000000100007824ULL, 0x000fe200078e0a7bULL,
0x0000000402097810ULL, 0x000fe20007ffe0ffULL, 0x0000000103067824ULL, 0x000fe200078e0202ULL,
0x000063001b1b7a11ULL, 0x000fc400020f3cffULL, 0x0000000300007217ULL, 0x000fe20007800000ULL,
0x0000000106087824ULL, 0x040fe400078e0211ULL, 0x0000000806137824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fc600078e0a03ULL, 0xfffffff8130a7812ULL, 0x000fe400078ee208ULL,
0x0000000802087810ULL, 0x040fe40007ffe0ffULL, 0x000000000200720cULL, 0x0c0fe40003f66070ULL,
0x0000000c02137810ULL, 0x000fe20007ffe0ffULL, 0x0000000107027824ULL, 0x000fe200078e0206ULL,
0x000000000800720cULL, 0x080fe20003f26070ULL, 0x0000000103067824ULL, 0x000fe200078e0209ULL,
0x000000000900720cULL, 0x080fe20003f46070ULL, 0x0000000103087824ULL, 0x000fe200078e0208ULL,
0x000000001300720cULL, 0x000fe20003f06070ULL, 0x0000000103147824ULL, 0x000fc400078e0213ULL,
0x0000000106037824ULL, 0x140fe400078e0211ULL, 0x0000000806187824ULL, 0x000fe400078e00ffULL,
0x0000000108097824ULL, 0x040fe400078e0211ULL, 0x00000008081a7824ULL, 0x000fe200078e00ffULL,
0xfffffff818007812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fc600078e00ffULL,
0xfffffff81a187812ULL, 0x000fe200078ee209ULL, 0x0000000107067824ULL, 0x040fe200078e0206ULL,
0x0000007002027812ULL, 0x000fe200078ef805ULL, 0x0000000107087824ULL, 0x040fe400078e0208ULL,
0x0000000107157824ULL, 0x000fe200078e0214ULL, 0x0000000217027210ULL, 0x000fe20007f9e0ffULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000000114137824ULL, 0x000fe200078e0211ULL,
0x0000007006067812ULL, 0x000fe200078ef805ULL, 0x00000008141a7824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x0000008015147825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef805ULL,
0x0000000103037824ULL, 0x000fe200020e061bULL, 0x0000007014147812ULL, 0x000fe400078ef805ULL,
0x0000e0000c057811ULL, 0x000fe400078e68ffULL, 0x0000001706067210ULL, 0x080fe40007f9e0ffULL,
0x0000001708087210ULL, 0x080fe20007fbe0ffULL, 0x000000100a137824ULL, 0x100fe200078e0205ULL,
0x0000001714147210ULL, 0x000fe20007fde0ffULL, 0x0000001000177824ULL, 0x000fc400078e0205ULL,
0x0000000107077824ULL, 0x000fe200020e061bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002137faeULL, 0x0003e2000d901c48ULL, 0x0000001018197824ULL, 0x000fe400078e0205ULL,
0x0000000109097824ULL, 0x000fe200028e061bULL, 0x0000000006177faeULL, 0x0003e2000d101c48ULL,
0x000000101a057824ULL, 0x000fe400078e0205ULL, 0x0000000115157824ULL, 0x000fe200030e061bULL,
0x0000000008197faeULL, 0x0003e8000c901c48ULL, 0x0000000014057faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x000062001b197a11ULL, 0x000fc800078038ffULL, 0x0000000011007211ULL, 0x000fe400078fe8ffULL,
0x000063001b1b7a11ULL, 0x000fe400000f3cffULL, 0x0000000400067810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x140fe200078e0211ULL, 0x0000000800087810ULL, 0x040fe20007ffe0ffULL,
0x0000000800037824ULL, 0x000fe400078e00ffULL, 0x0000000806147824ULL, 0x000fe400078e00ffULL,
0x0000000108097824ULL, 0x100fe200078e0211ULL, 0xfffffff8030a7812ULL, 0x000fe200078ee202ULL,
0x0000000106037824ULL, 0x000fc400078e0211ULL, 0x0000000107027824ULL, 0x000fe200078e0200ULL,
0x0000000c00007810ULL, 0x000fe20007ffe0ffULL, 0x0000000808187824ULL, 0x000fe200078e00ffULL,
0xfffffff814137812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fc600078e00ffULL,
0xfffffff818177812ULL, 0x000fe200078ee209ULL, 0x0000000107067824ULL, 0x040fe200078e0206ULL,
0x0000007002027812ULL, 0x000fe200078ef805ULL, 0x0000000107087824ULL, 0x040fe400078e0208ULL,
0x0000000107147824ULL, 0x000fe200078e0200ULL, 0x0000000219027210ULL, 0x000fe20007f1e0ffULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fc600078ef805ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc600078ef805ULL, 0x0000000100187824ULL, 0x000fe200078e0211ULL,
0x0000007014057812ULL, 0x000fe200078ef805ULL, 0x00000008001d7824ULL, 0x000fe200078e00ffULL,
0x0000e0000c007811ULL, 0x000fe200078e68ffULL, 0x0000000103037824ULL, 0x100fe200000e061bULL,
0x0000000619067210ULL, 0x040fe40007f1e0ffULL, 0x0000000819087210ULL, 0x000fe20007f3e0ffULL,
0x0000001013137824ULL, 0x000fe200078e0200ULL, 0xfffffff81d187812ULL, 0x000fe200078ee218ULL,
0x0000000107077824ULL, 0x000fe200000e061bULL, 0x0000000519147210ULL, 0x000fe20007f5e0ffULL,
0x000000100a057824ULL, 0x000fc400078e0200ULL, 0x0000001017177824ULL, 0x100fe400078e0200ULL,
0x0000000109097824ULL, 0x100fe200008e061bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000b901c48ULL, 0x0000001018197824ULL, 0x000fe400078e0200ULL,
0x0000000115157824ULL, 0x000fe200010e061bULL, 0x0000000006137faeULL, 0x0003e8000b901c48ULL,
0x0000000008177faeULL, 0x0003e8000b901c48ULL, 0x0000000014197faeULL, 0x0003e4000b901c48ULL,
0x00000001160a7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0x0000000f0a00720cULL, 0x000fda0003f06070ULL, 0x0000006000000947ULL, 0x000fea0003800000ULL,
0x0000000204007824ULL, 0x000fe400078e00ffULL, 0x00006800ff037624ULL, 0x002fc800078e00ffULL,
0x0000680000037624ULL, 0x000fc800078e0203ULL, 0x0000000103227824ULL, 0x000fc800078e020aULL,
0x0000640022227625ULL, 0x000fcc00078e0023ULL, 0x0000000822227981ULL, 0x000324000c1e1900ULL,
0x000000000c0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000126a80c027811ULL, 0x002fe200078e18ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x000126a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3d7224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff187f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000b22000008947ULL, 0x000fea0003800000ULL,
0x000000100c077824ULL, 0x000fe400078e00ffULL, 0x0000000204097824ULL, 0x000fc400078e00ffULL,
0x00006800ff007624ULL, 0x000fe200078e00ffULL, 0x0000001007077812ULL, 0x000fe200078ee2ffULL,
0x000000ffff187224ULL, 0x002fe400078e0019ULL, 0x000000ffff177224ULL, 0x004fe400078e0003ULL,
0x0000680009097624ULL, 0x000fe400078e0200ULL, 0xff317217ff1a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fc400078e00ffULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x000fe400078e000aULL, 0x000000ffff1c7224ULL, 0x00afc600078e00ffULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x0000000412047824ULL, 0x000fca00078e00ffULL,
0xfffffff804197812ULL, 0x000fc800078ec0ffULL, 0x000126c8191b7810ULL, 0x000fe20007ffe0ffULL,
0x0126cc0019047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e001bULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x00000004021d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000001d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126cc0019047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fc400078e001bULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001012027824ULL, 0x000fe200078e00ffULL,
0x0000000108177810ULL, 0x000fe20007ffe0ffULL, 0x0000590022227a24ULL, 0x010fc600078e02ffULL,
0xffffffe002037812ULL, 0x000fe200078ec0ffULL, 0x0000004022227824ULL, 0x000fe200078e00ffULL,
0x0000000e1700720cULL, 0x000fc60003f26070ULL, 0x0000010008037824ULL, 0x000fca00078e0203ULL,
0x0000004003197810ULL, 0x000fc80007ffe0ffULL, 0x0000002019047812ULL, 0x000fca00078ec0ffULL,
0x000000010b217824ULL, 0x000fe200078e0204ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001002037812ULL, 0x000fe200078ec0ffULL, 0x00000010111d7824ULL, 0x000fe200078e00ffULL,
0x0000001910027217ULL, 0x000fe40007800000ULL, 0x00000003ff1b7819ULL, 0x000fe40000011611ULL,
0x000000701d297812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a19ULL,
0x000000041b1c7810ULL, 0x040fe20007ffe0ffULL, 0x000000011b047824ULL, 0x000fe200078e0203ULL,
0x0000620022257a11ULL, 0x000fc400078a38ffULL, 0x0000000302027217ULL, 0x000fe20007800000ULL,
0x0000000104177824ULL, 0x000fe200078e0211ULL, 0x0000630022277a11ULL, 0x000fe200028f3cffULL,
0x00000008041e7824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fc600078e0a03ULL,
0xfffffff81e177812ULL, 0x000fe400078ee217ULL, 0x000000081b1e7810ULL, 0x040fe40007ffe0ffULL,
0x000000021b00720cULL, 0x0c0fe40003f86070ULL, 0x0000000c1b1b7810ULL, 0x000fe40007ffe0ffULL,
0x000000021c00720cULL, 0x0c0fe20003f66070ULL, 0x000000011c1c7824ULL, 0x100fe200078e0203ULL,
0x000000021e00720cULL, 0x0c0fe20003f46070ULL, 0x000000011e1e7824ULL, 0x100fe200078e0203ULL,
0x000000021b00720cULL, 0x040fe20003f06070ULL, 0x000000011b207824ULL, 0x000fc400078e0203ULL,
0x000000011c037824ULL, 0x040fe400078e0211ULL, 0x000000081c267824ULL, 0x000fe400078e00ffULL,
0x0000000121027824ULL, 0x040fe400078e0204ULL, 0x00000001211c7824ULL, 0x000fe200078e021cULL,
0xfffffff826197812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000002902027212ULL, 0x000fc600078efcffULL,
0x000000011e1b7824ULL, 0x040fe200078e0211ULL, 0x0000000225027210ULL, 0x000fe20007fbe0ffULL,
0x000000081e287824ULL, 0x000fe200078e00ffULL, 0x000000291c1c7212ULL, 0x000fe200078efcffULL,
0x00000001211e7824ULL, 0x040fe400078e021eULL, 0x0000000121217824ULL, 0x000fe200078e0220ULL,
0xfffffff8281b7812ULL, 0x000fe200078ee21bULL, 0x0000000120047824ULL, 0x040fe400078e0211ULL,
0x0000000820237824ULL, 0x000fc400078e00ffULL, 0x000000801e1e7825ULL, 0x000fc600078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x0000008021207825ULL, 0x000fe200078e00ffULL,
0x000000291e1e7212ULL, 0x000fe400078efcffULL, 0x0000f0000c047811ULL, 0x000fe200078e68ffULL,
0x0000000103037824ULL, 0x100fe200028e0627ULL, 0x000000251c1c7210ULL, 0x000fe40007fbe0ffULL,
0x0000002920207212ULL, 0x000fe200078efcffULL, 0x0000001017177824ULL, 0x100fe400078e0204ULL,
0x000000011d1d7824ULL, 0x100fe200028e0627ULL, 0x000000251e1e7210ULL, 0x080fe20007fbe0ffULL,
0x0000001019197824ULL, 0x100fe200078e0204ULL, 0x0000002520207210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002177faeULL, 0x0003e2000e101c48ULL, 0x000000011f1f7824ULL, 0x000fc400028e0627ULL,
0x0000001023237824ULL, 0x000fe200078e0204ULL, 0x000000001c197faeULL, 0x0003e2000d901c48ULL,
0x0000000121217824ULL, 0x000fc600030e0627ULL, 0x000000001e1b7faeULL, 0x0003e8000d101c48ULL,
0x0000000020237faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001002027812ULL, 0x000fe400078ec0ffULL, 0x0000620022257a11ULL, 0x040fe400078038ffULL,
0x0000000211027211ULL, 0x000fe400078fe8ffULL, 0x0000630022277a11ULL, 0x000fc400000f3cffULL,
0x00000004021c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000102037824ULL, 0x140fe200078e0211ULL,
0x00000008021e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000802047824ULL, 0x000fe400078e00ffULL,
0x000000011c177824ULL, 0x040fe400078e0211ULL, 0x000000081c207824ULL, 0x000fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x0000000121037824ULL, 0x000fe400078e0202ULL,
0x000000011e1b7824ULL, 0x000fe200078e0211ULL, 0xfffffff820197812ULL, 0x000fe200078ee217ULL,
0x0000001011177824ULL, 0x000fe200078e00ffULL, 0x0000000c02207810ULL, 0x000fe20007ffe0ffULL,
0x0000008003027825ULL, 0x000fc600078e00ffULL, 0x0000007017237812ULL, 0x000fe200078ec0ffULL,
0x000000081e267824ULL, 0x000fe400078e00ffULL, 0x00000001211c7824ULL, 0x040fe200078e021cULL,
0x0000002302027212ULL, 0x000fe200078efcffULL, 0x00000001211e7824ULL, 0x040fe200078e021eULL,
0xfffffff8261b7812ULL, 0x000fe200078ee21bULL, 0x0000000121217824ULL, 0x000fe200078e0220ULL,
0x0000000225027210ULL, 0x000fe20007f1e0ffULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x0000000120177824ULL, 0x000fe200078e0211ULL, 0x000000231c1c7212ULL, 0x000fe200078efcffULL,
0x0000000820227824ULL, 0x000fe400078e00ffULL, 0x000000801e1e7825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x0000008021207825ULL, 0x000fe200078e00ffULL,
0x000000231e1e7212ULL, 0x000fc600078efcffULL, 0x0000000103037824ULL, 0x000fe200000e0627ULL,
0x0000002320207212ULL, 0x000fe400078efcffULL, 0x0000f0000c237811ULL, 0x000fe400078e68ffULL,
0x0000001c251c7210ULL, 0x040fe40007f1e0ffULL, 0x0000001e251e7210ULL, 0x040fe20007f5e0ffULL,
0x0000001004177824ULL, 0x100fe200078e0223ULL, 0x0000002025207210ULL, 0x000fe20007f7e0ffULL,
0x0000001019197824ULL, 0x000fc400078e0223ULL, 0x000000011d1d7824ULL, 0x000fe200000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002177faeULL, 0x0003e2000b901c48ULL,
0x000000101b1b7824ULL, 0x000fe400078e0223ULL, 0x000000011f1f7824ULL, 0x000fe200010e0627ULL,
0x000000001c197faeULL, 0x0003e2000b901c48ULL, 0x0000001022237824ULL, 0x000fe400078e0223ULL,
0x0000000121217824ULL, 0x000fe200018e0627ULL, 0x000000001e1b7faeULL, 0x0003e8000b901c48ULL,
0x0000000020237faeULL, 0x0003e4000b901c48ULL, 0x0000000812287824ULL, 0x000fe200078e00ffULL,
0x000000010a027810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff028207812ULL, 0x000fe400078ec0ffULL, 0x0000000f0200720cULL, 0x000fe40003f06070ULL,
0x00000000200473c2ULL, 0x000e6200000e0000ULL, 0x0000001028177812ULL, 0x040fe400078ec0ffULL,
0xffffffe028047812ULL, 0x040fe400078ec0ffULL, 0x0000000828197812ULL, 0x000fcc00078ec0ffULL,
0x0000000109028824ULL, 0x000fe400078e0202ULL, 0x00000004ff038424ULL, 0x000fe200078e00ffULL,
0x0000000419047210ULL, 0x000fe40007ffe017ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640002028625ULL, 0x000fca00078e0003ULL, 0x0000000802228981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b000206e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260800041e7f8cULL, 0x000664000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01260c0004177984ULL, 0x000ee40000000800ULL, 0x8000000017ff7812ULL, 0x00afe4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c021c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc8000001141dULL,
0x0000001c17177211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x0000000217177819ULL, 0x000fc8000000121cULL, 0x000000170000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000119197810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0004177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002012027824ULL, 0x000fe200078e00ffULL, 0x00000001ff197819ULL, 0x000fe20000011611ULL,
0x0000001011037824ULL, 0x000fe400078e00ffULL, 0xffffffffff847424ULL, 0x000fe200078e00ffULL,
0xffffff8002177812ULL, 0x000fc400078ec0ffULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c19027812ULL, 0x000fc800078ec0ffULL, 0x0000001702177210ULL, 0x000fca0007ffe003ULL,
0x0120000017197984ULL, 0x000e680000000800ULL, 0x01220000171b7984ULL, 0x0006a20000000800ULL,
0x0000001a1900720bULL, 0x002fe20003f1d000ULL, 0x00013b427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000177806ULL, 0x008fc800000e0100ULL, 0x000000ff1700720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e001aULL, 0x0000001fff887424ULL, 0x000fe400078e00ffULL,
0xffffffffff857424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x000000120d00720cULL, 0x000fe40003f05270ULL, 0x0000001a1900720bULL, 0x000fe20003f54000ULL,
0x00013ae27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x000fc400010e0100ULL,
0x00000080121d8824ULL, 0x000fe200078e0203ULL, 0x0000001a19237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000102268824ULL, 0x000fca00078e021dULL,
0x0124002326008388ULL, 0x0003e20000000800ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001a231a7221ULL, 0x002fe20000010100ULL,
0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1a1a7820ULL, 0x000fcc0000410000ULL, 0x0000001a001a7308ULL, 0x000e640000000800ULL,
0x0000001a24247220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe20000011611ULL, 0x00013a227f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002644447220ULL, 0x080fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000811277811ULL, 0x002fe200078ff0ffULL,
0x000138f27f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002646467220ULL, 0x080fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001011277811ULL, 0x002fe200078ff0ffULL, 0x000137c27f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x0000002664647220ULL, 0x080fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002668687220ULL, 0x080fe20000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001811277811ULL, 0x002fe200078ff0ffULL, 0x000136a27f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x0000002666667220ULL, 0x080fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x000000266a6a7220ULL, 0x080fe20000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001c17ff7212ULL, 0x000fda00078030ffULL, 0x8000002319190221ULL, 0x000fe20000010000ULL,
0x00007610ff1e0816ULL, 0x000fc6000000001eULL, 0x3fb8aa3b19190820ULL, 0x000fc80000410000ULL,
0x0000001900000308ULL, 0x000e640000000800ULL, 0x000000001b1b0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000241b247221ULL, 0x004fc40000010000ULL,
0x00000000001a7805ULL, 0x000fca0000015200ULL, 0x0126ac0020177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804818ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c1a1c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e1bULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc8000001141dULL, 0x0000001c17177211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000217177819ULL, 0x000fc8000000121cULL,
0x000000170000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000119197810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac0020177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101e177816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff177819ULL, 0x000fe40000011611ULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x000132927f007947ULL, 0x000fea000b800000ULL, 0x00001f1716137589ULL, 0x0002a400000e0000ULL,
0x0000000817277810ULL, 0x002fe20007ffe0ffULL, 0x000132c27f007947ULL, 0x000fea000b800000ULL,
0x0000001017157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001817277810ULL, 0x002fe20007ffe0ffULL,
0x000133127f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000212257824ULL, 0x040fe200078e00ffULL,
0x0000000811187812ULL, 0x000fe200078ec0ffULL, 0x0000000412207824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000400121b7824ULL, 0x040fe200078e00ffULL,
0x00000004251e7812ULL, 0x000fe200078ec0ffULL, 0x00001000121c7824ULL, 0x000fe200078e00ffULL,
0x0000000718177812ULL, 0x000fe200078ef811ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000001e111a7211ULL, 0x000fc400078fe0ffULL, 0x0000000420207812ULL, 0x000fe200078ec0ffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0xfffff0001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000117187824ULL, 0x000fe200078e021aULL, 0x0000002011207211ULL, 0x000fe200078fe0ffULL,
0x0000000817277824ULL, 0x002fe200078e00ffULL, 0x0000a0001b217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff819187812ULL, 0x000fe400078ee218ULL, 0x0000001017197812ULL, 0x000fc400078efcffULL,
0xffffe0001c1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001171c7824ULL, 0x000fe400078e0220ULL,
0x000000011a1a7824ULL, 0x000fe200078e0219ULL, 0x0000e0001d1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8271b7812ULL, 0x000fe200078ee21cULL,
0x0000001018747824ULL, 0x000fc600078e0221ULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL,
0x000000101b807824ULL, 0x000fe400078e021dULL, 0x000000007474783bULL, 0x000e640000000200ULL,
0x000000101a707824ULL, 0x000fcc00078e0221ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001374747232ULL, 0x086fe40000000000ULL,
0x0000001376767232ULL, 0x000fe40000000000ULL, 0x0000001475757232ULL, 0x088fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x080fe40000000000ULL,
0x0000001572727232ULL, 0x000fc40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000021c1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000008080783bULL, 0x000ee20000004200ULL, 0x000000021e1e7812ULL, 0x000fe200078efcffULL,
0x000008e000007945ULL, 0x000fe20003800000ULL, 0xfffffff81f1c7812ULL, 0x000fe400078ee21cULL,
0x0000001e111e7211ULL, 0x000fc600078fe0ffULL, 0x000000101c7c7824ULL, 0x000fcc00078e021dULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x00000018ff1d7819ULL, 0x008fe40000011480ULL,
0x00000018ff1f7819ULL, 0x000fe40000011481ULL, 0x0000001d002a7306ULL, 0x0007e20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011483ULL, 0x00000018ff267819ULL, 0x000fca0000011482ULL,
0x0000001f006d7306ULL, 0x0003e20000200c00ULL, 0x00008880801d7816ULL, 0x048fe200000000ffULL,
0x000001007d917824ULL, 0x004fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe2000001147cULL,
0x000001007f977824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001147dULL,
0x00000018ff6c7819ULL, 0x000fe2000001147eULL, 0x00000029008f7306ULL, 0x0005e20000200c00ULL,
0x00000100801f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe2000001147fULL,
0x0001000080807824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fc40000011491ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000002b00937306ULL, 0x0003e20000200c00ULL,
0x0000010081297824ULL, 0x004fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x00000018ff977819ULL, 0x000fc80000011497ULL, 0x0000006c00987306ULL, 0x000fe20000200c00ULL,
0x00000018ff2b7819ULL, 0x002fce0000011429ULL, 0x00000027008d7306ULL, 0x0003f00000200c00ULL,
0x0000002b006c7306ULL, 0x0005e20000200c00ULL, 0x0000888081277816ULL, 0x042fe200000000ffULL,
0x0001000081817824ULL, 0x000fca00078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000008000297306ULL, 0x0002e20000200c00ULL, 0x00008880832b7816ULL, 0x004fce00000000ffULL,
0x0000002b008b7306ULL, 0x0005e20000200c00ULL, 0x0000010083807824ULL, 0x042fe400078e00ffULL,
0x0001000083837824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x0000002600897306ULL, 0x000fe20000200c00ULL, 0x000001007c2b7824ULL, 0x004fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00005410292a7816ULL, 0x008fe4000000002aULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000087009b7306ULL, 0x0003f00000200c00ULL,
0x0000001d001d7306ULL, 0x000fe20000200c00ULL, 0x0000010082877824ULL, 0x002fca00078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011487ULL, 0x0000001f00267306ULL, 0x0002b00000200c00ULL,
0x00000081008a7306ULL, 0x0006a20000200c00ULL, 0x00008880821f7816ULL, 0x042fe200000000ffULL,
0x0001000082827824ULL, 0x000fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x000088807c817816ULL, 0x048fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fe200078e00ffULL, 0x000054101d267816ULL, 0x004fc80000000026ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x00000083008e7306ULL, 0x0005f00000200c00ULL,
0x0000002b00907306ULL, 0x0007e20000200c00ULL, 0x000001007e837824ULL, 0x004fca00078e00ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00000087008c7306ULL, 0x0005e20000200c00ULL,
0x000088807e2b7816ULL, 0x048fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000009100927306ULL, 0x0007e20000200c00ULL,
0x000088807d877816ULL, 0x044fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x0000002700277306ULL, 0x000ea20000200c00ULL,
0x000088807f917816ULL, 0x048fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000002b00957306ULL, 0x0007f00000200c00ULL,
0x0000007e001d7306ULL, 0x000ea20000200c00ULL, 0x000054108a2b7816ULL, 0x008fc4000000006dULL,
0x000054108b6d7816ULL, 0x002fe40000000080ULL, 0x0000541027277816ULL, 0x004fc6000000006cULL,
0x0000001f001f7306ULL, 0x000e620000200c00ULL, 0x0000002a7430723cULL, 0x080f6e0000001830ULL,
0x0000009100997306ULL, 0x000fe20000200c00ULL, 0x000054101d987816ULL, 0x000fe20000000098ULL,
0x0000002a7050723cULL, 0x000b620000001850ULL, 0x00000001171d7824ULL, 0x000fc400078e021eULL,
0x00000001191e7824ULL, 0x000fc600078e021eULL, 0x00000097009a7306ULL, 0x000ea20000200c00ULL,
0x000054101f6c7816ULL, 0x002fe2000000008cULL, 0x00000008172a7824ULL, 0x020fe200078e00ffULL,
0x00000026742c723cULL, 0x000f62000000182cULL, 0x00000008191f7824ULL, 0x000fc600078e00ffULL,
0xfffffff82a1d7812ULL, 0x000fe200078ee21dULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0xfffffff81f1e7812ULL, 0x000fe400078ee21eULL, 0x00000026704c723cULL, 0x000b62000000184cULL,
0x0000e0000c1f7811ULL, 0x000fc800078e68ffULL, 0x0000008100817306ULL, 0x000ee20000200c00ULL,
0x0000541099977816ULL, 0x004fe2000000009aULL, 0x0000000119267824ULL, 0x060fe200078e0220ULL,
0x0000006c7434723cULL, 0x000f620000001834ULL, 0x0000000819277824ULL, 0x000fc800078e00ffULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x0000541082827816ULL, 0x002fe40000000089ULL,
0xfffffff827207812ULL, 0x000fe200078ee226ULL, 0x0000006c7054723cULL, 0x000f680000001854ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x0000541081907816ULL, 0x008fce0000000090ULL,
0x0000007d00947306ULL, 0x000ee20000200c00ULL, 0x0000541087917816ULL, 0x004fce0000000092ULL,
0x0000008300967306ULL, 0x0004e20000200c00ULL, 0x000054107c7c7816ULL, 0x002fe2000000008fULL,
0x00000090743c723cULL, 0x080f6c000000183cULL, 0x0000007f00807306ULL, 0x000e620000200c00ULL,
0x000054108e837816ULL, 0x004fe2000000008dULL, 0x00000090705c723cULL, 0x000f62000000185cULL,
0x00005410947d7816ULL, 0x008fc40000000093ULL, 0x0000541095967816ULL, 0x000fca0000000096ULL,
0x000000827438723cULL, 0x000f620000001838ULL, 0x0000541080997816ULL, 0x002fe2000000009bULL,
0x0000001020807824ULL, 0x000fcc00078e021fULL, 0x0000007c7440723cULL, 0x040f700000001840ULL,
0x000000967444723cULL, 0x040f700000001844ULL, 0x000000987448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0221ULL, 0x000000827058723cULL, 0x000f620000001858ULL,
0x000000101e217824ULL, 0x000fc800078e0221ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x0000007c7060723cULL, 0x040f700000001860ULL, 0x000000967064723cULL, 0x040f700000001864ULL,
0x000000987068723cULL, 0x000b640000001868ULL, 0x000000002170783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000001374747232ULL, 0x082fe40000000000ULL, 0x0000001376767232ULL, 0x000fc40000000000ULL,
0x0000001475757232ULL, 0x080fe40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x088fe40000000000ULL, 0x0000001572727232ULL, 0x000fe40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008192a7824ULL, 0x000fe200078e00ffULL,
0x0000000226217810ULL, 0x004fe20007ffe0ffULL, 0x000000008080783bULL, 0x000ea20000004200ULL,
0xfffffff825257812ULL, 0x000fc400078ec0ffULL, 0xfffffff82a217812ULL, 0x000fca00078ee221ULL,
0x00000010217c7824ULL, 0x000fcc00078e021fULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000018ff267819ULL, 0x004fe40000011480ULL, 0x00000018ff277819ULL, 0x000fe40000011481ULL,
0x00000026002a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff297819ULL, 0x000fe40000011482ULL,
0x00000018ff2b7819ULL, 0x000fe40000011483ULL, 0x00008880838d7816ULL, 0x000fc600000000ffULL,
0x00000027006d7306ULL, 0x0003e20000200c00ULL, 0x0000888080267816ULL, 0x004fe200000000ffULL,
0x000001007d927824ULL, 0x008fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001147cULL,
0x000001007e957824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe2000001147eULL,
0x000001007f997824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001147fULL,
0x00000029008b7306ULL, 0x0005e20000200c00ULL, 0x0000010080277824ULL, 0x042fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001147dULL, 0x0001000080807824ULL, 0x000fe200078e00ffULL,
0x000088807d917816ULL, 0x040fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000010081297824ULL, 0x004fe200078e00ffULL, 0x0000006c008f7306ULL, 0x0003e20000200c00ULL,
0x000088807f977816ULL, 0x040fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe40000011492ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x00000018ff957819ULL, 0x000fe20000011495ULL, 0x0000008900987306ULL, 0x0005e20000200c00ULL,
0x00000018ff6c7819ULL, 0x002fc40000011429ULL, 0x00000018ff997819ULL, 0x000fe40000011499ULL,
0x00000018ff7f7819ULL, 0x000fc6000001147fULL, 0x0000002b008e7306ULL, 0x0003e20000200c00ULL,
0x0000010082897824ULL, 0x004fca00078e00ffULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x0000008000297306ULL, 0x0004e20000200c00ULL, 0x00008880812b7816ULL, 0x042fe200000000ffULL,
0x0001000081817824ULL, 0x000fca00078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x00000089008c7306ULL, 0x0003e20000200c00ULL, 0x0000010083807824ULL, 0x044fe400078e00ffULL,
0x0001000083837824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x0000002600267306ULL, 0x000fe20000200c00ULL, 0x000001007c897824ULL, 0x002fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00005410292a7816ULL, 0x008fe4000000002aULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x0000002700277306ULL, 0x000e700000200c00ULL,
0x0000008a009b7306ULL, 0x000ff00000200c00ULL, 0x0000002b002b7306ULL, 0x000fe20000200c00ULL,
0x0000541026267816ULL, 0x002fce0000000027ULL, 0x0000006c006c7306ULL, 0x000e700000200c00ULL,
0x00000081008a7306ULL, 0x0004f00000200c00ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000088807c817816ULL, 0x044fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x000054102b277816ULL, 0x002fc8000000006cULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x000054108a2b7816ULL, 0x008fe2000000006dULL,
0x00000026742c723cULL, 0x040f6c000000182cULL, 0x0000008700937306ULL, 0x0005e40000200c00ULL,
0x0000002a7430723cULL, 0x000f6c0000001830ULL, 0x0000008900907306ULL, 0x0007e20000200c00ULL,
0x0000888082877816ULL, 0x044fe200000000ffULL, 0x0001000082827824ULL, 0x000fe200078e00ffULL,
0x000054108d6d7816ULL, 0x002fe20000000080ULL, 0x00000026704c723cULL, 0x000f66000000184cULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000008300837306ULL, 0x000e620000200c00ULL,
0x000088807e897816ULL, 0x048fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fc400078e00ffULL,
0x0000002a7050723cULL, 0x000f660000001850ULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008200827306ULL, 0x000eb00000200c00ULL, 0x0000008100817306ULL, 0x000ee20000200c00ULL,
0x0000541083837816ULL, 0x002fce000000008eULL, 0x0000009100917306ULL, 0x000fe20000200c00ULL,
0x0000541082827816ULL, 0x004fce000000008bULL, 0x0000009200927306ULL, 0x000e620000200c00ULL,
0x0000541081907816ULL, 0x008fe20000000090ULL, 0x000000827438723cULL, 0x080f6c0000001838ULL,
0x0000007c007c7306ULL, 0x000ea40000200c00ULL, 0x000000827058723cULL, 0x000f6c0000001858ULL,
0x0000007d00947306ULL, 0x000ee20000200c00ULL, 0x0000541091917816ULL, 0x002fce0000000092ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x000054107c7c7816ULL, 0x004fe2000000008fULL,
0x00000090743c723cULL, 0x080f6c000000183cULL, 0x0000009500967306ULL, 0x000e620000200c00ULL,
0x00005410947d7816ULL, 0x008fe20000000093ULL, 0x00000090705c723cULL, 0x000f6c000000185cULL,
0x0000009700977306ULL, 0x000fe40000200c00ULL, 0x0000007c7440723cULL, 0x080f6c0000001840ULL,
0x00000099009a7306ULL, 0x000ea20000200c00ULL, 0x0000541089967816ULL, 0x002fe20000000096ULL,
0x0000007c7060723cULL, 0x000f6c0000001860ULL, 0x0000007e00297306ULL, 0x000e700000200c00ULL,
0x0000007f00807306ULL, 0x000ee20000200c00ULL, 0x0000541097977816ULL, 0x004fc4000000009aULL,
0x0000541029987816ULL, 0x002fca0000000098ULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x000000967444723cULL, 0x000f620000001844ULL, 0x0000541080997816ULL, 0x008fce000000009bULL,
0x000000967064723cULL, 0x000f620000001864ULL, 0x00005410876c7816ULL, 0x002fce000000008cULL,
0x000000987448723cULL, 0x080f700000001848ULL, 0x000000987068723cULL, 0x000f700000001868ULL,
0x0000006c7434723cULL, 0x080f700000001834ULL, 0x0000006c7054723cULL, 0x000b6e0000001854ULL,
0x000126c80c6c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006c6c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126880025ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff297224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x000fc80000015200ULL, 0x0000040005257984ULL, 0x004ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a262a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e27ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001142bULL,
0x0000002a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000225257819ULL, 0x000fc8000000122aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040005257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001012267824ULL, 0x000fca00078e00ffULL, 0xffffffe026257812ULL, 0x000fca00078ec0ffULL,
0x0000010008257824ULL, 0x000fca00078e0225ULL, 0x0000008025277810ULL, 0x000fe20007ffe0ffULL,
0x0000590022257a24ULL, 0x010fc600078e02ffULL, 0x0000002027227812ULL, 0x000fe200078ec0ffULL,
0x0000004025297824ULL, 0x000fc800078e00ffULL, 0x000000010b707824ULL, 0x000fe200078e0222ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000002710227217ULL, 0x000fe40007800000ULL,
0x0000001026257812ULL, 0x000fe400078ec0ffULL, 0x00000003ff267819ULL, 0x000fe20000011611ULL,
0x0000000122227824ULL, 0x000fc600078e0a27ULL, 0x00000004262b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126277824ULL, 0x040fe200078e0225ULL, 0x0000002225227217ULL, 0x000fe40007800000ULL,
0x00000008266c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001272a7824ULL, 0x040fe400078e0211ULL,
0x00000008276d7824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x000fc600078e0a25ULL,
0xfffffff86d727812ULL, 0x000fe200078ee22aULL, 0x000000012b2a7824ULL, 0x100fe200078e0225ULL,
0x0000000c266d7810ULL, 0x040fe40007ffe0ffULL, 0x000000222600720cULL, 0x080fe20003f86070ULL,
0x0000000127267824ULL, 0x000fe200078e0270ULL, 0x000000226c00720cULL, 0x0c0fe20003f46070ULL,
0x000000016c6c7824ULL, 0x100fe200078e0225ULL, 0x000000222b00720cULL, 0x080fe20003f66070ULL,
0x000000016d737824ULL, 0x040fe200078e0225ULL, 0x000000226d00720cULL, 0x000fe20003f06070ULL,
0x000000012a257824ULL, 0x000fc400078e0211ULL, 0x000000082a747824ULL, 0x000fe400078e00ffULL,
0x000000016c2b7824ULL, 0x040fe400078e0211ULL, 0x000000086c767824ULL, 0x000fe200078e00ffULL,
0xfffffff874227812ULL, 0x000fe200078ee225ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620029257a11ULL, 0x040fe400078a38ffULL, 0xfffffff876747812ULL, 0x000fe200078ee22bULL,
0x000000012a2a7824ULL, 0x100fe200078e0270ULL, 0x0000000326267212ULL, 0x000fe200078efcffULL,
0x000000016c6c7824ULL, 0x000fe200078e0270ULL, 0x0000630029297a11ULL, 0x000fe200028f3cffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000002625267210ULL, 0x000fc60007fbe0ffULL,
0x0000000173707824ULL, 0x000fe200078e0270ULL, 0x000000032a2a7212ULL, 0x000fe200078efcffULL,
0x000000806c6c7825ULL, 0x000fc800078e00ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000036c6c7212ULL, 0x000fc600078efcffULL, 0x0000000127277824ULL, 0x000fe200028e0629ULL,
0x000000252a2a7210ULL, 0x000fe20007fbe0ffULL, 0x0000000173757824ULL, 0x040fe200078e0211ULL,
0x0000000370707212ULL, 0x000fe200078efcffULL, 0x0000000873767824ULL, 0x000fe400078e00ffULL,
0x000000012b2b7824ULL, 0x000fe200028e0629ULL, 0x000000256c6c7210ULL, 0x080fe20007fbe0ffULL,
0x0000001074737824ULL, 0x100fe200078e021fULL, 0x0000002570707210ULL, 0x000fe20007fde0ffULL,
0x0000001072257824ULL, 0x000fe200078e021fULL, 0xfffffff876767812ULL, 0x000fe200078ee275ULL,
0x000000016d6d7824ULL, 0x000fc400028e0629ULL, 0x0000000171717824ULL, 0x000fe200030e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000e101c48ULL,
0x0000001022297824ULL, 0x100fe400078e021fULL, 0x0000001076757824ULL, 0x000fc600078e021fULL,
0x000000002a297faeULL, 0x0003e8000d901c48ULL, 0x000000006c737faeULL, 0x0003e8000d101c48ULL,
0x0000000070757faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001026267812ULL, 0x000fc800078ec0ffULL, 0x0000002611227211ULL, 0x000fc800078fe8ffULL,
0x0000000422277810ULL, 0x040fe20007ffe0ffULL, 0x0000000122257824ULL, 0x040fe200078e0211ULL,
0x0000000c226d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000822727824ULL, 0x040fe400078e00ffULL,
0x0000000122267824ULL, 0x100fe400078e0270ULL, 0x00000001272a7824ULL, 0x000fe200078e0270ULL,
0xfffffff872727812ULL, 0x000fe200078ee225ULL, 0x000000086d767824ULL, 0x000fe200078e00ffULL,
0x0000000822257810ULL, 0x000fe20007ffe0ffULL, 0x0000000127227824ULL, 0x000fc400078e0211ULL,
0x0000000827277824ULL, 0x000fe400078e00ffULL, 0x00000001256c7824ULL, 0x040fe400078e0270ULL,
0x00000001252b7824ULL, 0x100fe200078e0211ULL, 0xfffffff827227812ULL, 0x000fe200078ee222ULL,
0x0000000825747824ULL, 0x000fe400078e00ffULL, 0x000000016d257824ULL, 0x000fe400078e0211ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fc400078ee22bULL,
0xfffffff876767812ULL, 0x000fe200078ee225ULL, 0x000000016d707824ULL, 0x000fe200078e0270ULL,
0x0000620029257a11ULL, 0x040fe200078038ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000000326267212ULL, 0x080fe400078efcffULL, 0x0000630029297a11ULL, 0x000fe200000f3cffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000002625267210ULL, 0x000fe40007f1e0ffULL,
0x000000032a2a7212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000036c6c7212ULL, 0x000fc400078efcffULL, 0x0000002a252a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x000fe200000e0629ULL, 0x0000000370707212ULL, 0x000fe200078efcffULL,
0x0000001074737824ULL, 0x000fe200078e021fULL, 0x0000006c256c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012b2b7824ULL, 0x000fe200010e0629ULL, 0x0000007025707210ULL, 0x000fe20007f7e0ffULL,
0x0000001072257824ULL, 0x000fe400078e021fULL, 0x000000016d6d7824ULL, 0x100fe400000e0629ULL,
0x0000000171717824ULL, 0x000fe200018e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000b901c48ULL, 0x0000001022297824ULL, 0x000fc400078e021fULL,
0x0000001076757824ULL, 0x000fc600078e021fULL, 0x000000002a297faeULL, 0x0003e8000b901c48ULL,
0x000000006c737faeULL, 0x0003e8000b901c48ULL, 0x0000000070757faeULL, 0x0003e4000b901c48ULL,
0x00000000280473c2ULL, 0x000ea200000e0000ULL, 0x000000020a267810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000000f2600720cULL, 0x000fda0003f06070ULL,
0x0000000109268824ULL, 0x000fe400078e0226ULL, 0x00000004ff278424ULL, 0x000fe200078e00ffULL,
0xfffffff004047892ULL, 0x004fc6000f8ec03fULL, 0x0000640026268625ULL, 0x000fe200078e0027ULL,
0x000126a804057890ULL, 0x000fc8000fffe03fULL, 0x0000000826228981ULL, 0x000328000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126a800ff2a7f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01262800046c7f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x002fc40000015200ULL,
0x01262c0004257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01262c0004257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002012257824ULL, 0x000fca00078e00ffULL, 0xffffff8025267812ULL, 0x000fc800078ec0ffULL,
0x0000008003257810ULL, 0x000fca0007ffe026ULL, 0x0000000102257824ULL, 0x000fca00078e0225ULL,
0x0120000025287984ULL, 0x000e680000000800ULL, 0x0122000025297984ULL, 0x0006a20000000800ULL,
0x000000232800720bULL, 0x002fe20003f1d000ULL, 0x000111327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000707806ULL, 0x008fc800000e0100ULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fd600078e00ffULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x000000010d257810ULL, 0x000fe40007ffe0ffULL,
0x000000232800720bULL, 0x000fe40003f54000ULL, 0x000000122500720cULL, 0x000fe20003f05270ULL,
0x000110f27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000717806ULL, 0x000fc400010e0100ULL,
0x0000008012278824ULL, 0x000fe200078e0203ULL, 0x0000002328258209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000102268824ULL, 0x000fca00078e0227ULL,
0x0124002526008388ULL, 0x0003e20000000800ULL, 0x000000ff7100720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002328267209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff71ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002326257221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500737308ULL, 0x000e640000000800ULL, 0x0000007324247220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe20000011611ULL,
0x000110227f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002644447220ULL, 0x080fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000811277811ULL, 0x002fe200078ff0ffULL, 0x00010ef27f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x0000002646467220ULL, 0x080fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001011277811ULL, 0x002fe200078ff0ffULL,
0x00010dc27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x0000002664647220ULL, 0x080fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002668687220ULL, 0x080fe20000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000071ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001811277811ULL, 0x002fe200078ff0ffULL,
0x00010ca27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x0000002666667220ULL, 0x080fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x000000266a6a7220ULL, 0x080fe20000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007170ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fe200078e00ffULL, 0x0000002328237209ULL, 0x000fd60007810000ULL,
0x8000002328280221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800000308ULL, 0x000e640000000800ULL,
0x0000000029290220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002429247221ULL, 0x004fc20000010000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000000812287824ULL, 0x000fca00078e00ffULL, 0xfffffff0286c7812ULL, 0x000fca00078ec0ffULL,
0x0126b4006c297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028266d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09006d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000006d28287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4006c297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025257816ULL, 0x000fc800000000ffULL, 0x000000ff2500720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff297819ULL, 0x000fe40000011611ULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x000108627f007947ULL, 0x000fea000b800000ULL, 0x00001f2916137589ULL, 0x0002a400000e0000ULL,
0x0000000829277810ULL, 0x002fe20007ffe0ffULL, 0x000108927f007947ULL, 0x000fea000b800000ULL,
0x0000001029157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001829277810ULL, 0x002fe20007ffe0ffULL,
0x000108e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000040012257824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100012267824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00025257812ULL, 0x000fc400078ec0ffULL, 0xffffe00026267812ULL, 0x000fe400078ec0ffULL,
0x0000b00025257810ULL, 0x000fe40007ffe0ffULL, 0x0000f00026267810ULL, 0x000fc60007ffe0ffULL,
0x0000001018707824ULL, 0x100fe400078e0225ULL, 0x000000101a6c7824ULL, 0x000fe400078e0225ULL,
0x000000101b7c7824ULL, 0x000fe400078e0226ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000006c6c783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001370707232ULL, 0x086fe40000000000ULL, 0x0000001372727232ULL, 0x000fc40000000000ULL,
0x0000001471717232ULL, 0x088fe40000000000ULL, 0x0000001473737232ULL, 0x000fe40000000000ULL,
0x000000156c6c7232ULL, 0x080fe40000000000ULL, 0x000000156e6e7232ULL, 0x000fe40000000000ULL,
0x000000166d6d7232ULL, 0x080fe40000000000ULL, 0x000000166f6f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x000000101c747824ULL, 0x000fe200078e0226ULL, 0x0000082000007945ULL, 0x000fea0003800000ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x00000018ff267819ULL, 0x008fc4000001147cULL,
0x00000018ff277819ULL, 0x002fe4000001147dULL, 0x0000002600287306ULL, 0x0003e20000200c00ULL,
0x00000018ff297819ULL, 0x000fe4000001147eULL, 0x00000018ff807819ULL, 0x000fe2000001147fULL,
0x00000100748d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011474ULL,
0x0000010075917824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011476ULL,
0x0000002700827306ULL, 0x0005e20000200c00ULL, 0x000088807c267816ULL, 0x002fe200000000ffULL,
0x0000010076957824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fc40000011477ULL,
0x000088807f8b7816ULL, 0x000fe400000000ffULL, 0x00000018ff837819ULL, 0x000fe20000011475ULL,
0x0000002900897306ULL, 0x0003e20000200c00ULL, 0x000001007c277824ULL, 0x044fe200078e00ffULL,
0x00008880758f7816ULL, 0x040fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001148dULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000080008c7306ULL, 0x0005e20000200c00ULL,
0x000001007d297824ULL, 0x002fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff927819ULL, 0x000fe40000011491ULL,
0x0000008100907306ULL, 0x0003e20000200c00ULL, 0x000088807d807816ULL, 0x044fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0x0000888077977816ULL, 0x000fe400000000ffULL,
0x00000018ff957819ULL, 0x000fe40000011495ULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000008700987306ULL, 0x0005e20000200c00ULL, 0x00000018ff817819ULL, 0x002fce0000011429ULL,
0x0000007c00297306ULL, 0x0002e20000200c00ULL, 0x000001007e877824ULL, 0x004fca00078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011487ULL, 0x0000008a00997306ULL, 0x000fe20000200c00ULL,
0x000001007f7c7824ULL, 0x042fe400078e00ffULL, 0x000100007f7f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d007d7306ULL, 0x000e620000200c00ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000541029287816ULL, 0x008fca0000000028ULL,
0x00000087008a7306ULL, 0x0005f00000200c00ULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x0000888074877816ULL, 0x044fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x000054107d297816ULL, 0x002fc80000000082ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000002700277306ULL, 0x000e640000200c00ULL, 0x000000287030723cULL, 0x080f6c0000001830ULL,
0x0000008000807306ULL, 0x000fe40000200c00ULL, 0x000000286c50723cULL, 0x000b6c0000001850ULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x0000541026267816ULL, 0x002fc40000000027ULL,
0x000010001f287810ULL, 0x020fca0007ffe0ffULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000001020297824ULL, 0x000fce00078e0228ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x0000541080277816ULL, 0x004fce0000000081ULL, 0x0000008300937306ULL, 0x0003e20000200c00ULL,
0x00000026702c723cULL, 0x080f6e000000182cULL, 0x0000008d008e7306ULL, 0x0005e20000200c00ULL,
0x000088807e837816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x000000266c4c723cULL, 0x000f68000000184cULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000007400917306ULL, 0x0002e20000200c00ULL, 0x00008880768d7816ULL, 0x044fe200000000ffULL,
0x0001000076767824ULL, 0x000fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000007500947306ULL, 0x0004e20000200c00ULL, 0x0000010077747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0001000077757824ULL, 0x004fe200078e00ffULL, 0x0000541091907816ULL, 0x008fc80000000090ULL,
0x00000018ff7d7819ULL, 0x000fe40000011475ULL, 0x000054108b757816ULL, 0x000fe2000000007cULL,
0x0000007e007e7306ULL, 0x000e620000200c00ULL, 0x0000541094917816ULL, 0x000fce0000000093ULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x000000907040723cULL, 0x080f6e0000001840ULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x000054107e7e7816ULL, 0x002fe20000000089ULL,
0x000000906c60723cULL, 0x000f6c0000001860ULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x000054107f7f7816ULL, 0x004fce000000008cULL, 0x0000009200927306ULL, 0x000e620000200c00ULL,
0x00005410878e7816ULL, 0x008fe2000000008eULL, 0x0000007e7038723cULL, 0x080f6c0000001838ULL,
0x0000008d008d7306ULL, 0x000fe40000200c00ULL, 0x0000007e6c58723cULL, 0x000f6c0000001858ULL,
0x0000009500967306ULL, 0x000ea20000200c00ULL, 0x000054108f8f7816ULL, 0x002fce0000000092ULL,
0x0000009700977306ULL, 0x000fe20000200c00ULL, 0x0000008e703c723cULL, 0x080f6e000000183cULL,
0x0000007400807306ULL, 0x0002e20000200c00ULL, 0x000054108d967816ULL, 0x004fe20000000096ULL,
0x0000008e6c5c723cULL, 0x000f6c000000185cULL, 0x0000007600777306ULL, 0x000ea20000200c00ULL,
0x0000541083747816ULL, 0x002fce000000008aULL, 0x0000007d007c7306ULL, 0x000e620000200c00ULL,
0x0000541097977816ULL, 0x008fe20000000080ULL, 0x000000747034723cULL, 0x000f620000001834ULL,
0x0000541077987816ULL, 0x004fce0000000098ULL, 0x000000967044723cULL, 0x000f620000001844ULL,
0x000054107c997816ULL, 0x002fce0000000099ULL, 0x000000746c54723cULL, 0x000f700000001854ULL,
0x000000987048723cULL, 0x000b6e0000001848ULL, 0x000000101d707824ULL, 0x120fe200078e0225ULL,
0x000000966c64723cULL, 0x000f620000001864ULL, 0x000000101e257824ULL, 0x000fc800078e0225ULL,
0x000000007070783bULL, 0x000e660000000200ULL, 0x000000986c68723cULL, 0x000b640000001868ULL,
0x00000000256c783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001370707232ULL, 0x082fe40000000000ULL,
0x0000001372727232ULL, 0x000fe40000000000ULL, 0x0000001471717232ULL, 0x000fc40000000000ULL,
0x0000001473737232ULL, 0x000fe40000000000ULL, 0x000000156c6c7232ULL, 0x088fe40000000000ULL,
0x000000156e6e7232ULL, 0x000fe40000000000ULL, 0x000000166d6d7232ULL, 0x080fe40000000000ULL,
0x000000166f6f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001021747824ULL, 0x000fe200078e0228ULL, 0x00000000297c783bULL, 0x000eaa0000004200ULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x00000018ff257819ULL, 0x004fe2000001147cULL,
0x000001007e8b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc4000001147dULL,
0x0000002500807306ULL, 0x0005e20000200c00ULL, 0x00000018ff837819ULL, 0x008fe20000011475ULL,
0x0000010075927824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001147fULL,
0x0000010076977824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe4000001147eULL,
0x00000018ff8a7819ULL, 0x000fe20000011477ULL, 0x0000002600877306ULL, 0x0007e20000200c00ULL,
0x000088807c257816ULL, 0x004fe400000000ffULL, 0x00000018ff8b7819ULL, 0x000fc4000001148bULL,
0x00000018ff827819ULL, 0x000fe40000011474ULL, 0x00000018ff897819ULL, 0x000fe20000011476ULL,
0x0000008300957306ULL, 0x0005e20000200c00ULL, 0x000001007c267824ULL, 0x048fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011492ULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x0000888075917816ULL, 0x040fe200000000ffULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000081008e7306ULL, 0x0007e20000200c00ULL,
0x000100007d837824ULL, 0x004fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000027008d7306ULL, 0x0005e20000200c00ULL, 0x000001007d817824ULL, 0x008fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fc80000011497ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x0000008a009b7306ULL, 0x000fe20000200c00ULL, 0x000088807d277816ULL, 0x004fce00000000ffULL,
0x0000007c007d7306ULL, 0x0005f00000200c00ULL, 0x00000083008a7306ULL, 0x0007e20000200c00ULL,
0x000001007f7c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000008b008c7306ULL, 0x0005e20000200c00ULL, 0x0000888074837816ULL, 0x008fce00000000ffULL,
0x00000082008f7306ULL, 0x000fe20000200c00ULL, 0x00000100748b7824ULL, 0x044fe400078e00ffULL,
0x0001000074747824ULL, 0x000fc600078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001148bULL,
0x0000008100827306ULL, 0x0005e20000200c00ULL, 0x00000018ff747819ULL, 0x000fce0000011474ULL,
0x0000002700277306ULL, 0x000ee20000200c00ULL, 0x000088807f817816ULL, 0x044fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000002500257306ULL, 0x000ff00000200c00ULL, 0x0000002600267306ULL, 0x000ea20000200c00ULL,
0x0000541027277816ULL, 0x008fce0000000082ULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000541025267816ULL, 0x004fce0000000026ULL,
0x0000007400927306ULL, 0x0004e20000200c00ULL, 0x00000026702c723cULL, 0x082f6e000000182cULL,
0x00000089009a7306ULL, 0x0003e20000200c00ULL, 0x0000010077747824ULL, 0x004fe200078e00ffULL,
0x000000266c4c723cULL, 0x000b68000000184cULL, 0x00000018ff747819ULL, 0x000fc40000011474ULL,
0x0000008b00907306ULL, 0x0005e20000200c00ULL, 0x000088807e897816ULL, 0x042fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fe200078e00ffULL, 0x0000541092927816ULL, 0x008fc8000000008fULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000009300947306ULL, 0x0003e20000200c00ULL,
0x00008880768b7816ULL, 0x044fe200000000ffULL, 0x0001000076767824ULL, 0x000fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000007400827306ULL, 0x0005e20000200c00ULL,
0x0000888077937816ULL, 0x042fe200000000ffULL, 0x0001000077777824ULL, 0x000fcc00078e00ffULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x000054107d747816ULL, 0x004fe40000000080ULL,
0x00000018ff7d7819ULL, 0x000fe40000011477ULL, 0x0000541081777816ULL, 0x000fc6000000007cULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000007f007f7306ULL, 0x000eb00000200c00ULL,
0x0000008300837306ULL, 0x000ee20000200c00ULL, 0x000054107e7e7816ULL, 0x002fce000000008dULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x000054107f7f7816ULL, 0x004fce000000008eULL,
0x0000007500967306ULL, 0x0004620000200c00ULL, 0x0000541083907816ULL, 0x008fe20000000090ULL,
0x0000007e7038723cULL, 0x080f6c0000001838ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000054108a757816ULL, 0x004fe20000000087ULL, 0x0000007e6c58723cULL, 0x000f620000001858ULL,
0x0000541091917816ULL, 0x002fca0000000094ULL, 0x0000009700987306ULL, 0x000e640000200c00ULL,
0x000000747030723cULL, 0x040f6c0000001830ULL, 0x0000009300997306ULL, 0x0004e40000200c00ULL,
0x00000090703c723cULL, 0x000f6c000000183cULL, 0x0000007600257306ULL, 0x0006e20000200c00ULL,
0x0000541096937816ULL, 0x004fe20000000095ULL, 0x000000746c50723cULL, 0x000f620000001850ULL,
0x000054108b987816ULL, 0x002fca0000000098ULL, 0x0000007d007c7306ULL, 0x000e620000200c00ULL,
0x0000541089767816ULL, 0x008fe2000000008cULL, 0x000000927040723cULL, 0x000f620000001840ULL,
0x0000541099997816ULL, 0x000fe40000000082ULL, 0x00005410259a7816ULL, 0x000fe2000000009aULL,
0x0000000212257824ULL, 0x000fc800078e00ffULL, 0x000000767034723cULL, 0x000f640000001834ULL,
0xfffffff825267812ULL, 0x020fe400078ec0ffULL, 0x000054107c9b7816ULL, 0x002fc8000000009bULL,
0x000000987044723cULL, 0x040f700000001844ULL, 0x0000009a7048723cULL, 0x000f700000001848ULL,
0x000000766c54723cULL, 0x040f700000001854ULL, 0x000000906c5c723cULL, 0x040f70000000185cULL,
0x000000926c60723cULL, 0x040f700000001860ULL, 0x000000986c64723cULL, 0x040f700000001864ULL,
0x0000009a6c68723cULL, 0x000b6e0000001868ULL, 0x000126c80c6e7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006e6e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126900026ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff257224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x004fc80000015200ULL,
0x00000400056d7984ULL, 0x000ea40000000800ULL, 0x800000006dff7812ULL, 0x006fc4000780486fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c26717210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff6c7819ULL, 0x000fc8000001146dULL, 0x000000716c6c7211ULL, 0x000fca00078110ffULL,
0x000000ffff6d7224ULL, 0x000fca00000e066dULL, 0x000000026c6c7819ULL, 0x000fc8000000126dULL,
0x0000006c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400056d7984ULL, 0x000e640000000800ULL, 0x800000006dff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001012267824ULL, 0x000fca00078e00ffULL,
0xffffffe026257812ULL, 0x000fca00078ec0ffULL, 0x0000010008257824ULL, 0x000fca00078e0225ULL,
0x000000c025277810ULL, 0x000fe20007ffe0ffULL, 0x0000590022257a24ULL, 0x010fc600078e02ffULL,
0x0000002027227812ULL, 0x000fe200078ec0ffULL, 0x0000004025737824ULL, 0x000fc800078e00ffULL,
0x000000010b707824ULL, 0x000fe200078e0222ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000002710227217ULL, 0x000fe40007800000ULL, 0x0000001026257812ULL, 0x000fe400078ec0ffULL,
0x00000003ff267819ULL, 0x000fe20000011611ULL, 0x0000000122227824ULL, 0x000fc600078e0a27ULL,
0x00000004266d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000126277824ULL, 0x040fe200078e0225ULL,
0x0000002225227217ULL, 0x000fe40007800000ULL, 0x00000008266e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001276c7824ULL, 0x040fe200078e0211ULL, 0x0000000c266f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000827757824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x100fe400078e0a25ULL,
0x000000016f727824ULL, 0x100fe200078e0225ULL, 0xfffffff875757812ULL, 0x000fe200078ee26cULL,
0x000000016d6c7824ULL, 0x100fe200078e0225ULL, 0x000000222600720cULL, 0x080fe20003f86070ULL,
0x0000000127267824ULL, 0x000fe200078e0270ULL, 0x000000226e00720cULL, 0x0c0fe20003f46070ULL,
0x000000016e6e7824ULL, 0x000fe200078e0225ULL, 0x000000226d00720cULL, 0x080fe20003f66070ULL,
0x000000016c257824ULL, 0x040fe200078e0211ULL, 0x000000226f00720cULL, 0x000fe20003f06070ULL,
0x000000086c747824ULL, 0x000fc400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff874777812ULL, 0x000fe200078ee225ULL, 0x000000016c6c7824ULL, 0x000fe200078e0270ULL,
0x0000620073257a11ULL, 0x040fe200078a38ffULL, 0x000000016e227824ULL, 0x000fe200078e0211ULL,
0x0000000326267212ULL, 0x080fe200078efcffULL, 0x000000086e7d7824ULL, 0x000fe200078e00ffULL,
0x0000630073737a11ULL, 0x000fe200028f3cffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002625267210ULL, 0x000fe40007fbe0ffULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee222ULL,
0x000000016e6e7824ULL, 0x100fe200078e0270ULL, 0x000000036c6c7212ULL, 0x000fe200078efcffULL,
0x0000000172707824ULL, 0x000fc400078e0270ULL, 0x000000806e6e7825ULL, 0x000fc800078e00ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000036e6e7212ULL, 0x000fc600078efcffULL,
0x0000000127277824ULL, 0x000fe200028e0673ULL, 0x000000256c6c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000172227824ULL, 0x000fe200078e0211ULL, 0x0000000370707212ULL, 0x000fe200078efcffULL,
0x00000008727f7824ULL, 0x000fe400078e00ffULL, 0x000000016d6d7824ULL, 0x100fe200028e0673ULL,
0x000000256e6e7210ULL, 0x080fe40007fbe0ffULL, 0x0000002570707210ULL, 0x000fe20007fde0ffULL,
0x0000001075257824ULL, 0x000fe200078e0228ULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee222ULL,
0x000000016f6f7824ULL, 0x000fc400028e0673ULL, 0x0000000171717824ULL, 0x000fe200030e0673ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000e101c48ULL,
0x0000001077737824ULL, 0x100fe400078e0228ULL, 0x000000107d757824ULL, 0x100fe400078e0228ULL,
0x000000107f777824ULL, 0x000fe200078e0228ULL, 0x000000006c737faeULL, 0x0003e8000d901c48ULL,
0x000000006e757faeULL, 0x0003e8000d101c48ULL, 0x0000000070777faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001026267812ULL, 0x000fe400078ec0ffULL,
0x0000620073757a11ULL, 0x000fc400078038ffULL, 0x0000002611227211ULL, 0x000fe400078fe8ffULL,
0x0000630073737a11ULL, 0x000fe400000f3cffULL, 0x0000000422277810ULL, 0x040fe20007ffe0ffULL,
0x0000000122257824ULL, 0x140fe200078e0211ULL, 0x00000008226d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008226c7824ULL, 0x040fe200078e00ffULL, 0x0000000c22717810ULL, 0x040fe20007ffe0ffULL,
0x0000000122267824ULL, 0x100fe400078e0270ULL, 0x0000000127227824ULL, 0x040fe200078e0211ULL,
0xfffffff86c257812ULL, 0x000fe200078ee225ULL, 0x00000001276c7824ULL, 0x000fc400078e0270ULL,
0x0000000827777824ULL, 0x000fe400078e00ffULL, 0x000000016d6e7824ULL, 0x040fe400078e0270ULL,
0x000000016d6f7824ULL, 0x100fe200078e0211ULL, 0xfffffff877777812ULL, 0x000fe200078ee222ULL,
0x000000086d727824ULL, 0x000fe400078e00ffULL, 0x00000001716d7824ULL, 0x040fe400078e0211ULL,
0x0000000871747824ULL, 0x000fe200078e00ffULL, 0xfffffff8727d7812ULL, 0x000fe200078ee26fULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff8747f7812ULL, 0x000fe200078ee26dULL,
0x0000000171707824ULL, 0x000fe200078e0270ULL, 0x0000000326267212ULL, 0x000fe200078efcffULL,
0x000000806c6c7825ULL, 0x000fc600078e00ffULL, 0x0000002675267210ULL, 0x000fe20007f1e0ffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x000000036c6c7212ULL, 0x000fc600078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000036e6e7212ULL, 0x080fe400078efcffULL,
0x0000006c756c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000127277824ULL, 0x100fe200000e0673ULL,
0x0000000370707212ULL, 0x000fe200078efcffULL, 0x0000001025257824ULL, 0x100fe200078e0228ULL,
0x0000006e756e7210ULL, 0x000fe20007f1e0ffULL, 0x000000016d6d7824ULL, 0x100fe200010e0673ULL,
0x0000007075707210ULL, 0x000fe20007f7e0ffULL, 0x000000107d757824ULL, 0x000fe200078e0228ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000b901c48ULL,
0x000000016f6f7824ULL, 0x000fc400000e0673ULL, 0x0000000171717824ULL, 0x000fe400018e0673ULL,
0x0000001077737824ULL, 0x100fe400078e0228ULL, 0x000000107f777824ULL, 0x000fc600078e0228ULL,
0x000000006c737faeULL, 0x0003e8000b901c48ULL, 0x000000006e757faeULL, 0x0003e8000b901c48ULL,
0x0000000070777faeULL, 0x0003e4000b901c48ULL, 0x0000000812257824ULL, 0x002fe200078e00ffULL,
0x000000030a267810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff025257812ULL, 0x000fe400078ec0ffULL, 0x0000000f2600720cULL, 0x000fe40003f06070ULL,
0x00000000250473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000109268824ULL, 0x000fc400078e0226ULL, 0x00000004ff278424ULL, 0x000fc800078e00ffULL,
0x0000640026268625ULL, 0x000fca00078e0027ULL, 0x0000000826228981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b000256e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480004707f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x01264c0004257984ULL, 0x002e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001146dULL,
0x0000006c25257211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000225257819ULL, 0x000fc8000000126cULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c0004257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002012047824ULL, 0x008fca00078e00ffULL, 0xffffff8004047812ULL, 0x000fc800078ec0ffULL,
0x0000010003257810ULL, 0x000fca0007ffe004ULL, 0x0000000102257824ULL, 0x000fca00078e0225ULL,
0x0120000025707984ULL, 0x000e680000000800ULL, 0x0122000025717984ULL, 0x0006a20000000800ULL,
0x000000237000720bULL, 0x002fe20003f1d000ULL, 0x0000e9227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000727806ULL, 0x008fc800000e0100ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff047224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x000000020d257810ULL, 0x000fe40007ffe0ffULL, 0x000000237000720bULL, 0x000fe40003f54000ULL,
0x000000122500720cULL, 0x000fe20003f05270ULL, 0x0000e8d27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000737806ULL, 0x000fc400010e0100ULL, 0x0000008012258824ULL, 0x000fe200078e0203ULL,
0x0000002370048209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000102258824ULL, 0x000fca00078e0225ULL, 0x0124000425008388ULL, 0x0003e20000000800ULL,
0x000000ff7300720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002370047209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff73ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002304047221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL, 0x0000000400757308ULL, 0x000e640000000800ULL,
0x0000007524247220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe20000011611ULL, 0x0000e8027f007947ULL, 0x000fea000b800000ULL,
0x00001f2775267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002644447220ULL, 0x080fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0073ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000811277811ULL, 0x002fe200078ff0ffULL,
0x0000e6d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2775267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002646467220ULL, 0x080fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000073ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001011277811ULL, 0x002fe200078ff0ffULL, 0x0000e5a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2775267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x0000002664647220ULL, 0x080fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002668687220ULL, 0x080fe20000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000073ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001811277811ULL, 0x002fe200078ff0ffULL, 0x0000e4827f007947ULL, 0x000fea000b800000ULL,
0x00001f2775267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x0000002666667220ULL, 0x080fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x000000266a6a7220ULL, 0x080fe20000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007372ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fe200078e00ffULL,
0x0000002370047209ULL, 0x000fd60007810000ULL, 0x8000000470700221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000000308ULL, 0x000e640000000800ULL, 0x0000000071710220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002471247221ULL, 0x004fc20000010000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000000812237824ULL, 0x000fca00078e00ffULL,
0xfffffff023707812ULL, 0x000fca00078ec0ffULL, 0x0126ac0070237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001146dULL, 0x0000006c23237211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000223237819ULL, 0x000fc8000000126cULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac0070237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991025237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff13723eULL, 0x000fe400000000ffULL, 0x00000002ff237819ULL, 0x000fe40000011611ULL,
0x0000541013167816ULL, 0x000fe20000000013ULL, 0x0000e0427f007947ULL, 0x000fea000b800000ULL,
0x00001f2316137589ULL, 0x0002a400000e0000ULL, 0x0000000823277810ULL, 0x002fe20007ffe0ffULL,
0x0000e0727f007947ULL, 0x000fea000b800000ULL, 0x0000001023157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2716147589ULL, 0x0002ea00000e0000ULL, 0x00001f1516157589ULL, 0x0002a400000e0000ULL,
0x0000001823277810ULL, 0x002fe20007ffe0ffULL, 0x0000e0c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2716167589ULL, 0x0002e400000e0000ULL, 0x0000040012237824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100012257824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00023237812ULL, 0x000fc400078ec0ffULL,
0xffffe00025257812ULL, 0x000fe400078ec0ffULL, 0x0000c00023237810ULL, 0x000fe40007ffe0ffULL,
0x0000e00025257810ULL, 0x000fc60007ffe0ffULL, 0x0000001018187824ULL, 0x100fe400078e0223ULL,
0x000000101a1a7824ULL, 0x000fe400078e0223ULL, 0x000000101b807824ULL, 0x000fe200078e0225ULL,
0x000000001874783bULL, 0x0002e80000000200ULL, 0x000000001a70783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001374747232ULL, 0x08cfe40000000000ULL,
0x0000001376767232ULL, 0x000fc40000000000ULL, 0x0000001475757232ULL, 0x080fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x080fe40000000000ULL,
0x0000001572727232ULL, 0x000fe40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101c7c7824ULL, 0x000fe200078e0225ULL, 0x000000008080783bULL, 0x000e620000004200ULL,
0x0000082000007945ULL, 0x000fe80003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000018ff1c7819ULL, 0x002fc40000011482ULL, 0x00000018ff1a7819ULL, 0x000fe40000011481ULL,
0x0000001c00877306ULL, 0x0003e20000200c00ULL, 0x00000018ff267819ULL, 0x008fe2000001147cULL,
0x000001007d8f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe2000001147dULL,
0x000100007d917824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011480ULL,
0x000001007e937824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011483ULL,
0x00000026008e7306ULL, 0x0007e20000200c00ULL, 0x00008880811c7816ULL, 0x002fc400000000ffULL,
0x000088807c8b7816ULL, 0x000fe400000000ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001147eULL,
0x00000018ff6d7819ULL, 0x000fe2000001147fULL, 0x0000001a006c7306ULL, 0x0003e20000200c00ULL,
0x0000010081267824ULL, 0x008fe200078e00ffULL, 0x000088807d8d7816ULL, 0x000fe200000000ffULL,
0x0001000081817824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe40000011491ULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000018002a7306ULL, 0x0007e20000200c00ULL,
0x00000100801a7824ULL, 0x042fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff937819ULL, 0x000fe40000011493ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000002700927306ULL, 0x000fe20000200c00ULL, 0x0000888080187816ULL, 0x048fe200000000ffULL,
0x0001000080807824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fc8000001148fULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x0000001c001c7306ULL, 0x000ff00000200c00ULL,
0x0000002600277306ULL, 0x0002f00000200c00ULL, 0x00000025008a7306ULL, 0x000fe20000200c00ULL,
0x0000888083267816ULL, 0x002fce00000000ffULL, 0x0000002600897306ULL, 0x0003e20000200c00ULL,
0x000054101c277816ULL, 0x008fe20000000027ULL, 0x000001007f1c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x000001007c267824ULL, 0x042fe400078e00ffULL, 0x000100007c7c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000001a00257306ULL, 0x0003e20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fce000001147cULL, 0x0000002b00967306ULL, 0x000fe20000200c00ULL,
0x00008880821a7816ULL, 0x002fce00000000ffULL, 0x0000006d00987306ULL, 0x0003f00000200c00ULL,
0x00000080002b7306ULL, 0x0006a20000200c00ULL, 0x00000100826d7824ULL, 0x042fe400078e00ffULL,
0x0001000082827824ULL, 0x000fc600078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x00000026008c7306ULL, 0x0003e20000200c00ULL, 0x0000010083807824ULL, 0x048fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0001000083837824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000007c007d7306ULL, 0x0006e20000200c00ULL,
0x000088807e267816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x000054102b2a7816ULL, 0x004fe4000000002aULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000002600947306ULL, 0x0003e20000200c00ULL,
0x000088807f7c7816ULL, 0x048fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x0000541018267816ULL, 0x002fe20000000025ULL, 0x000000ffff187224ULL, 0x000fe200078e007cULL,
0x000054107d8e7816ULL, 0x000fca000000008eULL, 0x0000001a001a7306ULL, 0x000fe20000200c00ULL,
0x00000026742c723cULL, 0x080f6e000000182cULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x00005410812b7816ULL, 0x004fe2000000006cULL, 0x00000026704c723cULL, 0x000f6c000000184cULL,
0x0000007e00977306ULL, 0x000ea40000200c00ULL, 0x0000002a7430723cULL, 0x080f6c0000001830ULL,
0x0000008000807306ULL, 0x000ee20000200c00ULL, 0x000054101a6c7816ULL, 0x002fe2000000006dULL,
0x0000002a7050723cULL, 0x000f6c0000001850ULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0x0000541097967816ULL, 0x004fce0000000096ULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x00005410896d7816ULL, 0x008fe20000000080ULL, 0x0000001020807824ULL, 0x000fcc00078e021fULL,
0x0000008b008b7306ULL, 0x000ee20000200c00ULL, 0x0000541082827816ULL, 0x002fe20000000087ULL,
0x0000006c7434723cULL, 0x080f6c0000001834ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x0000541083837816ULL, 0x004fe2000000008aULL, 0x0000006c7054723cULL, 0x000f6c0000001854ULL,
0x0000008f00907306ULL, 0x000e620000200c00ULL, 0x000054108b8c7816ULL, 0x008fe2000000008cULL,
0x000000827438723cULL, 0x080f6c0000001838ULL, 0x0000009100917306ULL, 0x000ea40000200c00ULL,
0x000000827058723cULL, 0x000f6c0000001858ULL, 0x0000009300937306ULL, 0x000ee20000200c00ULL,
0x000054108d8d7816ULL, 0x002fce0000000090ULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x00005410918f7816ULL, 0x004fe20000000092ULL, 0x0000008c743c723cULL, 0x040f6c000000183cULL,
0x0000001c00957306ULL, 0x000e620000200c00ULL, 0x0000541094947816ULL, 0x008fe20000000093ULL,
0x0000008e7440723cULL, 0x000f6c0000001840ULL, 0x0000007f007f7306ULL, 0x000ea40000200c00ULL,
0x0000008c705c723cULL, 0x000f62000000185cULL, 0x0000541018957816ULL, 0x002fce0000000095ULL,
0x0000008e7060723cULL, 0x000f620000001860ULL, 0x000054107f977816ULL, 0x004fce0000000098ULL,
0x000000947444723cULL, 0x040f700000001844ULL, 0x000000967448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0223ULL, 0x000000947064723cULL, 0x000f620000001864ULL,
0x000000101e237824ULL, 0x000fc800078e0223ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x000000967068723cULL, 0x000b640000001868ULL, 0x000000002370783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000001374747232ULL, 0x082fe40000000000ULL, 0x0000001376767232ULL, 0x000fe40000000000ULL,
0x0000001475757232ULL, 0x000fc40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x088fe40000000000ULL, 0x0000001572727232ULL, 0x000fe40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000008080783bULL, 0x000ea20000004200ULL,
0x00000010217c7824ULL, 0x000fcc00078e021fULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000018ff207819ULL, 0x004fe20000011483ULL, 0x00000100822b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe20000011481ULL, 0x00000100836d7824ULL, 0x000fe200078e00ffULL,
0x0000002000897306ULL, 0x0005e20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe40000011482ULL,
0x00000018ff187819ULL, 0x000fe20000011480ULL, 0x000100007e907824ULL, 0x008fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fc4000001147eULL, 0x00000018ff217819ULL, 0x000fe2000001147cULL,
0x0000001a00277306ULL, 0x0007e20000200c00ULL, 0x0000010081207824ULL, 0x004fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001147fULL, 0x00000018ff237819ULL, 0x000fe4000001147dULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000001c006c7306ULL, 0x0005e20000200c00ULL,
0x00000100801a7824ULL, 0x008fe200078e00ffULL, 0x000088807d8d7816ULL, 0x000fc400000000ffULL,
0x000088807f937816ULL, 0x000fe400000000ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000001800267306ULL, 0x0007e20000200c00ULL, 0x00008880811c7816ULL, 0x044fe200000000ffULL,
0x0001000081817824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000018ff907819ULL, 0x000fe40000011490ULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000002500917306ULL, 0x000fe20000200c00ULL, 0x0000888080187816ULL, 0x048fe200000000ffULL,
0x0001000080807824ULL, 0x000fca00078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000002000257306ULL, 0x0005f00000200c00ULL, 0x00000021008b7306ULL, 0x000fe20000200c00ULL,
0x0000888083207816ULL, 0x044fe200000000ffULL, 0x0001000083837824ULL, 0x000fca00078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0000001800187306ULL, 0x000ff00000200c00ULL,
0x0000001a00217306ULL, 0x000ff00000200c00ULL, 0x0000002000877306ULL, 0x0005f00000200c00ULL,
0x0000001c001c7306ULL, 0x000fe20000200c00ULL, 0x000001007c207824ULL, 0x004fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000081001a7306ULL, 0x0004f00000200c00ULL,
0x0000002a00927306ULL, 0x0003e20000200c00ULL, 0x000088807c817816ULL, 0x044fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x00000023008e7306ULL, 0x000fe20000200c00ULL, 0x00008880822a7816ULL, 0x042fe200000000ffULL,
0x0001000082827824ULL, 0x000fe200078e00ffULL, 0x000054101a277816ULL, 0x008fe20000000027ULL,
0x000100007f1a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0000008000237306ULL, 0x0002a20000200c00ULL, 0x00000018ff1a7819ULL, 0x000fce000001141aULL,
0x00000020008c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff807819ULL, 0x002fce000001146dULL,
0x00000082006d7306ULL, 0x0002620000200c00ULL, 0x000088807e207816ULL, 0x008fe400000000ffULL,
0x0000541023267816ULL, 0x004fca0000000026ULL, 0x00000020008f7306ULL, 0x0005e20000200c00ULL,
0x000001007d827824ULL, 0x042fe200078e00ffULL, 0x000000267430723cULL, 0x000b620000001830ULL,
0x000100007d7d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x00000083008a7306ULL, 0x0002e20000200c00ULL, 0x0000541018207816ULL, 0x004fe20000000021ULL,
0x000000ffff187224ULL, 0x000fe200078e0093ULL, 0x000054101c217816ULL, 0x000fe20000000025ULL,
0x000001007f1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x000000267050723cULL, 0x000b620000001850ULL, 0x000054106d6c7816ULL, 0x000fe2000000006cULL,
0x0000002a002a7306ULL, 0x000fe20000200c00ULL, 0x000001007e837824ULL, 0x002fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x000126c80c257811ULL, 0x000fe400078e18ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x00000020742c723cULL, 0x000b62000000182cULL,
0x0000002b002b7306ULL, 0x000e620000200c00ULL, 0x000054108a6d7816ULL, 0x008fcc0000000089ULL,
0x00000020704c723cULL, 0x000b62000000184cULL, 0x0000009000907306ULL, 0x000eae0000200c00ULL,
0x0000006c7438723cULL, 0x000b620000001838ULL, 0x0000008000807306ULL, 0x000ee20000200c00ULL,
0x000054102a2a7816ULL, 0x002fcc000000002bULL, 0x0000006c7058723cULL, 0x000b620000001858ULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x0000541090907816ULL, 0x004fce0000000091ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x00005410872b7816ULL, 0x008fce0000000080ULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x00005410818c7816ULL, 0x002fe2000000008cULL,
0x0000002a7434723cULL, 0x080b6c0000001834ULL, 0x0000007c007c7306ULL, 0x000e640000200c00ULL,
0x0000002a7054723cULL, 0x000b6c0000001854ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x000054108d8d7816ULL, 0x004fce0000000082ULL, 0x00000083007e7306ULL, 0x000ea20000200c00ULL,
0x000054107c7c7816ULL, 0x002fe2000000008bULL, 0x0000008c743c723cULL, 0x080b6c000000183cULL,
0x0000001800187306ULL, 0x000fe20000200c00ULL, 0x000054107d7d7816ULL, 0x008fe2000000008eULL,
0x0000008c705c723cULL, 0x000b6c000000185cULL, 0x0000001c007f7306ULL, 0x000e620000200c00ULL,
0x000054108f7e7816ULL, 0x004fe2000000007eULL, 0x0000007c7440723cULL, 0x080b6c0000001840ULL,
0x0000001a00237306ULL, 0x0004e40000200c00ULL, 0x0000007c7060723cULL, 0x000b620000001860ULL,
0x00005410187f7816ULL, 0x002fe2000000007fULL, 0x0000000212187824ULL, 0x000fca00078e00ffULL,
0xfffffff8181a7812ULL, 0x004fe200078ec0ffULL, 0x0000007e7444723cULL, 0x000b620000001844ULL,
0x0000541023917816ULL, 0x008fce0000000092ULL, 0x000000907448723cULL, 0x000b700000001848ULL,
0x0000007e7064723cULL, 0x040b700000001864ULL, 0x000000907068723cULL, 0x000b620000001868ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000252a7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012698001aff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff187224ULL, 0x000fc600078e00ffULL,
0x0000000000207805ULL, 0x000fc80000015200ULL, 0x0000040025237984ULL, 0x000e620000000800ULL,
0x000000030d1a7810ULL, 0x008fc40007ffe0ffULL, 0x8000000023ff7812ULL, 0x006fe2000780482bULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620237210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e21ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc80000011426ULL,
0x000000231c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0626ULL,
0x000000021c1c7819ULL, 0x000fc80000001223ULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000040025237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000108237810ULL, 0x000fe40007ffe0ffULL,
0x000000030a0a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000e2300720cULL, 0x000fda0003f06070ULL,
0x0000085000000947ULL, 0x000fea0003800000ULL, 0x0000000208217810ULL, 0x000fe20007ffe0ffULL,
0x0000010023237824ULL, 0x000fe400078e027bULL, 0x0000590022227a24ULL, 0x010fe200078e02ffULL,
0x0000000e2100720cULL, 0x000fe40003f06070ULL, 0x00000020230a7812ULL, 0x000fe200078ec0ffULL,
0x00000040226d7824ULL, 0x000fc800078e00ffULL, 0x000000010b2a7824ULL, 0x000fcc00078e020aULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x00000023100a7217ULL, 0x000fe20007800000ULL,
0x0000001012187824ULL, 0x000fc800078e00ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a23ULL,
0x0000001018217812ULL, 0x000fe400078ec0ffULL, 0x00000003ff187819ULL, 0x000fe40000011611ULL,
0x0000000a210a7217ULL, 0x000fe40007800000ULL, 0x00000004181c7810ULL, 0x040fe40007ffe0ffULL,
0x0000000818207810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0a7824ULL, 0x100fe200078e0a21ULL,
0x0000000c18257810ULL, 0x000fe20007ffe0ffULL, 0x000000011c227824ULL, 0x000fc400078e0221ULL,
0x0000000120237824ULL, 0x040fe200078e0221ULL, 0x0000000a2000720cULL, 0x080fe20003f46070ULL,
0x0000000122207824ULL, 0x000fe200078e0211ULL, 0x0000000a1800720cULL, 0x080fe20003f86070ULL,
0x00000008222b7824ULL, 0x000fe200078e00ffULL, 0x0000000a1c00720cULL, 0x080fe20003f66070ULL,
0x0000000118187824ULL, 0x100fe200078e0221ULL, 0x0000000a2500720cULL, 0x040fe20003f06070ULL,
0x0000000125217824ULL, 0x000fe200078e0221ULL, 0xfffffff82b0a7812ULL, 0x000fe200078ee220ULL,
0x00000001181c7824ULL, 0x000fc400078e0211ULL, 0x0000000818277824ULL, 0x040fe400078e00ffULL,
0x0000000118207824ULL, 0x100fe400078e022aULL, 0x0000000123267824ULL, 0x000fe200078e022aULL,
0xfffffff8271c7812ULL, 0x000fe200078ee21cULL, 0x0000000123187824ULL, 0x040fe400078e0211ULL,
0x0000000823237824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x000fc400078e022aULL,
0x0000000121257824ULL, 0x000fe200078e0211ULL, 0xfffffff823187812ULL, 0x000fe200078ee218ULL,
0x00000008216c7824ULL, 0x040fe400078e00ffULL, 0x00000001212a7824ULL, 0x000fe400078e022aULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0xfffffff86c6c7812ULL, 0x000fe400078ee225ULL,
0x000062006d257a11ULL, 0x000fe200078a38ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000000320207212ULL, 0x000fc400078efcffULL, 0x000063006d6d7a11ULL, 0x000fe200028f3cffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000322227212ULL, 0x000fe400078efcffULL,
0x0000002025207210ULL, 0x000fe20007fbe0ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002522227210ULL, 0x000fe40007fde0ffULL, 0x0000000326267212ULL, 0x080fe200078efcffULL,
0x0000000121217824ULL, 0x100fe200028e066dULL, 0x000000032a2a7212ULL, 0x000fe200078efcffULL,
0x0000000123237824ULL, 0x000fe200030e066dULL, 0x0000002526267210ULL, 0x080fe20007fbe0ffULL,
0x000000100a717824ULL, 0x100fe200078e021fULL, 0x000000252a2a7210ULL, 0x000fe20007fde0ffULL,
0x000000101c257824ULL, 0x000fc400078e021fULL, 0x0000001018737824ULL, 0x000fe400078e021fULL,
0x0000000127277824ULL, 0x000fe200028e066dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e2000e101c48ULL, 0x000000106c1f7824ULL, 0x000fe400078e021fULL,
0x000000012b2b7824ULL, 0x000fe200030e066dULL, 0x0000000022717faeULL, 0x0003e8000d901c48ULL,
0x0000000026737faeULL, 0x0003e8000d101c48ULL, 0x000000002a1f7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010120a7824ULL, 0x000fca00078e00ffULL,
0x000000100a0a7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7211ULL, 0x000fc800078fe8ffULL,
0x000000040a1c7810ULL, 0x040fe20007ffe0ffULL, 0x000000010a187824ULL, 0x140fe200078e0211ULL,
0x0000000c0a237810ULL, 0x040fe20007ffe0ffULL, 0x000000080a217824ULL, 0x040fe400078e00ffULL,
0x000000010a207824ULL, 0x100fe400078e022aULL, 0x000000011c227824ULL, 0x040fe200078e022aULL,
0xfffffff821187812ULL, 0x000fe200078ee218ULL, 0x000000081c277824ULL, 0x000fe200078e00ffULL,
0x000000080a217810ULL, 0x000fe20007ffe0ffULL, 0x000000011c0a7824ULL, 0x000fc400078e0211ULL,
0x0000000123257824ULL, 0x140fe400078e0211ULL, 0x00000008236c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8270a7812ULL, 0x000fe200078ee20aULL, 0x0000000121267824ULL, 0x040fe400078e022aULL,
0x00000001211c7824ULL, 0x040fe200078e0211ULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee225ULL,
0x00000008212b7824ULL, 0x000fe200078e00ffULL, 0x000062006d257a11ULL, 0x000fe200078038ffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0xfffffff82b1c7812ULL, 0x000fe200078ee21cULL,
0x00000001232a7824ULL, 0x000fe200078e022aULL, 0x0000000320207212ULL, 0x080fe200078efcffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x000063006d6d7a11ULL, 0x000fe400000f3cffULL,
0x0000002025207210ULL, 0x000fe20007f1e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000322227212ULL, 0x000fc600078efcffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000000326267212ULL, 0x000fc600078efcffULL, 0x0000000121217824ULL, 0x000fe200000e066dULL,
0x000000032a2a7212ULL, 0x000fe200078efcffULL, 0x000000100a717824ULL, 0x100fe200078e021fULL,
0x0000002225227210ULL, 0x040fe20007f1e0ffULL, 0x000000101c737824ULL, 0x100fe200078e021fULL,
0x0000002625267210ULL, 0x040fe40007f5e0ffULL, 0x0000002a252a7210ULL, 0x000fe20007f7e0ffULL,
0x0000001018257824ULL, 0x000fe400078e021fULL, 0x0000000123237824ULL, 0x000fc400000e066dULL,
0x0000000127277824ULL, 0x000fe200010e066dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e2000b901c48ULL, 0x000000106c1f7824ULL, 0x000fe400078e021fULL,
0x000000012b2b7824ULL, 0x000fe200018e066dULL, 0x0000000022717faeULL, 0x0003e8000b901c48ULL,
0x0000000026737faeULL, 0x0003e8000b901c48ULL, 0x000000002a1f7faeULL, 0x0003e4000b901c48ULL,
0x00000004060a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0xffffffffff227424ULL, 0x002fc400078e00ffULL, 0x0000000f0a00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000109227824ULL, 0x000fe400078e020aULL,
0x00000004ff237424ULL, 0x000fc800078e00ffULL, 0x0000640022227625ULL, 0x000fcc00078e0023ULL,
0x0000000822227981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000812187824ULL, 0x000fe400078e00ffULL, 0x000000200d067824ULL, 0x000fc600078e0207ULL,
0xfffffff018207812ULL, 0x040fe400078ec0ffULL, 0x00000008181f7812ULL, 0x000fe400078ec0ffULL,
0x00000000200473c2ULL, 0x000ea200000e0000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000011f067824ULL, 0x000fe200078e0206ULL, 0x000126a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126a80020207f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01266800062a7f8cULL, 0x000662000c80043fULL,
0x000000ffff187224ULL, 0x004fc600078e0021ULL, 0x0000000000207805ULL, 0x000fc80000015200ULL,
0x01266c00061f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026201f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e21ULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc80000011426ULL,
0x0000001f1c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e0626ULL,
0x000000021c1c7819ULL, 0x000fc8000000121fULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000123237810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01266c00061f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000801a1f7824ULL, 0x000fc800078e0203ULL, 0x00000001021f7824ULL, 0x000fca00078e021fULL,
0x012000001f237984ULL, 0x000e680000000800ULL, 0x012200001f217984ULL, 0x0004e20000000800ULL,
0x000000042300720bULL, 0x002fe20003f1d000ULL, 0x0000c0127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000067806ULL, 0x00cfc800000e0100ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x000fd200078e0004ULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x000000030d1f7810ULL, 0x000fe40007ffe0ffULL, 0x000000042300720bULL, 0x000fe40003f54000ULL,
0x000000121f00720cULL, 0x000fe20003f05270ULL, 0x0000bfc27f007947ULL, 0x000fd4000b800000ULL,
0x00000000001f7806ULL, 0x000fc400010e0100ULL, 0x0000008012038824ULL, 0x000fe200078e0203ULL,
0x00000004231a7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000102038824ULL, 0x000fca00078e0203ULL, 0x0124001a03008388ULL, 0x0003e20000000800ULL,
0x000000ff1f00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x000000041a027221ULL, 0x002fe20000010100ULL, 0x000000ff1fff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL,
0x0000000200037308ULL, 0x000e640000000800ULL, 0x0000000324247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe20000011611ULL,
0x0000bf027f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000262c2c7220ULL, 0x084fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002644447220ULL, 0x080fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001fff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000811277811ULL, 0x002fe200078ff0ffULL, 0x0000bdd27f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000262e2e7220ULL, 0x084fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x0000002646467220ULL, 0x080fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001fff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001011277811ULL, 0x002fe200078ff0ffULL,
0x0000bca27f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000264c4c7220ULL, 0x084fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x0000002664647220ULL, 0x080fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002668687220ULL, 0x080fe20000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001811277811ULL, 0x002fe200078ff0ffULL,
0x0000bb827f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000264e4e7220ULL, 0x084fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x0000002666667220ULL, 0x080fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x000000266a6a7220ULL, 0x080fe20000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001f06ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff1c7424ULL, 0x000fd800078e00ffULL, 0x000000231a020221ULL, 0x000fe20000010100ULL,
0x00007610ff1c0816ULL, 0x000fc6000000001cULL, 0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL,
0x0000000200000308ULL, 0x000e640000000800ULL, 0x0000000021210220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002421247221ULL, 0x000fe20000010000ULL,
0x000000010c047812ULL, 0x000fc400078ec0ffULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x0000000812067824ULL, 0x000fca00078e00ffULL, 0xfffffff006237812ULL, 0x000fca00078ec0ffULL,
0x0126b400231f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x00000020021f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000121207824ULL, 0x000fe200000e0e03ULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011420ULL,
0x0000001f06067211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e0620ULL,
0x0000000206067819ULL, 0x000fc8000000121fULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b400231f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099101c027816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe40000011611ULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x0000b7327f007947ULL, 0x000fea000b800000ULL,
0x00001f0302137589ULL, 0x0002a400000e0000ULL, 0x0000000803277810ULL, 0x002fe20007ffe0ffULL,
0x0000b7627f007947ULL, 0x000fea000b800000ULL, 0x0000001003157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2702147589ULL, 0x0002ea00000e0000ULL, 0x00001f1502157589ULL, 0x0002a400000e0000ULL,
0x0000001803277810ULL, 0x002fe20007ffe0ffULL, 0x0000b7b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2702167589ULL, 0x0002e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff037819ULL, 0x000fe20000011611ULL, 0x00000008171f7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000819217824ULL, 0x000fe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000404047824ULL, 0x000fe200078e0203ULL,
0x000000030d037810ULL, 0x000fe20007ffe0ffULL, 0x0000000412067824ULL, 0x000fc400078e00ffULL,
0x0000000117027824ULL, 0x102fe200078e0204ULL, 0x0000a00003037811ULL, 0x000fe200078e60ffULL,
0x0000000119047824ULL, 0x000fe200078e0204ULL, 0x0000000406067812ULL, 0x000fe200078ec0ffULL,
0x000000101b747824ULL, 0x000fe200078e0228ULL, 0xfffffff81f027812ULL, 0x000fe400078ee202ULL,
0xfffffff821047812ULL, 0x000fe400078ee204ULL, 0x0000000206067812ULL, 0x000fe200078efcffULL,
0x0000001002027824ULL, 0x000fc400078e0203ULL, 0x0000001004047824ULL, 0x000fc600078e0203ULL,
0x000000000270783bULL, 0x0002e80000000200ULL, 0x00000000046c783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001370707232ULL, 0x08cfe40000000000ULL,
0x0000001372727232ULL, 0x000fe40000000000ULL, 0x0000001471717232ULL, 0x080fe40000000000ULL,
0x0000001473737232ULL, 0x000fc40000000000ULL, 0x000000156c6c7232ULL, 0x080fe40000000000ULL,
0x000000156e6e7232ULL, 0x000fe40000000000ULL, 0x000000166d6d7232ULL, 0x080fe40000000000ULL,
0x000000166f6f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000611027211ULL, 0x002fe200078fe0ffULL, 0x0000000817047824ULL, 0x040fe200078e00ffULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x000000101e1e7824ULL, 0x000fe200078e0203ULL,
0x0000082000007945ULL, 0x000fe20003800000ULL, 0x0000000117177824ULL, 0x000fca00078e0202ULL,
0xfffffff804177812ULL, 0x000fca00078ee217ULL, 0x0000001017177824ULL, 0x000fca00078e0228ULL,
0x00000000177c783bULL, 0x000ee20000004200ULL, 0x00000018ff067819ULL, 0x002fe20000011475ULL,
0x00000100772b7824ULL, 0x040fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe40000011476ULL,
0x00000018ff1f7819ULL, 0x000fe20000011477ULL, 0x0000000600237306ULL, 0x0003e20000200c00ULL,
0x00000018ff047819ULL, 0x000fe40000011474ULL, 0x0000888077277816ULL, 0x040fe200000000ffULL,
0x0001000077777824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc6000001142bULL,
0x0000001c002a7306ULL, 0x0005e20000200c00ULL, 0x0000010074067824ULL, 0x002fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011477ULL, 0x00000018ff217819ULL, 0x008fe2000001147eULL,
0x000001007f8b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe4000001147cULL,
0x0000001f00817306ULL, 0x0003e20000200c00ULL, 0x00008880751c7816ULL, 0x004fe400000000ffULL,
0x00000018ff257819ULL, 0x000fc4000001147fULL, 0x00000018ff177819ULL, 0x000fe4000001147dULL,
0x00000018ff067819ULL, 0x000fe20000011406ULL, 0x0000002100897306ULL, 0x0005e20000200c00ULL,
0x00000100751f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x0001000075757824ULL, 0x000fc600078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000004001b7306ULL, 0x0003e20000200c00ULL, 0x0000010076217824ULL, 0x004fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fc80000011475ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002000877306ULL, 0x0005e20000200c00ULL, 0x0000888074047816ULL, 0x042fe200000000ffULL,
0x0001000074747824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000002100267306ULL, 0x0003e20000200c00ULL, 0x0000888076207816ULL, 0x044fe200000000ffULL,
0x0001000076767824ULL, 0x000fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x00000025008d7306ULL, 0x000fe20000200c00ULL, 0x000001007c217824ULL, 0x002fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000001700887306ULL, 0x000ff00000200c00ULL,
0x0000002000257306ULL, 0x0002b00000200c00ULL, 0x0000000400047306ULL, 0x000fe20000200c00ULL,
0x000088807c207816ULL, 0x042fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000000600177306ULL, 0x000fe20000200c00ULL,
0x0000541025267816ULL, 0x004fce0000000026ULL, 0x0000007500067306ULL, 0x0003f00000200c00ULL,
0x00000076002b7306ULL, 0x0004e20000200c00ULL, 0x000088807d757816ULL, 0x002fce00000000ffULL,
0x0000002000837306ULL, 0x0003e20000200c00ULL, 0x000001007d767824ULL, 0x044fe400078e00ffULL,
0x000100007d7d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x0000002100847306ULL, 0x0004a20000200c00ULL, 0x000088807e207816ULL, 0x002fe400000000ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x000054102b2a7816ULL, 0x008fc6000000002aULL,
0x0000007500857306ULL, 0x0003e20000200c00ULL, 0x000001007e217824ULL, 0x044fe400078e00ffULL,
0x000100007e7e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000007700827306ULL, 0x000ea20000200c00ULL,
0x000088807f757816ULL, 0x042fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x0000541083847816ULL, 0x000fc80000000084ULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000002000777306ULL, 0x0003f00000200c00ULL, 0x0000001c001c7306ULL, 0x000fe20000200c00ULL,
0x0000541004207816ULL, 0x002fc40000000017ULL, 0x00005410822b7816ULL, 0x004fca0000000081ULL,
0x0000001f001f7306ULL, 0x000fe40000200c00ULL, 0x0000002a6c58723cULL, 0x080f6c0000001858ULL,
0x0000007400747306ULL, 0x000e640000200c00ULL, 0x0000002a7038723cULL, 0x000f6c0000001838ULL,
0x0000002700277306ULL, 0x000ff00000200c00ULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x0000541074747816ULL, 0x002fce000000001bULL, 0x0000007600767306ULL, 0x000e700000200c00ULL,
0x0000007c007c7306ULL, 0x000ee20000200c00ULL, 0x0000541027277816ULL, 0x004fce0000000080ULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x0000541085857816ULL, 0x002fe20000000076ULL,
0x000000266c54723cULL, 0x040f6c0000001854ULL, 0x00000021008a7306ULL, 0x0002a20000200c00ULL,
0x000054107c7c7816ULL, 0x008fe20000000087ULL, 0x000000846c5c723cULL, 0x000f6c000000185cULL,
0x00000075008c7306ULL, 0x0007e20000200c00ULL, 0x000054101c217816ULL, 0x002fe2000000001fULL,
0x000000267034723cULL, 0x000f620000001834ULL, 0x000054107d7d7816ULL, 0x004fca0000000088ULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x0000541006757816ULL, 0x008fe20000000023ULL,
0x000000206c4c723cULL, 0x000f62000000184cULL, 0x00005410778a7816ULL, 0x000fca000000008aULL,
0x0000007e007e7306ULL, 0x000ea40000200c00ULL, 0x000000746c50723cULL, 0x040f6c0000001850ULL,
0x0000007f00047306ULL, 0x000ee20000200c00ULL, 0x000054108c8b7816ULL, 0x002fe2000000008bULL,
0x0000007c6c60723cULL, 0x000f620000001860ULL, 0x000054107e7e7816ULL, 0x004fce0000000089ULL,
0x0000008a6c64723cULL, 0x000f620000001864ULL, 0x00005410047f7816ULL, 0x008fe2000000008dULL,
0x000000101d047824ULL, 0x000fcc00078e0203ULL, 0x00000020702c723cULL, 0x000f62000000182cULL,
0x000000001e1c783bULL, 0x000e6e0000000200ULL, 0x0000007e6c68723cULL, 0x000b640000001868ULL,
0x00000000046c783bULL, 0x0204ec0000000200ULL, 0x000000747030723cULL, 0x040b700000001830ULL,
0x00000084703c723cULL, 0x040b70000000183cULL, 0x0000007c7040723cULL, 0x040b700000001840ULL,
0x0000008a7044723cULL, 0x040b700000001844ULL, 0x0000007e7048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x000000136c6c7232ULL, 0x08efe40000000000ULL, 0x000000136e6e7232ULL, 0x000fc40000000000ULL,
0x000000146d6d7232ULL, 0x080fe40000000000ULL, 0x000000146f6f7232ULL, 0x000fe40000000000ULL,
0x000000151c1c7232ULL, 0x080fe40000000000ULL, 0x000000151e1e7232ULL, 0x000fe40000000000ULL,
0x000000161d1d7232ULL, 0x080fe40000000000ULL, 0x000000161f1f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000000819037824ULL, 0x040fe200078e00ffULL,
0x000000002970783bULL, 0x020e620000004200ULL, 0x0000000119027824ULL, 0x000fca00078e0202ULL,
0xfffffff803037812ULL, 0x000fca00078ee202ULL, 0x0000001003037824ULL, 0x000fca00078e0228ULL,
0x000000000374783bULL, 0x0004e20000004200ULL, 0x00000018ff027819ULL, 0x002fe20000011470ULL,
0x0000010070037824ULL, 0x004fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fe20000011472ULL,
0x0000010073277824ULL, 0x000fe200078e00ffULL, 0x0000000200047306ULL, 0x0003e20000200c00ULL,
0x00000018ff067819ULL, 0x000fe40000011471ULL, 0x00000018ff197819ULL, 0x000fe40000011473ULL,
0x00000018ff037819ULL, 0x000fc40000011403ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000001700237306ULL, 0x0005e20000200c00ULL, 0x0000888070027816ULL, 0x042fe200000000ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x008fe20000011475ULL,
0x0000010074297824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fc60000011476ULL,
0x0000000600217306ULL, 0x0003e20000200c00ULL, 0x0000010071177824ULL, 0x044fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff267819ULL, 0x000fe40000011477ULL,
0x00000018ff1b7819ULL, 0x000fe40000011474ULL, 0x00000019002b7306ULL, 0x0005e20000200c00ULL,
0x0000888071067816ULL, 0x042fe200000000ffULL, 0x0001000071717824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00008880757d7816ULL, 0x000fe400000000ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000002000817306ULL, 0x0003e20000200c00ULL,
0x00000018ff197819ULL, 0x004fce0000011417ULL, 0x0000007000177306ULL, 0x000fe20000200c00ULL,
0x0000010072207824ULL, 0x002fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000000200027306ULL, 0x000ff00000200c00ULL, 0x0000000300037306ULL, 0x000e700000200c00ULL,
0x0000000600067306ULL, 0x000ff00000200c00ULL, 0x0000001900197306ULL, 0x000ea20000200c00ULL,
0x0000541002027816ULL, 0x002fce0000000003ULL, 0x0000002000287306ULL, 0x0003f00000200c00ULL,
0x0000002500847306ULL, 0x0007e20000200c00ULL, 0x0000888074207816ULL, 0x042fe200000000ffULL,
0x0001000074747824ULL, 0x000fe200078e00ffULL, 0x0000541006037816ULL, 0x004fe20000000019ULL,
0x0000010077067824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000002600877306ULL, 0x000fe20000200c00ULL, 0x0000888073257816ULL, 0x048fe200000000ffULL,
0x0001000073737824ULL, 0x000fe200078e00ffULL, 0x00000018ff067819ULL, 0x000fe20000011406ULL,
0x000000026c2c723cULL, 0x080b66000000182cULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000007100267306ULL, 0x000e680000200c00ULL, 0x000000021c4c723cULL, 0x000b68000000184cULL,
0x0000002000717306ULL, 0x0005f00000200c00ULL, 0x00000027002a7306ULL, 0x0007e20000200c00ULL,
0x0000888076207816ULL, 0x004fc400000000ffULL, 0x0000541026217816ULL, 0x002fca0000000021ULL,
0x0000001b007e7306ULL, 0x0003e20000200c00ULL, 0x0000010075277824ULL, 0x048fe400078e00ffULL,
0x0001000075757824ULL, 0x000fc600078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011427ULL,
0x0000002000837306ULL, 0x0005e20000200c00ULL, 0x00008880721b7816ULL, 0x042fe200000000ffULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fc80000011475ULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000007300707306ULL, 0x0003e20000200c00ULL,
0x0000541017207816ULL, 0x004fe20000000004ULL, 0x0001000077047824ULL, 0x000fca00078e00ffULL,
0x00000018ff047819ULL, 0x000fe20000011404ULL, 0x00000029007c7306ULL, 0x0004e20000200c00ULL,
0x0001000076737824ULL, 0x042fe200078e00ffULL, 0x000000206c30723cULL, 0x080b680000001830ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000007400277306ULL, 0x0002e20000200c00ULL,
0x0000010076297824ULL, 0x004fe200078e00ffULL, 0x000000201c50723cULL, 0x000b680000001850ULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x0000007300857306ULL, 0x0004a20000200c00ULL,
0x0000888077747816ULL, 0x002fe400000000ffULL, 0x00005410717c7816ULL, 0x008fca000000007cULL,
0x0000001b001b7306ULL, 0x000e620000200c00ULL, 0x0000541070737816ULL, 0x004fe4000000002bULL,
0x00005410277e7816ULL, 0x000fca000000007eULL, 0x0000002500257306ULL, 0x000fe20000200c00ULL,
0x0000541085847816ULL, 0x000fce0000000084ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000054101b287816ULL, 0x002fce0000000028ULL, 0x0000007d007d7306ULL, 0x000ff00000200c00ULL,
0x0000007f00807306ULL, 0x000e620000200c00ULL, 0x0000541072727816ULL, 0x004fce0000000023ULL,
0x0000007500827306ULL, 0x000ea20000200c00ULL, 0x000000726c38723cULL, 0x080b6e0000001838ULL,
0x0000002900767306ULL, 0x0006a20000200c00ULL, 0x000054107d7d7816ULL, 0x002fe20000000080ULL,
0x000000721c58723cULL, 0x000b6c0000001858ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541025297816ULL, 0x008fe2000000002aULL, 0x0000007c6c3c723cULL, 0x000b62000000183cULL,
0x00005410827f7816ULL, 0x004fca0000000081ULL, 0x0000000600777306ULL, 0x000e620000200c00ULL,
0x0000541083767816ULL, 0x000fe20000000076ULL, 0x000000286c34723cULL, 0x040b6c0000001834ULL,
0x0000000400047306ULL, 0x000ea40000200c00ULL, 0x0000007e6c40723cULL, 0x000b620000001840ULL,
0x0000541074777816ULL, 0x002fce0000000077ULL, 0x000000281c54723cULL, 0x000b620000001854ULL,
0x0000541004857816ULL, 0x004fce0000000087ULL, 0x000000766c44723cULL, 0x040b700000001844ULL,
0x000000846c48723cULL, 0x000b700000001848ULL, 0x0000007c1c5c723cULL, 0x040b70000000185cULL,
0x0000007e1c60723cULL, 0x040b700000001860ULL, 0x000000761c64723cULL, 0x040b700000001864ULL,
0x000000841c68723cULL, 0x000b620000001868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000005027f8cULL, 0x0202a2000c80043fULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x000126a00d047811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000004ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff177224ULL, 0x004fe200078e0003ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff4e8000007947ULL, 0x000fea000383ffffULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000cc1000047802ULL, 0x008fc40000000f00ULL,
0x0000a77000007944ULL, 0x016fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002400037308ULL, 0x004ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc80000000024ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000087919ULL, 0x000ea80000000000ULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000001808057811ULL, 0x006fc400078ff0ffULL, 0x0000000808097811ULL, 0x040fe400078ff0ffULL,
0x00000002ff077819ULL, 0x000fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x008fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f0b06027589ULL, 0x000ea200000e0000ULL, 0x0000002c002c7220ULL, 0x042fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000004400447220ULL, 0x040fe20000410000ULL,
0x0000004500457220ULL, 0x040fe20000410000ULL, 0x0000004800487220ULL, 0x040fe20000410000ULL,
0x0000004900497220ULL, 0x000fe20000410000ULL, 0x0000004e054e7220ULL, 0x044fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000005a055a7220ULL, 0x040fe20000410000ULL,
0x0000005b055b7220ULL, 0x040fe20000410000ULL, 0x0000005e055e7220ULL, 0x040fe20000410000ULL,
0x0000005f055f7220ULL, 0x040fe20000410000ULL, 0x0000006205627220ULL, 0x040fe20000410000ULL,
0x0000006305637220ULL, 0x040fe20000410000ULL, 0x0000006605667220ULL, 0x040fe20000410000ULL,
0x0000006705677220ULL, 0x040fe20000410000ULL, 0x0000006a056a7220ULL, 0x040fe20000410000ULL,
0x0000006b056b7220ULL, 0x000fe20000410000ULL, 0x000000042e2e7220ULL, 0x088fe20000410000ULL,
0x000000042f2f7220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x000000043a3a7220ULL, 0x080fe20000410000ULL,
0x000000043b3b7220ULL, 0x080fe20000410000ULL, 0x000000043e3e7220ULL, 0x080fe20000410000ULL,
0x000000043f3f7220ULL, 0x080fe20000410000ULL, 0x0000000442427220ULL, 0x080fe20000410000ULL,
0x0000000443437220ULL, 0x080fe20000410000ULL, 0x0000000446467220ULL, 0x080fe20000410000ULL,
0x0000000447477220ULL, 0x080fe20000410000ULL, 0x000000044a4a7220ULL, 0x080fe20000410000ULL,
0x000000044b4b7220ULL, 0x000fe20000410000ULL, 0x000000024c4c7220ULL, 0x080fe20000410000ULL,
0x000000024d4d7220ULL, 0x080fe20000410000ULL, 0x0000000250507220ULL, 0x080fe20000410000ULL,
0x0000000251517220ULL, 0x080fe20000410000ULL, 0x0000000254547220ULL, 0x080fe20000410000ULL,
0x0000000255557220ULL, 0x080fe20000410000ULL, 0x0000000258587220ULL, 0x080fe20000410000ULL,
0x0000000259597220ULL, 0x080fe20000410000ULL, 0x000000025c5c7220ULL, 0x080fe20000410000ULL,
0x000000025d5d7220ULL, 0x080fe20000410000ULL, 0x0000000260607220ULL, 0x080fe20000410000ULL,
0x0000000261617220ULL, 0x080fe20000410000ULL, 0x0000000264647220ULL, 0x080fe20000410000ULL,
0x0000000265657220ULL, 0x080fe20000410000ULL, 0x0000000268687220ULL, 0x080fe20000410000ULL,
0x0000000269697220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000002e2f2e723eULL, 0x000fc400000000ffULL, 0x000000323317723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000363736723eULL, 0x000fe400000000ffULL,
0x0000003a3b1b723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fc400000000ffULL,
0x00000042431f723eULL, 0x000fe400000000ffULL, 0x000000464746723eULL, 0x000fe400000000ffULL,
0x0000004a4b23723eULL, 0x000fe400000000ffULL, 0x0000004c4d4c723eULL, 0x000fe400000000ffULL,
0x0000000800057811ULL, 0x04afe400078ff0ffULL, 0x0000000200027812ULL, 0x004fc400078ec0ffULL,
0x0000001800097811ULL, 0x000fe200078ff0ffULL, 0x00000008050a7824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x000fe200078ff0ffULL,
0x0000000809187824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee203ULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x0000000805167824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fc400078ff8ffULL, 0x0000000902057211ULL, 0x040fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000702047211ULL, 0x000fe200078ff8ffULL,
0x0000000807107824ULL, 0x040fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee203ULL,
0x0000200012037824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x000fe40007ffe0ffULL,
0x0000200003037812ULL, 0x000fc400078ee2ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff805027812ULL, 0x000fe200078ee204ULL, 0x000010000c057824ULL, 0x000fe200078e0203ULL,
0x0000000404067810ULL, 0x040fe40007ffe0ffULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090e7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x000000100a147824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x00000010080a7824ULL, 0x100fe200078e0205ULL, 0x0000002c2d02723eULL, 0x000fe200000000ffULL,
0x0000001016167824ULL, 0x000fe200078e0205ULL, 0x000000303104723eULL, 0x000fe200000000ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000404106723eULL, 0x000fe200000000ffULL,
0x0000001018187824ULL, 0x100fe200078e0205ULL, 0x00005410021c7816ULL, 0x100fe20000000004ULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x00007632021d7816ULL, 0x000fe20000000004ULL,
0x0000001010107824ULL, 0x000fe200078e0205ULL, 0x000000343502723eULL, 0x000fe200000000ffULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x000000383904723eULL, 0x000fe200000000ffULL,
0x0000001c08007388ULL, 0x0003e20000000a00ULL, 0x0000003c3d05723eULL, 0x000fe200000000ffULL,
0x0000000107167824ULL, 0x000fe200078e0216ULL, 0x000000505126723eULL, 0x000fe200000000ffULL,
0x0000000107187824ULL, 0x040fe200078e0218ULL, 0x00005410361a7816ULL, 0x000fe2000000001bULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000545554723eULL, 0x000fe200000000ffULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000058592a723eULL, 0x000fe200000000ffULL,
0x0000000107107824ULL, 0x000fe200078e0210ULL, 0x000000444507723eULL, 0x000fc400000000ffULL,
0x00005410021c7816ULL, 0x142fe40000000004ULL, 0x00007632021d7816ULL, 0x000fe40000000004ULL,
0x000000484908723eULL, 0x000fe400000000ffULL, 0x0000541005047816ULL, 0x140fe20000000006ULL,
0x0000001c0a007388ULL, 0x000fe20000000a00ULL, 0x0000763205057816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x000fc40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000040e007388ULL, 0x0003e20000000a00ULL, 0x00007632361b7816ULL, 0x000fe4000000001bULL,
0x000054103e1e7816ULL, 0x140fe2000000001fULL, 0x0000000610007388ULL, 0x0005e20000000a00ULL,
0x000076323e1f7816ULL, 0x000fe4000000001fULL, 0x0000541046227816ULL, 0x150fe40000000023ULL,
0x0000763246237816ULL, 0x000fc40000000023ULL, 0x0000541054087816ULL, 0x000fe4000000002aULL,
0x000054102e047816ULL, 0x142fe40000000017ULL, 0x000076322e057816ULL, 0x000fe40000000017ULL,
0x000054104c067816ULL, 0x144fe40000000026ULL, 0x000076324c077816ULL, 0x000fe20000000026ULL,
0x0000000414007388ULL, 0x0003e20000000a00ULL, 0x0000763254097816ULL, 0x000fc4000000002aULL,
0x0000005c5d5c723eULL, 0x000fe200000000ffULL, 0x0004001a0a007388ULL, 0x000fe20000000a00ULL,
0x000000606160723eULL, 0x000fe400000000ffULL, 0x000000646564723eULL, 0x000fe200000000ffULL,
0x0004001e0e007388ULL, 0x000fe20000000a00ULL, 0x000000686932723eULL, 0x000fe400000000ffULL,
0x0000004e4f02723eULL, 0x000fe200000000ffULL, 0x0004002210007388ULL, 0x000fe20000000a00ULL,
0x0000541064147816ULL, 0x002fc40000000032ULL, 0x0000763264157816ULL, 0x000fe20000000032ULL,
0x0000000616007388ULL, 0x0003e20000000a00ULL, 0x000000525304723eULL, 0x000fe400000000ffULL,
0x000000565705723eULL, 0x000fe200000000ffULL, 0x000800080a007388ULL, 0x0005e20000000a00ULL,
0x000000ff0c00720cULL, 0x000fe40003f05270ULL, 0x0000005a5b06723eULL, 0x002fe400000000ffULL,
0x000000666707723eULL, 0x000fc400000000ffULL, 0x000054105c087816ULL, 0x144fe40000000060ULL,
0x000076325c097816ULL, 0x000fca0000000060ULL, 0x000800080e007388ULL, 0x0003e80000000a00ULL,
0x0008001410007388ULL, 0x0005e20000000a00ULL, 0x0000006a6b08723eULL, 0x002fe400000000ffULL,
0x0000541002147816ULL, 0x144fe40000000004ULL, 0x0000763202157816ULL, 0x000fe40000000004ULL,
0x0000005e5f02723eULL, 0x000fc400000000ffULL, 0x000000626304723eULL, 0x000fe200000000ffULL,
0x0000001418007388ULL, 0x0003e20000000a00ULL, 0x00005410072c7816ULL, 0x000fe40000000008ULL,
0x0000541002247816ULL, 0x140fe40000000004ULL, 0x0000763202257816ULL, 0x000fe20000000004ULL,
0x000000017b027824ULL, 0x000fe200078e0200ULL, 0x00007632072d7816ULL, 0x000fc60000000008ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x0000541005147816ULL, 0x142fe40000000006ULL,
0x0000763205157816ULL, 0x000fca0000000006ULL, 0x000c00140a007388ULL, 0x000fe80000000a00ULL,
0x000c00240e007388ULL, 0x000fe80000000a00ULL, 0x000c002c10007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002147984ULL, 0x000ea80000000c00ULL, 0x00080000021c7984ULL, 0x000ee80000000c00ULL,
0x000c000002247984ULL, 0x000ee80000000c00ULL, 0x0010000002087984ULL, 0x000ee80000000c00ULL,
0x0014000002187984ULL, 0x000ee80000000c00ULL, 0x0018000002207984ULL, 0x000ee80000000c00ULL,
0x001c000002287984ULL, 0x000ee20000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x008fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x000fc40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x0000000b07077230ULL, 0x000fe40000000000ULL,
0x0000000a06067230ULL, 0x000fe40000000000ULL, 0x0000000905057230ULL, 0x000fc40000000000ULL,
0x0000000804047230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fe40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x000fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0004001402007388ULL, 0x000fe20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x000fe40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0008001c02007388ULL, 0x000fe20000000c00ULL,
0x0000002925257230ULL, 0x000fc40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x000c002402007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fc80000011600ULL,
0x000000780700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107027824ULL, 0x100fe200078e0200ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000000112117812ULL, 0x000fe200078ec0ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000702057812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x00000007000e7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff805027812ULL, 0x000fe200078ef800ULL, 0x0000580000067ab9ULL, 0x000fc80000000800ULL,
0x0000001002047824ULL, 0x000fe400078e0203ULL, 0x000000207a027824ULL, 0x000fe400078e0207ULL,
0x0000000811077824ULL, 0x000fe200078e020eULL, 0x0000000004087984ULL, 0x0004e40000000c00ULL,
0x0000000502067c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe20000011602ULL,
0x00000006040472a4ULL, 0x002fc4000f8e023fULL, 0x0000000179067824ULL, 0x000fc800078e0206ULL,
0x0000008605057224ULL, 0x000fe200078e0206ULL, 0x0000002000067810ULL, 0x000fe20007ffe0ffULL,
0x0000000486027c24ULL, 0x000fc6000f8e02ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011606ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x004fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440cULL,
0x000000780d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0083ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe200078e020dULL, 0x00000040000c7810ULL, 0x000fe20007ffe0ffULL,
0x000000207a0d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000179047824ULL, 0x000fc800078e0204ULL, 0x000000860d0d7224ULL, 0x000fe400078e0204ULL,
0x0000000811077824ULL, 0x002fc600078e0206ULL, 0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000d047a11ULL, 0x000fc800078040ffULL,
0x00005d000d057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0d7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000780d00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe400078e020dULL, 0x000000207a0d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000179047824ULL, 0x000fc800078e0204ULL, 0x000000860d0d7224ULL, 0x000fca00078e0204ULL,
0x0000000d02057210ULL, 0x000fe40007f1e0ffULL, 0x00000060000d7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x040fe400078040ffULL,
0x00000003ff0f7819ULL, 0x000fe4000001160dULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000780f00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e020fULL, 0x0000008000077810ULL, 0x000fe20007ffe0ffULL,
0x000000207a0f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000179047824ULL, 0x000fc800078e0204ULL,
0x000000860f0f7224ULL, 0x000fca00078e0204ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440cULL, 0x00000003ff0f7819ULL, 0x000fc60000011607ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x000000780f00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0023f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107047824ULL, 0x102fe200078e020fULL, 0x000000a0000c7810ULL, 0x000fe20007ffe0ffULL,
0x000000207a0f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0d7819ULL, 0x000fe4000001160cULL, 0x0ffffff804047812ULL, 0x000fe400078ef807ULL,
0x0000000707077812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e0207ULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000179047824ULL, 0x000fc800078e0204ULL, 0x000000860f0f7224ULL, 0x000fca00078e0204ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440eULL,
0x000000780d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe400078e020dULL, 0x000000207a0d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000179047824ULL, 0x000fc800078e0204ULL, 0x000000860d0d7224ULL, 0x000fca00078e0204ULL,
0x0000000d02057210ULL, 0x000fe40007f1e0ffULL, 0x000000c0000d7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x040fe400078040ffULL,
0x00000003ff0f7819ULL, 0x000fe4000001160dULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000780f00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e020fULL, 0x000000e000007810ULL, 0x000fe20007ffe0ffULL,
0x000000207a0f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x00000003ff077819ULL, 0x000fe40000011600ULL, 0x0ffffff804047812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000179047824ULL, 0x000fc800078e0204ULL, 0x000000860f0f7224ULL, 0x000fe400078e0204ULL,
0x0000000100067824ULL, 0x002fc600078e0207ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440cULL, 0x000000780700720cULL, 0x000fc60003f06070ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x00000007060d7812ULL, 0x000fc800078ec0ffULL,
0xfffffff80d067812ULL, 0x000fe200078ef800ULL, 0x0000000804007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000207a077824ULL, 0x000fc600078e0207ULL,
0x0000000006087984ULL, 0x002e620000000c00ULL, 0x0000000811057824ULL, 0x000fe200078e0200ULL,
0x0000000507047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fc60000011607ULL,
0x0000000179047824ULL, 0x000fc800078e0204ULL, 0x0000008607077224ULL, 0x000fca00078e0204ULL,
0x0000000702077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0007027a11ULL, 0x000fc800078040ffULL, 0x00005d0007037a11ULL, 0x000fca00000f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000f1200720cULL, 0x000fe20003f06070ULL,
0xffffffffff0d7424ULL, 0x000fd800078e00ffULL, 0x0000000204038824ULL, 0x000fc800078e00ffULL,
0x0000680003088a24ULL, 0x000fc800078e0212ULL, 0x0000640008088625ULL, 0x000fe200078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff687624ULL, 0x000fe200078e00ffULL,
0x00000008080d8981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff697624ULL, 0x000fc600078e00ffULL,
0x01260000ff067f8cULL, 0x002e68000c80043fULL, 0x0000000868687981ULL, 0x000722000c1e9900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x00000040140c7824ULL, 0x000fe400078e00ffULL,
0x0000004012037824ULL, 0x000fe400078e00ffULL, 0x000000400b027824ULL, 0x000fc400078e00ffULL,
0x0000000c0d257224ULL, 0x004fcc00078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x00afe40000011611ULL, 0x0000620025237a11ULL, 0x000fe400078038ffULL,
0x00000011111a7211ULL, 0x000fe200078fe8ffULL, 0x000000400b1f7824ULL, 0x000fe200078e0226ULL,
0x0000630025257a11ULL, 0x000fe400000f3cffULL, 0x000000031a1e7812ULL, 0x000fe200078ec0ffULL,
0x000000801f087825ULL, 0x040fe200078e00ffULL, 0x000000101f147810ULL, 0x000fc40007ffe0ffULL,
0x000000081f0a7810ULL, 0x000fe40007ffe0ffULL, 0x0000003008167812ULL, 0x100fe200078ef805ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000310087217ULL, 0x000fe40007800000ULL,
0x0000001623167210ULL, 0x000fe20007f1e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003014147812ULL, 0x000fe400078ef805ULL, 0x0000000826227810ULL, 0x000fe20007ffe0ffULL,
0x0000000109177824ULL, 0x000fe200000e0625ULL, 0x000000181f097810ULL, 0x000fe20007ffe0ffULL,
0x0000000108137824ULL, 0x000fe200078e0a03ULL, 0x0000002314147210ULL, 0x000fe20007f5e0ffULL,
0x0000000422217824ULL, 0x000fe200078e00ffULL, 0x000000300a187812ULL, 0x000fe200078ef805ULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x000000201f0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000002318187210ULL, 0x000fe20007f3e0ffULL, 0x0000000115157824ULL, 0x000fe200010e0625ULL,
0x00000030081a7812ULL, 0x000fe400078ef805ULL, 0x000000132600720cULL, 0x000fe20003f06070ULL,
0x000000010b197824ULL, 0x100fe200008e0625ULL, 0x000000231a1a7210ULL, 0x000fe20007f5e0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000281f087810ULL, 0x000fe40007ffe0ffULL,
0x0000200012207811ULL, 0x000fe200078e68ffULL, 0x00000001091b7824ULL, 0x000fe200010e0625ULL,
0x0ffffffc1e117812ULL, 0x000fe200078ef811ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000132200720cULL, 0x000fc40003f26070ULL, 0xfffffffc21217812ULL, 0x000fe200078ee21eULL,
0x0000001011117824ULL, 0x100fe200078e0220ULL, 0x000000300a1c7812ULL, 0x100fe400078ef805ULL,
0x0000003008087812ULL, 0x000fe200078ef805ULL, 0x0000001021217824ULL, 0x000fe200078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016117faeULL, 0x0003e2000c101c48ULL,
0x000000231c1c7210ULL, 0x000fe40007f7e0ffULL, 0x00000020260a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000018217faeULL, 0x0005e2000c901c48ULL, 0x000000010b1d7824ULL, 0x000fe200018e0625ULL,
0x0000001026287810ULL, 0x000fc40007ffe0ffULL, 0x00000018262a7810ULL, 0x040fe40007ffe0ffULL,
0x0000002826227810ULL, 0x000fe20007ffe0ffULL, 0x0000000428117824ULL, 0x002fe200078e00ffULL,
0x0000002308167210ULL, 0x000fe40007fde0ffULL, 0x000000301f087810ULL, 0x000fe40007ffe0ffULL,
0x0000003026247810ULL, 0x000fe20007ffe0ffULL, 0x0000000109177824ULL, 0x000fe200030e0625ULL,
0x000000130a00720cULL, 0x040fe20003f66070ULL, 0x000000040a197824ULL, 0x004fe200078e00ffULL,
0x0000003826267810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000381f0a7810ULL, 0x000fc40007ffe0ffULL, 0x000000132800720cULL, 0x080fe20003fa6070ULL,
0x0000000422217824ULL, 0x000fe200078e00ffULL, 0x000000132a00720cULL, 0x080fe20003f86070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000132200720cULL, 0x080fe40003f46070ULL,
0x000000132400720cULL, 0x0c0fe20003f26070ULL, 0x0000000424277824ULL, 0x000fe200078e00ffULL,
0x000000132600720cULL, 0x000fe20003f06070ULL, 0x000000042a137824ULL, 0x000fe200078e00ffULL,
0x0000003008087812ULL, 0x000fe200078ef805ULL, 0x0000000426297824ULL, 0x000fe200078e00ffULL,
0xfffffffc11117812ULL, 0x000fc400078ee21eULL, 0x0000002308087210ULL, 0x080fe40007fde0ffULL,
0xfffffffc13137812ULL, 0x000fe200078ee21eULL, 0x0000001011117824ULL, 0x000fe200078e0220ULL,
0x000000300a0a7812ULL, 0x000fe200078ef805ULL, 0x0000000109097824ULL, 0x000fe200030e0625ULL,
0xfffffffc19197812ULL, 0x000fe200078ee21eULL, 0x0000001013137824ULL, 0x000fe200078e0220ULL,
0xfffffffc211f7812ULL, 0x100fe200078ee21eULL, 0x0000000014117faeULL, 0x0003e2000e901c48ULL,
0xfffffffc27057812ULL, 0x000fe200078ee21eULL, 0x0000001019197824ULL, 0x000fe200078e0220ULL,
0xfffffffc29217812ULL, 0x000fe200078ee21eULL, 0x000000101f1f7824ULL, 0x100fe200078e0220ULL,
0x000000230a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001005057824ULL, 0x100fe200078e0220ULL,
0x000000001a137faeULL, 0x0003e2000e101c48ULL, 0x0000001021217824ULL, 0x000fc400078e0220ULL,
0x000000010b0b7824ULL, 0x000fe200030e0625ULL, 0x000000001c197faeULL, 0x0003e8000d901c48ULL,
0x00000000161f7faeULL, 0x0003e8000d101c48ULL, 0x0000000008057faeULL, 0x0003e8000c901c48ULL,
0x000000000a217faeULL, 0x0003e2000c101c48ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x0000000211087211ULL, 0x04afe400078ff0ffULL, 0x0000001111097211ULL, 0x000fc400078fe8ffULL,
0x00000008111d7811ULL, 0x040fe400078ff0ffULL, 0x0000003011197811ULL, 0x040fe400078ff0ffULL,
0x0000001011317811ULL, 0x000fe200078ff0ffULL, 0x000000041d0b7824ULL, 0x000fe200078e00ffULL,
0x0000001811337811ULL, 0x000fe200078ff0ffULL, 0x0000000419277824ULL, 0x000fe200078e00ffULL,
0x0000002011157811ULL, 0x000fe200078ff0ffULL, 0x0000000431137824ULL, 0x000fe200078e00ffULL,
0x0000002811177811ULL, 0x000fe200078ff0ffULL, 0x00000004331f7824ULL, 0x000fe200078e00ffULL,
0x00000038111b7811ULL, 0x000fe200078ff0ffULL, 0x0000000415217824ULL, 0x000fe200078e00ffULL,
0x00000003091a7812ULL, 0x000fe200078ec0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00006200252b7a11ULL, 0x000fc400078038ffULL, 0x0000200012297811ULL, 0x000fe200078e68ffULL,
0x0000000417237824ULL, 0x000fe200078e00ffULL, 0x00000030081e7812ULL, 0x000fe200078ef805ULL,
0x000000041b2d7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc1a117812ULL, 0x000fe200078ef811ULL,
0x00000001021c7824ULL, 0x000fe200078e021bULL, 0xfffffffc0b0a7812ULL, 0x100fe400078ee21aULL,
0xfffffffc27087812ULL, 0x100fe200078ee21aULL, 0x00000010112f7824ULL, 0x100fe200078e0229ULL,
0xfffffffc130b7812ULL, 0x100fe200078ee21aULL, 0x000000100a117824ULL, 0x100fe200078e0229ULL,
0xfffffffc1f147812ULL, 0x100fe200078ee21aULL, 0x0000001008277824ULL, 0x000fe200078e0229ULL,
0xfffffffc21167812ULL, 0x100fe200078ee21aULL, 0x0000000102087824ULL, 0x000fe200078e021dULL,
0xfffffffc23187812ULL, 0x100fe200078ee21aULL, 0x0000001014217824ULL, 0x000fe200078e0229ULL,
0xfffffffc2d1a7812ULL, 0x000fe200078ee21aULL, 0x00000001020a7824ULL, 0x000fe200078e0231ULL,
0x00006300252d7a11ULL, 0x000fe200000f3cffULL, 0x0000001016237824ULL, 0x000fe200078e0229ULL,
0x0000001e2b1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000102147824ULL, 0x000fc400078e0233ULL,
0x000000100b137824ULL, 0x100fe400078e0229ULL, 0x0000001018257824ULL, 0x000fe400078e0229ULL,
0x00000001091f7824ULL, 0x000fe400000e062dULL, 0x0000000102167824ULL, 0x000fe400078e0215ULL,
0x000000101a297824ULL, 0x000fe200078e0229ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e2f7faeULL, 0x0003e2000b901c48ULL, 0x0000000102187824ULL, 0x000fc400078e0217ULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x00000001021a7824ULL, 0x000fe200078e0219ULL,
0x0000003008087812ULL, 0x000fe200078ef805ULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x000000082b087210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000300a0a7812ULL, 0x000fc600078ef805ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003014147812ULL, 0x100fe400078ef805ULL, 0x0000000a2b0a7210ULL, 0x040fe20007f3e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000003016167812ULL, 0x100fe400078ef805ULL,
0x000000142b147210ULL, 0x040fe20007f5e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000003018187812ULL, 0x100fe400078ef805ULL, 0x000000162b167210ULL, 0x000fe20007f7e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000301a1a7812ULL, 0x000fc400078ef805ULL,
0x000000182b187210ULL, 0x000fe20007f9e0ffULL, 0x0000000109097824ULL, 0x000fe200000e062dULL,
0x000000301c057812ULL, 0x000fe200078ef805ULL, 0x000000010b0b7824ULL, 0x100fe200008e062dULL,
0x0000001a2b1a7210ULL, 0x000fe20007fbe0ffULL, 0x0000000115157824ULL, 0x100fe200010e062dULL,
0x000000052b1c7210ULL, 0x000fe20007fde0ffULL, 0x0000000117177824ULL, 0x100fe200018e062dULL,
0x0000000008117faeULL, 0x0003e2000b901c48ULL, 0x0000000119197824ULL, 0x100fe400020e062dULL,
0x000000011b1b7824ULL, 0x100fe200028e062dULL, 0x000000000a137faeULL, 0x0003e2000b901c48ULL,
0x000000011d1d7824ULL, 0x000fc600030e062dULL, 0x0000000014217faeULL, 0x0003e8000b901c48ULL,
0x0000000016237faeULL, 0x0003e8000b901c48ULL, 0x0000000018257faeULL, 0x0003e8000b901c48ULL,
0x000000001a277faeULL, 0x0003e8000b901c48ULL, 0x000000001c297faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140bULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002012057824ULL, 0x002fca00078e0205ULL,
0x00000004ff067819ULL, 0x000fe40000011605ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL, 0x0000001f05067812ULL, 0x000fc600078ec0ffULL,
0x00000001080a7824ULL, 0x040fe400078e0207ULL, 0x0000000105097824ULL, 0x000fe200078e0208ULL,
0x0000000808087810ULL, 0x000fe20007ffe0ffULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000001006147824ULL, 0x000fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x000fe200078e0208ULL,
0x000001f00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000000105057824ULL, 0x000fe200078e0208ULL,
0x000001f014097812ULL, 0x000fe200078ee209ULL, 0x0000001006087824ULL, 0x040fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x000000000a147984ULL, 0x000e62000000cc00ULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000f05057812ULL, 0x000fc400078ec0ffULL,
0x0000000009187984ULL, 0x000ea4000000cc00ULL, 0x000001f006077812ULL, 0x000fe400078ee207ULL,
0x000001f008057812ULL, 0x000fe200078ee205ULL, 0x000000ffff1e7224ULL, 0x002fe400078e0014ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff1c7224ULL, 0x004fe400078e0018ULL,
0x000000ffff1d7224ULL, 0x000fc400078e001aULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff237224ULL, 0x000fe200078e0017ULL, 0x0000001c09007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0019ULL, 0x000000ffff217224ULL, 0x000fca00078e001bULL,
0x000000200a007388ULL, 0x000fe8000000cc00ULL, 0x0000000007147984ULL, 0x000e68000000cc00ULL,
0x0000000005187984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e0016ULL,
0x000000ffff267224ULL, 0x000fc400078e0014ULL, 0x000000ffff167224ULL, 0x000fe400078e0015ULL,
0x000000ffff247224ULL, 0x004fe400078e0018ULL, 0x000000ffff257224ULL, 0x000fe400078e001aULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x000000ffff157224ULL, 0x000fe200078e001bULL,
0x0000002405007388ULL, 0x0003e8000000cc00ULL, 0x0000001407007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01260000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff117224ULL, 0x000fc600078e00ffULL, 0x0000000000067805ULL, 0x002fc80000015200ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011409ULL, 0x0000000805057211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000205057819ULL, 0x000fc80000001208ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x00005800ff617624ULL, 0x000fe200078e00ffULL, 0x8000580010607a10ULL, 0x000fe20007ffe0ffULL,
0x0000680004697a24ULL, 0x000fe200078e02ffULL, 0x3db504f368687820ULL, 0x010fe20000410000ULL,
0x0001268812677811ULL, 0x000fe200078e18ffULL, 0x000000ffff657224ULL, 0x000fe200078e00ffULL,
0x0000001f61047810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff637224ULL, 0x000fe200078e00ffULL,
0xffffffff61627810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff647224ULL, 0x000fe200078e0012ULL,
0x00000004ff047819ULL, 0x000fc40000011604ULL, 0x0001260812667811ULL, 0x000fe400078e28ffULL,
0x0000000961617810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x0ffffffe04137812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x000fe200078e0063ULL, 0x0000000000167805ULL, 0x008fe2000001ff00ULL,
0x000000ffff6a7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x014fc4000001ff00ULL,
0x000000016a00780cULL, 0x040fe20003f25270ULL, 0x00000c0000007945ULL, 0x000fe20003800000ULL,
0x0000000165067810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6c7224ULL, 0x000fe200078e006aULL,
0x000000016a057810ULL, 0x000fe20007ffe0ffULL, 0x0000000c0d5e7224ULL, 0x030fe200078e02ffULL,
0x000000016b637812ULL, 0x000fc400078e0cffULL, 0x000000020500780cULL, 0x040fe20003f06070ULL,
0x000000ffff6a7224ULL, 0x000fe200078e0005ULL, 0x000000ff05047207ULL, 0x000fc60000800000ULL,
0x000000ffff061224ULL, 0x000fca00078e0265ULL, 0x0000000106077810ULL, 0x000fc80007ffe0ffULL,
0x0000000e0700720cULL, 0x000fda0003f46070ULL, 0x000006000000a947ULL, 0x000fea0003800000ULL,
0x0000001011057824ULL, 0x002fe200078e00ffULL, 0x00000002ff6d7819ULL, 0x000fe40000011611ULL,
0x000062005e737a11ULL, 0x000fe400078238ffULL, 0x0000003005077812ULL, 0x000fe200078ec0ffULL,
0x0000010006057824ULL, 0x000fe200078e0203ULL, 0x000000086d5b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102517824ULL, 0x000fe200078e026dULL, 0x000000106d6f7810ULL, 0x040fe20007ffe0ffULL,
0x0000004004067824ULL, 0x000fe200078e0207ULL, 0x000063005e757a11ULL, 0x000fe200008f3cffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000510547217ULL, 0x000fe20007800000ULL,
0x0000000102537824ULL, 0x000fe200078e025bULL, 0x000000186d707810ULL, 0x000fe20007ffe0ffULL,
0x0000008051507825ULL, 0x000fe200078e0006ULL, 0x000000206d727810ULL, 0x000fc40007ffe0ffULL,
0x000000286d747810ULL, 0x000fe20007ffe0ffULL, 0x0000008053527825ULL, 0x000fe200078e0006ULL,
0x0000007350567210ULL, 0x000fe40007f3e0ffULL, 0x0000001111507211ULL, 0x000fe200078fe8ffULL,
0x0000000102557824ULL, 0x000fe200078e026fULL, 0x0000007352587210ULL, 0x000fe20007f5e0ffULL,
0x0000000154057824ULL, 0x000fe200078e0a05ULL, 0x00000003506e7812ULL, 0x000fe200078ec0ffULL,
0x0000000151577824ULL, 0x000fe200008e0675ULL, 0x000000306d767810ULL, 0x000fe20007ffe0ffULL,
0x0000008055547825ULL, 0x000fe200078e0006ULL, 0x0ffffffc6e5f7812ULL, 0x000fc400078ef811ULL,
0x000000386d777810ULL, 0x000fe20007ffe0ffULL, 0x0000000102517824ULL, 0x000fe200078e0270ULL,
0x0000007354547210ULL, 0x000fe20007f3e0ffULL, 0x0000000153597824ULL, 0x000fe200010e0675ULL,
0x000000055b00720cULL, 0x080fe20003f46070ULL, 0x0000008051507825ULL, 0x000fe200078e0006ULL,
0x000000057000720cULL, 0x000fc60003fa6070ULL, 0x0000000102537824ULL, 0x000fe200078e0272ULL,
0x00000073505a7210ULL, 0x000fe20007f7e0ffULL, 0x00000002125e7824ULL, 0x000fe400078e0263ULL,
0x0000008053527825ULL, 0x000fc600078e0006ULL, 0x000020005e5e7811ULL, 0x000fe200078e60ffULL,
0x0000000155557824ULL, 0x100fe200008e0675ULL, 0x000000056d00720cULL, 0x000fe20003f26070ULL,
0x000000045b717824ULL, 0x000fe200078e00ffULL, 0x00000073525c7210ULL, 0x000fe20007f9e0ffULL,
0x00000001515b7824ULL, 0x100fe200018e0675ULL, 0x000000056f00720cULL, 0x080fe20003f66070ULL,
0x000000105f517824ULL, 0x000fe400078e025eULL, 0x000000046f5f7824ULL, 0x000fe400078e00ffULL,
0x00000001535d7824ULL, 0x000fe200020e0675ULL, 0xfffffffc71537812ULL, 0x000fe200078ee26eULL,
0x00000001026d7824ULL, 0x040fe200078e0274ULL, 0xfffffffc5f5f7812ULL, 0x000fe200078ee26eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000056517faeULL, 0x0003e2000c901c48ULL,
0x00000001026f7824ULL, 0x000fe200078e0276ULL, 0x000000057200720cULL, 0x080fe20003f86070ULL,
0x0000001053537824ULL, 0x100fe200078e025eULL, 0x000000057700720cULL, 0x000fe20003f26070ULL,
0x000000105f5f7824ULL, 0x000fc400078e025eULL, 0x0000000102717824ULL, 0x000fe200078e0277ULL,
0x0000000058537faeULL, 0x0005e2000d101c48ULL, 0x000000057600720cULL, 0x080fe20003f46070ULL,
0x000000806d507825ULL, 0x102fe400078e0006ULL, 0x00000000545f7faeULL, 0x0003e2000d901c48ULL,
0x000000057400720cULL, 0x000fe20003f66070ULL, 0x0000000470057824ULL, 0x000fe200078e00ffULL,
0x0000007350507210ULL, 0x000fe20007fde0ffULL, 0x0000000474577824ULL, 0x000fe400078e00ffULL,
0x000000806f527825ULL, 0x004fe200078e0006ULL, 0xfffffffc05057812ULL, 0x000fc400078ee26eULL,
0xfffffffc57577812ULL, 0x000fe200078ee26eULL, 0x0000000151517824ULL, 0x000fe200030e0675ULL,
0x0000007352527210ULL, 0x000fe20007fde0ffULL, 0x0000000472557824ULL, 0x002fe400078e00ffULL,
0x0000000476597824ULL, 0x000fe400078e00ffULL, 0x0000008071067825ULL, 0x000fe200078e0006ULL,
0xfffffffc55557812ULL, 0x100fe400078ee26eULL, 0xfffffffc59597812ULL, 0x000fe200078ee26eULL,
0x00000004775f7824ULL, 0x000fc400078e00ffULL, 0x0000000153537824ULL, 0x100fe200030e0675ULL,
0x0000007306067210ULL, 0x000fe20007fde0ffULL, 0x0000001005057824ULL, 0x000fe200078e025eULL,
0xfffffffc5f5f7812ULL, 0x000fe200078ee26eULL, 0x0000001055557824ULL, 0x100fe400078e025eULL,
0x0000001057577824ULL, 0x100fe200078e025eULL, 0x000000005a057faeULL, 0x0003e2000e901c48ULL,
0x0000001059597824ULL, 0x100fe400078e025eULL, 0x000000105f5f7824ULL, 0x000fe200078e025eULL,
0x000000005c557faeULL, 0x0003e2000e101c48ULL, 0x0000000107077824ULL, 0x000fc600030e0675ULL,
0x0000000050577faeULL, 0x0003e8000d901c48ULL, 0x0000000052597faeULL, 0x0003e8000d101c48ULL,
0x00000000065f7faeULL, 0x0003e2000c901c48ULL, 0x0000053000007947ULL, 0x000fea0003800000ULL,
0x0000000212077824ULL, 0x000fe200078e0263ULL, 0x0000000811517811ULL, 0x002fc400078ff0ffULL,
0x0000001011537811ULL, 0x040fe400078ff0ffULL, 0x0000001811557811ULL, 0x040fe400078ff0ffULL,
0x0000002011577811ULL, 0x000fe200078ff0ffULL, 0x00000004535f7824ULL, 0x000fe200078e00ffULL,
0x0000002811597811ULL, 0x000fe200078ff0ffULL, 0x00000004556d7824ULL, 0x000fe200078e00ffULL,
0x00000030115b7811ULL, 0x000fe200078ff0ffULL, 0x00000004576f7824ULL, 0x000fe200078e00ffULL,
0x0000003811797811ULL, 0x000fe200078ff0ffULL, 0x0000000459717824ULL, 0x000fe200078e00ffULL,
0x0000001111057211ULL, 0x000fe200078fe8ffULL, 0x000000045b737824ULL, 0x000fe200078e00ffULL,
0x0000200007507811ULL, 0x000fe200078e60ffULL, 0x0000000451077824ULL, 0x000fe200078e00ffULL,
0x0000000305067812ULL, 0x000fe200078ec0ffULL, 0x0000000479757824ULL, 0x000fe200078e00ffULL,
0x000062005e777a11ULL, 0x000fe200078238ffULL, 0x0000000102517824ULL, 0x040fe200078e0251ULL,
0xfffffffc07077812ULL, 0x100fe200078ee206ULL, 0x0000000102537824ULL, 0x040fe200078e0253ULL,
0xfffffffc5f5f7812ULL, 0x100fe200078ee206ULL, 0x0000000102557824ULL, 0x040fe200078e0255ULL,
0xfffffffc6d6d7812ULL, 0x100fe200078ee206ULL, 0x0000000102577824ULL, 0x040fe200078e0257ULL,
0xfffffffc6f6f7812ULL, 0x100fe200078ee206ULL, 0x0000000102597824ULL, 0x040fe200078e0259ULL,
0xfffffffc71717812ULL, 0x100fe200078ee206ULL, 0x00000001025b7824ULL, 0x000fe200078e025bULL,
0x0ffffffc06057812ULL, 0x000fe200078ef811ULL, 0x0000000102797824ULL, 0x000fe200078e0279ULL,
0xfffffffc73737812ULL, 0x000fe200078ee206ULL, 0x000000105f5f7824ULL, 0x000fe200078e0250ULL,
0xfffffffc75757812ULL, 0x000fe200078ee206ULL, 0x0000001011067824ULL, 0x000fc400078e00ffULL,
0x00000010057b7824ULL, 0x100fe400078e0250ULL, 0x0000001007057824ULL, 0x100fe200078e0250ULL,
0x00000030065d7812ULL, 0x000fe200078ec0ffULL, 0x000000106d6d7824ULL, 0x100fe200078e0250ULL,
0x0000000211077211ULL, 0x000fe200078ff0ffULL, 0x000000106f6f7824ULL, 0x000fe400078e0250ULL,
0x00000040045c7824ULL, 0x000fe400078e025dULL, 0x000000ffff5d7224ULL, 0x000fc400078e00ffULL,
0x0000001071717824ULL, 0x100fe400078e0250ULL, 0x0000001073737824ULL, 0x100fe400078e0250ULL,
0x0000001075757824ULL, 0x000fe400078e0250ULL, 0x0000008007067825ULL, 0x000fc800078e005cULL,
0x0000008051507825ULL, 0x000fc800078e005cULL, 0x0000008053527825ULL, 0x000fe200078e005cULL,
0x0000007750507210ULL, 0x000fc60007f5e0ffULL, 0x0000008055547825ULL, 0x000fe200078e005cULL,
0x0000007752527210ULL, 0x000fc60007f7e0ffULL, 0x0000008057567825ULL, 0x000fe200078e005cULL,
0x0000007754547210ULL, 0x000fc60007f9e0ffULL, 0x0000008059587825ULL, 0x000fc800078e005cULL,
0x000000805b5a7825ULL, 0x000fc800078e005cULL, 0x00000080795c7825ULL, 0x000fe200078e005cULL,
0x000063005e797a11ULL, 0x000fe400008f3cffULL, 0x0000007706067210ULL, 0x000fc60007f3e0ffULL,
0x0000000151517824ULL, 0x100fe200010e0679ULL, 0x0000007758587210ULL, 0x080fe20007f5e0ffULL,
0x0000000107077824ULL, 0x100fe200008e0679ULL, 0x0000007756567210ULL, 0x080fe20007f3e0ffULL,
0x0000000153537824ULL, 0x100fe200018e0679ULL, 0x000000775a5a7210ULL, 0x080fe20007f7e0ffULL,
0x0000000155557824ULL, 0x100fe200020e0679ULL, 0x000000775c5c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000157577824ULL, 0x100fe200008e0679ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000067b7faeULL, 0x0003e2000b901c48ULL, 0x0000000159597824ULL, 0x000fc400010e0679ULL,
0x000000015b5b7824ULL, 0x100fe200018e0679ULL, 0x0000000050057faeULL, 0x0003e2000b901c48ULL,
0x000000015d5d7824ULL, 0x000fc600020e0679ULL, 0x00000000525f7faeULL, 0x0003e8000b901c48ULL,
0x00000000546d7faeULL, 0x0003e8000b901c48ULL, 0x00000000566f7faeULL, 0x0003e8000b901c48ULL,
0x0000000058717faeULL, 0x0003e8000b901c48ULL, 0x000000005a737faeULL, 0x0003e8000b901c48ULL,
0x000000005c757faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010400780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000464647810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0d7424ULL, 0x000fc600078e00ffULL, 0x0000000f6400720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000269047824ULL, 0x000fe400078e0264ULL,
0x00000004ff057424ULL, 0x002fc800078e00ffULL, 0x0000640004047625ULL, 0x000fca00078e0005ULL,
0x00000008040d7981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000086c707824ULL, 0x000fe400078e00ffULL,
0x000000ffff797224ULL, 0x000fe400078e00ffULL, 0x00000010ff6f7424ULL, 0x002fe200078e00ffULL,
0x00000012706e7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff6d7224ULL, 0x000fe200078e00ffULL,
0x0000000270707810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff811047812ULL, 0x000fe200078ec0ffULL, 0x0000000212517824ULL, 0x020fe200078e026bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000016d5f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000704507812ULL, 0x000fe400078ef811ULL, 0x0000200051517811ULL, 0x000fe400078e60ffULL,
0x00000001ff527819ULL, 0x000fe20000011650ULL, 0x0000000450057824ULL, 0x040fe400078e00ffULL,
0x0000000450537824ULL, 0x000fe400078e00ffULL, 0x0000000152047824ULL, 0x040fe400078e026dULL,
0x0000000152527824ULL, 0x000fc600078e025fULL, 0xfffffffc05047812ULL, 0x000fe400078ee204ULL,
0xfffffffc53527812ULL, 0x000fc600078ee252ULL, 0x0000001004047824ULL, 0x100fe400078e0251ULL,
0x0000001052527824ULL, 0x000fc800078e0251ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x000000005258783bULL, 0x0004e20000000200ULL, 0x00000018ff507819ULL, 0x002fe20000011404ULL,
0x0001000004527824ULL, 0x044fe200078e00ffULL, 0x0000888004537816ULL, 0x040fe200000000ffULL,
0x0000010004547824ULL, 0x000fe200078e00ffULL, 0x00000050008f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff887819ULL, 0x000fe20000011405ULL, 0x00010000055e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fc40000011452ULL, 0x00000018ff5d7819ULL, 0x000fe40000011454ULL,
0x00000018ff727819ULL, 0x008fe20000011458ULL, 0x00000053008d7306ULL, 0x0005e20000200c00ULL,
0x0000002011507810ULL, 0x002fe40007ffe0ffULL, 0x00000018ff717819ULL, 0x000fe40000011459ULL,
0xfffffff850507812ULL, 0x000fe400078ec0ffULL, 0x0000888058757816ULL, 0x000fe200000000ffULL,
0x0000005c008e7306ULL, 0x0002e20000200c00ULL, 0x0000000750507812ULL, 0x000fc400078ef811ULL,
0x0000888005537816ULL, 0x044fe200000000ffULL, 0x0000010005057824ULL, 0x000fe200078e00ffULL,
0x00000001ff527819ULL, 0x000fe20000011650ULL, 0x0000000450557824ULL, 0x000fe200078e00ffULL,
0x0000888059787816ULL, 0x000fe200000000ffULL, 0x0000005300917306ULL, 0x0005e20000200c00ULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x0000000152047824ULL, 0x000fe200078e026dULL,
0x00008880065c7816ULL, 0x002fe200000000ffULL, 0x0000000152527824ULL, 0x000fe200078e025fULL,
0x00000018ff5e7819ULL, 0x000fc4000001145eULL, 0xfffffffc55047812ULL, 0x000fe200078ee204ULL,
0x0000000500937306ULL, 0x0003e20000200c00ULL, 0x000000086c537824ULL, 0x004fe200078e026fULL,
0x00000018ff847819ULL, 0x000fe40000011407ULL, 0x0000001004047824ULL, 0x000fe200078e0251ULL,
0x0000888007897816ULL, 0x000fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe2000001145aULL,
0x0000005c00947306ULL, 0x000fe20000200c00ULL, 0x000000000454783bULL, 0x0004e20000000200ULL,
0x0000000450057824ULL, 0x002fe200078e00ffULL, 0x000088805a7c7816ULL, 0x000fe200000000ffULL,
0x0001000059507824ULL, 0x040fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011406ULL,
0x0000010059597824ULL, 0x000fe200078e00ffULL, 0xfffffffc05527812ULL, 0x000fe200078ee252ULL,
0x0000005d00907306ULL, 0x0002e20000200c00ULL, 0x0001000007047824ULL, 0x044fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe20000011450ULL, 0x0000010007077824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc40000011459ULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x0000005e00927306ULL, 0x000ea20000200c00ULL, 0x00010000065d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff077819ULL, 0x000fe20000011407ULL, 0x0000010006067824ULL, 0x000fe200078e00ffULL,
0x000054108d8e7816ULL, 0x008fe4000000008eULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x00000004008a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff067819ULL, 0x000fc40000011406ULL,
0x00005410908f7816ULL, 0x000fe4000000008fULL, 0x00000018ff737819ULL, 0x000fe4000001145bULL,
0x000000026d6d7810ULL, 0x000fe20007ffe0ffULL, 0x0000005d00957306ULL, 0x000fe20000200c00ULL,
0x0001000058047824ULL, 0x042fe200078e00ffULL, 0x0000541091927816ULL, 0x004fe20000000092ULL,
0x0000010058587824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011404ULL,
0x0000001052047824ULL, 0x000fe200078e0251ULL, 0x0000000811527812ULL, 0x040fe200078ec0ffULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0001000054977824ULL, 0x000fe200078e00ffULL, 0x0000000711517812ULL, 0x000fe200078ec0ffULL,
0x0001000055907824ULL, 0x000fe200078e00ffULL, 0x0000005211507211ULL, 0x000fe400078fe0ffULL,
0x0000000752597812ULL, 0x000fe200078ef811ULL, 0x0000005800777306ULL, 0x0005e20000200c00ULL,
0x00000018ff867819ULL, 0x000fe20000011454ULL, 0x00000001518c7824ULL, 0x000fe200078e0250ULL,
0x00000018ff857819ULL, 0x000fe20000011455ULL, 0x000000086c517824ULL, 0x000fe200078e0279ULL,
0x0000888055987816ULL, 0x000fe200000000ffULL, 0x0000001059527824ULL, 0x040fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011456ULL, 0x000000018c517824ULL, 0x040fe200078e0251ULL,
0x0000001059587812ULL, 0x004fe200078efcffULL, 0x000000018c537824ULL, 0x000fe200078e0253ULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x000100005a507824ULL, 0x000fe200078e00ffULL,
0xfffffff052517812ULL, 0x000fe200078ee251ULL, 0x00000010585c7824ULL, 0x000fe200078e00ffULL,
0x0000541093937816ULL, 0x002fe20000000088ULL, 0x000001005a5a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011450ULL, 0x0000010055557824ULL, 0x000fe200078e00ffULL,
0xfffffff05c537812ULL, 0x000fe200078ee253ULL, 0x00000010515c7824ULL, 0x000fe200078e00ffULL,
0x00000007008b7306ULL, 0x000e620000200c00ULL, 0x00000018ff7f7819ULL, 0x000fe2000001145aULL,
0x000000ffff8d7224ULL, 0x000fe200078e0098ULL, 0x00008880545a7816ULL, 0x040fe200000000ffULL,
0x0000001053537824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000ea20000000200ULL,
0x0000010054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000008900897306ULL, 0x000ee20000200c00ULL, 0x0000888056887816ULL, 0x000fe200000000ffULL,
0x000000005350783bULL, 0x000ea20000000200ULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000001058587824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc40000011457ULL,
0x00000018ff977819ULL, 0x000fe20000011497ULL, 0x0000000600967306ULL, 0x0007e20000200c00ULL,
0x000054108b8b7816ULL, 0x002fe20000000084ULL, 0x0001000057847824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe40000011490ULL, 0x0000541094947816ULL, 0x000fe40000000095ULL,
0x00000018ff847819ULL, 0x000fe20000011484ULL, 0x0000005400997306ULL, 0x000fe20000200c00ULL,
0x000000000404783bULL, 0x008e620000000200ULL, 0x00005410898a7816ULL, 0x000fcc000000008aULL,
0x0000005500547306ULL, 0x0007f00000200c00ULL, 0x0000008700877306ULL, 0x000ea20000200c00ULL,
0x0000888057557816ULL, 0x048fe200000000ffULL, 0x0000010057577824ULL, 0x000fe200078e00ffULL,
0x0000008e5c4c723cULL, 0x084fe8000000184cULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000005a005a7306ULL, 0x000fe60000200c00ULL, 0x0000008e5008723cULL, 0x000bea0000001808ULL,
0x0000009700977306ULL, 0x000ea20000200c00ULL, 0x0000541096957816ULL, 0x000fc40000000087ULL,
0x000000708c877210ULL, 0x100fe20007ffe079ULL, 0x00010000568e7824ULL, 0x060fe200078e00ffULL,
0x0000008a5c20723cULL, 0x080fe20000001820ULL, 0x0000010056567824ULL, 0x000fe200078e00ffULL,
0x0000006e8c797210ULL, 0x000fe20007ffe079ULL, 0x0000008600867306ULL, 0x000ee20000200c00ULL,
0x00000018ff8e7819ULL, 0x000fe4000001148eULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000008a501c723cULL, 0x000be2000000181cULL, 0xfffffff058797812ULL, 0x000fc400078ee279ULL,
0x00000088008f7306ULL, 0x0005e20000200c00ULL, 0x00000018ff817819ULL, 0x002fe40000011404ULL,
0x0000001079587824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011405ULL,
0x000000925c34723cULL, 0x000fe20000001834ULL, 0x00000018ff797819ULL, 0x000fe40000011407ULL,
0x0000008e008e7306ULL, 0x000e620000200c00ULL, 0x000054105a887816ULL, 0x004fe20000000097ULL,
0x00000010595a7824ULL, 0x000fe200078e00ffULL, 0x0000541099897816ULL, 0x008fc40000000086ULL,
0x000088805b867816ULL, 0x000fe200000000ffULL, 0x000000945c38723cULL, 0x000f620000001838ULL,
0xfffffff05a877812ULL, 0x000fe200078ee287ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x00000018ff7e7819ULL, 0x000fe20000011406ULL, 0x000000ffff597224ULL, 0x000fc800078e0086ULL,
0x000000885c30723cULL, 0x000fe40000001830ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x000054108f8e7816ULL, 0x002fca000000008eULL, 0x000000925024723cULL, 0x000fe40000001824ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x0000541054857816ULL, 0x004fe20000000085ULL,
0x000100005b547824ULL, 0x000fc800078e00ffULL, 0x00000094503c723cULL, 0x000f62000000183cULL,
0x00000018ff867819ULL, 0x000fe20000011454ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x0000001087547824ULL, 0x000fca00078e00ffULL, 0x000000885048723cULL, 0x000fe40000001848ULL,
0x0000009000907306ULL, 0x000ff00000200c00ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000005500557306ULL, 0x000ff00000200c00ULL, 0x00000084008a7306ULL, 0x0204e20000200c00ULL,
0x00005410568f7816ULL, 0x002fce0000000083ULL, 0x00000057008b7306ULL, 0x0002620000200c00ULL,
0x000054108d847816ULL, 0x004fe20000000090ULL, 0x0000008e5c40723cULL, 0x040fec0000001840ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x00005410558a7816ULL, 0x008fe2000000008aULL,
0x000000845c2c723cULL, 0x080f62000000182cULL, 0x000000005454783bULL, 0x002e6a0000000200ULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x000054108b8b7816ULL, 0x000fe20000000082ULL,
0x000000845028723cULL, 0x000fec0000001828ULL, 0x0000007400747306ULL, 0x000fe40000200c00ULL,
0x0000008a5c44723cULL, 0x000b6c0000001844ULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x00008880045d7816ULL, 0x060fe200000000ffULL, 0x00010000045e7824ULL, 0x040fe200078e00ffULL,
0x00008880055f7816ULL, 0x000fe200000000ffULL, 0x0000010004047824ULL, 0x000fe200078e00ffULL,
0x0000008e5018723cULL, 0x000f620000001818ULL, 0x000001005b5c7824ULL, 0x000fe200078e00ffULL,
0x000054107c7c7816ULL, 0x004fe2000000007dULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00000018ff047819ULL, 0x000fc40000011404ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000008a5014723cULL, 0x000b620000001814ULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000054107f7d7816ULL, 0x008fe20000000074ULL,
0x0001000007747824ULL, 0x040fe400078e00ffULL, 0x000000ffff507224ULL, 0x020fe200078e005fULL,
0x00008880075f7816ULL, 0x000fe200000000ffULL, 0x0001000005517824ULL, 0x040fe200078e00ffULL,
0x0000888006527816ULL, 0x040fe200000000ffULL, 0x00000059008c7306ULL, 0x0007e20000200c00ULL,
0x0001000006537824ULL, 0x040fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000010005057824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000010007077824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000010006067824ULL, 0x000fe200078e00ffULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000000005858783bULL, 0x008ee20000000200ULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x0000007c5438723cULL, 0x002f620000001838ULL, 0x00000018ff077819ULL, 0x000fc40000011407ULL,
0x00000018ff067819ULL, 0x000fe40000011406ULL, 0x0000007a007a7306ULL, 0x000e620000200c00ULL,
0x0000541075767816ULL, 0x004fce0000000076ULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000000400047306ULL, 0x000ff00000200c00ULL, 0x0000007900827306ULL, 0x0003f00000200c00ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054107a797816ULL, 0x002fe20000000071ULL,
0x0000007c583c723cULL, 0x008f6c000000183cULL, 0x0000005000507306ULL, 0x000ff00000200c00ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x0000541077777816ULL, 0x004fce0000000072ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x00000076544c723cULL, 0x080f6e000000184cULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000541050507816ULL, 0x002fe20000000051ULL,
0x000000765808723cULL, 0x000f6c0000001808ULL, 0x0000005f00757306ULL, 0x0003f00000200c00ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x00005410045f7816ULL, 0x002fc40000000081ULL,
0x000000046f047810ULL, 0x000fe40007ffe0ffULL, 0x0000541052527816ULL, 0x004fe40000000053ULL,
0x000000180400780cULL, 0x000fe20003f25270ULL, 0x0000007300737306ULL, 0x000ff00000200c00ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x0000541075747816ULL, 0x008fce0000000074ULL,
0x0000007b007b7306ULL, 0x000e700000200c00ULL, 0x0000008000807306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x0000541078787816ULL, 0x002fce000000007bULL,
0x0000008600837306ULL, 0x000e620000200c00ULL, 0x000000785434723cULL, 0x080f6e0000001834ULL,
0x0000005c005c7306ULL, 0x000ea20000200c00ULL, 0x000000785824723cULL, 0x000b6e0000001824ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x000054108c727816ULL, 0x002fc40000000083ULL,
0xfffffff46f797810ULL, 0x020fe20007ffe0ffULL, 0x000000ffff6f7224ULL, 0x000fc800078e0004ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x000054105c737816ULL, 0x004fce0000000073ULL,
0x0000000500057306ULL, 0x000ea20000200c00ULL, 0x000000725420723cULL, 0x080b6e0000001820ULL,
0x0000000600717306ULL, 0x000ee20000200c00ULL, 0x000054105d5e7816ULL, 0x002fe2000000005eULL,
0x00000072581c723cULL, 0x000b6c000000181cULL, 0x0000000700077306ULL, 0x000e620000200c00ULL,
0x0000541005517816ULL, 0x004fe20000000080ULL, 0x0000005e5430723cULL, 0x000b620000001830ULL,
0x0000541071537816ULL, 0x008fce000000007eULL, 0x00000050542c723cULL, 0x000b62000000182cULL,
0x0000541007757816ULL, 0x002fce0000000082ULL, 0x000000525440723cULL, 0x040b700000001840ULL,
0x000000745444723cULL, 0x000b700000001844ULL, 0x0000005e5848723cULL, 0x040b700000001848ULL,
0x000000505828723cULL, 0x040b700000001828ULL, 0x000000525818723cULL, 0x040b700000001818ULL,
0x000000745814723cULL, 0x000b620000001814ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffedb000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff6b7224ULL, 0x000fe200078e0063ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe01000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000006832327220ULL, 0x0a0fe20000410000ULL, 0x0000006845457220ULL, 0x080fe20000410000ULL,
0x0000006836367220ULL, 0x080fe20000410000ULL, 0x0000006837377220ULL, 0x080fe20000410000ULL,
0x000000683a3a7220ULL, 0x080fe20000410000ULL, 0x000000683b3b7220ULL, 0x080fe20000410000ULL,
0x0000006833337220ULL, 0x080fe20000410000ULL, 0x0000006842427220ULL, 0x080fe20000410000ULL,
0x0000006844447220ULL, 0x080fe20000410000ULL, 0x0000006846467220ULL, 0x080fe20000410000ULL,
0x000000684e047220ULL, 0x080fe20000410000ULL, 0x000000684f057220ULL, 0x080fe20000410000ULL,
0x0000006838537220ULL, 0x080fe20000410000ULL, 0x0000006822227220ULL, 0x080fe20000410000ULL,
0x0000006823237220ULL, 0x080fe20000410000ULL, 0x000000682f067220ULL, 0x080fe20000410000ULL,
0x0000006843437220ULL, 0x080fe20000410000ULL, 0x0000006847077220ULL, 0x080fe20000410000ULL,
0x0000006824247220ULL, 0x080fe20000410000ULL, 0x0000006825257220ULL, 0x080fe20000410000ULL,
0x000000681c1c7220ULL, 0x080fe20000410000ULL, 0x000000681d1d7220ULL, 0x080fe20000410000ULL,
0x0000006818187220ULL, 0x080fe20000410000ULL, 0x0000006814147220ULL, 0x080fe20000410000ULL,
0x000000684c577220ULL, 0x080fe20000410000ULL, 0x0000006839527220ULL, 0x080fe20000410000ULL,
0x000000683c387220ULL, 0x080fe20000410000ULL, 0x000000684a5c7220ULL, 0x080fe20000410000ULL,
0x000000684d567220ULL, 0x080fe20000410000ULL, 0x0000006831507220ULL, 0x080fe20000410000ULL,
0x000000682c4f7220ULL, 0x080fe20000410000ULL, 0x000000682d4e7220ULL, 0x080fe20000410000ULL,
0x00000068414c7220ULL, 0x080fe20000410000ULL, 0x000000683d397220ULL, 0x080fe20000410000ULL,
0x00000068483c7220ULL, 0x080fe20000410000ULL, 0x000000684b5d7220ULL, 0x080fe20000410000ULL,
0x000000682b5f7220ULL, 0x080fe20000410000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e0045ULL,
0x0000006834557220ULL, 0x080fe20000410000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0032ULL,
0x0000006835547220ULL, 0x080fe20000410000ULL, 0x0000006820517220ULL, 0x080fe20000410000ULL,
0x0000006821587220ULL, 0x080fe20000410000ULL, 0x0000006830597220ULL, 0x080fe20000410000ULL,
0x000000682e317220ULL, 0x080fe20000410000ULL, 0x00000068404d7220ULL, 0x080fe20000410000ULL,
0x000000683e5a7220ULL, 0x080fe20000410000ULL, 0x000000683f5b7220ULL, 0x080fe20000410000ULL,
0x00000068493d7220ULL, 0x080fe20000410000ULL, 0x000000682a5e7220ULL, 0x080fe20000410000ULL,
0x0000006819417220ULL, 0x080fe20000410000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0044ULL,
0x0000006808357220ULL, 0x080fe20000410000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0036ULL,
0x0000006809347220ULL, 0x080fe20000410000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0037ULL,
0x000000680a0a7220ULL, 0x080fe20000410000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e003aULL,
0x000000680b0b7220ULL, 0x080fe20000410000ULL, 0x000000ffff487224ULL, 0x000fe200078e003bULL,
0x0000006826207220ULL, 0x080fe20000410000ULL, 0x000000ffff477224ULL, 0x000fe200078e0033ULL,
0x0000006827217220ULL, 0x080fe20000410000ULL, 0x000000ffff327224ULL, 0x000fe200078e0042ULL,
0x000000681e1e7220ULL, 0x080fe20000410000ULL, 0x000000ffff457224ULL, 0x000fe200078e0046ULL,
0x000000681f1f7220ULL, 0x080fe20000410000ULL, 0x00000068283e7220ULL, 0x080fe20000410000ULL,
0x00000068293f7220ULL, 0x080fe20000410000ULL, 0x000000681a197220ULL, 0x080fe20000410000ULL,
0x000000681b6a7220ULL, 0x080fe20000410000ULL, 0x0000006815157220ULL, 0x080fe20000410000ULL,
0x0000006816167220ULL, 0x080fe20000410000ULL, 0x0000006817177220ULL, 0x000fe20000410000ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0004ULL, 0x000000ffff497224ULL, 0x000fe400078e0005ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0022ULL, 0x000000ffff307224ULL, 0x000fe400078e0023ULL,
0x000000ffff407224ULL, 0x000fe400078e0006ULL, 0x000000ffff337224ULL, 0x000fe400078e0043ULL,
0x000000ffff447224ULL, 0x000fc400078e0007ULL, 0x000000ffff367224ULL, 0x000fe400078e0024ULL,
0x000000ffff377224ULL, 0x000fe400078e0025ULL, 0x000000ffff3a7224ULL, 0x000fe400078e001cULL,
0x000000ffff3b7224ULL, 0x000fe400078e001dULL, 0x000000ffff467224ULL, 0x000fe400078e0018ULL,
0x000000ffff427224ULL, 0x000fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000067087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff237224ULL, 0x000fc400078e0020ULL,
0x000000ffff247224ULL, 0x000fe400078e0021ULL, 0x000000ffff257224ULL, 0x000fe400078e001eULL,
0x000000ffff227224ULL, 0x000fe400078e001fULL, 0x000000ffff437224ULL, 0x000fe400078e0015ULL,
0x000000ffff267224ULL, 0x000fe400078e000aULL, 0x000000ffff277224ULL, 0x000fc400078e000bULL,
0x000000ffff297224ULL, 0x000fe400078e005aULL, 0x000000ffff287224ULL, 0x000fe400078e005bULL,
0x000000ffff217224ULL, 0x000fe400078e005cULL, 0x000000ffff207224ULL, 0x000fe400078e005dULL,
0x000000ffff1a7224ULL, 0x000fe400078e005eULL, 0x000000ffff1b7224ULL, 0x000fc400078e005fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0019ULL, 0x000000ffff1d7224ULL, 0x000fe400078e006aULL,
0x000000ffff1e7224ULL, 0x000fe400078e0016ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0017ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040067077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040067077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000411197824ULL, 0x000fe200078e00ffULL,
0x000000606500720cULL, 0x000fc80003f06070ULL, 0xfffffff019057812ULL, 0x000fca00078ec0ffULL,
0x0000008012187824ULL, 0x000fca00078e0205ULL, 0x0124000018047984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x0000010065097824ULL, 0x000fe200078e0203ULL,
0x0000000011087211ULL, 0x040fe200078ff0ffULL, 0x00000002115b7824ULL, 0x000fe400078e00ffULL,
0x00000002ff7c7424ULL, 0x000fe200078e00ffULL, 0x00000009105a7217ULL, 0x000fe40007800000ULL,
0x000000065b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000008080a7810ULL, 0x000fe20007ffe0ffULL,
0x000000015a5a7824ULL, 0x000fe200078e0a09ULL, 0x00005a00ff097a19ULL, 0x000fe20000011608ULL,
0x00000001610b7824ULL, 0x000fe200078e025bULL, 0x000058005b5d7a10ULL, 0x000fc40007ffe0ffULL,
0x0000001008147810ULL, 0x040fe40007ffe0ffULL, 0x0000005a0b00720cULL, 0x0c0fe20003f26070ULL,
0x000000010b0b7824ULL, 0x100fe200078e0a5aULL, 0x00000018085c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000962087217ULL, 0x040fe20003800000ULL, 0x000000015d097824ULL, 0x040fe200078e0a5aULL,
0x0000000b620b7217ULL, 0x040fe40003800000ULL, 0x0000005a5d00720cULL, 0x000fe20003f06070ULL,
0x00000008138b7224ULL, 0x000fe200078e02ffULL, 0x0000000962097217ULL, 0x000fc40003800000ULL,
0x00000004ff0b7819ULL, 0x000fe4000001160bULL, 0x00005a00ff157a19ULL, 0x000fe4000001160aULL,
0x000000ff097a7207ULL, 0x000fe40000000000ULL, 0x000000ff0b167207ULL, 0x000fe40000800000ULL,
0x00000015620a7217ULL, 0x000fe40003800000ULL, 0x00005a00ff177a19ULL, 0x000fe20000011614ULL,
0x000000018b0b7824ULL, 0x000fe200078e0216ULL, 0x0000008b7a097211ULL, 0x000fe200078fe0ffULL,
0x0000000a13917224ULL, 0x000fe200078e02ffULL, 0x00005a00ff5f7a19ULL, 0x000fe2000001165cULL,
0x000060000b0a7625ULL, 0x000fe200078e007cULL, 0x00000017625c7217ULL, 0x000fc40003800000ULL,
0x0000005f625e7217ULL, 0x000fe20003800000ULL, 0x0000600009087625ULL, 0x000fe200078e007cULL,
0x000000080a5f7981ULL, 0x0046a2000c1e9500ULL, 0x000000917a157211ULL, 0x000fe400078fe0ffULL,
0x0000005c13937224ULL, 0x040fe400078e02ffULL, 0x00000008085c7981ULL, 0x0002a2000c1e9500ULL,
0x0000005e13957224ULL, 0x000fe200078e02ffULL, 0x000000105b777812ULL, 0x000fe200078efcffULL,
0x0000000116177824ULL, 0x000fe200078e0291ULL, 0x000000937a6b7211ULL, 0x000fe200078fe0ffULL,
0x00000001166f7824ULL, 0x000fc400078e0293ULL, 0x0000600015147625ULL, 0x000fe200078e007cULL,
0x0000580077757a10ULL, 0x000fc60007ffe0ffULL, 0x0000000116717824ULL, 0x000fe200078e0295ULL,
0x00000008145e7981ULL, 0x0006a2000c1e9500ULL, 0x000060006b6a7625ULL, 0x000fc800078e007cULL,
0x0000600017167625ULL, 0x080fe200078e007cULL, 0x000000086a6e7981ULL, 0x0006a6000c1e9500ULL,
0x000060006f087625ULL, 0x002fc800078e007cULL, 0x0000000161797824ULL, 0x000fe200078e0277ULL,
0x0000000808737981ULL, 0x0002a2000c1e9500ULL, 0x0000600071147625ULL, 0x008fc600078e007cULL,
0x0000000816717981ULL, 0x0006a2000c1e9500ULL, 0x00000001797b7824ULL, 0x100fe400078e0a5aULL,
0x00000001750b7824ULL, 0x040fe200078e0a5aULL, 0x000000957a6d7211ULL, 0x000fe200078fe0ffULL,
0x0000000814707981ULL, 0x0002a2000c1e9500ULL, 0x0000007b627b7217ULL, 0x040fe40003800000ULL,
0x0000005a7500720cULL, 0x000fe40003f06070ULL, 0x0000000b620b7217ULL, 0x000fe20003800000ULL,
0x000060006d6c7625ULL, 0x000fe200078e007cULL, 0x0000005a7900720cULL, 0x000fc40003f26070ULL,
0x00000004ff7b7819ULL, 0x000fe4000001167bULL, 0x000000ff0b827207ULL, 0x000fe20000000000ULL,
0x000000086c6f7981ULL, 0x0002a2000c1e9500ULL, 0x000000ff7b167207ULL, 0x008fe40000800000ULL,
0x0000008b82097211ULL, 0x042fe400078fe0ffULL, 0x0000009182157211ULL, 0x000fe200078fe0ffULL,
0x000000018b0b7824ULL, 0x000fe200078e0216ULL, 0x000000205b7f7812ULL, 0x000fe200078efcffULL,
0x0000000116177824ULL, 0x000fc400078e0291ULL, 0x0000600009087625ULL, 0x000fc800078e007cULL,
0x00000001167b7824ULL, 0x040fe200078e0293ULL, 0x0000000808727981ULL, 0x0002e2000c1e9500ULL,
0x00000001167d7824ULL, 0x000fe400078e0295ULL, 0x0000600015147625ULL, 0x000fe200078e007cULL,
0x000058007f817a10ULL, 0x000fc60007ffe0ffULL, 0x000060000b0a7625ULL, 0x080fe200078e007cULL,
0x0000000814747981ULL, 0x0002e6000c1e9500ULL, 0x0000600017167625ULL, 0x080fe200078e007cULL,
0x000000080a797981ULL, 0x0002e6000c1e9500ULL, 0x0000000161857824ULL, 0x000fe400078e027fULL,
0x000060007b087625ULL, 0x002fc400078e007cULL, 0x00000008167b7981ULL, 0x0002e4000c1e9500ULL,
0x0000000185877824ULL, 0x100fe200078e0a5aULL, 0x00000093826b7211ULL, 0x040fe200078fe0ffULL,
0x00000001810b7824ULL, 0x000fe200078e0a5aULL, 0x00000095826d7211ULL, 0x000fe400078fe0ffULL,
0x0000008762877217ULL, 0x040fe20003800000ULL, 0x000060006b6a7625ULL, 0x000fe200078e007cULL,
0x0000005a8100720cULL, 0x000fe40003f06070ULL, 0x0000000b620b7217ULL, 0x000fe20003800000ULL,
0x000060006d6c7625ULL, 0x000fe200078e007cULL, 0x0000005a8500720cULL, 0x000fe20003f26070ULL,
0x000000086a767981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff877819ULL, 0x000fe20000011687ULL,
0x000060007d147625ULL, 0x000fe200078e007cULL, 0x000000ff0b887207ULL, 0x000fe20000000000ULL,
0x00000008087d7981ULL, 0x0002e8000c1e9500ULL, 0x000000086c787981ULL, 0x0002e8000c1e9500ULL,
0x0000000814837981ULL, 0x0002e4000c1e9500ULL, 0x000000ff87087207ULL, 0x002fc40000800000ULL,
0x0000008b880b7211ULL, 0x000fc600078fe0ffULL, 0x0000000108097824ULL, 0x000fe200078e0291ULL,
0x0000009188157211ULL, 0x000fe200078fe0ffULL, 0x000000018b6d7824ULL, 0x000fe400078e0208ULL,
0x0000000108877824ULL, 0x040fe400078e0293ULL, 0x0000000108897824ULL, 0x000fe400078e0295ULL,
0x0000600015147625ULL, 0x000fc800078e007cULL, 0x0000600009087625ULL, 0x080fe200078e007cULL,
0x0000000814807981ULL, 0x0002e6000c1e9500ULL, 0x000060000b0a7625ULL, 0x000fe200078e007cULL,
0x0000000808d17981ULL, 0x0002e2000c1e9500ULL, 0x00000093886b7211ULL, 0x000fc600078fe0ffULL,
0x000000080a7e7981ULL, 0x0002e2000c1e9500ULL, 0x0000009588177211ULL, 0x000fe200078fe0ffULL,
0x000060006d6c7625ULL, 0x000fc800078e007cULL, 0x00006000870a7625ULL, 0x082fe200078e007cULL,
0x000000305b877812ULL, 0x000fe200078efcffULL, 0x000000086c857981ULL, 0x0002e4000c1e9500ULL,
0x000060006b6a7625ULL, 0x080fe400078e007cULL, 0x000000080ad57981ULL, 0x0002e4000c1e9500ULL,
0x0000600017167625ULL, 0x080fe400078e007cULL, 0x000000086a847981ULL, 0x0002e4000c1e9500ULL,
0x0000600089147625ULL, 0x000fe200078e007cULL, 0x0000580087897a10ULL, 0x000fe20007ffe0ffULL,
0x0000000816867981ULL, 0x0002e4000c1e9500ULL, 0x00000001618d7824ULL, 0x000fc400078e0287ULL,
0x0000000814d97981ULL, 0x0002e4000c1e9500ULL, 0x000000018d8f7824ULL, 0x100fe400078e0a5aULL,
0x00000001896d7824ULL, 0x002fc600078e0a5aULL, 0x0000008f628f7217ULL, 0x040fe40003800000ULL,
0x0000005a8d00720cULL, 0x080fe40003f26070ULL, 0x0000005a8900720cULL, 0x000fe40003f06070ULL,
0x0000006d626d7217ULL, 0x000fe40003800000ULL, 0x00000004ff8f7819ULL, 0x000fe4000001168fULL,
0x000000ff6d8a7207ULL, 0x000fc40000000000ULL, 0x000000ff8f8c7207ULL, 0x000fe40000800000ULL,
0x0000008b8a6b7211ULL, 0x040fe400078fe0ffULL, 0x000000938a0b7211ULL, 0x000fe200078fe0ffULL,
0x000000018b6d7824ULL, 0x000fe400078e028cULL, 0x000000018c177824ULL, 0x000fe400078e0293ULL,
0x000060006b6a7625ULL, 0x000fc800078e007cULL, 0x000060006d6c7625ULL, 0x080fe200078e007cULL,
0x000000086abb7981ULL, 0x0002e6000c1e9500ULL, 0x000060000b0a7625ULL, 0x080fe200078e007cULL,
0x000000086c8e7981ULL, 0x0002e6000c1e9500ULL, 0x0000600017167625ULL, 0x000fe200078e007cULL,
0x000000080ad77981ULL, 0x0002e2000c1e9500ULL, 0x000000918a097211ULL, 0x000fc600078fe0ffULL,
0x0000000816927981ULL, 0x0002e2000c1e9500ULL, 0x000000018c157824ULL, 0x000fe400078e0291ULL,
0x0000600009087625ULL, 0x000fc800078e007cULL, 0x0000600015147625ULL, 0x080fe200078e007cULL,
0x0000000808d37981ULL, 0x0002e4000c1e9500ULL, 0x000000958a6b7211ULL, 0x002fe400078fe0ffULL,
0x0000000814907981ULL, 0x0002e2000c1e9500ULL, 0x000000018c6d7824ULL, 0x000fe400078e0295ULL,
0x000060006b6a7625ULL, 0x000fc800078e007cULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x000000086adb7981ULL, 0x0002e8000c1e9500ULL, 0x000000086c947981ULL, 0x0002e2000c1e9500ULL,
0xfffffff07a097812ULL, 0x000fe200078ec0ffULL, 0x00000001ffcf7424ULL, 0x000fc800078e00ffULL,
0x000000015a087824ULL, 0x000fc800078e0209ULL, 0x000000015d097824ULL, 0x000fe200078e0a08ULL,
0x000000015b8b7812ULL, 0x000fc800078efcffULL, 0x00000009cf097219ULL, 0x000fe400000006ffULL,
0x000058008b0b7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff082157812ULL, 0x002fc600078ec0ffULL,
0x000000010b0a7824ULL, 0x100fe200078e0a08ULL, 0x000000085b8d7812ULL, 0x040fe200078efcffULL,
0x000000015a167824ULL, 0x000fe200078e0215ULL, 0x000000095b8f7812ULL, 0x000fe400078efcffULL,
0x0000000acf157219ULL, 0x000fe400000006ffULL, 0x000058008d177a10ULL, 0x000fe40007ffe0ffULL,
0x000058008f6d7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0886b7812ULL, 0x000fe200078ec0ffULL,
0x0000000117147824ULL, 0x100fe200078e0a08ULL, 0xfffffff08a917812ULL, 0x000fe200078ec0ffULL,
0x000000016d087824ULL, 0x000fe200078e0a08ULL, 0x000000115b957812ULL, 0x000fe200078efcffULL,
0x000000015a6a7824ULL, 0x040fe200078e026bULL, 0x00000014cf6b7219ULL, 0x000fe200000006ffULL,
0x000000015a827824ULL, 0x000fe200078e0291ULL, 0x000054105c5c7816ULL, 0x004fc8000000005fULL,
0x0000005c09ff7212ULL, 0x000fc800078ac0ffULL, 0x0000005a5d00720cULL, 0x000fc80002fa1470ULL,
0x0000005a5b00720cULL, 0x000fe40002fa1070ULL, 0x0000005c15ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x0000005a0b00720cULL, 0x000fe40000f21470ULL,
0x000054106e6e7816ULL, 0x000fe40000000073ULL, 0x000054105e5e7816ULL, 0x000fc40000000071ULL,
0x0000006e09ff7212ULL, 0x040fe4000788c0ffULL, 0x0000005e09ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005e15ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005a5d00720cULL, 0x0c0fe40001741470ULL,
0x0000005a5d00720cULL, 0x080fe40002781470ULL, 0x0000005a0b00720cULL, 0x000fc40002fa1470ULL,
0x0000005a5b00720cULL, 0x0c0fe40001741070ULL, 0x0000005a5b00720cULL, 0x080fe40002781070ULL,
0x0000005a8b00720cULL, 0x0c0fe40000f21070ULL, 0x0000005a8b00720cULL, 0x000fe40002fa1070ULL,
0x00000008cf917219ULL, 0x000fe400000006ffULL, 0x000054106f707816ULL, 0x000fc40000000070ULL,
0x0000580095977a10ULL, 0x000fe40007ffe0ffULL, 0xff8000002a2a7808ULL, 0x000fe40001000000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000056567808ULL, 0x000fe40000800000ULL,
0xff80000049497808ULL, 0x000fe40002800000ULL, 0x0000005c6bff7212ULL, 0x000fc4000786c0ffULL,
0x0000007009ff7212ULL, 0x000fe4000780c0ffULL, 0x0000006e15ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007015ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005e91ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006e6bff7212ULL, 0x000fe200078ac0ffULL, 0x0000000175087824ULL, 0x100fe200078e0a16ULL,
0x0000005a5d00720cULL, 0x080fe20000701470ULL, 0x00000001970a7824ULL, 0x000fe200078e0a16ULL,
0x0000005a0b00720cULL, 0x000fc40001741470ULL, 0x0000005a0b00720cULL, 0x080fe40002781470ULL,
0x0000005a1700720cULL, 0x0c0fe40001f61470ULL, 0x0000005a1700720cULL, 0x080fe40002fa1470ULL,
0x0000005a6d00720cULL, 0x000fe40000f21470ULL, 0x000000185b9b7812ULL, 0x040fe400078efcffULL,
0x000000195ba17812ULL, 0x000fc400078efcffULL, 0x0000005a5b00720cULL, 0x080fe40000701070ULL,
0x0000005a8b00720cULL, 0x0c0fe40001741070ULL, 0x0000005a8b00720cULL, 0x080fe40002781070ULL,
0x0000005a8d00720cULL, 0x0c0fe40001f61070ULL, 0x0000005a8d00720cULL, 0x080fe40002fa1070ULL,
0x0000005a8f00720cULL, 0x000fc40000f21070ULL, 0x00000008cf937219ULL, 0x040fe400000006ffULL,
0x0000000acf997219ULL, 0x000fe400000006ffULL, 0x0000541072727816ULL, 0x008fe40000000079ULL,
0x0000541074747816ULL, 0x000fe4000000007bULL, 0x000058009b9d7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800a1a37a10ULL, 0x000fc40007ffe0ffULL, 0xff80000026267808ULL, 0x000fe40000000000ULL,
0xff80000034347808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40002000000ULL,
0xff80000055557808ULL, 0x000fe40001800000ULL, 0xff80000036367808ULL, 0x000fe40002800000ULL,
0xff8000002d2d7808ULL, 0x000fc40000800000ULL, 0x0000005e6bff7212ULL, 0x000fe4000780c0ffULL,
0x0000006e91ff7212ULL, 0x000fe4000784c0ffULL, 0x000000706bff7212ULL, 0x080fe4000788c0ffULL,
0x0000007091ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007299ff7212ULL, 0x000fe400078ac0ffULL,
0x0000007493ff7212ULL, 0x000fe2000782c0ffULL, 0x000000019d147824ULL, 0x100fe200078e0a16ULL,
0x0000005a1700720cULL, 0x080fe20000701470ULL, 0x00000001a3167824ULL, 0x000fe200078e0a16ULL,
0x0000005a1700720cULL, 0x000fc40002781470ULL, 0x0000005a6d00720cULL, 0x0c0fe40001741470ULL,
0x0000005a6d00720cULL, 0x080fe40001f61470ULL, 0x0000005a7500720cULL, 0x080fe40000f21470ULL,
0x0000005a9700720cULL, 0x080fe40002fa1470ULL, 0x0000005a8d00720cULL, 0x0c0fe40000701070ULL,
0x0000005a8d00720cULL, 0x000fc40002781070ULL, 0x0000005a8f00720cULL, 0x0c0fe40001741070ULL,
0x0000005a8f00720cULL, 0x080fe40001f61070ULL, 0x0000005a7700720cULL, 0x080fe40000f21070ULL,
0x0000005a9500720cULL, 0x000fe40002fa1070ULL, 0x00000014cf9f7219ULL, 0x040fe400000006ffULL,
0x00000016cfa57219ULL, 0x000fc400000006ffULL, 0x0000541076767816ULL, 0x000fe4000000007dULL,
0x0000541078787816ULL, 0x000fe40000000083ULL, 0xff8000002b2b7808ULL, 0x000fe40000000000ULL,
0xff80000023237808ULL, 0x000fe40002000000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000024247808ULL, 0x000fc40001800000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000052527808ULL, 0x000fe40002800000ULL, 0x0000007293ff7212ULL, 0x080fe4000780c0ffULL,
0x000000729fff7212ULL, 0x000fe4000788c0ffULL, 0x0000007693ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007893ff7212ULL, 0x000fc4000786c0ffULL, 0x0000007699ff7212ULL, 0x000fe4000782c0ffULL,
0x00000074a5ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001816c7824ULL, 0x000fe200078e0a6aULL,
0x0000005a7500720cULL, 0x0c0fe40000701470ULL, 0x0000005a7500720cULL, 0x0c0fe40001741470ULL,
0x0000005a7500720cULL, 0x080fe40001f61470ULL, 0x0000005a9700720cULL, 0x000fc40000f21470ULL,
0x0000005a9d00720cULL, 0x080fe40002781470ULL, 0x0000005aa300720cULL, 0x080fe40002fa1470ULL,
0x000000215ba97812ULL, 0x000fe400078efcffULL, 0x0000005a7700720cULL, 0x0c0fe40000701070ULL,
0x0000005a7700720cULL, 0x0c0fe40001741070ULL, 0x0000005a7700720cULL, 0x000fc40001f61070ULL,
0x0000005a9500720cULL, 0x080fe40000f21070ULL, 0x0000005a9b00720cULL, 0x080fe40002781070ULL,
0x0000005aa100720cULL, 0x000fe40002fa1070ULL, 0x0000006ccfa77219ULL, 0x000fe400000006ffULL,
0x0000541080807816ULL, 0x000fe400000000d1ULL, 0x00005800a9ab7a10ULL, 0x000fc40007ffe0ffULL,
0xff80000053537808ULL, 0x000fe40000000000ULL, 0xff80000038387808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000039397808ULL, 0x000fe40000800000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff80000030307808ULL, 0x000fc40002800000ULL,
0x0000007499ff7212ULL, 0x040fe4000780c0ffULL, 0x0000007899ff7212ULL, 0x000fe4000784c0ffULL,
0x000000749fff7212ULL, 0x000fe4000786c0ffULL, 0x00000076a5ff7212ULL, 0x040fe4000782c0ffULL,
0x00000078a5ff7212ULL, 0x000fe4000788c0ffULL, 0x00000080a7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ab7a7824ULL, 0x000fe200078e0a6aULL, 0x0000005a9700720cULL, 0x000fc40000701470ULL,
0x0000005a9700720cULL, 0x080fe40001741470ULL, 0x0000005a9d00720cULL, 0x080fe40001f61470ULL,
0x0000005aa300720cULL, 0x0c0fe40000f21470ULL, 0x0000005aa300720cULL, 0x080fe40002781470ULL,
0x0000005a8100720cULL, 0x000fe40002fa1470ULL, 0x000000285baf7812ULL, 0x000fc400078efcffULL,
0x000000295bb57812ULL, 0x000fe400078efcffULL, 0x0000005a9500720cULL, 0x0c0fe40000701070ULL,
0x0000005a9500720cULL, 0x080fe40001741070ULL, 0x0000005a9b00720cULL, 0x080fe40001f61070ULL,
0x0000005aa100720cULL, 0x0c0fe40000f21070ULL, 0x0000005aa100720cULL, 0x000fc40002781070ULL,
0x0000005a7f00720cULL, 0x000fe40002fa1070ULL, 0x0000007acfad7219ULL, 0x000fe400000006ffULL,
0x000054107e7e7816ULL, 0x000fe40000000085ULL, 0x0000541084847816ULL, 0x000fe400000000d5ULL,
0x0000541086867816ULL, 0x000fe400000000d9ULL, 0x00005800afb17a10ULL, 0x000fc40007ffe0ffULL,
0x00005800b5b77a10ULL, 0x000fe40007ffe0ffULL, 0xff80000048487808ULL, 0x000fe40000000000ULL,
0xff80000028287808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fc40002000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002800000ULL, 0x0000005c91ff7212ULL, 0x000fe400078cc0ffULL,
0x000000769fff7212ULL, 0x040fe4000780c0ffULL, 0x000000789fff7212ULL, 0x000fe4000784c0ffULL,
0x0000007ea7ff7212ULL, 0x040fe4000786c0ffULL, 0x00000084a7ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086a7ff7212ULL, 0x000fe4000788c0ffULL, 0x00000084adff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b17c7824ULL, 0x100fe200078e0a6aULL, 0x0000005a6d00720cULL, 0x080fe200037c1470ULL,
0x00000001b76a7824ULL, 0x000fe200078e0a6aULL, 0x0000005a9d00720cULL, 0x0c0fe40000701470ULL,
0x0000005a9d00720cULL, 0x080fe40001741470ULL, 0x0000005a8100720cULL, 0x000fc40001f61470ULL,
0x0000005a8100720cULL, 0x0c0fe40000f21470ULL, 0x0000005a8100720cULL, 0x080fe40002781470ULL,
0x0000005aab00720cULL, 0x080fe40002fa1470ULL, 0x0000005a8f00720cULL, 0x080fe400037c1070ULL,
0x0000005a9b00720cULL, 0x0c0fe40000701070ULL, 0x0000005a9b00720cULL, 0x000fc40001741070ULL,
0x0000005a7f00720cULL, 0x0c0fe40001f61070ULL, 0x0000005a7f00720cULL, 0x0c0fe40000f21070ULL,
0x0000005a7f00720cULL, 0x080fe40002781070ULL, 0x0000005aa900720cULL, 0x000fe40002fa1070ULL,
0x0000007ccfb37219ULL, 0x040fe400000006ffULL, 0x0000006acfb97219ULL, 0x000fc400000006ffULL,
0xff80000054547808ULL, 0x000fe40003000000ULL, 0xff8000003a3a7808ULL, 0x000fe40000000000ULL,
0xff80000025257808ULL, 0x000fe40001000000ULL, 0xff80000059597808ULL, 0x000fe40001800000ULL,
0xff8000003c3c7808ULL, 0x000fe40000800000ULL, 0xff80000021217808ULL, 0x000fc40002000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x00000072a5ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007eadff7212ULL, 0x080fe4000780c0ffULL, 0x0000007eb3ff7212ULL, 0x000fe4000784c0ffULL,
0x00000080adff7212ULL, 0x040fe4000786c0ffULL, 0x00000086adff7212ULL, 0x000fc4000782c0ffULL,
0x00000080b3ff7212ULL, 0x000fe4000788c0ffULL, 0x00000084b9ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000189887824ULL, 0x000fe200078e0a82ULL, 0x0000005aa300720cULL, 0x080fe400037c1470ULL,
0x0000005aab00720cULL, 0x0c0fe40000701470ULL, 0x0000005aab00720cULL, 0x0c0fe40001f61470ULL,
0x0000005aab00720cULL, 0x000fc40000f21470ULL, 0x0000005ab100720cULL, 0x0c0fe40001741470ULL,
0x0000005ab100720cULL, 0x080fe40002781470ULL, 0x0000005ab700720cULL, 0x000fe40002fa1470ULL,
0x000000315bbf7812ULL, 0x040fe400078efcffULL, 0x000000385bc57812ULL, 0x040fe400078efcffULL,
0x000000395bcb7812ULL, 0x000fc400078efcffULL, 0x0000005aa100720cULL, 0x080fe400037c1070ULL,
0x0000005aa900720cULL, 0x0c0fe40000701070ULL, 0x0000005aa900720cULL, 0x0c0fe40001f61070ULL,
0x0000005aa900720cULL, 0x080fe40000f21070ULL, 0x0000005aaf00720cULL, 0x0c0fe40001741070ULL,
0x0000005aaf00720cULL, 0x000fc40002781070ULL, 0x0000005ab500720cULL, 0x000fe40002fa1070ULL,
0x00000088cfbd7219ULL, 0x000fe400000006ffULL, 0x00005410bb8e7816ULL, 0x000fe4000000008eULL,
0x00005410d7927816ULL, 0x000fe40000000092ULL, 0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c5c77a10ULL, 0x000fc40007ffe0ffULL, 0x00005800cbcd7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000058587808ULL, 0x000fe40003000000ULL, 0xff80000050507808ULL, 0x000fe40000000000ULL,
0xff80000047477808ULL, 0x000fe40001800000ULL, 0xff80000020207808ULL, 0x000fe40000800000ULL,
0xff8000004f4f7808ULL, 0x000fc40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000003f3f7808ULL, 0x000fe40002800000ULL, 0x0000007eb9ff7212ULL, 0x040fe400078cc0ffULL,
0x00000080b9ff7212ULL, 0x000fe4000780c0ffULL, 0x00000084b3ff7212ULL, 0x040fe4000786c0ffULL,
0x00000086b3ff7212ULL, 0x000fc4000782c0ffULL, 0x00000086b9ff7212ULL, 0x000fe4000784c0ffULL,
0x0000008ebdff7212ULL, 0x040fe4000788c0ffULL, 0x00000092bdff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c18a7824ULL, 0x100fe200078e0a82ULL, 0x0000005ab100720cULL, 0x080fe20001f61470ULL,
0x00000001c78c7824ULL, 0x100fe200078e0a82ULL, 0x0000005ab100720cULL, 0x080fe20000f21470ULL,
0x00000001cd827824ULL, 0x000fe200078e0a82ULL, 0x0000005ab700720cULL, 0x000fc400037c1470ULL,
0x0000005ab700720cULL, 0x0c0fe40000701470ULL, 0x0000005ab700720cULL, 0x080fe40001741470ULL,
0x0000005a8900720cULL, 0x0c0fe40002781470ULL, 0x0000005a8900720cULL, 0x000fe40002fa1470ULL,
0x0000008acfc37219ULL, 0x040fe400000006ffULL, 0x0000008ccfc97219ULL, 0x000fc400000006ffULL,
0x0000005aaf00720cULL, 0x0c0fe40001f61070ULL, 0x0000005aaf00720cULL, 0x080fe40000f21070ULL,
0x0000005ab500720cULL, 0x0c0fe400037c1070ULL, 0x0000005ab500720cULL, 0x0c0fe40000701070ULL,
0x0000005ab500720cULL, 0x080fe40001741070ULL, 0x0000005a8700720cULL, 0x000fc40002781070ULL,
0x0000005a8700720cULL, 0x000fe40002fa1070ULL, 0x00000082cfcf7219ULL, 0x000fe400000006ffULL,
0x00005410d3907816ULL, 0x000fe40000000090ULL, 0xff8000003e3e7808ULL, 0x000fe40001800000ULL,
0xff8000001a1a7808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fc40003000000ULL,
0xff80000040407808ULL, 0x000fe40000000000ULL, 0xff8000001b1b7808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40002000000ULL, 0xff80000046467808ULL, 0x000fe40002800000ULL,
0x0000008ec3ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008ec9ff7212ULL, 0x000fc4000782c0ffULL,
0x0000008ecfff7212ULL, 0x000fe400078cc0ffULL, 0x00000090bdff7212ULL, 0x080fe4000780c0ffULL,
0x00000090c3ff7212ULL, 0x080fe4000784c0ffULL, 0x00000090c9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000092c3ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005a8900720cULL, 0x000fc40000701470ULL,
0x0000005ac100720cULL, 0x0c0fe40001f61470ULL, 0x0000005ac100720cULL, 0x0c0fe40001741470ULL,
0x0000005ac100720cULL, 0x080fe40002fa1470ULL, 0x0000005ac700720cULL, 0x080fe40000f21470ULL,
0x0000005acd00720cULL, 0x080fe400037c1470ULL, 0x0000005ac700720cULL, 0x000fc40002781470ULL,
0x0000005a8700720cULL, 0x080fe40000701070ULL, 0x0000005abf00720cULL, 0x0c0fe40001f61070ULL,
0x0000005abf00720cULL, 0x0c0fe40001741070ULL, 0x0000005abf00720cULL, 0x080fe40002fa1070ULL,
0x0000005ac500720cULL, 0x080fe40000f21070ULL, 0x0000005acb00720cULL, 0x000fc400037c1070ULL,
0x0000005ac500720cULL, 0x000fe40002781070ULL, 0x00005410db947816ULL, 0x000fe40000000094ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0xff8000004c4c7808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000041417808ULL, 0x000fc40002800000ULL,
0xff8000004b4b7808ULL, 0x000fe40000800000ULL, 0xff8000004a4a7808ULL, 0x000fe40003000000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0x00000090cfff7212ULL, 0x000fe4000780c0ffULL,
0x00000092c9ff7212ULL, 0x080fe4000786c0ffULL, 0x00000092cfff7212ULL, 0x000fc4000784c0ffULL,
0x00000094bdff7212ULL, 0x080fe400078ac0ffULL, 0x00000094c3ff7212ULL, 0x080fe4000782c0ffULL,
0x00000094c9ff7212ULL, 0x080fe400078cc0ffULL, 0x00000094cfff7212ULL, 0x000fe4000788c0ffULL,
0x0000005a8900720cULL, 0x080fe40002fa1470ULL, 0x0000005ac100720cULL, 0x000fc40000f21470ULL,
0x0000005ac700720cULL, 0x0c0fe40001f61470ULL, 0x0000005ac700720cULL, 0x080fe400037c1470ULL,
0x0000005acd00720cULL, 0x0c0fe40000701470ULL, 0x0000005acd00720cULL, 0x0c0fe40001741470ULL,
0x0000005acd00720cULL, 0x080fe40002781470ULL, 0x0000005a8700720cULL, 0x000fc40002fa1070ULL,
0x0000005abf00720cULL, 0x080fe40000f21070ULL, 0x0000005acb00720cULL, 0x080fe40000701070ULL,
0x0000005ac500720cULL, 0x0c0fe40001f61070ULL, 0x0000005ac500720cULL, 0x080fe400037c1070ULL,
0x0000005acb00720cULL, 0x0c0fe40001741070ULL, 0x0000005acb00720cULL, 0x000fc40002781070ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fe40001000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002800000ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0xff8000001e1e7808ULL, 0x000fc40003000000ULL,
0xff8000001f1f7808ULL, 0x000fc40002000000ULL, 0x000000570400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff5a7424ULL, 0x000fe200078e00ffULL, 0x0000002a0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff5b7424ULL, 0x000fe200078e00ffULL, 0x000000350600720bULL, 0x000fe40003f5e000ULL,
0x000000260700720bULL, 0x000fe40003f7e000ULL, 0x0000000457097208ULL, 0x000fe40004000000ULL,
0x000000052a047208ULL, 0x000fc40004800000ULL, 0x0000000635057208ULL, 0x000fe40005000000ULL,
0x0000000726067208ULL, 0x000fe40005800000ULL, 0x000000560900720bULL, 0x000fe40003f1e000ULL,
0x000000490400720bULL, 0x000fe40003f3e000ULL, 0x000000340500720bULL, 0x000fe40003f5e000ULL,
0x000000270600720bULL, 0x000fc40003f7e000ULL, 0x0000000956087208ULL, 0x000fe40004000000ULL,
0x0000000449047208ULL, 0x000fe40004800000ULL, 0x0000000534057208ULL, 0x000fe40005000000ULL,
0x0000000627067208ULL, 0x000fe40005800000ULL, 0x000000550800720bULL, 0x000fe40003f1e000ULL,
0x0000002b0400720bULL, 0x000fc40003f3e000ULL, 0x000000360500720bULL, 0x000fe40003f5e000ULL,
0x000000230600720bULL, 0x000fe40003f7e000ULL, 0x0000000855077208ULL, 0x000fe40004000000ULL,
0x000000042b047208ULL, 0x000fe40004800000ULL, 0x0000000536087208ULL, 0x000fe40005000000ULL,
0x0000000623057208ULL, 0x000fc40005800000ULL, 0x000000540700720bULL, 0x000fe40003f1e000ULL,
0x0000002d0400720bULL, 0x000fe40003f3e000ULL, 0x000000370800720bULL, 0x000fe40003f5e000ULL,
0x000000240500720bULL, 0x000fe40003f7e000ULL, 0x0000000754067208ULL, 0x000fe40004000000ULL,
0x000000042d077208ULL, 0x000fc40004800000ULL, 0x0000000837097208ULL, 0x000fe40005000000ULL,
0x0000000524047208ULL, 0x000fe40005800000ULL, 0x000000530600720bULL, 0x000fe40003f1e000ULL,
0x0000002c0700720bULL, 0x000fe40003f3e000ULL, 0x000000380900720bULL, 0x000fe40003f5e000ULL,
0x000000290400720bULL, 0x000fc40003f7e000ULL, 0x0000000653057208ULL, 0x000fe40004000000ULL,
0x000000072c077208ULL, 0x000fe40004800000ULL, 0x0000000938067208ULL, 0x000fe40005000000ULL,
0x0000000429097208ULL, 0x000fe40005800000ULL, 0x000000520500720bULL, 0x000fe40003f1e000ULL,
0x000000480700720bULL, 0x000fc40003f3e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x000000280900720bULL, 0x000fe40003f7e000ULL, 0x0000000552047208ULL, 0x000fe40004000000ULL,
0x0000000748077208ULL, 0x000fe40004800000ULL, 0x0000000639057208ULL, 0x000fe40005000000ULL,
0x0000000928067208ULL, 0x000fc40005800000ULL, 0x000000510400720bULL, 0x000fe40003f1e000ULL,
0x0000002e0700720bULL, 0x000fe40003f3e000ULL, 0x0000003a0500720bULL, 0x000fe40003f5e000ULL,
0x000000250600720bULL, 0x000fe40003f7e000ULL, 0x0000000451097208ULL, 0x000fe40004000000ULL,
0x000000072e077208ULL, 0x000fc40004800000ULL, 0x000000053a047208ULL, 0x000fe40005000000ULL,
0x0000000625057208ULL, 0x000fe40005800000ULL, 0x000000580900720bULL, 0x000fe40003f1e000ULL,
0x000000300700720bULL, 0x000fe40003f3e000ULL, 0x0000003b0400720bULL, 0x000fe40003f5e000ULL,
0x000000220500720bULL, 0x000fc40003f7e000ULL, 0x0000000958067208ULL, 0x000fe40004000000ULL,
0x0000000730087208ULL, 0x000fe40004800000ULL, 0x000000043b077208ULL, 0x000fe40005000000ULL,
0x0000000522047208ULL, 0x000fe40005800000ULL, 0x000000590600720bULL, 0x000fe40003f1e000ULL,
0x0000002f0800720bULL, 0x000fc40003f3e000ULL, 0x0000003c0700720bULL, 0x000fe40003f5e000ULL,
0x000000210400720bULL, 0x000fe40003f7e000ULL, 0x0000000659057208ULL, 0x000fe40004000000ULL,
0x000000082f087208ULL, 0x000fe40004800000ULL, 0x000000073c067208ULL, 0x000fe40005000000ULL,
0x0000000421077208ULL, 0x000fc40005800000ULL, 0x000000500500720bULL, 0x000fe40003f1e000ULL,
0x000000470800720bULL, 0x000fe40003f3e000ULL, 0x0000003d0600720bULL, 0x000fe40003f5e000ULL,
0x000000200700720bULL, 0x000fe40003f7e000ULL, 0x0000000550047208ULL, 0x000fe40004000000ULL,
0x0000000847087208ULL, 0x000fc40004800000ULL, 0x000000063d057208ULL, 0x000fe40005000000ULL,
0x0000000720077208ULL, 0x000fe40005800000ULL, 0x0000004f0400720bULL, 0x000fe40003f1e000ULL,
0x000000310800720bULL, 0x000fe40003f3e000ULL, 0x0000003e0500720bULL, 0x000fe40003f5e000ULL,
0x0000001a0700720bULL, 0x000fc40003f7e000ULL, 0x000000044f097208ULL, 0x000fe40004000000ULL,
0x00000008310b7208ULL, 0x000fe40004800000ULL, 0x000000053e047208ULL, 0x000fe40005000000ULL,
0x000000071a067208ULL, 0x000fe40005800000ULL, 0x0000004e0900720bULL, 0x000fe40003f1e000ULL,
0x000000400b00720bULL, 0x000fc40003f3e000ULL, 0x0000003f0400720bULL, 0x000fe40003f5e000ULL,
0x0000001b0600720bULL, 0x000fe40003f7e000ULL, 0x000000094e087208ULL, 0x000fe40004000000ULL,
0x0000000b400b7208ULL, 0x000fe40004800000ULL, 0x000000043f057208ULL, 0x000fe40005000000ULL,
0x000000061b077208ULL, 0x000fc40005800000ULL, 0x0000004d0800720bULL, 0x000fe40003f1e000ULL,
0x000000320b00720bULL, 0x000fe40003f3e000ULL, 0x000000460500720bULL, 0x000fe40003f5e000ULL,
0x0000001c0700720bULL, 0x000fe40003f7e000ULL, 0x000000084d097208ULL, 0x000fe40004000000ULL,
0x0000000b32047208ULL, 0x000fc40004800000ULL, 0x0000000546067208ULL, 0x000fe40005000000ULL,
0x000000071c087208ULL, 0x000fe40005800000ULL, 0x000000330400720bULL, 0x000fe40003f3e000ULL,
0x0000004c0900720bULL, 0x000fe40003f1e000ULL, 0x000000410600720bULL, 0x000fe40003f5e000ULL,
0x0000001d0800720bULL, 0x000fc40003f7e000ULL, 0x0000000433047208ULL, 0x000fe40004800000ULL,
0x000000094c0a7208ULL, 0x000fe40004000000ULL, 0x0000000641057208ULL, 0x000fe40005000000ULL,
0x000000081d077208ULL, 0x000fe40005800000ULL, 0x000000450400720bULL, 0x000fe40003f3e000ULL,
0x0000004b0a00720bULL, 0x000fc40003f1e000ULL, 0x000000420500720bULL, 0x000fe40003f5e000ULL,
0x0000001e0700720bULL, 0x000fe40003f7e000ULL, 0x00000004450b7208ULL, 0x000fe40004800000ULL,
0x0000000a4b097208ULL, 0x000fe40004000000ULL, 0x0000000542047208ULL, 0x000fe40005000000ULL,
0x000000071e067208ULL, 0x000fc40005800000ULL, 0x0000004a0900720bULL, 0x000fe40003f1e000ULL,
0x000000440b00720bULL, 0x000fe40003f3e000ULL, 0x000000430400720bULL, 0x000fe40003f5e000ULL,
0x0000001f0600720bULL, 0x000fe40003f7e000ULL, 0x000000094a077208ULL, 0x000fe40004000000ULL,
0x0000000b440a7208ULL, 0x000fc40004800000ULL, 0x0000000443167208ULL, 0x000fe40005000000ULL,
0x000000061f157208ULL, 0x000fe20005800000ULL, 0x000020027f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704177208ULL, 0x000fe20004000000ULL, 0x000020127f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0016057f89ULL, 0x000e6800000e0000ULL,
0x0c401f0015067f89ULL, 0x000ea200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000051600720bULL, 0x002fe40003f3e000ULL, 0x0000000a04077208ULL, 0x004fe40004000000ULL,
0x0000001605087208ULL, 0x000fe20004800000ULL, 0x0c201f0017047f89ULL, 0x000e6200000e0000ULL,
0x000000061500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007147f89ULL, 0x000ea200000e0000ULL,
0x00000015060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000041700720bULL, 0x002fe40003f1e000ULL,
0x000000140700720bULL, 0x004fe40003f3e000ULL, 0x0000001704047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x0000000714057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x3fb8aa3b06157820ULL, 0x000fe20000410000ULL,
0x00000002ff5f7819ULL, 0x000fe20000011611ULL, 0x3fb8aa3b51147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b59517823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4a4a7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x0000005700087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b34347823ULL, 0x000fe20000010815ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44077823ULL, 0x000fe20000010807ULL, 0x0000001400577308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010815ULL, 0x0000000700447308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b43157823ULL, 0x000fe20000010815ULL, 0x0000002d00147308ULL, 0x0005e20000000800ULL,
0x0000000a0b077208ULL, 0x002fe20004000000ULL, 0x000000085f6a7824ULL, 0x040fe200078e00ffULL,
0x000000025f0b7810ULL, 0x040fe20007ffe0ffULL, 0x000000085f6c7824ULL, 0x040fe200078e00ffULL,
0x000000015f0a7810ULL, 0x040fe20007ffe0ffULL, 0x000000085f707824ULL, 0x000fe200078e00ffULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee20bULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b072d7820ULL, 0x004fe20000410000ULL, 0x000000085f727824ULL, 0x040fe200078e00ffULL,
0x000000055f0b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b24247823ULL, 0x000fe2000001082dULL,
0x0000005600097308ULL, 0x000ea20000000800ULL, 0xfffffff870707812ULL, 0x000fe200078ee20bULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082dULL, 0x0000002b140b723eULL, 0x002fe200000000ffULL,
0x0000004800597308ULL, 0x000fe20000000800ULL, 0xffffffff5f147810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b1a1a7823ULL, 0x000fe2000001082dULL, 0x0000000c19197812ULL, 0x000fc400078ec0ffULL,
0x0000000311ff7812ULL, 0x000fc6000780c0ffULL, 0x0000001500437308ULL, 0x0003e20000000800ULL,
0x000000080908723eULL, 0x004fce00000000ffULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x000000035f157810ULL, 0x002fc80007ffe0ffULL, 0xfffffff86c6c7812ULL, 0x000fe400078ee215ULL,
0x000000065f157810ULL, 0x040fe20007ffe0ffULL, 0x0000005400547308ULL, 0x000fe60000000800ULL,
0xfffffff872727812ULL, 0x000fe200078ee215ULL, 0x000000085f157824ULL, 0x000fc800078e00ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0xfffffff815747812ULL, 0x000fce00078ee214ULL,
0x0000004900497308ULL, 0x000e700000000800ULL, 0x00000030005b7308ULL, 0x000ff00000000800ULL,
0x0000004700567308ULL, 0x000fe20000000800ULL, 0x0000002a4909723eULL, 0x002fce00000000ffULL,
0x0000003200487308ULL, 0x000ff00000000800ULL, 0x0000003500167308ULL, 0x0003f00000000800ULL,
0x0000003400177308ULL, 0x0004e20000000800ULL, 0x000000085f357824ULL, 0x002fca00078e00ffULL,
0xfffffff8355e7812ULL, 0x000fe200078ee20aULL, 0x3c003c00ff357424ULL, 0x000fe200078e00ffULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000045f0a7810ULL, 0x000fe20007ffe0ffULL,
0x3c003c00ff347424ULL, 0x004fcc00078e00ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000161714723eULL, 0x008fce00000000ffULL, 0x0000002600307308ULL, 0x000ff00000000800ULL,
0x0000002700477308ULL, 0x0004e20000000800ULL, 0x000000363716723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x000000085f277824ULL, 0x004fca00078e00ffULL,
0xfffffff8276e7812ULL, 0x000fe400078ee20aULL, 0x0000002400327308ULL, 0x000e620000000800ULL,
0x00000055540a723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b1e547823ULL, 0x100fe2000001082dULL,
0x000000304715723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b1b307823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1d477823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1f557823ULL, 0x000fe4000001082dULL,
0x00000025005c7308ULL, 0x0005e20000000800ULL, 0x000000233217723eULL, 0x002fce00000000ffULL,
0x00000029005a7308ULL, 0x000fe20000000800ULL, 0x000000340824723cULL, 0x004f6200000018ffULL,
0x3fb8aa3b1c327823ULL, 0x000fcc000001082dULL, 0x00000028005d7308ULL, 0x0003f00000000800ULL,
0x0000005300537308ULL, 0x000fe20000000800ULL, 0x000000341428723cULL, 0x002f6e00000018ffULL,
0x0000005200527308ULL, 0x000e700000000800ULL, 0x0000005800587308ULL, 0x000eb00000000800ULL,
0x0000002c002c7308ULL, 0x000ee20000000800ULL, 0x00000053521c723eULL, 0x002fe200000000ffULL,
0x000000085f527824ULL, 0x000fca00078e00ffULL, 0xfffffff852527812ULL, 0x000fe200078ee25fULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x00000057581e723eULL, 0x004fe400000000ffULL,
0x000000085f587810ULL, 0x000fca0007ffe0ffULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x0000002c591d723eULL, 0x008fce00000000ffULL, 0x0000003900397308ULL, 0x000ea20000000800ULL,
0x0000002e5b1f723eULL, 0x002fce00000000ffULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x000000341c24723cULL, 0x020f6e0000001824ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000002200497308ULL, 0x0002f00000000800ULL, 0x0000002100367308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b20227823ULL, 0x002fe2000001082dULL, 0x000000383920723eULL, 0x004fe200000000ffULL,
0x00000008582d7824ULL, 0x000fca00078e00ffULL, 0x00000022001b7308ULL, 0x0002a20000000800ULL,
0x0000005a5d21723eULL, 0x008fe400000000ffULL, 0x0000005c4923723eULL, 0x000fe400000000ffULL,
0x000000105f5a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82d587812ULL, 0x000fe200078ee258ULL,
0x0000002f002f7308ULL, 0x000ee20000000800ULL, 0x0000003a3b22723eULL, 0x002fe200000000ffULL,
0x000000085a397824ULL, 0x000fe200078e00ffULL, 0x000000185f5f7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff8395a7812ULL, 0x000fe200078ee25aULL, 0x0000005100517308ULL, 0x000fe20000000800ULL,
0x000000342028723cULL, 0x000f620000001828ULL, 0x000000361b39723eULL, 0x004fe200000000ffULL,
0x000000085f5c7824ULL, 0x000fca00078e00ffULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x0000002f562d723eULL, 0x008fe400000000ffULL, 0xfffffff85c5c7812ULL, 0x000fca00078ee25fULL,
0x0000004f004f7308ULL, 0x000ff00000000800ULL, 0x0000004e004e7308ULL, 0x000ea20000000800ULL,
0x00000051502c723eULL, 0x002fce00000000ffULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0x0000004f4e2e723eULL, 0x004fce00000000ffULL,
0x0000003c003c7308ULL, 0x000ff00000000800ULL, 0x0000003d003d7308ULL, 0x000ea20000000800ULL,
0x00000031402f723eULL, 0x002fce00000000ffULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x000000342c24723cULL, 0x020f6e0000001824ULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x0000003c3d38723eULL, 0x004fe400000000ffULL, 0x0000a000123d7811ULL, 0x000fca00078e60ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000001052527824ULL, 0x100fe400078e023dULL,
0x000000105e5e7824ULL, 0x100fe400078e023dULL, 0x000000106a6a7824ULL, 0x100fe400078e023dULL,
0x000000106c6c7824ULL, 0x100fe200078e023dULL, 0x00000030003b7308ULL, 0x000ea20000000800ULL,
0x0000003e3f3a723eULL, 0x002fe200000000ffULL, 0x000000106e6e7824ULL, 0x000fc400078e023dULL,
0x0000001070707824ULL, 0x100fe400078e023dULL, 0x0000001072727824ULL, 0x000fe400078e023dULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x00000001521b7824ULL, 0x000fe400078e0219ULL,
0x0000001074747824ULL, 0x100fe400078e023dULL, 0x0000001058587824ULL, 0x100fe200078e023dULL,
0x000000081b007388ULL, 0x0003e20000000800ULL, 0x000000105a5a7824ULL, 0x100fe200078e023dULL,
0x0000004c004c7308ULL, 0x000ee20000000800ULL, 0x0000001a3b3b723eULL, 0x004fe200000000ffULL,
0x000000105c5c7824ULL, 0x000fc400078e023dULL, 0x00000001195e7824ULL, 0x040fe400078e025eULL,
0x00000001196a7824ULL, 0x040fe400078e026aULL, 0x0000003300337308ULL, 0x000ea20000000800ULL,
0x000000343828723cULL, 0x000fe20000001828ULL, 0x00000001196c7824ULL, 0x040fe200078e026cULL,
0x0000000a5e007388ULL, 0x0003e20000000800ULL, 0x00000001196e7824ULL, 0x040fe400078e026eULL,
0x0000000119707824ULL, 0x040fe200078e0270ULL, 0x0000001c6a007388ULL, 0x0003e20000000800ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000004d4c30723eULL, 0x008fe200000000ffULL,
0x0000000119727824ULL, 0x040fe200078e0272ULL, 0x0000001e6c007388ULL, 0x0007e20000000800ULL,
0x0000000119747824ULL, 0x000fc400078e0274ULL, 0x0000000119587824ULL, 0x000fe200078e0258ULL,
0x0000002c6e007388ULL, 0x0007e20000000800ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x000000483331723eULL, 0x004fe200000000ffULL, 0x00000001191b7824ULL, 0x042fe200078e025aULL,
0x0000002e70007388ULL, 0x0007e20000000800ULL, 0x00000001195c7824ULL, 0x000fc600078e025cULL,
0x0000003072007388ULL, 0x0007e20000000800ULL, 0x0000004500457308ULL, 0x000e700000000800ULL,
0x0000004600467308ULL, 0x000ff00000000800ULL, 0x0000004100417308ULL, 0x000ea20000000800ULL,
0x000000454433723eULL, 0x002fce00000000ffULL, 0x0000004200427308ULL, 0x000e700000000800ULL,
0x0000003200377308ULL, 0x0003e20000000800ULL, 0x00000046413c723eULL, 0x004fce00000000ffULL,
0x00000047004c7308ULL, 0x000ea20000000800ULL, 0x0000004b4a32723eULL, 0x002fe400000000ffULL,
0x00000042433e723eULL, 0x000fc600000000ffULL, 0x0000003274007388ULL, 0x0007e40000000800ULL,
0x00000054003f7308ULL, 0x000fe20000000800ULL, 0x000000343024723cULL, 0x020f620000001824ULL,
0x0000000958007388ULL, 0x0007e80000000800ULL, 0x0004000b5e007388ULL, 0x0007e40000000800ULL,
0x00000055001a7308ULL, 0x000e620000000800ULL, 0x000000374c3d723eULL, 0x004fe200000000ffULL,
0x0004001d6a007388ULL, 0x0007e80000000800ULL, 0x0004001f6c007388ULL, 0x0007e80000000800ULL,
0x0004002d6e007388ULL, 0x0007e80000000800ULL, 0x0004002f70007388ULL, 0x0007e20000000800ULL,
0x0000003f1a3f723eULL, 0x002fc400000000ffULL, 0x000000ffff257224ULL, 0x020fe200078e0026ULL,
0x0004003172007388ULL, 0x0007e80000000800ULL, 0x0004003374007388ULL, 0x0007e20000000800ULL,
0x000000343c28723cULL, 0x000f660000001828ULL, 0x000000141b007388ULL, 0x0007e80000000800ULL,
0x000800165e007388ULL, 0x0007e80000000800ULL, 0x000800206a007388ULL, 0x0007e80000000800ULL,
0x000800226c007388ULL, 0x0007e80000000800ULL, 0x000800386e007388ULL, 0x0007e80000000800ULL,
0x0008003a70007388ULL, 0x0007e20000000800ULL, 0x000000ffff267224ULL, 0x020fc400078e0028ULL,
0x000000ffff277224ULL, 0x000fe200078e002aULL, 0x0008003c72007388ULL, 0x0007e80000000800ULL,
0x0008003e74007388ULL, 0x0007e80000000800ULL, 0x000000155c007388ULL, 0x0007e80000000800ULL,
0x000c00175e007388ULL, 0x0007e80000000800ULL, 0x000c00216a007388ULL, 0x0007e80000000800ULL,
0x000c00236c007388ULL, 0x0007e80000000800ULL, 0x000c00396e007388ULL, 0x0007e80000000800ULL,
0x000c003b70007388ULL, 0x0007e80000000800ULL, 0x000c003d72007388ULL, 0x0007e80000000800ULL,
0x000c003f74007388ULL, 0x0007e80000000800ULL, 0x0120000418008388ULL, 0x0007e80000000c00ULL,
0x0122002418008388ULL, 0x0007e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000066ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080066ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100066ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000165657810ULL, 0x000fe20007ffe0ffULL, 0x0000180066ff7f8cULL, 0x0003e6000c80043fULL,
0x0000000e6500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff98a000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x0001651000267802ULL, 0x000fc40000000f00ULL,
0x0000108000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff177224ULL, 0x000fe200078e0025ULL,
0xfffec48000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005000000ULL,
0x0001656000267802ULL, 0x000fc40000000f00ULL, 0x0000103000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0025ULL, 0xfffec4e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x000165b000257802ULL, 0x000fc40000000f00ULL,
0x00000f9000007944ULL, 0x014fea0003c00000ULL, 0xfffec5b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x000165f000257802ULL, 0x000fc40000000f00ULL,
0x00000f5000007944ULL, 0x014fea0003c00000ULL, 0xfffec6e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x0001663000257802ULL, 0x000fc40000000f00ULL,
0x00000f1000007944ULL, 0x014fea0003c00000ULL, 0xfffec81000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x0001667000257802ULL, 0x000fc40000000f00ULL,
0x00000ed000007944ULL, 0x014fea0003c00000ULL, 0xfffec93000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x000166c000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0017ULL, 0x00000e8000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffecd2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001671000257802ULL, 0x000fc40000000f00ULL,
0x00000e3000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001017277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001676000257802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xfffeccd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x000167b000257802ULL, 0x000fc40000000f00ULL,
0x00000d9000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xfffeccb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x0001680000267802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffeee9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005000000ULL, 0x0001685000267802ULL, 0x000fc40000000f00ULL,
0x00000d4000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0025ULL,
0xfffeeed000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x000168a000257802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x014fea0003c00000ULL,
0xfffeefb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x000168e000257802ULL, 0x000fc40000000f00ULL, 0x00000c6000007944ULL, 0x014fea0003c00000ULL,
0xfffef0e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001692000257802ULL, 0x000fc40000000f00ULL, 0x00000c2000007944ULL, 0x014fea0003c00000ULL,
0xfffef21000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001696000257802ULL, 0x000fc40000000f00ULL, 0x00000be000007944ULL, 0x014fea0003c00000ULL,
0xfffef33000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000169b000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0029ULL,
0x00000b9000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffef75000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00016a0000257802ULL, 0x000fc40000000f00ULL, 0x00000b4000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001029277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00016a5000257802ULL, 0x000fc40000000f00ULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xfffef70000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00016aa000257802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xfffef6e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x00016af000267802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0025ULL,
0xffff16a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005000000ULL,
0x00016b4000267802ULL, 0x000fc40000000f00ULL, 0x00000a5000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff737224ULL, 0x000fe200078e0025ULL, 0xffff16f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x00016b9000257802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x014fea0003c00000ULL, 0xffff17d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x00016bd000257802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x014fea0003c00000ULL, 0xffff190000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x00016c1000257802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x014fea0003c00000ULL, 0xffff1a3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x00016c5000257802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x014fea0003c00000ULL, 0xffff1b5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00016ca000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0023ULL, 0x000008a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xffff1f7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00016cf000257802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001023277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00016d4000257802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xffff1f2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00016d9000257802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xffff1f0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x004fe40004000000ULL,
0x00016de000267802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff067224ULL, 0x000fe200078e0025ULL, 0xffff3fb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005000000ULL, 0x00016e3000267802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xffff400000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x00016e8000257802ULL, 0x000fc40000000f00ULL, 0x000006c000007944ULL, 0x010fea0003c00000ULL,
0xffff40d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x00016ec000257802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x010fea0003c00000ULL,
0xffff420000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x00016f0000257802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x010fea0003c00000ULL,
0xffff433000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x00016f4000257802ULL, 0x000fc40000000f00ULL, 0x0000060000007944ULL, 0x010fea0003c00000ULL,
0xffff445000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x00016f9000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0003ULL,
0x000005b000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xffff488000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x00016fe000257802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001003277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001703000257802ULL, 0x000fc40000000f00ULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xffff483000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x0001708000257802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xffff481000007947ULL, 0x000fea000383ffffULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x000170d000087802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffffdfc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e000aULL,
0x0001713000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0016ULL, 0x0001719000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x0000000a0b067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0015ULL, 0x000171f000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x000000160b167208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0017ULL, 0x0001725000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000150b0a7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x000172b000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000170b047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0016ULL, 0x0001731000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000060b057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x0001737000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000160b067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffde9000007947ULL, 0x000fea000383ffffULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000024027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe8b0002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000005b00007348ULL, 0x000fe80003800000ULL,
0x0c000014070b7389ULL, 0x0002a200000e005aULL, 0xfffe8ac008007950ULL, 0x000fea0003c3ffffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0025ULL, 0x0000008500007348ULL, 0x000fe80003800000ULL,
0x00000000ff6d7424ULL, 0x000fe200078e00ffULL, 0x0000002726267389ULL, 0x0002a600000e0088ULL,
0xfffe8a706c007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f45070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000008400007348ULL, 0x000ff60003800000ULL,
0x0000000000257806ULL, 0x000fc800050e0100ULL, 0x0000008425257212ULL, 0x000fe200078ec0ffULL,
0xfffe8a1026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000360ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c90ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d50ULL,
0x00000000000008a0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001600ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001690ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001694ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000017680ULL, 0xde00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018f00ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018f40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000192c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001690ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017870ULL,
0x0000000000017870ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000018f00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000192c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_86_cubin_len = 103328;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
