/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000183b0ULL, 0x0000000000018030ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x656b240061686d5fULL,
0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL, 0x6d6172665f677562ULL,
0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL, 0x665f67756265642eULL,
0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x00000061686d5f6cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001beULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000291ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000037bULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000424ULL, 0x00000000000169b0ULL, 0x0000000000000250ULL,
0x000400030000049aULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000016c00ULL, 0x000d0003000004caULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000169b000000000ULL, 0x0001080400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x000169b000000000ULL, 0x0000025000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000bcULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000023000dc2804ULL, 0x00000960000002d0ULL, 0x00002cc000002c50ULL,
0x00002ed000002da0ULL, 0x0000314000003000ULL, 0x000036c0000036b0ULL, 0x000036e0000036d0ULL,
0x000055c000005530ULL, 0x000057d0000056a0ULL, 0x00005a4000005900ULL, 0x00005f0000005ef0ULL,
0x00005f2000005f10ULL, 0x00007d0000007c70ULL, 0x00007f1000007de0ULL, 0x0000818000008040ULL,
0x0000864000008630ULL, 0x0000866000008650ULL, 0x0000a4900000a420ULL, 0x0000a6b00000a580ULL,
0x0000a9200000a7e0ULL, 0x0000ae400000ae30ULL, 0x0000ae600000ae50ULL, 0x0000c0c00000c0b0ULL,
0x0000c0e00000c0d0ULL, 0x00015280000151d0ULL, 0x0001566000015570ULL, 0x00015b5000015a60ULL,
0x00015f0000015e20ULL, 0x0000047004303904ULL, 0x0001a600000000ffULL, 0x0000055000040100ULL,
0x0001a60800000000ULL, 0x00000660003f0100ULL, 0x0001a68800000000ULL, 0x00000790003f0100ULL,
0x0001a6a800000006ULL, 0x000008a0003f0100ULL, 0x0001a6c800000004ULL, 0x00001000003f0100ULL,
0x0001a600000000ffULL, 0x0000118000090107ULL, 0x0001a68800000000ULL, 0x00001c20003f0101ULL,
0x00000000000000ffULL, 0x00001c8000040107ULL, 0x00000000000000ffULL, 0x00001d0000040101ULL,
0x0000002000000002ULL, 0x00001e50003f0101ULL, 0x0001a6c800000036ULL, 0x00001fe000090109ULL,
0x0001a6c800000038ULL, 0x000028f0003f0109ULL, 0x0001a6b000000038ULL, 0x000029c000090107ULL,
0x0001a6b00000003aULL, 0x000029d0003f0101ULL, 0x0001a60800000080ULL, 0x000029f0003f0101ULL,
0x0001a60800000080ULL, 0x00002b60003f0109ULL, 0x0001a60800000080ULL, 0x000032d0003f0109ULL,
0x0001a6a80000003aULL, 0x00003440003f0109ULL, 0x0001a6a80000003aULL, 0x00004850003f0109ULL,
0x0001a6c800000034ULL, 0x00004860003f0101ULL, 0x0001a68800000081ULL, 0x0000489000090101ULL,
0x0000000000000006ULL, 0x00004a00003f0109ULL, 0x0000000000000006ULL, 0x00005240003f0109ULL,
0x0001a6a80000007aULL, 0x000052e000090107ULL, 0x0001a6a800000084ULL, 0x000052f0003f0101ULL,
0x0001a62800000080ULL, 0x00005310003f0101ULL, 0x0001a62800000080ULL, 0x00005480003f0109ULL,
0x0001a62800000080ULL, 0x00005c10003f0109ULL, 0x0001a6b00000002fULL, 0x00005d9000090109ULL,
0x0001a6b000000037ULL, 0x00006f80003f0109ULL, 0x0001a6c800000034ULL, 0x00006f90003f0101ULL,
0x0001a69000000036ULL, 0x00006fc000090101ULL, 0x0000000000000006ULL, 0x00007130003f0109ULL,
0x0000000000000006ULL, 0x000079a0003f0109ULL, 0x0001a6b00000002eULL, 0x00007a2000090107ULL,
0x0001a6b000000086ULL, 0x00007a30003f0101ULL, 0x0001a64800000080ULL, 0x00007a50003f0101ULL,
0x0001a64800000080ULL, 0x00007bc0003f0109ULL, 0x0001a64800000080ULL, 0x00008350003f0109ULL,
0x0001a6a80000002fULL, 0x000084d000090109ULL, 0x0001a6a800000037ULL, 0x000096b0003f0109ULL,
0x0001a6c80000004dULL, 0x000096d0003f0101ULL, 0x0001a69800000036ULL, 0x0000970000090101ULL,
0x0001a6c80000004dULL, 0x00009890003f0109ULL, 0x0001a6c80000004dULL, 0x0000a190003f0109ULL,
0x0001a6a800000080ULL, 0x0000a1e000090107ULL, 0x0001a6a80000002eULL, 0x0000a1f0003f0101ULL,
0x0001a66800000009ULL, 0x0000a220003f0101ULL, 0x0001a66800000009ULL, 0x0000a390003f0109ULL,
0x0001a66800000009ULL, 0x0000aaf0003f0109ULL, 0x0001a6b00000002fULL, 0x0000ac7000090109ULL,
0x0001a6b000000037ULL, 0x0000bda0003f0109ULL, 0x0000000000000006ULL, 0x0000be10003f0101ULL,
0x0001a6a000000006ULL, 0x0000dc10003f0101ULL, 0x0001a600000000ffULL, 0x0000f56000090101ULL,
0x0001a600000000ffULL, 0x0000f6d000090109ULL, 0x0001a600000000ffULL, 0x0000fa1000090109ULL,
0x0001a600000000ffULL, 0x0000fa3000090101ULL, 0x0001a600000000ffULL, 0x0000fba000090109ULL,
0x0001a600000000ffULL, 0x00012ab000090109ULL, 0x0001a68800000052ULL, 0x00012e80003f0101ULL,
0x0001a68800000052ULL, 0x00012ff0003f0109ULL, 0x0001a68800000052ULL, 0x00016940003f0109ULL,
0x0001a60800000073ULL, 0x00016950003f0101ULL, 0x0001a61000000073ULL, 0x00016960003f0101ULL,
0x0001a61800000073ULL, 0x00016970003f0101ULL, 0x0001a62000000073ULL, 0x00053803003f0101ULL,
0x0000cfe000301c04ULL, 0x0000d1f00000d040ULL, 0x0000d4b00000d350ULL, 0x0000d7700000d610ULL,
0x0000da600000d8d0ULL, 0x0000fbd00000db60ULL, 0x000c0504000169a0ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001600080a04ULL, 0x0000000000600210ULL,
0x00000000000000bcULL, 0x0000001500000002ULL, 0x00000000000169b0ULL, 0x0000000000000044ULL,
0x0000001500000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000000c7919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x0000000000637919ULL, 0x000f2a0000002100ULL, 0x00000400ff067b82ULL, 0x000f620000000800ULL,
0x0000010000047ab9ULL, 0x000fce0000000800ULL, 0x00008600ff177b82ULL, 0x000ee20000000800ULL,
0x0000000300007306ULL, 0x004ea20000209000ULL, 0x000000ff0300720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00047836ULL, 0x004fcc0000000000ULL,
0x0000000400057305ULL, 0x0004e4000021f000ULL, 0x000000ffff047224ULL, 0x004fe400078e00ffULL,
0x000000ffff087224ULL, 0x00afc800078e0a05ULL, 0x0000000308077224ULL, 0x000fe400078e02ffULL,
0x0000000000087919ULL, 0x000e640000002600ULL, 0x0000000705057227ULL, 0x000fe400078e0004ULL,
0x0000000000077919ULL, 0x000ea80000002200ULL, 0x0000000605777227ULL, 0x020fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a77ULL, 0x0000000503007224ULL, 0x000fca00078e0206ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a03ULL,
0x0000000177770836ULL, 0x000fc60000000000ULL, 0x000000030000720cULL, 0x000fda0003f26070ULL,
0x0000000177771836ULL, 0x000fe20000000000ULL, 0x00000003ff77a212ULL, 0x000fc800078e33ffULL,
0x0000007700007306ULL, 0x000ee20000209000ULL, 0x000000ff7700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047836ULL, 0x008fe40000000000ULL,
0x000000040c007c24ULL, 0x004fe2000f8e0207ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x0004e2000021f000ULL, 0x00001fff0c0c7589ULL, 0x000f6200000e0000ULL,
0x000000ffff047224ULL, 0x004fe400078e00ffULL, 0x0000000577067224ULL, 0x008fc800078e02ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a06ULL, 0x0000000905057227ULL, 0x000fc800078e0004ULL,
0x0000000400047c24ULL, 0x110fe2000f8e0263ULL, 0x00000005ff637819ULL, 0x000fe20000011663ULL,
0x0000000805587227ULL, 0x002fc600078e00ffULL, 0x0000007f0400780cULL, 0x040fe20003f64070ULL,
0x000000ffff057224ULL, 0x000fe200078e0a58ULL, 0x00001fff63637589ULL, 0x000f6200000e0000ULL,
0x000000030400780cULL, 0x000fe40003f84070ULL, 0x0000000577007224ULL, 0x000fe400078e0208ULL,
0x0000000000057919ULL, 0x000f660000002700ULL, 0x000000770000720cULL, 0x000fc60003f06070ULL,
0x000000000007b919ULL, 0x000e620000008800ULL, 0x000004000006b802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a77ULL, 0x0000000158580836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000770000720cULL, 0x000fda0003f26070ULL,
0x0000000158581836ULL, 0x000fe20000000000ULL, 0x00000077ff58a212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000006540709b816ULL, 0x002fe20000000006ULL,
0x000000ffff007224ULL, 0x000fe200078e0a58ULL, 0x000000010400780cULL, 0x000fe20003f44070ULL,
0xff317217ff07b424ULL, 0x000fe400078e00ffULL, 0x0000000077777224ULL, 0x000fc400078e0208ULL,
0x000000040406b824ULL, 0x000fe200078e0209ULL, 0x0000000000240947ULL, 0x020fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400070600b388ULL, 0x0003e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000002077007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404067c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000060612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a6a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x0000001702077219ULL, 0x082fe200000006ffULL,
0x0000000205027224ULL, 0x000fe200078e02ffULL, 0x00000017030b7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000700720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002007757446ULL, 0x000fe20003800004ULL,
0x000000040c047824ULL, 0x000fe200078e0263ULL, 0x0000001758767219ULL, 0x000fc400000006ffULL,
0x000000ff75757207ULL, 0x000fe20000000000ULL, 0x0000000404047824ULL, 0x000fe400078e00ffULL,
0x0000000b02027224ULL, 0x000fe200078e0276ULL, 0x000000207500780cULL, 0x000fda0003f05270ULL,
0x0000000000c88947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x00000400000d7802ULL, 0x000fe20000000f00ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ea20000008800ULL,
0x0000000475077248ULL, 0x000fe40007fe0000ULL, 0x0000001708087219ULL, 0x000fc600000006ffULL,
0x0000000107077824ULL, 0x000fe200078e0a04ULL, 0x00000004ff067819ULL, 0x002fe4000001160aULL,
0x0000065410107816ULL, 0x004fc6000000000dULL, 0x00000002060e7836ULL, 0x000fe20000000000ULL,
0x000000070600720cULL, 0x080fe20003f06070ULL, 0x00000001040f7824ULL, 0x000fe200078e0206ULL,
0x00000000100972caULL, 0x000fe200000e0000ULL, 0x0000000104117824ULL, 0x000fe200078e020eULL,
0x000000070e00720cULL, 0x000fe20003f26070ULL, 0x0000000100097824ULL, 0x040fe400078e020fULL,
0x0000000100137824ULL, 0x000fe400078e0211ULL, 0x00000001110e7824ULL, 0x000fe200078e020aULL,
0x00000008090d7212ULL, 0x080fe200078e30ffULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0x0000000813157212ULL, 0x000fc400078e30ffULL, 0x00000017ff047219ULL, 0x080fe20000011609ULL,
0x00000001020d7824ULL, 0x040fe200078e020dULL, 0x00000017ff087219ULL, 0x000fe20000011613ULL,
0x0000000102157824ULL, 0x000fe200078e0215ULL, 0xfffffff0110e7812ULL, 0x000fe200078ee20eULL,
0x0000000b04067224ULL, 0x080fe400078e020dULL, 0x000000100a047824ULL, 0x000fe400078e00ffULL,
0x0000000b08087224ULL, 0x000fe400078e0215ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x000000f0040d7812ULL, 0x000fc600078ec0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000d06067212ULL, 0x000fc600078efcffULL, 0x000000010f027824ULL, 0x040fe200078e020aULL,
0x0000000d08087212ULL, 0x000fe200078efcffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000406067c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000408087c10ULL, 0x000fe4000ff7e0ffULL,
0xfffffff00f027812ULL, 0x000fe400078ee202ULL, 0x0000000507077c10ULL, 0x000fe400097fe4ffULL,
0x00000009020d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000509097c10ULL, 0x000fe40009ffe4ffULL,
0x000000090e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000c101c46ULL, 0x00000000080f7faeULL, 0x0003e2000c901c46ULL,
0x0000000000ac7947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0x0000040000087802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000117919ULL, 0x000ea20000008800ULL, 0x000000040a0d7211ULL, 0x002fe200078fe0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x0000065411087816ULL, 0x004fc60000000008ULL,
0x000000020d0f7836ULL, 0x000fe20000000000ULL, 0x0000001704097219ULL, 0x000fe200000006ffULL,
0x0000000100047824ULL, 0x000fe200078e020dULL, 0x00000000080972caULL, 0x000fe200000e0000ULL,
0x0000000100067824ULL, 0x000fe400078e020fULL, 0x000000100d137824ULL, 0x000fe200078e00ffULL,
0x0000000904077212ULL, 0x080fe200078e30ffULL, 0x000000100f0e7824ULL, 0x000fe200078e00ffULL,
0x0000000906097212ULL, 0x000fe400078e30ffULL, 0x00000017ff047219ULL, 0x080fe20000011604ULL,
0x0000000102077824ULL, 0x040fe200078e0207ULL, 0x00000017ff067219ULL, 0x000fe20000011606ULL,
0x0000000102097824ULL, 0x000fc400078e0209ULL, 0x0000000b04077224ULL, 0x080fe400078e0207ULL,
0x000000100a047824ULL, 0x000fe400078e00ffULL, 0x0000000b06097224ULL, 0x000fe400078e0209ULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x000000f004117812ULL, 0x000fc600078ec0ffULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x0000001106067212ULL, 0x000fc600078efcffULL,
0x000000010d027824ULL, 0x100fe200078e020aULL, 0x0000001108087212ULL, 0x000fe200078efcffULL,
0x000000010f0d7824ULL, 0x000fe200078e020aULL, 0x0000000406067c10ULL, 0x000fe4000ff1e0ffULL,
0xfffffff013027812ULL, 0x000fe400078ee202ULL, 0x0000000408087c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff00e0e7812ULL, 0x000fe400078ee20dULL, 0x0000000507077c10ULL, 0x000fc400087fe4ffULL,
0x00000009020d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000509097c10ULL, 0x000fe40008ffe4ffULL,
0x000000090e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000b901c46ULL, 0x00000000080f7faeULL, 0x0003e4000b901c46ULL,
0x0001a60009047890ULL, 0x000fe2000fffe03fULL, 0x00009200ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000405067825ULL, 0x002fe200078e0006ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000606747981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x0000003f74627836ULL, 0x004fe40000000000ULL,
0x000000ff74027836ULL, 0x000fc60000000000ULL, 0x00000006ff627819ULL, 0x000fe40000011662ULL,
0x00000008ff617819ULL, 0x000fca0000011602ULL, 0x000000c800ac8947ULL, 0x000fea0003800000ULL,
0x00000002ff5a7819ULL, 0x000fe20000011663ULL, 0xffffffffff087424ULL, 0x000fe400078e00ffULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0x03ffffff5a597812ULL, 0x000fc800078ec0ffULL,
0x000000625900720cULL, 0x000fda0003f06070ULL, 0x00009400ff098b82ULL, 0x000e620000000800ULL,
0x0000000205008824ULL, 0x000fce00078e00ffULL, 0x00009000ff068b82ULL, 0x000ea20000000a00ULL,
0x0000000900008224ULL, 0x002fc800078e0209ULL, 0x0000000159098824ULL, 0x000fe200078e0200ULL,
0x0000000963007c11ULL, 0x000fc6000f8e18ffULL, 0x0000000409068825ULL, 0x004fe200078e0006ULL,
0x01a6880d00ff79a7ULL, 0x0003e8000850003fULL, 0x0000000606088981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x0000004058587824ULL, 0x000fe200078e00ffULL,
0x00000001ff607819ULL, 0x000fca0000011663ULL, 0x00000020605b7824ULL, 0x000fca00078e00ffULL,
0x0000002058007812ULL, 0x002fe200078ef85bULL, 0x0000000308087224ULL, 0x004fe200078e02ffULL,
0x0000000163037812ULL, 0x000fc600078ec0ffULL, 0x0000004008137824ULL, 0x000fe200078e00ffULL,
0x0000000400080947ULL, 0x000fec0003800000ULL, 0x0000005b74027248ULL, 0x000fe20007fe0000ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fe2000001160aULL,
0x00008e00ff167b82ULL, 0x000e640000000a00ULL, 0x0000000102027824ULL, 0x000fe400078e0a5bULL,
0x0000000103077824ULL, 0x000fe400078e0206ULL, 0x0000000406097836ULL, 0x000fe20000000000ULL,
0x0000000302027248ULL, 0x000fe20007fe0000ULL, 0x0000000107087824ULL, 0x000fc400078e020aULL,
0x00000008070d7824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e0a03ULL,
0x0000000c060c7836ULL, 0x000fe20000000000ULL, 0xfffffff80d0e7812ULL, 0x000fe200078ee208ULL,
0x0000000806087836ULL, 0x000fe20000000000ULL, 0x000000020900720cULL, 0x080fe20003f46070ULL,
0x0000000103097824ULL, 0x040fe200078e0209ULL, 0x000000020600720cULL, 0x080fe20003f66070ULL,
0x00000001030d7824ULL, 0x000fe200078e0208ULL, 0x000000020800720cULL, 0x080fe20003f26070ULL,
0x0000000109067824ULL, 0x040fe200078e020aULL, 0x000000020c00720cULL, 0x000fe20003f06070ULL,
0x0000000809117824ULL, 0x000fc400078e00ffULL, 0x00000001030f7824ULL, 0x000fe400078e020cULL,
0x0000000100027824ULL, 0x040fe200078e0207ULL, 0xfffffff811107812ULL, 0x000fe200078ee206ULL,
0x0000000100067824ULL, 0x040fe200078e0209ULL, 0x0000001613117211ULL, 0x042fe200078838ffULL,
0x0000000100087824ULL, 0x040fe400078e020dULL, 0x00000001000c7824ULL, 0x000fe200078e020fULL,
0x0000001713177211ULL, 0x000fe200020f3cffULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x000000010f077824ULL, 0x140fe200078e020aULL, 0x0000007002027812ULL, 0x000fe200078ef804ULL,
0x000000080f147824ULL, 0x000fe400078e00ffULL, 0x000000010d007824ULL, 0x040fe200078e020aULL,
0x0000000211027210ULL, 0x000fe20007f9e0ffULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff80d127812ULL, 0x000fe200078ee200ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000000960007c11ULL, 0x000fe4000f8e68ffULL, 0x0000007006067812ULL, 0x000fe200078ef804ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef804ULL,
0x0000000103037824ULL, 0x000fe200020e0617ULL, 0x000000700c047812ULL, 0x000fe200078ef804ULL,
0x00016000000f7836ULL, 0x000fe20000000000ULL, 0x0000001106067210ULL, 0x000fe40007f9e0ffULL,
0x0000001108087210ULL, 0x000fe20007fbe0ffULL, 0x0000001010137824ULL, 0x100fe200078e020fULL,
0x00000011040c7210ULL, 0x000fe20007fde0ffULL, 0x000000100e117824ULL, 0x000fe400078e020fULL,
0x0000000107077824ULL, 0x000fc400020e0617ULL, 0x0000001012157824ULL, 0x000fe200078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002117faeULL, 0x0003e2000d901c46ULL,
0x0000000109097824ULL, 0x000fe400028e0617ULL, 0x00000010140f7824ULL, 0x000fe200078e020fULL,
0x0000000006137faeULL, 0x0003e2000d101c46ULL, 0x000000010d0d7824ULL, 0x000fc600030e0617ULL,
0x0000000008157faeULL, 0x0003e8000c901c46ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x0000000960117c11ULL, 0x000fc6000f8e68ffULL,
0x000000030a037211ULL, 0x000fca00078fe8ffULL, 0x0000000103027824ULL, 0x140fe400078e020aULL,
0x0000000803097824ULL, 0x000fe400078e00ffULL, 0x0000000403077836ULL, 0x000fe40000000000ULL,
0x0000000c030d7836ULL, 0x000fe20000000000ULL, 0xfffffff8090e7812ULL, 0x000fe200078ee202ULL,
0x0000000107067824ULL, 0x040fe400078e020aULL, 0x00000008070f7824ULL, 0x000fc400078e00ffULL,
0x0000000803097836ULL, 0x000fe40000000000ULL, 0x0000000100027824ULL, 0x040fe200078e0203ULL,
0xfffffff80f107812ULL, 0x000fe200078ee206ULL, 0x0000000100077824ULL, 0x040fe200078e0207ULL,
0x00000014130f7211ULL, 0x042fe200078038ffULL, 0x0000000100087824ULL, 0x040fe400078e0209ULL,
0x00000001000c7824ULL, 0x000fe200078e020dULL, 0x0000001513177211ULL, 0x000fe200000f3cffULL,
0x000000010d067824ULL, 0x000fc400078e020aULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x0000000109007824ULL, 0x000fe200078e020aULL, 0x0000007002027812ULL, 0x000fe200078ef804ULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x0000000809097824ULL, 0x000fe200078e00ffULL,
0x000000020f027210ULL, 0x000fe20007f1e0ffULL, 0x0001600011157836ULL, 0x000fe20000000000ULL,
0xfffffff80d127812ULL, 0x000fe200078ee206ULL, 0x0000008007067825ULL, 0x000fe200078e00ffULL,
0xfffffff809007812ULL, 0x000fc600078ee200ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fc600078ef804ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc600078ef804ULL, 0x0000000103037824ULL, 0x000fe200000e0617ULL,
0x000000700c047812ULL, 0x000fe200078ef804ULL, 0x0000001010117824ULL, 0x100fe200078e0215ULL,
0x000000060f067210ULL, 0x000fe20007f1e0ffULL, 0x0000001000137824ULL, 0x100fe200078e0215ULL,
0x000000080f087210ULL, 0x000fe40007f3e0ffULL, 0x000000040f0c7210ULL, 0x000fe20007f5e0ffULL,
0x000000100e0f7824ULL, 0x000fe400078e0215ULL, 0x0000000107077824ULL, 0x000fc400000e0617ULL,
0x0000000109097824ULL, 0x000fe200008e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0003e2000b901c46ULL, 0x0000001012157824ULL, 0x000fe400078e0215ULL,
0x000000010d0d7824ULL, 0x000fe200010e0617ULL, 0x0000000006117faeULL, 0x0003e8000b901c46ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x000000000c157faeULL, 0x0003e4000b901c46ULL,
0x0000000159597836ULL, 0x000fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000625900720cULL, 0x000fda0003f06070ULL, 0x00009400ff078b82ULL, 0x002e620000000800ULL,
0x0000000205008824ULL, 0x000fce00078e00ffULL, 0x00009000ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000700008224ULL, 0x002fc800078e0207ULL, 0x0000000100078824ULL, 0x000fc800078e0259ULL,
0x0000000407028825ULL, 0x004fc800078e0002ULL, 0x00000009ff077e24ULL, 0x000fe2000f8e00ffULL,
0x00000000600472caULL, 0x000fe200000e0000ULL, 0x0000000602818981ULL, 0x000322000c1e1900ULL,
0x000000ff6100720cULL, 0x000fe20003f05270ULL, 0x0001a6a807077836ULL, 0x000fe20000000000ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff827224ULL, 0x000fe200078e00ffULL,
0x00000000070572caULL, 0x000fe400000e0000ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000860027824ULL, 0x002fe200078e0207ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000009ff7879a7ULL, 0x0002a20008500004ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00002009020279a7ULL, 0x0002e2000850003fULL, 0x0000000000567805ULL, 0x000fe4000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x000000a000808947ULL, 0x000fec0003800000ULL,
0x00009400ff2f7b82ULL, 0x000f620000000800ULL, 0x0000000863027824ULL, 0x008fe200078e00ffULL,
0x0000000160007812ULL, 0x000fe200078ec0ffULL, 0x0000000205087824ULL, 0x000fe200078e00ffULL,
0x000000095a077c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff397224ULL, 0x000fe200078e0003ULL,
0x0000000802027812ULL, 0x000fe200078ec0ffULL, 0xff317217ff7e7424ULL, 0x000fe400078e00ffULL,
0x0000001000077824ULL, 0x000fc800078e0207ULL, 0x0000000102097824ULL, 0x002fe400078e0207ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x0000002f08087224ULL, 0x020fe400078e022fULL,
0x000000ffff2f7224ULL, 0x000fce00078e00ffULL, 0x000000ffff6e7224ULL, 0x000fce00078e0059ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000000463067824ULL, 0x000fca00078e00ffULL,
0xfffffff806367812ULL, 0x000fc800078ec0ffULL, 0x01a6c839360075a7ULL, 0x000e620008000149ULL,
0x0000000936387c36ULL, 0x000fc80008000000ULL, 0x0001a6c838067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01a6c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001063347824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000000107387836ULL, 0x000fe40000000000ULL, 0x0000000481817c24ULL, 0x010fe2000f8e02ffULL,
0xffffffe034367812ULL, 0x000fe400078ec0ffULL, 0x000000613800720cULL, 0x000fe20003f26070ULL,
0x0000004081817824ULL, 0x000fe400078e00ffULL, 0x0000010007367824ULL, 0x000fc800078e0236ULL,
0x0000004036397836ULL, 0x000fca0000000000ULL, 0x0000002039357812ULL, 0x000fca00078ec0ffULL,
0x00000001584c7824ULL, 0x000fe200078e0235ULL, 0x0000000400109947ULL, 0x000fec0003800000ULL,
0x0000001034377812ULL, 0x000fe400078ec0ffULL, 0x0000003974347248ULL, 0x000fe40007fe0000ULL,
0x00000003ff3a7819ULL, 0x000fc6000001160aULL, 0x0000000134347824ULL, 0x000fe400078e0a39ULL,
0x000000013a397824ULL, 0x100fe400078e0237ULL, 0x000000083a4d7836ULL, 0x000fe20000000000ULL,
0x0000003734367248ULL, 0x000fe20007fe0000ULL, 0x0000000139387824ULL, 0x040fe200078e020aULL,
0x00008e00ff347b82ULL, 0x000e620000000a00ULL, 0x00000008393b7824ULL, 0x000fe400078e00ffULL,
0x0000000136367824ULL, 0x000fc400078e0a37ULL, 0x000000014c397824ULL, 0x000fe200078e0239ULL,
0xfffffff83b4e7812ULL, 0x000fe200078ee238ULL, 0x000000043a3b7836ULL, 0x000fe20000000000ULL,
0x000000363a00720cULL, 0x080fe20003f86070ULL, 0x0000000c3a3a7836ULL, 0x000fe20000000000ULL,
0x000000364d00720cULL, 0x080fe20003f46070ULL, 0x000000100a387824ULL, 0x000fe200078e00ffULL,
0x000000363b00720cULL, 0x0c0fe20003f66070ULL, 0x000000013b3b7824ULL, 0x100fe200078e0237ULL,
0x000000363a00720cULL, 0x000fe20003f06070ULL, 0x000000014d4d7824ULL, 0x000fc400078e0237ULL,
0x000000013b367824ULL, 0x140fe400078e020aULL, 0x000000083b5d7824ULL, 0x000fe400078e00ffULL,
0x000000013a4f7824ULL, 0x000fe400078e0237ULL, 0x000000014d377824ULL, 0x040fe200078e020aULL,
0xfffffff85d5c7812ULL, 0x000fe200078ee236ULL, 0x000000084d5e7824ULL, 0x000fe200078e00ffULL,
0x00000070385d7812ULL, 0x000fe200078ec0ffULL, 0x0000008039387825ULL, 0x000fc600078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee237ULL, 0x000000014c367824ULL, 0x040fe400078e023bULL,
0x000000014c3a7824ULL, 0x040fe400078e024dULL, 0x000000014c4c7824ULL, 0x000fe400078e024fULL,
0x000000014f3b7824ULL, 0x040fe400078e020aULL, 0x000000084f647824ULL, 0x000fe200078e00ffULL,
0x00000034814f7211ULL, 0x002fe200078a38ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000005d38347212ULL, 0x000fc400078efcffULL, 0x0000003581677211ULL, 0x000fe200028f3cffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x000000344f347210ULL, 0x000fe40007fbe0ffULL,
0xfffffff864647812ULL, 0x000fe200078ee23bULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000005d36367212ULL, 0x000fc600078efcffULL, 0x0000000139357824ULL, 0x100fe200028e0667ULL,
0x0000000960397c11ULL, 0x000fe4000f8e68ffULL, 0x0000004f36367210ULL, 0x000fe40007fbe0ffULL,
0x0000005d3a387212ULL, 0x080fe200078efcffULL, 0x0001700039397836ULL, 0x000fe20000000000ULL,
0x0000005d4c3a7212ULL, 0x000fe200078efcffULL, 0x0000000137377824ULL, 0x000fe200028e0667ULL,
0x0000004f38387210ULL, 0x000fe20007fbe0ffULL, 0x000000105c5d7824ULL, 0x100fe200078e0239ULL,
0x0000004f3a3a7210ULL, 0x000fe20007fde0ffULL, 0x000000104e4f7824ULL, 0x000fc400078e0239ULL,
0x000000105e5f7824ULL, 0x100fe400078e0239ULL, 0x0000001064657824ULL, 0x000fe200078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344f7faeULL, 0x0003e2000e101c46ULL,
0x000000013b397824ULL, 0x100fe400028e0667ULL, 0x000000014d3b7824ULL, 0x000fe200030e0667ULL,
0x00000000365d7faeULL, 0x0003e8000d901c46ULL, 0x00000000385f7faeULL, 0x0003e8000d101c46ULL,
0x000000003a657faeULL, 0x0003e2000c101c46ULL, 0x0000000000dc7947ULL, 0x000fea0003800000ULL,
0x0000001034377812ULL, 0x000fe400078ec0ffULL, 0x00008e00ff347b82ULL, 0x000e640000000a00ULL,
0x000000370a377211ULL, 0x000fca00078fe8ffULL, 0x0000000437397836ULL, 0x000fe40000000000ULL,
0x0000000137367824ULL, 0x140fe400078e020aULL, 0x00000008373b7824ULL, 0x000fe400078e00ffULL,
0x0000000139387824ULL, 0x040fe400078e020aULL, 0x00000008394d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b4e7812ULL, 0x000fe200078ee236ULL, 0x000000014c367824ULL, 0x000fc400078e0237ULL,
0x00000008373b7836ULL, 0x000fe20000000000ULL, 0xfffffff84d5c7812ULL, 0x000fe200078ee238ULL,
0x000000100a387824ULL, 0x000fe400078e00ffULL, 0x0000000c374d7836ULL, 0x000fe20000000000ULL,
0x00000034815d7211ULL, 0x042fe200078038ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000070384f7812ULL, 0x000fe400078ec0ffULL, 0x0000003581817211ULL, 0x000fe200000f3cffULL,
0x000000014c3a7824ULL, 0x000fe200078e023bULL, 0x0000004f36347212ULL, 0x000fe200078efcffULL,
0x000000013b387824ULL, 0x000fc400078e020aULL, 0x000000083b5f7824ULL, 0x000fe200078e00ffULL,
0x000000345d347210ULL, 0x000fe20007f1e0ffULL, 0x000000014d3b7824ULL, 0x040fe400078e020aULL,
0x000000084d647824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5e7812ULL, 0x000fe200078ee238ULL,
0x000000014c397824ULL, 0x040fe400078e0239ULL, 0x000000014c4c7824ULL, 0x000fe200078e024dULL,
0xfffffff864647812ULL, 0x000fe200078ee23bULL, 0x0000008039387825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000004f38367212ULL, 0x000fc600078efcffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000004f3a387212ULL, 0x000fc600078efcffULL,
0x0000000137357824ULL, 0x000fe200000e0681ULL, 0x0000000960377c11ULL, 0x000fe4000f8e68ffULL,
0x0000004f4c3a7212ULL, 0x000fe400078efcffULL, 0x000000365d367210ULL, 0x000fe20007f1e0ffULL,
0x0001700037377836ULL, 0x000fe20000000000ULL, 0x000000385d387210ULL, 0x000fe40007f5e0ffULL,
0x0000003a5d3a7210ULL, 0x000fe20007f7e0ffULL, 0x000000104e4f7824ULL, 0x000fc400078e0237ULL,
0x000000105c5d7824ULL, 0x100fe400078e0237ULL, 0x000000105e5f7824ULL, 0x100fe200078e0237ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344f7faeULL, 0x0003e2000b901c46ULL,
0x0000001064657824ULL, 0x000fe400078e0237ULL, 0x0000000139377824ULL, 0x100fe400000e0681ULL,
0x000000013b397824ULL, 0x100fe400010e0681ULL, 0x000000014d3b7824ULL, 0x000fe200018e0681ULL,
0x00000000365d7faeULL, 0x0003e8000b901c46ULL, 0x00000000385f7faeULL, 0x0003e8000b901c46ULL,
0x000000003a657faeULL, 0x0003e4000b901c46ULL, 0x0000000159377836ULL, 0x002fe40000000000ULL,
0xffffffffff7c7424ULL, 0x000fc600078e00ffULL, 0x000000623700720cULL, 0x000fe20003f06070ULL,
0x00000008637a7824ULL, 0x000fca00078e00ffULL, 0xfffffff07a387812ULL, 0x000fca00078ec0ffULL,
0x00000009383a7c36ULL, 0x000fe40008000000ULL, 0x00009000ff348b82ULL, 0x000e620000000a00ULL,
0x0000000108378824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000003a0472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000437348825ULL, 0x002fd000078e0034ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x00000006347c8981ULL, 0x000322000c1e1900ULL, 0xffffffe07a367812ULL, 0x040fe200078ec0ffULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x000000107a377812ULL, 0x000fc800078ec0ffULL,
0x0000000937367c10ULL, 0x000fe4000fffe036ULL, 0x000000087a377812ULL, 0x000fca00078ec0ffULL,
0x0000000136807824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x01a6b0393a8679a7ULL, 0x0002e4000850003fULL, 0x01a60839803879a7ULL, 0x0022a4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a60839800075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a60839800075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000100a6d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff707819ULL, 0x000fe2000001160aULL,
0x0000002063347824ULL, 0x000fe400078e00ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000706d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff837224ULL, 0x000fe200078e007eULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fe400078ec0ffULL,
0x000000096d357c10ULL, 0x000fca000fffe034ULL, 0x0000000135357824ULL, 0x000fca00078e0270ULL,
0x01a0000035377984ULL, 0x000ea80000000800ULL, 0x01a2000035397984ULL, 0x000b620000000800ULL,
0x0000007e3700720bULL, 0x004fda0003f1d000ULL, 0x0000000000367806ULL, 0x000fc800000e0100ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x02afea0003800000ULL,
0x000000635a00720cULL, 0x000fe40003f45270ULL, 0x0000007e3700720bULL, 0x0c0fe40003f14000ULL,
0x0000007e37837209ULL, 0x000fd20007810000ULL, 0x000000096334ac11ULL, 0x000fe4000f8e38ffULL,
0x0000000000357806ULL, 0x000fe400000e0100ULL, 0x000000347034a210ULL, 0x000fe40007ffe06dULL,
0x000000ff3500720cULL, 0x000fc60003f05270ULL, 0x01a400833400a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007e83347221ULL, 0x000fe20000010100ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff000035ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000035ff7812ULL, 0x000fe2000788c0ffULL, 0x00000034003b7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc000001160aULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x0000003454547220ULL, 0x082fe20000410000ULL,
0x0000003455557220ULL, 0x080fe20000410000ULL, 0x000000343c3c7220ULL, 0x080fe20000410000ULL,
0x000000343d3d7220ULL, 0x080fe20000410000ULL, 0x0000003440407220ULL, 0x080fe20000410000ULL,
0x0000003441417220ULL, 0x080fe20000410000ULL, 0x0000003444447220ULL, 0x080fe20000410000ULL,
0x0000003445457220ULL, 0x080fe20000410000ULL, 0x0000003448487220ULL, 0x080fe20000410000ULL,
0x0000003449497220ULL, 0x080fe20000410000ULL, 0x0000003450507220ULL, 0x080fe20000410000ULL,
0x0000003451517220ULL, 0x080fe20000410000ULL, 0x0000003428287220ULL, 0x080fe20000410000ULL,
0x0000003429297220ULL, 0x080fe20000410000ULL, 0x0000003424247220ULL, 0x080fe20000410000ULL,
0x0000003425257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343b347589ULL, 0x004e6400000e0000ULL,
0x0000003456567220ULL, 0x082fe20000410000ULL, 0x0000003457577220ULL, 0x080fe20000410000ULL,
0x000000343e3e7220ULL, 0x080fe20000410000ULL, 0x000000343f3f7220ULL, 0x080fe20000410000ULL,
0x0000003442427220ULL, 0x080fe20000410000ULL, 0x0000003443437220ULL, 0x080fe20000410000ULL,
0x0000003446467220ULL, 0x080fe20000410000ULL, 0x0000003447477220ULL, 0x080fe20000410000ULL,
0x000000344a4a7220ULL, 0x080fe20000410000ULL, 0x000000344b4b7220ULL, 0x080fe20000410000ULL,
0x0000003452527220ULL, 0x080fe20000410000ULL, 0x0000003453537220ULL, 0x080fe20000410000ULL,
0x000000342a2a7220ULL, 0x080fe20000410000ULL, 0x000000342b2b7220ULL, 0x080fe20000410000ULL,
0x0000003426267220ULL, 0x080fe20000410000ULL, 0x0000003427277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x000000340c0c7220ULL, 0x082fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x000000341d1d7220ULL, 0x080fe20000410000ULL, 0x0000003420207220ULL, 0x080fe20000410000ULL,
0x0000003421217220ULL, 0x080fe20000410000ULL, 0x0000003430307220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000342c2c7220ULL, 0x080fe20000410000ULL,
0x000000342d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b82827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x000e6400000e0000ULL, 0x000000340e0e7220ULL, 0x082fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x000000341e1e7220ULL, 0x080fe20000410000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x000fce0000410000ULL, 0x0000003536ff7212ULL, 0x000fda00078030ffULL,
0x8000008337370221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700040308ULL, 0x000ea40000000800ULL,
0x0000000439390220ULL, 0x004fce0000410000ULL, 0x0000008239827221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x01a6a8793a0075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fce00078e00ffULL,
0x000000103b00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003936367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013b3b7836ULL, 0x000fce0000000000ULL,
0x01a6a8793a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991038357816ULL, 0x000fe200000000ffULL, 0x0000000263817824ULL, 0x040fe400078e00ffULL,
0x0000040063347824ULL, 0x000fe200078e00ffULL, 0x000000ff3500720cULL, 0x000fe20003f05270ULL,
0x00000004637d7824ULL, 0x000fe200078e00ffULL, 0x000000080a357812ULL, 0x000fe200078ec0ffULL,
0x00000009ff797e24ULL, 0x000fe2000f8e00ffULL, 0x0000000481717812ULL, 0x000fe200078ec0ffULL,
0x00000009ff377e24ULL, 0x000fe2000f8e00ffULL, 0x00000007356c7812ULL, 0x000fc400078ef80aULL,
0x000000710a357211ULL, 0x000fe400078fe0ffULL, 0x000000106c787812ULL, 0x040fe200078efcffULL,
0x000000086c367824ULL, 0x000fe200078e00ffULL, 0xfffff00034347812ULL, 0x000fe200078ec0ffULL,
0x000000016c7f7824ULL, 0x000fe200078e0235ULL, 0x000000047d7d7812ULL, 0x000fe200078ec0ffULL,
0x00000001357e7824ULL, 0x000fe200078e0278ULL, 0x0001200079797810ULL, 0x000fe20007ffe034ULL,
0x0000000878357824ULL, 0x000fe200078e00ffULL, 0x0000007d0a7d7211ULL, 0x000fe200078fe0ffULL,
0x0000100063347824ULL, 0x000fe200078e00ffULL, 0xfffffff8367f7812ULL, 0x000fe200078ee27fULL,
0x000000086c6f7824ULL, 0x040fe200078e00ffULL, 0xfffffff8357e7812ULL, 0x000fe200078ee27eULL,
0x000000016c4c7824ULL, 0x000fe200078e027dULL, 0xffffe00034347812ULL, 0x000fe200078ec0ffULL,
0x000000107f367824ULL, 0x000fc400078e0279ULL, 0x000000107e387824ULL, 0x000fe200078e0279ULL,
0x00016000374e7810ULL, 0x000fe40007ffe034ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee24cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x0000541000347816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f0534057589ULL, 0x0002a800000e0000ULL,
0x00001f3534027589ULL, 0x0002e800000e0000ULL, 0x00001f0334037589ULL, 0x00026800000e0000ULL,
0x00001f3734007589ULL, 0x00026400000e0000ULL, 0x000000003634783bULL, 0x002e620000000200ULL,
0x000000106f5c7824ULL, 0x000fc600078e024eULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x088fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x0000000538387232ULL, 0x084fe40000000000ULL,
0x000000053a3a7232ULL, 0x000fc40000000000ULL, 0x0000000039397232ULL, 0x080fe40000000000ULL,
0x000000003b3b7232ULL, 0x000fce0000000000ULL, 0x000000086c647824ULL, 0x000fe200078e00ffULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000024c7b7836ULL, 0x000fe20000000000ULL,
0x0000000271717812ULL, 0x000fc800078efcffULL, 0xfffffff8647b7812ULL, 0x000fca00078ee27bULL,
0x000000107b4e7824ULL, 0x000fcc00078e024eULL, 0x000000004e4c783bULL, 0x000f640000004200ULL,
0x000001005d657824ULL, 0x068fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001145dULL,
0x000001005c647824ULL, 0x000fe200078e00ffULL, 0x000088805d927816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x00000018ff937819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x000088805c857816ULL, 0x000fc400000000ffULL, 0x00000018ff8e7819ULL, 0x000fe2000001145cULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001145dULL,
0x0000006500957306ULL, 0x0007e20000200c00ULL, 0x00000018ff677819ULL, 0x004fe2000001144dULL,
0x000001004d687824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001144cULL,
0x000001004e697824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe4000001145cULL,
0x00000018ff8d7819ULL, 0x000fe2000001145eULL, 0x0000006400947306ULL, 0x0005e20000200c00ULL,
0x000001004c657824ULL, 0x008fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fc4000001145fULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe40000011465ULL, 0x0000009200927306ULL, 0x000ee20000200c00ULL,
0x000001005f647824ULL, 0x004fe200078e00ffULL, 0x000088804d657816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x000088805f5d7816ULL, 0x040fe200000000ffULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fc40000011464ULL,
0x0000009300937306ULL, 0x000ea20000200c00ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff8a7819ULL, 0x000fe40000011468ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000008500857306ULL, 0x000f620000200c00ULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fc40000011469ULL, 0x00000018ff6b7819ULL, 0x000fe2000001144fULL,
0x0000004d00847306ULL, 0x0007e20000200c00ULL, 0x000088804f697816ULL, 0x040fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000004c00897306ULL, 0x0005e20000200c00ULL,
0x00005410924d7816ULL, 0x008fe20000000095ULL, 0x000100004f927824ULL, 0x000fcc00078e00ffULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000001004f4c7824ULL, 0x006fe200078e00ffULL,
0x00005410934f7816ULL, 0x000fe40000000088ULL, 0x00000018ff887819ULL, 0x000fe40000011492ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000008d008d7306ULL, 0x000ff00000200c00ULL,
0x0000004c00727306ULL, 0x000bf00000200c00ULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x00005410854c7816ULL, 0x020fce0000000094ULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x0000004c3454723cULL, 0x000fec0000001854ULL, 0x0000004c380c723cULL, 0x000fe2000000180cULL,
0x0000006700677306ULL, 0x000eac0000200c00ULL, 0x00000001784c7824ULL, 0x040fe200078e027dULL,
0x0000541089667816ULL, 0x002fe20000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00000008787d7824ULL, 0x000fca00078e00ffULL, 0xfffffff87d7d7812ULL, 0x000fe400078ee24cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000541084677816ULL, 0x004fce0000000067ULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000663820723cULL, 0x000fe20000001820ULL, 0x0000005c005c7306ULL, 0x000ff00000200c00ULL,
0x0000008f008f7306ULL, 0x000e700000200c00ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce000000008fULL, 0x0000009000907306ULL, 0x000e700000200c00ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000054105d5d7816ULL, 0x002fce0000000090ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054105e5e7816ULL, 0x004fcc000000008dULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000005c3814723cULL, 0x000fe20000001814ULL, 0x000054105f5f7816ULL, 0x002fcc000000008cULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x0000005e3444723cULL, 0x000fee0000001844ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000005e3818723cULL, 0x000fe20000001818ULL,
0x0000541064647816ULL, 0x002fcc000000008bULL, 0x0000008a008a7306ULL, 0x000e700000200c00ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x002fce000000008aULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x000000643448723cULL, 0x000fee0000001848ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x00000064381c723cULL, 0x000fe2000000181cULL,
0x0000541068687816ULL, 0x002fcc0000000073ULL, 0x0000004e00857306ULL, 0x0002e20000200c00ULL,
0x0000000960737c11ULL, 0x000fca000f8e68ffULL, 0x0001600073847836ULL, 0x000fe20000000000ULL,
0x0000541069697816ULL, 0x004fe20000000072ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x00005410914e7816ULL, 0x002fe2000000008eULL, 0x000000107d5c7824ULL, 0x000fc800078e0284ULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x00005410856a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x00005410886b7816ULL, 0x004fca000000006bULL,
0x0000004e3810723cULL, 0x000fec0000001810ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x000000683830723cULL, 0x000fe20000001830ULL, 0x000000710a357211ULL, 0x000fe200078fe0ffULL,
0x000000086c347824ULL, 0x000fc400078e00ffULL, 0x0000000878377824ULL, 0x000fe400078e00ffULL,
0x000000016c717824ULL, 0x100fe200078e0235ULL, 0x0000006a3838723cULL, 0x000fe2000000182cULL,
0x0000000178727824ULL, 0x000fc600078e0235ULL, 0xfffffff834717812ULL, 0x000fe400078ee271ULL,
0xfffffff837727812ULL, 0x000fc600078ee272ULL, 0x0000001071347824ULL, 0x100fe400078e0279ULL,
0x0000001072797824ULL, 0x000fc800078e0279ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x00000000792c783bULL, 0x0004e20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000008784e7824ULL, 0x000fe200078e00ffULL,
0xfffffff881817812ULL, 0x000fe200078ec0ffULL, 0x000000024c797836ULL, 0x004fca0000000000ULL,
0xfffffff84e797812ULL, 0x000fca00078ee279ULL, 0x00000010794c7824ULL, 0x000fcc00078e0284ULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x000001005c647824ULL, 0x020fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001145dULL, 0x000001005d657824ULL, 0x040fe200078e00ffULL,
0x000088805d957816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff937819ULL, 0x000fc4000001145cULL,
0x000088805c897816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe2000001145eULL, 0x0000006400967306ULL, 0x000be20000200c00ULL,
0x00000018ff947819ULL, 0x000fe4000001145cULL, 0x000088805e5c7816ULL, 0x000fe200000000ffULL,
0x000001004c697824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001144dULL,
0x000001004d857824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001144cULL,
0x0000006500987306ULL, 0x0005e20000200c00ULL, 0x000001005f647824ULL, 0x028fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fc40000011469ULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x00000018ff687819ULL, 0x000fe20000011464ULL, 0x000100005e647824ULL, 0x000fe200078e00ffULL,
0x0000009500957306ULL, 0x000ee20000200c00ULL, 0x000088804e997816ULL, 0x000fe400000000ffULL,
0x00000018ff917819ULL, 0x000fe4000001145dULL, 0x00000018ff657819ULL, 0x004fe20000011464ULL,
0x000100005f647824ULL, 0x040fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001144fULL,
0x00000068005e7306ULL, 0x0005e20000200c00ULL, 0x000088805f5d7816ULL, 0x000fc400000000ffULL,
0x00000018ff927819ULL, 0x000fe40000011464ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001145fULL,
0x0000009700977306ULL, 0x000f620000200c00ULL, 0x000088804d687816ULL, 0x044fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff857819ULL, 0x000fc40000011485ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000008900897306ULL, 0x000ff00000200c00ULL, 0x00000069008d7306ULL, 0x0005f00000200c00ULL,
0x0000004d008a7306ULL, 0x0007e20000200c00ULL, 0x000001004e697824ULL, 0x004fc400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe40000011469ULL,
0x0000004c008b7306ULL, 0x0005e20000200c00ULL, 0x00005410954d7816ULL, 0x008fe20000000098ULL,
0x000100004f957824ULL, 0x040fe200078e00ffULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fc6000001144eULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000001004f4c7824ULL, 0x004fe200078e00ffULL, 0x00005410974f7816ULL, 0x022fe4000000008cULL,
0x00000018ff8c7819ULL, 0x000fe40000011495ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000065005f7306ULL, 0x000fe20000200c00ULL, 0x000054105d5d7816ULL, 0x008fce000000005eULL,
0x0000004c00887306ULL, 0x0003f00000200c00ULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x00005410894c7816ULL, 0x002fce0000000096ULL, 0x0000006800657306ULL, 0x000fe20000200c00ULL,
0x0000004c3454723cULL, 0x000fe20000001854ULL, 0x000054105f5e7816ULL, 0x004fcc0000000090ULL,
0x00000085008e7306ULL, 0x000e620000200c00ULL, 0x0000004c2c0c723cULL, 0x000fee000000180cULL,
0x0000009300937306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x002fce000000008eULL,
0x0000008f008f7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054108b667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054108a677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000663450723cULL, 0x000fee0000001850ULL,
0x0000009400947306ULL, 0x000fe20000200c00ULL, 0x000000662c20723cULL, 0x000fee0000001820ULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000009100917306ULL, 0x000e700000200c00ULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x000054105c5c7816ULL, 0x002fce0000000091ULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x00005410925f7816ULL, 0x004fcc000000008fULL, 0x0000009900687306ULL, 0x000fe20000200c00ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x0000541064647816ULL, 0x002fcc000000008dULL,
0x0000009a00857306ULL, 0x000e620000200c00ULL, 0x0000005e3444723cULL, 0x000fee0000001844ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x000000643448723cULL, 0x000fe20000001848ULL,
0x0000541068687816ULL, 0x002fcc0000000085ULL, 0x0000004e00897306ULL, 0x0002e20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541069697816ULL, 0x004fcc0000000088ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x00005410944e7816ULL, 0x002fe20000000093ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x00005410896a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fec000000183cULL, 0x000000683428723cULL, 0x000fe20000001828ULL,
0x000054108c6b7816ULL, 0x004fca000000006bULL, 0x0000004e2c10723cULL, 0x000fec0000001810ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x000000682c30723cULL, 0x000fe20000001830ULL,
0x0000000960347c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff367424ULL, 0x000fc800078e00ffULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x01a6c836343479a7ULL, 0x0002a2000850003fULL,
0x01a6883681ff79a7ULL, 0x0003de0008500009ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000010632c7824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x000000047c4e7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe02c2e7812ULL, 0x000fe400078ec0ffULL,
0x000000404e4e7824ULL, 0x000fc600078e00ffULL, 0x00000100072e7824ULL, 0x000fc800078e022eULL,
0x000000802e2f7836ULL, 0x000fca0000000000ULL, 0x000000202f2d7812ULL, 0x000fca00078ec0ffULL,
0x00000001582d7824ULL, 0x000fe200078e022dULL, 0x0000000400009947ULL, 0x000fec0003800000ULL,
0x000000102c377812ULL, 0x000fe400078ec0ffULL, 0x00000003ff2e7819ULL, 0x000fe4000001160aULL,
0x0000002f742c7248ULL, 0x000fc60007fe0000ULL, 0x000000012e367824ULL, 0x002fe400078e0237ULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2fULL, 0x00000001362f7824ULL, 0x040fe400078e020aULL,
0x0000000836347824ULL, 0x000fe200078e00ffULL, 0x0000002c372c7248ULL, 0x000fe20007fe0000ULL,
0x000000042e4c7836ULL, 0x000fe40000000000ULL, 0x0000000c2e4d7836ULL, 0x000fe20000000000ULL,
0xfffffff8345d7812ULL, 0x000fe200078ee22fULL, 0x000000012c2c7824ULL, 0x000fe200078e0a37ULL,
0x00008e00ff347b82ULL, 0x000e620000000a00ULL, 0x000000082e2f7836ULL, 0x000fc40000000000ULL,
0x0000000136367824ULL, 0x000fe200078e022dULL, 0x0000002c4c00720cULL, 0x0c0fe20003f66070ULL,
0x000000014c4c7824ULL, 0x100fe200078e0237ULL, 0x0000002c2e00720cULL, 0x080fe40003f86070ULL,
0x0000002c2f00720cULL, 0x080fe20003f46070ULL, 0x000000014c2e7824ULL, 0x040fe200078e020aULL,
0x0000002c4d00720cULL, 0x000fe20003f06070ULL, 0x000000084c5f7824ULL, 0x000fe400078e00ffULL,
0x000000012f2f7824ULL, 0x000fc400078e0237ULL, 0x000000014d377824ULL, 0x000fe200078e0237ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee22eULL, 0x000000014c4c7824ULL, 0x100fe400078e022dULL,
0x000000012f2e7824ULL, 0x100fe400078e022dULL, 0x00000001372c7824ULL, 0x000fe400078e022dULL,
0x000000012f2d7824ULL, 0x040fe200078e020aULL, 0x000000344e4f7211ULL, 0x002fe200078a38ffULL,
0x000000082f5c7824ULL, 0x000fc400078e00ffULL, 0x00000001372f7824ULL, 0x040fe200078e020aULL,
0x000000354e657211ULL, 0x000fe200028f3cffULL, 0x00000008375e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c677812ULL, 0x000fe200078ee22dULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff85e697812ULL, 0x000fe200078ee22fULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000006d36347212ULL, 0x000fc600078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d4c367212ULL, 0x080fe400078efcffULL, 0x000000344f347210ULL, 0x000fe20007fbe0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000004f36367210ULL, 0x000fe40007fde0ffULL,
0x0000006d2e2e7212ULL, 0x080fe200078efcffULL, 0x0000000137357824ULL, 0x100fe200028e0665ULL,
0x0000006d2c2c7212ULL, 0x000fe200078efcffULL, 0x000000014d377824ULL, 0x000fe200030e0665ULL,
0x0000004f2e2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000105d4d7824ULL, 0x100fe200078e0284ULL,
0x0000004f2c2c7210ULL, 0x000fe20007fde0ffULL, 0x000000105f4f7824ULL, 0x000fc400078e0284ULL,
0x00000010675d7824ULL, 0x100fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344d7faeULL, 0x0003e2000e101c46ULL, 0x000000012f2f7824ULL, 0x100fe400028e0665ULL,
0x00000010695f7824ULL, 0x000fe200078e0284ULL, 0x00000000364f7faeULL, 0x0003e2000d901c46ULL,
0x000000012d2d7824ULL, 0x000fc600030e0665ULL, 0x000000002e5d7faeULL, 0x0003e8000d101c46ULL,
0x000000002c5f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x00008e00ff367b82ULL, 0x002e620000000a00ULL, 0x000000102c2f7812ULL, 0x000fc800078ec0ffULL,
0x0000002f0a2f7211ULL, 0x000fca00078fe8ffULL, 0x000000012f2c7824ULL, 0x040fe400078e020aULL,
0x000000082f4f7824ULL, 0x040fe400078e00ffULL, 0x000000042f2e7836ULL, 0x000fe40000000000ULL,
0x000000082f357836ULL, 0x000fe20000000000ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee22cULL,
0x0000000c2f4d7836ULL, 0x000fe40000000000ULL, 0x000000012f4c7824ULL, 0x000fc400078e022dULL,
0x000000012e347824ULL, 0x140fe400078e022dULL, 0x000000012e2f7824ULL, 0x100fe200078e020aULL,
0x000000364e5d7211ULL, 0x002fe200078038ffULL, 0x000000082e5c7824ULL, 0x000fe400078e00ffULL,
0x00000001352e7824ULL, 0x100fe200078e022dULL, 0x000000374e657211ULL, 0x000fe200000f3cffULL,
0x000000014d2c7824ULL, 0x000fe200078e022dULL, 0xfffffff85c5f7812ULL, 0x000fe200078ee22fULL,
0x00000001352d7824ULL, 0x000fc400078e020aULL, 0x00000008355e7824ULL, 0x000fe400078e00ffULL,
0x000000014d357824ULL, 0x040fe400078e020aULL, 0x000000084d647824ULL, 0x000fe200078e00ffULL,
0xfffffff85e677812ULL, 0x000fe200078ee22dULL, 0x000000804c4c7825ULL, 0x000fc600078e00ffULL,
0xfffffff864697812ULL, 0x000fe200078ee235ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006d4c367212ULL, 0x000fc600078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x000000365d367210ULL, 0x000fe40007f1e0ffULL, 0x0000006d34347212ULL, 0x080fe200078efcffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000006d2e2e7212ULL, 0x000fc600078efcffULL,
0x000000014d377824ULL, 0x100fe200000e0665ULL, 0x0000006d2c2c7212ULL, 0x000fe200078efcffULL,
0x000000104f4d7824ULL, 0x100fe200078e0284ULL, 0x000000345d347210ULL, 0x000fe20007f1e0ffULL,
0x000000105f4f7824ULL, 0x100fe200078e0284ULL, 0x0000002e5d2e7210ULL, 0x000fe20007f5e0ffULL,
0x00000010695f7824ULL, 0x100fe200078e0284ULL, 0x0000002c5d2c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000135357824ULL, 0x000fe200000e0665ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000364d7faeULL, 0x0003e2000b901c46ULL, 0x00000010675d7824ULL, 0x000fc400078e0284ULL,
0x000000012f2f7824ULL, 0x100fe200010e0665ULL, 0x00000000344f7faeULL, 0x0003e2000b901c46ULL,
0x000000012d2d7824ULL, 0x000fc600018e0665ULL, 0x000000002e5d7faeULL, 0x0003e8000b901c46ULL,
0x000000002c5f7faeULL, 0x0003e4000b901c46ULL, 0x00000002592f7836ULL, 0x002fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000622f00720cULL, 0x000fe40003f06070ULL,
0xfffffff07a7a7812ULL, 0x000fca00078ec0ffULL, 0x000000097a847c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00009000ff2c8b82ULL, 0x000e620000000a00ULL,
0x00000000840472caULL, 0x000fe200000e0000ULL, 0x00000001082f8824ULL, 0x000fd800078e022fULL,
0x0001a6a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000042f2c8825ULL, 0x002fca00078e002cULL, 0x000000062c818981ULL, 0x000322000c1e1900ULL,
0x00000001ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x01a6a82f848479a7ULL, 0x0004e4000850003fULL, 0x01a6282f802e79a7ULL, 0x004464000850003fULL,
0x00000000002c7805ULL, 0x002fce0000015200ULL, 0x01a6282f800075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342c377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6282f800075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000020632c7824ULL, 0x000fe400078e00ffULL, 0x00000009ff2d7e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL,
0x000000802d2c7810ULL, 0x000fc80007ffe02cULL, 0x0000002c702c7210ULL, 0x000fca0007ffe06dULL,
0x01a000002c2e7984ULL, 0x000e680000000800ULL, 0x01a200002c2d7984ULL, 0x000b620000000800ULL,
0x000000832e00720bULL, 0x002fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x02cfea0003800000ULL,
0x000000015a2c7836ULL, 0x000fe20000000000ULL, 0x000000832e00720bULL, 0x000fc80003f14000ULL,
0x000000632c00720cULL, 0x000fda0003f45270ULL, 0x000000096334ac11ULL, 0x000fe4000f8e38ffULL,
0x000000832e2ca209ULL, 0x000fe40007810000ULL, 0x000000347035a210ULL, 0x000fe40007ffe06dULL,
0x0000000000347806ULL, 0x000fc600000e0100ULL, 0x01a4002c3500a388ULL, 0x0003e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x000000832e2c7209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x000000832c2c7221ULL, 0x000fe20000010100ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c00357308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x002fcc000001160aULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a2c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a2c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003582827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a2c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x000000832e837209ULL, 0x000fd60007810000ULL,
0x800000832e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000822d827221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x002fce0000015200ULL, 0x00000008632e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL, 0x01a6b0872f0075a7ULL, 0x000e620008000149ULL,
0x000000092f377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6b087370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x00000400632d7824ULL, 0x040fe400078e00ffULL, 0x00001000632e7824ULL, 0x000fe200078e00ffULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x00000009ff7c7e24ULL, 0x000fe2000f8e00ffULL,
0xfffff0002d2d7812ULL, 0x000fe200078ec0ffULL, 0x00000009ff2f7e24ULL, 0x000fe2000f8e00ffULL,
0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL, 0x000130007c7c7810ULL, 0x000fc40007ffe02dULL,
0x000170002f4c7810ULL, 0x000fc60007ffe02eULL, 0x000000107f347824ULL, 0x100fe400078e027cULL,
0x000000107e2c7824ULL, 0x000fe400078e027cULL, 0x000000106f5c7824ULL, 0x000fe200078e024cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x000000082e027836ULL, 0x000fe20000000000ULL,
0x00005410002d7816ULL, 0x000fe20000000000ULL, 0x000000102e367836ULL, 0x000fe40000000000ULL,
0x000000182e4e7836ULL, 0x000fe40000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4e2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000107b4c7824ULL, 0x000fcc00078e024cULL,
0x000000004c4c783bULL, 0x000f640000004200ULL, 0x000001005c647824ULL, 0x028fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe2000001145dULL, 0x000001005d657824ULL, 0x040fe200078e00ffULL,
0x000088805d927816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x000001004d697824ULL, 0x004fe200078e00ffULL, 0x0000006400947306ULL, 0x0005e20000200c00ULL,
0x00000018ff907819ULL, 0x000fe2000001145cULL, 0x000001004c687824ULL, 0x000fe200078e00ffULL,
0x000088805c897816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001145eULL, 0x0000006500977306ULL, 0x0007e20000200c00ULL,
0x000001005f647824ULL, 0x004fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fc4000001145cULL,
0x000088805e5c7816ULL, 0x040fe400000000ffULL, 0x00000018ff677819ULL, 0x000fe4000001144dULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x00000018ff657819ULL, 0x008fe20000011464ULL,
0x000100005e647824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe4000001144cULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff8f7819ULL, 0x000fe20000011464ULL,
0x00000065005e7306ULL, 0x0007e20000200c00ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fc4000001145dULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x000088804d657816ULL, 0x048fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001145fULL,
0x000088805f5d7816ULL, 0x040fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000009500957306ULL, 0x000ee20000200c00ULL,
0x00000018ff6a7819ULL, 0x000fc4000001144eULL, 0x000088804e877816ULL, 0x000fe400000000ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000008900897306ULL, 0x000ff00000200c00ULL, 0x0000004d00867306ULL, 0x0005f00000200c00ULL,
0x00000068008d7306ULL, 0x000be20000200c00ULL, 0x00005410924d7816ULL, 0x004fe20000000097ULL,
0x000100004f927824ULL, 0x000fcc00078e00ffULL, 0x0000004c008b7306ULL, 0x0005e20000200c00ULL,
0x000001004e687824ULL, 0x062fe400078e00ffULL, 0x000100004e4e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000069008a7306ULL, 0x0003e20000200c00ULL,
0x000001004f4c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc8000001144eULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x000088804f697816ULL, 0x002fe400000000ffULL, 0x00005410954f7816ULL, 0x008fe40000000088ULL,
0x00000018ff887819ULL, 0x000fc60000011492ULL, 0x0000004c007a7306ULL, 0x0003e20000200c00ULL,
0x000054105d5d7816ULL, 0x004fce000000005eULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x00005410894c7816ULL, 0x002fce0000000094ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x0000004c3454723cULL, 0x000fec0000001854ULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x0000008c008c7306ULL, 0x000fec0000200c00ULL, 0x00000010724c7824ULL, 0x000fc400078e027cULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054108b667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541086677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000663450723cULL, 0x000fee0000001850ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000005c005c7306ULL, 0x000ff00000200c00ULL,
0x0000009100917306ULL, 0x000e700000200c00ULL, 0x0000008f008f7306ULL, 0x000ea20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000091ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054108f5e7816ULL, 0x004fcc000000008eULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x000054105f5f7816ULL, 0x002fcc000000008cULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x0000541064647816ULL, 0x004fcc000000008dULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x0000541065657816ULL, 0x002fcc000000008aULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x0000541087687816ULL, 0x002fcc0000000068ULL,
0x0000004e00897306ULL, 0x0002e20000200c00ULL, 0x0000541069697816ULL, 0x004fce000000007aULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x00005410934e7816ULL, 0x002fe20000000090ULL,
0x00017000737a7836ULL, 0x000fe20000000000ULL, 0x000000683428723cULL, 0x000fe20000001828ULL,
0x00005410896a7816ULL, 0x008fca000000006aULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x00005410886b7816ULL, 0x004fca000000006bULL, 0x0000004e2c10723cULL, 0x000fec0000001810ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x000000682c30723cULL, 0x000fe20000001830ULL,
0x0000001071347824ULL, 0x000fc400078e027cULL, 0x000000107d7c7824ULL, 0x000fc600078e027aULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000004c2c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x080fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000007c5c783bULL, 0x000f620000004200ULL,
0x00000010794c7824ULL, 0x004fcc00078e027aULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x000001005c647824ULL, 0x020fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d947816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x000001004d687824ULL, 0x004fe200078e00ffULL,
0x0000006400967306ULL, 0x0005e20000200c00ULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001144cULL,
0x000001004e697824ULL, 0x000fe200078e00ffULL, 0x000088805c897816ULL, 0x000fc400000000ffULL,
0x00000018ff917819ULL, 0x000fe2000001145dULL, 0x0000006500977306ULL, 0x000be20000200c00ULL,
0x000001005f647824ULL, 0x044fe200078e00ffULL, 0x000088805f5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe4000001144dULL, 0x00000018ff8a7819ULL, 0x000fe40000011464ULL,
0x0000009400947306ULL, 0x000fe20000200c00ULL, 0x000001004c657824ULL, 0x068fe200078e00ffULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe2000001145cULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fc40000011465ULL, 0x000088804d657816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff937819ULL, 0x000fe4000001145cULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff8f7819ULL, 0x000fe2000001145eULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff8e7819ULL, 0x000fe2000001145fULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fc40000011468ULL,
0x00000018ff6a7819ULL, 0x000fe2000001144eULL, 0x0000008a008a7306ULL, 0x000ea20000200c00ULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011469ULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000004c008b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fc4000001145fULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x000054105d5d7816ULL, 0x004fe2000000008aULL,
0x0000004d00887306ULL, 0x0005e20000200c00ULL, 0x000001004f4c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000009200927306ULL, 0x000fe20000200c00ULL,
0x00005410944d7816ULL, 0x004fe20000000097ULL, 0x000100004f947824ULL, 0x000fca00078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x0000004c00867306ULL, 0x0005f00000200c00ULL,
0x0000009000907306ULL, 0x000fe20000200c00ULL, 0x00005410894c7816ULL, 0x004fce0000000096ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x0000004c3454723cULL, 0x002fec0000001854ULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x0000008e008e7306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054108b667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541088677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000663450723cULL, 0x000fee0000001850ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000009500957306ULL, 0x000e700000200c00ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00005410954f7816ULL, 0x002fce0000000090ULL,
0x0000009100917306ULL, 0x000e700000200c00ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000091ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054105e5e7816ULL, 0x004fcc000000008fULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x000054105f5f7816ULL, 0x002fcc000000008eULL, 0x0000008d008d7306ULL, 0x000e620000200c00ULL,
0x0000005e3444723cULL, 0x000fee0000001844ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541064647816ULL, 0x002fcc000000008dULL,
0x0000008c008c7306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541065657816ULL, 0x002fce000000008cULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x0000541068687816ULL, 0x002fcc0000000087ULL,
0x0000004e00897306ULL, 0x0002e20000200c00ULL, 0x0000541069697816ULL, 0x004fce0000000086ULL,
0x00000094008a7306ULL, 0x000ea20000200c00ULL, 0x00005410934e7816ULL, 0x002fe20000000092ULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x00005410896a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x000054108a6b7816ULL, 0x004fca000000006bULL,
0x0000004e2c10723cULL, 0x000fec0000001810ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x000000682c30723cULL, 0x000fe20000001830ULL, 0x0000000263357824ULL, 0x000fe200078e00ffULL,
0x0000000960347c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff835367812ULL, 0x000fe200078ec0ffULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x01a6c837343479a7ULL, 0x0002a4000850003fULL, 0x01a6903736ff79a7ULL, 0x0003de0008500009ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000010632c7824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x00000004814e7c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe02c2e7812ULL, 0x000fe400078ec0ffULL, 0x000000404e4e7824ULL, 0x000fc600078e00ffULL,
0x00000100072e7824ULL, 0x000fc800078e022eULL, 0x000000c02e2f7836ULL, 0x000fca0000000000ULL,
0x000000202f2d7812ULL, 0x000fca00078ec0ffULL, 0x0000000158377824ULL, 0x002fe200078e022dULL,
0x0000000400009947ULL, 0x000fec0003800000ULL, 0x000000102c357812ULL, 0x000fe400078ec0ffULL,
0x0000002f742c7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff347819ULL, 0x000fc6000001160aULL,
0x000000012c2e7824ULL, 0x000fe400078e0a2fULL, 0x00008e00ff2c7b82ULL, 0x000e620000000a00ULL,
0x00000001342f7824ULL, 0x000fe400078e0235ULL, 0x0000002e352e7248ULL, 0x000fe20007fe0000ULL,
0x00000008344c7836ULL, 0x000fe40000000000ULL, 0x000000012f367824ULL, 0x040fe400078e020aULL,
0x000000082f5f7824ULL, 0x000fc400078e00ffULL, 0x000000012e2e7824ULL, 0x000fe400078e0a35ULL,
0x0000000c344d7836ULL, 0x000fe20000000000ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee236ULL,
0x0000000434367836ULL, 0x000fe20000000000ULL, 0x0000002e3400720cULL, 0x080fe20003f86070ULL,
0x000000012f2f7824ULL, 0x000fe200078e0237ULL, 0x0000002e4c00720cULL, 0x080fe20003f46070ULL,
0x0000000136347824ULL, 0x140fe200078e0235ULL, 0x0000002e3600720cULL, 0x080fe20003f66070ULL,
0x000000014c367824ULL, 0x100fe200078e0235ULL, 0x0000002e4d00720cULL, 0x040fe20003f06070ULL,
0x000000014d5c7824ULL, 0x000fc400078e0235ULL, 0x0000000134357824ULL, 0x100fe200078e020aULL,
0x0000002c4e4f7211ULL, 0x002fe200078a38ffULL, 0x00000008345e7824ULL, 0x000fe400078e00ffULL,
0x000000802f2e7825ULL, 0x000fe200078e00ffULL, 0x0000002d4e5d7211ULL, 0x000fe400028f3cffULL,
0xfffffff85e657812ULL, 0x000fe200078ee235ULL, 0x00000001364c7824ULL, 0x000fe200078e020aULL,
0x0000006d2e2c7212ULL, 0x000fe200078efcffULL, 0x0000000836677824ULL, 0x000fc400078e00ffULL,
0x0000000134347824ULL, 0x100fe200078e0237ULL, 0x0000002c4f2c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000136367824ULL, 0x000fe200078e0237ULL, 0xfffffff867677812ULL, 0x000fe200078ee24cULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000015c4c7824ULL, 0x000fe200078e0237ULL,
0x0000006d342e7212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000006d36347212ULL, 0x000fc600078efcffULL,
0x000000012f2d7824ULL, 0x100fe200028e065dULL, 0x0000004f2e2e7210ULL, 0x000fe20007fbe0ffULL,
0x000000015c4e7824ULL, 0x000fe200078e020aULL, 0x0000006d4c367212ULL, 0x000fe200078efcffULL,
0x000000085c697824ULL, 0x000fe400078e00ffULL, 0x00000001352f7824ULL, 0x100fe200028e065dULL,
0x0000004f34347210ULL, 0x000fe20007fbe0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0x0000004f36367210ULL, 0x000fe20007fde0ffULL, 0x0000001065657824ULL, 0x100fe200078e027aULL,
0xfffffff8694f7812ULL, 0x000fe200078ee24eULL, 0x0000000137357824ULL, 0x000fe200028e065dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c5f7faeULL, 0x0003e2000e101c46ULL,
0x0000001067677824ULL, 0x000fc400078e027aULL, 0x000000014d377824ULL, 0x000fe200030e065dULL,
0x000000002e657faeULL, 0x0003e2000d901c46ULL, 0x000000104f4f7824ULL, 0x000fc600078e027aULL,
0x0000000034677faeULL, 0x0003e8000d101c46ULL, 0x00000000364f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x00008e00ff347b82ULL, 0x000e620000000a00ULL,
0x000000102c2d7812ULL, 0x000fc800078ec0ffULL, 0x0000002d0a2d7211ULL, 0x000fca00078fe8ffULL,
0x000000012d2c7824ULL, 0x040fe400078e020aULL, 0x000000082d4f7824ULL, 0x040fe400078e00ffULL,
0x000000042d2e7836ULL, 0x000fe40000000000ULL, 0x000000082d2f7836ULL, 0x000fe20000000000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee22cULL, 0x0000000c2d5c7836ULL, 0x000fe40000000000ULL,
0x000000012d367824ULL, 0x000fc400078e0237ULL, 0x000000012e4c7824ULL, 0x140fe400078e0237ULL,
0x000000012e2d7824ULL, 0x100fe200078e020aULL, 0x000000344e5d7211ULL, 0x002fe200078038ffULL,
0x000000082e5e7824ULL, 0x000fe400078e00ffULL, 0x000000012f2e7824ULL, 0x040fe200078e0237ULL,
0x000000354e5f7211ULL, 0x000fe200000f3cffULL, 0x000000012f4d7824ULL, 0x040fe200078e020aULL,
0xfffffff85e657812ULL, 0x000fe200078ee22dULL, 0x000000082f647824ULL, 0x000fc400078e00ffULL,
0x000000015c2c7824ULL, 0x040fe400078e0237ULL, 0x000000015c2f7824ULL, 0x040fe200078e020aULL,
0xfffffff864677812ULL, 0x000fe200078ee24dULL, 0x000000085c5c7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff85c697812ULL, 0x000fe200078ee22fULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000006d36347212ULL, 0x000fc600078efcffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x000000345d347210ULL, 0x000fe40007f1e0ffULL,
0x0000006d4c367212ULL, 0x080fe200078efcffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000006d2e2e7212ULL, 0x080fe400078efcffULL, 0x000000365d367210ULL, 0x000fe20007f5e0ffULL,
0x0000000137357824ULL, 0x100fe200000e065fULL, 0x0000006d2c2c7212ULL, 0x000fe200078efcffULL,
0x000000104f4f7824ULL, 0x100fe200078e027aULL, 0x0000002e5d2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000014d377824ULL, 0x100fe200010e065fULL, 0x0000002c5d2c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001065657824ULL, 0x000fe200078e027aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344f7faeULL, 0x0003e2000b901c46ULL, 0x000000012f2f7824ULL, 0x000fc400000e065fULL,
0x0000001067677824ULL, 0x100fe200078e027aULL, 0x0000000036657faeULL, 0x0003e2000b901c46ULL,
0x000000012d2d7824ULL, 0x000fe400018e065fULL, 0x0000001069697824ULL, 0x000fe200078e027aULL,
0x000000002e677faeULL, 0x0003e8000b901c46ULL, 0x000000002c697faeULL, 0x0003e4000b901c46ULL,
0x00000003592f7836ULL, 0x002fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000622f00720cULL, 0x000fe20003f06070ULL, 0x00000008632e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2e7812ULL, 0x000fca00078ec0ffULL, 0x000000092e867c36ULL, 0x000fe40008000000ULL,
0x00009000ff2c8b82ULL, 0x000e620000000a00ULL, 0x00000001082f8824ULL, 0x000fe200078e022fULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000860472caULL, 0x000fda00000e0000ULL,
0x0001a6b004047890ULL, 0x000fe2000fffe03fULL, 0x000000042f2c8825ULL, 0x002fd000078e002cULL,
0x00000000ff0079b0ULL, 0x000fe80008000a44ULL, 0x000000062c818981ULL, 0x000322000c1e1900ULL,
0x00000001ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x01a6b02f868679a7ULL, 0x0004e2000850003fULL, 0x01a6482f802c79a7ULL, 0x002464000850003fULL,
0x00000000002e7805ULL, 0x004fce0000015200ULL, 0x01a6482d800075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6482d800075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000020632c7824ULL, 0x000fe400078e00ffULL, 0x00000009ff2d7e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL,
0x000001002d2c7810ULL, 0x000fc80007ffe02cULL, 0x0000002c702c7210ULL, 0x000fca0007ffe06dULL,
0x01a000002c2e7984ULL, 0x000e680000000800ULL, 0x01a200002c2d7984ULL, 0x0004a20000000800ULL,
0x000000832e00720bULL, 0x002fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x00cfea0003800000ULL,
0x000000025a2c7836ULL, 0x000fe20000000000ULL, 0x000000832e00720bULL, 0x000fc80003f14000ULL,
0x000000632c00720cULL, 0x000fda0003f45270ULL, 0x000000096334ac11ULL, 0x000fe4000f8e38ffULL,
0x000000832e2ca209ULL, 0x000fe40007810000ULL, 0x000000347035a210ULL, 0x000fe40007ffe06dULL,
0x0000000000347806ULL, 0x000fc600000e0100ULL, 0x01a4002c3500a388ULL, 0x0003e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x000000832e2c7209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x000000832c2c7221ULL, 0x000fe20000010100ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c00357308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x002fcc000001160aULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a2c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a2c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003582827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a2c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x000000832e837209ULL, 0x000fd60007810000ULL,
0x800000832e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000822d827221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x002fce0000015200ULL, 0x0000000863807824ULL, 0x000fca00078e00ffULL,
0xfffffff0802f7812ULL, 0x000fc800078ec0ffULL, 0x01a6a8852f0075a7ULL, 0x000e620008000149ULL,
0x000000092f377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6a885370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x00000400632d7824ULL, 0x040fe400078e00ffULL, 0x00001000632e7824ULL, 0x000fe200078e00ffULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x00000009ff847e24ULL, 0x000fe2000f8e00ffULL,
0xfffff0002d2d7812ULL, 0x000fe200078ec0ffULL, 0x00000009ff2f7e24ULL, 0x000fe2000f8e00ffULL,
0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL, 0x0001400084847810ULL, 0x000fc40007ffe02dULL,
0x000160002f4e7810ULL, 0x000fc60007ffe02eULL, 0x000000107f347824ULL, 0x100fe400078e0284ULL,
0x000000107e2c7824ULL, 0x000fe400078e0284ULL, 0x000000106f5c7824ULL, 0x000fe200078e024eULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x000000082e027836ULL, 0x000fe20000000000ULL,
0x00005410002d7816ULL, 0x000fe20000000000ULL, 0x000000102e367836ULL, 0x000fe40000000000ULL,
0x000000182e4c7836ULL, 0x000fe40000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4c2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000107b4e7824ULL, 0x000fcc00078e024eULL,
0x000000004e4c783bULL, 0x000f640000004200ULL, 0x00000018ff8a7819ULL, 0x028fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d947816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001145fULL,
0x000001005c647824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x000001004d687824ULL, 0x004fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000006500977306ULL, 0x0005e20000200c00ULL, 0x000088805c887816ULL, 0x000fc400000000ffULL,
0x00000018ff917819ULL, 0x000fe4000001145dULL, 0x000088805f5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe2000001144dULL, 0x0000006400937306ULL, 0x0007e20000200c00ULL,
0x000001004c657824ULL, 0x004fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001145cULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe4000001144cULL,
0x00000018ff897819ULL, 0x000fc40000011465ULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x000001005f647824ULL, 0x008fe200078e00ffULL, 0x000088804d657816ULL, 0x000fe200000000ffULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe2000001145cULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe40000011464ULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000008a008a7306ULL, 0x000fe20000200c00ULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x00000018ff8d7819ULL, 0x000fe4000001145eULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x0000005f008e7306ULL, 0x0005e20000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe40000011468ULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x0000009500957306ULL, 0x000ee20000200c00ULL,
0x000001004e5f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001144fULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fc4000001145eULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000004d007e7306ULL, 0x0005e20000200c00ULL,
0x000088804f697816ULL, 0x000fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fca000001144eULL,
0x0000005f007f7306ULL, 0x000be20000200c00ULL, 0x000001004f4d7824ULL, 0x004fce00078e00ffULL,
0x0000004c00857306ULL, 0x0005e20000200c00ULL, 0x000100004f5f7824ULL, 0x022fe200078e00ffULL,
0x00005410954f7816ULL, 0x008fc8000000008aULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x00005410884c7816ULL, 0x004fe40000000093ULL,
0x00000018ff887819ULL, 0x000fca000001144dULL, 0x0000008d008d7306ULL, 0x000ff00000200c00ULL,
0x0000008b008b7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x0000541085667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054107e677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00016000737e7836ULL, 0x000fe20000000000ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x0000009400947306ULL, 0x000e620000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000009200927306ULL, 0x000fe20000200c00ULL,
0x00005410944d7816ULL, 0x002fce0000000097ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000004c3454723cULL, 0x000fee0000001854ULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x0000004c2c0c723cULL, 0x000fee000000180cULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000091ULL, 0x0000009000907306ULL, 0x000e700000200c00ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000054105d5d7816ULL, 0x002fce0000000090ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054105e5e7816ULL, 0x004fcc000000008dULL, 0x0000008900897306ULL, 0x000e620000200c00ULL,
0x0000005c2c14723cULL, 0x000fee0000001814ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x000000107d5c7824ULL, 0x000fe200078e027eULL, 0x0000541064647816ULL, 0x002fcc0000000089ULL,
0x0000008c008c7306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000541065657816ULL, 0x002fce000000008cULL, 0x0000004e007b7306ULL, 0x0002e20000200c00ULL,
0x000000643448723cULL, 0x000fe20000001848ULL, 0x0000541068687816ULL, 0x004fcc000000007fULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00005410924e7816ULL, 0x002fe2000000008fULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x000054107b6a7816ULL, 0x008fca000000006aULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x0000004e343c723cULL, 0x000fee000000183cULL,
0x0000005f008a7306ULL, 0x0004e20000200c00ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000541069697816ULL, 0x002fc40000000088ULL, 0x000054108e5f7816ULL, 0x004fca000000008bULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x000054108a6b7816ULL, 0x008fca000000006bULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000001071347824ULL, 0x000fc400078e0284ULL,
0x0000001072847824ULL, 0x000fc600078e0284ULL, 0x000000682c30723cULL, 0x000fe20000001830ULL,
0x000000003434783bULL, 0x000e6a0000000200ULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x00000000842c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x080fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x00000010794c7824ULL, 0x000fcc00078e027eULL, 0x000000004c4c783bULL, 0x000f640000004200ULL,
0x00000018ff897819ULL, 0x024fe2000001145dULL, 0x000001005d657824ULL, 0x040fe200078e00ffULL,
0x000088805d907816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001145fULL, 0x000001005c647824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x000001004d687824ULL, 0x008fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000006500917306ULL, 0x0005e20000200c00ULL,
0x00000018ff8b7819ULL, 0x000fc4000001145cULL, 0x00000018ff8d7819ULL, 0x000fe4000001145dULL,
0x000088805f5d7816ULL, 0x000fe400000000ffULL, 0x000088805c887816ULL, 0x000fe200000000ffULL,
0x00000064008f7306ULL, 0x0007e20000200c00ULL, 0x000001004c657824ULL, 0x004fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe2000001144dULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe4000001144cULL, 0x00000018ff7d7819ULL, 0x000fc40000011465ULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x000001005f647824ULL, 0x048fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001145cULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x000088804d657816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe40000011464ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc4000001144dULL,
0x00000018ff8a7819ULL, 0x000fe40000011468ULL, 0x00000018ff857819ULL, 0x000fe2000001145eULL,
0x0000005f008c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x000088804e687816ULL, 0x040fe200000000ffULL,
0x0000008e008e7306ULL, 0x000f620000200c00ULL, 0x000001004e5f7824ULL, 0x048fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001144fULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fc4000001145eULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000004d00847306ULL, 0x0007e20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x000088804f697816ULL, 0x000fca00000000ffULL, 0x0000005f00797306ULL, 0x0005e20000200c00ULL,
0x000001004f4d7824ULL, 0x008fce00078e00ffULL, 0x0000004c007b7306ULL, 0x0007e20000200c00ULL,
0x000100004f5f7824ULL, 0x006fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000004e00737306ULL, 0x000be20000200c00ULL, 0x00005410884c7816ULL, 0x008fe4000000008fULL,
0x00000018ff887819ULL, 0x000fca000001144dULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000054108e4e7816ULL, 0x020fce000000008bULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000007f007f7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054107b667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x0000541084677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000663450723cULL, 0x000fe20000001850ULL,
0x00005410736a7816ULL, 0x002fcc000000006aULL, 0x0000009000907306ULL, 0x000e620000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000009200927306ULL, 0x000ea20000200c00ULL,
0x00005410904d7816ULL, 0x002fce0000000091ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000004c3454723cULL, 0x000fe20000001854ULL, 0x00005410924f7816ULL, 0x004fcc0000000089ULL,
0x0000008d008d7306ULL, 0x000e620000200c00ULL, 0x0000004c2c0c723cULL, 0x000fee000000180cULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x00000009604d7c11ULL, 0x000fc4000f8e18ffULL, 0x000054105c5c7816ULL, 0x002fc8000000008dULL,
0x0000009400947306ULL, 0x000e620000200c00ULL, 0x0000004e2c10723cULL, 0x000fee0000001810ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000054105d5d7816ULL, 0x002fce0000000094ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054105e5e7816ULL, 0x004fcc0000000085ULL, 0x0000007d007d7306ULL, 0x000e620000200c00ULL,
0x0000005c2c14723cULL, 0x000fee0000001814ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000541064647816ULL, 0x002fce000000007dULL, 0x0000008a008a7306ULL, 0x000e700000200c00ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000541065657816ULL, 0x002fce000000008aULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000000643448723cULL, 0x000fe20000001848ULL,
0x0000541068687816ULL, 0x004fcc0000000079ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x000000642c1c723cULL, 0x000fee000000181cULL, 0x0000005f008e7306ULL, 0x0004e20000200c00ULL,
0x0000541069697816ULL, 0x002fe40000000088ULL, 0x000054108c5f7816ULL, 0x004fca000000007fULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x000054108e6b7816ULL, 0x008fca000000006bULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000000263347824ULL, 0x000fc400078e00ffULL,
0x00000001ff377424ULL, 0x000fc600078e00ffULL, 0xfffffff834367812ULL, 0x000fe200078ec0ffULL,
0x000000682c30723cULL, 0x000fe20000001830ULL, 0x01a6c8374d3479a7ULL, 0x0002aa000850003fULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x01a6983736ff79a7ULL, 0x0003de0008500009ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x01a6c8354d0075a7ULL, 0x004ea2000800017fULL, 0x000000035a367836ULL, 0x002fc80000000000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0036ULL, 0x0000000000600947ULL, 0x004fec0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x0000002c2e377210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x000000372c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff2d7224ULL, 0x000fca00000e062dULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a6c8354d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ffff2c7224ULL, 0x000fce00078e0036ULL,
0x0000000107347836ULL, 0x000fe40000000000ULL, 0x0000000359597836ULL, 0x000fc60000000000ULL,
0x000000613400720cULL, 0x000fda0003f06070ULL, 0x0000000800180947ULL, 0x000fea0003800000ULL,
0x00000002072e7836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000010034357824ULL, 0x000fe400078e025bULL, 0x00000004812d7c24ULL, 0x010fe2000f8e02ffULL,
0x000000612e00720cULL, 0x000fe40003f06070ULL, 0x00000020352f7812ULL, 0x000fe200078ec0ffULL,
0x000000402d2d7824ULL, 0x000fc800078e00ffULL, 0x0000000158377824ULL, 0x000fcc00078e022fULL,
0x0000000400048947ULL, 0x000fea0003800000ULL, 0x00000035742e7248ULL, 0x000fe20007fe0000ULL,
0x00000010632f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff367819ULL, 0x000fc6000001160aULL,
0x000000012e2e7824ULL, 0x000fe200078e0a35ULL, 0x000000102f357812ULL, 0x000fe200078ec0ffULL,
0x00000004364c7836ULL, 0x000fe40000000000ULL, 0x00000008364e7836ULL, 0x000fe20000000000ULL,
0x0000002e35347248ULL, 0x000fe20007fe0000ULL, 0x0000000c36597836ULL, 0x000fe20000000000ULL,
0x00008e00ff2e7b82ULL, 0x000e620000000a00ULL, 0x000000014c4d7824ULL, 0x100fe400078e0235ULL,
0x0000000134347824ULL, 0x000fc400078e0a35ULL, 0x000000014e4f7824ULL, 0x100fe400078e0235ULL,
0x000000084d5f7824ULL, 0x040fe200078e00ffULL, 0x000000343600720cULL, 0x0c0fe20003f86070ULL,
0x0000000136367824ULL, 0x100fe200078e0235ULL, 0x000000344e00720cULL, 0x080fe20003f46070ULL,
0x000000014d4e7824ULL, 0x100fe200078e020aULL, 0x000000344c00720cULL, 0x080fe20003f66070ULL,
0x00000001595c7824ULL, 0x040fe200078e0235ULL, 0x000000345900720cULL, 0x000fe20003f06070ULL,
0x00000001364c7824ULL, 0x040fe200078e020aULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee24eULL,
0x00000008365d7824ULL, 0x000fc400078e00ffULL, 0x000000014f357824ULL, 0x140fe400078e020aULL,
0x000000084f5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee24cULL,
0x0000000136347824ULL, 0x100fe200078e0237ULL, 0x0000002e2d597211ULL, 0x002fe200078a38ffULL,
0x000000014d367824ULL, 0x100fe200078e0237ULL, 0xfffffff85e657812ULL, 0x000fe200078ee235ULL,
0x000000015c4e7824ULL, 0x040fe200078e0237ULL, 0x0000002f2d2d7211ULL, 0x000fe200028f3cffULL,
0x000000015c4d7824ULL, 0x000fc400078e020aULL, 0x000000014f4c7824ULL, 0x000fe400078e0237ULL,
0x000000085c5c7824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff85c677812ULL, 0x000fe200078ee24dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006d342e7212ULL, 0x000fc600078efcffULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000006d36347212ULL, 0x080fe400078efcffULL, 0x0000002e592e7210ULL, 0x000fe20007fbe0ffULL,
0x000000804e4e7825ULL, 0x000fe200078e00ffULL, 0x0000005934347210ULL, 0x000fe40007fde0ffULL,
0x0000006d4c367212ULL, 0x080fe200078efcffULL, 0x00000001352f7824ULL, 0x100fe200028e062dULL,
0x0000006d4e4c7212ULL, 0x000fe200078efcffULL, 0x0000000137357824ULL, 0x000fe200030e062dULL,
0x0000005936367210ULL, 0x000fe20007fbe0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e027eULL,
0x000000594c4c7210ULL, 0x000fe20007fde0ffULL, 0x000000105f5f7824ULL, 0x000fc400078e027eULL,
0x0000001065657824ULL, 0x100fe200078e027eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e5d7faeULL, 0x0003e2000e101c46ULL, 0x000000014d377824ULL, 0x100fe400028e062dULL,
0x0000001067677824ULL, 0x000fe200078e027eULL, 0x00000000345f7faeULL, 0x0003e2000d901c46ULL,
0x000000014f4d7824ULL, 0x000fc600030e062dULL, 0x0000000036657faeULL, 0x0003e8000d101c46ULL,
0x000000004c677faeULL, 0x0003e2000c101c46ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x00000010632e7824ULL, 0x000fe200078e00ffULL, 0x00008e00ff4e7b82ULL, 0x000e680000000a00ULL,
0x000000102e2f7812ULL, 0x000fc800078ec0ffULL, 0x0000002f0a2f7211ULL, 0x000fca00078fe8ffULL,
0x000000012f2e7824ULL, 0x040fe400078e020aULL, 0x000000082f597824ULL, 0x040fe400078e00ffULL,
0x000000042f357836ULL, 0x000fe40000000000ULL, 0x000000082f5c7836ULL, 0x000fe20000000000ULL,
0xfffffff859597812ULL, 0x000fe200078ee22eULL, 0x000000012f2e7824ULL, 0x100fe400078e0237ULL,
0x0000000c2f2f7836ULL, 0x000fe20000000000ULL, 0x0000004e2d5d7211ULL, 0x002fe200078038ffULL,
0x0000000135347824ULL, 0x000fc400078e0237ULL, 0x00000001354d7824ULL, 0x100fe200078e020aULL,
0x0000004f2d4f7211ULL, 0x000fe200000f3cffULL, 0x00000008355e7824ULL, 0x000fe400078e00ffULL,
0x000000015c367824ULL, 0x140fe400078e0237ULL, 0x000000012f4c7824ULL, 0x040fe200078e0237ULL,
0xfffffff85e5f7812ULL, 0x000fe200078ee24dULL, 0x000000015c357824ULL, 0x100fe400078e020aULL,
0x000000012f377824ULL, 0x000fc400078e020aULL, 0x000000082f647824ULL, 0x000fe400078e00ffULL,
0x000000085c5c7824ULL, 0x000fe400078e00ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0xfffffff864677812ULL, 0x000fe400078ee237ULL, 0xfffffff85c657812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006d2e2e7212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000002e5d2e7210ULL, 0x000fe40007f1e0ffULL,
0x0000006d34347212ULL, 0x080fe200078efcffULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000006d36367212ULL, 0x000fc600078efcffULL, 0x000000012f2f7824ULL, 0x100fe200000e064fULL,
0x0000006d4c4c7212ULL, 0x000fe200078efcffULL, 0x0000001059597824ULL, 0x100fe200078e027eULL,
0x000000345d347210ULL, 0x000fe20007f1e0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027eULL,
0x000000365d367210ULL, 0x000fe20007f5e0ffULL, 0x0000001065657824ULL, 0x000fe200078e027eULL,
0x0000004c5d4c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000135357824ULL, 0x100fe200000e064fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e597faeULL, 0x0003e2000b901c46ULL,
0x0000000137377824ULL, 0x000fc400010e064fULL, 0x0000001067677824ULL, 0x000fe200078e027eULL,
0x00000000345f7faeULL, 0x0003e2000b901c46ULL, 0x000000014d4d7824ULL, 0x000fc600018e064fULL,
0x0000000036657faeULL, 0x0003e8000b901c46ULL, 0x000000004c677faeULL, 0x0003e4000b901c46ULL,
0x000000046e597836ULL, 0x002fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000625900720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00009000ff2e7b82ULL, 0x000e620000000a00ULL, 0x00000001082d7824ULL, 0x000fc800078e0259ULL,
0x000000042d2e7825ULL, 0x002fca00078e002eULL, 0x000000062e817981ULL, 0x000324000c1e1900ULL,
0xfffffff080807812ULL, 0x000fe200078ec0ffULL, 0x00000001ff367424ULL, 0x000fc800078e00ffULL,
0x00000009802e7c36ULL, 0x002fe20008000000ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x000000002e0472caULL, 0x000fda00000e0000ULL, 0x0001a6a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01a6a8362e2e79a7ULL, 0x0002a4000850003fULL, 0x01a66836093679a7ULL, 0x0022e4000850003fULL,
0x000000ffff797224ULL, 0x006fce00078e002fULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x01a66837090075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2d7819ULL, 0x000fc80000011435ULL, 0x000000342d2d7211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x000000022d2d7819ULL, 0x000fc80000001234ULL,
0x0000002d0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a66837090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000092c2c7c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff7e7224ULL, 0x000fe200078e0083ULL,
0x0000002c702c7210ULL, 0x000fca0007ffe06dULL, 0x01a000002c2e7984ULL, 0x000e680000000800ULL,
0x01a200002c2d7984ULL, 0x0004a20000000800ULL, 0x000000832e00720bULL, 0x002fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x004fea0003800000ULL, 0x000000035a2c7836ULL, 0x000fe20000000000ULL,
0x000000832e00720bULL, 0x0c0fe40003f14000ULL, 0x000000832e7e7209ULL, 0x000fe40007810000ULL,
0x000000632c00720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x00000009632cac11ULL, 0x000fe4000f8e38ffULL, 0x000000ff3400720cULL, 0x000fe40003f05270ULL,
0x0000002c706da210ULL, 0x000fca0007ffe06dULL, 0x01a4007e6d00a388ULL, 0x0003ec0000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x000000837e2c7221ULL, 0x000fe20000010100ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x0000002c00357308ULL, 0x0004ec0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x004fcc000001160aULL,
0x00001f2c352c7589ULL, 0x008ea400000e0000ULL, 0x000000542c547220ULL, 0x044fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a2c7811ULL, 0x004fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x008ea400000e0000ULL,
0x000000562c567220ULL, 0x044fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a2c7811ULL, 0x004fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x008ea400000e0000ULL, 0x0000000c2c0c7220ULL, 0x044fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003582827220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a2c7811ULL, 0x004fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000ea400000e0000ULL, 0x0000000e2c0e7220ULL, 0x044fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x0000002e7e2c0221ULL, 0x004fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL,
0x0000002c00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000822d827221ULL, 0x000fe20000010000ULL, 0x0000000160367812ULL, 0x000fce00078ec0ffULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000008632e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL, 0x01a6b0872f0075a7ULL, 0x000ea20008000149ULL,
0x000000092f377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x004fec0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a6b087370075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x000000035a6e7836ULL, 0x000fe20000000000ULL, 0x00000004ff2d7819ULL, 0x000fe2000001160aULL,
0x00000004632f7824ULL, 0x000fe200078e00ffULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x000000086c357824ULL, 0x000fe200078e00ffULL, 0x000000096e6e7c11ULL, 0x000fe2000f8e60ffULL,
0x00000004362d7824ULL, 0x000fe200078e022dULL, 0x000000042f7b7812ULL, 0x000fe200078ec0ffULL,
0x0000000878377824ULL, 0x000fe400078e00ffULL, 0x000000016c2c7824ULL, 0x100fe200078e022dULL,
0x000000027b7b7812ULL, 0x000fe200078efcffULL, 0x00000001782e7824ULL, 0x000fc400078e022dULL,
0x000120006e6e7836ULL, 0x000fe20000000000ULL, 0xfffffff8352d7812ULL, 0x000fe200078ee22cULL,
0x000000106f4c7824ULL, 0x000fe200078e027aULL, 0xfffffff8372f7812ULL, 0x000fc600078ee22eULL,
0x000000102d2d7824ULL, 0x100fe400078e026eULL, 0x000000102f2f7824ULL, 0x000fe200078e026eULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x00005410002c7816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f052c057589ULL, 0x0004e800000e0000ULL,
0x00001f352c027589ULL, 0x00046800000e0000ULL, 0x00001f032c037589ULL, 0x00046800000e0000ULL,
0x00001f372c007589ULL, 0x00046400000e0000ULL, 0x000000002d5c783bULL, 0x000ae80000000200ULL,
0x000000002f34783bULL, 0x0044620000000200ULL, 0x0000000000200947ULL, 0x020fea0003800000ULL,
0x000000035c5c7232ULL, 0x08afe40000000000ULL, 0x000000035e5e7232ULL, 0x000fe40000000000ULL,
0x000000025d5d7232ULL, 0x080fe40000000000ULL, 0x000000025f5f7232ULL, 0x000fe40000000000ULL,
0x0000000534347232ULL, 0x080fe40000000000ULL, 0x0000000536367232ULL, 0x000fc40000000000ULL,
0x0000000035357232ULL, 0x080fe40000000000ULL, 0x0000000037377232ULL, 0x000fce0000000000ULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x0000007b0a7b7211ULL, 0x000fe200078fe0ffULL,
0x000000086c2d7824ULL, 0x000fc800078e00ffULL, 0x000000016c6c7824ULL, 0x000fca00078e027bULL,
0xfffffff82d2d7812ULL, 0x000fca00078ee26cULL, 0x000000102d2d7824ULL, 0x000fcc00078e027aULL,
0x000000002d2c783bULL, 0x004ea20000004200ULL, 0x000001004c677824ULL, 0x060fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe2000001144cULL, 0x000001004d687824ULL, 0x040fe200078e00ffULL,
0x000088804c667816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011467ULL, 0x000001004e697824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe2000001144dULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000088804d677816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc4000001144cULL, 0x00000018ff807819ULL, 0x000fe40000011468ULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004c00877306ULL, 0x000be20000200c00ULL,
0x00000018ff6a7819ULL, 0x000fe4000001144eULL, 0x000088804e687816ULL, 0x040fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011469ULL,
0x000001002e837824ULL, 0x004fe200078e00ffULL, 0x000088804f697816ULL, 0x040fe200000000ffULL,
0x0000004d00867306ULL, 0x0005e20000200c00ULL, 0x000001004f4c7824ULL, 0x028fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe2000001142cULL, 0x000001002f8b7824ULL, 0x000fe200078e00ffULL,
0x000088802c6c7816ULL, 0x000fc400000000ffULL, 0x00000018ff887819ULL, 0x000fe4000001144cULL,
0x00000018ff4c7819ULL, 0x000fe2000001144eULL, 0x000100004f4d7824ULL, 0x004fe200078e00ffULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff7d7819ULL, 0x000fe4000001142eULL, 0x00000018ff4e7819ULL, 0x000fe2000001144dULL,
0x000001002c4d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001142fULL,
0x0000008500857306ULL, 0x000ea20000200c00ULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x000088802e707816ULL, 0x040fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x000088802f8a7816ULL, 0x040fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001142cULL, 0x000100002d2c7824ULL, 0x040fe200078e00ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000088802d6d7816ULL, 0x002fc400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001142dULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00000018ff8b7819ULL, 0x000fe4000001148bULL,
0x0000541068687816ULL, 0x004fc40000000085ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x00000018ff857819ULL, 0x000fe4000001142fULL,
0x0000541087647816ULL, 0x000fe40000000064ULL, 0x0000541067677816ULL, 0x002fc60000000080ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000541086657816ULL, 0x004fce0000000065ULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x000000643410723cULL, 0x000fee0000001810ULL,
0x0000004c004f7306ULL, 0x0005e20000200c00ULL, 0x000000645c3c723cULL, 0x000fe2000000183cULL,
0x0000541069697816ULL, 0x002fcc0000000088ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000001002d4c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x000000683414723cULL, 0x000fe20000001814ULL, 0x0000007f002d7306ULL, 0x000fea0000200c00ULL,
0x000000685c40723cULL, 0x000fe60000001840ULL, 0x0000004c004c7306ULL, 0x000e700000200c00ULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x000054106d6d7816ULL, 0x002fce000000004cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000010714c7824ULL, 0x000fe200078e026eULL,
0x000054104f6a7816ULL, 0x004fcc000000006aULL, 0x0000008400847306ULL, 0x000ff00000200c00ULL,
0x0000006f006f7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000ff00000200c00ULL,
0x0000008900897306ULL, 0x000e700000200c00ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x0000541066667816ULL, 0x002fce0000000089ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000066340c723cULL, 0x000fe2000000180cULL, 0x000054104e6b7816ULL, 0x004fcc000000006bULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000000665c54723cULL, 0x000fee0000001854ULL,
0x0000002c002c7306ULL, 0x000ea20000200c00ULL, 0x0000006a3418723cULL, 0x000fe20000001818ULL,
0x000054106c6c7816ULL, 0x002fcc000000004dULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000006a5c44723cULL, 0x000fe20000001844ULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x000054102c6f7816ULL, 0x004fca000000006fULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x0000006c341c723cULL, 0x000fec000000181cULL, 0x0000006c5c48723cULL, 0x000fe20000001848ULL,
0x0000008a007f7306ULL, 0x000fe20000200c00ULL, 0x0000541070707816ULL, 0x004fce0000000083ULL,
0x0000008b00807306ULL, 0x000eb00000200c00ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000054107f717816ULL, 0x004fce0000000080ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x000000703430723cULL, 0x000fee0000001830ULL, 0x0000002e00867306ULL, 0x0004e20000200c00ULL,
0x000000705c28723cULL, 0x000fee0000001828ULL, 0x0000008500887306ULL, 0x000f620000200c00ULL,
0x00000010722e7824ULL, 0x004fe200078e026eULL, 0x000054102d6e7816ULL, 0x000fc40000000084ULL,
0x0000541086727816ULL, 0x008fc6000000007dULL, 0x000000002e2c783bULL, 0x000ea40000000200ULL,
0x0000006e3420723cULL, 0x000fe20000001820ULL, 0x0000541088737816ULL, 0x020fca0000000073ULL,
0x0000006e5c50723cULL, 0x000fec0000001850ULL, 0x000000725c24723cULL, 0x000fec0000001824ULL,
0x000000723434723cULL, 0x000fe20000001838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000200947ULL, 0x002fde0003800000ULL, 0x000000034c4c7232ULL, 0x080fe40000000000ULL,
0x000000034e4e7232ULL, 0x000fe40000000000ULL, 0x000000024d4d7232ULL, 0x080fe40000000000ULL,
0x000000024f4f7232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x084fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000007c5c783bULL, 0x000e620000004200ULL,
0x00000001787b7824ULL, 0x040fe400078e027bULL, 0x0000000878787824ULL, 0x000fe400078e00ffULL,
0x0000000107077836ULL, 0x000fc60000000000ULL, 0xfffffff8787b7812ULL, 0x000fe200078ee27bULL,
0x000001005c387824ULL, 0x042fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001145cULL,
0x000001005d397824ULL, 0x000fe200078e00ffULL, 0x000088805c677816ULL, 0x040fe200000000ffULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe20000011438ULL,
0x000000107b387824ULL, 0x000fe200078e027aULL, 0x00000018ff807819ULL, 0x000fe20000011439ULL,
0x000001005e647824ULL, 0x040fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x00000018ff6d7819ULL, 0x000fe2000001145eULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x000088805e727816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x000088805d7f7816ULL, 0x000fc400000000ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001145fULL, 0x0000005c007d7306ULL, 0x0007e20000200c00ULL,
0x000088805f737816ULL, 0x000fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001145dULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000007c007c7306ULL, 0x000f620000200c00ULL,
0x000001005f5c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x000100005f5f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x000fce000001145fULL,
0x0000008000807306ULL, 0x000ef00000200c00ULL, 0x0000005c00787306ULL, 0x000fe20000200c00ULL,
0x00000018ff657819ULL, 0x002fe2000001143aULL, 0x000001003a837824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fc40000011438ULL, 0x0000888038697816ULL, 0x000fc600000000ffULL,
0x00000064007b7306ULL, 0x0003e20000200c00ULL, 0x0000888039687816ULL, 0x000fce00000000ffULL,
0x0000005e00707306ULL, 0x0007e20000200c00ULL, 0x00000018ff647819ULL, 0x002fce0000011439ULL,
0x00000065005c7306ULL, 0x0003e20000200c00ULL, 0x00000100385e7824ULL, 0x04cfe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x0000010039657824ULL, 0x042fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe40000011465ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000005d007a7306ULL, 0x0002f00000200c00ULL,
0x0000003800667306ULL, 0x000be20000200c00ULL, 0x00000018ff5d7819ULL, 0x002fce000001143bULL,
0x0000003900657306ULL, 0x0003e20000200c00ULL, 0x0000541067387816ULL, 0x020fe4000000007cULL,
0x00000018ff677819ULL, 0x000fca0000011483ULL, 0x0000007200727306ULL, 0x000f620000200c00ULL,
0x000054107f397816ULL, 0x002fce0000000080ULL, 0x000000384c54723cULL, 0x000fe20000001854ULL,
0x0000007300737306ULL, 0x000e6a0000200c00ULL, 0x000000382c0c723cULL, 0x000fe6000000180cULL,
0x0000005e006a7306ULL, 0x0003e80000200c00ULL, 0x000054107d387816ULL, 0x008fc4000000006eULL,
0x000054107a397816ULL, 0x000fe2000000006fULL, 0x000001003b7a7824ULL, 0x040fe200078e00ffULL,
0x000088803b6e7816ULL, 0x040fe200000000ffULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x000088803a5e7816ULL, 0x042fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x000000384c3c723cULL, 0x000fe6000000183cULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000006400647306ULL, 0x000e640000200c00ULL,
0x000000382c10723cULL, 0x000fec0000001810ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000541072387816ULL, 0x020fe2000000007bULL, 0x000100003b727824ULL, 0x000fe200078e00ffULL,
0x0000541073397816ULL, 0x000fc80000000078ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000007a003b7306ULL, 0x000f640000200c00ULL, 0x000000384c40723cULL, 0x000fec0000001840ULL,
0x0000006d006d7306ULL, 0x000f620000200c00ULL, 0x000000382c14723cULL, 0x000fee0000001814ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000541066387816ULL, 0x008fc4000000005fULL,
0x0000541065397816ULL, 0x002fe40000000064ULL, 0x000054106e5f7816ULL, 0x020fe2000000003bULL,
0x00000001ff3b7424ULL, 0x000fe200078e00ffULL, 0x0000541070707816ULL, 0x000fe2000000006dULL,
0x0000007100717306ULL, 0x000e640000200c00ULL, 0x000000384c50723cULL, 0x000fec0000001850ULL,
0x0000006900697306ULL, 0x000ee20000200c00ULL, 0x000000382c20723cULL, 0x000fe20000001820ULL,
0x0000003b063879a7ULL, 0x000ae2000850003fULL, 0x0000541071717816ULL, 0x002fca000000006cULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000095a067c11ULL, 0x020fe2000f8e18ffULL,
0x000000702c18723cULL, 0x000fe20000001818ULL, 0x00005410696a7816ULL, 0x008fca000000006aULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x01a6a03b06ff79a7ULL, 0x0007e2000850003fULL,
0x000000704c44723cULL, 0x000fec0000001844ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00005410686b7816ULL, 0x002fce000000006bULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x0000006a2c1c723cULL, 0x000fee000000181cULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0000006a4c48723cULL, 0x000fe20000001848ULL, 0x000054105e5e7816ULL, 0x002fcc0000000067ULL,
0x0000003a006f7306ULL, 0x000e620000200c00ULL, 0x0000005e2c30723cULL, 0x000fee0000001830ULL,
0x0000007200727306ULL, 0x000f620000200c00ULL, 0x0000005e4c28723cULL, 0x000fe20000001828ULL,
0x000054106f5c7816ULL, 0x002fc4000000005cULL, 0x00005410725d7816ULL, 0x020fce000000005dULL,
0x0000005c4c24723cULL, 0x000fec0000001824ULL, 0x0000005c2c2c723cULL, 0x000fe20000001834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff5c00b49947ULL, 0x00cfde000383ffffULL,
0x000000ff6100720cULL, 0x000fda0003f05270ULL, 0x0000000400648947ULL, 0x000fea0003800000ULL,
0x0180000082007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000bfd000047802ULL, 0x000fce0000000f00ULL,
0x000000a800787944ULL, 0x01efea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000008200037308ULL, 0x008ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc80000000082ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000001805077811ULL, 0x042fe400078ff0ffULL, 0x00000002ff097819ULL, 0x000fe40000011605ULL,
0x0000000805357811ULL, 0x040fe400078ff0ffULL, 0x0000001005377811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f0900047589ULL, 0x000e6800000e0000ULL,
0x00001f3500067589ULL, 0x000ea800000e0000ULL, 0x00001f3700057589ULL, 0x000ee800000e0000ULL,
0x00001f0700077589ULL, 0x000f6200000e0000ULL, 0x0000005404547220ULL, 0x042fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000003c043c7220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x0000004004407220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000004404447220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x000fe20000410000ULL, 0x0000005606567220ULL, 0x044fe20000410000ULL,
0x0000005706577220ULL, 0x040fe20000410000ULL, 0x0000003e063e7220ULL, 0x040fe20000410000ULL,
0x0000003f063f7220ULL, 0x040fe20000410000ULL, 0x0000004206427220ULL, 0x040fe20000410000ULL,
0x0000004306437220ULL, 0x040fe20000410000ULL, 0x0000004606467220ULL, 0x040fe20000410000ULL,
0x0000004706477220ULL, 0x040fe20000410000ULL, 0x0000004a064a7220ULL, 0x040fe20000410000ULL,
0x0000004b064b7220ULL, 0x040fe20000410000ULL, 0x0000005206527220ULL, 0x040fe20000410000ULL,
0x0000005306537220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x000fe20000410000ULL, 0x0000000c050c7220ULL, 0x048fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000001105117220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002d052d7220ULL, 0x000fe20000410000ULL, 0x0000000e070e7220ULL, 0x060fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000003207327220ULL, 0x040fe20000410000ULL,
0x0000003307337220ULL, 0x040fe20000410000ULL, 0x0000002e072e7220ULL, 0x040fe20000410000ULL,
0x0000002f072f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000f620000000000ULL,
0x0000000163637812ULL, 0x000fe400078ec0ffULL, 0x000000484948723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000505150723eULL, 0x000fc400000000ffULL,
0x000000282928723eULL, 0x000fe400000000ffULL, 0x000000242524723eULL, 0x000fe400000000ffULL,
0x000000565757723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fe400000000ffULL,
0x000000424342723eULL, 0x000fe400000000ffULL, 0x000000464746723eULL, 0x000fc400000000ffULL,
0x0000004a4b4a723eULL, 0x000fe400000000ffULL, 0x000000525325723eULL, 0x000fe400000000ffULL,
0x0000541057567816ULL, 0x000fe4000000003eULL, 0x0000002a2b2a723eULL, 0x000fe400000000ffULL,
0x0000000800057811ULL, 0x062fe400078ff0ffULL, 0x0000000200027812ULL, 0x008fc400078ec0ffULL,
0x0000001800097811ULL, 0x000fe200078ff0ffULL, 0x0000000805367824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x000fe200078ff0ffULL,
0x00000008093a7824ULL, 0x000fe200078e00ffULL, 0x00000002ff077819ULL, 0x000fe40000011600ULL,
0xfffffff836367812ULL, 0x000fe200078ee203ULL, 0x0000000805387824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x040fe200078ff8ffULL, 0x0000000807347824ULL, 0x000fe200078e00ffULL,
0x0000000702047211ULL, 0x000fc400078ff8ffULL, 0x0000000902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee203ULL,
0x0000000204027836ULL, 0x000fe20000000000ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000000963037c11ULL, 0x000fe2000f8e68ffULL,
0x0000000404067836ULL, 0x000fe20000000000ULL, 0xfffffff809087812ULL, 0x000fe200078ee202ULL,
0x0000000604077836ULL, 0x000fe20000000000ULL, 0xfffffff805027812ULL, 0x000fe200078ee204ULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000100060057824ULL, 0x000fe200078e0203ULL, 0xfffffff834347812ULL, 0x000fc400078ee207ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x0000001002067824ULL, 0x100fe200078e0205ULL,
0x000000545502723eULL, 0x000fe200000000ffULL, 0x0000001036367824ULL, 0x000fe200078e0205ULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000000262726723eULL, 0x000fe200000000ffULL, 0x0000001038387824ULL, 0x100fe200078e0205ULL,
0x00005410023c7816ULL, 0x100fe20000000004ULL, 0x000000103a3a7824ULL, 0x100fe200078e0205ULL,
0x00007632023d7816ULL, 0x000fe20000000004ULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x000000404102723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0205ULL,
0x000000444504723eULL, 0x000fe200000000ffULL, 0x0000001034347824ULL, 0x000fe200078e0205ULL,
0x0000003c06007388ULL, 0x0003e20000000a00ULL, 0x0000000107367824ULL, 0x000fe200078e0236ULL,
0x0000763257577816ULL, 0x000fe2000000003eULL, 0x0000000107387824ULL, 0x040fe200078e0238ULL,
0x0000763242297816ULL, 0x000fe20000000046ULL, 0x00000001073a7824ULL, 0x000fe200078e023aULL,
0x0000000c0d0c723eULL, 0x000fe200000000ffULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x000000141514723eULL, 0x000fe200000000ffULL, 0x0000000107057824ULL, 0x000fe200078e020aULL,
0x00000018190a723eULL, 0x000fe200000000ffULL, 0x0000000107347824ULL, 0x000fe200078e0234ULL,
0x0000541002067816ULL, 0x002fc40000000004ULL, 0x0000763202077816ULL, 0x000fe20000000004ULL,
0x000000015b027824ULL, 0x000fe200078e0200ULL, 0x00007632140d7816ULL, 0x000fe4000000000aULL,
0x0000001c1d1c723eULL, 0x000fe200000000ffULL, 0x0000000608007388ULL, 0x0003e20000000a00ULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x000000303130723eULL, 0x000fe400000000ffULL, 0x0000002c2d18723eULL, 0x000fc400000000ffULL,
0x0000000e0f0e723eULL, 0x000fe400000000ffULL, 0x000000161716723eULL, 0x000fe400000000ffULL,
0x0000001a1b1a723eULL, 0x000fe400000000ffULL, 0x0000541048067816ULL, 0x142fe40000000050ULL,
0x0000763248077816ULL, 0x000fe40000000050ULL, 0x0000001e1f1e723eULL, 0x000fc400000000ffULL,
0x00000022230f723eULL, 0x000fe200000000ffULL, 0x0000000605007388ULL, 0x0003e20000000a00ULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x000000ff6000720cULL, 0x000fe40003f05270ULL, 0x0000763232097816ULL, 0x000fe40000000019ULL,
0x0000541028067816ULL, 0x002fc40000000024ULL, 0x0000763228077816ULL, 0x000fe40000000024ULL,
0x0000541042287816ULL, 0x000fe40000000046ULL, 0x000054104a247816ULL, 0x140fe20000000025ULL,
0x0000000634007388ULL, 0x0003e20000000a00ULL, 0x000076324a257816ULL, 0x000fc60000000025ULL,
0x0000005636007388ULL, 0x000fe80000000a00ULL, 0x0004002808007388ULL, 0x000fe20000000a00ULL,
0x000000101106723eULL, 0x002fc600000000ffULL, 0x0004002405007388ULL, 0x000fe20000000a00ULL,
0x000054102a107816ULL, 0x140fe40000000026ULL, 0x000076322a117816ULL, 0x000fe40000000026ULL,
0x000000121307723eULL, 0x000fc600000000ffULL, 0x0004001034007388ULL, 0x0003e40000000a00ULL,
0x000054100c107816ULL, 0x142fe40000000006ULL, 0x000076320c117816ULL, 0x000fe40000000006ULL,
0x00005410140c7816ULL, 0x000fe4000000000aULL, 0x000054100e067816ULL, 0x140fe20000000007ULL,
0x0000001038007388ULL, 0x000fe20000000a00ULL, 0x000076320e077816ULL, 0x000fc60000000007ULL,
0x0008000c08007388ULL, 0x0003e40000000a00ULL, 0x000054101c0c7816ULL, 0x142fe40000000020ULL,
0x000076321c0d7816ULL, 0x000fca0000000020ULL, 0x0008000c05007388ULL, 0x0003e40000000a00ULL,
0x00005410300c7816ULL, 0x142fe40000000018ULL, 0x00007632300d7816ULL, 0x000fca0000000018ULL,
0x0008000c34007388ULL, 0x000fe80000000a00ULL, 0x000000063a007388ULL, 0x0003e40000000a00ULL,
0x0000541016067816ULL, 0x142fe4000000001aULL, 0x0000763216077816ULL, 0x000fca000000001aULL,
0x000c000608007388ULL, 0x0003e40000000a00ULL, 0x000054101e067816ULL, 0x142fe4000000000fULL,
0x000076321e077816ULL, 0x000fe4000000000fULL, 0x0000541032087816ULL, 0x000fc60000000019ULL,
0x000c000605007388ULL, 0x000fe80000000a00ULL, 0x000c000834007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000020c7984ULL, 0x000e680000000c00ULL,
0x0004000002147984ULL, 0x000ee80000000c00ULL, 0x00080000021c7984ULL, 0x000f680000000c00ULL,
0x000c000002047984ULL, 0x000f680000000c00ULL, 0x0010000002107984ULL, 0x000f680000000c00ULL,
0x0014000002187984ULL, 0x000f680000000c00ULL, 0x0018000002207984ULL, 0x000f680000000c00ULL,
0x001c000002247984ULL, 0x000f620000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x008fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x024fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff07077230ULL, 0x000fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x000fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fc40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fe40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c02007388ULL, 0x0003e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x000fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0004001402007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000002707077230ULL, 0x000fe40000000000ULL,
0x0000002606067230ULL, 0x000fe20000000000ULL, 0x0008001c02007388ULL, 0x0003e20000000c00ULL,
0x0000002505057230ULL, 0x000fc40000000000ULL, 0x0000002404047230ULL, 0x000fca0000000000ULL,
0x000c000402007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff047819ULL, 0x002fe20000011600ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x000000750400720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104027824ULL, 0x000fe200078e0200ULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000a05057299ULL, 0x000fe2000800063fULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x00000007000a7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff805027812ULL, 0x000fc600078ef800ULL, 0x0000000863077824ULL, 0x000fe400078e020aULL,
0x0000001002067824ULL, 0x000fe400078e0203ULL, 0x0000002077027824ULL, 0x000fc600078e0204ULL,
0x00000000060c7984ULL, 0x0002a40000000c00ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff047c19ULL, 0x000fe20008011602ULL, 0x000000040b027c24ULL, 0x000fe4000f8e02ffULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000002000067836ULL, 0x002fe40000000000ULL,
0x0000000b04057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff087819ULL, 0x000fe20000011606ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750800720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe400078e0208ULL, 0x0000002077087824ULL, 0x000fc600078e0208ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000508057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x0002a20000000c00ULL,
0x0000000b08057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000863077824ULL, 0x002fc800078e0206ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4408ULL,
0x0000004000087836ULL, 0x000fe40000000000ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x00000003ff067819ULL, 0x000fc80000011608ULL, 0x000000750600720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0043d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000108047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef808ULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x0002a20000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000863077824ULL, 0x002fc800078e0208ULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x0000006000067836ULL, 0x000fe40000000000ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0043d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe400078e0208ULL, 0x0000002077087824ULL, 0x000fc600078e0208ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000508057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x0002a20000000c00ULL,
0x0000000b08057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000863077824ULL, 0x002fc800078e0206ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4408ULL,
0x0000008000087836ULL, 0x000fe40000000000ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x00000003ff067819ULL, 0x000fc80000011608ULL, 0x000000750600720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0043d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000108047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef808ULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x0002a20000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000863077824ULL, 0x002fc800078e0208ULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x000000a000067836ULL, 0x000fe40000000000ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0043d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe400078e0208ULL, 0x0000002077087824ULL, 0x000fc600078e0208ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000508057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x0002a20000000c00ULL,
0x0000000b08057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000863077824ULL, 0x002fc800078e0206ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4408ULL,
0x000000c000087836ULL, 0x000fe40000000000ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x00000003ff067819ULL, 0x000fc80000011608ULL, 0x000000750600720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0043d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000108047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fe400078e0206ULL,
0x000000e000007836ULL, 0x000fe20000000000ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef808ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b06057224ULL, 0x000fe200078e0205ULL,
0x00000003ff067819ULL, 0x000fc80000011600ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000100097824ULL, 0x000fe400078e0206ULL, 0x0000000863077824ULL, 0x002fe400078e0208ULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fe4000f8040ffULL,
0x0000000709097812ULL, 0x000fe400078ec0ffULL, 0x0000000905057c11ULL, 0x000fc400080f440aULL,
0x000000750600720cULL, 0x000fe40003f06070ULL, 0xfffffff809087812ULL, 0x000fe200078ef800ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ea000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001008087824ULL, 0x000fe200078e0203ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x00000000080c7984ULL, 0x002e620000000c00ULL, 0x0000000863637824ULL, 0x000fe200078e0200ULL,
0x0000000506037c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fc60008011606ULL,
0x0000000176037824ULL, 0x000fc800078e0203ULL, 0x0000000b06037224ULL, 0x000fca00078e0203ULL,
0x0000000302037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fc600080f4404ULL,
0x0000001063027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000626300720cULL, 0x000fe20003f06070ULL,
0x00009800ff0c7b82ULL, 0x000e620000000a00ULL, 0xffffffffff0b7424ULL, 0x000fd600078e00ffULL,
0x00009400ff078b82ULL, 0x000ea20000000800ULL, 0x0000000205068824ULL, 0x000fce00078e00ffULL,
0x00009000ff088b82ULL, 0x000ee20000000a00ULL, 0x000000060c5d7981ULL, 0x002322000c1e9900ULL,
0x0000000706078224ULL, 0x004fe400078e0263ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x0000000407088825ULL, 0x008fc800078e0008ULL, 0x01a60006ff0679a7ULL, 0x000e620008500009ULL,
0x00000006080b8981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x0000004003027824ULL, 0x000fe400078e00ffULL, 0x0000004063037824ULL, 0x000fe400078e00ffULL,
0x0000004058517824ULL, 0x000fe400078e00ffULL, 0x0000000b02267224ULL, 0x004fcc00078e02ffULL,
0x0000000c002c0947ULL, 0x002fea0003800000ULL, 0x00000003ff2f7819ULL, 0x000fe2000001160aULL,
0x00008e00ff107b82ULL, 0x000e620000000a00ULL, 0x0000000374087248ULL, 0x000fc60007fe0000ULL,
0x000000042f097836ULL, 0x000fe40000000000ULL, 0x00000001080d7824ULL, 0x000fe400078e0a03ULL,
0x0000000109087824ULL, 0x140fe400078e020aULL, 0x0000000809237824ULL, 0x040fe200078e00ffULL,
0x0000000d0900720cULL, 0x080fe20003f86070ULL, 0x000000082f097836ULL, 0x000fe40000000000ULL,
0x0000004058587824ULL, 0x000fe200078e022fULL, 0xfffffff823237812ULL, 0x000fe200078ee208ULL,
0x0000000c2f087836ULL, 0x000fe20000000000ULL, 0x0000000d0900720cULL, 0x040fe20003f06070ULL,
0x00000001090b7824ULL, 0x000fc400078e020aULL, 0x00000001080c7824ULL, 0x040fe200078e020aULL,
0x0000000d0800720cULL, 0x040fe20003f26070ULL, 0x0000000808277824ULL, 0x000fe400078e00ffULL,
0x0000000809127824ULL, 0x000fe400078e00ffULL, 0x0000008058087825ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe400078ee20cULL, 0x00000010260c7211ULL, 0x042fe200078438ffULL,
0x0000000858107836ULL, 0x000fe20000000000ULL, 0x0000007008177812ULL, 0x000fe200078ef804ULL,
0x00000004580e7836ULL, 0x000fe20000000000ULL, 0xfffffff812257812ULL, 0x000fe200078ee20bULL,
0x0000000c58087836ULL, 0x000fe20000000000ULL, 0x00000011260b7211ULL, 0x000fe200010f3cffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000170c167210ULL, 0x000fc60007f5e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000070101b7812ULL, 0x000fc600078ef804ULL,
0x0000000109177824ULL, 0x100fe200010e060bULL, 0x000000700e197812ULL, 0x000fe200078ef804ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000000c1b1a7210ULL, 0x000fe40007f5e0ffULL,
0x0000000c19187210ULL, 0x000fe20007f7e0ffULL, 0x00000010580e7836ULL, 0x000fe20000000000ULL,
0x00000070081d7812ULL, 0x000fe200078ef804ULL, 0x00000001111b7824ULL, 0x100fe200010e060bULL,
0x0000000963087c11ULL, 0x000fe2000f8e70ffULL, 0x000000010f197824ULL, 0x000fe200018e060bULL,
0x0000000c1d1c7210ULL, 0x000fe20007f5e0ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000001458127836ULL, 0x000fe20000000000ULL, 0x000000700e217812ULL, 0x000fe200078ef804ULL,
0x0000001858147836ULL, 0x000fe40000000000ULL, 0x00000001091d7824ULL, 0x000fe200010e060bULL,
0x0000000c210e7210ULL, 0x000fe20007f5e0ffULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000012f097824ULL, 0x000fe200078e020aULL, 0x00000070121f7812ULL, 0x000fe200078ef804ULL,
0x0000200008207836ULL, 0x000fe40000000000ULL, 0x0000001c58087836ULL, 0x000fe20000000000ULL,
0x0000000709217812ULL, 0x000fe200078ec0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000c1f127210ULL, 0x000fe40007f7e0ffULL, 0x0ffffff821217812ULL, 0x000fe200078ef80aULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007014117812ULL, 0x000fc600078ef804ULL,
0x000000142f1e7836ULL, 0x000fe20000000000ULL, 0x00000070081f7812ULL, 0x000fe200078ef804ULL,
0x0000000113137824ULL, 0x100fe200018e060bULL, 0x0000000c11147210ULL, 0x000fe20007fbe0ffULL,
0x000000011e087824ULL, 0x140fe200078e020aULL, 0x0000000d1e00720cULL, 0x0c0fe20003f66070ULL,
0x000000081e2b7824ULL, 0x000fe200078e00ffULL, 0x0000000c1f1e7210ULL, 0x000fe20007fde0ffULL,
0x000000102f107836ULL, 0x000fe40000000000ULL, 0x0000000115157824ULL, 0x100fe200028e060bULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee208ULL, 0x0000002058087836ULL, 0x000fe20000000000ULL,
0x0000000d2f00720cULL, 0x080fe20003fa6070ULL, 0x000000010f0f7824ULL, 0x000fe200010e060bULL,
0x0000000d1000720cULL, 0x040fe20003f46070ULL, 0x0000000110117824ULL, 0x000fc400078e020aULL,
0x00000001091f7824ULL, 0x000fe400030e060bULL, 0x0000000810107824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff810297812ULL, 0x000fe200078ee211ULL,
0x000000182f227836ULL, 0x000fe20000000000ULL, 0x00000070082d7812ULL, 0x000fe200078ef804ULL,
0x0000001021217824ULL, 0x100fe400078e0220ULL, 0x0000001023237824ULL, 0x000fe400078e0220ULL,
0x0000002458107836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016217faeULL, 0x0003e2000e901c46ULL, 0x0000000122087824ULL, 0x040fe200078e020aULL,
0x0000000d2200720cULL, 0x040fe20003fa6070ULL, 0x0000000822317824ULL, 0x000fe200078e00ffULL,
0x0000000018237faeULL, 0x0005e2000e101c46ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000001025257824ULL, 0x100fe400078e0220ULL, 0x0000001027277824ULL, 0x000fe200078e0220ULL,
0x0000000c2d167210ULL, 0x002fe20007fde0ffULL, 0x0000001c2f247836ULL, 0x000fe20000000000ULL,
0x00000070102d7812ULL, 0x000fe200078ef804ULL, 0x000000001a257faeULL, 0x000fe2000c101c46ULL,
0xfffffff831197812ULL, 0x004fe200078ee208ULL, 0x0000002858087836ULL, 0x000fe20000000000ULL,
0x0000000d2400720cULL, 0x000fe20003f86070ULL, 0x0000000109177824ULL, 0x000fe200030e060bULL,
0x000000001c277faeULL, 0x0003e2000c901c46ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000000c2d107210ULL, 0x000fc60007fde0ffULL, 0x0000001029297824ULL, 0x000fe200078e0220ULL,
0x00000070082d7812ULL, 0x000fe200078ef804ULL, 0x000000202f187836ULL, 0x000fe40000000000ULL,
0x000000242f237836ULL, 0x000fe20000000000ULL, 0x000000000e297faeULL, 0x0005e2000d101c46ULL,
0x0000000124217824ULL, 0x000fe200078e020aULL, 0x0000000d1800720cULL, 0x080fe20003f06070ULL,
0x0000002c581c7836ULL, 0x002fe20000000000ULL, 0x0000000d2300720cULL, 0x000fe20003f26070ULL,
0x000000102b2b7824ULL, 0x000fc400078e0220ULL, 0x0000000824247824ULL, 0x000fe400078e00ffULL,
0x0000000118227824ULL, 0x040fe200078e020aULL, 0x00000000122b7faeULL, 0x0003e2000d901c46ULL,
0x0000000818317824ULL, 0x000fe200078e00ffULL, 0xfffffff824217812ULL, 0x000fe200078ee221ULL,
0x000000801c0e7825ULL, 0x004fc600078e00ffULL, 0xfffffff8311b7812ULL, 0x000fe200078ee222ULL,
0x0000000123187824ULL, 0x000fe400078e020aULL, 0x0000000111117824ULL, 0x100fe200030e060bULL,
0x0000000c2d087210ULL, 0x000fe20007fde0ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x000000700e137812ULL, 0x002fe200078ef804ULL, 0x0000001019197824ULL, 0x100fe400078e0220ULL,
0x0000000109097824ULL, 0x000fe200030e060bULL, 0xfffffff8231d7812ULL, 0x000fe200078ee218ULL,
0x0000001021217824ULL, 0x100fe200078e0220ULL, 0x0000000c13127210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0220ULL, 0x0000000014197faeULL, 0x0003e2000e901c46ULL,
0x00000030580e7836ULL, 0x000fc40000000000ULL, 0x000000101d1d7824ULL, 0x000fe200078e0220ULL,
0x000000001e217faeULL, 0x000fe2000e101c46ULL, 0x000000010f137824ULL, 0x000fe400030e060bULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000000161b7faeULL, 0x0005e6000c101c46ULL,
0x000000302f227836ULL, 0x000fe20000000000ULL, 0x00000000101d7faeULL, 0x0007e2000c901c46ULL,
0x0000002c2f1a7836ULL, 0x000fc40000000000ULL, 0x000000342f197836ULL, 0x002fe20000000000ULL,
0x0000000d2200720cULL, 0x080fe20003f66070ULL, 0x000000011a157824ULL, 0x140fe200078e020aULL,
0x0000000d1a00720cULL, 0x0c0fe20003f86070ULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0x000000700e177812ULL, 0x004fe200078ef804ULL, 0x00000001220e7824ULL, 0x040fe200078e020aULL,
0x0000000d1900720cULL, 0x080fe20003f46070ULL, 0x000000282f187836ULL, 0x000fe20000000000ULL,
0x0000000c17147210ULL, 0x000fe20007fde0ffULL, 0x0000003458107836ULL, 0x008fe20000000000ULL,
0xfffffff81a1b7812ULL, 0x000fe200078ee215ULL, 0x00000008221d7824ULL, 0x000fe200078e00ffULL,
0x0000000d1800720cULL, 0x000fe20003fa6070ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20eULL, 0x00000038580e7836ULL, 0x000fe20000000000ULL,
0x0000007010177812ULL, 0x000fe200078ef804ULL, 0x000000382f1c7836ULL, 0x000fe40000000000ULL,
0x0000003c2f1e7836ULL, 0x000fe40000000000ULL, 0x000000010f157824ULL, 0x000fe200030e060bULL,
0x0000000c17167210ULL, 0x000fe20007fde0ffULL, 0x0000000119107824ULL, 0x040fe200078e020aULL,
0x0000000d1c00720cULL, 0x080fe20003f26070ULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x0000000d1e00720cULL, 0x000fe20003f06070ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL, 0x0000003c58587836ULL, 0x000fe20000000000ULL,
0x000000700e197812ULL, 0x000fe200078ef804ULL, 0x00000001180d7824ULL, 0x040fe400078e020aULL,
0x0000000818187824ULL, 0x000fe400078e00ffULL, 0x0000000111177824ULL, 0x000fe200030e060bULL,
0x0000000c190e7210ULL, 0x000fe20007fde0ffULL, 0x0000008058107825ULL, 0x000fe200078e00ffULL,
0xfffffff8180d7812ULL, 0x000fc600078ee20dULL, 0x000000011c187824ULL, 0x140fe200078e020aULL,
0x0000007010197812ULL, 0x000fe200078ef804ULL, 0x000000081c217824ULL, 0x000fe400078e00ffULL,
0x000000011e0a7824ULL, 0x040fe400078e020aULL, 0x000000081e237824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee218ULL, 0x000000010f0f7824ULL, 0x000fe200030e060bULL,
0x0000000c190c7210ULL, 0x000fe20007fde0ffULL, 0x000000100d197824ULL, 0x100fe200078e0220ULL,
0xfffffff823237812ULL, 0x000fe200078ee20aULL, 0x000000101b1b7824ULL, 0x000fc400078e0220ULL,
0x000000101d1d7824ULL, 0x100fe200078e0220ULL, 0x0000000008197faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x100fe400078e0220ULL, 0x0000001021217824ULL, 0x100fe200078e0220ULL,
0x00000000121b7faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fe400078e0220ULL,
0x00000001110d7824ULL, 0x000fe200030e060bULL, 0x00000000141d7faeULL, 0x0003e8000d901c46ULL,
0x00000000161f7faeULL, 0x0003e8000d101c46ULL, 0x000000000e217faeULL, 0x0003e8000c901c46ULL,
0x000000000c237faeULL, 0x0003e2000c101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x000000040a0b7811ULL, 0x040fe200078fe8ffULL, 0x00008e00ff487b82ULL, 0x000e620000000a00ULL,
0x000000080a0d7811ULL, 0x040fe400078fe8ffULL, 0x000000140a137811ULL, 0x040fe200078fe8ffULL,
0x000000010b087824ULL, 0x140fe200078e020aULL, 0x000000100a117811ULL, 0x040fe200078fe8ffULL,
0x000000080b097824ULL, 0x000fe200078e00ffULL, 0x0000000c0a0f7811ULL, 0x040fe200078fe8ffULL,
0x000000080d157824ULL, 0x000fe200078e00ffULL, 0x000000340a2a7811ULL, 0x040fe200078fe8ffULL,
0x0000000113147824ULL, 0x100fe200078e020aULL, 0xfffffff8090c7812ULL, 0x000fe200078ee208ULL,
0x000000010d087824ULL, 0x100fe200078e020aULL, 0x000000380a2c7811ULL, 0x040fe200078fe8ffULL,
0x0000000813197824ULL, 0x000fe200078e00ffULL, 0x000000240a1b7811ULL, 0x040fe200078fe8ffULL,
0x0000000111127824ULL, 0x140fe200078e020aULL, 0xfffffff8150e7812ULL, 0x000fe200078ee208ULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0x000000180a157811ULL, 0x040fe200078fe8ffULL,
0x000000010f097824ULL, 0x140fe200078e020aULL, 0xfffffff819147812ULL, 0x000fe200078ee214ULL,
0x000000080f107824ULL, 0x000fe200078e00ffULL, 0x000000200a197811ULL, 0x040fe200078fe8ffULL,
0x0000000115087824ULL, 0x140fe200078e020aULL, 0xfffffff817127812ULL, 0x000fe200078ee212ULL,
0x00000008151d7824ULL, 0x000fe200078e00ffULL, 0x0000001c0a177811ULL, 0x040fe200078fe8ffULL,
0x00000001191a7824ULL, 0x140fe200078e020aULL, 0xfffffff810107812ULL, 0x000fe200078ee209ULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d167812ULL, 0x000fe200078ee208ULL,
0x0000000117097824ULL, 0x140fe200078e020aULL, 0x000000280a1d7811ULL, 0x000fe200078fe8ffULL,
0x0000000817187824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL,
0x000000012a227824ULL, 0x100fe200078e020aULL, 0x0000002c0a1f7811ULL, 0x040fe200078fe8ffULL,
0x000000011d087824ULL, 0x140fe200078e020aULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000300a287811ULL, 0x000fe200078fe8ffULL,
0x000000011f097824ULL, 0x140fe200078e020aULL, 0x00000048264b7211ULL, 0x002fe200078038ffULL,
0x000000081f207824ULL, 0x000fe200078e00ffULL, 0xfffffff8231e7812ULL, 0x000fe200078ee208ULL,
0x000000082a257824ULL, 0x000fe200078e00ffULL, 0x0000000a0a087211ULL, 0x000fe200078fe8ffULL,
0x000000011b1c7824ULL, 0x140fe200078e020aULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x000000081b217824ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe200078ee222ULL,
0x000000082c257824ULL, 0x000fe200078e00ffULL, 0x0000000963237c11ULL, 0x000fe2000f8e70ffULL,
0x00000001510d7824ULL, 0x000fe200078e020dULL, 0x0000000708097812ULL, 0x000fe200078ec0ffULL,
0x000000012c087824ULL, 0x100fe200078e020aULL, 0xfffffff8211c7812ULL, 0x000fe200078ee21cULL,
0x0000200023477836ULL, 0x000fe20000000000ULL, 0x0ffffff809097812ULL, 0x000fe200078ef80aULL,
0x0000000128217824ULL, 0x000fe200078e020aULL, 0xfffffff825237812ULL, 0x000fe200078ee208ULL,
0x000000100c2b7824ULL, 0x100fe200078e0247ULL, 0x000000510a087211ULL, 0x040fe200078fe8ffULL,
0x0000001009297824ULL, 0x000fe200078e0247ULL, 0x0000003c0a2e7811ULL, 0x000fe200078fe8ffULL,
0x0000000828247824ULL, 0x000fe200078e00ffULL, 0x0000004926497211ULL, 0x000fe200000f3cffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff824217812ULL, 0x000fe200078ee221ULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef804ULL,
0x0000000151117824ULL, 0x040fe200078e0211ULL, 0x000000084b087210ULL, 0x000fe20007f1e0ffULL,
0x00000001510b7824ULL, 0x040fe200078e020bULL, 0x000000700c0c7812ULL, 0x000fe200078ef804ULL,
0x00000001510f7824ULL, 0x000fe400078e020fULL, 0x00000010102f7824ULL, 0x000fe400078e0247ULL,
0x000000012e247824ULL, 0x000fe400078e020aULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x000000100e2d7824ULL, 0x000fe200078e0247ULL, 0x0000007010107812ULL, 0x000fe200078ef804ULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x000000082e277824ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fe200078ef804ULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff827247812ULL, 0x000fe200078ee224ULL, 0x0000000109097824ULL, 0x000fe200000e0649ULL,
0x0000000c4b0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000151137824ULL, 0x040fe200078e0213ULL,
0x000000700e0e7812ULL, 0x000fe200078ef804ULL, 0x0000000151157824ULL, 0x040fe200078e0215ULL,
0x0000000a4b0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000151177824ULL, 0x040fe200078e0217ULL,
0x0000000e4b0e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001012317824ULL, 0x000fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008297faeULL, 0x0003e2000b901c46ULL,
0x0000000151197824ULL, 0x000fc400078e0219ULL, 0x0000001014337824ULL, 0x000fe400078e0247ULL,
0x0000008013127825ULL, 0x000fc800078e00ffULL, 0x0000001016357824ULL, 0x000fe400078e0247ULL,
0x0000008015147825ULL, 0x000fc800078e00ffULL, 0x0000001018377824ULL, 0x000fe400078e0247ULL,
0x000000010d0d7824ULL, 0x000fe200000e0649ULL, 0x000000104b107210ULL, 0x000fe20007f1e0ffULL,
0x0000008017167825ULL, 0x000fc800078e00ffULL, 0x0000008019187825ULL, 0x000fc800078e00ffULL,
0x00000010203f7824ULL, 0x100fe200078e0247ULL, 0x0000007012207812ULL, 0x000fe200078ef804ULL,
0x000000101a397824ULL, 0x100fe200078e0247ULL, 0x0000007018267812ULL, 0x000fe200078ef804ULL,
0x000000101c3b7824ULL, 0x100fe400078e0247ULL, 0x000000101e3d7824ULL, 0x100fe200078e0247ULL,
0x000000264b267210ULL, 0x000fe20007f7e0ffULL, 0x0000001021417824ULL, 0x100fe400078e0247ULL,
0x0000001022437824ULL, 0x100fe200078e0247ULL, 0x0000007014227812ULL, 0x000fe200078ef804ULL,
0x0000001023457824ULL, 0x000fc400078e0247ULL, 0x0000001024477824ULL, 0x000fe200078e0247ULL,
0x0000007016247812ULL, 0x000fe200078ef804ULL, 0x0000000111117824ULL, 0x100fe200000e0649ULL,
0x000000204b207210ULL, 0x000fe20007f1e0ffULL, 0x000000010b0b7824ULL, 0x100fe200008e0649ULL,
0x000000224b227210ULL, 0x000fe20007f3e0ffULL, 0x000000010f0f7824ULL, 0x000fe200010e0649ULL,
0x000000244b247210ULL, 0x000fe20007f5e0ffULL, 0x0000000151127824ULL, 0x040fe200078e021bULL,
0x000000000a2b7faeULL, 0x0003e2000b901c46ULL, 0x0000000151147824ULL, 0x000fc400078e021dULL,
0x0000000151167824ULL, 0x000fe200078e021fULL, 0x000000000c2d7faeULL, 0x0003e2000b901c46ULL,
0x0000000113217824ULL, 0x100fe400000e0649ULL, 0x0000000151187824ULL, 0x000fe200078e0228ULL,
0x000000000e2f7faeULL, 0x0003e2000b901c46ULL, 0x0000000115237824ULL, 0x000fe400008e0649ULL,
0x00000001511a7824ULL, 0x000fe200078e022aULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000000020337faeULL, 0x0003e2000b901c46ULL,
0x0000000117257824ULL, 0x100fe200010e0649ULL, 0x0000007012127812ULL, 0x000fe200078ef804ULL,
0x00000001511c7824ULL, 0x000fe200078e022cULL, 0x0000000022357faeULL, 0x0003e2000b901c46ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000124b127210ULL, 0x000fe40007f1e0ffULL,
0x0000000024377faeULL, 0x0003e2000b901c46ULL, 0x0000000119277824ULL, 0x000fe200018e0649ULL,
0x0000007014147812ULL, 0x000fe200078ef804ULL, 0x00000001511e7824ULL, 0x000fc400078e022eULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000144b147210ULL, 0x000fe20007f3e0ffULL,
0x0000000026397faeULL, 0x0003e4000b901c46ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fc600078ef804ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007018187812ULL, 0x000fe400078ef804ULL, 0x000000164b167210ULL, 0x000fe20007f5e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000701a1a7812ULL, 0x000fe400078ef804ULL,
0x000000184b187210ULL, 0x000fe20007f7e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000701c1c7812ULL, 0x000fe400078ef804ULL, 0x0000001a4b1a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000113137824ULL, 0x100fe200000e0649ULL, 0x000000701e047812ULL, 0x000fe200078ef804ULL,
0x0000000115157824ULL, 0x100fe200008e0649ULL, 0x0000001c4b1c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000117177824ULL, 0x100fe200010e0649ULL, 0x000000044b1e7210ULL, 0x000fe20007fde0ffULL,
0x0000000119197824ULL, 0x100fe200018e0649ULL, 0x00000000123b7faeULL, 0x0003e2000b901c46ULL,
0x000000011b1b7824ULL, 0x000fc400020e0649ULL, 0x000000011d1d7824ULL, 0x100fe200028e0649ULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x000000011f1f7824ULL, 0x000fc600030e0649ULL,
0x00000000163f7faeULL, 0x0003e8000b901c46ULL, 0x0000000018417faeULL, 0x0003e8000b901c46ULL,
0x000000001a437faeULL, 0x0003e8000b901c46ULL, 0x000000001c457faeULL, 0x0003e8000b901c46ULL,
0x000000001e477faeULL, 0x0003e4000b901c46ULL, 0x00000004637b7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff797424ULL, 0x000fc600078e00ffULL,
0x000000627b00720cULL, 0x000fda0003f06070ULL, 0x00009400ff0b8b82ULL, 0x002e620000000800ULL,
0x0000000205048824ULL, 0x000fce00078e00ffULL, 0x00009000ff088b82ULL, 0x000ea20000000a00ULL,
0x0000000b040b8224ULL, 0x002fc800078e027bULL, 0x000000040b088825ULL, 0x004fca00078e0008ULL,
0x0000000608798981ULL, 0x000324000c1e1900ULL, 0x0000000000087805ULL, 0x002fce0000015200ULL,
0x01a60007ff0075a7ULL, 0x000e640008000149ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140bULL, 0x0000000d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000204047819ULL, 0x000fc8000000120bULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01a60007ff0075a7ULL, 0x000e640008000149ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000002063047824ULL, 0x002fc800078e0204ULL, 0x0000000104087836ULL, 0x000fe20000000000ULL,
0x00000004ff067819ULL, 0x000fc80000011604ULL, 0x0ffffffe06077812ULL, 0x000fe400078ec0ffULL,
0x0000001f04067812ULL, 0x000fc600078ec0ffULL, 0x00000001070a7824ULL, 0x000fe400078e0208ULL,
0x0000000104097824ULL, 0x000fe400078e0207ULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000010060c7824ULL, 0x040fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x0000000807077836ULL, 0x000fe20000000000ULL,
0x000001f00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x000001f00c097812ULL, 0x000fe200078ee209ULL, 0x0000000104047824ULL, 0x100fe200078e0207ULL,
0x000000090a0a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000108077824ULL, 0x000fe200078e0207ULL,
0x0000000909097c11ULL, 0x000fc4000f8e20ffULL, 0x0000000f04047812ULL, 0x000fe200078ec0ffULL,
0x000000000a0c7984ULL, 0x000e620000000c00ULL, 0x0000000f07077812ULL, 0x000fe400078ec0ffULL,
0x000001f00b047812ULL, 0x000fe200078ee204ULL, 0x0000000009107984ULL, 0x000ea20000000c00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x0000000904047c11ULL, 0x000fe4000f8e20ffULL,
0x0000000907077c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff167224ULL, 0x002fc400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001409007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fc400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x000000180a007388ULL, 0x0003e80000000c00ULL, 0x00000000070c7984ULL, 0x000ea80000000c00ULL,
0x0000000004107984ULL, 0x000ee20000000c00ULL, 0x00000001ff0a7424ULL, 0x002fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x004fc400078e000eULL, 0x000000ffff1e7224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x008fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c04007388ULL, 0x0003e80000000c00ULL,
0x0000000c07007388ULL, 0x0003e20000000c00ULL, 0x01a6000aff0a79a7ULL, 0x000ea40008500009ULL,
0x0000000000067805ULL, 0x002fce0000015200ULL, 0x01a6000bff0075a7ULL, 0x004e640008000149ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fce0000015200ULL, 0x00000008060d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000d04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x01a6000bff0075a7ULL, 0x000e640008000149ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff6100720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009400ff047b82ULL, 0x000e620000000800ULL, 0x0000000000507919ULL, 0x000ea20000000000ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x3db504f35d5d7820ULL, 0x010fe20000410000ULL,
0x0000001f0a047890ULL, 0x000fe4000fffe03fULL, 0x8000000a745e7c36ULL, 0x000fe20008000000ULL,
0x0000000963527c11ULL, 0x040fe2000f8e18ffULL, 0x0000010003777836ULL, 0x000fe20000000000ULL,
0x000000043f047899ULL, 0x000fe20008011604ULL, 0x0000000963737c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff767224ULL, 0x000fe200078e00ffULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0xffffffff0a057890ULL, 0x000fc4000fffe03fULL,
0x000000090a087890ULL, 0x000fe4000fffe03fULL, 0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL,
0x0000000405757224ULL, 0x002fd600078e02ffULL, 0x0000000276047836ULL, 0x000fe20000000000ULL,
0x0000000108537812ULL, 0x000fe200078e0cffULL, 0x0000007902797224ULL, 0x010fc600078e02ffULL,
0x000000610400720cULL, 0x000fda0003f06070ULL, 0x0000000c003c8947ULL, 0x000fea0003800000ULL,
0x0000010076057824ULL, 0x000fe200078e0277ULL, 0x00000003ff0a7819ULL, 0x004fe20000011650ULL,
0x00008e00ff127b82ULL, 0x000e660000000a00ULL, 0x0000000574047248ULL, 0x000fe20007fe0000ULL,
0x0000000c0a187836ULL, 0x000fe40000000000ULL, 0x000000080a107836ULL, 0x000fe40000000000ULL,
0x000000040a0e7836ULL, 0x000fc40000000000ULL, 0x0000000104057824ULL, 0x000fe400078e0a05ULL,
0x0000000118077824ULL, 0x140fe400078e0250ULL, 0x0000000818207824ULL, 0x000fe200078e00ffULL,
0x000000050e00720cULL, 0x080fe20003f26070ULL, 0x0000000110067824ULL, 0x140fe200078e0250ULL,
0x000000051000720cULL, 0x040fe20003f06070ULL, 0x00000008100b7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x000000010e047824ULL, 0x000fc400078e0250ULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0xfffffff80b1e7812ULL, 0x000fe200078ee206ULL,
0x000000140a247836ULL, 0x000fe40000000000ULL, 0x000000180a287836ULL, 0x000fe20000000000ULL,
0xfffffff8091c7812ULL, 0x000fe200078ee204ULL, 0x0000001050077824ULL, 0x000fe400078e00ffULL,
0x00000001510e7824ULL, 0x000fe400078e020eULL, 0x0000000124067824ULL, 0x040fe200078e0250ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x00000008240d7824ULL, 0x000fc400078e00ffULL,
0x0000000128097824ULL, 0x040fe400078e0250ULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d267812ULL, 0x000fe200078ee206ULL, 0x00000001510c7824ULL, 0x000fe400078e020aULL,
0x000000100a1a7836ULL, 0x000fe20000000000ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001279097211ULL, 0x002fe400078438ffULL,
0x000000051a00720cULL, 0x000fe20003fa6070ULL, 0x0000000151107824ULL, 0x000fe200078e0210ULL,
0x000000070e147212ULL, 0x000fe200078efcffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000001379067211ULL, 0x000fc400010f3cffULL, 0x0000000914147210ULL, 0x000fe20007f7e0ffULL,
0x000000011a047824ULL, 0x000fe200078e0250ULL, 0x000000070c127212ULL, 0x080fe200078efcffULL,
0x000000081a0b7824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001209127210ULL, 0x000fe40007f5e0ffULL, 0xfffffff80b227812ULL, 0x000fe200078ee204ULL,
0x0000001c0a2c7836ULL, 0x000fe20000000000ULL, 0x0000000710167212ULL, 0x000fe200078efcffULL,
0x000000010f157824ULL, 0x000fe200018e0606ULL, 0x000000050a00720cULL, 0x000fe20003f66070ULL,
0x000000012c047824ULL, 0x040fe200078e0250ULL, 0x0000000916167210ULL, 0x000fe20007f9e0ffULL,
0x000000082c0b7824ULL, 0x000fc400078e00ffULL, 0x00000001510c7824ULL, 0x000fe400078e0218ULL,
0x000000010a0f7824ULL, 0x000fe200078e0250ULL, 0xfffffff80b2e7812ULL, 0x000fe200078ee204ULL,
0x000000010d137824ULL, 0x000fe200010e0606ULL, 0x0000000963047c11ULL, 0x000fe2000f8e70ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000051800720cULL, 0x000fc60003f46070ULL,
0x0000000111177824ULL, 0x000fe200020e0606ULL, 0x000000070f117812ULL, 0x000fe200078ec0ffULL,
0x00000001510e7824ULL, 0x000fe200078e021aULL, 0x000000070c187212ULL, 0x000fe200078efcffULL,
0x00002000530b7824ULL, 0x000fe200078e0204ULL, 0x0ffffff8110c7812ULL, 0x000fe200078ef850ULL,
0x000000200a307836ULL, 0x000fe20000000000ULL, 0x0000000918187210ULL, 0x000fe20007f9e0ffULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x000020000b0b7836ULL, 0x000fe20000000000ULL,
0x000000070e1a7212ULL, 0x000fe200078efcffULL, 0x0000000130107824ULL, 0x040fe400078e0250ULL,
0x0000000830197824ULL, 0x000fe200078e00ffULL, 0x000000091a1a7210ULL, 0x000fe20007fde0ffULL,
0x000000100c117824ULL, 0x000fe400078e020bULL, 0x00000001510c7824ULL, 0x000fe200078e0224ULL,
0xfffffff819327812ULL, 0x000fe200078ee210ULL, 0x000000010d197824ULL, 0x000fe200020e0606ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012117faeULL, 0x0003e2000d901c46ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000052400720cULL, 0x000fc40003f86070ULL,
0x000000052800720cULL, 0x000fe20003f66070ULL, 0x00000001510e7824ULL, 0x000fe200078e0228ULL,
0x000000070c0c7212ULL, 0x000fe200078efcffULL, 0x000000010f1b7824ULL, 0x000fe400030e0606ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000090c127210ULL, 0x002fc60007fde0ffULL,
0x000000101c1d7824ULL, 0x000fe200078e020bULL, 0x000000070e0c7212ULL, 0x000fe200078efcffULL,
0x0000000151107824ULL, 0x000fe400078e022cULL, 0x000000010d137824ULL, 0x000fe200030e0606ULL,
0x00000000141d7faeULL, 0x0003e2000c901c46ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000052c00720cULL, 0x000fc60003f26070ULL, 0x000000240a1c7836ULL, 0x000fe20000000000ULL,
0x0000000710107212ULL, 0x000fe200078efcffULL, 0x0000002c0a247836ULL, 0x000fe40000000000ULL,
0x000000011c1f7824ULL, 0x040fe400078e0250ULL, 0x000000081c0e7824ULL, 0x000fe200078e00ffULL,
0x000000090c147210ULL, 0x002fe20007fde0ffULL, 0x00000001510c7824ULL, 0x000fe400078e0230ULL,
0x000000101e1d7824ULL, 0x000fe200078e020bULL, 0xfffffff80e1e7812ULL, 0x000fe200078ee21fULL,
0x000000010f157824ULL, 0x000fe200030e0606ULL, 0x0000000910107210ULL, 0x000fe20007fde0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000161d7faeULL, 0x0003e2000c101c46ULL,
0x000000053000720cULL, 0x000fc40003f06070ULL, 0x00000010200f7824ULL, 0x000fe400078e020bULL,
0x000000280a207836ULL, 0x000fe40000000000ULL, 0x00000001510e7824ULL, 0x000fe200078e021cULL,
0x00000000180f7faeULL, 0x0005e2000d101c46ULL, 0x000000051c00720cULL, 0x000fe20003f46070ULL,
0x0000000111117824ULL, 0x000fe200030e0606ULL, 0x000000070c167212ULL, 0x002fe200078efcffULL,
0x0000000120177824ULL, 0x140fe400078e0250ULL, 0x00000008201c7824ULL, 0x000fe200078e00ffULL,
0x0000000916167210ULL, 0x000fe20007fde0ffULL, 0x00000001240c7824ULL, 0x000fc400078e0250ULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL,
0x00000010221d7824ULL, 0x000fe400078e020bULL, 0x000000010d177824ULL, 0x000fe200030e0606ULL,
0xfffffff81f227812ULL, 0x000fe200078ee20cULL, 0x000000800e0c7825ULL, 0x000fe200078e00ffULL,
0x000000001a1d7faeULL, 0x0003e2000e901c46ULL, 0x000000052000720cULL, 0x000fe40003fa6070ULL,
0x00000001510e7824ULL, 0x040fe200078e0220ULL, 0x000000070c187212ULL, 0x004fe200078efcffULL,
0x00000001510c7824ULL, 0x000fc400078e0224ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000918187210ULL, 0x000fc60007fde0ffULL, 0x00000010261f7824ULL, 0x100fe200078e020bULL,
0x000000070e0e7212ULL, 0x000fe200078efcffULL, 0x000000010d197824ULL, 0x000fe400030e0606ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000121f7faeULL, 0x0005e2000e101c46ULL,
0x000000052400720cULL, 0x000fe40003f86070ULL, 0x000000300a207836ULL, 0x000fe20000000000ULL,
0x000000070c1a7212ULL, 0x002fe200078efcffULL, 0x000000102a1d7824ULL, 0x000fc400078e020bULL,
0x00000001201b7824ULL, 0x040fe400078e0250ULL, 0x0000000820247824ULL, 0x000fe200078e00ffULL,
0x00000000141d7faeULL, 0x0003e2000d901c46ULL, 0x000000340a0c7836ULL, 0x000fe20000000000ULL,
0x000000090e127210ULL, 0x004fe20007fde0ffULL, 0x000000102e1f7824ULL, 0x000fe200078e020bULL,
0x000000052000720cULL, 0x080fe20003f66070ULL, 0x00000001510e7824ULL, 0x000fe200078e0220ULL,
0xfffffff824207812ULL, 0x000fe200078ee21bULL, 0x000000010f137824ULL, 0x000fe200030e0606ULL,
0x000000091a1a7210ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000101f7faeULL, 0x0005e2000c901c46ULL, 0x000000050c00720cULL, 0x000fc40003f26070ULL,
0x000000010d1b7824ULL, 0x000fe200030e0606ULL, 0x000000070e147212ULL, 0x002fe200078efcffULL,
0x000000010c0d7824ULL, 0x040fe400078e0250ULL, 0x000000080c247824ULL, 0x000fe200078e00ffULL,
0x0000000914147210ULL, 0x000fe20007fde0ffULL, 0x00000001510c7824ULL, 0x000fe400078e020cULL,
0x000000380a267836ULL, 0x000fe20000000000ULL, 0xfffffff824247812ULL, 0x000fe200078ee20dULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x00000001510e7824ULL, 0x000fe200078e0226ULL,
0x000000070c107212ULL, 0x004fe200078efcffULL, 0x0000003c0a0a7836ULL, 0x000fe40000000000ULL,
0x000000010f157824ULL, 0x000fe200030e0606ULL, 0x0000000910107210ULL, 0x000fe20007fde0ffULL,
0x00000010321d7824ULL, 0x000fe400078e020bULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000c101c46ULL, 0x000000101e1f7824ULL, 0x000fe200078e020bULL,
0x000000070e0e7212ULL, 0x000fe200078efcffULL, 0x00000001510c7824ULL, 0x000fe200078e020aULL,
0x000000050a00720cULL, 0x080fe20003f06070ULL, 0x000000010d117824ULL, 0x000fe200030e0606ULL,
0x00000000181f7faeULL, 0x0005e2000d101c46ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000052600720cULL, 0x040fe40003f46070ULL, 0x000000090e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000000126057824ULL, 0x000fc400078e0250ULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x000000010a167824ULL, 0x042fe400078e0250ULL, 0x000000080a177824ULL, 0x000fe200078e00ffULL,
0x000000070c0a7212ULL, 0x000fe200078efcffULL, 0x000000010f0f7824ULL, 0x000fe200030e0606ULL,
0xfffffff8260c7812ULL, 0x000fe200078ee205ULL, 0x000000101c057824ULL, 0x100fe200078e020bULL,
0xfffffff817167812ULL, 0x000fe200078ee216ULL, 0x0000001022077824ULL, 0x100fe200078e020bULL,
0x000000090a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001020097824ULL, 0x100fe200078e020bULL,
0x0000000012057faeULL, 0x0003e2000e901c46ULL, 0x0000001024177824ULL, 0x000fc400078e020bULL,
0x000000100c197824ULL, 0x104fe200078e020bULL, 0x000000001a077faeULL, 0x0003e2000e101c46ULL,
0x00000010161d7824ULL, 0x000fe400078e020bULL, 0x000000010d0b7824ULL, 0x000fe200030e0606ULL,
0x0000000014097faeULL, 0x0003e8000d901c46ULL, 0x0000000010177faeULL, 0x0003e8000c901c46ULL,
0x000000000e197faeULL, 0x0003e8000d101c46ULL, 0x000000000a1d7faeULL, 0x0003e2000c101c46ULL,
0x0000000800e87947ULL, 0x000fea0003800000ULL, 0x0000000c500f7811ULL, 0x044fe400078fe8ffULL,
0x00000004500d7811ULL, 0x040fe400078fe8ffULL, 0x0000001850137811ULL, 0x040fe200078fe8ffULL,
0x000000010f057824ULL, 0x140fe200078e0250ULL, 0x0000001050107811ULL, 0x040fe200078fe8ffULL,
0x000000080f0a7824ULL, 0x000fe200078e00ffULL, 0x00000008500e7811ULL, 0x040fe200078fe8ffULL,
0x000000010d047824ULL, 0x140fe200078e0250ULL, 0x0000002450187811ULL, 0x040fe200078fe8ffULL,
0x000000080d097824ULL, 0x000fe200078e00ffULL, 0xfffffff80a1d7812ULL, 0x000fe200078ee205ULL,
0x0000000113057824ULL, 0x140fe200078e0250ULL, 0x0000001c50157811ULL, 0x000fe200078fe8ffULL,
0x00000008130a7824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee204ULL,
0x0000000110067824ULL, 0x100fe200078e0250ULL, 0x0000001450127811ULL, 0x000fe200078fe8ffULL,
0x00000008101f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a317812ULL, 0x000fe200078ee205ULL,
0x000000010e047824ULL, 0x100fe200078e0250ULL, 0x0000003050217811ULL, 0x000fe200078fe8ffULL,
0x000000080e197824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x0000000118057824ULL, 0x100fe200078e0250ULL, 0x00000028501c7811ULL, 0x000fe200078fe8ffULL,
0x00000008180a7824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee204ULL,
0x0000000115067824ULL, 0x140fe200078e0250ULL, 0x0000002050177811ULL, 0x000fe200078fe8ffULL,
0x0000000815337824ULL, 0x000fe200078e00ffULL, 0xfffffff80a377812ULL, 0x000fe200078ee205ULL,
0x0000000112047824ULL, 0x100fe200078e0250ULL, 0x0000003450237811ULL, 0x000fe200078fe8ffULL,
0x00000008122f7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee206ULL,
0x0000000121057824ULL, 0x140fe200078e0250ULL, 0x0000002c501e7811ULL, 0x000fe200078fe8ffULL,
0x00000008210a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL,
0x000000011c067824ULL, 0x100fe200078e0250ULL, 0x0000003850257811ULL, 0x000fe200078fe8ffULL,
0x000000081c397824ULL, 0x000fe200078e00ffULL, 0xfffffff80a3d7812ULL, 0x000fe200078ee205ULL,
0x0000000117047824ULL, 0x140fe200078e0250ULL, 0x00008e00ff0a7b82ULL, 0x000e620000000a00ULL,
0x0000000817357824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee206ULL,
0x0000000123067824ULL, 0x140fe200078e0250ULL, 0x0000003c50277811ULL, 0x000fe200078fe8ffULL,
0x00000008233f7824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee204ULL,
0x000000011e047824ULL, 0x100fe200078e0250ULL, 0x0000005050057211ULL, 0x000fe200078fe8ffULL,
0x000000081e3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee206ULL,
0x0000000125067824ULL, 0x100fe200078e0250ULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x0000000825417824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee204ULL,
0x0000000127077824ULL, 0x000fe200078e0250ULL, 0x0000000963047c11ULL, 0x000fe2000f8e70ffULL,
0x0000000827147824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee206ULL,
0x00000001510d7824ULL, 0x000fe200078e020dULL, 0x0ffffff805057812ULL, 0x000fe200078ef850ULL,
0x0000200053067824ULL, 0x000fe200078e0204ULL, 0xfffffff814437812ULL, 0x000fe200078ee207ULL,
0x0000000151107824ULL, 0x000fe200078e0210ULL, 0x0000005150077211ULL, 0x040fe200078fe8ffULL,
0x00002000060c7836ULL, 0x000fe20000000000ULL, 0x0000000a79477211ULL, 0x002fe200078038ffULL,
0x0000001050067824ULL, 0x000fc400078e00ffULL, 0x0000001005057824ULL, 0x100fe200078e020cULL,
0x0000000b79797211ULL, 0x000fe200000f3cffULL, 0x0000001009097824ULL, 0x000fe200078e020cULL,
0x0000007006457812ULL, 0x000fe200078ec0ffULL, 0x0000008007067825ULL, 0x000fc800078e00ffULL,
0x0000001019197824ULL, 0x100fe200078e020cULL, 0x0000004506067212ULL, 0x000fe200078efcffULL,
0x000000101d1d7824ULL, 0x100fe400078e020cULL, 0x000000101f1f7824ULL, 0x100fe200078e020cULL,
0x0000000647067210ULL, 0x000fe20007f1e0ffULL, 0x000000102f2f7824ULL, 0x100fe400078e020cULL,
0x0000001031317824ULL, 0x100fe400078e020cULL, 0x0000001033337824ULL, 0x000fc400078e020cULL,
0x0000001035357824ULL, 0x100fe400078e020cULL, 0x0000001037377824ULL, 0x100fe400078e020cULL,
0x0000001039397824ULL, 0x100fe400078e020cULL, 0x000000103b3b7824ULL, 0x100fe400078e020cULL,
0x000000103d3d7824ULL, 0x100fe400078e020cULL, 0x000000103f3f7824ULL, 0x000fc400078e020cULL,
0x0000001041417824ULL, 0x100fe400078e020cULL, 0x0000001043437824ULL, 0x000fe400078e020cULL,
0x00000001510c7824ULL, 0x000fe400078e020eULL, 0x000000800d0a7825ULL, 0x000fc800078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000450a0a7212ULL, 0x000fc600078efcffULL,
0x00000001510f7824ULL, 0x000fe200078e020fULL, 0x000000450c0c7212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000a470a7210ULL, 0x000fc60007f3e0ffULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x0000004510107212ULL, 0x000fc600078efcffULL,
0x0000000107077824ULL, 0x000fe200000e0679ULL, 0x0000000c470c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000151127824ULL, 0x040fe200078e0212ULL, 0x000000450e0e7212ULL, 0x000fe200078efcffULL,
0x0000000151147824ULL, 0x040fe200078e0213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000b901c46ULL, 0x0000000151167824ULL, 0x040fe200078e0215ULL,
0x0000000e470e7210ULL, 0x000fe20007f5e0ffULL, 0x00000001511a7824ULL, 0x000fe400078e0217ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004512127212ULL, 0x000fc600078efcffULL, 0x000000010d0d7824ULL, 0x000fe200000e0679ULL,
0x0000001047107210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004514147212ULL, 0x000fc600078efcffULL, 0x0000000151207824ULL, 0x000fe200078e0218ULL,
0x0000004516167212ULL, 0x000fe200078efcffULL, 0x000000801a1a7825ULL, 0x000fc800078e00ffULL,
0x0000000151227824ULL, 0x040fe200078e021cULL, 0x000000451a1a7212ULL, 0x000fe200078efcffULL,
0x0000000151247824ULL, 0x040fe400078e021eULL, 0x0000000151267824ULL, 0x040fe200078e0221ULL,
0x0000001a471a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000151287824ULL, 0x000fe400078e0223ULL,
0x0000008020207825ULL, 0x000fc800078e00ffULL, 0x00000001512a7824ULL, 0x000fe200078e0225ULL,
0x0000004520207212ULL, 0x000fe200078efcffULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x0000000111117824ULL, 0x000fe200000e0679ULL, 0x0000001247127210ULL, 0x000fe20007f1e0ffULL,
0x00000001512c7824ULL, 0x000fe200078e0227ULL, 0x0000004522227212ULL, 0x000fe200078efcffULL,
0x0000008024247825ULL, 0x000fc800078e00ffULL, 0x000000010b0b7824ULL, 0x100fe200008e0679ULL,
0x0000001447147210ULL, 0x000fe20007f3e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000004524247212ULL, 0x080fe400078efcffULL, 0x000000000a097faeULL, 0x0003e2000b901c46ULL,
0x000000010f0f7824ULL, 0x100fe200010e0679ULL, 0x0000001647167210ULL, 0x000fe20007f5e0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000004526267212ULL, 0x080fe200078efcffULL,
0x000000000c197faeULL, 0x0003e4000b901c46ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000004528287212ULL, 0x080fe200078efcffULL, 0x000000000e1d7faeULL, 0x0003e4000b901c46ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x000000452a2a7212ULL, 0x080fe200078efcffULL,
0x00000000101f7faeULL, 0x0003e2000b901c46ULL, 0x0000002847287210ULL, 0x000fe20007f9e0ffULL,
0x0000000113137824ULL, 0x100fe200000e0679ULL, 0x0000002047207210ULL, 0x000fe20007f1e0ffULL,
0x0000000115157824ULL, 0x100fe200008e0679ULL, 0x0000002247227210ULL, 0x000fe20007f3e0ffULL,
0x0000000117177824ULL, 0x100fe200010e0679ULL, 0x000000452c2c7212ULL, 0x000fe200078efcffULL,
0x000000011b1b7824ULL, 0x100fe200018e0679ULL, 0x0000002447247210ULL, 0x000fe20007f5e0ffULL,
0x0000000121217824ULL, 0x100fe200000e0679ULL, 0x0000002647267210ULL, 0x000fe20007f7e0ffULL,
0x0000000123237824ULL, 0x100fe200008e0679ULL, 0x0000002a472a7210ULL, 0x000fe20007fbe0ffULL,
0x00000000122f7faeULL, 0x0003e2000b901c46ULL, 0x0000002c472c7210ULL, 0x000fe20007fde0ffULL,
0x0000000125257824ULL, 0x000fc400010e0679ULL, 0x0000000014317faeULL, 0x0003e2000b901c46ULL,
0x0000000127277824ULL, 0x100fe400018e0679ULL, 0x0000000129297824ULL, 0x100fe200020e0679ULL,
0x0000000016337faeULL, 0x0003e2000b901c46ULL, 0x000000012b2b7824ULL, 0x100fe400028e0679ULL,
0x000000012d2d7824ULL, 0x000fe200030e0679ULL, 0x000000001a357faeULL, 0x0003e8000b901c46ULL,
0x0000000020377faeULL, 0x0003e8000b901c46ULL, 0x0000000022397faeULL, 0x0003e8000b901c46ULL,
0x00000000243b7faeULL, 0x0003e8000b901c46ULL, 0x00000000263d7faeULL, 0x0003e8000b901c46ULL,
0x00000000283f7faeULL, 0x0003e8000b901c46ULL, 0x000000002a417faeULL, 0x0003e8000b901c46ULL,
0x000000002c437faeULL, 0x0003e4000b901c46ULL, 0x000000047b7b7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff797424ULL, 0x000fc600078e00ffULL,
0x000000627b00720cULL, 0x000fda0003f06070ULL, 0x00009000ff0a8b82ULL, 0x002e620000000a00ULL,
0x0000000275058824ULL, 0x000fe200078e027bULL, 0x00000008500d7812ULL, 0x040fe200078ec0ffULL,
0x00000020505f7836ULL, 0x000fe20000000000ULL, 0xfffffff850097812ULL, 0x000fe200078ec0ffULL,
0x00002000085b7824ULL, 0x000fe200078e0204ULL, 0x00000004ff597819ULL, 0x000fe20000011650ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x00000007505a7812ULL, 0x000fe400078ec0ffULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fc4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fc4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000004050a8825ULL, 0x002fe200078e000aULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000060a798981ULL, 0x000322000c1e1900ULL, 0xfffffff85f5f7812ULL, 0x000fc400078ec0ffULL,
0x0000000000047805ULL, 0x000fe4000001ff00ULL, 0x000000070d5c7812ULL, 0x000fe400078ef850ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fc4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x000020005b5b7836ULL, 0x000fe20000000000ULL, 0x0000000709607812ULL, 0x000fe200078ef850ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000075f5f7812ULL, 0x000fe400078ef850ULL,
0x000000105c587812ULL, 0x002fce00078efcffULL, 0x0000000160087824ULL, 0x140fe400078e0272ULL,
0x0000000860097824ULL, 0x000fe400078e00ffULL, 0x000000015f0c7824ULL, 0x040fe400078e0272ULL,
0x000000085f0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe200078ee208ULL,
0x0000000272917824ULL, 0x000fe400078e0259ULL, 0x00000010589b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0c7812ULL, 0x000fe200078ee20cULL, 0x0000001008087824ULL, 0x000fc800078e025bULL,
0x000000100c0c7824ULL, 0x000fe400078e025bULL, 0x000000000808783bULL, 0x000e680000000200ULL,
0x000000000c0c783bULL, 0x000ea20000000200ULL, 0x00000018ff4c7819ULL, 0x002fe20000011408ULL,
0x00010000084d7824ULL, 0x040fe200078e00ffULL, 0x00008880084e7816ULL, 0x040fe200000000ffULL,
0x0000010008087824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011409ULL,
0x0001000009547824ULL, 0x040fe200078e00ffULL, 0x00008880096e7816ULL, 0x040fe200000000ffULL,
0x0000010009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fc4000001144dULL,
0x00000018ff717819ULL, 0x000fe4000001140aULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x000088800a707816ULL, 0x000fe200000000ffULL, 0x00000008004d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff697819ULL, 0x004fe4000001140cULL,
0x000088800c687816ULL, 0x000fc400000000ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001140dULL,
0x0000000900807306ULL, 0x0005e20000200c00ULL, 0x000100000a087824ULL, 0x042fe200078e00ffULL,
0x000088800d6a7816ULL, 0x000fe200000000ffULL, 0x000001000a0a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe4000001140bULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000018ff0a7819ULL, 0x000fe2000001140aULL, 0x000100000b097824ULL, 0x044fe200078e00ffULL,
0x0000005400997306ULL, 0x0003e20000200c00ULL, 0x000088800b667816ULL, 0x040fe200000000ffULL,
0x000001000b0b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001140eULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x0000000a00987306ULL, 0x0005e20000200c00ULL, 0x0000000860547824ULL, 0x002fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe4000001140fULL, 0x000088800e6c7816ULL, 0x000fe400000000ffULL,
0x000088800f647816ULL, 0x000fe400000000ffULL, 0x00000009008b7306ULL, 0x0003e20000200c00ULL,
0x00000001720a7836ULL, 0x004fc40000000000ULL, 0x0000000272727836ULL, 0x000fca0000000000ULL,
0x0000000800977306ULL, 0x0005e20000200c00ULL, 0x0000000160097824ULL, 0x102fe200078e020aULL,
0x000000087200780cULL, 0x000fe20003f05270ULL, 0x000000015f0a7824ULL, 0x000fc600078e020aULL,
0xfffffff854547812ULL, 0x000fe200078ee209ULL, 0x000100000d097824ULL, 0x040fe200078e00ffULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000100000c087824ULL, 0x004fe400078e00ffULL,
0x0000001054547824ULL, 0x000fe200078e025bULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x000001000c0c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x000001000d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000b00967306ULL, 0x0005e20000200c00ULL,
0x000000005454783bULL, 0x000ee20000000200ULL, 0x00000018ff0c7819ULL, 0x000fc4000001140cULL,
0x00000018ff0d7819ULL, 0x000fc8000001140dULL, 0x0000000c00947306ULL, 0x000be20000200c00ULL,
0x000000085f0b7824ULL, 0x004fca00078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fe400078ee20aULL,
0x0000000d00927306ULL, 0x0005e20000200c00ULL, 0x000100000f0c7824ULL, 0x060fe400078e00ffULL,
0x000001000f0f7824ULL, 0x000fe400078e00ffULL, 0x000000100a0a7824ULL, 0x000fe200078e025bULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000000800957306ULL, 0x000be20000200c00ULL,
0x000000105c0d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fcc000001140fULL,
0x0000000c008f7306ULL, 0x0005e20000200c00ULL, 0x000100000e087824ULL, 0x060fe400078e00ffULL,
0x000001000e0e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff937819ULL, 0x000fe40000011408ULL,
0x0000004c004c7306ULL, 0x000f620000200c00ULL, 0x000000015c0c7824ULL, 0x004fe200078e0291ULL,
0x00000018ff877819ULL, 0x008fe20000011454ULL, 0x0001000055827824ULL, 0x040fe200078e00ffULL,
0x0000888054897816ULL, 0x040fe400000000ffULL, 0xfffffff00d0c7812ULL, 0x000fe200078ee20cULL,
0x00010000540d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011455ULL,
0x0000010054547824ULL, 0x000fe200078e00ffULL, 0x0000888055857816ULL, 0x040fe200000000ffULL,
0x0000010055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x00000009008d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff867819ULL, 0x000fe20000011455ULL, 0x0001000056557824ULL, 0x000fe200078e00ffULL,
0x000000090c0c7c11ULL, 0x000fe4000f8e20ffULL, 0x00000018ff8c7819ULL, 0x000fe2000001140dULL,
0x00000054008a7306ULL, 0x0007e20000200c00ULL, 0x00000018ff847819ULL, 0x000fe20000011455ULL,
0x000000000a08783bULL, 0x004ea20000000200ULL, 0x00000018ff7f7819ULL, 0x000fe40000011456ULL,
0x0000888056837816ULL, 0x040fe200000000ffULL, 0x0000010056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000000e008e7306ULL, 0x000fe20000200c00ULL,
0x0000000158547824ULL, 0x008fe200078e0291ULL, 0x00000018ff7e7819ULL, 0x000fe20000011457ULL,
0x0000000291917836ULL, 0x000fe20000000000ULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0xfffffff09b557812ULL, 0x000fe400078ee254ULL, 0x000054104e547816ULL, 0x002fe2000000004fULL,
0x0000000f00907306ULL, 0x0003e20000200c00ULL, 0x00000009554e7c11ULL, 0x000fe4000f8e20ffULL,
0x000054104d557816ULL, 0x020fe4000000004cULL, 0x00008880579a7816ULL, 0x000fe400000000ffULL,
0x000000004e4c783bULL, 0x000ee20000000200ULL, 0x0000006f006f7306ULL, 0x000f660000200c00ULL,
0x000000000c0c783bULL, 0x002e6a0000000200ULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x00005410806f7816ULL, 0x020fce000000006fULL, 0x0000006700677306ULL, 0x000f620000200c00ULL,
0x00000018ff7d7819ULL, 0x004fe20000011408ULL, 0x000000ffff807224ULL, 0x000fe200078e009aULL,
0x00000018ff7c7819ULL, 0x000fe40000011409ULL, 0x00000018ff7a7819ULL, 0x000fe4000001140aULL,
0x0000541098717816ULL, 0x000fe20000000071ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x00000018ff787819ULL, 0x000fe4000001140bULL, 0x0000541096677816ULL, 0x020fca0000000067ULL,
0x0000006b006b7306ULL, 0x000f620000200c00ULL, 0x0000541094697816ULL, 0x004fce0000000069ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x000000544c28723cULL, 0x008fe20000001828ULL,
0x00005410926b7816ULL, 0x020fcc000000006bULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x000000540c48723cULL, 0x002fe20000001848ULL, 0x0001000008927824ULL, 0x000fe200078e00ffULL,
0x000054108e6d7816ULL, 0x004fca000000006dULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541090657816ULL, 0x008fce0000000065ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x000054106e6e7816ULL, 0x002fce0000000099ULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x0000006e0c44723cULL, 0x000fe20000001844ULL, 0x0000541070707816ULL, 0x004fcc0000000097ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0001000057977824ULL, 0x040fe400078e00ffULL,
0x0000010057577824ULL, 0x000fe200078e00ffULL, 0x0000006e4c24723cULL, 0x000fe20000001824ULL,
0x0000541066667816ULL, 0x002fc6000000008bULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x000000700c40723cULL, 0x000fe20000001840ULL,
0x00000018ff8b7819ULL, 0x000fe40000011497ULL, 0x0000541068687816ULL, 0x004fc60000000095ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000000660c3c723cULL, 0x000fe2000000183cULL,
0x000054106a6a7816ULL, 0x002fcc000000008dULL, 0x0000009300937306ULL, 0x000e620000200c00ULL,
0x000000680c38723cULL, 0x000fec0000001838ULL, 0x0000006a0c34723cULL, 0x000fe20000001834ULL,
0x0000006400647306ULL, 0x000eaa0000200c00ULL, 0x000000684c18723cULL, 0x000fe20000001818ULL,
0x000054106c6c7816ULL, 0x002fc40000000093ULL, 0x0000008200887306ULL, 0x000fe60000200c00ULL,
0x000000664c1c723cULL, 0x000fe2000000181cULL, 0x0000541064647816ULL, 0x004fc8000000008fULL,
0x0000005600827306ULL, 0x0003e20000200c00ULL, 0x0000006c0c30723cULL, 0x000fe20000001830ULL,
0x00000018ff8f7819ULL, 0x000fca0000011492ULL, 0x000000640c2c723cULL, 0x000fe2000000182cULL,
0x00000057008d7306ULL, 0x000fe20000200c00ULL, 0x0000888008567816ULL, 0x042fe200000000ffULL,
0x0000010008087824ULL, 0x000fc600078e00ffULL, 0x000000704c20723cULL, 0x000fe20000001820ULL,
0x00008880090c7816ULL, 0x040fe200000000ffULL, 0x00000010580e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011408ULL, 0x000000015c087824ULL, 0x100fe200078e0291ULL,
0x00000056008e7306ULL, 0x0003e20000200c00ULL, 0x000000ffff6e7224ULL, 0x000fe200078e000cULL,
0x0000006a4c14723cULL, 0x000fe20000001814ULL, 0x00010000090c7824ULL, 0x000fe400078e00ffULL,
0x0000000158917824ULL, 0x000fc400078e0291ULL, 0x000000105c0d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x0000010009097824ULL, 0x000fe200078e00ffULL,
0xfffffff00e917812ULL, 0x000fe200078ee291ULL, 0x0000006c4c10723cULL, 0x000fe20000001810ULL,
0xfffffff00d087812ULL, 0x000fe200078ee208ULL, 0x0000000c006f7306ULL, 0x0005e20000200c00ULL,
0x000088800a0d7816ULL, 0x000fe400000000ffULL, 0x0000000908087c11ULL, 0x000fe2000f8e20ffULL,
0x000000644c04723cULL, 0x000fe20000001804ULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x000000ffff687224ULL, 0x000fe200078e000dULL, 0x000088800b6a7816ULL, 0x000fe200000000ffULL,
0x000000000854783bULL, 0x0022e20000000200ULL, 0x00000009910c7c11ULL, 0x004fe2000f8e20ffULL,
0x0000000900677306ULL, 0x0005e20000200c00ULL, 0x000001000b4c7824ULL, 0x000fc800078e00ffULL,
0x000000000c0c783bULL, 0x000f620000000200ULL, 0x000100000a087824ULL, 0x042fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144cULL, 0x000001000a0a7824ULL, 0x000fe200078e00ffULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000100000b097824ULL, 0x004fe200078e00ffULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x00000018ff6d7819ULL, 0x000fc40000011409ULL, 0x0000000800697306ULL, 0x000e700000200c00ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000541068687816ULL, 0x002fce0000000069ULL,
0x0000000a006b7306ULL, 0x000e700000200c00ULL, 0x0000008700877306ULL, 0x000ea20000200c00ULL,
0x000054106b697816ULL, 0x002fce000000007aULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000000685430723cULL, 0x008fe20000001830ULL, 0x000054108a097816ULL, 0x004fcc0000000087ULL,
0x0000007f007f7306ULL, 0x000e620000200c00ULL, 0x000000680c10723cULL, 0x020fee0000001810ULL,
0x0000007e007e7306ULL, 0x000ea20000200c00ULL, 0x00005410824d7816ULL, 0x002fce000000007fULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000054108d4f7816ULL, 0x004fce000000007eULL,
0x0000007c007c7306ULL, 0x000e700000200c00ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000541067677816ULL, 0x002fce000000007cULL, 0x0000008900897306ULL, 0x000ff00000200c00ULL,
0x0000008c008c7306ULL, 0x000e700000200c00ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x0000541089087816ULL, 0x002fce000000008cULL, 0x0000008600867306ULL, 0x000e620000200c00ULL,
0x000000085448723cULL, 0x000fe20000001848ULL, 0x00005410850a7816ULL, 0x004fcc0000000088ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x000000080c28723cULL, 0x000fe20000001828ULL,
0x00005410860b7816ULL, 0x002fcc0000000081ULL, 0x0000008400847306ULL, 0x000e620000200c00ULL,
0x0000000a5444723cULL, 0x000fee0000001844ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x0000000a0c24723cULL, 0x000fe20000001824ULL, 0x00005410834c7816ULL, 0x002fcc0000000084ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x0000004c5440723cULL, 0x000fee0000001840ULL,
0x0000008f008f7306ULL, 0x000e620000200c00ULL, 0x0000004c0c20723cULL, 0x000fee0000001820ULL,
0x0000009000907306ULL, 0x000ea20000200c00ULL, 0x000054108e647816ULL, 0x002fce000000008fULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541090657816ULL, 0x004fce000000007dULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000000645438723cULL, 0x000fe20000001838ULL,
0x000054106e667816ULL, 0x002fcc000000006fULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x000000640c18723cULL, 0x000fee0000001818ULL, 0x0000004e00717306ULL, 0x0004e20000200c00ULL,
0x000000665434723cULL, 0x000fe20000001834ULL, 0x000054106a6a7816ULL, 0x002fca000000006dULL,
0x000000660c14723cULL, 0x000fe20000001814ULL, 0x00005410804e7816ULL, 0x004fe4000000008bULL,
0x00005410716b7816ULL, 0x008fca0000000078ULL, 0x0000004e543c723cULL, 0x000fec000000183cULL,
0x0000006a542c723cULL, 0x000fec000000182cULL, 0x0000004e0c1c723cULL, 0x000fec000000181cULL,
0x0000006a0c04723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffec00b80947ULL, 0x000fde000383ffffULL, 0x00000001ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000005d48097220ULL, 0x080fe20000410000ULL, 0x0000005d49497220ULL, 0x080fe20000410000ULL,
0x0000005d4a4a7220ULL, 0x080fe20000410000ULL, 0x0000005d4b4b7220ULL, 0x080fe20000410000ULL,
0x0000005d44447220ULL, 0x080fe20000410000ULL, 0x01a6880f520e79a7ULL, 0x000262000850003fULL,
0x0000005d45457220ULL, 0x080fe20000410000ULL, 0x0000005d46467220ULL, 0x080fe20000410000ULL,
0x0000005d47477220ULL, 0x080fe20000410000ULL, 0x0000005d40407220ULL, 0x080fe20000410000ULL,
0x0000005d41417220ULL, 0x080fe20000410000ULL, 0x0000005d42427220ULL, 0x080fe20000410000ULL,
0x0000005d43437220ULL, 0x080fe20000410000ULL, 0x0000005d3c3c7220ULL, 0x080fe20000410000ULL,
0x0000005d3d3d7220ULL, 0x080fe20000410000ULL, 0x0000005d3e3e7220ULL, 0x080fe20000410000ULL,
0x0000005d3f3f7220ULL, 0x080fe20000410000ULL, 0x0000005d38387220ULL, 0x080fe20000410000ULL,
0x0000005d39397220ULL, 0x080fe20000410000ULL, 0x0000005d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000005d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000005d34347220ULL, 0x080fe20000410000ULL,
0x0000005d35357220ULL, 0x080fe20000410000ULL, 0x0000005d36367220ULL, 0x080fe20000410000ULL,
0x0000005d37377220ULL, 0x080fe20000410000ULL, 0x0000005d30307220ULL, 0x080fe20000410000ULL,
0x0000005d31317220ULL, 0x080fe20000410000ULL, 0x0000005d32327220ULL, 0x080fe20000410000ULL,
0x0000005d33337220ULL, 0x080fe20000410000ULL, 0x0000005d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000005d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000005d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000005d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000005d280b7220ULL, 0x080fe20000410000ULL,
0x0000005d29297220ULL, 0x080fe20000410000ULL, 0x0000005d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000005d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000005d24247220ULL, 0x080fe20000410000ULL,
0x0000005d25257220ULL, 0x080fe20000410000ULL, 0x0000005d26267220ULL, 0x080fe20000410000ULL,
0x0000005d27277220ULL, 0x080fe20000410000ULL, 0x0000005d20207220ULL, 0x080fe20000410000ULL,
0x0000005d21217220ULL, 0x080fe20000410000ULL, 0x0000005d22227220ULL, 0x080fe20000410000ULL,
0x0000005d23237220ULL, 0x080fe20000410000ULL, 0x0000005d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000005d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000005d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000005d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000005d18187220ULL, 0x080fe20000410000ULL,
0x0000005d19197220ULL, 0x080fe20000410000ULL, 0x0000005d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000005d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000005d14147220ULL, 0x080fe20000410000ULL,
0x0000005d15157220ULL, 0x080fe20000410000ULL, 0x0000005d16167220ULL, 0x080fe20000410000ULL,
0x0000005d17177220ULL, 0x080fe20000410000ULL, 0x0000005d10107220ULL, 0x080fe20000410000ULL,
0x0000005d11117220ULL, 0x080fe20000410000ULL, 0x0000005d12127220ULL, 0x080fe20000410000ULL,
0x0000005d13137220ULL, 0x080fe20000410000ULL, 0x0000005d04087220ULL, 0x080fe20000410000ULL,
0x0000005d050a7220ULL, 0x080fe20000410000ULL, 0x0000005d060c7220ULL, 0x080fe20000410000ULL,
0x0000005d070d7220ULL, 0x002fce0000410000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x01a6880f520075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff287224ULL, 0x000fce00078e00ffULL, 0x000000102800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x00000004064d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e07ULL,
0x003d09004d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000004d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000128287836ULL, 0x000fce0000000000ULL, 0x01a6880f520075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000450047824ULL, 0x000fe200078e00ffULL,
0x0000000963057c11ULL, 0x000fe4000f8e38ffULL, 0x0000005e7600720cULL, 0x000fe40003f06070ULL,
0xfffffff004047812ULL, 0x000fca00078ec0ffULL, 0x00000001050e7824ULL, 0x000fca00078e0204ULL,
0x01a400000e047984ULL, 0x0002a20000000c00ULL, 0x0000001c00c48947ULL, 0x000fea0003800000ULL,
0x0000010076ab7824ULL, 0x000fe200078e0203ULL, 0x00000000500f7211ULL, 0x040fe200078ff0ffULL,
0x0000000250aa7824ULL, 0x000fe200078e00ffULL, 0x00008600000a7ab9ULL, 0x000fe20000000800ULL,
0x00008c00ff567b82ULL, 0x000ee20000000a00ULL, 0x000000ab74287248ULL, 0x000fe20007fe0000ULL,
0x000000080f487836ULL, 0x000fe20000000000ULL, 0x00000006aaaa7812ULL, 0x000fe200078ec0ffULL,
0x000000100f4c7836ULL, 0x000fe20000000000ULL, 0x00008400000b7ab9ULL, 0x000fe20000000800ULL,
0x0000000128ab7824ULL, 0x000fe200078e0aabULL, 0x0000000aff287c19ULL, 0x000fe2000801160fULL,
0x000000180f4d7836ULL, 0x000fe20000000000ULL, 0x0000000aff487c19ULL, 0x000fe20008011648ULL,
0x00000008aa0f7c36ULL, 0x000fe20008000000ULL, 0x0000000528287c48ULL, 0x000fe2000bfe0000ULL,
0x000000ffff7a7224ULL, 0x000fe200078e0aabULL, 0x0000000aff4c7c19ULL, 0x000fe2000801164cULL,
0x0000000baaa97c36ULL, 0x000fe20008000000ULL, 0x000000ab0f00720cULL, 0x000fe20003f26070ULL,
0x00000004286e7c24ULL, 0x000fe2000f8e02ffULL, 0x000000050f0f7e46ULL, 0x000fc4000b80007aULL,
0x000000aba900720cULL, 0x000fe40003f06070ULL, 0x00000005a99a7e46ULL, 0x000fe4000b80007aULL,
0x00000004ff0f7819ULL, 0x000fe4000001160fULL, 0x000000ff9a9a7207ULL, 0x000fe40000000000ULL,
0x000000ff0f0f7207ULL, 0x000fe40000800000ULL, 0x0000000aff287c19ULL, 0x000fc4000801164dULL,
0x0000006e9a4d7211ULL, 0x000fe200078fe0ffULL, 0x000000016e657824ULL, 0x000fe200078e020fULL,
0x0000000548487c48ULL, 0x000fe4000bfe0000ULL, 0x000000054c607c48ULL, 0x000fe2000bfe0000ULL,
0x000000024d4c7825ULL, 0x008fe200078e0056ULL, 0x0000000528287c48ULL, 0x000fc6000bfe0000ULL,
0x0000000265647825ULL, 0x000fe200078e0056ULL, 0x000000064ca77981ULL, 0x0044e6000c1e9500ULL,
0x00000004486c7c24ULL, 0x000fe2000f8e02ffULL, 0x0000000664a87981ULL, 0x000ee2000c1e9500ULL,
0x0000000460607c24ULL, 0x000fe4000f8e02ffULL, 0x00000004285c7c24ULL, 0x000fe2000f8e02ffULL,
0x0000006c9a4f7211ULL, 0x040fe200078fe0ffULL, 0x000000010f977824ULL, 0x040fe200078e026cULL,
0x000000609a597211ULL, 0x000fe200078fe0ffULL, 0x000000010f5b7824ULL, 0x000fe200078e0260ULL,
0x00000010aa857812ULL, 0x000fe200078efcffULL, 0x000000024f4e7825ULL, 0x000fc800078e0056ULL,
0x000000010f0f7824ULL, 0x000fe200078e025cULL, 0x000000064e957981ULL, 0x000ae2000c1e9500ULL,
0x0000000297967825ULL, 0x000fc800078e0056ULL, 0x0000000259587825ULL, 0x100fe400078e0056ULL,
0x0000000696967981ULL, 0x000ee4000c1e9500ULL, 0x000000025b4c7825ULL, 0x104fe400078e0056ULL,
0x0000000658947981ULL, 0x000ea4000c1e9500ULL, 0x0000000885287c36ULL, 0x000fe40008000000ULL,
0x000000020f4e7825ULL, 0x022fc400078e0056ULL, 0x000000064c0f7981ULL, 0x0002a4000c1e9500ULL,
0x0000000b85867c36ULL, 0x000fe20008000000ULL, 0x0000005c9a557211ULL, 0x000fe200078fe0ffULL,
0x000000064e4e7981ULL, 0x000aa2000c1e9500ULL, 0x0000000528487e46ULL, 0x000fe4000b80007aULL,
0x000000ab8600720cULL, 0x080fe40003f06070ULL, 0x0000000586997e46ULL, 0x000fe2000b80007aULL,
0x0000000255547825ULL, 0x000fe200078e0056ULL, 0x000000ab2800720cULL, 0x000fc40003f26070ULL,
0x00000004ff487819ULL, 0x000fe40000011648ULL, 0x000000ff99997207ULL, 0x000fe20000000000ULL,
0x0000000654937981ULL, 0x000aa2000c1e9500ULL, 0x000000ff484d7207ULL, 0x002fe40000800000ULL,
0x0000006e99597211ULL, 0x000fc600078fe0ffULL, 0x000000016e8d7824ULL, 0x000fe400078e024dULL,
0x000000014d4f7824ULL, 0x020fe200078e026cULL, 0x0000006c99557211ULL, 0x000fe200078fe0ffULL,
0x0000000259587825ULL, 0x000fe200078e0056ULL, 0x00000020aa707812ULL, 0x000fc600078efcffULL,
0x000000028d8c7825ULL, 0x000fe200078e0056ULL, 0x00000006588b7981ULL, 0x000366000c1e9500ULL,
0x000000014d5b7824ULL, 0x040fe400078e0260ULL, 0x000000014d5f7824ULL, 0x000fe200078e025cULL,
0x000000068c8c7981ULL, 0x000f62000c1e9500ULL, 0x0000000255547825ULL, 0x000fc800078e0056ULL,
0x000000024f4c7825ULL, 0x100fe200078e0056ULL, 0x0000000654897981ULL, 0x000366000c1e9500ULL,
0x000000025b587825ULL, 0x102fe200078e0056ULL, 0x000000064c8a7981ULL, 0x000366000c1e9500ULL,
0x00000008705b7c36ULL, 0x000fe20008000000ULL, 0x0000006099677211ULL, 0x040fe200078fe0ffULL,
0x0000000b70717c36ULL, 0x000fe20008000000ULL, 0x0000005c99657211ULL, 0x000fe200078fe0ffULL,
0x000000025f547825ULL, 0x100fe200078e0056ULL, 0x000000055b5f7e46ULL, 0x000fe2000b80007aULL,
0x0000000658287981ULL, 0x000f62000c1e9500ULL, 0x000000ab7100720cULL, 0x080fe20003f06070ULL,
0x0000000267667825ULL, 0x100fe200078e0056ULL, 0x0000000571487e46ULL, 0x000fe2000b80007aULL,
0x00000006544f7981ULL, 0x000362000c1e9500ULL, 0x000000ab5b00720cULL, 0x000fe20003f26070ULL,
0x0000000265647825ULL, 0x000fe200078e0056ULL, 0x00000004ff5f7819ULL, 0x000fe2000001165fULL,
0x0000000666877981ULL, 0x000364000c1e9500ULL, 0x000000ff484d7207ULL, 0x002fc40000000000ULL,
0x000000ff5f5f7207ULL, 0x000fe20000800000ULL, 0x0000000664887981ULL, 0x000362000c1e9500ULL,
0x0000006c4d557211ULL, 0x000fc600078fe0ffULL, 0x000000015f677824ULL, 0x000fe400078e026cULL,
0x0000000255547825ULL, 0x000fe200078e0056ULL, 0x0000006e4d657211ULL, 0x002fc600078fe0ffULL,
0x0000000267667825ULL, 0x000fe200078e0056ULL, 0x0000000654727981ULL, 0x000366000c1e9500ULL,
0x000000016e597824ULL, 0x000fe200078e025fULL, 0x0000000666817981ULL, 0x000f62000c1e9500ULL,
0x0000000265647825ULL, 0x000fe200078e0056ULL, 0x000000604d6b7211ULL, 0x000fc600078fe0ffULL,
0x0000000259587825ULL, 0x000fe200078e0056ULL, 0x0000005c4d697211ULL, 0x000fe200078fe0ffULL,
0x0000000664787981ULL, 0x000f64000c1e9500ULL, 0x000000015f5b7824ULL, 0x040fe400078e0260ULL,
0x000000015f5f7824ULL, 0x000fe200078e025cULL, 0x0000000658837981ULL, 0x000362000c1e9500ULL,
0x000000026b6a7825ULL, 0x000fc800078e0056ULL, 0x000000025f547825ULL, 0x102fe200078e0056ULL,
0x000000066a7f7981ULL, 0x000362000c1e9500ULL, 0x00000030aa587812ULL, 0x000fe400078efcffULL,
0x0000000269687825ULL, 0x100fe400078e0056ULL, 0x0000000654547981ULL, 0x000f64000c1e9500ULL,
0x000000025b647825ULL, 0x000fe400078e0056ULL, 0x00000006687d7981ULL, 0x000f64000c1e9500ULL,
0x00000008584c7c36ULL, 0x000fc40008000000ULL, 0x0000000664487981ULL, 0x000f62000c1e9500ULL,
0x0000000b585f7c36ULL, 0x000fe40008000000ULL, 0x000000054c597e46ULL, 0x000fc6000b80007aULL,
0x000000ab5f00720cULL, 0x080fe40003f06070ULL, 0x000000055f977e46ULL, 0x000fe4000b80007aULL,
0x000000ab4c00720cULL, 0x000fe40003f26070ULL, 0x00000004ff597819ULL, 0x000fe40000011659ULL,
0x000000ff97977207ULL, 0x000fe40000000000ULL, 0x000000ff59597207ULL, 0x000fc40000800000ULL,
0x0000006e97677211ULL, 0x040fe400078fe0ffULL, 0x00000060978f7211ULL, 0x000fe200078fe0ffULL,
0x000000016e6b7824ULL, 0x002fe400078e0259ULL, 0x00000001596f7824ULL, 0x000fe400078e0260ULL,
0x0000000267667825ULL, 0x000fc800078e0056ULL, 0x000000026b6a7825ULL, 0x100fe400078e0056ULL,
0x0000000666667981ULL, 0x000364000c1e9500ULL, 0x000000028f8e7825ULL, 0x100fe400078e0056ULL,
0x000000066a6b7981ULL, 0x000f64000c1e9500ULL, 0x000000026f6e7825ULL, 0x000fe200078e0056ULL,
0x0000006c97917211ULL, 0x000fe200078fe0ffULL, 0x000000068e677981ULL, 0x002f64000c1e9500ULL,
0x0000000159697824ULL, 0x000fc400078e026cULL, 0x000000066e4c7981ULL, 0x000f64000c1e9500ULL,
0x0000000269687825ULL, 0x000fc800078e0056ULL, 0x0000000291907825ULL, 0x000fe400078e0056ULL,
0x0000000668697981ULL, 0x000f62000c1e9500ULL, 0x0000005c976d7211ULL, 0x000fc600078fe0ffULL,
0x0000000690647981ULL, 0x000362000c1e9500ULL, 0x0000000159597824ULL, 0x000fe400078e025cULL,
0x000000026d6c7825ULL, 0x000fc800078e0056ULL, 0x0000000259567825ULL, 0x000fe200078e0056ULL,
0x000000066c607981ULL, 0x000f68000c1e9500ULL, 0x0000000656657981ULL, 0x000362000c1e9500ULL,
0xfffffff09a9a7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff987424ULL, 0x000fc800078e00ffULL,
0x00000001abb77824ULL, 0x000fc800078e029aULL, 0x00000001a9b97824ULL, 0x000fe200078e0ab7ULL,
0x00000001aa917812ULL, 0x002fc800078efcffULL, 0x000000b998a67219ULL, 0x000fe200000006ffULL,
0x0000000b91927c36ULL, 0x000fe20008000000ULL, 0xfffffff097a07812ULL, 0x000fc600078ec0ffULL,
0x0000000192977824ULL, 0x000fe200078e0ab7ULL, 0x00000008aa8e7812ULL, 0x040fe400078efcffULL,
0x00000009aa8d7812ULL, 0x000fe400078efcffULL, 0x0000009798977219ULL, 0x000fe200000006ffULL,
0x0000000b8e907c36ULL, 0x000fe20008000000ULL, 0x00000031aa577812ULL, 0x040fe200078efcffULL,
0x0000000b8d8f7c36ULL, 0x000fe20008000000ULL, 0x00000038aa567812ULL, 0x040fe400078efcffULL,
0x00000039aa557812ULL, 0x000fc400078efcffULL, 0xfffffff0999c7812ULL, 0x000fe200078ec0ffULL,
0x0000000190997824ULL, 0x100fe400078e0ab7ULL, 0x0000000b575c7c36ULL, 0x000fe40008000000ULL,
0x0000000b565b7c36ULL, 0x000fe40008000000ULL, 0x0000000b55597c36ULL, 0x000fe40008000000ULL,
0x00000001ab9a7824ULL, 0x000fe400078e02a0ULL, 0x000000018fb77824ULL, 0x000fe200078e0ab7ULL,
0xfffffff04d9e7812ULL, 0x000fe200078ec0ffULL, 0x000000015fa37824ULL, 0x100fe200078e0a9aULL,
0x00000011aa827812ULL, 0x000fe200078efcffULL, 0x000000015cad7824ULL, 0x100fe200078e0a9aULL,
0x0000009998997219ULL, 0x000fe200000006ffULL, 0x000000015ba57824ULL, 0x000fc400078e0a9aULL,
0x00000001594d7824ULL, 0x000fe200078e0a9aULL, 0x000000b7989a7219ULL, 0x000fe400000006ffULL,
0x00005410a7a77816ULL, 0x008fc800000000a8ULL, 0x000000a7a6ff7212ULL, 0x000fc800078ac0ffULL,
0x000000aba900720cULL, 0x000fc80002fa1470ULL, 0x000000abaa00720cULL, 0x000fe40002fa1070ULL,
0x000000a797ff7212ULL, 0x000fe4000782c0ffULL, 0xff80000009097808ULL, 0x000fe40002800000ULL,
0x0000541095957816ULL, 0x000fc80000000096ULL, 0x00000095a6ff7212ULL, 0x080fe4000784c0ffULL,
0x0000009597ff7212ULL, 0x000fe400078ac0ffULL, 0x00005410940f7816ULL, 0x004fc8000000000fULL,
0x0000000fa6ff7212ULL, 0x000fe4000788c0ffULL, 0x000000aba900720cULL, 0x0c0fe40001741470ULL,
0x000000aba900720cULL, 0x080fe40002781470ULL, 0x000000ab9200720cULL, 0x0c0fe40000f21470ULL,
0x000000ab9200720cULL, 0x080fe40002fa1470ULL, 0x000000abaa00720cULL, 0x000fc40001741070ULL,
0x000000abaa00720cULL, 0x0c0fe40002781070ULL, 0x000000ab9100720cULL, 0x0c0fe40000f21070ULL,
0x000000ab9100720cULL, 0x000fe40002fa1070ULL, 0x00005410934e7816ULL, 0x000fe2000000004eULL,
0x0000000b82847c36ULL, 0x000fe20008000000ULL, 0x00000021aa6e7812ULL, 0x040fe200078efcffULL,
0x00000001abb37824ULL, 0x000fe200078e029cULL, 0x00000028aa6a7812ULL, 0x000fc400078efcffULL,
0x00000029aa687812ULL, 0x000fe400078efcffULL, 0xff8000004a4a7808ULL, 0x000fe40001000000ULL,
0xff8000000b0b7808ULL, 0x000fe40002000000ULL, 0xff80000049497808ULL, 0x000fe40000800000ULL,
0xff8000004b4b7808ULL, 0x000fe40002800000ULL, 0x000000a799ff7212ULL, 0x000fc4000786c0ffULL,
0x0000004ea6ff7212ULL, 0x080fe4000780c0ffULL, 0x0000000f97ff7212ULL, 0x040fe4000784c0ffULL,
0x0000004e97ff7212ULL, 0x000fe4000788c0ffULL, 0x000000959aff7212ULL, 0x000fe4000782c0ffULL,
0x0000000f99ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000b6e6f7c36ULL, 0x000fe20008000000ULL,
0x000000aba900720cULL, 0x080fe20000701470ULL, 0x0000000b6a6d7c36ULL, 0x000fe20008000000ULL,
0x000000ab9200720cULL, 0x0c0fe20001741470ULL, 0x0000000b686c7c36ULL, 0x000fe20008000000ULL,
0x000000ab9200720cULL, 0x080fe20002781470ULL, 0x00000001ab9c7824ULL, 0x000fe200078e029eULL,
0x000000ab9000720cULL, 0x080fe20001f61470ULL, 0x00000001869b7824ULL, 0x100fe200078e0ab3ULL,
0x000000ab9000720cULL, 0x080fe20002fa1470ULL, 0x0000000184b57824ULL, 0x000fe200078e0ab3ULL,
0x000000ab8f00720cULL, 0x080fe20000f21470ULL, 0x00000001719f7824ULL, 0x100fe200078e0a9cULL,
0x00000018aa7c7812ULL, 0x040fe200078efcffULL, 0x000000016fb17824ULL, 0x100fe200078e0a9cULL,
0x00000019aa7a7812ULL, 0x040fe200078efcffULL, 0x000000016da17824ULL, 0x100fe200078e0a9cULL,
0x000000abaa00720cULL, 0x080fe20000701070ULL, 0x000000016caf7824ULL, 0x000fe200078e0a9cULL,
0x000000ab9100720cULL, 0x000fc40001741070ULL, 0x000000ab9100720cULL, 0x080fe40002781070ULL,
0x000000ab8e00720cULL, 0x0c0fe40001f61070ULL, 0x000000ab8e00720cULL, 0x080fe40002fa1070ULL,
0x000000ab8d00720cULL, 0x000fe40000f21070ULL, 0x0000009b989b7219ULL, 0x040fe400000006ffULL,
0x000000b5989c7219ULL, 0x000fc400000006ffULL, 0x000054108b8b7816ULL, 0x020fe4000000008cULL,
0x0000541089897816ULL, 0x000fe2000000008aULL, 0x0000000b7c807c36ULL, 0x000fe20008000000ULL,
0xff8000002a2a7808ULL, 0x000fe20000000000ULL, 0x0000000b7a7e7c36ULL, 0x000fe20008000000ULL,
0xff80000029297808ULL, 0x000fe40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff80000044447808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0xff80000047477808ULL, 0x000fe40000800000ULL, 0x0000009599ff7212ULL, 0x040fe4000780c0ffULL,
0x0000000f9aff7212ULL, 0x040fe4000784c0ffULL, 0x0000004e99ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004e9aff7212ULL, 0x000fc4000786c0ffULL, 0x0000008b9cff7212ULL, 0x000fe400078ac0ffULL,
0x000000899bff7212ULL, 0x000fe2000782c0ffULL, 0x00000001809d7824ULL, 0x100fe200078e0ab3ULL,
0x000000ab9000720cULL, 0x080fe20000701470ULL, 0x000000017eb37824ULL, 0x000fe200078e0ab3ULL,
0x000000ab9000720cULL, 0x080fe40002781470ULL, 0x000000ab8f00720cULL, 0x0c0fe40001741470ULL,
0x000000ab8f00720cULL, 0x000fc40001f61470ULL, 0x000000ab8600720cULL, 0x080fe40000f21470ULL,
0x000000ab8400720cULL, 0x080fe40002fa1470ULL, 0x000000ab8e00720cULL, 0x0c0fe40000701070ULL,
0x000000ab8e00720cULL, 0x080fe40002781070ULL, 0x000000ab8d00720cULL, 0x0c0fe40001741070ULL,
0x000000ab8d00720cULL, 0x000fc40001f61070ULL, 0x000000ab8500720cULL, 0x080fe40000f21070ULL,
0x000000ab8200720cULL, 0x000fe40002fa1070ULL, 0x0000009d989d7219ULL, 0x040fe400000006ffULL,
0x000000b3989e7219ULL, 0x000fe400000006ffULL, 0x0000541087287816ULL, 0x000fe40000000028ULL,
0x00005410884f7816ULL, 0x000fc4000000004fULL, 0xff80000046467808ULL, 0x000fe40000000000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000042427808ULL, 0x000fe40000800000ULL,
0xff80000041417808ULL, 0x000fc40002800000ULL, 0x0000008b9bff7212ULL, 0x080fe4000780c0ffULL,
0x0000008b9dff7212ULL, 0x000fe4000788c0ffULL, 0x000000289bff7212ULL, 0x0c0fe4000784c0ffULL,
0x0000004f9bff7212ULL, 0x000fe4000786c0ffULL, 0x000000289cff7212ULL, 0x000fe4000782c0ffULL,
0x000000899eff7212ULL, 0x000fc400078ac0ffULL, 0x000000ab8600720cULL, 0x0c0fe40000701470ULL,
0x000000ab8600720cULL, 0x0c0fe40001741470ULL, 0x000000ab8600720cULL, 0x080fe40001f61470ULL,
0x000000ab8400720cULL, 0x080fe40000f21470ULL, 0x000000ab8000720cULL, 0x080fe40002781470ULL,
0x000000ab7e00720cULL, 0x000fc40002fa1470ULL, 0x000000ab8500720cULL, 0x0c0fe40000701070ULL,
0x000000ab8500720cULL, 0x0c0fe40001741070ULL, 0x000000ab8500720cULL, 0x080fe40001f61070ULL,
0x000000ab8200720cULL, 0x080fe40000f21070ULL, 0x000000ab7c00720cULL, 0x080fe40002781070ULL,
0x000000ab7a00720cULL, 0x000fc40002fa1070ULL, 0x0000009f989f7219ULL, 0x000fe400000006ffULL,
0x0000541072727816ULL, 0x000fe40000000081ULL, 0xff80000040407808ULL, 0x000fe40000000000ULL,
0xff80000020207808ULL, 0x000fe40001000000ULL, 0xff80000022227808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fc40000800000ULL, 0xff8000003c3c7808ULL, 0x000fe40002000000ULL,
0xff8000003f3f7808ULL, 0x000fe40002800000ULL, 0x000000899cff7212ULL, 0x040fe4000780c0ffULL,
0x0000004f9cff7212ULL, 0x000fe4000784c0ffULL, 0x000000899dff7212ULL, 0x000fe4000786c0ffULL,
0x000000289eff7212ULL, 0x000fc4000782c0ffULL, 0x0000004f9eff7212ULL, 0x000fe4000788c0ffULL,
0x000000729fff7212ULL, 0x000fe400078ac0ffULL, 0x000000ab8400720cULL, 0x0c0fe40000701470ULL,
0x000000ab8400720cULL, 0x080fe40001741470ULL, 0x000000ab8000720cULL, 0x080fe40001f61470ULL,
0x000000ab7e00720cULL, 0x000fc40000f21470ULL, 0x000000ab7e00720cULL, 0x080fe40002781470ULL,
0x000000ab7100720cULL, 0x080fe40002fa1470ULL, 0x000000ab8200720cULL, 0x0c0fe40000701070ULL,
0x000000ab8200720cULL, 0x080fe40001741070ULL, 0x000000ab7c00720cULL, 0x080fe40001f61070ULL,
0x000000ab7a00720cULL, 0x000fc40000f21070ULL, 0x000000ab7a00720cULL, 0x080fe40002781070ULL,
0x000000ab7000720cULL, 0x000fe40002fa1070ULL, 0x000000b198a07219ULL, 0x000fe400000006ffULL,
0x0000541078787816ULL, 0x000fe40000000083ULL, 0x000054107f487816ULL, 0x000fe40000000048ULL,
0x000054107d547816ULL, 0x000fc40000000054ULL, 0xff80000043437808ULL, 0x000fe40000000000ULL,
0xff80000023237808ULL, 0x000fe40001000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001800000ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff8000003a3a7808ULL, 0x000fc40002800000ULL, 0x000000a79aff7212ULL, 0x000fe400078cc0ffULL,
0x000000289dff7212ULL, 0x040fe4000780c0ffULL, 0x0000004f9dff7212ULL, 0x000fe4000784c0ffULL,
0x000000789fff7212ULL, 0x040fe4000786c0ffULL, 0x000000489fff7212ULL, 0x040fe4000782c0ffULL,
0x000000549fff7212ULL, 0x000fc4000788c0ffULL, 0x00000048a0ff7212ULL, 0x000fe400078ac0ffULL,
0x000000ab8f00720cULL, 0x080fe400037c1470ULL, 0x000000ab8000720cULL, 0x0c0fe40000701470ULL,
0x000000ab8000720cULL, 0x080fe40001741470ULL, 0x000000ab7100720cULL, 0x0c0fe40001f61470ULL,
0x000000ab7100720cULL, 0x000fc40000f21470ULL, 0x000000ab7100720cULL, 0x080fe40002781470ULL,
0x000000ab6f00720cULL, 0x080fe40002fa1470ULL, 0x000000ab8d00720cULL, 0x080fe400037c1070ULL,
0x000000ab7c00720cULL, 0x0c0fe40000701070ULL, 0x000000ab7c00720cULL, 0x080fe40001741070ULL,
0x000000ab7000720cULL, 0x000fc40001f61070ULL, 0x000000ab7000720cULL, 0x0c0fe40000f21070ULL,
0x000000ab7000720cULL, 0x080fe40002781070ULL, 0x000000ab6e00720cULL, 0x000fe40002fa1070ULL,
0x000000a198a17219ULL, 0x040fe400000006ffULL, 0x000000af98a27219ULL, 0x000fe400000006ffULL,
0xff80000045457808ULL, 0x000fc40003000000ULL, 0xff8000001c1c7808ULL, 0x000fe40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff80000038387808ULL, 0x000fe40001800000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fe40002000000ULL,
0xff80000019197808ULL, 0x000fc40002800000ULL, 0x0000008b9eff7212ULL, 0x000fe400078cc0ffULL,
0x00000078a0ff7212ULL, 0x0c0fe4000780c0ffULL, 0x00000078a1ff7212ULL, 0x040fe4000784c0ffULL,
0x00000072a0ff7212ULL, 0x040fe4000786c0ffULL, 0x00000054a0ff7212ULL, 0x000fe4000782c0ffULL,
0x00000072a1ff7212ULL, 0x000fc4000788c0ffULL, 0x00000048a2ff7212ULL, 0x000fe400078ac0ffULL,
0x000000ab7e00720cULL, 0x080fe400037c1470ULL, 0x000000ab6f00720cULL, 0x0c0fe40000701470ULL,
0x000000ab6f00720cULL, 0x0c0fe40001f61470ULL, 0x000000ab6f00720cULL, 0x080fe40000f21470ULL,
0x000000ab6d00720cULL, 0x000fc40001741470ULL, 0x000000ab6d00720cULL, 0x080fe40002781470ULL,
0x000000ab6c00720cULL, 0x080fe40002fa1470ULL, 0x000000ab7a00720cULL, 0x080fe400037c1070ULL,
0x000000ab6e00720cULL, 0x0c0fe40000701070ULL, 0x000000ab6e00720cULL, 0x0c0fe40001f61070ULL,
0x000000ab6e00720cULL, 0x000fc40000f21070ULL, 0x000000ab6a00720cULL, 0x0c0fe40001741070ULL,
0x000000ab6a00720cULL, 0x080fe40002781070ULL, 0x000000ab6800720cULL, 0x000fe40002fa1070ULL,
0x000000a398a37219ULL, 0x000fe400000006ffULL, 0x0000541066667816ULL, 0x000fe4000000006bULL,
0x00005410674c7816ULL, 0x000fc4000000004cULL, 0xff8000003d3d7808ULL, 0x000fe40003000000ULL,
0xff80000039397808ULL, 0x000fe40000000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001800000ULL,
0xff8000001b1b7808ULL, 0x000fe40000800000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fc40002000000ULL, 0xff80000015157808ULL, 0x000fe40002800000ULL,
0x00000078a2ff7212ULL, 0x040fe400078cc0ffULL, 0x00000072a2ff7212ULL, 0x040fe4000780c0ffULL,
0x00000048a1ff7212ULL, 0x040fe4000786c0ffULL, 0x00000054a1ff7212ULL, 0x080fe4000782c0ffULL,
0x00000054a2ff7212ULL, 0x000fc4000784c0ffULL, 0x00000066a3ff7212ULL, 0x040fe4000788c0ffULL,
0x0000004ca3ff7212ULL, 0x000fe400078ac0ffULL, 0x000000ab6d00720cULL, 0x0c0fe40001f61470ULL,
0x000000ab6d00720cULL, 0x080fe40000f21470ULL, 0x000000ab6c00720cULL, 0x0c0fe400037c1470ULL,
0x000000ab6c00720cULL, 0x000fc40000701470ULL, 0x000000ab6c00720cULL, 0x080fe40001741470ULL,
0x000000ab5f00720cULL, 0x0c0fe40002781470ULL, 0x000000ab5f00720cULL, 0x080fe40002fa1470ULL,
0x000000ab6a00720cULL, 0x0c0fe40001f61070ULL, 0x000000ab6a00720cULL, 0x080fe40000f21070ULL,
0x000000ab6800720cULL, 0x000fc400037c1070ULL, 0x000000ab6800720cULL, 0x0c0fe40000701070ULL,
0x000000ab6800720cULL, 0x080fe40001741070ULL, 0x000000ab5800720cULL, 0x0c0fe40002781070ULL,
0x000000ab5800720cULL, 0x000fe40002fa1070ULL, 0x000000ad98a47219ULL, 0x040fe400000006ffULL,
0x000000a598a57219ULL, 0x000fc400000006ffULL, 0x0000004d984d7219ULL, 0x000fe400000006ffULL,
0x0000541064647816ULL, 0x000fe40000000069ULL, 0xff80000014147808ULL, 0x000fe40001800000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff80000035357808ULL, 0x000fe40003000000ULL,
0xff80000037377808ULL, 0x000fc40000000000ULL, 0xff80000017177808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fe40002000000ULL, 0xff80000010107808ULL, 0x000fe40002800000ULL,
0x00000066a4ff7212ULL, 0x080fe4000786c0ffULL, 0x00000066a5ff7212ULL, 0x080fe4000782c0ffULL,
0x000000664dff7212ULL, 0x000fc400078cc0ffULL, 0x00000064a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000064a4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x00000064a5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000004ca4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000ab5f00720cULL, 0x080fe40000701470ULL,
0x000000ab5c00720cULL, 0x000fc40001f61470ULL, 0x000000ab5c00720cULL, 0x0c0fe40001741470ULL,
0x000000ab5c00720cULL, 0x080fe40002fa1470ULL, 0x000000ab5b00720cULL, 0x080fe40000f21470ULL,
0x000000ab5900720cULL, 0x080fe400037c1470ULL, 0x000000ab5b00720cULL, 0x080fe40002781470ULL,
0x000000ab5800720cULL, 0x000fc40000701070ULL, 0x000000ab5700720cULL, 0x0c0fe40001f61070ULL,
0x000000ab5700720cULL, 0x0c0fe40001741070ULL, 0x000000ab5700720cULL, 0x080fe40002fa1070ULL,
0x000000ab5600720cULL, 0x0c0fe40000f21070ULL, 0x000000ab5500720cULL, 0x080fe400037c1070ULL,
0x000000ab5600720cULL, 0x000fc40002781070ULL, 0x0000541060607816ULL, 0x000fe40000000065ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0xff80000031317808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000011117808ULL, 0x000fe40002800000ULL,
0xff8000002c2c7808ULL, 0x000fc40000800000ULL, 0xff8000002d2d7808ULL, 0x000fe40003000000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0x000000644dff7212ULL, 0x000fe4000780c0ffULL,
0x0000004ca5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004c4dff7212ULL, 0x000fe4000784c0ffULL,
0x00000060a3ff7212ULL, 0x000fc400078ac0ffULL, 0x00000060a4ff7212ULL, 0x080fe4000782c0ffULL,
0x00000060a5ff7212ULL, 0x080fe400078cc0ffULL, 0x000000604dff7212ULL, 0x000fe4000788c0ffULL,
0x000000ab5f00720cULL, 0x080fe40002fa1470ULL, 0x000000ab5c00720cULL, 0x080fe40000f21470ULL,
0x000000ab5b00720cULL, 0x000fc40001f61470ULL, 0x000000ab5b00720cULL, 0x080fe400037c1470ULL,
0x000000ab5900720cULL, 0x0c0fe40000701470ULL, 0x000000ab5900720cULL, 0x0c0fe40001741470ULL,
0x000000ab5900720cULL, 0x080fe40002781470ULL, 0x000000ab5800720cULL, 0x080fe40002fa1070ULL,
0x000000ab5700720cULL, 0x000fc40000f21070ULL, 0x000000ab5500720cULL, 0x0c0fe40000701070ULL,
0x000000ab5600720cULL, 0x0c0fe40001f61070ULL, 0x000000ab5600720cULL, 0x080fe400037c1070ULL,
0x000000ab5500720cULL, 0x0c0fe40001741070ULL, 0x000000ab5500720cULL, 0x000fe40002781070ULL,
0xff8000002f2f7808ULL, 0x000fc40000000000ULL, 0xff80000008087808ULL, 0x000fe40001800000ULL,
0xff8000000a0a7808ULL, 0x000fe40001000000ULL, 0xff80000012127808ULL, 0x000fe40002800000ULL,
0xff80000013137808ULL, 0x000fe40000800000ULL, 0xff8000000c0c7808ULL, 0x000fe40003000000ULL,
0xff8000000d0d7808ULL, 0x000fce0002000000ULL, 0x000000090400720bULL, 0x004fe20003f1e000ULL,
0x0000000176767836ULL, 0x000fe20000000000ULL, 0xfffffff8ff5a7812ULL, 0x000fe400078ee25aULL,
0x0000000409047208ULL, 0x000fc80004000000ULL, 0x000000490400720bULL, 0x000fc80003f1e000ULL,
0x00000004490f7208ULL, 0x000fc80004000000ULL, 0x000000440f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f44047208ULL, 0x000fc80004000000ULL, 0x000000450400720bULL, 0x000fc80003f1e000ULL,
0x00000004450f7208ULL, 0x000fc80004000000ULL, 0x000000400f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f40047208ULL, 0x000fc80004000000ULL, 0x000000410400720bULL, 0x000fc80003f1e000ULL,
0x00000004410f7208ULL, 0x000fc80004000000ULL, 0x0000003c0f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f3c047208ULL, 0x000fc80004000000ULL, 0x0000003d0400720bULL, 0x000fc80003f1e000ULL,
0x000000043d0f7208ULL, 0x000fc80004000000ULL, 0x000000380f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f38047208ULL, 0x000fc80004000000ULL, 0x000000390400720bULL, 0x000fc80003f1e000ULL,
0x00000004390f7208ULL, 0x000fc80004000000ULL, 0x000000340f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f34047208ULL, 0x000fc80004000000ULL, 0x000000350400720bULL, 0x000fc80003f1e000ULL,
0x00000004350f7208ULL, 0x000fc80004000000ULL, 0x000000300f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f30047208ULL, 0x000fc80004000000ULL, 0x000000310400720bULL, 0x000fc80003f1e000ULL,
0x00000004310f7208ULL, 0x000fc80004000000ULL, 0x0000002c0f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f2c047208ULL, 0x000fe40004000000ULL, 0x0000004a0500720bULL, 0x000fe40003f1e000ULL,
0x0000002d0400720bULL, 0x000fc80003f3e000ULL, 0x000000042d0f7208ULL, 0x000fe40004800000ULL,
0x000000054a047208ULL, 0x000fc60004000000ULL, 0x0c401f000f287f89ULL, 0x000ee200000e0000ULL,
0x0000004b0400720bULL, 0x000fc80003f1e000ULL, 0x000000044b057208ULL, 0x000fc80004000000ULL,
0x000000460500720bULL, 0x000fc80003f1e000ULL, 0x0000000546047208ULL, 0x000fc80004000000ULL,
0x000000470400720bULL, 0x000fc80003f1e000ULL, 0x0000000447057208ULL, 0x000fe40004000000ULL,
0x000000280f00720bULL, 0x008fe40003f3e000ULL, 0x000000420500720bULL, 0x000fe40003f1e000ULL,
0x0000000f28487208ULL, 0x000fe40004800000ULL, 0x0000000542047208ULL, 0x000fc60004000000ULL,
0x0c201f00480f7f89ULL, 0x000ee200000e0000ULL, 0x000000430400720bULL, 0x000fc80003f1e000ULL,
0x0000000443057208ULL, 0x000fc80004000000ULL, 0x0000003e0500720bULL, 0x000fc80003f1e000ULL,
0x000000053e047208ULL, 0x000fc80004000000ULL, 0x0000003f0400720bULL, 0x000fc80003f1e000ULL,
0x000000043f057208ULL, 0x000fe40004000000ULL, 0x0000000f4800720bULL, 0x008fe40003f3e000ULL,
0x0000003a0500720bULL, 0x000fe40003f1e000ULL, 0x000000480f047208ULL, 0x000fe40004800000ULL,
0x000000053a287208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b044c7820ULL, 0x000fe20000410000ULL,
0x0000003b2800720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b400f7823ULL, 0x100fe2000001084cULL,
0x000000283b057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3c4d7823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b49487823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001084cULL,
0x000000360500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b44447823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b45457823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b41417823ULL, 0x100fe2000001084cULL,
0x0000000536287208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001084cULL,
0x000000372800720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b31317823ULL, 0x000fe2000001084cULL,
0x0000000900097308ULL, 0x000fe40000000800ULL, 0x0000002837057208ULL, 0x000fc80004000000ULL,
0x000000320500720bULL, 0x000fe40003f1e000ULL, 0x0000004800487308ULL, 0x000ee40000000800ULL,
0x0000000532287208ULL, 0x000fc80004000000ULL, 0x000000332800720bULL, 0x000fe40003f1e000ULL,
0x0000004400447308ULL, 0x000fe40000000800ULL, 0x0000002833057208ULL, 0x000fc80004000000ULL,
0x0000002e0500720bULL, 0x000fe40003f1e000ULL, 0x0000000f00287308ULL, 0x000be40000000800ULL,
0x000000052e407208ULL, 0x000fc80004000000ULL, 0x0000002f4000720bULL, 0x000fe40003f1e000ULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b380f7823ULL, 0x120fe2000001084cULL,
0x000000402f3c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b39387823ULL, 0x100fe2000001084cULL,
0x0000000b0600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b35397823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b2c357823ULL, 0x000fe2000001084cULL, 0x0c401f003c497f89ULL, 0x000f6200000e0000ULL,
0x000000060b067208ULL, 0x000fe20004000000ULL, 0x0000004d00407308ULL, 0x0007e60000000800ULL,
0x000000290600720bULL, 0x000fc80003f1e000ULL, 0x0000000629057208ULL, 0x000fe20004000000ULL,
0x0000003d003d7308ULL, 0x000fe60000000800ULL, 0x000000240500720bULL, 0x000fc80003f1e000ULL,
0x0000000524067208ULL, 0x000fe20004000000ULL, 0x0000004100417308ULL, 0x000fe60000000800ULL,
0x000000250600720bULL, 0x000fe40003f1e000ULL, 0x000000493c00720bULL, 0x020fe40003f3e000ULL,
0x0000000625057208ULL, 0x000fe20004000000ULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000003c493c7208ULL, 0x000fc40004800000ULL, 0x000000200500720bULL, 0x000fc60003f1e000ULL,
0x0c201f003c4d7f89ULL, 0x00ae6200000e0000ULL, 0x0000000520067208ULL, 0x000fe20004000000ULL,
0x0000003800387308ULL, 0x000fe60000000800ULL, 0x000000210600720bULL, 0x000fc80003f1e000ULL,
0x0000000621057208ULL, 0x000fe20004000000ULL, 0x0000003400347308ULL, 0x000fe60000000800ULL,
0x0000001c0500720bULL, 0x000fc80003f1e000ULL, 0x000000051c067208ULL, 0x000fe20004000000ULL,
0x0000003900397308ULL, 0x000fe60000000800ULL, 0x0000001d0600720bULL, 0x000fe40003f1e000ULL,
0x0000004d3c00720bULL, 0x002fe40003f3e000ULL, 0x000000061d497208ULL, 0x000fe20004000000ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x0000003c4d057208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b2d3c7823ULL, 0x000fe2000001084cULL, 0x000000184900720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b054d7820ULL, 0x000fe20000410000ULL, 0x0000004918067208ULL, 0x000fe20004000000ULL,
0x0000003100317308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b4a2d7823ULL, 0x100fe2000001084dULL,
0x000000190600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b4b4a7823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b46467823ULL, 0x100fe2000001084dULL, 0x3fb8aa3b47477823ULL, 0x100fe2000001084dULL,
0x0000000619497208ULL, 0x000fe20004000000ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b42427823ULL, 0x100fe2000001084dULL, 0x3fb8aa3b43437823ULL, 0x100fe2000001084dULL,
0x000000144900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001084dULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001084dULL,
0x0000004914067208ULL, 0x000fe20004000000ULL, 0x0000004a004a7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001084dULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001084dULL,
0x000000150600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001084dULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe2000001084dULL,
0x0000000615497208ULL, 0x000fe20004000000ULL, 0x0000004600467308ULL, 0x000fe20000000800ULL,
0x0000002a0700720bULL, 0x000fc40003f1e000ULL, 0x000000104900720bULL, 0x000fe40003f3e000ULL,
0x000000072a067208ULL, 0x000fe40004000000ULL, 0x00000049102c7208ULL, 0x000fe20004800000ULL,
0x0000004700477308ULL, 0x000ee20000000800ULL, 0x0000002b0600720bULL, 0x000fe40003f1e000ULL,
0x000000112c00720bULL, 0x000fe40003f3e000ULL, 0x000000062b077208ULL, 0x000fc40004000000ULL,
0x0000002c11497208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b3a2c7823ULL, 0x100fe2000001084dULL,
0x000000260700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2e3a7823ULL, 0x000fe2000001084dULL,
0x000000084900720bULL, 0x000fe20003f3e000ULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x0000000726067208ULL, 0x000fe40004000000ULL, 0x0000004908497208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fc40003f1e000ULL, 0x0000000a4900720bULL, 0x000fe20003f3e000ULL,
0x0000004300437308ULL, 0x000f620000000800ULL, 0x0000000627077208ULL, 0x000fe40004000000ULL,
0x000000490a497208ULL, 0x000fe40004800000ULL, 0x000000220700720bULL, 0x000fc60003f1e000ULL,
0x0c401f00494c7f89ULL, 0x000e6200000e0000ULL, 0x0000000722067208ULL, 0x000fe20004000000ULL,
0x0000003e003e7308ULL, 0x000fe60000000800ULL, 0x000000230600720bULL, 0x000fc80003f1e000ULL,
0x0000000623077208ULL, 0x000fe20004000000ULL, 0x0000003f003f7308ULL, 0x000fe60000000800ULL,
0x0000001e0700720bULL, 0x000fc80003f1e000ULL, 0x000000071e067208ULL, 0x000fe20004000000ULL,
0x0000002c002c7308ULL, 0x000fe60000000800ULL, 0x0000001f0600720bULL, 0x000fe40003f1e000ULL,
0x0000004c4900720bULL, 0x002fe40003f3e000ULL, 0x000000061f077208ULL, 0x000fe20004000000ULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x000000494c497208ULL, 0x000fc40004800000ULL,
0x0000001a0700720bULL, 0x000fc60003f1e000ULL, 0x0c201f00494c7f89ULL, 0x000e6200000e0000ULL,
0x000000071a067208ULL, 0x000fe20004000000ULL, 0x0000003600367308ULL, 0x000fe60000000800ULL,
0x0000001b0600720bULL, 0x000fc80003f1e000ULL, 0x000000061b077208ULL, 0x000fe20004000000ULL,
0x0000003700377308ULL, 0x000fe60000000800ULL, 0x000000160700720bULL, 0x000fc80003f1e000ULL,
0x0000000716067208ULL, 0x000fe20004000000ULL, 0x0000003200327308ULL, 0x000fe60000000800ULL,
0x000000170600720bULL, 0x000fe40003f1e000ULL, 0x0000004c4900720bULL, 0x002fe40003f3e000ULL,
0x0000000617077208ULL, 0x000fe20004000000ULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x000000494c067208ULL, 0x000fc40004800000ULL, 0x000000120700720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b06557820ULL, 0x000fe20000410000ULL, 0x00000007122e7208ULL, 0x000fe20004000000ULL,
0x0000003500357308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b184b7823ULL, 0x100fe20000010855ULL,
0x000000132e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010855ULL,
0x0000002e13077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b10497823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b194e7823ULL, 0x100fe20000010855ULL,
0x0000000c0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b114c7823ULL, 0x100fe20000010855ULL,
0x0000000b00577308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010855ULL,
0x000000070c2e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b084f7823ULL, 0x100fe20000010855ULL, 0x000000094808723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b144d7823ULL, 0x100fe20000010855ULL, 0x0000000d2e00720bULL, 0x000fe20003f1e000ULL,
0x0000002900587308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b15547823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b0a567823ULL, 0x100fe20000010855ULL, 0x0000002e0d2e7208ULL, 0x000fe20004000000ULL,
0x3c003c00ff147424ULL, 0x000fe200078e00ffULL, 0x0000002d4a09723eULL, 0x000fe200000000ffULL,
0x3c003c00ff157424ULL, 0x000fe200078e00ffULL, 0x00000044450a723eULL, 0x000fe200000000ffULL,
0x0c401f002e077f89ULL, 0x000e6200000e0000ULL, 0x0000002400597308ULL, 0x000fe20000000800ULL,
0x00000046470b723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b21217823ULL, 0x000fe20000010855ULL, 0x00000003ff477819ULL, 0x000fe20000011650ULL,
0x000000185a457836ULL, 0x000fc60000000000ULL, 0x00000025005c7308ULL, 0x000ff00000000800ULL,
0x0000001c00297308ULL, 0x0007e20000000800ULL, 0x000000072e00720bULL, 0x002fce0003f1e000ULL,
0x0000001d00607308ULL, 0x000be20000000800ULL, 0x00000028411c723eULL, 0x008fe200000000ffULL,
0x000000085a417836ULL, 0x000fe20000000000ULL, 0x0000002e07077208ULL, 0x000fca0004000000ULL,
0x0c201f0007187f89ULL, 0x000e6200000e0000ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000042431d723eULL, 0x020fe200000000ffULL, 0x000000105a437836ULL, 0x000fcc0000000000ULL,
0x0000002100217308ULL, 0x000ef00000000800ULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x000000180700720bULL, 0x002fce0003f1e000ULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x000000202120723eULL, 0x008fe400000000ffULL, 0x0000000718077208ULL, 0x000fe40004000000ULL,
0x000000575818723eULL, 0x000fe200000000ffULL, 0x0000000845577824ULL, 0x000fe200078e00ffULL,
0x0000000350ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b072e7820ULL, 0x000fe20000410000ULL,
0x0000004d004d7308ULL, 0x000fe60000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082eULL,
0x0000002b00107308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1b2d7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe2000001082eULL,
0x0000002a00197308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b1f2b7823ULL, 0x002fe2000001082eULL,
0x0000003e3f1f723eULL, 0x000fe200000000ffULL, 0x00000008413f7824ULL, 0x000fca00078e00ffULL,
0x0000002600117308ULL, 0x000fe20000000800ULL, 0x000000191019723eULL, 0x008fce00000000ffULL,
0x0000002700647308ULL, 0x0002e20000000800ULL, 0x0000000450107810ULL, 0x000fc80007ffe047ULL,
0x0000000710107812ULL, 0x000fc600078ec0ffULL, 0x0000001e002a7308ULL, 0x000be20000000800ULL,
0x000000140824723cULL, 0x002fe200000018ffULL, 0xfffffff83f427812ULL, 0x000fe400078ee210ULL,
0xfffffff857467812ULL, 0x000fe400078ee210ULL, 0x00000011641b723eULL, 0x008fe400000000ffULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x000000403d1e723eULL, 0x020fe200000000ffULL,
0x000000085a117824ULL, 0x000fca00078e00ffULL, 0xfffffff811407812ULL, 0x000fe200078ee210ULL,
0x0000002300667308ULL, 0x0003e20000000800ULL, 0x0000002c3b11723eULL, 0x000fe400000000ffULL,
0x00000030312c723eULL, 0x000fe400000000ffULL, 0x0000004b4e30723eULL, 0x000fc600000000ffULL,
0x0000002200557308ULL, 0x0007620000000800ULL, 0x3fb8aa3b1a237823ULL, 0x002fe2000001082eULL,
0x000000595c1a723eULL, 0x000fe200000000ffULL, 0x000000141c24723cULL, 0x000fea0000001824ULL,
0x00000023003d7308ULL, 0x0003e20000000800ULL, 0x000000296022723eULL, 0x008fe400000000ffULL,
0x000000556621723eULL, 0x020fca00000000ffULL, 0x0000005400547308ULL, 0x000fe20000000800ULL,
0x0000002a2b23723eULL, 0x002fe200000000ffULL, 0x0000000843557824ULL, 0x000fe200078e00ffULL,
0x000000141828723cULL, 0x000fe800000018ffULL, 0xfffffff855447812ULL, 0x000fe200078ee210ULL,
0x0000002d003e7308ULL, 0x0002e20000000800ULL, 0x0000000f3810723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b130f7823ULL, 0x000fe2000001082eULL, 0x000000363713723eULL, 0x000fe200000000ffULL,
0x0000000841387824ULL, 0x000fc400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e001cULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b122d7823ULL, 0x002fe2000001082eULL,
0x000000343912723eULL, 0x000fe200000000ffULL, 0x000000ffff377224ULL, 0x000fe400078e001eULL,
0x000000ffff1c7224ULL, 0x000fe200078e0018ULL, 0x0000003d3e31723eULL, 0x008fe400000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000141024723cULL, 0x000fe20000001824ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0020ULL, 0x000000ffff187224ULL, 0x000fe400078e0019ULL,
0x000000ffff197224ULL, 0x000fe200078e001bULL, 0x000000142028723cULL, 0x000fe20000001828ULL,
0x0000002d003f7308ULL, 0x0007ea0000000800ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0023ULL,
0x000000ffff207224ULL, 0x000fe200078e0031ULL, 0x0000003c003c7308ULL, 0x000f620000000800ULL,
0x00000032332d723eULL, 0x008fc400000000ffULL, 0x0000004d5432723eULL, 0x000fe400000000ffULL,
0x000000161733723eULL, 0x002fe200000000ffULL, 0x000000085a167824ULL, 0x000fe200078e00ffULL,
0x0000000963177c11ULL, 0x000fe2000f8e60ffULL, 0x0000003a003a7308ULL, 0x000fe80000000800ULL,
0x0001200017177836ULL, 0x000fc60000000000ULL, 0x000000143028723cULL, 0x000fe20000001828ULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x000000353c2e723eULL, 0x020fe200000000ffULL,
0x00000008453c7824ULL, 0x000fe400078e00ffULL, 0x0000001040407824ULL, 0x100fe400078e0217ULL,
0x0000001042427824ULL, 0x100fe400078e0217ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x0000001044447824ULL, 0x000fc400078e0217ULL, 0x000000ffff357224ULL, 0x000fe400078e000aULL,
0x0000001046467824ULL, 0x000fe200078e0217ULL, 0x0000003a2f2f723eULL, 0x002fe400000000ffULL,
0x0000005600567308ULL, 0x000e620000000800ULL, 0x00000008433a7824ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fe400078e001dULL, 0x000000ffff1d7224ULL, 0x000fe200078e001aULL,
0x000000142c24723cULL, 0x000fe20000001824ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0021ULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x000000ffff217224ULL, 0x000fe200078e0033ULL,
0x0000004f564e723eULL, 0x002fcc00000000ffULL, 0x0000004c004c7308ULL, 0x000e700000000800ULL,
0x0000000f00347308ULL, 0x00076c0000000800ULL, 0x000000ffff257224ULL, 0x000fe200078e0026ULL,
0x000000494c4c723eULL, 0x002fe200000000ffULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x00000003470f7812ULL, 0x008fca00078ec0ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0250ULL,
0x0000003f344d723eULL, 0x020fe200000000ffULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x000000ffff347224ULL, 0x000fe400078e0008ULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fe400078e0009ULL, 0x000000ffff097224ULL, 0x000fe200078e000bULL,
0xfffffff816167812ULL, 0x000fe200078ee20fULL, 0x000000ffff0b7224ULL, 0x000fe200078e001fULL,
0xfffffff838387812ULL, 0x000fe200078ee20fULL, 0x000000ffff1f7224ULL, 0x000fe200078e0022ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL, 0x000000ffff227224ULL, 0x000fe200078e004dULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL, 0x0000001038387824ULL, 0x100fe200078e0217ULL,
0x0000000c0d4f723eULL, 0x002fe200000000ffULL, 0x00000010160c7824ULL, 0x000fc400078e0217ULL,
0x000000103a3a7824ULL, 0x100fe400078e0217ULL, 0x000000103c3c7824ULL, 0x000fe200078e0217ULL,
0x000000340c007844ULL, 0x000fe20000000200ULL, 0x000000144c28723cULL, 0x000fe20000001828ULL,
0x000000ffff167224ULL, 0x000fe400078e002cULL, 0x000000ffff177224ULL, 0x000fe400078e002eULL,
0x000000ffff2c7224ULL, 0x000fe400078e0030ULL, 0x000000ffff147224ULL, 0x000fc400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff117224ULL, 0x000fe200078e0013ULL, 0x0000001440007844ULL, 0x000fe20000000200ULL,
0x000000ffff127224ULL, 0x000fe400078e002dULL, 0x000000ffff137224ULL, 0x000fe200078e002fULL,
0x0000000838007844ULL, 0x0003e20000000200ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0032ULL,
0x000000ffff2e7224ULL, 0x000fe200078e004cULL, 0x0000001042007844ULL, 0x0007e20000000200ULL,
0x000000ffff2f7224ULL, 0x000fe400078e004eULL, 0x000000ffff237224ULL, 0x000fe200078e004fULL,
0x0000001c3a007844ULL, 0x0007e20000000200ULL, 0x000000ffff267224ULL, 0x000fe400078e0028ULL,
0x000000ffff277224ULL, 0x000fe200078e002aULL, 0x0000002c44007844ULL, 0x0007e80000000200ULL,
0x000000183c007844ULL, 0x0007e20000000200ULL, 0x00000001ff087424ULL, 0x002fc600078e00ffULL,
0x0000002046007844ULL, 0x0007e80000000200ULL, 0x01a000040e008388ULL, 0x0007e80000000c00ULL,
0x01a200240e008388ULL, 0x0007e20000000c00ULL, 0x000000617600720cULL, 0x000fe20003f06070ULL,
0x01a6080873ff79a7ULL, 0x000fe2000850003fULL, 0x01a6100873ff79a7ULL, 0x000fe2000850003fULL,
0x01a6180873ff79a7ULL, 0x000fe2000850003fULL, 0x01a6200873ff79a7ULL, 0x0003e4000850003fULL,
0x000000ffff087224ULL, 0x002fce00078e0053ULL, 0xffffff9000d48947ULL, 0x00cfea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000082007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008200008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff82ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000082027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe9402347950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004e3ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000660ULL, 0x0000000000000228ULL, 0x0000001500000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000888ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000968ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009bcULL, 0x0000000000000700ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001108ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016c00ULL, 0x0000001500000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017d80ULL, 0x0000000000000040ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017dc0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000017dc0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000183b0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000183b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000001108ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000016c00ULL,
0x0000000000016c00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017d80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000017dc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_90_cubin_len = 99584;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
