/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015dd0ULL, 0x0000000000015a50ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL, 0x497461324545386aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x386a4c4536316a4cULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x632e766e2e006675ULL,
0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL, 0x756265642e006d61ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL, 0x000000000000006eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b0ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003feULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000443ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b002200000489ULL, 0x0000000000013ef0ULL, 0x0000000000000180ULL,
0x000b0022000004bcULL, 0x0000000000014070ULL, 0x0000000000000040ULL, 0x000b0022000004e7ULL,
0x00000000000140b0ULL, 0x0000000000000050ULL, 0x000b002200000511ULL, 0x0000000000014100ULL,
0x0000000000000100ULL, 0x000a00030000057fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000059fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005cfULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000014200ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00013ef000000000ULL, 0x0000040400000000ULL,
0x810c000001340400ULL, 0x004e780400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8a08288080820828ULL, 0x2880809008288080ULL, 0x8096082880809408ULL,
0x0828808097082880ULL, 0x80809c0828808098ULL, 0x9e082880809d0828ULL, 0x2880808408288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808084ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x00013ef000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808a08288080ULL, 0x8094082880809008ULL,
0x0828808096082880ULL, 0x80809c0828808098ULL, 0x9e082880809d0828ULL, 0x288080b608288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b6ULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x0001407000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808a08288080ULL,
0x8094082880809008ULL, 0x0828808096082880ULL, 0x8080980828808097ULL, 0x9d082880809c0828ULL,
0x2880809e08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880809eULL,
0x0000002cffffffffULL, 0x000001d800000000ULL, 0x000140b000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x80902880809e0900ULL, 0x0000000000002880ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808a08288080ULL, 0x8094082880809008ULL,
0x0828808096082880ULL, 0x80809c0828808098ULL, 0x9d082880809e0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880809d920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000029000000000ULL, 0x0001410000000000ULL, 0x0000010000000000ULL, 0x0000180400000000ULL,
0x80902880809d0900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x000823040000008eULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0050016000000017ULL, 0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000002000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f001342804ULL, 0x0000040000000110ULL, 0x0000242000002390ULL, 0x000026a000002530ULL,
0x00002b4000002b10ULL, 0x00002c2000002bb0ULL, 0x00004f0000004e60ULL, 0x0000519000005030ULL,
0x0000563000005600ULL, 0x00005710000056a0ULL, 0x000076d000007630ULL, 0x0000796000007800ULL,
0x00007e0000007dd0ULL, 0x00007ee000007e70ULL, 0x00009f1000009e70ULL, 0x0000a1900000a030ULL,
0x0000a6200000a5f0ULL, 0x0000a7000000a690ULL, 0x0000b7e00000b7d0ULL, 0x000123c000012380ULL,
0x000123e0000123d0ULL, 0x0001245000012430ULL, 0x0001248000012470ULL, 0x00013140000130e0ULL,
0x00013220000131b0ULL, 0x00013320000132a0ULL, 0x000133e000013380ULL, 0x000134c000013450ULL,
0x000135b000013540ULL, 0x0001367000013610ULL, 0x00013750000136e0ULL, 0x00013840000137d0ULL,
0x00013900000138a0ULL, 0x000139e000013970ULL, 0x00013ad000013a60ULL, 0x00013bc000013b40ULL,
0x00013cc000013c40ULL, 0x00013dc000013d40ULL, 0x00013ec000013e40ULL, 0x000001f004403904ULL,
0x00017600000000ffULL, 0x00000290003f0100ULL, 0x000176080000000fULL, 0x00000370003f0120ULL,
0x000176880000000fULL, 0x000003a0003f0120ULL, 0x000176a80000000fULL, 0x000003d0003f0120ULL,
0x000176c80000000fULL, 0x00000460003f0120ULL, 0x00017600000000ffULL, 0x00000600003f0107ULL,
0x0000000400000006ULL, 0x000006b0003f0102ULL, 0x0000000000000006ULL, 0x000010a0003f0101ULL,
0x00000000000000ffULL, 0x0000112000040107ULL, 0x00000000000000ffULL, 0x0000118000040101ULL,
0x0000002000000014ULL, 0x00001330003f0101ULL, 0x000176cc00000012ULL, 0x00001510003f0105ULL,
0x000176cc00000012ULL, 0x00001ec0003f0105ULL, 0x000176a800000045ULL, 0x00002040003f0107ULL,
0x000176a800000045ULL, 0x000020a0003f0101ULL, 0x000176080000004aULL, 0x000020c0003f0101ULL,
0x0001760c0000004aULL, 0x00002290003f0105ULL, 0x0001760c0000004aULL, 0x00002870003f0105ULL,
0x000176ac00000016ULL, 0x00002a40003f0105ULL, 0x000176ac00000016ULL, 0x00003d60003f0105ULL,
0x000176c800000014ULL, 0x00003de0003f0101ULL, 0x0001768800000046ULL, 0x00003e60003f0101ULL,
0x000000040000004bULL, 0x00004030003f0105ULL, 0x000000040000004bULL, 0x00004a30003f0105ULL,
0x000176a800000054ULL, 0x00004b60003f0107ULL, 0x000176a800000054ULL, 0x00004bc0003f0101ULL,
0x000176280000004aULL, 0x00004be0003f0101ULL, 0x0001762c0000004aULL, 0x00004db0003f0105ULL,
0x0001762c0000004aULL, 0x00005360003f0105ULL, 0x000176ac00000045ULL, 0x00005530003f0105ULL,
0x000176ac00000045ULL, 0x00006630003f0105ULL, 0x0000000000000014ULL, 0x000066a0003f0101ULL,
0x0001769000000046ULL, 0x00006700003f0101ULL, 0x000000040000004bULL, 0x000068d0003f0105ULL,
0x000000040000004bULL, 0x000071d0003f0105ULL, 0x0000000000000055ULL, 0x00007330003f0107ULL,
0x000176a800000045ULL, 0x00007390003f0101ULL, 0x000176480000004aULL, 0x000073b0003f0101ULL,
0x0001764c0000004aULL, 0x00007580003f0105ULL, 0x0001764c0000004aULL, 0x00007b30003f0105ULL,
0x000176ac00000054ULL, 0x00007d00003f0105ULL, 0x000176ac00000054ULL, 0x00008e50003f0105ULL,
0x0000000000000014ULL, 0x00008ec0003f0101ULL, 0x0001769800000046ULL, 0x00008f40003f0101ULL,
0x000000040000004bULL, 0x00009110003f0105ULL, 0x000000040000004bULL, 0x00009a10003f0105ULL,
0x0000000000000053ULL, 0x00009b70003f0107ULL, 0x000176a800000054ULL, 0x00009bd0003f0101ULL,
0x000176680000004aULL, 0x00009bf0003f0101ULL, 0x0001766c0000004aULL, 0x00009dc0003f0105ULL,
0x0001766c0000004aULL, 0x0000a350003f0105ULL, 0x000176ac00000045ULL, 0x0000a520003f0105ULL,
0x000176ac00000045ULL, 0x0000b590003f0105ULL, 0x0000000000000014ULL, 0x0000b5f0003f0101ULL,
0x000176a000000046ULL, 0x0000c3a0003f0101ULL, 0x00017600000000ffULL, 0x0000e070003f0101ULL,
0x00017604000000ffULL, 0x0000e240003f0105ULL, 0x00017604000000ffULL, 0x0000e470003f0105ULL,
0x00017600000000ffULL, 0x0000e4a0003f0101ULL, 0x00017604000000ffULL, 0x0000e660003f0105ULL,
0x00017604000000ffULL, 0x00011870003f0105ULL, 0x0000000000000008ULL, 0x000118d0003f0101ULL,
0x0000000400000008ULL, 0x00011aa0003f0105ULL, 0x0000000400000008ULL, 0x00012f20003f0105ULL,
0x000000000000000bULL, 0x00012f80003f0101ULL, 0x000000080000000bULL, 0x00012fe0003f0101ULL,
0x000000100000000bULL, 0x00013050003f0101ULL, 0x000000180000000bULL, 0x00053803003f0101ULL,
0x0000c04000141c04ULL, 0x0000e6c00000c2c0ULL, 0x000130a00000e780ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000324ULL, 0x0000001a00000002ULL, 0x000000000000026cULL,
0x0000001a00000002ULL, 0x00000000000001c4ULL, 0x0000001a00000002ULL, 0x0000000000000104ULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x00000000000002faULL,
0x0000001a00000002ULL, 0x0000000000000247ULL, 0x0000001a00000002ULL, 0x000000000000019fULL,
0x0000001a00000002ULL, 0x00000000000000dfULL, 0x0000001a00000002ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff147624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001200057300ULL, 0x000ee200000e0000ULL, 0x0000000814087824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000f280000002200ULL, 0x0000000000067919ULL, 0x000ee20000000000ULL,
0x0000001200127309ULL, 0x000ea60000000000ULL, 0x0000000000157919ULL, 0x000ee80000002600ULL,
0x0000000000047919ULL, 0x000ee20000002700ULL, 0x00000005ff3d7819ULL, 0x002fc6000001160fULL,
0x00000000000d7919ULL, 0x000e680000000000ULL, 0x00001fff03007589ULL, 0x0045e200000e0000ULL,
0x0000010003027a24ULL, 0x010fc600078e0202ULL, 0x00001fff3d3d7589ULL, 0x000f2200000e0000ULL,
0x00000000020f7a24ULL, 0x000fe200078e020fULL, 0x000000060500720cULL, 0x008fe20003f02070ULL,
0x0000000815057824ULL, 0x000fc600078e00ffULL, 0x000000ff0f00720cULL, 0x040fe40003f45270ULL,
0x0000007f0f00780cULL, 0x040fe20003f84070ULL, 0x00000004080a7224ULL, 0x000fe200078e0205ULL,
0x0000000f0f00780cULL, 0x040fe40003f64070ULL, 0x000000030f00780cULL, 0x000fe40003f24070ULL,
0x00000004ff0e7819ULL, 0x002fca000001160dULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x004fe400078e00ffULL, 0x0000000400097824ULL, 0x010fe400078e023dULL,
0xff317217ff10c424ULL, 0x000fe200078e00ffULL, 0x01760002ff00a388ULL, 0x0003e20000000a00ULL,
0x0000000209057824ULL, 0x000fe200078e00ffULL, 0x000000010f00780cULL, 0x000fe20003f44070ULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x017400100f00c388ULL, 0x0005e20000004800ULL,
0x00000001050b7824ULL, 0x040fe200078e020eULL, 0x00000008050c7817ULL, 0x000fe20007800000ULL,
0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL, 0x000000100b137824ULL, 0x000fe400078e00ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a05ULL, 0x017608060f00b388ULL, 0x0007e20000008a00ULL,
0x000000100d057824ULL, 0x000fe400078e00ffULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x0000000c0e00720cULL, 0x000fe20003f66070ULL, 0x000000010a027824ULL, 0x000fe200078e020bULL,
0x000000f005117812ULL, 0x000fe200078ec0ffULL, 0x000000010b107824ULL, 0x004fc400078e020dULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0xfffffff013107812ULL, 0x000fe200078ee210ULL,
0x3fffff60ff089424ULL, 0x000fe200078e00ffULL, 0x0000001102027210ULL, 0x000fe20007f9e0ffULL,
0x7fffff60ff099424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff069424ULL, 0x008fe400078e00ffULL,
0x7fffff80ff079424ULL, 0x000fe200078e00ffULL, 0x017688080f009388ULL, 0x0003e20000008a00ULL,
0x3fffffc0ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x0176a8060f009388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fc400020e0603ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0176c80a0f00a388ULL, 0x000fe60000008a00ULL,
0x00006200043e7625ULL, 0x000fc800078e0011ULL, 0x0000001010097824ULL, 0x002fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff087224ULL, 0x000fe200078e0a12ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01760408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000063e3e7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fc40003f05270ULL,
0x0000003f3e3c7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff3e007810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff3c7819ULL, 0x000fe4000001163cULL, 0x00000008ff0f7819ULL, 0x000fca0000011600ULL,
0x0000bd8000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe2000001163dULL,
0x00000003ff097424ULL, 0x002fe200078e00ffULL, 0x000176883d067811ULL, 0x000fe200078e18ffULL,
0xffffffffff077424ULL, 0x000fe200078e00ffULL, 0x03ffffff0c417812ULL, 0x000fc800078ec0ffULL,
0x0000003c4100720cULL, 0x000fda0003f06070ULL, 0x0000000204028824ULL, 0x000fe400078e00ffULL,
0x00006400ff038624ULL, 0x000fc800078e00ffULL, 0x0000640002028624ULL, 0x000fc800078e0203ULL,
0x0000000141028824ULL, 0x000fe200078e0202ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040906ff738cULL, 0x0003e20000000000ULL, 0x0000600002028625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000602078981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x00000040150a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe2000001163dULL, 0x0000000006ff7f8cULL, 0x0007e2000c80043fULL,
0x000000013d007812ULL, 0x000fc600078ec0ffULL, 0x000000200e0b7824ULL, 0x000fe400078e00ffULL,
0x0000580007087a24ULL, 0x004fc600078e02ffULL, 0x000000200a077812ULL, 0x000fe200078ef80bULL,
0x0000004008157824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000001000037824ULL, 0x008fe200078e00ffULL, 0x0000000b3e007217ULL, 0x000fe40007800000ULL,
0x00000003ff027819ULL, 0x000fe4000001160dULL, 0x00000070051b7812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x0000000402097810ULL, 0x042fe20007ffe0ffULL,
0x0000000103067824ULL, 0x000fe200078e0202ULL, 0x0000000802107810ULL, 0x000fc40007ffe0ffULL,
0x0000000300007217ULL, 0x000fe20007800000ULL, 0x0000000106087824ULL, 0x000fe200078e020dULL,
0x0000000c02127810ULL, 0x000fe20007ffe0ffULL, 0x0000000806137824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fe400078e0a03ULL, 0x0000000107067824ULL, 0x000fe200078e0206ULL,
0xfffffff813087812ULL, 0x000fe200078ee208ULL, 0x0000000103147824ULL, 0x040fe200078e0212ULL,
0x000000000200720cULL, 0x080fe20003f66070ULL, 0x0000000103027824ULL, 0x000fe200078e0209ULL,
0x000000000900720cULL, 0x000fc40003f46070ULL, 0x0000000615097210ULL, 0x000fe20007f1e0ffULL,
0x0000000102067824ULL, 0x100fe200078e020dULL, 0x000000001000720cULL, 0x080fe20003f26070ULL,
0x0000000103107824ULL, 0x000fe200078e0210ULL, 0x00005e00091a7a11ULL, 0x000fe200078838ffULL,
0x0000000802137824ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x000000001200720cULL, 0x000fe20003f06070ULL, 0x0000000107027824ULL, 0x000fe200078e0202ULL,
0xfffffff813067812ULL, 0x000fe200078ee206ULL, 0x0000000107007824ULL, 0x000fe200078e0210ULL,
0x00005f0009127a11ULL, 0x000fe200020f3c16ULL, 0x0000000110037824ULL, 0x040fe200078e020dULL,
0x0000000215187210ULL, 0x000fe20007f9e0ffULL, 0x0000000107077824ULL, 0x000fe200078e0214ULL,
0x0000000015137210ULL, 0x000fe20007fbe0ffULL, 0x0000000810107824ULL, 0x000fc400078e00ffULL,
0x0000000114027824ULL, 0x040fe200078e020dULL, 0x0000000715097210ULL, 0x000fe20007fde0ffULL,
0x0000000814157824ULL, 0x000fe200078e00ffULL, 0xfffffff810007812ULL, 0x000fe200078ee203ULL,
0x000000ffff037224ULL, 0x000fe200020e06ffULL, 0x00005e0018167a11ULL, 0x040fe200078838ffULL,
0x000000ffff147224ULL, 0x000fe200028e06ffULL, 0xfffffff815107812ULL, 0x000fe400078ee202ULL,
0x00005f0018187a11ULL, 0x000fe400020f3c03ULL, 0x000130000e077811ULL, 0x000fc400078e68ffULL,
0x0000001a1b027210ULL, 0x000fc60007f9e0ffULL, 0x0000001008057824ULL, 0x100fe200078e0207ULL,
0x00005e0013087a11ULL, 0x000fe200078a38ffULL, 0x0000001006157824ULL, 0x100fe400078e0207ULL,
0x000000ffff037224ULL, 0x000fe200020e0612ULL, 0x0000001b16067210ULL, 0x080fe20007f9e0ffULL,
0x0000001000177824ULL, 0x100fe400078e0207ULL, 0x000000ffff007224ULL, 0x000fe200030e06ffULL,
0x00005e0009127a11ULL, 0x000fe200078c38ffULL, 0x0000001010197824ULL, 0x000fe200078e0207ULL,
0x00005f0013107a11ULL, 0x000fe200028f3c14ULL, 0x000000ffff077224ULL, 0x000fe200020e0618ULL,
0x0000001b08087210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000d901c46ULL, 0x00005f0009007a11ULL, 0x000fc400030f3c00ULL,
0x0000001b12127210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e0610ULL,
0x0000000006157faeULL, 0x0003e6000d101c46ULL, 0x000000ffff137224ULL, 0x000fe200020e0600ULL,
0x0000000008177faeULL, 0x0003e8000c901c46ULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x000130000e1b7811ULL, 0x000fc400078e68ffULL, 0x00000070051d7812ULL, 0x000fe400078ec0ffULL,
0x000000000d007211ULL, 0x000fc800078fe8ffULL, 0x0000000400067810ULL, 0x042fe20007ffe0ffULL,
0x0000000100027824ULL, 0x140fe200078e020dULL, 0x0000000800087810ULL, 0x040fe20007ffe0ffULL,
0x0000000800097824ULL, 0x000fe400078e00ffULL, 0x0000000106037824ULL, 0x040fe400078e020dULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0xfffffff809027812ULL, 0x000fe200078ee202ULL,
0x0000000107067824ULL, 0x040fe400078e0206ULL, 0x0000000107097824ULL, 0x040fe200078e0208ULL,
0xfffffff810037812ULL, 0x000fe200078ee203ULL, 0x0000000808177824ULL, 0x000fe200078e00ffULL,
0x0000000c00107810ULL, 0x000fe20007ffe0ffULL, 0x0000000107007824ULL, 0x000fe200078e0200ULL,
0x0000000615137210ULL, 0x000fc40007f5e0ffULL, 0x0000000915097210ULL, 0x000fe20007f7e0ffULL,
0x0000000107077824ULL, 0x000fe200078e0210ULL, 0x0000000015147210ULL, 0x040fe20007f3e0ffULL,
0x0000000108007824ULL, 0x100fe400078e020dULL, 0x0000000110067824ULL, 0x000fe200078e020dULL,
0x0000000715077210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x00005e0014127a11ULL, 0x000fe200078238ffULL, 0x0000000810197824ULL, 0x000fe200078e00ffULL,
0xfffffff817007812ULL, 0x000fe200078ee200ULL, 0x0000001003177824ULL, 0x000fe200078e021bULL,
0x00005f0014147a11ULL, 0x000fe200008f3c15ULL, 0x0000001002157824ULL, 0x100fe200078e021bULL,
0xfffffff819067812ULL, 0x000fe200078ee206ULL, 0x000000ffff027224ULL, 0x000fe200010e06ffULL,
0x00005e0013107a11ULL, 0x000fe200078238ffULL, 0x0000001000197824ULL, 0x100fe200078e021bULL,
0x00005e0009087a11ULL, 0x000fe200078438ffULL, 0x00000010061b7824ULL, 0x000fe200078e021bULL,
0x00005f0013137a11ULL, 0x000fe200008f3c02ULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x000000121d027210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005e0007127a11ULL, 0x000fc400078638ffULL, 0x00005f0009057a11ULL, 0x000fe200010f3c06ULL,
0x000000ffff037224ULL, 0x000fe200008e0614ULL, 0x000000101d067210ULL, 0x040fe40007f1e0ffULL,
0x000000081d087210ULL, 0x000fe40007f3e0ffULL, 0x00005f0007007a11ULL, 0x000fe200018f3c00ULL,
0x000000ffff077224ULL, 0x000fe200000e0613ULL, 0x000000121d127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e6000b901c46ULL, 0x000000ffff137224ULL, 0x000fe200010e0600ULL,
0x0000000006177faeULL, 0x0003e8000b901c46ULL, 0x0000000008197faeULL, 0x0003e8000b901c46ULL,
0x00000000121b7faeULL, 0x0003e4000b901c46ULL, 0x0000000141417810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff097424ULL, 0x002fc600078e00ffULL, 0x0000003c4100720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x0000000204007824ULL, 0x000fe400078e00ffULL,
0x00006400ff037624ULL, 0x000fc800078e00ffULL, 0x0000640000007624ULL, 0x000fc800078e0203ULL,
0x0000000100027824ULL, 0x000fc800078e0241ULL, 0x0000600002027625ULL, 0x000fca00078e0011ULL,
0x0000000602097981ULL, 0x000324000c1e1900ULL, 0x000000000e0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000176a80e147811ULL, 0x000fe200078e18ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x000176a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff587f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200014147f8cULL, 0x000ee2000c80043fULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000a43000008947ULL, 0x000fea0003800000ULL, 0x0000000204087824ULL, 0x000fe400078e00ffULL,
0x00006400ff037624ULL, 0x002fc400078e00ffULL, 0xff317217ff587424ULL, 0x004fe400078e00ffULL,
0x0000640008087624ULL, 0x000fe400078e0203ULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x0000010006057824ULL, 0x000fca00078e00ffULL, 0x0000003e0500720cULL, 0x000fda0003f06070ULL,
0x0000a35000000947ULL, 0x00afea0003800000ULL, 0x000000ffff057224ULL, 0x000fe400078e0041ULL,
0x000000ffff047224ULL, 0x000fc400078e0013ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x000000043d127824ULL, 0x000fca00078e00ffULL, 0xfffffff812127812ULL, 0x000fc800078ec0ffULL,
0x000176c8124b7810ULL, 0x000fe20007ffe0ffULL, 0x0176cc0012147984ULL, 0x008e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x00000016101d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e11ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000001d14147211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176cc0012147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000103d107824ULL, 0x000fe200078e00ffULL,
0x0000000106127810ULL, 0x000fe20007ffe0ffULL, 0x0000580009097a24ULL, 0x010fe200078e02ffULL,
0x0000000113477812ULL, 0x000fe400078e0cffULL, 0x0000000f1200720cULL, 0x000fe20003f06070ULL,
0x0000004009407824ULL, 0x000fe200078e00ffULL, 0xffffffe010117812ULL, 0x000fca00078ec0ffULL,
0x0000010006117824ULL, 0x000fca00078e0211ULL, 0x0000004011117810ULL, 0x000fc80007ffe0ffULL,
0x000000200a437812ULL, 0x000fe200078ef811ULL, 0x0000049000008947ULL, 0x000fea0003800000ULL,
0x0000001010127812ULL, 0x000fe200078ec0ffULL, 0x000000020e177824ULL, 0x000fe200078e0247ULL,
0x00000003ff1e7819ULL, 0x000fc8000001160dULL, 0x000000041e447810ULL, 0x040fe20007ffe0ffULL,
0x000000011e107824ULL, 0x040fe200078e0212ULL, 0x0001300017177811ULL, 0x000fe400078e60ffULL,
0x0000000c1e457810ULL, 0x000fe20007ffe0ffULL, 0x0000000143097824ULL, 0x000fe400078e0210ULL,
0x0000000144167824ULL, 0x000fe400078e0212ULL, 0x00000008101c7824ULL, 0x000fe200078e00ffULL,
0x00000009401d7210ULL, 0x000fc40007f1e0ffULL, 0x000000113e097217ULL, 0x000fc60007800000ULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00005e001d157a11ULL, 0x000fe200078038ffULL,
0x0000000109097824ULL, 0x000fe400078e0a11ULL, 0x000000100d117824ULL, 0x000fe200078e00ffULL,
0x00005f001d1d7a11ULL, 0x000fe200000f3c14ULL, 0x0000000143147824ULL, 0x000fe200078e0216ULL,
0x0000001209097217ULL, 0x000fe40007800000ULL, 0x0000007011427812ULL, 0x000fe200078ec0ffULL,
0x0000000110117824ULL, 0x100fe200078e020dULL, 0x00000014403f7210ULL, 0x000fe20007fde0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a12ULL, 0x0000004215107210ULL, 0x000fe20007fbe0ffULL,
0x0000000116157824ULL, 0x000fe200078e020dULL, 0xfffffff81c147812ULL, 0x000fe200078ee211ULL,
0x000000ffff1c7224ULL, 0x000fe200030e06ffULL, 0x000000091e00720cULL, 0x080fe20003f06070ULL,
0x000000ffff117224ULL, 0x000fe200028e061dULL, 0x000000094400720cULL, 0x000fe20003fa6070ULL,
0x00000010141d7824ULL, 0x000fe200078e0217ULL, 0x00005e003f1f7a11ULL, 0x000fe200078c38ffULL,
0x0000000816167824ULL, 0x000fe200078e00ffULL, 0x000000081e447810ULL, 0x000fc40007ffe0ffULL,
0x00005f003f3f7a11ULL, 0x000fe400030f3c1cULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x00000001441c7824ULL, 0x000fe400078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0x000000421f147210ULL, 0x000fe20007f1e0ffULL,
0x00000001431e7824ULL, 0x000fe400078e021cULL, 0x0000000145127824ULL, 0x000fe400078e0212ULL,
0x000000ffff157224ULL, 0x000fe200000e063fULL, 0x0000001e401e7210ULL, 0x000fc40007fde0ffULL,
0x000000094400720cULL, 0x000fe20003f06070ULL, 0x00000010161d7824ULL, 0x002fe400078e0217ULL,
0x0000000143107824ULL, 0x000fe400078e0212ULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x00000000141d7faeULL, 0x0003e2000e901c46ULL, 0x00005e001e117a11ULL, 0x000fe400078a38ffULL,
0x0000001040167210ULL, 0x000fe40007fde0ffULL, 0x00005f001e1e7a11ULL, 0x000fc400028f3c1fULL,
0x000000094500720cULL, 0x000fe20003fa6070ULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x0000004211107210ULL, 0x000fe20007fde0ffULL, 0x000000011c097824ULL, 0x140fe400078e020dULL,
0x000000081c1c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200030e061eULL,
0x00005e0016147a11ULL, 0x002fe200078c38ffULL, 0x0000000112157824ULL, 0x040fe400078e020dULL,
0x00000008121e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c127812ULL, 0x000fc400078ee209ULL,
0x00005f00161c7a11ULL, 0x000fe400030f3c1fULL, 0x0000004214147210ULL, 0x000fe20007fde0ffULL,
0x0000001012097824ULL, 0x000fe200078e0217ULL, 0xfffffff81e167812ULL, 0x000fc600078ee215ULL,
0x000000ffff157224ULL, 0x000fe200030e061cULL, 0x0000000010097faeULL, 0x0003e2000c101c46ULL,
0x0000001016177824ULL, 0x000fca00078e0217ULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x000003c000007947ULL, 0x000fea0003800000ULL, 0x0000001010107812ULL, 0x000fc800078ec0ffULL,
0x000000100d107211ULL, 0x000fc800078fe8ffULL, 0x0000000410147810ULL, 0x040fe20007ffe0ffULL,
0x0000000143097824ULL, 0x040fe400078e0210ULL, 0x0000000110117824ULL, 0x100fe400078e020dULL,
0x0000000114157824ULL, 0x000fe200078e020dULL, 0x00000009403f7210ULL, 0x000fe20007f1e0ffULL,
0x0000000814167824ULL, 0x000fe400078e00ffULL, 0x0000000810127824ULL, 0x000fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0xfffffff816177812ULL, 0x000fe200078ee215ULL,
0x0000000143147824ULL, 0x000fe200078e0214ULL, 0x0000000810167810ULL, 0x000fc40007ffe0ffULL,
0x0000000c10107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff812127812ULL, 0x000fe200078ee211ULL,
0x0000000143097824ULL, 0x000fe200078e0216ULL, 0x00005e003f1f7a11ULL, 0x000fe200078038ffULL,
0x0000000143117824ULL, 0x000fe200078e0210ULL, 0x0000001440157210ULL, 0x000fe20007fde0ffULL,
0x00000008101e7824ULL, 0x000fe200078e00ffULL, 0x0000000940427210ULL, 0x000fe20007fbe0ffULL,
0x0000000116097824ULL, 0x140fe200078e020dULL, 0x00005f003f3f7a11ULL, 0x000fe200000f3c1cULL,
0x0000000816167824ULL, 0x000fe200078e00ffULL, 0x0000001140407210ULL, 0x000fe20007f1e0ffULL,
0x0000000110117824ULL, 0x000fc400078e020dULL, 0x000000ffff107224ULL, 0x000fe200030e06ffULL,
0xfffffff8161d7812ULL, 0x000fe200078ee209ULL, 0x000000100d097824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00005e0042167a11ULL, 0x040fe400078a38ffULL, 0x00005e0015147a11ULL, 0x000fe400078c38ffULL,
0x0000007009437812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005f0042427a11ULL, 0x000fe200028f3c11ULL, 0x000000020e117824ULL, 0x000fe200078e0247ULL,
0x00005f0015157a11ULL, 0x000fc400030f3c10ULL, 0x000000431f107210ULL, 0x080fe40007f1e0ffULL,
0x0000004314147210ULL, 0x080fe40007fbe0ffULL, 0x00005e00401c7a11ULL, 0x000fe400078c38ffULL,
0x0001300011447811ULL, 0x000fe200078e60ffULL, 0x000000ffff117224ULL, 0x000fe200000e063fULL,
0x0000004316167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0615ULL,
0x00005f0040407a11ULL, 0x000fe200030f3c09ULL, 0x0000001012097824ULL, 0x100fe200078e0244ULL,
0x000000431c1c7210ULL, 0x000fe20007fbe0ffULL, 0x00000010171f7824ULL, 0x000fc400078e0244ULL,
0x000000101d3f7824ULL, 0x000fe200078e0244ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010097faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fe400000e0642ULL,
0x000000101e437824ULL, 0x000fe200078e0244ULL, 0x00000000141f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1d7224ULL, 0x000fc600028e0640ULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c437faeULL, 0x0003e4000b901c46ULL, 0x000000083d127824ULL, 0x000fe200078e00ffULL,
0x0000000141097810ULL, 0x002fc80007ffe0ffULL, 0xfffffff012147812ULL, 0x000fe400078ec0ffULL,
0x0000003c0900720cULL, 0x000fc60003f06070ULL, 0x0000000847457824ULL, 0x000fca00078e0214ULL,
0x0000000000007918ULL, 0x000fea0000000000ULL, 0x0000000108108824ULL, 0x000fe400078e0209ULL,
0x00000004ff118424ULL, 0x000fe400078e00ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0xffffffe0124a7812ULL, 0x000fe200078ec0ffULL, 0x0000600010108625ULL, 0x000fe200078e0011ULL,
0x0000001012157812ULL, 0x000fc400078ec0ffULL, 0x0000000812127812ULL, 0x000fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x0000000610098981ULL, 0x000322000c1e1900ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000004a124a7210ULL, 0x000fe40007ffe015ULL,
0x000176a845557810ULL, 0x000fd20007ffe0ffULL, 0x00000000550403c2ULL, 0x000ea40000060000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00b9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20001f0f070ULL,
0xffffff8000003947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a800457e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017608004a167f8cULL, 0x0002a4000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x01760c004a157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x006fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014101d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011415ULL,
0x0000001d12127211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000212127819ULL, 0x000fc80000001215ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760c004a157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d107824ULL, 0x000fe200078e00ffULL, 0x00000001ff487819ULL, 0x000fe2000001160dULL,
0x000000203d497824ULL, 0x000fc600078e00ffULL, 0x0000007010167812ULL, 0x000fe400078ec0ffULL,
0xffffff8049497812ULL, 0x000fe400078ec0ffULL, 0x0000000c48487812ULL, 0x000fc800078ec0ffULL,
0x0000004948107210ULL, 0x000fca0007ffe016ULL, 0x0170000010157984ULL, 0x000e680000000800ULL,
0x0172000010127984ULL, 0x0004e20000000800ULL, 0x000000581500720bULL, 0x002fe20003f1d000ULL,
0x00010d227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x004fc800000e0100ULL,
0x0000ffff101f7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff437224ULL, 0x000fd200078e0058ULL,
0x0000043000008947ULL, 0x000fea0003800000ULL, 0x0000003d0c00720cULL, 0x000fe40003fa5270ULL,
0x000000581500720bULL, 0x000fe20003f14000ULL, 0x00010cf27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x000fc400000e0100ULL, 0x000000803d11d824ULL, 0x000fe200078e0216ULL,
0x0000001558437209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000014810d824ULL, 0x000fe200078e0211ULL, 0x0000991014117816ULL, 0x000fc800000000ffULL,
0x017400431000d388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000004358107221ULL, 0x002fe20000010000ULL,
0x000000ff14ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x00000010003f7308ULL, 0x0002ac0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x002fe2000001160dULL,
0x00010c427f007947ULL, 0x000fea000b800000ULL, 0x00001f103f107589ULL, 0x0042a400000e0000ULL,
0x0000001020207220ULL, 0x084fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x000fc40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x080fe40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x000fc40000410000ULL, 0x0000001031317220ULL, 0x080fe40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001035357220ULL, 0x080fe40000410000ULL,
0x0000001038387220ULL, 0x080fe40000410000ULL, 0x0000001039397220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x000fc40000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0014ff7812ULL, 0x000fe2000780c0ffULL,
0x0000003f07077220ULL, 0x004fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d107811ULL, 0x002fe200078ff0ffULL, 0x00010b427f007947ULL, 0x000fea000b800000ULL,
0x00001f103f107589ULL, 0x0002a400000e0000ULL, 0x0000001022227220ULL, 0x084fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x080fe40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x000fc40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x080fe40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff1fff7812ULL, 0x000fda0007806014ULL, 0x8000004315150221ULL, 0x000fe20000010000ULL,
0x00007610ff6a0816ULL, 0x000fc6000000006aULL, 0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL,
0x0000001500030308ULL, 0x000e640000000800ULL, 0x0000000312120220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000712077221ULL, 0x008fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x000000020e127824ULL, 0x000fc800078e0213ULL,
0x0000000812167824ULL, 0x000fca00078e00ffULL, 0x0176ac0016127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011415ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000212127819ULL, 0x000fc80000001215ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0016127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106a107816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff127819ULL, 0x000fe4000001160dULL, 0x0000541000157816ULL, 0x000fe20000000000ULL,
0x000107427f007947ULL, 0x000fea000b800000ULL, 0x00001f1215027589ULL, 0x0002a400000e0000ULL,
0x0000000812007810ULL, 0x000fe20007ffe0ffULL, 0x000107927f007947ULL, 0x000fea000b800000ULL,
0x00001f0015007589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001012107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0015ULL,
0x00002bc0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x000114f000007944ULL, 0x01efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001812107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e0015ULL, 0x00002c30001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0001148000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070d107812ULL, 0x000fe200078ec0ffULL, 0x000000023d4d7824ULL, 0x040fe200078e00ffULL,
0x00000004ff6d7819ULL, 0x100fe2000001160dULL, 0x000002003d3f7824ULL, 0x000fe200078e00ffULL,
0x0000000810737812ULL, 0x000fe200078ef80dULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000044d107812ULL, 0x000fe400078ec0ffULL, 0xfffff8003f3f7812ULL, 0x000fe200078ec0ffULL,
0x0000000873117824ULL, 0x040fe200078e00ffULL, 0x0000001073107210ULL, 0x000fc80007ffe06dULL,
0xfffffff811447812ULL, 0x000fe400078ee210ULL, 0x000000080d107812ULL, 0x000fc600078ec0ffULL,
0x0000001044447824ULL, 0x000fc400078e023fULL, 0x000000043d567824ULL, 0x000fe200078e00ffULL,
0x0000000710577812ULL, 0x000fe200078ef80dULL, 0x000000020e507824ULL, 0x000fe200078e0213ULL,
0x000099106a6a7816ULL, 0x000fe400000000ffULL, 0x0000000456567812ULL, 0x000fe200078ec0ffULL,
0x0000000857117824ULL, 0x040fe200078e00ffULL, 0x0001300050507811ULL, 0x000fe200078e60ffULL,
0x0000000857127824ULL, 0x042fe200078e00ffULL, 0x0000001057597812ULL, 0x000fe200078efcffULL,
0x000000016d567824ULL, 0x000fc800078e0256ULL, 0x0000000157107824ULL, 0x000fe400078e0256ULL,
0x00000008594e7824ULL, 0x000fe400078e00ffULL, 0x00000001564f7824ULL, 0x000fe200078e0259ULL,
0xfffffff811117812ULL, 0x000fe400078ee210ULL, 0x0000000210517810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee24fULL, 0x0000001011117824ULL, 0x000fe200078e0250ULL,
0xfffffff812517812ULL, 0x000fc400078ee251ULL, 0x000000024f4f7810ULL, 0x000fe20007ffe0ffULL,
0x000000104e147824ULL, 0x100fe200078e0250ULL, 0x00000000111c783bULL, 0x000e620000004200ULL,
0x0000001051107824ULL, 0x000fc800078e0250ULL, 0x000000001414783bULL, 0x00cea20000004200ULL,
0x000001001c117824ULL, 0x042fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001141cULL,
0x000001001d547824ULL, 0x000fe200078e00ffULL, 0x000088801c827816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011411ULL,
0x0000010017587824ULL, 0x004fe200078e00ffULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x00000018ff4c7819ULL, 0x000fe20000011414ULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000888014607816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe20000011415ULL,
0x0000001c00857306ULL, 0x0005e20000200c00ULL, 0x00000018ff427819ULL, 0x000fe40000011416ULL,
0x00000018ff467819ULL, 0x000fe40000011417ULL, 0x00008880155e7816ULL, 0x000fc400000000ffULL,
0x0000888016617816ULL, 0x000fe200000000ffULL, 0x0000005400877306ULL, 0x0007e20000200c00ULL,
0x000001001e1c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe4000001141dULL,
0x00000018ff527819ULL, 0x000fe4000001141eULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff537819ULL, 0x000fe2000001141fULL, 0x000001001f547824ULL, 0x008fe200078e00ffULL,
0x0000001c007a7306ULL, 0x0005e20000200c00ULL, 0x000088801d807816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x000088801e817816ULL, 0x040fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x000088801f6b7816ULL, 0x040fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000005400787306ULL, 0x0007e20000200c00ULL, 0x00000100141c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000010011797824ULL, 0x002fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe2000001141cULL, 0x00000008591c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001d00837306ULL, 0x000fe20000200c00ULL,
0x0000888017547816ULL, 0x048fe200000000ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0xfffffff81c4f7812ULL, 0x000fe200078ee24fULL, 0x0001000010727824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0001000011777824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0000001400657306ULL, 0x0003e20000200c00ULL,
0x000000104f1c7824ULL, 0x000fe200078e0250ULL, 0x00000018ff6f7819ULL, 0x000fe20000011410ULL,
0x0000010015507824ULL, 0x040fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011411ULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011412ULL,
0x0000010012707824ULL, 0x000fe200078e00ffULL, 0x00000017005b7306ULL, 0x000fe20000200c00ULL,
0x0000010016147824ULL, 0x042fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00008880107b7816ULL, 0x000fe200000000ffULL,
0x0001000012847824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000010013757824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000001500637306ULL, 0x000fe20000200c00ULL, 0x0000888011747816ULL, 0x000fc400000000ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000888012717816ULL, 0x000fe200000000ffULL,
0x000000040e127824ULL, 0x000fe200078e026dULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x00000014005c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000000212127810ULL, 0x000fe20007ffe073ULL, 0x0000000873737824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fc40000011477ULL, 0x00000018ff627819ULL, 0x000fe20000011413ULL,
0x00000016005f7306ULL, 0x0005e20000200c00ULL, 0x0000010010147824ULL, 0x002fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff767819ULL, 0x000fe40000011414ULL, 0x0000001e007d7306ULL, 0x000fe20000200c00ULL,
0x011000004414783bULL, 0x004e620000000200ULL, 0x00000018ff847819ULL, 0x000fc40000011484ULL,
0x00000018ff507819ULL, 0x000fc80000011450ULL, 0x0000001f00687306ULL, 0x0005f00000200c00ULL,
0x0000008900897306ULL, 0x000ee20000200c00ULL, 0x000000001c1c783bULL, 0x004eae0000004200ULL,
0x0000008000807306ULL, 0x000e700000200c00ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x0000541082107816ULL, 0x008fce0000000089ULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x0000000214148232ULL, 0x082fe20000000000ULL, 0x0000541080117816ULL, 0x000fe20000000087ULL,
0x0000000216168232ULL, 0x000fe20000000000ULL, 0xfffffff873807812ULL, 0x000fe200078ee212ULL,
0x0000000015158232ULL, 0x080fe40000000000ULL, 0x0000000017178232ULL, 0x000fe20000000000ULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x00000010803f7824ULL, 0x000fe200078e023fULL,
0x000000ff6a00720cULL, 0x000fc80003f05270ULL, 0x000000101420723cULL, 0x040b640000001820ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x00000018ff6c7819ULL, 0x004fe4000001141eULL,
0x000088801c127816ULL, 0x040fe400000000ffULL, 0x0000541085107816ULL, 0x020fe4000000007cULL,
0x0000541083117816ULL, 0x008fe20000000064ULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x000054107d527816ULL, 0x002fe20000000052ULL, 0x000000ffff647224ULL, 0x000fe200078e0012ULL,
0x00000018ff5a7819ULL, 0x000fe2000001141cULL, 0x000001001c127824ULL, 0x040fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe2000001141dULL, 0x000000101424723cULL, 0x000b620000001824ULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x0000541068537816ULL, 0x000fc40000000053ULL, 0x000088801e6a7816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fc6000001141cULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x0000541081107816ULL, 0x024fe2000000007aULL, 0x00000052142c723cULL, 0x000bec000000182cULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000054106b117816ULL, 0x002fe40000000078ULL,
0x00000018ff6b7819ULL, 0x000fc40000011412ULL, 0x000088801d787816ULL, 0x000fc600000000ffULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000000101428723cULL, 0x000f620000001828ULL,
0x000000ffff687224ULL, 0x000fe400078e0078ULL, 0x000001001d787824ULL, 0x000fc800078e00ffULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x000054107b527816ULL, 0x024fe40000000076ULL,
0x00000018ff787819ULL, 0x000fca0000011478ULL, 0x00000058005d7306ULL, 0x000ff00000200c00ULL,
0x0000006c00587306ULL, 0x0005e20000200c00ULL, 0x0000541074537816ULL, 0x002fce0000000079ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00008880136c7816ULL, 0x044fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x000000521430723cULL, 0x000be80000001830ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000006e006e7306ULL, 0x000ff00000200c00ULL,
0x0000007200727306ULL, 0x000e700000200c00ULL, 0x0000007700777306ULL, 0x000eb00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541072527816ULL, 0x022fce000000006fULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541077537816ULL, 0x004fce000000006eULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000000521434723cULL, 0x000b6e0000001834ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x000100001d527824ULL, 0x020fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000001300737306ULL, 0x0005f00000200c00ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x011000003f10783bULL, 0x004ea20000000200ULL,
0x000054106c1d7816ULL, 0x002fcc0000000075ULL, 0x0000006200627306ULL, 0x000ff00000200c00ULL,
0x00000084006d7306ULL, 0x000e700000200c00ULL, 0x0000001c00537306ULL, 0x0007f00000200c00ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x00005410711c7816ULL, 0x008fce0000000070ULL,
0x0000001c1438723cULL, 0x000b620000001838ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000000210108232ULL, 0x084fe40000000000ULL, 0x0000000212128232ULL, 0x000fe40000000000ULL,
0x0000000011118232ULL, 0x080fe20000000000ULL, 0x000054106d1c7816ULL, 0x022fe20000000066ULL,
0x0000000013138232ULL, 0x000fe20000000000ULL, 0x00005410731d7816ULL, 0x000fe20000000062ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000ffff627224ULL, 0x000fca00078e006aULL,
0x0000001c1418723cULL, 0x000b640000001818ULL, 0x0000005000677306ULL, 0x000e6a0000200c00ULL,
0x000001001e147824ULL, 0x060fe200078e00ffULL, 0x000088801f1c7816ULL, 0x040fe200000000ffULL,
0x000001001f1d7824ULL, 0x000fe200078e00ffULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000004000407306ULL, 0x000ee20000200c00ULL, 0x000054105e157816ULL, 0x002fce0000000067ULL,
0x0000001400167306ULL, 0x0003f00000200c00ULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x0000541060147816ULL, 0x002fce0000000069ULL, 0x0000005400507306ULL, 0x0002620000200c00ULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000541065147816ULL, 0x024fe2000000004cULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000541063157816ULL, 0x008fc40000000040ULL,
0x00000018ff547819ULL, 0x002fca000001141fULL, 0x0000004600467306ULL, 0x000e620000200c00ULL,
0x000000141024723cULL, 0x000b6e0000001824ULL, 0x0000541061147816ULL, 0x020fe2000000005cULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x0000541050157816ULL, 0x000fce000000005dULL,
0x000000141028723cULL, 0x000b620000001828ULL, 0x0000005200527306ULL, 0x000eac0000200c00ULL,
0x000100001f147824ULL, 0x020fe200078e00ffULL, 0x000054105b157816ULL, 0x002fe20000000046ULL,
0x0000006200177306ULL, 0x000e660000200c00ULL, 0x00000018ff407819ULL, 0x000fc40000011414ULL,
0x000054105f147816ULL, 0x000fc60000000042ULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x00005410525b7816ULL, 0x004fc60000000059ULL, 0x00000014102c723cULL, 0x000b68000000182cULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541017167816ULL, 0x002fe40000000016ULL,
0x000000080e147824ULL, 0x020fca00078e00ffULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x00005410535a7816ULL, 0x008fce000000005aULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x0000005a1034723cULL, 0x000b6e0000001834ULL, 0x0000006800687306ULL, 0x000ff00000200c00ULL,
0x00000078006f7306ULL, 0x000ea20000200c00ULL, 0x0000541064647816ULL, 0x002fce000000006bULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000001d001d7306ULL, 0x000e620000200c00ULL,
0x0000541068657816ULL, 0x004fce000000006fULL, 0x0000001e001f7306ULL, 0x000ea20000200c00ULL,
0x000000641030723cULL, 0x000b6e0000001830ULL, 0x0000004000157306ULL, 0x000ee20000200c00ULL,
0x000054101c177816ULL, 0x002fe4000000001dULL, 0x000054101f587816ULL, 0x004fca0000000058ULL,
0x000000161038723cULL, 0x000b620000001838ULL, 0x0000541015597816ULL, 0x008fce0000000054ULL,
0x000000581018723cULL, 0x000b620000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0176c80014147f8cULL, 0x000e62000c80043fULL, 0xfffffff84d467812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004006117811ULL, 0x020fe200078e40ffULL,
0x0176880046ff7f8cULL, 0x0005e2000c80043fULL, 0x0000000141417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x000fe200078e0043ULL, 0x0000003e1100720cULL, 0x000fe20003f06070ULL,
0x000000ffff597224ULL, 0x000fe400078e007fULL, 0x000000ffff137224ULL, 0x000fd400078e0047ULL,
0x000077d000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x000004004b127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004004b127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000103d127824ULL, 0x000fe200078e00ffULL, 0x0000000106107810ULL, 0x000fe20007ffe0ffULL,
0x0000580009097a24ULL, 0x010fc600078e02ffULL, 0x0000000f1000720cULL, 0x000fe20003f06070ULL,
0x0000004009097824ULL, 0x000fe200078e00ffULL, 0xffffffe012117812ULL, 0x000fca00078ec0ffULL,
0x0000010006117824ULL, 0x000fca00078e0211ULL, 0x0000008011117810ULL, 0x000fc80007ffe0ffULL,
0x000000200a137812ULL, 0x000fe200078ef811ULL, 0x000004b000008947ULL, 0x000fea0003800000ULL,
0x0000001012407812ULL, 0x000fe200078ec0ffULL, 0x000000100d127824ULL, 0x000fe200078e00ffULL,
0x00000003ff417819ULL, 0x000fc8000001160dULL, 0x00000004414d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001411c7824ULL, 0x000fe200078e0240ULL, 0x0000007012127812ULL, 0x000fc600078ec0ffULL,
0x000000011c107824ULL, 0x040fe400078e0213ULL, 0x000000014d427824ULL, 0x000fe400078e0240ULL,
0x000000011c1d7824ULL, 0x040fe200078e020dULL, 0x0000001009147210ULL, 0x000fe20007f1e0ffULL,
0x000000081c1c7824ULL, 0x000fe200078e00ffULL, 0x000000113e107217ULL, 0x000fc60007800000ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0014177a11ULL, 0x000fe200078038ffULL,
0x0000000110117824ULL, 0x000fe200078e0a11ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee21dULL,
0x0000100004107824ULL, 0x000fe200078e00ffULL, 0x00005f0014147a11ULL, 0x000fe400000f3c15ULL,
0x0000001140117217ULL, 0x000fe40007800000ULL, 0x0000100010157812ULL, 0x000fe200078ec0ffULL,
0x0000000142107824ULL, 0x000fc400078e0213ULL, 0x0000000111167824ULL, 0x000fe400078e0a40ULL,
0x000020000e157824ULL, 0x000fe200078e0215ULL, 0x00000010091e7210ULL, 0x000fe40007fde0ffULL,
0x0000001217107210ULL, 0x000fe40007fbe0ffULL, 0x000000164100720cULL, 0x000fe20003f06070ULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x0001300015177810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200028e0614ULL, 0x00005e001e157a11ULL, 0x000fc400078c38ffULL,
0x000000164d00720cULL, 0x000fe20003fa6070ULL, 0x000000101c1d7824ULL, 0x000fe200078e0217ULL,
0x00000008414d7810ULL, 0x040fe40007ffe0ffULL, 0x00005f001e1e7a11ULL, 0x000fe200030f3c1fULL,
0x00000001421f7824ULL, 0x040fe200078e020dULL, 0x0000000c41417810ULL, 0x000fe20007ffe0ffULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0x000000014d4c7824ULL, 0x100fe200078e0240ULL,
0x0000001215147210ULL, 0x000fe20007f1e0ffULL, 0x0000000141407824ULL, 0x000fe200078e0240ULL,
0xfffffff842427812ULL, 0x000fe200078ee21fULL, 0x000000014c1c7824ULL, 0x000fc400078e0213ULL,
0x000000ffff157224ULL, 0x000fe200000e061eULL, 0x000000164d00720cULL, 0x000fe20003f06070ULL,
0x000000084c1f7824ULL, 0x000fe200078e00ffULL, 0x0000001c091c7210ULL, 0x000fe20007fde0ffULL,
0x00000010421d7824ULL, 0x002fe400078e0217ULL, 0x0000000140107824ULL, 0x000fe400078e0213ULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x00000000141d7faeULL, 0x0003e2000e901c46ULL,
0x00005e001c117a11ULL, 0x000fc400078a38ffULL, 0x0000001009097210ULL, 0x000fe40007fde0ffULL,
0x00005f001c137a11ULL, 0x000fe400028f3c13ULL, 0x000000164100720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1c7224ULL, 0x000fe200030e06ffULL, 0x0000001211107210ULL, 0x000fe20007fde0ffULL,
0x000000014c167824ULL, 0x100fe400078e020dULL, 0x00000001401d7824ULL, 0x042fe400078e020dULL,
0x000000ffff117224ULL, 0x000fe200030e0613ULL, 0x00005e0009157a11ULL, 0x000fe200078c38ffULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0xfffffff81f167812ULL, 0x000fc400078ee216ULL,
0x00005f0009137a11ULL, 0x000fe400030f3c1cULL, 0x0000001215147210ULL, 0x000fe20007fde0ffULL,
0x0000001016097824ULL, 0x000fe200078e0217ULL, 0xfffffff8401c7812ULL, 0x000fc600078ee21dULL,
0x000000ffff157224ULL, 0x000fe200030e0613ULL, 0x0000000010097faeULL, 0x0003e2000c101c46ULL,
0x000000101c177824ULL, 0x000fca00078e0217ULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x000003e000007947ULL, 0x000fea0003800000ULL, 0x0000001012127812ULL, 0x000fc800078ec0ffULL,
0x000000120d127211ULL, 0x000fc800078fe8ffULL, 0x0000000412147810ULL, 0x040fe20007ffe0ffULL,
0x0000000112117824ULL, 0x040fe200078e020dULL, 0x0000000c121e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000812167824ULL, 0x040fe400078e00ffULL, 0x0000000112107824ULL, 0x000fe400078e0213ULL,
0x0000000114157824ULL, 0x000fe200078e020dULL, 0xfffffff816417812ULL, 0x000fe200078ee211ULL,
0x00000008141c7824ULL, 0x040fe200078e00ffULL, 0x0000001009167210ULL, 0x000fe20007f1e0ffULL,
0x0000000114107824ULL, 0x000fc400078e0213ULL, 0x000000011e147824ULL, 0x000fe200078e0213ULL,
0xfffffff81c4d7812ULL, 0x000fe200078ee215ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00000008121c7810ULL, 0x000fe40007ffe0ffULL, 0x00005e00161f7a11ULL, 0x000fe400078038ffULL,
0x0000001009107210ULL, 0x040fe20007fde0ffULL, 0x000000011c127824ULL, 0x000fe200078e0213ULL,
0x00005f0016167a11ULL, 0x000fe200000f3c11ULL, 0x0000100004117824ULL, 0x000fe200078e00ffULL,
0x0000001409147210ULL, 0x040fe20007f1e0ffULL, 0x000000081c537824ULL, 0x040fe200078e00ffULL,
0x0000001209407210ULL, 0x000fe20007fbe0ffULL, 0x000000011c127824ULL, 0x100fe200078e020dULL,
0x0000100011117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005e0010157a11ULL, 0x000fe200078c38ffULL, 0x000000011e137824ULL, 0x000fe200078e020dULL,
0xfffffff853537812ULL, 0x000fe200078ee212ULL, 0x000000100d127824ULL, 0x000fe200078e00ffULL,
0x00005f00101c7a11ULL, 0x000fe200030f3c09ULL, 0x000020000e107824ULL, 0x000fc400078e0211ULL,
0x000000081e1e7824ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005e00141d7a11ULL, 0x000fe200078a38ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0040177a11ULL, 0x000fe400078038ffULL,
0xfffffff81e597812ULL, 0x000fe400078ee213ULL, 0x0001300010427810ULL, 0x000fe40007ffe0ffULL,
0x00005f0040407a11ULL, 0x000fc400000f3c11ULL, 0x00005f00141e7a11ULL, 0x000fe200028f3c09ULL,
0x0000001041097824ULL, 0x100fe200078e0242ULL, 0x000000121f107210ULL, 0x080fe20007f1e0ffULL,
0x000000104d137824ULL, 0x100fe200078e0242ULL, 0x0000001215147210ULL, 0x080fe20007fbe0ffULL,
0x00000010531f7824ULL, 0x000fe400078e0242ULL, 0x000000ffff117224ULL, 0x000fe200000e0616ULL,
0x0000001217167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e061cULL,
0x000000121d1c7210ULL, 0x000fe20007fbe0ffULL, 0x0000001059417824ULL, 0x000fe200078e0242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fc400000e0640ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061eULL,
0x0000000014137faeULL, 0x0003e8000b901c46ULL, 0x00000000161f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c417faeULL, 0x0003e4000b901c46ULL, 0x000000083d147824ULL, 0x002fe200078e00ffULL,
0x0000000205097810ULL, 0x000fe20007ffe0ffULL, 0x0000000804137824ULL, 0x000fc600078e00ffULL,
0xfffffff014147812ULL, 0x000fe400078ec0ffULL, 0x0000000813137812ULL, 0x000fe400078ec0ffULL,
0x0000003c0900720cULL, 0x000fe20003f06070ULL, 0xffffffffff097424ULL, 0x000fe400078e00ffULL,
0x0000000114547824ULL, 0x000fca00078e0213ULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x0000000208108810ULL, 0x000fe20007ffe005ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000176a854537810ULL, 0x000fc60007ffe0ffULL, 0x0000000610098981ULL, 0x000322000c1e1900ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000530403c2ULL, 0x000ea40000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80054587f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017628004a107f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x01762c004a137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011417ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c004a137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008012117810ULL, 0x000fca0007ffe049ULL, 0x0000000148117824ULL, 0x000fca00078e0211ULL,
0x0170000011147984ULL, 0x000e680000000800ULL, 0x0172000011167984ULL, 0x0004e20000000800ULL,
0x000000431400720bULL, 0x002fe20003f1d000ULL, 0x0000e4f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x004fc800000e0100ULL, 0x0000ffff13ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff157424ULL, 0x000fe400078e00ffULL,
0x000000ffff587224ULL, 0x008fd200078e0043ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000010c107810ULL, 0x000fe40007ffe0ffULL, 0x000000431400720bULL, 0x000fe40003f14000ULL,
0x0000003d1000720cULL, 0x000fe20003fa5270ULL, 0x0000e4b27f007947ULL, 0x000fd4000b800000ULL,
0x00000000001c7806ULL, 0x000fc400000e0100ULL, 0x000000803d11d824ULL, 0x000fe200078e0212ULL,
0x000000431410d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000014815d824ULL, 0x000fe200078e0211ULL, 0x000099101c117816ULL, 0x000fc800000000ffULL,
0x017400101500d388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004314107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff1cff7812ULL, 0x000fc6000780c0ffULL,
0x0000004310107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000127308ULL, 0x000e640000000800ULL, 0x0000001207077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x0000e3e27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x0002a400000e0000ULL,
0x0000001020207220ULL, 0x084fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x000fc40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x080fe40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001035357220ULL, 0x080fe40000410000ULL,
0x0000001038387220ULL, 0x080fe40000410000ULL, 0x0000001039397220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x0000e2f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x0004e400000e0000ULL,
0x0000001022227220ULL, 0x088fe40000410000ULL, 0x0000001023237220ULL, 0x080fe40000410000ULL,
0x0000001026267220ULL, 0x080fe40000410000ULL, 0x0000001027277220ULL, 0x080fe40000410000ULL,
0x000000102a2a7220ULL, 0x080fe40000410000ULL, 0x000000102b2b7220ULL, 0x000fc40000410000ULL,
0x000000102e2e7220ULL, 0x080fe40000410000ULL, 0x000000102f2f7220ULL, 0x080fe40000410000ULL,
0x0000001032327220ULL, 0x080fe40000410000ULL, 0x0000001033337220ULL, 0x080fe40000410000ULL,
0x0000001036367220ULL, 0x080fe40000410000ULL, 0x0000001037377220ULL, 0x000fc40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000101a1a7220ULL, 0x080fe40000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff1cff7812ULL, 0x000fe20007800813ULL,
0x00000001ff157424ULL, 0x000fe200078e00ffULL, 0x0000004314587209ULL, 0x000fd60007810000ULL,
0x8000005814140221ULL, 0x000fe20000010000ULL, 0x00007610ff150816ULL, 0x000fc60000000015ULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x0000001400030308ULL, 0x000e640000000800ULL,
0x0000000316160220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000716077221ULL, 0x000fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0176ac0045137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780487fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x004fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0045137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780487fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991015107816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe4000001160dULL,
0x0000541000127816ULL, 0x004fe20000000000ULL, 0x0000def27f007947ULL, 0x000fea000b800000ULL,
0x00001f1312027589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x0000df427f007947ULL, 0x000fea000b800000ULL, 0x00001f1012007589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000056b0001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000ea0000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00005720001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000e99000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000157107824ULL, 0x048fe200078e0256ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000857117824ULL, 0x000fe400078e00ffULL,
0x000000020e5a7824ULL, 0x000fc600078e0247ULL, 0xfffffff811117812ULL, 0x000fe400078ee210ULL,
0x000130005a5a7811ULL, 0x000fca00078e60ffULL, 0x0000001011527824ULL, 0x100fe400078e025aULL,
0x0000001051507824ULL, 0x100fe400078e025aULL, 0x000000104e4d7824ULL, 0x100fe200078e025aULL,
0x00000000521c783bULL, 0x000ee20000004200ULL, 0x000000104f4c7824ULL, 0x000fc600078e025aULL,
0x000000005040783bULL, 0x000fe80000004200ULL, 0x000000004d10783bULL, 0x006e680000004200ULL,
0x000000004c14783bULL, 0x000ea20000004200ULL, 0x00000018ff867819ULL, 0x008fe2000001141cULL,
0x000001001c647824ULL, 0x040fe200078e00ffULL, 0x000088801c897816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001141dULL,
0x000001001d657824ULL, 0x040fe200078e00ffULL, 0x000088801d687816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0001000010697824ULL, 0x002fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x00000100116f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe2000001141eULL,
0x00010000116a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe2000001141fULL,
0x0000001c00877306ULL, 0x0003e20000200c00ULL, 0x000088801e857816ULL, 0x000fc400000000ffULL,
0x000088801f707816ULL, 0x000fe400000000ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff627819ULL, 0x000fe20000011410ULL, 0x0000001d00887306ULL, 0x0007e20000200c00ULL,
0x000001001e1c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011411ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00008880407f7816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000064008a7306ULL, 0x0002a20000200c00ULL,
0x00000100411d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000888041767816ULL, 0x000fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00847306ULL, 0x0007e20000200c00ULL, 0x000001001f647824ULL, 0x042fe200078e00ffULL,
0x00008880106d7816ULL, 0x000fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00008880116c7816ULL, 0x000fc400000000ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x0000001d007d7306ULL, 0x0003e20000200c00ULL, 0x00000100401c7824ULL, 0x008fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff667819ULL, 0x000fe40000011442ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001e00817306ULL, 0x000fe20000200c00ULL,
0x00000100431d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fc40000011443ULL,
0x0000888042797816ULL, 0x000fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c007e7306ULL, 0x0003e20000200c00ULL, 0x0000888043747816ULL, 0x040fe200000000ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe20000011440ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011441ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000001f00827306ULL, 0x000fe20000200c00ULL, 0x00000100421c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fc40000011441ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001d00777306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff607819ULL, 0x000fe40000011412ULL, 0x0000888012677816ULL, 0x000fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fe20000011413ULL, 0x0000001c00787306ULL, 0x0003e20000200c00ULL,
0x00000018ff5e7819ULL, 0x004fc40000011414ULL, 0x00000018ff5d7819ULL, 0x000fe40000011415ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00000100101c7824ULL, 0x002fe200078e00ffULL,
0x0000541089107816ULL, 0x000fe4000000008aULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000018ff6e7819ULL, 0x000fc4000001141cULL, 0x01180000441c783bULL, 0x000e620000000200ULL,
0x00000065008b7306ULL, 0x0004e20000200c00ULL, 0x00000018ff5c7819ULL, 0x000fe40000011416ULL,
0x00000018ff5b7819ULL, 0x000fca0000011417ULL, 0x0000008600867306ULL, 0x000e620000200c00ULL,
0x0001000012657824ULL, 0x004fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x0000541068117816ULL, 0x008fce000000008bULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000000021c1c8232ULL, 0x002fce0000000000ULL, 0x0000008500857306ULL, 0x000e620000200c00ULL,
0x000000021e1e8232ULL, 0x000fe40000000000ULL, 0x000000001d1d8232ULL, 0x080fe40000000000ULL,
0x000000001f1f8232ULL, 0x000fc60000000000ULL, 0x0000007000707306ULL, 0x000fe80000200c00ULL,
0x000000101c20723cULL, 0x000b680000001820ULL, 0x0000006400837306ULL, 0x0006660000200c00ULL,
0x0000541087107816ULL, 0x020fc40000000086ULL, 0x0000541088117816ULL, 0x004fc6000000006bULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x0000010012647824ULL, 0x008fe200078e00ffULL,
0x0000888014127816ULL, 0x040fe400000000ffULL, 0x000000101c24723cULL, 0x000b640000001824ULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x000000ffff6b7224ULL, 0x000fe200078e0012ULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x0000010014127824ULL, 0x040fe400078e00ffULL,
0x0000541085107816ULL, 0x022fe20000000084ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x0000541070117816ULL, 0x000fc40000000083ULL, 0x00000018ff707819ULL, 0x000fe20000011412ULL,
0x0000004200737306ULL, 0x0003e20000200c00ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000888015837816ULL, 0x000fe200000000ffULL, 0x000000101c28723cULL, 0x000f680000001828ULL,
0x0000004300727306ULL, 0x0005e20000200c00ULL, 0x0000888013427816ULL, 0x002fce00000000ffULL,
0x00000040007b7306ULL, 0x0003e20000200c00ULL, 0x0000010013437824ULL, 0x044fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000041007c7306ULL, 0x0005e20000200c00ULL, 0x0000541081407816ULL, 0x002fe20000000080ULL,
0x0000010015807824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fca0000011413ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541082417816ULL, 0x004fce0000000071ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x000000401c2c723cULL, 0x000b6e000000182cULL,
0x000054107f407816ULL, 0x020fe2000000007eULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x0000541076417816ULL, 0x008fc4000000007dULL, 0x00000018ff767819ULL, 0x000fca0000011480ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000000401c30723cULL, 0x000b6e0000001830ULL,
0x0000001300687306ULL, 0x0007e20000200c00ULL, 0x000054107b407816ULL, 0x022fe4000000007aULL,
0x000054107c417816ULL, 0x004fca0000000075ULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x011800003f10783bULL, 0x008ea20000000200ULL, 0x000000401c34723cULL, 0x000bec0000001834ULL,
0x0000006300637306ULL, 0x000ee20000200c00ULL, 0x0001000015407824ULL, 0x020fe200078e00ffULL,
0x0000541074157816ULL, 0x000fc40000000077ULL, 0x0000888016747816ULL, 0x000fe400000000ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000001400417306ULL, 0x0003f00000200c00ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x0000541079147816ULL, 0x002fce0000000078ULL,
0x000000141c38723cULL, 0x000be20000001838ULL, 0x0000006e006e7306ULL, 0x000fec0000200c00ULL,
0x0000541073147816ULL, 0x020fe40000000066ULL, 0x0000541072157816ULL, 0x008fe20000000063ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000000210108232ULL, 0x084fe20000000000ULL,
0x000000ffff637224ULL, 0x000fe200078e0074ULL, 0x0000000212128232ULL, 0x000fc40000000000ULL,
0x0000000011118232ULL, 0x080fe20000000000ULL, 0x000000141c18723cULL, 0x000b620000001818ULL,
0x0000000013138232ULL, 0x000fe20000000000ULL, 0x0000006f006f7306ULL, 0x000e6a0000200c00ULL,
0x0000010016147824ULL, 0x060fe200078e00ffULL, 0x00008880171e7816ULL, 0x040fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x00000100171f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000054106c157816ULL, 0x002fce000000006fULL,
0x0000006900697306ULL, 0x000e700000200c00ULL, 0x0000006a006a7306ULL, 0x000eb00000200c00ULL,
0x00000014001c7306ULL, 0x0007f00000200c00ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054106d147816ULL, 0x008fce000000006eULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000541069147816ULL, 0x022fe40000000062ULL, 0x000054106a157816ULL, 0x004fca0000000061ULL,
0x0000004300437306ULL, 0x000e640000200c00ULL, 0x000000141024723cULL, 0x000b6c0000001824ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000541067147816ULL, 0x028fe40000000064ULL,
0x0000541042157816ULL, 0x002fca0000000043ULL, 0x0000005f005f7306ULL, 0x000e640000200c00ULL,
0x000000141028723cULL, 0x000b6c0000001828ULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x0001000017147824ULL, 0x020fce00078e00ffULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000541068157816ULL, 0x002fe4000000005fULL, 0x00000018ff427819ULL, 0x000fca0000011414ULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x0000541065147816ULL, 0x004fce0000000060ULL,
0x0000008300717306ULL, 0x000fe20000200c00ULL, 0x00000014102c723cULL, 0x000b6e000000182cULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000054106b147816ULL, 0x022fce0000000070ULL,
0x0000005d005d7306ULL, 0x000ff00000200c00ULL, 0x0000004000407306ULL, 0x000e620000200c00ULL,
0x0000541071157816ULL, 0x004fce0000000076ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000000141030723cULL, 0x000b6e0000001830ULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x0000541040157816ULL, 0x022fce000000005dULL, 0x0000001600177306ULL, 0x000e700000200c00ULL,
0x0000004200427306ULL, 0x000eb00000200c00ULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x00005410175c7816ULL, 0x002fc4000000005cULL, 0x00005410425d7816ULL, 0x004fca000000005bULL,
0x00000063001d7306ULL, 0x000e640000200c00ULL, 0x0000005c1018723cULL, 0x000f620000001818ULL,
0x0000541041147816ULL, 0x008fca000000005eULL, 0x0000001e001e7306ULL, 0x000fe40000200c00ULL,
0x000000141034723cULL, 0x000b6c0000001834ULL, 0x0000001f001f7306ULL, 0x000ea20000200c00ULL,
0x000054101d147816ULL, 0x022fe4000000001cULL, 0x000054101e157816ULL, 0x004fce000000001fULL,
0x000000141038723cULL, 0x000b6e0000001838ULL, 0x000176c80e147811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008006117811ULL, 0x000fe200078e40ffULL,
0x0176900046ff7f8cULL, 0x0005e2000c80043fULL, 0x0000000205417810ULL, 0x000fc40007ffe0ffULL,
0x0000003e1100720cULL, 0x000fe40003f06070ULL, 0x0000000104137812ULL, 0x000fd600078ec0ffULL,
0x00004f3000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x000004004b127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004004b127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000103d127824ULL, 0x000fe200078e00ffULL, 0x0000000106107810ULL, 0x000fe20007ffe0ffULL,
0x0000580009097a24ULL, 0x010fc600078e02ffULL, 0x0000000f1000720cULL, 0x000fe20003f06070ULL,
0x0000004009097824ULL, 0x000fe200078e00ffULL, 0xffffffe012117812ULL, 0x000fca00078ec0ffULL,
0x0000010006117824ULL, 0x000fca00078e0211ULL, 0x000000c011117810ULL, 0x000fc80007ffe0ffULL,
0x000000200a147812ULL, 0x000fe200078ef811ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000010121f7812ULL, 0x000fe200078ec0ffULL, 0x000000100d1c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe4000001160dULL, 0x000000113e107217ULL, 0x000fe40007800000ULL,
0x00000004161e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000116177824ULL, 0x000fe200078e021fULL,
0x000000701c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x0000000816427810ULL, 0x000fe20007ffe0ffULL, 0x0000000117127824ULL, 0x000fc400078e0214ULL,
0x000000011e407824ULL, 0x100fe200078e021fULL, 0x000000101f107217ULL, 0x000fe20007800000ULL,
0x0000000142437824ULL, 0x100fe200078e021fULL, 0x0000001209127210ULL, 0x000fe20007f1e0ffULL,
0x0000000840417824ULL, 0x000fe400078e00ffULL, 0x0000000110157824ULL, 0x000fe400078e0a1fULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x00005e0012117a11ULL, 0x000fe200078038ffULL,
0x0000000140107824ULL, 0x000fc600078e0214ULL, 0x00005f0012137a11ULL, 0x000fe200000f3c13ULL,
0x0000000117127824ULL, 0x040fe200078e020dULL, 0x000000151600720cULL, 0x080fe20003f06070ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x00000010091d7210ULL, 0x000fe40007fde0ffULL,
0x0000001c11107210ULL, 0x080fe40007fbe0ffULL, 0xfffffff817177812ULL, 0x000fe200078ee212ULL,
0x000000ffff127224ULL, 0x000fe400030e06ffULL, 0x000000ffff117224ULL, 0x000fe200028e0613ULL,
0x000000151e00720cULL, 0x000fe20003fa6070ULL, 0x0000001017177824ULL, 0x000fe200078e025aULL,
0x00005e001d137a11ULL, 0x000fe200078c38ffULL, 0x00000001401e7824ULL, 0x000fe200078e020dULL,
0x0000000c16407810ULL, 0x000fe20007ffe0ffULL, 0x0000000143167824ULL, 0x000fe200078e0214ULL,
0x00005f001d1d7a11ULL, 0x000fe200030f3c12ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e2000c101c46ULL, 0x0000001c13127210ULL, 0x000fe20007f1e0ffULL,
0x00000001401f7824ULL, 0x000fe200078e021fULL, 0xfffffff841417812ULL, 0x000fe200078ee21eULL,
0x00000008431e7824ULL, 0x000fe200078e00ffULL, 0x0000001609167210ULL, 0x000fe20007fde0ffULL,
0x000000011f147824ULL, 0x000fc400078e0214ULL, 0x000000ffff137224ULL, 0x000fe200000e061dULL,
0x000000154200720cULL, 0x000fe20003f06070ULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x0000001409147210ULL, 0x000fe20007fde0ffULL, 0x0000001041177824ULL, 0x002fc800078e025aULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x0000000012177faeULL, 0x0003e2000e901c46ULL,
0x00005e0016117a11ULL, 0x000fc800078a38ffULL, 0x00005f0016167a11ULL, 0x000fe400028f3c1dULL,
0x0000001c11107210ULL, 0x000fe40007fde0ffULL, 0x000000154000720cULL, 0x000fe20003fa6070ULL,
0x0000000143157824ULL, 0x100fe400078e020dULL, 0x000000ffff117224ULL, 0x000fe200030e0616ULL,
0x00005e0014137a11ULL, 0x002fe200078c38ffULL, 0x000000011f167824ULL, 0x040fe200078e020dULL,
0xfffffff81e157812ULL, 0x000fe200078ee215ULL, 0x000000081f177824ULL, 0x000fe200078e00ffULL,
0x00005f0014147a11ULL, 0x000fc400030f3c09ULL, 0x0000001c13127210ULL, 0x000fe20007fde0ffULL,
0x0000001015097824ULL, 0x000fe200078e025aULL, 0xfffffff817177812ULL, 0x000fc600078ee216ULL,
0x000000ffff137224ULL, 0x000fe200030e0614ULL, 0x0000000010097faeULL, 0x0003e2000c101c46ULL,
0x0000001017157824ULL, 0x000fca00078e025aULL, 0x0000000012157faeULL, 0x0003e2000e901c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001012127812ULL, 0x000fe200078ec0ffULL,
0x000000100d1c7824ULL, 0x000fc600078e00ffULL, 0x000000120d117211ULL, 0x000fe400078fe8ffULL,
0x000000701c1c7812ULL, 0x000fe400078ec0ffULL, 0x0000000411137810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x040fe200078e0214ULL, 0x0000000c11177810ULL, 0x040fe20007ffe0ffULL,
0x0000000111127824ULL, 0x140fe400078e020dULL, 0x00000008111f7824ULL, 0x000fe200078e00ffULL,
0x0000001009417210ULL, 0x000fe20007f1e0ffULL, 0x0000000113157824ULL, 0x000fc400078e020dULL,
0x0000000813167824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005e00411d7a11ULL, 0x000fe200078038ffULL,
0x0000000113107824ULL, 0x000fe200078e0214ULL, 0xfffffff816437812ULL, 0x000fe200078ee215ULL,
0x00000008175d7824ULL, 0x000fe200078e00ffULL, 0x0000000811157810ULL, 0x000fe40007ffe0ffULL,
0x00005f0041417a11ULL, 0x000fe400000f3c12ULL, 0x0000001009107210ULL, 0x000fe20007f1e0ffULL,
0x0000000115127824ULL, 0x000fc400078e0214ULL, 0x0000000117147824ULL, 0x000fe400078e0214ULL,
0x0000000115167824ULL, 0x000fe200078e020dULL, 0x0000001209127210ULL, 0x000fe20007fbe0ffULL,
0x00000008155b7824ULL, 0x000fe200078e00ffULL, 0x0000001409147210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e0010137a11ULL, 0x040fe400078038ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee216ULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005f0010167a11ULL, 0x000fe200000f3c11ULL, 0x0000000117107824ULL, 0x000fe200078e020dULL,
0x00005e0012157a11ULL, 0x000fe200078038ffULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00005e0014177a11ULL, 0x000fc400078a38ffULL, 0xfffffff85d5d7812ULL, 0x000fe400078ee210ULL,
0x00005f0012407a11ULL, 0x000fe400000f3c11ULL, 0x00005f00141e7a11ULL, 0x000fe200028f3c09ULL,
0x000000101f097824ULL, 0x100fe200078e025aULL, 0x0000001c1d107210ULL, 0x080fe20007f1e0ffULL,
0x00000010431d7824ULL, 0x100fe200078e025aULL, 0x0000001c13127210ULL, 0x080fe20007fbe0ffULL,
0x000000105b1f7824ULL, 0x000fe400078e025aULL, 0x000000ffff117224ULL, 0x000fe200000e0641ULL,
0x0000001c15147210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e0616ULL,
0x0000001c17167210ULL, 0x000fe20007fbe0ffULL, 0x000000105d417824ULL, 0x000fe200078e025aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fc400000e0640ULL, 0x000000ffff177224ULL, 0x000fe200028e061eULL,
0x00000000121d7faeULL, 0x0003e8000b901c46ULL, 0x00000000141f7faeULL, 0x0003e8000b901c46ULL,
0x0000000016417faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000305117810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x0000003c1100720cULL, 0x000fda0003fa6070ULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x0000000108107824ULL, 0x000fe400078e0211ULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610097981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000550403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a800457c7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017648004a107f8cULL, 0x0022a4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x01764c004a157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c004a157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001001c117810ULL, 0x000fca0007ffe049ULL,
0x0000000148117824ULL, 0x000fca00078e0211ULL, 0x0170000011137984ULL, 0x000e680000000800ULL,
0x0172000011127984ULL, 0x0004e20000000800ULL, 0x000000581300720bULL, 0x002fe20003f1d000ULL,
0x0000bfb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x004fc800000e0100ULL,
0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff5d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff557224ULL, 0x000fd200078e0058ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000020c107810ULL, 0x000fe40007ffe0ffULL,
0x000000581300720bULL, 0x000fe40003f14000ULL, 0x0000003d1000720cULL, 0x000fe20003fa5270ULL,
0x0000bf727f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400000e0100ULL,
0x000000803d11d824ULL, 0x000fe200078e021cULL, 0x000000135810d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x000000014817d824ULL, 0x000fe200078e0211ULL,
0x0000991015117816ULL, 0x000fc800000000ffULL, 0x017400101700d388ULL, 0x0003e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001358117209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL, 0x8000001158107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000167308ULL, 0x000e640000000800ULL,
0x0000001607077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe2000001160dULL, 0x0000bea27f007947ULL, 0x000fea000b800000ULL,
0x00001f1016107589ULL, 0x0002a400000e0000ULL, 0x0000001020207220ULL, 0x084fe40000410000ULL,
0x0000001021217220ULL, 0x080fe40000410000ULL, 0x0000001024247220ULL, 0x080fe40000410000ULL,
0x0000001025257220ULL, 0x000fc40000410000ULL, 0x0000001028287220ULL, 0x080fe40000410000ULL,
0x0000001029297220ULL, 0x080fe40000410000ULL, 0x000000102c2c7220ULL, 0x080fe40000410000ULL,
0x000000102d2d7220ULL, 0x080fe40000410000ULL, 0x0000001030307220ULL, 0x080fe40000410000ULL,
0x0000001031317220ULL, 0x000fc40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x080fe40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x080fe40000410000ULL, 0x0000001018187220ULL, 0x080fe40000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d107811ULL, 0x000fe200078ff0ffULL, 0x0000bdb27f007947ULL, 0x000fea000b800000ULL,
0x00001f1016107589ULL, 0x00046400000e0000ULL, 0x0000001022227220ULL, 0x082fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x080fe40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x000fc40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x080fe40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fe20007800814ULL, 0x00000001ff5d7424ULL, 0x000fe200078e00ffULL,
0x0000001358557209ULL, 0x000fd60007810000ULL, 0x8000005513130221ULL, 0x000fe20000010000ULL,
0x00007610ff5d0816ULL, 0x000fc6000000005dULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300030308ULL, 0x000e640000000800ULL, 0x0000000312120220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000712077221ULL, 0x008fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0176ac0054127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0054127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099105d107816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x000fe20000000000ULL,
0x0000b9b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1312027589ULL, 0x0002e400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x0000ba027f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00007e80001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000c23000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e0012ULL, 0x00007ef0001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000c1c000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000100004107824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000157567824ULL, 0x040fe400078e0256ULL, 0x0000000857577824ULL, 0x000fe200078e00ffULL,
0x0000100010117812ULL, 0x000fca00078ec0ffULL, 0x000020000e107824ULL, 0x000fe200078e0211ULL,
0xfffffff857117812ULL, 0x000fc800078ee256ULL, 0x0001300010567810ULL, 0x000fca0007ffe0ffULL,
0x00000010111c7824ULL, 0x100fe400078e0256ULL, 0x0000001051407824ULL, 0x100fe400078e0256ULL,
0x000000104e107824ULL, 0x100fe400078e0256ULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x000000104f147824ULL, 0x000fc600078e0256ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x000000001010783bULL, 0x000ee80000004200ULL, 0x000000001414783bULL, 0x004ea20000004200ULL,
0x00000018ff817819ULL, 0x002fe2000001141cULL, 0x000001001c5e7824ULL, 0x040fe200078e00ffULL,
0x000088801c847816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe2000001141dULL, 0x000001001d607824ULL, 0x040fe200078e00ffULL,
0x000088801d637816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000010011677824ULL, 0x048fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0001000011617824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fc4000001141eULL, 0x00000018ff6a7819ULL, 0x000fe2000001141fULL,
0x0000001c00827306ULL, 0x0003e20000200c00ULL, 0x000088801e807816ULL, 0x000fe400000000ffULL,
0x000088801f697816ULL, 0x000fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011410ULL,
0x0000888010657816ULL, 0x000fe200000000ffULL, 0x0000001d00837306ULL, 0x0007e20000200c00ULL,
0x000001001e1c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fc40000011411ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005e00857306ULL, 0x0002a20000200c00ULL,
0x00000100411d7824ULL, 0x008fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000888011647816ULL, 0x000fe200000000ffULL, 0x0000010012117824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c007f7306ULL, 0x0007e20000200c00ULL,
0x000001001f5e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888040787816ULL, 0x000fc400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000001d00767306ULL, 0x0003e20000200c00ULL,
0x00000100401c7824ULL, 0x008fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000888041737816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001e007a7306ULL, 0x000fe20000200c00ULL, 0x00000100431d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fc40000011442ULL, 0x00000018ff5c7819ULL, 0x000fe40000011443ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00777306ULL, 0x0003e20000200c00ULL,
0x0000888042727816ULL, 0x000fe400000000ffULL, 0x00008880436d7816ULL, 0x040fe200000000ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011440ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011441ULL,
0x0000001f007b7306ULL, 0x000fe20000200c00ULL, 0x00000100421c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000001d00707306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff597819ULL, 0x000fe40000011412ULL, 0x00000018ff587819ULL, 0x000fe20000011413ULL,
0x0000001c006f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff577819ULL, 0x004fe40000011414ULL,
0x00000018ff517819ULL, 0x000fc40000011415ULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x00000100101c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe20000011416ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011417ULL,
0x00000018ff667819ULL, 0x000fe4000001141cULL, 0x01200000441c783bULL, 0x000e620000000200ULL,
0x00000018ff627819ULL, 0x000fe20000011410ULL, 0x0000006000867306ULL, 0x0004e20000200c00ULL,
0x000099105d107816ULL, 0x000fc800000000ffULL, 0x000000ff1000720cULL, 0x000fe40003f05270ULL,
0x0000541084107816ULL, 0x000fe20000000085ULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x0000888012607816ULL, 0x004fce00000000ffULL, 0x0000006800687306ULL, 0x000eb00000200c00ULL,
0x0000007900797306ULL, 0x000ff00000200c00ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000000021c1c8232ULL, 0x002fce0000000000ULL, 0x00000011005d7306ULL, 0x0007e20000200c00ULL,
0x000000021e1e8232ULL, 0x000fe40000000000ULL, 0x000000001d1d8232ULL, 0x080fe40000000000ULL,
0x000000001f1f8232ULL, 0x000fc60000000000ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x0000541063117816ULL, 0x008fce0000000086ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000000101c20723cULL, 0x000b6e0000001820ULL, 0x0000005e007e7306ULL, 0x0006620000200c00ULL,
0x0000541082107816ULL, 0x020fe40000000081ULL, 0x0000541083117816ULL, 0x004fca0000000068ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x00010000125e7824ULL, 0x008fe200078e00ffULL,
0x0000888014127816ULL, 0x040fe200000000ffULL, 0x000000101c24723cULL, 0x000b660000001824ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x000000ffff687224ULL, 0x000fe200078e0012ULL,
0x0000007300737306ULL, 0x000ee20000200c00ULL, 0x0000010014127824ULL, 0x000fe200078e00ffULL,
0x0000541080107816ULL, 0x022fe2000000007fULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x0000541069117816ULL, 0x000fc4000000007eULL, 0x00000018ff697819ULL, 0x000fe40000011412ULL,
0x00000042006c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x000000101c28723cULL, 0x000f620000001828ULL, 0x00008880157e7816ULL, 0x000fc800000000ffULL,
0x00000043006b7306ULL, 0x0005e20000200c00ULL, 0x0000888013427816ULL, 0x002fce00000000ffULL,
0x0000004000747306ULL, 0x0003e20000200c00ULL, 0x0000010013437824ULL, 0x044fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004100757306ULL, 0x0005e20000200c00ULL, 0x000054107a407816ULL, 0x002fe20000000079ULL,
0x0000010015797824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fca0000011413ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000054107b417816ULL, 0x004fce000000006aULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x000000401c2c723cULL, 0x000b6e000000182cULL,
0x0000541078407816ULL, 0x020fe20000000077ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541073417816ULL, 0x008fc40000000076ULL, 0x00000018ff737819ULL, 0x000fca0000011479ULL,
0x0000006d006d7306ULL, 0x000ee20000200c00ULL, 0x000000401c30723cULL, 0x000b6e0000001830ULL,
0x0000001300637306ULL, 0x0007e20000200c00ULL, 0x0000541074407816ULL, 0x022fe40000000071ULL,
0x0000541075417816ULL, 0x004fca000000006eULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x012000003f10783bULL, 0x008ea20000000200ULL, 0x000000401c34723cULL, 0x000b6c0000001834ULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x0001000015417824ULL, 0x020fe200078e00ffULL,
0x000054106d157816ULL, 0x000fc40000000070ULL, 0x00008880166d7816ULL, 0x000fe400000000ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000001400407306ULL, 0x0003f00000200c00ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541072147816ULL, 0x002fce000000006fULL,
0x000000141c38723cULL, 0x000b620000001838ULL, 0x0000006600667306ULL, 0x000fec0000200c00ULL,
0x000054106c147816ULL, 0x020fe4000000005fULL, 0x000054106b157816ULL, 0x008fe2000000005cULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000000210108232ULL, 0x084fe20000000000ULL,
0x000000ffff5c7224ULL, 0x000fe200078e006dULL, 0x0000000212128232ULL, 0x000fc40000000000ULL,
0x0000000011118232ULL, 0x080fe20000000000ULL, 0x000000141c18723cULL, 0x000b620000001818ULL,
0x0000000013138232ULL, 0x000fe20000000000ULL, 0x0000006700677306ULL, 0x000e6a0000200c00ULL,
0x0000010016147824ULL, 0x060fe200078e00ffULL, 0x00008880171e7816ULL, 0x040fe200000000ffULL,
0x00000100171f7824ULL, 0x040fe200078e00ffULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541064157816ULL, 0x002fe40000000067ULL, 0x00000018ff177819ULL, 0x000fca0000011417ULL,
0x0000006200627306ULL, 0x000e700000200c00ULL, 0x0000006100617306ULL, 0x000eb00000200c00ULL,
0x00000014001c7306ULL, 0x0007f00000200c00ULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x0000541065147816ULL, 0x008fce0000000066ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000004300437306ULL, 0x000ee20000200c00ULL,
0x0000541062147816ULL, 0x022fe4000000005bULL, 0x0000541061157816ULL, 0x004fca000000005aULL,
0x0000006800687306ULL, 0x000fe40000200c00ULL, 0x000000141024723cULL, 0x000b6c0000001824ULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x0000541060147816ULL, 0x020fe4000000005dULL,
0x0000541042157816ULL, 0x008fca0000000043ULL, 0x0000005c001d7306ULL, 0x000ea40000200c00ULL,
0x000000141028723cULL, 0x000b6c0000001828ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0000541068687816ULL, 0x002fce0000000069ULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x000054101d1c7816ULL, 0x004fce000000001cULL, 0x0000005700577306ULL, 0x000eb00000200c00ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x00005410635f7816ULL, 0x002fce0000000058ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000541040407816ULL, 0x004fce0000000057ULL,
0x0000004f004f7306ULL, 0x000ff00000200c00ULL, 0x0000005e005e7306ULL, 0x000e700000200c00ULL,
0x0000007e006a7306ULL, 0x000ff00000200c00ULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x000054105e5e7816ULL, 0x002fce0000000059ULL, 0x00000041006e7306ULL, 0x000e620000200c00ULL,
0x0000005e102c723cULL, 0x000b6e000000182cULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x000054106a697816ULL, 0x004fce0000000073ULL, 0x0000001f001f7306ULL, 0x000ea20000200c00ULL,
0x000054106e417816ULL, 0x002fe20000000051ULL, 0x000000681030723cULL, 0x040b6c0000001830ULL,
0x0000001600157306ULL, 0x020e640000200c00ULL, 0x000000401034723cULL, 0x000b6c0000001834ULL,
0x0000001700147306ULL, 0x000ee20000200c00ULL, 0x000054101e1d7816ULL, 0x004fc4000000001fULL,
0x00005410154e7816ULL, 0x002fca000000004eULL, 0x0000001c1038723cULL, 0x000b620000001838ULL,
0x00005410144f7816ULL, 0x008fe4000000004fULL, 0x000176c80e147811ULL, 0x000fca00078e18ffULL,
0x0000004e1018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c006117811ULL, 0x020fe200078e40ffULL,
0x0176980046ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff137224ULL, 0x000fe200078e0047ULL,
0x0000000305417810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x000fe200078e0055ULL,
0x0000003e1100720cULL, 0x000fe20003f06070ULL, 0x000000ffff597224ULL, 0x000fd800078e007dULL,
0x000026f000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x000004004b127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004004b127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000206127810ULL, 0x040fe20007ffe0ffULL, 0x0000010006107824ULL, 0x000fe400078e020bULL,
0x0000580009097a24ULL, 0x010fe200078e02ffULL, 0x0000000f1200720cULL, 0x000fe40003f06070ULL,
0x0000010010117810ULL, 0x000fe20007ffe0ffULL, 0x0000004009097824ULL, 0x000fc600078e00ffULL,
0x000000200a137812ULL, 0x000fce00078ef811ULL, 0x0000048000008947ULL, 0x000fea0003800000ULL,
0x000000103d107824ULL, 0x000fe200078e00ffULL, 0x00000003ff1c7819ULL, 0x000fe2000001160dULL,
0x000000100d147824ULL, 0x000fc600078e00ffULL, 0x00000010101f7812ULL, 0x000fe400078ec0ffULL,
0x000000113e107217ULL, 0x000fe40007800000ULL, 0x000000041c407810ULL, 0x040fe20007ffe0ffULL,
0x000000011c1e7824ULL, 0x000fe400078e021fULL, 0x0000000110107824ULL, 0x000fe400078e0a11ULL,
0x000000011e127824ULL, 0x000fe400078e0213ULL, 0x0000000140427824ULL, 0x000fe200078e021fULL,
0x000000101f107217ULL, 0x000fe20007800000ULL, 0x000000081e177824ULL, 0x000fe200078e00ffULL,
0x0000001209127210ULL, 0x000fe20007f1e0ffULL, 0x0000000842417824ULL, 0x000fc400078e00ffULL,
0x0000000110167824ULL, 0x000fe400078e0a1fULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e0012117a11ULL, 0x000fe200078038ffULL, 0x0000000142107824ULL, 0x000fc600078e0213ULL,
0x00005f0012157a11ULL, 0x000fe400000f3c15ULL, 0x0000007014127812ULL, 0x000fe200078ec0ffULL,
0x000000011e147824ULL, 0x100fe200078e020dULL, 0x00000010091d7210ULL, 0x000fe20007fde0ffULL,
0x00000001421e7824ULL, 0x000fe200078e020dULL, 0x0000001211107210ULL, 0x000fe40007fbe0ffULL,
0x000000161c00720cULL, 0x080fe40003f06070ULL, 0xfffffff817177812ULL, 0x000fe200078ee214ULL,
0x000000ffff117224ULL, 0x000fe200028e0615ULL, 0x000000164000720cULL, 0x000fe20003fa6070ULL,
0x000000ffff147224ULL, 0x000fe200030e06ffULL, 0x000000081c407810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e0256ULL, 0x00005e001d157a11ULL, 0x000fc400078c38ffULL,
0x0000000c1c427810ULL, 0x000fe20007ffe0ffULL, 0x00000001404e7824ULL, 0x000fe200078e021fULL,
0x00005f001d1d7a11ULL, 0x000fe200030f3c14ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e2000c101c46ULL, 0x0000001215147210ULL, 0x000fe20007f1e0ffULL,
0x000000014e1c7824ULL, 0x000fe200078e0213ULL, 0xfffffff841417812ULL, 0x000fe200078ee21eULL,
0x00000001421e7824ULL, 0x000fe400078e021fULL, 0x000000ffff157224ULL, 0x000fe200000e061dULL,
0x0000001c091c7210ULL, 0x000fe20007fde0ffULL, 0x000000084e1f7824ULL, 0x000fe200078e00ffULL,
0x000000164000720cULL, 0x000fe20003f06070ULL, 0x000000011e1d7824ULL, 0x000fc400078e020dULL,
0x0000001041177824ULL, 0x002fe400078e0256ULL, 0x000000011e107824ULL, 0x000fe400078e0213ULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x00005e001c117a11ULL, 0x000fe200078a38ffULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0x0000001009097210ULL, 0x000fe40007fde0ffULL, 0x00005f001c137a11ULL, 0x000fc400028f3c13ULL,
0x000000164200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0000001211107210ULL, 0x000fe20007fde0ffULL, 0x000000014e167824ULL, 0x000fe200078e020dULL,
0xfffffff81e1d7812ULL, 0x000fc600078ee21dULL, 0x000000ffff117224ULL, 0x000fe200030e0613ULL,
0x00005e0009157a11ULL, 0x002fe400078c38ffULL, 0xfffffff81f177812ULL, 0x000fe400078ee216ULL,
0x00005f0009137a11ULL, 0x000fe400030f3c1cULL, 0x0000001215147210ULL, 0x000fe20007fde0ffULL,
0x0000001017097824ULL, 0x000fc800078e0256ULL, 0x000000ffff157224ULL, 0x000fe200030e0613ULL,
0x0000000010097faeULL, 0x0003e2000c101c46ULL, 0x000000101d137824ULL, 0x000fca00078e0256ULL,
0x0000000014137faeULL, 0x0003e2000e901c46ULL, 0x000003b000007947ULL, 0x000fea0003800000ULL,
0x000000103d107824ULL, 0x000fca00078e00ffULL, 0x0000001010107812ULL, 0x000fc800078ec0ffULL,
0x000000100d127211ULL, 0x000fc800078fe8ffULL, 0x0000000412147810ULL, 0x040fe20007ffe0ffULL,
0x0000000112107824ULL, 0x040fe400078e0213ULL, 0x0000000112117824ULL, 0x140fe400078e020dULL,
0x00000008121c7824ULL, 0x000fe200078e00ffULL, 0x0000001009167210ULL, 0x000fe20007f1e0ffULL,
0x0000000114157824ULL, 0x040fe400078e020dULL, 0x00000008141e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c417812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e00161f7a11ULL, 0x000fe200078038ffULL, 0x0000000114107824ULL, 0x000fe200078e0213ULL,
0xfffffff81e437812ULL, 0x000fc400078ee215ULL, 0x00000008121e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c12147810ULL, 0x000fe40007ffe0ffULL, 0x00005f0016167a11ULL, 0x000fe200000f3c11ULL,
0x000000011e127824ULL, 0x100fe200078e0213ULL, 0x00000010091c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000114107824ULL, 0x000fe400078e0213ULL, 0x000000011e137824ULL, 0x040fe200078e020dULL,
0x0000001209407210ULL, 0x040fe20007fbe0ffULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0x0000001009107210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e001c157a11ULL, 0x000fe200078038ffULL, 0x000000100d127824ULL, 0x000fe200078e00ffULL,
0xfffffff81e477812ULL, 0x000fe200078ee213ULL, 0x0000000114137824ULL, 0x000fe200078e020dULL,
0x00005f001c1c7a11ULL, 0x000fe200000f3c11ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00005e0040177a11ULL, 0x000fe200078038ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005e00101d7a11ULL, 0x000fe200078a38ffULL, 0x0000000814147824ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc400078ec0ffULL, 0x00005f0040407a11ULL, 0x000fe400000f3c11ULL,
0x00005f00101e7a11ULL, 0x000fe200028f3c09ULL, 0x0000001041097824ULL, 0x100fe200078e0256ULL,
0xfffffff8144b7812ULL, 0x000fe200078ee213ULL, 0x0000001043137824ULL, 0x100fe200078e0256ULL,
0x000000121f107210ULL, 0x080fe20007f1e0ffULL, 0x00000010471f7824ULL, 0x100fe200078e0256ULL,
0x0000001215147210ULL, 0x080fe20007fbe0ffULL, 0x000000104b417824ULL, 0x000fe400078e0256ULL,
0x000000ffff117224ULL, 0x000fe200000e0616ULL, 0x0000001217167210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e061cULL, 0x000000121d1c7210ULL, 0x000fc40007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fe400000e0640ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061eULL,
0x0000000014137faeULL, 0x0003e8000b901c46ULL, 0x00000000161f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c417faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000405117810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x0000003c1100720cULL, 0x000fda0003fa6070ULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x0000000108107824ULL, 0x000fe400078e0211ULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610097981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000530403c2ULL, 0x000ea40000080000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000270f070ULL, 0xffffff8000004947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80054587f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017668004a167f8cULL, 0x0002a4000c80043fULL,
0x0000000000107805ULL, 0x002fc40000015200ULL, 0x01766c004a137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x006fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011415ULL, 0x0000001413137211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000213137819ULL, 0x000fc80000001214ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01766c004a137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018012497810ULL, 0x000fca0007ffe049ULL,
0x0000000148497824ULL, 0x000fca00078e0249ULL, 0x0170000049147984ULL, 0x000e680000000800ULL,
0x0172000049167984ULL, 0x0004e20000000800ULL, 0x000000551400720bULL, 0x002fe20003f1d000ULL,
0x00009a027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x004fc800000e0100ULL,
0x0000ffff13ff7812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff157424ULL, 0x000fe400078e00ffULL, 0x000000ffff587224ULL, 0x008fd200078e0055ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000030c107810ULL, 0x000fe40007ffe0ffULL,
0x000000551400720bULL, 0x000fe40003f14000ULL, 0x0000003d1000720cULL, 0x000fe20003fa5270ULL,
0x000099c27f007947ULL, 0x000fd4000b800000ULL, 0x00000000001c7806ULL, 0x000fc400000e0100ULL,
0x000000803d11d824ULL, 0x000fe200078e0212ULL, 0x0000005514587209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099101c107816ULL, 0x000fe200000000ffULL,
0x000000014811d824ULL, 0x000fc600078e0211ULL, 0x000000ff1000720cULL, 0x000fe40003f05270ULL,
0x017400581100d388ULL, 0x0003f60000000800ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000005558107221ULL, 0x002fe20000010100ULL, 0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000127308ULL, 0x000e640000000800ULL, 0x0000001207077220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x000099027f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x0002a400000e0000ULL,
0x0000001020207220ULL, 0x084fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x000fc40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x080fe40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001035357220ULL, 0x000fc40000410000ULL,
0x0000001038387220ULL, 0x080fe40000410000ULL, 0x0000001039397220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x000098127f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x0004e400000e0000ULL,
0x0000001022227220ULL, 0x088fe40000410000ULL, 0x0000001023237220ULL, 0x080fe40000410000ULL,
0x0000001026267220ULL, 0x080fe40000410000ULL, 0x0000001027277220ULL, 0x080fe40000410000ULL,
0x000000102a2a7220ULL, 0x080fe40000410000ULL, 0x000000102b2b7220ULL, 0x000fc40000410000ULL,
0x000000102e2e7220ULL, 0x080fe40000410000ULL, 0x000000102f2f7220ULL, 0x080fe40000410000ULL,
0x0000001032327220ULL, 0x080fe40000410000ULL, 0x0000001033337220ULL, 0x080fe40000410000ULL,
0x0000001036367220ULL, 0x080fe40000410000ULL, 0x0000001037377220ULL, 0x000fc40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000101a1a7220ULL, 0x080fe40000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff1cff7812ULL, 0x000fe20007800813ULL,
0x00000001ff157424ULL, 0x000fd800078e00ffULL, 0x0000001458140221ULL, 0x000fe20000010100ULL,
0x00007610ff150816ULL, 0x000fc60000000015ULL, 0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL,
0x0000001400030308ULL, 0x000e640000000800ULL, 0x0000000316160220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000716077221ULL, 0x000fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0176ac0045137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780487dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x004fcc0000015200ULL,
0x0000001210177210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0045137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780487dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991015107816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x004fe20000000000ULL,
0x000094227f007947ULL, 0x000fea000b800000ULL, 0x00001f1312027589ULL, 0x0002a400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x000094727f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000a6a0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00009a1000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e0012ULL, 0x0000a710001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x000099a000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000521c783bULL, 0x000ee80000004200ULL,
0x000000005040783bULL, 0x0004680000004200ULL, 0x000000004d10783bULL, 0x00ee680000004200ULL,
0x000000004c14783bULL, 0x0004e20000004200ULL, 0x00000018ff707819ULL, 0x000fe2000001141cULL,
0x000001001c507824ULL, 0x040fe200078e00ffULL, 0x000088801c767816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001141dULL,
0x000001001d517824ULL, 0x040fe200078e00ffULL, 0x000088801d5b7816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff567819ULL, 0x000fe4000001141eULL,
0x00000018ff577819ULL, 0x000fe2000001141fULL, 0x0000001c00717306ULL, 0x0003e20000200c00ULL,
0x00000018ff627819ULL, 0x000fe40000011440ULL, 0x000088801e6f7816ULL, 0x000fe400000000ffULL,
0x000088801f647816ULL, 0x000fc400000000ffULL, 0x00008880406b7816ULL, 0x040fe200000000ffULL,
0x0000001d00727306ULL, 0x0005e20000200c00ULL, 0x000001001f1c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe20000011441ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000888041687816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005000737306ULL, 0x0003e20000200c00ULL, 0x00000100401d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc40000011442ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c006d7306ULL, 0x0005e20000200c00ULL, 0x000001001e507824ULL, 0x042fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000888042637816ULL, 0x000fe400000000ffULL, 0x00000018ff477819ULL, 0x000fe40000011410ULL,
0x0000001d006a7306ULL, 0x0003e20000200c00ULL, 0x00000100411c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fc40000011451ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000004000677306ULL, 0x000fe20000200c00ULL, 0x00000100421d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00697306ULL, 0x0003e20000200c00ULL, 0x00000018ff427819ULL, 0x000fc40000011442ULL,
0x00000018ff4d7819ULL, 0x000fe40000011411ULL, 0x00000018ff4f7819ULL, 0x000fe40000011443ULL,
0x00008880435e7816ULL, 0x040fe200000000ffULL, 0x0000001d00607306ULL, 0x0005e20000200c00ULL,
0x00000100431c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011412ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011413ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000001e00657306ULL, 0x000fe20000200c00ULL,
0x00000100101d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff487819ULL, 0x008fe40000011414ULL, 0x00000018ff407819ULL, 0x000fe4000001141dULL,
0x0000001f006c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fe40000011415ULL,
0x00000018ff457819ULL, 0x000fc40000011416ULL, 0x00000018ff4a7819ULL, 0x000fc60000011417ULL,
0x0000001c00617306ULL, 0x0003f00000200c00ULL, 0x0000004100667306ULL, 0x0005e20000200c00ULL,
0x01280000441c783bULL, 0x0022ee0000000200ULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x0000888010417816ULL, 0x044fe200000000ffULL, 0x0001000010107824ULL, 0x000fc400078e00ffULL,
0x0000010012447824ULL, 0x002fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005100747306ULL, 0x0003f00000200c00ULL, 0x0000005600567306ULL, 0x000ea20000200c00ULL,
0x00000018ff517819ULL, 0x002fc40000011444ULL, 0x0000888013447816ULL, 0x000fca00000000ffULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x00000050006e7306ULL, 0x0003e20000200c00ULL,
0x000000021c1c8232ULL, 0x088fe20000000000ULL, 0x0000541065567816ULL, 0x004fe20000000056ULL,
0x000000021e1e8232ULL, 0x000fc40000000000ULL, 0x000000001d1d8232ULL, 0x080fe40000000000ULL,
0x000000001f1f8232ULL, 0x000fe20000000000ULL, 0x0000004200557306ULL, 0x0005e20000200c00ULL,
0x0000010011507824ULL, 0x002fe200078e00ffULL, 0x000054106c577816ULL, 0x000fe20000000057ULL,
0x00000100156c7824ULL, 0x000fca00078e00ffULL, 0x0000001000527306ULL, 0x0003e20000200c00ULL,
0x0000888011427816ULL, 0x044fe200000000ffULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x000000561c2c723cULL, 0x000b68000000182cULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000010013107824ULL, 0x042fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff137819ULL, 0x000fce0000011413ULL,
0x0000006b006b7306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000eb00000200c00ULL,
0x0000001100547306ULL, 0x0007e20000200c00ULL, 0x000054106b567816ULL, 0x022fce000000006aULL,
0x0000001000537306ULL, 0x0003e20000200c00ULL, 0x000054105b117816ULL, 0x008fe40000000074ULL,
0x0000541068577816ULL, 0x004fe40000000069ULL, 0x00000018ff687819ULL, 0x000fc6000001146cULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000541076107816ULL, 0x002fe20000000073ULL,
0x000000561c30723cULL, 0x000fe20000001830ULL, 0x0000888014737816ULL, 0x000fca00000000ffULL,
0x0000006400647306ULL, 0x000e640000200c00ULL, 0x000000101c20723cULL, 0x000b6c0000001820ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x0000541071107816ULL, 0x020fe40000000070ULL,
0x0000541072117816ULL, 0x000fe2000000005dULL, 0x000000ffff5d7224ULL, 0x000fc800078e0073ULL,
0x0000005f005f7306ULL, 0x000ee40000200c00ULL, 0x000000101c24723cULL, 0x000bec0000001824ULL,
0x00000043005c7306ULL, 0x0007e20000200c00ULL, 0x000054106f107816ULL, 0x024fe4000000006eULL,
0x0000541064117816ULL, 0x002fc4000000006dULL, 0x0000541067567816ULL, 0x008fe40000000062ULL,
0x00008880156d7816ULL, 0x000fe200000000ffULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x00000018ff437819ULL, 0x000fe20000011450ULL, 0x000000101c28723cULL, 0x000f620000001828ULL,
0x0000888012507816ULL, 0x040fe200000000ffULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x0000541066577816ULL, 0x000fe2000000005fULL, 0x000000ffff657224ULL, 0x000fe400078e006dULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x00000018ff127819ULL, 0x000fc60000011412ULL,
0x000000561c34723cULL, 0x000b680000001834ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x00005410554e7816ULL, 0x002fe4000000004eULL, 0x0001000015567824ULL, 0x020fca00078e00ffULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x000054105c4f7816ULL, 0x004fe4000000004fULL,
0x00000018ff567819ULL, 0x000fca0000011456ULL, 0x00000012005a7306ULL, 0x0005e20000200c00ULL,
0x0000004e1c18723cULL, 0x000fee0000001818ULL, 0x00000013005b7306ULL, 0x0007e20000200c00ULL,
0x0000010014127824ULL, 0x004fe200078e00ffULL, 0x000054105e157816ULL, 0x002fe20000000061ULL,
0x0001000014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011412ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x012800003f10783bULL, 0x0082a20000000200ULL,
0x0000004900497306ULL, 0x000ef00000200c00ULL, 0x00000014003f7306ULL, 0x0023f00000200c00ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x0000541063147816ULL, 0x002fc40000000060ULL,
0x000054105a5a7816ULL, 0x008fca0000000049ULL, 0x000000141c38723cULL, 0x000b620000001838ULL,
0x0000004000407306ULL, 0x000e6c0000200c00ULL, 0x0000888016157816ULL, 0x060fe200000000ffULL,
0x0000010016147824ULL, 0x040fe200078e00ffULL, 0x00008880171e7816ULL, 0x040fe200000000ffULL,
0x00000100171f7824ULL, 0x040fe200078e00ffULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0000000210108232ULL, 0x084fe20000000000ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000000212128232ULL, 0x000fe20000000000ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x0000541041407816ULL, 0x002fe20000000040ULL,
0x0000000011118232ULL, 0x000fc40000000000ULL, 0x0000000013138232ULL, 0x000fc80000000000ULL,
0x00000015001c7306ULL, 0x000ff00000200c00ULL, 0x00000014001d7306ULL, 0x000e620000200c00ULL,
0x0000541050507816ULL, 0x004fce0000000051ULL, 0x0000004c004c7306ULL, 0x000eb00000200c00ULL,
0x0000004800487306ULL, 0x000ee20000200c00ULL, 0x000054101c1c7816ULL, 0x002fce000000001dULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x000054105b5b7816ULL, 0x004fce000000004cULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x000054103f487816ULL, 0x008fe20000000048ULL,
0x0000005a102c723cULL, 0x000f6c000000182cULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000004200427306ULL, 0x000ff00000200c00ULL, 0x0000004300437306ULL, 0x000e700000200c00ULL,
0x0000004400447306ULL, 0x000eb00000200c00ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0000541042417816ULL, 0x002fce0000000043ULL, 0x0000006400647306ULL, 0x000e620000200c00ULL,
0x0000541044517816ULL, 0x004fe20000000053ULL, 0x000000401020723cULL, 0x040f6c0000001820ULL,
0x0000006500657306ULL, 0x000fe40000200c00ULL, 0x000000501028723cULL, 0x000f6c0000001828ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x000054105d647816ULL, 0x002fce0000000064ULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x0000541065657816ULL, 0x004fce0000000068ULL, 0x0000001f001f7306ULL, 0x000ea20000200c00ULL,
0x0000541056497816ULL, 0x002fe2000000004bULL, 0x000000641030723cULL, 0x040f6c0000001830ULL,
0x0000001600167306ULL, 0x000e640000200c00ULL, 0x000000481034723cULL, 0x000f6c0000001834ULL,
0x0000001700177306ULL, 0x000ee20000200c00ULL, 0x000054101e1d7816ULL, 0x004fc4000000001fULL,
0x0000541016167816ULL, 0x002fca0000000045ULL, 0x0000004700477306ULL, 0x000e620000200c00ULL,
0x0000001c1038723cULL, 0x000f620000001838ULL, 0x0000541017177816ULL, 0x008fcc000000004aULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x000000161018723cULL, 0x000f620000001818ULL,
0x0000541052147816ULL, 0x002fe40000000047ULL, 0x0000541054157816ULL, 0x004fce000000004dULL,
0x000000141024723cULL, 0x000b6e0000001824ULL, 0x000176c80e147811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a00046ff7f8cULL, 0x0005e2000c80043fULL,
0x0000000405417810ULL, 0x000fc40007ffe0ffULL, 0x0000000104137812ULL, 0x000fc400078ec0ffULL,
0x0000000106067810ULL, 0x004fc80007ffe0ffULL, 0x0000000f0600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff5c4000007947ULL, 0x000fea000383ffffULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b6f000047802ULL, 0x000fc40000000f00ULL,
0x0000880000007944ULL, 0x01efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x006e620000000000ULL,
0x00000002ff067819ULL, 0x000fe40000011604ULL, 0x0000000807047811ULL, 0x002fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000002000207220ULL, 0x042fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x040fe40000410000ULL,
0x0000002500257220ULL, 0x000fc40000410000ULL, 0x0000002800287220ULL, 0x040fe40000410000ULL,
0x0000002900297220ULL, 0x040fe40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x000fc40000410000ULL, 0x0000003400347220ULL, 0x040fe40000410000ULL,
0x0000003500357220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x040fe40000410000ULL,
0x0000003900397220ULL, 0x040fe40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x000fc40000410000ULL, 0x0000002204227220ULL, 0x044fe40000410000ULL,
0x0000002304237220ULL, 0x040fe40000410000ULL, 0x0000002604267220ULL, 0x040fe40000410000ULL,
0x0000002704277220ULL, 0x040fe40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x000fc40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x040fe40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000003604367220ULL, 0x040fe40000410000ULL,
0x0000003704377220ULL, 0x000fc40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x040fe40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000010003d067824ULL, 0x000fe200078e00ffULL, 0x000000343535723eULL, 0x000fe400000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000383938723eULL, 0x000fc400000000ffULL,
0x00000018191c723eULL, 0x000fe400000000ffULL, 0x0000002a2b2a723eULL, 0x000fe400000000ffULL,
0x0000002e2f15723eULL, 0x00afe400000000ffULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x000054102a147816ULL, 0x140fe40000000015ULL, 0x000076322a157816ULL, 0x000fc40000000015ULL,
0x00000002ff057819ULL, 0x000fe40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x0000000805097824ULL, 0x050fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x0000000807107824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x000000363719723eULL, 0x000fc400000000ffULL, 0xfffffff810107812ULL, 0x000fe400078ee203ULL,
0x0000100006037812ULL, 0x000fe400078ee2ffULL, 0xfffffff807087812ULL, 0x040fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x000008000e057824ULL, 0x000fe200078e0203ULL,
0x0000000404067810ULL, 0x040fe40007ffe0ffULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x0000001010107824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000202102723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x000000242504723eULL, 0x000fe200000000ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x0000003a3b3a723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000541002127816ULL, 0x040fe20000000004ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x0000763202137816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x000000282902723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000001206007388ULL, 0x0003e20000000a00ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000303105723eULL, 0x000fc400000000ffULL, 0x0000763202077816ULL, 0x140fe40000000004ULL,
0x0000541005347816ULL, 0x140fe40000000035ULL, 0x0000763205357816ULL, 0x000fe40000000035ULL,
0x0000001a1b1d723eULL, 0x000fe400000000ffULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x000000222302723eULL, 0x000fc400000000ffULL, 0x000000262704723eULL, 0x000fe200000000ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x0000763232097816ULL, 0x000fe40000000019ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x000000340a007388ULL, 0x000fe20000000a00ULL,
0x0000541038067816ULL, 0x142fe4000000001cULL, 0x0000763238077816ULL, 0x000fe4000000001cULL,
0x000054103a1c7816ULL, 0x000fc4000000001dULL, 0x000076323a1d7816ULL, 0x000fe2000000001dULL,
0x000000060c007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x000000010b027824ULL, 0x000fc800078e0200ULL,
0x0000000610007388ULL, 0x000fe20000000a00ULL, 0x0000001002027824ULL, 0x000fc600078e0203ULL,
0x0004001408007388ULL, 0x0003e40000000a00ULL, 0x0000541032087816ULL, 0x002fca0000000019ULL,
0x000400080a007388ULL, 0x000fe80000000a00ULL, 0x0004001c0c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002147984ULL, 0x000ee80000000c00ULL, 0x0008000002107984ULL, 0x000ea80000000c00ULL,
0x000c000002187984ULL, 0x000ea20000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x008fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x0000001307077230ULL, 0x004fe40000000000ULL,
0x0000001206067230ULL, 0x000fe40000000000ULL, 0x0000001105057230ULL, 0x000fe40000000000ULL,
0x0000001004047230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001402007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000067810ULL, 0x000fe20007ffe0ffULL,
0x0000000000107919ULL, 0x000e620000002600ULL, 0x00000003ff117819ULL, 0x000fe20000011600ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff077819ULL, 0x000fe20000011606ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000013d3d7812ULL, 0x000fe200078ec0ffULL,
0x0000000111027824ULL, 0x000fe200078e0200ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000106047824ULL, 0x000fc600078e0207ULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x0000000704097812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe400078ef800ULL,
0x0ffffff809047812ULL, 0x000fc600078ef806ULL, 0x0000001002027824ULL, 0x100fe400078e0203ULL,
0x0000001004047824ULL, 0x000fe400078e0203ULL, 0x0000000810127824ULL, 0x042fe200078e00ffULL,
0x0000000002087984ULL, 0x0002e20000000c00ULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x00000000040c7984ULL, 0x0005220000000c00ULL,
0xfffffff812037812ULL, 0x000fe200078ee211ULL, 0x000000083d117824ULL, 0x000fe200078e00ffULL,
0xfffffff810077812ULL, 0x000fc400078ee207ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000407057c10ULL, 0x000fe2000ff3e0ffULL, 0x000000083d077824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x002fe200078040ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x00005a0005047a11ULL, 0x004fe400078240ffULL, 0x00005b0003037a11ULL, 0x000fc400000f4412ULL,
0xfffffff807077812ULL, 0x000fe400078ee200ULL, 0x00005b0005057a11ULL, 0x000fc600008f4410ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000003c3d00720cULL, 0x000fe20003f06070ULL,
0xffffffffff077424ULL, 0x000fd800078e00ffULL, 0x00000002040a8824ULL, 0x000fc800078e00ffULL,
0x000064000a0a8a24ULL, 0x000fc800078e023dULL, 0x000060000a0a8625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff127624ULL, 0x000fe200078e00ffULL,
0x000000060a078981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff137624ULL, 0x000fc600078e00ffULL,
0x01760000ff087f8cULL, 0x002e68000c80043fULL, 0x0000000612067981ULL, 0x000722000c1e9900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000004014007824ULL, 0x000fe400078e00ffULL,
0x000000403d037824ULL, 0x000fe400078e00ffULL, 0x0000004015027824ULL, 0x000fc400078e00ffULL,
0x0000000700077224ULL, 0x004fcc00078e02ffULL, 0x00000e8000000947ULL, 0x000fea0003800000ULL,
0x000000033e0a7217ULL, 0x00afe40007800000ULL, 0x00000003ff0e7819ULL, 0x000fe4000001160dULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0a03ULL,
0x000000040e0a7810ULL, 0x040fe20007ffe0ffULL, 0x00000040150c7824ULL, 0x000fe200078e020eULL,
0x000000080e147810ULL, 0x000fe40007ffe0ffULL, 0x0000000b0a00720cULL, 0x0c0fe20003f06070ULL,
0x000000010a107824ULL, 0x140fe200078e020dULL, 0x0000000c07197210ULL, 0x040fe20007f5e0ffULL,
0x000000080a1b7824ULL, 0x000fe200078e00ffULL, 0x000000040c0a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114127824ULL, 0x040fe200078e020dULL, 0x0000000b1400720cULL, 0x040fe20003f26070ULL,
0x00000008141d7824ULL, 0x000fe200078e00ffULL, 0x0000000a070a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005e00191a7a11ULL, 0x000fc400078438ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee212ULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x000000100c127810ULL, 0x000fe40007ffe0ffULL, 0x00005e000a187a11ULL, 0x000fe400078638ffULL,
0xfffffff81b1b7812ULL, 0x000fe400078ee210ULL, 0x00005f0019197a11ULL, 0x000fe400010f3c14ULL,
0x0000000c0c107810ULL, 0x000fc40007ffe0ffULL, 0x000000140c147810ULL, 0x000fe40007ffe0ffULL,
0x0000001207127210ULL, 0x040fe40007f5e0ffULL, 0x00005f000a1c7a11ULL, 0x000fe400018f3c13ULL,
0x0000001007107210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff277224ULL, 0x000fe200010e06ffULL,
0x0000001407147210ULL, 0x040fe40007f7e0ffULL, 0x000000080c0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e06ffULL, 0x00005e00121e7a11ULL, 0x000fe200078438ffULL,
0x000000ffff297224ULL, 0x000fe200018e06ffULL, 0x0000000a070a7210ULL, 0x000fc40007f9e0ffULL,
0x00005e00102a7a11ULL, 0x000fe400078a38ffULL, 0x00005e0014287a11ULL, 0x000fe200078638ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x00005f0012277a11ULL, 0x000fe400010f3c27ULL,
0x000000180c127810ULL, 0x000fe40007ffe0ffULL, 0x00005f00102b7a11ULL, 0x000fe200028f3c2bULL,
0x000000010e107824ULL, 0x000fe200078e020dULL, 0x00005f0014297a11ULL, 0x000fc400018f3c29ULL,
0x00005e000a167a11ULL, 0x000fe400078838ffULL, 0x000000100e147810ULL, 0x040fe40007ffe0ffULL,
0x0000001207267210ULL, 0x000fe40007fde0ffULL, 0x0000000c0e247810ULL, 0x000fe20007ffe0ffULL,
0x0000000114157824ULL, 0x000fe200078e020dULL, 0x000000051a127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0x00005f000a207a11ULL, 0x000fe200020f3c13ULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0x0000000710227812ULL, 0x000fe200078ec0ffULL,
0x0000000124107824ULL, 0x000fe200078e020dULL, 0x0000000b1400720cULL, 0x0c0fe20003f86070ULL,
0x0000000814147824ULL, 0x000fe200078e00ffULL, 0x0000000b2400720cULL, 0x000fe20003fa6070ULL,
0x000000ffff137224ULL, 0x000fe200018e0619ULL, 0x00005e0026247a11ULL, 0x000fc400078638ffULL,
0xfffffff814217812ULL, 0x000fe400078ee215ULL, 0x00005f0026267a11ULL, 0x000fe400018f3c17ULL,
0x0000000518147210ULL, 0x000fe40007f7e0ffULL, 0x0000000b0e00720cULL, 0x000fe40003f46070ULL,
0x000010003d0a7811ULL, 0x000fe200078e70ffULL, 0x000000ffff157224ULL, 0x000fe200018e061cULL,
0x0ffffff822237812ULL, 0x000fc400078ef80dULL, 0x0000001c0c1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e020aULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x0000001023197824ULL, 0x100fe200078e020aULL, 0x0000000516167210ULL, 0x000fe20007f7e0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e020aULL, 0x0000001c071c7210ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e020aULL, 0x000000140e107810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012197faeULL, 0x0003e2000d101c46ULL,
0x000000180e1a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200018e0620ULL,
0x0000000b1000720cULL, 0x0c0fe20003f46070ULL, 0x0000000110187824ULL, 0x140fe200078e020dULL,
0x00000000141b7faeULL, 0x0005e2000c101c46ULL, 0x0000000810237824ULL, 0x000fe200078e00ffULL,
0x0000000b1a00720cULL, 0x040fe20003f66070ULL, 0x000000011a107824ULL, 0x040fe200078e020dULL,
0x00000000161d7faeULL, 0x0007e2000c901c46ULL, 0x000000081a257824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x000000ffff137224ULL, 0x002fe200030e06ffULL,
0x00005e001c207a11ULL, 0x000fe200078c38ffULL, 0x0000001021217824ULL, 0x100fe200078e020aULL,
0x000000051e187210ULL, 0x000fe20007f3e0ffULL, 0x0000001023237824ULL, 0x000fe200078e020aULL,
0x00005f001c227a11ULL, 0x000fc400030f3c13ULL, 0x000000052a127210ULL, 0x000fe20007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0627ULL, 0x000000200c1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x000000ffff137224ULL, 0x000fe200030e062bULL,
0x0000001c0e107810ULL, 0x040fe40007ffe0ffULL, 0x000000200e1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x000fe200078e020aULL, 0x0000001e071e7210ULL, 0x000fe20007fde0ffULL,
0x00000001101a7824ULL, 0x140fe200078e020dULL, 0x0000000b1000720cULL, 0x0c0fe20003f06070ULL,
0x00000008102b7824ULL, 0x000fe200078e00ffULL, 0x0000000b1c00720cULL, 0x040fe20003f26070ULL,
0x000000011c107824ULL, 0x000fe200078e020dULL, 0x000000240c147810ULL, 0x004fe20007ffe0ffULL,
0x000000081c277824ULL, 0x000fe200078e00ffULL, 0x00000000121f7faeULL, 0x0003e2000e901c46ULL,
0x000000ffff157224ULL, 0x000fe200030e06ffULL, 0x00005e001e1c7a11ULL, 0x000fc400078c38ffULL,
0xfffffff827277812ULL, 0x000fe200078ee210ULL, 0x0000000018217faeULL, 0x0005e2000e101c46ULL,
0x00005f001e1e7a11ULL, 0x000fe400030f3c15ULL, 0x0000001407177210ULL, 0x008fe20007fde0ffULL,
0x0000001027277824ULL, 0x000fe200078e020aULL, 0x000000240e107810ULL, 0x000fe40007ffe0ffULL,
0x0000000528147210ULL, 0x000fe40007fbe0ffULL, 0x0000000b1000720cULL, 0x040fe20003f86070ULL,
0x0000000110167824ULL, 0x040fe200078e020dULL, 0xfffffff82b1b7812ULL, 0x000fe200078ee21aULL,
0x00000008101d7824ULL, 0x000fc400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200028e0629ULL,
0x0000000524127210ULL, 0x082fe20007fbe0ffULL, 0x000000ffff107224ULL, 0x000fe200030e06ffULL,
0xfffffff81d1f7812ULL, 0x000fe200078ee216ULL, 0x000000101b1d7824ULL, 0x000fe200078e020aULL,
0x0000000014237faeULL, 0x0003e2000d101c46ULL, 0x00005e00171a7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff137224ULL, 0x000fe200028e0626ULL, 0x0000000520167210ULL, 0x000fe20007f5e0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e020aULL, 0x00005f0017107a11ULL, 0x000fc400030f3c10ULL,
0x0000000012257faeULL, 0x0007e2000d901c46ULL, 0x000000ffff177224ULL, 0x000fe200010e0622ULL,
0x000000051c187210ULL, 0x084fe40007f7e0ffULL, 0x000000051a1a7210ULL, 0x000fe40007f5e0ffULL,
0x0000002c0e147810ULL, 0x042fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200018e061eULL,
0x000000300e1c7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e0610ULL,
0x000000280e107810ULL, 0x040fe20007ffe0ffULL, 0x00000000161d7faeULL, 0x0003e2000c101c46ULL,
0x000000340e1e7810ULL, 0x000fc40007ffe0ffULL, 0x000000380e207810ULL, 0x000fe20007ffe0ffULL,
0x0000000110127824ULL, 0x108fe200078e020dULL, 0x0000003c0e227810ULL, 0x000fe20007ffe0ffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0x000000280c0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000018277faeULL, 0x0005e2000c901c46ULL, 0x0000000b1000720cULL, 0x080fe20003fa6070ULL,
0x0000000114107824ULL, 0x040fe200078e020dULL, 0x0000000e07137210ULL, 0x000fe20007fde0ffULL,
0x000000001a1f7faeULL, 0x0007e2000e101c46ULL, 0x0000000b1400720cULL, 0x0c0fe20003f86070ULL,
0x0000000814177824ULL, 0x002fe200078e00ffULL, 0x0000000b1c00720cULL, 0x080fe20003f66070ULL,
0x000000ffff167224ULL, 0x000fe200030e06ffULL, 0x00005e00130e7a11ULL, 0x000fe200078c38ffULL,
0x00000008201d7824ULL, 0x000fe200078e00ffULL, 0x0000000b1e00720cULL, 0x080fe20003f46070ULL,
0x000000081c197824ULL, 0x004fe200078e00ffULL, 0x0000000b2000720cULL, 0x000fc40003f26070ULL,
0x0000000b2200720cULL, 0x000fe20003f06070ULL, 0x000000081e1b7824ULL, 0x008fe200078e00ffULL,
0xfffffff8150b7812ULL, 0x000fe200078ee212ULL, 0x00000008221f7824ULL, 0x000fe200078e00ffULL,
0x00005f0013137a11ULL, 0x000fe400030f3c16ULL, 0x000000050e127210ULL, 0x000fe20007fde0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e020aULL, 0x0000002c0c0e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff817177812ULL, 0x000fe200078ee210ULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x0000000e07167210ULL, 0x000fe20007fde0ffULL, 0x000000011e0e7824ULL, 0x000fc400078e020dULL,
0x000000011c107824ULL, 0x100fe200078e020dULL, 0x00000000120b7faeULL, 0x0003e2000e901c46ULL,
0x000000ffff157224ULL, 0x000fe200030e06ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20eULL,
0x0000001017177824ULL, 0x100fe200078e020aULL, 0x000000300c0e7810ULL, 0x000fe40007ffe0ffULL,
0x00005e0016147a11ULL, 0x000fe200078c38ffULL, 0x000000101b1b7824ULL, 0x000fe200078e020aULL,
0xfffffff819197812ULL, 0x000fe200078ee210ULL, 0x0000000120107824ULL, 0x100fe200078e020dULL,
0x0000000e071a7210ULL, 0x000fe20007fbe0ffULL, 0x00000001220e7824ULL, 0x000fe200078e020dULL,
0x00005f0016167a11ULL, 0x000fe200030f3c15ULL, 0x0000001019197824ULL, 0x000fe200078e020aULL,
0x00005e001a187a11ULL, 0x000fe200078c38ffULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x0000000514147210ULL, 0x000fc40007fbe0ffULL, 0xfffffff81d0d7812ULL, 0x000fe400078ee210ULL,
0xfffffff81f1d7812ULL, 0x000fe400078ee20eULL, 0x000000340c0e7810ULL, 0x000fe40007ffe0ffULL,
0x00005f001a1a7a11ULL, 0x000fe200030f3c15ULL, 0x000000ffff157224ULL, 0x000fe200028e0616ULL,
0x000000380c107810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e020aULL,
0x0000000e07167210ULL, 0x000fc40007fbe0ffULL, 0x0000003c0c0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000014177faeULL, 0x0005e2000e101c46ULL, 0x0000001007107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x002fe200028e06ffULL, 0x0000000c070e7210ULL, 0x000fe20007fde0ffULL,
0x000000100d077824ULL, 0x000fe200078e020aULL, 0x00005e00160c7a11ULL, 0x000fe200078a38ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x00005e0010127a11ULL, 0x000fe200078838ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x00005f0016167a11ULL, 0x000fc400028f3c0bULL,
0x00000005180a7210ULL, 0x080fe40007fbe0ffULL, 0x00005e000e147a11ULL, 0x004fe400078c38ffULL,
0x00005f0010107a11ULL, 0x000fe200020f3c13ULL, 0x000000ffff0b7224ULL, 0x000fe200028e061aULL,
0x000000050c0c7210ULL, 0x080fe40007fbe0ffULL, 0x00005f000e0e7a11ULL, 0x000fe400030f3c0dULL,
0x0000000512127210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e0616ULL,
0x0000000514147210ULL, 0x000fe20007fbe0ffULL, 0x000000000a197faeULL, 0x0003e4000d901c46ULL,
0x000000ffff137224ULL, 0x000fc400020e0610ULL, 0x000000ffff157224ULL, 0x000fe200028e060eULL,
0x000000000c1b7faeULL, 0x0003e8000d101c46ULL, 0x0000000012077faeULL, 0x0003e8000c901c46ULL,
0x00000000141d7faeULL, 0x0003e2000c101c46ULL, 0x00000d4000007947ULL, 0x000fea0003800000ULL,
0x000000040d0b7811ULL, 0x04afe400078fe8ffULL, 0x000000080d0e7811ULL, 0x000fc400078fe8ffULL,
0x000000200d1b7811ULL, 0x000fe200078fe8ffULL, 0x000000010b2a7824ULL, 0x100fe200078e020dULL,
0x0000000c0d127811ULL, 0x000fe200078fe8ffULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0x000000240d2d7811ULL, 0x040fe200078fe8ffULL, 0x000000010e297824ULL, 0x140fe200078e020dULL,
0x000000180d187811ULL, 0x000fe200078fe8ffULL, 0x000000080e0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8132a7812ULL, 0x000fe200078ee22aULL, 0x000000011b237824ULL, 0x100fe200078e020dULL,
0x000000100d137811ULL, 0x040fe200078fe8ffULL, 0x0000000112287824ULL, 0x000fe200078e020dULL,
0xfffffff80a297812ULL, 0x000fe200078ee229ULL, 0x0000000812157824ULL, 0x000fe200078e00ffULL,
0x000000280d2f7811ULL, 0x000fe200078fe8ffULL, 0x0000000113277824ULL, 0x100fe200078e020dULL,
0x000000300d337811ULL, 0x000fe200078fe8ffULL, 0x00000008130a7824ULL, 0x000fe200078e00ffULL,
0x0000002c0d317811ULL, 0x000fe200078fe8ffULL, 0x000000012d227824ULL, 0x000fe200078e020dULL,
0xfffffff815287812ULL, 0x000fe200078ee228ULL, 0x000000082d1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a277812ULL, 0x000fe200078ee227ULL, 0x000000081b0a7824ULL, 0x000fe200078e00ffULL,
0x000000140d157811ULL, 0x000fe200078fe8ffULL, 0x0000000118257824ULL, 0x040fe200078e020dULL,
0xfffffff81d227812ULL, 0x000fe200078ee222ULL, 0x00000008180c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a237812ULL, 0x000fe200078ee223ULL, 0x000000012f217824ULL, 0x000fe200078e020dULL,
0x000000340d357811ULL, 0x000fe200078fe8ffULL, 0x000000082f0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c257812ULL, 0x000fe200078ee225ULL, 0x00000001331d7824ULL, 0x000fe200078e020dULL,
0x000000380d377811ULL, 0x000fe200078fe8ffULL, 0x0000000833107824ULL, 0x000fe200078e00ffULL,
0xfffffff80a217812ULL, 0x000fe200078ee221ULL, 0x00000001311f7824ULL, 0x000fe200078e020dULL,
0x000000020d0a7211ULL, 0x000fe200078fe8ffULL, 0x00000008310c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8101d7812ULL, 0x000fe200078ee21dULL, 0x0000000115267824ULL, 0x000fe200078e020dULL,
0x0000001c0d197811ULL, 0x000fe200078fe8ffULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0xfffffff80c1f7812ULL, 0x000fe200078ee21fULL, 0x00000001352b7824ULL, 0x000fe200078e020dULL,
0x0000000a07147210ULL, 0x000fe20007f1e0ffULL, 0x0000000835107824ULL, 0x000fe200078e00ffULL,
0xfffffff817267812ULL, 0x000fe200078ee226ULL, 0x00000001020c7824ULL, 0x000fe200078e020bULL,
0x000010003d467811ULL, 0x000fe200078e70ffULL, 0x00000001370b7824ULL, 0x040fe200078e020dULL,
0xfffffff8102b7812ULL, 0x000fe200078ee22bULL, 0x00000008373a7824ULL, 0x000fe200078e00ffULL,
0x0000000c07107210ULL, 0x000fe20007f3e0ffULL, 0x0000000119247824ULL, 0x000fe200078e020dULL,
0x00000070054b7812ULL, 0x000fe200078ec0ffULL, 0x0000000819177824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20bULL, 0x000000ffff397224ULL, 0x000fe200000e06ffULL,
0x00005e00140a7a11ULL, 0x000fe200078038ffULL, 0x00000001020e7824ULL, 0x000fe200078e020eULL,
0xfffffff817247812ULL, 0x000fe200078ee224ULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005f00140b7a11ULL, 0x000fe200000f3c39ULL, 0x0000000102147824ULL, 0x000fe200078e0213ULL,
0x00005e00100c7a11ULL, 0x000fe200078238ffULL, 0x0000000102127824ULL, 0x040fe200078e0212ULL,
0x0000000e07137210ULL, 0x040fe20007f1e0ffULL, 0x00000001020e7824ULL, 0x000fe200078e0215ULL,
0x00005f0010107a11ULL, 0x000fe200008f3c17ULL, 0x0000000102307824ULL, 0x040fe200078e022fULL,
0x0000001207157210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x0000001407177210ULL, 0x000fe20007f5e0ffULL, 0x0000000102347824ULL, 0x040fe200078e0233ULL,
0x00005e0013127a11ULL, 0x000fe200078038ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078238ffULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00005f0013137a11ULL, 0x000fe200000f3c1eULL, 0x00000001022e7824ULL, 0x040fe200078e022dULL,
0x00005e0017167a11ULL, 0x000fe200078438ffULL, 0x0000000102327824ULL, 0x040fe200078e0231ULL,
0x0000000e071e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001020e7824ULL, 0x040fe200078e0218ULL,
0x00005f0015157a11ULL, 0x000fe200008f3c1cULL, 0x00000001021c7824ULL, 0x040fe200078e021bULL,
0x00005f0017177a11ULL, 0x000fe200010f3c1aULL, 0x00000001021a7824ULL, 0x000fe200078e0219ULL,
0x0000000e071b7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff397224ULL, 0x000fe200000e06ffULL,
0x00005e001e187a11ULL, 0x000fe200078038ffULL, 0x0000000102367824ULL, 0x040fe200078e0235ULL,
0x0000001a071a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200008e06ffULL,
0x0000001c070e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000102387824ULL, 0x000fe200078e0237ULL,
0x00005f001e197a11ULL, 0x000fe200000f3c39ULL, 0x000000ffff3b7224ULL, 0x000fe200010e06ffULL,
0x00005e001b1c7a11ULL, 0x000fe200078038ffULL, 0x000000ffff397224ULL, 0x000fe200018e06ffULL,
0x00005e000e207a11ULL, 0x000fe200078438ffULL, 0x0000001025357824ULL, 0x000fe200078e0246ULL,
0x00005f001b1b7a11ULL, 0x000fe200000f3c2cULL, 0x0000001024377824ULL, 0x100fe200078e0246ULL,
0x0000000d0d2c7211ULL, 0x000fe200078fe8ffULL, 0x000000101d437824ULL, 0x100fe200078e0246ULL,
0x00005f000e0e7a11ULL, 0x000fe200010f3c39ULL, 0x00000010282f7824ULL, 0x100fe200078e0246ULL,
0x0000003c0d397811ULL, 0x000fe200078fe8ffULL, 0x0000001027317824ULL, 0x100fe200078e0246ULL,
0x000000072c2c7812ULL, 0x000fe200078ec0ffULL, 0x0000001026337824ULL, 0x100fe200078e0246ULL,
0x00005e001a1e7a11ULL, 0x000fe200078238ffULL, 0x0000000839447824ULL, 0x040fe200078e00ffULL,
0x0ffffff82c2c7812ULL, 0x100fe200078ef80dULL, 0x00000001390d7824ULL, 0x000fe200078e020dULL,
0x00005f001a1a7a11ULL, 0x000fe200008f3c3bULL, 0x0000000102407824ULL, 0x000fe200078e0239ULL,
0x0000003007307210ULL, 0x000fe20007f7e0ffULL, 0x00000010213f7824ULL, 0x100fe200078e0246ULL,
0x0000003407347210ULL, 0x000fe20007f3e0ffULL, 0x000000102b457824ULL, 0x100fe200078e0246ULL,
0x0000002e072e7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0xfffffff8440d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff1d7224ULL, 0x000fe200008e06ffULL,
0x0000003207327210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200020e06ffULL,
0x0000003607367210ULL, 0x000fe20007f5e0ffULL, 0x000000100d497824ULL, 0x100fe200078e0246ULL,
0x00005e0030247a11ULL, 0x000fe200078638ffULL, 0x000000ffff277224ULL, 0x000fe200000e06ffULL,
0x00005e0034287a11ULL, 0x000fe200078238ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x00005e002e427a11ULL, 0x000fe200078c38ffULL, 0x0000001029297824ULL, 0x100fe200078e0246ULL,
0x0000003807387210ULL, 0x040fe20007f9e0ffULL, 0x00000010223b7824ULL, 0x100fe200078e0246ULL,
0x0000004007407210ULL, 0x000fe20007fbe0ffULL, 0x000000102c077824ULL, 0x100fe200078e0246ULL,
0x00005f0030257a11ULL, 0x000fe200018f3c25ULL, 0x000000ffff2b7224ULL, 0x000fe200020e06ffULL,
0x00005f0034307a11ULL, 0x000fe200008f3c1dULL, 0x000000ffff057224ULL, 0x000fe200028e06ffULL,
0x00005f002e447a11ULL, 0x000fe200030f3c2dULL, 0x000000102a2d7824ULL, 0x100fe200078e0246ULL,
0x00005e0032267a11ULL, 0x000fe200078038ffULL, 0x000000101f417824ULL, 0x100fe200078e0246ULL,
0x00005e0036217a11ULL, 0x000fe200078238ffULL, 0x0000001023397824ULL, 0x100fe200078e0246ULL,
0x00005e00382a7a11ULL, 0x000fe200078438ffULL, 0x000000103a477824ULL, 0x000fe200078e0246ULL,
0x00005e00402c7a11ULL, 0x000fc400078638ffULL, 0x00005f0032277a11ULL, 0x000fe400000f3c27ULL,
0x00005f00362e7a11ULL, 0x000fe400008f3c0dULL, 0x0000000a4b0a7210ULL, 0x040fe40007f1e0ffULL,
0x0000000c4b0c7210ULL, 0x040fe40007f3e0ffULL, 0x00005f00382b7a11ULL, 0x000fe200010f3c2bULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x00005f0040057a11ULL, 0x000fe200018f3c05ULL,
0x000000ffff0d7224ULL, 0x000fe200008e0610ULL, 0x000000124b127210ULL, 0x000fc40007f5e0ffULL,
0x000000144b147210ULL, 0x040fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a077faeULL, 0x0003e2000b901c46ULL, 0x000000164b167210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x000000184b187210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x0000001c4b1c7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x0000001e4b1e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200020e0619ULL, 0x000000204b207210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061bULL, 0x000000424b227210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e061aULL, 0x000000244b247210ULL, 0x040fe20007fbe0ffULL,
0x000000000c2d7faeULL, 0x0005e2000b901c46ULL, 0x000000264b267210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff237224ULL, 0x000fe200018e0644ULL, 0x000000284b287210ULL, 0x040fe20007f1e0ffULL,
0x0000000012297faeULL, 0x0007e2000b901c46ULL, 0x000000214b1a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e060eULL, 0x0000002a4b2a7210ULL, 0x040fe20007f5e0ffULL,
0x00000000142f7faeULL, 0x0003e2000b901c46ULL, 0x0000002c4b2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff257224ULL, 0x000fc400028e0625ULL, 0x0000000016317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff277224ULL, 0x000fe400020e0627ULL, 0x000000ffff1b7224ULL, 0x000fe200008e062eULL,
0x0000000018337faeULL, 0x0003e2000b901c46ULL, 0x000000ffff297224ULL, 0x008fe400000e0630ULL,
0x000000ffff2b7224ULL, 0x000fe200010e062bULL, 0x000000001c357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x004fc600018e0605ULL, 0x000000001e377faeULL, 0x0003e8000b901c46ULL,
0x0000000020397faeULL, 0x0003e8000b901c46ULL, 0x00000000223b7faeULL, 0x0003e8000b901c46ULL,
0x00000000243f7faeULL, 0x0003e8000b901c46ULL, 0x0000000026417faeULL, 0x0003e8000b901c46ULL,
0x0000000028437faeULL, 0x0003e8000b901c46ULL, 0x000000001a457faeULL, 0x0003e8000b901c46ULL,
0x000000002a477faeULL, 0x0003e8000b901c46ULL, 0x000000002c497faeULL, 0x0003e4000b901c46ULL,
0x000000043d057810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff077424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000003c0500720cULL, 0x000fda0003f06070ULL,
0x00000002040a8824ULL, 0x000fc800078e00ffULL, 0x000064000a0a8a24ULL, 0x000fc800078e0205ULL,
0x000060000a0a8625ULL, 0x000fca00078e0011ULL, 0x000000060a078981ULL, 0x000324000c1e1900ULL,
0x00000000000a7805ULL, 0x002fc40000015200ULL, 0x01760400ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a117210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc8000001140dULL, 0x000000110c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x000000020c0c7819ULL, 0x000fc8000000120dULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000e640000000000ULL,
0x000000203d087824ULL, 0x002fca00078e0208ULL, 0x00000003ff097819ULL, 0x000fc80000011608ULL,
0x1ffffffe090b7812ULL, 0x000fe400078ec0ffULL, 0x0000000f08097812ULL, 0x000fc600078ec0ffULL,
0x00000001080b7824ULL, 0x000fe400078e020bULL, 0x00000010090d7824ULL, 0x040fe400078e00ffULL,
0x00000010090a7824ULL, 0x000fe200078e00ffULL, 0x0000000f0b087812ULL, 0x040fe400078ec0ffULL,
0x000000010b0b7810ULL, 0x000fe40007ffe0ffULL, 0x000000f00d087812ULL, 0x000fe400078ee208ULL,
0x0000000f0b0b7812ULL, 0x000fc600078ec0ffULL, 0x0000000008147984ULL, 0x000e62000000cc00ULL,
0x000000f00a0b7812ULL, 0x000fca00078ee20bULL, 0x000000000b107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0012ULL,
0x000000ffff167224ULL, 0x000fe400078e0011ULL, 0x000000ffff177224ULL, 0x000fe200078e0013ULL,
0x0000001808007388ULL, 0x0003e8000000cc00ULL, 0x000000140b007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff0c7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0e7224ULL, 0x000fc600078e00ffULL, 0x0000000000087805ULL, 0x002fc80000015200ULL,
0x01760400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08117210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x000000110a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000e620000000000ULL,
0x0000640004047a24ULL, 0x000fe200078e02ffULL, 0x000176883d087811ULL, 0x000fe200078e18ffULL,
0x3db504f306067820ULL, 0x010fe20000410000ULL, 0xffffffff0f0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000176083d0b7811ULL, 0x000fe200078e28ffULL,
0x000000ffff107224ULL, 0x000fc400078e00ffULL, 0x000001000c0d7824ULL, 0x000fe200078e0203ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000000d3e00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000020c0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000700077224ULL, 0x000fc600078e02ffULL, 0x0000000f0e00720cULL, 0x000fe40003f06070ULL,
0x00000001100e7812ULL, 0x000fd600078e0cffULL, 0x00000eb000008947ULL, 0x000fea0003800000ULL,
0x00000003ff147819ULL, 0x102fe40000011609ULL, 0x000001000d137810ULL, 0x000fe40007ffe0ffULL,
0x0000000414187810ULL, 0x000fe20007ffe0ffULL, 0x0000000102167824ULL, 0x000fe200078e0214ULL,
0x00000008141a7810ULL, 0x000fe40007ffe0ffULL, 0x000000133e127217ULL, 0x000fe20007800000ULL,
0x0000000118117824ULL, 0x140fe200078e0209ULL, 0x0000001607167210ULL, 0x000fe20007f1e0ffULL,
0x00000008181c7824ULL, 0x000fe200078e00ffULL, 0x00000018142a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a177824ULL, 0x000fc400078e0209ULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e00161e7a11ULL, 0x000fe200078038ffULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0xfffffff81c217812ULL, 0x000fe200078ee211ULL, 0x0000000112137824ULL, 0x000fe200078e0a13ULL,
0x00005f0016157a11ULL, 0x000fe200000f3c15ULL, 0x0000000102167824ULL, 0x000fe200078e021aULL,
0x0000000c141c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102127824ULL, 0x000fe200078e0218ULL,
0xfffffff820257812ULL, 0x000fe200078ee217ULL, 0x0000000114177824ULL, 0x100fe200078e0209ULL,
0x000000131800720cULL, 0x080fe20003f66070ULL, 0x000000011c117824ULL, 0x040fe200078e0209ULL,
0x0000001607167210ULL, 0x040fe20007fbe0ffULL, 0x000000081c207824ULL, 0x040fe200078e00ffULL,
0x000000131c00720cULL, 0x000fe20003f86070ULL, 0x0000000102187824ULL, 0x000fe200078e021cULL,
0x0000001207127210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e06ffULL,
0xfffffff820277812ULL, 0x000fe200078ee211ULL, 0x0000001009117824ULL, 0x000fe200078e00ffULL,
0x0000001807187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e06ffULL,
0x00005e00161c7a11ULL, 0x000fc400078a38ffULL, 0x0000001014207810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e06ffULL, 0x00005f00161d7a11ULL, 0x000fe400028f3c1dULL,
0x000000131a00720cULL, 0x000fe20003f46070ULL, 0x0000000102167824ULL, 0x000fe200078e0220ULL,
0x00005e00121a7a11ULL, 0x000fe200078238ffULL, 0x0000000120227824ULL, 0x000fe200078e0209ULL,
0x00005e0018267a11ULL, 0x000fe200078038ffULL, 0x0000000820297824ULL, 0x000fe200078e00ffULL,
0x0000007011117812ULL, 0x000fc400078ec0ffULL, 0x00005f00121f7a11ULL, 0x000fe200008f3c1fULL,
0x000000023d127824ULL, 0x000fe200078e020eULL, 0x00005f00181b7a11ULL, 0x000fe400000f3c1bULL,
0x0000001607237210ULL, 0x000fe40007fde0ffULL, 0x0000000717187812ULL, 0x000fe400078ec0ffULL,
0x000000111e167210ULL, 0x000fe40007f3e0ffULL, 0x0ffffff818197812ULL, 0x000fe200078ef809ULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x000000132000720cULL, 0x000fe20003fa6070ULL,
0x000000ffff177224ULL, 0x000fe200008e0615ULL, 0x00005e00231e7a11ULL, 0x000fc400078238ffULL,
0x0000001414207810ULL, 0x040fe40007ffe0ffULL, 0x00005f0023237a11ULL, 0x000fe400008f3c18ULL,
0x000000131400720cULL, 0x000fe20003f06070ULL, 0x0000000102187824ULL, 0x000fe200078e0220ULL,
0x0000100012127811ULL, 0x000fe200078e68ffULL, 0x0000000120287824ULL, 0x040fe200078e0209ULL,
0xfffffff829297812ULL, 0x000fe200078ee222ULL, 0x00000008202b7824ULL, 0x000fe200078e00ffULL,
0x0000001807247210ULL, 0x000fe20007f3e0ffULL, 0x0000001019157824ULL, 0x000fc600078e0212ULL,
0x00005e0024227a11ULL, 0x000fe200078c38ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x000000111a187210ULL, 0x000fe20007f3e0ffULL, 0x00000001021a7824ULL, 0x000fe200078e022aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000c101c46ULL,
0x000000132000720cULL, 0x000fe40003f06070ULL, 0x00005f0024247a11ULL, 0x000fe200030f3c19ULL,
0x000000ffff197224ULL, 0x000fe200008e061fULL, 0x0000001a071a7210ULL, 0x000fe40007fde0ffULL,
0xfffffff82b2b7812ULL, 0x000fc600078ee228ULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x00005e001a207a11ULL, 0x000fe200078c38ffULL, 0x000000012a157824ULL, 0x002fe200078e0209ULL,
0x000000111c167210ULL, 0x000fe20007f3e0ffULL, 0x000000082a1c7824ULL, 0x000fe200078e00ffULL,
0x00005f001a1f7a11ULL, 0x000fc600030f3c1fULL, 0x000000ffff177224ULL, 0x000fe200008e061dULL,
0xfffffff81c2d7812ULL, 0x000fe200078ee215ULL, 0x0000001021157824ULL, 0x100fe200078e0212ULL,
0x0000001c141c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010251d7824ULL, 0x000fe200078e0212ULL,
0x000000132a00720cULL, 0x080fe40003f26070ULL, 0x0000000018157faeULL, 0x0003e2000d901c46ULL,
0x00000001021a7824ULL, 0x000fe200078e021cULL, 0x00000020142a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011c257824ULL, 0x040fe200078e0209ULL, 0x00000000161d7faeULL, 0x0005e2000d101c46ULL,
0x000000131c00720cULL, 0x040fe20003f46070ULL, 0x000000081c2c7824ULL, 0x000fe200078e00ffULL,
0x0000001a07217210ULL, 0x000fc80007f7e0ffULL, 0x00005e0021287a11ULL, 0x040fe200078c38ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00000011261a7210ULL, 0x080fe20007f7e0ffULL,
0x0000000102187824ULL, 0x002fe200078e022aULL, 0xfffffff82c2f7812ULL, 0x000fe200078ee225ULL,
0x000000012a157824ULL, 0x040fe200078e0209ULL, 0x00005f0021217a11ULL, 0x000fe200030f3c1cULL,
0x000000082a1c7824ULL, 0x000fe200078e00ffULL, 0x0000001807187210ULL, 0x000fe20007fde0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x000000111e167210ULL, 0x004fe20007f7e0ffULL,
0x00000010291d7824ULL, 0x100fe200078e0212ULL, 0xfffffff81c317812ULL, 0x000fe200078ee215ULL,
0x000000ffff257224ULL, 0x000fe200030e06ffULL, 0x00005e00181e7a11ULL, 0x000fe200078c38ffULL,
0x0000001027157824ULL, 0x000fe200078e0212ULL, 0x00000024141c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0623ULL, 0x00005f0018257a11ULL, 0x000fc400030f3c25ULL,
0x000000001a157faeULL, 0x0003e2000e101c46ULL, 0x0000000102187824ULL, 0x000fe200078e021cULL,
0x000000132a00720cULL, 0x080fe20003f66070ULL, 0x000000011c197824ULL, 0x000fe200078e0209ULL,
0x00000028142a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000161d7faeULL, 0x0005e2000e901c46ULL,
0x0000001807237210ULL, 0x000fe20007f9e0ffULL, 0x000000081c2c7824ULL, 0x040fe200078e00ffULL,
0x000000131c00720cULL, 0x000fe40003fa6070ULL, 0x00005e0023267a11ULL, 0x040fe200078c38ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x0000001122187210ULL, 0x080fe20007f9e0ffULL,
0x00000001021a7824ULL, 0x002fe200078e022aULL, 0xfffffff82c277812ULL, 0x000fe200078ee219ULL,
0x000000012a157824ULL, 0x040fe200078e0209ULL, 0x00005f0023237a11ULL, 0x000fe200030f3c1cULL,
0x000000082a1c7824ULL, 0x000fe200078e00ffULL, 0x0000001a071a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200020e0624ULL, 0x0000001120167210ULL, 0x004fc40007f9e0ffULL,
0xfffffff81c297812ULL, 0x000fe200078ee215ULL, 0x000000ffff1b7224ULL, 0x000fe200030e06ffULL,
0x00005e001a207a11ULL, 0x000fe200078c38ffULL, 0x000000102b157824ULL, 0x100fe200078e0212ULL,
0x0000002c141c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200020e061fULL,
0x00005f001a227a11ULL, 0x000fe200030f3c1bULL, 0x000000102d1b7824ULL, 0x000fe200078e0212ULL,
0x0000000018157faeULL, 0x0003e2000c101c46ULL, 0x00000001021a7824ULL, 0x000fe200078e021cULL,
0x000000132a00720cULL, 0x000fe20003f86070ULL, 0x000000011c1d7824ULL, 0x000fe200078e0209ULL,
0x00000000161b7faeULL, 0x0005e2000c901c46ULL, 0x00000030142a7810ULL, 0x000fe20007ffe0ffULL,
0x000000081c2c7824ULL, 0x000fe200078e00ffULL, 0x0000001a071a7210ULL, 0x000fc40007f3e0ffULL,
0x000000131c00720cULL, 0x000fe20003f06070ULL, 0x000000012a1c7824ULL, 0x000fe200078e0209ULL,
0x00005e001a247a11ULL, 0x000fe200078c38ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e06ffULL,
0x0000001128187210ULL, 0x082fe20007f3e0ffULL, 0x000000102f157824ULL, 0x000fe200078e0212ULL,
0x0000003414287810ULL, 0x000fe20007ffe0ffULL, 0x0000000102167824ULL, 0x004fe200078e022aULL,
0x00005f001a1f7a11ULL, 0x000fe200030f3c1fULL, 0x000000ffff197224ULL, 0x000fe200008e0621ULL,
0xfffffff82c2b7812ULL, 0x000fe200078ee21dULL, 0x000000082a2d7824ULL, 0x000fe200078e00ffULL,
0x0000001607217210ULL, 0x000fe20007fde0ffULL, 0x00000001281a7824ULL, 0x000fe200078e0209ULL,
0x0000000018157faeULL, 0x0003e2000d101c46ULL, 0x000000111e167210ULL, 0x080fe20007f5e0ffULL,
0x00000008281b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee21cULL,
0x000000ffff1e7224ULL, 0x000fe200030e06ffULL, 0x00005e00211c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff177224ULL, 0x000fe200010e0625ULL, 0xfffffff81b257812ULL, 0x000fe200078ee21aULL,
0x00000010311d7824ULL, 0x000fe200078e0212ULL, 0x00000011261a7210ULL, 0x000fc40007f5e0ffULL,
0x00005f0021217a11ULL, 0x000fe200030f3c1eULL, 0x0000000102187824ULL, 0x002fe200078e0228ULL,
0x00000038141e7810ULL, 0x040fe20007ffe0ffULL, 0x00000000161d7faeULL, 0x0003e2000d901c46ULL,
0x000000ffff1b7224ULL, 0x000fe200010e0623ULL, 0x0000003c14267810ULL, 0x000fe20007ffe0ffULL,
0x0000001027197824ULL, 0x000fe200078e0212ULL, 0x0000001807187210ULL, 0x000fe20007fde0ffULL,
0x000000011e237824ULL, 0x000fe200078e0209ULL, 0x0000001120147210ULL, 0x000fe20007f7e0ffULL,
0x0000000826277824ULL, 0x000fe200078e00ffULL, 0x000000001a197faeULL, 0x0005e2000e901c46ULL,
0x000000132a00720cULL, 0x000fc40003f26070ULL, 0x000000ffff157224ULL, 0x000fe200018e0622ULL,
0x000000132800720cULL, 0x080fe20003f46070ULL, 0x000000081e167824ULL, 0x042fe200078e00ffULL,
0x000000131e00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x00005e0018207a11ULL, 0x000fe400078c38ffULL, 0xfffffff816237812ULL, 0x000fe200078ee223ULL,
0x0000000102167824ULL, 0x000fe200078e021eULL, 0x000000132600720cULL, 0x000fe20003f66070ULL,
0x0000001029137824ULL, 0x000fe200078e0212ULL, 0x00005f0018227a11ULL, 0x000fe200030f3c17ULL,
0x0000000102187824ULL, 0x000fe200078e0226ULL, 0x00000016071a7210ULL, 0x004fe20007fde0ffULL,
0x000000102b1b7824ULL, 0x000fe200078e0212ULL, 0x0000000014137faeULL, 0x0003e2000e101c46ULL,
0x0000001124167210ULL, 0x000fe20007f9e0ffULL, 0x0000000126247824ULL, 0x000fc400078e0209ULL,
0x000000ffff1d7224ULL, 0x000fe200030e06ffULL, 0x00005e001a1e7a11ULL, 0x040fe200078c38ffULL,
0x000000ffff177224ULL, 0x000fe200020e061fULL, 0x0000001807197210ULL, 0x000fe20007f9e0ffULL,
0x000000102d077824ULL, 0x000fe200078e0212ULL, 0xfffffff827277812ULL, 0x000fe200078ee224ULL,
0x00000010231f7824ULL, 0x100fe200078e0212ULL, 0x00000000161b7faeULL, 0x0005e2000c101c46ULL,
0x00005f001a137a11ULL, 0x002fe200030f3c1dULL, 0x00000010251d7824ULL, 0x000fe200078e0212ULL,
0x000000111c147210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1c7224ULL, 0x000fe200020e06ffULL,
0x00005e00191a7a11ULL, 0x000fc600078038ffULL, 0x000000ffff157224ULL, 0x000fe200030e0621ULL,
0x0000001120187210ULL, 0x080fe20007fde0ffULL, 0x0000001027217824ULL, 0x000fe200078e0212ULL,
0x000000111e127210ULL, 0x080fe40007f9e0ffULL, 0x00005f0019177a11ULL, 0x004fe200000f3c1cULL,
0x000000ffff197224ULL, 0x000fe200030e0622ULL, 0x000000111a167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x0000000014077faeULL, 0x0003e6000c901c46ULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x00000000181d7faeULL, 0x0003e8000d101c46ULL,
0x00000000121f7faeULL, 0x0003e8000e901c46ULL, 0x0000000016217faeULL, 0x0003e2000d901c46ULL,
0x00000d6000007947ULL, 0x000fea0003800000ULL, 0x0000000409137811ULL, 0x002fe200078fe8ffULL,
0x000000023d337824ULL, 0x000fe200078e020eULL, 0x00000010091b7811ULL, 0x000fc400078fe8ffULL,
0x00000014091d7811ULL, 0x000fe200078fe8ffULL, 0x0000000113117824ULL, 0x100fe200078e0209ULL,
0x0000001c09217811ULL, 0x000fe200078fe8ffULL, 0x0000000813127824ULL, 0x000fe200078e00ffULL,
0x0000002409357811ULL, 0x000fe200078fe8ffULL, 0x000000011b307824ULL, 0x000fe200078e0209ULL,
0x0000002809367811ULL, 0x000fe200078fe8ffULL, 0x000000081b157824ULL, 0x000fe200078e00ffULL,
0xfffffff812117812ULL, 0x000fe200078ee211ULL, 0x000000011d2f7824ULL, 0x100fe200078e0209ULL,
0x0000000809167811ULL, 0x000fe200078fe8ffULL, 0x000000081d127824ULL, 0x000fe200078e00ffULL,
0xfffffff815307812ULL, 0x000fe200078ee230ULL, 0x00000001212c7824ULL, 0x000fe200078e0209ULL,
0x0000002c09377811ULL, 0x000fe200078fe8ffULL, 0x0000000821157824ULL, 0x000fe200078e00ffULL,
0xfffffff8122f7812ULL, 0x000fe200078ee22fULL, 0x0000000135297824ULL, 0x100fe200078e0209ULL,
0x00000018091f7811ULL, 0x000fe200078fe8ffULL, 0x0000000835127824ULL, 0x000fe200078e00ffULL,
0xfffffff8152c7812ULL, 0x000fe200078ee22cULL, 0x0000000136287824ULL, 0x140fe200078e0209ULL,
0x0000003409397811ULL, 0x040fe200078fe8ffULL, 0x0000000836157824ULL, 0x000fe200078e00ffULL,
0x0000000c09177811ULL, 0x000fe200078fe8ffULL, 0x00000001162b7824ULL, 0x000fe200078e0209ULL,
0xfffffff812297812ULL, 0x000fe200078ee229ULL, 0x0000000816147824ULL, 0x000fe200078e00ffULL,
0xfffffff815287812ULL, 0x000fe200078ee228ULL, 0x0000000137277824ULL, 0x000fe200078e0209ULL,
0x0000002009237811ULL, 0x000fe200078fe8ffULL, 0x0000000837127824ULL, 0x000fe200078e00ffULL,
0xfffffff8142b7812ULL, 0x000fe200078ee22bULL, 0x000000011f2e7824ULL, 0x000fe200078e0209ULL,
0x00000038093b7811ULL, 0x000fe200078fe8ffULL, 0x000000081f197824ULL, 0x000fe200078e00ffULL,
0xfffffff812277812ULL, 0x000fe200078ee227ULL, 0x0000000139247824ULL, 0x100fe200078e0209ULL,
0x0000000209127211ULL, 0x000fe200078fe8ffULL, 0x0000000839157824ULL, 0x000fe200078e00ffULL,
0xfffffff8192e7812ULL, 0x000fe200078ee22eULL, 0x00000001172d7824ULL, 0x000fe200078e0209ULL,
0x0000003009387811ULL, 0x000fe200078fe8ffULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0xfffffff815247812ULL, 0x000fe200078ee224ULL, 0x0000000102147824ULL, 0x000fe200078e0213ULL,
0x0000000712137210ULL, 0x080fe20007f1e0ffULL, 0x00000001232a7824ULL, 0x040fe200078e0209ULL,
0xfffffff8182d7812ULL, 0x000fe200078ee22dULL, 0x0000000823197824ULL, 0x000fe200078e00ffULL,
0x0000000714157210ULL, 0x000fe20007f3e0ffULL, 0x000000013b257824ULL, 0x100fe200078e0209ULL,
0x0000003c093f7811ULL, 0x000fe200078fe8ffULL, 0x000000083b187824ULL, 0x000fe200078e00ffULL,
0xfffffff8192a7812ULL, 0x000fe200078ee22aULL, 0x00000001021a7824ULL, 0x000fe200078e0216ULL,
0x0000000909317211ULL, 0x000fe200078fe8ffULL, 0x0000000138267824ULL, 0x000fe200078e0209ULL,
0xfffffff818257812ULL, 0x000fe200078ee225ULL, 0x0000000838197824ULL, 0x000fe200078e00ffULL,
0x0000100033467811ULL, 0x000fe200078e68ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078238ffULL, 0x00000001021c7824ULL, 0x040fe200078e0217ULL,
0xfffffff819267812ULL, 0x000fe200078ee226ULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078038ffULL, 0x00000001021e7824ULL, 0x040fe200078e021bULL,
0x00005f0015157a11ULL, 0x000fe200008f3c16ULL, 0x0000000102207824ULL, 0x000fe200078e021dULL,
0x000000071c197210ULL, 0x080fe20007f3e0ffULL, 0x0000000102227824ULL, 0x040fe200078e021fULL,
0x00005f0013137a11ULL, 0x000fe200000f3c18ULL, 0x0000000102327824ULL, 0x000fe200078e0223ULL,
0x000000071a177210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078238ffULL, 0x0000000102447824ULL, 0x000fe200078e0235ULL,
0x000000071e1b7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078038ffULL, 0x0000000102407824ULL, 0x040fe200078e0236ULL,
0x00005f0019197a11ULL, 0x000fe200008f3c1aULL, 0x0000000102427824ULL, 0x000fe200078e023fULL,
0x00000007201d7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x00005f0017177a11ULL, 0x000fe200000f3c1cULL, 0x00000001023a7824ULL, 0x040fe200078e0237ULL,
0x00005e001b1a7a11ULL, 0x000fe200078038ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078238ffULL, 0x0000000102387824ULL, 0x040fe200078e0238ULL,
0x00005f001b1b7a11ULL, 0x000fe200000f3c20ULL, 0x0000000102207824ULL, 0x000fe200078e0221ULL,
0x00000007221f7210ULL, 0x080fe20007f1e0ffULL, 0x000000013f337824ULL, 0x000fe200078e0209ULL,
0x00005f001d1d7a11ULL, 0x000fe200008f3c1eULL, 0x000000083f487824ULL, 0x000fe200078e00ffULL,
0x0000000732237210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff227224ULL, 0x000fe200000e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078038ffULL, 0x00000010273f7824ULL, 0x000fe200078e0246ULL,
0x0000000720217210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x00005f001f1f7a11ULL, 0x000fe200000f3c22ULL, 0x0000000102367824ULL, 0x000fe200078e0239ULL,
0x00005e0023227a11ULL, 0x000fe200078038ffULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x0000000744447210ULL, 0x080fe20007fde0ffULL, 0x0000001029397824ULL, 0x000fe200078e0246ULL,
0x00005f0023237a11ULL, 0x000fe200000f3c32ULL, 0x0000001026417824ULL, 0x100fe200078e0246ULL,
0x0000000731327812ULL, 0x000fe200078ec0ffULL, 0x000000ffff277224ULL, 0x000fe200030e06ffULL,
0x00005e0021207a11ULL, 0x000fe200078238ffULL, 0x0000001025457824ULL, 0x100fe200078e0246ULL,
0x0ffffff832317812ULL, 0x000fe200078ef809ULL, 0x000000102a377824ULL, 0x000fe200078e0246ULL,
0x00005f0021217a11ULL, 0x000fe200008f3c34ULL, 0x0000000102347824ULL, 0x000fe200078e023bULL,
0x0000000740407210ULL, 0x080fe20007fbe0ffULL, 0x00000010283b7824ULL, 0x100fe200078e0246ULL,
0x0000000742327210ULL, 0x080fe20007f9e0ffULL, 0x0000001024437824ULL, 0x100fe200078e0246ULL,
0x000000073a3a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff297224ULL, 0x000fe200028e06ffULL,
0x0000000738387210ULL, 0x080fe20007f3e0ffULL, 0x0000001009247824ULL, 0x000fe200078e00ffULL,
0x00005e0044427a11ULL, 0x000fe200078c38ffULL, 0x000000102c357824ULL, 0x100fe200078e0246ULL,
0x0000000736367210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0x00005f0044447a11ULL, 0x000fe200030f3c27ULL, 0x000000ffff277224ULL, 0x000fe200000e06ffULL,
0x00005e0040267a11ULL, 0x000fe200078a38ffULL, 0x0000001011117824ULL, 0x100fe200078e0246ULL,
0x0000000734347210ULL, 0x000fe20007f7e0ffULL, 0x0000001031077824ULL, 0x100fe200078e0246ULL,
0x00005e003a287a11ULL, 0x000fe200078038ffULL, 0x0000001030317824ULL, 0x100fe200078e0246ULL,
0x00005e00382a7a11ULL, 0x000fe200078238ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0246ULL,
0x00005f0040407a11ULL, 0x000fe200028f3c29ULL, 0x000000ffff297224ULL, 0x000fe200010e06ffULL,
0xfffffff848477812ULL, 0x000fe200078ee233ULL, 0x000000102e337824ULL, 0x100fe200078e0246ULL,
0x00005f003a3a7a11ULL, 0x000fe200000f3c27ULL, 0x000000ffff277224ULL, 0x000fe200018e06ffULL,
0x00005f0038387a11ULL, 0x000fe200008f3c25ULL, 0x000000ffff257224ULL, 0x000fe200020e06ffULL,
0x0000007024497812ULL, 0x000fe200078ec0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0246ULL,
0x00005e00362c7a11ULL, 0x000fe200078238ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0246ULL,
0x00005e00342e7a11ULL, 0x000fe200078438ffULL, 0x0000001047477824ULL, 0x000fe200078e0246ULL,
0x00005e0032307a11ULL, 0x000fc400078638ffULL, 0x0000004912127210ULL, 0x080fe40007f1e0ffULL,
0x00005f0036367a11ULL, 0x000fe400008f3c29ULL, 0x00005f0034347a11ULL, 0x000fe200010f3c27ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000004914147210ULL, 0x080fe40007f3e0ffULL,
0x00005f0032327a11ULL, 0x000fe400018f3c25ULL, 0x0000004916167210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000004918187210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012077faeULL, 0x0003e2000b901c46ULL,
0x000000491a1a7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x000000491c1c7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff197224ULL, 0x000fe200018e0619ULL,
0x000000491e1e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e061bULL,
0x0000004920207210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x0000004922227210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000004942247210ULL, 0x080fe20007f7e0ffULL, 0x0000000014117faeULL, 0x0003e2000b901c46ULL,
0x0000004926267210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff217224ULL, 0x000fe200008e0621ULL,
0x0000004928287210ULL, 0x080fe20007f9e0ffULL, 0x00000000162b7faeULL, 0x0005e2000b901c46ULL,
0x000000492a2a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e0623ULL,
0x000000492c2c7210ULL, 0x080fe20007f3e0ffULL, 0x00000000182d7faeULL, 0x0007e2000b901c46ULL,
0x000000492e2e7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200018e0644ULL,
0x0000004930307210ULL, 0x000fe20007f7e0ffULL, 0x000000001a317faeULL, 0x0009e2000b901c46ULL,
0x000000ffff277224ULL, 0x000fc400028e0640ULL, 0x000000ffff297224ULL, 0x000fe200020e063aULL,
0x000000001c2f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2b7224ULL, 0x004fc600000e0638ULL,
0x000000001e337faeULL, 0x0005e2000b901c46ULL, 0x000000ffff2d7224ULL, 0x008fc600008e0636ULL,
0x0000000020357faeULL, 0x0005e2000b901c46ULL, 0x000000ffff317224ULL, 0x010fc600018e0632ULL,
0x0000000022377faeULL, 0x0005e2000b901c46ULL, 0x000000ffff2f7224ULL, 0x002fc600010e0634ULL,
0x0000000024397faeULL, 0x0005e8000b901c46ULL, 0x00000000263b7faeULL, 0x0005e8000b901c46ULL,
0x00000000283f7faeULL, 0x0005e8000b901c46ULL, 0x000000002a417faeULL, 0x0005e8000b901c46ULL,
0x000000002c437faeULL, 0x0005e8000b901c46ULL, 0x000000002e457faeULL, 0x0005e8000b901c46ULL,
0x0000000030477faeULL, 0x0005e4000b901c46ULL, 0x0000000405057810ULL, 0x000fe20007ffe0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff077424ULL, 0x002fc400078e00ffULL,
0x0000003c0500720cULL, 0x000fe40003f06070ULL, 0x0000002009117810ULL, 0x000fe20007ffe0ffULL,
0x000000023d417824ULL, 0x004fd400078e0210ULL, 0x0000000204128824ULL, 0x000fe400078e0205ULL,
0x00000004ff138424ULL, 0x000fc800078e00ffULL, 0x0000600012128625ULL, 0x000fe200078e0013ULL,
0x0000000709427812ULL, 0x040fe200078ec0ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0xfffffff809107812ULL, 0x000fe200078ec0ffULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x0000000612078981ULL, 0x000322000c1e1900ULL, 0x00000004ff407819ULL, 0x000fe20000011609ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0xfffffff811127812ULL, 0x002fe200078ec0ffULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000100041417811ULL, 0x000fe400078e68ffULL,
0x0000000842427812ULL, 0x100fe400078ef809ULL, 0x0000000710437812ULL, 0x100fe400078ef809ULL,
0x00000007123f7812ULL, 0x000fc600078ef809ULL, 0x0000000143107824ULL, 0x060fe200078e0244ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000843117824ULL, 0x000fe400078e00ffULL,
0x0000000244777824ULL, 0x000fc600078e0240ULL, 0xfffffff811107812ULL, 0x000fe200078ee210ULL,
0x000000083f117824ULL, 0x000fc800078e00ffULL, 0x0000001010187824ULL, 0x000fe400078e0241ULL,
0x000000013f107824ULL, 0x000fc800078e0244ULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0xfffffff811107812ULL, 0x000fca00078ee210ULL, 0x0000001010107824ULL, 0x000fcc00078e0241ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x00000018ff737819ULL, 0x002fe20000011418ULL,
0x00010000181c7824ULL, 0x040fe200078e00ffULL, 0x0000888018757816ULL, 0x040fe200000000ffULL,
0x0000010018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011419ULL,
0x00010000191d7824ULL, 0x040fe200078e00ffULL, 0x0000888019717816ULL, 0x040fe200000000ffULL,
0x0000010019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00000018ff6d7819ULL, 0x000fc4000001141aULL,
0x000088801a6f7816ULL, 0x000fe400000000ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001800787306ULL, 0x0003e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff557819ULL, 0x004fe40000011410ULL,
0x0000888010547816ULL, 0x000fc400000000ffULL, 0x00000018ff617819ULL, 0x000fe20000011411ULL,
0x0000001900647306ULL, 0x0005e20000200c00ULL, 0x000100001a187824ULL, 0x042fe200078e00ffULL,
0x0000888011677816ULL, 0x000fe200000000ffULL, 0x000001001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe4000001141bULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001b197824ULL, 0x044fe200078e00ffULL,
0x0000001c007a7306ULL, 0x0003e20000200c00ULL, 0x000088801b5f7816ULL, 0x040fe200000000ffULL,
0x000001001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fc40000011412ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff457819ULL, 0x000fe20000011413ULL,
0x0000001a00727306ULL, 0x0005e20000200c00ULL, 0x00000008431c7824ULL, 0x002fe200078e00ffULL,
0x0000888012657816ULL, 0x000fe400000000ffULL, 0x00008880135d7816ULL, 0x000fe400000000ffULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000001900707306ULL, 0x0003e20000200c00ULL,
0x00000001441a7810ULL, 0x004fc40007ffe0ffULL, 0x0000000244447810ULL, 0x000fc80007ffe0ffULL,
0x000000084400780cULL, 0x000fe20003f05270ULL, 0x0000001d00767306ULL, 0x0005e20000200c00ULL,
0x0000000143197824ULL, 0x102fe400078e021aULL, 0x000000013f1a7824ULL, 0x000fc600078e021aULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee219ULL, 0x0001000011197824ULL, 0x040fe200078e00ffULL,
0x0000001800747306ULL, 0x0003e20000200c00ULL, 0x0000010011117824ULL, 0x000fe400078e00ffULL,
0x000000101c1c7824ULL, 0x000fe200078e0241ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000001b006b7306ULL, 0x0007e20000200c00ULL,
0x000000001c1c783bULL, 0x004ea20000000200ULL, 0x0001000010187824ULL, 0x002fc400078e00ffULL,
0x0000010010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x00000011006a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x000000083f1b7824ULL, 0x008fca00078e00ffULL, 0xfffffff81b1a7812ULL, 0x000fe200078ee21aULL,
0x00000010006e7306ULL, 0x0007e20000200c00ULL, 0x0001000013117824ULL, 0x042fe400078e00ffULL,
0x0000010013137824ULL, 0x000fe400078e00ffULL, 0x000000101a1a7824ULL, 0x000fe200078e0241ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0001000012107824ULL, 0x048fe200078e00ffULL, 0x0000001100627306ULL, 0x0003e20000200c00ULL,
0x0000010012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x0000001000687306ULL, 0x0007e20000200c00ULL,
0x0000001042117824ULL, 0x002fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x004fcc000001141cULL,
0x0000001200637306ULL, 0x000fe20000200c00ULL, 0x000100001c107824ULL, 0x048fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001141dULL, 0x000088801c477816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011410ULL,
0x0000000142107824ULL, 0x000fe200078e0277ULL, 0x0000001300607306ULL, 0x0003e20000200c00ULL,
0x000088801d517816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0xfffffff011107812ULL, 0x000fe200078ee210ULL, 0x000100001d117824ULL, 0x040fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001141eULL, 0x0000001800697306ULL, 0x000fe20000200c00ULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x000088801e537816ULL, 0x000fe200000000ffULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011411ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000019006c7306ULL, 0x0005e20000200c00ULL,
0x000000001010783bULL, 0x002fe20000000200ULL, 0x0000000242777810ULL, 0x000fc40007ffe077ULL,
0x00000018ff4b7819ULL, 0x000fe4000001141fULL, 0x000088801f577816ULL, 0x000fe400000000ffULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x000000001a18783bULL, 0x004eae0000000200ULL,
0x0000001c004f7306ULL, 0x0007f00000200c00ULL, 0x0000001d00567306ULL, 0x0003e20000200c00ULL,
0x000100001e1c7824ULL, 0x008fc400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x000100001f1d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x000001001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x00000018ff1f7819ULL, 0x000fce000001141fULL,
0x0000001c00587306ULL, 0x0007e20000200c00ULL, 0x00000018ff4a7819ULL, 0x004fe40000011418ULL,
0x00000018ff497819ULL, 0x000fe40000011419ULL, 0x00000018ff487819ULL, 0x000fe4000001141aULL,
0x00000018ff467819ULL, 0x000fe2000001141bULL, 0x0000001d005e7306ULL, 0x0005e20000200c00ULL,
0x00005410751c7816ULL, 0x008fce000000007aULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00005410781d7816ULL, 0x004fce0000000073ULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x0000001c1038723cULL, 0x000b6e0000001838ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00005410711c7816ULL, 0x022fe20000000076ULL, 0x0000001042767824ULL, 0x000fe200078e00ffULL,
0x00005410641d7816ULL, 0x000fe2000000005bULL, 0x0001000018647824ULL, 0x000fc600078e00ffULL,
0xfffffff076777812ULL, 0x000fe200078ee277ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000001c1034723cULL, 0x000b6c0000001834ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x000054106f1c7816ULL, 0x024fc40000000074ULL,
0x00005410721d7816ULL, 0x000fe4000000006dULL, 0x00008880196d7816ULL, 0x000fc600000000ffULL,
0x0000005400547306ULL, 0x000ea40000200c00ULL, 0x0000001c1030723cULL, 0x000b6c0000001830ULL,
0x0000001e00597306ULL, 0x0005e20000200c00ULL, 0x000054105f1c7816ULL, 0x022fe40000000070ULL,
0x000054106b1d7816ULL, 0x000fe20000000066ULL, 0x00010000196b7824ULL, 0x000fe200078e00ffULL,
0x000054106e557816ULL, 0x008fe20000000055ULL, 0x000000ffff667224ULL, 0x000fc400078e006dULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x00008880181e7816ULL, 0x044fe200000000ffULL,
0x0000010018187824ULL, 0x000fe200078e00ffULL, 0x0000001c102c723cULL, 0x000fe2000000182cULL,
0x0000541054547816ULL, 0x000fc60000000069ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000006700677306ULL, 0x000ea60000200c00ULL, 0x000000541028723cULL, 0x000bea0000001828ULL,
0x0000001e005b7306ULL, 0x0007e40000200c00ULL, 0x0000010019547824ULL, 0x020fe200078e00ffULL,
0x000054106a197816ULL, 0x002fc40000000061ULL, 0x000088801a617816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe2000001146bULL, 0x0000001f005c7306ULL, 0x0003e20000200c00ULL,
0x00000010771e7824ULL, 0x008fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fcc0000011454ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000000001e1c783bULL, 0x002e6e0000000200ULL,
0x0000006500657306ULL, 0x000ef00000200c00ULL, 0x00000018005f7306ULL, 0x0005f00000200c00ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000541067187816ULL, 0x004fce000000006cULL,
0x0000005d005d7306ULL, 0x000ea20000200c00ULL, 0x000000181024723cULL, 0x000b6e0000001824ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000541065187816ULL, 0x028fe40000000068ULL,
0x0000541063197816ULL, 0x000fe2000000005aULL, 0x000000ffff5a7224ULL, 0x000fc400078e0061ULL,
0x000100001a617824ULL, 0x040fe400078e00ffULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000001001a1a7824ULL, 0x000fe200078e00ffULL, 0x000000181020723cULL, 0x000b6c0000001820ULL,
0x0000005000507306ULL, 0x000ee20000200c00ULL, 0x000054105d187816ULL, 0x024fc40000000062ULL,
0x0000541060197816ULL, 0x000fca0000000045ULL, 0x0000004d004d7306ULL, 0x000ea40000200c00ULL,
0x000000181014723cULL, 0x000b6c0000001814ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000541047107816ULL, 0x028fe20000000050ULL, 0x000001001b187824ULL, 0x000fe200078e00ffULL,
0x000054104f117816ULL, 0x000fc4000000004eULL, 0x000088801b127816ULL, 0x000fe400000000ffULL,
0x00000018ff137819ULL, 0x000fe20000011461ULL, 0x0000005200527306ULL, 0x000ee20000200c00ULL,
0x00000018ff197819ULL, 0x000fe2000001141aULL, 0x000000101c38723cULL, 0x002b620000001838ULL,
0x00000018ff187819ULL, 0x000fca0000011418ULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x0000541056117816ULL, 0x024fe4000000004dULL, 0x0000541051107816ULL, 0x008fca0000000052ULL,
0x0000005a005a7306ULL, 0x000fe40000200c00ULL, 0x000000101c34723cULL, 0x000b6c0000001834ULL,
0x0000001300137306ULL, 0x000fe20000200c00ULL, 0x000100001b117824ULL, 0x020fe400078e00ffULL,
0x000000ffff107224ULL, 0x000fca00078e0012ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x00000018ff117819ULL, 0x000fce0000011411ULL, 0x0000004b004b7306ULL, 0x000ff00000200c00ULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x0000541059597816ULL, 0x002fce000000004cULL,
0x0000004900497306ULL, 0x000ff00000200c00ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054105f5f7816ULL, 0x004fce000000004aULL, 0x0000004600467306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000006400647306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541053587816ULL, 0x002fce0000000058ULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x000000581c30723cULL, 0x000b6e0000001830ULL,
0x0000005400547306ULL, 0x000eb00000200c00ULL, 0x0000001900197306ULL, 0x000ee20000200c00ULL,
0x0000541066667816ULL, 0x002fce0000000055ULL, 0x0000001000127306ULL, 0x0003e20000200c00ULL,
0x0000541054677816ULL, 0x004fce0000000049ULL, 0x00000011001b7306ULL, 0x0004a20000200c00ULL,
0x0000541057107816ULL, 0x002fe2000000005eULL, 0x000000661c24723cULL, 0x000b620000001824ULL,
0x000054105b5e7816ULL, 0x000fe40000000064ULL, 0x0000541019197816ULL, 0x008fc60000000048ULL,
0x0000001800457306ULL, 0x0002e20000200c00ULL, 0x000054105c117816ULL, 0x004fe2000000004bULL,
0x0000005e1c28723cULL, 0x000b620000001828ULL, 0x0000541012127816ULL, 0x000fe4000000001bULL,
0x000054105a187816ULL, 0x002fca0000000013ULL, 0x000000101c2c723cULL, 0x000b62000000182cULL,
0x0000541045137816ULL, 0x008fce0000000046ULL, 0x000000181c20723cULL, 0x040b700000001820ULL,
0x000000121c14723cULL, 0x000b620000001814ULL, 0xfffff09000000947ULL, 0x000fce000383ffffULL,
0x0000000634347220ULL, 0x080fe40000410000ULL, 0x0000000635357220ULL, 0x000fc40000410000ULL,
0x0000000638387220ULL, 0x080fe40000410000ULL, 0x0000000639397220ULL, 0x080fe40000410000ULL,
0x0000000630107220ULL, 0x0a0fe40000410000ULL, 0x0000000631117220ULL, 0x080fe40000410000ULL,
0x000000062d127220ULL, 0x080fe40000410000ULL, 0x0000000628287220ULL, 0x000fc40000410000ULL,
0x0000000626187220ULL, 0x080fe40000410000ULL, 0x0000000627197220ULL, 0x080fe40000410000ULL,
0x00000006331c7220ULL, 0x080fe40000410000ULL, 0x000000062f1e7220ULL, 0x080fe40000410000ULL,
0x000000062a1f7220ULL, 0x080fe40000410000ULL, 0x000000062b1a7220ULL, 0x000fc40000410000ULL,
0x0000000620277220ULL, 0x080fe40000410000ULL, 0x0000000621267220ULL, 0x080fe40000410000ULL,
0x00000006321b7220ULL, 0x080fe40000410000ULL, 0x000000062c337220ULL, 0x080fe40000410000ULL,
0x000000062e1d7220ULL, 0x080fe40000410000ULL, 0x00000006242b7220ULL, 0x000fc40000410000ULL,
0x00000006252a7220ULL, 0x080fe40000410000ULL, 0x0000000622207220ULL, 0x080fe40000410000ULL,
0x0000000623217220ULL, 0x080fe40000410000ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0034ULL,
0x000000ffff307224ULL, 0x000fe400078e0035ULL, 0x000000063a3a7220ULL, 0x000fc40000410000ULL,
0x000000063b3b7220ULL, 0x080fe40000410000ULL, 0x0000000636367220ULL, 0x080fe40000410000ULL,
0x0000000637377220ULL, 0x080fe40000410000ULL, 0x00000006292c7220ULL, 0x080fe40000410000ULL,
0x0000000614257220ULL, 0x080fe40000410000ULL, 0x0000000615247220ULL, 0x000fc40000410000ULL,
0x0000000616227220ULL, 0x080fe40000410000ULL, 0x0000000617237220ULL, 0x000fe40000410000ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0038ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0039ULL,
0x000000ffff317224ULL, 0x000fe400078e0010ULL, 0x000000ffff327224ULL, 0x000fc400078e0011ULL,
0x000000ffff347224ULL, 0x000fe400078e0012ULL, 0x000000ffff357224ULL, 0x000fe200078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000008107f8cULL, 0x0002a2000c80043fULL,
0x000000ffff147224ULL, 0x000fe400078e003aULL, 0x000000ffff157224ULL, 0x000fe400078e003bULL,
0x000000ffff167224ULL, 0x000fe400078e0036ULL, 0x000000ffff177224ULL, 0x000fc400078e0037ULL,
0x0000000000127805ULL, 0x000fca0000015200ULL, 0x0000040008297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x00cfc40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002812377210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e13ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000003728287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040008297984ULL, 0x000ea40000000800ULL, 0x8000000029ff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000409297824ULL, 0x000fe200078e00ffULL,
0x0000000a0c00720cULL, 0x000fc80003f05270ULL, 0xfffffff029287812ULL, 0x000fca00078ec0ffULL,
0x000000803d287824ULL, 0x000fca00078e0228ULL, 0x0174000028107984ULL, 0x0004e20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000209367824ULL, 0x000fe400078e00ffULL,
0x000000013e0d7824ULL, 0x000fc600078e0a0dULL, 0x0000000636367812ULL, 0x000fc800078ec0ffULL,
0x0000000136387812ULL, 0x040fe400078efcffULL, 0x00000008363a7812ULL, 0x000fe400078efcffULL,
0x0000000d3800720cULL, 0x080fe40003f26070ULL, 0x0000001036387812ULL, 0x000fe400078efcffULL,
0x0000000d3a00720cULL, 0x080fe40003f06070ULL, 0x0000000d3800720cULL, 0x000fc40003fc6070ULL,
0x00000011363a7812ULL, 0x040fe400078efcffULL, 0x0000001836387812ULL, 0x040fe400078efcffULL,
0x0000000d3600720cULL, 0x080fe40003f46070ULL, 0x0000000d3a00720cULL, 0x080fe40003fa6070ULL,
0x0000000d3800720cULL, 0x000fe40003f66070ULL, 0x0000000936407812ULL, 0x000fc400078efcffULL,
0x00000019363a7812ULL, 0x040fe400078efcffULL, 0x0000002036387812ULL, 0x000fe400078efcffULL,
0xff80000014147808ULL, 0x000fe40005000000ULL, 0xff8000002d2d7808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40004800000ULL, 0xff8000002e2e7808ULL, 0x000fc40004800000ULL,
0x0000000d4000720cULL, 0x080fe40003f86070ULL, 0x0000000d3a00720cULL, 0x080fe40003f46070ULL,
0x0000000d3800720cULL, 0x000fe40003f26070ULL, 0x00000021363a7812ULL, 0x040fe400078efcffULL,
0x0000002836387812ULL, 0x000fe400078efcffULL, 0xff80000016167808ULL, 0x000fc40004000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004000000ULL, 0xff80000017177808ULL, 0x000fe40006000000ULL,
0xff80000030307808ULL, 0x000fe40006000000ULL, 0x0000000d3a00720cULL, 0x080fe40003f06070ULL,
0x0000000d3800720cULL, 0x000fe40003f86070ULL, 0x00000029363a7812ULL, 0x000fc400078efcffULL,
0x0000003036387812ULL, 0x000fe400078efcffULL, 0xff8000001b1b7808ULL, 0x000fe40007000000ULL,
0xff80000031317808ULL, 0x000fe40007000000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff80000032327808ULL, 0x000fe40006800000ULL, 0x0000000d3a00720cULL, 0x000fc40003fc6070ULL,
0x0000000d3800720cULL, 0x000fe40003fa6070ULL, 0x00000031363a7812ULL, 0x040fe400078efcffULL,
0x0000003836387812ULL, 0x040fe400078efcffULL, 0x0000003936367812ULL, 0x000fe400078efcffULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff80000033337808ULL, 0x000fc40005800000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff80000034347808ULL, 0x000fe40005000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004800000ULL, 0xff80000035357808ULL, 0x000fe40004800000ULL,
0x0000000d3a00720cULL, 0x080fe40003f66070ULL, 0x0000000d3800720cULL, 0x000fc40003f46070ULL,
0x0000000d3600720cULL, 0x000fe40003f26070ULL, 0xff8000001a1a7808ULL, 0x000fe40004000000ULL,
0xff8000002c2c7808ULL, 0x000fe40004000000ULL, 0xff80000018187808ULL, 0x000fe40006000000ULL,
0xff8000002b2b7808ULL, 0x000fe40006000000ULL, 0xff80000019197808ULL, 0x000fc40007000000ULL,
0xff8000002a2a7808ULL, 0x000fe40007000000ULL, 0xff80000020207808ULL, 0x000fe40006800000ULL,
0xff80000027277808ULL, 0x000fe40006800000ULL, 0xff80000021217808ULL, 0x000fe40005800000ULL,
0xff80000026267808ULL, 0x000fe40005800000ULL, 0xff80000022227808ULL, 0x000fc40005000000ULL,
0xff80000025257808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40004800000ULL,
0xff80000024247808ULL, 0x000fc40004800000ULL, 0x0000002d1000720bULL, 0x008fe40003f1e000ULL,
0x000000141100720bULL, 0x000fe40003f3e000ULL, 0x000000102d0d7208ULL, 0x000fe40004000000ULL,
0x0000001114107208ULL, 0x000fc40004800000ULL, 0x0000002e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000151000720bULL, 0x000fe40003f3e000ULL, 0x0000000d2e367208ULL, 0x000fe40004000000ULL,
0x00000010150d7208ULL, 0x000fe40004800000ULL, 0x0000002f3600720bULL, 0x000fe40003f1e000ULL,
0x000000160d00720bULL, 0x000fc40003f3e000ULL, 0x000000362f117208ULL, 0x000fe40004000000ULL,
0x0000000d16107208ULL, 0x000fe40004800000ULL, 0x000000301100720bULL, 0x000fe40003f1e000ULL,
0x000000171000720bULL, 0x000fe40003f3e000ULL, 0x0000001130367208ULL, 0x000fe40004000000ULL,
0x0000001017107208ULL, 0x000fc40004800000ULL, 0x000000313600720bULL, 0x000fe40003f1e000ULL,
0x0000001b1000720bULL, 0x000fe40003f3e000ULL, 0x00000036310d7208ULL, 0x000fe40004000000ULL,
0x000000101b117208ULL, 0x000fe40004800000ULL, 0x000000320d00720bULL, 0x000fe40003f1e000ULL,
0x0000001c1100720bULL, 0x000fc40003f3e000ULL, 0x0000000d32107208ULL, 0x000fe40004000000ULL,
0x000000111c367208ULL, 0x000fe40004800000ULL, 0x000000331000720bULL, 0x000fe40003f1e000ULL,
0x0000001d3600720bULL, 0x000fe40003f3e000ULL, 0x00000010330d7208ULL, 0x000fe40004000000ULL,
0x000000361d117208ULL, 0x000fc40004800000ULL, 0x000000340d00720bULL, 0x000fe40003f1e000ULL,
0x0000001e1100720bULL, 0x000fe40003f3e000ULL, 0x0000000d34107208ULL, 0x000fe40004000000ULL,
0x000000111e367208ULL, 0x000fe40004800000ULL, 0x000000351000720bULL, 0x000fe40003f1e000ULL,
0x0000001f3600720bULL, 0x000fc40003f3e000ULL, 0x00000010350d7208ULL, 0x000fe40004000000ULL,
0x000000361f117208ULL, 0x000fe40004800000ULL, 0x0000002c0d00720bULL, 0x000fe40003f1e000ULL,
0x0000001a1100720bULL, 0x000fe40003f3e000ULL, 0x0000000d2c107208ULL, 0x000fe40004000000ULL,
0x000000111a117208ULL, 0x000fc40004800000ULL, 0x0000002b1000720bULL, 0x000fe40003f1e000ULL,
0x000000181100720bULL, 0x000fe40003f3e000ULL, 0x000000102b0d7208ULL, 0x000fe40004000000ULL,
0x0000001118107208ULL, 0x000fe40004800000ULL, 0x0000002a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000191000720bULL, 0x000fc40003f3e000ULL, 0x0000000d2a367208ULL, 0x000fe40004000000ULL,
0x00000010190d7208ULL, 0x000fe40004800000ULL, 0x000000273600720bULL, 0x000fe40003f1e000ULL,
0x000000200d00720bULL, 0x000fe40003f3e000ULL, 0x0000003627117208ULL, 0x000fe40004000000ULL,
0x0000000d20107208ULL, 0x000fc40004800000ULL, 0x000000261100720bULL, 0x000fe40003f1e000ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000001126367208ULL, 0x000fe40004000000ULL,
0x00000010210d7208ULL, 0x000fe40004800000ULL, 0x000000253600720bULL, 0x000fe40003f1e000ULL,
0x000000220d00720bULL, 0x000fc40003f3e000ULL, 0x0000003625117208ULL, 0x000fe40004000000ULL,
0x0000000d22107208ULL, 0x000fe40004800000ULL, 0x000000241100720bULL, 0x000fe40003f1e000ULL,
0x000000231000720bULL, 0x000fe40003f3e000ULL, 0x0000001124397208ULL, 0x000fe40004000000ULL,
0x00000010233b7208ULL, 0x000fe20004800000ULL, 0x000017827f007947ULL, 0x000fec000b800000ULL,
0x0c401f00390d7f89ULL, 0x00066400000e0000ULL, 0x0000000d3900720bULL, 0x002fc80003f1e000ULL,
0x000000390d3f7208ULL, 0x000fe20004000000ULL, 0x000017b27f007947ULL, 0x000fea000b800000ULL,
0x0c401f003b0d7f89ULL, 0x000e6800000e0000ULL, 0x0c401f0012117f89ULL, 0x000ea800000e0000ULL,
0x0c401f0013107f89ULL, 0x000ee200000e0000ULL, 0x0000000d3b00720bULL, 0x002fc40003f1e000ULL,
0x000000111200720bULL, 0x004fe40003f3e000ULL, 0x0000003b0d377208ULL, 0x000fe40004000000ULL,
0x0000001211387208ULL, 0x000fe40004800000ULL, 0x0c201f003f117f89ULL, 0x000e6200000e0000ULL,
0x000000101300720bULL, 0x008fc60003f1e000ULL, 0x0c201f00373a7f89ULL, 0x000ea200000e0000ULL,
0x00000013100d7208ULL, 0x000fc60004000000ULL, 0x0c201f0038397f89ULL, 0x000ee800000e0000ULL,
0x0c201f000d367f89ULL, 0x0002e400000e0000ULL, 0x000000113f00720bULL, 0x002fe40003f1e000ULL,
0x0000003a3700720bULL, 0x004fe40003f3e000ULL, 0x0000003f11107208ULL, 0x000fc40004000000ULL,
0x000000393800720bULL, 0x008fe40003f5e000ULL, 0x000000373a117208ULL, 0x000fe40004800000ULL,
0x0000003839127208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b10377820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000309ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010837ULL, 0x000000360d00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b2e2e7823ULL, 0x000fc40000010837ULL, 0x00000030003b7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010837ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe40000010837ULL,
0x3fb8aa3b27137823ULL, 0x100fe40000010837ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010837ULL,
0x0000002e00397308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b24307823ULL, 0x004fe40000010837ULL,
0x3fb8aa3b11247820ULL, 0x000fc40000410000ULL, 0x3fb8aa3b32327823ULL, 0x100fe40000010837ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010824ULL, 0x0000002f003a7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b15157823ULL, 0x100fe40000010824ULL, 0x3fb8aa3b16167823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b17177823ULL, 0x000fe40000010824ULL, 0x3fb8aa3b2c2e7823ULL, 0x102fe20000010837ULL,
0x0000001400277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2c7823ULL, 0x000fc40000010837ULL,
0x3fb8aa3b2a2f7823ULL, 0x104fe40000010837ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010837ULL, 0x00000015002a7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b34347823ULL, 0x000fe40000010837ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fc40000010824ULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe20000010824ULL,
0x00000016002b7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010837ULL,
0x3fb8aa3b25257823ULL, 0x000fca0000010837ULL, 0x0000001700407308ULL, 0x000ee20000000800ULL,
0x000000272a15723eULL, 0x002fe200000000ffULL, 0x3c003c00ff2a7424ULL, 0x000fe200078e00ffULL,
0x0000003a3b16723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b193a7823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b1a277823ULL, 0x000fe40000010824ULL, 0x0000002d00387308ULL, 0x0002a20000000800ULL,
0x0000002b4017723eULL, 0x008fe200000000ffULL, 0x3c003c00ff2b7424ULL, 0x000fcc00078e00ffULL,
0x0000001c00427308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b352d7823ULL, 0x002fe20000010837ULL,
0x00000002ff407819ULL, 0x000fe20000011609ULL, 0x3fb8aa3b1f377823ULL, 0x100fe20000010824ULL,
0x000000383914723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b18397823ULL, 0x000fc60000010824ULL,
0x0000001d00357308ULL, 0x000fe20000000800ULL, 0x00000008403f7824ULL, 0x040fe200078e00ffULL,
0x00000002403b7810ULL, 0x000fcc0007ffe0ffULL, 0x0000001e00447308ULL, 0x0003f00000000800ULL,
0x0000001b001b7308ULL, 0x000ea20000000800ULL, 0x0000002a141c723cULL, 0x002f6e00000018ffULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x0000001b4219723eULL, 0x004fe200000000ffULL, 0x0000000840427824ULL, 0x000fe200078e00ffULL,
0x00000035441b723eULL, 0x000fe200000000ffULL, 0x0000000840357824ULL, 0x000fc600078e00ffULL,
0xfffffff8423b7812ULL, 0x000fe200078ee23bULL, 0x0000003300337308ULL, 0x000ff00000000800ULL,
0x0000003400347308ULL, 0x000ea20000000800ULL, 0x000000313218723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b21317823ULL, 0x000fcc0000010824ULL, 0x0000002700387308ULL, 0x0003e20000000800ULL,
0x00000033341a723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b20277823ULL, 0x002fcc0000010824ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22337823ULL, 0x100fe20000010824ULL,
0x0000000140347810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b23247823ULL, 0x000fe40000010824ULL,
0x0000002a1820723cULL, 0x020b62000000181cULL, 0xfffffff835357812ULL, 0x000fe400078ee234ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0xffffffff40347810ULL, 0x000fc60007ffe0ffULL,
0x00000008401e7824ULL, 0x060fe200078e00ffULL, 0x00000003401c7810ULL, 0x040fe40007ffe0ffULL,
0x00000004401d7810ULL, 0x000fe20007ffe0ffULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee21cULL, 0xfffffff81e417812ULL, 0x000fca00078ee21dULL,
0x0000002f002f7308ULL, 0x000ea20000000800ULL, 0x0000002d2e1c723eULL, 0x002fe200000000ffULL,
0x00000008402d7824ULL, 0x040fe200078e00ffULL, 0x00000005402e7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee240ULL, 0x0000003700377308ULL, 0x000e700000000800ULL,
0x0000003900397308ULL, 0x000fe20000000800ULL, 0x0000002c2f1e723eULL, 0x004fe200000000ffULL,
0x00000008402f7824ULL, 0x000fca00078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee22eULL,
0x0000003a003a7308ULL, 0x000ea20000000800ULL, 0x00000037381d723eULL, 0x002fe200000000ffULL,
0x0000000840387824ULL, 0x040fe200078e00ffULL, 0x000110003d2e7811ULL, 0x000fe200078e58ffULL,
0x0000000840377824ULL, 0x000fc800078e00ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x000000102d2d7824ULL, 0x000fe200078e022eULL, 0xfffffff837377812ULL, 0x000fe200078ee234ULL,
0x0000001035357824ULL, 0x100fe400078e022eULL, 0x000000103b3b7824ULL, 0x100fe400078e022eULL,
0x000000103f3f7824ULL, 0x100fe200078e022eULL, 0x000000393a1f723eULL, 0x004fe200000000ffULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x0000000840397810ULL, 0x000fe20007ffe0ffULL,
0x0000001041417824ULL, 0x000fc400078e022eULL, 0x000000102f2f7824ULL, 0x100fe400078e022eULL,
0x0000002a1c20723cULL, 0x000f620000001820ULL, 0x00000008393a7824ULL, 0x000fe200078e00ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000001037377824ULL, 0x000fc600078e022eULL,
0xfffffff83a397812ULL, 0x000fc800078ee239ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000001039397824ULL, 0x000fce00078e022eULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000003100327308ULL, 0x0006700000000800ULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x0000000640317810ULL, 0x008fc80007ffe0ffULL, 0xfffffff838317812ULL, 0x000fc600078ee231ULL,
0x00000024002c7308ULL, 0x0002e40000000800ULL, 0x0000001031317824ULL, 0x000fe200078e022eULL,
0x000000132624723eULL, 0x002fe400000000ffULL, 0x000000253026723eULL, 0x004fe400000000ffULL,
0x000000273225723eULL, 0x000fe400000000ffULL, 0x0000000d36137208ULL, 0x000fe40004800000ULL,
0x000000332c27723eULL, 0x008fc400000000ffULL, 0x0000000c292c7812ULL, 0x000fca00078ec0ffULL,
0x0000002a2420723cULL, 0x020f620000001820ULL, 0x000000012d2d7824ULL, 0x000fe400078e022cULL,
0x000000012c357824ULL, 0x040fe400078e0235ULL, 0x000000012c3b7824ULL, 0x040fe200078e023bULL,
0x000000142d007388ULL, 0x0003e20000000800ULL, 0x000000012c3f7824ULL, 0x040fe400078e023fULL,
0x000000012c417824ULL, 0x040fe200078e0241ULL, 0x0000001635007388ULL, 0x0003e20000000800ULL,
0x000000012c2f7824ULL, 0x000fc400078e022fULL, 0x000000012c317824ULL, 0x040fe200078e0231ULL,
0x000000183b007388ULL, 0x0003e20000000800ULL, 0x000000012c377824ULL, 0x040fe400078e0237ULL,
0x000000012c2c7824ULL, 0x000fe200078e0239ULL, 0x0000001a3f007388ULL, 0x0003e80000000800ULL,
0x0000001c41007388ULL, 0x0003e40000000800ULL, 0x000000ffff217224ULL, 0x020fc400078e0022ULL,
0x0000001e2f007388ULL, 0x0003e80000000800ULL, 0x0000002431007388ULL, 0x0003e80000000800ULL,
0x0000002637007388ULL, 0x0003e80000000800ULL, 0x000000152c007388ULL, 0x0003e80000000800ULL,
0x0004001735007388ULL, 0x0003e80000000800ULL, 0x000400193b007388ULL, 0x0003e80000000800ULL,
0x0004001b3f007388ULL, 0x0003e80000000800ULL, 0x0004001d41007388ULL, 0x0003e80000000800ULL,
0x0004001f2f007388ULL, 0x0003e80000000800ULL, 0x0004002531007388ULL, 0x0003e80000000800ULL,
0x0004002737007388ULL, 0x0003e80000000800ULL, 0x0170001028008388ULL, 0x0003e80000000c00ULL,
0x0172002028008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000bff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008000bff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010000bff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000010c0c7810ULL, 0x000fe20007ffe0ffULL, 0x000018000bff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff107224ULL, 0x002fe200078e000eULL, 0x0000000f0c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb6b000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff177424ULL, 0x000fe200078e00ffULL, 0x000130f0001d7802ULL, 0x000fc40000000f00ULL,
0x0000101000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0017ULL,
0xfffef29000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004000000ULL,
0xffffffffff177424ULL, 0x000fe200078e00ffULL, 0x00013150001d7802ULL, 0x000fc40000000f00ULL,
0x00000fb000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0017ULL,
0xfffef2c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x004fe200078e003fULL,
0x000131c0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000ef000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xfffef36000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e003fULL, 0x00013230001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000e8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xfffef46000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0015ULL,
0x000132b0001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0012ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000e0000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0017ULL,
0xfffef85000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0000ULL,
0x00013330001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff177224ULL, 0x000fc400078e0015ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000d8000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0017ULL,
0xfffef80000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff177424ULL, 0x000fe200078e00ffULL, 0x00013390001d7802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff137224ULL, 0x000fe200078e0017ULL,
0xffff1ac000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004000000ULL,
0xffffffffff177424ULL, 0x000fe200078e00ffULL, 0x000133f0001d7802ULL, 0x000fc40000000f00ULL,
0x00000d1000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0017ULL,
0xffff1b0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00013460001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000c5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff1bc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000134d0001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff1cb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00013550001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0013ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0017ULL,
0xffff20a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x000135c0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000af000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0017ULL, 0xffff206000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe20004000000ULL, 0xffffffffff177424ULL, 0x000fe200078e00ffULL,
0x00013620001d7802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0017ULL, 0xffff400000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004000000ULL, 0xffffffffff177424ULL, 0x000fe200078e00ffULL,
0x00013680001d7802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0017ULL, 0xffff404000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x000136f0001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x000009c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff410000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x00013760001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000095000007944ULL, 0x01afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff41f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000137e0001e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0013ULL, 0x0000001fff1d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x000008d000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0017ULL, 0xffff45e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00013850001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000086000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0017ULL,
0xffff45a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff177424ULL, 0x000fe200078e00ffULL, 0x000138b0001d7802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff137224ULL, 0x000fe200078e0017ULL,
0xffff65b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004000000ULL,
0xffffffffff177424ULL, 0x000fe200078e00ffULL, 0x00013910001d7802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0017ULL,
0xffff65f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00013980001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000073000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff66a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000139f0001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x000006c000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff679000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00013a70001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0013ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000064000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0017ULL,
0xffff6b7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00013ae0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0017ULL, 0xffff6b3000007947ULL, 0x000fea000383ffffULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x00013b5000367802ULL, 0x000fe20000000f00ULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000052000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0038ULL,
0xffffe82000007947ULL, 0x000fea000383ffffULL, 0x000000ffff397224ULL, 0x008fe200078e003bULL,
0x00013bd000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff3a7424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000004a000007944ULL, 0x014fea0003c00000ULL, 0x000000383b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0012ULL, 0x00013c5000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003b38117208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x000000381200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0013ULL, 0x00013cd000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x00000012383b7208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fc400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x000000381300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e003fULL, 0x00013d5000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x00000013380d7208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000383f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0011ULL, 0x00013dd000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003f38107208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fc400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x000000381100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e003bULL, 0x00013e5000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000001138117208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000383b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e000dULL, 0x00013ed000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003b38127208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fc400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e0038ULL,
0xffffe60000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffebf9002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff377424ULL, 0x000fe200078e00ffULL,
0x0000004100007348ULL, 0x000fe80003800000ULL, 0x0c00003a39387389ULL, 0x0002a200000e0038ULL,
0xfffebf5036007950ULL, 0x000fea0003c3ffffULL, 0x0000004000007348ULL, 0x000fe80003800000ULL,
0x0000001017177389ULL, 0x0002a200000e001dULL, 0x00000000ff117424ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x002fc800078e001eULL, 0xfffebf0010007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f05070ULL, 0x0000001700007348ULL, 0x000fe80003800000ULL,
0x00000000ff117424ULL, 0x000fd000078e00ffULL, 0x0000000000107806ULL, 0x000fc800040e0100ULL,
0x0000001710177212ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fc800078e001dULL,
0xfffebe9010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005deULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000348ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d10ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001558ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001568ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015fcULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000014200ULL, 0x8e00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015a00ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015a50ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015dd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015f8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014408ULL, 0x0000000000014408ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015a00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015dd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 89776;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
