/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000013d50ULL, 0x00000000000139d0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL, 0x497461324545386aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x386a4c4536316a4cULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x632e766e2e006675ULL,
0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL, 0x756265642e006d61ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL, 0x000000000000006eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b0ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003feULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000443ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b002200000489ULL, 0x0000000000011e30ULL, 0x0000000000000180ULL,
0x000b0022000004bcULL, 0x0000000000011fb0ULL, 0x0000000000000040ULL, 0x000b0022000004e7ULL,
0x0000000000011ff0ULL, 0x0000000000000050ULL, 0x000b002200000511ULL, 0x0000000000012040ULL,
0x0000000000000140ULL, 0x000a00030000057fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000059fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005cfULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000012180ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00011e3000000000ULL, 0x0000040400000000ULL,
0x810c000001340400ULL, 0x0046480400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808608288080ULL, 0x8090082880808c08ULL,
0x0828808094082880ULL, 0x8080960828808095ULL, 0x9a08288080970828ULL, 0x2880809c08288080ULL,
0x808408288080b108ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080849200ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00011e3000000000ULL, 0x0000018000000000ULL,
0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808408288080ULL,
0x808c082880808608ULL, 0x0828808090082880ULL, 0x8080950828808094ULL, 0x9a08288080960828ULL,
0x2880809c08288080ULL, 0x80b608288080b108ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080b69200ULL, 0x0000001cffffffffULL, 0x0000013800000000ULL, 0x00011fb000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x808c082880808608ULL, 0x0828808090082880ULL,
0x8080950828808094ULL, 0x9708288080960828ULL, 0x2880809a08288080ULL, 0x809c08288080b108ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x22002880809c9200ULL, 0x0000002cffffffffULL,
0x000001e800000000ULL, 0x00011ff000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x80902880809c0900ULL, 0x0000000000002880ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x808c082880808608ULL, 0x0828808094082880ULL,
0x8080960828808095ULL, 0x9c082880809a0828ULL, 0x288080b108288080ULL, 0x8280162880809008ULL,
0x0000000003102880ULL, 0x8080909200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x000002a800000000ULL, 0x0001204000000000ULL, 0x0000014000000000ULL, 0x0000000000000000ULL,
0x0000001a00082f04ULL, 0x0008230400000093ULL, 0x0000000000000016ULL, 0x0000001600081204ULL,
0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL,
0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0050016000000017ULL, 0x000c170400501903ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01342904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000e001342804ULL, 0x0000040000000100ULL,
0x00002450000023a0ULL, 0x000026d000002560ULL, 0x00002b7000002b40ULL, 0x00002c1000002bc0ULL,
0x00004f0000004e60ULL, 0x0000519000005030ULL, 0x0000563000005600ULL, 0x000056d000005680ULL,
0x000076a000007600ULL, 0x00007930000077d0ULL, 0x00007dd000007da0ULL, 0x00007e7000007e20ULL,
0x00009e9000009df0ULL, 0x0000a11000009fb0ULL, 0x0000a5a00000a570ULL, 0x0000a6400000a5f0ULL,
0x0000b7400000b730ULL, 0x000106b000010670ULL, 0x000106d0000106c0ULL, 0x0001074000010720ULL,
0x0001077000010760ULL, 0x00011400000113b0ULL, 0x000114a000011450ULL, 0x0001156000011500ULL,
0x00011600000115b0ULL, 0x0001169000011640ULL, 0x00011740000116f0ULL, 0x000117e000011790ULL,
0x0001188000011830ULL, 0x00011930000118e0ULL, 0x000119d000011980ULL, 0x00011a6000011a10ULL,
0x00011b1000011ac0ULL, 0x00011bc000011b60ULL, 0x00011c8000011c20ULL, 0x00011d4000011ce0ULL,
0x00011e0000011da0ULL, 0x000001f004403904ULL, 0x0000f600000000ffULL, 0x00000260003f0100ULL,
0x0000f60800000005ULL, 0x00000370003f0120ULL, 0x0000f68800000005ULL, 0x000003a0003f0120ULL,
0x0000f6a800000005ULL, 0x000003d0003f0120ULL, 0x0000f6c800000005ULL, 0x00000460003f0120ULL,
0x0000f600000000ffULL, 0x00000600003f0107ULL, 0x0000000400000005ULL, 0x000006b0003f0102ULL,
0x0000000000000005ULL, 0x000010a0003f0101ULL, 0x00000000000000ffULL, 0x0000112000040107ULL,
0x00000000000000ffULL, 0x0000118000040101ULL, 0x0000002000000014ULL, 0x00001330003f0101ULL,
0x0000f6cc00000012ULL, 0x00001510003f0105ULL, 0x0000f6cc00000012ULL, 0x00001ec0003f0105ULL,
0x0000f6a800000047ULL, 0x00002040003f0107ULL, 0x0000f6a800000047ULL, 0x000020a0003f0101ULL,
0x0000f6080000004dULL, 0x000020c0003f0101ULL, 0x0000f60c0000004dULL, 0x00002290003f0105ULL,
0x0000f60c0000004dULL, 0x000028a0003f0105ULL, 0x0000f6ac00000016ULL, 0x00002a70003f0105ULL,
0x0000f6ac00000016ULL, 0x00003d60003f0105ULL, 0x0000f6c800000014ULL, 0x00003de0003f0101ULL,
0x0000f6880000004aULL, 0x00003e60003f0101ULL, 0x000000040000004eULL, 0x00004030003f0105ULL,
0x000000040000004eULL, 0x00004a30003f0105ULL, 0x0000f6a800000057ULL, 0x00004b60003f0107ULL,
0x0000f6a800000057ULL, 0x00004bc0003f0101ULL, 0x0000f6280000004dULL, 0x00004be0003f0101ULL,
0x0000f62c0000004dULL, 0x00004db0003f0105ULL, 0x0000f62c0000004dULL, 0x00005360003f0105ULL,
0x0000f6ac00000047ULL, 0x00005530003f0105ULL, 0x0000f6ac00000047ULL, 0x000065f0003f0105ULL,
0x0000000000000010ULL, 0x00006660003f0101ULL, 0x0000f6900000004aULL, 0x000066d0003f0101ULL,
0x000000040000004eULL, 0x000068a0003f0105ULL, 0x000000040000004eULL, 0x000071a0003f0105ULL,
0x0000000000000058ULL, 0x00007300003f0107ULL, 0x0000f6a800000047ULL, 0x00007360003f0101ULL,
0x0000f6480000004dULL, 0x00007380003f0101ULL, 0x0000f64c0000004dULL, 0x00007550003f0105ULL,
0x0000f64c0000004dULL, 0x00007b00003f0105ULL, 0x0000f6ac00000057ULL, 0x00007cd0003f0105ULL,
0x0000f6ac00000057ULL, 0x00008dd0003f0105ULL, 0x0000000000000014ULL, 0x00008e40003f0101ULL,
0x0000f6980000004aULL, 0x00008ec0003f0101ULL, 0x000000040000004eULL, 0x00009090003f0105ULL,
0x000000040000004eULL, 0x00009990003f0105ULL, 0x0000000000000056ULL, 0x00009af0003f0107ULL,
0x0000f6a800000057ULL, 0x00009b50003f0101ULL, 0x0000f6680000004dULL, 0x00009b70003f0101ULL,
0x0000f66c0000004dULL, 0x00009d40003f0105ULL, 0x0000f66c0000004dULL, 0x0000a2d0003f0105ULL,
0x0000f6ac00000047ULL, 0x0000a4a0003f0105ULL, 0x0000f6ac00000047ULL, 0x0000b4f0003f0105ULL,
0x0000000000000014ULL, 0x0000b550003f0101ULL, 0x0000f6a00000004aULL, 0x0000c300003f0101ULL,
0x0000f600000000ffULL, 0x0000d100003f0101ULL, 0x0000f604000000ffULL, 0x0000d2d0003f0105ULL,
0x0000f604000000ffULL, 0x0000d500003f0105ULL, 0x0000f600000000ffULL, 0x0000d530003f0101ULL,
0x0000f604000000ffULL, 0x0000d6f0003f0105ULL, 0x0000f604000000ffULL, 0x0000fb40003f0105ULL,
0x0000000000000008ULL, 0x0000fba0003f0101ULL, 0x0000000400000008ULL, 0x0000fd70003f0105ULL,
0x0000000400000008ULL, 0x00011210003f0105ULL, 0x000000000000000aULL, 0x00011270003f0101ULL,
0x000000080000000aULL, 0x000112d0003f0101ULL, 0x000000100000000aULL, 0x00011340003f0101ULL,
0x000000180000000aULL, 0x00053803003f0101ULL, 0x0000bfa000141c04ULL, 0x0000d7500000c220ULL,
0x000113800000d820ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000344ULL,
0x0000001a00000002ULL, 0x0000000000000284ULL, 0x0000001a00000002ULL, 0x00000000000001d4ULL,
0x0000001a00000002ULL, 0x000000000000010cULL, 0x0000001a00000002ULL, 0x0000000000000044ULL,
0x0000001a00000002ULL, 0x000000000000031cULL, 0x0000001a00000002ULL, 0x0000000000000261ULL,
0x0000001a00000002ULL, 0x00000000000001b1ULL, 0x0000001a00000002ULL, 0x00000000000000e9ULL,
0x0000001a00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000157806ULL, 0x000fe200038e0000ULL, 0x00005800ff147624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001500067300ULL, 0x000ee600000e0000ULL, 0x0000000000027919ULL, 0x000f280000002200ULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x0000001500157309ULL, 0x000ea60000000000ULL,
0x0000000000127919ULL, 0x000ee80000002600ULL, 0x0000000000047919ULL, 0x000ee20000002700ULL,
0x00000005ff3d7819ULL, 0x002fc60000011605ULL, 0x00000000000d7919ULL, 0x000e680000000000ULL,
0x00001fff03007589ULL, 0x0045e200000e0000ULL, 0x0000010003027a24ULL, 0x010fc600078e0202ULL,
0x00001fff3d3d7589ULL, 0x000f2200000e0000ULL, 0x0000000002057a24ULL, 0x000fe200078e0205ULL,
0x000000070600720cULL, 0x008fe20003f02070ULL, 0x0000000814067824ULL, 0x000fe400078e00ffULL,
0x0000000812077824ULL, 0x000fe200078e00ffULL, 0x000000ff0500720cULL, 0x040fe40003f45270ULL,
0x0000000f0500780cULL, 0x040fe20003f64070ULL, 0x0000000406077224ULL, 0x000fe200078e0207ULL,
0x0000007f0500780cULL, 0x000fc40003f84070ULL, 0x000000030500780cULL, 0x000fe40003f24070ULL,
0x00000004ff137819ULL, 0x002fca000001160dULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x004fe400078e00ffULL, 0x00000004000a7824ULL, 0x010fe400078e023dULL,
0x3fffffc0ff08b424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x000000020a067824ULL, 0x000fe200078e00ffULL, 0x000000010500780cULL, 0x000fe20003f44070ULL,
0x7fffffc0ff09b424ULL, 0x000fc400078e00ffULL, 0x00000001060e7824ULL, 0x040fe200078e0213ULL,
0x00000008060f7817ULL, 0x000fe20007800000ULL, 0xff317217ff10c424ULL, 0x000fe200078e00ffULL,
0x00f608080500b388ULL, 0x0005e20000008a00ULL, 0x3fffff60ff0a9424ULL, 0x000fe400078e00ffULL,
0x000000010f0c7824ULL, 0x000fe200078e0a06ULL, 0x00f400100500c388ULL, 0x0007e20000004800ULL,
0x000000100d067824ULL, 0x000fe400078e00ffULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x0000000c1300720cULL, 0x000fe20003f66070ULL, 0x0000000107027824ULL, 0x000fc400078e020eULL,
0x000000010e077824ULL, 0x000fe200078e020dULL, 0x000000f006097812ULL, 0x004fe200078ec0ffULL,
0x000000100e087824ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0003ULL,
0xfffffff008077812ULL, 0x000fe200078ee207ULL, 0x7fffff60ff0b9424ULL, 0x000fe200078e00ffULL,
0x0000000902087210ULL, 0x000fe20007f9e0ffULL, 0x3fffff80ff0e9424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0f9424ULL, 0x000fe200078e00ffULL, 0x00f6880a05009388ULL, 0x000fe20000008a00ULL,
0x3fffffc0ff10a424ULL, 0x008fe400078e00ffULL, 0x7fffffc0ff11a424ULL, 0x000fe200078e00ffULL,
0x00f6a80e05009388ULL, 0x000fe20000008a00ULL, 0x000000ffff097224ULL, 0x000fc400020e0603ULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x00f6c8100500a388ULL, 0x000fe20000008a00ULL,
0x000000ffff027224ULL, 0x000fe400078e0a15ULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008077faeULL, 0x0003e2000d901c46ULL, 0x00006200043e7625ULL, 0x000fc600078e0003ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60402ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000063e3e7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fc40003f05270ULL,
0x0000003f3e3c7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff3e027810ULL, 0x002fe40007ffe0ffULL,
0x00000006ff3c7819ULL, 0x000fe4000001163cULL, 0x00000008ff0f7819ULL, 0x000fca0000011602ULL,
0x0000bce000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe2000001163dULL,
0x00000003ff0a7424ULL, 0x000fc600078e00ffULL, 0x03ffffff0c417812ULL, 0x000fc800078ec0ffULL,
0x0000003c4100720cULL, 0x000fda0003f06070ULL, 0x0000000204008824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640000088624ULL, 0x000fe200078e0205ULL,
0x0000f6883d057811ULL, 0x000fe200078e18ffULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x0000000141088824ULL, 0x000fe200078e0208ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040a05ff738cULL, 0x0003e20000000000ULL, 0x0000600008088625ULL, 0x000fe200078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000608008981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x00000040120a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe2000001163dULL, 0x0000000005ff7f8cULL, 0x0003e8000c80043fULL,
0x000000200e0b7824ULL, 0x000fca00078e00ffULL, 0x000000200a027812ULL, 0x000fe200078ef80bULL,
0x0000580000077a24ULL, 0x004fe200078e02ffULL, 0x000000013d007812ULL, 0x000fc600078ec0ffULL,
0x0000004007157824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000001000057824ULL, 0x002fe200078e00ffULL, 0x0000000b3e007217ULL, 0x000fe40007800000ULL,
0x00000003ff077819ULL, 0x000fe4000001160dULL, 0x00000070061d7812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x0000000407107810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0207ULL, 0x0000000807117810ULL, 0x000fc40007ffe0ffULL,
0x0000000500007217ULL, 0x000fe20007800000ULL, 0x0000000108097824ULL, 0x040fe400078e020dULL,
0x0000000808127824ULL, 0x000fe400078e00ffULL, 0x0000000102087824ULL, 0x000fe400078e0208ULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0xfffffff812097812ULL, 0x000fe400078ee209ULL,
0x0000000815087210ULL, 0x000fc40007f1e0ffULL, 0x0000000c07127810ULL, 0x000fe40007ffe0ffULL,
0x000000001000720cULL, 0x080fe20003f46070ULL, 0x0000000105107824ULL, 0x000fe200078e0210ULL,
0x000000001100720cULL, 0x080fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e0008187a11ULL, 0x000fe200078838ffULL, 0x0000000105117824ULL, 0x000fe200078e0211ULL,
0x000000000700720cULL, 0x080fe20003f66070ULL, 0x0000000105057824ULL, 0x000fe200078e0212ULL,
0x000000001200720cULL, 0x000fe20003f06070ULL, 0x0000000110077824ULL, 0x000fe200078e020dULL,
0x00005f0008127a11ULL, 0x000fe200020f3c13ULL, 0x0000000810147824ULL, 0x000fc400078e00ffULL,
0x0000000102107824ULL, 0x040fe400078e0210ULL, 0x0000000102007824ULL, 0x000fe200078e0211ULL,
0xfffffff814077812ULL, 0x000fe200078ee207ULL, 0x0000000102087824ULL, 0x000fe200078e0205ULL,
0x0000001015167210ULL, 0x000fe20007f9e0ffULL, 0x0000000111027824ULL, 0x100fe200078e020dULL,
0x0000000015147210ULL, 0x000fe20007fbe0ffULL, 0x0000000811117824ULL, 0x000fe200078e00ffULL,
0x0000000815107210ULL, 0x000fe20007fde0ffULL, 0x0000000805137824ULL, 0x000fe200078e00ffULL,
0x0000b0000e007811ULL, 0x000fe200078e68ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e06ffULL,
0xfffffff811117812ULL, 0x000fe200078ee202ULL, 0x0000000105027824ULL, 0x000fc400078e020dULL,
0x000000ffff057224ULL, 0x000fe200020e06ffULL, 0x00005e0016087a11ULL, 0x040fe200078838ffULL,
0x0000001007157824ULL, 0x000fe200078e0200ULL, 0xfffffff813137812ULL, 0x000fe200078ee202ULL,
0x0000001011177824ULL, 0x100fe200078e0200ULL, 0x00005f0016167a11ULL, 0x000fe200020f3c05ULL,
0x0000001009057824ULL, 0x100fe200078e0200ULL, 0x000000181d067210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005e0014117a11ULL, 0x000fe200078a38ffULL,
0x0000001013197824ULL, 0x000fc400078e0200ULL, 0x000000ffff077224ULL, 0x000fe200020e0612ULL,
0x00005e0010127a11ULL, 0x000fe400078c38ffULL, 0x0000001d08087210ULL, 0x080fe40007f9e0ffULL,
0x00005f0014027a11ULL, 0x000fe200028f3c1bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000d901c46ULL, 0x00005f0010007a11ULL, 0x000fe200030f3c09ULL,
0x000000ffff097224ULL, 0x000fe200020e0616ULL, 0x0000001d11107210ULL, 0x080fe40007fbe0ffULL,
0x0000001d12127210ULL, 0x000fc40007f9e0ffULL, 0x0000000008157faeULL, 0x0003e2000d101c46ULL,
0x000000ffff117224ULL, 0x000fe400028e0602ULL, 0x000000ffff137224ULL, 0x000fc600020e0600ULL,
0x0000000010177faeULL, 0x0003e8000c901c46ULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x002fe200078e00ffULL,
0x0000b0000e197811ULL, 0x000fe400078e68ffULL, 0x0000007006167812ULL, 0x000fe400078ec0ffULL,
0x000000000d007211ULL, 0x000fc800078fe8ffULL, 0x0000000400077810ULL, 0x040fe20007ffe0ffULL,
0x0000000100057824ULL, 0x140fe200078e020dULL, 0x0000000800097810ULL, 0x040fe20007ffe0ffULL,
0x0000000800107824ULL, 0x000fe400078e00ffULL, 0x0000000107087824ULL, 0x040fe400078e020dULL,
0x0000000807117824ULL, 0x000fe200078e00ffULL, 0xfffffff810057812ULL, 0x000fe200078ee205ULL,
0x0000000102077824ULL, 0x040fe400078e0207ULL, 0x0000000102107824ULL, 0x000fe200078e0209ULL,
0xfffffff811087812ULL, 0x000fe200078ee208ULL, 0x0000001005057824ULL, 0x000fe200078e0219ULL,
0x0000000c00117810ULL, 0x000fe20007ffe0ffULL, 0x0000000102007824ULL, 0x000fe200078e0200ULL,
0x0000000715137210ULL, 0x000fc40007f5e0ffULL, 0x0000001015077210ULL, 0x040fe20007f7e0ffULL,
0x0000000102027824ULL, 0x000fe200078e0211ULL, 0x0000000015147210ULL, 0x000fe20007f3e0ffULL,
0x0000000109007824ULL, 0x100fe400078e020dULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0x0000000215107210ULL, 0x000fe20007f1e0ffULL, 0x0000000809157824ULL, 0x000fe400078e00ffULL,
0x0000000111027824ULL, 0x000fe400078e020dULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005e0014097a11ULL, 0x000fe200078238ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0xfffffff815007812ULL, 0x000fe200078ee200ULL, 0x0000001008157824ULL, 0x000fe200078e0219ULL,
0xfffffff817027812ULL, 0x000fc400078ee202ULL, 0x00005f0014147a11ULL, 0x000fe200008f3c11ULL,
0x0000001000177824ULL, 0x100fe200078e0219ULL, 0x00005e0013087a11ULL, 0x000fe200078238ffULL,
0x0000001002197824ULL, 0x000fe200078e0219ULL, 0x00005e0007117a11ULL, 0x000fe200078438ffULL,
0x000000ffff027224ULL, 0x000fe200018e06ffULL, 0x00005f0013137a11ULL, 0x000fe400008f3c12ULL,
0x0000000916067210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0010127a11ULL, 0x000fc400078638ffULL, 0x00005f0007027a11ULL, 0x000fe200010f3c02ULL,
0x000000ffff077224ULL, 0x000fe200008e0614ULL, 0x0000000816087210ULL, 0x000fe40007f1e0ffULL,
0x00005f0010007a11ULL, 0x000fe400018f3c09ULL, 0x0000001116107210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0613ULL, 0x0000001216127210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e4000b901c46ULL,
0x000000ffff117224ULL, 0x000fc400008e0602ULL, 0x000000ffff137224ULL, 0x000fe200010e0600ULL,
0x0000000008157faeULL, 0x0003e8000b901c46ULL, 0x0000000010177faeULL, 0x0003e8000b901c46ULL,
0x0000000012197faeULL, 0x0003e4000b901c46ULL, 0x0000000141417810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff097424ULL, 0x002fc600078e00ffULL, 0x0000003c4100720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x0000000204007824ULL, 0x000fe400078e00ffULL,
0x00006400ff057624ULL, 0x000fc800078e00ffULL, 0x0000640000007624ULL, 0x000fc800078e0205ULL,
0x0000000100027824ULL, 0x000fc800078e0241ULL, 0x0000600002027625ULL, 0x000fca00078e0003ULL,
0x0000000602097981ULL, 0x000324000c1e1900ULL, 0x000000000e0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000f6a80e147811ULL, 0x000fe200078e18ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff5c7f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200014147f8cULL, 0x000ee2000c80043fULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000a39000008947ULL, 0x000fea0003800000ULL, 0x0000000204087824ULL, 0x000fe400078e00ffULL,
0x00006400ff037624ULL, 0x002fc400078e00ffULL, 0xff317217ff5b7424ULL, 0x000fe400078e00ffULL,
0x0000640008087624ULL, 0x000fe400078e0203ULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x0000010006057824ULL, 0x000fca00078e00ffULL, 0x0000003e0500720cULL, 0x000fda0003f06070ULL,
0x0000a2b000000947ULL, 0x00afea0003800000ULL, 0x000000ffff057224ULL, 0x000fe400078e0041ULL,
0x000000ffff047224ULL, 0x000fc400078e0013ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x000000043d127824ULL, 0x000fca00078e00ffULL, 0xfffffff812127812ULL, 0x000fc800078ec0ffULL,
0x0000f6c8124e7810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc0012147984ULL, 0x008e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x00000016101d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e11ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000001d14147211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc0012147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000103d107824ULL, 0x000fe200078e00ffULL,
0x0000000106127810ULL, 0x000fe20007ffe0ffULL, 0x0000580009097a24ULL, 0x010fe200078e02ffULL,
0x0000000113497812ULL, 0x000fe400078e0cffULL, 0x0000000f1200720cULL, 0x000fe20003f06070ULL,
0x0000004009407824ULL, 0x000fe200078e00ffULL, 0xffffffe010117812ULL, 0x000fca00078ec0ffULL,
0x0000010006117824ULL, 0x000fca00078e0211ULL, 0x0000004011117810ULL, 0x000fc80007ffe0ffULL,
0x000000200a437812ULL, 0x000fe200078ef811ULL, 0x0000049000008947ULL, 0x000fea0003800000ULL,
0x0000001010127812ULL, 0x000fe200078ec0ffULL, 0x000000020e177824ULL, 0x000fe200078e0249ULL,
0x00000003ff1e7819ULL, 0x000fc8000001160dULL, 0x000000041e447810ULL, 0x040fe20007ffe0ffULL,
0x000000011e107824ULL, 0x040fe200078e0212ULL, 0x0000b00017177811ULL, 0x000fe400078e60ffULL,
0x0000000c1e457810ULL, 0x000fe20007ffe0ffULL, 0x0000000143097824ULL, 0x000fe400078e0210ULL,
0x0000000144167824ULL, 0x000fe400078e0212ULL, 0x00000008101c7824ULL, 0x000fe200078e00ffULL,
0x00000009401d7210ULL, 0x000fc40007f1e0ffULL, 0x000000113e097217ULL, 0x000fc60007800000ULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00005e001d157a11ULL, 0x000fe200078038ffULL,
0x0000000109097824ULL, 0x000fe400078e0a11ULL, 0x000000100d117824ULL, 0x000fe200078e00ffULL,
0x00005f001d1d7a11ULL, 0x000fe200000f3c14ULL, 0x0000000143147824ULL, 0x000fe200078e0216ULL,
0x0000001209097217ULL, 0x000fe40007800000ULL, 0x0000007011427812ULL, 0x000fe200078ec0ffULL,
0x0000000110117824ULL, 0x100fe200078e020dULL, 0x00000014403f7210ULL, 0x000fe20007fde0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a12ULL, 0x0000004215107210ULL, 0x000fe20007fbe0ffULL,
0x0000000116157824ULL, 0x000fe200078e020dULL, 0xfffffff81c147812ULL, 0x000fe200078ee211ULL,
0x000000ffff1c7224ULL, 0x000fe200030e06ffULL, 0x000000091e00720cULL, 0x080fe20003f06070ULL,
0x000000ffff117224ULL, 0x000fe200028e061dULL, 0x000000094400720cULL, 0x000fe20003fa6070ULL,
0x00000010141d7824ULL, 0x000fe200078e0217ULL, 0x00005e003f1f7a11ULL, 0x000fe200078c38ffULL,
0x0000000816167824ULL, 0x000fe200078e00ffULL, 0x000000081e447810ULL, 0x000fc40007ffe0ffULL,
0x00005f003f3f7a11ULL, 0x000fe400030f3c1cULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x00000001441c7824ULL, 0x000fe400078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0x000000421f147210ULL, 0x000fe20007f1e0ffULL,
0x00000001431e7824ULL, 0x000fe400078e021cULL, 0x0000000145127824ULL, 0x000fe400078e0212ULL,
0x000000ffff157224ULL, 0x000fe200000e063fULL, 0x0000001e401e7210ULL, 0x000fc40007fde0ffULL,
0x000000094400720cULL, 0x000fe20003f06070ULL, 0x00000010161d7824ULL, 0x002fe400078e0217ULL,
0x0000000143107824ULL, 0x000fe400078e0212ULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x00000000141d7faeULL, 0x0003e2000e901c46ULL, 0x00005e001e117a11ULL, 0x000fe400078a38ffULL,
0x0000001040167210ULL, 0x000fe40007fde0ffULL, 0x00005f001e1e7a11ULL, 0x000fc400028f3c1fULL,
0x000000094500720cULL, 0x000fe20003fa6070ULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x0000004211107210ULL, 0x000fe20007fde0ffULL, 0x000000011c097824ULL, 0x140fe400078e020dULL,
0x000000081c1c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200030e061eULL,
0x00005e0016147a11ULL, 0x002fe200078c38ffULL, 0x0000000112157824ULL, 0x040fe400078e020dULL,
0x00000008121e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c127812ULL, 0x000fc400078ee209ULL,
0x00005f00161c7a11ULL, 0x000fe400030f3c1fULL, 0x0000004214147210ULL, 0x000fe20007fde0ffULL,
0x0000001012097824ULL, 0x000fe200078e0217ULL, 0xfffffff81e167812ULL, 0x000fc600078ee215ULL,
0x000000ffff157224ULL, 0x000fe200030e061cULL, 0x0000000010097faeULL, 0x0003e2000c101c46ULL,
0x0000001016177824ULL, 0x000fca00078e0217ULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x000003c000007947ULL, 0x000fea0003800000ULL, 0x0000001010107812ULL, 0x000fc800078ec0ffULL,
0x000000100d107211ULL, 0x000fc800078fe8ffULL, 0x0000000410147810ULL, 0x040fe20007ffe0ffULL,
0x0000000143097824ULL, 0x040fe400078e0210ULL, 0x0000000110117824ULL, 0x100fe400078e020dULL,
0x0000000114157824ULL, 0x000fe200078e020dULL, 0x00000009403f7210ULL, 0x000fe20007f1e0ffULL,
0x0000000814167824ULL, 0x000fe400078e00ffULL, 0x0000000810127824ULL, 0x000fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0xfffffff816177812ULL, 0x000fe200078ee215ULL,
0x0000000143147824ULL, 0x000fe200078e0214ULL, 0x0000000810167810ULL, 0x000fc40007ffe0ffULL,
0x0000000c10107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff812127812ULL, 0x000fe200078ee211ULL,
0x0000000143097824ULL, 0x000fe200078e0216ULL, 0x00005e003f1f7a11ULL, 0x000fe200078038ffULL,
0x0000000143117824ULL, 0x000fe200078e0210ULL, 0x0000001440157210ULL, 0x000fe20007fde0ffULL,
0x00000008101e7824ULL, 0x000fe200078e00ffULL, 0x0000000940427210ULL, 0x000fe20007fbe0ffULL,
0x0000000116097824ULL, 0x140fe200078e020dULL, 0x00005f003f3f7a11ULL, 0x000fe200000f3c1cULL,
0x0000000816167824ULL, 0x000fe200078e00ffULL, 0x0000001140407210ULL, 0x000fe20007f1e0ffULL,
0x0000000110117824ULL, 0x000fc400078e020dULL, 0x000000ffff107224ULL, 0x000fe200030e06ffULL,
0xfffffff8161d7812ULL, 0x000fe200078ee209ULL, 0x000000100d097824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00005e0042167a11ULL, 0x040fe400078a38ffULL, 0x00005e0015147a11ULL, 0x000fe400078c38ffULL,
0x0000007009437812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005f0042427a11ULL, 0x000fe200028f3c11ULL, 0x000000020e117824ULL, 0x000fe200078e0249ULL,
0x00005f0015157a11ULL, 0x000fc400030f3c10ULL, 0x000000431f107210ULL, 0x080fe40007f1e0ffULL,
0x0000004314147210ULL, 0x080fe40007fbe0ffULL, 0x00005e00401c7a11ULL, 0x000fe400078c38ffULL,
0x0000b00011447811ULL, 0x000fe200078e60ffULL, 0x000000ffff117224ULL, 0x000fe200000e063fULL,
0x0000004316167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0615ULL,
0x00005f0040407a11ULL, 0x000fe200030f3c09ULL, 0x0000001012097824ULL, 0x100fe200078e0244ULL,
0x000000431c1c7210ULL, 0x000fe20007fbe0ffULL, 0x00000010171f7824ULL, 0x000fc400078e0244ULL,
0x000000101d3f7824ULL, 0x000fe200078e0244ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010097faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fe400000e0642ULL,
0x000000101e437824ULL, 0x000fe200078e0244ULL, 0x00000000141f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1d7224ULL, 0x000fc600028e0640ULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c437faeULL, 0x0003e4000b901c46ULL, 0x000000083d127824ULL, 0x000fe200078e00ffULL,
0x0000000141097810ULL, 0x002fc80007ffe0ffULL, 0xfffffff012147812ULL, 0x000fe400078ec0ffULL,
0x0000003c0900720cULL, 0x000fc60003f06070ULL, 0x0000000849477824ULL, 0x000fca00078e0214ULL,
0x0000000000007918ULL, 0x000fea0000000000ULL, 0x0000000108108824ULL, 0x000fe400078e0209ULL,
0x00000004ff118424ULL, 0x000fe400078e00ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0xffffffe0124d7812ULL, 0x000fe200078ec0ffULL, 0x0000600010108625ULL, 0x000fe200078e0011ULL,
0x0000001012147812ULL, 0x000fc400078ec0ffULL, 0x0000000812127812ULL, 0x000fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x0000000610098981ULL, 0x000322000c1e1900ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000004d124d7210ULL, 0x000fe40007ffe014ULL,
0x0000f6a847587810ULL, 0x000fd20007ffe0ffULL, 0x00000000580403c2ULL, 0x000ee40000060000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20001f0f070ULL,
0xffffff8000003947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80047807f8cULL, 0x000662000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f608004d167f8cULL, 0x0006a4000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x00f60c004d157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x006fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014101d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011415ULL,
0x0000001d12127211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000212127819ULL, 0x000fc80000001215ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c004d157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d107824ULL, 0x000fe200078e00ffULL, 0x00000001ff4b7819ULL, 0x000fe2000001160dULL,
0x000000203d4c7824ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fe200078e00ffULL,
0x00000070101c7812ULL, 0x000fc400078ec0ffULL, 0xffffff804c4c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c4b4b7812ULL, 0x000fc800078ec0ffULL, 0x0000004c4b107210ULL, 0x000fca0007ffe01cULL,
0x00f0000010127984ULL, 0x000e680000000800ULL, 0x00f2000010147984ULL, 0x0004e20000000800ULL,
0x0000005b1200720bULL, 0x002fe20003f1d000ULL, 0x0000eff27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff101e7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff407224ULL, 0x000fc400078e005bULL, 0x0000001fff487424ULL, 0x000fe400078e00ffULL,
0xffffffffff457424ULL, 0x000fca00078e00ffULL, 0x0000043000008947ULL, 0x000fea0003800000ULL,
0x0000003d0c00720cULL, 0x000fe40003fa5270ULL, 0x0000005b1200720bULL, 0x000fe20003f14000ULL,
0x0000ef927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x000fc400000e0100ULL,
0x000000803d10d824ULL, 0x000fe200078e021cULL, 0x000000125b407209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x000000014b11d824ULL, 0x000fe200078e0210ULL,
0x0000991015107816ULL, 0x000fc800000000ffULL, 0x00f400401100d388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000405b107221ULL, 0x002fe20000010000ULL, 0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x00000010001d7308ULL, 0x0002ac0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x002fe2000001160dULL, 0x0000eed27f007947ULL, 0x000fea000b800000ULL,
0x00001f101d107589ULL, 0x0042a400000e0000ULL, 0x0000001020207220ULL, 0x084fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001038387220ULL, 0x080fe20000410000ULL,
0x0000001039397220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001d07077220ULL, 0x004fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x002fe200078ff0ffULL,
0x0000edb27f007947ULL, 0x000fea000b800000ULL, 0x00001f101d107589ULL, 0x0002a400000e0000ULL,
0x0000001022227220ULL, 0x084fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x000000103a3a7220ULL, 0x080fe20000410000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff1eff7812ULL, 0x000fda0007806015ULL,
0x8000004012120221ULL, 0x000fe20000010000ULL, 0x00007610ff6e0816ULL, 0x000fc6000000006eULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x0000001200020308ULL, 0x000e640000000800ULL,
0x0000000214140220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000714077221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000020e127824ULL, 0x000fc800078e0213ULL, 0x0000000812167824ULL, 0x000fca00078e00ffULL,
0x00f6ac0016127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011415ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000212127819ULL, 0x000fc80000001215ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0016127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106e107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000002ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff127819ULL, 0x000fe4000001160dULL,
0x0000541000157816ULL, 0x000fe20000000000ULL, 0x0000e9927f007947ULL, 0x000fea000b800000ULL,
0x00001f1215037589ULL, 0x0002a400000e0000ULL, 0x0000000812007810ULL, 0x000fe20007ffe0ffULL,
0x0000e9c27f007947ULL, 0x000fea000b800000ULL, 0x00001f0015007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001012107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0015ULL, 0x00002bd0001c7802ULL, 0x000fc40000000f00ULL,
0x0000f42000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001812107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0015ULL,
0x00002c20001c7802ULL, 0x000fc40000000f00ULL, 0x0000f3d000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070d107812ULL, 0x000fe200078ec0ffULL,
0x000000023d507824ULL, 0x040fe200078e00ffULL, 0x00000004ff707819ULL, 0x100fe2000001160dULL,
0x000002003d3f7824ULL, 0x000fe200078e00ffULL, 0x0000000810757812ULL, 0x000fe200078ef80dULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000450107812ULL, 0x000fc400078ec0ffULL,
0xfffff8003f3f7812ULL, 0x000fe200078ec0ffULL, 0x0000000875117824ULL, 0x040fe200078e00ffULL,
0x0000001075107210ULL, 0x000fe40007ffe070ULL, 0x000000080d5a7812ULL, 0x000fe400078ec0ffULL,
0xfffffff811107812ULL, 0x000fca00078ee210ULL, 0x0000001010447824ULL, 0x000fc400078e023fULL,
0x000000043d597824ULL, 0x000fe200078e00ffULL, 0x000000075a5a7812ULL, 0x000fe200078ef80dULL,
0x000000020e537824ULL, 0x000fc600078e0213ULL, 0x0000000459597812ULL, 0x000fe200078ec0ffULL,
0x000000085a117824ULL, 0x040fe200078e00ffULL, 0x0000b00053537811ULL, 0x000fe400078e60ffULL,
0x000000105a5c7812ULL, 0x000fe200078efcffULL, 0x0000000170597824ULL, 0x000fc800078e0259ULL,
0x000000015a107824ULL, 0x000fe400078e0259ULL, 0x000000085c517824ULL, 0x000fe400078e00ffULL,
0x0000000159527824ULL, 0x000fe200078e025cULL, 0xfffffff811127812ULL, 0x002fe400078ee210ULL,
0x0000000210547810ULL, 0x000fe40007ffe0ffULL, 0xfffffff851517812ULL, 0x000fe200078ee252ULL,
0x0000001012127824ULL, 0x000fe200078e0253ULL, 0x0000000252527810ULL, 0x000fc60007ffe0ffULL,
0x0000001051147824ULL, 0x000fe200078e0253ULL, 0x00000000121c783bULL, 0x000e6a0000004200ULL,
0x000000001414783bULL, 0x00cea20000004200ULL, 0x00000018ff837819ULL, 0x002fe2000001141cULL,
0x000001001c117824ULL, 0x040fe200078e00ffULL, 0x000088801c877816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe2000001141dULL,
0x000001001d557824ULL, 0x040fe200078e00ffULL, 0x000088801d857816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x00000018ff8a7819ULL, 0x000fe20000011411ULL,
0x000000085a117824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff4f7819ULL, 0x004fe40000011414ULL, 0xfffffff811547812ULL, 0x000fe200078ee254ULL,
0x0000001c00867306ULL, 0x0003e20000200c00ULL, 0x0000888014667816ULL, 0x000fe400000000ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011415ULL, 0x0000001054107824ULL, 0x000fe200078e0253ULL,
0x00000018ff437819ULL, 0x000fe40000011416ULL, 0x00000018ff427819ULL, 0x000fe20000011417ULL,
0x0000001d00847306ULL, 0x0005e20000200c00ULL, 0x000001001e1c7824ULL, 0x002fe200078e00ffULL,
0x0000888015657816ULL, 0x000fe200000000ffULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x0000888016627816ULL, 0x000fc400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00008880175e7816ULL, 0x000fe200000000ffULL, 0x000000085c1d7824ULL, 0x004fe200078e00ffULL,
0x0000001c007f7306ULL, 0x0005e20000200c00ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff567819ULL, 0x000fe4000001141eULL, 0xfffffff81d527812ULL, 0x000fe400078ee252ULL,
0x00000018ff577819ULL, 0x000fe2000001141fULL, 0x0000005500887306ULL, 0x0007e20000200c00ULL,
0x00000100141c7824ULL, 0x004fe200078e00ffULL, 0x000088801e827816ULL, 0x000fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000088801f6c7816ULL, 0x000fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001141cULL,
0x00000010521c7824ULL, 0x000fe200078e0253ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000010015537824ULL, 0x040fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x0000001400647306ULL, 0x0005e20000200c00ULL,
0x000001001f557824ULL, 0x048fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005300687306ULL, 0x0007e20000200c00ULL,
0x0000010016147824ULL, 0x044fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0001000016167824ULL, 0x000fe400078e00ffULL, 0x00000100107b7824ULL, 0x042fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x00000100117a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000010017537824ULL, 0x048fe200078e00ffULL,
0x0000001500637306ULL, 0x000fe20000200c00ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011410ULL, 0x0001000010777824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011411ULL, 0x0001000011787824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0000010012717824ULL, 0x040fe200078e00ffULL,
0x0000001400617306ULL, 0x000fe20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fe20000011412ULL,
0x0001000012897824ULL, 0x000fe200078e00ffULL, 0x00008880107c7816ULL, 0x000fe200000000ffULL,
0x0000010013747824ULL, 0x000fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fc4000001147bULL,
0x0000888011797816ULL, 0x000fe200000000ffULL, 0x0000001600607306ULL, 0x000fe20000200c00ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000888012727816ULL, 0x000fe200000000ffULL,
0x000000040e127824ULL, 0x000fe200078e0270ULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x00000017005d7306ULL, 0x0003e20000200c00ULL,
0x0000000212127810ULL, 0x000fe20007ffe075ULL, 0x0000000875757824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fc40000011413ULL, 0x00008880136f7816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000001e006d7306ULL, 0x000fe20000200c00ULL, 0x009000004414783bULL, 0x002e620000000200ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x0000001f007e7306ULL, 0x0005e20000200c00ULL,
0x00000018ff537819ULL, 0x000fce0000011453ULL, 0x0000008a008a7306ULL, 0x000ee20000200c00ULL,
0x000000001c1c783bULL, 0x004eae0000004200ULL, 0x0000008500857306ULL, 0x000e700000200c00ULL,
0x0000008300837306ULL, 0x000ea20000200c00ULL, 0x0000541087107816ULL, 0x008fce000000008aULL,
0x0000006900697306ULL, 0x000ee20000200c00ULL, 0x0000000314148232ULL, 0x082fe20000000000ULL,
0x0000541085117816ULL, 0x000fe20000000088ULL, 0x0000000316168232ULL, 0x000fe20000000000ULL,
0xfffffff875887812ULL, 0x000fe200078ee212ULL, 0x0000000015158232ULL, 0x080fe40000000000ULL,
0x0000000017178232ULL, 0x000fe20000000000ULL, 0x0000005600567306ULL, 0x000e620000200c00ULL,
0x00000010883f7824ULL, 0x000fca00078e023fULL, 0x000000101420723cULL, 0x000b640000001820ULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x000088801c127816ULL, 0x004fe400000000ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001141cULL, 0x0000541086107816ULL, 0x020fe40000000083ULL,
0x0000541084117816ULL, 0x008fe20000000069ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x000054106d567816ULL, 0x002fe20000000056ULL, 0x000000ffff697224ULL, 0x000fe200078e0012ULL,
0x00000018ff5b7819ULL, 0x000fe2000001141dULL, 0x000001001c127824ULL, 0x000fc400078e00ffULL,
0x000000101424723cULL, 0x000b620000001824ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000054107e577816ULL, 0x000fc60000000057ULL,
0x00000018ff1c7819ULL, 0x000fc8000001141cULL, 0x00000055007d7306ULL, 0x0002e20000200c00ULL,
0x0000541082107816ULL, 0x024fe2000000007fULL, 0x00000056142c723cULL, 0x000bec000000182cULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff557819ULL, 0x002fce000001141eULL,
0x0000007b007b7306ULL, 0x000e620000200c00ULL, 0x000054106c117816ULL, 0x008fe4000000007dULL,
0x00000018ff6c7819ULL, 0x000fe40000011412ULL, 0x000088801d7d7816ULL, 0x000fc600000000ffULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000000101428723cULL, 0x000f620000001828ULL,
0x000000ffff6d7224ULL, 0x000fe400078e007dULL, 0x000001001d7d7824ULL, 0x000fc800078e00ffULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x000054107c567816ULL, 0x022fe4000000007bULL,
0x00000018ff7d7819ULL, 0x000fca000001147dULL, 0x0000007600767306ULL, 0x000ff00000200c00ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541079577816ULL, 0x004fce000000007aULL,
0x0000007700777306ULL, 0x000e620000200c00ULL, 0x000000561430723cULL, 0x000b6e0000001830ULL,
0x0000007800787306ULL, 0x000eb00000200c00ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541077567816ULL, 0x022fc40000000076ULL, 0x000099106e767816ULL, 0x000fca00000000ffULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541078577816ULL, 0x004fe20000000073ULL,
0x000000ffff737224ULL, 0x000fca00078e0076ULL, 0x000000ff7300720cULL, 0x000fe20003f05270ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000000561434723cULL, 0x000b6e0000001834ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x000100001d567824ULL, 0x020fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000001300757306ULL, 0x0005f00000200c00ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x009000003f10783bULL, 0x004ea20000000200ULL,
0x000054106f1d7816ULL, 0x002fc40000000074ULL, 0x000088801e6f7816ULL, 0x000fc800000000ffULL,
0x0000006a006a7306ULL, 0x000ff00000200c00ULL, 0x0000008900707306ULL, 0x000e700000200c00ULL,
0x0000001c00577306ULL, 0x0007f00000200c00ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00005410721c7816ULL, 0x008fce0000000071ULL, 0x0000001c1438723cULL, 0x000b620000001838ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000000310108232ULL, 0x084fe40000000000ULL,
0x0000000312128232ULL, 0x000fe40000000000ULL, 0x0000000011118232ULL, 0x080fe20000000000ULL,
0x00005410701c7816ULL, 0x022fe2000000006bULL, 0x0000000013138232ULL, 0x000fe20000000000ULL,
0x00005410751d7816ULL, 0x000fe2000000006aULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x000000ffff6a7224ULL, 0x000fca00078e006fULL, 0x0000001c1418723cULL, 0x000b640000001818ULL,
0x0000004f004f7306ULL, 0x000eaa0000200c00ULL, 0x000001001e147824ULL, 0x060fe200078e00ffULL,
0x000088801f1c7816ULL, 0x040fe200000000ffULL, 0x000001001f1d7824ULL, 0x000fe200078e00ffULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x0000541065157816ULL, 0x002fe20000000068ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000001400167306ULL, 0x0003f00000200c00ULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x0000541066147816ULL, 0x002fce0000000067ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x00000053005f7306ULL, 0x0002620000200c00ULL,
0x0000541064147816ULL, 0x024fe4000000004fULL, 0x0000541063157816ULL, 0x008fca000000004aULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x00000018ff537819ULL, 0x002fe2000001141fULL,
0x000000141024723cULL, 0x000b620000001824ULL, 0x000100001f1f7824ULL, 0x000fca00078e00ffULL,
0x0000004200427306ULL, 0x000e620000200c00ULL, 0x0000541062147816ULL, 0x020fe40000000061ULL,
0x000054105e157816ULL, 0x000fe4000000005fULL, 0x00000018ff1f7819ULL, 0x000fc6000001141fULL,
0x0000006a00177306ULL, 0x000ee40000200c00ULL, 0x000000141028723cULL, 0x000b6c0000001828ULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x0000541060147816ULL, 0x024fe40000000043ULL,
0x000054105d157816ULL, 0x002fca0000000042ULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x0000541017167816ULL, 0x008fe20000000016ULL, 0x00000014102c723cULL, 0x000b6c000000182cULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x00005410575c7816ULL, 0x000fce000000005cULL,
0x0000005300537306ULL, 0x000ff00000200c00ULL, 0x0000006900697306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000e700000200c00ULL, 0x0000006d006d7306ULL, 0x000ff00000200c00ULL,
0x0000007d006e7306ULL, 0x000ea20000200c00ULL, 0x00005410696c7816ULL, 0x002fce000000006cULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000001c001c7306ULL, 0x000fe20000200c00ULL,
0x000054106d6d7816ULL, 0x004fce000000006eULL, 0x0000001d001d7306ULL, 0x000ea20000200c00ULL,
0x00005410565d7816ULL, 0x002fe2000000005bULL, 0x0000006c1030723cULL, 0x040b6c0000001830ULL,
0x0000001e001e7306ULL, 0x000e640000200c00ULL, 0x0000005c1034723cULL, 0x000b6c0000001834ULL,
0x0000001f00147306ULL, 0x020ee20000200c00ULL, 0x000054101c177816ULL, 0x004fc4000000001dULL,
0x000054101e1e7816ULL, 0x002fca0000000055ULL, 0x000000161038723cULL, 0x000b620000001838ULL,
0x00005410141f7816ULL, 0x008fe20000000053ULL, 0x000000080e147824ULL, 0x000fcc00078e00ffULL,
0x0000001e1018723cULL, 0x000b620000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00f6c80014147f8cULL, 0x000e62000c80043fULL, 0xfffffff8504a7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004006117811ULL, 0x020fe200078e40ffULL,
0x00f688004aff7f8cULL, 0x0005e2000c80043fULL, 0x0000000141417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0040ULL, 0x0000003e1100720cULL, 0x000fe20003f06070ULL,
0x000000ffff5d7224ULL, 0x000fe400078e0081ULL, 0x000000ffff137224ULL, 0x000fd400078e0049ULL,
0x0000773000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x000004004e127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004004e127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000103d127824ULL, 0x000fe200078e00ffULL, 0x0000000106107810ULL, 0x000fe20007ffe0ffULL,
0x0000580009097a24ULL, 0x010fc600078e02ffULL, 0x0000000f1000720cULL, 0x000fe20003f06070ULL,
0x0000004009097824ULL, 0x000fe200078e00ffULL, 0xffffffe012117812ULL, 0x000fca00078ec0ffULL,
0x0000010006117824ULL, 0x000fca00078e0211ULL, 0x0000008011117810ULL, 0x000fc80007ffe0ffULL,
0x000000200a137812ULL, 0x000fe200078ef811ULL, 0x000004b000008947ULL, 0x000fea0003800000ULL,
0x0000001012427812ULL, 0x000fe200078ec0ffULL, 0x000000100d127824ULL, 0x000fe200078e00ffULL,
0x00000003ff417819ULL, 0x000fc8000001160dULL, 0x0000000441437810ULL, 0x040fe20007ffe0ffULL,
0x00000001411c7824ULL, 0x000fe200078e0242ULL, 0x0000007012127812ULL, 0x000fc600078ec0ffULL,
0x000000011c107824ULL, 0x040fe400078e0213ULL, 0x0000000143507824ULL, 0x000fe400078e0242ULL,
0x000000011c1d7824ULL, 0x040fe200078e020dULL, 0x0000001009147210ULL, 0x000fe20007f1e0ffULL,
0x000000081c1c7824ULL, 0x000fe200078e00ffULL, 0x000000113e107217ULL, 0x000fc60007800000ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0014177a11ULL, 0x000fe200078038ffULL,
0x0000000110117824ULL, 0x000fe200078e0a11ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee21dULL,
0x0000100004107824ULL, 0x000fe200078e00ffULL, 0x00005f0014147a11ULL, 0x000fe400000f3c15ULL,
0x0000001142117217ULL, 0x000fe40007800000ULL, 0x0000100010157812ULL, 0x000fe200078ec0ffULL,
0x0000000150107824ULL, 0x000fc400078e0213ULL, 0x0000000111167824ULL, 0x000fe400078e0a42ULL,
0x000020000e157824ULL, 0x000fe200078e0215ULL, 0x00000010091e7210ULL, 0x000fe40007fde0ffULL,
0x0000001217107210ULL, 0x000fe40007fbe0ffULL, 0x000000164100720cULL, 0x000fe20003f06070ULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x0000b00015177810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200028e0614ULL, 0x00005e001e157a11ULL, 0x000fc400078c38ffULL,
0x000000164300720cULL, 0x000fe20003fa6070ULL, 0x000000101c1d7824ULL, 0x000fe200078e0217ULL,
0x0000000841437810ULL, 0x040fe40007ffe0ffULL, 0x00005f001e1e7a11ULL, 0x000fe200030f3c1fULL,
0x00000001501f7824ULL, 0x040fe200078e020dULL, 0x0000000c41417810ULL, 0x000fe20007ffe0ffULL,
0x0000000850507824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0x0000000143567824ULL, 0x100fe200078e0242ULL,
0x0000001215147210ULL, 0x000fe20007f1e0ffULL, 0x0000000141427824ULL, 0x000fe200078e0242ULL,
0xfffffff850507812ULL, 0x000fe200078ee21fULL, 0x00000001561c7824ULL, 0x000fc400078e0213ULL,
0x000000ffff157224ULL, 0x000fe200000e061eULL, 0x000000164300720cULL, 0x000fe20003f06070ULL,
0x00000008561f7824ULL, 0x000fe200078e00ffULL, 0x0000001c091c7210ULL, 0x000fe20007fde0ffULL,
0x00000010501d7824ULL, 0x002fe400078e0217ULL, 0x0000000142107824ULL, 0x000fe400078e0213ULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x00000000141d7faeULL, 0x0003e2000e901c46ULL,
0x00005e001c117a11ULL, 0x000fc400078a38ffULL, 0x0000001009097210ULL, 0x000fe40007fde0ffULL,
0x00005f001c137a11ULL, 0x000fe400028f3c13ULL, 0x000000164100720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1c7224ULL, 0x000fe200030e06ffULL, 0x0000001211107210ULL, 0x000fe20007fde0ffULL,
0x0000000156167824ULL, 0x100fe400078e020dULL, 0x00000001421d7824ULL, 0x042fe400078e020dULL,
0x000000ffff117224ULL, 0x000fe200030e0613ULL, 0x00005e0009157a11ULL, 0x000fe200078c38ffULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0xfffffff81f167812ULL, 0x000fc400078ee216ULL,
0x00005f0009137a11ULL, 0x000fe400030f3c1cULL, 0x0000001215147210ULL, 0x000fe20007fde0ffULL,
0x0000001016097824ULL, 0x000fe200078e0217ULL, 0xfffffff8421c7812ULL, 0x000fc600078ee21dULL,
0x000000ffff157224ULL, 0x000fe200030e0613ULL, 0x0000000010097faeULL, 0x0003e2000c101c46ULL,
0x000000101c177824ULL, 0x000fca00078e0217ULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x000003e000007947ULL, 0x000fea0003800000ULL, 0x0000001012127812ULL, 0x000fc800078ec0ffULL,
0x000000120d127211ULL, 0x000fc800078fe8ffULL, 0x0000000412147810ULL, 0x040fe20007ffe0ffULL,
0x0000000112117824ULL, 0x040fe200078e020dULL, 0x0000000c121e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000812167824ULL, 0x040fe400078e00ffULL, 0x0000000112107824ULL, 0x000fe400078e0213ULL,
0x0000000114157824ULL, 0x000fe200078e020dULL, 0xfffffff816417812ULL, 0x000fe200078ee211ULL,
0x00000008141c7824ULL, 0x040fe200078e00ffULL, 0x0000001009167210ULL, 0x000fe20007f1e0ffULL,
0x0000000114107824ULL, 0x000fc400078e0213ULL, 0x000000011e147824ULL, 0x000fe200078e0213ULL,
0xfffffff81c437812ULL, 0x000fe200078ee215ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00000008121c7810ULL, 0x000fe40007ffe0ffULL, 0x00005e00161f7a11ULL, 0x000fe400078038ffULL,
0x0000001009107210ULL, 0x040fe20007fde0ffULL, 0x000000011c127824ULL, 0x000fe200078e0213ULL,
0x00005f0016167a11ULL, 0x000fe200000f3c11ULL, 0x0000100004117824ULL, 0x000fe200078e00ffULL,
0x0000001409147210ULL, 0x040fe20007f1e0ffULL, 0x000000081c4f7824ULL, 0x040fe200078e00ffULL,
0x0000001209427210ULL, 0x000fe20007fbe0ffULL, 0x000000011c127824ULL, 0x100fe200078e020dULL,
0x0000100011117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005e0010157a11ULL, 0x000fe200078c38ffULL, 0x000000011e137824ULL, 0x000fe200078e020dULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee212ULL, 0x000000100d127824ULL, 0x000fe200078e00ffULL,
0x00005f00101c7a11ULL, 0x000fe200030f3c09ULL, 0x000020000e107824ULL, 0x000fc400078e0211ULL,
0x000000081e1e7824ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005e00141d7a11ULL, 0x000fe200078a38ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0042177a11ULL, 0x000fe400078038ffULL,
0xfffffff81e537812ULL, 0x000fe400078ee213ULL, 0x0000b00010507810ULL, 0x000fe40007ffe0ffULL,
0x00005f0042427a11ULL, 0x000fc400000f3c11ULL, 0x00005f00141e7a11ULL, 0x000fe200028f3c09ULL,
0x0000001041097824ULL, 0x100fe200078e0250ULL, 0x000000121f107210ULL, 0x080fe20007f1e0ffULL,
0x0000001043137824ULL, 0x100fe200078e0250ULL, 0x0000001215147210ULL, 0x080fe20007fbe0ffULL,
0x000000104f1f7824ULL, 0x000fe400078e0250ULL, 0x000000ffff117224ULL, 0x000fe200000e0616ULL,
0x0000001217167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e061cULL,
0x000000121d1c7210ULL, 0x000fe20007fbe0ffULL, 0x0000001053417824ULL, 0x000fe200078e0250ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fc400000e0642ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061eULL,
0x0000000014137faeULL, 0x0003e8000b901c46ULL, 0x00000000161f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c417faeULL, 0x0003e4000b901c46ULL, 0x000000083d147824ULL, 0x002fe200078e00ffULL,
0x0000000205097810ULL, 0x000fe20007ffe0ffULL, 0x0000000804137824ULL, 0x000fc600078e00ffULL,
0xfffffff014147812ULL, 0x000fe400078ec0ffULL, 0x0000000813137812ULL, 0x000fe400078ec0ffULL,
0x0000003c0900720cULL, 0x000fe20003f06070ULL, 0xffffffffff097424ULL, 0x000fe400078e00ffULL,
0x0000000114577824ULL, 0x000fca00078e0213ULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x0000000208108810ULL, 0x000fe20007ffe005ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x0000f6a857567810ULL, 0x000fc60007ffe0ffULL, 0x0000000610098981ULL, 0x000322000c1e1900ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000560403c2ULL, 0x000ea40000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800575c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628004d107f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f62c004d137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011417ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c004d137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008012107810ULL, 0x000fca0007ffe04cULL, 0x000000014b107824ULL, 0x000fca00078e0210ULL,
0x00f0000010137984ULL, 0x000e680000000800ULL, 0x00f2000010147984ULL, 0x0004e20000000800ULL,
0x000000401300720bULL, 0x002fe20003f1d000ULL, 0x0000c7327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff5b7224ULL, 0x000fd200078e0040ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000010c107810ULL, 0x000fe40007ffe0ffULL, 0x000000401300720bULL, 0x000fe40003f14000ULL,
0x0000003d1000720cULL, 0x000fe20003fa5270ULL, 0x0000c6e27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x000fc400000e0100ULL, 0x000000803d12d824ULL, 0x000fe200078e0212ULL,
0x000000401310d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991016117816ULL, 0x000fe200000000ffULL, 0x000000014b17d824ULL, 0x000fc600078e0212ULL,
0x000000ff1100720cULL, 0x000fe40003f05270ULL, 0x00f400101700d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004013117209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL,
0x0000004011107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000127308ULL, 0x000e640000000800ULL, 0x0000001207077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x0000c5f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x0002a400000e0000ULL,
0x0000001020207220ULL, 0x084fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x0000001024247220ULL, 0x080fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001038387220ULL, 0x080fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x0000c4e27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x00046400000e0000ULL,
0x0000001022227220ULL, 0x082fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x000000103a3a7220ULL, 0x080fe20000410000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007800815ULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x00000040135b7209ULL, 0x000fd60007810000ULL,
0x8000005b13130221ULL, 0x000fe20000010000ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x0000001300020308ULL, 0x000e640000000800ULL,
0x0000000214140220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000714077221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6ac0047137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804881ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x004fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0047137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804881ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000002ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe4000001160dULL,
0x0000541000127816ULL, 0x004fe20000000000ULL, 0x0000c0c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1312037589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x0000c0f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00005690001c7802ULL, 0x000fc40000000f00ULL,
0x0000c96000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x000056e0001c7802ULL, 0x000fc40000000f00ULL, 0x0000c91000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000015a107824ULL, 0x048fe200078e0259ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000085a117824ULL, 0x000fc400078e00ffULL,
0x000000020e5f7824ULL, 0x000fc600078e0249ULL, 0xfffffff811107812ULL, 0x000fe400078ee210ULL,
0x0000b0005f5f7811ULL, 0x000fca00078e60ffULL, 0x0000001010557824ULL, 0x100fe400078e025fULL,
0x0000001054537824ULL, 0x100fe400078e025fULL, 0x0000001051507824ULL, 0x100fe200078e025fULL,
0x00000000551c783bULL, 0x000ee20000004200ULL, 0x00000010524f7824ULL, 0x000fc600078e025fULL,
0x000000005340783bULL, 0x000fe80000004200ULL, 0x000000005010783bULL, 0x006e680000004200ULL,
0x000000004f14783bULL, 0x000ea20000004200ULL, 0x00000018ff877819ULL, 0x008fe2000001141cULL,
0x000001001c677824ULL, 0x040fe200078e00ffULL, 0x000088801c8b7816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001141dULL,
0x000001001d687824ULL, 0x040fe200078e00ffULL, 0x000088801d6b7816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000010010717824ULL, 0x042fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x00010000106c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001141eULL,
0x0000010011727824ULL, 0x040fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe2000001141fULL,
0x0000001c008c7306ULL, 0x0003e20000200c00ULL, 0x000088801e8a7816ULL, 0x000fe200000000ffULL,
0x00010000116d7824ULL, 0x000fe200078e00ffULL, 0x000088801f737816ULL, 0x000fe200000000ffULL,
0x00000100437a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0001000042767824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011410ULL,
0x0000006700907306ULL, 0x0006a20000200c00ULL, 0x000001001e1c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011411ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000888040847816ULL, 0x000fe200000000ffULL, 0x0001000043757824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000001d00897306ULL, 0x0003e20000200c00ULL,
0x000001001f677824ULL, 0x048fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888041797816ULL, 0x040fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x0000001c00857306ULL, 0x0007e20000200c00ULL,
0x00000100411d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x0000888010707816ULL, 0x000fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001e00867306ULL, 0x000fe20000200c00ULL, 0x00000100401c7824ULL, 0x008fe200078e00ffULL,
0x00008880116f7816ULL, 0x000fe400000000ffULL, 0x000054108b107816ULL, 0x004fe40000000090ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000001f00837306ULL, 0x000fe20000200c00ULL,
0x00000018ff7d7819ULL, 0x000fe20000011440ULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe40000011442ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000001c007f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff667819ULL, 0x000fc40000011443ULL, 0x00000018ff637819ULL, 0x000fe40000011412ULL,
0x00008880427c7816ULL, 0x040fe200000000ffULL, 0x0000001d00827306ULL, 0x000fe20000200c00ULL,
0x00000100421c7824ULL, 0x002fe200078e00ffULL, 0x0000888043777816ULL, 0x000fe200000000ffULL,
0x0000010013437824ULL, 0x000fe200078e00ffULL, 0x00008880126a7816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff627819ULL, 0x000fc40000011413ULL, 0x0000888013427816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000001c007b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff617819ULL, 0x000fc40000011414ULL, 0x00000018ff607819ULL, 0x000fe20000011415ULL,
0x00000068008e7306ULL, 0x0004e20000200c00ULL, 0x00980000441c783bULL, 0x002e620000000200ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x0001000012687824ULL, 0x004fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001146dULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x000054106b117816ULL, 0x008fe4000000008eULL,
0x00000018ff5e7819ULL, 0x000fe40000011416ULL, 0x00000018ff5c7819ULL, 0x000fc60000011417ULL,
0x0000008100817306ULL, 0x000ff00000200c00ULL, 0x0000007400747306ULL, 0x000ff00000200c00ULL,
0x0000008a008a7306ULL, 0x000ee20000200c00ULL, 0x000000031c1c8232ULL, 0x002fc40000000000ULL,
0x000000031e1e8232ULL, 0x000fe40000000000ULL, 0x000000001d1d8232ULL, 0x080fe40000000000ULL,
0x000000001f1f8232ULL, 0x000fe20000000000ULL, 0x0000007300737306ULL, 0x000fec0000200c00ULL,
0x000000101c20723cULL, 0x000b640000001820ULL, 0x0000006700887306ULL, 0x0002ea0000200c00ULL,
0x000054108c107816ULL, 0x020fc40000000087ULL, 0x0000541089117816ULL, 0x004fe2000000006eULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x0000010012677824ULL, 0x002fe200078e00ffULL,
0x0000888014127816ULL, 0x000fc800000000ffULL, 0x000000101c24723cULL, 0x000b620000001824ULL,
0x000000ffff6e7224ULL, 0x000fe200078e0012ULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x0000010014127824ULL, 0x040fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0001000014147824ULL, 0x000fe400078e00ffULL, 0x000054108a107816ULL, 0x028fe40000000085ULL,
0x0000541073117816ULL, 0x000fe20000000088ULL, 0x0000004000807306ULL, 0x0007e20000200c00ULL,
0x00000018ff737819ULL, 0x000fc40000011412ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000888015857816ULL, 0x040fe200000000ffULL, 0x000000101c28723cULL, 0x000f640000001828ULL,
0x00000041007e7306ULL, 0x0003e20000200c00ULL, 0x0000541086407816ULL, 0x008fe20000000081ULL,
0x0000010015817824ULL, 0x000fcc00078e00ffULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x0000541083417816ULL, 0x002fce0000000074ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x000000401c2c723cULL, 0x000b6e000000182cULL, 0x0000541084407816ULL, 0x024fe2000000007fULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000541079417816ULL, 0x000fc40000000082ULL,
0x00000018ff797819ULL, 0x000fca0000011481ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x000000401c30723cULL, 0x000b6e0000001830ULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x0000541080407816ULL, 0x028fe4000000007dULL, 0x000054107e417816ULL, 0x002fca0000000078ULL,
0x00000013006b7306ULL, 0x0003e40000200c00ULL, 0x000000401c34723cULL, 0x000b6c0000001834ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x009800003f10783bULL, 0x002e620000000200ULL,
0x0001000015417824ULL, 0x020fe200078e00ffULL, 0x0000541077157816ULL, 0x004fc4000000007aULL,
0x0000888016777816ULL, 0x000fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000007600767306ULL, 0x000eb00000200c00ULL,
0x0000007500757306ULL, 0x000ef00000200c00ULL, 0x0000001400407306ULL, 0x0003f00000200c00ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x000054107c147816ULL, 0x002fe2000000007bULL,
0x0000000310108232ULL, 0x000fc40000000000ULL, 0x0000000312128232ULL, 0x000fe40000000000ULL,
0x0000000011118232ULL, 0x080fe40000000000ULL, 0x000000141c38723cULL, 0x000b620000001838ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000000013138232ULL, 0x000fca0000000000ULL,
0x0000541076147816ULL, 0x024fe40000000069ULL, 0x0000541075157816ULL, 0x008fe20000000066ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000000ffff667224ULL, 0x000fca00078e0077ULL,
0x000000141c18723cULL, 0x000b640000001818ULL, 0x0000007200727306ULL, 0x000e6a0000200c00ULL,
0x0000010016147824ULL, 0x060fe200078e00ffULL, 0x00008880171e7816ULL, 0x040fe200000000ffULL,
0x00000100171f7824ULL, 0x000fe200078e00ffULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000054106f157816ULL, 0x002fce0000000072ULL,
0x0000006c006c7306ULL, 0x000e700000200c00ULL, 0x0000006d006d7306ULL, 0x000eb00000200c00ULL,
0x00000014001c7306ULL, 0x0007f00000200c00ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541070147816ULL, 0x008fce0000000071ULL, 0x0000006700677306ULL, 0x000ee20000200c00ULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x000054106c147816ULL, 0x022fe40000000065ULL, 0x000054106d157816ULL, 0x004fca0000000064ULL,
0x0000004300437306ULL, 0x000e640000200c00ULL, 0x000000141024723cULL, 0x000b6c0000001824ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000054106a147816ULL, 0x028fce0000000067ULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x0000541042157816ULL, 0x002fce0000000043ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x000000141028723cULL, 0x000b6e0000001828ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0001000017147824ULL, 0x020fe200078e00ffULL,
0x000054106b157816ULL, 0x004fc80000000062ULL, 0x00000018ff427819ULL, 0x000fe40000011414ULL,
0x0000007300737306ULL, 0x000ea20000200c00ULL, 0x0000541068147816ULL, 0x002fce0000000063ULL,
0x0000008500747306ULL, 0x000fe20000200c00ULL, 0x00000014102c723cULL, 0x000b6e000000182cULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x000054106e147816ULL, 0x024fce0000000073ULL,
0x0000006100617306ULL, 0x000eb00000200c00ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000541074157816ULL, 0x002fce0000000079ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x000000141030723cULL, 0x000b6e0000001830ULL, 0x00000066001d7306ULL, 0x000ee20000200c00ULL,
0x0000541040147816ULL, 0x024fce0000000061ULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x0000541041157816ULL, 0x002fce0000000060ULL, 0x0000001f001f7306ULL, 0x000e620000200c00ULL,
0x000000141034723cULL, 0x000b6e0000001834ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000054101d147816ULL, 0x028fce000000001cULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000054101e157816ULL, 0x002fce000000001fULL, 0x0000001600177306ULL, 0x000e620000200c00ULL,
0x000000141038723cULL, 0x000b6e0000001838ULL, 0x0000004200437306ULL, 0x000ea20000200c00ULL,
0x0000541017147816ULL, 0x022fe4000000005eULL, 0x0000541043157816ULL, 0x004fce000000005cULL,
0x000000141018723cULL, 0x000b6e0000001818ULL, 0x0000f6c80e107811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008006137811ULL, 0x000fe200078e40ffULL,
0x00f690004aff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff157224ULL, 0x002fe200078e0011ULL,
0x0000000205417810ULL, 0x000fc40007ffe0ffULL, 0x0000003e1300720cULL, 0x000fe40003f06070ULL,
0x0000000104137812ULL, 0x000fd600078ec0ffULL, 0x00004ec000000947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x004fc40000015200ULL, 0x000004004e107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x0000001012177210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e13ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000001710107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004e107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000103d127824ULL, 0x000fe200078e00ffULL,
0x0000000106107810ULL, 0x000fe20007ffe0ffULL, 0x0000580009097a24ULL, 0x010fc600078e02ffULL,
0x0000000f1000720cULL, 0x000fe20003f06070ULL, 0x0000004009097824ULL, 0x000fe200078e00ffULL,
0xffffffe012117812ULL, 0x000fca00078ec0ffULL, 0x0000010006117824ULL, 0x000fca00078e0211ULL,
0x000000c011117810ULL, 0x000fc80007ffe0ffULL, 0x000000200a147812ULL, 0x000fe200078ef811ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000010121f7812ULL, 0x000fe200078ec0ffULL,
0x000000100d1c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe4000001160dULL,
0x000000113e107217ULL, 0x000fe40007800000ULL, 0x0000000416407810ULL, 0x040fe20007ffe0ffULL,
0x0000000116177824ULL, 0x000fe200078e021fULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0x0000000c165c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000117127824ULL, 0x000fc400078e0214ULL, 0x0000000140417824ULL, 0x000fe200078e021fULL,
0x000000101f107217ULL, 0x000fe40007800000ULL, 0x0000001209127210ULL, 0x000fc60007f1e0ffULL,
0x0000000110157824ULL, 0x000fe400078e0a1fULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e0012117a11ULL, 0x000fe200078038ffULL, 0x0000000141107824ULL, 0x000fc600078e0214ULL,
0x00005f0012137a11ULL, 0x000fe200000f3c13ULL, 0x0000000117127824ULL, 0x000fe200078e020dULL,
0x00000010091d7210ULL, 0x000fe20007fde0ffULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0x0000001c11107210ULL, 0x000fe40007fbe0ffULL, 0x000000151600720cULL, 0x080fe40003f06070ULL,
0xfffffff8171e7812ULL, 0x000fe200078ee212ULL, 0x000000ffff117224ULL, 0x000fe200028e0613ULL,
0x000000154000720cULL, 0x000fe20003fa6070ULL, 0x000000ffff127224ULL, 0x000fe200030e06ffULL,
0x0000000816407810ULL, 0x000fe20007ffe0ffULL, 0x000000101e177824ULL, 0x000fe200078e025fULL,
0x00005e001d137a11ULL, 0x000fe200078c38ffULL, 0x00000001411e7824ULL, 0x000fc400078e020dULL,
0x0000000140427824ULL, 0x100fe200078e021fULL, 0x00005f001d1d7a11ULL, 0x000fe200030f3c12ULL,
0x0000000841417824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e2000c101c46ULL, 0x0000000142167824ULL, 0x000fe200078e0214ULL,
0x0000001c13127210ULL, 0x000fe20007f1e0ffULL, 0x000000015c1f7824ULL, 0x000fe200078e021fULL,
0xfffffff8411e7812ULL, 0x000fe400078ee21eULL, 0x0000001609167210ULL, 0x000fe20007fde0ffULL,
0x000000011f147824ULL, 0x000fc400078e0214ULL, 0x000000ffff137224ULL, 0x000fe200000e061dULL,
0x000000154000720cULL, 0x000fe20003f06070ULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x0000001409147210ULL, 0x000fe20007fde0ffULL, 0x000000101e177824ULL, 0x002fe400078e025fULL,
0x000000081f1e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x0000000012177faeULL, 0x0003e2000e901c46ULL, 0x00005e0016117a11ULL, 0x000fc800078a38ffULL,
0x00005f0016167a11ULL, 0x000fe400028f3c1dULL, 0x0000001c11107210ULL, 0x000fe40007fde0ffULL,
0x000000155c00720cULL, 0x000fe20003fa6070ULL, 0x0000000142157824ULL, 0x140fe400078e020dULL,
0x0000000842427824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200030e0616ULL,
0x00005e0014137a11ULL, 0x002fe200078c38ffULL, 0x000000011f177824ULL, 0x000fe200078e020dULL,
0xfffffff842167812ULL, 0x000fc400078ee215ULL, 0x00005f0014147a11ULL, 0x000fe400030f3c09ULL,
0x0000001c13127210ULL, 0x000fe20007fde0ffULL, 0x0000001016097824ULL, 0x000fe200078e025fULL,
0xfffffff81e1e7812ULL, 0x000fc600078ee217ULL, 0x000000ffff137224ULL, 0x000fe200030e0614ULL,
0x0000000010097faeULL, 0x0003e2000c101c46ULL, 0x000000101e5f7824ULL, 0x000fca00078e025fULL,
0x00000000125f7faeULL, 0x0003e2000e901c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x0000001012127812ULL, 0x000fe200078ec0ffULL, 0x000000100d1c7824ULL, 0x000fc600078e00ffULL,
0x000000120d127211ULL, 0x000fe400078fe8ffULL, 0x000000701c1c7812ULL, 0x000fe400078ec0ffULL,
0x0000000412137810ULL, 0x040fe20007ffe0ffULL, 0x0000000112107824ULL, 0x040fe400078e0214ULL,
0x0000000112117824ULL, 0x140fe400078e020dULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0x0000001009427210ULL, 0x000fe20007f1e0ffULL, 0x0000000113157824ULL, 0x000fc400078e020dULL,
0x00000008135c7824ULL, 0x040fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee211ULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e00421d7a11ULL, 0x000fe200078038ffULL,
0x0000000113107824ULL, 0x100fe200078e0214ULL, 0xfffffff85c5c7812ULL, 0x000fe400078ee215ULL,
0x0000000812157810ULL, 0x040fe40007ffe0ffULL, 0x0000000c12137810ULL, 0x000fe40007ffe0ffULL,
0x00005f0042427a11ULL, 0x000fe200000f3c11ULL, 0x0000000115127824ULL, 0x100fe200078e0214ULL,
0x0000001009107210ULL, 0x000fe20007f1e0ffULL, 0x0000000113147824ULL, 0x000fc400078e0214ULL,
0x0000000115117824ULL, 0x000fe200078e020dULL, 0x0000001209127210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff417224ULL, 0x000fe200000e06ffULL, 0x00005e0010177a11ULL, 0x040fe200078038ffULL,
0x00000008155e7824ULL, 0x000fe200078e00ffULL, 0x0000001409147210ULL, 0x000fe20007fde0ffULL,
0x00000008131f7824ULL, 0x040fe200078e00ffULL, 0x00005f0010417a11ULL, 0x000fe200000f3c41ULL,
0x0000000113107824ULL, 0x000fe200078e020dULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee211ULL,
0x000000ffff157224ULL, 0x000fe200028e06ffULL, 0x00005e0014137a11ULL, 0x000fe200078a38ffULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005e0012117a11ULL, 0x000fc400078038ffULL,
0xfffffff81f607812ULL, 0x000fe200078ee210ULL, 0x000000105e1f7824ULL, 0x000fe200078e025fULL,
0x00005f00141e7a11ULL, 0x000fe200028f3c09ULL, 0x0000001016097824ULL, 0x000fe200078e025fULL,
0x00005f0012407a11ULL, 0x000fe400000f3c15ULL, 0x0000001c1d167210ULL, 0x080fe20007f1e0ffULL,
0x000000105c1d7824ULL, 0x100fe200078e025fULL, 0x0000001c17147210ULL, 0x080fe20007fbe0ffULL,
0x00000010605f7824ULL, 0x000fe400078e025fULL, 0x000000ffff177224ULL, 0x000fe200000e0642ULL,
0x0000001c11107210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0641ULL,
0x0000001c13127210ULL, 0x000fc40007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016097faeULL, 0x0003e2000b901c46ULL, 0x000000ffff117224ULL, 0x000fe400000e0640ULL,
0x000000ffff137224ULL, 0x000fe200028e061eULL, 0x00000000141d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x00000000125f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000305117810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x0000003c1100720cULL, 0x000fda0003fa6070ULL, 0x0000004000005947ULL, 0x000fea0003800000ULL,
0x0000000108107824ULL, 0x000fe400078e0211ULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610097981ULL, 0x000324000c1e1900ULL,
0x0000009000007945ULL, 0x000fe40003800000ULL, 0x00000000580403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80047807f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648004d107f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f64c004d137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001214177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e15ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c004d137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001001c107810ULL, 0x000fca0007ffe04cULL, 0x000000014b107824ULL, 0x000fca00078e0210ULL,
0x00f0000010127984ULL, 0x000e680000000800ULL, 0x00f2000010137984ULL, 0x0004e20000000800ULL,
0x0000005b1200720bULL, 0x002fe20003f1d000ULL, 0x0000a1727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff607424ULL, 0x000fe400078e00ffULL,
0x000000ffff587224ULL, 0x000fd200078e005bULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000020c107810ULL, 0x000fe40007ffe0ffULL, 0x0000005b1200720bULL, 0x000fe40003f14000ULL,
0x0000003d1000720cULL, 0x000fe20003fa5270ULL, 0x0000a1227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400000e0100ULL, 0x000000803d1cd824ULL, 0x000fe200078e021cULL,
0x000000125b10d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991015117816ULL, 0x000fe200000000ffULL, 0x000000014b17d824ULL, 0x000fc600078e021cULL,
0x000000ff1100720cULL, 0x000fe40003f05270ULL, 0x00f400101700d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000125b107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x800000105b107221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000167308ULL, 0x000e640000000800ULL, 0x0000001607077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x0000a0427f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x0002a400000e0000ULL,
0x0000001020207220ULL, 0x084fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x0000001024247220ULL, 0x080fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001038387220ULL, 0x080fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x00009f327f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x00046400000e0000ULL,
0x0000001022227220ULL, 0x082fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x000000103a3a7220ULL, 0x080fe20000410000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe20007800814ULL,
0x00000001ff607424ULL, 0x000fe200078e00ffULL, 0x000000125b587209ULL, 0x000fd60007810000ULL,
0x8000005812120221ULL, 0x000fe20000010000ULL, 0x00007610ff600816ULL, 0x000fc60000000060ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x0000001200020308ULL, 0x000e640000000800ULL,
0x0000000213130220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000713077221ULL, 0x008fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x00f6ac0057107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000001012157210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e13ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000001510107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0057107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991060107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000002ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe4000001160dULL,
0x0000541000127816ULL, 0x000fe20000000000ULL, 0x00009b127f007947ULL, 0x000fea000b800000ULL,
0x00001f1312037589ULL, 0x0002e400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x00009b427f007947ULL, 0x000fea000b800000ULL, 0x00001f1012007589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00007e30001c7802ULL, 0x000fc40000000f00ULL,
0x0000a1c000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00007e80001c7802ULL, 0x000fc40000000f00ULL, 0x0000a17000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000100004107824ULL, 0x002fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000015a597824ULL, 0x000fc400078e0259ULL,
0x000000085a1c7824ULL, 0x000fe200078e00ffULL, 0x0000100010117812ULL, 0x000fc800078ec0ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee259ULL, 0x000020000e117824ULL, 0x000fca00078e0211ULL,
0x0000b00011597810ULL, 0x000fca0007ffe0ffULL, 0x000000101c1c7824ULL, 0x100fe400078e0259ULL,
0x0000001054407824ULL, 0x100fe400078e0259ULL, 0x0000001051107824ULL, 0x100fe400078e0259ULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0x0000001052147824ULL, 0x000fc600078e0259ULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x000000001010783bULL, 0x000ee80000004200ULL,
0x000000001414783bULL, 0x004ea20000004200ULL, 0x00000018ff847819ULL, 0x002fe2000001141cULL,
0x000001001c617824ULL, 0x040fe200078e00ffULL, 0x000088801c877816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001141dULL,
0x000001001d637824ULL, 0x040fe200078e00ffULL, 0x000088801d647816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0001000010657824ULL, 0x008fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x00000100116b7824ULL, 0x040fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001141eULL,
0x0001000011667824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001141fULL,
0x000088801e837816ULL, 0x000fe200000000ffULL, 0x0000001c00857306ULL, 0x0003e20000200c00ULL,
0x000088801f6c7816ULL, 0x000fe400000000ffULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x00000018ff5e7819ULL, 0x000fe40000011410ULL, 0x0000888010697816ULL, 0x000fe200000000ffULL,
0x0000001d00867306ULL, 0x0007e20000200c00ULL, 0x000001001e1c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011411ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000888011687816ULL, 0x000fe200000000ffULL, 0x0000010012117824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000006100887306ULL, 0x0002a20000200c00ULL,
0x00000100411d7824ULL, 0x008fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00827306ULL, 0x0007e20000200c00ULL, 0x000001001f617824ULL, 0x042fe200078e00ffULL,
0x00008880407b7816ULL, 0x000fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000888041727816ULL, 0x000fc400000000ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000001d00797306ULL, 0x0003e20000200c00ULL, 0x00000100401c7824ULL, 0x008fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff627819ULL, 0x000fe40000011442ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001e007d7306ULL, 0x000fe20000200c00ULL,
0x00000100431d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fc40000011443ULL,
0x0000888042757816ULL, 0x000fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c007a7306ULL, 0x0003e20000200c00ULL, 0x0000888043707816ULL, 0x040fe200000000ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011440ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011441ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000001f007e7306ULL, 0x000fe20000200c00ULL, 0x00000100421c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fc40000011441ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001d00737306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff5c7819ULL, 0x000fe40000011412ULL, 0x00000018ff5b7819ULL, 0x000fe40000011413ULL,
0x00000018ff5a7819ULL, 0x004fe20000011414ULL, 0x0000001c00747306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fc40000011415ULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x00000100101c7824ULL, 0x002fe200078e00ffULL,
0x0000991060107816ULL, 0x000fe400000000ffULL, 0x00000018ff527819ULL, 0x000fe40000011416ULL,
0x00000018ff6a7819ULL, 0x000fc4000001141cULL, 0x00a00000441c783bULL, 0x000e620000000200ULL,
0x0000006300897306ULL, 0x0004e20000200c00ULL, 0x000000ff1000720cULL, 0x000fe40003f05270ULL,
0x0000541087107816ULL, 0x000fe40000000088ULL, 0x00000018ff517819ULL, 0x000fc60000011417ULL,
0x0000008400847306ULL, 0x000e620000200c00ULL, 0x0000888012637816ULL, 0x004fce00000000ffULL,
0x0000006700677306ULL, 0x000eb00000200c00ULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000031c1c8232ULL, 0x002fce0000000000ULL,
0x0000001100607306ULL, 0x0007e20000200c00ULL, 0x000000031e1e8232ULL, 0x000fe40000000000ULL,
0x000000001d1d8232ULL, 0x080fe40000000000ULL, 0x000000001f1f8232ULL, 0x000fc60000000000ULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x0000541064117816ULL, 0x008fce0000000089ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000000101c20723cULL, 0x000b6e0000001820ULL,
0x00000061007f7306ULL, 0x0006620000200c00ULL, 0x0000541085107816ULL, 0x020fe40000000084ULL,
0x0000541086117816ULL, 0x004fca0000000067ULL, 0x0000007b007b7306ULL, 0x000ea20000200c00ULL,
0x0001000012617824ULL, 0x008fe200078e00ffULL, 0x0000888014127816ULL, 0x040fe200000000ffULL,
0x000000101c24723cULL, 0x000b660000001824ULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x000000ffff677224ULL, 0x000fe200078e0012ULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x0000010014127824ULL, 0x040fe200078e00ffULL, 0x0000541083107816ULL, 0x022fe20000000082ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000054106c117816ULL, 0x000fc4000000007fULL,
0x00000018ff6c7819ULL, 0x000fe40000011412ULL, 0x00000042006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x000000101c28723cULL, 0x000f620000001828ULL,
0x00008880157f7816ULL, 0x000fc800000000ffULL, 0x00000043006e7306ULL, 0x0005e20000200c00ULL,
0x0000888013427816ULL, 0x002fce00000000ffULL, 0x0000004000777306ULL, 0x0003e20000200c00ULL,
0x0000010013437824ULL, 0x044fe400078e00ffULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000004100787306ULL, 0x0005e20000200c00ULL,
0x000054107d407816ULL, 0x002fe2000000007cULL, 0x00000100157c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fca0000011413ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x000054107e417816ULL, 0x004fce000000006dULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x000000401c2c723cULL, 0x000b6e000000182cULL, 0x000054107b407816ULL, 0x020fe2000000007aULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000541072417816ULL, 0x008fc40000000079ULL,
0x00000018ff727819ULL, 0x000fca000001147cULL, 0x0000007000707306ULL, 0x000ee20000200c00ULL,
0x000000401c30723cULL, 0x000b6e0000001830ULL, 0x0000001300647306ULL, 0x0007e20000200c00ULL,
0x0000541077407816ULL, 0x022fe40000000076ULL, 0x0000541078417816ULL, 0x004fca0000000071ULL,
0x0000006200627306ULL, 0x000e620000200c00ULL, 0x00a000003f10783bULL, 0x008ea20000000200ULL,
0x000000401c34723cULL, 0x000b6c0000001834ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x0001000015407824ULL, 0x020fe200078e00ffULL, 0x0000541070157816ULL, 0x000fc40000000073ULL,
0x0000888016707816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000001400417306ULL, 0x0003f00000200c00ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541075147816ULL, 0x002fce0000000074ULL, 0x000000141c38723cULL, 0x000b620000001838ULL,
0x0000006a006a7306ULL, 0x000fec0000200c00ULL, 0x000054106f147816ULL, 0x020fe40000000062ULL,
0x000054106e157816ULL, 0x008fe2000000005fULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000000310108232ULL, 0x084fe20000000000ULL, 0x000000ffff5f7224ULL, 0x000fe200078e0070ULL,
0x0000000312128232ULL, 0x000fc40000000000ULL, 0x0000000011118232ULL, 0x080fe20000000000ULL,
0x000000141c18723cULL, 0x000b620000001818ULL, 0x0000000013138232ULL, 0x000fe20000000000ULL,
0x0000006b006b7306ULL, 0x000e6a0000200c00ULL, 0x0000010016147824ULL, 0x060fe200078e00ffULL,
0x00008880171e7816ULL, 0x040fe200000000ffULL, 0x00000100171f7824ULL, 0x040fe200078e00ffULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fc4000001141fULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000541068157816ULL, 0x002fe4000000006bULL,
0x00000018ff177819ULL, 0x000fca0000011417ULL, 0x0000006500657306ULL, 0x000e700000200c00ULL,
0x0000006600667306ULL, 0x000eb00000200c00ULL, 0x00000014001c7306ULL, 0x0007f00000200c00ULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x0000541069147816ULL, 0x008fce000000006aULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000000141020723cULL, 0x000b6e0000001820ULL,
0x0000004300437306ULL, 0x000ee20000200c00ULL, 0x0000541065147816ULL, 0x022fe4000000005eULL,
0x0000541066157816ULL, 0x004fca000000005dULL, 0x0000005b005b7306ULL, 0x000e640000200c00ULL,
0x000000141024723cULL, 0x000b6c0000001824ULL, 0x0000005f001d7306ULL, 0x000ea20000200c00ULL,
0x0000541063147816ULL, 0x020fe40000000060ULL, 0x0000541042157816ULL, 0x008fca0000000043ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00005410645d7816ULL, 0x002fe2000000005bULL,
0x000000141028723cULL, 0x000b6c0000001828ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000054101d1c7816ULL, 0x004fce000000001cULL, 0x0000005400547306ULL, 0x000ff00000200c00ULL,
0x0000006100617306ULL, 0x000ea20000200c00ULL, 0x00005410415a7816ULL, 0x002fce000000005aULL,
0x0000006700677306ULL, 0x000ff00000200c00ULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x00005410615c7816ULL, 0x004fce000000005cULL, 0x0000007f006d7306ULL, 0x000fe20000200c00ULL,
0x0000005c102c723cULL, 0x000f6e000000182cULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x00005410676c7816ULL, 0x002fce000000006cULL, 0x0000004000717306ULL, 0x000e700000200c00ULL,
0x0000001e001e7306ULL, 0x000fe20000200c00ULL, 0x000054106d6d7816ULL, 0x004fce0000000072ULL,
0x0000001f001f7306ULL, 0x000ea20000200c00ULL, 0x00005410715b7816ULL, 0x002fe20000000054ULL,
0x0000006c1030723cULL, 0x040f6c0000001830ULL, 0x0000005200527306ULL, 0x000fe40000200c00ULL,
0x0000005a1034723cULL, 0x000f6c0000001834ULL, 0x0000001600157306ULL, 0x020e620000200c00ULL,
0x000054101e1d7816ULL, 0x004fce000000001fULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000001c1038723cULL, 0x000f6e0000001838ULL, 0x0000001700407306ULL, 0x000ea20000200c00ULL,
0x0000541015147816ULL, 0x002fe40000000052ULL, 0x0000541040157816ULL, 0x004fce0000000051ULL,
0x000000141018723cULL, 0x000b6e0000001818ULL, 0x0000f6c80e147811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c006117811ULL, 0x000fe200078e40ffULL,
0x00f698004aff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff137224ULL, 0x000fe200078e0049ULL,
0x0000000305417810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0058ULL,
0x0000003e1100720cULL, 0x000fe20003f06070ULL, 0x000000ffff5d7224ULL, 0x000fd800078e0081ULL,
0x000026d000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x000004004e127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004004e127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000206127810ULL, 0x040fe20007ffe0ffULL, 0x0000010006107824ULL, 0x000fe400078e020bULL,
0x0000580009097a24ULL, 0x010fe200078e02ffULL, 0x0000000f1200720cULL, 0x000fe40003f06070ULL,
0x0000010010117810ULL, 0x000fe20007ffe0ffULL, 0x0000004009097824ULL, 0x000fc600078e00ffULL,
0x000000200a137812ULL, 0x000fce00078ef811ULL, 0x0000048000008947ULL, 0x000fea0003800000ULL,
0x000000103d107824ULL, 0x000fe200078e00ffULL, 0x00000003ff1c7819ULL, 0x000fe2000001160dULL,
0x000000100d147824ULL, 0x000fc600078e00ffULL, 0x00000010101f7812ULL, 0x000fe400078ec0ffULL,
0x000000113e107217ULL, 0x000fe40007800000ULL, 0x000000041c407810ULL, 0x040fe20007ffe0ffULL,
0x000000011c1e7824ULL, 0x040fe200078e021fULL, 0x0000000c1c417810ULL, 0x000fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe400078e0a11ULL, 0x000000011e127824ULL, 0x000fe400078e0213ULL,
0x0000000140427824ULL, 0x000fe200078e021fULL, 0x000000101f107217ULL, 0x000fe20007800000ULL,
0x000000081e177824ULL, 0x000fe200078e00ffULL, 0x0000001209127210ULL, 0x000fe20007f1e0ffULL,
0x0000000842437824ULL, 0x000fc400078e00ffULL, 0x0000000110167824ULL, 0x000fe400078e0a1fULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0012117a11ULL, 0x000fe200078038ffULL,
0x0000000142107824ULL, 0x000fc600078e0213ULL, 0x00005f0012157a11ULL, 0x000fe400000f3c15ULL,
0x0000007014127812ULL, 0x000fe200078ec0ffULL, 0x000000011e147824ULL, 0x000fe200078e020dULL,
0x00000010091d7210ULL, 0x000fe40007fde0ffULL, 0x0000001211107210ULL, 0x000fe40007fbe0ffULL,
0x000000161c00720cULL, 0x080fe40003f06070ULL, 0xfffffff8171e7812ULL, 0x000fe200078ee214ULL,
0x000000ffff117224ULL, 0x000fe200028e0615ULL, 0x000000164000720cULL, 0x000fe20003fa6070ULL,
0x000000ffff147224ULL, 0x000fe200030e06ffULL, 0x000000081c407810ULL, 0x000fe20007ffe0ffULL,
0x000000101e177824ULL, 0x000fe200078e0259ULL, 0x00005e001d157a11ULL, 0x000fe200078c38ffULL,
0x00000001421e7824ULL, 0x000fc400078e020dULL, 0x00000001404e7824ULL, 0x000fe200078e021fULL,
0x00005f001d1d7a11ULL, 0x000fe200030f3c14ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e2000c101c46ULL, 0x0000001215147210ULL, 0x000fe20007f1e0ffULL,
0x000000014e1c7824ULL, 0x040fe200078e0213ULL, 0xfffffff8431e7812ULL, 0x000fe200078ee21eULL,
0x0000000141427824ULL, 0x000fe400078e021fULL, 0x000000ffff157224ULL, 0x000fe200000e061dULL,
0x0000001c091c7210ULL, 0x000fe20007fde0ffULL, 0x000000084e1d7824ULL, 0x000fe200078e00ffULL,
0x000000164000720cULL, 0x000fe20003f06070ULL, 0x000000101e177824ULL, 0x002fc400078e0259ULL,
0x0000000142107824ULL, 0x000fe400078e0213ULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0000000014177faeULL, 0x0003e2000e901c46ULL, 0x00005e001c117a11ULL, 0x040fe400078a38ffULL,
0x0000001009097210ULL, 0x000fe40007fde0ffULL, 0x00005f001c137a11ULL, 0x000fe400028f3c13ULL,
0x000000164100720cULL, 0x000fe20003fa6070ULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0000001211107210ULL, 0x000fe20007fde0ffULL, 0x000000014e167824ULL, 0x000fc400078e020dULL,
0x0000000142177824ULL, 0x042fe400078e020dULL, 0x000000ffff117224ULL, 0x000fe200030e0613ULL,
0x00005e0009157a11ULL, 0x000fe200078c38ffULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0xfffffff81d167812ULL, 0x000fe400078ee216ULL, 0x00005f0009137a11ULL, 0x000fe400030f3c1cULL,
0x0000001215147210ULL, 0x000fe20007fde0ffULL, 0x0000001016097824ULL, 0x000fe200078e0259ULL,
0xfffffff8421c7812ULL, 0x000fc600078ee217ULL, 0x000000ffff157224ULL, 0x000fe200030e0613ULL,
0x0000000010097faeULL, 0x0003e2000c101c46ULL, 0x000000101c597824ULL, 0x000fca00078e0259ULL,
0x0000000014597faeULL, 0x0003e2000e901c46ULL, 0x000003b000007947ULL, 0x000fea0003800000ULL,
0x000000103d107824ULL, 0x000fca00078e00ffULL, 0x0000001010107812ULL, 0x000fc800078ec0ffULL,
0x000000100d127211ULL, 0x000fc800078fe8ffULL, 0x00000004121c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000112107824ULL, 0x040fe200078e0213ULL, 0x00000008121e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000112117824ULL, 0x040fe200078e020dULL, 0x0000000c12527810ULL, 0x040fe20007ffe0ffULL,
0x0000000812147824ULL, 0x000fe200078e00ffULL, 0x0000001009167210ULL, 0x000fe20007f1e0ffULL,
0x000000011c107824ULL, 0x040fe400078e0213ULL, 0x000000011c157824ULL, 0x000fe200078e020dULL,
0xfffffff814147812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e00161f7a11ULL, 0x000fe200078038ffULL, 0x000000081c427824ULL, 0x000fc400078e00ffULL,
0x000000011e127824ULL, 0x000fe200078e0213ULL, 0x00005f0016167a11ULL, 0x000fe200000f3c11ULL,
0x000000081e4e7824ULL, 0x000fe200078e00ffULL, 0x00000010091c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000152107824ULL, 0x000fe200078e0213ULL, 0xfffffff842427812ULL, 0x000fe200078ee215ULL,
0x000000011e137824ULL, 0x000fe200078e020dULL, 0x0000001209407210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e001c157a11ULL, 0x000fe200078038ffULL,
0x000000100d127824ULL, 0x000fe200078e00ffULL, 0x0000001009107210ULL, 0x000fc40007fde0ffULL,
0x00005f001c1c7a11ULL, 0x000fe200000f3c11ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00005e0040177a11ULL, 0x000fe200078038ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005e00101d7a11ULL, 0x000fe400078a38ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0x00005f0040407a11ULL, 0x000fe400000f3c11ULL, 0x00005f00101e7a11ULL, 0x000fe200028f3c09ULL,
0x0000001014097824ULL, 0x000fe200078e0259ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee213ULL,
0x0000000152137824ULL, 0x040fe200078e020dULL, 0x000000121f107210ULL, 0x080fe20007f1e0ffULL,
0x0000000852527824ULL, 0x000fe200078e00ffULL, 0x0000001215147210ULL, 0x000fe20007fbe0ffULL,
0x000000104e1f7824ULL, 0x000fc400078e0259ULL, 0x000000ffff117224ULL, 0x000fe200000e0616ULL,
0x0000001217167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e061cULL,
0xfffffff852527812ULL, 0x000fe200078ee213ULL, 0x0000001042137824ULL, 0x100fe200078e0259ULL,
0x000000121d1c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200000e0640ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000b901c46ULL,
0x0000001052597824ULL, 0x000fe400078e0259ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061eULL,
0x0000000014137faeULL, 0x0003e8000b901c46ULL, 0x00000000161f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c597faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000405117810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x0000003c1100720cULL, 0x000fda0003fa6070ULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x0000000108107824ULL, 0x000fe400078e0211ULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610097981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000560403c2ULL, 0x000ea40000080000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000270f070ULL, 0xffffff8000004947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800575c7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f668004d107f8cULL, 0x0022a4000c80043fULL,
0x0000000000147805ULL, 0x000fc40000015200ULL, 0x00f66c004d137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614167210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011417ULL, 0x0000001613137211ULL, 0x000fca00078110ffULL,
0x000000ffff167224ULL, 0x000fca00000e0617ULL, 0x0000000213137819ULL, 0x000fc80000001216ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c004d137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000180124c7810ULL, 0x000fca0007ffe04cULL,
0x000000014b4c7824ULL, 0x000fca00078e024cULL, 0x00f000004c137984ULL, 0x000e680000000800ULL,
0x00f200004c147984ULL, 0x0004e20000000800ULL, 0x000000581300720bULL, 0x002fe20003f1d000ULL,
0x00007b727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x004fc800000e0100ULL,
0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff167424ULL, 0x000fe400078e00ffULL, 0x000000ffff5b7224ULL, 0x000fd200078e0058ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000030c107810ULL, 0x000fe40007ffe0ffULL,
0x000000581300720bULL, 0x000fe40003f14000ULL, 0x0000003d1000720cULL, 0x000fe20003fa5270ULL,
0x00007b227f007947ULL, 0x000fd4000b800000ULL, 0x0000000000167806ULL, 0x000fc400000e0100ULL,
0x000000803d12d824ULL, 0x000fe200078e0212ULL, 0x00000058135b7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991016107816ULL, 0x000fe200000000ffULL,
0x000000014b12d824ULL, 0x000fc600078e0212ULL, 0x000000ff1000720cULL, 0x000fe40003f05270ULL,
0x00f4005b1200d388ULL, 0x0003f60000000800ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x000000585b107221ULL, 0x002fe20000010100ULL, 0x000000ff16ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000127308ULL, 0x000e640000000800ULL, 0x0000001207077220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x00007a427f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x0002a400000e0000ULL,
0x0000001020207220ULL, 0x084fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x0000001024247220ULL, 0x080fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001038387220ULL, 0x080fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x000079327f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x00046400000e0000ULL,
0x0000001022227220ULL, 0x082fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x000000103a3a7220ULL, 0x080fe20000410000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007800815ULL,
0x00000001ff167424ULL, 0x000fd800078e00ffULL, 0x000000135b130221ULL, 0x000fe20000010100ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300020308ULL, 0x000e640000000800ULL, 0x0000000214140220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000714077221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x00f6ac0047137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804881ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x004fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0047137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804881ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991016107816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000002ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x004fe20000000000ULL,
0x000075227f007947ULL, 0x000fea000b800000ULL, 0x00001f1312037589ULL, 0x0002a400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x000075527f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000a600001c7802ULL, 0x000fc40000000f00ULL, 0x000079f000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e0012ULL, 0x0000a650001c7802ULL, 0x000fc40000000f00ULL,
0x000079a000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000551c783bULL, 0x000ee80000004200ULL,
0x000000005340783bULL, 0x000ea80000004200ULL, 0x000000005010783bULL, 0x00ee680000004200ULL,
0x000000004f14783bULL, 0x0004e20000004200ULL, 0x00000018ff6c7819ULL, 0x000fe2000001141cULL,
0x000001001c4f7824ULL, 0x044fe200078e00ffULL, 0x000088801c797816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe2000001141dULL,
0x000001001d517824ULL, 0x040fe200078e00ffULL, 0x000088801d617816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fc4000001144fULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff547819ULL, 0x000fe4000001141eULL,
0x00000018ff627819ULL, 0x000fe2000001141fULL, 0x0000001c00777306ULL, 0x0005e20000200c00ULL,
0x00000018ff607819ULL, 0x000fe40000011440ULL, 0x000088801e737816ULL, 0x000fe400000000ffULL,
0x000088801f677816ULL, 0x000fc400000000ffULL, 0x00008880406f7816ULL, 0x040fe200000000ffULL,
0x0000001d00757306ULL, 0x0003e20000200c00ULL, 0x000001001f1c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011441ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000888041647816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000004f006e7306ULL, 0x0005e20000200c00ULL, 0x00000100401d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc40000011442ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00687306ULL, 0x0003e20000200c00ULL, 0x000001001e4f7824ULL, 0x044fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000888042657816ULL, 0x000fe400000000ffULL, 0x00000018ff467819ULL, 0x000fe40000011410ULL,
0x0000001d00667306ULL, 0x0005e20000200c00ULL, 0x00000100411c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fc40000011451ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000040006b7306ULL, 0x000fe20000200c00ULL, 0x00000100421d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c006d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff427819ULL, 0x000fc40000011442ULL,
0x00000018ff4d7819ULL, 0x000fe40000011411ULL, 0x00000018ff507819ULL, 0x000fe40000011443ULL,
0x00008880435a7816ULL, 0x040fe200000000ffULL, 0x0000001d005e7306ULL, 0x0005e20000200c00ULL,
0x00000100431c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011412ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011413ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000001e00717306ULL, 0x000fe20000200c00ULL,
0x00000100101d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff477819ULL, 0x008fe40000011414ULL, 0x00000018ff407819ULL, 0x000fe4000001141dULL,
0x0000001f00557306ULL, 0x000fe20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fe40000011415ULL,
0x00000018ff457819ULL, 0x000fc40000011416ULL, 0x00000018ff497819ULL, 0x000fc60000011417ULL,
0x0000001c00637306ULL, 0x0003f00000200c00ULL, 0x0000004100697306ULL, 0x0005e20000200c00ULL,
0x00a80000441c783bULL, 0x0022ee0000000200ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000888010417816ULL, 0x044fe200000000ffULL, 0x0001000010107824ULL, 0x000fc400078e00ffULL,
0x0000010012447824ULL, 0x002fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005100707306ULL, 0x000fe20000200c00ULL, 0x00000018ff567819ULL, 0x000fe40000011444ULL,
0x0000888013447816ULL, 0x000fca00000000ffULL, 0x0000004f006a7306ULL, 0x0003f00000200c00ULL,
0x00000042005f7306ULL, 0x0005e20000200c00ULL, 0x00000100114f7824ULL, 0x002fce00078e00ffULL,
0x0000001000517306ULL, 0x0003e20000200c00ULL, 0x0000888011427816ULL, 0x044fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x000000031c1c8232ULL, 0x088fe40000000000ULL,
0x000000031e1e8232ULL, 0x000fe40000000000ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000010013107824ULL, 0x042fe200078e00ffULL,
0x000000001d1d8232ULL, 0x080fe20000000000ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x000000001f1f8232ULL, 0x000fc40000000000ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x00000018ff137819ULL, 0x000fce0000011413ULL,
0x0000005400547306ULL, 0x000e700000200c00ULL, 0x0000006200627306ULL, 0x000eb00000200c00ULL,
0x0000001100527306ULL, 0x0007e20000200c00ULL, 0x0000541071547816ULL, 0x002fce0000000054ULL,
0x0000001000537306ULL, 0x0003e20000200c00ULL, 0x0000541061117816ULL, 0x008fe40000000070ULL,
0x0000541055557816ULL, 0x004fca0000000062ULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x0000541079107816ULL, 0x002fe2000000006eULL, 0x000000541c2c723cULL, 0x000fe2000000182cULL,
0x00008880146e7816ULL, 0x000fca00000000ffULL, 0x0000006700677306ULL, 0x000e640000200c00ULL,
0x000000101c20723cULL, 0x000bec0000001820ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000541077107816ULL, 0x020fe4000000006cULL, 0x0000541075117816ULL, 0x000fe20000000058ULL,
0x000000ffff587224ULL, 0x000fc800078e006eULL, 0x0000006400647306ULL, 0x000ee40000200c00ULL,
0x000000101c24723cULL, 0x000b6c0000001824ULL, 0x0000004300597306ULL, 0x0007e20000200c00ULL,
0x0000541073107816ULL, 0x024fe4000000006aULL, 0x0000541067117816ULL, 0x002fc40000000068ULL,
0x000054106f547816ULL, 0x008fe40000000066ULL, 0x0000888015687816ULL, 0x040fe200000000ffULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x00000018ff437819ULL, 0x000fe2000001144fULL,
0x000000101c28723cULL, 0x000f620000001828ULL, 0x00008880124f7816ULL, 0x040fe200000000ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000541064557816ULL, 0x000fe2000000006dULL,
0x000000ffff627224ULL, 0x000fe400078e0068ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000010015687824ULL, 0x000fc400078e00ffULL,
0x000000541c30723cULL, 0x000b680000001830ULL, 0x0000001200577306ULL, 0x0007e60000200c00ULL,
0x000054106b547816ULL, 0x022fca0000000060ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000010014127824ULL, 0x048fe200078e00ffULL, 0x0000541069557816ULL, 0x004fe2000000005cULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00008880165c7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe40000011412ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000000541c34723cULL, 0x000b6c0000001834ULL,
0x0000001300617306ULL, 0x0005e20000200c00ULL, 0x0001000015557824ULL, 0x020fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000004e004e7306ULL, 0x000ee20000200c00ULL,
0x00a800003f10783bULL, 0x0044e20000000200ULL, 0x000054105a157816ULL, 0x002fcc0000000063ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x00000018ff3f7819ULL, 0x004fce0000011468ULL,
0x0000001400547306ULL, 0x0005f00000200c00ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x0000541065147816ULL, 0x004fce000000005eULL, 0x000000141c38723cULL, 0x000b620000001838ULL,
0x0000004d004d7306ULL, 0x000eac0000200c00ULL, 0x000054105f147816ULL, 0x028fe2000000004eULL,
0x000000ffff4e7224ULL, 0x000fe200078e005cULL, 0x0000541059157816ULL, 0x002fe20000000050ULL,
0x0000000310108232ULL, 0x080fe20000000000ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x0000000312128232ULL, 0x000fc40000000000ULL, 0x0000000011118232ULL, 0x080fe40000000000ULL,
0x000000141c18723cULL, 0x000b620000001818ULL, 0x0000000013138232ULL, 0x000fe40000000000ULL,
0x0000004000407306ULL, 0x000e680000200c00ULL, 0x0000010016147824ULL, 0x020fe200078e00ffULL,
0x0000888017157816ULL, 0x040fe200000000ffULL, 0x00000100171e7824ULL, 0x000fc400078e00ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x00000015001f7306ULL, 0x0005e20000200c00ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000014001d7306ULL, 0x0007e20000200c00ULL,
0x0000541052157816ULL, 0x004fc4000000004dULL, 0x0000541041407816ULL, 0x002fca0000000040ULL,
0x0000004e001c7306ULL, 0x000e620000200c00ULL, 0x0000541051147816ULL, 0x008fce0000000046ULL,
0x000000141024723cULL, 0x000b620000001824ULL, 0x0000004800487306ULL, 0x000ea20000200c00ULL,
0x000054101c1c7816ULL, 0x002fce000000001dULL, 0x0000004c004c7306ULL, 0x000e700000200c00ULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x0000541057607816ULL, 0x004fce0000000048ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541061617816ULL, 0x002fce000000004cULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000541054547816ULL, 0x008fe20000000047ULL,
0x00000060102c723cULL, 0x000b6c000000182cULL, 0x0000004900497306ULL, 0x000ff00000200c00ULL,
0x0000004200427306ULL, 0x000ff00000200c00ULL, 0x0000004300437306ULL, 0x000e700000200c00ULL,
0x0000004f004f7306ULL, 0x000ff00000200c00ULL, 0x0000005600567306ULL, 0x000ea20000200c00ULL,
0x0000541042417816ULL, 0x002fce0000000043ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x000000401020723cULL, 0x000b6e0000001820ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000054104f527816ULL, 0x004fce0000000056ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000541044537816ULL, 0x002fce0000000053ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000000521028723cULL, 0x000b6e0000001828ULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x0000541058587816ULL, 0x004fce0000000067ULL, 0x00000055005a7306ULL, 0x000eb00000200c00ULL,
0x0000001e001e7306ULL, 0x000ee20000200c00ULL, 0x0000541062597816ULL, 0x002fce000000003fULL,
0x0000001600167306ULL, 0x000e620000200c00ULL, 0x000054105a557816ULL, 0x004fe2000000004bULL,
0x000000581030723cULL, 0x040b6c0000001830ULL, 0x0000001700147306ULL, 0x020ea20000200c00ULL,
0x000054101f1d7816ULL, 0x008fe2000000001eULL, 0x000000541034723cULL, 0x000b620000001834ULL,
0x0000541016167816ULL, 0x002fce0000000045ULL, 0x0000001c1038723cULL, 0x000b620000001838ULL,
0x0000541014177816ULL, 0x004fe40000000049ULL, 0x0000f6c80e147811ULL, 0x000fca00078e18ffULL,
0x000000161018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a0004aff7f8cULL, 0x0005e2000c80043fULL,
0x0000000405417810ULL, 0x000fe40007ffe0ffULL, 0x0000000104137812ULL, 0x020fc400078ec0ffULL,
0x0000000106067810ULL, 0x004fc80007ffe0ffULL, 0x0000000f0600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff5ce000007947ULL, 0x000fea000383ffffULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b65000047802ULL, 0x000fc40000000f00ULL,
0x000067e000007944ULL, 0x01efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x006e620000000000ULL,
0x00000002ff067819ULL, 0x000fe40000011604ULL, 0x0000000807047811ULL, 0x002fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000002000207220ULL, 0x042fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x000fe20000410000ULL, 0x0000002204227220ULL, 0x044fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003a043a7220ULL, 0x040fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000010003d067824ULL, 0x000fe200078e00ffULL, 0x000000343535723eULL, 0x000fc400000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000383938723eULL, 0x000fe400000000ffULL,
0x00000018191c723eULL, 0x000fe400000000ffULL, 0x0000002a2b2a723eULL, 0x000fc400000000ffULL,
0x0000002e2f15723eULL, 0x00afe400000000ffULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x000054102a147816ULL, 0x140fe40000000015ULL, 0x000076322a157816ULL, 0x000fe40000000015ULL,
0x00000002ff057819ULL, 0x000fe40000011600ULL, 0x0000000200027812ULL, 0x000fc400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x0000000805097824ULL, 0x050fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x0000000807107824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x000000363719723eULL, 0x000fe400000000ffULL, 0xfffffff810107812ULL, 0x000fc400078ee203ULL,
0x0000100006037812ULL, 0x000fe400078ee2ffULL, 0xfffffff807087812ULL, 0x040fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x000008000e057824ULL, 0x000fe200078e0203ULL,
0x0000000404067810ULL, 0x040fe40007ffe0ffULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x0000001010107824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000202102723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x000000242504723eULL, 0x000fe200000000ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x0000003a3b3a723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000541002127816ULL, 0x040fe20000000004ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x0000763202137816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x000000282902723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000001206007388ULL, 0x0003e20000000a00ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000303105723eULL, 0x000fc400000000ffULL, 0x0000763202077816ULL, 0x140fe40000000004ULL,
0x0000541005347816ULL, 0x140fe40000000035ULL, 0x0000763205357816ULL, 0x000fe40000000035ULL,
0x0000001a1b1d723eULL, 0x000fe400000000ffULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x000000222302723eULL, 0x000fc400000000ffULL, 0x000000262704723eULL, 0x000fe200000000ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x0000763232097816ULL, 0x000fe40000000019ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x000000340a007388ULL, 0x000fe20000000a00ULL,
0x0000541038067816ULL, 0x142fe4000000001cULL, 0x0000763238077816ULL, 0x000fe4000000001cULL,
0x000054103a1c7816ULL, 0x000fc4000000001dULL, 0x000076323a1d7816ULL, 0x000fe2000000001dULL,
0x000000060c007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x000000010b027824ULL, 0x000fc800078e0200ULL,
0x0000000610007388ULL, 0x000fe20000000a00ULL, 0x0000001002027824ULL, 0x000fc600078e0203ULL,
0x0004001408007388ULL, 0x0003e40000000a00ULL, 0x0000541032087816ULL, 0x002fca0000000019ULL,
0x000400080a007388ULL, 0x000fe80000000a00ULL, 0x0004001c0c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002147984ULL, 0x000ee80000000c00ULL, 0x0008000002107984ULL, 0x000ea80000000c00ULL,
0x000c000002187984ULL, 0x000ea20000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x008fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x0000001307077230ULL, 0x004fe40000000000ULL,
0x0000001206067230ULL, 0x000fe40000000000ULL, 0x0000001105057230ULL, 0x000fe40000000000ULL,
0x0000001004047230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001402007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000067810ULL, 0x000fe20007ffe0ffULL,
0x0000000000107919ULL, 0x000e620000002600ULL, 0x00000003ff117819ULL, 0x000fe20000011600ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff077819ULL, 0x000fe20000011606ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000013d3d7812ULL, 0x000fe200078ec0ffULL,
0x0000000111027824ULL, 0x000fe200078e0200ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000106047824ULL, 0x000fc600078e0207ULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x0000000704097812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe400078ef800ULL,
0x0ffffff809047812ULL, 0x000fc600078ef806ULL, 0x0000001002027824ULL, 0x100fe400078e0203ULL,
0x0000001004047824ULL, 0x000fe400078e0203ULL, 0x0000000810127824ULL, 0x042fe200078e00ffULL,
0x0000000002087984ULL, 0x0002e20000000c00ULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x00000000040c7984ULL, 0x0005220000000c00ULL,
0xfffffff812037812ULL, 0x000fe200078ee211ULL, 0x000000083d117824ULL, 0x000fe200078e00ffULL,
0xfffffff810077812ULL, 0x000fc400078ee207ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000407057c10ULL, 0x000fe2000ff3e0ffULL, 0x000000083d077824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x002fe200078040ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x00005a0005047a11ULL, 0x004fe400078240ffULL, 0x00005b0003037a11ULL, 0x000fc400000f4412ULL,
0xfffffff807077812ULL, 0x000fe400078ee200ULL, 0x00005b0005057a11ULL, 0x000fc600008f4410ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000003c3d00720cULL, 0x000fe20003f06070ULL,
0xffffffffff007424ULL, 0x000fd800078e00ffULL, 0x0000000204108824ULL, 0x000fc800078e00ffULL,
0x0000640010108a24ULL, 0x000fc800078e023dULL, 0x0000600010108625ULL, 0x000fe200078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff0a7624ULL, 0x000fe200078e00ffULL,
0x0000000610008981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff0b7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff087f8cULL, 0x000e68000c80043fULL, 0x000000060a0a7981ULL, 0x000722000c1e9900ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x0000004014037824ULL, 0x000fe400078e00ffULL,
0x000000403d057824ULL, 0x000fe400078e00ffULL, 0x0000004012027824ULL, 0x000fc400078e00ffULL,
0x0000000300237224ULL, 0x004fcc00078e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x00afe4000001160dULL, 0x0000003006217812ULL, 0x000fe400078ec0ffULL,
0x000000081e067810ULL, 0x000fe20007ffe0ffULL, 0x0000004012127824ULL, 0x000fe200078e021eULL,
0x000000181e207810ULL, 0x040fe40007ffe0ffULL, 0x000000281e1a7810ULL, 0x000fe40007ffe0ffULL,
0x00000018120c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000812077810ULL, 0x040fe40007ffe0ffULL,
0x0000000c230c7210ULL, 0x040fe40007f7e0ffULL, 0x00000010120b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000723077210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x0000000b230b7210ULL, 0x000fe40007f5e0ffULL, 0x00005e000c197a11ULL, 0x000fe200078638ffULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x00005e0007157a11ULL, 0x000fe200078238ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x0000001223177210ULL, 0x000fc40007f1e0ffULL,
0x00005f000c1b7a11ULL, 0x000fe400018f3c1bULL, 0x00005e000b107a11ULL, 0x000fe200078438ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x000000053e0c7217ULL, 0x000fe40007800000ULL,
0x00005f0007167a11ULL, 0x000fe400008f3c16ULL, 0x0000000d0d077211ULL, 0x000fe400078fe8ffULL,
0x00005f000b117a11ULL, 0x000fe200010f3c0eULL, 0x000000010c0b7824ULL, 0x000fe200078e0a05ULL,
0x00005e0017187a11ULL, 0x000fc400078038ffULL, 0x00000003070e7812ULL, 0x000fe200078ec0ffULL,
0x0000000406077824ULL, 0x000fe200078e00ffULL, 0x00005f0017177a11ULL, 0x000fe400000f3c14ULL,
0x000000101e0c7810ULL, 0x000fe40007ffe0ffULL, 0x000010003d147811ULL, 0x000fe400078e68ffULL,
0x0ffffffc0e0d7812ULL, 0x000fe200078ef80dULL, 0x000000040c1d7824ULL, 0x000fe200078e00ffULL,
0x0000000b1e00720cULL, 0x000fc40003f06070ULL, 0x0000000b0600720cULL, 0x080fe20003f26070ULL,
0x000000100d137824ULL, 0x000fe200078e0214ULL, 0x0000001821067210ULL, 0x000fe40007f7e0ffULL,
0x0000000b0c00720cULL, 0x000fe40003f46070ULL, 0xfffffffc070d7812ULL, 0x100fe200078ee20eULL,
0x000000ffff077224ULL, 0x000fe200018e0617ULL, 0x00000021150c7210ULL, 0x080fe40007f7e0ffULL,
0xfffffffc1d177812ULL, 0x000fe200078ee20eULL, 0x000000100d157824ULL, 0x000fe200078e0214ULL,
0x0000002110107210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e0616ULL,
0x0000002012187810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006137faeULL, 0x0003e2000c101c46ULL, 0x0000001017177824ULL, 0x000fe200078e0214ULL,
0x000000201e167810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0611ULL,
0x0000001823187210ULL, 0x000fe20007f1e0ffULL, 0x000000000c157faeULL, 0x0005e2000c901c46ULL,
0x000000301e1c7810ULL, 0x000fc40007ffe0ffULL, 0x000000381e1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000010177faeULL, 0x0007e2000d101c46ULL, 0x0000000b2000720cULL, 0x040fe20003f86070ULL,
0x000000ffff1f7224ULL, 0x000fe200000e06ffULL, 0x0000002119067210ULL, 0x002fe20007fbe0ffULL,
0x0000000420077824ULL, 0x000fe200078e00ffULL, 0x0000000b1600720cULL, 0x080fe20003f66070ULL,
0x000000041c137824ULL, 0x000fe200078e00ffULL, 0x0000000b1a00720cULL, 0x080fe20003f46070ULL,
0x000000041e157824ULL, 0x004fe200078e00ffULL, 0xfffffffc070d7812ULL, 0x000fe200078ee20eULL,
0x000000ffff077224ULL, 0x000fe200028e061bULL, 0x0000000b1c00720cULL, 0x080fe20003f26070ULL,
0x000000041a117824ULL, 0x008fe200078e00ffULL, 0x0000000b1e00720cULL, 0x000fe20003f06070ULL,
0x000000100d0d7824ULL, 0x000fe200078e0214ULL, 0x00000028120b7810ULL, 0x000fc40007ffe0ffULL,
0x00000030120c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b23107210ULL, 0x000fe20007fbe0ffULL,
0x00000000060d7faeULL, 0x0003e2000e101c46ULL, 0xfffffffc13137812ULL, 0x000fe200078ee20eULL,
0x00000004160b7824ULL, 0x000fe200078e00ffULL, 0x0000000c231b7210ULL, 0x000fe40007f9e0ffULL,
0x00005e00181d7a11ULL, 0x000fe200078c38ffULL, 0x0000001013177824ULL, 0x000fe200078e0214ULL,
0x0000003812127810ULL, 0x000fc40007ffe0ffULL, 0x00005f00181f7a11ULL, 0x000fe400030f3c1fULL,
0x0000001223187210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0d7224ULL, 0x002fe200028e06ffULL,
0x00005e00100c7a11ULL, 0x040fe400078a38ffULL, 0xfffffffc15077812ULL, 0x000fe400078ee20eULL,
0x00005f0010137a11ULL, 0x000fe200028f3c0dULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x000000211d067210ULL, 0x000fe20007fbe0ffULL, 0x0000001007197824ULL, 0x000fe200078e0214ULL,
0xfffffffc0b0b7812ULL, 0x000fc400078ee20eULL, 0xfffffffc11117812ULL, 0x000fe200078ee20eULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x00005e001b107a11ULL, 0x000fe200078838ffULL,
0x000000ffff077224ULL, 0x000fe200028e061fULL, 0x00005e0018127a11ULL, 0x000fe200078c38ffULL,
0x0000001011157824ULL, 0x100fe200078e0214ULL, 0x000000210c0c7210ULL, 0x080fe20007fbe0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e0214ULL, 0x00005f001b117a11ULL, 0x000fe400020f3c0eULL,
0x00005f00180e7a11ULL, 0x000fe200030f3c0dULL, 0x000000ffff0d7224ULL, 0x000fe200028e0613ULL,
0x0000002110107210ULL, 0x080fe20007f9e0ffULL, 0x00000000060b7faeULL, 0x0003e2000d901c46ULL,
0x0000002112127210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0611ULL,
0x000000000c157faeULL, 0x0003e2000d101c46ULL, 0x000000ffff137224ULL, 0x000fc600028e060eULL,
0x0000000010177faeULL, 0x0003e8000c901c46ULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x000000020d077211ULL, 0x04afe400078ff0ffULL,
0x000000080d1d7811ULL, 0x000fe400078ff0ffULL, 0x0000000723077210ULL, 0x000fe40007f1e0ffULL,
0x000000100d0b7811ULL, 0x000fc400078ff0ffULL, 0x0000000d0d1a7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x00005e0007247a11ULL, 0x000fe200078038ffULL,
0x00000001020c7824ULL, 0x040fe200078e020bULL, 0x000000180d117811ULL, 0x000fe200078ff0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x00005f0007267a11ULL, 0x000fe200000f3c26ULL,
0x0000000102077824ULL, 0x040fe200078e021dULL, 0x000000200d137811ULL, 0x040fe200078ff0ffULL,
0x00000001020e7824ULL, 0x040fe200078e0211ULL, 0x000000300d177811ULL, 0x000fe200078ff0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x000000280d157811ULL, 0x000fe200078ff0ffULL,
0x0000000102107824ULL, 0x000fe200078e0213ULL, 0x0000000723227210ULL, 0x000fe20007fde0ffULL,
0x000000041d077824ULL, 0x000fe200078e00ffULL, 0x000000031a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000102147824ULL, 0x040fe200078e0217ULL, 0x000000380d197811ULL, 0x000fe200078ff0ffULL,
0x0000000102127824ULL, 0x000fe200078e0215ULL, 0x0000000c23187210ULL, 0x000fe20007fbe0ffULL,
0x00000004131d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b0c7812ULL, 0x100fe200078ee21aULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x000010003d277811ULL, 0x000fe200078e68ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0x0ffffffc1a137812ULL, 0x000fe200078ef80dULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0xfffffffc07077812ULL, 0x100fe200078ee21aULL,
0x0000000102167824ULL, 0x000fe200078e0219ULL, 0x00005e0022207a11ULL, 0x000fe200078c38ffULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x00000010231c7210ULL, 0x000fe20007f3e0ffULL,
0x00000010132b7824ULL, 0x000fe200078e0227ULL, 0xfffffffc110d7812ULL, 0x000fc400078ee21aULL,
0x0000000e231e7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc17117812ULL, 0x100fe200078ee21aULL,
0x000000100d1f7824ULL, 0x000fe200078e0227ULL, 0x00005f0022227a11ULL, 0x000fe200030f3c0bULL,
0x00000010070b7824ULL, 0x100fe200078e0227ULL, 0xfffffffc15107812ULL, 0x000fe200078ee21aULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000001423147210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x0000001623167210ULL, 0x000fe20007f9e0ffULL,
0x0000001011257824ULL, 0x100fe200078e0227ULL, 0x00005e001c157a11ULL, 0x000fe200078238ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00000012231b7210ULL, 0x000fe20007f5e0ffULL,
0x0000001010237824ULL, 0x000fe200078e0227ULL, 0x00005e001e137a11ULL, 0x000fc400078038ffULL,
0x0000003006297812ULL, 0x000fe400078ec0ffULL, 0xfffffffc1d0e7812ULL, 0x100fe200078ee21aULL,
0x000000100c1d7824ULL, 0x000fe200078e0227ULL, 0xfffffffc19127812ULL, 0x000fe200078ee21aULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0x00005e0018107a11ULL, 0x000fe200078a38ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005f001c1c7a11ULL, 0x000fe200008f3c07ULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x00005f001e1e7a11ULL, 0x000fe200000f3c0dULL,
0x000000100e217824ULL, 0x100fe200078e0227ULL, 0x00005e00161a7a11ULL, 0x000fe200078638ffULL,
0x0000001012277824ULL, 0x000fe200078e0227ULL, 0x0000002429067210ULL, 0x000fc40007f1e0ffULL,
0x00005e001b177a11ULL, 0x040fe400078238ffULL, 0x00005f0018117a11ULL, 0x000fe400028f3c11ULL,
0x00005e0014187a11ULL, 0x000fe400078438ffULL, 0x00005f00160e7a11ULL, 0x000fe200018f3c07ULL,
0x000000ffff077224ULL, 0x000fe200000e0626ULL, 0x00005f001b1b7a11ULL, 0x000fe400008f3c0cULL,
0x00000020290c7210ULL, 0x000fc40007f1e0ffULL, 0x00005f0014197a11ULL, 0x000fe200010f3c19ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000062b7faeULL, 0x0003e2000b901c46ULL,
0x0000001029107210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0622ULL,
0x0000001329127210ULL, 0x040fe40007f5e0ffULL, 0x0000001529147210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000001729167210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e061eULL, 0x0000001829187210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200018e061cULL, 0x0000001a291a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200020e061bULL, 0x000000000c0b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff197224ULL, 0x000fc400028e0619ULL, 0x000000ffff1b7224ULL, 0x000fe200000e060eULL,
0x00000000101d7faeULL, 0x0003e8000b901c46ULL, 0x00000000121f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014217faeULL, 0x0003e8000b901c46ULL, 0x0000000016237faeULL, 0x0003e8000b901c46ULL,
0x0000000018257faeULL, 0x0003e8000b901c46ULL, 0x000000001a277faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x00f60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c060c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e07ULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc8000001140dULL,
0x0000000c0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x000000020b0b7819ULL, 0x000fc8000000120cULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e640000000000ULL, 0x000000203d067824ULL, 0x002fca00078e0206ULL,
0x00000003ff077819ULL, 0x000fc80000011606ULL, 0x1ffffffe07097812ULL, 0x000fe400078ec0ffULL,
0x0000000f06077812ULL, 0x000fc600078ec0ffULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x00000010070b7824ULL, 0x040fe400078e00ffULL, 0x0000001007087824ULL, 0x000fe200078e00ffULL,
0x0000000f09067812ULL, 0x040fe400078ec0ffULL, 0x0000000109097810ULL, 0x000fe40007ffe0ffULL,
0x000000f00b067812ULL, 0x000fe400078ee206ULL, 0x0000000f09097812ULL, 0x000fc600078ec0ffULL,
0x0000000006147984ULL, 0x000e62000000cc00ULL, 0x000000f008097812ULL, 0x000fca00078ee209ULL,
0x0000000009107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001806007388ULL, 0x0003e8000000cc00ULL,
0x0000001409007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0c7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0e7224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x002fc80000015200ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x3db504f30a067820ULL, 0x010fe20000410000ULL,
0x0000640004047a24ULL, 0x000fe200078e02ffULL, 0x0000f6883d087811ULL, 0x000fe200078e18ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0xffffffff0f097810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x0000f6083d0a7811ULL, 0x000fe200078e28ffULL,
0x000000ffff0b7224ULL, 0x000fc400078e003dULL, 0x000001000c0d7824ULL, 0x000fe200078e0205ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000000d3e00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e000eULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fc4000001ff00ULL, 0x000000013f117810ULL, 0x000fe20007ffe0ffULL,
0x00000d6000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fc400078e003fULL,
0x0000000c11187211ULL, 0x040fe200078ff8ffULL, 0x0000000300407224ULL, 0x010fe200078e02ffULL,
0x000000021100780cULL, 0x040fe20003f06070ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0011ULL,
0x00000001180e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000111487812ULL, 0x000fe400078ec0ffULL,
0x0000000f0e00720cULL, 0x000fe40003f26070ULL, 0x00000001100e7812ULL, 0x000fd600078e0cffULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x002fe20000011607ULL,
0x0000010018117824ULL, 0x000fe400078e0205ULL, 0x00000004484a7824ULL, 0x000fe200078e00ffULL,
0x000000081d457810ULL, 0x040fe20007ffe0ffULL, 0x0000000102127824ULL, 0x000fe200078e021dULL,
0x000000101d4f7810ULL, 0x000fe20007ffe0ffULL, 0x000000023d497824ULL, 0x000fe200078e020eULL,
0x000000113e187217ULL, 0x000fe20007800000ULL, 0x0000000102137824ULL, 0x000fe200078e0245ULL,
0x00000012401b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000102197824ULL, 0x000fe200078e024fULL,
0x000000181d517810ULL, 0x040fe20007ffe0ffULL, 0x0000000118117824ULL, 0x000fe200078e0a11ULL,
0x0000001340137210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x0000001940197210ULL, 0x000fe20007f7e0ffULL, 0x0000000102187824ULL, 0x000fe200078e0251ULL,
0x000000281d537810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x00005e0013427a11ULL, 0x000fe200078438ffULL, 0x000000ffff1a7224ULL, 0x000fe200018e06ffULL,
0x00005e0019127a11ULL, 0x000fc400078638ffULL, 0x00005e001b467a11ULL, 0x000fe400078238ffULL,
0x00005f0013437a11ULL, 0x000fe400010f3c1cULL, 0x000000201d527810ULL, 0x000fe40007ffe0ffULL,
0x00005f0019137a11ULL, 0x000fe200018f3c1aULL, 0x00000001021a7824ULL, 0x040fe200078e0253ULL,
0x000000381d557810ULL, 0x000fe20007ffe0ffULL, 0x0000000102197824ULL, 0x000fe200078e0252ULL,
0x00005f001b477a11ULL, 0x000fc400008f3c1eULL, 0x000000301d547810ULL, 0x040fe40007ffe0ffULL,
0x000000111d00720cULL, 0x000fe40003f46070ULL, 0x00000018401d7210ULL, 0x000fe20007f3e0ffULL,
0x0000000102187824ULL, 0x000fe200078e0255ULL, 0x0000001a40417210ULL, 0x000fe20007fde0ffULL,
0x00000001021b7824ULL, 0x000fe200078e0254ULL, 0x00000019401f7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078238ffULL,
0x000000ffff4e7224ULL, 0x000fe200030e06ffULL, 0x0000001840197210ULL, 0x000fc40007f7e0ffULL,
0x0000000707187211ULL, 0x000fe400078fe8ffULL, 0x00005f001d1d7a11ULL, 0x000fe400008f3c1aULL,
0x000000114500720cULL, 0x040fe20003f26070ULL, 0x0000000445457824ULL, 0x000fe200078e00ffULL,
0x0000000318507812ULL, 0x000fe200078ec0ffULL, 0x000000ffff187224ULL, 0x000fe200028e06ffULL,
0x0000001b401b7210ULL, 0x000fe40007f9e0ffULL, 0xfffffffc45407812ULL, 0x000fc400078ee250ULL,
0x0000100049497811ULL, 0x000fe200078e60ffULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x0ffffffc501a7812ULL, 0x100fe400078ef807ULL, 0xfffffffc4a457812ULL, 0x000fe200078ee207ULL,
0x00000010404d7824ULL, 0x100fe200078e0249ULL, 0x00005e001f1e7a11ULL, 0x000fe200078a38ffULL,
0x000000101a4b7824ULL, 0x000fe200078e0249ULL, 0x00005e001b1a7a11ULL, 0x000fe200078838ffULL,
0x0000001045467825ULL, 0x000fe200078e0046ULL, 0x00005f001f1f7a11ULL, 0x000fc400028f3c18ULL,
0x00005e0041407a11ULL, 0x000fe200078a38ffULL, 0x0000001045427825ULL, 0x000fe200078e0042ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000464b7faeULL, 0x0003e2000d101c46ULL,
0x00005f001b1b7a11ULL, 0x000fe400020f3c4cULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078638ffULL, 0x00000000424d7faeULL, 0x0005e2000c901c46ULL,
0x000000114f00720cULL, 0x040fe20003f26070ULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0x00005f0041417a11ULL, 0x000fe200028f3c4eULL, 0x0000001045127825ULL, 0x000fe200078e0012ULL,
0x00005f0019197a11ULL, 0x000fc400018f3c4aULL, 0x000000115100720cULL, 0x0c0fe20003f46070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x000000115200720cULL, 0x080fe20003f66070ULL,
0x00000010451c7825ULL, 0x000fe200078e001cULL, 0x000000115300720cULL, 0x0c0fe40003f86070ULL,
0x000000115400720cULL, 0x080fe20003fa6070ULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0x000000115500720cULL, 0x000fe20003fc6070ULL, 0x0000000452117824ULL, 0x000fe200078e00ffULL,
0xfffffffc4f427812ULL, 0x104fe200078ee250ULL, 0x0000000454437824ULL, 0x000fe200078e00ffULL,
0xfffffffc51467812ULL, 0x102fe200078ee250ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0xfffffffc114a7812ULL, 0x100fe200078ee250ULL, 0x0000001042117824ULL, 0x000fe200078e0249ULL,
0xfffffffc534c7812ULL, 0x000fe200078ee250ULL, 0x00000010451e7825ULL, 0x000fe200078e001eULL,
0xfffffffc434e7812ULL, 0x000fc400078ee250ULL, 0xfffffffc55507812ULL, 0x000fe200078ee250ULL,
0x0000001046437824ULL, 0x100fe200078e0249ULL, 0x0000000012117faeULL, 0x0003e2000c901c46ULL,
0x000000104a477824ULL, 0x100fe400078e0249ULL, 0x000000104c4b7824ULL, 0x000fe200078e0249ULL,
0x000000001c437faeULL, 0x0003e2000d101c46ULL, 0x0000001045407825ULL, 0x000fc600078e0040ULL,
0x000000001e477faeULL, 0x0003e2000d901c46ULL, 0x000000104e4d7824ULL, 0x000fe400078e0249ULL,
0x00000010451a7825ULL, 0x040fe200078e001aULL, 0x00000000404b7faeULL, 0x0003e6000e101c46ULL,
0x0000001050497824ULL, 0x000fe200078e0249ULL, 0x000000001a4d7faeULL, 0x0003e2000e901c46ULL,
0x0000001045187825ULL, 0x000fca00078e0018ULL, 0x0000000018497faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x00000008071f7811ULL, 0x002fe200078ff0ffULL,
0x000000023d1c7824ULL, 0x000fe200078e020eULL, 0x0000000207137211ULL, 0x040fe400078ff0ffULL,
0x0000001007417811ULL, 0x000fe200078ff0ffULL, 0x0000000102117824ULL, 0x000fe200078e021fULL,
0x0000004013137210ULL, 0x080fe20007f3e0ffULL, 0x000000041f1f7824ULL, 0x000fe200078e00ffULL,
0x0000001807457811ULL, 0x000fe400078ff0ffULL, 0x0000004011117210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x00005e0013467a11ULL, 0x000fc400078238ffULL,
0x0000002007497811ULL, 0x000fe200078ff0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e0011427a11ULL, 0x000fe400078438ffULL, 0x00000028074b7811ULL, 0x000fe200078ff0ffULL,
0x00000001021d7824ULL, 0x040fe200078e0249ULL, 0x00005f0011437a11ULL, 0x000fe200010f3c12ULL,
0x0000000102117824ULL, 0x040fe200078e0241ULL, 0x00000030074d7811ULL, 0x040fe200078ff0ffULL,
0x00000001021b7824ULL, 0x040fe200078e024bULL, 0x00000038074f7811ULL, 0x000fe200078ff0ffULL,
0x0000000441417824ULL, 0x000fe200078e00ffULL, 0x00005f0013477a11ULL, 0x000fe200008f3c18ULL,
0x0000000102137824ULL, 0x040fe200078e0245ULL, 0x0000000707187211ULL, 0x000fe200078fe8ffULL,
0x0000000102197824ULL, 0x040fe200078e024dULL, 0x0000004011117210ULL, 0x080fe20007fde0ffULL,
0x0000000102517824ULL, 0x000fe200078e024fULL, 0x0000004013127210ULL, 0x080fe20007fbe0ffULL,
0x000000044b4b7824ULL, 0x000fe200078e00ffULL, 0x00000003181a7812ULL, 0x000fe200078ec0ffULL,
0x0000000445457824ULL, 0x000fe200078e00ffULL, 0x000000401d1d7210ULL, 0x080fe20007f9e0ffULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x000000401b1b7210ULL, 0x080fe20007f3e0ffULL,
0x000000044d4d7824ULL, 0x000fe200078e00ffULL, 0x0000004019197210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x0000004051137210ULL, 0x000fe20007f7e0ffULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x00005e0011407a11ULL, 0x000fc400078c38ffULL,
0x000010001c517811ULL, 0x000fe400078e60ffULL, 0xfffffffc1f1e7812ULL, 0x100fe200078ee21aULL,
0x000000ffff1f7224ULL, 0x000fe200028e06ffULL, 0xfffffffc414a7812ULL, 0x100fe400078ee21aULL,
0xfffffffc4b507812ULL, 0x100fe400078ee21aULL, 0xfffffffc454c7812ULL, 0x100fe200078ee21aULL,
0x000000104a457824ULL, 0x100fe200078e0251ULL, 0xfffffffc494e7812ULL, 0x100fe200078ee21aULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0xfffffffc4d527812ULL, 0x000fe200078ee21aULL,
0x00000010504d7824ULL, 0x000fe200078e0251ULL, 0x0ffffffc1a1c7812ULL, 0x000fe200078ef807ULL,
0x000000104c497824ULL, 0x100fe200078e0251ULL, 0x00005f0011417a11ULL, 0x000fe200030f3c18ULL,
0x0000000448187824ULL, 0x000fe200078e00ffULL, 0xfffffffc4f1a7812ULL, 0x000fe200078ee21aULL,
0x000000101e117824ULL, 0x100fe200078e0251ULL, 0x00005e00121e7a11ULL, 0x000fe200078a38ffULL,
0x000000101c557824ULL, 0x000fe200078e0251ULL, 0xfffffffc18537812ULL, 0x000fe200078ee207ULL,
0x000000104e4b7824ULL, 0x000fe200078e0251ULL, 0x00005f00121f7a11ULL, 0x000fe200028f3c1fULL,
0x00000010524f7824ULL, 0x100fe200078e0251ULL, 0x00005e0013127a11ULL, 0x000fe200078638ffULL,
0x000000ffff507224ULL, 0x000fe200020e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078838ffULL,
0x000000101a517824ULL, 0x000fe200078e0251ULL, 0x00005f0013137a11ULL, 0x000fe200018f3c4aULL,
0x000000ffff4e7224ULL, 0x000fe200008e06ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078238ffULL,
0x000000ffff4c7224ULL, 0x000fe200010e06ffULL, 0x00005e0019187a11ULL, 0x000fe200078438ffULL,
0x0000001053467825ULL, 0x000fe200078e0046ULL, 0x00005f001d1d7a11ULL, 0x000fc400020f3c50ULL,
0x00005f001b1b7a11ULL, 0x000fe200008f3c4eULL, 0x0000001053427825ULL, 0x000fe200078e0042ULL,
0x00005f0019197a11ULL, 0x000fe200010f3c4cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046557faeULL, 0x0003e4000b901c46ULL, 0x0000001053407825ULL, 0x040fe400078e0040ULL,
0x0000000042117faeULL, 0x0003e4000b901c46ULL, 0x00000010531e7825ULL, 0x040fe400078e001eULL,
0x0000000040457faeULL, 0x0003e4000b901c46ULL, 0x00000010531c7825ULL, 0x000fc400078e001cULL,
0x000000001e497faeULL, 0x0003e4000b901c46ULL, 0x00000010531a7825ULL, 0x040fe400078e001aULL,
0x000000001c4b7faeULL, 0x0003e4000b901c46ULL, 0x0000001053187825ULL, 0x040fe400078e0018ULL,
0x000000001a4d7faeULL, 0x0003e4000b901c46ULL, 0x0000001053127825ULL, 0x000fc400078e0012ULL,
0x00000000184f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012517faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff4800720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x000000040b0b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x0000003c0b00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000204127824ULL, 0x002fe400078e020bULL, 0x00000004ff137424ULL, 0x000fc800078e00ffULL,
0x0000600012127625ULL, 0x000fca00078e0013ULL, 0x0000000612007981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002007127810ULL, 0x002fe20007ffe0ffULL, 0x000000023d407824ULL, 0x000fe200078e0210ULL,
0xfffffff807107812ULL, 0x040fe200078ec0ffULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe400078ec0ffULL, 0x0000000707187812ULL, 0x000fe400078ec0ffULL,
0x0000000710457812ULL, 0x100fe400078ef807ULL, 0x0000000712477812ULL, 0x000fc400078ef807ULL,
0x0000100040407811ULL, 0x000fe400078e60ffULL, 0x0000000818417812ULL, 0x000fe400078ef807ULL,
0x00000001ff427819ULL, 0x000fe40000011645ULL, 0x00000001ff467819ULL, 0x000fe20000011647ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000142107824ULL, 0x120fe200078e0243ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000445117824ULL, 0x000fe200078e00ffULL,
0x0000000143497810ULL, 0x000fe20007ffe0ffULL, 0x00000004447a7824ULL, 0x000fc600078e0243ULL,
0xfffffffc11117812ULL, 0x000fe200078ee210ULL, 0x0000000146107824ULL, 0x000fe200078e0243ULL,
0x0000000243437810ULL, 0x000fe20007ffe0ffULL, 0x000000027a7a7824ULL, 0x000fe400078e00ffULL,
0x0000001011187824ULL, 0x000fe200078e0240ULL, 0x000000044300780cULL, 0x000fe20003f25270ULL,
0x0000000447117824ULL, 0x000fc800078e00ffULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0xfffffffc11117812ULL, 0x000fca00078ee210ULL, 0x0000001011117824ULL, 0x000fcc00078e0240ULL,
0x000000001110783bULL, 0x000ea20000000200ULL, 0x00000018ff5f7819ULL, 0x002fe20000011418ULL,
0x00010000181c7824ULL, 0x040fe200078e00ffULL, 0x0000888018787816ULL, 0x040fe200000000ffULL,
0x0000010018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011419ULL,
0x00010000191d7824ULL, 0x040fe200078e00ffULL, 0x0000888019747816ULL, 0x040fe200000000ffULL,
0x0000010019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fc4000001141aULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x000088801a727816ULL, 0x000fe400000000ffULL,
0x00000018ff667819ULL, 0x000fe2000001141bULL, 0x0000001800767306ULL, 0x0002e20000200c00ULL,
0x000088801b647816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff557819ULL, 0x004fe20000011410ULL,
0x0000001900617306ULL, 0x0005e20000200c00ULL, 0x000100001a187824ULL, 0x002fe200078e00ffULL,
0x0000888010547816ULL, 0x000fe200000000ffULL, 0x000001001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011411ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001b197824ULL, 0x044fe200078e00ffULL,
0x0000001c007b7306ULL, 0x000fe20000200c00ULL, 0x000001001b1b7824ULL, 0x000fe200078e00ffULL,
0x00008880116c7816ULL, 0x000fc400000000ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000001a00757306ULL, 0x0003e20000200c00ULL,
0x00000018ff5e7819ULL, 0x000fe40000011412ULL, 0x00000018ff487819ULL, 0x000fe40000011413ULL,
0x0000888012687816ULL, 0x000fe400000000ffULL, 0x0000888013627816ULL, 0x000fe200000000ffULL,
0x0000001900737306ULL, 0x0005e20000200c00ULL, 0x00000004451a7824ULL, 0x002fce00078e00ffULL,
0x0000001b00717306ULL, 0x0003e20000200c00ULL, 0x0000000142197824ULL, 0x104fe400078e0249ULL,
0x0000000146497824ULL, 0x000fca00078e0249ULL, 0x0000001d00797306ULL, 0x0005e20000200c00ULL,
0xfffffffc1a1b7812ULL, 0x002fe200078ee219ULL, 0x0001000011197824ULL, 0x040fe400078e00ffULL,
0x0000010011117824ULL, 0x000fe400078e00ffULL, 0x000000101b1b7824ULL, 0x000fe200078e0240ULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000001800777306ULL, 0x0003e20000200c00ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x000000001b1c783bULL, 0x004eaa0000000200ULL,
0x00000011006a7306ULL, 0x0007e20000200c00ULL, 0x0001000010187824ULL, 0x002fc400078e00ffULL,
0x0000010010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0001000013117824ULL, 0x048fe200078e00ffULL,
0x00000018006f7306ULL, 0x000fe20000200c00ULL, 0x0000010013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x00000010006e7306ULL, 0x0003f00000200c00ULL, 0x0000001100657306ULL, 0x0007e20000200c00ULL,
0x0000000447107824ULL, 0x002fca00078e00ffULL, 0xfffffffc10497812ULL, 0x000fe200078ee249ULL,
0x0001000012107824ULL, 0x040fe200078e00ffULL, 0x00000019006d7306ULL, 0x0003e20000200c00ULL,
0x0000001041117824ULL, 0x008fe200078e00ffULL, 0x00000018ff517819ULL, 0x004fe2000001141cULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000001049187824ULL, 0x000fe200078e0240ULL, 0x000088801c4a7816ULL, 0x000fe400000000ffULL,
0x00000010006b7306ULL, 0x0005e20000200c00ULL, 0x00000018ff127819ULL, 0x000fc40000011412ULL,
0x000000001818783bULL, 0x002e620000000200ULL, 0x00000018ff507819ULL, 0x000fe4000001141dULL,
0x000088801d537816ULL, 0x000fe400000000ffULL, 0x0000001200697306ULL, 0x000fe20000200c00ULL,
0x000100001c107824ULL, 0x044fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001141eULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x000088801e567816ULL, 0x000fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fc40000011410ULL, 0x0000007a07107211ULL, 0x000fe200078fe0ffULL,
0x0000001300637306ULL, 0x0005e20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff4e7819ULL, 0x000fe2000001141fULL, 0x0000000141107824ULL, 0x000fe200078e0210ULL,
0x000088801f597816ULL, 0x000fe400000000ffULL, 0x000000027a7a7810ULL, 0x000fe20007ffe0ffULL,
0x0000007800787306ULL, 0x000ee20000200c00ULL, 0xfffffff011107812ULL, 0x000fe200078ee210ULL,
0x000100001d117824ULL, 0x000fe200078e00ffULL, 0x0000007a077a7211ULL, 0x000fe200078fe0ffULL,
0x000001001d1d7824ULL, 0x000fc400078e00ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011411ULL, 0x0000001c00527306ULL, 0x0007e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x00000001417a7824ULL, 0x000fe400078e027aULL,
0x000000001010783bULL, 0x004ea80000000200ULL, 0x0000001d00577306ULL, 0x0003e20000200c00ULL,
0x000100001e1c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x002fe20000011418ULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc40000011419ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x000100001f1d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001141aULL,
0x00000018ff5c7819ULL, 0x000fe4000001141dULL, 0x0000007400747306ULL, 0x000ee20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fc4000001141fULL, 0x00005410761f7816ULL, 0x000fe4000000005fULL,
0x00008880181d7816ULL, 0x000fe400000000ffULL, 0x00000018ff497819ULL, 0x000fe2000001141bULL,
0x0000001e005a7306ULL, 0x0003f00000200c00ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00005410781e7816ULL, 0x002fce000000007bULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000001e1038723cULL, 0x004b6e0000001838ULL, 0x0000001c005b7306ULL, 0x0007e20000200c00ULL,
0x000000ffff1e7224ULL, 0x020fe200078e001dULL, 0x00005410611d7816ULL, 0x000fe20000000060ULL,
0x0000001041617824ULL, 0x000fc400078e00ffULL, 0x00010000181f7824ULL, 0x040fe400078e00ffULL,
0x0000010018187824ULL, 0x000fe200078e00ffULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00005410741c7816ULL, 0x008fe40000000079ULL, 0xfffffff0617a7812ULL, 0x000fe400078ee27aULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000001c1034723cULL, 0x000b6e0000001834ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x00005410721c7816ULL, 0x022fc40000000077ULL,
0x00005410751d7816ULL, 0x000fe40000000070ULL, 0x0000888019707816ULL, 0x000fc600000000ffULL,
0x0000005400547306ULL, 0x000e640000200c00ULL, 0x0000001c1030723cULL, 0x000bec0000001830ULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x00005410641c7816ULL, 0x024fe40000000073ULL,
0x00005410711d7816ULL, 0x000fe20000000066ULL, 0x000000ffff667224ULL, 0x000fe200078e0070ULL,
0x000054106e557816ULL, 0x008fe20000000055ULL, 0x0001000019707824ULL, 0x000fc400078e00ffULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000541054547816ULL, 0x002fe2000000006fULL,
0x0000001c102c723cULL, 0x040fec000000182cULL, 0x0000001e00607306ULL, 0x0003e40000200c00ULL,
0x000000541028723cULL, 0x000b6c0000001828ULL, 0x0000001f00617306ULL, 0x0004e20000200c00ULL,
0x000000107a1e7824ULL, 0x002fe200078e00ffULL, 0x00000018ff557819ULL, 0x020fe20000011470ULL,
0x0000010019547824ULL, 0x000fe200078e00ffULL, 0x000054106a197816ULL, 0x000fc80000000067ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000001e1c783bULL, 0x004e620000000200ULL,
0x00000018ff677819ULL, 0x000fe40000011454ULL, 0x000088801a547816ULL, 0x000fc800000000ffULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000541060607816ULL, 0x008fce0000000061ULL,
0x0000001800647306ULL, 0x0007f00000200c00ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054106c187816ULL, 0x008fce000000006dULL, 0x0000006200627306ULL, 0x000ee20000200c00ULL,
0x000000181024723cULL, 0x000b6e0000001824ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000541068187816ULL, 0x024fe4000000006bULL, 0x0000541069197816ULL, 0x000fe2000000005eULL,
0x000100001a5e7824ULL, 0x000fc400078e00ffULL, 0x000001001a1a7824ULL, 0x000fe400078e00ffULL,
0x0000004a004a7306ULL, 0x000fe40000200c00ULL, 0x000000181020723cULL, 0x000b6c0000001820ULL,
0x0000005d005d7306ULL, 0x000ea20000200c00ULL, 0x0000541062187816ULL, 0x028fc40000000065ULL,
0x0000541063197816ULL, 0x000fca0000000048ULL, 0x0000005000507306ULL, 0x000ee40000200c00ULL,
0x000000181014723cULL, 0x000b6c0000001814ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x000054104a107816ULL, 0x024fe4000000005dULL, 0x0000541052117816ULL, 0x000fc40000000051ULL,
0x000088801b187816ULL, 0x000fe400000000ffULL, 0x00000018ff137819ULL, 0x000fe2000001145eULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x00000018ff127819ULL, 0x000fe2000001141aULL,
0x000000101c38723cULL, 0x002b6c0000001838ULL, 0x0000004f004f7306ULL, 0x000e620000200c00ULL,
0x0000541057117816ULL, 0x028fc40000000050ULL, 0x0000541053107816ULL, 0x004fca0000000058ULL,
0x0000004e004e7306ULL, 0x000fe40000200c00ULL, 0x000000101c34723cULL, 0x000b620000001834ULL,
0x000054105a577816ULL, 0x002fca000000004fULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x000100001b117824ULL, 0x060fe400078e00ffULL, 0x000001001b1b7824ULL, 0x000fca00078e00ffULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000000ffff107224ULL, 0x000fe200078e0018ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff1b7819ULL, 0x000fc8000001141bULL,
0x0000001000107306ULL, 0x000fe20000200c00ULL, 0x0000541064617816ULL, 0x002fce000000004dULL,
0x0000001100117306ULL, 0x000e620000200c00ULL, 0x000000601c28723cULL, 0x000b6e0000001828ULL,
0x0000004b004b7306ULL, 0x000ff00000200c00ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000541010107816ULL, 0x002fce0000000011ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000005900597306ULL, 0x000ff00000200c00ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x0000541056567816ULL, 0x002fce000000005bULL, 0x0000007c005f7306ULL, 0x000e620000200c00ULL,
0x000000561c30723cULL, 0x000b6e0000001830ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00005410595c7816ULL, 0x004fce000000005cULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x000054105f5d7816ULL, 0x002fce000000004eULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x0000005c1c2c723cULL, 0x000b6e000000182cULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541066667816ULL, 0x004fce0000000055ULL, 0x0000001300137306ULL, 0x000ea20000200c00ULL,
0x0000541067677816ULL, 0x002fce000000004cULL, 0x0000001200127306ULL, 0x000e620000200c00ULL,
0x000000661c24723cULL, 0x000b6e0000001824ULL, 0x0000001b00187306ULL, 0x000ee20000200c00ULL,
0x00005410544a7816ULL, 0x004fe40000000013ULL, 0x00005410124b7816ULL, 0x002fce000000004bULL,
0x0000004a1c20723cULL, 0x000b620000001820ULL, 0x0000541018117816ULL, 0x008fce0000000049ULL,
0x000000101c14723cULL, 0x000b620000001814ULL, 0xfffff05000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff107224ULL, 0x020fe200078e000eULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe0f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x080fe20000410000ULL, 0x0000000638387220ULL, 0x080fe20000410000ULL,
0x0000000639397220ULL, 0x080fe20000410000ULL, 0x0000000630107220ULL, 0x080fe20000410000ULL,
0x0000000631117220ULL, 0x080fe20000410000ULL, 0x000000062d127220ULL, 0x080fe20000410000ULL,
0x0000000628287220ULL, 0x080fe20000410000ULL, 0x0000000626187220ULL, 0x080fe20000410000ULL,
0x0000000627197220ULL, 0x080fe20000410000ULL, 0x00000006331c7220ULL, 0x080fe20000410000ULL,
0x000000062f1e7220ULL, 0x080fe20000410000ULL, 0x000000062a1f7220ULL, 0x080fe20000410000ULL,
0x000000062b1a7220ULL, 0x080fe20000410000ULL, 0x0000000620277220ULL, 0x080fe20000410000ULL,
0x0000000621267220ULL, 0x080fe20000410000ULL, 0x00000006321b7220ULL, 0x080fe20000410000ULL,
0x000000062c337220ULL, 0x080fe20000410000ULL, 0x000000062e1d7220ULL, 0x080fe20000410000ULL,
0x00000006242b7220ULL, 0x080fe20000410000ULL, 0x00000006252a7220ULL, 0x080fe20000410000ULL,
0x0000000622207220ULL, 0x080fe20000410000ULL, 0x0000000623217220ULL, 0x080fe20000410000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0034ULL, 0x000000063a3a7220ULL, 0x080fe20000410000ULL,
0x000000ffff307224ULL, 0x000fe200078e0035ULL, 0x000000063b3b7220ULL, 0x080fe20000410000ULL,
0x0000000636367220ULL, 0x080fe20000410000ULL, 0x0000000637377220ULL, 0x080fe20000410000ULL,
0x00000006292c7220ULL, 0x080fe20000410000ULL, 0x0000000614257220ULL, 0x080fe20000410000ULL,
0x0000000615247220ULL, 0x080fe20000410000ULL, 0x0000000616227220ULL, 0x080fe20000410000ULL,
0x0000000617237220ULL, 0x000fe20000410000ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0038ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0039ULL, 0x000000ffff317224ULL, 0x000fe400078e0010ULL,
0x000000ffff327224ULL, 0x000fe400078e0011ULL, 0x000000ffff347224ULL, 0x000fe400078e0012ULL,
0x000000ffff357224ULL, 0x000fe200078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000008107f8cULL, 0x0002a2000c80043fULL, 0x000000ffff147224ULL, 0x000fc400078e003aULL,
0x000000ffff157224ULL, 0x000fe400078e003bULL, 0x000000ffff167224ULL, 0x000fe400078e0036ULL,
0x000000ffff177224ULL, 0x000fc400078e0037ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x0000040008297984ULL, 0x000ee40000000800ULL, 0x8000000029ff7812ULL, 0x00cfe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002812377210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000003728287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040008297984ULL, 0x000ea40000000800ULL,
0x8000000029ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000407297824ULL, 0x000fe200078e00ffULL, 0x000000090c00720cULL, 0x000fc80003f05270ULL,
0xfffffff029287812ULL, 0x000fca00078ec0ffULL, 0x000000803d287824ULL, 0x000fca00078e0228ULL,
0x00f4000028107984ULL, 0x0004e20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000207367824ULL, 0x000fe400078e00ffULL, 0x000000013e0d7824ULL, 0x000fc600078e0a0dULL,
0x0000000636367812ULL, 0x000fc800078ec0ffULL, 0x0000000136387812ULL, 0x040fe400078efcffULL,
0x00000008363a7812ULL, 0x000fe400078efcffULL, 0x0000000d3800720cULL, 0x080fe40003f26070ULL,
0x0000001036387812ULL, 0x000fe400078efcffULL, 0x0000000d3a00720cULL, 0x080fe40003f06070ULL,
0x0000000d3800720cULL, 0x000fc40003fc6070ULL, 0x00000011363a7812ULL, 0x040fe400078efcffULL,
0x0000001836387812ULL, 0x040fe400078efcffULL, 0x0000000d3600720cULL, 0x080fe40003f46070ULL,
0x0000000d3a00720cULL, 0x080fe40003fa6070ULL, 0x0000000d3800720cULL, 0x000fe40003f66070ULL,
0x0000000936407812ULL, 0x000fc400078efcffULL, 0x00000019363a7812ULL, 0x040fe400078efcffULL,
0x0000002036387812ULL, 0x000fe400078efcffULL, 0xff80000014147808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40004800000ULL,
0xff8000002e2e7808ULL, 0x000fc40004800000ULL, 0x0000000d4000720cULL, 0x080fe40003f86070ULL,
0x0000000d3a00720cULL, 0x080fe40003f46070ULL, 0x0000000d3800720cULL, 0x000fe40003f26070ULL,
0x00000021363a7812ULL, 0x040fe400078efcffULL, 0x0000002836387812ULL, 0x000fe400078efcffULL,
0xff80000016167808ULL, 0x000fc40004000000ULL, 0xff8000002f2f7808ULL, 0x000fe40004000000ULL,
0xff80000017177808ULL, 0x000fe40006000000ULL, 0xff80000030307808ULL, 0x000fe40006000000ULL,
0x0000000d3a00720cULL, 0x080fe40003f06070ULL, 0x0000000d3800720cULL, 0x000fe40003f86070ULL,
0x00000029363a7812ULL, 0x000fc400078efcffULL, 0x0000003036387812ULL, 0x000fe400078efcffULL,
0xff8000001b1b7808ULL, 0x000fe40007000000ULL, 0xff80000031317808ULL, 0x000fe40007000000ULL,
0xff8000001c1c7808ULL, 0x000fe40006800000ULL, 0xff80000032327808ULL, 0x000fe40006800000ULL,
0x0000000d3a00720cULL, 0x000fc40003fc6070ULL, 0x0000000d3800720cULL, 0x000fe40003fa6070ULL,
0x00000031363a7812ULL, 0x040fe400078efcffULL, 0x0000003836387812ULL, 0x040fe400078efcffULL,
0x0000003936367812ULL, 0x000fe400078efcffULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff80000033337808ULL, 0x000fc40005800000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff80000034347808ULL, 0x000fe40005000000ULL, 0xff8000001f1f7808ULL, 0x000fe40004800000ULL,
0xff80000035357808ULL, 0x000fe40004800000ULL, 0x0000000d3a00720cULL, 0x080fe40003f66070ULL,
0x0000000d3800720cULL, 0x000fc40003f46070ULL, 0x0000000d3600720cULL, 0x000fe40003f26070ULL,
0xff8000001a1a7808ULL, 0x000fe40004000000ULL, 0xff8000002c2c7808ULL, 0x000fe40004000000ULL,
0xff80000018187808ULL, 0x000fe40006000000ULL, 0xff8000002b2b7808ULL, 0x000fe40006000000ULL,
0xff80000019197808ULL, 0x000fc40007000000ULL, 0xff8000002a2a7808ULL, 0x000fe40007000000ULL,
0xff80000020207808ULL, 0x000fe40006800000ULL, 0xff80000027277808ULL, 0x000fe40006800000ULL,
0xff80000021217808ULL, 0x000fe40005800000ULL, 0xff80000026267808ULL, 0x000fe40005800000ULL,
0xff80000022227808ULL, 0x000fc40005000000ULL, 0xff80000025257808ULL, 0x000fe40005000000ULL,
0xff80000023237808ULL, 0x000fe40004800000ULL, 0xff80000024247808ULL, 0x000fc40004800000ULL,
0x0000002d1000720bULL, 0x008fe20003f1e000ULL, 0x0000001fff407424ULL, 0x000fe200078e00ffULL,
0x000000141100720bULL, 0x000fe20003f3e000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x000000102d0d7208ULL, 0x000fe40004000000ULL, 0x0000001114107208ULL, 0x000fc40004800000ULL,
0x0000002e0d00720bULL, 0x000fe40003f1e000ULL, 0x000000151000720bULL, 0x000fe40003f3e000ULL,
0x0000000d2e367208ULL, 0x000fe40004000000ULL, 0x00000010150d7208ULL, 0x000fe40004800000ULL,
0x0000002f3600720bULL, 0x000fe40003f1e000ULL, 0x000000160d00720bULL, 0x000fc40003f3e000ULL,
0x000000362f117208ULL, 0x000fe40004000000ULL, 0x0000000d16107208ULL, 0x000fe40004800000ULL,
0x000000301100720bULL, 0x000fe40003f1e000ULL, 0x000000171000720bULL, 0x000fe40003f3e000ULL,
0x0000001130367208ULL, 0x000fe40004000000ULL, 0x0000001017107208ULL, 0x000fc40004800000ULL,
0x000000313600720bULL, 0x000fe40003f1e000ULL, 0x0000001b1000720bULL, 0x000fe40003f3e000ULL,
0x00000036310d7208ULL, 0x000fe40004000000ULL, 0x000000101b117208ULL, 0x000fe40004800000ULL,
0x000000320d00720bULL, 0x000fe40003f1e000ULL, 0x0000001c1100720bULL, 0x000fc40003f3e000ULL,
0x0000000d32107208ULL, 0x000fe40004000000ULL, 0x000000111c367208ULL, 0x000fe40004800000ULL,
0x000000331000720bULL, 0x000fe40003f1e000ULL, 0x0000001d3600720bULL, 0x000fe40003f3e000ULL,
0x00000010330d7208ULL, 0x000fe40004000000ULL, 0x000000361d117208ULL, 0x000fc40004800000ULL,
0x000000340d00720bULL, 0x000fe40003f1e000ULL, 0x0000001e1100720bULL, 0x000fe40003f3e000ULL,
0x0000000d34107208ULL, 0x000fe40004000000ULL, 0x000000111e367208ULL, 0x000fe40004800000ULL,
0x000000351000720bULL, 0x000fe40003f1e000ULL, 0x0000001f3600720bULL, 0x000fc40003f3e000ULL,
0x00000010350d7208ULL, 0x000fe40004000000ULL, 0x000000361f117208ULL, 0x000fe40004800000ULL,
0x0000002c0d00720bULL, 0x000fe40003f1e000ULL, 0x0000001a1100720bULL, 0x000fe40003f3e000ULL,
0x0000000d2c107208ULL, 0x000fe40004000000ULL, 0x000000111a117208ULL, 0x000fc40004800000ULL,
0x0000002b1000720bULL, 0x000fe40003f1e000ULL, 0x000000181100720bULL, 0x000fe40003f3e000ULL,
0x000000102b0d7208ULL, 0x000fe40004000000ULL, 0x0000001118107208ULL, 0x000fe40004800000ULL,
0x0000002a0d00720bULL, 0x000fe40003f1e000ULL, 0x000000191000720bULL, 0x000fc40003f3e000ULL,
0x0000000d2a367208ULL, 0x000fe40004000000ULL, 0x00000010190d7208ULL, 0x000fe40004800000ULL,
0x000000273600720bULL, 0x000fe40003f1e000ULL, 0x000000200d00720bULL, 0x000fe40003f3e000ULL,
0x0000003627117208ULL, 0x000fe40004000000ULL, 0x0000000d20107208ULL, 0x000fc40004800000ULL,
0x000000261100720bULL, 0x000fe40003f1e000ULL, 0x000000211000720bULL, 0x000fe40003f3e000ULL,
0x0000001126367208ULL, 0x000fe40004000000ULL, 0x00000010210d7208ULL, 0x000fe40004800000ULL,
0x000000253600720bULL, 0x000fe40003f1e000ULL, 0x000000220d00720bULL, 0x000fc40003f3e000ULL,
0x0000003625117208ULL, 0x000fe40004000000ULL, 0x0000000d22107208ULL, 0x000fe40004800000ULL,
0x000000241100720bULL, 0x000fe40003f1e000ULL, 0x000000231000720bULL, 0x000fe40003f3e000ULL,
0x0000001124397208ULL, 0x000fe40004000000ULL, 0x00000010233b7208ULL, 0x000fe20004800000ULL,
0x000014d27f007947ULL, 0x000fec000b800000ULL, 0x0c401f00390d7f89ULL, 0x00066400000e0000ULL,
0x0000000d3900720bULL, 0x002fc80003f1e000ULL, 0x000000390d3f7208ULL, 0x000fe20004000000ULL,
0x000014e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f003b0d7f89ULL, 0x000e6800000e0000ULL,
0x0c401f0012117f89ULL, 0x000ea800000e0000ULL, 0x0c401f0013107f89ULL, 0x000ee200000e0000ULL,
0x0000000d3b00720bULL, 0x002fc40003f1e000ULL, 0x000000111200720bULL, 0x004fe40003f3e000ULL,
0x0000003b0d377208ULL, 0x000fe40004000000ULL, 0x0000001211387208ULL, 0x000fe40004800000ULL,
0x0c201f003f117f89ULL, 0x000e6200000e0000ULL, 0x000000101300720bULL, 0x008fc60003f1e000ULL,
0x0c201f00373a7f89ULL, 0x000ea200000e0000ULL, 0x00000013100d7208ULL, 0x000fc60004000000ULL,
0x0c201f0038397f89ULL, 0x000ee800000e0000ULL, 0x0c201f000d367f89ULL, 0x0002e400000e0000ULL,
0x000000113f00720bULL, 0x002fe40003f1e000ULL, 0x0000003a3700720bULL, 0x004fe40003f3e000ULL,
0x0000003f11107208ULL, 0x000fc40004000000ULL, 0x000000393800720bULL, 0x008fe40003f5e000ULL,
0x000000373a117208ULL, 0x000fe40004800000ULL, 0x0000003839127208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b10377820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000307ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010837ULL, 0x00000030003b7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b27137823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010837ULL, 0x0000002e00397308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b24307823ULL, 0x004fe20000010837ULL, 0x3fb8aa3b11247820ULL, 0x000fe20000410000ULL,
0x000000360d00720bULL, 0x000fc60003f3e000ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010824ULL, 0x0000002f003a7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b2c2e7823ULL, 0x102fe20000010837ULL, 0x3fb8aa3b2b2c7823ULL, 0x000fe20000010837ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b1e1e7823ULL, 0x000fc40000010824ULL,
0x0000001400277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2f7823ULL, 0x004fce0000010837ULL,
0x00000015002a7308ULL, 0x000e700000000800ULL, 0x00000016002b7308ULL, 0x0005f00000000800ULL,
0x0000001700407308ULL, 0x000ee20000000800ULL, 0x000000272a15723eULL, 0x002fe200000000ffULL,
0x3c003c00ff2a7424ULL, 0x000fe200078e00ffULL, 0x0000003a3b16723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b193a7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b1a277823ULL, 0x000fc60000010824ULL,
0x0000002d00387308ULL, 0x0002a20000000800ULL, 0x0000002b4017723eULL, 0x008fe200000000ffULL,
0x3c003c00ff2b7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b352d7823ULL, 0x002fca0000010837ULL,
0x0000001c00427308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1f377823ULL, 0x100fe20000010824ULL,
0x00000002ff407819ULL, 0x000fe40000011607ULL, 0x000000383914723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b18397823ULL, 0x000fe40000010824ULL, 0x00000008403f7824ULL, 0x040fe200078e00ffULL,
0x0000001d00357308ULL, 0x000fe20000000800ULL, 0x00000002403b7810ULL, 0x000fce0007ffe0ffULL,
0x0000001e00447308ULL, 0x0003f00000000800ULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0x0000002a141c723cULL, 0x002f6e00000018ffULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x0000001b4219723eULL, 0x004fe200000000ffULL,
0x0000000840427824ULL, 0x000fe200078e00ffULL, 0x00000035441b723eULL, 0x000fe200000000ffULL,
0x0000000840357824ULL, 0x000fc600078e00ffULL, 0xfffffff8423b7812ULL, 0x000fe200078ee23bULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x0000003400347308ULL, 0x000ea20000000800ULL,
0x000000313218723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b21317823ULL, 0x000fcc0000010824ULL,
0x0000002700387308ULL, 0x0003e20000000800ULL, 0x00000033341a723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b20277823ULL, 0x102fe20000010824ULL, 0x3fb8aa3b22337823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b23247823ULL, 0x000fc80000010824ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x0000000140347810ULL, 0x040fe20007ffe0ffULL, 0x0000002a1820723cULL, 0x020b66000000181cULL,
0xfffffff835357812ULL, 0x000fe400078ee234ULL, 0xffffffff40347810ULL, 0x040fe20007ffe0ffULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x00000008401e7824ULL, 0x060fe200078e00ffULL,
0x00000003401c7810ULL, 0x000fc40007ffe0ffULL, 0x00000004401d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee21cULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0xfffffff81e417812ULL, 0x000fce00078ee21dULL, 0x0000002f002f7308ULL, 0x000ea20000000800ULL,
0x0000002d2e1c723eULL, 0x002fe200000000ffULL, 0x00000008402d7824ULL, 0x040fe200078e00ffULL,
0x00000005402e7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee240ULL,
0x0000003700377308ULL, 0x000e700000000800ULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x0000002c2f1e723eULL, 0x004fe200000000ffULL, 0x00000008402f7824ULL, 0x000fca00078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee22eULL, 0x0000003a003a7308ULL, 0x000ea20000000800ULL,
0x00000037381d723eULL, 0x002fe200000000ffULL, 0x0000000840387824ULL, 0x040fe200078e00ffULL,
0x000090003d2e7811ULL, 0x000fe200078e58ffULL, 0x0000000840377824ULL, 0x000fc800078e00ffULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x000000102d2d7824ULL, 0x000fe200078e022eULL,
0xfffffff837377812ULL, 0x000fe200078ee234ULL, 0x0000001035357824ULL, 0x100fe400078e022eULL,
0x000000103b3b7824ULL, 0x100fe400078e022eULL, 0x000000103f3f7824ULL, 0x100fe200078e022eULL,
0x000000393a1f723eULL, 0x004fe200000000ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x0000000840397810ULL, 0x000fe20007ffe0ffULL, 0x0000001041417824ULL, 0x000fc400078e022eULL,
0x000000102f2f7824ULL, 0x100fe400078e022eULL, 0x0000002a1c20723cULL, 0x000f620000001820ULL,
0x00000008393a7824ULL, 0x000fe200078e00ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000001037377824ULL, 0x000fc600078e022eULL, 0xfffffff83a397812ULL, 0x000fc800078ee239ULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x0000001039397824ULL, 0x000fce00078e022eULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000003100327308ULL, 0x0006700000000800ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x0000000640317810ULL, 0x008fc80007ffe0ffULL,
0xfffffff838317812ULL, 0x000fc600078ee231ULL, 0x00000024002c7308ULL, 0x0002e40000000800ULL,
0x0000001031317824ULL, 0x000fe200078e022eULL, 0x000000132624723eULL, 0x002fe400000000ffULL,
0x000000253026723eULL, 0x004fe400000000ffULL, 0x000000273225723eULL, 0x000fe400000000ffULL,
0x0000000d36137208ULL, 0x000fe40004800000ULL, 0x000000332c27723eULL, 0x008fc400000000ffULL,
0x0000000c292c7812ULL, 0x000fca00078ec0ffULL, 0x0000002a2420723cULL, 0x020f620000001820ULL,
0x000000012d2d7824ULL, 0x000fe400078e022cULL, 0x000000012c357824ULL, 0x040fe400078e0235ULL,
0x000000012c3b7824ULL, 0x040fe200078e023bULL, 0x000000142d007388ULL, 0x0003e20000000800ULL,
0x000000012c3f7824ULL, 0x040fe400078e023fULL, 0x000000012c417824ULL, 0x040fe200078e0241ULL,
0x0000001635007388ULL, 0x0003e20000000800ULL, 0x000000012c2f7824ULL, 0x000fc400078e022fULL,
0x000000012c317824ULL, 0x040fe200078e0231ULL, 0x000000183b007388ULL, 0x0003e20000000800ULL,
0x000000012c377824ULL, 0x040fe400078e0237ULL, 0x000000012c2c7824ULL, 0x000fe200078e0239ULL,
0x0000001a3f007388ULL, 0x0003e80000000800ULL, 0x0000001c41007388ULL, 0x0003e40000000800ULL,
0x000000ffff217224ULL, 0x020fc400078e0022ULL, 0x0000001e2f007388ULL, 0x0003e80000000800ULL,
0x0000002431007388ULL, 0x0003e80000000800ULL, 0x0000002637007388ULL, 0x0003e80000000800ULL,
0x000000152c007388ULL, 0x0003e80000000800ULL, 0x0004001735007388ULL, 0x0003e80000000800ULL,
0x000400193b007388ULL, 0x0003e80000000800ULL, 0x0004001b3f007388ULL, 0x0003e80000000800ULL,
0x0004001d41007388ULL, 0x0003e80000000800ULL, 0x0004001f2f007388ULL, 0x0003e80000000800ULL,
0x0004002531007388ULL, 0x0003e80000000800ULL, 0x0004002737007388ULL, 0x0003e80000000800ULL,
0x00f0001028008388ULL, 0x0003e80000000c00ULL, 0x00f2002028008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000aff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008000aff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010000aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000010c0c7810ULL, 0x000fe20007ffe0ffULL,
0x000018000aff7f8cULL, 0x0003e6000c80043fULL, 0x0000000f0c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc47000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff117807ULL, 0x004fe40004000000ULL,
0x000113c000107802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0016ULL, 0xffff0fd000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40004000000ULL, 0x0001141000107802ULL, 0x000fc40000000f00ULL,
0x00000c3000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff103000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x004fe200078e001dULL,
0x00011460001c7802ULL, 0x000fc40000000f00ULL, 0x00000b9000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff10f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e001dULL, 0x000114b0001c7802ULL, 0x000fc40000000f00ULL,
0x00000b4000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff121000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0015ULL,
0x00011510001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0012ULL,
0x00000ae000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0017ULL,
0xffff162000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0000ULL,
0x00011570001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff177224ULL, 0x000fc400078e0015ULL,
0x00000a8000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0017ULL,
0xffff15f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x004fe40004000000ULL,
0x000115c000107802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff389000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40004000000ULL, 0x0001161000107802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x018fea0003c00000ULL, 0xffff38f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00011650001c7802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff39d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x000116a0001c7802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x01afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff3ae000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00011700001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x000008f000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0017ULL, 0xffff3ef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00011750001c7802ULL, 0x000fc40000000f00ULL,
0x000008a000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0017ULL,
0xffff3ed000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x004fe40004000000ULL,
0x000117a000107802ULL, 0x000fc40000000f00ULL, 0x000008a000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0xffff5e5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40004000000ULL, 0x000117f000107802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff5ea000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x00011840001c7802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff5f8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x00011890001c7802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff609000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x000118f0001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0013ULL,
0x0000070000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0017ULL,
0xffff64a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00011940001c7802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0017ULL, 0xffff648000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x004fe40004000000ULL, 0x0001199000107802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff845000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40004000000ULL,
0x000119e000107802ULL, 0x000fc40000000f00ULL, 0x0000066000007944ULL, 0x018fea0003c00000ULL,
0xffff84b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00011a20001c7802ULL, 0x000fc40000000f00ULL, 0x000005d000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff858000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00011a70001c7802ULL, 0x000fc40000000f00ULL,
0x0000058000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff869000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00011ad0001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0013ULL,
0x0000052000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0017ULL,
0xffff8a9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00011b20001c7802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0017ULL, 0xffff8a7000007947ULL, 0x000fea000383ffffULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x00011b7000367802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0038ULL,
0xffffeaf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff397224ULL, 0x008fe200078e003bULL,
0x00011bd000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff3a7424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x014fea0003c00000ULL, 0x000000383b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0012ULL, 0x00011c3000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003b38117208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000381200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0013ULL, 0x00011c9000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x00000012383b7208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000381300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e003fULL, 0x00011cf000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x00000013380d7208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x000000383f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0011ULL, 0x00011d5000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003f38107208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x000000381100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e003bULL, 0x00011db000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000001138117208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000383b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e000dULL, 0x00011e1000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003b38127208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e0038ULL,
0xffffe9b000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffee05002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff377424ULL, 0x000fe200078e00ffULL,
0x0000004100007348ULL, 0x000fe80003800000ULL, 0x0c00003a39387389ULL, 0x0002a200000e0040ULL,
0xfffee01036007950ULL, 0x000fea0003c3ffffULL, 0x0000004500007348ULL, 0x000fe80003800000ULL,
0x0000001017177389ULL, 0x0002a200000e0048ULL, 0x00000000ff117424ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x002fc800078e001cULL, 0xfffedfc010007950ULL, 0x000fea0003c3ffffULL,
0x000000011100780cULL, 0x000fe20003f05070ULL, 0x0000004600007348ULL, 0x000fd80003800000ULL,
0x0000000000117806ULL, 0x000fc800040e0100ULL, 0x0000004611167212ULL, 0x000fe200078ec0ffULL,
0x00000000ff117424ULL, 0x000fc800078e00ffULL, 0xfffedf6010007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005deULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000358ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d20ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000de0ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001568ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001578ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001608ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000160cULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000012180ULL, 0x9300001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013980ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000139d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013d50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001608ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012378ULL, 0x0000000000012378ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013d50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_86_cubin_len = 81456;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
