/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014350ULL, 0x0000000000013fd0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000012260ULL, 0x0000000000000190ULL,
0x000b0022000004bdULL, 0x00000000000123f0ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x0000000000012430ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x0000000000012470ULL,
0x0000000000000110ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000012580ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001226000000000ULL, 0x0000040400000000ULL,
0x810c0000015c0400ULL, 0x0047300400288080ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x9408288080930828ULL, 0x2880809908288080ULL, 0x80ca08288080c208ULL,
0x1628808085082880ULL, 0x0000031028808280ULL, 0x8592000000000000ULL, 0x0000002200288080ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001226000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880809408288080ULL,
0x80c2082880809908ULL, 0x08288080ca082880ULL, 0x8082801628808090ULL, 0x0000000000031028ULL,
0x2880809092000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000011800000000ULL,
0x000123f000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880809408288080ULL, 0x80ca082880809908ULL,
0x16288080c2082880ULL, 0x0000031028808280ULL, 0xc292000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x000001b000000000ULL, 0x0001243000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL,
0x2880809408288080ULL, 0x80ca082880809908ULL, 0x16288080c2082880ULL, 0x0000031028808280ULL,
0xc292000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000024000000000ULL,
0x0001247000000000ULL, 0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001a00082f04ULL,
0x0008230400000066ULL, 0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL,
0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL,
0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL,
0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL,
0x0000001700080a04ULL, 0x0048190300480160ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x0198290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000e001982804ULL, 0x0000047000000100ULL, 0x00001d3000001c80ULL,
0x00001f9000001e20ULL, 0x00002410000023e0ULL, 0x000024b000002460ULL, 0x0000385000003820ULL,
0x000038f0000038a0ULL, 0x00004cf000004c60ULL, 0x00004f6000004e00ULL, 0x00005400000053d0ULL,
0x000054a000005450ULL, 0x0000666000006630ULL, 0x00006700000066b0ULL, 0x000079e000007960ULL,
0x00007c5000007af0ULL, 0x000080f0000080c0ULL, 0x0000819000008140ULL, 0x0000935000009320ULL,
0x000093f0000093a0ULL, 0x0000a6d00000a650ULL, 0x0000a9400000a7e0ULL, 0x0000ade00000adb0ULL,
0x0000ae800000ae30ULL, 0x0000c0600000c030ULL, 0x0000c1000000c0b0ULL, 0x0000c9000000c8f0ULL,
0x000107c00000d0d0ULL, 0x0001081000010800ULL, 0x0001087000010820ULL, 0x000108b000010890ULL,
0x000114f0000108c0ULL, 0x000115a000011540ULL, 0x0001166000011600ULL, 0x00011720000116c0ULL,
0x000117c000011770ULL, 0x0001186000011810ULL, 0x00011910000118b0ULL, 0x000119c000011960ULL,
0x00011a6000011a10ULL, 0x00011b0000011ab0ULL, 0x00011bb000011b50ULL, 0x00011c6000011c00ULL,
0x00011d0000011cb0ULL, 0x00011da000011d50ULL, 0x00011e5000011df0ULL, 0x00011f0000011ea0ULL,
0x00011fa000011f50ULL, 0x0001206000012000ULL, 0x00012120000120c0ULL, 0x000121e000012180ULL,
0x0600390400012240ULL, 0x000000ff00000210ULL, 0x003f010000010600ULL, 0x0000000300000280ULL,
0x003f012000010608ULL, 0x0000000300000320ULL, 0x003f012000010688ULL, 0x0000000300000410ULL,
0x003f0120000106a8ULL, 0x000000ff00000440ULL, 0x003f0100000106b8ULL, 0x000000ff00000500ULL,
0x003f010700010600ULL, 0x0000000900000600ULL, 0x003f01020001068cULL, 0x0000000900000690ULL,
0x003f010100010688ULL, 0x000000ff00000d10ULL, 0x003f0107000106a8ULL, 0x000000ff00000e30ULL,
0x003f0101000106a8ULL, 0x000000ff00000e90ULL, 0x003f0101000106b8ULL, 0x000000ff00000fc0ULL,
0x003f0105000106bcULL, 0x000000ff00001190ULL, 0x003f0105000106bcULL, 0x000000ff000018c0ULL,
0x003f0107000106b0ULL, 0x000000ff00001940ULL, 0x003f0101000106b0ULL, 0x00000009000019a0ULL,
0x003f010100010608ULL, 0x00000009000019c0ULL, 0x003f01050001060cULL, 0x0000000900001b90ULL,
0x003f01050001060cULL, 0x000000ff00002140ULL, 0x003f0105000106acULL, 0x000000ff00002310ULL,
0x003f0105000106acULL, 0x000000ff00002c30ULL, 0x003f0101000106b8ULL, 0x000000ff00002c50ULL,
0x003f0105000106bcULL, 0x000000ff00002e20ULL, 0x003f0105000106bcULL, 0x000000ff00003500ULL,
0x003f0107000106a8ULL, 0x000000ff00003580ULL, 0x003f0101000106a8ULL, 0x000000ff000035a0ULL,
0x003f0105000106b4ULL, 0x000000ff00003770ULL, 0x003f0105000106b4ULL, 0x000000ff00003f80ULL,
0x003f0101000106b8ULL, 0x000000ff00003ff0ULL, 0x003f010100010688ULL, 0x000000ff00004050ULL,
0x003f0105000106bcULL, 0x000000ff00004220ULL, 0x003f0105000106bcULL, 0x000000ff00004900ULL,
0x003f0107000106b0ULL, 0x000000ff00004980ULL, 0x003f0101000106b0ULL, 0x00000009000049e0ULL,
0x003f010100010628ULL, 0x0000000900004a00ULL, 0x003f01050001062cULL, 0x0000000900004bd0ULL,
0x003f01050001062cULL, 0x000000ff00005130ULL, 0x003f0105000106acULL, 0x000000ff00005300ULL,
0x003f0105000106acULL, 0x000000ff00005a30ULL, 0x003f0101000106b8ULL, 0x000000ff00005a50ULL,
0x003f0105000106bcULL, 0x000000ff00005c20ULL, 0x003f0105000106bcULL, 0x000000ff00006300ULL,
0x003f0107000106a8ULL, 0x000000ff00006380ULL, 0x003f0101000106a8ULL, 0x000000ff000063b0ULL,
0x003f0105000106b4ULL, 0x000000ff00006580ULL, 0x003f0105000106b4ULL, 0x000000ff00006c90ULL,
0x003f0101000106b8ULL, 0x000000ff00006d00ULL, 0x003f010100010690ULL, 0x000000ff00006d50ULL,
0x003f0105000106bcULL, 0x000000ff00006f20ULL, 0x003f0105000106bcULL, 0x000000ff00007600ULL,
0x003f0107000106b0ULL, 0x000000ff00007680ULL, 0x003f0101000106b0ULL, 0x00000009000076e0ULL,
0x003f010100010648ULL, 0x0000000900007700ULL, 0x003f01050001064cULL, 0x00000009000078d0ULL,
0x003f01050001064cULL, 0x000000ff00007e20ULL, 0x003f0105000106acULL, 0x000000ff00007ff0ULL,
0x003f0105000106acULL, 0x000000ff00008720ULL, 0x003f0101000106b8ULL, 0x000000ff00008740ULL,
0x003f0105000106bcULL, 0x000000ff00008910ULL, 0x003f0105000106bcULL, 0x000000ff00008ff0ULL,
0x003f0107000106a8ULL, 0x000000ff00009070ULL, 0x003f0101000106a8ULL, 0x000000ff000090a0ULL,
0x003f0105000106b4ULL, 0x000000ff00009270ULL, 0x003f0105000106b4ULL, 0x000000ff00009980ULL,
0x003f0101000106b8ULL, 0x000000ff000099f0ULL, 0x003f010100010698ULL, 0x000000ff00009a40ULL,
0x003f0105000106bcULL, 0x000000ff00009c10ULL, 0x003f0105000106bcULL, 0x000000ff0000a2f0ULL,
0x003f0107000106b0ULL, 0x000000ff0000a370ULL, 0x003f0101000106b0ULL, 0x000000090000a3d0ULL,
0x003f010100010668ULL, 0x000000090000a3f0ULL, 0x003f01050001066cULL, 0x000000090000a5c0ULL,
0x003f01050001066cULL, 0x000000ff0000ab10ULL, 0x003f0105000106acULL, 0x000000ff0000ace0ULL,
0x003f0105000106acULL, 0x000000ff0000b410ULL, 0x003f0101000106b8ULL, 0x000000ff0000b430ULL,
0x003f0105000106bcULL, 0x000000ff0000b600ULL, 0x003f0105000106bcULL, 0x000000ff0000bd00ULL,
0x003f0107000106a8ULL, 0x000000ff0000bd80ULL, 0x003f0101000106a8ULL, 0x000000ff0000bdb0ULL,
0x003f0105000106b4ULL, 0x000000ff0000bf80ULL, 0x003f0105000106b4ULL, 0x000000ff0000c690ULL,
0x003f0101000106b8ULL, 0x000000ff0000c6f0ULL, 0x003f0101000106a0ULL, 0x000000ff0000d2c0ULL,
0x003f010100010600ULL, 0x000000ff0000ddb0ULL, 0x003f010500010604ULL, 0x000000ff0000df80ULL,
0x003f010500010604ULL, 0x000000ff0000e300ULL, 0x003f010100010600ULL, 0x000000ff0000e330ULL,
0x003f010500010604ULL, 0x000000ff0000e4f0ULL, 0x003f010500010604ULL, 0x000000070000fbc0ULL,
0x003f010100000000ULL, 0x000000070000fcf0ULL, 0x003f010500000004ULL, 0x000000070000fec0ULL,
0x003f010500000004ULL, 0x0000000a00011350ULL, 0x003f010100000000ULL, 0x0000000a000113b0ULL,
0x003f010100000008ULL, 0x0000000a00011410ULL, 0x003f010100000010ULL, 0x0000000a00011480ULL,
0x003f010100000018ULL, 0x00101c0400053803ULL, 0x0000e5500000d210ULL, 0x000114c00000e600ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002bcULL, 0x0000001a00000002ULL,
0x000000000000022cULL, 0x0000001a00000002ULL, 0x000000000000019cULL, 0x0000001a00000002ULL,
0x00000000000000ecULL, 0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL,
0x0000000000000296ULL, 0x0000001a00000002ULL, 0x0000000000000206ULL, 0x0000001a00000002ULL,
0x0000000000000173ULL, 0x0000001a00000002ULL, 0x00000000000000c6ULL, 0x0000001a00000002ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001300097300ULL, 0x000fe200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000057919ULL, 0x000ee80000002200ULL, 0x0000000000147919ULL, 0x000f220000002600ULL,
0x0000001300137309ULL, 0x000ea60000000000ULL, 0x00000000000a7919ULL, 0x000f280000000000ULL,
0x0000000000127919ULL, 0x000f220000002700ULL, 0x00000005ff007819ULL, 0x002fc60000011603ULL,
0x00001fff040f7589ULL, 0x004fe200000e0000ULL, 0x000000ffff157224ULL, 0x000fc600078e0a13ULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x0000010004027a24ULL, 0x008fe400078e0205ULL,
0x0000000814067824ULL, 0x010fe400078e00ffULL, 0x0000000002037a24ULL, 0x000fe400078e0203ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x0000000a0900720cULL, 0x000fe40003f02070ULL,
0x000000ff0300720cULL, 0x000fe20003f25270ULL, 0x00000012070a7224ULL, 0x000fe200078e0206ULL,
0x0000000f0300780cULL, 0x000fc40003f44070ULL, 0x0000007f0300780cULL, 0x040fe40003f84070ULL,
0x000000030300780cULL, 0x000fe20003f64070ULL, 0x000000040f087824ULL, 0x002fcc00078e0200ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x00000002080b7824ULL, 0x000fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x000000010b0c7824ULL, 0x044fe400078e0202ULL,
0x000000200b0d7824ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0x3fffffc0ff06a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0xffffffe00d107812ULL, 0x000fe200078ee20cULL, 0xff317217ff16c424ULL, 0x000fe200078e00ffULL,
0x000000080b0c7817ULL, 0x000fe20007800000ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x010608060300a388ULL, 0x0005e20000008a00ULL, 0x000000010300780cULL, 0x000fe20003f44070ULL,
0x000000010a047824ULL, 0x102fe400078e020bULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0bULL,
0x000000010b0b7810ULL, 0x000fe20007ffe0ffULL, 0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL,
0x010400160300c388ULL, 0x0003e20000004800ULL, 0x00000200ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000010c00780cULL, 0x000fe20003f83070ULL, 0x00000010020e7824ULL, 0x000fe200078e00ffULL,
0x010688080300b388ULL, 0x0007e20000008a00ULL, 0x000000010a067824ULL, 0x004fe200078e020bULL,
0x000000ff0c00720cULL, 0x000fe20003f63070ULL, 0x00005c0004047625ULL, 0x000fe200078e000dULL,
0x000001f00e117812ULL, 0x000fc600078ec0ffULL, 0x000000200b167824ULL, 0x002fe400078e00ffULL,
0x00005c0006067625ULL, 0x000fe200078e000dULL, 0x0000001104087210ULL, 0x008fc60007fbe0ffULL,
0x000000010b097824ULL, 0x000fe200078e0202ULL, 0x0000001106067210ULL, 0x000fe20007fde0ffULL,
0x3fffff00ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffff00ff0ba424ULL, 0x000fe200078e00ffULL,
0xffffffe016047812ULL, 0x000fe200078ee209ULL, 0x3fffff80ff0c9424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL, 0x0106a80a0300a388ULL, 0x000fe20000008a00ULL,
0x000000ffff097224ULL, 0x000fc400028e0605ULL, 0x0000001010117824ULL, 0x000fe200078e00ffULL,
0x0106b80cff009388ULL, 0x000fe20000000a00ULL, 0x000000ffff077224ULL, 0x000fe400030e0607ULL,
0x0000001004137824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff037224ULL, 0x000fe200078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e2000d901c46ULL, 0x00000004ff057424ULL, 0x000fc600078e00ffULL,
0x0000000006137faeULL, 0x0003e2000e101c46ULL, 0x0000600012047625ULL, 0x000fc600078e0005ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01060403ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fc40003f05270ULL,
0x000000ff030a7810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff087819ULL, 0x000fce000001160aULL,
0x0000cc5000008947ULL, 0x000fea0003800000ULL, 0x0000000800097824ULL, 0x000fe400078e00ffULL,
0x00000003ff047424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0409ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x00000002120a7824ULL, 0x000fe200078e00ffULL,
0x0000580014057a10ULL, 0x000fe20007ffe0ffULL, 0x0106880009ff7f8cULL, 0x0005e8000c80043fULL,
0x000058000a0a7a24ULL, 0x000fcc00078e0205ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x00000004ff057819ULL, 0x004fe20000011602ULL, 0x00000100ff177424ULL, 0x000fe200078e00ffULL,
0x0000000903047217ULL, 0x002fe40007800000ULL, 0x0000000205067810ULL, 0x000fe20007ffe0ffULL,
0x0000000109077824ULL, 0x000fe200078e0205ULL, 0x00000004050b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a09ULL, 0x0000000605117810ULL, 0x000fe20007ffe0ffULL,
0x00000001090d7824ULL, 0x040fe400078e0206ULL, 0x00000001090f7824ULL, 0x000fe200078e020bULL,
0x000000040500720cULL, 0x080fe20003f66070ULL, 0x0000000107057824ULL, 0x140fe200078e0202ULL,
0x000000040600720cULL, 0x080fe20003f46070ULL, 0x0000001007107824ULL, 0x000fe200078e00ffULL,
0x000000040b00720cULL, 0x080fe20003f26070ULL, 0x000000010d067824ULL, 0x100fe200078e0202ULL,
0x000000041100720cULL, 0x000fe20003f06070ULL, 0x000000100d137824ULL, 0x000fe200078e00ffULL,
0xfffffff0100b7812ULL, 0x000fe200078ee205ULL, 0x000000010f0c7824ULL, 0x000fc400078e0202ULL,
0x000000100f157824ULL, 0x000fe200078e00ffULL, 0xfffffff013107812ULL, 0x000fe200078ee206ULL,
0x000062000a047a24ULL, 0x000fe200078e0207ULL, 0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL,
0x0000000109117824ULL, 0x000fe200078e0211ULL, 0xfffffff015127812ULL, 0x000fe200078ee20cULL,
0x00005e0004047625ULL, 0x000fe200078e0017ULL, 0x000000f00e157812ULL, 0x000fc600078ec0ffULL,
0x000062000a067a24ULL, 0x000fe200078e020dULL, 0x0000001504047210ULL, 0x000fe20007fbe0ffULL,
0x000062000a0c7a24ULL, 0x040fe400078e020fULL, 0x000062000a0e7a24ULL, 0x000fe400078e0211ULL,
0x00005e0006067625ULL, 0x000fc800078e0017ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0017ULL,
0x0000001506067210ULL, 0x000fc60007f9e0ffULL, 0x00005e000e0e7625ULL, 0x000fc800078e0017ULL,
0x0000000111137824ULL, 0x040fe200078e0202ULL, 0x000000150e0e7210ULL, 0x080fe20007fde0ffULL,
0x0000001011147824ULL, 0x000fe200078e00ffULL, 0x0000c00010117811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200028e0605ULL, 0x000000150c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200020e0607ULL, 0xfffffff014147812ULL, 0x000fe200078ee213ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x0000c00012137811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000c00014157811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000d901c46ULL,
0x0000000006117faeULL, 0x0003e8000d101c46ULL, 0x000000000c137faeULL, 0x0003e8000c901c46ULL,
0x000000000e157faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000902057211ULL, 0x004fe200078fe0ffULL, 0x00000100ff137424ULL, 0x000fe200078e00ffULL,
0x000000f00e157812ULL, 0x000fc400078ec0ffULL, 0x0000000205077810ULL, 0x040fe20007ffe0ffULL,
0x0000000105047824ULL, 0x142fe200078e0202ULL, 0x00000004050d7810ULL, 0x040fe20007ffe0ffULL,
0x00000010050b7824ULL, 0x000fe400078e00ffULL, 0x0000000107067824ULL, 0x040fe400078e0202ULL,
0x00000010070f7824ULL, 0x000fe200078e00ffULL, 0xfffffff00b0b7812ULL, 0x000fe200078ee204ULL,
0x000062000a047a24ULL, 0x000fe400078e0205ULL, 0x000000010d0c7824ULL, 0x000fe200078e0202ULL,
0xfffffff00f107812ULL, 0x000fe200078ee206ULL, 0x000000100d117824ULL, 0x000fe200078e00ffULL,
0x00000006050f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0013ULL,
0x0000c0000b0b7811ULL, 0x000fc400078e20ffULL, 0xfffffff011127812ULL, 0x000fe200078ee20cULL,
0x000062000a077a24ULL, 0x000fe200078e0207ULL, 0x0000001504047210ULL, 0x000fe20007f1e0ffULL,
0x000062000a0d7a24ULL, 0x040fe400078e020dULL, 0x000062000a0e7a24ULL, 0x000fe400078e020fULL,
0x00005e0007067625ULL, 0x000fc800078e0013ULL, 0x000000010f117824ULL, 0x040fe200078e0202ULL,
0x0000001506067210ULL, 0x000fe20007f3e0ffULL, 0x000000100f147824ULL, 0x000fe400078e00ffULL,
0x00005e000d0c7625ULL, 0x000fc600078e0013ULL, 0xfffffff014147812ULL, 0x000fe200078ee211ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0013ULL, 0x0000c00010117811ULL, 0x000fe400078e20ffULL,
0x0000c00012137811ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x000000150c0c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000150e0e7210ULL, 0x000fe40007f5e0ffULL, 0x0000c00014157811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fc600010e060fULL,
0x0000000006117faeULL, 0x0003e8000b901c46ULL, 0x000000000c137faeULL, 0x0003e8000b901c46ULL,
0x000000000e157faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff3e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff0c7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000b81000008947ULL, 0x000fea0003800000ULL,
0x000000ffff467224ULL, 0x004fe400078e000dULL, 0xff317217ff407424ULL, 0x000fc400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fc400078e00ffULL,
0x000001000d0c7824ULL, 0x000fca00078e00ffULL, 0x000000030c00720cULL, 0x000fda0003f06070ULL,
0x0000b76000000947ULL, 0x002fea0003800000ULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e177210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011411ULL,
0x000000170c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x000000020c0c7819ULL, 0x000fc80000001211ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010d0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000200d0c7811ULL, 0x000fe400078e40ffULL,
0x000000080f00720cULL, 0x000fc60003f26070ULL, 0x000062000a177a24ULL, 0x000fd400078e020cULL,
0x000003b000009947ULL, 0x000fea0003800000ULL, 0x0000000c030f7217ULL, 0x000fe20007800000ULL,
0x00000100ff1b7424ULL, 0x000fe200078e00ffULL, 0x00000004ff107819ULL, 0x000fc60000011602ULL,
0x000000010f0e7824ULL, 0x000fe200078e0a0cULL, 0x0000000210127810ULL, 0x000fe20007ffe0ffULL,
0x00000001090f7824ULL, 0x000fc600078e0210ULL, 0x0000000e090e7217ULL, 0x000fe20007800000ULL,
0x000000010f117824ULL, 0x040fe400078e0202ULL, 0x000000100f1a7824ULL, 0x000fe400078e00ffULL,
0x000000010e0e7824ULL, 0x000fe400078e0a09ULL, 0x0000000109167824ULL, 0x000fe200078e0212ULL,
0xfffffff01a1a7812ULL, 0x000fe200078ee211ULL, 0x0000001002117824ULL, 0x000fe200078e00ffULL,
0x0000000e1200720cULL, 0x080fe20003f66070ULL, 0x000000010f0f7824ULL, 0x000fe200078e0217ULL,
0x0000000410127810ULL, 0x000fe20007ffe0ffULL, 0x0000000116187824ULL, 0x000fe200078e0202ULL,
0x0000000e1000720cULL, 0x000fe20003f86070ULL, 0x0000001016197824ULL, 0x000fe200078e00ffULL,
0x0000000610107810ULL, 0x000fc40007ffe0ffULL, 0x0000000e1200720cULL, 0x080fe40003f46070ULL,
0x0000000e1000720cULL, 0x000fe20003f06070ULL, 0x00005e000f0e7625ULL, 0x000fe200078e001bULL,
0x000000f0111d7812ULL, 0x000fe400078ec0ffULL, 0xfffffff0191c7812ULL, 0x000fe200078ee218ULL,
0x0000000109117824ULL, 0x040fe200078e0212ULL, 0x0000001d0e187210ULL, 0x000fe20007fbe0ffULL,
0x00000001091e7824ULL, 0x000fe400078e0210ULL, 0x0000000116107824ULL, 0x000fc400078e0217ULL,
0x0000000111197824ULL, 0x040fe400078e0202ULL, 0x00000010113c7824ULL, 0x040fe400078e00ffULL,
0x0000000111127824ULL, 0x000fe400078e0217ULL, 0x00005e0010107625ULL, 0x000fe200078e001bULL,
0xfffffff03c1f7812ULL, 0x000fc600078ee219ULL, 0x000000011e167824ULL, 0x000fe200078e0217ULL,
0x0000e0001f1f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff197224ULL, 0x000fe200028e060fULL,
0x0000001d10107210ULL, 0x000fe20007fbe0ffULL, 0x00005e00120e7625ULL, 0x000fc800078e001bULL,
0x00005e0016167625ULL, 0x000fc800078e001bULL, 0x000000011e127824ULL, 0x000fe200078e0202ULL,
0x0000001d16167210ULL, 0x080fe20007fde0ffULL, 0x000000101e1b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x0000001d0e0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0xfffffff01b127812ULL, 0x000fe400078ee212ULL,
0x0000e0001a1b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e060fULL,
0x0000e0001c1d7811ULL, 0x000fc400078e20ffULL, 0x0000e000123d7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181b7faeULL, 0x0005e8000e101c46ULL,
0x00000000101d7faeULL, 0x0005e8000d901c46ULL, 0x000000000e1f7faeULL, 0x0005e8000d101c46ULL,
0x00000000163d7faeULL, 0x0005e2000c101c46ULL, 0x000002e000007947ULL, 0x000fea0003800000ULL,
0x00000009020f7211ULL, 0x000fc800078fe0ffULL, 0x000000020f117810ULL, 0x040fe20007ffe0ffULL,
0x000000010f0e7824ULL, 0x140fe200078e0202ULL, 0x000000040f167810ULL, 0x040fe20007ffe0ffULL,
0x000000100f197824ULL, 0x040fe200078e00ffULL, 0x000000060f1a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111107824ULL, 0x040fe400078e0202ULL, 0x00000010111d7824ULL, 0x000fe200078e00ffULL,
0xfffffff019127812ULL, 0x000fe200078ee20eULL, 0x00000100ff197424ULL, 0x000fe400078e00ffULL,
0x000000010f0e7824ULL, 0x000fe200078e0217ULL, 0xfffffff01d1d7812ULL, 0x000fe200078ee210ULL,
0x0000001002107824ULL, 0x000fc400078e00ffULL, 0x0000000116187824ULL, 0x040fe200078e0202ULL,
0x0000e0001d1d7811ULL, 0x000fe200078e20ffULL, 0x00000010161f7824ULL, 0x000fe200078e00ffULL,
0x000000f0101b7812ULL, 0x000fe200078ec0ffULL, 0x00005e000e0e7625ULL, 0x000fc600078e0019ULL,
0xfffffff01f1f7812ULL, 0x000fe200078ee218ULL, 0x0000000111107824ULL, 0x100fe200078e0217ULL,
0x0000001b0e0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000116167824ULL, 0x100fe200078e0217ULL,
0x0000e0001f1f7811ULL, 0x000fe200078e20ffULL, 0x000000011a187824ULL, 0x000fe400078e0217ULL,
0x00005e0010107625ULL, 0x000fc800078e0019ULL, 0x00005e0016167625ULL, 0x000fe200078e0019ULL,
0x0000001b10107210ULL, 0x000fc60007f5e0ffULL, 0x00005e0018187625ULL, 0x000fc800078e0019ULL,
0x000000011a1c7824ULL, 0x000fe200078e0202ULL, 0x0000001b18187210ULL, 0x080fe20007f7e0ffULL,
0x000000101a3d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000001b16167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0xfffffff03d1c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff197224ULL, 0x000fe200018e0619ULL,
0x0000e000121b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000e0001c3d7811ULL, 0x000fc600078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e1b7faeULL, 0x0005e8000b901c46ULL, 0x00000000101d7faeULL, 0x0005e8000b901c46ULL,
0x00000000161f7faeULL, 0x0005e8000b901c46ULL, 0x00000000183d7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff1e7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080009167f8cULL, 0x0006a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01060c0009117984ULL, 0x000f240000000800ULL, 0x8000000011ff7812ULL, 0x014fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e197210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000001910107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c0009117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff0f7819ULL, 0x000fe20000011602ULL, 0x00000010020e7824ULL, 0x000fc600078e00ffULL,
0x0000000c0f107812ULL, 0x000fe400078ec0ffULL, 0x000000700e0f7812ULL, 0x000fca00078ec0ffULL,
0x000000010f0f7824ULL, 0x000fe400078e0210ULL, 0xffffffffff107424ULL, 0x000fc600078e00ffULL,
0x010000000f177984ULL, 0x000ea80000000800ULL, 0x010200000f167984ULL, 0x0006620000000800ULL,
0x000000401700720bULL, 0x004fe20003f1d000ULL, 0x0000f8527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000117806ULL, 0x008fc800000e0100ULL, 0x0000ffff111b7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff417224ULL, 0x000fc400078e0040ULL, 0x0000001fff117424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f05270ULL, 0x000000401700720bULL, 0x000fe20003f54000ULL,
0x0000f7f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x000fc400010e0100ULL,
0x0000001740417209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991018197816ULL, 0x000fc600000000ffULL, 0x010400410f008388ULL, 0x0005e20000000800ULL,
0x000000ff1900720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000004140197221ULL, 0x004fe20000010000ULL, 0x000000ff18ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b19197820ULL, 0x000fc80000410000ULL,
0x00000019001c7308ULL, 0x0004ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff197819ULL, 0x004fe20000011602ULL, 0x0000f7527f007947ULL, 0x000fea000b800000ULL,
0x00001f191c197589ULL, 0x0084e400000e0000ULL, 0x0000001930307220ULL, 0x088fe20000410000ULL,
0x0000001931317220ULL, 0x080fe20000410000ULL, 0x0000001938387220ULL, 0x080fe20000410000ULL,
0x0000001939397220ULL, 0x080fe20000410000ULL, 0x0000001934347220ULL, 0x080fe20000410000ULL,
0x0000001935357220ULL, 0x080fe20000410000ULL, 0x0000001928287220ULL, 0x080fe20000410000ULL,
0x0000001929297220ULL, 0x080fe20000410000ULL, 0x0000001924247220ULL, 0x080fe20000410000ULL,
0x0000001925257220ULL, 0x080fe20000410000ULL, 0x000000192c2c7220ULL, 0x080fe20000410000ULL,
0x000000192d2d7220ULL, 0x080fe20000410000ULL, 0x0000001920207220ULL, 0x080fe20000410000ULL,
0x0000001921217220ULL, 0x080fe20000410000ULL, 0x0000001904047220ULL, 0x080fe20000410000ULL,
0x0000001905057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0018ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001c0b0b7220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802197811ULL, 0x004fe200078ff0ffULL,
0x0000f6427f007947ULL, 0x000fea000b800000ULL, 0x00001f191c197589ULL, 0x0004e400000e0000ULL,
0x0000001932327220ULL, 0x088fe20000410000ULL, 0x0000001933337220ULL, 0x080fe20000410000ULL,
0x000000193a3a7220ULL, 0x080fe20000410000ULL, 0x000000193b3b7220ULL, 0x080fe20000410000ULL,
0x0000001936367220ULL, 0x080fe20000410000ULL, 0x0000001937377220ULL, 0x080fe20000410000ULL,
0x000000192a2a7220ULL, 0x080fe20000410000ULL, 0x000000192b2b7220ULL, 0x080fe20000410000ULL,
0x0000001926267220ULL, 0x080fe20000410000ULL, 0x0000001927277220ULL, 0x080fe20000410000ULL,
0x000000192e2e7220ULL, 0x080fe20000410000ULL, 0x000000192f2f7220ULL, 0x080fe20000410000ULL,
0x0000001922227220ULL, 0x080fe20000410000ULL, 0x0000001923237220ULL, 0x080fe20000410000ULL,
0x0000001906067220ULL, 0x080fe20000410000ULL, 0x0000001907077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff1bff7812ULL, 0x000fda0007806018ULL,
0x8000004117170221ULL, 0x000fe20000010000ULL, 0x00007610ff1a0816ULL, 0x000fc6000000001aULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x0000001700130308ULL, 0x000ea40000000800ULL,
0x0000001316160220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b160b7221ULL, 0x002fc40000010000ULL, 0x0000000000167805ULL, 0x000fca0000015200ULL,
0x0106ac00ff187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018161b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e17ULL, 0x003d09001b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011419ULL,
0x0000001b18187211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x0000000218187819ULL, 0x000fc80000001219ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099101a167816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1600720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000013ff14723eULL, 0x000fe400000000ffULL, 0x00000002ff167819ULL, 0x000fe40000011602ULL,
0x0000541014177816ULL, 0x000fe20000000014ULL, 0x0000f2527f007947ULL, 0x000fea000b800000ULL,
0x00001f1617157589ULL, 0x0002a400000e0000ULL, 0x0000000816147810ULL, 0x000fe20007ffe0ffULL,
0x0000f2827f007947ULL, 0x000fea000b800000ULL, 0x00001f1417147589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010164a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0017ULL, 0x0000247000427802ULL, 0x000fc40000000f00ULL,
0x0000ffc000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018164a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x004fe200078e0017ULL,
0x000024c000427802ULL, 0x000fc40000000f00ULL, 0x0000ff7000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802177812ULL, 0x00afe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff167819ULL, 0x000fc40000011602ULL,
0x0000000702517812ULL, 0x000fe400078ec0ffULL, 0x0000000717507812ULL, 0x000fe200078ef802ULL,
0x00000004001d7824ULL, 0x040fe200078e0216ULL, 0x0000000851517812ULL, 0x000fe400078ef802ULL,
0x0000000200437811ULL, 0x000fe200078e10ffULL, 0x0000000150177824ULL, 0x040fe200078e021dULL,
0x00000010501c7812ULL, 0x040fe200078efcffULL, 0x0000001050187824ULL, 0x000fe400078e00ffULL,
0x0000000116407824ULL, 0x000fe200078e0251ULL, 0x000000431c5c7210ULL, 0x000fe20007ffe016ULL,
0x0000000851197824ULL, 0x000fe200078e00ffULL, 0xfffffff018187812ULL, 0x000fe200078ee217ULL,
0x0000000116537824ULL, 0x000fc400078e0243ULL, 0x00000010501a7824ULL, 0x040fe200078e00ffULL,
0xfffffff819177812ULL, 0x000fe200078ee240ULL, 0x0000000150197824ULL, 0x000fe200078e0253ULL,
0x0000c00018187811ULL, 0x000fe200078e20ffULL, 0x000000011d527824ULL, 0x000fe200078e021cULL,
0x0000a000173d7811ULL, 0x000fe400078e20ffULL, 0xfffffff01a197812ULL, 0x000fe200078ee219ULL,
0x000000001844783bULL, 0x000e660000004200ULL, 0x0000c00019197811ULL, 0x000fe200078e20ffULL,
0x000000003d3c783bULL, 0x000ee80000000200ULL, 0x000000001948783bULL, 0x004ea20000004200ULL,
0x0000312044447816ULL, 0x002fc400000000ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x00000044ff1a723eULL, 0x080fe200020006ffULL, 0x000000153c3ca232ULL, 0x088fe20000000000ULL,
0x00000045ff1b723eULL, 0x080fe200020006ffULL, 0x000000153e3ea232ULL, 0x000fe20000000000ULL,
0x00000044ff44723eULL, 0x000fe200030006ffULL, 0x000000143d3da232ULL, 0x080fe20000000000ULL,
0x00000045ff45723eULL, 0x000fe200030006ffULL, 0x000000143f3fa232ULL, 0x000fe20000000000ULL,
0x0000312046467816ULL, 0x000fc400000000ffULL, 0x0000312047477816ULL, 0x000fe400000000ffULL,
0x0000312048487816ULL, 0x004fe400000000ffULL, 0x000000443c38723cULL, 0x040be20000001838ULL,
0x0000312049497816ULL, 0x000fe400000000ffULL, 0x00000046ff4c723eULL, 0x000fe400020006ffULL,
0x00000047ff4d723eULL, 0x000fe400020006ffULL, 0x000000101c457824ULL, 0x020fe200078e00ffULL,
0x0000001a3c30723cULL, 0x000b620000001830ULL, 0x00000048ff58723eULL, 0x000fc400020006ffULL,
0x00000049ff59723eULL, 0x000fe400020006ffULL, 0xfffffff045527812ULL, 0x000fe400078ee252ULL,
0x00000008511b7824ULL, 0x020fe200078e00ffULL, 0x00000002401a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004c3c4c723cULL, 0x000be20000001834ULL, 0x000031204a4a7816ULL, 0x000fe400000000ffULL,
0xfffffff81b1a7812ULL, 0x000fe400078ee21aULL, 0x0000c000521b7811ULL, 0x000fc400078e20ffULL,
0x0000a0001a447811ULL, 0x000fe200078e20ffULL, 0x000000583c58723cULL, 0x000be40000001824ULL,
0x00000046ff34723eULL, 0x020fe200030006ffULL, 0x000000001b54783bULL, 0x000e620000004200ULL,
0x00000047ff35723eULL, 0x000fe400030006ffULL, 0x000031204b4b7816ULL, 0x000fe200000000ffULL,
0x000000004444783bULL, 0x000ea20000000200ULL, 0x000000101c277824ULL, 0x000fe200078e00ffULL,
0x0000004aff24723eULL, 0x000fc400020006ffULL, 0x0000004bff25723eULL, 0x000fe200020006ffULL,
0x000000343c28723cULL, 0x040f620000001828ULL, 0xfffffff0275c7812ULL, 0x000fe400078ee25cULL,
0x00000048ff48723eULL, 0x000fe400030006ffULL, 0x00000049ff49723eULL, 0x000fe400030006ffULL,
0x0000c0005c1c7811ULL, 0x000fe200078e20ffULL, 0x000000243c20723cULL, 0x040bee0000001820ULL,
0x0000004aff24723eULL, 0x020fe200030006ffULL, 0x000000483c2c723cULL, 0x000b62000000182cULL,
0x0000004bff25723eULL, 0x000fc400030006ffULL, 0x000000001c48783bULL, 0x020eea0000004200ULL,
0x000000243c3c723cULL, 0x000b620000001804ULL, 0x0000312054547816ULL, 0x002fe400000000ffULL,
0x0000312055557816ULL, 0x000fe200000000ffULL, 0x000000154444a232ULL, 0x084fe20000000000ULL,
0x00000054ff34723eULL, 0x000fe200020006ffULL, 0x000000154646a232ULL, 0x000fe20000000000ULL,
0x00000055ff35723eULL, 0x000fe200020006ffULL, 0x000000144545a232ULL, 0x080fe20000000000ULL,
0x0000312057257816ULL, 0x020fe200000000ffULL, 0x000000144747a232ULL, 0x000fe20000000000ULL,
0x0000312056567816ULL, 0x000fc400000000ffULL, 0x00000054ff54723eULL, 0x000fe400030006ffULL,
0x00000056ff24723eULL, 0x000fe400030006ffULL, 0x000000344434723cULL, 0x000b620000001830ULL,
0x00000055ff55723eULL, 0x000fcc00030006ffULL, 0x00000025ff31723eULL, 0x0a0fe200020006ffULL,
0x000000544438723cULL, 0x040f620000001838ULL, 0x00000025ff25723eULL, 0x000fe400030006ffULL,
0x0000312048487816ULL, 0x008fe400000000ffULL, 0x0000312049497816ULL, 0x000fe400000000ffULL,
0x000031204a4a7816ULL, 0x000fe200000000ffULL, 0x000000244424723cULL, 0x000b620000001828ULL,
0x000031204b4b7816ULL, 0x000fc400000000ffULL, 0x00000056ff30723eULL, 0x000fe400020006ffULL,
0x00000048ff04723eULL, 0x080fe400020006ffULL, 0x00000048ff28723eULL, 0x020fe400030006ffULL,
0x00000049ff29723eULL, 0x080fe200030006ffULL, 0x000000304430723cULL, 0x000f62000000184cULL,
0x00000049ff05723eULL, 0x000fce00020006ffULL, 0x000000284428723cULL, 0x040b6e000000182cULL,
0x0000004aff2c723eULL, 0x020fe200020006ffULL, 0x000000044404723cULL, 0x000f620000001858ULL,
0x0000004bff2d723eULL, 0x000fce00020006ffULL, 0x0000002c442c723cULL, 0x000b6e0000001820ULL,
0x0000004aff20723eULL, 0x020fe400030006ffULL, 0x0000004bff21723eULL, 0x000fce00030006ffULL,
0x000000204420723cULL, 0x000b62000000183cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff427f8cULL, 0x000e64000c80043fULL,
0x00000000003c7805ULL, 0x020fc40000015200ULL, 0x0106bc00ff3f7984ULL, 0x000ea40000000800ULL,
0x800000003fff7812ULL, 0x006fe40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c457210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000453e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff3f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000200c3d7810ULL, 0x000fca0007ffe0ffULL,
0x000062000a427a24ULL, 0x000fe200078e023dULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000001093f7824ULL, 0x000fe200078e0216ULL, 0x0000003d033c7217ULL, 0x000fe40007800000ULL,
0x00000004164c7810ULL, 0x040fe20007ffe0ffULL, 0x000000013f437824ULL, 0x040fe200078e0202ULL,
0x0000000216487810ULL, 0x000fe20007ffe0ffULL, 0x000000103f467824ULL, 0x000fe200078e00ffULL,
0x000000f00e497812ULL, 0x000fe200078ec0ffULL, 0x000000013c3e7824ULL, 0x000fe200078e0a3dULL,
0x00000006164e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109477824ULL, 0x040fe200078e024cULL,
0xfffffff046467812ULL, 0x000fe200078ee243ULL, 0x00000100ff437424ULL, 0x000fe200078e00ffULL,
0x0000003e093e7217ULL, 0x000fe20007800000ULL, 0x000000013f3c7824ULL, 0x000fc400078e0242ULL,
0x0000000147447824ULL, 0x040fe400078e0202ULL, 0x00000010474b7824ULL, 0x000fe400078e00ffULL,
0x0000000109457824ULL, 0x000fe400078e0248ULL, 0x00005e003c3c7625ULL, 0x000fe200078e0043ULL,
0xfffffff04b4b7812ULL, 0x000fc600078ee244ULL, 0x00000001453f7824ULL, 0x040fe200078e0202ULL,
0x000000493c447210ULL, 0x000fe20007f1e0ffULL, 0x00000010454a7824ULL, 0x000fe200078e00ffULL,
0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL, 0x00000001453c7824ULL, 0x100fe400078e0242ULL,
0x000000ffff457224ULL, 0x000fe200000e063dULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee23fULL,
0x00000001473f7824ULL, 0x000fe400078e0242ULL, 0x00005e003c3c7625ULL, 0x000fc800078e0043ULL,
0x00000001094d7824ULL, 0x000fe200078e024eULL, 0x000000493c3c7210ULL, 0x000fe20007fbe0ffULL,
0x000000013e477824ULL, 0x000fe400078e0a09ULL, 0x00005e003f3e7625ULL, 0x000fc600078e0043ULL,
0x000000474800720cULL, 0x000fe20003f66070ULL, 0x000000014d427824ULL, 0x040fe200078e0242ULL,
0x000000493e3e7210ULL, 0x000fe20007fde0ffULL, 0x000000014d487824ULL, 0x000fe200078e0202ULL,
0x000000471600720cULL, 0x000fe20003f86070ULL, 0x00005e0042427625ULL, 0x000fe200078e0043ULL,
0x000000474c00720cULL, 0x000fc60003f06070ULL, 0x000000ffff3d7224ULL, 0x000fe200028e063dULL,
0x000000474e00720cULL, 0x000fe20003fa6070ULL, 0x000000104d4d7824ULL, 0x000fe200078e00ffULL,
0x0000c00046477811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063fULL,
0x0000004942427210ULL, 0x000fe40007fde0ffULL, 0xfffffff04d487812ULL, 0x000fe200078ee248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044477faeULL, 0x0003e2000e101c46ULL,
0x0000c0004a497811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200030e0643ULL,
0x0000c000484d7811ULL, 0x000fc600078e20ffULL, 0x000000003c497faeULL, 0x0003e8000d901c46ULL,
0x000000003e4b7faeULL, 0x0003e8000c101c46ULL, 0x00000000424d7faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000109437824ULL, 0x000fe200078e0216ULL,
0x000000f00e4b7812ULL, 0x000fc600078ec0ffULL, 0x0000000143447824ULL, 0x040fe200078e0202ULL,
0x00000004433f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001043457824ULL, 0x040fe200078e00ffULL,
0x00000002433d7810ULL, 0x000fc60007ffe0ffULL, 0x000000013f3e7824ULL, 0x000fe200078e0202ULL,
0xfffffff0454c7812ULL, 0x000fe200078ee244ULL, 0x000000103f497824ULL, 0x000fe400078e00ffULL,
0x0000000143447824ULL, 0x040fe200078e0242ULL, 0x0000000643437810ULL, 0x000fe20007ffe0ffULL,
0x000000013d3c7824ULL, 0x000fe200078e0202ULL, 0xfffffff049487812ULL, 0x000fe200078ee23eULL,
0x00000100ff497424ULL, 0x000fe200078e00ffULL, 0x0000c0004c4d7811ULL, 0x000fe200078e20ffULL,
0x000000103d477824ULL, 0x000fc400078e00ffULL, 0x00005e0044447625ULL, 0x000fc600078e0049ULL,
0xfffffff047467812ULL, 0x000fe200078ee23cULL, 0x00000001423d7824ULL, 0x000fe200078e023dULL,
0x0000004b44447210ULL, 0x000fe20007f7e0ffULL, 0x00000001423f7824ULL, 0x040fe400078e023fULL,
0x0000000142427824ULL, 0x000fe400078e0243ULL, 0x00005e003d3c7625ULL, 0x000fc800078e0049ULL,
0x0000000143477824ULL, 0x040fe200078e0202ULL, 0x0000004b3c3c7210ULL, 0x000fe20007f1e0ffULL,
0x00000010434a7824ULL, 0x000fe400078e00ffULL, 0x00005e003f3e7625ULL, 0x000fc600078e0049ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee247ULL, 0x00005e0042427625ULL, 0x000fe200078e0049ULL,
0x0000c00046477811ULL, 0x000fe400078e20ffULL, 0x0000c00048497811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200018e0645ULL, 0x0000004b3e3e7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063dULL, 0x0000004b42427210ULL, 0x000fe40007f9e0ffULL,
0x0000c0004a4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000444d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff437224ULL, 0x000fc600020e0643ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x000000003e497faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff3e7f8cULL, 0x000e64000c80043fULL, 0x00000000003c7805ULL, 0x000fc40000015200ULL,
0x0106b400ff437984ULL, 0x000ea40000000800ULL, 0x8000000043ff7812ULL, 0x004fc4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x000000423c457210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e3dULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x002fc80000011443ULL,
0x000000453e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x000000023e3e7819ULL, 0x000fc80000001243ULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff437984ULL, 0x000ea40000000800ULL,
0x8000000043ff7812ULL, 0x004fe4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000013ff14723eULL, 0x000fe400000000ffULL, 0x00000002ff1f7819ULL, 0x000fe40000011602ULL,
0x00005410141e7816ULL, 0x000fe20000000014ULL, 0x0000ded27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f1e157589ULL, 0x0004e400000e0000ULL, 0x000000081f4a7810ULL, 0x002fe20007ffe0ffULL,
0x0000df027f007947ULL, 0x000fea000b800000ULL, 0x00001f4a1e147589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101f4a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e001eULL, 0x000038b000427802ULL, 0x000fc40000000f00ULL,
0x0000eb8000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181f4a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x004fe200078e001eULL,
0x0000390000427802ULL, 0x000fc40000000f00ULL, 0x0000eb3000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001501e7824ULL, 0x006fe200078e021dULL,
0x00000004401d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010501f7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008513c7824ULL, 0x000fe200078e00ffULL,
0x0000e0005c3e7811ULL, 0x000fe200078e20ffULL, 0x0000000150537824ULL, 0x040fe200078e0253ULL,
0xfffffff01f1e7812ULL, 0x000fe200078ee21eULL, 0x0000001050507824ULL, 0x000fe200078e00ffULL,
0xfffffff83c1d7812ULL, 0x000fe200078ee21dULL, 0x0000000851517824ULL, 0x000fe200078e00ffULL,
0x0000e0001e1e7811ULL, 0x000fc400078e20ffULL, 0x0000a0001d477811ULL, 0x000fe400078e20ffULL,
0xfffffff0501f7812ULL, 0x000fe200078ee253ULL, 0x000000001e4c783bULL, 0x000e660000004200ULL,
0x0000e0001f1f7811ULL, 0x000fe200078e20ffULL, 0x000000004744783bULL, 0x000ea80000000200ULL,
0x000000001f48783bULL, 0x000f220000004200ULL, 0x000031204c4c7816ULL, 0x002fc400000000ffULL,
0x000031204d4d7816ULL, 0x000fe200000000ffULL, 0x000000154444a232ULL, 0x08cfe20000000000ULL,
0x0000004cff3c723eULL, 0x000fe200020006ffULL, 0x000000154646a232ULL, 0x000fe20000000000ULL,
0x0000004dff3d723eULL, 0x000fe200020006ffULL, 0x000000144545a232ULL, 0x080fe20000000000ULL,
0x000031204e4e7816ULL, 0x000fe200000000ffULL, 0x000000144747a232ULL, 0x000fe20000000000ULL,
0x000031204f4f7816ULL, 0x000fe400000000ffULL, 0x0000004eff42723eULL, 0x000fc400020006ffULL,
0x0000004fff43723eULL, 0x000fe400020006ffULL, 0x0000003c4434723cULL, 0x040b620000001834ULL,
0x0000004cff4c723eULL, 0x000fe400030006ffULL, 0x0000004dff4d723eULL, 0x000fe400030006ffULL,
0x0000312048487816ULL, 0x010fe400000000ffULL, 0x00000006403c7810ULL, 0x020fe40007ffe0ffULL,
0x0000312049497816ULL, 0x000fe200000000ffULL, 0x0000004c4438723cULL, 0x000b620000001838ULL,
0xfffffff8513c7812ULL, 0x000fc400078ee23cULL, 0x0000e000523d7811ULL, 0x000fe400078e20ffULL,
0x0000004eff4e723eULL, 0x000fe400030006ffULL, 0x0000004fff4f723eULL, 0x000fe200030006ffULL,
0x000000424450723cULL, 0x040be40000001830ULL, 0x0000a0003c4c7811ULL, 0x020fe200078e20ffULL,
0x000000003d54783bULL, 0x000e680000004200ULL, 0x00000048ff30723eULL, 0x080fe200020006ffULL,
0x0000004e4424723cULL, 0x000b620000001824ULL, 0x00000049ff31723eULL, 0x000fe200020006ffULL,
0x000000004c4c783bULL, 0x020ea20000000200ULL, 0x00000048ff48723eULL, 0x000fc400030006ffULL,
0x00000049ff49723eULL, 0x000fc600030006ffULL, 0x000000304404723cULL, 0x040b6e0000001804ULL,
0x000031204a307816ULL, 0x020fe400000000ffULL, 0x000031204b317816ULL, 0x000fe400000000ffULL,
0x00000030ff58723eULL, 0x000fe200020006ffULL, 0x000000484448723cULL, 0x000f620000001828ULL,
0x00000031ff59723eULL, 0x000fc400020006ffULL, 0x00000030ff30723eULL, 0x000fe400030006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000584458723cULL, 0x000b64000000182cULL,
0x000000003e2c783bULL, 0x020ee20000004200ULL, 0x0000312054547816ULL, 0x002fe400000000ffULL,
0x0000312055557816ULL, 0x000fc600000000ffULL, 0x000000304444723cULL, 0x000b620000001820ULL,
0x0000312057297816ULL, 0x000fe400000000ffULL, 0x0000312056567816ULL, 0x000fe200000000ffULL,
0x000000154c4ca232ULL, 0x004fc60000000000ULL, 0x00000054ff30723eULL, 0x020fe200020006ffULL,
0x000000154e4ea232ULL, 0x000fe20000000000ULL, 0x00000055ff31723eULL, 0x080fe200020006ffULL,
0x000000144d4da232ULL, 0x080fe20000000000ULL, 0x00000056ff28723eULL, 0x000fe200030006ffULL,
0x000000144f4fa232ULL, 0x000fe20000000000ULL, 0x00000054ff54723eULL, 0x000fe400030006ffULL,
0x00000055ff55723eULL, 0x000fc800030006ffULL, 0x000000304c30723cULL, 0x040b6e0000001834ULL,
0x00000029ff35723eULL, 0x0a0fe200020006ffULL, 0x000000544c38723cULL, 0x000f620000001838ULL,
0x00000029ff29723eULL, 0x000fe400030006ffULL, 0x00000056ff34723eULL, 0x000fc400020006ffULL,
0x000031202c2c7816ULL, 0x008fe400000000ffULL, 0x000031202d2d7816ULL, 0x000fe200000000ffULL,
0x000000284c28723cULL, 0x040b6e0000001824ULL, 0x0000002cff24723eULL, 0x020fe200020006ffULL,
0x000000344c34723cULL, 0x000f620000001850ULL, 0x0000002dff25723eULL, 0x000fc400020006ffULL,
0x0000002cff2c723eULL, 0x000fe400030006ffULL, 0x0000002dff2d723eULL, 0x000fc600030006ffULL,
0x000000244c24723cULL, 0x040b6e0000001804ULL, 0x000031202e047816ULL, 0x020fe400000000ffULL,
0x000031202f057816ULL, 0x000fe400000000ffULL, 0x00000004ff20723eULL, 0x000fe200020006ffULL,
0x0000002c4c2c723cULL, 0x000b620000001848ULL, 0x00000005ff21723eULL, 0x000fc400020006ffULL,
0x00000004ff04723eULL, 0x000fe400030006ffULL, 0x00000005ff05723eULL, 0x000fc600030006ffULL,
0x000000204c20723cULL, 0x040b700000001858ULL, 0x000000044c04723cULL, 0x000b620000001844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff427f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000200c407810ULL, 0x000fe20007ffe0ffULL, 0x01068800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x022fc400078e0043ULL, 0x000000034000720cULL, 0x000fe20003f06070ULL,
0x000000ffff407224ULL, 0x000fd800078e0041ULL, 0x000086d000000947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x0106bc00ff457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442477210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff407819ULL, 0x000fc80000011445ULL, 0x0000004740407211ULL, 0x000fca00078110ffULL,
0x000000ffff457224ULL, 0x000fca00000e0645ULL, 0x0000000240407819ULL, 0x000fc80000001245ULL,
0x000000400000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff457984ULL, 0x000e640000000800ULL, 0x8000000045ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000400c437810ULL, 0x000fca0007ffe0ffULL,
0x000062000a477a24ULL, 0x000fe200078e0243ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000002164c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000109427824ULL, 0x000fe200078e0216ULL,
0x0000000416507810ULL, 0x000fe40007ffe0ffULL, 0x0000004303407217ULL, 0x000fe20007800000ULL,
0x0000000109457824ULL, 0x040fe200078e024cULL, 0x000000f00e4f7812ULL, 0x000fe200078ec0ffULL,
0x0000000109487824ULL, 0x000fe400078e0250ULL, 0x0000000145467824ULL, 0x000fc400078e0202ULL,
0x00000010454d7824ULL, 0x000fe400078e00ffULL, 0x0000000142447824ULL, 0x040fe400078e0202ULL,
0x00000010424b7824ULL, 0x000fe200078e00ffULL, 0xfffffff04d4e7812ULL, 0x000fe200078ee246ULL,
0x0000000148497824ULL, 0x040fe400078e0202ULL, 0x0000001048527824ULL, 0x000fe200078e00ffULL,
0xfffffff04b4a7812ULL, 0x000fe200078ee244ULL, 0x0000000140407824ULL, 0x000fc400078e0a43ULL,
0x00000100ff4d7424ULL, 0x000fe200078e00ffULL, 0xfffffff052517812ULL, 0x000fe200078ee249ULL,
0x0000000142427824ULL, 0x100fe200078e0247ULL, 0x0000000616527810ULL, 0x000fe20007ffe0ffULL,
0x0000000145447824ULL, 0x000fe200078e0247ULL, 0x0000004009407217ULL, 0x000fe20007800000ULL,
0x00005e0042427625ULL, 0x000fe200078e004dULL, 0x0000e00051517811ULL, 0x000fc600078e20ffULL,
0x00005e0044447625ULL, 0x000fc800078e004dULL, 0x0000000109497824ULL, 0x000fe200078e0252ULL,
0x0000004f44447210ULL, 0x080fe20007f9e0ffULL, 0x0000000148467824ULL, 0x000fe200078e0247ULL,
0x0000004f42487210ULL, 0x000fe20007f1e0ffULL, 0x00000001404b7824ULL, 0x000fe400078e0a09ULL,
0x0000000149477824ULL, 0x040fe400078e0247ULL, 0x0000000149537824ULL, 0x040fe200078e0202ULL,
0x0000004b1600720cULL, 0x080fe20003f66070ULL, 0x0000001049547824ULL, 0x000fe200078e00ffULL,
0x0000004b4c00720cULL, 0x080fe20003f46070ULL, 0x000000ffff497224ULL, 0x000fe200000e0643ULL,
0x0000004b5000720cULL, 0x000fe20003f06070ULL, 0x00005e0046427625ULL, 0x000fe200078e004dULL,
0xfffffff054537812ULL, 0x000fc600078ee253ULL, 0x00005e0047467625ULL, 0x000fe200078e004dULL,
0x0000004f42427210ULL, 0x000fe40007fbe0ffULL, 0x0000e0004e4d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200020e0645ULL, 0x0000004b5200720cULL, 0x000fe20003f86070ULL,
0x000000ffff437224ULL, 0x000fe200028e0643ULL, 0x0000004f46467210ULL, 0x000fe40007fde0ffULL,
0x0000e0004a4b7811ULL, 0x000fe400078e20ffULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fc400030e0647ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000484b7faeULL, 0x0003e8000d901c46ULL, 0x00000000444d7faeULL, 0x0003e8000d101c46ULL,
0x0000000042517faeULL, 0x0003e8000c101c46ULL, 0x0000000046537faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000109407824ULL, 0x000fc800078e0216ULL,
0x0000000140427824ULL, 0x140fe200078e0202ULL, 0x0000000240437810ULL, 0x040fe20007ffe0ffULL,
0x0000001040497824ULL, 0x040fe200078e00ffULL, 0x0000000440457810ULL, 0x040fe20007ffe0ffULL,
0x0000000140487824ULL, 0x040fe200078e0247ULL, 0x0000000640407810ULL, 0x000fe20007ffe0ffULL,
0x0000000143447824ULL, 0x000fe200078e0202ULL, 0xfffffff0494a7812ULL, 0x000fe200078ee242ULL,
0x00000010434b7824ULL, 0x000fe400078e00ffULL, 0x0000000145467824ULL, 0x040fe200078e0202ULL,
0x0000e0004a517811ULL, 0x000fe200078e20ffULL, 0x00000010454d7824ULL, 0x000fe200078e00ffULL,
0xfffffff04b4c7812ULL, 0x000fe200078ee244ULL, 0x00000100ff4b7424ULL, 0x000fc400078e00ffULL,
0x0000000143427824ULL, 0x000fe200078e0247ULL, 0xfffffff04d4e7812ULL, 0x000fe200078ee246ULL,
0x00005e0048487625ULL, 0x000fe200078e004bULL, 0x000000f00e4d7812ULL, 0x000fc600078ec0ffULL,
0x0000000145447824ULL, 0x100fe200078e0247ULL, 0x0000004d48487210ULL, 0x000fe20007f5e0ffULL,
0x0000000140467824ULL, 0x000fe400078e0247ULL, 0x00005e0042427625ULL, 0x000fc800078e004bULL,
0x00005e0044447625ULL, 0x000fe200078e004bULL, 0x0000004d42427210ULL, 0x000fc60007f1e0ffULL,
0x00000001404f7824ULL, 0x000fe400078e0202ULL, 0x00005e0046467625ULL, 0x000fe200078e004bULL,
0x0000e0004c4b7811ULL, 0x000fc600078e20ffULL, 0x0000001040407824ULL, 0x000fe200078e00ffULL,
0x0000004d46467210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff497224ULL, 0x000fe200010e0649ULL,
0x0000004d44447210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0643ULL,
0xfffffff0404f7812ULL, 0x000fe200078ee24fULL, 0x000000ffff477224ULL, 0x000fe200018e0647ULL,
0x0000e0004e4d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200010e0645ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048517faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e8000b901c46ULL,
0x00000000444d7faeULL, 0x0003e8000b901c46ULL, 0x00000000464f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff447f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280009487f8cULL, 0x0004e4000c80043fULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x01062c0009477984ULL, 0x000f240000000800ULL, 0x8000000047ff7812ULL, 0x018fc40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x00000046424b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e43ULL, 0x003d09004b00780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404b00780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff407819ULL, 0x000fc80000011447ULL,
0x0000004b40407211ULL, 0x000fca00078110ffULL, 0x000000ffff477224ULL, 0x000fca00000e0647ULL,
0x0000000240407819ULL, 0x000fc80000001247ULL, 0x000000400000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01062c0009477984ULL, 0x000ee40000000800ULL,
0x8000000047ff7812ULL, 0x008fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010080000f467984ULL, 0x000ee80000000800ULL, 0x010280000f487984ULL, 0x0004620000000800ULL,
0x000000414600720bULL, 0x008fe20003f1d000ULL, 0x0000cb427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000477806ULL, 0x004fc800000e0100ULL, 0x0000ffff47ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff497424ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fd200078e0041ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe40003f05270ULL, 0x000000414600720bULL, 0x000fe20003f54000ULL,
0x0000cb027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000407806ULL, 0x000fc400010e0100ULL,
0x0000004146428209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991040437816ULL, 0x000fc600000000ffULL, 0x010480420f008388ULL, 0x0005e20000000800ULL,
0x000000ff4300720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004146427209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff40ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004142427221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x00000042004c7308ULL, 0x000ea40000000800ULL,
0x0000004c0b0b7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff4a7819ULL, 0x000fe20000011602ULL, 0x0000ca427f007947ULL, 0x000fea000b800000ULL,
0x00001f4a4c427589ULL, 0x0004e400000e0000ULL, 0x0000004230307220ULL, 0x088fe20000410000ULL,
0x0000004231317220ULL, 0x080fe20000410000ULL, 0x0000004238387220ULL, 0x080fe20000410000ULL,
0x0000004239397220ULL, 0x080fe20000410000ULL, 0x0000004234347220ULL, 0x080fe20000410000ULL,
0x0000004235357220ULL, 0x080fe20000410000ULL, 0x0000004228287220ULL, 0x080fe20000410000ULL,
0x0000004229297220ULL, 0x080fe20000410000ULL, 0x0000004224247220ULL, 0x080fe20000410000ULL,
0x0000004225257220ULL, 0x080fe20000410000ULL, 0x000000422c2c7220ULL, 0x080fe20000410000ULL,
0x000000422d2d7220ULL, 0x080fe20000410000ULL, 0x0000004220207220ULL, 0x080fe20000410000ULL,
0x0000004221217220ULL, 0x080fe20000410000ULL, 0x0000004204047220ULL, 0x080fe20000410000ULL,
0x0000004205057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0040ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008024a7811ULL, 0x006fe200078ff0ffULL, 0x0000c9327f007947ULL, 0x000fea000b800000ULL,
0x00001f4a4c427589ULL, 0x0002a400000e0000ULL, 0x0000004232327220ULL, 0x084fe20000410000ULL,
0x0000004233337220ULL, 0x080fe20000410000ULL, 0x000000423a3a7220ULL, 0x080fe20000410000ULL,
0x000000423b3b7220ULL, 0x080fe20000410000ULL, 0x0000004236367220ULL, 0x080fe20000410000ULL,
0x0000004237377220ULL, 0x080fe20000410000ULL, 0x000000422a2a7220ULL, 0x080fe20000410000ULL,
0x000000422b2b7220ULL, 0x080fe20000410000ULL, 0x0000004226267220ULL, 0x080fe20000410000ULL,
0x0000004227277220ULL, 0x080fe20000410000ULL, 0x000000422e2e7220ULL, 0x080fe20000410000ULL,
0x000000422f2f7220ULL, 0x080fe20000410000ULL, 0x0000004222227220ULL, 0x080fe20000410000ULL,
0x0000004223237220ULL, 0x080fe20000410000ULL, 0x0000004206067220ULL, 0x080fe20000410000ULL,
0x0000004207077220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff40ff7812ULL, 0x000fe20007800847ULL, 0x00000001ff497424ULL, 0x000fe200078e00ffULL,
0x0000004146407209ULL, 0x000fd60007810000ULL, 0x8000004046460221ULL, 0x000fe20000010000ULL,
0x00007610ff490816ULL, 0x000fc60000000049ULL, 0x3fb8aa3b46460820ULL, 0x000fc80000410000ULL,
0x0000004600130308ULL, 0x000ea40000000800ULL, 0x0000001348480220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b480b7221ULL, 0x002fc20000010000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004642467210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e43ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011447ULL, 0x0000004641417211ULL, 0x000fca00078110ffULL,
0x000000ffff467224ULL, 0x000fca00000e0647ULL, 0x0000000241417819ULL, 0x000fc80000001246ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910493f7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff3f00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000013ff14723eULL, 0x000fe400000000ffULL,
0x00000002ff467819ULL, 0x000fe40000011602ULL, 0x00005410143f7816ULL, 0x000fe20000000014ULL,
0x0000c5127f007947ULL, 0x000fea000b800000ULL, 0x00001f463f157589ULL, 0x0002a400000e0000ULL,
0x00000008464a7810ULL, 0x002fe20007ffe0ffULL, 0x0000c5427f007947ULL, 0x000fea000b800000ULL,
0x00001f4a3f147589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010464a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e003fULL,
0x0000546000427802ULL, 0x000fc40000000f00ULL, 0x0000cfd000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018464a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x004fe200078e003fULL, 0x000054b000427802ULL, 0x000fc40000000f00ULL,
0x0000cf8000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000a800173f7811ULL, 0x002fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000184c783bULL, 0x000e680000004200ULL, 0x000000003f48783bULL, 0x004ea80000000200ULL,
0x000000001950783bULL, 0x000f280000004200ULL, 0x000000001b54783bULL, 0x000ee80000004200ULL,
0x000000001c5c783bULL, 0x000ee20000004200ULL, 0x000031204c4c7816ULL, 0x002fc400000000ffULL,
0x000031204d4d7816ULL, 0x000fe200000000ffULL, 0x000000154848a232ULL, 0x084fe20000000000ULL,
0x0000004cff42723eULL, 0x080fe200020006ffULL, 0x000000154a4aa232ULL, 0x000fe20000000000ULL,
0x0000004dff43723eULL, 0x080fe200020006ffULL, 0x000000144949a232ULL, 0x088fe20000000000ULL,
0x0000004cff4c723eULL, 0x000fe200030006ffULL, 0x000000144b4ba232ULL, 0x000fe20000000000ULL,
0x0000004dff4d723eULL, 0x000fe400030006ffULL, 0x000031204e4e7816ULL, 0x000fc400000000ffULL,
0x000031204f4f7816ULL, 0x000fe400000000ffULL, 0x000000424830723cULL, 0x040be20000001830ULL,
0x0000312050507816ULL, 0x010fe400000000ffULL, 0x0000312051517816ULL, 0x000fe400000000ffULL,
0x00000050ff58723eULL, 0x000fe400020006ffULL, 0x0000004eff42723eULL, 0x020fe200020006ffULL,
0x0000004c4838723cULL, 0x000be20000001838ULL, 0x0000004fff43723eULL, 0x000fc400020006ffULL,
0x00000051ff59723eULL, 0x080fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400030006ffULL,
0x0000a8001a4c7811ULL, 0x020fe200078e20ffULL, 0x000000424834723cULL, 0x000b620000001834ULL,
0x00000051ff51723eULL, 0x000fe400030006ffULL, 0x0000312056567816ULL, 0x000fe400000000ffULL,
0x0000312057577816ULL, 0x000fc400000000ffULL, 0x0000004eff42723eULL, 0x020fe200030006ffULL,
0x000000584858723cULL, 0x040be20000001824ULL, 0x0000004fff43723eULL, 0x000fe400030006ffULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x0000312054547816ULL, 0x000fe400000000ffULL,
0x0000312055557816ULL, 0x000fe400000000ffULL, 0x0000312052247816ULL, 0x020fe200000000ffULL,
0x00000050482c723cULL, 0x000be2000000182cULL, 0x0000312053257816ULL, 0x000fc400000000ffULL,
0x000031205c5c7816ULL, 0x000fe400000000ffULL, 0x000031205d5d7816ULL, 0x000fe400000000ffULL,
0x00000024ff50723eULL, 0x0a0fe200020006ffULL, 0x000000424828723cULL, 0x000f620000001828ULL,
0x00000025ff51723eULL, 0x080fe400020006ffULL, 0x00000024ff24723eULL, 0x000fe400030006ffULL,
0x00000025ff25723eULL, 0x000fc400030006ffULL, 0x000031205e5e7816ULL, 0x000fe200000000ffULL,
0x000000504850723cULL, 0x040b6e0000001820ULL, 0x0000005cff20723eULL, 0x020fe200020006ffULL,
0x000000244848723cULL, 0x000b620000001804ULL, 0x0000005dff21723eULL, 0x000fcc00020006ffULL,
0x00000056ff04723eULL, 0x020fe400020006ffULL, 0x00000057ff05723eULL, 0x000fe200020006ffULL,
0x000000154c4ca232ULL, 0x082fe20000000000ULL, 0x00000054ff24723eULL, 0x080fe200020006ffULL,
0x000000154e4ea232ULL, 0x000fe20000000000ULL, 0x00000055ff25723eULL, 0x080fe200020006ffULL,
0x000000144d4da232ULL, 0x080fe20000000000ULL, 0x00000054ff54723eULL, 0x000fe200030006ffULL,
0x000000144f4fa232ULL, 0x000fe20000000000ULL, 0x00000055ff55723eULL, 0x000fcc00030006ffULL,
0x000000044c34723cULL, 0x040b6e0000001834ULL, 0x00000056ff04723eULL, 0x020fe200030006ffULL,
0x000000244c24723cULL, 0x000b620000001830ULL, 0x00000057ff05723eULL, 0x000fcc00030006ffULL,
0x000031205f317816ULL, 0x020fe200000000ffULL, 0x000000044c04723cULL, 0x000b620000001828ULL,
0x0000005eff30723eULL, 0x000fcc00030006ffULL, 0x0000005cff28723eULL, 0x020fe200030006ffULL,
0x000000544c38723cULL, 0x000f620000001838ULL, 0x0000005dff29723eULL, 0x000fce00030006ffULL,
0x000000284c28723cULL, 0x040b6e000000182cULL, 0x00000031ff2d723eULL, 0x0a0fe200020006ffULL,
0x000000204c20723cULL, 0x000b620000001858ULL, 0x0000005eff2c723eULL, 0x000fe400020006ffULL,
0x00000031ff31723eULL, 0x000fca00030006ffULL, 0x0000002c4c2c723cULL, 0x040b700000001850ULL,
0x000000304c30723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff487f8cULL, 0x020e64000c80043fULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x0106bc00ff3f7984ULL, 0x000ea40000000800ULL,
0x800000003fff7812ULL, 0x006fc40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004642467210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e43ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3f7819ULL, 0x000fc80000011447ULL, 0x000000463f3f7211ULL, 0x000fca00078110ffULL,
0x000000ffff467224ULL, 0x000fca00000e0647ULL, 0x000000023f3f7819ULL, 0x000fc80000001246ULL,
0x0000003f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff3f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000600c467810ULL, 0x000fca0007ffe0ffULL,
0x000062000a487a24ULL, 0x000fe200078e0246ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x0000000109417824ULL, 0x000fe200078e0216ULL, 0x0000000416507810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff497424ULL, 0x000fe200078e00ffULL, 0x00000046033f7217ULL, 0x000fe20007800000ULL,
0x0000000141427824ULL, 0x040fe200078e0202ULL, 0x00000002164e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001041437824ULL, 0x000fe400078e00ffULL, 0x00000001094b7824ULL, 0x000fe400078e0250ULL,
0x000000013f467824ULL, 0x000fe200078e0a46ULL, 0xfffffff0434c7812ULL, 0x000fe200078ee242ULL,
0x0000000141427824ULL, 0x000fe200078e0248ULL, 0x000000f00e417812ULL, 0x000fe200078ec0ffULL,
0x00000001093f7824ULL, 0x040fe200078e024eULL, 0x0000004609467217ULL, 0x000fe20007800000ULL,
0x000000014b4a7824ULL, 0x000fc400078e0202ULL, 0x000000104b4f7824ULL, 0x000fe400078e00ffULL,
0x00005e0042427625ULL, 0x000fc600078e0049ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee24aULL,
0x000000013f477824ULL, 0x040fe200078e0202ULL, 0x00000041424a7210ULL, 0x000fe20007f1e0ffULL,
0x000000103f527824ULL, 0x000fe200078e00ffULL, 0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000013f427824ULL, 0x100fe400078e0248ULL, 0x00000001463f7824ULL, 0x000fe200078e0a09ULL,
0xfffffff0524d7812ULL, 0x000fe200078ee247ULL, 0x000000014b477824ULL, 0x000fe200078e0248ULL,
0x0000000616527810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4b7224ULL, 0x000fe200000e0643ULL,
0x0000003f4e00720cULL, 0x000fe20003f66070ULL, 0x00005e0042427625ULL, 0x000fe200078e0049ULL,
0x0000003f1600720cULL, 0x000fc40003f86070ULL, 0x0000003f5000720cULL, 0x000fe20003f06070ULL,
0x0000000109517824ULL, 0x000fe200078e0252ULL, 0x0000004142427210ULL, 0x000fe20007fbe0ffULL,
0x00005e0047467625ULL, 0x000fe200078e0049ULL, 0x0000c0004d4d7811ULL, 0x000fc600078e20ffULL,
0x0000000151487824ULL, 0x040fe200078e0248ULL, 0x0000004146467210ULL, 0x000fe20007fde0ffULL,
0x00000001514e7824ULL, 0x000fe400078e0202ULL, 0x00005e0048487625ULL, 0x000fc800078e0049ULL,
0x000000ffff437224ULL, 0x000fe200028e0643ULL, 0x0000003f5200720cULL, 0x000fe20003fa6070ULL,
0x0000001051517824ULL, 0x000fe200078e00ffULL, 0x0000c0004c3f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200030e0647ULL, 0x0000004148487210ULL, 0x000fe40007fde0ffULL,
0xfffffff0514e7812ULL, 0x000fe200078ee24eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004a3f7faeULL, 0x0003e4000e101c46ULL, 0x000000ffff497224ULL, 0x000fe200030e0649ULL,
0x0000c0004e417811ULL, 0x000fe200078e20ffULL, 0x00000000424d7faeULL, 0x0003e8000d901c46ULL,
0x00000000464f7faeULL, 0x0003e8000c101c46ULL, 0x0000000048417faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x00000001093f7824ULL, 0x000fc800078e0216ULL,
0x000000013f417824ULL, 0x040fe200078e0202ULL, 0x000000043f477810ULL, 0x040fe20007ffe0ffULL,
0x000000103f4c7824ULL, 0x040fe200078e00ffULL, 0x000000023f437810ULL, 0x040fe20007ffe0ffULL,
0x000000013f4a7824ULL, 0x040fe200078e0248ULL, 0x000000063f3f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000147467824ULL, 0x140fe200078e0202ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee241ULL,
0x0000001047497824ULL, 0x000fe200078e00ffULL, 0x000000f00e417812ULL, 0x000fe200078ec0ffULL,
0x0000000143427824ULL, 0x000fc400078e0202ULL, 0x00000010434d7824ULL, 0x000fe200078e00ffULL,
0xfffffff0494e7812ULL, 0x000fe200078ee246ULL, 0x00000100ff497424ULL, 0x000fe400078e00ffULL,
0x0000000147467824ULL, 0x000fe200078e0248ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL,
0x00005e004a4a7625ULL, 0x000fc600078e0049ULL, 0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000143427824ULL, 0x100fe200078e0248ULL, 0x000000414a4a7210ULL, 0x000fe20007f7e0ffULL,
0x000000013f487824ULL, 0x000fe400078e0248ULL, 0x00005e0042427625ULL, 0x000fc800078e0049ULL,
0x00005e0046467625ULL, 0x000fe200078e0049ULL, 0x0000004142427210ULL, 0x000fc60007f1e0ffULL,
0x00005e0048487625ULL, 0x000fc800078e0049ULL, 0x000000013f4f7824ULL, 0x040fe200078e0202ULL,
0x0000004148487210ULL, 0x080fe20007f9e0ffULL, 0x000000103f507824ULL, 0x000fe200078e00ffULL,
0x0000c0004c3f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe200018e064bULL,
0x0000004146467210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0643ULL,
0xfffffff0504f7812ULL, 0x000fe200078ee24fULL, 0x000000ffff497224ULL, 0x000fe200020e0649ULL,
0x0000c0004e417811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200018e0647ULL,
0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004a3f7faeULL, 0x0003e8000b901c46ULL, 0x00000000424d7faeULL, 0x0003e8000b901c46ULL,
0x0000000046417faeULL, 0x0003e8000b901c46ULL, 0x00000000484f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff427f8cULL, 0x000e64000c80043fULL, 0x000000ffff3f7224ULL, 0x002fc400078e0043ULL,
0x0000000000427805ULL, 0x000fca0000015200ULL, 0x0106b400ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fc40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004642467210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e43ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011447ULL, 0x0000004641417211ULL, 0x000fca00078110ffULL,
0x000000ffff467224ULL, 0x000fca00000e0647ULL, 0x0000000241417819ULL, 0x000fc80000001246ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000013ff14723eULL, 0x000fe400000000ffULL,
0x00000002ff447819ULL, 0x000fe40000011602ULL, 0x0000541014417816ULL, 0x000fe20000000014ULL,
0x0000b3627f007947ULL, 0x000fea000b800000ULL, 0x00001f4441157589ULL, 0x0002a400000e0000ULL,
0x00000008444a7810ULL, 0x002fe20007ffe0ffULL, 0x0000b3927f007947ULL, 0x000fea000b800000ULL,
0x00001f4a41147589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010444a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0041ULL,
0x000066c000427802ULL, 0x000fc40000000f00ULL, 0x0000bd7000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018444a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x004fe200078e0041ULL, 0x0000671000427802ULL, 0x000fc40000000f00ULL,
0x0000bd2000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000a8001d417811ULL, 0x002fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001e48783bULL, 0x004e680000004200ULL, 0x000000004144783bULL, 0x000ea80000000200ULL,
0x000000001f4c783bULL, 0x000f280000004200ULL, 0x000000003d50783bULL, 0x000ee20000004200ULL,
0x0000312048487816ULL, 0x002fc400000000ffULL, 0x0000312049497816ULL, 0x000fe200000000ffULL,
0x000000154444a232ULL, 0x084fe20000000000ULL, 0x00000048ff42723eULL, 0x080fe200020006ffULL,
0x000000154646a232ULL, 0x000fe20000000000ULL, 0x00000049ff43723eULL, 0x000fe200020006ffULL,
0x000000144545a232ULL, 0x088fe20000000000ULL, 0x000031204a4a7816ULL, 0x000fe200000000ffULL,
0x000000144747a232ULL, 0x000fe20000000000ULL, 0x000031204b4b7816ULL, 0x000fe400000000ffULL,
0x00000048ff48723eULL, 0x000fc400030006ffULL, 0x00000049ff49723eULL, 0x000fe400030006ffULL,
0x000000424424723cULL, 0x040b620000001824ULL, 0x000031204c4c7816ULL, 0x010fe400000000ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x000031204e417816ULL, 0x000fe400000000ffULL,
0x0000004aff42723eULL, 0x020fe200020006ffULL, 0x000000484438723cULL, 0x000b620000001838ULL,
0x0000004bff43723eULL, 0x000fc400020006ffULL, 0x00000041ff54723eULL, 0x000fe400020006ffULL,
0x0000312050507816ULL, 0x000fe400000000ffULL, 0x0000a8003c487811ULL, 0x020fe200078e20ffULL,
0x000000424434723cULL, 0x000b620000001834ULL, 0x0000312051517816ULL, 0x000fe400000000ffULL,
0x0000312052527816ULL, 0x000fc800000000ffULL, 0x0000004aff42723eULL, 0x020fe400030006ffULL,
0x0000004bff43723eULL, 0x000fe400030006ffULL, 0x000000004848783bULL, 0x000e6a0000000200ULL,
0x000000424404723cULL, 0x000b6e0000001804ULL, 0x0000004cff42723eULL, 0x020fc400020006ffULL,
0x0000004dff43723eULL, 0x080fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400030006ffULL,
0x0000004dff4d723eULL, 0x000fc600030006ffULL, 0x000000424420723cULL, 0x040b6e0000001820ULL,
0x000031204f427816ULL, 0x020fe400000000ffULL, 0x0000004c444c723cULL, 0x000b640000001828ULL,
0x00000042ff55723eULL, 0x000fca00020006ffULL, 0x00000041ff28723eULL, 0x020fe400030006ffULL,
0x000000544454723cULL, 0x040b62000000182cULL, 0x00000042ff29723eULL, 0x000fe200030006ffULL,
0x000000003e2c783bULL, 0x020ea20000004200ULL, 0x000000154848a232ULL, 0x082fe40000000000ULL,
0x000000154a4aa232ULL, 0x000fe40000000000ULL, 0x000000144949a232ULL, 0x080fe20000000000ULL,
0x000000284444723cULL, 0x000b620000001830ULL, 0x000000144b4ba232ULL, 0x000fcc0000000000ULL,
0x00000050ff30723eULL, 0x020fe400020006ffULL, 0x00000051ff31723eULL, 0x080fe400020006ffULL,
0x0000312053297816ULL, 0x000fe400000000ffULL, 0x00000052ff28723eULL, 0x000fe400030006ffULL,
0x00000050ff50723eULL, 0x000fe200030006ffULL, 0x000000304830723cULL, 0x000b620000001824ULL,
0x00000051ff51723eULL, 0x000fcc00030006ffULL, 0x00000052ff24723eULL, 0x020fe200020006ffULL,
0x000000504838723cULL, 0x000f620000001838ULL, 0x00000029ff25723eULL, 0x080fe400020006ffULL,
0x00000029ff29723eULL, 0x000fca00030006ffULL, 0x000000244834723cULL, 0x000b620000001834ULL,
0x000031202c2c7816ULL, 0x004fe400000000ffULL, 0x000031202d2d7816ULL, 0x000fc800000000ffULL,
0x0000002cff24723eULL, 0x0a0fe200020006ffULL, 0x000000284828723cULL, 0x040b620000001804ULL,
0x0000002dff25723eULL, 0x080fe400020006ffULL, 0x0000002cff2c723eULL, 0x000fe400030006ffULL,
0x0000002dff2d723eULL, 0x000fe400030006ffULL, 0x000031202e047816ULL, 0x020fe200000000ffULL,
0x000000244824723cULL, 0x000b620000001820ULL, 0x000031202f057816ULL, 0x000fcc00000000ffULL,
0x00000004ff20723eULL, 0x0a0fe200020006ffULL, 0x0000002c482c723cULL, 0x000b62000000184cULL,
0x00000005ff21723eULL, 0x080fe400020006ffULL, 0x00000004ff04723eULL, 0x000fe400030006ffULL,
0x00000005ff05723eULL, 0x000fc600030006ffULL, 0x000000204820723cULL, 0x040b700000001854ULL,
0x000000044804723cULL, 0x000b620000001844ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff427f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000600c427810ULL, 0x002fe20007ffe0ffULL,
0x01069000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff467224ULL, 0x020fc400078e0043ULL,
0x000000034200720cULL, 0x000fda0003f06070ULL, 0x000059d000000947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x0106bc00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011445ULL, 0x0000004441417211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000241417819ULL, 0x000fc80000001244ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000147477810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000800c427810ULL, 0x000fca0007ffe0ffULL,
0x000062000a477a24ULL, 0x000fe200078e0242ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x0000000416507810ULL, 0x040fe20007ffe0ffULL, 0x0000000109437824ULL, 0x000fe200078e0216ULL,
0x00000002164e7810ULL, 0x040fe40007ffe0ffULL, 0x0000004203417217ULL, 0x000fe20007800000ULL,
0x0000000109487824ULL, 0x040fe200078e0250ULL, 0x0000000616527810ULL, 0x000fe20007ffe0ffULL,
0x0000000109457824ULL, 0x000fe400078e024eULL, 0x0000000148497824ULL, 0x000fc400078e0202ULL,
0x00000010484a7824ULL, 0x000fe400078e00ffULL, 0x0000000143447824ULL, 0x040fe400078e0202ULL,
0x00000010434b7824ULL, 0x000fe200078e00ffULL, 0xfffffff04a4f7812ULL, 0x000fe200078ee249ULL,
0x0000000141427824ULL, 0x000fe400078e0a42ULL, 0x0000000145467824ULL, 0x000fe200078e0202ULL,
0xfffffff04b4c7812ULL, 0x000fe200078ee244ULL, 0x00000010454d7824ULL, 0x000fe200078e00ffULL,
0x0000004209447217ULL, 0x000fe20007800000ULL, 0x00000100ff4a7424ULL, 0x000fe200078e00ffULL,
0x000000f00e4b7812ULL, 0x000fe200078ec0ffULL, 0x0000000143437824ULL, 0x100fe200078e0247ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee246ULL, 0x0000000109417824ULL, 0x000fe200078e0252ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x0000000145457824ULL, 0x000fe200078e0247ULL,
0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL, 0x00005e0043427625ULL, 0x000fc800078e004aULL,
0x0000000148467824ULL, 0x100fe200078e0247ULL, 0x0000004b42487210ULL, 0x000fe20007f1e0ffULL,
0x0000000141477824ULL, 0x040fe400078e0247ULL, 0x0000000141497824ULL, 0x040fe400078e0202ULL,
0x0000001041547824ULL, 0x000fe400078e00ffULL, 0x0000000144417824ULL, 0x000fe400078e0a09ULL,
0x00005e0045447625ULL, 0x000fe200078e004aULL, 0xfffffff054517812ULL, 0x000fc400078ee249ULL,
0x000000411600720cULL, 0x000fe20003f66070ULL, 0x000000ffff497224ULL, 0x000fe200000e0643ULL,
0x0000004b44447210ULL, 0x000fe20007f9e0ffULL, 0x00005e0046427625ULL, 0x080fe200078e004aULL,
0x000000414e00720cULL, 0x080fe40003f46070ULL, 0x000000415000720cULL, 0x000fe20003f06070ULL,
0x00005e0047467625ULL, 0x000fe200078e004aULL, 0x0000004b42427210ULL, 0x000fe40007fbe0ffULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200020e0645ULL,
0x000000415200720cULL, 0x000fe20003f86070ULL, 0x000000ffff437224ULL, 0x000fe200028e0643ULL,
0x0000004b46467210ULL, 0x000fc40007fde0ffULL, 0x0000e0004c417811ULL, 0x000fc600078e20ffULL,
0x000000ffff477224ULL, 0x000fe400030e0647ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048417faeULL, 0x0003e8000d901c46ULL, 0x00000000444d7faeULL, 0x0003e8000d101c46ULL,
0x00000000424f7faeULL, 0x0003e8000c101c46ULL, 0x0000000046517faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000109417824ULL, 0x000fc800078e0216ULL,
0x0000000141427824ULL, 0x140fe200078e0202ULL, 0x0000000241437810ULL, 0x040fe20007ffe0ffULL,
0x0000001041497824ULL, 0x040fe200078e00ffULL, 0x0000000441457810ULL, 0x040fe20007ffe0ffULL,
0x0000000141487824ULL, 0x040fe200078e0247ULL, 0x0000000641417810ULL, 0x000fe20007ffe0ffULL,
0x0000000143447824ULL, 0x000fe200078e0202ULL, 0xfffffff0494a7812ULL, 0x000fe200078ee242ULL,
0x00000010434b7824ULL, 0x000fe400078e00ffULL, 0x0000000145467824ULL, 0x000fc400078e0202ULL,
0x00000010454d7824ULL, 0x000fe200078e00ffULL, 0xfffffff04b4c7812ULL, 0x000fe200078ee244ULL,
0x00000100ff4b7424ULL, 0x000fe400078e00ffULL, 0x0000000143427824ULL, 0x000fe200078e0247ULL,
0xfffffff04d4e7812ULL, 0x000fe200078ee246ULL, 0x00005e0048487625ULL, 0x000fe200078e004bULL,
0x000000f00e4d7812ULL, 0x000fc600078ec0ffULL, 0x0000000145447824ULL, 0x100fe200078e0247ULL,
0x0000004d48487210ULL, 0x000fe20007f5e0ffULL, 0x0000000141467824ULL, 0x000fe400078e0247ULL,
0x00005e0042427625ULL, 0x000fc800078e004bULL, 0x00005e0044447625ULL, 0x000fe200078e004bULL,
0x0000004d42427210ULL, 0x000fc60007f1e0ffULL, 0x00005e0046467625ULL, 0x000fe200078e004bULL,
0x0000e0004c4b7811ULL, 0x000fc600078e20ffULL, 0x00000001414f7824ULL, 0x040fe200078e0202ULL,
0x0000004d46467210ULL, 0x080fe20007f7e0ffULL, 0x0000001041507824ULL, 0x000fe200078e00ffULL,
0x0000e0004a417811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200010e0649ULL,
0x0000004d44447210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0643ULL,
0xfffffff0504f7812ULL, 0x000fe200078ee24fULL, 0x000000ffff477224ULL, 0x000fe200018e0647ULL,
0x0000e0004e4d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200010e0645ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048417faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e8000b901c46ULL,
0x00000000444d7faeULL, 0x0003e8000b901c46ULL, 0x00000000464f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff447f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106480009487f8cULL, 0x0004e4000c80043fULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x01064c0009417984ULL, 0x000f240000000800ULL, 0x8000000041ff7812ULL, 0x018fc40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004642467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e43ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011447ULL,
0x0000004641417211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000241417819ULL, 0x000fc80000001246ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01064c0009417984ULL, 0x000ee40000000800ULL,
0x8000000041ff7812ULL, 0x008fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010100000f417984ULL, 0x000ee80000000800ULL, 0x010300000f467984ULL, 0x0004620000000800ULL,
0x000000404100720bULL, 0x008fe20003f1d000ULL, 0x0000a0e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000477806ULL, 0x004fc800000e0100ULL, 0x0000ffff47ff7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff487424ULL, 0x000fd600078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f05270ULL,
0x000000404100720bULL, 0x000fe20003f54000ULL, 0x0000a0b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000487806ULL, 0x000fc400010e0100ULL, 0x0000004140428209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991048437816ULL, 0x000fc600000000ffULL,
0x010500420f008388ULL, 0x0005e20000000800ULL, 0x000000ff4300720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004140437209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff48ff7812ULL, 0x000fc6000780c0ffULL,
0x8000004340427221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL,
0x00000042004c7308ULL, 0x000ea40000000800ULL, 0x0000004c0b0b7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff4a7819ULL, 0x000fe20000011602ULL,
0x00009ff27f007947ULL, 0x000fea000b800000ULL, 0x00001f4a4c427589ULL, 0x0004e400000e0000ULL,
0x0000004230307220ULL, 0x088fe20000410000ULL, 0x0000004231317220ULL, 0x080fe20000410000ULL,
0x0000004238387220ULL, 0x080fe20000410000ULL, 0x0000004239397220ULL, 0x080fe20000410000ULL,
0x0000004234347220ULL, 0x080fe20000410000ULL, 0x0000004235357220ULL, 0x080fe20000410000ULL,
0x0000004228287220ULL, 0x080fe20000410000ULL, 0x0000004229297220ULL, 0x080fe20000410000ULL,
0x0000004224247220ULL, 0x080fe20000410000ULL, 0x0000004225257220ULL, 0x080fe20000410000ULL,
0x000000422c2c7220ULL, 0x080fe20000410000ULL, 0x000000422d2d7220ULL, 0x080fe20000410000ULL,
0x0000004220207220ULL, 0x080fe20000410000ULL, 0x0000004221217220ULL, 0x080fe20000410000ULL,
0x0000004204047220ULL, 0x080fe20000410000ULL, 0x0000004205057220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0048ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008024a7811ULL, 0x006fe200078ff0ffULL,
0x00009ee27f007947ULL, 0x000fea000b800000ULL, 0x00001f4a4c427589ULL, 0x0002a400000e0000ULL,
0x0000004232327220ULL, 0x084fe20000410000ULL, 0x0000004233337220ULL, 0x080fe20000410000ULL,
0x000000423a3a7220ULL, 0x080fe20000410000ULL, 0x000000423b3b7220ULL, 0x080fe20000410000ULL,
0x0000004236367220ULL, 0x080fe20000410000ULL, 0x0000004237377220ULL, 0x080fe20000410000ULL,
0x000000422a2a7220ULL, 0x080fe20000410000ULL, 0x000000422b2b7220ULL, 0x080fe20000410000ULL,
0x0000004226267220ULL, 0x080fe20000410000ULL, 0x0000004227277220ULL, 0x080fe20000410000ULL,
0x000000422e2e7220ULL, 0x080fe20000410000ULL, 0x000000422f2f7220ULL, 0x080fe20000410000ULL,
0x0000004222227220ULL, 0x080fe20000410000ULL, 0x0000004223237220ULL, 0x080fe20000410000ULL,
0x0000004206067220ULL, 0x080fe20000410000ULL, 0x0000004207077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff48ff7812ULL, 0x000fe20007800847ULL,
0x00000001ff487424ULL, 0x000fe200078e00ffULL, 0x0000004140407209ULL, 0x000fd60007810000ULL,
0x8000004041410221ULL, 0x000fe20000010000ULL, 0x00007610ff480816ULL, 0x000fc60000000048ULL,
0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL, 0x0000004100130308ULL, 0x000ea40000000800ULL,
0x0000001346460220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b460b7221ULL, 0x002fc20000010000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004642467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e43ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011447ULL,
0x0000004641417211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000241417819ULL, 0x000fc80000001246ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910483f7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff3f00720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000013ff14723eULL, 0x000fe400000000ffULL, 0x00000002ff467819ULL, 0x000fe40000011602ULL,
0x00005410143f7816ULL, 0x000fe20000000014ULL, 0x00009ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f463f157589ULL, 0x0002a400000e0000ULL, 0x00000008464a7810ULL, 0x002fe20007ffe0ffULL,
0x00009af27f007947ULL, 0x000fea000b800000ULL, 0x00001f4a3f147589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010464a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e003fULL, 0x0000815000427802ULL, 0x000fc40000000f00ULL,
0x0000a2e000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018464a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x004fe200078e003fULL,
0x000081a000427802ULL, 0x000fc40000000f00ULL, 0x0000a29000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b000173f7811ULL, 0x002fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000184c783bULL, 0x000e680000004200ULL,
0x000000003f48783bULL, 0x004ea80000000200ULL, 0x000000001950783bULL, 0x000f280000004200ULL,
0x000000001b54783bULL, 0x000ee80000004200ULL, 0x000000001c5c783bULL, 0x000ee20000004200ULL,
0x000031204c4c7816ULL, 0x002fc400000000ffULL, 0x000031204d4d7816ULL, 0x000fe200000000ffULL,
0x000000154848a232ULL, 0x084fe20000000000ULL, 0x0000004cff42723eULL, 0x080fe200020006ffULL,
0x000000154a4aa232ULL, 0x000fe20000000000ULL, 0x0000004dff43723eULL, 0x080fe200020006ffULL,
0x000000144949a232ULL, 0x088fe20000000000ULL, 0x0000004cff4c723eULL, 0x000fe200030006ffULL,
0x000000144b4ba232ULL, 0x000fe20000000000ULL, 0x0000004dff4d723eULL, 0x000fe400030006ffULL,
0x000031204e4e7816ULL, 0x000fc400000000ffULL, 0x000031204f4f7816ULL, 0x000fe400000000ffULL,
0x000000424830723cULL, 0x040be20000001830ULL, 0x0000312050507816ULL, 0x010fe400000000ffULL,
0x0000312051517816ULL, 0x000fe400000000ffULL, 0x00000050ff58723eULL, 0x000fe400020006ffULL,
0x0000004eff42723eULL, 0x020fe200020006ffULL, 0x0000004c4838723cULL, 0x000be20000001838ULL,
0x0000004fff43723eULL, 0x000fc400020006ffULL, 0x00000051ff59723eULL, 0x080fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400030006ffULL, 0x0000b0001a4c7811ULL, 0x020fe200078e20ffULL,
0x000000424834723cULL, 0x000b620000001834ULL, 0x00000051ff51723eULL, 0x000fe400030006ffULL,
0x0000312056567816ULL, 0x000fe400000000ffULL, 0x0000312057577816ULL, 0x000fc400000000ffULL,
0x0000004eff42723eULL, 0x020fe200030006ffULL, 0x000000584858723cULL, 0x040be20000001824ULL,
0x0000004fff43723eULL, 0x000fe400030006ffULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x0000312054547816ULL, 0x000fe400000000ffULL, 0x0000312055557816ULL, 0x000fe400000000ffULL,
0x0000312052247816ULL, 0x020fe200000000ffULL, 0x00000050482c723cULL, 0x000be2000000182cULL,
0x0000312053257816ULL, 0x000fc400000000ffULL, 0x000031205c5c7816ULL, 0x000fe400000000ffULL,
0x000031205d5d7816ULL, 0x000fe400000000ffULL, 0x00000024ff50723eULL, 0x0a0fe200020006ffULL,
0x000000424828723cULL, 0x000f620000001828ULL, 0x00000025ff51723eULL, 0x080fe400020006ffULL,
0x00000024ff24723eULL, 0x000fe400030006ffULL, 0x00000025ff25723eULL, 0x000fc400030006ffULL,
0x000031205e5e7816ULL, 0x000fe200000000ffULL, 0x000000504850723cULL, 0x040b6e0000001820ULL,
0x0000005cff20723eULL, 0x020fe200020006ffULL, 0x000000244848723cULL, 0x000b620000001804ULL,
0x0000005dff21723eULL, 0x000fcc00020006ffULL, 0x00000056ff04723eULL, 0x020fe400020006ffULL,
0x00000057ff05723eULL, 0x000fe200020006ffULL, 0x000000154c4ca232ULL, 0x082fe20000000000ULL,
0x00000054ff24723eULL, 0x080fe200020006ffULL, 0x000000154e4ea232ULL, 0x000fe20000000000ULL,
0x00000055ff25723eULL, 0x080fe200020006ffULL, 0x000000144d4da232ULL, 0x080fe20000000000ULL,
0x00000054ff54723eULL, 0x000fe200030006ffULL, 0x000000144f4fa232ULL, 0x000fe20000000000ULL,
0x00000055ff55723eULL, 0x000fcc00030006ffULL, 0x000000044c34723cULL, 0x040b6e0000001834ULL,
0x00000056ff04723eULL, 0x020fe200030006ffULL, 0x000000244c24723cULL, 0x000b620000001830ULL,
0x00000057ff05723eULL, 0x000fcc00030006ffULL, 0x000031205f317816ULL, 0x020fe200000000ffULL,
0x000000044c04723cULL, 0x000b620000001828ULL, 0x0000005eff30723eULL, 0x000fcc00030006ffULL,
0x0000005cff28723eULL, 0x020fe200030006ffULL, 0x000000544c38723cULL, 0x000f620000001838ULL,
0x0000005dff29723eULL, 0x000fce00030006ffULL, 0x000000284c28723cULL, 0x040b6e000000182cULL,
0x00000031ff2d723eULL, 0x0a0fe200020006ffULL, 0x000000204c20723cULL, 0x000b620000001858ULL,
0x0000005eff2c723eULL, 0x000fe400020006ffULL, 0x00000031ff31723eULL, 0x000fca00030006ffULL,
0x0000002c4c2c723cULL, 0x040b700000001850ULL, 0x000000304c30723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff487f8cULL, 0x020e64000c80043fULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x0106bc00ff3f7984ULL, 0x000ea40000000800ULL, 0x800000003fff7812ULL, 0x006fc40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004642467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e43ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3f7819ULL, 0x000fc80000011447ULL,
0x000000463f3f7211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x000000023f3f7819ULL, 0x000fc80000001246ULL, 0x0000003f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000141417810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff3f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000a00c467810ULL, 0x000fca0007ffe0ffULL, 0x000062000a487a24ULL, 0x000fe200078e0246ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x0000000109417824ULL, 0x000fe200078e0216ULL,
0x0000000416507810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff497424ULL, 0x000fe200078e00ffULL,
0x00000046033f7217ULL, 0x000fe20007800000ULL, 0x0000000141427824ULL, 0x040fe200078e0202ULL,
0x00000002164e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001041437824ULL, 0x000fe400078e00ffULL,
0x00000001094b7824ULL, 0x000fe400078e0250ULL, 0x000000013f467824ULL, 0x000fe200078e0a46ULL,
0xfffffff0434c7812ULL, 0x000fe200078ee242ULL, 0x0000000141427824ULL, 0x000fe200078e0248ULL,
0x000000f00e417812ULL, 0x000fe200078ec0ffULL, 0x00000001093f7824ULL, 0x040fe200078e024eULL,
0x0000004609467217ULL, 0x000fe20007800000ULL, 0x000000014b4a7824ULL, 0x000fc400078e0202ULL,
0x000000104b4f7824ULL, 0x000fe400078e00ffULL, 0x00005e0042427625ULL, 0x000fc600078e0049ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee24aULL, 0x000000013f477824ULL, 0x040fe200078e0202ULL,
0x00000041424a7210ULL, 0x000fe20007f1e0ffULL, 0x000000103f527824ULL, 0x000fe200078e00ffULL,
0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL, 0x000000013f427824ULL, 0x100fe400078e0248ULL,
0x00000001463f7824ULL, 0x000fe200078e0a09ULL, 0xfffffff0524d7812ULL, 0x000fe200078ee247ULL,
0x000000014b477824ULL, 0x000fe200078e0248ULL, 0x0000000616527810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4b7224ULL, 0x000fe200000e0643ULL, 0x0000003f4e00720cULL, 0x000fe20003f66070ULL,
0x00005e0042427625ULL, 0x000fe200078e0049ULL, 0x0000003f1600720cULL, 0x000fc40003f86070ULL,
0x0000003f5000720cULL, 0x000fe20003f06070ULL, 0x0000000109517824ULL, 0x000fe200078e0252ULL,
0x0000004142427210ULL, 0x000fe20007fbe0ffULL, 0x00005e0047467625ULL, 0x000fe200078e0049ULL,
0x0000c0004d4d7811ULL, 0x000fc600078e20ffULL, 0x0000000151487824ULL, 0x040fe200078e0248ULL,
0x0000004146467210ULL, 0x000fe20007fde0ffULL, 0x00000001514e7824ULL, 0x000fe400078e0202ULL,
0x00005e0048487625ULL, 0x000fc800078e0049ULL, 0x000000ffff437224ULL, 0x000fe200028e0643ULL,
0x0000003f5200720cULL, 0x000fe20003fa6070ULL, 0x0000001051517824ULL, 0x000fe200078e00ffULL,
0x0000c0004c3f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200030e0647ULL,
0x0000004148487210ULL, 0x000fe40007fde0ffULL, 0xfffffff0514e7812ULL, 0x000fe200078ee24eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004a3f7faeULL, 0x0003e4000e101c46ULL,
0x000000ffff497224ULL, 0x000fe200030e0649ULL, 0x0000c0004e417811ULL, 0x000fe200078e20ffULL,
0x00000000424d7faeULL, 0x0003e8000d901c46ULL, 0x00000000464f7faeULL, 0x0003e8000c101c46ULL,
0x0000000048417faeULL, 0x0003e2000e901c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x00000001093f7824ULL, 0x000fc800078e0216ULL, 0x000000013f417824ULL, 0x040fe200078e0202ULL,
0x000000043f477810ULL, 0x040fe20007ffe0ffULL, 0x000000103f4c7824ULL, 0x040fe200078e00ffULL,
0x000000023f437810ULL, 0x040fe20007ffe0ffULL, 0x000000013f4a7824ULL, 0x040fe200078e0248ULL,
0x000000063f3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000147467824ULL, 0x140fe200078e0202ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee241ULL, 0x0000001047497824ULL, 0x000fe200078e00ffULL,
0x000000f00e417812ULL, 0x000fe200078ec0ffULL, 0x0000000143427824ULL, 0x000fc400078e0202ULL,
0x00000010434d7824ULL, 0x000fe200078e00ffULL, 0xfffffff0494e7812ULL, 0x000fe200078ee246ULL,
0x00000100ff497424ULL, 0x000fe400078e00ffULL, 0x0000000147467824ULL, 0x000fe200078e0248ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL, 0x00005e004a4a7625ULL, 0x000fc600078e0049ULL,
0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL, 0x0000000143427824ULL, 0x100fe200078e0248ULL,
0x000000414a4a7210ULL, 0x000fe20007f7e0ffULL, 0x000000013f487824ULL, 0x000fe400078e0248ULL,
0x00005e0042427625ULL, 0x000fc800078e0049ULL, 0x00005e0046467625ULL, 0x000fe200078e0049ULL,
0x0000004142427210ULL, 0x000fc60007f1e0ffULL, 0x00005e0048487625ULL, 0x000fc800078e0049ULL,
0x000000013f4f7824ULL, 0x040fe200078e0202ULL, 0x0000004148487210ULL, 0x080fe20007f9e0ffULL,
0x000000103f507824ULL, 0x000fe200078e00ffULL, 0x0000c0004c3f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e064bULL, 0x0000004146467210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e0643ULL, 0xfffffff0504f7812ULL, 0x000fe200078ee24fULL,
0x000000ffff497224ULL, 0x000fe200020e0649ULL, 0x0000c0004e417811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200018e0647ULL, 0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004a3f7faeULL, 0x0003e8000b901c46ULL,
0x00000000424d7faeULL, 0x0003e8000b901c46ULL, 0x0000000046417faeULL, 0x0003e8000b901c46ULL,
0x00000000484f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff427f8cULL, 0x000e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0043ULL, 0x0000000000427805ULL, 0x000fca0000015200ULL,
0x0106b400ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004642467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e43ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011447ULL,
0x0000004641417211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000241417819ULL, 0x000fc80000001246ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000013ff14723eULL, 0x000fe400000000ffULL, 0x00000002ff447819ULL, 0x000fe40000011602ULL,
0x0000541014417816ULL, 0x000fe20000000014ULL, 0x000089127f007947ULL, 0x000fea000b800000ULL,
0x00001f4441157589ULL, 0x0002a400000e0000ULL, 0x00000008444a7810ULL, 0x002fe20007ffe0ffULL,
0x000089427f007947ULL, 0x000fea000b800000ULL, 0x00001f4a41147589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010444a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0041ULL, 0x000093b000427802ULL, 0x000fc40000000f00ULL,
0x0000908000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018444a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x004fe200078e0041ULL,
0x0000940000427802ULL, 0x000fc40000000f00ULL, 0x0000903000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b0001d417811ULL, 0x002fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001e48783bULL, 0x004e680000004200ULL,
0x000000004144783bULL, 0x000ea80000000200ULL, 0x000000001f4c783bULL, 0x000f280000004200ULL,
0x000000003d50783bULL, 0x000ee20000004200ULL, 0x0000312048487816ULL, 0x002fc400000000ffULL,
0x0000312049497816ULL, 0x000fe200000000ffULL, 0x000000154444a232ULL, 0x084fe20000000000ULL,
0x00000048ff42723eULL, 0x080fe200020006ffULL, 0x000000154646a232ULL, 0x000fe20000000000ULL,
0x00000049ff43723eULL, 0x000fe200020006ffULL, 0x000000144545a232ULL, 0x088fe20000000000ULL,
0x000031204a4a7816ULL, 0x000fe200000000ffULL, 0x000000144747a232ULL, 0x000fe20000000000ULL,
0x000031204b4b7816ULL, 0x000fe400000000ffULL, 0x00000048ff48723eULL, 0x000fc400030006ffULL,
0x00000049ff49723eULL, 0x000fe400030006ffULL, 0x000000424424723cULL, 0x040b620000001824ULL,
0x000031204c4c7816ULL, 0x010fe400000000ffULL, 0x000031204d4d7816ULL, 0x000fe400000000ffULL,
0x000031204e417816ULL, 0x000fe400000000ffULL, 0x0000004aff42723eULL, 0x020fe200020006ffULL,
0x000000484438723cULL, 0x000b620000001838ULL, 0x0000004bff43723eULL, 0x000fc400020006ffULL,
0x00000041ff54723eULL, 0x000fe400020006ffULL, 0x0000312050507816ULL, 0x000fe400000000ffULL,
0x0000b0003c487811ULL, 0x020fe200078e20ffULL, 0x000000424434723cULL, 0x000b620000001834ULL,
0x0000312051517816ULL, 0x000fe400000000ffULL, 0x0000312052527816ULL, 0x000fc800000000ffULL,
0x0000004aff42723eULL, 0x020fe400030006ffULL, 0x0000004bff43723eULL, 0x000fe400030006ffULL,
0x000000004848783bULL, 0x000e6a0000000200ULL, 0x000000424404723cULL, 0x000b6e0000001804ULL,
0x0000004cff42723eULL, 0x020fc400020006ffULL, 0x0000004dff43723eULL, 0x080fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400030006ffULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x000000424420723cULL, 0x040b6e0000001820ULL, 0x000031204f427816ULL, 0x020fe400000000ffULL,
0x0000004c444c723cULL, 0x000b640000001828ULL, 0x00000042ff55723eULL, 0x000fca00020006ffULL,
0x00000041ff28723eULL, 0x020fe400030006ffULL, 0x000000544454723cULL, 0x040b62000000182cULL,
0x00000042ff29723eULL, 0x000fe200030006ffULL, 0x000000003e2c783bULL, 0x020ea20000004200ULL,
0x000000154848a232ULL, 0x082fe40000000000ULL, 0x000000154a4aa232ULL, 0x000fe40000000000ULL,
0x000000144949a232ULL, 0x080fe20000000000ULL, 0x000000284444723cULL, 0x000b620000001830ULL,
0x000000144b4ba232ULL, 0x000fcc0000000000ULL, 0x00000050ff30723eULL, 0x020fe400020006ffULL,
0x00000051ff31723eULL, 0x080fe400020006ffULL, 0x0000312053297816ULL, 0x000fe400000000ffULL,
0x00000052ff28723eULL, 0x000fe400030006ffULL, 0x00000050ff50723eULL, 0x000fe200030006ffULL,
0x000000304830723cULL, 0x000b620000001824ULL, 0x00000051ff51723eULL, 0x000fcc00030006ffULL,
0x00000052ff24723eULL, 0x020fe200020006ffULL, 0x000000504838723cULL, 0x000f620000001838ULL,
0x00000029ff25723eULL, 0x080fe400020006ffULL, 0x00000029ff29723eULL, 0x000fca00030006ffULL,
0x000000244834723cULL, 0x000b620000001834ULL, 0x000031202c2c7816ULL, 0x004fe400000000ffULL,
0x000031202d2d7816ULL, 0x000fc800000000ffULL, 0x0000002cff24723eULL, 0x0a0fe200020006ffULL,
0x000000284828723cULL, 0x040b620000001804ULL, 0x0000002dff25723eULL, 0x080fe400020006ffULL,
0x0000002cff2c723eULL, 0x000fe400030006ffULL, 0x0000002dff2d723eULL, 0x000fe400030006ffULL,
0x000031202e047816ULL, 0x020fe200000000ffULL, 0x000000244824723cULL, 0x000b620000001820ULL,
0x000031202f057816ULL, 0x000fcc00000000ffULL, 0x00000004ff20723eULL, 0x0a0fe200020006ffULL,
0x0000002c482c723cULL, 0x000b62000000184cULL, 0x00000005ff21723eULL, 0x080fe400020006ffULL,
0x00000004ff04723eULL, 0x000fe400030006ffULL, 0x00000005ff05723eULL, 0x000fc600030006ffULL,
0x000000204820723cULL, 0x040b700000001854ULL, 0x000000044804723cULL, 0x000b620000001844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff427f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000a00c427810ULL, 0x002fe20007ffe0ffULL, 0x01069800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x020fc400078e0043ULL, 0x000000034200720cULL, 0x000fda0003f06070ULL,
0x00002ce000000947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x0106bc00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442447210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011445ULL,
0x0000004441417211ULL, 0x000fca00078110ffULL, 0x000000ffff447224ULL, 0x000fca00000e0645ULL,
0x0000000241417819ULL, 0x000fc80000001244ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c00c427810ULL, 0x000fca0007ffe0ffULL, 0x000062000a457a24ULL, 0x000fe200078e0242ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x0000004203417217ULL, 0x000fe20007800000ULL,
0x0000000109437824ULL, 0x000fe200078e0216ULL, 0x00000002164c7810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff497424ULL, 0x000fe200078e00ffULL, 0x00000004164e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000141427824ULL, 0x000fe200078e0a42ULL, 0x0000000616507810ULL, 0x000fe20007ffe0ffULL,
0x0000000109447824ULL, 0x000fe200078e024cULL, 0x000000f00e4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000143417824ULL, 0x000fe200078e0202ULL, 0x0000004209427217ULL, 0x040fe20007800000ULL,
0x0000000109477824ULL, 0x000fc400078e024eULL, 0x00000010434a7824ULL, 0x000fe400078e00ffULL,
0x0000000144467824ULL, 0x140fe400078e0202ULL, 0x00000010444d7824ULL, 0x000fe200078e00ffULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee241ULL, 0x0000000147487824ULL, 0x040fe400078e0202ULL,
0x00000010474f7824ULL, 0x000fe200078e00ffULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee246ULL,
0x0000000109417824ULL, 0x000fc400078e0250ULL, 0x0000000143437824ULL, 0x100fe200078e0245ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee248ULL, 0x0000000144447824ULL, 0x100fe200078e0245ULL,
0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL, 0x0000000147467824ULL, 0x100fe200078e0245ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x0000000141487824ULL, 0x040fe400078e0245ULL,
0x0000000141457824ULL, 0x040fe400078e0202ULL, 0x0000001041527824ULL, 0x000fc400078e00ffULL,
0x0000000142417824ULL, 0x000fe400078e0a09ULL, 0x00005e0043427625ULL, 0x000fe200078e0049ULL,
0xfffffff052517812ULL, 0x000fe400078ee245ULL, 0x000000411600720cULL, 0x000fe20003f66070ULL,
0x00005e0044447625ULL, 0x000fe200078e0049ULL, 0x0000004b42427210ULL, 0x000fe40007fbe0ffULL,
0x000000414c00720cULL, 0x000fe20003f46070ULL, 0x00005e0046467625ULL, 0x000fe200078e0049ULL,
0x000000414e00720cULL, 0x000fc40003f26070ULL, 0x000000415000720cULL, 0x000fe20003f06070ULL,
0x00005e0048487625ULL, 0x000fe200078e0049ULL, 0x0000004b44447210ULL, 0x080fe40007f9e0ffULL,
0x0000e0004a417811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200028e0643ULL,
0x0000004b46467210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff457224ULL, 0x000fe200020e0645ULL,
0x0000004b48487210ULL, 0x000fe40007fde0ffULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200028e0647ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042417faeULL, 0x0003e2000d901c46ULL, 0x000000ffff497224ULL, 0x000fc600030e0649ULL,
0x00000000444d7faeULL, 0x0003e8000d101c46ULL, 0x00000000464f7faeULL, 0x0003e8000c901c46ULL,
0x0000000048517faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000109417824ULL, 0x000fc800078e0216ULL, 0x0000000141427824ULL, 0x040fe200078e0202ULL,
0x0000000441467810ULL, 0x040fe20007ffe0ffULL, 0x0000001041497824ULL, 0x040fe200078e00ffULL,
0x0000000241437810ULL, 0x000fc60007ffe0ffULL, 0x0000000146477824ULL, 0x040fe200078e0202ULL,
0xfffffff0494a7812ULL, 0x000fe200078ee242ULL, 0x0000001046487824ULL, 0x000fe400078e00ffULL,
0x0000000143447824ULL, 0x040fe400078e0202ULL, 0x00000010434b7824ULL, 0x000fe200078e00ffULL,
0xfffffff0484d7812ULL, 0x000fe200078ee247ULL, 0x00000100ff477424ULL, 0x000fe400078e00ffULL,
0x0000000141487824ULL, 0x140fe200078e0245ULL, 0x0000000641417810ULL, 0x000fe20007ffe0ffULL,
0x0000000143427824ULL, 0x000fe200078e0245ULL, 0xfffffff04b4c7812ULL, 0x000fe200078ee244ULL,
0x00005e0048487625ULL, 0x000fe200078e0047ULL, 0x000000f00e4b7812ULL, 0x000fc400078ec0ffULL,
0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL, 0x0000000146447824ULL, 0x100fe200078e0245ULL,
0x0000004b48487210ULL, 0x000fe20007f3e0ffULL, 0x0000000141467824ULL, 0x000fe400078e0245ULL,
0x00005e0042427625ULL, 0x000fc800078e0047ULL, 0x00005e0044447625ULL, 0x000fe200078e0047ULL,
0x0000004b42427210ULL, 0x000fc60007f1e0ffULL, 0x00000001414e7824ULL, 0x000fe400078e0202ULL,
0x00005e0046467625ULL, 0x000fc800078e0047ULL, 0x0000001041417824ULL, 0x000fe200078e00ffULL,
0x0000004b46467210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff497224ULL, 0x000fe200008e0649ULL,
0x0000004b44447210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0643ULL,
0xfffffff0414e7812ULL, 0x000fe200078ee24eULL, 0x000000ffff477224ULL, 0x000fe200010e0647ULL,
0x0000e0004a417811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200008e0645ULL,
0x0000e0004c4b7811ULL, 0x000fe400078e20ffULL, 0x0000e0004e4f7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048417faeULL, 0x0003e8000b901c46ULL,
0x00000000424b7faeULL, 0x0003e8000b901c46ULL, 0x00000000444d7faeULL, 0x0003e8000b901c46ULL,
0x00000000464f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff447f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106680009487f8cULL, 0x0004e4000c80043fULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x01066c0009417984ULL, 0x000f240000000800ULL,
0x8000000041ff7812ULL, 0x018fc40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004642467210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e43ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011447ULL, 0x0000004641417211ULL, 0x000fca00078110ffULL,
0x000000ffff467224ULL, 0x000fca00000e0647ULL, 0x0000000241417819ULL, 0x000fc80000001246ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01066c0009417984ULL, 0x000ee40000000800ULL, 0x8000000041ff7812ULL, 0x008fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010180000f417984ULL, 0x000ee80000000800ULL,
0x010380000f467984ULL, 0x0004620000000800ULL, 0x000000404100720bULL, 0x008fe20003f1d000ULL,
0x000076927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000477806ULL, 0x004fc800000e0100ULL,
0x0000ffff47ff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff487424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f05270ULL, 0x000000404100720bULL, 0x000fe20003f34000ULL,
0x000076627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x000fc400008e0100ULL,
0x0000004041428209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991010437816ULL, 0x000fc600000000ffULL, 0x010580420f008388ULL, 0x0005e20000000800ULL,
0x000000ff4300720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000040410f7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff10ff7812ULL, 0x000fc6000780c0ffULL, 0x000000400f0f7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL, 0x0000000f00487308ULL, 0x000ea40000000800ULL,
0x000000480b0b7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff4a7819ULL, 0x000fe20000011602ULL, 0x000075a27f007947ULL, 0x000fea000b800000ULL,
0x00001f4a480f7589ULL, 0x0004e400000e0000ULL, 0x0000000f30307220ULL, 0x088fe20000410000ULL,
0x0000000f31317220ULL, 0x080fe20000410000ULL, 0x0000000f38387220ULL, 0x080fe20000410000ULL,
0x0000000f39397220ULL, 0x080fe20000410000ULL, 0x0000000f34347220ULL, 0x080fe20000410000ULL,
0x0000000f35357220ULL, 0x080fe20000410000ULL, 0x0000000f28287220ULL, 0x080fe20000410000ULL,
0x0000000f29297220ULL, 0x080fe20000410000ULL, 0x0000000f24247220ULL, 0x080fe20000410000ULL,
0x0000000f25257220ULL, 0x080fe20000410000ULL, 0x0000000f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000f20207220ULL, 0x080fe20000410000ULL,
0x0000000f21217220ULL, 0x080fe20000410000ULL, 0x0000000f04047220ULL, 0x080fe20000410000ULL,
0x0000000f05057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008024a7811ULL, 0x006fe200078ff0ffULL, 0x000074927f007947ULL, 0x000fea000b800000ULL,
0x00001f4a480f7589ULL, 0x0002a400000e0000ULL, 0x0000000f32327220ULL, 0x084fe20000410000ULL,
0x0000000f33337220ULL, 0x080fe20000410000ULL, 0x0000000f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000f36367220ULL, 0x080fe20000410000ULL,
0x0000000f37377220ULL, 0x080fe20000410000ULL, 0x0000000f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000f26267220ULL, 0x080fe20000410000ULL,
0x0000000f27277220ULL, 0x080fe20000410000ULL, 0x0000000f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000f22227220ULL, 0x080fe20000410000ULL,
0x0000000f23237220ULL, 0x080fe20000410000ULL, 0x0000000f06067220ULL, 0x080fe20000410000ULL,
0x0000000f07077220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff10ff7812ULL, 0x000fe20007800847ULL, 0x00000001ff487424ULL, 0x002fe200078e00ffULL,
0x0000004041407209ULL, 0x000fd60007810000ULL, 0x8000004041410221ULL, 0x000fe20000010000ULL,
0x00007610ff480816ULL, 0x000fc60000000048ULL, 0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL,
0x0000004100130308ULL, 0x000e640000000800ULL, 0x0000001346460220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b460b7221ULL, 0x002fc20000010000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004642107210ULL, 0x000fca0007f1e1ffULL, 0x0000000147467824ULL, 0x000fe200000e0e43ULL,
0x003d09001000780cULL, 0x000fc80003f06070ULL, 0x000000ff4600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401000780cULL, 0x000fc80003f06070ULL,
0x000000ff4600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011446ULL, 0x000000100f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff107224ULL, 0x000fca00000e0646ULL, 0x000000020f0f7819ULL, 0x000fc80000001210ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910480f7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0f00720cULL, 0x000fda0003f25270ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000013ff0f723eULL, 0x000fe400000000ffULL,
0x00000002ff107819ULL, 0x000fe40000011602ULL, 0x000054100f0f7816ULL, 0x000fe2000000000fULL,
0x000070727f007947ULL, 0x000fea000b800000ULL, 0x00001f100f157589ULL, 0x0002a400000e0000ULL,
0x00000008104a7810ULL, 0x002fe20007ffe0ffULL, 0x000070a27f007947ULL, 0x000fea000b800000ULL,
0x00001f4a0f147589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010104a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e000fULL,
0x0000ae4000427802ULL, 0x000fc40000000f00ULL, 0x000075f000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018104a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x004fe200078e000fULL, 0x0000ae9000427802ULL, 0x000fc40000000f00ULL,
0x000075a000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b80017177811ULL, 0x000fe200078e20ffULL,
0x00000000184c783bULL, 0x000f220000004200ULL, 0x0000b8001a1a7811ULL, 0x000fc600078e20ffULL,
0x000000001748783bULL, 0x006e680000000200ULL, 0x000000001954783bULL, 0x0004e80000004200ULL,
0x000000001b58783bULL, 0x000ea20000004200ULL, 0x000031204c4c7816ULL, 0x010fe400000000ffULL,
0x000031204d4d7816ULL, 0x000fc400000000ffULL, 0x0000004cff42723eULL, 0x080fe200020006ffULL,
0x0000001548489232ULL, 0x082fe20000000000ULL, 0x0000004dff43723eULL, 0x080fe200020006ffULL,
0x000000154a4a9232ULL, 0x000fe20000000000ULL, 0x0000004cff4c723eULL, 0x000fe200030006ffULL,
0x0000001449499232ULL, 0x088fe20000000000ULL, 0x0000004dff4d723eULL, 0x000fe200030006ffULL,
0x000000144b4b9232ULL, 0x000fe20000000000ULL, 0x000031204e0f7816ULL, 0x000fe400000000ffULL,
0x000031204f197816ULL, 0x004fc400000000ffULL, 0x0000312054547816ULL, 0x000fe400000000ffULL,
0x0000004c484c723cULL, 0x040be20000001838ULL, 0x0000312055557816ULL, 0x000fe400000000ffULL,
0x00000054ff50723eULL, 0x000fe400020006ffULL, 0x00000055ff51723eULL, 0x000fe400020006ffULL,
0x0000000fff38723eULL, 0x020fe200020006ffULL, 0x000000424830723cULL, 0x000fe20000001830ULL,
0x00000019ff39723eULL, 0x000fc400020006ffULL, 0x00000054ff54723eULL, 0x000fe400030006ffULL,
0x00000055ff55723eULL, 0x000fe400030006ffULL, 0x0000000fff18723eULL, 0x000fe200030006ffULL,
0x000000384838723cULL, 0x000b620000001834ULL, 0x00000019ff19723eULL, 0x000fe200030006ffULL,
0x000000001a34783bULL, 0x020e620000000200ULL, 0x0000312056567816ULL, 0x000fe400000000ffULL,
0x0000312057577816ULL, 0x000fc400000000ffULL, 0x000031205a5a7816ULL, 0x000fe200000000ffULL,
0x00000054485c723cULL, 0x040be2000000182cULL, 0x0000312058587816ULL, 0x000fe200000000ffULL,
0x000000001c2c783bULL, 0x020eac0000004200ULL, 0x000000184828723cULL, 0x040b6e0000001828ULL,
0x00000056ff18723eULL, 0x020fe200020006ffULL, 0x000000504850723cULL, 0x000b620000001824ULL,
0x00000057ff19723eULL, 0x000fc400020006ffULL, 0x00000056ff56723eULL, 0x000fe400030006ffULL,
0x00000057ff57723eULL, 0x000fe400030006ffULL, 0x000031205b257816ULL, 0x020fe200000000ffULL,
0x000000184860723cULL, 0x000b620000001820ULL, 0x0000005aff24723eULL, 0x000fcc00030006ffULL,
0x0000312059197816ULL, 0x020fe200000000ffULL, 0x000000564848723cULL, 0x000b620000001804ULL,
0x0000005aff20723eULL, 0x000fe200020006ffULL, 0x0000001534349232ULL, 0x082fe20000000000ULL,
0x00000025ff21723eULL, 0x080fe200020006ffULL, 0x0000001536369232ULL, 0x000fe20000000000ULL,
0x00000025ff25723eULL, 0x000fe200030006ffULL, 0x0000001435359232ULL, 0x080fe20000000000ULL,
0x00000058ff04723eULL, 0x020fe200020006ffULL, 0x0000001437379232ULL, 0x000fe20000000000ULL,
0x00000019ff05723eULL, 0x000fc400020006ffULL, 0x000031202c2c7816ULL, 0x004fe400000000ffULL,
0x000031202d2d7816ULL, 0x000fe400000000ffULL, 0x000000203420723cULL, 0x040b620000001838ULL,
0x000031202e0f7816ULL, 0x000fe400000000ffULL, 0x00000058ff18723eULL, 0x000fe400030006ffULL,
0x00000019ff19723eULL, 0x000fe400030006ffULL, 0x000031202f397816ULL, 0x020fe200000000ffULL,
0x000000243424723cULL, 0x000b620000001828ULL, 0x0000000fff38723eULL, 0x000fcc00030006ffULL,
0x0000002cff28723eULL, 0x0a0fe200020006ffULL, 0x000000043404723cULL, 0x040b620000001830ULL,
0x0000002dff29723eULL, 0x080fe400020006ffULL, 0x0000002cff2c723eULL, 0x000fe400030006ffULL,
0x0000002dff2d723eULL, 0x000fe400030006ffULL, 0x0000000fff30723eULL, 0x020fe200020006ffULL,
0x000000183418723cULL, 0x000b62000000184cULL, 0x00000039ff31723eULL, 0x000fc400020006ffULL,
0x00000039ff39723eULL, 0x000fca00030006ffULL, 0x000000283428723cULL, 0x040b700000001850ULL,
0x0000002c342c723cULL, 0x040b70000000185cULL, 0x000000303430723cULL, 0x040b700000001860ULL,
0x000000383434723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff427f8cULL, 0x000e64000c80043fULL,
0x0000000000387805ULL, 0x020fc40000015200ULL, 0x0106bc00ff0f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x006fc40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a38107210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3a7824ULL, 0x000fe200000e0e39ULL,
0x003d09001000780cULL, 0x000fc80003f06070ULL, 0x000000ff3a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401000780cULL, 0x000fc80003f06070ULL,
0x000000ff3a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc8000001143aULL, 0x000000100f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff107224ULL, 0x000fca00000e063aULL, 0x000000020f0f7819ULL, 0x000fc80000001210ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000117177810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020d0f7810ULL, 0x000fc80007ffe0ffULL,
0x000000080f00720cULL, 0x000fe40003f06070ULL, 0x000000e00c0f7810ULL, 0x000fca0007ffe0ffULL,
0x000062000a177a24ULL, 0x000fcc00078e020fULL, 0x0000039000008947ULL, 0x000fea0003800000ULL,
0x0000000216467810ULL, 0x040fe20007ffe0ffULL, 0x0000000109107824ULL, 0x000fe200078e0216ULL,
0x0000000416487810ULL, 0x000fe40007ffe0ffULL, 0x0000000f030c7217ULL, 0x000fe20007800000ULL,
0x0000000109387824ULL, 0x000fe200078e0246ULL, 0x000000f00e417812ULL, 0x000fe200078ec0ffULL,
0x00000001101c7824ULL, 0x100fe400078e0202ULL, 0x0000000138397824ULL, 0x040fe400078e0202ULL,
0x00000010384a7824ULL, 0x000fc400078e00ffULL, 0x00000010103f7824ULL, 0x000fe400078e00ffULL,
0x00000001093a7824ULL, 0x000fe200078e0248ULL, 0xfffffff04a437812ULL, 0x000fe200078ee239ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0fULL, 0x00000006164a7810ULL, 0x000fe20007ffe0ffULL,
0x000000013a3b7824ULL, 0x040fe200078e0202ULL, 0xfffffff03f427812ULL, 0x000fe200078ee21cULL,
0x000000103a4c7824ULL, 0x000fe200078e00ffULL, 0x0000000c090c7217ULL, 0x000fe20007800000ULL,
0x00000100ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000c00043437811ULL, 0x000fe200078e20ffULL,
0x00000001100f7824ULL, 0x000fe200078e0217ULL, 0xfffffff04c477812ULL, 0x000fe200078ee23bULL,
0x0000000109397824ULL, 0x000fc400078e024aULL, 0x0000000138387824ULL, 0x000fe200078e0217ULL,
0x0000c00047477811ULL, 0x000fe200078e20ffULL, 0x00005e000f0e7625ULL, 0x000fc800078e001cULL,
0x000000013a107824ULL, 0x100fe200078e0217ULL, 0x000000410e3a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000139177824ULL, 0x040fe400078e0217ULL, 0x00000001393b7824ULL, 0x040fe400078e0202ULL,
0x00000010394c7824ULL, 0x000fe400078e00ffULL, 0x00005e0038387625ULL, 0x000fc800078e001cULL,
0x000000010c3f7824ULL, 0x000fe200078e0a09ULL, 0x0000004138387210ULL, 0x000fe40007f9e0ffULL,
0xfffffff04c0c7812ULL, 0x000fe200078ee23bULL, 0x000000ffff3b7224ULL, 0x000fe200000e060fULL,
0x0000003f1600720cULL, 0x080fe20003f66070ULL, 0x00005e00100e7625ULL, 0x080fe200078e001cULL,
0x0000003f4600720cULL, 0x080fe40003f46070ULL, 0x0000003f4800720cULL, 0x000fe20003f06070ULL,
0x00005e0017167625ULL, 0x000fe200078e001cULL, 0x000000410e0e7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200020e0639ULL, 0x0000003f4a00720cULL, 0x000fe20003f86070ULL,
0x000000ffff0f7224ULL, 0x000fe200028e060fULL, 0x0000004116167210ULL, 0x000fe40007fde0ffULL,
0x0000c000423f7811ULL, 0x000fe400078e20ffULL, 0x0000c0000c417811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe400030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3f7faeULL, 0x0003e8000d901c46ULL, 0x0000000038437faeULL, 0x0003e8000d101c46ULL,
0x000000000e477faeULL, 0x0003e8000c101c46ULL, 0x0000000016417faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000109167824ULL, 0x000fc800078e0216ULL,
0x00000001160c7824ULL, 0x140fe200078e0202ULL, 0x00000002160f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001016397824ULL, 0x040fe200078e00ffULL, 0x00000004161c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001163a7824ULL, 0x040fe200078e0217ULL, 0x0000000616417810ULL, 0x000fe20007ffe0ffULL,
0x000000010f107824ULL, 0x000fe200078e0202ULL, 0xfffffff0390c7812ULL, 0x000fe200078ee20cULL,
0x000000100f3b7824ULL, 0x000fe400078e00ffULL, 0x000000011c387824ULL, 0x000fc400078e0202ULL,
0x000000101c3f7824ULL, 0x040fe200078e00ffULL, 0xfffffff03b107812ULL, 0x000fe200078ee210ULL,
0x00000100ff397424ULL, 0x000fe400078e00ffULL, 0x000000011c167824ULL, 0x100fe200078e0217ULL,
0xfffffff03f427812ULL, 0x000fe200078ee238ULL, 0x00005e003a3a7625ULL, 0x000fe200078e0039ULL,
0x000000f00e3f7812ULL, 0x000fe400078ec0ffULL, 0x0000c00042437811ULL, 0x000fe200078e20ffULL,
0x000000010f0e7824ULL, 0x100fe200078e0217ULL, 0x0000003f3a3a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000141387824ULL, 0x000fc400078e0217ULL, 0x00005e000e0e7625ULL, 0x000fc800078e0039ULL,
0x00005e0016167625ULL, 0x000fe200078e0039ULL, 0x0000003f0e0e7210ULL, 0x000fc60007f1e0ffULL,
0x00000001411c7824ULL, 0x000fe400078e0202ULL, 0x00005e0038387625ULL, 0x000fc800078e0039ULL,
0x0000001041417824ULL, 0x000fe200078e00ffULL, 0x0000003f38387210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e063bULL, 0x0000003f16167210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0xfffffff0411c7812ULL, 0x000fe200078ee21cULL,
0x000000ffff397224ULL, 0x000fe200018e0639ULL, 0x0000c0000c3f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000c00010417811ULL, 0x000fe400078e20ffULL,
0x0000c0001c477811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3f7faeULL, 0x0003e8000b901c46ULL, 0x000000000e417faeULL, 0x0003e8000b901c46ULL,
0x0000000016437faeULL, 0x0003e8000b901c46ULL, 0x0000000038477faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff0e7f8cULL, 0x002e64000c80043fULL, 0x000000ffff3f7224ULL, 0x002fc400078e000fULL,
0x00000000000e7805ULL, 0x000fca0000015200ULL, 0x0106b400ff177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fc40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x000000160e397210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e0fULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011417ULL, 0x000000390c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x000000020c0c7819ULL, 0x000fc80000001217ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000013ff0c723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011602ULL, 0x000054100c0c7816ULL, 0x000fe2000000000cULL,
0x00005ea27f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0c157589ULL, 0x0002a400000e0000ULL,
0x000000080f4a7810ULL, 0x002fe20007ffe0ffULL, 0x00005ed27f007947ULL, 0x000fea000b800000ULL,
0x00001f4a0c147589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f4a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e000cULL,
0x0000c0c000427802ULL, 0x000fc40000000f00ULL, 0x0000637000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f4a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x004fe200078e000cULL, 0x0000c11000427802ULL, 0x000fc40000000f00ULL,
0x0000632000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000b8001d1d7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001e44783bULL, 0x000f280000004200ULL, 0x000000001d38783bULL, 0x000e680000000200ULL,
0x000000001f48783bULL, 0x006e680000004200ULL, 0x000000003e1c783bULL, 0x000ea20000004200ULL,
0x0000312044447816ULL, 0x010fc400000000ffULL, 0x0000312045457816ULL, 0x000fe200000000ffULL,
0x0000001538389232ULL, 0x080fe20000000000ULL, 0x00000044ff0e723eULL, 0x080fe200020006ffULL,
0x000000153a3a9232ULL, 0x000fe20000000000ULL, 0x00000045ff0f723eULL, 0x000fe200020006ffULL,
0x0000001439399232ULL, 0x088fe20000000000ULL, 0x0000312046467816ULL, 0x000fe200000000ffULL,
0x000000143b3b9232ULL, 0x000fe20000000000ULL, 0x0000312047477816ULL, 0x000fe400000000ffULL,
0x00000044ff44723eULL, 0x000fc400030006ffULL, 0x00000045ff45723eULL, 0x000fe400030006ffULL,
0x0000000e384c723cULL, 0x040be20000001804ULL, 0x0000312048487816ULL, 0x002fe400000000ffULL,
0x0000312049497816ULL, 0x000fe400000000ffULL, 0x000031204a4a7816ULL, 0x000fe400000000ffULL,
0x00000046ff04723eULL, 0x0a0fe200020006ffULL, 0x000000443850723cULL, 0x000be20000001818ULL,
0x00000047ff05723eULL, 0x000fe200020006ffULL, 0x000000003d18783bULL, 0x020e620000004200ULL,
0x00000046ff46723eULL, 0x000fc400030006ffULL, 0x00000047ff47723eULL, 0x000fe400030006ffULL,
0x00000048ff0e723eULL, 0x080fe200020006ffULL, 0x000000043820723cULL, 0x040be20000001820ULL,
0x00000049ff0f723eULL, 0x080fe400020006ffULL, 0x000031204b4b7816ULL, 0x000fe400000000ffULL,
0x00000048ff48723eULL, 0x000fe400030006ffULL, 0x0000b8003c047811ULL, 0x020fe200078e20ffULL,
0x000000463824723cULL, 0x000f620000001824ULL, 0x00000049ff49723eULL, 0x000fc400030006ffULL,
0x000031201c1c7816ULL, 0x004fe400000000ffULL, 0x000000000404783bULL, 0x000ea20000000200ULL,
0x000031201d1d7816ULL, 0x000fe400000000ffULL, 0x0000000e3844723cULL, 0x000b620000001828ULL,
0x000031201e1e7816ULL, 0x000fe400000000ffULL, 0x000031201f1f7816ULL, 0x000fc800000000ffULL,
0x0000004aff0e723eULL, 0x0a0fe200020006ffULL, 0x00000048382c723cULL, 0x000f62000000182cULL,
0x0000004bff0f723eULL, 0x080fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400030006ffULL,
0x0000004bff4b723eULL, 0x000fc600030006ffULL, 0x0000000e3854723cULL, 0x000b620000001830ULL,
0x000031201a1a7816ULL, 0x002fe400000000ffULL, 0x000031201b1b7816ULL, 0x000fe400000000ffULL,
0x0000312018187816ULL, 0x000fc600000000ffULL, 0x0000004a3848723cULL, 0x000b620000001834ULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x00000018ff30723eULL, 0x020fe400020006ffULL,
0x00000019ff31723eULL, 0x000fe400020006ffULL, 0x0000001aff34723eULL, 0x080fe400020006ffULL,
0x0000001bff35723eULL, 0x080fe400020006ffULL, 0x0000001aff1a723eULL, 0x000fe200030006ffULL,
0x0000001504049232ULL, 0x084fe20000000000ULL, 0x0000001bff1b723eULL, 0x000fe200030006ffULL,
0x0000001506069232ULL, 0x000fe20000000000ULL, 0x00000018ff18723eULL, 0x000fe200030006ffULL,
0x0000001405059232ULL, 0x080fe20000000000ULL, 0x00000019ff19723eULL, 0x000fe200030006ffULL,
0x0000001407079232ULL, 0x000fce0000000000ULL, 0x0000001a0428723cULL, 0x040b6e0000001824ULL,
0x0000001cff24723eULL, 0x0a0fe200020006ffULL, 0x000000340434723cULL, 0x000b620000001820ULL,
0x0000001dff25723eULL, 0x000fe400020006ffULL, 0x0000001cff1c723eULL, 0x000fc400030006ffULL,
0x0000001dff1d723eULL, 0x000fe400030006ffULL, 0x0000001eff20723eULL, 0x0a0fe200020006ffULL,
0x000000300430723cULL, 0x000b62000000184cULL, 0x0000001fff21723eULL, 0x080fe400020006ffULL,
0x0000001eff1e723eULL, 0x000fe400030006ffULL, 0x0000001fff1f723eULL, 0x000fc600030006ffULL,
0x000000180438723cULL, 0x040b700000001850ULL, 0x000000240424723cULL, 0x040b700000001844ULL,
0x0000001c042c723cULL, 0x040b70000000182cULL, 0x000000200420723cULL, 0x040b700000001854ULL,
0x0000001e0404723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x022fc600078e000fULL, 0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL,
0x000000080d00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff483000007947ULL, 0x000fea000383ffffULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x000000ffff167224ULL, 0x000fe400078e0007ULL, 0x000000ffff157224ULL, 0x000fe400078e0006ULL,
0x000000ffff137224ULL, 0x000fe400078e0005ULL, 0x000000ffff147224ULL, 0x000fcc00078e0004ULL,
0x0000036000008947ULL, 0x000fea0003800000ULL, 0x018000000b027810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000c82000057802ULL, 0x000fc40000000f00ULL, 0x00005a4000007944ULL, 0x006fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00047308ULL, 0x000ee40000001000ULL,
0xbf80000004027423ULL, 0x008fc8000000000bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ee8000c1e9900ULL, 0x0000000000067919ULL, 0x000f240000000000ULL,
0x00000002ff057819ULL, 0x010fe40000011606ULL, 0x0000000806077811ULL, 0x000fe200078ff0ffULL,
0x0000000403047220ULL, 0x008fca0000410000ULL, 0x00001f0504057589ULL, 0x000ee800000e0000ULL,
0x00001f0704067589ULL, 0x000f2200000e0000ULL, 0x0000003005307220ULL, 0x048fe20000410000ULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000003805387220ULL, 0x040fe20000410000ULL,
0x0000003905397220ULL, 0x040fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000003505357220ULL, 0x040fe20000410000ULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000002905297220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002505257220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002d052d7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fe20000410000ULL, 0x0000003206327220ULL, 0x050fe20000410000ULL,
0x0000003306337220ULL, 0x040fe20000410000ULL, 0x0000003a063a7220ULL, 0x040fe20000410000ULL,
0x0000003b063b7220ULL, 0x040fe20000410000ULL, 0x0000003606367220ULL, 0x040fe20000410000ULL,
0x0000003706377220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001606167220ULL, 0x000fc20000410000ULL, 0x0000000000187919ULL, 0x000ee20000000000ULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x0000580000047ab9ULL, 0x000fc40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff057819ULL, 0x008fc60000011618ULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x0000000218027812ULL, 0x040fe400078ec0ffULL, 0x0000000818077811ULL, 0x000fe200078ff0ffULL,
0x0000000805047824ULL, 0x040fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe200078ff8ffULL,
0x00000008050b7824ULL, 0x042fe200078e00ffULL, 0x0000000702067211ULL, 0x000fe200078ff8ffULL,
0x0000000805087824ULL, 0x040fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000203027810ULL, 0x000fe20007ffe0ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000000403057810ULL, 0x000fc40007ffe0ffULL,
0x0000000603037810ULL, 0x000fe40007ffe0ffULL, 0x0000002018107810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee203ULL, 0x0000000818037824ULL, 0x000fe200078e00ffULL,
0xfffffff8070c7812ULL, 0x004fe400078ee206ULL, 0xfffffff808087812ULL, 0x000fe400078ee205ULL,
0xfffffff80b067812ULL, 0x000fc400078ee202ULL, 0x0000a00000057811ULL, 0x000fe400078e58ffULL,
0x000000303100723eULL, 0x000fe400000000ffULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x0000001004047824ULL, 0x100fe200078e0205ULL, 0x00000003ff117819ULL, 0x000fe20000011610ULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x0000000803037812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x00005410000e7816ULL, 0x100fe20000000002ULL,
0x0000001008087824ULL, 0x000fe200078e0205ULL, 0x00007632000f7816ULL, 0x000fe20000000002ULL,
0x0000000110027824ULL, 0x000fe200078e0211ULL, 0x00000003ff0b7819ULL, 0x000fe20000011618ULL,
0x0000000104047824ULL, 0x000fc400078e0203ULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x00000007020d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b007824ULL, 0x000fe200078e0218ULL,
0x0000000e04007388ULL, 0x0003e20000000a00ULL, 0x00000001030c7824ULL, 0x000fe200078e020cULL,
0x000000282902723eULL, 0x000fe200000000ffULL, 0x0000000103077824ULL, 0x040fe400078e0206ULL,
0x0000000103087824ULL, 0x040fe400078e0208ULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x0000000700037812ULL, 0x000fc400078ec0ffULL, 0x000000343500723eULL, 0x000fe400000000ffULL,
0x0ffffff80d0e7812ULL, 0x002fe400078ef810ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0ffffff803067812ULL, 0x000fe200078ef818ULL, 0x000000100e127824ULL, 0x100fe200078e0205ULL,
0x00005410000e7816ULL, 0x000fe40000000002ULL, 0x000000242503723eULL, 0x000fe200000000ffULL,
0x00000010060d7824ULL, 0x000fe200078e0205ULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000000e07007388ULL, 0x0003e20000000a00ULL, 0x000000202100723eULL, 0x000fc400000000ffULL,
0x000000141302723eULL, 0x000fe400000000ffULL, 0x000000363705723eULL, 0x000fe400000000ffULL,
0x0000002a2b06723eULL, 0x000fe400000000ffULL, 0x0000000718187812ULL, 0x000fe400078ec0ffULL,
0x0000000710107812ULL, 0x000fe400078ec0ffULL, 0x00005410030e7816ULL, 0x002fc40000000004ULL,
0x00007632030f7816ULL, 0x000fe40000000004ULL, 0x000000323303723eULL, 0x000fe400000000ffULL,
0x0000003a3b04723eULL, 0x000fe200000000ffULL, 0x0000000e08007388ULL, 0x0003e40000000a00ULL,
0x00005410000e7816ULL, 0x142fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x000000262700723eULL, 0x000fc400000000ffULL, 0x0000002e2f02723eULL, 0x000fe200000000ffULL,
0x0000000e0a007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x142fe40000000004ULL,
0x00007632030f7816ULL, 0x000fe40000000004ULL, 0x000000222303723eULL, 0x000fe400000000ffULL,
0x000000151604723eULL, 0x000fe200000000ffULL, 0x0000000e0c007388ULL, 0x0003e40000000a00ULL,
0x00005410050e7816ULL, 0x002fc40000000006ULL, 0x00007632050f7816ULL, 0x000fe40000000006ULL,
0x0000000000057919ULL, 0x000e620000002600ULL, 0x0000541000067816ULL, 0x000fc60000000002ULL,
0x0004000e07007388ULL, 0x0005e40000000a00ULL, 0x0000763200077816ULL, 0x004fe40000000002ULL,
0x0000541003027816ULL, 0x140fe40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004000608007388ULL, 0x0005e20000000a00ULL, 0x0000000805007824ULL, 0x002fc600078e00ffULL,
0x000400020a007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000d0c7984ULL, 0x000ee20000000c00ULL, 0x0000000805047824ULL, 0x000fe200078e00ffULL,
0xfffffff8000b7812ULL, 0x000fe400078ee20bULL, 0x0000000012147984ULL, 0x000f220000000c00ULL,
0x1ffffff818077812ULL, 0x004fe400078ef809ULL, 0xfffffff804117812ULL, 0x000fe400078ee211ULL,
0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000411117c10ULL, 0x000fc4000ff3e0ffULL,
0x1ffffff810097812ULL, 0x000fe200078ef809ULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005a000b027a11ULL, 0x002fe200078048ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005a0011047a11ULL, 0x000fe400078248ffULL, 0x00005b000b037a11ULL, 0x000fe400000f4c06ULL,
0x00005b0011057a11ULL, 0x000fc600008f4c00ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001009047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x008fe8000c101d06ULL,
0x0000001404007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604207981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x0000000212057824ULL, 0x002fe200078e00ffULL,
0x01060000ff067f8cULL, 0x000e62000c80043fULL, 0x0000004000047824ULL, 0x000fe400078e00ffULL,
0x0000580005057a24ULL, 0x000fc800078e0214ULL, 0x0000620005097a24ULL, 0x000fc800078e0204ULL,
0x000005a000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011602ULL,
0x00000100ff237424ULL, 0x000fe200078e00ffULL, 0x000000300e217812ULL, 0x000fe400078ec0ffULL,
0x000000081e177810ULL, 0x040fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x040fe200078e021eULL,
0x000000101e227810ULL, 0x040fe40007ffe0ffULL, 0x000000181e247810ULL, 0x040fe20007ffe0ffULL,
0x00000001090c7824ULL, 0x000fe200078e0217ULL, 0x000000201e1a7810ULL, 0x000fe20007ffe0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0023ULL, 0x0000000403137217ULL, 0x000fc40007800000ULL,
0x0000000202167211ULL, 0x000fe200078fe8ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0023ULL,
0x000000210a0e7210ULL, 0x080fe40007f1e0ffULL, 0x00002000001b7811ULL, 0x000fe200078e68ffULL,
0x0000000109127824ULL, 0x040fe200078e0222ULL, 0x000000210c107210ULL, 0x000fe20007f3e0ffULL,
0x00000001090c7824ULL, 0x000fe200078e0224ULL, 0x000000281e1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe400000e060bULL, 0x00005e00120a7625ULL, 0x000fc800078e0023ULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x000000210a127210ULL, 0x000fe20007f1e0ffULL,
0x00005e000c0c7625ULL, 0x000fc800078e0023ULL, 0x00000001090a7824ULL, 0x000fe200078e021aULL,
0x000000210c147210ULL, 0x000fe20007f3e0ffULL, 0x00000001130c7824ULL, 0x000fe400078e0a04ULL,
0x000000ffff137224ULL, 0x000fe400000e060bULL, 0x00005e000a0a7625ULL, 0x000fe200078e0023ULL,
0x0000000c1e00720cULL, 0x080fe40003f06070ULL, 0x0000000c2200720cULL, 0x080fe20003fa6070ULL,
0x000000ffff157224ULL, 0x000fe200008e060dULL, 0x00000003160d7812ULL, 0x000fe200078ec0ffULL,
0x0000000417187824ULL, 0x040fe200078e00ffULL, 0x000000210a167210ULL, 0x000fe20007f5e0ffULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x0000000c1700720cULL, 0x000fc40003f26070ULL,
0xfffffffc180a7812ULL, 0x000fe200078ee20dULL, 0x000000ffff177224ULL, 0x000fe200010e060bULL,
0x0ffffffc0d027812ULL, 0x000fe400078ef802ULL, 0x0000000c2400720cULL, 0x080fe20003f86070ULL,
0x000000100a1f7824ULL, 0x100fe200078e021bULL, 0x0000000c1a00720cULL, 0x080fe20003f66070ULL,
0x00000001090a7824ULL, 0x000fe200078e021cULL, 0x0000000c1c00720cULL, 0x000fe20003f46070ULL,
0x00000010021d7824ULL, 0x000fe200078e021bULL, 0x000000301e027810ULL, 0x000fe20007ffe0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0023ULL, 0x000000381e1e7810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e1d7faeULL, 0x0005e4000c101c46ULL,
0x000000210a187210ULL, 0x000fe20007fde0ffULL, 0x00000001090a7824ULL, 0x040fe200078e0202ULL,
0x00000000101f7faeULL, 0x0007e2000c901c46ULL, 0x0000000c0200720cULL, 0x080fe40003f26070ULL,
0x0000000c1e00720cULL, 0x000fe20003f06070ULL, 0x000000ffff197224ULL, 0x000fe400030e060bULL,
0x00000001090c7824ULL, 0x000fc400078e021eULL, 0x00000004240e7824ULL, 0x004fe400078e00ffULL,
0x000000041e1e7824ULL, 0x000fe400078e00ffULL, 0x000000041a107824ULL, 0x008fe200078e00ffULL,
0xfffffffc0e0e7812ULL, 0x100fe200078ee20dULL, 0x000000041c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e1e7812ULL, 0x100fe200078ee20dULL, 0x00000004021c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc22027812ULL, 0x100fe200078ee20dULL, 0x00005e000a0a7625ULL, 0x000fe200078e0023ULL,
0xfffffffc10107812ULL, 0x000fc400078ee20dULL, 0xfffffffc1a1a7812ULL, 0x000fe200078ee20dULL,
0x0000001002097824ULL, 0x100fe200078e021bULL, 0x000000210a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000100e0f7824ULL, 0x000fe200078e021bULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee20dULL,
0x00005e000c0c7625ULL, 0x000fe200078e0023ULL, 0x0000000012097faeULL, 0x0005e6000e901c46ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x000000210c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001010117824ULL, 0x100fe200078e021bULL, 0x00000000140f7faeULL, 0x0005e2000e101c46ULL,
0x000000101a1d7824ULL, 0x000fc400078e021bULL, 0x000000101c1f7824ULL, 0x100fe200078e021bULL,
0x0000000016117faeULL, 0x0005e2000d901c46ULL, 0x000000101e1b7824ULL, 0x000fe400078e021bULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x00000000181d7faeULL, 0x0005e8000d101c46ULL,
0x000000000a1f7faeULL, 0x0005e8000c901c46ULL, 0x000000000c1b7faeULL, 0x0005e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000009020a7211ULL, 0x040fe200078ff0ffULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x00000002020b7211ULL, 0x000fc400078fe8ffULL,
0x00000008021a7811ULL, 0x040fe400078ff0ffULL, 0x0000002802147811ULL, 0x000fe400078ff0ffULL,
0x000000030b197812ULL, 0x000fe200078ec0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0027ULL,
0x000000300e297812ULL, 0x000fe400078ec0ffULL, 0x00000010020e7811ULL, 0x040fe200078ff0ffULL,
0x00000001090c7824ULL, 0x040fe200078e021aULL, 0x0000003002167811ULL, 0x000fe200078ff0ffULL,
0x000000041a227824ULL, 0x000fe200078e00ffULL, 0x0000002002127811ULL, 0x040fe200078ff0ffULL,
0x00000001091a7824ULL, 0x040fe200078e0214ULL, 0x0000001802107811ULL, 0x000fe200078ff0ffULL,
0x0000000414287824ULL, 0x000fe200078e00ffULL, 0x000000290a147210ULL, 0x000fe20007f1e0ffULL,
0x00000001090d7824ULL, 0x040fe200078e020eULL, 0x0000003802187811ULL, 0x000fe200078ff0ffULL,
0x00000001091c7824ULL, 0x040fe200078e0216ULL, 0x0000200000257811ULL, 0x000fe200078e68ffULL,
0x00000004162a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc28167812ULL, 0x000fe200078ee219ULL,
0x0000000109137824ULL, 0x000fc400078e0212ULL, 0x000000ffff157224ULL, 0x000fe200000e060bULL,
0xfffffffc2a177812ULL, 0x100fe200078ee219ULL, 0x000000040e247824ULL, 0x000fe400078e00ffULL,
0x0000000410267824ULL, 0x000fe400078e00ffULL, 0x0000000412127824ULL, 0x000fe400078e00ffULL,
0x00000001091e7824ULL, 0x000fe200078e0218ULL, 0xfffffffc26117812ULL, 0x100fe200078ee219ULL,
0x00005e000c0a7625ULL, 0x000fe200078e0027ULL, 0xfffffffc12127812ULL, 0x000fc600078ee219ULL,
0x0000000418187824ULL, 0x000fe400078e00ffULL, 0x00000001090e7824ULL, 0x000fe200078e0210ULL,
0x0ffffffc19097812ULL, 0x000fe200078ef802ULL, 0x00005e000d0c7625ULL, 0x000fe200078e0027ULL,
0xfffffffc22027812ULL, 0x100fe400078ee219ULL, 0xfffffffc24107812ULL, 0x000fe200078ee219ULL,
0x0000001016217824ULL, 0x000fe200078e0225ULL, 0x000000290a167210ULL, 0x000fe20007f1e0ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e0027ULL, 0xfffffffc18197812ULL, 0x000fc400078ee219ULL,
0x000000290c187210ULL, 0x000fe20007f3e0ffULL, 0x00000010092b7824ULL, 0x100fe400078e0225ULL,
0x0000001017237824ULL, 0x100fe400078e0225ULL, 0x0000001002097824ULL, 0x100fe200078e0225ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000142b7faeULL, 0x0005e2000b901c46ULL,
0x00000010101b7824ULL, 0x100fe400078e0225ULL, 0x00000010111d7824ULL, 0x100fe400078e0225ULL,
0x00000010121f7824ULL, 0x000fc400078e0225ULL, 0x000000ffff177224ULL, 0x000fe200000e060bULL,
0x000000290e0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001019257824ULL, 0x000fe400078e0225ULL,
0x000000ffff197224ULL, 0x000fe200008e060dULL, 0x0000000016097faeULL, 0x0005e2000b901c46ULL,
0x00005e00130a7625ULL, 0x000fc600078e0027ULL, 0x00000000181b7faeULL, 0x0005e2000b901c46ULL,
0x00005e001a0c7625ULL, 0x000fc800078e0027ULL, 0x00005e001c107625ULL, 0x000fe200078e0027ULL,
0x000000290c0c7210ULL, 0x000fc60007f3e0ffULL, 0x00005e001e127625ULL, 0x000fe200078e0027ULL,
0x0000002910107210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x000000290a0a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x0000002912127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x000000000e1d7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0b7224ULL, 0x000fe400000e060bULL,
0x000000ffff137224ULL, 0x000fc600018e0613ULL, 0x000000000a1f7faeULL, 0x0005e8000b901c46ULL,
0x000000000c217faeULL, 0x0005e8000b901c46ULL, 0x0000000010237faeULL, 0x0005e8000b901c46ULL,
0x0000000012257faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000a7805ULL, 0x004fc40000015200ULL, 0x01060400ff097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x006fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a097210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e0bULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc8000001140cULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e060cULL, 0x0000000202027819ULL, 0x000fc80000001209ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0207ULL, 0x00000003ff067819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL,
0x0000000102067810ULL, 0x040fe20007ffe0ffULL, 0x00000020020b7824ULL, 0x040fe400078e00ffULL,
0x0000000102097824ULL, 0x040fe400078e0207ULL, 0x00000001070a7824ULL, 0x040fe200078e0206ULL,
0x0000001007077810ULL, 0x000fe20007ffe0ffULL, 0x00000020020c7824ULL, 0x040fe200078e00ffULL,
0x0000001f09097812ULL, 0x000fe200078ec0ffULL, 0x0000002002147824ULL, 0x000fe200078e00ffULL,
0x0000001f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000001e00c097812ULL, 0x000fc400078ee209ULL, 0x000001e00b0a7812ULL, 0x000fe200078ee20aULL,
0x00000001020b7824ULL, 0x000fe200078e0207ULL, 0x0000001f06067812ULL, 0x000fe200078ec0ffULL,
0x0000000009107984ULL, 0x000e62000000cc00ULL, 0x0000002002077824ULL, 0x000fe400078e00ffULL,
0x0000001f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000000a0c7984ULL, 0x000ea4000000cc00ULL,
0x000001e007067812ULL, 0x000fe400078ee206ULL, 0x000001e0140b7812ULL, 0x000fe200078ee20bULL,
0x000000ffff187224ULL, 0x002fc400078e0010ULL, 0x000000ffff197224ULL, 0x000fe400078e0012ULL,
0x000000ffff1a7224ULL, 0x004fe400078e000cULL, 0x000000ffff1b7224ULL, 0x000fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fe200078e000fULL,
0x0000001809007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1c7224ULL, 0x000fc400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fca00078e0013ULL, 0x0000001c0a007388ULL, 0x000fe8000000cc00ULL,
0x00000000060c7984ULL, 0x000e68000000cc00ULL, 0x000000000b107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff177224ULL, 0x002fe400078e000eULL, 0x000000ffff167224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x000000140b007388ULL, 0x0003e8000000cc00ULL,
0x0000000c06007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff0c7f8cULL, 0x002e62000c80043fULL, 0x000000ffff0e7224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x01060400ff097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x006fc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a06097210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e07ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140aULL,
0x0000000902027211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e060aULL,
0x0000000202027819ULL, 0x000fc80000001209ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x3d80000020067820ULL, 0x010fe20000410000ULL,
0x0001068800077811ULL, 0x000fe200078e18ffULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0xffffffff08097810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200078e00ffULL,
0x00010608000a7811ULL, 0x000fc400078e28ffULL, 0x000001000b2c7824ULL, 0x000fe200078e0204ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000002c0300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e002dULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x000000012e307810ULL, 0x020fe20007ffe0ffULL,
0x00000a8000007945ULL, 0x000fe60003800000ULL, 0x0000000b302d7211ULL, 0x000fc400078ff0ffULL,
0x000000043000780cULL, 0x040fe40003f06070ULL, 0x000000012d2f7810ULL, 0x040fe20007ffe0ffULL,
0x000001002d347824ULL, 0x000fe200078e0204ULL, 0x00000001412d7812ULL, 0x000fe400078e0cffULL,
0x000000082f00720cULL, 0x000fe20003f26070ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002eULL,
0x0000000330317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2e7224ULL, 0x000fe400078e0030ULL,
0x0000620005397a24ULL, 0x000fd000078e0234ULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x00000004313d7824ULL, 0x000fe200078e00ffULL, 0x0000000202317211ULL, 0x002fe200078fe8ffULL,
0x00000002003c7824ULL, 0x000fe200078e022dULL, 0x0000003403307217ULL, 0x000fe20007800000ULL,
0x00000100ff3f7424ULL, 0x000fe200078e00ffULL, 0x00000002ff367819ULL, 0x000fe40000011602ULL,
0x00000003313b7812ULL, 0x000fe200078ec0ffULL, 0x0000000130347824ULL, 0x000fe200078e0a34ULL,
0x0000000836317810ULL, 0x040fe20007ffe0ffULL, 0x0000000136307824ULL, 0x000fe200078e0239ULL,
0xfffffffc3d3d7812ULL, 0x000fc400078ee202ULL, 0x000000343600720cULL, 0x080fe20003f26070ULL,
0x0000000131327824ULL, 0x040fe200078e0239ULL, 0x000000343100720cULL, 0x040fe20003f46070ULL,
0x0000000431387824ULL, 0x000fe200078e00ffULL, 0x000020003c3c7811ULL, 0x000fe200078e60ffULL,
0x00005e0030307625ULL, 0x080fe200078e003fULL, 0x0ffffffc3b357812ULL, 0x000fe400078ef802ULL,
0xfffffffc38377812ULL, 0x000fe200078ee23bULL, 0x00005e0032327625ULL, 0x000fe200078e003fULL,
0x0000001036387810ULL, 0x000fc40007ffe0ffULL, 0x00000018363a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001035357824ULL, 0x000fe200078e023cULL, 0x00000020363e7810ULL, 0x040fe20007ffe0ffULL,
0x000000103d307825ULL, 0x000fe200078e0030ULL, 0x0000002836407810ULL, 0x040fe40007ffe0ffULL,
0x0000003036427810ULL, 0x040fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e023cULL,
0x0000003836437810ULL, 0x000fe20007ffe0ffULL, 0x000000103d327825ULL, 0x000fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030357faeULL, 0x0003e2000c901c46ULL,
0x000000343800720cULL, 0x000fc40003f26070ULL, 0x000000343e00720cULL, 0x080fe20003f66070ULL,
0x0000000032377faeULL, 0x0005e2000d101c46ULL, 0x000000343a00720cULL, 0x080fe20003f46070ULL,
0x0000000438447824ULL, 0x000fe200078e00ffULL, 0x000000344000720cULL, 0x0c0fe20003f86070ULL,
0x0000000140367824ULL, 0x100fe200078e0239ULL, 0x000000344200720cULL, 0x080fe20003fa6070ULL,
0x000000043a467824ULL, 0x000fe200078e00ffULL, 0x000000344300720cULL, 0x000fe20003fc6070ULL,
0x0000000138307824ULL, 0x102fe400078e0239ULL, 0x000000013e347824ULL, 0x000fe200078e0239ULL,
0xfffffffc46457812ULL, 0x000fe200078ee23bULL, 0x0000000142387824ULL, 0x000fc400078e0239ULL,
0x000000043e3e7824ULL, 0x000fe400078e00ffULL, 0x0000000440407824ULL, 0x000fe400078e00ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0xfffffffc3e477812ULL, 0x100fe200078ee23bULL,
0x0000000443487824ULL, 0x040fe200078e00ffULL, 0xfffffffc40497812ULL, 0x000fe200078ee23bULL,
0x000000013a327824ULL, 0x004fe200078e0239ULL, 0xfffffffc424b7812ULL, 0x000fe200078ee23bULL,
0x00000001433a7824ULL, 0x000fe200078e0239ULL, 0xfffffffc44437812ULL, 0x100fe200078ee23bULL,
0x00005e0030307625ULL, 0x000fe200078e003fULL, 0xfffffffc484d7812ULL, 0x000fc600078ee23bULL,
0x00005e0032327625ULL, 0x000fc800078e003fULL, 0x00005e0034347625ULL, 0x000fc800078e003fULL,
0x00005e0036367625ULL, 0x000fc800078e003fULL, 0x00005e0038387625ULL, 0x000fc800078e003fULL,
0x00005e003a3a7625ULL, 0x000fc800078e003fULL, 0x000000103d307825ULL, 0x000fc800078e0030ULL,
0x000000103d327825ULL, 0x000fc800078e0032ULL, 0x000000103d347825ULL, 0x000fc800078e0034ULL,
0x000000103d367825ULL, 0x000fc800078e0036ULL, 0x000000103d387825ULL, 0x000fc800078e0038ULL,
0x000000103d3a7825ULL, 0x000fc800078e003aULL, 0x00000010433d7824ULL, 0x100fe400078e023cULL,
0x00000010453f7824ULL, 0x100fe400078e023cULL, 0x0000001047437824ULL, 0x100fe200078e023cULL,
0x00000000303d7faeULL, 0x0003e2000c901c46ULL, 0x0000001049457824ULL, 0x100fe400078e023cULL,
0x000000104b477824ULL, 0x100fe200078e023cULL, 0x00000000323f7faeULL, 0x0003e2000d101c46ULL,
0x000000104d497824ULL, 0x000fc600078e023cULL, 0x0000000034437faeULL, 0x0003e8000d901c46ULL,
0x0000000036457faeULL, 0x0003e8000e101c46ULL, 0x0000000038477faeULL, 0x0003e8000e901c46ULL,
0x000000003a497faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x0000000200327824ULL, 0x000fe200078e022dULL, 0x0000000802347811ULL, 0x042fe200078ff0ffULL,
0x0000000431437824ULL, 0x000fe200078e00ffULL, 0x0000001002367811ULL, 0x040fe200078ff0ffULL,
0x00000100ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001802387811ULL, 0x000fe200078ff0ffULL,
0x0000000434427824ULL, 0x000fe200078e00ffULL, 0x00000020023a7811ULL, 0x000fe200078ff0ffULL,
0x0000000436447824ULL, 0x000fe200078e00ffULL, 0x00000028023c7811ULL, 0x000fe200078ff0ffULL,
0x0000000438467824ULL, 0x000fe200078e00ffULL, 0x00000030023e7811ULL, 0x000fe200078ff0ffULL,
0x000000043a487824ULL, 0x000fe200078e00ffULL, 0x0000003802407811ULL, 0x000fe200078ff0ffULL,
0x000000043c4a7824ULL, 0x000fe200078e00ffULL, 0x00002000324f7811ULL, 0x000fe200078e60ffULL,
0x0000000134327824ULL, 0x100fe200078e0239ULL, 0x0000000202317211ULL, 0x000fe200078fe8ffULL,
0x0000000136347824ULL, 0x100fe200078e0239ULL, 0x0000003902307211ULL, 0x000fe200078ff0ffULL,
0x0000000138367824ULL, 0x100fe200078e0239ULL, 0x0000000331337812ULL, 0x000fe200078ec0ffULL,
0x000000013a387824ULL, 0x000fe200078e0239ULL, 0xfffffffc43437812ULL, 0x000fe200078ee202ULL,
0x000000043e4c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc42427812ULL, 0x100fe200078ee233ULL,
0x00000004404e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x000fe200078ee233ULL,
0x000000013c3a7824ULL, 0x000fe200078e0239ULL, 0xfffffffc46467812ULL, 0x000fe200078ee233ULL,
0x000000013e3c7824ULL, 0x000fe200078e0239ULL, 0xfffffffc48487812ULL, 0x000fe200078ee233ULL,
0x00000001403e7824ULL, 0x000fe200078e0239ULL, 0xfffffffc4a4a7812ULL, 0x100fe200078ee233ULL,
0x00005e0030307625ULL, 0x000fe200078e003fULL, 0xfffffffc4c4c7812ULL, 0x000fc400078ee233ULL,
0xfffffffc4e4e7812ULL, 0x000fe200078ee233ULL, 0x00005e0034347625ULL, 0x000fe200078e003fULL,
0x0ffffffc33407812ULL, 0x000fc600078ef802ULL, 0x00005e0032327625ULL, 0x000fc800078e003fULL,
0x00005e0036367625ULL, 0x000fc800078e003fULL, 0x00005e0038387625ULL, 0x000fc800078e003fULL,
0x00005e003a3a7625ULL, 0x000fc800078e003fULL, 0x00005e003c3c7625ULL, 0x000fc800078e003fULL,
0x00005e003e3e7625ULL, 0x000fc800078e003fULL, 0x0000001043307825ULL, 0x000fc800078e0030ULL,
0x0000001043327825ULL, 0x000fc800078e0032ULL, 0x0000001043347825ULL, 0x000fc800078e0034ULL,
0x0000001043367825ULL, 0x000fc800078e0036ULL, 0x0000001043387825ULL, 0x000fc800078e0038ULL,
0x00000010433a7825ULL, 0x000fc800078e003aULL, 0x00000010433c7825ULL, 0x000fc800078e003cULL,
0x00000010433e7825ULL, 0x000fc800078e003eULL, 0x0000001040517824ULL, 0x100fe400078e024fULL,
0x0000001042437824ULL, 0x100fe400078e024fULL, 0x0000001044457824ULL, 0x100fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030517faeULL, 0x0003e2000b901c46ULL,
0x0000001046477824ULL, 0x100fe400078e024fULL, 0x0000001048497824ULL, 0x100fe200078e024fULL,
0x0000000032437faeULL, 0x0003e2000b901c46ULL, 0x000000104a4b7824ULL, 0x000fc400078e024fULL,
0x000000104c4d7824ULL, 0x100fe200078e024fULL, 0x0000000034457faeULL, 0x0003e2000b901c46ULL,
0x000000104e4f7824ULL, 0x000fc600078e024fULL, 0x0000000036477faeULL, 0x0003e8000b901c46ULL,
0x0000000038497faeULL, 0x0003e8000b901c46ULL, 0x000000003a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000003c4d7faeULL, 0x0003e8000b901c46ULL, 0x000000003e4f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002337810ULL, 0x002fe20007ffe0ffULL, 0x0000000200307824ULL, 0x000fe200078e0241ULL,
0xfffffff802317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fc400078ec0ffULL, 0x0000000702357812ULL, 0x000fe400078ec0ffULL,
0x00000007313a7812ULL, 0x100fe400078ef802ULL, 0x0000000733407812ULL, 0x100fe400078ef802ULL,
0x0000200030547811ULL, 0x000fe400078e60ffULL, 0x0000000835557812ULL, 0x000fe400078ef802ULL,
0x00000001ff3b7819ULL, 0x000fc4000001163aULL, 0x00000001ff417819ULL, 0x000fe20000011640ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000042f397824ULL, 0x100fe200078e0238ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000013b307824ULL, 0x020fe400078e0238ULL,
0x000000043a317824ULL, 0x000fe400078e00ffULL, 0x0000000239397824ULL, 0x000fe400078e00ffULL,
0x0000002055337824ULL, 0x000fe200078e00ffULL, 0xfffffffc31317812ULL, 0x000fe200078ee230ULL,
0x0000000141347824ULL, 0x000fe200078e0238ULL, 0x0000003902307211ULL, 0x000fe200078fe0ffULL,
0x0000000440357824ULL, 0x000fe200078e00ffULL, 0x0000000239397810ULL, 0x000fe20007ffe0ffULL,
0x00000010313c7824ULL, 0x000fc400078e0254ULL, 0x0000000155307824ULL, 0x000fe200078e0230ULL,
0xfffffffc35347812ULL, 0x000fe400078ee234ULL, 0x0000003902397211ULL, 0x000fe200078fe0ffULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0xffffffe033307812ULL, 0x000fe200078ee230ULL,
0x0000001034347824ULL, 0x000fe400078e0254ULL, 0x0000000155397824ULL, 0x000fe400078e0239ULL,
0x0000001030307824ULL, 0x000fc400078e00ffULL, 0x000000003434783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x0000003cff42723eULL, 0x082fe400020006ffULL,
0x0000003cff43723eULL, 0x000fe400030006ffULL, 0x0000003dff44723eULL, 0x080fe400020006ffULL,
0x0000003dff45723eULL, 0x000fc400030006ffULL, 0x0000003eff3c723eULL, 0x080fe400020006ffULL,
0x0000003eff3d723eULL, 0x000fe200030006ffULL, 0x000000423028723cULL, 0x044b6e0000001828ULL,
0x0000000138427810ULL, 0x020fe20007ffe0ffULL, 0x000000043a437824ULL, 0x000fe200078e00ffULL,
0x0000003c3020723cULL, 0x000be20000001820ULL, 0x0000000238387810ULL, 0x000fc40007ffe0ffULL,
0x000000013b3e7824ULL, 0x100fe400078e0242ULL, 0x0000000141427824ULL, 0x000fe200078e0242ULL,
0x000000043800780cULL, 0x000fe20003f25270ULL, 0x00000020553c7824ULL, 0x020fe200078e00ffULL,
0xfffffffc43437812ULL, 0x000fe200078ee23eULL, 0x000000443024723cULL, 0x000f620000001824ULL,
0x0000003fff3e723eULL, 0x080fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe200030006ffULL,
0x0000001043437824ULL, 0x000fe200078e0254ULL, 0xffffffe03c397812ULL, 0x000fc800078ee239ULL,
0x00000000434c783bULL, 0x000e620000000200ULL, 0x0000003e303c723cULL, 0x000b62000000181cULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0x000000003948783bULL, 0x000ea20000000200ULL,
0x00000034ff1c723eULL, 0x0a0fe400020006ffULL, 0x00000034ff1d723eULL, 0x000fe400030006ffULL,
0x00000035ff34723eULL, 0x080fe400020006ffULL, 0x00000035ff35723eULL, 0x000fc600030006ffULL,
0x0000001c3018723cULL, 0x040f700000001818ULL, 0x000000343044723cULL, 0x000bee0000001814ULL,
0x0000000440177824ULL, 0x020fe200078e00ffULL, 0x00000036ff14723eULL, 0x000fc400020006ffULL,
0x00000036ff15723eULL, 0x000fe400030006ffULL, 0xfffffffc17427812ULL, 0x000fe400078ee242ULL,
0x00000037ff36723eULL, 0x080fe400020006ffULL, 0x00000037ff37723eULL, 0x000fe200030006ffULL,
0x0000001042427824ULL, 0x000fe200078e0254ULL, 0x000000143010723cULL, 0x040b620000001810ULL,
0x0000004fff1c723eULL, 0x082fe400020006ffULL, 0x0000004fff1d723eULL, 0x000fe200030006ffULL,
0x000000004250783bULL, 0x000e660000000200ULL, 0x0000004cff14723eULL, 0x0a0fe200020006ffULL,
0x00000036300c723cULL, 0x000f62000000180cULL, 0x0000004cff15723eULL, 0x000fc400030006ffULL,
0x0000004dff4c723eULL, 0x080fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x000000144828723cULL, 0x044b6e0000001828ULL, 0x0000004eff14723eULL, 0x0a0fe200020006ffULL,
0x0000004c4824723cULL, 0x000f620000001824ULL, 0x0000004eff15723eULL, 0x000fce00030006ffULL,
0x000000144820723cULL, 0x040b700000001820ULL, 0x0000001c481c723cULL, 0x000f64000000183cULL,
0x00000050ff14723eULL, 0x022fc400020006ffULL, 0x00000050ff15723eULL, 0x000fe400030006ffULL,
0x00000052ff30723eULL, 0x080fe400020006ffULL, 0x00000052ff31723eULL, 0x000fe400030006ffULL,
0x00000053ff52723eULL, 0x080fe200020006ffULL, 0x000000144818723cULL, 0x000b620000001818ULL,
0x00000053ff53723eULL, 0x000fcc00030006ffULL, 0x00000051ff14723eULL, 0x0a0fe200020006ffULL,
0x000000304810723cULL, 0x000b620000001810ULL, 0x00000051ff15723eULL, 0x000fce00030006ffULL,
0x000000144814723cULL, 0x040b700000001844ULL, 0x00000052480c723cULL, 0x000b62000000180cULL,
0xfffffa8000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff417224ULL, 0x000fe200078e002dULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffeec000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x000000061e307220ULL, 0x0a0fe20000410000ULL, 0x000000061f317220ULL, 0x080fe20000410000ULL,
0x0000000620207220ULL, 0x080fe20000410000ULL, 0x0000000621217220ULL, 0x080fe20000410000ULL,
0x00000006222e7220ULL, 0x080fe20000410000ULL, 0x00000006232f7220ULL, 0x080fe20000410000ULL,
0x000000061d1d7220ULL, 0x080fe20000410000ULL, 0x00000006181e7220ULL, 0x080fe20000410000ULL,
0x00000006191f7220ULL, 0x080fe20000410000ULL, 0x0000000628287220ULL, 0x080fe20000410000ULL,
0x0000000629297220ULL, 0x080fe20000410000ULL, 0x0000000624247220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x0000000614227220ULL, 0x080fe20000410000ULL, 0x0000000615237220ULL, 0x080fe20000410000ULL,
0x0000000610107220ULL, 0x080fe20000410000ULL, 0x0000000611117220ULL, 0x080fe20000410000ULL,
0x000000060c0c7220ULL, 0x080fe20000410000ULL, 0x000000061a327220ULL, 0x080fe20000410000ULL,
0x000000061b337220ULL, 0x080fe20000410000ULL, 0x0000000616347220ULL, 0x080fe20000410000ULL,
0x0000000617357220ULL, 0x080fe20000410000ULL, 0x0000000612367220ULL, 0x080fe20000410000ULL,
0x0000000613377220ULL, 0x080fe20000410000ULL, 0x000000ffff167224ULL, 0x000fe200078e0020ULL,
0x000000062a2a7220ULL, 0x080fe20000410000ULL, 0x000000ffff177224ULL, 0x000fe200078e0021ULL,
0x000000062b2b7220ULL, 0x080fe20000410000ULL, 0x000000ffff197224ULL, 0x000fe200078e001dULL,
0x0000000626267220ULL, 0x080fe20000410000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e001eULL,
0x0000000627277220ULL, 0x080fe20000410000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e001fULL,
0x000000060d0d7220ULL, 0x080fe20000410000ULL, 0x000000060e0e7220ULL, 0x080fe20000410000ULL,
0x000000060f0f7220ULL, 0x000fe20000410000ULL, 0x000000ffff137224ULL, 0x000fc400078e0028ULL,
0x000000ffff127224ULL, 0x000fe400078e0029ULL, 0x000000ffff147224ULL, 0x000fe400078e0024ULL,
0x000000ffff157224ULL, 0x000fe400078e0025ULL, 0x000000ffff187224ULL, 0x000fe400078e001cULL,
0x000000ffff1d7224ULL, 0x000fe400078e0022ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0023ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0010ULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000007107f8cULL, 0x0002a2000c80043fULL, 0x000000ffff257224ULL, 0x000fe400078e0026ULL,
0x000000ffff267224ULL, 0x000fe400078e0027ULL, 0x000000ffff247224ULL, 0x000fc400078e002aULL,
0x000000ffff237224ULL, 0x000fe400078e002bULL, 0x000000ffff277224ULL, 0x000fe400078e002eULL,
0x000000ffff287224ULL, 0x000fe400078e002fULL, 0x000000ffff297224ULL, 0x000fe400078e0030ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0031ULL, 0x000000ffff2b7224ULL, 0x000fc400078e0032ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0033ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0034ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff307224ULL, 0x000fe400078e0035ULL,
0x000000ffff317224ULL, 0x000fe400078e0036ULL, 0x000000ffff327224ULL, 0x000fc400078e0037ULL,
0x000000ffff337224ULL, 0x000fe400078e000eULL, 0x000000ffff347224ULL, 0x000fc400078e000fULL,
0x00000000000c7805ULL, 0x006fca0000015200ULL, 0x00000400070f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c357210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000350e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400070f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000402357824ULL, 0x000fe200078e00ffULL,
0x000000090b00720cULL, 0x000fc80003f05270ULL, 0xfffffff0350d7812ULL, 0x000fca00078ec0ffULL,
0x00000080001c7824ULL, 0x000fca00078e020dULL, 0x010400001c0c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202107824ULL, 0x000fe400078e00ffULL,
0x00000001032c7824ULL, 0x000fc600078e0a2cULL, 0x0000000610117812ULL, 0x000fc800078ec0ffULL,
0x0000000111377812ULL, 0x040fe400078efcffULL, 0x0000000811397812ULL, 0x000fe400078efcffULL,
0x0000002c3700720cULL, 0x080fe40003f26070ULL, 0x0000001011377812ULL, 0x000fe400078efcffULL,
0x0000002c3900720cULL, 0x080fe40003f06070ULL, 0x0000002c3700720cULL, 0x000fc40003fc6070ULL,
0x0000001111397812ULL, 0x040fe400078efcffULL, 0x0000001811377812ULL, 0x040fe400078efcffULL,
0x0000002c1100720cULL, 0x080fe40003f46070ULL, 0x0000002c3900720cULL, 0x080fe40003fa6070ULL,
0x0000002c3700720cULL, 0x000fe40003f66070ULL, 0x00000009113b7812ULL, 0x000fc400078efcffULL,
0x0000001911397812ULL, 0x040fe400078efcffULL, 0x0000002011377812ULL, 0x000fe400078efcffULL,
0xff80000024247808ULL, 0x000fe40005000000ULL, 0xff80000013137808ULL, 0x000fe40005000000ULL,
0xff80000023237808ULL, 0x000fe40004800000ULL, 0xff80000012127808ULL, 0x000fc40004800000ULL,
0x0000002c3b00720cULL, 0x080fe40003f86070ULL, 0x0000002c3900720cULL, 0x080fe40003f46070ULL,
0x0000002c3700720cULL, 0x000fe40003f26070ULL, 0x0000002111397812ULL, 0x040fe400078efcffULL,
0x0000002811377812ULL, 0x000fe400078efcffULL, 0xff80000025257808ULL, 0x000fc40004000000ULL,
0xff80000014147808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff80000015157808ULL, 0x000fe40006000000ULL, 0x0000002c3900720cULL, 0x080fe40003f06070ULL,
0x0000002c3700720cULL, 0x000fe40003f86070ULL, 0x0000002911397812ULL, 0x000fc400078efcffULL,
0x0000003011377812ULL, 0x000fe400078efcffULL, 0xff80000027277808ULL, 0x000fe40007000000ULL,
0xff80000016167808ULL, 0x000fe40007000000ULL, 0xff80000028287808ULL, 0x000fe40006800000ULL,
0xff80000017177808ULL, 0x000fe40006800000ULL, 0x0000002c3900720cULL, 0x000fc40003fc6070ULL,
0x0000002c3700720cULL, 0x000fe40003fa6070ULL, 0x0000003111397812ULL, 0x040fe400078efcffULL,
0x0000003811377812ULL, 0x040fe400078efcffULL, 0x0000003911117812ULL, 0x000fe400078efcffULL,
0xff80000029297808ULL, 0x000fe40005800000ULL, 0xff80000018187808ULL, 0x000fc40005800000ULL,
0xff8000002a2a7808ULL, 0x000fe40005000000ULL, 0xff80000019197808ULL, 0x000fe40005000000ULL,
0xff8000002b2b7808ULL, 0x000fe40004800000ULL, 0xff8000001a1a7808ULL, 0x000fe40004800000ULL,
0x0000002c3900720cULL, 0x080fe40003f66070ULL, 0x0000002c3700720cULL, 0x000fc40003f46070ULL,
0x0000002c1100720cULL, 0x000fe40003f26070ULL, 0xff8000002e2e7808ULL, 0x000fe40004000000ULL,
0xff8000001b1b7808ULL, 0x000fe40004000000ULL, 0xff8000002f2f7808ULL, 0x000fe40006000000ULL,
0xff8000001d1d7808ULL, 0x000fe40006000000ULL, 0xff80000030307808ULL, 0x000fc40007000000ULL,
0xff8000001e1e7808ULL, 0x000fe40007000000ULL, 0xff80000031317808ULL, 0x000fe40006800000ULL,
0xff8000001f1f7808ULL, 0x000fe40006800000ULL, 0xff80000032327808ULL, 0x000fe40005800000ULL,
0xff80000020207808ULL, 0x000fe40005800000ULL, 0xff80000033337808ULL, 0x000fc40005000000ULL,
0xff80000021217808ULL, 0x000fe40005000000ULL, 0xff80000034347808ULL, 0x000fe40004800000ULL,
0xff80000022227808ULL, 0x000fc40004800000ULL, 0x000000130c00720bULL, 0x004fe20003f1e000ULL,
0x0000001fff3b7424ULL, 0x000fe200078e00ffULL, 0x000000240d00720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000c13117208ULL, 0x000fe40004000000ULL,
0x0000000d240c7208ULL, 0x000fc40004800000ULL, 0x000000121100720bULL, 0x000fe40003f1e000ULL,
0x000000230c00720bULL, 0x000fe40003f3e000ULL, 0x0000001112117208ULL, 0x000fe40004000000ULL,
0x0000000c230c7208ULL, 0x000fe40004800000ULL, 0x000000141100720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fc40003f3e000ULL, 0x0000001114107208ULL, 0x000fe40004000000ULL,
0x0000000c250d7208ULL, 0x000fe40004800000ULL, 0x000000151000720bULL, 0x000fe40003f1e000ULL,
0x000000260d00720bULL, 0x000fe40003f3e000ULL, 0x0000001015117208ULL, 0x000fe40004000000ULL,
0x0000000d260c7208ULL, 0x000fc40004800000ULL, 0x000000161100720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x0000001116107208ULL, 0x000fe40004000000ULL,
0x0000000c270d7208ULL, 0x000fe40004800000ULL, 0x000000171000720bULL, 0x000fe40003f1e000ULL,
0x000000280d00720bULL, 0x000fc40003f3e000ULL, 0x0000001017117208ULL, 0x000fe40004000000ULL,
0x0000000d280c7208ULL, 0x000fe40004800000ULL, 0x000000181100720bULL, 0x000fe40003f1e000ULL,
0x000000290c00720bULL, 0x000fe40003f3e000ULL, 0x0000001118107208ULL, 0x000fe40004000000ULL,
0x0000000c290d7208ULL, 0x000fc40004800000ULL, 0x000000191000720bULL, 0x000fe40003f1e000ULL,
0x0000002a0d00720bULL, 0x000fe40003f3e000ULL, 0x0000001019117208ULL, 0x000fe40004000000ULL,
0x0000000d2a0c7208ULL, 0x000fe40004800000ULL, 0x0000001a1100720bULL, 0x000fe40003f1e000ULL,
0x0000002b0c00720bULL, 0x000fc40003f3e000ULL, 0x000000111a107208ULL, 0x000fe40004000000ULL,
0x0000000c2b0d7208ULL, 0x000fe40004800000ULL, 0x0000001b1000720bULL, 0x000fe40003f1e000ULL,
0x0000002e0d00720bULL, 0x000fe40003f3e000ULL, 0x000000101b107208ULL, 0x000fe40004000000ULL,
0x0000000d2e0c7208ULL, 0x000fc40004800000ULL, 0x0000001d1000720bULL, 0x000fe40003f1e000ULL,
0x0000002f0c00720bULL, 0x000fe40003f3e000ULL, 0x000000101d0d7208ULL, 0x000fe40004000000ULL,
0x0000000c2f117208ULL, 0x000fe40004800000ULL, 0x0000001e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000301100720bULL, 0x000fc40003f3e000ULL, 0x0000000d1e0c7208ULL, 0x000fe40004000000ULL,
0x0000001130107208ULL, 0x000fe40004800000ULL, 0x0000001f0c00720bULL, 0x000fe40003f1e000ULL,
0x000000311000720bULL, 0x000fe40003f3e000ULL, 0x0000000c1f0d7208ULL, 0x000fe40004000000ULL,
0x0000001031117208ULL, 0x000fc40004800000ULL, 0x000000200d00720bULL, 0x000fe40003f1e000ULL,
0x000000321100720bULL, 0x000fe40003f3e000ULL, 0x0000000d200c7208ULL, 0x000fe40004000000ULL,
0x0000001132107208ULL, 0x000fe40004800000ULL, 0x000000210c00720bULL, 0x000fe40003f1e000ULL,
0x000000331000720bULL, 0x000fc40003f3e000ULL, 0x0000000c210d7208ULL, 0x000fe40004000000ULL,
0x0000001033117208ULL, 0x000fe40004800000ULL, 0x000000220d00720bULL, 0x000fe40003f1e000ULL,
0x000000341100720bULL, 0x000fe40003f3e000ULL, 0x0000000d22367208ULL, 0x000fe40004000000ULL,
0x0000001134387208ULL, 0x000fe20004800000ULL, 0x000017c27f007947ULL, 0x000fec000b800000ULL,
0x0c401f00360c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c3600720bULL, 0x008fc80003f1e000ULL,
0x000000360c3a7208ULL, 0x000fe20004000000ULL, 0x000017d27f007947ULL, 0x000fea000b800000ULL,
0x0c401f00380c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f2c7f89ULL, 0x000e6200000e0000ULL, 0x0000000c3800720bULL, 0x008fc40003f1e000ULL,
0x0000000d0e00720bULL, 0x010fe40003f3e000ULL, 0x000000380c107208ULL, 0x000fe40004000000ULL,
0x0000000e0d117208ULL, 0x000fe20004800000ULL, 0x0c201f003a0c7f89ULL, 0x000ee200000e0000ULL,
0x0000002c0f00720bULL, 0x002fc60003f1e000ULL, 0x0c201f00100d7f89ULL, 0x000e6200000e0000ULL,
0x0000000f2c2c7208ULL, 0x000fc60004000000ULL, 0x0c201f0011367f89ULL, 0x004ea800000e0000ULL,
0x0c201f002c377f89ULL, 0x0002a200000e0000ULL, 0x0000000c3a00720bULL, 0x008fe40003f1e000ULL,
0x0000000d1000720bULL, 0x002fe40003f3e000ULL, 0x0000003a0c0c7208ULL, 0x000fe40004000000ULL,
0x000000361100720bULL, 0x004fc40003f5e000ULL, 0x000000100d0d7208ULL, 0x000fe40004800000ULL,
0x00000011360e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c0f7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b0d367820ULL, 0x002fe20000410000ULL, 0x3c003c00ff3c7424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010836ULL, 0x0000001300107308ULL, 0x000fe20000000800ULL,
0x3c003c00ff3d7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010836ULL, 0x0000001200117308ULL, 0x000e620000000800ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010836ULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010836ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000101110723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b34347823ULL, 0x000fe20000010836ULL,
0x3fb8aa3b220f7823ULL, 0x000fe2000001080fULL, 0x0000a000003f7811ULL, 0x000fc400078e58ffULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x0000000302ff7812ULL, 0x000fe4000780c0ffULL,
0x000000372c00720bULL, 0x004fca0003f3e000ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fce00000000ffULL, 0x0000002500137308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ea20000000800ULL, 0x000000242311723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000132613723eULL, 0x004fce00000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x0000003c1038723cULL, 0x000f6e00000018ffULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x004fce00000000ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x000000272815723eULL, 0x002fe400000000ffULL, 0x00000002ff287819ULL, 0x000fc80000011602ULL,
0x0000000228187810ULL, 0x040fe20007ffe0ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000000828257824ULL, 0x040fe200078e00ffULL, 0x0000000328197810ULL, 0x040fe20007ffe0ffULL,
0x0000000828267824ULL, 0x040fe200078e00ffULL, 0x0000000428237810ULL, 0x040fe20007ffe0ffULL,
0x0000000828247824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe400078ee218ULL,
0x000000292a17723eULL, 0x004fe200000000ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0xfffffff826267812ULL, 0x000fe200078ee219ULL, 0x00000008282a7824ULL, 0x000fc400078e00ffULL,
0x0000000828297824ULL, 0x000fe400078e00ffULL, 0x0000003c1438723cULL, 0x020f620000001838ULL,
0xfffffff82a277812ULL, 0x000fe200078ee223ULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0xffffffff28237810ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x100fe400078e023fULL,
0x0000001027277824ULL, 0x000fc800078e023fULL, 0x0000001e001e7308ULL, 0x000ea20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000000ffULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x0000001d1e1a723eULL, 0x004fe400000000ffULL,
0x00000005281d7810ULL, 0x000fc40007ffe0ffULL, 0x00000006281e7810ULL, 0x000fc60007ffe0ffULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000002b2e19723eULL, 0x002fe200000000ffULL, 0x00000008282e7824ULL, 0x000fca00078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee223ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x0000002f301b723eULL, 0x004fce00000000ffULL, 0x0000000f00227308ULL, 0x0002a20000000800ULL,
0x0000000828307810ULL, 0x000fe20007ffe0ffULL, 0x000000102e2f7824ULL, 0x000fe200078e023fULL,
0x0000003c1838723cULL, 0x020f660000001838ULL, 0x00000008302b7824ULL, 0x000fe400078e00ffULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x00000001280f7810ULL, 0x002fe40007ffe0ffULL,
0xfffffff82b307812ULL, 0x000fc400078ee230ULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x00000008280f7824ULL, 0x000fe400078e00ffULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x000000212222723eULL, 0x004fe400000000ffULL, 0xfffffff80f0f7812ULL, 0x000fe400078ee228ULL,
0xfffffff82a287812ULL, 0x000fe200078ee21dULL, 0x00000010241d7824ULL, 0x100fe400078e023fULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0xfffffff8292a7812ULL, 0x000fe200078ee21eULL,
0x000000100f0f7824ULL, 0x100fe200078e023fULL, 0x0000000c351e7812ULL, 0x000fe200078ec0ffULL,
0x0000001028297824ULL, 0x000fc400078e023fULL, 0x000000102a2b7824ULL, 0x100fe400078e023fULL,
0x0000003200327308ULL, 0x000ea20000000800ULL, 0x0000001f2020723eULL, 0x002fe200000000ffULL,
0x00000010261f7824ULL, 0x000fe400078e023fULL, 0x000000010f0f7824ULL, 0x000fe400078e021eULL,
0x000000011e1d7824ULL, 0x040fe400078e021dULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x000000011e257824ULL, 0x040fe200078e0225ULL, 0x000000100f007388ULL, 0x0003e20000000800ULL,
0x000000011e1f7824ULL, 0x000fc400078e021fULL, 0x000000011e277824ULL, 0x040fe200078e0227ULL,
0x000000121d007388ULL, 0x0007e20000000800ULL, 0x000000011e297824ULL, 0x000fe200078e0229ULL,
0x0000003400347308ULL, 0x000f220000000800ULL, 0x000000313221723eULL, 0x004fe200000000ffULL,
0x0000001030317824ULL, 0x000fe200078e023fULL, 0x0000001425007388ULL, 0x0007e20000000800ULL,
0x000000011e2b7824ULL, 0x040fe200078e022bULL, 0x0000002c370f7208ULL, 0x002fe20004800000ULL,
0x000000011e2f7824ULL, 0x040fe200078e022fULL, 0x000000161f007388ULL, 0x0007e20000000800ULL,
0x000000011e1e7824ULL, 0x000fc600078e0231ULL, 0x0000001827007388ULL, 0x0007e80000000800ULL,
0x0000001a29007388ULL, 0x0007e20000000800ULL, 0x000000333423723eULL, 0x010fc600000000ffULL,
0x000000202b007388ULL, 0x0007e80000000800ULL, 0x0000003c2038723cULL, 0x020f620000001838ULL,
0x000000222f007388ULL, 0x0007e80000000800ULL, 0x000000111e007388ULL, 0x0007e80000000800ULL,
0x000400131d007388ULL, 0x0007e80000000800ULL, 0x0004001525007388ULL, 0x0007e80000000800ULL,
0x000400171f007388ULL, 0x0007e80000000800ULL, 0x0004001927007388ULL, 0x0007e60000000800ULL,
0x000000ffff397224ULL, 0x020fe200078e003aULL, 0x0004001b29007388ULL, 0x0007e80000000800ULL,
0x000400212b007388ULL, 0x0007e80000000800ULL, 0x000400232f007388ULL, 0x0007e80000000800ULL,
0x0100000c1c008388ULL, 0x0007e80000000c00ULL, 0x010200381c008388ULL, 0x0007e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008000aff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010000aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000010b0b7810ULL, 0x000fe20007ffe0ffULL,
0x000018000aff7f8cULL, 0x0003e6000c80043fULL, 0x000000080b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffd11000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff437807ULL, 0x008fe40004000000ULL,
0x0001150000427802ULL, 0x000fc40000000f00ULL, 0x00000f7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff117224ULL, 0x000fe200078e0049ULL, 0xffff077000007947ULL, 0x000fea000383ffffULL,
0x00000001ff437807ULL, 0x000fe40005000000ULL, 0x0001155000427802ULL, 0x000fc40000000f00ULL,
0x00000f2000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0049ULL,
0xffff07d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0019ULL,
0x000115b000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x008fc400078e001cULL,
0x00000e8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0049ULL,
0xffff086000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e001cULL,
0x0001161000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x002fc400078e0019ULL,
0x00000e2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0049ULL,
0xffff097000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0017ULL,
0x0001167000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0016ULL,
0x00000dc000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0049ULL,
0xffff0d6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x002fe200078e0014ULL,
0x000116d000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0017ULL,
0x00000d6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0049ULL,
0xffff0d3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e001eULL,
0x0001173000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e001fULL,
0x00000d0000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0049ULL,
0xffff20e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e001eULL,
0x0001178000427802ULL, 0x000fc40000000f00ULL, 0x00000cb000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0049ULL, 0xffff20c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff437807ULL, 0x004fe40004000000ULL, 0x000117d000427802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff477224ULL, 0x000fe200078e0049ULL,
0xffff348000007947ULL, 0x000fea000383ffffULL, 0x00000001ff437807ULL, 0x000fe40005000000ULL,
0x0001182000427802ULL, 0x000fc40000000f00ULL, 0x00000c5000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff407224ULL, 0x000fe200078e0049ULL, 0xffff34c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e004cULL, 0x0001187000427802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0049ULL,
0xffff358000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e004cULL,
0x000118c000427802ULL, 0x000fc40000000f00ULL, 0x00000b7000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0049ULL, 0xffff369000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e003fULL, 0x0001192000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4a7224ULL, 0x000fc400078e0046ULL, 0x00000b1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0049ULL, 0xffff3aa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e003fULL, 0x0001197000427802ULL, 0x000fc40000000f00ULL,
0x00000ac000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0049ULL,
0xffff3a8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0041ULL,
0x000119d000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0044ULL,
0x00000a6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0049ULL,
0xffff4c5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0041ULL,
0x00011a2000427802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0049ULL, 0xffff4c3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff437807ULL, 0x004fe40004000000ULL, 0x00011a7000427802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff477224ULL, 0x000fe200078e0049ULL,
0xffff5ee000007947ULL, 0x000fea000383ffffULL, 0x00000001ff437807ULL, 0x000fe40005000000ULL,
0x00011ac000427802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff487224ULL, 0x000fe200078e0049ULL, 0xffff5f1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e004cULL, 0x00011b1000427802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0049ULL,
0xffff5fd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e004cULL,
0x00011b6000427802ULL, 0x000fc40000000f00ULL, 0x000008d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0049ULL, 0xffff60e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e003fULL, 0x00011bc000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4a7224ULL, 0x000fc400078e0046ULL, 0x0000087000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0049ULL, 0xffff64f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e003fULL, 0x00011c1000427802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0049ULL,
0xffff64d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0041ULL,
0x00011c7000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0044ULL,
0x000007c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0049ULL,
0xffff76a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0041ULL,
0x00011cc000427802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0049ULL, 0xffff768000007947ULL, 0x000fea000383ffffULL,
0x00000001ff437807ULL, 0x004fe40004000000ULL, 0x00011d1000427802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff477224ULL, 0x000fe200078e0049ULL,
0xffff893000007947ULL, 0x000fea000383ffffULL, 0x00000001ff437807ULL, 0x000fe40004800000ULL,
0x00011d6000427802ULL, 0x000fc40000000f00ULL, 0x0000071000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0049ULL, 0xffff896000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0048ULL, 0x00011db000427802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0049ULL,
0xffff8a2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0048ULL,
0x00011e0000427802ULL, 0x000fc40000000f00ULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0049ULL, 0xffff8b3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e000fULL, 0x00011e6000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4a7224ULL, 0x000fc400078e0010ULL, 0x000005d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0049ULL, 0xffff8f4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e000fULL, 0x00011eb000427802ULL, 0x000fc40000000f00ULL,
0x0000058000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0049ULL,
0xffff8f2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e000cULL,
0x00011f1000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e000fULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0049ULL,
0xffffa11000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e000cULL,
0x00011f6000427802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0049ULL, 0xffffa0f000007947ULL, 0x000fea000383ffffULL,
0x00000002ff397424ULL, 0x000fe200078e00ffULL, 0x00011fb000107802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0037ULL,
0xffffe80000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x006fe200078e0038ULL,
0x0001201000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff397424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x000000373800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e000eULL, 0x0001207000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff397424ULL, 0x000fe200078e00ffULL, 0x0000003837387208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000370e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e000fULL, 0x000120d000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff397424ULL, 0x000fe200078e00ffULL, 0x0000000e370e7208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000370f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e003aULL, 0x0001213000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000000f372c7208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x000000373a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e0038ULL, 0x0001219000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000003a370c7208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x000000373800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e000eULL, 0x000121f000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x00000038370d7208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000370e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e002cULL, 0x0001225000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000000e370e7208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe6d000007947ULL, 0x000fea000383ffffULL,
0x018000000b027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000b00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0bff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000b037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000b00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffedc1002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0c00003936377389ULL, 0x0002a200000e003bULL,
0xfffedbd010007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff437424ULL, 0x000fe200078e00ffULL,
0x0000001200007348ULL, 0x000fe80003800000ULL, 0x0000004a49497389ULL, 0x0002a200000e0011ULL,
0xfffedb9042007950ULL, 0x000fea0003c3ffffULL, 0x000000014300780cULL, 0x000fe20003f45070ULL,
0x0000001000007348ULL, 0x000fd80003800000ULL, 0x0000000000437806ULL, 0x000fc800050e0100ULL,
0x0000001043497212ULL, 0x000fe200078ec0ffULL, 0x00000000ff437424ULL, 0x000fc800078e00ffULL,
0xfffedb3042007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x00000000000002d0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c98ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d58ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001760ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001770ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001804ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001a00ULL, 0x0000000000012580ULL, 0x6600001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013f80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013fd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014350ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001800ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012780ULL, 0x0000000000012780ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013f80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014350ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin_len = 82992;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
