/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015cd0ULL, 0x0000000000015950ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000013a20ULL, 0x0000000000000190ULL,
0x000b0022000004bdULL, 0x0000000000013bb0ULL, 0x0000000000000050ULL, 0x000b0022000004e8ULL,
0x0000000000013c00ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x0000000000013c40ULL,
0x0000000000000140ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000013d80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00013a2000000000ULL, 0x0000040400000000ULL,
0x810c000001580400ULL, 0x004d240400288080ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0xa408288080840828ULL, 0x288080a608288080ULL, 0x80aa08288080a908ULL,
0x08288080ad082880ULL, 0x8080b508288080afULL, 0xbd08288080b90828ULL, 0x288080be08288080ULL,
0x80c008288080bf08ULL, 0x08288080c8082880ULL, 0x8080ca08288080c9ULL, 0xcc08288080cb0828ULL,
0x288080cd08288080ULL, 0x808508288080ce08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080859200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00013a2000000000ULL,
0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL,
0x2880808228808085ULL, 0x000000b4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL,
0x2880808c08288080ULL, 0x80a4082880809608ULL, 0x08288080a6082880ULL, 0x8080aa08288080a9ULL,
0xaf08288080ad0828ULL, 0x288080b508288080ULL, 0x80bd08288080b908ULL, 0x08288080be082880ULL,
0x8080c008288080bfULL, 0xc908288080c80828ULL, 0x288080ca08288080ULL, 0x80cc08288080cb08ULL,
0x08288080cd082880ULL, 0x80828016288080b2ULL, 0x0000000000031028ULL, 0x288080b292000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000016000000000ULL, 0x00013bb000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808c288080b20900ULL, 0x0000000000002880ULL,
0x000000acffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880809608288080ULL,
0x80a608288080a408ULL, 0x08288080a9082880ULL, 0x8080ad08288080aaULL, 0xb508288080af0828ULL,
0x288080b908288080ULL, 0x80bf08288080bd08ULL, 0x08288080c0082880ULL, 0x8080c908288080c8ULL,
0xcb08288080ca0828ULL, 0x288080cc08288080ULL, 0x80ce08288080cd08ULL, 0x16288080be082880ULL,
0x0000031028808280ULL, 0xbe92000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000025800000000ULL, 0x00013c0000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000acffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880809608288080ULL,
0x80a608288080a408ULL, 0x08288080a9082880ULL, 0x8080ad08288080aaULL, 0xb508288080af0828ULL,
0x288080b908288080ULL, 0x80be08288080bd08ULL, 0x08288080c0082880ULL, 0x8080c908288080c8ULL,
0xcb08288080ca0828ULL, 0x288080cc08288080ULL, 0x80ce08288080cd08ULL, 0x16288080bf082880ULL,
0x0000031028808280ULL, 0xbf92000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL,
0x0000033800000000ULL, 0x00013c4000000000ULL, 0x0000014000000000ULL, 0x0000140400000000ULL,
0x80be288080bf0900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x000823040000006aULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x0198290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000010001982804ULL, 0x0000047000000110ULL, 0x0000210000002050ULL, 0x00002360000021f0ULL,
0x000027e0000027b0ULL, 0x0000288000002830ULL, 0x00003da000003d70ULL, 0x00003e4000003df0ULL,
0x0000542000005390ULL, 0x0000569000005530ULL, 0x00005b5000005b20ULL, 0x00005bf000005ba0ULL,
0x00006f2000006ef0ULL, 0x00006fc000006f70ULL, 0x00008420000083a0ULL, 0x0000869000008530ULL,
0x00008b3000008b00ULL, 0x00008bd000008b80ULL, 0x00009f0000009ed0ULL, 0x00009fa000009f50ULL,
0x0000b4800000b400ULL, 0x0000b6f00000b590ULL, 0x0000bb900000bb60ULL, 0x0000bc300000bbe0ULL,
0x0000cf800000cf50ULL, 0x0000d0200000cfd0ULL, 0x0000d9000000d8f0ULL, 0x00011eb00000e0d0ULL,
0x00011f0000011ef0ULL, 0x00011f6000011f10ULL, 0x00011fa000011f80ULL, 0x00012bf000011fb0ULL,
0x00012c9000012c40ULL, 0x00012d4000012ce0ULL, 0x00012e0000012da0ULL, 0x00012eb000012e60ULL,
0x00012f6000012f00ULL, 0x0001302000012fc0ULL, 0x000130e000013080ULL, 0x0001319000013140ULL,
0x00013240000131e0ULL, 0x00013300000132a0ULL, 0x000133c000013360ULL, 0x0001347000013420ULL,
0x00013520000134c0ULL, 0x000135e000013580ULL, 0x000136a000013640ULL, 0x0001376000013700ULL,
0x00013820000137c0ULL, 0x000138e000013880ULL, 0x000139a000013940ULL, 0x0600390400013a00ULL,
0x000000ff00000220ULL, 0x003f010000010600ULL, 0x00000007000002d0ULL, 0x003f012000010608ULL,
0x00000007000002f0ULL, 0x003f012000010688ULL, 0x0000000700000440ULL, 0x003f0120000106a8ULL,
0x000000ff00000460ULL, 0x003f0100000106b8ULL, 0x000000ff000004e0ULL, 0x003f010700010600ULL,
0x0000000700000630ULL, 0x003f01020001068cULL, 0x0000000700000690ULL, 0x003f010100010688ULL,
0x000000ff00000ef0ULL, 0x003f0107000106a8ULL, 0x000000ff00001010ULL, 0x003f0101000106a8ULL,
0x000000ff00001070ULL, 0x003f0101000106b8ULL, 0x000000ff00001200ULL, 0x003f0105000106bcULL,
0x000000ff000013d0ULL, 0x003f0105000106bcULL, 0x000000ff00001c90ULL, 0x003f0107000106b0ULL,
0x000000ff00001d10ULL, 0x003f0101000106b0ULL, 0x0000000700001d70ULL, 0x003f010100010608ULL,
0x0000000700001d90ULL, 0x003f01050001060cULL, 0x0000000700001f60ULL, 0x003f01050001060cULL,
0x000000ff00002510ULL, 0x003f0105000106acULL, 0x000000ff000026e0ULL, 0x003f0105000106acULL,
0x000000ff00003000ULL, 0x003f0101000106b8ULL, 0x000000ff00003020ULL, 0x003f0105000106bcULL,
0x000000ff000031f0ULL, 0x003f0105000106bcULL, 0x000000ff00003a40ULL, 0x003f0107000106a8ULL,
0x000000ff00003ac0ULL, 0x003f0101000106a8ULL, 0x000000ff00003af0ULL, 0x003f0105000106b4ULL,
0x000000ff00003cc0ULL, 0x003f0105000106b4ULL, 0x000000ff000044d0ULL, 0x003f0101000106b8ULL,
0x000000ff00004540ULL, 0x003f010100010688ULL, 0x000000ff00004590ULL, 0x003f0105000106bcULL,
0x000000ff00004760ULL, 0x003f0105000106bcULL, 0x000000ff00004fb0ULL, 0x003f0107000106b0ULL,
0x000000ff000050b0ULL, 0x003f0101000106b0ULL, 0x0000000700005110ULL, 0x003f010100010628ULL,
0x0000000700005130ULL, 0x003f01050001062cULL, 0x0000000700005300ULL, 0x003f01050001062cULL,
0x000000ff00005880ULL, 0x003f0105000106acULL, 0x000000ff00005a50ULL, 0x003f0105000106acULL,
0x000000ff00006180ULL, 0x003f0101000106b8ULL, 0x000000ff000061a0ULL, 0x003f0105000106bcULL,
0x000000ff00006370ULL, 0x003f0105000106bcULL, 0x000000ff00006bc0ULL, 0x003f0107000106a8ULL,
0x000000ff00006c40ULL, 0x003f0101000106a8ULL, 0x000000ff00006c70ULL, 0x003f0105000106b4ULL,
0x000000ff00006e40ULL, 0x003f0105000106b4ULL, 0x000000ff00007550ULL, 0x003f0101000106b8ULL,
0x000000ff000075c0ULL, 0x003f010100010690ULL, 0x000000ff00007620ULL, 0x003f0105000106bcULL,
0x000000ff000077f0ULL, 0x003f0105000106bcULL, 0x000000ff00008040ULL, 0x003f0107000106b0ULL,
0x000000ff000080c0ULL, 0x003f0101000106b0ULL, 0x0000000700008120ULL, 0x003f010100010648ULL,
0x0000000700008140ULL, 0x003f01050001064cULL, 0x0000000700008310ULL, 0x003f01050001064cULL,
0x000000ff00008860ULL, 0x003f0105000106acULL, 0x000000ff00008a30ULL, 0x003f0105000106acULL,
0x000000ff00009160ULL, 0x003f0101000106b8ULL, 0x000000ff00009180ULL, 0x003f0105000106bcULL,
0x000000ff00009350ULL, 0x003f0105000106bcULL, 0x000000ff00009ba0ULL, 0x003f0107000106a8ULL,
0x000000ff00009c20ULL, 0x003f0101000106a8ULL, 0x000000ff00009c50ULL, 0x003f0105000106b4ULL,
0x000000ff00009e20ULL, 0x003f0105000106b4ULL, 0x000000ff0000a530ULL, 0x003f0101000106b8ULL,
0x000000ff0000a5a0ULL, 0x003f010100010698ULL, 0x000000ff0000a600ULL, 0x003f0105000106bcULL,
0x000000ff0000a7d0ULL, 0x003f0105000106bcULL, 0x000000ff0000b020ULL, 0x003f0107000106b0ULL,
0x000000ff0000b120ULL, 0x003f0101000106b0ULL, 0x000000070000b180ULL, 0x003f010100010668ULL,
0x000000070000b1a0ULL, 0x003f01050001066cULL, 0x000000070000b370ULL, 0x003f01050001066cULL,
0x000000ff0000b8c0ULL, 0x003f0105000106acULL, 0x000000ff0000ba90ULL, 0x003f0105000106acULL,
0x000000ff0000c1c0ULL, 0x003f0101000106b8ULL, 0x000000ff0000c1e0ULL, 0x003f0105000106bcULL,
0x000000ff0000c3b0ULL, 0x003f0105000106bcULL, 0x000000ff0000cc20ULL, 0x003f0107000106a8ULL,
0x000000ff0000cca0ULL, 0x003f0101000106a8ULL, 0x000000ff0000ccd0ULL, 0x003f0105000106b4ULL,
0x000000ff0000cea0ULL, 0x003f0105000106b4ULL, 0x000000ff0000d5b0ULL, 0x003f0101000106b8ULL,
0x000000ff0000d610ULL, 0x003f0101000106a0ULL, 0x000000ff0000e340ULL, 0x003f010100010600ULL,
0x000000ff0000f110ULL, 0x003f010500010604ULL, 0x000000ff0000f2e0ULL, 0x003f010500010604ULL,
0x000000ff0000f650ULL, 0x003f010100010600ULL, 0x000000ff0000f680ULL, 0x003f010500010604ULL,
0x000000ff0000f840ULL, 0x003f010500010604ULL, 0x0000002d000112d0ULL, 0x003f010100000000ULL,
0x0000002d000113e0ULL, 0x003f010500000004ULL, 0x0000002d000115b0ULL, 0x003f010500000004ULL,
0x0000002f00012a50ULL, 0x003f010100000000ULL, 0x0000002f00012ab0ULL, 0x003f010100000008ULL,
0x0000002f00012b10ULL, 0x003f010100000010ULL, 0x0000002f00012b80ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x0000f8a00000e210ULL, 0x00012bc00000f950ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000404ULL, 0x0000001a00000002ULL, 0x0000000000000324ULL,
0x0000001a00000002ULL, 0x0000000000000234ULL, 0x0000001a00000002ULL, 0x0000000000000134ULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x00000000000003deULL,
0x0000001a00000002ULL, 0x00000000000002feULL, 0x0000001a00000002ULL, 0x000000000000020bULL,
0x0000001a00000002ULL, 0x0000000000000111ULL, 0x0000001a00000002ULL, 0x0000000000010700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000077919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff297624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x00000010000a7300ULL, 0x000ee200000e0000ULL, 0x0000000829097824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000f220000002200ULL, 0x00000004ff217424ULL, 0x000fc600078e00ffULL,
0x0000000000067919ULL, 0x000ee20000002600ULL, 0x0000001000137309ULL, 0x0002a60000000000ULL,
0x00000000000c7919ULL, 0x000f280000000000ULL, 0x0000000000227919ULL, 0x000f220000002700ULL,
0x00000005ff007819ULL, 0x002fc60000011607ULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x00001fff02047589ULL, 0x0049e800000e0000ULL, 0x00001fff00007589ULL, 0x000ea200000e0000ULL,
0x0000000806087824ULL, 0x008fe400078e00ffULL, 0x0000010002027a24ULL, 0x010fe200078e0203ULL,
0x0000000c0a00720cULL, 0x000fc60003f02070ULL, 0x0000000002077a24ULL, 0x000fe400078e0207ULL,
0x00000022090a7224ULL, 0x000fc600078e0208ULL, 0x000000ff0700720cULL, 0x040fe40003f25270ULL,
0x0000000f0700780cULL, 0x000fe20003f44070ULL, 0x00000010050e7824ULL, 0x002fe200078e00ffULL,
0x000000030700780cULL, 0x040fe40003f64070ULL, 0x0000007f0700780cULL, 0x000fe40003f84070ULL,
0x000001f00e117812ULL, 0x000fe200078ec0ffULL, 0x00000004040b7824ULL, 0x004fc800078e0200ULL,
0x3fffff80ff029424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x000000020b0b7824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x01060002ff009388ULL, 0x0003e20000000a00ULL, 0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL,
0x000000010b0c7824ULL, 0x000fc400078e0205ULL, 0x000000200b0f7824ULL, 0x000fe400078e00ffULL,
0xff317217ff0dc424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff02a424ULL, 0x002fe200078e00ffULL,
0xffffffe00f0f7812ULL, 0x000fe200078ee20cULL, 0x7fffffc0ff03a424ULL, 0x000fe200078e00ffULL,
0x0104000d0700c388ULL, 0x0003e20000004800ULL, 0x3fffff80ff0c9424ULL, 0x000fe400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x010608020700a388ULL, 0x0005e20000008a00ULL,
0x000000010700780cULL, 0x000fc60003f44070ULL, 0x010688080700b388ULL, 0x0007e20000008a00ULL,
0x7fffff80ff0d9424ULL, 0x002fe200078e00ffULL, 0x000000080b027817ULL, 0x044fe20007800000ULL,
0x000000010a037824ULL, 0x100fe400078e020bULL, 0x00000200ff097424ULL, 0x008fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e0a0bULL, 0x000000010b0b7810ULL, 0x000fc80007ffe0ffULL,
0x000000ff0200720cULL, 0x000fe20003f63070ULL, 0x000000010a087824ULL, 0x000fe200078e020bULL,
0x000000010200780cULL, 0x000fe20003f83070ULL, 0x00005c0003027625ULL, 0x000fc800078e0009ULL,
0x000000010b107824ULL, 0x040fe200078e0205ULL, 0x0000001102027210ULL, 0x000fe20007fbe0ffULL,
0x000000200b127824ULL, 0x000fe400078e00ffULL, 0x00005c0008087625ULL, 0x000fc600078e0009ULL,
0xffffffe012107812ULL, 0x000fe200078ee210ULL, 0x3fffff00ff0aa424ULL, 0x000fe200078e00ffULL,
0x0000001108087210ULL, 0x000fe20007fde0ffULL, 0x7fffff00ff0ba424ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x000fe400028e0603ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0106a80a0700a388ULL, 0x000fe20000008a00ULL, 0x0000001010107824ULL, 0x000fc600078e00ffULL,
0x0106b80cff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020f7faeULL, 0x0003e2000d901c46ULL,
0x000000ffff077224ULL, 0x000fc600078e0a13ULL, 0x0000000008107faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x01060407ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000620022027625ULL, 0x000fc600078e0021ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000602027981ULL, 0x004ea2000c1e1900ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x0000007f02037810ULL, 0x044fe40007ffe0ffULL,
0x000000ff020a7810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff037819ULL, 0x000fe40000011603ULL,
0x00000008ff047819ULL, 0x000fca000001160aULL, 0x0000dc4000008947ULL, 0x000fea0003800000ULL,
0x000001ff0a00780cULL, 0x000fe20003f24070ULL, 0x0000000800077824ULL, 0x000fe200078e00ffULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c0807ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106880007ff7f8cULL, 0x0005e2000c80043fULL,
0xffffffffff207424ULL, 0x000fe200078e00ffULL, 0x0000005000008947ULL, 0x000fea0003800000ULL,
0x0000000222087824ULL, 0x002fe400078e00ffULL, 0x00006400ff097624ULL, 0x000fc800078e00ffULL,
0x0000640008087624ULL, 0x000fc800078e0209ULL, 0x0000600008207625ULL, 0x000fcc00078e0021ULL,
0x0000000620207981ULL, 0x000324000c1e1900ULL, 0x0000580020087a24ULL, 0x012fc800078e02ffULL,
0x0000008008157824ULL, 0x000fe200078e00ffULL, 0x0000043000001947ULL, 0x000fea0003800000ULL,
0x0000000702087217ULL, 0x000fe40007800000ULL, 0x00000004ff097819ULL, 0x000fe40000011605ULL,
0x000000f00e177812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a07ULL,
0x00000002090b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001070a7824ULL, 0x000fe200078e0209ULL,
0x00000004090f7810ULL, 0x040fe40007ffe0ffULL, 0x000000080900720cULL, 0x080fe20003f06070ULL,
0x00000001070c7824ULL, 0x000fe200078e020bULL, 0x0000000609107810ULL, 0x000fe20007ffe0ffULL,
0x0000008006097824ULL, 0x000fe200078e020aULL, 0x000000080b00720cULL, 0x080fe20003f26070ULL,
0x000000010a0b7824ULL, 0x140fe200078e0205ULL, 0x000000080f00720cULL, 0x000fe20003f46070ULL,
0x000000100a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000915187210ULL, 0x000fe20007f7e0ffULL,
0x000000010c0a7824ULL, 0x000fc400078e0205ULL, 0x000000100c127824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0b7812ULL, 0x000fe200078ee20bULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x000000081000720cULL, 0x000fe20003f66070ULL, 0x00000001070f7824ULL, 0x000fe200078e020fULL,
0x0000000209087810ULL, 0x000fe20007ffe0ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0xfffffff0120d7812ULL, 0x000fe400078ee20aULL, 0x00005e00180c7a11ULL, 0x000fe400078840ffULL,
0x00000004090a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000609097810ULL, 0x000fe40007ffe0ffULL,
0x0000000815167210ULL, 0x000fe20007fde0ffULL, 0x000000010f087824ULL, 0x040fe200078e0205ULL,
0x00005f0018187a11ULL, 0x000fe200020f4411ULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000915117210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x0000000a15137210ULL, 0x000fe20007f9e0ffULL, 0x00000001100a7824ULL, 0x000fe200078e0205ULL,
0x00005e0016157a11ULL, 0x000fe200078c40ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0xfffffff00f0f7812ULL, 0x000fe200078ee208ULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x00005f0016167a11ULL, 0x000fe200030f4409ULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x0000000c17087210ULL, 0x000fc40007fde0ffULL, 0x0000c0000b0b7811ULL, 0x000fe400078e20ffULL,
0x00005e0013127a11ULL, 0x000fe200078840ffULL, 0x000000ffff097224ULL, 0x000fe200030e0618ULL,
0x00005e00110c7a11ULL, 0x000fe400078a40ffULL, 0xfffffff010107812ULL, 0x000fe400078ee20aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x00005f0013137a11ULL, 0x000fe400020f4414ULL, 0x00005f0011117a11ULL, 0x000fc400028f440eULL,
0x00000017120a7210ULL, 0x080fe40007f9e0ffULL, 0x000000170c0c7210ULL, 0x080fe40007fbe0ffULL,
0x0000c0000d0e7811ULL, 0x000fe400078e20ffULL, 0x0000c0000f0f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x002fe200020e0613ULL, 0x0000001715087210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e0611ULL, 0x0000c00010107811ULL, 0x000fc600078e20ffULL,
0x000000ffff097224ULL, 0x000fca00000e0616ULL, 0x00000000080e7faeULL, 0x0003e8000c901c46ULL,
0x000000000a0f7faeULL, 0x0003e8000d101c46ULL, 0x000000000c107faeULL, 0x0003e2000d901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000705087211ULL, 0x000fc800078fe0ffULL,
0x00000002080a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108097824ULL, 0x140fe200078e0205ULL,
0x00000006080f7810ULL, 0x040fe20007ffe0ffULL, 0x00000010080c7824ULL, 0x000fe400078e00ffULL,
0x000000010a0b7824ULL, 0x040fe400078e0205ULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c0a7812ULL, 0x000fe200078ee209ULL, 0x0000008006097824ULL, 0x000fe400078e0208ULL,
0x000000100f177824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fc400078ee20bULL,
0x00000004080b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000915167210ULL, 0x000fe40007f1e0ffULL,
0x0000000209087810ULL, 0x000fe20007ffe0ffULL, 0x000000100b137824ULL, 0x000fe200078e00ffULL,
0x00000004090c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000609107810ULL, 0x000fe20007ffe0ffULL,
0x000000010b097824ULL, 0x100fe200078e0205ULL, 0x0000000c15127210ULL, 0x000fe20007f5e0ffULL,
0x000000010f0b7824ULL, 0x000fe200078e0205ULL, 0x0000000815147210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000001015117210ULL, 0x000fc40007f7e0ffULL,
0x00005e0016087a11ULL, 0x000fe200078040ffULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0xfffffff017107812ULL, 0x000fe200078ee20bULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x000000f00e177812ULL, 0x000fe400078ec0ffULL, 0xfffffff0130f7812ULL, 0x000fe200078ee209ULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x00005f0016167a11ULL, 0x000fe400000f440cULL,
0x00005e00120c7a11ULL, 0x000fc400078440ffULL, 0x00005e00110e7a11ULL, 0x000fe400078640ffULL,
0x0000000817087210ULL, 0x000fe40007f1e0ffULL, 0x00005e0014137a11ULL, 0x000fe400078240ffULL,
0x00005f0012127a11ULL, 0x000fe400010f440bULL, 0x00005f0011117a11ULL, 0x000fe200018f4409ULL,
0x000000ffff097224ULL, 0x000fe200000e0616ULL, 0x0000c0000a0b7811ULL, 0x000fc400078e20ffULL,
0x00005f0014147a11ULL, 0x000fe400008f4415ULL, 0x00000013170a7210ULL, 0x040fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000b901c46ULL,
0x0000000c170c7210ULL, 0x040fe40007f3e0ffULL, 0x0000000e170e7210ULL, 0x000fe40007f5e0ffULL,
0x0000c00010107811ULL, 0x000fe400078e20ffULL, 0x0000c0000d087811ULL, 0x002fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0614ULL, 0x0000c0000f097811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fc400008e0612ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0611ULL,
0x000000000a087faeULL, 0x0003e8000b901c46ULL, 0x000000000c097faeULL, 0x0003e8000b901c46ULL,
0x000000000e107faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe20003f05270ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff487f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff247f8cULL, 0x000ee2000c80043fULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000c56000008947ULL, 0x000fea0003800000ULL,
0x0000000222227824ULL, 0x000fe400078e00ffULL, 0x00006400ff177624ULL, 0x000fc400078e00ffULL,
0x000000ffff487224ULL, 0x002fe400078e0049ULL, 0x0000640022227624ULL, 0x000fe400078e0217ULL,
0x000000ffff4c7224ULL, 0x008fe400078e0025ULL, 0xff317217ff3d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fe400078e00ffULL, 0x000000ffff407224ULL, 0x000fc400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400078e00ffULL, 0x0000010023247824ULL, 0x000fca00078e00ffULL,
0x000000022400720cULL, 0x000fda0003f06070ULL, 0x0000c46000000947ULL, 0x004fea0003800000ULL,
0x000000ffff247224ULL, 0x000fc400078e0040ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x0106bc00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780484cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c262b7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2c7824ULL, 0x000fe200000e0e27ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001142cULL,
0x0000002b25257211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062cULL,
0x0000000225257819ULL, 0x000fc8000000122bULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780484cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000123257810ULL, 0x000fe20007ffe0ffULL, 0x0000580020497a24ULL, 0x000fc600078e02ffULL,
0x000000042500720cULL, 0x000fe20003f26070ULL, 0x0000008049497824ULL, 0x000fd800078e00ffULL,
0x0000048000009947ULL, 0x000fea0003800000ULL, 0x0000002023257811ULL, 0x000fe400078e40ffULL,
0x00000004ff2f7819ULL, 0x000fe40000011605ULL, 0x0000002502267217ULL, 0x000fe40007800000ULL,
0x000000042f417810ULL, 0x000fe20007ffe0ffULL, 0x0000000107277824ULL, 0x000fe200078e022fULL,
0x000000022f307810ULL, 0x000fe20007ffe0ffULL, 0x0000000126267824ULL, 0x000fe200078e0a25ULL,
0x0000002006257811ULL, 0x000fe200078e38ffULL, 0x00000001272b7824ULL, 0x000fe200078e0205ULL,
0x000000062f437810ULL, 0x000fe20007ffe0ffULL, 0x00000010273e7824ULL, 0x000fe200078e00ffULL,
0x0000002607267217ULL, 0x040fe20007800000ULL, 0x00000001072d7824ULL, 0x000fc400078e0241ULL,
0x00000001072c7824ULL, 0x000fe200078e0230ULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee22bULL,
0x0000000127277824ULL, 0x000fe400078e0225ULL, 0x000000012d2e7824ULL, 0x140fe400078e0205ULL,
0x000000102d427824ULL, 0x000fe200078e00ffULL, 0x0000002749337210ULL, 0x000fe20007f1e0ffULL,
0x000000012c2b7824ULL, 0x040fe400078e0205ULL, 0x000000102c3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff042427812ULL, 0x000fe200078ee22eULL, 0x000000012c277824ULL, 0x000fc400078e0225ULL,
0x00000001072e7824ULL, 0x000fe200078e0243ULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee22bULL,
0x000000012d2b7824ULL, 0x100fe200078e0225ULL, 0x0000002749277210ULL, 0x040fe20007f5e0ffULL,
0x000000012e2c7824ULL, 0x000fe400078e0225ULL, 0x0000000126257824ULL, 0x000fe200078e0a07ULL,
0x0000002b492b7210ULL, 0x040fe20007f9e0ffULL, 0x000000012e317824ULL, 0x040fe200078e0205ULL,
0x0000002c492c7210ULL, 0x000fe20007fde0ffULL, 0x000000102e447824ULL, 0x000fc400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e00332e7a11ULL, 0x000fe200078040ffULL,
0x0000001005267824ULL, 0x000fe200078e00ffULL, 0xfffffff044447812ULL, 0x000fe200078ee231ULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x000000253000720cULL, 0x080fe20003f46070ULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x00005f0033337a11ULL, 0x000fe400000f442dULL,
0x000000f0263c7812ULL, 0x000fe400078ec0ffULL, 0x000000252f00720cULL, 0x000fe20003f06070ULL,
0x000000ffff2f7224ULL, 0x000fe200030e06ffULL, 0x00005e002b2d7a11ULL, 0x000fc400078a40ffULL,
0x00005e0027317a11ULL, 0x000fe400078640ffULL, 0x0000003c2e267210ULL, 0x000fe40007f9e0ffULL,
0x00005f002b307a11ULL, 0x000fe400028f4430ULL, 0x00005e002c2e7a11ULL, 0x000fe400078a40ffULL,
0x00005f0027327a11ULL, 0x000fe200018f4432ULL, 0x000000ffff277224ULL, 0x000fe200020e0633ULL,
0x0000e0003e2b7811ULL, 0x000fc400078e20ffULL, 0x00005f002c2f7a11ULL, 0x000fe400028f442fULL,
0x0000003c312c7210ULL, 0x080fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e2000c101c46ULL, 0x000000254100720cULL, 0x080fe40003f66070ULL,
0x000000254300720cULL, 0x000fe40003f86070ULL, 0x0000e0003f257811ULL, 0x000fe400078e20ffULL,
0x0000003c2d267210ULL, 0x082fe20007f1e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200028e0632ULL,
0x0000003c2e2e7210ULL, 0x000fc40007fbe0ffULL, 0x0000e000422b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff277224ULL, 0x000fe200000e0630ULL, 0x0000e00044307811ULL, 0x000fe200078e20ffULL,
0x000000ffff2f7224ULL, 0x000fe200028e062fULL, 0x000000002c257faeULL, 0x0003e8000d101c46ULL,
0x00000000262b7faeULL, 0x0003e8000d901c46ULL, 0x000000002e307faeULL, 0x0003e2000e101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000000705267211ULL, 0x000fe400078fe0ffULL,
0x0000002006277811ULL, 0x000fc400078e38ffULL, 0x00000002262b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126257824ULL, 0x140fe200078e0205ULL, 0x00000006262e7810ULL, 0x040fe20007ffe0ffULL,
0x00000010263e7824ULL, 0x000fe400078e00ffULL, 0x000000012b2c7824ULL, 0x040fe400078e0205ULL,
0x000000102b3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee225ULL,
0x0000000126257824ULL, 0x000fe400078e0227ULL, 0x000000012e2f7824ULL, 0x040fe200078e0205ULL,
0xfffffff03f3f7812ULL, 0x000fe200078ee22cULL, 0x000000102e427824ULL, 0x000fe200078e00ffULL,
0x00000004262c7810ULL, 0x000fc40007ffe0ffULL, 0x0000002549337210ULL, 0x000fe20007f1e0ffULL,
0x000000012b257824ULL, 0x000fe200078e0227ULL, 0xfffffff042427812ULL, 0x000fe200078ee22fULL,
0x000000012c267824ULL, 0x040fe400078e0227ULL, 0x000000012c2d7824ULL, 0x040fe400078e0205ULL,
0x000000102c417824ULL, 0x000fe200078e00ffULL, 0x00000026492f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078040ffULL,
0x000000012e277824ULL, 0x000fe200078e0227ULL, 0xfffffff041417812ULL, 0x000fe200078ee22dULL,
0x00000010052c7824ULL, 0x000fe200078e00ffULL, 0x00005f0033337a11ULL, 0x000fc400000f442bULL,
0x00000025492d7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x0000002749277210ULL, 0x000fe40007f9e0ffULL, 0x000000f02c3c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078640ffULL,
0x000000ffff2b7224ULL, 0x000fe200020e06ffULL, 0x00005e0027307a11ULL, 0x000fe400078840ffULL,
0x0000003c32267210ULL, 0x000fc40007f1e0ffULL, 0x00005e002d2c7a11ULL, 0x000fe400078440ffULL,
0x00005f002f2f7a11ULL, 0x000fe400018f4425ULL, 0x00005f00272b7a11ULL, 0x000fe200020f442bULL,
0x000000ffff277224ULL, 0x000fe200000e0633ULL, 0x0000e0003e257811ULL, 0x000fe400078e20ffULL,
0x00005f002d2d7a11ULL, 0x000fe400010f4431ULL, 0x0000003c2c2c7210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000b901c46ULL,
0x0000003c2e2e7210ULL, 0x000fc40007f5e0ffULL, 0x0000003c30307210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2d7224ULL, 0x000fe400000e062dULL, 0x000000ffff2f7224ULL, 0x000fe400010e062fULL,
0x000000ffff317224ULL, 0x000fe200018e062bULL, 0x0000e0003f257811ULL, 0x002fe400078e20ffULL,
0x0000e00041267811ULL, 0x000fe400078e20ffULL, 0x0000e00042277811ULL, 0x000fe200078e20ffULL,
0x000000002c257faeULL, 0x0003e8000b901c46ULL, 0x000000002e267faeULL, 0x0003e8000b901c46ULL,
0x0000000030277faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff427f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060800072e7f8cULL, 0x0006a4000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x01060c0007257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x014fc4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c262b7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2c7824ULL, 0x000fe200000e0e27ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142cULL, 0x0000002b25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062cULL, 0x0000000225257819ULL, 0x000fc8000000122bULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000130307810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060c0007257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001005257824ULL, 0x000fe200078e00ffULL,
0x00000001ff267819ULL, 0x000fe20000011605ULL, 0xffffffffff2d7424ULL, 0x000fc600078e00ffULL,
0x0000000c26267812ULL, 0x000fe400078ec0ffULL, 0x00000070252c7812ULL, 0x000fca00078ec0ffULL,
0x000000012c2c7824ULL, 0x000fca00078e0226ULL, 0x010000002c2b7984ULL, 0x000ea80000000800ULL,
0x010200002c2e7984ULL, 0x0006620000000800ULL, 0x0000003d2b00720bULL, 0x004fe20003f1d000ULL,
0x00010b827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000267806ULL, 0x008fc800000e0100ULL,
0x0000ffff26317812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff327424ULL, 0x000fe400078e00ffULL, 0x000000ffff4a7224ULL, 0x000fc400078e003dULL,
0x0000001fff267424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fca00078e00ffULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fe40003f05270ULL,
0x0000003d2b00720bULL, 0x000fe20003f54000ULL, 0x00010b227f007947ULL, 0x000fd8000b800000ULL,
0x00000000002f7806ULL, 0x000fc400010e0100ULL, 0x0000002b3d4a7209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000099102f307816ULL, 0x000fc600000000ffULL,
0x0104004a2c008388ULL, 0x0005e20000000800ULL, 0x000000ff3000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000004a3d307221ULL, 0x004fe20000010000ULL,
0x000000ff2fff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b30307820ULL, 0x000fcc0000410000ULL, 0x0000003000307308ULL, 0x000ea80000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3f7819ULL, 0x000fe20000011605ULL,
0x00010a827f007947ULL, 0x000fea000b800000ULL, 0x00001f3f303f7589ULL, 0x0044e400000e0000ULL,
0x0000003f34347220ULL, 0x088fe20000410000ULL, 0x0000003f35357220ULL, 0x080fe20000410000ULL,
0x0000003f38387220ULL, 0x080fe20000410000ULL, 0x0000003f39397220ULL, 0x080fe20000410000ULL,
0x0000003f1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003f1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003f18187220ULL, 0x080fe20000410000ULL, 0x0000003f19197220ULL, 0x080fe20000410000ULL,
0x0000003f10107220ULL, 0x080fe20000410000ULL, 0x0000003f11117220ULL, 0x080fe20000410000ULL,
0x0000003f0c0c7220ULL, 0x080fe20000410000ULL, 0x0000003f0d0d7220ULL, 0x080fe20000410000ULL,
0x0000003f08087220ULL, 0x080fe20000410000ULL, 0x0000003f09097220ULL, 0x080fe20000410000ULL,
0x0000003f14147220ULL, 0x080fe20000410000ULL, 0x0000003f15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff002fff7812ULL, 0x000fe2000780c0ffULL,
0x0000003021217220ULL, 0x004fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008053f7811ULL, 0x000fe200078ff0ffULL, 0x000109627f007947ULL, 0x000fea000b800000ULL,
0x00001f3f303f7589ULL, 0x0004e400000e0000ULL, 0x0000003f36367220ULL, 0x088fe20000410000ULL,
0x0000003f37377220ULL, 0x080fe20000410000ULL, 0x0000003f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003f1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003f12127220ULL, 0x080fe20000410000ULL,
0x0000003f13137220ULL, 0x080fe20000410000ULL, 0x0000003f0e0e7220ULL, 0x080fe20000410000ULL,
0x0000003f0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003f0a0a7220ULL, 0x080fe20000410000ULL,
0x0000003f0b0b7220ULL, 0x080fe20000410000ULL, 0x0000003f16167220ULL, 0x080fe20000410000ULL,
0x0000003f17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff31ff7812ULL, 0x000fda000780602fULL, 0x8000004a2b2b0221ULL, 0x000fe20000010000ULL,
0x00007610ff320816ULL, 0x000fc60000000032ULL, 0x3fb8aa3b2b2b0820ULL, 0x000fc80000410000ULL,
0x0000002b00280308ULL, 0x000ea40000000800ULL, 0x000000282e2e0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000212e217221ULL, 0x002fc40000010000ULL,
0x00000000002e7805ULL, 0x000fca0000015200ULL, 0x0106ac00ff2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff337224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x000000302e307210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e2fULL,
0x003d09003000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2b7819ULL, 0x000fc80000011431ULL, 0x000000302b2b7211ULL, 0x000fca00078110ffULL,
0x000000ffff307224ULL, 0x000fca00000e0631ULL, 0x000000022b2b7819ULL, 0x000fc80000001230ULL,
0x0000002b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000133337810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910322b7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2b00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000028ff29723eULL, 0x000fe400000000ffULL,
0x00000002ff2e7819ULL, 0x000fe40000011605ULL, 0x00005410292b7816ULL, 0x000fe20000000029ULL,
0x000105627f007947ULL, 0x000fea000b800000ULL, 0x00001f2e2b297589ULL, 0x0002a400000e0000ULL,
0x000000082e2a7810ULL, 0x000fe20007ffe0ffULL, 0x000105927f007947ULL, 0x000fea000b800000ULL,
0x00001f2a2b2a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000102e3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e002bULL,
0x00002840003e7802ULL, 0x000fc40000000f00ULL, 0x000113c000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000182e3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x004fe200078e002bULL, 0x00002890003e7802ULL, 0x000fc40000000f00ULL,
0x0001137000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000805597812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff2b7819ULL, 0x00afc40000011605ULL, 0x00000007054b7812ULL, 0x000fe400078ec0ffULL,
0x0000000759597812ULL, 0x000fe200078ef805ULL, 0x00000004005b7824ULL, 0x040fe200078e022bULL,
0x000000084b4b7812ULL, 0x000fe400078ef805ULL, 0x0000000200337811ULL, 0x000fe200078e10ffULL,
0x00000001592e7824ULL, 0x040fe200078e025bULL, 0x0000001059487812ULL, 0x040fe200078efcffULL,
0x00000010592f7824ULL, 0x000fe400078e00ffULL, 0x000000012b587824ULL, 0x000fe200078e024bULL,
0x0000003348657210ULL, 0x000fe20007ffe02bULL, 0x000000084b307824ULL, 0x000fe200078e00ffULL,
0xfffffff02f2f7812ULL, 0x000fe200078ee22eULL, 0x000000012b5a7824ULL, 0x000fc400078e0233ULL,
0x0000001059317824ULL, 0x040fe200078e00ffULL, 0xfffffff8302e7812ULL, 0x000fe200078ee258ULL,
0x0000000159307824ULL, 0x000fe200078e025aULL, 0x0000c0002f2f7811ULL, 0x000fe200078e20ffULL,
0x000000015b647824ULL, 0x000fe200078e0248ULL, 0x0000a0002e3c7811ULL, 0x000fe200078e20ffULL,
0x000000084b327824ULL, 0x000fe200078e00ffULL, 0xfffffff031307812ULL, 0x000fe200078ee230ULL,
0x000000002f4c783bULL, 0x004e620000004200ULL, 0x0000000258317810ULL, 0x000fe40007ffe0ffULL,
0x0000c00030307811ULL, 0x000fe200078e20ffULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0xfffffff832317812ULL, 0x000fc600078ee231ULL, 0x000000003044783bULL, 0x000ee20000004200ULL,
0x000031204c4c7816ULL, 0x002fe400000000ffULL, 0x000031204d4d7816ULL, 0x000fe400000000ffULL,
0x0000004cff50723eULL, 0x080fe200020006ffULL, 0x000000293c3ca232ULL, 0x084fe20000000000ULL,
0x0000004dff51723eULL, 0x080fe200020006ffULL, 0x000000293e3ea232ULL, 0x000fe20000000000ULL,
0x0000004cff4c723eULL, 0x000fe200030006ffULL, 0x0000002a3d3da232ULL, 0x080fe20000000000ULL,
0x0000004dff4d723eULL, 0x000fe200030006ffULL, 0x0000002a3f3fa232ULL, 0x000fe20000000000ULL,
0x000031204e417816ULL, 0x000fe200000000ffULL, 0x00000010484e7824ULL, 0x040fe200078e00ffULL,
0x000031204f557816ULL, 0x000fe200000000ffULL, 0x0000001048487824ULL, 0x000fe200078e00ffULL,
0x00000041ff54723eULL, 0x000fc400030006ffULL, 0x0000004c3c38723cULL, 0x040be20000001838ULL,
0xfffffff04e647812ULL, 0x000fe400078ee264ULL, 0xfffffff048657812ULL, 0x000fe400078ee265ULL,
0x0000c00064327811ULL, 0x000fe400078e20ffULL, 0x00000041ff4c723eULL, 0x020fe200020006ffULL,
0x000000503c34723cULL, 0x000b620000001834ULL, 0x00000055ff4d723eULL, 0x000fe200020006ffULL,
0x000000003250783bULL, 0x020e620000004200ULL, 0x0000c00065337811ULL, 0x000fc400078e20ffULL,
0x00000055ff55723eULL, 0x000fe400030006ffULL, 0x0000312044447816ULL, 0x008fe200000000ffULL,
0x0000004c3c4c723cULL, 0x000be2000000181cULL, 0x000000003360783bULL, 0x000ea20000004200ULL,
0x0000312045457816ULL, 0x000fca00000000ffULL, 0x0000a000311c7811ULL, 0x020fe200078e20ffULL,
0x000000543c18723cULL, 0x000b6a0000001818ULL, 0x000000001c1c783bULL, 0x000ee40000000200ULL,
0x00000044ff54723eULL, 0x020fe400020006ffULL, 0x00000045ff55723eULL, 0x000fc400020006ffULL,
0x00000044ff44723eULL, 0x000fe400030006ffULL, 0x00000045ff45723eULL, 0x000fc600030006ffULL,
0x000000543c54723cULL, 0x040b6e0000001810ULL, 0x0000312046107816ULL, 0x020fe400000000ffULL,
0x0000312047117816ULL, 0x000fe400000000ffULL, 0x00000010ff5c723eULL, 0x000fe200020006ffULL,
0x000000443c44723cULL, 0x000f62000000180cULL, 0x00000011ff5d723eULL, 0x000fc400020006ffULL,
0x00000010ff10723eULL, 0x000fe400030006ffULL, 0x00000011ff11723eULL, 0x000fe400030006ffULL,
0x0000312050507816ULL, 0x002fe200000000ffULL, 0x0000005c3c5c723cULL, 0x000b620000001808ULL,
0x0000312052527816ULL, 0x000fe400000000ffULL, 0x0000312060607816ULL, 0x004fe400000000ffULL,
0x0000312062627816ULL, 0x000fc400000000ffULL, 0x00000050ff08723eULL, 0x020fe200020006ffULL,
0x000000103c3c723cULL, 0x000b620000001814ULL, 0x000000291c1ca232ULL, 0x088fe20000000000ULL,
0x0000312063637816ULL, 0x000fe200000000ffULL, 0x000000291e1ea232ULL, 0x000fe20000000000ULL,
0x00000052ff0c723eULL, 0x000fe200020006ffULL, 0x0000002a1d1da232ULL, 0x080fe40000000000ULL,
0x0000312051117816ULL, 0x020fe200000000ffULL, 0x0000002a1f1fa232ULL, 0x000fe20000000000ULL,
0x0000312053157816ULL, 0x000fc400000000ffULL, 0x00000011ff09723eULL, 0x000fe400020006ffULL,
0x00000015ff0d723eULL, 0x080fe400020006ffULL, 0x00000052ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fe200030006ffULL, 0x000000081c08723cULL, 0x000b620000001834ULL,
0x00000050ff10723eULL, 0x000fe400030006ffULL, 0x00000011ff11723eULL, 0x000fc800030006ffULL,
0x0000312061357816ULL, 0x020fe200000000ffULL, 0x000000141c14723cULL, 0x000b620000001818ULL,
0x00000060ff34723eULL, 0x000fcc00030006ffULL, 0x00000035ff19723eULL, 0x0a0fe200020006ffULL,
0x000000101c10723cULL, 0x000b620000001838ULL, 0x00000060ff18723eULL, 0x000fe400020006ffULL,
0x00000035ff35723eULL, 0x000fc800030006ffULL, 0x00000062ff38723eULL, 0x0a0fe200020006ffULL,
0x0000000c1c0c723cULL, 0x000b62000000184cULL, 0x00000063ff39723eULL, 0x080fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400030006ffULL, 0x00000063ff63723eULL, 0x000fc600030006ffULL,
0x000000181c18723cULL, 0x040b700000001854ULL, 0x000000341c34723cULL, 0x040b700000001844ULL,
0x000000381c38723cULL, 0x040b70000000185cULL, 0x000000621c1c723cULL, 0x000b62000000183cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x020e64000c80043fULL, 0x00000000003c7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff3e7984ULL, 0x000ea40000000800ULL, 0x800000003eff7812ULL, 0x006fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000413e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004023417811ULL, 0x000fe200078e40ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000001073d7824ULL, 0x000fe200078e022bULL, 0x00000040063e7811ULL, 0x000fe400078e38ffULL,
0x000000022b477810ULL, 0x000fe20007ffe0ffULL, 0x000000013d3c7824ULL, 0x000fe200078e0205ULL,
0x000000042b507810ULL, 0x000fe20007ffe0ffULL, 0x000000103d4e7824ULL, 0x000fe200078e00ffULL,
0x000000f0254d7812ULL, 0x000fe200078ec0ffULL, 0x000000013d3d7824ULL, 0x000fe200078e023eULL,
0x000000062b527810ULL, 0x000fe20007ffe0ffULL, 0x00000001073f7824ULL, 0x040fe200078e0247ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee23cULL, 0x0000000107487824ULL, 0x000fe200078e0250ULL,
0x00000041023c7217ULL, 0x000fe20007800000ULL, 0x000000013f447824ULL, 0x000fe200078e0205ULL,
0x0000003d49457210ULL, 0x000fe20007f1e0ffULL, 0x000000103f4f7824ULL, 0x000fe200078e00ffULL,
0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL, 0x000000013c3c7824ULL, 0x000fc400078e0a41ULL,
0x000000013f3d7824ULL, 0x000fe200078e023eULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee244ULL,
0x00000001484c7824ULL, 0x040fe200078e0205ULL, 0x0000003c073c7217ULL, 0x000fe20007800000ULL,
0x0000001048517824ULL, 0x000fe200078e00ffULL, 0x0000003d493d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff467224ULL, 0x000fe200000e06ffULL, 0x00005e0045447a11ULL, 0x000fe200078040ffULL,
0x000000013c3f7824ULL, 0x000fe200078e0a07ULL, 0xfffffff051517812ULL, 0x000fe200078ee24cULL,
0x00000001483c7824ULL, 0x000fe200078e023eULL, 0x00005f0045457a11ULL, 0x000fe200000f4446ULL,
0x000000ffff4c7224ULL, 0x000fe200018e06ffULL, 0x00005e003d467a11ULL, 0x000fe200078640ffULL,
0x0000000107537824ULL, 0x000fe200078e0252ULL, 0x0000003f2b00720cULL, 0x000fc40003f86070ULL,
0x0000003c49487210ULL, 0x000fe20007fbe0ffULL, 0x00000001533e7824ULL, 0x000fe200078e023eULL,
0x00005f003d4c7a11ULL, 0x000fe400018f444cULL, 0x0000004d443c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff447224ULL, 0x000fe200028e06ffULL, 0x0000003f4700720cULL, 0x080fe40003f06070ULL,
0x00005e0048477a11ULL, 0x000fe200078a40ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e0645ULL,
0x0000003f5000720cULL, 0x000fc40003f66070ULL, 0x00005f0048487a11ULL, 0x000fe400028f4444ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4e7faeULL, 0x0003e2000e101c46ULL,
0x0000003e49457210ULL, 0x000fe40007f9e0ffULL, 0x0000004d473e7210ULL, 0x080fe40007fde0ffULL,
0x0000c0004f4f7811ULL, 0x000fe400078e20ffULL, 0x0000c00051517811ULL, 0x000fe400078e20ffULL,
0x0000004d463c7210ULL, 0x002fe20007fbe0ffULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x00005e0045447a11ULL, 0x000fe200078840ffULL, 0x00000001534e7824ULL, 0x000fc400078e0205ULL,
0x0000001053537824ULL, 0x000fe200078e00ffULL, 0x00005f0045457a11ULL, 0x000fe200020f4446ULL,
0x000000ffff3d7224ULL, 0x000fe200028e064cULL, 0x0000003f5200720cULL, 0x000fe20003fa6070ULL,
0x000000ffff3f7224ULL, 0x000fe200030e0648ULL, 0x0000004d44447210ULL, 0x000fe40007f9e0ffULL,
0xfffffff0534e7812ULL, 0x000fe200078ee24eULL, 0x000000003c4f7faeULL, 0x0003e4000c101c46ULL,
0x000000ffff457224ULL, 0x000fe200020e0645ULL, 0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL,
0x000000003e517faeULL, 0x0003e8000d901c46ULL, 0x00000000444e7faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000004006467811ULL, 0x000fe200078e38ffULL,
0x0000000107457824ULL, 0x000fe200078e022bULL, 0x000000f025527812ULL, 0x000fc600078ec0ffULL,
0x00000001453d7824ULL, 0x140fe200078e0246ULL, 0x00000002453c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001453e7824ULL, 0x140fe200078e0205ULL, 0x00000004453f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001045537824ULL, 0x040fe200078e00ffULL, 0x0000000645457810ULL, 0x000fe20007ffe0ffULL,
0x000000103c487824ULL, 0x040fe200078e00ffULL, 0x0000003d494c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013c3d7824ULL, 0x040fe200078e0246ULL, 0xfffffff053537812ULL, 0x000fe200078ee23eULL,
0x000000013c3e7824ULL, 0x000fc400078e0205ULL, 0x0000000145477824ULL, 0x000fe200078e0205ULL,
0x0000c00053537811ULL, 0x000fe200078e20ffULL, 0x00000010454f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff4d7224ULL, 0x000fe200000e06ffULL, 0x00005e004c507a11ULL, 0x040fe200078040ffULL,
0x000000013f3c7824ULL, 0x100fe400078e0246ULL, 0x0000000145467824ULL, 0x000fe200078e0246ULL,
0x00005f004c517a11ULL, 0x000fe200000f444dULL, 0x000000013f447824ULL, 0x000fe200078e0205ULL,
0x0000003c494d7210ULL, 0x000fe20007f7e0ffULL, 0x000000103f4e7824ULL, 0x000fe200078e00ffULL,
0xfffffff0483f7812ULL, 0x000fc400078ee23eULL, 0xfffffff04f487812ULL, 0x000fe400078ee247ULL,
0x0000003d494f7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e06ffULL,
0x00000046494c7210ULL, 0x000fe40007f9e0ffULL, 0xfffffff04e457812ULL, 0x000fe200078ee244ULL,
0x000000ffff477224ULL, 0x000fe200000e06ffULL, 0x00005e004f4e7a11ULL, 0x000fe200078040ffULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x0000005250467210ULL, 0x000fc40007fbe0ffULL,
0x00005e004c447a11ULL, 0x040fe400078840ffULL, 0x00005e004d3e7a11ULL, 0x000fe400078640ffULL,
0x00005f004f4f7a11ULL, 0x000fe200000f4447ULL, 0x000000ffff477224ULL, 0x000fe200028e0651ULL,
0x00005f004c4c7a11ULL, 0x000fe400020f443cULL, 0x00005f004d4d7a11ULL, 0x000fe400018f443dULL,
0x000000524e3c7210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046537faeULL, 0x0003e2000b901c46ULL, 0x000000523e3e7210ULL, 0x000fc40007f7e0ffULL,
0x0000005244447210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e064fULL,
0x0000c00048487811ULL, 0x000fe400078e20ffULL, 0x0000c0003f467811ULL, 0x002fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e064dULL, 0x0000c00045477811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe400020e064cULL, 0x000000003c467faeULL, 0x0003e8000b901c46ULL,
0x000000003e477faeULL, 0x0003e8000b901c46ULL, 0x0000000044487faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff3c7f8cULL, 0x000e64000c80043fULL, 0x000000ffff487224ULL, 0x002fc400078e003dULL,
0x00000000003c7805ULL, 0x000fca0000015200ULL, 0x0106b400ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fc40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c447210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000443e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000145457810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000028ff29723eULL, 0x000fe400000000ffULL,
0x00000002ff3d7819ULL, 0x000fe40000011605ULL, 0x00005410293c7816ULL, 0x000fe20000000029ULL,
0x0000f0627f007947ULL, 0x000fea000b800000ULL, 0x00001f3d3c297589ULL, 0x0002a400000e0000ULL,
0x000000083d2a7810ULL, 0x000fe20007ffe0ffULL, 0x0000f0927f007947ULL, 0x000fea000b800000ULL,
0x00001f2a3c2a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000103d3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e003cULL,
0x00003e00003e7802ULL, 0x000fc40000000f00ULL, 0x0000fe0000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000183d3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x004fe200078e003cULL, 0x00003e50003e7802ULL, 0x000fc40000000f00ULL,
0x0000fdb000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001595b7824ULL, 0x040fe200078e025bULL, 0x0000000458427810ULL, 0x040fe20007ffe0ffULL,
0x0000001059437824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000084b3c7824ULL, 0x00afe200078e00ffULL, 0x0000000658457810ULL, 0x000fe20007ffe0ffULL,
0x00000001595a7824ULL, 0x000fe200078e025aULL, 0xfffffff043437812ULL, 0x000fe200078ee25bULL,
0x0000001059447824ULL, 0x000fe200078e00ffULL, 0xfffffff83c427812ULL, 0x000fe200078ee242ULL,
0x000000084b4b7824ULL, 0x000fe200078e00ffULL, 0x0000e00043437811ULL, 0x000fc400078e20ffULL,
0x0000a000423c7811ULL, 0x000fe400078e20ffULL, 0xfffffff044447812ULL, 0x000fe200078ee25aULL,
0x000000004350783bULL, 0x000e620000004200ULL, 0xfffffff84b457812ULL, 0x000fe400078ee245ULL,
0x0000e00044447811ULL, 0x000fe200078e20ffULL, 0x000000003c3c783bULL, 0x000ee80000000200ULL,
0x00000000444c783bULL, 0x004ea20000004200ULL, 0x0000312050507816ULL, 0x002fc400000000ffULL,
0x0000312051517816ULL, 0x000fe400000000ffULL, 0x00000050ff46723eULL, 0x080fe200020006ffULL,
0x000000293c3ca232ULL, 0x088fe20000000000ULL, 0x00000051ff47723eULL, 0x080fe200020006ffULL,
0x000000293e3ea232ULL, 0x000fe20000000000ULL, 0x00000050ff50723eULL, 0x000fe200030006ffULL,
0x0000002a3d3da232ULL, 0x080fe20000000000ULL, 0x00000051ff51723eULL, 0x000fe200030006ffULL,
0x0000002a3f3fa232ULL, 0x000fe20000000000ULL, 0x0000312052527816ULL, 0x000fc400000000ffULL,
0x0000312053537816ULL, 0x000fe400000000ffULL, 0x00000052ff54723eULL, 0x080fe400030006ffULL,
0x000000503c10723cULL, 0x040be20000001810ULL, 0x00000053ff55723eULL, 0x080fe400030006ffULL,
0x000031204c4c7816ULL, 0x004fe400000000ffULL, 0x000031204d4d7816ULL, 0x000fe400000000ffULL,
0x00000052ff50723eULL, 0x020fe200020006ffULL, 0x000000463c08723cULL, 0x000be20000001808ULL,
0x00000053ff51723eULL, 0x000fc400020006ffULL, 0x0000004cff58723eULL, 0x080fe400020006ffULL,
0x0000004dff59723eULL, 0x080fe400020006ffULL, 0x0000e00064467811ULL, 0x020fe200078e20ffULL,
0x000000503c0c723cULL, 0x000b62000000180cULL, 0x0000a00045477811ULL, 0x000fe400078e20ffULL,
0x0000004cff4c723eULL, 0x000fe200030006ffULL, 0x000000004650783bULL, 0x020e620000004200ULL,
0x0000004dff4d723eULL, 0x000fc600030006ffULL, 0x000000543c54723cULL, 0x040b640000001814ULL,
0x000000004714783bULL, 0x0204ec0000000200ULL, 0x000000583c58723cULL, 0x000b620000001818ULL,
0x0000e00065477811ULL, 0x004fca00078e20ffULL, 0x000000004760783bULL, 0x000ea20000004200ULL,
0x000031204e187816ULL, 0x020fe400000000ffULL, 0x000031204f197816ULL, 0x000fe400000000ffULL,
0x00000018ff5c723eULL, 0x080fe200020006ffULL, 0x0000004c3c4c723cULL, 0x000f620000001834ULL,
0x00000019ff5d723eULL, 0x080fe400020006ffULL, 0x00000018ff18723eULL, 0x000fe400030006ffULL,
0x00000019ff19723eULL, 0x000fc600030006ffULL, 0x0000005c3c5c723cULL, 0x000b620000001838ULL,
0x0000312052527816ULL, 0x002fce00000000ffULL, 0x000000183c3c723cULL, 0x000b64000000181cULL,
0x0000312051397816ULL, 0x020fe400000000ffULL, 0x0000312050507816ULL, 0x000fe200000000ffULL,
0x000000291414a232ULL, 0x088fe20000000000ULL, 0x00000039ff35723eULL, 0x000fe200020006ffULL,
0x000000291616a232ULL, 0x000fe20000000000ULL, 0x0000312053197816ULL, 0x000fe200000000ffULL,
0x0000002a1515a232ULL, 0x080fe20000000000ULL, 0x00000052ff1c723eULL, 0x000fe200020006ffULL,
0x0000002a1717a232ULL, 0x000fe20000000000ULL, 0x00000019ff1d723eULL, 0x000fc400020006ffULL,
0x00000050ff38723eULL, 0x080fe400030006ffULL, 0x00000039ff39723eULL, 0x000fe400030006ffULL,
0x00000050ff34723eULL, 0x000fe200020006ffULL, 0x0000001c141c723cULL, 0x000b62000000180cULL,
0x0000312060607816ULL, 0x004fe400000000ffULL, 0x0000312062627816ULL, 0x000fe400000000ffULL,
0x0000312063637816ULL, 0x000fc400000000ffULL, 0x00003120610d7816ULL, 0x020fe200000000ffULL,
0x000000381438723cULL, 0x040b620000001810ULL, 0x00000052ff18723eULL, 0x000fe400030006ffULL,
0x00000019ff19723eULL, 0x000fe400030006ffULL, 0x00000060ff0c723eULL, 0x080fe400030006ffULL,
0x0000000dff11723eULL, 0x020fe200020006ffULL, 0x000000341434723cULL, 0x000b620000001808ULL,
0x00000060ff10723eULL, 0x000fc400020006ffULL, 0x0000000dff0d723eULL, 0x000fc800030006ffULL,
0x00000062ff08723eULL, 0x0a0fe200020006ffULL, 0x000000181418723cULL, 0x000b620000001854ULL,
0x00000063ff09723eULL, 0x080fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400030006ffULL,
0x00000063ff63723eULL, 0x000fc600030006ffULL, 0x000000101410723cULL, 0x040b700000001858ULL,
0x0000000c140c723cULL, 0x040b70000000184cULL, 0x000000081408723cULL, 0x040b70000000185cULL,
0x000000621414723cULL, 0x000b62000000183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000024100720cULL, 0x000fe20003f06070ULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4c7224ULL, 0x002fc400078e003dULL,
0x000000ffff3d7224ULL, 0x000fd200078e004aULL, 0x000090c000000947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x0106bc00ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fe4000780484cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc8000001143fULL, 0x0000003e20207211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x0000000220207819ULL, 0x000fc8000000123eULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fe4000780484cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000002041207810ULL, 0x000fe20007ffe0ffULL, 0x00000001073d7824ULL, 0x000fe200078e022bULL,
0x000000022b4d7810ULL, 0x000fe40007ffe0ffULL, 0x00000020023c7217ULL, 0x000fe20007800000ULL,
0x000000013d3e7824ULL, 0x000fe200078e0205ULL, 0x000000042b537810ULL, 0x000fe20007ffe0ffULL,
0x000000103d517824ULL, 0x000fe200078e00ffULL, 0x000000062b557810ULL, 0x000fe20007ffe0ffULL,
0x000000013c3c7824ULL, 0x000fe200078e0a20ULL, 0x0000006006207811ULL, 0x000fe200078e38ffULL,
0x00000001073f7824ULL, 0x000fe200078e024dULL, 0xfffffff051517812ULL, 0x000fe200078ee23eULL,
0x00000001074b7824ULL, 0x040fe200078e0253ULL, 0x0000003c073c7217ULL, 0x000fe20007800000ULL,
0x000000013f3e7824ULL, 0x100fe200078e0205ULL, 0x000000f025507812ULL, 0x000fe200078ec0ffULL,
0x000000103f527824ULL, 0x000fe200078e00ffULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000014b4c7824ULL, 0x000fc400078e0205ULL, 0x000000104b547824ULL, 0x000fe200078e00ffULL,
0xfffffff052527812ULL, 0x000fe200078ee23eULL, 0x000000013d3d7824ULL, 0x100fe400078e0220ULL,
0x000000014b3e7824ULL, 0x000fe200078e0220ULL, 0xfffffff054547812ULL, 0x000fe200078ee24cULL,
0x00000001074c7824ULL, 0x000fe200078e0255ULL, 0x0000003d494f7210ULL, 0x000fe20007f1e0ffULL,
0x000000013f3d7824ULL, 0x100fe200078e0220ULL, 0x0000003e493e7210ULL, 0x040fe20007f7e0ffULL,
0x000000014c3f7824ULL, 0x000fe200078e0220ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000014c4e7824ULL, 0x040fe200078e0205ULL, 0x0000003d493d7210ULL, 0x040fe20007f9e0ffULL,
0x000000104c567824ULL, 0x000fe200078e00ffULL, 0x0000003f493f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200000e06ffULL, 0x00005e004f4c7a11ULL, 0x040fe200078040ffULL,
0x000000013c207824ULL, 0x000fe200078e0a07ULL, 0xfffffff056567812ULL, 0x000fe200078ee24eULL,
0x000000ffff4e7224ULL, 0x000fe200020e06ffULL, 0x00005f004f4f7a11ULL, 0x000fe200000f444bULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x000000204d00720cULL, 0x000fc40003f06070ULL,
0x00005e003d4d7a11ULL, 0x000fe400078c40ffULL, 0x00005e003e497a11ULL, 0x040fe400078a40ffULL,
0x000000202b00720cULL, 0x000fe40003f86070ULL, 0x00005f003d4e7a11ULL, 0x000fe400030f444eULL,
0x00005f003e4b7a11ULL, 0x000fe200028f444bULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x000000504c3c7210ULL, 0x000fc40007fde0ffULL, 0x00005e003f4c7a11ULL, 0x000fe400078a40ffULL,
0x000000205300720cULL, 0x080fe20003f66070ULL, 0x000000ffff3d7224ULL, 0x000fe200030e064fULL,
0x000000205500720cULL, 0x000fe40003f46070ULL, 0x00005f003f207a11ULL, 0x000fe400028f443eULL,
0x000000504d3e7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c517faeULL, 0x0003e2000e101c46ULL, 0x0000e00054547811ULL, 0x000fc400078e20ffULL,
0x0000e00056567811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e064eULL,
0x000000504c4c7210ULL, 0x000fc80007fbe0ffULL, 0x000000003e527faeULL, 0x0005e2000c101c46ULL,
0x000000ffff4d7224ULL, 0x000fe200028e0620ULL, 0x00000050493c7210ULL, 0x002fca0007f9e0ffULL,
0x000000ffff3d7224ULL, 0x000fca00020e064bULL, 0x000000003c547faeULL, 0x0005e8000d901c46ULL,
0x000000004c567faeULL, 0x0005e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000107207824ULL, 0x000fe200078e022bULL, 0x00000060063d7811ULL, 0x000fe400078e38ffULL,
0x000000f025507812ULL, 0x000fe200078ec0ffULL, 0x00000001203c7824ULL, 0x040fe200078e0205ULL,
0x00000002203f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001020517824ULL, 0x040fe200078e00ffULL,
0x00000004204b7810ULL, 0x000fc40007ffe0ffULL, 0x00000006204c7810ULL, 0x040fe20007ffe0ffULL,
0x000000013f3e7824ULL, 0x000fe200078e0205ULL, 0xfffffff051517812ULL, 0x000fe200078ee23cULL,
0x000000103f527824ULL, 0x000fe400078e00ffULL, 0x00000001203c7824ULL, 0x100fe200078e023dULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000013f207824ULL, 0x000fe200078e023dULL,
0xfffffff052527812ULL, 0x000fe200078ee23eULL, 0x000000014b3f7824ULL, 0x000fe200078e0205ULL,
0x0000003c493e7210ULL, 0x000fe20007f7e0ffULL, 0x000000014b3c7824ULL, 0x100fe200078e023dULL,
0x00000020494d7210ULL, 0x000fe20007f1e0ffULL, 0x000000014c3d7824ULL, 0x000fe200078e023dULL,
0x00005e003e4e7a11ULL, 0x000fe200078840ffULL, 0x000000104b537824ULL, 0x000fe200078e00ffULL,
0x0000003c493c7210ULL, 0x000fe20007f5e0ffULL, 0x000000014c4b7824ULL, 0x000fc400078e0205ULL,
0x000000104c547824ULL, 0x000fe200078e00ffULL, 0xfffffff053537812ULL, 0x000fe200078ee23fULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0x0000003d493d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0xfffffff054547812ULL, 0x000fe200078ee24bULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0x00005f003e4f7a11ULL, 0x000fe200020f4420ULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x00005e004d207a11ULL, 0x000fe400078040ffULL,
0x00005e003c3e7a11ULL, 0x000fc400078440ffULL, 0x00005e003d4c7a11ULL, 0x000fe400078640ffULL,
0x000000504e4e7210ULL, 0x080fe40007f9e0ffULL, 0x00005f004d497a11ULL, 0x000fe400000f4449ULL,
0x00005f003c3f7a11ULL, 0x000fe200010f443fULL, 0x000000ffff4f7224ULL, 0x000fe200020e064fULL,
0x00005f003d4b7a11ULL, 0x000fe400018f444bULL, 0x00000050203c7210ULL, 0x000fc40007f1e0ffULL,
0x000000503e3e7210ULL, 0x080fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004e517faeULL, 0x0003e2000b901c46ULL, 0x000000504c4c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0649ULL, 0x0000e00052207811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e063fULL, 0x0000e00053497811ULL, 0x000fe200078e20ffULL,
0x000000ffff4d7224ULL, 0x000fe200018e064bULL, 0x0000e000544b7811ULL, 0x000fe200078e20ffULL,
0x000000003c207faeULL, 0x0003e8000b901c46ULL, 0x000000003e497faeULL, 0x0003e8000b901c46ULL,
0x000000004c4b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000140207810ULL, 0x000fc80007ffe0ffULL, 0x000000032000720cULL, 0x000fe20003f06070ULL,
0xffffffffff207424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001223c7810ULL, 0x004fe20007ffe040ULL, 0x00000004ff3d7424ULL, 0x000fc800078e00ffULL,
0x000060003c3c7625ULL, 0x000fca00078e003dULL, 0x000000063c207981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff4c7f8cULL, 0x004ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01062800074e7f8cULL, 0x000664000c80043fULL,
0x00000000003c7805ULL, 0x002fc40000015200ULL, 0x01062c00073e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe4000780484fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c497210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004900780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404900780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000493e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01062c00073e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe4000780484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010080002c3c7984ULL, 0x000e680000000800ULL,
0x010280002c497984ULL, 0x0006a20000000800ULL, 0x0000004a3c00720bULL, 0x002fe20003f1d000ULL,
0x0000db027f007947ULL, 0x000fd8000b800000ULL, 0x00000000004b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff4bff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4e7424ULL, 0x000fc400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fd200078e004aULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x0000004a3c00720bULL, 0x000fe20003f54000ULL, 0x0000dac27f007947ULL, 0x000fd8000b800000ULL,
0x00000000003d7806ULL, 0x000fc400010e0100ULL, 0x0000004a3c3e8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0104803e2c008388ULL, 0x0003e40000000800ULL,
0x000099103d3e7816ULL, 0x002fc800000000ffULL, 0x000000ff3e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004a3c3e7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff3dff7812ULL, 0x000fc6000780c0ffULL,
0x0000004a3e3e7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b3e3e7820ULL, 0x000fc80000410000ULL,
0x0000003e004f7308ULL, 0x000e640000000800ULL, 0x0000004f21217220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3e7819ULL, 0x000fe20000011605ULL,
0x0000da027f007947ULL, 0x000fea000b800000ULL, 0x00001f3e4f3e7589ULL, 0x0002e400000e0000ULL,
0x0000003e34347220ULL, 0x088fe20000410000ULL, 0x0000003e35357220ULL, 0x080fe20000410000ULL,
0x0000003e38387220ULL, 0x080fe20000410000ULL, 0x0000003e39397220ULL, 0x080fe20000410000ULL,
0x0000003e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003e18187220ULL, 0x080fe20000410000ULL, 0x0000003e19197220ULL, 0x080fe20000410000ULL,
0x0000003e10107220ULL, 0x080fe20000410000ULL, 0x0000003e11117220ULL, 0x080fe20000410000ULL,
0x0000003e0c0c7220ULL, 0x080fe20000410000ULL, 0x0000003e0d0d7220ULL, 0x080fe20000410000ULL,
0x0000003e08087220ULL, 0x080fe20000410000ULL, 0x0000003e09097220ULL, 0x080fe20000410000ULL,
0x0000003e14147220ULL, 0x080fe20000410000ULL, 0x0000003e15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff003dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008053e7811ULL, 0x000fe200078ff0ffULL,
0x0000d9027f007947ULL, 0x000fea000b800000ULL, 0x00001f3e4f3e7589ULL, 0x00066400000e0000ULL,
0x0000003e36367220ULL, 0x082fe20000410000ULL, 0x0000003e37377220ULL, 0x080fe20000410000ULL,
0x0000003e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000003e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000003e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003e1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003e12127220ULL, 0x080fe20000410000ULL, 0x0000003e13137220ULL, 0x080fe20000410000ULL,
0x0000003e0e0e7220ULL, 0x080fe20000410000ULL, 0x0000003e0f0f7220ULL, 0x080fe20000410000ULL,
0x0000003e0a0a7220ULL, 0x080fe20000410000ULL, 0x0000003e0b0b7220ULL, 0x080fe20000410000ULL,
0x0000003e16167220ULL, 0x080fe20000410000ULL, 0x0000003e17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff3dff7812ULL, 0x000fe2000780084bULL,
0x00000001ff4e7424ULL, 0x000fe200078e00ffULL, 0x0000004a3c4a7209ULL, 0x000fca0007810000ULL,
0x000000ffff3d7224ULL, 0x000fcc00078e004aULL, 0x8000004a3c3c0221ULL, 0x100fe20000010000ULL,
0x000000ffff3d0224ULL, 0x000fe200078e004aULL, 0x00007610ff4e0816ULL, 0x000fe4000000004eULL,
0x3fb8aa3b3c3c0820ULL, 0x000fc80000410000ULL, 0x0000003c00280308ULL, 0x000e640000000800ULL,
0x0000002849490220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002149217221ULL, 0x004fc20000010000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff3c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4f7224ULL, 0x008fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a3e497210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e3fULL, 0x003d09004900780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404900780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001144aULL,
0x000000493c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff497224ULL, 0x000fca00000e064aULL,
0x000000023c3c7819ULL, 0x000fc80000001249ULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014f4f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104e3c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff3c00720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000028ff29723eULL, 0x000fe400000000ffULL, 0x00000002ff487819ULL, 0x000fe40000011605ULL,
0x00005410293c7816ULL, 0x000fe20000000029ULL, 0x0000d4d27f007947ULL, 0x000fea000b800000ULL,
0x00001f483c297589ULL, 0x0002a400000e0000ULL, 0x00000008482a7810ULL, 0x000fe20007ffe0ffULL,
0x0000d5027f007947ULL, 0x000fea000b800000ULL, 0x00001f2a3c2a7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010483f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e003cULL, 0x00005bb0003e7802ULL, 0x000fc40000000f00ULL,
0x0000e05000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018483f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e003cULL,
0x00005c00003e7802ULL, 0x000fc40000000f00ULL, 0x0000e00000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000a8002e487811ULL, 0x002fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002f58783bULL, 0x000e680000004200ULL,
0x000000004848783bULL, 0x000ee80000000200ULL, 0x000000003054783bULL, 0x000ea80000004200ULL,
0x000000003364783bULL, 0x000ea20000004200ULL, 0x0000312058587816ULL, 0x002fc400000000ffULL,
0x0000312059597816ULL, 0x000fe200000000ffULL, 0x000000294848a232ULL, 0x08cfe20000000000ULL,
0x00000058ff50723eULL, 0x080fe200020006ffULL, 0x000000294a4aa232ULL, 0x000fe20000000000ULL,
0x00000059ff51723eULL, 0x000fe200020006ffULL, 0x0000002a4949a232ULL, 0x080fe20000000000ULL,
0x000031205a5a7816ULL, 0x000fe200000000ffULL, 0x0000002a4b4ba232ULL, 0x000fe20000000000ULL,
0x000031205b3f7816ULL, 0x000fe400000000ffULL, 0x00000058ff58723eULL, 0x000fc400030006ffULL,
0x00000059ff59723eULL, 0x000fe400030006ffULL, 0x000000504850723cULL, 0x040be20000001834ULL,
0x0000005aff3e723eULL, 0x080fe400030006ffULL, 0x0000312054547816ULL, 0x000fe400000000ffULL,
0x0000312055557816ULL, 0x000fe400000000ffULL, 0x0000005aff34723eULL, 0x020fe200020006ffULL,
0x000000584838723cULL, 0x000b620000001838ULL, 0x0000003fff35723eULL, 0x000fe200020006ffULL,
0x000000003258783bULL, 0x020e620000004200ULL, 0x00000054ff5c723eULL, 0x000fc400020006ffULL,
0x00000055ff5d723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe200030006ffULL,
0x00000034481c723cULL, 0x040b62000000181cULL, 0x00000054ff54723eULL, 0x000fe400030006ffULL,
0x00000055ff55723eULL, 0x000fe400030006ffULL, 0x0000312064647816ULL, 0x000fe400000000ffULL,
0x0000a80031347811ULL, 0x020fe200078e20ffULL, 0x0000005c485c723cULL, 0x000be20000001810ULL,
0x0000312065657816ULL, 0x000fc400000000ffULL, 0x0000312066667816ULL, 0x000fe400000000ffULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x0000312067677816ULL, 0x000fe400000000ffULL,
0x0000312056107816ULL, 0x020fe200000000ffULL, 0x0000003e4818723cULL, 0x000f620000001818ULL,
0x0000312057117816ULL, 0x000fe400000000ffULL, 0x00000010ff60723eULL, 0x000fe400020006ffULL,
0x00000011ff61723eULL, 0x000fc400020006ffULL, 0x00000010ff10723eULL, 0x000fe200030006ffULL,
0x000000544854723cULL, 0x000b62000000180cULL, 0x00000011ff11723eULL, 0x000fcc00030006ffULL,
0x00000064ff0c723eULL, 0x020fe200020006ffULL, 0x000000604860723cULL, 0x040b620000001808ULL,
0x0000312058587816ULL, 0x002fe400000000ffULL, 0x000031205a5a7816ULL, 0x000fe400000000ffULL,
0x00000065ff0d723eULL, 0x000fe400020006ffULL, 0x000031205b097816ULL, 0x020fe200000000ffULL,
0x000000104848723cULL, 0x000b620000001814ULL, 0x0000005aff08723eULL, 0x000fcc00030006ffULL,
0x0000312059157816ULL, 0x020fe400000000ffULL, 0x00000058ff14723eULL, 0x080fe400030006ffULL,
0x00000015ff11723eULL, 0x080fe200020006ffULL, 0x000000293434a232ULL, 0x084fe20000000000ULL,
0x00000015ff15723eULL, 0x000fe200030006ffULL, 0x000000293636a232ULL, 0x000fe20000000000ULL,
0x00000058ff10723eULL, 0x000fe200020006ffULL, 0x0000002a3535a232ULL, 0x080fe40000000000ULL,
0x0000002a3737a232ULL, 0x000fce0000000000ULL, 0x000000143414723cULL, 0x040b6e0000001838ULL,
0x00000009ff39723eULL, 0x0a0fe200020006ffULL, 0x000000103410723cULL, 0x000f620000001850ULL,
0x0000005aff38723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fca00030006ffULL,
0x000000383438723cULL, 0x040b6e000000181cULL, 0x00000066ff1c723eULL, 0x0a0fe200020006ffULL,
0x000000083408723cULL, 0x000b620000001818ULL, 0x00000067ff1d723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fc400030006ffULL, 0x00000067ff67723eULL, 0x000fe400030006ffULL,
0x00000064ff18723eULL, 0x020fe200030006ffULL, 0x0000000c340c723cULL, 0x000b62000000185cULL,
0x00000065ff19723eULL, 0x000fce00030006ffULL, 0x000000183418723cULL, 0x040b700000001854ULL,
0x0000001c341c723cULL, 0x040b700000001860ULL, 0x000000663434723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff4a7f8cULL, 0x020e64000c80043fULL, 0x00000000003e7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff3c7984ULL, 0x000ea40000000800ULL, 0x800000003cff7812ULL, 0x006fc4000780484bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x000000483e487210ULL, 0x000fca0007f1e1ffULL,
0x0000000149497824ULL, 0x000fe200000e0e3fULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc80000011449ULL,
0x000000483c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff487224ULL, 0x000fca00000e0649ULL,
0x000000023c3c7819ULL, 0x000fc80000001248ULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00005800203c7a24ULL, 0x010fc800078e02ffULL, 0x000000803c3c7824ULL, 0x000fe200078e00ffULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000040413e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107487824ULL, 0x000fe200078e022bULL, 0x000000022b547810ULL, 0x040fe40007ffe0ffULL,
0x0000003e023f7217ULL, 0x000fe20007800000ULL, 0x0000008006517824ULL, 0x000fe200078e0248ULL,
0x000000042b567810ULL, 0x000fe20007ffe0ffULL, 0x0000000148497824ULL, 0x040fe200078e0205ULL,
0x000000f025527812ULL, 0x000fe200078ec0ffULL, 0x0000001048537824ULL, 0x000fe200078e00ffULL,
0x0000003c514e7210ULL, 0x080fe20007f1e0ffULL, 0x0000000107487824ULL, 0x000fe200078e0254ULL,
0x0000000251507810ULL, 0x000fe20007ffe0ffULL, 0x000000013f3f7824ULL, 0x000fe200078e0a3eULL,
0xfffffff053537812ULL, 0x000fe200078ee249ULL, 0x00000001073e7824ULL, 0x000fe200078e0256ULL,
0x00000004514f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000148497824ULL, 0x140fe200078e0205ULL,
0x0000003f073f7217ULL, 0x000fe20007800000ULL, 0x0000001048557824ULL, 0x000fe200078e00ffULL,
0x0000003c4f4f7210ULL, 0x000fe20007f7e0ffULL, 0x000000013e487824ULL, 0x040fe200078e0205ULL,
0x0000c00053537811ULL, 0x000fe200078e20ffULL, 0x000000103e577824ULL, 0x000fe200078e00ffULL,
0xfffffff055557812ULL, 0x000fe200078ee249ULL, 0x000000ffff3e7224ULL, 0x000fe200000e06ffULL,
0x00005e004e4b7a11ULL, 0x040fe200078040ffULL, 0x000000013f497824ULL, 0x000fe200078e0a07ULL,
0xfffffff057577812ULL, 0x000fe200078ee248ULL, 0x000000ffff3f7224ULL, 0x000fe200018e06ffULL,
0x00005f004e4e7a11ULL, 0x000fc400000f443eULL, 0x0000003c50507210ULL, 0x000fe40007f1e0ffULL,
0x000000492b00720cULL, 0x000fe40003f86070ULL, 0x00005e004f487a11ULL, 0x040fe200078a40ffULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e00504a7a11ULL, 0x040fe400078040ffULL,
0x00005f004f4f7a11ULL, 0x000fe400028f443fULL, 0x00005f0050507a11ULL, 0x000fc400000f443eULL,
0x000000524b3e7210ULL, 0x000fe40007f7e0ffULL, 0x000000495400720cULL, 0x080fe40003f06070ULL,
0x000000062b547810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e064eULL,
0x00000006514b7810ULL, 0x000fe40007ffe0ffULL, 0x000000495600720cULL, 0x000fe20003f66070ULL,
0x00000001074e7824ULL, 0x000fe200078e0254ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e537faeULL, 0x0003e2000e101c46ULL, 0x0000003c4b4b7210ULL, 0x000fc40007f9e0ffULL,
0x000000014e517824ULL, 0x000fe200078e0205ULL, 0x0000005248487210ULL, 0x080fe40007fde0ffULL,
0x0000c00055557811ULL, 0x000fe400078e20ffULL, 0x0000c00057577811ULL, 0x000fe400078e20ffULL,
0x000000524a3e7210ULL, 0x002fe20007fbe0ffULL, 0x000000104e537824ULL, 0x000fe400078e00ffULL,
0x000000ffff4e7224ULL, 0x000fe200020e06ffULL, 0x00005e004b4a7a11ULL, 0x040fe200078840ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e0650ULL, 0x000000495400720cULL, 0x000fe20003fa6070ULL,
0x000000ffff497224ULL, 0x000fe200030e064fULL, 0x00005f004b4b7a11ULL, 0x000fc400020f444eULL,
0x000000524a4a7210ULL, 0x000fe20007f9e0ffULL, 0x000000003e557faeULL, 0x0003e2000c101c46ULL,
0xfffffff053517812ULL, 0x000fc600078ee251ULL, 0x000000ffff4b7224ULL, 0x000fe200020e064bULL,
0x0000c00051517811ULL, 0x000fe200078e20ffULL, 0x0000000048577faeULL, 0x0003e8000d901c46ULL,
0x000000004a517faeULL, 0x0003e2000e901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x00000001073e7824ULL, 0x000fc800078e022bULL, 0x000000013e3f7824ULL, 0x040fe200078e0205ULL,
0x000000023e487810ULL, 0x040fe20007ffe0ffULL, 0x000000103e4a7824ULL, 0x000fc800078e00ffULL,
0x0000000148497824ULL, 0x000fe200078e0205ULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee23fULL,
0x0000001048507824ULL, 0x000fe200078e00ffULL, 0x000000043e487810ULL, 0x000fe20007ffe0ffULL,
0x00000080063f7824ULL, 0x000fc600078e023eULL, 0xfffffff050507812ULL, 0x000fe200078ee249ULL,
0x00000001484b7824ULL, 0x100fe200078e0205ULL, 0x000000063e497810ULL, 0x000fe20007ffe0ffULL,
0x0000001048547824ULL, 0x000fe200078e00ffULL, 0x0000003c3f3e7210ULL, 0x000fe40007f1e0ffULL,
0x0000c00050507811ULL, 0x000fe200078e20ffULL, 0x00000001494e7824ULL, 0x040fe200078e0205ULL,
0xfffffff054547812ULL, 0x000fe200078ee24bULL, 0x0000001049587824ULL, 0x000fe200078e00ffULL,
0x000000023f4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff487224ULL, 0x000fe200000e06ffULL,
0x00005e003e497a11ULL, 0x000fc400078040ffULL, 0xfffffff058587812ULL, 0x000fe400078ee24eULL,
0x00005f003e487a11ULL, 0x000fe400000f4448ULL, 0x000000043f3e7810ULL, 0x040fe40007ffe0ffULL,
0x000000063f3f7810ULL, 0x000fe40007ffe0ffULL, 0x0000003c4b4b7210ULL, 0x080fe40007f1e0ffULL,
0x0000003c3e517210ULL, 0x000fc40007f7e0ffULL, 0x000000f0254e7812ULL, 0x000fe400078ec0ffULL,
0x0000003c3f557210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e06ffULL,
0x00005e004b4f7a11ULL, 0x000fe200078040ffULL, 0x000000ffff527224ULL, 0x000fe200018e06ffULL,
0x0000004e493e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff567224ULL, 0x000fe200028e06ffULL,
0x00005e0051537a11ULL, 0x000fe400078840ffULL, 0x00005e0055577a11ULL, 0x000fc400078a40ffULL,
0x00005f004b4b7a11ULL, 0x000fe200000f443fULL, 0x000000ffff3f7224ULL, 0x000fe200018e0648ULL,
0x0000c0004a497811ULL, 0x000fe400078e20ffULL, 0x0000004e4f487210ULL, 0x080fe40007f1e0ffULL,
0x00005f0051527a11ULL, 0x000fe200020f4452ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e497faeULL, 0x0003e2000b901c46ULL, 0x0000004e534a7210ULL, 0x000fe40007f7e0ffULL,
0x00005f0055567a11ULL, 0x000fc400028f4456ULL, 0x0000004e574e7210ULL, 0x000fe40007f9e0ffULL,
0x0000c00054547811ULL, 0x000fe400078e20ffULL, 0x0000c00058587811ULL, 0x000fe200078e20ffULL,
0x000000ffff4f7224ULL, 0x000fe400020e0656ULL, 0x000000ffff497224ULL, 0x002fe400000e064bULL,
0x000000ffff4b7224ULL, 0x000fc600018e0652ULL, 0x0000000048507faeULL, 0x0003e8000b901c46ULL,
0x000000004a547faeULL, 0x0003e8000b901c46ULL, 0x000000004e587faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff487f8cULL, 0x000e64000c80043fULL, 0x000000ffff487224ULL, 0x002fc400078e0049ULL,
0x00000000003e7805ULL, 0x000fca0000015200ULL, 0x0106b400ff497984ULL, 0x000e640000000800ULL,
0x8000000049ff7812ULL, 0x002fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a3e4a7210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4b7824ULL, 0x000fe200000e0e3fULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff497819ULL, 0x000fc8000001144bULL, 0x0000004a49497211ULL, 0x000fca00078110ffULL,
0x000000ffff4a7224ULL, 0x000fca00000e064bULL, 0x0000000249497819ULL, 0x000fc8000000124aULL,
0x000000490000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff497984ULL, 0x000e640000000800ULL, 0x8000000049ff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000028ff29723eULL, 0x000fe400000000ffULL,
0x00000002ff4a7819ULL, 0x000fe40000011605ULL, 0x0000541029497816ULL, 0x000fe20000000029ULL,
0x0000c1c27f007947ULL, 0x000fea000b800000ULL, 0x00001f4a49297589ULL, 0x0002a400000e0000ULL,
0x000000084a2a7810ULL, 0x000fe20007ffe0ffULL, 0x0000c1f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a492a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000104a3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0049ULL,
0x00006f80003e7802ULL, 0x000fc40000000f00ULL, 0x0000cc8000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000184a3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x004fe200078e0049ULL, 0x00006fd0003e7802ULL, 0x000fc40000000f00ULL,
0x0000cc3000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a800424c7811ULL, 0x000fc400078e20ffULL,
0x000000004354783bULL, 0x000f280000004200ULL, 0x000000004c4c783bULL, 0x004ea80000000200ULL,
0x000000004450783bULL, 0x000ee80000004200ULL, 0x000000004760783bULL, 0x000e620000004200ULL,
0x0000312054547816ULL, 0x010fc400000000ffULL, 0x0000312055557816ULL, 0x000fe200000000ffULL,
0x000000294c4ca232ULL, 0x084fe20000000000ULL, 0x00000054ff3e723eULL, 0x080fe200020006ffULL,
0x000000294e4ea232ULL, 0x000fe20000000000ULL, 0x00000055ff3f723eULL, 0x080fe200020006ffULL,
0x0000002a4d4da232ULL, 0x082fe20000000000ULL, 0x00000054ff54723eULL, 0x000fe200030006ffULL,
0x0000002a4f4fa232ULL, 0x000fe20000000000ULL, 0x00000055ff55723eULL, 0x000fe400030006ffULL,
0x0000312050507816ULL, 0x008fc400000000ffULL, 0x0000312051517816ULL, 0x000fe400000000ffULL,
0x0000003e4c10723cULL, 0x000b620000001810ULL, 0x0000312060607816ULL, 0x000fe400000000ffULL,
0x0000312061617816ULL, 0x000fe400000000ffULL, 0x0000312062627816ULL, 0x000fe400000000ffULL,
0x00003120563e7816ULL, 0x020fe400000000ffULL, 0x00003120573f7816ULL, 0x000fc400000000ffULL,
0x0000003eff58723eULL, 0x080fe200020006ffULL, 0x000000544c54723cULL, 0x040b620000001814ULL,
0x0000003fff59723eULL, 0x080fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400030006ffULL,
0x0000003fff3f723eULL, 0x000fe400030006ffULL, 0x0000a80045147811ULL, 0x020fe200078e20ffULL,
0x000000584c58723cULL, 0x040b620000001838ULL, 0x0000312063637816ULL, 0x000fe200000000ffULL,
0x000000004638783bULL, 0x020e680000004200ULL, 0x000000001414783bULL, 0x000ea40000000200ULL,
0x0000003e4c08723cULL, 0x000b6e0000001808ULL, 0x00000050ff3e723eULL, 0x020fc400020006ffULL,
0x00000051ff3f723eULL, 0x080fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400030006ffULL,
0x00000051ff51723eULL, 0x000fc600030006ffULL, 0x0000003e4c0c723cULL, 0x040b6e000000180cULL,
0x00003120523e7816ULL, 0x020fe400000000ffULL, 0x00003120533f7816ULL, 0x000fe400000000ffULL,
0x0000003eff5c723eULL, 0x000fe200020006ffULL, 0x000000504c50723cULL, 0x000fe20000001818ULL,
0x0000003fff5d723eULL, 0x000fc400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400030006ffULL,
0x0000003fff3f723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x002fe200000000ffULL,
0x0000005c4c5c723cULL, 0x000f62000000181cULL, 0x0000312039397816ULL, 0x000fe200000000ffULL,
0x000000291414a232ULL, 0x084fe40000000000ULL, 0x000000291616a232ULL, 0x000fe40000000000ULL,
0x0000002a1515a232ULL, 0x000fc40000000000ULL, 0x0000003e4c4c723cULL, 0x000b620000001834ULL,
0x0000002a1717a232ULL, 0x000fcc0000000000ULL, 0x00000038ff34723eULL, 0x0a0fe400020006ffULL,
0x00000039ff35723eULL, 0x080fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400030006ffULL,
0x00000039ff39723eULL, 0x000fc600030006ffULL, 0x000000341434723cULL, 0x040b6e0000001810ULL,
0x000031203a107816ULL, 0x020fe400000000ffULL, 0x000031203b117816ULL, 0x000fe400000000ffULL,
0x00000010ff1c723eULL, 0x000fe200020006ffULL, 0x000000381438723cULL, 0x000f620000001854ULL,
0x00000011ff1d723eULL, 0x000fc400020006ffULL, 0x00000010ff10723eULL, 0x000fe400030006ffULL,
0x00000011ff11723eULL, 0x000fc600030006ffULL, 0x0000001c141c723cULL, 0x040f700000001858ULL,
0x000000101418723cULL, 0x000b6e0000001808ULL, 0x00000060ff10723eULL, 0x020fc400020006ffULL,
0x00000061ff11723eULL, 0x000fe400020006ffULL, 0x00000062ff08723eULL, 0x080fe400020006ffULL,
0x00000063ff09723eULL, 0x080fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe200030006ffULL,
0x000000101410723cULL, 0x000b62000000180cULL, 0x00000063ff63723eULL, 0x000fcc00030006ffULL,
0x00000060ff0c723eULL, 0x020fe200030006ffULL, 0x000000081408723cULL, 0x000b62000000185cULL,
0x00000061ff0d723eULL, 0x000fce00030006ffULL, 0x0000000c140c723cULL, 0x040b700000001850ULL,
0x000000621414723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000040413e7810ULL, 0x002fe20007ffe0ffULL,
0x01069000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4c7224ULL, 0x020fe200078e003fULL,
0x0000000140407810ULL, 0x000fc40007ffe0ffULL, 0x000000023e00720cULL, 0x000fda0003f06070ULL,
0x0000603000000947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff407984ULL, 0x000e640000000800ULL, 0x8000000040ff7812ULL, 0x002fe4000780484cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a3e497210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e3fULL, 0x003d09004900780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404900780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff407819ULL, 0x000fc8000001144aULL,
0x0000004940407211ULL, 0x000fca00078110ffULL, 0x000000ffff497224ULL, 0x000fca00000e064aULL,
0x0000000240407819ULL, 0x000fc80000001249ULL, 0x000000400000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014d4d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff407984ULL, 0x000e640000000800ULL,
0x8000000040ff7812ULL, 0x002fe4000780484cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x00000060413e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107407824ULL, 0x000fe200078e022bULL, 0x000000022b4b7810ULL, 0x040fe40007ffe0ffULL,
0x0000003e023f7217ULL, 0x000fe20007800000ULL, 0x0000000140497824ULL, 0x040fe200078e0205ULL,
0x000000042b4c7810ULL, 0x040fe20007ffe0ffULL, 0x0000001040527824ULL, 0x000fe200078e00ffULL,
0x000000062b557810ULL, 0x000fe20007ffe0ffULL, 0x000000013f3f7824ULL, 0x000fe200078e0a3eULL,
0x00000020063e7811ULL, 0x000fe200078e38ffULL, 0x00000001074a7824ULL, 0x040fe200078e024cULL,
0xfffffff052527812ULL, 0x000fe200078ee249ULL, 0x0000000107497824ULL, 0x040fe200078e024bULL,
0x0000003f073f7217ULL, 0x000fe20007800000ULL, 0x0000000140507824ULL, 0x100fe200078e023eULL,
0x000000f025517812ULL, 0x000fe200078ec0ffULL, 0x00000001074e7824ULL, 0x000fe200078e0255ULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x00000001494f7824ULL, 0x040fe200078e023eULL,
0x0000003c50507210ULL, 0x000fe20007f1e0ffULL, 0x0000000149407824ULL, 0x000fc400078e0205ULL,
0x0000001049537824ULL, 0x000fe200078e00ffULL, 0x0000003c4f4f7210ULL, 0x080fe20007f5e0ffULL,
0x000000014a4d7824ULL, 0x040fe400078e023eULL, 0x000000014a497824ULL, 0x140fe200078e0205ULL,
0xfffffff053537812ULL, 0x000fe200078ee240ULL, 0x000000104a547824ULL, 0x000fe200078e00ffULL,
0x0000003c4d4d7210ULL, 0x000fe20007f7e0ffULL, 0x000000014e567824ULL, 0x040fe200078e023eULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000014e3e7824ULL, 0x000fe200078e0205ULL,
0xfffffff054547812ULL, 0x000fe200078ee249ULL, 0x000000104e577824ULL, 0x000fc400078e00ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005e00504a7a11ULL, 0x040fe200078040ffULL,
0x000000013f407824ULL, 0x000fe200078e0a07ULL, 0xfffffff057577812ULL, 0x000fe200078ee23eULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x00005e004f4e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x00005f0050507a11ULL, 0x000fe400000f4449ULL,
0x000000404b00720cULL, 0x000fe40003f06070ULL, 0x00005f004f4f7a11ULL, 0x000fc400010f443eULL,
0x0000003c56497210ULL, 0x000fe40007fde0ffULL, 0x00005e004d4b7a11ULL, 0x000fe400078a40ffULL,
0x000000402b00720cULL, 0x080fe40003f46070ULL, 0x000000514a3e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x000000404c00720cULL, 0x000fe40003f66070ULL,
0x00005f004d4d7a11ULL, 0x000fe200028f443fULL, 0x000000ffff3f7224ULL, 0x000fe200020e0650ULL,
0x00005e00494c7a11ULL, 0x000fc400078a40ffULL, 0x000000405500720cULL, 0x000fe40003f86070ULL,
0x00005f0049407a11ULL, 0x000fe200028f444aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e527faeULL, 0x0003e2000d101c46ULL, 0x000000514e4a7210ULL, 0x080fe40007fbe0ffULL,
0x0000e00054547811ULL, 0x000fe400078e20ffULL, 0x0000e00057577811ULL, 0x000fe400078e20ffULL,
0x000000514b3e7210ULL, 0x082fe20007f5e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200028e064fULL,
0x000000514c4c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e064dULL,
0x000000004a537faeULL, 0x0003e2000c101c46ULL, 0x000000ffff4d7224ULL, 0x000fc600028e0640ULL,
0x000000003e547faeULL, 0x0003e8000d901c46ULL, 0x000000004c577faeULL, 0x0003e2000e101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x00000001073e7824ULL, 0x000fe200078e022bULL,
0x0000002006407811ULL, 0x000fe400078e38ffULL, 0x000000f025517812ULL, 0x000fe200078ec0ffULL,
0x000000013e497824ULL, 0x040fe200078e0205ULL, 0x000000023e4a7810ULL, 0x040fe20007ffe0ffULL,
0x000000103e527824ULL, 0x040fe200078e00ffULL, 0x000000043e4c7810ULL, 0x040fe20007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe200078e0240ULL, 0x000000063e4e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001403e7824ULL, 0x000fe200078e024aULL, 0xfffffff052527812ULL, 0x000fe200078ee249ULL,
0x000000014a4b7824ULL, 0x040fe200078e0205ULL, 0x0000003c3f497210ULL, 0x000fe20007f1e0ffULL,
0x000000104a537824ULL, 0x000fe200078e00ffULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x00000001403f7824ULL, 0x000fc400078e024cULL, 0x000000014c4d7824ULL, 0x040fe200078e0205ULL,
0xfffffff053537812ULL, 0x000fe200078ee24bULL, 0x000000104c547824ULL, 0x000fe200078e00ffULL,
0x0000003f3c3f7210ULL, 0x000fe20007f5e0ffULL, 0x0000000140407824ULL, 0x000fe200078e024eULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000014e4c7824ULL, 0x000fe200078e0205ULL,
0xfffffff054547812ULL, 0x000fe200078ee24dULL, 0x000000104e557824ULL, 0x000fe200078e00ffULL,
0x000000403c407210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0x00005e00494e7a11ULL, 0x000fc400078040ffULL, 0xfffffff055557812ULL, 0x000fe400078ee24cULL,
0x00005f0049507a11ULL, 0x000fe200000f444aULL, 0x000000ffff497224ULL, 0x000fe200010e06ffULL,
0x0000003e3c4d7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff3e7224ULL, 0x000fe200018e06ffULL,
0x00005e00404c7a11ULL, 0x000fe400078640ffULL, 0x00005e003f4a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff4f7224ULL, 0x000fe200000e06ffULL, 0x00005e004d4b7a11ULL, 0x000fc400078040ffULL,
0x000000514e4e7210ULL, 0x080fe40007f9e0ffULL, 0x00005f004d4d7a11ULL, 0x000fe400000f444fULL,
0x00005f0040407a11ULL, 0x000fe200018f443eULL, 0x000000ffff4f7224ULL, 0x000fe200020e0650ULL,
0x00005f003f497a11ULL, 0x000fe400010f4449ULL, 0x000000514b3e7210ULL, 0x080fe40007f1e0ffULL,
0x000000514a4a7210ULL, 0x080fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004e527faeULL, 0x0003e2000b901c46ULL, 0x000000514c4c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e064dULL, 0x0000e00054547811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200010e0649ULL, 0x0000e00055557811ULL, 0x000fe200078e20ffULL,
0x000000ffff4d7224ULL, 0x000fe200018e0640ULL, 0x000000003e537faeULL, 0x0003e8000b901c46ULL,
0x000000004a547faeULL, 0x0003e8000b901c46ULL, 0x000000004c557faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01064800074e7f8cULL, 0x0004e4000c80043fULL, 0x00000000003e7805ULL, 0x000fc40000015200ULL,
0x01064c0007407984ULL, 0x000f240000000800ULL, 0x8000000040ff7812ULL, 0x018fc4000780484fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff507224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000105000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004c7805ULL, 0x000fcc0000015200ULL, 0x0000004c3e497210ULL, 0x000fca0007f1e1ffULL,
0x000000014d4c7824ULL, 0x000fe200000e0e3fULL, 0x003d09004900780cULL, 0x000fc80003f06070ULL,
0x000000ff4c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404900780cULL, 0x000fc80003f06070ULL, 0x000000ff4c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff407819ULL, 0x000fc8000001144cULL,
0x0000004940407211ULL, 0x000fca00078110ffULL, 0x000000ffff497224ULL, 0x000fca00000e064cULL,
0x0000000240407819ULL, 0x000fc80000001249ULL, 0x000000400000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000150507810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01064c0007407984ULL, 0x000ee40000000800ULL,
0x8000000040ff7812ULL, 0x008fe4000780484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010100002c407984ULL, 0x000ee80000000800ULL, 0x010300002c497984ULL, 0x0004620000000800ULL,
0x0000003d4000720bULL, 0x008fe20003f1d000ULL, 0x0000add27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff4cff7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4e7424ULL, 0x000fd600078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f05270ULL,
0x0000003d4000720bULL, 0x000fe20003f54000ULL, 0x0000ada27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004d7806ULL, 0x000fc400010e0100ULL, 0x000000403d3e8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0105003e2c008388ULL, 0x0005e40000000800ULL,
0x000099104d3e7816ULL, 0x004fc800000000ffULL, 0x000000ff3e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000403d3e7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff4dff7812ULL, 0x000fc6000780c0ffULL,
0x8000003e3d3e7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b3e3e7820ULL, 0x000fc80000410000ULL,
0x0000003e004f7308ULL, 0x000ea40000000800ULL, 0x0000004f21217220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3e7819ULL, 0x000fe20000011605ULL,
0x0000ace27f007947ULL, 0x000fea000b800000ULL, 0x00001f3e4f3e7589ULL, 0x0004e400000e0000ULL,
0x0000003e34347220ULL, 0x088fe20000410000ULL, 0x0000003e35357220ULL, 0x080fe20000410000ULL,
0x0000003e38387220ULL, 0x080fe20000410000ULL, 0x0000003e39397220ULL, 0x080fe20000410000ULL,
0x0000003e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003e18187220ULL, 0x080fe20000410000ULL, 0x0000003e19197220ULL, 0x080fe20000410000ULL,
0x0000003e10107220ULL, 0x080fe20000410000ULL, 0x0000003e11117220ULL, 0x080fe20000410000ULL,
0x0000003e0c0c7220ULL, 0x080fe20000410000ULL, 0x0000003e0d0d7220ULL, 0x080fe20000410000ULL,
0x0000003e08087220ULL, 0x080fe20000410000ULL, 0x0000003e09097220ULL, 0x080fe20000410000ULL,
0x0000003e14147220ULL, 0x080fe20000410000ULL, 0x0000003e15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff004dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008053e7811ULL, 0x000fe200078ff0ffULL,
0x0000abe27f007947ULL, 0x000fea000b800000ULL, 0x00001f3e4f3e7589ULL, 0x0006a400000e0000ULL,
0x0000003e36367220ULL, 0x084fe20000410000ULL, 0x0000003e37377220ULL, 0x080fe20000410000ULL,
0x0000003e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000003e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000003e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003e1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003e12127220ULL, 0x080fe20000410000ULL, 0x0000003e13137220ULL, 0x080fe20000410000ULL,
0x0000003e0e0e7220ULL, 0x080fe20000410000ULL, 0x0000003e0f0f7220ULL, 0x080fe20000410000ULL,
0x0000003e0a0a7220ULL, 0x080fe20000410000ULL, 0x0000003e0b0b7220ULL, 0x080fe20000410000ULL,
0x0000003e16167220ULL, 0x080fe20000410000ULL, 0x0000003e17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff4dff7812ULL, 0x000fe2000780084cULL,
0x00000001ff4e7424ULL, 0x000fe200078e00ffULL, 0x000000403d3d7209ULL, 0x000fd60007810000ULL,
0x8000003d40400221ULL, 0x000fe20000010000ULL, 0x00007610ff4e0816ULL, 0x000fc6000000004eULL,
0x3fb8aa3b40400820ULL, 0x000fc80000410000ULL, 0x0000004000280308ULL, 0x000f240000000800ULL,
0x0000002849490220ULL, 0x012fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002149217221ULL, 0x002fc20000010000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff407984ULL, 0x000e640000000800ULL, 0x8000000040ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4f7224ULL, 0x00cfe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004c7805ULL, 0x000fcc0000015200ULL, 0x0000004c3e497210ULL, 0x000fca0007f1e1ffULL,
0x000000014d4c7824ULL, 0x000fe200000e0e3fULL, 0x003d09004900780cULL, 0x000fc80003f06070ULL,
0x000000ff4c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404900780cULL, 0x000fc80003f06070ULL, 0x000000ff4c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff407819ULL, 0x000fc8000001144cULL,
0x0000004940407211ULL, 0x000fca00078110ffULL, 0x000000ffff497224ULL, 0x000fca00000e064cULL,
0x0000000240407819ULL, 0x000fc80000001249ULL, 0x000000400000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014f4f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff407984ULL, 0x000e640000000800ULL,
0x8000000040ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104e3e7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff3e00720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000028ff29723eULL, 0x000fe400000000ffULL, 0x00000002ff487819ULL, 0x000fe40000011605ULL,
0x0000541029407816ULL, 0x000fe20000000029ULL, 0x0000a7d27f007947ULL, 0x000fea000b800000ULL,
0x00001f4840297589ULL, 0x0002a400000e0000ULL, 0x00000008482a7810ULL, 0x000fe20007ffe0ffULL,
0x0000a8027f007947ULL, 0x000fea000b800000ULL, 0x00001f2a402a7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010483f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0040ULL, 0x00008b90003e7802ULL, 0x000fc40000000f00ULL,
0x0000b07000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018483f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e0040ULL,
0x00008be0003e7802ULL, 0x000fc40000000f00ULL, 0x0000b02000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b0002e4c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002f54783bULL, 0x000f280000004200ULL,
0x000000004c4c783bULL, 0x004ea80000000200ULL, 0x000000003050783bULL, 0x000ee80000004200ULL,
0x000000003258783bULL, 0x000e680000004200ULL, 0x000000003364783bULL, 0x000e620000004200ULL,
0x0000312054547816ULL, 0x010fc400000000ffULL, 0x0000312055557816ULL, 0x000fe200000000ffULL,
0x000000294c4ca232ULL, 0x084fe20000000000ULL, 0x00000054ff3e723eULL, 0x080fe200020006ffULL,
0x000000294e4ea232ULL, 0x000fe20000000000ULL, 0x00000055ff3f723eULL, 0x080fe200020006ffULL,
0x0000002a4d4da232ULL, 0x082fe20000000000ULL, 0x00000054ff54723eULL, 0x000fe200030006ffULL,
0x0000002a4f4fa232ULL, 0x000fe20000000000ULL, 0x00000055ff55723eULL, 0x000fe400030006ffULL,
0x0000312050507816ULL, 0x008fc400000000ffULL, 0x0000312051517816ULL, 0x000fe400000000ffULL,
0x0000003e4c34723cULL, 0x040b620000001834ULL, 0x00000050ff5c723eULL, 0x080fe400020006ffULL,
0x00000051ff5d723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400030006ffULL,
0x00003120563e7816ULL, 0x020fe200000000ffULL, 0x000000544c38723cULL, 0x000be20000001838ULL,
0x00003120573f7816ULL, 0x000fc400000000ffULL, 0x00000051ff51723eULL, 0x000fe400030006ffULL,
0x0000312058587816ULL, 0x000fe400000000ffULL, 0x0000003eff54723eULL, 0x0a0fe200020006ffULL,
0x0000005c4c5c723cULL, 0x000b620000001810ULL, 0x0000003fff55723eULL, 0x080fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400030006ffULL, 0x0000003fff3f723eULL, 0x000fc400030006ffULL,
0x0000312052107816ULL, 0x020fe200000000ffULL, 0x000000544c54723cULL, 0x040be2000000181cULL,
0x0000312053117816ULL, 0x000fe400000000ffULL, 0x00000010ff60723eULL, 0x080fe400020006ffULL,
0x00000011ff61723eULL, 0x000fe400020006ffULL, 0x0000b000311c7811ULL, 0x020fe200078e20ffULL,
0x0000003e4c18723cULL, 0x000fe20000001818ULL, 0x00000010ff10723eULL, 0x000fc400030006ffULL,
0x00000011ff11723eULL, 0x000fe400030006ffULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x000000504c50723cULL, 0x000b62000000180cULL,
0x000031205a5a7816ULL, 0x000fe400000000ffULL, 0x0000312064647816ULL, 0x000fe400000000ffULL,
0x0000312066667816ULL, 0x000fc400000000ffULL, 0x0000312067677816ULL, 0x000fe200000000ffULL,
0x000000604c60723cULL, 0x000b640000001808ULL, 0x00000064ff0c723eULL, 0x020fca00020006ffULL,
0x000031205b097816ULL, 0x000fe200000000ffULL, 0x000000104c4c723cULL, 0x000b620000001814ULL,
0x0000005aff08723eULL, 0x000fcc00030006ffULL, 0x00000058ff10723eULL, 0x020fe400020006ffULL,
0x00000059ff11723eULL, 0x000fe400020006ffULL, 0x0000312065157816ULL, 0x000fe400000000ffULL,
0x00000064ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff0d723eULL, 0x080fe400020006ffULL,
0x00000015ff15723eULL, 0x000fe200030006ffULL, 0x000000291c1ca232ULL, 0x002fc40000000000ULL,
0x000000291e1ea232ULL, 0x000fe40000000000ULL, 0x0000002a1d1da232ULL, 0x080fe40000000000ULL,
0x0000002a1f1fa232ULL, 0x000fce0000000000ULL, 0x000000101c10723cULL, 0x040b6e0000001834ULL,
0x00000058ff34723eULL, 0x020fe200030006ffULL, 0x0000000c1c0c723cULL, 0x000f62000000185cULL,
0x00000059ff35723eULL, 0x000fce00030006ffULL, 0x000000341c34723cULL, 0x040b6e0000001838ULL,
0x00000009ff39723eULL, 0x0a0fe200020006ffULL, 0x000000141c14723cULL, 0x000f620000001850ULL,
0x00000009ff09723eULL, 0x000fe400030006ffULL, 0x0000005aff38723eULL, 0x000fca00020006ffULL,
0x000000081c08723cULL, 0x040b6e0000001818ULL, 0x00000066ff18723eULL, 0x0a0fe200020006ffULL,
0x000000381c38723cULL, 0x000b620000001854ULL, 0x00000067ff19723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fc400030006ffULL, 0x00000067ff67723eULL, 0x000fc600030006ffULL,
0x000000181c18723cULL, 0x040b700000001860ULL, 0x000000661c1c723cULL, 0x000b62000000184cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff4c7f8cULL, 0x020e64000c80043fULL, 0x00000000003e7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff407984ULL, 0x000ea40000000800ULL, 0x8000000040ff7812ULL, 0x006fc4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x000000483e487210ULL, 0x000fca0007f1e1ffULL,
0x0000000149497824ULL, 0x000fe200000e0e3fULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff407819ULL, 0x000fc80000011449ULL,
0x0000004840407211ULL, 0x000fca00078110ffULL, 0x000000ffff487224ULL, 0x000fca00000e0649ULL,
0x0000000240407819ULL, 0x000fc80000001248ULL, 0x000000400000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff407984ULL, 0x000e640000000800ULL,
0x8000000040ff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x0000000107407824ULL, 0x000fe200078e022bULL,
0x00000080413f7810ULL, 0x000fe40007ffe0ffULL, 0x000000022b497810ULL, 0x040fe20007ffe0ffULL,
0x00000001403e7824ULL, 0x000fe200078e0205ULL, 0x0000004006507811ULL, 0x000fe200078e38ffULL,
0x0000001040527824ULL, 0x040fe200078e00ffULL, 0x000000042b547810ULL, 0x000fe20007ffe0ffULL,
0x00000001074c7824ULL, 0x000fe200078e0249ULL, 0x000000062b567810ULL, 0x000fe20007ffe0ffULL,
0x00000001404d7824ULL, 0x000fe200078e0250ULL, 0xfffffff052527812ULL, 0x000fe200078ee23eULL,
0x000000014c4f7824ULL, 0x000fe200078e0250ULL, 0x0000003f023e7217ULL, 0x000fe20007800000ULL,
0x00000001074e7824ULL, 0x000fe200078e0254ULL, 0x0000003c4d4d7210ULL, 0x080fe20007f1e0ffULL,
0x000000014c487824ULL, 0x000fe200078e0205ULL, 0x0000003c4f4f7210ULL, 0x000fe20007f7e0ffULL,
0x000000013e3e7824ULL, 0x000fe200078e0a3fULL, 0x0000c00052527811ULL, 0x000fe200078e20ffULL,
0x000000104c537824ULL, 0x000fc400078e00ffULL, 0x000000014e517824ULL, 0x040fe200078e0205ULL,
0x0000003e073e7217ULL, 0x000fe20007800000ULL, 0x000000104e557824ULL, 0x000fe200078e00ffULL,
0xfffffff053537812ULL, 0x000fe200078ee248ULL, 0x000000ffff487224ULL, 0x000fe200000e06ffULL,
0x00005e004d3f7a11ULL, 0x000fe200078040ffULL, 0x000000013e407824ULL, 0x000fe200078e0a07ULL,
0xfffffff055557812ULL, 0x000fe200078ee251ULL, 0x000000ffff3e7224ULL, 0x000fe200018e06ffULL,
0x00005e004f4c7a11ULL, 0x000fe200078640ffULL, 0x000000014e4e7824ULL, 0x000fe200078e0250ULL,
0x000000f025517812ULL, 0x000fe200078ec0ffULL, 0x0000000107577824ULL, 0x000fe200078e0256ULL,
0x000000402b00720cULL, 0x000fc40003f86070ULL, 0x00005f004f4f7a11ULL, 0x000fe200018f443eULL,
0x0000000157507824ULL, 0x000fe200078e0250ULL, 0x00005f004d4d7a11ULL, 0x000fe400000f4448ULL,
0x0000003c4e4e7210ULL, 0x000fe40007fbe0ffULL, 0x000000513f3e7210ULL, 0x000fe40007f7e0ffULL,
0x000000404900720cULL, 0x080fe20003f06070ULL, 0x000000ffff497224ULL, 0x000fe200028e06ffULL,
0x00005e004e487a11ULL, 0x000fe200078a40ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e064dULL,
0x000000405400720cULL, 0x000fc40003f66070ULL, 0x00005f004e4e7a11ULL, 0x000fe400028f4449ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e527faeULL, 0x0003e2000e101c46ULL,
0x0000003c50497210ULL, 0x000fe20007f9e0ffULL, 0x0000000157507824ULL, 0x040fe200078e0205ULL,
0x0000005148487210ULL, 0x000fe20007fde0ffULL, 0x0000001057577824ULL, 0x000fe200078e00ffULL,
0x0000c00053537811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200020e06ffULL,
0x0000c00055557811ULL, 0x000fe400078e20ffULL, 0xfffffff057507812ULL, 0x000fc400078ee250ULL,
0x000000514c3e7210ULL, 0x082fe40007fbe0ffULL, 0x00005e00494c7a11ULL, 0x040fe400078840ffULL,
0x0000c00050507811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e064fULL,
0x000000405600720cULL, 0x000fe40003fa6070ULL, 0x00005f0049407a11ULL, 0x000fe200020f444dULL,
0x000000ffff497224ULL, 0x000fe200030e064eULL, 0x000000514c4c7210ULL, 0x000fe20007f9e0ffULL,
0x000000003e537faeULL, 0x0003e8000c101c46ULL, 0x000000ffff4d7224ULL, 0x000fe200020e0640ULL,
0x0000000048557faeULL, 0x0003e8000d901c46ULL, 0x000000004c507faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x00000040063f7811ULL, 0x000fe200078e38ffULL,
0x00000001073e7824ULL, 0x000fe200078e022bULL, 0x000000f025527812ULL, 0x000fc600078ec0ffULL,
0x000000013e487824ULL, 0x040fe200078e0205ULL, 0x000000023e497810ULL, 0x040fe20007ffe0ffULL,
0x000000103e537824ULL, 0x040fe200078e00ffULL, 0x000000043e4c7810ULL, 0x040fe20007ffe0ffULL,
0x000000013e407824ULL, 0x140fe200078e023fULL, 0x000000063e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000149507824ULL, 0x000fe200078e023fULL, 0xfffffff053537812ULL, 0x000fe200078ee248ULL,
0x0000000149487824ULL, 0x040fe200078e0205ULL, 0x0000003c40407210ULL, 0x000fe20007f1e0ffULL,
0x0000001049547824ULL, 0x000fe200078e00ffULL, 0x0000c00053537811ULL, 0x000fe200078e20ffULL,
0x000000014c497824ULL, 0x000fc400078e023fULL, 0x000000013e4d7824ULL, 0x000fe200078e023fULL,
0xfffffff054547812ULL, 0x000fe200078ee248ULL, 0x000000014c3f7824ULL, 0x140fe200078e0205ULL,
0x0000003c49497210ULL, 0x000fe20007f7e0ffULL, 0x000000104c557824ULL, 0x000fe200078e00ffULL,
0x0000c00054547811ULL, 0x000fe200078e20ffULL, 0x000000013e4c7824ULL, 0x040fe400078e0205ULL,
0x000000103e567824ULL, 0x000fe200078e00ffULL, 0xfffffff055557812ULL, 0x000fe200078ee23fULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e00404e7a11ULL, 0x000fe200078040ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0xfffffff056567812ULL, 0x000fc400078ee24cULL,
0x00005f0040517a11ULL, 0x000fe400000f443eULL, 0x0000003c50507210ULL, 0x080fe40007f1e0ffULL,
0x0000003c4d407210ULL, 0x000fe40007f9e0ffULL, 0x00005e0049487a11ULL, 0x000fe200078640ffULL,
0x000000ffff4f7224ULL, 0x000fe200000e06ffULL, 0x00005e00504d7a11ULL, 0x000fe200078040ffULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00005e00404c7a11ULL, 0x000fc400078840ffULL,
0x000000524e4e7210ULL, 0x080fe40007fbe0ffULL, 0x00005f0050507a11ULL, 0x000fe400000f444fULL,
0x00005f0040407a11ULL, 0x000fe200020f443eULL, 0x000000ffff4f7224ULL, 0x000fe200028e0651ULL,
0x00005f0049497a11ULL, 0x000fe400018f443fULL, 0x000000524d3e7210ULL, 0x080fe40007f1e0ffULL,
0x0000005248487210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004e537faeULL, 0x0003e2000b901c46ULL, 0x000000524c4c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e0650ULL, 0x0000c00055557811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200018e0649ULL, 0x0000c00056567811ULL, 0x000fe200078e20ffULL,
0x000000ffff4d7224ULL, 0x000fe200020e0640ULL, 0x000000003e547faeULL, 0x0003e8000b901c46ULL,
0x0000000048557faeULL, 0x0003e8000b901c46ULL, 0x000000004c567faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff487f8cULL, 0x000e64000c80043fULL, 0x000000ffff487224ULL, 0x002fc400078e0049ULL,
0x00000000003e7805ULL, 0x000fca0000015200ULL, 0x0106b400ff407984ULL, 0x000e640000000800ULL,
0x8000000040ff7812ULL, 0x002fc4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004c7805ULL, 0x000fcc0000015200ULL,
0x0000004c3e497210ULL, 0x000fca0007f1e1ffULL, 0x000000014d4c7824ULL, 0x000fe200000e0e3fULL,
0x003d09004900780cULL, 0x000fc80003f06070ULL, 0x000000ff4c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404900780cULL, 0x000fc80003f06070ULL,
0x000000ff4c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff407819ULL, 0x000fc8000001144cULL, 0x0000004940407211ULL, 0x000fca00078110ffULL,
0x000000ffff497224ULL, 0x000fca00000e064cULL, 0x0000000240407819ULL, 0x000fc80000001249ULL,
0x000000400000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff407984ULL, 0x000e640000000800ULL, 0x8000000040ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000028ff29723eULL, 0x000fe400000000ffULL,
0x00000002ff497819ULL, 0x000fe40000011605ULL, 0x0000541029407816ULL, 0x000fe20000000029ULL,
0x000094c27f007947ULL, 0x000fea000b800000ULL, 0x00001f4940297589ULL, 0x0002a400000e0000ULL,
0x00000008492a7810ULL, 0x000fe20007ffe0ffULL, 0x000094f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a402a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010493f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0040ULL,
0x00009f60003e7802ULL, 0x000fc40000000f00ULL, 0x00009ca000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018493f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x004fe200078e0040ULL, 0x00009fb0003e7802ULL, 0x000fc40000000f00ULL,
0x00009c5000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b000424c7811ULL, 0x000fc400078e20ffULL,
0x000000004350783bULL, 0x000f280000004200ULL, 0x000000004c4c783bULL, 0x004ea80000000200ULL,
0x000000004454783bULL, 0x000ee80000004200ULL, 0x000000004760783bULL, 0x000e620000004200ULL,
0x0000312052527816ULL, 0x010fc400000000ffULL, 0x0000312053537816ULL, 0x000fe400000000ffULL,
0x0000312050507816ULL, 0x000fe200000000ffULL, 0x000000294c4ca232ULL, 0x084fe20000000000ULL,
0x0000312051517816ULL, 0x000fe200000000ffULL, 0x000000294e4ea232ULL, 0x000fe20000000000ULL,
0x00000052ff5c723eULL, 0x000fe200020006ffULL, 0x0000002a4d4da232ULL, 0x082fe20000000000ULL,
0x00000053ff5d723eULL, 0x000fe200020006ffULL, 0x0000002a4f4fa232ULL, 0x000fe20000000000ULL,
0x00000050ff58723eULL, 0x000fc400030006ffULL, 0x00000051ff59723eULL, 0x080fe400030006ffULL,
0x00000050ff3e723eULL, 0x000fe400020006ffULL, 0x0000b00045507811ULL, 0x000fe200078e20ffULL,
0x0000005c4c5c723cULL, 0x000be20000001838ULL, 0x00000051ff3f723eULL, 0x000fe200020006ffULL,
0x000000004638783bULL, 0x020e620000004200ULL, 0x0000312054547816ULL, 0x008fe400000000ffULL,
0x0000312055557816ULL, 0x000fc400000000ffULL, 0x0000312060607816ULL, 0x000fe200000000ffULL,
0x000000584c58723cULL, 0x040be20000001834ULL, 0x0000312061617816ULL, 0x000fe400000000ffULL,
0x0000312062627816ULL, 0x000fe400000000ffULL, 0x0000312063637816ULL, 0x000fe400000000ffULL,
0x00000052ff34723eULL, 0x020fe200030006ffULL, 0x0000003e4c10723cULL, 0x000f620000001810ULL,
0x00000053ff35723eULL, 0x000fc400030006ffULL, 0x000000005050783bULL, 0x000eaa0000000200ULL,
0x000000344c08723cULL, 0x000b6e0000001808ULL, 0x00000054ff34723eULL, 0x020fc400020006ffULL,
0x00000055ff35723eULL, 0x080fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400030006ffULL,
0x00000055ff55723eULL, 0x000fc600030006ffULL, 0x000000344c0c723cULL, 0x000b62000000180cULL,
0x0000312038387816ULL, 0x002fe400000000ffULL, 0x0000312039397816ULL, 0x000fc800000000ffULL,
0x0000312056347816ULL, 0x020fe200000000ffULL, 0x000000544c14723cULL, 0x000be20000001814ULL,
0x0000312057357816ULL, 0x000fcc00000000ffULL, 0x00000034ff54723eULL, 0x0a0fe400020006ffULL,
0x00000035ff55723eULL, 0x080fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe200030006ffULL,
0x000000295050a232ULL, 0x084fe20000000000ULL, 0x00000035ff35723eULL, 0x000fe200030006ffULL,
0x000000295252a232ULL, 0x000fe40000000000ULL, 0x000000544c54723cULL, 0x000f620000001818ULL,
0x0000002a5151a232ULL, 0x000fc40000000000ULL, 0x0000002a5353a232ULL, 0x000fca0000000000ULL,
0x000000344c4c723cULL, 0x000b6e000000181cULL, 0x00000038ff34723eULL, 0x0a0fe400020006ffULL,
0x00000039ff35723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fc400030006ffULL,
0x00000039ff39723eULL, 0x000fc600030006ffULL, 0x000000345034723cULL, 0x040b6e0000001810ULL,
0x000031203a107816ULL, 0x020fe400000000ffULL, 0x000031203b117816ULL, 0x000fe400000000ffULL,
0x00000010ff1c723eULL, 0x000fe200020006ffULL, 0x000000385038723cULL, 0x000f620000001858ULL,
0x00000011ff1d723eULL, 0x000fc400020006ffULL, 0x00000010ff10723eULL, 0x000fe400030006ffULL,
0x00000011ff11723eULL, 0x000fc600030006ffULL, 0x0000001c501c723cULL, 0x040f70000000185cULL,
0x000000105018723cULL, 0x000b6e0000001808ULL, 0x00000060ff10723eULL, 0x020fc400020006ffULL,
0x00000061ff11723eULL, 0x000fe400020006ffULL, 0x00000062ff08723eULL, 0x000fe400020006ffULL,
0x00000063ff09723eULL, 0x000fc600020006ffULL, 0x000000105010723cULL, 0x040b6e000000180cULL,
0x00000060ff0c723eULL, 0x020fe200030006ffULL, 0x000000085008723cULL, 0x000f620000001854ULL,
0x00000061ff0d723eULL, 0x000fce00030006ffULL, 0x0000000c500c723cULL, 0x000b6e0000001814ULL,
0x00000062ff14723eULL, 0x020fe400030006ffULL, 0x00000063ff15723eULL, 0x000fce00030006ffULL,
0x000000145014723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000080413e7810ULL, 0x002fe20007ffe0ffULL,
0x01069800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4c7224ULL, 0x020fe200078e003fULL,
0x0000000124407810ULL, 0x000fe40007ffe0ffULL, 0x000000023e00720cULL, 0x000fda0003f06070ULL,
0x0000305000000947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fe4000780484cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a3e407210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e3fULL, 0x003d09004000780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404000780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff207819ULL, 0x000fc8000001144aULL,
0x0000004020207211ULL, 0x000fca00078110ffULL, 0x000000ffff407224ULL, 0x000fca00000e064aULL,
0x0000000220207819ULL, 0x000fc80000001240ULL, 0x000000200000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fe4000780484cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000a041207810ULL, 0x000fe20007ffe0ffULL,
0x00000001073f7824ULL, 0x000fe200078e022bULL, 0x000000022b4a7810ULL, 0x000fe40007ffe0ffULL,
0x00000020023e7217ULL, 0x000fe20007800000ULL, 0x000000013f407824ULL, 0x000fe200078e0205ULL,
0x000000042b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000103f517824ULL, 0x000fe200078e00ffULL,
0x000000062b547810ULL, 0x000fe20007ffe0ffULL, 0x000000013e3e7824ULL, 0x000fe200078e0a20ULL,
0x0000006006207811ULL, 0x000fe200078e38ffULL, 0x0000000107497824ULL, 0x000fe200078e024aULL,
0xfffffff051517812ULL, 0x000fe200078ee240ULL, 0x00000001074c7824ULL, 0x040fe200078e024bULL,
0x0000003e073e7217ULL, 0x000fe20007800000ULL, 0x000000013f4f7824ULL, 0x000fe200078e0220ULL,
0x000000f025507812ULL, 0x000fe200078ec0ffULL, 0x00000001073f7824ULL, 0x000fe200078e0254ULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x00000001494e7824ULL, 0x000fe200078e0220ULL,
0x0000003c4f4f7210ULL, 0x000fe20007f1e0ffULL, 0x0000000149407824ULL, 0x000fc400078e0205ULL,
0x0000001049527824ULL, 0x000fe200078e00ffULL, 0x0000003c4e4e7210ULL, 0x080fe20007f3e0ffULL,
0x000000014c497824ULL, 0x100fe400078e0220ULL, 0x000000013f207824ULL, 0x000fe200078e0220ULL,
0xfffffff052527812ULL, 0x000fe200078ee240ULL, 0x000000014c4d7824ULL, 0x140fe200078e0205ULL,
0x0000003c49497210ULL, 0x080fe20007f9e0ffULL, 0x000000104c537824ULL, 0x000fe200078e00ffULL,
0x0000003c203c7210ULL, 0x000fe20007f7e0ffULL, 0x000000013f407824ULL, 0x040fe200078e0205ULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x000000103f557824ULL, 0x000fe200078e00ffULL,
0xfffffff053537812ULL, 0x000fe200078ee24dULL, 0x000000013e207824ULL, 0x000fe200078e0a07ULL,
0x00005e004e4d7a11ULL, 0x000fe200078440ffULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0xfffffff055557812ULL, 0x000fe200078ee240ULL, 0x000000ffff407224ULL, 0x000fe200000e06ffULL,
0x00005e004f3f7a11ULL, 0x000fc400078040ffULL, 0x00005f004e4e7a11ULL, 0x000fe400010f443eULL,
0x000000202b00720cULL, 0x000fe40003f46070ULL, 0x00005f004f4f7a11ULL, 0x000fe200000f4440ULL,
0x000000ffff407224ULL, 0x000fe200018e06ffULL, 0x000000503f3e7210ULL, 0x000fe40007fbe0ffULL,
0x000000204b00720cULL, 0x080fe20003f06070ULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x000000204a00720cULL, 0x000fe20003f26070ULL, 0x000000ffff3f7224ULL, 0x000fe200028e064fULL,
0x00005e00494a7a11ULL, 0x000fc400078840ffULL, 0x00005e003c4c7a11ULL, 0x000fe400078c40ffULL,
0x000000205400720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e517faeULL, 0x0003e2000d101c46ULL, 0x00005f0049497a11ULL, 0x000fe400020f444bULL,
0x000000504a4a7210ULL, 0x080fe40007f9e0ffULL, 0x00005f003c207a11ULL, 0x000fe400030f4440ULL,
0x000000504c4c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff4b7224ULL, 0x000fe200020e0649ULL,
0x0000e00053537811ULL, 0x000fc400078e20ffULL, 0x0000e00055557811ULL, 0x000fe400078e20ffULL,
0x000000504d3e7210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff4d7224ULL, 0x000fc800028e0620ULL,
0x000000ffff3f7224ULL, 0x000fca00010e064eULL, 0x000000003e527faeULL, 0x0003e8000c901c46ULL,
0x000000004a537faeULL, 0x0003e8000c101c46ULL, 0x000000004c557faeULL, 0x0003e2000d901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000000107207824ULL, 0x000fe200078e022bULL,
0x00000060063e7811ULL, 0x000fc400078e38ffULL, 0x000000f025507812ULL, 0x000fe200078ec0ffULL,
0x00000001203f7824ULL, 0x040fe200078e0205ULL, 0x0000000220407810ULL, 0x040fe20007ffe0ffULL,
0x0000001020517824ULL, 0x040fe200078e00ffULL, 0x00000004204a7810ULL, 0x000fc60007ffe0ffULL,
0x0000000140497824ULL, 0x040fe200078e0205ULL, 0xfffffff051517812ULL, 0x000fe200078ee23fULL,
0x0000001040527824ULL, 0x000fe400078e00ffULL, 0x00000001203f7824ULL, 0x140fe200078e023eULL,
0x0000000620207810ULL, 0x000fe20007ffe0ffULL, 0x000000014a4b7824ULL, 0x000fe200078e0205ULL,
0xfffffff052527812ULL, 0x000fe200078ee249ULL, 0x0000000140497824ULL, 0x100fe200078e023eULL,
0x0000003c3f3f7210ULL, 0x080fe20007f5e0ffULL, 0x000000014a407824ULL, 0x100fe200078e023eULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x00000001204c7824ULL, 0x000fe200078e023eULL,
0x0000003c49497210ULL, 0x080fe20007f1e0ffULL, 0x000000104a537824ULL, 0x000fe200078e00ffULL,
0x0000003c40407210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x00005e003f4e7a11ULL, 0x000fe200078640ffULL, 0x00000001204a7824ULL, 0x040fe200078e0205ULL,
0xfffffff053537812ULL, 0x000fe200078ee24bULL, 0x0000001020547824ULL, 0x000fe200078e00ffULL,
0x0000003c4c207210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200000e06ffULL,
0x00005f003f4d7a11ULL, 0x000fe200018f443eULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0xfffffff054547812ULL, 0x000fe200078ee24aULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e00493f7a11ULL, 0x000fc400078040ffULL, 0x00005e00404a7a11ULL, 0x000fe400078240ffULL,
0x00005e00204c7a11ULL, 0x000fe400078440ffULL, 0x000000504e4e7210ULL, 0x080fe40007f7e0ffULL,
0x00005f0049497a11ULL, 0x000fe400000f444bULL, 0x00005f0040407a11ULL, 0x000fe200008f443eULL,
0x000000ffff4f7224ULL, 0x000fe200018e064dULL, 0x000000503f3e7210ULL, 0x000fc40007f1e0ffULL,
0x00005f0020207a11ULL, 0x000fe400010f443cULL, 0x000000504a4a7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e0649ULL, 0x000000504c4c7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e517faeULL, 0x0003e2000b901c46ULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe200008e0640ULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200010e0620ULL,
0x0000e00054547811ULL, 0x000fe200078e20ffULL, 0x000000003e527faeULL, 0x0003e8000b901c46ULL,
0x000000004a537faeULL, 0x0003e8000b901c46ULL, 0x000000004c547faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000002243e7810ULL, 0x002fc80007ffe0ffULL,
0x000000033e00720cULL, 0x000fe20003f06070ULL, 0xffffffffff207424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00000001223e7824ULL, 0x000fe400078e023eULL,
0x00000004ff3f7424ULL, 0x000fc800078e00ffULL, 0x000060003e3e7625ULL, 0x000fca00078e003fULL,
0x000000063e207981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4a7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01066800074e7f8cULL, 0x000664000c80043fULL, 0x00000000003e7805ULL, 0x002fc40000015200ULL,
0x01066c00073c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe4000780484fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004c7805ULL, 0x000fcc0000015200ULL, 0x0000004c3e407210ULL, 0x000fca0007f1e1ffULL,
0x000000014d4c7824ULL, 0x000fe200000e0e3fULL, 0x003d09004000780cULL, 0x000fc80003f06070ULL,
0x000000ff4c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404000780cULL, 0x000fc80003f06070ULL, 0x000000ff4c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001144cULL,
0x000000403c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff407224ULL, 0x000fca00000e064cULL,
0x000000023c3c7819ULL, 0x000fc80000001240ULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01066c00073c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe4000780484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010180002c3c7984ULL, 0x000e680000000800ULL, 0x010380002c407984ULL, 0x0006a20000000800ULL,
0x0000003d3c00720bULL, 0x002fe20003f1d000ULL, 0x000080527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000497806ULL, 0x008fc800000e0100ULL, 0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4c7424ULL, 0x000fd600078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000030000780cULL, 0x000fe40003f05270ULL,
0x0000003d3c00720bULL, 0x000fe20003f34000ULL, 0x000080227f007947ULL, 0x000fd8000b800000ULL,
0x00000000002d7806ULL, 0x000fc400008e0100ULL, 0x0000003d3c3e8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0105803e2c008388ULL, 0x0003e40000000800ULL,
0x000099102d2c7816ULL, 0x002fc800000000ffULL, 0x000000ff2c00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000003d3c2c7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff2dff7812ULL, 0x000fc6000780c0ffULL,
0x0000003d2c2c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c004c7308ULL, 0x000e640000000800ULL, 0x0000004c21217220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff2c7819ULL, 0x000fe20000011605ULL,
0x00007f627f007947ULL, 0x000fea000b800000ULL, 0x00001f2c4c2c7589ULL, 0x0002e400000e0000ULL,
0x0000002c34347220ULL, 0x088fe20000410000ULL, 0x0000002c35357220ULL, 0x080fe20000410000ULL,
0x0000002c38387220ULL, 0x080fe20000410000ULL, 0x0000002c39397220ULL, 0x080fe20000410000ULL,
0x0000002c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002c18187220ULL, 0x080fe20000410000ULL, 0x0000002c19197220ULL, 0x080fe20000410000ULL,
0x0000002c10107220ULL, 0x080fe20000410000ULL, 0x0000002c11117220ULL, 0x080fe20000410000ULL,
0x0000002c0c0c7220ULL, 0x080fe20000410000ULL, 0x0000002c0d0d7220ULL, 0x080fe20000410000ULL,
0x0000002c08087220ULL, 0x080fe20000410000ULL, 0x0000002c09097220ULL, 0x080fe20000410000ULL,
0x0000002c14147220ULL, 0x080fe20000410000ULL, 0x0000002c15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff002dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008052c7811ULL, 0x000fe200078ff0ffULL,
0x00007e627f007947ULL, 0x000fea000b800000ULL, 0x00001f2c4c2c7589ULL, 0x00066400000e0000ULL,
0x0000002c36367220ULL, 0x082fe20000410000ULL, 0x0000002c37377220ULL, 0x080fe20000410000ULL,
0x0000002c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000002c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000002c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000002c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000002c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002c12127220ULL, 0x080fe20000410000ULL, 0x0000002c13137220ULL, 0x080fe20000410000ULL,
0x0000002c0e0e7220ULL, 0x080fe20000410000ULL, 0x0000002c0f0f7220ULL, 0x080fe20000410000ULL,
0x0000002c0a0a7220ULL, 0x080fe20000410000ULL, 0x0000002c0b0b7220ULL, 0x080fe20000410000ULL,
0x0000002c16167220ULL, 0x080fe20000410000ULL, 0x0000002c17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff2dff7812ULL, 0x000fe20007800849ULL,
0x00000001ff4c7424ULL, 0x00afe200078e00ffULL, 0x0000003d3c3d7209ULL, 0x000fd60007810000ULL,
0x8000003d3c3c0221ULL, 0x000fe20000010000ULL, 0x00007610ff4c0816ULL, 0x000fc6000000004cULL,
0x3fb8aa3b3c3c0820ULL, 0x000fc80000410000ULL, 0x0000003c00280308ULL, 0x000e640000000800ULL,
0x0000002840400220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002140217221ULL, 0x004fc20000010000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff3c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e2c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143fULL,
0x0000003e3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x000000023c3c7819ULL, 0x000fc8000000123eULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000140407810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104c2c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2c00720cULL, 0x000fda0003f25270ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000028ff29723eULL, 0x000fe400000000ffULL, 0x00000002ff2d7819ULL, 0x000fe40000011605ULL,
0x00005410292c7816ULL, 0x000fe20000000029ULL, 0x00007a527f007947ULL, 0x000fea000b800000ULL,
0x00001f2d2c297589ULL, 0x0002a400000e0000ULL, 0x000000082d2a7810ULL, 0x000fe20007ffe0ffULL,
0x00007a827f007947ULL, 0x000fea000b800000ULL, 0x00001f2a2c2a7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000102d3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e002cULL, 0x0000bbf0003e7802ULL, 0x000fc40000000f00ULL,
0x0000801000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000182d3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e002cULL,
0x0000bc40003e7802ULL, 0x000fc40000000f00ULL, 0x00007fc000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b8002e2e7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002f50783bULL, 0x000ee80000004200ULL,
0x000000002e4c783bULL, 0x004ea80000000200ULL, 0x00000000302c783bULL, 0x00a2e80000004200ULL,
0x000000003258783bULL, 0x000e680000004200ULL, 0x00000000335c783bULL, 0x000ee20000004200ULL,
0x0000312050507816ULL, 0x000fc400000000ffULL, 0x0000312051517816ULL, 0x000fe200000000ffULL,
0x000000294c4c9232ULL, 0x084fe20000000000ULL, 0x00000050ff3e723eULL, 0x080fe200020006ffULL,
0x000000294e4e9232ULL, 0x000fe20000000000ULL, 0x00000051ff3f723eULL, 0x080fe200020006ffULL,
0x0000002a4d4d9232ULL, 0x080fe20000000000ULL, 0x00000050ff50723eULL, 0x000fe200030006ffULL,
0x0000002a4f4f9232ULL, 0x000fe20000000000ULL, 0x00000051ff51723eULL, 0x000fe400030006ffULL,
0x0000312052307816ULL, 0x002fc400000000ffULL, 0x000031202c2c7816ULL, 0x008fe400000000ffULL,
0x0000003e4c34723cULL, 0x040be20000001834ULL, 0x000031202d2d7816ULL, 0x000fe400000000ffULL,
0x000031205a5a7816ULL, 0x000fe400000000ffULL, 0x000031205b5b7816ULL, 0x000fe400000000ffULL,
0x00003120533f7816ULL, 0x020fe200000000ffULL, 0x000000504c38723cULL, 0x000be20000001838ULL,
0x00000030ff3e723eULL, 0x000fc400030006ffULL, 0x000031205c5c7816ULL, 0x000fe400000000ffULL,
0x000031205d5d7816ULL, 0x000fe400000000ffULL, 0x00000030ff50723eULL, 0x020fe400020006ffULL,
0x0000003fff51723eULL, 0x080fe400020006ffULL, 0x0000002cff30723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fc400030006ffULL, 0x0000002cff2c723eULL, 0x000fe200030006ffULL,
0x000000504c50723cULL, 0x040b62000000181cULL, 0x0000312058587816ULL, 0x000fe400000000ffULL,
0x000031205e5e7816ULL, 0x000fe400000000ffULL, 0x000031205f5f7816ULL, 0x000fe400000000ffULL,
0x0000b800311c7811ULL, 0x020fe200078e20ffULL, 0x0000003e4c18723cULL, 0x000fe20000001818ULL,
0x0000002dff31723eULL, 0x000fc400020006ffULL, 0x0000002dff2d723eULL, 0x000fe400030006ffULL,
0x000000001c1c783bULL, 0x000e660000000200ULL, 0x000000304c10723cULL, 0x000b6e0000001810ULL,
0x000031202e307816ULL, 0x020fc400000000ffULL, 0x000031202f317816ULL, 0x000fe400000000ffULL,
0x00000030ff54723eULL, 0x080fe200020006ffULL, 0x0000002c4c2c723cULL, 0x040b62000000180cULL,
0x00000031ff55723eULL, 0x080fe400020006ffULL, 0x00000030ff30723eULL, 0x000fe400030006ffULL,
0x00000031ff31723eULL, 0x000fe400030006ffULL, 0x00003120590d7816ULL, 0x020fe200000000ffULL,
0x000000544c54723cULL, 0x000b620000001808ULL, 0x00000058ff0c723eULL, 0x000fcc00030006ffULL,
0x0000000dff09723eULL, 0x0a0fe200020006ffULL, 0x000000304c30723cULL, 0x000b620000001814ULL,
0x00000058ff08723eULL, 0x000fe400020006ffULL, 0x0000000dff0d723eULL, 0x000fc800030006ffULL,
0x0000005aff14723eULL, 0x0a0fe200020006ffULL, 0x000000291c1c9232ULL, 0x082fe20000000000ULL,
0x0000005bff15723eULL, 0x080fe200020006ffULL, 0x000000291e1e9232ULL, 0x000fe20000000000ULL,
0x0000005aff5a723eULL, 0x000fe200030006ffULL, 0x0000002a1d1d9232ULL, 0x080fe20000000000ULL,
0x0000005bff5b723eULL, 0x000fe200030006ffULL, 0x0000002a1f1f9232ULL, 0x000fce0000000000ULL,
0x000000141c50723cULL, 0x040b6e0000001850ULL, 0x0000005cff14723eULL, 0x0a0fe200020006ffULL,
0x000000081c08723cULL, 0x000f620000001834ULL, 0x0000005dff15723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400030006ffULL, 0x0000005dff5d723eULL, 0x000fc600030006ffULL,
0x000000141c10723cULL, 0x040b6e0000001810ULL, 0x0000005eff14723eULL, 0x0a0fe200020006ffULL,
0x0000000c1c0c723cULL, 0x000b620000001838ULL, 0x0000005fff15723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fc400030006ffULL, 0x0000005fff5f723eULL, 0x000fc600030006ffULL,
0x0000005a1c18723cULL, 0x040b700000001818ULL, 0x0000005c1c2c723cULL, 0x040b70000000182cULL,
0x000000141c54723cULL, 0x040b700000001854ULL, 0x0000005e1c1c723cULL, 0x000b620000001830ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x020e64000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x0106bc00ff167984ULL, 0x000ea40000000800ULL, 0x8000000016ff7812ULL, 0x006fc40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614327210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003216167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000133337810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000223147810ULL, 0x000fc80007ffe0ffULL, 0x000000041400720cULL, 0x000fe20003f06070ULL,
0x0000580020147a24ULL, 0x010fc800078e02ffULL, 0x0000008014177824ULL, 0x000fd000078e00ffULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x0000000107157824ULL, 0x000fe200078e022bULL,
0x000000022b377810ULL, 0x000fe40007ffe0ffULL, 0x000000c041417810ULL, 0x000fe20007ffe0ffULL,
0x0000000115167824ULL, 0x000fe200078e0205ULL, 0x000000042b397810ULL, 0x000fe20007ffe0ffULL,
0x0000001015367824ULL, 0x000fe200078e00ffULL, 0x0000004102147217ULL, 0x000fe20007800000ULL,
0x0000000107307824ULL, 0x000fe200078e0237ULL, 0x000000062b3b7810ULL, 0x000fe20007ffe0ffULL,
0x0000008006157824ULL, 0x000fe200078e0215ULL, 0xfffffff036367812ULL, 0x000fe200078ee216ULL,
0x0000000130167824ULL, 0x000fc400078e0205ULL, 0x0000001030387824ULL, 0x000fe200078e00ffULL,
0x0000001715347210ULL, 0x0c0fe20007f1e0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a41ULL,
0x0000000215337810ULL, 0x000fe20007ffe0ffULL, 0x0000000107317824ULL, 0x040fe200078e0239ULL,
0xfffffff038387812ULL, 0x000fe200078ee216ULL, 0x0000000107167824ULL, 0x040fe200078e023bULL,
0x0000001407147217ULL, 0x000fe20007800000ULL, 0x0000000131307824ULL, 0x100fe200078e0205ULL,
0x0000000615327810ULL, 0x000fe20007ffe0ffULL, 0x00000010313a7824ULL, 0x000fe200078e00ffULL,
0x0000000415317810ULL, 0x000fe20007ffe0ffULL, 0x0000000116357824ULL, 0x040fe200078e0205ULL,
0x0000001733337210ULL, 0x080fe20007f9e0ffULL, 0x00000010163c7824ULL, 0x000fe200078e00ffULL,
0xfffffff03a3a7812ULL, 0x000fe200078ee230ULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0000001731317210ULL, 0x000fe20007f7e0ffULL, 0x0000000114167824ULL, 0x000fe200078e0a07ULL,
0x00005e0034307a11ULL, 0x000fc400078440ffULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee235ULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x00005f0034347a11ULL, 0x000fe200010f4415ULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x000000162b00720cULL, 0x000fe40003f46070ULL,
0x00005e00312b7a11ULL, 0x000fe400078640ffULL, 0x000000f025357812ULL, 0x000fe400078ec0ffULL,
0x0000001732177210ULL, 0x000fc40007f1e0ffULL, 0x00005f0031317a11ULL, 0x000fe400018f4414ULL,
0x00005e0033327a11ULL, 0x040fe200078840ffULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x0000003530147210ULL, 0x000fe40007fbe0ffULL, 0x00005f0033337a11ULL, 0x000fe400020f4415ULL,
0x000000163700720cULL, 0x080fe20003f86070ULL, 0x000000ffff157224ULL, 0x000fe200028e0634ULL,
0x000000163900720cULL, 0x000fc40003f66070ULL, 0x0000c00036367811ULL, 0x000fe400078e20ffULL,
0x000000163b00720cULL, 0x000fe40003f06070ULL, 0x00005e0017307a11ULL, 0x040fe200078c40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014367faeULL, 0x0003e2000d101c46ULL,
0x0000003532167210ULL, 0x080fe40007fbe0ffULL, 0x00005f0017257a11ULL, 0x000fe400030f4425ULL,
0x0000c00038387811ULL, 0x000fe200078e20ffULL, 0x000000ffff177224ULL, 0x000fe200028e0633ULL,
0x0000003530307210ULL, 0x000fc40007fbe0ffULL, 0x0000c0003a3a7811ULL, 0x000fe400078e20ffULL,
0x0000c0003c3c7811ULL, 0x000fe200078e20ffULL, 0x0000000016387faeULL, 0x0005e2000e101c46ULL,
0x000000352b147210ULL, 0x002fca0007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe400010e0631ULL,
0x000000ffff317224ULL, 0x000fc600028e0625ULL, 0x00000000143a7faeULL, 0x0005e8000d901c46ULL,
0x00000000303c7faeULL, 0x0005e2000c101c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x00000001072b7824ULL, 0x000fe200078e022bULL, 0x000000f025257812ULL, 0x000fc600078ec0ffULL,
0x000000012b147824ULL, 0x040fe200078e0205ULL, 0x000000022b157810ULL, 0x040fe20007ffe0ffULL,
0x000000102b307824ULL, 0x040fe200078e00ffULL, 0x000000042b317810ULL, 0x000fc60007ffe0ffULL,
0x0000000115167824ULL, 0x040fe200078e0205ULL, 0xfffffff030307812ULL, 0x000fe200078ee214ULL,
0x0000001015337824ULL, 0x000fe400078e00ffULL, 0x0000008006147824ULL, 0x000fe200078e022bULL,
0x000000062b2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000131347824ULL, 0x100fe200078e0205ULL,
0xfffffff033337812ULL, 0x000fe200078ee216ULL, 0x0000001031367824ULL, 0x000fe200078e00ffULL,
0x0000001714157210ULL, 0x040fe20007f1e0ffULL, 0x000000012b317824ULL, 0x040fe200078e0205ULL,
0x0000000214167810ULL, 0x040fe20007ffe0ffULL, 0x000000102b3a7824ULL, 0x000fe200078e00ffULL,
0x0000000414327810ULL, 0x000fc40007ffe0ffULL, 0x0000000614357810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00000017162b7210ULL, 0x080fe40007f5e0ffULL,
0x00005e0015167a11ULL, 0x000fe400078040ffULL, 0x0000001732327210ULL, 0x080fe40007f7e0ffULL,
0x0000001735377210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0xfffffff03a3a7812ULL, 0x000fc400078ee231ULL, 0x00005f0015157a11ULL, 0x000fe200000f4414ULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x00005e002b317a11ULL, 0x000fe400078440ffULL,
0x0000002516147210ULL, 0x000fe40007f1e0ffULL, 0xfffffff036367812ULL, 0x000fe200078ee234ULL,
0x000000ffff347224ULL, 0x000fe200018e06ffULL, 0x00005e0032357a11ULL, 0x000fe200078640ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00005e0037397a11ULL, 0x000fc400078840ffULL,
0x00005f002b2b7a11ULL, 0x000fe400010f4417ULL, 0x0000c00030177811ULL, 0x000fe400078e20ffULL,
0x0000002531167210ULL, 0x080fe40007f1e0ffULL, 0x00005f0032347a11ULL, 0x000fe200018f4434ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000b901c46ULL,
0x0000002535307210ULL, 0x000fe40007f5e0ffULL, 0x00005f0037387a11ULL, 0x000fc400020f4438ULL,
0x0000002539327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe200010e0634ULL,
0x0000c00036367811ULL, 0x000fe400078e20ffULL, 0x0000c0003a3a7811ULL, 0x000fe400078e20ffULL,
0x0000c00033147811ULL, 0x002fe200078e20ffULL, 0x000000ffff177224ULL, 0x000fe400000e062bULL,
0x000000ffff337224ULL, 0x000fc600018e0638ULL, 0x0000000016147faeULL, 0x0003e8000b901c46ULL,
0x0000000030367faeULL, 0x0003e8000b901c46ULL, 0x00000000323a7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x006fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff487f8cULL, 0x000e64000c80043fULL, 0x000000ffff487224ULL, 0x002fc400078e0049ULL,
0x0000000000147805ULL, 0x000fca0000015200ULL, 0x0106b400ff167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fc4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614257210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000002516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff167984ULL, 0x000e640000000800ULL, 0x8000000016ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000028ff14723eULL, 0x000fe400000000ffULL,
0x00000002ff157819ULL, 0x000fe40000011605ULL, 0x0000541014147816ULL, 0x000fe20000000014ULL,
0x000067227f007947ULL, 0x000fea000b800000ULL, 0x00001f1514297589ULL, 0x0002a400000e0000ULL,
0x00000008152a7810ULL, 0x000fe20007ffe0ffULL, 0x000067527f007947ULL, 0x000fea000b800000ULL,
0x00001f2a142a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010153f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0014ULL,
0x0000cfe0003e7802ULL, 0x000fc40000000f00ULL, 0x00006c2000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018153f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x004fe200078e0014ULL, 0x0000d030003e7802ULL, 0x000fc40000000f00ULL,
0x00006bd000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b80042427811ULL, 0x000fc400078e20ffULL,
0x000000004314783bULL, 0x00ae680000004200ULL, 0x000000004230783bULL, 0x000ee80000000200ULL,
0x000000004434783bULL, 0x000f220000004200ULL, 0x0000312014147816ULL, 0x002fc400000000ffULL,
0x0000312015157816ULL, 0x000fe200000000ffULL, 0x0000002930309232ULL, 0x08cfe20000000000ULL,
0x00000014ff26723eULL, 0x080fe200020006ffULL, 0x0000002932329232ULL, 0x000fe20000000000ULL,
0x00000015ff27723eULL, 0x080fe200020006ffULL, 0x0000002a31319232ULL, 0x080fe20000000000ULL,
0x00000014ff14723eULL, 0x000fe200030006ffULL, 0x0000002a33339232ULL, 0x000fe20000000000ULL,
0x00000015ff15723eULL, 0x000fe400030006ffULL, 0x0000312016167816ULL, 0x000fc400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x000000263038723cULL, 0x040b620000001808ULL,
0x0000312034347816ULL, 0x010fe400000000ffULL, 0x0000312035357816ULL, 0x000fe400000000ffULL,
0x0000312036367816ULL, 0x000fe400000000ffULL, 0x00000016ff08723eULL, 0x020fe200020006ffULL,
0x000000143040723cULL, 0x000b62000000180cULL, 0x00000017ff09723eULL, 0x000fe200020006ffULL,
0x00000000460c783bULL, 0x020e620000004200ULL, 0x0000312037377816ULL, 0x000fc800000000ffULL,
0x0000b80045147811ULL, 0x000fe200078e20ffULL, 0x000000083050723cULL, 0x000be20000001850ULL,
0x000000004744783bULL, 0x000fec0000004200ULL, 0x00000016ff08723eULL, 0x020fe400030006ffULL,
0x00000017ff09723eULL, 0x000fc400030006ffULL, 0x000000001414783bULL, 0x000eaa0000000200ULL,
0x000000083018723cULL, 0x000b6e0000001818ULL, 0x00000034ff08723eULL, 0x020fc400020006ffULL,
0x00000035ff09723eULL, 0x080fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x00000008304c723cULL, 0x040b620000001810ULL,
0x000031200c0c7816ULL, 0x002fe400000000ffULL, 0x000031200d0d7816ULL, 0x000fe400000000ffULL,
0x000031200e0e7816ULL, 0x000fe400000000ffULL, 0x00000036ff08723eULL, 0x0a0fe200020006ffULL,
0x00000034302c723cULL, 0x000b62000000182cULL, 0x00000037ff09723eULL, 0x000fe400020006ffULL,
0x00000036ff36723eULL, 0x000fc400030006ffULL, 0x00000037ff37723eULL, 0x000fe400030006ffULL,
0x0000000cff34723eULL, 0x0a0fe200020006ffULL, 0x000000083054723cULL, 0x040f620000001854ULL,
0x0000000dff35723eULL, 0x080fe200020006ffULL, 0x0000002914149232ULL, 0x084fe20000000000ULL,
0x0000000cff0c723eULL, 0x000fe200030006ffULL, 0x0000002916169232ULL, 0x000fe20000000000ULL,
0x0000000dff0d723eULL, 0x000fe200030006ffULL, 0x0000002a15159232ULL, 0x080fe20000000000ULL,
0x000031200f0f7816ULL, 0x000fe200000000ffULL, 0x000000363030723cULL, 0x000b62000000181cULL,
0x0000002a17179232ULL, 0x000fe20000000000ULL, 0x0000312044447816ULL, 0x000fc400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fe400000000ffULL,
0x000000341434723cULL, 0x000f640000001838ULL, 0x0000000eff1c723eULL, 0x0a0fe400020006ffULL,
0x0000000fff1d723eULL, 0x000fe400020006ffULL, 0x0000000eff0e723eULL, 0x000fc400030006ffULL,
0x0000000fff0f723eULL, 0x000fe200030006ffULL, 0x0000000c1438723cULL, 0x040b620000001840ULL,
0x00000044ff10723eULL, 0x000fe400020006ffULL, 0x00000046ff08723eULL, 0x000fe400020006ffULL,
0x00000047ff09723eULL, 0x000fe400020006ffULL, 0x00003120450d7816ULL, 0x020fe200000000ffULL,
0x0000000e1418723cULL, 0x000b620000001818ULL, 0x00000044ff0c723eULL, 0x000fc400030006ffULL,
0x0000000dff11723eULL, 0x080fe400020006ffULL, 0x0000000dff0d723eULL, 0x000fe400030006ffULL,
0x00000046ff46723eULL, 0x000fe200030006ffULL, 0x0000001c141c723cULL, 0x000b620000001850ULL,
0x00000047ff47723eULL, 0x000fce00030006ffULL, 0x000000101410723cULL, 0x040b70000000184cULL,
0x0000000c140c723cULL, 0x040b70000000182cULL, 0x000000081408723cULL, 0x040b700000001854ULL,
0x000000461414723cULL, 0x000b620000001830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff267f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000000224407810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x022fc400078e0027ULL,
0x0000000123237810ULL, 0x000fc80007ffe0ffULL, 0x000000042300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff3b3000007947ULL, 0x000fea000383ffffULL,
0x000000ff0400720cULL, 0x000fe20003f05270ULL, 0x000000ffff287224ULL, 0x000fe400078e0015ULL,
0x000000ffff277224ULL, 0x000fe400078e0014ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0017ULL,
0x000000ffff297224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fe400078e0013ULL,
0x000000ffff147224ULL, 0x000fc400078e0012ULL, 0x000000ffff267224ULL, 0x000fe400078e000bULL,
0x000000ffff257224ULL, 0x008fe400078e000aULL, 0x000000ffff247224ULL, 0x000fe400078e0009ULL,
0x000000ffff237224ULL, 0x000fe400078e0008ULL, 0x000000ffff227224ULL, 0x000fe400078e000fULL,
0x000000ffff207224ULL, 0x000fc400078e000eULL, 0x000000ffff177224ULL, 0x000fe400078e000dULL,
0x000000ffff167224ULL, 0x000fe400078e000cULL, 0x000000ffff137224ULL, 0x000fe400078e0011ULL,
0x000000ffff127224ULL, 0x000fe200078e0010ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000021027810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x000fe200078e0021ULL,
0x0000d82000057802ULL, 0x000fc40000000f00ULL, 0x0000620000007944ULL, 0x006fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002100047308ULL, 0x000ee40000001000ULL,
0xbf80000004217423ULL, 0x008fc80000000021ULL, 0x800000ff21217221ULL, 0x000fc80000010100ULL,
0x0000002104047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff027624ULL, 0x000fe400078e00ffULL, 0x00006900ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x000728000c1e9900ULL, 0x0000000000057919ULL, 0x000ee40000000000ULL,
0x00000002ff037819ULL, 0x008fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000402027220ULL, 0x010fca0000410000ULL, 0x00001f0302037589ULL, 0x000ee800000e0000ULL,
0x00001f0502027589ULL, 0x000f2200000e0000ULL, 0x0000003403347220ULL, 0x048fe20000410000ULL,
0x0000003503357220ULL, 0x040fe20000410000ULL, 0x0000003803387220ULL, 0x040fe20000410000ULL,
0x0000003903397220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x040fe20000410000ULL, 0x0000001803187220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x040fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x000fe20000410000ULL, 0x0000003602367220ULL, 0x050fe20000410000ULL,
0x0000003702377220ULL, 0x040fe20000410000ULL, 0x0000003a023a7220ULL, 0x040fe20000410000ULL,
0x0000003b023b7220ULL, 0x040fe20000410000ULL, 0x0000001e021e7220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000001a021a7220ULL, 0x040fe20000410000ULL,
0x0000001b021b7220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002202227220ULL, 0x040fe20000410000ULL, 0x0000002502257220ULL, 0x040fe20000410000ULL,
0x0000002602267220ULL, 0x040fe20000410000ULL, 0x0000002902297220ULL, 0x040fe20000410000ULL,
0x0000002a022a7220ULL, 0x000fc20000410000ULL, 0x0000000000217919ULL, 0x000ee20000000000ULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x0000580000047ab9ULL, 0x000fc40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff047819ULL, 0x008fc60000011621ULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x0000000221027812ULL, 0x040fe400078ec0ffULL, 0x0000000821057811ULL, 0x000fe200078ff0ffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000000402037211ULL, 0x000fe200078ff8ffULL,
0x0000000804097824ULL, 0x000fe200078e00ffULL, 0x0000000502067211ULL, 0x000fe200078ff8ffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000203027810ULL, 0x040fe20007ffe0ffULL,
0x00000008040b7824ULL, 0x040fe200078e00ffULL, 0x0000000403057810ULL, 0x000fe20007ffe0ffULL,
0x00000008040c7824ULL, 0x000fe200078e00ffULL, 0xfffffff808047812ULL, 0x000fc400078ee203ULL,
0x0000000603037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee206ULL,
0xfffffff809067812ULL, 0x000fe400078ee202ULL, 0xfffffff80c097812ULL, 0x000fe200078ee203ULL,
0x0000000821037824ULL, 0x000fe200078e00ffULL, 0xfffffff80b087812ULL, 0x000fe400078ee205ULL,
0x0000a00000057811ULL, 0x000fc400078e58ffULL, 0x0000000803037812ULL, 0x000fe400078ec0ffULL,
0x000000343500723eULL, 0x000fe200000000ffULL, 0x0000001004047824ULL, 0x100fe200078e0205ULL,
0x000000383902723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x00000003ff0c7819ULL, 0x000fe20000011621ULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x0000541000107816ULL, 0x100fe20000000002ULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x0000763200117816ULL, 0x000fe20000000002ULL, 0x0000001008007824ULL, 0x100fe200078e0205ULL,
0x00000020210e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001009027824ULL, 0x000fc400078e0205ULL,
0x0000001004007388ULL, 0x0007e20000000a00ULL, 0x00000003ff0f7819ULL, 0x000fe2000001160eULL,
0x00000001030b7824ULL, 0x040fe400078e020aULL, 0x0000000103087824ULL, 0x040fe400078e0206ULL,
0x0000000103097824ULL, 0x000fe200078e0200ULL, 0x0000001c1d00723eULL, 0x000fe200000000ffULL,
0x00000001030a7824ULL, 0x000fe200078e0202ULL, 0x000000181902723eULL, 0x000fe200000000ffULL,
0x000000010e0d7824ULL, 0x000fe200078e020fULL, 0x000000121303723eULL, 0x000fe200000000ffULL,
0x000000010c047824ULL, 0x008fe200078e0221ULL, 0x0000541000127816ULL, 0x000fc40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001208007388ULL, 0x000fe20000000a00ULL,
0x0ffffff804067812ULL, 0x000fe400078ef821ULL, 0x000000161704723eULL, 0x000fe400000000ffULL,
0x0ffffff80d107812ULL, 0x000fe200078ef80eULL, 0x00000010060d7824ULL, 0x000fe200078e0205ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0000001010107824ULL, 0x000fe200078e0205ULL, 0x000000232400723eULL, 0x000fe400000000ffULL,
0x0000003a3b04723eULL, 0x000fe200000000ffULL, 0x0000000209007388ULL, 0x0007e20000000a00ULL,
0x0000001e1f05723eULL, 0x000fe400000000ffULL, 0x0000001a1b06723eULL, 0x000fe400000000ffULL,
0x0000000721217812ULL, 0x000fc400078ec0ffULL, 0x000000070e0e7812ULL, 0x000fc800078ec0ffULL,
0x1ffffff80e0e7812ULL, 0x000fe400078ef807ULL, 0x000000272802723eULL, 0x008fe400000000ffULL,
0x000000363703723eULL, 0x000fe400000000ffULL, 0x0000541000127816ULL, 0x140fe40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x000000120a007388ULL, 0x000fe20000000a00ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000020b007388ULL, 0x0007e20000000a00ULL, 0x000000141500723eULL, 0x000fc600000000ffULL,
0x0004000408007388ULL, 0x0009e20000000a00ULL, 0x000000202202723eULL, 0x008fe400000000ffULL,
0x000000252603723eULL, 0x000fe200000000ffULL, 0x0000000000057919ULL, 0x010ee20000002600ULL,
0x000000292a04723eULL, 0x000fe400000000ffULL, 0x0000541000127816ULL, 0x140fe40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004001209007388ULL, 0x000fe80000000a00ULL,
0x000400020a007388ULL, 0x0009e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000d087984ULL, 0x000ea20000000c00ULL, 0x0000000805007824ULL, 0x008fc600078e00ffULL,
0x0000000010107984ULL, 0x000ee20000000c00ULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff8000c7812ULL, 0x000fc800078ee20cULL, 0xfffffff8050f7812ULL, 0x000fe400078ee20fULL,
0x000000040c0c7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040f0f7c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a000c027a11ULL, 0x050fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a000f047a11ULL, 0x000fe400078248ffULL,
0x00005b000c037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff821007812ULL, 0x000fe400078ef807ULL,
0x00005b000f057a11ULL, 0x000fc600008f4c05ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x000000100e047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x004fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff077819ULL, 0x000fe20000011600ULL, 0xffffffffff287424ULL, 0x000fc600078e00ffULL,
0x000000030700720cULL, 0x000fda0003f06070ULL, 0x0000000222088824ULL, 0x000fc800078e00ffULL,
0x0000640008088a24ULL, 0x000fc800078e0207ULL, 0x0000600008088625ULL, 0x000fe200078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff2c7624ULL, 0x000fe200078e00ffULL,
0x0000000608288981ULL, 0x0002a2000c1e1900ULL, 0x00006900ff2d7624ULL, 0x000fca00078e00ffULL,
0x000000062c2c7981ULL, 0x000722000c1e9900ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000008006067824ULL, 0x000fe400078e00ffULL, 0x00000040002a7824ULL, 0x000fe200078e00ffULL,
0x01060000ff087f8cULL, 0x002e62000c80043fULL, 0x0000008029297824ULL, 0x000fc600078e00ffULL,
0x0000004006107812ULL, 0x000fe200078ef82aULL, 0x00000029281c7224ULL, 0x004fc800078e02ffULL,
0x0000071000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011605ULL,
0x000000300e1a7812ULL, 0x000fe400078ec0ffULL, 0x000000081d1e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001100a7824ULL, 0x040fe200078e021dULL, 0x000000101d1f7810ULL, 0x040fe40007ffe0ffULL,
0x000000181d207810ULL, 0x000fe20007ffe0ffULL, 0x00000001100b7824ULL, 0x000fe200078e021eULL,
0x0000000a1c1b7210ULL, 0x000fe20007f1e0ffULL, 0x00000001100a7824ULL, 0x000fe200078e021fULL,
0x0000200000137811ULL, 0x000fc400078e68ffULL, 0x0000000b1c197210ULL, 0x000fe20007f3e0ffULL,
0x00000001100b7824ULL, 0x000fe200078e0220ULL, 0x0000000a1c187210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e001b157a11ULL, 0x000fe200078040ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0019147a11ULL, 0x000fe400078240ffULL,
0x0000000b1c177210ULL, 0x000fe40007f7e0ffULL, 0x0000002a020a7217ULL, 0x000fc40007800000ULL,
0x00005f001b1b7a11ULL, 0x000fe200000f440dULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x00005e00180f7a11ULL, 0x000fe200078040ffULL, 0x000000010a117824ULL, 0x000fe200078e0a2aULL,
0x00005f0019197a11ULL, 0x000fe200008f440cULL, 0x000000ffff0c7224ULL, 0x000fe200018e06ffULL,
0x00000005050b7211ULL, 0x000fe400078fe8ffULL, 0x00005e0017167a11ULL, 0x000fe400078240ffULL,
0x00005f0018187a11ULL, 0x000fe200000f440dULL, 0x000000041e0d7824ULL, 0x000fe200078e00ffULL,
0x000000151a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000041f157824ULL, 0x000fe200078e00ffULL,
0x000000030b127812ULL, 0x000fc400078ec0ffULL, 0x00005f0017177a11ULL, 0x000fe200008f440cULL,
0x000000ffff0b7224ULL, 0x000fe200018e061bULL, 0x000000111d00720cULL, 0x080fe40003f06070ULL,
0x000000111e00720cULL, 0x080fe40003f26070ULL, 0x0ffffffc12057812ULL, 0x000fe400078ef805ULL,
0xfffffffc0d0d7812ULL, 0x000fe400078ee212ULL, 0x0000001a140c7210ULL, 0x080fe20007f7e0ffULL,
0x0000001005057824ULL, 0x100fe200078e0213ULL, 0x0000001a0f0e7210ULL, 0x000fe20007f9e0ffULL,
0x000000100d147824ULL, 0x000fe200078e0213ULL, 0x000000111f00720cULL, 0x080fe20003f46070ULL,
0x000000ffff0d7224ULL, 0x000fe200018e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a057faeULL, 0x0003e2000c101c46ULL, 0x000000ffff0f7224ULL, 0x000fe200020e0618ULL,
0x000000112000720cULL, 0x040fe20003f86070ULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0x000000000c147faeULL, 0x0005e2000c901c46ULL, 0xfffffffc15157812ULL, 0x000fca00078ee212ULL,
0x0000001015157824ULL, 0x000fe200078e0213ULL, 0x0000001a160a7210ULL, 0x002fc80007fbe0ffULL,
0x000000000e157faeULL, 0x0003e2000d101c46ULL, 0x000000201d0c7810ULL, 0x044fe40007ffe0ffULL,
0x000000281d0d7810ULL, 0x040fe40007ffe0ffULL, 0x000000381d147810ULL, 0x000fe20007ffe0ffULL,
0x0000000110057824ULL, 0x000fe200078e020cULL, 0x000000110c00720cULL, 0x080fe40003f66070ULL,
0x000000110d00720cULL, 0x000fe40003f46070ULL, 0x000000051c197210ULL, 0x000fe20007f1e0ffULL,
0x00000001100e7824ULL, 0x002fe200078e020dULL, 0xfffffffc20057812ULL, 0x000fc400078ee212ULL,
0x00005e0019187a11ULL, 0x000fe200078c40ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x000000301d0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001005057824ULL, 0x000fe200078e0213ULL,
0x000000111400720cULL, 0x080fe40003f06070ULL, 0x00005f0019197a11ULL, 0x000fe200030f440bULL,
0x000000ffff0b7224ULL, 0x000fe200028e0617ULL, 0x0000000e1c0e7210ULL, 0x000fe40007fbe0ffULL,
0x000000110f00720cULL, 0x000fe20003f26070ULL, 0x0000000110117824ULL, 0x000fe200078e020fULL,
0x000000000a057faeULL, 0x0003e2000e101c46ULL, 0x000000ffff177224ULL, 0x000fe200028e06ffULL,
0x00005e000e167a11ULL, 0x000fe200078a40ffULL, 0x0000000110107824ULL, 0x000fe200078e0214ULL,
0x000000111c157210ULL, 0x000fc40007f9e0ffULL, 0x00005f000e177a11ULL, 0x000fe400028f4417ULL,
0x000000101c117210ULL, 0x000fe20007fde0ffULL, 0x000000040d0a7824ULL, 0x002fe400078e00ffULL,
0x000000040c057824ULL, 0x000fe400078e00ffULL, 0x000000040f0b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee212ULL, 0x00000004140c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc05057812ULL, 0x100fe200078ee212ULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0xfffffffc0b0b7812ULL, 0x100fe200078ee212ULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0xfffffffc0c0c7812ULL, 0x000fe200078ee212ULL, 0x000000100a127824ULL, 0x100fe200078e0213ULL,
0x0000001a180a7210ULL, 0x080fe20007fbe0ffULL, 0x0000001005057824ULL, 0x100fe200078e0213ULL,
0x00005e00150e7a11ULL, 0x000fe200078840ffULL, 0x000000100b147824ULL, 0x100fe200078e0213ULL,
0x00005e0011107a11ULL, 0x000fe200078c40ffULL, 0x000000100c137824ULL, 0x000fe200078e0213ULL,
0x00005f00150f7a11ULL, 0x000fe200020f440fULL, 0x000000ffff0b7224ULL, 0x000fe200028e0619ULL,
0x0000001a160c7210ULL, 0x000fc40007fbe0ffULL, 0x00005f0011117a11ULL, 0x000fe400030f440dULL,
0x0000001a0e0e7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e0617ULL,
0x0000001a10107210ULL, 0x000fe20007fbe0ffULL, 0x000000000a057faeULL, 0x0003e4000d901c46ULL,
0x000000ffff0f7224ULL, 0x000fe400020e060fULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x000000000c127faeULL, 0x0003e8000d101c46ULL, 0x000000000e147faeULL, 0x0003e8000c901c46ULL,
0x0000000010137faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x00000010050a7211ULL, 0x04afe400078ff0ffULL, 0x00000008051a7811ULL, 0x000fc400078ff0ffULL,
0x0000000a1c0a7210ULL, 0x000fe40007f1e0ffULL, 0x00000010050b7811ULL, 0x040fe400078ff0ffULL,
0x00000018050d7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff267224ULL, 0x000fe200000e06ffULL,
0x00005e000a257a11ULL, 0x000fe200078040ffULL, 0x00000001100c7824ULL, 0x040fe200078e020bULL,
0x0000002005117811ULL, 0x040fe200078ff0ffULL, 0x00000001100f7824ULL, 0x000fe200078e020dULL,
0x00005f000a267a11ULL, 0x000fe200000f4426ULL, 0x00000001100a7824ULL, 0x040fe200078e021aULL,
0x0000000505187211ULL, 0x040fe200078fe8ffULL, 0x0000000110127824ULL, 0x000fe200078e0211ULL,
0x0000002805137811ULL, 0x040fe200078ff0ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0x0000003005157811ULL, 0x000fc400078ff0ffULL, 0x0000000a1c247210ULL, 0x040fe20007fde0ffULL,
0x000000040b0a7824ULL, 0x000fe200078e00ffULL, 0x0000000c1c217210ULL, 0x040fe20007fbe0ffULL,
0x000000040d0b7824ULL, 0x000fe200078e00ffULL, 0x0000003805177811ULL, 0x000fe200078ff0ffULL,
0x00000004110c7824ULL, 0x000fe200078e00ffULL, 0x0000000f1c207210ULL, 0x000fe20007f1e0ffULL,
0x00000004130d7824ULL, 0x000fe200078e00ffULL, 0x0000000318187812ULL, 0x000fe200078ec0ffULL,
0x00000004150f7824ULL, 0x000fe200078e00ffULL, 0x00002000001d7811ULL, 0x000fe200078e68ffULL,
0x0000000110147824ULL, 0x000fe200078e0213ULL, 0x0ffffffc18137812ULL, 0x000fe200078ef805ULL,
0x0000000110167824ULL, 0x040fe200078e0215ULL, 0xfffffffc0b0b7812ULL, 0x100fe200078ee218ULL,
0x0000000110107824ULL, 0x000fe200078e0217ULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee218ULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0xfffffffc0c0c7812ULL, 0x100fe200078ee218ULL,
0x00000010132b7824ULL, 0x100fe200078e021dULL, 0x000000121c1f7210ULL, 0x000fe20007f3e0ffULL,
0x000000100b157824ULL, 0x100fe200078e021dULL, 0x00005e0024237a11ULL, 0x000fe200078c40ffULL,
0x000000100a137824ULL, 0x100fe200078e021dULL, 0xfffffffc0d0d7812ULL, 0x100fe200078ee218ULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0xfffffffc0f0f7812ULL, 0x100fe200078ee218ULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0xfffffffc1a057812ULL, 0x000fe200078ee218ULL,
0x000000100c1a7824ULL, 0x100fe200078e021dULL, 0x000000141c1e7210ULL, 0x040fe20007f5e0ffULL,
0x000000100d1b7824ULL, 0x000fe200078e021dULL, 0x000000161c127210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200028e06ffULL, 0x000000101c197210ULL, 0x000fe20007f9e0ffULL,
0x0000000417107824ULL, 0x000fe200078e00ffULL, 0x00005f0024247a11ULL, 0x000fe200030f4411ULL,
0x000000100f1c7824ULL, 0x100fe200078e021dULL, 0x00005e0020117a11ULL, 0x000fe200078040ffULL,
0x000000ffff177224ULL, 0x000fe200018e06ffULL, 0x00005e00210f7a11ULL, 0x000fe200078a40ffULL,
0x0000001005057824ULL, 0x000fe200078e021dULL, 0x00005e001f0d7a11ULL, 0x000fc400078240ffULL,
0x000000300e277812ULL, 0x000fe400078ec0ffULL, 0x00005f0020207a11ULL, 0x000fe200000f440bULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0xfffffffc10107812ULL, 0x000fe400078ee218ULL,
0x00005f0021217a11ULL, 0x000fe200028f440cULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x00005f001f1f7a11ULL, 0x000fe200008f440aULL, 0x00000010101d7824ULL, 0x000fe200078e021dULL,
0x00005e0019187a11ULL, 0x000fc400078640ffULL, 0x00000025270a7210ULL, 0x000fe40007f1e0ffULL,
0x00005e001e147a11ULL, 0x000fe400078240ffULL, 0x00005e0012167a11ULL, 0x000fe400078440ffULL,
0x00005f0019197a11ULL, 0x000fe200018f440bULL, 0x000000ffff0b7224ULL, 0x000fe200000e0626ULL,
0x00005f001e1e7a11ULL, 0x000fe400008f440cULL, 0x00000023270c7210ULL, 0x000fc40007f1e0ffULL,
0x00005f0012177a11ULL, 0x000fe200010f4417ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2b7faeULL, 0x0003e2000b901c46ULL, 0x0000000f270e7210ULL, 0x040fe40007f3e0ffULL,
0x0000001127107210ULL, 0x040fe40007f5e0ffULL, 0x0000000d27127210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e0624ULL, 0x0000001427147210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e0621ULL, 0x0000001627167210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0620ULL, 0x0000001827187210ULL, 0x000fe20007f1e0ffULL,
0x000000000c057faeULL, 0x0003e4000b901c46ULL, 0x000000ffff177224ULL, 0x000fc400028e0617ULL,
0x000000000e137faeULL, 0x0005e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc600000e0619ULL,
0x0000000010157faeULL, 0x0007e2000b901c46ULL, 0x000000ffff137224ULL, 0x004fe400018e061fULL,
0x000000ffff157224ULL, 0x008fc600020e061eULL, 0x00000000121a7faeULL, 0x0003e8000b901c46ULL,
0x00000000141b7faeULL, 0x0003e8000b901c46ULL, 0x00000000161c7faeULL, 0x0003e8000b901c46ULL,
0x00000000181d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000a7805ULL, 0x002fc40000015200ULL, 0x01060400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140dULL, 0x0000000c05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e060dULL, 0x0000000205057819ULL, 0x000fc8000000120cULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002000057824ULL, 0x002fca00078e0205ULL, 0x00000003ff087819ULL, 0x000fe40000011605ULL,
0x0000000f05057812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe08087812ULL, 0x000fe400078ec0ffULL,
0x0000000105097810ULL, 0x040fe20007ffe0ffULL, 0x00000020050d7824ULL, 0x040fe400078e00ffULL,
0x00000001050a7824ULL, 0x040fe400078e0208ULL, 0x00000001080b7824ULL, 0x040fe200078e0209ULL,
0x0000001008087810ULL, 0x000fe20007ffe0ffULL, 0x00000020050c7824ULL, 0x000fe200078e00ffULL,
0x0000001f0a0a7812ULL, 0x000fc400078ec0ffULL, 0x0000001f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000105147824ULL, 0x000fe200078e0208ULL, 0x000001e00c0a7812ULL, 0x000fe200078ee20aULL,
0x0000000109087824ULL, 0x000fe200078e0208ULL, 0x000001e00d0b7812ULL, 0x000fe200078ee20bULL,
0x0000002005097824ULL, 0x040fe200078e00ffULL, 0x0000001f14147812ULL, 0x000fe200078ec0ffULL,
0x000000000a107984ULL, 0x000e62000000cc00ULL, 0x0000002005057824ULL, 0x000fe200078e00ffULL,
0x0000001f08087812ULL, 0x000fe400078ec0ffULL, 0x000000000b0c7984ULL, 0x000ea2000000cc00ULL,
0x000001e009147812ULL, 0x000fc400078ee214ULL, 0x000001e005087812ULL, 0x000fe200078ee208ULL,
0x000000ffff187224ULL, 0x002fe400078e0010ULL, 0x000000ffff197224ULL, 0x000fe400078e0012ULL,
0x000000ffff1b7224ULL, 0x004fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff0c7224ULL, 0x000fe200078e0011ULL,
0x000000180a007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff0d7224ULL, 0x000fca00078e0013ULL,
0x0000000c0b007388ULL, 0x000fe8000000cc00ULL, 0x00000000080c7984ULL, 0x000e68000000cc00ULL,
0x0000000014107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c14007388ULL, 0x0003e8000000cc00ULL, 0x0000000c08007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff0c7f8cULL, 0x002e62000c80043fULL,
0x000000ffff0e7224ULL, 0x000fc600078e00ffULL, 0x0000000000087805ULL, 0x000fc80000015200ULL,
0x01060400ff057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00006400222b7a24ULL, 0x000fe200078e02ffULL, 0x3d8000002c2c7820ULL, 0x010fe20000410000ULL,
0x00010688002d7811ULL, 0x000fe200078e18ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0xffffffff042e7810ULL, 0x000fe40007ffe0ffULL, 0x00010608002f7811ULL, 0x000fc600078e28ffULL,
0x0000010030327824ULL, 0x000fe200078e022aULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000320200720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e0031ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x0000000133357810ULL, 0x000fe20007ffe0ffULL, 0x00000d8000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fc400078e0033ULL, 0x0000003035317211ULL, 0x040fe200078ff0ffULL,
0x0000002928477224ULL, 0x010fe200078e02ffULL, 0x000000043500780cULL, 0x000fe20003f06070ULL,
0x000000ffff337224ULL, 0x000fe200078e0035ULL, 0x0000000131367810ULL, 0x040fe20007ffe0ffULL,
0x0000010031407824ULL, 0x000fe200078e022aULL, 0x0000000134317812ULL, 0x000fe400078e0cffULL,
0x000000043600720cULL, 0x000fe40003f26070ULL, 0x0000004040367812ULL, 0x000fc400078ec0ffULL,
0x0000000335557812ULL, 0x000fc600078ec0ffULL, 0x0000000106417824ULL, 0x000fcc00078e0236ULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff427819ULL, 0x002fe20000011605ULL,
0x0000000200487824ULL, 0x000fc600078e0231ULL, 0x00000010424f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000142357824ULL, 0x140fe200078e0241ULL, 0x0000000842447810ULL, 0x040fe40007ffe0ffULL,
0x0000001842507810ULL, 0x000fe20007ffe0ffULL, 0x000000014f377824ULL, 0x100fe200078e0241ULL,
0x00000035473f7210ULL, 0x040fe20007f3e0ffULL, 0x0000000144367824ULL, 0x000fe200078e0241ULL,
0x0000004002357217ULL, 0x000fe20007800000ULL, 0x00000004444a7824ULL, 0x000fe200078e00ffULL,
0x0000003747397210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff377224ULL, 0x000fe200008e06ffULL,
0x00000036473b7210ULL, 0x000fe20007f5e0ffULL, 0x0000000135357824ULL, 0x000fe200078e0a40ULL,
0x00005e003f367a11ULL, 0x000fe200078240ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e06ffULL,
0x00005e00393c7a11ULL, 0x000fe200078640ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x00005e003b3a7a11ULL, 0x000fc400078440ffULL, 0x00005f00393d7a11ULL, 0x000fe200018f443dULL,
0x0000000150397824ULL, 0x100fe200078e0241ULL, 0x0000002042517810ULL, 0x040fe40007ffe0ffULL,
0x0000002842527810ULL, 0x040fe40007ffe0ffULL, 0x0000003042537810ULL, 0x040fe40007ffe0ffULL,
0x0000003842547810ULL, 0x000fe40007ffe0ffULL, 0x00005f003b3b7a11ULL, 0x000fe200010f443eULL,
0x00000001513e7824ULL, 0x000fe200078e0241ULL, 0x00005f003f377a11ULL, 0x000fe200008f4437ULL,
0x00000001523f7824ULL, 0x100fe200078e0241ULL, 0x000000354200720cULL, 0x000fe20003f46070ULL,
0x0000000153407824ULL, 0x100fe200078e0241ULL, 0x0000003947427210ULL, 0x040fe20007f3e0ffULL,
0x0000000154397824ULL, 0x000fe200078e0241ULL, 0x0000003e47417210ULL, 0x000fc40007fbe0ffULL,
0x0000003f47437210ULL, 0x040fe20007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x0000004047457210ULL, 0x040fe40007f9e0ffULL, 0x0000003947477210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200030e06ffULL, 0x0000000505397211ULL, 0x000fe200078fe8ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x00005e00423e7a11ULL, 0x040fe200078240ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x00000003394e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff397224ULL, 0x000fe200028e06ffULL, 0x00005f00423f7a11ULL, 0x000fe200008f443fULL,
0x0000000455427824ULL, 0x000fe200078e00ffULL, 0x00005e0041407a11ULL, 0x000fc400078a40ffULL,
0x000000354400720cULL, 0x000fe40003f26070ULL, 0x00005f0041417a11ULL, 0x000fe400028f4439ULL,
0x0000200048487811ULL, 0x000fe400078e60ffULL, 0x0ffffffc4e497812ULL, 0x100fe400078ef805ULL,
0xfffffffc42397812ULL, 0x000fe400078ee205ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0x00005e0043427a11ULL, 0x000fe200078a40ffULL,
0x0000001039367825ULL, 0x000fe200078e0036ULL, 0x00005e0045447a11ULL, 0x000fc400078640ffULL,
0x00005e0047467a11ULL, 0x000fe200078840ffULL, 0x000000104a4a7824ULL, 0x000fe200078e0248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036497faeULL, 0x0003e2000d101c46ULL,
0x00000010393a7825ULL, 0x000fe200078e003aULL, 0x00005f0043437a11ULL, 0x000fe400028f444dULL,
0x00005f0045457a11ULL, 0x000fe200018f444cULL, 0x00000004534c7824ULL, 0x000fe200078e00ffULL,
0x00005f0047477a11ULL, 0x000fe200020f444bULL, 0x000000003a4a7faeULL, 0x0005e2000c901c46ULL,
0x000000354f00720cULL, 0x080fe20003f26070ULL, 0x00000004524b7824ULL, 0x000fe200078e00ffULL,
0x000000355000720cULL, 0x000fc40003f46070ULL, 0x000000355100720cULL, 0x080fe20003f66070ULL,
0x0000000450497824ULL, 0x002fe200078e00ffULL, 0x000000355200720cULL, 0x080fe20003f86070ULL,
0x0000001039367825ULL, 0x000fe200078e003cULL, 0x000000355300720cULL, 0x080fe40003fa6070ULL,
0x000000355400720cULL, 0x040fe20003fc6070ULL, 0x000000044f357824ULL, 0x000fe200078e00ffULL,
0xfffffffc49497812ULL, 0x100fe200078ee24eULL, 0x00000004514a7824ULL, 0x004fe200078e00ffULL,
0xfffffffc4b4b7812ULL, 0x100fe200078ee24eULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0xfffffffc35357812ULL, 0x000fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e0248ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL, 0x00000010393a7825ULL, 0x000fe200078e003eULL,
0xfffffffc4c4c7812ULL, 0x000fc400078ee24eULL, 0xfffffffc544e7812ULL, 0x000fe200078ee24eULL,
0x0000001035357824ULL, 0x100fe400078e0248ULL, 0x000000104a4a7824ULL, 0x000fe400078e0248ULL,
0x00000010393c7825ULL, 0x000fe200078e0040ULL, 0x0000000036357faeULL, 0x0003e6000c901c46ULL,
0x000000104b4b7824ULL, 0x000fe200078e0248ULL, 0x000000003a497faeULL, 0x0003e2000d101c46ULL,
0x00000010393e7825ULL, 0x000fc600078e0042ULL, 0x000000003c4a7faeULL, 0x0003e2000d901c46ULL,
0x000000104c4c7824ULL, 0x000fe400078e0248ULL, 0x0000001039407825ULL, 0x040fe200078e0044ULL,
0x000000003e4b7faeULL, 0x0003e6000e101c46ULL, 0x000000104e487824ULL, 0x000fe200078e0248ULL,
0x00000000404c7faeULL, 0x0003e2000e901c46ULL, 0x0000001039427825ULL, 0x000fca00078e0046ULL,
0x0000000042487faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008053d7811ULL, 0x002fe200078ff0ffULL, 0x0000000455517824ULL, 0x000fe200078e00ffULL,
0x0000004105357211ULL, 0x040fe400078ff0ffULL, 0x00000018053e7811ULL, 0x000fe200078ff0ffULL,
0x000000013d367824ULL, 0x000fe200078e0241ULL, 0x0000003547377210ULL, 0x000fe20007f3e0ffULL,
0x000000043d457824ULL, 0x000fe200078e00ffULL, 0x00000020053f7811ULL, 0x000fe200078ff0ffULL,
0x000000043e487824ULL, 0x000fe200078e00ffULL, 0x0000003647357210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200008e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078240ffULL,
0x000000043f497824ULL, 0x000fe200078e00ffULL, 0x0000002805427811ULL, 0x000fe200078ff0ffULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0x00005e00353a7a11ULL, 0x000fc400078440ffULL,
0x00005f0037377a11ULL, 0x000fe200008f443bULL, 0x00000004424a7824ULL, 0x000fe200078e00ffULL,
0x00005f00353b7a11ULL, 0x000fe200010f4439ULL, 0x0000000200357824ULL, 0x000fe200078e0231ULL,
0x0000001005397811ULL, 0x040fe200078ff0ffULL, 0x00000001423d7824ULL, 0x100fe200078e0241ULL,
0x0000003005437811ULL, 0x040fe400078ff0ffULL, 0x0000003805447811ULL, 0x000fe200078ff0ffULL,
0x0000000439467824ULL, 0x000fe200078e00ffULL, 0x00000005053c7211ULL, 0x000fe200078fe8ffULL,
0x00000004434b7824ULL, 0x000fe200078e00ffULL, 0x00002000354c7811ULL, 0x000fe200078e60ffULL,
0x0000000139357824ULL, 0x000fe200078e0241ULL, 0x000000033c407812ULL, 0x000fe200078ec0ffULL,
0x00000004444d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc51517812ULL, 0x000fe200078ee205ULL,
0x000000013e397824ULL, 0x100fe200078e0241ULL, 0x0000003547357210ULL, 0x000fe20007f7e0ffULL,
0x000000013f3c7824ULL, 0x100fe200078e0241ULL, 0xfffffffc46467812ULL, 0x100fe200078ee240ULL,
0x00000001433e7824ULL, 0x100fe200078e0241ULL, 0xfffffffc48487812ULL, 0x100fe200078ee240ULL,
0x00000001443f7824ULL, 0x000fe200078e0241ULL, 0xfffffffc45447812ULL, 0x000fe200078ee240ULL,
0x0000001051367825ULL, 0x000fe200078e0036ULL, 0xfffffffc49497812ULL, 0x000fc400078ee240ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee240ULL, 0x0000001048487824ULL, 0x000fe200078e024cULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee240ULL, 0x0000001049497824ULL, 0x000fe200078e024cULL,
0xfffffffc4d4d7812ULL, 0x000fe200078ee240ULL, 0x000000104a4a7824ULL, 0x100fe200078e024cULL,
0x0ffffffc40427812ULL, 0x000fe200078ef805ULL, 0x000000104b4b7824ULL, 0x100fe200078e024cULL,
0x0000003947407210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff397224ULL, 0x000fe200018e06ffULL,
0x0000003c47417210ULL, 0x040fe20007f3e0ffULL, 0x0000001042527824ULL, 0x000fe200078e024cULL,
0x0000003d47437210ULL, 0x000fc40007f7e0ffULL, 0x0000003e47457210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff507224ULL, 0x000fe200008e06ffULL, 0x0000003f47477210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0x00005e00353c7a11ULL, 0x040fe200078c40ffULL,
0x000000ffff4f7224ULL, 0x000fe200018e06ffULL, 0x00005e00403e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff4e7224ULL, 0x000fe200020e06ffULL, 0x00005f00353d7a11ULL, 0x000fe200030f4439ULL,
0x0000001044357824ULL, 0x100fe200078e024cULL, 0x00005f00403f7a11ULL, 0x000fe200010f443fULL,
0x0000001046397824ULL, 0x100fe200078e024cULL, 0x00005e0041407a11ULL, 0x000fe200078240ffULL,
0x000000104d4c7824ULL, 0x000fe200078e024cULL, 0x00005e0043427a11ULL, 0x000fe200078440ffULL,
0x000000ffff4d7224ULL, 0x000fe200028e06ffULL, 0x00005e0045447a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036527faeULL, 0x0003e2000b901c46ULL,
0x00005e0047467a11ULL, 0x000fc400078840ffULL, 0x00005f0041417a11ULL, 0x000fe400008f4450ULL,
0x00005f0043437a11ULL, 0x000fe400010f444fULL, 0x00005f0045457a11ULL, 0x000fe400018f444eULL,
0x00005f0047477a11ULL, 0x000fe200020f444dULL, 0x0000001051367825ULL, 0x002fc800078e003aULL,
0x00000010513a7825ULL, 0x040fe200078e003cULL, 0x0000000036357faeULL, 0x0003e6000b901c46ULL,
0x00000010513c7825ULL, 0x040fe200078e003eULL, 0x000000003a397faeULL, 0x0003e6000b901c46ULL,
0x00000010513e7825ULL, 0x040fe200078e0040ULL, 0x000000003c487faeULL, 0x0003e6000b901c46ULL,
0x0000001051407825ULL, 0x040fe200078e0042ULL, 0x000000003e497faeULL, 0x0003e6000b901c46ULL,
0x0000001051427825ULL, 0x040fe200078e0044ULL, 0x00000000404a7faeULL, 0x0003e6000b901c46ULL,
0x0000001051447825ULL, 0x000fe200078e0046ULL, 0x00000000424b7faeULL, 0x0003e8000b901c46ULL,
0x00000000444c7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035500780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000207077810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff287424ULL, 0x000fc600078e00ffULL, 0x000000030700720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000022b367824ULL, 0x002fe400078e0207ULL,
0x00000004ff377424ULL, 0x000fc800078e00ffULL, 0x0000600036367625ULL, 0x000fca00078e0037ULL,
0x0000000636287981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002005357810ULL, 0x042fe20007ffe0ffULL,
0x0000000200367824ULL, 0x000fe200078e0234ULL, 0xfffffff805347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe400078ec0ffULL,
0x0000000705377812ULL, 0x000fe400078ec0ffULL, 0x00000007343b7812ULL, 0x100fe400078ef805ULL,
0x0000000735457812ULL, 0x000fc400078ef805ULL, 0x0000200036547811ULL, 0x000fe400078e60ffULL,
0x0000000837557812ULL, 0x000fe400078ef805ULL, 0x00000001ff447819ULL, 0x000fe4000001163bULL,
0x00000001ff467819ULL, 0x000fe20000011645ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000004383a7824ULL, 0x100fe200078e0239ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000144347824ULL, 0x020fe200078e0239ULL, 0x0000000139477810ULL, 0x000fe20007ffe0ffULL,
0x000000043b357824ULL, 0x000fc400078e00ffULL, 0x000000023a3a7824ULL, 0x000fe400078e00ffULL,
0x0000002055367824ULL, 0x000fe200078e00ffULL, 0xfffffffc35357812ULL, 0x000fe200078ee234ULL,
0x00000001463c7824ULL, 0x000fe200078e0239ULL, 0x0000003a05347211ULL, 0x000fe200078fe0ffULL,
0x00000004453d7824ULL, 0x000fe200078e00ffULL, 0x000000023a3a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001035357824ULL, 0x000fe200078e0254ULL, 0x0000000239397810ULL, 0x000fe20007ffe0ffULL,
0x0000000155347824ULL, 0x000fe200078e0234ULL, 0xfffffffc3d3c7812ULL, 0x000fc400078ee23cULL,
0x000000003540783bULL, 0x000e620000000200ULL, 0x0000003a053a7211ULL, 0x000fe400078fe0ffULL,
0xffffffe036347812ULL, 0x000fe200078ee234ULL, 0x000000103c3c7824ULL, 0x000fe200078e0254ULL,
0x000000043900780cULL, 0x000fe20003f25270ULL, 0x00000001553a7824ULL, 0x000fe400078e023aULL,
0x0000001034347824ULL, 0x000fe400078e00ffULL, 0x000000003c3c783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x00000040ff48723eULL, 0x002fc400020006ffULL,
0x00000040ff49723eULL, 0x000fe400030006ffULL, 0x00000041ff40723eULL, 0x080fe400020006ffULL,
0x00000041ff41723eULL, 0x000fce00030006ffULL, 0x000000403420723cULL, 0x044bee0000001820ULL,
0x00000042ff40723eULL, 0x0a0fe200020006ffULL, 0x000000483424723cULL, 0x000b620000001824ULL,
0x00000042ff41723eULL, 0x000fe200030006ffULL, 0x0000000144427824ULL, 0x000fc400078e0247ULL,
0x0000000146477824ULL, 0x000fc600078e0247ULL, 0x000000043b487824ULL, 0x020fe200078e00ffULL,
0x00000040341c723cULL, 0x000b62000000181cULL, 0x0000003cff49723eULL, 0x000fc600030006ffULL,
0xfffffffc48487812ULL, 0x000fe400078ee242ULL, 0x00000043ff42723eULL, 0x080fe200020006ffULL,
0x0000002055407824ULL, 0x020fe200078e00ffULL, 0x00000043ff43723eULL, 0x000fe200030006ffULL,
0x0000001048487824ULL, 0x000fc600078e0254ULL, 0xffffffe0403a7812ULL, 0x000fe400078ee23aULL,
0x00000000484c783bULL, 0x0002a20000000200ULL, 0x000000423418723cULL, 0x000b640000001818ULL,
0x000000103a3a7824ULL, 0x000fe200078e00ffULL, 0x0000003cff48723eULL, 0x002fc800020006ffULL,
0x000000003a40783bULL, 0x020e620000000200ULL, 0x0000003dff3c723eULL, 0x080fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe200030006ffULL, 0x000000483414723cULL, 0x040f700000001814ULL,
0x0000003c3448723cULL, 0x000bee0000001810ULL, 0x0000000445127824ULL, 0x020fe200078e00ffULL,
0x0000003eff10723eULL, 0x000fc400020006ffULL, 0x0000003eff11723eULL, 0x000fe400030006ffULL,
0xfffffffc12477812ULL, 0x000fe400078ee247ULL, 0x0000003fff3e723eULL, 0x080fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe200030006ffULL, 0x0000001047477824ULL, 0x000fe200078e0254ULL,
0x00000010340c723cULL, 0x040b68000000180cULL, 0x000000004750783bULL, 0x000ee60000000200ULL,
0x0000004cff10723eULL, 0x0a4fe200020006ffULL, 0x0000003e3408723cULL, 0x000f620000001808ULL,
0x0000004cff11723eULL, 0x000fc400030006ffULL, 0x0000004dff4c723eULL, 0x080fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fc600030006ffULL, 0x000000104024723cULL, 0x042b6e0000001824ULL,
0x0000004eff10723eULL, 0x0a0fe200020006ffULL, 0x0000004c4020723cULL, 0x000f620000001820ULL,
0x0000004eff11723eULL, 0x000fe400030006ffULL, 0x0000004fff4e723eULL, 0x000fc400020006ffULL,
0x0000004fff4f723eULL, 0x000fc600030006ffULL, 0x00000010401c723cULL, 0x040b70000000181cULL,
0x0000004e4018723cULL, 0x000f640000001818ULL, 0x00000050ff10723eULL, 0x028fc400020006ffULL,
0x00000050ff11723eULL, 0x000fe400030006ffULL, 0x00000052ff34723eULL, 0x080fe400020006ffULL,
0x00000052ff35723eULL, 0x000fe400030006ffULL, 0x00000053ff52723eULL, 0x080fe200020006ffULL,
0x000000104014723cULL, 0x000b620000001814ULL, 0x00000053ff53723eULL, 0x000fcc00030006ffULL,
0x00000051ff10723eULL, 0x0a0fe200020006ffULL, 0x00000034400c723cULL, 0x000b62000000180cULL,
0x00000051ff11723eULL, 0x000fce00030006ffULL, 0x000000104010723cULL, 0x040b700000001848ULL,
0x000000524008723cULL, 0x000b620000001808ULL, 0xfffffa8000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff347224ULL, 0x020fe200078e0031ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffeb0000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000002c1a357220ULL, 0x080fe20000410000ULL,
0x0000002c1e337220ULL, 0x080fe20000410000ULL, 0x0000002c1b367220ULL, 0x080fe20000410000ULL,
0x0000002c141a7220ULL, 0x080fe20000410000ULL, 0x0000002c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002c1f347220ULL, 0x080fe20000410000ULL,
0x0000002c151b7220ULL, 0x080fe20000410000ULL, 0x0000002c101e7220ULL, 0x080fe20000410000ULL,
0x0000002c24247220ULL, 0x080fe20000410000ULL, 0x0000002c25257220ULL, 0x080fe20000410000ULL,
0x0000002c20207220ULL, 0x080fe20000410000ULL, 0x0000002c21217220ULL, 0x080fe20000410000ULL,
0x0000002c18187220ULL, 0x080fe20000410000ULL, 0x0000002c19197220ULL, 0x080fe20000410000ULL,
0x0000002c111f7220ULL, 0x080fe20000410000ULL, 0x0000002c0c0c7220ULL, 0x080fe20000410000ULL,
0x0000002c0d0d7220ULL, 0x080fe20000410000ULL, 0x0000002c08087220ULL, 0x080fe20000410000ULL,
0x0000002c16377220ULL, 0x080fe20000410000ULL, 0x0000002c17387220ULL, 0x080fe20000410000ULL,
0x0000002c12397220ULL, 0x080fe20000410000ULL, 0x0000002c133a7220ULL, 0x080fe20000410000ULL,
0x000000ffff167224ULL, 0x000fe200078e001aULL, 0x0000002c0e3b7220ULL, 0x080fe20000410000ULL,
0x0000002c0f3c7220ULL, 0x080fe20000410000ULL, 0x000000ffff127224ULL, 0x000fe200078e001cULL,
0x0000002c26267220ULL, 0x080fe20000410000ULL, 0x000000ffff137224ULL, 0x000fe200078e001dULL,
0x0000002c27277220ULL, 0x080fe20000410000ULL, 0x000000ffff177224ULL, 0x000fe200078e001bULL,
0x0000002c22227220ULL, 0x080fe20000410000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e001eULL,
0x0000002c23237220ULL, 0x080fe20000410000ULL, 0x0000002c09097220ULL, 0x080fe20000410000ULL,
0x0000002c0a0a7220ULL, 0x080fe20000410000ULL, 0x0000002c0b0b7220ULL, 0x000fe20000410000ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0024ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0025ULL,
0x000000ffff107224ULL, 0x000fe400078e0020ULL, 0x000000ffff117224ULL, 0x000fe400078e0021ULL,
0x000000ffff147224ULL, 0x000fe400078e0018ULL, 0x000000ffff157224ULL, 0x000fe400078e0019ULL,
0x000000ffff1b7224ULL, 0x000fc400078e001fULL, 0x000000ffff1c7224ULL, 0x000fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000dULL, 0x000000ffff1e7224ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002d0c7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff207224ULL, 0x000fe400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff247224ULL, 0x000fc400078e0033ULL, 0x000000ffff257224ULL, 0x000fe400078e0034ULL,
0x000000ffff267224ULL, 0x000fe400078e0035ULL, 0x000000ffff277224ULL, 0x000fe400078e0036ULL,
0x000000ffff337224ULL, 0x000fe400078e0037ULL, 0x000000ffff347224ULL, 0x000fe400078e0038ULL,
0x000000ffff357224ULL, 0x000fc400078e0039ULL, 0x000000ffff367224ULL, 0x000fe400078e003aULL,
0x000000ffff1f7224ULL, 0x000fe400078e0009ULL, 0x000000ffff377224ULL, 0x000fe400078e003bULL,
0x000000ffff387224ULL, 0x000fe400078e003cULL, 0x000000ffff397224ULL, 0x000fe400078e000aULL,
0x000000ffff3a7224ULL, 0x000fc400078e000bULL, 0x0000000000087805ULL, 0x006fca0000015200ULL,
0x000004002d0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08187210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09001800780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401800780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x000000180a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000119197810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004002d0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000405197824ULL, 0x000fe200078e00ffULL, 0x0000002e3000720cULL, 0x000fc80003f05270ULL,
0xfffffff019187812ULL, 0x000fca00078ec0ffULL, 0x0000008000187824ULL, 0x000fca00078e0218ULL,
0x0104000018087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002050c7824ULL, 0x000fe400078e00ffULL, 0x0000000102327824ULL, 0x000fc600078e0a32ULL,
0x000000060c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000010c0d7812ULL, 0x040fe400078efcffULL,
0x000000080c3b7812ULL, 0x040fe400078efcffULL, 0x000000320d00720cULL, 0x080fe40003f26070ULL,
0x000000100c0d7812ULL, 0x000fe400078efcffULL, 0x000000323b00720cULL, 0x080fe40003f06070ULL,
0x000000320d00720cULL, 0x000fc40003fc6070ULL, 0x000000110c3b7812ULL, 0x040fe400078efcffULL,
0x000000180c0d7812ULL, 0x040fe400078efcffULL, 0x000000320c00720cULL, 0x0c0fe40003f46070ULL,
0x000000323b00720cULL, 0x080fe40003fa6070ULL, 0x000000320d00720cULL, 0x000fe40003f66070ULL,
0x000000090c3c7812ULL, 0x000fc400078efcffULL, 0x000000190c3b7812ULL, 0x040fe400078efcffULL,
0x000000200c0d7812ULL, 0x000fe400078efcffULL, 0xff80000020207808ULL, 0x000fe40005000000ULL,
0xff8000000e0e7808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0xff8000000f0f7808ULL, 0x000fc40004800000ULL, 0x000000323c00720cULL, 0x080fe40003f86070ULL,
0x000000323b00720cULL, 0x080fe40003f46070ULL, 0x000000320d00720cULL, 0x000fe40003f26070ULL,
0x000000210c3b7812ULL, 0x040fe400078efcffULL, 0x000000280c0d7812ULL, 0x000fe400078efcffULL,
0xff80000022227808ULL, 0x000fc40004000000ULL, 0xff80000010107808ULL, 0x000fe40004000000ULL,
0xff80000023237808ULL, 0x000fe40006000000ULL, 0xff80000011117808ULL, 0x000fe40006000000ULL,
0x000000323b00720cULL, 0x080fe40003f06070ULL, 0x000000320d00720cULL, 0x000fe40003f86070ULL,
0x000000290c3b7812ULL, 0x000fc400078efcffULL, 0x000000300c0d7812ULL, 0x000fe400078efcffULL,
0xff80000024247808ULL, 0x000fe40007000000ULL, 0xff80000012127808ULL, 0x000fe40007000000ULL,
0xff80000025257808ULL, 0x000fe40006800000ULL, 0xff80000013137808ULL, 0x000fe40006800000ULL,
0x000000323b00720cULL, 0x000fc40003fc6070ULL, 0x000000320d00720cULL, 0x000fe40003fa6070ULL,
0x000000310c3b7812ULL, 0x040fe400078efcffULL, 0x000000380c0d7812ULL, 0x040fe400078efcffULL,
0x000000390c0c7812ULL, 0x000fe400078efcffULL, 0xff80000026267808ULL, 0x000fe40005800000ULL,
0xff80000014147808ULL, 0x000fc40005800000ULL, 0xff80000027277808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40005000000ULL, 0xff80000033337808ULL, 0x000fe40004800000ULL,
0xff80000016167808ULL, 0x000fe40004800000ULL, 0x000000323b00720cULL, 0x080fe40003f66070ULL,
0x000000320d00720cULL, 0x000fc40003f46070ULL, 0x000000320c00720cULL, 0x000fe40003f26070ULL,
0xff80000034347808ULL, 0x000fe40004000000ULL, 0xff80000017177808ULL, 0x000fe40004000000ULL,
0xff80000035357808ULL, 0x000fe40006000000ULL, 0xff8000001a1a7808ULL, 0x000fe40006000000ULL,
0xff80000036367808ULL, 0x000fc40007000000ULL, 0xff8000001b1b7808ULL, 0x000fe40007000000ULL,
0xff80000037377808ULL, 0x000fe40006800000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff80000038387808ULL, 0x000fe40005800000ULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff80000039397808ULL, 0x000fc40005000000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff8000003a3a7808ULL, 0x000fe40004800000ULL, 0xff8000001f1f7808ULL, 0x000fc40004800000ULL,
0x0000000e0800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff3d7424ULL, 0x000fe200078e00ffULL,
0x000000200900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x000000080e087208ULL, 0x000fe40004000000ULL, 0x0000000920097208ULL, 0x000fc40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000210900720bULL, 0x000fe40003f3e000ULL,
0x000000080f087208ULL, 0x000fe40004000000ULL, 0x0000000921097208ULL, 0x000fe40004800000ULL,
0x000000100800720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fc40003f3e000ULL,
0x0000000810087208ULL, 0x000fe40004000000ULL, 0x0000000922097208ULL, 0x000fe40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x000000230900720bULL, 0x000fe40003f3e000ULL,
0x0000000811087208ULL, 0x000fe40004000000ULL, 0x0000000923097208ULL, 0x000fc40004800000ULL,
0x000000120800720bULL, 0x000fe40003f1e000ULL, 0x000000240900720bULL, 0x000fe40003f3e000ULL,
0x0000000812087208ULL, 0x000fe40004000000ULL, 0x0000000924097208ULL, 0x000fe40004800000ULL,
0x000000130800720bULL, 0x000fe40003f1e000ULL, 0x000000250900720bULL, 0x000fc40003f3e000ULL,
0x0000000813087208ULL, 0x000fe40004000000ULL, 0x0000000925097208ULL, 0x000fe40004800000ULL,
0x000000140800720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fe40003f3e000ULL,
0x0000000814087208ULL, 0x000fe40004000000ULL, 0x0000000926097208ULL, 0x000fc40004800000ULL,
0x000000150800720bULL, 0x000fe40003f1e000ULL, 0x000000270900720bULL, 0x000fe40003f3e000ULL,
0x0000000815087208ULL, 0x000fe40004000000ULL, 0x0000000927097208ULL, 0x000fe40004800000ULL,
0x000000160800720bULL, 0x000fe40003f1e000ULL, 0x000000330900720bULL, 0x000fc40003f3e000ULL,
0x0000000816087208ULL, 0x000fe40004000000ULL, 0x0000000933097208ULL, 0x000fe40004800000ULL,
0x000000170800720bULL, 0x000fe40003f1e000ULL, 0x000000340900720bULL, 0x000fe40003f3e000ULL,
0x0000000817087208ULL, 0x000fe40004000000ULL, 0x0000000934097208ULL, 0x000fc40004800000ULL,
0x0000001a0800720bULL, 0x000fe40003f1e000ULL, 0x000000350900720bULL, 0x000fe40003f3e000ULL,
0x000000081a087208ULL, 0x000fe40004000000ULL, 0x0000000935097208ULL, 0x000fe40004800000ULL,
0x0000001b0800720bULL, 0x000fe40003f1e000ULL, 0x000000360900720bULL, 0x000fc40003f3e000ULL,
0x000000081b087208ULL, 0x000fe40004000000ULL, 0x0000000936097208ULL, 0x000fe40004800000ULL,
0x0000001c0800720bULL, 0x000fe40003f1e000ULL, 0x000000370900720bULL, 0x000fe40003f3e000ULL,
0x000000081c087208ULL, 0x000fe40004000000ULL, 0x0000000937097208ULL, 0x000fc40004800000ULL,
0x0000001d0800720bULL, 0x000fe40003f1e000ULL, 0x000000380900720bULL, 0x000fe40003f3e000ULL,
0x000000081d087208ULL, 0x000fe40004000000ULL, 0x0000000938097208ULL, 0x000fe40004800000ULL,
0x0000001e0800720bULL, 0x000fe40003f1e000ULL, 0x000000390900720bULL, 0x000fc40003f3e000ULL,
0x000000081e087208ULL, 0x000fe40004000000ULL, 0x0000000939097208ULL, 0x000fe40004800000ULL,
0x0000001f0800720bULL, 0x000fe40003f1e000ULL, 0x0000003a0900720bULL, 0x000fe40003f3e000ULL,
0x000000081f3c7208ULL, 0x000fe40004000000ULL, 0x000000093a097208ULL, 0x000fe20004800000ULL,
0x000018827f007947ULL, 0x000fec000b800000ULL, 0x0c401f003c087f89ULL, 0x0004e400000e0000ULL,
0x000000083c00720bULL, 0x008fc80003f1e000ULL, 0x0000003c083c7208ULL, 0x004fe20004000000ULL,
0x000018a27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009087f89ULL, 0x000ea800000e0000ULL,
0x0c401f000a0c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000b0d7f89ULL, 0x000e6200000e0000ULL,
0x000000080900720bULL, 0x004fc40003f1e000ULL, 0x0000000c0a00720bULL, 0x008fe40003f3e000ULL,
0x0000000908097208ULL, 0x000fe40004000000ULL, 0x0000000a0c0a7208ULL, 0x000fe20004800000ULL,
0x0c201f003c087f89ULL, 0x000ea200000e0000ULL, 0x0000000d0b00720bULL, 0x002fc60003f1e000ULL,
0x0c201f00090c7f89ULL, 0x000e6200000e0000ULL, 0x0000000b0d0b7208ULL, 0x000fc60004000000ULL,
0x0c201f000a327f89ULL, 0x000ee800000e0000ULL, 0x0c201f000b3b7f89ULL, 0x0002e200000e0000ULL,
0x000000083c00720bULL, 0x004fe40003f1e000ULL, 0x0000000c0900720bULL, 0x002fe40003f3e000ULL,
0x0000003c08087208ULL, 0x000fe40004000000ULL, 0x000000320a00720bULL, 0x008fc40003f5e000ULL,
0x000000090c097208ULL, 0x000fe40004800000ULL, 0x0000000a320a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080c7820ULL, 0x000fe20000410000ULL, 0x3c003c00ff447424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3c003c00ff457424ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001080cULL,
0x0000001c003f7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001080cULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b091c7820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe2000001080cULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b20207823ULL, 0x000fe2000001081cULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1f0c7823ULL, 0x000fe2000001080cULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001081cULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b39397823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b3a3a7823ULL, 0x000fe2000001081cULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x0000000c19197812ULL, 0x000fc400078ec0ffULL, 0x0000000305ff7812ULL, 0x000fe4000780c0ffULL,
0x0000003b0b00720bULL, 0x004fc60003f3e000ULL, 0x00000020000d7308ULL, 0x000fe20000000800ULL,
0x0000000b3b0b7208ULL, 0x000fce0004800000ULL, 0x0000002100217308ULL, 0x000e700000000800ULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x0000000d210d723eULL, 0x002fce00000000ffULL, 0x0000000c00427308ULL, 0x0003f00000000800ULL,
0x0000001400327308ULL, 0x000fe20000000800ULL, 0x0000000e0f0c723eULL, 0x002fe400000000ffULL,
0x00000010110e723eULL, 0x000fc400000000ffULL, 0x00000022230f723eULL, 0x004fc600000000ffULL,
0x00000015003c7308ULL, 0x000ff00000000800ULL, 0x00000016003d7308ULL, 0x000ff00000000800ULL,
0x00000017003e7308ULL, 0x0003f00000000800ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x000000440c14723cULL, 0x002f6e00000018ffULL, 0x0000001300137308ULL, 0x000e700000000800ULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000121310723eULL, 0x002fc400000000ffULL, 0x000000323c12723eULL, 0x000fe400000000ffULL,
0x00000002ff3c7819ULL, 0x000fc60000011605ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000013c207810ULL, 0x040fe40007ffe0ffULL, 0x000000023c217810ULL, 0x040fe40007ffe0ffULL,
0x000000063c327810ULL, 0x000fc60007ffe0ffULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000242511723eULL, 0x004fe200000000ffULL, 0x000000083c247824ULL, 0x040fe400078e00ffULL,
0x000000083c257824ULL, 0x000fc600078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee220ULL,
0x0000001d00407308ULL, 0x000fe20000000800ULL, 0xfffffff825257812ULL, 0x000fe400078ee221ULL,
0x000000262713723eULL, 0x002fca00000000ffULL, 0x0000001e00417308ULL, 0x0003e20000000800ULL,
0x000000083c267824ULL, 0x040fe400078e00ffULL, 0x000000083c277824ULL, 0x000fca00078e00ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x00000044101c723cULL, 0x022b6e0000001814ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000033c147810ULL, 0x060fe40007ffe0ffULL,
0x000000043c157810ULL, 0x000fc40007ffe0ffULL, 0xfffffff826267812ULL, 0x000fe400078ee214ULL,
0xfffffff827277812ULL, 0x000fe200078ee215ULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x0000003d3e14723eULL, 0x000fce00000000ffULL, 0x0000003400347308ULL, 0x000ea20000000800ULL,
0x0000001a1b16723eULL, 0x002fe200000000ffULL, 0x000000083c1a7824ULL, 0x040fe200078e00ffULL,
0x000000053c1b7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee23cULL,
0x0000003500357308ULL, 0x000ff00000000800ULL, 0x0000003600367308ULL, 0x000e620000000800ULL,
0x000000333415723eULL, 0x004fc400000000ffULL, 0x000000083c347810ULL, 0x040fe40007ffe0ffULL,
0xffffffff3c337810ULL, 0x000fc60007ffe0ffULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x000000353617723eULL, 0x002fce00000000ffULL, 0x0000003800387308ULL, 0x000e620000000800ULL,
0x000000083c357824ULL, 0x040fe400078e00ffULL, 0x000000083c367824ULL, 0x040fe400078e00ffULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x000000441420723cULL, 0x000b62000000181cULL,
0xfffffff8351b7812ULL, 0x000fe200078ee21bULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x0000a00000357811ULL, 0x000fe400078e58ffULL, 0xfffffff836327812ULL, 0x000fc400078ee232ULL,
0x00000008341c7824ULL, 0x020fe200078e00ffULL, 0x00000041421e723eULL, 0x000fe200000000ffULL,
0x000000101a1a7824ULL, 0x100fe200078e0235ULL, 0x0000003a003a7308ULL, 0x000ea20000000800ULL,
0x00000037381d723eULL, 0x002fe200000000ffULL, 0x0000001024247824ULL, 0x100fe200078e0235ULL,
0xfffffff81c347812ULL, 0x000fe200078ee234ULL, 0x0000001025257824ULL, 0x100fe200078e0235ULL,
0x0000003f401c723eULL, 0x000fe200000000ffULL, 0x0000001026267824ULL, 0x000fe200078e0235ULL,
0xfffffff83c337812ULL, 0x000fe200078ee233ULL, 0x0000001027277824ULL, 0x000fc400078e0235ULL,
0x000000011a1a7824ULL, 0x000fe400078e0219ULL, 0x000000101b1b7824ULL, 0x100fe400078e0235ULL,
0x0000000119247824ULL, 0x040fe200078e0224ULL, 0x0000000c1a007388ULL, 0x0003e20000000800ULL,
0x000000393a1f723eULL, 0x004fe200000000ffULL, 0x0000001032327824ULL, 0x000fe400078e0235ULL,
0x0000000119257824ULL, 0x000fe200078e0225ULL, 0x0000000e24007388ULL, 0x0003e20000000800ULL,
0x0000001033337824ULL, 0x000fc400078e0235ULL, 0x000000441c20723cULL, 0x000f620000001820ULL,
0x0000000119267824ULL, 0x040fe200078e0226ULL, 0x0000001025007388ULL, 0x0003e20000000800ULL,
0x0000001034347824ULL, 0x000fe400078e0235ULL, 0x0000000119277824ULL, 0x040fe200078e0227ULL,
0x0000001226007388ULL, 0x0003e20000000800ULL, 0x00000001191b7824ULL, 0x040fe400078e021bULL,
0x0000000119327824ULL, 0x040fe200078e0232ULL, 0x0000001427007388ULL, 0x0003e20000000800ULL,
0x0000000119337824ULL, 0x000fc400078e0233ULL, 0x0000000119347824ULL, 0x000fe200078e0234ULL,
0x000000161b007388ULL, 0x0003e80000000800ULL, 0x0000001c32007388ULL, 0x0003e80000000800ULL,
0x0000001e33007388ULL, 0x0003e40000000800ULL, 0x000000ffff217224ULL, 0x020fc400078e0022ULL,
0x0000000d34007388ULL, 0x0003e80000000800ULL, 0x0004000f24007388ULL, 0x0003e80000000800ULL,
0x0004001125007388ULL, 0x0003e80000000800ULL, 0x0004001326007388ULL, 0x0003e80000000800ULL,
0x0004001527007388ULL, 0x0003e80000000800ULL, 0x000400171b007388ULL, 0x0003e80000000800ULL,
0x0004001d32007388ULL, 0x0003e80000000800ULL, 0x0004001f33007388ULL, 0x0003e80000000800ULL,
0x0100000818008388ULL, 0x0003e80000000c00ULL, 0x0102002018008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002fff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002fff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000130307810ULL, 0x000fe20007ffe0ffULL,
0x000018002fff7f8cULL, 0x0003e6000c80043fULL, 0x000000043000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffcd6000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff3e7807ULL, 0x008fe40004000000ULL,
0x00012c00003f7802ULL, 0x000fc40000000f00ULL, 0x0000104000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff267224ULL, 0x000fe200078e004eULL, 0xfffef44000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x000fe40005000000ULL, 0x00012c50003f7802ULL, 0x000fc40000000f00ULL,
0x00000ff000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e004eULL,
0xfffef4a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x004fe200078e0030ULL,
0x00012ca0003e7802ULL, 0x000fc40000000f00ULL, 0x00000f6000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff3f7224ULL, 0x004fe200078e004eULL, 0xfffef54000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0030ULL, 0x00012cf0003e7802ULL, 0x000fc40000000f00ULL,
0x00000f1000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff3f7224ULL, 0x004fe200078e004eULL,
0xfffef66000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e002bULL,
0x00012d50003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e002eULL,
0x00000eb000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e004eULL,
0xfffefa5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002aULL,
0x00012db0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e002bULL,
0x00000e5000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e004eULL,
0xfffefa2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e003cULL,
0x00012e10003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e003dULL,
0x00000df000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e004eULL,
0xffff0f5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002aULL,
0x00012e70003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e003cULL,
0x00000d9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e004eULL,
0xffff0f2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x008fe40004000000ULL,
0x00012ec0003f7802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e004eULL, 0xffff24c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x000fe40005000000ULL, 0x00012f10003f7802ULL, 0x000fc40000000f00ULL,
0x00000d3000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e004eULL,
0xffff250000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e003eULL,
0x00012f70003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e004fULL,
0x00000c9000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e004eULL,
0xffff25b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e003eULL,
0x00012fd0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e004fULL,
0x00000c3000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e004eULL,
0xffff26b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e003cULL,
0x00013030003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0048ULL,
0x00000bd000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e004eULL,
0xffff2ae000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002aULL,
0x00013090003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e003cULL,
0x00000b7000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e004eULL,
0xffff2ab000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0049ULL,
0x000130f0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e004aULL,
0x00000b1000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e004eULL,
0xffff3df000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002aULL,
0x00013150003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0049ULL,
0x00000ab000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e004eULL,
0xffff3dc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x004fe40004000000ULL,
0x000131a0003f7802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e004eULL, 0xffff51f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x000fe40005000000ULL, 0x000131f0003f7802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e004eULL,
0xffff522000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e003eULL,
0x00013250003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e004fULL,
0x000009b000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e004eULL,
0xffff52d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e003eULL,
0x000132b0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e004fULL,
0x0000095000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e004eULL,
0xffff53d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0040ULL,
0x00013310003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0048ULL,
0x000008f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e004eULL,
0xffff57e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002aULL,
0x00013370003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0040ULL,
0x0000089000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e004eULL,
0xffff57b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0040ULL,
0x000133d0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0049ULL,
0x0000083000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e004eULL,
0xffff6af000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002aULL,
0x00013430003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0040ULL,
0x000007d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e004eULL,
0xffff6ac000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x008fe40004000000ULL,
0x00013480003f7802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff497224ULL, 0x000fe200078e004eULL, 0xffff7f7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x000fe40004800000ULL, 0x000134d0003f7802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e004eULL,
0xffff7fa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002cULL,
0x00013530003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e004cULL,
0x000006d000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff2c7224ULL, 0x004fe200078e004eULL,
0xffff805000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e004cULL,
0x00013590003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e002cULL,
0x0000067000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff2c7224ULL, 0x004fe200078e004eULL,
0xffff815000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e002cULL,
0x000135f0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e002dULL,
0x0000061000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e004eULL,
0xffff856000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002aULL,
0x00013650003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e002cULL,
0x000005b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e004eULL,
0xffff853000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0014ULL,
0x000136b0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0015ULL,
0x0000055000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e004eULL,
0xffff989000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e002aULL,
0x00013710003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0014ULL,
0x000004f000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e004eULL,
0xffff986000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x000fe200078e003cULL,
0x0001377000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fc400078e00ffULL,
0x0000044000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003bULL,
0xffffe73000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0009ULL,
0x000137d000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x012fea0003c00000ULL, 0x0000003b0900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000aULL, 0x0001383000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000093b097208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x0000003b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000bULL, 0x0001389000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a3b0a7208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x0000003b0b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e003cULL, 0x000138f000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000b3b0b7208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x0000003b3c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0x0001395000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003c3b087208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x0000003b0900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000aULL, 0x000139b000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000093b097208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x0000003b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000bULL, 0x00013a1000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a3b0a7208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe60000007947ULL, 0x000fea000383ffffULL,
0x0180000003027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000300028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000204ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000003037812ULL, 0x002fe400078ec0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000204ff7212ULL, 0x000fda000780c0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000300027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x002fc800078e00ffULL,
0xfffec45002007950ULL, 0x000fea0003c3ffffULL, 0x0000003e00007348ULL, 0x000fe80003800000ULL,
0x0c00000d0c3b7389ULL, 0x0002a400000e003dULL, 0x000000ffff0c7224ULL, 0x002fe400078e0032ULL,
0x00000000ff0d7424ULL, 0x000fc800078e00ffULL, 0xfffec4000c007950ULL, 0x000fea0003c3ffffULL,
0x0000002700007348ULL, 0x000fe80003800000ULL, 0x0000003f4e4e7389ULL, 0x0002a400000e0026ULL,
0x00000000ff3f7424ULL, 0x002fc800078e00ffULL, 0xfffec3c03e007950ULL, 0x000fea0003c3ffffULL,
0x000000013e00780cULL, 0x000fe20003f45070ULL, 0x0000002d00007348ULL, 0x000fd80003800000ULL,
0x00000000003e7806ULL, 0x000fc800050e0100ULL, 0x0000002d3e4e7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe400078e003fULL, 0x00000000ff3f7424ULL, 0x000fc800078e00ffULL,
0xfffec3503e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000428ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000df0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eb0ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018b8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018c8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001958ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000195cULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b80ULL, 0x0000000000013d80ULL, 0x6a00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015900ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015950ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015cd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001958ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013fa8ULL, 0x0000000000013fa8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015900ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015cd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 89520;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
