/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015d50ULL, 0x00000000000159d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000013af0ULL, 0x0000000000000190ULL,
0x000b0022000004bdULL, 0x0000000000013c80ULL, 0x0000000000000050ULL, 0x000b0022000004e8ULL,
0x0000000000013cd0ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x0000000000013d10ULL,
0x0000000000000170ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000013e80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00013af000000000ULL, 0x0000040400000000ULL,
0x810c000001580400ULL, 0x004d580400288080ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8608288080840828ULL, 0x2880809408288080ULL, 0x80a208288080a008ULL,
0x08288080a5082880ULL, 0x8080a908288080a6ULL, 0xbc08288080ab0828ULL, 0x288080be08288080ULL,
0x80c708288080bf08ULL, 0x08288080c8082880ULL, 0x8080cb08288080caULL, 0xcd08288080cc0828ULL,
0x2880808508288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808085ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00013af000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL,
0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL,
0x8094082880808c08ULL, 0x08288080a0082880ULL, 0x8080a508288080a2ULL, 0xa908288080a60828ULL,
0x288080ab08288080ULL, 0x80be08288080bc08ULL, 0x08288080bf082880ULL, 0x8080c808288080c7ULL,
0xcb08288080ca0828ULL, 0x288080cd08288080ULL, 0x828016288080b108ULL, 0x0000000003102880ULL,
0x8080b19200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL, 0x0000015800000000ULL,
0x00013c8000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808c288080b10900ULL,
0x0000000000002880ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL,
0x2880808608288080ULL, 0x80a0082880809408ULL, 0x08288080a2082880ULL, 0x8080a608288080a5ULL,
0xab08288080a90828ULL, 0x288080bc08288080ULL, 0x80c708288080bf08ULL, 0x08288080c8082880ULL,
0x8080cb08288080caULL, 0xcd08288080cc0828ULL, 0x288080be08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080beULL, 0x0000001cffffffffULL, 0x0000024000000000ULL,
0x00013cd000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL, 0x80a0082880809408ULL,
0x08288080a2082880ULL, 0x8080a608288080a5ULL, 0xab08288080a90828ULL, 0x288080bc08288080ULL,
0x80c708288080be08ULL, 0x08288080c8082880ULL, 0x8080cb08288080caULL, 0xcd08288080cc0828ULL,
0x288080bf08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080bfULL,
0x0000002cffffffffULL, 0x0000031000000000ULL, 0x00013d1000000000ULL, 0x0000017000000000ULL,
0x0000140400000000ULL, 0x80be288080bf0900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL,
0x0008230400000066ULL, 0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL,
0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL,
0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL,
0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL,
0x0000001700080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x0198290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000010001982804ULL, 0x0000047000000120ULL, 0x000021a0000020f0ULL,
0x0000240000002290ULL, 0x0000288000002850ULL, 0x00002920000028d0ULL, 0x00003e4000003e10ULL,
0x00003ee000003e90ULL, 0x000054d000005440ULL, 0x00005740000055e0ULL, 0x00005c0000005bd0ULL,
0x00005ca000005c50ULL, 0x00006fd000006fa0ULL, 0x0000707000007020ULL, 0x00008550000084d0ULL,
0x000087c000008660ULL, 0x00008c6000008c30ULL, 0x00008d0000008cb0ULL, 0x0000a0300000a000ULL,
0x0000a0d00000a080ULL, 0x0000b5b00000b530ULL, 0x0000b8200000b6c0ULL, 0x0000bcc00000bc90ULL,
0x0000bd600000bd10ULL, 0x0000d0b00000d080ULL, 0x0000d1500000d100ULL, 0x0000d9f00000d9e0ULL,
0x00011f800000e1c0ULL, 0x00011fd000011fc0ULL, 0x0001203000011fe0ULL, 0x0001207000012050ULL,
0x00012cc000012080ULL, 0x00012d6000012d10ULL, 0x00012e1000012db0ULL, 0x00012ed000012e70ULL,
0x00012f8000012f30ULL, 0x0001303000012fd0ULL, 0x000130f000013090ULL, 0x000131b000013150ULL,
0x0001326000013210ULL, 0x00013310000132b0ULL, 0x000133d000013370ULL, 0x0001349000013430ULL,
0x00013540000134f0ULL, 0x000135f000013590ULL, 0x000136b000013650ULL, 0x0001377000013710ULL,
0x00013830000137d0ULL, 0x000138f000013890ULL, 0x000139b000013950ULL, 0x00013a7000013a10ULL,
0x0600390400013ad0ULL, 0x000000ff000001f0ULL, 0x003f010000010600ULL, 0x0000000700000220ULL,
0x003f012000010608ULL, 0x00000007000002c0ULL, 0x003f012000010688ULL, 0x0000000700000440ULL,
0x003f0120000106a8ULL, 0x000000ff00000460ULL, 0x003f0100000106b8ULL, 0x000000ff000004e0ULL,
0x003f010700010600ULL, 0x0000000700000630ULL, 0x003f01020001068cULL, 0x0000000700000690ULL,
0x003f010100010688ULL, 0x000000ff00000ef0ULL, 0x003f0107000106a8ULL, 0x000000ff00001010ULL,
0x003f0101000106a8ULL, 0x000000ff00001070ULL, 0x003f0101000106b8ULL, 0x000000ff00001200ULL,
0x003f0105000106bcULL, 0x000000ff000013d0ULL, 0x003f0105000106bcULL, 0x000000ff00001c90ULL,
0x003f0107000106b0ULL, 0x000000ff00001db0ULL, 0x003f0101000106b0ULL, 0x0000000700001e10ULL,
0x003f010100010608ULL, 0x0000000700001e30ULL, 0x003f01050001060cULL, 0x0000000700002000ULL,
0x003f01050001060cULL, 0x000000ff000025b0ULL, 0x003f0105000106acULL, 0x000000ff00002780ULL,
0x003f0105000106acULL, 0x000000ff000030a0ULL, 0x003f0101000106b8ULL, 0x000000ff000030c0ULL,
0x003f0105000106bcULL, 0x000000ff00003290ULL, 0x003f0105000106bcULL, 0x000000ff00003ae0ULL,
0x003f0107000106a8ULL, 0x000000ff00003b60ULL, 0x003f0101000106a8ULL, 0x000000ff00003b90ULL,
0x003f0105000106b4ULL, 0x000000ff00003d60ULL, 0x003f0105000106b4ULL, 0x000000ff00004570ULL,
0x003f0101000106b8ULL, 0x000000ff000045e0ULL, 0x003f010100010688ULL, 0x000000ff00004640ULL,
0x003f0105000106bcULL, 0x000000ff00004810ULL, 0x003f0105000106bcULL, 0x000000ff00005060ULL,
0x003f0107000106b0ULL, 0x000000ff00005160ULL, 0x003f0101000106b0ULL, 0x00000007000051c0ULL,
0x003f010100010628ULL, 0x00000007000051e0ULL, 0x003f01050001062cULL, 0x00000007000053b0ULL,
0x003f01050001062cULL, 0x000000ff00005930ULL, 0x003f0105000106acULL, 0x000000ff00005b00ULL,
0x003f0105000106acULL, 0x000000ff00006230ULL, 0x003f0101000106b8ULL, 0x000000ff00006250ULL,
0x003f0105000106bcULL, 0x000000ff00006420ULL, 0x003f0105000106bcULL, 0x000000ff00006c70ULL,
0x003f0107000106a8ULL, 0x000000ff00006cf0ULL, 0x003f0101000106a8ULL, 0x000000ff00006d20ULL,
0x003f0105000106b4ULL, 0x000000ff00006ef0ULL, 0x003f0105000106b4ULL, 0x000000ff00007600ULL,
0x003f0101000106b8ULL, 0x000000ff00007670ULL, 0x003f010100010690ULL, 0x000000ff000076d0ULL,
0x003f0105000106bcULL, 0x000000ff000078a0ULL, 0x003f0105000106bcULL, 0x000000ff000080f0ULL,
0x003f0107000106b0ULL, 0x000000ff000081f0ULL, 0x003f0101000106b0ULL, 0x0000000700008250ULL,
0x003f010100010648ULL, 0x0000000700008270ULL, 0x003f01050001064cULL, 0x0000000700008440ULL,
0x003f01050001064cULL, 0x000000ff00008990ULL, 0x003f0105000106acULL, 0x000000ff00008b60ULL,
0x003f0105000106acULL, 0x000000ff00009290ULL, 0x003f0101000106b8ULL, 0x000000ff000092b0ULL,
0x003f0105000106bcULL, 0x000000ff00009480ULL, 0x003f0105000106bcULL, 0x000000ff00009cd0ULL,
0x003f0107000106a8ULL, 0x000000ff00009d50ULL, 0x003f0101000106a8ULL, 0x000000ff00009d80ULL,
0x003f0105000106b4ULL, 0x000000ff00009f50ULL, 0x003f0105000106b4ULL, 0x000000ff0000a660ULL,
0x003f0101000106b8ULL, 0x000000ff0000a6d0ULL, 0x003f010100010698ULL, 0x000000ff0000a730ULL,
0x003f0105000106bcULL, 0x000000ff0000a900ULL, 0x003f0105000106bcULL, 0x000000ff0000b150ULL,
0x003f0107000106b0ULL, 0x000000ff0000b250ULL, 0x003f0101000106b0ULL, 0x000000070000b2b0ULL,
0x003f010100010668ULL, 0x000000070000b2d0ULL, 0x003f01050001066cULL, 0x000000070000b4a0ULL,
0x003f01050001066cULL, 0x000000ff0000b9f0ULL, 0x003f0105000106acULL, 0x000000ff0000bbc0ULL,
0x003f0105000106acULL, 0x000000ff0000c2f0ULL, 0x003f0101000106b8ULL, 0x000000ff0000c310ULL,
0x003f0105000106bcULL, 0x000000ff0000c4e0ULL, 0x003f0105000106bcULL, 0x000000ff0000cd50ULL,
0x003f0107000106a8ULL, 0x000000ff0000cdd0ULL, 0x003f0101000106a8ULL, 0x000000ff0000ce00ULL,
0x003f0105000106b4ULL, 0x000000ff0000cfd0ULL, 0x003f0105000106b4ULL, 0x000000ff0000d6e0ULL,
0x003f0101000106b8ULL, 0x000000ff0000d740ULL, 0x003f0101000106a0ULL, 0x000000ff0000e420ULL,
0x003f010100010600ULL, 0x000000ff0000f1e0ULL, 0x003f010500010604ULL, 0x000000ff0000f3b0ULL,
0x003f010500010604ULL, 0x000000ff0000f720ULL, 0x003f010100010600ULL, 0x000000ff0000f750ULL,
0x003f010500010604ULL, 0x000000ff0000f910ULL, 0x003f010500010604ULL, 0x0000002b000113a0ULL,
0x003f010100000000ULL, 0x0000002b000114b0ULL, 0x003f010500000004ULL, 0x0000002b00011680ULL,
0x003f010500000004ULL, 0x0000002d00012b20ULL, 0x003f010100000000ULL, 0x0000002d00012b80ULL,
0x003f010100000008ULL, 0x0000002d00012be0ULL, 0x003f010100000010ULL, 0x0000002d00012c50ULL,
0x003f010100000018ULL, 0x00101c0400053803ULL, 0x0000f9700000e300ULL, 0x00012c900000fa40ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003ccULL, 0x0000001a00000002ULL,
0x00000000000002fcULL, 0x0000001a00000002ULL, 0x000000000000021cULL, 0x0000001a00000002ULL,
0x000000000000012cULL, 0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL,
0x00000000000003a7ULL, 0x0000001a00000002ULL, 0x00000000000002d7ULL, 0x0000001a00000002ULL,
0x00000000000001f4ULL, 0x0000001a00000002ULL, 0x0000000000000107ULL, 0x0000001a00000002ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000077919ULL, 0x000e620000002100ULL,
0x00000000000c7806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000004ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000000c000b7300ULL, 0x000ee200000e0000ULL, 0x0000000304057899ULL, 0x000fe4000800063fULL,
0x0000000000027919ULL, 0x000ea20000002200ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x0000000000067919ULL, 0x000f220000002600ULL, 0x0000000c00137309ULL, 0x0002a60000000000ULL,
0x00000000001e7919ULL, 0x000ee80000002700ULL, 0x0000000000057919ULL, 0x000ee20000000000ULL,
0x00000005ff007819ULL, 0x002fc60000011607ULL, 0x00000000000d7919ULL, 0x000e680000000000ULL,
0x00001fff00007589ULL, 0x000fe200000e0000ULL, 0x0000010004027a24ULL, 0x004fc600078e0202ULL,
0x00001fff04047589ULL, 0x000ea200000e0000ULL, 0x0000000002077a24ULL, 0x000fca00078e0207ULL,
0x000000ff0700720cULL, 0x040fe40003f25270ULL, 0x0000000f0700780cULL, 0x000fe20003f44070ULL,
0x00000010050e7824ULL, 0x008fe200078e00ffULL, 0x000000030700780cULL, 0x040fe40003f64070ULL,
0x0000007f0700780cULL, 0x000fe40003f84070ULL, 0x0000000d0b00720cULL, 0x002fe40003f02070ULL,
0x000001f00e117812ULL, 0x000fc600078ec0ffULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x01060002ff009388ULL, 0x0003e20000000a00ULL,
0x00000004040a7824ULL, 0x004fe400078e0200ULL, 0xff317217ff0bc424ULL, 0x000fe200078e00ffULL,
0x010608080700a388ULL, 0x0009e20000008a00ULL, 0x000000020a0a7824ULL, 0x000fe200078e00ffULL,
0x000000010700780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff0c9424ULL, 0x000fe200078e00ffULL,
0x0104000b0700c388ULL, 0x0005e20000004800ULL, 0x000000200a0f7824ULL, 0x000fc400078e00ffULL,
0x3fffff60ff02b424ULL, 0x002fe400078e00ffULL, 0x7fffff60ff03b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0d9424ULL, 0x000fe400078e00ffULL, 0x0000000806087824ULL, 0x010fe200078e00ffULL,
0x010688020700b388ULL, 0x0003e20000008a00ULL, 0x000000010a097824ULL, 0x000fe400078e0205ULL,
0x000000051e087c24ULL, 0x000fc4000f8e0208ULL, 0x7fffff00ff0ba424ULL, 0x004fe200078e00ffULL,
0xffffffe00f0f7812ULL, 0x000fe200078ee209ULL, 0x00000200ff097424ULL, 0x000fc800078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x000000080a027817ULL, 0x002fe20007800000ULL,
0x0000000108037824ULL, 0x000fc800078e020aULL, 0x0000000102027824ULL, 0x000fe200078e0a0aULL,
0x000000010a0a7810ULL, 0x000fc80007ffe0ffULL, 0x000000ff0200720cULL, 0x000fe20003f63070ULL,
0x0000000108087824ULL, 0x000fe200078e020aULL, 0x000000010200780cULL, 0x000fe20003f83070ULL,
0x00005c0003027625ULL, 0x000fc800078e0009ULL, 0x000000010a107824ULL, 0x000fe200078e0205ULL,
0x0000001102027210ULL, 0x000fe20007fbe0ffULL, 0x000000200a127824ULL, 0x000fe400078e00ffULL,
0x00005c0008087625ULL, 0x000fc600078e0009ULL, 0xffffffe012107812ULL, 0x000fe200078ee210ULL,
0x3fffff00ff0aa424ULL, 0x000fe200078e00ffULL, 0x0000001108087210ULL, 0x000fe20007fde0ffULL,
0x000000ffff037224ULL, 0x000fe400028e0603ULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x0106a80a0700a388ULL, 0x000fe20000008a00ULL, 0x000000ffff097224ULL, 0x000fc600030e0609ULL,
0x0106b80cff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020f7faeULL, 0x0003e2000d901c46ULL,
0x000000ffff077224ULL, 0x000fc600078e0a13ULL, 0x0000000008107faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x01060407ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x000062001e027625ULL, 0x000fc600078e001dULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000602027981ULL, 0x004ea2000c1e1900ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x0000003f02037810ULL, 0x044fe40007ffe0ffULL,
0x000000ff020a7810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff037819ULL, 0x000fe40000011603ULL,
0x00000008ff047819ULL, 0x000fca000001160aULL, 0x0000dd3000008947ULL, 0x000fea0003800000ULL,
0x000001ff0a00780cULL, 0x000fe20003f24070ULL, 0x0000000800077824ULL, 0x000fe200078e00ffULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c0807ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106880007ff7f8cULL, 0x0005e2000c80043fULL,
0xffffffffff1c7424ULL, 0x000fe200078e00ffULL, 0x0000005000008947ULL, 0x000fea0003800000ULL,
0x000000021e087824ULL, 0x002fe400078e00ffULL, 0x00006400ff097624ULL, 0x000fc800078e00ffULL,
0x0000640008087624ULL, 0x000fc800078e0209ULL, 0x00006000081c7625ULL, 0x000fcc00078e001dULL,
0x000000061c1c7981ULL, 0x000324000c1e1900ULL, 0x000058001c087a24ULL, 0x012fc800078e02ffULL,
0x0000004008157824ULL, 0x000fe200078e00ffULL, 0x0000043000001947ULL, 0x000fea0003800000ULL,
0x0000000702087217ULL, 0x000fe40007800000ULL, 0x00000004ff097819ULL, 0x000fe40000011605ULL,
0x000000f00e177812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a07ULL,
0x00000002090b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001070a7824ULL, 0x000fe200078e0209ULL,
0x00000004090f7810ULL, 0x040fe40007ffe0ffULL, 0x000000080900720cULL, 0x080fe20003f06070ULL,
0x00000001070c7824ULL, 0x000fe200078e020bULL, 0x0000000609107810ULL, 0x000fe20007ffe0ffULL,
0x0000004006097824ULL, 0x000fe200078e020aULL, 0x000000080b00720cULL, 0x080fe20003f26070ULL,
0x000000010a0b7824ULL, 0x140fe200078e0205ULL, 0x000000080f00720cULL, 0x000fe20003f46070ULL,
0x000000100a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000915187210ULL, 0x000fe20007f7e0ffULL,
0x000000010c0a7824ULL, 0x000fc400078e0205ULL, 0x000000100c127824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0b7812ULL, 0x000fe200078ee20bULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x000000081000720cULL, 0x000fe20003f66070ULL, 0x00000001070f7824ULL, 0x000fe200078e020fULL,
0x0000000209087810ULL, 0x000fe20007ffe0ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0xfffffff0120d7812ULL, 0x000fe400078ee20aULL, 0x00005e00180c7a11ULL, 0x000fe400078840ffULL,
0x00000004090a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000609097810ULL, 0x000fe40007ffe0ffULL,
0x0000000815167210ULL, 0x000fe20007fde0ffULL, 0x000000010f087824ULL, 0x040fe200078e0205ULL,
0x00005f0018187a11ULL, 0x000fe200020f4411ULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000915117210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x0000000a15137210ULL, 0x000fe20007f9e0ffULL, 0x00000001100a7824ULL, 0x000fe200078e0205ULL,
0x00005e0016157a11ULL, 0x000fe200078c40ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0xfffffff00f0f7812ULL, 0x000fe200078ee208ULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x00005f0016167a11ULL, 0x000fe200030f4409ULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x0000000c17087210ULL, 0x000fc40007fde0ffULL, 0x0000c0000b0b7811ULL, 0x000fe400078e20ffULL,
0x00005e0013127a11ULL, 0x000fe200078840ffULL, 0x000000ffff097224ULL, 0x000fe200030e0618ULL,
0x00005e00110c7a11ULL, 0x000fe400078a40ffULL, 0xfffffff010107812ULL, 0x000fe400078ee20aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x00005f0013137a11ULL, 0x000fe400020f4414ULL, 0x00005f0011117a11ULL, 0x000fc400028f440eULL,
0x00000017120a7210ULL, 0x080fe40007f9e0ffULL, 0x000000170c0c7210ULL, 0x080fe40007fbe0ffULL,
0x0000c0000d0e7811ULL, 0x000fe400078e20ffULL, 0x0000c0000f0f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x002fe200020e0613ULL, 0x0000001715087210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e0611ULL, 0x0000c00010107811ULL, 0x000fc600078e20ffULL,
0x000000ffff097224ULL, 0x000fca00000e0616ULL, 0x00000000080e7faeULL, 0x0003e8000c901c46ULL,
0x000000000a0f7faeULL, 0x0003e8000d101c46ULL, 0x000000000c107faeULL, 0x0003e2000d901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000705087211ULL, 0x000fc800078fe0ffULL,
0x00000002080a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108097824ULL, 0x140fe200078e0205ULL,
0x00000006080f7810ULL, 0x040fe20007ffe0ffULL, 0x00000010080c7824ULL, 0x000fe400078e00ffULL,
0x000000010a0b7824ULL, 0x040fe400078e0205ULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c0a7812ULL, 0x000fe200078ee209ULL, 0x0000004006097824ULL, 0x000fe400078e0208ULL,
0x000000100f177824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fc400078ee20bULL,
0x00000004080b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000915167210ULL, 0x000fe40007f1e0ffULL,
0x0000000209087810ULL, 0x000fe20007ffe0ffULL, 0x000000100b137824ULL, 0x000fe200078e00ffULL,
0x00000004090c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000609107810ULL, 0x000fe20007ffe0ffULL,
0x000000010b097824ULL, 0x100fe200078e0205ULL, 0x0000000c15127210ULL, 0x000fe20007f5e0ffULL,
0x000000010f0b7824ULL, 0x000fe200078e0205ULL, 0x0000000815147210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000001015117210ULL, 0x000fc40007f7e0ffULL,
0x00005e0016087a11ULL, 0x000fe200078040ffULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0xfffffff017107812ULL, 0x000fe200078ee20bULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x000000f00e177812ULL, 0x000fe400078ec0ffULL, 0xfffffff0130f7812ULL, 0x000fe200078ee209ULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x00005f0016167a11ULL, 0x000fe400000f440cULL,
0x00005e00120c7a11ULL, 0x000fc400078440ffULL, 0x00005e00110e7a11ULL, 0x000fe400078640ffULL,
0x0000000817087210ULL, 0x000fe40007f1e0ffULL, 0x00005e0014137a11ULL, 0x000fe400078240ffULL,
0x00005f0012127a11ULL, 0x000fe400010f440bULL, 0x00005f0011117a11ULL, 0x000fe200018f4409ULL,
0x000000ffff097224ULL, 0x000fe200000e0616ULL, 0x0000c0000a0b7811ULL, 0x000fc400078e20ffULL,
0x00005f0014147a11ULL, 0x000fe400008f4415ULL, 0x00000013170a7210ULL, 0x040fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000b901c46ULL,
0x0000000c170c7210ULL, 0x040fe40007f3e0ffULL, 0x0000000e170e7210ULL, 0x000fe40007f5e0ffULL,
0x0000c00010107811ULL, 0x000fe400078e20ffULL, 0x0000c0000d087811ULL, 0x002fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0614ULL, 0x0000c0000f097811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fc400008e0612ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0611ULL,
0x000000000a087faeULL, 0x0003e8000b901c46ULL, 0x000000000c097faeULL, 0x0003e8000b901c46ULL,
0x000000000e107faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe20003f05270ULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff207f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff227f8cULL, 0x000ee2000c80043fULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000c69000008947ULL, 0x000fea0003800000ULL,
0x000000021e1e7824ULL, 0x000fe400078e00ffULL, 0x00006400ff0b7624ULL, 0x000fc400078e00ffULL,
0x000000ffff477224ULL, 0x002fe400078e0021ULL, 0x000064001e1e7624ULL, 0x000fe400078e020bULL,
0x000000ffff4a7224ULL, 0x008fe400078e0023ULL, 0xff317217ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff487224ULL, 0x000fc400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fc400078e00ffULL, 0x000001001f207824ULL, 0x000fca00078e00ffULL,
0x000000022000720cULL, 0x000fda0003f06070ULL, 0x0000c59000000947ULL, 0x004fea0003800000ULL,
0x000000ffff207224ULL, 0x000fc400078e0048ULL, 0x0000000000227805ULL, 0x000fca0000015200ULL,
0x0106bc00ff217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002822277210ULL, 0x000fca0007f1e1ffULL,
0x0000000129287824ULL, 0x000fe200000e0e23ULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc80000011428ULL,
0x0000002721217211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0628ULL,
0x0000000221217819ULL, 0x000fc80000001227ULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000011f217810ULL, 0x000fe20007ffe0ffULL, 0x000058001c1c7a24ULL, 0x000fc600078e02ffULL,
0x000000042100720cULL, 0x000fe20003f26070ULL, 0x000000401c297824ULL, 0x000fd800078e00ffULL,
0x0000048000009947ULL, 0x000fea0003800000ULL, 0x00000004ff2a7819ULL, 0x100fe40000011605ULL,
0x000000201f1c7811ULL, 0x000fe400078e40ffULL, 0x000000022a3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107227824ULL, 0x000fe200078e022aULL, 0x0000001c02217217ULL, 0x000fe40007800000ULL,
0x000000042a407810ULL, 0x000fe20007ffe0ffULL, 0x0000000122237824ULL, 0x000fe200078e0205ULL,
0x000000062a427810ULL, 0x000fe20007ffe0ffULL, 0x00000010223d7824ULL, 0x000fc400078e00ffULL,
0x0000000107277824ULL, 0x000fe400078e023eULL, 0x0000000121217824ULL, 0x000fe200078e0a1cULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee223ULL, 0x0000000127237824ULL, 0x040fe200078e0205ULL,
0x00000020061c7811ULL, 0x000fe200078e30ffULL, 0x00000010273f7824ULL, 0x000fe200078e00ffULL,
0x0000002107217217ULL, 0x040fe20007800000ULL, 0x00000001072d7824ULL, 0x040fe400078e0240ULL,
0x00000001072e7824ULL, 0x000fe200078e0242ULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee223ULL,
0x0000000127237824ULL, 0x000fc400078e021cULL, 0x000000012d277824ULL, 0x100fe400078e021cULL,
0x0000000122227824ULL, 0x100fe200078e021cULL, 0x0000002329237210ULL, 0x000fe20007f5e0ffULL,
0x000000102d417824ULL, 0x000fe200078e00ffULL, 0x00000027292c7210ULL, 0x000fe20007fbe0ffULL,
0x000000012d277824ULL, 0x000fe200078e0205ULL, 0x0000002229287210ULL, 0x000fe20007f1e0ffULL,
0x000000012e1c7824ULL, 0x040fe200078e021cULL, 0x00005e00232d7a11ULL, 0x000fe200078840ffULL,
0x000000102e437824ULL, 0x040fe200078e00ffULL, 0xfffffff041417812ULL, 0x000fe200078ee227ULL,
0x0000001005277824ULL, 0x000fe200078e00ffULL, 0x0000001c292b7210ULL, 0x000fe20007fde0ffULL,
0x000000012e297824ULL, 0x000fc400078e0205ULL, 0x0000000121217824ULL, 0x000fe200078e0a07ULL,
0x000000f0272f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0xfffffff043437812ULL, 0x000fe200078ee229ULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005e0028227a11ULL, 0x000fe200078040ffULL, 0x000000ffff277224ULL, 0x000fe200030e06ffULL,
0x000000212a00720cULL, 0x000fe40003f66070ULL, 0x00005f00232e7a11ULL, 0x000fe400020f442eULL,
0x00005f00281c7a11ULL, 0x000fe200000f441cULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x0000002f22227210ULL, 0x000fc40007f9e0ffULL, 0x00005e002c297a11ULL, 0x000fe400078a40ffULL,
0x000000213e00720cULL, 0x000fe20003f46070ULL, 0x000000ffff237224ULL, 0x000fe200020e061cULL,
0x0000e0003d1c7811ULL, 0x000fe400078e20ffULL, 0x00005f002c2c7a11ULL, 0x000fe400028f4428ULL,
0x0000002f2d287210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000221c7faeULL, 0x0003e2000d901c46ULL, 0x000000214000720cULL, 0x000fc40003f06070ULL,
0x00005e002b2a7a11ULL, 0x040fe400078c40ffULL, 0x000000214200720cULL, 0x000fe40003f86070ULL,
0x00005f002b2b7a11ULL, 0x000fe400030f4427ULL, 0x0000e00041217811ULL, 0x000fe400078e20ffULL,
0x0000e00043277811ULL, 0x000fe400078e20ffULL, 0x0000002f29227210ULL, 0x082fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fe200028e062eULL, 0x0000002f2a2a7210ULL, 0x000fc40007fbe0ffULL,
0x0000e0003f1c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff237224ULL, 0x000fe400018e062cULL,
0x000000ffff2b7224ULL, 0x000fe400028e062bULL, 0x00000000281c7faeULL, 0x0003e8000d101c46ULL,
0x0000000022217faeULL, 0x0003e8000c101c46ULL, 0x000000002a277faeULL, 0x0003e2000e101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x00000007051c7211ULL, 0x000fe400078fe0ffULL,
0x0000002006237811ULL, 0x000fc400078e30ffULL, 0x000000021c227810ULL, 0x040fe20007ffe0ffULL,
0x000000011c217824ULL, 0x140fe200078e0205ULL, 0x000000061c2a7810ULL, 0x040fe20007ffe0ffULL,
0x000000101c2f7824ULL, 0x000fe400078e00ffULL, 0x0000000122277824ULL, 0x040fe400078e0205ULL,
0x00000010223d7824ULL, 0x040fe200078e00ffULL, 0xfffffff02f2f7812ULL, 0x000fe200078ee221ULL,
0x0000000122217824ULL, 0x000fe400078e0223ULL, 0x000000102a3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff03d3d7812ULL, 0x000fc400078ee227ULL, 0x000000041c277810ULL, 0x040fe20007ffe0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e0223ULL, 0x0000002129217210ULL, 0x000fc60007f5e0ffULL,
0x0000000127227824ULL, 0x100fe200078e0223ULL, 0x0000001c291c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012a237824ULL, 0x000fe400078e0223ULL, 0x0000000127287824ULL, 0x100fe200078e0205ULL,
0x00000022292b7210ULL, 0x000fe20007f7e0ffULL, 0x00000010273e7824ULL, 0x000fe200078e00ffULL,
0x0000002329237210ULL, 0x000fe20007f9e0ffULL, 0x0000001005277824ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e001c227a11ULL, 0x000fe200078040ffULL,
0x000000012a297824ULL, 0x000fe200078e0205ULL, 0x000000f0272e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff277224ULL, 0x000fe200020e06ffULL, 0x00005f001c2d7a11ULL, 0x000fe200000f442dULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee229ULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x000fc400078640ffULL,
0x00005e00232c7a11ULL, 0x000fe400078840ffULL, 0x0000002e22227210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03e3e7812ULL, 0x000fe400078ee228ULL, 0x00005e0021287a11ULL, 0x000fe400078440ffULL,
0x00005f002b2b7a11ULL, 0x000fe400018f441cULL, 0x00005f0023277a11ULL, 0x000fe200020f4427ULL,
0x000000ffff237224ULL, 0x000fe200000e062dULL, 0x0000e0002f1c7811ULL, 0x000fc400078e20ffULL,
0x00005f0021217a11ULL, 0x000fe400010f4429ULL, 0x0000002e28287210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221c7faeULL, 0x0003e2000b901c46ULL,
0x0000002e2a2a7210ULL, 0x080fe40007f5e0ffULL, 0x0000002e2c2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fe200000e0621ULL, 0x0000e0003e217811ULL, 0x000fe200078e20ffULL,
0x000000ffff2b7224ULL, 0x000fe400010e062bULL, 0x000000ffff2d7224ULL, 0x000fe200018e0627ULL,
0x0000e0003d1c7811ULL, 0x002fc400078e20ffULL, 0x0000e0003f227811ULL, 0x000fc600078e20ffULL,
0x00000000281c7faeULL, 0x0003e8000b901c46ULL, 0x000000002a217faeULL, 0x0003e8000b901c46ULL,
0x000000002c227faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000148227810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe60003800000ULL,
0x000000032200720cULL, 0x000fe20003f06070ULL, 0xffffffffff1c7424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000011e227824ULL, 0x000fe400078e0222ULL,
0x00000004ff237424ULL, 0x000fc800078e00ffULL, 0x0000600022227625ULL, 0x000fca00078e0023ULL,
0x00000006221c7981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff427f8cULL, 0x000ee2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060800072a7f8cULL, 0x0002a4000c80043fULL,
0x0000000000227805ULL, 0x002fc40000015200ULL, 0x01060c0007217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x006fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002822277210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e23ULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc80000011428ULL, 0x0000002721217211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0628ULL, 0x0000000221217819ULL, 0x000fc80000001227ULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060c0007217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001005217824ULL, 0x000fe200078e00ffULL,
0x00000001ff227819ULL, 0x000fe20000011605ULL, 0xffffffffff297424ULL, 0x000fc600078e00ffULL,
0x0000000c22227812ULL, 0x000fe400078ec0ffULL, 0x0000007021287812ULL, 0x000fca00078ec0ffULL,
0x0000000128287824ULL, 0x000fca00078e0222ULL, 0x0100000028277984ULL, 0x000e680000000800ULL,
0x01020000282a7984ULL, 0x0004e20000000800ULL, 0x0000003c2700720bULL, 0x002fe20003f1d000ULL,
0x00010bb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000227806ULL, 0x004fc800000e0100ULL,
0x0000ffff222d7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff497224ULL, 0x000fc400078e003cULL,
0x0000001fff227424ULL, 0x000fe400078e00ffULL, 0xffffffffff237424ULL, 0x000fca00078e00ffULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fe40003f05270ULL,
0x0000003c2700720bULL, 0x000fe20003f54000ULL, 0x00010b527f007947ULL, 0x000fd8000b800000ULL,
0x00000000002b7806ULL, 0x000fc400010e0100ULL, 0x000000273c497209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000099102b2c7816ULL, 0x000fc600000000ffULL,
0x0104004928008388ULL, 0x0003e20000000800ULL, 0x000000ff2c00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000493c2c7221ULL, 0x002fe20000010000ULL,
0x000000ff2bff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b2c2c7820ULL, 0x000fcc0000410000ULL, 0x0000002c002c7308ULL, 0x000e680000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3f7819ULL, 0x000fe20000011605ULL,
0x00010ab27f007947ULL, 0x000fea000b800000ULL, 0x00001f3f2c3f7589ULL, 0x0022a400000e0000ULL,
0x0000003f34347220ULL, 0x084fe20000410000ULL, 0x0000003f35357220ULL, 0x080fe20000410000ULL,
0x0000003f38387220ULL, 0x080fe20000410000ULL, 0x0000003f39397220ULL, 0x080fe20000410000ULL,
0x0000003f30307220ULL, 0x080fe20000410000ULL, 0x0000003f31317220ULL, 0x080fe20000410000ULL,
0x0000003f18187220ULL, 0x080fe20000410000ULL, 0x0000003f19197220ULL, 0x080fe20000410000ULL,
0x0000003f14147220ULL, 0x080fe20000410000ULL, 0x0000003f15157220ULL, 0x080fe20000410000ULL,
0x0000003f10107220ULL, 0x080fe20000410000ULL, 0x0000003f11117220ULL, 0x080fe20000410000ULL,
0x0000003f0c0c7220ULL, 0x080fe20000410000ULL, 0x0000003f0d0d7220ULL, 0x080fe20000410000ULL,
0x0000003f08087220ULL, 0x080fe20000410000ULL, 0x0000003f09097220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff002bff7812ULL, 0x000fe2000780c0ffULL,
0x0000002c1d1d7220ULL, 0x002fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008053f7811ULL, 0x000fe200078ff0ffULL, 0x000109927f007947ULL, 0x000fea000b800000ULL,
0x00001f3f2c3f7589ULL, 0x0002a400000e0000ULL, 0x0000003f36367220ULL, 0x084fe20000410000ULL,
0x0000003f37377220ULL, 0x080fe20000410000ULL, 0x0000003f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003f32327220ULL, 0x080fe20000410000ULL,
0x0000003f33337220ULL, 0x080fe20000410000ULL, 0x0000003f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003f1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003f16167220ULL, 0x080fe20000410000ULL,
0x0000003f17177220ULL, 0x080fe20000410000ULL, 0x0000003f12127220ULL, 0x080fe20000410000ULL,
0x0000003f13137220ULL, 0x080fe20000410000ULL, 0x0000003f0e0e7220ULL, 0x080fe20000410000ULL,
0x0000003f0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003f0a0a7220ULL, 0x080fe20000410000ULL,
0x0000003f0b0b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2dff7812ULL, 0x000fda000780602bULL, 0x8000004927270221ULL, 0x000fe20000010000ULL,
0x00007610ff2e0816ULL, 0x000fc6000000002eULL, 0x3fb8aa3b27270820ULL, 0x000fc80000410000ULL,
0x0000002700240308ULL, 0x000e640000000800ULL, 0x000000242a2a0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001d2a1d7221ULL, 0x008fc40000010000ULL,
0x00000000002a7805ULL, 0x000fca0000015200ULL, 0x0106ac00ff277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2c7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff277819ULL, 0x000fc8000001142dULL, 0x0000002c27277211ULL, 0x000fca00078110ffULL,
0x000000ffff2c7224ULL, 0x000fca00000e062dULL, 0x0000000227277819ULL, 0x000fc8000000122cULL,
0x000000270000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012f2f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099102e277816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2700720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000024ff25723eULL, 0x000fe400000000ffULL,
0x00000002ff2a7819ULL, 0x000fe40000011605ULL, 0x0000541025277816ULL, 0x000fe20000000025ULL,
0x000105927f007947ULL, 0x000fea000b800000ULL, 0x00001f2a27257589ULL, 0x0002a400000e0000ULL,
0x000000082a267810ULL, 0x000fe20007ffe0ffULL, 0x000105c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000102a3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0027ULL,
0x000028e0003e7802ULL, 0x000fc40000000f00ULL, 0x000113f000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000182a3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e0027ULL, 0x00002930003e7802ULL, 0x000fc40000000f00ULL,
0x000113a000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008055c7812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff277819ULL, 0x00afc40000011605ULL, 0x00000007054a7812ULL, 0x000fe400078ec0ffULL,
0x000000075c5c7812ULL, 0x000fe200078ef805ULL, 0x0000000400417824ULL, 0x000fe200078e0227ULL,
0x000000084a4a7812ULL, 0x000fe400078ef805ULL, 0x00000002002f7811ULL, 0x000fe200078e10ffULL,
0x000000015c2a7824ULL, 0x040fe200078e0241ULL, 0x000000105c567812ULL, 0x040fe200078efcffULL,
0x000000105c2b7824ULL, 0x000fe400078e00ffULL, 0x00000001274b7824ULL, 0x000fe200078e024aULL,
0x0000002f565f7210ULL, 0x000fe20007ffe027ULL, 0x000000084a2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff02b2b7812ULL, 0x000fe200078ee22aULL, 0x00000001275d7824ULL, 0x000fc400078e022fULL,
0x000000105c2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2a7812ULL, 0x000fe200078ee24bULL,
0x000000015c2c7824ULL, 0x000fe200078e025dULL, 0x0000c0002b2b7811ULL, 0x000fe200078e20ffULL,
0x00000001415e7824ULL, 0x000fe200078e0256ULL, 0x0000a0002a3c7811ULL, 0x000fe200078e20ffULL,
0x000000084a2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff02d2c7812ULL, 0x000fe200078ee22cULL,
0x000000002b50783bULL, 0x000e620000004200ULL, 0x000000024b2d7810ULL, 0x000fe40007ffe0ffULL,
0x0000c0002c2c7811ULL, 0x000fe200078e20ffULL, 0x000000003c3c783bULL, 0x000ee20000000200ULL,
0xfffffff82e2d7812ULL, 0x000fc600078ee22dULL, 0x000000002c4c783bULL, 0x004ea20000004200ULL,
0x0000312050507816ULL, 0x002fe400000000ffULL, 0x0000312051517816ULL, 0x000fe200000000ffULL,
0x000000253c3ca232ULL, 0x088fe20000000000ULL, 0x00000050ff44723eULL, 0x000fe200020006ffULL,
0x000000253e3ea232ULL, 0x000fe20000000000ULL, 0x00000051ff45723eULL, 0x000fe200020006ffULL,
0x000000263d3da232ULL, 0x080fe20000000000ULL, 0x0000312052527816ULL, 0x000fe200000000ffULL,
0x000000263f3fa232ULL, 0x000fe20000000000ULL, 0x0000312053537816ULL, 0x000fc400000000ffULL,
0x00000052ff54723eULL, 0x000fe400030006ffULL, 0x00000053ff55723eULL, 0x080fe400030006ffULL,
0x000000443c44723cULL, 0x040be20000001834ULL, 0x000031204c4c7816ULL, 0x004fe400000000ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x00000050ff50723eULL, 0x000fe400030006ffULL,
0x0000001056367824ULL, 0x060fe200078e00ffULL, 0x00000052ff34723eULL, 0x000fe200020006ffULL,
0x000000543c18723cULL, 0x000b620000001818ULL, 0x00000053ff35723eULL, 0x000fe200020006ffULL,
0x0000001056567824ULL, 0x000fe200078e00ffULL, 0xfffffff0365e7812ULL, 0x000fc400078ee25eULL,
0x00000051ff51723eULL, 0x000fe400030006ffULL, 0x0000004cff54723eULL, 0x020fe200020006ffULL,
0x000000343c30723cULL, 0x040b620000001830ULL, 0x0000004dff55723eULL, 0x000fe400020006ffULL,
0x0000c0005e2e7811ULL, 0x000fe400078e20ffULL, 0x000031204e407816ULL, 0x000fe400000000ffULL,
0x000031204f587816ULL, 0x000fe200000000ffULL, 0x000000503c38723cULL, 0x000b640000001838ULL,
0x0000a0002d347811ULL, 0x020fe200078e20ffULL, 0x000000002e50783bULL, 0x000e620000004200ULL,
0xfffffff0565f7812ULL, 0x000fc400078ee25fULL, 0x0000004cff4c723eULL, 0x000fe400030006ffULL,
0x0000c0005f2f7811ULL, 0x000fe200078e20ffULL, 0x000000543c14723cULL, 0x000b620000001814ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x0000004dff4d723eULL, 0x000fca00030006ffULL,
0x00000040ff54723eULL, 0x020fe400020006ffULL, 0x00000058ff55723eULL, 0x080fe200020006ffULL,
0x0000004c3c4c723cULL, 0x040ff00000001810ULL, 0x000000543c54723cULL, 0x000b6e000000180cULL,
0x00000058ff0d723eULL, 0x020fc400030006ffULL, 0x000000002f58783bULL, 0x000ee20000004200ULL,
0x00000040ff0c723eULL, 0x000fe400030006ffULL, 0x0000312053117816ULL, 0x002fca00000000ffULL,
0x0000000c3c3c723cULL, 0x000b620000001808ULL, 0x0000312052527816ULL, 0x000fe400000000ffULL,
0x0000312050507816ULL, 0x000fe400000000ffULL, 0x00000052ff10723eULL, 0x080fe200030006ffULL,
0x000000253434a232ULL, 0x084fe20000000000ULL, 0x00000011ff09723eULL, 0x0a0fe200020006ffULL,
0x000000253636a232ULL, 0x000fe20000000000ULL, 0x00000011ff11723eULL, 0x000fe200030006ffULL,
0x000000263535a232ULL, 0x080fe20000000000ULL, 0x00000052ff08723eULL, 0x000fe200020006ffULL,
0x000000263737a232ULL, 0x000fe20000000000ULL, 0x0000312051517816ULL, 0x000fc400000000ffULL,
0x00000050ff0c723eULL, 0x080fe400020006ffULL, 0x00000051ff0d723eULL, 0x080fe400020006ffULL,
0x000000103410723cULL, 0x000b620000001818ULL, 0x00000050ff50723eULL, 0x000fe400030006ffULL,
0x00000051ff51723eULL, 0x000fca00030006ffULL, 0x000000083408723cULL, 0x000b620000001830ULL,
0x0000312058587816ULL, 0x008fe400000000ffULL, 0x0000312059597816ULL, 0x000fca00000000ffULL,
0x0000000c340c723cULL, 0x040f640000001844ULL, 0x00000058ff18723eULL, 0x020fe400020006ffULL,
0x00000059ff19723eULL, 0x000fe400020006ffULL, 0x000031205a5a7816ULL, 0x000fe400000000ffULL,
0x000031205b5b7816ULL, 0x000fe200000000ffULL, 0x000000503438723cULL, 0x000f620000001838ULL,
0x0000005aff30723eULL, 0x000fc400020006ffULL, 0x0000005bff31723eULL, 0x080fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400030006ffULL, 0x0000005bff5b723eULL, 0x000fe200030006ffULL,
0x000000183414723cULL, 0x040b6e0000001814ULL, 0x00000058ff18723eULL, 0x020fe200030006ffULL,
0x000000303430723cULL, 0x000b620000001854ULL, 0x00000059ff19723eULL, 0x000fce00030006ffULL,
0x000000183418723cULL, 0x040b70000000184cULL, 0x0000005a3434723cULL, 0x000b62000000183cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x000e64000c80043fULL, 0x00000000003c7805ULL, 0x020fc40000015200ULL,
0x0106bc00ff3e7984ULL, 0x000ea40000000800ULL, 0x800000003eff7812ULL, 0x006fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c407210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004000780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404000780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000403e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000058001c607a24ULL, 0x010fe200078e02ffULL, 0x000000401f407811ULL, 0x000fc600078e40ffULL,
0x0000004060607824ULL, 0x000fe200078e00ffULL, 0x0000044000009947ULL, 0x000fea0003800000ULL,
0x00000040023c7217ULL, 0x000fe20007800000ULL, 0x00000001073d7824ULL, 0x000fe200078e0227ULL,
0x0000000227447810ULL, 0x040fe40007ffe0ffULL, 0x0000000427517810ULL, 0x000fe20007ffe0ffULL,
0x000000013d3e7824ULL, 0x000fe200078e0205ULL, 0x000000f0214e7812ULL, 0x000fe200078ec0ffULL,
0x000000103d4f7824ULL, 0x000fe400078e00ffULL, 0x000000013c3c7824ULL, 0x000fc400078e0a40ULL,
0x00000040064d7824ULL, 0x000fe200078e023dULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee23eULL,
0x00000001073f7824ULL, 0x040fe200078e0244ULL, 0x0000003c073c7217ULL, 0x040fe20007800000ULL,
0x00000001073d7824ULL, 0x000fe200078e0251ULL, 0x000000604d457210ULL, 0x080fe20007f1e0ffULL,
0x000000013f3e7824ULL, 0x100fe200078e0205ULL, 0x000000024d4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000103f507824ULL, 0x000fe200078e00ffULL, 0x000000044d477810ULL, 0x000fe20007ffe0ffULL,
0x000000013d467824ULL, 0x040fe200078e0205ULL, 0x000000604c4c7210ULL, 0x080fe20007f7e0ffULL,
0x000000103d527824ULL, 0x000fe200078e00ffULL, 0xfffffff050507812ULL, 0x000fe200078ee23eULL,
0x000000013c3f7824ULL, 0x000fe200078e0a07ULL, 0x0000006047477210ULL, 0x000fe20007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e06ffULL, 0x00005e00453e7a11ULL, 0x000fc400078040ffULL,
0x0000003f2700720cULL, 0x000fe40003f86070ULL, 0x00005f0045457a11ULL, 0x000fe200000f443dULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0xfffffff052527812ULL, 0x000fe400078ee246ULL,
0x00005e004c467a11ULL, 0x000fe400078a40ffULL, 0x0000004e3e3c7210ULL, 0x000fe40007f7e0ffULL,
0x00005f004c4c7a11ULL, 0x000fc400028f443dULL, 0x0000003f4400720cULL, 0x080fe20003f06070ULL,
0x000000ffff3d7224ULL, 0x000fe200018e0645ULL, 0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff447224ULL, 0x000fe200030e06ffULL, 0x0000003f5100720cULL, 0x000fe40003f66070ULL,
0x00005e00473e7a11ULL, 0x000fe200078a40ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c4f7faeULL, 0x0003e2000e101c46ULL, 0x0000000627517810ULL, 0x000fe40007ffe0ffULL,
0x000000064d457810ULL, 0x000fc40007ffe0ffULL, 0x00005f0047477a11ULL, 0x000fe200028f4444ULL,
0x0000000107447824ULL, 0x000fe200078e0251ULL, 0x0000006045457210ULL, 0x000fe40007f9e0ffULL,
0x0000004e3e3e7210ULL, 0x080fe20007fde0ffULL, 0x00000001444d7824ULL, 0x000fe200078e0205ULL,
0x0000c00050507811ULL, 0x000fe200078e20ffULL, 0x00000010444f7824ULL, 0x002fe200078e00ffULL,
0x0000004e463c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x00005e0045447a11ULL, 0x000fc400078840ffULL, 0xfffffff04f4d7812ULL, 0x000fe200078ee24dULL,
0x000000ffff3d7224ULL, 0x000fe200028e064cULL, 0x0000003f5100720cULL, 0x000fe20003fa6070ULL,
0x000000ffff3f7224ULL, 0x000fe200030e0647ULL, 0x00005f0045457a11ULL, 0x000fe400020f4446ULL,
0x0000004e44447210ULL, 0x000fe20007f9e0ffULL, 0x000000003c507faeULL, 0x0003e2000c101c46ULL,
0x0000c00052527811ULL, 0x000fe400078e20ffULL, 0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fc400020e0645ULL, 0x000000003e527faeULL, 0x0003e8000d901c46ULL,
0x00000000444d7faeULL, 0x0003e2000e901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x00000001073e7824ULL, 0x000fc800078e0227ULL, 0x000000013e3f7824ULL, 0x140fe200078e0205ULL,
0x000000023e3c7810ULL, 0x040fe20007ffe0ffULL, 0x000000103e4d7824ULL, 0x000fe400078e00ffULL,
0x0000004006447824ULL, 0x000fe400078e023eULL, 0x000000013c3d7824ULL, 0x040fe200078e0205ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee23fULL, 0x000000103c457824ULL, 0x000fe200078e00ffULL,
0x000000043e3c7810ULL, 0x040fe40007ffe0ffULL, 0x000000063e3e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff0453f7812ULL, 0x000fe200078ee23dULL, 0x000000013c3d7824ULL, 0x100fe200078e0205ULL,
0x0000006044467210ULL, 0x000fe20007f1e0ffULL, 0x000000103c457824ULL, 0x000fe200078e00ffULL,
0x00000004444e7810ULL, 0x000fe20007ffe0ffULL, 0x000000013e3c7824ULL, 0x040fe200078e0205ULL,
0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL, 0x000000103e4c7824ULL, 0x000fe200078e00ffULL,
0xfffffff045457812ULL, 0x000fe200078ee23dULL, 0x000000ffff3e7224ULL, 0x000fe200000e06ffULL,
0x00005e0046477a11ULL, 0x000fc400078040ffULL, 0xfffffff04c4c7812ULL, 0x000fe400078ee23cULL,
0x00000002443c7810ULL, 0x000fe40007ffe0ffULL, 0x00005f00463e7a11ULL, 0x000fe400000f443eULL,
0x0000000644447810ULL, 0x000fe40007ffe0ffULL, 0x000000603c3d7210ULL, 0x080fe40007f1e0ffULL,
0x000000604e4f7210ULL, 0x000fc40007f7e0ffULL, 0x000000f021467812ULL, 0x000fe400078ec0ffULL,
0x0000006044527210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff447224ULL, 0x000fe200000e06ffULL,
0x00005e003d4e7a11ULL, 0x000fe200078040ffULL, 0x000000ffff507224ULL, 0x000fe200018e06ffULL,
0x00000046473c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff537224ULL, 0x000fe200028e06ffULL,
0x00005e004f517a11ULL, 0x000fe400078840ffULL, 0x00005f003d477a11ULL, 0x000fe200000f4444ULL,
0x000000ffff3d7224ULL, 0x000fe200018e063eULL, 0x00005e0052547a11ULL, 0x000fc400078a40ffULL,
0x000000464e3e7210ULL, 0x080fe40007f1e0ffULL, 0x00005f004f507a11ULL, 0x000fe200020f4450ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4d7faeULL, 0x0003e2000b901c46ULL,
0x0000004651447210ULL, 0x080fe40007f7e0ffULL, 0x00005f0052537a11ULL, 0x000fe400028f4453ULL,
0x0000004654467210ULL, 0x000fe40007f9e0ffULL, 0x0000c0004c4c7811ULL, 0x000fc400078e20ffULL,
0x0000c0003f3c7811ULL, 0x002fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e0647ULL,
0x0000c000453d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe400018e0650ULL,
0x000000ffff477224ULL, 0x000fe200020e0653ULL, 0x000000003e3c7faeULL, 0x0003e8000b901c46ULL,
0x00000000443d7faeULL, 0x0003e8000b901c46ULL, 0x00000000464c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff3c7f8cULL, 0x000e64000c80043fULL, 0x000000ffff477224ULL, 0x002fc400078e003dULL,
0x00000000003c7805ULL, 0x000fca0000015200ULL, 0x0106b400ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fc40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c447210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000443e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000145457810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000024ff25723eULL, 0x000fe400000000ffULL,
0x00000002ff3d7819ULL, 0x000fe40000011605ULL, 0x00005410253c7816ULL, 0x000fe20000000025ULL,
0x0000f0927f007947ULL, 0x000fea000b800000ULL, 0x00001f3d3c257589ULL, 0x0002a400000e0000ULL,
0x000000083d267810ULL, 0x000fe20007ffe0ffULL, 0x0000f0c27f007947ULL, 0x000fea000b800000ULL,
0x00001f263c267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000103d3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e003cULL,
0x00003ea0003e7802ULL, 0x000fc40000000f00ULL, 0x0000fe3000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000183d3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e003cULL, 0x00003ef0003e7802ULL, 0x000fc40000000f00ULL,
0x0000fde000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000015c3c7824ULL, 0x04afe200078e0241ULL, 0x000000044b417810ULL, 0x000fe20007ffe0ffULL,
0x000000105c3e7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000084a3d7824ULL, 0x000fc400078e00ffULL, 0x000000015c5d7824ULL, 0x000fe200078e025dULL,
0xfffffff03e3c7812ULL, 0x000fe200078ee23cULL, 0x000000105c437824ULL, 0x000fe200078e00ffULL,
0xfffffff83d417812ULL, 0x000fe200078ee241ULL, 0x000000084a4a7824ULL, 0x000fe200078e00ffULL,
0x0000e0003c427811ULL, 0x000fe400078e20ffULL, 0x0000a000413c7811ULL, 0x000fe400078e20ffULL,
0xfffffff043437812ULL, 0x000fe200078ee25dULL, 0x000000004250783bULL, 0x000e660000004200ULL,
0x0000e00043437811ULL, 0x000fe200078e20ffULL, 0x000000003c3c783bULL, 0x000ee80000000200ULL,
0x00000000434c783bULL, 0x004ea20000004200ULL, 0x0000312050507816ULL, 0x002fc400000000ffULL,
0x0000312051517816ULL, 0x000fe400000000ffULL, 0x00000050ff44723eULL, 0x080fe200020006ffULL,
0x000000253c3ca232ULL, 0x088fe20000000000ULL, 0x00000051ff45723eULL, 0x080fe200020006ffULL,
0x000000253e3ea232ULL, 0x000fe20000000000ULL, 0x00000050ff50723eULL, 0x000fe200030006ffULL,
0x000000263d3da232ULL, 0x080fe20000000000ULL, 0x00000051ff51723eULL, 0x000fe200030006ffULL,
0x000000263f3fa232ULL, 0x000fe20000000000ULL, 0x0000312052467816ULL, 0x000fc400000000ffULL,
0x0000312053547816ULL, 0x000fe400000000ffULL, 0x000031204c4c7816ULL, 0x004fe400000000ffULL,
0x000000503c38723cULL, 0x000be20000001838ULL, 0x000031204d4d7816ULL, 0x000fcc00000000ffULL,
0x00000046ff50723eULL, 0x020fe200020006ffULL, 0x000000443c0c723cULL, 0x000b62000000180cULL,
0x00000054ff51723eULL, 0x000fcc00020006ffULL, 0x000000064b447810ULL, 0x020fe20007ffe0ffULL,
0x000000503c50723cULL, 0x000be20000001808ULL, 0x0000e0005e457811ULL, 0x000fe400078e20ffULL,
0xfffffff84a447812ULL, 0x000fe400078ee244ULL, 0x0000004cff4a723eULL, 0x000fe400020006ffULL,
0x00000046ff08723eULL, 0x020fe400030006ffULL, 0x00000054ff09723eULL, 0x000fc400030006ffULL,
0x0000a000440a7811ULL, 0x000fe200078e20ffULL, 0x000000004554783bULL, 0x000e620000004200ULL,
0x0000e0005f467811ULL, 0x000fe400078e20ffULL, 0x0000004dff4b723eULL, 0x080fe200020006ffULL,
0x000000083c10723cULL, 0x000b620000001810ULL, 0x0000004cff4c723eULL, 0x000fe200030006ffULL,
0x000000000a08783bULL, 0x020ea20000000200ULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x00000000465c783bULL, 0x000ee40000004200ULL, 0x0000004a3c14723cULL, 0x000b6e0000001814ULL,
0x000031204e4a7816ULL, 0x020fe400000000ffULL, 0x000031204f4b7816ULL, 0x000fc400000000ffULL,
0x0000004aff58723eULL, 0x080fe200020006ffULL, 0x0000004c3c4c723cULL, 0x000b620000001818ULL,
0x0000004bff59723eULL, 0x080fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400030006ffULL,
0x0000004bff4b723eULL, 0x000fc600030006ffULL, 0x000000583c58723cULL, 0x000f620000001830ULL,
0x0000312054547816ULL, 0x002fce00000000ffULL, 0x0000004a3c3c723cULL, 0x000b620000001834ULL,
0x0000312055557816ULL, 0x000fe400000000ffULL, 0x0000312057197816ULL, 0x020fe200000000ffULL,
0x000000250808a232ULL, 0x084fe20000000000ULL, 0x0000312056567816ULL, 0x000fe200000000ffULL,
0x000000250a0aa232ULL, 0x000fe20000000000ULL, 0x00000054ff34723eULL, 0x000fe200020006ffULL,
0x000000260909a232ULL, 0x080fe20000000000ULL, 0x00000055ff35723eULL, 0x000fe200020006ffULL,
0x000000260b0ba232ULL, 0x000fe20000000000ULL, 0x000031205c5c7816ULL, 0x008fc400000000ffULL,
0x000031205d5d7816ULL, 0x000fe400000000ffULL, 0x00000019ff31723eULL, 0x080fe400020006ffULL,
0x000000340834723cULL, 0x000b62000000180cULL, 0x00000056ff18723eULL, 0x000fe400030006ffULL,
0x00000019ff19723eULL, 0x000fe400030006ffULL, 0x000031205e5e7816ULL, 0x000fe400000000ffULL,
0x0000005cff0c723eULL, 0x020fc400020006ffULL, 0x0000005dff0d723eULL, 0x000fe200020006ffULL,
0x000000180818723cULL, 0x040b620000001810ULL, 0x000031205f5f7816ULL, 0x000fe400000000ffULL,
0x00000054ff54723eULL, 0x000fe400030006ffULL, 0x00000055ff55723eULL, 0x000fe400030006ffULL,
0x00000056ff30723eULL, 0x000fe200020006ffULL, 0x0000000c0814723cULL, 0x000b640000001814ULL,
0x0000005cff10723eULL, 0x020fc400030006ffULL, 0x0000005dff11723eULL, 0x000fc600030006ffULL,
0x0000005eff0c723eULL, 0x080fe200020006ffULL, 0x000000540838723cULL, 0x000b620000001838ULL,
0x0000005fff0d723eULL, 0x080fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400030006ffULL,
0x0000005fff5f723eULL, 0x000fc600030006ffULL, 0x000000300830723cULL, 0x040b700000001850ULL,
0x000000100810723cULL, 0x040b70000000184cULL, 0x0000000c080c723cULL, 0x040b700000001858ULL,
0x0000005e0808723cULL, 0x000b62000000183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000024000720cULL, 0x000fe20003f06070ULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4a7224ULL, 0x002fe200078e003dULL,
0x0000000148487810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3c7224ULL, 0x000fd200078e0049ULL,
0x0000914000000947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc8000001143fULL,
0x0000003e1c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x000000021c1c7819ULL, 0x000fc8000000123eULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x00000020401c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001073d7824ULL, 0x000fe200078e0227ULL, 0x00000004274a7810ULL, 0x000fe40007ffe0ffULL,
0x0000001c023c7217ULL, 0x000fe20007800000ULL, 0x000000013d3e7824ULL, 0x100fe200078e0205ULL,
0x00000002273f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001074b7824ULL, 0x000fe200078e024aULL,
0x0000000627527810ULL, 0x000fe20007ffe0ffULL, 0x000000013c3c7824ULL, 0x000fe200078e0a1cULL,
0x00000020061c7811ULL, 0x000fe200078e30ffULL, 0x000000014b4c7824ULL, 0x000fc400078e0205ULL,
0x000000104b517824ULL, 0x000fe200078e00ffULL, 0x0000003c073c7217ULL, 0x000fe20007800000ULL,
0x000000103d4f7824ULL, 0x000fe400078e00ffULL, 0x0000000107487824ULL, 0x000fe200078e023fULL,
0xfffffff051517812ULL, 0x000fe200078ee24cULL, 0x000000013d4d7824ULL, 0x000fe200078e021cULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee23eULL, 0x00000001484c7824ULL, 0x040fe200078e021cULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x00000001483e7824ULL, 0x040fe200078e0205ULL,
0x000000604d4d7210ULL, 0x080fe20007f1e0ffULL, 0x0000001048507824ULL, 0x000fe200078e00ffULL,
0x000000604c4c7210ULL, 0x000fe20007f9e0ffULL, 0x00000001073d7824ULL, 0x000fe200078e0252ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x000000014b487824ULL, 0x000fe200078e021cULL,
0xfffffff050507812ULL, 0x000fe200078ee23eULL, 0x000000013d4b7824ULL, 0x000fc400078e021cULL,
0x000000013d4e7824ULL, 0x040fe200078e0205ULL, 0x0000006048487210ULL, 0x080fe20007f7e0ffULL,
0x000000103d537824ULL, 0x000fe200078e00ffULL, 0x000000604b607210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e06ffULL, 0x00005e004d3e7a11ULL, 0x000fe200078040ffULL,
0x000000013c1c7824ULL, 0x000fe200078e0a07ULL, 0xfffffff053537812ULL, 0x000fe200078ee24eULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x00005f004d4d7a11ULL, 0x000fe200000f443dULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005e004c4b7a11ULL, 0x000fc400078c40ffULL,
0x0000001c3f00720cULL, 0x080fe40003f06070ULL, 0x000000f0214e7812ULL, 0x000fe400078ec0ffULL,
0x00005e00483f7a11ULL, 0x000fe400078a40ffULL, 0x0000001c2700720cULL, 0x000fe40003f86070ULL,
0x00005f004c4c7a11ULL, 0x000fe400030f443cULL, 0x0000004e3e3c7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x0000001c4a00720cULL, 0x000fc40003f66070ULL,
0x00005f0048487a11ULL, 0x000fe200028f443dULL, 0x000000ffff3d7224ULL, 0x000fe200030e064dULL,
0x00005e00604a7a11ULL, 0x000fe400078a40ffULL, 0x0000001c5200720cULL, 0x000fe40003f46070ULL,
0x00005f00601c7a11ULL, 0x000fe200028f443eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c4f7faeULL, 0x0003e2000e101c46ULL, 0x0000004e4b3e7210ULL, 0x000fe40007fbe0ffULL,
0x0000e00050507811ULL, 0x000fc400078e20ffULL, 0x0000e00053537811ULL, 0x000fe400078e20ffULL,
0x0000004e3f3c7210ULL, 0x082fe20007f9e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e064cULL,
0x0000004e4a4a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200020e0648ULL,
0x000000003e507faeULL, 0x0003e2000c101c46ULL, 0x000000ffff4b7224ULL, 0x000fc600028e061cULL,
0x000000003c517faeULL, 0x0003e8000d901c46ULL, 0x000000004a537faeULL, 0x0003e2000d101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x00000001071c7824ULL, 0x000fe200078e0227ULL,
0x00000020063d7811ULL, 0x000fe400078e30ffULL, 0x000000f0214f7812ULL, 0x000fe200078ec0ffULL,
0x000000011c3c7824ULL, 0x040fe200078e0205ULL, 0x000000021c3f7810ULL, 0x040fe20007ffe0ffULL,
0x000000101c507824ULL, 0x040fe200078e00ffULL, 0x000000041c487810ULL, 0x000fc40007ffe0ffULL,
0x000000061c4a7810ULL, 0x000fe20007ffe0ffULL, 0x000000013f3e7824ULL, 0x040fe200078e0205ULL,
0xfffffff050507812ULL, 0x000fe200078ee23cULL, 0x000000103f517824ULL, 0x000fe400078e00ffULL,
0x000000011c3c7824ULL, 0x000fe200078e023dULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000013d1c7824ULL, 0x000fe200078e023fULL, 0xfffffff051517812ULL, 0x000fe200078ee23eULL,
0x00000001483f7824ULL, 0x000fe200078e0205ULL, 0x000000603c3e7210ULL, 0x000fe20007f7e0ffULL,
0x000000013d3c7824ULL, 0x000fc400078e0248ULL, 0x000000013d3d7824ULL, 0x000fe200078e024aULL,
0x00005e003e4c7a11ULL, 0x000fe200078840ffULL, 0x0000001048527824ULL, 0x000fe200078e00ffULL,
0x0000001c60487210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x0000003c603c7210ULL, 0x000fe20007f5e0ffULL, 0x000000014a4b7824ULL, 0x000fe200078e0205ULL,
0x0000003d603d7210ULL, 0x000fe20007f7e0ffULL, 0x000000104a537824ULL, 0x000fe200078e00ffULL,
0xfffffff052527812ULL, 0x000fe200078ee23fULL, 0x000000ffff4d7224ULL, 0x000fe200000e06ffULL,
0x00005f003e4e7a11ULL, 0x000fe200020f441cULL, 0x000000ffff3f7224ULL, 0x000fe200010e06ffULL,
0xfffffff053537812ULL, 0x000fe200078ee24bULL, 0x000000ffff4b7224ULL, 0x000fe200018e06ffULL,
0x00005e00481c7a11ULL, 0x000fc400078040ffULL, 0x00005e003c3e7a11ULL, 0x000fe400078440ffULL,
0x0000004f4c4c7210ULL, 0x080fe40007f9e0ffULL, 0x00005e003d4a7a11ULL, 0x000fe400078640ffULL,
0x00005f0048487a11ULL, 0x000fe200000f444dULL, 0x000000ffff4d7224ULL, 0x000fe200020e064eULL,
0x00005f003c3f7a11ULL, 0x000fe400010f443fULL, 0x0000004f1c3c7210ULL, 0x000fc40007f1e0ffULL,
0x00005f003d4b7a11ULL, 0x000fe200018f444bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c507faeULL, 0x0003e2000b901c46ULL, 0x0000004f3e3e7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0648ULL, 0x0000004f4a4a7210ULL, 0x000fe40007f7e0ffULL,
0x0000e000511c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e063fULL,
0x0000e00052487811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe400018e064bULL,
0x000000003c1c7faeULL, 0x0005e2000b901c46ULL, 0x0000e000534c7811ULL, 0x002fc600078e20ffULL,
0x000000003e487faeULL, 0x0005e8000b901c46ULL, 0x000000004a4c7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x00000002201c7810ULL, 0x000fc80007ffe0ffULL,
0x000000031c00720cULL, 0x000fe20003f06070ULL, 0xffffffffff1c7424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000021e3c7810ULL, 0x002fe20007ffe020ULL,
0x00000004ff3d7424ULL, 0x000fc800078e00ffULL, 0x000060003c3c7625ULL, 0x000fca00078e003dULL,
0x000000063c1c7981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4a7f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01062800074c7f8cULL, 0x0004e4000c80043fULL, 0x00000000003c7805ULL, 0x000fc40000015200ULL,
0x01062c00073e7984ULL, 0x000ea40000000800ULL, 0x800000003eff7812ULL, 0x00cfe4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c487210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000483e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01062c00073e7984ULL, 0x000ea40000000800ULL,
0x800000003eff7812ULL, 0x004fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01008000283d7984ULL, 0x000ea80000000800ULL, 0x0102800028487984ULL, 0x0006620000000800ULL,
0x000000493d00720bULL, 0x004fe20003f1d000ULL, 0x0000db227f007947ULL, 0x000fd8000b800000ULL,
0x00000000004d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff4dff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4c7424ULL, 0x000fc400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e0049ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe40003f05270ULL, 0x000000493d00720bULL, 0x000fe20003f54000ULL,
0x0000dae27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x000fc400010e0100ULL,
0x000000493d3e8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0104803e28008388ULL, 0x0005e40000000800ULL, 0x000099103c3e7816ULL, 0x004fc800000000ffULL,
0x000000ff3e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000493d3e7209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff3cff7812ULL, 0x000fc6000780c0ffULL, 0x000000493e3e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b3e3e7820ULL, 0x000fc80000410000ULL, 0x0000003e004e7308ULL, 0x000ea40000000800ULL,
0x0000004e1d1d7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff3e7819ULL, 0x000fe20000011605ULL, 0x0000da227f007947ULL, 0x000fea000b800000ULL,
0x00001f3e4e3e7589ULL, 0x0004e400000e0000ULL, 0x0000003e34347220ULL, 0x088fe20000410000ULL,
0x0000003e35357220ULL, 0x080fe20000410000ULL, 0x0000003e38387220ULL, 0x080fe20000410000ULL,
0x0000003e39397220ULL, 0x080fe20000410000ULL, 0x0000003e30307220ULL, 0x080fe20000410000ULL,
0x0000003e31317220ULL, 0x080fe20000410000ULL, 0x0000003e18187220ULL, 0x080fe20000410000ULL,
0x0000003e19197220ULL, 0x080fe20000410000ULL, 0x0000003e14147220ULL, 0x080fe20000410000ULL,
0x0000003e15157220ULL, 0x080fe20000410000ULL, 0x0000003e10107220ULL, 0x080fe20000410000ULL,
0x0000003e11117220ULL, 0x080fe20000410000ULL, 0x0000003e0c0c7220ULL, 0x080fe20000410000ULL,
0x0000003e0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003e08087220ULL, 0x080fe20000410000ULL,
0x0000003e09097220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff003cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008053e7811ULL, 0x000fe200078ff0ffULL, 0x0000d9227f007947ULL, 0x000fea000b800000ULL,
0x00001f3e4e3e7589ULL, 0x0006a400000e0000ULL, 0x0000003e36367220ULL, 0x084fe20000410000ULL,
0x0000003e37377220ULL, 0x080fe20000410000ULL, 0x0000003e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003e32327220ULL, 0x080fe20000410000ULL,
0x0000003e33337220ULL, 0x080fe20000410000ULL, 0x0000003e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003e1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003e16167220ULL, 0x080fe20000410000ULL,
0x0000003e17177220ULL, 0x080fe20000410000ULL, 0x0000003e12127220ULL, 0x080fe20000410000ULL,
0x0000003e13137220ULL, 0x080fe20000410000ULL, 0x0000003e0e0e7220ULL, 0x080fe20000410000ULL,
0x0000003e0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003e0a0a7220ULL, 0x080fe20000410000ULL,
0x0000003e0b0b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fe2000780084dULL, 0x00000001ff4c7424ULL, 0x000fe200078e00ffULL,
0x000000493d497209ULL, 0x000fca0007810000ULL, 0x000000ffff3c7224ULL, 0x000fcc00078e0049ULL,
0x800000493d3d0221ULL, 0x100fe20000010000ULL, 0x000000ffff3c0224ULL, 0x000fe200078e0049ULL,
0x00007610ff4c0816ULL, 0x000fe4000000004cULL, 0x3fb8aa3b3d3d0820ULL, 0x000fc80000410000ULL,
0x0000003d00240308ULL, 0x000ea40000000800ULL, 0x0000002448480220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001d481d7221ULL, 0x002fc20000010000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x000000483e487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e3fULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3d7819ULL, 0x000fc80000011449ULL, 0x000000483d3d7211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x000000023d3d7819ULL, 0x000fc80000001248ULL,
0x0000003d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014d4d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104c3d7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff3d00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000024ff25723eULL, 0x000fe400000000ffULL,
0x00000002ff477819ULL, 0x000fe40000011605ULL, 0x00005410253d7816ULL, 0x000fe20000000025ULL,
0x0000d4f27f007947ULL, 0x000fea000b800000ULL, 0x00001f473d257589ULL, 0x0002a400000e0000ULL,
0x0000000847267810ULL, 0x000fe20007ffe0ffULL, 0x0000d5227f007947ULL, 0x000fea000b800000ULL,
0x00001f263d267589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010473f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e003dULL,
0x00005c60003e7802ULL, 0x000fc40000000f00ULL, 0x0000e07000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018473f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e003dULL, 0x00005cb0003e7802ULL, 0x000fc40000000f00ULL,
0x0000e02000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000a8002a4c7811ULL, 0x004fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002b54783bULL, 0x000ea80000004200ULL, 0x000000004c4c783bULL, 0x008ee80000000200ULL,
0x000000002c50783bULL, 0x000e680000004200ULL, 0x000000002e58783bULL, 0x000e680000004200ULL,
0x000000002f60783bULL, 0x000e620000004200ULL, 0x0000312054547816ULL, 0x004fc400000000ffULL,
0x0000312055557816ULL, 0x000fe200000000ffULL, 0x000000254c4ca232ULL, 0x088fe20000000000ULL,
0x00000054ff3e723eULL, 0x080fe200020006ffULL, 0x000000254e4ea232ULL, 0x000fe20000000000ULL,
0x00000055ff3f723eULL, 0x080fe200020006ffULL, 0x000000264d4da232ULL, 0x080fe20000000000ULL,
0x00000054ff54723eULL, 0x000fe200030006ffULL, 0x000000264f4fa232ULL, 0x000fe20000000000ULL,
0x00000055ff55723eULL, 0x000fe400030006ffULL, 0x00003120563d7816ULL, 0x002fc400000000ffULL,
0x0000312050507816ULL, 0x000fe400000000ffULL, 0x0000003e4c34723cULL, 0x040b620000001834ULL,
0x0000312051517816ULL, 0x000fe400000000ffULL, 0x0000312058587816ULL, 0x000fe400000000ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x00003120573f7816ULL, 0x020fe200000000ffULL,
0x000000544c38723cULL, 0x000be20000001838ULL, 0x0000003dff3e723eULL, 0x000fc400030006ffULL,
0x000031205a5a7816ULL, 0x000fe400000000ffULL, 0x0000312060607816ULL, 0x000fe400000000ffULL,
0x0000003dff54723eULL, 0x020fe400020006ffULL, 0x0000003fff55723eULL, 0x080fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400030006ffULL, 0x00003120523d7816ULL, 0x000fc400000000ffULL,
0x0000312061617816ULL, 0x000fe200000000ffULL, 0x000000544c54723cULL, 0x040be20000001830ULL,
0x0000003dff5c723eULL, 0x000fe400020006ffULL, 0x0000312062627816ULL, 0x000fe400000000ffULL,
0x0000312063637816ULL, 0x000fe400000000ffULL, 0x0000a8002d307811ULL, 0x020fe200078e20ffULL,
0x0000003e4c18723cULL, 0x000bea0000001818ULL, 0x000000003030783bULL, 0x000e640000000200ULL,
0x00000050ff3e723eULL, 0x020fc400020006ffULL, 0x00000051ff3f723eULL, 0x080fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400030006ffULL, 0x00000051ff51723eULL, 0x000fc600030006ffULL,
0x0000003e4c14723cULL, 0x040b6e0000001814ULL, 0x00003120533e7816ULL, 0x020fe400000000ffULL,
0x000000504c50723cULL, 0x000b640000001810ULL, 0x0000003eff5d723eULL, 0x000fca00020006ffULL,
0x00000058ff10723eULL, 0x020fe400020006ffULL, 0x00000059ff11723eULL, 0x000fe200020006ffULL,
0x0000005c4c5c723cULL, 0x000b6e000000180cULL, 0x0000003dff0c723eULL, 0x020fc400030006ffULL,
0x0000003eff0d723eULL, 0x000fe200030006ffULL, 0x000000253030a232ULL, 0x082fe40000000000ULL,
0x000000253232a232ULL, 0x000fe40000000000ULL, 0x000000263131a232ULL, 0x080fe40000000000ULL,
0x000000263333a232ULL, 0x000fe20000000000ULL, 0x0000000c4c4c723cULL, 0x000b6e0000001808ULL,
0x000031205b097816ULL, 0x020fe200000000ffULL, 0x000000103010723cULL, 0x000b620000001834ULL,
0x0000005aff08723eULL, 0x000fc400030006ffULL, 0x00000060ff0c723eULL, 0x000fe400020006ffULL,
0x00000061ff0d723eULL, 0x000fe400020006ffULL, 0x00000058ff34723eULL, 0x020fe400030006ffULL,
0x00000059ff35723eULL, 0x000fc600030006ffULL, 0x0000000c300c723cULL, 0x040b6e0000001814ULL,
0x00000060ff14723eULL, 0x020fe200030006ffULL, 0x000000343034723cULL, 0x000b620000001838ULL,
0x00000061ff15723eULL, 0x000fcc00030006ffULL, 0x00000009ff39723eULL, 0x0a0fe200020006ffULL,
0x000000143014723cULL, 0x000f620000001850ULL, 0x00000009ff09723eULL, 0x000fe400030006ffULL,
0x0000005aff38723eULL, 0x000fca00020006ffULL, 0x000000083008723cULL, 0x040b6e0000001818ULL,
0x00000062ff18723eULL, 0x0a0fe200020006ffULL, 0x000000383038723cULL, 0x000b620000001854ULL,
0x00000063ff19723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fc400030006ffULL,
0x00000063ff63723eULL, 0x000fc600030006ffULL, 0x000000183018723cULL, 0x040b70000000185cULL,
0x000000623030723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff4c7f8cULL, 0x020e64000c80043fULL,
0x00000000003e7805ULL, 0x000fc40000015200ULL, 0x0106bc00ff3d7984ULL, 0x000ea40000000800ULL,
0x800000003dff7812ULL, 0x006fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x000000483e477210ULL, 0x000fca0007f1e1ffULL, 0x0000000149487824ULL, 0x000fe200000e0e3fULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3d7819ULL, 0x000fc80000011448ULL, 0x000000473d3d7211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e0648ULL, 0x000000023d3d7819ULL, 0x000fc80000001247ULL,
0x0000003d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000058001c3d7a24ULL, 0x010fc800078e02ffULL,
0x000000403d3d7824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000040403e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107477824ULL, 0x000fe200078e0227ULL,
0x0000000227537810ULL, 0x040fe40007ffe0ffULL, 0x0000003e023f7217ULL, 0x000fe20007800000ULL,
0x0000004006507824ULL, 0x000fe200078e0247ULL, 0x0000000427557810ULL, 0x000fe20007ffe0ffULL,
0x0000000147487824ULL, 0x000fe200078e0205ULL, 0x000000f021517812ULL, 0x000fe200078ec0ffULL,
0x0000001047527824ULL, 0x000fe200078e00ffULL, 0x0000003d504d7210ULL, 0x040fe20007f1e0ffULL,
0x0000000107477824ULL, 0x000fe200078e0253ULL, 0x00000002504f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013f3f7824ULL, 0x000fe200078e0a3eULL, 0xfffffff052527812ULL, 0x000fe200078ee248ULL,
0x00000001073e7824ULL, 0x000fe200078e0255ULL, 0x00000004504e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000147487824ULL, 0x100fe200078e0205ULL, 0x0000003f073f7217ULL, 0x000fe20007800000ULL,
0x0000001047547824ULL, 0x000fe200078e00ffULL, 0x0000003d4e4e7210ULL, 0x000fe20007f7e0ffULL,
0x000000013e477824ULL, 0x000fe200078e0205ULL, 0x0000c00052527811ULL, 0x000fe200078e20ffULL,
0x000000103e567824ULL, 0x000fe200078e00ffULL, 0xfffffff054547812ULL, 0x000fe200078ee248ULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e004d497a11ULL, 0x000fc400078040ffULL,
0xfffffff056567812ULL, 0x000fe200078ee247ULL, 0x000000013f477824ULL, 0x000fe200078e0a07ULL,
0x00005f004d4d7a11ULL, 0x000fe200000f443eULL, 0x000000ffff3f7224ULL, 0x000fe200018e06ffULL,
0x0000003d4f4f7210ULL, 0x000fe40007f1e0ffULL, 0x000000472700720cULL, 0x000fe40003f86070ULL,
0x00005e004e487a11ULL, 0x000fe200078a40ffULL, 0x000000ffff3e7224ULL, 0x000fe200000e06ffULL,
0x00005e004f4c7a11ULL, 0x000fc400078040ffULL, 0x00005f004e4e7a11ULL, 0x000fe400028f443fULL,
0x00005f004f4f7a11ULL, 0x000fe400000f443eULL, 0x00000051493e7210ULL, 0x000fe40007f7e0ffULL,
0x000000475300720cULL, 0x000fe40003f06070ULL, 0x0000000627537810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e064dULL, 0x0000000650497810ULL, 0x000fc40007ffe0ffULL,
0x000000475500720cULL, 0x000fe20003f66070ULL, 0x00000001074d7824ULL, 0x000fe200078e0253ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e527faeULL, 0x0003e2000e101c46ULL,
0x0000003d49497210ULL, 0x000fe40007f9e0ffULL, 0x000000014d507824ULL, 0x000fe200078e0205ULL,
0x0000005148487210ULL, 0x000fe40007fde0ffULL, 0x0000c00054547811ULL, 0x000fe400078e20ffULL,
0x0000c00056567811ULL, 0x000fc400078e20ffULL, 0x000000514c3e7210ULL, 0x002fe20007fbe0ffULL,
0x000000104d527824ULL, 0x000fe400078e00ffULL, 0x000000ffff4d7224ULL, 0x000fe200020e06ffULL,
0x00005e00494c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e064fULL,
0x000000475300720cULL, 0x000fe40003fa6070ULL, 0x00005f0049477a11ULL, 0x000fe200020f444dULL,
0x000000ffff497224ULL, 0x000fe200030e064eULL, 0x000000514c4c7210ULL, 0x000fe20007f9e0ffULL,
0x000000003e547faeULL, 0x0003e2000c101c46ULL, 0xfffffff052507812ULL, 0x000fc600078ee250ULL,
0x000000ffff4d7224ULL, 0x000fe200020e0647ULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x0000000048567faeULL, 0x0003e8000d901c46ULL, 0x000000004c507faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x00000001073e7824ULL, 0x000fe200078e0227ULL,
0x000000f0214e7812ULL, 0x000fc600078ec0ffULL, 0x000000013e3f7824ULL, 0x040fe200078e0205ULL,
0x000000023e477810ULL, 0x040fe20007ffe0ffULL, 0x000000103e497824ULL, 0x000fc800078e00ffULL,
0x0000000147487824ULL, 0x000fe200078e0205ULL, 0xfffffff049497812ULL, 0x000fe200078ee23fULL,
0x0000001047507824ULL, 0x000fe200078e00ffULL, 0x000000043e477810ULL, 0x000fe20007ffe0ffULL,
0x00000040063f7824ULL, 0x000fe200078e023eULL, 0x0000c00049497811ULL, 0x000fe400078e20ffULL,
0xfffffff050507812ULL, 0x000fe200078ee248ULL, 0x00000001474c7824ULL, 0x040fe200078e0205ULL,
0x000000063e487810ULL, 0x000fe20007ffe0ffULL, 0x0000001047547824ULL, 0x000fe200078e00ffULL,
0x0000003d3f3e7210ULL, 0x000fc40007f1e0ffULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x00000001484d7824ULL, 0x000fe200078e0205ULL, 0xfffffff054547812ULL, 0x000fe200078ee24cULL,
0x0000001048587824ULL, 0x000fe200078e00ffULL, 0x000000023f4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff477224ULL, 0x000fe200000e06ffULL, 0x00005e003e487a11ULL, 0x000fe400078040ffULL,
0xfffffff058587812ULL, 0x000fe400078ee24dULL, 0x00005f003e477a11ULL, 0x000fc400000f4447ULL,
0x000000043f3e7810ULL, 0x040fe40007ffe0ffULL, 0x000000063f3f7810ULL, 0x000fe40007ffe0ffULL,
0x0000003d4c4c7210ULL, 0x080fe40007f1e0ffULL, 0x0000003d3e517210ULL, 0x080fe40007f7e0ffULL,
0x0000003d3f557210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e06ffULL,
0x00005e004c4d7a11ULL, 0x000fe200078040ffULL, 0x000000ffff527224ULL, 0x000fe200018e06ffULL,
0x0000004e483e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff567224ULL, 0x000fe200028e06ffULL,
0x00005e0051537a11ULL, 0x000fc400078840ffULL, 0x00005e0055577a11ULL, 0x000fe400078a40ffULL,
0x00005f004c4f7a11ULL, 0x000fe200000f443fULL, 0x000000ffff3f7224ULL, 0x000fe200018e0647ULL,
0x0000004e4d487210ULL, 0x080fe40007f1e0ffULL, 0x00005f0051527a11ULL, 0x000fe400020f4452ULL,
0x0000004e534c7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e497faeULL, 0x0003e2000b901c46ULL, 0x00005f0055567a11ULL, 0x000fc400028f4456ULL,
0x0000004e574e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff4d7224ULL, 0x000fe200018e0652ULL,
0x0000c00054547811ULL, 0x000fe400078e20ffULL, 0x0000c00058587811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x002fe400000e064fULL, 0x000000ffff4f7224ULL, 0x000fc600020e0656ULL,
0x0000000048507faeULL, 0x0003e8000b901c46ULL, 0x000000004c547faeULL, 0x0003e8000b901c46ULL,
0x000000004e587faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff3e7f8cULL, 0x000e64000c80043fULL,
0x000000ffff477224ULL, 0x002fc400078e003fULL, 0x00000000003e7805ULL, 0x000fca0000015200ULL,
0x0106b400ff487984ULL, 0x000e640000000800ULL, 0x8000000048ff7812ULL, 0x002fc4000780484bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x000000483e4c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000149497824ULL, 0x000fe200000e0e3fULL, 0x003d09004c00780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404c00780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff487819ULL, 0x000fc80000011449ULL,
0x0000004c48487211ULL, 0x000fca00078110ffULL, 0x000000ffff497224ULL, 0x000fca00000e0649ULL,
0x0000000248487819ULL, 0x000fc80000001249ULL, 0x000000480000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014d4d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff487984ULL, 0x000e640000000800ULL,
0x8000000048ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000024ff25723eULL, 0x000fe400000000ffULL, 0x00000002ff497819ULL, 0x000fe40000011605ULL,
0x0000541025487816ULL, 0x000fe20000000025ULL, 0x0000c1e27f007947ULL, 0x000fea000b800000ULL,
0x00001f4948257589ULL, 0x0002a400000e0000ULL, 0x0000000849267810ULL, 0x000fe20007ffe0ffULL,
0x0000c2127f007947ULL, 0x000fea000b800000ULL, 0x00001f2648267589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010493f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0048ULL, 0x00007030003e7802ULL, 0x000fc40000000f00ULL,
0x0000cca000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018493f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x004fe200078e0048ULL,
0x00007080003e7802ULL, 0x000fc40000000f00ULL, 0x0000cc5000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000a80041487811ULL, 0x00afe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000424c783bULL, 0x004e680000004200ULL,
0x000000004848783bULL, 0x000ea80000000200ULL, 0x000000004350783bULL, 0x000ee80000004200ULL,
0x000000004660783bULL, 0x000f220000004200ULL, 0x000031204e4e7816ULL, 0x002fc400000000ffULL,
0x000031204f4f7816ULL, 0x000fe400000000ffULL, 0x000031204c4c7816ULL, 0x000fe200000000ffULL,
0x000000254848a232ULL, 0x084fe20000000000ULL, 0x000031204d4d7816ULL, 0x000fe200000000ffULL,
0x000000254a4aa232ULL, 0x000fe20000000000ULL, 0x0000004eff58723eULL, 0x000fe200020006ffULL,
0x000000264949a232ULL, 0x080fe20000000000ULL, 0x0000004fff59723eULL, 0x000fe200020006ffULL,
0x000000264b4ba232ULL, 0x000fe20000000000ULL, 0x0000004cff54723eULL, 0x000fc400030006ffULL,
0x0000004dff55723eULL, 0x080fe400030006ffULL, 0x0000004cff3e723eULL, 0x000fe400020006ffULL,
0x0000a800444c7811ULL, 0x000fe200078e20ffULL, 0x000000584858723cULL, 0x000be20000001838ULL,
0x0000004dff3f723eULL, 0x000fe200020006ffULL, 0x000000004538783bULL, 0x020e620000004200ULL,
0x0000312050507816ULL, 0x008fe400000000ffULL, 0x0000312051517816ULL, 0x000fc400000000ffULL,
0x0000312060607816ULL, 0x010fe200000000ffULL, 0x000000544854723cULL, 0x000be20000001834ULL,
0x0000312061617816ULL, 0x000fe400000000ffULL, 0x0000312062627816ULL, 0x000fc800000000ffULL,
0x0000004eff34723eULL, 0x020fe200030006ffULL, 0x0000003e4810723cULL, 0x040fe20000001810ULL,
0x0000004fff35723eULL, 0x000fe400030006ffULL, 0x000000004c4c783bULL, 0x000eaa0000000200ULL,
0x000000344808723cULL, 0x000bee0000001808ULL, 0x00000050ff34723eULL, 0x020fc400020006ffULL,
0x00000051ff35723eULL, 0x080fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400030006ffULL,
0x00000051ff51723eULL, 0x000fc600030006ffULL, 0x00000034480c723cULL, 0x000b62000000180cULL,
0x0000312038387816ULL, 0x002fe400000000ffULL, 0x0000312039397816ULL, 0x000fc800000000ffULL,
0x0000312052347816ULL, 0x020fe400000000ffULL, 0x0000312053357816ULL, 0x000fe400000000ffULL,
0x00000034ff5c723eULL, 0x080fe200020006ffULL, 0x000000504850723cULL, 0x000be20000001814ULL,
0x00000035ff5d723eULL, 0x080fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fe200030006ffULL, 0x000000254c4ca232ULL, 0x004fc40000000000ULL,
0x0000005c485c723cULL, 0x000f620000001818ULL, 0x000000254e4ea232ULL, 0x000fe20000000000ULL,
0x00000060ff14723eULL, 0x020fe200020006ffULL, 0x000000264d4da232ULL, 0x080fe20000000000ULL,
0x00000061ff15723eULL, 0x000fe200020006ffULL, 0x000000264f4fa232ULL, 0x000fc60000000000ULL,
0x000000344848723cULL, 0x000b6e0000001830ULL, 0x00000038ff34723eULL, 0x0a0fe200020006ffULL,
0x000000144c14723cULL, 0x000b62000000180cULL, 0x00000039ff35723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fc400030006ffULL, 0x00000039ff39723eULL, 0x000fe400030006ffULL,
0x00000062ff0c723eULL, 0x020fe200020006ffULL, 0x000000344c34723cULL, 0x000b6e0000001810ULL,
0x000031203a107816ULL, 0x020fc400000000ffULL, 0x000031203b117816ULL, 0x000fe400000000ffULL,
0x00000010ff30723eULL, 0x080fe200020006ffULL, 0x000000384c38723cULL, 0x000f620000001854ULL,
0x00000011ff31723eULL, 0x080fe400020006ffULL, 0x00000010ff10723eULL, 0x000fe400030006ffULL,
0x00000011ff11723eULL, 0x000fc600030006ffULL, 0x000000304c30723cULL, 0x040f700000001858ULL,
0x000000104c18723cULL, 0x000b6e0000001808ULL, 0x0000312063097816ULL, 0x020fc400000000ffULL,
0x00000060ff10723eULL, 0x000fe400030006ffULL, 0x00000009ff0d723eULL, 0x000fe400020006ffULL,
0x00000061ff11723eULL, 0x000fe400030006ffULL, 0x00000062ff08723eULL, 0x000fe400030006ffULL,
0x00000009ff09723eULL, 0x000fe200030006ffULL, 0x0000000c4c0c723cULL, 0x040b70000000185cULL,
0x000000104c10723cULL, 0x040b700000001850ULL, 0x000000084c08723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000040403e7810ULL, 0x002fe20007ffe0ffULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4a7224ULL, 0x020fe200078e003fULL, 0x0000000220487810ULL, 0x000fc40007ffe0ffULL,
0x000000023e00720cULL, 0x000fda0003f06070ULL, 0x000060b000000947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fc40000015200ULL, 0x0106bc00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x000000483e487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e3fULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011449ULL, 0x000000481c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x000000021c1c7819ULL, 0x000fc80000001248ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x00000060401c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001073f7824ULL, 0x000fe200078e0227ULL,
0x0000000427527810ULL, 0x000fe40007ffe0ffULL, 0x0000001c023e7217ULL, 0x000fe20007800000ULL,
0x000000013f487824ULL, 0x000fe200078e0205ULL, 0x0000000227497810ULL, 0x000fe20007ffe0ffULL,
0x000000103f507824ULL, 0x000fe200078e00ffULL, 0x0000000627547810ULL, 0x000fe20007ffe0ffULL,
0x000000013e3e7824ULL, 0x000fe200078e0a1cULL, 0x00000020061c7811ULL, 0x000fe200078e30ffULL,
0x00000001074b7824ULL, 0x040fe200078e0252ULL, 0xfffffff050507812ULL, 0x000fe200078ee248ULL,
0x00000001074a7824ULL, 0x040fe200078e0249ULL, 0x0000003e073e7217ULL, 0x000fe20007800000ULL,
0x000000013f4e7824ULL, 0x100fe200078e021cULL, 0x000000f0214f7812ULL, 0x000fe200078ec0ffULL,
0x000000014b4c7824ULL, 0x040fe200078e0205ULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000104b537824ULL, 0x000fe200078e00ffULL, 0x0000003d4e4e7210ULL, 0x000fe20007f1e0ffULL,
0x000000014a4d7824ULL, 0x000fc400078e021cULL, 0x000000014a487824ULL, 0x140fe200078e0205ULL,
0xfffffff053537812ULL, 0x000fe200078ee24cULL, 0x000000104a517824ULL, 0x000fe200078e00ffULL,
0x0000003d4d4d7210ULL, 0x080fe20007f9e0ffULL, 0x00000001073f7824ULL, 0x000fe200078e0254ULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000014b4b7824ULL, 0x000fe200078e021cULL,
0xfffffff051517812ULL, 0x000fe200078ee248ULL, 0x000000013f4a7824ULL, 0x040fe400078e021cULL,
0x000000013f4c7824ULL, 0x000fe200078e0205ULL, 0x0000003d4b4b7210ULL, 0x080fe20007f7e0ffULL,
0x000000103f557824ULL, 0x000fe200078e00ffULL, 0x0000003d4a3d7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e06ffULL, 0x00005e004e487a11ULL, 0x000fe200078040ffULL,
0x000000013e1c7824ULL, 0x000fe200078e0a07ULL, 0xfffffff055557812ULL, 0x000fe200078ee24cULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00005f004e4e7a11ULL, 0x000fe200000f443fULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x00005e004d4c7a11ULL, 0x000fc400078c40ffULL,
0x0000001c4900720cULL, 0x080fe40003f06070ULL, 0x00005e004b497a11ULL, 0x000fe400078a40ffULL,
0x0000001c2700720cULL, 0x000fe40003f86070ULL, 0x00005f004d4d7a11ULL, 0x000fe400030f443eULL,
0x0000004f483e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x00005f004b4b7a11ULL, 0x000fc400028f443fULL, 0x00005e003d4a7a11ULL, 0x040fe200078a40ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e064eULL, 0x0000001c5200720cULL, 0x080fe40003f66070ULL,
0x0000001c5400720cULL, 0x000fe40003f46070ULL, 0x00005f003d1c7a11ULL, 0x000fe200028f4448ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e507faeULL, 0x0003e2000e101c46ULL,
0x0000004f4c487210ULL, 0x000fe40007fbe0ffULL, 0x0000e00051517811ULL, 0x000fc400078e20ffULL,
0x0000e00055557811ULL, 0x000fe400078e20ffULL, 0x0000004f493e7210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff497224ULL, 0x000fe200028e064dULL, 0x0000004f4a4a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200020e064bULL, 0x0000000048517faeULL, 0x0003e2000c101c46ULL,
0x000000ffff4b7224ULL, 0x000fc600028e061cULL, 0x000000003e537faeULL, 0x0003e8000d901c46ULL,
0x000000004a557faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x00000001071c7824ULL, 0x000fe200078e0227ULL, 0x00000020063e7811ULL, 0x000fe400078e30ffULL,
0x000000f0214f7812ULL, 0x000fe200078ec0ffULL, 0x000000011c3f7824ULL, 0x040fe200078e0205ULL,
0x000000021c487810ULL, 0x040fe20007ffe0ffULL, 0x000000101c507824ULL, 0x040fe200078e00ffULL,
0x000000061c4a7810ULL, 0x000fc60007ffe0ffULL, 0x0000000148497824ULL, 0x000fe200078e0205ULL,
0xfffffff050507812ULL, 0x000fe200078ee23fULL, 0x0000001048517824ULL, 0x000fe400078e00ffULL,
0x000000011c3f7824ULL, 0x000fe200078e023eULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000013e4b7824ULL, 0x040fe200078e0248ULL, 0xfffffff051517812ULL, 0x000fe200078ee249ULL,
0x000000013e4d7824ULL, 0x000fe200078e024aULL, 0x000000041c497810ULL, 0x000fe20007ffe0ffULL,
0x000000014a4e7824ULL, 0x040fe200078e0205ULL, 0x0000003d3f3f7210ULL, 0x080fe20007f7e0ffULL,
0x000000104a537824ULL, 0x000fe200078e00ffULL, 0x0000003d4b4b7210ULL, 0x080fe20007f1e0ffULL,
0x000000013e1c7824ULL, 0x000fe200078e0249ULL, 0x00005e003f4c7a11ULL, 0x000fe200078840ffULL,
0x0000000149487824ULL, 0x000fe200078e0205ULL, 0xfffffff053537812ULL, 0x000fe200078ee24eULL,
0x0000001049527824ULL, 0x000fe200078e00ffULL, 0x0000003d1c497210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x0000003d4d1c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200000e06ffULL, 0xfffffff052527812ULL, 0x000fc400078ee248ULL,
0x00005f003f4e7a11ULL, 0x000fe200020f443eULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x00005e004b3f7a11ULL, 0x000fe200078040ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e06ffULL,
0x00005e0049487a11ULL, 0x000fe400078440ffULL, 0x00005e001c4a7a11ULL, 0x000fe400078640ffULL,
0x0000004f4c4c7210ULL, 0x000fe40007f9e0ffULL, 0x00005f004b4b7a11ULL, 0x000fc400000f444dULL,
0x00005f0049497a11ULL, 0x000fe200010f443eULL, 0x000000ffff4d7224ULL, 0x000fe200020e064eULL,
0x0000004f3f3e7210ULL, 0x080fe40007f1e0ffULL, 0x00005f001c1c7a11ULL, 0x000fe400018f443dULL,
0x0000004f48487210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e064bULL,
0x0000004f4a4a7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c507faeULL, 0x0003e2000b901c46ULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200010e0649ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e061cULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000003e517faeULL, 0x0003e8000b901c46ULL, 0x0000000048527faeULL, 0x0003e8000b901c46ULL,
0x000000004a537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000003203e7810ULL, 0x002fc80007ffe0ffULL, 0x000000033e00720cULL, 0x000fe20003f06070ULL,
0xffffffffff1c7424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000011e3e7824ULL, 0x000fe400078e023eULL, 0x00000004ff3f7424ULL, 0x000fc800078e00ffULL,
0x000060003e3e7625ULL, 0x000fca00078e003fULL, 0x000000063e1c7981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff487f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01064800074c7f8cULL, 0x000664000c80043fULL,
0x00000000003e7805ULL, 0x002fc40000015200ULL, 0x01064c00073d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a3e4a7210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4b7824ULL, 0x000fe200000e0e3fULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3d7819ULL, 0x000fc8000001144bULL, 0x0000004a3d3d7211ULL, 0x000fca00078110ffULL,
0x000000ffff4a7224ULL, 0x000fca00000e064bULL, 0x000000023d3d7819ULL, 0x000fc8000000124aULL,
0x0000003d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01064c00073d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01010000283d7984ULL, 0x000e680000000800ULL,
0x01030000284a7984ULL, 0x0006a20000000800ULL, 0x0000003c3d00720bULL, 0x002fe20003f1d000ULL,
0x0000ad727f007947ULL, 0x000fd8000b800000ULL, 0x00000000004b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff4bff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4c7424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000020000780cULL, 0x000fe40003f05270ULL, 0x0000003c3d00720bULL, 0x000fe20003f54000ULL,
0x0000ad427f007947ULL, 0x000fd8000b800000ULL, 0x00000000004d7806ULL, 0x000fc400010e0100ULL,
0x0000003d3c3e8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0105003e28008388ULL, 0x0003e40000000800ULL, 0x000099104d3e7816ULL, 0x002fc800000000ffULL,
0x000000ff3e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000003d3c3e7209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff4dff7812ULL, 0x000fc6000780c0ffULL, 0x8000003e3c3e7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b3e3e7820ULL, 0x000fc80000410000ULL, 0x0000003e004e7308ULL, 0x000e640000000800ULL,
0x0000004e1d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff3e7819ULL, 0x000fe20000011605ULL, 0x0000ac827f007947ULL, 0x000fea000b800000ULL,
0x00001f3e4e3e7589ULL, 0x0002e400000e0000ULL, 0x0000003e34347220ULL, 0x088fe20000410000ULL,
0x0000003e35357220ULL, 0x080fe20000410000ULL, 0x0000003e38387220ULL, 0x080fe20000410000ULL,
0x0000003e39397220ULL, 0x080fe20000410000ULL, 0x0000003e30307220ULL, 0x080fe20000410000ULL,
0x0000003e31317220ULL, 0x080fe20000410000ULL, 0x0000003e18187220ULL, 0x080fe20000410000ULL,
0x0000003e19197220ULL, 0x080fe20000410000ULL, 0x0000003e14147220ULL, 0x080fe20000410000ULL,
0x0000003e15157220ULL, 0x080fe20000410000ULL, 0x0000003e10107220ULL, 0x080fe20000410000ULL,
0x0000003e11117220ULL, 0x080fe20000410000ULL, 0x0000003e0c0c7220ULL, 0x080fe20000410000ULL,
0x0000003e0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003e08087220ULL, 0x080fe20000410000ULL,
0x0000003e09097220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff004dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008053e7811ULL, 0x000fe200078ff0ffULL, 0x0000ab827f007947ULL, 0x000fea000b800000ULL,
0x00001f3e4e3e7589ULL, 0x00066400000e0000ULL, 0x0000003e36367220ULL, 0x082fe20000410000ULL,
0x0000003e37377220ULL, 0x080fe20000410000ULL, 0x0000003e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003e32327220ULL, 0x080fe20000410000ULL,
0x0000003e33337220ULL, 0x080fe20000410000ULL, 0x0000003e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003e1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003e16167220ULL, 0x080fe20000410000ULL,
0x0000003e17177220ULL, 0x080fe20000410000ULL, 0x0000003e12127220ULL, 0x080fe20000410000ULL,
0x0000003e13137220ULL, 0x080fe20000410000ULL, 0x0000003e0e0e7220ULL, 0x080fe20000410000ULL,
0x0000003e0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003e0a0a7220ULL, 0x080fe20000410000ULL,
0x0000003e0b0b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff4dff7812ULL, 0x000fe2000780084bULL, 0x00000001ff4c7424ULL, 0x000fe200078e00ffULL,
0x0000003d3c3c7209ULL, 0x000fd60007810000ULL, 0x8000003c3d3d0221ULL, 0x000fe20000010000ULL,
0x00007610ff4c0816ULL, 0x000fc6000000004cULL, 0x3fb8aa3b3d3d0820ULL, 0x000fc80000410000ULL,
0x0000003d00240308ULL, 0x000e640000000800ULL, 0x000000244a4a0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001d4a1d7221ULL, 0x004fc20000010000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a3e4a7210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4b7824ULL, 0x000fe200000e0e3fULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3d7819ULL, 0x000fc8000001144bULL, 0x0000004a3d3d7211ULL, 0x000fca00078110ffULL,
0x000000ffff4a7224ULL, 0x000fca00000e064bULL, 0x000000023d3d7819ULL, 0x000fc8000000124aULL,
0x0000003d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014d4d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104c3d7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff3d00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000024ff25723eULL, 0x000fe400000000ffULL,
0x00000002ff477819ULL, 0x000fe40000011605ULL, 0x00005410253d7816ULL, 0x000fe20000000025ULL,
0x0000a7727f007947ULL, 0x000fea000b800000ULL, 0x00001f473d257589ULL, 0x0002a400000e0000ULL,
0x0000000847267810ULL, 0x000fe20007ffe0ffULL, 0x0000a7a27f007947ULL, 0x000fea000b800000ULL,
0x00001f263d267589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010473f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e003dULL,
0x00008cc0003e7802ULL, 0x000fc40000000f00ULL, 0x0000b01000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018473f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e003dULL, 0x00008d10003e7802ULL, 0x000fc40000000f00ULL,
0x0000afc000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000b0002a4c7811ULL, 0x004fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002b54783bULL, 0x000ea80000004200ULL, 0x000000004c4c783bULL, 0x008ee80000000200ULL,
0x000000002c50783bULL, 0x000e680000004200ULL, 0x000000002e58783bULL, 0x000e680000004200ULL,
0x000000002f60783bULL, 0x000e620000004200ULL, 0x0000312054547816ULL, 0x004fc400000000ffULL,
0x0000312055557816ULL, 0x000fe200000000ffULL, 0x000000254c4ca232ULL, 0x088fe20000000000ULL,
0x00000054ff3e723eULL, 0x080fe200020006ffULL, 0x000000254e4ea232ULL, 0x000fe20000000000ULL,
0x00000055ff3f723eULL, 0x080fe200020006ffULL, 0x000000264d4da232ULL, 0x080fe20000000000ULL,
0x00000054ff54723eULL, 0x000fe200030006ffULL, 0x000000264f4fa232ULL, 0x000fe20000000000ULL,
0x00000055ff55723eULL, 0x000fe400030006ffULL, 0x00003120563d7816ULL, 0x002fc400000000ffULL,
0x0000312050507816ULL, 0x000fe400000000ffULL, 0x0000003e4c34723cULL, 0x040b620000001834ULL,
0x0000312051517816ULL, 0x000fe400000000ffULL, 0x0000312058587816ULL, 0x000fe400000000ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x00003120573f7816ULL, 0x020fe200000000ffULL,
0x000000544c38723cULL, 0x000be20000001838ULL, 0x0000003dff3e723eULL, 0x000fc400030006ffULL,
0x000031205a5a7816ULL, 0x000fe400000000ffULL, 0x0000312060607816ULL, 0x000fe400000000ffULL,
0x0000003dff54723eULL, 0x020fe400020006ffULL, 0x0000003fff55723eULL, 0x080fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400030006ffULL, 0x00003120523d7816ULL, 0x000fc400000000ffULL,
0x0000312061617816ULL, 0x000fe200000000ffULL, 0x000000544c54723cULL, 0x040be20000001830ULL,
0x0000003dff5c723eULL, 0x000fe400020006ffULL, 0x0000312062627816ULL, 0x000fe400000000ffULL,
0x0000312063637816ULL, 0x000fe400000000ffULL, 0x0000b0002d307811ULL, 0x020fe200078e20ffULL,
0x0000003e4c18723cULL, 0x000bea0000001818ULL, 0x000000003030783bULL, 0x000e640000000200ULL,
0x00000050ff3e723eULL, 0x020fc400020006ffULL, 0x00000051ff3f723eULL, 0x080fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400030006ffULL, 0x00000051ff51723eULL, 0x000fc600030006ffULL,
0x0000003e4c14723cULL, 0x040b6e0000001814ULL, 0x00003120533e7816ULL, 0x020fe400000000ffULL,
0x000000504c50723cULL, 0x000b640000001810ULL, 0x0000003eff5d723eULL, 0x000fca00020006ffULL,
0x00000058ff10723eULL, 0x020fe400020006ffULL, 0x00000059ff11723eULL, 0x000fe200020006ffULL,
0x0000005c4c5c723cULL, 0x000b6e000000180cULL, 0x0000003dff0c723eULL, 0x020fc400030006ffULL,
0x0000003eff0d723eULL, 0x000fe200030006ffULL, 0x000000253030a232ULL, 0x082fe40000000000ULL,
0x000000253232a232ULL, 0x000fe40000000000ULL, 0x000000263131a232ULL, 0x080fe40000000000ULL,
0x000000263333a232ULL, 0x000fe20000000000ULL, 0x0000000c4c4c723cULL, 0x000b6e0000001808ULL,
0x000031205b097816ULL, 0x020fe200000000ffULL, 0x000000103010723cULL, 0x000b620000001834ULL,
0x0000005aff08723eULL, 0x000fc400030006ffULL, 0x00000060ff0c723eULL, 0x000fe400020006ffULL,
0x00000061ff0d723eULL, 0x000fe400020006ffULL, 0x00000058ff34723eULL, 0x020fe400030006ffULL,
0x00000059ff35723eULL, 0x000fc600030006ffULL, 0x0000000c300c723cULL, 0x040b6e0000001814ULL,
0x00000060ff14723eULL, 0x020fe200030006ffULL, 0x000000343034723cULL, 0x000b620000001838ULL,
0x00000061ff15723eULL, 0x000fcc00030006ffULL, 0x00000009ff39723eULL, 0x0a0fe200020006ffULL,
0x000000143014723cULL, 0x000f620000001850ULL, 0x00000009ff09723eULL, 0x000fe400030006ffULL,
0x0000005aff38723eULL, 0x000fca00020006ffULL, 0x000000083008723cULL, 0x040b6e0000001818ULL,
0x00000062ff18723eULL, 0x0a0fe200020006ffULL, 0x000000383038723cULL, 0x000b620000001854ULL,
0x00000063ff19723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fc400030006ffULL,
0x00000063ff63723eULL, 0x000fc600030006ffULL, 0x000000183018723cULL, 0x040b70000000185cULL,
0x000000623030723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff4c7f8cULL, 0x020e64000c80043fULL,
0x00000000003e7805ULL, 0x000fc40000015200ULL, 0x0106bc00ff3d7984ULL, 0x000ea40000000800ULL,
0x800000003dff7812ULL, 0x006fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a3e477210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4a7824ULL, 0x000fe200000e0e3fULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3d7819ULL, 0x000fc8000001144aULL, 0x000000473d3d7211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e064aULL, 0x000000023d3d7819ULL, 0x000fc80000001247ULL,
0x0000003d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000058001c3d7a24ULL, 0x010fc800078e02ffULL,
0x000000403d3d7824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000080403e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107477824ULL, 0x000fe200078e0227ULL,
0x0000000227537810ULL, 0x040fe40007ffe0ffULL, 0x0000003e023f7217ULL, 0x000fe20007800000ULL,
0x0000004006507824ULL, 0x000fe200078e0247ULL, 0x0000000427557810ULL, 0x000fe20007ffe0ffULL,
0x00000001474a7824ULL, 0x000fe200078e0205ULL, 0x000000f021517812ULL, 0x000fe200078ec0ffULL,
0x0000001047527824ULL, 0x000fe200078e00ffULL, 0x0000003d504d7210ULL, 0x040fe20007f1e0ffULL,
0x0000000107477824ULL, 0x000fe200078e0253ULL, 0x00000002504f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013f3f7824ULL, 0x000fe200078e0a3eULL, 0xfffffff052527812ULL, 0x000fe200078ee24aULL,
0x00000001073e7824ULL, 0x000fe200078e0255ULL, 0x00000004504e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001474a7824ULL, 0x100fe200078e0205ULL, 0x0000003f073f7217ULL, 0x000fe20007800000ULL,
0x0000001047547824ULL, 0x000fe200078e00ffULL, 0x0000003d4e4e7210ULL, 0x000fe20007f7e0ffULL,
0x000000013e477824ULL, 0x000fe200078e0205ULL, 0x0000c00052527811ULL, 0x000fe200078e20ffULL,
0x000000103e567824ULL, 0x000fe200078e00ffULL, 0xfffffff054547812ULL, 0x000fe200078ee24aULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e004d4b7a11ULL, 0x000fc400078040ffULL,
0xfffffff056567812ULL, 0x000fe200078ee247ULL, 0x000000013f477824ULL, 0x000fe200078e0a07ULL,
0x00005f004d4d7a11ULL, 0x000fe200000f443eULL, 0x000000ffff3f7224ULL, 0x000fe200018e06ffULL,
0x0000003d4f4f7210ULL, 0x000fe40007f1e0ffULL, 0x000000472700720cULL, 0x000fe40003f86070ULL,
0x00005e004e4a7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff3e7224ULL, 0x000fe200000e06ffULL,
0x00005e004f4c7a11ULL, 0x000fc400078040ffULL, 0x00005f004e4e7a11ULL, 0x000fe400028f443fULL,
0x00005f004f4f7a11ULL, 0x000fe400000f443eULL, 0x000000514b3e7210ULL, 0x000fe40007f7e0ffULL,
0x000000475300720cULL, 0x000fe40003f06070ULL, 0x0000000627537810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e064dULL, 0x00000006504b7810ULL, 0x000fc40007ffe0ffULL,
0x000000475500720cULL, 0x000fe20003f66070ULL, 0x00000001074d7824ULL, 0x000fe200078e0253ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e527faeULL, 0x0003e2000e101c46ULL,
0x0000003d4b4b7210ULL, 0x000fe40007f9e0ffULL, 0x000000014d507824ULL, 0x000fe200078e0205ULL,
0x000000514a4a7210ULL, 0x000fe40007fde0ffULL, 0x0000c00054547811ULL, 0x000fe400078e20ffULL,
0x0000c00056567811ULL, 0x000fc400078e20ffULL, 0x000000514c3e7210ULL, 0x002fe20007fbe0ffULL,
0x000000104d527824ULL, 0x000fe400078e00ffULL, 0x000000ffff4d7224ULL, 0x000fe200020e06ffULL,
0x00005e004b4c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e064fULL,
0x000000475300720cULL, 0x000fe40003fa6070ULL, 0x00005f004b477a11ULL, 0x000fe200020f444dULL,
0x000000ffff4b7224ULL, 0x000fe200030e064eULL, 0x000000514c4c7210ULL, 0x000fe20007f9e0ffULL,
0x000000003e547faeULL, 0x0003e2000c101c46ULL, 0xfffffff052507812ULL, 0x000fc600078ee250ULL,
0x000000ffff4d7224ULL, 0x000fe200020e0647ULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x000000004a567faeULL, 0x0003e8000d901c46ULL, 0x000000004c507faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x00000001073e7824ULL, 0x000fe200078e0227ULL,
0x000000f0214e7812ULL, 0x000fc600078ec0ffULL, 0x000000013e3f7824ULL, 0x040fe200078e0205ULL,
0x000000023e477810ULL, 0x040fe20007ffe0ffULL, 0x000000103e4b7824ULL, 0x000fc800078e00ffULL,
0x00000001474a7824ULL, 0x000fe200078e0205ULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee23fULL,
0x0000001047507824ULL, 0x000fe200078e00ffULL, 0x000000043e477810ULL, 0x000fe20007ffe0ffULL,
0x00000040063f7824ULL, 0x000fe200078e023eULL, 0x0000c0004b4b7811ULL, 0x000fe400078e20ffULL,
0xfffffff050507812ULL, 0x000fe200078ee24aULL, 0x00000001474c7824ULL, 0x040fe200078e0205ULL,
0x000000063e4a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001047547824ULL, 0x000fe200078e00ffULL,
0x0000003d3f3e7210ULL, 0x000fc40007f1e0ffULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x000000014a4d7824ULL, 0x000fe200078e0205ULL, 0xfffffff054547812ULL, 0x000fe200078ee24cULL,
0x000000104a587824ULL, 0x000fe200078e00ffULL, 0x000000023f4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff477224ULL, 0x000fe200000e06ffULL, 0x00005e003e4a7a11ULL, 0x000fe400078040ffULL,
0xfffffff058587812ULL, 0x000fe400078ee24dULL, 0x00005f003e477a11ULL, 0x000fc400000f4447ULL,
0x000000043f3e7810ULL, 0x040fe40007ffe0ffULL, 0x000000063f3f7810ULL, 0x000fe40007ffe0ffULL,
0x0000003d4c4c7210ULL, 0x080fe40007f1e0ffULL, 0x0000003d3e517210ULL, 0x080fe40007f7e0ffULL,
0x0000003d3f557210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e06ffULL,
0x00005e004c4d7a11ULL, 0x000fe200078040ffULL, 0x000000ffff527224ULL, 0x000fe200018e06ffULL,
0x0000004e4a3e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff567224ULL, 0x000fe200028e06ffULL,
0x00005e0051537a11ULL, 0x000fc400078840ffULL, 0x00005e0055577a11ULL, 0x000fe400078a40ffULL,
0x00005f004c4f7a11ULL, 0x000fe200000f443fULL, 0x000000ffff3f7224ULL, 0x000fe200018e0647ULL,
0x0000004e4d4a7210ULL, 0x080fe40007f1e0ffULL, 0x00005f0051527a11ULL, 0x000fe400020f4452ULL,
0x0000004e534c7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e4b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0055567a11ULL, 0x000fc400028f4456ULL,
0x0000004e574e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff4d7224ULL, 0x000fe200018e0652ULL,
0x0000c00054547811ULL, 0x000fe400078e20ffULL, 0x0000c00058587811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x002fe400000e064fULL, 0x000000ffff4f7224ULL, 0x000fc600020e0656ULL,
0x000000004a507faeULL, 0x0003e8000b901c46ULL, 0x000000004c547faeULL, 0x0003e8000b901c46ULL,
0x000000004e587faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff3e7f8cULL, 0x000e64000c80043fULL,
0x000000ffff477224ULL, 0x002fc400078e003fULL, 0x00000000003e7805ULL, 0x000fca0000015200ULL,
0x0106b400ff4a7984ULL, 0x000e640000000800ULL, 0x800000004aff7812ULL, 0x002fc40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a3e4c7210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4b7824ULL, 0x000fe200000e0e3fULL, 0x003d09004c00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404c00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff4a7819ULL, 0x000fc8000001144bULL,
0x0000004c4a4a7211ULL, 0x000fca00078110ffULL, 0x000000ffff4b7224ULL, 0x000fca00000e064bULL,
0x000000024a4a7819ULL, 0x000fc8000000124bULL, 0x0000004a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014d4d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff4a7984ULL, 0x000e640000000800ULL,
0x800000004aff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000024ff25723eULL, 0x000fe400000000ffULL, 0x00000002ff497819ULL, 0x000fe40000011605ULL,
0x0000541025487816ULL, 0x000fe20000000025ULL, 0x000094627f007947ULL, 0x000fea000b800000ULL,
0x00001f4948257589ULL, 0x0002a400000e0000ULL, 0x0000000849267810ULL, 0x000fe20007ffe0ffULL,
0x000094927f007947ULL, 0x000fea000b800000ULL, 0x00001f2648267589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010493f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0048ULL, 0x0000a090003e7802ULL, 0x000fc40000000f00ULL,
0x00009c4000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018493f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x004fe200078e0048ULL,
0x0000a0e0003e7802ULL, 0x000fc40000000f00ULL, 0x00009bf000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b00041487811ULL, 0x00afe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000424c783bULL, 0x004e680000004200ULL,
0x000000004848783bULL, 0x000ea80000000200ULL, 0x000000004350783bULL, 0x000ee80000004200ULL,
0x000000004660783bULL, 0x000f220000004200ULL, 0x000031204e4e7816ULL, 0x002fc400000000ffULL,
0x000031204f4f7816ULL, 0x000fe400000000ffULL, 0x000031204c4c7816ULL, 0x000fe200000000ffULL,
0x000000254848a232ULL, 0x084fe20000000000ULL, 0x000031204d4d7816ULL, 0x000fe200000000ffULL,
0x000000254a4aa232ULL, 0x000fe20000000000ULL, 0x0000004eff58723eULL, 0x000fe200020006ffULL,
0x000000264949a232ULL, 0x080fe20000000000ULL, 0x0000004fff59723eULL, 0x000fe200020006ffULL,
0x000000264b4ba232ULL, 0x000fe20000000000ULL, 0x0000004cff54723eULL, 0x000fc400030006ffULL,
0x0000004dff55723eULL, 0x080fe400030006ffULL, 0x0000004cff3e723eULL, 0x000fe400020006ffULL,
0x0000b000444c7811ULL, 0x000fe200078e20ffULL, 0x000000584858723cULL, 0x000be20000001838ULL,
0x0000004dff3f723eULL, 0x000fe200020006ffULL, 0x000000004538783bULL, 0x020e620000004200ULL,
0x0000312050507816ULL, 0x008fe400000000ffULL, 0x0000312051517816ULL, 0x000fc400000000ffULL,
0x0000312060607816ULL, 0x010fe200000000ffULL, 0x000000544854723cULL, 0x000be20000001834ULL,
0x0000312061617816ULL, 0x000fe400000000ffULL, 0x0000312062627816ULL, 0x000fc800000000ffULL,
0x0000004eff34723eULL, 0x020fe200030006ffULL, 0x0000003e4810723cULL, 0x040fe20000001810ULL,
0x0000004fff35723eULL, 0x000fe400030006ffULL, 0x000000004c4c783bULL, 0x000eaa0000000200ULL,
0x000000344808723cULL, 0x000bee0000001808ULL, 0x00000050ff34723eULL, 0x020fc400020006ffULL,
0x00000051ff35723eULL, 0x080fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400030006ffULL,
0x00000051ff51723eULL, 0x000fc600030006ffULL, 0x00000034480c723cULL, 0x000b62000000180cULL,
0x0000312038387816ULL, 0x002fe400000000ffULL, 0x0000312039397816ULL, 0x000fc800000000ffULL,
0x0000312052347816ULL, 0x020fe400000000ffULL, 0x0000312053357816ULL, 0x000fe400000000ffULL,
0x00000034ff5c723eULL, 0x080fe200020006ffULL, 0x000000504850723cULL, 0x000be20000001814ULL,
0x00000035ff5d723eULL, 0x080fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fe200030006ffULL, 0x000000254c4ca232ULL, 0x004fc40000000000ULL,
0x0000005c485c723cULL, 0x000f620000001818ULL, 0x000000254e4ea232ULL, 0x000fe20000000000ULL,
0x00000060ff14723eULL, 0x020fe200020006ffULL, 0x000000264d4da232ULL, 0x080fe20000000000ULL,
0x00000061ff15723eULL, 0x000fe200020006ffULL, 0x000000264f4fa232ULL, 0x000fc60000000000ULL,
0x000000344848723cULL, 0x000b6e0000001830ULL, 0x00000038ff34723eULL, 0x0a0fe200020006ffULL,
0x000000144c14723cULL, 0x000b62000000180cULL, 0x00000039ff35723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fc400030006ffULL, 0x00000039ff39723eULL, 0x000fe400030006ffULL,
0x00000062ff0c723eULL, 0x020fe200020006ffULL, 0x000000344c34723cULL, 0x000b6e0000001810ULL,
0x000031203a107816ULL, 0x020fc400000000ffULL, 0x000031203b117816ULL, 0x000fe400000000ffULL,
0x00000010ff30723eULL, 0x080fe200020006ffULL, 0x000000384c38723cULL, 0x000f620000001854ULL,
0x00000011ff31723eULL, 0x080fe400020006ffULL, 0x00000010ff10723eULL, 0x000fe400030006ffULL,
0x00000011ff11723eULL, 0x000fc600030006ffULL, 0x000000304c30723cULL, 0x040f700000001858ULL,
0x000000104c18723cULL, 0x000b6e0000001808ULL, 0x0000312063097816ULL, 0x020fc400000000ffULL,
0x00000060ff10723eULL, 0x000fe400030006ffULL, 0x00000009ff0d723eULL, 0x000fe400020006ffULL,
0x00000061ff11723eULL, 0x000fe400030006ffULL, 0x00000062ff08723eULL, 0x000fe400030006ffULL,
0x00000009ff09723eULL, 0x000fe200030006ffULL, 0x0000000c4c0c723cULL, 0x040b70000000185cULL,
0x000000104c10723cULL, 0x040b700000001850ULL, 0x000000084c08723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000080403e7810ULL, 0x002fe20007ffe0ffULL, 0x01069800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4a7224ULL, 0x020fe200078e003fULL, 0x0000000320487810ULL, 0x000fc40007ffe0ffULL,
0x000000023e00720cULL, 0x000fda0003f06070ULL, 0x0000305000000947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fc40000015200ULL, 0x0106bc00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x000000483e487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e3fULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011449ULL, 0x000000481c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x000000021c1c7819ULL, 0x000fc80000001248ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000a0401c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001073f7824ULL, 0x000fe200078e0227ULL,
0x0000000227497810ULL, 0x000fe40007ffe0ffULL, 0x0000001c023e7217ULL, 0x000fe20007800000ULL,
0x000000013f487824ULL, 0x000fe200078e0205ULL, 0x00000004274c7810ULL, 0x000fe20007ffe0ffULL,
0x000000103f517824ULL, 0x000fe200078e00ffULL, 0x0000000627547810ULL, 0x000fe20007ffe0ffULL,
0x000000013e3e7824ULL, 0x000fe200078e0a1cULL, 0x00000020061c7811ULL, 0x000fe200078e30ffULL,
0x00000001074a7824ULL, 0x000fe200078e0249ULL, 0xfffffff051517812ULL, 0x000fe200078ee248ULL,
0x00000001074b7824ULL, 0x040fe200078e024cULL, 0x0000003e073e7217ULL, 0x000fe20007800000ULL,
0x000000013f4f7824ULL, 0x000fe200078e021cULL, 0x000000f021507812ULL, 0x000fe200078ec0ffULL,
0x00000001073f7824ULL, 0x000fe200078e0254ULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000014a4e7824ULL, 0x000fe200078e021cULL, 0x0000003d4f4f7210ULL, 0x000fe20007f1e0ffULL,
0x000000014b4d7824ULL, 0x000fc400078e0205ULL, 0x000000104b537824ULL, 0x000fe200078e00ffULL,
0x0000003d4e4e7210ULL, 0x080fe20007f3e0ffULL, 0x000000014a487824ULL, 0x040fe400078e0205ULL,
0x000000104a527824ULL, 0x000fe200078e00ffULL, 0xfffffff053537812ULL, 0x000fe200078ee24dULL,
0x000000014b4b7824ULL, 0x100fe200078e021cULL, 0x00005e004e4d7a11ULL, 0x000fe200078440ffULL,
0x000000013f1c7824ULL, 0x040fe200078e021cULL, 0xfffffff052527812ULL, 0x000fe200078ee248ULL,
0x000000013f487824ULL, 0x000fe200078e0205ULL, 0x0000003d4b4b7210ULL, 0x080fe20007f9e0ffULL,
0x000000103f557824ULL, 0x000fe200078e00ffULL, 0x0000003d1c3d7210ULL, 0x000fe20007f7e0ffULL,
0x000000013e1c7824ULL, 0x000fe200078e0a07ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff3e7224ULL, 0x000fe200008e06ffULL, 0xfffffff055557812ULL, 0x000fe200078ee248ULL,
0x000000ffff487224ULL, 0x000fe200000e06ffULL, 0x00005e004f3f7a11ULL, 0x000fc400078040ffULL,
0x00005f004e4e7a11ULL, 0x000fe400010f443eULL, 0x0000001c2700720cULL, 0x000fe40003f46070ULL,
0x00005f004f4f7a11ULL, 0x000fe200000f4448ULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x000000503f3e7210ULL, 0x000fe40007fbe0ffULL, 0x0000001c4c00720cULL, 0x080fe20003f06070ULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000001c4900720cULL, 0x000fe20003f26070ULL,
0x000000ffff3f7224ULL, 0x000fe200028e064fULL, 0x00005e004b497a11ULL, 0x000fc400078840ffULL,
0x00005e003d4a7a11ULL, 0x000fe400078c40ffULL, 0x0000001c5400720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e517faeULL, 0x0003e2000d101c46ULL,
0x00005f004b4b7a11ULL, 0x000fe400020f444cULL, 0x00005f003d1c7a11ULL, 0x000fe400030f4448ULL,
0x0000005049487210ULL, 0x080fe40007f9e0ffULL, 0x000000504a4a7210ULL, 0x000fc40007fbe0ffULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200020e064bULL,
0x0000e00055557811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe200028e061cULL,
0x000000504d3e7210ULL, 0x002fca0007f5e0ffULL, 0x000000ffff3f7224ULL, 0x000fca00010e064eULL,
0x000000003e527faeULL, 0x0003e8000c901c46ULL, 0x0000000048537faeULL, 0x0003e8000c101c46ULL,
0x000000004a557faeULL, 0x0003e2000d901c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x00000001071c7824ULL, 0x000fe200078e0227ULL, 0x00000020063e7811ULL, 0x000fc400078e30ffULL,
0x000000f0214f7812ULL, 0x000fe200078ec0ffULL, 0x000000011c3f7824ULL, 0x040fe200078e0205ULL,
0x000000021c487810ULL, 0x040fe20007ffe0ffULL, 0x000000101c507824ULL, 0x040fe200078e00ffULL,
0x000000061c4a7810ULL, 0x000fc60007ffe0ffULL, 0x0000000148497824ULL, 0x000fe200078e0205ULL,
0xfffffff050507812ULL, 0x000fe200078ee23fULL, 0x0000001048517824ULL, 0x000fe400078e00ffULL,
0x000000011c3f7824ULL, 0x000fe200078e023eULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000013e4b7824ULL, 0x040fe200078e0248ULL, 0xfffffff051517812ULL, 0x000fe200078ee249ULL,
0x000000013e4d7824ULL, 0x000fe200078e024aULL, 0x000000041c497810ULL, 0x000fe20007ffe0ffULL,
0x000000014a4e7824ULL, 0x040fe200078e0205ULL, 0x0000003d3f3f7210ULL, 0x080fe20007f5e0ffULL,
0x000000104a537824ULL, 0x000fe200078e00ffULL, 0x0000003d4b4b7210ULL, 0x080fe20007f1e0ffULL,
0x000000013e1c7824ULL, 0x000fe200078e0249ULL, 0x00005e003f4c7a11ULL, 0x000fe200078640ffULL,
0x0000000149487824ULL, 0x000fe200078e0205ULL, 0xfffffff053537812ULL, 0x000fe200078ee24eULL,
0x0000001049527824ULL, 0x000fe200078e00ffULL, 0x0000003d1c497210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x0000003d4d1c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200000e06ffULL, 0xfffffff052527812ULL, 0x000fc400078ee248ULL,
0x00005f003f4e7a11ULL, 0x000fe200018f443eULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x00005e004b3f7a11ULL, 0x000fe200078040ffULL, 0x000000ffff3d7224ULL, 0x000fe200010e06ffULL,
0x00005e0049487a11ULL, 0x000fe400078240ffULL, 0x00005e001c4a7a11ULL, 0x000fe400078440ffULL,
0x0000004f4c4c7210ULL, 0x000fe40007f7e0ffULL, 0x00005f004b4b7a11ULL, 0x000fc400000f444dULL,
0x00005f0049497a11ULL, 0x000fe200008f443eULL, 0x000000ffff4d7224ULL, 0x000fe200018e064eULL,
0x0000004f3f3e7210ULL, 0x080fe40007f1e0ffULL, 0x00005f001c1c7a11ULL, 0x000fe400010f443dULL,
0x0000004f48487210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e064bULL,
0x0000004f4a4a7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c507faeULL, 0x0003e2000b901c46ULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200008e0649ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200010e061cULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000003e517faeULL, 0x0003e8000b901c46ULL, 0x0000000048527faeULL, 0x0003e8000b901c46ULL,
0x000000004a537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000004203e7810ULL, 0x002fc80007ffe0ffULL, 0x000000033e00720cULL, 0x000fe20003f06070ULL,
0xffffffffff1c7424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000011e3e7824ULL, 0x000fe400078e023eULL, 0x00000004ff3f7424ULL, 0x000fc800078e00ffULL,
0x000060003e3e7625ULL, 0x000fca00078e003fULL, 0x000000063e1c7981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff487f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01066800074c7f8cULL, 0x000664000c80043fULL,
0x00000000003e7805ULL, 0x002fc40000015200ULL, 0x01066c00073d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a3e4a7210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4b7824ULL, 0x000fe200000e0e3fULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3d7819ULL, 0x000fc8000001144bULL, 0x0000004a3d3d7211ULL, 0x000fca00078110ffULL,
0x000000ffff4a7224ULL, 0x000fca00000e064bULL, 0x000000023d3d7819ULL, 0x000fc8000000124aULL,
0x0000003d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01066c00073d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01018000283d7984ULL, 0x000e680000000800ULL,
0x01038000284a7984ULL, 0x0006a20000000800ULL, 0x0000003c3d00720bULL, 0x002fe20003f1d000ULL,
0x00007ff27f007947ULL, 0x000fd8000b800000ULL, 0x00000000004b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff4bff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4c7424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f05270ULL, 0x0000003c3d00720bULL, 0x000fe20003f34000ULL,
0x00007fc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000297806ULL, 0x000fc400008e0100ULL,
0x0000003c3d3e8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0105803e28008388ULL, 0x0003e40000000800ULL, 0x0000991029287816ULL, 0x002fc800000000ffULL,
0x000000ff2800720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000003c3d287209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff29ff7812ULL, 0x000fc6000780c0ffULL, 0x0000003c28287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x00000028004d7308ULL, 0x000e640000000800ULL,
0x0000004d1d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff287819ULL, 0x000fe20000011605ULL, 0x00007f027f007947ULL, 0x000fea000b800000ULL,
0x00001f284d287589ULL, 0x0002e400000e0000ULL, 0x0000002834347220ULL, 0x088fe20000410000ULL,
0x0000002835357220ULL, 0x080fe20000410000ULL, 0x0000002838387220ULL, 0x080fe20000410000ULL,
0x0000002839397220ULL, 0x080fe20000410000ULL, 0x0000002830307220ULL, 0x080fe20000410000ULL,
0x0000002831317220ULL, 0x080fe20000410000ULL, 0x0000002818187220ULL, 0x080fe20000410000ULL,
0x0000002819197220ULL, 0x080fe20000410000ULL, 0x0000002814147220ULL, 0x080fe20000410000ULL,
0x0000002815157220ULL, 0x080fe20000410000ULL, 0x0000002810107220ULL, 0x080fe20000410000ULL,
0x0000002811117220ULL, 0x080fe20000410000ULL, 0x000000280c0c7220ULL, 0x080fe20000410000ULL,
0x000000280d0d7220ULL, 0x080fe20000410000ULL, 0x0000002808087220ULL, 0x080fe20000410000ULL,
0x0000002809097220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0029ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000805287811ULL, 0x000fe200078ff0ffULL, 0x00007e027f007947ULL, 0x000fea000b800000ULL,
0x00001f284d287589ULL, 0x00066400000e0000ULL, 0x0000002836367220ULL, 0x082fe20000410000ULL,
0x0000002837377220ULL, 0x080fe20000410000ULL, 0x000000283a3a7220ULL, 0x080fe20000410000ULL,
0x000000283b3b7220ULL, 0x080fe20000410000ULL, 0x0000002832327220ULL, 0x080fe20000410000ULL,
0x0000002833337220ULL, 0x080fe20000410000ULL, 0x000000281a1a7220ULL, 0x080fe20000410000ULL,
0x000000281b1b7220ULL, 0x080fe20000410000ULL, 0x0000002816167220ULL, 0x080fe20000410000ULL,
0x0000002817177220ULL, 0x080fe20000410000ULL, 0x0000002812127220ULL, 0x080fe20000410000ULL,
0x0000002813137220ULL, 0x080fe20000410000ULL, 0x000000280e0e7220ULL, 0x080fe20000410000ULL,
0x000000280f0f7220ULL, 0x080fe20000410000ULL, 0x000000280a0a7220ULL, 0x080fe20000410000ULL,
0x000000280b0b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff29ff7812ULL, 0x000fe2000780084bULL, 0x00000001ff4c7424ULL, 0x000fe200078e00ffULL,
0x0000003c3d3c7209ULL, 0x000fd60007810000ULL, 0x8000003c3d3d0221ULL, 0x000fe20000010000ULL,
0x00007610ff4c0816ULL, 0x000fc6000000004cULL, 0x3fb8aa3b3d3d0820ULL, 0x000fc80000410000ULL,
0x0000003d00240308ULL, 0x000e640000000800ULL, 0x000000244a4a0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001d4a1d7221ULL, 0x004fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e283e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e29ULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3d7819ULL, 0x000fc8000001143fULL, 0x0000003e3d3d7211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x000000023d3d7819ULL, 0x000fc8000000123eULL,
0x0000003d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104c287816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2800720cULL, 0x000fda0003f25270ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000024ff25723eULL, 0x000fe400000000ffULL,
0x00000002ff297819ULL, 0x000fe40000011605ULL, 0x0000541025287816ULL, 0x000fe20000000025ULL,
0x000079f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2928257589ULL, 0x0002a400000e0000ULL,
0x0000000829267810ULL, 0x000fe20007ffe0ffULL, 0x00007a227f007947ULL, 0x000fea000b800000ULL,
0x00001f2628267589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010293f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0028ULL,
0x0000bd20003e7802ULL, 0x000fc40000000f00ULL, 0x00007fb000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018293f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e0028ULL, 0x0000bd70003e7802ULL, 0x000fc40000000f00ULL,
0x00007f6000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000b8002a2a7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002b50783bULL, 0x000e620000004200ULL, 0x0000b8002d2d7811ULL, 0x000fc600078e20ffULL,
0x000000002a4c783bULL, 0x00cea80000000200ULL, 0x000000002c28783bULL, 0x0022e80000004200ULL,
0x000000002e54783bULL, 0x000e680000004200ULL, 0x000000002f58783bULL, 0x000ee20000004200ULL,
0x0000312050507816ULL, 0x000fc400000000ffULL, 0x0000312051517816ULL, 0x000fe200000000ffULL,
0x000000254c4c9232ULL, 0x084fe20000000000ULL, 0x00000050ff3e723eULL, 0x080fe200020006ffULL,
0x000000254e4e9232ULL, 0x000fe20000000000ULL, 0x00000051ff3f723eULL, 0x080fe200020006ffULL,
0x000000264d4d9232ULL, 0x080fe20000000000ULL, 0x00000050ff50723eULL, 0x000fe200030006ffULL,
0x000000264f4f9232ULL, 0x000fe20000000000ULL, 0x00000051ff51723eULL, 0x000fe400030006ffULL,
0x00003120522c7816ULL, 0x002fc400000000ffULL, 0x0000312028287816ULL, 0x008fe400000000ffULL,
0x0000003e4c34723cULL, 0x040be20000001834ULL, 0x0000312029297816ULL, 0x000fe400000000ffULL,
0x0000312056567816ULL, 0x000fe400000000ffULL, 0x0000312057577816ULL, 0x000fe400000000ffULL,
0x00003120533f7816ULL, 0x020fe200000000ffULL, 0x000000504c38723cULL, 0x000be20000001838ULL,
0x0000002cff3e723eULL, 0x000fc400030006ffULL, 0x0000312058587816ULL, 0x000fe400000000ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x0000002cff50723eULL, 0x020fe400020006ffULL,
0x0000003fff51723eULL, 0x000fe400020006ffULL, 0x00000028ff2c723eULL, 0x080fe400020006ffULL,
0x00000028ff28723eULL, 0x000fc400030006ffULL, 0x0000003fff3f723eULL, 0x000fe200030006ffULL,
0x000000504c50723cULL, 0x000b620000001830ULL, 0x0000312054547816ULL, 0x000fe200000000ffULL,
0x000000002d30783bULL, 0x0202a20000000200ULL, 0x000031205a5a7816ULL, 0x000fe400000000ffULL,
0x000031205b5b7816ULL, 0x000fc600000000ffULL, 0x0000003e4c18723cULL, 0x000fe20000001818ULL,
0x00000029ff2d723eULL, 0x082fe400020006ffULL, 0x00000029ff29723eULL, 0x000fca00030006ffULL,
0x0000002c4c14723cULL, 0x040b6e0000001814ULL, 0x000031202a2c7816ULL, 0x020fe200000000ffULL,
0x000000284c10723cULL, 0x000b620000001810ULL, 0x000031202b2d7816ULL, 0x000fcc00000000ffULL,
0x0000002cff28723eULL, 0x0a0fe400020006ffULL, 0x0000002dff29723eULL, 0x080fe400020006ffULL,
0x0000002cff2c723eULL, 0x000fe400030006ffULL, 0x0000002dff2d723eULL, 0x000fc600030006ffULL,
0x000000284c28723cULL, 0x040b62000000180cULL, 0x0000002530309232ULL, 0x084fe40000000000ULL,
0x0000002532329232ULL, 0x000fe40000000000ULL, 0x0000002631319232ULL, 0x080fe40000000000ULL,
0x0000002633339232ULL, 0x000fe20000000000ULL, 0x0000002c4c4c723cULL, 0x000b640000001808ULL,
0x00003120550d7816ULL, 0x020fc400000000ffULL, 0x00000054ff0c723eULL, 0x000fc600030006ffULL,
0x00000056ff2c723eULL, 0x000fe400020006ffULL, 0x00000057ff2d723eULL, 0x000fe400020006ffULL,
0x0000000dff09723eULL, 0x080fe400020006ffULL, 0x00000054ff08723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe200030006ffULL, 0x0000002c3050723cULL, 0x000b620000001850ULL,
0x00000056ff56723eULL, 0x000fc400030006ffULL, 0x00000057ff57723eULL, 0x000fc800030006ffULL,
0x00000058ff2c723eULL, 0x0a0fe200020006ffULL, 0x000000083008723cULL, 0x000f620000001834ULL,
0x00000059ff2d723eULL, 0x080fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400030006ffULL,
0x00000059ff59723eULL, 0x000fc600030006ffULL, 0x0000002c3014723cULL, 0x040b6e0000001814ULL,
0x0000005aff2c723eULL, 0x0a0fe200020006ffULL, 0x0000000c300c723cULL, 0x000b620000001838ULL,
0x0000005bff2d723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fc400030006ffULL,
0x0000005bff5b723eULL, 0x000fc600030006ffULL, 0x000000563018723cULL, 0x040b700000001818ULL,
0x000000583010723cULL, 0x040b700000001810ULL, 0x0000002c3028723cULL, 0x040b700000001828ULL,
0x0000005a3030723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff347f8cULL, 0x000e64000c80043fULL,
0x00000000002c7805ULL, 0x020fc40000015200ULL, 0x0106bc00ff2e7984ULL, 0x000ea40000000800ULL,
0x800000002eff7812ULL, 0x006fc40007804835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff377224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c367210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000362e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000137377810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000021f2c7810ULL, 0x000fc80007ffe0ffULL,
0x000000042c00720cULL, 0x000fe20003f06070ULL, 0x000058001c2c7a24ULL, 0x010fc800078e02ffULL,
0x000000402c2f7824ULL, 0x000fd000078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x00000001072d7824ULL, 0x000fe200078e0227ULL, 0x000000c040407810ULL, 0x000fe40007ffe0ffULL,
0x00000002273b7810ULL, 0x000fe20007ffe0ffULL, 0x000000012d2e7824ULL, 0x040fe200078e0205ULL,
0x00000040022c7217ULL, 0x000fe20007800000ULL, 0x000000102d3a7824ULL, 0x000fe200078e00ffULL,
0x00000004273e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107347824ULL, 0x000fe400078e023bULL,
0x000000012c2c7824ULL, 0x000fe200078e0a40ULL, 0xfffffff03a3a7812ULL, 0x000fe200078ee22eULL,
0x00000001342e7824ULL, 0x040fe200078e0205ULL, 0x0000000627407810ULL, 0x000fe20007ffe0ffULL,
0x00000010343d7824ULL, 0x000fe200078e00ffULL, 0x0000002c072c7217ULL, 0x040fe20007800000ULL,
0x00000040062d7824ULL, 0x000fe200078e022dULL, 0x0000c0003a3a7811ULL, 0x000fe200078e20ffULL,
0x0000000107357824ULL, 0x000fe200078e023eULL, 0xfffffff03d3d7812ULL, 0x000fe200078ee22eULL,
0x00000001072e7824ULL, 0x000fe200078e0240ULL, 0x0000002f2d387210ULL, 0x080fe20007f1e0ffULL,
0x0000000135347824ULL, 0x100fe200078e0205ULL, 0x000000022d377810ULL, 0x000fe20007ffe0ffULL,
0x00000010353f7824ULL, 0x000fe200078e00ffULL, 0x000000042d357810ULL, 0x040fe20007ffe0ffULL,
0x000000012e397824ULL, 0x040fe200078e0205ULL, 0x000000062d367810ULL, 0x000fe20007ffe0ffULL,
0x000000102e477824ULL, 0x000fe200078e00ffULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee234ULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x0000002f35357210ULL, 0x000fe20007f7e0ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0a07ULL, 0x00005e0038347a11ULL, 0x000fc400078440ffULL,
0x0000002f37377210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00005f0038387a11ULL, 0x000fe400010f442dULL, 0x0000002e2700720cULL, 0x000fe20003f46070ULL,
0x000000ffff2d7224ULL, 0x000fe200020e06ffULL, 0xfffffff047477812ULL, 0x000fe400078ee239ULL,
0x00005e0035277a11ULL, 0x000fe400078640ffULL, 0x000000f021397812ULL, 0x000fc400078ec0ffULL,
0x0000002f362f7210ULL, 0x000fe40007f1e0ffULL, 0x00005f0035357a11ULL, 0x000fe400018f442cULL,
0x00005e0037367a11ULL, 0x040fe200078840ffULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0x00000039342c7210ULL, 0x000fe40007fbe0ffULL, 0x00005f0037377a11ULL, 0x000fe400020f442dULL,
0x0000002e3b00720cULL, 0x080fe20003f86070ULL, 0x000000ffff2d7224ULL, 0x000fe200028e0638ULL,
0x0000002e3e00720cULL, 0x000fc40003f66070ULL, 0x0000002e4000720cULL, 0x000fe40003f06070ULL,
0x00005e002f347a11ULL, 0x040fe200078c40ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c3a7faeULL, 0x0003e2000d101c46ULL, 0x00000039362e7210ULL, 0x080fe40007fbe0ffULL,
0x00005f002f217a11ULL, 0x000fe400030f4421ULL, 0x0000c0003d3d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff2f7224ULL, 0x000fe200028e0637ULL, 0x0000003934347210ULL, 0x000fc40007fbe0ffULL,
0x0000c0003f3f7811ULL, 0x000fe400078e20ffULL, 0x0000c00047477811ULL, 0x000fe200078e20ffULL,
0x000000002e3d7faeULL, 0x0005e2000e101c46ULL, 0x00000039272c7210ULL, 0x002fca0007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe400010e0635ULL, 0x000000ffff357224ULL, 0x000fc600028e0621ULL,
0x000000002c3f7faeULL, 0x0005e8000d901c46ULL, 0x0000000034477faeULL, 0x0005e2000c101c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000107277824ULL, 0x000fe200078e0227ULL,
0x000000f021217812ULL, 0x000fc600078ec0ffULL, 0x00000001272c7824ULL, 0x040fe200078e0205ULL,
0x00000002272d7810ULL, 0x040fe20007ffe0ffULL, 0x00000010272e7824ULL, 0x040fe200078e00ffULL,
0x0000000627367810ULL, 0x000fc60007ffe0ffULL, 0x000000012d347824ULL, 0x040fe200078e0205ULL,
0xfffffff02e2e7812ULL, 0x000fe200078ee22cULL, 0x000000102d377824ULL, 0x000fe400078e00ffULL,
0x00000040062c7824ULL, 0x000fe400078e0227ULL, 0x00000001363d7824ULL, 0x040fe200078e0205ULL,
0xfffffff037377812ULL, 0x000fe200078ee234ULL, 0x00000010363f7824ULL, 0x000fe200078e00ffULL,
0x0000000427347810ULL, 0x000fe40007ffe0ffULL, 0x0000002f2c277210ULL, 0x000fc40007f1e0ffULL,
0x000000022c2d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000134387824ULL, 0x000fe200078e0205ULL,
0x000000042c357810ULL, 0x000fe20007ffe0ffULL, 0x00000010343a7824ULL, 0x000fe200078e00ffULL,
0x000000062c397810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2c7224ULL, 0x000fe200000e06ffULL,
0x0000002f2d347210ULL, 0x080fe40007f5e0ffULL, 0x00005e00272d7a11ULL, 0x000fe400078040ffULL,
0x0000002f35367210ULL, 0x000fc40007f7e0ffULL, 0x0000002f393b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x00005f0027277a11ULL, 0x000fe400000f442cULL,
0x000000212d2c7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff03a3a7812ULL, 0x000fe200078ee238ULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee23dULL,
0x000000ffff3d7224ULL, 0x000fe200020e06ffULL, 0x00005e0034357a11ULL, 0x000fe200078440ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e0627ULL, 0x00005e0036397a11ULL, 0x000fc400078640ffULL,
0x00005e003b3e7a11ULL, 0x000fe400078840ffULL, 0x0000c0002e277811ULL, 0x000fe400078e20ffULL,
0x00005f00342f7a11ULL, 0x000fe400010f442fULL, 0x00000021352e7210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c277faeULL, 0x0003e2000b901c46ULL,
0x00005f0036387a11ULL, 0x000fe400018f4438ULL, 0x0000002139347210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200000e062fULL, 0x00005f003b3d7a11ULL, 0x000fc400020f443dULL,
0x000000213e367210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff357224ULL, 0x000fe200010e0638ULL,
0x0000c00037217811ULL, 0x000fe400078e20ffULL, 0x0000c0003a3a7811ULL, 0x000fe200078e20ffULL,
0x000000ffff377224ULL, 0x000fe200018e063dULL, 0x0000c0003f3f7811ULL, 0x000fe200078e20ffULL,
0x000000002e217faeULL, 0x0003e8000b901c46ULL, 0x00000000343a7faeULL, 0x0003e8000b901c46ULL,
0x00000000363f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff2c7f8cULL, 0x004e64000c80043fULL,
0x000000ffff477224ULL, 0x002fc400078e002dULL, 0x00000000002c7805ULL, 0x000fca0000015200ULL,
0x0106b400ff217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fc40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c277210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2e7824ULL, 0x000fe200000e0e2dULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff2e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff2e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc8000001142eULL,
0x0000002721217211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e062eULL,
0x0000000221217819ULL, 0x000fc80000001227ULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000024ff21723eULL, 0x000fe400000000ffULL, 0x00000002ff277819ULL, 0x000fe40000011605ULL,
0x0000541021217816ULL, 0x000fe20000000021ULL, 0x000066c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2721257589ULL, 0x0002a400000e0000ULL, 0x0000000827267810ULL, 0x000fe20007ffe0ffULL,
0x000066f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2621267589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010273f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0021ULL, 0x0000d110003e7802ULL, 0x000fc40000000f00ULL,
0x00006bc000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018273f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x004fe200078e0021ULL,
0x0000d160003e7802ULL, 0x000fc40000000f00ULL, 0x00006b7000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000b80041417811ULL, 0x000fe200078e20ffULL, 0x000000004234783bULL, 0x000f280000004200ULL,
0x00000000412c783bULL, 0x000ee80000000200ULL, 0x000000004340783bULL, 0x000ea80000004200ULL,
0x000000004538783bULL, 0x000e620000004200ULL, 0x0000312034347816ULL, 0x010fc400000000ffULL,
0x0000312035357816ULL, 0x000fe400000000ffULL, 0x00000034ff22723eULL, 0x080fe200020006ffULL,
0x000000252c2c9232ULL, 0x08cfe20000000000ULL, 0x00000035ff23723eULL, 0x080fe200020006ffULL,
0x000000252e2e9232ULL, 0x000fe20000000000ULL, 0x00000034ff34723eULL, 0x000fe200030006ffULL,
0x000000262d2d9232ULL, 0x082fe20000000000ULL, 0x00000035ff35723eULL, 0x000fe200030006ffULL,
0x000000262f2f9232ULL, 0x000fe20000000000ULL, 0x0000312040407816ULL, 0x000fc400000000ffULL,
0x0000312041417816ULL, 0x000fe400000000ffULL, 0x0000312036367816ULL, 0x000fe400000000ffULL,
0x000000342c4c723cULL, 0x040be2000000180cULL, 0x0000312037377816ULL, 0x000fe400000000ffULL,
0x0000312042427816ULL, 0x000fe400000000ffULL, 0x0000312043437816ULL, 0x000fe400000000ffULL,
0x00000040ff0c723eULL, 0x020fe200020006ffULL, 0x000000222c48723cULL, 0x000be20000001808ULL,
0x00000041ff0d723eULL, 0x000fc400020006ffULL, 0x00000040ff40723eULL, 0x000fe400030006ffULL,
0x00000041ff41723eULL, 0x000fe400030006ffULL, 0x00000036ff08723eULL, 0x0a0fe200020006ffULL,
0x0000000c2c54723cULL, 0x000be20000001814ULL, 0x00000037ff09723eULL, 0x080fe400020006ffULL,
0x00000036ff36723eULL, 0x000fe400030006ffULL, 0x00000037ff37723eULL, 0x000fc400030006ffULL,
0x00000042ff0c723eULL, 0x0a0fe200020006ffULL, 0x000000082c50723cULL, 0x040be20000001850ULL,
0x00000043ff0d723eULL, 0x080fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400030006ffULL,
0x00000043ff43723eULL, 0x000fe400030006ffULL, 0x0000b80044087811ULL, 0x020fe200078e20ffULL,
0x0000000c2c28723cULL, 0x000be20000001828ULL, 0x0000312038387816ULL, 0x000fe200000000ffULL,
0x00000000460c783bULL, 0x020e620000004200ULL, 0x0000312039397816ULL, 0x000fc400000000ffULL,
0x00000038ff34723eULL, 0x080fe200020006ffULL, 0x000000000808783bULL, 0x000ea20000000200ULL,
0x00000039ff35723eULL, 0x080fe200020006ffULL, 0x000000362c18723cULL, 0x000f620000001818ULL,
0x00000038ff38723eULL, 0x000fe400030006ffULL, 0x00000039ff39723eULL, 0x000fca00030006ffULL,
0x000000402c58723cULL, 0x040b6e0000001810ULL, 0x000031203a107816ULL, 0x020fe200000000ffULL,
0x000000422c2c723cULL, 0x000b620000001830ULL, 0x000031203b117816ULL, 0x000fcc00000000ffULL,
0x00000010ff30723eULL, 0x0a0fe400020006ffULL, 0x00000011ff31723eULL, 0x080fe400020006ffULL,
0x00000010ff10723eULL, 0x000fe400030006ffULL, 0x00000011ff11723eULL, 0x000fe400030006ffULL,
0x000031200c0c7816ULL, 0x002fe400000000ffULL, 0x000031200d0d7816ULL, 0x000fe200000000ffULL,
0x0000002508089232ULL, 0x084fe20000000000ULL, 0x0000000cff14723eULL, 0x080fe200020006ffULL,
0x000000250a0a9232ULL, 0x000fe20000000000ULL, 0x0000000dff15723eULL, 0x080fe200020006ffULL,
0x0000002609099232ULL, 0x080fe20000000000ULL, 0x0000000cff0c723eULL, 0x000fe200030006ffULL,
0x000000260b0b9232ULL, 0x000fe20000000000ULL, 0x0000000dff0d723eULL, 0x000fc400030006ffULL,
0x000031200e217816ULL, 0x000fe400000000ffULL, 0x000031200f237816ULL, 0x000fe400000000ffULL,
0x000000100818723cULL, 0x000f620000001818ULL, 0x00000021ff22723eULL, 0x000fce00030006ffULL,
0x0000000c0810723cULL, 0x040b6e0000001858ULL, 0x00000021ff0c723eULL, 0x020fe200020006ffULL,
0x000000340834723cULL, 0x000b620000001848ULL, 0x00000023ff0d723eULL, 0x080fe400020006ffULL,
0x00000023ff23723eULL, 0x000fca00030006ffULL, 0x000000380838723cULL, 0x040b70000000184cULL,
0x000000300830723cULL, 0x040b700000001850ULL, 0x000000140814723cULL, 0x040b700000001854ULL,
0x0000000c080c723cULL, 0x040b700000001828ULL, 0x000000220808723cULL, 0x000b62000000182cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff227f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x0000000420487810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x002fc400078e0023ULL, 0x000000011f1f7810ULL, 0x000fc80007ffe0ffULL,
0x000000041f00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff3a0000007947ULL, 0x000fea000383ffffULL, 0x000000ff0400720cULL, 0x000fe20003f05270ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0013ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0012ULL,
0x000000ffff267224ULL, 0x000fe400078e000bULL, 0x000000ffff257224ULL, 0x000fe400078e000aULL,
0x000000ffff247224ULL, 0x000fe400078e0009ULL, 0x000000ffff237224ULL, 0x008fc400078e0008ULL,
0x000000ffff227224ULL, 0x000fe400078e000fULL, 0x000000ffff217224ULL, 0x002fe400078e000eULL,
0x000000ffff207224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fe400078e000cULL,
0x000000ffff137224ULL, 0x000fe400078e0011ULL, 0x000000ffff127224ULL, 0x000fe200078e0010ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000001d027810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe200078e001dULL, 0x0000d91000057802ULL, 0x000fc40000000f00ULL,
0x000061e000007944ULL, 0x004fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001d00047308ULL, 0x000e640000001000ULL, 0xbf800000041d7423ULL, 0x002fc8000000001dULL,
0x800000ff1d1d7221ULL, 0x000fc80000010100ULL, 0x0000001d04047223ULL, 0x000fc40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006800ff027624ULL, 0x000fe400078e00ffULL,
0x00006900ff037624ULL, 0x000fca00078e00ffULL, 0x0000000602027981ULL, 0x0002e8000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff037819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000402027220ULL, 0x008fca0000410000ULL,
0x00001f0302037589ULL, 0x000e6800000e0000ULL, 0x00001f0502027589ULL, 0x000ee200000e0000ULL,
0x0000003403347220ULL, 0x042fe20000410000ULL, 0x0000003503357220ULL, 0x040fe20000410000ULL,
0x0000003803387220ULL, 0x040fe20000410000ULL, 0x0000003903397220ULL, 0x040fe20000410000ULL,
0x0000003003307220ULL, 0x040fe20000410000ULL, 0x0000003103317220ULL, 0x040fe20000410000ULL,
0x0000001803187220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001303137220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000002003207220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000002403247220ULL, 0x000fe20000410000ULL,
0x0000003602367220ULL, 0x048fe20000410000ULL, 0x0000003702377220ULL, 0x040fe20000410000ULL,
0x0000003a023a7220ULL, 0x040fe20000410000ULL, 0x0000003b023b7220ULL, 0x040fe20000410000ULL,
0x0000003202327220ULL, 0x040fe20000410000ULL, 0x0000003302337220ULL, 0x040fe20000410000ULL,
0x0000001a021a7220ULL, 0x040fe20000410000ULL, 0x0000001b021b7220ULL, 0x040fe20000410000ULL,
0x0000001602167220ULL, 0x040fe20000410000ULL, 0x0000001702177220ULL, 0x040fe20000410000ULL,
0x0000001c021c7220ULL, 0x040fe20000410000ULL, 0x0000001e021e7220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002202227220ULL, 0x040fe20000410000ULL,
0x0000002502257220ULL, 0x040fe20000410000ULL, 0x0000002602267220ULL, 0x000fc20000410000ULL,
0x00000000001d7919ULL, 0x000e620000000000ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff047819ULL, 0x002fc6000001161dULL,
0x00000005040472a4ULL, 0x008fe2000f8e023fULL, 0x000000021d027812ULL, 0x040fe400078ec0ffULL,
0x000000081d057811ULL, 0x000fe200078ff0ffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000000402037211ULL, 0x000fe200078ff8ffULL, 0x0000000804097824ULL, 0x000fe200078e00ffULL,
0x0000000502067211ULL, 0x000fe200078ff8ffULL, 0x00000008050a7824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x040fe20007ffe0ffULL, 0x00000008040b7824ULL, 0x040fe200078e00ffULL,
0x0000000403057810ULL, 0x000fe20007ffe0ffULL, 0x00000008040c7824ULL, 0x000fe200078e00ffULL,
0xfffffff808047812ULL, 0x000fc400078ee203ULL, 0x0000000603037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80a0a7812ULL, 0x000fe400078ee206ULL, 0xfffffff809067812ULL, 0x000fe400078ee202ULL,
0xfffffff80c097812ULL, 0x000fe200078ee203ULL, 0x000000081d037824ULL, 0x000fe200078e00ffULL,
0xfffffff80b087812ULL, 0x000fe400078ee205ULL, 0x0000a00000057811ULL, 0x000fc400078e58ffULL,
0x0000000803037812ULL, 0x000fe400078ec0ffULL, 0x000000343500723eULL, 0x000fe200000000ffULL,
0x0000001004047824ULL, 0x100fe200078e0205ULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x00000003ff0c7819ULL, 0x000fe2000001161dULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x0000541000107816ULL, 0x100fe20000000002ULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x0000763200117816ULL, 0x000fe20000000002ULL,
0x0000001008007824ULL, 0x100fe200078e0205ULL, 0x000000201d0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001009027824ULL, 0x000fc400078e0205ULL, 0x0000001004007388ULL, 0x0003e20000000a00ULL,
0x00000003ff0f7819ULL, 0x000fe2000001160eULL, 0x00000001030b7824ULL, 0x040fe400078e020aULL,
0x0000000103087824ULL, 0x040fe400078e0206ULL, 0x0000000103097824ULL, 0x000fe200078e0200ULL,
0x000000303100723eULL, 0x000fe200000000ffULL, 0x00000001030a7824ULL, 0x000fe200078e0202ULL,
0x000000181902723eULL, 0x000fe200000000ffULL, 0x000000010e0d7824ULL, 0x000fe200078e020fULL,
0x000000141503723eULL, 0x000fe200000000ffULL, 0x000000010c047824ULL, 0x002fc600078e021dULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0ffffff80d107812ULL, 0x000fe400078ef80eULL, 0x0ffffff804067812ULL, 0x000fe400078ef81dULL,
0x000000121304723eULL, 0x000fe200000000ffULL, 0x0000001010107824ULL, 0x100fe200078e0205ULL,
0x0000541000127816ULL, 0x100fe20000000002ULL, 0x00000010060d7824ULL, 0x000fe200078e0205ULL,
0x0000763200137816ULL, 0x000fc40000000002ULL, 0x0000541003027816ULL, 0x140fe40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0000001208007388ULL, 0x000fe20000000a00ULL,
0x0000001f2000723eULL, 0x000fe400000000ffULL, 0x0000003a3b04723eULL, 0x000fe200000000ffULL,
0x0000000209007388ULL, 0x0003e20000000a00ULL, 0x000000323305723eULL, 0x000fe400000000ffULL,
0x0000001a1b06723eULL, 0x000fc400000000ffULL, 0x000000071d1d7812ULL, 0x000fe400078ec0ffULL,
0x000000070e0e7812ULL, 0x000fc800078ec0ffULL, 0x1ffffff80e0e7812ULL, 0x000fe400078ef807ULL,
0x000000232402723eULL, 0x002fe400000000ffULL, 0x000000363703723eULL, 0x000fe400000000ffULL,
0x0000541000127816ULL, 0x140fe40000000002ULL, 0x0000763200137816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x000000120a007388ULL, 0x000fe20000000a00ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x000000020b007388ULL, 0x0003e20000000a00ULL,
0x000000161700723eULL, 0x000fc600000000ffULL, 0x0004000408007388ULL, 0x0007e20000000a00ULL,
0x0000001c1e02723eULL, 0x002fe400000000ffULL, 0x000000212203723eULL, 0x000fe200000000ffULL,
0x0000000000057919ULL, 0x008e620000002600ULL, 0x000000252604723eULL, 0x000fe400000000ffULL,
0x0000541000127816ULL, 0x140fe40000000002ULL, 0x0000763200137816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004001209007388ULL, 0x000fe80000000a00ULL, 0x000400020a007388ULL, 0x0007e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000000d087984ULL, 0x000f220000000c00ULL,
0x0000000805007824ULL, 0x002fc600078e00ffULL, 0x0000000010107984ULL, 0x000e620000000c00ULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0xfffffff8000c7812ULL, 0x000fc800078ee20cULL,
0xfffffff8050f7812ULL, 0x000fe400078ee20fULL, 0x000000040c0c7c10ULL, 0x000fe4000ff1e0ffULL,
0x000000040f0f7c10ULL, 0x000fc6000ff3e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005a000c027a11ULL, 0x048fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a000f047a11ULL, 0x000fe400078248ffULL, 0x00005b000c037a11ULL, 0x000fe400000f4c00ULL,
0x1ffffff81d007812ULL, 0x000fe400078ef807ULL, 0x00005b000f057a11ULL, 0x000fc600008f4c05ULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x000000100e047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x010fe8000c101d06ULL, 0x0000001004007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000030000720cULL, 0x000fe20003f06070ULL,
0xffffffffff077424ULL, 0x000fd800078e00ffULL, 0x000000021e088824ULL, 0x000fc800078e00ffULL,
0x0000640008088a24ULL, 0x000fc800078e0200ULL, 0x0000600008088625ULL, 0x000fe200078e001dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff2a7624ULL, 0x000fe200078e00ffULL,
0x0000000608078981ULL, 0x0002a2000c1e1900ULL, 0x00006900ff2b7624ULL, 0x000fca00078e00ffULL,
0x000000062a2a7981ULL, 0x000722000c1e9900ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004000287824ULL, 0x000fe200078e00ffULL,
0x01060000ff087f8cULL, 0x002e62000c80043fULL, 0x0000004006297824ULL, 0x000fc600078e00ffULL,
0x00000004071a7c24ULL, 0x004fcc000f8e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1b7819ULL, 0x00afe40000011605ULL, 0x000000300e197812ULL, 0x000fe400078ec0ffULL,
0x0000200000127811ULL, 0x000fe200078e68ffULL, 0x0000004006117824ULL, 0x000fca00078e021bULL,
0x0000000811067810ULL, 0x040fe40007ffe0ffULL, 0x00000010110a7810ULL, 0x040fe40007ffe0ffULL,
0x000000061a067210ULL, 0x040fe40007f3e0ffULL, 0x0000000a1a0a7210ULL, 0x040fe40007f5e0ffULL,
0x00000018110b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x000000111a137210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00005e00060c7a11ULL, 0x000fc400078240ffULL, 0x00005e000a0f7a11ULL, 0x000fe200078440ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x0000000b1a0b7210ULL, 0x000fe40007f7e0ffULL,
0x00005e00130d7a11ULL, 0x000fe400078040ffULL, 0x00005f0006187a11ULL, 0x000fe200008f4418ULL,
0x000000ffff177224ULL, 0x000fe200018e06ffULL, 0x00005f000a167a11ULL, 0x000fe400010f4416ULL,
0x00000005050a7211ULL, 0x000fc400078fe8ffULL, 0x0000002802067217ULL, 0x000fe40007800000ULL,
0x00005e000b157a11ULL, 0x000fe400078640ffULL, 0x00005f0013137a11ULL, 0x000fe200000f4410ULL,
0x0000000106067824ULL, 0x000fe200078e0a28ULL, 0x000000030a107812ULL, 0x000fe400078ec0ffULL,
0x000000081b0a7810ULL, 0x000fe40007ffe0ffULL, 0x00005f000b177a11ULL, 0x000fc400018f4417ULL,
0x000000101b0b7810ULL, 0x040fe20007ffe0ffULL, 0x000000040a0e7824ULL, 0x040fe200078e00ffULL,
0x000000061b00720cULL, 0x080fe40003f06070ULL, 0x000000060a00720cULL, 0x080fe20003f26070ULL,
0x000000040b147824ULL, 0x000fe200078e00ffULL, 0x0000000d190a7210ULL, 0x000fe40007f7e0ffULL,
0x0ffffffc10057812ULL, 0x000fe400078ef805ULL, 0x000000060b00720cULL, 0x000fe20003f46070ULL,
0x000000ffff0b7224ULL, 0x000fe200018e0613ULL, 0xfffffffc0e0d7812ULL, 0x000fe200078ee210ULL,
0x0000001005057824ULL, 0x000fe200078e0212ULL, 0x000000190c0c7210ULL, 0x000fc40007f7e0ffULL,
0xfffffffc14147812ULL, 0x000fe200078ee210ULL, 0x000000100d137824ULL, 0x000fe200078e0212ULL,
0x000000190f0e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e0618ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a057faeULL, 0x0003e2000c101c46ULL,
0x0000001014147824ULL, 0x000fe400078e0212ULL, 0x000000ffff0f7224ULL, 0x000fe200020e0616ULL,
0x000000000c137faeULL, 0x0005e8000c901c46ULL, 0x000000000e147faeULL, 0x0007e2000d101c46ULL,
0x000000181b0a7810ULL, 0x002fc40007ffe0ffULL, 0x0000002011057810ULL, 0x000fe40007ffe0ffULL,
0x000000060a00720cULL, 0x000fe40003f86070ULL, 0x000000051a167210ULL, 0x000fe20007f1e0ffULL,
0x000000040a0f7824ULL, 0x008fe200078e00ffULL, 0x00000019150a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e0016147a11ULL, 0x000fe400078c40ffULL,
0xfffffffc0f057812ULL, 0x000fe400078ee210ULL, 0x000000201b0c7810ULL, 0x044fe40007ffe0ffULL,
0x000000281b0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001005057824ULL, 0x000fe200078e0212ULL,
0x000000301b0e7810ULL, 0x040fe40007ffe0ffULL, 0x000000381b137810ULL, 0x000fc40007ffe0ffULL,
0x00005f0016167a11ULL, 0x000fe200030f440bULL, 0x000000ffff0b7224ULL, 0x000fe200028e0617ULL,
0x000000060c00720cULL, 0x080fe40003f66070ULL, 0x000000060d00720cULL, 0x080fe40003f46070ULL,
0x000000060e00720cULL, 0x080fe20003f26070ULL, 0x000000000a057faeULL, 0x0003e2000e101c46ULL,
0x000000061300720cULL, 0x040fe20003f06070ULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0000002811067810ULL, 0x000fc40007ffe0ffULL, 0x00000030110f7810ULL, 0x000fe40007ffe0ffULL,
0x000000061a157210ULL, 0x040fe20007fbe0ffULL, 0x000000040d067824ULL, 0x000fe200078e00ffULL,
0x0000003811117810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1a0f7210ULL, 0x000fe20007f9e0ffULL,
0x000000040e0a7824ULL, 0x002fe200078e00ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee210ULL,
0x000000040c057824ULL, 0x000fe200078e00ffULL, 0x000000111a117210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e06ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee210ULL,
0x0000001006067824ULL, 0x000fe200078e0212ULL, 0x00005e00150c7a11ULL, 0x000fe200078a40ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0xfffffffc05057812ULL, 0x000fc400078ee210ULL,
0xfffffffc13107812ULL, 0x000fe200078ee210ULL, 0x000000100a137824ULL, 0x100fe200078e0212ULL,
0x00005f0015157a11ULL, 0x000fe200028f440bULL, 0x0000001005057824ULL, 0x100fe200078e0212ULL,
0x00000019140a7210ULL, 0x080fe20007fbe0ffULL, 0x0000001010127824ULL, 0x000fe200078e0212ULL,
0x00005e0011107a11ULL, 0x000fe200078c40ffULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078840ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0616ULL,
0x000000190c0c7210ULL, 0x000fc40007fbe0ffULL, 0x00005f000f0f7a11ULL, 0x000fe400020f4414ULL,
0x00005f0011117a11ULL, 0x000fe200030f440dULL, 0x000000ffff0d7224ULL, 0x000fe200028e0615ULL,
0x000000190e0e7210ULL, 0x080fe20007f9e0ffULL, 0x000000000a057faeULL, 0x0003e2000d901c46ULL,
0x0000001910107210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e060fULL,
0x000000000c067faeULL, 0x0003e2000d101c46ULL, 0x000000ffff117224ULL, 0x000fc600028e0611ULL,
0x000000000e137faeULL, 0x0003e8000c901c46ULL, 0x0000000010127faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000002905067211ULL, 0x04afe400078ff0ffULL,
0x0000000805197811ULL, 0x040fe400078ff0ffULL, 0x000000061a067210ULL, 0x000fe40007f1e0ffULL,
0x00000010050a7811ULL, 0x000fc400078ff0ffULL, 0x00000018050c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x00005e0006267a11ULL, 0x040fe200078040ffULL,
0x00000001290b7824ULL, 0x000fe200078e020aULL, 0x0000000505187211ULL, 0x000fe200078fe8ffULL,
0x00000001290d7824ULL, 0x040fe200078e020cULL, 0x00005f0006277a11ULL, 0x000fe200000f4427ULL,
0x0000000129067824ULL, 0x000fe200078e0219ULL, 0x00000020050f7811ULL, 0x000fe200078ff0ffULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x0000002805117811ULL, 0x000fc400078ff0ffULL,
0x000000061a257210ULL, 0x000fe20007fde0ffULL, 0x000000040a067824ULL, 0x000fe200078e00ffULL,
0x0000000318187812ULL, 0x000fe200078ec0ffULL, 0x000000040c0a7824ULL, 0x000fe200078e00ffULL,
0x0000003005137811ULL, 0x000fe200078ff0ffULL, 0x0000000129107824ULL, 0x000fe200078e020fULL,
0x0000003805157811ULL, 0x000fe200078ff0ffULL, 0x0000000129127824ULL, 0x000fe200078e0211ULL,
0x0000000b1a177210ULL, 0x000fe20007fbe0ffULL, 0x000000040f0b7824ULL, 0x000fe200078e00ffULL,
0x00002000001d7811ULL, 0x000fe200078e68ffULL, 0x00000004110c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee218ULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x0000000d1a227210ULL, 0x040fe20007f1e0ffULL, 0x0000000129147824ULL, 0x000fe200078e0213ULL,
0x00005e0025247a11ULL, 0x000fe200078c40ffULL, 0x0000000129167824ULL, 0x000fe200078e0215ULL,
0x000000101a107210ULL, 0x000fe20007f3e0ffULL, 0x00000004130d7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc18137812ULL, 0x000fe200078ef805ULL, 0x00000004150f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b0b7812ULL, 0x100fe200078ee218ULL, 0x000000100a157824ULL, 0x000fe200078e021dULL,
0x00005f0025257a11ULL, 0x000fe200030f4411ULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x000000121a127210ULL, 0x040fe20007f5e0ffULL, 0x00000010132c7824ULL, 0x100fe200078e021dULL,
0x000000141a147210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x000000161a167210ULL, 0x000fe20007f9e0ffULL, 0x000000100b1a7824ULL, 0x100fe200078e021dULL,
0xfffffffc19057812ULL, 0x100fe200078ee218ULL, 0x000000ffff0b7224ULL, 0x000fe200028e06ffULL,
0xfffffffc06067812ULL, 0x100fe200078ee218ULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0xfffffffc0c0c7812ULL, 0x100fe200078ee218ULL, 0x0000001005057824ULL, 0x100fe200078e021dULL,
0xfffffffc0d0d7812ULL, 0x100fe200078ee218ULL, 0x0000001006067824ULL, 0x100fe200078e021dULL,
0x00005e0022117a11ULL, 0x000fe200078040ffULL, 0x000000100c1b7824ULL, 0x100fe200078e021dULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee218ULL, 0x000000100d1c7824ULL, 0x100fe200078e021dULL,
0x000000300e2b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e06ffULL,
0x00005e0010137a11ULL, 0x000fe200078240ffULL, 0x000000100f1d7824ULL, 0x000fe200078e021dULL,
0x00005e0017237a11ULL, 0x000fe200078a40ffULL, 0x000000ffff197224ULL, 0x000fe200020e06ffULL,
0x00005f0022227a11ULL, 0x000fc400000f440aULL, 0x000000262b0a7210ULL, 0x000fe40007f1e0ffULL,
0x00005f0010217a11ULL, 0x000fe400008f4421ULL, 0x00005f00170f7a11ULL, 0x000fe200028f440bULL,
0x000000ffff0b7224ULL, 0x000fe200000e0627ULL, 0x00005e00120d7a11ULL, 0x000fe400078240ffULL,
0x00005e0014177a11ULL, 0x000fe400078440ffULL, 0x00005f0012207a11ULL, 0x000fe200008f4420ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2c7faeULL, 0x0003e2000b901c46ULL,
0x000000242b0c7210ULL, 0x000fc40007f1e0ffULL, 0x00005f00141f7a11ULL, 0x000fe400010f441fULL,
0x000000232b0e7210ULL, 0x040fe40007f3e0ffULL, 0x00005e0016187a11ULL, 0x040fe400078640ffULL,
0x000000112b107210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000000d2b147210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0625ULL,
0x00005f0016197a11ULL, 0x000fe200018f4419ULL, 0x000000ffff117224ULL, 0x000fe200010e0622ULL,
0x000000132b127210ULL, 0x000fc40007f7e0ffULL, 0x000000172b167210ULL, 0x040fe20007fbe0ffULL,
0x000000000c057faeULL, 0x0003e2000b901c46ULL, 0x000000182b187210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe400018e0621ULL, 0x000000000e067faeULL, 0x0003e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fe400028e061fULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000000010157faeULL, 0x0005e8000b901c46ULL, 0x00000000121a7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff157224ULL, 0x004fca00020e0620ULL, 0x00000000141b7faeULL, 0x0003e8000b901c46ULL,
0x00000000161c7faeULL, 0x0003e8000b901c46ULL, 0x00000000181d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fc40000015200ULL,
0x01060400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a067210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e0bULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140cULL,
0x0000000605057211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e060cULL,
0x0000000205057819ULL, 0x000fc80000001206ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002000057824ULL, 0x002fca00078e0205ULL,
0x00000003ff067819ULL, 0x000fe40000011605ULL, 0x0000000f05057812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe06067812ULL, 0x000fe400078ec0ffULL, 0x0000000105087810ULL, 0x040fe20007ffe0ffULL,
0x00000020050c7824ULL, 0x040fe400078e00ffULL, 0x0000000105097824ULL, 0x040fe400078e0206ULL,
0x00000001060a7824ULL, 0x040fe200078e0208ULL, 0x0000001006067810ULL, 0x000fe20007ffe0ffULL,
0x00000020050b7824ULL, 0x000fe200078e00ffULL, 0x0000001f09097812ULL, 0x000fc400078ec0ffULL,
0x0000001f0a0a7812ULL, 0x000fe400078ec0ffULL, 0x000001e00b097812ULL, 0x000fe200078ee209ULL,
0x00000001050b7824ULL, 0x040fe200078e0206ULL, 0x000001e00c0a7812ULL, 0x000fe200078ee20aULL,
0x0000000108067824ULL, 0x000fe400078e0206ULL, 0x0000000009107984ULL, 0x000e62000000cc00ULL,
0x0000002005087824ULL, 0x000fe200078e00ffULL, 0x0000001f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000002005057824ULL, 0x000fe200078e00ffULL, 0x000000000a0c7984ULL, 0x000ea2000000cc00ULL,
0x0000001f06067812ULL, 0x000fc400078ec0ffULL, 0x000001e0080b7812ULL, 0x000fe400078ee20bULL,
0x000001e005067812ULL, 0x000fe200078ee206ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff177224ULL, 0x004fe400078e000eULL,
0x000000ffff167224ULL, 0x000fe400078e000cULL, 0x000000ffff0e7224ULL, 0x000fc400078e000dULL,
0x000000ffff0c7224ULL, 0x000fe200078e0011ULL, 0x0000001409007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff0d7224ULL, 0x000fca00078e0013ULL, 0x0000000c0a007388ULL, 0x000fe8000000cc00ULL,
0x00000000060c7984ULL, 0x000e68000000cc00ULL, 0x000000000b107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1b7224ULL, 0x002fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff187224ULL, 0x004fe400078e0010ULL,
0x000000ffff197224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x000000180b007388ULL, 0x0003e8000000cc00ULL,
0x0000000c06007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff0c7f8cULL, 0x002e62000c80043fULL, 0x000000ffff0e7224ULL, 0x000fc600078e00ffULL,
0x0000000000087805ULL, 0x000fc80000015200ULL, 0x01060400ff057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x006fc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08067210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e09ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140aULL,
0x0000000605057211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e060aULL,
0x0000000205057819ULL, 0x000fc80000001206ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x000064001e067a24ULL, 0x000fe200078e02ffULL,
0x3d8000002a2a7820ULL, 0x010fe20000410000ULL, 0x00010688002b7811ULL, 0x000fe200078e18ffULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0xffffffff042c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x00010608002d7811ULL, 0x000fe200078e28ffULL,
0x000000ffff2f7224ULL, 0x000fc400078e0000ULL, 0x000001002e317824ULL, 0x000fe200078e0228ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000310200720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e0030ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fc4000001ff00ULL, 0x0000000132347810ULL, 0x020fe20007ffe0ffULL,
0x00000d6000007945ULL, 0x000fe20003800000ULL, 0x000000ffff337224ULL, 0x000fc400078e0032ULL,
0x0000002e34357211ULL, 0x040fe200078ff0ffULL, 0x0000000407437c24ULL, 0x010fe2000f8e02ffULL,
0x000000043400780cULL, 0x040fe20003f06070ULL, 0x000000ffff327224ULL, 0x000fe200078e0034ULL,
0x0000000135307810ULL, 0x000fe40007ffe0ffULL, 0x0000000334547812ULL, 0x000fe400078ec0ffULL,
0x000000043000720cULL, 0x000fe40003f26070ULL, 0x0000000144307812ULL, 0x000fd600078e0cffULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff3f7819ULL, 0x002fe20000011605ULL,
0x0000010035357824ULL, 0x000fe400078e0228ULL, 0x0000000200477824ULL, 0x000fe200078e0230ULL,
0x000000103f4e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129347824ULL, 0x000fe200078e023fULL,
0x000000083f467810ULL, 0x040fe40007ffe0ffULL, 0x000000183f4f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129387824ULL, 0x000fe200078e024eULL, 0x00000034433d7210ULL, 0x000fe20007f3e0ffULL,
0x0000000129367824ULL, 0x000fe200078e0246ULL, 0x0000003502377217ULL, 0x000fe20007800000ULL,
0x0000000446497824ULL, 0x000fe200078e00ffULL, 0x0000003843397210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200008e06ffULL, 0x00000036433b7210ULL, 0x000fe20007f5e0ffULL,
0x0000000137457824ULL, 0x000fe200078e0a35ULL, 0x000000203f507810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078640ffULL,
0x000000ffff3c7224ULL, 0x000fe200010e06ffULL, 0x00005e003b367a11ULL, 0x000fc400078440ffULL,
0x00005f0039397a11ULL, 0x000fe200018f443aULL, 0x00000001293a7824ULL, 0x000fe200078e024fULL,
0x000000283f517810ULL, 0x000fe40007ffe0ffULL, 0x00005e003d347a11ULL, 0x000fe400078240ffULL,
0x000000303f527810ULL, 0x040fe40007ffe0ffULL, 0x000000383f537810ULL, 0x000fe40007ffe0ffULL,
0x00005f003b377a11ULL, 0x000fe200010f443cULL, 0x00000001293b7824ULL, 0x000fe200078e0250ULL,
0x00005f003d357a11ULL, 0x000fe200008f443eULL, 0x00000001293c7824ULL, 0x000fe200078e0251ULL,
0x0000003a43427210ULL, 0x000fe20007f3e0ffULL, 0x00000001293d7824ULL, 0x000fe200078e0252ULL,
0x000000453f00720cULL, 0x000fe20003f46070ULL, 0x00000001293e7824ULL, 0x000fe200078e0253ULL,
0x0000003b43407210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e06ffULL,
0x0000003c433f7210ULL, 0x000fc40007fde0ffULL, 0x00000005053c7211ULL, 0x000fe400078fe8ffULL,
0x00005e00423a7a11ULL, 0x000fe200078240ffULL, 0x000000ffff4c7224ULL, 0x000fe200030e06ffULL,
0x0000003d43417210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200028e06ffULL,
0x0000003e43437210ULL, 0x000fe20007f7e0ffULL, 0x00000004543e7824ULL, 0x000fe200078e00ffULL,
0x000000033c4d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x00005f00423b7a11ULL, 0x000fe200008f443bULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x000000454600720cULL, 0x000fc40003f26070ULL, 0x0000200047477811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4d487812ULL, 0x100fe400078ef805ULL, 0xfffffffc3e467812ULL, 0x000fe400078ee205ULL,
0xfffffffc49497812ULL, 0x000fe200078ee24dULL, 0x0000001048487824ULL, 0x000fe200078e0247ULL,
0x00005e00403c7a11ULL, 0x000fe200078a40ffULL, 0x0000001046347825ULL, 0x000fe200078e0034ULL,
0x00005e0043427a11ULL, 0x000fc400078640ffULL, 0x00005f00403d7a11ULL, 0x000fe200028f443dULL,
0x0000001049497824ULL, 0x000fe200078e0247ULL, 0x00005e003f3e7a11ULL, 0x000fe200078a40ffULL,
0x0000001046367825ULL, 0x000fe200078e0036ULL, 0x00005e0041407a11ULL, 0x000fe200078840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034487faeULL, 0x0003e2000d101c46ULL,
0x00005f003f3f7a11ULL, 0x000fe400028f444cULL, 0x00005f0041417a11ULL, 0x000fe200020f444bULL,
0x0000000036497faeULL, 0x0005e2000c901c46ULL, 0x00005f0043437a11ULL, 0x000fe200018f444aULL,
0x00000004514a7824ULL, 0x000fe200078e00ffULL, 0x000000454e00720cULL, 0x080fe20003f26070ULL,
0x00000004524b7824ULL, 0x000fe200078e00ffULL, 0x000000454f00720cULL, 0x000fc40003f46070ULL,
0x000000455000720cULL, 0x080fe20003f66070ULL, 0x000000044f487824ULL, 0x002fe200078e00ffULL,
0x000000455100720cULL, 0x080fe20003f86070ULL, 0x0000001046347825ULL, 0x000fe200078e0038ULL,
0x000000455200720cULL, 0x080fe40003fa6070ULL, 0x000000455300720cULL, 0x040fe20003fc6070ULL,
0x000000044e457824ULL, 0x000fe200078e00ffULL, 0xfffffffc48487812ULL, 0x100fe200078ee24dULL,
0x0000000450497824ULL, 0x004fe200078e00ffULL, 0xfffffffc4a4a7812ULL, 0x100fe200078ee24dULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0xfffffffc45457812ULL, 0x000fe200078ee24dULL,
0x0000001048487824ULL, 0x000fe200078e0247ULL, 0xfffffffc49497812ULL, 0x000fe200078ee24dULL,
0x0000001046367825ULL, 0x000fe200078e003aULL, 0xfffffffc4b4b7812ULL, 0x000fc400078ee24dULL,
0xfffffffc534d7812ULL, 0x000fe200078ee24dULL, 0x0000001045457824ULL, 0x100fe400078e0247ULL,
0x0000001049497824ULL, 0x000fe400078e0247ULL, 0x0000001046387825ULL, 0x000fe200078e003cULL,
0x0000000034457faeULL, 0x0003e6000c901c46ULL, 0x000000104a4a7824ULL, 0x000fe200078e0247ULL,
0x0000000036487faeULL, 0x0003e2000d101c46ULL, 0x00000010463a7825ULL, 0x000fc600078e003eULL,
0x0000000038497faeULL, 0x0003e2000d901c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e0247ULL,
0x00000010463c7825ULL, 0x040fe200078e0040ULL, 0x000000003a4a7faeULL, 0x0003e6000e101c46ULL,
0x000000104d477824ULL, 0x000fe200078e0247ULL, 0x000000003c4b7faeULL, 0x0003e2000e901c46ULL,
0x00000010463e7825ULL, 0x000fca00078e0042ULL, 0x000000003e477faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x00000008053e7811ULL, 0x042fe200078ff0ffULL,
0x0000000454507824ULL, 0x000fe200078e00ffULL, 0x0000002905357211ULL, 0x040fe400078ff0ffULL,
0x0000001005407811ULL, 0x000fe200078ff0ffULL, 0x0000000129377824ULL, 0x000fe200078e023eULL,
0x0000004335357210ULL, 0x080fe20007f3e0ffULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x0000001805427811ULL, 0x000fe400078ff0ffULL, 0x0000004337377210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078240ffULL,
0x00000001293b7824ULL, 0x000fe200078e0242ULL, 0x0000002005457811ULL, 0x000fe200078ff0ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078440ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000002805467811ULL, 0x000fe200078ff0ffULL,
0x00000001293d7824ULL, 0x000fe200078e0245ULL, 0x0000003005477811ULL, 0x000fc400078ff0ffULL,
0x0000003805487811ULL, 0x000fe200078ff0ffULL, 0x00000001293f7824ULL, 0x000fe200078e0246ULL,
0x00005f0035357a11ULL, 0x000fe200008f4439ULL, 0x0000000129397824ULL, 0x000fe200078e0240ULL,
0x00005f0037377a11ULL, 0x000fe200010f4438ULL, 0x0000000200387824ULL, 0x000fe200078e0230ULL,
0x00000005053a7211ULL, 0x000fe200078fe8ffULL, 0x0000000129417824ULL, 0x000fe200078e0247ULL,
0x0000004339397210ULL, 0x080fe20007fde0ffULL, 0x00000001293c7824ULL, 0x000fe200078e0248ULL,
0x000000433b3b7210ULL, 0x080fe20007fbe0ffULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x000000433d3d7210ULL, 0x080fe20007f9e0ffULL, 0x0000000446497824ULL, 0x000fe200078e00ffULL,
0x000000433f3f7210ULL, 0x080fe20007f3e0ffULL, 0x00000004474a7824ULL, 0x000fe200078e00ffULL,
0x0000004341417210ULL, 0x080fe20007f5e0ffULL, 0x00000004484c7824ULL, 0x000fe200078e00ffULL,
0x00002000384b7811ULL, 0x000fe200078e60ffULL, 0x0000000445387824ULL, 0x000fe200078e00ffULL,
0x000000433c437210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200020e06ffULL,
0x000000033a3c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3a7224ULL, 0x000fe200030e06ffULL,
0xfffffffc50507812ULL, 0x000fe200078ee205ULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0xfffffffc38487812ULL, 0x000fe200078ee23cULL, 0x000000ffff4d7224ULL, 0x000fe200010e06ffULL,
0x00005e0039387a11ULL, 0x000fe200078c40ffULL, 0x0000001050347825ULL, 0x000fe200078e0034ULL,
0xfffffffc3e457812ULL, 0x000fc400078ee23cULL, 0xfffffffc40467812ULL, 0x100fe200078ee23cULL,
0x0000001048487824ULL, 0x100fe200078e024bULL, 0xfffffffc42477812ULL, 0x100fe200078ee23cULL,
0x0000001045457824ULL, 0x100fe200078e024bULL, 0xfffffffc49497812ULL, 0x100fe200078ee23cULL,
0x0000001046467824ULL, 0x100fe200078e024bULL, 0xfffffffc4a4a7812ULL, 0x100fe200078ee23cULL,
0x0000001047477824ULL, 0x000fe200078e024bULL, 0x0ffffffc3c3e7812ULL, 0x000fe200078ef805ULL,
0x0000001049497824ULL, 0x100fe200078e024bULL, 0xfffffffc4c407812ULL, 0x000fe200078ee23cULL,
0x000000ffff3c7224ULL, 0x000fe200028e06ffULL, 0x00005f0039397a11ULL, 0x000fe200030f443aULL,
0x000000103e517824ULL, 0x100fe200078e024bULL, 0x00005e003b3a7a11ULL, 0x000fe200078a40ffULL,
0x000000104a4a7824ULL, 0x100fe200078e024bULL, 0x00005e003f3e7a11ULL, 0x000fe200078240ffULL,
0x00000010404b7824ULL, 0x000fe200078e024bULL, 0x00005f003b3b7a11ULL, 0x000fe200028f443cULL,
0x000000ffff4c7224ULL, 0x000fe200018e06ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034517faeULL, 0x0003e2000b901c46ULL,
0x00005e0041407a11ULL, 0x000fc400078440ffULL, 0x00005e0043427a11ULL, 0x000fe400078640ffULL,
0x00005f003d3d7a11ULL, 0x000fe400020f444fULL, 0x00005f003f3f7a11ULL, 0x000fe400008f444eULL,
0x00005f0041417a11ULL, 0x000fe400010f444dULL, 0x00005f0043437a11ULL, 0x000fe200018f444cULL,
0x0000001050347825ULL, 0x002fc800078e0036ULL, 0x0000001050367825ULL, 0x040fe200078e0038ULL,
0x0000000034457faeULL, 0x0003e6000b901c46ULL, 0x0000001050387825ULL, 0x040fe200078e003aULL,
0x0000000036467faeULL, 0x0003e6000b901c46ULL, 0x00000010503a7825ULL, 0x040fe200078e003cULL,
0x0000000038477faeULL, 0x0003e6000b901c46ULL, 0x00000010503c7825ULL, 0x040fe200078e003eULL,
0x000000003a487faeULL, 0x0003e6000b901c46ULL, 0x00000010503e7825ULL, 0x040fe200078e0040ULL,
0x000000003c497faeULL, 0x0003e6000b901c46ULL, 0x0000001050407825ULL, 0x000fe200078e0042ULL,
0x000000003e4a7faeULL, 0x0003e8000b901c46ULL, 0x00000000404b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000035400780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x000000042f2f7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff077424ULL, 0x000fc600078e00ffULL,
0x000000032f00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000206347824ULL, 0x002fe400078e022fULL, 0x00000004ff357424ULL, 0x000fc800078e00ffULL,
0x0000600034347625ULL, 0x000fca00078e0035ULL, 0x0000000634077981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002005357810ULL, 0x042fe20007ffe0ffULL, 0x0000000200367824ULL, 0x000fe200078e0244ULL,
0xfffffff805347812ULL, 0x000fe200078ec0ffULL, 0x000000ffff407224ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe400078ec0ffULL, 0x0000000705377812ULL, 0x000fe400078ec0ffULL,
0x0000000734417812ULL, 0x100fe400078ef805ULL, 0x0000000735437812ULL, 0x000fc400078ef805ULL,
0x00002000364a7811ULL, 0x000fe400078e60ffULL, 0x00000008374b7812ULL, 0x000fe400078ef805ULL,
0x00000001ff427819ULL, 0x000fe40000011641ULL, 0x00000001ff487819ULL, 0x000fe20000011643ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000004333c7824ULL, 0x120fe200078e0240ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000142347824ULL, 0x000fe200078e0240ULL,
0x0000000140497810ULL, 0x000fe20007ffe0ffULL, 0x0000000441357824ULL, 0x000fc400078e00ffULL,
0x000000023c3c7824ULL, 0x000fe400078e00ffULL, 0x000000204b367824ULL, 0x000fe200078e00ffULL,
0xfffffffc35357812ULL, 0x000fe200078ee234ULL, 0x0000000148387824ULL, 0x000fe200078e0240ULL,
0x0000003c05347211ULL, 0x000fe200078fe0ffULL, 0x0000000443397824ULL, 0x000fe200078e00ffULL,
0x000000023c3c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001035357824ULL, 0x000fe200078e024aULL,
0x0000000240407810ULL, 0x000fe20007ffe0ffULL, 0x000000014b347824ULL, 0x000fe200078e0234ULL,
0xfffffffc39387812ULL, 0x000fe200078ee238ULL, 0x00000001423d7824ULL, 0x100fe200078e0249ULL,
0x000000003544783bULL, 0x000e620000000200ULL, 0x0000003c053c7211ULL, 0x000fe200078fe0ffULL,
0x0000000148497824ULL, 0x000fe200078e0249ULL, 0xffffffe036347812ULL, 0x000fe200078ee234ULL,
0x0000001038387824ULL, 0x000fe200078e024aULL, 0x000000044000780cULL, 0x000fe20003f25270ULL,
0x000000014b3c7824ULL, 0x000fc400078e023cULL, 0x0000001034347824ULL, 0x000fe400078e00ffULL,
0x000000003838783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x00000044ff3e723eULL, 0x082fe400020006ffULL, 0x00000044ff3f723eULL, 0x000fe400030006ffULL,
0x00000045ff44723eULL, 0x000fc400020006ffULL, 0x00000045ff45723eULL, 0x000fc600030006ffULL,
0x0000003e3424723cULL, 0x044b6e0000001824ULL, 0x00000046ff3e723eULL, 0x0a0fe200020006ffULL,
0x000000443420723cULL, 0x000b620000001820ULL, 0x00000046ff3f723eULL, 0x000fe400030006ffULL,
0x00000047ff46723eULL, 0x000fc400020006ffULL, 0x00000047ff47723eULL, 0x000fe400030006ffULL,
0x0000000441447824ULL, 0x020fe200078e00ffULL, 0x0000003e341c723cULL, 0x000b68000000181cULL,
0xfffffffc443d7812ULL, 0x000fc600078ee23dULL, 0x000000204b3e7824ULL, 0x020fe200078e00ffULL,
0x000000463444723cULL, 0x000b620000001818ULL, 0x000000103d3d7824ULL, 0x000fc600078e024aULL,
0xffffffe03e3c7812ULL, 0x000fe400078ee23cULL, 0x000000003d50783bULL, 0x000e620000000200ULL,
0x00000038ff18723eULL, 0x0a0fe400020006ffULL, 0x00000038ff19723eULL, 0x000fe200030006ffULL,
0x000000103c3c7824ULL, 0x000fe200078e00ffULL, 0x00000039ff38723eULL, 0x080fe400020006ffULL,
0x00000039ff39723eULL, 0x000fc600030006ffULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x000000183414723cULL, 0x040f700000001814ULL, 0x00000038344c723cULL, 0x000bee0000001810ULL,
0x0000000443127824ULL, 0x020fe200078e00ffULL, 0x0000003aff10723eULL, 0x000fc400020006ffULL,
0x0000003aff11723eULL, 0x000fe400030006ffULL, 0xfffffffc12497812ULL, 0x000fe400078ee249ULL,
0x0000003bff3a723eULL, 0x080fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fe200030006ffULL,
0x0000001049497824ULL, 0x000fe200078e024aULL, 0x00000010340c723cULL, 0x000b62000000180cULL,
0x00000053ff18723eULL, 0x002fc600020006ffULL, 0x000000004954783bULL, 0x000e620000000200ULL,
0x00000053ff19723eULL, 0x000fe400030006ffULL, 0x00000050ff10723eULL, 0x0a0fe200020006ffULL,
0x0000003a3408723cULL, 0x000f620000001808ULL, 0x00000050ff11723eULL, 0x000fe400030006ffULL,
0x00000051ff50723eULL, 0x080fe400020006ffULL, 0x00000051ff51723eULL, 0x000fc600030006ffULL,
0x000000103c24723cULL, 0x044b6e0000001824ULL, 0x00000052ff10723eULL, 0x0a0fe200020006ffULL,
0x000000503c20723cULL, 0x000f620000001820ULL, 0x00000052ff11723eULL, 0x000fce00030006ffULL,
0x000000103c1c723cULL, 0x040b70000000181cULL, 0x000000183c18723cULL, 0x000f640000001844ULL,
0x00000054ff10723eULL, 0x022fc400020006ffULL, 0x00000054ff11723eULL, 0x000fe400030006ffULL,
0x00000056ff34723eULL, 0x080fe400020006ffULL, 0x00000056ff35723eULL, 0x000fe400030006ffULL,
0x00000057ff56723eULL, 0x080fe200020006ffULL, 0x000000103c14723cULL, 0x000b620000001814ULL,
0x00000057ff57723eULL, 0x000fcc00030006ffULL, 0x00000055ff10723eULL, 0x0a0fe200020006ffULL,
0x000000343c0c723cULL, 0x000b62000000180cULL, 0x00000055ff11723eULL, 0x000fce00030006ffULL,
0x000000103c10723cULL, 0x040b70000000184cULL, 0x000000563c08723cULL, 0x000b620000001808ULL,
0xfffffa8000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff447224ULL, 0x000fe200078e0030ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffeb2000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000002a1a347220ULL, 0x0a0fe20000410000ULL, 0x0000002a1e327220ULL, 0x080fe20000410000ULL,
0x0000002a1b357220ULL, 0x080fe20000410000ULL, 0x0000002a141a7220ULL, 0x080fe20000410000ULL,
0x0000002a1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002a1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002a1f337220ULL, 0x080fe20000410000ULL, 0x0000002a151b7220ULL, 0x080fe20000410000ULL,
0x0000002a101e7220ULL, 0x080fe20000410000ULL, 0x0000002a24247220ULL, 0x080fe20000410000ULL,
0x0000002a25257220ULL, 0x080fe20000410000ULL, 0x0000002a20207220ULL, 0x080fe20000410000ULL,
0x0000002a21217220ULL, 0x080fe20000410000ULL, 0x0000002a18187220ULL, 0x080fe20000410000ULL,
0x0000002a19197220ULL, 0x080fe20000410000ULL, 0x0000002a111f7220ULL, 0x080fe20000410000ULL,
0x0000002a0c0c7220ULL, 0x080fe20000410000ULL, 0x0000002a0d0d7220ULL, 0x080fe20000410000ULL,
0x0000002a08087220ULL, 0x080fe20000410000ULL, 0x0000002a16367220ULL, 0x080fe20000410000ULL,
0x0000002a17377220ULL, 0x080fe20000410000ULL, 0x0000002a12387220ULL, 0x080fe20000410000ULL,
0x0000002a13397220ULL, 0x080fe20000410000ULL, 0x000000ffff167224ULL, 0x000fe200078e001aULL,
0x0000002a0e3a7220ULL, 0x080fe20000410000ULL, 0x0000002a0f3b7220ULL, 0x080fe20000410000ULL,
0x000000ffff127224ULL, 0x000fe200078e001cULL, 0x0000002a26267220ULL, 0x080fe20000410000ULL,
0x000000ffff137224ULL, 0x000fe200078e001dULL, 0x0000002a27277220ULL, 0x080fe20000410000ULL,
0x000000ffff177224ULL, 0x000fe200078e001bULL, 0x0000002a22227220ULL, 0x080fe20000410000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e001eULL, 0x0000002a23237220ULL, 0x080fe20000410000ULL,
0x0000002a09097220ULL, 0x080fe20000410000ULL, 0x0000002a0a0a7220ULL, 0x080fe20000410000ULL,
0x0000002a0b0b7220ULL, 0x000fe20000410000ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0024ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0025ULL, 0x000000ffff107224ULL, 0x000fe400078e0020ULL,
0x000000ffff117224ULL, 0x000fe400078e0021ULL, 0x000000ffff147224ULL, 0x000fe400078e0018ULL,
0x000000ffff157224ULL, 0x000fe400078e0019ULL, 0x000000ffff1b7224ULL, 0x000fc400078e001fULL,
0x000000ffff1c7224ULL, 0x000fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000dULL,
0x000000ffff1e7224ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002b0c7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fe400078e0026ULL,
0x000000ffff217224ULL, 0x000fe400078e0027ULL, 0x000000ffff247224ULL, 0x000fc400078e0032ULL,
0x000000ffff257224ULL, 0x000fe400078e0033ULL, 0x000000ffff267224ULL, 0x000fe400078e0034ULL,
0x000000ffff277224ULL, 0x000fe400078e0035ULL, 0x000000ffff327224ULL, 0x000fe400078e0036ULL,
0x000000ffff337224ULL, 0x000fe400078e0037ULL, 0x000000ffff347224ULL, 0x000fc400078e0038ULL,
0x000000ffff357224ULL, 0x000fe400078e0039ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0009ULL,
0x000000ffff367224ULL, 0x000fe400078e003aULL, 0x000000ffff377224ULL, 0x000fe400078e003bULL,
0x000000ffff387224ULL, 0x000fe400078e000aULL, 0x000000ffff397224ULL, 0x000fc400078e000bULL,
0x0000000000087805ULL, 0x006fca0000015200ULL, 0x000004002b0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08187210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x000000180a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000119197810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004002b0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000405197824ULL, 0x000fe200078e00ffULL,
0x0000002c2e00720cULL, 0x000fc80003f05270ULL, 0xfffffff019187812ULL, 0x000fca00078ec0ffULL,
0x0000008000187824ULL, 0x000fca00078e0218ULL, 0x0104000018087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002050c7824ULL, 0x000fe400078e00ffULL,
0x0000000102317824ULL, 0x000fc600078e0a31ULL, 0x000000060c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c0d7812ULL, 0x040fe400078efcffULL, 0x000000080c3a7812ULL, 0x040fe400078efcffULL,
0x000000310d00720cULL, 0x080fe40003f26070ULL, 0x000000100c0d7812ULL, 0x000fe400078efcffULL,
0x000000313a00720cULL, 0x080fe40003f06070ULL, 0x000000310d00720cULL, 0x000fc40003fc6070ULL,
0x000000110c3a7812ULL, 0x040fe400078efcffULL, 0x000000180c0d7812ULL, 0x040fe400078efcffULL,
0x000000310c00720cULL, 0x080fe40003f46070ULL, 0x000000313a00720cULL, 0x080fe40003fa6070ULL,
0x000000310d00720cULL, 0x000fe40003f66070ULL, 0x000000090c3b7812ULL, 0x000fc400078efcffULL,
0x000000190c3a7812ULL, 0x040fe400078efcffULL, 0x000000200c0d7812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40005000000ULL, 0xff8000000e0e7808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0xff8000000f0f7808ULL, 0x000fc40004800000ULL,
0x000000313b00720cULL, 0x080fe40003f86070ULL, 0x000000313a00720cULL, 0x080fe40003f46070ULL,
0x000000310d00720cULL, 0x000fe40003f26070ULL, 0x000000210c3a7812ULL, 0x040fe400078efcffULL,
0x000000280c0d7812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fc40004000000ULL,
0xff80000010107808ULL, 0x000fe40004000000ULL, 0xff80000023237808ULL, 0x000fe40006000000ULL,
0xff80000011117808ULL, 0x000fe40006000000ULL, 0x000000313a00720cULL, 0x080fe40003f06070ULL,
0x000000310d00720cULL, 0x000fe40003f86070ULL, 0x000000290c3a7812ULL, 0x000fc400078efcffULL,
0x000000300c0d7812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40007000000ULL,
0xff80000012127808ULL, 0x000fe40007000000ULL, 0xff80000025257808ULL, 0x000fe40006800000ULL,
0xff80000013137808ULL, 0x000fe40006800000ULL, 0x000000313a00720cULL, 0x000fc40003fc6070ULL,
0x000000310d00720cULL, 0x000fe40003fa6070ULL, 0x000000310c3a7812ULL, 0x040fe400078efcffULL,
0x000000380c0d7812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff80000026267808ULL, 0x000fe40005800000ULL, 0xff80000014147808ULL, 0x000fc40005800000ULL,
0xff80000027277808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40005000000ULL,
0xff80000032327808ULL, 0x000fe40004800000ULL, 0xff80000016167808ULL, 0x000fe40004800000ULL,
0x000000313a00720cULL, 0x080fe40003f66070ULL, 0x000000310d00720cULL, 0x000fc40003f46070ULL,
0x000000310c00720cULL, 0x000fe40003f26070ULL, 0xff80000033337808ULL, 0x000fe40004000000ULL,
0xff80000017177808ULL, 0x000fe40004000000ULL, 0xff80000034347808ULL, 0x000fe40006000000ULL,
0xff8000001a1a7808ULL, 0x000fe40006000000ULL, 0xff80000035357808ULL, 0x000fc40007000000ULL,
0xff8000001b1b7808ULL, 0x000fe40007000000ULL, 0xff80000036367808ULL, 0x000fe40006800000ULL,
0xff8000001c1c7808ULL, 0x000fe40006800000ULL, 0xff80000037377808ULL, 0x000fe40005800000ULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff80000038387808ULL, 0x000fc40005000000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff80000039397808ULL, 0x000fe40004800000ULL,
0xff8000001f1f7808ULL, 0x000fc40004800000ULL, 0x0000000e0800720bULL, 0x004fe20003f1e000ULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x000000200900720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x000000080e087208ULL, 0x000fe40004000000ULL,
0x0000000920097208ULL, 0x000fc40004800000ULL, 0x0000000f0800720bULL, 0x000fe40003f1e000ULL,
0x000000210900720bULL, 0x000fe40003f3e000ULL, 0x000000080f087208ULL, 0x000fe40004000000ULL,
0x0000000921097208ULL, 0x000fe40004800000ULL, 0x000000100800720bULL, 0x000fe40003f1e000ULL,
0x000000220900720bULL, 0x000fc40003f3e000ULL, 0x0000000810087208ULL, 0x000fe40004000000ULL,
0x0000000922097208ULL, 0x000fe40004800000ULL, 0x000000110800720bULL, 0x000fe40003f1e000ULL,
0x000000230900720bULL, 0x000fe40003f3e000ULL, 0x0000000811087208ULL, 0x000fe40004000000ULL,
0x0000000923097208ULL, 0x000fc40004800000ULL, 0x000000120800720bULL, 0x000fe40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x0000000812087208ULL, 0x000fe40004000000ULL,
0x0000000924097208ULL, 0x000fe40004800000ULL, 0x000000130800720bULL, 0x000fe40003f1e000ULL,
0x000000250900720bULL, 0x000fc40003f3e000ULL, 0x0000000813087208ULL, 0x000fe40004000000ULL,
0x0000000925097208ULL, 0x000fe40004800000ULL, 0x000000140800720bULL, 0x000fe40003f1e000ULL,
0x000000260900720bULL, 0x000fe40003f3e000ULL, 0x0000000814087208ULL, 0x000fe40004000000ULL,
0x0000000926097208ULL, 0x000fc40004800000ULL, 0x000000150800720bULL, 0x000fe40003f1e000ULL,
0x000000270900720bULL, 0x000fe40003f3e000ULL, 0x0000000815087208ULL, 0x000fe40004000000ULL,
0x0000000927097208ULL, 0x000fe40004800000ULL, 0x000000160800720bULL, 0x000fe40003f1e000ULL,
0x000000320900720bULL, 0x000fc40003f3e000ULL, 0x0000000816087208ULL, 0x000fe40004000000ULL,
0x0000000932097208ULL, 0x000fe40004800000ULL, 0x000000170800720bULL, 0x000fe40003f1e000ULL,
0x000000330900720bULL, 0x000fe40003f3e000ULL, 0x0000000817087208ULL, 0x000fe40004000000ULL,
0x0000000933097208ULL, 0x000fc40004800000ULL, 0x0000001a0800720bULL, 0x000fe40003f1e000ULL,
0x000000340900720bULL, 0x000fe40003f3e000ULL, 0x000000081a087208ULL, 0x000fe40004000000ULL,
0x0000000934097208ULL, 0x000fe40004800000ULL, 0x0000001b0800720bULL, 0x000fe40003f1e000ULL,
0x000000350900720bULL, 0x000fc40003f3e000ULL, 0x000000081b087208ULL, 0x000fe40004000000ULL,
0x0000000935097208ULL, 0x000fe40004800000ULL, 0x0000001c0800720bULL, 0x000fe40003f1e000ULL,
0x000000360900720bULL, 0x000fe40003f3e000ULL, 0x000000081c087208ULL, 0x000fe40004000000ULL,
0x0000000936097208ULL, 0x000fc40004800000ULL, 0x0000001d0800720bULL, 0x000fe40003f1e000ULL,
0x000000370900720bULL, 0x000fe40003f3e000ULL, 0x000000081d087208ULL, 0x000fe40004000000ULL,
0x0000000937097208ULL, 0x000fe40004800000ULL, 0x0000001e0800720bULL, 0x000fe40003f1e000ULL,
0x000000380900720bULL, 0x000fc40003f3e000ULL, 0x000000081e087208ULL, 0x000fe40004000000ULL,
0x0000000938097208ULL, 0x000fe40004800000ULL, 0x0000001f0800720bULL, 0x000fe40003f1e000ULL,
0x000000390900720bULL, 0x000fe40003f3e000ULL, 0x000000081f3b7208ULL, 0x000fe40004000000ULL,
0x0000000939097208ULL, 0x000fe20004800000ULL, 0x000018827f007947ULL, 0x000fec000b800000ULL,
0x0c401f003b087f89ULL, 0x0004e400000e0000ULL, 0x000000083b00720bULL, 0x008fc80003f1e000ULL,
0x0000003b083b7208ULL, 0x004fe20004000000ULL, 0x000018a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0009087f89ULL, 0x000ea800000e0000ULL, 0x0c401f000a0c7f89ULL, 0x000ee800000e0000ULL,
0x0c401f000b0d7f89ULL, 0x000e6200000e0000ULL, 0x000000080900720bULL, 0x004fc40003f1e000ULL,
0x0000000c0a00720bULL, 0x008fe40003f3e000ULL, 0x0000000908097208ULL, 0x000fe40004000000ULL,
0x0000000a0c0a7208ULL, 0x000fe20004800000ULL, 0x0c201f003b087f89ULL, 0x000ea200000e0000ULL,
0x0000000d0b00720bULL, 0x002fc60003f1e000ULL, 0x0c201f00090c7f89ULL, 0x000e6200000e0000ULL,
0x0000000b0d0b7208ULL, 0x000fc60004000000ULL, 0x0c201f000a317f89ULL, 0x000ee800000e0000ULL,
0x0c201f000b3a7f89ULL, 0x0002e200000e0000ULL, 0x000000083b00720bULL, 0x004fe40003f1e000ULL,
0x0000000c0900720bULL, 0x002fe40003f3e000ULL, 0x0000003b08087208ULL, 0x000fe40004000000ULL,
0x000000310a00720bULL, 0x008fc40003f5e000ULL, 0x000000090c097208ULL, 0x000fe40004800000ULL,
0x0000000a310a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b080c7820ULL, 0x000fe20000410000ULL,
0x3c003c00ff427424ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff437424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080cULL, 0x0000001c003e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080cULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b091c7820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1d1d7823ULL, 0x000fe2000001080cULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b20207823ULL, 0x000fe2000001081cULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b1f0c7823ULL, 0x000fe2000001080cULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001081cULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b39397823ULL, 0x000fe2000001081cULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x0000000c19197812ULL, 0x000fc400078ec0ffULL,
0x0000000305ff7812ULL, 0x000fe4000780c0ffULL, 0x0000003a0b00720bULL, 0x004fc60003f3e000ULL,
0x00000020000d7308ULL, 0x000fe20000000800ULL, 0x0000000b3a0b7208ULL, 0x000fce0004800000ULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x0000000d210d723eULL, 0x002fce00000000ffULL,
0x0000000c00417308ULL, 0x0003f00000000800ULL, 0x0000001400317308ULL, 0x000fe20000000800ULL,
0x0000000e0f0c723eULL, 0x002fe400000000ffULL, 0x00000010110e723eULL, 0x000fc400000000ffULL,
0x00000022230f723eULL, 0x004fc600000000ffULL, 0x00000015003b7308ULL, 0x000ff00000000800ULL,
0x00000016003c7308ULL, 0x000ff00000000800ULL, 0x00000017003d7308ULL, 0x0003f00000000800ULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x000000420c14723cULL, 0x002f6e00000018ffULL,
0x0000001300137308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fc400000000ffULL,
0x000000313b12723eULL, 0x000fe400000000ffULL, 0x00000002ff3b7819ULL, 0x000fc60000011605ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000013b207810ULL, 0x040fe40007ffe0ffULL,
0x000000023b217810ULL, 0x040fe40007ffe0ffULL, 0x000000063b317810ULL, 0x000fc60007ffe0ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000242511723eULL, 0x004fe200000000ffULL,
0x000000083b247824ULL, 0x040fe400078e00ffULL, 0x000000083b257824ULL, 0x000fc600078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee220ULL, 0x0000001d003f7308ULL, 0x000fe20000000800ULL,
0xfffffff825257812ULL, 0x000fe400078ee221ULL, 0x000000262713723eULL, 0x002fca00000000ffULL,
0x0000001e00407308ULL, 0x0003e20000000800ULL, 0x000000083b267824ULL, 0x040fe400078e00ffULL,
0x000000083b277824ULL, 0x000fca00078e00ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x00000042101c723cULL, 0x022b6e0000001814ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x000000033b147810ULL, 0x060fe40007ffe0ffULL, 0x000000043b157810ULL, 0x000fc40007ffe0ffULL,
0xfffffff826267812ULL, 0x000fe400078ee214ULL, 0xfffffff827277812ULL, 0x000fe200078ee215ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x0000003c3d14723eULL, 0x000fce00000000ffULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x0000001a1b16723eULL, 0x002fe200000000ffULL,
0x000000083b1a7824ULL, 0x040fe200078e00ffULL, 0x000000053b1b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee23bULL, 0x0000003400347308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x000000323315723eULL, 0x004fc400000000ffULL,
0x000000083b337810ULL, 0x040fe40007ffe0ffULL, 0xffffffff3b327810ULL, 0x000fc60007ffe0ffULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000343517723eULL, 0x002fce00000000ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000083b347824ULL, 0x040fe400078e00ffULL,
0x000000083b357824ULL, 0x040fe400078e00ffULL, 0x000000083b3b7824ULL, 0x000fe200078e00ffULL,
0x000000421420723cULL, 0x000b62000000181cULL, 0xfffffff8341b7812ULL, 0x000fe200078ee21bULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x0000a00000347811ULL, 0x000fe400078e58ffULL,
0xfffffff835317812ULL, 0x000fc400078ee231ULL, 0x00000008331c7824ULL, 0x020fe200078e00ffULL,
0x00000040411e723eULL, 0x000fe200000000ffULL, 0x000000101a1a7824ULL, 0x100fe200078e0234ULL,
0x0000003900397308ULL, 0x000ea20000000800ULL, 0x00000036371d723eULL, 0x002fe200000000ffULL,
0x0000001024247824ULL, 0x100fe200078e0234ULL, 0xfffffff81c337812ULL, 0x000fe200078ee233ULL,
0x0000001025257824ULL, 0x100fe200078e0234ULL, 0x0000003e3f1c723eULL, 0x000fe200000000ffULL,
0x0000001026267824ULL, 0x000fe200078e0234ULL, 0xfffffff83b327812ULL, 0x000fe200078ee232ULL,
0x0000001027277824ULL, 0x000fc400078e0234ULL, 0x000000011a1a7824ULL, 0x000fe400078e0219ULL,
0x000000101b1b7824ULL, 0x000fe400078e0234ULL, 0x0000000119247824ULL, 0x000fe200078e0224ULL,
0x0000000c1a007388ULL, 0x0003e20000000800ULL, 0x00000038391f723eULL, 0x004fe200000000ffULL,
0x0000001031317824ULL, 0x100fe400078e0234ULL, 0x0000000119257824ULL, 0x000fe200078e0225ULL,
0x0000000e24007388ULL, 0x0003e20000000800ULL, 0x0000001032327824ULL, 0x000fc400078e0234ULL,
0x000000421c20723cULL, 0x000f620000001820ULL, 0x0000000119267824ULL, 0x000fe200078e0226ULL,
0x0000001025007388ULL, 0x0003e20000000800ULL, 0x0000001033337824ULL, 0x000fe400078e0234ULL,
0x0000000119277824ULL, 0x040fe200078e0227ULL, 0x0000001226007388ULL, 0x0003e20000000800ULL,
0x00000001191b7824ULL, 0x040fe400078e021bULL, 0x0000000119317824ULL, 0x040fe200078e0231ULL,
0x0000001427007388ULL, 0x0003e20000000800ULL, 0x0000000119327824ULL, 0x000fc400078e0232ULL,
0x0000000119337824ULL, 0x000fe200078e0233ULL, 0x000000161b007388ULL, 0x0003e80000000800ULL,
0x0000001c31007388ULL, 0x0003e80000000800ULL, 0x0000001e32007388ULL, 0x0003e40000000800ULL,
0x000000ffff217224ULL, 0x020fc400078e0022ULL, 0x0000000d33007388ULL, 0x0003e80000000800ULL,
0x0004000f24007388ULL, 0x0003e80000000800ULL, 0x0004001125007388ULL, 0x0003e80000000800ULL,
0x0004001326007388ULL, 0x0003e80000000800ULL, 0x0004001527007388ULL, 0x0003e80000000800ULL,
0x000400171b007388ULL, 0x0003e80000000800ULL, 0x0004001d31007388ULL, 0x0003e80000000800ULL,
0x0004001f32007388ULL, 0x0003e80000000800ULL, 0x0100000818008388ULL, 0x0003e80000000c00ULL,
0x0102002018008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002dff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008002dff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010002dff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000012e2e7810ULL, 0x000fe20007ffe0ffULL, 0x000018002dff7f8cULL, 0x0003e6000c80043fULL,
0x000000042e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffcd8000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff3e7807ULL, 0x004fe40004000000ULL, 0x00012cd0003f7802ULL, 0x000fc40000000f00ULL,
0x0000104000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e004cULL,
0xfffef41000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x000fe40005000000ULL,
0x00012d20003f7802ULL, 0x000fc40000000f00ULL, 0x00000ff000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e004cULL, 0xfffef47000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x002fe200078e002cULL, 0x00012d70003e7802ULL, 0x000fc40000000f00ULL,
0x00000f6000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff3f7224ULL, 0x004fe200078e004cULL,
0xfffef51000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e002cULL,
0x00012dc0003e7802ULL, 0x000fc40000000f00ULL, 0x00000f1000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff3f7224ULL, 0x004fe200078e004cULL, 0xfffef63000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0027ULL, 0x00012e20003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e002aULL, 0x00000eb000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e004cULL, 0xfffefa2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0026ULL, 0x00012e80003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0027ULL, 0x00000e5000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e004cULL, 0xfffef9f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e003cULL, 0x00012ee0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e003dULL, 0x00000df000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e004cULL, 0xffff0f2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0026ULL, 0x00012f40003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e003cULL, 0x00000d9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e004cULL, 0xffff0ef000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x008fe40004000000ULL, 0x00012f90003f7802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e004cULL,
0xffff24a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x000fe40005000000ULL,
0x00012fe0003f7802ULL, 0x000fc40000000f00ULL, 0x00000d3000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e004cULL, 0xffff24e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e003eULL, 0x00013040003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e004eULL, 0x00000c9000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e004cULL, 0xffff259000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e003eULL, 0x000130a0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e004eULL, 0x00000c3000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e004cULL, 0xffff269000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e003dULL, 0x00013100003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0047ULL, 0x00000bd000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e004cULL, 0xffff2ac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0026ULL, 0x00013160003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e003dULL, 0x00000b7000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e004cULL, 0xffff2a9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0048ULL, 0x000131c0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0049ULL, 0x00000b1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e004cULL, 0xffff3dd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0026ULL, 0x00013220003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0048ULL, 0x00000ab000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e004cULL, 0xffff3da000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x008fe40004000000ULL, 0x00013270003f7802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e004cULL,
0xffff525000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x000fe40005000000ULL,
0x000132c0003f7802ULL, 0x000fc40000000f00ULL, 0x00000a5000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff4d7224ULL, 0x000fe200078e004cULL, 0xffff528000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e003eULL, 0x00013320003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e004eULL, 0x000009b000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e004cULL, 0xffff533000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e003eULL, 0x00013380003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e004eULL, 0x0000095000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e004cULL, 0xffff543000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e003dULL, 0x000133e0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0047ULL, 0x000008f000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e004cULL, 0xffff584000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0026ULL, 0x00013440003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e003dULL, 0x0000089000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e004cULL, 0xffff581000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0048ULL, 0x000134a0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0049ULL, 0x0000083000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e004cULL, 0xffff6b5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0026ULL, 0x00013500003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0048ULL, 0x000007d000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e004cULL, 0xffff6b2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x008fe40004000000ULL, 0x00013550003f7802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e004cULL,
0xffff7fd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x000fe40004800000ULL,
0x000135a0003f7802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff297224ULL, 0x000fe200078e004cULL, 0xffff800000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0028ULL, 0x00013600003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e004dULL, 0x000006d000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e004cULL, 0xffff80b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e004dULL, 0x00013660003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0028ULL, 0x0000067000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e004cULL, 0xffff81b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0028ULL, 0x000136c0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0029ULL, 0x0000061000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e004cULL, 0xffff85c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0026ULL, 0x00013720003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0028ULL, 0x000005b000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e004cULL, 0xffff859000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0021ULL, 0x00013780003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0027ULL, 0x0000055000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e004cULL, 0xffff98f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0026ULL, 0x000137e0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0021ULL, 0x000004f000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e004cULL, 0xffff98c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x000fe200078e003bULL, 0x0001384000317802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fc400078e00ffULL, 0x0000044000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003aULL, 0xffffe73000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0x000138a000317802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x012fea0003c00000ULL,
0x0000003a0900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000aULL,
0x0001390000317802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000093a097208ULL, 0x000fc80004000000ULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000bULL,
0x0001396000317802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000a3a0a7208ULL, 0x000fc80004000000ULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e003bULL,
0x000139c000317802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000b3a0b7208ULL, 0x000fc80004000000ULL, 0x000002c000007944ULL, 0x000fea0003c00000ULL,
0x0000003a3b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0009ULL,
0x00013a2000317802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003b3a087208ULL, 0x000fc80004000000ULL, 0x0000026000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000aULL,
0x00013a8000317802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000093a097208ULL, 0x000fc80004000000ULL, 0x0000020000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000bULL,
0x00013ae000317802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000a3a0a7208ULL, 0x000fc80004000000ULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0xffffe60000007947ULL, 0x000fea000383ffffULL, 0x0180000003027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000000300028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000204ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000003037812ULL, 0x002fe400078ec0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000204ff7212ULL, 0x000fda000780c0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000300027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x002fc800078e00ffULL, 0xfffec38002007950ULL, 0x000fea0003c3ffffULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x0c00000d0c3a7389ULL, 0x0002a400000e003cULL,
0x000000ffff0c7224ULL, 0x002fe400078e0031ULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffec3300c007950ULL, 0x000fea0003c3ffffULL, 0x0000002300007348ULL, 0x000fe80003800000ULL,
0x0000003f4c4c7389ULL, 0x0002a400000e0022ULL, 0x00000000ff3f7424ULL, 0x002fc800078e00ffULL,
0xfffec2f03e007950ULL, 0x000fea0003c3ffffULL, 0x000000013e00780cULL, 0x000fe20003f45070ULL,
0x0000002900007348ULL, 0x000fd80003800000ULL, 0x00000000003e7806ULL, 0x000fc800050e0100ULL,
0x000000293e4c7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe400078e003fULL,
0x00000000ff3f7424ULL, 0x000fc800078e00ffULL, 0xfffec2803e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x00000000000003f0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e78ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001890ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001920ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001924ULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b00ULL, 0x0000000000013e80ULL, 0x6600001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015980ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000159d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015d50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001920ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014060ULL, 0x0000000000014060ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015d50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 89648;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
