/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000007f58ULL, 0x0000000000007b18ULL, 0x00380040005a0d5aULL, 0x0001001100400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL,
0x6d5f6c656e72656bULL, 0x756265642e006168ULL, 0x00656d6172665f67ULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x6f632e766e2e616cULL, 0x0034746e6174736eULL,
0x2e6c65722e000000ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x5f67756265642e61ULL,
0x6e2e00656d617266ULL, 0x72676c6c61632e76ULL, 0x2e766e2e00687061ULL, 0x7079746f746f7270ULL,
0x6f632e766e2e0065ULL, 0x2e30746e6174736eULL, 0x6d5f6c656e72656bULL, 0x0000000000006168ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x732e000000000000ULL, 0x0062617472747368ULL, 0x006261747274732eULL, 0x006261746d79732eULL,
0x5f6261746d79732eULL, 0x6e2e0078646e6873ULL, 0x2e006f666e692e76ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL, 0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL,
0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL, 0x6f632e766e2e0061ULL, 0x0033746e6174736eULL,
0x4d34456b00000000ULL, 0x6e2e0058414d5f33ULL, 0x6c61626f6c672e76ULL, 0x6d730074696e692eULL,
0x2e00657a69536d65ULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL, 0x79546c656e72656bULL,
0x0000000000006570ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7265746e695f5f24ULL,
0x5f245f305f6c616eULL, 0x6d735f616475635fULL, 0x725f7063725f3032ULL, 0x33665f7a74665f6eULL,
0x6170776f6c735f32ULL, 0x2e6c65722e006874ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e006369702e74ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x72656b0065707974ULL, 0x0061686d5f6c656eULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e000300000089ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000100000099ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0003000000a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e0001000000b3ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d0022000000d3ULL, 0x0000000000006700ULL,
0x0000000000000280ULL, 0x0004000300000131ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000700030000018cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d1012000001a8ULL,
0x0000000000000000ULL, 0x0000000000006980ULL, 0x00100003000001b3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x0000002cffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000670000000000ULL, 0x0000500400000000ULL,
0x0400288080810c00ULL, 0x000000000000195cULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x8d082880808c0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808d920000ULL,
0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL, 0x0000670000000000ULL,
0x0000028000000000ULL, 0x0000480400000000ULL, 0x80882880808a0900ULL, 0x0900000010042880ULL,
0x2880808a2880808dULL, 0x0000000c00082f04ULL, 0x0008120400000050ULL, 0x0000000000000009ULL,
0x0000000900081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL,
0x0021f00000f00007ULL, 0x00000000000c1704ULL, 0x0201f00000700006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x00ff1b0380005003ULL,
0x000001d000103104ULL, 0x00003ab0000039b0ULL, 0x0048290400003ad0ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffff0500000cULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000001d000482804ULL, 0x00002460000023b0ULL, 0x00003ad000002530ULL, 0x000047e0000047d0ULL,
0x0000482000004810ULL, 0x0000486000004850ULL, 0x00004b3000004af0ULL, 0x00004b9000004b80ULL,
0x00004bd000004bc0ULL, 0x05f0390400005280ULL, 0x000000ff00000340ULL, 0x000401000000cda0ULL,
0x000000ff00000370ULL, 0x000401000000cda8ULL, 0x000000ff00000390ULL, 0x000401000000cdb0ULL,
0x000000ff000003d0ULL, 0x000401000000cdb8ULL, 0x000000ff000003f0ULL, 0x000401000000cdc0ULL,
0x000000ff00000410ULL, 0x000401000000cdc8ULL, 0x000000ff00000430ULL, 0x000401000000cdd0ULL,
0x000000ff00000450ULL, 0x000401000000cdd8ULL, 0x000000ff00000470ULL, 0x000401000000cde0ULL,
0x000000ff00000490ULL, 0x000401000000cde8ULL, 0x000000ff000004b0ULL, 0x000401000000cdf0ULL,
0x000000ff000004d0ULL, 0x000401000000cdf8ULL, 0x000000ff000004f0ULL, 0x000401000000ce00ULL,
0x000000ff00000510ULL, 0x000401000000ce08ULL, 0x000000ff00000530ULL, 0x000401000000ce10ULL,
0x000000ff00000550ULL, 0x000401000000ce18ULL, 0x0000000b000008f0ULL, 0x003f01010000cdd8ULL,
0x0000000b00000920ULL, 0x003f01090000cdd8ULL, 0x0000000200000c10ULL, 0x003f01010000cdb8ULL,
0x0000000200000c30ULL, 0x003f01090000cdb8ULL, 0x0000000200000d80ULL, 0x003f01010000cdc8ULL,
0x0000000200000d90ULL, 0x003f01090000cdc8ULL, 0x00000002000011b0ULL, 0x003f01010000cda8ULL,
0x00000002000011d0ULL, 0x003f01090000cda8ULL, 0x0000000200001cb0ULL, 0x003f01010000cda0ULL,
0x0000000200001d10ULL, 0x003f01010000cdd8ULL, 0x0000000200001d30ULL, 0x003f01010000cde8ULL,
0x0000000200001d40ULL, 0x003f01010000cdf8ULL, 0x0000000200001d50ULL, 0x003f01010000ce08ULL,
0x0000000200001d80ULL, 0x003f01010000ce18ULL, 0x0000000200001d90ULL, 0x003f01090000ce18ULL,
0x0000000b00002250ULL, 0x003f01090000cdd0ULL, 0x0000001100002280ULL, 0x003f01010000cdf0ULL,
0x0000001100002300ULL, 0x003f01090000cdf0ULL, 0x0000000200002380ULL, 0x003f01010000ce18ULL,
0x00000002000025e0ULL, 0x003f01090000ce18ULL, 0x0000000200002810ULL, 0x003f01010000ce18ULL,
0x0000000200002940ULL, 0x003f01090000ce18ULL, 0x0000000200003100ULL, 0x003f01010000ce18ULL,
0x0000000200003150ULL, 0x003f01090000ce18ULL, 0x0000000200003870ULL, 0x003f01010000ce18ULL,
0x0000000200003880ULL, 0x003f01090000ce18ULL, 0x0000000200003950ULL, 0x003f01010000ce18ULL,
0x0000000200003960ULL, 0x003f01090000ce18ULL, 0x0000000800003be0ULL, 0x003f01010000cdf8ULL,
0x0000000800003bf0ULL, 0x003f01010000cdd8ULL, 0x0000000200003c70ULL, 0x003f01010000cda8ULL,
0x0000000200003c90ULL, 0x003f01010000cdb8ULL, 0x0000000200003ca0ULL, 0x003f01010000cdc8ULL,
0x0000000200003cc0ULL, 0x003f01010000ce10ULL, 0x0000000200003cd0ULL, 0x003f01090000ce10ULL,
0x0000000200003cf0ULL, 0x003f01010000cda0ULL, 0x0000000200003d00ULL, 0x003f01090000cda0ULL,
0x0000000200003df0ULL, 0x003f01090000cdb0ULL, 0x0000000200004270ULL, 0x003f01010000cdb8ULL,
0x0000000200004290ULL, 0x003f01090000cdc0ULL, 0x0000000200004690ULL, 0x003f01010000cdc8ULL,
0x0000000200004990ULL, 0x003f01010000ce10ULL, 0x00000002000049d0ULL, 0x003f01090000ce10ULL,
0x0000000200004a00ULL, 0x003f01010000ce10ULL, 0x0000000200004a10ULL, 0x003f01090000ce10ULL,
0x0000001600004ce0ULL, 0x003f01010000cdf8ULL, 0x0000001600004cf0ULL, 0x003f01090000cdf8ULL,
0x0000001600004ec0ULL, 0x003f01010000cdf0ULL, 0x0000000200004ef0ULL, 0x003f01010000cda8ULL,
0x0000000200005030ULL, 0x003f01080000cda0ULL, 0x0000000000005130ULL, 0x003f010000004100ULL,
0x00000000000051a0ULL, 0x003f010000004108ULL, 0x0000000000005250ULL, 0x003f010100004108ULL,
0x0000000300005510ULL, 0x0007010a00004108ULL, 0x000000ff00005620ULL, 0x0008010700004100ULL,
0x00000003000058e0ULL, 0x0007010a00004100ULL, 0x000000ff00005c80ULL, 0x0008010100004108ULL,
0x0000000000005ef0ULL, 0x003f010800004108ULL, 0x0000000000005f00ULL, 0x003f010800004100ULL,
0x0000000b00005f20ULL, 0x003f01090000cdd8ULL, 0x0000000200005f80ULL, 0x003f01090000cdb8ULL,
0x0000000200005fe0ULL, 0x003f01090000cdc8ULL, 0x0000000200006040ULL, 0x003f01090000cda8ULL,
0x00000002000060a0ULL, 0x003f01090000ce18ULL, 0x0000000b00006100ULL, 0x003f01090000cdd0ULL,
0x0000001100006160ULL, 0x003f01090000cdf0ULL, 0x00000002000061c0ULL, 0x003f01090000ce18ULL,
0x0000000200006220ULL, 0x003f01090000ce18ULL, 0x0000000200006280ULL, 0x003f01090000ce18ULL,
0x00000002000062e0ULL, 0x003f01090000ce18ULL, 0x0000000200006340ULL, 0x003f01090000ce10ULL,
0x00000002000063a0ULL, 0x003f01090000cda0ULL, 0x0000000200006400ULL, 0x003f01090000cdb0ULL,
0x0000000200006460ULL, 0x003f01090000cdc0ULL, 0x00000002000064c0ULL, 0x003f01090000ce10ULL,
0x0000000200006520ULL, 0x003f01090000ce10ULL, 0x0000001600006580ULL, 0x003f01090000cdf8ULL,
0x0000000500006610ULL, 0x003f010a00004108ULL, 0x0000000f000066a0ULL, 0x003f010a00004100ULL,
0x00141c0400123803ULL, 0x0000504000000130ULL, 0x00005ec0000050a0ULL, 0x00041e0400005f10ULL,
0x00f8190300000000ULL, 0x0000000d00080a04ULL, 0x0004360400f80210ULL, 0x0000000000000008ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000008ULL, 0x0000000700000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000500000002ULL, 0x0000000000000000ULL, 0x00000000000000d4ULL, 0x0000000c00000002ULL,
0x0000000000006700ULL, 0x0000000000000044ULL, 0x0000000c00000002ULL, 0x0000000000000000ULL,
0x00000000000000aaULL, 0x0000000c00000002ULL, 0x0000000000000000ULL, 0x0000000043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e240000000800ULL, 0x0000000000077919ULL, 0x000e620000002700ULL,
0x00008e00ff027b82ULL, 0x000e620000000a00ULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0x0000000407027825ULL, 0x002fca00078e0002ULL, 0x0000000e02007981ULL, 0x000ea2000c1e1900ULL,
0x00000000001079c3ULL, 0x000e620000002500ULL, 0x0000030000127ab9ULL, 0x000fe20000000800ULL,
0x00000000000472caULL, 0x004fda00000e0000ULL, 0x0000003f04047890ULL, 0x000fc8000fffe03fULL,
0x000000063f117899ULL, 0x000fe40008011604ULL, 0x0000007f0400788cULL, 0x000fe4000bf04070ULL,
0x000000121100728cULL, 0x000fe4000bf21070ULL, 0x000000011200788cULL, 0x000fe40008704070ULL,
0x0000001211067287ULL, 0x000fe40008800000ULL, 0x0000003f10137287ULL, 0x002fc40008000000ULL,
0x0000000106067887ULL, 0x000fc80008000000ULL, 0x000000061300728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000e620000002300ULL, 0x0000000600047d06ULL, 0x000ea20008209000ULL,
0x0000042000007945ULL, 0x000fe20003800000ULL, 0x0000000000087919ULL, 0x000e620000002200ULL,
0x0000000000067919ULL, 0x000eea0000002100ULL, 0x0000000400047308ULL, 0x004ea20000001000ULL,
0x0000000908ff7212ULL, 0x002fc8000780fcffULL, 0x000000200600780cULL, 0x008fda0000705670ULL,
0x00006600ff028b82ULL, 0x000e620000000a00ULL, 0x00000000003f7886ULL, 0x000fe20000020000ULL,
0x0000007002058810ULL, 0x002fc80007f3e0ffULL, 0x00000000050482caULL, 0x000fe200000e0000ULL,
0x000000ffff028224ULL, 0x000fe200008e0603ULL, 0x0000000609ff7212ULL, 0x000fe2000782fe08ULL,
0x0ffffffe04057836ULL, 0x004fc60000000000ULL, 0x00000000020582caULL, 0x000fc600000e0000ULL,
0x0000000500057305ULL, 0x000e68000021f000ULL, 0x00000004ff027e24ULL, 0x000fca000f8e00ffULL,
0x00000000020482caULL, 0x000fe200000e0000ULL, 0x00000005ff037e24ULL, 0x000fca000f8e00ffULL,
0x00000000030582caULL, 0x000fda00000e0000ULL, 0x00000000040099b9ULL, 0x0003e40008040000ULL,
0x0000000000b41947ULL, 0x002fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001ffe8000087882ULL, 0x000fe20000000000ULL,
0x7ffa000000097882ULL, 0x000fe20000000000ULL, 0x001fff00000a7882ULL, 0x000fe20000000000ULL,
0x7ffc0000000b7882ULL, 0x000fe20000000000ULL, 0x001ffefe000c7882ULL, 0x000fe20000000000ULL,
0x7ffbf800000d7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x00cda008043f75b2ULL, 0x000e620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cda808043f75b2ULL, 0x0004620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x001ffe0000087882ULL, 0x004fe20000000000ULL, 0x7ff8000000097882ULL, 0x000fe20000000000ULL,
0x00cdb00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdb80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdc00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdc80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdd00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdd80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cde00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cde80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdf008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdf808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00ce0008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00ce0808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00ce100a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00ce180a043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000050572caULL, 0x000fe200000e0000ULL,
0x800000063f087290ULL, 0x000fe2000fffe03fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000133f077292ULL, 0x000fe2000f8e333fULL, 0x000000ff0900720cULL, 0x000fe20003f05270ULL,
0x0000003f0600728cULL, 0x000fc6000bf65070ULL, 0x0000003f00047c82ULL, 0x000fca0008000000ULL,
0x00000005080872a4ULL, 0x000fc8000f8e023fULL, 0x00000008050872a5ULL, 0x000fe4000f8e0004ULL,
0x0000001106047290ULL, 0x000fc8000fffe007ULL, 0x00000004090872a5ULL, 0x000fce000f8e003fULL,
0x0000000900057c82ULL, 0x000fe40008000000ULL, 0x0000003f05077290ULL, 0x000fe4000fffe13fULL,
0x00000000000879c3ULL, 0x000e640000008800ULL, 0x00000007060772a4ULL, 0x000fc8000f8e0204ULL,
0x000000060700728cULL, 0x000fd6000bf26070ULL, 0x0000000706071290ULL, 0x000fe4000fffe13fULL,
0x0000000105051890ULL, 0x000fe4000fffe03fULL, 0x000000060700728cULL, 0x000fc6000bf46070ULL,
0x0000040000077882ULL, 0x000fe40000000000ULL, 0x0000065408077896ULL, 0x002fcc0008000007ULL,
0x0000000105052890ULL, 0x000fe2000fffe03fULL, 0x00000007ff027e24ULL, 0x000fe2000f8e00ffULL,
0x000000063f05b292ULL, 0x000fc6000f8e333fULL, 0x0000000406427824ULL, 0x000fe200078e0202ULL,
0x0000003400408947ULL, 0x000ff00003800000ULL, 0x00000000000a7919ULL, 0x000e620000002600ULL,
0x000000010900780cULL, 0x000fe20003f05270ULL, 0x000034c000007945ULL, 0x000fd80003800000ULL,
0x0000001400588947ULL, 0x000fea0003800000ULL, 0x000000400600780cULL, 0x000fda0003f06070ULL,
0x0000000400cc8947ULL, 0x000fea0003800000ULL, 0x000000400600780cULL, 0x000fda0003f05270ULL,
0x0000000000d88947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fc80003f0f018ULL, 0x000000600600780cULL, 0x000fda0000705670ULL,
0x0000003400080947ULL, 0x000fea0003800000ULL, 0x0000000107037811ULL, 0x000fe200078e08ffULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x00000013ff077e24ULL, 0x000fe4000f8e00ffULL,
0xffffffffff0c7424ULL, 0x000fe400078e00ffULL, 0x0000000608077c24ULL, 0x000fca000f8e0207ULL,
0x0000001107007c0cULL, 0x000fda000bf06070ULL, 0x00009000ff068b82ULL, 0x000eb00000000800ULL,
0x00008c00ff048b82ULL, 0x000ee20000000a00ULL, 0x0000000603078224ULL, 0x004fe400078e0207ULL,
0x0000001008067824ULL, 0x000fc400078e00ffULL, 0x0000000407048825ULL, 0x008fc600078e0004ULL,
0x0000001006077812ULL, 0x000fe200078ec0ffULL, 0x00000001ff067424ULL, 0x000fe200078e00ffULL,
0x0000000e040c8981ULL, 0x000566000c1e1900ULL, 0x00000001020b7824ULL, 0x000fe200078e0207ULL,
0x0000000108097812ULL, 0x000fc600078ec0ffULL, 0x00cdd8060b0679a7ULL, 0x000ee4000850003fULL,
0x00000010090a7824ULL, 0x142fe400078e0202ULL, 0x0000420009097824ULL, 0x000fe200078e0202ULL,
0x00cdd8070b0075a7ULL, 0x008e64000800017fULL, 0x0000005400788947ULL, 0x006fea0003800000ULL,
0x00000000000c79c3ULL, 0x000e620000002600ULL, 0x00000000090772caULL, 0x000fe200000e0000ULL,
0x00006600000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000000a0972caULL, 0x000fe200000e0000ULL,
0x000000700a147890ULL, 0x000fe2000ff3e03fULL, 0x000000000c0d72caULL, 0x020fe400000e0000ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000000b3f157290ULL, 0x000fe20008ffe43fULL,
0x0000003f000a7c82ULL, 0x000fe40008000000ULL, 0x0000003f000b7c82ULL, 0x000fc60008000000ULL,
0x0000420007087890ULL, 0x000fe4000fffe03fULL, 0x0000cdd009097890ULL, 0x002fd8000fffe03fULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x00000008140075b4ULL, 0x0003d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x0000620007087890ULL, 0x000fe2000fffe03fULL, 0x00000080000a7882ULL, 0x000fd60000000000ULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x00000008140075b4ULL, 0x0003d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x0000000108087836ULL, 0x000fca0000000000ULL,
0x0000000508007c0cULL, 0x000fda000bf06070ULL, 0xfffffffc00448947ULL, 0x001fea000383ffffULL,
0x0000003000407947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000003000340947ULL, 0x000fea0003800000ULL,
0x00006600ff0e7b82ULL, 0x000ea20000000a00ULL, 0x0000900000077ab9ULL, 0x000fe20000000800ULL,
0x000000ffff0a7224ULL, 0x002fe400078e00ffULL, 0x0000000707037c24ULL, 0x000fce000f8e02ffULL,
0x00008c00ff067b82ULL, 0x000e620000000a00ULL, 0x00000013ff057e24ULL, 0x000fe4000f8e00ffULL,
0xffffffffff0c7424ULL, 0x000fe400078e00ffULL, 0x000000060a047c24ULL, 0x000fc8000f8e0205ULL,
0x0000000203057824ULL, 0x000fe200078e0204ULL, 0x0000001104007c0cULL, 0x000fe2000bf46070ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000000405067825ULL, 0x002fd400078e0006ULL,
0x0000000e060ca981ULL, 0x000362000c1e1900ULL, 0x00cdb80b020479a7ULL, 0x000ee2000850003fULL,
0x000000700e087810ULL, 0x004fe20007f3e0ffULL, 0x00cdb805020075a7ULL, 0x008ea4000800017fULL,
0x0000005000cc8947ULL, 0x006ff40003800000ULL, 0x00000000000c79c3ULL, 0x000e620000002600ULL,
0x000000ffff097224ULL, 0x000fe200008e060fULL, 0x00000000020872caULL, 0x000fe200000e0000ULL,
0x000000010a0a7836ULL, 0x000fe20000000000ULL, 0x000000000c0d72caULL, 0x020fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x00000000081472caULL, 0x000fe200000e0000ULL,
0x0000003f000b7c82ULL, 0x000fe20008000000ULL, 0x00000000091572caULL, 0x000fe400000e0000ULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x000000050a007c0cULL, 0x000fc6000bf26070ULL,
0x0000cdb008097890ULL, 0x002fd8000fffe03fULL, 0x00000000003f082fULL, 0x000fe20003860000ULL,
0x00000008140075b4ULL, 0x0003d80008018000ULL, 0x000000000000381cULL, 0x000fe40001f0e170ULL,
0x000000000000781cULL, 0x000fd60003f6e170ULL, 0xfffffffd00ec0947ULL, 0x002fea000393ffffULL,
0xffffffffff0c7424ULL, 0x000fcc00078e00ffULL, 0x0000000e060ca981ULL, 0x000362000c1e1900ULL,
0x00cdc80b020479a7ULL, 0x000ea4000850003fULL, 0x00cdc805020075a7ULL, 0x004ea4000800017fULL,
0x00000050008c8947ULL, 0x006fea0003800000ULL, 0x00000000000c79c3ULL, 0x000e620000002600ULL,
0x00000000020972caULL, 0x000fe200000e0000ULL, 0x00000080000a7882ULL, 0x000fe20000000000ULL,
0x00000000081472caULL, 0x000fe200000e0000ULL, 0x0000003f000b7c82ULL, 0x000fe20008000000ULL,
0x00000000091572caULL, 0x000fe400000e0000ULL, 0x000000000c0d72caULL, 0x020fe400000e0000ULL,
0x000000000000781cULL, 0x000fca0003f0f070ULL, 0x0000200009087890ULL, 0x000fe4000fffe03fULL,
0x0000cdc009097890ULL, 0x002fd8000fffe03fULL, 0x00000000003f082fULL, 0x000fe20003840000ULL,
0x00000008140075b4ULL, 0x0003d80008018000ULL, 0x000000000000281cULL, 0x000fe4000170e170ULL,
0x000000000000781cULL, 0x000fd60003f4e170ULL, 0xfffffffd00ec0947ULL, 0x002fea000393ffffULL,
0xfffffffc00349947ULL, 0x001fea000383ffffULL, 0x0000002c00547947ULL, 0x000fea0003800000ULL,
0x00008800ff107b82ULL, 0x000ea20000000a00ULL, 0x0000840000077ab9ULL, 0x000fe40000000800ULL,
0x0000000707037c24ULL, 0x002fc8000f8e020aULL, 0x0000010003137824ULL, 0x000fc800078e0206ULL,
0x0000001013087825ULL, 0x004fcc00078e0010ULL, 0x0000000e08087981ULL, 0x000f62000c1e9d00ULL,
0x0000004006037836ULL, 0x000fe20000000000ULL, 0x0000027000017945ULL, 0x000fe20003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x000000ff0300780cULL, 0x000fe40003f04070ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000001ff057424ULL, 0x000fd000078e00ffULL, 0x0000000000780947ULL, 0x000fea0003800000ULL,
0x00000040130d7836ULL, 0x000fc80000000000ULL, 0x000000100d0c7825ULL, 0x000fcc00078e0010ULL,
0x0000000e0c0c7981ULL, 0x000f62000c1e9d00ULL, 0x0000008006127836ULL, 0x000fca0000000000ULL,
0x000000ff1200780cULL, 0x000fda0003f24070ULL, 0x0000000000601947ULL, 0x000fea0003800000ULL,
0x000000c006077836ULL, 0x000fca0000000000ULL, 0x000000ff0700780cULL, 0x000fda0003f24070ULL,
0x000000c013159836ULL, 0x000fc80000000000ULL, 0x0000001015149825ULL, 0x000fc800078e0010ULL,
0x0000008013137836ULL, 0x000fe40000000000ULL, 0x0000000e14149981ULL, 0x000ea4000c1e9d00ULL,
0x0000001013107825ULL, 0x000fcc00078e0010ULL, 0x0000000e10107981ULL, 0x000f62000c1e9d00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x00007732141a9816ULL, 0x004fe400000000ffULL, 0x00007732151b9816ULL, 0x000fe400000000ffULL,
0x00007732161c9816ULL, 0x000fe400000000ffULL, 0x00007732171d9816ULL, 0x000fe400000000ffULL,
0x0000ffff14049812ULL, 0x000fc400078ec0ffULL, 0x0000ffff15079812ULL, 0x000fe400078ec0ffULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000ffff16189812ULL, 0x000fe200078ec0ffULL,
0x000000ffff149224ULL, 0x000fe200078e001aULL, 0x0000ffff17199812ULL, 0x000fe400078ec0ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff159224ULL, 0x000fe400078e001bULL,
0x000000ffff169224ULL, 0x000fc400078e001cULL, 0x000000ffff179224ULL, 0x000fce00078e001dULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00cda805021a79a7ULL, 0x000e62000850003fULL,
0x000000ff0600780cULL, 0x000fe20003f44070ULL, 0x00cda81b020075a7ULL, 0x002e64000802017fULL,
0x0000004c00949947ULL, 0x002ff40003800000ULL, 0x00000ab000017945ULL, 0x000fe80003800000ULL,
0x0000000800a42947ULL, 0x000fea0003800000ULL, 0x00007732081a7816ULL, 0x060fe400000000ffULL,
0x0000ffff08087812ULL, 0x000fe400078ec0ffULL, 0x0000001aff1a723eULL, 0x000fe400048032ffULL,
0x00000008ff1d723eULL, 0x000fe400048032ffULL, 0x000076101a1e7816ULL, 0x000fe4000000001eULL,
0x0000ffff091a7812ULL, 0x000fc400078ec0ffULL, 0x00007732091f7816ULL, 0x000fe400000000ffULL,
0x00000001ff087819ULL, 0x000fe40000011606ULL, 0x0000ffff0a097812ULL, 0x040fe400078ec0ffULL,
0x000077320a207816ULL, 0x000fe400000000ffULL, 0x0000ffff0b0a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1d1d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff1e1e7812ULL, 0x000fe400078ec0ffULL,
0x00000005ff1b7819ULL, 0x000fe40000011606ULL, 0x0000000708087812ULL, 0x000fe400078ec0ffULL,
0x00000009ff09723eULL, 0x000fe400048032ffULL, 0x000076041e227816ULL, 0x000fe4000000001dULL,
0x0000000aff0a723eULL, 0x000fc400048032ffULL, 0x0000001b081c7212ULL, 0x000fe400078e3cffULL,
0x00007610091d7816ULL, 0x000fe2000000001dULL, 0x000000ffff097224ULL, 0x100fe200078e001fULL,
0x000076100a1f7816ULL, 0x000fe2000000001fULL, 0x000000ffff0a7224ULL, 0x000fe200078e0020ULL,
0x000077320b0b7816ULL, 0x000fe200000000ffULL, 0x000000081b1b7824ULL, 0x000fe200078e021cULL,
0x00000009ff1c723eULL, 0x000fe400048032ffULL, 0x0000001006097812ULL, 0x000fc400078ec0ffULL,
0x0000000aff0a723eULL, 0x000fe400048032ffULL, 0x0000000bff20723eULL, 0x000fe400048032ffULL,
0x00000004ff0b7819ULL, 0x000fe40000011609ULL, 0x0000001aff1a723eULL, 0x000fe400048032ffULL,
0x000076100a1e7816ULL, 0x000fe2000000001eULL, 0x000004000b0a7824ULL, 0x000fe200078e0202ULL,
0x000000ff1a0b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL,
0x000000101b1a7824ULL, 0x000fe200078e020aULL, 0x000000ff1f1f7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff1c1c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff1e1e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff20207812ULL, 0x000fe400078ec0ffULL, 0x0000000106097812ULL, 0x000fc400078ec0ffULL,
0x000076041c0b7816ULL, 0x000fe4000000000bULL, 0x000076041e1e7816ULL, 0x000fe2000000001dULL,
0x00000008091a7824ULL, 0x000fe200078e021aULL, 0x00007604201f7816ULL, 0x000fe4000000001fULL,
0x0000541022227816ULL, 0x000fe4000000000bULL, 0x000054101e237816ULL, 0x000fca000000001fULL,
0x00c400221a007388ULL, 0x0003e20000000a00ULL, 0x0000000400e00947ULL, 0x000fea0003800000ULL,
0x000077320c0b7816ULL, 0x040fe400000000ffULL, 0x0000ffff0c0c7812ULL, 0x000fe400078ec0ffULL,
0x0000000bff1b723eULL, 0x000fe400048032ffULL, 0x0000ffff0d0b7812ULL, 0x040fe400078ec0ffULL,
0x000077320d1c7816ULL, 0x000fe400000000ffULL, 0x0000000cff0c723eULL, 0x000fc400048032ffULL,
0x00000005ff0d7819ULL, 0x000fe40000011603ULL, 0x0000ffff0e037812ULL, 0x040fe400078ec0ffULL,
0x000077320e1d7816ULL, 0x000fe400000000ffULL, 0x000076100c1a7816ULL, 0x002fe4000000001aULL,
0x0000000d080e7212ULL, 0x000fe400078e3cffULL, 0x000077320f1f7816ULL, 0x000fc400000000ffULL,
0x0000ffff0f0c7812ULL, 0x000fe200078ec0ffULL, 0x000000080d0f7824ULL, 0x000fe200078e020eULL,
0x000000ff1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e001fULL,
0x0000ffff1b1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000bff0b723eULL, 0x000fe400048032ffULL,
0x00000003ff03723eULL, 0x000fe400048032ffULL, 0x000076041b1e7816ULL, 0x000fc4000000001aULL,
0x000076100b0e7816ULL, 0x000fe2000000000eULL, 0x000000ffff0b7224ULL, 0x000fe200078e001dULL,
0x00007610031a7816ULL, 0x000fe2000000001aULL, 0x000000ffff037224ULL, 0x000fe200078e001cULL,
0x0000000dff0d723eULL, 0x000fe400048032ffULL, 0x0000000cff0c723eULL, 0x000fe400048032ffULL,
0x00000003ff03723eULL, 0x000fe400048032ffULL, 0x0000000bff0b723eULL, 0x000fc400048032ffULL,
0x000076100d1b7816ULL, 0x000fe4000000001bULL, 0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1a1a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff0c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000100f0c7824ULL, 0x000fe200078e020aULL, 0x0000ffff03037812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000008090c7824ULL, 0x000fe200078e020cULL,
0x0000ffff1b1c7812ULL, 0x000fc400078ec0ffULL, 0x0000760403037816ULL, 0x000fe4000000000eULL,
0x000076040b1a7816ULL, 0x000fe4000000001aULL, 0x000076041c0d7816ULL, 0x000fe4000000000dULL,
0x000054101e1e7816ULL, 0x000fe40000000003ULL, 0x000054101a1f7816ULL, 0x000fe2000000000dULL,
0x00000080060d7836ULL, 0x000fc80000000000ULL, 0x00c4001e0c007388ULL, 0x0003e20000000a00ULL,
0x000000ff0d00780cULL, 0x000fda0003f04070ULL, 0x0000000400280947ULL, 0x002fea0003800000ULL,
0x0000773210037816ULL, 0x040fe400000000ffULL, 0x0000ffff10107812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0b723eULL, 0x000fe400048032ffULL, 0x00000005ff0d7819ULL, 0x000fe4000001160dULL,
0x0000ffff11037812ULL, 0x000fe400078ec0ffULL, 0x000076100b117816ULL, 0x000fc40000000011ULL,
0x00000010ff0f723eULL, 0x000fe400048032ffULL, 0x0000ffff130c7812ULL, 0x040fe400078ec0ffULL,
0x0000000d080e7212ULL, 0x000fe400078e3cffULL, 0x0000ffff120b7812ULL, 0x000fe400078ec0ffULL,
0x0000773213137816ULL, 0x000fe400000000ffULL, 0x00007732111b7816ULL, 0x000fc400000000ffULL,
0x000000ff0f107812ULL, 0x000fe200078ec0ffULL, 0x000000080d0f7824ULL, 0x000fe200078e020eULL,
0x0000ffff11117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000773212127816ULL, 0x000fe400000000ffULL, 0x00000003ff03723eULL, 0x000fe400048032ffULL,
0x0000000bff0b723eULL, 0x000fe400048032ffULL, 0x00007604111a7816ULL, 0x000fc40000000010ULL,
0x00007610030e7816ULL, 0x000fe2000000000eULL, 0x000000ffff037224ULL, 0x000fe200078e001bULL,
0x000076100b107816ULL, 0x000fe20000000010ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0012ULL,
0x0000000dff0d723eULL, 0x000fe400048032ffULL, 0x0000000cff0c723eULL, 0x000fe400048032ffULL,
0x00000003ff03723eULL, 0x000fe400048032ffULL, 0x0000000bff0b723eULL, 0x000fc400048032ffULL,
0x000076100d117816ULL, 0x000fe40000000011ULL, 0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff10107812ULL, 0x000fe400078ec0ffULL, 0x000000ff0c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000100f0c7824ULL, 0x000fe200078e020aULL, 0x0000ffff03037812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000008090c7824ULL, 0x000fe200078e020cULL,
0x0000ffff11127812ULL, 0x000fc400078ec0ffULL, 0x0000760403037816ULL, 0x000fe4000000000eULL,
0x000076040b107816ULL, 0x000fe40000000010ULL, 0x00007604120d7816ULL, 0x000fe4000000000dULL,
0x000054101a1a7816ULL, 0x000fe20000000003ULL, 0x000000c006037836ULL, 0x000fe20000000000ULL,
0x00005410101b7816ULL, 0x000fc8000000000dULL, 0x000000ff0300780cULL, 0x000fe20003f04070ULL,
0x00c4001a0c007388ULL, 0x0003d80000000a00ULL, 0x0000000000700947ULL, 0x002fea0003800000ULL,
0x00000005ff037819ULL, 0x000fe40000011603ULL, 0x00000007ff06723eULL, 0x000fe400048032ffULL,
0x0000000308087212ULL, 0x000fe400078e3cffULL, 0x00000019ff0c723eULL, 0x000fe400048032ffULL,
0x00000017ff0d723eULL, 0x000fe200048032ffULL, 0x0000000803037824ULL, 0x000fe200078e0208ULL,
0x00000018ff08723eULL, 0x000fc400048032ffULL, 0x00000016ff0b723eULL, 0x000fe200048032ffULL,
0x00000010030a7824ULL, 0x000fe200078e020aULL, 0x00000004ff03723eULL, 0x000fe400048032ffULL,
0x00000015ff07723eULL, 0x000fe200048032ffULL, 0x00000008090a7824ULL, 0x000fe200078e020aULL,
0x00000014ff04723eULL, 0x000fe400048032ffULL, 0x000000ff0c0c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0d0d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x000000ff06067812ULL, 0x000fe400078ec0ffULL, 0x0000ffff07077812ULL, 0x000fe400078ec0ffULL,
0x000000ff03037812ULL, 0x000fe400078ec0ffULL, 0x0000ffff04047812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0b0b7812ULL, 0x000fc400078ec0ffULL, 0x000076040d0c7816ULL, 0x000fe4000000000cULL,
0x0000760407067816ULL, 0x000fe40000000006ULL, 0x0000760404037816ULL, 0x000fe40000000003ULL,
0x000076040b0b7816ULL, 0x000fe40000000008ULL, 0x0000541003067816ULL, 0x000fe40000000006ULL,
0x000054100b077816ULL, 0x000fca000000000cULL, 0x00c400060a007388ULL, 0x0003e40000000a00ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00cda00502ff79a7ULL, 0x0005e2000850003fULL,
0x0000001c00d07947ULL, 0x000fea0003800000ULL, 0x00009400ff087b82ULL, 0x000ea40000000a00ULL,
0x0000000e08087981ULL, 0x004562000c1e9900ULL, 0x000000070600780cULL, 0x000fe20003f04070ULL,
0x00000001ff057424ULL, 0x000fc800078e00ffULL, 0x00cdd80502ff79a7ULL, 0x0005f0000850003fULL,
0xff800000ff038424ULL, 0x000fe200078e00ffULL, 0x00cde80502ff79a7ULL, 0x0005e2000850003fULL,
0x00cdf80502ff79a7ULL, 0x0005e2000850003fULL, 0x00ce080502ff79a7ULL, 0x0005e4000850003fULL,
0x00cd600342008388ULL, 0x0005e80000000800ULL, 0x00cd80ff42008388ULL, 0x0005e20000000800ULL,
0x00ce1805020479a7ULL, 0x000ee4000850003fULL, 0x00ce1805020075a7ULL, 0x008ee4000800017fULL,
0x0000004000bc8947ULL, 0x00cfea0003800000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x000000040600728cULL, 0x000fe2000bf24070ULL,
0x00000005ff037819ULL, 0x000fca0000011606ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000001c00800947ULL, 0x000fea0003800000ULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x0000920000077ab9ULL, 0x000fe20000000800ULL, 0x0000000807077c24ULL, 0x002fe2000f8e020aULL,
0x00000007080772a4ULL, 0x000fe2000f8e023fULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000c000000a7ab9ULL, 0x000fe20000000a00ULL, 0x3b12492508417820ULL, 0x020fe20000410000ULL,
0x00000000071572caULL, 0x000fe200000e0000ULL, 0x00000fff07087891ULL, 0x000fe2000f8e103fULL,
0x0000000aff4a7e24ULL, 0x000fe2000f8e00ffULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000bff4b7e24ULL, 0x000fe2000f8e00ffULL, 0xfffff00008087892ULL, 0x000fe2000f8ec03fULL,
0x0000000403407836ULL, 0x040fe20000000000ULL, 0x00008600000c7ab9ULL, 0x000fe20000000a00ULL,
0x0000001003087824ULL, 0x040fe200078e00ffULL, 0x000000ff0600720cULL, 0x000fe20000722270ULL,
0x0000000c033e7836ULL, 0x040fe20000000000ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000040083c7836ULL, 0x040fe20000000000ULL, 0x00000012151472a4ULL, 0x000fe2000f8e0210ULL,
0x00000080083b7836ULL, 0x040fe20000000000ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000c0083a7836ULL, 0x000fe20000000000ULL, 0x0000001408097291ULL, 0x000fe2000f8fd03fULL,
0x00000008033f7836ULL, 0x000fe20000000000ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000009ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000000612097899ULL, 0x000fe2000800063fULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000805057824ULL, 0x000fe200078e0206ULL,
0x00000009070972a4ULL, 0x000fe2000f8e0208ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000315077899ULL, 0x000fe2000800063fULL, 0x00000008054a7825ULL, 0x000fe200078e004aULL,
0x0000001f06057812ULL, 0x040fe200078ec0ffULL, 0x00000fff09097890ULL, 0x000fe2000fffe03fULL,
0x000000080600780cULL, 0x000fe20000701070ULL, 0x00000200070c78a5ULL, 0x000fe2000f8e000cULL,
0x00000001ff057819ULL, 0x000fe20000011605ULL, 0x0000001409097291ULL, 0x000fe2000f8fa03fULL,
0x00000003ff3d7819ULL, 0x000fe2000001163eULL, 0xffffffff05167890ULL, 0x000fe2000fffe03fULL,
0x0000000305397812ULL, 0x000fe200078e7803ULL, 0x0000000309097899ULL, 0x000fe2000800063fULL,
0x0000000305057812ULL, 0x000fc400078e7840ULL, 0x0000000839397212ULL, 0x000fe200078efcffULL,
0x00000200090878a5ULL, 0x000fe2000f8e000aULL, 0x00000004ff3c7819ULL, 0x000fe2000001163cULL,
0x0000001040387824ULL, 0x000fe200078e0205ULL, 0x00000004ff3b7819ULL, 0x000fe2000001163bULL,
0x00000004150a78a5ULL, 0x000fe2000f8e000aULL, 0x00000004ff3a7819ULL, 0x000fe2000001163aULL,
0x0000000c08177287ULL, 0x000fe40008000000ULL, 0x0000000d090d7287ULL, 0x002fd80008000000ULL,
0x0000001007057824ULL, 0x040fe200078e00ffULL, 0x0000000107437812ULL, 0x000fe200078ec0ffULL,
0x00000080ff087424ULL, 0x000fe200078e00ffULL, 0x0000008000017945ULL, 0x000fe40003800000ULL,
0x0000001005057812ULL, 0x000fe200078ec0ffULL, 0x0000001043117824ULL, 0x000fc800078e0202ULL,
0x00000001020b7824ULL, 0x000fe400078e0205ULL, 0x00000001ff057424ULL, 0x000fe400078e00ffULL,
0x00cdd0080b0879a7ULL, 0x000e64000800003fULL, 0x00cdd0090b0075a7ULL, 0x002e64000804017fULL,
0x0000003c00a4a947ULL, 0x002fea0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00cdf005110879a7ULL, 0x000e62000850003fULL, 0x000000070400780cULL, 0x000fe20003f44070ULL,
0x0000008000017945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fd200078e00ffULL, 0x00000020430ba824ULL, 0x100fe400078e0202ULL,
0x000000040410a824ULL, 0x040fe400078e0202ULL, 0x00000004040da824ULL, 0x000fe200078e020bULL,
0x00cdf009110075a7ULL, 0x002e64000806017fULL, 0x0000003c0090b947ULL, 0x002fea0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00cc00000d0aa984ULL, 0x000fe20000000800ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x00000004040ca824ULL, 0x000fe200078e0202ULL,
0x00cd6000100fa984ULL, 0x000e680000000800ULL, 0x00cd80000c0ba984ULL, 0x0004a20000000800ULL,
0x00ce1805020879a7ULL, 0x0004a4000850003fULL, 0x0000000a0f00720bULL, 0x006fda0003f7e000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00000000000e7806ULL, 0x000fc800058e0100ULL,
0x000000ff0e00720cULL, 0x000fda0003f65270ULL, 0x00000000007cb947ULL, 0x000fea0003800000ULL,
0x8000000a0f0f7221ULL, 0x000fe20000010000ULL, 0x000000550eff7812ULL, 0x040fe4000786c0ffULL,
0x000000aa0eff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b0f0f7820ULL, 0x000fcc0000410000ULL,
0x0000000f000f7308ULL, 0x000e680000000800ULL, 0x00000000002cb947ULL, 0x000fea0003800000ULL,
0x00000002040c7824ULL, 0x000fca00078e00ffULL, 0x000000060c0c7812ULL, 0x000fca00078ec0ffULL,
0x00001f0c0f0d7589ULL, 0x002e6400000e0000ULL, 0x0000000d24247220ULL, 0x082fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x000fce0000410000ULL, 0x000000000030c947ULL, 0x000fea0003800000ULL,
0x00000002040c7824ULL, 0x000fca00078e00ffULL, 0x000000060c0c7812ULL, 0x000fca00078ec0ffULL,
0x000000010c0c7836ULL, 0x000fcc0000000000ULL, 0x00001f0c0f0c7589ULL, 0x002e6400000e0000ULL,
0x0000000c25257220ULL, 0x082fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c19197220ULL, 0x080fe20000410000ULL, 0x0000000c1b1b7220ULL, 0x000fce0000410000ULL,
0x0000000f0b0b7220ULL, 0x002fce0000410000ULL, 0x0000006000017945ULL, 0x000fe20003800000ULL,
0x00ce1809020075a7ULL, 0x000262000806017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000b95dULL, 0x000fea0003900000ULL, 0x00ce18090200b5a7ULL, 0x000e24000806007fULL,
0xfffffffc00ecb947ULL, 0x001fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000030300780cULL, 0x000fe20003f65270ULL, 0x000001b000017945ULL, 0x000fd80003800000ULL,
0x0000000000643947ULL, 0x000fea0003800000ULL, 0x000000ff0e00720cULL, 0x000fe20001762670ULL,
0x000000804309a824ULL, 0x140fe400078e0202ULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x00000080430da824ULL, 0x140fe400078e0202ULL, 0x000000040409a824ULL, 0x000fe400078e0209ULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x000000804311a824ULL, 0x000fc400078e0202ULL,
0x00000004040fb824ULL, 0x140fe400078e0202ULL, 0x000000040410a824ULL, 0x040fe400078e020dULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x00cd600a0f00b388ULL, 0x000fe20000000800ULL,
0x000000804313a824ULL, 0x000fe400078e0202ULL, 0x000000040411a824ULL, 0x000fe200078e0211ULL,
0x00cc4000090ca984ULL, 0x000e620000000800ULL, 0x000000ffff0d7224ULL, 0x000fc400078e00ffULL,
0x000000040413a824ULL, 0x000fe200078e0213ULL, 0x00cc60001008a984ULL, 0x000ea80000000800ULL,
0x00cc8000110ea984ULL, 0x000ee80000000800ULL, 0x00cca000130da984ULL, 0x000f220000000800ULL,
0x0000000c0b0b7221ULL, 0x002fc80000010000ULL, 0x000000080b0b7221ULL, 0x004fe20000010000ULL,
0x000000040408a824ULL, 0x000fc600078e0202ULL, 0x0000000e0b0e7221ULL, 0x008fc80000010000ULL,
0x0000000d0e0d7221ULL, 0x010fca0000010000ULL, 0x00cd800d0800a388ULL, 0x0003e40000000800ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00ce1805020879a7ULL, 0x002e62000850003fULL,
0x0000420043437824ULL, 0x000fe200078e0202ULL, 0x00000008ff0d7819ULL, 0x000fe20000011606ULL,
0x00000008040f7824ULL, 0x040fe200078e00ffULL, 0x00000003ff477819ULL, 0x000fe20000011640ULL,
0x00004200430a7836ULL, 0x000fe20000000000ULL, 0x00000003ff0b7819ULL, 0x000fe2000001163fULL,
0x0000000804107824ULL, 0x000fe200078e00ffULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000020000d487824ULL, 0x100fe400078e020aULL, 0x0000200047477824ULL, 0x000fc400078e020aULL,
0x000020000b467824ULL, 0x100fe200078e020aULL, 0x00000004480c7211ULL, 0x080fe200078fc8ffULL,
0x0000000804117824ULL, 0x000fe200078e00ffULL, 0x00000004470b7211ULL, 0x080fe200078fc8ffULL,
0x000020003d457824ULL, 0x000fe200078e020aULL, 0x000000030c0c7212ULL, 0x000fe400078e3cffULL,
0x00000004460e7211ULL, 0x000fe400078fc8ffULL, 0x000000400b0d7212ULL, 0x000fe200078e3cffULL,
0x00ce1809020075a7ULL, 0x002e62000804017fULL, 0xfffffff80f0b7812ULL, 0x000fc400078ee20cULL,
0x0000003f0e0e7212ULL, 0x000fe400078e3cffULL, 0xfffffff8100a7812ULL, 0x000fe200078ee20dULL,
0x000000100b147824ULL, 0x000fe200078e0248ULL, 0xfffffff8110d7812ULL, 0x000fe400078ee20eULL,
0x00000004450f7211ULL, 0x000fe200078fc8ffULL, 0x000000380000a947ULL, 0x002fec0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000003e0f0f7212ULL, 0x000fe200078e3cffULL, 0x000000100a107824ULL, 0x000fe200078e0247ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000001414783bULL, 0x000e620000004200ULL,
0x000000100d0d7824ULL, 0x000fe200078e0246ULL, 0xfffffff808087812ULL, 0x000fe200078ee20fULL,
0x0000400043447836ULL, 0x040fe20000000000ULL, 0x000000001010783bULL, 0x000ea20000004200ULL,
0x0000402043437836ULL, 0x000fc40000000000ULL, 0x0000001008087824ULL, 0x000fe200078e0245ULL,
0x000000000d0c783bULL, 0x000fe20000004200ULL, 0x000001f044ff7812ULL, 0x000fe4000784c0ffULL,
0x0003fff043437812ULL, 0x000fe400078ec0ffULL, 0x000000000808783bULL, 0x000ee40000004200ULL,
0x00000004ff437819ULL, 0x000fe40000011643ULL, 0x0000624014347816ULL, 0x002fc40000000015ULL,
0x0000735114357816ULL, 0x000fe40000000015ULL, 0x0000624016367816ULL, 0x140fe40000000017ULL,
0x0000735116377816ULL, 0x000fe40000000017ULL, 0x0000624010307816ULL, 0x144fe40000000011ULL,
0x0000735110317816ULL, 0x000fe40000000011ULL, 0x0000624012327816ULL, 0x000fc40000000013ULL,
0x0000624008287816ULL, 0x148fe40000000009ULL, 0x0000735108297816ULL, 0x000fe40000000009ULL,
0x0003fff044087812ULL, 0x000fe400078ec0ffULL, 0x0000735112337816ULL, 0x000fe40000000013ULL,
0x00000004ff087819ULL, 0x000fe40000011608ULL, 0x000062400c2c7816ULL, 0x000fc4000000000dULL,
0x00003f00084d7812ULL, 0x000fe400078ec0ffULL, 0x000073510c2d7816ULL, 0x000fe4000000000dULL,
0x000000ff4d4c7812ULL, 0x000fe200078ef808ULL, 0x0000040044087824ULL, 0x000fe200078e00ffULL,
0x000062400e2e7816ULL, 0x140fe4000000000fULL, 0x000073510e2f7816ULL, 0x000fe4000000000fULL,
0x000e000008087812ULL, 0x000fc400078ec0ffULL, 0x000062400a2a7816ULL, 0x100fe4000000000bULL,
0x8000002008087812ULL, 0x000fe400078efcffULL, 0x000073510a2b7816ULL, 0x000fe4000000000bULL,
0x80000020084d7807ULL, 0x000fe20001000000ULL, 0x0000002004087836ULL, 0x000fe20000000000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x000000004c1a72caULL, 0x000fe400000e0000ULL,
0x000000004d1b72caULL, 0x000fe200000e0000ULL, 0x00000008080d7824ULL, 0x000fe200078e00ffULL,
0x00000008480a7211ULL, 0x080fe200078fc8ffULL, 0x00000008080e7824ULL, 0x000fe200078e00ffULL,
0x0000000847097211ULL, 0x000fc400078fc8ffULL, 0x000000030a0a7212ULL, 0x000fe400078e3cffULL,
0x00000040090b7212ULL, 0x000fe400078e3cffULL, 0x00000008460c7211ULL, 0x000fe400078fc8ffULL,
0xfffffff80d097812ULL, 0x000fe200078ee20aULL, 0x0000001834247df3ULL, 0x000fe20008700824ULL,
0x000000004c1a72caULL, 0x000fe400000e0000ULL, 0x000000004d1b72caULL, 0x000fe200000e0000ULL,
0x0000001009147824ULL, 0x000fe200078e0248ULL, 0xfffffff80e0a7812ULL, 0x000fe200078ee20bULL,
0x00000008080b7824ULL, 0x000fe200078e00ffULL, 0x0000003f0c0c7212ULL, 0x000fc400078e3cffULL,
0x0000001607007c0cULL, 0x000fe2000bf45270ULL, 0x000000100a107824ULL, 0x000fe200078e0247ULL,
0xfffffff80b097812ULL, 0x000fe400078ee20cULL, 0x00000008450b7211ULL, 0x000fe200078fc8ffULL,
0x0000000808087824ULL, 0x000fe400078e00ffULL, 0x0000001830207df3ULL, 0x000fe20008700820ULL,
0x000000004c1a72caULL, 0x000fe200000e0000ULL, 0x00000010090c7824ULL, 0x000fe200078e0246ULL,
0x000000004d1b72caULL, 0x000fc400000e0000ULL, 0x0000003e0b0b7212ULL, 0x000fc800078e3cffULL,
0xfffffff808087812ULL, 0x000fca00078ee20bULL, 0x0000001008087824ULL, 0x000fe400078e0245ULL,
0x000000182c1c7df3ULL, 0x000fe2000870081cULL, 0x000000004c1a72caULL, 0x000fe400000e0000ULL,
0x000000004d1b72caULL, 0x000fda00000e0000ULL, 0x0000001828187df3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x000000001414783bULL, 0x000e680000004200ULL,
0x000000001010783bULL, 0x000ea80000004200ULL, 0x000000000c0c783bULL, 0x000fe80000004200ULL,
0x000000000808783bULL, 0x000ee20000004200ULL, 0x0000624014347816ULL, 0x002fc40000000015ULL,
0x0000735114357816ULL, 0x000fe40000000015ULL, 0x0000624016367816ULL, 0x140fe40000000017ULL,
0x0000735116377816ULL, 0x000fe40000000017ULL, 0x0000624010307816ULL, 0x144fe40000000011ULL,
0x0000735110317816ULL, 0x000fe40000000011ULL, 0x0000624008287816ULL, 0x008fc40000000009ULL,
0x0000735108297816ULL, 0x000fe20000000009ULL, 0x000000ffff097224ULL, 0x000fe200078e004dULL,
0x00003f0043087812ULL, 0x000fe400078ec0ffULL, 0x0000624012327816ULL, 0x140fe40000000013ULL,
0x0000735112337816ULL, 0x000fe40000000013ULL, 0x000062400c2c7816ULL, 0x140fe4000000000dULL,
0x000073510c2d7816ULL, 0x000fc4000000000dULL, 0x000062400e2e7816ULL, 0x140fe4000000000fULL,
0x000073510e2f7816ULL, 0x000fe4000000000fULL, 0x000062400a2a7816ULL, 0x140fe4000000000bULL,
0x000073510a2b7816ULL, 0x000fe4000000000bULL, 0x000000ff08087812ULL, 0x000fe400078ef843ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000000091b72caULL, 0x000fc400000e0000ULL,
0x00000000081a72caULL, 0x000fda00000e0000ULL, 0x0000001834247df3ULL, 0x000fe20008700824ULL,
0x00000000081a72caULL, 0x000fe400000e0000ULL, 0x00000000091b72caULL, 0x000fda00000e0000ULL,
0x0000001830207df3ULL, 0x000fe20008700820ULL, 0x00000000081a72caULL, 0x000fe400000e0000ULL,
0x00000000091b72caULL, 0x000fda00000e0000ULL, 0x000000182c1c7df3ULL, 0x000fe2000870081cULL,
0x00000000081a72caULL, 0x000fe400000e0000ULL, 0x00000000091b72caULL, 0x000fda00000e0000ULL,
0x0000001828187df3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00000ab000017945ULL, 0x000fe80003800000ULL, 0x0000000800a42947ULL, 0x000fea0003800000ULL,
0x00ce1805020879a7ULL, 0x000e62000850003fULL, 0x0000000804137824ULL, 0x000fe200078e00ffULL,
0x0000005000027945ULL, 0x000fe80003800000ULL, 0x0000001813137812ULL, 0x000fca00078ec0ffULL,
0x0000000102127824ULL, 0x000fe200078e0213ULL, 0x00ce1809020075a7ULL, 0x002e64000804017fULL,
0x00000030002ca947ULL, 0x002fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00cd800012087984ULL, 0x000e620000000a00ULL, 0x00000008ff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x0000018000027945ULL, 0x000fe20003800000ULL, 0x00000009ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x00cd6000420f0984ULL, 0x000fe20000000800ULL, 0x00000009ff0d7e24ULL, 0x000fe4000f8e00ffULL,
0x00000017ff107e24ULL, 0x000fe2000f8e00ffULL, 0x00cd8000420e0984ULL, 0x000ea20000000800ULL,
0x0000000dff117e24ULL, 0x000fe4000f8e00ffULL, 0x000000ffff100224ULL, 0x000fc400078e000cULL,
0x000000ffff110224ULL, 0x000fe400078e000bULL, 0x01800000080a7836ULL, 0x002fca0000000000ULL,
0x7f8000000a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000e4a000986ULL, 0x0043e6000c101b0eULL,
0x01ffffff0a00780cULL, 0x000fe20003f44070ULL, 0x00000008ff0a7e24ULL, 0x000fd8000f8e00ffULL,
0x0000000000142947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0008ULL,
0x000032c0000d7802ULL, 0x000fce0000000f00ULL, 0x0000003400107944ULL, 0x001fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0008ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x00000008000b7308ULL, 0x000e640000001000ULL, 0xbf800000080a7423ULL, 0x002fc8000000000bULL,
0x800000ff0a0a7221ULL, 0x000fc80000010100ULL, 0x0000000a0b0c7223ULL, 0x000fce000000000bULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0180000009087836ULL, 0x000fe20000000000ULL,
0x000000c000027945ULL, 0x000fe80003800000ULL, 0x7f80000008087812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0800780cULL, 0x000fda0003f44070ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0009ULL, 0x000033b0000d7802ULL, 0x000fce0000000f00ULL,
0x0000003000d47944ULL, 0x001fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000900087308ULL, 0x000e640000001000ULL, 0xbf800000090a7423ULL, 0x002fc80000000008ULL,
0x800000ff0a0b7221ULL, 0x000fc80000010100ULL, 0x0000000b08087223ULL, 0x000fce0000000008ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000c41097220ULL, 0x040fe20000410000ULL,
0x00000008410a7220ULL, 0x004fe20000410000ULL, 0x00000002ff087819ULL, 0x000fe40000011604ULL,
0x0000000924247220ULL, 0x080fe20000410000ULL, 0x0000000a25257220ULL, 0x080fe20000410000ULL,
0x0000000926267220ULL, 0x080fe20000410000ULL, 0x0000000a27277220ULL, 0x000fe20000410000ULL,
0x0000000920207220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x000000091c1c7220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x000000091a1a7220ULL, 0x000fe20000410000ULL,
0x000000242509723eULL, 0x000fe200000000ffULL, 0x0000000a21217220ULL, 0x000fe20000410000ULL,
0x000000262712723eULL, 0x000fe200000000ffULL, 0x0000000a23237220ULL, 0x080fe20000410000ULL,
0x0000000a1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000a1f1f7220ULL, 0x000fe20000410000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000000909723aULL, 0x000fe20000000000ULL,
0x00000020210e723eULL, 0x000fe200000000ffULL, 0x0000000a19197220ULL, 0x000fe20000410000ULL,
0x00000022230f723eULL, 0x000fe200000000ffULL, 0x000000001212723aULL, 0x000e620000000000ULL,
0x0000001c1d0d723eULL, 0x000fe200000000ffULL, 0x0000000a1b1b7220ULL, 0x000fe20000410000ULL,
0x0000001e1f0c723eULL, 0x000fe200000000ffULL, 0x000000000e0e723aULL, 0x000fe20000000000ULL,
0x0000000303157812ULL, 0x000fc400078e7808ULL, 0x00000018190b723eULL, 0x000fe200000000ffULL,
0x000000000f0f723aULL, 0x000ea20000000000ULL, 0x0000001a1b0a723eULL, 0x000fe200000000ffULL,
0x0000001008157824ULL, 0x040fe200078e0215ULL, 0x000000033c177812ULL, 0x000fe200078e7808ULL,
0x000000000d0d723aULL, 0x000fe20000000000ULL, 0x000000033b297812ULL, 0x000fe400078e7808ULL,
0x000000033a2b7812ULL, 0x000fe200078e7808ULL, 0x000000000c0c723aULL, 0x000ee20000000000ULL,
0x0000001008177824ULL, 0x000fc400078e0217ULL, 0x0000001008297824ULL, 0x040fe200078e0229ULL,
0x000000000b0b723aULL, 0x000fe20000000000ULL, 0x00000010082b7824ULL, 0x000fe400078e022bULL,
0x0000002015087824ULL, 0x100fe200078e0244ULL, 0x000000000a0a723aULL, 0x000f220000000000ULL,
0x0000002017167824ULL, 0x000fe200078e0244ULL, 0x000001b000027945ULL, 0x000fe20003800000ULL,
0x0000000113147824ULL, 0x000fe200078e0208ULL, 0x0000541009087816ULL, 0x002fe20000000012ULL,
0x0000000113167824ULL, 0x000fe200078e0216ULL, 0x0000763209097816ULL, 0x000fe20000000012ULL,
0x0000002029287824ULL, 0x000fc400078e0244ULL, 0x000000202b2a7824ULL, 0x000fe400078e0244ULL,
0x0000000814007388ULL, 0x0005e20000000a00ULL, 0x0000000113287824ULL, 0x040fe400078e0228ULL,
0x00000001132a7824ULL, 0x000fe200078e022aULL, 0x000054100e087816ULL, 0x144fe4000000000fULL,
0x000076320e097816ULL, 0x000fca000000000fULL, 0x0000000816007388ULL, 0x0007e40000000a00ULL,
0x000054100d087816ULL, 0x148fe4000000000cULL, 0x000076320d097816ULL, 0x000fe2000000000cULL,
0x00000020390c7824ULL, 0x100fe200078e0244ULL, 0x00000001060d7812ULL, 0x000fe200078ec0ffULL,
0x0000002038447824ULL, 0x000fe400078e0244ULL, 0x0000000828007388ULL, 0x0009e40000000a00ULL,
0x000000100d147824ULL, 0x000fc400078e020cULL, 0x000000100d0c7824ULL, 0x000fe200078e0244ULL,
0x000054100b087816ULL, 0x150fe4000000000aULL, 0x000076320b097816ULL, 0x000fca000000000aULL,
0x000000082a007388ULL, 0x0003e20000000a00ULL, 0x00ce1805020a79a7ULL, 0x000ea4000850003fULL,
0x00ce180b020075a7ULL, 0x004ea4000804017fULL, 0x000000280078a947ULL, 0x006fea0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000014087984ULL, 0x000e620000000c00ULL,
0x0000001003107211ULL, 0x040fe200078448ffULL, 0x000000b000027945ULL, 0x000fe20003800000ULL,
0x0000001f06137812ULL, 0x000fe200078ec0ffULL, 0x000000000c0c7984ULL, 0x000ea20000000c00ULL,
0x0000001103117211ULL, 0x000fe400010f4cffULL, 0x0000001013107211ULL, 0x000fca00078620ffULL,
0x000000ffff117224ULL, 0x000fca00018e0611ULL, 0x0000000810007986ULL, 0x0023e8000c101d0eULL,
0x0008000c10007986ULL, 0x0043e2000c101d0eULL, 0x00ce1805021279a7ULL, 0x000ea4000850003fULL,
0x00ce1813020075a7ULL, 0x004ea4000804017fULL, 0x000000280058a947ULL, 0x006fea0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000000007c9947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000000000077886ULL, 0x000fe200038e0100ULL,
0x0000000aff087e24ULL, 0x000fe2000f8e00ffULL, 0x00000007000d7d00ULL, 0x000e6200080e0000ULL,
0x0000000bff097e24ULL, 0x000fce000f8e00ffULL, 0x00000007000b7d09ULL, 0x000ea20008000000ULL,
0x000000040d00720cULL, 0x002fda0003f42070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000002992ULL, 0x0003ec0000008000ULL,
0x0000000000002992ULL, 0x002fec000000a000ULL, 0x00000000000029abULL, 0x000fc00000000000ULL,
0x00000000000025abULL, 0x000fec0000000000ULL, 0x0000000b080829a8ULL, 0x004ea800081ee1ceULL,
0x00000000ff00298fULL, 0x004fe20002000000ULL, 0x00000000000c7806ULL, 0x000fe200038e0100ULL,
0x00000000000a7919ULL, 0x000e640000003900ULL, 0x00001f0d08027589ULL, 0x000ea200000e0000ULL,
0x00000000000c79c3ULL, 0x000ee20000008800ULL, 0x000000070a0a7c12ULL, 0x002fe2000f8ec0ffULL,
0xffffffff06147890ULL, 0x000fe2000fffe03fULL, 0x0000040000077882ULL, 0x000fc40000000000ULL,
0x0000000a000f7309ULL, 0x000ea40000000000ULL, 0x0000000102027824ULL, 0x004fe200078e020fULL,
0x000006540c077896ULL, 0x008fc80008000007ULL, 0x0000001402007c0cULL, 0x000fe4000bf45270ULL,
0x00000007ff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff097807ULL, 0x000fca0001000000ULL,
0x00ce200902007388ULL, 0x0003e80000000000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000107097812ULL, 0x042fe200078ec0ffULL, 0x0000000107077836ULL, 0x000fc80000000000ULL,
0x0000001009087824ULL, 0x000fe200078e0202ULL, 0x0000000507007c0cULL, 0x000fc6000bf46070ULL,
0x00cdf80508ff79a7ULL, 0x0003e2000850003fULL, 0x00cdd80508ff79a7ULL, 0x0003f2000850003fULL,
0xffffffe4006ca947ULL, 0x003fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000b47947ULL, 0x000fea0003800000ULL, 0x00009400ff087b82ULL, 0x000e640000000a00ULL,
0x0000000e08087981ULL, 0x002362000c1e9900ULL, 0x000000070600780cULL, 0x000fe20003f04070ULL,
0x00000001ff037424ULL, 0x000fc800078e00ffULL, 0x00cda80302ff79a7ULL, 0x0003f0000850003fULL,
0xff317217ff078424ULL, 0x000fe200078e00ffULL, 0x00cdb80302ff79a7ULL, 0x0003e2000850003fULL,
0x00cdc80302ff79a7ULL, 0x0003e6000850003fULL, 0x00cd400742008388ULL, 0x0003e20000000800ULL,
0x00ce1003020479a7ULL, 0x000ea4000850003fULL, 0x00ce1005020075a7ULL, 0x004ea4000800017fULL,
0x0000002400948947ULL, 0x006fea0003800000ULL, 0x00cda003020479a7ULL, 0x000e64000850003fULL,
0x00cda005020075a7ULL, 0x002e64000800017fULL, 0x0000002400a08947ULL, 0x002fea0003800000ULL,
0x000000040600728cULL, 0x000fe2000bf24070ULL, 0x00000005ff067819ULL, 0x000fca0000011606ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000001000640947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00000010060a7824ULL, 0x000fe400078e00ffULL,
0x3d80000008047820ULL, 0x020fe20000410000ULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x0000000a05087211ULL, 0x002fce00078ff0ffULL, 0x00000040ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x00cdb00d020a79a7ULL, 0x000e64000800003fULL, 0x00cdb00b020075a7ULL, 0x002e64000800017fULL,
0x00000024007c8947ULL, 0x002fea0003800000ULL, 0x00000000020c72caULL, 0x040fe200000e0000ULL,
0x00000400020a7824ULL, 0x040fe200078e00ffULL, 0x0003fff002097812ULL, 0x040fe200078ec0ffULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x000003ff02ff7812ULL, 0x000fe4000780c0ffULL,
0x00000004ff097819ULL, 0x000fe40000011609ULL, 0x000e00000a0b7812ULL, 0x000fe400078ec0ffULL,
0x00003f00090a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000c4000c077890ULL, 0x000fe2000fffe03fULL, 0x000000ff0a0a7812ULL, 0x000fe400078ef809ULL,
0x400000400b097812ULL, 0x000fe200078efcffULL, 0x000003ff073f7892ULL, 0x000fe2000f82c03fULL,
0x000000000a0b72caULL, 0x000fe200000e0000ULL, 0x0000000a07087899ULL, 0x000fe2000800063fULL,
0x00000000090972caULL, 0x000fe200000e0000ULL, 0x0003fff007077892ULL, 0x000fe2000f8ec03fULL,
0x0000002002097836ULL, 0x000fe20000000000ULL, 0x000e0000080a7892ULL, 0x000fc4000f8ec03fULL,
0x000000043f087899ULL, 0x000fe40008011607ULL, 0x0000003f0a077287ULL, 0x000fe20008800000ULL,
0x0003fff009097812ULL, 0x000fe200078ec0ffULL, 0x00003f00080a7892ULL, 0x000fe4000f8ec03fULL,
0x4000004007077892ULL, 0x000fe2000f8efc3fULL, 0x00000004ff097819ULL, 0x000fe20000011609ULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00003f00090a7812ULL, 0x000fe200078ec0ffULL, 0x00000007000b7c82ULL, 0x000fc60008000000ULL,
0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL, 0x00000000081879f3ULL, 0x000fe2000c7008ffULL,
0x0000c4200c087890ULL, 0x000fe2000fffe03fULL, 0x0000004002097836ULL, 0x000fe20000000000ULL,
0x000000000a0b72caULL, 0x000fe400000e0000ULL, 0x0003fff008087892ULL, 0x000fe4000f8ec03fULL,
0x0003fff009097812ULL, 0x000fe400078ec0ffULL, 0x000000043f087899ULL, 0x000fc40008011608ULL,
0x00000004ff097819ULL, 0x000fe40000011609ULL, 0x00003f00080a7892ULL, 0x000fe4000f8ec03fULL,
0x00003f00090a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff0a0a7892ULL, 0x000fe4000f8ef808ULL,
0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x0000006002097836ULL, 0x000fca0000000000ULL,
0x0003fff009097812ULL, 0x000fc800078ec0ffULL, 0x00000004ff097819ULL, 0x000fe20000011609ULL,
0x00000000081879f3ULL, 0x000fe20008700818ULL, 0x0000c4400c087890ULL, 0x000fe2000fffe03fULL,
0x000000000a0b72caULL, 0x000fe400000e0000ULL, 0x00003f00090a7812ULL, 0x000fe200078ec0ffULL,
0x0003fff008087892ULL, 0x000fc6000f8ec03fULL, 0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL,
0x000000043f087899ULL, 0x000fe20008011608ULL, 0x0000200002097836ULL, 0x000fc60000000000ULL,
0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fca0008000000ULL,
0x00000000081879f3ULL, 0x000fe20008700818ULL, 0x0000c4600c087890ULL, 0x000fe2000fffe03fULL,
0x000000000a0b72caULL, 0x000fc600000e0000ULL, 0x0003fff008087892ULL, 0x000fc8000f8ec03fULL,
0x000000043f087899ULL, 0x000fc80008011608ULL, 0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fca0008000000ULL, 0x00000000081879f3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00cdb80302ff79a7ULL, 0x0003e2000850003fULL,
0x00cdc00d020a79a7ULL, 0x000ea4000800003fULL, 0x00cdc00b020075a7ULL, 0x004ea4000800017fULL,
0x00000020006c8947ULL, 0x006fea0003800000ULL, 0x00000000020c72caULL, 0x000fe200000e0000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x0003fff009097812ULL, 0x000fc800078ec0ffULL,
0x00000004ff097819ULL, 0x000fc80000011609ULL, 0x00003f00090a7812ULL, 0x000fc600078ec0ffULL,
0x0000c8000c087890ULL, 0x000fe2000fffe03fULL, 0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL,
0x0000202002097836ULL, 0x000fe40000000000ULL, 0x0003fff008087892ULL, 0x000fe2000f8ec03fULL,
0x000000000a0b72caULL, 0x000fe400000e0000ULL, 0x0003fff009097812ULL, 0x000fe200078ec0ffULL,
0x000000043f087899ULL, 0x000fc60008011608ULL, 0x00000004ff097819ULL, 0x000fe20000011609ULL,
0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL, 0x00003f00090a7812ULL, 0x000fe200078ec0ffULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL,
0x0000204002097836ULL, 0x000fc60000000000ULL, 0x00000000081879f3ULL, 0x000fe20008700818ULL,
0x0000c8200c087890ULL, 0x000fe2000fffe03fULL, 0x000000000a0b72caULL, 0x000fe400000e0000ULL,
0x0003fff009097812ULL, 0x000fe200078ec0ffULL, 0x0003fff008087892ULL, 0x000fc6000f8ec03fULL,
0x00000004ff097819ULL, 0x000fe20000011609ULL, 0x000000043f087899ULL, 0x000fc60008011608ULL,
0x00003f00090a7812ULL, 0x000fe200078ec0ffULL, 0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL,
0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL, 0x000000ff0a0a7892ULL, 0x000fe2000f8ef808ULL,
0x0000206002097836ULL, 0x000fe40000000000ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe40008000000ULL, 0x0003fff009097812ULL, 0x000fc800078ec0ffULL,
0x00000004ff097819ULL, 0x000fe20000011609ULL, 0x00000000081879f3ULL, 0x000fe20008700818ULL,
0x0000c8400c087890ULL, 0x000fe2000fffe03fULL, 0x000000000a0b72caULL, 0x000fe400000e0000ULL,
0x00003f00090a7812ULL, 0x000fe200078ec0ffULL, 0x0003fff008087892ULL, 0x000fc6000f8ec03fULL,
0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL, 0x000000043f087899ULL, 0x000fc80008011608ULL,
0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fca0008000000ULL,
0x00000000081879f3ULL, 0x000fe20008700818ULL, 0x0000c8600c087890ULL, 0x000fe2000fffe03fULL,
0x000000000a0b72caULL, 0x000fe200000e0000ULL, 0x00000013ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x0003fff008087892ULL, 0x000fe4000f8ec03fULL, 0x0000000607097c24ULL, 0x000fe4000f8e020aULL,
0x000000043f087899ULL, 0x000fe40008011608ULL, 0x00000001090a7836ULL, 0x000fc40000000000ULL,
0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL, 0x000000110a007c0cULL, 0x000fe2000bf05270ULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fca0008000000ULL, 0x00000000081879f3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00cdc80302ff79a7ULL, 0x0003e2000850003fULL,
0x0000000418187220ULL, 0x080fe20000410000ULL, 0x0000000419197220ULL, 0x080fe20000410000ULL,
0x000000041a0f7220ULL, 0x080fe20000410000ULL, 0x000000041b0e7220ULL, 0x000fe20000410000ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x0000004009097824ULL, 0x000fca00078e00ffULL,
0x00000009000a7248ULL, 0x000fca0007fe0000ULL, 0x000000010a097824ULL, 0x000fe400078e0a09ULL,
0x00000008080a7836ULL, 0x000fc60000000000ULL, 0x000000090800720cULL, 0x080fe40003f06070ULL,
0x000000090a00720cULL, 0x000fe40003f26070ULL, 0xff80000018187808ULL, 0x000fe40004000000ULL,
0xff80000019197808ULL, 0x000fe40004000000ULL, 0xff8000000f0f7808ULL, 0x000fe40004800000ULL,
0xff8000000e0e7808ULL, 0x000fce0004800000ULL, 0x000000180f097209ULL, 0x000fe40007810000ULL,
0x000000190e0b7209ULL, 0x000fe40007810000ULL, 0x000000030500780cULL, 0x000fe20003f04070ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0e001f00090a7f89ULL, 0x000ea800000e0000ULL,
0x0e001f000b0c7f89ULL, 0x000ee200000e0000ULL, 0x0000000a090a7209ULL, 0x004fc40007810000ULL,
0x0000000c0b0c7209ULL, 0x008fc60007810000ULL, 0x0d001f000a0d7f89ULL, 0x000ea800000e0000ULL,
0x0d001f000c117f89ULL, 0x000ee200000e0000ULL, 0x0000000d0a0d7209ULL, 0x004fe40007810000ULL,
0x000000110c117209ULL, 0x008fc60007810000ULL, 0x0c801f000d107f89ULL, 0x000ea800000e0000ULL,
0x0c801f0011127f89ULL, 0x000ee200000e0000ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x000000100d107209ULL, 0x004fe40007810000ULL, 0x0000001211127209ULL, 0x008fe20007810000ULL,
0x0000000000340947ULL, 0x000fec0003800000ULL, 0x000000ff1000720bULL, 0x000fe20003f36000ULL,
0x0000006000017945ULL, 0x000fe20003800000ULL, 0x0000000805097824ULL, 0x000fd600078e0202ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x00cd401009ff738cULL, 0x0005e20001000200ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x00cd401009ff738cULL, 0x0005e40000800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff1200720bULL, 0x000fda0003f36000ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x00cd441209ff738cULL, 0x0007e20001000200ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x00cd441209ff738cULL, 0x0007e40000800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00ce1003020a79a7ULL, 0x000f22000850003fULL,
0x0000000805097824ULL, 0x00cfca00078e00ffULL, 0x00000018090d7812ULL, 0x000fca00078ec0ffULL,
0x0000000102117824ULL, 0x000fe200078e020dULL, 0x00ce100b020075a7ULL, 0x010ea4000802017fULL,
0x0000001800b49947ULL, 0x004fea0003800000ULL, 0x00cd4000110a7984ULL, 0x000ea20000000a00ULL,
0x00ce1003020c79a7ULL, 0x000ee4000850003fULL, 0x00ce100d020075a7ULL, 0x008ee2000802017fULL,
0x3fb8aa3b0a107820ULL, 0x004fc80000410000ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe20000010810ULL, 0x3fb8aa3b0b107820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b0e0e7823ULL, 0x000fe20000010810ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000f000f7308ULL, 0x000eb00000000800ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x0000000f18107221ULL, 0x004fce0000010000ULL,
0x0000000e000e7308ULL, 0x000ea40000000800ULL, 0x0000000e19117221ULL, 0x004fe20000010000ULL,
0x00000018008c9947ULL, 0x008fec0003800000ULL, 0x0e001f00100d7f89ULL, 0x000ea200000e0000ULL,
0x000000070500780cULL, 0x000fe20003f24070ULL, 0x000001c000007945ULL, 0x000fe20003800000ULL,
0x0000000107177812ULL, 0x000fe200078ec0ffULL, 0x0e001f00110c7f89ULL, 0x000ee200000e0000ULL,
0x000000ffff147224ULL, 0x000fc600078e00ffULL, 0x0000001017167824ULL, 0x000fe400078e0202ULL,
0x0000000d100d7221ULL, 0x004fe20000010000ULL, 0x0000000c110c7221ULL, 0x008fc80000010000ULL,
0x0d001f000d127f89ULL, 0x000ea800000e0000ULL, 0x0d001f000c137f89ULL, 0x000ee200000e0000ULL,
0x000000120d127221ULL, 0x004fe20000010000ULL, 0x000000130c137221ULL, 0x008fc80000010000ULL,
0x0c801f0012117f89ULL, 0x0004e800000e0000ULL, 0x0c801f0013107f89ULL, 0x00052200000e0000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000779c3ULL, 0x000f620000003000ULL,
0x00000001ff0d7819ULL, 0x000fe20000011605ULL, 0x0000000405147824ULL, 0x040fe200078e00ffULL,
0x00000006050c7812ULL, 0x000fe400078ec0ffULL, 0x7ffffffc0d0d7812ULL, 0x000fe400078ec0ffULL,
0x00000001ff0c7819ULL, 0x000fe4000001160cULL, 0x0000001c14147812ULL, 0x000fe200078ec0ffULL,
0x000000010d0d7824ULL, 0x000fca00078e0206ULL, 0x0000000c0d0d7212ULL, 0x000fca00078e3cffULL,
0x000000010d0d7824ULL, 0x000fe400078e0214ULL, 0x0000000702157c36ULL, 0x020fc80008000000ULL,
0x00004200170c7824ULL, 0x000fc800078e0215ULL, 0x000000100d0c7824ULL, 0x000fc800078e020cULL,
0x000040000c147836ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00cdf803160c79a7ULL, 0x000f64000850003fULL, 0x00cdf80d160075a7ULL, 0x020f64000802017fULL,
0x00000018001c9947ULL, 0x020fea0003800000ULL, 0x00000000000779c3ULL, 0x000f620000003000ULL,
0x43e0000018187820ULL, 0x000fe20000410000ULL, 0x43e000000f0f7820ULL, 0x000fe20000410000ULL,
0x43e0000019197820ULL, 0x000fe20000410000ULL, 0x43e000000e0e7820ULL, 0x000fe20000410000ULL,
0x0000001112117221ULL, 0x008fe20000010000ULL, 0x0000001013107221ULL, 0x010fe20000010000ULL,
0x000000180f0f723eULL, 0x000fe4000480710fULL, 0x000000190e0e723eULL, 0x000fc8000480710eULL,
0x000054100f0f7816ULL, 0x000fe2000000000eULL, 0x80000007140c7c36ULL, 0x020fe20008000000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000f0c007844ULL, 0x0009e20000004000ULL,
0x000000c000007945ULL, 0x000fe80003800000ULL, 0x0000000000280947ULL, 0x010fea0003800000ULL,
0x000000ff0600720cULL, 0x040fe20003f05270ULL, 0x00000080170d7824ULL, 0x140fe400078e0202ULL,
0x00000020170c7824ULL, 0x008fe400078e0202ULL, 0x00000020060e7824ULL, 0x000fe400078e020dULL,
0x00000001090c7824ULL, 0x000fe400078e020cULL, 0x00000008050e7824ULL, 0x000fc800078e020eULL,
0x00cc000a0c008388ULL, 0x0007e80000000800ULL, 0x00cc40110e007388ULL, 0x0007e80000000800ULL,
0x00cc040b0c008388ULL, 0x0007e80000000800ULL, 0x00cc44100e007388ULL, 0x0007e40000000800ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000107077836ULL, 0x000fe20000000000ULL,
0x00cdf00316ff79a7ULL, 0x0009e8000850003fULL, 0x0000000507007c0cULL, 0x000fda000bf06070ULL,
0xffffffec00b08947ULL, 0x01ffea000383ffffULL, 0x00cda80302ff79a7ULL, 0x0003e4000850003fULL,
0x0000000000047919ULL, 0x000ee20000002300ULL, 0x0000003f00007836ULL, 0x000fe20000000000ULL,
0x0000000000057919ULL, 0x004ee20000002200ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000783f077890ULL, 0x000fe2000ff3e03fULL,
0x0000007f0000780cULL, 0x000fc60003f04070ULL, 0x0000003f3f0c7290ULL, 0x000fe20008ffe43fULL,
0x0000010000147ab9ULL, 0x000fe20000000800ULL, 0x0000000000067919ULL, 0x002e620000002100ULL,
0x0000000000157ab9ULL, 0x000fe20000000800ULL, 0x00000300ff077b82ULL, 0x000ea20000000800ULL,
0x0000000307077899ULL, 0x000fc8000800120cULL, 0x0000000107077890ULL, 0x000fe2000fffe03fULL,
0x0000001404037c24ULL, 0x008fe2000f8e0205ULL, 0x000000010700780cULL, 0x004fc60000704070ULL,
0x0000001503037c24ULL, 0x002fca000f8e0206ULL, 0x0000000703007c0cULL, 0x000fda000bf26070ULL,
0x0000000803029824ULL, 0x000fc800078e0202ULL, 0x00cda000020099b1ULL, 0x0002a4000800003fULL,
0x000000000000894dULL, 0x004fea0003800000ULL, 0x00000000000c79c3ULL, 0x000ee20000008800ULL,
0x0000040000077882ULL, 0x000fe40000000000ULL, 0x000006540c077896ULL, 0x008fd20008000007ULL,
0x00ce2007ff007984ULL, 0x004ea40008000000ULL, 0x000000ff0000720cULL, 0x004fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000405ff7212ULL, 0x000fc8000784fcffULL, 0x000000040600780cULL, 0x000fda0005741070ULL,
0x00000000005ca947ULL, 0x000fea0003800000ULL, 0x0000000706007c11ULL, 0x000fe2000f8e20ffULL,
0x001ffffe00047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x7ffff80000057882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x002fd60000000000ULL,
0x00000000000812caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00410004083f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001ffe0000047882ULL, 0x002fe20000000000ULL, 0x7ff8000000057882ULL, 0x000fd60000000000ULL,
0x00000000000812caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00410804083f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x00000100ff057424ULL, 0x000fc800078e00ffULL, 0x0041080500ff79a7ULL, 0x0045e6000850003fULL,
0x00000005ff037819ULL, 0x000fe20000011603ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001fff03037589ULL, 0x000ee400000e0000ULL, 0x00000000030572caULL, 0x00afe200000e0000ULL,
0x0000000000007b1dULL, 0x000fd80000010000ULL, 0x000000080500788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x00000004002c8947ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000fe20000002600ULL, 0x0000000b05067890ULL, 0x000fe2000fffe106ULL,
0x0000840000097ab9ULL, 0x000fc60000000800ULL, 0x000000023f067899ULL, 0x000fc60008011606ULL,
0x00000000000879c3ULL, 0x000e660000002700ULL, 0x00000006ff007c0cULL, 0x000fe2000bf05270ULL,
0x00000009080a72a4ULL, 0x002fd8000f8e0204ULL, 0x0000000800d48947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x0000030000087ab9ULL, 0x000fe20000000800ULL, 0x00000004090972a4ULL, 0x000fe4000f8e023fULL,
0x0000000608047899ULL, 0x000fe4000800063fULL, 0x00000fff090b7891ULL, 0x000fc8000f8e103fULL,
0xfffff0000b107892ULL, 0x000fe4000f8ec03fULL, 0xfffffff8050b7890ULL, 0x000fe4000fffe03fULL,
0x00000004090472a4ULL, 0x000fe4000f8e0210ULL, 0x000000080a0572a4ULL, 0x000fe4000f8e023fULL,
0x00000fff040a7890ULL, 0x000fc6000fffe03fULL, 0x0000003f00047c82ULL, 0x000fd20008000000ULL,
0x0000000b04087291ULL, 0x000fe2000f8e103fULL, 0x000000070700780cULL, 0x042fe20003f64070ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x000000ff0700720cULL, 0x000fe20003f25270ULL,
0x0000000408097892ULL, 0x000fe4000f8ec03fULL, 0x00000004080c7899ULL, 0x000fe4000800063fULL,
0x000000023f097899ULL, 0x000fe40008011609ULL, 0x000000300c0c7892ULL, 0x000fc4000f8ec03fULL,
0x0000001f09097899ULL, 0x000fe4000800063fULL, 0x000000060400728cULL, 0x000fe4000bf06070ULL,
0x0000000cff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000805117290ULL, 0x000fe2000fffe03fULL,
0x00000009ff007e24ULL, 0x004fe2000f8e00ffULL, 0x00000003080d7892ULL, 0x000fe4000f8ec03fULL,
0x0000000c070c7290ULL, 0x000fe4000fffe03fULL, 0x00410800030075a7ULL, 0x000e640008000147ULL,
0x00000010002c8947ULL, 0x002ff00003800000ULL, 0x0000014000007945ULL, 0x000fe80003800000ULL,
0x0000000000483947ULL, 0x000fea0003800000ULL, 0x00000011100c7291ULL, 0x000fe2000f8fd03fULL,
0x0000c00000087ab9ULL, 0x000fc60000000a00ULL, 0x000000400c0878a5ULL, 0x000fe4000f8e0008ULL,
0x000000070d0c7291ULL, 0x000fc8000f8e303fULL, 0x00000008ff027e24ULL, 0x000fe2000f8e00ffULL,
0x000000070d087291ULL, 0x000fe2000f8e203fULL, 0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c07057c11ULL, 0x040fe2000f8e18ffULL, 0x0000000807027825ULL, 0x000fca00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0400000002057faeULL, 0x0003e2000b921a4eULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000410008087890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200408ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a88ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000d000007945ULL, 0x000fe80003800000ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x000000110a0c7291ULL, 0x000fe2000f8fa03fULL, 0x00001000ff007424ULL, 0x000fe200078e00ffULL,
0x000000070d147291ULL, 0x000fe2000f8e203fULL, 0x0000c00000087ab9ULL, 0x000fe20000000a00ULL,
0x000000070d127291ULL, 0x000fe4000f8e603fULL, 0x000010000c0878a5ULL, 0x000fe4000f8e0008ULL,
0x0000410014137890ULL, 0x000fe2000fffe03fULL, 0x00000100000c7882ULL, 0x000fd00000000000ULL,
0x00000012080073baULL, 0x0003e2000800020cULL, 0x00410000ffff79a7ULL, 0x0003e40008000014ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0xfffffffc00288947ULL, 0x021fea000383ffffULL,
0x0000000400c87947ULL, 0x000fea0003800000ULL, 0x0000000000167919ULL, 0x000e620000000000ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x00000004003c8947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x004fe2000001ff00ULL, 0xff317217ff007424ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x0000000000087805ULL, 0x020fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fcc0008000000ULL, 0x0000000404087892ULL, 0x000fe4000f8ec03fULL,
0x0000000404097899ULL, 0x000fe4000800063fULL, 0x000000023f087899ULL, 0x000fe40008011608ULL,
0x0000003009097892ULL, 0x000fe4000f8ec03fULL, 0x0000001f080b7899ULL, 0x000fe4000800063fULL,
0x00000003040c7892ULL, 0x000fc4000f8ec03fULL, 0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000907097290ULL, 0x000fe2000fffe03fULL, 0x0000000bff027e24ULL, 0x000fe2000f8e00ffULL,
0x000000070c0a7291ULL, 0x000fe4000f8e603fULL, 0x000000070c087291ULL, 0x000fe4000f8e303fULL,
0x00410002030075a7ULL, 0x000ea20008000147ULL, 0x0000000a050a7291ULL, 0x000fe4000f8e483fULL,
0x0000000805087291ULL, 0x000fc8000f8e183fULL, 0x0000000a160d7c11ULL, 0x002fe2000f8e20ffULL,
0x0000000c00508947ULL, 0x004fee0003800000ULL, 0x00400008ff027984ULL, 0x000e620008000a00ULL,
0x0000000104047890ULL, 0x000fc6000fffe03fULL, 0x000000000d0e7984ULL, 0x000ea20000000a00ULL,
0x000000060400728cULL, 0x000fc6000bf06070ULL, 0x000008000d107984ULL, 0x000ee20000000a00ULL,
0x000000000300720bULL, 0x002fe20003f14000ULL, 0x2000000eff137230ULL, 0x004fe40000004100ULL,
0x3000000eff0e7230ULL, 0x000fe40000004100ULL, 0x2000000fff157230ULL, 0x000fe40000004100ULL,
0x3000000fff127230ULL, 0x000fe40000004100ULL, 0x20000010ff177230ULL, 0x008fc40000004100ULL,
0x30000010ff147230ULL, 0x000fe40000004100ULL, 0x20000011ff197230ULL, 0x000fe40000004100ULL,
0x30000011ff1b7230ULL, 0x000fe20000004100ULL, 0x0000000000380947ULL, 0x000fec0003800000ULL,
0x0000000300037221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b03037820ULL, 0x000fcc0000410000ULL,
0x0000000300037308ULL, 0x000e640000000800ULL, 0x00000003020d7220ULL, 0x002fc80000410000ULL,
0x0000000d130c7223ULL, 0x080fe2000001000cULL, 0x0000000d0e0b7223ULL, 0x080fe2000001000bULL,
0x0000000d150a7223ULL, 0x080fe2000001000aULL, 0x0000000d12097223ULL, 0x080fe20000010009ULL,
0x0000000d17087223ULL, 0x080fe20000010008ULL, 0x0000000d14077223ULL, 0x080fe20000010007ULL,
0x0000000d19067223ULL, 0x080fe20000010006ULL, 0x0000000d1b047223ULL, 0x000fe20000010004ULL,
0x000000050d057221ULL, 0x000fe20000010000ULL, 0x0000000000547947ULL, 0x000fec0003800000ULL,
0x8000000300007221ULL, 0x100fe20000010000ULL, 0x00000013020f7220ULL, 0x040fe20000410000ULL,
0x0000001502117220ULL, 0x040fe20000410000ULL, 0x0000001202107220ULL, 0x000fe20000410000ULL,
0x3fb8aa3b00007820ULL, 0x000fe20000410000ULL, 0x0000001702137220ULL, 0x040fe20000410000ULL,
0x0000000e020e7220ULL, 0x040fe20000410000ULL, 0x0000001402127220ULL, 0x040fe20000410000ULL,
0x00000000000d7308ULL, 0x0002a20000000800ULL, 0x0000001902157220ULL, 0x040fe20000410000ULL,
0x0000001b02177220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x002fc400078e0003ULL,
0x000000050d057223ULL, 0x044fe20000010002ULL, 0x0000000c0d0c7223ULL, 0x040fe2000001000fULL,
0x0000000b0d0b7223ULL, 0x040fe2000001000eULL, 0x0000000a0d0a7223ULL, 0x040fe20000010011ULL,
0x000000090d097223ULL, 0x040fe20000010010ULL, 0x000000080d087223ULL, 0x040fe20000010013ULL,
0x000000070d077223ULL, 0x040fe20000010012ULL, 0x000000060d067223ULL, 0x040fe20000010015ULL,
0x000000040d047223ULL, 0x000fce0000010017ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000070c087291ULL, 0x000fe2000f8e203fULL, 0x00000001ff027424ULL, 0x000fd000078e00ffULL,
0x00410802ffff79a7ULL, 0x0003e60008500008ULL, 0xfffffff800e48947ULL, 0x003fea000383ffffULL,
0x0000000000147947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x004fe4000001ff00ULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x0000000000087805ULL, 0x020fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x00000000000479c3ULL, 0x000fe20000002600ULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x0000000500057308ULL, 0x000ea20000001000ULL, 0x00000008160f7824ULL, 0x002fca00078e00ffULL,
0x00000000000679c3ULL, 0x000e620000002700ULL, 0x0000000c050c7220ULL, 0x044fe20000410000ULL,
0x0000000b050b7220ULL, 0x040fe20000410000ULL, 0x0000000a050a7220ULL, 0x040fe20000410000ULL,
0x0000000805087220ULL, 0x040fe20000410000ULL, 0x0000000605067220ULL, 0x040fe20000410000ULL,
0x00000004050d7220ULL, 0x040fe20000410000ULL, 0x0000000705077220ULL, 0x040fe20000410000ULL,
0x0000000905057220ULL, 0x000fe20000410000ULL, 0x0000000c0b0c723eULL, 0x000fc600000000ffULL,
0x00000008070e723eULL, 0x000fe200000000ffULL, 0x00000008060472a4ULL, 0x002fc6000f8e0204ULL,
0x0000860000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000504057291ULL, 0x000fc8000f80183fULL,
0x0000003f3f067290ULL, 0x000fe400087fe43fULL, 0x0000000805047291ULL, 0x000fc8000f80483fULL,
0x0000000905057291ULL, 0x000fe400080f4c06ULL, 0x00000004ff027e24ULL, 0x000fc8000f8e00ffULL,
0x00000005ff037e24ULL, 0x000fe4000f8e00ffULL, 0x000000020f027825ULL, 0x000fe200078e0002ULL,
0x000000060d0f723eULL, 0x000fe400000000ffULL, 0x0000000a050d723eULL, 0x000fca00000000ffULL,
0x0000000c02007986ULL, 0x0003e4000c101d0eULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000000a94dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x004e240000002100ULL,
0x0000000700007c11ULL, 0x001fc8000f8e20ffULL, 0x00410800000079b1ULL, 0x000e24000800003fULL,
0x00410000000079b1ULL, 0x001fe2000800003fULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00cdd8070b0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdd8070b0085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffa800707947ULL, 0x021fea000383ffffULL,
0x00cdb805020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdb805020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffac001c7947ULL, 0x021fea000383ffffULL,
0x00cdc805020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdc805020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffac005c7947ULL, 0x021fea000383ffffULL,
0x00cda81b020075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00cda81b020095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffb000547947ULL, 0x021fea000383ffffULL,
0x00ce1805020075a7ULL, 0x0004a2000800017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00ce1805020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffbc002c7947ULL, 0x023fea000383ffffULL,
0x00cdd0090b0075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00cdd0090b00a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffc000447947ULL, 0x001fea000383ffffULL,
0x00cdf009110075a7ULL, 0x000262000806017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000b95dULL, 0x000fea0003900000ULL, 0x00cdf0091100b5a7ULL, 0x000e24000806007fULL,
0xfffffffc00ecb947ULL, 0x001fea000383ffffULL, 0xffffffc000587947ULL, 0x001fea000383ffffULL,
0x00ce1809020075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce18090200a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffc400e87947ULL, 0x001fea000383ffffULL,
0x00ce1809020075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce18090200a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffcc00bc7947ULL, 0x001fea000383ffffULL,
0x00ce180b020075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce180b0200a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffd400707947ULL, 0x001fea000383ffffULL,
0x00ce1813020075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce18130200a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffd400907947ULL, 0x001fea000383ffffULL,
0x00ce1005020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00ce1005020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd800547947ULL, 0x021fea000383ffffULL,
0x00cda005020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cda005020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd800487947ULL, 0x021fea000383ffffULL,
0x00cdb00b020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdb00b020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd8006c7947ULL, 0x001fea000383ffffULL,
0x00cdc00b020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdc00b020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffdc007c7947ULL, 0x001fea000383ffffULL,
0x00ce100b020075a7ULL, 0x0004a2000802017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00ce100b020095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe400347947ULL, 0x003fea000383ffffULL,
0x00ce100d020075a7ULL, 0x0004a2000802017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00ce100d020095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe4005c7947ULL, 0x003fea000383ffffULL,
0x00cdf80d160075a7ULL, 0x000b62000802017fULL, 0x0000d0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00cdf80d160095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe400cc7947ULL, 0x01ffea000383ffffULL,
0x00000009ff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000009ff037e24ULL, 0x000fce000f8e00ffULL,
0x0000000cff057e24ULL, 0x000fc8000f8e00ffULL, 0x00410803050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00410803050085a7ULL, 0x000e24000800007fULL, 0xfffffffc00e88947ULL, 0x001fea000383ffffULL,
0xffffffec00b07947ULL, 0x021fea000383ffffULL, 0x0000000bff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fce000f8e00ffULL, 0x00000009ff0f7e24ULL, 0x000fc8000f8e00ffULL,
0x004100030f0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x004100030f0085a7ULL, 0x000e24000800007fULL,
0xfffffffc00e88947ULL, 0x001fea000383ffffULL, 0xfffffff0008c7947ULL, 0x001fea000383ffffULL,
0x018000000a087836ULL, 0x000fe20000000000ULL, 0x0000013000037945ULL, 0x000fe80003800000ULL,
0x7f800000080b7812ULL, 0x000fc800078ec0ffULL, 0x018000000b00780cULL, 0x000fda0003f45070ULL,
0x0000000a0008a308ULL, 0x0000620000001000ULL, 0x000000000038a947ULL, 0x000fea0003800000ULL,
0x000000ff0b00720cULL, 0x040fe40003f65070ULL, 0x008000000b00780cULL, 0x000fe40003f42070ULL,
0x00000001ff0b7807ULL, 0x000fe40001800000ULL, 0x00000001ff087807ULL, 0x002fc80005000000ULL,
0x000000080bff7212ULL, 0x000fda000784fcffULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x007fffff0aff7812ULL, 0x040fe4000784c0ffULL, 0x800000000a0a7812ULL, 0x001fe400078ec0ffULL,
0x00000001ff087807ULL, 0x000fc80001000000ULL, 0x000000080bff7212ULL, 0x000fda000784c0ffULL,
0x008000000a082812ULL, 0x000fe200078efcffULL, 0x000000ffff08a224ULL, 0x000fe200078e000aULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000a00087308ULL, 0x0002a40000001000ULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x003fe400078e000dULL,
0x00000000ff0b7424ULL, 0x000fc800078e00ffULL, 0xffffff940ae07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000010000ce80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000015bULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001c5ULL, 0x00000000000001ccULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000398ULL, 0x0000000000000150ULL,
0x0000000c00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000004e8ULL, 0x0000000000000100ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005e8ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000630ULL, 0x000000000000076cULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000126ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d9cULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000b5ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000dc0ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000edULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000dc0ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000400000114ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000df0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e38ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e40ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000006980ULL,
0x0000000c00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000007800ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000007810ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000100000142ULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000007810ULL, 0x0000000000000308ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000007f58ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000007f58ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e38ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000006980ULL, 0x0000000000006980ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000007800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000410ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000007810ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000308ULL, 0x0000000000000308ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 32936;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
