/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c640ULL, 0x000000000001c2c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45386aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x695f5f2400687461ULL,
0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL, 0x5f636e79736c6668ULL,
0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL,
0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL,
0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL,
0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x2e006d617261705fULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL, 0x0000006e6f697463ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000362ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000003a7ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0022000003edULL,
0x000000000001a9f0ULL, 0x0000000000000190ULL, 0x000b002200000420ULL, 0x000000000001ab80ULL,
0x0000000000000040ULL, 0x000b00220000044bULL, 0x000000000001abc0ULL, 0x0000000000000040ULL,
0x000b002200000475ULL, 0x000000000001ac00ULL, 0x0000000000000100ULL, 0x000a0003000004e3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000503ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000533ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001ad00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001a9f000000000ULL, 0x0000040400000000ULL, 0x810c000001440400ULL, 0x0069280400288080ULL,
0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080840828ULL,
0x2880808c08288080ULL, 0x8092082880808e08ULL, 0x082880809b082880ULL, 0x8080d408288080d3ULL,
0x8016288080860828ULL, 0x0000000310288082ULL, 0x8086920000000000ULL, 0x0000000022002880ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001a9f000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8087288080840900ULL, 0x0900000004042880ULL, 0x2880808428808086ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8908288080870828ULL, 0x2880808c08288080ULL,
0x80d3082880809208ULL, 0x08288080d4082880ULL, 0x808280162880808aULL, 0x0000000000031028ULL,
0x2880808a92000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000012800000000ULL,
0x0001ab8000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080860828808081ULL, 0x8e08288080890828ULL, 0x2880809208288080ULL, 0x80d408288080d308ULL,
0x162880808c082880ULL, 0x0000031028808280ULL, 0x8c92000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x000001c000000000ULL, 0x0001abc000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8c08288080890828ULL,
0x2880809208288080ULL, 0x80d408288080d308ULL, 0x162880808e082880ULL, 0x0000031028808280ULL,
0x8e92000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000025000000000ULL,
0x0001ac0000000000ULL, 0x0000010000000000ULL, 0x0000180400000000ULL, 0x808c2880808e0900ULL,
0x0000000000002880ULL, 0x0000001800082f04ULL, 0x00082304000000ceULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0050016000000015ULL,
0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001cc2804ULL, 0x0000036000000120ULL,
0x000027a000001680ULL, 0x0000292000002830ULL, 0x00002ca000002a90ULL, 0x00002d3000002cd0ULL,
0x000032c000002d90ULL, 0x000040f0000040c0ULL, 0x000041b000004150ULL, 0x0000574000004610ULL,
0x000058e0000057d0ULL, 0x00005c5000005a40ULL, 0x00005ce000005c80ULL, 0x00005fd000005d40ULL,
0x00006de000006db0ULL, 0x00006ea000006e40ULL, 0x00008200000071a0ULL, 0x0000839000008280ULL,
0x00008700000084f0ULL, 0x0000879000008730ULL, 0x00008a60000087f0ULL, 0x0000989000009860ULL,
0x00009950000098f0ULL, 0x0000ad9000009c50ULL, 0x0000af200000ae10ULL, 0x0000b2900000b080ULL,
0x0000b3200000b2c0ULL, 0x0000b6400000b380ULL, 0x0000c4500000c420ULL, 0x0000c5100000c4b0ULL,
0x0000c9900000c980ULL, 0x0000ea700000d0f0ULL, 0x0000f1400000eab0ULL, 0x0000f8100000f180ULL,
0x00018d6000018d20ULL, 0x00018d8000018d70ULL, 0x00018df000018d90ULL, 0x00018e3000018e10ULL,
0x00019ad000019a70ULL, 0x00019b8000019b30ULL, 0x00019c4000019be0ULL, 0x00019d1000019cb0ULL,
0x00019dd000019d70ULL, 0x00019e7000019e20ULL, 0x00019f3000019ed0ULL, 0x0001a00000019fa0ULL,
0x0001a0c00001a060ULL, 0x0001a1600001a110ULL, 0x0001a2200001a1c0ULL, 0x0001a2f00001a290ULL,
0x0001a3b00001a350ULL, 0x0001a4500001a400ULL, 0x0001a5100001a4b0ULL, 0x0001a5e00001a580ULL,
0x0001a6c00001a650ULL, 0x0001a7c00001a740ULL, 0x0001a8c00001a840ULL, 0x0001a9c00001a940ULL,
0x0000020002003904ULL, 0x0001c600000000ffULL, 0x00000280003f0100ULL, 0x0001c60800000009ULL,
0x00000340003f0120ULL, 0x0001c68800000009ULL, 0x000004a0003f0120ULL, 0x0001c600000000ffULL,
0x00000620003f0107ULL, 0x0001c68c00000003ULL, 0x000006c0003f0102ULL, 0x0001c68800000003ULL,
0x000024d0003f0101ULL, 0x0001c60800000003ULL, 0x000024f0003f0101ULL, 0x0001c60c00000003ULL,
0x000026c0003f0105ULL, 0x0001c60c00000003ULL, 0x000045d0003f0105ULL, 0x0001c688000000ffULL,
0x000054c0003f0101ULL, 0x0001c62800000003ULL, 0x000054e0003f0101ULL, 0x0001c62c00000003ULL,
0x000056b0003f0105ULL, 0x0001c62c00000003ULL, 0x00007170003f0105ULL, 0x0001c690000000ffULL,
0x00007f80003f0101ULL, 0x0001c64800000003ULL, 0x00007fa0003f0101ULL, 0x0001c64c00000003ULL,
0x00008170003f0105ULL, 0x0001c64c00000003ULL, 0x00009c20003f0105ULL, 0x0001c698000000ffULL,
0x0000ab10003f0101ULL, 0x0001c66800000003ULL, 0x0000ab30003f0101ULL, 0x0001c66c00000003ULL,
0x0000ad00003f0105ULL, 0x0001c66c00000003ULL, 0x0000c7e0003f0105ULL, 0x0001c6a0000000ffULL,
0x0000fbc0003f0101ULL, 0x0001c600000000ffULL, 0x000117f0003f0101ULL, 0x0001c604000000ffULL,
0x000119c0003f0105ULL, 0x0001c604000000ffULL, 0x00018250003f0105ULL, 0x00000000000000c5ULL,
0x00018270003f0101ULL, 0x00000004000000c5ULL, 0x00018440003f0105ULL, 0x00000004000000c5ULL,
0x000198c0003f0105ULL, 0x0001c608000000c6ULL, 0x00019920003f0101ULL, 0x0001c610000000c6ULL,
0x00019980003f0101ULL, 0x0001c618000000c6ULL, 0x000199f0003f0101ULL, 0x0001c620000000c6ULL,
0x00033803003f0101ULL, 0x0000fa9000101c04ULL, 0x00011ab000011a20ULL, 0x0000040100019a30ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000002ccULL, 0x0000001800000002ULL, 0x000000000000023cULL,
0x0000001800000002ULL, 0x00000000000001acULL, 0x0000001800000002ULL, 0x00000000000000fcULL,
0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL, 0x00000000000002a6ULL,
0x0000001800000002ULL, 0x0000000000000216ULL, 0x0000001800000002ULL, 0x0000000000000183ULL,
0x0000001800000002ULL, 0x00000000000000d5ULL, 0x0000001800000002ULL, 0x000000000001c700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000097919ULL, 0x000e620000002100ULL,
0x0000000000167806ULL, 0x000fe200038e0000ULL, 0x00005800ffc87624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001600067300ULL, 0x000ee200000e0000ULL, 0x00000200ff157424ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x0000000000027919ULL, 0x000ee80000002200ULL,
0x0000000000127919ULL, 0x000f220000002600ULL, 0x0000001600167309ULL, 0x000ea60000000000ULL,
0x0000000000cb7919ULL, 0x000f280000002700ULL, 0x0000000000077919ULL, 0x000f220000000000ULL,
0x00000005ff087819ULL, 0x002fc60000011609ULL, 0x0000000000007919ULL, 0x000e680000000000ULL,
0x00001fff03057589ULL, 0x0045e200000e0000ULL, 0x0000010003027a24ULL, 0x008fc600078e0202ULL,
0x00001fff08087589ULL, 0x000ee200000e0000ULL, 0x0000000002097a24ULL, 0x000fe400078e0209ULL,
0x0000000812027824ULL, 0x010fe400078e00ffULL, 0x00000008c8037824ULL, 0x004fe200078e00ffULL,
0x000000ff0900720cULL, 0x040fe40003f25270ULL, 0x0000000f0900780cULL, 0x000fe20003f44070ULL,
0x000000cb030a7224ULL, 0x000fe200078e0202ULL, 0x0000007f0900780cULL, 0x000fc40003f84070ULL,
0x000000030900780cULL, 0x000fe40003f64070ULL, 0x000000070600720cULL, 0x000fca0003f02070ULL,
0x3fffff80ff029424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x0000000405047824ULL, 0x008fe400078e0208ULL, 0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL,
0x01c60002ff009388ULL, 0x0005e20000000a00ULL, 0x00000002040b7824ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff07a424ULL, 0x000fc400078e00ffULL, 0x000000010b047824ULL, 0x042fe200078e0200ULL,
0x000000080b0c7817ULL, 0x040fe20007800000ULL, 0x000000200b0d7824ULL, 0x040fe200078e00ffULL,
0x000000010b117810ULL, 0x000fe20007ffe0ffULL, 0xff317217ff14c424ULL, 0x000fe200078e00ffULL,
0x01c608060900a388ULL, 0x0003e20000008a00ULL, 0x000000010a027824ULL, 0x104fe200078e020bULL,
0xffffffe00d107812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x01c400140900c388ULL, 0x000fe20000004800ULL, 0x000000010c0d7824ULL, 0x000fc400078e0a0bULL,
0x3fffff60ff0eb424ULL, 0x000fe200078e00ffULL, 0x000001f004137812ULL, 0x000fe200078ec0ffULL,
0x7fffff60ff0fb424ULL, 0x000fe200078e00ffULL, 0x000000ff0d00720cULL, 0x040fe20003f23070ULL,
0x00005c0002027625ULL, 0x000fe200078e0015ULL, 0x000000010d00780cULL, 0x000fe40003f43070ULL,
0x01c6880e0900b388ULL, 0x000fe20000008a00ULL, 0x000000010a067824ULL, 0x002fc600078e0211ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00005c0006067625ULL, 0x000fe200078e0015ULL,
0x00000013020a7210ULL, 0x000fc60007f7e0ffULL, 0x00000001110b7824ULL, 0x040fe200078e0200ULL,
0x00000013060c7210ULL, 0x000fe20007f9e0ffULL, 0x0000002011147824ULL, 0x000fe400078e00ffULL,
0x0000001010097824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e0607ULL,
0xffffffe014027812ULL, 0x000fe200078ee20bULL, 0x000000ffff0b7224ULL, 0x000fe400018e0603ULL,
0x000000ffff067224ULL, 0x000fc400078e0a16ULL, 0x00000010020f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a097faeULL, 0x0003e2000c901c46ULL,
0x00000004ff0e7424ULL, 0x000fe400078e00ffULL, 0x00000004ff077e24ULL, 0x000fe2000f8e00ffULL,
0x000000000c0f7faeULL, 0x0003e2000d101c46ULL, 0x00006200cb027625ULL, 0x000fc600078e000eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01c60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602067981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0500720cULL, 0x000fc40003f05270ULL,
0x0000007f06c37810ULL, 0x044fe40007ffe0ffULL, 0x000000ff06057810ULL, 0x000fe40007ffe0ffULL,
0x00000007ffc37819ULL, 0x000fe400000116c3ULL, 0x00000008ff057819ULL, 0x000fca0000011605ULL,
0x0000f51000008947ULL, 0x000fea0003800000ULL, 0x0000000207027824ULL, 0x000fe400078e00ffULL,
0x0000000808037824ULL, 0x000fe400078e00ffULL, 0x00000003ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000c30200720cULL, 0x000fda0003f06070ULL, 0x0000640002098a10ULL, 0x000fe20007ffe0ffULL,
0x00000002cb048824ULL, 0x000fc800078e00ffULL, 0x0000640004098a24ULL, 0x000fe400078e0209ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c68c0c03ff738cULL, 0x0003e20000000000ULL, 0x00006000090a8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a048981ULL, 0x000ea2000c1e1900ULL,
0x00000001070c7810ULL, 0x002fe20007ffe0ffULL, 0x0000008012097824ULL, 0x000fe400078e00ffULL,
0x01c6880003ff7f8cULL, 0x0003e2000c80043fULL, 0x000000050c00720cULL, 0x000fe20003f06070ULL,
0x00005800040c7a24ULL, 0x004fc800078e02ffULL, 0x000000800c277824ULL, 0x000fd000078e00ffULL,
0x0000073000008947ULL, 0x000fea0003800000ULL, 0x00000003ff0f7819ULL, 0x002fe20000011600ULL,
0x00000100070b7824ULL, 0x000fc600078e00ffULL, 0x000000040f137810ULL, 0x040fe40007ffe0ffULL,
0x000000080f157810ULL, 0x040fe40007ffe0ffULL, 0x000000100f197810ULL, 0x000fe20007ffe0ffULL,
0x00000001130c7824ULL, 0x100fe200078e0200ULL, 0x000000140f217810ULL, 0x000fe20007ffe0ffULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0x0000000b060a7217ULL, 0x000fe20007800000ULL,
0x00000001150d7824ULL, 0x000fe200078e0200ULL, 0x0000000c0f177810ULL, 0x000fe20007ffe0ffULL,
0x00000008151e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8111c7812ULL, 0x000fe200078ee20cULL,
0x00000080120c7824ULL, 0x000fe200078e020fULL, 0x0000001c0f257810ULL, 0x000fe20007ffe0ffULL,
0x0000000819227824ULL, 0x040fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL,
0x00000001190d7824ULL, 0x100fe200078e0200ULL, 0x0000000c27117210ULL, 0x000fe20007f1e0ffULL,
0x0000000121107824ULL, 0x140fe200078e0200ULL, 0x000000140c147810ULL, 0x000fe20007ffe0ffULL,
0x00000008211b7824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20dULL,
0x000000010a0e7824ULL, 0x000fe200078e0a0bULL, 0x000000040c0d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001170b7824ULL, 0x000fe200078e0200ULL, 0xfffffff81b247812ULL, 0x000fe200078ee210ULL,
0x0000000817207824ULL, 0x000fe200078e00ffULL, 0x000000080c107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005e00110a7a11ULL, 0x000fc400078048ffULL,
0x0000000d270d7210ULL, 0x000fe40007f9e0ffULL, 0xfffffff820207812ULL, 0x000fe400078ee20bULL,
0x00005f00110b7a11ULL, 0x000fe400000f4c12ULL, 0x00000010271d7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x0000000c0c117810ULL, 0x040fe40007ffe0ffULL,
0x000000100c127810ULL, 0x000fc40007ffe0ffULL, 0x000000180c167810ULL, 0x040fe40007ffe0ffULL,
0x0000001c0c1a7810ULL, 0x000fe40007ffe0ffULL, 0x00005e000d0c7a11ULL, 0x000fe400078c48ffULL,
0x00000011271b7210ULL, 0x000fe20007f1e0ffULL, 0x0000000825117824ULL, 0x000fe200078e00ffULL,
0x00005f000d0d7a11ULL, 0x000fe200030f4c10ULL, 0x0000000125107824ULL, 0x000fe200078e0200ULL,
0x000000180f237810ULL, 0x000fc40007ffe0ffULL, 0x00000012272b7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0xfffffff811287812ULL, 0x000fe200078ee210ULL,
0x000000010f107824ULL, 0x100fe200078e0200ULL, 0x00000014272a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000123187824ULL, 0x000fe200078e0200ULL, 0x0000001627297210ULL, 0x000fe20007fbe0ffULL,
0x00000008231f7824ULL, 0x000fe200078e00ffULL, 0x0000001a27277210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x000000200e1a7817ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200028e06ffULL, 0x00005e001d0e7a11ULL, 0x000fc400078c48ffULL,
0x0000000710117812ULL, 0x000fe400078ec0ffULL, 0x0000001a0f00720cULL, 0x000fe40003f46070ULL,
0xfffffff81f267812ULL, 0x000fe200078ee218ULL, 0x00000008081f7824ULL, 0x040fe200078e00ffULL,
0x00005f001d0f7a11ULL, 0x000fe400030f4c12ULL, 0x00005e001b107a11ULL, 0x000fe400078c48ffULL,
0x00014000081d7811ULL, 0x000fc400078e68ffULL, 0x0ffffff811127812ULL, 0x000fe400078ef800ULL,
0x00005f001b117a11ULL, 0x000fe200030f4c14ULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0xfffffff81f1b7812ULL, 0x000fe200078ee200ULL, 0x00000010121f7824ULL, 0x000fe200078e021dULL,
0x00005e002b127a11ULL, 0x000fe400078c48ffULL, 0x0000001a1300720cULL, 0x080fe20003f06070ULL,
0x000000101b0a7825ULL, 0x000fe200078e000aULL, 0x0000001a1500720cULL, 0x000fc40003f26070ULL,
0x00005f002b137a11ULL, 0x000fe200030f4c14ULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x00005e002a147a11ULL, 0x040fe200078c48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1f7faeULL, 0x0003e2000d101c46ULL, 0x00005e0029167a11ULL, 0x000fe400078a48ffULL,
0x00005f002a157a11ULL, 0x000fe200030f4c15ULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005e0027187a11ULL, 0x000fe400078c48ffULL, 0x0000001a1700720cULL, 0x000fc40003f66070ULL,
0x0000001a1900720cULL, 0x080fe40003f46070ULL, 0x0000001a2100720cULL, 0x080fe20003f86070ULL,
0x000000101c1f7824ULL, 0x002fe200078e021dULL, 0x00005f0029177a11ULL, 0x000fe200028f4c2cULL,
0x000000101b0a7825ULL, 0x000fe200078e000cULL, 0x0000001a2300720cULL, 0x080fe40003fa6070ULL,
0x00005f0027197a11ULL, 0x000fe200030f4c2aULL, 0x000000101e217824ULL, 0x000fe200078e021dULL,
0x0000001a2500720cULL, 0x000fe20003fc6070ULL, 0x000000101b0c7825ULL, 0x040fe200078e000eULL,
0x000000000a1f7faeULL, 0x0003e6000c101c46ULL, 0x0000001020237824ULL, 0x000fe200078e021dULL,
0x000000000c217faeULL, 0x0003e2000c901c46ULL, 0x000000101b0e7825ULL, 0x000fc800078e0010ULL,
0x0000001022257824ULL, 0x000fe200078e021dULL, 0x000000000e237faeULL, 0x0003e2000d901c46ULL,
0x000000101b107825ULL, 0x000fc800078e0012ULL, 0x0000001024277824ULL, 0x000fe200078e021dULL,
0x0000000010257faeULL, 0x0003e2000d101c46ULL, 0x000000101b127825ULL, 0x000fc800078e0014ULL,
0x0000001026297824ULL, 0x000fe200078e021dULL, 0x0000000012277faeULL, 0x0003e2000e101c46ULL,
0x000000101b147825ULL, 0x000fc800078e0016ULL, 0x00000010281d7824ULL, 0x000fe200078e021dULL,
0x0000000014297faeULL, 0x0003e2000e901c46ULL, 0x000000101b167825ULL, 0x000fca00078e0018ULL,
0x00000000161d7faeULL, 0x0003e2000f101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x00000004000d7811ULL, 0x002fe200078fe8ffULL, 0x00000008082b7824ULL, 0x000fe200078e00ffULL,
0x0000000c00117811ULL, 0x040fe400078fe8ffULL, 0x00000008000e7811ULL, 0x040fe200078fe8ffULL,
0x000000010d0a7824ULL, 0x140fe200078e0200ULL, 0x0000001400157811ULL, 0x040fe200078fe8ffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0x0000001800177811ULL, 0x000fe200078fe8ffULL,
0x00000001110c7824ULL, 0x040fe200078e0200ULL, 0x0001400008297811ULL, 0x000fe200078e68ffULL,
0x0000000811137824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x000000010e0b7824ULL, 0x000fe200078e0200ULL, 0x00000009000a7211ULL, 0x000fe200078fe8ffULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0xfffffff813127812ULL, 0x000fe200078ee20cULL,
0x00000001150c7824ULL, 0x140fe200078e0200ULL, 0x0000001000137811ULL, 0x000fe200078fe8ffULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x0000000a27197210ULL, 0x000fe20007f1e0ffULL,
0x00000001090d7824ULL, 0x000fe200078e020dULL, 0xfffffff810107812ULL, 0x000fe200078ee20bULL,
0x00000001130b7824ULL, 0x000fe200078e0200ULL, 0xfffffff81b167812ULL, 0x000fe200078ee20cULL,
0x0000000813147824ULL, 0x000fe200078e00ffULL, 0x00000000000c7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x00005e00190a7a11ULL, 0x000fe200078048ffULL,
0x00000001090e7824ULL, 0x040fe200078e020eULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x0000000109117824ULL, 0x000fe200078e0211ULL, 0x00005f00190b7a11ULL, 0x000fe200000f4c1aULL,
0x0000000117187824ULL, 0x100fe200078e0200ULL, 0x0000000d271b7210ULL, 0x000fe20007fde0ffULL,
0x00000008171d7824ULL, 0x000fe200078e00ffULL, 0x0000001c00197811ULL, 0x000fe200078fe8ffULL,
0x0000000109137824ULL, 0x000fe200078e0213ULL, 0x000000070c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff207224ULL, 0x000fe200030e06ffULL, 0x0000000e271e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000819227824ULL, 0x000fe200078e00ffULL, 0x00000011271c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000119117824ULL, 0x100fe200078e0200ULL, 0x00005e001b0c7a11ULL, 0x000fe200078c48ffULL,
0x0000000109157824ULL, 0x000fe200078e0215ULL, 0x0ffffff80d0e7812ULL, 0x000fe200078ef800ULL,
0x0000000109177824ULL, 0x000fe200078e0217ULL, 0xfffffff81d187812ULL, 0x000fe200078ee218ULL,
0x00000001091a7824ULL, 0x000fe200078e0219ULL, 0x00005f001b0d7a11ULL, 0x000fe200030f4c20ULL,
0x000000100f1d7824ULL, 0x100fe200078e0229ULL, 0x0000001327137210ULL, 0x040fe20007f7e0ffULL,
0x000000100e1b7824ULL, 0x000fe200078e0229ULL, 0xfffffff822117812ULL, 0x000fe200078ee211ULL,
0x000000ffff0f7224ULL, 0x000fe200028e06ffULL, 0x0000001527157210ULL, 0x040fe20007f1e0ffULL,
0x00000010101f7824ULL, 0x100fe200078e0229ULL, 0x00005e001e0e7a11ULL, 0x000fe200078a48ffULL,
0x000000ffff197224ULL, 0x000fe200020e06ffULL, 0x0000001727177210ULL, 0x040fe20007f5e0ffULL,
0x0000001012217824ULL, 0x100fe200078e0229ULL, 0x00005e001c107a11ULL, 0x000fe200078848ffULL,
0x0000001014237824ULL, 0x100fe200078e0229ULL, 0x0000001a271a7210ULL, 0x000fe20007f3e0ffULL,
0x0000001016257824ULL, 0x000fe200078e0229ULL, 0x00005f001e0f7a11ULL, 0x000fe200028f4c0fULL,
0x0000001018277824ULL, 0x100fe200078e0229ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee200ULL,
0x0000001011297824ULL, 0x000fe200078e0229ULL, 0x00005f001c117a11ULL, 0x000fe200020f4c19ULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078648ffULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078048ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x00005e0017167a11ULL, 0x000fe200078448ffULL,
0x000000ffff197224ULL, 0x000fe200008e06ffULL, 0x00005e001a187a11ULL, 0x000fe200078248ffULL,
0x000000102b0a7825ULL, 0x000fe200078e000aULL, 0x00005f0013137a11ULL, 0x000fc400018f4c20ULL,
0x00005f0015157a11ULL, 0x000fe200000f4c1eULL, 0x000000102b0c7825ULL, 0x000fe200078e000cULL,
0x00005f0017177a11ULL, 0x000fe200010f4c1cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1b7faeULL, 0x0003e2000b901c46ULL, 0x00005f001a197a11ULL, 0x000fe200008f4c19ULL,
0x000000102b0e7825ULL, 0x040fe400078e000eULL, 0x000000000c1d7faeULL, 0x0003e4000b901c46ULL,
0x000000102b107825ULL, 0x040fe400078e0010ULL, 0x000000000e1f7faeULL, 0x0003e4000b901c46ULL,
0x000000102b127825ULL, 0x000fc400078e0012ULL, 0x0000000010217faeULL, 0x0003e4000b901c46ULL,
0x000000102b147825ULL, 0x040fe400078e0014ULL, 0x0000000012237faeULL, 0x0003e4000b901c46ULL,
0x000000102b167825ULL, 0x040fe400078e0016ULL, 0x0000000014257faeULL, 0x0003e4000b901c46ULL,
0x000000102b187825ULL, 0x000fc400078e0018ULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000018297faeULL, 0x0003e4000b901c46ULL, 0x000000050700720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff6a7424ULL, 0x000fe200078e00ffULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x002fe200078e00ffULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000b25000000947ULL, 0x000fea0003800000ULL,
0x00000002cb0c7824ULL, 0x000fe400078e00ffULL, 0x00006400ff4f7624ULL, 0x000fc400078e00ffULL,
0xff317217ff6a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3f7224ULL, 0x000fe400078e00ffULL,
0x000064000c4f7624ULL, 0x000fc400078e024fULL, 0x00000100070b7824ULL, 0x000fca00078e00ffULL,
0x000000060b00720cULL, 0x000fda0003f06070ULL, 0x0000b19000000947ULL, 0x020fea0003800000ULL,
0x00000001070c7810ULL, 0x000fe20007ffe0ffULL, 0x00005800044d7a24ULL, 0x000fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000050c00720cULL, 0x000fe20003f26070ULL,
0x000000ffff507224ULL, 0x000fe400078e0002ULL, 0x000000804d4d7824ULL, 0x000fd400078e00ffULL,
0x0000074000009947ULL, 0x000fea0003800000ULL, 0x00000003ff267819ULL, 0x100fe40000011600ULL,
0x00000020070b7811ULL, 0x000fe400078e40ffULL, 0x0000000426147810ULL, 0x000fe40007ffe0ffULL,
0x0000000b060c7217ULL, 0x000fe40007800000ULL, 0x0000000826387810ULL, 0x000fe20007ffe0ffULL,
0x00000001140d7824ULL, 0x100fe200078e0200ULL, 0x0000000c26407810ULL, 0x000fe20007ffe0ffULL,
0x00000008140e7824ULL, 0x000fe200078e00ffULL, 0x0000001026427810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0b7824ULL, 0x000fe200078e0a0bULL, 0x0000002009177810ULL, 0x000fe20007ffe0ffULL,
0x00000001380c7824ULL, 0x100fe200078e0200ULL, 0xfffffff80e417812ULL, 0x000fe200078ee20dULL,
0x0000000838437824ULL, 0x000fe200078e00ffULL, 0x0000001826467810ULL, 0x000fe20007ffe0ffULL,
0x00000001400d7824ULL, 0x000fe200078e0200ULL, 0x0000001426447810ULL, 0x000fe20007ffe0ffULL,
0x0000000840107824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee20cULL,
0x00000001420e7824ULL, 0x100fe200078e0200ULL, 0x0000001c26487810ULL, 0x000fe20007ffe0ffULL,
0x0000000842477824ULL, 0x000fe200078e00ffULL, 0xfffffff810457812ULL, 0x000fe200078ee20dULL,
0x00000001260c7824ULL, 0x000fe200078e0217ULL, 0x000000200b0b7817ULL, 0x000fe20003800000ULL,
0x00000001460f7824ULL, 0x040fe200078e0200ULL, 0xfffffff847477812ULL, 0x000fe200078ee20eULL,
0x0000000846127824ULL, 0x000fe200078e00ffULL, 0x0000000c4d0d7210ULL, 0x000fe20007f1e0ffULL,
0x00000001440e7824ULL, 0x100fe200078e0200ULL, 0x0000000b1400720cULL, 0x000fe20003fa6070ULL,
0x0000000844497824ULL, 0x000fe200078e00ffULL, 0xfffffff8124b7812ULL, 0x000fe200078ee20fULL,
0x0000000148107824ULL, 0x000fc400078e0200ULL, 0x0000000848517824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee20eULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078048ffULL, 0x00000001140e7824ULL, 0x100fe200078e0217ULL,
0xfffffff851517812ULL, 0x000fe200078ee210ULL, 0x0000000138107824ULL, 0x100fe200078e0217ULL,
0x00005f000d0d7a11ULL, 0x000fe200000f4c12ULL, 0x0000000140127824ULL, 0x100fe200078e0217ULL,
0x0000000e4d0f7210ULL, 0x040fe20007f1e0ffULL, 0x0000000142147824ULL, 0x000fe200078e0217ULL,
0x000000104d117210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff247224ULL, 0x000fe200000e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078048ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe400078448ffULL, 0x00005f000f0f7a11ULL, 0x000fe400000f4c24ULL,
0x000000124d137210ULL, 0x000fe40007f1e0ffULL, 0x00005f0011117a11ULL, 0x000fe400010f4c16ULL,
0x000000144d157210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff247224ULL, 0x000fe200000e06ffULL,
0x0000000b2600720cULL, 0x040fe20003f46070ULL, 0x0000000126267824ULL, 0x000fe200078e0200ULL,
0x00005e0013127a11ULL, 0x000fe200078648ffULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005e0015147a11ULL, 0x000fc400078848ffULL, 0x00005f0013137a11ULL, 0x000fe200018f4c24ULL,
0x0000000144247824ULL, 0x100fe200078e0217ULL, 0x0000000726257812ULL, 0x000fe200078ec0ffULL,
0x0000000148267824ULL, 0x100fe200078e0217ULL, 0x00005f0015157a11ULL, 0x000fe400020f4c16ULL,
0x0ffffff8253b7812ULL, 0x000fe400078ef800ULL, 0x0000000700167812ULL, 0x000fe400078ec0ffULL,
0x000000244d257210ULL, 0x000fe20007f7e0ffULL, 0x0000000146247824ULL, 0x000fe200078e0217ULL,
0x0000000b3800720cULL, 0x080fe20003f06070ULL, 0x0000000103397824ULL, 0x000fe200078e0216ULL,
0x0001500008387811ULL, 0x000fe200078e68ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005e0025167a11ULL, 0x000fe200078648ffULL, 0x00000010390c7825ULL, 0x000fe200078e000cULL,
0x0000000b4000720cULL, 0x000fc40003f86070ULL, 0x00005f0025177a11ULL, 0x000fe200018f4c3aULL,
0x000000103b3b7824ULL, 0x100fe200078e0238ULL, 0x000000244d257210ULL, 0x000fe20007f7e0ffULL,
0x0000001041417824ULL, 0x000fe400078e0238ULL, 0x00000010390e7825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c3b7faeULL, 0x0003e2000d101c46ULL,
0x000000264d277210ULL, 0x000fe40007f5e0ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078c48ffULL, 0x000000000e417faeULL, 0x0005e2000e901c46ULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x0000000b4200720cULL, 0x000fc40003f66070ULL,
0x00005f0025257a11ULL, 0x000fe400030f4c26ULL, 0x00005e0027267a11ULL, 0x000fe200078448ffULL,
0x00000010390c7825ULL, 0x002fe200078e0010ULL, 0x0000000b4400720cULL, 0x080fe40003fc6070ULL,
0x0000000b4600720cULL, 0x080fe20003fa6070ULL, 0x00000010453b7824ULL, 0x000fe200078e0238ULL,
0x00005f0027277a11ULL, 0x000fe200010f4c3aULL, 0x00000010390e7825ULL, 0x004fe200078e0012ULL,
0x0000000b4800720cULL, 0x000fc60003f46070ULL, 0x00000010430b7824ULL, 0x100fe400078e0238ULL,
0x0000001047437824ULL, 0x000fe400078e0238ULL, 0x0000001039107825ULL, 0x000fe200078e0014ULL,
0x000000000c0b7faeULL, 0x0003e6000c101c46ULL, 0x0000001049457824ULL, 0x000fe200078e0238ULL,
0x000000000e3b7faeULL, 0x0003e2000e101c46ULL, 0x0000001039127825ULL, 0x000fc600078e0016ULL,
0x0000000010437faeULL, 0x0003e2000d901c46ULL, 0x000000104b477824ULL, 0x000fe400078e0238ULL,
0x0000001039147825ULL, 0x000fe200078e0024ULL, 0x0000000012457faeULL, 0x0003e6000f101c46ULL,
0x0000001051497824ULL, 0x000fe200078e0238ULL, 0x0000000014477faeULL, 0x0003e2000e901c46ULL,
0x0000001039167825ULL, 0x000fca00078e0026ULL, 0x0000000016497faeULL, 0x0003e2000d101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x00000004000e7811ULL, 0x040fe400078fe8ffULL,
0x0000000c00127811ULL, 0x040fe400078fe8ffULL, 0x0000000800107811ULL, 0x000fe200078fe8ffULL,
0x000000010e0b7824ULL, 0x100fe200078e0200ULL, 0x0000001800247811ULL, 0x000fe200078fe8ffULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0x0000001c000f7811ULL, 0x000fe200078fe8ffULL,
0x00000001120d7824ULL, 0x100fe200078e0200ULL, 0x0001500008407811ULL, 0x000fe200078e68ffULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0xfffffff814397812ULL, 0x000fe200078ee20bULL,
0x00000001100c7824ULL, 0x100fe200078e0200ULL, 0x0000001000147811ULL, 0x000fe200078fe8ffULL,
0x00000008103b7824ULL, 0x000fe200078e00ffULL, 0xfffffff816417812ULL, 0x000fe200078ee20dULL,
0x00000001240d7824ULL, 0x100fe200078e0200ULL, 0x0000001400167811ULL, 0x000fe200078fe8ffULL,
0x00000001140b7824ULL, 0x040fe200078e0200ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20cULL,
0x0000000814267824ULL, 0x000fe200078e00ffULL, 0x0000000700427812ULL, 0x000fe200078ec0ffULL,
0x00000001160c7824ULL, 0x000fc400078e0200ULL, 0x0000000816457824ULL, 0x000fe200078e00ffULL,
0xfffffff826437812ULL, 0x000fe200078ee20bULL, 0x0000000824267824ULL, 0x000fe200078e00ffULL,
0x00000020090b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f117824ULL, 0x000fe200078e0200ULL,
0xfffffff845457812ULL, 0x000fe200078ee20cULL, 0x000000080f387824ULL, 0x000fe200078e00ffULL,
0x00000000000c7211ULL, 0x000fe200078fe8ffULL, 0x000000010e0e7824ULL, 0x000fe200078e020bULL,
0xfffffff826477812ULL, 0x000fe200078ee20dULL, 0x0000000110107824ULL, 0x100fe200078e020bULL,
0x000000070c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000112127824ULL, 0x100fe200078e020bULL,
0x0000000b000c7211ULL, 0x000fe200078fe8ffULL, 0x0000000114147824ULL, 0x000fe200078e020bULL,
0xfffffff838117812ULL, 0x000fe200078ee211ULL, 0x0000000116167824ULL, 0x000fc400078e020bULL,
0x0000000124247824ULL, 0x100fe200078e020bULL, 0x000000144d157210ULL, 0x000fe20007f7e0ffULL,
0x000000010f267824ULL, 0x000fe200078e020bULL, 0x0ffffff80d0b7812ULL, 0x000fe200078ef800ULL,
0x0000001011497824ULL, 0x100fe200078e0240ULL, 0x0000000c4d0d7210ULL, 0x000fe20007f1e0ffULL,
0x0000001039397824ULL, 0x100fe200078e0240ULL, 0x0000000e4d0f7210ULL, 0x000fe20007f5e0ffULL,
0x000000100b0b7824ULL, 0x100fe400078e0240ULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078048ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0240ULL,
0x00005f000d0d7a11ULL, 0x000fe200000f4c3aULL, 0x0000001041417824ULL, 0x100fe200078e0240ULL,
0x000000104d117210ULL, 0x000fe20007f1e0ffULL, 0x0000001043437824ULL, 0x000fe200078e0240ULL,
0x00005f000f0f7a11ULL, 0x000fe200010f4c38ULL, 0x0000001045457824ULL, 0x100fe200078e0240ULL,
0x000000124d137210ULL, 0x000fe20007f5e0ffULL, 0x0000001047477824ULL, 0x000fc400078e0240ULL,
0x000000ffff407224ULL, 0x000fe200000e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078048ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078448ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078648ffULL,
0x00000001034b7824ULL, 0x000fe200078e0242ULL, 0x00005f0011117a11ULL, 0x000fe400000f4c40ULL,
0x00005f0013137a11ULL, 0x000fe200010f4c3aULL, 0x000000104b0c7825ULL, 0x000fe200078e000cULL,
0x000000164d177210ULL, 0x000fc40007f1e0ffULL, 0x00005f0015157a11ULL, 0x000fe200018f4c38ULL,
0x000000104b0e7825ULL, 0x000fe200078e000eULL, 0x000000244d257210ULL, 0x040fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c46ULL,
0x000000264d277210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff407224ULL, 0x000fe200000e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078048ffULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078448ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078648ffULL, 0x000000104b107825ULL, 0x000fe200078e0010ULL,
0x00005f0017177a11ULL, 0x000fe200000f4c40ULL, 0x000000000e397faeULL, 0x0003e2000b901c46ULL,
0x00005f0025257a11ULL, 0x000fe200010f4c3aULL, 0x000000104b127825ULL, 0x000fe200078e0012ULL,
0x00005f0027277a11ULL, 0x000fe200018f4c38ULL, 0x00000000103b7faeULL, 0x0003e4000b901c46ULL,
0x000000104b147825ULL, 0x000fc400078e0014ULL, 0x0000000012417faeULL, 0x0003e4000b901c46ULL,
0x000000104b167825ULL, 0x040fe400078e0016ULL, 0x0000000014437faeULL, 0x0003e4000b901c46ULL,
0x000000104b247825ULL, 0x040fe400078e0024ULL, 0x0000000016457faeULL, 0x0003e4000b901c46ULL,
0x000000104b267825ULL, 0x000fc400078e0026ULL, 0x0000000024477faeULL, 0x0003e8000b901c46ULL,
0x0000000026497faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6080003107f8cULL, 0x0022a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01c60c00030b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x00cfe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c0e7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001140fULL, 0x0000000e0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e060fULL, 0x000000020b0b7819ULL, 0x000fc8000000120eULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01c60c00030b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000517824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011600ULL, 0x0000007051517812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0c7812ULL, 0x000fca00078ec0ffULL, 0x0000000151517824ULL, 0x000fca00078e020cULL,
0x01c00000510b7984ULL, 0x000ea80000000800ULL, 0x01c2000051117984ULL, 0x0006620000000800ULL,
0x0000006a0b00720bULL, 0x004fe20003f1d000ULL, 0x000172a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c137812ULL, 0x000fe2000784c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff4e7224ULL, 0x000fd400078e006aULL, 0x000004100000a947ULL, 0x000fea0003800000ULL,
0x000000ff0800720cULL, 0x000fe40003f45270ULL, 0x0000006a0b00720bULL, 0x000fe20003f74000ULL,
0x000172727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x000fc400018e0100ULL,
0x0000000b6a4e7209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x00009910100c7816ULL, 0x000fc600000000ffULL, 0x01c4004e5100a388ULL, 0x0005e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f45270ULL, 0x000003000000a947ULL, 0x000fea0003800000ULL,
0x8000004e6a0c7221ULL, 0x004fe20000010000ULL, 0x000000ff10ff7812ULL, 0x000fe2000784c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00417308ULL, 0x0004ec0000000800ULL, 0x000001300000a947ULL, 0x000fea0003800000ULL,
0x00000002ff407819ULL, 0x000fe20000011600ULL, 0x000171e27f007947ULL, 0x000fea000b800000ULL,
0x00001f40410e7589ULL, 0x0086a400000e0000ULL, 0x0000000e18187220ULL, 0x084fe40000410000ULL,
0x0000000e19197220ULL, 0x080fe40000410000ULL, 0x0000000e1c1c7220ULL, 0x000fc40000410000ULL,
0x0000000e1d1d7220ULL, 0x080fe40000410000ULL, 0x0000000e20207220ULL, 0x080fe40000410000ULL,
0x0000000e21217220ULL, 0x080fe40000410000ULL, 0x0000000e28287220ULL, 0x080fe40000410000ULL,
0x0000000e29297220ULL, 0x080fe40000410000ULL, 0x0000000e2c2c7220ULL, 0x000fc40000410000ULL,
0x0000000e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000e30307220ULL, 0x080fe40000410000ULL,
0x0000000e31317220ULL, 0x080fe40000410000ULL, 0x0000000e34347220ULL, 0x080fe40000410000ULL,
0x0000000e35357220ULL, 0x080fe40000410000ULL, 0x0000000e3c3c7220ULL, 0x000fc40000410000ULL,
0x0000000e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0010ff7812ULL, 0x000fe2000784c0ffULL, 0x000000410a0a7220ULL, 0x008fd80000410000ULL,
0x000001300000a947ULL, 0x000fea0003800000ULL, 0x0000000800407811ULL, 0x002fe200078ff0ffULL,
0x000170c27f007947ULL, 0x000fea000b800000ULL, 0x00001f40410e7589ULL, 0x0002e400000e0000ULL,
0x0000000e1a1a7220ULL, 0x08cfe40000410000ULL, 0x0000000e1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000e1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000e1f1f7220ULL, 0x080fe40000410000ULL,
0x0000000e22227220ULL, 0x080fe40000410000ULL, 0x0000000e23237220ULL, 0x000fc40000410000ULL,
0x0000000e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000e2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000000e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000e32327220ULL, 0x080fe40000410000ULL, 0x0000000e33337220ULL, 0x000fc40000410000ULL,
0x0000000e36367220ULL, 0x080fe40000410000ULL, 0x0000000e37377220ULL, 0x080fe40000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff13ff7812ULL, 0x000fda0007846010ULL,
0x8000004e0b0b2221ULL, 0x000fe20000010000ULL, 0x000000000000281cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0b0b2820ULL, 0x000fc80000410000ULL, 0x0000000b00522308ULL, 0x000ea40000000800ULL,
0x0000005211112220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x0000000a110a7221ULL, 0x002fe20000010000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000052ff0b723eULL, 0x000fe400000000ffULL, 0x00000002ff107819ULL, 0x000fe40000011600ULL,
0x000054100b417816ULL, 0x000fe2000000000bULL, 0x00016f027f007947ULL, 0x000fea000b800000ULL,
0x00001f1041537589ULL, 0x0002a400000e0000ULL, 0x0000000810407810ULL, 0x002fe20007ffe0ffULL,
0x00016f427f007947ULL, 0x000fea000b800000ULL, 0x00001f4041547589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001010407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00002d40000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00017e8000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001810407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00002da0000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x004fc400078e00ffULL, 0x00017e2000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000700567812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008000b7812ULL, 0x000fc400078ec0ffULL,
0x00000008560d7812ULL, 0x000fc800078ef800ULL, 0x0000000d006a7211ULL, 0x000fe200078fe0ffULL,
0x000000080d557824ULL, 0x000fca00078e00ffULL, 0xfffffff855557812ULL, 0x000fc800078ee26aULL,
0x0001200055107811ULL, 0x000fca00078e20ffULL, 0x000000070b0b7812ULL, 0x000fe200078ef800ULL,
0x000000001010783bULL, 0x000f220000000200ULL, 0x0001400008577811ULL, 0x000fe200078e68ffULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000b000c7211ULL, 0x000fe200078fe0ffULL,
0x000000080b0f7824ULL, 0x042fe200078e00ffULL, 0x000000026a5c7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0e7824ULL, 0x044fe200078e00ffULL, 0x000000020c637810ULL, 0x040fe20007ffe0ffULL,
0x000000080b147824ULL, 0x040fe200078e00ffULL, 0x000000040c6b7810ULL, 0x040fe20007ffe0ffULL,
0x000000080b157824ULL, 0x000fe200078e00ffULL, 0x000000060c6c7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80f587812ULL, 0x000fe400078ee20cULL, 0xfffffff80e637812ULL, 0x000fe400078ee263ULL,
0xfffffff8146b7812ULL, 0x000fe200078ee26bULL, 0x0000001058587824ULL, 0x100fe200078e0257ULL,
0xfffffff8156c7812ULL, 0x000fe200078ee26cULL, 0x0000001063597824ULL, 0x100fe200078e0257ULL,
0x000000100b0b7812ULL, 0x000fe200078efcffULL, 0x000000106b5a7824ULL, 0x100fe200078e0257ULL,
0x000000005864783bULL, 0x000e620000004200ULL, 0x000000106c5b7824ULL, 0x000fe200078e0257ULL,
0x0000000b000c7211ULL, 0x000fe200078fe0ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0x000000005914783bULL, 0x000ea20000004200ULL, 0xfffffff80d5c7812ULL, 0x000fe200078ee25cULL,
0x000000080b0e7824ULL, 0x040fe200078e00ffULL, 0x000000020c687810ULL, 0x040fe20007ffe0ffULL,
0x000000005a40783bULL, 0x000fe20000004200ULL, 0x000000080b0d7824ULL, 0x040fe200078e00ffULL,
0x000000040c697810ULL, 0x000fe20007ffe0ffULL, 0x000000080b247824ULL, 0x000fe200078e00ffULL,
0x000000005b44783bULL, 0x000fe20000004200ULL, 0x000120005c387811ULL, 0x000fc400078e20ffULL,
0x000000060c0b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80f687812ULL, 0x000fe200078ee268ULL,
0x0000005310100232ULL, 0x090fe20000000000ULL, 0xfffffff80e697812ULL, 0x000fe200078ee269ULL,
0x000000003838783bULL, 0x000f220000000200ULL, 0xfffffff80d4c7812ULL, 0x000fe200078ee20cULL,
0x00000010685e7824ULL, 0x000fe200078e0257ULL, 0xfffffff8240b7812ULL, 0x000fe200078ee20bULL,
0x00000010695f7824ULL, 0x100fe200078e0257ULL, 0x0000005312120232ULL, 0x000fe20000000000ULL,
0x000000104c5d7824ULL, 0x100fe200078e0257ULL, 0x000000005e24783bULL, 0x000ee20000004200ULL,
0x000000100b607824ULL, 0x000fe200078e0257ULL, 0x0000005411110232ULL, 0x008fc40000000000ULL,
0x000000005f48783bULL, 0x000ee20000004200ULL, 0x0000005413130232ULL, 0x000fc60000000000ULL,
0x000000005d70783bULL, 0x000ee80000004200ULL, 0x00000000600c783bULL, 0x000ee20000004200ULL,
0x000000641018723cULL, 0x042ff00000001818ULL, 0x00000066101c723cULL, 0x040ff0000000181cULL,
0x000000141064723cULL, 0x004f620000001820ULL, 0x0000005338380232ULL, 0x010fc40000000000ULL,
0x000000533a3a0232ULL, 0x000fca0000000000ULL, 0x000000161014723cULL, 0x000fe20000001828ULL,
0x0000005439390232ULL, 0x080fe40000000000ULL, 0x000000543b3b0232ULL, 0x000fca0000000000ULL,
0x00000040102c723cULL, 0x040f70000000182cULL, 0x000000421030723cULL, 0x040f700000001830ULL,
0x000000441028723cULL, 0x040f700000001834ULL, 0x00000046103c723cULL, 0x000f70000000183cULL,
0x000000243834723cULL, 0x060b700000001864ULL, 0x00000048382c723cULL, 0x048b70000000182cULL,
0x000000703820723cULL, 0x040b700000001818ULL, 0x000000723810723cULL, 0x040b70000000181cULL,
0x000000263824723cULL, 0x040b700000001814ULL, 0x0000004a3848723cULL, 0x040b700000001830ULL,
0x0000000c3844723cULL, 0x040b700000001828ULL, 0x0000000e3838723cULL, 0x000b62000000183cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000072000009947ULL, 0x000fca0003800000ULL,
0x00000003ff1b7819ULL, 0x020fe20000011600ULL, 0x0000000103297824ULL, 0x000fe200078e0256ULL,
0x00000040070d7811ULL, 0x000fe400078e40ffULL, 0x000000081b197810ULL, 0x040fe40007ffe0ffULL,
0x000000041b177810ULL, 0x000fe40007ffe0ffULL, 0x0000000d060c7217ULL, 0x000fe20007800000ULL,
0x0000000119147824ULL, 0x100fe200078e0200ULL, 0x0000000c1b1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819157824ULL, 0x000fe200078e00ffULL, 0x000000141b3f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001170f7824ULL, 0x000fe200078e0200ULL, 0x000000101b3d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000817307824ULL, 0x000fe200078e00ffULL, 0xfffffff815327812ULL, 0x000fe200078ee214ULL,
0x000000010c0e7824ULL, 0x000fe200078e0a0dULL, 0x00000040091c7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d0c7824ULL, 0x140fe200078e0200ULL, 0xfffffff830307812ULL, 0x000fe200078ee20fULL,
0x000000081d157824ULL, 0x000fe200078e00ffULL, 0x000000181b417810ULL, 0x000fe20007ffe0ffULL,
0x000000013f0f7824ULL, 0x000fe200078e0200ULL, 0x0000001c1b437810ULL, 0x000fe20007ffe0ffULL,
0x000000083f407824ULL, 0x000fe200078e00ffULL, 0xfffffff8153c7812ULL, 0x000fe200078ee20cULL,
0x000000013d0d7824ULL, 0x040fe200078e0200ULL, 0x000000200e287817ULL, 0x000fe20003800000ULL,
0x000000083d3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee20fULL,
0x000000011b0c7824ULL, 0x000fe200078e021cULL, 0x000000281900720cULL, 0x000fe20003fa6070ULL,
0x00000001410f7824ULL, 0x040fe200078e0200ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x0000000841427824ULL, 0x000fe200078e00ffULL, 0x0000000c4d0d7210ULL, 0x000fe20007f5e0ffULL,
0x0000000117147824ULL, 0x000fc400078e021cULL, 0x0000000143157824ULL, 0x040fe200078e0200ULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x0000000843627824ULL, 0x000fe200078e00ffULL,
0x000000144d0f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078448ffULL, 0x0000000119147824ULL, 0x000fe200078e021cULL,
0xfffffff862627812ULL, 0x000fe200078ee215ULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x00005f000d0d7a11ULL, 0x000fe200010f4c16ULL, 0x000000011d167824ULL, 0x000fe200078e021cULL,
0x000000144d157210ULL, 0x000fe20007f9e0ffULL, 0x0000001030317824ULL, 0x000fe200078e0257ULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x00000010290c7825ULL, 0x000fe200078e000cULL,
0x000000281700720cULL, 0x000fc40003f66070ULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c18ULL,
0x000000ffff1a7224ULL, 0x000fe200020e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078448ffULL,
0x000000013d187824ULL, 0x000fe200078e021cULL, 0x000000164d177210ULL, 0x000fe20007f9e0ffULL,
0x00000010290e7825ULL, 0x000fe200078e000eULL, 0x00005f0015157a11ULL, 0x000fe400010f4c1aULL,
0x000000184d197210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x000000281b00720cULL, 0x040fe20003f86070ULL, 0x000000011b1b7824ULL, 0x000fe200078e0200ULL,
0x00005e0017167a11ULL, 0x000fe200078448ffULL, 0x000000ffff1e7224ULL, 0x000fe200030e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078c48ffULL, 0x0000001032337824ULL, 0x000fe200078e0257ULL,
0x000000071b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000001029147825ULL, 0x000fe200078e0014ULL,
0x00005f0017177a11ULL, 0x000fc400010f4c1aULL, 0x0ffffff81b2a7812ULL, 0x000fe200078ef800ULL,
0x000000013f1a7824ULL, 0x000fe200078e021cULL, 0x00005f0019197a11ULL, 0x000fe200030f4c1eULL,
0x00000001411e7824ULL, 0x100fe200078e021cULL, 0x000000281d00720cULL, 0x000fe20003f46070ULL,
0x000000102a2b7824ULL, 0x000fe200078e0257ULL, 0x0000001a4d1b7210ULL, 0x000fe20007fde0ffULL,
0x00000001431c7824ULL, 0x000fc600078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c2b7faeULL, 0x0003e2000e101c46ULL, 0x000000ffff2a7224ULL, 0x000fe200030e06ffULL,
0x0000001e4d1e7210ULL, 0x000fe40007f9e0ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078c48ffULL,
0x000000000e317faeULL, 0x0005e2000d901c46ULL, 0x0000001c4d1f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e06ffULL, 0x00005f001b1b7a11ULL, 0x000fe200030f4c2aULL,
0x0000000014337faeULL, 0x0007e2000e901c46ULL, 0x00005e001e1c7a11ULL, 0x040fe200078c48ffULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x000000283d00720cULL, 0x000fe20003f86070ULL,
0x00000010290c7825ULL, 0x002fe200078e0016ULL, 0x00005f001e1d7a11ULL, 0x000fc400030f4c1dULL,
0x00005e001f1e7a11ULL, 0x000fe200078648ffULL, 0x00000010290e7825ULL, 0x004fe200078e0018ULL,
0x000000283f00720cULL, 0x080fe40003fc6070ULL, 0x000000284100720cULL, 0x080fe20003fa6070ULL,
0x0000001029187825ULL, 0x000fe200078e001cULL, 0x00005f001f1f7a11ULL, 0x000fe400018f4c2aULL,
0x000000284300720cULL, 0x000fe20003f66070ULL, 0x0000001029167825ULL, 0x000fc800078e001aULL,
0x000000103c1d7824ULL, 0x000fe400078e0257ULL, 0x00000010291a7825ULL, 0x000fc600078e001eULL,
0x000000000c1d7faeULL, 0x0003e2000d101c46ULL, 0x000000103e157824ULL, 0x108fe400078e0257ULL,
0x00000010401f7824ULL, 0x100fe400078e0257ULL, 0x0000001042297824ULL, 0x100fe200078e0257ULL,
0x000000000e157faeULL, 0x0003e2000e101c46ULL, 0x00000010622b7824ULL, 0x000fc600078e0257ULL,
0x00000000161f7faeULL, 0x0003e8000f101c46ULL, 0x0000000018297faeULL, 0x0003e8000e901c46ULL,
0x000000001a2b7faeULL, 0x0003e2000d901c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000004000e7811ULL, 0x060fe400078fe8ffULL, 0x0000000800147811ULL, 0x000fc400078fe8ffULL,
0x0000001000187811ULL, 0x000fe200078fe8ffULL, 0x000000010e0c7824ULL, 0x100fe200078e0200ULL,
0x00000018001c7811ULL, 0x000fe200078fe8ffULL, 0x000000080e157824ULL, 0x000fe200078e00ffULL,
0x0000000c00167811ULL, 0x000fe200078fe8ffULL, 0x00000001140d7824ULL, 0x000fe200078e0200ULL,
0x00000014001a7811ULL, 0x000fe200078fe8ffULL, 0x00000008143c7824ULL, 0x000fe200078e00ffULL,
0xfffffff815327812ULL, 0x000fe200078ee20cULL, 0x00000001180c7824ULL, 0x100fe200078e0200ULL,
0x00000000001d7211ULL, 0x000fe200078fe8ffULL, 0x000000011c157824ULL, 0x000fe200078e0200ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20dULL, 0x00000008180d7824ULL, 0x000fe200078e00ffULL,
0x000000071d297812ULL, 0x000fe200078ec0ffULL, 0x000000081c627824ULL, 0x000fc400078e00ffULL,
0x00000001160f7824ULL, 0x040fe200078e0200ULL, 0xfffffff80d407812ULL, 0x000fe200078ee20cULL,
0x00000008163e7824ULL, 0x000fe200078e00ffULL, 0x00000040090d7810ULL, 0x000fe20007ffe0ffULL,
0x000000081a427824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ee215ULL,
0x0000001032317824ULL, 0x000fe200078e0257ULL, 0x0000001c00157811ULL, 0x000fe200078fe8ffULL,
0x000000010e0e7824ULL, 0x000fe200078e020dULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20fULL,
0x000000011a0f7824ULL, 0x000fe200078e0200ULL, 0x0000000d000c7211ULL, 0x000fe200078fe8ffULL,
0x0000000114147824ULL, 0x000fc400078e020dULL, 0x0000000116167824ULL, 0x000fe200078e020dULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x0000000118187824ULL, 0x100fe200078e020dULL,
0x0000000e4d0f7210ULL, 0x040fe20007f7e0ffULL, 0x000000011a1a7824ULL, 0x100fe400078e020dULL,
0x000000011c1c7824ULL, 0x100fe200078e020dULL, 0x000000184d197210ULL, 0x000fe20007f9e0ffULL,
0x00000001151e7824ULL, 0x000fe200078e020dULL, 0x0000000c4d0d7210ULL, 0x000fe20007f5e0ffULL,
0x0000000115177824ULL, 0x000fc400078e0200ULL, 0x0000000815647824ULL, 0x000fe400078e00ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078448ffULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078648ffULL,
0x000000103c337824ULL, 0x100fe200078e0257ULL, 0x00005f000d0d7a11ULL, 0x000fe200010f4c2aULL,
0x00000010403d7824ULL, 0x100fe200078e0257ULL, 0x000000144d157210ULL, 0x000fe20007f5e0ffULL,
0x00000010423f7824ULL, 0x000fe200078e0257ULL, 0xfffffff864647812ULL, 0x000fe200078ee217ULL,
0x0000001062417824ULL, 0x100fe200078e0257ULL, 0x00005f000f0f7a11ULL, 0x000fe200018f4c28ULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x000000164d177210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078448ffULL,
0x0000001064437824ULL, 0x000fe200078e0257ULL, 0x00005e0019187a11ULL, 0x000fe200078848ffULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x00005e0017167a11ULL, 0x000fc400078648ffULL,
0x00005f0015157a11ULL, 0x000fe400010f4c30ULL, 0x0000001a4d1b7210ULL, 0x000fe40007f5e0ffULL,
0x00005f0017177a11ULL, 0x000fe400018f4c2aULL, 0x00005f0019197a11ULL, 0x000fe200020f4c28ULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x0000001c4d1d7210ULL, 0x040fe40007f7e0ffULL,
0x0000001e4d1f7210ULL, 0x000fc40007f9e0ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078648ffULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe400078848ffULL,
0x00005f001b1b7a11ULL, 0x000fe400010f4c30ULL, 0x0ffffff829307812ULL, 0x000fe200078ef800ULL,
0x0000000103297824ULL, 0x000fe200078e0256ULL, 0x00005f001d1d7a11ULL, 0x000fc400018f4c2aULL,
0x00005f001f1f7a11ULL, 0x000fe200020f4c28ULL, 0x00000010302b7824ULL, 0x000fe400078e0257ULL,
0x00000010290c7825ULL, 0x000fc800078e000cULL, 0x00000010290e7825ULL, 0x040fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c2b7faeULL, 0x0003e6000b901c46ULL,
0x0000001029147825ULL, 0x040fe200078e0014ULL, 0x000000000e317faeULL, 0x0003e6000b901c46ULL,
0x0000001029167825ULL, 0x040fe200078e0016ULL, 0x0000000014337faeULL, 0x0003e6000b901c46ULL,
0x0000001029187825ULL, 0x000fc800078e0018ULL, 0x00000010291a7825ULL, 0x000fc800078e001aULL,
0x00000010291c7825ULL, 0x000fc800078e001cULL, 0x00000010291e7825ULL, 0x000fc800078e001eULL,
0x000000103e297824ULL, 0x000fca00078e0257ULL, 0x0000000016297faeULL, 0x0003e8000b901c46ULL,
0x00000000183d7faeULL, 0x0003e8000b901c46ULL, 0x000000001a3f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c417faeULL, 0x0003e8000b901c46ULL, 0x000000001e437faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000052ff0c723eULL, 0x002fe400000000ffULL, 0x00000002ff147819ULL, 0x000fe40000011600ULL,
0x000054100c417816ULL, 0x000fe2000000000cULL, 0x00015bb27f007947ULL, 0x000fea000b800000ULL,
0x00001f1441537589ULL, 0x0002a400000e0000ULL, 0x0000000814407810ULL, 0x002fe20007ffe0ffULL,
0x00015bf27f007947ULL, 0x000fea000b800000ULL, 0x00001f4041547589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001014407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00004160000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00016a6000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001814407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x000041c0000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x004fc400078e00ffULL, 0x00016a0000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008560c7812ULL, 0x002fe200078ef800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000046a617810ULL, 0x000fc40007ffe0ffULL,
0x00000008000d7812ULL, 0x000fe200078ec0ffULL, 0x000000080c0e7824ULL, 0x004fca00078e00ffULL,
0xfffffff80e617812ULL, 0x000fc800078ee261ULL, 0x0001200061147811ULL, 0x000fca00078e20ffULL,
0x000000070d0d7812ULL, 0x000fe200078ef800ULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x0000100057627810ULL, 0x000fe20007ffe0ffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000d000e7211ULL, 0x000fe200078fe0ffULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0x000000066a677810ULL, 0x000fe20007ffe0ffULL, 0x0000001063637824ULL, 0x100fe400078e0262ULL,
0x000000106b647824ULL, 0x000fe200078e0262ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20eULL,
0x000000106c657824ULL, 0x100fe200078e0262ULL, 0x000000006370783bULL, 0x000ea20000004200ULL,
0xfffffff80c677812ULL, 0x000fe200078ee267ULL, 0x0000001068687824ULL, 0x000fc400078e0262ULL,
0x000000100d667824ULL, 0x100fe200078e0262ULL, 0x00000000646c783bULL, 0x000f220000004200ULL,
0x00012000671c7811ULL, 0x000fe200078e20ffULL, 0x0000001069697824ULL, 0x100fe400078e0262ULL,
0x000000006540783bULL, 0x000fe20000004200ULL, 0x000000100b0b7824ULL, 0x100fe400078e0262ULL,
0x000000104c4c7824ULL, 0x000fe200078e0262ULL, 0x000000006618783bULL, 0x000fe80000004200ULL,
0x000000001c1c783bULL, 0x000ee80000000200ULL, 0x000000006828783bULL, 0x000ee80000004200ULL,
0x000000006930783bULL, 0x000ee80000004200ULL, 0x000000000b3c783bULL, 0x000ee20000004200ULL,
0x0000005314140232ULL, 0x002fc40000000000ULL, 0x0000005316160232ULL, 0x000fe20000000000ULL,
0x000000004c0c783bULL, 0x000e620000004200ULL, 0x0000005415150232ULL, 0x088fe40000000000ULL,
0x0000005417170232ULL, 0x000fce0000000000ULL, 0x000000701434723cULL, 0x044f700000001834ULL,
0x0000006c142c723cULL, 0x010f62000000182cULL, 0x000000531c1c0232ULL, 0x000fce0000000000ULL,
0x000000401444723cULL, 0x000f620000001844ULL, 0x000000531e1e0232ULL, 0x000fe40000000000ULL,
0x000000541d1d0232ULL, 0x080fe40000000000ULL, 0x000000541f1f0232ULL, 0x000fc60000000000ULL,
0x000000421438723cULL, 0x040ff00000001838ULL, 0x000000721424723cULL, 0x040f700000001824ULL,
0x0000006e1448723cULL, 0x040f700000001848ULL, 0x000000181440723cULL, 0x040f700000001820ULL,
0x0000001a1410723cULL, 0x000f700000001810ULL, 0x000000281c20723cULL, 0x060b700000001834ULL,
0x000000301c2c723cULL, 0x040b70000000182cULL, 0x0000003c1c34723cULL, 0x040b700000001844ULL,
0x0000002a1c28723cULL, 0x040b700000001824ULL, 0x000000321c30723cULL, 0x040b700000001848ULL,
0x0000003e1c3c723cULL, 0x040b700000001838ULL, 0x0000000c1c18723cULL, 0x042b700000001840ULL,
0x0000000e1c1c723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000040070d7811ULL, 0x020fe200078e40ffULL, 0x01c68800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff6a7224ULL, 0x000fc400078e004eULL, 0x000000060d00720cULL, 0x000fda0003f06070ULL,
0x000081e000000947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x000fe20000011600ULL,
0x00000001033b7824ULL, 0x000fe200078e0256ULL, 0x0000006009107810ULL, 0x000fe40007ffe0ffULL,
0x00000060070d7811ULL, 0x000fe400078e40ffULL, 0x0000000413157810ULL, 0x040fe20007ffe0ffULL,
0x00000001130c7824ULL, 0x040fe200078e0210ULL, 0x0000000d06047217ULL, 0x000fe40007800000ULL,
0x0000000813177810ULL, 0x000fe20007ffe0ffULL, 0x0000000115117824ULL, 0x100fe200078e0200ULL,
0x0000000c4d0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104047824ULL, 0x000fe200078e0a0dULL,
0x0000000c13277810ULL, 0x000fe20007ffe0ffULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0x0000001013457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e000e0c7a11ULL, 0x000fe200078048ffULL, 0x0000000117127824ULL, 0x140fe200078e0200ULL,
0xfffffff814397812ULL, 0x000fe200078ee211ULL, 0x0000000817417824ULL, 0x000fe200078e00ffULL,
0x00005f000e0d7a11ULL, 0x000fe200000f4c0fULL, 0x00000001130e7824ULL, 0x100fe200078e0200ULL,
0x0000002004047817ULL, 0x000fe20003800000ULL, 0x0000000127147824ULL, 0x000fe200078e0200ULL,
0xfffffff841417812ULL, 0x000fe200078ee212ULL, 0x0000000827437824ULL, 0x000fe200078e00ffULL,
0x000000070e0f7812ULL, 0x000fe200078ec0ffULL, 0x00000001150e7824ULL, 0x000fe200078e0210ULL,
0x000000041300720cULL, 0x000fe20003f06070ULL, 0x0000000145167824ULL, 0x100fe200078e0200ULL,
0x0ffffff80f117812ULL, 0x000fe200078ef800ULL, 0x0000000845477824ULL, 0x000fe200078e00ffULL,
0x0000000e4d0f7210ULL, 0x000fe20007f5e0ffULL, 0x000000103b0c7825ULL, 0x000fe200078e000cULL,
0x0000001413497810ULL, 0x000fc40007ffe0ffULL, 0x00000018136b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078448ffULL,
0x0000000149247824ULL, 0x000fe200078e0200ULL, 0x0000001c136f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008494b7824ULL, 0x000fe200078e00ffULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c12ULL,
0x0000000117127824ULL, 0x000fe200078e0210ULL, 0xfffffff843437812ULL, 0x000fe200078ee214ULL,
0x0000001011117824ULL, 0x000fe200078e0262ULL, 0xfffffff847477812ULL, 0x000fe200078ee216ULL,
0x0000000127147824ULL, 0x100fe200078e0210ULL, 0x000000124d137210ULL, 0x000fe20007f5e0ffULL,
0x0000000145167824ULL, 0x000fe200078e0210ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e2000c101c46ULL,
0x0000000149247824ULL, 0x100fe200078e0210ULL, 0x000000144d147210ULL, 0x000fe20007f7e0ffULL,
0x000000016b267824ULL, 0x100fe200078e0210ULL, 0x000000164d167210ULL, 0x000fe20007f1e0ffULL,
0x000000016f127824ULL, 0x000fe200078e0210ULL, 0x00005e0013107a11ULL, 0x000fe200078c48ffULL,
0x000000086b6d7824ULL, 0x000fe200078e00ffULL, 0x000000264d257210ULL, 0x000fe20007fbe0ffULL,
0x000000086f267824ULL, 0x000fe200078e00ffULL, 0x000000244d247210ULL, 0x000fe20007f9e0ffULL,
0x0000001039397824ULL, 0x000fc400078e0262ULL, 0x000000ffff0c7224ULL, 0x002fe200010e06ffULL,
0x000000124d4d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e06ffULL,
0x000000041500720cULL, 0x080fe20003f66070ULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005f0013117a11ULL, 0x000fe200030f4c0cULL, 0x000000016f137824ULL, 0x100fe200078e0200ULL,
0x00005e0014127a11ULL, 0x000fe200078c48ffULL, 0x000000016b0c7824ULL, 0x000fe200078e0200ULL,
0x000000041700720cULL, 0x000fe20003f06070ULL, 0x000000ffff387224ULL, 0x000fe200028e06ffULL,
0xfffffff826717812ULL, 0x000fc400078ee213ULL, 0x00005f0014137a11ULL, 0x000fe400030f4c0dULL,
0x00005e0016147a11ULL, 0x040fe400078c48ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee20cULL,
0x000000103b0c7825ULL, 0x000fe200078e000eULL, 0x00005f0016157a11ULL, 0x000fe400030f4c15ULL,
0x00005e0024167a11ULL, 0x000fe200078c48ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0x000000000c397faeULL, 0x0003e2000d901c46ULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x000000042700720cULL, 0x000fc40003f66070ULL, 0x00005f0024177a11ULL, 0x000fe400030f4c0fULL,
0x00005e0025247a11ULL, 0x000fe400078a48ffULL, 0x00005e004d267a11ULL, 0x000fe400078c48ffULL,
0x000000044500720cULL, 0x080fe40003f86070ULL, 0x000000044900720cULL, 0x000fe20003f46070ULL,
0x000000103b0c7825ULL, 0x002fe200078e0010ULL, 0x00005f0025257a11ULL, 0x000fc400028f4c38ULL,
0x000000046b00720cULL, 0x080fe20003fa6070ULL, 0x000000103b107825ULL, 0x000fe200078e0014ULL,
0x00005f004d277a11ULL, 0x000fe400030f4c0eULL, 0x000000046f00720cULL, 0x000fe20003fc6070ULL,
0x000000103b0e7825ULL, 0x000fc800078e0012ULL, 0x0000001041397824ULL, 0x000fe400078e0262ULL,
0x000000103b127825ULL, 0x000fc600078e0016ULL, 0x000000000c397faeULL, 0x0003e2000c101c46ULL,
0x000000103b147825ULL, 0x000fc800078e0024ULL, 0x000000103b167825ULL, 0x000fc800078e0026ULL,
0x0000001043257824ULL, 0x100fe400078e0262ULL, 0x0000001047277824ULL, 0x100fe400078e0262ULL,
0x000000104b3b7824ULL, 0x100fe200078e0262ULL, 0x000000000e257faeULL, 0x0003e2000d901c46ULL,
0x000000106d417824ULL, 0x100fe400078e0262ULL, 0x0000001071437824ULL, 0x000fe200078e0262ULL,
0x0000000010277faeULL, 0x0003e8000e101c46ULL, 0x00000000123b7faeULL, 0x0003e8000d101c46ULL,
0x0000000014417faeULL, 0x0003e8000e901c46ULL, 0x0000000016437faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000004000c7811ULL, 0x040fe200078fe8ffULL,
0x0000000103437824ULL, 0x000fe200078e0256ULL, 0x0000000800117811ULL, 0x000fc400078fe8ffULL,
0x0000000c00127811ULL, 0x000fe200078fe8ffULL, 0x000000010c047824ULL, 0x140fe200078e0200ULL,
0x0000006009137810ULL, 0x000fe20007ffe0ffULL, 0x000000080c3b7824ULL, 0x000fe200078e00ffULL,
0x0000001000147811ULL, 0x040fe200078fe8ffULL, 0x0000000811417824ULL, 0x000fe200078e00ffULL,
0x0000001800177811ULL, 0x000fe200078fe8ffULL, 0x00000001120d7824ULL, 0x000fe200078e0200ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee204ULL, 0x0000000111047824ULL, 0x000fe200078e0200ULL,
0x0000001400157811ULL, 0x000fe200078fe8ffULL, 0x0000000812107824ULL, 0x000fe200078e00ffULL,
0x0000000000267211ULL, 0x000fe200078fe8ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0213ULL,
0xfffffff841417812ULL, 0x000fe200078ee204ULL, 0x00000001140e7824ULL, 0x100fe200078e0200ULL,
0x0000001300047211ULL, 0x000fe200078fe8ffULL, 0x0000000814477824ULL, 0x000fe200078e00ffULL,
0xfffffff810457812ULL, 0x000fe200078ee20dULL, 0x0000000117247824ULL, 0x100fe200078e0200ULL,
0x000000044d0d7210ULL, 0x000fe20007f1e0ffULL, 0x00000008174b7824ULL, 0x000fe200078e00ffULL,
0x0000000c4d047210ULL, 0x000fe20007f5e0ffULL, 0x0000000115167824ULL, 0x000fe200078e0200ULL,
0xfffffff847477812ULL, 0x000fe200078ee20eULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078048ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x00005e00040e7a11ULL, 0x000fe200078448ffULL, 0x0000000815497824ULL, 0x000fe200078e00ffULL,
0x00005f000d0d7a11ULL, 0x000fe200000f4c10ULL, 0x0000000112107824ULL, 0x000fe200078e0213ULL,
0x00005f00040f7a11ULL, 0x000fe200010f4c0fULL, 0x0000000111047824ULL, 0x100fe200078e0213ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee224ULL, 0x0000000114127824ULL, 0x100fe200078e0213ULL,
0x0000001c00247811ULL, 0x000fe200078fe8ffULL, 0x0000000115147824ULL, 0x000fe200078e0213ULL,
0x000000044d117210ULL, 0x000fe20007f7e0ffULL, 0x00000010430c7825ULL, 0x000fe200078e000cULL,
0xfffffff849497812ULL, 0x000fc400078ee216ULL, 0x000000124d157210ULL, 0x000fe20007f5e0ffULL,
0x0000000117167824ULL, 0x100fe200078e0213ULL, 0x000000144d177210ULL, 0x040fe20007fbe0ffULL,
0x0000000124047824ULL, 0x040fe200078e0213ULL, 0x000000104d137210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078c48ffULL,
0x0000000124277824ULL, 0x040fe200078e0200ULL, 0x000000164d257210ULL, 0x040fe20007f7e0ffULL,
0x0000000824387824ULL, 0x000fe200078e00ffULL, 0x000000044d047210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005f0011117a11ULL, 0x000fe200030f4c12ULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078048ffULL,
0x000000ffff3a7224ULL, 0x000fe200028e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078448ffULL,
0x000000103b3b7824ULL, 0x000fe200078e0262ULL, 0xfffffff8384d7812ULL, 0x000fe200078ee227ULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x0000000726397812ULL, 0x000fe200078ec0ffULL,
0x000000ffff277224ULL, 0x000fe200020e06ffULL, 0x00005f0013137a11ULL, 0x000fe200000f4c24ULL,
0x00000010430e7825ULL, 0x000fe200078e000eULL, 0x00005f0015157a11ULL, 0x000fc400010f4c16ULL,
0x00005e0017167a11ULL, 0x000fe200078048ffULL, 0x0000001041417824ULL, 0x000fe200078e0262ULL,
0x00005e0025247a11ULL, 0x000fe200078448ffULL, 0x0000001043107825ULL, 0x000fe200078e0010ULL,
0x00005e0004267a11ULL, 0x040fe400078648ffULL, 0x0ffffff839397812ULL, 0x000fe200078ef800ULL,
0x0000001043127825ULL, 0x000fe200078e0012ULL, 0x00005f0017177a11ULL, 0x000fe400000f4c3aULL,
0x00005f0025257a11ULL, 0x000fe200010f4c38ULL, 0x0000001039397824ULL, 0x000fe200078e0262ULL,
0x00005f0004277a11ULL, 0x000fe200018f4c27ULL, 0x0000001043147825ULL, 0x000fc600078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c397faeULL, 0x0003e2000b901c46ULL,
0x0000001043167825ULL, 0x000fc600078e0016ULL, 0x000000000e3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001043247825ULL, 0x000fc600078e0024ULL, 0x0000000010417faeULL, 0x0003e2000b901c46ULL,
0x0000001043267825ULL, 0x000fc800078e0026ULL, 0x0000001045437824ULL, 0x100fe400078e0262ULL,
0x0000001047457824ULL, 0x100fe400078e0262ULL, 0x0000001049477824ULL, 0x100fe200078e0262ULL,
0x0000000012437faeULL, 0x0003e2000b901c46ULL, 0x000000104b497824ULL, 0x100fe400078e0262ULL,
0x000000104d4b7824ULL, 0x000fe200078e0262ULL, 0x0000000014457faeULL, 0x0003e8000b901c46ULL,
0x0000000016477faeULL, 0x0003e8000b901c46ULL, 0x0000000024497faeULL, 0x0003e8000b901c46ULL,
0x00000000264b7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff4d7624ULL, 0x000fe200078e00ffULL,
0x0000000102047812ULL, 0x000fc800078ec0ffULL, 0x000000010400780cULL, 0x000fe20003f05070ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0xffffffff4d4d7811ULL, 0x000fc800078e08ffULL,
0x000000014d4d7807ULL, 0x000fca0004000000ULL, 0x0000000102027824ULL, 0x000fca00078e024dULL,
0x000000c30200720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000004d4f0c7210ULL, 0x002fe20007ffe050ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000060000c0c7625ULL, 0x000fca00078e000dULL, 0x000000060c047981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6280003107f8cULL, 0x0022a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01c62c00030f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000130e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01c62c00030f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c0800051117984ULL, 0x000ea80000000800ULL, 0x01c2800051137984ULL, 0x0006620000000800ULL,
0x0000004e1100720bULL, 0x004fe20003f1d000ULL, 0x000146027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800000e0100ULL, 0x0000ffff10ff7812ULL, 0x000fe2000784c0ffULL,
0x0000046000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff6a7224ULL, 0x000fd400078e004eULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x000000010800780cULL, 0x000fe40003f05270ULL, 0x0000004e1100720bULL, 0x000fe20003f54000ULL,
0x000145d27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x000fc400010e0100ULL,
0x0000004e110c8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910150d7816ULL, 0x000fc600000000ffULL, 0x01c4800c51008388ULL, 0x0005e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004e110d7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004e0d0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00417308ULL, 0x000ea40000000800ULL,
0x000000410a0a7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff407819ULL, 0x000fe20000011600ULL, 0x000145127f007947ULL, 0x000fea000b800000ULL,
0x00001f40410e7589ULL, 0x0004e400000e0000ULL, 0x0000000e18187220ULL, 0x08cfe40000410000ULL,
0x0000000e19197220ULL, 0x080fe40000410000ULL, 0x0000000e1c1c7220ULL, 0x080fe40000410000ULL,
0x0000000e1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000e20207220ULL, 0x080fe40000410000ULL,
0x0000000e21217220ULL, 0x080fe40000410000ULL, 0x0000000e28287220ULL, 0x080fe40000410000ULL,
0x0000000e29297220ULL, 0x080fe40000410000ULL, 0x0000000e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000000e2d2d7220ULL, 0x000fc40000410000ULL, 0x0000000e30307220ULL, 0x080fe40000410000ULL,
0x0000000e31317220ULL, 0x080fe40000410000ULL, 0x0000000e34347220ULL, 0x080fe40000410000ULL,
0x0000000e35357220ULL, 0x080fe40000410000ULL, 0x0000000e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800407811ULL, 0x002fe200078ff0ffULL, 0x000144027f007947ULL, 0x000fea000b800000ULL,
0x00001f40410e7589ULL, 0x0002a400000e0000ULL, 0x0000000e1a1a7220ULL, 0x084fe40000410000ULL,
0x0000000e1b1b7220ULL, 0x080fe40000410000ULL, 0x0000000e1e1e7220ULL, 0x080fe40000410000ULL,
0x0000000e1f1f7220ULL, 0x080fe40000410000ULL, 0x0000000e22227220ULL, 0x080fe40000410000ULL,
0x0000000e23237220ULL, 0x000fc40000410000ULL, 0x0000000e2a2a7220ULL, 0x080fe40000410000ULL,
0x0000000e2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000e2e2e7220ULL, 0x080fe40000410000ULL,
0x0000000e2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000e32327220ULL, 0x080fe40000410000ULL,
0x0000000e33337220ULL, 0x000fc40000410000ULL, 0x0000000e36367220ULL, 0x080fe40000410000ULL,
0x0000000e37377220ULL, 0x080fe40000410000ULL, 0x0000000e3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000e3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fe40007800810ULL, 0x0000004e116a7209ULL, 0x000fd60007810000ULL,
0x8000006a11110221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100520308ULL, 0x000ea40000000800ULL, 0x0000005213130220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x0000000a130a7221ULL, 0x002fe20000010000ULL,
0x0000014000008947ULL, 0x000fea0003800000ULL, 0x00000052ff0c723eULL, 0x000fe400000000ffULL,
0x00000002ff107819ULL, 0x000fe40000011600ULL, 0x000054100c417816ULL, 0x000fe2000000000cULL,
0x000142427f007947ULL, 0x000fea000b800000ULL, 0x00001f1041537589ULL, 0x0002a400000e0000ULL,
0x0000000810407810ULL, 0x002fe20007ffe0ffULL, 0x000142827f007947ULL, 0x000fea000b800000ULL,
0x00001f4041547589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001010407810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x00005cf0000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x00014ed000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001810407810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x00005d50000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x004fc400078e00ffULL,
0x00014e7000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0001280055407811ULL, 0x002fcc00078e20ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x000128005c0c7811ULL, 0x000fe200078e20ffULL,
0x00005800044e7a24ULL, 0x010fc400078e02ffULL, 0x000000005870783bULL, 0x000ee40000004200ULL,
0x000000804e4e7824ULL, 0x000fe400078e00ffULL, 0x00000000596c783bULL, 0x000fe80000004200ULL,
0x000000005a48783bULL, 0x000fe80000004200ULL, 0x000000005b44783bULL, 0x000fe80000004200ULL,
0x000000000c0c783bULL, 0x004ea80000000200ULL, 0x000000005d24783bULL, 0x000ea80000004200ULL,
0x000000005e14783bULL, 0x000ea80000004200ULL, 0x000000005f10783bULL, 0x000ea80000004200ULL,
0x000000006038783bULL, 0x000ea20000004200ULL, 0x0000005340400232ULL, 0x002fc40000000000ULL,
0x0000005342420232ULL, 0x000fe40000000000ULL, 0x0000005441410232ULL, 0x088fe40000000000ULL,
0x0000005443430232ULL, 0x000fce0000000000ULL, 0x000000704018723cULL, 0x000f620000001818ULL,
0x000000530c0c0232ULL, 0x004fce0000000000ULL, 0x0000006c4020723cULL, 0x000f620000001820ULL,
0x000000530e0e0232ULL, 0x000fe40000000000ULL, 0x000000540d0d0232ULL, 0x080fe40000000000ULL,
0x000000540f0f0232ULL, 0x000fc60000000000ULL, 0x00000048402c723cULL, 0x040f70000000182cULL,
0x00000072401c723cULL, 0x040f70000000181cULL, 0x0000006e4028723cULL, 0x040f700000001828ULL,
0x0000004a4030723cULL, 0x040f700000001830ULL, 0x000000444034723cULL, 0x040f700000001834ULL,
0x00000046403c723cULL, 0x000f70000000183cULL, 0x000000240c44723cULL, 0x060b700000001818ULL,
0x000000140c20723cULL, 0x040b700000001820ULL, 0x000000100c2c723cULL, 0x040b70000000182cULL,
0x000000260c24723cULL, 0x040b70000000181cULL, 0x000000160c14723cULL, 0x040b700000001828ULL,
0x000000120c10723cULL, 0x040b700000001830ULL, 0x000000380c34723cULL, 0x040b700000001834ULL,
0x0000003a0c18723cULL, 0x000b62000000183cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000009947ULL, 0x000fca0003800000ULL, 0x00000003ff317819ULL, 0x020fe20000011600ULL,
0x0000000103397824ULL, 0x000fe200078e0256ULL, 0x00000080070d7811ULL, 0x000fe400078e40ffULL,
0x00000004311d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000d060c7217ULL, 0x000fe40007800000ULL,
0x0000001031417810ULL, 0x000fe20007ffe0ffULL, 0x000000011d0f7824ULL, 0x100fe200078e0200ULL,
0x00000008312b7810ULL, 0x000fe20007ffe0ffULL, 0x000000081d307824ULL, 0x000fe200078e00ffULL,
0x0000001431437810ULL, 0x040fe20007ffe0ffULL, 0x000000010c0e7824ULL, 0x000fe200078e0a0dULL,
0x0000000c31337810ULL, 0x000fe20007ffe0ffULL, 0x00000001410d7824ULL, 0x140fe200078e0200ULL,
0xfffffff830307812ULL, 0x000fe200078ee20fULL, 0x00000008413e7824ULL, 0x000fe200078e00ffULL,
0x0000001831497810ULL, 0x000fe20007ffe0ffULL, 0x000000012b1c7824ULL, 0x100fe200078e0200ULL,
0x0000001c314b7810ULL, 0x000fe20007ffe0ffULL, 0x000000082b1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL, 0x00000001430f7824ULL, 0x040fe200078e0200ULL,
0x000000200e387817ULL, 0x000fe20003800000ULL, 0x0000000843407824ULL, 0x000fe200078e00ffULL,
0xfffffff81f327812ULL, 0x000fe200078ee21cULL, 0x00000001090d7824ULL, 0x000fe200078e0231ULL,
0x000000382b00720cULL, 0x000fe20003fa6070ULL, 0x00000001330c7824ULL, 0x140fe200078e0200ULL,
0xfffffff840407812ULL, 0x000fe200078ee20fULL, 0x00000008331f7824ULL, 0x000fe200078e00ffULL,
0x0000000d4e0f7210ULL, 0x000fe20007f5e0ffULL, 0x00000001491c7824ULL, 0x000fc400078e0200ULL,
0x0000000849297824ULL, 0x000fe200078e00ffULL, 0xfffffff81f3c7812ULL, 0x000fe200078ee20cULL,
0x00000001090d7824ULL, 0x000fe400078e021dULL, 0x000000ffff1e7224ULL, 0x000fe200010e06ffULL,
0x00005e000f0c7a11ULL, 0x000fe200078448ffULL, 0x000000014b1f7824ULL, 0x000fe200078e0200ULL,
0xfffffff829427812ULL, 0x000fe200078ee21cULL, 0x000000084b487824ULL, 0x000fe200078e00ffULL,
0x0000000d4e1c7210ULL, 0x000fe20007f7e0ffULL, 0x00000010303d7824ULL, 0x000fe200078e0257ULL,
0x00005f000f0d7a11ULL, 0x000fe200010f4c1eULL, 0x00000001090f7824ULL, 0x000fe200078e022bULL,
0xfffffff848487812ULL, 0x000fe200078ee21fULL, 0x000000ffff1f7224ULL, 0x000fe200018e06ffULL,
0x000000381d00720cULL, 0x000fe20003f66070ULL, 0x00000001091d7824ULL, 0x000fe200078e0233ULL,
0x0000000f4e1e7210ULL, 0x000fe20007f9e0ffULL, 0x00000010390c7825ULL, 0x000fe200078e000cULL,
0x00005e001c0e7a11ULL, 0x000fc600078448ffULL, 0x000000ffff297224ULL, 0x000fe200020e06ffULL,
0x00005f001c0f7a11ULL, 0x000fe200010f4c1fULL, 0x00000001091f7824ULL, 0x000fe200078e0241ULL,
0x00005e001e1c7a11ULL, 0x000fe200078448ffULL, 0x00000010323f7824ULL, 0x000fe200078e0257ULL,
0x0000001d4e287210ULL, 0x000fe20007f9e0ffULL, 0x00000010390e7825ULL, 0x040fe200078e000eULL,
0x00005f001e1d7a11ULL, 0x000fe400010f4c29ULL, 0x0000001f4e297210ULL, 0x000fe20007fde0ffULL,
0x000000ffff2b7224ULL, 0x000fe200020e06ffULL, 0x00005e00281e7a11ULL, 0x000fe200078448ffULL,
0x00000010391c7825ULL, 0x000fe200078e001cULL, 0x000000383100720cULL, 0x000fc40003f86070ULL,
0x00005f00281f7a11ULL, 0x000fe200010f4c2bULL, 0x0000000131317824ULL, 0x000fe200078e0200ULL,
0x000000383300720cULL, 0x000fe20003f46070ULL, 0x000000ffff2a7224ULL, 0x000fe200030e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078c48ffULL, 0x00000001092b7824ULL, 0x000fe200078e0243ULL,
0x0000000731317812ULL, 0x000fe200078ec0ffULL, 0x0000000109337824ULL, 0x000fe200078e024bULL,
0x00005f0029297a11ULL, 0x000fe400030f4c2aULL, 0x0ffffff8312a7812ULL, 0x000fe200078ef800ULL,
0x0000000109317824ULL, 0x000fe200078e0249ULL, 0x0000002b4e2b7210ULL, 0x000fc60007fde0ffULL,
0x000000102a3b7824ULL, 0x000fe400078e0257ULL, 0x000000ffff307224ULL, 0x000fe200030e06ffULL,
0x00005e002b2a7a11ULL, 0x040fe400078c48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c3b7faeULL, 0x0003e2000e101c46ULL, 0x000000314e317210ULL, 0x040fe40007f9e0ffULL,
0x00005f002b2b7a11ULL, 0x000fe200030f4c30ULL, 0x000000000e3d7faeULL, 0x0005e2000d901c46ULL,
0x000000334e337210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff327224ULL, 0x000fe200020e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078c48ffULL, 0x000000001c3f7faeULL, 0x0007e2000e901c46ULL,
0x000000384100720cULL, 0x000fe20003f86070ULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005f0031317a11ULL, 0x000fe200030f4c32ULL, 0x00000010390c7825ULL, 0x002fe200078e001eULL,
0x00005e0033327a11ULL, 0x000fc400078648ffULL, 0x000000384300720cULL, 0x080fe20003fc6070ULL,
0x00000010390e7825ULL, 0x004fe200078e0028ULL, 0x000000384900720cULL, 0x080fe40003fa6070ULL,
0x00005f0033337a11ULL, 0x000fe200018f4c3aULL, 0x0000001039287825ULL, 0x000fe200078e0030ULL,
0x000000384b00720cULL, 0x000fc60003f66070ULL, 0x00000010391e7825ULL, 0x000fc800078e002aULL,
0x000000103c317824ULL, 0x000fe400078e0257ULL, 0x00000010392a7825ULL, 0x000fc600078e0032ULL,
0x000000000c317faeULL, 0x0003e2000d101c46ULL, 0x000000103e1d7824ULL, 0x108fe400078e0257ULL,
0x0000001040337824ULL, 0x100fe400078e0257ULL, 0x0000001042397824ULL, 0x100fe200078e0257ULL,
0x000000000e1d7faeULL, 0x0003e2000e101c46ULL, 0x00000010483b7824ULL, 0x000fc600078e0257ULL,
0x000000001e337faeULL, 0x0003e8000f101c46ULL, 0x0000000028397faeULL, 0x0003e8000e901c46ULL,
0x000000002a3b7faeULL, 0x0003e2000d901c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x00000008001c7811ULL, 0x060fe200078fe8ffULL, 0x0000000103397824ULL, 0x000fe200078e0256ULL,
0x00000010002b7811ULL, 0x000fc400078fe8ffULL, 0x0000000c001e7811ULL, 0x000fe200078fe8ffULL,
0x000000011c0e7824ULL, 0x100fe200078e0200ULL, 0x00000004000c7811ULL, 0x000fe200078fe8ffULL,
0x000000081c1f7824ULL, 0x000fe200078e00ffULL, 0x0000001400317811ULL, 0x040fe200078fe8ffULL,
0x000000012b1d7824ULL, 0x140fe200078e0200ULL, 0x0000001c00387811ULL, 0x040fe200078fe8ffULL,
0x000000082b4a7824ULL, 0x000fe200078e00ffULL, 0x0000001800327811ULL, 0x000fe200078fe8ffULL,
0x000000011e0f7824ULL, 0x040fe200078e0200ULL, 0xfffffff81f427812ULL, 0x000fe200078ee20eULL,
0x000000081e487824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee21dULL,
0x000000010c0d7824ULL, 0x100fe200078e0200ULL, 0x0000000000297211ULL, 0x000fe200078fe8ffULL,
0x000000080c407824ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fe200078ee20fULL,
0x00000001310e7824ULL, 0x100fe200078e0200ULL, 0x0000000729297812ULL, 0x000fe200078ec0ffULL,
0x00000008311f7824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee20dULL,
0x00000001381d7824ULL, 0x000fe200078e0200ULL, 0x00000009000d7211ULL, 0x000fe200078fe8ffULL,
0x0000000838707824ULL, 0x000fe200078e00ffULL, 0xfffffff81f6c7812ULL, 0x000fe200078ee20eULL,
0x00000001320f7824ULL, 0x040fe200078e0200ULL, 0x0000004e0d0d7210ULL, 0x000fe20007f5e0ffULL,
0x00000008326e7824ULL, 0x000fe200078e00ffULL, 0xfffffff870707812ULL, 0x000fe200078ee21dULL,
0x00000001091d7824ULL, 0x000fc400078e021cULL, 0x00000001091f7824ULL, 0x040fe200078e021eULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee20fULL, 0x00000001090f7824ULL, 0x000fe200078e020cULL,
0x0000004e1d1d7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x0000004e1f1f7210ULL, 0x080fe20007fbe0ffULL, 0x00000001092b7824ULL, 0x000fe200078e022bULL,
0x0000004e0f0f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078848ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005f000d0d7a11ULL, 0x000fe200010f4c0eULL, 0x0000000109317824ULL, 0x000fe200078e0231ULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x0000000109337824ULL, 0x000fe200078e0232ULL,
0x00005e001d1c7a11ULL, 0x000fe200078648ffULL, 0x00000001093b7824ULL, 0x000fe200078e0238ULL,
0x00005f001f1f7a11ULL, 0x000fe200020f4c28ULL, 0x00000010390c7825ULL, 0x000fe200078e000cULL,
0x0ffffff829287812ULL, 0x000fc400078ef800ULL, 0x0000004e2b297210ULL, 0x080fe20007f9e0ffULL,
0x00000010403d7824ULL, 0x100fe200078e0257ULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c30ULL,
0x00000010423f7824ULL, 0x000fe200078e0257ULL, 0x0000004e312b7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00005f001d1d7a11ULL, 0x000fe200018f4c2aULL,
0x00000010390e7825ULL, 0x000fe200078e000eULL, 0x0000004e33317210ULL, 0x080fe40007f5e0ffULL,
0x0000004e3b337210ULL, 0x000fe20007f7e0ffULL, 0x00000010283b7824ULL, 0x000fe200078e0257ULL,
0x00005e0029287a11ULL, 0x000fe200078848ffULL, 0x000000ffff3c7224ULL, 0x000fe200028e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078a48ffULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078448ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00005e0033327a11ULL, 0x000fe200078648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c3b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0029297a11ULL, 0x000fe200020f4c3eULL,
0x00000010391c7825ULL, 0x000fe200078e001cULL, 0x00005f002b2b7a11ULL, 0x000fe200028f4c3cULL,
0x000000000e3d7faeULL, 0x0005e2000b901c46ULL, 0x00005f0031317a11ULL, 0x000fe200010f4c3aULL,
0x00000010391e7825ULL, 0x000fe200078e001eULL, 0x00005f0033337a11ULL, 0x000fe200018f4c38ULL,
0x000000001c3f7faeULL, 0x0005e4000b901c46ULL, 0x0000001039287825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fc800078e002aULL, 0x0000001039307825ULL, 0x000fc800078e0030ULL,
0x0000001039327825ULL, 0x000fc800078e0032ULL, 0x00000010480d7824ULL, 0x102fe400078e0257ULL,
0x000000104a397824ULL, 0x100fe400078e0257ULL, 0x000000106c3b7824ULL, 0x100fe200078e0257ULL,
0x000000001e0d7faeULL, 0x0005e2000b901c46ULL, 0x000000106e417824ULL, 0x100fe400078e0257ULL,
0x0000001070437824ULL, 0x000fe200078e0257ULL, 0x0000000028397faeULL, 0x0005e8000b901c46ULL,
0x000000002a3b7faeULL, 0x0005e8000b901c46ULL, 0x0000000030417faeULL, 0x0005e8000b901c46ULL,
0x0000000032437faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000014000008947ULL, 0x000fea0003800000ULL, 0x00000052ff0c723eULL, 0x002fe400000000ffULL,
0x00000002ff1c7819ULL, 0x004fe40000011600ULL, 0x000054100c417816ULL, 0x000fe2000000000cULL,
0x000131b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1c41537589ULL, 0x0002a400000e0000ULL,
0x000000081c407810ULL, 0x002fe20007ffe0ffULL, 0x000131f27f007947ULL, 0x000fea000b800000ULL,
0x00001f4041547589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000101c407810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x00006e50000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x00013d7000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000181c407810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x00006eb0000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x004fc400078e00ffULL,
0x00013d1000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0001280061387811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006670783bULL, 0x000fe20000004200ULL, 0x00012800673c7811ULL, 0x000fc600078e20ffULL,
0x000000003838783bULL, 0x006e680000000200ULL, 0x00000000636c783bULL, 0x000fe80000004200ULL,
0x000000006448783bULL, 0x000fe80000004200ULL, 0x000000006540783bULL, 0x000fe80000004200ULL,
0x000000003c3c783bULL, 0x000ea80000000200ULL, 0x000000004c1c783bULL, 0x000f280000004200ULL,
0x000000006828783bULL, 0x000ee80000004200ULL, 0x000000006930783bULL, 0x000ee80000004200ULL,
0x000000000b0c783bULL, 0x000ee20000004200ULL, 0x0000005338380232ULL, 0x002fc40000000000ULL,
0x000000533a3a0232ULL, 0x000fe40000000000ULL, 0x0000005439390232ULL, 0x088fe40000000000ULL,
0x000000543b3b0232ULL, 0x000fce0000000000ULL, 0x000000703844723cULL, 0x000f620000001844ULL,
0x000000533c3c0232ULL, 0x084fe40000000000ULL, 0x000000533e3e0232ULL, 0x000fe40000000000ULL,
0x000000543d3d0232ULL, 0x000fc60000000000ULL, 0x0000006c3820723cULL, 0x000f620000001820ULL,
0x000000543f3f0232ULL, 0x000fce0000000000ULL, 0x00000048382c723cULL, 0x040f70000000182cULL,
0x000000723824723cULL, 0x040f700000001824ULL, 0x0000006e3814723cULL, 0x040f700000001814ULL,
0x0000004a3810723cULL, 0x040f700000001810ULL, 0x000000403834723cULL, 0x040f700000001834ULL,
0x000000423838723cULL, 0x000f700000001818ULL, 0x0000001c3c18723cULL, 0x070b700000001844ULL,
0x000000283c20723cULL, 0x040b700000001820ULL, 0x000000303c2c723cULL, 0x040b70000000182cULL,
0x0000001e3c1c723cULL, 0x040b700000001824ULL, 0x0000002a3c28723cULL, 0x040b700000001814ULL,
0x000000323c30723cULL, 0x040b700000001810ULL, 0x0000000c3c34723cULL, 0x040b700000001834ULL,
0x0000000e3c3c723cULL, 0x000b620000001838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000080070d7811ULL, 0x020fe200078e40ffULL, 0x01c69000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000060d00720cULL, 0x000fda0003f06070ULL, 0x0000565000000947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x00000003ff177819ULL, 0x100fe40000011600ULL, 0x000000a0070d7811ULL, 0x000fe400078e40ffULL,
0x0000000417117810ULL, 0x040fe40007ffe0ffULL, 0x0000001017477810ULL, 0x000fe40007ffe0ffULL,
0x0000000d060c7217ULL, 0x000fe20007800000ULL, 0x00000001110e7824ULL, 0x100fe200078e0200ULL,
0x0000000817157810ULL, 0x000fe20007ffe0ffULL, 0x0000000811417824ULL, 0x000fe200078e00ffULL,
0x0000000c17277810ULL, 0x000fe20007ffe0ffULL, 0x00000001470f7824ULL, 0x000fe200078e0200ULL,
0x0000002009267810ULL, 0x000fe20007ffe0ffULL, 0x0000000847107824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee20eULL, 0x000000010c0d7824ULL, 0x000fe200078e0a0dULL,
0x00000014174b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001150c7824ULL, 0x140fe200078e0200ULL,
0xfffffff810497812ULL, 0x000fe200078ee20fULL, 0x0000000815437824ULL, 0x000fe200078e00ffULL,
0x0000001c17737810ULL, 0x000fe20007ffe0ffULL, 0x00000001270e7824ULL, 0x000fe200078e0200ULL,
0x00000018176d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000827457824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee20cULL, 0x00000001170f7824ULL, 0x000fe200078e0226ULL,
0x000000200d387817ULL, 0x000fe20003800000ULL, 0x000000014b0c7824ULL, 0x000fe200078e0200ULL,
0xfffffff845457812ULL, 0x000fe200078ee20eULL, 0x000000084b6b7824ULL, 0x000fe200078e00ffULL,
0x0000004e0f0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000111137824ULL, 0x140fe200078e0226ULL,
0x000000381100720cULL, 0x000fe20003fa6070ULL, 0x0000000115257824ULL, 0x000fe200078e0226ULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee20cULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e000e0c7a11ULL, 0x040fe200078048ffULL, 0x0000000173127824ULL, 0x100fe200078e0200ULL,
0x0000004e25117210ULL, 0x080fe20007f7e0ffULL, 0x0000000873757824ULL, 0x000fe200078e00ffULL,
0x00005f000e0d7a11ULL, 0x000fe200000f4c0fULL, 0x000000016d107824ULL, 0x000fe200078e0200ULL,
0x0000004e130f7210ULL, 0x000fe20007f5e0ffULL, 0x000000086d717824ULL, 0x000fe200078e00ffULL,
0xfffffff875757812ULL, 0x000fe200078ee212ULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x000000381500720cULL, 0x000fe20003f06070ULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0xfffffff871717812ULL, 0x000fe200078ee210ULL, 0x0000000127137824ULL, 0x100fe200078e0226ULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x0000000147157824ULL, 0x100fe200078e0226ULL,
0x00005e0011107a11ULL, 0x000fe200078648ffULL, 0x000000014b397824ULL, 0x000fe200078e0226ULL,
0x00005f000f0f7a11ULL, 0x000fe200010f4c14ULL, 0x000000016d6f7824ULL, 0x000fe200078e0226ULL,
0x00005f0011117a11ULL, 0x000fe200018f4c12ULL, 0x0000001041417824ULL, 0x100fe200078e0262ULL,
0x0000004e13137210ULL, 0x000fe20007f7e0ffULL, 0x0000001043437824ULL, 0x000fe200078e0262ULL,
0x000000381700720cULL, 0x040fe20003f46070ULL, 0x0000000117177824ULL, 0x000fe200078e0200ULL,
0x0000004e15157210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078648ffULL, 0x0000001045457824ULL, 0x000fe200078e0262ULL,
0x0000000717177812ULL, 0x000fe200078ec0ffULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005f0013137a11ULL, 0x000fe200018f4c24ULL, 0x0000001049497824ULL, 0x000fe200078e0262ULL,
0x0ffffff817257812ULL, 0x000fe200078ef800ULL, 0x000000106b6b7824ULL, 0x000fe200078e0262ULL,
0x0000004e39177210ULL, 0x000fe20007f7e0ffULL, 0x0000000103397824ULL, 0x000fe200078e0256ULL,
0x00005e0015147a11ULL, 0x000fe200078848ffULL, 0x00000010253b7824ULL, 0x000fc400078e0262ULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x00005f0015157a11ULL, 0x000fe200020f4c16ULL,
0x00000010390c7825ULL, 0x000fe200078e000cULL, 0x00005e0017167a11ULL, 0x000fe400078648ffULL,
0x000000382700720cULL, 0x000fe20003f86070ULL, 0x0000000173277824ULL, 0x000fe200078e0226ULL,
0x00005f0017177a11ULL, 0x000fe200018f4c24ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c3b7faeULL, 0x0003e2000d101c46ULL, 0x0000004e6f257210ULL, 0x080fe20007f7e0ffULL,
0x00000010390e7825ULL, 0x000fe200078e000eULL, 0x0000004e27277210ULL, 0x000fc40007f5e0ffULL,
0x00005e0025247a11ULL, 0x000fe200078c48ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x000000384700720cULL, 0x080fe20003f66070ULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x000000000e417faeULL, 0x0005e2000e901c46ULL, 0x000000386d00720cULL, 0x080fe20003fa6070ULL,
0x0000001071717824ULL, 0x000fe200078e0262ULL, 0x00005f0025257a11ULL, 0x000fe200030f4c26ULL,
0x00000010390c7825ULL, 0x002fe200078e0010ULL, 0x00005e0027267a11ULL, 0x000fe400078448ffULL,
0x000000384b00720cULL, 0x080fe20003fc6070ULL, 0x0000001039107825ULL, 0x000fe200078e0012ULL,
0x00005f0027277a11ULL, 0x000fe200010f4c3aULL, 0x000000000c437faeULL, 0x0003e2000c101c46ULL,
0x000000387300720cULL, 0x000fe20003f46070ULL, 0x0000001039127825ULL, 0x000fc400078e0014ULL,
0x0000000010457faeULL, 0x0003e4000e101c46ULL, 0x0000001039147825ULL, 0x040fe400078e0016ULL,
0x0000000012497faeULL, 0x0003e4000d901c46ULL, 0x0000001039167825ULL, 0x040fe400078e0024ULL,
0x00000000146b7faeULL, 0x0003e4000f101c46ULL, 0x00000010390e7825ULL, 0x004fc400078e0026ULL,
0x0000000016717faeULL, 0x0003e4000e901c46ULL, 0x0000001075757824ULL, 0x000fca00078e0262ULL,
0x000000000e757faeULL, 0x0003e2000d101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000008000e7811ULL, 0x040fe400078fe8ffULL, 0x00000004000c7811ULL, 0x040fe400078fe8ffULL,
0x0000000c00107811ULL, 0x000fe200078fe8ffULL, 0x000000010e0f7824ULL, 0x100fe200078e0200ULL,
0x0000000000257211ULL, 0x000fe200078fe8ffULL, 0x000000080e147824ULL, 0x000fe400078e00ffULL,
0x000000010c0d7824ULL, 0x140fe200078e0200ULL, 0x0000000725397812ULL, 0x000fe200078ec0ffULL,
0x000000080c127824ULL, 0x000fe200078e00ffULL, 0xfffffff814437812ULL, 0x000fe200078ee20fULL,
0x0000000110117824ULL, 0x000fe200078e0200ULL, 0x00000010000f7811ULL, 0x000fe200078fe8ffULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0xfffffff812417812ULL, 0x000fe200078ee20dULL,
0x0000001043437824ULL, 0x000fe200078e0262ULL, 0x0000001400127811ULL, 0x000fe200078fe8ffULL,
0x000000010f0d7824ULL, 0x140fe200078e0200ULL, 0xfffffff816457812ULL, 0x000fe200078ee211ULL,
0x000000080f167824ULL, 0x000fe200078e00ffULL, 0x0000001800147811ULL, 0x000fe200078fe8ffULL,
0x0000000112117824ULL, 0x000fc400078e0200ULL, 0x0000000812247824ULL, 0x000fe200078e00ffULL,
0xfffffff816477812ULL, 0x000fe200078ee20dULL, 0x0000000114137824ULL, 0x040fe200078e0200ULL,
0x00000020090d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000814267824ULL, 0x000fe200078e00ffULL,
0x0000001c00167811ULL, 0x000fe200078fe8ffULL, 0x0000001041417824ULL, 0x000fe200078e0262ULL,
0xfffffff824497812ULL, 0x000fe200078ee211ULL, 0x000000010f177824ULL, 0x100fe200078e020dULL,
0x0000000d000f7211ULL, 0x000fe200078fe8ffULL, 0x000000010c117824ULL, 0x000fe200078e020dULL,
0xfffffff8264b7812ULL, 0x000fe200078ee213ULL, 0x000000010e137824ULL, 0x000fc400078e020dULL,
0x0000000110157824ULL, 0x100fe400078e020dULL, 0x0000000112277824ULL, 0x100fe400078e020dULL,
0x00000001143b7824ULL, 0x100fe400078e020dULL, 0x00000001166b7824ULL, 0x040fe200078e020dULL,
0x0000004e0f0d7210ULL, 0x080fe20007f1e0ffULL, 0x0000000116147824ULL, 0x040fe200078e0200ULL,
0x0000004e110f7210ULL, 0x000fe20007f5e0ffULL, 0x00000008166d7824ULL, 0x000fc400078e00ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078048ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078448ffULL,
0x0000001045457824ULL, 0x000fe200078e0262ULL, 0x00005f000d0d7a11ULL, 0x000fe200000f4c12ULL,
0x0000001047477824ULL, 0x100fe200078e0262ULL, 0x0000004e13117210ULL, 0x080fe20007f1e0ffULL,
0x0000001049497824ULL, 0x000fe200078e0262ULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c10ULL,
0x000000104b4b7824ULL, 0x000fe200078e0262ULL, 0x0000004e15137210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x0000004e17157210ULL, 0x000fc40007f7e0ffULL,
0x00005e0011107a11ULL, 0x000fe200078048ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee214ULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00005e0013127a11ULL, 0x000fe400078448ffULL, 0x00005e0015147a11ULL, 0x000fe200078648ffULL,
0x000000106d6d7824ULL, 0x000fe200078e0262ULL, 0x00005f0011117a11ULL, 0x000fe400000f4c26ULL,
0x00005f0013137a11ULL, 0x000fc400010f4c24ULL, 0x0000004e27177210ULL, 0x080fe40007f1e0ffULL,
0x00005f0015157a11ULL, 0x000fe400018f4c16ULL, 0x0000004e3b257210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff407224ULL, 0x000fe200000e06ffULL, 0x0000004e6b277210ULL, 0x000fe40007f7e0ffULL,
0x0ffffff8393b7812ULL, 0x000fe200078ef800ULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078048ffULL, 0x0000000103397824ULL, 0x000fe200078e0256ULL,
0x00005e0025247a11ULL, 0x000fe200078448ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078648ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0262ULL,
0x00005f0017177a11ULL, 0x000fe200000f4c40ULL, 0x00000010390c7825ULL, 0x000fe200078e000cULL,
0x00005f0025257a11ULL, 0x000fc400010f4c3aULL, 0x00005f0027277a11ULL, 0x000fe200018f4c38ULL,
0x00000010390e7825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c3b7faeULL, 0x0003e6000b901c46ULL, 0x0000001039107825ULL, 0x040fe200078e0010ULL,
0x000000000e417faeULL, 0x0003e6000b901c46ULL, 0x0000001039127825ULL, 0x040fe200078e0012ULL,
0x0000000010437faeULL, 0x0003e6000b901c46ULL, 0x0000001039147825ULL, 0x040fe200078e0014ULL,
0x0000000012457faeULL, 0x0003e6000b901c46ULL, 0x0000001039167825ULL, 0x040fe200078e0016ULL,
0x0000000014477faeULL, 0x0003e6000b901c46ULL, 0x0000001039247825ULL, 0x040fe200078e0024ULL,
0x0000000016497faeULL, 0x0003e6000b901c46ULL, 0x0000001039267825ULL, 0x000fe200078e0026ULL,
0x00000000244b7faeULL, 0x0003e8000b901c46ULL, 0x00000000266d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6480003107f8cULL, 0x0022a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01c64c00030f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfc40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000130e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01c64c00030f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c1000051117984ULL, 0x000ea80000000800ULL, 0x01c3000051137984ULL, 0x0006620000000800ULL,
0x0000006a1100720bULL, 0x004fe20003f1d000ULL, 0x00011e327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800000e0100ULL, 0x0000ffff10ff7812ULL, 0x000fe2000784c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x000004200000a947ULL, 0x000fea0003800000ULL, 0x000000020800780cULL, 0x000fe40003f05270ULL,
0x0000006a1100720bULL, 0x000fe20003f54000ULL, 0x00011e127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x000fc400010e0100ULL, 0x000000116a0c8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910150d7816ULL, 0x000fc600000000ffULL,
0x01c5000c51008388ULL, 0x0005e20000000800ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000116a0d7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x8000000d6a0c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00417308ULL, 0x000ea40000000800ULL, 0x000000410a0a7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff407819ULL, 0x000fe20000011600ULL,
0x00011d527f007947ULL, 0x000fea000b800000ULL, 0x00001f40410e7589ULL, 0x0004e400000e0000ULL,
0x0000000e18187220ULL, 0x08cfe40000410000ULL, 0x0000000e19197220ULL, 0x080fe40000410000ULL,
0x0000000e1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000e1d1d7220ULL, 0x000fc40000410000ULL,
0x0000000e20207220ULL, 0x080fe40000410000ULL, 0x0000000e21217220ULL, 0x080fe40000410000ULL,
0x0000000e28287220ULL, 0x080fe40000410000ULL, 0x0000000e29297220ULL, 0x080fe40000410000ULL,
0x0000000e2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000e2d2d7220ULL, 0x000fc40000410000ULL,
0x0000000e30307220ULL, 0x080fe40000410000ULL, 0x0000000e31317220ULL, 0x080fe40000410000ULL,
0x0000000e34347220ULL, 0x080fe40000410000ULL, 0x0000000e35357220ULL, 0x080fe40000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000e3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800407811ULL, 0x002fe200078ff0ffULL,
0x00011c427f007947ULL, 0x000fea000b800000ULL, 0x00001f40410e7589ULL, 0x0002a400000e0000ULL,
0x0000000e1a1a7220ULL, 0x084fe40000410000ULL, 0x0000000e1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000e1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000e1f1f7220ULL, 0x080fe40000410000ULL,
0x0000000e22227220ULL, 0x080fe40000410000ULL, 0x0000000e23237220ULL, 0x000fc40000410000ULL,
0x0000000e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000e2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000000e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000e32327220ULL, 0x080fe40000410000ULL, 0x0000000e33337220ULL, 0x000fc40000410000ULL,
0x0000000e36367220ULL, 0x080fe40000410000ULL, 0x0000000e37377220ULL, 0x080fe40000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe40007800810ULL,
0x000000116a6a7209ULL, 0x000fd60007810000ULL, 0x8000006a11110221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100520308ULL, 0x000ea40000000800ULL,
0x0000005213130220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x0000000a130a7221ULL, 0x002fe20000010000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000052ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff107819ULL, 0x000fe40000011600ULL,
0x000054100c417816ULL, 0x000fe2000000000cULL, 0x00011a827f007947ULL, 0x000fea000b800000ULL,
0x00001f1041537589ULL, 0x0002a400000e0000ULL, 0x0000000810407810ULL, 0x002fe20007ffe0ffULL,
0x00011ac27f007947ULL, 0x000fea000b800000ULL, 0x00001f4041547589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001010407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x000087a0000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0001242000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001810407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00008800000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x004fc400078e00ffULL, 0x000123c000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0001300055407811ULL, 0x002fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005870783bULL, 0x000fe20000004200ULL,
0x000130005c0c7811ULL, 0x000fc600078e20ffULL, 0x000000004040783bULL, 0x000e680000000200ULL,
0x00000000596c783bULL, 0x000fe80000004200ULL, 0x000000005a48783bULL, 0x000fe80000004200ULL,
0x000000005b44783bULL, 0x000fe80000004200ULL, 0x000000000c0c783bULL, 0x004ea80000000200ULL,
0x000000005d38783bULL, 0x000f280000004200ULL, 0x000000005e24783bULL, 0x000ee80000004200ULL,
0x000000005f14783bULL, 0x000ee80000004200ULL, 0x000000006010783bULL, 0x000ee20000004200ULL,
0x0000005340400232ULL, 0x002fc40000000000ULL, 0x0000005342420232ULL, 0x000fe40000000000ULL,
0x0000005441410232ULL, 0x088fe40000000000ULL, 0x0000005443430232ULL, 0x000fce0000000000ULL,
0x000000704018723cULL, 0x000f620000001818ULL, 0x000000530c0c0232ULL, 0x084fe40000000000ULL,
0x000000530e0e0232ULL, 0x000fe40000000000ULL, 0x000000540d0d0232ULL, 0x000fc60000000000ULL,
0x00000072401c723cULL, 0x000f62000000181cULL, 0x000000540f0f0232ULL, 0x000fce0000000000ULL,
0x0000006c4020723cULL, 0x040f700000001820ULL, 0x0000006e4028723cULL, 0x040f700000001828ULL,
0x00000048402c723cULL, 0x040f70000000182cULL, 0x0000004a4030723cULL, 0x040f700000001830ULL,
0x000000444034723cULL, 0x040f700000001834ULL, 0x00000046403c723cULL, 0x000f70000000183cULL,
0x000000380c18723cULL, 0x070b700000001818ULL, 0x0000003a0c1c723cULL, 0x040b70000000181cULL,
0x000000240c20723cULL, 0x040b700000001820ULL, 0x000000260c28723cULL, 0x040b700000001828ULL,
0x000000140c2c723cULL, 0x040b70000000182cULL, 0x000000160c30723cULL, 0x040b700000001830ULL,
0x000000100c34723cULL, 0x040b700000001834ULL, 0x000000120c3c723cULL, 0x000b62000000183cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000072000009947ULL, 0x000fca0003800000ULL,
0x000000c0070d7811ULL, 0x020fe200078e40ffULL, 0x0000000103397824ULL, 0x000fe200078e0256ULL,
0x00000003ff177819ULL, 0x100fe40000011600ULL, 0x0000000d060c7217ULL, 0x000fe40007800000ULL,
0x0000000417137810ULL, 0x040fe40007ffe0ffULL, 0x0000000817157810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0e7824ULL, 0x000fe200078e0a0dULL, 0x0000001017457810ULL, 0x000fe20007ffe0ffULL,
0x00000001130f7824ULL, 0x100fe200078e0200ULL, 0x0000000c17257810ULL, 0x000fe20007ffe0ffULL,
0x0000000813247824ULL, 0x000fe200078e00ffULL, 0x0000004009267810ULL, 0x000fe20007ffe0ffULL,
0x0000000115107824ULL, 0x100fe200078e0200ULL, 0x0000001417477810ULL, 0x000fe20007ffe0ffULL,
0x0000000815117824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x00000001450d7824ULL, 0x000fe200078e0200ULL, 0x0000001817497810ULL, 0x000fe20007ffe0ffULL,
0x0000000845427824ULL, 0x000fe200078e00ffULL, 0xfffffff8113a7812ULL, 0x000fe200078ee210ULL,
0x00000001250c7824ULL, 0x100fe200078e0200ULL, 0x0000001c174b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000825117824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee20dULL,
0x00000001470f7824ULL, 0x040fe200078e0200ULL, 0x000000200e387817ULL, 0x000fe20003800000ULL,
0x0000000847447824ULL, 0x000fe200078e00ffULL, 0xfffffff811407812ULL, 0x000fe200078ee20cULL,
0x00000001170d7824ULL, 0x000fe200078e0226ULL, 0x000000381500720cULL, 0x000fe20003fa6070ULL,
0x0000000149117824ULL, 0x000fe200078e0200ULL, 0xfffffff844447812ULL, 0x000fe200078ee20fULL,
0x00000001130f7824ULL, 0x000fe200078e0226ULL, 0x0000004e0d0d7210ULL, 0x000fe20007f5e0ffULL,
0x0000000849467824ULL, 0x000fc400078e00ffULL, 0x000000014b127824ULL, 0x000fe200078e0200ULL,
0x0000004e0f0f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078448ffULL, 0x000000084b277824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee211ULL, 0x0000000115117824ULL, 0x000fe200078e0226ULL,
0x00005f000d0d7a11ULL, 0x000fe200010f4c10ULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x000000381300720cULL, 0x000fe20003f66070ULL, 0x0000000125137824ULL, 0x100fe200078e0226ULL,
0x0000004e11117210ULL, 0x000fe20007f9e0ffULL, 0x0000000145157824ULL, 0x000fe200078e0226ULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x00000010390c7825ULL, 0x000fe200078e000cULL,
0xfffffff827487812ULL, 0x000fc400078ee212ULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c10ULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x0000004e13137210ULL, 0x080fe20007f9e0ffULL,
0x0000001024417824ULL, 0x000fe200078e0257ULL, 0x00005e0011107a11ULL, 0x000fe200078448ffULL,
0x00000010390e7825ULL, 0x000fe200078e000eULL, 0x0000004e15157210ULL, 0x000fe40007fde0ffULL,
0x00005f0011117a11ULL, 0x000fe200010f4c12ULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078448ffULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x000000381700720cULL, 0x0c0fe20003f86070ULL, 0x0000000117177824ULL, 0x000fe200078e0200ULL,
0x00005f0013137a11ULL, 0x000fe200010f4c14ULL, 0x000000014b277824ULL, 0x000fe200078e0226ULL,
0x00005e0015147a11ULL, 0x000fe200078c48ffULL, 0x000000103a437824ULL, 0x000fe200078e0257ULL,
0x0000000717177812ULL, 0x000fe200078ec0ffULL, 0x0000001039107825ULL, 0x000fe200078e0010ULL,
0x000000382500720cULL, 0x000fc40003f46070ULL, 0x00005f0015157a11ULL, 0x000fe200030f4c16ULL,
0x0000000147257824ULL, 0x000fe200078e0226ULL, 0x0ffffff817167812ULL, 0x000fc800078ef800ULL,
0x0000004e25177210ULL, 0x080fe20007fde0ffULL, 0x00000010163b7824ULL, 0x000fe400078e0257ULL,
0x0000000149257824ULL, 0x000fe400078e0226ULL, 0x000000ffff247224ULL, 0x000fe200030e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c3b7faeULL, 0x0003e2000e101c46ULL,
0x00005e0017167a11ULL, 0x000fe400078c48ffULL, 0x0000004e25257210ULL, 0x000fe20007f9e0ffULL,
0x000000000e417faeULL, 0x0005e2000d901c46ULL, 0x00005f0017177a11ULL, 0x000fc400030f4c24ULL,
0x0000004e27277210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078c48ffULL, 0x0000000010437faeULL, 0x0007e2000e901c46ULL,
0x000000384500720cULL, 0x080fe20003f86070ULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005f0025257a11ULL, 0x000fe200030f4c26ULL, 0x00000010390c7825ULL, 0x002fe200078e0012ULL,
0x00005e0027267a11ULL, 0x000fe400078648ffULL, 0x000000384700720cULL, 0x080fe20003fc6070ULL,
0x00000010390e7825ULL, 0x004fe200078e0014ULL, 0x000000384900720cULL, 0x000fc40003fa6070ULL,
0x00005f0027277a11ULL, 0x000fe200018f4c3aULL, 0x0000001039147825ULL, 0x000fe200078e0024ULL,
0x000000384b00720cULL, 0x000fc60003f66070ULL, 0x0000001039127825ULL, 0x000fc800078e0016ULL,
0x0000001040257824ULL, 0x000fe400078e0257ULL, 0x0000001039167825ULL, 0x000fc600078e0026ULL,
0x000000000c257faeULL, 0x0003e2000d101c46ULL, 0x0000001042117824ULL, 0x108fe400078e0257ULL,
0x0000001044277824ULL, 0x100fe400078e0257ULL, 0x0000001046397824ULL, 0x100fe200078e0257ULL,
0x000000000e117faeULL, 0x0003e2000e101c46ULL, 0x00000010483b7824ULL, 0x000fc600078e0257ULL,
0x0000000012277faeULL, 0x0003e8000f101c46ULL, 0x0000000014397faeULL, 0x0003e8000e901c46ULL,
0x00000000163b7faeULL, 0x0003e2000d901c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000008000e7811ULL, 0x060fe400078fe8ffULL, 0x00000004000c7811ULL, 0x000fc400078fe8ffULL,
0x0000000c00107811ULL, 0x000fe200078fe8ffULL, 0x000000010e0f7824ULL, 0x100fe200078e0200ULL,
0x0000001400127811ULL, 0x000fe200078fe8ffULL, 0x000000080e447824ULL, 0x000fe200078e00ffULL,
0x0000001800147811ULL, 0x000fe200078fe8ffULL, 0x000000010c0d7824ULL, 0x100fe200078e0200ULL,
0x0000001c00167811ULL, 0x000fe200078fe8ffULL, 0x000000080c427824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee20fULL, 0x0000000110117824ULL, 0x100fe200078e0200ULL,
0x00000010000f7811ULL, 0x000fe200078fe8ffULL, 0x0000000810467824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee20dULL, 0x00000008124a7824ULL, 0x000fe200078e00ffULL,
0x0000000000257211ULL, 0x000fe200078fe8ffULL, 0x000000010f0d7824ULL, 0x140fe200078e0200ULL,
0xfffffff846467812ULL, 0x000fe200078ee211ULL, 0x000000080f487824ULL, 0x000fe200078e00ffULL,
0x0000000725397812ULL, 0x000fe200078ec0ffULL, 0x0000000112117824ULL, 0x000fc400078e0200ULL,
0x0000000114137824ULL, 0x000fe200078e0200ULL, 0xfffffff848487812ULL, 0x000fe200078ee20dULL,
0x00000008146c7824ULL, 0x000fe200078e00ffULL, 0x00000040090d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001044437824ULL, 0x000fe200078e0257ULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee211ULL,
0x0000001048457824ULL, 0x000fe200078e0257ULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee213ULL,
0x000000010f177824ULL, 0x100fe200078e020dULL, 0x0000000d000f7211ULL, 0x000fe200078fe8ffULL,
0x000000010c117824ULL, 0x000fc400078e020dULL, 0x000000010e137824ULL, 0x100fe400078e020dULL,
0x0000000110157824ULL, 0x100fe400078e020dULL, 0x0000000112277824ULL, 0x100fe400078e020dULL,
0x00000001143b7824ULL, 0x100fe400078e020dULL, 0x0000000116417824ULL, 0x040fe200078e020dULL,
0x0000004e0f0d7210ULL, 0x080fe20007f5e0ffULL, 0x0000000116147824ULL, 0x040fe200078e0200ULL,
0x0000004e110f7210ULL, 0x000fe20007f7e0ffULL, 0x0000000816117824ULL, 0x000fc400078e00ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078448ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078648ffULL,
0x000000104a477824ULL, 0x100fe200078e0257ULL, 0xfffffff8116e7812ULL, 0x000fe200078ee214ULL,
0x000000106c497824ULL, 0x100fe200078e0257ULL, 0x00005f000d0d7a11ULL, 0x000fe400010f4c12ULL,
0x0000004e13117210ULL, 0x000fe20007f5e0ffULL, 0x000000106e4b7824ULL, 0x000fe200078e0257ULL,
0x00005f000f0f7a11ULL, 0x000fc400018f4c10ULL, 0x0000004e15137210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x0000004e17157210ULL, 0x000fe40007f9e0ffULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078648ffULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005e0015147a11ULL, 0x000fe400078848ffULL, 0x00005f0011117a11ULL, 0x000fc400010f4c26ULL,
0x0000004e27177210ULL, 0x080fe40007f5e0ffULL, 0x00005f0013137a11ULL, 0x000fe400018f4c24ULL,
0x00005f0015157a11ULL, 0x000fe200020f4c16ULL, 0x000000ffff407224ULL, 0x000fe200010e06ffULL,
0x0000004e3b257210ULL, 0x080fe40007f7e0ffULL, 0x0000004e41277210ULL, 0x000fe20007f9e0ffULL,
0x0000001042417824ULL, 0x000fe200078e0257ULL, 0x00005e0017167a11ULL, 0x000fe200078448ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078648ffULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x00005e0027267a11ULL, 0x000fc400078848ffULL,
0x00005f0017177a11ULL, 0x000fe400010f4c40ULL, 0x0ffffff839407812ULL, 0x000fe200078ef800ULL,
0x0000000103397824ULL, 0x000fe200078e0256ULL, 0x00005f0025257a11ULL, 0x000fe400018f4c3aULL,
0x00005f0027277a11ULL, 0x000fe200020f4c38ULL, 0x00000010403b7824ULL, 0x000fe400078e0257ULL,
0x00000010390c7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x040fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c3b7faeULL, 0x0003e6000b901c46ULL,
0x0000001039107825ULL, 0x040fe200078e0010ULL, 0x000000000e417faeULL, 0x0003e6000b901c46ULL,
0x0000001039127825ULL, 0x040fe200078e0012ULL, 0x0000000010437faeULL, 0x0003e6000b901c46ULL,
0x0000001039147825ULL, 0x000fc800078e0014ULL, 0x0000001039167825ULL, 0x000fc800078e0016ULL,
0x0000001039247825ULL, 0x000fc800078e0024ULL, 0x0000001039267825ULL, 0x000fc800078e0026ULL,
0x0000001046397824ULL, 0x000fca00078e0257ULL, 0x0000000012397faeULL, 0x0003e8000b901c46ULL,
0x0000000014457faeULL, 0x0003e8000b901c46ULL, 0x0000000016477faeULL, 0x0003e8000b901c46ULL,
0x0000000024497faeULL, 0x0003e8000b901c46ULL, 0x00000000264b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000052ff0c723eULL, 0x002fe400000000ffULL, 0x00000002ff107819ULL, 0x000fe40000011600ULL,
0x000054100c417816ULL, 0x000fe2000000000cULL, 0x000109f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1041537589ULL, 0x0002a400000e0000ULL, 0x0000000810407810ULL, 0x002fe20007ffe0ffULL,
0x00010a327f007947ULL, 0x000fea000b800000ULL, 0x00001f4041547589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001010407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00009900000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x000112c000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001810407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00009960000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x004fc400078e00ffULL, 0x0001126000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0001300061407811ULL, 0x002fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006670783bULL, 0x000fe20000004200ULL,
0x00013000670c7811ULL, 0x000fc600078e20ffULL, 0x000000004040783bULL, 0x000e680000000200ULL,
0x00000000636c783bULL, 0x000fe80000004200ULL, 0x000000006448783bULL, 0x000fe80000004200ULL,
0x000000006544783bULL, 0x000fe80000004200ULL, 0x000000000c0c783bULL, 0x004ea80000000200ULL,
0x000000004c38783bULL, 0x000f280000004200ULL, 0x000000006824783bULL, 0x000ee80000004200ULL,
0x000000006914783bULL, 0x000ee80000004200ULL, 0x000000000b10783bULL, 0x000ee20000004200ULL,
0x0000005340400232ULL, 0x002fc40000000000ULL, 0x0000005342420232ULL, 0x000fe40000000000ULL,
0x0000005441410232ULL, 0x088fe40000000000ULL, 0x0000005443430232ULL, 0x000fce0000000000ULL,
0x000000704018723cULL, 0x000f620000001818ULL, 0x000000530c0c0232ULL, 0x084fe40000000000ULL,
0x000000530e0e0232ULL, 0x000fe40000000000ULL, 0x000000540d0d0232ULL, 0x000fc60000000000ULL,
0x00000072401c723cULL, 0x000f62000000181cULL, 0x000000540f0f0232ULL, 0x000fce0000000000ULL,
0x0000006c4020723cULL, 0x040f700000001820ULL, 0x0000006e4028723cULL, 0x040f700000001828ULL,
0x00000048402c723cULL, 0x040f70000000182cULL, 0x0000004a4030723cULL, 0x040f700000001830ULL,
0x000000444034723cULL, 0x040f700000001834ULL, 0x00000046403c723cULL, 0x000f70000000183cULL,
0x000000380c18723cULL, 0x070b700000001818ULL, 0x0000003a0c1c723cULL, 0x040b70000000181cULL,
0x000000240c20723cULL, 0x040b700000001820ULL, 0x000000260c28723cULL, 0x040b700000001828ULL,
0x000000140c2c723cULL, 0x040b70000000182cULL, 0x000000160c30723cULL, 0x040b700000001830ULL,
0x000000100c34723cULL, 0x040b700000001834ULL, 0x000000120c3c723cULL, 0x000b62000000183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000c0070d7811ULL, 0x020fe200078e40ffULL,
0x01c69800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000060d00720cULL, 0x000fda0003f06070ULL,
0x00002ba000000947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff257819ULL, 0x100fe40000011600ULL,
0x000000e0070d7811ULL, 0x000fe400078e40ffULL, 0x0000000425397810ULL, 0x000fe40007ffe0ffULL,
0x0000000d06027217ULL, 0x000fe40007800000ULL, 0x00000060090e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000139047824ULL, 0x000fe200078e0200ULL, 0x0000000c25477810ULL, 0x000fe20007ffe0ffULL,
0x0000000839417824ULL, 0x000fe200078e00ffULL, 0x0000000825437810ULL, 0x040fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a0dULL, 0x00000014256d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001250d7824ULL, 0x000fe200078e020eULL, 0xfffffff841417812ULL, 0x000fe200078ee204ULL,
0x00000001470f7824ULL, 0x100fe200078e0200ULL, 0x00000010254b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000847127824ULL, 0x000fe200078e00ffULL, 0x0000004e0d047210ULL, 0x080fe20007f1e0ffULL,
0x00000001430c7824ULL, 0x100fe200078e0200ULL, 0x0000001825717810ULL, 0x000fe20007ffe0ffULL,
0x0000000843457824ULL, 0x000fe200078e00ffULL, 0xfffffff812497812ULL, 0x000fe200078ee20fULL,
0x000000016d117824ULL, 0x000fe200078e0200ULL, 0x0000001c25757810ULL, 0x000fe20007ffe0ffULL,
0x000000086d147824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee20cULL,
0x00000001390f7824ULL, 0x000fe200078e020eULL, 0x0000002002027817ULL, 0x000fe20003800000ULL,
0x000000014b107824ULL, 0x040fe200078e0200ULL, 0xfffffff8146f7812ULL, 0x000fe200078ee211ULL,
0x000000084b6b7824ULL, 0x000fe200078e00ffULL, 0x0000004e0f0f7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e00040c7a11ULL, 0x040fe200078048ffULL,
0x0000000143117824ULL, 0x000fe200078e020eULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee210ULL,
0x0000000171147824ULL, 0x040fe200078e0200ULL, 0x00005f00040d7a11ULL, 0x000fe200000f4c0dULL,
0x0000000871737824ULL, 0x000fe200078e00ffULL, 0x0000004e11117210ULL, 0x000fe20007f1e0ffULL,
0x0000000147137824ULL, 0x000fc400078e020eULL, 0x000000014b157824ULL, 0x000fe200078e020eULL,
0xfffffff873737812ULL, 0x000fe200078ee214ULL, 0x000000016d177824ULL, 0x100fe200078e020eULL,
0x0000004e13137210ULL, 0x080fe20007f5e0ffULL, 0x0000000171277824ULL, 0x100fe200078e020eULL,
0x0000004e15157210ULL, 0x080fe20007f3e0ffULL, 0x00000001753b7824ULL, 0x000fe200078e020eULL,
0x00005e000f0e7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x0000004e27047210ULL, 0x080fe20007fbe0ffULL, 0x0000000125147824ULL, 0x000fe200078e0200ULL,
0x0000004e17177210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005f000f0f7a11ULL, 0x000fe200030f4c10ULL, 0x0000000175167824ULL, 0x000fe200078e0200ULL,
0x00005e0011107a11ULL, 0x000fe200078048ffULL, 0x0000000875777824ULL, 0x000fe200078e00ffULL,
0x0000000714277812ULL, 0x000fe200078ec0ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00005f0011117a11ULL, 0x000fe200000f4c12ULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078c48ffULL, 0x0000001041417824ULL, 0x000fe200078e0262ULL,
0xfffffff877777812ULL, 0x000fe200078ee216ULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x000000022500720cULL, 0x080fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200028e06ffULL,
0x00005f0013137a11ULL, 0x000fe200030f4c14ULL, 0x0000001045457824ULL, 0x100fe200078e0262ULL,
0x00005e0015147a11ULL, 0x000fe200078c48ffULL, 0x0000001049497824ULL, 0x000fe200078e0262ULL,
0x0ffffff827277812ULL, 0x000fe200078ef800ULL, 0x000000106b6b7824ULL, 0x000fe200078e0262ULL,
0x000000023900720cULL, 0x000fe20003f06070ULL, 0x0000000103397824ULL, 0x000fe200078e0256ULL,
0x00005f0015157a11ULL, 0x000fe200030f4c16ULL, 0x000000106f6f7824ULL, 0x100fe200078e0262ULL,
0x0000004e3b4e7210ULL, 0x000fe20007f9e0ffULL, 0x00000010273b7824ULL, 0x000fe200078e0262ULL,
0x00005e0017167a11ULL, 0x000fe200078c48ffULL, 0x00000010390c7825ULL, 0x000fe200078e000cULL,
0x000000024300720cULL, 0x000fc40003f26070ULL, 0x00005f0017177a11ULL, 0x000fe200030f4c24ULL,
0x000000ffff277224ULL, 0x000fe200020e06ffULL, 0x00005e0004247a11ULL, 0x000fe200078a48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c3b7faeULL, 0x0003e2000d101c46ULL,
0x00005e004e267a11ULL, 0x000fe200078c48ffULL, 0x0000001073737824ULL, 0x100fe200078e0262ULL,
0x000000024700720cULL, 0x080fe20003f66070ULL, 0x0000001077777824ULL, 0x000fe200078e0262ULL,
0x000000024b00720cULL, 0x080fe40003f46070ULL, 0x000000026d00720cULL, 0x000fc40003f86070ULL,
0x00005f0004257a11ULL, 0x000fe400028f4c25ULL, 0x000000027100720cULL, 0x080fe20003fa6070ULL,
0x00000010390c7825ULL, 0x002fe200078e000eULL, 0x00005f004e277a11ULL, 0x000fe400030f4c27ULL,
0x000000027500720cULL, 0x000fe20003fc6070ULL, 0x00000010390e7825ULL, 0x040fe200078e0010ULL,
0x000000000c417faeULL, 0x0003e6000c101c46ULL, 0x0000001039107825ULL, 0x040fe200078e0012ULL,
0x000000000e457faeULL, 0x0003e6000c901c46ULL, 0x0000001039127825ULL, 0x040fe200078e0014ULL,
0x0000000010497faeULL, 0x0003e6000d901c46ULL, 0x0000001039147825ULL, 0x040fe200078e0016ULL,
0x00000000126b7faeULL, 0x0003e6000d101c46ULL, 0x0000001039167825ULL, 0x040fe200078e0024ULL,
0x00000000146f7faeULL, 0x0003e6000e101c46ULL, 0x0000001039247825ULL, 0x000fe200078e0026ULL,
0x0000000016737faeULL, 0x0003e8000e901c46ULL, 0x0000000024777faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000004000e7811ULL, 0x040fe400078fe8ffULL,
0x0000000c00127811ULL, 0x000fc400078fe8ffULL, 0x0000000800107811ULL, 0x000fe200078fe8ffULL,
0x000000010e027824ULL, 0x140fe200078e0200ULL, 0x00000060090f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e257824ULL, 0x000fe200078e00ffULL, 0x0000001000147811ULL, 0x000fe200078fe8ffULL,
0x0000000812457824ULL, 0x000fe200078e00ffULL, 0x0000000f000d7211ULL, 0x000fe200078fe8ffULL,
0x0000000110047824ULL, 0x000fe200078e0200ULL, 0xfffffff825257812ULL, 0x000fe200078ee202ULL,
0x0000000112027824ULL, 0x000fe200078e0200ULL, 0x0000001400167811ULL, 0x000fe200078fe8ffULL,
0x0000000810277824ULL, 0x000fe200078e00ffULL, 0x0000001800177811ULL, 0x000fe200078fe8ffULL,
0x0000000814477824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee202ULL,
0x0000000816497824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee204ULL,
0x0000000114047824ULL, 0x100fe200078e0200ULL, 0x0000004e0d027210ULL, 0x000fe20007f1e0ffULL,
0x0000000117117824ULL, 0x000fc400078e0200ULL, 0x0000000817247824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee204ULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e00020c7a11ULL, 0x000fe200078048ffULL, 0x0000000116047824ULL, 0x000fe200078e0200ULL,
0xfffffff8244b7812ULL, 0x000fe200078ee211ULL, 0x000000010e137824ULL, 0x000fe200078e020fULL,
0x00005f00020d7a11ULL, 0x000fe200000f4c0dULL, 0x0000000110157824ULL, 0x100fe200078e020fULL,
0x0000001c00027811ULL, 0x000fe200078fe8ffULL, 0x0000000112397824ULL, 0x100fe200078e020fULL,
0xfffffff849497812ULL, 0x000fe200078ee204ULL, 0x00000001143b7824ULL, 0x100fe200078e020fULL,
0x0000000000047211ULL, 0x000fe200078fe8ffULL, 0x0000000116417824ULL, 0x000fc400078e020fULL,
0x0000000117437824ULL, 0x100fe200078e020fULL, 0x0000000704117812ULL, 0x000fe200078ec0ffULL,
0x00000001026b7824ULL, 0x040fe200078e020fULL, 0x0000004e130f7210ULL, 0x080fe20007f9e0ffULL,
0x0000000102127824ULL, 0x140fe200078e0200ULL, 0x0ffffff811177812ULL, 0x000fe200078ef800ULL,
0x00000008026d7824ULL, 0x000fe200078e00ffULL, 0x0000004e15117210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x0000004e39137210ULL, 0x080fe20007f7e0ffULL,
0x0000001045457824ULL, 0x000fe200078e0262ULL, 0x00005e000f0e7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x0000004e3b157210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0xfffffff86d397812ULL, 0x000fe200078ee212ULL,
0x00000010173b7824ULL, 0x000fe200078e0262ULL, 0x00005f000f0f7a11ULL, 0x000fe200030f4c10ULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x0000004e41047210ULL, 0x080fe20007f1e0ffULL,
0x0000001025417824ULL, 0x100fe200078e0262ULL, 0x00005e0011107a11ULL, 0x000fe200078248ffULL,
0x0000001047477824ULL, 0x100fe200078e0262ULL, 0x00005e0013127a11ULL, 0x000fe200078648ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x0000004e43027210ULL, 0x080fe20007fbe0ffULL,
0x0000001027437824ULL, 0x100fe200078e0262ULL, 0x0000004e6b4e7210ULL, 0x000fe20007f9e0ffULL,
0x00000010396b7824ULL, 0x000fe200078e0262ULL, 0x00005f0011117a11ULL, 0x000fe200008f4c16ULL,
0x000000ffff257224ULL, 0x000fe200028e06ffULL, 0x00005f0013137a11ULL, 0x000fe200018f4c14ULL,
0x0000000103397824ULL, 0x000fe200078e0256ULL, 0x00005e0015147a11ULL, 0x000fe200078248ffULL,
0x000000ffff277224ULL, 0x000fe200020e06ffULL, 0x00005e0004167a11ULL, 0x000fe200078048ffULL,
0x00000010390c7825ULL, 0x000fe200078e000cULL, 0x00005e0002247a11ULL, 0x000fc400078448ffULL,
0x00005e004e267a11ULL, 0x000fe200078648ffULL, 0x00000010390e7825ULL, 0x000fe200078e000eULL,
0x00005f0015157a11ULL, 0x000fe200008f4c38ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c3b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0004177a11ULL, 0x000fe200000f4c17ULL,
0x0000001039107825ULL, 0x040fe200078e0010ULL, 0x00005f0002257a11ULL, 0x000fe200010f4c25ULL,
0x000000000e417faeULL, 0x0003e2000b901c46ULL, 0x00005f004e277a11ULL, 0x000fe200018f4c27ULL,
0x0000001039127825ULL, 0x040fe400078e0012ULL, 0x0000000010437faeULL, 0x0003e4000b901c46ULL,
0x0000001039147825ULL, 0x000fc400078e0014ULL, 0x0000000012457faeULL, 0x0003e4000b901c46ULL,
0x0000001049497824ULL, 0x000fe400078e0262ULL, 0x0000001039167825ULL, 0x000fe200078e0016ULL,
0x0000000014477faeULL, 0x0003e6000b901c46ULL, 0x000000104b4b7824ULL, 0x000fe200078e0262ULL,
0x0000000016497faeULL, 0x0003e2000b901c46ULL, 0x0000001039247825ULL, 0x000fc800078e0024ULL,
0x0000001039267825ULL, 0x000fe200078e0026ULL, 0x00000000244b7faeULL, 0x0003e8000b901c46ULL,
0x00000000266b7faeULL, 0x0003e4000b901c46ULL, 0x00000001504d7824ULL, 0x000fe400078e024dULL,
0x00000300ff027624ULL, 0x000fc600078e00ffULL, 0x000000014d047812ULL, 0x000fe400078ec0ffULL,
0xffffffff02027811ULL, 0x000fe400078e08ffULL, 0x000000010400780cULL, 0x000fe20003f05070ULL,
0xffffffffff047424ULL, 0x000fc600078e00ffULL, 0x0000000102027807ULL, 0x000fca0004000000ULL,
0x000000014d027824ULL, 0x000fca00078e0202ULL, 0x000000c30200720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00000001020c7824ULL, 0x002fe400078e024fULL,
0x00000004ff0d7424ULL, 0x000fc800078e00ffULL, 0x000060000c0c7625ULL, 0x000fca00078e000dULL,
0x000000060c047981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6680003107f8cULL, 0x0022a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01c66c00030f7984ULL, 0x000ee40000000800ULL,
0x800000000fff7812ULL, 0x00cfe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000130e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01c66c00030f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c1800051117984ULL, 0x000ea80000000800ULL,
0x01c3800051137984ULL, 0x0006620000000800ULL, 0x0000006a1100720bULL, 0x004fe20003f1d000ULL,
0x0000f5927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x008fc800000e0100ULL,
0x0000ffff10ff7812ULL, 0x000fe2000782c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x000000030800780cULL, 0x000fe40003f05270ULL, 0x0000006a1100720bULL, 0x000fe20003f34000ULL,
0x0000f5727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x000fc400008e0100ULL,
0x0000006a110c8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910150d7816ULL, 0x000fc600000000ffULL, 0x01c5800c51008388ULL, 0x0005e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000006a110d7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL, 0x0000006a0d0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00417308ULL, 0x000ea40000000800ULL,
0x000000410a0a7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff407819ULL, 0x000fe20000011600ULL, 0x0000f4b27f007947ULL, 0x000fea000b800000ULL,
0x00001f40410e7589ULL, 0x0004e400000e0000ULL, 0x0000000e18187220ULL, 0x08cfe40000410000ULL,
0x0000000e19197220ULL, 0x080fe40000410000ULL, 0x0000000e1c1c7220ULL, 0x080fe40000410000ULL,
0x0000000e1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000e20207220ULL, 0x080fe40000410000ULL,
0x0000000e21217220ULL, 0x080fe40000410000ULL, 0x0000000e28287220ULL, 0x080fe40000410000ULL,
0x0000000e29297220ULL, 0x080fe40000410000ULL, 0x0000000e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000000e2d2d7220ULL, 0x000fc40000410000ULL, 0x0000000e30307220ULL, 0x080fe40000410000ULL,
0x0000000e31317220ULL, 0x080fe40000410000ULL, 0x0000000e34347220ULL, 0x080fe40000410000ULL,
0x0000000e35357220ULL, 0x080fe40000410000ULL, 0x0000000e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800407811ULL, 0x002fe200078ff0ffULL, 0x0000f3a27f007947ULL, 0x000fea000b800000ULL,
0x00001f40410e7589ULL, 0x0002a400000e0000ULL, 0x0000000e1a1a7220ULL, 0x084fe40000410000ULL,
0x0000000e1b1b7220ULL, 0x080fe40000410000ULL, 0x0000000e1e1e7220ULL, 0x080fe40000410000ULL,
0x0000000e1f1f7220ULL, 0x080fe40000410000ULL, 0x0000000e22227220ULL, 0x080fe40000410000ULL,
0x0000000e23237220ULL, 0x000fc40000410000ULL, 0x0000000e2a2a7220ULL, 0x080fe40000410000ULL,
0x0000000e2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000e2e2e7220ULL, 0x080fe40000410000ULL,
0x0000000e2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000e32327220ULL, 0x080fe40000410000ULL,
0x0000000e33337220ULL, 0x000fc40000410000ULL, 0x0000000e36367220ULL, 0x080fe40000410000ULL,
0x0000000e37377220ULL, 0x080fe40000410000ULL, 0x0000000e3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000e3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fe40007800810ULL, 0x0000006a116a7209ULL, 0x000fd60007810000ULL,
0x8000006a11110221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100520308ULL, 0x000ea40000000800ULL, 0x0000005213130220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x0000000a130a7221ULL, 0x002fe20000010000ULL,
0x0000014000008947ULL, 0x000fea0003800000ULL, 0x00000052ff0c723eULL, 0x000fe400000000ffULL,
0x00000002ff107819ULL, 0x000fe40000011600ULL, 0x000054100c417816ULL, 0x000fe2000000000cULL,
0x0000f1e27f007947ULL, 0x000fea000b800000ULL, 0x00001f1041537589ULL, 0x0002a400000e0000ULL,
0x0000000810407810ULL, 0x002fe20007ffe0ffULL, 0x0000f2227f007947ULL, 0x000fea000b800000ULL,
0x00001f4041547589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001010407810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x0000b330000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000f89000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001810407810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x0000b390000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x004fc400078e00ffULL,
0x0000f83000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0001380055107811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005814783bULL, 0x000fe20000004200ULL, 0x000138005c0c7811ULL, 0x000fc600078e20ffULL,
0x000000001010783bULL, 0x000e680000000200ULL, 0x000000005924783bULL, 0x000fe80000004200ULL,
0x000000005a38783bULL, 0x000fe80000004200ULL, 0x000000005b40783bULL, 0x002fe80000004200ULL,
0x000000000c0c783bULL, 0x004e680000000200ULL, 0x000000005d44783bULL, 0x000ea80000004200ULL,
0x000000005e48783bULL, 0x000ee80000004200ULL, 0x000000005f6c783bULL, 0x000ea80000004200ULL,
0x000000006070783bULL, 0x000ea20000004200ULL, 0x0000005310100232ULL, 0x000fc40000000000ULL,
0x0000005312120232ULL, 0x000fe40000000000ULL, 0x0000005411110232ULL, 0x088fe40000000000ULL,
0x0000005413130232ULL, 0x000fce0000000000ULL, 0x000000141018723cULL, 0x000f620000001818ULL,
0x000000530c0c0232ULL, 0x082fe40000000000ULL, 0x000000530e0e0232ULL, 0x000fe40000000000ULL,
0x000000540d0d0232ULL, 0x000fc60000000000ULL, 0x000000161014723cULL, 0x000fe2000000181cULL,
0x000000540f0f0232ULL, 0x000fce0000000000ULL, 0x000000241020723cULL, 0x040f700000001820ULL,
0x00000026101c723cULL, 0x040ff00000001828ULL, 0x00000038102c723cULL, 0x040f70000000182cULL,
0x0000003a1024723cULL, 0x040f700000001830ULL, 0x000000401028723cULL, 0x040f700000001834ULL,
0x00000042103c723cULL, 0x000f70000000183cULL, 0x000000440c10723cULL, 0x064f700000001818ULL,
0x000000480c18723cULL, 0x040f700000001820ULL, 0x0000006c0c20723cULL, 0x040f70000000182cULL,
0x000000460c14723cULL, 0x040f700000001814ULL, 0x0000004a0c1c723cULL, 0x040f70000000181cULL,
0x0000006e0c24723cULL, 0x040f700000001824ULL, 0x000000700c28723cULL, 0x040f700000001828ULL,
0x000000720c2c723cULL, 0x000b6e000000183cULL, 0x00000300070d7a10ULL, 0x020fe20007ffe0ffULL,
0x00005800040e7a24ULL, 0x010fc600078e02ffULL, 0x000000010d0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000800e3b7824ULL, 0x000fc600078e00ffULL, 0x000000050c00720cULL, 0x000fe20003f26070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x00000003ff3d7819ULL, 0x000fe20000011600ULL, 0x000001000d0d7824ULL, 0x000fc600078e00ffULL,
0x000000043d417810ULL, 0x040fe20007ffe0ffULL, 0x000000013d367824ULL, 0x140fe200078e0200ULL,
0x0000000d060c7217ULL, 0x000fe40007800000ULL, 0x000000083d437810ULL, 0x000fe20007ffe0ffULL,
0x00000001410e7824ULL, 0x100fe200078e0200ULL, 0x0000000c3d457810ULL, 0x000fe20007ffe0ffULL,
0x00000008410f7824ULL, 0x000fe200078e00ffULL, 0x000000103d477810ULL, 0x040fe20007ffe0ffULL,
0x000000010c327824ULL, 0x000fe200078e0a0dULL, 0x000000143d497810ULL, 0x000fe20007ffe0ffULL,
0x00000001430c7824ULL, 0x000fe200078e0200ULL, 0xfffffff80f3a7812ULL, 0x000fe200078ee20eULL,
0x00000008430f7824ULL, 0x000fe200078e00ffULL, 0x000000183d4b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001450d7824ULL, 0x040fe200078e0200ULL, 0x00000007363f7812ULL, 0x000fe200078ec0ffULL,
0x0000000845427824ULL, 0x000fe200078e00ffULL, 0xfffffff80f407812ULL, 0x000fe200078ee20cULL,
0x00000001090c7824ULL, 0x000fe200078e023dULL, 0x0000001c3d4d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001470e7824ULL, 0x140fe200078e0200ULL, 0xfffffff842427812ULL, 0x000fe200078ee20dULL,
0x0000000847317824ULL, 0x000fe200078e00ffULL, 0x0000003b0c0d7210ULL, 0x080fe20007f3e0ffULL,
0x00000001090c7824ULL, 0x000fe200078e0241ULL, 0x0ffffff83f367812ULL, 0x000fe200078ef800ULL,
0x0000000849467824ULL, 0x000fe200078e00ffULL, 0xfffffff831447812ULL, 0x000fe200078ee20eULL,
0x000000ffff347224ULL, 0x000fe200008e06ffULL, 0x0000003b0c0f7210ULL, 0x000fe20007f5e0ffULL,
0x0000000149317824ULL, 0x100fe200078e0200ULL, 0x00005e000d0c7a11ULL, 0x000fe200078248ffULL,
0x000000014b337824ULL, 0x000fc400078e0200ULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x000000084b487824ULL, 0x000fe200078e00ffULL,
0x00005f000d0d7a11ULL, 0x000fe200008f4c34ULL, 0x0000000109347824ULL, 0x000fe200078e0245ULL,
0x00005f000f0f7a11ULL, 0x000fe200010f4c30ULL, 0x0000000109307824ULL, 0x040fe200078e0243ULL,
0xfffffff846467812ULL, 0x000fe200078ee231ULL, 0x00000001093c7824ULL, 0x040fe200078e0249ULL,
0xfffffff848487812ULL, 0x000fe200078ee233ULL, 0x0000000109387824ULL, 0x040fe200078e0247ULL,
0x0000003b30317210ULL, 0x080fe20007f7e0ffULL, 0x00000001093e7824ULL, 0x040fe200078e024bULL,
0x0000003b34337210ULL, 0x080fe20007f3e0ffULL, 0x00000001094a7824ULL, 0x000fe200078e024dULL,
0x00005e0031307a11ULL, 0x000fe200078c48ffULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x0000003b3c377210ULL, 0x080fe20007f7e0ffULL, 0x000000084d517824ULL, 0x040fe200078e00ffULL,
0x0000003b38357210ULL, 0x080fe20007f5e0ffULL, 0x000000014d387824ULL, 0x000fe200078e0200ULL,
0x00005f0031317a11ULL, 0x000fe200030f4c34ULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x00000020323c7817ULL, 0x000fe20003800000ULL, 0x00000010363f7824ULL, 0x000fe200078e0257ULL,
0x00005e0033327a11ULL, 0x000fe200078c48ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x0000003b3e397210ULL, 0x000fc40007fbe0ffULL, 0x00005f0033337a11ULL, 0x000fe400030f4c34ULL,
0x00005e0035347a11ULL, 0x000fe400078c48ffULL, 0x0000003c3d00720cULL, 0x080fe20003f26070ULL,
0x00000001033d7824ULL, 0x000fe200078e0256ULL, 0x0000003b4a3b7210ULL, 0x000fe40007f9e0ffULL,
0xfffffff8514a7812ULL, 0x000fe200078ee238ULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00005f0035357a11ULL, 0x000fe200030f4c36ULL, 0x000000103d0c7825ULL, 0x000fe200078e000cULL,
0x0000003c4100720cULL, 0x000fc40003f46070ULL, 0x00005e0037367a11ULL, 0x000fe200078c48ffULL,
0x000000103a417824ULL, 0x000fe200078e0257ULL, 0x0000003c4500720cULL, 0x080fe20003f66070ULL,
0x000000ffff3a7224ULL, 0x000fe200028e06ffULL, 0x00005f0037377a11ULL, 0x000fe200030f4c38ULL,
0x000000103d0e7825ULL, 0x000fe200078e000eULL, 0x00005e0039387a11ULL, 0x000fe200078c48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c3f7faeULL, 0x0003e2000c901c46ULL,
0x0000003c4300720cULL, 0x080fe20003f26070ULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005f0039397a11ULL, 0x000fe200030f4c3aULL, 0x000000000e417faeULL, 0x0005e2000d101c46ULL,
0x00005e003b3a7a11ULL, 0x000fe200078848ffULL, 0x0000001042437824ULL, 0x100fe200078e0257ULL,
0x0000003c4700720cULL, 0x080fe20003fa6070ULL, 0x0000001044457824ULL, 0x100fe200078e0257ULL,
0x0000003c4900720cULL, 0x080fe20003fc6070ULL, 0x0000001046477824ULL, 0x100fe200078e0257ULL,
0x0000003c4b00720cULL, 0x080fe20003f46070ULL, 0x00000010403f7824ULL, 0x002fe200078e0257ULL,
0x00005f003b3b7a11ULL, 0x000fe200020f4c3eULL, 0x000000103d0c7825ULL, 0x000fe200078e0030ULL,
0x0000003c4d00720cULL, 0x000fc60003f86070ULL, 0x000000103d0e7825ULL, 0x044fe200078e0032ULL,
0x000000000c3f7faeULL, 0x0003e6000c901c46ULL, 0x000000103d307825ULL, 0x040fe200078e0034ULL,
0x000000000e437faeULL, 0x0003e6000d901c46ULL, 0x000000103d327825ULL, 0x040fe200078e0036ULL,
0x0000000030457faeULL, 0x0003e6000e901c46ULL, 0x0000001048497824ULL, 0x000fe200078e0257ULL,
0x0000000032477faeULL, 0x0003e2000f101c46ULL, 0x000000103d347825ULL, 0x000fc800078e0038ULL,
0x000000104a577824ULL, 0x000fe200078e0257ULL, 0x0000000034497faeULL, 0x0003e2000d101c46ULL,
0x000000103d367825ULL, 0x000fca00078e003aULL, 0x0000000036577faeULL, 0x0003e2000e101c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x00000004000d7811ULL, 0x040fe400078fe8ffULL,
0x0000001000357811ULL, 0x040fe400078fe8ffULL, 0x0000000c00347811ULL, 0x040fe200078fe8ffULL,
0x000000010d0c7824ULL, 0x140fe200078e0200ULL, 0x0000000800337811ULL, 0x040fe200078fe8ffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0x0000001400377811ULL, 0x040fe200078fe8ffULL,
0x00000008353e7824ULL, 0x000fe200078e00ffULL, 0x0000001c003d7811ULL, 0x000fe200078fe8ffULL,
0x00000001340e7824ULL, 0x000fe200078e0200ULL, 0xfffffff80f367812ULL, 0x000fe200078ee20cULL,
0x00000001350f7824ULL, 0x000fc400078e0200ULL, 0x0000000834397824ULL, 0x000fe400078e00ffULL,
0x00000001330c7824ULL, 0x040fe200078e0200ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20fULL,
0x0000000833317824ULL, 0x000fe200078e00ffULL, 0xfffffff8393a7812ULL, 0x000fe200078ee20eULL,
0x00000001370f7824ULL, 0x040fe200078e0200ULL, 0x0000001800397811ULL, 0x040fe200078fe8ffULL,
0x0000000837427824ULL, 0x000fe200078e00ffULL, 0xfffffff831387812ULL, 0x000fe200078ee20cULL,
0x00000001090e7824ULL, 0x000fe200078e020dULL, 0x00000009000c7211ULL, 0x000fe200078fe8ffULL,
0x0000000139317824ULL, 0x140fe200078e0200ULL, 0xfffffff842427812ULL, 0x000fe200078ee20fULL,
0x0000000839467824ULL, 0x000fe200078e00ffULL, 0x0000003b0e0f7210ULL, 0x080fe20007f5e0ffULL,
0x00000001093c7824ULL, 0x000fe200078e0235ULL, 0x0000003b0c0d7210ULL, 0x080fe20007f3e0ffULL,
0x000000013d3f7824ULL, 0x000fe200078e0200ULL, 0xfffffff846467812ULL, 0x000fe200078ee231ULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078448ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x0000000000317211ULL, 0x000fe200078fe8ffULL,
0x000000083d4a7824ULL, 0x000fe200078e00ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078248ffULL,
0x0000000109407824ULL, 0x000fe200078e0237ULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c30ULL,
0x0000000109307824ULL, 0x000fe200078e0233ULL, 0x0000000731317812ULL, 0x000fe200078ec0ffULL,
0x0000000109447824ULL, 0x000fe200078e0239ULL, 0x00005f000d0d7a11ULL, 0x000fe200008f4c32ULL,
0x0000000109327824ULL, 0x000fe200078e0234ULL, 0x0ffffff831347812ULL, 0x000fe200078ef800ULL,
0x0000000109487824ULL, 0x000fe200078e023dULL, 0x0000003b30317210ULL, 0x080fe20007f9e0ffULL,
0x0000001042497824ULL, 0x100fe200078e0257ULL, 0x0000003b32337210ULL, 0x080fe20007f5e0ffULL,
0x0000001036417824ULL, 0x100fe200078e0257ULL, 0x00005e0031307a11ULL, 0x040fe200078c48ffULL,
0x000000ffff327224ULL, 0x000fe200020e06ffULL, 0x0000003b3c357210ULL, 0x080fe20007f7e0ffULL,
0x0000001038437824ULL, 0x000fe200078e0257ULL, 0xfffffff84a3c7812ULL, 0x000fe200078ee23fULL,
0x00000010343f7824ULL, 0x100fe200078e0257ULL, 0x00005f0031317a11ULL, 0x000fe200030f4c32ULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x0000003b40377210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff427224ULL, 0x000fe200018e06ffULL, 0x00005e0033327a11ULL, 0x040fe200078448ffULL,
0x000000103a457824ULL, 0x100fe200078e0257ULL, 0x0000003b44397210ULL, 0x080fe20007f9e0ffULL,
0x000000103e477824ULL, 0x100fe200078e0257ULL, 0x0000003b483b7210ULL, 0x000fe20007fbe0ffULL,
0x00000010464b7824ULL, 0x100fe200078e0257ULL, 0x00005f0033337a11ULL, 0x000fe200010f4c34ULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078448ffULL,
0x000000103c577824ULL, 0x000fe200078e0257ULL, 0x00005e0037367a11ULL, 0x000fe200078248ffULL,
0x00000001033d7824ULL, 0x000fe200078e0256ULL, 0x00005e0039387a11ULL, 0x000fe200078648ffULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078848ffULL,
0x000000ffff3c7224ULL, 0x000fe200028e06ffULL, 0x00005f0035357a11ULL, 0x000fe200010f4c42ULL,
0x000000103d0c7825ULL, 0x000fe200078e000cULL, 0x00005f0037377a11ULL, 0x000fc400008f4c40ULL,
0x00005f0039397a11ULL, 0x000fe200018f4c3eULL, 0x000000103d0e7825ULL, 0x000fe200078e000eULL,
0x00005f003b3b7a11ULL, 0x000fe200020f4c3cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c46ULL, 0x000000103d307825ULL, 0x040fe400078e0030ULL,
0x000000000e417faeULL, 0x0003e4000b901c46ULL, 0x000000103d327825ULL, 0x040fe400078e0032ULL,
0x0000000030437faeULL, 0x0003e4000b901c46ULL, 0x000000103d347825ULL, 0x000fc400078e0034ULL,
0x0000000032457faeULL, 0x0003e4000b901c46ULL, 0x000000103d367825ULL, 0x040fe400078e0036ULL,
0x0000000034477faeULL, 0x0003e4000b901c46ULL, 0x000000103d387825ULL, 0x040fe400078e0038ULL,
0x0000000036497faeULL, 0x0003e4000b901c46ULL, 0x000000103d3a7825ULL, 0x000fc400078e003aULL,
0x00000000384b7faeULL, 0x0003e8000b901c46ULL, 0x000000003a577faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000052ff0c723eULL, 0x002fe400000000ffULL, 0x00000002ff307819ULL, 0x000fe40000011600ULL,
0x000054100c417816ULL, 0x000fe2000000000cULL, 0x0000e1227f007947ULL, 0x000fea000b800000ULL,
0x00001f3041537589ULL, 0x0002a400000e0000ULL, 0x0000000830407810ULL, 0x002fe20007ffe0ffULL,
0x0000e1627f007947ULL, 0x000fea000b800000ULL, 0x00001f4041547589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001030407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x0000c4c0000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000e70000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001830407810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x0000c520000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x004fc400078e00ffULL, 0x0000e6a000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0001380061617811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006630783bULL, 0x002fe20000004200ULL,
0x0001380067677811ULL, 0x000fc600078e20ffULL, 0x00000000610c783bULL, 0x004e680000000200ULL,
0x000000006334783bULL, 0x000fe80000004200ULL, 0x000000006438783bULL, 0x000fe80000004200ULL,
0x00000000653c783bULL, 0x000fe80000004200ULL, 0x000000006740783bULL, 0x000ea80000000200ULL,
0x000000006848783bULL, 0x000f280000004200ULL, 0x000000004c44783bULL, 0x000ee80000004200ULL,
0x000000006958783bULL, 0x000ee80000004200ULL, 0x000000000b5c783bULL, 0x000ee20000004200ULL,
0x000000530c0c0232ULL, 0x002fc40000000000ULL, 0x000000530e0e0232ULL, 0x000fe40000000000ULL,
0x000000540d0d0232ULL, 0x088fe40000000000ULL, 0x000000540f0f0232ULL, 0x000fce0000000000ULL,
0x000000300c10723cULL, 0x000fe20000001810ULL, 0x0000005340400232ULL, 0x084fe40000000000ULL,
0x0000005342420232ULL, 0x000fe40000000000ULL, 0x0000005441410232ULL, 0x000fc60000000000ULL,
0x000000320c14723cULL, 0x000fe20000001814ULL, 0x0000005443430232ULL, 0x000fce0000000000ULL,
0x000000340c30723cULL, 0x040f700000001818ULL, 0x000000380c60723cULL, 0x040ff00000001820ULL,
0x0000003a0c24723cULL, 0x040ff00000001824ULL, 0x000000360c34723cULL, 0x040f70000000181cULL,
0x0000003c0c38723cULL, 0x040f700000001828ULL, 0x0000003e0c3c723cULL, 0x000f70000000182cULL,
0x000000484020723cULL, 0x070b700000001830ULL, 0x0000004a4028723cULL, 0x040b700000001834ULL,
0x000000444018723cULL, 0x040b700000001810ULL, 0x00000046401c723cULL, 0x040b700000001814ULL,
0x00000058402c723cULL, 0x040b700000001860ULL, 0x0000005a4030723cULL, 0x040b700000001824ULL,
0x0000005c4034723cULL, 0x040b700000001838ULL, 0x0000005e403c723cULL, 0x000b62000000183cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c6a000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030007077a10ULL, 0x000fc80007ffe0ffULL,
0x000000050700720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff4e0000007947ULL, 0x000fea000383ffffULL, 0x0000000000247919ULL, 0x020e640000002500ULL,
0x000000052400720cULL, 0x002fda0003f06070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x018000000a007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000c8d000067802ULL, 0x000fc40000000f00ULL,
0x0000e12000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000a00057308ULL, 0x000e640000001000ULL,
0xbf80000005007423ULL, 0x002fc8000000000aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000005007223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000ea80000000000ULL, 0x0000000000047919ULL, 0x000ee20000000000ULL,
0x00000002ff057819ULL, 0x004fe40000011602ULL, 0x0000000804077811ULL, 0x008fc600078ff0ffULL,
0x00001f0500027589ULL, 0x000ea800000e0000ULL, 0x00001f0700047589ULL, 0x000ee200000e0000ULL,
0x0000001802187220ULL, 0x044fe40000410000ULL, 0x0000001902197220ULL, 0x040fe40000410000ULL,
0x0000001c021c7220ULL, 0x040fe40000410000ULL, 0x0000001d021d7220ULL, 0x000fc40000410000ULL,
0x0000002002207220ULL, 0x040fe40000410000ULL, 0x0000002102217220ULL, 0x040fe40000410000ULL,
0x0000002802287220ULL, 0x040fe40000410000ULL, 0x0000002902297220ULL, 0x040fe40000410000ULL,
0x0000002c022c7220ULL, 0x040fe40000410000ULL, 0x0000002d022d7220ULL, 0x000fc40000410000ULL,
0x0000003002307220ULL, 0x040fe40000410000ULL, 0x0000003102317220ULL, 0x040fe40000410000ULL,
0x0000003402347220ULL, 0x040fe40000410000ULL, 0x0000003502357220ULL, 0x040fe40000410000ULL,
0x0000003c023c7220ULL, 0x040fe40000410000ULL, 0x0000003d023d7220ULL, 0x000fc40000410000ULL,
0x0000001a041a7220ULL, 0x048fe40000410000ULL, 0x0000001b041b7220ULL, 0x040fe40000410000ULL,
0x0000001e041e7220ULL, 0x040fe40000410000ULL, 0x0000001f041f7220ULL, 0x040fe40000410000ULL,
0x0000002204227220ULL, 0x040fe40000410000ULL, 0x0000002304237220ULL, 0x000fc40000410000ULL,
0x0000002a042a7220ULL, 0x040fe40000410000ULL, 0x0000002b042b7220ULL, 0x040fe40000410000ULL,
0x0000002e042e7220ULL, 0x040fe40000410000ULL, 0x0000002f042f7220ULL, 0x040fe40000410000ULL,
0x0000003204327220ULL, 0x040fe40000410000ULL, 0x0000003304337220ULL, 0x000fc40000410000ULL,
0x0000003604367220ULL, 0x040fe40000410000ULL, 0x0000003704377220ULL, 0x040fe40000410000ULL,
0x0000003e043e7220ULL, 0x040fe40000410000ULL, 0x0000003f043f7220ULL, 0x000fc40000410000ULL,
0x0000000000257919ULL, 0x000ea20000000000ULL, 0x0000001a1b0e723eULL, 0x000fe400000000ffULL,
0x000000181904723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001c1d05723eULL, 0x000fc400000000ffULL, 0x000000202106723eULL, 0x000fe400000000ffULL,
0x0000001e1f0f723eULL, 0x000fe400000000ffULL, 0x000000222310723eULL, 0x000fe400000000ffULL,
0x000000282907723eULL, 0x000fe400000000ffULL, 0x0000002c2d09723eULL, 0x000fe400000000ffULL,
0x00000030310b723eULL, 0x000fc400000000ffULL, 0x00000002ff1a7819ULL, 0x004fe40000011625ULL,
0x0000000825277811ULL, 0x000fe400078ff0ffULL, 0x000000011a007810ULL, 0x040fe20007ffe0ffULL,
0x000000081a197824ULL, 0x040fe200078e00ffULL, 0x000000021a027810ULL, 0x040fe20007ffe0ffULL,
0x000000081a1b7824ULL, 0x040fe200078e00ffULL, 0x000000061a177810ULL, 0x040fe20007ffe0ffULL,
0x000000081a1d7824ULL, 0x040fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee200ULL,
0x000000081a187824ULL, 0x040fe200078e00ffULL, 0x000000031a007810ULL, 0x040fe20007ffe0ffULL,
0x000000081a217824ULL, 0x040fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL,
0x000000081a1f7824ULL, 0x040fe200078e00ffULL, 0x000000051a167810ULL, 0x040fe20007ffe0ffULL,
0x000000081a297824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee200ULL,
0x0000080008007824ULL, 0x000fe200078e00ffULL, 0xfffffff818237812ULL, 0x000fe200078ee217ULL,
0x000000081a177824ULL, 0x040fe200078e00ffULL, 0x000000041a027810ULL, 0x000fc40007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee216ULL, 0x0000000425167824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee202ULL, 0xfffffff817177812ULL, 0x000fe400078ee21aULL,
0x0001200000027810ULL, 0x000fe40007ffe0ffULL, 0xffffffff1a187810ULL, 0x000fe20007ffe0ffULL,
0x00000008271a7824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0xfffffff829257812ULL, 0x000fe200078ee218ULL,
0x0000001019197824ULL, 0x100fe200078e0202ULL, 0xfffffff81a277812ULL, 0x000fe200078ee227ULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x00000034350c723eULL, 0x000fe200000000ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0202ULL, 0x0000003c3d0d723eULL, 0x000fe200000000ffULL,
0x0000001021217824ULL, 0x100fe200078e0202ULL, 0x0000002a2b11723eULL, 0x000fe200000000ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0202ULL, 0x0000002e2f12723eULL, 0x000fe200000000ffULL,
0x0000000117177824ULL, 0x000fe200078e0216ULL, 0x000000323313723eULL, 0x000fe200000000ffULL,
0x0000000116187824ULL, 0x040fe200078e0219ULL, 0x000000363714723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x100fe200078e0202ULL, 0x0000000417007388ULL, 0x0005e20000000800ULL,
0x00000001161b7824ULL, 0x040fe200078e021bULL, 0x0000003e3f15723eULL, 0x000fe200000000ffULL,
0x0000001025257824ULL, 0x000fe200078e0202ULL, 0x0000000518007388ULL, 0x0005e20000000800ULL,
0x00000001161a7824ULL, 0x000fc400078e021dULL, 0x00000001161c7824ULL, 0x040fe200078e0221ULL,
0x000000061b007388ULL, 0x0005e20000000800ULL, 0x0000001027277824ULL, 0x000fe400078e0202ULL,
0x00000001161f7824ULL, 0x040fe200078e021fULL, 0x000000071a007388ULL, 0x0005e20000000800ULL,
0x00000300ff217624ULL, 0x000fe400078e00ffULL, 0x0000000116237824ULL, 0x040fe200078e0223ULL,
0x000000091f007388ULL, 0x0005e20000000800ULL, 0x00000001161e7824ULL, 0x040fe200078e0225ULL,
0x000000012100780cULL, 0x000fe20003f05270ULL, 0x0000000116277824ULL, 0x000fe200078e0227ULL,
0x0000000b1c007388ULL, 0x0005e80000000800ULL, 0x0000000c23007388ULL, 0x0005e80000000800ULL,
0x0000000d1e007388ULL, 0x0005e80000000800ULL, 0x0000000e27007388ULL, 0x0005e80000000800ULL,
0x0004000f18007388ULL, 0x0005e80000000800ULL, 0x000400101b007388ULL, 0x0005e80000000800ULL,
0x000400111a007388ULL, 0x0005e80000000800ULL, 0x000400121f007388ULL, 0x0005e80000000800ULL,
0x000400131c007388ULL, 0x0005e80000000800ULL, 0x0004001423007388ULL, 0x0005e80000000800ULL,
0x000400151e007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000271000008947ULL, 0x000fea0003800000ULL, 0x00005800ff047624ULL, 0x004fe200078e00ffULL,
0x0000000000067919ULL, 0x000ea60000002700ULL, 0x0000660004047a24ULL, 0x000fe200078e02ffULL,
0x00000000000b7919ULL, 0x000ea60000002600ULL, 0x0000030004097a24ULL, 0x040fe200078e02ffULL,
0x0000000f04057811ULL, 0x000fe200078e10ffULL, 0x0000000000077919ULL, 0x000ee60000000000ULL,
0xfffffff005127812ULL, 0x000fca00078ec0ffULL, 0x0000008009147824ULL, 0x000fc800078e0212ULL,
0x0000008009097824ULL, 0x000fca00078e0214ULL, 0x0000007f09047810ULL, 0x000fe20007ffe0ffULL,
0x0000580006067a24ULL, 0x004fc600078e020bULL, 0xffffff8004137812ULL, 0x000fe200078ec0ffULL,
0x0000030006097a24ULL, 0x000fe200078e02ffULL, 0x00000020070d7810ULL, 0x048fe20007ffe0ffULL,
0x00000010070c7824ULL, 0x000fe200078e0200ULL, 0x00006a0013047a10ULL, 0x000fe20007f1e0ffULL,
0x00000001090b7824ULL, 0x000fc600078e0224ULL, 0x012000000c187984ULL, 0x000ea20000000c00ULL,
0x00006b00ff0e7624ULL, 0x000fe200000e06ffULL, 0x000000040b047211ULL, 0x040fe400078260ffULL,
0x00006a0012167a10ULL, 0x000fe20007f1e0ffULL, 0x012200000c1c7984ULL, 0x0006620000000c00ULL,
0x0000000e0b057211ULL, 0x000fe400008f64ffULL, 0x000000ff0800720cULL, 0x040fe20003f25270ULL,
0x00006b00ff207624ULL, 0x000fe400000e06ffULL, 0x0000040008047825ULL, 0x000fcc00078e0004ULL,
0x000000100d0c7825ULL, 0x008fc800078e0004ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000011000001947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000ee20000000000ULL,
0x000000800b0f7824ULL, 0x000fe200078e00ffULL, 0x00000019ff0b7819ULL, 0x000fe2000001160bULL,
0x000000100e107824ULL, 0x008fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fc8000001160eULL,
0x0000007010117812ULL, 0x000fe400078ec0ffULL, 0x00006a000f107a10ULL, 0x000fe40007b5e014ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x00000016110f7210ULL, 0x000fe4000791e00fULL,
0x00006b000b157a10ULL, 0x000fe400017e64ffULL, 0x000000100e107210ULL, 0x000fc40007c7e011ULL,
0x0000000f0e0e7210ULL, 0x000fe40007f5e0ffULL, 0x00000020ff0b7210ULL, 0x000fe400007e240bULL,
0x00000015ff117210ULL, 0x000fc60001fe84ffULL, 0x000000ffff0f7224ULL, 0x000fca00010e060bULL,
0x0000006a0e007986ULL, 0x0007e8000c101906ULL, 0x0000000a10007986ULL, 0x0007e4000c101906ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000001804007986ULL, 0x004fe2000c101d06ULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0x000000ff0800720cULL, 0x000fe20000705670ULL,
0x0000001c0c007986ULL, 0x002fe8000c101d06ULL, 0x0000000000007b1dULL, 0x000ff00000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0xffffffff210b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a0006047625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000b040479a8ULL, 0x000ea400099ee1c6ULL,
0x0000000b0400720cULL, 0x004fc80003f05270ULL, 0x00000001ff067807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000006ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff047984ULL, 0x000ea40000000000ULL, 0x000000ff0400720cULL, 0x004fda0003f05270ULL,
0x0000225000008947ULL, 0x000fea0003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001007057824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x002fe40000011607ULL, 0x0000001609047211ULL, 0x000fe400078038ffULL,
0x00000070050b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fe400078ec0ffULL,
0x0000002009057211ULL, 0x000fe400000f3cffULL, 0x0000000406047210ULL, 0x000fc8000791e00bULL,
0x00000005ff057210ULL, 0x000fca00007e24ffULL, 0x0000000604067981ULL, 0x000328000c1e1900ULL,
0x00008006040b7981ULL, 0x000322000c1e1900ULL, 0x000000022100780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010006040d7981ULL, 0x002322000c1e1900ULL,
0x000000042100780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x00018006040f7981ULL, 0x00a322000c1e1900ULL, 0x000000042100780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000604117981ULL, 0x002322000c1e1900ULL,
0x000000062100780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800604157981ULL, 0x002322000c1e1900ULL, 0x000000062100780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000082100780cULL, 0x002fe20003f06070ULL,
0x0003000604177981ULL, 0x000318000c1e1900ULL, 0x0003800604190981ULL, 0x000324000c1e1900ULL,
0x0000000721047810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x008fc80000011604ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x00000012091d7211ULL, 0x000fe200078038ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1b7224ULL, 0x010fe200078e0006ULL,
0x00006a001d1d7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff090c7211ULL, 0x000fe400000f3cffULL,
0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL, 0x00006b00ff0c7a10ULL, 0x000fc400017e240cULL,
0x000003000e007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x000000040a007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080e047810ULL, 0x040fe40007ffe0ffULL, 0x000000010e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001b06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffc8006041b7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090e047810ULL, 0x042fe40007ffe0ffULL, 0x000000020e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000b06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffd0006040b7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000030e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffd8006040d7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000040e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000f06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffe0006040f7981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000050e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffe800604117981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000060e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xffff000604157981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000070e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001706067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xffff800604177981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e047810ULL, 0x002fe40007ffe0ffULL, 0x0000001906067209ULL, 0x000fe40007810000ULL,
0x0000030004007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0x0000000604197981ULL, 0x000326000c1e1900ULL, 0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL,
0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e060cULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x000ea40000000000ULL,
0x0000001007047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fca00078ec0ffULL,
0x0000000104057824ULL, 0x000fca00078e0205ULL, 0x0000000605007388ULL, 0x0103e40000000800ULL,
0x00006a0013047a10ULL, 0x000fe20007f1e0ffULL, 0x0000040008417824ULL, 0x040fe200078e00ffULL,
0x00000016ff437819ULL, 0x000fe20000011608ULL, 0x0000001007067824ULL, 0x042fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011607ULL, 0x00006b00ff057624ULL, 0x000fe200000e06ffULL,
0x000000070700780cULL, 0x000fe20003f04070ULL, 0x0000100008167824ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x00001000090a7825ULL, 0x008fe200078e0004ULL,
0x0000000c0c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000410a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000106067824ULL, 0x000fe200078e020dULL,
0x00006a0012467a10ULL, 0x000fe20007f5e0ffULL, 0x0000001008158824ULL, 0x000fe200078e0207ULL,
0x00000020070d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200008e0643ULL,
0x00006a0014427a10ULL, 0x000fe20007f3e0ffULL, 0x00006b00ff487624ULL, 0x000fe200010e06ffULL,
0x0000004609108211ULL, 0x000fe200078438ffULL, 0x0000001008178824ULL, 0x000fe200078e0207ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x00006b00ff447624ULL, 0x000fe200008e06ffULL,
0x00000042090e8211ULL, 0x000fe200078238ffULL, 0x000000100d0c7825ULL, 0x000fe200078e000aULL,
0x0000004809118211ULL, 0x040fe200010f3cffULL, 0x0000000006067984ULL, 0x000e620000000800ULL,
0x00000044090f8211ULL, 0x000fe200008f3cffULL, 0x0000001007137824ULL, 0x040fe200078e0216ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000010070a7825ULL, 0x000fe200078e000aULL,
0x0000418017178811ULL, 0x000fe200078e20ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000010070e8825ULL, 0x040fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0005e2000b901c46ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000001007108825ULL, 0x000fe200078e0010ULL, 0x003800000c137faeULL, 0x0005e2000b901c46ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000000e158faeULL, 0x0007e2000b901c46ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000010178faeULL, 0x0009e2000b901c46ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000127805ULL, 0x004fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x008fe2000001ff00ULL, 0x000000ffff177224ULL, 0x010fe200078e00ffULL,
0x00000bd000009947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fc400078e00ffULL, 0x00000001ff477424ULL, 0x000fca00078e00ffULL,
0x0000030047007a0cULL, 0x000fda0003f06070ULL, 0x000001f000000947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f44070ULL, 0x00001000090a7825ULL, 0x000fe200078e0004ULL,
0x00000001470f7812ULL, 0x000fe400078ec0ffULL, 0x00000020073b7810ULL, 0x000fe20007ffe0ffULL,
0x00000800470c7824ULL, 0x000fe200078e00ffULL, 0x000000410a0a7210ULL, 0x000fc80007f1e0ffULL,
0x000008000c0d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b0b7824ULL, 0x000fe400000e0643ULL,
0x000000020834a824ULL, 0x140fe200078e020fULL, 0x00000042090ea211ULL, 0x040fe200078038ffULL,
0x000000020836a824ULL, 0x000fe200078e020fULL, 0x000000460910a211ULL, 0x040fe200078238ffULL,
0x00000001160c7824ULL, 0x000fe200078e020dULL, 0x00000044090fa211ULL, 0x040fe200000f3cffULL,
0x000000083434a824ULL, 0x100fe200078e0207ULL, 0x000000480911a211ULL, 0x000fe200008f3cffULL,
0x000000083636a824ULL, 0x000fc400078e0207ULL, 0x0000001007357824ULL, 0x000fe200078e020cULL,
0x000045803437a811ULL, 0x000fe200078e20ffULL, 0x000000103b0c7825ULL, 0x000fe200078e000aULL,
0x000041803639a811ULL, 0x000fc600078e20ffULL, 0x00000010070a7825ULL, 0x000fc800078e000aULL,
0x00000010070ea825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a357faeULL, 0x0005e6000b901c46ULL, 0x000000100710a825ULL, 0x000fe200078e0010ULL,
0x003800000c357faeULL, 0x0005e8000b901c46ULL, 0x000000000e37afaeULL, 0x0005e8000b901c46ULL,
0x000000001039afaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff470a7810ULL, 0x004fe20007ffe0ffULL, 0x00000010070c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc40000011607ULL, 0x00000002ff3b7819ULL, 0x000fe20000011607ULL,
0x000000800a0b7824ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x000008000a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000083b347824ULL, 0x000fe200078e00ffULL, 0x000000800b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000083b107824ULL, 0x040fe200078e00ffULL, 0x000000083b3f7810ULL, 0x040fe20007ffe0ffULL,
0x000000083b367824ULL, 0x040fe200078e00ffULL, 0x000000013b0f7810ULL, 0x040fe20007ffe0ffULL,
0x00000100080b7824ULL, 0x000fe200078e020bULL, 0x000000033b117810ULL, 0x040fe20007ffe0ffULL,
0x000000083b3a7824ULL, 0x040fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20fULL,
0x000000083b397824ULL, 0x000fe200078e00ffULL, 0x0000000b0d0c7210ULL, 0x000fe20007ffe00cULL,
0x00000004070b7824ULL, 0x000fe200078e00ffULL, 0x000000023b0f7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000c0d7984ULL, 0x000ea20000000800ULL,
0x0000000c0b3d7812ULL, 0x000fe200078ec0ffULL, 0x000000083b457824ULL, 0x040fe200078e00ffULL,
0x000008000a0b7812ULL, 0x000fe200078ec0ffULL, 0x004580000c0e7984ULL, 0x0007220000000800ULL,
0xfffffff8340a7812ULL, 0x000fe200078ee23bULL, 0x000000083b4a7824ULL, 0x040fe200078e00ffULL,
0x00000180160b7810ULL, 0x000fe40007ffe00bULL, 0xfffffff834347812ULL, 0x000fe400078ee20fULL,
0x000000043b357810ULL, 0x000fe20007ffe0ffULL, 0x000000083f0c7824ULL, 0x008fe200078e00ffULL,
0x000000053b387810ULL, 0x000fe20007ffe0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e020bULL,
0x0000030047007a0cULL, 0x000fc40003f06070ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee23fULL,
0x000000013d0a7824ULL, 0x000fe200078e020aULL, 0x0000000109097810ULL, 0x000fe40007ffe0ffULL,
0x0000000147477810ULL, 0x000fe20007ffe0ffULL, 0x000000100c0c7824ULL, 0x100fe400078e020bULL,
0x000000000a0a7984ULL, 0x000fe40000000800ULL, 0x000000013d0f7824ULL, 0x000fe400078e020cULL,
0x00000010100c7824ULL, 0x000fe200078e020bULL, 0xfffffff836107812ULL, 0x000fc400078ee211ULL,
0x000000000f377984ULL, 0x0006620000000800ULL, 0x000000013d0c7824ULL, 0x000fe200078e020cULL,
0xfffffff83a367812ULL, 0x000fe400078ee235ULL, 0xfffffff8393a7812ULL, 0x000fe400078ee238ULL,
0x000400000c387984ULL, 0x000fe20000000800ULL, 0xffffffff3b357810ULL, 0x000fe20007ffe0ffULL,
0x00000010100f7824ULL, 0x008fe400078e020bULL, 0x0000000d060d7221ULL, 0x006fe20000010100ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee235ULL, 0x0000001036117824ULL, 0x000fc400078e020bULL,
0x3fb8aa3b0d0d7820ULL, 0x000fe40000410000ULL, 0x000000013d107824ULL, 0x040fe400078e020fULL,
0x000000013d117824ULL, 0x000fe400078e0211ULL, 0x0000000d000d7308ULL, 0x000f240000000800ULL,
0x0000000e0d3c7220ULL, 0x010fe40000410000ULL, 0x000000000c0d7984ULL, 0x000fe20000000800ULL,
0x00000010340e7824ULL, 0x000fe200078e020bULL, 0x000000063b347810ULL, 0x000fe20007ffe0ffULL,
0x000000333c337221ULL, 0x000fe20000010000ULL, 0x00001f3b3c3e7589ULL, 0x000e6200000e0000ULL,
0x000000013d0e7824ULL, 0x000fe200078e020eULL, 0xfffffff845367812ULL, 0x000fe200078ee234ULL,
0x000000103a347824ULL, 0x100fe200078e020bULL, 0x00001f3f3c407589ULL, 0x0004e600000e0000ULL,
0x0000001036357824ULL, 0x100fe200078e020bULL, 0x000000000e0f7984ULL, 0x000f220000000800ULL,
0x000000104a367824ULL, 0x000fc400078e020bULL, 0x000000013d347824ULL, 0x040fe200078e0234ULL,
0x00000000100c7984ULL, 0x000f220000000800ULL, 0x000000013d357824ULL, 0x040fe200078e0235ULL,
0x30000037ff3c7230ULL, 0x104fe20000004100ULL, 0x000000013d367824ULL, 0x000fe200078e0236ULL,
0x000400000e397984ULL, 0x000ea20000000800ULL, 0x2000000aff3d7230ULL, 0x100fe40000004100ULL,
0x3000000aff0a7230ULL, 0x000fe20000004100ULL, 0x00000000110b7984ULL, 0x000ea20000000800ULL,
0x20000037ff3f7230ULL, 0x000fc60000004100ULL, 0x00000000340e7984ULL, 0x000ea20000000800ULL,
0x0000003e0a317223ULL, 0x082fe40000010031ULL, 0x0000003e3d327223ULL, 0x000fe20000010032ULL,
0x00040000113b7984ULL, 0x000e620000000800ULL, 0x000000403c2f7223ULL, 0x088fe4000001002fULL,
0x000000403f307223ULL, 0x000fe20000010030ULL, 0x00000000350a7984ULL, 0x000ee20000000800ULL,
0x2000000dff377230ULL, 0x000fc60000004100ULL, 0x0004000035117984ULL, 0x000ee20000000800ULL,
0x3000000dff3c7230ULL, 0x000fe40000004100ULL, 0x20000038ff0d7230ULL, 0x100fe20000004100ULL,
0x00040000103a7984ULL, 0x000ee20000000800ULL, 0x30000038ff387230ULL, 0x000fe20000004100ULL,
0x0000003e372e7223ULL, 0x000fe4000001002eULL, 0x000000400d2c7223ULL, 0x080fe2000001002cULL,
0x0004000034107984ULL, 0x000ee20000000800ULL, 0x00000040382b7223ULL, 0x000fe2000001002bULL,
0x2000000fff377230ULL, 0x110fe20000004100ULL, 0x0000003e3c2d7223ULL, 0x000fe2000001002dULL,
0x00000000360d7984ULL, 0x000f220000000800ULL, 0x3000000fff387230ULL, 0x000fc40000004100ULL,
0x2000000cff0f7230ULL, 0x100fe20000004100ULL, 0x0004000036347984ULL, 0x0005220000000800ULL,
0x3000000cff0c7230ULL, 0x000fe20000004100ULL, 0x0000003e372a7223ULL, 0x080fe2000001002aULL,
0x20000039ff3d7230ULL, 0x104fe20000004100ULL, 0x0000003e0f267223ULL, 0x080fe20000010026ULL,
0x30000039ff3c7230ULL, 0x000fe20000004100ULL, 0x0000003e0c257223ULL, 0x080fe20000010025ULL,
0x2000000bff0f7230ULL, 0x100fe20000004100ULL, 0x0000003e38297223ULL, 0x000fe20000010029ULL,
0x3000000bff367230ULL, 0x000fe20000004100ULL, 0x000000403d287223ULL, 0x000fe20000010028ULL,
0x2000000eff0c7230ULL, 0x100fe20000004100ULL, 0x0000003e0f227223ULL, 0x080fe20000010022ULL,
0x3000000eff0b7230ULL, 0x000fe20000004100ULL, 0x0000003e36217223ULL, 0x080fe20000010021ULL,
0x2000003bff0f7230ULL, 0x102fe20000004100ULL, 0x0000003e0c177223ULL, 0x080fe20000010017ULL,
0x3000003bff367230ULL, 0x000fe20000004100ULL, 0x0000003e0b1e7223ULL, 0x000fe2000001001eULL,
0x2000000aff0c7230ULL, 0x108fe20000004100ULL, 0x000000400f207223ULL, 0x080fe20000010020ULL,
0x3000000aff0b7230ULL, 0x000fe20000004100ULL, 0x000000403c277223ULL, 0x080fe20000010027ULL,
0x20000011ff0a7230ULL, 0x100fe20000004100ULL, 0x00000040361f7223ULL, 0x000fe2000001001fULL,
0x30000011ff117230ULL, 0x000fe20000004100ULL, 0x0000003e0b1c7223ULL, 0x000fe2000001001cULL,
0x2000003aff357230ULL, 0x100fe20000004100ULL, 0x000000400a1b7223ULL, 0x000fe2000001001bULL,
0x3000003aff3a7230ULL, 0x000fe20000004100ULL, 0x0000003e0c137223ULL, 0x000fe20000010013ULL,
0x20000010ff0e7230ULL, 0x100fe20000004100ULL, 0x0000004035247223ULL, 0x080fe20000010024ULL,
0x30000010ff107230ULL, 0x000fe20000004100ULL, 0x000000403a237223ULL, 0x080fe20000010023ULL,
0x2000000dff0a7230ULL, 0x110fe20000004100ULL, 0x000000400e1d7223ULL, 0x080fe2000001001dULL,
0x3000000dff0d7230ULL, 0x000fe20000004100ULL, 0x0000004010157223ULL, 0x080fe20000010015ULL,
0x20000034ff0b7230ULL, 0x100fe20000004100ULL, 0x00000040111a7223ULL, 0x000fe2000001001aULL,
0x30000034ff0f7230ULL, 0x000fe20000004100ULL, 0x0000003e0a197223ULL, 0x000fc40000010019ULL,
0x0000003e0d187223ULL, 0x000fe40000010018ULL, 0x000000400b147223ULL, 0x080fe40000010014ULL,
0x000000400f127223ULL, 0x000fe20000010012ULL, 0xfffff46000008947ULL, 0x000fea000383ffffULL,
0x0180000033047810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0033ULL, 0x0000f07000067802ULL, 0x002fc40000000f00ULL,
0x0000b98000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003300047308ULL, 0x000ea40000001000ULL,
0xbf80000004057423ULL, 0x004fc80000000033ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000504047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff097819ULL, 0x004fc40000011607ULL, 0x00000008070b7811ULL, 0x040fe200078ff0ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x00000004090c7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0904057589ULL, 0x000ea200000e0000ULL, 0x0000000809337824ULL, 0x040fe200078e00ffULL,
0x0000000209087810ULL, 0x040fe20007ffe0ffULL, 0x00000008090f7824ULL, 0x040fe200078e00ffULL,
0x00001f0b04067589ULL, 0x0022e200000e0000ULL, 0x0000000809117824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee20cULL, 0x00000008090c7824ULL, 0x040fe200078e00ffULL,
0x00000003090a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000809357824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee208ULL, 0x0000000809377824ULL, 0x040fe200078e00ffULL,
0xfffffff80c0d7812ULL, 0x000fe200078ee209ULL, 0x0000000809397824ULL, 0x040fe200078e00ffULL,
0x0000000609087810ULL, 0x000fe20007ffe0ffULL, 0x000000080b0c7824ULL, 0x000fc400078e00ffULL,
0x000000100d0d7824ULL, 0x100fe400078e0202ULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0xfffffff80c0b7812ULL, 0x002fe200078ee20bULL, 0x0000001033337824ULL, 0x000fe400078e0202ULL,
0x0000003205327220ULL, 0x044fe40000410000ULL, 0x0000003105317220ULL, 0x040fe40000410000ULL,
0x0000002e052e7220ULL, 0x000fc40000410000ULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x000000323131723eULL, 0x000fe200000000ffULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x0000002e2d2d723eULL, 0x000fe200000000ffULL,
0x0000002605267220ULL, 0x040fe40000410000ULL, 0x0000002505257220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000002205227220ULL, 0x000fc40000410000ULL,
0x0000002105217220ULL, 0x000fe20000410000ULL, 0x000000262525723eULL, 0x000fe200000000ffULL,
0x0000001705177220ULL, 0x040fe40000410000ULL, 0x0000001e051e7220ULL, 0x000fe20000410000ULL,
0x000000222121723eULL, 0x000fe200000000ffULL, 0x0000001305137220ULL, 0x040fe40000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x000000171e17723eULL, 0x000fe200000000ffULL,
0x0000001905197220ULL, 0x000fc40000410000ULL, 0x0000001805187220ULL, 0x000fe20000410000ULL,
0x000000131c13723eULL, 0x000fe200000000ffULL, 0x0000003006307220ULL, 0x048fe40000410000ULL,
0x0000002f062f7220ULL, 0x000fe20000410000ULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x0000002c062c7220ULL, 0x040fe40000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000000ffULL, 0x0000002806287220ULL, 0x000fc40000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0000002406247220ULL, 0x040fe40000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000002006207220ULL, 0x040fe40000410000ULL,
0x0000001f061f7220ULL, 0x040fe20000410000ULL, 0x000000242323723eULL, 0x000fe200000000ffULL,
0x0000001d061d7220ULL, 0x000fc40000410000ULL, 0x0000001506047220ULL, 0x040fe20000410000ULL,
0x000000201f1f723eULL, 0x000fe200000000ffULL, 0x0000001b061b7220ULL, 0x040fe40000410000ULL,
0x0000001a061a7220ULL, 0x000fe20000410000ULL, 0x0000001d0404723eULL, 0x000fe200000000ffULL,
0x0000001406147220ULL, 0x040fe40000410000ULL, 0x0000001206057220ULL, 0x000fe20000410000ULL,
0x0000000109067810ULL, 0x040fe20007ffe0ffULL, 0x0000000809157824ULL, 0x000fe200078e00ffULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0xfffffff80f0f7812ULL, 0x000fc400078ee206ULL, 0x0000000509067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff815157812ULL, 0x000fe200078ee20aULL, 0x000000100f0f7824ULL, 0x000fe200078e0202ULL,
0xffffffff090a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff835097812ULL, 0x000fe200078ee206ULL,
0x0000001015157824ULL, 0x000fe200078e0202ULL, 0xfffffff837357812ULL, 0x000fe400078ee208ULL,
0xfffffff839377812ULL, 0x000fe200078ee20aULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x0000000c07067812ULL, 0x000fe200078ec0ffULL, 0x0000001035357824ULL, 0x100fe200078e0202ULL,
0x000000140505723eULL, 0x000fe200000000ffULL, 0x0000001037377824ULL, 0x000fc400078e0202ULL,
0x000000010d027824ULL, 0x000fe400078e0206ULL, 0x0000000106087824ULL, 0x040fe400078e020fULL,
0x00000001060a7824ULL, 0x040fe200078e0211ULL, 0x0000003102007388ULL, 0x0003e20000000800ULL,
0x00000001060c7824ULL, 0x040fe400078e0215ULL, 0x00000001060e7824ULL, 0x040fe200078e0233ULL,
0x0000002d08007388ULL, 0x0003e20000000800ULL, 0x0000000106097824ULL, 0x000fc400078e0209ULL,
0x0000000106357824ULL, 0x040fe200078e0235ULL, 0x000000290a007388ULL, 0x0003e20000000800ULL,
0x0000000106377824ULL, 0x040fe400078e0237ULL, 0x0000000106067824ULL, 0x000fe200078e020bULL,
0x000000250c007388ULL, 0x0003e80000000800ULL, 0x000000210e007388ULL, 0x0003e80000000800ULL,
0x0000001709007388ULL, 0x0003e80000000800ULL, 0x0000001335007388ULL, 0x0003e80000000800ULL,
0x0000001837007388ULL, 0x0003e80000000800ULL, 0x0000002f06007388ULL, 0x0003e80000000800ULL,
0x0004002b08007388ULL, 0x0003e80000000800ULL, 0x000400270a007388ULL, 0x0003e80000000800ULL,
0x000400230c007388ULL, 0x0003e80000000800ULL, 0x0004001f0e007388ULL, 0x0003e80000000800ULL,
0x0004000409007388ULL, 0x0003e80000000800ULL, 0x0004001a35007388ULL, 0x0003e80000000800ULL,
0x0004000537007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000077919ULL, 0x004ea20000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000067919ULL, 0x002e620000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020070d7810ULL, 0x004fc60007ffe0ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x00000003ff0c7819ULL, 0x000fe40000011607ULL,
0x00000003ff027819ULL, 0x000fe2000001160dULL, 0x00000008060f7824ULL, 0x00afe200078e00ffULL,
0x00000007070e7812ULL, 0x000fe200078ec0ffULL, 0x000000010c057824ULL, 0x000fe400078e0207ULL,
0x000000010d047824ULL, 0x000fe400078e0202ULL, 0x0000000806157824ULL, 0x000fe200078e00ffULL,
0x0000000705087812ULL, 0x000fc400078ec0ffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0ffffff808097812ULL, 0x000fe400078ef807ULL, 0x0ffffff804057812ULL, 0x000fe400078ef80dULL,
0xfffffff815027812ULL, 0x000fe200078ee202ULL, 0x0000001009087824ULL, 0x100fe400078e0200ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0xfffffff80f007812ULL, 0x000fc400078ee20cULL,
0x0000000402027c10ULL, 0x000fe2000ff3e0ffULL, 0x0120000008087984ULL, 0x000e620000000c00ULL,
0x00000004000c7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000070d007812ULL, 0x000fe200078ec0ffULL,
0x0120000005107984ULL, 0x0004e20000000c00ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005a0002067a11ULL, 0x000fe400078248ffULL, 0x1ffffff80e0d7812ULL, 0x000fe400078ef803ULL,
0x00005b0002077a11ULL, 0x000fe200008f4c07ULL, 0x000000ffff057224ULL, 0x004fe200000e06ffULL,
0x00005a000c047a11ULL, 0x000fc400078048ffULL, 0x1ffffff8000f7812ULL, 0x000fe400078ef803ULL,
0x00005b000c057a11ULL, 0x000fca00000f4c05ULL, 0x000000100d027825ULL, 0x000fc800078e0004ULL,
0x000000100f047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ffa27819ULL, 0x000fca0000011608ULL, 0x0000000207a27824ULL, 0x000fca00078e02a2ULL,
0x000000c3a200720cULL, 0x000fda0003f06070ULL, 0x00000002cb038824ULL, 0x000fc800078e00ffULL,
0x00006400030c8a24ULL, 0x000fe400078e02a2ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x000060000c0c8625ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060c038981ULL, 0x000ea2000c1e1900ULL, 0x0000000107027810ULL, 0x040fe20007ffe0ffULL,
0x0000004008c97824ULL, 0x000fe400078e00ffULL, 0x0000008012c77824ULL, 0x000fe200078e00ffULL,
0x000000050200720cULL, 0x000fe20003f06070ULL, 0x00000100070f7824ULL, 0x000fe200078e02c9ULL,
0x01c60000ff0a7f8cULL, 0x000e62000c80043fULL, 0x00000080c8c87824ULL, 0x000fc600078e00ffULL,
0x00000040c7097812ULL, 0x000fe200078ef80fULL, 0x000000c803027224ULL, 0x004fcc00078e02ffULL,
0x00000e8000008947ULL, 0x000fea0003800000ULL, 0x0000000f060c7217ULL, 0x002fe40007800000ULL,
0x00000003ff257819ULL, 0x100fe40000011600ULL, 0x0000007004277812ULL, 0x000fe200078ec0ffULL,
0x000000010c167824ULL, 0x000fe200078e0a0fULL, 0x00000004250f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001090d7824ULL, 0x000fe200078e0225ULL, 0x0000000825117810ULL, 0x000fe40007ffe0ffULL,
0x000000160f00720cULL, 0x0c0fe20003f06070ULL, 0x000000010f107824ULL, 0x100fe200078e0200ULL,
0x0000000d021c7210ULL, 0x040fe20007f3e0ffULL, 0x00000001090d7824ULL, 0x000fe200078e020fULL,
0x0000000c251f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f1d7824ULL, 0x000fe200078e00ffULL,
0x00000014252d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x0000000d020d7210ULL, 0x000fe20007f5e0ffULL, 0x0000000111127824ULL, 0x000fe200078e0200ULL,
0x00005e001c0e7a11ULL, 0x040fe200078248ffULL, 0x0000000109137824ULL, 0x000fe200078e022dULL,
0x0000001025297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x00005e000d157a11ULL, 0x000fe200078448ffULL, 0x0000000811237824ULL, 0x000fe200078e00ffULL,
0x00005f001c1c7a11ULL, 0x000fe200008f4c0fULL, 0x00000001090f7824ULL, 0x000fe200078e021fULL,
0x00005f000d1b7a11ULL, 0x000fe200010f4c0cULL, 0x00000001090d7824ULL, 0x000fe200078e0211ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL, 0x000000081f207824ULL, 0x000fe200078e00ffULL,
0x000000161100720cULL, 0x000fe20003f26070ULL, 0x0000000109117824ULL, 0x000fe200078e0229ULL,
0x0000000d020d7210ULL, 0x040fe20007f9e0ffULL, 0x00000001291e7824ULL, 0x040fe200078e0200ULL,
0x0000000f020f7210ULL, 0x040fe20007fbe0ffULL, 0x00000008292b7824ULL, 0x000fe200078e00ffULL,
0x0000001302137210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x00005e000d107a11ULL, 0x000fe200078848ffULL, 0x000000ffff1a7224ULL, 0x000fe200028e06ffULL,
0x00000018252f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x00005f000d177a11ULL, 0x000fe200020f4c0cULL, 0x00000001250c7824ULL, 0x000fe200078e0200ULL,
0x0000001102117210ULL, 0x000fe20007f5e0ffULL, 0x00000001090d7824ULL, 0x000fe200078e022fULL,
0x00005e000f197a11ULL, 0x000fc400078a48ffULL, 0x00005e0013147a11ULL, 0x000fe200078648ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005f000f1a7a11ULL, 0x000fe400028f4c1aULL,
0xfffffff823237812ULL, 0x000fe400078ee212ULL, 0x00005f0013227a11ULL, 0x000fe400018f4c22ULL,
0x000000070c0f7812ULL, 0x000fe400078ec0ffULL, 0x00005e0011127a11ULL, 0x000fc400078448ffULL,
0x0000000d02217210ULL, 0x000fe40007fde0ffULL, 0x0000000e270c7210ULL, 0x000fe40007f7e0ffULL,
0x00005f0011187a11ULL, 0x000fe200010f4c18ULL, 0x000000011f117824ULL, 0x040fe200078e0200ULL,
0x000000161f00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff0e7224ULL, 0x000fe200030e06ffULL,
0x000000162500720cULL, 0x000fe20003f46070ULL, 0x000000ffff0d7224ULL, 0x000fe200018e061cULL,
0x00005e00211f7a11ULL, 0x000fe200078648ffULL, 0x000000082d1c7824ULL, 0x000fe200078e00ffULL,
0x0000001c25317810ULL, 0x000fc40007ffe0ffULL, 0x0000200008047811ULL, 0x000fe400078e70ffULL,
0x0ffffff80f0f7812ULL, 0x000fe200078ef800ULL, 0x0000000831247824ULL, 0x000fe200078e00ffULL,
0x00005f0021217a11ULL, 0x000fe400018f4c0eULL, 0x00000015270e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000109157824ULL, 0x000fe200078e0231ULL, 0x000000162900720cULL, 0x000fe20003f86070ULL,
0x000000100f137824ULL, 0x000fe200078e0204ULL, 0xfffffff820297812ULL, 0x000fe200078ee211ULL,
0x000000ffff0f7224ULL, 0x000fe200018e061bULL, 0x0000001027107210ULL, 0x000fe20007f7e0ffULL,
0x000000012d1b7824ULL, 0x000fe200078e0200ULL, 0x0000001502207210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c137faeULL, 0x0003e2000d101c46ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21eULL, 0x000000ffff117224ULL, 0x000fe200018e0617ULL,
0x000000162f00720cULL, 0x080fe20003f66070ULL, 0x000000101d157824ULL, 0x100fe200078e0204ULL,
0x000000162d00720cULL, 0x080fe20003f46070ULL, 0x0000001023177824ULL, 0x000fe200078e0204ULL,
0xfffffff81c2d7812ULL, 0x000fe200078ee21bULL, 0x00000001311d7824ULL, 0x140fe200078e0200ULL,
0x000000000e157faeULL, 0x0005e2000c101c46ULL, 0x000000163100720cULL, 0x000fe20003f06070ULL,
0x000000012f0c7824ULL, 0x002fc400078e0200ULL, 0x0000000010177faeULL, 0x0003e2000c901c46ULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x0000001227127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x00005e00201e7a11ULL, 0x040fe400078c48ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee20cULL, 0x000000ffff137224ULL, 0x000fe200008e0618ULL,
0x00005f0020207a11ULL, 0x000fe200030f4c0dULL, 0x000000102b157824ULL, 0x004fe200078e0204ULL,
0x00000019270c7210ULL, 0x000fc40007fde0ffULL, 0x0000002025197810ULL, 0x000fe20007ffe0ffULL,
0x0000001029117824ULL, 0x002fe200078e0204ULL, 0x00000024250f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e061aULL, 0x000000161900720cULL, 0x080fe20003f26070ULL,
0x00000001091b7824ULL, 0x000fe200078e0219ULL, 0xfffffff824237812ULL, 0x000fe200078ee21dULL,
0x00000001190e7824ULL, 0x140fe200078e0200ULL, 0x000000000c117faeULL, 0x0003e2000e901c46ULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0x0000001b021b7210ULL, 0x000fe20007fde0ffULL,
0x0000000109177824ULL, 0x000fe200078e020fULL, 0x0000000012157faeULL, 0x0005e2000e101c46ULL,
0x000000160f00720cULL, 0x040fe20003f86070ULL, 0x000000010f107824ULL, 0x000fe200078e0200ULL,
0xfffffff8191d7812ULL, 0x000fe200078ee20eULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x00005e001b1a7a11ULL, 0x000fc400078c48ffULL, 0x00000014270e7210ULL, 0x000fe20007fbe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0204ULL, 0x00005f001b1c7a11ULL, 0x000fe200030f4c1cULL,
0x00000010231b7824ULL, 0x000fe200078e0204ULL, 0x0000001702187210ULL, 0x000fe20007fde0ffULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0x0000003825237810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200028e0622ULL, 0x0000001f270c7210ULL, 0x002fe20007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0x00005e0018147a11ULL, 0x000fc400078c48ffULL,
0xfffffff8171f7812ULL, 0x000fe200078ee210ULL, 0x000000102d177824ULL, 0x100fe200078e0204ULL,
0x00005f0018157a11ULL, 0x004fe200030f4c19ULL, 0x000000ffff0d7224ULL, 0x000fe200028e0621ULL,
0x0000003425217810ULL, 0x000fe20007ffe0ffULL, 0x000000102f197824ULL, 0x100fe200078e0204ULL,
0x000000000e177faeULL, 0x0003e2000d101c46ULL, 0x0000001e27107210ULL, 0x000fe20007f5e0ffULL,
0x000000101f1f7824ULL, 0x000fe400078e0204ULL, 0x000000000c197faeULL, 0x0005e2000d901c46ULL,
0x0000001a27127210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0620ULL,
0x0000001427147210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e061cULL,
0x00000000101b7faeULL, 0x0007e2000c101c46ULL, 0x0000002c25177810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x000000162100720cULL, 0x080fe20003f46070ULL,
0x00000000121d7faeULL, 0x0003e2000c901c46ULL, 0x00000028250d7810ULL, 0x044fe40007ffe0ffULL,
0x0000003025197810ULL, 0x000fe20007ffe0ffULL, 0x00000000141f7faeULL, 0x0005e2000e101c46ULL,
0x000000160d00720cULL, 0x080fe20003fa6070ULL, 0x00000001090f7824ULL, 0x000fe200078e020dULL,
0x000000161700720cULL, 0x080fe20003f86070ULL, 0x000000010d0c7824ULL, 0x100fe200078e0200ULL,
0x0000003c25257810ULL, 0x000fe20007ffe0ffULL, 0x000000080d117824ULL, 0x008fe200078e00ffULL,
0x0000000f020f7210ULL, 0x000fe20007f1e0ffULL, 0x00000001170d7824ULL, 0x000fe200078e0200ULL,
0x000000161900720cULL, 0x000fe20003f66070ULL, 0x0000000817127824ULL, 0x002fe200078e00ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0xfffffff811117812ULL, 0x000fe200078ee20cULL, 0x0000000109177824ULL, 0x000fe200078e0217ULL,
0xfffffff812137812ULL, 0x000fe200078ee20dULL, 0x0000000819157824ULL, 0x004fe200078e00ffULL,
0x00005f000f0d7a11ULL, 0x000fe200030f4c10ULL, 0x00000001210f7824ULL, 0x100fe200078e0200ULL,
0x0000000e270c7210ULL, 0x000fe20007fde0ffULL, 0x00000001190e7824ULL, 0x000fe200078e0200ULL,
0x000000162300720cULL, 0x080fe20003f26070ULL, 0x0000000109197824ULL, 0x000fe200078e0219ULL,
0x000000162500720cULL, 0x000fe20003f06070ULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x0000001702147210ULL, 0x000fe20007fde0ffULL, 0x0000000821167824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee20eULL, 0x0000001011117824ULL, 0x000fc400078e0204ULL,
0x000000ffff1d7224ULL, 0x000fe200030e06ffULL, 0x00005e0014127a11ULL, 0x000fe200078c48ffULL,
0x0000000109217824ULL, 0x000fe200078e0221ULL, 0xfffffff816177812ULL, 0x000fe200078ee20fULL,
0x0000000123107824ULL, 0x140fe200078e0200ULL, 0x00005f00140f7a11ULL, 0x000fe200030f4c1dULL,
0x00000008231b7824ULL, 0x000fe200078e00ffULL, 0x00000012270e7210ULL, 0x000fe20007fde0ffULL,
0x0000000125007824ULL, 0x000fe200078e0200ULL, 0x000000000c117faeULL, 0x0003e2000e901c46ULL,
0x0000002102217210ULL, 0x040fe20007fbe0ffULL, 0x0000001013137824ULL, 0x000fe200078e0204ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee210ULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x0000001902127210ULL, 0x000fe20007fde0ffULL, 0x0000000825197824ULL, 0x000fc400078e00ffULL,
0x0000000109237824ULL, 0x000fe200078e0223ULL, 0x000000000e137faeULL, 0x0005e2000e101c46ULL,
0x000000ffff1d7224ULL, 0x000fe200030e06ffULL, 0xfffffff819197812ULL, 0x000fe200078ee200ULL,
0x000000ffff007224ULL, 0x000fe200028e06ffULL, 0x00005e0021147a11ULL, 0x000fe200078a48ffULL,
0x0000000109097824ULL, 0x000fe200078e0225ULL, 0x00005e0012107a11ULL, 0x000fe200078c48ffULL,
0x0000001015157824ULL, 0x100fe200078e0204ULL, 0x0000002302237210ULL, 0x000fe20007f9e0ffULL,
0x0000001017177824ULL, 0x100fe200078e0204ULL, 0x00005f0012127a11ULL, 0x000fe200030f4c1dULL,
0x000000101b1b7824ULL, 0x100fe200078e0204ULL, 0x0000000902097210ULL, 0x000fe20007fde0ffULL,
0x0000001019197824ULL, 0x000fe200078e0204ULL, 0x00005f0021047a11ULL, 0x000fe200028f4c00ULL,
0x000000ffff027224ULL, 0x000fe200020e06ffULL, 0x00000010270c7210ULL, 0x002fe20007fbe0ffULL,
0x000000ffff007224ULL, 0x000fe200030e06ffULL, 0x00005e0023107a11ULL, 0x000fc600078848ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e0612ULL, 0x00000014270e7210ULL, 0x004fe40007fbe0ffULL,
0x00005e0009127a11ULL, 0x000fe400078c48ffULL, 0x00005f0023027a11ULL, 0x000fe200020f4c02ULL,
0x000000ffff0f7224ULL, 0x000fe200028e0604ULL, 0x0000001027107210ULL, 0x000fe20007f9e0ffULL,
0x000000000c157faeULL, 0x0003e2000d901c46ULL, 0x00005f0009007a11ULL, 0x000fe400030f4c00ULL,
0x0000001227127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0602ULL,
0x000000000e177faeULL, 0x0003e6000d101c46ULL, 0x000000ffff137224ULL, 0x000fe200028e0600ULL,
0x00000000101b7faeULL, 0x0003e8000c901c46ULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x0000000400157811ULL, 0x042fe400078fe8ffULL,
0x0000000c00197811ULL, 0x000fc400078fe8ffULL, 0x0000000800177811ULL, 0x040fe200078fe8ffULL,
0x00000001150c7824ULL, 0x140fe200078e0200ULL, 0x00000010001b7811ULL, 0x040fe200078fe8ffULL,
0x0000000815117824ULL, 0x000fe200078e00ffULL, 0x0000001c00217811ULL, 0x040fe200078fe8ffULL,
0x00000001190e7824ULL, 0x040fe200078e0200ULL, 0x00000014001d7811ULL, 0x040fe200078fe8ffULL,
0x0000000819137824ULL, 0x000fe200078e00ffULL, 0xfffffff811267812ULL, 0x000fe200078ee20cULL,
0x00000001170d7824ULL, 0x040fe200078e0200ULL, 0x00000020000c7811ULL, 0x040fe200078fe8ffULL,
0x0000000817287824ULL, 0x000fe200078e00ffULL, 0xfffffff8132a7812ULL, 0x000fe200078ee20eULL,
0x000000011b0f7824ULL, 0x140fe200078e0200ULL, 0x00000018001f7811ULL, 0x000fe200078fe8ffULL,
0x000000081b2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20dULL,
0x0000000121107824ULL, 0x140fe200078e0200ULL, 0x0000002800147811ULL, 0x000fe200078fe8ffULL,
0x0000000821137824ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x000000011d0e7824ULL, 0x040fe200078e0200ULL, 0x00000030001c7811ULL, 0x000fe200078fe8ffULL,
0x000000081d117824ULL, 0x000fe200078e00ffULL, 0xfffffff8134a7812ULL, 0x000fe200078ee210ULL,
0x000000010c0d7824ULL, 0x000fe200078e0200ULL, 0x0000002400107811ULL, 0x000fe200078fe8ffULL,
0x000000080c127824ULL, 0x000fe200078e00ffULL, 0xfffffff811307812ULL, 0x000fe200078ee20eULL,
0x000000011f0f7824ULL, 0x140fe200078e0200ULL, 0x0000002c00187811ULL, 0x000fe200078fe8ffULL,
0x000000081f327824ULL, 0x000fe200078e00ffULL, 0xfffffff8120e7812ULL, 0x000fe200078ee20dULL,
0x00000001100d7824ULL, 0x100fe200078e0200ULL, 0x0000003400207811ULL, 0x000fe200078fe8ffULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee20fULL,
0x00000001140f7824ULL, 0x100fe200078e0200ULL, 0x0000003800227811ULL, 0x000fe200078fe8ffULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee20dULL,
0x000000011c137824ULL, 0x100fe200078e0200ULL, 0x00000009000d7211ULL, 0x000fe200078fe8ffULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee20fULL,
0x0000000118117824ULL, 0x000fe200078e0200ULL, 0x00000000000f7211ULL, 0x000fe200078fe8ffULL,
0x00000008181a7824ULL, 0x000fe200078e00ffULL, 0x0000000d02497210ULL, 0x000fe20007f1e0ffULL,
0x00000001150d7824ULL, 0x100fe200078e0209ULL, 0x000000070f297812ULL, 0x000fe200078ec0ffULL,
0x00000001170f7824ULL, 0x000fe200078e0209ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee213ULL,
0x000000011f177824ULL, 0x000fe200078e0209ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL,
0x00000001091f7824ULL, 0x000fe200078e0214ULL, 0x0000000f020f7210ULL, 0x000fe20007f3e0ffULL,
0x000000011b137824ULL, 0x100fe200078e0209ULL, 0x0000003c00247811ULL, 0x000fe200078fe8ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00005e0049487a11ULL, 0x000fe200078048ffULL,
0x0000000119117824ULL, 0x100fe200078e0209ULL, 0x0000001302137210ULL, 0x040fe20007f7e0ffULL,
0x00000001091b7824ULL, 0x000fe200078e020cULL, 0x00005f0049497a11ULL, 0x000fe200000f4c14ULL,
0x0000000109237824ULL, 0x040fe200078e021cULL, 0x0000000d020d7210ULL, 0x040fe20007f1e0ffULL,
0x0000000109257824ULL, 0x000fe200078e0220ULL, 0x0000001102117210ULL, 0x000fe20007f5e0ffULL,
0x00000001200c7824ULL, 0x140fe200078e0200ULL, 0x0ffffff829297812ULL, 0x000fe200078ef800ULL,
0x00000008202b7824ULL, 0x000fe200078e00ffULL, 0x0000200008417811ULL, 0x000fe200078e70ffULL,
0x000000ffff407224ULL, 0x000fe200018e06ffULL, 0x00005e0013147a11ULL, 0x000fe200078648ffULL,
0x0000000121197824ULL, 0x100fe200078e0209ULL, 0xfffffff82b0c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff207224ULL, 0x000fe200000e06ffULL, 0x00005e000d467a11ULL, 0x000fe200078048ffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x00005e000f447a11ULL, 0x000fe200078248ffULL,
0x000000011d157824ULL, 0x000fe200078e0209ULL, 0x00005f0013407a11ULL, 0x000fe200018f4c40ULL,
0x0000000109217824ULL, 0x000fe200078e0218ULL, 0x00005f000d477a11ULL, 0x000fe200000f4c20ULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005e0011427a11ULL, 0x000fe200078448ffULL,
0x00000001091d7824ULL, 0x000fe200078e0210ULL, 0x00005f000f457a11ULL, 0x000fe200008f4c1cULL,
0x0000000122107824ULL, 0x100fe200078e0200ULL, 0x0000001b021b7210ULL, 0x000fe20007f7e0ffULL,
0x00000008222d7824ULL, 0x000fe200078e00ffULL, 0x0000001502157210ULL, 0x000fe20007f1e0ffULL,
0x0000000124007824ULL, 0x000fe200078e0200ULL, 0x0000001702177210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x00005f0011437a11ULL, 0x000fe200010f4c18ULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x0000001902197210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x00005e001b1c7a11ULL, 0x000fe200078648ffULL,
0x00000008242f7824ULL, 0x000fe200078e00ffULL, 0x00005e00153c7a11ULL, 0x000fe200078048ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x00005e0017187a11ULL, 0x000fe200078248ffULL,
0x0000000109277824ULL, 0x000fe200078e0222ULL, 0x00005e0019137a11ULL, 0x000fe200078448ffULL,
0x0000000109097824ULL, 0x000fe200078e0224ULL, 0x00005f001b367a11ULL, 0x000fe200018f4c36ULL,
0x000000102e2b7824ULL, 0x100fe200078e0241ULL, 0x00005f00153e7a11ULL, 0x000fe200000f4c3eULL,
0x000000104a317824ULL, 0x100fe200078e0241ULL, 0x00005f00173a7a11ULL, 0x000fe200008f4c3aULL,
0x000000100e337824ULL, 0x100fe200078e0241ULL, 0x0000001d021d7210ULL, 0x000fe20007f7e0ffULL,
0x0000001012357824ULL, 0x100fe200078e0241ULL, 0x0000002102217210ULL, 0x000fe20007f1e0ffULL,
0x0000001016377824ULL, 0x100fe200078e0241ULL, 0x0000002302237210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff347224ULL, 0x000fe200018e06ffULL, 0x00005f0019387a11ULL, 0x000fe200010f4c38ULL,
0x000000101a397824ULL, 0x100fe200078e0241ULL, 0x0000001f021f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0xfffffff82d107812ULL, 0x000fe200078ee210ULL,
0x00000010302d7824ULL, 0x100fe200078e0241ULL, 0xfffffff82f007812ULL, 0x000fe200078ee200ULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x00000025022c7210ULL, 0x000fe20007f7e0ffULL,
0x00000010322f7824ULL, 0x100fe200078e0241ULL, 0x00000027020f7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005e0021227a11ULL, 0x000fe200078048ffULL,
0x0000001026257824ULL, 0x100fe200078e0241ULL, 0x00005e0023247a11ULL, 0x000fe200078248ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x0000000902027210ULL, 0x000fe20007fbe0ffULL,
0x0000001029097824ULL, 0x100fe200078e0241ULL, 0x00005e001f207a11ULL, 0x000fe200078448ffULL,
0x0000001028277824ULL, 0x100fe200078e0241ULL, 0x00005f0021307a11ULL, 0x000fe200000f4c30ULL,
0x000000102a297824ULL, 0x100fe200078e0241ULL, 0x00005f00232e7a11ULL, 0x000fe200008f4c2eULL,
0x000000ffff0d7224ULL, 0x000fe200028e06ffULL, 0x0000007004217812ULL, 0x000fe200078ec0ffULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x00005e002c267a11ULL, 0x000fe200078248ffULL,
0x000000101e3b7824ULL, 0x100fe200078e0241ULL, 0x00005f001f327a11ULL, 0x000fe200010f4c32ULL,
0x000000100c3d7824ULL, 0x100fe200078e0241ULL, 0x00005e000f287a11ULL, 0x000fe200078448ffULL,
0x00000010103f7824ULL, 0x100fe200078e0241ULL, 0x00005e00022a7a11ULL, 0x000fe200078648ffULL,
0x0000001000417824ULL, 0x000fe200078e0241ULL, 0x00005f002c2c7a11ULL, 0x000fc400008f4c11ULL,
0x00000048210c7210ULL, 0x040fe40007f1e0ffULL, 0x00000046210e7210ULL, 0x000fe40007f3e0ffULL,
0x00005f000f047a11ULL, 0x000fe400010f4c04ULL, 0x00005f0002007a11ULL, 0x000fe200018f4c0dULL,
0x000000ffff0d7224ULL, 0x000fe200000e0649ULL, 0x0000004421107210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e0647ULL, 0x0000004221127210ULL, 0x000fc40007f7e0ffULL,
0x00005e001d157a11ULL, 0x000fe200078c48ffULL, 0x000000ffff117224ULL, 0x000fe200010e0645ULL,
0x0000001421147210ULL, 0x040fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c097faeULL, 0x0003e2000b901c46ULL, 0x0000003c21167210ULL, 0x040fe40007f9e0ffULL,
0x0000001821187210ULL, 0x040fe20007f1e0ffULL, 0x000000000e257faeULL, 0x0005e2000b901c46ULL,
0x00000013211a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0643ULL,
0x00005f001d347a11ULL, 0x000fe200030f4c34ULL, 0x000000ffff177224ULL, 0x000fe200020e063eULL,
0x0000001c211c7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe200000e063aULL,
0x00000015211e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0640ULL,
0x0000002021207210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e0638ULL,
0x0000002221227210ULL, 0x040fe20007f9e0ffULL, 0x0000000010277faeULL, 0x0007e2000b901c46ULL,
0x0000002421247210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e0636ULL,
0x0000002621267210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e0634ULL,
0x0000000012297faeULL, 0x0009e2000b901c46ULL, 0x0000002821287210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x000fe200020e0630ULL, 0x0000002a212a7210ULL, 0x000fe20007f7e0ffULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff217224ULL, 0x000fc400028e0632ULL,
0x000000ffff257224ULL, 0x004fe200000e062eULL, 0x00000000162d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff277224ULL, 0x008fc600008e062cULL, 0x00000000182f7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff297224ULL, 0x010fc600010e0604ULL, 0x000000001a317faeULL, 0x0005e2000b901c46ULL,
0x000000ffff2b7224ULL, 0x002fc600018e0600ULL, 0x000000001c337faeULL, 0x0005e8000b901c46ULL,
0x000000001e357faeULL, 0x0005e8000b901c46ULL, 0x0000000020377faeULL, 0x0005e8000b901c46ULL,
0x0000000022397faeULL, 0x0005e8000b901c46ULL, 0x00000000243b7faeULL, 0x0005e8000b901c46ULL,
0x00000000263d7faeULL, 0x0005e8000b901c46ULL, 0x00000000283f7faeULL, 0x0005e8000b901c46ULL,
0x000000002a417faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000c7805ULL, 0x002fc40000015200ULL, 0x01c60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c097210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e0dULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140eULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e060eULL, 0x0000000200007819ULL, 0x000fc80000001209ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000102027810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01c60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000050700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000a17919ULL, 0x000e620000000000ULL,
0x00006400cbcb7a24ULL, 0x000fe200078e02ffULL, 0x0001c68808c57811ULL, 0x040fe200078e18ffULL,
0x0000002008c67824ULL, 0x000fe200078e00ffULL, 0xffffffff05ca7810ULL, 0x000fc40007ffe0ffULL,
0x0000010007047824ULL, 0x000fe200078e02c9ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000040600720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x0000000107007810ULL, 0x000fe20007ffe0ffULL, 0x00000003c81c7224ULL, 0x004fc600078e02ffULL,
0x000000050000720cULL, 0x000fe40003f06070ULL, 0x0000004004007812ULL, 0x000fca00078ec0ffULL,
0x00000001c71d7824ULL, 0x000fcc00078e0200ULL, 0x00000d8000008947ULL, 0x000fea0003800000ULL,
0x00000003ff2c7819ULL, 0x002fe200000116a1ULL, 0x0000000106007824ULL, 0x000fe200078e0a04ULL,
0x0ffffff8a1907812ULL, 0x000fe400078ec0ffULL, 0x000000042c027810ULL, 0x040fe20007ffe0ffULL,
0x000000012c037824ULL, 0x040fe200078e021dULL, 0x000000082c2a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c2c2e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102097824ULL, 0x000fe200078e02a1ULL,
0x000000031c037210ULL, 0x000fe20007f9e0ffULL, 0x00000008020a7824ULL, 0x000fe200078e00ffULL,
0x000000102c307810ULL, 0x000fe20007ffe0ffULL, 0x000000012a0b7824ULL, 0x000fe200078e021dULL,
0x000000000200720cULL, 0x000fe20003f26070ULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0xfffffff80a2b7812ULL, 0x000fe200078ee209ULL, 0x0000000102097824ULL, 0x100fe200078e021dULL,
0x00005e0003167a11ULL, 0x040fe200078848ffULL, 0x000000012e0d7824ULL, 0x000fe200078e021dULL,
0x0000000b1c0b7210ULL, 0x000fe20007f5e0ffULL, 0x000000012e297824ULL, 0x000fe200078e02a1ULL,
0x00005f0003177a11ULL, 0x000fe200020f4c0eULL, 0x0000000130037824ULL, 0x000fe200078e021dULL,
0x000000091c097210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x0000000d1c0d7210ULL, 0x000fe20007f7e0ffULL, 0x000000082a2d7824ULL, 0x000fe200078e00ffULL,
0x000000031c037210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200028e06ffULL,
0x00005e0009187a11ULL, 0x000fe200078a48ffULL, 0x000000ffff027224ULL, 0x000fe200018e06ffULL,
0x00005e000b1a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x000000142c327810ULL, 0x000fe20007ffe0ffULL, 0x0000000830317824ULL, 0x000fe200078e00ffULL,
0x000000182c347810ULL, 0x000fc40007ffe0ffULL, 0x00005e000d1e7a11ULL, 0x000fe200078648ffULL,
0x0000000832337824ULL, 0x000fe200078e00ffULL, 0x0000001c2c367810ULL, 0x000fe20007ffe0ffULL,
0x0000000834357824ULL, 0x000fe200078e00ffULL, 0x00005f0009197a11ULL, 0x000fe200028f4c0cULL,
0x0000000132097824ULL, 0x100fe200078e021dULL, 0x00005f000b1b7a11ULL, 0x000fe200010f4c0aULL,
0x00000001340b7824ULL, 0x100fe200078e021dULL, 0x00005f000d1f7a11ULL, 0x000fe200018f4c02ULL,
0x00000001360d7824ULL, 0x000fe200078e021dULL, 0x00005e0003207a11ULL, 0x000fc400078848ffULL,
0x000000202c387810ULL, 0x000fe40007ffe0ffULL, 0x00005f0003217a11ULL, 0x000fe400020f4c12ULL,
0x000000091c097210ULL, 0x000fe20007fbe0ffULL, 0x0000000138037824ULL, 0x000fe200078e021dULL,
0x0000000b1c0b7210ULL, 0x040fe40007f5e0ffULL, 0x0000000d1c0d7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200028e06ffULL, 0x000000031c137210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x00005e0009147a11ULL, 0x000fe200078a48ffULL,
0x000000ffff027224ULL, 0x000fe200018e06ffULL, 0x00005e000b107a11ULL, 0x000fe200078448ffULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x000000242c3a7810ULL, 0x000fc40007ffe0ffULL,
0x000000282c3c7810ULL, 0x040fe40007ffe0ffULL, 0x00005e000d0e7a11ULL, 0x000fe400078648ffULL,
0x0000002c2c3e7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0009157a11ULL, 0x000fe200028f4c0cULL,
0x000000013a097824ULL, 0x100fe200078e021dULL, 0x00005f000b117a11ULL, 0x000fe200010f4c0aULL,
0x000000013c0b7824ULL, 0x100fe200078e021dULL, 0x00005f000d0f7a11ULL, 0x000fe200018f4c02ULL,
0x000000013e0d7824ULL, 0x000fe200078e021dULL, 0x00005e0013227a11ULL, 0x000fc400078848ffULL,
0x000000091c097210ULL, 0x000fe40007fbe0ffULL, 0x00005f0013237a11ULL, 0x000fe200020f4c28ULL,
0x000000012c137824ULL, 0x100fe200078e02a1ULL, 0x0000000b1c0b7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x0000000d1c027210ULL, 0x000fe20007f7e0ffULL,
0x000000012a287824ULL, 0x000fe200078e02a1ULL, 0x000000302c407810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000000790277812ULL, 0x000fe200078ef813ULL,
0x000000ffff037224ULL, 0x000fe200018e06ffULL, 0x00005e0009247a11ULL, 0x000fe200078a48ffULL,
0x0000000140137824ULL, 0x000fe200078e021dULL, 0x00005e000b0c7a11ULL, 0x000fc400078448ffULL,
0x00005e00020a7a11ULL, 0x000fe400078648ffULL, 0x00005f0009257a11ULL, 0x000fe400028f4c26ULL,
0x00005f000b0d7a11ULL, 0x000fe400010f4c12ULL, 0x000000002e00720cULL, 0x040fe20003f86070ULL,
0x000000082e2e7824ULL, 0x000fe200078e00ffULL, 0x00005f00020b7a11ULL, 0x000fe400018f4c03ULL,
0x000000131c137210ULL, 0x000fc40007fbe0ffULL, 0x00000007a1037812ULL, 0x000fe400078ec0ffULL,
0x000000342c427810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200028e06ffULL,
0x000000002c00720cULL, 0x080fe40003f46070ULL, 0x0000400008027811ULL, 0x000fe400078e70ffULL,
0x0000000803097812ULL, 0x000fe400078efcffULL, 0xfffffff82e2f7812ULL, 0x000fe200078ee229ULL,
0x0000000142297824ULL, 0x000fe200078e021dULL, 0x00005e0013127a11ULL, 0x000fe200078a48ffULL,
0x0000001027277824ULL, 0x000fe200078e0202ULL, 0x000000002a00720cULL, 0x000fe20003f66070ULL,
0x0000001009167825ULL, 0x000fe200078e0016ULL, 0x00005f0013137a11ULL, 0x000fc400028f4c26ULL,
0x000000003000720cULL, 0x040fe20003fa6070ULL, 0x00000001302a7824ULL, 0x100fe200078e02a1ULL,
0x000000291c297210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016277faeULL, 0x0003e2000d101c46ULL, 0x000000382c307810ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0202ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee228ULL,
0x000000ffff287224ULL, 0x000fe200030e06ffULL, 0x00005e0029267a11ULL, 0x000fe200078c48ffULL,
0x00000001322e7824ULL, 0x000fe200078e02a1ULL, 0x0000003c2c2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0202ULL, 0xfffffff831317812ULL, 0x000fe200078ee22aULL,
0x000000102f2f7824ULL, 0x000fe200078e0202ULL, 0xfffffff833337812ULL, 0x000fe200078ee22eULL,
0x0000001009167825ULL, 0x002fe200078e0018ULL, 0x00005f0029277a11ULL, 0x000fc400030f4c28ULL,
0x000000003200720cULL, 0x080fe20003f46070ULL, 0x0000000130197824ULL, 0x000fe200078e021dULL,
0x00000000162b7faeULL, 0x0003e2000c901c46ULL, 0x00000001342e7824ULL, 0x040fe200078e02a1ULL,
0x000000003400720cULL, 0x000fe20003f26070ULL, 0x0000001031317824ULL, 0x000fe200078e0202ULL,
0x000000191c297210ULL, 0x000fe20007fde0ffULL, 0x0000001009187825ULL, 0x000fc800078e001eULL,
0x000000ffff2a7224ULL, 0x000fe200030e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078c48ffULL,
0x000000012c1f7824ULL, 0x000fe400078e021dULL, 0x0000001009167825ULL, 0x002fe200078e001aULL,
0x00005f0029297a11ULL, 0x000fe400030f4c2aULL, 0x0000001f1c1f7210ULL, 0x000fe20007fde0ffULL,
0x00000010091a7825ULL, 0x000fe200078e0020ULL, 0x00000000162d7faeULL, 0x0003e2000d901c46ULL,
0x000000003a00720cULL, 0x000fc40003f66070ULL, 0xfffffff835217812ULL, 0x000fe200078ee22eULL,
0x00000000182f7faeULL, 0x0005e2000e101c46ULL, 0x00000001361e7824ULL, 0x100fe200078e02a1ULL,
0x000000003800720cULL, 0x080fe20003f86070ULL, 0x00000008362b7824ULL, 0x000fe200078e00ffULL,
0x000000001a317faeULL, 0x0007e2000e901c46ULL, 0x0000000138207824ULL, 0x100fe200078e02a1ULL,
0x000000003600720cULL, 0x000fe20003fa6070ULL, 0x0000000838357824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21eULL, 0x000000013a177824ULL, 0x002fc400078e02a1ULL,
0x000000083a3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8352d7812ULL, 0x000fe200078ee220ULL,
0x000000ffff167224ULL, 0x000fe400030e06ffULL, 0x0000001009147825ULL, 0x000fe200078e0014ULL,
0x00005e001f1a7a11ULL, 0x008fe400078c48ffULL, 0xfffffff83a177812ULL, 0x000fe200078ee217ULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x00005f001f1b7a11ULL, 0x000fe200030f4c16ULL,
0x00000010331f7824ULL, 0x000fe200078e0202ULL, 0x000000002c00720cULL, 0x000fe20003fc6070ULL,
0x0000001009107825ULL, 0x000fc600078e0010ULL, 0x00000000141f7faeULL, 0x0003e2000d101c46ULL,
0x000000102b2b7824ULL, 0x100fe200078e0202ULL, 0x000000003e00720cULL, 0x080fe20003f46070ULL,
0x00000010172f7824ULL, 0x004fe200078e0202ULL, 0x0000000010217faeULL, 0x0005e2000c901c46ULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x000000003c00720cULL, 0x000fc60003f26070ULL,
0x000000102d2d7824ULL, 0x000fe200078e0202ULL, 0x000000000e2b7faeULL, 0x0007e2000e901c46ULL,
0x0000001009167825ULL, 0x000fe200078e0022ULL, 0x000000003000720cULL, 0x000fc60003fa6070ULL,
0x0000001009187825ULL, 0x000fe200078e0024ULL, 0x00000000162d7faeULL, 0x0009e2000e101c46ULL,
0x000000004200720cULL, 0x080fe40003f86070ULL, 0x000000013e207824ULL, 0x140fe200078e02a1ULL,
0x00000000182f7faeULL, 0x0005e2000d901c46ULL, 0x000000083e257824ULL, 0x000fe200078e00ffULL,
0x000000004000720cULL, 0x000fe20003f66070ULL, 0x000000013c1e7824ULL, 0x040fe400078e02a1ULL,
0x000000083c237824ULL, 0x000fc400078e00ffULL, 0x00000001300f7824ULL, 0x108fe400078e02a1ULL,
0x0000000140007824ULL, 0x140fe200078e02a1ULL, 0xfffffff823177812ULL, 0x010fe200078ee21eULL,
0x00000008401f7824ULL, 0x002fe200078e00ffULL, 0xfffffff825197812ULL, 0x004fe200078ee220ULL,
0x0000000830307824ULL, 0x000fe400078e00ffULL, 0x00000001420e7824ULL, 0x040fe200078e02a1ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL, 0x0000000842217824ULL, 0x000fe200078e00ffULL,
0xfffffff8300f7812ULL, 0x000fe200078ee20fULL, 0x000000012c107824ULL, 0x000fc400078e02a1ULL,
0x000000082c257824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20eULL,
0x0000001017177824ULL, 0x000fe400078e0202ULL, 0x00000010090c7825ULL, 0x000fe200078e000cULL,
0xfffffff825257812ULL, 0x000fc600078ee210ULL, 0x0000001019197824ULL, 0x000fe200078e0202ULL,
0x000000000c177faeULL, 0x0003e2000c901c46ULL, 0x00000010090a7825ULL, 0x000fc800078e000aULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x000000000a197faeULL, 0x0003e2000d101c46ULL,
0x000000100f237824ULL, 0x000fe400078e0202ULL, 0x0000001009127825ULL, 0x000fc800078e0012ULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x00000000121f7faeULL, 0x0003e2000d901c46ULL,
0x00000010090e7825ULL, 0x000fc800078e0026ULL, 0x0000001009107825ULL, 0x000fe200078e0028ULL,
0x000000000e217faeULL, 0x0003e6000e101c46ULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x0000000010237faeULL, 0x0003e2000e901c46ULL, 0x0000001009147825ULL, 0x000fca00078e001aULL,
0x0000000014257faeULL, 0x0003e2000f101c46ULL, 0x00000c5000007947ULL, 0x000fea0003800000ULL,
0x00000008a10c7811ULL, 0x042fe400078fe8ffULL, 0x00000004a1027811ULL, 0x040fe400078fe8ffULL,
0x0000000ca10e7811ULL, 0x040fe200078fe8ffULL, 0x000000010c037824ULL, 0x140fe200078e02a1ULL,
0x00000014a1187811ULL, 0x040fe200078fe8ffULL, 0x000000080c0a7824ULL, 0x000fe200078e00ffULL,
0x00000010a1167811ULL, 0x040fe200078fe8ffULL, 0x0000000102007824ULL, 0x040fe200078e02a1ULL,
0x00000018a11a7811ULL, 0x040fe200078fe8ffULL, 0x00000008022d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a2f7812ULL, 0x000fe200078ee203ULL, 0x000000010e097824ULL, 0x140fe200078e02a1ULL,
0x00000020a1207811ULL, 0x000fe200078fe8ffULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee200ULL, 0x0000000118037824ULL, 0x040fe200078e02a1ULL,
0x0000001ca11e7811ULL, 0x040fe200078fe8ffULL, 0x00000008180a7824ULL, 0x000fe200078e00ffULL,
0xfffffff810317812ULL, 0x000fe200078ee209ULL, 0x0000000116007824ULL, 0x040fe200078e02a1ULL,
0x00000024a1227811ULL, 0x040fe200078fe8ffULL, 0x0000000816337824ULL, 0x000fe200078e00ffULL,
0xfffffff80a357812ULL, 0x000fe200078ee203ULL, 0x000000011a097824ULL, 0x140fe200078e02a1ULL,
0x0000002ca1267811ULL, 0x000fe200078fe8ffULL, 0x000000081a107824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee200ULL, 0x0000000120037824ULL, 0x040fe200078e02a1ULL,
0x00000028a1247811ULL, 0x040fe200078fe8ffULL, 0x00000008200a7824ULL, 0x000fe200078e00ffULL,
0xfffffff810377812ULL, 0x000fe200078ee209ULL, 0x000000011e007824ULL, 0x040fe200078e02a1ULL,
0x00000030a1287811ULL, 0x040fe200078fe8ffULL, 0x000000081e397824ULL, 0x000fe200078e00ffULL,
0xfffffff80a3b7812ULL, 0x000fe200078ee203ULL, 0x0000000122097824ULL, 0x140fe200078e02a1ULL,
0x00000034a12a7811ULL, 0x000fe200078fe8ffULL, 0x0000000822107824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee200ULL, 0x0000000126037824ULL, 0x040fe200078e02a1ULL,
0x00000038a12c7811ULL, 0x040fe200078fe8ffULL, 0x00000008260a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8103d7812ULL, 0x000fe200078ee209ULL, 0x0000000124007824ULL, 0x040fe200078e02a1ULL,
0x0000003ca12e7811ULL, 0x040fe200078fe8ffULL, 0x00000008243f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a417812ULL, 0x000fe200078ee203ULL, 0x0000000128097824ULL, 0x140fe200078e02a1ULL,
0x0000001da1037211ULL, 0x000fe200078fe8ffULL, 0x0000000828107824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee200ULL, 0x000000012a007824ULL, 0x000fe200078e02a1ULL,
0x000000031c037210ULL, 0x000fe20007f3e0ffULL, 0x000000082a457824ULL, 0x000fe200078e00ffULL,
0xfffffff810437812ULL, 0x000fe200078ee209ULL, 0x000000012c097824ULL, 0x140fe200078e02a1ULL,
0x0ffffff8a1907812ULL, 0x000fe200078ec0ffULL, 0x000000082c0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee200ULL, 0x000000012e0b7824ULL, 0x000fe200078e02a1ULL,
0x0000400008147811ULL, 0x000fe200078e70ffULL, 0x000000082e107824ULL, 0x000fe200078e00ffULL,
0xfffffff80a477812ULL, 0x000fe200078ee209ULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e00030a7a11ULL, 0x040fe200078248ffULL, 0x000000010e0f7824ULL, 0x000fe200078e021dULL,
0xfffffff810497812ULL, 0x000fe200078ee20bULL, 0x000000010c0d7824ULL, 0x100fe200078e021dULL,
0x00005f00030b7a11ULL, 0x000fe200008f4c00ULL, 0x0000000102037824ULL, 0x100fe200078e021dULL,
0x0000000f1c007210ULL, 0x000fe20007f7e0ffULL, 0x0000000118137824ULL, 0x100fe200078e021dULL,
0x0000000d1c027210ULL, 0x000fe20007f5e0ffULL, 0x000000011e177824ULL, 0x100fe200078e021dULL,
0x000000031c117210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff037224ULL, 0x000fe200018e06ffULL,
0x00005e0000107a11ULL, 0x000fe200078648ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x00005e00020e7a11ULL, 0x000fe200078448ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00005e00110c7a11ULL, 0x000fe200078248ffULL, 0x000000011a157824ULL, 0x000fe200078e021dULL,
0x000000a1a1097211ULL, 0x000fe200078fe8ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0214ULL,
0x00005f00110d7a11ULL, 0x000fe200008f4c12ULL, 0x000000102f2f7824ULL, 0x100fe200078e0214ULL,
0x00005f0000117a11ULL, 0x000fe200018f4c03ULL, 0x0000000116037824ULL, 0x000fe200078e021dULL,
0x00005f00020f7a11ULL, 0x000fe200010f4c0fULL, 0x0000001031317824ULL, 0x100fe200078e0214ULL,
0x0000000790097812ULL, 0x000fe200078ef809ULL, 0x0000001033337824ULL, 0x100fe200078e0214ULL,
0x000000031c1b7210ULL, 0x040fe20007f5e0ffULL, 0x0000001035357824ULL, 0x100fe200078e0214ULL,
0x000000131c197210ULL, 0x040fe20007f7e0ffULL, 0x0000001009097824ULL, 0x100fe200078e0214ULL,
0x000000171c007210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200010e06ffULL,
0x00005e001b127a11ULL, 0x000fe200078448ffULL, 0x0000001037377824ULL, 0x100fe200078e0214ULL,
0x000000151c027210ULL, 0x000fe20007f9e0ffULL, 0x0000001039397824ULL, 0x000fe200078e0214ULL,
0x00005f001b137a11ULL, 0x000fe200010f4c1eULL, 0x000000103b3b7824ULL, 0x000fc400078e0214ULL,
0x000000103d3d7824ULL, 0x100fe400078e0214ULL, 0x000000103f3f7824ULL, 0x100fe400078e0214ULL,
0x0000001041417824ULL, 0x100fe400078e0214ULL, 0x0000001043437824ULL, 0x100fe400078e0214ULL,
0x0000001045457824ULL, 0x100fe400078e0214ULL, 0x0000001047477824ULL, 0x000fc400078e0214ULL,
0x0000001049497824ULL, 0x000fe400078e0214ULL, 0x000000ffff1a7224ULL, 0x000fe200018e06ffULL,
0x00005e0019147a11ULL, 0x040fe200078648ffULL, 0x000000ffff037224ULL, 0x000fe200008e06ffULL,
0x00005e0000187a11ULL, 0x000fe200078248ffULL, 0x00000001221b7824ULL, 0x100fe200078e021dULL,
0x00005f0019157a11ULL, 0x000fe200018f4c1aULL, 0x0000000126217824ULL, 0x000fe200078e021dULL,
0x00005f0000197a11ULL, 0x000fe200008f4c03ULL, 0x0000000120037824ULL, 0x100fe200078e021dULL,
0x0000001b1c237210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x000000211c007210ULL, 0x000fe20007f3e0ffULL, 0x00000001241f7824ULL, 0x100fe200078e021dULL,
0x000000031c257210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005e0002167a11ULL, 0x000fe200078848ffULL, 0x000000ffff037224ULL, 0x000fe200008e06ffULL,
0x00005e00231e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x00005e0000227a11ULL, 0x000fe200078248ffULL, 0x000000012a277824ULL, 0x000fe200078e021dULL,
0x00005f0002177a11ULL, 0x000fe200020f4c17ULL, 0x000000012c297824ULL, 0x100fe200078e021dULL,
0x00005e00251a7a11ULL, 0x000fe200078448ffULL, 0x000000012e2b7824ULL, 0x000fe200078e021dULL,
0x0000001f1c027210ULL, 0x000fc40007f9e0ffULL, 0x00005f00231f7a11ULL, 0x000fe400018f4c24ULL,
0x00005f0000237a11ULL, 0x000fe200008f4c03ULL, 0x000000ffff217224ULL, 0x000fe200020e06ffULL,
0x00005f00251b7a11ULL, 0x000fe200010f4c26ULL, 0x0000000128257824ULL, 0x000fe200078e021dULL,
0x00000007a1037812ULL, 0x000fe400078ec0ffULL, 0x00005e0002207a11ULL, 0x000fe400078848ffULL,
0x00000008034b7812ULL, 0x000fc400078efcffULL, 0x000000251c257210ULL, 0x000fe40007f5e0ffULL,
0x00005f0002217a11ULL, 0x000fe200020f4c21ULL, 0x000000104b0a7825ULL, 0x040fe200078e000aULL,
0x000000271c277210ULL, 0x040fe40007f7e0ffULL, 0x000000291c297210ULL, 0x040fe20007f9e0ffULL,
0x000000104b0c7825ULL, 0x000fe200078e000cULL, 0x0000002b1c2b7210ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a097faeULL, 0x0003e4000b901c46ULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078448ffULL,
0x000000104b0e7825ULL, 0x000fe200078e000eULL, 0x000000000c2d7faeULL, 0x0005e4000b901c46ULL,
0x00005f0025257a11ULL, 0x000fe200010f4c2eULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078648ffULL, 0x000000104b107825ULL, 0x000fe200078e0010ULL,
0x000000000e2f7faeULL, 0x0005e4000b901c46ULL, 0x00005f0027277a11ULL, 0x000fe200018f4c2cULL,
0x000000ffff027224ULL, 0x000fe200020e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078848ffULL,
0x000000104b127825ULL, 0x000fe200078e0012ULL, 0x0000000010317faeULL, 0x0005e4000b901c46ULL,
0x00005f0029297a11ULL, 0x000fe200020f4c02ULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078248ffULL, 0x000000104b147825ULL, 0x000fe200078e0014ULL,
0x0000000012337faeULL, 0x0005e4000b901c46ULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c00ULL,
0x000000104b167825ULL, 0x040fe200078e0016ULL, 0x0000000014357faeULL, 0x0005e6000b901c46ULL,
0x000000104b187825ULL, 0x040fe200078e0018ULL, 0x0000000016377faeULL, 0x0005e6000b901c46ULL,
0x000000104b1a7825ULL, 0x040fe200078e001aULL, 0x0000000018397faeULL, 0x0005e6000b901c46ULL,
0x000000104b1e7825ULL, 0x040fe200078e001eULL, 0x000000001a3b7faeULL, 0x0005e6000b901c46ULL,
0x000000104b207825ULL, 0x040fe200078e0020ULL, 0x000000001e3d7faeULL, 0x0005e6000b901c46ULL,
0x000000104b0a7825ULL, 0x042fe200078e0022ULL, 0x00000000203f7faeULL, 0x0005e6000b901c46ULL,
0x000000104b227825ULL, 0x040fe200078e0024ULL, 0x000000000a417faeULL, 0x0005e6000b901c46ULL,
0x000000104b247825ULL, 0x040fe200078e0026ULL, 0x0000000022437faeULL, 0x0005e6000b901c46ULL,
0x000000104b267825ULL, 0x040fe200078e0028ULL, 0x0000000024457faeULL, 0x0005e6000b901c46ULL,
0x000000104b287825ULL, 0x000fe200078e002aULL, 0x0000000026477faeULL, 0x0005e8000b901c46ULL,
0x0000000028497faeULL, 0x0005e4000b901c46ULL, 0x00000004ff097819ULL, 0x100fe200000116a1ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000003ffc47819ULL, 0x100fe200000116a1ULL,
0x00004000081e7824ULL, 0x004fe200078e00ffULL, 0x0000000803027812ULL, 0x000fe200078ef8a1ULL,
0x0000000809007824ULL, 0x000fe200078e00ffULL, 0x00000001c40a7812ULL, 0x002fc400078ec0ffULL,
0x000020001e917810ULL, 0x000fe20007ffe0ffULL, 0x0000002002117824ULL, 0x000fe200078e00ffULL,
0xfffffff8000b7812ULL, 0x000fe200078ee203ULL, 0x0000000102007824ULL, 0x040fe400078e0209ULL,
0x0000002002097824ULL, 0x000fe200078e00ffULL, 0x000000100b3d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010a1f7824ULL, 0x000fe200078e020bULL, 0x0000000200107810ULL, 0x000fe20007ffe0ffULL,
0x000000080bc27824ULL, 0x000fe200078e00ffULL, 0xffffffe009097812ULL, 0x000fe200078ee200ULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0x000000021fbe7810ULL, 0x000fe20007ffe0ffULL,
0x000000010ac17824ULL, 0x000fe200078e023dULL, 0xfffffff8c2c27812ULL, 0x000fe200078ee21fULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0xffffffe011107812ULL, 0x000fe200078ee210ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000010c2ae7824ULL, 0x000fe200078e0291ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000090c783bULL, 0x0003e20000000200ULL,
0x000000083d127824ULL, 0x000fe200078e00ffULL, 0xfffffff813be7812ULL, 0x000fe200078ee2beULL,
0x0000001010287824ULL, 0x000fe200078e00ffULL, 0x00000000ae14783bULL, 0x000ea20000000200ULL,
0x000000300b3f7810ULL, 0x040fe20007ffe0ffULL, 0x000000080b457824ULL, 0x040fe200078e00ffULL,
0xfffffff812c17812ULL, 0x000fe200078ee2c1ULL, 0x00000010bea97824ULL, 0x000fe200078e0291ULL,
0x000000200b097810ULL, 0x002fe20007ffe0ffULL, 0x000000010abf7824ULL, 0x040fe200078e023fULL,
0x000000221fbc7810ULL, 0x000fe20007ffe0ffULL, 0x00000010c1ad7824ULL, 0x000fe200078e0291ULL,
0x000000002828783bULL, 0x000fe20000000200ULL, 0x000000010ac07824ULL, 0x000fe200078e0209ULL,
0x000000121fbd7810ULL, 0x000fe20007ffe0ffULL, 0x0000000809197824ULL, 0x000fe200078e00ffULL,
0x00000000a920783bULL, 0x000fe20000000200ULL, 0x000000083f0a7824ULL, 0x000fe200078e00ffULL,
0x000000321fbb7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff819c07812ULL, 0x000fe200078ee2c0ULL,
0x00000000ad10783bULL, 0x000e620000000200ULL, 0xfffffff80abf7812ULL, 0x000fe200078ee2bfULL,
0x000000083d0a7824ULL, 0x000fe200078e00ffULL, 0x000000041fb37810ULL, 0x040fe20007ffe0ffULL,
0x00000010c0ab7824ULL, 0x100fe200078e0291ULL, 0x000000141fb17810ULL, 0x000fe20007ffe0ffULL,
0x00000010bfaa7824ULL, 0x000fe200078e0291ULL, 0xfffffff80abd7812ULL, 0x000fe200078ee2bdULL,
0x000000083f0a7824ULL, 0x000fe200078e00ffULL, 0x00000000ab2c783bULL, 0x000ee20000000200ULL,
0x000000241fb07810ULL, 0x000fc40007ffe0ffULL, 0x00000010bda67824ULL, 0x000fe200078e0291ULL,
0x00000000aa24783bULL, 0x000f220000000200ULL, 0xfffffff80abb7812ULL, 0x000fe400078ee2bbULL,
0x00000004000a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000a618783bULL, 0x000fe20000000200ULL,
0x000000341faf7810ULL, 0x000fe20007ffe0ffULL, 0x00000010bba47824ULL, 0x000fe200078e0291ULL,
0x000000061fac7810ULL, 0x040fe20007ffe0ffULL, 0x000000140c80723cULL, 0x004b6200000018ffULL,
0x000000161fa77810ULL, 0x000fc40007ffe0ffULL, 0x00000000a438783bULL, 0x000fe20000000200ULL,
0x000000261fa87810ULL, 0x040fe40007ffe0ffULL, 0x000000361fa37810ULL, 0x000fe20007ffe0ffULL,
0x0000000809157824ULL, 0x020fe200078e00ffULL, 0x000000160c30723cULL, 0x000b6200000018ffULL,
0xfffffff845ac7812ULL, 0x000fc600078ee2acULL, 0xfffffff815bc7812ULL, 0x000fe400078ee2bcULL,
0x00000010acb77824ULL, 0x000fc600078e0291ULL, 0x00000010bca57824ULL, 0x000fe200078e0291ULL,
0x000000100c40723cULL, 0x002fe200000018ffULL, 0x00000000b764783bULL, 0x000fe80000000200ULL,
0x00000000a514783bULL, 0x020e660000000200ULL, 0x000000202880723cULL, 0x000ff00000001880ULL,
0x0000002c0c48723cULL, 0x008f7000000018ffULL, 0x000000222820723cULL, 0x000ff00000001830ULL,
0x000000120c30723cULL, 0x040f7000000018ffULL, 0x0000002e0c10723cULL, 0x040f7000000018ffULL,
0x000000240c50723cULL, 0x010b6e00000018ffULL, 0x0000002002257824ULL, 0x020fe200078e00ffULL,
0x000000142848723cULL, 0x002be20000001848ULL, 0x000000083d247824ULL, 0x000fc600078e00ffULL,
0xffffffe0250a7812ULL, 0x000fe400078ee20aULL, 0xfffffff824b17812ULL, 0x000fe200078ee2b1ULL,
0x000000080b147824ULL, 0x020fe200078e00ffULL, 0x000000260c0c723cULL, 0x000b6200000018ffULL,
0x0000000809157824ULL, 0x000fe200078e00ffULL, 0x0000000600247810ULL, 0x000fe20007ffe0ffULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff814b37812ULL, 0x000fe200078ee2b3ULL,
0x00000010b1b47824ULL, 0x100fe200078e0291ULL, 0xfffffff815b07812ULL, 0x000fe200078ee2b0ULL,
0x000000083f267824ULL, 0x020fe200078e00ffULL, 0x000000182840723cULL, 0x040f620000001840ULL,
0x00000010b3b27824ULL, 0x100fe200078e0291ULL, 0xffffffe0250b7812ULL, 0x000fe200078ee224ULL,
0x00000010b0b57824ULL, 0x000fe200078e0291ULL, 0xfffffff826af7812ULL, 0x000fe200078ee2afULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x00000000b234783bULL, 0x000fe20000000200ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x0000001a2818723cULL, 0x000b620000001830ULL,
0x00000010afb67824ULL, 0x000fe200078e0291ULL, 0x00000000b430783bULL, 0x020fe20000000200ULL,
0xfffffff809a87812ULL, 0x000fc600078ee2a8ULL, 0x00000000b52c783bULL, 0x000fe40000000200ULL,
0x000000162814723cULL, 0x040b620000001810ULL, 0x00000010a8b97824ULL, 0x000fe200078e0291ULL,
0x000000000a10783bULL, 0x0202a80000000200ULL, 0x00000000b624783bULL, 0x000ee40000000200ULL,
0x000000382850723cULL, 0x040b620000001850ULL, 0x000000083d0a7824ULL, 0x002fe200078e00ffULL,
0x000000000b5c783bULL, 0x000e6a0000000200ULL, 0x000000083f387824ULL, 0x020fe200078e00ffULL,
0xfffffff80aa77812ULL, 0x000fe200078ee2a7ULL, 0x0000003a2828723cULL, 0x000b62000000180cULL,
0x00000000b960783bULL, 0x000fe40000000200ULL, 0xfffffff838a37812ULL, 0x000fe200078ee2a3ULL,
0x00000010a7b87824ULL, 0x000fc800078e0291ULL, 0x00000010a3ba7824ULL, 0x000fe200078e0291ULL,
0x00000000b83c783bULL, 0x000f280000000200ULL, 0x00000000ba0c783bULL, 0x020e620000000200ULL,
0x000000341080723cULL, 0x044f700000001880ULL, 0x000000301040723cULL, 0x040f700000001840ULL,
0x0000002c1048723cULL, 0x040f700000001848ULL, 0x000000361020723cULL, 0x040f700000001820ULL,
0x000000321018723cULL, 0x040f700000001818ULL, 0x0000002e1014723cULL, 0x040f700000001814ULL,
0x000000241050723cULL, 0x048f700000001850ULL, 0x000000261010723cULL, 0x000f700000001828ULL,
0x000000645c80723cULL, 0x062b700000001880ULL, 0x0000003c5c40723cULL, 0x050b700000001840ULL,
0x000000605c48723cULL, 0x040b700000001848ULL, 0x000000665c64723cULL, 0x040b700000001820ULL,
0x0000003e5c3c723cULL, 0x040b700000001818ULL, 0x000000625c60723cULL, 0x040b700000001814ULL,
0x0000000c5c50723cULL, 0x040b700000001850ULL, 0x0000000e5c5c723cULL, 0x000b620000001810ULL,
0x00000d4000008947ULL, 0x000fce0003800000ULL, 0x00000008c40a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001c40b7824ULL, 0x040fe200078e02a1ULL, 0x00000004c4097810ULL, 0x040fe20007ffe0ffULL,
0x00000001c4137824ULL, 0x020fe200078e021dULL, 0x0000001003557812ULL, 0x000fe200078efcffULL,
0x000000010a8e7824ULL, 0x000fe200078e02a1ULL, 0x0000000790907812ULL, 0x000fe200078ef80bULL,
0x000000080a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000cc40b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001098f7824ULL, 0x140fe200078e02a1ULL, 0x000000131c147210ULL, 0x000fe20007f3e0ffULL,
0x00000008090c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d8e7812ULL, 0x000fe200078ee28eULL,
0x000000010b8d7824ULL, 0x040fe200078e02a1ULL, 0x00000014c40d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c8f7812ULL, 0x000fe200078ee28fULL,
0x0000000109137824ULL, 0x000fe200078e021dULL, 0x00000010c40c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d8b7824ULL, 0x040fe200078e02a1ULL, 0xfffffff80e8d7812ULL, 0x000fe200078ee28dULL,
0x000000080d107824ULL, 0x000fe200078e00ffULL, 0x00000018c40e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c8c7824ULL, 0x000fe200078e02a1ULL, 0x000000131c167210ULL, 0x000fe20007f5e0ffULL,
0x000000080c0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8108b7812ULL, 0x000fe200078ee28bULL,
0x000000010e8a7824ULL, 0x100fe200078e02a1ULL, 0x00000020c4107810ULL, 0x000fe20007ffe0ffULL,
0x000000080e117824ULL, 0x000fe200078e00ffULL, 0xfffffff80f8c7812ULL, 0x000fe200078ee28cULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0x0000001cc40f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110887824ULL, 0x100fe200078e02a1ULL, 0x00005e0016227a11ULL, 0x000fe200078448ffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0xfffffff8118a7812ULL, 0x000fe200078ee28aULL,
0x000000010f897824ULL, 0x040fe200078e02a1ULL, 0x00000024c4117810ULL, 0x000fe20007ffe0ffULL,
0x000000080f127824ULL, 0x000fe200078e00ffULL, 0xfffffff815887812ULL, 0x000fe200078ee288ULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x00005e0014207a11ULL, 0x000fe200078248ffULL,
0x000000010d1b7824ULL, 0x000fe200078e021dULL, 0x00005f0016237a11ULL, 0x000fe200010f4c17ULL,
0x000000010b177824ULL, 0x000fe200078e021dULL, 0x00005f0014217a11ULL, 0x000fe200008f4c15ULL,
0x000000010a157824ULL, 0x000fe200078e021dULL, 0xfffffff812897812ULL, 0x000fe200078ee289ULL,
0x000000010c197824ULL, 0x000fe200078e021dULL, 0x00000028c4127810ULL, 0x000fe20007ffe0ffULL,
0x00000001111f7824ULL, 0x140fe200078e02a1ULL, 0x000000151c157210ULL, 0x040fe20007f5e0ffULL,
0x00000008111a7824ULL, 0x000fe200078e00ffULL, 0x0000001b1c1b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000112187824ULL, 0x000fe200078e02a1ULL, 0x000000171c177210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005e0015247a11ULL, 0x040fe200078448ffULL,
0x0000000812137824ULL, 0x000fe200078e00ffULL, 0x000000191c197210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005f0015257a11ULL, 0x000fe200010f4c14ULL,
0x000000010e157824ULL, 0x000fe200078e021dULL, 0xfffffff813137812ULL, 0x000fe200078ee218ULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x00005e001b2a7a11ULL, 0x000fe200078248ffULL,
0x00000001064d7824ULL, 0x000fe200078e0a04ULL, 0x00005e0017267a11ULL, 0x000fe200078648ffULL,
0x0000001090a07824ULL, 0x100fe200078e0291ULL, 0x00005e0019287a11ULL, 0x000fe200078848ffULL,
0x000000108f9f7824ULL, 0x000fe200078e0291ULL, 0x00005f001b2b7a11ULL, 0x000fe200008f4c1aULL,
0x00000001111b7824ULL, 0x100fe200078e021dULL, 0x00005f0017277a11ULL, 0x000fe200018f4c16ULL,
0x000000010f177824ULL, 0x000fe200078e021dULL, 0x000000151c157210ULL, 0x000fe20007f5e0ffULL,
0x000000108e9e7824ULL, 0x000fe200078e0291ULL, 0x00005f0019297a11ULL, 0x000fe200020f4c18ULL,
0x0000000110197824ULL, 0x000fe200078e021dULL, 0x0000001b1c1b7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x000000171c177210ULL, 0x040fe20007f7e0ffULL,
0x000000108d9d7824ULL, 0x100fe200078e0291ULL, 0x00005e00152c7a11ULL, 0x040fe200078448ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x000000191c197210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x00005f00152d7a11ULL, 0x000fe200010f4c14ULL,
0x000000108c9c7824ULL, 0x100fe200078e0291ULL, 0x00005e001b327a11ULL, 0x000fe200078248ffULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x00000030c4157810ULL, 0x000fe20007ffe0ffULL,
0x000000108b9b7824ULL, 0x100fe200078e0291ULL, 0x00005e00172e7a11ULL, 0x000fe200078648ffULL,
0x000000108a9a7824ULL, 0x000fe200078e0291ULL, 0x00005e0019307a11ULL, 0x000fe200078848ffULL,
0x0000001055467825ULL, 0x000fe200078e002cULL, 0x0000002cc4147810ULL, 0x000fc40007ffe0ffULL,
0x00005f001b337a11ULL, 0x000fe200008f4c1aULL, 0x00000001151b7824ULL, 0x000fe200078e021dULL,
0x0000004dc400720cULL, 0x080fe20003f46070ULL, 0x0000001089997824ULL, 0x000fe200078e0291ULL,
0x00005f00172f7a11ULL, 0x000fe200018f4c16ULL, 0x0000000112177824ULL, 0x000fe200078e021dULL,
0x0000004d0900720cULL, 0x000fe20003f26070ULL, 0x0000001088987824ULL, 0x000fe200078e0291ULL,
0x00005f0019317a11ULL, 0x000fe200020f4c18ULL, 0x0000000114197824ULL, 0x000fe200078e021dULL,
0x0000001b1c397210ULL, 0x040fe20007f7e0ffULL, 0x000000101f977824ULL, 0x000fe200078e0291ULL,
0x000000171c1a7210ULL, 0x040fe20007f9e0ffULL, 0x0000001055167825ULL, 0x000fe200078e0020ULL,
0x000000191c377210ULL, 0x000fc60007fbe0ffULL, 0x0000001055187825ULL, 0x000fe200078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016a07faeULL, 0x0003e2000d101c46ULL,
0x0000004d0b00720cULL, 0x080fe40003f46070ULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x00005e0039387a11ULL, 0x040fe200078648ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e06ffULL,
0x00005e001a347a11ULL, 0x000fe200078848ffULL, 0x00000000189f7faeULL, 0x0005e2000c901c46ULL,
0x0000004d0a00720cULL, 0x000fe20003f26070ULL, 0x000000ffff3a7224ULL, 0x000fe200028e06ffULL,
0x00005f0039397a11ULL, 0x000fe200018f4c44ULL, 0x0000001055447825ULL, 0x000fe200078e002aULL,
0x00005f001a357a11ULL, 0x000fc400020f4c1bULL, 0x0000004d0c00720cULL, 0x080fe20003f66070ULL,
0x00000010551a7825ULL, 0x000fe200078e0026ULL, 0x0000004d0d00720cULL, 0x080fe40003f86070ULL,
0x00005e0037367a11ULL, 0x000fe200078a48ffULL, 0x0000001055187825ULL, 0x004fe200078e0024ULL,
0x00000034c4167810ULL, 0x002fe40007ffe0ffULL, 0x00005f0037377a11ULL, 0x000fe200028f4c3aULL,
0x00000010553a7825ULL, 0x000fe200078e0028ULL, 0x0000004d0e00720cULL, 0x080fe20003fa6070ULL,
0x00000000189e7faeULL, 0x0003e2000c901c46ULL, 0x0000004d0f00720cULL, 0x080fe20003f26070ULL,
0x0000001013967824ULL, 0x000fe200078e0291ULL, 0x00000038c4177810ULL, 0x000fe20007ffe0ffULL,
0x000000001a9d7faeULL, 0x0005e2000d101c46ULL, 0x0000004d1000720cULL, 0x000fc60003f46070ULL,
0x000000003a9c7faeULL, 0x0007e2000d901c46ULL, 0x0000004d1100720cULL, 0x000fc60003f66070ULL,
0x00000000449b7faeULL, 0x0009e2000e101c46ULL, 0x0000004d1200720cULL, 0x080fe20003f86070ULL,
0x0000000116197824ULL, 0x002fe200078e021dULL, 0x0000003cc4187810ULL, 0x000fe20007ffe0ffULL,
0x00000000469a7faeULL, 0x0003e2000e901c46ULL, 0x00000010551a7825ULL, 0x004fe200078e0034ULL,
0x0000004d1700720cULL, 0x000fc60003fa6070ULL, 0x00000010553a7825ULL, 0x008fc800078e002eULL,
0x0000001055447825ULL, 0x050fe200078e0030ULL, 0x000000003a997faeULL, 0x0005e2000c901c46ULL,
0x0000004d1400720cULL, 0x080fe40003f26070ULL, 0x0000001055467825ULL, 0x002fe200078e0032ULL,
0x0000000044987faeULL, 0x0003e2000d101c46ULL, 0x0000004d1600720cULL, 0x000fc60003f46070ULL,
0x0000000046977faeULL, 0x0007e2000d901c46ULL, 0x0000004d1500720cULL, 0x000fc60003f66070ULL,
0x000000001a967faeULL, 0x0009e2000e101c46ULL, 0x000000191c197210ULL, 0x000fe20007f9e0ffULL,
0x0000000117457824ULL, 0x002fc600078e021dULL, 0x00005e00193a7a11ULL, 0x044fe200078c48ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000004d1800720cULL, 0x040fe20003f86070ULL,
0x00000001181d7824ULL, 0x000fe400078e021dULL, 0x0000000814467824ULL, 0x048fe200078e00ffULL,
0x00005f00193b7a11ULL, 0x000fe200030f4c4cULL, 0x0000000114197824ULL, 0x100fe200078e02a1ULL,
0x000000451c457210ULL, 0x000fe20007fde0ffULL, 0x00000001151a7824ULL, 0x050fe400078e02a1ULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0xfffffff846197812ULL, 0x000fe200078ee219ULL,
0x000000ffff447224ULL, 0x000fe200030e06ffULL, 0x00005e0045847a11ULL, 0x000fe200078c48ffULL,
0x0000000816467824ULL, 0x040fe200078e00ffULL, 0xfffffff81b1a7812ULL, 0x000fe200078ee21aULL,
0x00000001161b7824ULL, 0x100fe200078e02a1ULL, 0x00005f0045857a11ULL, 0x000fe200030f4c44ULL,
0x0000000817477824ULL, 0x040fe200078e00ffULL, 0x0000001d1c447210ULL, 0x000fe20007fde0ffULL,
0x00000001171c7824ULL, 0x000fe200078e02a1ULL, 0xfffffff8461b7812ULL, 0x000fe200078ee21bULL,
0x00000001181d7824ULL, 0x000fc400078e02a1ULL, 0x00000008184c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8471c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff457224ULL, 0x000fe200030e06ffULL,
0x00005e0044867a11ULL, 0x000fe200078c48ffULL, 0x0000001019957824ULL, 0x000fe200078e0291ULL,
0xfffffff84c1d7812ULL, 0x000fe200078ee21dULL, 0x000000101a947824ULL, 0x000fe200078e0291ULL,
0x00005f0044877a11ULL, 0x000fe200030f4c45ULL, 0x0000001055447825ULL, 0x000fc800078e0036ULL,
0x0000001055467825ULL, 0x000fe200078e0038ULL, 0x0000000044957faeULL, 0x0003e6000c901c46ULL,
0x000000101b937824ULL, 0x000fe200078e0291ULL, 0x0000000046947faeULL, 0x0003e2000d901c46ULL,
0x00000010554c7825ULL, 0x000fc800078e003aULL, 0x000000101c927824ULL, 0x000fe200078e0291ULL,
0x000000004c937faeULL, 0x0003e2000d101c46ULL, 0x00000010554e7825ULL, 0x000fc800078e0084ULL,
0x000000101d917824ULL, 0x000fe200078e0291ULL, 0x000000004e927faeULL, 0x0003e2000e901c46ULL,
0x0000001055547825ULL, 0x000fca00078e0086ULL, 0x0000000054917faeULL, 0x0003e2000e101c46ULL,
0x00000c2000007947ULL, 0x000fea0003800000ULL, 0x00000004c4097810ULL, 0x040fe20007ffe0ffULL,
0x00000001c40b7824ULL, 0x000fe200078e021dULL, 0x0000001003597812ULL, 0x000fc600078efcffULL,
0x00000001090d7824ULL, 0x060fe200078e021dULL, 0x0000000b1c0b7210ULL, 0x040fe20007f3e0ffULL,
0x00000001098f7824ULL, 0x140fe400078e02a1ULL, 0x00000008091a7824ULL, 0x000fe200078e00ffULL,
0x0000000d1c0c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e000b207a11ULL, 0x040fe200078248ffULL, 0x00000001c40d7824ULL, 0x000fe200078e02a1ULL,
0xfffffff81a8f7812ULL, 0x000fe200078ee28fULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x00005f000b217a11ULL, 0x000fc400008f4c0aULL, 0x00005e000c227a11ULL, 0x000fe200078448ffULL,
0x000000108f9f7824ULL, 0x000fe200078e0291ULL, 0x00000008c40a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001059567825ULL, 0x000fe200078e0020ULL, 0x0000000cc40b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000790907812ULL, 0x000fe200078ef80dULL, 0x000000010a8e7824ULL, 0x000fe200078e02a1ULL,
0x00005f000c237a11ULL, 0x000fe200010f4c0fULL, 0x000000010a0f7824ULL, 0x100fe200078e021dULL,
0x00000010c40c7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b117824ULL, 0x040fe200078e021dULL,
0x00000014c40d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b8d7824ULL, 0x000fe200078e02a1ULL,
0x0000000f1c0f7210ULL, 0x000fe20007f5e0ffULL, 0x000000010c137824ULL, 0x100fe200078e021dULL,
0x000000111c117210ULL, 0x000fe20007f7e0ffULL, 0x000000010d157824ULL, 0x000fc400078e021dULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x000000131c137210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x000000151c157210ULL, 0x000fe20007f3e0ffULL,
0x000000080b1a7824ULL, 0x000fe200078e00ffULL, 0x00005e000f247a11ULL, 0x000fe200078448ffULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x00005e0011267a11ULL, 0x000fe200078648ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x00005f000f257a11ULL, 0x000fe200010f4c0eULL,
0x000000010c8c7824ULL, 0x100fe200078e02a1ULL, 0x00005f0011277a11ULL, 0x000fe200018f4c10ULL,
0x000000010d8b7824ULL, 0x000fe200078e02a1ULL, 0x00005e0013287a11ULL, 0x000fe200078848ffULL,
0x0000001090a07824ULL, 0x000fe200078e0291ULL, 0x00005e00152a7a11ULL, 0x000fc400078248ffULL,
0x00000018c40e7810ULL, 0x040fe40007ffe0ffULL, 0x0000001cc40f7810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000056a07faeULL, 0x0003e2000b901c46ULL,
0x00000020c4107810ULL, 0x000fe20007ffe0ffULL, 0x000000010e8a7824ULL, 0x100fe200078e02a1ULL,
0x00000024c4117810ULL, 0x000fe20007ffe0ffULL, 0x000000010f897824ULL, 0x000fe200078e02a1ULL,
0x00005f0013297a11ULL, 0x000fe200020f4c12ULL, 0x000000010e137824ULL, 0x100fe200078e021dULL,
0x00005f00152b7a11ULL, 0x000fe200008f4c14ULL, 0x000000010f157824ULL, 0x000fe200078e021dULL,
0xfffffff81a8d7812ULL, 0x000fe200078ee28dULL, 0x0000000110177824ULL, 0x100fe200078e021dULL,
0x000000131c137210ULL, 0x040fe20007f5e0ffULL, 0x0000000111197824ULL, 0x000fe200078e021dULL,
0x000000151c157210ULL, 0x040fe20007f7e0ffULL, 0x000000080f1a7824ULL, 0x000fe200078e00ffULL,
0x000000171c177210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x000000191c197210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x00005e00132c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005e00152e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x00005e0017307a11ULL, 0x000fe200078848ffULL, 0x0000000110887824ULL, 0x000fe200078e02a1ULL,
0x00005e0019327a11ULL, 0x000fe200078248ffULL, 0x000000108d9d7824ULL, 0x000fe200078e0291ULL,
0x00005f00132d7a11ULL, 0x000fe200010f4c12ULL, 0x0000001059547825ULL, 0x000fe200078e002aULL,
0x00005f00152f7a11ULL, 0x000fc400018f4c14ULL, 0x00005f0017317a11ULL, 0x000fe400020f4c16ULL,
0x00005f0019337a11ULL, 0x000fe400008f4c18ULL, 0x00000028c4127810ULL, 0x040fe40007ffe0ffULL,
0x0000002cc4147810ULL, 0x040fe40007ffe0ffULL, 0x00000030c4157810ULL, 0x000fe20007ffe0ffULL,
0x0000000112137824ULL, 0x100fe200078e021dULL, 0x00000034c4167810ULL, 0x000fe20007ffe0ffULL,
0x0000000114197824ULL, 0x100fe200078e021dULL, 0x00000038c4177810ULL, 0x040fe20007ffe0ffULL,
0x00000001151f7824ULL, 0x100fe200078e021dULL, 0x0000003cc4187810ULL, 0x000fe20007ffe0ffULL,
0x0000000116357824ULL, 0x100fe200078e021dULL, 0x000000191c377210ULL, 0x040fe20007fbe0ffULL,
0x0000000117457824ULL, 0x100fe200078e021dULL, 0x000000131c1b7210ULL, 0x000fe20007fde0ffULL,
0x00000001181d7824ULL, 0x000fe200078e021dULL, 0x0000001f1c397210ULL, 0x000fe20007f9e0ffULL,
0x000000080c197824ULL, 0x000fe200078e00ffULL, 0x000000351c3b7210ULL, 0x000fe20007f3e0ffULL,
0x000000080a137824ULL, 0x000fe200078e00ffULL, 0x000000451c457210ULL, 0x040fe20007f5e0ffULL,
0x00000001111f7824ULL, 0x000fe200078e02a1ULL, 0x0000001d1c477210ULL, 0x000fe20007f7e0ffULL,
0x000000080d1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8198c7812ULL, 0x000fe200078ee28cULL,
0x0000000810197824ULL, 0x000fe200078e00ffULL, 0xfffffff8138e7812ULL, 0x000fe200078ee28eULL,
0x000000080e137824ULL, 0x000fe200078e00ffULL, 0xfffffff81c8b7812ULL, 0x000fe200078ee28bULL,
0x00000008111c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a897812ULL, 0x000fe200078ee289ULL,
0x00000001151a7824ULL, 0x100fe200078e02a1ULL, 0xfffffff819887812ULL, 0x000fe200078ee288ULL,
0x00000008151d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8138a7812ULL, 0x000fe200078ee28aULL,
0x0000000114197824ULL, 0x000fe200078e02a1ULL, 0xfffffff81c1f7812ULL, 0x000fe200078ee21fULL,
0x0000000814387824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1a7812ULL, 0x000fe200078ee21aULL,
0x0000000112137824ULL, 0x000fc400078e02a1ULL, 0x0000000812367824ULL, 0x000fe200078e00ffULL,
0xfffffff838197812ULL, 0x000fe200078ee219ULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x00005e001b347a11ULL, 0x040fe200078c48ffULL, 0x00000001181d7824ULL, 0x000fe200078e02a1ULL,
0xfffffff836137812ULL, 0x000fe200078ee213ULL, 0x0000000818447824ULL, 0x000fe200078e00ffULL,
0x00005f001b357a11ULL, 0x000fe200030f4c1cULL, 0x000000ffff387224ULL, 0x000fe200028e06ffULL,
0x00005e0037367a11ULL, 0x040fe200078a48ffULL, 0x00000001161b7824ULL, 0x000fe200078e02a1ULL,
0xfffffff8441d7812ULL, 0x000fe200078ee21dULL, 0x00000008163a7824ULL, 0x000fe200078e00ffULL,
0x00005f0037377a11ULL, 0x000fe200028f4c38ULL, 0x000000ffff447224ULL, 0x000fe200020e06ffULL,
0x00005e0039387a11ULL, 0x000fe200078848ffULL, 0x000000ffff4c7224ULL, 0x000fe200010e06ffULL,
0xfffffff83a1b7812ULL, 0x000fe200078ee21bULL, 0x000000ffff467224ULL, 0x000fe200008e06ffULL,
0x00005e0045847a11ULL, 0x000fe200078448ffULL, 0x000000ffff4e7224ULL, 0x000fe200018e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078248ffULL, 0x00000001171c7824ULL, 0x000fe200078e02a1ULL,
0x00005e0047867a11ULL, 0x000fe200078648ffULL, 0x00000008174d7824ULL, 0x000fe200078e00ffULL,
0x00005f0039397a11ULL, 0x000fe200020f4c44ULL, 0x000000108e9e7824ULL, 0x000fe200078e0291ULL,
0x00005f0045857a11ULL, 0x000fe200010f4c4cULL, 0x0000001059447825ULL, 0x000fe200078e0022ULL,
0x00005f003b3b7a11ULL, 0x000fc400008f4c46ULL, 0x00005f0047877a11ULL, 0x000fe200018f4c4eULL,
0x0000001059467825ULL, 0x000fe200078e0024ULL, 0xfffffff84d1c7812ULL, 0x000fe200078ee21cULL,
0x00000000449f7faeULL, 0x0005e4000b901c46ULL, 0x00000010594c7825ULL, 0x040fe400078e0026ULL,
0x00000000469e7faeULL, 0x0007e4000b901c46ULL, 0x000000108c9c7824ULL, 0x000fe400078e0291ULL,
0x00000010594e7825ULL, 0x000fe200078e0028ULL, 0x000000004c9d7faeULL, 0x0009e6000b901c46ULL,
0x000000108b9b7824ULL, 0x100fe200078e0291ULL, 0x000000004e9c7faeULL, 0x0003e2000b901c46ULL,
0x000000108a9a7824ULL, 0x000fc400078e0291ULL, 0x0000001059447825ULL, 0x004fe200078e002cULL,
0x00000000549b7faeULL, 0x0005e6000b901c46ULL, 0x0000001089997824ULL, 0x000fe200078e0291ULL,
0x00000000449a7faeULL, 0x0003e2000b901c46ULL, 0x0000001059467825ULL, 0x008fc800078e002eULL,
0x0000001088987824ULL, 0x000fe200078e0291ULL, 0x0000000046997faeULL, 0x0007e2000b901c46ULL,
0x00000010594c7825ULL, 0x010fc800078e0030ULL, 0x000000101f977824ULL, 0x000fe200078e0291ULL,
0x000000004c987faeULL, 0x0009e2000b901c46ULL, 0x00000010594e7825ULL, 0x002fc800078e0032ULL,
0x0000001013967824ULL, 0x000fe200078e0291ULL, 0x000000004e977faeULL, 0x0003e2000b901c46ULL,
0x0000001059547825ULL, 0x004fc800078e0034ULL, 0x0000001019957824ULL, 0x000fe200078e0291ULL,
0x0000000054967faeULL, 0x0005e2000b901c46ULL, 0x0000001059447825ULL, 0x000fc800078e0036ULL,
0x000000101a947824ULL, 0x000fe200078e0291ULL, 0x0000000044957faeULL, 0x0003e2000b901c46ULL,
0x0000001059467825ULL, 0x008fc800078e0038ULL, 0x000000101b937824ULL, 0x000fe200078e0291ULL,
0x0000000046947faeULL, 0x0007e2000b901c46ULL, 0x00000010594c7825ULL, 0x010fc800078e003aULL,
0x000000101c927824ULL, 0x000fe200078e0291ULL, 0x000000004c937faeULL, 0x0007e2000b901c46ULL,
0x00000010594e7825ULL, 0x002fc800078e0084ULL, 0x000000101d917824ULL, 0x000fe200078e0291ULL,
0x000000004e927faeULL, 0x0007e2000b901c46ULL, 0x0000001059547825ULL, 0x004fca00078e0086ULL,
0x0000000054917faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002457824ULL, 0x002fe200078e00ffULL, 0x0000000800447810ULL, 0x000fe20007ffe0ffULL,
0x0000002002467824ULL, 0x008fe200078e00ffULL, 0x000040001e1e7810ULL, 0x000fe40007ffe0ffULL,
0xffffffe045447812ULL, 0x000fe400078ee244ULL, 0x0000000a00457810ULL, 0x000fe20007ffe0ffULL,
0x00000010c2c27824ULL, 0x100fe400078e021eULL, 0x0000001044447824ULL, 0x000fe200078e00ffULL,
0xffffffe046457812ULL, 0x000fe200078ee245ULL, 0x00000010c1c17824ULL, 0x000fc400078e021eULL,
0x00000010c0c07824ULL, 0x100fe400078e021eULL, 0x0000001045547824ULL, 0x000fe400078e00ffULL,
0x00000010bebe7824ULL, 0x100fe400078e021eULL, 0x00000010bfbf7824ULL, 0x100fe400078e021eULL,
0x00000010bdbd7824ULL, 0x000fe200078e021eULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000c24c783bULL, 0x000fe20000000200ULL, 0x00000010bcbc7824ULL, 0x100fe400078e021eULL,
0x00000010bbbb7824ULL, 0x100fe200078e021eULL, 0x000000004468783bULL, 0x000e620000000200ULL,
0x00000010b3b37824ULL, 0x100fe400078e021eULL, 0x00000010b1b17824ULL, 0x100fe200078e021eULL,
0x00000000c170783bULL, 0x000ea20000000200ULL, 0x00000010b0b07824ULL, 0x100fe400078e021eULL,
0x00000010afaf7824ULL, 0x100fe200078e021eULL, 0x00000000c058783bULL, 0x000ee20000000200ULL,
0x00000010acac7824ULL, 0x000fc400078e021eULL, 0x00000010a7a77824ULL, 0x100fe200078e021eULL,
0x00000000be7c783bULL, 0x000fe20000000200ULL, 0x00000010a8a87824ULL, 0x100fe400078e021eULL,
0x00000010a3a37824ULL, 0x000fe200078e021eULL, 0x000000005454783bULL, 0x000f280000000200ULL,
0x00000000bf6c783bULL, 0x000ee80000000200ULL, 0x00000000bd44783bULL, 0x000ee80000000200ULL,
0x00000000b178783bULL, 0x000fe80000000200ULL, 0x00000000b074783bULL, 0x000fe20000000200ULL,
0x0000004c6880723cULL, 0x042f700000001880ULL, 0x0000004e6864723cULL, 0x040b640000001864ULL,
0x00000000bc4c783bULL, 0x020e6c0000000200ULL, 0x000000706840723cULL, 0x044f700000001840ULL,
0x000000586848723cULL, 0x048ff00000001848ULL, 0x0000005a6860723cULL, 0x040be40000001860ULL,
0x00000000bb58783bULL, 0x020eac0000000200ULL, 0x00000072683c723cULL, 0x000b64000000183cULL,
0x00000000af70783bULL, 0x020fec0000000200ULL, 0x0000007c5480723cULL, 0x050ff00000001880ULL,
0x0000007e547c723cULL, 0x000bee0000001864ULL, 0x0000002002657824ULL, 0x020fe200078e00ffULL,
0x0000000c00647810ULL, 0x000fe20007ffe0ffULL, 0x0000006c6850723cULL, 0x000f660000001850ULL,
0xffffffe065647812ULL, 0x000fca00078ee264ULL, 0x0000006e685c723cULL, 0x000b62000000185cULL,
0x0000001064647824ULL, 0x000fe200078e00ffULL, 0x00000000ac68783bULL, 0x020fe80000000200ULL,
0x00000000646c783bULL, 0x000ee40000000200ULL, 0x000000445440723cULL, 0x040f640000001840ULL,
0x00000000a764783bULL, 0x000fec0000000200ULL, 0x000000465444723cULL, 0x040b64000000183cULL,
0x00000000b33c783bULL, 0x020f2c0000000200ULL, 0x0000004c5448723cULL, 0x042f700000001848ULL,
0x0000004e544c723cULL, 0x040b6e0000001860ULL, 0x0000002002617824ULL, 0x020fe200078e00ffULL,
0x0000000e00607810ULL, 0x000fe20007ffe0ffULL, 0x000000585450723cULL, 0x004b660000001850ULL,
0xffffffe061607812ULL, 0x000fca00078ee260ULL, 0x0000005a5454723cULL, 0x000b64000000185cULL,
0x0000001060587824ULL, 0x020fe200078e00ffULL, 0x00000000a35c783bULL, 0x000fe80000000200ULL,
0x00000000a860783bULL, 0x000fe20000000200ULL, 0x000000786c40723cULL, 0x048fe60000001840ULL,
0x000000005858783bULL, 0x000e6a0000000200ULL, 0x0000003c6c80723cULL, 0x050f700000001880ULL,
0x0000003e6c7c723cULL, 0x040f70000000187cULL, 0x0000007a6c44723cULL, 0x040f700000001844ULL,
0x000000746c48723cULL, 0x040f700000001848ULL, 0x000000766c4c723cULL, 0x040f70000000184cULL,
0x000000706c50723cULL, 0x040f700000001850ULL, 0x000000726c54723cULL, 0x000f700000001854ULL,
0x000000685880723cULL, 0x062b700000001880ULL, 0x0000006a587c723cULL, 0x040b70000000187cULL,
0x000000645840723cULL, 0x040b700000001840ULL, 0x000000665844723cULL, 0x040b700000001844ULL,
0x000000605848723cULL, 0x040b700000001848ULL, 0x00000062584c723cULL, 0x040b70000000184cULL,
0x0000005c5850723cULL, 0x040b700000001850ULL, 0x0000005e5854723cULL, 0x000b620000001854ULL,
0x0000046000008947ULL, 0x000fce0003800000ULL, 0x00000001065f7824ULL, 0x020fe200078e0a04ULL,
0x0000001803037812ULL, 0x000fe200078efcffULL, 0x00000010903d7824ULL, 0x000fc400078e021eULL,
0x000000108f8f7824ULL, 0x000fe200078e021eULL, 0x0000005fc400720cULL, 0x080fe20003f06070ULL,
0x0000001003207825ULL, 0x000fe200078e0020ULL, 0x0000005f0900720cULL, 0x080fe40003f26070ULL,
0x0000005f0c00720cULL, 0x080fe20003f46070ULL, 0x0000001003227825ULL, 0x000fe200078e0022ULL,
0x0000005f0d00720cULL, 0x080fe40003f66070ULL, 0x0000005f0e00720cULL, 0x080fe20003f86070ULL,
0x000000108e3f7824ULL, 0x000fe200078e021eULL, 0x0000005f0f00720cULL, 0x080fe20003fa6070ULL,
0x0000001003247825ULL, 0x000fe200078e0024ULL, 0x0000005f1000720cULL, 0x080fe20003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000203d7faeULL, 0x0003e2000c101c46ULL,
0x0000005f0a00720cULL, 0x000fe20003f06070ULL, 0x000000108d8d7824ULL, 0x000fc400078e021eULL,
0x00000000228f7faeULL, 0x0005e2000c901c46ULL, 0x0000005f0b00720cULL, 0x000fe20003f26070ULL,
0x0000001003267825ULL, 0x000fc800078e0026ULL, 0x000000108c597824ULL, 0x000fe400078e021eULL,
0x0000001003287825ULL, 0x000fe400078e0028ULL, 0x00000000243f7faeULL, 0x0007e2000c101c46ULL,
0x0000005f1100720cULL, 0x080fe20003f06070ULL, 0x000000108b8b7824ULL, 0x000fe400078e021eULL,
0x00000010032a7825ULL, 0x000fe200078e002aULL, 0x00000000268d7faeULL, 0x0007e2000c901c46ULL,
0x0000005f1200720cULL, 0x000fc40003f26070ULL, 0x000000108a5b7824ULL, 0x000fe200078e021eULL,
0x0000000028597faeULL, 0x0007e2000d101c46ULL, 0x00000010032c7825ULL, 0x000fe200078e002cULL,
0x0000005f1400720cULL, 0x080fe40003f46070ULL, 0x000000002a8b7faeULL, 0x0007e2000d901c46ULL,
0x0000001089897824ULL, 0x000fe200078e021eULL, 0x0000005f1500720cULL, 0x080fe20003f66070ULL,
0x00000010032e7825ULL, 0x000fe200078e002eULL, 0x000000002c5b7faeULL, 0x0007e2000e101c46ULL,
0x0000005f1600720cULL, 0x000fc40003f86070ULL, 0x00000010885d7824ULL, 0x000fe200078e021eULL,
0x000000002e897faeULL, 0x0007e2000e901c46ULL, 0x0000001003307825ULL, 0x000fe200078e0030ULL,
0x0000005f1700720cULL, 0x000fc60003fa6070ULL, 0x000000101f1f7824ULL, 0x000fe200078e021eULL,
0x00000000305d7faeULL, 0x0007e2000f101c46ULL, 0x0000005f1800720cULL, 0x000fe20003fc6070ULL,
0x0000001003327825ULL, 0x000fc800078e0032ULL, 0x0000001013137824ULL, 0x000fe200078e021eULL,
0x00000000321f7faeULL, 0x0007e2000c101c46ULL, 0x0000001003347825ULL, 0x000fc800078e0034ULL,
0x0000001019197824ULL, 0x000fe200078e021eULL, 0x0000000034137faeULL, 0x0007e2000c901c46ULL,
0x0000001003367825ULL, 0x000fc800078e0036ULL, 0x000000101a217824ULL, 0x002fe200078e021eULL,
0x0000000036197faeULL, 0x0007e2000d101c46ULL, 0x0000001003387825ULL, 0x000fc800078e0038ULL,
0x000000101b1b7824ULL, 0x000fe200078e021eULL, 0x0000000038217faeULL, 0x0007e2000d901c46ULL,
0x00000010033a7825ULL, 0x000fc800078e003aULL, 0x000000101c237824ULL, 0x004fe200078e021eULL,
0x000000003a1b7faeULL, 0x0007e2000e101c46ULL, 0x0000001003847825ULL, 0x000fc800078e0084ULL,
0x000000101d1d7824ULL, 0x000fe200078e021eULL, 0x0000000084237faeULL, 0x0007e2000e901c46ULL,
0x0000001003867825ULL, 0x000fca00078e0086ULL, 0x00000000861d7faeULL, 0x0007e2000f101c46ULL,
0x0000034000007947ULL, 0x000fea0003800000ULL, 0x0000001803037812ULL, 0x000fe200078efcffULL,
0x00000010903d7824ULL, 0x100fe400078e021eULL, 0x000000108f8f7824ULL, 0x000fe400078e021eULL,
0x0000001003207825ULL, 0x000fc800078e0020ULL, 0x0000001003227825ULL, 0x040fe200078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000203d7faeULL, 0x0003e6000b901c46ULL,
0x000000108e3f7824ULL, 0x000fe200078e021eULL, 0x00000000228f7faeULL, 0x0003e2000b901c46ULL,
0x0000001003247825ULL, 0x000fc800078e0024ULL, 0x000000108d8d7824ULL, 0x000fe200078e021eULL,
0x00000000243f7faeULL, 0x0003e2000b901c46ULL, 0x0000001003267825ULL, 0x000fc800078e0026ULL,
0x000000108c597824ULL, 0x020fe200078e021eULL, 0x00000000268d7faeULL, 0x0003e2000b901c46ULL,
0x0000001003287825ULL, 0x000fc800078e0028ULL, 0x000000108b8b7824ULL, 0x000fe200078e021eULL,
0x0000000028597faeULL, 0x0003e2000b901c46ULL, 0x00000010032a7825ULL, 0x000fc800078e002aULL,
0x000000108a5b7824ULL, 0x000fe200078e021eULL, 0x000000002a8b7faeULL, 0x0003e2000b901c46ULL,
0x00000010032c7825ULL, 0x000fc800078e002cULL, 0x0000001089897824ULL, 0x000fe200078e021eULL,
0x000000002c5b7faeULL, 0x0003e2000b901c46ULL, 0x00000010032e7825ULL, 0x000fc800078e002eULL,
0x00000010885d7824ULL, 0x000fe200078e021eULL, 0x000000002e897faeULL, 0x0003e2000b901c46ULL,
0x0000001003307825ULL, 0x000fc800078e0030ULL, 0x000000101f1f7824ULL, 0x000fe200078e021eULL,
0x00000000305d7faeULL, 0x0003e2000b901c46ULL, 0x0000001003327825ULL, 0x000fc800078e0032ULL,
0x0000001013137824ULL, 0x000fe200078e021eULL, 0x00000000321f7faeULL, 0x0003e2000b901c46ULL,
0x0000001003347825ULL, 0x000fc800078e0034ULL, 0x0000001019197824ULL, 0x000fe200078e021eULL,
0x0000000034137faeULL, 0x0003e2000b901c46ULL, 0x0000001003367825ULL, 0x000fc800078e0036ULL,
0x000000101a5f7824ULL, 0x000fe200078e021eULL, 0x0000000036197faeULL, 0x0003e2000b901c46ULL,
0x0000001003387825ULL, 0x000fc800078e0038ULL, 0x000000101b1b7824ULL, 0x000fe200078e021eULL,
0x00000000385f7faeULL, 0x0003e2000b901c46ULL, 0x00000010033a7825ULL, 0x000fc800078e003aULL,
0x000000101c617824ULL, 0x000fe200078e021eULL, 0x000000003a1b7faeULL, 0x0003e2000b901c46ULL,
0x0000001003847825ULL, 0x000fc800078e0084ULL, 0x000000101d1d7824ULL, 0x000fe200078e021eULL,
0x0000000084617faeULL, 0x0003e2000b901c46ULL, 0x0000001003867825ULL, 0x000fca00078e0086ULL,
0x00000000861d7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff037624ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x0000000203a27824ULL, 0x000fe400078e02a2ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x000000c3a200720cULL, 0x000fda0003f06070ULL,
0x00000002cb1a8824ULL, 0x000fe400078e02a2ULL, 0x00000004ff1b8424ULL, 0x00afe200078e00ffULL,
0x0000001000137810ULL, 0x000fe20007ffe0ffULL, 0x00000020021c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000060001a1a8625ULL, 0x000fe200078e001bULL,
0xffffffe01c137812ULL, 0x000fe200078ee213ULL, 0x00000000ad24783bULL, 0x000fe80000000200ULL,
0x000000061a038981ULL, 0x0002a2000c1e1900ULL, 0x0000001013137824ULL, 0x000fe200078e00ffULL,
0x0000001200197810ULL, 0x000fe20007ffe0ffULL, 0x0000002002307824ULL, 0x000fe200078e00ffULL,
0x00000000ae1c783bULL, 0x000fe80000000200ULL, 0x000000001320783bULL, 0x0007220000000200ULL,
0xffffffe030197812ULL, 0x000fe200078ee219ULL, 0x00000020021a7824ULL, 0x002fc400078e00ffULL,
0x00000000ab28783bULL, 0x000e640000000200ULL, 0x0000001019197824ULL, 0x000fe400078e00ffULL,
0x00000000aa2c783bULL, 0x000e620000000200ULL, 0x0000001400137810ULL, 0x008fc60007ffe0ffULL,
0x00000000a934783bULL, 0x000fe20000000200ULL, 0xffffffe01a137812ULL, 0x000fc600078ee213ULL,
0x000000001930783bULL, 0x0006640000000200ULL, 0x0000001013137824ULL, 0x000fe400078e00ffULL,
0x00000000a638783bULL, 0x000fe20000000200ULL, 0x0000001600197810ULL, 0x008fc60007ffe0ffULL,
0x00000000b758783bULL, 0x000fe20000000200ULL, 0xffffffe01a197812ULL, 0x000fc600078ee219ULL,
0x00000000b83c783bULL, 0x000fe20000000200ULL, 0x00000300071a7a10ULL, 0x000fe20007ffe0ffULL,
0x0000001019197824ULL, 0x000fc800078e00ffULL, 0x000001001a1b7824ULL, 0x040fe200078e02c9ULL,
0x0000001c2080723cULL, 0x050f700000001880ULL, 0x0000001e207c723cULL, 0x040b64000000187cULL,
0x00000000a51c783bULL, 0x020eec0000000200ULL, 0x000000242040723cULL, 0x040ff00000001840ULL,
0x000000262044723cULL, 0x040be40000001844ULL, 0x00000000a424783bULL, 0x020f2c0000000200ULL,
0x000000282048723cULL, 0x042f700000001848ULL, 0x0000002a204c723cULL, 0x040b64000000184cULL,
0x00000000b428783bULL, 0x020fec0000000200ULL, 0x0000002c2050723cULL, 0x040f700000001850ULL,
0x0000002e2054723cULL, 0x000b640000001854ULL, 0x00000000b220783bULL, 0x020fe80000000200ULL,
0x00000000b52c783bULL, 0x000fe40000000200ULL, 0x000000343080723cULL, 0x040f700000001880ULL,
0x00000036307c723cULL, 0x040b64000000187cULL, 0x000000001334783bULL, 0x020e6c0000000200ULL,
0x0000001c3048723cULL, 0x048ff00000001848ULL, 0x0000001e304c723cULL, 0x040be4000000184cULL,
0x00000000b61c783bULL, 0x020eec0000000200ULL, 0x000000383040723cULL, 0x040f700000001840ULL,
0x0000003a3044723cULL, 0x040b640000001844ULL, 0x00000000b938783bULL, 0x020fec0000000200ULL,
0x000000243050723cULL, 0x050f700000001850ULL, 0x000000263054723cULL, 0x000b640000001854ULL,
0x000000001924783bULL, 0x020f280000000200ULL, 0x00000000ba30783bULL, 0x000ee40000000200ULL,
0x000000203480723cULL, 0x042f700000001880ULL, 0x00000022347c723cULL, 0x040f70000000187cULL,
0x000000283440723cULL, 0x040f700000001840ULL, 0x0000002a3444723cULL, 0x040f700000001844ULL,
0x0000002c3448723cULL, 0x040f700000001848ULL, 0x0000002e344c723cULL, 0x040f70000000184cULL,
0x0000001c3450723cULL, 0x048b6e0000001850ULL, 0x000000011a1c7810ULL, 0x020fe20007ffe0ffULL,
0x0000001e3454723cULL, 0x000f660000001854ULL, 0x000000051c00720cULL, 0x000fc40003f06070ULL,
0x000000401b1c7812ULL, 0x000fc600078ec0ffULL, 0x000000582480723cULL, 0x010b640000001880ULL,
0x00000001c7297824ULL, 0x000fcc00078e021cULL, 0x0000005a247c723cULL, 0x040b70000000187cULL,
0x0000003c2440723cULL, 0x040b700000001840ULL, 0x0000003e2444723cULL, 0x040b700000001844ULL,
0x000000382448723cULL, 0x040b700000001848ULL, 0x0000003a244c723cULL, 0x040b70000000184cULL,
0x000000302450723cULL, 0x040b700000001850ULL, 0x000000322454723cULL, 0x020b620000001854ULL,
0x000000c803137224ULL, 0x004fe200078e02ffULL, 0x0000098000008947ULL, 0x000fcc0003800000ULL,
0x0000001b06197217ULL, 0x020fe20007800000ULL, 0x00000001c41c7824ULL, 0x000fc400078e0229ULL,
0x000000010a1e7824ULL, 0x000fe400078e0229ULL, 0x0000000119197824ULL, 0x000fe200078e0a1bULL,
0x0000001c13227210ULL, 0x000fe20007f1e0ffULL, 0x00000001091c7824ULL, 0x000fe200078e0229ULL,
0x0000001e131e7210ULL, 0x000fe40007f9e0ffULL, 0x000000190900720cULL, 0x000fe20003f46070ULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000001c131c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e06ffULL, 0x00005e0022217a11ULL, 0x000fc400078048ffULL,
0x000000190a00720cULL, 0x080fe20003f26070ULL, 0x000000ffff1f7224ULL, 0x000fe200018e06ffULL,
0x00005f0022227a11ULL, 0x000fe200000f4c09ULL, 0x000000010b0a7824ULL, 0x000fe200078e0229ULL,
0x00005e001c1d7a11ULL, 0x000fe400078048ffULL, 0x00005e001e097a11ULL, 0x000fe400078648ffULL,
0x00005f001c1f7a11ULL, 0x000fe200000f4c1fULL, 0x000000010c1c7824ULL, 0x100fe200078e0229ULL,
0x0000000a13277210ULL, 0x000fe20007f1e0ffULL, 0x000000010d0a7824ULL, 0x000fe200078e0229ULL,
0x000000190b00720cULL, 0x000fe20003f86070ULL, 0x00000010a10b7824ULL, 0x000fe200078e00ffULL,
0x0000001c131c7210ULL, 0x000fc40007fde0ffULL, 0x00005f001e207a11ULL, 0x000fe200018f4c1bULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078648ffULL,
0x000000ffff237224ULL, 0x000fe200030e06ffULL, 0x000000700b287812ULL, 0x000fe400078ec0ffULL,
0x00005e001c1b7a11ULL, 0x000fe400078048ffULL, 0x00000019c400720cULL, 0x000fe40003fa6070ULL,
0x00005f0027277a11ULL, 0x000fc400018f4c1eULL, 0x0000000a13257210ULL, 0x000fe40007f7e0ffULL,
0x00000021280a7210ULL, 0x000fe40007fde0ffULL, 0x00005f001c237a11ULL, 0x000fe200000f4c23ULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x0000001d281c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e0622ULL, 0x000000190c00720cULL, 0x080fe20003f66070ULL,
0x000000010e0c7824ULL, 0x000fe200078e0229ULL, 0x00005e0025217a11ULL, 0x000fe200078c48ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000aa07faeULL, 0x0003e2000e901c46ULL, 0x000000190d00720cULL, 0x000fc40003f06070ULL,
0x0000000c13247210ULL, 0x000fe20007fbe0ffULL, 0x000000001c9f7faeULL, 0x0005e2000d101c46ULL,
0x00005f0025257a11ULL, 0x000fe200030f4c1eULL, 0x000000010f1e7824ULL, 0x000fe200078e0229ULL,
0x00000009280c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0x00005e00241f7a11ULL, 0x040fe400078a48ffULL, 0x0000001e13227210ULL, 0x040fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0620ULL, 0x00005f0024247a11ULL, 0x000fe200028f4c09ULL,
0x00000001100a7824ULL, 0x102fe200078e0229ULL, 0x00005e00221e7a11ULL, 0x000fe200078a48ffULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x000000000c9e7faeULL, 0x0003e2000c901c46ULL,
0x000000190e00720cULL, 0x000fe20003f46070ULL, 0x00000001120e7824ULL, 0x000fe200078e0229ULL,
0x0000000a13207210ULL, 0x000fc40007f3e0ffULL, 0x00000026280a7210ULL, 0x000fe40007fde0ffULL,
0x00005f0022227a11ULL, 0x000fe400028f4c09ULL, 0x0000001b281c7210ULL, 0x004fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e0627ULL, 0x000000190f00720cULL, 0x000fe20003fc6070ULL,
0x00000001110c7824ULL, 0x002fe400078e0229ULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x00005e0020097a11ULL, 0x000fe200078248ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e0623ULL,
0x000000000a9d7faeULL, 0x0003e2000e101c46ULL, 0x0000000c13237210ULL, 0x000fc40007f9e0ffULL,
0x00005f0020207a11ULL, 0x000fe200008f4c1bULL, 0x000000001c9c7faeULL, 0x0005e2000d901c46ULL,
0x000000191000720cULL, 0x000fe20003fa6070ULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x00000021280c7210ULL, 0x000fe40007f3e0ffULL, 0x00005e00231b7a11ULL, 0x000fc600078848ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e0625ULL, 0x0000000e13217210ULL, 0x000fe40007f3e0ffULL,
0x00005f0023237a11ULL, 0x000fe200020f4c10ULL, 0x00000001141c7824ULL, 0x104fe200078e0229ULL,
0x0000001f280e7210ULL, 0x040fe20007f7e0ffULL, 0x000000000c9b7faeULL, 0x0005e2000c101c46ULL,
0x0000001e280a7210ULL, 0x042fe20007f9e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x000000191100720cULL, 0x000fe20003f26070ULL, 0x000000ffff0f7224ULL, 0x000fe200018e0624ULL,
0x00005e00211f7a11ULL, 0x000fe200078648ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0622ULL,
0x0000000928107210ULL, 0x000fe20007f9e0ffULL, 0x0000000117227824ULL, 0x100fe200078e0229ULL,
0x00005f0021217a11ULL, 0x000fe200018f4c1eULL, 0x00000001151e7824ULL, 0x100fe200078e0229ULL,
0x0000001c13097210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0620ULL,
0x000000000e9a7faeULL, 0x0003e2000d101c46ULL, 0x0000000116207824ULL, 0x100fe200078e0229ULL,
0x0000001e131e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0c7224ULL, 0x004fe200000e06ffULL,
0x000000000a997faeULL, 0x0005e2000f101c46ULL, 0x00000001181c7824ULL, 0x000fe200078e0229ULL,
0x0000002213227210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e06ffULL,
0x0000000010987faeULL, 0x0007e2000e901c46ULL, 0x0000002013207210ULL, 0x000fc40007fbe0ffULL,
0x000000191200720cULL, 0x000fe40003f46070ULL, 0x00005e00090e7a11ULL, 0x002fe400078c48ffULL,
0x0000001c131c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x0000001b280a7210ULL, 0x004fe40007f9e0ffULL, 0x00005f0009097a11ULL, 0x000fe200030f4c0cULL,
0x000000ffff117224ULL, 0x008fe200028e06ffULL, 0x00005e001e1b7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e0623ULL, 0x00005e0020107a11ULL, 0x000fc400078a48ffULL,
0x000000191400720cULL, 0x000fe40003f86070ULL, 0x00005f001e1d7a11ULL, 0x000fe200030f4c1dULL,
0x000000000a977faeULL, 0x0003e2000c901c46ULL, 0x0000001f280c7210ULL, 0x000fe40007fde0ffULL,
0x00005f0020117a11ULL, 0x000fe400028f4c11ULL, 0x0000000e280e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e0621ULL, 0x00005e0022127a11ULL, 0x000fc400078048ffULL,
0x000000191500720cULL, 0x000fe20003f26070ULL, 0x000000ffff0f7224ULL, 0x000fe200028e0609ULL,
0x000000000c967faeULL, 0x0005e2000d101c46ULL, 0x000000ffff0b7224ULL, 0x002fe200018e06ffULL,
0x0000001b280a7210ULL, 0x000fe40007f7e0ffULL, 0x000000000e957faeULL, 0x0003e2000e101c46ULL,
0x00005e001c097a11ULL, 0x000fe400078848ffULL, 0x0000001028107210ULL, 0x000fe40007f5e0ffULL,
0x000000191600720cULL, 0x000fc40003fc6070ULL, 0x000000191700720cULL, 0x080fe20003fa6070ULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x00005f0022137a11ULL, 0x000fe400000f4c13ULL,
0x000000191800720cULL, 0x000fe40003f06070ULL, 0x00005f001c147a11ULL, 0x000fe200020f4c0bULL,
0x000000ffff0b7224ULL, 0x000fe200018e061dULL, 0x0000001228127210ULL, 0x040fe40007f7e0ffULL,
0x00000009280c7210ULL, 0x004fc40007f5e0ffULL, 0x000000000a947faeULL, 0x0003e2000c901c46ULL,
0x000000ffff137224ULL, 0x000fe400018e0613ULL, 0x000000ffff0d7224ULL, 0x000fe200010e0614ULL,
0x0000000010937faeULL, 0x0003e8000f101c46ULL, 0x0000000012927faeULL, 0x0003e8000e901c46ULL,
0x000000000c917faeULL, 0x0003e2000c101c46ULL, 0x0000085000007947ULL, 0x000fea0003800000ULL,
0x00000001091c7824ULL, 0x120fe400078e0229ULL, 0x00000001c4c47824ULL, 0x000fc400078e0229ULL,
0x000000010c227824ULL, 0x100fe200078e0229ULL, 0x0000001c131c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010b207824ULL, 0x100fe200078e0229ULL, 0x000000c413c47210ULL, 0x000fe20007f1e0ffULL,
0x000000010d247824ULL, 0x100fe200078e0229ULL, 0x0000002213227210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x00005e001c0c7a11ULL, 0x000fe200078248ffULL,
0x000000010a1e7824ULL, 0x100fe200078e0229ULL, 0x0000002413247210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e00c40a7a11ULL, 0x000fe200078048ffULL,
0x000000010f287824ULL, 0x000fe200078e0229ULL, 0x00005f001c1c7a11ULL, 0x000fe200008f4c0bULL,
0x0000000112327824ULL, 0x000fe200078e0229ULL, 0x0000002013207210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e06ffULL, 0x00005f00c4097a11ULL, 0x000fe200000f4c09ULL,
0x00000001102a7824ULL, 0x100fe200078e0229ULL, 0x0000001e131e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001112c7824ULL, 0x100fe200078e0229ULL, 0x00005e0022127a11ULL, 0x000fe200078448ffULL,
0x0000000114347824ULL, 0x000fc400078e0229ULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0x00005e0020107a11ULL, 0x000fe200078248ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005e0024147a11ULL, 0x000fe200078648ffULL, 0x000000010e267824ULL, 0x000fe200078e0229ULL,
0x00005f0022227a11ULL, 0x000fe200010f4c0fULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005e001e0e7a11ULL, 0x000fe200078048ffULL, 0x00000001183e7824ULL, 0x100fe200078e0229ULL,
0x0000002a132a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000116387824ULL, 0x000fe200078e0229ULL,
0x00005f0020207a11ULL, 0x000fe200008f4c0dULL, 0x0000000115367824ULL, 0x000fe200078e0229ULL,
0x00005f0024247a11ULL, 0x000fe200018f4c11ULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x0000002813287210ULL, 0x000fe20007f3e0ffULL, 0x00000001173a7824ULL, 0x000fe200078e0229ULL,
0x0000002c13117210ULL, 0x000fc40007f7e0ffULL, 0x00005f001e1e7a11ULL, 0x000fe200000f4c0bULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x0000002613267210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e002a2c7a11ULL, 0x000fe400078448ffULL,
0x00005e0028187a11ULL, 0x000fe200078248ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005e0011307a11ULL, 0x000fe400078648ffULL, 0x00005f002a2a7a11ULL, 0x000fc400010f4c0fULL,
0x00005e0026167a11ULL, 0x000fe400078048ffULL, 0x0000003213327210ULL, 0x000fe40007f5e0ffULL,
0x00005f0028287a11ULL, 0x000fe400008f4c0dULL, 0x00005f00112e7a11ULL, 0x000fe400018f4c2eULL,
0x00000034130d7210ULL, 0x000fe40007f7e0ffULL, 0x00005f0026267a11ULL, 0x000fe200000f4c0bULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00005e0032347a11ULL, 0x000fc400078448ffULL,
0x00000036130f7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x0000003813117210ULL, 0x040fe40007f1e0ffULL, 0x0000003a13157210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200028e06ffULL, 0x0000003e13137210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005f0032327a11ULL, 0x000fe200010f4c0bULL,
0x00000010a10b7824ULL, 0x000fe200078e00ffULL, 0x00005e0013607a11ULL, 0x000fe200078448ffULL,
0x000000ffff5e7224ULL, 0x000fe200018e06ffULL, 0x00005e0011587a11ULL, 0x000fe200078048ffULL,
0x000000ffff5a7224ULL, 0x000fe200008e06ffULL, 0x000000700b2b7812ULL, 0x000fc400078ec0ffULL,
0x00005e00155c7a11ULL, 0x000fe400078248ffULL, 0x00005e000f3c7a11ULL, 0x000fe400078a48ffULL,
0x00005f00135e7a11ULL, 0x000fe400010f4c5eULL, 0x00005e000d387a11ULL, 0x000fe400078848ffULL,
0x0000000a2b0a7210ULL, 0x000fe40007f5e0ffULL, 0x00005f00155a7a11ULL, 0x000fc400008f4c5aULL,
0x0000000c2b0c7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e0609ULL,
0x00005f00113e7a11ULL, 0x000fe400000f4c3eULL, 0x0000000e2b0e7210ULL, 0x000fe40007f3e0ffULL,
0x00005f000f3a7a11ULL, 0x000fe200028f4c3aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000aa07faeULL, 0x0003e2000b901c46ULL, 0x000000102b107210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e061eULL, 0x00005f000d367a11ULL, 0x000fe200020f4c36ULL,
0x000000ffff0d7224ULL, 0x000fe200030e061cULL, 0x000000122b127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0620ULL, 0x000000142b147210ULL, 0x000fc40007f9e0ffULL,
0x000000162b167210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e0622ULL,
0x000000182b187210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200020e0624ULL,
0x0000002c2b1c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200018e0626ULL,
0x000000302b1e7210ULL, 0x040fe20007f1e0ffULL, 0x000000000c9f7faeULL, 0x0003e2000b901c46ULL,
0x000000342b207210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0628ULL,
0x000000382b227210ULL, 0x040fe20007f9e0ffULL, 0x000000000e9e7faeULL, 0x0003e2000b901c46ULL,
0x0000003c2b247210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e062aULL,
0x000000582b267210ULL, 0x040fe20007f5e0ffULL, 0x00000000109d7faeULL, 0x0003e2000b901c46ULL,
0x0000005c2b287210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e062eULL,
0x000000602b2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000000129c7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff217224ULL, 0x000fc400028e0632ULL, 0x000000ffff237224ULL, 0x000fe200020e0636ULL,
0x00000000149b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff257224ULL, 0x000fe400018e063aULL,
0x000000ffff277224ULL, 0x000fe200010e063eULL, 0x00000000169a7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fe400008e065aULL, 0x000000ffff2b7224ULL, 0x000fe200000e065eULL,
0x0000000018997faeULL, 0x0003e8000b901c46ULL, 0x000000001c987faeULL, 0x0003e8000b901c46ULL,
0x000000001e977faeULL, 0x0003e8000b901c46ULL, 0x0000000020967faeULL, 0x0003e8000b901c46ULL,
0x0000000022957faeULL, 0x0003e8000b901c46ULL, 0x0000000024947faeULL, 0x0003e8000b901c46ULL,
0x0000000026937faeULL, 0x0003e8000b901c46ULL, 0x0000000028927faeULL, 0x0003e8000b901c46ULL,
0x000000002a917faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020020a7824ULL, 0x002fe200078e00ffULL, 0x0000001800097810ULL, 0x000fe20007ffe0ffULL,
0x00000020020b7824ULL, 0x000fc400078e00ffULL, 0x0000002002187824ULL, 0x000fe200078e00ffULL,
0xffffffe00a097812ULL, 0x000fe400078ee209ULL, 0x0000001a000a7810ULL, 0x000fc60007ffe0ffULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0xffffffe00b0a7812ULL, 0x000fca00078ee20aULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000c210783bULL, 0x000fe80000000200ULL, 0x00000000090c783bULL, 0x0002a80000000200ULL,
0x00000000c11c783bULL, 0x000ee80000000200ULL, 0x00000000c020783bULL, 0x000f220000000200ULL,
0x0000001c00097810ULL, 0x002fc40007ffe0ffULL, 0x0000001e00007810ULL, 0x000fe20007ffe0ffULL,
0x00000000bf14783bULL, 0x000e620000000200ULL, 0xffffffe018097812ULL, 0x000fe400078ee209ULL,
0xffffffe00b007812ULL, 0x000fe200078ee200ULL, 0x00000000be24783bULL, 0x000fe40000000200ULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x00000000bd28783bULL, 0x000fe20000000200ULL,
0x0000001000007824ULL, 0x000fc600078e00ffULL, 0x00000000bc2c783bULL, 0x000fe80000000200ULL,
0x00000000bbb8783bULL, 0x000fe80000000200ULL, 0x00000000a7a4783bULL, 0x000fe80000000200ULL,
0x00000000a8a8783bULL, 0x000fe20000000200ULL, 0x000000100c80723cULL, 0x044f700000001880ULL,
0x000000120c7c723cULL, 0x040b64000000187cULL, 0x000000000a10783bULL, 0x020eac0000000200ULL,
0x0000001c0c40723cULL, 0x048f700000001840ULL, 0x0000001e0c44723cULL, 0x040b640000001844ULL,
0x00000000091c783bULL, 0x020fec0000000200ULL, 0x000000200c48723cULL, 0x050f700000001848ULL,
0x000000220c4c723cULL, 0x040b64000000184cULL, 0x00000000b320783bULL, 0x020eec0000000200ULL,
0x000000140c50723cULL, 0x042f700000001850ULL, 0x000000160c54723cULL, 0x000b640000001854ULL,
0x00000000b10c783bULL, 0x020e680000000200ULL, 0x00000000b014783bULL, 0x000f240000000200ULL,
0x000000241080723cULL, 0x044f700000001880ULL, 0x00000026107c723cULL, 0x040b64000000187cULL,
0x000000000024783bULL, 0x020fec0000000200ULL, 0x000000281040723cULL, 0x040f700000001840ULL,
0x0000002a1044723cULL, 0x040b640000001844ULL, 0x00000000ac28783bULL, 0x020fec0000000200ULL,
0x0000002c1048723cULL, 0x040f700000001848ULL, 0x0000002e104c723cULL, 0x040f70000000184cULL,
0x000000b81050723cULL, 0x040f700000001850ULL, 0x000000ba1054723cULL, 0x000b640000001854ULL,
0x00000000af10783bULL, 0x020eac0000000200ULL, 0x000000201c80723cULL, 0x048f700000001880ULL,
0x000000221c7c723cULL, 0x040b64000000187cULL, 0x00000000a320783bULL, 0x020eec0000000200ULL,
0x0000000c1c40723cULL, 0x042f700000001840ULL, 0x0000000e1c44723cULL, 0x040f700000001844ULL,
0x000000141c48723cULL, 0x050ff00000001848ULL, 0x000000161c4c723cULL, 0x040ff0000000184cULL,
0x000000101c50723cULL, 0x044ff00000001850ULL, 0x000000121c54723cULL, 0x000ff00000001854ULL,
0x000000282480723cULL, 0x040f700000001880ULL, 0x0000002a247c723cULL, 0x040f70000000187cULL,
0x000000a42440723cULL, 0x060f700000001840ULL, 0x000000a62444723cULL, 0x000f620000001844ULL,
0x3d80000080807820ULL, 0x000fc40000410000ULL, 0x3d80000081817820ULL, 0x000fe40000410000ULL,
0x3d80000082827820ULL, 0x000fe40000410000ULL, 0x3d80000083837820ULL, 0x000fe20000410000ULL,
0x000000a82448723cULL, 0x000f620000001848ULL, 0x3d8000007c7c7820ULL, 0x000fe40000410000ULL,
0x3d8000007d7d7820ULL, 0x000fe40000410000ULL, 0x3d8000007e7e7820ULL, 0x000fc40000410000ULL,
0x3d8000007f7f7820ULL, 0x000fe20000410000ULL, 0x000000aa244c723cULL, 0x040f64000000184cULL,
0x3d80000040407820ULL, 0x020fe40000410000ULL, 0x3d80000041417820ULL, 0x000fe40000410000ULL,
0x3d80000042427820ULL, 0x000fe40000410000ULL, 0x3d80000043437820ULL, 0x000fe20000410000ULL,
0x000000202450723cULL, 0x008f620000001850ULL, 0x3d80000044447820ULL, 0x000fc40000410000ULL,
0x3d80000045457820ULL, 0x000fe40000410000ULL, 0x3d80000046467820ULL, 0x000fe40000410000ULL,
0x3d80000047477820ULL, 0x000fe20000410000ULL, 0x000000222454723cULL, 0x000f620000001854ULL,
0x3d80000048487820ULL, 0x000fe40000410000ULL, 0x3d80000049497820ULL, 0x000fe40000410000ULL,
0x3d8000004a4a7820ULL, 0x000fc40000410000ULL, 0x3d8000004b4b7820ULL, 0x000fe40000410000ULL,
0x3d8000004c4c7820ULL, 0x000fe40000410000ULL, 0x3d8000004d4d7820ULL, 0x000fe40000410000ULL,
0x3d8000004e4e7820ULL, 0x000fe40000410000ULL, 0x3d8000004f4f7820ULL, 0x000fe40000410000ULL,
0x3d80000050507820ULL, 0x020fc40000410000ULL, 0x3d80000051517820ULL, 0x000fe40000410000ULL,
0x3d80000052527820ULL, 0x000fe40000410000ULL, 0x3d80000053537820ULL, 0x000fe40000410000ULL,
0x3d80000054547820ULL, 0x000fe40000410000ULL, 0x3d80000055557820ULL, 0x000fe40000410000ULL,
0x3d80000056567820ULL, 0x000fc40000410000ULL, 0x3d80000057577820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000c50e7f8cULL, 0x0002a4000c80043fULL,
0x00000000000a7805ULL, 0x000fc40000015200ULL, 0x00000400c5097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a097210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e0bULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140cULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e060cULL, 0x0000000200007819ULL, 0x000fc80000001209ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000102027810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400c5097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004a1027824ULL, 0x000fe200078e00ffULL,
0x000000ca0700720cULL, 0x000fc80003f05270ULL, 0xfffffff002097812ULL, 0x000fca00078ec0ffULL,
0x0000008008007824ULL, 0x000fca00078e0209ULL, 0x01c40000000c7984ULL, 0x0004e20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002a1077824ULL, 0x000fe400078e00ffULL,
0x00000001060b7824ULL, 0x000fc600078e0a04ULL, 0x0000000607077812ULL, 0x000fc800078ec0ffULL,
0x0000000107047812ULL, 0x040fe400078efcffULL, 0x0000000807097812ULL, 0x040fe400078efcffULL,
0x0000000b0400720cULL, 0x080fe40003f26070ULL, 0x0000001007047812ULL, 0x000fe400078efcffULL,
0x0000000b0900720cULL, 0x080fe40003f06070ULL, 0x0000000b0400720cULL, 0x000fc40003fc6070ULL,
0x0000001107097812ULL, 0x040fe400078efcffULL, 0x0000001807047812ULL, 0x040fe400078efcffULL,
0x0000000b0700720cULL, 0x080fe40003f46070ULL, 0x0000000b0900720cULL, 0x080fe40003fa6070ULL,
0x0000000b0400720cULL, 0x000fe40003f66070ULL, 0x00000009070a7812ULL, 0x000fc400078efcffULL,
0x0000001907097812ULL, 0x040fe400078efcffULL, 0x0000002007047812ULL, 0x000fe400078efcffULL,
0xff80000082827808ULL, 0x000fe40005000000ULL, 0xff80000080807808ULL, 0x000fe40005000000ULL,
0xff80000083837808ULL, 0x000fe40004800000ULL, 0xff80000081817808ULL, 0x000fc40004800000ULL,
0x0000000b0a00720cULL, 0x080fe40003f86070ULL, 0x0000000b0900720cULL, 0x080fe40003f46070ULL,
0x0000000b0400720cULL, 0x000fe40003f26070ULL, 0x0000002107097812ULL, 0x040fe400078efcffULL,
0x0000002807047812ULL, 0x000fe400078efcffULL, 0xff8000007e7e7808ULL, 0x000fc40004000000ULL,
0xff8000007c7c7808ULL, 0x000fe40004000000ULL, 0xff8000007f7f7808ULL, 0x000fe40006000000ULL,
0xff8000007d7d7808ULL, 0x000fe40006000000ULL, 0x0000000b0900720cULL, 0x080fe40003f06070ULL,
0x0000000b0400720cULL, 0x000fe40003f86070ULL, 0x0000002907097812ULL, 0x000fc400078efcffULL,
0x0000003007047812ULL, 0x000fe400078efcffULL, 0xff80000042427808ULL, 0x000fe40007000000ULL,
0xff80000040407808ULL, 0x000fe40007000000ULL, 0xff80000043437808ULL, 0x000fe40006800000ULL,
0xff80000041417808ULL, 0x000fe40006800000ULL, 0x0000000b0900720cULL, 0x000fc40003fc6070ULL,
0x0000000b0400720cULL, 0x000fe40003fa6070ULL, 0x0000003107097812ULL, 0x040fe400078efcffULL,
0x0000003807047812ULL, 0x040fe400078efcffULL, 0x0000003907077812ULL, 0x000fe400078efcffULL,
0xff80000046467808ULL, 0x000fe40005800000ULL, 0xff80000044447808ULL, 0x000fc40005800000ULL,
0xff80000047477808ULL, 0x000fe40005000000ULL, 0xff80000045457808ULL, 0x000fe40005000000ULL,
0xff8000004a4a7808ULL, 0x000fe40004800000ULL, 0xff80000048487808ULL, 0x000fe40004800000ULL,
0x0000000b0900720cULL, 0x080fe40003f66070ULL, 0x0000000b0400720cULL, 0x000fc40003f46070ULL,
0x0000000b0700720cULL, 0x000fe40003f26070ULL, 0xff8000004b4b7808ULL, 0x000fe40004000000ULL,
0xff80000049497808ULL, 0x000fe40004000000ULL, 0xff8000004e4e7808ULL, 0x000fe40006000000ULL,
0xff8000004c4c7808ULL, 0x000fe40006000000ULL, 0xff8000004f4f7808ULL, 0x000fc40007000000ULL,
0xff8000004d4d7808ULL, 0x000fe40007000000ULL, 0xff80000052527808ULL, 0x000fe40006800000ULL,
0xff80000050507808ULL, 0x000fe40006800000ULL, 0xff80000053537808ULL, 0x000fe40005800000ULL,
0xff80000051517808ULL, 0x000fe40005800000ULL, 0xff80000056567808ULL, 0x000fc40005000000ULL,
0xff80000054547808ULL, 0x000fe40005000000ULL, 0xff80000057577808ULL, 0x000fe40004800000ULL,
0xff80000055557808ULL, 0x000fc40004800000ULL, 0x000000800c00720bULL, 0x008fe40003f1e000ULL,
0x000000820d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c800c7208ULL, 0x000fe40004000000ULL,
0x0000000d82047208ULL, 0x000fc40004800000ULL, 0x000000810c00720bULL, 0x000fe40003f1e000ULL,
0x000000830400720bULL, 0x000fe40003f3e000ULL, 0x0000000c81077208ULL, 0x000fe40004000000ULL,
0x0000000483097208ULL, 0x000fe40004800000ULL, 0x0000007c0700720bULL, 0x000fe40003f1e000ULL,
0x0000007e0900720bULL, 0x000fc40003f3e000ULL, 0x000000077c047208ULL, 0x000fe40004000000ULL,
0x000000097e0a7208ULL, 0x000fe40004800000ULL, 0x0000007d0400720bULL, 0x000fe40003f1e000ULL,
0x0000007f0a00720bULL, 0x000fe40003f3e000ULL, 0x000000047d077208ULL, 0x000fe40004000000ULL,
0x0000000a7f097208ULL, 0x000fc40004800000ULL, 0x000000400700720bULL, 0x000fe40003f1e000ULL,
0x000000420900720bULL, 0x000fe40003f3e000ULL, 0x0000000740047208ULL, 0x000fe40004000000ULL,
0x00000009420a7208ULL, 0x000fe40004800000ULL, 0x000000410400720bULL, 0x000fe40003f1e000ULL,
0x000000430a00720bULL, 0x000fc40003f3e000ULL, 0x0000000441077208ULL, 0x000fe40004000000ULL,
0x0000000a43097208ULL, 0x000fe40004800000ULL, 0x000000440700720bULL, 0x000fe40003f1e000ULL,
0x000000460900720bULL, 0x000fe40003f3e000ULL, 0x0000000744047208ULL, 0x000fe40004000000ULL,
0x00000009460a7208ULL, 0x000fc40004800000ULL, 0x000000450400720bULL, 0x000fe40003f1e000ULL,
0x000000470a00720bULL, 0x000fe40003f3e000ULL, 0x0000000445077208ULL, 0x000fe40004000000ULL,
0x0000000a47097208ULL, 0x000fe40004800000ULL, 0x000000480700720bULL, 0x000fe40003f1e000ULL,
0x0000004a0900720bULL, 0x000fc40003f3e000ULL, 0x0000000748047208ULL, 0x000fe40004000000ULL,
0x000000094a0a7208ULL, 0x000fe40004800000ULL, 0x000000490400720bULL, 0x000fe40003f1e000ULL,
0x0000004b0a00720bULL, 0x000fe40003f3e000ULL, 0x0000000449077208ULL, 0x000fe40004000000ULL,
0x0000000a4b097208ULL, 0x000fc40004800000ULL, 0x0000004c0700720bULL, 0x000fe40003f1e000ULL,
0x0000004e0900720bULL, 0x000fe40003f3e000ULL, 0x000000074c047208ULL, 0x000fe40004000000ULL,
0x000000094e0a7208ULL, 0x000fe40004800000ULL, 0x0000004d0400720bULL, 0x000fe40003f1e000ULL,
0x0000004f0a00720bULL, 0x000fc40003f3e000ULL, 0x000000044d077208ULL, 0x000fe40004000000ULL,
0x0000000a4f097208ULL, 0x000fe40004800000ULL, 0x000000500700720bULL, 0x000fe40003f1e000ULL,
0x000000520900720bULL, 0x000fe40003f3e000ULL, 0x0000000750047208ULL, 0x000fe40004000000ULL,
0x00000009520a7208ULL, 0x000fc40004800000ULL, 0x000000510400720bULL, 0x000fe40003f1e000ULL,
0x000000530a00720bULL, 0x000fe40003f3e000ULL, 0x0000000451077208ULL, 0x000fe40004000000ULL,
0x0000000a53097208ULL, 0x000fe40004800000ULL, 0x000000540700720bULL, 0x000fe40003f1e000ULL,
0x000000560900720bULL, 0x000fc40003f3e000ULL, 0x0000000754047208ULL, 0x000fe40004000000ULL,
0x00000009560a7208ULL, 0x000fe40004800000ULL, 0x000000550400720bULL, 0x000fe40003f1e000ULL,
0x000000570a00720bULL, 0x000fe40003f3e000ULL, 0x0000000455077208ULL, 0x000fe40004000000ULL,
0x0000000a57097208ULL, 0x000fe20004800000ULL, 0x000018f27f007947ULL, 0x000fec000b800000ULL,
0x0c401f0007047f89ULL, 0x00066400000e0000ULL, 0x000000040700720bULL, 0x006fc80003f1e000ULL,
0x0000000704117208ULL, 0x000fe20004000000ULL, 0x000019127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0009047f89ULL, 0x000e6800000e0000ULL, 0x0c401f000e077f89ULL, 0x008ea800000e0000ULL,
0x0c401f000f0a7f89ULL, 0x000ee800000e0000ULL, 0x0c201f00110c7f89ULL, 0x000f2200000e0000ULL,
0x000000040900720bULL, 0x002fc40003f1e000ULL, 0x000000070e00720bULL, 0x004fe40003f3e000ULL,
0x0000000904047208ULL, 0x000fe40004000000ULL, 0x0000000e07077208ULL, 0x000fe40004800000ULL,
0x0000000a0f00720bULL, 0x008fe20003f1e000ULL, 0x0c201f00040d7f89ULL, 0x000e6600000e0000ULL,
0x0000000f0a097208ULL, 0x000fe20004000000ULL, 0x0c201f0007107f89ULL, 0x000ea200000e0000ULL,
0x0000000c1100720bULL, 0x010fc60003f1e000ULL, 0x0c201f00090a7f89ULL, 0x0006e200000e0000ULL,
0x000000110c0c7208ULL, 0x000fe40004000000ULL, 0x0000000d0400720bULL, 0x002fe40003f3e000ULL,
0x000000100700720bULL, 0x004fe40003f5e000ULL, 0x000000040d0d7208ULL, 0x000fe40004800000ULL,
0x00000007100e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c047820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0d0b7820ULL, 0x000fe20000410000ULL,
0x00000002ff0f7819ULL, 0x000fe200000116a1ULL, 0x3fb8aa3b81817823ULL, 0x100fe20000010804ULL,
0x0000000c02307812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b7d7d7823ULL, 0x100fe20000010804ULL,
0x000000080f2d7810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b80807823ULL, 0x100fe20000010804ULL,
0x000000020f197810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b7c7c7823ULL, 0x000fe20000010804ULL,
0x0000008100817308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b82827823ULL, 0x100fe2000001080bULL,
0x000000030f1b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b83837823ULL, 0x100fe2000001080bULL,
0xffffffff0f297810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b7e7e7823ULL, 0x100fe2000001080bULL,
0x00000003a1ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b7f7f7823ULL, 0x000fe2000001080bULL,
0x0000008000107308ULL, 0x002e620000000800ULL, 0x3c003c00ff2a7424ULL, 0x000fe200078e00ffULL,
0x0000000a0900720bULL, 0x000fe20003f3e000ULL, 0x3c003c00ff2b7424ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b40407823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010804ULL,
0x0000007c00127308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b44447823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b45457823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b48487823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010804ULL, 0x0000007d007d7308ULL, 0x000ea20000000800ULL,
0x000000108110723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b4c4c7823ULL, 0x000fc40000010804ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b50507823ULL, 0x100fe40000010804ULL,
0x0000008200117308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b51517823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b54547823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b55047823ULL, 0x000fe40000010804ULL,
0x3fb8aa3b42427823ULL, 0x100fe2000001080bULL, 0x0000008300187308ULL, 0x000e620000000800ULL,
0x000000127d12723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b43437823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b46467823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b47477823ULL, 0x100fe4000001080bULL,
0x0000007e00137308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe2000001080bULL, 0x0000007f001c7308ULL, 0x000ea20000000800ULL,
0x000000111811723eULL, 0x002fe200000000ffULL, 0x000000080f277824ULL, 0x040fe200078e00ffULL,
0x000000010f187810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b52527823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b53537823ULL, 0x100fe2000001080bULL, 0xfffffff8272c7812ULL, 0x000fe200078ee218ULL,
0x0000000400077308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b56567823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b570b7823ULL, 0x000fe4000001080bULL, 0x000000080f2e7824ULL, 0x040fe400078e00ffULL,
0x000000080f327824ULL, 0x040fe200078e00ffULL, 0x000000131c13723eULL, 0x004fe200000000ffULL,
0x0000004000147308ULL, 0x000fe20000000800ULL, 0x000000080f287824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee219ULL, 0x000000082d3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee21bULL, 0x000000080f367824ULL, 0x040fe200078e00ffULL,
0x0000002a101c723cULL, 0x000f6200000018ffULL, 0x000000050f197810ULL, 0x040fe20007ffe0ffULL,
0x0000004100417308ULL, 0x000e620000000800ULL, 0x000000060f1b7810ULL, 0x040fe20007ffe0ffULL,
0x000000080f387824ULL, 0x040fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20fULL,
0x000000080f3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fc400078ee22dULL,
0xfffffff836367812ULL, 0x000fe200078ee219ULL, 0x0000004400167308ULL, 0x000fe20000000800ULL,
0xfffffff838387812ULL, 0x000fe400078ee21bULL, 0xfffffff83a3a7812ULL, 0x000fca00078ee229ULL,
0x0000004500457308ULL, 0x000ea20000000800ULL, 0x000000144114723eULL, 0x002fce00000000ffULL,
0x0000004200157308ULL, 0x000ff00000000800ULL, 0x0000004300047308ULL, 0x000e620000000800ULL,
0x000000164516723eULL, 0x004fce00000000ffULL, 0x0000004600177308ULL, 0x000ff00000000800ULL,
0x0000004700207308ULL, 0x000ea20000000800ULL, 0x000000150415723eULL, 0x002fce00000000ffULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x000000172017723eULL, 0x004fce00000000ffULL,
0x0000004900497308ULL, 0x000e620000000800ULL, 0x0000002a1420723cULL, 0x020b6e000000181cULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x000000080f1d7824ULL, 0x060fe200078e00ffULL,
0x000000040f1c7810ULL, 0x000fcc0007ffe0ffULL, 0x0000004d004d7308ULL, 0x000ea20000000800ULL,
0xfffffff81d347812ULL, 0x000fe400078ee21cULL, 0x00000048491c723eULL, 0x002fca00000000ffULL,
0x0000004a004a7308ULL, 0x000ff00000000800ULL, 0x0000004b004b7308ULL, 0x000e620000000800ULL,
0x0000004c4d1e723eULL, 0x004fce00000000ffULL, 0x0000004e004e7308ULL, 0x000ff00000000800ULL,
0x0000004f004f7308ULL, 0x000ea20000000800ULL, 0x0000004a4b1d723eULL, 0x002fce00000000ffULL,
0x0000005000247308ULL, 0x000fe20000000800ULL, 0x0000004e4f1f723eULL, 0x004fce00000000ffULL,
0x0000005100517308ULL, 0x000e620000000800ULL, 0x0000002a1c20723cULL, 0x000f6e0000001820ULL,
0x0000005400267308ULL, 0x000eb00000000800ULL, 0x0000005200257308ULL, 0x000fe20000000800ULL,
0x000000245124723eULL, 0x002fce00000000ffULL, 0x0000005300047308ULL, 0x000e620000000800ULL,
0x000000260726723eULL, 0x004fe400000000ffULL, 0x0001200008077811ULL, 0x000fca00078e58ffULL,
0x0000005600277308ULL, 0x000fe20000000800ULL, 0x000000102e0f7824ULL, 0x100fe400078e0207ULL,
0x0000001028027824ULL, 0x100fe400078e0207ULL, 0x0000001034197824ULL, 0x100fe400078e0207ULL,
0x00000010361b7824ULL, 0x100fe200078e0207ULL, 0x0000000b00187308ULL, 0x0004e20000000800ULL,
0x000000250425723eULL, 0x002fe200000000ffULL, 0x000000102c047824ULL, 0x000fc400078e0207ULL,
0x0000001038287824ULL, 0x100fe400078e0207ULL, 0x0000000130047824ULL, 0x000fe400078e0204ULL,
0x000000103a297824ULL, 0x000fe400078e0207ULL, 0x00000001300b7824ULL, 0x044fe400078e0202ULL,
0x0000000130027824ULL, 0x000fe200078e020fULL, 0x000000090a0f7208ULL, 0x000fe20004800000ULL,
0x0000000130197824ULL, 0x000fe200078e0219ULL, 0x000000100b007388ULL, 0x0003e20000000800ULL,
0x000000271827723eULL, 0x008fe200000000ffULL, 0x0000001032187824ULL, 0x000fc400078e0207ULL,
0x000000103c077824ULL, 0x000fe200078e0207ULL, 0x0000001204007388ULL, 0x0003e20000000800ULL,
0x0000000130187824ULL, 0x040fe400078e0218ULL, 0x0000002a242c723cULL, 0x020b620000001820ULL,
0x00000001301b7824ULL, 0x040fe200078e021bULL, 0x0000001402007388ULL, 0x0003e20000000800ULL,
0x0000000130287824ULL, 0x040fe400078e0228ULL, 0x0000000130297824ULL, 0x040fe200078e0229ULL,
0x0000001618007388ULL, 0x0003e20000000800ULL, 0x0000000130207824ULL, 0x020fc600078e0207ULL,
0x0000001c19007388ULL, 0x0003e80000000800ULL, 0x0000001e1b007388ULL, 0x0003e80000000800ULL,
0x0000002428007388ULL, 0x0003e80000000800ULL, 0x0000002629007388ULL, 0x0003e40000000800ULL,
0x000000ffff2d7224ULL, 0x000fc400078e002eULL, 0x0000001120007388ULL, 0x0003e80000000800ULL,
0x0004001304007388ULL, 0x0003e80000000800ULL, 0x0004001502007388ULL, 0x0003e80000000800ULL,
0x0004001718007388ULL, 0x0003e80000000800ULL, 0x0004001d19007388ULL, 0x0003e80000000800ULL,
0x0004001f1b007388ULL, 0x0003e80000000800ULL, 0x0004002528007388ULL, 0x0003e80000000800ULL,
0x0004002729007388ULL, 0x0003e80000000800ULL, 0x01c0000c00008388ULL, 0x0003e80000000c00ULL,
0x01c2002c00008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c60800c6ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c61000c6ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c61800c6ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000051a00720cULL, 0x000fe20003f06070ULL, 0x01c62000c6ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff077224ULL, 0x000fd600078e001aULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff805000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0c7807ULL, 0x008fe20004000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00019a80000e7802ULL, 0x000fc40000000f00ULL, 0x0000118000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0015ULL, 0xfffe8d1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20005800000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00019ae0000e7802ULL, 0x000fc40000000f00ULL, 0x0000112000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0015ULL, 0xfffe8d4000007947ULL, 0x000fea000383ffffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00019b40000c7802ULL, 0x004fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000108000007944ULL, 0x00afea0003c00000ULL,
0xfffe8de000007947ULL, 0x000fea000383ffffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x00019b90000c7802ULL, 0x004fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000103000007944ULL, 0x000fea0003c00000ULL, 0xfffe8f0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff407224ULL, 0x000fe200078e0010ULL, 0x00019bf0000c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff0f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x00000fd000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff537224ULL, 0x004fe200078e000eULL,
0xfffe90a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x00019c50000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x00000f7000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff547224ULL, 0x004fe200078e000eULL,
0xfffe907000007947ULL, 0x000fea000383ffffULL, 0x000000ffff407224ULL, 0x000fe200078e0014ULL,
0x00019cc0000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff0f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00000f0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff537224ULL, 0x004fe200078e000eULL, 0xfffea3f000007947ULL, 0x000fea000383ffffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00019d20000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00000ea000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff547224ULL, 0x004fe200078e000eULL, 0xfffea3c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe20004000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00019d80000e7802ULL, 0x000fc40000000f00ULL, 0x00000e8000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0015ULL, 0xfffeb9b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20005000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00019de0000e7802ULL, 0x000fc40000000f00ULL, 0x00000e2000007944ULL, 0x012fea0003c00000ULL,
0xfffeb9f000007947ULL, 0x000fea000383ffffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x00019e30000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x00000d9000007944ULL, 0x012fea0003c00000ULL, 0xfffebab000007947ULL, 0x000fea000383ffffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00019e80000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00000d4000007944ULL, 0x010fea0003c00000ULL,
0xfffebbc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff407224ULL, 0x000fe200078e0010ULL,
0x00019ee0000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff0f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff537224ULL, 0x004fe200078e000eULL, 0xfffebd6000007947ULL, 0x000fea000383ffffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x00019f40000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00000c8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff547224ULL, 0x004fe200078e000eULL, 0xfffebd3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff407224ULL, 0x000fe200078e001cULL, 0x00019fb0000c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff0f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x00000c1000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff537224ULL, 0x004fe200078e000eULL,
0xfffecdf000007947ULL, 0x000fea000383ffffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x0001a010000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x00000bb000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff547224ULL, 0x004fe200078e000eULL,
0xfffecdc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe20004000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x0001a070000e7802ULL, 0x000fc40000000f00ULL,
0x00000b9000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0015ULL,
0xfffee18000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe20005000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x0001a0d0000e7802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x002fea0003c00000ULL, 0xfffee1b000007947ULL, 0x000fea000383ffffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x0001a120000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00000aa000007944ULL, 0x002fea0003c00000ULL,
0xfffee27000007947ULL, 0x000fea000383ffffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x0001a170000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x00000a5000007944ULL, 0x000fea0003c00000ULL, 0xfffee38000007947ULL, 0x000fea000383ffffULL,
0x000000ffff407224ULL, 0x000fe200078e0010ULL, 0x0001a1d0000c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff0f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x000009f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff537224ULL, 0x004fe200078e000eULL,
0xfffee52000007947ULL, 0x000fea000383ffffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x0001a230000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000099000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff547224ULL, 0x004fe200078e000eULL,
0xfffee4f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff407224ULL, 0x000fe200078e0010ULL,
0x0001a2a0000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff0f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000092000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff537224ULL, 0x004fe200078e000eULL, 0xfffef5b000007947ULL, 0x000fea000383ffffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x0001a300000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x000008c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff547224ULL, 0x004fe200078e000eULL, 0xfffef58000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe20004000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x0001a360000e7802ULL, 0x000fc40000000f00ULL, 0x000008a000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0015ULL, 0xffff0a2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x0001a3c0000e7802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x012fea0003c00000ULL,
0xffff0a5000007947ULL, 0x000fea000383ffffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x0001a410000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x000007b000007944ULL, 0x012fea0003c00000ULL, 0xffff0b1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x0001a460000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000076000007944ULL, 0x010fea0003c00000ULL,
0xffff0c2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff407224ULL, 0x000fe200078e0010ULL,
0x0001a4c0000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff0f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000070000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff537224ULL, 0x004fe200078e000eULL, 0xffff0dc000007947ULL, 0x000fea000383ffffULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x0001a520000c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff547224ULL, 0x004fe200078e000eULL, 0xffff0d9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff407224ULL, 0x000fe200078e0030ULL, 0x0001a590000c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff0f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff537224ULL, 0x004fe200078e000eULL,
0xffff1e8000007947ULL, 0x000fea000383ffffULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x0001a5f0000c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff547224ULL, 0x004fe200078e000eULL,
0xffff1e5000007947ULL, 0x000fea000383ffffULL, 0x00000002ff107424ULL, 0x000fe200078e00ffULL,
0x0001a660000a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff047424ULL, 0x000fc400078e00ffULL,
0xffffffffff157424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x006fea0003c00000ULL,
0xffffe6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x008fe200078e0009ULL,
0x0001a6d0000a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff107424ULL, 0x000fe400078e00ffULL,
0x0000001fff047424ULL, 0x000fe400078e00ffULL, 0xffffffffff157424ULL, 0x000fc400078e00ffULL,
0x000004b000007944ULL, 0x000fea0003c00000ULL, 0x000000040900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000eULL, 0x0001a750000a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff107424ULL, 0x000fe200078e00ffULL, 0x00000009040d7208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fc400078e00ffULL, 0xffffffffff157424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x000000040e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000fULL, 0x0001a7d0000a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff107424ULL, 0x000fe200078e00ffULL, 0x0000000e04137208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fe400078e00ffULL, 0xffffffffff157424ULL, 0x000fc400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x000000040f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0011ULL, 0x0001a850000a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000000f04097208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fc400078e00ffULL, 0xffffffffff157424ULL, 0x000fc400078e00ffULL,
0x0000033000007944ULL, 0x000fea0003c00000ULL, 0x000000041100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000dULL, 0x0001a8d0000a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x00000011040c7208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fe400078e00ffULL, 0xffffffffff157424ULL, 0x000fc400078e00ffULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000040d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0013ULL, 0x0001a950000a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000000d040d7208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fc400078e00ffULL, 0xffffffffff157424ULL, 0x000fc400078e00ffULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000041300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0009ULL, 0x0001a9d0000a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x00000013040e7208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fe400078e00ffULL, 0xffffffffff157424ULL, 0x000fc400078e00ffULL,
0x000001b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0004ULL,
0xffffe4a000007947ULL, 0x000fea000383ffffULL, 0x018000000a047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000a00048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff047807ULL, 0x000fc80000000000ULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000a057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000a00047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x00cfe400078e0004ULL, 0x000000ffff047224ULL, 0x000fe400078e0006ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe548004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000001500007348ULL, 0x000fe80003800000ULL,
0x0c00001007047389ULL, 0x0002a200000e0004ULL, 0xfffe54400a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000e00007348ULL, 0x000fe80003800000ULL,
0x00000040410e7389ULL, 0x0002a200000e000fULL, 0xfffe54000c007950ULL, 0x000fea0003c3ffffULL,
0x000000010c00780cULL, 0x000fe20003f65070ULL, 0x0000001500007348ULL, 0x000fe80003800000ULL,
0x00000000ff0d7424ULL, 0x000fd000078e00ffULL, 0x00000000000c7806ULL, 0x000fc800058e0100ULL,
0x000000150c157212ULL, 0x000fe200078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fc800078e000eULL,
0xfffe53900c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000542ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a0ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008f8ULL,
0x00000000000002f0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000be8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ca8ULL,
0x0000000000000670ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001318ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001328ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013b8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013bcULL,
0x00000000000001b0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x000000000001ad00ULL, 0xce00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c280ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c2c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c640ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000013b8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001aec8ULL,
0x000000000001aec8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c640ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 116512;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
