/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c4c0ULL, 0x000000000001c140ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45386aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x695f5f2400687461ULL,
0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL, 0x5f636e79736c6668ULL,
0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL,
0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL,
0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL,
0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x2e006d617261705fULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL, 0x0000006e6f697463ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000362ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000003a7ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0022000003edULL,
0x000000000001a780ULL, 0x0000000000000190ULL, 0x000b002200000420ULL, 0x000000000001a910ULL,
0x0000000000000040ULL, 0x000b00220000044bULL, 0x000000000001a950ULL, 0x0000000000000040ULL,
0x000b002200000475ULL, 0x000000000001a990ULL, 0x0000000000000170ULL, 0x000a0003000004e3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000503ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000533ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001ab00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001a78000000000ULL, 0x0000040400000000ULL, 0x810c000001480400ULL, 0x0068880400288080ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808908288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL, 0x8080a0082880809bULL,
0xae08288080ac0828ULL, 0x2880808608288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808086ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001a78000000000ULL,
0x0000019000000000ULL, 0x0000580400000000ULL, 0x8087288080840900ULL, 0x0900000004042880ULL,
0x2880808428808086ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8608288080840828ULL,
0x2880808908288080ULL, 0x8094082880808b08ULL, 0x0828808095082880ULL, 0x80809b0828808096ULL,
0xac08288080a00828ULL, 0x2880808e08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x000022002880808eULL, 0x0000001cffffffffULL, 0x0000013000000000ULL, 0x0001a91000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8608288080840828ULL, 0x2880808908288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL,
0x8080a0082880809bULL, 0xac08288080ae0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080ac920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000001d800000000ULL,
0x0001a95000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8608288080840828ULL, 0x2880808908288080ULL, 0x8095082880809408ULL,
0x0828808096082880ULL, 0x8080a0082880809bULL, 0xae08288080ac0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080ae920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000028000000000ULL, 0x0001a99000000000ULL, 0x0000017000000000ULL, 0x0000180400000000ULL,
0x80ac288080ae0900ULL, 0x0000000000002880ULL, 0x0000001800082f04ULL, 0x000823040000007cULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL,
0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL,
0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0050016000000015ULL, 0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000002000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001cc2804ULL,
0x0000038000000110ULL, 0x000027e0000016b0ULL, 0x0000296000002870ULL, 0x00002ce000002ad0ULL,
0x00002d5000002d10ULL, 0x000032c000002d90ULL, 0x000040f0000040c0ULL, 0x0000417000004130ULL,
0x00005700000045d0ULL, 0x000058a000005790ULL, 0x00005c1000005a00ULL, 0x00005c8000005c40ULL,
0x00005f5000005cc0ULL, 0x00006d6000006d30ULL, 0x00006de000006da0ULL, 0x00008140000070e0ULL,
0x000082d0000081c0ULL, 0x0000864000008430ULL, 0x000086b000008670ULL, 0x00008960000086f0ULL,
0x0000979000009760ULL, 0x00009810000097d0ULL, 0x0000ac5000009b10ULL, 0x0000ade00000acd0ULL,
0x0000b1500000af40ULL, 0x0000b1c00000b180ULL, 0x0000b4c00000b200ULL, 0x0000c2d00000c2a0ULL,
0x0000c3500000c310ULL, 0x0000c7d00000c7c0ULL, 0x0000e8c00000cf30ULL, 0x0000ef700000e8f0ULL,
0x0000f6500000efb0ULL, 0x00018f6000018f20ULL, 0x00018f8000018f70ULL, 0x00018ff000018f90ULL,
0x0001903000019010ULL, 0x00019ca000019c50ULL, 0x00019d1000019ce0ULL, 0x00019d9000019d50ULL,
0x00019e2000019de0ULL, 0x00019ec000019e70ULL, 0x00019f2000019ef0ULL, 0x00019fa000019f60ULL,
0x0001a03000019ff0ULL, 0x0001a0d00001a080ULL, 0x0001a1400001a110ULL, 0x0001a1c00001a180ULL,
0x0001a2500001a210ULL, 0x0001a2f00001a2a0ULL, 0x0001a3600001a330ULL, 0x0001a3e00001a3a0ULL,
0x0001a4700001a430ULL, 0x0001a5100001a4c0ULL, 0x0001a5d00001a570ULL, 0x0001a6900001a630ULL,
0x0001a7500001a6f0ULL, 0x0000022002003904ULL, 0x00014600000000ffULL, 0x00000280003f0100ULL,
0x0001460800000003ULL, 0x00000340003f0120ULL, 0x0001468800000003ULL, 0x000004b0003f0120ULL,
0x00014600000000ffULL, 0x00000630003f0107ULL, 0x0001468c00000008ULL, 0x000006d0003f0102ULL,
0x0001468800000008ULL, 0x00002500003f0101ULL, 0x0001460800000008ULL, 0x00002520003f0101ULL,
0x0001460c00000008ULL, 0x000026f0003f0105ULL, 0x0001460c00000008ULL, 0x00004590003f0105ULL,
0x00014688000000ffULL, 0x00005480003f0101ULL, 0x0001462800000008ULL, 0x000054a0003f0101ULL,
0x0001462c00000008ULL, 0x00005670003f0105ULL, 0x0001462c00000008ULL, 0x000070b0003f0105ULL,
0x00014690000000ffULL, 0x00007ec0003f0101ULL, 0x0001464800000008ULL, 0x00007ee0003f0101ULL,
0x0001464c00000008ULL, 0x000080b0003f0105ULL, 0x0001464c00000008ULL, 0x00009ae0003f0105ULL,
0x00014698000000ffULL, 0x0000a9d0003f0101ULL, 0x0001466800000008ULL, 0x0000a9f0003f0101ULL,
0x0001466c00000008ULL, 0x0000abc0003f0105ULL, 0x0001466c00000008ULL, 0x0000c620003f0105ULL,
0x000146a0000000ffULL, 0x0000fa00003f0101ULL, 0x00014600000000ffULL, 0x000107d0003f0101ULL,
0x00014604000000ffULL, 0x000109a0003f0105ULL, 0x00014604000000ffULL, 0x00018430003f0105ULL,
0x0000000000000025ULL, 0x00018450003f0101ULL, 0x0000000400000025ULL, 0x00018620003f0105ULL,
0x0000000400000025ULL, 0x00019ab0003f0105ULL, 0x0001460800000024ULL, 0x00019b10003f0101ULL,
0x0001461000000024ULL, 0x00019b70003f0101ULL, 0x0001461800000024ULL, 0x00019be0003f0101ULL,
0x0001462000000024ULL, 0x00033803003f0101ULL, 0x0000f8d000101c04ULL, 0x00010a9000010a00ULL,
0x0000040100019c20ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000314ULL, 0x0000001800000002ULL,
0x000000000000026cULL, 0x0000001800000002ULL, 0x00000000000001c4ULL, 0x0000001800000002ULL,
0x0000000000000104ULL, 0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL,
0x00000000000002eaULL, 0x0000001800000002ULL, 0x0000000000000242ULL, 0x0000001800000002ULL,
0x000000000000019fULL, 0x0000001800000002ULL, 0x00000000000000dfULL, 0x0000001800000002ULL,
0x0000000000014700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002100ULL,
0x0000000000157806ULL, 0x000fe200038e0000ULL, 0x00005800ff137624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000057919ULL, 0x000ea20000002300ULL,
0x0000001500077300ULL, 0x000fe200000e0000ULL, 0x00000200ff117424ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000000000027919ULL, 0x000f280000002200ULL,
0x0000000000147919ULL, 0x000ee20000002600ULL, 0x0000001500157309ULL, 0x000ea60000000000ULL,
0x0000000000277919ULL, 0x000ee80000002700ULL, 0x0000000000087919ULL, 0x000ee20000000000ULL,
0x00000005ff007819ULL, 0x002fc60000011604ULL, 0x00001fff050b7589ULL, 0x0043e200000e0000ULL,
0x000000ffff157224ULL, 0x000fc600078e0a15ULL, 0x00001fff00007589ULL, 0x000ea200000e0000ULL,
0x0000010005037a24ULL, 0x010fc600078e0202ULL, 0x0000000000027919ULL, 0x000f220000000000ULL,
0x0000000003037a24ULL, 0x000fe400078e0204ULL, 0x0000000814047824ULL, 0x008fe400078e00ffULL,
0x0000000813057824ULL, 0x002fe200078e00ffULL, 0x000000ff0300720cULL, 0x040fe40003f25270ULL,
0x0000000f0300780cULL, 0x000fe20003f44070ULL, 0x00000027050a7224ULL, 0x000fe200078e0204ULL,
0x000000030300780cULL, 0x000fc40003f64070ULL, 0x0000007f0300780cULL, 0x000fe40003f84070ULL,
0x000000080700720cULL, 0x000fca0003f02070ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x000000040b067824ULL, 0x004fe400078e0200ULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x00000002060d7824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL,
0x01460004ff009388ULL, 0x0003e20000000a00ULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x000000080d0c7817ULL, 0x040fe20007800000ULL, 0x000000010d087824ULL, 0x050fe200078e0202ULL,
0x000000010d0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000200d097824ULL, 0x000fe200078e00ffULL,
0x014608060300a388ULL, 0x0005e20000008a00ULL, 0x0000001002127824ULL, 0x000fc400078e00ffULL,
0x000000010c0c7824ULL, 0x100fe200078e0a0dULL, 0xffffffe0090e7812ULL, 0x000fe200078ee208ULL,
0x000000010a047824ULL, 0x002fe200078e020dULL, 0x000001f0120d7812ULL, 0x000fe200078ec0ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x000000ff0c00720cULL, 0x040fe20003f23070ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x000000010c00780cULL, 0x000fe20003f43070ULL,
0xff317217ff10c424ULL, 0x000fe400078e00ffULL, 0x000000010a067824ULL, 0x004fe200078e020fULL,
0x014688080300b388ULL, 0x000fe20000008a00ULL, 0x00005c0004047625ULL, 0x000fc600078e0011ULL,
0x014400100300c388ULL, 0x000fe20000004800ULL, 0x000000010f0a7824ULL, 0x000fc600078e0202ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00005c0006067625ULL, 0x000fe200078e0011ULL,
0x0000000d04047210ULL, 0x000fc60007f7e0ffULL, 0x000000200f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000d06067210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff057224ULL, 0x000fe400018e0605ULL,
0x000000100e0d7824ULL, 0x000fe200078e00ffULL, 0xffffffe00f0a7812ULL, 0x000fe200078ee20aULL,
0x000000ffff077224ULL, 0x000fe400020e0607ULL, 0x00000004ff117424ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000c901c46ULL,
0x000000100a0f7824ULL, 0x000fc400078e00ffULL, 0x000000ffff0a7224ULL, 0x000fe400078e0015ULL,
0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL, 0x00000000060f7faeULL, 0x0003e2000d101c46ULL,
0x0000620027087625ULL, 0x000fc600078e0011ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0146040affff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01460000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000608047981ULL, 0x002ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fc40003f05270ULL, 0x0000007f04057810ULL, 0x044fe40007ffe0ffULL,
0x000000ff04067810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff057819ULL, 0x000fe40000011605ULL,
0x00000008ff067819ULL, 0x000fca0000011606ULL, 0x0000f34000008947ULL, 0x000fea0003800000ULL,
0x0000000203077824ULL, 0x000fe400078e00ffULL, 0x0000000800087824ULL, 0x000fe400078e00ffULL,
0x00000003ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000050700720cULL, 0x000fda0003f06070ULL,
0x00006400070a8a10ULL, 0x000fe20007ffe0ffULL, 0x0000000227098824ULL, 0x000fc800078e00ffULL,
0x00006400090a8a24ULL, 0x000fe400078e020aULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01468c0b08ff738cULL, 0x0003e20000000000ULL,
0x000060000a0c8625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060c098981ULL, 0x000ea2000c1e1900ULL, 0x00000001030b7810ULL, 0x002fe20007ffe0ffULL,
0x00000080140a7824ULL, 0x000fe400078e00ffULL, 0x0146880008ff7f8cULL, 0x0003e2000c80043fULL,
0x000000060b00720cULL, 0x000fe20003f06070ULL, 0x00005800090b7a24ULL, 0x004fc800078e02ffULL,
0x000000800b267824ULL, 0x000fd000078e00ffULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x00000003ff117819ULL, 0x002fe20000011602ULL, 0x00000100030b7824ULL, 0x000fc600078e00ffULL,
0x0000000811167810ULL, 0x040fe40007ffe0ffULL, 0x0000000411157810ULL, 0x040fe40007ffe0ffULL,
0x0000001011187810ULL, 0x040fe20007ffe0ffULL, 0x00000001160e7824ULL, 0x140fe200078e0202ULL,
0x0000001411197810ULL, 0x040fe20007ffe0ffULL, 0x00000008160f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11177810ULL, 0x000fe20007ffe0ffULL, 0x00000001150d7824ULL, 0x040fe200078e0202ULL,
0x0000000b040c7217ULL, 0x000fe20007800000ULL, 0x00000008151c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f1e7812ULL, 0x000fe200078ee20eULL, 0x00000080140e7824ULL, 0x000fe200078e0211ULL,
0x0000001c11237810ULL, 0x000fe20007ffe0ffULL, 0x00000001180f7824ULL, 0x100fe200078e0202ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL, 0x0000000818227824ULL, 0x000fe200078e00ffULL,
0x0000000e26127210ULL, 0x000fe20007f1e0ffULL, 0x0000000119107824ULL, 0x140fe200078e0202ULL,
0x000000140e147810ULL, 0x000fe20007ffe0ffULL, 0x00000008191b7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee20fULL, 0x00000001170d7824ULL, 0x040fe200078e0202ULL,
0x000000040e0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000817207824ULL, 0x000fe200078e00ffULL,
0xfffffff81b247812ULL, 0x000fe200078ee210ULL, 0x000000010c0b7824ULL, 0x000fe200078e0a0bULL,
0x00000018111b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e00120c7a11ULL, 0x000fc400078048ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x000000011b1d7824ULL, 0x040fe200078e0202ULL, 0x000000080e107810ULL, 0x000fe20007ffe0ffULL,
0x000000081b287824ULL, 0x000fe200078e00ffULL, 0x0000000f260f7210ULL, 0x000fe40007f9e0ffULL,
0x00005f00120d7a11ULL, 0x000fe400000f4c13ULL, 0x0000000c0e127810ULL, 0x040fe40007ffe0ffULL,
0x000000100e137810ULL, 0x000fc40007ffe0ffULL, 0x000000180e1a7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c0e1f7810ULL, 0x000fe40007ffe0ffULL, 0x00000010262c7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x0000001226217210ULL, 0x040fe20007f1e0ffULL,
0x0000000123127824ULL, 0x000fe200078e0202ULL, 0x00000013262b7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00000014262a7210ULL, 0x000fc40007f7e0ffULL,
0x0000001a26297210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x0000001f26257210ULL, 0x000fe40007f9e0ffULL, 0xfffffff828267812ULL, 0x000fe200078ee21dULL,
0x00000008231d7824ULL, 0x000fe200078e00ffULL, 0x00005e000f0e7a11ULL, 0x000fe400078c48ffULL,
0x000000200b0b7817ULL, 0x000fe40003800000ULL, 0x00005f000f0f7a11ULL, 0x000fc400030f4c10ULL,
0xfffffff81d287812ULL, 0x000fe200078ee212ULL, 0x0000000111127824ULL, 0x040fe200078e0202ULL,
0x00005e002c107a11ULL, 0x000fe200078c48ffULL, 0x00000008001d7824ULL, 0x000fe200078e00ffULL,
0x0000000b1100720cULL, 0x000fe40003f46070ULL, 0x00005f002c117a11ULL, 0x000fe200030f4c13ULL,
0x000000ffff2c7224ULL, 0x000fe200028e06ffULL, 0x0000000712137812ULL, 0x000fe400078ec0ffULL,
0x00005e0021127a11ULL, 0x000fc400078c48ffULL, 0x0000c000001f7811ULL, 0x000fe400078e68ffULL,
0x0ffffff813147812ULL, 0x000fe400078ef802ULL, 0x00005f0021137a11ULL, 0x000fe200030f4c1aULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee202ULL,
0x0000001014217824ULL, 0x000fe200078e021fULL, 0x00005e002b147a11ULL, 0x000fe400078c48ffULL,
0x0000000b1500720cULL, 0x000fe20003f06070ULL, 0x000000101d0c7825ULL, 0x000fe200078e000cULL,
0x00005f002b157a11ULL, 0x000fc400030f4c1aULL, 0x0000000b1600720cULL, 0x080fe20003f26070ULL,
0x000000ffff2b7224ULL, 0x000fe200018e06ffULL, 0x00005e002a167a11ULL, 0x000fe200078c48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c217faeULL, 0x0003e2000d101c46ULL,
0x0000000b1700720cULL, 0x080fe40003f66070ULL, 0x0000000b1800720cULL, 0x000fe40003f46070ULL,
0x00005f002a177a11ULL, 0x000fe200030f4c2bULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005e0029187a11ULL, 0x000fe200078a48ffULL, 0x00000010262b7824ULL, 0x000fe200078e021fULL,
0x00005e00251a7a11ULL, 0x000fc400078c48ffULL, 0x0000000b1900720cULL, 0x080fe20003f86070ULL,
0x000000101d0c7825ULL, 0x002fe200078e000eULL, 0x00005f0029197a11ULL, 0x000fe400028f4c2cULL,
0x0000000b1b00720cULL, 0x080fe20003fa6070ULL, 0x000000101e217824ULL, 0x000fe200078e021fULL,
0x00005f00251b7a11ULL, 0x000fe200030f4c2aULL, 0x000000101d0e7825ULL, 0x000fe200078e0010ULL,
0x0000000b2300720cULL, 0x000fc60003fc6070ULL, 0x000000101c0b7824ULL, 0x100fe400078e021fULL,
0x0000001020237824ULL, 0x000fe400078e021fULL, 0x000000101d107825ULL, 0x040fe200078e0012ULL,
0x000000000c0b7faeULL, 0x0003e6000c101c46ULL, 0x0000001022257824ULL, 0x000fe200078e021fULL,
0x000000000e217faeULL, 0x0003e2000c901c46ULL, 0x000000101d127825ULL, 0x000fc600078e0014ULL,
0x0000000010237faeULL, 0x0003e2000d901c46ULL, 0x0000001024297824ULL, 0x000fe400078e021fULL,
0x000000101d147825ULL, 0x040fe200078e0016ULL, 0x0000000012257faeULL, 0x0003e6000d101c46ULL,
0x000000101d167825ULL, 0x040fe200078e0018ULL, 0x0000000014297faeULL, 0x0003e6000e101c46ULL,
0x00000010281f7824ULL, 0x000fe200078e021fULL, 0x00000000162b7faeULL, 0x0003e2000e901c46ULL,
0x000000101d187825ULL, 0x000fca00078e001aULL, 0x00000000181f7faeULL, 0x0003e2000f101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x00000004020f7811ULL, 0x002fe200078fe8ffULL,
0x00000008002d7824ULL, 0x000fe200078e00ffULL, 0x0000000c02137811ULL, 0x040fe400078fe8ffULL,
0x0000000802117811ULL, 0x040fe200078fe8ffULL, 0x000000010f0b7824ULL, 0x140fe200078e0202ULL,
0x0000001402177811ULL, 0x040fe200078fe8ffULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0x0000001802197811ULL, 0x000fe200078fe8ffULL, 0x00000001130d7824ULL, 0x140fe200078e0202ULL,
0x0000c000002b7811ULL, 0x000fe200078e68ffULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee20bULL, 0x00000001110c7824ULL, 0x140fe200078e0202ULL,
0x0000000a020b7211ULL, 0x000fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x00000001170d7824ULL, 0x040fe200078e0202ULL,
0x0000000b261b7210ULL, 0x000fe20007f1e0ffULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0xfffffff815127812ULL, 0x000fe200078ee20cULL, 0x00000001190e7824ULL, 0x100fe200078e0202ULL,
0x0000001002157811ULL, 0x000fe200078fe8ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005e001b0c7a11ULL, 0x000fe200078048ffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee20dULL, 0x00000001150b7824ULL, 0x000fe200078e0202ULL,
0x00005f001b0d7a11ULL, 0x000fe200000f4c1cULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0x0000001c021b7811ULL, 0x000fe200078fe8ffULL, 0x000000010a0f7824ULL, 0x040fe200078e020fULL,
0xfffffff81d1a7812ULL, 0x000fe200078ee20eULL, 0x000000010a137824ULL, 0x000fe200078e0213ULL,
0xfffffff816167812ULL, 0x000fe200078ee20bULL, 0x000000010a0e7824ULL, 0x000fe200078e021bULL,
0x0000000f261d7210ULL, 0x000fe20007fde0ffULL, 0x000000010a117824ULL, 0x000fe200078e0211ULL,
0x00000002020b7211ULL, 0x000fe200078fe8ffULL, 0x000000011b0f7824ULL, 0x140fe200078e0202ULL,
0x0000001326137210ULL, 0x040fe20007f9e0ffULL, 0x000000081b227824ULL, 0x000fe200078e00ffULL,
0x0000000e261c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010a157824ULL, 0x000fe200078e0215ULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x00000011261e7210ULL, 0x000fe20007fbe0ffULL, 0x000000010a177824ULL, 0x040fe200078e0217ULL,
0x00005e001d0e7a11ULL, 0x000fe200078c48ffULL, 0x000000010a197824ULL, 0x000fe200078e0219ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef802ULL, 0x0000001014217824ULL, 0x000fe200078e022bULL,
0xfffffff822117812ULL, 0x000fe200078ee20fULL, 0x00000010121f7824ULL, 0x100fe200078e022bULL,
0x0000001526157210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x00005f001d0f7a11ULL, 0x000fe200030f4c20ULL, 0x00000010101d7824ULL, 0x100fe200078e022bULL,
0x0000001726177210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078848ffULL, 0x000000100b0b7824ULL, 0x100fe200078e022bULL,
0x0000001926197210ULL, 0x000fe20007f5e0ffULL, 0x0000001016237824ULL, 0x100fe200078e022bULL,
0x00005e001e107a11ULL, 0x000fe200078a48ffULL, 0x0000001018257824ULL, 0x100fe200078e022bULL,
0x00005f0013137a11ULL, 0x000fe200020f4c14ULL, 0x000000101a297824ULL, 0x100fe200078e022bULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee202ULL, 0x00000010112b7824ULL, 0x000fe200078e022bULL,
0x00005f001e117a11ULL, 0x000fe200028f4c1bULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078648ffULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078048ffULL, 0x000000ffff1e7224ULL, 0x000fe200010e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078448ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x00005e001c1a7a11ULL, 0x000fe200078248ffULL, 0x000000102d0c7825ULL, 0x000fe200078e000cULL,
0x00005f0015157a11ULL, 0x000fc400018f4c22ULL, 0x00005f0017177a11ULL, 0x000fe200000f4c20ULL,
0x000000102d0e7825ULL, 0x000fe200078e000eULL, 0x00005f0019197a11ULL, 0x000fe200010f4c1eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c46ULL,
0x00005f001c1b7a11ULL, 0x000fe200008f4c1bULL, 0x000000102d107825ULL, 0x040fe400078e0010ULL,
0x000000000e1d7faeULL, 0x0003e4000b901c46ULL, 0x000000102d127825ULL, 0x040fe400078e0012ULL,
0x00000000101f7faeULL, 0x0003e4000b901c46ULL, 0x000000102d147825ULL, 0x000fc400078e0014ULL,
0x0000000012217faeULL, 0x0003e4000b901c46ULL, 0x000000102d167825ULL, 0x040fe400078e0016ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x000000102d187825ULL, 0x040fe400078e0018ULL,
0x0000000016257faeULL, 0x0003e4000b901c46ULL, 0x000000102d1a7825ULL, 0x000fc400078e001aULL,
0x0000000018297faeULL, 0x0003e8000b901c46ULL, 0x000000001a2b7faeULL, 0x0003e4000b901c46ULL,
0x000000060300720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff747424ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x002fe200078e00ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000b08000000947ULL, 0x000fea0003800000ULL, 0x0000000227277824ULL, 0x000fe400078e00ffULL,
0x00006400ff107624ULL, 0x000fc400078e00ffULL, 0x0000001fff767424ULL, 0x000fe400078e00ffULL,
0xffffffffff757424ULL, 0x000fe400078e00ffULL, 0x0000640027107624ULL, 0x000fe400078e0210ULL,
0xff317217ff747424ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fc400078e00ffULL,
0x00000100030d7824ULL, 0x000fca00078e00ffULL, 0x000000040d00720cULL, 0x000fda0003f06070ULL,
0x0000afa000000947ULL, 0x020fea0003800000ULL, 0x00000001030d7810ULL, 0x000fe20007ffe0ffULL,
0x0000580009787a24ULL, 0x000fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000060d00720cULL, 0x000fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe400078e0007ULL,
0x0000008078787824ULL, 0x000fd400078e00ffULL, 0x0000074000009947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x100fe40000011602ULL, 0x00000020030d7811ULL, 0x000fe400078e40ffULL,
0x000000041f1b7810ULL, 0x040fe40007ffe0ffULL, 0x000000101f2f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000d040c7217ULL, 0x000fe20007800000ULL, 0x000000011b0e7824ULL, 0x100fe200078e0202ULL,
0x000000081f217810ULL, 0x000fe20007ffe0ffULL, 0x000000081b277824ULL, 0x000fe200078e00ffULL,
0x0000000c1f2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000012f0f7824ULL, 0x040fe200078e0202ULL,
0x000000200a1e7810ULL, 0x000fe20007ffe0ffULL, 0x000000082f127824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20eULL, 0x000000010c0d7824ULL, 0x000fe200078e0a0dULL,
0x000000141f377810ULL, 0x000fe20007ffe0ffULL, 0x00000001210c7824ULL, 0x140fe200078e0202ULL,
0xfffffff812357812ULL, 0x000fe200078ee20fULL, 0x0000000821297824ULL, 0x000fe200078e00ffULL,
0x000000181f3b7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b0e7824ULL, 0x000fe200078e0202ULL,
0x0000001c1f3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000082b2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x000000011f0f7824ULL, 0x000fe200078e021eULL,
0x0000d00000227811ULL, 0x000fe200078e68ffULL, 0x00000001370c7824ULL, 0x000fe200078e0202ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x0000000837397824ULL, 0x000fe200078e00ffULL,
0x0000000f780e7210ULL, 0x000fe20007f1e0ffULL, 0x000000013b127824ULL, 0x000fc400078e0202ULL,
0x000000083b3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee20cULL,
0x000000ffff197224ULL, 0x000fe200000e06ffULL, 0x00005e000e0c7a11ULL, 0x040fe200078048ffULL,
0x000000011b0f7824ULL, 0x000fe200078e021eULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee212ULL,
0x0000000121177824ULL, 0x000fe200078e021eULL, 0x000000200d127817ULL, 0x000fe20003800000ULL,
0x000000013f167824ULL, 0x040fe200078e0202ULL, 0x00005f000e0d7a11ULL, 0x000fe200000f4c19ULL,
0x000000083f417824ULL, 0x000fe200078e00ffULL, 0x0000000f780f7210ULL, 0x040fe20007f1e0ffULL,
0x000000012f197824ULL, 0x100fe200078e021eULL, 0x0000001778187210ULL, 0x000fe20007f5e0ffULL,
0x000000012b177824ULL, 0x000fe200078e021eULL, 0x000000121b00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078048ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e06ffULL, 0xfffffff841417812ULL, 0x000fe200078ee216ULL,
0x0000001027277824ULL, 0x000fe200078e0222ULL, 0x00005e0018167a11ULL, 0x000fc400078448ffULL,
0x00005f000f0f7a11ULL, 0x000fe400000f4c1aULL, 0x00000017781d7210ULL, 0x000fe40007f1e0ffULL,
0x00005f0018177a11ULL, 0x000fe400010f4c1bULL, 0x000000121f00720cULL, 0x0c0fe20003f46070ULL,
0x000000011f1f7824ULL, 0x000fe200078e0202ULL, 0x00005e001d187a11ULL, 0x000fe200078648ffULL,
0x000000ffff207224ULL, 0x000fe200000e06ffULL, 0x000000122100720cULL, 0x000fc40003f06070ULL,
0x000000071f217812ULL, 0x000fe200078ec0ffULL, 0x00000001371f7824ULL, 0x000fe200078e021eULL,
0x00000019781b7210ULL, 0x000fe40007f9e0ffULL, 0x00005f001d197a11ULL, 0x000fe400018f4c20ULL,
0x00000007021d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1c7224ULL, 0x000fe200020e06ffULL,
0x0000001f78207210ULL, 0x000fe20007f7e0ffULL, 0x000000013b1f7824ULL, 0x000fe200078e021eULL,
0x00005e001b1a7a11ULL, 0x000fe200078848ffULL, 0x0000000108237824ULL, 0x000fe200078e021dULL,
0x0ffffff821217812ULL, 0x000fe200078ef802ULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe200020f4c1cULL, 0x00000010230c7825ULL, 0x000fe200078e000cULL,
0x00005e00201c7a11ULL, 0x000fc400078648ffULL, 0x000000122b00720cULL, 0x080fe20003f86070ULL,
0x0000001021257824ULL, 0x000fe200078e0222ULL, 0x00005f00201d7a11ULL, 0x000fe200018f4c1dULL,
0x000000013f217824ULL, 0x000fe200078e021eULL, 0x0000001f781f7210ULL, 0x040fe20007f7e0ffULL,
0x00000010230e7825ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c257faeULL, 0x0003e4000d101c46ULL, 0x0000002178217210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe200078c48ffULL,
0x000000000e277faeULL, 0x0005e2000e901c46ULL, 0x000000122f00720cULL, 0x080fe20003f66070ULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005f001f1f7a11ULL, 0x000fe200030f4c20ULL,
0x00000010352b7824ULL, 0x100fe200078e0222ULL, 0x00005e0021207a11ULL, 0x000fe200078448ffULL,
0x000000103d2f7824ULL, 0x100fe200078e0222ULL, 0x000000123700720cULL, 0x080fe20003fc6070ULL,
0x0000001029257824ULL, 0x002fe200078e0222ULL, 0x000000123b00720cULL, 0x000fe20003fa6070ULL,
0x00000010230c7825ULL, 0x000fe200078e0016ULL, 0x00005f0021217a11ULL, 0x000fc400010f4c24ULL,
0x000000123f00720cULL, 0x000fe20003f46070ULL, 0x000000102d297824ULL, 0x000fe200078e0222ULL,
0x000000000c257faeULL, 0x0003e2000c101c46ULL, 0x00000010230e7825ULL, 0x004fc800078e0018ULL,
0x0000001023167825ULL, 0x000fe200078e001aULL, 0x000000000e297faeULL, 0x0003e6000e101c46ULL,
0x00000010392d7824ULL, 0x000fe200078e0222ULL, 0x00000000162b7faeULL, 0x0003e2000d901c46ULL,
0x0000001023187825ULL, 0x000fc800078e001cULL, 0x00000010231a7825ULL, 0x000fe200078e001eULL,
0x00000000182d7faeULL, 0x0003e6000f101c46ULL, 0x0000001041357824ULL, 0x000fe200078e0222ULL,
0x000000001a2f7faeULL, 0x0003e2000e901c46ULL, 0x00000010231c7825ULL, 0x000fca00078e0020ULL,
0x000000001c357faeULL, 0x0003e2000d101c46ULL, 0x0000066000007947ULL, 0x000fea0003800000ULL,
0x0000000802177811ULL, 0x040fe400078fe8ffULL, 0x0000000c02197811ULL, 0x040fe400078fe8ffULL,
0x00000004020f7811ULL, 0x040fe200078fe8ffULL, 0x00000001170d7824ULL, 0x140fe200078e0202ULL,
0x00000014021d7811ULL, 0x040fe200078fe8ffULL, 0x0000000817127824ULL, 0x000fe200078e00ffULL,
0x00000018021f7811ULL, 0x040fe200078fe8ffULL, 0x00000001190e7824ULL, 0x140fe200078e0202ULL,
0x00000010021b7811ULL, 0x000fe200078fe8ffULL, 0x0000000819297824ULL, 0x000fe200078e00ffULL,
0xfffffff812277812ULL, 0x000fe200078ee20dULL, 0x000000010f0c7824ULL, 0x040fe200078e0202ULL,
0x0000d00000187811ULL, 0x000fe200078e68ffULL, 0x000000080f257824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x000000011d0d7824ULL, 0x040fe200078e0202ULL,
0x0000000702377812ULL, 0x000fe200078ec0ffULL, 0x000000081d127824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x000000011f0e7824ULL, 0x000fc400078e0202ULL,
0x000000081f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8122d7812ULL, 0x000fe200078ee20dULL,
0x000000011b0c7824ULL, 0x040fe200078e0202ULL, 0x000000200a0d7810ULL, 0x000fe20007ffe0ffULL,
0x000000081b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL,
0x0000001025257824ULL, 0x000fe200078e0218ULL, 0x0000001c020e7811ULL, 0x040fe200078fe8ffULL,
0x000000010f0f7824ULL, 0x100fe200078e020dULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL,
0x0000000117177824ULL, 0x100fe200078e020dULL, 0x00000002020c7211ULL, 0x000fe200078fe8ffULL,
0x0000000119197824ULL, 0x100fe200078e020dULL, 0x0000000f780f7210ULL, 0x000fe20007f5e0ffULL,
0x000000011b1b7824ULL, 0x100fe200078e020dULL, 0x000000070c237812ULL, 0x000fe200078ec0ffULL,
0x000000011d1d7824ULL, 0x000fc400078e020dULL, 0x000000011f1f7824ULL, 0x100fe200078e020dULL,
0x0ffffff823237812ULL, 0x100fe200078ef802ULL, 0x000000010e217824ULL, 0x000fe200078e020dULL,
0x0000000d020d7211ULL, 0x000fe200078fe8ffULL, 0x000000010e0c7824ULL, 0x000fe200078e0202ULL,
0x0000001b781b7210ULL, 0x000fe20007f7e0ffULL, 0x000000080e357824ULL, 0x000fe200078e00ffULL,
0x0000000d780d7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x0000001023237824ULL, 0x000fe200078e0218ULL,
0xfffffff835357812ULL, 0x000fe200078ee20cULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078048ffULL, 0x0000001027277824ULL, 0x000fe200078e0218ULL,
0x00005f000f0f7a11ULL, 0x000fe200010f4c12ULL, 0x0000001029297824ULL, 0x000fe200078e0218ULL,
0x00005f000d0d7a11ULL, 0x000fe200000f4c16ULL, 0x000000102b2b7824ULL, 0x100fe200078e0218ULL,
0x0000001778177210ULL, 0x040fe20007f1e0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0218ULL,
0x0000001978197210ULL, 0x000fe20007f5e0ffULL, 0x000000102f2f7824ULL, 0x000fc400078e0218ULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x00005e0017167a11ULL, 0x000fe200078048ffULL,
0x0000001035357824ULL, 0x000fe400078e0218ULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078448ffULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078648ffULL, 0x0000000108377824ULL, 0x000fe200078e0237ULL,
0x00005f0017177a11ULL, 0x000fe400000f4c1eULL, 0x00005f0019197a11ULL, 0x000fe200010f4c1cULL,
0x00000010370c7825ULL, 0x000fe200078e000cULL, 0x0000001d781d7210ULL, 0x000fc40007f1e0ffULL,
0x00005f001b1b7a11ULL, 0x000fe200018f4c12ULL, 0x00000010370e7825ULL, 0x000fe200078e000eULL,
0x0000001f781f7210ULL, 0x040fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c237faeULL, 0x0003e2000b901c46ULL, 0x0000002178217210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078048ffULL,
0x000000ffff227224ULL, 0x000fe200010e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe200078448ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x00005e0021207a11ULL, 0x000fe200078648ffULL,
0x0000001037167825ULL, 0x000fe200078e0016ULL, 0x00005f001d1d7a11ULL, 0x000fe200000f4c24ULL,
0x000000000e257faeULL, 0x0003e2000b901c46ULL, 0x00005f001f1f7a11ULL, 0x000fe200010f4c22ULL,
0x0000001037187825ULL, 0x000fe200078e0018ULL, 0x00005f0021217a11ULL, 0x000fe200018f4c12ULL,
0x0000000016277faeULL, 0x0003e4000b901c46ULL, 0x00000010371a7825ULL, 0x000fc400078e001aULL,
0x0000000018297faeULL, 0x0003e4000b901c46ULL, 0x00000010371c7825ULL, 0x040fe400078e001cULL,
0x000000001a2b7faeULL, 0x0003e4000b901c46ULL, 0x00000010371e7825ULL, 0x040fe400078e001eULL,
0x000000001c2d7faeULL, 0x0003e4000b901c46ULL, 0x0000001037207825ULL, 0x000fc400078e0020ULL,
0x000000001e2f7faeULL, 0x0003e8000b901c46ULL, 0x0000000020357faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146080008167f8cULL, 0x0022a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01460c00080f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c197210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000190e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01460c00080f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002127824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011602ULL,
0xffffffffff2b7424ULL, 0x000fc600078e00ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0d7812ULL, 0x000fca00078ec0ffULL, 0x0000000112127824ULL, 0x000fca00078e020dULL,
0x01400000120d7984ULL, 0x000ea80000000800ULL, 0x01420000120c7984ULL, 0x0006620000000800ULL,
0x000000740d00720bULL, 0x004fe20003f1d000ULL, 0x000174527f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0e177812ULL, 0x000fe2000784c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff777224ULL, 0x000fd400078e0074ULL, 0x000004100000a947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f45270ULL, 0x000000740d00720bULL, 0x000fe20003f74000ULL,
0x000174127f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x000fc400018e0100ULL,
0x0000000d74777209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x000099100e0f7816ULL, 0x000fc600000000ffULL, 0x014400771200a388ULL, 0x0005e20000000800ULL,
0x000000ff0f00720cULL, 0x000fda0003f45270ULL, 0x000003000000a947ULL, 0x000fea0003800000ULL,
0x80000077740f7221ULL, 0x004fe20000010000ULL, 0x000000ff0eff7812ULL, 0x000fe2000784c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f006b7308ULL, 0x0004ec0000000800ULL, 0x000001300000a947ULL, 0x000fea0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe20000011602ULL, 0x000173727f007947ULL, 0x000fea000b800000ULL,
0x00001f2e6b2e7589ULL, 0x0086a400000e0000ULL, 0x0000002e50507220ULL, 0x084fe20000410000ULL,
0x0000002e51517220ULL, 0x080fe20000410000ULL, 0x0000002e54547220ULL, 0x080fe20000410000ULL,
0x0000002e55557220ULL, 0x080fe20000410000ULL, 0x0000002e58587220ULL, 0x080fe20000410000ULL,
0x0000002e59597220ULL, 0x080fe20000410000ULL, 0x0000002e5c5c7220ULL, 0x080fe20000410000ULL,
0x0000002e5d5d7220ULL, 0x080fe20000410000ULL, 0x0000002e64647220ULL, 0x080fe20000410000ULL,
0x0000002e65657220ULL, 0x080fe20000410000ULL, 0x0000002e60607220ULL, 0x080fe20000410000ULL,
0x0000002e61617220ULL, 0x080fe20000410000ULL, 0x0000002e4c4c7220ULL, 0x080fe20000410000ULL,
0x0000002e4d4d7220ULL, 0x080fe20000410000ULL, 0x0000002e30307220ULL, 0x080fe20000410000ULL,
0x0000002e31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000eff7812ULL, 0x000fe2000784c0ffULL, 0x0000006b0b0b7220ULL, 0x008fd80000410000ULL,
0x000001300000a947ULL, 0x000fea0003800000ULL, 0x00000008022e7811ULL, 0x000fe200078ff0ffULL,
0x000172327f007947ULL, 0x000fea000b800000ULL, 0x00001f2e6b2e7589ULL, 0x0006a400000e0000ULL,
0x0000002e52527220ULL, 0x084fe20000410000ULL, 0x0000002e53537220ULL, 0x080fe20000410000ULL,
0x0000002e56567220ULL, 0x080fe20000410000ULL, 0x0000002e57577220ULL, 0x080fe20000410000ULL,
0x0000002e5a5a7220ULL, 0x080fe20000410000ULL, 0x0000002e5b5b7220ULL, 0x080fe20000410000ULL,
0x0000002e5e5e7220ULL, 0x080fe20000410000ULL, 0x0000002e5f5f7220ULL, 0x080fe20000410000ULL,
0x0000002e66667220ULL, 0x080fe20000410000ULL, 0x0000002e67677220ULL, 0x080fe20000410000ULL,
0x0000002e62627220ULL, 0x080fe20000410000ULL, 0x0000002e63637220ULL, 0x080fe20000410000ULL,
0x0000002e4e4e7220ULL, 0x080fe20000410000ULL, 0x0000002e4f4f7220ULL, 0x080fe20000410000ULL,
0x0000002e32327220ULL, 0x080fe20000410000ULL, 0x0000002e33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff17ff7812ULL, 0x000fda000784600eULL,
0x800000770d0d2221ULL, 0x000fe20000010000ULL, 0x000000000000281cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0d0d2820ULL, 0x000fc80000410000ULL, 0x0000000d00132308ULL, 0x000ea40000000800ULL,
0x000000130c0c2220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000000b0c0b7221ULL, 0x002fe20000010000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000013ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011602ULL,
0x000054100c6b7816ULL, 0x008fe2000000000cULL, 0x000170527f007947ULL, 0x000fea000b800000ULL,
0x00001f0e6b147589ULL, 0x0002a400000e0000ULL, 0x000000080e2e7810ULL, 0x000fe20007ffe0ffULL,
0x000170727f007947ULL, 0x000fea000b800000ULL, 0x00001f2e6b157589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000100e2e7810ULL, 0x008fe40007ffe0ffULL,
0x00002d60002c7802ULL, 0x000fc40000000f00ULL, 0x00017bf000007944ULL, 0x006fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000180e2e7810ULL, 0x00cfe40007ffe0ffULL,
0x00002da0002c7802ULL, 0x000fc40000000f00ULL, 0x00017bb000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000702167812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008020d7812ULL, 0x000fc400078ec0ffULL,
0x00000008160f7812ULL, 0x000fc800078ef802ULL, 0x0000000f02687211ULL, 0x000fe200078fe0ffULL,
0x000000080f177824ULL, 0x000fca00078e00ffULL, 0xfffffff817177812ULL, 0x000fc800078ee268ULL,
0x0000a00017247811ULL, 0x000fca00078e20ffULL, 0x000000070d0d7812ULL, 0x000fe200078ef802ULL,
0x000000002424783bULL, 0x000f220000000200ULL, 0x0000c00000187811ULL, 0x000fe400078e68ffULL,
0x0000000d020c7211ULL, 0x000fe200078fe0ffULL, 0x000000080d197824ULL, 0x040fe400078e00ffULL,
0x000000080d1b7824ULL, 0x040fe200078e00ffULL, 0x000000020c6a7810ULL, 0x040fe20007ffe0ffULL,
0x000000080d0e7824ULL, 0x042fe200078e00ffULL, 0x000000040c697810ULL, 0x040fe20007ffe0ffULL,
0x000000080d1d7824ULL, 0x000fe200078e00ffULL, 0x000000060c287810ULL, 0x000fc40007ffe0ffULL,
0xfffffff819197812ULL, 0x000fe200078ee20cULL, 0x000000080f0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b6a7812ULL, 0x000fe400078ee26aULL, 0xfffffff80e697812ULL, 0x000fe200078ee269ULL,
0x0000001019197824ULL, 0x000fe200078e0218ULL, 0xfffffff81d287812ULL, 0x000fe200078ee228ULL,
0x000000106a1a7824ULL, 0x100fe200078e0218ULL, 0x00000002681d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010691b7824ULL, 0x100fe200078e0218ULL, 0x00000000196c783bULL, 0x000e620000004200ULL,
0x00000010281c7824ULL, 0x000fe200078e0218ULL, 0x000000100d0d7812ULL, 0x000fc400078efcffULL,
0x000000001a48783bULL, 0x000ee20000004200ULL, 0xfffffff80c1d7812ULL, 0x000fe400078ee21dULL,
0x0000000d020c7211ULL, 0x000fe200078fe0ffULL, 0x000000001b44783bULL, 0x000ea20000004200ULL,
0x000000080d0e7824ULL, 0x000fe200078e00ffULL, 0x0000a0001d387811ULL, 0x000fe200078e20ffULL,
0x000000080d1f7824ULL, 0x040fe200078e00ffULL, 0x000000001c2c783bULL, 0x00cfe20000004200ULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0x000000020c297810ULL, 0x040fe20007ffe0ffULL,
0x000000080d207824ULL, 0x000fe200078e00ffULL, 0x000000040c2a7810ULL, 0x040fe20007ffe0ffULL,
0x000000003838783bULL, 0x000ea20000000200ULL, 0x000000060c797810ULL, 0x000fe20007ffe0ffULL,
0x0000001424240232ULL, 0x090fe20000000000ULL, 0xfffffff80f747812ULL, 0x000fe200078ee20cULL,
0x0000001426260232ULL, 0x000fe20000000000ULL, 0xfffffff80e297812ULL, 0x000fe200078ee229ULL,
0x0000001525250232ULL, 0x080fe20000000000ULL, 0xfffffff81f2a7812ULL, 0x000fe200078ee22aULL,
0x00000010741e7824ULL, 0x100fe200078e0218ULL, 0xfffffff820797812ULL, 0x000fe200078ee279ULL,
0x00000010291f7824ULL, 0x100fe200078e0218ULL, 0x0000001527270232ULL, 0x000fe20000000000ULL,
0x000000102a207824ULL, 0x100fe200078e0218ULL, 0x000000001e34783bULL, 0x000ee20000004200ULL,
0x0000001079217824ULL, 0x000fc600078e0218ULL, 0x000000001f40783bULL, 0x000f280000004200ULL,
0x00000000203c783bULL, 0x000ee20000004200ULL, 0x0000006c2450723cULL, 0x042f660000001850ULL,
0x00000000210c783bULL, 0x000e6a0000004200ULL, 0x000000482458723cULL, 0x040f700000001858ULL,
0x000000442464723cULL, 0x000f620000001864ULL, 0x0000001438380232ULL, 0x004fc40000000000ULL,
0x000000143a3a0232ULL, 0x000fe40000000000ULL, 0x0000001539390232ULL, 0x080fe40000000000ULL,
0x000000153b3b0232ULL, 0x000fe20000000000ULL, 0x0000006e2454723cULL, 0x040f700000001854ULL,
0x0000004a245c723cULL, 0x040f70000000185cULL, 0x000000462444723cULL, 0x040f700000001860ULL,
0x0000002c244c723cULL, 0x040f70000000184cULL, 0x0000002e2424723cULL, 0x000f700000001830ULL,
0x000000343850723cULL, 0x068b700000001850ULL, 0x000000403858723cULL, 0x050b700000001858ULL,
0x0000003c3864723cULL, 0x040b700000001864ULL, 0x000000363834723cULL, 0x040b700000001854ULL,
0x000000423840723cULL, 0x040b70000000185cULL, 0x0000003e383c723cULL, 0x040b700000001844ULL,
0x0000000c384c723cULL, 0x042b70000000184cULL, 0x0000000e3838723cULL, 0x000b620000001824ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000072000009947ULL, 0x000fca0003800000ULL,
0x00000003ff2f7819ULL, 0x020fe20000011602ULL, 0x0000000108337824ULL, 0x000fe200078e0216ULL,
0x00000040030d7811ULL, 0x000fe400078e40ffULL, 0x000000082f2d7810ULL, 0x040fe40007ffe0ffULL,
0x000000042f237810ULL, 0x000fe40007ffe0ffULL, 0x0000000d040c7217ULL, 0x000fe20007800000ULL,
0x000000012d227824ULL, 0x100fe200078e0202ULL, 0x000000102f557810ULL, 0x000fe20007ffe0ffULL,
0x000000082d497824ULL, 0x000fe200078e00ffULL, 0x000000142f5d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001230f7824ULL, 0x040fe200078e0202ULL, 0x000000400a2e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000823247824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee222ULL,
0x000000010c0e7824ULL, 0x000fe200078e0a0dULL, 0x0000000c2f317810ULL, 0x000fe20007ffe0ffULL,
0x00000001550d7824ULL, 0x140fe200078e0202ULL, 0xfffffff824477812ULL, 0x000fe200078ee20fULL,
0x0000000855227824ULL, 0x000fe200078e00ffULL, 0x000000182f617810ULL, 0x000fe20007ffe0ffULL,
0x000000015d0f7824ULL, 0x000fe200078e0202ULL, 0x0000001c2f6b7810ULL, 0x000fe20007ffe0ffULL,
0x000000085d247824ULL, 0x000fe200078e00ffULL, 0xfffffff822577812ULL, 0x000fe200078ee20dULL,
0x000000012f0d7824ULL, 0x000fe200078e022eULL, 0x000000200e327817ULL, 0x000fe20003800000ULL,
0x00000001310c7824ULL, 0x140fe200078e0202ULL, 0xfffffff8245f7812ULL, 0x000fe200078ee20fULL,
0x00000008314b7824ULL, 0x000fe200078e00ffULL, 0x0000000d780f7210ULL, 0x000fe20007f5e0ffULL,
0x0000000161227824ULL, 0x000fe200078e0202ULL, 0x000000322d00720cULL, 0x000fe20003fa6070ULL,
0x0000000861637824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee20cULL,
0x00000001230d7824ULL, 0x000fc400078e022eULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00005e000f0c7a11ULL, 0x000fe200078448ffULL, 0x000000016b257824ULL, 0x000fe200078e0202ULL,
0xfffffff863637812ULL, 0x000fe200078ee222ULL, 0x000000086b267824ULL, 0x000fe200078e00ffULL,
0x0000000d78227210ULL, 0x000fe20007f7e0ffULL, 0x0000001047477824ULL, 0x000fe200078e0218ULL,
0x00005f000f0d7a11ULL, 0x000fe200010f4c24ULL, 0x000000012d0f7824ULL, 0x100fe200078e022eULL,
0xfffffff8266d7812ULL, 0x000fe200078ee225ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x000000322300720cULL, 0x000fe20003f66070ULL, 0x0000000131237824ULL, 0x000fe200078e022eULL,
0x0000000f78247210ULL, 0x000fe20007f9e0ffULL, 0x00000010330c7825ULL, 0x000fe200078e000cULL,
0x00005e00220e7a11ULL, 0x000fc600078448ffULL, 0x000000ffff277224ULL, 0x000fe200020e06ffULL,
0x0000002378267210ULL, 0x000fe20007f9e0ffULL, 0x0000001049497824ULL, 0x000fe200078e0218ULL,
0x00005f00220f7a11ULL, 0x000fe200010f4c25ULL, 0x0000000155257824ULL, 0x000fe200078e022eULL,
0x00005e0024227a11ULL, 0x040fe200078448ffULL, 0x000000ffff2d7224ULL, 0x000fe200020e06ffULL,
0x000000322f00720cULL, 0x040fe20003f86070ULL, 0x000000012f2f7824ULL, 0x000fe200078e0202ULL,
0x00005f0024237a11ULL, 0x000fe200010f4c27ULL, 0x00000010330e7825ULL, 0x000fe200078e000eULL,
0x00005e0026247a11ULL, 0x000fc400078448ffULL, 0x0000002578277210ULL, 0x000fe20007fde0ffULL,
0x0000001033227825ULL, 0x000fe200078e0022ULL, 0x000000072f2f7812ULL, 0x000fe400078ec0ffULL,
0x00005f0026257a11ULL, 0x000fe200010f4c2dULL, 0x000000ffff2c7224ULL, 0x000fe200030e06ffULL,
0x000000323100720cULL, 0x000fe20003f46070ULL, 0x000000015d2d7824ULL, 0x000fe200078e022eULL,
0x00005e0027267a11ULL, 0x000fe200078c48ffULL, 0x000000104b4b7824ULL, 0x000fe200078e0218ULL,
0x0ffffff82f317812ULL, 0x000fe200078ef802ULL, 0x00000001612f7824ULL, 0x000fe200078e022eULL,
0x00005f0027277a11ULL, 0x000fe200030f4c2cULL, 0x0000001057577824ULL, 0x100fe200078e0218ULL,
0x0000002d782d7210ULL, 0x000fe20007fde0ffULL, 0x0000001031457824ULL, 0x000fc400078e0218ULL,
0x000000016b317824ULL, 0x000fe400078e022eULL, 0x000000ffff307224ULL, 0x000fe200030e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c457faeULL, 0x0003e2000e101c46ULL,
0x00005e002d2c7a11ULL, 0x000fe200078c48ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0218ULL,
0x0000002f782f7210ULL, 0x040fe20007f9e0ffULL, 0x000000000e477faeULL, 0x0005e2000d901c46ULL,
0x00005f002d2d7a11ULL, 0x000fe200030f4c30ULL, 0x0000001063637824ULL, 0x000fe200078e0218ULL,
0x0000003178317210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff307224ULL, 0x000fe200020e06ffULL,
0x00005e002f2e7a11ULL, 0x000fe200078c48ffULL, 0x0000000022497faeULL, 0x0007e2000e901c46ULL,
0x000000325500720cULL, 0x000fe20003f86070ULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x00005f002f2f7a11ULL, 0x000fe200030f4c30ULL, 0x00000010330c7825ULL, 0x002fe200078e0024ULL,
0x00005e0031307a11ULL, 0x000fc400078648ffULL, 0x000000325d00720cULL, 0x080fe20003fc6070ULL,
0x00000010330e7825ULL, 0x004fe200078e0026ULL, 0x000000326100720cULL, 0x080fe20003fa6070ULL,
0x000000000c4b7faeULL, 0x0007e2000d101c46ULL, 0x00005f0031317a11ULL, 0x000fe200018f4c44ULL,
0x0000001033247825ULL, 0x000fe200078e002cULL, 0x000000326b00720cULL, 0x000fe20003f66070ULL,
0x000000000e577faeULL, 0x0007e4000e101c46ULL, 0x0000001033267825ULL, 0x000fc800078e002eULL,
0x00000010332c7825ULL, 0x000fe200078e0030ULL, 0x00000000245f7faeULL, 0x0007e6000f101c46ULL,
0x000000106d6d7824ULL, 0x000fe200078e0218ULL, 0x0000000026637faeULL, 0x0007e8000e901c46ULL,
0x000000002c6d7faeULL, 0x0007e2000d901c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x0000000802237811ULL, 0x060fe400078fe8ffULL, 0x00000004020f7811ULL, 0x000fc400078fe8ffULL,
0x00000014022d7811ULL, 0x040fe200078fe8ffULL, 0x00000001230d7824ULL, 0x140fe200078e0202ULL,
0x0000001002277811ULL, 0x040fe200078fe8ffULL, 0x0000000823227824ULL, 0x000fe200078e00ffULL,
0x0000000c02257811ULL, 0x000fe200078fe8ffULL, 0x000000010f0c7824ULL, 0x140fe200078e0202ULL,
0x000000400a317810ULL, 0x000fe20007ffe0ffULL, 0x000000080f477824ULL, 0x000fe200078e00ffULL,
0xfffffff822497812ULL, 0x000fe200078ee20dULL, 0x000000012d0d7824ULL, 0x040fe200078e0202ULL,
0x00000018022f7811ULL, 0x000fe200078fe8ffULL, 0x000000082d227824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee20cULL, 0x00000001270c7824ULL, 0x000fc400078e0202ULL,
0x0000000827557824ULL, 0x000fe200078e00ffULL, 0xfffffff822577812ULL, 0x000fe200078ee20dULL,
0x00000001250e7824ULL, 0x040fe200078e0202ULL, 0x00000031020d7211ULL, 0x040fe200078fe8ffULL,
0x00000008254b7824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fe200078ee20cULL,
0x000000010f0f7824ULL, 0x100fe200078e0231ULL, 0x0000001c020c7811ULL, 0x000fe200078fe8ffULL,
0x000000082f5d7824ULL, 0x000fe200078e00ffULL, 0x0000000d780d7210ULL, 0x040fe20007f5e0ffULL,
0x0000000123237824ULL, 0x100fe200078e0231ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee20eULL,
0x000000012f0e7824ULL, 0x000fe200078e0202ULL, 0x0000000f780f7210ULL, 0x000fe20007f7e0ffULL,
0x0000000125257824ULL, 0x000fc400078e0231ULL, 0x0000000127277824ULL, 0x100fe200078e0231ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee20eULL, 0x000000012d2d7824ULL, 0x100fe400078e0231ULL,
0x000000012f2f7824ULL, 0x100fe200078e0231ULL, 0x0000002778277210ULL, 0x000fe20007f9e0ffULL,
0x000000010c317824ULL, 0x040fe400078e0231ULL, 0x000000010c267824ULL, 0x040fe400078e0202ULL,
0x000000080c5f7824ULL, 0x000fc400078e00ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00005f000d0d7a11ULL, 0x000fe200010f4c24ULL, 0x0000001047477824ULL, 0x100fe200078e0218ULL,
0x0000002378237210ULL, 0x040fe20007f5e0ffULL, 0x0000001049497824ULL, 0x000fe200078e0218ULL,
0x00005f000f0f7a11ULL, 0x000fe200018f4c22ULL, 0x000000104b4b7824ULL, 0x100fe200078e0218ULL,
0x0000002578257210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e0023227a11ULL, 0x000fe200078448ffULL, 0x0000001055557824ULL, 0x000fe200078e0218ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee226ULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078648ffULL, 0x0000001057577824ULL, 0x000fe200078e0218ULL,
0x00005f0023237a11ULL, 0x000fe200010f4c30ULL, 0x000000105d5d7824ULL, 0x100fe200078e0218ULL,
0x00005e0027267a11ULL, 0x000fe200078848ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0218ULL,
0x0000000202307211ULL, 0x000fc400078fe8ffULL, 0x00005f0025257a11ULL, 0x000fe400018f4c2eULL,
0x0000002d782d7210ULL, 0x000fe40007f5e0ffULL, 0x00005f0027277a11ULL, 0x000fe400020f4c2cULL,
0x0000000730337812ULL, 0x000fe200078ec0ffULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0x0000002f782f7210ULL, 0x040fe40007f7e0ffULL, 0x0000003178317210ULL, 0x000fc40007f9e0ffULL,
0x0ffffff833457812ULL, 0x000fe200078ef802ULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078448ffULL, 0x0000000108337824ULL, 0x000fe200078e0216ULL,
0x00005e002f2e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff327224ULL, 0x000fe200020e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078848ffULL, 0x0000001045457824ULL, 0x000fe200078e0218ULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4c46ULL, 0x00000010330c7825ULL, 0x000fe200078e000cULL,
0x00005f002f2f7a11ULL, 0x000fc400018f4c44ULL, 0x00005f0031317a11ULL, 0x000fe200020f4c32ULL,
0x00000010330e7825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c457faeULL, 0x0003e6000b901c46ULL, 0x0000001033227825ULL, 0x040fe200078e0022ULL,
0x000000000e477faeULL, 0x0003e6000b901c46ULL, 0x0000001033247825ULL, 0x040fe200078e0024ULL,
0x0000000022497faeULL, 0x0003e6000b901c46ULL, 0x0000001033267825ULL, 0x040fe200078e0026ULL,
0x00000000244b7faeULL, 0x0003e6000b901c46ULL, 0x00000010332c7825ULL, 0x040fe200078e002cULL,
0x0000000026557faeULL, 0x0003e6000b901c46ULL, 0x00000010332e7825ULL, 0x040fe200078e002eULL,
0x000000002c577faeULL, 0x0003e6000b901c46ULL, 0x0000001033307825ULL, 0x000fe200078e0030ULL,
0x000000002e5d7faeULL, 0x0003e8000b901c46ULL, 0x00000000305f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000013ff0c723eULL, 0x00afe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011602ULL,
0x000054100c6b7816ULL, 0x000fe2000000000cULL, 0x00015d027f007947ULL, 0x000fea000b800000ULL,
0x00001f0e6b147589ULL, 0x0002a400000e0000ULL, 0x000000080e2e7810ULL, 0x000fe20007ffe0ffULL,
0x00015d227f007947ULL, 0x000fea000b800000ULL, 0x00001f2e6b157589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000100e2e7810ULL, 0x008fe40007ffe0ffULL,
0x00004140002c7802ULL, 0x000fc40000000f00ULL, 0x0001681000007944ULL, 0x006fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000180e2e7810ULL, 0x00cfe40007ffe0ffULL,
0x00004180002c7802ULL, 0x000fc40000000f00ULL, 0x000167d000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008160e7812ULL, 0x00afe200078ef802ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000468227810ULL, 0x000fc60007ffe0ffULL,
0x000000080e0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d227812ULL, 0x000fe400078ee222ULL,
0x00000008020d7812ULL, 0x000fe400078ec0ffULL, 0x0000a00022447811ULL, 0x000fca00078e20ffULL,
0x000000070d0d7812ULL, 0x000fe200078ef802ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000100018237810ULL, 0x000fe40007ffe0ffULL, 0x0000000d020c7211ULL, 0x000fe200078fe0ffULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x000000106a247824ULL, 0x000fc400078e0223ULL,
0x0000001069257824ULL, 0x100fe200078e0223ULL, 0xfffffff80d2c7812ULL, 0x000fe200078ee20cULL,
0x0000001028267824ULL, 0x100fe200078e0223ULL, 0x00000006680c7810ULL, 0x000fe20007ffe0ffULL,
0x000000002470783bULL, 0x000ee20000004200ULL, 0x000000080e0d7824ULL, 0x000fe400078e00ffULL,
0x000000102c277824ULL, 0x100fe200078e0223ULL, 0x00000000256c783bULL, 0x000f220000004200ULL,
0x0000001029297824ULL, 0x100fe200078e0223ULL, 0xfffffff80d287812ULL, 0x000fe200078ee20cULL,
0x000000102a2a7824ULL, 0x100fe200078e0223ULL, 0x000000002668783bULL, 0x000fe20000004200ULL,
0x00000010790c7824ULL, 0x100fe200078e0223ULL, 0x0000a00028547811ULL, 0x000fe200078e20ffULL,
0x00000010740d7824ULL, 0x000fe200078e0223ULL, 0x000000002748783bULL, 0x000fe80000004200ULL,
0x000000005454783bULL, 0x000ea80000000200ULL, 0x00000000295c783bULL, 0x000ea80000004200ULL,
0x000000002a60783bULL, 0x000ea80000004200ULL, 0x000000000c30783bULL, 0x000ea40000004200ULL,
0x0000001444440232ULL, 0x006fc40000000000ULL, 0x0000001446460232ULL, 0x000fe20000000000ULL,
0x000000000d2c783bULL, 0x000e620000004200ULL, 0x0000001545450232ULL, 0x080fe40000000000ULL,
0x0000001547470232ULL, 0x000fce0000000000ULL, 0x000000704458723cULL, 0x048f700000001858ULL,
0x0000006c4464723cULL, 0x010f620000001864ULL, 0x0000001454540232ULL, 0x000fce0000000000ULL,
0x00000068444c723cULL, 0x000f62000000184cULL, 0x0000001456560232ULL, 0x000fe40000000000ULL,
0x0000001555550232ULL, 0x080fe40000000000ULL, 0x0000001557570232ULL, 0x000fc60000000000ULL,
0x000000724440723cULL, 0x040f700000001840ULL, 0x0000006e443c723cULL, 0x040f70000000183cULL,
0x0000006a4438723cULL, 0x040f700000001838ULL, 0x000000484450723cULL, 0x040f700000001850ULL,
0x0000004a4434723cULL, 0x000f700000001834ULL, 0x0000005c5458723cULL, 0x060b700000001858ULL,
0x000000605464723cULL, 0x040b700000001864ULL, 0x00000030544c723cULL, 0x040b70000000184cULL,
0x0000005e545c723cULL, 0x040b700000001840ULL, 0x000000625460723cULL, 0x040b70000000183cULL,
0x000000325430723cULL, 0x040b700000001838ULL, 0x0000002c5450723cULL, 0x042b700000001850ULL,
0x0000002e5454723cULL, 0x000b620000001834ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000040030f7811ULL, 0x000fe200078e40ffULL, 0x01468800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff747224ULL, 0x000fc400078e0077ULL, 0x000000040f00720cULL, 0x000fda0003f06070ULL,
0x0000806000000947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff357819ULL, 0x020fe20000011602ULL,
0x0000000108417824ULL, 0x000fe200078e0216ULL, 0x000000600a2e7810ULL, 0x000fe40007ffe0ffULL,
0x0000006003097811ULL, 0x000fe400078e40ffULL, 0x00000004353f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001350f7824ULL, 0x040fe200078e022eULL, 0x00000009042c7217ULL, 0x000fe40007800000ULL,
0x0000000835437810ULL, 0x000fe20007ffe0ffULL, 0x000000013f2d7824ULL, 0x140fe200078e0202ULL,
0x0000000f780f7210ULL, 0x000fe20007f1e0ffULL, 0x000000083f367824ULL, 0x000fe200078e00ffULL,
0x0000000c35457810ULL, 0x000fe20007ffe0ffULL, 0x00000001432f7824ULL, 0x100fe200078e0202ULL,
0x0000001035477810ULL, 0x000fe20007ffe0ffULL, 0x00000008433e7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee22dULL, 0x000000012c2c7824ULL, 0x000fe200078e0a09ULL,
0x0000001435497810ULL, 0x040fe20007ffe0ffULL, 0x0000000135097824ULL, 0x000fe200078e0202ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee22fULL, 0x000000013f2d7824ULL, 0x000fe200078e022eULL,
0x00000018354b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200000e06ffULL,
0x00000007092f7812ULL, 0x000fe200078ec0ffULL, 0x0000000145377824ULL, 0x100fe200078e0202ULL,
0x00005e000f0e7a11ULL, 0x000fe200078048ffULL, 0x0000000845407824ULL, 0x000fe200078e00ffULL,
0x000000202c097817ULL, 0x000fe20003800000ULL, 0x0000000147387824ULL, 0x100fe200078e0202ULL,
0x0ffffff82f2c7812ULL, 0x100fe200078ef802ULL, 0x00000008473b7824ULL, 0x000fe200078e00ffULL,
0x0000002d782d7210ULL, 0x000fe20007f5e0ffULL, 0x0000000149397824ULL, 0x000fe200078e0202ULL,
0x00005f000f0f7a11ULL, 0x000fe200000f4c34ULL, 0x000000102c2f7824ULL, 0x000fe200078e0223ULL,
0x000000093500720cULL, 0x040fe20003f06070ULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x0000001c35697810ULL, 0x000fe20007ffe0ffULL, 0x0000000143357824ULL, 0x000fe200078e022eULL,
0x00005e002d2c7a11ULL, 0x000fe200078448ffULL, 0x0000000849447824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee237ULL, 0x00000010410e7825ULL, 0x000fe200078e000eULL,
0x00005f002d2d7a11ULL, 0x000fc400010f4c34ULL, 0x0000003578347210ULL, 0x000fe20007f5e0ffULL,
0x0000000145377824ULL, 0x000fe200078e022eULL, 0xfffffff83b427812ULL, 0x000fe200078ee238ULL,
0x00000001493b7824ULL, 0x100fe200078e022eULL, 0xfffffff844447812ULL, 0x000fe200078ee239ULL,
0x0000000147397824ULL, 0x100fe200078e022eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e2f7faeULL, 0x0003e2000c101c46ULL, 0x000000014b3d7824ULL, 0x100fe200078e022eULL,
0x0000003778377210ULL, 0x000fe20007f7e0ffULL, 0x0000000169357824ULL, 0x040fe200078e022eULL,
0x00005e00342e7a11ULL, 0x000fe200078c48ffULL, 0x0000000869487824ULL, 0x000fe200078e00ffULL,
0x0000003978397210ULL, 0x040fe20007f1e0ffULL, 0x000000084b467824ULL, 0x000fe200078e00ffULL,
0x0000003b783b7210ULL, 0x000fc40007f9e0ffULL, 0x0000003d783d7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x000000094300720cULL, 0x000fe20003f06070ULL,
0x000000ffff0f7224ULL, 0x002fe200010e06ffULL, 0x0000003578787210ULL, 0x000fe20007f5e0ffULL,
0x0000000169357824ULL, 0x100fe400078e0202ULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x00005f00342f7a11ULL, 0x000fe200030f4c0fULL, 0x000000014b0f7824ULL, 0x000fe200078e0202ULL,
0x00005e0037347a11ULL, 0x000fc400078c48ffULL, 0x000000093f00720cULL, 0x000fe20003f66070ULL,
0x00000010363f7824ULL, 0x000fe200078e0223ULL, 0xfffffff848487812ULL, 0x000fe400078ee235ULL,
0x00005f0037357a11ULL, 0x000fe400030f4c0eULL, 0x00005e0039367a11ULL, 0x000fe200078c48ffULL,
0x0000001048437824ULL, 0x000fe200078e0223ULL, 0xfffffff846467812ULL, 0x000fe200078ee20fULL,
0x00000010410e7825ULL, 0x000fe200078e002cULL, 0x00005f0039377a11ULL, 0x000fc400030f4c38ULL,
0x00005e003b387a11ULL, 0x000fe200078c48ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x000000000e3f7faeULL, 0x0003e2000d901c46ULL, 0x000000ffff2d7224ULL, 0x000fe200010e06ffULL,
0x000000094500720cULL, 0x000fe40003f66070ULL, 0x00005f003b397a11ULL, 0x000fe200030f4c2cULL,
0x000000ffff2c7224ULL, 0x000fe200028e06ffULL, 0x00005e003d3a7a11ULL, 0x000fe400078a48ffULL,
0x00005e00783c7a11ULL, 0x000fc400078c48ffULL, 0x000000094700720cULL, 0x080fe40003f86070ULL,
0x000000094900720cULL, 0x080fe20003f46070ULL, 0x00000010410e7825ULL, 0x002fe200078e002eULL,
0x00005f003d3b7a11ULL, 0x000fe400028f4c2cULL, 0x000000094b00720cULL, 0x080fe20003fa6070ULL,
0x00000010412e7825ULL, 0x000fe200078e0036ULL, 0x00005f00783d7a11ULL, 0x000fe400030f4c2dULL,
0x000000096900720cULL, 0x000fe20003fc6070ULL, 0x00000010412c7825ULL, 0x000fc800078e0034ULL,
0x000000103e097824ULL, 0x000fe400078e0223ULL, 0x0000001041347825ULL, 0x000fc600078e0038ULL,
0x000000000e097faeULL, 0x0003e2000c101c46ULL, 0x0000001041367825ULL, 0x000fc800078e003aULL,
0x0000001041387825ULL, 0x000fc800078e003cULL, 0x00000010403b7824ULL, 0x100fe400078e0223ULL,
0x00000010423d7824ULL, 0x100fe400078e0223ULL, 0x00000010443f7824ULL, 0x100fe200078e0223ULL,
0x000000002c3b7faeULL, 0x0003e2000d901c46ULL, 0x0000001046417824ULL, 0x000fc600078e0223ULL,
0x000000002e3d7faeULL, 0x0003e8000e101c46ULL, 0x00000000343f7faeULL, 0x0003e8000d101c46ULL,
0x0000000036417faeULL, 0x0003e8000e901c46ULL, 0x0000000038437faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000004020f7811ULL, 0x000fe200078fe8ffULL,
0x0000000108437824ULL, 0x020fe200078e0216ULL, 0x00000008022f7811ULL, 0x000fc400078fe8ffULL,
0x0000000c02357811ULL, 0x000fe200078fe8ffULL, 0x000000010f097824ULL, 0x140fe200078e0202ULL,
0x000000600a3b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f447824ULL, 0x000fe200078e00ffULL,
0x0000001002367811ULL, 0x040fe200078fe8ffULL, 0x000000082f467824ULL, 0x000fe200078e00ffULL,
0x0000001802397811ULL, 0x000fe200078fe8ffULL, 0x00000001350e7824ULL, 0x100fe200078e0202ULL,
0xfffffff844447812ULL, 0x000fe200078ee209ULL, 0x000000012f097824ULL, 0x000fe200078e0202ULL,
0x0000001c023c7811ULL, 0x000fe200078fe8ffULL, 0x00000008352d7824ULL, 0x000fc400078e00ffULL,
0x000000010f0f7824ULL, 0x000fe200078e023bULL, 0xfffffff846467812ULL, 0x000fe200078ee209ULL,
0x00000001362c7824ULL, 0x000fe200078e0202ULL, 0x0000003b02097211ULL, 0x000fe200078fe8ffULL,
0x0000000836377824ULL, 0x000fe200078e00ffULL, 0xfffffff82d487812ULL, 0x000fe200078ee20eULL,
0x00000001393a7824ULL, 0x140fe200078e0202ULL, 0x00000009782d7210ULL, 0x000fe20007f1e0ffULL,
0x000000013c3e7824ULL, 0x000fe200078e0202ULL, 0x0000000f78097210ULL, 0x000fe20007f5e0ffULL,
0x00000008390f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8374a7812ULL, 0x000fe200078ee22cULL,
0x000000ffff347224ULL, 0x000fe200000e06ffULL, 0x00005e002d0e7a11ULL, 0x000fe200078048ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e00092c7a11ULL, 0x000fe200078448ffULL,
0x0000000139397824ULL, 0x000fe200078e023bULL, 0xfffffff80f6a7812ULL, 0x000fe200078ee23aULL,
0x000000083c3f7824ULL, 0x000fe200078e00ffULL, 0x00005f002d0f7a11ULL, 0x000fe200000f4c34ULL,
0x0000001046417824ULL, 0x100fe200078e0223ULL, 0x0000001402377811ULL, 0x000fe200078fe8ffULL,
0x000000104a457824ULL, 0x000fe200078e0223ULL, 0x00005f00092d7a11ULL, 0x000fe200010f4c2eULL,
0x000000012f097824ULL, 0x000fe200078e023bULL, 0xfffffff83f6c7812ULL, 0x000fe200078ee23eULL,
0x0000000137387824ULL, 0x000fc400078e0202ULL, 0x00000008373d7824ULL, 0x000fe200078e00ffULL,
0x0000000978347210ULL, 0x000fe20007f7e0ffULL, 0x00000001352f7824ULL, 0x100fe400078e023bULL,
0x0000000136357824ULL, 0x100fe200078e023bULL, 0xfffffff83d687812ULL, 0x000fe200078ee238ULL,
0x0000000137377824ULL, 0x100fe200078e023bULL, 0x0000002f783a7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200018e06ffULL, 0x0000003578387210ULL, 0x000fe20007f5e0ffULL,
0x000000013c097824ULL, 0x000fe200078e023bULL, 0x00005e00342e7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff357224ULL, 0x000fe200000e06ffULL, 0x00000037783d7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff377224ULL, 0x000fe200010e06ffULL, 0x00005f00342f7a11ULL, 0x000fe200030f4c2fULL,
0x00000010430e7825ULL, 0x000fe200078e000eULL, 0x00005e003a347a11ULL, 0x000fc400078048ffULL,
0x00005e0038367a11ULL, 0x000fe200078448ffULL, 0x000000ffff427224ULL, 0x000fe200028e06ffULL,
0x00000039783b7210ULL, 0x040fe20007f7e0ffULL, 0x00000010432c7825ULL, 0x040fe200078e002cULL,
0x0000000978097210ULL, 0x000fe40007f9e0ffULL, 0x0000000202397211ULL, 0x000fe200078fe8ffULL,
0x000000ffff407224ULL, 0x000fe200018e06ffULL, 0x00005f003a357a11ULL, 0x000fe200000f4c35ULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00005f0038377a11ULL, 0x000fe200010f4c37ULL,
0x00000010432e7825ULL, 0x000fe200078e002eULL, 0x00005e003d387a11ULL, 0x000fc400078048ffULL,
0x00000007393f7812ULL, 0x000fe200078ec0ffULL, 0x0000001043347825ULL, 0x000fe200078e0034ULL,
0x00005e003b3a7a11ULL, 0x000fe400078448ffULL, 0x00005e00093c7a11ULL, 0x000fe200078648ffULL,
0x0000001043367825ULL, 0x000fe200078e0036ULL, 0x00005f003d397a11ULL, 0x000fe400000f4c42ULL,
0x0ffffff83f427812ULL, 0x000fe200078ef802ULL, 0x00000010443f7824ULL, 0x000fe200078e0223ULL,
0x00005f003b3b7a11ULL, 0x000fe200010f4c40ULL, 0x0000001043387825ULL, 0x000fe200078e0038ULL,
0x00005f00093d7a11ULL, 0x000fc600018f4c3eULL, 0x0000001042097824ULL, 0x000fe400078e0223ULL,
0x00000010433a7825ULL, 0x000fc600078e003aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000b901c46ULL, 0x00000010433c7825ULL, 0x000fc600078e003cULL,
0x000000002c3f7faeULL, 0x0003e2000b901c46ULL, 0x0000001048437824ULL, 0x100fe400078e0223ULL,
0x0000001068477824ULL, 0x100fe200078e0223ULL, 0x000000002e417faeULL, 0x0003e2000b901c46ULL,
0x000000106a497824ULL, 0x100fe400078e0223ULL, 0x000000106c4b7824ULL, 0x000fe200078e0223ULL,
0x0000000034437faeULL, 0x0003e8000b901c46ULL, 0x0000000036457faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x000000003a497faeULL, 0x0003e8000b901c46ULL,
0x000000003c4b7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff0e7624ULL, 0x002fe200078e00ffULL,
0x0000000107097812ULL, 0x000fc800078ec0ffULL, 0x000000010900780cULL, 0x000fe20003f05070ULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0xffffffff0e0e7811ULL, 0x000fc800078e08ffULL,
0x000000010e0e7807ULL, 0x000fca0004000000ULL, 0x0000000107077824ULL, 0x000fca00078e020eULL,
0x000000050700720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000e102c7210ULL, 0x000fe20007ffe011ULL, 0x00000004ff2d7424ULL, 0x000fc800078e00ffULL,
0x000060002c2c7625ULL, 0x000fca00078e002dULL, 0x000000062c097981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146280008347f8cULL, 0x0004e4000c80043fULL, 0x00000000002c7805ULL, 0x002fc40000015200ULL,
0x01462c00080f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x00afe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c2e7210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09002e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc8000001142fULL,
0x0000002e0f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff2e7224ULL, 0x000fca00000e062fULL,
0x000000020f0f7819ULL, 0x000fc8000000122eULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01462c00080f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0140800012347984ULL, 0x000e680000000800ULL, 0x0142800012367984ULL, 0x0006a20000000800ULL,
0x000000773400720bULL, 0x002fe20003f1d000ULL, 0x000147527f007947ULL, 0x000fd8000b800000ULL,
0x00000000000f7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0fff7812ULL, 0x000fe2000784c0ffULL,
0x0000046000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff747224ULL, 0x000fd400078e0077ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe40003f05270ULL, 0x000000773400720bULL, 0x000fe20003f54000ULL,
0x000147127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000387806ULL, 0x000fc400010e0100ULL,
0x00000077342d8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910382c7816ULL, 0x000fc600000000ffULL, 0x0144802d12008388ULL, 0x0003e20000000800ULL,
0x000000ff2c00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000077342c7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff38ff7812ULL, 0x000fc6000780c0ffULL, 0x000000772c2c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c006b7308ULL, 0x000e640000000800ULL,
0x0000006b0b0b7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe20000011602ULL, 0x000146427f007947ULL, 0x000fea000b800000ULL,
0x00001f2e6b2e7589ULL, 0x0002e400000e0000ULL, 0x0000002e50507220ULL, 0x08cfe20000410000ULL,
0x0000002e51517220ULL, 0x080fe20000410000ULL, 0x0000002e54547220ULL, 0x080fe20000410000ULL,
0x0000002e55557220ULL, 0x080fe20000410000ULL, 0x0000002e58587220ULL, 0x080fe20000410000ULL,
0x0000002e59597220ULL, 0x080fe20000410000ULL, 0x0000002e5c5c7220ULL, 0x080fe20000410000ULL,
0x0000002e5d5d7220ULL, 0x080fe20000410000ULL, 0x0000002e64647220ULL, 0x080fe20000410000ULL,
0x0000002e65657220ULL, 0x080fe20000410000ULL, 0x0000002e60607220ULL, 0x080fe20000410000ULL,
0x0000002e61617220ULL, 0x080fe20000410000ULL, 0x0000002e4c4c7220ULL, 0x080fe20000410000ULL,
0x0000002e4d4d7220ULL, 0x080fe20000410000ULL, 0x0000002e30307220ULL, 0x080fe20000410000ULL,
0x0000002e31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0038ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008022e7811ULL, 0x000fe200078ff0ffULL, 0x000145127f007947ULL, 0x000fea000b800000ULL,
0x00001f2e6b2e7589ULL, 0x00066400000e0000ULL, 0x0000002e52527220ULL, 0x086fe20000410000ULL,
0x0000002e53537220ULL, 0x080fe20000410000ULL, 0x0000002e56567220ULL, 0x080fe20000410000ULL,
0x0000002e57577220ULL, 0x080fe20000410000ULL, 0x0000002e5a5a7220ULL, 0x080fe20000410000ULL,
0x0000002e5b5b7220ULL, 0x080fe20000410000ULL, 0x0000002e5e5e7220ULL, 0x080fe20000410000ULL,
0x0000002e5f5f7220ULL, 0x080fe20000410000ULL, 0x0000002e66667220ULL, 0x080fe20000410000ULL,
0x0000002e67677220ULL, 0x080fe20000410000ULL, 0x0000002e62627220ULL, 0x080fe20000410000ULL,
0x0000002e63637220ULL, 0x080fe20000410000ULL, 0x0000002e4e4e7220ULL, 0x080fe20000410000ULL,
0x0000002e4f4f7220ULL, 0x080fe20000410000ULL, 0x0000002e32327220ULL, 0x080fe20000410000ULL,
0x0000002e33337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff38ff7812ULL, 0x000fe4000780080fULL, 0x0000007734747209ULL, 0x000fd60007810000ULL,
0x8000007434340221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL,
0x0000003400130308ULL, 0x000e640000000800ULL, 0x0000001336360220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000000b360b7221ULL, 0x004fe20000010000ULL,
0x0000010000008947ULL, 0x000fea0003800000ULL, 0x00000013ff0f723eULL, 0x000fe400000000ffULL,
0x00000002ff347819ULL, 0x000fe40000011602ULL, 0x000054100f6b7816ULL, 0x008fe2000000000fULL,
0x000143327f007947ULL, 0x000fea000b800000ULL, 0x00001f346b147589ULL, 0x0002a400000e0000ULL,
0x00000008342e7810ULL, 0x000fe20007ffe0ffULL, 0x000143527f007947ULL, 0x000fea000b800000ULL,
0x00001f2e6b157589ULL, 0x00066400000e0000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x00000010342e7810ULL, 0x008fe40007ffe0ffULL, 0x00005c90002c7802ULL, 0x000fc40000000f00ULL,
0x00014cc000007944ULL, 0x016fea0003c00000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x00000018342e7810ULL, 0x00cfe40007ffe0ffULL, 0x00005cd0002c7802ULL, 0x000fc40000000f00ULL,
0x00014c8000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a80017447811ULL, 0x000fcc00078e20ffULL,
0x000000004444783bULL, 0x000ee20000000200ULL, 0x0000a8001d407811ULL, 0x000fe200078e20ffULL,
0x00005800090f7a24ULL, 0x010fc400078e02ffULL, 0x000000001970783bULL, 0x000ea40000004200ULL,
0x000000800f0f7824ULL, 0x000fe400078e00ffULL, 0x000000001a6c783bULL, 0x000fe80000004200ULL,
0x000000001b68783bULL, 0x00afe80000004200ULL, 0x000000001c48783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000e680000000200ULL, 0x000000001e3c783bULL, 0x000ee80000004200ULL,
0x000000001f38783bULL, 0x000ee80000004200ULL, 0x000000002034783bULL, 0x000ee80000004200ULL,
0x00000000212c783bULL, 0x004ea20000004200ULL, 0x0000001444440232ULL, 0x000fc40000000000ULL,
0x0000001446460232ULL, 0x000fe40000000000ULL, 0x0000001545450232ULL, 0x080fe40000000000ULL,
0x0000001547470232ULL, 0x000fce0000000000ULL, 0x000000704450723cULL, 0x000f620000001850ULL,
0x0000001440400232ULL, 0x002fce0000000000ULL, 0x0000006c4458723cULL, 0x000f620000001858ULL,
0x0000001442420232ULL, 0x000fe40000000000ULL, 0x0000001541410232ULL, 0x080fe40000000000ULL,
0x0000001543430232ULL, 0x000fc60000000000ULL, 0x000000684464723cULL, 0x040f700000001864ULL,
0x000000724454723cULL, 0x040f700000001854ULL, 0x0000006e445c723cULL, 0x040f70000000185cULL,
0x0000006a4460723cULL, 0x040f700000001860ULL, 0x00000048444c723cULL, 0x040f70000000184cULL,
0x0000004a4430723cULL, 0x000f700000001830ULL, 0x0000003c4050723cULL, 0x068b700000001850ULL,
0x000000384058723cULL, 0x040b700000001858ULL, 0x000000344064723cULL, 0x040b700000001864ULL,
0x0000003e403c723cULL, 0x040b700000001854ULL, 0x0000003a4038723cULL, 0x040b70000000185cULL,
0x000000364034723cULL, 0x040b700000001860ULL, 0x0000002c404c723cULL, 0x044b70000000184cULL,
0x0000002e4040723cULL, 0x000b620000001830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000009947ULL, 0x000fca0003800000ULL, 0x00000003ff477819ULL, 0x020fe20000011602ULL,
0x0000000108557824ULL, 0x000fe200078e0216ULL, 0x00000080032d7811ULL, 0x000fe400078e40ffULL,
0x0000000447337810ULL, 0x040fe40007ffe0ffULL, 0x0000000847457810ULL, 0x000fe40007ffe0ffULL,
0x0000002d042c7217ULL, 0x000fe20007800000ULL, 0x00000001332f7824ULL, 0x100fe200078e0202ULL,
0x0000000c47497810ULL, 0x000fe20007ffe0ffULL, 0x0000000833327824ULL, 0x000fe200078e00ffULL,
0x00000014476b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000145307824ULL, 0x100fe200078e0202ULL,
0x0000001047637810ULL, 0x000fe20007ffe0ffULL, 0x00000008455f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8324b7812ULL, 0x000fe200078ee22fULL, 0x000000012c2e7824ULL, 0x000fe200078e0a2dULL,
0x00000018476f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001492c7824ULL, 0x000fe200078e0202ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee230ULL, 0x0000000849617824ULL, 0x000fe200078e00ffULL,
0x0000001c47737810ULL, 0x000fe20007ffe0ffULL, 0x000000016b2f7824ULL, 0x040fe200078e0202ULL,
0x000000202e547817ULL, 0x000fe20003800000ULL, 0x000000086b327824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee22cULL, 0x00000001632d7824ULL, 0x000fe200078e0202ULL,
0x000000544500720cULL, 0x000fe20003fa6070ULL, 0x0000000863307824ULL, 0x000fe200078e00ffULL,
0xfffffff8326d7812ULL, 0x000fe200078ee22fULL, 0x000000010a2c7824ULL, 0x000fc400078e0247ULL,
0x000000016f2f7824ULL, 0x140fe200078e0202ULL, 0xfffffff830697812ULL, 0x000fe200078ee22dULL,
0x000000086f447824ULL, 0x000fe200078e00ffULL, 0x0000002c0f2d7210ULL, 0x000fe20007f5e0ffULL,
0x000000010a307824ULL, 0x000fe400078e0233ULL, 0x0000000173317824ULL, 0x040fe200078e0202ULL,
0xfffffff844717812ULL, 0x000fe200078ee22fULL, 0x0000000873467824ULL, 0x000fe200078e00ffULL,
0x000000300f2f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x00005e002d2c7a11ULL, 0x040fe200078448ffULL, 0x000000010a307824ULL, 0x000fe200078e0245ULL,
0xfffffff846777812ULL, 0x000fe200078ee231ULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4c32ULL, 0x000000010a327824ULL, 0x000fe200078e0249ULL,
0x000000300f317210ULL, 0x000fe20007f9e0ffULL, 0x000000104b5d7824ULL, 0x000fe200078e0218ULL,
0x00005e002f2e7a11ULL, 0x000fe200078448ffULL, 0x00000010552c7825ULL, 0x000fe200078e002cULL,
0x000000543300720cULL, 0x000fc40003f66070ULL, 0x00005f002f2f7a11ULL, 0x000fe200010f4c44ULL,
0x000000ffff467224ULL, 0x000fe200020e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078448ffULL,
0x000000010a447824ULL, 0x040fe200078e0263ULL, 0x000000320f337210ULL, 0x000fe20007f9e0ffULL,
0x00000010552e7825ULL, 0x000fe200078e002eULL, 0x00005f0031317a11ULL, 0x000fe400010f4c46ULL,
0x000000440f457210ULL, 0x000fe20007fde0ffULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x000000544700720cULL, 0x0c0fe20003f86070ULL, 0x0000000147477824ULL, 0x000fe200078e0202ULL,
0x00005e0033327a11ULL, 0x000fe200078448ffULL, 0x000000ffff487224ULL, 0x000fe200030e06ffULL,
0x00005e0045447a11ULL, 0x000fe200078c48ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0218ULL,
0x00005f0033337a11ULL, 0x000fe200010f4c46ULL, 0x000000010a467824ULL, 0x000fe200078e026bULL,
0x0000000747477812ULL, 0x000fe200078ec0ffULL, 0x0000001055307825ULL, 0x000fe200078e0030ULL,
0x000000544900720cULL, 0x000fc40003f46070ULL, 0x00005f0045457a11ULL, 0x000fe200030f4c48ULL,
0x000000010a487824ULL, 0x040fe200078e026fULL, 0x0ffffff847497812ULL, 0x000fe200078ef802ULL,
0x0000001061617824ULL, 0x100fe200078e0218ULL, 0x000000460f477210ULL, 0x000fe20007fde0ffULL,
0x0000001069697824ULL, 0x100fe400078e0218ULL, 0x0000001049577824ULL, 0x100fe400078e0218ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x00005e0047467a11ULL, 0x000fe200078c48ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c577faeULL, 0x0003e2000e101c46ULL, 0x000000480f497210ULL, 0x000fe20007f9e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0218ULL, 0x00005f0047477a11ULL, 0x000fe200030f4c4aULL,
0x000000010a4a7824ULL, 0x000fe200078e0273ULL, 0x000000002e5d7faeULL, 0x0005e2000d901c46ULL,
0x00005e0049487a11ULL, 0x000fe200078c48ffULL, 0x0000001077777824ULL, 0x000fc400078e0218ULL,
0x0000004a0f4b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x000000546300720cULL, 0x080fe20003f86070ULL, 0x00000000305f7faeULL, 0x0007e2000e901c46ULL,
0x000000546f00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x00005f0049497a11ULL, 0x000fe200030f4c4aULL, 0x00000010552c7825ULL, 0x002fe200078e0032ULL,
0x00005e004b4a7a11ULL, 0x000fe400078648ffULL, 0x000000546b00720cULL, 0x080fe20003fc6070ULL,
0x00000010552e7825ULL, 0x004fe200078e0044ULL, 0x00005f004b4b7a11ULL, 0x000fe200018f4c56ULL,
0x000000002c617faeULL, 0x0007e2000d101c46ULL, 0x000000547300720cULL, 0x000fe20003f66070ULL,
0x0000001055327825ULL, 0x000fc400078e0046ULL, 0x000000002e697faeULL, 0x0007e4000e101c46ULL,
0x0000001055447825ULL, 0x000fc800078e0048ULL, 0x0000001055467825ULL, 0x000fe200078e004aULL,
0x00000000326d7faeULL, 0x0007e8000f101c46ULL, 0x0000000044717faeULL, 0x0007e8000e901c46ULL,
0x0000000046777faeULL, 0x0007e2000d901c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x0000000802317811ULL, 0x020fe200078fe8ffULL, 0x0000000108557824ULL, 0x000fe200078e0216ULL,
0x0000001002477811ULL, 0x000fc400078fe8ffULL, 0x00000004022f7811ULL, 0x040fe200078fe8ffULL,
0x00000001312d7824ULL, 0x140fe200078e0202ULL, 0x0000001402497811ULL, 0x040fe200078fe8ffULL,
0x0000000831327824ULL, 0x000fe200078e00ffULL, 0x0000000c02337811ULL, 0x040fe200078fe8ffULL,
0x0000000147307824ULL, 0x140fe200078e0202ULL, 0x0000001c02577811ULL, 0x000fe200078fe8ffULL,
0x0000000847637824ULL, 0x000fe200078e00ffULL, 0xfffffff8325f7812ULL, 0x000fe200078ee22dULL,
0x000000012f2c7824ULL, 0x040fe200078e0202ULL, 0x00000018024b7811ULL, 0x040fe200078fe8ffULL,
0x000000082f5d7824ULL, 0x000fe200078e00ffULL, 0xfffffff863637812ULL, 0x000fe200078ee230ULL,
0x00000001492d7824ULL, 0x040fe200078e0202ULL, 0x0000000202457211ULL, 0x040fe200078fe8ffULL,
0x0000000849327824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee22cULL,
0x00000001332e7824ULL, 0x140fe200078e0202ULL, 0x0000000a022c7211ULL, 0x000fe200078fe8ffULL,
0x0000000833617824ULL, 0x000fe200078e00ffULL, 0xfffffff832697812ULL, 0x000fe200078ee22dULL,
0x0000000157307824ULL, 0x040fe200078e0202ULL, 0x0000000f2c2d7210ULL, 0x080fe20007f5e0ffULL,
0x00000008576d7824ULL, 0x000fe200078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee22eULL,
0x000000010a327824ULL, 0x040fe200078e0231ULL, 0x0000000745457812ULL, 0x000fe200078ec0ffULL,
0x000000010a447824ULL, 0x000fe200078e0233ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee230ULL,
0x000000014b2e7824ULL, 0x040fe200078e0202ULL, 0x0000000f32317210ULL, 0x080fe20007f9e0ffULL,
0x000000084b6b7824ULL, 0x000fe200078e00ffULL, 0x0000000f44337210ULL, 0x000fe20007fbe0ffULL,
0x000000010a307824ULL, 0x000fc400078e022fULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee22eULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x0000000f302f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff447224ULL, 0x000fe200028e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078448ffULL, 0x000000010a4a7824ULL, 0x000fe200078e0257ULL,
0x00005e0033327a11ULL, 0x000fe200078848ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4c2eULL, 0x000000105d5d7824ULL, 0x100fe200078e0218ULL,
0x00005e0031307a11ULL, 0x000fe200078648ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0218ULL,
0x00005e002f2e7a11ULL, 0x000fe200078448ffULL, 0x00000010552c7825ULL, 0x000fe200078e002cULL,
0x00005f0033337a11ULL, 0x000fc400020f4c44ULL, 0x00005f0031317a11ULL, 0x000fe200018f4c46ULL,
0x000000010a447824ULL, 0x040fe200078e0247ULL, 0x00005f002f2f7a11ULL, 0x000fe200010f4c48ULL,
0x000000010a467824ULL, 0x040fe200078e0249ULL, 0x0ffffff845577812ULL, 0x000fe200078ef802ULL,
0x000000010a487824ULL, 0x000fe200078e024bULL, 0x0000000f44457210ULL, 0x080fe20007f9e0ffULL,
0x00000010552e7825ULL, 0x000fe200078e002eULL, 0x0000000f46477210ULL, 0x080fe40007fbe0ffULL,
0x0000000f48497210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff5e7224ULL, 0x000fe200020e06ffULL,
0x0000000f4a4b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff5c7224ULL, 0x000fe200028e06ffULL,
0x00005e0045447a11ULL, 0x000fe200078848ffULL, 0x000000ffff567224ULL, 0x000fe200010e06ffULL,
0x00005e0047467a11ULL, 0x000fe200078a48ffULL, 0x000000ffff547224ULL, 0x000fe200018e06ffULL,
0x00005e0049487a11ULL, 0x000fe200078448ffULL, 0x0000001057577824ULL, 0x000fe200078e0218ULL,
0x00005e004b4a7a11ULL, 0x000fe200078648ffULL, 0x0000001055307825ULL, 0x000fe200078e0030ULL,
0x00005f0045457a11ULL, 0x000fc400020f4c5eULL, 0x00005f0047477a11ULL, 0x000fe200028f4c5cULL,
0x0000001055327825ULL, 0x000fe200078e0032ULL, 0x00005f0049497a11ULL, 0x000fe200010f4c56ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c577faeULL, 0x0003e2000b901c46ULL,
0x00005f004b4b7a11ULL, 0x000fe200018f4c54ULL, 0x0000001061617824ULL, 0x000fe400078e0218ULL,
0x0000001055447825ULL, 0x000fe200078e0044ULL, 0x000000002e5d7faeULL, 0x0003e6000b901c46ULL,
0x0000001063637824ULL, 0x000fe200078e0218ULL, 0x00000000305f7faeULL, 0x0003e2000b901c46ULL,
0x0000001055467825ULL, 0x000fc600078e0046ULL, 0x0000000032617faeULL, 0x0003e2000b901c46ULL,
0x0000001069697824ULL, 0x000fe400078e0218ULL, 0x0000001055487825ULL, 0x000fe200078e0048ULL,
0x0000000044637faeULL, 0x0003e6000b901c46ULL, 0x000000106b6b7824ULL, 0x000fe200078e0218ULL,
0x0000000046697faeULL, 0x0003e2000b901c46ULL, 0x00000010554a7825ULL, 0x000fc600078e004aULL,
0x00000000486b7faeULL, 0x0003e2000b901c46ULL, 0x000000106d6d7824ULL, 0x000fca00078e0218ULL,
0x000000004a6d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000008947ULL, 0x000fea0003800000ULL, 0x00000013ff14723eULL, 0x000fe400000000ffULL,
0x00000002ff307819ULL, 0x00afe40000011602ULL, 0x00005410146b7816ULL, 0x000fe20000000014ULL,
0x000132a27f007947ULL, 0x000fea000b800000ULL, 0x00001f306b147589ULL, 0x0002a400000e0000ULL,
0x00000008302e7810ULL, 0x000fe20007ffe0ffULL, 0x000132c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2e6b157589ULL, 0x00066400000e0000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x00000010302e7810ULL, 0x008fe40007ffe0ffULL, 0x00006db0002c7802ULL, 0x000fc40000000f00ULL,
0x00013ba000007944ULL, 0x006fea0003c00000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x00000018302e7810ULL, 0x00cfe40007ffe0ffULL, 0x00006df0002c7802ULL, 0x000fc40000000f00ULL,
0x00013b6000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000a80022447811ULL, 0x00afe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002770783bULL, 0x000fe20000004200ULL, 0x0000a80028307811ULL, 0x000fc600078e20ffULL,
0x000000004444783bULL, 0x000e680000000200ULL, 0x00000000246c783bULL, 0x000fe80000004200ULL,
0x000000002568783bULL, 0x000fe80000004200ULL, 0x000000002648783bULL, 0x000fe80000004200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000000d54783bULL, 0x000f280000004200ULL,
0x00000000295c783bULL, 0x000ea80000004200ULL, 0x000000002a60783bULL, 0x000ea80000004200ULL,
0x000000000c2c783bULL, 0x004ea20000004200ULL, 0x0000001444440232ULL, 0x002fc40000000000ULL,
0x0000001446460232ULL, 0x000fe40000000000ULL, 0x0000001545450232ULL, 0x080fe40000000000ULL,
0x0000001547470232ULL, 0x000fce0000000000ULL, 0x000000704450723cULL, 0x000f620000001850ULL,
0x0000001430300232ULL, 0x088fe40000000000ULL, 0x0000001432320232ULL, 0x000fe40000000000ULL,
0x0000001531310232ULL, 0x000fc60000000000ULL, 0x0000006c4458723cULL, 0x000f620000001858ULL,
0x0000001533330232ULL, 0x000fce0000000000ULL, 0x000000684464723cULL, 0x040f700000001864ULL,
0x00000072443c723cULL, 0x040f70000000183cULL, 0x0000006e4438723cULL, 0x040f700000001838ULL,
0x0000006a4434723cULL, 0x040f700000001834ULL, 0x00000048444c723cULL, 0x040f70000000184cULL,
0x0000004a4440723cULL, 0x000f700000001840ULL, 0x000000543050723cULL, 0x070b700000001850ULL,
0x0000005c3058723cULL, 0x040b700000001858ULL, 0x000000603064723cULL, 0x040b700000001864ULL,
0x000000563054723cULL, 0x040b70000000183cULL, 0x0000005e305c723cULL, 0x040b700000001838ULL,
0x000000623060723cULL, 0x040b700000001834ULL, 0x0000002c304c723cULL, 0x044b70000000184cULL,
0x0000002e3030723cULL, 0x000b620000001840ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000080032d7811ULL, 0x020fe200078e40ffULL, 0x01469000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000042d00720cULL, 0x000fda0003f06070ULL, 0x0000555000000947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x00000003ff3b7819ULL, 0x000fe20000011602ULL, 0x0000000108417824ULL, 0x000fe200078e0216ULL,
0x000000a0032d7811ULL, 0x000fe400078e40ffULL, 0x000000043b357810ULL, 0x040fe40007ffe0ffULL,
0x0000000c3b3d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002d042c7217ULL, 0x000fe20007800000ULL,
0x00000001352e7824ULL, 0x000fe200078e0202ULL, 0x000000103b477810ULL, 0x000fe20007ffe0ffULL,
0x00000008352f7824ULL, 0x000fe200078e00ffULL, 0x000000083b377810ULL, 0x000fe20007ffe0ffULL,
0x000000083d3f7824ULL, 0x000fe200078e00ffULL, 0x000000200a3e7810ULL, 0x000fe20007ffe0ffULL,
0x000000012c2d7824ULL, 0x000fe200078e0a2dULL, 0xfffffff82f427812ULL, 0x000fe200078ee22eULL,
0x000000013d2e7824ULL, 0x100fe200078e0202ULL, 0x000000183b4b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001472f7824ULL, 0x000fe200078e0202ULL, 0x000000143b497810ULL, 0x000fe20007ffe0ffULL,
0x0000000847487824ULL, 0x000fe200078e00ffULL, 0xfffffff83f467812ULL, 0x000fe200078ee22eULL,
0x00000001372c7824ULL, 0x000fe200078e0202ULL, 0x0000001c3b697810ULL, 0x000fe20007ffe0ffULL,
0x0000000837397824ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fe200078ee22fULL,
0x000000013b2e7824ULL, 0x000fe200078e023eULL, 0x000000202d407817ULL, 0x000fe20003800000ULL,
0x000000014b2f7824ULL, 0x000fe200078e0202ULL, 0xfffffff839447812ULL, 0x000fe200078ee22cULL,
0x000000084b6a7824ULL, 0x000fe200078e00ffULL, 0x0000000f2e2e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001492c7824ULL, 0x100fe200078e0202ULL, 0x000000403500720cULL, 0x000fe20003fa6070ULL,
0x0000000849397824ULL, 0x000fe200078e00ffULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee22fULL,
0x0000000169347824ULL, 0x000fc400078e0202ULL, 0x00000008693f7824ULL, 0x000fe200078e00ffULL,
0xfffffff839687812ULL, 0x000fe200078ee22cULL, 0x000000ffff2f7224ULL, 0x000fe200000e06ffULL,
0x00005e002e2c7a11ULL, 0x040fe200078048ffULL, 0x0000000137367824ULL, 0x000fe200078e023eULL,
0xfffffff83f6c7812ULL, 0x000fe200078ee234ULL, 0x0000000135347824ULL, 0x100fe200078e023eULL,
0x00005f002e2d7a11ULL, 0x000fe200000f4c2fULL, 0x00000001473c7824ULL, 0x100fe200078e023eULL,
0x0000000f36357210ULL, 0x080fe20007f7e0ffULL, 0x000000013d3a7824ULL, 0x100fe200078e023eULL,
0x0000000f342f7210ULL, 0x000fe20007f5e0ffULL, 0x00000001494a7824ULL, 0x000fe200078e023eULL,
0x000000403700720cULL, 0x000fe20003f06070ULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078648ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x00005e002f2e7a11ULL, 0x000fe200078448ffULL, 0x00000010412c7825ULL, 0x000fe200078e002cULL,
0x00005f0035357a11ULL, 0x000fc400018f4c36ULL, 0x00005f002f2f7a11ULL, 0x000fe200010f4c38ULL,
0x0000001042457824ULL, 0x000fe200078e0223ULL, 0x0000000f3c397210ULL, 0x080fe40007f9e0ffULL,
0x0000000f3a377210ULL, 0x000fe20007f7e0ffULL, 0x00000010412e7825ULL, 0x000fe200078e002eULL,
0x000000403b00720cULL, 0x000fc60003f46070ULL, 0x000000013b3b7824ULL, 0x000fe400078e0202ULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078848ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x00005e0037367a11ULL, 0x000fe400078648ffULL,
0x000000073b3b7812ULL, 0x000fe400078ec0ffULL, 0x00005f0039397a11ULL, 0x000fe400020f4c3aULL,
0x00005f0037377a11ULL, 0x000fc400018f4c3cULL, 0x0ffffff83b3a7812ULL, 0x000fe400078ef802ULL,
0x0000000f4a3b7210ULL, 0x000fe20007f7e0ffULL, 0x000000014b4a7824ULL, 0x100fe200078e023eULL,
0x000000403d00720cULL, 0x000fe20003f86070ULL, 0x000000103a437824ULL, 0x000fe400078e0223ULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078648ffULL,
0x00000001693e7824ULL, 0x000fe200078e023eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c437faeULL, 0x0003e4000d101c46ULL, 0x00005f003b3b7a11ULL, 0x000fc400018f4c3cULL,
0x0000000f4a3d7210ULL, 0x080fe20007f7e0ffULL, 0x000000002e457faeULL, 0x0005e2000e901c46ULL,
0x0000000f3e3f7210ULL, 0x000fe40007f5e0ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x000000404700720cULL, 0x080fe20003f66070ULL,
0x000000ffff427224ULL, 0x000fe200010e06ffULL, 0x000000404b00720cULL, 0x000fe20003fa6070ULL,
0x00000010412c7825ULL, 0x002fe200078e0034ULL, 0x00005f003d3d7a11ULL, 0x000fc400030f4c3eULL,
0x00005e003f3e7a11ULL, 0x000fe200078448ffULL, 0x0000001041347825ULL, 0x000fe200078e0036ULL,
0x000000404900720cULL, 0x080fe40003fc6070ULL, 0x00005f003f3f7a11ULL, 0x000fe200010f4c42ULL,
0x0000001041367825ULL, 0x000fe200078e0038ULL, 0x000000406900720cULL, 0x000fc60003f46070ULL,
0x0000001041387825ULL, 0x000fc800078e003aULL, 0x0000001044437824ULL, 0x000fe400078e0223ULL,
0x00000010413a7825ULL, 0x000fc600078e003cULL, 0x000000002c437faeULL, 0x0003e2000c101c46ULL,
0x00000010412e7825ULL, 0x004fc800078e003eULL, 0x00000010463d7824ULL, 0x100fe400078e0223ULL,
0x00000010483f7824ULL, 0x100fe400078e0223ULL, 0x0000001068417824ULL, 0x100fe200078e0223ULL,
0x00000000343d7faeULL, 0x0003e2000e101c46ULL, 0x000000106a457824ULL, 0x100fe400078e0223ULL,
0x000000106c477824ULL, 0x000fe200078e0223ULL, 0x00000000363f7faeULL, 0x0003e8000d901c46ULL,
0x0000000038417faeULL, 0x0003e8000f101c46ULL, 0x000000003a457faeULL, 0x0003e8000e901c46ULL,
0x000000002e477faeULL, 0x0003e2000d101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x0000000c02347811ULL, 0x040fe400078fe8ffULL, 0x00000004022c7811ULL, 0x000fc400078fe8ffULL,
0x00000008022f7811ULL, 0x000fe200078fe8ffULL, 0x0000000134357824ULL, 0x100fe200078e0202ULL,
0x0000001002367811ULL, 0x000fe200078fe8ffULL, 0x00000008344a7824ULL, 0x000fe200078e00ffULL,
0x00000002023d7211ULL, 0x000fe200078fe8ffULL, 0x000000012c2d7824ULL, 0x140fe400078e0202ULL,
0x000000082c467824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee235ULL,
0x000000012f2e7824ULL, 0x140fe200078e0202ULL, 0x0000001402357811ULL, 0x000fe200078fe8ffULL,
0x000000082f377824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee22dULL,
0x00000001362d7824ULL, 0x040fe200078e0202ULL, 0x000000073d417812ULL, 0x000fe200078ec0ffULL,
0x0000000836687824ULL, 0x000fe200078e00ffULL, 0xfffffff837487812ULL, 0x000fe200078ee22eULL,
0x00000001352e7824ULL, 0x140fe200078e0202ULL, 0x0000001802377811ULL, 0x000fe200078fe8ffULL,
0x0000000835397824ULL, 0x000fe200078e00ffULL, 0xfffffff868687812ULL, 0x000fe200078ee22dULL,
0x0000001046457824ULL, 0x000fe200078e0223ULL, 0x000000200a2d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000137387824ULL, 0x000fe200078e0202ULL, 0xfffffff8396a7812ULL, 0x000fe200078ee22eULL,
0x00000008373b7824ULL, 0x000fe200078e00ffULL, 0x0000001c02397811ULL, 0x000fe200078fe8ffULL,
0x000000012c2e7824ULL, 0x100fe200078e022dULL, 0x0000002d022c7211ULL, 0x000fe200078fe8ffULL,
0x00000001343a7824ULL, 0x100fe200078e022dULL, 0xfffffff83b6c7812ULL, 0x000fe200078ee238ULL,
0x000000012f387824ULL, 0x100fe200078e022dULL, 0x0000000f2e2f7210ULL, 0x000fe20007f5e0ffULL,
0x00000001363c7824ULL, 0x000fc400078e022dULL, 0x0000000135407824ULL, 0x100fe400078e022dULL,
0x0000000137427824ULL, 0x100fe400078e022dULL, 0x0000000139447824ULL, 0x040fe200078e022dULL,
0x0000000f2c2d7210ULL, 0x080fe20007f1e0ffULL, 0x0000000139357824ULL, 0x040fe400078e0202ULL,
0x00000008396e7824ULL, 0x000fe200078e00ffULL, 0x0000000f3c397210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff367224ULL, 0x000fe200000e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078048ffULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078448ffULL,
0x0000001048477824ULL, 0x000fe200078e0223ULL, 0xfffffff86e6e7812ULL, 0x000fe200078ee235ULL,
0x0000001068497824ULL, 0x100fe200078e0223ULL, 0x00005f002d2d7a11ULL, 0x000fe200000f4c36ULL,
0x000000106a4b7824ULL, 0x100fe200078e0223ULL, 0x0000000f38357210ULL, 0x080fe20007f1e0ffULL,
0x000000106c697824ULL, 0x100fe200078e0223ULL, 0x00005f002f2f7a11ULL, 0x000fe200010f4c34ULL,
0x000000106e6b7824ULL, 0x000fe200078e0223ULL, 0x0000000f3a377210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078048ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078648ffULL,
0x000000ffff3c7224ULL, 0x000fe200010e06ffULL, 0x00005e0037367a11ULL, 0x000fc400078448ffULL,
0x00005f0035357a11ULL, 0x000fe400000f4c3eULL, 0x0000000f403b7210ULL, 0x080fe40007f1e0ffULL,
0x00005f0037377a11ULL, 0x000fe400010f4c3cULL, 0x00005f0039397a11ULL, 0x000fe400018f4c3aULL,
0x0000000f423d7210ULL, 0x080fe40007f5e0ffULL, 0x0000000f443f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff447224ULL, 0x000fe200000e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078048ffULL,
0x000000ffff427224ULL, 0x000fe200010e06ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078448ffULL,
0x000000ffff407224ULL, 0x000fe200018e06ffULL, 0x00005e003f3e7a11ULL, 0x000fc400078648ffULL,
0x00005f003b3b7a11ULL, 0x000fe400000f4c44ULL, 0x0ffffff841447812ULL, 0x000fe200078ef802ULL,
0x0000000108417824ULL, 0x000fe200078e0216ULL, 0x00005f003d3d7a11ULL, 0x000fe400010f4c42ULL,
0x00005f003f3f7a11ULL, 0x000fe200018f4c40ULL, 0x0000001044437824ULL, 0x000fe400078e0223ULL,
0x00000010412c7825ULL, 0x000fc800078e002cULL, 0x00000010412e7825ULL, 0x040fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c437faeULL, 0x0003e6000b901c46ULL,
0x0000001041347825ULL, 0x040fe200078e0034ULL, 0x000000002e457faeULL, 0x0003e6000b901c46ULL,
0x0000001041367825ULL, 0x040fe200078e0036ULL, 0x0000000034477faeULL, 0x0003e6000b901c46ULL,
0x0000001041387825ULL, 0x000fc800078e0038ULL, 0x00000010413a7825ULL, 0x000fc800078e003aULL,
0x00000010413c7825ULL, 0x000fc800078e003cULL, 0x00000010413e7825ULL, 0x000fc800078e003eULL,
0x000000104a417824ULL, 0x000fca00078e0223ULL, 0x0000000036417faeULL, 0x0003e8000b901c46ULL,
0x0000000038497faeULL, 0x0003e8000b901c46ULL, 0x000000003a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000003c697faeULL, 0x0003e8000b901c46ULL, 0x000000003e6b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146480008347f8cULL, 0x0022a4000c80043fULL, 0x00000000002c7805ULL, 0x000fc40000015200ULL,
0x01464c00082f7984ULL, 0x000ee40000000800ULL, 0x800000002fff7812ULL, 0x00cfc40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01464c00082f7984ULL, 0x000ea40000000800ULL,
0x800000002fff7812ULL, 0x004fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01410000122f7984ULL, 0x000ea80000000800ULL, 0x0143000012347984ULL, 0x0006620000000800ULL,
0x000000742f00720bULL, 0x004fe20003f1d000ULL, 0x00011f227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000357806ULL, 0x008fc800000e0100ULL, 0x0000ffff35ff7812ULL, 0x000fe2000784c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x000004200000a947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f05270ULL,
0x000000742f00720bULL, 0x000fe20003f54000ULL, 0x00011ef27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000367806ULL, 0x000fc400010e0100ULL, 0x0000002f742d8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910362c7816ULL, 0x000fc600000000ffULL,
0x0145002d12008388ULL, 0x0005e20000000800ULL, 0x000000ff2c00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000002f742d7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff36ff7812ULL, 0x000fc6000780c0ffULL,
0x8000002d742c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c006b7308ULL, 0x000ea40000000800ULL, 0x0000006b0b0b7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe20000011602ULL,
0x00011e327f007947ULL, 0x000fea000b800000ULL, 0x00001f2e6b2e7589ULL, 0x0004e400000e0000ULL,
0x0000002e50507220ULL, 0x08cfe20000410000ULL, 0x0000002e51517220ULL, 0x080fe20000410000ULL,
0x0000002e54547220ULL, 0x080fe20000410000ULL, 0x0000002e55557220ULL, 0x080fe20000410000ULL,
0x0000002e58587220ULL, 0x080fe20000410000ULL, 0x0000002e59597220ULL, 0x080fe20000410000ULL,
0x0000002e5c5c7220ULL, 0x080fe20000410000ULL, 0x0000002e5d5d7220ULL, 0x080fe20000410000ULL,
0x0000002e64647220ULL, 0x080fe20000410000ULL, 0x0000002e65657220ULL, 0x080fe20000410000ULL,
0x0000002e60607220ULL, 0x080fe20000410000ULL, 0x0000002e61617220ULL, 0x080fe20000410000ULL,
0x0000002e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000002e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000002e30307220ULL, 0x080fe20000410000ULL, 0x0000002e31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0036ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008022e7811ULL, 0x000fe200078ff0ffULL,
0x00011d027f007947ULL, 0x000fea000b800000ULL, 0x00001f2e6b2e7589ULL, 0x0004e400000e0000ULL,
0x0000002e52527220ULL, 0x08cfe20000410000ULL, 0x0000002e53537220ULL, 0x080fe20000410000ULL,
0x0000002e56567220ULL, 0x080fe20000410000ULL, 0x0000002e57577220ULL, 0x080fe20000410000ULL,
0x0000002e5a5a7220ULL, 0x080fe20000410000ULL, 0x0000002e5b5b7220ULL, 0x080fe20000410000ULL,
0x0000002e5e5e7220ULL, 0x080fe20000410000ULL, 0x0000002e5f5f7220ULL, 0x080fe20000410000ULL,
0x0000002e66667220ULL, 0x080fe20000410000ULL, 0x0000002e67677220ULL, 0x080fe20000410000ULL,
0x0000002e62627220ULL, 0x080fe20000410000ULL, 0x0000002e63637220ULL, 0x080fe20000410000ULL,
0x0000002e4e4e7220ULL, 0x080fe20000410000ULL, 0x0000002e4f4f7220ULL, 0x080fe20000410000ULL,
0x0000002e32327220ULL, 0x080fe20000410000ULL, 0x0000002e33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe40007800835ULL,
0x0000002f74747209ULL, 0x000fd60007810000ULL, 0x800000742f2f0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b2f2f0820ULL, 0x000fc80000410000ULL, 0x0000002f00130308ULL, 0x000ea40000000800ULL,
0x0000001334340220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000000b340b7221ULL, 0x002fe20000010000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000013ff14723eULL, 0x000fe400000000ffULL, 0x00000002ff347819ULL, 0x000fe40000011602ULL,
0x00005410146b7816ULL, 0x000fe20000000014ULL, 0x00011b227f007947ULL, 0x000fea000b800000ULL,
0x00001f346b147589ULL, 0x0002a400000e0000ULL, 0x00000008342e7810ULL, 0x000fe20007ffe0ffULL,
0x00011b427f007947ULL, 0x000fea000b800000ULL, 0x00001f2e6b157589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x00000010342e7810ULL, 0x008fe40007ffe0ffULL,
0x000086c0002c7802ULL, 0x000fc40000000f00ULL, 0x0001229000007944ULL, 0x006fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x00000018342e7810ULL, 0x00cfe40007ffe0ffULL,
0x00008700002c7802ULL, 0x000fc40000000f00ULL, 0x0001225000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b00017447811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001970783bULL, 0x000fe20000004200ULL,
0x0000b0001d2c7811ULL, 0x000fc600078e20ffULL, 0x000000004444783bULL, 0x000f280000000200ULL,
0x000000001b68783bULL, 0x00afe80000004200ULL, 0x000000001a6c783bULL, 0x000fe80000004200ULL,
0x000000001c48783bULL, 0x000fe80000004200ULL, 0x000000002c2c783bULL, 0x004e680000000200ULL,
0x000000001e40783bULL, 0x000ea80000004200ULL, 0x000000002038783bULL, 0x000ee80000004200ULL,
0x000000001f3c783bULL, 0x000ea80000004200ULL, 0x000000002134783bULL, 0x000ea20000004200ULL,
0x0000001444440232ULL, 0x010fc40000000000ULL, 0x0000001446460232ULL, 0x000fe40000000000ULL,
0x0000001545450232ULL, 0x080fe40000000000ULL, 0x0000001547470232ULL, 0x000fce0000000000ULL,
0x000000704450723cULL, 0x000f620000001850ULL, 0x000000142c2c0232ULL, 0x082fe40000000000ULL,
0x000000142e2e0232ULL, 0x000fe40000000000ULL, 0x000000152d2d0232ULL, 0x000fc60000000000ULL,
0x000000724454723cULL, 0x000f620000001854ULL, 0x000000152f2f0232ULL, 0x000fce0000000000ULL,
0x000000684464723cULL, 0x040f700000001864ULL, 0x0000006c4458723cULL, 0x040f700000001858ULL,
0x0000006e445c723cULL, 0x040f70000000185cULL, 0x0000006a4460723cULL, 0x040f700000001860ULL,
0x00000048444c723cULL, 0x040f70000000184cULL, 0x0000004a4430723cULL, 0x000f700000001830ULL,
0x000000402c50723cULL, 0x064b700000001850ULL, 0x000000422c54723cULL, 0x040b700000001854ULL,
0x000000382c64723cULL, 0x048b700000001864ULL, 0x0000003c2c58723cULL, 0x040b700000001858ULL,
0x0000003e2c5c723cULL, 0x040b70000000185cULL, 0x0000003a2c38723cULL, 0x040b700000001860ULL,
0x000000342c4c723cULL, 0x040b70000000184cULL, 0x000000362c40723cULL, 0x000b620000001830ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000072000009947ULL, 0x000fca0003800000ULL,
0x00000003ff377819ULL, 0x020fe20000011602ULL, 0x0000000108457824ULL, 0x000fe200078e0216ULL,
0x000000c0032d7811ULL, 0x000fe400078e40ffULL, 0x0000000437337810ULL, 0x040fe40007ffe0ffULL,
0x0000000837357810ULL, 0x000fe40007ffe0ffULL, 0x0000002d042c7217ULL, 0x000fe20007800000ULL,
0x00000001332f7824ULL, 0x100fe200078e0202ULL, 0x0000000c373d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000833327824ULL, 0x000fe200078e00ffULL, 0x00000014376b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000135307824ULL, 0x100fe200078e0202ULL, 0x0000001037637810ULL, 0x000fe20007ffe0ffULL,
0x00000008354b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8323f7812ULL, 0x000fe200078ee22fULL,
0x000000012c2e7824ULL, 0x000fe200078e0a2dULL, 0x000000400a3e7810ULL, 0x000fe20007ffe0ffULL,
0x000000013d2c7824ULL, 0x000fe200078e0202ULL, 0x00000018376f7810ULL, 0x000fe20007ffe0ffULL,
0x000000083d617824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee230ULL,
0x000000016b2f7824ULL, 0x000fe200078e0202ULL, 0x0000001c37737810ULL, 0x000fe20007ffe0ffULL,
0x000000086b327824ULL, 0x000fe200078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee22cULL,
0x00000001632d7824ULL, 0x040fe200078e0202ULL, 0x000000202e447817ULL, 0x000fe20003800000ULL,
0x0000000863307824ULL, 0x000fe200078e00ffULL, 0xfffffff8326d7812ULL, 0x000fe200078ee22fULL,
0x00000001372c7824ULL, 0x000fe200078e023eULL, 0x000000443500720cULL, 0x000fe20003fa6070ULL,
0x000000016f2f7824ULL, 0x040fe200078e0202ULL, 0xfffffff830697812ULL, 0x000fe200078ee22dULL,
0x000000086f347824ULL, 0x000fe200078e00ffULL, 0x0000000f2c2d7210ULL, 0x000fe20007f5e0ffULL,
0x0000000133327824ULL, 0x000fc400078e023eULL, 0x0000000173317824ULL, 0x040fe200078e0202ULL,
0xfffffff834717812ULL, 0x000fe200078ee22fULL, 0x0000000873367824ULL, 0x000fe200078e00ffULL,
0x0000000f322f7210ULL, 0x080fe20007f7e0ffULL, 0x0000000135327824ULL, 0x100fe400078e023eULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078448ffULL,
0x000000013d347824ULL, 0x100fe200078e023eULL, 0xfffffff836777812ULL, 0x000fe200078ee231ULL,
0x0000000163367824ULL, 0x100fe200078e023eULL, 0x0000000f32317210ULL, 0x080fe20007f9e0ffULL,
0x000000016b3c7824ULL, 0x000fe200078e023eULL, 0x00005f002d2d7a11ULL, 0x000fe200010f4c30ULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x000000443300720cULL, 0x000fe20003f66070ULL,
0x000000ffff327224ULL, 0x000fe200020e06ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078448ffULL,
0x00000010452c7825ULL, 0x000fe200078e002cULL, 0x0000000f34337210ULL, 0x000fc40007f9e0ffULL,
0x00005f002f2f7a11ULL, 0x000fe200010f4c30ULL, 0x000000016f467824ULL, 0x000fe200078e023eULL,
0x00005e0031307a11ULL, 0x000fe200078448ffULL, 0x000000ffff347224ULL, 0x000fe200020e06ffULL,
0x000000443700720cULL, 0x040fe20003f86070ULL, 0x0000000137377824ULL, 0x000fe200078e0202ULL,
0x00005f0031317a11ULL, 0x000fe200010f4c32ULL, 0x000000103f497824ULL, 0x000fe200078e0218ULL,
0x00005e0033327a11ULL, 0x000fe200078448ffULL, 0x00000010452e7825ULL, 0x000fe200078e002eULL,
0x0000000f36357210ULL, 0x000fc40007fde0ffULL, 0x0000000737377812ULL, 0x000fe200078ec0ffULL,
0x00000001733e7824ULL, 0x000fe200078e023eULL, 0x00005f0033337a11ULL, 0x000fe200010f4c34ULL,
0x000000ffff367224ULL, 0x000fe200030e06ffULL, 0x000000443d00720cULL, 0x000fe20003f46070ULL,
0x000000104b4b7824ULL, 0x000fe200078e0218ULL, 0x0ffffff8373d7812ULL, 0x000fe200078ef802ULL,
0x0000001045307825ULL, 0x000fe200078e0030ULL, 0x00005e0035347a11ULL, 0x000fc600078c48ffULL,
0x000000103d477824ULL, 0x000fe200078e0218ULL, 0x00005f0035357a11ULL, 0x000fe200030f4c36ULL,
0x0000001061617824ULL, 0x100fe200078e0218ULL, 0x0000000f3c377210ULL, 0x080fe20007fde0ffULL,
0x0000001069697824ULL, 0x100fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c477faeULL, 0x0003e2000e101c46ULL, 0x0000000f463d7210ULL, 0x080fe20007f9e0ffULL,
0x000000106d6d7824ULL, 0x000fe400078e0218ULL, 0x000000ffff3c7224ULL, 0x000fe200030e06ffULL,
0x00005e0037367a11ULL, 0x040fe200078c48ffULL, 0x000000002e497faeULL, 0x0005e2000d901c46ULL,
0x0000000f3e3f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005f0037377a11ULL, 0x000fe200030f4c3cULL, 0x00000000304b7faeULL, 0x0007e2000e901c46ULL,
0x00005e003d3c7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff467224ULL, 0x000fe200018e06ffULL,
0x000000446300720cULL, 0x000fe20003f86070ULL, 0x00000010452c7825ULL, 0x002fe200078e0032ULL,
0x00005f003d3d7a11ULL, 0x000fc400030f4c3eULL, 0x00005e003f3e7a11ULL, 0x000fe200078648ffULL,
0x00000010452e7825ULL, 0x004fe200078e0034ULL, 0x000000446b00720cULL, 0x080fe20003fc6070ULL,
0x000000002c617faeULL, 0x0007e2000d101c46ULL, 0x000000446f00720cULL, 0x080fe20003fa6070ULL,
0x0000001045327825ULL, 0x000fe200078e0036ULL, 0x00005f003f3f7a11ULL, 0x000fe400018f4c46ULL,
0x000000447300720cULL, 0x000fe20003f66070ULL, 0x0000001045347825ULL, 0x000fe200078e003cULL,
0x000000002e697faeULL, 0x0007e6000e101c46ULL, 0x0000001071717824ULL, 0x000fc400078e0218ULL,
0x0000001045367825ULL, 0x000fe200078e003eULL, 0x00000000326d7faeULL, 0x0007e6000f101c46ULL,
0x0000001077777824ULL, 0x000fe200078e0218ULL, 0x0000000034717faeULL, 0x0007e8000e901c46ULL,
0x0000000036777faeULL, 0x0007e2000d901c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000004022c7811ULL, 0x060fe400078fe8ffULL, 0x0000000c02307811ULL, 0x000fc400078fe8ffULL,
0x00000008022f7811ULL, 0x000fe200078fe8ffULL, 0x000000012c2d7824ULL, 0x100fe200078e0202ULL,
0x0000001802337811ULL, 0x000fe200078fe8ffULL, 0x000000082c327824ULL, 0x000fe200078e00ffULL,
0x0000001c02357811ULL, 0x000fe200078fe8ffULL, 0x0000000130317824ULL, 0x100fe200078e0202ULL,
0x00000002023d7211ULL, 0x000fe200078fe8ffULL, 0x0000000830347824ULL, 0x000fe200078e00ffULL,
0xfffffff832497812ULL, 0x000fe200078ee22dULL, 0x000000012f2e7824ULL, 0x140fe200078e0202ULL,
0x0000001002327811ULL, 0x000fe200078fe8ffULL, 0x000000082f4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff834617812ULL, 0x000fe200078ee231ULL, 0x0000000133347824ULL, 0x100fe200078e0202ULL,
0x0000001402317811ULL, 0x000fe200078fe8ffULL, 0x00000001322d7824ULL, 0x040fe200078e0202ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee22eULL, 0x0000000832367824ULL, 0x000fe200078e00ffULL,
0x000000073d457812ULL, 0x000fe200078ec0ffULL, 0x00000001312e7824ULL, 0x000fc400078e0202ULL,
0x0000000831697824ULL, 0x000fe200078e00ffULL, 0xfffffff836637812ULL, 0x000fe200078ee22dULL,
0x00000008336b7824ULL, 0x000fe200078e00ffULL, 0x000000400a2d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008353e7824ULL, 0x000fe200078e00ffULL, 0xfffffff869697812ULL, 0x000fe200078ee22eULL,
0x0000001049497824ULL, 0x000fe200078e0218ULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee234ULL,
0x000000012c2e7824ULL, 0x100fe200078e022dULL, 0x0000002d022c7211ULL, 0x000fe200078fe8ffULL,
0x000000012f347824ULL, 0x100fe200078e022dULL, 0x0ffffff845477812ULL, 0x000fe200078ef802ULL,
0x0000000130367824ULL, 0x100fe200078e022dULL, 0x0000000f2e2f7210ULL, 0x000fe20007f7e0ffULL,
0x00000001323c7824ULL, 0x000fc400078e022dULL, 0x0000000131447824ULL, 0x100fe400078e022dULL,
0x0000000133467824ULL, 0x100fe400078e022dULL, 0x0000000135487824ULL, 0x040fe200078e022dULL,
0x0000000f2c2d7210ULL, 0x080fe20007f5e0ffULL, 0x0000000135317824ULL, 0x000fe200078e0202ULL,
0x0000000f3c357210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005e002f2e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078448ffULL, 0x0000000108457824ULL, 0x000fe200078e0216ULL,
0xfffffff83e6d7812ULL, 0x000fe200078ee231ULL, 0x0000001047477824ULL, 0x000fe200078e0218ULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4c32ULL, 0x000000104b4b7824ULL, 0x100fe200078e0218ULL,
0x0000000f34317210ULL, 0x080fe20007f5e0ffULL, 0x0000001061617824ULL, 0x000fe200078e0218ULL,
0x00005f002f2f7a11ULL, 0x000fe200018f4c30ULL, 0x00000010452c7825ULL, 0x000fe200078e002cULL,
0x0000000f36337210ULL, 0x000fc60007f7e0ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078448ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x00005e0033327a11ULL, 0x000fe200078648ffULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078848ffULL, 0x00000010452e7825ULL, 0x000fe200078e002eULL,
0x00005f0031317a11ULL, 0x000fe200010f4c3eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c477faeULL, 0x0003e2000b901c46ULL, 0x00005f0033337a11ULL, 0x000fe200018f4c3cULL,
0x0000001063637824ULL, 0x000fe200078e0218ULL, 0x0000000f44377210ULL, 0x080fe20007f5e0ffULL,
0x0000001045307825ULL, 0x000fe200078e0030ULL, 0x00005f0035357a11ULL, 0x000fe200020f4c36ULL,
0x000000002e497faeULL, 0x0003e2000b901c46ULL, 0x0000000f463d7210ULL, 0x080fe20007f7e0ffULL,
0x0000001045327825ULL, 0x000fe200078e0032ULL, 0x0000000f483f7210ULL, 0x000fe20007f9e0ffULL,
0x00000000304b7faeULL, 0x0003e4000b901c46ULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078448ffULL, 0x000000ffff467224ULL, 0x000fe200018e06ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078648ffULL, 0x000000ffff447224ULL, 0x000fe200020e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078848ffULL, 0x0000001045347825ULL, 0x000fe200078e0034ULL,
0x00005f0037377a11ULL, 0x000fe200010f4c48ULL, 0x0000000032617faeULL, 0x0003e2000b901c46ULL,
0x00005f003d3d7a11ULL, 0x000fe200018f4c46ULL, 0x0000001069697824ULL, 0x000fe200078e0218ULL,
0x00005f003f3f7a11ULL, 0x000fe200020f4c44ULL, 0x0000001045367825ULL, 0x040fe200078e0036ULL,
0x0000000034637faeULL, 0x0003e6000b901c46ULL, 0x00000010453c7825ULL, 0x000fe200078e003cULL,
0x0000000036697faeULL, 0x0003e6000b901c46ULL, 0x000000106b6b7824ULL, 0x000fc400078e0218ULL,
0x00000010453e7825ULL, 0x000fc600078e003eULL, 0x000000003c6b7faeULL, 0x0003e2000b901c46ULL,
0x000000106d6d7824ULL, 0x000fca00078e0218ULL, 0x000000003e6d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000013ff14723eULL, 0x000fe400000000ffULL, 0x00000002ff307819ULL, 0x00afe40000011602ULL,
0x00005410146b7816ULL, 0x000fe20000000014ULL, 0x00010a927f007947ULL, 0x000fea000b800000ULL,
0x00001f306b147589ULL, 0x0002a400000e0000ULL, 0x00000008302e7810ULL, 0x000fe20007ffe0ffULL,
0x00010ab27f007947ULL, 0x000fea000b800000ULL, 0x00001f2e6b157589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x00000010302e7810ULL, 0x008fe40007ffe0ffULL,
0x000097e0002c7802ULL, 0x000fc40000000f00ULL, 0x0001117000007944ULL, 0x006fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x00000018302e7810ULL, 0x00cfe40007ffe0ffULL,
0x00009820002c7802ULL, 0x000fc40000000f00ULL, 0x0001113000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b00022447811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002568783bULL, 0x00afe20000004200ULL,
0x0000b00028307811ULL, 0x000fc600078e20ffULL, 0x000000004444783bULL, 0x000e680000000200ULL,
0x000000002770783bULL, 0x000fe80000004200ULL, 0x00000000246c783bULL, 0x000fe80000004200ULL,
0x000000002648783bULL, 0x000fe80000004200ULL, 0x000000003030783bULL, 0x000ee80000000200ULL,
0x000000002a60783bULL, 0x000f280000004200ULL, 0x000000000d3c783bULL, 0x000ea80000004200ULL,
0x000000002934783bULL, 0x000ea80000004200ULL, 0x000000000c2c783bULL, 0x004ea20000004200ULL,
0x0000001444440232ULL, 0x002fc40000000000ULL, 0x0000001446460232ULL, 0x000fe40000000000ULL,
0x0000001545450232ULL, 0x080fe40000000000ULL, 0x0000001547470232ULL, 0x000fce0000000000ULL,
0x000000684464723cULL, 0x000f620000001864ULL, 0x0000001430300232ULL, 0x088fe40000000000ULL,
0x0000001432320232ULL, 0x000fe40000000000ULL, 0x0000001531310232ULL, 0x000fc60000000000ULL,
0x000000704450723cULL, 0x000f620000001850ULL, 0x0000001533330232ULL, 0x000fce0000000000ULL,
0x000000724454723cULL, 0x040f700000001854ULL, 0x0000006c4458723cULL, 0x040f700000001858ULL,
0x0000006e445c723cULL, 0x040f70000000185cULL, 0x0000006a4438723cULL, 0x040f700000001838ULL,
0x00000048444c723cULL, 0x040f70000000184cULL, 0x0000004a4440723cULL, 0x000f700000001840ULL,
0x000000603064723cULL, 0x070b700000001864ULL, 0x0000003c3050723cULL, 0x040b700000001850ULL,
0x0000003e3054723cULL, 0x040b700000001854ULL, 0x000000343058723cULL, 0x040b700000001858ULL,
0x00000036305c723cULL, 0x040b70000000185cULL, 0x000000623060723cULL, 0x040b700000001838ULL,
0x0000002c304c723cULL, 0x044b70000000184cULL, 0x0000002e3030723cULL, 0x000b620000001840ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000c0032d7811ULL, 0x020fe200078e40ffULL,
0x01469800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000042d00720cULL, 0x000fda0003f06070ULL,
0x00002b2000000947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff3a7819ULL, 0x000fe20000011602ULL,
0x0000000108417824ULL, 0x000fe200078e0216ULL, 0x000000e003077811ULL, 0x000fe400078e40ffULL,
0x000000043a3c7810ULL, 0x000fe40007ffe0ffULL, 0x00000007042c7217ULL, 0x000fe40007800000ULL,
0x000000600a2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000013c097824ULL, 0x100fe200078e0202ULL,
0x000000083a3e7810ULL, 0x000fe20007ffe0ffULL, 0x000000083c447824ULL, 0x000fe200078e00ffULL,
0x0000000c3a407810ULL, 0x000fe20007ffe0ffULL, 0x000000012c077824ULL, 0x000fe200078e0a07ULL,
0x000000103a427810ULL, 0x040fe20007ffe0ffULL, 0x000000013a2c7824ULL, 0x000fe200078e022fULL,
0xfffffff844447812ULL, 0x000fe200078ee209ULL, 0x000000013e2d7824ULL, 0x100fe200078e0202ULL,
0x000000143a687810ULL, 0x000fe20007ffe0ffULL, 0x000000083e467824ULL, 0x000fe200078e00ffULL,
0x0000000f2c097210ULL, 0x080fe20007f1e0ffULL, 0x0000000840487824ULL, 0x000fe200078e00ffULL,
0x000000183a6e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000142347824ULL, 0x100fe200078e0202ULL,
0xfffffff846467812ULL, 0x000fe200078ee22dULL, 0x00000001402d7824ULL, 0x000fe200078e0202ULL,
0x0000001c3a727810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2e7224ULL, 0x000fe200000e06ffULL,
0x00005e00092c7a11ULL, 0x040fe200078048ffULL, 0x0000000842377824ULL, 0x000fe200078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee22dULL, 0x0000000142387824ULL, 0x100fe200078e022fULL,
0x00005f00092d7a11ULL, 0x000fe200000f4c2eULL, 0x000000013c2e7824ULL, 0x100fe200078e022fULL,
0xfffffff8374a7812ULL, 0x000fe200078ee234ULL, 0x0000000168357824ULL, 0x000fe200078e0202ULL,
0x0000000f38397210ULL, 0x000fe20007f3e0ffULL, 0x00000008686c7824ULL, 0x000fe200078e00ffULL,
0x0000002007077817ULL, 0x000fe20003800000ULL, 0x000000013e347824ULL, 0x000fc400078e022fULL,
0x0000000140367824ULL, 0x000fe200078e022fULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee235ULL,
0x00000001686a7824ULL, 0x100fe200078e022fULL, 0x0000000f34357210ULL, 0x080fe20007f1e0ffULL,
0x000000016e707824ULL, 0x100fe200078e022fULL, 0x0000000f36377210ULL, 0x080fe20007f5e0ffULL,
0x0000000172787824ULL, 0x000fe200078e022fULL, 0x0000000f2e2f7210ULL, 0x080fe20007f7e0ffULL,
0x000000016e387824ULL, 0x100fe200078e0202ULL, 0x0000000f70097210ULL, 0x080fe20007fbe0ffULL,
0x000000086e3f7824ULL, 0x000fe200078e00ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff347224ULL, 0x000fe200018e06ffULL, 0x0000000f6a3b7210ULL, 0x080fe20007f7e0ffULL,
0x00000001723d7824ULL, 0x040fe200078e0202ULL, 0xfffffff83f6a7812ULL, 0x000fe200078ee238ULL,
0x0000000872707824ULL, 0x000fe200078e00ffULL, 0x00005f002f2f7a11ULL, 0x000fe200030f4c34ULL,
0x000000013a387824ULL, 0x000fe200078e0202ULL, 0x0000000f780f7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff367224ULL, 0x000fe200000e06ffULL, 0xfffffff870707812ULL, 0x000fe200078ee23dULL,
0x00000010412c7825ULL, 0x000fe200078e002cULL, 0x00000007383d7812ULL, 0x000fc400078ec0ffULL,
0x00005e0035347a11ULL, 0x000fe200078048ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x000000073a00720cULL, 0x080fe20003f46070ULL, 0x000000106c457824ULL, 0x100fe200078e0223ULL,
0x0ffffff83d3a7812ULL, 0x000fe200078ef802ULL, 0x000000106a477824ULL, 0x100fe200078e0223ULL,
0x00005f0035357a11ULL, 0x000fe400000f4c36ULL, 0x00005e0037367a11ULL, 0x040fe200078c48ffULL,
0x000000103a437824ULL, 0x000fe200078e0223ULL, 0x000000073c00720cULL, 0x080fe20003f06070ULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x00005f0037377a11ULL, 0x000fe200030f4c38ULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x00005e0039387a11ULL, 0x040fe200078c48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c437faeULL, 0x0003e2000d101c46ULL,
0x000000074200720cULL, 0x000fe20003f46070ULL, 0x000000ffff427224ULL, 0x000fe200028e06ffULL,
0x00005f0039397a11ULL, 0x000fc400030f4c3aULL, 0x00005e003b3a7a11ULL, 0x040fe400078c48ffULL,
0x000000074000720cULL, 0x080fe20003f66070ULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe400030f4c3cULL, 0x000000073e00720cULL, 0x080fe20003f26070ULL,
0x00000010412c7825ULL, 0x002fe200078e002eULL, 0x00005e00093c7a11ULL, 0x000fe400078a48ffULL,
0x00005e000f3e7a11ULL, 0x000fe200078c48ffULL, 0x00000010412e7825ULL, 0x000fe200078e0034ULL,
0x000000076800720cULL, 0x000fc40003f86070ULL, 0x00005f00093d7a11ULL, 0x000fe200028f4c42ULL,
0x0000001046097824ULL, 0x000fe200078e0223ULL, 0x000000076e00720cULL, 0x080fe20003fa6070ULL,
0x0000001041347825ULL, 0x000fe200078e0036ULL, 0x00005f000f3f7a11ULL, 0x000fe400030f4c40ULL,
0x000000077200720cULL, 0x000fe20003fc6070ULL, 0x0000001044077824ULL, 0x100fe400078e0223ULL,
0x00000010480f7824ULL, 0x100fe400078e0223ULL, 0x000000104a437824ULL, 0x000fe200078e0223ULL,
0x000000002c077faeULL, 0x0003e2000c101c46ULL, 0x0000001041367825ULL, 0x000fc600078e0038ULL,
0x000000002e097faeULL, 0x0003e2000c901c46ULL, 0x0000001041387825ULL, 0x000fc600078e003aULL,
0x00000000340f7faeULL, 0x0003e2000d901c46ULL, 0x00000010413a7825ULL, 0x000fc600078e003cULL,
0x0000000036437faeULL, 0x0003e2000d101c46ULL, 0x0000001070237824ULL, 0x000fe400078e0223ULL,
0x00000010413c7825ULL, 0x000fe200078e003eULL, 0x0000000038457faeULL, 0x0003e8000e101c46ULL,
0x000000003a477faeULL, 0x0003e8000e901c46ULL, 0x000000003c237faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x0000000802357811ULL, 0x040fe400078fe8ffULL,
0x0000000402347811ULL, 0x000fc400078fe8ffULL, 0x0000000c02367811ULL, 0x040fe200078fe8ffULL,
0x0000000135097824ULL, 0x140fe200078e0202ULL, 0x0000001002377811ULL, 0x040fe200078fe8ffULL,
0x00000008353a7824ULL, 0x000fe200078e00ffULL, 0x0000001402397811ULL, 0x000fe200078fe8ffULL,
0x0000000134077824ULL, 0x100fe200078e0202ULL, 0x00000018023b7811ULL, 0x000fe200078fe8ffULL,
0x0000000834387824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee209ULL,
0x00000008363e7824ULL, 0x000fe200078e00ffULL, 0x000000600a097810ULL, 0x000fe20007ffe0ffULL,
0x00000001372d7824ULL, 0x140fe200078e0202ULL, 0xfffffff838387812ULL, 0x000fe200078ee207ULL,
0x0000000136077824ULL, 0x100fe200078e0202ULL, 0x00000009022c7211ULL, 0x040fe200078fe8ffULL,
0x0000000837427824ULL, 0x000fe200078e00ffULL, 0x00000002022f7211ULL, 0x000fe200078fe8ffULL,
0x0000000839467824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL,
0x000000013b3c7824ULL, 0x140fe200078e0202ULL, 0x0000000f2c077210ULL, 0x080fe20007f1e0ffULL,
0x000000083b3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee22dULL,
0x00000001392d7824ULL, 0x000fe200078e0202ULL, 0x000000072f2f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2e7224ULL, 0x000fe200000e06ffULL, 0x00005e00072c7a11ULL, 0x000fe200078048ffULL,
0x0000000134347824ULL, 0x000fe200078e0209ULL, 0xfffffff846467812ULL, 0x000fe200078ee22dULL,
0x000000013b487824ULL, 0x100fe200078e0209ULL, 0x00005f00072d7a11ULL, 0x000fe200000f4c2eULL,
0x00000001352e7824ULL, 0x100fe200078e0209ULL, 0x0000001c02077811ULL, 0x000fe200078fe8ffULL,
0x0000000137407824ULL, 0x100fe200078e0209ULL, 0xfffffff83d4a7812ULL, 0x000fe200078ee23cULL,
0x00000001363c7824ULL, 0x100fe200078e0209ULL, 0x0ffffff82f367812ULL, 0x100fe200078ef802ULL,
0x00000001073b7824ULL, 0x040fe200078e0202ULL, 0x0000000f342f7210ULL, 0x080fe20007f9e0ffULL,
0x00000008076a7824ULL, 0x000fe200078e00ffULL, 0x0000000f2e357210ULL, 0x080fe20007f3e0ffULL,
0x0000000139447824ULL, 0x100fe200078e0209ULL, 0x0000000f3c377210ULL, 0x080fe20007f7e0ffULL,
0x0000000107687824ULL, 0x000fe200078e0209ULL, 0x0000000f40397210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff347224ULL, 0x000fe200020e06ffULL, 0x00005e002f2e7a11ULL, 0x040fe200078c48ffULL,
0x0000001038437824ULL, 0x100fe200078e0223ULL, 0x0000000f48077210ULL, 0x080fe20007fbe0ffULL,
0x000000103a457824ULL, 0x000fe200078e0223ULL, 0xfffffff86a3c7812ULL, 0x000fe200078ee23bULL,
0x0000001036417824ULL, 0x100fe200078e0223ULL, 0x00005f002f2f7a11ULL, 0x000fe200030f4c34ULL,
0x000000103e477824ULL, 0x100fe200078e0223ULL, 0x0000000f44097210ULL, 0x080fe20007f1e0ffULL,
0x0000001042497824ULL, 0x100fe200078e0223ULL, 0x0000000f680f7210ULL, 0x000fe20007f9e0ffULL,
0x00000010464b7824ULL, 0x000fc400078e0223ULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078248ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078648ffULL, 0x000000104a697824ULL, 0x100fe200078e0223ULL,
0x00005f0035357a11ULL, 0x000fe200008f4c3aULL, 0x000000103c237824ULL, 0x000fe200078e0223ULL,
0x00005f0037377a11ULL, 0x000fe200018f4c38ULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0x00005e00073c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff427224ULL, 0x000fe200028e06ffULL,
0x00005e0039387a11ULL, 0x000fe200078248ffULL, 0x000000ffff447224ULL, 0x000fe200000e06ffULL,
0x00005e00093a7a11ULL, 0x000fe200078048ffULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x00005f00073d7a11ULL, 0x000fe200010f4c42ULL, 0x0000000108077824ULL, 0x000fe200078e0216ULL,
0x00005e000f3e7a11ULL, 0x000fc400078648ffULL, 0x00005f0039397a11ULL, 0x000fe200008f4c46ULL,
0x00000010072c7825ULL, 0x000fe200078e002cULL, 0x00005f00093b7a11ULL, 0x000fe400000f4c44ULL,
0x00005f000f3f7a11ULL, 0x000fe200018f4c40ULL, 0x00000010072e7825ULL, 0x040fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c417faeULL, 0x0003e6000b901c46ULL,
0x0000001007347825ULL, 0x040fe200078e0034ULL, 0x000000002e437faeULL, 0x0003e6000b901c46ULL,
0x0000001007367825ULL, 0x040fe200078e0036ULL, 0x0000000034457faeULL, 0x0003e6000b901c46ULL,
0x0000001007387825ULL, 0x040fe200078e0038ULL, 0x0000000036477faeULL, 0x0003e6000b901c46ULL,
0x00000010073a7825ULL, 0x040fe200078e003aULL, 0x0000000038497faeULL, 0x0003e6000b901c46ULL,
0x00000010073c7825ULL, 0x040fe200078e003cULL, 0x000000003a4b7faeULL, 0x0003e6000b901c46ULL,
0x00000010073e7825ULL, 0x000fe200078e003eULL, 0x000000003c697faeULL, 0x0003e8000b901c46ULL,
0x000000003e237faeULL, 0x0003e4000b901c46ULL, 0x00000001110e7824ULL, 0x000fe400078e020eULL,
0x00000300ff077624ULL, 0x002fc600078e00ffULL, 0x000000010e097812ULL, 0x000fe400078ec0ffULL,
0xffffffff07077811ULL, 0x000fe400078e08ffULL, 0x000000010900780cULL, 0x000fe20003f05070ULL,
0xffffffffff097424ULL, 0x000fc600078e00ffULL, 0x0000000107077807ULL, 0x000fca0004000000ULL,
0x000000010e077824ULL, 0x000fca00078e0207ULL, 0x000000050700720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe400078e0210ULL,
0x00000004ff0f7424ULL, 0x000fc800078e00ffULL, 0x000060000e0e7625ULL, 0x000fca00078e000fULL,
0x000000060e097981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01466800082e7f8cULL, 0x0004e4000c80043fULL,
0x00000000000e7805ULL, 0x002fc40000015200ULL, 0x01466c0008117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x00afe4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c0e2c7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e0fULL,
0x003d09002c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc8000001142dULL, 0x0000002c11117211ULL, 0x000fca00078110ffULL,
0x000000ffff2c7224ULL, 0x000fca00000e062dULL, 0x0000000211117819ULL, 0x000fc8000000122cULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000123237810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01466c0008117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01418000120f7984ULL, 0x000e680000000800ULL,
0x01438000120e7984ULL, 0x0006a20000000800ULL, 0x000000740f00720bULL, 0x002fe20003f1d000ULL,
0x0000f6327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000117806ULL, 0x008fc800000e0100ULL,
0x0000ffff11ff7812ULL, 0x000fe2000782c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f05270ULL, 0x000000740f00720bULL, 0x000fe20003f34000ULL,
0x0000f6027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000347806ULL, 0x000fc400008e0100ULL,
0x000000740f238209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910342b7816ULL, 0x000fc600000000ffULL, 0x0145802312008388ULL, 0x0003e20000000800ULL,
0x000000ff2b00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000740f237209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff34ff7812ULL, 0x000fc6000780c0ffULL, 0x0000007423127221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL, 0x00000012006b7308ULL, 0x000e640000000800ULL,
0x0000006b0b0b7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe20000011602ULL, 0x0000f5427f007947ULL, 0x000fea000b800000ULL,
0x00001f2e6b2e7589ULL, 0x0002e400000e0000ULL, 0x0000002e50507220ULL, 0x08cfe20000410000ULL,
0x0000002e51517220ULL, 0x080fe20000410000ULL, 0x0000002e54547220ULL, 0x080fe20000410000ULL,
0x0000002e55557220ULL, 0x080fe20000410000ULL, 0x0000002e58587220ULL, 0x080fe20000410000ULL,
0x0000002e59597220ULL, 0x080fe20000410000ULL, 0x0000002e5c5c7220ULL, 0x080fe20000410000ULL,
0x0000002e5d5d7220ULL, 0x080fe20000410000ULL, 0x0000002e64647220ULL, 0x080fe20000410000ULL,
0x0000002e65657220ULL, 0x080fe20000410000ULL, 0x0000002e60607220ULL, 0x080fe20000410000ULL,
0x0000002e61617220ULL, 0x080fe20000410000ULL, 0x0000002e4c4c7220ULL, 0x080fe20000410000ULL,
0x0000002e4d4d7220ULL, 0x080fe20000410000ULL, 0x0000002e30307220ULL, 0x080fe20000410000ULL,
0x0000002e31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0034ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008022e7811ULL, 0x000fe200078ff0ffULL, 0x0000f4127f007947ULL, 0x000fea000b800000ULL,
0x00001f2e6b2e7589ULL, 0x00066400000e0000ULL, 0x0000002e52527220ULL, 0x086fe20000410000ULL,
0x0000002e53537220ULL, 0x080fe20000410000ULL, 0x0000002e56567220ULL, 0x080fe20000410000ULL,
0x0000002e57577220ULL, 0x080fe20000410000ULL, 0x0000002e5a5a7220ULL, 0x080fe20000410000ULL,
0x0000002e5b5b7220ULL, 0x080fe20000410000ULL, 0x0000002e5e5e7220ULL, 0x080fe20000410000ULL,
0x0000002e5f5f7220ULL, 0x080fe20000410000ULL, 0x0000002e66667220ULL, 0x080fe20000410000ULL,
0x0000002e67677220ULL, 0x080fe20000410000ULL, 0x0000002e62627220ULL, 0x080fe20000410000ULL,
0x0000002e63637220ULL, 0x080fe20000410000ULL, 0x0000002e4e4e7220ULL, 0x080fe20000410000ULL,
0x0000002e4f4f7220ULL, 0x080fe20000410000ULL, 0x0000002e32327220ULL, 0x080fe20000410000ULL,
0x0000002e33337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff34ff7812ULL, 0x000fe40007800811ULL, 0x000000740f747209ULL, 0x000fd60007810000ULL,
0x800000740f0f0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00130308ULL, 0x000e640000000800ULL, 0x000000130e0e0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000000b0e0b7221ULL, 0x004fe20000010000ULL,
0x0000010000008947ULL, 0x000fea0003800000ULL, 0x00000013ff0e723eULL, 0x000fe400000000ffULL,
0x00000002ff127819ULL, 0x000fe40000011602ULL, 0x000054100e6b7816ULL, 0x008fe2000000000eULL,
0x0000f2327f007947ULL, 0x000fea000b800000ULL, 0x00001f126b147589ULL, 0x0002a400000e0000ULL,
0x00000008122e7810ULL, 0x000fe20007ffe0ffULL, 0x0000f2527f007947ULL, 0x000fea000b800000ULL,
0x00001f2e6b157589ULL, 0x00066400000e0000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x00000010122e7810ULL, 0x008fe40007ffe0ffULL, 0x0000b1d0002c7802ULL, 0x000fc40000000f00ULL,
0x0000f78000007944ULL, 0x016fea0003c00000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x00000018122e7810ULL, 0x00cfe40007ffe0ffULL, 0x0000b210002c7802ULL, 0x000fc40000000f00ULL,
0x0000f74000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000b80017177811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001934783bULL, 0x000fe20000004200ULL, 0x0000b8001d1d7811ULL, 0x000fe200078e20ffULL,
0x0000580009117a24ULL, 0x010fe200078e02ffULL, 0x00000300030e7a10ULL, 0x000fe20007ffe0ffULL,
0x00000000172c783bULL, 0x00cea60000000200ULL, 0x000000010e0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000001a38783bULL, 0x000fe60000004200ULL, 0x000000060f00720cULL, 0x000fe20003f26070ULL,
0x000000001b3c783bULL, 0x000fe80000004200ULL, 0x000000001c40783bULL, 0x000fe80000004200ULL,
0x000000001d48783bULL, 0x000ee80000000200ULL, 0x000000001e44783bULL, 0x000e680000004200ULL,
0x000000001f6c783bULL, 0x0002680000004200ULL, 0x000000002070783bULL, 0x000e680000004200ULL,
0x000000002168783bULL, 0x002e620000004200ULL, 0x000000142c2c0232ULL, 0x004fc40000000000ULL,
0x000000142e2e0232ULL, 0x000fe40000000000ULL, 0x000000152d2d0232ULL, 0x080fe40000000000ULL,
0x000000152f2f0232ULL, 0x000fce0000000000ULL, 0x000000342c50723cULL, 0x000f620000001850ULL,
0x0000001448480232ULL, 0x088fe40000000000ULL, 0x000000144a4a0232ULL, 0x000fe40000000000ULL,
0x0000001549490232ULL, 0x000fc60000000000ULL, 0x000000362c34723cULL, 0x000f620000001854ULL,
0x000000154b4b0232ULL, 0x000fce0000000000ULL, 0x000000382c58723cULL, 0x040f700000001858ULL,
0x0000003a2c38723cULL, 0x040f70000000185cULL, 0x0000003c2c64723cULL, 0x040f700000001864ULL,
0x0000003e2c60723cULL, 0x040f700000001860ULL, 0x000000402c4c723cULL, 0x040f70000000184cULL,
0x000000422c2c723cULL, 0x000f700000001830ULL, 0x00000044481c723cULL, 0x060f700000001850ULL,
0x000000464830723cULL, 0x040f700000001834ULL, 0x0000006c4834723cULL, 0x040f700000001858ULL,
0x0000006e4838723cULL, 0x040f700000001838ULL, 0x00000070483c723cULL, 0x040f700000001864ULL,
0x000000724840723cULL, 0x040f700000001860ULL, 0x000000684844723cULL, 0x042f70000000184cULL,
0x0000006a4848723cULL, 0x000b6e000000182cULL, 0x00000080112d7824ULL, 0x020fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x00000003ff2f7819ULL, 0x000fe20000011602ULL, 0x000001000e0f7824ULL, 0x000fc600078e00ffULL,
0x000000042f4d7810ULL, 0x040fe40007ffe0ffULL, 0x000000102f5b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f040e7217ULL, 0x000fe20007800000ULL, 0x000000014d127824ULL, 0x000fe200078e0202ULL,
0x000000082f537810ULL, 0x000fe20007ffe0ffULL, 0x000000084d4f7824ULL, 0x000fe200078e00ffULL,
0x0000000c2f577810ULL, 0x000fe20007ffe0ffULL, 0x000000085b5d7824ULL, 0x000fe200078e00ffULL,
0x000000182f637810ULL, 0x000fe20007ffe0ffULL, 0x000000010e117824ULL, 0x000fe200078e0a0fULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee212ULL, 0x000000015b127824ULL, 0x100fe200078e0202ULL,
0x000000142f5f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001530e7824ULL, 0x000fe200078e0202ULL,
0x0000001c2f677810ULL, 0x000fe20007ffe0ffULL, 0x0000000853557824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee212ULL, 0x000000010a127824ULL, 0x000fe200078e024dULL,
0x0000002011117817ULL, 0x000fe20003800000ULL, 0x00000001570f7824ULL, 0x000fe200078e0202ULL,
0xfffffff855557812ULL, 0x000fe200078ee20eULL, 0x00000008571a7824ULL, 0x000fe200078e00ffULL,
0x0000002d12127210ULL, 0x000fe20007f5e0ffULL, 0x000000010a0e7824ULL, 0x000fc400078e022fULL,
0x00000001631b7824ULL, 0x140fe200078e0202ULL, 0xfffffff81a597812ULL, 0x000fe200078ee20fULL,
0x00000008632e7824ULL, 0x000fe200078e00ffULL, 0x0000002d0e0f7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0x00005e00121a7a11ULL, 0x000fe200078448ffULL,
0x000000015f197824ULL, 0x040fe200078e0202ULL, 0xfffffff82e657812ULL, 0x000fe200078ee21bULL,
0x000000085f2c7824ULL, 0x000fe200078e00ffULL, 0x00005f00121b7a11ULL, 0x000fe200010f4c17ULL,
0x000000ffff207224ULL, 0x000fe200008e06ffULL, 0x00005e000f0e7a11ULL, 0x040fe200078248ffULL,
0x000000010a127824ULL, 0x000fe200078e0253ULL, 0xfffffff82c617812ULL, 0x000fe200078ee219ULL,
0x000000010a2c7824ULL, 0x040fe200078e025bULL, 0x00005f000f0f7a11ULL, 0x000fe200008f4c20ULL,
0x000000010a207824ULL, 0x000fe200078e0257ULL, 0x0000002d12217210ULL, 0x080fe20007f7e0ffULL,
0x000000010a4c7824ULL, 0x000fe200078e025fULL, 0x0000002d2c237210ULL, 0x080fe20007f5e0ffULL,
0x000000010a4e7824ULL, 0x000fe200078e0263ULL, 0x0000002d202b7210ULL, 0x080fe20007f3e0ffULL,
0x000000010a127824ULL, 0x000fe200078e0267ULL, 0x00005e0021207a11ULL, 0x000fe200078c48ffULL,
0x000000012f2e7824ULL, 0x100fe200078e0202ULL, 0x0000002d4e197210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x0000002d4c177210ULL, 0x080fe20007f7e0ffULL,
0x00000001674c7824ULL, 0x040fe200078e0202ULL, 0x0000002d12127210ULL, 0x000fe20007f9e0ffULL,
0x0000000867697824ULL, 0x000fe200078e00ffULL, 0x000000072e2d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005f0021217a11ULL, 0x000fe200030f4c2cULL,
0x000000ffff507224ULL, 0x000fe200028e06ffULL, 0x00005e002b2c7a11ULL, 0x000fe200078c48ffULL,
0x0000001055557824ULL, 0x100fe200078e0218ULL, 0x000000112f00720cULL, 0x080fe20003f26070ULL,
0x0000001059597824ULL, 0x000fe200078e0218ULL, 0x0ffffff82d2f7812ULL, 0x000fe200078ef802ULL,
0x000000105d5d7824ULL, 0x000fe200078e0218ULL, 0x00005f002b2d7a11ULL, 0x000fe200030f4c2eULL,
0x00000001082b7824ULL, 0x000fe200078e0216ULL, 0x00005e00232e7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0xfffffff869697812ULL, 0x000fe200078ee24cULL,
0x000000102f517824ULL, 0x000fe200078e0218ULL, 0x000000114d00720cULL, 0x000fe20003f46070ULL,
0x000000102b0e7825ULL, 0x000fe200078e000eULL, 0x00005f00232f7a11ULL, 0x000fc400030f4c16ULL,
0x00005e00174c7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e2000c901c46ULL,
0x000000104f237824ULL, 0x100fe200078e0218ULL, 0x000000115300720cULL, 0x080fe20003f26070ULL,
0x0000001061617824ULL, 0x000fe200078e0218ULL, 0x00005f00174d7a11ULL, 0x000fe200030f4c16ULL,
0x000000102b167825ULL, 0x000fe200078e001aULL, 0x00005e00194e7a11ULL, 0x000fe400078c48ffULL,
0x000000115700720cULL, 0x080fe20003f66070ULL, 0x0000001065657824ULL, 0x000fe200078e0218ULL,
0x00005f00194f7a11ULL, 0x000fe200030f4c50ULL, 0x000000ffff197224ULL, 0x000fe200020e06ffULL,
0x00005e0012507a11ULL, 0x000fe200078848ffULL, 0x0000000016237faeULL, 0x0005e2000d101c46ULL,
0x000000115b00720cULL, 0x080fe20003fa6070ULL, 0x000000102b0e7825ULL, 0x002fe200078e0020ULL,
0x000000115f00720cULL, 0x000fc40003fc6070ULL, 0x000000116300720cULL, 0x080fe20003f46070ULL,
0x0000001069697824ULL, 0x000fe200078e0218ULL, 0x00005f0012517a11ULL, 0x000fe200020f4c19ULL,
0x000000102b187825ULL, 0x000fe200078e002eULL, 0x000000116700720cULL, 0x000fe20003f86070ULL,
0x000000000e557faeULL, 0x0003e4000c901c46ULL, 0x000000102b167825ULL, 0x004fc800078e002cULL,
0x000000102b1a7825ULL, 0x040fe200078e004cULL, 0x0000000016597faeULL, 0x0003e6000d901c46ULL,
0x000000102b207825ULL, 0x040fe200078e004eULL, 0x00000000185d7faeULL, 0x0003e6000e901c46ULL,
0x000000102b2c7825ULL, 0x000fe200078e0050ULL, 0x000000001a617faeULL, 0x0003e8000f101c46ULL,
0x0000000020657faeULL, 0x0003e8000d101c46ULL, 0x000000002c697faeULL, 0x0003e2000e101c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x00000004020f7811ULL, 0x040fe400078fe8ffULL,
0x0000000c02217811ULL, 0x000fc400078fe8ffULL, 0x0000001002237811ULL, 0x040fe200078fe8ffULL,
0x000000010f0e7824ULL, 0x140fe200078e0202ULL, 0x0000000802197811ULL, 0x040fe200078fe8ffULL,
0x000000080f2f7824ULL, 0x000fe200078e00ffULL, 0x00000014022b7811ULL, 0x040fe200078fe8ffULL,
0x0000000121117824ULL, 0x040fe200078e0202ULL, 0x0000001802537811ULL, 0x000fe200078fe8ffULL,
0x00000008211a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL,
0x0000000123127824ULL, 0x140fe400078e0202ULL, 0x0000000823517824ULL, 0x000fe200078e00ffULL,
0xfffffff81a4f7812ULL, 0x000fe200078ee211ULL, 0x00000001190e7824ULL, 0x000fc400078e0202ULL,
0x00000008194d7824ULL, 0x000fe200078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee212ULL,
0x000000012b117824ULL, 0x040fe400078e0202ULL, 0x000000082b1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee20eULL, 0x000000010a127824ULL, 0x000fe200078e020fULL,
0x0000000a020e7211ULL, 0x000fe200078fe8ffULL, 0x0000000153177824ULL, 0x040fe200078e0202ULL,
0xfffffff81a5d7812ULL, 0x000fe200078ee211ULL, 0x00000008532c7824ULL, 0x000fe200078e00ffULL,
0x0000002d12117210ULL, 0x080fe20007f5e0ffULL, 0x000000010a2e7824ULL, 0x000fe200078e022bULL,
0x0000002d0e0f7210ULL, 0x080fe20007f3e0ffULL, 0x000000010a4c7824ULL, 0x000fe200078e0253ULL,
0xfffffff82c5f7812ULL, 0x000fe200078ee217ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e00111a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff207224ULL, 0x000fe200008e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078248ffULL, 0x000000010a2c7824ULL, 0x040fe200078e0223ULL,
0x00005f00111b7a11ULL, 0x000fe200010f4c12ULL, 0x000000010a127824ULL, 0x000fe200078e0219ULL,
0x0000000202177211ULL, 0x040fe200078fe8ffULL, 0x000000102f557824ULL, 0x100fe200078e0218ULL,
0x0000001c02117811ULL, 0x000fe200078fe8ffULL, 0x000000104d577824ULL, 0x000fe200078e0218ULL,
0x00005f000f0f7a11ULL, 0x000fe200008f4c20ULL, 0x000000010a207824ULL, 0x040fe200078e0221ULL,
0x0000000717177812ULL, 0x000fe200078ec0ffULL, 0x000000010a4e7824ULL, 0x000fe200078e0211ULL,
0x0000002d12217210ULL, 0x080fe20007f9e0ffULL, 0x0000000111507824ULL, 0x100fe200078e0202ULL,
0x0ffffff8172b7812ULL, 0x000fe200078ef802ULL, 0x0000000811537824ULL, 0x000fe200078e00ffULL,
0x0000002d2c237210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x0000002d20127210ULL, 0x080fe20007f5e0ffULL, 0x000000104f597824ULL, 0x100fe200078e0218ULL,
0x00005e0021207a11ULL, 0x000fe200078c48ffULL, 0x00000010515b7824ULL, 0x100fe200078e0218ULL,
0x0000002d2e197210ULL, 0x080fe20007f3e0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0218ULL,
0x0000002d4c177210ULL, 0x080fe20007f9e0ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0218ULL,
0x0000002d4e117210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff527224ULL, 0x000fe200018e06ffULL,
0xfffffff8532d7812ULL, 0x000fe200078ee250ULL, 0x000000102b537824ULL, 0x000fe200078e0218ULL,
0x00005f0021217a11ULL, 0x000fe200030f4c2cULL, 0x000000ffff2b7224ULL, 0x000fe200010e06ffULL,
0x00005e00122c7a11ULL, 0x040fe200078448ffULL, 0x000000102d617824ULL, 0x000fe200078e0218ULL,
0x00005e00174e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x00005f00122d7a11ULL, 0x000fe200010f4c2bULL, 0x00000001082b7824ULL, 0x000fe200078e0216ULL,
0x00005e00232e7a11ULL, 0x000fe200078448ffULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005e00194c7a11ULL, 0x000fe200078248ffULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x00005e0011507a11ULL, 0x000fe200078848ffULL, 0x000000102b0e7825ULL, 0x000fe200078e000eULL,
0x00005f00232f7a11ULL, 0x000fc400010f4c52ULL, 0x00005f00194d7a11ULL, 0x000fe200008f4c18ULL,
0x000000102b187825ULL, 0x000fe200078e0020ULL, 0x00005f00174f7a11ULL, 0x000fe200018f4c16ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e537faeULL, 0x0003e2000b901c46ULL,
0x00005f0011517a11ULL, 0x000fe200020f4c12ULL, 0x000000102b167825ULL, 0x000fc800078e001aULL,
0x000000102b1a7825ULL, 0x040fe200078e002cULL, 0x0000000016557faeULL, 0x0003e6000b901c46ULL,
0x000000102b207825ULL, 0x040fe200078e002eULL, 0x0000000018577faeULL, 0x0003e6000b901c46ULL,
0x000000102b2c7825ULL, 0x040fe200078e004cULL, 0x000000001a597faeULL, 0x0003e6000b901c46ULL,
0x000000102b2e7825ULL, 0x040fe200078e004eULL, 0x00000000205b7faeULL, 0x0003e6000b901c46ULL,
0x000000102b4c7825ULL, 0x000fe200078e0050ULL, 0x000000002c5d7faeULL, 0x0003e8000b901c46ULL,
0x000000002e5f7faeULL, 0x0003e8000b901c46ULL, 0x000000004c617faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000013ff0e723eULL, 0x002fe400000000ffULL, 0x00000002ff127819ULL, 0x000fe40000011602ULL,
0x000054100e6b7816ULL, 0x000fe2000000000eULL, 0x0000e1727f007947ULL, 0x000fea000b800000ULL,
0x00001f126b147589ULL, 0x0002a400000e0000ULL, 0x00000008122e7810ULL, 0x000fe20007ffe0ffULL,
0x0000e1927f007947ULL, 0x000fea000b800000ULL, 0x00001f2e6b157589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x00000010122e7810ULL, 0x008fe40007ffe0ffULL,
0x0000c320002c7802ULL, 0x000fc40000000f00ULL, 0x0000e63000007944ULL, 0x006fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x00000018122e7810ULL, 0x00cfe40007ffe0ffULL,
0x0000c360002c7802ULL, 0x000fc40000000f00ULL, 0x0000e5f000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b80022227811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002718783bULL, 0x002fe20000004200ULL,
0x0000b80028287811ULL, 0x000fc600078e20ffULL, 0x000000002220783bULL, 0x000e680000000200ULL,
0x00000000242c783bULL, 0x00cfe80000004200ULL, 0x00000000254c783bULL, 0x000fe80000004200ULL,
0x000000002650783bULL, 0x000fe80000004200ULL, 0x000000002868783bULL, 0x000ea80000000200ULL,
0x000000000d54783bULL, 0x000ee80000004200ULL, 0x00000000295c783bULL, 0x000f280000004200ULL,
0x000000002a60783bULL, 0x000ee80000004200ULL, 0x000000000c6c783bULL, 0x000ee20000004200ULL,
0x0000001420200232ULL, 0x002fc40000000000ULL, 0x0000001422220232ULL, 0x000fe40000000000ULL,
0x0000001521210232ULL, 0x080fe40000000000ULL, 0x0000001523230232ULL, 0x000fce0000000000ULL,
0x00000018201c723cULL, 0x000f62000000181cULL, 0x0000001468680232ULL, 0x084fe40000000000ULL,
0x000000146a6a0232ULL, 0x000fe40000000000ULL, 0x0000001569690232ULL, 0x000fc60000000000ULL,
0x0000001a2030723cULL, 0x000f620000001830ULL, 0x000000156b6b0232ULL, 0x000fce0000000000ULL,
0x0000002c2034723cULL, 0x040f700000001834ULL, 0x0000004c203c723cULL, 0x040f70000000183cULL,
0x0000002e2038723cULL, 0x040f700000001838ULL, 0x0000004e2040723cULL, 0x040f700000001840ULL,
0x000000502044723cULL, 0x040f700000001844ULL, 0x000000522048723cULL, 0x000f700000001848ULL,
0x000000546850723cULL, 0x068b70000000181cULL, 0x000000566854723cULL, 0x040b700000001830ULL,
0x0000005c6858723cULL, 0x050b700000001834ULL, 0x000000606864723cULL, 0x040b70000000183cULL,
0x0000005e685c723cULL, 0x040b700000001838ULL, 0x000000626860723cULL, 0x040b700000001840ULL,
0x0000006c684c723cULL, 0x040b700000001844ULL, 0x0000006e6830723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0146a000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030003037a10ULL, 0x000fc80007ffe0ffULL,
0x000000060300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff4ff000007947ULL, 0x000fea000383ffffULL, 0x0000000000217919ULL, 0x000e640000002500ULL,
0x000000062100720cULL, 0x002fda0003f06070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x018000000b027810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000c71000067802ULL, 0x000fc40000000f00ULL,
0x0000e07000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00027308ULL, 0x000e640000001000ULL,
0xbf80000002037423ULL, 0x002fc8000000000bULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000302027223ULL, 0x000fc40000000002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000047919ULL, 0x000ee20000000000ULL,
0x00000002ff037819ULL, 0x004fe40000011603ULL, 0x0000000804057811ULL, 0x008fc800078ff0ffULL,
0x00001f0302037589ULL, 0x000ea800000e0000ULL, 0x00001f0502047589ULL, 0x000ee200000e0000ULL,
0x0000005003507220ULL, 0x064fe20000410000ULL, 0x0000005103517220ULL, 0x040fe20000410000ULL,
0x0000005403547220ULL, 0x040fe20000410000ULL, 0x0000005503557220ULL, 0x040fe20000410000ULL,
0x0000005803587220ULL, 0x040fe20000410000ULL, 0x0000005903597220ULL, 0x040fe20000410000ULL,
0x0000005c035c7220ULL, 0x040fe20000410000ULL, 0x0000005d035d7220ULL, 0x040fe20000410000ULL,
0x0000006403647220ULL, 0x040fe20000410000ULL, 0x0000006503657220ULL, 0x040fe20000410000ULL,
0x0000006003607220ULL, 0x040fe20000410000ULL, 0x0000006103617220ULL, 0x040fe20000410000ULL,
0x0000004c034c7220ULL, 0x040fe20000410000ULL, 0x0000004d034d7220ULL, 0x040fe20000410000ULL,
0x0000003003307220ULL, 0x040fe20000410000ULL, 0x0000003103317220ULL, 0x000fe20000410000ULL,
0x0000005204527220ULL, 0x048fe20000410000ULL, 0x0000005304537220ULL, 0x040fe20000410000ULL,
0x0000005604567220ULL, 0x040fe20000410000ULL, 0x0000005704577220ULL, 0x040fe20000410000ULL,
0x0000005a045a7220ULL, 0x040fe20000410000ULL, 0x0000005b045b7220ULL, 0x040fe20000410000ULL,
0x0000005e045e7220ULL, 0x040fe20000410000ULL, 0x0000005f045f7220ULL, 0x040fe20000410000ULL,
0x0000006604667220ULL, 0x040fe20000410000ULL, 0x0000006704677220ULL, 0x040fe20000410000ULL,
0x0000006204627220ULL, 0x040fe20000410000ULL, 0x0000006304637220ULL, 0x040fe20000410000ULL,
0x0000004e044e7220ULL, 0x040fe20000410000ULL, 0x0000004f044f7220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x000fc20000410000ULL,
0x00000000001b7919ULL, 0x000ea20000000000ULL, 0x000000505104723eULL, 0x020fc400000000ffULL,
0x000000545505723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000585906723eULL, 0x000fe400000000ffULL, 0x0000005c5d07723eULL, 0x000fe400000000ffULL,
0x000000646509723eULL, 0x000fc400000000ffULL, 0x00000060610a723eULL, 0x000fe400000000ffULL,
0x0000004c4d0c723eULL, 0x000fe400000000ffULL, 0x00000030310d723eULL, 0x000fe400000000ffULL,
0x00000052530e723eULL, 0x000fe400000000ffULL, 0x00000002ff1d7819ULL, 0x004fe4000001161bULL,
0x000000081b267811ULL, 0x000fc400078ff0ffULL, 0x000000011d027810ULL, 0x040fe20007ffe0ffULL,
0x000000081d177824ULL, 0x040fe200078e00ffULL, 0x000000021d037810ULL, 0x040fe20007ffe0ffULL,
0x000000081d1a7824ULL, 0x040fe200078e00ffULL, 0x000000051d167810ULL, 0x040fe20007ffe0ffULL,
0x000000081d197824ULL, 0x000fe200078e00ffULL, 0xfffffff817187812ULL, 0x000fe200078ee202ULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0x000000031d027810ULL, 0x040fe20007ffe0ffULL,
0x000000081d227824ULL, 0x040fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL,
0x000000081d1e7824ULL, 0x040fe200078e00ffULL, 0x000000061d177810ULL, 0x040fe20007ffe0ffULL,
0x000000081d247824ULL, 0x000fe200078e00ffULL, 0xfffffff8191c7812ULL, 0x000fe200078ee202ULL,
0x0000080000027824ULL, 0x000fe200078e00ffULL, 0xfffffff81f207812ULL, 0x000fe200078ee216ULL,
0x000000081d167824ULL, 0x040fe200078e00ffULL, 0x000000041d037810ULL, 0x000fc40007ffe0ffULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x000000041b177824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee203ULL, 0xfffffff816167812ULL, 0x000fe400078ee21dULL,
0x0000a00002037810ULL, 0x000fe40007ffe0ffULL, 0xffffffff1d197810ULL, 0x000fe20007ffe0ffULL,
0x00000008261d7824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x0000001016167824ULL, 0x000fe200078e0203ULL, 0xfffffff824247812ULL, 0x000fe200078ee219ULL,
0x0000001018187824ULL, 0x100fe200078e0203ULL, 0xfffffff81d267812ULL, 0x000fe200078ee226ULL,
0x000000101a1a7824ULL, 0x100fe200078e0203ULL, 0x00000056570f723eULL, 0x000fe200000000ffULL,
0x000000101c1c7824ULL, 0x100fe200078e0203ULL, 0x0000005a5b10723eULL, 0x000fe200000000ffULL,
0x0000001022227824ULL, 0x100fe200078e0203ULL, 0x0000005e5f11723eULL, 0x000fe200000000ffULL,
0x000000101e1e7824ULL, 0x000fe200078e0203ULL, 0x000000666712723eULL, 0x000fe200000000ffULL,
0x0000000116197824ULL, 0x000fe200078e0217ULL, 0x000000626313723eULL, 0x000fe200000000ffULL,
0x0000001020207824ULL, 0x100fe200078e0203ULL, 0x0000004e4f14723eULL, 0x000fe200000000ffULL,
0x0000000117187824ULL, 0x040fe200078e0218ULL, 0x0000000419007388ULL, 0x0005e20000000800ULL,
0x00000001171b7824ULL, 0x000fe200078e021aULL, 0x000000323315723eULL, 0x000fe200000000ffULL,
0x0000001024247824ULL, 0x000fe200078e0203ULL, 0x0000000518007388ULL, 0x0005e20000000800ULL,
0x00000001171c7824ULL, 0x000fc400078e021cULL, 0x00000001171d7824ULL, 0x040fe200078e0222ULL,
0x000000061b007388ULL, 0x0005e20000000800ULL, 0x0000001026267824ULL, 0x000fe400078e0203ULL,
0x00000001171e7824ULL, 0x040fe200078e021eULL, 0x000000071c007388ULL, 0x0005e20000000800ULL,
0x00000300ff227624ULL, 0x000fe400078e00ffULL, 0x0000000117207824ULL, 0x040fe200078e0220ULL,
0x000000091e007388ULL, 0x0005e20000000800ULL, 0x0000000117247824ULL, 0x040fe200078e0224ULL,
0x000000012200780cULL, 0x000fe20003f05270ULL, 0x0000000117177824ULL, 0x000fe200078e0226ULL,
0x0000000a20007388ULL, 0x0005e80000000800ULL, 0x0000000c1d007388ULL, 0x0005e80000000800ULL,
0x0000000d24007388ULL, 0x0005e80000000800ULL, 0x0000000e17007388ULL, 0x0005e80000000800ULL,
0x0004000f18007388ULL, 0x0005e80000000800ULL, 0x000400101b007388ULL, 0x0005e80000000800ULL,
0x000400111c007388ULL, 0x0005e80000000800ULL, 0x000400121e007388ULL, 0x0005e80000000800ULL,
0x0004001320007388ULL, 0x0005e80000000800ULL, 0x000400141d007388ULL, 0x0005e80000000800ULL,
0x0004001524007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000271000008947ULL, 0x000fea0003800000ULL, 0x00005800ff047624ULL, 0x004fe200078e00ffULL,
0x0000000000067919ULL, 0x000ea60000002700ULL, 0x0000660004047a24ULL, 0x000fe200078e02ffULL,
0x00000000000d7919ULL, 0x000ea60000002600ULL, 0x0000030004097a24ULL, 0x040fe200078e02ffULL,
0x0000000f04057811ULL, 0x000fe200078e10ffULL, 0x0000000000077919ULL, 0x000ee60000000000ULL,
0xfffffff005127812ULL, 0x000fca00078ec0ffULL, 0x0000008009147824ULL, 0x000fc800078e0212ULL,
0x0000008009097824ULL, 0x000fca00078e0214ULL, 0x0000007f09047810ULL, 0x000fe20007ffe0ffULL,
0x0000580006067a24ULL, 0x004fc600078e020dULL, 0xffffff8004137812ULL, 0x000fe200078ec0ffULL,
0x0000030006097a24ULL, 0x000fe200078e02ffULL, 0x00000020070d7810ULL, 0x048fe20007ffe0ffULL,
0x00000010070c7824ULL, 0x000fe200078e0202ULL, 0x00006a0013057a10ULL, 0x000fe20007f1e0ffULL,
0x00000001090a7824ULL, 0x000fc600078e0221ULL, 0x00a000000c187984ULL, 0x000ea40000000c00ULL,
0x000000050a047211ULL, 0x000fe200078260ffULL, 0x00006b00ff057624ULL, 0x000fe200000e06ffULL,
0x00006a0012167a10ULL, 0x000fe20007f1e0ffULL, 0x00a200000c1c7984ULL, 0x0006660000000c00ULL,
0x000000050a057211ULL, 0x000fe200008f64ffULL, 0x00006b00ff157624ULL, 0x000fe200000e06ffULL,
0x000000ff0000720cULL, 0x000fc60003f25270ULL, 0x0000040000047825ULL, 0x000fcc00078e0004ULL,
0x000000100d0c7825ULL, 0x008fc800078e0004ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000011000001947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000ee20000000000ULL,
0x000000800a0f7824ULL, 0x000fe200078e00ffULL, 0x00000019ff0a7819ULL, 0x000fe2000001160aULL,
0x000000100e107824ULL, 0x008fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fc8000001160eULL,
0x0000007010117812ULL, 0x000fe400078ec0ffULL, 0x00006a000f107a10ULL, 0x000fe40007b5e014ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x00000016110f7210ULL, 0x000fe4000791e00fULL,
0x00006b000a177a10ULL, 0x000fe400017e64ffULL, 0x000000100e107210ULL, 0x000fc40007c7e011ULL,
0x0000000f0e0e7210ULL, 0x000fe40007f5e0ffULL, 0x00000015ff0a7210ULL, 0x000fe400007e240aULL,
0x00000017ff117210ULL, 0x000fc60001fe84ffULL, 0x000000ffff0f7224ULL, 0x000fca00010e060aULL,
0x000000740e007986ULL, 0x0007e8000c101906ULL, 0x0000000b10007986ULL, 0x0007e4000c101906ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000001804007986ULL, 0x004fe2000c101d06ULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0x000000ff0000720cULL, 0x000fe20000705670ULL,
0x0000001c0c007986ULL, 0x002fe8000c101d06ULL, 0x0000000000007b1dULL, 0x000ff00000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0xffffffff220b7810ULL, 0x008fc60007ffe0ffULL, 0x00006a0006047625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000b040479a8ULL, 0x000ea400099ee1c6ULL,
0x0000000b0400720cULL, 0x004fc80003f05270ULL, 0x00000001ff067807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000006ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff047984ULL, 0x000ea40000000000ULL, 0x000000ff0400720cULL, 0x004fda0003f05270ULL,
0x0000225000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001007057824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x002fe40000011607ULL, 0x0000001609047211ULL, 0x000fe400078038ffULL,
0x00000070050b7812ULL, 0x008fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fe400078ec0ffULL,
0x0000001509057211ULL, 0x000fe400000f3cffULL, 0x0000000406047210ULL, 0x000fc8000791e00bULL,
0x00000005ff057210ULL, 0x000fca00007e24ffULL, 0x0000000604067981ULL, 0x000328000c1e1900ULL,
0x00008006040b7981ULL, 0x000322000c1e1900ULL, 0x000000022200780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010006040d7981ULL, 0x002322000c1e1900ULL,
0x000000042200780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x00018006040f7981ULL, 0x002322000c1e1900ULL, 0x000000042200780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000604117981ULL, 0x002322000c1e1900ULL,
0x000000062200780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800604157981ULL, 0x002322000c1e1900ULL, 0x000000062200780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000082200780cULL, 0x002fe20003f06070ULL,
0x0003000604177981ULL, 0x000318000c1e1900ULL, 0x0003800604190981ULL, 0x000324000c1e1900ULL,
0x0000000722047810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011604ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x00000012091d7211ULL, 0x000fe200078038ffULL, 0x000000ffff0e7224ULL, 0x008fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1b7224ULL, 0x010fe200078e0006ULL,
0x00006a001d1d7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff090c7211ULL, 0x000fe400000f3cffULL,
0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL, 0x00006b00ff0c7a10ULL, 0x000fc400017e240cULL,
0x000003000e007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x000000040a007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080e047810ULL, 0x040fe40007ffe0ffULL, 0x000000010e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001b06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffc8006041b7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090e047810ULL, 0x042fe40007ffe0ffULL, 0x000000020e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000b06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffd0006040b7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000030e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffd8006040d7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000040e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000f06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffe0006040f7981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000050e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xfffe800604117981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000060e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xffff000604157981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e047810ULL, 0x042fe40007ffe0ffULL, 0x000000070e057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001706067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0xffff800604177981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e047810ULL, 0x002fe40007ffe0ffULL, 0x0000001906067209ULL, 0x000fe40007810000ULL,
0x0000030004007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060cULL,
0x0000000604197981ULL, 0x000326000c1e1900ULL, 0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL,
0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e060cULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x000ea40000000000ULL,
0x0000001007047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fca00078ec0ffULL,
0x0000000104057824ULL, 0x000fca00078e0205ULL, 0x0000000605007388ULL, 0x0103e40000000800ULL,
0x00006a0013047a10ULL, 0x000fe20007f1e0ffULL, 0x0000040000417824ULL, 0x040fe200078e00ffULL,
0x00000016ff437819ULL, 0x000fe20000011600ULL, 0x0000001007067824ULL, 0x042fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011607ULL, 0x00006b00ff057624ULL, 0x000fe200000e06ffULL,
0x000000070700780cULL, 0x000fe20003f04070ULL, 0x0000100000167824ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x00001000090a7825ULL, 0x008fe200078e0004ULL,
0x0000000c0c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000410a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000106067824ULL, 0x000fe200078e020dULL,
0x00006a0012467a10ULL, 0x000fe20007f5e0ffULL, 0x0000001000158824ULL, 0x000fe200078e0207ULL,
0x00000020070d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200008e0643ULL,
0x00006a0014427a10ULL, 0x000fe20007f3e0ffULL, 0x00006b00ff487624ULL, 0x000fe200010e06ffULL,
0x0000004609108211ULL, 0x000fe200078438ffULL, 0x0000001000178824ULL, 0x000fe200078e0207ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x00006b00ff447624ULL, 0x000fe200008e06ffULL,
0x00000042090e8211ULL, 0x000fe200078238ffULL, 0x000000100d0c7825ULL, 0x000fe200078e000aULL,
0x0000004809118211ULL, 0x040fe200010f3cffULL, 0x0000000006067984ULL, 0x000e620000000800ULL,
0x00000044090f8211ULL, 0x000fe200008f3cffULL, 0x0000001007137824ULL, 0x040fe200078e0216ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000010070a7825ULL, 0x000fe200078e000aULL,
0x0000418017178811ULL, 0x000fe200078e20ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000010070e8825ULL, 0x040fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0005e2000b901c46ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000001007108825ULL, 0x000fe200078e0010ULL, 0x003800000c137faeULL, 0x0005e2000b901c46ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000000e158faeULL, 0x0007e2000b901c46ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000010178faeULL, 0x0009e2000b901c46ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000127805ULL, 0x004fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x008fe2000001ff00ULL, 0x000000ffff177224ULL, 0x010fe200078e00ffULL,
0x00000bd000009947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fc400078e00ffULL, 0x00000001ff477424ULL, 0x000fca00078e00ffULL,
0x0000030047007a0cULL, 0x000fda0003f06070ULL, 0x000001f000000947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f44070ULL, 0x00001000090a7825ULL, 0x000fe200078e0004ULL,
0x00000001470f7812ULL, 0x000fe400078ec0ffULL, 0x00000020073b7810ULL, 0x000fe20007ffe0ffULL,
0x00000800470c7824ULL, 0x000fe200078e00ffULL, 0x000000410a0a7210ULL, 0x000fc80007f1e0ffULL,
0x000008000c0d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b0b7824ULL, 0x000fe400000e0643ULL,
0x000000020034a824ULL, 0x140fe200078e020fULL, 0x00000042090ea211ULL, 0x040fe200078038ffULL,
0x000000020036a824ULL, 0x000fe200078e020fULL, 0x000000460910a211ULL, 0x040fe200078238ffULL,
0x00000001160c7824ULL, 0x000fe200078e020dULL, 0x00000044090fa211ULL, 0x040fe200000f3cffULL,
0x000000083434a824ULL, 0x100fe200078e0207ULL, 0x000000480911a211ULL, 0x000fe200008f3cffULL,
0x000000083636a824ULL, 0x000fc400078e0207ULL, 0x0000001007357824ULL, 0x000fe200078e020cULL,
0x000045803437a811ULL, 0x000fe200078e20ffULL, 0x000000103b0c7825ULL, 0x000fe200078e000aULL,
0x000041803639a811ULL, 0x000fc600078e20ffULL, 0x00000010070a7825ULL, 0x000fc800078e000aULL,
0x00000010070ea825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a357faeULL, 0x0005e6000b901c46ULL, 0x000000100710a825ULL, 0x000fe200078e0010ULL,
0x003800000c357faeULL, 0x0005e8000b901c46ULL, 0x000000000e37afaeULL, 0x0005e8000b901c46ULL,
0x000000001039afaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff470a7810ULL, 0x004fe20007ffe0ffULL, 0x00000010070c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc40000011607ULL, 0x00000002ff3b7819ULL, 0x000fe20000011607ULL,
0x000000800a0b7824ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x000008000a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000083b347824ULL, 0x000fe200078e00ffULL, 0x000000800b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000083b107824ULL, 0x040fe200078e00ffULL, 0x000000083b3f7810ULL, 0x040fe20007ffe0ffULL,
0x000000083b367824ULL, 0x040fe200078e00ffULL, 0x000000013b0f7810ULL, 0x040fe20007ffe0ffULL,
0x00000100000b7824ULL, 0x000fe200078e020bULL, 0x000000033b117810ULL, 0x040fe20007ffe0ffULL,
0x000000083b3a7824ULL, 0x040fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20fULL,
0x000000083b397824ULL, 0x000fe200078e00ffULL, 0x0000000b0d0c7210ULL, 0x000fe20007ffe00cULL,
0x00000004070b7824ULL, 0x000fe200078e00ffULL, 0x000000023b0f7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000c0d7984ULL, 0x000ea20000000800ULL,
0x0000000c0b3d7812ULL, 0x000fe200078ec0ffULL, 0x000000083b457824ULL, 0x040fe200078e00ffULL,
0x000008000a0b7812ULL, 0x000fe200078ec0ffULL, 0x004580000c0e7984ULL, 0x0007220000000800ULL,
0xfffffff8340a7812ULL, 0x000fe200078ee23bULL, 0x000000083b4a7824ULL, 0x040fe200078e00ffULL,
0x00000180160b7810ULL, 0x000fe40007ffe00bULL, 0xfffffff834347812ULL, 0x000fe400078ee20fULL,
0x000000043b357810ULL, 0x000fe20007ffe0ffULL, 0x000000083f0c7824ULL, 0x008fe200078e00ffULL,
0x000000053b387810ULL, 0x000fe20007ffe0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e020bULL,
0x0000030047007a0cULL, 0x000fc40003f06070ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee23fULL,
0x000000013d0a7824ULL, 0x000fe200078e020aULL, 0x0000000109097810ULL, 0x000fe40007ffe0ffULL,
0x0000000147477810ULL, 0x000fe20007ffe0ffULL, 0x000000100c0c7824ULL, 0x100fe400078e020bULL,
0x000000000a0a7984ULL, 0x000ee40000000800ULL, 0x000000013d0f7824ULL, 0x000fe400078e020cULL,
0x00000010100c7824ULL, 0x000fe200078e020bULL, 0xfffffff836107812ULL, 0x000fc400078ee211ULL,
0x000000000f377984ULL, 0x0002e20000000800ULL, 0x000000013d0c7824ULL, 0x000fe200078e020cULL,
0xfffffff83a367812ULL, 0x000fe400078ee235ULL, 0xfffffff8393a7812ULL, 0x000fe400078ee238ULL,
0x000400000c387984ULL, 0x000fe20000000800ULL, 0xffffffff3b357810ULL, 0x000fe20007ffe0ffULL,
0x00000010100f7824ULL, 0x002fe200078e020bULL, 0x0000000d060d7221ULL, 0x004fe20000010100ULL,
0x0000001036117824ULL, 0x000fe200078e020bULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee235ULL,
0x000000013d107824ULL, 0x000fe200078e020fULL, 0x3fb8aa3b0d0d7820ULL, 0x000fe20000410000ULL,
0x000000013d117824ULL, 0x000fca00078e0211ULL, 0x0000000d000d7308ULL, 0x000f240000000800ULL,
0x0000000e0d3c7220ULL, 0x010fe20000410000ULL, 0x00000010340e7824ULL, 0x000fe200078e020bULL,
0x000000000c0d7984ULL, 0x000fe20000000800ULL, 0x000000063b347810ULL, 0x000fe20007ffe0ffULL,
0x000000333c337221ULL, 0x000fe20000010000ULL, 0x000000013d0e7824ULL, 0x000fe200078e020eULL,
0x00001f3b3c3e7589ULL, 0x000e6200000e0000ULL, 0xfffffff845367812ULL, 0x000fe200078ee234ULL,
0x000000103a347824ULL, 0x000fc400078e020bULL, 0x00001f3f3c407589ULL, 0x00052400000e0000ULL,
0x0000001036357824ULL, 0x100fe400078e020bULL, 0x000000000e0f7984ULL, 0x000f220000000800ULL,
0x000000104a367824ULL, 0x000fe400078e020bULL, 0x000000013d347824ULL, 0x040fe200078e0234ULL,
0x00000000100c7984ULL, 0x000f220000000800ULL, 0x000000013d357824ULL, 0x040fe400078e0235ULL,
0x000000013d367824ULL, 0x000fe200078e0236ULL, 0x000400000e397984ULL, 0x000f220000000800ULL,
0x2000000aff3d7230ULL, 0x008fc40000004100ULL, 0x3000000aff0a7230ULL, 0x000fe20000004100ULL,
0x00000000110b7984ULL, 0x000ee20000000800ULL, 0x30000037ff3c7230ULL, 0x104fe40000004100ULL,
0x20000037ff3f7230ULL, 0x000fe20000004100ULL, 0x00000000340e7984ULL, 0x000ea20000000800ULL,
0x0000003e0a317223ULL, 0x082fe20000010031ULL, 0x0000003e3d327223ULL, 0x000fe20000010032ULL,
0x000000403c2f7223ULL, 0x090fe2000001002fULL, 0x00040000113b7984ULL, 0x000e620000000800ULL,
0x000000403f307223ULL, 0x000fc60000010030ULL, 0x00000000350a7984ULL, 0x000f220000000800ULL,
0x2000000dff377230ULL, 0x000fc60000004100ULL, 0x0004000035117984ULL, 0x000f220000000800ULL,
0x3000000dff3c7230ULL, 0x000fe40000004100ULL, 0x20000038ff0d7230ULL, 0x100fe20000004100ULL,
0x00040000103a7984ULL, 0x000f220000000800ULL, 0x30000038ff387230ULL, 0x000fe20000004100ULL,
0x0000003e372e7223ULL, 0x080fe2000001002eULL, 0x0000003e3c2d7223ULL, 0x000fe2000001002dULL,
0x000000400d2c7223ULL, 0x080fe2000001002cULL, 0x0004000034107984ULL, 0x000f220000000800ULL,
0x00000040382b7223ULL, 0x000fe2000001002bULL, 0x2000000fff377230ULL, 0x000fc40000004100ULL,
0x00000000360d7984ULL, 0x000f220000000800ULL, 0x3000000fff387230ULL, 0x000fe40000004100ULL,
0x2000000cff0f7230ULL, 0x100fe20000004100ULL, 0x0004000036347984ULL, 0x0005220000000800ULL,
0x3000000cff0c7230ULL, 0x000fe20000004100ULL, 0x0000003e372a7223ULL, 0x080fe2000001002aULL,
0x20000039ff3d7230ULL, 0x100fe20000004100ULL, 0x0000003e0f267223ULL, 0x080fe20000010026ULL,
0x30000039ff3c7230ULL, 0x000fe20000004100ULL, 0x0000003e0c257223ULL, 0x080fe20000010025ULL,
0x2000000bff0f7230ULL, 0x108fe20000004100ULL, 0x0000003e38297223ULL, 0x000fe20000010029ULL,
0x3000000bff367230ULL, 0x004fe20000004100ULL, 0x000000403d287223ULL, 0x000fe20000010028ULL,
0x2000000eff0c7230ULL, 0x100fe20000004100ULL, 0x0000003e0f227223ULL, 0x080fe20000010022ULL,
0x3000000eff0b7230ULL, 0x000fe20000004100ULL, 0x0000003e36217223ULL, 0x080fe20000010021ULL,
0x2000003bff0f7230ULL, 0x102fe20000004100ULL, 0x0000003e0c177223ULL, 0x080fe20000010017ULL,
0x3000003bff367230ULL, 0x000fe20000004100ULL, 0x0000003e0b1e7223ULL, 0x000fe2000001001eULL,
0x2000000aff0c7230ULL, 0x110fe20000004100ULL, 0x000000400f207223ULL, 0x080fe20000010020ULL,
0x3000000aff0b7230ULL, 0x000fe20000004100ULL, 0x000000403c277223ULL, 0x080fe20000010027ULL,
0x20000011ff0a7230ULL, 0x100fe20000004100ULL, 0x00000040361f7223ULL, 0x000fe2000001001fULL,
0x30000011ff117230ULL, 0x000fe20000004100ULL, 0x0000003e0b1c7223ULL, 0x000fe2000001001cULL,
0x2000003aff357230ULL, 0x100fe20000004100ULL, 0x000000400a1b7223ULL, 0x000fe2000001001bULL,
0x3000003aff3a7230ULL, 0x000fe20000004100ULL, 0x0000003e0c137223ULL, 0x000fe20000010013ULL,
0x00000040111a7223ULL, 0x080fe2000001001aULL, 0x20000010ff0e7230ULL, 0x100fe20000004100ULL,
0x0000004035247223ULL, 0x080fe20000010024ULL, 0x30000010ff107230ULL, 0x000fe20000004100ULL,
0x000000403a237223ULL, 0x080fe20000010023ULL, 0x2000000dff0a7230ULL, 0x100fe20000004100ULL,
0x000000400e1d7223ULL, 0x080fe2000001001dULL, 0x3000000dff0d7230ULL, 0x000fe20000004100ULL,
0x0000004010157223ULL, 0x000fe20000010015ULL, 0x20000034ff0b7230ULL, 0x100fe20000004100ULL,
0x0000003e0a197223ULL, 0x080fe20000010019ULL, 0x30000034ff0f7230ULL, 0x000fe20000004100ULL,
0x0000003e0d187223ULL, 0x000fc40000010018ULL, 0x000000400b147223ULL, 0x080fe40000010014ULL,
0x000000400f127223ULL, 0x000fe20000010012ULL, 0xfffff46000008947ULL, 0x000fea000383ffffULL,
0x0180000033007810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000000007812ULL, 0x000fe200078ec0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0033ULL, 0x0000eeb000067802ULL, 0x002fc40000000f00ULL,
0x0000b8d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003300007308ULL, 0x000ea40000001000ULL,
0xbf80000000047423ULL, 0x004fc80000000033ULL, 0x800000ff04057221ULL, 0x000fc80000010100ULL,
0x0000000500007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x002e680000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000806097811ULL, 0x002fc400078ff0ffULL, 0x00000002ff077819ULL, 0x000fe20000011606ULL,
0x0000000406067824ULL, 0x000fe400078e00ffULL, 0x00001f0900057589ULL, 0x000e6200000e0000ULL,
0x00000001070a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000807117824ULL, 0x040fe200078e00ffULL,
0x00000002070b7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0700047589ULL, 0x0004e200000e0000ULL,
0x00000008070e7824ULL, 0x040fe200078e00ffULL, 0x00000003070d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000807107824ULL, 0x000fe200078e00ffULL, 0xfffffff8110c7812ULL, 0x000fe200078ee20aULL,
0x00000008070a7824ULL, 0x040fe200078e00ffULL, 0x00000004070f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000807167824ULL, 0x040fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL,
0x0000000807347824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee207ULL,
0x0000000809367824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20dULL,
0x000000100c0c7824ULL, 0x100fe200078e0203ULL, 0x00000005070b7810ULL, 0x040fe20007ffe0ffULL,
0x000000100a0a7824ULL, 0x100fe200078e0203ULL, 0x00000006070d7810ULL, 0x000fe20007ffe0ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0203ULL, 0xfffffff816167812ULL, 0x000fe200078ee20bULL,
0x0000001010107824ULL, 0x000fe200078e0203ULL, 0x0000003005307220ULL, 0x042fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000001505007220ULL, 0x044fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001205057220ULL, 0x000fe20000410000ULL, 0x0000000807127824ULL, 0x040fe200078e00ffULL,
0x0000003204327220ULL, 0x048fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000001804047220ULL, 0x000fe20000410000ULL,
0x0000000807187824ULL, 0x040fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee20fULL,
0x0000001016167824ULL, 0x000fe200078e0203ULL, 0xffffffff070f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c06077812ULL, 0x000fe200078ec0ffULL, 0x0000001012127824ULL, 0x000fe200078e0203ULL,
0xfffffff818187812ULL, 0x000fe400078ee20dULL, 0xfffffff834347812ULL, 0x000fe200078ee20fULL,
0x000000010a0a7824ULL, 0x000fe200078e0207ULL, 0xfffffff836367812ULL, 0x000fe200078ee209ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000323131723eULL, 0x000fe200000000ffULL,
0x0000001018187824ULL, 0x100fe200078e0203ULL, 0x0000002e2d2d723eULL, 0x000fe200000000ffULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x0000001034347824ULL, 0x100fe200078e0203ULL, 0x000000262525723eULL, 0x000fe200000000ffULL,
0x0000000107107824ULL, 0x000fe200078e0210ULL, 0x000000222121723eULL, 0x000fe200000000ffULL,
0x0000001036367824ULL, 0x000fe200078e0203ULL, 0x000000171e17723eULL, 0x000fe200000000ffULL,
0x0000000107127824ULL, 0x040fe200078e0212ULL, 0x000000310a007388ULL, 0x0003e20000000800ULL,
0x0000000107167824ULL, 0x040fe200078e0216ULL, 0x000000131c13723eULL, 0x000fe200000000ffULL,
0x0000000107187824ULL, 0x040fe200078e0218ULL, 0x0000002d0c007388ULL, 0x0003e20000000800ULL,
0x000000190404723eULL, 0x000fe200000000ffULL, 0x0000000107347824ULL, 0x000fe200078e0234ULL,
0x000000302f2f723eULL, 0x000fe200000000ffULL, 0x000000290e007388ULL, 0x0003e20000000800ULL,
0x0000000107367824ULL, 0x000fe200078e0236ULL, 0x0000002c2b2b723eULL, 0x000fc400000000ffULL,
0x0000002510007388ULL, 0x0003e20000000800ULL, 0x000000282727723eULL, 0x000fe400000000ffULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x0000002112007388ULL, 0x0003e20000000800ULL,
0x000000201f1f723eULL, 0x000fe400000000ffULL, 0x0000001d0000723eULL, 0x000fe200000000ffULL,
0x0000001716007388ULL, 0x0003e20000000800ULL, 0x0000001b1a1a723eULL, 0x000fe400000000ffULL,
0x000000140505723eULL, 0x000fe200000000ffULL, 0x0000001318007388ULL, 0x0003e80000000800ULL,
0x0000000434007388ULL, 0x0003e80000000800ULL, 0x0000002f36007388ULL, 0x0003e80000000800ULL,
0x0004002b0c007388ULL, 0x0003e80000000800ULL, 0x000400270e007388ULL, 0x0003e80000000800ULL,
0x0004002310007388ULL, 0x0003e80000000800ULL, 0x0004001f12007388ULL, 0x0003e80000000800ULL,
0x0004000016007388ULL, 0x0003e80000000800ULL, 0x0004001a18007388ULL, 0x0003e80000000800ULL,
0x0004000534007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000077919ULL, 0x004ea20000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000047919ULL, 0x002e620000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020070b7810ULL, 0x00cfc60007ffe0ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x00000003ff067819ULL, 0x000fe40000011607ULL,
0x00000003ff037819ULL, 0x000fc6000001160bULL, 0x0000000106057824ULL, 0x000fe400078e0207ULL,
0x000000010b007824ULL, 0x000fc600078e0203ULL, 0x00000007050a7812ULL, 0x000fe400078ec0ffULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0ffffff80a097812ULL, 0x000fe400078ef807ULL,
0x0ffffff800057812ULL, 0x000fe400078ef80bULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x00000010090c7824ULL, 0x100fe400078e0202ULL, 0x0000001005057824ULL, 0x000fe200078e0202ULL,
0x1ffffff807077812ULL, 0x000fe200078ef808ULL, 0x0000000804097824ULL, 0x002fc400078e00ffULL,
0x00a000000c0c7984ULL, 0x000e620000000c00ULL, 0x0000000804047824ULL, 0x000fe400078e00ffULL,
0xfffffff809007812ULL, 0x000fe200078ee206ULL, 0x00a0000005107984ULL, 0x0004e20000000c00ULL,
0x000000070b097812ULL, 0x000fe400078ec0ffULL, 0xfffffff804037812ULL, 0x000fe400078ee203ULL,
0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000403007c10ULL, 0x000fc4000ff3e0ffULL,
0x1ffffff809097812ULL, 0x000fe200078ef808ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0006027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x004fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fe400078248ffULL, 0x00005b0006037a11ULL, 0x000fe400000f4c03ULL,
0x00005b0000057a11ULL, 0x000fc600008f4c05ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001009047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0c7819ULL, 0x000fe20000011600ULL, 0xffffffffff227424ULL, 0x000fc800078e00ffULL,
0x00000002030c7824ULL, 0x000fca00078e020cULL, 0x000000050c00720cULL, 0x000fda0003f06070ULL,
0x0000000227078824ULL, 0x000fc800078e00ffULL, 0x0000640007108a24ULL, 0x000fc800078e020cULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000610228981ULL, 0x000ea2000c1e1900ULL, 0x0000000103077810ULL, 0x000fe20007ffe0ffULL,
0x00000040000a7824ULL, 0x000fe400078e00ffULL, 0x0000008014087824ULL, 0x000fe200078e00ffULL,
0x000000060700720cULL, 0x000fe20003f06070ULL, 0x00000100030d7824ULL, 0x000fe200078e020aULL,
0x01460000ff0e7f8cULL, 0x000e62000c80043fULL, 0x0000008013077824ULL, 0x000fc600078e00ffULL,
0x0000004008217812ULL, 0x000fe200078ef80dULL, 0x0000000722237224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x002fe40000011602ULL,
0x0000000d04097217ULL, 0x000fe40007800000ULL, 0x000000081c1a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001210b7824ULL, 0x000fe200078e021cULL, 0x000000101c1e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a0dULL, 0x000000181c267810ULL, 0x000fe40007ffe0ffULL,
0x0000000b23197210ULL, 0x000fe20007f1e0ffULL, 0x00000001210b7824ULL, 0x040fe200078e021aULL,
0x0000000202177211ULL, 0x000fe200078fe8ffULL, 0x00000001210d7824ULL, 0x000fe200078e021eULL,
0x0000003012247812ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005e0019117a11ULL, 0x000fc400078048ffULL, 0x0000000d23157210ULL, 0x000fe40007f3e0ffULL,
0x00005f0019197a11ULL, 0x000fe200000f4c10ULL, 0x0000000121107824ULL, 0x000fe200078e0226ULL,
0x0000000b230b7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x00005e0015147a11ULL, 0x000fe400078248ffULL, 0x0000001023107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x00005e000b137a11ULL, 0x000fc400078048ffULL,
0x00005f0015157a11ULL, 0x000fe200008f4c16ULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x00005e00101f7a11ULL, 0x000fe200078448ffULL, 0x000000041e167824ULL, 0x000fe200078e00ffULL,
0x00005f000b187a11ULL, 0x000fe400000f4c18ULL, 0x00000003170b7812ULL, 0x000fe400078ec0ffULL,
0x00005f0010207a11ULL, 0x000fe400010f4c0dULL, 0x00002000000d7811ULL, 0x000fc400078e68ffULL,
0x0ffffffc0b027812ULL, 0x000fe400078ef802ULL, 0x000000091a00720cULL, 0x0c0fe20003f26070ULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc16167812ULL, 0x000fe200078ee20bULL,
0x0000001002177824ULL, 0x100fe200078e020dULL, 0x000000091c00720cULL, 0x000fe40003f06070ULL,
0x0000001124107210ULL, 0x000fe20007f7e0ffULL, 0x00000010161b7824ULL, 0x000fe200078e020dULL,
0xfffffffc1a027812ULL, 0x000fc400078ee20bULL, 0x000000201c167810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200018e0619ULL, 0x0000002414147210ULL, 0x080fe20007f9e0ffULL,
0x0000001002197824ULL, 0x000fe200078e020dULL, 0x000000091e00720cULL, 0x080fe20003f46070ULL,
0x0000000121027824ULL, 0x000fe200078e0216ULL, 0x0000002413127210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e2000c101c46ULL,
0x000000ffff157224ULL, 0x000fe200020e0615ULL, 0x000000092600720cULL, 0x040fe20003f86070ULL,
0x0000000426267824ULL, 0x000fe200078e00ffULL, 0x00000002231e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200018e0618ULL, 0x000000281c187810ULL, 0x000fc40007ffe0ffULL,
0x000000301c1a7810ULL, 0x040fe40007ffe0ffULL, 0x000000381c1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000012197faeULL, 0x0005e2000c901c46ULL, 0x000000ffff117224ULL, 0x002fe200000e06ffULL,
0x00005e001e1d7a11ULL, 0x000fe400078c48ffULL, 0x000000241f107210ULL, 0x000fe20007fbe0ffULL,
0x00000000141b7faeULL, 0x0003e2000d101c46ULL, 0xfffffffc26027812ULL, 0x000fe400078ee20bULL,
0x000000091600720cULL, 0x000fc40003f66070ULL, 0x000000091800720cULL, 0x080fe40003f46070ULL,
0x000000091a00720cULL, 0x080fe20003f26070ULL, 0x0000000121127824ULL, 0x044fe200078e021aULL,
0x000000091c00720cULL, 0x000fe20003f06070ULL, 0x0000001002097824ULL, 0x000fe200078e020dULL,
0x00005f001e1e7a11ULL, 0x000fe200030f4c11ULL, 0x000000ffff117224ULL, 0x000fe400028e0620ULL,
0x0000000121027824ULL, 0x040fe400078e0218ULL, 0x0000000121137824ULL, 0x000fe200078e021cULL,
0x0000000010097faeULL, 0x0005e2000e101c46ULL, 0x0000001223157210ULL, 0x042fe20007f9e0ffULL,
0x0000000418127824ULL, 0x000fe200078e00ffULL, 0x00000002231b7210ULL, 0x040fe20007fbe0ffULL,
0x0000000416027824ULL, 0x000fe200078e00ffULL, 0x0000001323137210ULL, 0x000fe20007fde0ffULL,
0x000000041a147824ULL, 0x000fe200078e00ffULL, 0xfffffffc12127812ULL, 0x100fe200078ee20bULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc02027812ULL, 0x100fe200078ee20bULL,
0x000000ffff1a7224ULL, 0x000fe200028e06ffULL, 0xfffffffc14147812ULL, 0x100fe200078ee20bULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0xfffffffc1c107812ULL, 0x004fe200078ee20bULL,
0x0000001002097824ULL, 0x100fe200078e020dULL, 0x00005e001b177a11ULL, 0x000fe200078a48ffULL,
0x00000010120b7824ULL, 0x000fc400078e020dULL, 0x0000001014197824ULL, 0x100fe200078e020dULL,
0x00005f001b1a7a11ULL, 0x000fe200028f4c1aULL, 0x00000010100d7824ULL, 0x000fe200078e020dULL,
0x000000241d107210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff027224ULL, 0x000fe200030e06ffULL,
0x00005e0015147a11ULL, 0x000fe400078848ffULL, 0x00005e0013167a11ULL, 0x000fe200078c48ffULL,
0x000000ffff117224ULL, 0x000fe200028e061eULL, 0x0000002417127210ULL, 0x000fe40007fbe0ffULL,
0x00005f0015157a11ULL, 0x000fc400020f4c18ULL, 0x00005f0013027a11ULL, 0x000fe200030f4c02ULL,
0x000000ffff137224ULL, 0x000fe200028e061aULL, 0x0000002414147210ULL, 0x080fe20007f9e0ffULL,
0x0000000010097faeULL, 0x0003e2000d901c46ULL, 0x0000002416167210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200020e0615ULL, 0x00000000120b7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff177224ULL, 0x000fc600028e0602ULL, 0x0000000014197faeULL, 0x0003e8000c901c46ULL,
0x00000000160d7faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000002102097211ULL, 0x042fe400078ff0ffULL, 0x0000001802107811ULL, 0x040fe400078ff0ffULL,
0x0000000923097210ULL, 0x000fe40007f1e0ffULL, 0x0000002802157811ULL, 0x040fe200078ff0ffULL,
0x0000000121117824ULL, 0x000fe200078e0210ULL, 0x0000002002137811ULL, 0x040fe200078ff0ffULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x0000003002177811ULL, 0x040fe200078ff0ffULL,
0x00000004152e7824ULL, 0x000fe200078e00ffULL, 0x00000002021b7211ULL, 0x040fe200078fe8ffULL,
0x0000000121147824ULL, 0x000fe200078e0213ULL, 0x00005e00092b7a11ULL, 0x000fe200078048ffULL,
0x0000000417307824ULL, 0x000fe200078e00ffULL, 0x00000008021e7811ULL, 0x040fe200078ff0ffULL,
0x0000000121167824ULL, 0x040fe200078e0215ULL, 0x00000010020b7811ULL, 0x040fe200078ff0ffULL,
0x0000000121187824ULL, 0x000fe200078e0217ULL, 0x0000003802197811ULL, 0x000fe200078ff0ffULL,
0x0000000413287824ULL, 0x000fe200078e00ffULL, 0x000000031b1b7812ULL, 0x000fe200078ec0ffULL,
0x00000001210d7824ULL, 0x000fe200078e020bULL, 0x00005f00092c7a11ULL, 0x000fe200000f4c2cULL,
0x0000000121097824ULL, 0x000fe200078e021eULL, 0x0000001123247210ULL, 0x000fe20007f1e0ffULL,
0x00000001211a7824ULL, 0x000fe200078e0219ULL, 0x00002000001c7811ULL, 0x000fe200078e68ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0xfffffffc2e117812ULL, 0x100fe200078ee21bULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0x0000001423207210ULL, 0x000fe20007f3e0ffULL,
0x000000040b147824ULL, 0x000fe200078e00ffULL, 0xfffffffc30137812ULL, 0x000fe200078ee21bULL,
0x0000000419327824ULL, 0x000fe200078e00ffULL, 0x0000000923097210ULL, 0x000fc40007fde0ffULL,
0x0000000d23267210ULL, 0x000fe20007fbe0ffULL, 0x0000001013257824ULL, 0x100fe200078e021cULL,
0x0000001623167210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x0000001823187210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200030e06ffULL,
0x0000001a231a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001011237824ULL, 0x000fe200078e021cULL,
0x0ffffffc1b157812ULL, 0x000fe200078ef802ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0xfffffffc100d7812ULL, 0x100fe200078ee21bULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0xfffffffc140b7812ULL, 0x100fe200078ee21bULL, 0x00000010152d7824ULL, 0x100fe200078e021cULL,
0xfffffffc28107812ULL, 0x100fe200078ee21bULL, 0x000000ffff1f7224ULL, 0x000fe200010e06ffULL,
0x00005e0020197a11ULL, 0x000fe200078248ffULL, 0x000000100b0b7824ULL, 0x100fe200078e021cULL,
0xfffffffc1e027812ULL, 0x100fe200078ee21bULL, 0x0000001010217824ULL, 0x100fe200078e021cULL,
0xfffffffc32147812ULL, 0x000fe200078ee21bULL, 0x000000ffff1b7224ULL, 0x000fe200028e06ffULL,
0x00005e0024177a11ULL, 0x000fe200078048ffULL, 0x000000100d0d7824ULL, 0x100fe200078e021cULL,
0x00000030122e7812ULL, 0x000fe200078ec0ffULL, 0x0000001014297824ULL, 0x000fe200078e021cULL,
0x00005e0009287a11ULL, 0x000fc400078c48ffULL, 0x00005e0026157a11ULL, 0x000fe400078a48ffULL,
0x00005f0020207a11ULL, 0x000fe200008f4c11ULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x00005f0024247a11ULL, 0x000fe400000f4c13ULL, 0x00005e001a1e7a11ULL, 0x000fe400078648ffULL,
0x0000002b2e107210ULL, 0x000fe40007f1e0ffULL, 0x00005f00092a7a11ULL, 0x000fe200030f4c2aULL,
0x0000001002097824ULL, 0x000fe200078e021cULL, 0x00005f0026267a11ULL, 0x000fc400028f4c1bULL,
0x00005e00161b7a11ULL, 0x000fe400078248ffULL, 0x00005e00181c7a11ULL, 0x000fe400078448ffULL,
0x00005f001a027a11ULL, 0x000fe200018f4c11ULL, 0x000000ffff117224ULL, 0x000fe200000e062cULL,
0x00005f00161f7a11ULL, 0x000fe400008f4c1fULL, 0x000000282e127210ULL, 0x000fe40007f1e0ffULL,
0x00005f00181d7a11ULL, 0x000fe200010f4c1dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102d7faeULL, 0x0003e2000b901c46ULL, 0x000000152e147210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e062aULL, 0x000000172e167210ULL, 0x000fc40007f5e0ffULL,
0x000000192e187210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0626ULL,
0x0000001b2e1a7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0624ULL,
0x0000001c2e1c7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200018e0620ULL,
0x0000001e2e1e7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e061fULL,
0x0000000012097faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1d7224ULL, 0x000fe400028e061dULL,
0x000000ffff1f7224ULL, 0x000fe200000e0602ULL, 0x00000000140b7faeULL, 0x0003e8000b901c46ULL,
0x00000000160d7faeULL, 0x0003e8000b901c46ULL, 0x0000000018217faeULL, 0x0003e8000b901c46ULL,
0x000000001a237faeULL, 0x0003e8000b901c46ULL, 0x000000001c257faeULL, 0x0003e8000b901c46ULL,
0x000000001e297faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000107805ULL, 0x002fc40000015200ULL, 0x01460400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210097210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e11ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011412ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0612ULL, 0x0000000202027819ULL, 0x000fc80000001209ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01460400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000060300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000287919ULL, 0x000e620000000000ULL,
0x0000640027277a24ULL, 0x000fe200078e02ffULL, 0x0001468800257811ULL, 0x040fe200078e18ffULL,
0x0000002000247824ULL, 0x000fe200078e00ffULL, 0xffffffff06267810ULL, 0x000fc40007ffe0ffULL,
0x0000010003237824ULL, 0x000fe200078e020aULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000230400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x0000000103097810ULL, 0x000fe20007ffe0ffULL, 0x0000002207227224ULL, 0x000fe200078e02ffULL,
0x0000004023217812ULL, 0x000fe400078ec0ffULL, 0x000000060900720cULL, 0x000fc60003f06070ULL,
0x0000000108217824ULL, 0x000fd400078e0221ULL, 0x000006a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff197819ULL, 0x002fe40000011628ULL, 0x0ffffffc28297812ULL, 0x000fe400078ec0ffULL,
0x00000020192f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000119097824ULL, 0x140fe200078e0221ULL,
0x00000008191b7810ULL, 0x040fe40007ffe0ffULL, 0x00000010192b7810ULL, 0x000fe20007ffe0ffULL,
0x000000012f117824ULL, 0x100fe200078e0221ULL, 0x0000000922097210ULL, 0x040fe20007f3e0ffULL,
0x000000041b1f7824ULL, 0x000fe200078e00ffULL, 0x00000018192d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b0b7824ULL, 0x100fe200078e0221ULL, 0x0000003819327810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e00090e7a11ULL, 0x000fe200078248ffULL,
0x000000012d0d7824ULL, 0x100fe200078e0221ULL, 0x0000000b220b7210ULL, 0x000fe20007f7e0ffULL,
0x00000001321d7824ULL, 0x100fe200078e0221ULL, 0x00005f00090f7a11ULL, 0x000fe200008f4c02ULL,
0x000000011b097824ULL, 0x000fe200078e0221ULL, 0x0000001122027210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x0000000d220d7210ULL, 0x000fc40007f9e0ffULL,
0x0000000922137210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e0002167a11ULL, 0x040fe200078248ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x00005e000b127a11ULL, 0x000fe200078648ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x00005f0002177a11ULL, 0x000fe200008f4c09ULL, 0x0000000104027824ULL, 0x000fe200078e0a23ULL,
0x0000002828097211ULL, 0x000fe400078fe8ffULL, 0x00005e0013107a11ULL, 0x000fc400078448ffULL,
0x00005e000d147a11ULL, 0x000fe400078848ffULL, 0x00000003092e7812ULL, 0x000fe400078ec0ffULL,
0x00005f0013117a11ULL, 0x000fe400010f4c1cULL, 0x00005f000b137a11ULL, 0x000fe400018f4c1aULL,
0x00005f000d157a11ULL, 0x000fe400020f4c18ULL, 0x0000003019317810ULL, 0x000fc40007ffe0ffULL,
0x00003000000b7811ULL, 0x000fe400078e68ffULL, 0x000000292e187212ULL, 0x000fe400078efcffULL,
0x0000000328207812ULL, 0x000fe400078ec0ffULL, 0x0000002819307810ULL, 0x040fe20007ffe0ffULL,
0x00000010180d7824ULL, 0x000fe200078e020bULL, 0x000000021900720cULL, 0x080fe40003f46070ULL,
0x000000021b00720cULL, 0x000fe20003f26070ULL, 0x00000001311b7824ULL, 0x100fe200078e0221ULL,
0x0000000420097812ULL, 0x000fe200078efcffULL, 0x0000000130197824ULL, 0x000fe200078e0221ULL,
0xfffffffc1f187812ULL, 0x000fc400078ee22eULL, 0x0000001d221d7210ULL, 0x040fe20007f7e0ffULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x0000001b221b7210ULL, 0x040fe40007fbe0ffULL,
0x0000001922197210ULL, 0x000fe20007f9e0ffULL, 0x00000010181f7824ULL, 0x000fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078648ffULL,
0x0000001009107825ULL, 0x000fe200078e0010ULL, 0x000000022d00720cULL, 0x000fc40003f46070ULL,
0x00005f001d1d7a11ULL, 0x000fe200018f4c1eULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078a48ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00000000101f7faeULL, 0x0005e2000c901c46ULL, 0x00005e0019187a11ULL, 0x000fe200078848ffULL,
0x000000042d2d7824ULL, 0x000fe200078e00ffULL, 0x000000022b00720cULL, 0x0c0fe20003f26070ULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0x000000022f00720cULL, 0x0c0fe20003f66070ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0x00005f001b1b7a11ULL, 0x000fe200028f4c2aULL,
0x00000004300d7824ULL, 0x002fe200078e00ffULL, 0x000000023100720cULL, 0x0c0fe20003fa6070ULL,
0x0000000431317824ULL, 0x000fe200078e00ffULL, 0x00005f0019197a11ULL, 0x000fe200020f4c2cULL,
0x00000004320f7824ULL, 0x000fe200078e00ffULL, 0x000000023000720cULL, 0x000fc40003f86070ULL,
0x000000023200720cULL, 0x000fe40003fc6070ULL, 0xfffffffc2d0e7812ULL, 0x100fe400078ee22eULL,
0xfffffffc2b027812ULL, 0x100fe400078ee22eULL, 0xfffffffc2f107812ULL, 0x104fe200078ee22eULL,
0x000000100e1f7824ULL, 0x100fe200078e020bULL, 0xfffffffc0d1e7812ULL, 0x100fe200078ee22eULL,
0x00000010020d7824ULL, 0x100fe200078e020bULL, 0xfffffffc312a7812ULL, 0x100fe200078ee22eULL,
0x00000010102b7824ULL, 0x000fe200078e020bULL, 0xfffffffc0f2e7812ULL, 0x000fe200078ee22eULL,
0x00000010090e7825ULL, 0x000fc800078e0012ULL, 0x0000001009107825ULL, 0x040fe200078e0014ULL,
0x000000000e0d7faeULL, 0x0003e6000c901c46ULL, 0x0000001009127825ULL, 0x040fe200078e0016ULL,
0x00000000101f7faeULL, 0x0003e6000d101c46ULL, 0x000000101e2d7824ULL, 0x000fe200078e020bULL,
0x00000000122b7faeULL, 0x0003e2000d901c46ULL, 0x0000001009147825ULL, 0x000fc800078e0018ULL,
0x000000102a2f7824ULL, 0x000fe200078e020bULL, 0x00000000142d7faeULL, 0x0003e2000e101c46ULL,
0x0000001009167825ULL, 0x000fc800078e001aULL, 0x000000102e0b7824ULL, 0x000fe200078e020bULL,
0x00000000162f7faeULL, 0x0003e2000e901c46ULL, 0x0000001009187825ULL, 0x000fca00078e001cULL,
0x00000000180b7faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000002128097211ULL, 0x042fe400078ff0ffULL, 0x0000001028127811ULL, 0x000fe400078ff0ffULL,
0x0000000922097210ULL, 0x000fe40007f3e0ffULL, 0x0000001828147811ULL, 0x000fe200078ff0ffULL,
0x0000000412137824ULL, 0x000fe200078e00ffULL, 0x00000028280b7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e00090e7a11ULL, 0x000fe200078248ffULL,
0x0000000414157824ULL, 0x000fe200078e00ffULL, 0x0000000828107811ULL, 0x000fe200078ff0ffULL,
0x00000001140d7824ULL, 0x000fe200078e0221ULL, 0x00000020281a7811ULL, 0x000fc400078ff0ffULL,
0x00000028281c7811ULL, 0x000fe200078ff0ffULL, 0x0000000410117824ULL, 0x000fe200078e00ffULL,
0x00000030282a7811ULL, 0x000fe200078ff0ffULL, 0x000000041a177824ULL, 0x000fe200078e00ffULL,
0x00000038282c7811ULL, 0x000fe200078ff0ffULL, 0x000000041c197824ULL, 0x000fe200078e00ffULL,
0x00005f00090f7a11ULL, 0x000fe200008f4c02ULL, 0x000000042a1b7824ULL, 0x000fe200078e00ffULL,
0x000000030b027812ULL, 0x000fe200078ec0ffULL, 0x00000001120b7824ULL, 0x100fe200078e0221ULL,
0x0ffffffc28297812ULL, 0x000fe200078ec0ffULL, 0x000000042c1d7824ULL, 0x000fe200078e00ffULL,
0x00003000002f7811ULL, 0x000fe200078e68ffULL, 0x0000000110097824ULL, 0x000fe200078e0221ULL,
0xfffffffc13147812ULL, 0x000fc400078ee202ULL, 0xfffffffc15167812ULL, 0x100fe400078ee202ULL,
0xfffffffc11127812ULL, 0x100fe400078ee202ULL, 0xfffffffc17187812ULL, 0x100fe200078ee202ULL,
0x000000011a177824ULL, 0x100fe200078e0221ULL, 0xfffffffc191e7812ULL, 0x100fe200078ee202ULL,
0x000000011c197824ULL, 0x000fe200078e0221ULL, 0xfffffffc1b207812ULL, 0x100fe200078ee202ULL,
0x00000010181f7824ULL, 0x000fe200078e022fULL, 0xfffffffc1d2e7812ULL, 0x000fe200078ee202ULL,
0x000000012a1b7824ULL, 0x100fe200078e0221ULL, 0x0000002902107212ULL, 0x000fe200078efcffULL,
0x000000012c1d7824ULL, 0x000fe200078e0221ULL, 0x0000000b22137210ULL, 0x000fe20007f5e0ffULL,
0x00000010140b7824ULL, 0x100fe200078e022fULL, 0x0000000d22027210ULL, 0x000fe20007f7e0ffULL,
0x00000010160d7824ULL, 0x100fe200078e022fULL, 0x0000000922117210ULL, 0x000fe20007f3e0ffULL,
0x0000001012097824ULL, 0x100fe200078e022fULL, 0x0000001b221b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x00005e0013127a11ULL, 0x040fe200078448ffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x00005e0002147a11ULL, 0x000fe200078648ffULL,
0x0000001010337824ULL, 0x100fe200078e022fULL, 0x00005f0013137a11ULL, 0x000fe200010f4c16ULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x00005e0011107a11ULL, 0x040fe200078248ffULL,
0x00000010202d7824ULL, 0x000fe200078e022fULL, 0x00005f0002157a11ULL, 0x000fe200018f4c15ULL,
0x000000101e2b7824ULL, 0x100fe200078e022fULL, 0x0000001722177210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x0000001922197210ULL, 0x000fe20007f7e0ffULL,
0x000000102e2f7824ULL, 0x000fe200078e022fULL, 0x00005f0011117a11ULL, 0x000fe200008f4c18ULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x0000000328207812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x0000001d221d7210ULL, 0x000fc40007f3e0ffULL,
0x0000000420317812ULL, 0x000fe400078efcffULL, 0x00005e0017167a11ULL, 0x000fe200078448ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e0019187a11ULL, 0x000fe200078648ffULL,
0x00000010310e7825ULL, 0x000fe200078e000eULL, 0x00005e001b1a7a11ULL, 0x000fe400078848ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078248ffULL, 0x0000001031107825ULL, 0x000fe200078e0010ULL,
0x00005f0017177a11ULL, 0x000fe200010f4c2cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e337faeULL, 0x0003e2000b901c46ULL, 0x00005f0019197a11ULL, 0x000fe200018f4c2aULL,
0x0000001031127825ULL, 0x000fe200078e0012ULL, 0x00005f001b1b7a11ULL, 0x000fe200020f4c1eULL,
0x0000000010097faeULL, 0x0003e2000b901c46ULL, 0x00005f001d1d7a11ULL, 0x000fe200008f4c02ULL,
0x0000001031147825ULL, 0x000fc400078e0014ULL, 0x00000000120b7faeULL, 0x0003e4000b901c46ULL,
0x0000001031167825ULL, 0x040fe400078e0016ULL, 0x00000000140d7faeULL, 0x0003e4000b901c46ULL,
0x0000001031187825ULL, 0x040fe400078e0018ULL, 0x00000000161f7faeULL, 0x0003e4000b901c46ULL,
0x00000010311a7825ULL, 0x000fc400078e001aULL, 0x00000000182b7faeULL, 0x0003e4000b901c46ULL,
0x00000010311c7825ULL, 0x000fe400078e001cULL, 0x000000001a2d7faeULL, 0x0003e8000b901c46ULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x00000004ff1e7819ULL, 0x100fe20000011628ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000007281f7812ULL, 0x002fe200078ec0ffULL,
0x00002000000f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff417819ULL, 0x000fe20000011628ULL,
0x000000081e0e7824ULL, 0x000fc600078e00ffULL, 0x0000000141097812ULL, 0x000fe400078ec0ffULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee21fULL, 0x000000081f1f7812ULL, 0x000fe400078ef828ULL,
0x000000200e167810ULL, 0x040fe20007ffe0ffULL, 0x000000040e2a7824ULL, 0x040fe200078e00ffULL,
0x000000100e147810ULL, 0x040fe20007ffe0ffULL, 0x000000011f1e7824ULL, 0x040fe200078e021eULL,
0x000000300e187810ULL, 0x000fe20007ffe0ffULL, 0x000000201f0b7824ULL, 0x000fe200078e00ffULL,
0x00000009140d7211ULL, 0x080fe200078ff8ffULL, 0x000000040e367824ULL, 0x000fe200078e00ffULL,
0x0000000916157211ULL, 0x080fe200078ff8ffULL, 0x0000000414407824ULL, 0x000fe200078e00ffULL,
0xffffffe00b027812ULL, 0x000fe200078ee21eULL, 0x0000000418107824ULL, 0x000fe200078e00ffULL,
0x000000090e0b7211ULL, 0x080fe200078ff8ffULL, 0x00000004160e7824ULL, 0x000fe200078e00ffULL,
0x0000000918097211ULL, 0x000fe200078ff8ffULL, 0x0000001002027824ULL, 0x000fe200078e00ffULL,
0x000020000f1d7810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffffc0e2b7812ULL, 0x000fe200078ee215ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0xfffffffc2a2a7812ULL, 0x000fe200078ee20bULL, 0x0000000414357824ULL, 0x000fe200078e00ffULL,
0xfffffffc40407812ULL, 0x000fe200078ee20dULL, 0x000000102b1a7824ULL, 0x000fe200078e021dULL,
0xfffffffc100e7812ULL, 0x000fe200078ee209ULL, 0x000000102a1c7824ULL, 0x100fe200078e021dULL,
0x000000000210783bULL, 0x0003e20000000200ULL, 0x00000010401b7824ULL, 0x100fe200078e021dULL,
0x000000020b0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000100e197824ULL, 0x000fe200078e021dULL,
0x000000001a30783bULL, 0x000ea20000000200ULL, 0x000000020d147810ULL, 0x000fe20007ffe0ffULL,
0x000000201f347824ULL, 0x000fe200078e00ffULL, 0xfffffffc360d7812ULL, 0x000fe200078ee20bULL,
0x000000001c3c783bULL, 0x000ee20000000200ULL, 0x000000021e177810ULL, 0x000fe20007ffe0ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0xfffffffc350b7812ULL, 0x000fe200078ee214ULL,
0x000000001b38783bULL, 0x000f220000000200ULL, 0x0000000215157810ULL, 0x000fe20007ffe0ffULL,
0x0000000418357824ULL, 0x000fe200078e00ffULL, 0x0000000209027810ULL, 0x002fe20007ffe0ffULL,
0x00000000192c783bULL, 0x000e620000000200ULL, 0xffffffe034177812ULL, 0x000fe200078ee217ULL,
0x000000100d187824ULL, 0x000fe200078e021dULL, 0xfffffffc16097812ULL, 0x000fc400078ee215ULL,
0xfffffffc35027812ULL, 0x000fe200078ee202ULL, 0x0000001017487824ULL, 0x000fe200078e00ffULL,
0x00000000184c783bULL, 0x000fe20000000200ULL, 0x0000001009167824ULL, 0x100fe400078e021dULL,
0x000000100b177824ULL, 0x100fe400078e021dULL, 0x0000001002157824ULL, 0x000fe200078e021dULL,
0x000000004848783bULL, 0x000fe80000000200ULL, 0x000000001654783bULL, 0x000e680000000200ULL,
0x000000001750783bULL, 0x000e680000000200ULL, 0x000000001534783bULL, 0x000e620000000200ULL,
0x000000301058723cULL, 0x044f7000000018ffULL, 0x0000003c105c723cULL, 0x048f7000000018ffULL,
0x0000003e1068723cULL, 0x040f7000000018ffULL, 0x000000381064723cULL, 0x050f7000000018ffULL,
0x0000003a1060723cULL, 0x040f7000000018ffULL, 0x000000321030723cULL, 0x040f7000000018ffULL,
0x0000002c1044723cULL, 0x042f7000000018ffULL, 0x0000002e1010723cULL, 0x000f7000000018ffULL,
0x000000544858723cULL, 0x060b700000001858ULL, 0x0000004c485c723cULL, 0x040b70000000185cULL,
0x0000004e4868723cULL, 0x040b700000001868ULL, 0x000000504864723cULL, 0x040b700000001864ULL,
0x000000524860723cULL, 0x040b700000001860ULL, 0x000000564854723cULL, 0x040b700000001830ULL,
0x000000344844723cULL, 0x040b700000001844ULL, 0x000000364848723cULL, 0x000b620000001810ULL,
0x0000067000008947ULL, 0x000fce0003800000ULL, 0x00000002ff127819ULL, 0x020fe20000011628ULL,
0x00000001043a7824ULL, 0x000fe200078e0a23ULL, 0x00000008203b7812ULL, 0x000fc400078efcffULL,
0x0000000812137810ULL, 0x040fe20007ffe0ffULL, 0x0000000112117824ULL, 0x140fe200078e0221ULL,
0x00000010123c7810ULL, 0x040fe40007ffe0ffULL, 0x00000018123e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001132d7824ULL, 0x100fe200078e0221ULL, 0x0000001122117210ULL, 0x000fe20007f3e0ffULL,
0x000000013c2f7824ULL, 0x100fe200078e0221ULL, 0x0000002012427810ULL, 0x000fe20007ffe0ffULL,
0x000000013e317824ULL, 0x100fe200078e0221ULL, 0x0000002d222d7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x00005e0011107a11ULL, 0x040fe200078248ffULL,
0x0000000142337824ULL, 0x000fe200078e0221ULL, 0x0000002f222f7210ULL, 0x000fe20007f7e0ffULL,
0x000000043c3f7824ULL, 0x000fe200078e00ffULL, 0x00005f0011117a11ULL, 0x000fe200008f4c14ULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078248ffULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078448ffULL,
0x000000103b107825ULL, 0x000fe200078e0010ULL, 0x00005f002d2d7a11ULL, 0x000fc400008f4c14ULL,
0x0000003122317210ULL, 0x000fe40007f3e0ffULL, 0x0000002812437810ULL, 0x040fe20007ffe0ffULL,
0x000000103b2c7825ULL, 0x000fe200078e002cULL, 0x00000030124c7810ULL, 0x000fe40007ffe0ffULL,
0x00005f002f2f7a11ULL, 0x000fe200010f4c30ULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x0000003322337210ULL, 0x000fe20007f5e0ffULL, 0x0000000143357824ULL, 0x100fe200078e0221ULL,
0x00005e0031307a11ULL, 0x000fe200078248ffULL, 0x000000014c377824ULL, 0x000fe200078e0221ULL,
0x0000003a4300720cULL, 0x000fe20003f86070ULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005f0031317a11ULL, 0x000fe200008f4c14ULL, 0x0000000141147824ULL, 0x000fe200078e0228ULL,
0x0000003522357210ULL, 0x000fe20007f3e0ffULL, 0x0000000443437824ULL, 0x000fe200078e00ffULL,
0x00005e0033327a11ULL, 0x000fc400078448ffULL, 0x0000003722377210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x0000003812417810ULL, 0x000fe40007ffe0ffULL,
0x00005f0033337a11ULL, 0x000fe200010f4c34ULL, 0x000000ffff4e7224ULL, 0x000fe200018e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078448ffULL, 0x0000000141397824ULL, 0x000fe200078e0221ULL,
0x00005e0037367a11ULL, 0x000fe400078648ffULL, 0x00005f0035357a11ULL, 0x000fc400010f4c38ULL,
0x0000000314147812ULL, 0x000fe400078ec0ffULL, 0x0000003a1200720cULL, 0x080fe40003f26070ULL,
0x0000003a1300720cULL, 0x040fe20003f46070ULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x00005f0037377a11ULL, 0x000fe400018f4c4eULL, 0x0000002914297212ULL, 0x000fe400078efcffULL,
0x0000003922397210ULL, 0x000fc40007f7e0ffULL, 0xfffffffc13127812ULL, 0x000fe200078ee214ULL,
0x0000001029137824ULL, 0x100fe200078e021dULL, 0x0000003a4100720cULL, 0x080fe20003fc6070ULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078648ffULL,
0x00000010123d7824ULL, 0x000fe200078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000c901c46ULL, 0x0000003a3c00720cULL, 0x000fe20003f26070ULL,
0x0000000441417824ULL, 0x000fe200078e00ffULL, 0x00005f0039397a11ULL, 0x000fe200018f4c4eULL,
0x000000002c3d7faeULL, 0x0005e2000d101c46ULL, 0xfffffffc3f127812ULL, 0x000fc400078ee214ULL,
0x0000003a3e00720cULL, 0x080fe40003f46070ULL, 0x0000003a4200720cULL, 0x080fe20003f66070ULL,
0x00000010123f7824ULL, 0x000fe200078e021dULL, 0x0000003a4c00720cULL, 0x000fe20003fa6070ULL,
0x000000103b107825ULL, 0x002fe200078e002eULL, 0xfffffffc413c7812ULL, 0x000fc600078ee214ULL,
0x000000103b2e7825ULL, 0x040fe200078e0030ULL, 0x00000000103f7faeULL, 0x0003e6000c901c46ULL,
0x000000103b307825ULL, 0x000fc800078e0032ULL, 0x000000103b2c7825ULL, 0x004fc800078e0034ULL,
0x000000103b327825ULL, 0x000fc800078e0036ULL, 0x000000103b347825ULL, 0x000fe200078e0038ULL,
0xfffffffc43387812ULL, 0x000fc600078ee214ULL, 0x000000043e377824ULL, 0x000fe400078e00ffULL,
0x0000000442397824ULL, 0x000fe400078e00ffULL, 0x000000044c3b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc37127812ULL, 0x100fe200078ee214ULL, 0x000000103c3d7824ULL, 0x100fe200078e021dULL,
0xfffffffc39367812ULL, 0x100fe200078ee214ULL, 0x0000001038397824ULL, 0x100fe200078e021dULL,
0xfffffffc3b3a7812ULL, 0x000fe200078ee214ULL, 0x0000001012117824ULL, 0x002fc400078e021dULL,
0x0000001036377824ULL, 0x100fe400078e021dULL, 0x000000103a3b7824ULL, 0x000fe200078e021dULL,
0x000000002e117faeULL, 0x0003e8000d101c46ULL, 0x0000000030377faeULL, 0x0003e8000d901c46ULL,
0x000000002c397faeULL, 0x0003e8000e101c46ULL, 0x00000000323b7faeULL, 0x0003e8000e901c46ULL,
0x00000000343d7faeULL, 0x0003e2000f101c46ULL, 0x000005c000007947ULL, 0x000fea0003800000ULL,
0x0000000828367811ULL, 0x060fe400078ff0ffULL, 0x0000002128117211ULL, 0x000fc400078ff0ffULL,
0x0000002828427811ULL, 0x000fe200078ff0ffULL, 0x0000000136137824ULL, 0x100fe200078e0221ULL,
0x0000001122117210ULL, 0x000fe20007f3e0ffULL, 0x00000004363b7824ULL, 0x000fe200078e00ffULL,
0x00000018283c7811ULL, 0x000fe200078ff0ffULL, 0x0000000142357824ULL, 0x100fe200078e0221ULL,
0x0000001322137210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00005e0011107a11ULL, 0x040fe200078248ffULL, 0x000000013c2f7824ULL, 0x000fe200078e0221ULL,
0x00000020283e7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00005f0011117a11ULL, 0x000fc400008f4c12ULL, 0x00005e00132c7a11ULL, 0x040fe200078448ffULL,
0x000000013e337824ULL, 0x100fe200078e0221ULL, 0x0000001028127811ULL, 0x000fe400078ff0ffULL,
0x00005f00132d7a11ULL, 0x000fe400010f4c14ULL, 0x0000003522357210ULL, 0x000fe20007f3e0ffULL,
0x0000000112137824ULL, 0x100fe200078e0221ULL, 0x00000038284e7811ULL, 0x000fe200078ff0ffULL,
0x00000004123d7824ULL, 0x000fe200078e00ffULL, 0x0000002f22317210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200008e06ffULL, 0x0000001322137210ULL, 0x000fe20007f5e0ffULL,
0x000000014e397824ULL, 0x000fe200078e0221ULL, 0x00005e0035347a11ULL, 0x040fe200078248ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x0000003322337210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005f0035357a11ULL, 0x000fe200008f4c4cULL,
0x000000044e4d7824ULL, 0x000fe200078e00ffULL, 0x00005e00132e7a11ULL, 0x000fe200078448ffULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x00000030284c7811ULL, 0x000fc400078ff0ffULL,
0x00005f00132f7a11ULL, 0x000fe200010f4c14ULL, 0x0000000141147824ULL, 0x000fe200078e0228ULL,
0x0000003922397210ULL, 0x000fe20007f5e0ffULL, 0x000000014c137824ULL, 0x000fe200078e0221ULL,
0x00005e0031307a11ULL, 0x000fe200078648ffULL, 0x0000000442417824ULL, 0x000fe200078e00ffULL,
0x0000000314147812ULL, 0x000fe200078ec0ffULL, 0x000000ffff507224ULL, 0x000fe200010e06ffULL,
0x0000001322377210ULL, 0x000fe20007f3e0ffULL, 0x000000044c437824ULL, 0x000fe200078e00ffULL,
0x00000008203f7812ULL, 0x000fc400078efcffULL, 0x0000002914297212ULL, 0x000fe200078efcffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00005f0031317a11ULL, 0x000fe200018f4c38ULL,
0x000000103f107825ULL, 0x000fe200078e0010ULL, 0x00005e0033327a11ULL, 0x000fe400078848ffULL,
0x00005e0037367a11ULL, 0x000fe200078248ffULL, 0x0000001029137824ULL, 0x000fe200078e021dULL,
0x00005e0039387a11ULL, 0x000fe200078448ffULL, 0x000000103f2c7825ULL, 0x000fe200078e002cULL,
0x00005f0033337a11ULL, 0x000fc400020f4c3aULL, 0x00005f0037377a11ULL, 0x000fe200008f4c12ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000b901c46ULL,
0x00005f0039397a11ULL, 0x000fe200010f4c50ULL, 0x000000103f2e7825ULL, 0x000fe200078e002eULL,
0xfffffffc3b127812ULL, 0x100fe400078ee214ULL, 0xfffffffc3d3a7812ULL, 0x000fe200078ee214ULL,
0x000000103f307825ULL, 0x000fc800078e0030ULL, 0x000000103f327825ULL, 0x000fc800078e0032ULL,
0x000000103f347825ULL, 0x000fc800078e0034ULL, 0x000000103f367825ULL, 0x000fc800078e0036ULL,
0x000000103f387825ULL, 0x000fc800078e0038ULL, 0x000000043c117824ULL, 0x002fe200078e00ffULL,
0xfffffffc433c7812ULL, 0x100fe200078ee214ULL, 0x000000043e3f7824ULL, 0x000fe400078e00ffULL,
0x00000010123b7824ULL, 0x100fe200078e021dULL, 0xfffffffc11107812ULL, 0x100fe200078ee214ULL,
0x000000103a3d7824ULL, 0x100fe200078e021dULL, 0xfffffffc3f127812ULL, 0x100fe400078ee214ULL,
0xfffffffc413a7812ULL, 0x000fe200078ee214ULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001010117824ULL, 0x000fc600078e021dULL, 0x000000002e3d7faeULL, 0x0005e8000b901c46ULL,
0x0000000030117faeULL, 0x0007e2000b901c46ULL, 0xfffffffc4d2c7812ULL, 0x002fe200078ee214ULL,
0x00000010122d7824ULL, 0x100fe400078e021dULL, 0x000000103c3b7824ULL, 0x100fe400078e021dULL,
0x000000103a2f7824ULL, 0x104fe200078e021dULL, 0x00000000322d7faeULL, 0x0007e2000b901c46ULL,
0x000000102c3d7824ULL, 0x000fc600078e021dULL, 0x00000000342f7faeULL, 0x0007e8000b901c46ULL,
0x00000000363b7faeULL, 0x0007e8000b901c46ULL, 0x00000000383d7faeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000201f117824ULL, 0x00afe200078e00ffULL,
0x000000041e107810ULL, 0x000fc40007ffe0ffULL, 0x000030000f127810ULL, 0x000fe40007ffe0ffULL,
0xffffffe011107812ULL, 0x000fc600078ee210ULL, 0x000000102a117824ULL, 0x100fe200078e0212ULL,
0x000000061e2a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010104c7824ULL, 0x000fe400078e00ffULL,
0x0000001040107824ULL, 0x100fe400078e0212ULL, 0x000000102b0f7824ULL, 0x100fe400078e0212ULL,
0x000000100e0e7824ULL, 0x000fe400078e0212ULL, 0x000000201f2b7824ULL, 0x000fc400078e00ffULL,
0x000000100d0d7824ULL, 0x100fe400078e0212ULL, 0x0000001009097824ULL, 0x000fe200078e0212ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001170783bULL, 0x000fe20000000200ULL,
0xffffffe02b2a7812ULL, 0x000fe200078ee22aULL, 0x000000100b0b7824ULL, 0x100fe400078e0212ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x0000001002027824ULL, 0x000fe400078e0212ULL,
0x000000102a2a7824ULL, 0x000fe200078e00ffULL, 0x00000000106c783bULL, 0x000ea80000000200ULL,
0x000000000f40783bULL, 0x000ee80000000200ULL, 0x000000000e50783bULL, 0x000f280000000200ULL,
0x000000000d3c783bULL, 0x000fe80000000200ULL, 0x000000002a2c783bULL, 0x000ee80000000200ULL,
0x000000000934783bULL, 0x000ee80000000200ULL, 0x000000000b38783bULL, 0x000ee80000000200ULL,
0x000000000230783bULL, 0x000ee20000000200ULL, 0x000000704c5c723cULL, 0x042f70000000185cULL,
0x000000724c68723cULL, 0x040ff00000001868ULL, 0x0000006c4c64723cULL, 0x044ff00000001864ULL,
0x0000006e4c60723cULL, 0x040ff00000001860ULL, 0x000000424c54723cULL, 0x048f700000001854ULL,
0x000000404c58723cULL, 0x040f700000001858ULL, 0x000000504c6c723cULL, 0x050f700000001844ULL,
0x000000524c70723cULL, 0x000f700000001848ULL, 0x0000003c2c40723cULL, 0x060b70000000185cULL,
0x000000362c50723cULL, 0x040b700000001854ULL, 0x0000003e2c3c723cULL, 0x040b700000001868ULL,
0x000000382c44723cULL, 0x040b700000001864ULL, 0x0000003a2c48723cULL, 0x040b700000001860ULL,
0x000000342c4c723cULL, 0x040b700000001858ULL, 0x000000302c54723cULL, 0x040b70000000186cULL,
0x000000322c5c723cULL, 0x000b620000001870ULL, 0x0000064000008947ULL, 0x000fce0003800000ULL,
0x00000002ff327819ULL, 0x020fe20000011628ULL, 0x0000001029297824ULL, 0x000fe200078e0212ULL,
0x0000000c203b7812ULL, 0x000fc400078efcffULL, 0x00000018325a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001322b7824ULL, 0x140fe200078e0221ULL, 0x0000000832387810ULL, 0x040fe40007ffe0ffULL,
0x0000001032587810ULL, 0x000fe20007ffe0ffULL, 0x000000015a317824ULL, 0x100fe200078e0221ULL,
0x0000002b222b7210ULL, 0x000fe20007f5e0ffULL, 0x00000001382d7824ULL, 0x100fe200078e0221ULL,
0x0000002832617810ULL, 0x000fe20007ffe0ffULL, 0x00000001582f7824ULL, 0x100fe200078e0221ULL,
0x0000003122317210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x0000002d222d7210ULL, 0x040fe20007f7e0ffULL, 0x0000000161357824ULL, 0x000fe200078e0221ULL,
0x0000002f222f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff607224ULL, 0x000fe200008e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078248ffULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00005f0031317a11ULL, 0x000fe200008f4c60ULL, 0x0000000438597824ULL, 0x000fe200078e00ffULL,
0x0000002032607810ULL, 0x000fe20007ffe0ffULL, 0x00000004585b7824ULL, 0x000fe200078e00ffULL,
0x00005e002d2c7a11ULL, 0x000fc400078648ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078848ffULL,
0x0000000160337824ULL, 0x000fe200078e0221ULL, 0x00005f002b2b7a11ULL, 0x000fe400010f4c34ULL,
0x00005f002d2d7a11ULL, 0x000fe400018f4c36ULL, 0x00005f002f2f7a11ULL, 0x000fe200020f4c3aULL,
0x00000001043a7824ULL, 0x000fe200078e0a23ULL, 0x0000003032637810ULL, 0x000fe20007ffe0ffULL,
0x000000103b2a7825ULL, 0x000fe200078e002aULL, 0x0000003322337210ULL, 0x000fc40007f5e0ffULL,
0x0000003522357210ULL, 0x000fe20007f7e0ffULL, 0x0000000163377824ULL, 0x100fe200078e0221ULL,
0x0000003832657810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff627224ULL, 0x000fe200010e06ffULL,
0x0000003a3200720cULL, 0x000fe20003f26070ULL, 0x000000ffff647224ULL, 0x000fe200018e06ffULL,
0x00005e0033327a11ULL, 0x000fe200078448ffULL, 0x0000000165397824ULL, 0x000fe200078e0221ULL,
0x00005e0035347a11ULL, 0x000fe200078648ffULL, 0x000000103b2c7825ULL, 0x000fe200078e002cULL,
0x0000003722377210ULL, 0x000fc40007f9e0ffULL, 0x00005f0033337a11ULL, 0x000fe400010f4c62ULL,
0x00005f0035357a11ULL, 0x000fe200018f4c64ULL, 0x000000ffff667224ULL, 0x000fe200020e06ffULL,
0x0000003a3800720cULL, 0x000fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a297faeULL, 0x0003e2000c901c46ULL, 0x0000003922397210ULL, 0x000fe40007f7e0ffULL,
0xfffffffc59597812ULL, 0x000fe400078ee214ULL, 0x00005e0037367a11ULL, 0x000fe200078848ffULL,
0x000000ffff627224ULL, 0x000fe200018e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078648ffULL,
0x0000001059597824ULL, 0x000fe200078e0212ULL, 0x00005f0037377a11ULL, 0x000fc400020f4c66ULL,
0x00005f0039397a11ULL, 0x000fe200018f4c62ULL, 0x000000103b2a7825ULL, 0x002fe200078e002eULL,
0x0000003a5800720cULL, 0x080fe20003f26070ULL, 0x000000002c597faeULL, 0x0003e2000d101c46ULL,
0xfffffffc5b5b7812ULL, 0x000fe200078ee214ULL, 0x000000103b2e7825ULL, 0x040fe200078e0030ULL,
0x0000003a5a00720cULL, 0x080fe40003f46070ULL, 0x0000003a6000720cULL, 0x080fe20003f66070ULL,
0x000000103b307825ULL, 0x000fe200078e0032ULL, 0x0000003a6100720cULL, 0x000fc40003f86070ULL,
0x0000003a6300720cULL, 0x080fe20003fa6070ULL, 0x000000103b327825ULL, 0x000fe200078e0036ULL,
0x0000003a6500720cULL, 0x000fc60003fc6070ULL, 0x000000103b2c7825ULL, 0x002fc800078e0034ULL,
0x000000103b347825ULL, 0x000fc800078e0038ULL, 0x000000045a377824ULL, 0x000fe400078e00ffULL,
0x0000000460397824ULL, 0x000fe400078e00ffULL, 0x00000004613b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc37377812ULL, 0x100fe200078ee214ULL, 0x0000000463597824ULL, 0x000fe200078e00ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee214ULL, 0x000000105b5b7824ULL, 0x000fe200078e0212ULL,
0xfffffffc3b3b7812ULL, 0x100fe200078ee214ULL, 0x0000000465617824ULL, 0x000fe200078e00ffULL,
0xfffffffc59597812ULL, 0x000fc400078ee214ULL, 0x000000002a5b7faeULL, 0x0003e4000c901c46ULL,
0xfffffffc61617812ULL, 0x000fe200078ee214ULL, 0x00000010372b7824ULL, 0x102fe400078e0212ULL,
0x0000001039377824ULL, 0x100fe400078e0212ULL, 0x000000103b397824ULL, 0x100fe200078e0212ULL,
0x000000002e2b7faeULL, 0x0003e2000d101c46ULL, 0x00000010593b7824ULL, 0x100fe400078e0212ULL,
0x0000001061597824ULL, 0x000fe200078e0212ULL, 0x0000000030377faeULL, 0x0003e8000d901c46ULL,
0x000000002c397faeULL, 0x0003e8000e101c46ULL, 0x00000000323b7faeULL, 0x0003e8000e901c46ULL,
0x0000000034597faeULL, 0x0003e2000f101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000828367811ULL, 0x060fe200078ff0ffULL, 0x0000001029297824ULL, 0x000fe200078e0212ULL,
0x00000021282b7211ULL, 0x000fc400078ff0ffULL, 0x0000001028387811ULL, 0x000fe200078ff0ffULL,
0x00000001362d7824ULL, 0x100fe200078e0221ULL, 0x0000002b222b7210ULL, 0x000fe20007f3e0ffULL,
0x00000004363b7824ULL, 0x000fe200078e00ffULL, 0x00000018283a7811ULL, 0x000fe200078ff0ffULL,
0x00000001382f7824ULL, 0x100fe200078e0221ULL, 0x0000002d222d7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078248ffULL,
0x000000013a317824ULL, 0x100fe200078e0221ULL, 0x0000002028587811ULL, 0x000fe200078ff0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078448ffULL,
0x0000000438597824ULL, 0x000fe200078e00ffULL, 0x0000002828607811ULL, 0x000fe200078ff0ffULL,
0x0000000158337824ULL, 0x000fe200078e0221ULL, 0x00005f002b2b7a11ULL, 0x000fc400008f4c2eULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4c30ULL, 0x0000000160357824ULL, 0x000fe200078e0221ULL,
0x0000002f222f7210ULL, 0x000fe20007f3e0ffULL, 0x0000000460617824ULL, 0x000fe200078e00ffULL,
0x0000003122317210ULL, 0x040fe40007f5e0ffULL, 0x0000003322337210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x0000003522357210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078248ffULL,
0x000000ffff5a7224ULL, 0x000fe200018e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078448ffULL,
0x000000ffff627224ULL, 0x000fe200020e06ffULL, 0x0000003028647811ULL, 0x000fc400078ff0ffULL,
0x0000003828667811ULL, 0x000fe400078ff0ffULL, 0x00005f002f2f7a11ULL, 0x000fe200008f4c32ULL,
0x0000000164377824ULL, 0x100fe200078e0221ULL, 0x00005f0031317a11ULL, 0x000fe200010f4c34ULL,
0x0000000166397824ULL, 0x000fe200078e0221ULL, 0x00005e0033327a11ULL, 0x000fe200078248ffULL,
0x0000000464637824ULL, 0x000fe200078e00ffULL, 0x00005e0035347a11ULL, 0x000fe200078448ffULL,
0x0000000466657824ULL, 0x000fe200078e00ffULL, 0x00005f0033337a11ULL, 0x000fc400008f4c5aULL,
0x00005f0035357a11ULL, 0x000fe400010f4c62ULL, 0x0000003722377210ULL, 0x040fe40007f3e0ffULL,
0x0000003922397210ULL, 0x000fe40007f5e0ffULL, 0x0000000c205b7812ULL, 0x000fe200078efcffULL,
0x000000ffff5a7224ULL, 0x000fe200008e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078248ffULL,
0x000000ffff627224ULL, 0x000fe200010e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078448ffULL,
0x000000105b2a7825ULL, 0x000fe200078e002aULL, 0x00005f0037377a11ULL, 0x000fc400008f4c5aULL,
0x00005f0039397a11ULL, 0x000fe200010f4c62ULL, 0x000000105b2c7825ULL, 0x000fe200078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a297faeULL, 0x0003e2000b901c46ULL,
0xfffffffc3b3b7812ULL, 0x000fe400078ee214ULL, 0x000000105b2e7825ULL, 0x000fe200078e002eULL,
0xfffffffc59597812ULL, 0x100fe400078ee214ULL, 0xfffffffc61617812ULL, 0x000fe200078ee214ULL,
0x000000105b307825ULL, 0x000fe200078e0030ULL, 0xfffffffc63637812ULL, 0x000fc400078ee214ULL,
0xfffffffc65657812ULL, 0x000fe200078ee214ULL, 0x000000105b327825ULL, 0x000fc800078e0032ULL,
0x000000105b347825ULL, 0x000fc800078e0034ULL, 0x000000105b367825ULL, 0x000fc800078e0036ULL,
0x000000105b387825ULL, 0x000fc800078e0038ULL, 0x000000043a2b7824ULL, 0x002fe400078e00ffULL,
0x00000004585b7824ULL, 0x000fe400078e00ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0212ULL,
0xfffffffc2b2b7812ULL, 0x000fe200078ee214ULL, 0x0000001059597824ULL, 0x000fe200078e0212ULL,
0xfffffffc5b5b7812ULL, 0x000fe400078ee214ULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x000000102b2b7824ULL, 0x000fc600078e0212ULL, 0x000000002e597faeULL, 0x0005e8000b901c46ULL,
0x00000000302b7faeULL, 0x0007e2000b901c46ULL, 0x000000105b2d7824ULL, 0x102fe400078e0212ULL,
0x00000010633b7824ULL, 0x100fe400078e0212ULL, 0x00000010612f7824ULL, 0x104fe200078e0212ULL,
0x00000000322d7faeULL, 0x0007e2000b901c46ULL, 0x0000001065597824ULL, 0x000fc600078e0212ULL,
0x00000000342f7faeULL, 0x0007e8000b901c46ULL, 0x00000000363b7faeULL, 0x0007e8000b901c46ULL,
0x0000000038597faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201f2b7824ULL, 0x04afe200078e00ffULL, 0x000000081e2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000201f2c7824ULL, 0x000fc600078e00ffULL, 0xffffffe02b2a7812ULL, 0x000fe400078ee22aULL,
0x0000000a1e2b7810ULL, 0x000fc60007ffe0ffULL, 0x000000102a2a7824ULL, 0x000fe200078e00ffULL,
0xffffffe02c2b7812ULL, 0x000fca00078ee22bULL, 0x000000102b2b7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001c74783bULL, 0x000fe80000000200ULL,
0x000000002a60783bULL, 0x000e680000000200ULL, 0x000000001b70783bULL, 0x000ea80000000200ULL,
0x000000001a6c783bULL, 0x000ee80000000200ULL, 0x000000001964783bULL, 0x000f280000000200ULL,
0x000000001858783bULL, 0x000fe80000000200ULL, 0x000000002b2c783bULL, 0x000ee80000000200ULL,
0x000000001738783bULL, 0x000ee80000000200ULL, 0x000000001634783bULL, 0x000ee80000000200ULL,
0x000000001530783bULL, 0x000ee20000000200ULL, 0x000000746068723cULL, 0x042f700000001840ULL,
0x000000766040723cULL, 0x040f70000000183cULL, 0x000000706044723cULL, 0x044f700000001844ULL,
0x000000726048723cULL, 0x040f700000001848ULL, 0x0000006c604c723cULL, 0x048f70000000184cULL,
0x0000006e6050723cULL, 0x040f700000001850ULL, 0x000000646054723cULL, 0x050f700000001854ULL,
0x00000066605c723cULL, 0x000f70000000185cULL, 0x000000582c3c723cULL, 0x060b700000001868ULL,
0x0000005a2c58723cULL, 0x040b700000001840ULL, 0x000000382c40723cULL, 0x040b700000001844ULL,
0x0000003a2c44723cULL, 0x040b700000001848ULL, 0x000000342c48723cULL, 0x040b70000000184cULL,
0x000000362c4c723cULL, 0x040b700000001850ULL, 0x000000302c50723cULL, 0x040b700000001854ULL,
0x000000322c5c723cULL, 0x000b62000000185cULL, 0x0000063000008947ULL, 0x000fce0003800000ULL,
0x00000002ff337819ULL, 0x020fe20000011628ULL, 0x00000001043a7824ULL, 0x000fc600078e0a23ULL,
0x0000000833377810ULL, 0x040fe20007ffe0ffULL, 0x00000001332b7824ULL, 0x140fe200078e0221ULL,
0x0000001833607810ULL, 0x040fe40007ffe0ffULL, 0x0000001033567810ULL, 0x000fe20007ffe0ffULL,
0x00000001372d7824ULL, 0x100fe200078e0221ULL, 0x0000002b222b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000160317824ULL, 0x100fe200078e0221ULL, 0x0000002033617810ULL, 0x000fe20007ffe0ffULL,
0x00000001562f7824ULL, 0x100fe200078e0221ULL, 0x0000002d222d7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x0000003122317210ULL, 0x040fe20007f9e0ffULL,
0x0000000161357824ULL, 0x100fe200078e0221ULL, 0x0000002833627810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x040fe200078448ffULL,
0x000000ffff347224ULL, 0x000fe200020e06ffULL, 0x0000002f222f7210ULL, 0x000fe20007f7e0ffULL,
0x0000000162397824ULL, 0x000fe200078e0221ULL, 0x00005f002d2d7a11ULL, 0x000fe200010f4c30ULL,
0x0000000437557824ULL, 0x000fe200078e00ffULL, 0x00005e0031307a11ULL, 0x000fe200078448ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078248ffULL,
0x0000000456577824ULL, 0x000fe200078e00ffULL, 0x0000003033637810ULL, 0x000fc40007ffe0ffULL,
0x00005f0031317a11ULL, 0x000fe400010f4c34ULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c2eULL,
0x00000001633b7824ULL, 0x000fe200078e0221ULL, 0x0000003522357210ULL, 0x040fe40007f5e0ffULL,
0x00005e002f2e7a11ULL, 0x040fe400078248ffULL, 0x0000003922397210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x00005f002f2f7a11ULL, 0x000fc400008f4c32ULL,
0x00005e0035327a11ULL, 0x000fe200078448ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00005e0039347a11ULL, 0x000fe400078648ffULL, 0x0000003b223b7210ULL, 0x000fe40007f9e0ffULL,
0x0000003a3300720cULL, 0x040fe40003f26070ULL, 0x0000003833647810ULL, 0x000fe40007ffe0ffULL,
0x00005f0035337a11ULL, 0x000fc400010f4c36ULL, 0x00005f0039357a11ULL, 0x000fe200018f4c38ULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x00005e003b367a11ULL, 0x000fe200078648ffULL,
0x0000000164397824ULL, 0x000fe200078e0221ULL, 0x0000003a3700720cULL, 0x000fe40003f46070ULL,
0x00005f003b377a11ULL, 0x000fe400018f4c38ULL, 0x00000010203b7812ULL, 0x000fe400078efcffULL,
0x0000003922397210ULL, 0x000fc40007f9e0ffULL, 0xfffffffc55547812ULL, 0x000fe200078ee214ULL,
0x000000103b2a7825ULL, 0x000fe200078e002aULL, 0x00005e0039387a11ULL, 0x000fe400078648ffULL,
0x0000003a6300720cULL, 0x080fe20003fa6070ULL, 0x000000ffff667224ULL, 0x000fe200020e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a137faeULL, 0x0003e2000c901c46ULL,
0x0000001054557824ULL, 0x000fe200078e021dULL, 0x0000003a5600720cULL, 0x000fe20003f26070ULL,
0x000000103b2c7825ULL, 0x000fe200078e002cULL, 0x00005f0039397a11ULL, 0x000fc400018f4c66ULL,
0xfffffffc57547812ULL, 0x000fe200078ee214ULL, 0x0000000463637824ULL, 0x000fe200078e00ffULL,
0x000000002c557faeULL, 0x0005e2000d101c46ULL, 0x0000003a6100720cULL, 0x0c0fe20003f66070ULL,
0x0000000461617824ULL, 0x000fe200078e00ffULL, 0x0000003a6000720cULL, 0x080fe20003f46070ULL,
0x000000103b2a7825ULL, 0x042fe200078e002eULL, 0x0000003a6200720cULL, 0x080fe40003f86070ULL,
0x0000003a6400720cULL, 0x000fe20003fc6070ULL, 0x000000103b2e7825ULL, 0x000fc800078e0030ULL,
0x000000103b307825ULL, 0x000fc800078e0032ULL, 0x000000103b327825ULL, 0x000fc800078e0036ULL,
0x000000103b2c7825ULL, 0x004fc800078e0034ULL, 0x0000000460377824ULL, 0x000fe400078e00ffULL,
0x000000103b347825ULL, 0x000fe200078e0038ULL, 0xfffffffc61387812ULL, 0x100fe400078ee214ULL,
0xfffffffc37367812ULL, 0x100fe200078ee214ULL, 0x0000000462397824ULL, 0x000fe400078e00ffULL,
0x0000001054577824ULL, 0x100fe200078e021dULL, 0xfffffffc63547812ULL, 0x100fe200078ee214ULL,
0x00000004643b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc393a7812ULL, 0x100fe200078ee214ULL,
0x0000001038377824ULL, 0x100fe200078e021dULL, 0x000000002a577faeULL, 0x0003e4000c901c46ULL,
0xfffffffc3b567812ULL, 0x000fe200078ee214ULL, 0x000000103a397824ULL, 0x000fc400078e021dULL,
0x00000010543b7824ULL, 0x100fe400078e021dULL, 0x0000001056557824ULL, 0x100fe400078e021dULL,
0x00000010362b7824ULL, 0x002fca00078e021dULL, 0x000000002e2b7faeULL, 0x0003e8000d101c46ULL,
0x0000000030377faeULL, 0x0003e8000d901c46ULL, 0x000000002c397faeULL, 0x0003e8000e101c46ULL,
0x00000000323b7faeULL, 0x0003e8000e901c46ULL, 0x0000000034557faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000828367811ULL, 0x060fe400078ff0ffULL,
0x00000021282b7211ULL, 0x000fc400078ff0ffULL, 0x0000001028387811ULL, 0x000fe200078ff0ffULL,
0x00000001362d7824ULL, 0x100fe200078e0221ULL, 0x0000002b222b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000436557824ULL, 0x000fe200078e00ffULL, 0x0000001828567811ULL, 0x000fe200078ff0ffULL,
0x00000001382f7824ULL, 0x100fe200078e0221ULL, 0x0000002d222d7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078248ffULL,
0x0000000156317824ULL, 0x100fe200078e0221ULL, 0x0000002028607811ULL, 0x000fe200078ff0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078448ffULL,
0x0000000438577824ULL, 0x000fe200078e00ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c2eULL,
0x0000000160337824ULL, 0x000fe200078e0221ULL, 0x00005f002d2d7a11ULL, 0x000fc400010f4c30ULL,
0x0000002f222f7210ULL, 0x040fe40007f3e0ffULL, 0x0000003122317210ULL, 0x000fe40007f5e0ffULL,
0x0000002828627811ULL, 0x000fe200078ff0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00005e002f2e7a11ULL, 0x000fe200078248ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078448ffULL, 0x0000000162357824ULL, 0x040fe200078e0221ULL,
0x00005f002f2f7a11ULL, 0x000fe200008f4c32ULL, 0x0000000462617824ULL, 0x000fe200078e00ffULL,
0x00005f0031317a11ULL, 0x000fc400010f4c34ULL, 0x0000003322337210ULL, 0x040fe40007f3e0ffULL,
0x0000003522357210ULL, 0x000fe40007f5e0ffULL, 0x0000003028647811ULL, 0x040fe200078ff0ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x0000003828667811ULL, 0x000fe200078ff0ffULL,
0x000000ffff547224ULL, 0x000fe200010e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078248ffULL,
0x0000000164377824ULL, 0x100fe200078e0221ULL, 0x00005e0035347a11ULL, 0x000fe200078448ffULL,
0x0000000166397824ULL, 0x000fe200078e0221ULL, 0x00005f0033337a11ULL, 0x000fe200008f4c3aULL,
0x0000000464637824ULL, 0x000fe200078e00ffULL, 0x00005f0035357a11ULL, 0x000fe200010f4c54ULL,
0x0000000466657824ULL, 0x000fe200078e00ffULL, 0x0000003722377210ULL, 0x000fc40007f3e0ffULL,
0x0000003922397210ULL, 0x000fe40007f5e0ffULL, 0x00000010203b7812ULL, 0x000fe200078efcffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078248ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078448ffULL,
0x000000103b2a7825ULL, 0x000fe200078e002aULL, 0x00005f0037377a11ULL, 0x000fe400008f4c3aULL,
0x00005f0039397a11ULL, 0x000fe200010f4c68ULL, 0x000000103b2c7825ULL, 0x000fe200078e002cULL,
0xfffffffc553a7812ULL, 0x100fe200078ee214ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a137faeULL, 0x0003e2000b901c46ULL, 0xfffffffc57547812ULL, 0x000fe200078ee214ULL,
0x000000103b2e7825ULL, 0x000fc800078e002eULL, 0x000000103b307825ULL, 0x000fc800078e0030ULL,
0x000000103b327825ULL, 0x000fc800078e0032ULL, 0x000000103b347825ULL, 0x000fc800078e0034ULL,
0x000000103b367825ULL, 0x000fc800078e0036ULL, 0x000000103b387825ULL, 0x000fc800078e0038ULL,
0x00000004562b7824ULL, 0x002fe200078e00ffULL, 0xfffffffc63567812ULL, 0x100fe200078ee214ULL,
0x00000004603b7824ULL, 0x000fe400078e00ffULL, 0x000000103a557824ULL, 0x100fe200078e021dULL,
0xfffffffc2b2a7812ULL, 0x100fe200078ee214ULL, 0x0000001054577824ULL, 0x100fe200078e021dULL,
0xfffffffc3b3a7812ULL, 0x100fe200078ee214ULL, 0x00000010563b7824ULL, 0x100fe200078e021dULL,
0xfffffffc61547812ULL, 0x000fe200078ee214ULL, 0x000000002c557faeULL, 0x0003e2000b901c46ULL,
0x000000102a2b7824ULL, 0x000fc600078e021dULL, 0x000000002e577faeULL, 0x0005e8000b901c46ULL,
0x00000000302b7faeULL, 0x0007e2000b901c46ULL, 0xfffffffc652c7812ULL, 0x002fe200078ee214ULL,
0x000000103a2d7824ULL, 0x100fe400078e021dULL, 0x00000010542f7824ULL, 0x104fe400078e021dULL,
0x000000102c557824ULL, 0x000fe200078e021dULL, 0x00000000322d7faeULL, 0x0007e8000b901c46ULL,
0x00000000342f7faeULL, 0x0007e8000b901c46ULL, 0x00000000363b7faeULL, 0x0007e8000b901c46ULL,
0x0000000038557faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201f2b7824ULL, 0x04afe200078e00ffULL, 0x0000000c1e2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000201f2c7824ULL, 0x000fc600078e00ffULL, 0xffffffe02b2a7812ULL, 0x000fe400078ee22aULL,
0x0000000e1e2b7810ULL, 0x000fc60007ffe0ffULL, 0x000000102a2a7824ULL, 0x000fe200078e00ffULL,
0xffffffe02c2b7812ULL, 0x000fca00078ee22bULL, 0x000000102b2b7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001170783bULL, 0x000fe80000000200ULL,
0x000000002a60783bULL, 0x000e680000000200ULL, 0x00000000106c783bULL, 0x000ea80000000200ULL,
0x000000000f68783bULL, 0x000ee80000000200ULL, 0x000000000e64783bULL, 0x000f280000000200ULL,
0x000000000d54783bULL, 0x000fe80000000200ULL, 0x000000002b2c783bULL, 0x000ee80000000200ULL,
0x000000000b38783bULL, 0x000ee80000000200ULL, 0x000000000934783bULL, 0x000ee80000000200ULL,
0x000000000230783bULL, 0x000ee20000000200ULL, 0x00000070603c723cULL, 0x042f70000000183cULL,
0x000000726058723cULL, 0x040f700000001858ULL, 0x0000006c6040723cULL, 0x044f700000001840ULL,
0x0000006e6044723cULL, 0x040f700000001844ULL, 0x000000686048723cULL, 0x048f700000001848ULL,
0x0000006a604c723cULL, 0x040f70000000184cULL, 0x000000646050723cULL, 0x050f700000001850ULL,
0x00000066605c723cULL, 0x000f70000000185cULL, 0x000000542c3c723cULL, 0x060b70000000183cULL,
0x000000562c54723cULL, 0x040b700000001858ULL, 0x000000382c40723cULL, 0x040b700000001840ULL,
0x0000003a2c44723cULL, 0x040b700000001844ULL, 0x000000342c48723cULL, 0x040b700000001848ULL,
0x000000362c4c723cULL, 0x040b70000000184cULL, 0x000000302c50723cULL, 0x040b700000001850ULL,
0x000000322c5c723cULL, 0x000b62000000185cULL, 0x0000063000008947ULL, 0x000fce0003800000ULL,
0x00000002ff337819ULL, 0x020fe20000011628ULL, 0x00000001043a7824ULL, 0x000fc600078e0a23ULL,
0x0000000833377810ULL, 0x040fe20007ffe0ffULL, 0x00000001332b7824ULL, 0x140fe200078e0221ULL,
0x00000018335a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001033587810ULL, 0x000fe20007ffe0ffULL,
0x00000001372d7824ULL, 0x100fe200078e0221ULL, 0x0000002b222b7210ULL, 0x000fe20007f3e0ffULL,
0x000000015a317824ULL, 0x100fe200078e0221ULL, 0x0000002033607810ULL, 0x040fe20007ffe0ffULL,
0x00000001582f7824ULL, 0x100fe200078e0221ULL, 0x0000002d222d7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x0000003122317210ULL, 0x000fe20007f9e0ffULL,
0x0000000160357824ULL, 0x100fe200078e0221ULL, 0x0000002833617810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078448ffULL,
0x000000ffff347224ULL, 0x000fe200020e06ffULL, 0x0000002f222f7210ULL, 0x000fe20007f7e0ffULL,
0x0000000161397824ULL, 0x000fe200078e0221ULL, 0x00005f002d2d7a11ULL, 0x000fe200010f4c30ULL,
0x0000000437597824ULL, 0x000fe200078e00ffULL, 0x00005e0031307a11ULL, 0x000fe200078448ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x00005e002b2a7a11ULL, 0x000fc400078248ffULL,
0x0000003033627810ULL, 0x000fe40007ffe0ffULL, 0x00005f0031317a11ULL, 0x000fe400010f4c34ULL,
0x00005f002b2b7a11ULL, 0x000fe200008f4c2eULL, 0x00000001623b7824ULL, 0x000fe200078e0221ULL,
0x0000003522357210ULL, 0x040fe40007f5e0ffULL, 0x00005e002f2e7a11ULL, 0x040fe400078248ffULL,
0x0000003922397210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005f002f2f7a11ULL, 0x000fc400008f4c32ULL, 0x00005e0035327a11ULL, 0x000fe200078448ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e0039347a11ULL, 0x000fe400078648ffULL,
0x0000003b223b7210ULL, 0x000fe40007f9e0ffULL, 0x0000003833637810ULL, 0x040fe40007ffe0ffULL,
0x0000003a3300720cULL, 0x000fe40003f26070ULL, 0x00005f0035337a11ULL, 0x000fc400010f4c36ULL,
0x00005f0039357a11ULL, 0x000fe200018f4c38ULL, 0x000000ffff387224ULL, 0x000fe200020e06ffULL,
0x00005e003b367a11ULL, 0x000fe200078648ffULL, 0x0000000163397824ULL, 0x000fe200078e0221ULL,
0x0000003a3700720cULL, 0x000fe40003f46070ULL, 0x00005f003b377a11ULL, 0x000fe400018f4c38ULL,
0x00000039225b7210ULL, 0x000fe40007f9e0ffULL, 0x00000014203b7812ULL, 0x000fc400078efcffULL,
0xfffffffc59397812ULL, 0x000fe200078ee214ULL, 0x000000ffff647224ULL, 0x000fe200020e06ffULL,
0x00005e005b387a11ULL, 0x000fe200078648ffULL, 0x000000103b2a7825ULL, 0x000fe200078e002aULL,
0x0000003a6100720cULL, 0x080fe40003f86070ULL, 0x0000003a6200720cULL, 0x080fe20003fa6070ULL,
0x0000001039597824ULL, 0x000fe200078e0212ULL, 0x00005f005b397a11ULL, 0x000fe200018f4c64ULL,
0x000000103b2c7825ULL, 0x000fe200078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a297faeULL, 0x0003e2000c901c46ULL, 0x0000003a5800720cULL, 0x000fc40003f26070ULL,
0x00000004585b7824ULL, 0x000fe200078e00ffULL, 0x000000002c597faeULL, 0x0005e2000d101c46ULL,
0x0000003a5a00720cULL, 0x080fe40003f46070ULL, 0x0000003a6000720cULL, 0x080fe40003f66070ULL,
0xfffffffc5b5b7812ULL, 0x000fe400078ee214ULL, 0x0000003a6300720cULL, 0x000fe20003fc6070ULL,
0x000000103b2a7825ULL, 0x002fc800078e002eULL, 0x000000103b2e7825ULL, 0x000fc800078e0030ULL,
0x000000103b307825ULL, 0x000fc800078e0032ULL, 0x000000103b2c7825ULL, 0x004fc800078e0034ULL,
0x000000103b327825ULL, 0x000fc800078e0036ULL, 0x000000103b347825ULL, 0x000fc800078e0038ULL,
0x000000045a377824ULL, 0x000fe400078e00ffULL, 0x0000000460397824ULL, 0x000fe400078e00ffULL,
0x00000004613b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc37377812ULL, 0x100fe200078ee214ULL,
0x0000000462597824ULL, 0x000fe200078e00ffULL, 0xfffffffc39397812ULL, 0x100fe200078ee214ULL,
0x0000000463617824ULL, 0x000fe200078e00ffULL, 0xfffffffc3b3b7812ULL, 0x000fe200078ee214ULL,
0x000000105b5b7824ULL, 0x000fe200078e0212ULL, 0xfffffffc59597812ULL, 0x000fe200078ee214ULL,
0x0000001037377824ULL, 0x000fe200078e0212ULL, 0xfffffffc61617812ULL, 0x000fe200078ee214ULL,
0x0000001039397824ULL, 0x100fe200078e0212ULL, 0x000000002a5b7faeULL, 0x0003e2000c901c46ULL,
0x000000103b3b7824ULL, 0x000fc400078e0212ULL, 0x0000001059597824ULL, 0x100fe200078e0212ULL,
0x000000002e377faeULL, 0x0003e2000d101c46ULL, 0x0000001061617824ULL, 0x000fc600078e0212ULL,
0x0000000030397faeULL, 0x0003e8000d901c46ULL, 0x000000002c3b7faeULL, 0x0003e8000e101c46ULL,
0x0000000032597faeULL, 0x0003e8000e901c46ULL, 0x0000000034617faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000828367811ULL, 0x060fe400078ff0ffULL,
0x00000021282b7211ULL, 0x000fc400078ff0ffULL, 0x0000001028387811ULL, 0x000fe200078ff0ffULL,
0x00000001362d7824ULL, 0x100fe200078e0221ULL, 0x0000002b222b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000436597824ULL, 0x000fe200078e00ffULL, 0x00000018283a7811ULL, 0x000fe200078ff0ffULL,
0x00000001382f7824ULL, 0x100fe200078e0221ULL, 0x0000002d222d7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078248ffULL,
0x000000013a317824ULL, 0x100fe200078e0221ULL, 0x0000002028587811ULL, 0x000fe200078ff0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078448ffULL,
0x00000004385b7824ULL, 0x000fe200078e00ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c2eULL,
0x0000000158337824ULL, 0x000fe200078e0221ULL, 0x00005f002d2d7a11ULL, 0x000fc400010f4c30ULL,
0x0000002f222f7210ULL, 0x040fe40007f3e0ffULL, 0x0000003122317210ULL, 0x000fe40007f5e0ffULL,
0x0000002828607811ULL, 0x000fe200078ff0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00005e002f2e7a11ULL, 0x000fe200078248ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078448ffULL, 0x0000000160357824ULL, 0x040fe200078e0221ULL,
0x00005f002f2f7a11ULL, 0x000fe200008f4c32ULL, 0x0000000460617824ULL, 0x000fe200078e00ffULL,
0x00005f0031317a11ULL, 0x000fc400010f4c34ULL, 0x0000003322337210ULL, 0x040fe40007f3e0ffULL,
0x0000003522357210ULL, 0x000fe40007f5e0ffULL, 0x0000003028647811ULL, 0x040fe200078ff0ffULL,
0x000000ffff5a7224ULL, 0x000fe200008e06ffULL, 0x0000003828667811ULL, 0x000fe200078ff0ffULL,
0x000000ffff627224ULL, 0x000fe200010e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078248ffULL,
0x0000000164377824ULL, 0x100fe200078e0221ULL, 0x00005e0035347a11ULL, 0x000fe200078448ffULL,
0x0000000166397824ULL, 0x000fe200078e0221ULL, 0x00005f0033337a11ULL, 0x000fe200008f4c5aULL,
0x0000000464637824ULL, 0x000fe200078e00ffULL, 0x00005f0035357a11ULL, 0x000fe200010f4c62ULL,
0x0000000466657824ULL, 0x000fe200078e00ffULL, 0x0000003722377210ULL, 0x000fc40007f3e0ffULL,
0x0000003922397210ULL, 0x000fe40007f5e0ffULL, 0x00000014203b7812ULL, 0x000fe200078efcffULL,
0x000000ffff5a7224ULL, 0x000fe200008e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078248ffULL,
0x000000ffff627224ULL, 0x000fe200010e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078448ffULL,
0x000000103b2a7825ULL, 0x000fe200078e002aULL, 0x00005f0037377a11ULL, 0x000fe400008f4c5aULL,
0x00005f0039397a11ULL, 0x000fe200010f4c62ULL, 0x000000103b2c7825ULL, 0x000fe200078e002cULL,
0xfffffffc59597812ULL, 0x100fe200078ee214ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a297faeULL, 0x0003e2000b901c46ULL, 0xfffffffc5b5b7812ULL, 0x000fe200078ee214ULL,
0x000000103b2e7825ULL, 0x000fe200078e002eULL, 0xfffffffc61617812ULL, 0x000fc400078ee214ULL,
0xfffffffc63637812ULL, 0x000fe200078ee214ULL, 0x000000103b307825ULL, 0x000fc800078e0030ULL,
0x000000103b327825ULL, 0x000fc800078e0032ULL, 0x000000103b347825ULL, 0x000fc800078e0034ULL,
0x000000103b367825ULL, 0x000fc800078e0036ULL, 0x000000103b387825ULL, 0x000fc800078e0038ULL,
0x000000043a2b7824ULL, 0x002fe400078e00ffULL, 0x00000004583b7824ULL, 0x000fe400078e00ffULL,
0x0000001059597824ULL, 0x000fe200078e0212ULL, 0xfffffffc2b2b7812ULL, 0x000fe200078ee214ULL,
0x000000105b5b7824ULL, 0x000fe200078e0212ULL, 0xfffffffc3b3b7812ULL, 0x000fe200078ee214ULL,
0x0000001061617824ULL, 0x100fe200078e0212ULL, 0x000000002c597faeULL, 0x0003e2000b901c46ULL,
0x000000102b2b7824ULL, 0x000fc400078e0212ULL, 0x000000103b3b7824ULL, 0x100fe200078e0212ULL,
0x000000002e5b7faeULL, 0x0005e2000b901c46ULL, 0x0000001063637824ULL, 0x000fc600078e0212ULL,
0x00000000302b7faeULL, 0x0005e2000b901c46ULL, 0xfffffffc652d7812ULL, 0x002fc600078ee214ULL,
0x00000000323b7faeULL, 0x0005e4000b901c46ULL, 0x000000102d2d7824ULL, 0x000fe400078e0212ULL,
0x0000000034617faeULL, 0x0005e8000b901c46ULL, 0x0000000036637faeULL, 0x0005e8000b901c46ULL,
0x00000000382d7faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201f2b7824ULL, 0x046fe200078e00ffULL, 0x000000101e2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000201f2c7824ULL, 0x000fc600078e00ffULL, 0xffffffe02b2a7812ULL, 0x000fe400078ee22aULL,
0x000000121e2b7810ULL, 0x000fc60007ffe0ffULL, 0x000000102a2a7824ULL, 0x000fe200078e00ffULL,
0xffffffe02c2b7812ULL, 0x000fca00078ee22bULL, 0x000000102b2b7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002a60783bULL, 0x000fe80000000200ULL,
0x000000001b6c783bULL, 0x000e680000000200ULL, 0x000000001c70783bULL, 0x000ea80000000200ULL,
0x000000001a68783bULL, 0x000ee80000000200ULL, 0x000000001964783bULL, 0x000f280000000200ULL,
0x000000002b2c783bULL, 0x000fe80000000200ULL, 0x000000001738783bULL, 0x000ee80000000200ULL,
0x000000001858783bULL, 0x000ee80000000200ULL, 0x000000001634783bULL, 0x000f280000000200ULL,
0x000000001530783bULL, 0x000f220000000200ULL, 0x0000006c6040723cULL, 0x042f700000001840ULL,
0x0000006e6044723cULL, 0x040f700000001844ULL, 0x00000070603c723cULL, 0x044f70000000183cULL,
0x000000686048723cULL, 0x048f700000001848ULL, 0x000000726054723cULL, 0x040f700000001854ULL,
0x0000006a604c723cULL, 0x040f70000000184cULL, 0x000000646050723cULL, 0x050f700000001850ULL,
0x00000066605c723cULL, 0x000f70000000185cULL, 0x000000382c40723cULL, 0x060b700000001840ULL,
0x0000003a2c38723cULL, 0x040b700000001844ULL, 0x000000582c3c723cULL, 0x040b70000000183cULL,
0x000000342c44723cULL, 0x040b700000001848ULL, 0x0000005a2c58723cULL, 0x040b700000001854ULL,
0x000000362c34723cULL, 0x040b70000000184cULL, 0x000000302c48723cULL, 0x040b700000001850ULL,
0x000000322c5c723cULL, 0x000b62000000185cULL, 0x0000063000008947ULL, 0x000fce0003800000ULL,
0x00000002ff337819ULL, 0x020fe20000011628ULL, 0x0000000104527824ULL, 0x000fc600078e0a23ULL,
0x00000008334f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001332b7824ULL, 0x140fe200078e0221ULL,
0x0000001833607810ULL, 0x040fe40007ffe0ffULL, 0x0000001033567810ULL, 0x000fe20007ffe0ffULL,
0x000000014f2d7824ULL, 0x100fe200078e0221ULL, 0x0000002b222b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000160317824ULL, 0x100fe200078e0221ULL, 0x0000002033617810ULL, 0x000fe20007ffe0ffULL,
0x00000001562f7824ULL, 0x100fe200078e0221ULL, 0x0000002d222d7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x0000003122317210ULL, 0x040fe20007f9e0ffULL,
0x00000001614d7824ULL, 0x100fe200078e0221ULL, 0x0000002833627810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x040fe200078448ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000002f222f7210ULL, 0x000fe20007f7e0ffULL,
0x0000000162517824ULL, 0x000fe200078e0221ULL, 0x00005f002d2d7a11ULL, 0x000fe200010f4c30ULL,
0x000000044f557824ULL, 0x000fe200078e00ffULL, 0x00005e0031307a11ULL, 0x000fe200078448ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078248ffULL,
0x0000000456577824ULL, 0x000fe200078e00ffULL, 0x0000003033637810ULL, 0x000fc40007ffe0ffULL,
0x00005f0031317a11ULL, 0x000fe400010f4c4cULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c2eULL,
0x0000000163537824ULL, 0x000fe200078e0221ULL, 0x0000004d224d7210ULL, 0x040fe40007f5e0ffULL,
0x00005e002f2e7a11ULL, 0x040fe400078248ffULL, 0x0000005122517210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4e7224ULL, 0x000fe200010e06ffULL, 0x00005f002f2f7a11ULL, 0x000fc400008f4c32ULL,
0x00005e004d327a11ULL, 0x000fe200078448ffULL, 0x000000ffff507224ULL, 0x000fe200018e06ffULL,
0x00005e00514c7a11ULL, 0x000fe400078648ffULL, 0x0000005322537210ULL, 0x000fe40007f9e0ffULL,
0x000000523300720cULL, 0x040fe40003f26070ULL, 0x0000003833647810ULL, 0x000fe40007ffe0ffULL,
0x00005f004d337a11ULL, 0x000fc400010f4c4eULL, 0x00005f00514d7a11ULL, 0x000fe200018f4c50ULL,
0x000000ffff507224ULL, 0x000fe200020e06ffULL, 0x00005e00534e7a11ULL, 0x000fe200078648ffULL,
0x0000000164517824ULL, 0x000fe200078e0221ULL, 0x000000524f00720cULL, 0x000fe40003f46070ULL,
0x00005f00534f7a11ULL, 0x000fe400018f4c50ULL, 0x0000001820537812ULL, 0x000fe400078efcffULL,
0x0000005122517210ULL, 0x000fc40007f9e0ffULL, 0xfffffffc55547812ULL, 0x000fe200078ee214ULL,
0x00000010532a7825ULL, 0x000fe200078e002aULL, 0x00005e0051507a11ULL, 0x000fe400078648ffULL,
0x000000526300720cULL, 0x080fe20003fa6070ULL, 0x000000ffff667224ULL, 0x000fe200020e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a137faeULL, 0x0003e2000c901c46ULL,
0x0000001054557824ULL, 0x000fe200078e021dULL, 0x000000525600720cULL, 0x000fe20003f26070ULL,
0x00000010532c7825ULL, 0x000fe200078e002cULL, 0x00005f0051517a11ULL, 0x000fc400018f4c66ULL,
0xfffffffc57547812ULL, 0x000fe200078ee214ULL, 0x0000000463637824ULL, 0x000fe200078e00ffULL,
0x000000002c557faeULL, 0x0005e2000d101c46ULL, 0x000000526100720cULL, 0x0c0fe20003f66070ULL,
0x0000000461617824ULL, 0x000fe200078e00ffULL, 0x000000526000720cULL, 0x080fe20003f46070ULL,
0x00000010532a7825ULL, 0x042fe200078e002eULL, 0x000000526200720cULL, 0x080fe40003f86070ULL,
0x000000526400720cULL, 0x000fe20003fc6070ULL, 0x00000010532e7825ULL, 0x000fc800078e0030ULL,
0x0000001053307825ULL, 0x000fc800078e0032ULL, 0x0000001053327825ULL, 0x000fc800078e004eULL,
0x00000010532c7825ULL, 0x004fc800078e004cULL, 0x00000004604f7824ULL, 0x000fe400078e00ffULL,
0x00000010534c7825ULL, 0x000fe200078e0050ULL, 0xfffffffc61507812ULL, 0x100fe400078ee214ULL,
0xfffffffc4f4e7812ULL, 0x100fe200078ee214ULL, 0x0000000462517824ULL, 0x000fe400078e00ffULL,
0x0000001054577824ULL, 0x100fe200078e021dULL, 0xfffffffc63547812ULL, 0x100fe200078ee214ULL,
0x0000000464537824ULL, 0x000fe200078e00ffULL, 0xfffffffc51527812ULL, 0x100fe200078ee214ULL,
0x00000010504f7824ULL, 0x100fe200078e021dULL, 0x000000002a577faeULL, 0x0003e4000c901c46ULL,
0xfffffffc53567812ULL, 0x000fe200078ee214ULL, 0x0000001052517824ULL, 0x000fc400078e021dULL,
0x0000001054537824ULL, 0x100fe400078e021dULL, 0x0000001056557824ULL, 0x100fe400078e021dULL,
0x000000104e2b7824ULL, 0x002fca00078e021dULL, 0x000000002e2b7faeULL, 0x0003e8000d101c46ULL,
0x00000000304f7faeULL, 0x0003e8000d901c46ULL, 0x000000002c517faeULL, 0x0003e8000e101c46ULL,
0x0000000032537faeULL, 0x0003e8000e901c46ULL, 0x000000004c557faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x00000008284e7811ULL, 0x060fe400078ff0ffULL,
0x00000021282b7211ULL, 0x000fc400078ff0ffULL, 0x0000001028507811ULL, 0x000fe200078ff0ffULL,
0x000000014e2d7824ULL, 0x100fe200078e0221ULL, 0x0000002b222b7210ULL, 0x000fe20007f3e0ffULL,
0x000000044e557824ULL, 0x000fe200078e00ffULL, 0x0000001828567811ULL, 0x000fe200078ff0ffULL,
0x00000001502f7824ULL, 0x100fe200078e0221ULL, 0x0000002d222d7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078248ffULL,
0x0000000156317824ULL, 0x100fe200078e0221ULL, 0x0000002028607811ULL, 0x000fe200078ff0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078448ffULL,
0x0000000450577824ULL, 0x000fe200078e00ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c2eULL,
0x0000000160337824ULL, 0x000fe200078e0221ULL, 0x00005f002d2d7a11ULL, 0x000fc400010f4c30ULL,
0x0000002f222f7210ULL, 0x040fe40007f3e0ffULL, 0x0000003122317210ULL, 0x000fe40007f5e0ffULL,
0x0000002828627811ULL, 0x000fe200078ff0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00005e002f2e7a11ULL, 0x000fe200078248ffULL, 0x000000ffff4c7224ULL, 0x000fe200010e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078448ffULL, 0x00000001624d7824ULL, 0x040fe200078e0221ULL,
0x00005f002f2f7a11ULL, 0x000fe200008f4c32ULL, 0x0000000462617824ULL, 0x000fe200078e00ffULL,
0x00005f0031317a11ULL, 0x000fc400010f4c4cULL, 0x0000003322337210ULL, 0x040fe40007f3e0ffULL,
0x0000004d224d7210ULL, 0x000fe40007f5e0ffULL, 0x0000003028647811ULL, 0x040fe200078ff0ffULL,
0x000000ffff527224ULL, 0x000fe200008e06ffULL, 0x0000003828667811ULL, 0x000fe200078ff0ffULL,
0x000000ffff547224ULL, 0x000fe200010e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078248ffULL,
0x00000001644f7824ULL, 0x100fe200078e0221ULL, 0x00005e004d4c7a11ULL, 0x000fe200078448ffULL,
0x0000000166517824ULL, 0x000fe200078e0221ULL, 0x00005f0033337a11ULL, 0x000fe200008f4c52ULL,
0x0000000464637824ULL, 0x000fe200078e00ffULL, 0x00005f004d4d7a11ULL, 0x000fe200010f4c54ULL,
0x0000000466657824ULL, 0x000fe200078e00ffULL, 0x0000004f224f7210ULL, 0x000fc40007f3e0ffULL,
0x0000005122517210ULL, 0x000fe40007f5e0ffULL, 0x0000001820537812ULL, 0x000fe200078efcffULL,
0x000000ffff527224ULL, 0x000fe200008e06ffULL, 0x00005e004f4e7a11ULL, 0x000fe200078248ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x00005e0051507a11ULL, 0x000fe200078448ffULL,
0x00000010532a7825ULL, 0x000fe200078e002aULL, 0x00005f004f4f7a11ULL, 0x000fe400008f4c52ULL,
0x00005f0051517a11ULL, 0x000fe200010f4c68ULL, 0x00000010532c7825ULL, 0x000fe200078e002cULL,
0xfffffffc55527812ULL, 0x100fe200078ee214ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a137faeULL, 0x0003e2000b901c46ULL, 0xfffffffc57547812ULL, 0x000fe200078ee214ULL,
0x00000010532e7825ULL, 0x000fc800078e002eULL, 0x0000001053307825ULL, 0x000fc800078e0030ULL,
0x0000001053327825ULL, 0x000fc800078e0032ULL, 0x00000010534c7825ULL, 0x000fc800078e004cULL,
0x00000010534e7825ULL, 0x000fc800078e004eULL, 0x0000001053507825ULL, 0x000fc800078e0050ULL,
0x00000004562b7824ULL, 0x002fe200078e00ffULL, 0xfffffffc63567812ULL, 0x100fe200078ee214ULL,
0x0000000460537824ULL, 0x000fe400078e00ffULL, 0x0000001052557824ULL, 0x100fe200078e021dULL,
0xfffffffc2b2a7812ULL, 0x100fe200078ee214ULL, 0x0000001054577824ULL, 0x100fe200078e021dULL,
0xfffffffc53527812ULL, 0x100fe200078ee214ULL, 0x0000001056537824ULL, 0x100fe200078e021dULL,
0xfffffffc61547812ULL, 0x000fe200078ee214ULL, 0x000000002c557faeULL, 0x0003e2000b901c46ULL,
0x000000102a2b7824ULL, 0x000fc600078e021dULL, 0x000000002e577faeULL, 0x0005e8000b901c46ULL,
0x00000000302b7faeULL, 0x0007e2000b901c46ULL, 0xfffffffc652c7812ULL, 0x002fe200078ee214ULL,
0x00000010522d7824ULL, 0x100fe400078e021dULL, 0x00000010542f7824ULL, 0x104fe400078e021dULL,
0x000000102c557824ULL, 0x000fe200078e021dULL, 0x00000000322d7faeULL, 0x0007e8000b901c46ULL,
0x000000004c2f7faeULL, 0x0007e8000b901c46ULL, 0x000000004e537faeULL, 0x0007e8000b901c46ULL,
0x0000000050557faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201f2b7824ULL, 0x04afe200078e00ffULL, 0x000000141e2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000201f2c7824ULL, 0x000fc600078e00ffULL, 0xffffffe02b2a7812ULL, 0x000fe400078ee22aULL,
0x000000161e2b7810ULL, 0x000fc60007ffe0ffULL, 0x000000102a2a7824ULL, 0x000fe200078e00ffULL,
0xffffffe02c2b7812ULL, 0x000fca00078ee22bULL, 0x000000102b2b7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001170783bULL, 0x000fe80000000200ULL,
0x000000002a60783bULL, 0x000e680000000200ULL, 0x000000000f68783bULL, 0x000ea80000000200ULL,
0x00000000106c783bULL, 0x000ee80000000200ULL, 0x000000000e64783bULL, 0x000f280000000200ULL,
0x000000000d2c783bULL, 0x000fe80000000200ULL, 0x000000002b30783bULL, 0x000ee80000000200ULL,
0x000000000950783bULL, 0x000ee80000000200ULL, 0x000000000b4c783bULL, 0x000f280000000200ULL,
0x000000000254783bULL, 0x000f220000000200ULL, 0x00000070603c723cULL, 0x042f70000000183cULL,
0x000000726058723cULL, 0x040f700000001858ULL, 0x000000686044723cULL, 0x044f700000001844ULL,
0x0000006c6040723cULL, 0x048f700000001840ULL, 0x0000006e6038723cULL, 0x040f700000001838ULL,
0x0000006a6034723cULL, 0x040f700000001834ULL, 0x000000646048723cULL, 0x050f700000001848ULL,
0x00000066605c723cULL, 0x000f70000000185cULL, 0x0000002c303c723cULL, 0x060b70000000183cULL,
0x0000002e3058723cULL, 0x040b700000001858ULL, 0x000000503044723cULL, 0x040b700000001844ULL,
0x0000004c3040723cULL, 0x040b700000001840ULL, 0x0000004e3038723cULL, 0x040b700000001838ULL,
0x000000523050723cULL, 0x040b700000001834ULL, 0x00000054302c723cULL, 0x040b700000001848ULL,
0x000000563030723cULL, 0x000b62000000185cULL, 0x0000063000008947ULL, 0x000fce0003800000ULL,
0x00000002ff487819ULL, 0x020fe20000011628ULL, 0x0000000104567824ULL, 0x000fe200078e0a23ULL,
0x0000001c20577812ULL, 0x000fc400078efcffULL, 0x00000008485c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001482b7824ULL, 0x140fe200078e0221ULL, 0x00000010485d7810ULL, 0x040fe40007ffe0ffULL,
0x00000018485e7810ULL, 0x000fe20007ffe0ffULL, 0x000000015c357824ULL, 0x100fe200078e0221ULL,
0x0000002b222b7210ULL, 0x000fe20007f1e0ffULL, 0x000000015d377824ULL, 0x100fe200078e0221ULL,
0x00000020485f7810ULL, 0x000fe20007ffe0ffULL, 0x000000015e497824ULL, 0x100fe200078e0221ULL,
0x0000003522357210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0x0000003722377210ULL, 0x000fe20007f5e0ffULL, 0x000000015f4b7824ULL, 0x100fe200078e0221ULL,
0x0000002848607810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x00005e0035347a11ULL, 0x040fe200078248ffULL, 0x000000ffff4e7224ULL, 0x000fe200010e06ffULL,
0x0000003048617810ULL, 0x000fe20007ffe0ffULL, 0x00000001604d7824ULL, 0x100fe200078e0221ULL,
0x0000003848637810ULL, 0x000fe20007ffe0ffULL, 0x000000045e657824ULL, 0x000fe200078e00ffULL,
0x00005f0035357a11ULL, 0x000fe200008f4c4cULL, 0x00000001614f7824ULL, 0x100fe200078e0221ULL,
0x00005e002b2a7a11ULL, 0x000fe200078048ffULL, 0x0000000163217824ULL, 0x000fe200078e0221ULL,
0x0000004922497210ULL, 0x000fe20007f3e0ffULL, 0x0000000460677824ULL, 0x000fe200078e00ffULL,
0x00005e0037367a11ULL, 0x000fe200078448ffULL, 0x0000000461697824ULL, 0x000fe200078e00ffULL,
0x00005f002b2b7a11ULL, 0x000fe200000f4c4aULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0x00005f0037377a11ULL, 0x000fe200010f4c4eULL, 0x00000004636b7824ULL, 0x000fe200078e00ffULL,
0x000000564800720cULL, 0x000fc40003f06070ULL, 0x0000004f224f7210ULL, 0x040fe40007f5e0ffULL,
0x0000002122557210ULL, 0x040fe20007f3e0ffULL, 0x0000001057207825ULL, 0x000fe200078e002aULL,
0x0000004b224b7210ULL, 0x040fe40007f9e0ffULL, 0x00005e0049487a11ULL, 0x000fe200078648ffULL,
0x000000ffff647224ULL, 0x000fe200010e06ffULL, 0x0000004d224d7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff667224ULL, 0x000fe200008e06ffULL, 0x00005e004f4e7a11ULL, 0x000fe200078248ffULL,
0x000000ffff227224ULL, 0x000fe200020e06ffULL, 0x00005f0049497a11ULL, 0x000fe200018f4c4aULL,
0x000000045c2b7824ULL, 0x000fe200078e00ffULL, 0x00005f004f4f7a11ULL, 0x000fe200008f4c64ULL,
0x000000ffff627224ULL, 0x000fe200028e06ffULL, 0x00005e0055547a11ULL, 0x000fe200078448ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020297faeULL, 0x0003e2000c101c46ULL,
0x000000565d00720cULL, 0x040fe20003f26070ULL, 0x000000045d5d7824ULL, 0x000fe200078e00ffULL,
0x00005e004b4a7a11ULL, 0x000fc400078648ffULL, 0x00005e004d4c7a11ULL, 0x000fe400078848ffULL,
0x000000565c00720cULL, 0x080fe40003f06070ULL, 0x00005f0055557a11ULL, 0x000fe400010f4c66ULL,
0x00005f004b4b7a11ULL, 0x000fe200018f4c22ULL, 0x000000045f297824ULL, 0x002fe200078e00ffULL,
0x000000565e00720cULL, 0x000fe40003f46070ULL, 0xfffffffc2b217812ULL, 0x000fc400078ee214ULL,
0x00005f004d4d7a11ULL, 0x000fe400020f4c62ULL, 0x000000565f00720cULL, 0x080fe40003f66070ULL,
0xfffffffc5d2b7812ULL, 0x000fe400078ee214ULL, 0x000000566000720cULL, 0x080fe40003f86070ULL,
0x000000566100720cULL, 0x080fe20003fa6070ULL, 0x000000102b5d7824ULL, 0x000fe200078e0212ULL,
0xfffffffc655f7812ULL, 0x000fe200078ee214ULL, 0x00000010572a7825ULL, 0x000fe200078e0036ULL,
0x000000566300720cULL, 0x000fc40003fc6070ULL, 0xfffffffc29617812ULL, 0x000fe200078ee214ULL,
0x0000001021297824ULL, 0x000fe200078e0212ULL, 0xfffffffc67637812ULL, 0x000fe200078ee214ULL,
0x0000001057207825ULL, 0x000fe200078e0034ULL, 0xfffffffc69657812ULL, 0x100fe400078ee214ULL,
0xfffffffc6b677812ULL, 0x000fe200078ee214ULL, 0x000000105f5f7824ULL, 0x000fe200078e0212ULL,
0x0000000020297faeULL, 0x0003e2000c101c46ULL, 0x0000001057347825ULL, 0x000fc600078e0048ULL,
0x000000002a5d7faeULL, 0x0003e2000c901c46ULL, 0x0000001061617824ULL, 0x000fe400078e0212ULL,
0x0000001057367825ULL, 0x000fe200078e004aULL, 0x00000000345f7faeULL, 0x0003e6000d101c46ULL,
0x0000001063637824ULL, 0x000fe200078e0212ULL, 0x0000000036617faeULL, 0x0003e2000d901c46ULL,
0x0000001057487825ULL, 0x000fc800078e004cULL, 0x0000001065657824ULL, 0x000fe200078e0212ULL,
0x0000000048637faeULL, 0x0003e2000e101c46ULL, 0x00000010574a7825ULL, 0x000fc800078e004eULL,
0x0000001067677824ULL, 0x000fe200078e0212ULL, 0x000000004a657faeULL, 0x0003e2000e901c46ULL,
0x00000010574c7825ULL, 0x000fca00078e0054ULL, 0x000000004c677faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000828367811ULL, 0x060fe400078ff0ffULL,
0x00000021282b7211ULL, 0x040fe400078ff0ffULL, 0x00000010284a7811ULL, 0x000fe200078ff0ffULL,
0x0000000136357824ULL, 0x100fe200078e0221ULL, 0x0000002b222b7210ULL, 0x000fe40007f1e0ffULL,
0x00000018284c7811ULL, 0x000fe200078ff0ffULL, 0x000000014a377824ULL, 0x100fe200078e0221ULL,
0x00000020284e7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff347224ULL, 0x000fe200000e06ffULL,
0x0000002828547811ULL, 0x000fe200078ff0ffULL, 0x000000014c497824ULL, 0x100fe200078e0221ULL,
0x00000030285c7811ULL, 0x000fe200078ff0ffULL, 0x000000014e4d7824ULL, 0x100fe200078e0221ULL,
0x0000003828607811ULL, 0x000fe200078ff0ffULL, 0x0000000154557824ULL, 0x100fe200078e0221ULL,
0x0000003522357210ULL, 0x000fe20007f7e0ffULL, 0x000000015c577824ULL, 0x100fe200078e0221ULL,
0x00005e002b2a7a11ULL, 0x040fe200078048ffULL, 0x0000000160217824ULL, 0x000fe200078e0221ULL,
0x0000004d224f7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x00005f002b2b7a11ULL, 0x000fe200000f4c34ULL, 0x000000044c4d7824ULL, 0x000fe200078e00ffULL,
0x00000049224b7210ULL, 0x000fe20007f1e0ffULL, 0x000000044a497824ULL, 0x000fe200078e00ffULL,
0x0000005522567210ULL, 0x000fe20007f7e0ffULL, 0x000000044e557824ULL, 0x000fe200078e00ffULL,
0x00000057225e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000454577824ULL, 0x000fe200078e00ffULL,
0x0000002122627210ULL, 0x000fe20007f9e0ffULL, 0x0000000436217824ULL, 0x000fe200078e00ffULL,
0x0000003722377210ULL, 0x000fe20007f3e0ffULL, 0x000000045c677824ULL, 0x000fe200078e00ffULL,
0x00005e0035347a11ULL, 0x000fe200078c48ffULL, 0x0000000460697824ULL, 0x000fe200078e00ffULL,
0xfffffffc21217812ULL, 0x100fe200078ee214ULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0xfffffffc49497812ULL, 0x100fe200078ee214ULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0xfffffffc4d4d7812ULL, 0x000fe200078ee214ULL, 0x00000010215d7824ULL, 0x000fe200078e0212ULL,
0xfffffffc55557812ULL, 0x000fe200078ee214ULL, 0x00000010495f7824ULL, 0x000fe200078e0212ULL,
0xfffffffc57577812ULL, 0x000fe200078ee214ULL, 0x000000104d617824ULL, 0x000fe200078e0212ULL,
0xfffffffc67677812ULL, 0x000fe200078ee214ULL, 0x0000001055637824ULL, 0x000fe200078e0212ULL,
0xfffffffc69697812ULL, 0x000fe200078ee214ULL, 0x0000001057657824ULL, 0x000fe200078e0212ULL,
0x00005f0035357a11ULL, 0x000fe200030f4c48ULL, 0x0000001067677824ULL, 0x100fe200078e0212ULL,
0x00005e004b487a11ULL, 0x000fe200078048ffULL, 0x00000010696b7824ULL, 0x000fe200078e0212ULL,
0x00005e0037367a11ULL, 0x000fe200078248ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005f004b497a11ULL, 0x000fe200000f4c4aULL, 0x000000ffff4d7224ULL, 0x000fe200018e06ffULL,
0x00005f0037377a11ULL, 0x000fe200008f4c22ULL, 0x000000ffff557224ULL, 0x000fe200028e06ffULL,
0x0000001c20577812ULL, 0x000fe200078efcffULL, 0x000000ffff697224ULL, 0x000fe200020e06ffULL,
0x00005e004f4a7a11ULL, 0x000fc400078048ffULL, 0x00005e00564c7a11ULL, 0x000fe200078248ffULL,
0x0000001057207825ULL, 0x040fe200078e002aULL, 0x00005e005e4e7a11ULL, 0x000fe400078448ffULL,
0x00005e0062547a11ULL, 0x000fe200078648ffULL, 0x00000010572a7825ULL, 0x000fe200078e0034ULL,
0x00005f004f4b7a11ULL, 0x000fe200000f4c12ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020297faeULL, 0x0003e2000b901c46ULL, 0x00005f00564d7a11ULL, 0x000fe200008f4c4dULL,
0x0000001057347825ULL, 0x040fe200078e0036ULL, 0x00005f005e4f7a11ULL, 0x000fe200010f4c55ULL,
0x000000002a5d7faeULL, 0x0003e2000b901c46ULL, 0x00005f0062557a11ULL, 0x000fe200018f4c69ULL,
0x0000001057367825ULL, 0x000fc400078e0048ULL, 0x00000000345f7faeULL, 0x0003e4000b901c46ULL,
0x0000001057487825ULL, 0x040fe400078e004aULL, 0x0000000036617faeULL, 0x0003e4000b901c46ULL,
0x00000010574a7825ULL, 0x040fe400078e004cULL, 0x0000000048637faeULL, 0x0003e4000b901c46ULL,
0x00000010574c7825ULL, 0x000fc400078e004eULL, 0x000000004a657faeULL, 0x0003e4000b901c46ULL,
0x00000010574e7825ULL, 0x000fe400078e0054ULL, 0x000000004c677faeULL, 0x0003e8000b901c46ULL,
0x000000004e6b7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff217624ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff227424ULL, 0x000fc400078e00ffULL,
0x00000002210c7824ULL, 0x000fca00078e020cULL, 0x000000050c00720cULL, 0x000fda0003f06070ULL,
0x0000000227208824ULL, 0x000fe400078e020cULL, 0x00000004ff218424ULL, 0x000fe200078e00ffULL,
0x000000181e127810ULL, 0x000fe20007ffe0ffULL, 0x000000201f297824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600020208625ULL, 0x000fe200078e0021ULL,
0xffffffe029127812ULL, 0x000fe200078ee212ULL, 0x000000001c4c783bULL, 0x000fe80000000200ULL,
0x0000000620228981ULL, 0x0002a2000c1e1900ULL, 0x0000001012127824ULL, 0x000fc600078e00ffULL,
0x000000001b54783bULL, 0x000fe80000000200ULL, 0x000000001248783bULL, 0x000ee20000000200ULL,
0x000000201f217824ULL, 0x002fe200078e00ffULL, 0x0000001a1e207810ULL, 0x000fe40007ffe0ffULL,
0x000000001a5c783bULL, 0x000e640000000200ULL, 0xffffffe021207812ULL, 0x000fc400078ee220ULL,
0x000000001960783bULL, 0x000f260000000200ULL, 0x0000001020207824ULL, 0x000fe200078e00ffULL,
0x000000001864783bULL, 0x000fe80000000200ULL, 0x000000002034783bULL, 0x000e680000000200ULL,
0x000000001768783bULL, 0x000e680000000200ULL, 0x00000000166c783bULL, 0x000f280000000200ULL,
0x000000001570783bULL, 0x0007240000000200ULL, 0x0000030003157a10ULL, 0x008fe20007ffe0ffULL,
0x0000004c483c723cULL, 0x000f66000000183cULL, 0x0000000115177810ULL, 0x040fe20007ffe0ffULL,
0x0000010015217824ULL, 0x000fc600078e020aULL, 0x000000061700720cULL, 0x000fe40003f06070ULL,
0x0000004021177812ULL, 0x000fe200078ec0ffULL, 0x0000004e4858723cULL, 0x040ff00000001858ULL,
0x000000544840723cULL, 0x040f700000001840ULL, 0x0000005c4844723cULL, 0x042f700000001844ULL,
0x000000564838723cULL, 0x040f700000001838ULL, 0x0000005e4850723cULL, 0x040f700000001850ULL,
0x00000060484c723cULL, 0x050f70000000182cULL, 0x000000624848723cULL, 0x000f700000001830ULL,
0x000000643418723cULL, 0x060f70000000183cULL, 0x000000683430723cULL, 0x040f700000001840ULL,
0x0000006c343c723cULL, 0x040f700000001844ULL, 0x00000066342c723cULL, 0x040f700000001858ULL,
0x0000006a3438723cULL, 0x040f700000001838ULL, 0x0000006e3440723cULL, 0x040f700000001850ULL,
0x000000703444723cULL, 0x040f70000000184cULL, 0x000000723434723cULL, 0x000b6e0000001848ULL,
0x00000001084b7824ULL, 0x020fc400078e0217ULL, 0x00000007224d7224ULL, 0x004fe200078e02ffULL,
0x000006d000008947ULL, 0x000fca0003800000ULL, 0x00000002ff4c7819ULL, 0x000fe20000011628ULL,
0x00000010284e7824ULL, 0x000fe200078e00ffULL, 0x0000002104127217ULL, 0x000fe40007800000ULL,
0x000000084c507810ULL, 0x040fe20007ffe0ffULL, 0x000000014c167824ULL, 0x040fe200078e024bULL,
0x000000104c517810ULL, 0x000fe20007ffe0ffULL, 0x00000001121c7824ULL, 0x000fe200078e0a21ULL,
0x000000184c527810ULL, 0x000fe20007ffe0ffULL, 0x0000000150127824ULL, 0x100fe200078e024bULL,
0x000000164d4a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000151167824ULL, 0x100fe200078e024bULL,
0x000000304e4f7812ULL, 0x000fe200078ec0ffULL, 0x0000000152177824ULL, 0x000fe200078e024bULL,
0x000000124d127210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0x00005e004a497a11ULL, 0x000fc400078048ffULL, 0x000000164d167210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e06ffULL, 0x000000174d177210ULL, 0x000fe40007f7e0ffULL,
0x00005f004a4a7a11ULL, 0x000fe200000f4c21ULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x00005e0012207a11ULL, 0x000fe200078048ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x00005e0017297a11ULL, 0x000fe400078448ffULL, 0x00005e00162a7a11ULL, 0x000fc400078248ffULL,
0x00005f00122b7a11ULL, 0x000fe400000f4c2bULL, 0x00005f0017487a11ULL, 0x000fe200010f4c48ULL,
0x0000000450177824ULL, 0x000fe200078e00ffULL, 0x00005f0016127a11ULL, 0x000fe400008f4c21ULL,
0x0000004f49167210ULL, 0x000fe40007f7e0ffULL, 0x0000001c5100720cULL, 0x0c0fe20003f46070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0xfffffffc174e7812ULL, 0x000fe200078ee214ULL,
0x000000ffff177224ULL, 0x000fe200018e064aULL, 0x0000001c4c00720cULL, 0x000fc40003f06070ULL,
0xfffffffc514a7812ULL, 0x000fe200078ee214ULL, 0x000000104e497824ULL, 0x100fe200078e021dULL,
0x0000004f20207210ULL, 0x080fe40007f7e0ffULL, 0x0000004f2a2a7210ULL, 0x000fe20007f9e0ffULL,
0x000000104a517824ULL, 0x000fe200078e021dULL, 0x000000204c4a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200018e062bULL, 0x0000001c5000720cULL, 0x000fe20003f26070ULL,
0x000000ffff2b7224ULL, 0x000fe200020e0612ULL, 0x000000284c4e7810ULL, 0x000fe20007ffe0ffULL,
0x000000014a127824ULL, 0x000fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016137faeULL, 0x0003e2000c101c46ULL, 0x000000304c507810ULL, 0x000fc40007ffe0ffULL,
0x0000001c5200720cULL, 0x080fe40003f86070ULL, 0x000000384c4c7810ULL, 0x000fe40007ffe0ffULL,
0x0000001c4a00720cULL, 0x080fe40003f66070ULL, 0x0000000020497faeULL, 0x0005e2000c901c46ULL,
0x0000001c5000720cULL, 0x000fe20003f26070ULL, 0x000000044c537824ULL, 0x000fe200078e00ffULL,
0x000000124d137210ULL, 0x002fe20007f1e0ffULL, 0x0000000452177824ULL, 0x000fe200078e00ffULL,
0x000000002a517faeULL, 0x0003e2000d101c46ULL, 0x0000004f29127210ULL, 0x000fc40007fbe0ffULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x0000001c4e00720cULL, 0x080fe40003f46070ULL,
0x0000001c4c00720cULL, 0x040fe20003f06070ULL, 0x000000014c1c7824ULL, 0x100fe200078e024bULL,
0x00005e0013207a11ULL, 0x004fe400078c48ffULL, 0xfffffffc172a7812ULL, 0x002fe200078ee214ULL,
0x0000000150177824ULL, 0x100fe200078e024bULL, 0x00005f00132b7a11ULL, 0x000fe200030f4c16ULL,
0x000000014e167824ULL, 0x000fc400078e024bULL, 0x000000044a4b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe200028e0648ULL, 0x000000164d297210ULL, 0x000fe20007fbe0ffULL,
0x000000102a497824ULL, 0x000fe200078e021dULL, 0xfffffffc4b167812ULL, 0x000fe200078ee214ULL,
0x0000000450517824ULL, 0x000fc600078e00ffULL, 0x0000000012497faeULL, 0x0003e2000e101c46ULL,
0x000000174d217210ULL, 0x040fe40007f9e0ffULL, 0x0000001c4d177210ULL, 0x000fe20007fde0ffULL,
0x000000044e4d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc512a7812ULL, 0x000fc800078ee214ULL,
0xfffffffc4d1c7812ULL, 0x100fe200078ee214ULL, 0x000000102a4d7824ULL, 0x100fe200078e021dULL,
0xfffffffc53147812ULL, 0x000fe200078ee214ULL, 0x0000001016497824ULL, 0x102fe400078e021dULL,
0x000000ffff127224ULL, 0x000fe200028e06ffULL, 0x00005e0029167a11ULL, 0x040fe200078a48ffULL,
0x0000001014517824ULL, 0x100fe400078e021dULL, 0x000000101c4b7824ULL, 0x000fe200078e021dULL,
0x00005f0029297a11ULL, 0x000fe200028f4c12ULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x0000004f20127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff147224ULL, 0x000fe200030e06ffULL,
0x00005e00211c7a11ULL, 0x000fc400078848ffULL, 0x00005e0017207a11ULL, 0x000fe200078c48ffULL,
0x000000ffff137224ULL, 0x000fe200028e062bULL, 0x0000004f16167210ULL, 0x080fe40007fbe0ffULL,
0x00005f00211d7a11ULL, 0x000fe400020f4c2aULL, 0x00005f0017147a11ULL, 0x000fe200030f4c14ULL,
0x000000ffff177224ULL, 0x000fe200028e0629ULL, 0x0000004f1c1c7210ULL, 0x080fe20007f9e0ffULL,
0x0000000012497faeULL, 0x0003e2000d901c46ULL, 0x0000004f20207210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e061dULL, 0x00000000164b7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff217224ULL, 0x000fc600028e0614ULL, 0x000000001c4d7faeULL, 0x0003e8000c901c46ULL,
0x0000000020517faeULL, 0x0003e2000c101c46ULL, 0x0000061000007947ULL, 0x000fea0003800000ULL,
0x0000000828167811ULL, 0x040fe400078ff0ffULL, 0x0000004b28127211ULL, 0x040fe400078ff0ffULL,
0x00000020282a7811ULL, 0x000fe200078ff0ffULL, 0x00000004162b7824ULL, 0x000fe200078e00ffULL,
0x00000010281c7811ULL, 0x000fc400078ff0ffULL, 0x0000001828207811ULL, 0x000fe200078ff0ffULL,
0x000000042a517824ULL, 0x000fe200078e00ffULL, 0x0000002828487811ULL, 0x000fe200078ff0ffULL,
0x000000041c497824ULL, 0x000fe200078e00ffULL, 0x00000030284a7811ULL, 0x000fe200078ff0ffULL,
0x0000000120177824ULL, 0x100fe200078e024bULL, 0x00000038284c7811ULL, 0x000fe200078ff0ffULL,
0x00000004204f7824ULL, 0x000fe200078e00ffULL, 0x000000124d527210ULL, 0x000fe20007f1e0ffULL,
0x0000000116127824ULL, 0x100fe400078e024bULL, 0x000000011c167824ULL, 0x000fc400078e024bULL,
0x000000012a1c7824ULL, 0x100fe200078e024bULL, 0xfffffffc2b2a7812ULL, 0x100fe200078ee214ULL,
0x0000000148207824ULL, 0x140fe200078e024bULL, 0x000000124d127210ULL, 0x000fe20007fde0ffULL,
0x0000000448537824ULL, 0x000fe200078e00ffULL, 0xfffffffc49487812ULL, 0x100fe200078ee214ULL,
0x000000014a217824ULL, 0x140fe200078e024bULL, 0x000000164d167210ULL, 0x000fe20007fbe0ffULL,
0x000000044a557824ULL, 0x000fe200078e00ffULL, 0xfffffffc4f4a7812ULL, 0x100fe200078ee214ULL,
0x000000014c297824ULL, 0x040fe200078e024bULL, 0xfffffffc534e7812ULL, 0x100fe200078ee214ULL,
0x000000044c4b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc514c7812ULL, 0x100fe200078ee214ULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x00005e0052517a11ULL, 0x000fe200078048ffULL,
0x0000001048577824ULL, 0x100fe200078e021dULL, 0xfffffffc55507812ULL, 0x100fe200078ee214ULL,
0x000000102a557824ULL, 0x100fe200078e021dULL, 0xfffffffc4b147812ULL, 0x000fe200078ee214ULL,
0x000000104a597824ULL, 0x000fe200078e021dULL, 0x00005f0052527a11ULL, 0x000fe200000f4c2bULL,
0x000000ffff2b7224ULL, 0x000fe200030e06ffULL, 0x000000174d177210ULL, 0x040fe20007f1e0ffULL,
0x0000001014617824ULL, 0x100fe200078e021dULL, 0x00005e00124f7a11ULL, 0x000fe200078c48ffULL,
0x0000001028147824ULL, 0x000fe200078e00ffULL, 0x0000001c4d1c7210ULL, 0x040fe20007f3e0ffULL,
0x00000010505f7824ULL, 0x100fe200078e021dULL, 0x000000204d207210ULL, 0x040fe20007f5e0ffULL,
0x000000104c5b7824ULL, 0x100fe200078e021dULL, 0x000000214d217210ULL, 0x040fe20007f7e0ffULL,
0x000000104e5d7824ULL, 0x000fe200078e021dULL, 0x000000294d297210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200028e06ffULL, 0x00005f0012507a11ULL, 0x000fe200030f4c2bULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005e00161d7a11ULL, 0x000fe200078a48ffULL,
0x000000ffff497224ULL, 0x000fe200008e06ffULL, 0x00005e00172a7a11ULL, 0x000fe200078048ffULL,
0x000000ffff4b7224ULL, 0x000fe200010e06ffULL, 0x0000003014537812ULL, 0x000fe200078ec0ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x00005e001c487a11ULL, 0x000fc400078248ffULL,
0x00005f00164d7a11ULL, 0x000fe400028f4c4dULL, 0x00005f00172b7a11ULL, 0x000fe200000f4c12ULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x0000005351167210ULL, 0x000fe40007f1e0ffULL,
0x00005f001c497a11ULL, 0x000fe400008f4c49ULL, 0x00005e00204a7a11ULL, 0x000fe200078248ffULL,
0x000000ffff177224ULL, 0x000fe200000e0652ULL, 0x00005e00214c7a11ULL, 0x000fc400078448ffULL,
0x00005e00294e7a11ULL, 0x000fe400078648ffULL, 0x00005f00204b7a11ULL, 0x000fe200008f4c4bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016137faeULL, 0x0003e2000b901c46ULL,
0x000000534f1c7210ULL, 0x080fe40007f1e0ffULL, 0x00005f0021147a11ULL, 0x000fe400010f4c14ULL,
0x000000531d207210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e0650ULL,
0x00005f0029127a11ULL, 0x000fc400018f4c12ULL, 0x000000532a2a7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e064dULL, 0x0000005348487210ULL, 0x080fe20007f7e0ffULL,
0x000000001c557faeULL, 0x0003e2000b901c46ULL, 0x000000534a4a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e062bULL, 0x000000534c4c7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff497224ULL, 0x000fe200018e0649ULL, 0x000000534e4e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200020e064bULL, 0x0000000020577faeULL, 0x0003e2000b901c46ULL,
0x000000ffff4d7224ULL, 0x000fc400028e0614ULL, 0x000000ffff4f7224ULL, 0x000fe200000e0612ULL,
0x000000002a597faeULL, 0x0003e8000b901c46ULL, 0x00000000485b7faeULL, 0x0003e8000b901c46ULL,
0x000000004a5d7faeULL, 0x0003e8000b901c46ULL, 0x000000004c5f7faeULL, 0x0003e8000b901c46ULL,
0x000000004e617faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201f137824ULL, 0x002fe200078e00ffULL, 0x0000001c1e127810ULL, 0x000fc40007ffe0ffULL,
0x0000001e1e1e7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe013127812ULL, 0x040fe400078ee212ULL,
0xffffffe013137812ULL, 0x000fc600078ee21eULL, 0x0000001012127824ULL, 0x000fe400078e00ffULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000114c783bULL, 0x000fe80000000200ULL, 0x000000001248783bULL, 0x000e680000000200ULL,
0x000000001050783bULL, 0x000ea80000000200ULL, 0x000000000f1c783bULL, 0x000ee80000000200ULL,
0x000000000e54783bULL, 0x000f280000000200ULL, 0x000000000d5c783bULL, 0x000fe80000000200ULL,
0x000000001358783bULL, 0x000ee80000000200ULL, 0x000000000b60783bULL, 0x000ee80000000200ULL,
0x000000000264783bULL, 0x000fe20000000200ULL, 0x0000004c4818723cULL, 0x042f700000001818ULL,
0x0000004e482c723cULL, 0x040b64000000182cULL, 0x00000000094c783bULL, 0x020e6c0000000200ULL,
0x000000504830723cULL, 0x044f700000001830ULL, 0x000000524838723cULL, 0x040f700000001838ULL,
0x0000001c483c723cULL, 0x048ff0000000183cULL, 0x0000001e4840723cULL, 0x040ff00000001840ULL,
0x000000544844723cULL, 0x050ff00000001844ULL, 0x000000564834723cULL, 0x000ff00000001834ULL,
0x0000005c5818723cULL, 0x040f700000001818ULL, 0x0000005e582c723cULL, 0x040f70000000182cULL,
0x000000605830723cULL, 0x060f700000001830ULL, 0x000000625838723cULL, 0x000f620000001838ULL,
0x3d80000018187820ULL, 0x000fe20000410000ULL, 0x3d80000019197820ULL, 0x000fe20000410000ULL,
0x3d8000001a1a7820ULL, 0x000fe20000410000ULL, 0x3d8000001b1b7820ULL, 0x000fc80000410000ULL,
0x0000004c583c723cULL, 0x002f62000000183cULL, 0x3d8000002c2c7820ULL, 0x000fe20000410000ULL,
0x3d8000002d2d7820ULL, 0x000fe20000410000ULL, 0x3d8000002e2e7820ULL, 0x000fe20000410000ULL,
0x3d8000002f2f7820ULL, 0x000fc80000410000ULL, 0x0000004e5840723cULL, 0x000f640000001840ULL,
0x3d80000030307820ULL, 0x020fe20000410000ULL, 0x3d80000031317820ULL, 0x000fe20000410000ULL,
0x3d80000032327820ULL, 0x000fe20000410000ULL, 0x3d80000033337820ULL, 0x000fc60000410000ULL,
0x000000645844723cULL, 0x000f620000001844ULL, 0x3d80000038387820ULL, 0x000fe20000410000ULL,
0x3d80000039397820ULL, 0x000fe20000410000ULL, 0x3d8000003a3a7820ULL, 0x000fe20000410000ULL,
0x3d8000003b3b7820ULL, 0x000fc80000410000ULL, 0x000000665834723cULL, 0x000f620000001834ULL,
0x3d8000003c3c7820ULL, 0x000fe20000410000ULL, 0x3d8000003d3d7820ULL, 0x000fe20000410000ULL,
0x3d8000003e3e7820ULL, 0x000fe20000410000ULL, 0x3d8000003f3f7820ULL, 0x000fc80000410000ULL,
0x3d80000040407820ULL, 0x000fe20000410000ULL, 0x3d80000041417820ULL, 0x000fe20000410000ULL,
0x3d80000042427820ULL, 0x000fe20000410000ULL, 0x3d80000043437820ULL, 0x000fca0000410000ULL,
0x3d80000044447820ULL, 0x020fe20000410000ULL, 0x3d80000045457820ULL, 0x000fe20000410000ULL,
0x3d80000046467820ULL, 0x000fe20000410000ULL, 0x3d80000047477820ULL, 0x000fca0000410000ULL,
0x3d80000034347820ULL, 0x000fe20000410000ULL, 0x3d80000035357820ULL, 0x000fe20000410000ULL,
0x3d80000036367820ULL, 0x000fe20000410000ULL, 0x3d80000037377820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000025127f8cULL, 0x0002a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x0000040025097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e097210ULL, 0x000fca0007f1e1ffULL, 0x0000000111107824ULL, 0x000fe200000e0e0fULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011410ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0610ULL, 0x0000000202027819ULL, 0x000fc80000001209ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040025097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000428097824ULL, 0x000fe200078e00ffULL,
0x000000260300720cULL, 0x000fc80003f05270ULL, 0xfffffff0090b7812ULL, 0x000fca00078ec0ffULL,
0x0000008000027824ULL, 0x000fca00078e020bULL, 0x0144000002107984ULL, 0x0004e20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000228037824ULL, 0x000fe400078e00ffULL,
0x0000000104147824ULL, 0x000fc600078e0a23ULL, 0x0000000603037812ULL, 0x000fc800078ec0ffULL,
0x00000001030b7812ULL, 0x040fe400078efcffULL, 0x00000008030d7812ULL, 0x000fe400078efcffULL,
0x000000140b00720cULL, 0x080fe40003f26070ULL, 0x00000010030b7812ULL, 0x000fe400078efcffULL,
0x000000140d00720cULL, 0x080fe40003f06070ULL, 0x000000140b00720cULL, 0x000fc40003fc6070ULL,
0x00000011030d7812ULL, 0x040fe400078efcffULL, 0x00000018030b7812ULL, 0x040fe400078efcffULL,
0x000000140300720cULL, 0x080fe40003f46070ULL, 0x000000140d00720cULL, 0x080fe40003fa6070ULL,
0x000000140b00720cULL, 0x000fe40003f66070ULL, 0x00000009030e7812ULL, 0x000fc400078efcffULL,
0x00000019030d7812ULL, 0x040fe400078efcffULL, 0x00000020030b7812ULL, 0x000fe400078efcffULL,
0xff8000001a1a7808ULL, 0x000fe40005000000ULL, 0xff80000018187808ULL, 0x000fe40005000000ULL,
0xff8000001b1b7808ULL, 0x000fe40004800000ULL, 0xff80000019197808ULL, 0x000fc40004800000ULL,
0x000000140e00720cULL, 0x080fe40003f86070ULL, 0x000000140d00720cULL, 0x080fe40003f46070ULL,
0x000000140b00720cULL, 0x000fe40003f26070ULL, 0x00000021030d7812ULL, 0x040fe400078efcffULL,
0x00000028030b7812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fc40004000000ULL,
0xff8000002c2c7808ULL, 0x000fe40004000000ULL, 0xff8000002f2f7808ULL, 0x000fe40006000000ULL,
0xff8000002d2d7808ULL, 0x000fe40006000000ULL, 0x000000140d00720cULL, 0x080fe40003f06070ULL,
0x000000140b00720cULL, 0x000fe40003f86070ULL, 0x00000029030d7812ULL, 0x000fc400078efcffULL,
0x00000030030b7812ULL, 0x000fe400078efcffULL, 0xff80000032327808ULL, 0x000fe40007000000ULL,
0xff80000030307808ULL, 0x000fe40007000000ULL, 0xff80000033337808ULL, 0x000fe40006800000ULL,
0xff80000031317808ULL, 0x000fe40006800000ULL, 0x000000140d00720cULL, 0x000fc40003fc6070ULL,
0x000000140b00720cULL, 0x000fe40003fa6070ULL, 0x00000031030d7812ULL, 0x040fe400078efcffULL,
0x00000038030b7812ULL, 0x040fe400078efcffULL, 0x0000003903037812ULL, 0x000fe400078efcffULL,
0xff8000003a3a7808ULL, 0x000fe40005800000ULL, 0xff80000038387808ULL, 0x000fc40005800000ULL,
0xff8000003b3b7808ULL, 0x000fe40005000000ULL, 0xff80000039397808ULL, 0x000fe40005000000ULL,
0xff8000003e3e7808ULL, 0x000fe40004800000ULL, 0xff8000003c3c7808ULL, 0x000fe40004800000ULL,
0x000000140d00720cULL, 0x080fe40003f66070ULL, 0x000000140b00720cULL, 0x000fc40003f46070ULL,
0x000000140300720cULL, 0x000fe40003f26070ULL, 0xff8000003f3f7808ULL, 0x000fe40004000000ULL,
0xff8000003d3d7808ULL, 0x000fe40004000000ULL, 0xff80000042427808ULL, 0x000fe40006000000ULL,
0xff80000040407808ULL, 0x000fe40006000000ULL, 0xff80000043437808ULL, 0x000fc40007000000ULL,
0xff80000041417808ULL, 0x000fe40007000000ULL, 0xff80000046467808ULL, 0x000fe40006800000ULL,
0xff80000044447808ULL, 0x000fe40006800000ULL, 0xff80000047477808ULL, 0x000fe40005800000ULL,
0xff80000045457808ULL, 0x000fe40005800000ULL, 0xff80000036367808ULL, 0x000fc40005000000ULL,
0xff80000034347808ULL, 0x000fe40005000000ULL, 0xff80000037377808ULL, 0x000fe40004800000ULL,
0xff80000035357808ULL, 0x000fc40004800000ULL, 0x000000181000720bULL, 0x008fe20003f1e000ULL,
0x0000001fff1d7424ULL, 0x000fe200078e00ffULL, 0x0000001a1100720bULL, 0x000fe20003f3e000ULL,
0xffffffffff1e7424ULL, 0x000fe200078e00ffULL, 0x0000001018107208ULL, 0x000fe40004000000ULL,
0x000000111a0e7208ULL, 0x000fc40004800000ULL, 0x000000191000720bULL, 0x000fe40003f1e000ULL,
0x0000001b0e00720bULL, 0x000fe40003f3e000ULL, 0x0000001019037208ULL, 0x000fe40004000000ULL,
0x0000000e1b0b7208ULL, 0x000fe40004800000ULL, 0x0000002c0300720bULL, 0x000fe40003f1e000ULL,
0x0000002e0b00720bULL, 0x000fc40003f3e000ULL, 0x000000032c0e7208ULL, 0x000fe40004000000ULL,
0x0000000b2e107208ULL, 0x000fe40004800000ULL, 0x0000002d0e00720bULL, 0x000fe40003f1e000ULL,
0x0000002f1000720bULL, 0x000fe40003f3e000ULL, 0x0000000e2d037208ULL, 0x000fe40004000000ULL,
0x000000102f0b7208ULL, 0x000fc40004800000ULL, 0x000000300300720bULL, 0x000fe40003f1e000ULL,
0x000000320b00720bULL, 0x000fe40003f3e000ULL, 0x00000003300e7208ULL, 0x000fe40004000000ULL,
0x0000000b32107208ULL, 0x000fe40004800000ULL, 0x000000310e00720bULL, 0x000fe40003f1e000ULL,
0x000000331000720bULL, 0x000fc40003f3e000ULL, 0x0000000e31037208ULL, 0x000fe40004000000ULL,
0x00000010330b7208ULL, 0x000fe40004800000ULL, 0x000000380300720bULL, 0x000fe40003f1e000ULL,
0x0000003a0b00720bULL, 0x000fe40003f3e000ULL, 0x00000003380e7208ULL, 0x000fe40004000000ULL,
0x0000000b3a107208ULL, 0x000fc40004800000ULL, 0x000000390e00720bULL, 0x000fe40003f1e000ULL,
0x0000003b1000720bULL, 0x000fe40003f3e000ULL, 0x0000000e39037208ULL, 0x000fe40004000000ULL,
0x000000103b0b7208ULL, 0x000fe40004800000ULL, 0x0000003c0300720bULL, 0x000fe40003f1e000ULL,
0x0000003e0b00720bULL, 0x000fc40003f3e000ULL, 0x000000033c0e7208ULL, 0x000fe40004000000ULL,
0x0000000b3e107208ULL, 0x000fe40004800000ULL, 0x0000003d0e00720bULL, 0x000fe40003f1e000ULL,
0x0000003f1000720bULL, 0x000fe40003f3e000ULL, 0x0000000e3d037208ULL, 0x000fe40004000000ULL,
0x000000103f0b7208ULL, 0x000fc40004800000ULL, 0x000000400300720bULL, 0x000fe40003f1e000ULL,
0x000000420b00720bULL, 0x000fe40003f3e000ULL, 0x00000003400e7208ULL, 0x000fe40004000000ULL,
0x0000000b42107208ULL, 0x000fe40004800000ULL, 0x000000410e00720bULL, 0x000fe40003f1e000ULL,
0x000000431000720bULL, 0x000fc40003f3e000ULL, 0x0000000e41037208ULL, 0x000fe40004000000ULL,
0x00000010430b7208ULL, 0x000fe40004800000ULL, 0x000000440300720bULL, 0x000fe40003f1e000ULL,
0x000000460b00720bULL, 0x000fe40003f3e000ULL, 0x00000003440e7208ULL, 0x000fe40004000000ULL,
0x0000000b46107208ULL, 0x000fc40004800000ULL, 0x000000450e00720bULL, 0x000fe40003f1e000ULL,
0x000000471000720bULL, 0x000fe40003f3e000ULL, 0x0000000e45037208ULL, 0x000fe40004000000ULL,
0x00000010470b7208ULL, 0x000fe40004800000ULL, 0x000000340300720bULL, 0x000fe40003f1e000ULL,
0x000000360b00720bULL, 0x000fc40003f3e000ULL, 0x00000003340e7208ULL, 0x000fe40004000000ULL,
0x0000000b36107208ULL, 0x000fe40004800000ULL, 0x000000350e00720bULL, 0x000fe40003f1e000ULL,
0x000000371000720bULL, 0x000fe40003f3e000ULL, 0x0000000e350b7208ULL, 0x000fe40004000000ULL,
0x00000010371c7208ULL, 0x000fe20004800000ULL, 0x000015827f007947ULL, 0x000fec000b800000ULL,
0x0c401f000b037f89ULL, 0x00066400000e0000ULL, 0x000000030b00720bULL, 0x006fc80003f1e000ULL,
0x0000000b03177208ULL, 0x000fe20004000000ULL, 0x000015827f007947ULL, 0x000fea000b800000ULL,
0x0c401f001c037f89ULL, 0x000e6800000e0000ULL, 0x0c401f00120b7f89ULL, 0x008ea800000e0000ULL,
0x0c401f00130e7f89ULL, 0x000ee800000e0000ULL, 0x0c201f0017107f89ULL, 0x000f2200000e0000ULL,
0x000000031c00720bULL, 0x002fc40003f1e000ULL, 0x0000000b1200720bULL, 0x004fe40003f3e000ULL,
0x0000001c03037208ULL, 0x000fe40004000000ULL, 0x000000120b0b7208ULL, 0x000fe40004800000ULL,
0x0000000e1300720bULL, 0x008fe20003f1e000ULL, 0x0c201f0003147f89ULL, 0x000e6600000e0000ULL,
0x000000130e0d7208ULL, 0x000fe20004000000ULL, 0x0c201f000b167f89ULL, 0x000ea200000e0000ULL,
0x000000101700720bULL, 0x010fc60003f1e000ULL, 0x0c201f000d0e7f89ULL, 0x0006e200000e0000ULL,
0x0000001710107208ULL, 0x000fe40004000000ULL, 0x000000140300720bULL, 0x002fe40003f3e000ULL,
0x000000160b00720bULL, 0x004fe40003f5e000ULL, 0x0000000314117208ULL, 0x000fe40004800000ULL,
0x0000000b16127208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b10037820ULL, 0x008fe20000410000ULL,
0x3fb8aa3b110f7820ULL, 0x000fe20000410000ULL, 0x3c003c00ff487424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b2d2d7823ULL, 0x000fe20000010803ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b1b1b7823ULL, 0x000fe2000001080fULL, 0x0000001800187308ULL, 0x000fe20000000800ULL,
0x3c003c00ff497424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b38387823ULL, 0x000fe20000010803ULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001080fULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b3b3b7823ULL, 0x000fe2000001080fULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b41417823ULL, 0x000fe20000010803ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe2000001080fULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b42427823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b43437823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b35037823ULL, 0x000fe20000010803ULL, 0x0000002d002d7308ULL, 0x000ee20000000800ULL,
0x000000181918723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b46467823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b47477823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b36367823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b370f7823ULL, 0x000fe2000001080fULL, 0x0000000328ff7812ULL, 0x000fc4000780c0ffULL,
0x0000001a00137308ULL, 0x0007e20000000800ULL, 0x0000000e0d00720bULL, 0x000fce0003f3e000ULL,
0x0000001b00167308ULL, 0x000ea20000000800ULL, 0x0000002c2d1a723eULL, 0x008fce00000000ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x000000131619723eULL, 0x004fce00000000ffULL, 0x00000030001c7308ULL, 0x000fe20000000800ULL,
0x0000002e2f1b723eULL, 0x008fce00000000ffULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x00000048182c723cULL, 0x000f6e00000018ffULL, 0x00000038001e7308ULL, 0x0023f00000000800ULL,
0x0000003900397308ULL, 0x000ee20000000800ULL, 0x0000001c311c723eULL, 0x004fc400000000ffULL,
0x0000000c09387812ULL, 0x002fca00078ec0ffULL, 0x00000032001d7308ULL, 0x000ff00000000800ULL,
0x0000003300207308ULL, 0x000e620000000800ULL, 0x0000001e391e723eULL, 0x008fce00000000ffULL,
0x0000003a001f7308ULL, 0x000ff00000000800ULL, 0x0000003b002a7308ULL, 0x000ea20000000800ULL,
0x0000001d201d723eULL, 0x002fce00000000ffULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x0000001f2a1f723eULL, 0x004fce00000000ffULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0x000000481c30723cULL, 0x020b6e000000182cULL, 0x0000004000407308ULL, 0x000ff00000000800ULL,
0x0000004100417308ULL, 0x000ea20000000800ULL, 0x0000003c3d2c723eULL, 0x022fce00000000ffULL,
0x0000003e003e7308ULL, 0x000ff00000000800ULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x00000040412e723eULL, 0x004fce00000000ffULL, 0x0000004200427308ULL, 0x000ff00000000800ULL,
0x0000004300437308ULL, 0x000ea20000000800ULL, 0x0000003e3f2d723eULL, 0x002fce00000000ffULL,
0x0000000300147308ULL, 0x0003e20000000800ULL, 0x00000042432f723eULL, 0x004fce00000000ffULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x00000002ff037819ULL, 0x002fc80000011628ULL,
0x0000000303207810ULL, 0x040fe20007ffe0ffULL, 0x0000000803237824ULL, 0x040fe200078e00ffULL,
0x000000482c30723cULL, 0x000f620000001830ULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0x00000008033a7824ULL, 0x040fe200078e00ffULL, 0x0000000103137810ULL, 0x040fe20007ffe0ffULL,
0x00000008032a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8234a7812ULL, 0x000fe200078ee220ULL,
0x00000008034c7824ULL, 0x040fe200078e00ffULL, 0x0000000203177810ULL, 0x040fe20007ffe0ffULL,
0x00000008033c7824ULL, 0x040fe200078e00ffULL, 0x00000034000b7308ULL, 0x0002a20000000800ULL,
0x0000000403217810ULL, 0x040fe20007ffe0ffULL, 0x00000008033e7824ULL, 0x040fe200078e00ffULL,
0x0000000803237810ULL, 0x040fe20007ffe0ffULL, 0x0000000803407824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fc400078ee213ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x0000004600357308ULL, 0x0007e20000000800ULL, 0x000000444534723eULL, 0x002fe200000000ffULL,
0x0000000823427824ULL, 0x000fe200078e00ffULL, 0x0000000503137810ULL, 0x040fe40007ffe0ffULL,
0xffffffff03217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x0000004700167308ULL, 0x000e620000000800ULL, 0xfffffff82a467812ULL, 0x008fc400078ee217ULL,
0x0000000603177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee203ULL,
0x0000a00000037811ULL, 0x000fe200078e58ffULL, 0x0000003600377308ULL, 0x0005e20000000800ULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee217ULL, 0xfffffff840407812ULL, 0x000fe200078ee221ULL,
0x000000102a097824ULL, 0x000fe200078e0203ULL, 0xfffffff842427812ULL, 0x000fe200078ee223ULL,
0x000000104a137824ULL, 0x000fc400078e0203ULL, 0x0000000f00207308ULL, 0x0007220000000800ULL,
0x0000000b1436723eULL, 0x004fe200000000ffULL, 0x000000103a0b7824ULL, 0x100fe200078e0203ULL,
0x000000351635723eULL, 0x002fe200000000ffULL, 0x000000104c147824ULL, 0x000fe400078e0203ULL,
0x0000000138097824ULL, 0x000fe400078e0209ULL, 0x000000103c167824ULL, 0x100fe400078e0203ULL,
0x00000010460f7824ULL, 0x008fe200078e0203ULL, 0x0000001809007388ULL, 0x0003e20000000800ULL,
0x00000001380b7824ULL, 0x000fc400078e020bULL, 0x000000103e177824ULL, 0x100fe200078e0203ULL,
0x000000372037723eULL, 0x010fe200000000ffULL, 0x0000001040207824ULL, 0x100fe200078e0203ULL,
0x0000001a0b007388ULL, 0x0003e20000000800ULL, 0x0000001042217824ULL, 0x000fe400078e0203ULL,
0x00000001380f7824ULL, 0x040fe400078e020fULL, 0x000000483430723cULL, 0x020f620000001830ULL,
0x0000000138037824ULL, 0x000fe200078e0213ULL, 0x0000000d0e137208ULL, 0x000fe20004800000ULL,
0x0000000138147824ULL, 0x040fe200078e0214ULL, 0x0000001c0f007388ULL, 0x0003e20000000800ULL,
0x0000000138167824ULL, 0x000fc400078e0216ULL, 0x0000000138177824ULL, 0x040fe200078e0217ULL,
0x0000001e03007388ULL, 0x0003e20000000800ULL, 0x0000000138207824ULL, 0x040fe400078e0220ULL,
0x00000001382a7824ULL, 0x000fe200078e0221ULL, 0x0000002c14007388ULL, 0x0003e80000000800ULL,
0x0000002e16007388ULL, 0x0003e80000000800ULL, 0x0000003417007388ULL, 0x0003e80000000800ULL,
0x0000003620007388ULL, 0x0003e20000000800ULL, 0x000000ffff317224ULL, 0x020fc600078e0032ULL,
0x000000192a007388ULL, 0x0003e80000000800ULL, 0x0004001b0b007388ULL, 0x0003e80000000800ULL,
0x0004001d0f007388ULL, 0x0003e80000000800ULL, 0x0004001f03007388ULL, 0x0003e80000000800ULL,
0x0004002d14007388ULL, 0x0003e80000000800ULL, 0x0004002f16007388ULL, 0x0003e80000000800ULL,
0x0004003517007388ULL, 0x0003e80000000800ULL, 0x0004003720007388ULL, 0x0003e80000000800ULL,
0x0140001002008388ULL, 0x0003e80000000c00ULL, 0x0142003002008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146080024ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146100024ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146180024ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000061500720cULL, 0x000fe20003f06070ULL,
0x0146200024ff7f8cULL, 0x0003e4000c80043fULL, 0x000000ffff037224ULL, 0x002fd400078e0015ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff6e4000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff2c7807ULL, 0x008fe40004000000ULL,
0x00019c60002e7802ULL, 0x000fc40000000f00ULL, 0x00000d3000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0038ULL, 0xfffe8b7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2c7807ULL, 0x000fe40005800000ULL, 0x00019cb0002e7802ULL, 0x000fc40000000f00ULL,
0x00000ce000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0038ULL,
0xfffe8bb000007947ULL, 0x000fea000383ffffULL, 0x00019cf0002c7802ULL, 0x000fc40000000f00ULL,
0x00000c6000007944ULL, 0x00efea0003c00000ULL, 0xfffe8c7000007947ULL, 0x000fea000383ffffULL,
0x00019d20002c7802ULL, 0x000fc40000000f00ULL, 0x00000c3000007944ULL, 0x006fea0003c00000ULL,
0xfffe8db000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x000fe200078e000eULL,
0x00019d60002c7802ULL, 0x000fc40000000f00ULL, 0x00000bf000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e002eULL, 0xfffe8f7000007947ULL, 0x000fea000383ffffULL,
0x00019da0002c7802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e002eULL, 0xfffe8f6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x000fe200078e000eULL, 0x00019df0002c7802ULL, 0x000fc40000000f00ULL,
0x00000b6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e002eULL,
0xfffea2c000007947ULL, 0x000fea000383ffffULL, 0x00019e30002c7802ULL, 0x000fc40000000f00ULL,
0x00000b2000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e002eULL,
0xfffea2b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2c7807ULL, 0x008fe40004000000ULL,
0x00019e80002e7802ULL, 0x000fc40000000f00ULL, 0x00000b1000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0038ULL, 0xfffeb87000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2c7807ULL, 0x000fe40005000000ULL, 0x00019ed0002e7802ULL, 0x000fc40000000f00ULL,
0x00000ac000007944ULL, 0x014fea0003c00000ULL, 0xfffeb8c000007947ULL, 0x000fea000383ffffULL,
0x00019f00002c7802ULL, 0x000fc40000000f00ULL, 0x00000a5000007944ULL, 0x014fea0003c00000ULL,
0xfffeb9a000007947ULL, 0x000fea000383ffffULL, 0x00019f30002c7802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x016fea0003c00000ULL, 0xfffebad000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x000fe200078e0034ULL, 0x00019f70002c7802ULL, 0x000fc40000000f00ULL,
0x000009e000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e002eULL,
0xfffebc9000007947ULL, 0x000fea000383ffffULL, 0x00019fb0002c7802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e002eULL,
0xfffebc8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0030ULL,
0x0001a000002c7802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e002eULL, 0xfffecd2000007947ULL, 0x000fea000383ffffULL,
0x0001a040002c7802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e002eULL, 0xfffecd1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2c7807ULL, 0x008fe40004000000ULL, 0x0001a090002e7802ULL, 0x000fc40000000f00ULL,
0x0000090000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff357224ULL, 0x000fe200078e0038ULL,
0xfffee0a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2c7807ULL, 0x000fe40005000000ULL,
0x0001a0e0002e7802ULL, 0x000fc40000000f00ULL, 0x000008b000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff367224ULL, 0x000fe200078e0038ULL, 0xfffee0d000007947ULL, 0x000fea000383ffffULL,
0x0001a120002c7802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x002fea0003c00000ULL,
0xfffee1b000007947ULL, 0x000fea000383ffffULL, 0x0001a150002c7802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x002fea0003c00000ULL, 0xfffee2e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x000fe200078e0034ULL, 0x0001a190002c7802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e002eULL,
0xfffee4a000007947ULL, 0x000fea000383ffffULL, 0x0001a1d0002c7802ULL, 0x000fc40000000f00ULL,
0x0000078000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e002eULL,
0xfffee49000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0030ULL,
0x0001a220002c7802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e002eULL, 0xfffef53000007947ULL, 0x000fea000383ffffULL,
0x0001a260002c7802ULL, 0x000fc40000000f00ULL, 0x000006f000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e002eULL, 0xfffef52000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2c7807ULL, 0x008fe40004000000ULL, 0x0001a2b0002e7802ULL, 0x000fc40000000f00ULL,
0x000006e000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff117224ULL, 0x000fe200078e0038ULL,
0xffff099000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2c7807ULL, 0x000fe40004800000ULL,
0x0001a300002e7802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff347224ULL, 0x000fe200078e0038ULL, 0xffff09c000007947ULL, 0x000fea000383ffffULL,
0x0001a340002c7802ULL, 0x000fc40000000f00ULL, 0x0000061000007944ULL, 0x014fea0003c00000ULL,
0xffff0aa000007947ULL, 0x000fea000383ffffULL, 0x0001a370002c7802ULL, 0x000fc40000000f00ULL,
0x000005e000007944ULL, 0x016fea0003c00000ULL, 0xffff0bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x000fe200078e0012ULL, 0x0001a3b0002c7802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e002eULL,
0xffff0d9000007947ULL, 0x000fea000383ffffULL, 0x0001a3f0002c7802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e002eULL,
0xffff0d8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0012ULL,
0x0001a440002c7802ULL, 0x000fc40000000f00ULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e002eULL, 0xffff1e5000007947ULL, 0x000fea000383ffffULL,
0x0001a480002c7802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e002eULL, 0xffff1e4000007947ULL, 0x000fea000383ffffULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x0001a4d0000e7802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x006fea0003c00000ULL, 0xffffea5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0b7224ULL, 0x008fe200078e001cULL, 0x0001a520000e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fc400078e00ffULL, 0x000003f000007944ULL, 0x000fea0003c00000ULL,
0x000000031c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0012ULL,
0x0001a580000e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fe200078e00ffULL,
0x0000001c03167208ULL, 0x000fc80004000000ULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000031200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0013ULL,
0x0001a5e0000e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fe200078e00ffULL,
0x0000001203127208ULL, 0x000fc80004000000ULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x000000031300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0017ULL,
0x0001a640000e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x00000013030d7208ULL, 0x000fc80004000000ULL, 0x000002d000007944ULL, 0x000fea0003c00000ULL,
0x000000031700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0016ULL,
0x0001a6a0000e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x0000001703107208ULL, 0x000fc80004000000ULL, 0x0000027000007944ULL, 0x000fea0003c00000ULL,
0x000000031600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0012ULL,
0x0001a700000e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x0000001603117208ULL, 0x000fc80004000000ULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000031200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e000dULL,
0x0001a760000e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x0000001203127208ULL, 0x000fc80004000000ULL, 0x000001b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0003ULL, 0xffffe91000007947ULL, 0x000fea000383ffffULL,
0x018000000b047810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000004057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000b00048308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff047807ULL, 0x004fc80004000000ULL,
0x0000000405ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0bff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000405ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000b057812ULL, 0x000fd600078ec0ffULL,
0x0080000005040812ULL, 0x000fe200078efcffULL, 0x000000ffff048224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000b00047308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x00cfe400078e0004ULL,
0x000000ffff047224ULL, 0x000fe400078e0006ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe56f004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001e00007348ULL, 0x000fe80003800000ULL, 0x0c0000140b037389ULL, 0x0002a200000e001dULL,
0xfffe56b00e007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000007500007348ULL, 0x000fe80003800000ULL, 0x0000002e6b2e7389ULL, 0x0002a200000e0076ULL,
0xfffe56702c007950ULL, 0x000fea0003c3ffffULL, 0x000000012c00780cULL, 0x000fe20003f65070ULL,
0x0000002b00007348ULL, 0x000fe80003800000ULL, 0x00000000ff2d7424ULL, 0x000fd000078e00ffULL,
0x00000000002c7806ULL, 0x000fc800058e0100ULL, 0x0000002b2c387212ULL, 0x000fe200078ec0ffULL,
0x000000ffff2c7224ULL, 0x000fc800078e002eULL, 0xfffe56002c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000542ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a0ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008f8ULL,
0x0000000000000338ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c30ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cf0ULL,
0x0000000000000670ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001360ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001370ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001400ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001404ULL,
0x00000000000001b0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001600ULL,
0x000000000001ab00ULL, 0x7c00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c100ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c140ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c4c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001400ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001ad00ULL,
0x000000000001ad00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c100ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c4c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_86_cubin_len = 116128;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
