/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c540ULL, 0x000000000001c1c0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45386aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x695f5f2400687461ULL,
0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL, 0x5f636e79736c6668ULL,
0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL,
0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL,
0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL,
0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x2e006d617261705fULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL, 0x0000006e6f697463ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000362ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000003a7ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0022000003edULL,
0x000000000001a8b0ULL, 0x0000000000000190ULL, 0x000b002200000420ULL, 0x000000000001aa40ULL,
0x0000000000000040ULL, 0x000b00220000044bULL, 0x000000000001aa80ULL, 0x0000000000000040ULL,
0x000b002200000475ULL, 0x000000000001aac0ULL, 0x0000000000000140ULL, 0x000a0003000004e3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000503ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000533ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001ac00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001a8b000000000ULL, 0x0000040400000000ULL, 0x810c000001440400ULL, 0x0068d80400288080ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808708288080ULL, 0x80cc082880809b08ULL, 0x08288080d1082880ULL, 0x80808608288080d2ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808692ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0001a8b000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL,
0x8087288080840900ULL, 0x0900000004042880ULL, 0x2880808428808086ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8708288080840828ULL, 0x288080cc08288080ULL, 0x80d208288080d108ULL,
0x162880808c082880ULL, 0x0000031028808280ULL, 0x8c92000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000012000000000ULL, 0x0001aa4000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8708288080860828ULL,
0x288080cc08288080ULL, 0x80d208288080d108ULL, 0x1628808084082880ULL, 0x0000031028808280ULL,
0x8492000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x000001b000000000ULL,
0x0001aa8000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8708288080840828ULL, 0x288080cc08288080ULL, 0x80d208288080d108ULL,
0x1628808086082880ULL, 0x0000031028808280ULL, 0x8692000000000000ULL, 0x0000002200288080ULL,
0x0000002cffffffffULL, 0x0000024000000000ULL, 0x0001aac000000000ULL, 0x0000014000000000ULL,
0x0000180400000000ULL, 0x8084288080860900ULL, 0x0000000000002880ULL, 0x0000001800082f04ULL,
0x000823040000007aULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL,
0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0050016000000015ULL, 0x000c170400501903ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000e001cc2804ULL, 0x0000034000000100ULL, 0x00002890000016a0ULL, 0x00002a1000002920ULL,
0x00002d9000002b80ULL, 0x00002e0000002dc0ULL, 0x0000339000002e40ULL, 0x000041a000004170ULL,
0x00004220000041e0ULL, 0x000057b000004680ULL, 0x0000595000005840ULL, 0x00005cc000005ab0ULL,
0x00005d3000005cf0ULL, 0x0000600000005d70ULL, 0x00006e1000006de0ULL, 0x00006e9000006e50ULL,
0x000082c000007190ULL, 0x0000845000008340ULL, 0x000087c0000085b0ULL, 0x00008830000087f0ULL,
0x00008b0000008870ULL, 0x00009910000098e0ULL, 0x0000999000009950ULL, 0x0000adc000009c90ULL,
0x0000af500000ae40ULL, 0x0000b2c00000b0b0ULL, 0x0000b3300000b2f0ULL, 0x0000b6300000b370ULL,
0x0000c4400000c410ULL, 0x0000c4c00000c480ULL, 0x0000c9900000c980ULL, 0x0000eae00000d0f0ULL,
0x0000f1500000eb40ULL, 0x0000f8200000f190ULL, 0x000190b000019070ULL, 0x000190d0000190c0ULL,
0x0001914000019120ULL, 0x0001917000019160ULL, 0x00019df000019da0ULL, 0x00019e6000019e30ULL,
0x00019ee000019ea0ULL, 0x00019f7000019f30ULL, 0x0001a01000019fc0ULL, 0x0001a0700001a040ULL,
0x0001a0f00001a0b0ULL, 0x0001a1800001a140ULL, 0x0001a2200001a1d0ULL, 0x0001a2800001a250ULL,
0x0001a3000001a2c0ULL, 0x0001a3900001a350ULL, 0x0001a4300001a3e0ULL, 0x0001a4900001a460ULL,
0x0001a5100001a4d0ULL, 0x0001a5a00001a560ULL, 0x0001a6400001a5f0ULL, 0x0001a7000001a6a0ULL,
0x0001a7c00001a760ULL, 0x0001a8800001a820ULL, 0x000001b002003904ULL, 0x00014600000000ffULL,
0x00000250003f0100ULL, 0x0001460800000003ULL, 0x00000300003f0120ULL, 0x0001468800000003ULL,
0x000004a0003f0120ULL, 0x00014600000000ffULL, 0x00000620003f0107ULL, 0x0001468c00000048ULL,
0x000006c0003f0102ULL, 0x0001468800000048ULL, 0x000025b0003f0101ULL, 0x0001460800000048ULL,
0x000025d0003f0101ULL, 0x0001460c00000048ULL, 0x000027a0003f0105ULL, 0x0001460c00000048ULL,
0x00004640003f0105ULL, 0x00014688000000ffULL, 0x00005530003f0101ULL, 0x0001462800000048ULL,
0x00005550003f0101ULL, 0x0001462c00000048ULL, 0x00005720003f0105ULL, 0x0001462c00000048ULL,
0x00007160003f0105ULL, 0x00014690000000ffULL, 0x00008040003f0101ULL, 0x0001464800000048ULL,
0x00008060003f0101ULL, 0x0001464c00000048ULL, 0x00008230003f0105ULL, 0x0001464c00000048ULL,
0x00009c60003f0105ULL, 0x00014698000000ffULL, 0x0000ab40003f0101ULL, 0x0001466800000048ULL,
0x0000ab60003f0101ULL, 0x0001466c00000048ULL, 0x0000ad30003f0105ULL, 0x0001466c00000048ULL,
0x0000c790003f0105ULL, 0x000146a0000000ffULL, 0x0000fba0003f0101ULL, 0x00014600000000ffULL,
0x00010980003f0101ULL, 0x00014604000000ffULL, 0x00010b50003f0105ULL, 0x00014604000000ffULL,
0x00018580003f0105ULL, 0x0000000000000021ULL, 0x000185a0003f0101ULL, 0x0000000400000021ULL,
0x00018770003f0105ULL, 0x0000000400000021ULL, 0x00019c00003f0105ULL, 0x000146080000001eULL,
0x00019c60003f0101ULL, 0x000146100000001eULL, 0x00019cc0003f0101ULL, 0x000146180000001eULL,
0x00019d30003f0101ULL, 0x000146200000001eULL, 0x00033803003f0101ULL, 0x0000faa000101c04ULL,
0x00010c4000010bb0ULL, 0x0000040100019d70ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002bcULL,
0x0000001800000002ULL, 0x000000000000022cULL, 0x0000001800000002ULL, 0x000000000000019cULL,
0x0000001800000002ULL, 0x00000000000000f4ULL, 0x0000001800000002ULL, 0x0000000000000044ULL,
0x0000001800000002ULL, 0x0000000000000296ULL, 0x0000001800000002ULL, 0x0000000000000206ULL,
0x0000001800000002ULL, 0x0000000000000176ULL, 0x0000001800000002ULL, 0x00000000000000d0ULL,
0x0000001800000002ULL, 0x0000000000014700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00000000000d7919ULL, 0x000ea20000002300ULL, 0x0000001300097300ULL, 0x000ee200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000027919ULL, 0x000ea20000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x00000000000a7919ULL, 0x000ee20000000000ULL,
0x0000001300147309ULL, 0x0008a60000000000ULL, 0x0000000000107919ULL, 0x000f280000002600ULL,
0x0000000000237919ULL, 0x000f220000002700ULL, 0x00000005ff007819ULL, 0x002fcc0000011603ULL,
0x00001fff00007589ULL, 0x000fe200000e0000ULL, 0x000001000d027a24ULL, 0x004fc600078e0202ULL,
0x00001fff0d0d7589ULL, 0x000e6200000e0000ULL, 0x0000000002037a24ULL, 0x000fe200078e0203ULL,
0x0000000a0900720cULL, 0x008fe40003f02070ULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x000000ff0300720cULL, 0x040fe40003f25270ULL, 0x0000000f0300780cULL, 0x040fe40003f44070ULL,
0x0000007f0300780cULL, 0x000fd20003f64070ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x000000040d087824ULL, 0x002fe400078e0200ULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x01460004ff009388ULL, 0x0003e20000000a00ULL,
0x000000030300780cULL, 0x000fe20003f24070ULL, 0x0000000208097824ULL, 0x000fe400078e00ffULL,
0x0000000810087824ULL, 0x010fc400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x0000000109117810ULL, 0x040fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x044fe400078e0202ULL,
0x00000020090f7824ULL, 0x040fe200078e00ffULL, 0x0000000809047817ULL, 0x002fe20007800000ULL,
0x0000000523087c24ULL, 0x000fe2000f8e0208ULL, 0x014608060300a388ULL, 0x0003e20000008a00ULL,
0xff317217ff12b424ULL, 0x000fe200078e00ffULL, 0xffffffe00f0f7812ULL, 0x000fe200078ee20aULL,
0x00000001040c7824ULL, 0x000fe200078e0a09ULL, 0x00000000000579c3ULL, 0x000ea20000002500ULL,
0x3fffff60ff0a9424ULL, 0x000fe200078e00ffULL, 0x014400120300b388ULL, 0x000fe20000004800ULL,
0x7fffff60ff0b9424ULL, 0x000fe200078e00ffULL, 0x000000010c00780cULL, 0x000fe20003f43070ULL,
0x00000010020e7824ULL, 0x000fc400078e00ffULL, 0x0000000108047824ULL, 0x000fe200078e0209ULL,
0x0146880a03009388ULL, 0x000fe20000008a00ULL, 0x00000200ff077424ULL, 0x002fe200078e00ffULL,
0x000001f00e137812ULL, 0x000fe200078ec0ffULL, 0x0000000108067824ULL, 0x000fe200078e0211ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00005c0004047625ULL, 0x000fe200078e0007ULL,
0x000000ff0c00720cULL, 0x000fc60003f23070ULL, 0x00005c0006067625ULL, 0x000fe200078e0007ULL,
0x0000001304087210ULL, 0x000fc60007f7e0ffULL, 0x0000000111097824ULL, 0x040fe200078e0202ULL,
0x0000001306067210ULL, 0x000fe20007f9e0ffULL, 0x0000002011127824ULL, 0x000fe400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200020e0607ULL,
0xffffffe012037812ULL, 0x000fe200078ee209ULL, 0x000000ffff097224ULL, 0x000fe400018e0605ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0a14ULL, 0x00000010030b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c901c46ULL,
0x00000004ff117424ULL, 0x000fe400078e00ffULL, 0x00000005ff037e24ULL, 0x004fe2000f8e00ffULL,
0x00000000060b7faeULL, 0x0003e2000d101c46ULL, 0x0000620023047625ULL, 0x000fc600078e0011ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0146040affff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604447981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fc40003f05270ULL,
0x0000003f44457810ULL, 0x044fe40007ffe0ffULL, 0x000000ff44467810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff457819ULL, 0x000fe40000011645ULL, 0x00000008ff467819ULL, 0x000fca0000011646ULL,
0x0000f52000008947ULL, 0x000fea0003800000ULL, 0x0000000403477824ULL, 0x000fe400078e00ffULL,
0x0000000800487824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x002fe200078e00ffULL,
0x000000454700720cULL, 0x000fe20003f06070ULL, 0xffffffffff497424ULL, 0x000fd800078e00ffULL,
0x0000640047058a10ULL, 0x000fe20007ffe0ffULL, 0x0000000223048824ULL, 0x000fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fe200078e0205ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01468c0748ff738cULL, 0x0003e20000000000ULL, 0x0000600004048625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000604498981ULL, 0x000ea2000c1e1900ULL,
0x0000000103077810ULL, 0x002fe20007ffe0ffULL, 0x00000040104a7824ULL, 0x000fe400078e00ffULL,
0x0146880048ff7f8cULL, 0x0003e2000c80043fULL, 0x000000460700720cULL, 0x000fe20003f06070ULL,
0x0000580049067a24ULL, 0x004fc800078e02ffULL, 0x0000004006217824ULL, 0x000fd000078e00ffULL,
0x0000073000008947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x002fe20000011602ULL,
0x0000010003057824ULL, 0x000fc600078e00ffULL, 0x00000004090d7810ULL, 0x040fe40007ffe0ffULL,
0x00000008090f7810ULL, 0x040fe40007ffe0ffULL, 0x0000001009137810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x100fe200078e0202ULL, 0x00000014091b7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0b7824ULL, 0x000fe200078e00ffULL, 0x0000000544047217ULL, 0x000fe20007800000ULL,
0x000000010f077824ULL, 0x000fe200078e0202ULL, 0x0000000c09117810ULL, 0x000fe20007ffe0ffULL,
0x000000080f187824ULL, 0x000fe200078e00ffULL, 0xfffffff80b167812ULL, 0x000fe200078ee206ULL,
0x0000004010067824ULL, 0x000fe200078e0209ULL, 0x0000001c091f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008131c7824ULL, 0x040fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee207ULL,
0x0000000113077824ULL, 0x100fe200078e0202ULL, 0x00000006210b7210ULL, 0x000fe20007f1e0ffULL,
0x000000011b0a7824ULL, 0x140fe200078e0202ULL, 0x00000014060e7810ULL, 0x000fe20007ffe0ffULL,
0x000000081b157824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL,
0x0000000104087824ULL, 0x000fe200078e0a05ULL, 0x0000000406077810ULL, 0x040fe20007ffe0ffULL,
0x0000000111057824ULL, 0x000fe200078e0202ULL, 0xfffffff8151e7812ULL, 0x000fe200078ee20aULL,
0x00000008111a7824ULL, 0x000fe200078e00ffULL, 0x00000008060a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005e000b047a11ULL, 0x000fc400078048ffULL,
0x0000000721077210ULL, 0x000fe40007f9e0ffULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee205ULL,
0x00005f000b057a11ULL, 0x000fe400000f4c0cULL, 0x0000000a21177210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200020e06ffULL, 0x0000000c060b7810ULL, 0x040fe40007ffe0ffULL,
0x00000010060c7810ULL, 0x000fc40007ffe0ffULL, 0x0000001806107810ULL, 0x040fe40007ffe0ffULL,
0x0000001c06147810ULL, 0x000fe40007ffe0ffULL, 0x00005e0007067a11ULL, 0x000fe400078c48ffULL,
0x0000000b21157210ULL, 0x000fe20007f1e0ffULL, 0x000000081f0b7824ULL, 0x000fe200078e00ffULL,
0x00005f0007077a11ULL, 0x000fe200030f4c0aULL, 0x000000011f0a7824ULL, 0x000fe200078e0202ULL,
0x00000018091d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c21267210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0xfffffff80b227812ULL, 0x000fe200078ee20aULL,
0x00000001090a7824ULL, 0x100fe200078e0202ULL, 0x0000000e21247210ULL, 0x000fe20007f7e0ffULL,
0x000000011d127824ULL, 0x000fe200078e0202ULL, 0x0000001021257210ULL, 0x000fe20007fbe0ffULL,
0x000000081d197824ULL, 0x000fe200078e00ffULL, 0x0000001421217210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x0000002008147817ULL, 0x000fc40003800000ULL,
0x00005e0017087a11ULL, 0x000fe400078c48ffULL, 0x000000070a0b7812ULL, 0x000fe400078ec0ffULL,
0x000000140900720cULL, 0x000fe40003f46070ULL, 0xfffffff819207812ULL, 0x000fe200078ee212ULL,
0x0000000800197824ULL, 0x000fe200078e00ffULL, 0x00005f0017097a11ULL, 0x000fe400030f4c0cULL,
0x00005e00150a7a11ULL, 0x000fc400078c48ffULL, 0x0000c00000177811ULL, 0x000fe400078e68ffULL,
0x0ffffff80b0c7812ULL, 0x000fe400078ef802ULL, 0x00005f00150b7a11ULL, 0x000fe400030f4c0eULL,
0x000000140d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0xfffffff819157812ULL, 0x000fe200078ee202ULL, 0x000000100c197824ULL, 0x000fe200078e0217ULL,
0x00005e00260c7a11ULL, 0x000fc400078c48ffULL, 0x000000140f00720cULL, 0x080fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200018e06ffULL, 0x00005f00260d7a11ULL, 0x000fe200030f4c0dULL,
0x0000001015047825ULL, 0x000fe200078e0004ULL, 0x00005e00240e7a11ULL, 0x040fe400078c48ffULL,
0x000000141100720cULL, 0x000fe20003f66070ULL, 0x000000ffff267224ULL, 0x000fe200028e06ffULL,
0x00005f00240f7a11ULL, 0x000fe200030f4c0fULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005e0025107a11ULL, 0x000fe200078a48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004197faeULL, 0x0003e2000d101c46ULL, 0x00005e0021127a11ULL, 0x000fc400078c48ffULL,
0x000000141300720cULL, 0x080fe40003f46070ULL, 0x000000141b00720cULL, 0x080fe20003f86070ULL,
0x00000010181b7824ULL, 0x100fe200078e0217ULL, 0x00005f0025117a11ULL, 0x000fe200028f4c26ULL,
0x0000001020257824ULL, 0x100fe200078e0217ULL, 0x000000141d00720cULL, 0x080fe20003fa6070ULL,
0x000000101a1d7824ULL, 0x100fe200078e0217ULL, 0x00005f0021137a11ULL, 0x000fe200030f4c24ULL,
0x0000001016197824ULL, 0x002fe200078e0217ULL, 0x000000141f00720cULL, 0x000fe20003fc6070ULL,
0x0000001015047825ULL, 0x000fc800078e0006ULL, 0x0000001015067825ULL, 0x040fe200078e0008ULL,
0x0000000004197faeULL, 0x0003e6000c101c46ULL, 0x0000001015087825ULL, 0x040fe200078e000aULL,
0x00000000061b7faeULL, 0x0003e6000c901c46ULL, 0x000000101c1f7824ULL, 0x000fe200078e0217ULL,
0x00000000081d7faeULL, 0x0003e2000d901c46ULL, 0x00000010150a7825ULL, 0x000fc800078e000cULL,
0x000000101e217824ULL, 0x000fe200078e0217ULL, 0x000000000a1f7faeULL, 0x0003e2000d101c46ULL,
0x00000010150c7825ULL, 0x000fc800078e000eULL, 0x00000010150e7825ULL, 0x040fe200078e0010ULL,
0x000000000c217faeULL, 0x0003e6000e101c46ULL, 0x0000001022177824ULL, 0x000fe200078e0217ULL,
0x000000000e257faeULL, 0x0003e2000e901c46ULL, 0x0000001015107825ULL, 0x000fca00078e0012ULL,
0x0000000010177faeULL, 0x0003e2000f101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000000402077811ULL, 0x002fe200078fe8ffULL, 0x0000000800297824ULL, 0x000fe200078e00ffULL,
0x0000000c020d7811ULL, 0x040fe400078fe8ffULL, 0x00000008020b7811ULL, 0x040fe200078fe8ffULL,
0x0000000107047824ULL, 0x140fe200078e0202ULL, 0x0000001402117811ULL, 0x040fe200078fe8ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000001802137811ULL, 0x000fe200078fe8ffULL,
0x000000010d067824ULL, 0x040fe200078e0202ULL, 0x0000c00000257811ULL, 0x000fe200078e68ffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee204ULL,
0x000000010b057824ULL, 0x040fe200078e0202ULL, 0x0000004a02047211ULL, 0x040fe200078fe8ffULL,
0x000000080b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0c7812ULL, 0x000fe200078ee206ULL,
0x0000000111067824ULL, 0x140fe200078e0202ULL, 0x00000010020f7811ULL, 0x000fe200078fe8ffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0x0000000421147210ULL, 0x000fe20007f1e0ffULL,
0x0000000113087824ULL, 0x100fe200078e0202ULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee205ULL,
0x000000010f057824ULL, 0x000fe200078e0202ULL, 0xfffffff817107812ULL, 0x000fe200078ee206ULL,
0x000000080f0e7824ULL, 0x000fe200078e00ffULL, 0x0000000202067211ULL, 0x000fe200078fe8ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0014047a11ULL, 0x000fe200078048ffULL,
0x0000000813197824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee205ULL,
0x000000014a077824ULL, 0x000fe200078e0207ULL, 0x00005f0014057a11ULL, 0x000fe200000f4c15ULL,
0x000000014a0d7824ULL, 0x000fe200078e020dULL, 0x0000001c02157811ULL, 0x000fe200078fe8ffULL,
0x000000014a0f7824ULL, 0x040fe200078e020fULL, 0xfffffff819127812ULL, 0x000fe200078ee208ULL,
0x000000014a0b7824ULL, 0x040fe200078e020bULL, 0x0000000721177210ULL, 0x040fe20007fde0ffULL,
0x000000014a117824ULL, 0x040fe200078e0211ULL, 0x0000000d21147210ULL, 0x040fe20007f9e0ffULL,
0x000000014a137824ULL, 0x040fe200078e0213ULL, 0x0000000f210d7210ULL, 0x000fe20007f7e0ffULL,
0x000000014a087824ULL, 0x000fe200078e0215ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x00000008151a7824ULL, 0x000fe200078e00ffULL, 0x0000000b21167210ULL, 0x000fe20007fbe0ffULL,
0x00000001150b7824ULL, 0x100fe200078e0202ULL, 0x00000011210f7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x0000001321117210ULL, 0x040fe20007f5e0ffULL,
0x000000100a197824ULL, 0x100fe200078e0225ULL, 0x0000000821137210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff277224ULL, 0x000fe200020e06ffULL, 0x00005e0017067a11ULL, 0x000fe200078c48ffULL,
0x000000100c1b7824ULL, 0x100fe200078e0225ULL, 0x0ffffff807087812ULL, 0x000fe200078ef802ULL,
0x000000100e1d7824ULL, 0x000fe200078e0225ULL, 0xfffffff81a0b7812ULL, 0x000fe200078ee20bULL,
0x00000010101f7824ULL, 0x100fe200078e0225ULL, 0x00005f0017077a11ULL, 0x000fe200030f4c18ULL,
0x0000001009177824ULL, 0x100fe200078e0225ULL, 0x00005e00140a7a11ULL, 0x000fe200078848ffULL,
0x0000001008157824ULL, 0x000fc400078e0225ULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0x00005e0016087a11ULL, 0x000fe200078a48ffULL, 0x0000001012217824ULL, 0x100fe400078e0225ULL,
0x000000100b257824ULL, 0x000fe200078e0225ULL, 0x00005f00140b7a11ULL, 0x000fe200020f4c27ULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x00005f0016097a11ULL, 0x000fe200028f4c09ULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0xfffffff829277812ULL, 0x000fe200078ee202ULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078648ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078048ffULL,
0x0000001027047825ULL, 0x000fe200078e0004ULL, 0x00005e0011107a11ULL, 0x000fc400078448ffULL,
0x00005e0013127a11ULL, 0x000fe200078248ffULL, 0x0000001027067825ULL, 0x000fe200078e0006ULL,
0x00005f000d0d7a11ULL, 0x000fe200018f4c1aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e2000b901c46ULL, 0x00005f000f0f7a11ULL, 0x000fe200000f4c18ULL,
0x0000001027087825ULL, 0x000fe200078e0008ULL, 0x00005f0011117a11ULL, 0x000fe200010f4c16ULL,
0x0000000006177faeULL, 0x0003e2000b901c46ULL, 0x00005f0013137a11ULL, 0x000fe200008f4c14ULL,
0x00000010270a7825ULL, 0x040fe400078e000aULL, 0x0000000008197faeULL, 0x0003e4000b901c46ULL,
0x00000010270c7825ULL, 0x000fc400078e000cULL, 0x000000000a1b7faeULL, 0x0003e4000b901c46ULL,
0x00000010270e7825ULL, 0x040fe400078e000eULL, 0x000000000c1d7faeULL, 0x0003e4000b901c46ULL,
0x0000001027107825ULL, 0x040fe400078e0010ULL, 0x000000000e1f7faeULL, 0x0003e4000b901c46ULL,
0x0000001027127825ULL, 0x000fc400078e0012ULL, 0x0000000010217faeULL, 0x0003e8000b901c46ULL,
0x0000000012257faeULL, 0x0003e4000b901c46ULL, 0x000000460300720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff6a7424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x002fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000b20000000947ULL, 0x000fea0003800000ULL,
0x0000000223047824ULL, 0x000fe400078e00ffULL, 0x00006400ff4d7624ULL, 0x000fc400078e00ffULL,
0x0000001fff6b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4c7424ULL, 0x000fe400078e00ffULL,
0x00006400044d7624ULL, 0x000fe400078e024dULL, 0xff317217ff6a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fc400078e00ffULL, 0x0000010003057824ULL, 0x020fca00078e00ffULL,
0x000000440500720cULL, 0x000fda0003f06070ULL, 0x0000b12000000947ULL, 0x000fea0003800000ULL,
0x0000000103057810ULL, 0x000fe20007ffe0ffULL, 0x0000580049497a24ULL, 0x000fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000460500720cULL, 0x000fe20003f26070ULL,
0x0000004049237824ULL, 0x000fd800078e00ffULL, 0x0000074000009947ULL, 0x000fea0003800000ULL,
0x0000002003057811ULL, 0x000fe400078e40ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x000000204a0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000544047217ULL, 0x000fe40007800000ULL,
0x000000040f337810ULL, 0x040fe20007ffe0ffULL, 0x000000010f077824ULL, 0x040fe200078e020cULL,
0x000000080f3b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104067824ULL, 0x000fe200078e0a05ULL,
0x0000000c0f3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000833107824ULL, 0x000fe200078e00ffULL,
0x0000000723057210ULL, 0x000fe20007f1e0ffULL, 0x0000000133077824ULL, 0x100fe200078e0202ULL,
0x0000002006307817ULL, 0x000fe20003800000ULL, 0x000000013b0d7824ULL, 0x100fe200078e0202ULL,
0x000000100f437810ULL, 0x000fe20007ffe0ffULL, 0x000000083b127824ULL, 0x000fe200078e00ffULL,
0xfffffff810397812ULL, 0x000fe200078ee207ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x0000000702077812ULL, 0x000fe200078ec0ffULL, 0x000000013f107824ULL, 0x140fe200078e0202ULL,
0xfffffff8123d7812ULL, 0x000fe200078ee20dULL, 0x000000083f417824ULL, 0x000fe200078e00ffULL,
0x00005e0005047a11ULL, 0x000fe200078048ffULL, 0x0000000148317824ULL, 0x000fe200078e0207ULL,
0x000000140f4f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010f077824ULL, 0x000fe200078e0202ULL,
0x00005f0005057a11ULL, 0x000fe200000f4c0eULL, 0x0000000143117824ULL, 0x000fe200078e0202ULL,
0x000000300f00720cULL, 0x000fe20003f06070ULL, 0x0000000843207824ULL, 0x000fe200078e00ffULL,
0x00000007070d7812ULL, 0x000fe200078ec0ffULL, 0x0000000133077824ULL, 0x000fe200078e020cULL,
0x0000d00000327811ULL, 0x000fe200078e68ffULL, 0x000000014f127824ULL, 0x100fe200078e0202ULL,
0x0ffffff80d0d7812ULL, 0x000fe200078ef802ULL, 0x000000084f537824ULL, 0x000fe200078e00ffULL,
0x0000000723077210ULL, 0x000fe20007f5e0ffULL, 0x0000001031047825ULL, 0x000fe200078e0004ULL,
0x000000180f557810ULL, 0x000fc40007ffe0ffULL, 0x0000001c0f597810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x00005e0007067a11ULL, 0x000fe200078448ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0232ULL, 0xfffffff841417812ULL, 0x000fe200078ee210ULL,
0x000000013f0f7824ULL, 0x000fe200078e020cULL, 0x00005f0007077a11ULL, 0x000fe200010f4c0eULL,
0x000000013b0e7824ULL, 0x000fe200078e020cULL, 0xfffffff820497812ULL, 0x000fe200078ee211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000c101c46ULL,
0xfffffff853537812ULL, 0x000fe200078ee212ULL, 0x0000000143107824ULL, 0x100fe200078e020cULL,
0x0000000e23227210ULL, 0x000fe20007f5e0ffULL, 0x000000014f117824ULL, 0x100fe200078e020cULL,
0x0000000f230f7210ULL, 0x000fe20007f7e0ffULL, 0x0000000155127824ULL, 0x100fe200078e020cULL,
0x0000001023207210ULL, 0x000fe20007f1e0ffULL, 0x00000001590e7824ULL, 0x040fe200078e020cULL,
0x00005e00220c7a11ULL, 0x040fe200078c48ffULL, 0x0000000159107824ULL, 0x100fe200078e0202ULL,
0x0000001123137210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff057224ULL, 0x002fe200010e06ffULL,
0x0000001223217210ULL, 0x000fe20007fbe0ffULL, 0x00000008595b7824ULL, 0x000fe200078e00ffULL,
0x0000000e23237210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff047224ULL, 0x000fe200018e06ffULL,
0x00005f00220d7a11ULL, 0x000fe200030f4c05ULL, 0x0000000155057824ULL, 0x000fe200078e0202ULL,
0x00005e000f0e7a11ULL, 0x000fe200078c48ffULL, 0x0000000855127824ULL, 0x000fe200078e00ffULL,
0x000000303300720cULL, 0x000fe20003f66070ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee210ULL, 0x0000001039337824ULL, 0x000fe200078e0232ULL,
0x00005f000f0f7a11ULL, 0x000fe200030f4c04ULL, 0x000000ffff387224ULL, 0x000fe200028e06ffULL,
0x00005e0020107a11ULL, 0x000fe200078c48ffULL, 0x0000001041397824ULL, 0x000fe200078e0232ULL,
0xfffffff812577812ULL, 0x000fe200078ee205ULL, 0x0000001031047825ULL, 0x000fe200078e0006ULL,
0x00005f0020117a11ULL, 0x000fc400030f4c11ULL, 0x00005e0013127a11ULL, 0x000fe200078c48ffULL,
0x000000ffff067224ULL, 0x000fe200020e06ffULL, 0x00005e0021207a11ULL, 0x000fe200078a48ffULL,
0x0000000004337faeULL, 0x0003e2000d901c46ULL, 0x000000303b00720cULL, 0x080fe20003f06070ULL,
0x00000010493b7824ULL, 0x000fe200078e0232ULL, 0x00005f0013137a11ULL, 0x000fe200030f4c06ULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x00005e0023227a11ULL, 0x000fe200078c48ffULL,
0x000000105b417824ULL, 0x100fe200078e0232ULL, 0x000000303f00720cULL, 0x080fe20003f66070ULL,
0x00000010573f7824ULL, 0x000fe200078e0232ULL, 0x000000304300720cULL, 0x000fc40003f86070ULL,
0x000000304f00720cULL, 0x080fe20003f46070ULL, 0x000000103d337824ULL, 0x002fe200078e0232ULL,
0x00005f0021217a11ULL, 0x000fe200028f4c38ULL, 0x0000001031047825ULL, 0x000fe200078e000cULL,
0x000000305500720cULL, 0x080fe40003fa6070ULL, 0x00005f0023237a11ULL, 0x000fe200030f4c06ULL,
0x0000001031067825ULL, 0x000fe200078e000eULL, 0x000000305900720cULL, 0x000fe20003fc6070ULL,
0x0000000004337faeULL, 0x0003e4000c101c46ULL, 0x00000010310c7825ULL, 0x000fc400078e0010ULL,
0x0000000006397faeULL, 0x0003e4000d901c46ULL, 0x00000010533d7824ULL, 0x000fe400078e0232ULL,
0x00000010310e7825ULL, 0x040fe200078e0012ULL, 0x000000000c3b7faeULL, 0x0003e6000e101c46ULL,
0x0000001031107825ULL, 0x040fe200078e0020ULL, 0x000000000e3d7faeULL, 0x0003e6000d101c46ULL,
0x0000001031127825ULL, 0x000fe200078e0022ULL, 0x00000000103f7faeULL, 0x0003e8000e901c46ULL,
0x0000000012417faeULL, 0x0003e2000f101c46ULL, 0x0000066000007947ULL, 0x000fea0003800000ULL,
0x0000000402057811ULL, 0x040fe400078fe8ffULL, 0x0000000c02107811ULL, 0x000fc400078fe8ffULL,
0x00000008020f7811ULL, 0x040fe200078fe8ffULL, 0x0000000105047824ULL, 0x140fe200078e0202ULL,
0x0000001002127811ULL, 0x000fe200078fe8ffULL, 0x0000000805337824ULL, 0x000fe200078e00ffULL,
0x000000204a117810ULL, 0x000fe20007ffe0ffULL, 0x00000008103b7824ULL, 0x000fe200078e00ffULL,
0x0000001402207811ULL, 0x000fe200078fe8ffULL, 0x000000010f067824ULL, 0x000fe200078e0202ULL,
0xfffffff833337812ULL, 0x000fe200078ee204ULL, 0x0000000110047824ULL, 0x000fe200078e0202ULL,
0x0000001802217811ULL, 0x000fe200078fe8ffULL, 0x000000080f397824ULL, 0x000fe200078e00ffULL,
0x0000d00000307811ULL, 0x000fe200078e68ffULL, 0x00000008123d7824ULL, 0x040fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee204ULL, 0x0000000105057824ULL, 0x100fe200078e0211ULL,
0xfffffff839397812ULL, 0x000fe200078ee206ULL, 0x0000000112067824ULL, 0x100fe200078e0202ULL,
0x0000001102047211ULL, 0x000fe200078fe8ffULL, 0x00000008203f7824ULL, 0x040fe200078e00ffULL,
0x0000000523077210ULL, 0x000fe20007f5e0ffULL, 0x0000000121137824ULL, 0x000fe200078e0202ULL,
0x00000004230d7210ULL, 0x000fe20007f1e0ffULL, 0x0000000821227824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee206ULL, 0x0000000120067824ULL, 0x000fe200078e0202ULL,
0x0000000702497812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005e000d047a11ULL, 0x000fe200078048ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee206ULL, 0x0000001033337824ULL, 0x100fe200078e0230ULL,
0x00005e0007067a11ULL, 0x000fe200078448ffULL, 0x0000001039397824ULL, 0x000fe200078e0230ULL,
0x00005f000d057a11ULL, 0x000fe200000f4c0eULL, 0x00000001120e7824ULL, 0x000fe200078e0211ULL,
0x00000002020d7211ULL, 0x000fe200078fe8ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0230ULL,
0xfffffff822417812ULL, 0x000fe200078ee213ULL, 0x000000103d3d7824ULL, 0x000fe200078e0230ULL,
0x00005f0007077a11ULL, 0x000fe200010f4c0cULL, 0x000000010f0c7824ULL, 0x100fe200078e0211ULL,
0x0000001c02227811ULL, 0x000fe200078fe8ffULL, 0x00000001200f7824ULL, 0x100fe200078e0211ULL,
0x000000070d137812ULL, 0x000fe200078ec0ffULL, 0x00000001100d7824ULL, 0x100fe200078e0211ULL,
0x0000000e23127210ULL, 0x000fe20007f7e0ffULL, 0x0000000121107824ULL, 0x100fe200078e0211ULL,
0x0ffffff813317812ULL, 0x100fe200078ef802ULL, 0x0000000122117824ULL, 0x040fe200078e0211ULL,
0x0000000d23207210ULL, 0x040fe20007f1e0ffULL, 0x0000000122327824ULL, 0x040fe200078e0202ULL,
0x0000000f23137210ULL, 0x040fe20007f5e0ffULL, 0x0000000822437824ULL, 0x000fe200078e00ffULL,
0x0000000c23227210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e00200e7a11ULL, 0x000fe200078048ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0xfffffff843437812ULL, 0x000fe200078ee232ULL, 0x000000ffff0d7224ULL, 0x000fe200020e06ffULL,
0x0000001023217210ULL, 0x000fe20007f9e0ffULL, 0x0000001031317824ULL, 0x100fe200078e0230ULL,
0x0000001123237210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005e0012107a11ULL, 0x000fe200078648ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0230ULL,
0x00005e00220c7a11ULL, 0x000fe200078c48ffULL, 0x0000001041417824ULL, 0x100fe200078e0230ULL,
0x00005f00200f7a11ULL, 0x000fe200000f4c0fULL, 0x0000001043437824ULL, 0x000fe200078e0230ULL,
0x00005f0012117a11ULL, 0x000fe200018f4c11ULL, 0x000000ffff327224ULL, 0x000fe200020e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078048ffULL, 0x0000000148497824ULL, 0x000fe200078e0249ULL,
0x00005f00220d7a11ULL, 0x000fe200030f4c0dULL, 0x000000ffff307224ULL, 0x000fe200028e06ffULL,
0x00005e0021207a11ULL, 0x000fe200078448ffULL, 0x0000001049047825ULL, 0x000fe200078e0004ULL,
0x00005e0023227a11ULL, 0x000fc400078648ffULL, 0x00005f0013137a11ULL, 0x000fe200000f4c38ULL,
0x0000001049067825ULL, 0x000fe200078e0006ULL, 0x00005f0021217a11ULL, 0x000fe200010f4c32ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004317faeULL, 0x0003e2000b901c46ULL,
0x00005f0023237a11ULL, 0x000fe200018f4c30ULL, 0x00000010490c7825ULL, 0x040fe400078e000cULL,
0x0000000006337faeULL, 0x0003e4000b901c46ULL, 0x00000010490e7825ULL, 0x040fe400078e000eULL,
0x000000000c397faeULL, 0x0003e4000b901c46ULL, 0x0000001049107825ULL, 0x000fc400078e0010ULL,
0x000000000e3b7faeULL, 0x0003e4000b901c46ULL, 0x0000001049127825ULL, 0x040fe400078e0012ULL,
0x00000000103d7faeULL, 0x0003e4000b901c46ULL, 0x0000001049207825ULL, 0x040fe400078e0020ULL,
0x00000000123f7faeULL, 0x0003e4000b901c46ULL, 0x0000001049227825ULL, 0x000fc400078e0022ULL,
0x0000000020417faeULL, 0x0003e8000b901c46ULL, 0x0000000022437faeULL, 0x0003e4000b901c46ULL,
0x00000004ff057424ULL, 0x002fe200078e00ffULL, 0x0000000347067812ULL, 0x000fe200078ec0ffULL,
0x00000300ff047624ULL, 0x000fe400078e00ffULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x000000030600780cULL, 0x000fe20003f05270ULL, 0xfffffffd05047424ULL, 0x000fca00078e0204ULL,
0x0000000104047807ULL, 0x000fca0004000000ULL, 0x0000000147477824ULL, 0x000fca00078e0204ULL,
0x000000454700720cULL, 0x000fda0003f06070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000000147047824ULL, 0x000fc800078e024dULL, 0x0000600004047625ULL, 0x000fca00078e0005ULL,
0x0000000604497981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01460800480c7f8cULL, 0x0004e4000c80043fULL,
0x0000000000047805ULL, 0x002fc40000015200ULL, 0x01460c0048077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x00afe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000f06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01460c0048077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010024e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fe20000011602ULL, 0xffffffffff4f7424ULL, 0x000fc600078e00ffULL,
0x000000704e4e7812ULL, 0x000fe400078ec0ffULL, 0x0000000c04057812ULL, 0x000fca00078ec0ffULL,
0x000000014e4e7824ULL, 0x000fca00078e0205ULL, 0x014000004e077984ULL, 0x000e680000000800ULL,
0x014200004e0c7984ULL, 0x0006a20000000800ULL, 0x0000006a0700720bULL, 0x002fe20003f1d000ULL,
0x000174f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000047806ULL, 0x008fc800000e0100ULL,
0x0000ffff04107812ULL, 0x000fe2000784c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff757224ULL, 0x000fd400078e006aULL,
0x000004100000a947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fe40003f45270ULL,
0x0000006a0700720bULL, 0x000fe20003f74000ULL, 0x000174b27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x000fc400018e0100ULL, 0x000000076a757209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000099100d047816ULL, 0x000fc600000000ffULL,
0x014400754e00a388ULL, 0x0003e20000000800ULL, 0x000000ff0400720cULL, 0x000fda0003f45270ULL,
0x000003000000a947ULL, 0x000fea0003800000ULL, 0x800000756a047221ULL, 0x002fe20000010000ULL,
0x000000ff0dff7812ULL, 0x000fe2000784c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL, 0x0000000400417308ULL, 0x0002ec0000000800ULL,
0x000001300000a947ULL, 0x000fea0003800000ULL, 0x00000002ff067819ULL, 0x000fe20000011602ULL,
0x000174127f007947ULL, 0x000fea000b800000ULL, 0x00001f0641067589ULL, 0x00866400000e0000ULL,
0x0000000614147220ULL, 0x086fe20000410000ULL, 0x0000000615157220ULL, 0x080fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000619197220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000628287220ULL, 0x080fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000608087220ULL, 0x080fe20000410000ULL, 0x0000000609097220ULL, 0x080fe20000410000ULL,
0x000000062c2c7220ULL, 0x080fe20000410000ULL, 0x000000062d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fe2000784c0ffULL,
0x000000414b4b7220ULL, 0x008fd80000410000ULL, 0x000001300000a947ULL, 0x000fea0003800000ULL,
0x0000000802067811ULL, 0x000fe200078ff0ffULL, 0x000172d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0641067589ULL, 0x00066400000e0000ULL, 0x0000000616167220ULL, 0x086fe20000410000ULL,
0x0000000617177220ULL, 0x080fe20000410000ULL, 0x000000061a1a7220ULL, 0x080fe20000410000ULL,
0x000000061b1b7220ULL, 0x080fe20000410000ULL, 0x000000061e1e7220ULL, 0x080fe20000410000ULL,
0x000000061f1f7220ULL, 0x080fe20000410000ULL, 0x0000000626267220ULL, 0x080fe20000410000ULL,
0x0000000627277220ULL, 0x080fe20000410000ULL, 0x000000062a2a7220ULL, 0x080fe20000410000ULL,
0x000000062b2b7220ULL, 0x080fe20000410000ULL, 0x0000000636367220ULL, 0x080fe20000410000ULL,
0x0000000637377220ULL, 0x080fe20000410000ULL, 0x000000060a0a7220ULL, 0x080fe20000410000ULL,
0x000000060b0b7220ULL, 0x080fe20000410000ULL, 0x000000062e2e7220ULL, 0x080fe20000410000ULL,
0x000000062f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff10ff7812ULL, 0x000fda000784600dULL, 0x8000007507072221ULL, 0x000fe20000010000ULL,
0x000000000000281cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b07072820ULL, 0x000fc80000410000ULL,
0x0000000700502308ULL, 0x000e640000000800ULL, 0x000000500c0c2220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000004b0c4b7221ULL, 0x004fe20000010000ULL,
0x0000010000008947ULL, 0x000fea0003800000ULL, 0x00000050ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff0c7819ULL, 0x000fe40000011602ULL, 0x0000541004417816ULL, 0x008fe20000000004ULL,
0x000170f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c41517589ULL, 0x0002a400000e0000ULL,
0x000000080c067810ULL, 0x000fe20007ffe0ffULL, 0x000171127f007947ULL, 0x000fea000b800000ULL,
0x00001f0641527589ULL, 0x00066400000e0000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x000000100c067810ULL, 0x008fe40007ffe0ffULL, 0x00002e1000047802ULL, 0x000fc40000000f00ULL,
0x00017c7000007944ULL, 0x016fea0003c00000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x000000180c067810ULL, 0x00cfe40007ffe0ffULL, 0x00002e5000047802ULL, 0x000fc40000000f00ULL,
0x00017c3000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000702537812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000853077812ULL, 0x000fc800078ef802ULL, 0x0000000702627211ULL, 0x000fe200078fe0ffULL,
0x0000000807057824ULL, 0x000fca00078e00ffULL, 0xfffffff805547812ULL, 0x000fe400078ee262ULL,
0x0000000802057812ULL, 0x000fe400078ec0ffULL, 0x0000a000543c7811ULL, 0x000fca00078e20ffULL,
0x0000000705057812ULL, 0x000fe200078ef802ULL, 0x000000003c3c783bULL, 0x000ee20000000200ULL,
0x0000c00000557811ULL, 0x000fe200078e68ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x0000000502047211ULL, 0x000fe200078fe0ffULL, 0x00000008050d7824ULL, 0x040fe200078e00ffULL,
0x00000002625a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000805067824ULL, 0x04cfe200078e00ffULL,
0x0000000204617810ULL, 0x040fe20007ffe0ffULL, 0x00000008050c7824ULL, 0x042fe200078e00ffULL,
0x0000000404637810ULL, 0x040fe20007ffe0ffULL, 0x00000008050f7824ULL, 0x000fe200078e00ffULL,
0x0000000604647810ULL, 0x000fe20007ffe0ffULL, 0x0000580049747a24ULL, 0x010fe200078e02ffULL,
0xfffffff80d567812ULL, 0x000fc400078ee204ULL, 0xfffffff806617812ULL, 0x000fe200078ee261ULL,
0x0000004074747824ULL, 0x000fe200078e00ffULL, 0xfffffff80c637812ULL, 0x000fe200078ee263ULL,
0x0000001056567824ULL, 0x100fe200078e0255ULL, 0xfffffff80f647812ULL, 0x000fe200078ee264ULL,
0x0000001061577824ULL, 0x100fe200078e0255ULL, 0x0000001005057812ULL, 0x000fe200078efcffULL,
0x0000001063587824ULL, 0x100fe200078e0255ULL, 0x000000005670783bULL, 0x000e620000004200ULL,
0x0000001064597824ULL, 0x000fe200078e0255ULL, 0x0000000502047211ULL, 0x000fe200078fe0ffULL,
0x0000000805067824ULL, 0x000fe200078e00ffULL, 0x00000000576c783bULL, 0x000ea20000004200ULL,
0xfffffff8075a7812ULL, 0x000fe200078ee25aULL, 0x0000000805077824ULL, 0x040fe200078e00ffULL,
0x0000000204667810ULL, 0x040fe20007ffe0ffULL, 0x000000005838783bULL, 0x000ee20000004200ULL,
0x0000000805697824ULL, 0x040fe200078e00ffULL, 0x0000000404677810ULL, 0x000fe20007ffe0ffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x000000005940783bULL, 0x000fe20000004200ULL,
0x0000a0005a0c7811ULL, 0x000fc400078e20ffULL, 0x0000000604687810ULL, 0x000fe40007ffe0ffULL,
0xfffffff869697812ULL, 0x000fe200078ee204ULL, 0x000000513c3c0232ULL, 0x080fe20000000000ULL,
0xfffffff807667812ULL, 0x000fe200078ee266ULL, 0x000000000c0c783bULL, 0x000ee20000000200ULL,
0xfffffff806677812ULL, 0x000fe200078ee267ULL, 0x00000010695b7824ULL, 0x100fe200078e0255ULL,
0xfffffff805687812ULL, 0x000fe200078ee268ULL, 0x00000010665c7824ULL, 0x100fe200078e0255ULL,
0x000000513e3e0232ULL, 0x000fe20000000000ULL, 0x00000010675d7824ULL, 0x100fe200078e0255ULL,
0x000000005b30783bULL, 0x000ee20000004200ULL, 0x00000010685e7824ULL, 0x000fe200078e0255ULL,
0x000000523d3d0232ULL, 0x000fc40000000000ULL, 0x000000005c20783bULL, 0x000ee20000004200ULL,
0x000000523f3f0232ULL, 0x000fc60000000000ULL, 0x000000005d10783bULL, 0x000ee80000004200ULL,
0x000000005e04783bULL, 0x000ee20000004200ULL, 0x000000703c14723cULL, 0x042f700000001814ULL,
0x0000006c3c1c723cULL, 0x044f70000000181cULL, 0x000000383c28723cULL, 0x008f620000001828ULL,
0x000000510c0c0232ULL, 0x000fc40000000000ULL, 0x000000510e0e0232ULL, 0x000fca0000000000ULL,
0x000000723c18723cULL, 0x000f620000001818ULL, 0x000000520d0d0232ULL, 0x080fe40000000000ULL,
0x000000520f0f0232ULL, 0x000fca0000000000ULL, 0x0000006e3c24723cULL, 0x040f700000001824ULL,
0x0000003a3c34723cULL, 0x040f700000001834ULL, 0x000000403c08723cULL, 0x040f700000001808ULL,
0x000000423c2c723cULL, 0x000f70000000182cULL, 0x000000300c14723cULL, 0x060b700000001814ULL,
0x000000200c3c723cULL, 0x040b70000000181cULL, 0x000000100c28723cULL, 0x040b700000001828ULL,
0x000000320c30723cULL, 0x040b700000001818ULL, 0x000000220c20723cULL, 0x040b700000001824ULL,
0x000000120c10723cULL, 0x040b700000001834ULL, 0x000000040c08723cULL, 0x040b700000001808ULL,
0x000000060c0c723cULL, 0x000b62000000182cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000009947ULL, 0x000fca0003800000ULL, 0x00000003ff257819ULL, 0x120fe20000011602ULL,
0x00000001482d7824ULL, 0x000fe200078e0253ULL, 0x0000004003057811ULL, 0x000fe400078e40ffULL,
0x0000000425197810ULL, 0x040fe40007ffe0ffULL, 0x0000000544047217ULL, 0x000fe40007800000ULL,
0x0000001025397810ULL, 0x000fe20007ffe0ffULL, 0x0000000119077824ULL, 0x100fe200078e0202ULL,
0x00000008251f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000819247824ULL, 0x000fe200078e00ffULL,
0x00000014253b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104067824ULL, 0x000fe200078e0a05ULL,
0x0000000c25277810ULL, 0x000fe20007ffe0ffULL, 0x0000000139057824ULL, 0x140fe200078e0202ULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x0000000839367824ULL, 0x000fe200078e00ffULL,
0x0000001825417810ULL, 0x000fe20007ffe0ffULL, 0x000000011f187824ULL, 0x100fe200078e0202ULL,
0x0000001c25437810ULL, 0x000fe20007ffe0ffULL, 0x000000081f1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee205ULL, 0x000000013b077824ULL, 0x040fe200078e0202ULL,
0x00000020062c7817ULL, 0x000fe20003800000ULL, 0x000000083b387824ULL, 0x000fe200078e00ffULL,
0xfffffff81b267812ULL, 0x000fe200078ee218ULL, 0x000000014a057824ULL, 0x000fe200078e0225ULL,
0x0000002c1f00720cULL, 0x000fe20003fa6070ULL, 0x0000000127047824ULL, 0x140fe200078e0202ULL,
0xfffffff838387812ULL, 0x000fe200078ee207ULL, 0x00000008271b7824ULL, 0x000fe200078e00ffULL,
0x0000000574077210ULL, 0x000fe20007f5e0ffULL, 0x0000000141187824ULL, 0x000fc400078e0202ULL,
0x00000008411d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b347812ULL, 0x000fe200078ee204ULL,
0x000000014a057824ULL, 0x000fe400078e0219ULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00005e0007047a11ULL, 0x000fe200078448ffULL, 0x00000001431b7824ULL, 0x000fe200078e0202ULL,
0xfffffff81d3a7812ULL, 0x000fe200078ee218ULL, 0x0000000843407824ULL, 0x000fe200078e00ffULL,
0x0000000574187210ULL, 0x000fe20007f7e0ffULL, 0x0000001024357824ULL, 0x000fe200078e0255ULL,
0x00005f0007057a11ULL, 0x000fe200010f4c1aULL, 0x000000014a077824ULL, 0x000fe200078e021fULL,
0xfffffff840407812ULL, 0x000fe200078ee21bULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x0000002c1900720cULL, 0x000fe20003f66070ULL, 0x000000014a197824ULL, 0x000fe200078e0227ULL,
0x00000007741a7210ULL, 0x000fe20007f9e0ffULL, 0x000000102d047825ULL, 0x000fe200078e0004ULL,
0x00005e0018067a11ULL, 0x000fc600078448ffULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x00005f0018077a11ULL, 0x000fe200010f4c1bULL, 0x000000014a1b7824ULL, 0x000fe200078e0239ULL,
0x00005e001a187a11ULL, 0x000fe200078448ffULL, 0x0000001026377824ULL, 0x000fe200078e0255ULL,
0x00000019741c7210ULL, 0x000fe20007f9e0ffULL, 0x000000102d067825ULL, 0x040fe200078e0006ULL,
0x00005f001a197a11ULL, 0x000fe400010f4c1dULL, 0x0000001b741d7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e06ffULL, 0x00005e001c1a7a11ULL, 0x000fe200078448ffULL,
0x000000102d187825ULL, 0x000fe200078e0018ULL, 0x0000002c2500720cULL, 0x000fc40003f86070ULL,
0x00005f001c1b7a11ULL, 0x000fe200010f4c1fULL, 0x0000000125257824ULL, 0x000fe200078e0202ULL,
0x0000002c2700720cULL, 0x000fe20003f46070ULL, 0x000000ffff1e7224ULL, 0x000fe200030e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078c48ffULL, 0x000000014a1f7824ULL, 0x040fe200078e023bULL,
0x0000000725257812ULL, 0x000fe200078ec0ffULL, 0x000000014a277824ULL, 0x040fe200078e0243ULL,
0x00005f001d1d7a11ULL, 0x000fe400030f4c1eULL, 0x0ffffff8251e7812ULL, 0x000fe200078ef802ULL,
0x000000014a257824ULL, 0x000fe200078e0241ULL, 0x0000001f741f7210ULL, 0x000fc60007fde0ffULL,
0x000000101e2f7824ULL, 0x000fe400078e0255ULL, 0x000000ffff247224ULL, 0x000fe200030e06ffULL,
0x00005e001f1e7a11ULL, 0x040fe400078c48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000042f7faeULL, 0x0003e2000e101c46ULL, 0x0000002574257210ULL, 0x040fe40007f9e0ffULL,
0x00005f001f1f7a11ULL, 0x000fe200030f4c24ULL, 0x0000000006357faeULL, 0x0005e2000d901c46ULL,
0x0000002774277210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078c48ffULL, 0x0000000018377faeULL, 0x0007e2000e901c46ULL,
0x0000002c3900720cULL, 0x000fe20003f86070ULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x00005f0025257a11ULL, 0x000fe200030f4c26ULL, 0x000000102d047825ULL, 0x002fe200078e001aULL,
0x00005e0027267a11ULL, 0x000fc400078648ffULL, 0x0000002c3b00720cULL, 0x080fe20003fc6070ULL,
0x000000102d067825ULL, 0x004fe200078e001cULL, 0x0000002c4100720cULL, 0x080fe40003fa6070ULL,
0x00005f0027277a11ULL, 0x000fe200018f4c2eULL, 0x000000102d1c7825ULL, 0x000fe200078e0024ULL,
0x0000002c4300720cULL, 0x000fc60003f66070ULL, 0x000000102d1a7825ULL, 0x000fc800078e001eULL,
0x0000001034257824ULL, 0x000fe400078e0255ULL, 0x000000102d1e7825ULL, 0x000fc600078e0026ULL,
0x0000000004257faeULL, 0x0003e2000d101c46ULL, 0x0000001036197824ULL, 0x108fe400078e0255ULL,
0x0000001038277824ULL, 0x100fe400078e0255ULL, 0x000000103a2d7824ULL, 0x100fe200078e0255ULL,
0x0000000006197faeULL, 0x0003e2000e101c46ULL, 0x00000010402f7824ULL, 0x000fc600078e0255ULL,
0x000000001a277faeULL, 0x0003e8000f101c46ULL, 0x000000001c2d7faeULL, 0x0003e8000e901c46ULL,
0x000000001e2f7faeULL, 0x0003e2000d901c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x0000000c021b7811ULL, 0x060fe400078fe8ffULL, 0x00000010021f7811ULL, 0x000fc400078fe8ffULL,
0x0000000802197811ULL, 0x040fe200078fe8ffULL, 0x000000011b067824ULL, 0x140fe200078e0202ULL,
0x0000000402077811ULL, 0x040fe200078fe8ffULL, 0x000000081b257824ULL, 0x000fe200078e00ffULL,
0x0000001c022f7811ULL, 0x040fe200078fe8ffULL, 0x000000011f187824ULL, 0x040fe400078e0202ULL,
0x000000081f277824ULL, 0x000fe200078e00ffULL, 0xfffffff825407812ULL, 0x000fe200078ee206ULL,
0x0000000119057824ULL, 0x040fe200078e0202ULL, 0x0000001402257811ULL, 0x040fe200078fe8ffULL,
0x00000008193a7824ULL, 0x000fe200078e00ffULL, 0xfffffff827427812ULL, 0x000fe200078ee218ULL,
0x0000000107047824ULL, 0x040fe200078e0202ULL, 0x0000001802277811ULL, 0x000fe200078fe8ffULL,
0x00000008071d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL,
0x000000014a197824ULL, 0x000fe200078e0219ULL, 0x0000004a02057211ULL, 0x000fe200078fe8ffULL,
0x000000014a1b7824ULL, 0x040fe200078e021bULL, 0xfffffff81d387812ULL, 0x000fe200078ee204ULL,
0x0000000125047824ULL, 0x100fe200078e0202ULL, 0x0000007405057210ULL, 0x080fe20007f5e0ffULL,
0x00000008251d7824ULL, 0x000fe200078e00ffULL, 0x0000007419197210ULL, 0x080fe20007f9e0ffULL,
0x0000000127067824ULL, 0x000fe200078e0202ULL, 0x000000741b1b7210ULL, 0x000fe20007fbe0ffULL,
0x00000008272d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d607812ULL, 0x000fe200078ee204ULL,
0x000000014a077824ULL, 0x000fe200078e0207ULL, 0x00000002021d7211ULL, 0x000fe200078fe8ffULL,
0x000000012f187824ULL, 0x000fe200078e0202ULL, 0xfffffff82d6a7812ULL, 0x000fe200078ee206ULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x0000007407077210ULL, 0x080fe20007f7e0ffULL,
0x000000082f357824ULL, 0x000fe200078e00ffULL, 0x00005e0005047a11ULL, 0x000fe200078448ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078848ffULL,
0x000000ffff1c7224ULL, 0x000fe200028e06ffULL, 0x000000071d1d7812ULL, 0x000fe200078ec0ffULL,
0x000000014a1f7824ULL, 0x040fe200078e021fULL, 0x00005f0005057a11ULL, 0x000fe200010f4c06ULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0xfffffff8356c7812ULL, 0x000fe200078ee218ULL,
0x000000014a257824ULL, 0x040fe200078e0225ULL, 0x00005e0007067a11ULL, 0x000fe200078448ffULL,
0x000000014a277824ULL, 0x040fe200078e0227ULL, 0x00005e0019187a11ULL, 0x000fe200078648ffULL,
0x000000014a2f7824ULL, 0x000fe200078e022fULL, 0x00005f001b1b7a11ULL, 0x000fe200020f4c1cULL,
0x00000001482d7824ULL, 0x000fe200078e0253ULL, 0x0ffffff81d1c7812ULL, 0x000fe200078ef802ULL,
0x0000001038357824ULL, 0x000fe200078e0255ULL, 0x000000741f1d7210ULL, 0x000fe20007f9e0ffULL,
0x000000102d047825ULL, 0x000fe200078e0004ULL, 0x00005f0007077a11ULL, 0x000fc400010f4c24ULL,
0x00000074251f7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0x00005f0019197a11ULL, 0x000fe200018f4c1eULL, 0x000000102d067825ULL, 0x000fe200078e0006ULL,
0x0000007427257210ULL, 0x080fe40007f5e0ffULL, 0x000000742f277210ULL, 0x000fe20007f7e0ffULL,
0x000000101c2f7824ULL, 0x100fe200078e0255ULL, 0x00005e001d1c7a11ULL, 0x000fe200078848ffULL,
0x000000ffff347224ULL, 0x000fe200028e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe200078a48ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078448ffULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078648ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000042f7faeULL, 0x0003e2000b901c46ULL,
0x00005f001d1d7a11ULL, 0x000fe200020f4c36ULL, 0x000000103a377824ULL, 0x000fe200078e0255ULL,
0x00005f001f1f7a11ULL, 0x000fe200028f4c34ULL, 0x000000102d187825ULL, 0x000fe200078e0018ULL,
0x00005f0025257a11ULL, 0x000fe200010f4c2eULL, 0x0000000006357faeULL, 0x0005e2000b901c46ULL,
0x00005f0027277a11ULL, 0x000fe200018f4c2cULL, 0x000000102d1a7825ULL, 0x000fc400078e001aULL,
0x0000000018377faeULL, 0x0005e4000b901c46ULL, 0x000000102d1c7825ULL, 0x000fc800078e001cULL,
0x000000102d1e7825ULL, 0x000fc800078e001eULL, 0x000000102d247825ULL, 0x000fc800078e0024ULL,
0x000000102d267825ULL, 0x000fc800078e0026ULL, 0x0000001040057824ULL, 0x102fe400078e0255ULL,
0x00000010422d7824ULL, 0x100fe400078e0255ULL, 0x00000010602f7824ULL, 0x100fe200078e0255ULL,
0x000000001a057faeULL, 0x0005e2000b901c46ULL, 0x000000106a397824ULL, 0x100fe400078e0255ULL,
0x000000106c3b7824ULL, 0x000fe200078e0255ULL, 0x000000001c2d7faeULL, 0x0005e8000b901c46ULL,
0x000000001e2f7faeULL, 0x0005e8000b901c46ULL, 0x0000000024397faeULL, 0x0005e8000b901c46ULL,
0x00000000263b7faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000008947ULL, 0x000fea0003800000ULL, 0x00000050ff04723eULL, 0x002fe400000000ffULL,
0x00000002ff187819ULL, 0x004fe40000011602ULL, 0x0000541004417816ULL, 0x000fe20000000004ULL,
0x00015da27f007947ULL, 0x000fea000b800000ULL, 0x00001f1841517589ULL, 0x0002a400000e0000ULL,
0x0000000818067810ULL, 0x000fe20007ffe0ffULL, 0x00015dc27f007947ULL, 0x000fea000b800000ULL,
0x00001f0641527589ULL, 0x00066400000e0000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x0000001018067810ULL, 0x008fe40007ffe0ffULL, 0x000041f000047802ULL, 0x000fc40000000f00ULL,
0x0001689000007944ULL, 0x006fea0003c00000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x0000001818067810ULL, 0x00cfe40007ffe0ffULL, 0x0000423000047802ULL, 0x000fc40000000f00ULL,
0x0001685000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000853047812ULL, 0x002fe200078ef802ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004625f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000802057812ULL, 0x004fe200078ec0ffULL,
0x0000000804067824ULL, 0x008fca00078e00ffULL, 0xfffffff8065f7812ULL, 0x000fc800078ee25fULL,
0x0000a0005f1c7811ULL, 0x000fca00078e20ffULL, 0x0000000705057812ULL, 0x000fe200078ef802ULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x0000100055607810ULL, 0x000fe20007ffe0ffULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x0000000502067211ULL, 0x000fe200078fe0ffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x0000000662657810ULL, 0x000fe20007ffe0ffULL,
0x0000001063627824ULL, 0x100fe400078e0260ULL, 0x0000001061617824ULL, 0x000fe200078e0260ULL,
0xfffffff805057812ULL, 0x000fe200078ee206ULL, 0x0000001064637824ULL, 0x100fe200078e0260ULL,
0x00000000626c783bULL, 0x000ea20000004200ULL, 0xfffffff804657812ULL, 0x000fe200078ee265ULL,
0x0000001066667824ULL, 0x000fc400078e0260ULL, 0x0000001005647824ULL, 0x100fe200078e0260ULL,
0x000000006170783bULL, 0x000ee20000004200ULL, 0x0000a00065187811ULL, 0x000fe200078e20ffULL,
0x0000001067677824ULL, 0x100fe400078e0260ULL, 0x000000006340783bULL, 0x000fe20000004200ULL,
0x0000001068687824ULL, 0x100fe400078e0260ULL, 0x0000001069697824ULL, 0x000fe200078e0260ULL,
0x000000006438783bULL, 0x000fe80000004200ULL, 0x000000001818783bULL, 0x000f280000000200ULL,
0x000000006624783bULL, 0x000f280000004200ULL, 0x000000006734783bULL, 0x000f280000004200ULL,
0x00000000682c783bULL, 0x000f220000004200ULL, 0x000000511c1c0232ULL, 0x002fc40000000000ULL,
0x000000511e1e0232ULL, 0x000fe20000000000ULL, 0x000000006904783bULL, 0x000e620000004200ULL,
0x000000521d1d0232ULL, 0x080fe40000000000ULL, 0x000000521f1f0232ULL, 0x000fce0000000000ULL,
0x0000006c1c28723cULL, 0x044ff00000001828ULL, 0x000000701c3c723cULL, 0x008f62000000183cULL,
0x0000005118180232ULL, 0x010fce0000000000ULL, 0x000000401c08723cULL, 0x000f620000001808ULL,
0x000000511a1a0232ULL, 0x000fe40000000000ULL, 0x0000005219190232ULL, 0x080fe40000000000ULL,
0x000000521b1b0232ULL, 0x000fc60000000000ULL, 0x000000721c20723cULL, 0x040f700000001820ULL,
0x0000006e1c10723cULL, 0x040f700000001810ULL, 0x000000421c0c723cULL, 0x040f70000000180cULL,
0x000000381c14723cULL, 0x040f700000001814ULL, 0x0000003a1c30723cULL, 0x000f700000001830ULL,
0x00000024181c723cULL, 0x060b70000000183cULL, 0x000000341828723cULL, 0x040b700000001828ULL,
0x0000002c1808723cULL, 0x040b700000001808ULL, 0x000000261824723cULL, 0x040b700000001820ULL,
0x000000361834723cULL, 0x040b700000001810ULL, 0x0000002e182c723cULL, 0x040b70000000180cULL,
0x000000041814723cULL, 0x042b700000001814ULL, 0x000000061818723cULL, 0x000b620000001830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000004003057811ULL, 0x020fe200078e40ffULL,
0x01468800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff6a7224ULL, 0x000fc400078e0075ULL,
0x000000440500720cULL, 0x000fda0003f06070ULL, 0x0000812000000947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x00000003ff0f7819ULL, 0x000fe20000011602ULL, 0x0000000148337824ULL, 0x000fe200078e0253ULL,
0x000000204a107810ULL, 0x000fe40007ffe0ffULL, 0x0000006003057811ULL, 0x000fe400078e40ffULL,
0x000000040f237810ULL, 0x040fe20007ffe0ffULL, 0x000000010f077824ULL, 0x040fe200078e0210ULL,
0x0000000544067217ULL, 0x000fe40007800000ULL, 0x000000080f397810ULL, 0x000fe20007ffe0ffULL,
0x00000001230d7824ULL, 0x000fe200078e0202ULL, 0x0000007407077210ULL, 0x000fe20007f1e0ffULL,
0x0000000106067824ULL, 0x000fe200078e0a05ULL, 0x0000000c0f3d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000823127824ULL, 0x000fe200078e00ffULL, 0x000000140f497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005e0007047a11ULL, 0x000fe200078048ffULL,
0x0000000123117824ULL, 0x000fe200078e0210ULL, 0xfffffff812317812ULL, 0x000fe200078ee20dULL,
0x00000001390e7824ULL, 0x000fe200078e0202ULL, 0x00005f0007057a11ULL, 0x000fe200000f4c0cULL,
0x000000010f077824ULL, 0x000fe200078e0202ULL, 0x0000002006307817ULL, 0x000fe20003800000ULL,
0x00000008393b7824ULL, 0x000fe200078e00ffULL, 0x000000100f417810ULL, 0x000fe20007ffe0ffULL,
0x000000083d3f7824ULL, 0x000fe200078e00ffULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x0000000849207824ULL, 0x000fe200078e00ffULL, 0x000000300f00720cULL, 0x000fe20003f06070ULL,
0x0000001033047825ULL, 0x000fe200078e0004ULL, 0x0ffffff8070d7812ULL, 0x000fc400078ef802ULL,
0x0000007411077210ULL, 0x080fe20007f5e0ffULL, 0x0000000149117824ULL, 0x000fe200078e0202ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL, 0x000000013d0e7824ULL, 0x000fe200078e0202ULL,
0x000000180f6f7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x0000001c0f737810ULL, 0x000fe20007ffe0ffULL, 0x00000001390f7824ULL, 0x000fe200078e0210ULL,
0x00005e0007067a11ULL, 0x000fe200078448ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0260ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20eULL, 0x0000000141137824ULL, 0x000fe200078e0210ULL,
0x00005f0007077a11ULL, 0x000fe200010f4c0cULL, 0x0000000149217824ULL, 0x100fe200078e0210ULL,
0x000000740f0e7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000c101c46ULL, 0xfffffff8206d7812ULL, 0x000fe200078ee211ULL,
0x000000013d117824ULL, 0x000fe200078e0210ULL, 0x00005e000e0c7a11ULL, 0x000fe200078c48ffULL,
0x0000000141127824ULL, 0x000fc400078e0202ULL, 0x0000000841437824ULL, 0x000fe200078e00ffULL,
0x00000074110f7210ULL, 0x080fe20007f7e0ffULL, 0x000000016f717824ULL, 0x100fe200078e0210ULL,
0x0000007413117210ULL, 0x080fe20007f1e0ffULL, 0x0000000173777824ULL, 0x000fe200078e0210ULL,
0x0000007421137210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff057224ULL, 0x002fe200010e06ffULL,
0xfffffff843437812ULL, 0x000fe200078ee212ULL, 0x000000086f127824ULL, 0x000fe200078e00ffULL,
0x0000007471217210ULL, 0x080fe20007fbe0ffULL, 0x0000000173107824ULL, 0x100fe200078e0202ULL,
0x00005f000e0d7a11ULL, 0x000fe200030f4c05ULL, 0x000000016f057824ULL, 0x000fe200078e0202ULL,
0x0000007477747210ULL, 0x000fe20007f5e0ffULL, 0x0000000873777824ULL, 0x000fe200078e00ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff047224ULL, 0x000fe200018e06ffULL,
0xfffffff812717812ULL, 0x000fe200078ee205ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x000000302300720cULL, 0x000fe20003f66070ULL, 0x0000001031317824ULL, 0x000fe200078e0260ULL,
0xfffffff877777812ULL, 0x000fc400078ee210ULL, 0x00005f000f0f7a11ULL, 0x000fe200030f4c04ULL,
0x0000001033047825ULL, 0x000fe200078e0006ULL, 0x00005e0011107a11ULL, 0x000fe400078c48ffULL,
0x000000303900720cULL, 0x080fe20003f06070ULL, 0x000000ffff067224ULL, 0x000fe200020e06ffULL,
0x00005f0011117a11ULL, 0x000fe200030f4c12ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078c48ffULL, 0x0000000004317faeULL, 0x0003e2000d901c46ULL,
0x000000303d00720cULL, 0x000fe20003f66070ULL, 0x0000001071397824ULL, 0x000fe200078e0260ULL,
0x00005f0013137a11ULL, 0x000fe200030f4c06ULL, 0x000000ffff067224ULL, 0x000fe200028e06ffULL,
0x00005e0021207a11ULL, 0x000fc400078a48ffULL, 0x00005e0074227a11ULL, 0x040fe400078c48ffULL,
0x000000304100720cULL, 0x080fe40003f86070ULL, 0x000000304900720cULL, 0x080fe20003f46070ULL,
0x0000001033047825ULL, 0x002fe200078e000cULL, 0x00005f0021217a11ULL, 0x000fe400028f4c06ULL,
0x000000306f00720cULL, 0x000fe20003fa6070ULL, 0x00000010330c7825ULL, 0x000fe200078e0010ULL,
0x00005f0074237a11ULL, 0x000fc400030f4c07ULL, 0x000000307300720cULL, 0x000fe20003fc6070ULL,
0x0000001033067825ULL, 0x000fc800078e000eULL, 0x000000103b317824ULL, 0x000fe400078e0260ULL,
0x00000010330e7825ULL, 0x000fc600078e0012ULL, 0x0000000004317faeULL, 0x0003e2000c101c46ULL,
0x0000001033107825ULL, 0x000fc800078e0020ULL, 0x0000001033127825ULL, 0x000fc800078e0022ULL,
0x000000103f217824ULL, 0x100fe400078e0260ULL, 0x0000001043237824ULL, 0x100fe400078e0260ULL,
0x000000106d337824ULL, 0x100fe200078e0260ULL, 0x0000000006217faeULL, 0x0003e2000d901c46ULL,
0x00000010773b7824ULL, 0x000fc600078e0260ULL, 0x000000000c237faeULL, 0x0003e8000e101c46ULL,
0x000000000e337faeULL, 0x0003e8000d101c46ULL, 0x0000000010397faeULL, 0x0003e8000e901c46ULL,
0x00000000123b7faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x0000000402047811ULL, 0x000fe200078fe8ffULL, 0x00000001483b7824ULL, 0x000fe200078e0253ULL,
0x00000008020d7811ULL, 0x000fc400078fe8ffULL, 0x0000001002127811ULL, 0x000fe200078fe8ffULL,
0x0000000104057824ULL, 0x100fe200078e0202ULL, 0x000000204a0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000804067824ULL, 0x000fe200078e00ffULL, 0x0000001402207811ULL, 0x040fe200078fe8ffULL,
0x000000080d0c7824ULL, 0x040fe200078e00ffULL, 0x0000000c02107811ULL, 0x000fe200078fe8ffULL,
0x0000000112077824ULL, 0x100fe200078e0202ULL, 0xfffffff806337812ULL, 0x000fe200078ee205ULL,
0x000000010d057824ULL, 0x000fe200078e0202ULL, 0x0000001802227811ULL, 0x000fe200078fe8ffULL,
0x00000008120e7824ULL, 0x000fc400078e00ffULL, 0x0000000120117824ULL, 0x100fe200078e0202ULL,
0xfffffff80c397812ULL, 0x000fe200078ee205ULL, 0x0000000820307824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3f7812ULL, 0x000fe200078ee207ULL, 0x0000000104077824ULL, 0x000fe200078e020fULL,
0x0000000f02057211ULL, 0x000fe200078fe8ffULL, 0x0000000110067824ULL, 0x100fe200078e0202ULL,
0xfffffff830417812ULL, 0x000fe200078ee211ULL, 0x00000008103d7824ULL, 0x000fe200078e00ffULL,
0x0000007405057210ULL, 0x080fe20007f1e0ffULL, 0x0000000122137824ULL, 0x040fe200078e0202ULL,
0x0000007407077210ULL, 0x080fe20007f5e0ffULL, 0x0000000822327824ULL, 0x000fe200078e00ffULL,
0x0000001c02307811ULL, 0x000fe200078fe8ffULL, 0x000000010d0d7824ULL, 0x000fe200078e020fULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee206ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005e0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0xfffffff832437812ULL, 0x000fe200078ee213ULL, 0x0000000110117824ULL, 0x100fe200078e020fULL,
0x00005e0007067a11ULL, 0x000fe200078448ffULL, 0x0000000112137824ULL, 0x100fe200078e020fULL,
0x000000740d0d7210ULL, 0x080fe20007f7e0ffULL, 0x0000000120217824ULL, 0x100fe200078e020fULL,
0x00005f0005057a11ULL, 0x000fe200000f4c0eULL, 0x0000000122237824ULL, 0x100fe200078e020fULL,
0x00005f0007077a11ULL, 0x000fe200010f4c0cULL, 0x0000000130317824ULL, 0x000fe200078e020fULL,
0x00000074110f7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x0000007413117210ULL, 0x000fe20007f5e0ffULL, 0x000000103b047825ULL, 0x000fe200078e0004ULL,
0x00005e000d0c7a11ULL, 0x000fc400078c48ffULL, 0x0000007421137210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff207224ULL, 0x000fe200000e06ffULL, 0x0000007423217210ULL, 0x080fe20007f7e0ffULL,
0x0000000130237824ULL, 0x040fe200078e0202ULL, 0x0000007431747210ULL, 0x000fe20007f9e0ffULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x00005f000d0d7a11ULL, 0x000fe200030f4c0eULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000000202227211ULL, 0x000fe200078fe8ffULL,
0x000000ffff327224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078048ffULL,
0x0000001033337824ULL, 0x000fe200078e0260ULL, 0x00005e0011107a11ULL, 0x000fe200078448ffULL,
0x000000103b067825ULL, 0x000fe200078e0006ULL, 0xfffffff830497812ULL, 0x000fc400078ee223ULL,
0x0000000722317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005f000f0f7a11ULL, 0x000fe200000f4c20ULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0x00005f0011117a11ULL, 0x000fe200010f4c12ULL, 0x0000001039397824ULL, 0x000fe200078e0260ULL,
0x00005e0013127a11ULL, 0x000fe200078048ffULL, 0x000000103b0c7825ULL, 0x000fe200078e000cULL,
0x00005e0021207a11ULL, 0x000fe400078448ffULL, 0x00005e0074227a11ULL, 0x000fe200078648ffULL,
0x000000103b0e7825ULL, 0x000fe200078e000eULL, 0x0ffffff831317812ULL, 0x000fc400078ef802ULL,
0x00005f0013137a11ULL, 0x000fe200000f4c32ULL, 0x000000103b107825ULL, 0x000fe200078e0010ULL,
0x00005f0021217a11ULL, 0x000fe400010f4c30ULL, 0x00005f0074237a11ULL, 0x000fe200018f4c23ULL,
0x0000001031317824ULL, 0x000fe400078e0260ULL, 0x000000103b127825ULL, 0x000fc600078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004317faeULL, 0x0003e2000b901c46ULL,
0x000000103b207825ULL, 0x000fc600078e0020ULL, 0x0000000006337faeULL, 0x0003e2000b901c46ULL,
0x000000103b227825ULL, 0x000fc600078e0022ULL, 0x000000000c397faeULL, 0x0003e2000b901c46ULL,
0x000000103d3b7824ULL, 0x100fe400078e0260ULL, 0x000000103f3d7824ULL, 0x100fe400078e0260ULL,
0x00000010413f7824ULL, 0x100fe200078e0260ULL, 0x000000000e3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001043417824ULL, 0x100fe400078e0260ULL, 0x0000001049437824ULL, 0x000fe200078e0260ULL,
0x00000000103d7faeULL, 0x0003e8000b901c46ULL, 0x00000000123f7faeULL, 0x0003e8000b901c46ULL,
0x0000000020417faeULL, 0x0003e8000b901c46ULL, 0x0000000022437faeULL, 0x0003e4000b901c46ULL,
0x00000300ff047624ULL, 0x002fe200078e00ffULL, 0x0000000347057812ULL, 0x000fe200078ec0ffULL,
0xffffffffff497424ULL, 0x000fc600078e00ffULL, 0x000000030500780cULL, 0x000fe40003f05270ULL,
0xfffffffd04047811ULL, 0x000fc800078e10ffULL, 0x0000000104047807ULL, 0x000fca0004000000ULL,
0x0000000147477824ULL, 0x000fca00078e0204ULL, 0x000000454700720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000147047824ULL, 0x000fe400078e024dULL,
0x00000004ff057424ULL, 0x000fc800078e00ffULL, 0x0000600004047625ULL, 0x000fca00078e0005ULL,
0x0000000604497981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01462800480c7f8cULL, 0x0004e4000c80043fULL,
0x0000000000047805ULL, 0x002fc40000015200ULL, 0x01462c0048077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x00afe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000f06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01462c0048077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x014080004e0c7984ULL, 0x000e680000000800ULL,
0x014280004e077984ULL, 0x0006a20000000800ULL, 0x000000750c00720bULL, 0x002fe20003f1d000ULL,
0x000147f27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0dff7812ULL, 0x000fe2000784c0ffULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff6a7224ULL, 0x000fd400078e0075ULL,
0x000004200000a947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x000000750c00720bULL, 0x000fe20003f54000ULL, 0x000147b27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x000fc400010e0100ULL, 0x000000750c058209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100e047816ULL, 0x000fc600000000ffULL,
0x014480054e008388ULL, 0x0003e20000000800ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000750c047209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0eff7812ULL, 0x000fc6000780c0ffULL,
0x0000007504047221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL,
0x0000000400417308ULL, 0x000e640000000800ULL, 0x000000414b4b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff067819ULL, 0x000fe20000011602ULL,
0x000146e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0641067589ULL, 0x0002e400000e0000ULL,
0x0000000614147220ULL, 0x08cfe20000410000ULL, 0x0000000615157220ULL, 0x080fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000619197220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000628287220ULL, 0x080fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000608087220ULL, 0x080fe20000410000ULL, 0x0000000609097220ULL, 0x080fe20000410000ULL,
0x000000062c2c7220ULL, 0x080fe20000410000ULL, 0x000000062d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000eff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802067811ULL, 0x000fe200078ff0ffULL,
0x000145b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0641067589ULL, 0x00066400000e0000ULL,
0x0000000616167220ULL, 0x086fe20000410000ULL, 0x0000000617177220ULL, 0x080fe20000410000ULL,
0x000000061a1a7220ULL, 0x080fe20000410000ULL, 0x000000061b1b7220ULL, 0x080fe20000410000ULL,
0x000000061e1e7220ULL, 0x080fe20000410000ULL, 0x000000061f1f7220ULL, 0x080fe20000410000ULL,
0x0000000626267220ULL, 0x080fe20000410000ULL, 0x0000000627277220ULL, 0x080fe20000410000ULL,
0x000000062a2a7220ULL, 0x080fe20000410000ULL, 0x000000062b2b7220ULL, 0x080fe20000410000ULL,
0x0000000636367220ULL, 0x080fe20000410000ULL, 0x0000000637377220ULL, 0x080fe20000410000ULL,
0x000000060a0a7220ULL, 0x080fe20000410000ULL, 0x000000060b0b7220ULL, 0x080fe20000410000ULL,
0x000000062e2e7220ULL, 0x080fe20000410000ULL, 0x000000062f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff0eff7812ULL, 0x000fe4000780080dULL,
0x000000750c6a7209ULL, 0x000fd60007810000ULL, 0x8000006a0c0c0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0c0c0820ULL, 0x000fc80000410000ULL, 0x0000000c00500308ULL, 0x000e640000000800ULL,
0x0000005007070220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000004b074b7221ULL, 0x004fe20000010000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000050ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0c7819ULL, 0x000fe40000011602ULL,
0x0000541004417816ULL, 0x008fe20000000004ULL, 0x000143d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c41517589ULL, 0x0002a400000e0000ULL, 0x000000080c067810ULL, 0x000fe20007ffe0ffULL,
0x000143f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0641527589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000100c067810ULL, 0x008fe40007ffe0ffULL,
0x00005d4000047802ULL, 0x000fc40000000f00ULL, 0x00014d4000007944ULL, 0x016fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000180c067810ULL, 0x00cfe40007ffe0ffULL,
0x00005d8000047802ULL, 0x000fc40000000f00ULL, 0x00014d0000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000a800543c7811ULL, 0x000fcc00078e20ffULL, 0x000000003c3c783bULL, 0x000ee20000000200ULL,
0x0000a8005a0c7811ULL, 0x002fe200078e20ffULL, 0x0000580049747a24ULL, 0x010fc400078e02ffULL,
0x000000005804783bULL, 0x00ce640000004200ULL, 0x0000004074747824ULL, 0x000fe400078e00ffULL,
0x000000005670783bULL, 0x000fe80000004200ULL, 0x00000000576c783bULL, 0x000fe80000004200ULL,
0x000000005940783bULL, 0x000fe80000004200ULL, 0x000000000c0c783bULL, 0x000ea80000000200ULL,
0x000000005b38783bULL, 0x000ee80000004200ULL, 0x000000005c30783bULL, 0x000ee80000004200ULL,
0x000000005d20783bULL, 0x000ee80000004200ULL, 0x000000005e10783bULL, 0x000ee20000004200ULL,
0x000000513c3c0232ULL, 0x000fc40000000000ULL, 0x000000513e3e0232ULL, 0x000fe40000000000ULL,
0x000000523d3d0232ULL, 0x080fe40000000000ULL, 0x000000523f3f0232ULL, 0x000fce0000000000ULL,
0x000000043c28723cULL, 0x002fe20000001828ULL, 0x000000510c0c0232ULL, 0x004fce0000000000ULL,
0x000000703c14723cULL, 0x000f620000001814ULL, 0x000000510e0e0232ULL, 0x000fe40000000000ULL,
0x000000520d0d0232ULL, 0x080fe40000000000ULL, 0x000000520f0f0232ULL, 0x000fc60000000000ULL,
0x000000723c18723cULL, 0x040f700000001818ULL, 0x0000006c3c1c723cULL, 0x040f70000000181cULL,
0x0000006e3c24723cULL, 0x040f700000001824ULL, 0x000000063c04723cULL, 0x040f700000001834ULL,
0x000000403c08723cULL, 0x040f700000001808ULL, 0x000000423c3c723cULL, 0x000f70000000182cULL,
0x000000380c14723cULL, 0x068b700000001814ULL, 0x0000003a0c18723cULL, 0x040b700000001818ULL,
0x000000300c1c723cULL, 0x040b70000000181cULL, 0x000000320c30723cULL, 0x040b700000001824ULL,
0x000000200c28723cULL, 0x040b700000001828ULL, 0x000000220c2c723cULL, 0x040b700000001804ULL,
0x000000100c08723cULL, 0x040b700000001808ULL, 0x000000120c38723cULL, 0x000b62000000183cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000009947ULL, 0x000fca0003800000ULL,
0x0000008003057811ULL, 0x020fe200078e40ffULL, 0x0000000148257824ULL, 0x000fe200078e0253ULL,
0x00000003ff137819ULL, 0x100fe40000011602ULL, 0x0000000544047217ULL, 0x000fe40007800000ULL,
0x00000004130f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000813117810ULL, 0x040fe20007ffe0ffULL,
0x0000000104067824ULL, 0x000fe200078e0a05ULL, 0x00000010133d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f077824ULL, 0x100fe200078e0202ULL, 0x0000000c13217810ULL, 0x000fe20007ffe0ffULL,
0x000000080f207824ULL, 0x000fe200078e00ffULL, 0x00000014133f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001110c7824ULL, 0x100fe200078e0202ULL, 0x0000001813417810ULL, 0x000fe20007ffe0ffULL,
0x00000008110d7824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee207ULL,
0x000000013d057824ULL, 0x000fe200078e0202ULL, 0x0000001c13437810ULL, 0x000fe20007ffe0ffULL,
0x000000083d367824ULL, 0x000fe200078e00ffULL, 0xfffffff80d227812ULL, 0x000fe200078ee20cULL,
0x0000000121047824ULL, 0x140fe200078e0202ULL, 0x0000002006247817ULL, 0x000fe20003800000ULL,
0x00000008210d7824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee205ULL,
0x000000013f077824ULL, 0x000fe200078e0202ULL, 0x000000241100720cULL, 0x000fe20003fa6070ULL,
0x000000083f3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d347812ULL, 0x000fe200078ee204ULL,
0x000000014a057824ULL, 0x000fc400078e0213ULL, 0x00000001410d7824ULL, 0x100fe200078e0202ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee207ULL, 0x000000014a077824ULL, 0x000fe200078e020fULL,
0x0000007405057210ULL, 0x080fe20007f5e0ffULL, 0x00000008413e7824ULL, 0x000fe400078e00ffULL,
0x00000001430e7824ULL, 0x000fe200078e0202ULL, 0x0000007407077210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078448ffULL,
0x0000000843237824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x000000014a0d7824ULL, 0x040fe200078e0211ULL, 0x00005f0005057a11ULL, 0x000fe200010f4c0cULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x000000240f00720cULL, 0x000fe20003f66070ULL,
0x000000014a0f7824ULL, 0x040fe200078e0221ULL, 0x000000740d0d7210ULL, 0x000fe20007f9e0ffULL,
0x000000014a117824ULL, 0x000fe200078e023dULL, 0x00005e0007067a11ULL, 0x000fe200078448ffULL,
0x0000001025047825ULL, 0x000fe200078e0004ULL, 0xfffffff823407812ULL, 0x000fc400078ee20eULL,
0x00005f0007077a11ULL, 0x000fe200010f4c0cULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0x000000740f0f7210ULL, 0x080fe20007f9e0ffULL, 0x0000001020357824ULL, 0x000fe200078e0255ULL,
0x00005e000d0c7a11ULL, 0x000fe200078448ffULL, 0x0000001025067825ULL, 0x000fe200078e0006ULL,
0x0000007411117210ULL, 0x000fe40007fde0ffULL, 0x00005f000d0d7a11ULL, 0x000fe200010f4c0eULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078448ffULL,
0x000000ffff127224ULL, 0x000fe200030e06ffULL, 0x000000241300720cULL, 0x0c0fe20003f86070ULL,
0x0000000113137824ULL, 0x000fe200078e0202ULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c10ULL,
0x000000014a237824ULL, 0x000fe200078e0243ULL, 0x00005e0011107a11ULL, 0x000fe200078c48ffULL,
0x0000001022377824ULL, 0x000fe200078e0255ULL, 0x0000000713137812ULL, 0x000fe200078ec0ffULL,
0x00000010250c7825ULL, 0x000fe200078e000cULL, 0x000000242100720cULL, 0x000fc40003f46070ULL,
0x00005f0011117a11ULL, 0x000fe200030f4c12ULL, 0x000000014a217824ULL, 0x000fe200078e023fULL,
0x0ffffff813127812ULL, 0x000fc800078ef802ULL, 0x0000007421137210ULL, 0x080fe20007fde0ffULL,
0x0000001012277824ULL, 0x000fe400078e0255ULL, 0x000000014a217824ULL, 0x000fe400078e0241ULL,
0x000000ffff207224ULL, 0x000fe200030e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004277faeULL, 0x0003e2000e101c46ULL, 0x00005e0013127a11ULL, 0x000fe400078c48ffULL,
0x0000007421217210ULL, 0x000fe20007f9e0ffULL, 0x0000000006357faeULL, 0x0005e2000d901c46ULL,
0x00005f0013137a11ULL, 0x000fc400030f4c20ULL, 0x0000007423237210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff227224ULL, 0x000fe200020e06ffULL, 0x00005e0021207a11ULL, 0x000fe200078c48ffULL,
0x000000000c377faeULL, 0x0007e2000e901c46ULL, 0x000000243d00720cULL, 0x080fe20003f86070ULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x00005f0021217a11ULL, 0x000fe200030f4c22ULL,
0x0000001025047825ULL, 0x002fe200078e000eULL, 0x00005e0023227a11ULL, 0x000fe400078648ffULL,
0x000000243f00720cULL, 0x080fe20003fc6070ULL, 0x0000001025067825ULL, 0x004fe200078e0010ULL,
0x000000244100720cULL, 0x000fc40003fa6070ULL, 0x00005f0023237a11ULL, 0x000fe200018f4c26ULL,
0x0000001025107825ULL, 0x000fe200078e0020ULL, 0x000000244300720cULL, 0x000fc60003f66070ULL,
0x00000010250e7825ULL, 0x000fc800078e0012ULL, 0x0000001034217824ULL, 0x000fe400078e0255ULL,
0x0000001025127825ULL, 0x000fc600078e0022ULL, 0x0000000004217faeULL, 0x0003e2000d101c46ULL,
0x00000010360d7824ULL, 0x108fe400078e0255ULL, 0x000000103c237824ULL, 0x100fe400078e0255ULL,
0x000000103e257824ULL, 0x100fe200078e0255ULL, 0x00000000060d7faeULL, 0x0003e2000e101c46ULL,
0x0000001040277824ULL, 0x000fc600078e0255ULL, 0x000000000e237faeULL, 0x0003e8000f101c46ULL,
0x0000000010257faeULL, 0x0003e8000e901c46ULL, 0x0000000012277faeULL, 0x0003e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x0000000c020f7811ULL, 0x060fe400078fe8ffULL,
0x0000001002137811ULL, 0x000fc400078fe8ffULL, 0x00000008020d7811ULL, 0x040fe200078fe8ffULL,
0x000000010f067824ULL, 0x140fe200078e0202ULL, 0x0000000402077811ULL, 0x040fe200078fe8ffULL,
0x000000080f217824ULL, 0x000fe200078e00ffULL, 0x0000001c02277811ULL, 0x040fe200078fe8ffULL,
0x00000001130c7824ULL, 0x040fe400078e0202ULL, 0x0000000813237824ULL, 0x000fe200078e00ffULL,
0xfffffff821407812ULL, 0x000fe200078ee206ULL, 0x000000010d057824ULL, 0x040fe200078e0202ULL,
0x0000001402217811ULL, 0x040fe200078fe8ffULL, 0x000000080d3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff823427812ULL, 0x000fe200078ee20cULL, 0x0000000107047824ULL, 0x040fe200078e0202ULL,
0x0000001802237811ULL, 0x000fe200078fe8ffULL, 0x0000000807117824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee205ULL, 0x000000014a0d7824ULL, 0x000fe200078e020dULL,
0x0000004a02057211ULL, 0x000fe200078fe8ffULL, 0x000000014a0f7824ULL, 0x040fe200078e020fULL,
0xfffffff8113c7812ULL, 0x000fe200078ee204ULL, 0x0000000121047824ULL, 0x100fe200078e0202ULL,
0x0000007405057210ULL, 0x080fe20007f5e0ffULL, 0x0000000821117824ULL, 0x000fe200078e00ffULL,
0x000000740d0d7210ULL, 0x080fe20007f9e0ffULL, 0x0000000123067824ULL, 0x000fe200078e0202ULL,
0x000000740f0f7210ULL, 0x000fe20007fbe0ffULL, 0x0000000823257824ULL, 0x000fe200078e00ffULL,
0xfffffff8116c7812ULL, 0x000fe200078ee204ULL, 0x000000014a077824ULL, 0x000fe200078e0207ULL,
0x0000000202117211ULL, 0x000fe200078fe8ffULL, 0x00000001270c7824ULL, 0x000fe200078e0202ULL,
0xfffffff8256e7812ULL, 0x000fe200078ee206ULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0x0000007407077210ULL, 0x080fe20007f7e0ffULL, 0x0000000827357824ULL, 0x000fe200078e00ffULL,
0x00005e0005047a11ULL, 0x000fe200078448ffULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078848ffULL, 0x000000ffff107224ULL, 0x000fe200028e06ffULL,
0x0000000711117812ULL, 0x000fe200078ec0ffULL, 0x000000014a137824ULL, 0x040fe200078e0213ULL,
0x00005f0005057a11ULL, 0x000fe200010f4c06ULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0xfffffff835707812ULL, 0x000fe200078ee20cULL, 0x000000014a217824ULL, 0x040fe200078e0221ULL,
0x00005e0007067a11ULL, 0x000fe200078448ffULL, 0x000000014a237824ULL, 0x040fe200078e0223ULL,
0x00005e000d0c7a11ULL, 0x000fe200078648ffULL, 0x000000014a277824ULL, 0x000fe200078e0227ULL,
0x00005f000f0f7a11ULL, 0x000fe200020f4c10ULL, 0x0000000148257824ULL, 0x000fe200078e0253ULL,
0x0ffffff811107812ULL, 0x000fe200078ef802ULL, 0x000000103c357824ULL, 0x000fe200078e0255ULL,
0x0000007413117210ULL, 0x000fe20007f9e0ffULL, 0x0000001025047825ULL, 0x000fe200078e0004ULL,
0x00005f0007077a11ULL, 0x000fc400010f4c20ULL, 0x0000007421137210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff367224ULL, 0x000fe200020e06ffULL, 0x00005f000d0d7a11ULL, 0x000fe200018f4c12ULL,
0x0000001025067825ULL, 0x000fe200078e0006ULL, 0x0000007423217210ULL, 0x080fe40007f5e0ffULL,
0x0000007427237210ULL, 0x000fe20007f7e0ffULL, 0x0000001010277824ULL, 0x100fe200078e0255ULL,
0x00005e0011107a11ULL, 0x000fe200078848ffULL, 0x000000ffff347224ULL, 0x000fe200028e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078a48ffULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x00005e0021207a11ULL, 0x000fe200078448ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005e0023227a11ULL, 0x000fe200078648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004277faeULL, 0x0003e2000b901c46ULL, 0x00005f0011117a11ULL, 0x000fe200020f4c36ULL,
0x000000103e377824ULL, 0x000fe200078e0255ULL, 0x00005f0013137a11ULL, 0x000fe200028f4c34ULL,
0x00000010250c7825ULL, 0x000fe200078e000cULL, 0x00005f0021217a11ULL, 0x000fe200010f4c26ULL,
0x0000000006357faeULL, 0x0005e2000b901c46ULL, 0x00005f0023237a11ULL, 0x000fe200018f4c24ULL,
0x00000010250e7825ULL, 0x000fc400078e000eULL, 0x000000000c377faeULL, 0x0005e4000b901c46ULL,
0x0000001025107825ULL, 0x000fc800078e0010ULL, 0x0000001025127825ULL, 0x000fc800078e0012ULL,
0x0000001025207825ULL, 0x000fc800078e0020ULL, 0x0000001025227825ULL, 0x000fc800078e0022ULL,
0x0000001040057824ULL, 0x102fe400078e0255ULL, 0x0000001042257824ULL, 0x100fe400078e0255ULL,
0x000000106c277824ULL, 0x100fe200078e0255ULL, 0x000000000e057faeULL, 0x0005e2000b901c46ULL,
0x000000106e3d7824ULL, 0x100fe400078e0255ULL, 0x00000010703f7824ULL, 0x000fe200078e0255ULL,
0x0000000010257faeULL, 0x0005e8000b901c46ULL, 0x0000000012277faeULL, 0x0005e8000b901c46ULL,
0x00000000203d7faeULL, 0x0005e8000b901c46ULL, 0x00000000223f7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000050ff04723eULL, 0x002fe400000000ffULL, 0x00000002ff0c7819ULL, 0x004fe40000011602ULL,
0x0000541004417816ULL, 0x000fe20000000004ULL, 0x000133427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c41517589ULL, 0x0002a400000e0000ULL, 0x000000080c067810ULL, 0x000fe20007ffe0ffULL,
0x000133627f007947ULL, 0x000fea000b800000ULL, 0x00001f0641527589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000100c067810ULL, 0x008fe40007ffe0ffULL,
0x00006e6000047802ULL, 0x000fc40000000f00ULL, 0x00013c2000007944ULL, 0x006fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000180c067810ULL, 0x00cfe40007ffe0ffULL,
0x00006ea000047802ULL, 0x000fc40000000f00ULL, 0x00013be000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000a8005f3c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006470783bULL, 0x000fe20000004200ULL,
0x0000a800650c7811ULL, 0x006fc600078e20ffULL, 0x000000003c3c783bULL, 0x000e680000000200ULL,
0x00000000616c783bULL, 0x000fe80000004200ULL, 0x000000006204783bULL, 0x008fe80000004200ULL,
0x000000006340783bULL, 0x000fe80000004200ULL, 0x000000000c0c783bULL, 0x000ea80000000200ULL,
0x000000006934783bULL, 0x000ee80000004200ULL, 0x000000006624783bULL, 0x000f280000004200ULL,
0x000000006720783bULL, 0x000ee80000004200ULL, 0x000000006810783bULL, 0x000ee20000004200ULL,
0x000000513c3c0232ULL, 0x002fc40000000000ULL, 0x000000513e3e0232ULL, 0x000fe40000000000ULL,
0x000000523d3d0232ULL, 0x080fe40000000000ULL, 0x000000523f3f0232ULL, 0x000fce0000000000ULL,
0x000000703c14723cULL, 0x000f620000001814ULL, 0x000000510c0c0232ULL, 0x084fe40000000000ULL,
0x000000510e0e0232ULL, 0x000fe40000000000ULL, 0x000000520d0d0232ULL, 0x000fc60000000000ULL,
0x000000723c18723cULL, 0x000f620000001818ULL, 0x000000520f0f0232ULL, 0x000fce0000000000ULL,
0x0000006c3c1c723cULL, 0x040f70000000181cULL, 0x000000043c28723cULL, 0x040ff00000001828ULL,
0x0000006e3c30723cULL, 0x040f700000001830ULL, 0x000000063c04723cULL, 0x040f70000000182cULL,
0x000000403c08723cULL, 0x040f700000001808ULL, 0x000000423c38723cULL, 0x000f700000001838ULL,
0x000000340c14723cULL, 0x068b700000001814ULL, 0x000000360c18723cULL, 0x040b700000001818ULL,
0x000000240c1c723cULL, 0x050b70000000181cULL, 0x000000260c24723cULL, 0x040b700000001830ULL,
0x000000200c28723cULL, 0x040b700000001828ULL, 0x000000220c34723cULL, 0x040b700000001804ULL,
0x000000100c08723cULL, 0x040b700000001808ULL, 0x000000120c2c723cULL, 0x000b620000001838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000008003057811ULL, 0x020fe200078e40ffULL,
0x01469000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000440500720cULL, 0x000fda0003f06070ULL,
0x0000561000000947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011602ULL,
0x0000000148317824ULL, 0x000fe200078e0253ULL, 0x000000204a0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000a003057811ULL, 0x000fe400078e40ffULL, 0x000000040d237810ULL, 0x040fe20007ffe0ffULL,
0x000000010d077824ULL, 0x040fe200078e020eULL, 0x0000000544067217ULL, 0x000fe40007800000ULL,
0x000000080d397810ULL, 0x000fe20007ffe0ffULL, 0x00000001230f7824ULL, 0x000fe200078e0202ULL,
0x0000007407077210ULL, 0x000fe20007f1e0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a05ULL,
0x000000140d497810ULL, 0x000fe20007ffe0ffULL, 0x0000000823127824ULL, 0x000fe200078e00ffULL,
0x0000000c0d3d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005e0007047a11ULL, 0x000fe200078048ffULL, 0x0000000123117824ULL, 0x000fe200078e020eULL,
0xfffffff812337812ULL, 0x000fe200078ee20fULL, 0x0000000149137824ULL, 0x000fe200078e0202ULL,
0x00005f0007057a11ULL, 0x000fe200000f4c0cULL, 0x000000010d077824ULL, 0x100fe200078e0202ULL,
0x0000002006307817ULL, 0x000fe20003800000ULL, 0x0000000849207824ULL, 0x000fe200078e00ffULL,
0x000000100d417810ULL, 0x000fe20007ffe0ffULL, 0x0000000139107824ULL, 0x000fe200078e0202ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x00000008393b7824ULL, 0x000fe200078e00ffULL,
0x000000300d00720cULL, 0x000fe20003f06070ULL, 0x0000001031047825ULL, 0x000fe200078e0004ULL,
0x0ffffff8070f7812ULL, 0x000fc400078ef802ULL, 0x0000007411077210ULL, 0x080fe20007f5e0ffULL,
0x0000000149217824ULL, 0x000fe200078e020eULL, 0x000000180d6f7810ULL, 0x000fe20007ffe0ffULL,
0x000000100f117824ULL, 0x000fe200078e0260ULL, 0x0000001c0d737810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005e0007067a11ULL, 0x000fe200078448ffULL,
0x00000001390d7824ULL, 0x100fe200078e020eULL, 0xfffffff8206d7812ULL, 0x000fe200078ee213ULL,
0x000000013d0f7824ULL, 0x000fe200078e020eULL, 0x00005f0007077a11ULL, 0x000fe200010f4c0cULL,
0x0000000141137824ULL, 0x000fe200078e020eULL, 0x000000740d0d7210ULL, 0x080fe20007f5e0ffULL,
0x0000000141127824ULL, 0x000fe200078e0202ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL,
0x0000000841437824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e2000c101c46ULL, 0x000000016f717824ULL, 0x000fe200078e020eULL,
0x000000740f0f7210ULL, 0x000fe20007f7e0ffULL, 0x000000013d107824ULL, 0x000fe200078e0202ULL,
0x00005e000d0c7a11ULL, 0x000fe200078c48ffULL, 0x000000083d3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee212ULL, 0x0000000173757824ULL, 0x000fc400078e020eULL,
0x000000086f127824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee210ULL,
0x0000000173107824ULL, 0x100fe200078e0202ULL, 0x0000007413117210ULL, 0x082fe20007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200010e06ffULL, 0x0000007421137210ULL, 0x080fe20007f9e0ffULL,
0x000000016f057824ULL, 0x000fe200078e0202ULL, 0x0000007471217210ULL, 0x080fe20007fbe0ffULL,
0x0000001033337824ULL, 0x000fe200078e0260ULL, 0x0000007475747210ULL, 0x000fe20007f5e0ffULL,
0x0000000873757824ULL, 0x000fe200078e00ffULL, 0x00005f000d0d7a11ULL, 0x000fe200030f4c04ULL,
0x000000ffff047224ULL, 0x000fe200018e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078c48ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0260ULL, 0xfffffff812717812ULL, 0x000fe200078ee205ULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x000000302300720cULL, 0x000fe20003f66070ULL,
0x000000103f3f7824ULL, 0x000fe200078e0260ULL, 0xfffffff875757812ULL, 0x000fe200078ee210ULL,
0x0000001043437824ULL, 0x000fe200078e0260ULL, 0x00005f000f0f7a11ULL, 0x000fe200030f4c04ULL,
0x0000001031047825ULL, 0x000fe200078e0006ULL, 0x00005e0011107a11ULL, 0x000fc400078c48ffULL,
0x000000303900720cULL, 0x080fe20003f06070ULL, 0x000000ffff067224ULL, 0x000fe200020e06ffULL,
0x00005f0011117a11ULL, 0x000fe200030f4c12ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078c48ffULL, 0x0000000004337faeULL, 0x0003e2000d901c46ULL,
0x000000303d00720cULL, 0x080fe20003f66070ULL, 0x000000106d6d7824ULL, 0x000fe200078e0260ULL,
0x00005f0013137a11ULL, 0x000fe200030f4c06ULL, 0x000000ffff067224ULL, 0x000fe200028e06ffULL,
0x00005e0021207a11ULL, 0x000fe200078a48ffULL, 0x0000001071717824ULL, 0x100fe200078e0260ULL,
0x00005e0074227a11ULL, 0x000fe200078c48ffULL, 0x0000001075757824ULL, 0x000fe200078e0260ULL,
0x000000304100720cULL, 0x000fc40003f86070ULL, 0x000000304900720cULL, 0x080fe20003f46070ULL,
0x0000001031047825ULL, 0x002fe200078e000cULL, 0x00005f0021217a11ULL, 0x000fe400028f4c06ULL,
0x000000306f00720cULL, 0x080fe20003fa6070ULL, 0x00000010310c7825ULL, 0x000fe200078e0010ULL,
0x00005f0074237a11ULL, 0x000fe200030f4c07ULL, 0x00000000043b7faeULL, 0x0003e2000c101c46ULL,
0x000000307300720cULL, 0x000fe20003fc6070ULL, 0x0000001031067825ULL, 0x000fc800078e000eULL,
0x00000010310e7825ULL, 0x040fe200078e0012ULL, 0x00000000063f7faeULL, 0x0003e6000d901c46ULL,
0x0000001031107825ULL, 0x040fe200078e0020ULL, 0x000000000c437faeULL, 0x0003e6000e101c46ULL,
0x0000001031127825ULL, 0x000fe200078e0022ULL, 0x000000000e6d7faeULL, 0x0003e8000d101c46ULL,
0x0000000010717faeULL, 0x0003e8000e901c46ULL, 0x0000000012757faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x0000000402047811ULL, 0x040fe400078fe8ffULL,
0x00000008020d7811ULL, 0x000fc400078fe8ffULL, 0x0000001002127811ULL, 0x000fe200078fe8ffULL,
0x0000000104057824ULL, 0x100fe200078e0202ULL, 0x000000204a0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000804067824ULL, 0x000fe200078e00ffULL, 0x0000001402207811ULL, 0x040fe200078fe8ffULL,
0x000000080d0c7824ULL, 0x040fe200078e00ffULL, 0x0000000c02107811ULL, 0x000fe200078fe8ffULL,
0x0000000112077824ULL, 0x100fe200078e0202ULL, 0xfffffff806397812ULL, 0x000fe200078ee205ULL,
0x000000010d057824ULL, 0x000fe200078e0202ULL, 0x0000001802227811ULL, 0x000fe200078fe8ffULL,
0x00000008120e7824ULL, 0x000fc400078e00ffULL, 0x0000000120117824ULL, 0x100fe200078e0202ULL,
0xfffffff80c3b7812ULL, 0x000fe200078ee205ULL, 0x0000000820307824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3f7812ULL, 0x000fe200078ee207ULL, 0x0000000104077824ULL, 0x000fe200078e020fULL,
0x0000000f02057211ULL, 0x000fe200078fe8ffULL, 0x0000000110067824ULL, 0x100fe200078e0202ULL,
0xfffffff830417812ULL, 0x000fe200078ee211ULL, 0x00000008103d7824ULL, 0x000fe200078e00ffULL,
0x0000007405057210ULL, 0x080fe20007f1e0ffULL, 0x0000000122137824ULL, 0x040fe200078e0202ULL,
0x0000007407077210ULL, 0x080fe20007f5e0ffULL, 0x0000000822327824ULL, 0x000fe200078e00ffULL,
0x0000001c02307811ULL, 0x000fe200078fe8ffULL, 0x000000010d0d7824ULL, 0x000fe200078e020fULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee206ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005e0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0xfffffff832437812ULL, 0x000fe200078ee213ULL, 0x0000000110117824ULL, 0x100fe200078e020fULL,
0x00005e0007067a11ULL, 0x000fe200078448ffULL, 0x0000000112137824ULL, 0x100fe200078e020fULL,
0x000000740d0d7210ULL, 0x080fe20007f7e0ffULL, 0x0000000120217824ULL, 0x100fe200078e020fULL,
0x00005f0005057a11ULL, 0x000fe200000f4c0eULL, 0x0000000122237824ULL, 0x100fe200078e020fULL,
0x00005f0007077a11ULL, 0x000fe200010f4c0cULL, 0x0000000130317824ULL, 0x000fe200078e020fULL,
0x00000074110f7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x0000007413117210ULL, 0x080fe20007f5e0ffULL, 0x0000001039397824ULL, 0x100fe200078e0260ULL,
0x00005e000d0c7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x0000007421137210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000000202227211ULL, 0x000fe200078fe8ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0260ULL,
0x0000007423217210ULL, 0x080fe20007f7e0ffULL, 0x0000000130237824ULL, 0x040fe200078e0202ULL,
0x0000007431747210ULL, 0x000fe20007f9e0ffULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x00005f000d0d7a11ULL, 0x000fe200030f4c0eULL, 0x000000ffff327224ULL, 0x000fe200028e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078048ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0260ULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0260ULL,
0x0000000722317812ULL, 0x000fe200078ec0ffULL, 0x0000001041417824ULL, 0x000fe200078e0260ULL,
0xfffffff830497812ULL, 0x000fe200078ee223ULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005f000f0f7a11ULL, 0x000fe200000f4c20ULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0x00005f0011117a11ULL, 0x000fe200010f4c12ULL, 0x0000001043437824ULL, 0x000fe200078e0260ULL,
0x0ffffff831337812ULL, 0x000fe200078ef802ULL, 0x0000000148317824ULL, 0x000fe200078e0253ULL,
0x00005e0013127a11ULL, 0x000fe200078048ffULL, 0x0000001049497824ULL, 0x100fe200078e0260ULL,
0x00005e0021207a11ULL, 0x000fe200078448ffULL, 0x0000001033337824ULL, 0x000fe200078e0260ULL,
0x00005e0074227a11ULL, 0x000fe200078648ffULL, 0x0000001031047825ULL, 0x000fe200078e0004ULL,
0x00005f0013137a11ULL, 0x000fc400000f4c32ULL, 0x00005f0021217a11ULL, 0x000fe200010f4c30ULL,
0x0000001031067825ULL, 0x040fe200078e0006ULL, 0x00005f0074237a11ULL, 0x000fe200018f4c23ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004337faeULL, 0x0003e4000b901c46ULL,
0x00000010310c7825ULL, 0x040fe400078e000cULL, 0x0000000006397faeULL, 0x0003e4000b901c46ULL,
0x00000010310e7825ULL, 0x040fe400078e000eULL, 0x000000000c3b7faeULL, 0x0003e4000b901c46ULL,
0x0000001031107825ULL, 0x000fc400078e0010ULL, 0x000000000e3d7faeULL, 0x0003e4000b901c46ULL,
0x0000001031127825ULL, 0x040fe400078e0012ULL, 0x00000000103f7faeULL, 0x0003e4000b901c46ULL,
0x0000001031207825ULL, 0x040fe400078e0020ULL, 0x0000000012417faeULL, 0x0003e4000b901c46ULL,
0x0000001031227825ULL, 0x000fc400078e0022ULL, 0x0000000020437faeULL, 0x0003e8000b901c46ULL,
0x0000000022497faeULL, 0x0003e4000b901c46ULL, 0x00000300ff047624ULL, 0x002fe200078e00ffULL,
0x0000000347057812ULL, 0x000fe200078ec0ffULL, 0xffffffffff497424ULL, 0x000fc600078e00ffULL,
0x000000030500780cULL, 0x000fe40003f05270ULL, 0xfffffffd04047811ULL, 0x000fc800078e10ffULL,
0x0000000104047807ULL, 0x000fca0004000000ULL, 0x0000000147477824ULL, 0x000fca00078e0204ULL,
0x000000454700720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000147047824ULL, 0x000fe400078e024dULL, 0x00000004ff057424ULL, 0x000fc800078e00ffULL,
0x0000600004047625ULL, 0x000fca00078e0005ULL, 0x0000000604497981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01464800480c7f8cULL, 0x0004e4000c80043fULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x01464c0048077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x00afe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000f06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01464c0048077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x014100004e077984ULL, 0x000e680000000800ULL, 0x014300004e0c7984ULL, 0x0006a20000000800ULL,
0x0000006a0700720bULL, 0x002fe20003f1d000ULL, 0x00011ef27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0dff7812ULL, 0x000fe2000784c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x000004200000a947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f05270ULL,
0x0000006a0700720bULL, 0x000fe20003f54000ULL, 0x00011ec27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x000fc400010e0100ULL, 0x000000076a058209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100e047816ULL, 0x000fc600000000ffULL,
0x014500054e008388ULL, 0x0003e20000000800ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000076a057209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0eff7812ULL, 0x000fc6000780c0ffULL,
0x800000056a047221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL,
0x0000000400417308ULL, 0x000e640000000800ULL, 0x000000414b4b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff067819ULL, 0x000fe20000011602ULL,
0x00011df27f007947ULL, 0x000fea000b800000ULL, 0x00001f0641067589ULL, 0x0002e400000e0000ULL,
0x0000000614147220ULL, 0x08cfe20000410000ULL, 0x0000000615157220ULL, 0x080fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000619197220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000628287220ULL, 0x080fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000608087220ULL, 0x080fe20000410000ULL, 0x0000000609097220ULL, 0x080fe20000410000ULL,
0x000000062c2c7220ULL, 0x080fe20000410000ULL, 0x000000062d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000eff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802067811ULL, 0x000fe200078ff0ffULL,
0x00011cc27f007947ULL, 0x000fea000b800000ULL, 0x00001f0641067589ULL, 0x00066400000e0000ULL,
0x0000000616167220ULL, 0x086fe20000410000ULL, 0x0000000617177220ULL, 0x080fe20000410000ULL,
0x000000061a1a7220ULL, 0x080fe20000410000ULL, 0x000000061b1b7220ULL, 0x080fe20000410000ULL,
0x000000061e1e7220ULL, 0x080fe20000410000ULL, 0x000000061f1f7220ULL, 0x080fe20000410000ULL,
0x0000000626267220ULL, 0x080fe20000410000ULL, 0x0000000627277220ULL, 0x080fe20000410000ULL,
0x000000062a2a7220ULL, 0x080fe20000410000ULL, 0x000000062b2b7220ULL, 0x080fe20000410000ULL,
0x0000000636367220ULL, 0x080fe20000410000ULL, 0x0000000637377220ULL, 0x080fe20000410000ULL,
0x000000060a0a7220ULL, 0x080fe20000410000ULL, 0x000000060b0b7220ULL, 0x080fe20000410000ULL,
0x000000062e2e7220ULL, 0x080fe20000410000ULL, 0x000000062f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff0eff7812ULL, 0x000fe4000780080dULL,
0x000000076a6a7209ULL, 0x000fd60007810000ULL, 0x8000006a07070221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b07070820ULL, 0x000fc80000410000ULL, 0x0000000700500308ULL, 0x000e640000000800ULL,
0x000000500c0c0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000004b0c4b7221ULL, 0x004fe20000010000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000050ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0c7819ULL, 0x000fe40000011602ULL,
0x0000541004417816ULL, 0x008fe20000000004ULL, 0x00011ae27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c41517589ULL, 0x0002a400000e0000ULL, 0x000000080c067810ULL, 0x000fe20007ffe0ffULL,
0x00011b027f007947ULL, 0x000fea000b800000ULL, 0x00001f0641527589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000100c067810ULL, 0x008fe40007ffe0ffULL,
0x0000884000047802ULL, 0x000fc40000000f00ULL, 0x0001224000007944ULL, 0x016fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000180c067810ULL, 0x00cfe40007ffe0ffULL,
0x0000888000047802ULL, 0x000fc40000000f00ULL, 0x0001220000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000b000543c7811ULL, 0x000fcc00078e20ffULL, 0x000000003c3c783bULL, 0x000ee20000000200ULL,
0x0000b0005a0c7811ULL, 0x002fe200078e20ffULL, 0x0000580049747a24ULL, 0x010fc400078e02ffULL,
0x00000000576c783bULL, 0x000e640000004200ULL, 0x0000004074747824ULL, 0x000fe400078e00ffULL,
0x000000005804783bULL, 0x00cfe80000004200ULL, 0x000000005670783bULL, 0x000fe80000004200ULL,
0x000000005940783bULL, 0x000fe80000004200ULL, 0x000000000c0c783bULL, 0x000ea80000000200ULL,
0x000000005c30783bULL, 0x000ee80000004200ULL, 0x000000005b38783bULL, 0x000ee80000004200ULL,
0x000000005d20783bULL, 0x000ee80000004200ULL, 0x000000005e10783bULL, 0x000ee20000004200ULL,
0x000000513c3c0232ULL, 0x000fc40000000000ULL, 0x000000513e3e0232ULL, 0x000fe40000000000ULL,
0x000000523d3d0232ULL, 0x080fe40000000000ULL, 0x000000523f3f0232ULL, 0x000fce0000000000ULL,
0x0000006c3c1c723cULL, 0x002f62000000181cULL, 0x000000510c0c0232ULL, 0x004fce0000000000ULL,
0x0000006e3c24723cULL, 0x000f620000001824ULL, 0x000000510e0e0232ULL, 0x000fe40000000000ULL,
0x000000520d0d0232ULL, 0x080fe40000000000ULL, 0x000000520f0f0232ULL, 0x000fc60000000000ULL,
0x000000043c28723cULL, 0x040ff00000001828ULL, 0x000000703c14723cULL, 0x040f700000001814ULL,
0x000000723c18723cULL, 0x040f700000001818ULL, 0x000000063c04723cULL, 0x040f700000001834ULL,
0x000000403c08723cULL, 0x040f700000001808ULL, 0x000000423c2c723cULL, 0x000f70000000182cULL,
0x000000300c1c723cULL, 0x068b70000000181cULL, 0x000000320c24723cULL, 0x040b700000001824ULL,
0x000000380c14723cULL, 0x040b700000001814ULL, 0x0000003a0c18723cULL, 0x040b700000001818ULL,
0x000000200c28723cULL, 0x040b700000001828ULL, 0x000000220c30723cULL, 0x040b700000001804ULL,
0x000000100c20723cULL, 0x040b700000001808ULL, 0x000000120c38723cULL, 0x000b62000000182cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000009947ULL, 0x000fca0003800000ULL,
0x000000c003057811ULL, 0x020fe200078e40ffULL, 0x00000001482d7824ULL, 0x000fe200078e0253ULL,
0x00000003ff0f7819ULL, 0x100fe40000011602ULL, 0x0000000544047217ULL, 0x000fe40007800000ULL,
0x000000040f0b7810ULL, 0x040fe40007ffe0ffULL, 0x000000080f0d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000104067824ULL, 0x000fe200078e0a05ULL, 0x000000100f3d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b077824ULL, 0x100fe200078e0202ULL, 0x0000000c0f117810ULL, 0x000fe20007ffe0ffULL,
0x000000080b107824ULL, 0x000fe200078e00ffULL, 0x000000140f3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d087824ULL, 0x100fe200078e0202ULL, 0x000000180f417810ULL, 0x000fe20007ffe0ffULL,
0x000000080d097824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x000000013d057824ULL, 0x000fe200078e0202ULL, 0x0000001c0f437810ULL, 0x000fe20007ffe0ffULL,
0x000000083d367824ULL, 0x000fe200078e00ffULL, 0xfffffff809127812ULL, 0x000fe200078ee208ULL,
0x0000000111047824ULL, 0x140fe200078e0202ULL, 0x00000020062c7817ULL, 0x000fe20003800000ULL,
0x0000000811097824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee205ULL,
0x000000013f077824ULL, 0x000fe200078e0202ULL, 0x0000002c0d00720cULL, 0x000fe20003fa6070ULL,
0x000000083f3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff809347812ULL, 0x000fe200078ee204ULL,
0x000000014a057824ULL, 0x000fc400078e020fULL, 0x0000000141097824ULL, 0x100fe200078e0202ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee207ULL, 0x000000014a077824ULL, 0x000fe200078e020bULL,
0x0000007405057210ULL, 0x080fe20007f5e0ffULL, 0x00000008413e7824ULL, 0x000fe400078e00ffULL,
0x00000001430a7824ULL, 0x000fe200078e0202ULL, 0x0000007407077210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff087224ULL, 0x000fe200010e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078448ffULL,
0x0000000843137824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee209ULL,
0x000000014a097824ULL, 0x040fe200078e020dULL, 0x00005f0005057a11ULL, 0x000fe200010f4c08ULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x0000002c0b00720cULL, 0x000fe20003f66070ULL,
0x000000014a0b7824ULL, 0x040fe200078e0211ULL, 0x0000007409097210ULL, 0x000fe20007f9e0ffULL,
0x000000014a0d7824ULL, 0x000fe200078e023dULL, 0x00005e0007067a11ULL, 0x000fe200078448ffULL,
0x000000102d047825ULL, 0x000fe200078e0004ULL, 0xfffffff813407812ULL, 0x000fc400078ee20aULL,
0x00005f0007077a11ULL, 0x000fe200010f4c08ULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x000000740b0b7210ULL, 0x080fe20007f9e0ffULL, 0x0000001010357824ULL, 0x000fe200078e0255ULL,
0x00005e0009087a11ULL, 0x000fe200078448ffULL, 0x000000102d067825ULL, 0x000fe200078e0006ULL,
0x000000740d0d7210ULL, 0x000fe40007fde0ffULL, 0x00005f0009097a11ULL, 0x000fe200010f4c0aULL,
0x000000ffff0c7224ULL, 0x000fe200020e06ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff0e7224ULL, 0x000fe200030e06ffULL, 0x0000002c0f00720cULL, 0x0c0fe20003f86070ULL,
0x000000010f0f7824ULL, 0x000fe200078e0202ULL, 0x00005f000b0b7a11ULL, 0x000fe200010f4c0cULL,
0x000000014a137824ULL, 0x000fe200078e0243ULL, 0x00005e000d0c7a11ULL, 0x000fe200078c48ffULL,
0x0000001012377824ULL, 0x000fe200078e0255ULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000102d087825ULL, 0x000fe200078e0008ULL, 0x0000002c1100720cULL, 0x000fc40003f46070ULL,
0x00005f000d0d7a11ULL, 0x000fe200030f4c0eULL, 0x000000014a117824ULL, 0x000fe200078e023fULL,
0x0ffffff80f0e7812ULL, 0x000fc800078ef802ULL, 0x00000074110f7210ULL, 0x080fe20007fde0ffULL,
0x000000100e2f7824ULL, 0x000fe400078e0255ULL, 0x000000014a117824ULL, 0x000fe400078e0241ULL,
0x000000ffff107224ULL, 0x000fe200030e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000042f7faeULL, 0x0003e2000e101c46ULL, 0x00005e000f0e7a11ULL, 0x000fe400078c48ffULL,
0x0000007411117210ULL, 0x000fe20007f9e0ffULL, 0x0000000006357faeULL, 0x0005e2000d901c46ULL,
0x00005f000f0f7a11ULL, 0x000fc400030f4c10ULL, 0x0000007413137210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078c48ffULL,
0x0000000008377faeULL, 0x0007e2000e901c46ULL, 0x0000002c3d00720cULL, 0x080fe20003f86070ULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005f0011117a11ULL, 0x000fe200030f4c12ULL,
0x000000102d047825ULL, 0x002fe200078e000aULL, 0x00005e0013127a11ULL, 0x000fe400078648ffULL,
0x0000002c3f00720cULL, 0x080fe20003fc6070ULL, 0x000000102d067825ULL, 0x004fe200078e000cULL,
0x0000002c4100720cULL, 0x000fc40003fa6070ULL, 0x00005f0013137a11ULL, 0x000fe200018f4c2eULL,
0x000000102d0c7825ULL, 0x000fe200078e0010ULL, 0x0000002c4300720cULL, 0x000fc60003f66070ULL,
0x000000102d0a7825ULL, 0x000fc800078e000eULL, 0x0000001034117824ULL, 0x000fe400078e0255ULL,
0x000000102d0e7825ULL, 0x000fc600078e0012ULL, 0x0000000004117faeULL, 0x0003e2000d101c46ULL,
0x0000001036097824ULL, 0x108fe400078e0255ULL, 0x000000103c137824ULL, 0x100fe400078e0255ULL,
0x000000103e2d7824ULL, 0x100fe200078e0255ULL, 0x0000000006097faeULL, 0x0003e2000e101c46ULL,
0x00000010402f7824ULL, 0x000fc600078e0255ULL, 0x000000000a137faeULL, 0x0003e8000f101c46ULL,
0x000000000c2d7faeULL, 0x0003e8000e901c46ULL, 0x000000000e2f7faeULL, 0x0003e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x0000000c020b7811ULL, 0x060fe400078fe8ffULL,
0x00000010020f7811ULL, 0x000fc400078fe8ffULL, 0x0000000802097811ULL, 0x040fe200078fe8ffULL,
0x000000010b067824ULL, 0x140fe200078e0202ULL, 0x0000000402077811ULL, 0x040fe200078fe8ffULL,
0x000000080b117824ULL, 0x000fe200078e00ffULL, 0x0000001c022f7811ULL, 0x040fe200078fe8ffULL,
0x000000010f087824ULL, 0x040fe400078e0202ULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0xfffffff811407812ULL, 0x000fe200078ee206ULL, 0x0000000109057824ULL, 0x040fe200078e0202ULL,
0x0000001402117811ULL, 0x040fe200078fe8ffULL, 0x00000008093e7824ULL, 0x000fe200078e00ffULL,
0xfffffff813427812ULL, 0x000fe200078ee208ULL, 0x0000000107047824ULL, 0x040fe200078e0202ULL,
0x0000001802137811ULL, 0x000fe200078fe8ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee205ULL, 0x000000014a097824ULL, 0x000fe200078e0209ULL,
0x0000004a02057211ULL, 0x000fe200078fe8ffULL, 0x000000014a0b7824ULL, 0x040fe200078e020bULL,
0xfffffff80d3c7812ULL, 0x000fe200078ee204ULL, 0x0000000111047824ULL, 0x100fe200078e0202ULL,
0x0000007405057210ULL, 0x080fe20007f5e0ffULL, 0x00000008110d7824ULL, 0x000fe200078e00ffULL,
0x0000007409097210ULL, 0x080fe20007f9e0ffULL, 0x0000000113067824ULL, 0x000fe200078e0202ULL,
0x000000740b0b7210ULL, 0x000fe20007fbe0ffULL, 0x00000008132d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d6c7812ULL, 0x000fe200078ee204ULL, 0x000000014a077824ULL, 0x000fe200078e0207ULL,
0x00000002020d7211ULL, 0x000fe200078fe8ffULL, 0x000000012f087824ULL, 0x000fe200078e0202ULL,
0xfffffff82d6e7812ULL, 0x000fe200078ee206ULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0x0000007407077210ULL, 0x080fe20007f7e0ffULL, 0x000000082f357824ULL, 0x000fe200078e00ffULL,
0x00005e0005047a11ULL, 0x000fe200078448ffULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0x00005e000b0a7a11ULL, 0x000fe200078848ffULL, 0x000000ffff0c7224ULL, 0x000fe200028e06ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000014a0f7824ULL, 0x040fe200078e020fULL,
0x00005f0005057a11ULL, 0x000fe200010f4c06ULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0xfffffff835707812ULL, 0x000fe200078ee208ULL, 0x000000014a117824ULL, 0x040fe200078e0211ULL,
0x00005e0007067a11ULL, 0x000fe200078448ffULL, 0x000000014a137824ULL, 0x040fe200078e0213ULL,
0x00005e0009087a11ULL, 0x000fe200078648ffULL, 0x000000014a2f7824ULL, 0x000fe200078e022fULL,
0x00005f000b0b7a11ULL, 0x000fe200020f4c0cULL, 0x00000001482d7824ULL, 0x000fe200078e0253ULL,
0x0ffffff80d0c7812ULL, 0x000fe200078ef802ULL, 0x000000103c357824ULL, 0x000fe200078e0255ULL,
0x000000740f0d7210ULL, 0x000fe20007f9e0ffULL, 0x000000102d047825ULL, 0x000fe200078e0004ULL,
0x00005f0007077a11ULL, 0x000fc400010f4c10ULL, 0x00000074110f7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff367224ULL, 0x000fe200020e06ffULL, 0x00005f0009097a11ULL, 0x000fe200018f4c0eULL,
0x000000102d067825ULL, 0x000fe200078e0006ULL, 0x0000007413117210ULL, 0x080fe40007f5e0ffULL,
0x000000742f137210ULL, 0x000fe20007f7e0ffULL, 0x000000100c2f7824ULL, 0x100fe200078e0255ULL,
0x00005e000d0c7a11ULL, 0x000fe200078848ffULL, 0x000000ffff347224ULL, 0x000fe200028e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078a48ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000042f7faeULL, 0x0003e2000b901c46ULL, 0x00005f000d0d7a11ULL, 0x000fe200020f4c36ULL,
0x000000103e377824ULL, 0x000fe200078e0255ULL, 0x00005f000f0f7a11ULL, 0x000fe200028f4c34ULL,
0x000000102d087825ULL, 0x000fe200078e0008ULL, 0x00005f0011117a11ULL, 0x000fe200010f4c2eULL,
0x0000000006357faeULL, 0x0005e2000b901c46ULL, 0x00005f0013137a11ULL, 0x000fe200018f4c2cULL,
0x000000102d0a7825ULL, 0x000fc400078e000aULL, 0x0000000008377faeULL, 0x0005e4000b901c46ULL,
0x000000102d0c7825ULL, 0x000fc800078e000cULL, 0x000000102d0e7825ULL, 0x000fc800078e000eULL,
0x000000102d107825ULL, 0x000fc800078e0010ULL, 0x000000102d127825ULL, 0x000fc800078e0012ULL,
0x0000001040057824ULL, 0x102fe400078e0255ULL, 0x00000010422d7824ULL, 0x100fe400078e0255ULL,
0x000000106c2f7824ULL, 0x100fe200078e0255ULL, 0x000000000a057faeULL, 0x0005e2000b901c46ULL,
0x000000106e3d7824ULL, 0x100fe400078e0255ULL, 0x00000010703f7824ULL, 0x000fe200078e0255ULL,
0x000000000c2d7faeULL, 0x0005e8000b901c46ULL, 0x000000000e2f7faeULL, 0x0005e8000b901c46ULL,
0x00000000103d7faeULL, 0x0005e8000b901c46ULL, 0x00000000123f7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000050ff04723eULL, 0x002fe400000000ffULL, 0x00000002ff087819ULL, 0x004fe40000011602ULL,
0x0000541004417816ULL, 0x000fe20000000004ULL, 0x00010a527f007947ULL, 0x000fea000b800000ULL,
0x00001f0841517589ULL, 0x0002a400000e0000ULL, 0x0000000808067810ULL, 0x000fe20007ffe0ffULL,
0x00010a727f007947ULL, 0x000fea000b800000ULL, 0x00001f0641527589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x0000001008067810ULL, 0x008fe40007ffe0ffULL,
0x0000996000047802ULL, 0x000fc40000000f00ULL, 0x0001112000007944ULL, 0x006fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x0000001808067810ULL, 0x00cfe40007ffe0ffULL,
0x000099a000047802ULL, 0x000fc40000000f00ULL, 0x000110e000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b0005f3c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000616c783bULL, 0x000fe20000004200ULL,
0x0000b000652c7811ULL, 0x000fc600078e20ffULL, 0x000000003c3c783bULL, 0x004ea80000000200ULL,
0x000000006204783bULL, 0x00afe80000004200ULL, 0x000000006470783bULL, 0x000fe80000004200ULL,
0x000000006340783bULL, 0x000fe80000004200ULL, 0x000000002c2c783bULL, 0x000e680000000200ULL,
0x000000006608783bULL, 0x000ee80000004200ULL, 0x000000006734783bULL, 0x000f280000004200ULL,
0x000000006910783bULL, 0x000ee80000004200ULL, 0x00000000680c783bULL, 0x000ee20000004200ULL,
0x000000513c3c0232ULL, 0x004fc40000000000ULL, 0x000000513e3e0232ULL, 0x000fe40000000000ULL,
0x000000523d3d0232ULL, 0x080fe40000000000ULL, 0x000000523f3f0232ULL, 0x000fce0000000000ULL,
0x0000006c3c1c723cULL, 0x000f62000000181cULL, 0x000000512c2c0232ULL, 0x082fe40000000000ULL,
0x000000512e2e0232ULL, 0x000fe40000000000ULL, 0x000000522d2d0232ULL, 0x000fc60000000000ULL,
0x0000006e3c24723cULL, 0x000f620000001824ULL, 0x000000522f2f0232ULL, 0x000fce0000000000ULL,
0x000000043c28723cULL, 0x040f700000001828ULL, 0x000000703c14723cULL, 0x040f700000001814ULL,
0x000000723c18723cULL, 0x040f700000001818ULL, 0x000000063c04723cULL, 0x040f700000001830ULL,
0x000000403c20723cULL, 0x040f700000001820ULL, 0x000000423c38723cULL, 0x000f700000001838ULL,
0x000000082c1c723cULL, 0x068b70000000181cULL, 0x0000000a2c24723cULL, 0x040b700000001824ULL,
0x000000342c28723cULL, 0x050b700000001828ULL, 0x000000102c14723cULL, 0x040b700000001814ULL,
0x000000122c18723cULL, 0x040b700000001818ULL, 0x000000362c34723cULL, 0x040b700000001804ULL,
0x0000000c2c08723cULL, 0x040b700000001820ULL, 0x0000000e2c2c723cULL, 0x000b620000001838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000c003057811ULL, 0x020fe200078e40ffULL,
0x01469800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000440500720cULL, 0x000fda0003f06070ULL,
0x00002b1000000947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff237819ULL, 0x100fe40000011602ULL,
0x000000e003057811ULL, 0x000fe400078e40ffULL, 0x00000008233b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000544047217ULL, 0x000fe40007800000ULL, 0x000000204a0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000013b077824ULL, 0x000fe200078e0202ULL, 0x0000000c233f7810ULL, 0x000fe20007ffe0ffULL,
0x000000083b107824ULL, 0x000fe200078e00ffULL, 0x0000000423337810ULL, 0x040fe20007ffe0ffULL,
0x00000001040e7824ULL, 0x000fe200078e0a05ULL, 0x0000001023437810ULL, 0x040fe20007ffe0ffULL,
0x0000000123057824ULL, 0x000fe200078e020cULL, 0xfffffff8103d7812ULL, 0x000fe200078ee207ULL,
0x000000013f077824ULL, 0x100fe200078e0202ULL, 0x00000014236d7810ULL, 0x000fe20007ffe0ffULL,
0x000000083f107824ULL, 0x000fe200078e00ffULL, 0x0000007405057210ULL, 0x080fe20007f1e0ffULL,
0x0000000133067824ULL, 0x100fe200078e0202ULL, 0x0000001823717810ULL, 0x000fe20007ffe0ffULL,
0x0000000833397824ULL, 0x000fe200078e00ffULL, 0xfffffff810417812ULL, 0x000fe200078ee207ULL,
0x00000001430d7824ULL, 0x000fe200078e0202ULL, 0x0000001c23757810ULL, 0x000fe20007ffe0ffULL,
0x0000000843127824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee206ULL,
0x0000000133077824ULL, 0x000fe200078e020cULL, 0x000000200e307817ULL, 0x000fe20003800000ULL,
0x000000016d0f7824ULL, 0x040fe200078e0202ULL, 0xfffffff812497812ULL, 0x000fe200078ee20dULL,
0x000000086d207824ULL, 0x000fe200078e00ffULL, 0x0000007407077210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078048ffULL,
0x000000013b0d7824ULL, 0x100fe200078e020cULL, 0xfffffff8206f7812ULL, 0x000fe200078ee20fULL,
0x000000013f0f7824ULL, 0x000fe200078e020cULL, 0x00005f0005057a11ULL, 0x000fe200000f4c06ULL,
0x0000000143117824ULL, 0x100fe200078e020cULL, 0x000000740d0d7210ULL, 0x080fe20007f1e0ffULL,
0x000000016d137824ULL, 0x100fe200078e020cULL, 0x00005e0007067a11ULL, 0x000fe200078c48ffULL,
0x0000000171217824ULL, 0x100fe200078e020cULL, 0x000000740f0f7210ULL, 0x080fe20007f5e0ffULL,
0x0000000175317824ULL, 0x000fe200078e020cULL, 0x0000007411117210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x0000007413137210ULL, 0x080fe20007f7e0ffULL,
0x0000000171127824ULL, 0x000fe200078e0202ULL, 0x0000007421217210ULL, 0x080fe20007fbe0ffULL,
0x0000000871737824ULL, 0x000fe200078e00ffULL, 0x00005f0007077a11ULL, 0x000fe200030f4c0cULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078048ffULL,
0x0000000175207824ULL, 0x000fe200078e0202ULL, 0xfffffff873737812ULL, 0x000fe200078ee212ULL,
0x0000000123127824ULL, 0x000fe200078e0202ULL, 0x00005f000d0d7a11ULL, 0x000fe200000f4c10ULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078c48ffULL,
0x0000000875777824ULL, 0x000fe200078e00ffULL, 0x0000007431747210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff327224ULL, 0x000fe200028e06ffULL, 0x0000000712317812ULL, 0x000fe200078ec0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x000000302300720cULL, 0x000fe20003f46070ULL,
0x0000001039397824ULL, 0x000fe200078e0260ULL, 0x00005f000f0f7a11ULL, 0x000fe200030f4c10ULL,
0x000000103d3d7824ULL, 0x100fe200078e0260ULL, 0x00005e0011107a11ULL, 0x000fe200078c48ffULL,
0x0000001041417824ULL, 0x000fe200078e0260ULL, 0x0ffffff831237812ULL, 0x000fe200078ef802ULL,
0x0000000148317824ULL, 0x000fe200078e0253ULL, 0xfffffff877777812ULL, 0x000fe200078ee220ULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0x00005f0011117a11ULL, 0x000fe200030f4c12ULL,
0x0000001031047825ULL, 0x000fe200078e0004ULL, 0x00005e0013127a11ULL, 0x000fc400078c48ffULL,
0x000000303300720cULL, 0x080fe20003f06070ULL, 0x0000001023337824ULL, 0x000fe200078e0260ULL,
0x00005f0013137a11ULL, 0x000fe200030f4c20ULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0x00005e0021207a11ULL, 0x000fe200078a48ffULL, 0x0000001049497824ULL, 0x100fe200078e0260ULL,
0x000000303b00720cULL, 0x080fe20003f26070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004337faeULL, 0x0003e2000d101c46ULL, 0x00005e0074227a11ULL, 0x000fe200078c48ffULL,
0x000000106f6f7824ULL, 0x100fe200078e0260ULL, 0x000000303f00720cULL, 0x080fe20003f66070ULL,
0x0000001073737824ULL, 0x100fe200078e0260ULL, 0x000000304300720cULL, 0x080fe20003f46070ULL,
0x0000001077777824ULL, 0x000fe200078e0260ULL, 0x000000306d00720cULL, 0x000fc40003f86070ULL,
0x00005f0021217a11ULL, 0x000fe400028f4c32ULL, 0x000000307100720cULL, 0x080fe20003fa6070ULL,
0x0000001031047825ULL, 0x002fe200078e0006ULL, 0x00005f0074237a11ULL, 0x000fe400030f4c23ULL,
0x000000307500720cULL, 0x000fe20003fc6070ULL, 0x0000001031067825ULL, 0x040fe200078e000cULL,
0x0000000004397faeULL, 0x0003e6000c101c46ULL, 0x00000010310c7825ULL, 0x040fe200078e000eULL,
0x00000000063d7faeULL, 0x0003e6000c901c46ULL, 0x00000010310e7825ULL, 0x040fe200078e0010ULL,
0x000000000c417faeULL, 0x0003e6000d901c46ULL, 0x0000001031107825ULL, 0x040fe200078e0012ULL,
0x000000000e497faeULL, 0x0003e6000d101c46ULL, 0x0000001031127825ULL, 0x040fe200078e0020ULL,
0x00000000106f7faeULL, 0x0003e6000e101c46ULL, 0x0000001031207825ULL, 0x000fe200078e0022ULL,
0x0000000012737faeULL, 0x0003e8000e901c46ULL, 0x0000000020777faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x0000000802107811ULL, 0x040fe400078fe8ffULL,
0x00000004020e7811ULL, 0x000fc400078fe8ffULL, 0x000000204a077810ULL, 0x000fe20007ffe0ffULL,
0x0000000110057824ULL, 0x100fe200078e0202ULL, 0x0000001002207811ULL, 0x000fe200078fe8ffULL,
0x0000000810067824ULL, 0x000fe200078e00ffULL, 0x0000000c02127811ULL, 0x000fe200078fe8ffULL,
0x000000010e047824ULL, 0x100fe200078e0202ULL, 0x0000001402227811ULL, 0x000fe200078fe8ffULL,
0x000000080e317824ULL, 0x000fe200078e00ffULL, 0xfffffff8063b7812ULL, 0x000fe200078ee205ULL,
0x0000000120067824ULL, 0x000fe200078e0202ULL, 0x0000000702057211ULL, 0x000fe200078fe8ffULL,
0x00000008203f7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee204ULL,
0x0000000112047824ULL, 0x040fe200078e0202ULL, 0x0000007405057210ULL, 0x000fe20007f1e0ffULL,
0x00000008123d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee206ULL,
0x00000001220c7824ULL, 0x000fe200078e0202ULL, 0x0000001802237811ULL, 0x000fe200078fe8ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL,
0x0000000822417824ULL, 0x000fe200078e00ffULL, 0x00005e0005047a11ULL, 0x000fe200078048ffULL,
0x00000001230d7824ULL, 0x000fc400078e0202ULL, 0x0000000823307824ULL, 0x000fe200078e00ffULL,
0x00005f0005057a11ULL, 0x000fe200000f4c06ULL, 0x000000010e0f7824ULL, 0x100fe200078e0207ULL,
0x0000001c02067811ULL, 0x000fe200078fe8ffULL, 0x0000000110117824ULL, 0x100fe200078e0207ULL,
0xfffffff841417812ULL, 0x000fe200078ee20cULL, 0x0000000112137824ULL, 0x100fe200078e0207ULL,
0x00000002020c7211ULL, 0x000fe200078fe8ffULL, 0x0000000120217824ULL, 0x000fe200078e0207ULL,
0xfffffff830437812ULL, 0x000fe200078ee20dULL, 0x0000000122337824ULL, 0x100fe200078e0207ULL,
0x000000070c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000123397824ULL, 0x000fc400078e0207ULL,
0x0000000106497824ULL, 0x040fe200078e0207ULL, 0x000000740f077210ULL, 0x080fe20007f9e0ffULL,
0x00000001060e7824ULL, 0x140fe200078e0202ULL, 0x0ffffff80d237812ULL, 0x000fe200078ef802ULL,
0x00000008066d7824ULL, 0x000fe200078e00ffULL, 0x00000074110d7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200020e06ffULL, 0x00000074130f7210ULL, 0x080fe20007f7e0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0260ULL, 0x00005e0007067a11ULL, 0x000fe200078c48ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000007421117210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x0000007433137210ULL, 0x080fe20007f1e0ffULL,
0x0000001023337824ULL, 0x100fe200078e0260ULL, 0x0000007439217210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x0000007449747210ULL, 0x000fe20007f9e0ffULL,
0x0000001031397824ULL, 0x000fe200078e0260ULL, 0xfffffff86d497812ULL, 0x000fe200078ee20eULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005f0007077a11ULL, 0x000fe200030f4c0cULL,
0x000000ffff307224ULL, 0x000fe200028e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078248ffULL,
0x0000000148317824ULL, 0x000fe200078e0253ULL, 0x00005e000f0e7a11ULL, 0x000fe200078648ffULL,
0x000000ffff237224ULL, 0x000fe200020e06ffULL, 0x00005f000d0d7a11ULL, 0x000fe200008f4c12ULL,
0x0000001031047825ULL, 0x000fe200078e0004ULL, 0x00005f000f0f7a11ULL, 0x000fc400018f4c10ULL,
0x00005e0011107a11ULL, 0x000fe200078248ffULL, 0x0000001031067825ULL, 0x000fe200078e0006ULL,
0x00005e0013127a11ULL, 0x000fe200078048ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004337faeULL, 0x0003e2000b901c46ULL, 0x00005e0021207a11ULL, 0x000fe200078448ffULL,
0x00000010310c7825ULL, 0x000fe200078e000cULL, 0x00005e0074227a11ULL, 0x040fe200078648ffULL,
0x0000000006397faeULL, 0x0003e2000b901c46ULL, 0x00005f0011117a11ULL, 0x000fe200008f4c38ULL,
0x000000103d3d7824ULL, 0x000fe200078e0260ULL, 0x00005f0013137a11ULL, 0x000fe200000f4c32ULL,
0x00000010310e7825ULL, 0x000fe200078e000eULL, 0x00005f0021217a11ULL, 0x000fe200010f4c30ULL,
0x000000000c3b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0074237a11ULL, 0x000fe200018f4c23ULL,
0x000000103f3f7824ULL, 0x000fc400078e0260ULL, 0x0000001031107825ULL, 0x000fe200078e0010ULL,
0x000000000e3d7faeULL, 0x0003e6000b901c46ULL, 0x0000001041417824ULL, 0x000fe200078e0260ULL,
0x00000000103f7faeULL, 0x0003e2000b901c46ULL, 0x0000001031127825ULL, 0x000fc800078e0012ULL,
0x0000001043437824ULL, 0x000fe200078e0260ULL, 0x0000000012417faeULL, 0x0003e2000b901c46ULL,
0x0000001031207825ULL, 0x000fc800078e0020ULL, 0x0000001049497824ULL, 0x000fe200078e0260ULL,
0x0000000020437faeULL, 0x0003e2000b901c46ULL, 0x0000001031227825ULL, 0x000fca00078e0022ULL,
0x0000000022497faeULL, 0x0003e4000b901c46ULL, 0x00000300ff047624ULL, 0x002fe200078e00ffULL,
0x0000000347057812ULL, 0x000fe200078ec0ffULL, 0xffffffffff497424ULL, 0x000fc600078e00ffULL,
0x000000030500780cULL, 0x000fe40003f05270ULL, 0xfffffffd04047811ULL, 0x000fc800078e10ffULL,
0x0000000104047807ULL, 0x000fca0004000000ULL, 0x0000000147477824ULL, 0x000fca00078e0204ULL,
0x000000454700720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000147047824ULL, 0x000fe400078e024dULL, 0x00000004ff057424ULL, 0x000fc800078e00ffULL,
0x0000600004047625ULL, 0x000fca00078e0005ULL, 0x0000000604497981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01466800480c7f8cULL, 0x0004e4000c80043fULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x01466c0048077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x00afe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000f06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01466c0048077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x014180004e077984ULL, 0x000e680000000800ULL, 0x014380004e0c7984ULL, 0x0006a20000000800ULL,
0x0000006a0700720bULL, 0x002fe20003f1d000ULL, 0x0000f6027f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0dff7812ULL, 0x000fe2000782c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x000000030000780cULL, 0x000fe40003f05270ULL,
0x0000006a0700720bULL, 0x000fe20003f34000ULL, 0x0000f5d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x000fc400008e0100ULL, 0x0000006a07058209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100e047816ULL, 0x000fc600000000ffULL,
0x014580054e008388ULL, 0x0003e20000000800ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000006a07057209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0eff7812ULL, 0x000fc6000780c0ffULL,
0x0000006a05047221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL,
0x0000000400417308ULL, 0x000e640000000800ULL, 0x000000414b4b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff067819ULL, 0x000fe20000011602ULL,
0x0000f5027f007947ULL, 0x000fea000b800000ULL, 0x00001f0641067589ULL, 0x0002e400000e0000ULL,
0x0000000614147220ULL, 0x08cfe20000410000ULL, 0x0000000615157220ULL, 0x080fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000619197220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000628287220ULL, 0x080fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000608087220ULL, 0x080fe20000410000ULL, 0x0000000609097220ULL, 0x080fe20000410000ULL,
0x000000062c2c7220ULL, 0x080fe20000410000ULL, 0x000000062d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000eff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802067811ULL, 0x000fe200078ff0ffULL,
0x0000f3d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0641067589ULL, 0x00066400000e0000ULL,
0x0000000616167220ULL, 0x086fe20000410000ULL, 0x0000000617177220ULL, 0x080fe20000410000ULL,
0x000000061a1a7220ULL, 0x080fe20000410000ULL, 0x000000061b1b7220ULL, 0x080fe20000410000ULL,
0x000000061e1e7220ULL, 0x080fe20000410000ULL, 0x000000061f1f7220ULL, 0x080fe20000410000ULL,
0x0000000626267220ULL, 0x080fe20000410000ULL, 0x0000000627277220ULL, 0x080fe20000410000ULL,
0x000000062a2a7220ULL, 0x080fe20000410000ULL, 0x000000062b2b7220ULL, 0x080fe20000410000ULL,
0x0000000636367220ULL, 0x080fe20000410000ULL, 0x0000000637377220ULL, 0x080fe20000410000ULL,
0x000000060a0a7220ULL, 0x080fe20000410000ULL, 0x000000060b0b7220ULL, 0x080fe20000410000ULL,
0x000000062e2e7220ULL, 0x080fe20000410000ULL, 0x000000062f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff0eff7812ULL, 0x000fe4000780080dULL,
0x0000006a076a7209ULL, 0x000fd60007810000ULL, 0x8000006a07070221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b07070820ULL, 0x000fc80000410000ULL, 0x0000000700500308ULL, 0x000e640000000800ULL,
0x000000500c0c0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000004b0c4b7221ULL, 0x004fe20000010000ULL, 0x0000010000008947ULL, 0x000fea0003800000ULL,
0x00000050ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0c7819ULL, 0x000fe40000011602ULL,
0x0000541004417816ULL, 0x008fe20000000004ULL, 0x0000f1f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c41517589ULL, 0x0002a400000e0000ULL, 0x000000080c067810ULL, 0x000fe20007ffe0ffULL,
0x0000f2127f007947ULL, 0x000fea000b800000ULL, 0x00001f0641527589ULL, 0x00066400000e0000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000100c067810ULL, 0x008fe40007ffe0ffULL,
0x0000b34000047802ULL, 0x000fc40000000f00ULL, 0x0000f74000007944ULL, 0x016fea0003c00000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0x000000180c067810ULL, 0x00cfe40007ffe0ffULL,
0x0000b38000047802ULL, 0x000fc40000000f00ULL, 0x0000f70000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b800540c7811ULL, 0x002fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005610783bULL, 0x000fe20000004200ULL,
0x0000b8005a047811ULL, 0x000fc600078e20ffULL, 0x000000000c0c783bULL, 0x000e680000000200ULL,
0x000000005720783bULL, 0x000fe80000004200ULL, 0x00000000593c783bULL, 0x000fe80000004200ULL,
0x000000005838783bULL, 0x000fe80000004200ULL, 0x000000000404783bULL, 0x00cea80000000200ULL,
0x000000005b40783bULL, 0x000ee80000004200ULL, 0x000000005c6c783bULL, 0x000ee80000004200ULL,
0x000000005e30783bULL, 0x000ee80000004200ULL, 0x000000005d70783bULL, 0x000ee20000004200ULL,
0x000000510c0c0232ULL, 0x002fc40000000000ULL, 0x000000510e0e0232ULL, 0x000fe40000000000ULL,
0x000000520d0d0232ULL, 0x080fe40000000000ULL, 0x000000520f0f0232ULL, 0x000fce0000000000ULL,
0x000000100c14723cULL, 0x000f620000001814ULL, 0x0000005104040232ULL, 0x084fe40000000000ULL,
0x0000005106060232ULL, 0x000fe40000000000ULL, 0x0000005205050232ULL, 0x000fc60000000000ULL,
0x000000200c1c723cULL, 0x000fe2000000181cULL, 0x0000005207070232ULL, 0x000fce0000000000ULL,
0x000000120c10723cULL, 0x040f700000001818ULL, 0x000000220c20723cULL, 0x040f700000001824ULL,
0x0000003c0c24723cULL, 0x040f700000001808ULL, 0x000000380c18723cULL, 0x040f700000001828ULL,
0x0000003a0c34723cULL, 0x040f700000001834ULL, 0x0000003e0c2c723cULL, 0x000f70000000182cULL,
0x000000400408723cULL, 0x068f700000001814ULL, 0x00000042040c723cULL, 0x040f700000001810ULL,
0x0000006e0414723cULL, 0x040f700000001820ULL, 0x0000006c0410723cULL, 0x040f70000000181cULL,
0x000000300420723cULL, 0x040f700000001824ULL, 0x000000700418723cULL, 0x040f700000001818ULL,
0x00000072041c723cULL, 0x040f700000001834ULL, 0x000000320424723cULL, 0x000b6e000000182cULL,
0x0000030003047a10ULL, 0x020fe20007ffe0ffULL, 0x0000580049067a24ULL, 0x010fc600078e02ffULL,
0x0000000104057810ULL, 0x000fe20007ffe0ffULL, 0x0000004006337824ULL, 0x000fc600078e00ffULL,
0x000000460500720cULL, 0x000fe20003f26070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000071000009947ULL, 0x000fea0003800000ULL, 0x00000003ff357819ULL, 0x100fe20000011602ULL,
0x0000010004057824ULL, 0x000fe400078e00ffULL, 0x0000000148537824ULL, 0x000fe200078e0253ULL,
0x0000000435397810ULL, 0x040fe20007ffe0ffULL, 0x00000001352e7824ULL, 0x140fe200078e0202ULL,
0x0000000544047217ULL, 0x000fe40007800000ULL, 0x00000008353b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000139067824ULL, 0x100fe200078e0202ULL, 0x0000000c353d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000839077824ULL, 0x000fe200078e00ffULL, 0x00000010353f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001042a7824ULL, 0x000fe200078e0a05ULL, 0x0000001435417810ULL, 0x000fe20007ffe0ffULL,
0x000000013b047824ULL, 0x000fe200078e0202ULL, 0xfffffff807327812ULL, 0x000fe200078ee206ULL,
0x000000083b077824ULL, 0x000fe200078e00ffULL, 0x0000001835437810ULL, 0x000fe20007ffe0ffULL,
0x000000013d057824ULL, 0x040fe200078e0202ULL, 0x000000072e377812ULL, 0x000fe200078ec0ffULL,
0x000000083d3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff807387812ULL, 0x000fe200078ee204ULL,
0x000000014a047824ULL, 0x000fe200078e0235ULL, 0x0000001c354f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013f067824ULL, 0x140fe200078e0202ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL,
0x000000083f297824ULL, 0x000fe200078e00ffULL, 0x0000003304057210ULL, 0x080fe20007f3e0ffULL,
0x000000014a047824ULL, 0x000fe200078e0239ULL, 0x0ffffff8372e7812ULL, 0x000fe200078ef802ULL,
0x00000008413e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8293c7812ULL, 0x000fe200078ee206ULL,
0x000000ffff2c7224ULL, 0x000fe200008e06ffULL, 0x0000003304077210ULL, 0x000fe20007f5e0ffULL,
0x0000000141297824ULL, 0x100fe200078e0202ULL, 0x00005e0005047a11ULL, 0x000fe200078248ffULL,
0x00000001432b7824ULL, 0x000fc400078e0202ULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e0007067a11ULL, 0x000fe200078448ffULL, 0x0000000843407824ULL, 0x000fe200078e00ffULL,
0x00005f0005057a11ULL, 0x000fe200008f4c2cULL, 0x000000014a2c7824ULL, 0x040fe200078e023dULL,
0x00005f0007077a11ULL, 0x000fe200010f4c28ULL, 0x000000014a287824ULL, 0x000fe200078e023bULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee229ULL, 0x000000014a347824ULL, 0x000fe200078e0241ULL,
0xfffffff840407812ULL, 0x000fe200078ee22bULL, 0x000000014a307824ULL, 0x000fe200078e023fULL,
0x0000003328297210ULL, 0x080fe20007f7e0ffULL, 0x000000014a367824ULL, 0x000fe200078e0243ULL,
0x000000332c2b7210ULL, 0x080fe20007f3e0ffULL, 0x000000014a427824ULL, 0x000fe200078e024fULL,
0x00005e0029287a11ULL, 0x000fe200078c48ffULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00000033342f7210ULL, 0x080fe20007f7e0ffULL, 0x000000084f577824ULL, 0x000fe200078e00ffULL,
0x000000202a347817ULL, 0x000fe20003800000ULL, 0x0000001032377824ULL, 0x000fe200078e0255ULL,
0x00005f0029297a11ULL, 0x000fe200030f4c2cULL, 0x000000ffff2c7224ULL, 0x000fe200008e06ffULL,
0x00000033302d7210ULL, 0x000fe20007f5e0ffULL, 0x000000014f307824ULL, 0x000fe200078e0202ULL,
0x00005e002b2a7a11ULL, 0x000fe200078c48ffULL, 0x0000001053047825ULL, 0x000fe200078e0004ULL,
0x000000343500720cULL, 0x000fc40003f26070ULL, 0x00005f002b2b7a11ULL, 0x000fe200030f4c2cULL,
0x000000102e357824ULL, 0x000fe200078e0255ULL, 0x00005e002d2c7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x0000003336317210ULL, 0x080fe20007fbe0ffULL,
0x0000001053067825ULL, 0x000fe200078e0006ULL, 0x0000003342337210ULL, 0x000fe40007f9e0ffULL,
0xfffffff857427812ULL, 0x000fe200078ee230ULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005f002d2d7a11ULL, 0x000fe200030f4c2eULL, 0x000000ffff327224ULL, 0x000fe200028e06ffULL,
0x000000343900720cULL, 0x080fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004357faeULL, 0x0003e2000c901c46ULL, 0x00005e002f2e7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff367224ULL, 0x000fe200020e06ffULL, 0x000000343b00720cULL, 0x000fe20003f26070ULL,
0x000000103a397824ULL, 0x100fe200078e0255ULL, 0x00005f002f2f7a11ULL, 0x000fe200030f4c30ULL,
0x000000103c3b7824ULL, 0x000fe200078e0255ULL, 0x00005e0031307a11ULL, 0x000fc400078c48ffULL,
0x000000343d00720cULL, 0x080fe20003f66070ULL, 0x000000103e3d7824ULL, 0x100fe200078e0255ULL,
0x00005f0031317a11ULL, 0x000fe200030f4c32ULL, 0x0000000006377faeULL, 0x0005e2000d101c46ULL,
0x00005e0033327a11ULL, 0x000fe200078848ffULL, 0x0000001038357824ULL, 0x002fe200078e0255ULL,
0x000000343f00720cULL, 0x080fe20003fa6070ULL, 0x0000001053047825ULL, 0x000fe200078e0028ULL,
0x000000344100720cULL, 0x080fe40003fc6070ULL, 0x000000344300720cULL, 0x080fe20003f46070ULL,
0x0000001053287825ULL, 0x000fe200078e002cULL, 0x00005f0033337a11ULL, 0x000fe200020f4c36ULL,
0x0000000004357faeULL, 0x0003e2000c901c46ULL, 0x000000344f00720cULL, 0x000fe20003f86070ULL,
0x0000001053067825ULL, 0x004fc800078e002aULL, 0x00000010532a7825ULL, 0x040fe200078e002eULL,
0x0000000006397faeULL, 0x0003e6000d901c46ULL, 0x00000010403f7824ULL, 0x000fe200078e0255ULL,
0x00000000283b7faeULL, 0x0003e2000e901c46ULL, 0x00000010532c7825ULL, 0x000fc600078e0030ULL,
0x000000002a3d7faeULL, 0x0003e2000f101c46ULL, 0x0000001042557824ULL, 0x000fe400078e0255ULL,
0x00000010532e7825ULL, 0x000fe200078e0032ULL, 0x000000002c3f7faeULL, 0x0003e8000d101c46ULL,
0x000000002e557faeULL, 0x0003e2000e101c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x0000000402057811ULL, 0x000fe200078fe8ffULL, 0x0000000148537824ULL, 0x000fe200078e0253ULL,
0x00000010022f7811ULL, 0x000fc400078fe8ffULL, 0x0000000c022d7811ULL, 0x040fe200078fe8ffULL,
0x0000000105047824ULL, 0x140fe200078e0202ULL, 0x00000008022b7811ULL, 0x040fe200078fe8ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000001402317811ULL, 0x040fe200078fe8ffULL,
0x000000082f367824ULL, 0x000fe200078e00ffULL, 0x0000001c02377811ULL, 0x000fe200078fe8ffULL,
0x000000012d067824ULL, 0x000fe200078e0202ULL, 0xfffffff8072e7812ULL, 0x000fe200078ee204ULL,
0x000000012f077824ULL, 0x000fe400078e0202ULL, 0x000000082d357824ULL, 0x000fc400078e00ffULL,
0x000000012b047824ULL, 0x040fe200078e0202ULL, 0xfffffff836367812ULL, 0x000fe200078ee207ULL,
0x000000082b297824ULL, 0x000fe200078e00ffULL, 0xfffffff835327812ULL, 0x000fe200078ee206ULL,
0x0000000131077824ULL, 0x040fe200078e0202ULL, 0x0000001802357811ULL, 0x000fe200078fe8ffULL,
0x00000008313a7824ULL, 0x000fe200078e00ffULL, 0xfffffff829307812ULL, 0x000fe200078ee204ULL,
0x000000014a067824ULL, 0x000fe200078e0205ULL, 0x0000004a02047211ULL, 0x000fe200078fe8ffULL,
0x0000000135297824ULL, 0x140fe200078e0202ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee207ULL,
0x00000008353e7824ULL, 0x000fe200078e00ffULL, 0x0000003306077210ULL, 0x080fe20007f5e0ffULL,
0x000000014a347824ULL, 0x000fe200078e022fULL, 0x0000003304057210ULL, 0x080fe20007f3e0ffULL,
0x000000014a3c7824ULL, 0x000fe200078e0235ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee229ULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x00005e0007067a11ULL, 0x000fe200078448ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x0000000202297211ULL, 0x000fe200078fe8ffULL,
0x0000000137357824ULL, 0x000fe200078e0202ULL, 0x00005e0005047a11ULL, 0x000fe200078248ffULL,
0x0000000837427824ULL, 0x000fe200078e00ffULL, 0x00005f0007077a11ULL, 0x000fe200010f4c28ULL,
0x000000014a287824ULL, 0x040fe200078e022bULL, 0x0000000729297812ULL, 0x000fe200078ec0ffULL,
0x000000014a387824ULL, 0x040fe200078e0231ULL, 0x00005f0005057a11ULL, 0x000fe200008f4c2aULL,
0x000000014a2a7824ULL, 0x040fe200078e022dULL, 0x0ffffff8292c7812ULL, 0x000fe200078ef802ULL,
0x000000014a407824ULL, 0x000fe200078e0237ULL, 0x0000003328297210ULL, 0x080fe20007f9e0ffULL,
0x000000103a3f7824ULL, 0x100fe200078e0255ULL, 0x000000332a2b7210ULL, 0x080fe20007f5e0ffULL,
0x000000102e377824ULL, 0x100fe200078e0255ULL, 0x00005e0029287a11ULL, 0x040fe200078c48ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x00000033342d7210ULL, 0x080fe20007f7e0ffULL,
0x0000001030397824ULL, 0x000fe200078e0255ULL, 0xfffffff842347812ULL, 0x000fe200078ee235ULL,
0x000000102c357824ULL, 0x100fe200078e0255ULL, 0x00005f0029297a11ULL, 0x000fe200030f4c2aULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00000033382f7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e002b2a7a11ULL, 0x040fe200078448ffULL,
0x00000010323b7824ULL, 0x100fe200078e0255ULL, 0x000000333c317210ULL, 0x080fe20007f9e0ffULL,
0x00000010363d7824ULL, 0x100fe200078e0255ULL, 0x0000003340337210ULL, 0x000fe20007fbe0ffULL,
0x000000103e417824ULL, 0x100fe200078e0255ULL, 0x00005f002b2b7a11ULL, 0x000fe200010f4c2cULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078448ffULL,
0x0000001034557824ULL, 0x000fe200078e0255ULL, 0x00005e002f2e7a11ULL, 0x000fe200078248ffULL,
0x000000ffff367224ULL, 0x000fe200020e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078648ffULL,
0x000000ffff347224ULL, 0x000fe200028e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078848ffULL,
0x0000001053047825ULL, 0x000fe200078e0004ULL, 0x00005f002d2d7a11ULL, 0x000fc400010f4c3aULL,
0x00005f002f2f7a11ULL, 0x000fe200008f4c38ULL, 0x0000001053067825ULL, 0x000fe200078e0006ULL,
0x00005f0031317a11ULL, 0x000fe200018f4c36ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004357faeULL, 0x0003e2000b901c46ULL, 0x00005f0033337a11ULL, 0x000fe200020f4c34ULL,
0x0000001053287825ULL, 0x040fe400078e0028ULL, 0x0000000006377faeULL, 0x0003e4000b901c46ULL,
0x00000010532a7825ULL, 0x040fe400078e002aULL, 0x0000000028397faeULL, 0x0003e4000b901c46ULL,
0x00000010532c7825ULL, 0x000fc400078e002cULL, 0x000000002a3b7faeULL, 0x0003e4000b901c46ULL,
0x00000010532e7825ULL, 0x040fe400078e002eULL, 0x000000002c3d7faeULL, 0x0003e4000b901c46ULL,
0x0000001053307825ULL, 0x040fe400078e0030ULL, 0x000000002e3f7faeULL, 0x0003e4000b901c46ULL,
0x0000001053327825ULL, 0x000fc400078e0032ULL, 0x0000000030417faeULL, 0x0003e8000b901c46ULL,
0x0000000032557faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000008947ULL, 0x000fea0003800000ULL, 0x00000050ff04723eULL, 0x002fe400000000ffULL,
0x00000002ff287819ULL, 0x000fe40000011602ULL, 0x0000541004417816ULL, 0x000fe20000000004ULL,
0x0000e1327f007947ULL, 0x000fea000b800000ULL, 0x00001f2841517589ULL, 0x0002a400000e0000ULL,
0x0000000828067810ULL, 0x000fe20007ffe0ffULL, 0x0000e1527f007947ULL, 0x000fea000b800000ULL,
0x00001f0641527589ULL, 0x00066400000e0000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x0000001028067810ULL, 0x008fe40007ffe0ffULL, 0x0000c49000047802ULL, 0x000fc40000000f00ULL,
0x0000e5f000007944ULL, 0x006fea0003c00000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0x0000001828067810ULL, 0x00cfe40007ffe0ffULL, 0x0000c4d000047802ULL, 0x000fc40000000f00ULL,
0x0000e5b000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000b8005f5f7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006404783bULL, 0x00efe20000004200ULL, 0x0000b80065657811ULL, 0x000fc600078e20ffULL,
0x000000005f5c783bULL, 0x000e680000000200ULL, 0x000000006128783bULL, 0x000fe80000004200ULL,
0x00000000622c783bULL, 0x000fe80000004200ULL, 0x000000006330783bULL, 0x000fe80000004200ULL,
0x000000006538783bULL, 0x000ea80000000200ULL, 0x000000006934783bULL, 0x000ee80000004200ULL,
0x00000000663c783bULL, 0x000f280000004200ULL, 0x000000006740783bULL, 0x000ee80000004200ULL,
0x000000006854783bULL, 0x000ee20000004200ULL, 0x000000515c5c0232ULL, 0x002fc40000000000ULL,
0x000000515e5e0232ULL, 0x000fe40000000000ULL, 0x000000525d5d0232ULL, 0x080fe40000000000ULL,
0x000000525f5f0232ULL, 0x000fce0000000000ULL, 0x000000045c08723cULL, 0x000f620000001808ULL,
0x0000005138380232ULL, 0x084fe40000000000ULL, 0x000000513a3a0232ULL, 0x000fe40000000000ULL,
0x0000005239390232ULL, 0x000fc60000000000ULL, 0x000000065c0c723cULL, 0x000f62000000180cULL,
0x000000523b3b0232ULL, 0x000fce0000000000ULL, 0x000000285c10723cULL, 0x040ff00000001810ULL,
0x0000002c5c04723cULL, 0x040ff00000001818ULL, 0x0000002a5c28723cULL, 0x040f700000001814ULL,
0x0000002e5c2c723cULL, 0x040f70000000181cULL, 0x000000305c20723cULL, 0x040f700000001820ULL,
0x000000325c30723cULL, 0x000f700000001824ULL, 0x000000343814723cULL, 0x068b700000001808ULL,
0x000000363818723cULL, 0x040b70000000180cULL, 0x0000003e3824723cULL, 0x050b700000001828ULL,
0x000000423834723cULL, 0x040b70000000182cULL, 0x0000003c381c723cULL, 0x040b700000001810ULL,
0x000000403828723cULL, 0x040b700000001804ULL, 0x000000543808723cULL, 0x040b700000001820ULL,
0x00000056382c723cULL, 0x000b620000001830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0146a000ffff7f8cULL, 0x000fe4000c80043fULL,
0x0000030003037a10ULL, 0x000fc80007ffe0ffULL, 0x000000460300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff4e7000007947ULL, 0x000fea000383ffffULL,
0x0000000000217919ULL, 0x020e620000002500ULL, 0x000000ffff127224ULL, 0x000fe400078e000bULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0b7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0008ULL, 0x000000462100720cULL, 0x002fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x018000004b027810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e004bULL, 0x0000c8d000067802ULL, 0x000fc40000000f00ULL,
0x0000dfe000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000004b00027308ULL, 0x000e640000001000ULL,
0xbf80000002037423ULL, 0x002fc8000000004bULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000302027223ULL, 0x000fc40000000002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000047919ULL, 0x000ee20000000000ULL,
0x00000002ff037819ULL, 0x004fe40000011603ULL, 0x0000000804057811ULL, 0x008fc800078ff0ffULL,
0x00001f0302037589ULL, 0x000ea800000e0000ULL, 0x00001f0502047589ULL, 0x000ee200000e0000ULL,
0x0000001403147220ULL, 0x044fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000001803187220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000002503257220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000002903297220ULL, 0x040fe20000410000ULL,
0x0000003403347220ULL, 0x040fe20000410000ULL, 0x0000003503357220ULL, 0x040fe20000410000ULL,
0x0000000a030a7220ULL, 0x040fe20000410000ULL, 0x0000000b030b7220ULL, 0x040fe20000410000ULL,
0x0000002c032c7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x000fe20000410000ULL,
0x0000001604167220ULL, 0x048fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x000fc20000410000ULL,
0x0000000000227919ULL, 0x000ea20000000000ULL, 0x000000181905723eULL, 0x000fc400000000ffULL,
0x000000141504723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000016170c723eULL, 0x000fe400000000ffULL, 0x0000001a1b0d723eULL, 0x000fe400000000ffULL,
0x0000001c1d06723eULL, 0x000fc400000000ffULL, 0x0000001e1f0e723eULL, 0x000fe200000000ffULL,
0x00000300ff1f7624ULL, 0x000fe200078e00ffULL, 0x000000242507723eULL, 0x000fe400000000ffULL,
0x00000026270f723eULL, 0x000fe400000000ffULL, 0x000000282908723eULL, 0x000fe400000000ffULL,
0x00000002ff197819ULL, 0x004fe40000011622ULL, 0x0000000822247811ULL, 0x000fc400078ff0ffULL,
0x0000000119027810ULL, 0x040fe20007ffe0ffULL, 0x0000000819157824ULL, 0x040fe200078e00ffULL,
0x0000000219037810ULL, 0x040fe20007ffe0ffULL, 0x0000000819187824ULL, 0x040fe200078e00ffULL,
0x0000000519147810ULL, 0x040fe20007ffe0ffULL, 0x0000000819177824ULL, 0x000fe200078e00ffULL,
0xfffffff815167812ULL, 0x000fe200078ee202ULL, 0x00000008191b7824ULL, 0x040fe200078e00ffULL,
0x0000000319027810ULL, 0x040fe20007ffe0ffULL, 0x0000000819207824ULL, 0x040fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee203ULL, 0x00000008191c7824ULL, 0x040fe200078e00ffULL,
0x0000000619157810ULL, 0x040fe20007ffe0ffULL, 0x0000000819267824ULL, 0x000fe200078e00ffULL,
0xfffffff8171a7812ULL, 0x000fe200078ee202ULL, 0x0000080000027824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1e7812ULL, 0x000fe200078ee214ULL, 0x0000000819147824ULL, 0x040fe200078e00ffULL,
0x0000000419037810ULL, 0x000fc40007ffe0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee215ULL,
0x0000000422157824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe400078ee203ULL,
0xfffffff814147812ULL, 0x000fe400078ee219ULL, 0x0000a00002037810ULL, 0x000fe40007ffe0ffULL,
0xffffffff19177810ULL, 0x000fe20007ffe0ffULL, 0x0000000824197824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x0000001014147824ULL, 0x000fe200078e0203ULL,
0xfffffff826227812ULL, 0x000fe200078ee217ULL, 0x0000001016167824ULL, 0x100fe200078e0203ULL,
0xfffffff819247812ULL, 0x000fe200078ee224ULL, 0x0000001018187824ULL, 0x100fe200078e0203ULL,
0x000000343509723eULL, 0x000fe200000000ffULL, 0x000000101a1a7824ULL, 0x100fe200078e0203ULL,
0x0000000a0b0a723eULL, 0x000fe200000000ffULL, 0x000000101c1c7824ULL, 0x000fe200078e0203ULL,
0x0000002c2d0b723eULL, 0x000fe200000000ffULL, 0x0000000114177824ULL, 0x000fe200078e0215ULL,
0x000000011f00780cULL, 0x000fe20003f05270ULL, 0x000000101e1e7824ULL, 0x100fe200078e0203ULL,
0x0000002a2b10723eULL, 0x000fe200000000ffULL, 0x0000000115167824ULL, 0x000fe200078e0216ULL,
0x0000000417007388ULL, 0x0005e20000000800ULL, 0x0000001020207824ULL, 0x100fe200078e0203ULL,
0x000000363711723eULL, 0x000fe200000000ffULL, 0x0000000115197824ULL, 0x040fe200078e0218ULL,
0x0000000516007388ULL, 0x0005e20000000800ULL, 0x0000001022227824ULL, 0x100fe200078e0203ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x00000001151a7824ULL, 0x000fe200078e021aULL,
0x0000000619007388ULL, 0x0005e20000000800ULL, 0x0000001024247824ULL, 0x000fe200078e0203ULL,
0x0000002e2f13723eULL, 0x000fe200000000ffULL, 0x00000001151b7824ULL, 0x040fe200078e021cULL,
0x000000071a007388ULL, 0x0005e20000000800ULL, 0x00000001151e7824ULL, 0x000fc400078e021eULL,
0x00000001151d7824ULL, 0x040fe200078e0220ULL, 0x000000081b007388ULL, 0x0005e20000000800ULL,
0x0000000115227824ULL, 0x040fe400078e0222ULL, 0x0000000115157824ULL, 0x000fe200078e0224ULL,
0x000000091e007388ULL, 0x0005e80000000800ULL, 0x0000000a1d007388ULL, 0x0005e80000000800ULL,
0x0000000b22007388ULL, 0x0005e80000000800ULL, 0x0000000c15007388ULL, 0x0005e80000000800ULL,
0x0004000d16007388ULL, 0x0005e80000000800ULL, 0x0004000e19007388ULL, 0x0005e80000000800ULL,
0x0004000f1a007388ULL, 0x0005e80000000800ULL, 0x000400101b007388ULL, 0x0005e80000000800ULL,
0x000400111e007388ULL, 0x0005e80000000800ULL, 0x000400121d007388ULL, 0x0005e80000000800ULL,
0x0004001322007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000272000008947ULL, 0x000fea0003800000ULL, 0x00005800ff047624ULL, 0x004fe200078e00ffULL,
0x0000000000067919ULL, 0x000ea60000002700ULL, 0x0000660004047a24ULL, 0x000fe200078e02ffULL,
0x00000000000b7919ULL, 0x000ea60000002600ULL, 0x0000030004097a24ULL, 0x040fe200078e02ffULL,
0x0000000f04057811ULL, 0x000fe200078e10ffULL, 0x0000000000077919ULL, 0x000ee60000000000ULL,
0xfffffff0050e7812ULL, 0x000fca00078ec0ffULL, 0x0000008009107824ULL, 0x000fc800078e020eULL,
0x0000008009097824ULL, 0x000fca00078e0210ULL, 0x0000007f09097810ULL, 0x000fe20007ffe0ffULL,
0x0000580006067a24ULL, 0x004fc600078e020bULL, 0xffffff80090f7812ULL, 0x000fe200078ec0ffULL,
0x0000030006117a24ULL, 0x000fe200078e02ffULL, 0x0000002007097810ULL, 0x048fe20007ffe0ffULL,
0x0000001007087824ULL, 0x000fe200078e0202ULL, 0x00006a000f057a10ULL, 0x000fe20007f1e0ffULL,
0x00000001110a7824ULL, 0x000fc600078e0221ULL, 0x00a0000008147984ULL, 0x000ea40000000c00ULL,
0x000000050a047211ULL, 0x000fe200078260ffULL, 0x00006b00ff057624ULL, 0x000fe200000e06ffULL,
0x00006a000e127a10ULL, 0x000fe20007f1e0ffULL, 0x00a2000008187984ULL, 0x0006660000000c00ULL,
0x000000050a057211ULL, 0x000fe200008f64ffULL, 0x00006b00ff1c7624ULL, 0x000fe200000e06ffULL,
0x000000ff0000720cULL, 0x000fc60003f25270ULL, 0x0000040000047825ULL, 0x000fcc00078e0004ULL,
0x0000001009087825ULL, 0x008fc800078e0004ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000011000001947ULL, 0x000fea0003800000ULL, 0x00000000000c7919ULL, 0x000ee20000000000ULL,
0x000000800a0b7824ULL, 0x000fe400078e00ffULL, 0x000000100c0d7824ULL, 0x008fe200078e00ffULL,
0x00000001ff1d7819ULL, 0x000fe4000001160cULL, 0x00006a000b0c7a10ULL, 0x000fe40007b5e010ULL,
0x000000700d137812ULL, 0x000fe400078ec0ffULL, 0x00000019ff0d7819ULL, 0x000fc4000001160aULL,
0x0000000c1d0a7812ULL, 0x000fe400078ec0ffULL, 0x00000012130b7210ULL, 0x000fe4000791e00bULL,
0x00006b000d1d7a10ULL, 0x000fe400017e64ffULL, 0x0000000c0a0c7210ULL, 0x040fe40007c7e013ULL,
0x0000000b0a0a7210ULL, 0x000fe40007f5e0ffULL, 0x0000001cff0b7210ULL, 0x000fc400007e240dULL,
0x0000001dff0d7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff0b7224ULL, 0x000fca00010e060bULL,
0x0000006a0a007986ULL, 0x0007e8000c101906ULL, 0x0000004b0c007986ULL, 0x0007e4000c101906ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000001404007986ULL, 0x004fe2000c101d06ULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0x000000ff0000720cULL, 0x000fe20000705670ULL,
0x0000001808007986ULL, 0x002fe8000c101d06ULL, 0x0000000000007b1dULL, 0x000ff00000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0xffffffff1f097810ULL, 0x000fc60007ffe0ffULL, 0x00006a0006047625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000009040479a8ULL, 0x000ea400099ee1c6ULL,
0x000000090400720cULL, 0x004fc80003f05270ULL, 0x00000001ff067807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000006ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff047984ULL, 0x000ea40000000000ULL, 0x000000ff0400720cULL, 0x004fda0003f05270ULL,
0x0000226000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001007057824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x002fe40000011607ULL, 0x0000001211047211ULL, 0x000fe400078038ffULL,
0x0000007005097812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fe400078ec0ffULL,
0x0000001c11057211ULL, 0x000fe400000f3cffULL, 0x0000000406047210ULL, 0x000fc8000791e009ULL,
0x00000005ff057210ULL, 0x000fca00007e24ffULL, 0x0000000604067981ULL, 0x000328000c1e1900ULL,
0x0000800604097981ULL, 0x000322000c1e1900ULL, 0x000000021f00780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010006040b7981ULL, 0x00a322000c1e1900ULL,
0x000000041f00780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x00018006040d7981ULL, 0x002322000c1e1900ULL, 0x000000041f00780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000604137981ULL, 0x002322000c1e1900ULL,
0x000000061f00780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800604157981ULL, 0x002322000c1e1900ULL, 0x000000061f00780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000081f00780cULL, 0x002fe20003f06070ULL,
0x0003000604177981ULL, 0x000318000c1e1900ULL, 0x0003800604190981ULL, 0x000324000c1e1900ULL,
0x000000071f047810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff087819ULL, 0x000fc80000011604ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x0000000e111d7211ULL, 0x000fe200078038ffULL, 0x000000ffff0c7224ULL, 0x008fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1b7224ULL, 0x010fe200078e0006ULL,
0x00006a001d1d7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff110a7211ULL, 0x000fe400000f3cffULL,
0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL, 0x00006b00ff0a7a10ULL, 0x000fc400017e240aULL,
0x000003000c007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000408007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080c047810ULL, 0x040fe40007ffe0ffULL, 0x000000010c057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001b06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060aULL,
0xfffc8006041b7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090c047810ULL, 0x042fe40007ffe0ffULL, 0x000000020c057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000906067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060aULL,
0xfffd000604097981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0c047810ULL, 0x042fe40007ffe0ffULL, 0x000000030c057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000b06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060aULL,
0xfffd8006040b7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0c047810ULL, 0x042fe40007ffe0ffULL, 0x000000040c057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060aULL,
0xfffe0006040d7981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0c047810ULL, 0x042fe40007ffe0ffULL, 0x000000050c057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001306067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060aULL,
0xfffe800604137981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0c047810ULL, 0x042fe40007ffe0ffULL, 0x000000060c057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060aULL,
0xffff000604157981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0c047810ULL, 0x042fe40007ffe0ffULL, 0x000000070c057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001706067209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060aULL,
0xffff800604177981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0c047810ULL, 0x002fe40007ffe0ffULL, 0x0000001906067209ULL, 0x000fe40007810000ULL,
0x0000030004007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000041d047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060aULL,
0x0000000604197981ULL, 0x000326000c1e1900ULL, 0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL,
0x000000080c0c7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e060aULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x000ea40000000000ULL,
0x0000001007047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fca00078ec0ffULL,
0x0000000104057824ULL, 0x000fca00078e0205ULL, 0x0000000605007388ULL, 0x0103e40000000800ULL,
0x00006a000f047a10ULL, 0x000fe20007f1e0ffULL, 0x0000040000417824ULL, 0x040fe200078e00ffULL,
0x00000016ff437819ULL, 0x000fe20000011600ULL, 0x0000001007067824ULL, 0x042fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x008fe20000011607ULL, 0x00006b00ff057624ULL, 0x000fe200000e06ffULL,
0x000000070700780cULL, 0x000fe20003f04070ULL, 0x0000100000127824ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000100011087825ULL, 0x000fe200078e0004ULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000004108087210ULL, 0x000fe20007f3e0ffULL, 0x0000000106067824ULL, 0x000fe200078e020bULL,
0x00006a000e447a10ULL, 0x000fe20007f5e0ffULL, 0x0000001000158824ULL, 0x000fe200078e0207ULL,
0x00000020070b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109097824ULL, 0x000fe200008e0643ULL,
0x00006a0010407a10ULL, 0x000fe20007f3e0ffULL, 0x00006b00ff467624ULL, 0x000fe200010e06ffULL,
0x00000044110e8211ULL, 0x000fe200078438ffULL, 0x0000001000178824ULL, 0x000fe200078e0207ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x00006b00ff427624ULL, 0x000fe200008e06ffULL,
0x00000040110c8211ULL, 0x000fe200078238ffULL, 0x000000100b0a7825ULL, 0x000fe200078e0008ULL,
0x00000046110f8211ULL, 0x040fe200010f3cffULL, 0x0000000006067984ULL, 0x000e620000000800ULL,
0x00000042110d8211ULL, 0x000fe200008f3cffULL, 0x0000001007137824ULL, 0x040fe200078e0212ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x0000001007087825ULL, 0x000fe200078e0008ULL,
0x0000418017178811ULL, 0x000fe200078e20ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000010070c8825ULL, 0x040fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008137faeULL, 0x0005e2000b901c46ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000010070e8825ULL, 0x000fe200078e000eULL, 0x003800000a137faeULL, 0x0005e2000b901c46ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000000000c158faeULL, 0x0007e2000b901c46ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000000e178faeULL, 0x0009e2000b901c46ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff137224ULL, 0x004fe200078e00ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x008fe2000001ff00ULL,
0x0000000000167805ULL, 0x010fe2000001ff00ULL, 0x00000be000009947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fc400078e00ffULL,
0x00000001ff457424ULL, 0x000fca00078e00ffULL, 0x0000030045007a0cULL, 0x000fda0003f06070ULL,
0x000001f000000947ULL, 0x000fea0003800000ULL, 0x000000070700780cULL, 0x000fe20003f44070ULL,
0x0000100011087825ULL, 0x000fe200078e0004ULL, 0x00000001450d7812ULL, 0x000fe400078ec0ffULL,
0x0000002007397810ULL, 0x000fe20007ffe0ffULL, 0x00000800450a7824ULL, 0x000fe200078e00ffULL,
0x0000004108087210ULL, 0x000fc80007f1e0ffULL, 0x000008000a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000109097824ULL, 0x000fe400000e0643ULL, 0x000000020034a824ULL, 0x140fe200078e020dULL,
0x00000040110ca211ULL, 0x040fe200078038ffULL, 0x000000020036a824ULL, 0x000fe200078e020dULL,
0x00000044110ea211ULL, 0x040fe200078238ffULL, 0x00000001120a7824ULL, 0x000fe200078e020bULL,
0x00000042110da211ULL, 0x040fe200000f3cffULL, 0x000000083434a824ULL, 0x100fe200078e0207ULL,
0x00000046110fa211ULL, 0x000fe200008f3cffULL, 0x000000083636a824ULL, 0x000fc400078e0207ULL,
0x0000001007337824ULL, 0x000fe200078e020aULL, 0x000045803435a811ULL, 0x000fe200078e20ffULL,
0x00000010390a7825ULL, 0x000fe200078e0008ULL, 0x000041803637a811ULL, 0x000fc600078e20ffULL,
0x0000001007087825ULL, 0x000fc800078e0008ULL, 0x00000010070ca825ULL, 0x040fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008337faeULL, 0x0005e6000b901c46ULL,
0x00000010070ea825ULL, 0x000fe200078e000eULL, 0x003800000a337faeULL, 0x0005e8000b901c46ULL,
0x000000000c35afaeULL, 0x0005e8000b901c46ULL, 0x000000000e37afaeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff45087810ULL, 0x004fe20007ffe0ffULL,
0x00000010070a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc40000011607ULL,
0x00000002ff3e7819ULL, 0x000fe20000011607ULL, 0x0000008008097824ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000080008087824ULL, 0x000fe200078e00ffULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000083e0f7824ULL, 0x040fe200078e00ffULL,
0x0000008009097812ULL, 0x000fe200078ec0ffULL, 0x000000083e0e7824ULL, 0x040fe200078e00ffULL,
0x000000083e4a7810ULL, 0x040fe20007ffe0ffULL, 0x000000083e347824ULL, 0x040fe200078e00ffULL,
0x000000013e0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010000097824ULL, 0x000fe200078e0209ULL,
0x000000043e337810ULL, 0x040fe20007ffe0ffULL, 0x000000083e387824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee20dULL, 0x000000083e3a7824ULL, 0x040fe200078e00ffULL,
0x000000090b0a7210ULL, 0x000fe20007ffe00aULL, 0x0000000407097824ULL, 0x000fe200078e00ffULL,
0x000000023e0d7810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180000a0b7984ULL, 0x000ea20000000800ULL, 0x0000000c093d7812ULL, 0x000fe200078ec0ffULL,
0x000000083e3c7824ULL, 0x000fe200078e00ffULL, 0x0000080008097812ULL, 0x000fe200078ec0ffULL,
0x004580000a0c7984ULL, 0x0007220000000800ULL, 0xfffffff80f087812ULL, 0x000fe200078ee23eULL,
0x000000084a0f7824ULL, 0x000fe200078e00ffULL, 0x0000018012097810ULL, 0x000fe20007ffe009ULL,
0x000000083e4c7824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe400078ee20dULL,
0x000000053e357810ULL, 0x000fe20007ffe0ffULL, 0x0000001008087824ULL, 0x000fe200078e0209ULL,
0xfffffff80f0a7812ULL, 0x008fc400078ee24aULL, 0x000000033e0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013d087824ULL, 0x040fe200078e0208ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee233ULL,
0x000000100a0a7824ULL, 0x000fe200078e0209ULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee235ULL,
0x000000063e337810ULL, 0x000fe20007ffe0ffULL, 0x000000013d0d7824ULL, 0x040fe200078e020aULL,
0x0000000008087984ULL, 0x000ee20000000800ULL, 0x000000100e0a7824ULL, 0x000fe200078e0209ULL,
0xfffffff8380e7812ULL, 0x000fe200078ee20fULL, 0x000000103a0f7824ULL, 0x000fe200078e0209ULL,
0x000000000d367984ULL, 0x0002e20000000800ULL, 0x000000013d0a7824ULL, 0x040fe200078e020aULL,
0xffffffff3e357810ULL, 0x000fe20007ffe0ffULL, 0x000000013d0f7824ULL, 0x000fe200078e020fULL,
0x0000030045007a0cULL, 0x000fc40003f06070ULL, 0xfffffff84c3a7812ULL, 0x000fe200078ee235ULL,
0x000400000a377984ULL, 0x000fe20000000800ULL, 0x000000100e0d7824ULL, 0x102fe200078e0209ULL,
0x0000000111117810ULL, 0x000fe40007ffe0ffULL, 0x000000103a357824ULL, 0x000fe200078e0209ULL,
0x0000000145457810ULL, 0x000fe20007ffe0ffULL, 0x0000000b060b7221ULL, 0x004fe20000010100ULL,
0x000000013d0e7824ULL, 0x040fe200078e020dULL, 0x000400000f3a7984ULL, 0x000fe20000000800ULL,
0x000000013d357824ULL, 0x000fe200078e0235ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc40000410000ULL,
0x000400000e397984ULL, 0x000fe80000000800ULL, 0x0000000b000b7308ULL, 0x000f240000000800ULL,
0x0000000c0b3b7220ULL, 0x010fe20000410000ULL, 0x00000010340c7824ULL, 0x000fe200078e0209ULL,
0x000000000a0b7984ULL, 0x000fe20000000800ULL, 0x000000083e347824ULL, 0x000fe200078e00ffULL,
0x000000323b327221ULL, 0x000fe20000010000ULL, 0x000000013d0c7824ULL, 0x000fe200078e020cULL,
0x00001f3e3b3e7589ULL, 0x000e6400000e0000ULL, 0xfffffff834347812ULL, 0x000fe200078ee233ULL,
0x000000103c337824ULL, 0x000fe200078e0209ULL, 0x000000000c0d7984ULL, 0x000fe20000000800ULL,
0x20000008ff3c7230ULL, 0x008fc40000004100ULL, 0x0000001034347824ULL, 0x000fe200078e0209ULL,
0x00001f4a3b3f7589ULL, 0x0004e200000e0000ULL, 0x000000013d337824ULL, 0x040fe400078e0233ULL,
0x000000013d347824ULL, 0x000fe200078e0234ULL, 0x000000000e0a7984ULL, 0x000f220000000800ULL,
0x30000036ff3d7230ULL, 0x000fc60000004100ULL, 0x000000000f097984ULL, 0x000f220000000800ULL,
0x30000008ff3b7230ULL, 0x004fe40000004100ULL, 0x20000036ff087230ULL, 0x000fe20000004100ULL,
0x000400000c387984ULL, 0x000ea20000000800ULL, 0x0000003e3c317223ULL, 0x002fc60000010031ULL,
0x00000000330c7984ULL, 0x000e620000000800ULL, 0x20000037ff3c7230ULL, 0x100fe20000004100ULL,
0x0000003e3b307223ULL, 0x000fe20000010030ULL, 0x30000037ff377230ULL, 0x000fe20000004100ULL,
0x00040000330e7984ULL, 0x000e620000000800ULL, 0x0000003f082f7223ULL, 0x008fc6000001002fULL,
0x00040000340f7984ULL, 0x000ee20000000800ULL, 0x0000003f3c2b7223ULL, 0x080fe2000001002bULL,
0x0000003f372a7223ULL, 0x080fe2000001002aULL, 0x2000000bff367230ULL, 0x100fe20000004100ULL,
0x0000000034087984ULL, 0x0008e20000000800ULL, 0x3000000bff0b7230ULL, 0x000fe20000004100ULL,
0x0000003f3d2e7223ULL, 0x000fe4000001002eULL, 0x0004000035337984ULL, 0x000ee20000000800ULL,
0x0000003e362d7223ULL, 0x080fe2000001002dULL, 0x0000003e0b2c7223ULL, 0x000fe2000001002cULL,
0x2000000dff367230ULL, 0x100fe20000004100ULL, 0x00000000350b7984ULL, 0x000ee20000000800ULL,
0x3000000dff0d7230ULL, 0x000fc60000004100ULL, 0x0000003e36297223ULL, 0x080fe40000010029ULL,
0x0000003e0d287223ULL, 0x080fe20000010028ULL, 0x2000000aff347230ULL, 0x110fe40000004100ULL,
0x3000000aff0d7230ULL, 0x000fe40000004100ULL, 0x20000009ff0a7230ULL, 0x100fe20000004100ULL,
0x0000003e34257223ULL, 0x080fe20000010025ULL, 0x30000009ff097230ULL, 0x000fe20000004100ULL,
0x0000003e0d247223ULL, 0x080fe20000010024ULL, 0x20000039ff347230ULL, 0x000fe20000004100ULL,
0x0000003e0a217223ULL, 0x080fe20000010021ULL, 0x20000038ff3c7230ULL, 0x004fe20000004100ULL,
0x0000003e09207223ULL, 0x080fe20000010020ULL, 0x3000003aff097230ULL, 0x000fe20000004100ULL,
0x0000003f34237223ULL, 0x080fe20000010023ULL, 0x2000000cff0a7230ULL, 0x102fe20000004100ULL,
0x0000003f3c277223ULL, 0x080fe20000010027ULL, 0x3000000cff0c7230ULL, 0x000fe20000004100ULL,
0x0000003f091e7223ULL, 0x080fe2000001001eULL, 0x2000000eff0d7230ULL, 0x000fe20000004100ULL,
0x0000003e0a177223ULL, 0x080fe20000010017ULL, 0x30000038ff377230ULL, 0x000fe20000004100ULL,
0x0000003e0c1d7223ULL, 0x080fe2000001001dULL, 0x2000000fff097230ULL, 0x008fe20000004100ULL,
0x0000003f0d1c7223ULL, 0x080fe2000001001cULL, 0x30000039ff397230ULL, 0x000fe20000004100ULL,
0x0000003f37267223ULL, 0x080fe20000010026ULL, 0x20000008ff0a7230ULL, 0x000fe20000004100ULL,
0x0000003f091a7223ULL, 0x080fe2000001001aULL, 0x2000003aff347230ULL, 0x000fe20000004100ULL,
0x0000003f39227223ULL, 0x080fe20000010022ULL, 0x20000033ff0d7230ULL, 0x000fe20000004100ULL,
0x0000003e0a137223ULL, 0x080fe20000010013ULL, 0x3000000eff0e7230ULL, 0x000fe20000004100ULL,
0x0000003f341f7223ULL, 0x080fe2000001001fULL, 0x2000000bff097230ULL, 0x000fe20000004100ULL,
0x0000003f0d147223ULL, 0x080fe20000010014ULL, 0x30000008ff087230ULL, 0x000fe20000004100ULL,
0x0000003f0e157223ULL, 0x080fe20000010015ULL, 0x3000000fff0c7230ULL, 0x000fe20000004100ULL,
0x0000003e09187223ULL, 0x080fe20000010018ULL, 0x3000000bff0b7230ULL, 0x000fe20000004100ULL,
0x0000003e081b7223ULL, 0x000fe2000001001bULL, 0x30000033ff337230ULL, 0x000fe20000004100ULL,
0x0000003f0c197223ULL, 0x000fc40000010019ULL, 0x0000003e0b167223ULL, 0x000fe40000010016ULL,
0x0000003f33107223ULL, 0x000fe20000010010ULL, 0xfffff45000008947ULL, 0x000fea000383ffffULL,
0x0180000032007810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000000007812ULL, 0x000fe200078ec0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000f08000067802ULL, 0x002fc40000000f00ULL, 0x0000b83000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003200057308ULL, 0x000ea40000001000ULL, 0xbf80000005007423ULL, 0x004fc80000000032ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff097819ULL, 0x004fc40000011608ULL,
0x00000008080b7811ULL, 0x040fe200078ff0ffULL, 0x0000000408087824ULL, 0x000fe200078e00ffULL,
0x00000003090d7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0900047589ULL, 0x000ea200000e0000ULL,
0x0000000809117824ULL, 0x040fe200078e00ffULL, 0x00000004090f7810ULL, 0x040fe20007ffe0ffULL,
0x00000008090e7824ULL, 0x040fe200078e00ffULL, 0x00001f0b00077589ULL, 0x00072200000e0000ULL,
0x00000002090c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000809127824ULL, 0x040fe400078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee20dULL, 0x0000000809327824ULL, 0x042fe200078e00ffULL,
0x00000005090d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b347824ULL, 0x000fc400078e00ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0203ULL, 0xfffffff812127812ULL, 0x000fe400078ee20dULL,
0xfffffff834347812ULL, 0x000fc600078ee20bULL, 0x0000001012127824ULL, 0x100fe400078e0203ULL,
0x0000001034347824ULL, 0x000fe200078e0203ULL, 0x0000003104317220ULL, 0x044fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001d04007220ULL, 0x048fe20000410000ULL, 0x0000001304137220ULL, 0x040fe20000410000ULL,
0x0000001b04067220ULL, 0x040fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000001604057220ULL, 0x000fe20000410000ULL, 0x0000000109047810ULL, 0x000fe20007ffe0ffULL,
0x0000002f072f7220ULL, 0x050fe20000410000ULL, 0x0000002e072e7220ULL, 0x040fe20000410000ULL,
0x0000002b072b7220ULL, 0x040fe20000410000ULL, 0x0000002a072a7220ULL, 0x040fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001907197220ULL, 0x040fe20000410000ULL,
0x0000001407147220ULL, 0x040fe20000410000ULL, 0x0000001007077220ULL, 0x000fe20000410000ULL,
0x0000000809107824ULL, 0x000fe200078e00ffULL, 0xfffffff8110a7812ULL, 0x000fe200078ee204ULL,
0x0000000809047824ULL, 0x040fe200078e00ffULL, 0xffffffff09117810ULL, 0x040fe20007ffe0ffULL,
0x00000008091b7824ULL, 0x040fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20fULL,
0x0000000809167824ULL, 0x040fe200078e00ffULL, 0x00000006090f7810ULL, 0x000fe20007ffe0ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0xfffffff804047812ULL, 0x000fe200078ee209ULL,
0x0000001010107824ULL, 0x000fe200078e0203ULL, 0xfffffff81b0c7812ULL, 0x000fc400078ee20cULL,
0xfffffff816167812ULL, 0x000fe200078ee20fULL, 0x0000001004047824ULL, 0x000fe200078e0203ULL,
0xfffffff832327812ULL, 0x000fe200078ee211ULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x0000000c08097812ULL, 0x000fe200078ec0ffULL, 0x0000001016167824ULL, 0x100fe200078e0203ULL,
0x000000313030723eULL, 0x000fe200000000ffULL, 0x0000001032327824ULL, 0x000fe200078e0203ULL,
0x0000002d2c2c723eULL, 0x000fe200000000ffULL, 0x0000000104037824ULL, 0x000fe200078e0209ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x00000001090b7824ULL, 0x040fe200078e020aULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x00000001090d7824ULL, 0x040fe200078e020cULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x00000001090f7824ULL, 0x040fe200078e020eULL,
0x000000170000723eULL, 0x000fe200000000ffULL, 0x0000000109117824ULL, 0x040fe200078e0210ULL,
0x0000003003007388ULL, 0x0003e20000000800ULL, 0x0000000109127824ULL, 0x040fe200078e0212ULL,
0x000000130606723eULL, 0x000fe200000000ffULL, 0x0000000109167824ULL, 0x000fe200078e0216ULL,
0x0000002c0b007388ULL, 0x0003e20000000800ULL, 0x000000180505723eULL, 0x000fe200000000ffULL,
0x0000000109327824ULL, 0x040fe200078e0232ULL, 0x0000002f2e2e723eULL, 0x000fe200000000ffULL,
0x000000280d007388ULL, 0x0003e20000000800ULL, 0x0000000109097824ULL, 0x000fe200078e0234ULL,
0x0000002b2a2a723eULL, 0x000fc400000000ffULL, 0x000000240f007388ULL, 0x0003e20000000800ULL,
0x000000272626723eULL, 0x000fe400000000ffULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000002011007388ULL, 0x0003e20000000800ULL, 0x0000001f1e1e723eULL, 0x000fe400000000ffULL,
0x0000001c1515723eULL, 0x000fe200000000ffULL, 0x0000000012007388ULL, 0x0003e20000000800ULL,
0x0000001a1919723eULL, 0x000fe400000000ffULL, 0x000000140707723eULL, 0x000fe200000000ffULL,
0x0000000616007388ULL, 0x0003e80000000800ULL, 0x0000000532007388ULL, 0x0003e80000000800ULL,
0x0000002e09007388ULL, 0x0003e80000000800ULL, 0x0004002a0b007388ULL, 0x0003e80000000800ULL,
0x000400260d007388ULL, 0x0003e80000000800ULL, 0x000400220f007388ULL, 0x0003e80000000800ULL,
0x0004001e11007388ULL, 0x0003e80000000800ULL, 0x0004001512007388ULL, 0x0003e80000000800ULL,
0x0004001916007388ULL, 0x0003e80000000800ULL, 0x0004000732007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000077919ULL, 0x006e620000000000ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x0000580000047ab9ULL, 0x000fc40000000800ULL,
0x0000000000047919ULL, 0x000f220000002600ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000020070d7810ULL, 0x00afc60007ffe0ffULL, 0x00000005040472a4ULL, 0x004fe2000f8e023fULL,
0x00000003ff067819ULL, 0x000fe40000011607ULL, 0x00000003ff037819ULL, 0x000fe2000001160dULL,
0x00000008040f7824ULL, 0x010fe400078e00ffULL, 0x0000000106057824ULL, 0x000fe400078e0207ULL,
0x000000010d007824ULL, 0x000fe400078e0203ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0x0000000705087812ULL, 0x000fc400078ec0ffULL, 0x0000000700007812ULL, 0x000fe400078ec0ffULL,
0x0ffffff808097812ULL, 0x000fe400078ef807ULL, 0x0ffffff800057812ULL, 0x000fe400078ef80dULL,
0xfffffff80f007812ULL, 0x000fe200078ee206ULL, 0x0000001009087824ULL, 0x100fe200078e0202ULL,
0xfffffff804037812ULL, 0x000fe200078ee203ULL, 0x0000001005057824ULL, 0x000fe200078e0202ULL,
0x0000000400067c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000403007c10ULL, 0x000fe2000ff3e0ffULL,
0x00a0000008087984ULL, 0x000e620000000c00ULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0006027a11ULL, 0x040fe200078048ffULL,
0x00a0000005107984ULL, 0x0004e20000000c00ULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x00005b0006037a11ULL, 0x000fe400000f4c03ULL, 0x1ffffff807077812ULL, 0x000fc400078ef848ULL,
0x1ffffff80d0d7812ULL, 0x000fe200078ef848ULL, 0x000000ffff057224ULL, 0x004fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fe200078248ffULL, 0x0000001007027825ULL, 0x000fc600078e0002ULL,
0x00005b0000057a11ULL, 0x000fca00008f4c05ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x002fe8000c101d06ULL, 0x0000001004007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000403067824ULL, 0x002fe400078e0200ULL,
0xffffffffff1d7424ULL, 0x000fc600078e00ffULL, 0x000000450600720cULL, 0x000fda0003f06070ULL,
0x0000000223058824ULL, 0x000fc800078e00ffULL, 0x00006400050a8a24ULL, 0x000fc800078e0206ULL,
0x000060000a0a8625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060a1d8981ULL, 0x000ea2000c1e1900ULL, 0x0000000103057810ULL, 0x000fe20007ffe0ffULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004000047824ULL, 0x000fe200078e00ffULL,
0x01460000ff087f8cULL, 0x000e62000c80043fULL, 0x000000460500720cULL, 0x000fe20003f06070ULL,
0x0000004010057824ULL, 0x000fe400078e00ffULL, 0x000000041d1e7c24ULL, 0x004fd4000f8e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000010003077824ULL, 0x002fe200078e0204ULL,
0x00000002ff207819ULL, 0x000fe40000011602ULL, 0x0000000202137211ULL, 0x000fe400078fe8ffULL,
0x00000007440a7217ULL, 0x000fe20007800000ULL, 0x00000040100b7824ULL, 0x000fe200078e0220ULL,
0x0000000313137812ULL, 0x000fe400078ec0ffULL, 0x000000300e1f7812ULL, 0x000fe200078ec0ffULL,
0x000000010a077824ULL, 0x000fe200078e0a07ULL, 0x000000080b0a7810ULL, 0x000fc40007ffe0ffULL,
0x000000100b0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a1e0a7210ULL, 0x040fe40007f3e0ffULL,
0x0000000b1e167210ULL, 0x040fe40007f1e0ffULL, 0x0000000c1e0c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e06ffULL, 0x00005e000a197a11ULL, 0x000fe200078248ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e0016107a11ULL, 0x000fe200078048ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0x00005f000a1b7a11ULL, 0x000fc400008f4c1bULL,
0x000000180b0a7810ULL, 0x000fe40007ffe0ffULL, 0x000000072000720cULL, 0x000fe40003f66070ULL,
0x00005e000c127a11ULL, 0x000fe400078448ffULL, 0x00005f0016167a11ULL, 0x000fe400000f4c0fULL,
0x0000000a1e117210ULL, 0x000fe40007f3e0ffULL, 0x0000200000157811ULL, 0x000fc400078e68ffULL,
0x0ffffffc13027812ULL, 0x000fe400078ef802ULL, 0x000000101f0a7210ULL, 0x000fe40007f1e0ffULL,
0x00005f000c147a11ULL, 0x000fe200010f4c0dULL, 0x0000001002177824ULL, 0x000fe200078e0215ULL,
0x000000200b0c7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x000000280b0d7810ULL, 0x040fe40007ffe0ffULL, 0x000000300b0e7810ULL, 0x000fc40007ffe0ffULL,
0x000000380b0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0616ULL,
0x0000000c1e1c7210ULL, 0x040fe40007f5e0ffULL, 0x0000000d1e1a7210ULL, 0x040fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a177faeULL, 0x0003e2000d901c46ULL,
0x0000001f190c7210ULL, 0x000fe40007f7e0ffULL, 0x0000000e1e187210ULL, 0x040fe40007f1e0ffULL,
0x0000000f1e167210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e061bULL,
0x00005e0011107a11ULL, 0x000fc400078848ffULL, 0x00000008201e7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0011027a11ULL, 0x000fe200020f4c02ULL, 0x000000ffff177224ULL, 0x002fe200010e06ffULL,
0x000000071e00720cULL, 0x040fe20003f66070ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x0000001f10107210ULL, 0x080fe40007fbe0ffULL, 0x0000001020227810ULL, 0x000fe40007ffe0ffULL,
0x0000001f120e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0602ULL,
0x0000001820127810ULL, 0x000fe20007ffe0ffULL, 0x00000004220a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e027812ULL, 0x000fe200078ee213ULL, 0x000000ffff0f7224ULL, 0x000fe200020e0614ULL,
0x000000071200720cULL, 0x0c0fe20003fa6070ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x000000072200720cULL, 0x000fe20003f86070ULL, 0x00000010020b7824ULL, 0x000fe200078e0215ULL,
0x00005e001c1b7a11ULL, 0x000fc400078448ffULL, 0xfffffffc0a0a7812ULL, 0x100fe400078ee213ULL,
0x0000002020027810ULL, 0x000fe20007ffe0ffULL, 0x000000000c0b7faeULL, 0x0003e2000d901c46ULL,
0xfffffffc12127812ULL, 0x000fe400078ee213ULL, 0x00005f001c1c7a11ULL, 0x000fe200010f4c17ULL,
0x000000100a177824ULL, 0x100fe200078e0215ULL, 0x000000070200720cULL, 0x0c0fe20003f46070ULL,
0x0000000402027824ULL, 0x000fe200078e00ffULL, 0x00000028200a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001012197824ULL, 0x000fe200078e0215ULL, 0x0000003020127810ULL, 0x040fe20007ffe0ffULL,
0x000000000e177faeULL, 0x0005e2000e101c46ULL, 0x0000003820147810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x002fe200008e06ffULL, 0x000000070a00720cULL, 0x0c0fe20003f66070ULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc02027812ULL, 0x000fe200078ee213ULL,
0x0000000010197faeULL, 0x0003e2000e901c46ULL, 0x000000071200720cULL, 0x0c0fe20003f86070ULL,
0x00000004120c7824ULL, 0x000fe200078e00ffULL, 0x000000071400720cULL, 0x000fe20003fa6070ULL,
0x0000001002077824ULL, 0x000fe200078e0215ULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee213ULL,
0x00000004140e7824ULL, 0x004fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee213ULL,
0x000000ffff0f7224ULL, 0x000fc600000e06ffULL, 0xfffffffc0e0e7812ULL, 0x000fe200078ee213ULL,
0x000000ffff117224ULL, 0x002fe200030e06ffULL, 0x00005e001a027a11ULL, 0x000fe200078c48ffULL,
0x000000100a137824ULL, 0x100fe400078e0215ULL, 0x000000100c177824ULL, 0x000fe200078e0215ULL,
0x00005f001a117a11ULL, 0x000fe200030f4c11ULL, 0x000000100e157824ULL, 0x000fe200078e0215ULL,
0x0000001f1b0a7210ULL, 0x000fe40007fde0ffULL, 0x00005e00180e7a11ULL, 0x000fc400078048ffULL,
0x0000001f020c7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e061cULL,
0x00005e0016107a11ULL, 0x000fe400078c48ffULL, 0x00005f00180f7a11ULL, 0x000fe400000f4c0fULL,
0x00005f0016027a11ULL, 0x000fe200030f4c0dULL, 0x000000ffff0d7224ULL, 0x000fe200008e0611ULL,
0x0000001f0e0e7210ULL, 0x080fe20007f1e0ffULL, 0x000000000a077faeULL, 0x0003e2000d101c46ULL,
0x0000001f10107210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x000000000c137faeULL, 0x0003e2000d901c46ULL, 0x000000ffff117224ULL, 0x000fc600008e0602ULL,
0x000000000e177faeULL, 0x0003e8000e101c46ULL, 0x0000000010157faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000000502077211ULL, 0x042fe400078ff0ffULL,
0x0000000802187811ULL, 0x000fe400078ff0ffULL, 0x000000071e077210ULL, 0x000fe40007f1e0ffULL,
0x00000010020a7811ULL, 0x000fc400078ff0ffULL, 0x00000018020c7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x00005e0007197a11ULL, 0x000fe200078048ffULL,
0x00000001050b7824ULL, 0x040fe200078e020aULL, 0x0000002002107811ULL, 0x040fe200078ff0ffULL,
0x00000001050d7824ULL, 0x040fe200078e020cULL, 0x0000002802127811ULL, 0x000fe200078ff0ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x0000003002147811ULL, 0x040fe200078ff0ffULL,
0x00000001050f7824ULL, 0x040fe200078e0210ULL, 0x0000003802167811ULL, 0x040fe200078ff0ffULL,
0x0000000105117824ULL, 0x000fe200078e0212ULL, 0x00005f0007267a11ULL, 0x000fe200000f4c26ULL,
0x0000000105077824ULL, 0x040fe200078e0218ULL, 0x0000000202177211ULL, 0x000fe200078fe8ffULL,
0x0000000105137824ULL, 0x040fe200078e0214ULL, 0x0000000b1e207210ULL, 0x040fe20007fbe0ffULL,
0x0000000105157824ULL, 0x000fe200078e0216ULL, 0x000000071e077210ULL, 0x000fe20007fde0ffULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0x0000000d1e1c7210ULL, 0x000fe20007f1e0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000f1e1a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x000000111e117210ULL, 0x000fe20007f5e0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x000000131e137210ULL, 0x000fe20007f7e0ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x000000151e157210ULL, 0x000fe20007f9e0ffULL,
0x00000004121e7824ULL, 0x000fe200078e00ffULL, 0x0000000317177812ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200030e06ffULL, 0x0000200000297811ULL, 0x000fc400078e68ffULL,
0xfffffffc140f7812ULL, 0x100fe400078ee217ULL, 0xfffffffc1e0d7812ULL, 0x100fe400078ee217ULL,
0xfffffffc0c0b7812ULL, 0x000fe200078ee217ULL, 0x000000100f277824ULL, 0x100fe200078e0229ULL,
0x0ffffffc17127812ULL, 0x000fe200078ef802ULL, 0x000000100d257824ULL, 0x000fe200078e0229ULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee217ULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e001c0d7a11ULL, 0x000fe200078048ffULL, 0x000000100b1f7824ULL, 0x000fe200078e0229ULL,
0xfffffffc100c7812ULL, 0x000fe200078ee217ULL, 0x00000010122b7824ULL, 0x000fe200078e0229ULL,
0x00005f001c1c7a11ULL, 0x000fe200000f4c0fULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x000000300e0f7812ULL, 0x000fe200078ec0ffULL, 0x000000100a1b7824ULL, 0x000fe200078e0229ULL,
0xfffffffc18027812ULL, 0x000fe200078ee217ULL, 0x000000100c217824ULL, 0x000fe200078e0229ULL,
0x00005e0007227a11ULL, 0x000fe200078c48ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffffc16107812ULL, 0x000fe200078ee217ULL, 0x000000ffff177224ULL, 0x000fe200028e06ffULL,
0x00005e001a127a11ULL, 0x000fe200078248ffULL, 0x000000ffff0c7224ULL, 0x000fe200018e06ffULL,
0x00005e00201e7a11ULL, 0x000fc400078a48ffULL, 0x000000190f0a7210ULL, 0x000fe40007f1e0ffULL,
0x00005e0013167a11ULL, 0x000fe400078448ffULL, 0x00005f0007247a11ULL, 0x000fe200030f4c24ULL,
0x0000001002077824ULL, 0x000fe200078e0229ULL, 0x00005f001a1a7a11ULL, 0x000fe200008f4c0bULL,
0x000000ffff027224ULL, 0x000fe200020e06ffULL, 0x00005e0011147a11ULL, 0x000fe200078248ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0626ULL, 0x00005f0020207a11ULL, 0x000fe200028f4c17ULL,
0x0000001010297824ULL, 0x000fe200078e0229ULL, 0x00005e0015187a11ULL, 0x000fc400078648ffULL,
0x00005f0013177a11ULL, 0x000fe200010f4c0cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2b7faeULL, 0x0003e2000b901c46ULL, 0x000000220f0c7210ULL, 0x000fe40007f1e0ffULL,
0x00005f0011197a11ULL, 0x000fe400008f4c0eULL, 0x0000001e0f0e7210ULL, 0x000fe40007f3e0ffULL,
0x00005f0015027a11ULL, 0x000fe400018f4c02ULL, 0x0000000d0f107210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e0624ULL, 0x000000120f127210ULL, 0x000fc40007f7e0ffULL,
0x000000140f147210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e061cULL,
0x000000160f167210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200018e061aULL,
0x000000180f187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e0620ULL,
0x000000000c077faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fe400020e0619ULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x000000000e1b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff197224ULL, 0x000fc600000e0602ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000016277faeULL, 0x0003e8000b901c46ULL, 0x0000000018297faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fc40000015200ULL,
0x01460400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a077210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e0bULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140cULL,
0x0000000702027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e060cULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01460400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000460300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000227919ULL, 0x000e620000000000ULL, 0x0000640023237a24ULL, 0x000fe200078e02ffULL,
0x0001468800217811ULL, 0x040fe200078e18ffULL, 0x00000020001e7824ULL, 0x000fe200078e00ffULL,
0xffffffff46207810ULL, 0x000fc40007ffe0ffULL, 0x00000100031f7824ULL, 0x000fe200078e0204ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000001f4400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x0000000103077810ULL, 0x000fe20007ffe0ffULL,
0x000000041d1d7c24ULL, 0x000fc6000f8e02ffULL, 0x000000460700720cULL, 0x000fda0003f06070ULL,
0x000006a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x002fe40000011622ULL,
0x00000003221c7812ULL, 0x000fe400078ec0ffULL, 0x0000000813157810ULL, 0x000fe20007ffe0ffULL,
0x0000000105027824ULL, 0x000fe200078e0213ULL, 0x0000002013297810ULL, 0x040fe40007ffe0ffULL,
0x0000001013257810ULL, 0x000fe20007ffe0ffULL, 0x00000004151b7824ULL, 0x000fe200078e00ffULL,
0x000000021d027210ULL, 0x000fe20007f3e0ffULL, 0x00000001050e7824ULL, 0x000fe200078e0229ULL,
0x0000001813277810ULL, 0x000fe20007ffe0ffULL, 0x00000001050a7824ULL, 0x000fe200078e0225ULL,
0x00000038132c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0002087a11ULL, 0x000fe200078248ffULL, 0x00000001050c7824ULL, 0x000fe200078e0227ULL,
0x0000000a1d0d7210ULL, 0x000fc40007f7e0ffULL, 0x00005f0002097a11ULL, 0x000fe200008f4c07ULL,
0x0000000105027824ULL, 0x000fe200078e0215ULL, 0x0000000c1d0f7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe400078648ffULL,
0x000000021d0b7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x0000000e1d027210ULL, 0x000fe40007f3e0ffULL, 0x00000030132b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002107a11ULL, 0x000fc400078248ffULL,
0x00005f000b0b7a11ULL, 0x000fe200010f4c16ULL, 0x0000000105167824ULL, 0x000fe200078e022cULL,
0x00005f0002117a11ULL, 0x000fe200008f4c07ULL, 0x0000000144027824ULL, 0x000fe200078e0a1fULL,
0x0000002222077211ULL, 0x040fe400078fe8ffULL, 0x0ffffffc22477812ULL, 0x000fe400078ec0ffULL,
0x0000000307287812ULL, 0x000fe400078ec0ffULL, 0x00005e000f0e7a11ULL, 0x000fc400078848ffULL,
0x000000021300720cULL, 0x0c0fe40003f46070ULL, 0x00000028132a7810ULL, 0x000fe40007ffe0ffULL,
0x000000021500720cULL, 0x000fe40003f26070ULL, 0x00005f000d0d7a11ULL, 0x000fe200018f4c14ULL,
0x0000000105147824ULL, 0x000fe200078e022bULL, 0x0000300000187811ULL, 0x000fe400078e68ffULL,
0x000000041c077812ULL, 0x000fc400078efcffULL, 0x0000004728197212ULL, 0x000fe400078efcffULL,
0x00005f000f0f7a11ULL, 0x000fe200020f4c12ULL, 0x0000000105127824ULL, 0x000fe200078e022aULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee228ULL, 0x0000001019197824ULL, 0x000fe200078e0218ULL,
0x000000161d177210ULL, 0x000fe20007f7e0ffULL, 0x0000001007087825ULL, 0x000fe200078e0008ULL,
0x000000141d157210ULL, 0x040fe40007fbe0ffULL, 0x000000121d137210ULL, 0x000fe20007f9e0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e2000d101c46ULL, 0x00000010070a7825ULL, 0x000fe200078e000aULL,
0x000000022700720cULL, 0x000fc40003f46070ULL, 0x000000022c00720cULL, 0x080fe20003fc6070ULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x00005e0017167a11ULL, 0x000fe200078648ffULL,
0x000000ffff247224ULL, 0x000fe200028e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078a48ffULL,
0x000000000a1b7faeULL, 0x0005e2000c901c46ULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x000000022500720cULL, 0x0c0fe20003f26070ULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x00005e0013127a11ULL, 0x000fe200078848ffULL, 0x0000000427277824ULL, 0x000fe200078e00ffULL,
0x00005f0017177a11ULL, 0x000fe200018f4c1aULL, 0x000000042a097824ULL, 0x002fe200078e00ffULL,
0x000000022900720cULL, 0x040fe20003f66070ULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0x00005f0015157a11ULL, 0x000fc400028f4c24ULL, 0x000000022b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0x00005f0013137a11ULL, 0x000fe200020f4c26ULL,
0x000000042c0b7824ULL, 0x004fe200078e00ffULL, 0x000000022a00720cULL, 0x000fe40003f86070ULL,
0xfffffffc25197812ULL, 0x100fe400078ee228ULL, 0xfffffffc271b7812ULL, 0x100fe400078ee228ULL,
0xfffffffc29257812ULL, 0x000fe200078ee228ULL, 0x0000001019197824ULL, 0x000fe200078e0218ULL,
0xfffffffc09277812ULL, 0x000fe200078ee228ULL, 0x0000001007087825ULL, 0x000fe200078e000cULL,
0xfffffffc2b297812ULL, 0x000fc400078ee228ULL, 0xfffffffc0b2b7812ULL, 0x000fe200078ee228ULL,
0x000000101b1b7824ULL, 0x000fe200078e0218ULL, 0x0000000008197faeULL, 0x0003e2000c901c46ULL,
0x00000010070a7825ULL, 0x000fc800078e000eULL, 0x0000001025257824ULL, 0x000fe200078e0218ULL,
0x000000000a1b7faeULL, 0x0003e2000d101c46ULL, 0x00000010070c7825ULL, 0x000fc800078e0010ULL,
0x0000001027277824ULL, 0x000fe200078e0218ULL, 0x000000000c257faeULL, 0x0003e2000d901c46ULL,
0x00000010070e7825ULL, 0x000fc800078e0012ULL, 0x0000001029297824ULL, 0x000fe200078e0218ULL,
0x000000000e277faeULL, 0x0003e2000e101c46ULL, 0x0000001007107825ULL, 0x000fc800078e0014ULL,
0x000000102b2b7824ULL, 0x000fe200078e0218ULL, 0x0000000010297faeULL, 0x0003e2000e901c46ULL,
0x0000001007127825ULL, 0x000fca00078e0016ULL, 0x00000000122b7faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000522027211ULL, 0x042fe400078ff0ffULL,
0x0000001822107811ULL, 0x000fe400078ff0ffULL, 0x0000001d02027210ULL, 0x000fe40007f3e0ffULL,
0x00000010220e7811ULL, 0x000fe200078ff0ffULL, 0x00000004100d7824ULL, 0x000fe200078e00ffULL,
0x00000022220a7211ULL, 0x000fe200078fe8ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0002087a11ULL, 0x000fe200078248ffULL, 0x0000000105127824ULL, 0x000fe200078e0210ULL,
0x0000002022167811ULL, 0x000fe200078ff0ffULL, 0x000000040e0b7824ULL, 0x000fe200078e00ffULL,
0x00005f0002097a11ULL, 0x000fc400008f4c07ULL, 0x0000000822027811ULL, 0x000fe200078ff0ffULL,
0x00000004160f7824ULL, 0x000fe200078e00ffULL, 0x00000028221a7811ULL, 0x040fe200078ff0ffULL,
0x0000000105167824ULL, 0x040fe200078e0216ULL, 0x0000003022247811ULL, 0x040fe200078ff0ffULL,
0x00000001050c7824ULL, 0x040fe200078e0202ULL, 0x0000003822287811ULL, 0x000fe200078ff0ffULL,
0x0000000402077824ULL, 0x000fe200078e00ffULL, 0x000000030a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000105027824ULL, 0x000fe200078e020eULL, 0x00003000002b7811ULL, 0x000fe200078e68ffULL,
0x000000041a117824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d147812ULL, 0x100fe200078ee20aULL,
0x0000000424137824ULL, 0x000fe200078e00ffULL, 0x0000001d020d7210ULL, 0x080fe20007f5e0ffULL,
0x0000000428157824ULL, 0x000fe200078e00ffULL, 0xfffffffc070e7812ULL, 0x000fe200078ee20aULL,
0x00000001051a7824ULL, 0x040fe200078e021aULL, 0x0000001d12027210ULL, 0x000fe20007f7e0ffULL,
0x0000000105247824ULL, 0x000fe200078e0224ULL, 0x0ffffffc22477812ULL, 0x000fe200078ec0ffULL,
0x000000100e077824ULL, 0x100fe200078e022bULL, 0xfffffffc0b107812ULL, 0x100fe200078ee20aULL,
0x00000010141b7824ULL, 0x100fe200078e022bULL, 0xfffffffc0f187812ULL, 0x100fe200078ee20aULL,
0x000000ffff0f7224ULL, 0x000fe200018e06ffULL, 0xfffffffc111c7812ULL, 0x100fe200078ee20aULL,
0x0000001010197824ULL, 0x100fe200078e022bULL, 0xfffffffc13267812ULL, 0x100fe200078ee20aULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0xfffffffc152a7812ULL, 0x000fe200078ee20aULL,
0x000000101c277824ULL, 0x100fe200078e022bULL, 0x000000470a0a7212ULL, 0x000fe200078efcffULL,
0x0000001018257824ULL, 0x100fe200078e022bULL, 0x0000001d0c0b7210ULL, 0x000fe20007f3e0ffULL,
0x0000001026297824ULL, 0x100fe200078e022bULL, 0x00005e00020e7a11ULL, 0x000fe200078648ffULL,
0x000000100a2f7824ULL, 0x000fe200078e022bULL, 0x00005e000d0c7a11ULL, 0x000fe200078448ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00005f00020f7a11ULL, 0x000fe200018f4c0fULL,
0x0000000105027824ULL, 0x000fe200078e0228ULL, 0x00005e000b0a7a11ULL, 0x000fe200078248ffULL,
0x000000102a2b7824ULL, 0x000fe200078e022bULL, 0x00005f000d0d7a11ULL, 0x000fc400010f4c10ULL,
0x0000001d16117210ULL, 0x080fe40007f5e0ffULL, 0x0000001d1a137210ULL, 0x080fe40007f7e0ffULL,
0x00005f000b0b7a11ULL, 0x000fe400008f4c12ULL, 0x00000003221c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x0000001d24157210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x0000001d02027210ULL, 0x000fc40007f3e0ffULL,
0x000000041c2d7812ULL, 0x000fe200078efcffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078648ffULL, 0x000000102d087825ULL, 0x000fe200078e0008ULL,
0x00005e0015147a11ULL, 0x000fe400078848ffULL, 0x00005e0002167a11ULL, 0x040fe200078248ffULL,
0x000000102d0a7825ULL, 0x000fe200078e000aULL, 0x00005f0011117a11ULL, 0x000fe200010f4c24ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082f7faeULL, 0x0003e2000b901c46ULL,
0x00005f0013137a11ULL, 0x000fe200018f4c1aULL, 0x000000102d0c7825ULL, 0x000fe200078e000cULL,
0x00005f0015157a11ULL, 0x000fe200020f4c18ULL, 0x000000000a077faeULL, 0x0003e2000b901c46ULL,
0x00005f0002177a11ULL, 0x000fe200008f4c17ULL, 0x000000102d0e7825ULL, 0x000fc400078e000eULL,
0x000000000c197faeULL, 0x0003e4000b901c46ULL, 0x000000102d107825ULL, 0x040fe400078e0010ULL,
0x000000000e1b7faeULL, 0x0003e4000b901c46ULL, 0x000000102d127825ULL, 0x040fe400078e0012ULL,
0x0000000010257faeULL, 0x0003e4000b901c46ULL, 0x000000102d147825ULL, 0x000fc400078e0014ULL,
0x0000000012277faeULL, 0x0003e4000b901c46ULL, 0x000000102d167825ULL, 0x000fe400078e0016ULL,
0x0000000014297faeULL, 0x0003e8000b901c46ULL, 0x00000000162b7faeULL, 0x0003e4000b901c46ULL,
0x00000004ff1a7819ULL, 0x100fe20000011622ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000007221b7812ULL, 0x002fe200078ec0ffULL, 0x0000200000507824ULL, 0x000fe200078e00ffULL,
0x00000003ff577819ULL, 0x000fe20000011622ULL, 0x000000081a087824ULL, 0x000fc600078e00ffULL,
0x0000000157077812ULL, 0x000fe400078ec0ffULL, 0xfffffff808087812ULL, 0x000fe400078ee21bULL,
0x000000081b1b7812ULL, 0x000fe400078ef822ULL, 0x0000001008107810ULL, 0x040fe20007ffe0ffULL,
0x0000000408517824ULL, 0x040fe200078e00ffULL, 0x0000002008127810ULL, 0x040fe20007ffe0ffULL,
0x000000011b1a7824ULL, 0x040fe200078e021aULL, 0x0000003008147810ULL, 0x040fe20007ffe0ffULL,
0x000000201b097824ULL, 0x000fe200078e00ffULL, 0x00000007080c7211ULL, 0x0c0fe200078ff8ffULL,
0x0000000408347824ULL, 0x000fe200078e00ffULL, 0x0000000710117211ULL, 0x0c0fe200078ff8ffULL,
0x0000000410087824ULL, 0x000fe200078e00ffULL, 0x0000000712137211ULL, 0x0c0fe200078ff8ffULL,
0x0000000412527824ULL, 0x000fe200078e00ffULL, 0x0000000714307211ULL, 0x040fe200078ff8ffULL,
0x0000000414077824ULL, 0x000fe200078e00ffULL, 0x0000200050197810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffffe009027812ULL, 0x000fe200078ee21aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffffc51517812ULL, 0x000fe200078ee20cULL,
0x000000201b327824ULL, 0x000fe200078e00ffULL, 0xfffffffc08537812ULL, 0x000fe200078ee211ULL,
0x0000001002027824ULL, 0x000fe200078e00ffULL, 0xfffffffc52527812ULL, 0x000fe200078ee213ULL,
0x0000001051187824ULL, 0x100fe200078e0219ULL, 0xfffffffc07567812ULL, 0x000fe200078ee230ULL,
0x0000001053177824ULL, 0x100fe200078e0219ULL, 0x000000000208783bULL, 0x0003e20000000200ULL,
0x0000001052167824ULL, 0x100fe200078e0219ULL, 0x000000020c317810ULL, 0x000fe20007ffe0ffULL,
0x0000001056157824ULL, 0x000fe200078e0219ULL, 0x00000000182c783bULL, 0x000ea20000000200ULL,
0x000000021a077810ULL, 0x000fe20007ffe0ffULL, 0x0000000410337824ULL, 0x000fe200078e00ffULL,
0x0000000211547810ULL, 0x000fe20007ffe0ffULL, 0x000000001728783bULL, 0x000ee20000000200ULL,
0xffffffe032027812ULL, 0x002fe200078ee207ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000000213557810ULL, 0x000fe20007ffe0ffULL, 0x000000001624783bULL, 0x000e620000000200ULL,
0x0000000414117824ULL, 0x000fe200078e00ffULL, 0x0000000230307810ULL, 0x000fe20007ffe0ffULL,
0x00000010024c7824ULL, 0x000fe200078e00ffULL, 0x00000000150c783bULL, 0x000f220000000200ULL,
0xfffffffc34077812ULL, 0x000fc400078ee231ULL, 0xfffffffc33547812ULL, 0x000fe400078ee254ULL,
0xfffffffc12557812ULL, 0x000fe200078ee255ULL, 0x0000001007147824ULL, 0x100fe200078e0219ULL,
0xfffffffc11027812ULL, 0x000fe200078ee230ULL, 0x0000001054137824ULL, 0x100fe200078e0219ULL,
0x000000004c4c783bULL, 0x000fe20000000200ULL, 0x0000001055127824ULL, 0x100fe400078e0219ULL,
0x0000001002117824ULL, 0x000fe200078e0219ULL, 0x00000000145c783bULL, 0x000e680000000200ULL,
0x000000001360783bULL, 0x000e680000000200ULL, 0x000000001264783bULL, 0x000f280000000200ULL,
0x000000001158783bULL, 0x000f220000000200ULL, 0x0000002c0830723cULL, 0x044f7000000018ffULL,
0x0000002e0834723cULL, 0x040f7000000018ffULL, 0x000000280838723cULL, 0x048f7000000018ffULL,
0x0000002a0828723cULL, 0x040f7000000018ffULL, 0x00000024083c723cULL, 0x042f7000000018ffULL,
0x000000260840723cULL, 0x040f7000000018ffULL, 0x0000000c0848723cULL, 0x050f7000000018ffULL,
0x0000000e0808723cULL, 0x000f7000000018ffULL, 0x0000005c4c2c723cULL, 0x060b700000001830ULL,
0x0000005e4c30723cULL, 0x040b700000001834ULL, 0x000000604c34723cULL, 0x040b700000001838ULL,
0x000000624c38723cULL, 0x040b700000001828ULL, 0x000000644c3c723cULL, 0x040b70000000183cULL,
0x000000664c40723cULL, 0x040b700000001840ULL, 0x000000584c48723cULL, 0x040b700000001848ULL,
0x0000005a4c4c723cULL, 0x000b620000001808ULL, 0x0000067000008947ULL, 0x000fce0003800000ULL,
0x00000002ff0e7819ULL, 0x000fe20000011622ULL, 0x00000001445a7824ULL, 0x020fc600078e0a1fULL,
0x000000080e0f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105087824ULL, 0x040fe200078e020eULL,
0x000000100e5c7810ULL, 0x040fe40007ffe0ffULL, 0x000000180e5e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001050c7824ULL, 0x000fe200078e020fULL, 0x000000081d097210ULL, 0x000fe20007f3e0ffULL,
0x0000000105107824ULL, 0x040fe200078e025cULL, 0x000000200e5f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105267824ULL, 0x000fe200078e025eULL, 0x0000000c1d0b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0009087a11ULL, 0x000fe200078248ffULL,
0x0000000105287824ULL, 0x000fe200078e025fULL, 0x000000101d0d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x00005f0009097a11ULL, 0x000fe200008f4c0aULL,
0x000000045c5d7824ULL, 0x000fe200078e00ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078248ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x00005e000d0c7a11ULL, 0x000fc400078448ffULL,
0x00005f000b0b7a11ULL, 0x000fe400008f4c10ULL, 0x000000261d107210ULL, 0x000fe40007f3e0ffULL,
0x000000280e607810ULL, 0x040fe40007ffe0ffULL, 0x000000300e617810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005f000d0d7a11ULL, 0x000fe200010f4c24ULL,
0x00000001052a7824ULL, 0x000fe200078e0260ULL, 0x000000281d287210ULL, 0x000fe20007f5e0ffULL,
0x0000000105587824ULL, 0x000fe200078e0261ULL, 0x00005e0010247a11ULL, 0x000fc400078248ffULL,
0x000000380e637810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe200010e06ffULL,
0x00005f0010257a11ULL, 0x000fe200008f4c25ULL, 0x0000000157107824ULL, 0x000fe200078e0222ULL,
0x0000002a1d297210ULL, 0x040fe40007f3e0ffULL, 0x00005e0028267a11ULL, 0x040fe400078448ffULL,
0x000000581d2b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff587224ULL, 0x000fe200008e06ffULL,
0x00005f0028277a11ULL, 0x000fc400010f4c27ULL, 0x00005e0029287a11ULL, 0x000fe200078448ffULL,
0x000000ffff627224ULL, 0x000fe200018e06ffULL, 0x0000005a0e00720cULL, 0x080fe20003f26070ULL,
0x00000001050e7824ULL, 0x000fe200078e0263ULL, 0x00005e002b2a7a11ULL, 0x000fe400078648ffULL,
0x0000000310107812ULL, 0x000fe400078ec0ffULL, 0x00005f0029297a11ULL, 0x000fe400010f4c58ULL,
0x0000005a0f00720cULL, 0x040fe20003f46070ULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x00005f002b2b7a11ULL, 0x000fc400018f4c62ULL, 0x0000004710477212ULL, 0x000fe400078efcffULL,
0x000000081c577812ULL, 0x000fe400078efcffULL, 0x0000000e1d597210ULL, 0x000fe40007f7e0ffULL,
0xfffffffc0f0e7812ULL, 0x000fe200078ee210ULL, 0x00000010470f7824ULL, 0x000fe200078e0219ULL,
0x0000005a6100720cULL, 0x080fe20003fa6070ULL, 0x0000001057087825ULL, 0x000fe200078e0008ULL,
0x0000005a6300720cULL, 0x000fc40003fc6070ULL, 0x0000005a6000720cULL, 0x080fe20003f86070ULL,
0x000000ffff627224ULL, 0x000fe200018e06ffULL, 0x00005e0059587a11ULL, 0x000fe200078648ffULL,
0x000000100e5b7824ULL, 0x000fe200078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x0003e2000c901c46ULL, 0x00000010570a7825ULL, 0x000fe200078e000aULL,
0x00005f0059597a11ULL, 0x000fe400018f4c62ULL, 0x0000005a5c00720cULL, 0x080fe20003f26070ULL,
0x0000000461617824ULL, 0x000fe200078e00ffULL, 0x000000000a5b7faeULL, 0x0005e2000d101c46ULL,
0xfffffffc5d0e7812ULL, 0x000fe200078ee210ULL, 0x0000000463637824ULL, 0x000fe200078e00ffULL,
0x0000005a5f00720cULL, 0x0c0fe20003f66070ULL, 0x000000045f5f7824ULL, 0x000fe200078e00ffULL,
0x0000005a5e00720cULL, 0x000fe20003f46070ULL, 0x0000001057087825ULL, 0x002fe200078e000cULL,
0xfffffffc615a7812ULL, 0x000fc400078ee210ULL, 0xfffffffc635c7812ULL, 0x000fe200078ee210ULL,
0x00000010570c7825ULL, 0x000fc800078e0024ULL, 0x0000001057247825ULL, 0x000fc800078e0026ULL,
0x0000001057267825ULL, 0x000fe200078e002aULL, 0xfffffffc5f2a7812ULL, 0x000fc600078ee210ULL,
0x00000010570a7825ULL, 0x004fc800078e0028ULL, 0x000000045e2b7824ULL, 0x000fe400078e00ffULL,
0x0000001057287825ULL, 0x000fc800078e0058ULL, 0x0000000460577824ULL, 0x000fe400078e00ffULL,
0x000000100e5d7824ULL, 0x100fe200078e0219ULL, 0xfffffffc2b0e7812ULL, 0x100fe200078ee210ULL,
0x000000102a2b7824ULL, 0x100fe200078e0219ULL, 0xfffffffc57587812ULL, 0x000fe200078ee210ULL,
0x000000105a597824ULL, 0x100fe200078e0219ULL, 0x00000000085d7faeULL, 0x0003e2000c901c46ULL,
0x000000105c5b7824ULL, 0x100fe400078e0219ULL, 0x0000001058577824ULL, 0x000fc400078e0219ULL,
0x000000100e097824ULL, 0x002fca00078e0219ULL, 0x000000000c097faeULL, 0x0003e8000d101c46ULL,
0x00000000242b7faeULL, 0x0003e8000d901c46ULL, 0x000000000a577faeULL, 0x0003e8000e101c46ULL,
0x0000000026597faeULL, 0x0003e8000e901c46ULL, 0x00000000285b7faeULL, 0x0003e2000f101c46ULL,
0x000005c000007947ULL, 0x000fea0003800000ULL, 0x00000008220e7811ULL, 0x040fe400078ff0ffULL,
0x0000000522087211ULL, 0x020fc400078ff0ffULL, 0x0000002822607811ULL, 0x000fe200078ff0ffULL,
0x00000001050a7824ULL, 0x040fe200078e020eULL, 0x0000001d08097210ULL, 0x080fe20007f3e0ffULL,
0x000000040e597824ULL, 0x000fe200078e00ffULL, 0x00000018225c7811ULL, 0x000fe200078ff0ffULL,
0x0000000105267824ULL, 0x000fe200078e0260ULL, 0x0000001d0a0b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0009087a11ULL, 0x000fe200078248ffULL,
0x00000004605f7824ULL, 0x000fe200078e00ffULL, 0x00000010222a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x00005e000b0a7a11ULL, 0x000fc400078448ffULL,
0x00000020225e7811ULL, 0x000fe200078ff0ffULL, 0x000000042a5b7824ULL, 0x000fe200078e00ffULL,
0x00005f0009097a11ULL, 0x000fe200008f4c0cULL, 0x00000001050c7824ULL, 0x000fe200078e022aULL,
0x00005f000b0b7a11ULL, 0x000fe200010f4c10ULL, 0x0000000105107824ULL, 0x040fe200078e025cULL,
0x0000001d26297210ULL, 0x080fe20007f3e0ffULL, 0x0000000105247824ULL, 0x000fe200078e025eULL,
0x0000001d0c0d7210ULL, 0x080fe40007f5e0ffULL, 0x0000001d100f7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff627224ULL, 0x000fe200008e06ffULL, 0x00005e0029287a11ULL, 0x040fe200078248ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x0000001d24277210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff587224ULL, 0x000fe200018e06ffULL, 0x00005f0029297a11ULL, 0x000fc400008f4c62ULL,
0x00005e000f247a11ULL, 0x000fe200078648ffULL, 0x000000ffff5a7224ULL, 0x000fe200020e06ffULL,
0x0000003022627811ULL, 0x000fe400078ff0ffULL, 0x00005e000d0c7a11ULL, 0x000fe400078448ffULL,
0x00005e0027267a11ULL, 0x000fe200078848ffULL, 0x0000000462617824ULL, 0x000fe200078e00ffULL,
0x0000003822647811ULL, 0x000fe400078ff0ffULL, 0x00005f000f257a11ULL, 0x000fe200018f4c58ULL,
0x0000000105587824ULL, 0x000fe200078e0262ULL, 0x00005f000d0d7a11ULL, 0x000fe200010f4c10ULL,
0x0000000157107824ULL, 0x000fe200078e0222ULL, 0x00005f0027277a11ULL, 0x000fe200020f4c5aULL,
0x00000001055a7824ULL, 0x000fe200078e0264ULL, 0x0000001d580e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000464637824ULL, 0x000fe200078e00ffULL, 0x0000000310107812ULL, 0x000fc400078ec0ffULL,
0x0000001d5a577210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200008e06ffULL,
0x000000081c5d7812ULL, 0x000fe400078efcffULL, 0x0000004710477212ULL, 0x000fe200078efcffULL,
0x000000ffff667224ULL, 0x000fe200010e06ffULL, 0x00005e000e2a7a11ULL, 0x040fe200078248ffULL,
0x000000105d087825ULL, 0x000fe200078e0008ULL, 0x00005e0057587a11ULL, 0x000fe400078448ffULL,
0x00005f000e2b7a11ULL, 0x000fe200008f4c2bULL, 0x00000010470f7824ULL, 0x000fe200078e0219ULL,
0xfffffffc590e7812ULL, 0x000fe200078ee210ULL, 0x000000105d0a7825ULL, 0x000fe200078e000aULL,
0x00005f0057597a11ULL, 0x000fc400010f4c66ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x0003e2000b901c46ULL, 0x000000105d0c7825ULL, 0x000fe200078e000cULL,
0xfffffffc5b5a7812ULL, 0x000fc600078ee210ULL, 0x000000105d247825ULL, 0x000fc800078e0024ULL,
0x000000105d267825ULL, 0x000fc800078e0026ULL, 0x000000105d287825ULL, 0x000fc800078e0028ULL,
0x000000105d2a7825ULL, 0x000fc800078e002aULL, 0x000000105d587825ULL, 0x000fc800078e0058ULL,
0x000000045c097824ULL, 0x002fe200078e00ffULL, 0xfffffffc615c7812ULL, 0x100fe200078ee210ULL,
0x000000045e5d7824ULL, 0x000fe400078e00ffULL, 0x000000100e577824ULL, 0x100fe200078e0219ULL,
0xfffffffc09087812ULL, 0x100fe200078ee210ULL, 0x000000105a5b7824ULL, 0x100fe200078e0219ULL,
0xfffffffc5d0e7812ULL, 0x100fe400078ee210ULL, 0xfffffffc5f5a7812ULL, 0x000fe200078ee210ULL,
0x000000000a577faeULL, 0x0003e2000b901c46ULL, 0x0000001008097824ULL, 0x000fc600078e0219ULL,
0x000000000c5b7faeULL, 0x0005e8000b901c46ULL, 0x0000000024097faeULL, 0x0007e2000b901c46ULL,
0xfffffffc630a7812ULL, 0x002fe200078ee210ULL, 0x000000100e0b7824ULL, 0x100fe400078e0219ULL,
0x000000105c577824ULL, 0x100fe400078e0219ULL, 0x000000105a0d7824ULL, 0x104fe200078e0219ULL,
0x00000000260b7faeULL, 0x0007e2000b901c46ULL, 0x000000100a5b7824ULL, 0x000fc600078e0219ULL,
0x00000000280d7faeULL, 0x0007e8000b901c46ULL, 0x000000002a577faeULL, 0x0007e8000b901c46ULL,
0x00000000585b7faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201b097824ULL, 0x00afe200078e00ffULL, 0x000000041a087810ULL, 0x000fc40007ffe0ffULL,
0x00003000500e7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe009087812ULL, 0x000fc600078ee208ULL,
0x00000010510d7824ULL, 0x100fe400078e020eULL, 0x0000001008587824ULL, 0x000fe200078e00ffULL,
0x000000061a087810ULL, 0x000fe20007ffe0ffULL, 0x00000010530c7824ULL, 0x100fe400078e020eULL,
0x00000010520b7824ULL, 0x000fe200078e020eULL, 0xffffffe009087812ULL, 0x000fe200078ee208ULL,
0x00000010560a7824ULL, 0x100fe400078e020eULL, 0x0000001007097824ULL, 0x000fc400078e020eULL,
0x0000001008247824ULL, 0x000fe400078e00ffULL, 0x0000001054087824ULL, 0x000fe200078e020eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000d50783bULL, 0x000fe20000000200ULL,
0x0000001055077824ULL, 0x100fe400078e020eULL, 0x0000001002027824ULL, 0x000fe200078e020eULL,
0x000000005858783bULL, 0x000e680000000200ULL, 0x000000000c64783bULL, 0x000ea80000000200ULL,
0x000000000b60783bULL, 0x000ee80000000200ULL, 0x000000000a5c783bULL, 0x000f280000000200ULL,
0x00000000096c783bULL, 0x000fe80000000200ULL, 0x000000002424783bULL, 0x000ee80000000200ULL,
0x000000000868783bULL, 0x000ee80000000200ULL, 0x000000000754783bULL, 0x000f280000000200ULL,
0x000000000228783bULL, 0x000f220000000200ULL, 0x00000050582c723cULL, 0x042ff0000000182cULL,
0x000000525850723cULL, 0x040f700000001830ULL, 0x000000645834723cULL, 0x044f700000001834ULL,
0x00000060583c723cULL, 0x048f70000000183cULL, 0x000000665864723cULL, 0x040f700000001838ULL,
0x000000625860723cULL, 0x040f700000001840ULL, 0x0000005c5848723cULL, 0x050f700000001848ULL,
0x0000005e584c723cULL, 0x000f70000000184cULL, 0x0000006e2440723cULL, 0x060b700000001850ULL,
0x000000682438723cULL, 0x040b700000001834ULL, 0x00000054243c723cULL, 0x040b70000000183cULL,
0x0000006c2430723cULL, 0x040b70000000182cULL, 0x0000006a2468723cULL, 0x040b700000001864ULL,
0x000000562454723cULL, 0x040b700000001860ULL, 0x000000282448723cULL, 0x040b700000001848ULL,
0x0000002a2450723cULL, 0x000b62000000184cULL, 0x0000064000008947ULL, 0x000fce0003800000ULL,
0x00000002ff247819ULL, 0x020fc80000011622ULL, 0x0000001824587810ULL, 0x040fe20007ffe0ffULL,
0x0000000105267824ULL, 0x040fe200078e0224ULL, 0x00000008244c7810ULL, 0x040fe40007ffe0ffULL,
0x00000010244f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001052c7824ULL, 0x000fe200078e0258ULL,
0x000000261d257210ULL, 0x000fe20007f5e0ffULL, 0x0000000105287824ULL, 0x040fe200078e024cULL,
0x0000002024597810ULL, 0x000fe20007ffe0ffULL, 0x00000001052a7824ULL, 0x000fe200078e024fULL,
0x0000002c1d2d7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x000000281d297210ULL, 0x000fe20007f7e0ffULL, 0x000000044c5f7824ULL, 0x000fe200078e00ffULL,
0x00005e0025267a11ULL, 0x000fe200078448ffULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078248ffULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x00005f0025277a11ULL, 0x000fe200010f4c2eULL, 0x00000001052e7824ULL, 0x000fe200078e0259ULL,
0x00005e0029287a11ULL, 0x000fc400078648ffULL, 0x00000028245a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f002d2d7a11ULL, 0x000fe200008f4c4eULL, 0x00000001444e7824ULL, 0x000fe200078e0a1fULL,
0x00005f0029297a11ULL, 0x000fe200018f4c34ULL, 0x0000000105347824ULL, 0x000fe200078e025aULL,
0x0000002a1d2b7210ULL, 0x040fe40007f9e0ffULL, 0x0000002e1d257210ULL, 0x000fe40007f5e0ffULL,
0x00000030245b7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0x0000004e2400720cULL, 0x000fc40003f26070ULL, 0x00000038245d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x000000341d357210ULL, 0x000fe40007f7e0ffULL,
0x00005e002b2a7a11ULL, 0x000fe400078848ffULL, 0x00005e00252e7a11ULL, 0x000fe200078448ffULL,
0x000000ffff5c7224ULL, 0x000fe200018e06ffULL, 0x00005f002b2b7a11ULL, 0x000fe200020f4c36ULL,
0x0000000105367824ULL, 0x000fe200078e025bULL, 0x00005f00252f7a11ULL, 0x000fe200010f4c24ULL,
0x0000000105247824ULL, 0x000fe200078e025dULL, 0x00005e0035347a11ULL, 0x000fc400078648ffULL,
0x0000000c1c257812ULL, 0x000fe400078efcffULL, 0x00005f0035357a11ULL, 0x000fe400018f4c5cULL,
0x000000361d377210ULL, 0x000fe20007f9e0ffULL, 0x0000001025267825ULL, 0x000fe200078e0026ULL,
0x0000004e4c00720cULL, 0x000fe40003f46070ULL, 0x000000241d4d7210ULL, 0x000fe20007f7e0ffULL,
0x0000001047247824ULL, 0x000fe200078e020eULL, 0xfffffffc5f477812ULL, 0x000fe200078ee210ULL,
0x000000ffff5e7224ULL, 0x000fe200020e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078848ffULL,
0x000000ffff5c7224ULL, 0x000fe200018e06ffULL, 0x00005e004d4c7a11ULL, 0x000fe200078648ffULL,
0x0000001047477824ULL, 0x000fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026247faeULL, 0x0003e2000c901c46ULL, 0x0000001025287825ULL, 0x000fe200078e0028ULL,
0x00005f0037377a11ULL, 0x000fc400020f4c5eULL, 0x00005f004d4d7a11ULL, 0x000fe400018f4c5cULL,
0x0000004e4f00720cULL, 0x0c0fe20003f26070ULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0x0000000028477faeULL, 0x0005e2000d101c46ULL, 0x0000004e5800720cULL, 0x080fe40003f46070ULL,
0x0000004e5900720cULL, 0x080fe20003f66070ULL, 0x0000001025267825ULL, 0x002fe200078e002aULL,
0xfffffffc4f4f7812ULL, 0x000fe400078ee210ULL, 0x0000004e5a00720cULL, 0x080fe20003f86070ULL,
0x00000010252a7825ULL, 0x000fe200078e002cULL, 0x0000004e5b00720cULL, 0x000fc40003fa6070ULL,
0x0000004e5d00720cULL, 0x000fe20003fc6070ULL, 0x00000010252c7825ULL, 0x000fc800078e002eULL,
0x0000001025287825ULL, 0x004fc800078e0034ULL, 0x00000010252e7825ULL, 0x000fc800078e0036ULL,
0x0000001025347825ULL, 0x000fc800078e004cULL, 0x0000000458257824ULL, 0x000fe400078e00ffULL,
0x0000000459377824ULL, 0x000fe400078e00ffULL, 0x000000045a477824ULL, 0x000fe200078e00ffULL,
0xfffffffc25257812ULL, 0x100fe200078ee210ULL, 0x000000045b4d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc37377812ULL, 0x100fe200078ee210ULL, 0x000000045d597824ULL, 0x000fe200078e00ffULL,
0xfffffffc47477812ULL, 0x000fe200078ee210ULL, 0x000000104f4f7824ULL, 0x000fe200078e020eULL,
0xfffffffc4d4d7812ULL, 0x000fe200078ee210ULL, 0x0000001025257824ULL, 0x000fe200078e020eULL,
0xfffffffc59597812ULL, 0x000fc400078ee210ULL, 0x00000000264f7faeULL, 0x0003e8000c901c46ULL,
0x000000002a257faeULL, 0x0005e2000d101c46ULL, 0x0000001037277824ULL, 0x102fe400078e020eULL,
0x0000001047377824ULL, 0x100fe400078e020eULL, 0x000000104d477824ULL, 0x100fe200078e020eULL,
0x000000002c277faeULL, 0x0005e2000d901c46ULL, 0x00000010594d7824ULL, 0x000fc600078e020eULL,
0x0000000028377faeULL, 0x0005e8000e101c46ULL, 0x000000002e477faeULL, 0x0005e8000e901c46ULL,
0x00000000344d7faeULL, 0x0005e2000f101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000822367811ULL, 0x060fe400078ff0ffULL, 0x0000000522247211ULL, 0x000fc400078ff0ffULL,
0x00000010224c7811ULL, 0x000fe200078ff0ffULL, 0x0000000105267824ULL, 0x000fe200078e0236ULL,
0x0000001d24247210ULL, 0x080fe40007f3e0ffULL, 0x00000018224e7811ULL, 0x000fe200078ff0ffULL,
0x000000044c597824ULL, 0x000fe200078e00ffULL, 0x0000001d26297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005e0024267a11ULL, 0x000fe400078248ffULL,
0x00000028225a7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005e0029287a11ULL, 0x000fc400078448ffULL, 0x00005f0024277a11ULL, 0x000fe200008f4c25ULL,
0x0000000105247824ULL, 0x000fe200078e024cULL, 0x00005f0029297a11ULL, 0x000fe200010f4c2aULL,
0x00000001052a7824ULL, 0x040fe200078e024eULL, 0x0000002022587811ULL, 0x000fe200078ff0ffULL,
0x00000001055c7824ULL, 0x040fe200078e025aULL, 0x0000001d24247210ULL, 0x080fe40007f3e0ffULL,
0x0000001d2a2d7210ULL, 0x080fe20007f5e0ffULL, 0x0000000105347824ULL, 0x000fe200078e0258ULL,
0x0000001d5c5c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0x00005e00242a7a11ULL, 0x000fe200078248ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x00005e002d2c7a11ULL, 0x000fc400078448ffULL, 0x00005f00242b7a11ULL, 0x000fe200008f4c25ULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x0000001d342f7210ULL, 0x000fe40007f7e0ffULL,
0x00005f002d2d7a11ULL, 0x000fe400010f4c2eULL, 0x00005e005c347a11ULL, 0x000fe200078448ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x00000030225e7811ULL, 0x040fe400078ff0ffULL,
0x0000003822607811ULL, 0x000fc400078ff0ffULL, 0x00005f005c357a11ULL, 0x000fe200010f4c25ULL,
0x00000001055c7824ULL, 0x000fe200078e025eULL, 0x00005e002f2e7a11ULL, 0x000fe200078248ffULL,
0x0000000105627824ULL, 0x000fe200078e0260ULL, 0x0000000c1c4f7812ULL, 0x000fe200078efcffULL,
0x000000045e5b7824ULL, 0x000fe200078e00ffULL, 0x00005f002f2f7a11ULL, 0x000fe200008f4c24ULL,
0x0000001047247824ULL, 0x000fe200078e020eULL, 0x0000001d5c5c7210ULL, 0x080fe20007f3e0ffULL,
0x0000000436477824ULL, 0x000fe200078e00ffULL, 0x0000001d62627210ULL, 0x000fe20007f5e0ffULL,
0x000000104f267825ULL, 0x000fe200078e0026ULL, 0xfffffffc5b5b7812ULL, 0x000fc600078ee210ULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005e005c367a11ULL, 0x000fe200078248ffULL,
0x000000ffff4d7224ULL, 0x000fe200010e06ffULL, 0x00005e00624c7a11ULL, 0x000fe200078448ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026247faeULL, 0x0003e2000b901c46ULL,
0x00005f005c377a11ULL, 0x000fe200008f4c25ULL, 0x000000104f287825ULL, 0x000fe200078e0028ULL,
0x00005f00624d7a11ULL, 0x000fe400010f4c4dULL, 0xfffffffc47257812ULL, 0x000fe200078ee210ULL,
0x000000104f2a7825ULL, 0x000fe200078e002aULL, 0xfffffffc59477812ULL, 0x000fc600078ee210ULL,
0x000000104f2c7825ULL, 0x000fc800078e002cULL, 0x000000104f2e7825ULL, 0x000fc800078e002eULL,
0x000000104f347825ULL, 0x000fc800078e0034ULL, 0x000000104f367825ULL, 0x000fc800078e0036ULL,
0x000000104f4c7825ULL, 0x000fc800078e004cULL, 0x000000044e277824ULL, 0x002fe400078e00ffULL,
0x00000004584f7824ULL, 0x000fe400078e00ffULL, 0x000000045a597824ULL, 0x000fe200078e00ffULL,
0xfffffffc27277812ULL, 0x000fe200078ee210ULL, 0x0000001025257824ULL, 0x000fe200078e020eULL,
0xfffffffc4f4f7812ULL, 0x100fe200078ee210ULL, 0x00000004605d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc59597812ULL, 0x000fe200078ee210ULL, 0x0000001047477824ULL, 0x000fe200078e020eULL,
0x0000000028257faeULL, 0x0003e4000b901c46ULL, 0xfffffffc5d5d7812ULL, 0x000fc400078ee210ULL,
0x000000002a477faeULL, 0x0005e2000b901c46ULL, 0x0000001027257824ULL, 0x102fe400078e020eULL,
0x000000104f277824ULL, 0x100fe400078e020eULL, 0x0000001059297824ULL, 0x100fe200078e020eULL,
0x000000002c257faeULL, 0x0003e2000b901c46ULL, 0x000000105b2b7824ULL, 0x104fe400078e020eULL,
0x000000105d477824ULL, 0x000fe200078e020eULL, 0x000000002e277faeULL, 0x0003e8000b901c46ULL,
0x0000000034297faeULL, 0x0003e8000b901c46ULL, 0x00000000362b7faeULL, 0x0003e8000b901c46ULL,
0x000000004c477faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201b267824ULL, 0x040fe200078e00ffULL, 0x000000081a257810ULL, 0x006fe20007ffe0ffULL,
0x000000201b277824ULL, 0x000fc600078e00ffULL, 0xffffffe026257812ULL, 0x000fe400078ee225ULL,
0x0000000a1a267810ULL, 0x000fc60007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0xffffffe027267812ULL, 0x000fca00078ee226ULL, 0x0000001026267824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001864783bULL, 0x000fe80000000200ULL,
0x00000000255c783bULL, 0x000e680000000200ULL, 0x000000001770783bULL, 0x000ea80000000200ULL,
0x00000000166c783bULL, 0x000ee80000000200ULL, 0x000000001560783bULL, 0x000f280000000200ULL,
0x000000001458783bULL, 0x000fe80000000200ULL, 0x000000002628783bULL, 0x000ee80000000200ULL,
0x000000001234783bULL, 0x000ee80000000200ULL, 0x00000000134c783bULL, 0x000ee80000000200ULL,
0x00000000112c783bULL, 0x000ee20000000200ULL, 0x000000645c30723cULL, 0x042ff00000001830ULL,
0x000000665c40723cULL, 0x040f700000001840ULL, 0x000000705c64723cULL, 0x044ff00000001838ULL,
0x000000725c68723cULL, 0x040ff00000001868ULL, 0x0000006c5c70723cULL, 0x048f70000000183cULL,
0x0000006e5c54723cULL, 0x040f700000001854ULL, 0x000000605c6c723cULL, 0x050f700000001848ULL,
0x000000625c50723cULL, 0x000f700000001850ULL, 0x0000005a2848723cULL, 0x060b700000001840ULL,
0x000000342840723cULL, 0x040b700000001870ULL, 0x000000582838723cULL, 0x040b700000001830ULL,
0x0000004c283c723cULL, 0x040b700000001864ULL, 0x000000362834723cULL, 0x040b700000001854ULL,
0x0000004e284c723cULL, 0x040b700000001868ULL, 0x0000002c2854723cULL, 0x040b70000000186cULL,
0x0000002e2858723cULL, 0x000b620000001850ULL, 0x0000063000008947ULL, 0x000fce0003800000ULL,
0x00000002ff327819ULL, 0x020fe20000011622ULL, 0x0000000144477824ULL, 0x000fc600078e0a1fULL,
0x0000000832507810ULL, 0x040fe20007ffe0ffULL, 0x0000000105267824ULL, 0x040fe200078e0232ULL,
0x00000010325c7810ULL, 0x040fe40007ffe0ffULL, 0x00000018325e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105287824ULL, 0x000fe200078e0250ULL, 0x000000261d257210ULL, 0x000fe20007f3e0ffULL,
0x00000001052e7824ULL, 0x040fe200078e025cULL, 0x0000002032607810ULL, 0x000fe20007ffe0ffULL,
0x0000000105307824ULL, 0x000fe200078e025eULL, 0x000000281d297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0025267a11ULL, 0x000fe200078248ffULL,
0x0000000450537824ULL, 0x000fe200078e00ffULL, 0x0000002e1d2e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x000000301d307210ULL, 0x000fe20007f9e0ffULL,
0x000000045c5d7824ULL, 0x000fe200078e00ffULL, 0x00005e0029287a11ULL, 0x000fc400078448ffULL,
0x00005f0025277a11ULL, 0x000fe200008f4c2aULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x00005f0029297a11ULL, 0x000fe200010f4c2cULL, 0x000000ffff2d7224ULL, 0x000fe200020e06ffULL,
0x00005e002e2a7a11ULL, 0x000fe400078248ffULL, 0x00005e00302c7a11ULL, 0x000fe400078448ffULL,
0x0000002832627810ULL, 0x000fe40007ffe0ffULL, 0x00005f002e2b7a11ULL, 0x000fe200008f4c25ULL,
0x00000001052e7824ULL, 0x040fe200078e0260ULL, 0x00005f00302d7a11ULL, 0x000fe200010f4c2dULL,
0x0000000105307824ULL, 0x000fe200078e0262ULL, 0x0000003032667810ULL, 0x000fc40007ffe0ffULL,
0x0000002e1d257210ULL, 0x040fe40007f5e0ffULL, 0x000000301d317210ULL, 0x000fe20007f7e0ffULL,
0x0000000105687824ULL, 0x000fe200078e0266ULL, 0x00000038326a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x000fe200010e06ffULL, 0x00005e00252e7a11ULL, 0x000fe200078448ffULL,
0x000000ffff647224ULL, 0x000fe200018e06ffULL, 0x000000681d687210ULL, 0x000fe40007f9e0ffULL,
0x00005e0031307a11ULL, 0x000fc400078648ffULL, 0x00005f00252f7a11ULL, 0x000fe200010f4c52ULL,
0x0000000105527824ULL, 0x000fe200078e026aULL, 0x000000473200720cULL, 0x080fe20003f26070ULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x00005f0031317a11ULL, 0x000fe400018f4c64ULL,
0x00005e0068327a11ULL, 0x000fe400078648ffULL, 0x000000475000720cULL, 0x000fe40003f46070ULL,
0x000000521d517210ULL, 0x000fc40007f9e0ffULL, 0x00005f0068337a11ULL, 0x000fe400018f4c25ULL,
0x000000101c257812ULL, 0x000fe200078efcffULL, 0x000000ffff647224ULL, 0x000fe200020e06ffULL,
0xfffffffc53527812ULL, 0x000fe400078ee210ULL, 0x00005e0051507a11ULL, 0x000fe200078648ffULL,
0x0000001025267825ULL, 0x000fe200078e0026ULL, 0x000000476200720cULL, 0x080fe40003f86070ULL,
0x00005f0051517a11ULL, 0x000fe200018f4c64ULL, 0x0000001052537824ULL, 0x000fe200078e0219ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000260f7faeULL, 0x0003e2000c901c46ULL,
0x0000001025287825ULL, 0x000fe200078e0028ULL, 0x000000475c00720cULL, 0x000fc40003f26070ULL,
0xfffffffc5d527812ULL, 0x000fe200078ee210ULL, 0x000000046a5d7824ULL, 0x000fe200078e00ffULL,
0x0000000028537faeULL, 0x0005e2000d101c46ULL, 0x000000475e00720cULL, 0x080fe40003f46070ULL,
0x000000476000720cULL, 0x080fe40003f66070ULL, 0x000000476600720cULL, 0x080fe20003fa6070ULL,
0x0000001025267825ULL, 0x002fe200078e002aULL, 0x000000476a00720cULL, 0x000fc60003fc6070ULL,
0x00000010252a7825ULL, 0x000fc800078e002cULL, 0x00000010252c7825ULL, 0x000fc800078e002eULL,
0x0000001025287825ULL, 0x004fc800078e0030ULL, 0x00000010252e7825ULL, 0x000fc800078e0032ULL,
0x0000001025307825ULL, 0x000fc800078e0050ULL, 0x000000045e257824ULL, 0x000fe200078e00ffULL,
0xfffffffc5d5e7812ULL, 0x100fe200078ee210ULL, 0x0000000460337824ULL, 0x000fe400078e00ffULL,
0x0000000462517824ULL, 0x000fe200078e00ffULL, 0xfffffffc25327812ULL, 0x100fe200078ee210ULL,
0x0000000466537824ULL, 0x000fe200078e00ffULL, 0xfffffffc33507812ULL, 0x100fe200078ee210ULL,
0x0000001052477824ULL, 0x100fe200078e0219ULL, 0xfffffffc51527812ULL, 0x100fe200078ee210ULL,
0x0000001032257824ULL, 0x100fe200078e0219ULL, 0xfffffffc535c7812ULL, 0x000fe200078ee210ULL,
0x000000105e517824ULL, 0x100fe200078e0219ULL, 0x0000000026477faeULL, 0x0003e2000c901c46ULL,
0x0000001052337824ULL, 0x000fc600078e0219ULL, 0x000000002a257faeULL, 0x0005e2000d101c46ULL,
0x0000001050277824ULL, 0x102fe400078e0219ULL, 0x000000105c477824ULL, 0x000fc600078e0219ULL,
0x000000002c277faeULL, 0x0005e8000d901c46ULL, 0x0000000028337faeULL, 0x0005e8000e101c46ULL,
0x000000002e477faeULL, 0x0005e8000e901c46ULL, 0x0000000030517faeULL, 0x0005e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000822327811ULL, 0x060fe400078ff0ffULL,
0x0000000522267211ULL, 0x000fc400078ff0ffULL, 0x0000001022507811ULL, 0x000fe200078ff0ffULL,
0x0000000105287824ULL, 0x000fe200078e0232ULL, 0x0000001d26257210ULL, 0x080fe20007f3e0ffULL,
0x0000000432517824ULL, 0x000fe200078e00ffULL, 0x00000018225e7811ULL, 0x000fe200078ff0ffULL,
0x0000000450537824ULL, 0x000fe200078e00ffULL, 0x0000001d28297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0025267a11ULL, 0x000fe400078248ffULL,
0x0000002022607811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e0029287a11ULL, 0x000fc400078448ffULL, 0x00005f0025277a11ULL, 0x000fe200008f4c2aULL,
0x00000001052a7824ULL, 0x000fe200078e0250ULL, 0x00005f0029297a11ULL, 0x000fe200010f4c2cULL,
0x00000001052c7824ULL, 0x040fe200078e025eULL, 0x0000002822627811ULL, 0x000fe200078ff0ffULL,
0x0000000105527824ULL, 0x040fe200078e0260ULL, 0x0000001d2a257210ULL, 0x080fe40007f3e0ffULL,
0x0000001d2c2d7210ULL, 0x080fe20007f5e0ffULL, 0x00000001055c7824ULL, 0x000fe200078e0262ULL,
0x0000003022647811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e00252a7a11ULL, 0x000fe200078248ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078448ffULL, 0x00000004625d7824ULL, 0x000fe200078e00ffULL,
0x00005f00252b7a11ULL, 0x000fe200008f4c2eULL, 0x00000004645f7824ULL, 0x000fe200078e00ffULL,
0x0000001d52527210ULL, 0x000fc40007f3e0ffULL, 0x00005f002d2d7a11ULL, 0x000fe400010f4c30ULL,
0x0000001d5c5c7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0x00005e00522e7a11ULL, 0x000fe400078248ffULL, 0x0000003822667811ULL, 0x000fe200078ff0ffULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x00005e005c307a11ULL, 0x000fe400078448ffULL,
0x00005f00522f7a11ULL, 0x000fe200008f4c25ULL, 0x0000000105527824ULL, 0x040fe200078e0264ULL,
0x00005f005c317a11ULL, 0x000fe200010f4c31ULL, 0x00000001055c7824ULL, 0x000fe200078e0266ULL,
0x000000101c257812ULL, 0x000fe200078efcffULL, 0x0000000466617824ULL, 0x000fe200078e00ffULL,
0x0000001d52527210ULL, 0x000fc40007f3e0ffULL, 0x0000001d5c477210ULL, 0x000fe20007f5e0ffULL,
0x0000001025267825ULL, 0x000fe200078e0026ULL, 0xfffffffc535c7812ULL, 0x000fc600078ee210ULL,
0x000000ffff337224ULL, 0x000fe200008e06ffULL, 0x00005e0052327a11ULL, 0x040fe200078248ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x00005e0047507a11ULL, 0x000fe200078448ffULL,
0x0000001025287825ULL, 0x000fe200078e0028ULL, 0x00005f0052337a11ULL, 0x000fe200008f4c33ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000260f7faeULL, 0x0003e2000b901c46ULL,
0xfffffffc51527812ULL, 0x000fe200078ee210ULL, 0x00000010252a7825ULL, 0x000fe200078e002aULL,
0x00005f0047517a11ULL, 0x000fc600010f4c68ULL, 0x00000010252c7825ULL, 0x000fc800078e002cULL,
0x00000010252e7825ULL, 0x000fc800078e002eULL, 0x0000001025307825ULL, 0x000fc800078e0030ULL,
0x0000001025327825ULL, 0x000fc800078e0032ULL, 0x0000001025507825ULL, 0x000fc800078e0050ULL,
0x000000045e257824ULL, 0x000fe200078e00ffULL, 0xfffffffc5f5e7812ULL, 0x100fe200078ee210ULL,
0x0000000460277824ULL, 0x002fe400078e00ffULL, 0x0000001052477824ULL, 0x100fe200078e0219ULL,
0xfffffffc25267812ULL, 0x100fe200078ee210ULL, 0x000000105c537824ULL, 0x100fe200078e0219ULL,
0xfffffffc27527812ULL, 0x100fe400078ee210ULL, 0xfffffffc5d5c7812ULL, 0x000fe200078ee210ULL,
0x0000000028477faeULL, 0x0003e2000b901c46ULL, 0x0000001026257824ULL, 0x000fc400078e0219ULL,
0x0000001052277824ULL, 0x100fe200078e0219ULL, 0x000000002a537faeULL, 0x0005e8000b901c46ULL,
0x000000002c257faeULL, 0x0007e2000b901c46ULL, 0xfffffffc61287812ULL, 0x002fe200078ee210ULL,
0x000000105c297824ULL, 0x100fe400078e0219ULL, 0x000000002e277faeULL, 0x0007e2000b901c46ULL,
0x000000105e2b7824ULL, 0x004fc400078e0219ULL, 0x0000001028477824ULL, 0x000fe200078e0219ULL,
0x0000000030297faeULL, 0x0007e8000b901c46ULL, 0x00000000322b7faeULL, 0x0007e8000b901c46ULL,
0x0000000050477faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201b267824ULL, 0x040fe200078e00ffULL, 0x0000000c1a257810ULL, 0x00cfe20007ffe0ffULL,
0x000000201b277824ULL, 0x000fc600078e00ffULL, 0xffffffe026257812ULL, 0x000fe400078ee225ULL,
0x0000000e1a267810ULL, 0x000fc60007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0xffffffe027267812ULL, 0x000fca00078ee226ULL, 0x0000001026267824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000d70783bULL, 0x000fe80000000200ULL,
0x000000002560783bULL, 0x000e680000000200ULL, 0x000000000c6c783bULL, 0x000ea80000000200ULL,
0x000000000b68783bULL, 0x000ee80000000200ULL, 0x000000000a64783bULL, 0x000f280000000200ULL,
0x00000000095c783bULL, 0x000fe80000000200ULL, 0x000000002628783bULL, 0x000ee80000000200ULL,
0x000000000850783bULL, 0x000ee80000000200ULL, 0x000000000730783bULL, 0x000f280000000200ULL,
0x00000000022c783bULL, 0x000f220000000200ULL, 0x000000706038723cULL, 0x042f700000001838ULL,
0x0000006c603c723cULL, 0x044f70000000183cULL, 0x0000006e604c723cULL, 0x040f70000000184cULL,
0x00000068606c723cULL, 0x048ff00000001840ULL, 0x000000726048723cULL, 0x040f700000001848ULL,
0x0000006a6068723cULL, 0x040f700000001834ULL, 0x000000646054723cULL, 0x050f700000001854ULL,
0x000000666058723cULL, 0x000f700000001858ULL, 0x0000005c2834723cULL, 0x060b700000001838ULL,
0x000000502838723cULL, 0x040b70000000183cULL, 0x000000522850723cULL, 0x040b70000000184cULL,
0x0000005e2840723cULL, 0x040b700000001848ULL, 0x00000030283c723cULL, 0x040b70000000186cULL,
0x00000032284c723cULL, 0x040b700000001868ULL, 0x0000002c2854723cULL, 0x040b700000001854ULL,
0x0000002e2858723cULL, 0x000b620000001858ULL, 0x0000063000008947ULL, 0x000fce0003800000ULL,
0x00000002ff327819ULL, 0x020fe20000011622ULL, 0x0000000144477824ULL, 0x000fc600078e0a1fULL,
0x0000000832487810ULL, 0x040fe20007ffe0ffULL, 0x0000000105267824ULL, 0x040fe200078e0232ULL,
0x00000010324a7810ULL, 0x040fe40007ffe0ffULL, 0x00000018325c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105287824ULL, 0x000fe200078e0248ULL, 0x000000261d257210ULL, 0x000fe20007f3e0ffULL,
0x00000001052e7824ULL, 0x040fe200078e024aULL, 0x00000020325e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105307824ULL, 0x000fe200078e025cULL, 0x000000281d297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0025267a11ULL, 0x000fe200078248ffULL,
0x0000000448497824ULL, 0x000fe200078e00ffULL, 0x0000002e1d2e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x000000301d307210ULL, 0x000fc40007f9e0ffULL,
0x00005e0029287a11ULL, 0x000fe400078448ffULL, 0x00005f0025277a11ULL, 0x000fe200008f4c2aULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x00005f0029297a11ULL, 0x000fe200010f4c2cULL,
0x000000ffff2d7224ULL, 0x000fe200020e06ffULL, 0x00005e002e2a7a11ULL, 0x000fe400078248ffULL,
0x00005e00302c7a11ULL, 0x000fe400078448ffULL, 0x0000002832627810ULL, 0x000fc40007ffe0ffULL,
0x00005f002e2b7a11ULL, 0x000fe200008f4c25ULL, 0x00000001052e7824ULL, 0x040fe200078e025eULL,
0x00005f00302d7a11ULL, 0x000fe200010f4c2dULL, 0x0000000105307824ULL, 0x000fe200078e0262ULL,
0x0000003032667810ULL, 0x040fe40007ffe0ffULL, 0x0000002e1d257210ULL, 0x040fe40007f5e0ffULL,
0x000000301d317210ULL, 0x000fe20007f7e0ffULL, 0x0000000105687824ULL, 0x000fe200078e0266ULL,
0x00000038326a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff607224ULL, 0x000fe200010e06ffULL,
0x00005e00252e7a11ULL, 0x000fe200078448ffULL, 0x000000ffff647224ULL, 0x000fe200018e06ffULL,
0x000000681d687210ULL, 0x000fc40007f9e0ffULL, 0x00005e0031307a11ULL, 0x000fe400078648ffULL,
0x00005f00252f7a11ULL, 0x000fe200010f4c60ULL, 0x0000000105607824ULL, 0x000fe200078e026aULL,
0x000000473200720cULL, 0x080fe20003f26070ULL, 0x000000ffff257224ULL, 0x000fe200020e06ffULL,
0x00005f0031317a11ULL, 0x000fe400018f4c64ULL, 0x00005e0068327a11ULL, 0x000fe400078648ffULL,
0x000000474800720cULL, 0x000fc40003f46070ULL, 0x000000601d607210ULL, 0x000fe40007f9e0ffULL,
0x00005f0068337a11ULL, 0x000fe400018f4c25ULL, 0x000000141c257812ULL, 0x000fe200078efcffULL,
0x000000ffff5d7224ULL, 0x000fe200020e06ffULL, 0xfffffffc49497812ULL, 0x000fe400078ee210ULL,
0x00005e0060487a11ULL, 0x000fe200078648ffULL, 0x0000001025267825ULL, 0x000fe200078e0026ULL,
0x000000476200720cULL, 0x000fc40003f86070ULL, 0x000000476600720cULL, 0x080fe20003fa6070ULL,
0x00000010494b7824ULL, 0x000fe200078e020eULL, 0x00005f0060497a11ULL, 0x000fe200018f4c5dULL,
0x0000001025287825ULL, 0x000fe200078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026247faeULL, 0x0003e2000c901c46ULL, 0x000000474a00720cULL, 0x0c0fe40003f26070ULL,
0x000000044a5d7824ULL, 0x000fe200078e00ffULL, 0x00000000284b7faeULL, 0x0005e2000d101c46ULL,
0x000000475c00720cULL, 0x080fe40003f46070ULL, 0x000000475e00720cULL, 0x000fc40003f66070ULL,
0x000000476a00720cULL, 0x000fe20003fc6070ULL, 0x0000000462477824ULL, 0x000fe200078e00ffULL,
0xfffffffc5d5d7812ULL, 0x000fe200078ee210ULL, 0x0000001025267825ULL, 0x002fc600078e002aULL,
0xfffffffc47477812ULL, 0x000fe200078ee210ULL, 0x00000010252a7825ULL, 0x000fc800078e002cULL,
0x00000010252c7825ULL, 0x000fc800078e002eULL, 0x0000001025287825ULL, 0x004fc800078e0030ULL,
0x00000010252e7825ULL, 0x000fc800078e0032ULL, 0x0000001025307825ULL, 0x000fc800078e0048ULL,
0x000000045c257824ULL, 0x000fe400078e00ffULL, 0x000000045e337824ULL, 0x000fe400078e00ffULL,
0x0000000466497824ULL, 0x000fe200078e00ffULL, 0xfffffffc25257812ULL, 0x100fe200078ee210ULL,
0x000000046a4b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc33337812ULL, 0x000fe200078ee210ULL,
0x000000105d5d7824ULL, 0x000fe200078e020eULL, 0xfffffffc49497812ULL, 0x000fe200078ee210ULL,
0x0000001025257824ULL, 0x000fe200078e020eULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee210ULL,
0x0000001033337824ULL, 0x100fe200078e020eULL, 0x00000000265d7faeULL, 0x0003e2000c901c46ULL,
0x0000001047477824ULL, 0x000fc400078e020eULL, 0x0000001049497824ULL, 0x100fe200078e020eULL,
0x000000002a257faeULL, 0x0003e2000d101c46ULL, 0x000000104b4b7824ULL, 0x000fc600078e020eULL,
0x000000002c337faeULL, 0x0003e8000d901c46ULL, 0x0000000028477faeULL, 0x0003e8000e101c46ULL,
0x000000002e497faeULL, 0x0003e8000e901c46ULL, 0x00000000304b7faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000822327811ULL, 0x060fe400078ff0ffULL,
0x0000000522267211ULL, 0x000fc400078ff0ffULL, 0x0000001022487811ULL, 0x000fe200078ff0ffULL,
0x0000000105287824ULL, 0x000fe200078e0232ULL, 0x0000001d26257210ULL, 0x080fe20007f3e0ffULL,
0x0000000432477824ULL, 0x000fe200078e00ffULL, 0x00000018224a7811ULL, 0x000fe200078ff0ffULL,
0x00000004484b7824ULL, 0x000fe200078e00ffULL, 0x0000001d28297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0025267a11ULL, 0x000fe400078248ffULL,
0x00000020225c7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e0029287a11ULL, 0x000fc400078448ffULL, 0x00005f0025277a11ULL, 0x000fe200008f4c2aULL,
0x00000001052a7824ULL, 0x000fe200078e0248ULL, 0x00005f0029297a11ULL, 0x000fe200010f4c2cULL,
0x00000001052c7824ULL, 0x040fe200078e024aULL, 0x0000002822607811ULL, 0x000fe200078ff0ffULL,
0x00000001055e7824ULL, 0x040fe200078e025cULL, 0x0000001d2a257210ULL, 0x080fe40007f3e0ffULL,
0x0000001d2c2d7210ULL, 0x000fe20007f5e0ffULL, 0x0000000105627824ULL, 0x000fe200078e0260ULL,
0x0000003022647811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e00252a7a11ULL, 0x000fe200078248ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078448ffULL, 0x00000004605d7824ULL, 0x000fe200078e00ffULL,
0x00005f00252b7a11ULL, 0x000fe200008f4c2eULL, 0x00000004645f7824ULL, 0x000fe200078e00ffULL,
0x00005f002d2d7a11ULL, 0x000fc400010f4c30ULL, 0x0000001d5e5e7210ULL, 0x080fe40007f3e0ffULL,
0x0000001d62627210ULL, 0x000fe40007f5e0ffULL, 0x0000003822667811ULL, 0x000fe200078ff0ffULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005e005e2e7a11ULL, 0x000fe200078248ffULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x00005e0062307a11ULL, 0x000fe200078448ffULL,
0x0000000466617824ULL, 0x000fe200078e00ffULL, 0x00005f005e2f7a11ULL, 0x000fe200008f4c25ULL,
0x00000001055e7824ULL, 0x040fe200078e0264ULL, 0x00005f0062317a11ULL, 0x000fe200010f4c31ULL,
0x0000000105627824ULL, 0x000fe200078e0266ULL, 0x000000141c257812ULL, 0x000fc400078efcffULL,
0x0000001d5e5e7210ULL, 0x080fe40007f3e0ffULL, 0x0000001d62627210ULL, 0x000fe20007f5e0ffULL,
0x0000001025267825ULL, 0x000fe200078e0026ULL, 0xfffffffc47477812ULL, 0x100fe400078ee210ULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee210ULL, 0x000000ffff337224ULL, 0x000fe200008e06ffULL,
0x00005e005e327a11ULL, 0x000fe200078248ffULL, 0x000000ffff497224ULL, 0x000fe200010e06ffULL,
0x00005e0062487a11ULL, 0x000fe200078448ffULL, 0x0000001025287825ULL, 0x040fe200078e0028ULL,
0x00005f005e337a11ULL, 0x000fe200008f4c33ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026247faeULL, 0x0003e2000b901c46ULL, 0x00005f0062497a11ULL, 0x000fe200010f4c49ULL,
0x00000010252a7825ULL, 0x000fe200078e002aULL, 0xfffffffc5d5d7812ULL, 0x000fc400078ee210ULL,
0xfffffffc5f5f7812ULL, 0x000fe200078ee210ULL, 0x00000010252c7825ULL, 0x000fc800078e002cULL,
0x00000010252e7825ULL, 0x000fc800078e002eULL, 0x0000001025307825ULL, 0x000fc800078e0030ULL,
0x0000001025327825ULL, 0x000fc800078e0032ULL, 0x0000001025487825ULL, 0x000fc800078e0048ULL,
0x000000044a257824ULL, 0x000fe400078e00ffULL, 0x000000045c277824ULL, 0x002fe400078e00ffULL,
0x0000001047477824ULL, 0x000fe200078e020eULL, 0xfffffffc25257812ULL, 0x000fe200078ee210ULL,
0x000000104b4b7824ULL, 0x000fe200078e020eULL, 0xfffffffc27277812ULL, 0x000fe200078ee210ULL,
0x000000105d5d7824ULL, 0x100fe200078e020eULL, 0x0000000028477faeULL, 0x0003e2000b901c46ULL,
0x0000001025257824ULL, 0x000fc400078e020eULL, 0x0000001027277824ULL, 0x100fe200078e020eULL,
0x000000002a4b7faeULL, 0x0005e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fc600078e020eULL,
0x000000002c257faeULL, 0x0005e2000b901c46ULL, 0xfffffffc61297812ULL, 0x002fc600078ee210ULL,
0x000000002e277faeULL, 0x0005e4000b901c46ULL, 0x0000001029297824ULL, 0x000fe400078e020eULL,
0x00000000305d7faeULL, 0x0005e8000b901c46ULL, 0x00000000325f7faeULL, 0x0005e8000b901c46ULL,
0x0000000048297faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201b267824ULL, 0x042fe200078e00ffULL, 0x000000101a257810ULL, 0x004fe20007ffe0ffULL,
0x000000201b277824ULL, 0x000fc600078e00ffULL, 0xffffffe026257812ULL, 0x000fe400078ee225ULL,
0x000000121a267810ULL, 0x000fc60007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0xffffffe027267812ULL, 0x000fca00078ee226ULL, 0x0000001026267824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002560783bULL, 0x000fe80000000200ULL,
0x00000000176c783bULL, 0x000e680000000200ULL, 0x000000001870783bULL, 0x000ea80000000200ULL,
0x000000001668783bULL, 0x000ee80000000200ULL, 0x000000001564783bULL, 0x000f280000000200ULL,
0x000000002628783bULL, 0x000fe80000000200ULL, 0x000000001348783bULL, 0x000ee80000000200ULL,
0x00000000145c783bULL, 0x000ee80000000200ULL, 0x000000001230783bULL, 0x000ee80000000200ULL,
0x00000000112c783bULL, 0x000ee20000000200ULL, 0x0000006c6038723cULL, 0x042f700000001838ULL,
0x0000006e6050723cULL, 0x040f700000001850ULL, 0x000000706034723cULL, 0x044f700000001834ULL,
0x000000726040723cULL, 0x040f700000001840ULL, 0x00000068603c723cULL, 0x048f70000000183cULL,
0x0000006a604c723cULL, 0x040f70000000184cULL, 0x000000646054723cULL, 0x050f700000001854ULL,
0x000000666058723cULL, 0x000f700000001858ULL, 0x000000482838723cULL, 0x060b700000001838ULL,
0x0000004a2848723cULL, 0x040b700000001850ULL, 0x0000005c2834723cULL, 0x040b700000001834ULL,
0x0000005e2840723cULL, 0x040b700000001840ULL, 0x00000030283c723cULL, 0x040b70000000183cULL,
0x000000322850723cULL, 0x040b70000000184cULL, 0x0000002c2854723cULL, 0x040b700000001854ULL,
0x0000002e2858723cULL, 0x000b620000001858ULL, 0x0000063000008947ULL, 0x000fce0003800000ULL,
0x00000002ff327819ULL, 0x020fe20000011622ULL, 0x0000000144477824ULL, 0x000fc600078e0a1fULL,
0x00000008324c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105267824ULL, 0x040fe200078e0232ULL,
0x00000010325c7810ULL, 0x040fe40007ffe0ffULL, 0x00000018325e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105287824ULL, 0x000fe200078e024cULL, 0x000000261d257210ULL, 0x000fe20007f3e0ffULL,
0x00000001052e7824ULL, 0x040fe200078e025cULL, 0x0000002032607810ULL, 0x000fe20007ffe0ffULL,
0x0000000105307824ULL, 0x000fe200078e025eULL, 0x000000281d297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0025267a11ULL, 0x000fe200078248ffULL,
0x000000044c4f7824ULL, 0x000fe200078e00ffULL, 0x0000002e1d2e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x000000301d307210ULL, 0x000fe20007f9e0ffULL,
0x000000045c5d7824ULL, 0x000fe200078e00ffULL, 0x00005e0029287a11ULL, 0x000fc400078448ffULL,
0x00005f0025277a11ULL, 0x000fe200008f4c2aULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x00005f0029297a11ULL, 0x000fe200010f4c2cULL, 0x000000ffff2d7224ULL, 0x000fe200020e06ffULL,
0x00005e002e2a7a11ULL, 0x000fe400078248ffULL, 0x00005e00302c7a11ULL, 0x000fe400078448ffULL,
0x0000002832627810ULL, 0x000fe40007ffe0ffULL, 0x00005f002e2b7a11ULL, 0x000fe200008f4c25ULL,
0x00000001052e7824ULL, 0x040fe200078e0260ULL, 0x00005f00302d7a11ULL, 0x000fe200010f4c2dULL,
0x0000000105307824ULL, 0x000fe200078e0262ULL, 0x0000003032667810ULL, 0x000fc40007ffe0ffULL,
0x0000002e1d257210ULL, 0x040fe40007f5e0ffULL, 0x000000301d317210ULL, 0x000fe20007f7e0ffULL,
0x0000000105687824ULL, 0x000fe200078e0266ULL, 0x00000038326a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200010e06ffULL, 0x00005e00252e7a11ULL, 0x000fe200078448ffULL,
0x000000ffff647224ULL, 0x000fe200018e06ffULL, 0x000000681d687210ULL, 0x000fe40007f9e0ffULL,
0x00005e0031307a11ULL, 0x000fc400078648ffULL, 0x00005f00252f7a11ULL, 0x000fe200010f4c4eULL,
0x00000001054e7824ULL, 0x000fe200078e026aULL, 0x000000473200720cULL, 0x080fe20003f26070ULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x00005f0031317a11ULL, 0x000fe400018f4c64ULL,
0x00005e0068327a11ULL, 0x000fe400078648ffULL, 0x000000474c00720cULL, 0x000fe40003f46070ULL,
0x0000004e1d4d7210ULL, 0x000fc40007f9e0ffULL, 0x00005f0068337a11ULL, 0x000fe400018f4c25ULL,
0x000000181c257812ULL, 0x000fe200078efcffULL, 0x000000ffff647224ULL, 0x000fe200020e06ffULL,
0xfffffffc4f4e7812ULL, 0x000fe400078ee210ULL, 0x00005e004d4c7a11ULL, 0x000fe200078648ffULL,
0x0000001025267825ULL, 0x000fe200078e0026ULL, 0x000000476200720cULL, 0x080fe40003f86070ULL,
0x00005f004d4d7a11ULL, 0x000fe200018f4c64ULL, 0x000000104e4f7824ULL, 0x000fe200078e0219ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000260f7faeULL, 0x0003e2000c901c46ULL,
0x0000001025287825ULL, 0x000fe200078e0028ULL, 0x000000475c00720cULL, 0x000fc40003f26070ULL,
0xfffffffc5d4e7812ULL, 0x000fe200078ee210ULL, 0x000000046a5d7824ULL, 0x000fe200078e00ffULL,
0x00000000284f7faeULL, 0x0005e2000d101c46ULL, 0x000000475e00720cULL, 0x080fe40003f46070ULL,
0x000000476000720cULL, 0x080fe40003f66070ULL, 0x000000476600720cULL, 0x080fe20003fa6070ULL,
0x0000001025267825ULL, 0x002fe200078e002aULL, 0x000000476a00720cULL, 0x000fc60003fc6070ULL,
0x00000010252a7825ULL, 0x000fc800078e002cULL, 0x00000010252c7825ULL, 0x000fc800078e002eULL,
0x0000001025287825ULL, 0x004fc800078e0030ULL, 0x00000010252e7825ULL, 0x000fc800078e0032ULL,
0x0000001025307825ULL, 0x000fc800078e004cULL, 0x000000045e257824ULL, 0x000fe200078e00ffULL,
0xfffffffc5d5e7812ULL, 0x100fe200078ee210ULL, 0x0000000460337824ULL, 0x000fe400078e00ffULL,
0x00000004624d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc25327812ULL, 0x100fe200078ee210ULL,
0x00000004664f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc334c7812ULL, 0x100fe200078ee210ULL,
0x000000104e477824ULL, 0x100fe200078e0219ULL, 0xfffffffc4d4e7812ULL, 0x100fe200078ee210ULL,
0x0000001032257824ULL, 0x100fe200078e0219ULL, 0xfffffffc4f5c7812ULL, 0x000fe200078ee210ULL,
0x000000105e4d7824ULL, 0x100fe200078e0219ULL, 0x0000000026477faeULL, 0x0003e2000c901c46ULL,
0x000000104e337824ULL, 0x000fc600078e0219ULL, 0x000000002a257faeULL, 0x0005e2000d101c46ULL,
0x000000104c277824ULL, 0x102fe400078e0219ULL, 0x000000105c477824ULL, 0x000fc600078e0219ULL,
0x000000002c277faeULL, 0x0005e8000d901c46ULL, 0x0000000028337faeULL, 0x0005e8000e101c46ULL,
0x000000002e477faeULL, 0x0005e8000e901c46ULL, 0x00000000304d7faeULL, 0x0005e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000822327811ULL, 0x060fe400078ff0ffULL,
0x0000000522267211ULL, 0x000fc400078ff0ffULL, 0x00000010224c7811ULL, 0x000fe200078ff0ffULL,
0x0000000105287824ULL, 0x000fe200078e0232ULL, 0x0000001d26257210ULL, 0x080fe20007f3e0ffULL,
0x00000004324d7824ULL, 0x000fe200078e00ffULL, 0x00000018225e7811ULL, 0x000fe200078ff0ffULL,
0x000000044c4f7824ULL, 0x000fe200078e00ffULL, 0x0000001d28297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0025267a11ULL, 0x000fe400078248ffULL,
0x0000002022607811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e0029287a11ULL, 0x000fc400078448ffULL, 0x00005f0025277a11ULL, 0x000fe200008f4c2aULL,
0x00000001052a7824ULL, 0x000fe200078e024cULL, 0x00005f0029297a11ULL, 0x000fe200010f4c2cULL,
0x00000001052c7824ULL, 0x040fe200078e025eULL, 0x0000002822627811ULL, 0x000fe200078ff0ffULL,
0x00000001054e7824ULL, 0x040fe200078e0260ULL, 0x0000001d2a257210ULL, 0x080fe40007f3e0ffULL,
0x0000001d2c2d7210ULL, 0x080fe20007f5e0ffULL, 0x00000001055c7824ULL, 0x000fe200078e0262ULL,
0x0000003022647811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e00252a7a11ULL, 0x000fe200078248ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078448ffULL, 0x00000004625d7824ULL, 0x000fe200078e00ffULL,
0x00005f00252b7a11ULL, 0x000fe200008f4c2eULL, 0x00000004645f7824ULL, 0x000fe200078e00ffULL,
0x0000001d4e4e7210ULL, 0x000fc40007f3e0ffULL, 0x00005f002d2d7a11ULL, 0x000fe400010f4c30ULL,
0x0000001d5c5c7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0x00005e004e2e7a11ULL, 0x000fe400078248ffULL, 0x0000003822667811ULL, 0x000fe200078ff0ffULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x00005e005c307a11ULL, 0x000fe400078448ffULL,
0x00005f004e2f7a11ULL, 0x000fe200008f4c25ULL, 0x00000001054e7824ULL, 0x040fe200078e0264ULL,
0x00005f005c317a11ULL, 0x000fe200010f4c31ULL, 0x00000001055c7824ULL, 0x000fe200078e0266ULL,
0x000000181c257812ULL, 0x000fe200078efcffULL, 0x0000000466617824ULL, 0x000fe200078e00ffULL,
0x0000001d4e4e7210ULL, 0x000fc40007f3e0ffULL, 0x0000001d5c477210ULL, 0x000fe20007f5e0ffULL,
0x0000001025267825ULL, 0x000fe200078e0026ULL, 0xfffffffc4f5c7812ULL, 0x000fc600078ee210ULL,
0x000000ffff337224ULL, 0x000fe200008e06ffULL, 0x00005e004e327a11ULL, 0x040fe200078248ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x00005e00474c7a11ULL, 0x000fe200078448ffULL,
0x0000001025287825ULL, 0x000fe200078e0028ULL, 0x00005f004e337a11ULL, 0x000fe200008f4c33ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000260f7faeULL, 0x0003e2000b901c46ULL,
0xfffffffc4d4e7812ULL, 0x000fe200078ee210ULL, 0x00000010252a7825ULL, 0x000fe200078e002aULL,
0x00005f00474d7a11ULL, 0x000fc600010f4c68ULL, 0x00000010252c7825ULL, 0x000fc800078e002cULL,
0x00000010252e7825ULL, 0x000fc800078e002eULL, 0x0000001025307825ULL, 0x000fc800078e0030ULL,
0x0000001025327825ULL, 0x000fc800078e0032ULL, 0x00000010254c7825ULL, 0x000fc800078e004cULL,
0x000000045e257824ULL, 0x000fe200078e00ffULL, 0xfffffffc5f5e7812ULL, 0x100fe200078ee210ULL,
0x0000000460277824ULL, 0x002fe400078e00ffULL, 0x000000104e477824ULL, 0x100fe200078e0219ULL,
0xfffffffc25267812ULL, 0x100fe200078ee210ULL, 0x000000105c4f7824ULL, 0x100fe200078e0219ULL,
0xfffffffc274e7812ULL, 0x100fe400078ee210ULL, 0xfffffffc5d5c7812ULL, 0x000fe200078ee210ULL,
0x0000000028477faeULL, 0x0003e2000b901c46ULL, 0x0000001026257824ULL, 0x000fc400078e0219ULL,
0x000000104e277824ULL, 0x100fe200078e0219ULL, 0x000000002a4f7faeULL, 0x0005e8000b901c46ULL,
0x000000002c257faeULL, 0x0007e2000b901c46ULL, 0xfffffffc61287812ULL, 0x002fe200078ee210ULL,
0x000000105c297824ULL, 0x100fe400078e0219ULL, 0x000000002e277faeULL, 0x0007e2000b901c46ULL,
0x000000105e2b7824ULL, 0x004fc400078e0219ULL, 0x0000001028477824ULL, 0x000fe200078e0219ULL,
0x0000000030297faeULL, 0x0007e8000b901c46ULL, 0x00000000322b7faeULL, 0x0007e8000b901c46ULL,
0x000000004c477faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000201b267824ULL, 0x040fe200078e00ffULL, 0x000000141a257810ULL, 0x00cfe20007ffe0ffULL,
0x000000201b277824ULL, 0x000fc600078e00ffULL, 0xffffffe026257812ULL, 0x000fe400078ee225ULL,
0x000000161a267810ULL, 0x000fc60007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0xffffffe027267812ULL, 0x000fca00078ee226ULL, 0x0000001026267824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000d68783bULL, 0x000fe80000000200ULL,
0x000000002560783bULL, 0x000e680000000200ULL, 0x000000000c70783bULL, 0x000ea80000000200ULL,
0x000000000b6c783bULL, 0x000ee80000000200ULL, 0x000000000a64783bULL, 0x000f280000000200ULL,
0x00000000095c783bULL, 0x000fe80000000200ULL, 0x000000002628783bULL, 0x000ee80000000200ULL,
0x00000000084c783bULL, 0x000ee80000000200ULL, 0x000000000730783bULL, 0x000ee80000000200ULL,
0x00000000022c783bULL, 0x000ee20000000200ULL, 0x000000686034723cULL, 0x042ff00000001834ULL,
0x0000006a6040723cULL, 0x040f700000001840ULL, 0x000000706068723cULL, 0x044f700000001838ULL,
0x000000726048723cULL, 0x040f700000001848ULL, 0x0000006c6070723cULL, 0x048f70000000183cULL,
0x0000006e6050723cULL, 0x040f700000001850ULL, 0x000000646054723cULL, 0x050f700000001854ULL,
0x000000666058723cULL, 0x000f700000001858ULL, 0x0000005e2838723cULL, 0x060b700000001840ULL,
0x0000004c283c723cULL, 0x040b700000001868ULL, 0x0000004e284c723cULL, 0x040b700000001848ULL,
0x000000302840723cULL, 0x040b700000001870ULL, 0x0000005c2834723cULL, 0x040b700000001834ULL,
0x000000322830723cULL, 0x040b700000001850ULL, 0x0000002c2848723cULL, 0x040b700000001854ULL,
0x0000002e2828723cULL, 0x000b620000001858ULL, 0x0000063000008947ULL, 0x000fce0003800000ULL,
0x00000002ff507819ULL, 0x020fe20000011622ULL, 0x0000000144257824ULL, 0x000fc600078e0a1fULL,
0x00000008505a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105267824ULL, 0x040fe200078e0250ULL,
0x00000010505c7810ULL, 0x040fe40007ffe0ffULL, 0x00000018505e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001052c7824ULL, 0x000fe200078e025aULL, 0x000000261d277210ULL, 0x000fe20007f1e0ffULL,
0x00000001052e7824ULL, 0x000fe200078e025cULL, 0x0000002050607810ULL, 0x000fe20007ffe0ffULL,
0x000000045e5b7824ULL, 0x000fe200078e00ffULL, 0x0000002c1d2d7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff527224ULL, 0x000fe200000e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078048ffULL,
0x0000000460617824ULL, 0x000fe200078e00ffULL, 0x0000002e1d2f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff547224ULL, 0x000fe200008e06ffULL, 0x00005f0027277a11ULL, 0x000fe200000f4c52ULL,
0x0000000105527824ULL, 0x000fe200078e025eULL, 0x00005e002d2c7a11ULL, 0x000fe200078248ffULL,
0x000000ffff567224ULL, 0x000fe200010e06ffULL, 0x000000255000720cULL, 0x000fc40003f06070ULL,
0x00005f002d2d7a11ULL, 0x000fe400008f4c54ULL, 0x0000002850647810ULL, 0x040fe40007ffe0ffULL,
0x0000003050687810ULL, 0x040fe40007ffe0ffULL, 0x00000038506c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105507824ULL, 0x000fe200078e0260ULL, 0x000000521d527210ULL, 0x000fe20007f3e0ffULL,
0x0000000105547824ULL, 0x000fe200078e0264ULL, 0x00005e002f2e7a11ULL, 0x000fe200078448ffULL,
0x0000000105587824ULL, 0x000fe200078e026cULL, 0x000000501d537210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff477224ULL, 0x000fe200008e06ffULL, 0x00005f002f2f7a11ULL, 0x000fe200010f4c56ULL,
0x0000000105567824ULL, 0x000fe200078e0268ULL, 0x00005e0052507a11ULL, 0x000fe200078648ffULL,
0x000000ffff627224ULL, 0x000fe200020e06ffULL, 0x000000541d557210ULL, 0x040fe20007fbe0ffULL,
0x0000000464637824ULL, 0x000fe200078e00ffULL, 0x00005f0052517a11ULL, 0x000fe200018f4c47ULL,
0x0000000468657824ULL, 0x000fe200078e00ffULL, 0x000000561d577210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff667224ULL, 0x000fe200028e06ffULL, 0x000000581d597210ULL, 0x000fe20007f3e0ffULL,
0x000000046c677824ULL, 0x000fe200078e00ffULL, 0x0000001c1c477812ULL, 0x000fe200078efcffULL,
0x000000ffff6a7224ULL, 0x000fe200010e06ffULL, 0x00005e0053527a11ULL, 0x000fe200078648ffULL,
0x000000ffff6e7224ULL, 0x000fe200008e06ffULL, 0x00005e0055547a11ULL, 0x000fe200078848ffULL,
0x00000010471c7825ULL, 0x000fe200078e0026ULL, 0x00005e0057567a11ULL, 0x000fc400078448ffULL,
0x00005e0059587a11ULL, 0x000fe200078248ffULL, 0x000000045c277824ULL, 0x000fe200078e00ffULL,
0x00005f0053537a11ULL, 0x000fe200018f4c62ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c247faeULL, 0x0003e2000c101c46ULL, 0x00005f0055557a11ULL, 0x000fe400020f4c66ULL,
0x00005f0057577a11ULL, 0x000fe400010f4c6aULL, 0x00005f0059597a11ULL, 0x000fe400008f4c6eULL,
0x000000255a00720cULL, 0x000fc40003f06070ULL, 0x000000255c00720cULL, 0x080fe40003f26070ULL,
0x000000255e00720cULL, 0x080fe40003f46070ULL, 0x000000256000720cULL, 0x080fe40003f66070ULL,
0x000000256400720cULL, 0x080fe40003f86070ULL, 0x000000256800720cULL, 0x080fe40003fa6070ULL,
0x000000256c00720cULL, 0x000fe20003fc6070ULL, 0x000000045a257824ULL, 0x000fe200078e00ffULL,
0xfffffffc61617812ULL, 0x000fc400078ee210ULL, 0xfffffffc63637812ULL, 0x100fe400078ee210ULL,
0xfffffffc251d7812ULL, 0x002fe200078ee210ULL, 0x0000001061617824ULL, 0x000fe200078e020eULL,
0xfffffffc27257812ULL, 0x000fe200078ee210ULL, 0x0000001063637824ULL, 0x000fe200078e020eULL,
0xfffffffc5b277812ULL, 0x000fe200078ee210ULL, 0x000000101d5b7824ULL, 0x000fe200078e020eULL,
0xfffffffc65657812ULL, 0x000fe200078ee210ULL, 0x00000010255d7824ULL, 0x000fe200078e020eULL,
0xfffffffc67677812ULL, 0x000fe200078ee210ULL, 0x00000010471c7825ULL, 0x000fc800078e002cULL,
0x00000010275f7824ULL, 0x000fe200078e020eULL, 0x000000001c5b7faeULL, 0x0003e2000c101c46ULL,
0x0000001047247825ULL, 0x000fc800078e002eULL, 0x0000001047267825ULL, 0x040fe200078e0050ULL,
0x00000000245d7faeULL, 0x0003e6000c901c46ULL, 0x00000010472c7825ULL, 0x040fe200078e0052ULL,
0x00000000265f7faeULL, 0x0003e6000d101c46ULL, 0x00000010472e7825ULL, 0x000fe200078e0054ULL,
0x000000002c617faeULL, 0x0003e6000d901c46ULL, 0x0000001065657824ULL, 0x000fe200078e020eULL,
0x000000002e637faeULL, 0x0003e2000e101c46ULL, 0x0000001047507825ULL, 0x000fc800078e0056ULL,
0x0000001067677824ULL, 0x000fe200078e020eULL, 0x0000000050657faeULL, 0x0003e2000e901c46ULL,
0x0000001047527825ULL, 0x000fca00078e0058ULL, 0x0000000052677faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000522267211ULL, 0x040fe400078ff0ffULL,
0x00000008222e7811ULL, 0x020fe400078ff0ffULL, 0x0000001d26257210ULL, 0x080fe40007f1e0ffULL,
0x0000001022527811ULL, 0x040fe400078ff0ffULL, 0x0000001822547811ULL, 0x040fe200078ff0ffULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x00005e0025267a11ULL, 0x000fe200078048ffULL,
0x0000000105507824ULL, 0x040fe200078e0252ULL, 0x0000002022587811ULL, 0x040fe200078ff0ffULL,
0x0000000105567824ULL, 0x000fe200078e0254ULL, 0x00005f0025277a11ULL, 0x000fe200000f4c2cULL,
0x00000001052c7824ULL, 0x040fe200078e022eULL, 0x00000028225c7811ULL, 0x040fe200078ff0ffULL,
0x00000001055a7824ULL, 0x040fe200078e0258ULL, 0x0000003022607811ULL, 0x000fe200078ff0ffULL,
0x0000000454517824ULL, 0x000fe200078e00ffULL, 0x0000003822647811ULL, 0x000fe200078ff0ffULL,
0x00000001055e7824ULL, 0x040fe200078e025cULL, 0x0000001d2c257210ULL, 0x080fe20007f7e0ffULL,
0x0000000105627824ULL, 0x040fe200078e0260ULL, 0x0000001d502f7210ULL, 0x080fe20007f3e0ffULL,
0x0000000105667824ULL, 0x000fe200078e0264ULL, 0x0000001d56567210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff507224ULL, 0x000fe200018e06ffULL, 0x0000001d5a5a7210ULL, 0x080fe20007f5e0ffULL,
0x0000000458537824ULL, 0x000fe200078e00ffULL, 0x0000001d5e5e7210ULL, 0x080fe20007f7e0ffULL,
0x000000045c557824ULL, 0x000fe200078e00ffULL, 0x0000001d62627210ULL, 0x080fe20007fbe0ffULL,
0x0000000460577824ULL, 0x000fe200078e00ffULL, 0x0000001d66667210ULL, 0x000fe20007f9e0ffULL,
0x000000042e1d7824ULL, 0x000fe200078e00ffULL, 0x00005e00252c7a11ULL, 0x000fe200078c48ffULL,
0x0000000464597824ULL, 0x000fe200078e00ffULL, 0xfffffffc51517812ULL, 0x000fc400078ee210ULL,
0x00005f00252d7a11ULL, 0x000fe200030f4c50ULL, 0x0000000452257824ULL, 0x000fe200078e00ffULL,
0xfffffffc1d1d7812ULL, 0x100fe200078ee210ULL, 0x000000ffff527224ULL, 0x000fe200008e06ffULL,
0xfffffffc53537812ULL, 0x000fe200078ee210ULL, 0x00000010515d7824ULL, 0x000fe200078e020eULL,
0xfffffffc25257812ULL, 0x000fe200078ee210ULL, 0x000000101d477824ULL, 0x000fe200078e020eULL,
0xfffffffc55557812ULL, 0x100fe200078ee210ULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0xfffffffc57577812ULL, 0x000fe200078ee210ULL, 0x00000010535f7824ULL, 0x100fe200078e020eULL,
0x00005e002f2e7a11ULL, 0x000fe200078248ffULL, 0x00000010255b7824ULL, 0x100fe200078e020eULL,
0x00005e0056507a11ULL, 0x040fe200078048ffULL, 0x0000001055617824ULL, 0x000fe200078e020eULL,
0xfffffffc59597812ULL, 0x000fe200078ee210ULL, 0x000000ffff537224ULL, 0x000fe200010e06ffULL,
0x00005f002f2f7a11ULL, 0x000fe200008f4c52ULL, 0x0000001057637824ULL, 0x100fe200078e020eULL,
0x00005f0056517a11ULL, 0x000fe200000f4c1dULL, 0x000000ffff557224ULL, 0x000fe200018e06ffULL,
0x0000001c1c257812ULL, 0x000fe200078efcffULL, 0x0000001059657824ULL, 0x000fe200078e020eULL,
0x00005e005a527a11ULL, 0x000fe200078048ffULL, 0x000000ffff577224ULL, 0x000fe200028e06ffULL,
0x00005e005e547a11ULL, 0x000fe200078248ffULL, 0x000000ffff597224ULL, 0x000fe200020e06ffULL,
0x00005e0062567a11ULL, 0x000fe200078448ffULL, 0x00000010251c7825ULL, 0x000fe200078e0026ULL,
0x00005e0066587a11ULL, 0x000fc400078648ffULL, 0x00005f005a537a11ULL, 0x000fe200000f4c53ULL,
0x0000001025267825ULL, 0x040fe200078e002cULL, 0x00005f005e557a11ULL, 0x000fe200008f4c55ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c247faeULL, 0x0003e2000b901c46ULL,
0x00005f0062577a11ULL, 0x000fe200010f4c57ULL, 0x00000010252c7825ULL, 0x040fe200078e002eULL,
0x00005f0066597a11ULL, 0x000fe200018f4c59ULL, 0x0000000026477faeULL, 0x0003e4000b901c46ULL,
0x00000010252e7825ULL, 0x040fe400078e0050ULL, 0x000000002c5b7faeULL, 0x0003e4000b901c46ULL,
0x0000001025507825ULL, 0x000fc400078e0052ULL, 0x000000002e5d7faeULL, 0x0003e4000b901c46ULL,
0x0000001025527825ULL, 0x040fe400078e0054ULL, 0x00000000505f7faeULL, 0x0003e4000b901c46ULL,
0x0000001025547825ULL, 0x040fe400078e0056ULL, 0x0000000052617faeULL, 0x0003e4000b901c46ULL,
0x0000001025567825ULL, 0x000fc400078e0058ULL, 0x0000000054637faeULL, 0x0003e8000b901c46ULL,
0x0000000056657faeULL, 0x0003e4000b901c46ULL, 0x00000004ff257424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff1d7424ULL, 0x000fe400078e00ffULL,
0x0000030025067a24ULL, 0x000fca00078e0206ULL, 0x000000450600720cULL, 0x000fda0003f06070ULL,
0x0000000223248824ULL, 0x000fe200078e0206ULL, 0x000000181a0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b277824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000600024248625ULL, 0x000fe200078e0025ULL, 0xffffffe0270e7812ULL, 0x000fe200078ee20eULL,
0x000000001850783bULL, 0x000fe80000000200ULL, 0x00000006241d8981ULL, 0x0002a2000c1e1900ULL,
0x000000100e0e7824ULL, 0x000fe200078e00ffULL, 0x0000001a1a1c7810ULL, 0x000fe40007ffe0ffULL,
0x000000001754783bULL, 0x000fe80000000200ULL, 0x000000000e2c783bULL, 0x000ee20000000200ULL,
0x000000201b257824ULL, 0x002fc600078e00ffULL, 0x000000001658783bULL, 0x000e640000000200ULL,
0xffffffe0251c7812ULL, 0x000fe400078ee21cULL, 0x00000000155c783bULL, 0x000f260000000200ULL,
0x000000101c1c7824ULL, 0x000fe200078e00ffULL, 0x000000001460783bULL, 0x000fe80000000200ULL,
0x000000001c24783bULL, 0x000e680000000200ULL, 0x000000001364783bULL, 0x000e680000000200ULL,
0x000000001268783bULL, 0x000f280000000200ULL, 0x00000000116c783bULL, 0x0007240000000200ULL,
0x0000030003117a10ULL, 0x008fe20007ffe0ffULL, 0x000000502c34723cULL, 0x000f660000001834ULL,
0x0000000111137810ULL, 0x000fc80007ffe0ffULL, 0x000000461300720cULL, 0x000fe20003f06070ULL,
0x000000522c38723cULL, 0x040f700000001838ULL, 0x000000542c3c723cULL, 0x040f70000000183cULL,
0x000000582c40723cULL, 0x042ff00000001840ULL, 0x000000562c4c723cULL, 0x040f70000000184cULL,
0x0000005a2c58723cULL, 0x040f700000001830ULL, 0x0000005c2c48723cULL, 0x050f700000001848ULL,
0x0000005e2c5c723cULL, 0x000f700000001828ULL, 0x000000602414723cULL, 0x060f700000001834ULL,
0x000000622428723cULL, 0x040f700000001838ULL, 0x00000064242c723cULL, 0x040f70000000183cULL,
0x000000662430723cULL, 0x040f70000000184cULL, 0x000000682434723cULL, 0x040f700000001840ULL,
0x0000006a2438723cULL, 0x040f700000001858ULL, 0x0000006c243c723cULL, 0x040b700000001848ULL,
0x0000006e2424723cULL, 0x000b64000000185cULL, 0x000000041d4a7c24ULL, 0x024fe2000f8e02ffULL,
0x000006e000008947ULL, 0x000fca0003800000ULL, 0x0000010011137824ULL, 0x000fe200078e0204ULL,
0x00000002ff4b7819ULL, 0x000fe20000011622ULL, 0x00000010224c7824ULL, 0x000fc600078e00ffULL,
0x00000013440e7217ULL, 0x000fe20007800000ULL, 0x0000000105497824ULL, 0x000fe200078e024bULL,
0x000000104b4f7810ULL, 0x040fe40007ffe0ffULL, 0x000000184b507810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a13ULL, 0x000000084b4e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105137824ULL, 0x000fe200078e024fULL, 0x0000004a49497210ULL, 0x080fe20007f1e0ffULL,
0x0000000105417824ULL, 0x040fe200078e0250ULL, 0x000000304c4d7812ULL, 0x000fe200078ec0ffULL,
0x0000000105437824ULL, 0x000fe200078e024eULL, 0x0000004a13187210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x0000004a41487210ULL, 0x000fc40007f7e0ffULL,
0x00005e0049477a11ULL, 0x000fe200078048ffULL, 0x000000ffff417224ULL, 0x000fe200010e06ffULL,
0x0000004a43437210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x00005e00481c7a11ULL, 0x040fe400078448ffULL, 0x00005f0049497a11ULL, 0x000fe200000f4c12ULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00005e0043407a11ULL, 0x040fe400078048ffULL,
0x00005f0048487a11ULL, 0x000fe200010f4c13ULL, 0x000000044e137824ULL, 0x000fe200078e00ffULL,
0x00005f0043437a11ULL, 0x000fc400000f4c12ULL, 0x0000004d47127210ULL, 0x000fe40007f7e0ffULL,
0x00005e0018427a11ULL, 0x040fe400078248ffULL, 0x0000000e4f00720cULL, 0x0c0fe20003f46070ULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc134c7812ULL, 0x000fe200078ee210ULL,
0x000000ffff137224ULL, 0x000fe200018e0649ULL, 0x0000000e4b00720cULL, 0x080fe40003f06070ULL,
0x00005f0018187a11ULL, 0x000fe200008f4c41ULL, 0x000000104c497824ULL, 0x000fe200078e0219ULL,
0x0000000e4e00720cULL, 0x000fc40003f26070ULL, 0xfffffffc4f4e7812ULL, 0x000fe400078ee210ULL,
0x000000204b4c7810ULL, 0x040fe40007ffe0ffULL, 0x0000004d40407210ULL, 0x000fe20007f7e0ffULL,
0x000000104e4f7824ULL, 0x000fe200078e0219ULL, 0x000000284b4e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105477824ULL, 0x000fe200078e024cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120f7faeULL, 0x0003e2000c101c46ULL, 0x000000ffff417224ULL, 0x000fe200018e0643ULL,
0x000000304b517810ULL, 0x000fc40007ffe0ffULL, 0x000000384b527810ULL, 0x000fe20007ffe0ffULL,
0x00000001054b7824ULL, 0x000fe200078e024eULL, 0x0000004a47477210ULL, 0x000fe20007f1e0ffULL,
0x0000000040497faeULL, 0x0005e2000c901c46ULL, 0x0000004d42427210ULL, 0x000fe40007f9e0ffULL,
0x0000000e4c00720cULL, 0x000fe20003f66070ULL, 0x000000ffff127224ULL, 0x002fe200000e06ffULL,
0x0000004a4b0f7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff437224ULL, 0x000fe200020e0618ULL,
0x0000000e5000720cULL, 0x080fe20003f86070ULL, 0x0000000105137824ULL, 0x000fe200078e0251ULL,
0x0000000e5100720cULL, 0x080fe20003f26070ULL, 0x000000044e4b7824ULL, 0x040fe200078e00ffULL,
0x00005e0047417a11ULL, 0x004fe200078c48ffULL, 0x00000000424f7faeULL, 0x0003e2000d101c46ULL,
0x0000000e4e00720cULL, 0x080fe20003f46070ULL, 0x0000000105497824ULL, 0x000fe200078e0252ULL,
0x00005f0047477a11ULL, 0x000fe200030f4c12ULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x00005e000f187a11ULL, 0x000fe200078c48ffULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x0000000e5200720cULL, 0x000fc40003f06070ULL, 0x0000004d1c0e7210ULL, 0x000fe40007fbe0ffULL,
0x00005f000f437a11ULL, 0x002fe200030f4c12ULL, 0x00000004524f7824ULL, 0x000fe200078e00ffULL,
0x0000004a13427210ULL, 0x080fe20007fde0ffULL, 0x0000000450137824ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fe200028e0648ULL, 0x0000004a491c7210ULL, 0x000fe20007fbe0ffULL,
0x000000044c497824ULL, 0x000fe200078e00ffULL, 0xfffffffc13127812ULL, 0x000fe200078ee210ULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x00005e0042407a11ULL, 0x000fc400078c48ffULL,
0xfffffffc49487812ULL, 0x100fe200078ee210ULL, 0x0000001012497824ULL, 0x000fe200078e0219ULL,
0x00005f0042427a11ULL, 0x000fe400030f4c13ULL, 0x0000004d41127210ULL, 0x080fe20007fde0ffULL,
0x000000ffff417224ULL, 0x000fe200028e06ffULL, 0xfffffffc4b4a7812ULL, 0x100fe200078ee210ULL,
0x000000000e497faeULL, 0x0003e2000e101c46ULL, 0xfffffffc514c7812ULL, 0x100fe200078ee210ULL,
0x000000ffff137224ULL, 0x000fe200030e0647ULL, 0xfffffffc4f4e7812ULL, 0x000fe200078ee210ULL,
0x00000010484b7824ULL, 0x100fe200078e0219ULL, 0x00005e001c107a11ULL, 0x000fe200078848ffULL,
0x000000104a4f7824ULL, 0x100fe200078e0219ULL, 0x0000004d18187210ULL, 0x080fe20007fde0ffULL,
0x000000104c517824ULL, 0x100fe200078e0219ULL, 0x0000004d40407210ULL, 0x080fe20007fbe0ffULL,
0x000000104e477824ULL, 0x000fe200078e0219ULL, 0x00000000124b7faeULL, 0x0005e2000d901c46ULL,
0x00005f001c0f7a11ULL, 0x002fe200020f4c41ULL, 0x000000ffff197224ULL, 0x000fe200030e0643ULL,
0x0000004d100e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff417224ULL, 0x000fc600028e0642ULL,
0x00000000184f7faeULL, 0x0005e2000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fc600020e060fULL,
0x0000000040517faeULL, 0x0005e8000c901c46ULL, 0x000000000e477faeULL, 0x0005e2000c101c46ULL,
0x0000061000007947ULL, 0x000fea0003800000ULL, 0x0000000522137211ULL, 0x040fe400078ff0ffULL,
0x00000028224c7811ULL, 0x040fe400078ff0ffULL, 0x0000004a13507210ULL, 0x080fe40007f1e0ffULL,
0x00000030224e7811ULL, 0x000fe200078ff0ffULL, 0x000000044c537824ULL, 0x000fe200078e00ffULL,
0x0000003822527811ULL, 0x000fe200078ff0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e00504f7a11ULL, 0x000fe200078048ffULL, 0x0000000105417824ULL, 0x040fe200078e024eULL,
0x0000000822127811ULL, 0x000fe200078ff0ffULL, 0x00000001054b7824ULL, 0x040fe200078e0252ULL,
0x00005f0050507a11ULL, 0x000fe200000f4c13ULL, 0x0000000105137824ULL, 0x040fe200078e024cULL,
0x0000001022407811ULL, 0x040fe200078ff0ffULL, 0x00000001054d7824ULL, 0x040fe200078e0212ULL,
0x0000001822427811ULL, 0x000fe200078ff0ffULL, 0x000000044e557824ULL, 0x000fe200078e00ffULL,
0x0000002022487811ULL, 0x000fe200078ff0ffULL, 0x0000000105497824ULL, 0x000fe200078e0240ULL,
0x0000004a131c7210ULL, 0x080fe20007f5e0ffULL, 0x0000000105437824ULL, 0x000fe200078e0242ULL,
0x0000004a41187210ULL, 0x080fe20007f7e0ffULL, 0x0000000105477824ULL, 0x000fe200078e0248ULL,
0x0000004a4b0e7210ULL, 0x080fe20007f9e0ffULL, 0x0000000412137824ULL, 0x000fe200078e00ffULL,
0x0000004a4d4d7210ULL, 0x080fe20007fde0ffULL, 0x0000000440417824ULL, 0x000fe200078e00ffULL,
0x0000004a49497210ULL, 0x080fe20007fbe0ffULL, 0x00000004424b7824ULL, 0x000fe200078e00ffULL,
0x0000004a43437210ULL, 0x080fe20007f1e0ffULL, 0x0000000448517824ULL, 0x000fe200078e00ffULL,
0x0000004a47477210ULL, 0x000fe20007f3e0ffULL, 0x0000000452577824ULL, 0x000fe200078e00ffULL,
0xfffffffc13127812ULL, 0x100fe200078ee210ULL, 0x0000001022137824ULL, 0x000fe200078e00ffULL,
0xfffffffc41407812ULL, 0x100fe200078ee210ULL, 0x000000ffff417224ULL, 0x000fe200010e06ffULL,
0xfffffffc4b427812ULL, 0x000fc400078ee210ULL, 0xfffffffc51487812ULL, 0x100fe400078ee210ULL,
0xfffffffc534a7812ULL, 0x100fe200078ee210ULL, 0x0000001012537824ULL, 0x100fe200078e0219ULL,
0xfffffffc554c7812ULL, 0x100fe200078ee210ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0xfffffffc574e7812ULL, 0x000fe200078ee210ULL, 0x000000ffff107224ULL, 0x000fe200030e06ffULL,
0x00005e004d4b7a11ULL, 0x000fe200078c48ffULL, 0x0000001042577824ULL, 0x100fe200078e0219ULL,
0x00005e0043427a11ULL, 0x000fe200078048ffULL, 0x000000104a5b7824ULL, 0x100fe200078e0219ULL,
0x00005f004d4d7a11ULL, 0x000fe200030f4c10ULL, 0x0000001040557824ULL, 0x100fe200078e0219ULL,
0x0000003013517812ULL, 0x000fe200078ec0ffULL, 0x0000001048597824ULL, 0x100fe200078e0219ULL,
0x00005f0043437a11ULL, 0x000fe200000f4c12ULL, 0x000000ffff4a7224ULL, 0x000fe200028e06ffULL,
0x00005e0049407a11ULL, 0x000fe200078a48ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x00005e0047487a11ULL, 0x000fe200078248ffULL, 0x000000104c5d7824ULL, 0x100fe200078e0219ULL,
0x000000514f127210ULL, 0x000fe20007f1e0ffULL, 0x000000104e5f7824ULL, 0x000fe200078e0219ULL,
0x00005f0049497a11ULL, 0x000fe200028f4c4aULL, 0x000000ffff197224ULL, 0x000fe200018e06ffULL,
0x00005e000e4e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x00005f0047477a11ULL, 0x000fc400008f4c10ULL, 0x00005e00184c7a11ULL, 0x000fe400078448ffULL,
0x00005e001c4a7a11ULL, 0x000fe400078248ffULL, 0x00005f000e0e7a11ULL, 0x000fe200018f4c13ULL,
0x000000ffff137224ULL, 0x000fe200000e0650ULL, 0x00005f0018107a11ULL, 0x000fe400010f4c19ULL,
0x00005f001c1c7a11ULL, 0x000fe400008f4c41ULL, 0x000000514b187210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120f7faeULL, 0x0003e2000b901c46ULL,
0x0000005140407210ULL, 0x000fc40007f3e0ffULL, 0x0000005142427210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff197224ULL, 0x000fe200000e064dULL, 0x0000005148487210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff417224ULL, 0x000fe200008e0649ULL, 0x000000514a4a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff437224ULL, 0x000fe200010e0643ULL, 0x000000514c4c7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff497224ULL, 0x000fe200018e0647ULL, 0x000000514e4e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200020e061cULL, 0x0000000018537faeULL, 0x0003e2000b901c46ULL,
0x000000ffff4d7224ULL, 0x000fc400028e0610ULL, 0x000000ffff4f7224ULL, 0x000fe200000e060eULL,
0x0000000040557faeULL, 0x0003e8000b901c46ULL, 0x0000000042577faeULL, 0x0003e8000b901c46ULL,
0x0000000048597faeULL, 0x0003e8000b901c46ULL, 0x000000004a5b7faeULL, 0x0003e8000b901c46ULL,
0x000000004c5d7faeULL, 0x0003e8000b901c46ULL, 0x000000004e5f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000201b0f7824ULL, 0x006fe200078e00ffULL,
0x0000001c1a0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000001e1a1a7810ULL, 0x000fe40007ffe0ffULL,
0xffffffe00f0e7812ULL, 0x040fe400078ee20eULL, 0xffffffe00f0f7812ULL, 0x000fc600078ee21aULL,
0x000000100e0e7824ULL, 0x000fe400078e00ffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000d48783bULL, 0x000fe80000000200ULL,
0x000000000e40783bULL, 0x000e680000000200ULL, 0x000000000c4c783bULL, 0x000ea80000000200ULL,
0x000000000b18783bULL, 0x000ee80000000200ULL, 0x000000000a50783bULL, 0x000f280000000200ULL,
0x000000000958783bULL, 0x000fe80000000200ULL, 0x000000000f54783bULL, 0x000ee80000000200ULL,
0x00000000085c783bULL, 0x000ee80000000200ULL, 0x000000000260783bULL, 0x000fe20000000200ULL,
0x000000484014723cULL, 0x042f700000001814ULL, 0x0000004a4028723cULL, 0x040b640000001828ULL,
0x000000000748783bULL, 0x020e6c0000000200ULL, 0x0000004c402c723cULL, 0x044f70000000182cULL,
0x0000004e4030723cULL, 0x040f700000001830ULL, 0x000000184034723cULL, 0x048ff00000001834ULL,
0x0000001a4038723cULL, 0x040ff00000001838ULL, 0x00000050403c723cULL, 0x050ff0000000183cULL,
0x000000524024723cULL, 0x000ff00000001824ULL, 0x000000585414723cULL, 0x040f700000001814ULL,
0x0000005a5428723cULL, 0x040f700000001828ULL, 0x0000005c542c723cULL, 0x060f70000000182cULL,
0x0000005e5430723cULL, 0x000f620000001830ULL, 0x3d80000014147820ULL, 0x000fe20000410000ULL,
0x3d80000015157820ULL, 0x000fe20000410000ULL, 0x3d80000016167820ULL, 0x000fe20000410000ULL,
0x3d80000017177820ULL, 0x000fc80000410000ULL, 0x000000485434723cULL, 0x002f620000001834ULL,
0x3d80000028287820ULL, 0x000fe20000410000ULL, 0x3d80000029297820ULL, 0x000fe20000410000ULL,
0x3d8000002a2a7820ULL, 0x000fe20000410000ULL, 0x3d8000002b2b7820ULL, 0x000fc80000410000ULL,
0x0000004a5438723cULL, 0x000f640000001838ULL, 0x3d8000002c2c7820ULL, 0x020fe20000410000ULL,
0x3d8000002d2d7820ULL, 0x000fe20000410000ULL, 0x3d8000002e2e7820ULL, 0x000fe20000410000ULL,
0x3d8000002f2f7820ULL, 0x000fc60000410000ULL, 0x00000060543c723cULL, 0x000f62000000183cULL,
0x3d80000030307820ULL, 0x000fe20000410000ULL, 0x3d80000031317820ULL, 0x000fe20000410000ULL,
0x3d80000032327820ULL, 0x000fe20000410000ULL, 0x3d80000033337820ULL, 0x000fc80000410000ULL,
0x000000625424723cULL, 0x000f620000001824ULL, 0x3d80000034347820ULL, 0x000fe20000410000ULL,
0x3d80000035357820ULL, 0x000fe20000410000ULL, 0x3d80000036367820ULL, 0x000fe20000410000ULL,
0x3d80000037377820ULL, 0x000fc80000410000ULL, 0x3d80000038387820ULL, 0x000fe20000410000ULL,
0x3d80000039397820ULL, 0x000fe20000410000ULL, 0x3d8000003a3a7820ULL, 0x000fe20000410000ULL,
0x3d8000003b3b7820ULL, 0x000fca0000410000ULL, 0x3d8000003c3c7820ULL, 0x020fe20000410000ULL,
0x3d8000003d3d7820ULL, 0x000fe20000410000ULL, 0x3d8000003e3e7820ULL, 0x000fe20000410000ULL,
0x3d8000003f3f7820ULL, 0x000fca0000410000ULL, 0x3d80000024247820ULL, 0x000fe20000410000ULL,
0x3d80000025257820ULL, 0x000fe20000410000ULL, 0x3d80000026267820ULL, 0x000fe20000410000ULL,
0x3d80000027277820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000210c7f8cULL, 0x0002a4000c80043fULL, 0x0000000000087805ULL, 0x000fc40000015200ULL,
0x0000040021077984ULL, 0x000ee40000000800ULL, 0x8000000007ff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08077210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e09ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140aULL,
0x0000000702027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e060aULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040021077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000422077824ULL, 0x000fe200078e00ffULL, 0x000000200300720cULL, 0x000fc80003f05270ULL,
0xfffffff007097812ULL, 0x000fca00078ec0ffULL, 0x0000008000027824ULL, 0x000fca00078e0209ULL,
0x0144000002087984ULL, 0x0004e20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000222037824ULL, 0x000fe400078e00ffULL, 0x00000001441f7824ULL, 0x000fc600078e0a1fULL,
0x0000000603037812ULL, 0x000fc800078ec0ffULL, 0x00000001030c7812ULL, 0x040fe400078efcffULL,
0x00000008030d7812ULL, 0x040fe400078efcffULL, 0x0000001f0c00720cULL, 0x080fe40003f26070ULL,
0x00000010030c7812ULL, 0x000fe400078efcffULL, 0x0000001f0d00720cULL, 0x080fe40003f06070ULL,
0x0000001f0c00720cULL, 0x000fc40003fc6070ULL, 0x00000011030d7812ULL, 0x040fe400078efcffULL,
0x00000018030c7812ULL, 0x040fe400078efcffULL, 0x0000001f0300720cULL, 0x080fe40003f46070ULL,
0x0000001f0d00720cULL, 0x080fe40003fa6070ULL, 0x0000001f0c00720cULL, 0x000fe40003f66070ULL,
0x00000009030e7812ULL, 0x000fc400078efcffULL, 0x00000019030d7812ULL, 0x040fe400078efcffULL,
0x00000020030c7812ULL, 0x000fe400078efcffULL, 0xff80000016167808ULL, 0x000fe40005000000ULL,
0xff80000014147808ULL, 0x000fe40005000000ULL, 0xff80000017177808ULL, 0x000fe40004800000ULL,
0xff80000015157808ULL, 0x000fc40004800000ULL, 0x0000001f0e00720cULL, 0x080fe40003f86070ULL,
0x0000001f0d00720cULL, 0x080fe40003f46070ULL, 0x0000001f0c00720cULL, 0x000fe40003f26070ULL,
0x00000021030d7812ULL, 0x040fe400078efcffULL, 0x00000028030c7812ULL, 0x000fe400078efcffULL,
0xff8000002a2a7808ULL, 0x000fc40004000000ULL, 0xff80000028287808ULL, 0x000fe40004000000ULL,
0xff8000002b2b7808ULL, 0x000fe40006000000ULL, 0xff80000029297808ULL, 0x000fe40006000000ULL,
0x0000001f0d00720cULL, 0x080fe40003f06070ULL, 0x0000001f0c00720cULL, 0x000fe40003f86070ULL,
0x00000029030d7812ULL, 0x000fc400078efcffULL, 0x00000030030c7812ULL, 0x000fe400078efcffULL,
0xff8000002e2e7808ULL, 0x000fe40007000000ULL, 0xff8000002c2c7808ULL, 0x000fe40007000000ULL,
0xff8000002f2f7808ULL, 0x000fe40006800000ULL, 0xff8000002d2d7808ULL, 0x000fe40006800000ULL,
0x0000001f0d00720cULL, 0x000fc40003fc6070ULL, 0x0000001f0c00720cULL, 0x000fe40003fa6070ULL,
0x00000031030d7812ULL, 0x040fe400078efcffULL, 0x00000038030c7812ULL, 0x040fe400078efcffULL,
0x0000003903037812ULL, 0x000fe400078efcffULL, 0xff80000032327808ULL, 0x000fe40005800000ULL,
0xff80000030307808ULL, 0x000fc40005800000ULL, 0xff80000033337808ULL, 0x000fe40005000000ULL,
0xff80000031317808ULL, 0x000fe40005000000ULL, 0xff80000036367808ULL, 0x000fe40004800000ULL,
0xff80000034347808ULL, 0x000fe40004800000ULL, 0x0000001f0d00720cULL, 0x080fe40003f66070ULL,
0x0000001f0c00720cULL, 0x000fc40003f46070ULL, 0x0000001f0300720cULL, 0x000fe40003f26070ULL,
0xff80000037377808ULL, 0x000fe40004000000ULL, 0xff80000035357808ULL, 0x000fe40004000000ULL,
0xff8000003a3a7808ULL, 0x000fe40006000000ULL, 0xff80000038387808ULL, 0x000fe40006000000ULL,
0xff8000003b3b7808ULL, 0x000fc40007000000ULL, 0xff80000039397808ULL, 0x000fe40007000000ULL,
0xff8000003e3e7808ULL, 0x000fe40006800000ULL, 0xff8000003c3c7808ULL, 0x000fe40006800000ULL,
0xff8000003f3f7808ULL, 0x000fe40005800000ULL, 0xff8000003d3d7808ULL, 0x000fe40005800000ULL,
0xff80000026267808ULL, 0x000fc40005000000ULL, 0xff80000024247808ULL, 0x000fe40005000000ULL,
0xff80000027277808ULL, 0x000fe40004800000ULL, 0xff80000025257808ULL, 0x000fc40004800000ULL,
0x000000140800720bULL, 0x008fe20003f1e000ULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x000000160900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff1a7424ULL, 0x000fe200078e00ffULL,
0x0000000814087208ULL, 0x000fe40004000000ULL, 0x00000009160c7208ULL, 0x000fc40004800000ULL,
0x000000150800720bULL, 0x000fe40003f1e000ULL, 0x000000170c00720bULL, 0x000fe40003f3e000ULL,
0x0000000815037208ULL, 0x000fe40004000000ULL, 0x0000000c17097208ULL, 0x000fe40004800000ULL,
0x000000280300720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fc40003f3e000ULL,
0x0000000328087208ULL, 0x000fe40004000000ULL, 0x000000092a0c7208ULL, 0x000fe40004800000ULL,
0x000000290800720bULL, 0x000fe40003f1e000ULL, 0x0000002b0c00720bULL, 0x000fe40003f3e000ULL,
0x0000000829037208ULL, 0x000fe40004000000ULL, 0x0000000c2b097208ULL, 0x000fc40004800000ULL,
0x0000002c0300720bULL, 0x000fe40003f1e000ULL, 0x0000002e0900720bULL, 0x000fe40003f3e000ULL,
0x000000032c087208ULL, 0x000fe40004000000ULL, 0x000000092e0c7208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x0000002f0c00720bULL, 0x000fc40003f3e000ULL,
0x000000082d037208ULL, 0x000fe40004000000ULL, 0x0000000c2f097208ULL, 0x000fe40004800000ULL,
0x000000300300720bULL, 0x000fe40003f1e000ULL, 0x000000320900720bULL, 0x000fe40003f3e000ULL,
0x0000000330087208ULL, 0x000fe40004000000ULL, 0x00000009320c7208ULL, 0x000fc40004800000ULL,
0x000000310800720bULL, 0x000fe40003f1e000ULL, 0x000000330c00720bULL, 0x000fe40003f3e000ULL,
0x0000000831037208ULL, 0x000fe40004000000ULL, 0x0000000c33097208ULL, 0x000fe40004800000ULL,
0x000000340300720bULL, 0x000fe40003f1e000ULL, 0x000000360900720bULL, 0x000fc40003f3e000ULL,
0x0000000334087208ULL, 0x000fe40004000000ULL, 0x00000009360c7208ULL, 0x000fe40004800000ULL,
0x000000350800720bULL, 0x000fe40003f1e000ULL, 0x000000370c00720bULL, 0x000fe40003f3e000ULL,
0x0000000835037208ULL, 0x000fe40004000000ULL, 0x0000000c37097208ULL, 0x000fc40004800000ULL,
0x000000380300720bULL, 0x000fe40003f1e000ULL, 0x0000003a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000338087208ULL, 0x000fe40004000000ULL, 0x000000093a0c7208ULL, 0x000fe40004800000ULL,
0x000000390800720bULL, 0x000fe40003f1e000ULL, 0x0000003b0c00720bULL, 0x000fc40003f3e000ULL,
0x0000000839037208ULL, 0x000fe40004000000ULL, 0x0000000c3b097208ULL, 0x000fe40004800000ULL,
0x0000003c0300720bULL, 0x000fe40003f1e000ULL, 0x0000003e0900720bULL, 0x000fe40003f3e000ULL,
0x000000033c087208ULL, 0x000fe40004000000ULL, 0x000000093e0c7208ULL, 0x000fc40004800000ULL,
0x0000003d0800720bULL, 0x000fe40003f1e000ULL, 0x0000003f0c00720bULL, 0x000fe40003f3e000ULL,
0x000000083d037208ULL, 0x000fe40004000000ULL, 0x0000000c3f097208ULL, 0x000fe40004800000ULL,
0x000000240300720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fc40003f3e000ULL,
0x0000000324087208ULL, 0x000fe40004000000ULL, 0x00000009260c7208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fe40003f1e000ULL, 0x000000270c00720bULL, 0x000fe40003f3e000ULL,
0x00000008250e7208ULL, 0x000fe40004000000ULL, 0x0000000c27107208ULL, 0x000fe20004800000ULL,
0x000015627f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e037f89ULL, 0x00066400000e0000ULL,
0x000000030e00720bULL, 0x006fc80003f1e000ULL, 0x0000000e03127208ULL, 0x000fe20004000000ULL,
0x000015627f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010037f89ULL, 0x000e6800000e0000ULL,
0x0c401f000a097f89ULL, 0x000ea800000e0000ULL, 0x0c401f000b087f89ULL, 0x000f2200000e0000ULL,
0x000000031000720bULL, 0x002fc40003f1e000ULL, 0x000000090a00720bULL, 0x004fe40003f3e000ULL,
0x0000001003037208ULL, 0x000fe40004000000ULL, 0x0000000a090c7208ULL, 0x000fe40004800000ULL,
0x0c201f0012097f89ULL, 0x000e6200000e0000ULL, 0x000000080b00720bULL, 0x010fc60003f1e000ULL,
0x0c201f00030e7f89ULL, 0x008ea200000e0000ULL, 0x0000000b08107208ULL, 0x000fc60004000000ULL,
0x0c201f000c0d7f89ULL, 0x000ee800000e0000ULL, 0x0c201f0010137f89ULL, 0x0002e400000e0000ULL,
0x000000091200720bULL, 0x002fe40003f1e000ULL, 0x0000000e0300720bULL, 0x004fe40003f3e000ULL,
0x0000001209087208ULL, 0x000fc40004000000ULL, 0x0000000d0c00720bULL, 0x008fe40003f5e000ULL,
0x000000030e097208ULL, 0x000fe40004800000ULL, 0x0000000c0d0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b08037820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b09197820ULL, 0x000fe20000410000ULL,
0x3c003c00ff407424ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b28287823ULL, 0x000fe20000010803ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2b2b7823ULL, 0x000fe20000010819ULL,
0x00000014000c7308ULL, 0x000fe20000000800ULL, 0x3c003c00ff417424ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b31317823ULL, 0x000fe20000010803ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010819ULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b33337823ULL, 0x000fe20000010819ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010803ULL,
0x00000028000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b25037823ULL, 0x000fe20000010803ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010819ULL,
0x0000002900297308ULL, 0x000ea20000000800ULL, 0x0000000c150c723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b271f7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b3f3f7823ULL, 0x000fe20000010819ULL, 0x0000000322ff7812ULL, 0x000fc4000780c0ffULL,
0x000000131000720bULL, 0x000fe20003f3e000ULL, 0x00000016000d7308ULL, 0x000ff00000000800ULL,
0x0000001700147308ULL, 0x000e620000000800ULL, 0x0000000e290e723eULL, 0x004fce00000000ffULL,
0x0000002a000f7308ULL, 0x000ff00000000800ULL, 0x0000002b001c7308ULL, 0x000ea20000000800ULL,
0x0000000d140d723eULL, 0x002fce00000000ffULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x0000000f1c0f723eULL, 0x004fce00000000ffULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x000000400c28723cULL, 0x000f6e00000018ffULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x0000002c2d14723eULL, 0x002fc400000000ffULL,
0x00000002ff2c7819ULL, 0x000fc80000011622ULL, 0x000000022c2d7810ULL, 0x000fe20007ffe0ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x000000303116723eULL, 0x004fc400000000ffULL, 0x0000000c07307812ULL, 0x000fca00078ec0ffULL,
0x0000003200327308ULL, 0x000ff00000000800ULL, 0x0000003300177308ULL, 0x000ea20000000800ULL,
0x0000002e2f15723eULL, 0x002fe200000000ffULL, 0x000000082c2f7824ULL, 0x000fcc00078e00ffULL,
0x0000000300127308ULL, 0x0003e20000000800ULL, 0x000000321717723eULL, 0x004fce00000000ffULL,
0x00000024000b7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b26037823ULL, 0x002fe20000010819ULL,
0x000000082c327824ULL, 0x040fe200078e00ffULL, 0x000000012c197810ULL, 0x000fc80007ffe0ffULL,
0xfffffff832327812ULL, 0x000fe200078ee219ULL, 0x0000003400187308ULL, 0x0003e20000000800ULL,
0x000000401424723cULL, 0x024b6e0000001828ULL, 0x0000003500357308ULL, 0x000ea20000000800ULL,
0x000000082c2b7824ULL, 0x060fe200078e00ffULL, 0x000000032c287810ULL, 0x040fe20007ffe0ffULL,
0x000000082c347824ULL, 0x042fe200078e00ffULL, 0x000000042c297810ULL, 0x000fc40007ffe0ffULL,
0xffffffff2c2a7810ULL, 0x000fe40007ffe0ffULL, 0x00000038001a7308ULL, 0x0003e20000000800ULL,
0xfffffff834347812ULL, 0x000fe200078ee22dULL, 0x000000082c2d7824ULL, 0x000fca00078e00ffULL,
0xfffffff82d2e7812ULL, 0x000fe200078ee22cULL, 0x0000003900397308ULL, 0x000ee20000000800ULL,
0x000000183518723eULL, 0x004fe400000000ffULL, 0xfffffff82b387812ULL, 0x002fe400078ee228ULL,
0x000000082c2b7810ULL, 0x040fe40007ffe0ffULL, 0x000000052c287810ULL, 0x000fe20007ffe0ffULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0xfffffff82d427812ULL, 0x000fe200078ee22aULL,
0x000000082b487824ULL, 0x000fe200078e00ffULL, 0x0000000b122a723eULL, 0x000fc400000000ffULL,
0x0000a000000b7811ULL, 0x000fe400078e58ffULL, 0xfffffff848487812ULL, 0x000fe200078ee22bULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x0000001a391a723eULL, 0x008fe200000000ffULL,
0x0000001032077824ULL, 0x100fe400078e020bULL, 0x0000001034127824ULL, 0x000fe400078e020bULL,
0x0000000130077824ULL, 0x040fe400078e0207ULL, 0x0000003a001b7308ULL, 0x0005e20000000800ULL,
0x0000000130127824ULL, 0x000fce00078e0212ULL, 0x0000003b001c7308ULL, 0x000ee20000000800ULL,
0x000000363719723eULL, 0x002fe200000000ffULL, 0x000000082c3a7824ULL, 0x044fe400078e00ffULL,
0x000000082c367824ULL, 0x000fc600078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee229ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000062c297810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82f2c7812ULL, 0x000fe400078ee228ULL, 0xfffffff836367812ULL, 0x000fe400078ee229ULL,
0x0000001b1c1b723eULL, 0x008fe200000000ffULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0x000000102c2c7824ULL, 0x000fc400078e020bULL, 0x00000010362d7824ULL, 0x000fe400078e020bULL,
0x00000001302c7824ULL, 0x040fe200078e022cULL, 0x000000401824723cULL, 0x000f620000001824ULL,
0x00000001302d7824ULL, 0x000fe200078e022dULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000ea20000000800ULL, 0x0000003c3d28723eULL, 0x002fce00000000ffULL,
0x0000000300037308ULL, 0x000ff00000000800ULL, 0x0000001f001c7308ULL, 0x0002e20000000800ULL,
0x0000003e3f29723eULL, 0x004fe200000000ffULL, 0x000000103a1f7824ULL, 0x002fc800078e020bULL,
0x00000001301f7824ULL, 0x000fe200078e021fULL, 0x000000031c2b723eULL, 0x008fe200000000ffULL,
0x000000102e037824ULL, 0x100fe400078e020bULL, 0x00000010422e7824ULL, 0x100fe400078e020bULL,
0x00000010381c7824ULL, 0x000fe400078e020bULL, 0x000000402840723cULL, 0x020b620000001824ULL,
0x0000000130037824ULL, 0x040fe400078e0203ULL, 0x00000001301c7824ULL, 0x000fc400078e021cULL,
0x00000010480b7824ULL, 0x000fe200078e020bULL, 0x0000000c03007388ULL, 0x0003e20000000800ULL,
0x00000001302e7824ULL, 0x040fe400078e022eULL, 0x0000000130247824ULL, 0x020fe200078e020bULL,
0x0000000e07007388ULL, 0x0003e20000000800ULL, 0x00000010130b7208ULL, 0x000fc60004800000ULL,
0x0000001412007388ULL, 0x0003e80000000800ULL, 0x000000161c007388ULL, 0x0003e80000000800ULL,
0x000000181f007388ULL, 0x0003e40000000800ULL, 0x000000ffff417224ULL, 0x000fc400078e0042ULL,
0x0000001a2c007388ULL, 0x0003e80000000800ULL, 0x000000282d007388ULL, 0x0003e80000000800ULL,
0x0000002a2e007388ULL, 0x0003e80000000800ULL, 0x0000000d24007388ULL, 0x0003e80000000800ULL,
0x0004000f07007388ULL, 0x0003e80000000800ULL, 0x0004001512007388ULL, 0x0003e80000000800ULL,
0x000400171c007388ULL, 0x0003e80000000800ULL, 0x000400191f007388ULL, 0x0003e80000000800ULL,
0x0004001b2c007388ULL, 0x0003e80000000800ULL, 0x000400292d007388ULL, 0x0003e80000000800ULL,
0x0004002b2e007388ULL, 0x0003e80000000800ULL, 0x0140000802008388ULL, 0x0003e80000000c00ULL,
0x0142004002008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014608001eff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014610001eff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014618001eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000461100720cULL, 0x000fe20003f06070ULL, 0x014620001eff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff037224ULL, 0x002fd400078e0011ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff6ea000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047807ULL, 0x008fe40004000000ULL, 0x00019db000067802ULL, 0x000fc40000000f00ULL,
0x00000d1000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e000eULL,
0xfffe8ad000007947ULL, 0x000fea000383ffffULL, 0x00000001ff047807ULL, 0x000fe40005800000ULL,
0x00019e0000067802ULL, 0x000fc40000000f00ULL, 0x00000cc000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000eULL, 0xfffe8b1000007947ULL, 0x000fea000383ffffULL,
0x00019e4000047802ULL, 0x002fc40000000f00ULL, 0x00000c4000007944ULL, 0x01cfea0003c00000ULL,
0xfffe8bd000007947ULL, 0x000fea000383ffffULL, 0x00019e7000047802ULL, 0x002fc40000000f00ULL,
0x00000c1000007944ULL, 0x014fea0003c00000ULL, 0xfffe8d1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff067224ULL, 0x000fe200078e000cULL, 0x00019eb000047802ULL, 0x000fc40000000f00ULL,
0x00000bd000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff517224ULL, 0x004fe200078e0006ULL,
0xfffe8ed000007947ULL, 0x000fea000383ffffULL, 0x00019ef000047802ULL, 0x000fc40000000f00ULL,
0x00000b9000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff527224ULL, 0x004fe200078e0006ULL,
0xfffe8ec000007947ULL, 0x000fea000383ffffULL, 0x000000ffff067224ULL, 0x000fe200078e0018ULL,
0x00019f4000047802ULL, 0x000fc40000000f00ULL, 0x00000b4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff517224ULL, 0x004fe200078e0006ULL, 0xfffea22000007947ULL, 0x000fea000383ffffULL,
0x00019f8000047802ULL, 0x000fc40000000f00ULL, 0x00000b0000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff527224ULL, 0x004fe200078e0006ULL, 0xfffea21000007947ULL, 0x000fea000383ffffULL,
0x00000001ff047807ULL, 0x008fe40004000000ULL, 0x00019fd000067802ULL, 0x000fc40000000f00ULL,
0x00000af000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e000eULL,
0xfffeb7d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff047807ULL, 0x000fe40005000000ULL,
0x0001a02000067802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x014fea0003c00000ULL,
0xfffeb82000007947ULL, 0x000fea000383ffffULL, 0x0001a05000047802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x014fea0003c00000ULL, 0xfffeb90000007947ULL, 0x000fea000383ffffULL,
0x0001a08000047802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x016fea0003c00000ULL,
0xfffeba3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff067224ULL, 0x000fe200078e000cULL,
0x0001a0c000047802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff517224ULL, 0x004fe200078e0006ULL, 0xfffebbf000007947ULL, 0x000fea000383ffffULL,
0x0001a10000047802ULL, 0x000fc40000000f00ULL, 0x0000098000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff527224ULL, 0x004fe200078e0006ULL, 0xfffebbe000007947ULL, 0x000fea000383ffffULL,
0x000000ffff067224ULL, 0x000fe200078e000cULL, 0x0001a15000047802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff517224ULL, 0x004fe200078e0006ULL,
0xfffecc8000007947ULL, 0x000fea000383ffffULL, 0x0001a19000047802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff527224ULL, 0x004fe200078e0006ULL,
0xfffecc7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff047807ULL, 0x008fe40004000000ULL,
0x0001a1e000067802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000eULL, 0xfffee0d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff047807ULL, 0x000fe40005000000ULL, 0x0001a23000067802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x014fea0003c00000ULL, 0xfffee11000007947ULL, 0x000fea000383ffffULL,
0x0001a26000047802ULL, 0x000fc40000000f00ULL, 0x0000082000007944ULL, 0x014fea0003c00000ULL,
0xfffee1f000007947ULL, 0x000fea000383ffffULL, 0x0001a29000047802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x016fea0003c00000ULL, 0xfffee32000007947ULL, 0x000fea000383ffffULL,
0x000000ffff067224ULL, 0x000fe200078e000cULL, 0x0001a2d000047802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff517224ULL, 0x004fe200078e0006ULL,
0xfffee4e000007947ULL, 0x000fea000383ffffULL, 0x0001a31000047802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff527224ULL, 0x004fe200078e0006ULL,
0xfffee4d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff067224ULL, 0x000fe200078e0008ULL,
0x0001a36000047802ULL, 0x000fc40000000f00ULL, 0x0000072000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff517224ULL, 0x004fe200078e0006ULL, 0xfffef57000007947ULL, 0x000fea000383ffffULL,
0x0001a3a000047802ULL, 0x000fc40000000f00ULL, 0x000006e000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff527224ULL, 0x004fe200078e0006ULL, 0xfffef56000007947ULL, 0x000fea000383ffffULL,
0x00000001ff047807ULL, 0x008fe40004000000ULL, 0x0001a3f000067802ULL, 0x000fc40000000f00ULL,
0x000006d000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e000eULL,
0xffff09c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff047807ULL, 0x000fe40004800000ULL,
0x0001a44000067802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x014fea0003c00000ULL,
0xffff0a0000007947ULL, 0x000fea000383ffffULL, 0x0001a47000047802ULL, 0x000fc40000000f00ULL,
0x0000061000007944ULL, 0x014fea0003c00000ULL, 0xffff0ae000007947ULL, 0x000fea000383ffffULL,
0x0001a4a000047802ULL, 0x000fc40000000f00ULL, 0x000005e000007944ULL, 0x016fea0003c00000ULL,
0xffff0c1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff067224ULL, 0x000fe200078e000cULL,
0x0001a4e000047802ULL, 0x000fc40000000f00ULL, 0x000005a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff517224ULL, 0x004fe200078e0006ULL, 0xffff0dd000007947ULL, 0x000fea000383ffffULL,
0x0001a52000047802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff527224ULL, 0x004fe200078e0006ULL, 0xffff0dc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff067224ULL, 0x000fe200078e0028ULL, 0x0001a57000047802ULL, 0x000fc40000000f00ULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff517224ULL, 0x004fe200078e0006ULL,
0xffff1e9000007947ULL, 0x000fea000383ffffULL, 0x0001a5b000047802ULL, 0x000fc40000000f00ULL,
0x000004d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff527224ULL, 0x004fe200078e0006ULL,
0xffff1e8000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0001a600000c7802ULL, 0x000fc40000000f00ULL, 0x0000044000007944ULL, 0x006fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x008fe200078e0010ULL,
0x0001a650000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x000000031000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000aULL, 0x0001a6b0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001003187208ULL, 0x000fc80004000000ULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000030a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000bULL, 0x0001a710000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a030a7208ULL, 0x000fc80004000000ULL,
0x0000033000007944ULL, 0x000fea0003c00000ULL, 0x000000030b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0012ULL, 0x0001a770000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000b03107208ULL, 0x000fc80004000000ULL,
0x000002d000007944ULL, 0x000fea0003c00000ULL, 0x000000031200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0018ULL, 0x0001a7d0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001203087208ULL, 0x000fc80004000000ULL,
0x0000027000007944ULL, 0x000fea0003c00000ULL, 0x000000031800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000aULL, 0x0001a830000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001803097208ULL, 0x000fc80004000000ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000030a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0010ULL, 0x0001a890000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a030a7208ULL, 0x000fc80004000000ULL,
0x000001b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff137224ULL, 0x006fe200078e0003ULL,
0xffffe93000007947ULL, 0x000fea000383ffffULL, 0x0180000032047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003200048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff32ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff047807ULL, 0x000fc80000000000ULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000032057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003200047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x00cfe400078e0004ULL, 0x000000ffff047224ULL, 0x000fe400078e0006ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe55c004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000001a00007348ULL, 0x000fe80003800000ULL,
0x0c00000f0e037389ULL, 0x0002a200000e0013ULL, 0xfffe55800c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff057424ULL, 0x000fe200078e00ffULL, 0x0000004c00007348ULL, 0x000fe80003800000ULL,
0x0000000641067389ULL, 0x0002a200000e006bULL, 0xfffe554004007950ULL, 0x000fea0003c3ffffULL,
0x000000010400780cULL, 0x000fe20003f65070ULL, 0x0000004f00007348ULL, 0x000fe80003800000ULL,
0x00000000ff057424ULL, 0x000fd000078e00ffULL, 0x0000000000047806ULL, 0x000fc800058e0100ULL,
0x0000004f040e7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff047224ULL, 0x000fc800078e0006ULL,
0xfffe54d004007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000542ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a0ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008f8ULL,
0x00000000000002e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bd8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c98ULL,
0x0000000000000670ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001308ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001318ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013a8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013acULL,
0x00000000000001b0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x000000000001ac00ULL, 0x7a00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c180ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c1c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c540ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000013a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001add8ULL,
0x000000000001add8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c540ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_86_cubin_len = 116256;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
