/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001a9a0ULL, 0x000000000001a620ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45346aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x32336a4c4545346aULL, 0x61324545386a4c45ULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x6a4c45386a4c4545ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL, 0x5f7063725f30326dULL,
0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL,
0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL, 0x72665f6775626564ULL,
0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000366ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000003abULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a002200000406ULL, 0x00000000000192f0ULL,
0x0000000000000210ULL, 0x000400030000047cULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000019500ULL, 0x000d0003000004acULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000192f000000000ULL,
0x0000200400000000ULL, 0x01d0288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL,
0x0000006000000000ULL, 0x000192f000000000ULL, 0x0000021000000000ULL, 0x0000000000000000ULL,
0x0000001400082f04ULL, 0x0008230400000080ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x00081104000000d0ULL, 0x000000d000000012ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x000000d000000014ULL, 0x0000001400081104ULL, 0x00043704000000d0ULL, 0x000c17040000007bULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0x0000dac000083104ULL, 0x00f429040000df70ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00f42804ffffffffULL, 0x00000110000000d0ULL,
0x000019b000000690ULL, 0x00002bf000002b70ULL, 0x00002df000002cb0ULL, 0x0000307000003060ULL,
0x000043b000003550ULL, 0x00004770000043c0ULL, 0x00005840000057d0ULL, 0x00005a6000005920ULL,
0x00005c4000005c30ULL, 0x00006d0000005ee0ULL, 0x00006fe000006d10ULL, 0x000080a000008030ULL,
0x000082c000008180ULL, 0x000084a000008490ULL, 0x0000956000008740ULL, 0x0000984000009570ULL,
0x0000a9000000a890ULL, 0x0000ab200000a9e0ULL, 0x0000ad000000acf0ULL, 0x0000be000000afe0ULL,
0x0000c2100000be10ULL, 0x0000c7100000c220ULL, 0x0000df700000dac0ULL, 0x0000e3d00000e3a0ULL,
0x0000e8800000e860ULL, 0x000187500000ed00ULL, 0x00018a3000018800ULL, 0x00018d8000018ac0ULL,
0x00018ee000018e00ULL, 0x01f0390400018f50ULL, 0x000000ff000001c0ULL, 0x000401000001c600ULL,
0x00000002000002a0ULL, 0x003f01000001c608ULL, 0x00000002000003b0ULL, 0x003f01000001c688ULL,
0x000000ff000006f0ULL, 0x000401070001c600ULL, 0x0000005800000870ULL, 0x000401010001c688ULL,
0x0000005800002920ULL, 0x000401010001c608ULL, 0x0000005800002960ULL, 0x000401090001c608ULL,
0x0000005800002ad0ULL, 0x000401090001c608ULL, 0x000000ff000046c0ULL, 0x000401010001c688ULL,
0x00000058000055b0ULL, 0x000401010001c628ULL, 0x0000005800005600ULL, 0x000401090001c628ULL,
0x0000005800005770ULL, 0x000401090001c628ULL, 0x000000ff00006f50ULL, 0x000401010001c690ULL,
0x0000005800007e20ULL, 0x000401010001c648ULL, 0x0000005800007e70ULL, 0x000401090001c648ULL,
0x0000005800007fe0ULL, 0x000401090001c648ULL, 0x000000ff000097b0ULL, 0x000401010001c698ULL,
0x000000580000a680ULL, 0x000401010001c668ULL, 0x000000580000a6d0ULL, 0x000401090001c668ULL,
0x000000580000a840ULL, 0x000401090001c668ULL, 0x000000ff0000c000ULL, 0x000401010001c6a0ULL,
0x000000ff0000efc0ULL, 0x000401010001c600ULL, 0x000000ff00010d60ULL, 0x000401090001c600ULL,
0x000000ff00010ed0ULL, 0x000401090001c600ULL, 0x000000ff00017bc0ULL, 0x000801010001c688ULL,
0x000000ff00017e10ULL, 0x000801090001c688ULL, 0x000000ff00017f80ULL, 0x000801090001c688ULL,
0x000000ff00019290ULL, 0x000c01010001c608ULL, 0x000000ff000192a0ULL, 0x000c01010001c610ULL,
0x000000ff000192b0ULL, 0x000c01010001c618ULL, 0x000000ff000192c0ULL, 0x000c01010001c620ULL,
0x00101c0400033803ULL, 0x00010f100000ef80ULL, 0x000192e000010f70ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400501903ULL, 0x0050021000000015ULL,
0x00000000000000bcULL, 0x0000001400000002ULL, 0x00000000000192f0ULL, 0x0000000000000044ULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001400000002ULL,
0x0000000000000000ULL, 0x000000000001c700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000067919ULL, 0x000ea20000002100ULL,
0x0000030000107ab9ULL, 0x000fe20000000800ULL, 0x0000010000047ab9ULL, 0x000fca0000000800ULL,
0x00008800ff047b82ULL, 0x000ee20000000a00ULL, 0x0000000000087919ULL, 0x000f220000002300ULL,
0x000001a000007945ULL, 0x000fe20003800000ULL, 0xffffff3001017836ULL, 0x002fe20000000000ULL,
0x0000000000037919ULL, 0x000f280000002200ULL, 0x00000000000879c3ULL, 0x000e620000002700ULL,
0x0000000000007919ULL, 0x000e6e0000000000ULL, 0x00000000000979c3ULL, 0x000e620000002600ULL,
0x00000005ff027819ULL, 0x004fcc0000011606ULL, 0x00001fff02027589ULL, 0x000ea200000e0000ULL,
0x0000000408037c24ULL, 0x010fe2000f8e0203ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000403077c24ULL, 0x000fe4000f8e0206ULL, 0x00001fff08067589ULL, 0x00026600000e0000ULL,
0x000000ff0700720cULL, 0x040fe40003f05270ULL, 0x0000000f0700780cULL, 0x040fe40003f24070ULL,
0x000000030700780cULL, 0x000fe40003f44070ULL, 0x00000000021172caULL, 0x004fce00000e0000ULL,
0x0000000000240947ULL, 0x00aff00003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x004fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000eb40000000000ULL,
0x01c60006043f75b2ULL, 0x0004a40008000100ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000407027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01c60804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000407027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000020612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01c68804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000679c3ULL, 0x000ea20000008800ULL,
0x0000001106027c11ULL, 0x002fe2000f8e10ffULL, 0x00008400000d7ab9ULL, 0x000fe20000000800ULL,
0x0000000309047899ULL, 0x000fe2000800063fULL, 0x0000007f0700780cULL, 0x000fe20003f04070ULL,
0x000000030d057899ULL, 0x000fe2000800063fULL, 0x0000000202037824ULL, 0x000fe200078e00ffULL,
0x00008200000e7ab9ULL, 0x000fe40000000a00ULL, 0x00000008050472a4ULL, 0x000fe2000f8e0204ULL,
0x0000000103087824ULL, 0x040fe200078e0200ULL, 0x0000000803027848ULL, 0x000fe20007fe0000ULL,
0x00000020030f7824ULL, 0x000fc400078e00ffULL, 0x00000001030b7836ULL, 0x000fe40000000000ULL,
0x0000000102097824ULL, 0x000fe200078e0a03ULL, 0xffffffe00f0a7812ULL, 0x000fe200078ee208ULL,
0x0000000403037c36ULL, 0x000fe40008000000ULL, 0x000000040b0d7c36ULL, 0x000fe20008000000ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000001000087824ULL, 0x000fe200078e00ffULL,
0x000000ff0900720cULL, 0x000fe20003f23070ULL, 0x0000020003027825ULL, 0x000fe200078e0004ULL,
0x0000065406047896ULL, 0x004fe20008000004ULL, 0x000000010900780cULL, 0x000fc40003f43070ULL,
0x000002000d047825ULL, 0x000fe200078e0004ULL, 0x000001f0080d7812ULL, 0x000fe200078ec0ffULL,
0x0001c60004057890ULL, 0x000fe4000fffe03fULL, 0x0000000407078c11ULL, 0x000fe2000f8e10ffULL,
0x000000010b0c7824ULL, 0x040fe200078e0200ULL, 0x0000000d02027210ULL, 0x000fe20007f7e0ffULL,
0x000000200b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000d04047210ULL, 0x000fe20007f9e0ffULL,
0xff317217ff0e8424ULL, 0x000fe200078e00ffULL, 0x000000040a097c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200018e0603ULL, 0xffffffe00b0c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fe200020e0605ULL, 0x01c4000e07008388ULL, 0x0003e40000000800ULL,
0x000000040c0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000c901c4eULL,
0x00000000040b7faeULL, 0x0003e2000d101c4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200405ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a85ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00008e0000067ab9ULL, 0x000fc40000000a00ULL,
0x00000004080678a5ULL, 0x000fcc000f8e0006ULL, 0x00000006ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000007ff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000e02027981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x00000000000579c3ULL, 0x000e620000002500ULL,
0x00000000021372caULL, 0x004fda00000e0000ULL, 0x0000003f13067890ULL, 0x000fe4000fffe03fULL,
0x000000ff13077890ULL, 0x000fe4000fffe03fULL, 0x000000063f067899ULL, 0x000fe40008011606ULL,
0x000000083f077899ULL, 0x000fe20008011607ULL, 0x000000e400e48947ULL, 0x002ff60003800000ULL,
0x0000000205147899ULL, 0x000fe2000800063fULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x0000000311127899ULL, 0x000fe4000800063fULL, 0x000000061400728cULL, 0x000fe2000bf06070ULL,
0xffffffff000a7882ULL, 0x000fc60000000000ULL, 0x00000012ff587e24ULL, 0x000fe4000f8e00ffULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x01c6880358ff79a7ULL, 0x0003f60008500004ULL,
0x0000000000280947ULL, 0x002fea0003800000ULL, 0x00009000000c7ab9ULL, 0x000fe20000000800ULL,
0x00000001080a7899ULL, 0x000fe4000800063fULL, 0x0000000c140b7290ULL, 0x000fc8000fffe03fULL,
0x0000000c0a0c72a4ULL, 0x000fc6000f8e020bULL, 0x00008c00000a7ab9ULL, 0x000fe40000000a00ULL,
0x000000040c0a78a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000e02027981ULL, 0x000ea4000c1e1900ULL,
0x00000000020a72caULL, 0x004fde00000e0000ULL, 0x00000001050b7890ULL, 0x000fe4000fffe03fULL,
0x0000000609097899ULL, 0x000fe4000800063fULL, 0x000000070b00728cULL, 0x000fe4000bf06070ULL,
0x0000000d0a0b72a4ULL, 0x000fc8000f8e023fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000060b0c7899ULL, 0x000fd8000800063fULL, 0x0000000400e48947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000002600ULL, 0x00000003ff0b7819ULL, 0x000fe20000011600ULL,
0x00000008050b7899ULL, 0x000fe2000800063fULL, 0x00008a0000167ab9ULL, 0x000fc60000000a00ULL,
0x000000040b057836ULL, 0x000fe20000000000ULL, 0x0000000b1300728cULL, 0x000fe2000bf01070ULL,
0x000000080b077836ULL, 0x000fe40000000000ULL, 0x0000000105027824ULL, 0x140fe200078e0200ULL,
0x0000000b130d7287ULL, 0x000fe2000c000000ULL, 0x00000008050d7824ULL, 0x000fe400078e00ffULL,
0x0000000c0b097836ULL, 0x000fe40000000000ULL, 0x0000000107037824ULL, 0x040fe200078e0200ULL,
0xfffffff80d147812ULL, 0x000fe200078ee202ULL, 0x0000000807167824ULL, 0x000fc400078e00ffULL,
0x000000100b117836ULL, 0x000fe40000000000ULL, 0x0000000109027824ULL, 0x140fe200078e0200ULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x00000008090d7824ULL, 0x000fe400078e00ffULL,
0x000000140b177836ULL, 0x000fe40000000000ULL, 0x0000000111037824ULL, 0x040fe200078e0200ULL,
0xfffffff80d187812ULL, 0x000fe200078ee202ULL, 0x00000008111a7824ULL, 0x000fc400078e00ffULL,
0x0000000117027824ULL, 0x140fe400078e0200ULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x0000001c0b1d7836ULL, 0x000fe40000000000ULL,
0x000000180b197836ULL, 0x000fe20000000000ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL,
0x000000011d037824ULL, 0x040fe400078e0200ULL, 0x000000081d1e7824ULL, 0x000fc400078e00ffULL,
0x000000400e0e7824ULL, 0x002fe400078e020bULL, 0x0000000119027824ULL, 0x040fe200078e0200ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x00000008190d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e037c10ULL, 0x000fe2000ff1e0ffULL, 0x8000000bff127e24ULL, 0x000fe2000f8e02ffULL,
0x00000004110b7291ULL, 0x000fe2000f8e683fULL, 0x000000040e047836ULL, 0x000fe20000000000ULL,
0xfffffff80d1c7812ULL, 0x000fe200078ee202ULL, 0x0000000dff0d7e24ULL, 0x000fe2000f8e00ffULL,
0x00000003110d7899ULL, 0x000fe2000800063fULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000001603027c11ULL, 0x040fe2000f8048ffULL, 0x000000080e067836ULL, 0x000fe20000000000ULL,
0x000000200d127446ULL, 0x000fe20003800012ULL, 0x000000140e0c7836ULL, 0x000fe20000000000ULL,
0x0000001703037c11ULL, 0x000fe200080f4c08ULL, 0x000140000b0b7890ULL, 0x000fe2000fffe03fULL,
0x0000000c040a7c10ULL, 0x000fc4000ff3e0ffULL, 0x000000120500720cULL, 0x080fe20003f06070ULL,
0x0000000c0e057836ULL, 0x000fe20000000000ULL, 0x0000000c06087c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x000000160a047c11ULL, 0x000fe4000f8248ffULL,
0x0000000c050d7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x0000001608067c11ULL, 0x000fe4000f8448ffULL, 0x000000170a057c11ULL, 0x000fe200088f4c13ULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x000000120700720cULL, 0x000fe20003f26070ULL,
0x000000100e0a7836ULL, 0x000fe20000000000ULL, 0x0000001708077c11ULL, 0x000fe200090f4c0fULL,
0x000000010b0f7824ULL, 0x000fe200078e0200ULL, 0x000000160d087c11ULL, 0x000fc4000f8648ffULL,
0x000000120900720cULL, 0x000fe40003f46070ULL, 0x000000170d097c11ULL, 0x000fe400098f4c10ULL,
0x0000000c0c0d7c10ULL, 0x000fe4000ff9e0ffULL, 0x0000000c0a137c10ULL, 0x000fe4000ff7e0ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x000000160d0c7c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x00000016130a7c11ULL, 0x000fc4000f8648ffULL, 0x000000170d0d7c11ULL, 0x000fe2000a0f4c10ULL,
0x000000180e107836ULL, 0x000fe20000000000ULL, 0x000000120b00720cULL, 0x000fe20003fa6070ULL,
0x0000001c0e0e7836ULL, 0x000fe20000000000ULL, 0x00000017130b7c11ULL, 0x000fe200098f4c20ULL,
0x0000000dff137e24ULL, 0x000fe2000f8e00ffULL, 0x0ffffff80f0f7812ULL, 0x000fe400078ef800ULL,
0x0000000c10107c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000b0f157c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff813137812ULL, 0x000fe200078ee200ULL, 0x000000ffff0f7224ULL, 0x000fe200018e06ffULL,
0x0000000c0e1f7c10ULL, 0x000fe4000ff9e0ffULL, 0x00000016100e7c11ULL, 0x040fe2000f8c48ffULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x000000121100720cULL, 0x080fe40003f66070ULL,
0x00000017100f7c11ULL, 0x000fe2000b0f4c0fULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x000000161f107c11ULL, 0x000fe2000f8848ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000e901c4eULL, 0x000000121700720cULL, 0x000fe20003fc6070ULL,
0x0000001013047825ULL, 0x000fe200078e0004ULL, 0x000000171f117c11ULL, 0x000fc4000a0f4c20ULL,
0x000000121900720cULL, 0x080fe20003fa6070ULL, 0x0000001013067825ULL, 0x000fe200078e0006ULL,
0x000000121d00720cULL, 0x000fe40003f86070ULL, 0x0000000b14177c11ULL, 0x000fe2000f8e20ffULL,
0x0000001013087825ULL, 0x000fe200078e0008ULL, 0x0000000b16197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b1b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001013027825ULL, 0x002fe200078e000cULL,
0x0000000004177faeULL, 0x0003e2000c101c4eULL, 0x0000000b1c157c11ULL, 0x000fc4000f8e20ffULL,
0x00000010130c7825ULL, 0x040fe200078e000eULL, 0x0000000006197faeULL, 0x0003e2000c901c4eULL,
0x0000000b1e1d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000010130e7825ULL, 0x000fe200078e0010ULL,
0x0000000b18117c11ULL, 0x000fc6000f8e20ffULL, 0x00000010130a7825ULL, 0x000fe200078e000aULL,
0x0000000b1a137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000008117faeULL, 0x0003e8000d101c4eULL,
0x000000000a137faeULL, 0x0003e8000d901c4eULL, 0x00000000021b7faeULL, 0x0003e8000f101c4eULL,
0x000000000c157faeULL, 0x0003e8000e901c4eULL, 0x000000000e1d7faeULL, 0x0003e2000e101c4eULL,
0x0000000400a07947ULL, 0x000fea0003800000ULL, 0x0000000400037811ULL, 0x040fe200078fe8ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000000800057811ULL, 0x040fe200078fe8ffULL,
0x00000003110d7899ULL, 0x000fe2000800063fULL, 0x0000000c00077811ULL, 0x040fe200078fe8ffULL,
0x0000000103027824ULL, 0x140fe200078e0200ULL, 0x00000010000d7811ULL, 0x040fe200078fe8ffULL,
0x0000000803097824ULL, 0x000fe200078e00ffULL, 0x00000014000f7811ULL, 0x040fe200078fe8ffULL,
0x0000000105047824ULL, 0x100fe200078e0200ULL, 0x0000001c00137811ULL, 0x040fe200078fe8ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff809127812ULL, 0x000fe200078ee202ULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000001800117811ULL, 0x040fe200078fe8ffULL,
0x0000000107027824ULL, 0x100fe200078e0200ULL, 0x00000000000a7211ULL, 0x000fe200078fe8ffULL,
0x000000080f197824ULL, 0x000fe200078e00ffULL, 0xfffffff809147812ULL, 0x000fe200078ee204ULL,
0x000000080d097824ULL, 0x040fe200078e00ffULL, 0xfffffff80b167812ULL, 0x000fe200078ee202ULL,
0x000000010d027824ULL, 0x100fe200078e0200ULL, 0x00000004110b7291ULL, 0x000fe2000f8e683fULL,
0x000000010f047824ULL, 0x000fc400078e0200ULL, 0x0000000113067824ULL, 0x140fe200078e0200ULL,
0xfffffff809187812ULL, 0x000fe200078ee202ULL, 0x00000008130b7824ULL, 0x000fe200078e00ffULL,
0x0000000900027c11ULL, 0x000fe2000f8fe8ffULL, 0x0000000903037c36ULL, 0x000fe20008000000ULL,
0xfffffff819197812ULL, 0x000fe200078ee204ULL, 0x0000000111047824ULL, 0x040fe200078e0200ULL,
0x0000000c02087c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000811097824ULL, 0x000fe200078e00ffULL,
0xfffffff80b1c7812ULL, 0x000fe200078ee206ULL, 0x0000000905057c36ULL, 0x000fe20008000000ULL,
0x0000000c03067c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0xfffffff8091a7812ULL, 0x000fe200078ee204ULL, 0x0000000907077c36ULL, 0x000fe20008000000ULL,
0x0000001608027c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000001606047c11ULL, 0x000fe2000f8248ffULL, 0x000000090d0d7c36ULL, 0x000fe20008000000ULL,
0x0000001708037c11ULL, 0x000fe200080f4c03ULL, 0x000000090f0f7c36ULL, 0x000fe20008000000ULL,
0x0000000c050b7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000911117c36ULL, 0x000fe20008000000ULL,
0x0000001706057c11ULL, 0x000fe200088f4c09ULL, 0x0000000913137c36ULL, 0x000fe20008000000ULL,
0x0000000c07097c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x000000160b067c11ULL, 0x000fe2000f8048ffULL, 0x0000000dff1b7e24ULL, 0x000fe2000f8e00ffULL,
0x000140000b0b7890ULL, 0x000fe2000fffe03fULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000001609087c11ULL, 0x000fc4000f8248ffULL, 0x000000170b077c11ULL, 0x000fe400080f4c0eULL,
0x0000001709097c11ULL, 0x000fe400088f4c0cULL, 0x0000000c0d157c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000c0f0d7c10ULL, 0x000fe4000ff3e0ffULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x0000000c110f7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff227224ULL, 0x000fe200008e06ffULL, 0x0000000c13117c10ULL, 0x000fc4000ff7e0ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef800ULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00000016150a7c11ULL, 0x000fe2000f8048ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x000000160d0c7c11ULL, 0x000fe4000f8248ffULL, 0x000000160f0e7c11ULL, 0x000fe2000f8448ffULL,
0x000000101b047825ULL, 0x000fe200078e0004ULL, 0x0000001611107c11ULL, 0x000fc4000f8648ffULL,
0x0000000b0b137c11ULL, 0x000fe2000f8e20ffULL, 0x000000101b067825ULL, 0x000fe200078e0006ULL,
0x00000017150b7c11ULL, 0x000fe400080f4c24ULL, 0x000000170d0d7c11ULL, 0x000fe200088f4c22ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002137faeULL, 0x0003e2000b901c4eULL,
0x000000170f0f7c11ULL, 0x000fe200090f4c20ULL, 0x000000101b087825ULL, 0x000fe200078e0008ULL,
0x0000001711117c11ULL, 0x000fe400098f4c1eULL, 0x0000000b12157c11ULL, 0x000fe2000f8e20ffULL,
0x000000101b0a7825ULL, 0x000fe200078e000aULL, 0x0000000b14177c11ULL, 0x000fc4000f8e20ffULL,
0x0000000b19197c11ULL, 0x000fe2000f8e20ffULL, 0x000000101b0c7825ULL, 0x040fe200078e000cULL,
0x0000000004157faeULL, 0x0005e2000b901c4eULL, 0x0000000b16037c11ULL, 0x002fe4000f8e20ffULL,
0x0000000b18137c11ULL, 0x000fe2000f8e20ffULL, 0x000000101b0e7825ULL, 0x040fe200078e000eULL,
0x0000000006177faeULL, 0x0005e2000b901c4eULL, 0x0000000b1c1d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000101b107825ULL, 0x000fe200078e0010ULL, 0x0000000b1a1b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000008037faeULL, 0x0005e8000b901c4eULL, 0x000000000a137faeULL, 0x0005e8000b901c4eULL,
0x000000000c197faeULL, 0x0005e8000b901c4eULL, 0x000000000e1b7faeULL, 0x0005e8000b901c4eULL,
0x00000000101d7faeULL, 0x0005e4000b901c4eULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff097424ULL, 0x006fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000000a400f40947ULL, 0x000fec0003800000ULL, 0x0000000108087899ULL, 0x000fe2000800063fULL,
0xff317217ff097424ULL, 0x000fe200078e00ffULL, 0x00009000000b7ab9ULL, 0x000fe20000000800ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x0000000b080872a4ULL, 0x000fd8000f8e020bULL,
0x00000008050b7899ULL, 0x000fc8000800063fULL, 0x000000130b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000a400c00947ULL, 0x000fea0003800000ULL,
0x00000001050c7890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x000000070c00728cULL, 0x000fc6000bf06070ULL, 0x00008400000c7ab9ULL, 0x000fe40000000800ULL,
0x0000000c0a0c72a4ULL, 0x000fe2000f8e023fULL, 0x000000000000781cULL, 0x000fc60003f2f008ULL,
0x000000060c0c7899ULL, 0x000fd4000800063fULL, 0x0000000400e09947ULL, 0x000fea0003800000ULL,
0x00000003ff177819ULL, 0x100fe20000011600ULL, 0x00000020090d7890ULL, 0x000fe4000fffe03fULL,
0x000000200b0a7890ULL, 0x000fe4000fffe03fULL, 0x0000000417137836ULL, 0x000fe20000000000ULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000000817187836ULL, 0x000fe20000000000ULL,
0x0000000a1300728cULL, 0x000fe2000bf01070ULL, 0x0000000113037824ULL, 0x040fe400078e0200ULL,
0x0000000813087824ULL, 0x000fe200078e00ffULL, 0x0000000a130b7287ULL, 0x000fe2000c000000ULL,
0x0000000c171b7836ULL, 0x000fc40000000000ULL, 0x0000000118047824ULL, 0x140fe200078e0200ULL,
0xfffffff8083d7812ULL, 0x000fe200078ee203ULL, 0x00000008180b7824ULL, 0x000fe400078e00ffULL,
0x000000011b037824ULL, 0x140fe400078e0200ULL, 0x000000081b0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b3a7812ULL, 0x000fe200078ee204ULL, 0x0000001017387836ULL, 0x000fe40000000000ULL,
0x00000014173c7836ULL, 0x000fe20000000000ULL, 0xfffffff80a037812ULL, 0x000fe200078ee203ULL,
0x0000000138047824ULL, 0x000fc400078e0200ULL, 0x00000008380b7824ULL, 0x000fe400078e00ffULL,
0x0000000d170a7c36ULL, 0x000fe40008000000ULL, 0x000000013c087824ULL, 0x140fe200078e0200ULL,
0xfffffff80b047812ULL, 0x000fe200078ee204ULL, 0x000000083c0d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0a0b7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001c173f7836ULL, 0x000fe40000000000ULL,
0x0000000d130a7c36ULL, 0x000fe20008000000ULL, 0xfffffff80d087812ULL, 0x000fe200078ee208ULL,
0x000000013f0d7824ULL, 0x000fc400078e0200ULL, 0x000000083f407824ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x000000160b107c11ULL, 0x040fe2000f8048ffULL,
0x00000018173e7836ULL, 0x000fe20000000000ULL, 0xfffffff840407812ULL, 0x000fe200078ee20dULL,
0x8000000aff157e24ULL, 0x000fe2000f8e02ffULL, 0x000000170b117c11ULL, 0x000fe200080f4c0cULL,
0x000000013e147824ULL, 0x040fe200078e0200ULL, 0x0000000c0a0d7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000083e0f7824ULL, 0x000fe200078e00ffULL, 0x00000004110a7291ULL, 0x000fe2000f8e683fULL,
0x0000000d180a7c36ULL, 0x000fc40008000000ULL, 0x0000000bff127e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff80f147812ULL, 0x000fe200078ee214ULL, 0x0000000d1b0b7c36ULL, 0x000fe20008000000ULL,
0x0000000c0a0f7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x000000160d0c7c11ULL, 0x040fe2000f8048ffULL, 0x000150000a0a7890ULL, 0x000fe2000fffe03fULL,
0x0000002012157446ULL, 0x000fe20003800015ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000000c0b0b7c10ULL, 0x000fe4000ff7e0ffULL, 0x000000170d0d7c11ULL, 0x000fc400080f4c0eULL,
0x000000160f0e7c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x000000160b0a7c11ULL, 0x000fe4000f8448ffULL, 0x000000170f0f7c11ULL, 0x000fe200080f4c12ULL,
0x0000000d38127c36ULL, 0x000fe20008000000ULL, 0x000000170b0b7c11ULL, 0x000fe400090f4c16ULL,
0x000000151300720cULL, 0x080fe40003fa6070ULL, 0x000000151700720cULL, 0x040fe20003f46070ULL,
0x0000000117177824ULL, 0x000fe200078e0200ULL, 0x0000000c12137c10ULL, 0x000fc4000ff7e0ffULL,
0x000000151800720cULL, 0x000fe40003f06070ULL, 0x0000000717197812ULL, 0x000fe200078ec0ffULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x0000001613127c11ULL, 0x040fe2000f8648ffULL,
0x0000000d3c177c36ULL, 0x000fe20008000000ULL, 0x0000000700167812ULL, 0x000fe400078ec0ffULL,
0x0000001713137c11ULL, 0x000fe200098f4c18ULL, 0x0000000d3e187c36ULL, 0x000fe20008000000ULL,
0x0000000c17177c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001216397c36ULL, 0x000fe20008000000ULL,
0x0ffffff819197812ULL, 0x000fc400078ef800ULL, 0x000000151b00720cULL, 0x000fe20003f86070ULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x0000001617167c11ULL, 0x000fe2000f8648ffULL,
0x0000001039107825ULL, 0x000fe200078e0010ULL, 0x0000000a193b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001717177c11ULL, 0x000fe200098f4c1aULL, 0x0000000d3f197c36ULL, 0x000fe20008000000ULL,
0x0000000c181a7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103b7faeULL, 0x0003e2000d101c4eULL, 0x0000000a3d3d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010390c7825ULL, 0x000fe200078e000cULL, 0x0000000c191b7c10ULL, 0x000fc4000ff5e0ffULL,
0x000000161a187c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff197224ULL, 0x000fe200018e06ffULL,
0x000000153800720cULL, 0x080fe20003f66070ULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x000000000c3d7faeULL, 0x0005e2000e901c4eULL, 0x000000153e00720cULL, 0x080fe20003fa6070ULL,
0x00000010390e7825ULL, 0x000fe200078e000eULL, 0x000000171a197c11ULL, 0x000fe4000b0f4c19ULL,
0x000000161b1a7c11ULL, 0x000fe2000f8448ffULL, 0x0000001039107825ULL, 0x002fe200078e0016ULL,
0x000000153c00720cULL, 0x000fc40003fc6070ULL, 0x000000171b1b7c11ULL, 0x000fe200090f4c38ULL,
0x00000010390a7825ULL, 0x000fe200078e000aULL, 0x000000153f00720cULL, 0x000fe40003f46070ULL,
0x0000000a3a157c11ULL, 0x000fe2000f8e20ffULL, 0x0000001039167825ULL, 0x000fe200078e0018ULL,
0x0000000a03037c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a04197c11ULL, 0x000fe2000f8e20ffULL,
0x0000001039127825ULL, 0x000fe200078e0012ULL, 0x000000000e157faeULL, 0x0003e2000c101c4eULL,
0x0000000a403b7c11ULL, 0x000fc4000f8e20ffULL, 0x00000010390c7825ULL, 0x004fe200078e001aULL,
0x0000000a081b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a037faeULL, 0x0003e2000e101c4eULL,
0x0000000a14397c11ULL, 0x000fc6000f8e20ffULL, 0x0000000012197faeULL, 0x0003e8000d901c4eULL,
0x00000000101b7faeULL, 0x0003e8000f101c4eULL, 0x0000000016397faeULL, 0x0003e8000e901c4eULL,
0x000000000c3b7faeULL, 0x0003e2000d101c4eULL, 0x0000000400a07947ULL, 0x000fea0003800000ULL,
0x00000004000b7811ULL, 0x040fe200078fe8ffULL, 0x00000020090b7890ULL, 0x000fe2000fffe03fULL,
0x00000008000f7811ULL, 0x040fe200078fe8ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000c00117811ULL, 0x040fe200078fe8ffULL, 0x000000010b037824ULL, 0x140fe200078e0200ULL,
0x0000001000137811ULL, 0x040fe200078fe8ffULL, 0x000000080b387824ULL, 0x000fe200078e00ffULL,
0x0000001400157811ULL, 0x040fe200078fe8ffULL, 0x000000010f047824ULL, 0x140fe200078e0200ULL,
0x0000001800177811ULL, 0x040fe200078fe8ffULL, 0x000000080f397824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee203ULL, 0x0000000111037824ULL, 0x140fe200078e0200ULL,
0x0000001c00197811ULL, 0x040fe200078fe8ffULL, 0x00000008113a7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee204ULL, 0x0000000113047824ULL, 0x140fe200078e0200ULL,
0x00000004110a7291ULL, 0x000fe2000f8e683fULL, 0x00000008133d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee203ULL, 0x0000000115087824ULL, 0x140fe200078e0200ULL,
0x0000000b00037c11ULL, 0x040fe2000f8fe8ffULL, 0x00000008153f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL, 0x0000000b0b047c36ULL, 0x000fe20008000000ULL,
0x00000007001a7812ULL, 0x000fe200078ec0ffULL, 0x00000001170d7824ULL, 0x140fe200078e0200ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee208ULL, 0x0000000817107824ULL, 0x000fe200078e00ffULL,
0x0000000c03087c10ULL, 0x000fe2000ff1e0ffULL, 0x00000001190e7824ULL, 0x040fe200078e0200ULL,
0x0000000c04047c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000819437824ULL, 0x000fe200078e00ffULL,
0xfffffff810417812ULL, 0x000fe200078ee20dULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00000016080c7c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff037224ULL, 0x000fe200010e06ffULL,
0x00000016040a7c11ULL, 0x000fe2000f8448ffULL, 0x000150000a0a7890ULL, 0x000fe2000fffe03fULL,
0x00000017080d7c11ULL, 0x000fe200080f4c0bULL, 0x0000000b13087c36ULL, 0x000fe20008000000ULL,
0x00000017040b7c11ULL, 0x000fe200090f4c03ULL, 0x0000000b0f037c36ULL, 0x000fe20008000000ULL,
0xfffffff843437812ULL, 0x000fe200078ee20eULL, 0x0000000b11047c36ULL, 0x000fe20008000000ULL,
0x0000000c08087c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000b150e7c36ULL, 0x000fe20008000000ULL,
0x0000000c03137c10ULL, 0x000fe2000ff5e0ffULL, 0x000000121a3b7c36ULL, 0x000fe20008000000ULL,
0x0000000c04117c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0x0000000c0e037c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x0000001613147c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001611127c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000001608107c11ULL, 0x000fe2000f8848ffULL, 0x000000103b0c7825ULL, 0x000fe200078e000cULL,
0x00000016030e7c11ULL, 0x000fc4000f8048ffULL, 0x0000001713157c11ULL, 0x000fe200090f4c18ULL,
0x000000103b0a7825ULL, 0x000fe200078e000aULL, 0x0000001711137c11ULL, 0x000fe400098f4c16ULL,
0x0000001708117c11ULL, 0x000fe2000a0f4c0fULL, 0x000000103b147825ULL, 0x000fe200078e0014ULL,
0x00000017030f7c11ULL, 0x000fe400080f4c04ULL, 0x0000000000167211ULL, 0x000fe200078fe8ffULL,
0x0000000b17037c36ULL, 0x000fe20008000000ULL, 0x0000000a39397c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b19047c36ULL, 0x000fe20008000000ULL, 0x0000000716197812ULL, 0x000fe200078ec0ffULL,
0x000000103b127825ULL, 0x000fe200078e0012ULL, 0x0000000c03087c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000c04047c10ULL, 0x000fe2000ff5e0ffULL, 0x000000103b107825ULL, 0x000fe200078e0010ULL,
0x0ffffff8191b7812ULL, 0x000fe400078ef800ULL, 0x0000000a3d3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x0000001608167c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x0000001604187c11ULL, 0x000fe2000f8448ffULL,
0x000000103b0e7825ULL, 0x000fe200078e000eULL, 0x0000001708177c11ULL, 0x000fc400080f4c17ULL,
0x0000001704197c11ULL, 0x000fe400090f4c03ULL, 0x0000000a1b037c11ULL, 0x000fe2000f8e20ffULL,
0x000000103b167825ULL, 0x000fe200078e0016ULL, 0x0000000a381b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a3f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000103b187825ULL, 0x000fe200078e0018ULL,
0x0000000a3a3b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c037faeULL, 0x0003e2000b901c4eULL, 0x0000000a41417c11ULL, 0x000fc4000f8e20ffULL,
0x0000000a43437c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a1b7faeULL, 0x0003e8000b901c4eULL,
0x0000000014397faeULL, 0x0003e8000b901c4eULL, 0x00000000123b7faeULL, 0x0003e8000b901c4eULL,
0x00000000103d7faeULL, 0x0003e8000b901c4eULL, 0x000000000e3f7faeULL, 0x0003e8000b901c4eULL,
0x0000000016417faeULL, 0x0003e8000b901c4eULL, 0x0000000018437faeULL, 0x0003e4000b901c4eULL,
0x00000003140b7892ULL, 0x000fe2000f8ec03fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd100a7891ULL, 0x000fe4000f8e103fULL, 0x000000030b00788cULL, 0x000fc8000bf05270ULL,
0x000000010a0a7887ULL, 0x000fc8000c000000ULL, 0x0000000a14147290ULL, 0x000fc8000fffe03fULL,
0x000000061400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000008140c8290ULL, 0x000fe2000fffe03fULL, 0x00008c00000a8ab9ULL, 0x000fc60000000a00ULL,
0x000000040c0a88a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff0a7e24ULL, 0x002fe4000f8e00ffULL,
0x0000000bff0b7e24ULL, 0x000fca000f8e00ffULL, 0x0000000e0a0a8981ULL, 0x000ea2000c1e1900ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0xffffffff000a7882ULL, 0x000fca0000000000ULL,
0x01c6080f580e79a7ULL, 0x000e620008500004ULL, 0x000000000a0b82caULL, 0x004fda00000e0000ULL,
0x0000000b000a8c82ULL, 0x000fe20008000000ULL, 0x00000000000a7805ULL, 0x000fe20000015200ULL,
0x01c6080f580075a7ULL, 0x002e640008000144ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a047210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e0bULL,
0x003d09000400780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400400780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140cULL, 0x0000000403037211ULL, 0x000fca00078110ffULL,
0x000000ffff047224ULL, 0x000fca00000e060cULL, 0x0000000203037819ULL, 0x000fc80000001204ULL,
0x000000030000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01c6080f580075a7ULL, 0x000e640008000144ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000001000037824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fc80000011600ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ec0ffULL, 0x0000000404037c10ULL, 0x000fca000fffe003ULL,
0x01c0000003087984ULL, 0x000e680000000800ULL, 0x01c2000003127984ULL, 0x0004a20000000800ULL,
0x000000090800720bULL, 0x002fda0003f1d000ULL, 0x0000000000047806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff040b7812ULL, 0x000fe2000784c0ffULL,
0x000000ffff047224ULL, 0x000fd800078e0009ULL, 0x0000000000e8a947ULL, 0x004fea0003800000ULL,
0x000000090800720bULL, 0x000fe40003f54000ULL, 0x00000011ff007c0cULL, 0x000fe4000bf65270ULL,
0x0000000809047209ULL, 0x000fd20007810000ULL, 0x00000000000c7806ULL, 0x000fe400010e0100ULL,
0x01c400040300b388ULL, 0x0003e40000000800ULL, 0x000099100c0a7816ULL, 0x000fc800000000ffULL,
0x000000ff0a00720cULL, 0x000fda0003f45270ULL, 0x0000000000b0a947ULL, 0x002fea0003800000ULL,
0x8000000409097221ULL, 0x000fe20000010000ULL, 0x000000ff0cff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff000cff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x00000009000a7308ULL, 0x0002ac0000000800ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x002fcc0000011600ULL, 0x00001f090a097589ULL, 0x004e6400000e0000ULL,
0x0000000934347220ULL, 0x082fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000930307220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x080fe20000410000ULL,
0x0000000944447220ULL, 0x080fe20000410000ULL, 0x0000000945457220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x0000000928287220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x080fe20000410000ULL,
0x0000000924247220ULL, 0x080fe20000410000ULL, 0x0000000925257220ULL, 0x080fe20000410000ULL,
0x0000000920207220ULL, 0x080fe20000410000ULL, 0x0000000921217220ULL, 0x080fe20000410000ULL,
0x000000091c1c7220ULL, 0x080fe20000410000ULL, 0x000000091d1d7220ULL, 0x000fce0000410000ULL,
0x0000000a02027220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000000800097811ULL, 0x002fcc00078ff0ffULL, 0x00001f090a097589ULL, 0x000e6400000e0000ULL,
0x0000000936367220ULL, 0x082fe20000410000ULL, 0x0000000937377220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x080fe20000410000ULL,
0x0000000946467220ULL, 0x080fe20000410000ULL, 0x0000000947477220ULL, 0x080fe20000410000ULL,
0x000000092e2e7220ULL, 0x080fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x000000092a2a7220ULL, 0x080fe20000410000ULL, 0x000000092b2b7220ULL, 0x080fe20000410000ULL,
0x0000000926267220ULL, 0x080fe20000410000ULL, 0x0000000927277220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x0000000923237220ULL, 0x080fe20000410000ULL,
0x000000091e1e7220ULL, 0x080fe20000410000ULL, 0x000000091f1f7220ULL, 0x000fce0000410000ULL,
0x0000ffff0bff7812ULL, 0x000fda000784600cULL, 0x8000000408082221ULL, 0x000fe20000010000ULL,
0x000000000000281cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b08082820ULL, 0x000fc80000410000ULL,
0x0000000800052308ULL, 0x000ea40000000800ULL, 0x0000000512122220ULL, 0x004fce0000410000ULL,
0x0000000700597812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000859097812ULL, 0x002fe400078ef800ULL, 0x00000008000b7812ULL, 0x040fe400078ec0ffULL,
0x0000000900087211ULL, 0x000fe200078fe0ffULL, 0x00000008090d7824ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fc800078ef800ULL, 0xfffffff80d4e7812ULL, 0x000fe200078ee208ULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x0000000b000c7211ULL, 0x000fe400078fe0ffULL,
0x000000044e4e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe40000011600ULL, 0x00000005ff06723eULL, 0x000fc600000000ffULL,
0x000000080d077836ULL, 0x000fe20000000000ULL, 0x00005410060a7816ULL, 0x000fca0000000006ULL,
0x00001f0d0a067589ULL, 0x0002a800000e0000ULL, 0x00001f070a077589ULL, 0x0002e400000e0000ULL,
0x012000004e14783bULL, 0x0002e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000614147232ULL, 0x08cfe40000000000ULL, 0x0000000616167232ULL, 0x000fe40000000000ULL,
0x0000000715157232ULL, 0x080fe40000000000ULL, 0x0000000717177232ULL, 0x000fce0000000000ULL,
0x000000080b0a7824ULL, 0x042fe200078e00ffULL, 0x00000004110b7291ULL, 0x000fe2000f8e683fULL,
0x000000040c117836ULL, 0x000fe20000000000ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL,
0x000000080b0d7824ULL, 0x040fe200078e00ffULL, 0x000140000b157890ULL, 0x000fe2000fffe03fULL,
0x000000020c107836ULL, 0x000fe20000000000ULL, 0xfffffff80a117812ULL, 0x000fe200078ee211ULL,
0x000000060c0a7836ULL, 0x000fe20000000000ULL, 0x000000100b0b7812ULL, 0x000fe200078efcffULL,
0x0000000809557824ULL, 0x000fe200078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x00000002080c7836ULL, 0x000fe20000000000ULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0x0000001511527c11ULL, 0x000fc4000f8e20ffULL,
0x000000150a537c11ULL, 0x000fe4000f8e20ffULL, 0x000000150f4d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000005238783bULL, 0x000e620000004200ULL, 0x0000001510507c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff855557812ULL, 0x000fe200078ee20cULL, 0x000000005318783bULL, 0x000f220000004200ULL,
0x0000000b000c7211ULL, 0x000fe400078fe0ffULL, 0x0000000455557c11ULL, 0x000fe2000f8e20ffULL,
0x000000004d40783bULL, 0x000f640000004200ULL, 0x000000020c0e7836ULL, 0x000fc40000000000ULL,
0x00000000503c783bULL, 0x000f620000004200ULL, 0x000000040c0d7836ULL, 0x000fe20000000000ULL,
0x000000381428723cULL, 0x00afec0000001828ULL, 0x000000181420723cULL, 0x010fe20000001820ULL,
0x000000080b387824ULL, 0x000fca00078e00ffULL, 0x0000001a141c723cULL, 0x000fe2000000181cULL,
0x000000080b197824ULL, 0x040fe400078e00ffULL, 0x000000080b187824ULL, 0x000fe400078e00ffULL,
0x000000060c0b7836ULL, 0x000fe20000000000ULL, 0xfffffff8130c7812ULL, 0x000fe200078ee20cULL,
0x000000401434723cULL, 0x020fe20000001834ULL, 0xfffffff8190e7812ULL, 0x000fe400078ee20eULL,
0xfffffff8180d7812ULL, 0x000fc400078ee20dULL, 0x012000005518783bULL, 0x0002e20000000200ULL,
0x000000421430723cULL, 0x000fe20000001830ULL, 0xfffffff8380b7812ULL, 0x000fe400078ee20bULL,
0x000000150e517c11ULL, 0x000fe4000f8e20ffULL, 0x000000150d4f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000003c1444723cULL, 0x004fe20000001844ULL, 0x000000150c547c11ULL, 0x000fca000f8e20ffULL,
0x0000003e142c723cULL, 0x000fec000000182cULL, 0x0000003a1424723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000108947ULL, 0x002fde0003800000ULL,
0x0000000618187232ULL, 0x088fe40000000000ULL, 0x000000061a1a7232ULL, 0x000fe40000000000ULL,
0x0000000719197232ULL, 0x080fe40000000000ULL, 0x000000071b1b7232ULL, 0x000fce0000000000ULL,
0x000000150b4c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000005114783bULL, 0x000e620000004200ULL,
0x00008400000c7ab9ULL, 0x000fe20000000800ULL, 0x0000000212027221ULL, 0x000fe20000010000ULL,
0x0000000c0a0c72a4ULL, 0x000fe2000f8e023fULL, 0x000000004f38783bULL, 0x000ea60000004200ULL,
0x000000060c0c7899ULL, 0x000fe2000800063fULL, 0x00000000543c783bULL, 0x000f280000004200ULL,
0x000000004c40783bULL, 0x000f620000004200ULL, 0x000000141844723cULL, 0x00afec0000001844ULL,
0x00000016182c723cULL, 0x000fec000000182cULL, 0x000000381828723cULL, 0x004fec0000001828ULL,
0x0000003a1824723cULL, 0x000fec0000001824ULL, 0x0000003c1834723cULL, 0x010fec0000001834ULL,
0x0000003e1830723cULL, 0x000fec0000001830ULL, 0x000000401820723cULL, 0x020fec0000001820ULL,
0x00000042181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400d09947ULL, 0x000fde0003800000ULL,
0x00000003ff197819ULL, 0x000fe20000011600ULL, 0x00000040050d7891ULL, 0x000fe2000f8e403fULL,
0x00008a0000187ab9ULL, 0x000fc60000000a00ULL, 0x00000004191b7836ULL, 0x000fe20000000000ULL,
0x0000000d1300728cULL, 0x000fe2000bf01070ULL, 0x0000000819577836ULL, 0x000fe40000000000ULL,
0x000000011b127824ULL, 0x140fe200078e0200ULL, 0x0000000d13167287ULL, 0x000fe2000c000000ULL,
0x000000081b3d7824ULL, 0x000fe400078e00ffULL, 0x00000014193f7836ULL, 0x000fe40000000000ULL,
0x0000000157567824ULL, 0x040fe200078e0200ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee212ULL,
0x0000000857137824ULL, 0x000fc400078e00ffULL, 0x000000013f417824ULL, 0x100fe200078e0200ULL,
0x000000153d5d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000083f127824ULL, 0x000fe200078e00ffULL,
0xfffffff813567812ULL, 0x000fe200078ee256ULL, 0x0000000c195b7836ULL, 0x000fe40000000000ULL,
0x00000010194b7836ULL, 0x000fe20000000000ULL, 0xfffffff812417812ULL, 0x000fe200078ee241ULL,
0x000000015b3e7824ULL, 0x040fe200078e0200ULL, 0x00000015565f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000085b137824ULL, 0x000fe200078e00ffULL, 0x0000001541417c11ULL, 0x000fe2000f8e20ffULL,
0x0000000919127c36ULL, 0x000fc40008000000ULL, 0x000000014b407824ULL, 0x040fe200078e0200ULL,
0xfffffff8133e7812ULL, 0x000fe200078ee23eULL, 0x000000084b157824ULL, 0x000fe200078e00ffULL,
0x0000000c12137c10ULL, 0x000fe2000ff5e0ffULL, 0x000000091b127c36ULL, 0x000fe40008000000ULL,
0x0000001819437836ULL, 0x000fe20000000000ULL, 0xfffffff815407812ULL, 0x000fe200078ee240ULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00000018133a7c11ULL, 0x000fe2000f8448ffULL,
0x0000001c19497836ULL, 0x000fc40000000000ULL, 0x0000000143427824ULL, 0x000fe200078e0200ULL,
0x00000019133b7c11ULL, 0x000fe200090f4c14ULL, 0x0000000843157824ULL, 0x000fe200078e00ffULL,
0x0000000c12147c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000149487824ULL, 0x040fe400078e0200ULL,
0x0000000849177824ULL, 0x000fe200078e00ffULL, 0xfffffff815427812ULL, 0x000fe200078ee242ULL,
0x8000000dff4a7e24ULL, 0x000fe4000f8e02ffULL, 0x00000016ff137e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff817487812ULL, 0x000fe200078ee248ULL, 0x0000000957127c36ULL, 0x000fc40008000000ULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0x00000020134a7446ULL, 0x000fe2000380004aULL,
0x000000095b137c36ULL, 0x000fe20008000000ULL, 0x0000000c12157c10ULL, 0x000fe2000ff9e0ffULL,
0x000000094b127c36ULL, 0x000fe20008000000ULL, 0x0000001814387c11ULL, 0x040fe2000f8448ffULL,
0x00000001193c7824ULL, 0x000fe200078e0200ULL, 0x0000000c13137c10ULL, 0x000fe2000ffbe0ffULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x0000001914397c11ULL, 0x000fe400090f4c17ULL,
0x00000018151a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff167224ULL, 0x000fe200028e06ffULL,
0x0000004a1b00720cULL, 0x000fc40003f66070ULL, 0x00000019151b7c11ULL, 0x000fe200090f4c18ULL,
0x000000093f187c36ULL, 0x000fe20008000000ULL, 0x0000000c12127c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001813147c11ULL, 0x000fe4000f8848ffULL, 0x0000004a5700720cULL, 0x000fe20003fa6070ULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0x0000001913157c11ULL, 0x000fe2000a0f4c16ULL,
0x0000000943577c36ULL, 0x000fe20008000000ULL, 0x0000001812167c11ULL, 0x000fc4000f8c48ffULL,
0x0ffffff800137812ULL, 0x000fe400078ec0ffULL, 0x0000004a1900720cULL, 0x080fe40003f86070ULL,
0x0000001912177c11ULL, 0x000fe2000b0f4c17ULL, 0x0000001259127c36ULL, 0x000fe20008000000ULL,
0x00000007133c7812ULL, 0x000fe400078ef83cULL, 0x0000004a5b00720cULL, 0x000fe20003f46070ULL,
0x00000010123a7825ULL, 0x000fe200078e003aULL, 0x000000153c5b7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000c18197c10ULL, 0x000fe2000ffde0ffULL, 0x00000010123c7825ULL, 0x040fe400078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a5b7faeULL, 0x0003e2000e101c4eULL,
0x0000000c57397c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff5a7224ULL, 0x000fe200030e06ffULL,
0x0000001819187c11ULL, 0x040fe2000f8c48ffULL, 0x0000000949387c36ULL, 0x000fe20008000000ULL,
0x000000003c5d7faeULL, 0x0005e2000d901c4eULL, 0x000000ffff567224ULL, 0x000fe200020e06ffULL,
0x0000001919197c11ULL, 0x000fe2000b0f4c5aULL, 0x00000010121a7825ULL, 0x000fe200078e001aULL,
0x0000000c38577c10ULL, 0x000fc4000ff7e0ffULL, 0x0000001839387c11ULL, 0x000fe2000f8c48ffULL,
0x0000001012147825ULL, 0x040fe200078e0014ULL, 0x0000004a4b00720cULL, 0x080fe20003f86070ULL,
0x000000001a5f7faeULL, 0x0007e2000e901c4eULL, 0x0000001939397c11ULL, 0x000fe2000b0f4c56ULL,
0x000000ffff567224ULL, 0x000fe200018e06ffULL, 0x00000018573a7c11ULL, 0x002fe2000f8648ffULL,
0x0000001012167825ULL, 0x040fe200078e0016ULL, 0x0000004a3f00720cULL, 0x080fe40003fc6070ULL,
0x0000004a4300720cULL, 0x000fe20003fa6070ULL, 0x0000001012187825ULL, 0x000fe200078e0018ULL,
0x00000019573b7c11ULL, 0x000fc400098f4c56ULL, 0x0000004a4900720cULL, 0x000fe20003f66070ULL,
0x0000001012387825ULL, 0x000fe200078e0038ULL, 0x000000153e3d7c11ULL, 0x004fe4000f8e20ffULL,
0x00000015403f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010123a7825ULL, 0x000fe200078e003aULL,
0x0000001542437c11ULL, 0x000fe2000f8e20ffULL, 0x00000000143d7faeULL, 0x0007e2000d101c4eULL,
0x0000001548497c11ULL, 0x000fc6000f8e20ffULL, 0x00000000163f7faeULL, 0x0007e8000e101c4eULL,
0x0000000018417faeULL, 0x0007e8000f101c4eULL, 0x0000000038437faeULL, 0x0007e8000e901c4eULL,
0x000000003a497faeULL, 0x0007e2000d901c4eULL, 0x0000000400907947ULL, 0x000fea0003800000ULL,
0x0000000400137811ULL, 0x040fe200078fe8ffULL, 0x00008a0000187ab9ULL, 0x000fe20000000a00ULL,
0x0000000800157811ULL, 0x040fe400078fe8ffULL, 0x00000010001b7811ULL, 0x040fe200078fe8ffULL,
0x00000001131a7824ULL, 0x140fe200078e0200ULL, 0x0000000c00197811ULL, 0x040fe200078fe8ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000001800497811ULL, 0x040fe200078fe8ffULL,
0x0000000115127824ULL, 0x140fe200078e0200ULL, 0x0000001400397811ULL, 0x040fe200078fe8ffULL,
0x0000000815577824ULL, 0x000fe200078e00ffULL, 0xfffffff8171a7812ULL, 0x000fe200078ee21aULL,
0x000000011b437824ULL, 0x140fe200078e0200ULL, 0x0000000900167c11ULL, 0x040fe2000f8fe8ffULL,
0x000000081b147824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee212ULL,
0x0000000119487824ULL, 0x140fe200078e0200ULL, 0x0000000c16167c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000819177824ULL, 0x000fe200078e00ffULL, 0xfffffff814437812ULL, 0x000fe200078ee243ULL,
0x0000000149417824ULL, 0x140fe200078e0200ULL, 0x0000001c004b7811ULL, 0x040fe200078fe8ffULL,
0x0000000849127824ULL, 0x000fe200078e00ffULL, 0xfffffff817487812ULL, 0x000fe200078ee248ULL,
0x0000000913147c36ULL, 0x000fe20008000000ULL, 0x0000000000567211ULL, 0x000fe200078fe8ffULL,
0x0000000139427824ULL, 0x140fe200078e0200ULL, 0xfffffff812417812ULL, 0x000fe200078ee241ULL,
0x0000000839177824ULL, 0x000fe200078e00ffULL, 0x0000000c14147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000915127c36ULL, 0x000fe20008000000ULL, 0x0000001557577c11ULL, 0x000fe2000f8e20ffULL,
0x000000014b407824ULL, 0x040fe200078e0200ULL, 0xfffffff817427812ULL, 0x000fe200078ee242ULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x0000000c12127c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0x00000018143c7c11ULL, 0x000fe2000f8648ffULL,
0x000000084b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018163e7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x00000019143d7c11ULL, 0x000fe200098f4c15ULL,
0x0000000919157c36ULL, 0x000fe20008000000ULL, 0x00000018123a7c11ULL, 0x000fc4000f8848ffULL,
0x00000019163f7c11ULL, 0x000fe200090f4c17ULL, 0x000000091b177c36ULL, 0x000fe20008000000ULL,
0xfffffff83b407812ULL, 0x000fe200078ee240ULL, 0x00000009491b7c36ULL, 0x000fe20008000000ULL,
0x00000019123b7c11ULL, 0x000fe2000a0f4c13ULL, 0x0000000939127c36ULL, 0x000fe20008000000ULL,
0x0000000c15157c10ULL, 0x000fe2000ff5e0ffULL, 0x000000094b397c36ULL, 0x000fe20008000000ULL,
0x0000000c17177c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000c12127c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200010e06ffULL, 0x0000001815147c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x0000001817167c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff197224ULL, 0x000fe200020e06ffULL, 0x0ffffff800137812ULL, 0x000fc400078ec0ffULL,
0x0000001915157c11ULL, 0x000fe400090f4c4aULL, 0x0000001812187c11ULL, 0x000fe4000f8848ffULL,
0x0000001917177c11ULL, 0x000fe400098f4c38ULL, 0x0000000713567812ULL, 0x000fe400078ef856ULL,
0x0000000c1b1b7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000c39397c10ULL, 0x000fc4000ff7e0ffULL,
0x0000001912197c11ULL, 0x000fe2000a0f4c19ULL, 0x0000001259127c36ULL, 0x000fe20008000000ULL,
0x0000001556497c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff567224ULL, 0x000fe200010e06ffULL,
0x000000151a4b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x000000181b1a7c11ULL, 0x000fe2000f8448ffULL, 0x00000010123e7825ULL, 0x040fe200078e003eULL,
0x0000001839387c11ULL, 0x000fe4000f8648ffULL, 0x000000191b1b7c11ULL, 0x000fe200090f4c56ULL,
0x00000010123c7825ULL, 0x000fe200078e003cULL, 0x0000001939397c11ULL, 0x000fe200098f4c4aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e497faeULL, 0x0003e2000b901c4eULL,
0x00000015485b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010123a7825ULL, 0x000fe200078e003aULL,
0x0000001543437c11ULL, 0x000fe2000f8e20ffULL, 0x000000003c4b7faeULL, 0x0003e2000b901c4eULL,
0x00000015425d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001012147825ULL, 0x000fe200078e0014ULL,
0x0000001541417c11ULL, 0x000fe2000f8e20ffULL, 0x000000003a577faeULL, 0x0003e2000b901c4eULL,
0x00000015405f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001012167825ULL, 0x000fc400078e0016ULL,
0x00000000145b7faeULL, 0x0003e4000b901c4eULL, 0x0000001012187825ULL, 0x040fe400078e0018ULL,
0x0000000016437faeULL, 0x0003e4000b901c4eULL, 0x00000010121a7825ULL, 0x040fe400078e001aULL,
0x00000000185d7faeULL, 0x0003e4000b901c4eULL, 0x0000001012387825ULL, 0x000fc400078e0038ULL,
0x000000001a417faeULL, 0x0003e8000b901c4eULL, 0x00000000385f7faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000408147836ULL, 0x00afe40000000000ULL,
0x0000000809157824ULL, 0x000fca00078e00ffULL, 0xfffffff815147812ULL, 0x000fc800078ee214ULL,
0x00000004144b7c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff157819ULL, 0x000fe40000011600ULL,
0x00000005ff06723eULL, 0x000fc600000000ffULL, 0x0000000815077836ULL, 0x000fe20000000000ULL,
0x0000541006147816ULL, 0x000fca0000000006ULL, 0x00001f1514067589ULL, 0x0002a800000e0000ULL,
0x00001f0714077589ULL, 0x0002e400000e0000ULL, 0x012000004b14783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000614147232ULL, 0x08cfe40000000000ULL,
0x0000000616167232ULL, 0x000fe40000000000ULL, 0x0000000715157232ULL, 0x080fe40000000000ULL,
0x0000000717177232ULL, 0x000fce0000000000ULL, 0x000150000b0b7890ULL, 0x000fe2000fffe03fULL,
0x0000000608087836ULL, 0x000fe40000000000ULL, 0x0000000809097824ULL, 0x000fc600078e00ffULL,
0x0000000b0f4a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b10497c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b11487c11ULL, 0x000fe2000f8e20ffULL, 0x000000004a40783bULL, 0x000f220000004200ULL,
0x0000000b0a0f7c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff809087812ULL, 0x000fe200078ee208ULL,
0x000000004918783bULL, 0x000f620000004200ULL, 0x0000000b0c0c7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000408087c11ULL, 0x000fe2000f8e20ffULL, 0x000000004838783bULL, 0x000f620000004200ULL,
0x0000000b0e0e7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000f3c783bULL, 0x000f620000004200ULL, 0x000000401434723cULL, 0x018fec0000001834ULL,
0x000000421430723cULL, 0x000fec0000001830ULL, 0x000000181444723cULL, 0x022fec0000001844ULL,
0x0000001a142c723cULL, 0x000fec000000182cULL, 0x000000381428723cULL, 0x000fec0000001828ULL,
0x0000003a1424723cULL, 0x000fec0000001824ULL, 0x0000003c1420723cULL, 0x004fec0000001820ULL,
0x0000003e141c723cULL, 0x000fe2000000181cULL, 0x012000000814783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000614147232ULL, 0x084fe40000000000ULL, 0x0000000616167232ULL, 0x000fe40000000000ULL,
0x0000000715157232ULL, 0x080fe40000000000ULL, 0x0000000717177232ULL, 0x000fce0000000000ULL,
0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c40783bULL, 0x000ee20000004200ULL,
0x00000040050d7891ULL, 0x000fe2000f8e403fULL, 0x00000001ff117424ULL, 0x000fe400078e00ffULL,
0x000000000e3c783bULL, 0x000f220000004200ULL, 0x000000130d00728cULL, 0x000fe2000bf06070ULL,
0x000000ffff097224ULL, 0x000fe400078e0004ULL, 0x000000000d38783bULL, 0x000f660000004200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000000b18783bULL, 0x000f220000004200ULL,
0x01c68811ffff79a7ULL, 0x0007e40008500004ULL, 0x000000401434723cULL, 0x00cfec0000001834ULL,
0x000000421430723cULL, 0x000fec0000001830ULL, 0x0000003c1444723cULL, 0x010fec0000001844ULL,
0x0000003e142c723cULL, 0x000fec000000182cULL, 0x000000381428723cULL, 0x022fec0000001828ULL,
0x0000003a1424723cULL, 0x000fec0000001824ULL, 0x000000181420723cULL, 0x000fec0000001820ULL,
0x0000001a141c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000078004c0947ULL, 0x000fde0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400c89947ULL, 0x000fea0003800000ULL, 0x00000003ff397819ULL, 0x100fe20000011600ULL,
0x000000200d0a7890ULL, 0x000fe4000fffe03fULL, 0x0000002009167890ULL, 0x000fe4000fffe03fULL,
0x00000001390a7824ULL, 0x100fe200078e0200ULL, 0x0000000a1300728cULL, 0x000fe2000bf01070ULL,
0x00000004393d7836ULL, 0x000fe40000000000ULL, 0x00000008395f7836ULL, 0x000fe20000000000ULL,
0x00000007133f7812ULL, 0x000fe200078ef80aULL, 0x000000013d3c7824ULL, 0x040fe200078e0200ULL,
0x0000000a130d7287ULL, 0x000fe2000c000000ULL, 0x000000083d097824ULL, 0x000fc400078e00ffULL,
0x000000015f417824ULL, 0x140fe400078e0200ULL, 0x000000085f0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8093c7812ULL, 0x000fe200078ee23cULL, 0x0000000c39197836ULL, 0x000fe40000000000ULL,
0x00000010395b7836ULL, 0x000fe20000000000ULL, 0xfffffff80a417812ULL, 0x000fe200078ee241ULL,
0x0000000119097824ULL, 0x140fe200078e0200ULL, 0x0000000b3c617c11ULL, 0x000fe2000f8e20ffULL,
0x0000000819107824ULL, 0x000fe200078e00ffULL, 0x0000000b41417c11ULL, 0x000fe2000f8e20ffULL,
0x000000015b0a7824ULL, 0x000fc400078e0200ULL, 0x000000085b137824ULL, 0x000fe200078e00ffULL,
0xfffffff810097812ULL, 0x000fe200078ee209ULL, 0x0000001439437836ULL, 0x000fe40000000000ULL,
0x0000001839577836ULL, 0x000fe20000000000ULL, 0xfffffff8130a7812ULL, 0x000fe200078ee20aULL,
0x0000000143107824ULL, 0x100fe200078e0200ULL, 0x0000000b09097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000843157824ULL, 0x000fe400078e00ffULL, 0x0000000157137824ULL, 0x000fc400078e0200ULL,
0x0000000857147824ULL, 0x000fe200078e00ffULL, 0xfffffff815107812ULL, 0x000fe200078ee210ULL,
0x000000163d157c36ULL, 0x000fe40008000000ULL, 0x8000000aff427e24ULL, 0x000fe2000f8e02ffULL,
0xfffffff814137812ULL, 0x000fe200078ee213ULL, 0x0000001639147c36ULL, 0x000fe20008000000ULL,
0x0000000c15157c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000dff177e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b13137c11ULL, 0x000fe2000f8e20ffULL, 0x0000001c395d7836ULL, 0x000fe20000000000ULL,
0x0000000c14147c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x0000002017427446ULL, 0x000fe20003800042ULL, 0x000000015d407824ULL, 0x000fe200078e0200ULL,
0x00000018153a7c11ULL, 0x000fe2000f8648ffULL, 0x000000085d1b7824ULL, 0x000fe200078e00ffULL,
0x000000423900720cULL, 0x000fe20003f46070ULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x00000018141a7c11ULL, 0x040fe2000f8048ffULL, 0x000000165f187c36ULL, 0x000fe20008000000ULL,
0xfffffff81b407812ULL, 0x000fe200078ee240ULL, 0x00000016575a7c36ULL, 0x000fe20008000000ULL,
0x00000019141b7c11ULL, 0x000fc400080f4c17ULL, 0x00000019153b7c11ULL, 0x000fe200098f4c16ULL,
0x0000001619157c36ULL, 0x000fe20008000000ULL, 0x0000000c18147c10ULL, 0x000fe2000ff1e0ffULL,
0x000000165b167c36ULL, 0x000fe20008000000ULL, 0x000000423d00720cULL, 0x000fe20003fa6070ULL,
0x00000016433d7c36ULL, 0x000fe20008000000ULL, 0x0000000c15157c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x0000001814387c11ULL, 0x000fc6000f8048ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x0000001914397c11ULL, 0x000fe400080f4c17ULL,
0x0000000c16177c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001815147c11ULL, 0x000fe2000f8648ffULL,
0x0000001012387825ULL, 0x000fe200078e0038ULL, 0x0000001817167c11ULL, 0x000fe4000f8848ffULL,
0x0000001915157c11ULL, 0x000fe200098f4c3eULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x0000000c3d3d7c10ULL, 0x000fc4000ff7e0ffULL, 0x000000425f00720cULL, 0x080fe20003f06070ULL,
0x0000001012147825ULL, 0x040fe200078e0014ULL, 0x0000001917177c11ULL, 0x000fe4000a0f4c18ULL,
0x0000000b3f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x000000183d187c11ULL, 0x000fe2000f8648ffULL, 0x00000010123e7825ULL, 0x040fe200078e001aULL,
0x000000421900720cULL, 0x000fe40003f86070ULL, 0x000000193d197c11ULL, 0x000fe200098f4c56ULL,
0x000000165d1a7c36ULL, 0x000fe20008000000ULL, 0x0000000c5a1b7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e5f7faeULL, 0x000fe2000d101c4eULL,
0x00000010123c7825ULL, 0x000fc400078e003aULL, 0x0000000c1a567c10ULL, 0x000fe4000ff5e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200018e06ffULL, 0x000000181b1a7c11ULL, 0x000fe2000f8c48ffULL,
0x000000003c617faeULL, 0x0003e2000e901c4eULL, 0x000000ffff3b7224ULL, 0x000fe200010e06ffULL,
0x00000018563a7c11ULL, 0x000fe2000f8448ffULL, 0x0000001012167825ULL, 0x040fe200078e0016ULL,
0x000000425b00720cULL, 0x080fe20003f66070ULL, 0x0000000038417faeULL, 0x0007e2000c101c4eULL,
0x000000191b1b7c11ULL, 0x000fe2000b0f4c5aULL, 0x0000001012187825ULL, 0x040fe200078e0018ULL,
0x000000424300720cULL, 0x080fe20003fc6070ULL, 0x0000000014097faeULL, 0x0007e2000e101c4eULL,
0x000000425700720cULL, 0x000fe20003fa6070ULL, 0x00000010121a7825ULL, 0x000fe200078e001aULL,
0x00000019563b7c11ULL, 0x000fc400090f4c3bULL, 0x000000425d00720cULL, 0x000fe40003f46070ULL,
0x0000000b0a3d7c11ULL, 0x002fe2000f8e20ffULL, 0x00000010123a7825ULL, 0x000fe200078e003aULL,
0x0000000b103f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b40437c11ULL, 0x000fe2000f8e20ffULL,
0x00000000163d7faeULL, 0x0007e8000d901c4eULL, 0x00000000183f7faeULL, 0x0007e8000f101c4eULL,
0x000000001a137faeULL, 0x0007e8000e901c4eULL, 0x000000003a437faeULL, 0x0007e2000d101c4eULL,
0x0000000400887947ULL, 0x000fea0003800000ULL, 0x0000000400157811ULL, 0x040fe200078fe8ffULL,
0x00000020090a7890ULL, 0x000fe2000fffe03fULL, 0x0000000800177811ULL, 0x040fe400078fe8ffULL,
0x0000000c001b7811ULL, 0x040fe200078fe8ffULL, 0x0000000115427824ULL, 0x140fe200078e0200ULL,
0x0000001c005d7811ULL, 0x040fe200078fe8ffULL, 0x0000000815097824ULL, 0x000fe200078e00ffULL,
0x00000000000a7211ULL, 0x040fe200078fe8ffULL, 0x0000000117437824ULL, 0x140fe200078e0200ULL,
0x00000010003b7811ULL, 0x040fe200078fe8ffULL, 0x0000000817107824ULL, 0x000fe200078e00ffULL,
0xfffffff809427812ULL, 0x000fe200078ee242ULL, 0x000000011b407824ULL, 0x140fe200078e0200ULL,
0x0000001400577811ULL, 0x040fe200078fe8ffULL, 0x000000081b197824ULL, 0x000fe200078e00ffULL,
0x0000000713417812ULL, 0x000fe200078ef80aULL, 0x000000015d097824ULL, 0x140fe200078e0200ULL,
0xfffffff810437812ULL, 0x000fe200078ee243ULL, 0x000000085d167824ULL, 0x000fe200078e00ffULL,
0xfffffff819407812ULL, 0x000fe200078ee240ULL, 0x000000013b137824ULL, 0x140fe200078e0200ULL,
0x00000018005b7811ULL, 0x040fe200078fe8ffULL, 0x000000083b147824ULL, 0x000fe200078e00ffULL,
0xfffffff816097812ULL, 0x000fe200078ee209ULL, 0x0000000157107824ULL, 0x100fe200078e0200ULL,
0x0000000b41417c11ULL, 0x000fe2000f8e20ffULL, 0x0000000857197824ULL, 0x000fe200078e00ffULL,
0xfffffff814137812ULL, 0x000fe200078ee213ULL, 0x0000000a151a7c36ULL, 0x000fe20008000000ULL,
0x0000000b43437c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a17167c36ULL, 0x000fe20008000000ULL,
0xfffffff819107812ULL, 0x000fe200078ee210ULL, 0x0000000a1b147c36ULL, 0x000fe20008000000ULL,
0x0000000a00197c11ULL, 0x000fe2000f8fe8ffULL, 0x000000015b0a7824ULL, 0x040fe200078e0200ULL,
0x0000000c1a1a7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000085b397824ULL, 0x000fe200078e00ffULL,
0x0000000c16167c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000a3b3b7c36ULL, 0x000fe20008000000ULL,
0x0000000c14147c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x0000000c19197c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x000000181a387c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00000018163c7c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x00000018143e7c11ULL, 0x000fc4000f8048ffULL, 0xfffffff8390a7812ULL, 0x000fe400078ee20aULL,
0x0000001819187c11ULL, 0x040fe4000f8448ffULL, 0x000000191a397c11ULL, 0x000fe200098f4c1bULL,
0x0000000a571b7c36ULL, 0x000fe20008000000ULL, 0x00000019163d7c11ULL, 0x000fe2000a0f4c17ULL,
0x0000000a5b177c36ULL, 0x000fe20008000000ULL, 0x00000019143f7c11ULL, 0x000fe200080f4c15ULL,
0x0000000a5d157c36ULL, 0x000fe20008000000ULL, 0x0000001919197c11ULL, 0x000fe200090f4c3aULL,
0x0000001012387825ULL, 0x000fe200078e0038ULL, 0x0000000c3b3b7c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000c1b1b7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001012187825ULL, 0x040fe200078e0018ULL,
0x0000000c17177c10ULL, 0x000fe4000ff9e0ffULL, 0x0000000c15157c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff5e7224ULL, 0x000fe200010e06ffULL, 0x000000183b3a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff5c7224ULL, 0x000fe200018e06ffULL, 0x000000181b1a7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff5a7224ULL, 0x000fe200020e06ffULL, 0x0000001817167c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff567224ULL, 0x000fe200000e06ffULL, 0x0000001815147c11ULL, 0x000fe2000f8048ffULL,
0x00000010123c7825ULL, 0x040fe200078e003cULL, 0x000000193b3b7c11ULL, 0x000fe200090f4c5eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018417faeULL, 0x0003e2000b901c4eULL,
0x000000191b1b7c11ULL, 0x000fe200098f4c5cULL, 0x00000010123e7825ULL, 0x000fe200078e003eULL,
0x0000001917177c11ULL, 0x000fc4000a0f4c5aULL, 0x0000000b42577c11ULL, 0x000fe2000f8e20ffULL,
0x00000010123a7825ULL, 0x000fe200078e003aULL, 0x0000001915157c11ULL, 0x000fe400080f4c56ULL,
0x0000000b405b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010121a7825ULL, 0x000fe200078e001aULL,
0x0000000b13137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000038577faeULL, 0x0003e2000b901c4eULL,
0x0000000b105d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001012167825ULL, 0x000fe200078e0016ULL,
0x0000000b0a5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003c437faeULL, 0x0003e2000b901c4eULL,
0x0000000b09097c11ULL, 0x000fe2000f8e20ffULL, 0x0000001012147825ULL, 0x000fc400078e0014ULL,
0x000000003e5b7faeULL, 0x0003e8000b901c4eULL, 0x000000003a137faeULL, 0x0003e8000b901c4eULL,
0x000000001a5d7faeULL, 0x0003e8000b901c4eULL, 0x00000000165f7faeULL, 0x0003e8000b901c4eULL,
0x0000000014097faeULL, 0x0003e4000b901c4eULL, 0x00000003140c7892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xfffffffd100a7891ULL, 0x000fe4000f8e103fULL,
0x000000030c00788cULL, 0x000fc8000bf05270ULL, 0x000000010a0a7887ULL, 0x000fc8000c000000ULL,
0x0000000a14147290ULL, 0x000fc8000fffe03fULL, 0x000000061400728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x00000008140a8290ULL, 0x000fe2000fffe03fULL,
0x00008c00000c8ab9ULL, 0x000fc60000000a00ULL, 0x000000040a0c88a5ULL, 0x000fcc000f8e000cULL,
0x0000000cff127e24ULL, 0x000fe4000f8e00ffULL, 0x0000000dff137e24ULL, 0x00afca000f8e00ffULL,
0x0000000e12128981ULL, 0x000ea2000c1e1900ULL, 0x01c62811581479a7ULL, 0x0002e20008500004ULL,
0xffffffff000a7882ULL, 0x000fe20000000000ULL, 0x00000000120c82caULL, 0x004fda00000e0000ULL,
0x0000000c000a8c82ULL, 0x000fe20008000000ULL, 0x0000000000107805ULL, 0x002fe20000015200ULL,
0x01c62815580075a7ULL, 0x008e640008000144ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff167224ULL, 0x000fce00078e00ffULL, 0x000000101600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012100a7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e11ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011412ULL, 0x0000000a09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e0612ULL, 0x0000000209097819ULL, 0x000fc8000000120aULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000116167836ULL, 0x000fce0000000000ULL, 0x01c62815580075a7ULL, 0x000e640008000144ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x01c0800003117984ULL, 0x000e620000000800ULL,
0x000000ffff097224ULL, 0x000fc600078e0004ULL, 0x01c28000030a7984ULL, 0x0004a20000000800ULL,
0x000000041100720bULL, 0x002fda0003f1d000ULL, 0x0000000000127806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff12ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000f0a947ULL, 0x004fea0003800000ULL, 0x000000011100788cULL, 0x000fe2000bf05270ULL,
0x000000041100720bULL, 0x000fca0003f14000ULL, 0x000000000000781cULL, 0x000fd00003f4f008ULL,
0x0000000000137806ULL, 0x000fc800000e0100ULL, 0x0000991013097816ULL, 0x000fe400000000ffULL,
0x000000041110a209ULL, 0x000fe40007810000ULL, 0x000000ff0900720cULL, 0x000fc60003f05270ULL,
0x01c480100300a388ULL, 0x0003f40000000800ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000000411097209ULL, 0x000fe40007810000ULL, 0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0013ff7812ULL, 0x000fe2000784c0ffULL, 0x0000000409097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fca0000011600ULL,
0x00001f1015097589ULL, 0x006e6400000e0000ULL, 0x0000000934347220ULL, 0x082fe20000410000ULL,
0x0000000935357220ULL, 0x080fe20000410000ULL, 0x0000000930307220ULL, 0x080fe20000410000ULL,
0x0000000931317220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000928287220ULL, 0x080fe20000410000ULL,
0x0000000929297220ULL, 0x080fe20000410000ULL, 0x0000000924247220ULL, 0x080fe20000410000ULL,
0x0000000925257220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x000fce0000410000ULL, 0x0000001502027220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000800107811ULL, 0x000fca00078ff0ffULL,
0x00001f1015097589ULL, 0x002e6400000e0000ULL, 0x0000000936367220ULL, 0x082fe20000410000ULL,
0x0000000937377220ULL, 0x080fe20000410000ULL, 0x0000000932327220ULL, 0x080fe20000410000ULL,
0x0000000933337220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000947477220ULL, 0x080fe20000410000ULL, 0x000000092e2e7220ULL, 0x080fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x000000092a2a7220ULL, 0x080fe20000410000ULL,
0x000000092b2b7220ULL, 0x080fe20000410000ULL, 0x0000000926267220ULL, 0x080fe20000410000ULL,
0x0000000927277220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x0000000923237220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x000000091f1f7220ULL, 0x000fce0000410000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007800812ULL,
0x0000000411097209ULL, 0x002fd60007810000ULL, 0x8000000911110221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100050308ULL, 0x000e640000000800ULL,
0x000000050a0a0220ULL, 0x002fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe40000011600ULL,
0x00000005ff04723eULL, 0x000fc600000000ffULL, 0x0000000811077836ULL, 0x000fe20000000000ULL,
0x0000541004047816ULL, 0x000fca0000000004ULL, 0x00001f1104067589ULL, 0x0002a800000e0000ULL,
0x00001f0704077589ULL, 0x0002e400000e0000ULL, 0x012800004e10783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000610107232ULL, 0x08cfe40000000000ULL,
0x0000000612127232ULL, 0x000fe40000000000ULL, 0x0000000711117232ULL, 0x080fe40000000000ULL,
0x0000000713137232ULL, 0x000fce0000000000ULL, 0x000000004d3c783bULL, 0x000f280000004200ULL,
0x000000005038783bULL, 0x000f680000004200ULL, 0x000000005218783bULL, 0x000f680000004200ULL,
0x000000005314783bULL, 0x000f620000004200ULL, 0x0000003c1034723cULL, 0x018fec0000001834ULL,
0x0000003e1030723cULL, 0x000fec0000001830ULL, 0x000000381044723cULL, 0x022fec0000001844ULL,
0x0000003a102c723cULL, 0x000fec000000182cULL, 0x000000181028723cULL, 0x000fec0000001828ULL,
0x0000001a1024723cULL, 0x000fec0000001824ULL, 0x000000141020723cULL, 0x004fec0000001820ULL,
0x00000016101c723cULL, 0x000fe2000000181cULL, 0x012800005510783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000610107232ULL, 0x084fe40000000000ULL, 0x0000000612127232ULL, 0x000fe40000000000ULL,
0x0000000711117232ULL, 0x080fe40000000000ULL, 0x0000000713137232ULL, 0x000fce0000000000ULL,
0x00000000543c783bULL, 0x000ee20000004200ULL, 0x00008400000c7ab9ULL, 0x000fe20000000800ULL,
0x000000020a027221ULL, 0x000fe20000010000ULL, 0x0000000c0a0c72a4ULL, 0x000fe2000f8e023fULL,
0x000000005138783bULL, 0x000f260000004200ULL, 0x000000060c0c7899ULL, 0x000fe2000800063fULL,
0x000000004f18783bULL, 0x000f680000004200ULL, 0x000000004c14783bULL, 0x000f220000004200ULL,
0x0000003c1034723cULL, 0x00cfec0000001834ULL, 0x0000003e1030723cULL, 0x000fec0000001830ULL,
0x000000381044723cULL, 0x010fec0000001844ULL, 0x0000003a102c723cULL, 0x000fec000000182cULL,
0x000000181028723cULL, 0x022fec0000001828ULL, 0x0000001a1024723cULL, 0x000fec0000001824ULL,
0x000000141020723cULL, 0x000fec0000001820ULL, 0x00000016101c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400d09947ULL, 0x000fde0003800000ULL, 0x00000003ff157819ULL, 0x000fe20000011600ULL,
0x00000080050d7891ULL, 0x000fe2000f8e403fULL, 0x00008a0000187ab9ULL, 0x000fc60000000a00ULL,
0x0000000415137836ULL, 0x000fe20000000000ULL, 0x0000000d1300728cULL, 0x000fe2000bf01070ULL,
0x00000014153b7836ULL, 0x000fe40000000000ULL, 0x0000000113047824ULL, 0x140fe200078e0200ULL,
0x0000000d13167287ULL, 0x000fe2000c000000ULL, 0x0000000813117824ULL, 0x000fe400078e00ffULL,
0x000000013b3d7824ULL, 0x040fe400078e0200ULL, 0x0000000815397836ULL, 0x000fe20000000000ULL,
0xfffffff811387812ULL, 0x000fe200078ee204ULL, 0x000000083b047824ULL, 0x000fc400078e00ffULL,
0x0000000139567824ULL, 0x140fe200078e0200ULL, 0x00000015385d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000839177824ULL, 0x000fe200078e00ffULL, 0xfffffff8043d7812ULL, 0x000fe200078ee23dULL,
0x0000000c15577836ULL, 0x000fe40000000000ULL, 0x0000000915047c36ULL, 0x000fe20008000000ULL,
0xfffffff817567812ULL, 0x000fe200078ee256ULL, 0x0000001015437836ULL, 0x000fe20000000000ULL,
0x000000153d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001573a7824ULL, 0x140fe200078e0200ULL,
0x0000000c04047c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000857117824ULL, 0x000fe200078e00ffULL,
0x00000015565f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001433c7824ULL, 0x000fc400078e0200ULL,
0x0000000843177824ULL, 0x000fe200078e00ffULL, 0xfffffff8113a7812ULL, 0x000fe200078ee23aULL,
0x00000018153f7836ULL, 0x000fe40000000000ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0xfffffff8173c7812ULL, 0x000fe200078ee23cULL, 0x000000013f407824ULL, 0x040fe200078e0200ULL,
0x00000018041a7c11ULL, 0x040fe2000f8448ffULL, 0x000000083f177824ULL, 0x000fe400078e00ffULL,
0x00000009130a7c36ULL, 0x000fe20008000000ULL, 0x00000019041b7c11ULL, 0x000fe200090f4c11ULL,
0x0000001c15417836ULL, 0x000fe20000000000ULL, 0xfffffff817407812ULL, 0x000fe200078ee240ULL,
0x8000000dff427e24ULL, 0x000fe2000f8e02ffULL, 0x0000000c0a047c10ULL, 0x000fe2000ff5e0ffULL,
0x00000016ff177e24ULL, 0x000fc4000f8e00ffULL, 0x00000009390a7c36ULL, 0x000fe40008000000ULL,
0x00000001413e7824ULL, 0x040fe200078e0200ULL, 0x0000002017427446ULL, 0x000fe20003800042ULL,
0x0000000841197824ULL, 0x000fe200078e00ffULL, 0x0000000c0a0a7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001804187c11ULL, 0x040fe2000f8448ffULL,
0x0000000957107c36ULL, 0x000fe20008000000ULL, 0xfffffff8193e7812ULL, 0x000fe200078ee23eULL,
0x0000000943127c36ULL, 0x000fe20008000000ULL, 0x0000001904197c11ULL, 0x000fc400090f4c11ULL,
0x000000421300720cULL, 0x000fe20003f66070ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x0000000c10047c10ULL, 0x000fe4000ffbe0ffULL, 0x000000180a167c11ULL, 0x000fe4000f8448ffULL,
0x0000001804107c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x000000190a177c11ULL, 0x000fe400090f4c13ULL, 0x0000000c120a7c10ULL, 0x000fc4000ff5e0ffULL,
0x0000001904117c11ULL, 0x000fe4000a0f4c11ULL, 0x000000421500720cULL, 0x0c0fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x000000180a127c11ULL, 0x000fe2000f8c48ffULL,
0x0000000115157824ULL, 0x000fe200078e0200ULL, 0x0ffffff800047812ULL, 0x000fe400078ec0ffULL,
0x000000423900720cULL, 0x000fe20003fa6070ULL, 0x000000093b397c36ULL, 0x000fe20008000000ULL,
0x000000190a137c11ULL, 0x000fe2000b0f4c13ULL, 0x00000012590a7c36ULL, 0x000fe20008000000ULL,
0x0000000704147812ULL, 0x000fc400078ef815ULL, 0x000000425700720cULL, 0x000fe20003f46070ULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x00000015145b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c39157c10ULL, 0x000fe2000ffde0ffULL, 0x000000093f577c36ULL, 0x000fe40008000000ULL,
0x000000100a387825ULL, 0x040fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a5b7faeULL, 0x0003e4000e101c4eULL, 0x0000000c57197c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200030e06ffULL, 0x0000001815147c11ULL, 0x040fe2000f8c48ffULL,
0x0000000941187c36ULL, 0x000fe20008000000ULL, 0x00000000385d7faeULL, 0x0005e2000d901c4eULL,
0x000000ffff567224ULL, 0x000fe200020e06ffULL, 0x0000001915157c11ULL, 0x000fe2000b0f4c5aULL,
0x000000100a167825ULL, 0x000fe200078e0016ULL, 0x0000000c18577c10ULL, 0x000fc4000ff7e0ffULL,
0x0000001819187c11ULL, 0x000fe2000f8c48ffULL, 0x000000100a107825ULL, 0x040fe200078e0010ULL,
0x000000424300720cULL, 0x080fe20003f86070ULL, 0x00000000165f7faeULL, 0x0007e2000e901c4eULL,
0x0000001919197c11ULL, 0x000fe2000b0f4c56ULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x00000018571a7c11ULL, 0x002fe2000f8648ffULL, 0x000000100a127825ULL, 0x040fe200078e0012ULL,
0x000000423b00720cULL, 0x080fe40003fc6070ULL, 0x000000423f00720cULL, 0x000fe20003fa6070ULL,
0x000000100a147825ULL, 0x000fe200078e0014ULL, 0x00000019571b7c11ULL, 0x000fc400098f4c56ULL,
0x000000424100720cULL, 0x000fe20003f66070ULL, 0x000000100a187825ULL, 0x000fe200078e0018ULL,
0x000000153a397c11ULL, 0x004fe4000f8e20ffULL, 0x000000153c3b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x00000015403f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000010397faeULL, 0x0007e2000d101c4eULL, 0x000000153e417c11ULL, 0x000fc6000f8e20ffULL,
0x00000000123b7faeULL, 0x0007e8000e101c4eULL, 0x00000000143d7faeULL, 0x0007e8000f101c4eULL,
0x00000000183f7faeULL, 0x0007e8000e901c4eULL, 0x000000001a417faeULL, 0x0007e2000d901c4eULL,
0x0000000400907947ULL, 0x000fea0003800000ULL, 0x0000000400117811ULL, 0x040fe200078fe8ffULL,
0x00008a0000187ab9ULL, 0x000fe20000000a00ULL, 0x0000000800137811ULL, 0x040fe400078fe8ffULL,
0x0000001000197811ULL, 0x040fe200078fe8ffULL, 0x0000000111167824ULL, 0x140fe200078e0200ULL,
0x0000001800437811ULL, 0x040fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x0000000c00177811ULL, 0x040fe200078fe8ffULL, 0x0000000113047824ULL, 0x100fe200078e0200ULL,
0x0000001400417811ULL, 0x040fe200078fe8ffULL, 0x00000001193f7824ULL, 0x100fe200078e0200ULL,
0xfffffff815167812ULL, 0x000fe200078ee216ULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0x0000000900107c11ULL, 0x040fe2000f8fe8ffULL, 0x00000008190a7824ULL, 0x000fe200078e00ffULL,
0x0000001c00577811ULL, 0x000fe200078fe8ffULL, 0x00000001433d7824ULL, 0x140fe200078e0200ULL,
0xfffffff815567812ULL, 0x000fe200078ee204ULL, 0x0000000843047824ULL, 0x000fe200078e00ffULL,
0xfffffff80a3f7812ULL, 0x000fe200078ee23fULL, 0x00000009110a7c36ULL, 0x000fe20008000000ULL,
0x0000000c10107c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000117407824ULL, 0x140fe200078e0200ULL,
0xfffffff8043d7812ULL, 0x000fe200078ee23dULL, 0x0000000913047c36ULL, 0x000fe20008000000ULL,
0x0000000c0a0a7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0x000000153f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001413e7824ULL, 0x140fe200078e0200ULL,
0x0000000c04047c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000841157824ULL, 0x000fe200078e00ffULL,
0xfffffff81b407812ULL, 0x000fe200078ee240ULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x000000180a387c11ULL, 0x040fe2000f8648ffULL, 0x00000001573c7824ULL, 0x040fe200078e0200ULL,
0xfffffff8153e7812ULL, 0x000fe200078ee23eULL, 0x00000008571b7824ULL, 0x000fe200078e00ffULL,
0x000000190a397c11ULL, 0x000fe200098f4c13ULL, 0x000000ffff157224ULL, 0x000fe200010e06ffULL,
0x00000018103a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x00000018041a7c11ULL, 0x000fe2000f8848ffULL, 0x0000000917177c36ULL, 0x000fe20008000000ULL,
0xfffffff81b3c7812ULL, 0x000fe200078ee23cULL, 0x0000000919137c36ULL, 0x000fe20008000000ULL,
0x00000019103b7c11ULL, 0x000fe200090f4c15ULL, 0x00000009410a7c36ULL, 0x000fe20008000000ULL,
0x00000019041b7c11ULL, 0x000fe2000a0f4c11ULL, 0x0000000943437c36ULL, 0x000fe20008000000ULL,
0x0000000c17117c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000957197c36ULL, 0x000fe20008000000ULL,
0x0000000c13137c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000000177211ULL, 0x040fe200078fe8ffULL,
0x000000ffff427224ULL, 0x000fe200010e06ffULL, 0x0ffffff800047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x0000000c0a0a7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001811107c11ULL, 0x000fe4000f8448ffULL, 0x0000000704177812ULL, 0x000fe200078ef817ULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x0000001813127c11ULL, 0x000fc4000f8648ffULL,
0x0000001911117c11ULL, 0x000fe400090f4c42ULL, 0x0000001517417c11ULL, 0x000fe4000f8e20ffULL,
0x000000180a147c11ULL, 0x000fe4000f8848ffULL, 0x0000001913137c11ULL, 0x000fe400098f4c18ULL,
0x0000000c43177c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000c19197c10ULL, 0x000fc4000ff7e0ffULL,
0x000000190a157c11ULL, 0x000fe2000a0f4c15ULL, 0x00000012590a7c36ULL, 0x000fe20008000000ULL,
0x0000001556577c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff567224ULL, 0x000fe200010e06ffULL,
0x0000001516437c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff427224ULL, 0x000fe200018e06ffULL,
0x0000001817167c11ULL, 0x000fe2000f8448ffULL, 0x000000100a3a7825ULL, 0x040fe200078e003aULL,
0x0000001819187c11ULL, 0x000fe4000f8648ffULL, 0x0000001917177c11ULL, 0x000fe200090f4c56ULL,
0x000000100a387825ULL, 0x000fe200078e0038ULL, 0x0000001919197c11ULL, 0x000fe200098f4c42ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000b901c4eULL,
0x00000015405b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a1a7825ULL, 0x000fe200078e001aULL,
0x000000153e5d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000038437faeULL, 0x0003e2000b901c4eULL,
0x000000153d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a107825ULL, 0x000fe200078e0010ULL,
0x000000153c5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a577faeULL, 0x0003e4000b901c4eULL,
0x000000100a127825ULL, 0x000fc400078e0012ULL, 0x00000000105b7faeULL, 0x0003e4000b901c4eULL,
0x000000100a147825ULL, 0x040fe400078e0014ULL, 0x00000000123f7faeULL, 0x0003e4000b901c4eULL,
0x000000100a167825ULL, 0x040fe400078e0016ULL, 0x00000000145d7faeULL, 0x0003e4000b901c4eULL,
0x000000100a187825ULL, 0x000fc400078e0018ULL, 0x00000000163d7faeULL, 0x0003e8000b901c4eULL,
0x00000000185f7faeULL, 0x0003e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x00afe40000011600ULL, 0x00000005ff06723eULL, 0x000fc600000000ffULL,
0x0000000811077836ULL, 0x000fe20000000000ULL, 0x0000541006107816ULL, 0x000fca0000000006ULL,
0x00001f1110067589ULL, 0x0002a800000e0000ULL, 0x00001f0710077589ULL, 0x0002e400000e0000ULL,
0x012800004b10783bULL, 0x00a2e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000610107232ULL, 0x08cfe40000000000ULL, 0x0000000612127232ULL, 0x000fe40000000000ULL,
0x0000000711117232ULL, 0x080fe40000000000ULL, 0x0000000713137232ULL, 0x000fce0000000000ULL,
0x000000004a3c783bULL, 0x000f280000004200ULL, 0x000000004938783bULL, 0x000f680000004200ULL,
0x000000004818783bULL, 0x000f680000004200ULL, 0x000000000f14783bULL, 0x000f620000004200ULL,
0x0000003c1034723cULL, 0x018fec0000001834ULL, 0x0000003e1030723cULL, 0x000fec0000001830ULL,
0x000000381044723cULL, 0x022fec0000001844ULL, 0x0000003a102c723cULL, 0x000fec000000182cULL,
0x000000181028723cULL, 0x000fec0000001828ULL, 0x0000001a1024723cULL, 0x000fec0000001824ULL,
0x000000141020723cULL, 0x004fec0000001820ULL, 0x00000016101c723cULL, 0x000fe2000000181cULL,
0x012800000810783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000610107232ULL, 0x084fe40000000000ULL,
0x0000000612127232ULL, 0x000fe40000000000ULL, 0x0000000711117232ULL, 0x080fe40000000000ULL,
0x0000000713137232ULL, 0x000fce0000000000ULL, 0x000000000b14783bULL, 0x000ee20000004200ULL,
0x00000080050d7891ULL, 0x000fc6000f8e403fULL, 0x000000000c3c783bULL, 0x000f220000004200ULL,
0x000000130d00728cULL, 0x000fc6000bf06070ULL, 0x000000000e38783bULL, 0x000f660000004200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000000d18783bULL, 0x000f620000004200ULL,
0x000000141020723cULL, 0x00cfec0000001820ULL, 0x0000003c1034723cULL, 0x010fe20000001834ULL,
0x00000001ff157424ULL, 0x000fc800078e00ffULL, 0x01c69015ffff79a7ULL, 0x0005e20008500004ULL,
0x0000003e1030723cULL, 0x000fec0000001830ULL, 0x000000381044723cULL, 0x022fec0000001844ULL,
0x0000003a102c723cULL, 0x000fec000000182cULL, 0x000000181028723cULL, 0x000fec0000001828ULL,
0x0000001a1024723cULL, 0x000fec0000001824ULL, 0x00000016101c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000005000300947ULL, 0x004fde0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400c89947ULL, 0x000fea0003800000ULL,
0x00000003ff1b7819ULL, 0x100fe20000011600ULL, 0x000000200d0a7890ULL, 0x000fe4000fffe03fULL,
0x0000002009167890ULL, 0x000fe4000fffe03fULL, 0x000000011b117824ULL, 0x100fe200078e0200ULL,
0x0000000a1300728cULL, 0x000fe2000bf01070ULL, 0x000000081b5f7836ULL, 0x000fe40000000000ULL,
0x0000000c1b177836ULL, 0x000fe20000000000ULL, 0x00000007043d7812ULL, 0x000fe200078ef811ULL,
0x000000041b3b7836ULL, 0x000fe20000000000ULL, 0x0000000a130d7287ULL, 0x000fe2000c000000ULL,
0x000000015f417824ULL, 0x000fc400078e0200ULL, 0x000000085f107824ULL, 0x000fe400078e00ffULL,
0x0000000117047824ULL, 0x140fe400078e0200ULL, 0x0000000817117824ULL, 0x000fe200078e00ffULL,
0xfffffff810417812ULL, 0x000fe200078ee241ULL, 0x000000141b437836ULL, 0x000fe40000000000ULL,
0x000000181b577836ULL, 0x000fe20000000000ULL, 0xfffffff811047812ULL, 0x000fe200078ee204ULL,
0x000000013b3a7824ULL, 0x000fe200078e0200ULL, 0x0000000b41417c11ULL, 0x000fe2000f8e20ffULL,
0x000000083b137824ULL, 0x000fc400078e00ffULL, 0x000000101b5b7836ULL, 0x000fe40000000000ULL,
0x00000001433e7824ULL, 0x140fe200078e0200ULL, 0xfffffff8133a7812ULL, 0x000fe200078ee23aULL,
0x0000000843117824ULL, 0x000fe400078e00ffULL, 0x00000001573f7824ULL, 0x140fe200078e0200ULL,
0x0000000b3a617c11ULL, 0x000fe2000f8e20ffULL, 0x0000000857107824ULL, 0x000fe200078e00ffULL,
0xfffffff8113e7812ULL, 0x000fe200078ee23eULL, 0x000000015b147824ULL, 0x000fc400078e0200ULL,
0x000000085b137824ULL, 0x000fe200078e00ffULL, 0xfffffff8103f7812ULL, 0x000fe200078ee23fULL,
0x000000161b107c36ULL, 0x000fe40008000000ULL, 0x000000163b117c36ULL, 0x000fe20008000000ULL,
0xfffffff813147812ULL, 0x000fe200078ee214ULL, 0x8000000aff427e24ULL, 0x000fe2000f8e02ffULL,
0x0000000c10107c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000dff137e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c11117c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001c1b5d7836ULL, 0x000fe20000000000ULL,
0x0000000b3f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000165f167c36ULL, 0x000fe20008000000ULL,
0x0000002013427446ULL, 0x000fe20003800042ULL, 0x000000015d407824ULL, 0x000fe200078e0200ULL,
0x0000001811387c11ULL, 0x000fe2000f8648ffULL, 0x000000085d197824ULL, 0x000fe200078e00ffULL,
0x000000423b00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x0000001810187c11ULL, 0x040fe2000f8048ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0xfffffff819407812ULL, 0x000fe200078ee240ULL, 0x00000016433b7c36ULL, 0x000fe20008000000ULL,
0x0000001910197c11ULL, 0x000fe200080f4c13ULL, 0x00000016575a7c36ULL, 0x000fe20008000000ULL,
0x0000001911397c11ULL, 0x000fe200098f4c12ULL, 0x0000001617117c36ULL, 0x000fe20008000000ULL,
0x0000000c16107c10ULL, 0x000fe2000ff1e0ffULL, 0x000000165b127c36ULL, 0x000fe20008000000ULL,
0x000000421b00720cULL, 0x000fc40003f46070ULL, 0x0000000c11117c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x00000018101a7c11ULL, 0x000fc6000f8048ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x00000019101b7c11ULL, 0x000fe400080f4c13ULL,
0x0000000c12137c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001811107c11ULL, 0x000fe2000f8648ffULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x0000001813127c11ULL, 0x000fe4000f8848ffULL,
0x0000001911117c11ULL, 0x000fe200098f4c3cULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000000c3b3b7c10ULL, 0x000fc4000ff7e0ffULL, 0x000000425f00720cULL, 0x080fe20003f06070ULL,
0x000000100a107825ULL, 0x040fe200078e0010ULL, 0x0000001913137c11ULL, 0x000fe4000a0f4c16ULL,
0x0000000b3d5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x000000183b167c11ULL, 0x000fe2000f8648ffULL, 0x000000100a3c7825ULL, 0x040fe200078e0018ULL,
0x000000421700720cULL, 0x000fe40003f86070ULL, 0x000000193b177c11ULL, 0x000fe200098f4c56ULL,
0x000000165d187c36ULL, 0x000fe20008000000ULL, 0x0000000c5a197c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c5f7faeULL, 0x000fe2000d101c4eULL,
0x000000100a3a7825ULL, 0x000fc400078e0038ULL, 0x0000000c18567c10ULL, 0x000fe4000ff5e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200018e06ffULL, 0x0000001819187c11ULL, 0x000fe2000f8c48ffULL,
0x000000003a617faeULL, 0x0003e2000e901c4eULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x0000001856387c11ULL, 0x000fe2000f8448ffULL, 0x000000100a127825ULL, 0x040fe200078e0012ULL,
0x000000425b00720cULL, 0x080fe20003f66070ULL, 0x000000001a417faeULL, 0x0007e2000c101c4eULL,
0x0000001919197c11ULL, 0x000fe2000b0f4c5aULL, 0x000000100a167825ULL, 0x000fe200078e0016ULL,
0x000000424300720cULL, 0x000fc40003fc6070ULL, 0x000000425700720cULL, 0x080fe20003fa6070ULL,
0x000000100a187825ULL, 0x000fe200078e0018ULL, 0x0000001956397c11ULL, 0x000fe400090f4c39ULL,
0x000000425d00720cULL, 0x000fe40003f46070ULL, 0x0000000b043b7c11ULL, 0x002fe2000f8e20ffULL,
0x000000100a387825ULL, 0x000fe200078e0038ULL, 0x0000000b143d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b3e437c11ULL, 0x000fe2000f8e20ffULL, 0x00000000103b7faeULL, 0x0007e2000e101c4eULL,
0x0000000b40577c11ULL, 0x000fc6000f8e20ffULL, 0x00000000123d7faeULL, 0x0007e8000d901c4eULL,
0x0000000016437faeULL, 0x0007e8000f101c4eULL, 0x00000000183f7faeULL, 0x0007e8000e901c4eULL,
0x0000000038577faeULL, 0x0007e2000d101c4eULL, 0x0000000400887947ULL, 0x000fea0003800000ULL,
0x0000000800137811ULL, 0x040fe200078fe8ffULL, 0x00000020090a7890ULL, 0x000fe2000fffe03fULL,
0x0000000400117811ULL, 0x040fe400078fe8ffULL, 0x0000001000397811ULL, 0x040fe200078fe8ffULL,
0x0000000113437824ULL, 0x140fe200078e0200ULL, 0x0000001400577811ULL, 0x040fe200078fe8ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x0000000c00197811ULL, 0x040fe200078fe8ffULL,
0x0000000111427824ULL, 0x140fe200078e0200ULL, 0x00000018005b7811ULL, 0x040fe200078fe8ffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0xfffffff810437812ULL, 0x000fe200078ee243ULL,
0x00000001393f7824ULL, 0x140fe200078e0200ULL, 0x0000000000417211ULL, 0x040fe200078fe8ffULL,
0x0000000839107824ULL, 0x000fe200078e00ffULL, 0xfffffff817427812ULL, 0x000fe200078ee242ULL,
0x00000001573e7824ULL, 0x140fe200078e0200ULL, 0x0000001c005d7811ULL, 0x040fe200078fe8ffULL,
0x0000000857177824ULL, 0x000fe200078e00ffULL, 0xfffffff8103f7812ULL, 0x000fe200078ee23fULL,
0x0000000a11187c36ULL, 0x000fe20008000000ULL, 0x0000000704417812ULL, 0x000fe200078ef841ULL,
0x0000000a13127c36ULL, 0x000fe20008000000ULL, 0xfffffff8173e7812ULL, 0x000fe200078ee23eULL,
0x0000000a19107c36ULL, 0x000fe20008000000ULL, 0x0000000a00177c11ULL, 0x000fe2000f8fe8ffULL,
0x0000000119407824ULL, 0x140fe200078e0200ULL, 0x0000000c18187c10ULL, 0x000fe2000ff7e0ffULL,
0x00000008191b7824ULL, 0x000fe200078e00ffULL, 0x0000000c12127c10ULL, 0x000fe2000ff9e0ffULL,
0x000000015b147824ULL, 0x100fe200078e0200ULL, 0x0000000c10107c10ULL, 0x000fe2000ff1e0ffULL,
0x000000015d047824ULL, 0x000fe200078e0200ULL, 0xfffffff81b407812ULL, 0x000fe200078ee240ULL,
0x000000085b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000c17177c10ULL, 0x000fe2000ff5e0ffULL,
0x000000085d3b7824ULL, 0x000fe200078e00ffULL, 0x0000000b41417c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0x00000018181a7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x00000018123a7c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00000018103c7c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0xfffffff81b147812ULL, 0x000fe200078ee214ULL,
0x0000000a39397c36ULL, 0x000fe20008000000ULL, 0xfffffff83b047812ULL, 0x000fc400078ee204ULL,
0x0000001817167c11ULL, 0x040fe4000f8448ffULL, 0x00000019181b7c11ULL, 0x000fe200098f4c19ULL,
0x0000000a57197c36ULL, 0x000fe20008000000ULL, 0x00000019123b7c11ULL, 0x000fe2000a0f4c13ULL,
0x0000000a5b137c36ULL, 0x000fe20008000000ULL, 0x00000019103d7c11ULL, 0x000fe200080f4c11ULL,
0x0000000a5d117c36ULL, 0x000fe20008000000ULL, 0x0000001917177c11ULL, 0x000fe200090f4c38ULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x0000000c39397c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000c19197c10ULL, 0x000fe2000ff7e0ffULL, 0x000000100a167825ULL, 0x040fe200078e0016ULL,
0x0000000c13137c10ULL, 0x000fe4000ff9e0ffULL, 0x0000000c11117c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff5e7224ULL, 0x000fe200010e06ffULL, 0x0000001839387c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff5c7224ULL, 0x000fe200018e06ffULL, 0x0000001819187c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff5a7224ULL, 0x000fe200020e06ffULL, 0x0000001813127c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff567224ULL, 0x000fe200000e06ffULL, 0x0000001811107c11ULL, 0x000fe2000f8048ffULL,
0x000000100a3a7825ULL, 0x040fe200078e003aULL, 0x0000001939397c11ULL, 0x000fe200090f4c5eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016417faeULL, 0x0003e2000b901c4eULL,
0x0000001919197c11ULL, 0x000fe200098f4c5cULL, 0x000000100a3c7825ULL, 0x000fe200078e003cULL,
0x0000001913137c11ULL, 0x000fc4000a0f4c5aULL, 0x0000000b42577c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a387825ULL, 0x040fe200078e0038ULL, 0x0000001911117c11ULL, 0x000fe400080f4c56ULL,
0x0000000b43437c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a187825ULL, 0x000fe200078e0018ULL,
0x0000000b405b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a577faeULL, 0x0003e2000b901c4eULL,
0x0000000b3f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a127825ULL, 0x000fe200078e0012ULL,
0x0000000b3e5d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003a437faeULL, 0x0003e2000b901c4eULL,
0x0000000b145f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a107825ULL, 0x000fe200078e0010ULL,
0x0000000b04617c11ULL, 0x000fe2000f8e20ffULL, 0x000000003c5b7faeULL, 0x0003e8000b901c4eULL,
0x00000000383f7faeULL, 0x0003e8000b901c4eULL, 0x00000000185d7faeULL, 0x0003e8000b901c4eULL,
0x00000000125f7faeULL, 0x0003e8000b901c4eULL, 0x0000000010617faeULL, 0x0003e4000b901c4eULL,
0x00000003140c7892ULL, 0x000fe2000f8ec03fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd100a7891ULL, 0x000fe4000f8e103fULL, 0x000000030c00788cULL, 0x000fc8000bf05270ULL,
0x000000010a0a7887ULL, 0x000fc8000c000000ULL, 0x0000000a14147290ULL, 0x000fc8000fffe03fULL,
0x000000061400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000008140a8290ULL, 0x000fe2000fffe03fULL, 0x00008c00000c8ab9ULL, 0x000fc60000000a00ULL,
0x000000040a0c88a5ULL, 0x000fcc000f8e000cULL, 0x0000000cff107e24ULL, 0x00afe4000f8e00ffULL,
0x0000000dff117e24ULL, 0x000fca000f8e00ffULL, 0x0000000e10108981ULL, 0x000ea2000c1e1900ULL,
0x01c64815581479a7ULL, 0x000e620008500004ULL, 0xffffffff000a7882ULL, 0x000fe20000000000ULL,
0x00000000100c82caULL, 0x004fda00000e0000ULL, 0x0000000c000a8c82ULL, 0x000fe20008000000ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x01c64815580075a7ULL, 0x002e640008000144ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011413ULL,
0x0000001704047211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000204047819ULL, 0x000fc80000001213ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01c64815580075a7ULL, 0x000e640008000144ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x01c10000030a7984ULL, 0x000e680000000800ULL, 0x01c3000003047984ULL, 0x0004a20000000800ULL,
0x000000090a00720bULL, 0x002fda0003f1d000ULL, 0x0000000000127806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff12ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000f0a947ULL, 0x004fea0003800000ULL, 0x000000021100788cULL, 0x000fe2000bf05270ULL,
0x000000090a00720bULL, 0x000fca0003f14000ULL, 0x000000000000781cULL, 0x000fd00003f4f008ULL,
0x0000000000137806ULL, 0x000fc800000e0100ULL, 0x0000991013117816ULL, 0x000fe400000000ffULL,
0x0000000a0910a209ULL, 0x000fe40007810000ULL, 0x000000ff1100720cULL, 0x000fc60003f05270ULL,
0x01c500100300a388ULL, 0x0003f40000000800ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000000a09107209ULL, 0x000fe40007810000ULL, 0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0013ff7812ULL, 0x000fe2000784c0ffULL, 0x8000001009107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000117308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x002fcc0000011600ULL,
0x00001f1011107589ULL, 0x004e6400000e0000ULL, 0x0000001034347220ULL, 0x082fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001044447220ULL, 0x080fe20000410000ULL,
0x0000001045457220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x000fce0000410000ULL, 0x0000001102027220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000800107811ULL, 0x002fcc00078ff0ffULL,
0x00001f1011107589ULL, 0x000e6400000e0000ULL, 0x0000001036367220ULL, 0x082fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001046467220ULL, 0x080fe20000410000ULL,
0x0000001047477220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x000fce0000410000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007800812ULL,
0x0000000a09097209ULL, 0x000fd60007810000ULL, 0x800000090a0a0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00050308ULL, 0x000ea40000000800ULL,
0x0000000504040220ULL, 0x004fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe40000011600ULL,
0x00000005ff06723eULL, 0x000fc600000000ffULL, 0x0000000811077836ULL, 0x000fe20000000000ULL,
0x00005410060a7816ULL, 0x000fca0000000006ULL, 0x00001f110a067589ULL, 0x0004e800000e0000ULL,
0x00001f070a077589ULL, 0x00046400000e0000ULL, 0x013000004e10783bULL, 0x0062a20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000610107232ULL, 0x08cfe40000000000ULL,
0x0000000612127232ULL, 0x000fe40000000000ULL, 0x0000000711117232ULL, 0x080fe40000000000ULL,
0x0000000713137232ULL, 0x000fce0000000000ULL, 0x000000004d3c783bULL, 0x000f280000004200ULL,
0x000000005038783bULL, 0x000f680000004200ULL, 0x000000005218783bULL, 0x000f680000004200ULL,
0x000000005314783bULL, 0x000f620000004200ULL, 0x0000003c1034723cULL, 0x014fec0000001834ULL,
0x0000003e1030723cULL, 0x000fec0000001830ULL, 0x000000381044723cULL, 0x022fec0000001844ULL,
0x0000003a102c723cULL, 0x000fec000000182cULL, 0x000000181028723cULL, 0x008fec0000001828ULL,
0x0000001a1024723cULL, 0x000fec0000001824ULL, 0x000000141020723cULL, 0x000fec0000001820ULL,
0x00000016101c723cULL, 0x000fe2000000181cULL, 0x013000005510783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000610107232ULL, 0x084fe40000000000ULL, 0x0000000612127232ULL, 0x000fe40000000000ULL,
0x0000000711117232ULL, 0x080fe40000000000ULL, 0x0000000713137232ULL, 0x000fce0000000000ULL,
0x00000000543c783bULL, 0x000ee20000004200ULL, 0x00008400000c7ab9ULL, 0x000fe20000000800ULL,
0x0000000204027221ULL, 0x000fe20000010000ULL, 0x0000000c0a0c72a4ULL, 0x000fe2000f8e023fULL,
0x000000005138783bULL, 0x000f260000004200ULL, 0x000000060c0c7899ULL, 0x000fe2000800063fULL,
0x000000004f18783bULL, 0x000f680000004200ULL, 0x000000004c14783bULL, 0x000f220000004200ULL,
0x0000003c1034723cULL, 0x00cfec0000001834ULL, 0x0000003e1030723cULL, 0x000fec0000001830ULL,
0x000000381044723cULL, 0x010fec0000001844ULL, 0x0000003a102c723cULL, 0x000fec000000182cULL,
0x000000181028723cULL, 0x022fec0000001828ULL, 0x0000001a1024723cULL, 0x000fec0000001824ULL,
0x000000141020723cULL, 0x000fec0000001820ULL, 0x00000016101c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400d09947ULL, 0x000fde0003800000ULL, 0x00000003ff157819ULL, 0x000fe20000011600ULL,
0x000000c0050d7891ULL, 0x000fe2000f8e403fULL, 0x00008a0000187ab9ULL, 0x000fc60000000a00ULL,
0x0000000415137836ULL, 0x000fe20000000000ULL, 0x0000000d1300728cULL, 0x000fe2000bf01070ULL,
0x00000014153b7836ULL, 0x000fe40000000000ULL, 0x0000000113047824ULL, 0x140fe200078e0200ULL,
0x0000000d13167287ULL, 0x000fe2000c000000ULL, 0x0000000813117824ULL, 0x000fe400078e00ffULL,
0x000000013b3d7824ULL, 0x040fe400078e0200ULL, 0x0000000815397836ULL, 0x000fe20000000000ULL,
0xfffffff811387812ULL, 0x000fe200078ee204ULL, 0x000000083b047824ULL, 0x000fc400078e00ffULL,
0x0000000139567824ULL, 0x140fe200078e0200ULL, 0x00000015385d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000839177824ULL, 0x000fe200078e00ffULL, 0xfffffff8043d7812ULL, 0x000fe200078ee23dULL,
0x0000000c15577836ULL, 0x000fe40000000000ULL, 0x0000000915047c36ULL, 0x000fe20008000000ULL,
0xfffffff817567812ULL, 0x000fe200078ee256ULL, 0x0000001015437836ULL, 0x000fe20000000000ULL,
0x000000153d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001573a7824ULL, 0x140fe200078e0200ULL,
0x0000000c04047c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000857117824ULL, 0x000fe200078e00ffULL,
0x00000015565f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001433c7824ULL, 0x000fc400078e0200ULL,
0x0000000843177824ULL, 0x000fe200078e00ffULL, 0xfffffff8113a7812ULL, 0x000fe200078ee23aULL,
0x00000018153f7836ULL, 0x000fe40000000000ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0xfffffff8173c7812ULL, 0x000fe200078ee23cULL, 0x000000013f407824ULL, 0x040fe200078e0200ULL,
0x00000018041a7c11ULL, 0x040fe2000f8448ffULL, 0x000000083f177824ULL, 0x000fe400078e00ffULL,
0x00000009130a7c36ULL, 0x000fe20008000000ULL, 0x00000019041b7c11ULL, 0x000fe200090f4c11ULL,
0x0000001c15417836ULL, 0x000fe20000000000ULL, 0xfffffff817407812ULL, 0x000fe200078ee240ULL,
0x8000000dff427e24ULL, 0x000fe2000f8e02ffULL, 0x0000000c0a047c10ULL, 0x000fe2000ff5e0ffULL,
0x00000016ff177e24ULL, 0x000fc4000f8e00ffULL, 0x00000009390a7c36ULL, 0x000fe40008000000ULL,
0x00000001413e7824ULL, 0x040fe200078e0200ULL, 0x0000002017427446ULL, 0x000fe20003800042ULL,
0x0000000841197824ULL, 0x000fe200078e00ffULL, 0x0000000c0a0a7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001804187c11ULL, 0x040fe2000f8448ffULL,
0x0000000957107c36ULL, 0x000fe20008000000ULL, 0xfffffff8193e7812ULL, 0x000fe200078ee23eULL,
0x0000000943127c36ULL, 0x000fe20008000000ULL, 0x0000001904197c11ULL, 0x000fc400090f4c11ULL,
0x000000421300720cULL, 0x000fe20003f66070ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x0000000c10047c10ULL, 0x000fe4000ffbe0ffULL, 0x000000180a167c11ULL, 0x000fe4000f8448ffULL,
0x0000001804107c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x000000190a177c11ULL, 0x000fe400090f4c13ULL, 0x0000000c120a7c10ULL, 0x000fc4000ff5e0ffULL,
0x0000001904117c11ULL, 0x000fe4000a0f4c11ULL, 0x000000421500720cULL, 0x0c0fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x000000180a127c11ULL, 0x000fe2000f8c48ffULL,
0x0000000115157824ULL, 0x000fe200078e0200ULL, 0x0ffffff800047812ULL, 0x000fe400078ec0ffULL,
0x000000423900720cULL, 0x000fe20003fa6070ULL, 0x000000093b397c36ULL, 0x000fe20008000000ULL,
0x000000190a137c11ULL, 0x000fe2000b0f4c13ULL, 0x00000012590a7c36ULL, 0x000fe20008000000ULL,
0x0000000704147812ULL, 0x000fc400078ef815ULL, 0x000000425700720cULL, 0x000fe20003f46070ULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x00000015145b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c39157c10ULL, 0x000fe2000ffde0ffULL, 0x000000093f577c36ULL, 0x000fe40008000000ULL,
0x000000100a387825ULL, 0x040fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a5b7faeULL, 0x0003e4000e101c4eULL, 0x0000000c57197c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200030e06ffULL, 0x0000001815147c11ULL, 0x040fe2000f8c48ffULL,
0x0000000941187c36ULL, 0x000fe20008000000ULL, 0x00000000385d7faeULL, 0x0005e2000d901c4eULL,
0x000000ffff567224ULL, 0x000fe200020e06ffULL, 0x0000001915157c11ULL, 0x000fe2000b0f4c5aULL,
0x000000100a167825ULL, 0x000fe200078e0016ULL, 0x0000000c18577c10ULL, 0x000fc4000ff7e0ffULL,
0x0000001819187c11ULL, 0x000fe2000f8c48ffULL, 0x000000100a107825ULL, 0x040fe200078e0010ULL,
0x000000424300720cULL, 0x080fe20003f86070ULL, 0x00000000165f7faeULL, 0x0007e2000e901c4eULL,
0x0000001919197c11ULL, 0x000fe2000b0f4c56ULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x00000018571a7c11ULL, 0x002fe2000f8648ffULL, 0x000000100a127825ULL, 0x040fe200078e0012ULL,
0x000000423b00720cULL, 0x080fe40003fc6070ULL, 0x000000423f00720cULL, 0x000fe20003fa6070ULL,
0x000000100a147825ULL, 0x000fe200078e0014ULL, 0x00000019571b7c11ULL, 0x000fc400098f4c56ULL,
0x000000424100720cULL, 0x000fe20003f66070ULL, 0x000000100a187825ULL, 0x000fe200078e0018ULL,
0x000000153a397c11ULL, 0x004fe4000f8e20ffULL, 0x000000153c3b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x00000015403f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000010397faeULL, 0x0007e2000d101c4eULL, 0x000000153e417c11ULL, 0x000fc6000f8e20ffULL,
0x00000000123b7faeULL, 0x0007e8000e101c4eULL, 0x00000000143d7faeULL, 0x0007e8000f101c4eULL,
0x00000000183f7faeULL, 0x0007e8000e901c4eULL, 0x000000001a417faeULL, 0x0007e2000d901c4eULL,
0x0000000400907947ULL, 0x000fea0003800000ULL, 0x0000000400117811ULL, 0x040fe200078fe8ffULL,
0x00008a0000187ab9ULL, 0x000fe20000000a00ULL, 0x0000000800137811ULL, 0x040fe400078fe8ffULL,
0x0000001000197811ULL, 0x040fe200078fe8ffULL, 0x0000000111167824ULL, 0x140fe200078e0200ULL,
0x0000001800437811ULL, 0x040fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x0000000c00177811ULL, 0x040fe200078fe8ffULL, 0x0000000113047824ULL, 0x100fe200078e0200ULL,
0x0000001400417811ULL, 0x040fe200078fe8ffULL, 0x00000001193f7824ULL, 0x100fe200078e0200ULL,
0xfffffff815167812ULL, 0x000fe200078ee216ULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0x0000000900107c11ULL, 0x040fe2000f8fe8ffULL, 0x00000008190a7824ULL, 0x000fe200078e00ffULL,
0x0000001c00577811ULL, 0x000fe200078fe8ffULL, 0x00000001433d7824ULL, 0x140fe200078e0200ULL,
0xfffffff815567812ULL, 0x000fe200078ee204ULL, 0x0000000843047824ULL, 0x000fe200078e00ffULL,
0xfffffff80a3f7812ULL, 0x000fe200078ee23fULL, 0x00000009110a7c36ULL, 0x000fe20008000000ULL,
0x0000000c10107c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000117407824ULL, 0x140fe200078e0200ULL,
0xfffffff8043d7812ULL, 0x000fe200078ee23dULL, 0x0000000913047c36ULL, 0x000fe20008000000ULL,
0x0000000c0a0a7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0x000000153f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001413e7824ULL, 0x140fe200078e0200ULL,
0x0000000c04047c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000841157824ULL, 0x000fe200078e00ffULL,
0xfffffff81b407812ULL, 0x000fe200078ee240ULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x000000180a387c11ULL, 0x040fe2000f8648ffULL, 0x00000001573c7824ULL, 0x040fe200078e0200ULL,
0xfffffff8153e7812ULL, 0x000fe200078ee23eULL, 0x00000008571b7824ULL, 0x000fe200078e00ffULL,
0x000000190a397c11ULL, 0x000fe200098f4c13ULL, 0x000000ffff157224ULL, 0x000fe200010e06ffULL,
0x00000018103a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x00000018041a7c11ULL, 0x000fe2000f8848ffULL, 0x0000000917177c36ULL, 0x000fe20008000000ULL,
0xfffffff81b3c7812ULL, 0x000fe200078ee23cULL, 0x0000000919137c36ULL, 0x000fe20008000000ULL,
0x00000019103b7c11ULL, 0x000fe200090f4c15ULL, 0x00000009410a7c36ULL, 0x000fe20008000000ULL,
0x00000019041b7c11ULL, 0x000fe2000a0f4c11ULL, 0x0000000943437c36ULL, 0x000fe20008000000ULL,
0x0000000c17117c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000957197c36ULL, 0x000fe20008000000ULL,
0x0000000c13137c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000000177211ULL, 0x040fe200078fe8ffULL,
0x000000ffff427224ULL, 0x000fe200010e06ffULL, 0x0ffffff800047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x0000000c0a0a7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001811107c11ULL, 0x000fe4000f8448ffULL, 0x0000000704177812ULL, 0x000fe200078ef817ULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x0000001813127c11ULL, 0x000fc4000f8648ffULL,
0x0000001911117c11ULL, 0x000fe400090f4c42ULL, 0x0000001517417c11ULL, 0x000fe4000f8e20ffULL,
0x000000180a147c11ULL, 0x000fe4000f8848ffULL, 0x0000001913137c11ULL, 0x000fe400098f4c18ULL,
0x0000000c43177c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000c19197c10ULL, 0x000fc4000ff7e0ffULL,
0x000000190a157c11ULL, 0x000fe2000a0f4c15ULL, 0x00000012590a7c36ULL, 0x000fe20008000000ULL,
0x0000001556577c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff567224ULL, 0x000fe200010e06ffULL,
0x0000001516437c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff427224ULL, 0x000fe200018e06ffULL,
0x0000001817167c11ULL, 0x000fe2000f8448ffULL, 0x000000100a3a7825ULL, 0x040fe200078e003aULL,
0x0000001819187c11ULL, 0x000fe4000f8648ffULL, 0x0000001917177c11ULL, 0x000fe200090f4c56ULL,
0x000000100a387825ULL, 0x000fe200078e0038ULL, 0x0000001919197c11ULL, 0x000fe200098f4c42ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000b901c4eULL,
0x00000015405b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a1a7825ULL, 0x000fe200078e001aULL,
0x000000153e5d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000038437faeULL, 0x0003e2000b901c4eULL,
0x000000153d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a107825ULL, 0x000fe200078e0010ULL,
0x000000153c5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a577faeULL, 0x0003e4000b901c4eULL,
0x000000100a127825ULL, 0x000fc400078e0012ULL, 0x00000000105b7faeULL, 0x0003e4000b901c4eULL,
0x000000100a147825ULL, 0x040fe400078e0014ULL, 0x00000000123f7faeULL, 0x0003e4000b901c4eULL,
0x000000100a167825ULL, 0x040fe400078e0016ULL, 0x00000000145d7faeULL, 0x0003e4000b901c4eULL,
0x000000100a187825ULL, 0x000fc400078e0018ULL, 0x00000000163d7faeULL, 0x0003e8000b901c4eULL,
0x00000000185f7faeULL, 0x0003e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x00afe40000011600ULL, 0x00000005ff06723eULL, 0x000fc600000000ffULL,
0x0000000811077836ULL, 0x000fe20000000000ULL, 0x0000541006107816ULL, 0x000fca0000000006ULL,
0x00001f1110067589ULL, 0x0002a800000e0000ULL, 0x00001f0710077589ULL, 0x0002e400000e0000ULL,
0x013000004b10783bULL, 0x00a2e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000610107232ULL, 0x08cfe40000000000ULL, 0x0000000612127232ULL, 0x000fe40000000000ULL,
0x0000000711117232ULL, 0x080fe40000000000ULL, 0x0000000713137232ULL, 0x000fce0000000000ULL,
0x000000004a3c783bULL, 0x000f280000004200ULL, 0x000000004938783bULL, 0x000f680000004200ULL,
0x000000004818783bULL, 0x000f680000004200ULL, 0x000000000f14783bULL, 0x000f620000004200ULL,
0x0000003c1034723cULL, 0x018fec0000001834ULL, 0x0000003e1030723cULL, 0x000fec0000001830ULL,
0x000000381044723cULL, 0x022fec0000001844ULL, 0x0000003a102c723cULL, 0x000fec000000182cULL,
0x000000181028723cULL, 0x000fec0000001828ULL, 0x0000001a1024723cULL, 0x000fec0000001824ULL,
0x000000141020723cULL, 0x004fec0000001820ULL, 0x00000016101c723cULL, 0x000fe2000000181cULL,
0x013000000810783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000610107232ULL, 0x084fe40000000000ULL,
0x0000000612127232ULL, 0x000fe40000000000ULL, 0x0000000711117232ULL, 0x080fe40000000000ULL,
0x0000000713137232ULL, 0x000fce0000000000ULL, 0x000000000b14783bULL, 0x000ee20000004200ULL,
0x000000c0050d7891ULL, 0x000fc6000f8e403fULL, 0x000000000c3c783bULL, 0x000f220000004200ULL,
0x000000130d00728cULL, 0x000fc6000bf06070ULL, 0x000000000e38783bULL, 0x000f660000004200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000000d18783bULL, 0x000f620000004200ULL,
0x000000141020723cULL, 0x00cfec0000001820ULL, 0x0000003c1034723cULL, 0x010fe20000001834ULL,
0x00000001ff157424ULL, 0x000fc800078e00ffULL, 0x01c69815ffff79a7ULL, 0x0005e20008500004ULL,
0x0000003e1030723cULL, 0x000fec0000001830ULL, 0x000000381044723cULL, 0x022fec0000001844ULL,
0x0000003a102c723cULL, 0x000fec000000182cULL, 0x000000181028723cULL, 0x000fec0000001828ULL,
0x0000001a1024723cULL, 0x000fec0000001824ULL, 0x00000016101c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000002800180947ULL, 0x004fde0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400c89947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x100fe20000011600ULL, 0x0000002009167890ULL, 0x000fe4000fffe03fULL,
0x000000200d0a7890ULL, 0x000fe4000fffe03fULL, 0x0000000413197836ULL, 0x000fe40000000000ULL,
0x0000000113117824ULL, 0x100fe200078e0200ULL, 0x0000000a1300728cULL, 0x000fe2000bf01070ULL,
0x0000000119427824ULL, 0x040fe400078e0200ULL, 0x0000000819177824ULL, 0x000fe200078e00ffULL,
0x0000000704167812ULL, 0x000fe200078ef811ULL, 0x0000000c135d7836ULL, 0x000fe20000000000ULL,
0x0000000a130d7287ULL, 0x000fe2000c000000ULL, 0x00000008135b7836ULL, 0x000fe20000000000ULL,
0xfffffff817427812ULL, 0x000fe200078ee242ULL, 0x0000001013177836ULL, 0x000fc40000000000ULL,
0x000000015d047824ULL, 0x140fe400078e0200ULL, 0x000000085d117824ULL, 0x000fe400078e00ffULL,
0x0000000117147824ULL, 0x140fe400078e0200ULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0xfffffff811047812ULL, 0x000fe200078ee204ULL, 0x000000015b417824ULL, 0x040fe400078e0200ULL,
0x000000085b107824ULL, 0x000fe200078e00ffULL, 0xfffffff81b147812ULL, 0x000fe200078ee214ULL,
0x0000001613117c36ULL, 0x000fc40008000000ULL, 0x0000001413577836ULL, 0x000fe20000000000ULL,
0xfffffff810417812ULL, 0x000fe200078ee241ULL, 0x00000018131b7836ULL, 0x000fe20000000000ULL,
0x0000000c11117c10ULL, 0x000fe2000ff1e0ffULL, 0x00000001573e7824ULL, 0x100fe200078e0200ULL,
0x0000000b41417c11ULL, 0x000fe2000f8e20ffULL, 0x0000000857397824ULL, 0x000fe400078e00ffULL,
0x000000011b3f7824ULL, 0x040fe400078e0200ULL, 0x000000081b107824ULL, 0x000fe200078e00ffULL,
0xfffffff8393e7812ULL, 0x000fe200078ee23eULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00000018113c7c11ULL, 0x040fe2000f8048ffULL, 0x8000000aff567e24ULL, 0x000fe2000f8e02ffULL,
0xfffffff8103f7812ULL, 0x000fe200078ee23fULL, 0x0000000dff397e24ULL, 0x000fe2000f8e00ffULL,
0x00000019113d7c11ULL, 0x000fe200080f4c12ULL, 0x0000001619107c36ULL, 0x000fe20008000000ULL,
0x0000000b3f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000165b187c36ULL, 0x000fe20008000000ULL,
0x0000002039567446ULL, 0x000fe20003800056ULL, 0x0000001c13437836ULL, 0x000fe20000000000ULL,
0x0000000c10107c10ULL, 0x000fe2000ff3e0ffULL, 0x000000100a3c7825ULL, 0x000fe200078e003cULL,
0x0000000c18117c10ULL, 0x000fc4000ff5e0ffULL, 0x000000561300720cULL, 0x080fe20003fa6070ULL,
0x0000000143407824ULL, 0x040fe200078e0200ULL, 0x0000001810387c11ULL, 0x040fe2000f8048ffULL,
0x00000008433b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x00000018113a7c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0xfffffff83b407812ULL, 0x000fe200078ee240ULL, 0x000000165d187c36ULL, 0x000fe20008000000ULL,
0x0000001910397c11ULL, 0x000fe200080f4c13ULL, 0x00000016435c7c36ULL, 0x000fe20008000000ULL,
0x00000019113b7c11ULL, 0x000fe200088f4c12ULL, 0x0000001617117c36ULL, 0x000fe20008000000ULL,
0x0000000c18107c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001657127c36ULL, 0x000fe20008000000ULL,
0x000000561900720cULL, 0x000fe20003f06070ULL, 0x000000100a387825ULL, 0x000fe200078e0038ULL,
0x0000000c11117c10ULL, 0x000fc4000ff7e0ffULL, 0x000000565b00720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x0000001810187c11ULL, 0x040fe2000f8448ffULL,
0x000000ffff1a7224ULL, 0x000fe400018e06ffULL, 0x000000161b5b7c36ULL, 0x000fe20008000000ULL,
0x0000001910197c11ULL, 0x000fe200090f4c13ULL, 0x000000100a3a7825ULL, 0x040fe200078e003aULL,
0x0000000c12137c10ULL, 0x000fe4000ff9e0ffULL, 0x0000001811107c11ULL, 0x000fe2000f8648ffULL,
0x000000100a187825ULL, 0x000fe200078e0018ULL, 0x000000565d00720cULL, 0x000fc40003f46070ULL,
0x0000001911117c11ULL, 0x000fe200098f4c1aULL, 0x000000ffff5a7224ULL, 0x000fe200020e06ffULL,
0x0000000c5b1a7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001813127c11ULL, 0x040fe2000f8848ffULL,
0x000000100a107825ULL, 0x000fe200078e0010ULL, 0x0000000b165d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001913137c11ULL, 0x000fe2000a0f4c5aULL, 0x000000ffff5b7224ULL, 0x000fe200018e06ffULL,
0x0000000c5c5a7c10ULL, 0x000fe2000ff9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c5d7faeULL, 0x0003e2000e901c4eULL, 0x000000181a167c11ULL, 0x000fe2000f8c48ffULL,
0x000000100a127825ULL, 0x000fe200078e0012ULL, 0x000000561700720cULL, 0x000fc40003f66070ULL,
0x000000191a177c11ULL, 0x000fe2000b0f4c5bULL, 0x000000ffff5b7224ULL, 0x000fe200020e06ffULL,
0x000000185a1a7c11ULL, 0x000fe4000f8848ffULL, 0x000000565700720cULL, 0x080fe20003fc6070ULL,
0x000000100a167825ULL, 0x000fe200078e0016ULL, 0x000000561b00720cULL, 0x080fe40003fa6070ULL,
0x000000195a1b7c11ULL, 0x000fe4000a0f4c5bULL, 0x000000564300720cULL, 0x000fc40003f86070ULL,
0x0000000b42437c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a1a7825ULL, 0x000fe200078e001aULL,
0x0000000b043d7c11ULL, 0x002fe4000f8e20ffULL, 0x0000000b14577c11ULL, 0x000fe2000f8e20ffULL,
0x0000000038437faeULL, 0x0003e2000c101c4eULL, 0x0000000b3e5b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b405d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003a417faeULL, 0x0003e8000c901c4eULL,
0x00000000183d7faeULL, 0x0003e8000d101c4eULL, 0x0000000010577faeULL, 0x0003e8000d901c4eULL,
0x00000000125b7faeULL, 0x0003e8000f101c4eULL, 0x00000000163f7faeULL, 0x0003e8000e901c4eULL,
0x000000001a5d7faeULL, 0x0003e2000e101c4eULL, 0x0000000400887947ULL, 0x000fea0003800000ULL,
0x0000000800137811ULL, 0x040fe200078fe8ffULL, 0x00000020090a7890ULL, 0x000fe2000fffe03fULL,
0x0000000400117811ULL, 0x040fe400078fe8ffULL, 0x0000001000397811ULL, 0x040fe200078fe8ffULL,
0x0000000113437824ULL, 0x140fe200078e0200ULL, 0x0000001400577811ULL, 0x040fe200078fe8ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x0000000c00197811ULL, 0x040fe200078fe8ffULL,
0x0000000111427824ULL, 0x140fe200078e0200ULL, 0x00000018005b7811ULL, 0x040fe200078fe8ffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0xfffffff810437812ULL, 0x000fe200078ee243ULL,
0x00000001393f7824ULL, 0x140fe200078e0200ULL, 0x0000000000417211ULL, 0x040fe200078fe8ffULL,
0x0000000839107824ULL, 0x000fe200078e00ffULL, 0xfffffff817427812ULL, 0x000fe200078ee242ULL,
0x00000001573e7824ULL, 0x140fe200078e0200ULL, 0x0000001c005d7811ULL, 0x040fe200078fe8ffULL,
0x0000000857177824ULL, 0x000fe200078e00ffULL, 0xfffffff8103f7812ULL, 0x000fe200078ee23fULL,
0x0000000a11187c36ULL, 0x000fe20008000000ULL, 0x0000000704417812ULL, 0x000fe200078ef841ULL,
0x0000000a13127c36ULL, 0x000fe20008000000ULL, 0xfffffff8173e7812ULL, 0x000fe200078ee23eULL,
0x0000000a19107c36ULL, 0x000fe20008000000ULL, 0x0000000a00177c11ULL, 0x000fe2000f8fe8ffULL,
0x0000000119407824ULL, 0x140fe200078e0200ULL, 0x0000000c18187c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008191b7824ULL, 0x000fe200078e00ffULL, 0x0000000c12127c10ULL, 0x000fe2000ff5e0ffULL,
0x000000015b147824ULL, 0x100fe200078e0200ULL, 0x0000000c10107c10ULL, 0x000fe2000ff7e0ffULL,
0x000000015d047824ULL, 0x000fe200078e0200ULL, 0xfffffff81b407812ULL, 0x000fe200078ee240ULL,
0x000000085b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000c17177c10ULL, 0x000fe2000ff1e0ffULL,
0x000000085d3b7824ULL, 0x000fe200078e00ffULL, 0x0000000b41417c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff197224ULL, 0x000fe200008e06ffULL, 0x00000018181a7c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00000018123a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x00000018103c7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0xfffffff81b147812ULL, 0x000fe200078ee214ULL,
0x0000000a39397c36ULL, 0x000fe20008000000ULL, 0xfffffff83b047812ULL, 0x000fc400078ee204ULL,
0x0000001817167c11ULL, 0x040fe4000f8048ffULL, 0x00000019181b7c11ULL, 0x000fe200088f4c19ULL,
0x0000000a57197c36ULL, 0x000fe20008000000ULL, 0x00000019123b7c11ULL, 0x000fe200090f4c13ULL,
0x0000000a5b137c36ULL, 0x000fe20008000000ULL, 0x00000019103d7c11ULL, 0x000fe200098f4c11ULL,
0x0000000a5d117c36ULL, 0x000fe20008000000ULL, 0x0000001917177c11ULL, 0x000fe200080f4c38ULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x0000000c39397c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000c19197c10ULL, 0x000fe2000ff3e0ffULL, 0x000000100a167825ULL, 0x040fe200078e0016ULL,
0x0000000c13137c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000c11117c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff5e7224ULL, 0x000fe200000e06ffULL, 0x0000001839387c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff5c7224ULL, 0x000fe200008e06ffULL, 0x0000001819187c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff5a7224ULL, 0x000fe200010e06ffULL, 0x0000001813127c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff567224ULL, 0x000fe200018e06ffULL, 0x0000001811107c11ULL, 0x000fe2000f8648ffULL,
0x000000100a3a7825ULL, 0x040fe200078e003aULL, 0x0000001939397c11ULL, 0x000fe200080f4c5eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016417faeULL, 0x0003e2000b901c4eULL,
0x0000001919197c11ULL, 0x000fe200088f4c5cULL, 0x000000100a3c7825ULL, 0x000fe200078e003cULL,
0x0000001913137c11ULL, 0x000fc400090f4c5aULL, 0x0000000b42577c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a387825ULL, 0x040fe200078e0038ULL, 0x0000001911117c11ULL, 0x000fe400098f4c56ULL,
0x0000000b43437c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a187825ULL, 0x000fe200078e0018ULL,
0x0000000b405b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a577faeULL, 0x0003e2000b901c4eULL,
0x0000000b3f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a127825ULL, 0x000fe200078e0012ULL,
0x0000000b3e5d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003a437faeULL, 0x0003e2000b901c4eULL,
0x0000000b145f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a107825ULL, 0x000fe200078e0010ULL,
0x0000000b04617c11ULL, 0x000fe2000f8e20ffULL, 0x000000003c5b7faeULL, 0x0003e8000b901c4eULL,
0x00000000383f7faeULL, 0x0003e8000b901c4eULL, 0x00000000185d7faeULL, 0x0003e8000b901c4eULL,
0x00000000125f7faeULL, 0x0003e8000b901c4eULL, 0x0000000010617faeULL, 0x0003e4000b901c4eULL,
0x00000003140b7892ULL, 0x000fe2000f8ec03fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd100a7891ULL, 0x000fe4000f8e103fULL, 0x000000030b00788cULL, 0x000fc8000bf05270ULL,
0x000000010a0a7887ULL, 0x000fc8000c000000ULL, 0x0000000a14147290ULL, 0x000fc8000fffe03fULL,
0x000000061400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000008140c8290ULL, 0x000fe2000fffe03fULL, 0x00008c00000a8ab9ULL, 0x000fc60000000a00ULL,
0x000000040c0a88a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff107e24ULL, 0x002fe4000f8e00ffULL,
0x0000000bff117e24ULL, 0x000fca000f8e00ffULL, 0x0000000e10108981ULL, 0x000ea2000c1e1900ULL,
0x01c66815581479a7ULL, 0x000e620008500004ULL, 0xffffffff000a7882ULL, 0x000fe20000000000ULL,
0x00000000100b82caULL, 0x004fda00000e0000ULL, 0x0000000b000a8c82ULL, 0x000fe20008000000ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x01c66815580075a7ULL, 0x002e640008000144ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011413ULL,
0x0000001704047211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000204047819ULL, 0x000fc80000001213ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01c66815580075a7ULL, 0x000e640008000144ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x01c18000030a7984ULL, 0x000e680000000800ULL, 0x01c3800003047984ULL, 0x0004a20000000800ULL,
0x000000090a00720bULL, 0x002fda0003f1d000ULL, 0x0000000000127806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff12ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f09947ULL, 0x004fea0003800000ULL, 0x000000031100788cULL, 0x000fe2000bf05270ULL,
0x000000090a00720bULL, 0x000fca0003f14000ULL, 0x000000000000781cULL, 0x000fd00003f2f008ULL,
0x0000000000137806ULL, 0x000fc800000e0100ULL, 0x0000991013117816ULL, 0x000fe400000000ffULL,
0x000000090a109209ULL, 0x000fe40007810000ULL, 0x000000ff1100720cULL, 0x000fc60003f05270ULL,
0x01c5801003009388ULL, 0x0003f40000000800ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x000000090a107209ULL, 0x000fe40007810000ULL, 0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0013ff7812ULL, 0x000fe2000782c0ffULL, 0x0000000910037221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b03037820ULL, 0x000fc80000410000ULL, 0x0000000300117308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fca0000011600ULL,
0x00001f1011037589ULL, 0x006e6400000e0000ULL, 0x0000000334347220ULL, 0x082fe20000410000ULL,
0x0000000335357220ULL, 0x080fe20000410000ULL, 0x0000000330307220ULL, 0x080fe20000410000ULL,
0x0000000331317220ULL, 0x080fe20000410000ULL, 0x0000000344447220ULL, 0x080fe20000410000ULL,
0x0000000345457220ULL, 0x080fe20000410000ULL, 0x000000032c2c7220ULL, 0x080fe20000410000ULL,
0x000000032d2d7220ULL, 0x080fe20000410000ULL, 0x0000000328287220ULL, 0x080fe20000410000ULL,
0x0000000329297220ULL, 0x080fe20000410000ULL, 0x0000000324247220ULL, 0x080fe20000410000ULL,
0x0000000325257220ULL, 0x080fe20000410000ULL, 0x0000000320207220ULL, 0x080fe20000410000ULL,
0x0000000321217220ULL, 0x080fe20000410000ULL, 0x000000031c1c7220ULL, 0x080fe20000410000ULL,
0x000000031d1d7220ULL, 0x000fce0000410000ULL, 0x0000001102027220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x0000000800107811ULL, 0x000fca00078ff0ffULL,
0x00001f1011037589ULL, 0x002e6400000e0000ULL, 0x0000000336367220ULL, 0x082fe20000410000ULL,
0x0000000337377220ULL, 0x080fe20000410000ULL, 0x0000000332327220ULL, 0x080fe20000410000ULL,
0x0000000333337220ULL, 0x080fe20000410000ULL, 0x0000000346467220ULL, 0x080fe20000410000ULL,
0x0000000347477220ULL, 0x080fe20000410000ULL, 0x000000032e2e7220ULL, 0x080fe20000410000ULL,
0x000000032f2f7220ULL, 0x080fe20000410000ULL, 0x000000032a2a7220ULL, 0x080fe20000410000ULL,
0x000000032b2b7220ULL, 0x080fe20000410000ULL, 0x0000000326267220ULL, 0x080fe20000410000ULL,
0x0000000327277220ULL, 0x080fe20000410000ULL, 0x0000000322227220ULL, 0x080fe20000410000ULL,
0x0000000323237220ULL, 0x080fe20000410000ULL, 0x000000031e1e7220ULL, 0x080fe20000410000ULL,
0x000000031f1f7220ULL, 0x000fce0000410000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007800812ULL,
0x000000090a097209ULL, 0x000fd60007810000ULL, 0x800000090a0a0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00050308ULL, 0x000ea40000000800ULL,
0x0000000504040220ULL, 0x004fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff067819ULL, 0x000fe40000011600ULL,
0x00000005ff03723eULL, 0x002fc600000000ffULL, 0x00000008060a7836ULL, 0x000fe20000000000ULL,
0x0000541003037816ULL, 0x000fca0000000003ULL, 0x00001f0603067589ULL, 0x0002a800000e0000ULL,
0x00001f0a03077589ULL, 0x0002e400000e0000ULL, 0x013800004e10783bULL, 0x0002e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000610107232ULL, 0x08cfe40000000000ULL,
0x0000000612127232ULL, 0x000fe40000000000ULL, 0x0000000711117232ULL, 0x080fe40000000000ULL,
0x0000000713137232ULL, 0x000fce0000000000ULL, 0x000000004d14783bULL, 0x000f280000004200ULL,
0x000000005018783bULL, 0x000f680000004200ULL, 0x000000005238783bULL, 0x000f680000004200ULL,
0x00000000533c783bULL, 0x000f620000004200ULL, 0x000000141034723cULL, 0x018fec0000001834ULL,
0x000000181044723cULL, 0x022fec0000001844ULL, 0x000000161014723cULL, 0x000fec0000001830ULL,
0x0000001a1018723cULL, 0x000fec000000182cULL, 0x000000381028723cULL, 0x000fec0000001828ULL,
0x0000003a1024723cULL, 0x000fec0000001824ULL, 0x0000003c1020723cULL, 0x004fec0000001820ULL,
0x0000003e1010723cULL, 0x000fe2000000181cULL, 0x01380000551c783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x000000061c1c7232ULL, 0x084fe40000000000ULL, 0x000000061e1e7232ULL, 0x000fe40000000000ULL,
0x000000071d1d7232ULL, 0x080fe40000000000ULL, 0x000000071f1f7232ULL, 0x000fce0000000000ULL,
0x000000004f2c783bULL, 0x000ee20000004200ULL, 0x00000005100b7290ULL, 0x000fe2000fffe03fULL,
0x0000000204027221ULL, 0x000fe40000010000ULL, 0x000000005454783bULL, 0x002e620000004200ULL,
0x000000010b0c7890ULL, 0x000fc6000fffe03fULL, 0x000000005150783bULL, 0x000f220000004200ULL,
0x000000070c00728cULL, 0x000fc6000bf06070ULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x00008400000c7ab9ULL, 0x000fe40000000800ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x0000000c0a0c72a4ULL, 0x000fc8000f8e023fULL, 0x000000060c0c7899ULL, 0x000fe2000800063fULL,
0x0000002c1c28723cULL, 0x00cfec0000001828ULL, 0x000000541c34723cULL, 0x002fec0000001834ULL,
0x000000561c14723cULL, 0x000fec0000001814ULL, 0x000000501c44723cULL, 0x010fec0000001844ULL,
0x000000521c18723cULL, 0x000fec0000001818ULL, 0x0000002e1c24723cULL, 0x000fec0000001824ULL,
0x0000004c1c20723cULL, 0x020fec0000001820ULL, 0x0000004e1c10723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400d09947ULL, 0x000fde0003800000ULL, 0x00000003ff337819ULL, 0x100fe20000011600ULL,
0x000000080b0b7899ULL, 0x000fe2000800063fULL, 0x0000001259597c36ULL, 0x000fe20008000000ULL,
0x00008a0000167ab9ULL, 0x000fe40000000a00ULL, 0x00000004332d7836ULL, 0x000fe20000000000ULL,
0x0000000b1300728cULL, 0x000fe2000bf01070ULL, 0x0000000833417836ULL, 0x000fe40000000000ULL,
0x000000012d037824ULL, 0x040fe200078e0200ULL, 0x0000000b130d7287ULL, 0x000fe2000c000000ULL,
0x000000082d4c7824ULL, 0x000fc400078e00ffULL, 0x0000000c334d7836ULL, 0x000fe40000000000ULL,
0x00000014333b7836ULL, 0x000fe20000000000ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee203ULL,
0x00000001413a7824ULL, 0x140fe400078e0200ULL, 0x0000000841037824ULL, 0x000fe400078e00ffULL,
0x000000014d397824ULL, 0x140fe400078e0200ULL, 0x000000084d047824ULL, 0x000fe200078e00ffULL,
0xfffffff8033a7812ULL, 0x000fe200078ee23aULL, 0x000000013b0a7824ULL, 0x000fc400078e0200ULL,
0x000000083b1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff804397812ULL, 0x000fe200078ee239ULL,
0x00000010333d7836ULL, 0x000fe40000000000ULL, 0x00000018333f7836ULL, 0x000fe20000000000ULL,
0xfffffff81d0a7812ULL, 0x000fe200078ee20aULL, 0x000000013d387824ULL, 0x100fe200078e0200ULL,
0x0000001539397c11ULL, 0x000fe2000f8e20ffULL, 0x000000083d037824ULL, 0x000fe400078e00ffULL,
0x000000013f047824ULL, 0x000fc400078e0200ULL, 0x000000083f1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff803387812ULL, 0x000fe200078ee238ULL, 0x0000001c334f7836ULL, 0x000fe40000000000ULL,
0x00000009331f7c36ULL, 0x000fe20008000000ULL, 0xfffffff81d047812ULL, 0x000fe200078ee204ULL,
0x000000014f037824ULL, 0x040fe400078e0200ULL, 0x000000084f1c7824ULL, 0x000fe200078e00ffULL,
0x0000000c1f1f7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000092d1d7c36ULL, 0x000fc40008000000ULL,
0x8000000bff3e7e24ULL, 0x000fe2000f8e02ffULL, 0xfffffff81c037812ULL, 0x000fe200078ee203ULL,
0x00000009411c7c36ULL, 0x000fe20008000000ULL, 0x0000000c1d1d7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000dff2f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000001503037c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2c7224ULL, 0x000fe200008e06ffULL, 0x0000000c1c1c7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x000000161d2e7c11ULL, 0x000fe2000f8448ffULL,
0x000000093b407c36ULL, 0x000fe20008000000ULL, 0x000000161f307c11ULL, 0x000fe2000f8248ffULL,
0x000000093f427c36ULL, 0x000fe20008000000ULL, 0x000000202f3e7446ULL, 0x000fc4000380003eULL,
0x000000171d2f7c11ULL, 0x000fe200090f4c1eULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x000000171f317c11ULL, 0x000fe200088f4c2cULL, 0x000000093d1e7c36ULL, 0x000fe20008000000ULL,
0x000000161c2c7c11ULL, 0x040fe2000f8248ffULL, 0x000000094d1f7c36ULL, 0x000fe20008000000ULL,
0x0000003e2d00720cULL, 0x000fe20003fa6070ULL, 0x00000010592e7825ULL, 0x000fe200078e002eULL,
0x000000171c2d7c11ULL, 0x000fe400088f4c1dULL, 0x0000000c1e1d7c10ULL, 0x000fc4000ff9e0ffULL,
0x0000000c1f1f7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000010592c7825ULL, 0x000fe200078e002cULL,
0x0000003e3300720cULL, 0x080fe40003f46070ULL, 0x0000003e4100720cULL, 0x000fe20003f26070ULL,
0x0000000133337824ULL, 0x000fe400078e0200ULL, 0x000000ffff327224ULL, 0x000fe200020e06ffULL,
0x000000161d1c7c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x000000161f1e7c11ULL, 0x000fc4000f8648ffULL, 0x0000000733337812ULL, 0x000fe400078ec0ffULL,
0x000000171d1d7c11ULL, 0x000fe4000a0f4c32ULL, 0x000000171f1f7c11ULL, 0x000fe400098f4c3cULL,
0x0ffffff833327812ULL, 0x000fe200078ef800ULL, 0x00000010591c7825ULL, 0x040fe200078e001cULL,
0x0000000c40337c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001532437c11ULL, 0x000fe2000f8e20ffULL,
0x0000001059407825ULL, 0x000fe200078e0030ULL, 0x0000003e4d00720cULL, 0x000fc40003f86070ULL,
0x000000154c4d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x0000001633327c11ULL, 0x000fe2000f8648ffULL, 0x000000094f307c36ULL, 0x000fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040437faeULL, 0x000fe2000d101c4eULL,
0x00000010591e7825ULL, 0x000fe200078e001eULL, 0x0000001733337c11ULL, 0x000fe400098f4c3cULL,
0x0000000c42317c10ULL, 0x000fe2000ff7e0ffULL, 0x000000002e4d7faeULL, 0x0003e2000e901c4eULL,
0x0000000c30427c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001059327825ULL, 0x000fe200078e0032ULL,
0x0000001631307c11ULL, 0x000fc4000f8c48ffULL, 0x0000003e3f00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x0000003e3d00720cULL, 0x080fe20003f66070ULL,
0x000000ffff3d7224ULL, 0x000fe200010e06ffULL, 0x000000150a3f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001731317c11ULL, 0x000fe4000b0f4c3cULL, 0x00000016423c7c11ULL, 0x040fe4000f8448ffULL,
0x0000003e3b00720cULL, 0x000fe20003fc6070ULL, 0x0000001059307825ULL, 0x000fe200078e0030ULL,
0x00000017423d7c11ULL, 0x000fc400090f4c3dULL, 0x0000003e4f00720cULL, 0x000fe40003f46070ULL,
0x000000153a3b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010592e7825ULL, 0x002fe200078e003cULL,
0x00000015383d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001504417c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c3b7faeULL, 0x0003e8000c901c4eULL, 0x000000001e397faeULL, 0x0003e8000e101c4eULL,
0x000000001c3d7faeULL, 0x0003e8000d901c4eULL, 0x00000000323f7faeULL, 0x0003e8000f101c4eULL,
0x0000000030417faeULL, 0x0003e8000e901c4eULL, 0x000000002e037faeULL, 0x0003e2000d101c4eULL,
0x0000000400907947ULL, 0x000fea0003800000ULL, 0x00000008001f7811ULL, 0x040fe200078fe8ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000001000337811ULL, 0x040fe200078fe8ffULL,
0x0000001259597c36ULL, 0x000fe20008000000ULL, 0x0000000c002d7811ULL, 0x040fe200078fe8ffULL,
0x000000011f047824ULL, 0x140fe200078e0200ULL, 0x00000004001d7811ULL, 0x040fe200078fe8ffULL,
0x000000081f437824ULL, 0x000fe200078e00ffULL, 0x0000001400397811ULL, 0x040fe200078fe8ffULL,
0x00000001331c7824ULL, 0x140fe200078e0200ULL, 0x00000018003f7811ULL, 0x040fe200078fe8ffULL,
0x0000000833317824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee204ULL,
0x000000012d0a7824ULL, 0x140fe200078e0200ULL, 0x0000001c004d7811ULL, 0x040fe200078fe8ffULL,
0x000000082d2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff831047812ULL, 0x000fe200078ee21cULL,
0x000000011d037824ULL, 0x140fe200078e0200ULL, 0x00000009001c7c11ULL, 0x040fe2000f8fe8ffULL,
0x000000081d1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f0a7812ULL, 0x000fe200078ee20aULL,
0x00000001393c7824ULL, 0x140fe200078e0200ULL, 0x0000000c1c1c7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008392f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e417812ULL, 0x000fe200078ee203ULL,
0x000000013f037824ULL, 0x140fe200078e0200ULL, 0x0000000000317211ULL, 0x000fe200078fe8ffULL,
0x000000083f1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f3c7812ULL, 0x000fe200078ee23cULL,
0x000000014d3d7824ULL, 0x000fe200078e0200ULL, 0x0000000731317812ULL, 0x000fe200078ec0ffULL,
0x000000084d2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e037812ULL, 0x000fe200078ee203ULL,
0x000000091d2f7c36ULL, 0x000fe20008000000ULL, 0x0000001541417c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0xfffffff82c3d7812ULL, 0x000fe200078ee23dULL,
0x000000091f1f7c36ULL, 0x000fe20008000000ULL, 0x000000161c2c7c11ULL, 0x040fe2000f8248ffULL,
0x000000092d1e7c36ULL, 0x000fe20008000000ULL, 0x0000000c2f2f7c10ULL, 0x000fe2000ff5e0ffULL,
0x00000009333b7c36ULL, 0x000fe20008000000ULL, 0x000000171c2d7c11ULL, 0x000fe200088f4c1dULL,
0x0000000939397c36ULL, 0x000fe20008000000ULL, 0x0000000c1f1f7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x0000000c1e1d7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000093f337c36ULL, 0x000fe20008000000ULL, 0x000000161f1e7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x000000161d1c7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x000000162f2e7c11ULL, 0x000fe2000f8248ffULL,
0x000000094d4d7c36ULL, 0x000fe20008000000ULL, 0x000000171f1f7c11ULL, 0x000fe200090f4c32ULL,
0x00000010592c7825ULL, 0x000fe200078e002cULL, 0x000000171d1d7c11ULL, 0x000fc400098f4c30ULL,
0x0000000c3b3b7c10ULL, 0x000fe2000ff5e0ffULL, 0x00000010591e7825ULL, 0x000fe200078e001eULL,
0x0000000c39397c10ULL, 0x000fe4000ff7e0ffULL, 0x000000172f2f7c11ULL, 0x000fe200088f4c38ULL,
0x000000ffff4c7224ULL, 0x000fe200010e06ffULL, 0x0ffffff831307812ULL, 0x000fe200078ef800ULL,
0x000000ffff427224ULL, 0x000fe200018e06ffULL, 0x0000000c33337c10ULL, 0x000fe2000ff9e0ffULL,
0x00000010592e7825ULL, 0x000fe200078e002eULL, 0x0000000c4d317c10ULL, 0x000fc4000ff3e0ffULL,
0x000000163b3a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x0000001639387c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x00000015303f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010591c7825ULL, 0x000fe200078e001cULL,
0x0000001633327c11ULL, 0x000fe4000f8848ffULL, 0x0000001631307c11ULL, 0x000fe2000f8248ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c3f7faeULL, 0x0003e2000b901c4eULL,
0x000000173b3b7c11ULL, 0x000fc400090f4c4cULL, 0x0000001739397c11ULL, 0x000fe200098f4c42ULL,
0x000000002e417faeULL, 0x0005e2000b901c4eULL, 0x0000001733337c11ULL, 0x000fe2000a0f4c40ULL,
0x00000010593a7825ULL, 0x000fe200078e003aULL, 0x0000001731317c11ULL, 0x000fe400088f4c3eULL,
0x0000001543437c11ULL, 0x000fe2000f8e20ffULL, 0x0000001059387825ULL, 0x040fe200078e0038ULL,
0x000000153c4d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000150a2d7c11ULL, 0x002fe2000f8e20ffULL,
0x0000001059327825ULL, 0x000fe200078e0032ULL, 0x00000015043f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001e437faeULL, 0x0005e2000b901c4eULL, 0x0000001503037c11ULL, 0x000fe2000f8e20ffULL,
0x0000001059307825ULL, 0x000fe200078e0030ULL, 0x000000153d3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001c2d7faeULL, 0x0005e8000b901c4eULL, 0x000000003a3f7faeULL, 0x0005e8000b901c4eULL,
0x00000000384d7faeULL, 0x0005e8000b901c4eULL, 0x0000000032037faeULL, 0x0005e8000b901c4eULL,
0x00000000303d7faeULL, 0x0005e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff067819ULL, 0x000fe40000011600ULL, 0x00000005ff03723eULL, 0x006fc600000000ffULL,
0x0000000806047836ULL, 0x000fe20000000000ULL, 0x0000541003037816ULL, 0x000fca0000000003ULL,
0x00001f0603067589ULL, 0x0002a800000e0000ULL, 0x00001f0403077589ULL, 0x0002e400000e0000ULL,
0x013800004b1c783bULL, 0x0062a20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x000000061c1c7232ULL, 0x084fe40000000000ULL, 0x000000061e1e7232ULL, 0x000fe40000000000ULL,
0x000000071d1d7232ULL, 0x088fe40000000000ULL, 0x000000071f1f7232ULL, 0x000fce0000000000ULL,
0x000000004a38783bULL, 0x000f280000004200ULL, 0x00000000493c783bULL, 0x000f680000004200ULL,
0x000000004830783bULL, 0x000f680000004200ULL, 0x000000000f2c783bULL, 0x000f620000004200ULL,
0x000000381c34723cULL, 0x014fec0000001834ULL, 0x0000003a1c14723cULL, 0x000fec0000001814ULL,
0x0000003c1c44723cULL, 0x022fec0000001844ULL, 0x0000003e1c18723cULL, 0x000fec0000001818ULL,
0x000000301c28723cULL, 0x008fec0000001828ULL, 0x000000321c24723cULL, 0x000fec0000001824ULL,
0x0000002c1c20723cULL, 0x000fec0000001820ULL, 0x0000002e1c10723cULL, 0x000fe20000001810ULL,
0x01380000081c783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x000000061c1c7232ULL, 0x084fe40000000000ULL,
0x000000061e1e7232ULL, 0x000fe40000000000ULL, 0x000000071d1d7232ULL, 0x080fe40000000000ULL,
0x000000071f1f7232ULL, 0x000fce0000000000ULL, 0x000000000c30783bULL, 0x000ee20000004200ULL,
0x00000001ff037424ULL, 0x000fc600078e00ffULL, 0x000000000e2c783bULL, 0x000f280000004200ULL,
0x000000000d38783bULL, 0x000f680000004200ULL, 0x000000000b3c783bULL, 0x000f620000004200ULL,
0x01c6a003ffff79a7ULL, 0x0007e40008500004ULL, 0x000000301c34723cULL, 0x00cfec0000001834ULL,
0x0000002c1c44723cULL, 0x010fec0000001844ULL, 0x000000321c30723cULL, 0x000fec0000001814ULL,
0x0000002e1c2c723cULL, 0x000fec0000001818ULL, 0x000000381c28723cULL, 0x022fec0000001828ULL,
0x0000003a1c24723cULL, 0x000fec0000001824ULL, 0x0000003c1c20723cULL, 0x000fec0000001820ULL,
0x0000003e1c1c723cULL, 0x000fde0000001810ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000510057290ULL, 0x000fc8000fffe03fULL, 0x000000070500728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0xffffff5800208947ULL, 0x000fea000383ffffULL,
0x00000000001479c3ULL, 0x000e640000002500ULL, 0x000000071400728cULL, 0x002fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000c40947ULL, 0x000fea0003800000ULL,
0x0180000002007836ULL, 0x000fca0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000c18000047802ULL, 0x000fce0000000f00ULL, 0x000000d0005c7944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000002ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000047919ULL, 0x000f240000000000ULL,
0x00000002ff037819ULL, 0x010fe40000011604ULL, 0x0000000804057811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0500047589ULL, 0x000ee200000e0000ULL, 0x0000003403347220ULL, 0x044fe20000410000ULL,
0x0000003503357220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x040fe20000410000ULL, 0x0000004403447220ULL, 0x040fe20000410000ULL,
0x0000004503457220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000002803287220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002403247220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002003207220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x000fe20000410000ULL, 0x0000003604367220ULL, 0x048fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000004604467220ULL, 0x040fe20000410000ULL,
0x0000004704477220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000411067291ULL, 0x000fe2000f8e583fULL, 0x00000028290c723eULL, 0x000fe200000000ffULL,
0x000000011000788cULL, 0x000fe2000bf05270ULL, 0x00000020210e723eULL, 0x000fe200000000ffULL,
0x0001200006167890ULL, 0x000fe2000fffe03fULL, 0x0000001c1d0f723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000781cULL, 0x000fc40003f0f008ULL,
0x000000363710723eULL, 0x000fe400000000ffULL, 0x000000323311723eULL, 0x000fe400000000ffULL,
0x000000464712723eULL, 0x000fe400000000ffULL, 0x0000002e2f13723eULL, 0x000fe400000000ffULL,
0x0000002a2b14723eULL, 0x000fe400000000ffULL, 0x000000262715723eULL, 0x000fc400000000ffULL,
0x000000222316723eULL, 0x000fe400000000ffULL, 0x0000001e1f17723eULL, 0x000fe400000000ffULL,
0x00000003ff037819ULL, 0x004fe40000011600ULL, 0xfffffff8ff057812ULL, 0x000fe400078ee200ULL,
0x0000000303047812ULL, 0x000fc600078ec0ffULL, 0x0000000805077836ULL, 0x000fe40000000000ULL,
0x0000000805087824ULL, 0x040fe400078e00ffULL, 0x00000008050d7824ULL, 0x000fe400078e00ffULL,
0x0000000104057824ULL, 0x040fe400078e0205ULL, 0x0000000104067824ULL, 0x000fe400078e0207ULL,
0x0000000405047836ULL, 0x000fe20000000000ULL, 0xfffffff808087812ULL, 0x000fe200078ee205ULL,
0x00000008070b7824ULL, 0x000fc400078e00ffULL, 0x0000000807187824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee204ULL, 0x0000000c05077836ULL, 0x000fe20000000000ULL,
0xfffffff80b0b7812ULL, 0x000fe400078ee206ULL, 0x000000343504723eULL, 0x000fe400000000ffULL,
0xfffffff818187812ULL, 0x000fe400078ee207ULL, 0x000000303105723eULL, 0x000fe400000000ffULL,
0x000000444506723eULL, 0x000fc400000000ffULL, 0x0000002c2d07723eULL, 0x000fe400000000ffULL,
0x0000001608087c11ULL, 0x000fe4000f8e20ffULL, 0x00000024250d723eULL, 0x000fe400000000ffULL,
0x000000160a0a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000408007844ULL, 0x0005e20000000200ULL,
0x000000160b0b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001618187c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c0a007844ULL, 0x0005e80000000200ULL, 0x000000100b007844ULL, 0x0005e80000000200ULL,
0x0000001418007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002400788947ULL, 0x000fea0003800000ULL, 0x00000000000979c3ULL, 0x000fe20000002700ULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000840000077ab9ULL, 0x000fe20000000800ULL,
0x00000011ff007c0cULL, 0x000fe2000bf05270ULL, 0x00000004070472a4ULL, 0x000fe2000f8e023fULL,
0x0000000600087c11ULL, 0x004fe2000f8e20ffULL, 0x00009600000c7ab9ULL, 0x000fe40000000a00ULL,
0x00000000000579c3ULL, 0x000ea40000002600ULL, 0x00000007090972a4ULL, 0x004fc4000f8e0205ULL,
0x0000000f04077891ULL, 0x000fe4000f8e103fULL, 0x00000010091572a4ULL, 0x000fe4000f8e023fULL,
0xfffffff007077892ULL, 0x000fe4000f8ec03fULL, 0x00000010040472a4ULL, 0x000fe4000f8e023fULL,
0x0000000c07177290ULL, 0x000fe4000ff1e03fULL, 0x00000014150a7290ULL, 0x000fc4000fffe03fULL,
0x0000000704187291ULL, 0x000fe4000f8e383fULL, 0x0000000d3f197290ULL, 0x000fe200087fe43fULL,
0x0000000000480947ULL, 0x000ff60003800000ULL, 0x000000070a057899ULL, 0x000fe2000800063fULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x000000193f087899ULL, 0x000fe2000801160aULL,
0x00000001ff057819ULL, 0x000fc60000011600ULL, 0x00000005ff077e24ULL, 0x000fe2000f8e00ffULL,
0x0000007004067812ULL, 0x000fe200078ec0ffULL, 0x0000000c05057290ULL, 0x000fe2000f91e018ULL,
0x0000000c05057812ULL, 0x000fe400078ec0ffULL, 0x0000001706047c10ULL, 0x000fe2000fa3e007ULL,
0x00000008ff077e24ULL, 0x000fe2000f8e00ffULL, 0x0000000d08087290ULL, 0x000fe200087e243fULL,
0x0000000505067c10ULL, 0x000fe4000fd9e006ULL, 0x0000000405047210ULL, 0x000fc40007f7e0ffULL,
0x00000019ff057c10ULL, 0x000fe40008fe4407ULL, 0x00000008ff077c10ULL, 0x000fc6000a7ea4ffULL,
0x000000ffff057224ULL, 0x000fca00018e0605ULL, 0x0000000904007986ULL, 0x0005e8000c10190eULL,
0x0000000206007986ULL, 0x0005e4000c10190eULL, 0x0000001804047291ULL, 0x000fe2000f8e383fULL,
0x01200000080c7984ULL, 0x000ee20000000c00ULL, 0x000000ff0000720cULL, 0x000fe20000705670ULL,
0x0000002000097836ULL, 0x004fe20000000000ULL, 0x0000007f04047890ULL, 0x000fe2000fffe03fULL,
0x0122000008107984ULL, 0x000ea20000000c00ULL, 0x000002e000007945ULL, 0x000fe40003800000ULL,
0xffffff8004087892ULL, 0x000fc8000f8ec03fULL, 0x0000000c08047290ULL, 0x000fc8000ff1e03fULL,
0x0000000d3f057290ULL, 0x000fe400087fe43fULL, 0x000000040a047291ULL, 0x000fc8000f80603fULL,
0x000000050a057291ULL, 0x000fc800080f643fULL, 0x00000400110478a5ULL, 0x000fcc000f8e0004ULL,
0x00000004ff067e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff077e24ULL, 0x000fe4000f8e00ffULL,
0x0000001000047825ULL, 0x000fc800078e0006ULL, 0x0000001009067825ULL, 0x000fe200078e0006ULL,
0x0000000c04007986ULL, 0x0087e8000c101d0eULL, 0x0000001006007986ULL, 0x0047e2000c101d0eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000007c0947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff100a7890ULL, 0x000fe4000fffe03fULL, 0x00000004090478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000aff077e24ULL, 0x008fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fca000f8e00ffULL, 0x00000007040479a8ULL, 0x00052200099ee1ceULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000a04007c0cULL, 0x010fc8000bf05270ULL,
0x00000001ff027807ULL, 0x002fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000002ff007988ULL, 0x0003e60008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000f220000008800ULL, 0x0000040000097882ULL, 0x000fce0000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000065404097896ULL, 0x010fd20008000009ULL,
0x00000009ff027984ULL, 0x002e640008000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x0000001c00f88947ULL, 0x000fea0003800000ULL, 0x00000011ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800f00947ULL, 0x000fea0003800000ULL, 0x00000010ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000000848947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x0000001715047291ULL, 0x000fc6000f80383fULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x0000001915057291ULL, 0x000fe200080f3c3fULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000403027c10ULL, 0x000fc8000f91e002ULL,
0x00000005ff037c10ULL, 0x000fca00087e24ffULL, 0x0000000e02067981ULL, 0x008328000c1e1900ULL,
0x0000800e02077981ULL, 0x004322000c1e1900ULL, 0x000000021000788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000508947ULL, 0x002fea0003800000ULL,
0x0001000e02097981ULL, 0x000322000c1e1900ULL, 0x000000041000788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000408947ULL, 0x002fea0003800000ULL,
0x0001800e020b7981ULL, 0x000322000c1e1900ULL, 0x000000041000788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x0002000e020d7981ULL, 0x000322000c1e1900ULL, 0x000000061000788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000208947ULL, 0x002fea0003800000ULL,
0x0002800e020f7981ULL, 0x000322000c1e1900ULL, 0x000000061000788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000108947ULL, 0x002fea0003800000ULL,
0x000000081000788cULL, 0x000fe2000bf06070ULL, 0x0003000e02117981ULL, 0x00032a000c1e1900ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0003800e02130981ULL, 0x000324000c1e1900ULL,
0x0000000710047890ULL, 0x000fc8000fffe03fULL, 0x000000033f0a7899ULL, 0x000fcc0008011604ULL,
0x0000000aff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800388947ULL, 0x000fea0003800000ULL,
0x00000007150b7291ULL, 0x000fe2000f80383fULL, 0x000000ffff057224ULL, 0x01cfe200078e0006ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000000c0b0b7290ULL, 0x000fe4000ff3e03fULL, 0x0000003f15137291ULL, 0x000fe400080f3c3fULL,
0x000007800b0b7890ULL, 0x000fc8000ff1e03fULL, 0x000000133f137290ULL, 0x000fd800087e240dULL,
0x000000100400728cULL, 0x000fe4000bf06070ULL, 0x0000000105057890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000a0500728cULL, 0x000fd8000bf06070ULL,
0x0000000400f00947ULL, 0x012fea0003800000ULL, 0x00000008041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000506067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000013ff037e24ULL, 0x000fca00080e06ffULL,
0xfffc800e02057981ULL, 0x000326000c1e1900ULL, 0x00000001041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000400b00947ULL, 0x000fea0003800000ULL, 0x00000009041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000706067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000013ff037e24ULL, 0x000fca00080e06ffULL,
0xfffd000e02077981ULL, 0x000326000c1e1900ULL, 0x00000002041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000400700947ULL, 0x000fea0003800000ULL, 0x0000000a041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000906067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000013ff037e24ULL, 0x000fca00080e06ffULL,
0xfffd800e02097981ULL, 0x000326000c1e1900ULL, 0x00000003041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000400300947ULL, 0x000fea0003800000ULL, 0x0000000b041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000b06067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000013ff037e24ULL, 0x000fca00080e06ffULL,
0xfffe000e020b7981ULL, 0x000326000c1e1900ULL, 0x00000004041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000f00947ULL, 0x000fea0003800000ULL, 0x0000000c041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000d06067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000013ff037e24ULL, 0x000fca00080e06ffULL,
0xfffe800e020d7981ULL, 0x000326000c1e1900ULL, 0x00000005041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000b00947ULL, 0x000fea0003800000ULL, 0x0000000d041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000f06067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000013ff037e24ULL, 0x000fca00080e06ffULL,
0xffff000e020f7981ULL, 0x000326000c1e1900ULL, 0x00000006041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x0000000e041a7890ULL, 0x000fe2000fffe03fULL,
0x0000001106067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000013ff037e24ULL, 0x000fca00080e06ffULL,
0xffff800e02117981ULL, 0x000326000c1e1900ULL, 0x00000007041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000300947ULL, 0x000fea0003800000ULL, 0x0000000f041a7890ULL, 0x000fe2000fffe03fULL,
0x0000001306067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000013ff037e24ULL, 0x000fca00080e06ffULL,
0x0000000e02137981ULL, 0x000326000c1e1900ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000004000b0b7890ULL, 0x000fe4000ff3e03fULL, 0x0000000804047890ULL, 0x000fe4000fffe03fULL,
0x000000133f137290ULL, 0x000fd00008ffe43fULL, 0xfffffff400e88947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000f640000000000ULL, 0x0000001000027824ULL, 0x022fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000903037c10ULL, 0x000fca000fffe002ULL,
0x0000000603007388ULL, 0x0103e40000000800ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000004081a7290ULL, 0x000fe2000ff3e03fULL,
0x00000015ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000418217290ULL, 0x000fe2000ff1e03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000004070b7290ULL, 0x000fe2000ff5e03fULL,
0x00000001ff037819ULL, 0x002fe20000011600ULL, 0x000000053f1b7290ULL, 0x000fe20008ffe43fULL,
0x0000002000077836ULL, 0x00cfe20000000000ULL, 0x000000053f227290ULL, 0x000fe200087fe43fULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x000000053f137290ULL, 0x000fe200097fe43fULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x0000000a111f7899ULL, 0x000fe2000800063fULL,
0x000000210b088c11ULL, 0x040fe2000f8238ffULL, 0x00001000150478a5ULL, 0x000fe2000f8e001aULL,
0x0000000b0b0a8c11ULL, 0x040fe2000f8438ffULL, 0x000000163f207899ULL, 0x000fe20008011611ULL,
0x000000220b098c11ULL, 0x000fe200088f3cffULL, 0x0000001f040a7290ULL, 0x000fe2000ff1e03fULL,
0x00000010ff007c0cULL, 0x000fe2000bf25270ULL, 0x00000009111c7291ULL, 0x000fc4000f8e603fULL,
0x0000000903147c10ULL, 0x000fe2000fffe002ULL, 0x0000002005047290ULL, 0x000fe200087fe43fULL,
0x000000130b0b8c11ULL, 0x000fe200090f3cffULL, 0x0000000aff047e24ULL, 0x000fe2000f8e00ffULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x0000001c000d7c11ULL, 0x040fe2000f8e20ffULL,
0x0000001000088825ULL, 0x040fe200078e0008ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000004ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000911048291ULL, 0x000fe2000f8e403fULL,
0x00000010000a8825ULL, 0x040fe200078e000aULL, 0x0000000911058291ULL, 0x000fe2000f8e403fULL,
0x0000000014147984ULL, 0x000e620000000800ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000001007067825ULL, 0x000fe200078e0004ULL, 0x00000004000f8c11ULL, 0x000fc4000f8e20ffULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000500118c11ULL, 0x040fe2000f8e20ffULL,
0x0000001000047825ULL, 0x000fe200078e0004ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000040d7faeULL, 0x0005e2000b901c4eULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00380000060d7faeULL, 0x0005e2000b901c4eULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x04580000080f8faeULL, 0x0005e2000b901c4eULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x041800000a118faeULL, 0x0005e2000b901c4eULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800809947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x104fe20000011600ULL,
0x0000000911047291ULL, 0x000fe2000f8e403fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee200ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x00000001151d7890ULL, 0x000fe2000fffe03fULL, 0x00000002ff397819ULL, 0x000fe20000011600ULL,
0x0000000805077836ULL, 0x000fe20000000000ULL, 0x00000001001e7882ULL, 0x000fe20000000000ULL,
0x0000000805377824ULL, 0x000fe400078e00ffULL, 0x0000000104367824ULL, 0x000fc400078e0207ULL,
0x0000000104047824ULL, 0x000fe400078e0205ULL, 0x0000000807097824ULL, 0x000fe400078e00ffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee204ULL,
0x0000000404387836ULL, 0x000fe20000000000ULL, 0xfffffff809367812ULL, 0x000fe200078ee236ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x0000000c043a7836ULL, 0x000fe20000000000ULL,
0xfffffff805387812ULL, 0x000fe200078ee238ULL, 0x00000004ff3b7e24ULL, 0x000fc4000f8e00ffULL,
0x00000008393c7836ULL, 0x000fe20000000000ULL, 0xfffffff8073a7812ULL, 0x000fce00078ee23aULL,
0x000000101e00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000980947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f44070ULL,
0x000010001d0478a5ULL, 0x000fe4000f8e001aULL, 0x0000001dff047e24ULL, 0x000fe2000f8e00ffULL,
0x000000011e247892ULL, 0x000fe2000f8ec03fULL, 0x0000002000077836ULL, 0x000fe20000000000ULL,
0x0000001f04237290ULL, 0x000fe4000ff1e03fULL, 0x0000000b1e0a7899ULL, 0x000fe4000800063fULL,
0x0000002005047290ULL, 0x000fe200087fe43fULL, 0x00000024ff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x000008000a0a7892ULL, 0x000fe2000f8ec03fULL, 0x00000000003f7886ULL, 0x000fe20001020000ULL,
0x000000210408ac11ULL, 0x000fc4000f8038ffULL, 0x0000000a1c0a7290ULL, 0x000fe2000fffe03fULL,
0x0000000b040aac11ULL, 0x040fe2000f8238ffULL, 0x00000004ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000000911059291ULL, 0x000fe2000f8e403fULL, 0x000000220409ac11ULL, 0x040fe200080f3cffULL,
0x0000000911249291ULL, 0x000fe2000f8e403fULL, 0x00000013040bac11ULL, 0x000fe200088f3cffULL,
0x00000023ff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000000a000d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000005ff3bae24ULL, 0x000fe4000f8e00ffULL, 0x0000001007067825ULL, 0x000fc800078e0004ULL,
0x000000800c0fa824ULL, 0x000fe400078e023bULL, 0x00000024ff3bae24ULL, 0x000fe4000f8e00ffULL,
0x0000001000047825ULL, 0x000fc800078e0004ULL, 0x000000800c11a824ULL, 0x000fe200078e023bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040d7faeULL, 0x0005e2000b901c4eULL,
0x000000100008a825ULL, 0x000fc600078e0008ULL, 0x00380000060d7faeULL, 0x0005e2000b901c4eULL,
0x00000010000fa824ULL, 0x040fe400078e020fULL, 0x00000010000aa825ULL, 0x000fc600078e000aULL,
0x04580000080fafaeULL, 0x0005e2000b901c4eULL, 0x000000100011a824ULL, 0x000fca00078e0211ULL,
0x041800000a11afaeULL, 0x0005e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff1e047890ULL, 0x000fe4000fffe03fULL, 0x000000101e00728cULL, 0x000fe4000bf06070ULL,
0x0000000704057899ULL, 0x000fe4000800063fULL, 0x0000000b04047899ULL, 0x000fe4000800063fULL,
0x0000008005057892ULL, 0x000fe2000f8ec03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000080004047892ULL, 0x000fc4000f8ec03fULL, 0x000000011d1d7890ULL, 0x000fe4000fffe03fULL,
0x0000000502047c10ULL, 0x004fe2000fffe03bULL, 0x000001801c047890ULL, 0x000fe4000fffe004ULL,
0x000000011e1e7890ULL, 0x000fe4000fffe03fULL, 0x00000001033d7824ULL, 0x000fe400078e0204ULL,
0x0000000437047c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003d0d7984ULL, 0x000ea20000000800ULL, 0x0000000438087c11ULL, 0x000fe4000f8e20ffULL,
0x00000004360c7c11ULL, 0x000fe2000f8e20ffULL, 0x004580003d3f7984ULL, 0x000fe20000000800ULL,
0x000000043a107c11ULL, 0x000fc6000f8e20ffULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000808783bULL, 0x000f220000000200ULL, 0x0000000d14117221ULL, 0x006fc60000010100ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x3fb8aa3b11427820ULL, 0x000fc60000410000ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x30000005ff3e7230ULL, 0x008fe40000004100ULL,
0x0000004200427308ULL, 0x000ee20000000800ULL, 0x20000007ff417230ULL, 0x000fe40000004100ULL,
0x30000007ff407230ULL, 0x000fe40000004100ULL, 0x20000009ff437230ULL, 0x010fe40000004100ULL,
0x2000000bff457230ULL, 0x000fc40000004100ULL, 0x3000000bff447230ULL, 0x000fe40000004100ULL,
0x20000004ff3d7230ULL, 0x000fe40000004100ULL, 0x20000008ff077230ULL, 0x000fe40000004100ULL,
0x0000003f424e7220ULL, 0x008fe20000410000ULL, 0x20000005ff3f7230ULL, 0x000fe40000004100ULL,
0x30000009ff427230ULL, 0x000fe40000004100ULL, 0x000000354e357221ULL, 0x000fe20000010000ULL,
0x00001f394e4f7589ULL, 0x000ee200000e0000ULL, 0x20000006ff057230ULL, 0x000fc40000004100ULL,
0x2000000aff097230ULL, 0x000fe20000004100ULL, 0x00001f3c4e507589ULL, 0x000f2200000e0000ULL,
0x30000004ff047230ULL, 0x000fe40000004100ULL, 0x30000006ff067230ULL, 0x000fe40000004100ULL,
0x30000008ff087230ULL, 0x000fe40000004100ULL, 0x3000000aff0a7230ULL, 0x000fe40000004100ULL,
0x2000000dff477230ULL, 0x002fc40000004100ULL, 0x3000000dff467230ULL, 0x000fe40000004100ULL,
0x2000000fff497230ULL, 0x000fe40000004100ULL, 0x3000000fff487230ULL, 0x000fe40000004100ULL,
0x20000011ff4b7230ULL, 0x004fe40000004100ULL, 0x30000011ff4a7230ULL, 0x000fe40000004100ULL,
0x0000004f3d347223ULL, 0x008fe20000010034ULL, 0x2000000cff0b7230ULL, 0x000fc40000004100ULL,
0x0000004f04337223ULL, 0x080fe20000010033ULL, 0x2000000eff0d7230ULL, 0x000fe40000004100ULL,
0x0000004f3f327223ULL, 0x080fe20000010032ULL, 0x20000010ff0f7230ULL, 0x000fe40000004100ULL,
0x0000004f3e317223ULL, 0x080fe20000010031ULL, 0x20000012ff117230ULL, 0x000fe40000004100ULL,
0x0000004f05307223ULL, 0x000fe20000010030ULL, 0x3000000cff0c7230ULL, 0x000fc40000004100ULL,
0x0000004f062f7223ULL, 0x080fe2000001002fULL, 0x3000000eff0e7230ULL, 0x000fe40000004100ULL,
0x0000004f412e7223ULL, 0x080fe2000001002eULL, 0x30000010ff107230ULL, 0x000fe40000004100ULL,
0x0000004f402d7223ULL, 0x080fe2000001002dULL, 0x30000012ff127230ULL, 0x000fe40000004100ULL,
0x0000004f072c7223ULL, 0x000fe2000001002cULL, 0x20000013ff4d7230ULL, 0x000fc40000004100ULL,
0x0000004f082b7223ULL, 0x080fe2000001002bULL, 0x30000013ff4c7230ULL, 0x000fe40000004100ULL,
0x0000004f432a7223ULL, 0x080fe2000001002aULL, 0x0000004f42297223ULL, 0x080fe20000010029ULL,
0x0000004f09287223ULL, 0x080fe20000010028ULL, 0x0000004f0a277223ULL, 0x080fe20000010027ULL,
0x0000004f45267223ULL, 0x080fe20000010026ULL, 0x0000004f44257223ULL, 0x000fe20000010025ULL,
0x000000500b247223ULL, 0x090fe20000010024ULL, 0x000000500c237223ULL, 0x080fe20000010023ULL,
0x0000005047227223ULL, 0x080fe20000010022ULL, 0x0000005046217223ULL, 0x080fe20000010021ULL,
0x000000500d207223ULL, 0x080fe20000010020ULL, 0x000000500e1f7223ULL, 0x080fe2000001001fULL,
0x00000050491e7223ULL, 0x080fe2000001001eULL, 0x00000050481d7223ULL, 0x080fe2000001001dULL,
0x000000500f1c7223ULL, 0x080fe2000001001cULL, 0x00000050101b7223ULL, 0x080fe2000001001bULL,
0x000000504b1a7223ULL, 0x080fe2000001001aULL, 0x000000504a197223ULL, 0x080fe20000010019ULL,
0x0000005011187223ULL, 0x080fe20000010018ULL, 0x0000005012177223ULL, 0x080fe20000010017ULL,
0x000000504d167223ULL, 0x080fe20000010016ULL, 0x000000504c157223ULL, 0x000fe20000010015ULL,
0xfffffff400dc8947ULL, 0x000fec000383ffffULL, 0x0180000035007836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e0035ULL, 0x0000e7b000047802ULL, 0x004fce0000000f00ULL,
0x000000a800d07944ULL, 0x002fea0003c00000ULL, 0x000000ffff027224ULL, 0x00efe200078e0000ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000003500027308ULL, 0x000ee40000001000ULL,
0xbf80000002007423ULL, 0x008fc80000000035ULL, 0x800000ff00037221ULL, 0x000fc80000010100ULL,
0x0000000302027223ULL, 0x000fce0000000002ULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x00000002ff037819ULL, 0x008fe40000011600ULL, 0x00000008000d7811ULL, 0x004fe400078ff0ffULL,
0xfffffff8ff0f7812ULL, 0x000fe200078ee200ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0302037589ULL, 0x000ea200000e0000ULL, 0x000000080f117836ULL, 0x000fc60000000000ULL,
0x00001f0d020d7589ULL, 0x00072200000e0000ULL, 0x000000080f127824ULL, 0x040fe400078e00ffULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000811147824ULL, 0x002fc400078e00ffULL, 0x0000003403047220ULL, 0x044fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000003203057220ULL, 0x040fe20000410000ULL,
0x0000003103067220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000002e03077220ULL, 0x040fe20000410000ULL,
0x0000002d03087220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002a03097220ULL, 0x040fe20000410000ULL,
0x0000002903027220ULL, 0x048fe20000410000ULL, 0x00000028030a7220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x00000026030b7220ULL, 0x040fe20000410000ULL,
0x00000025030c7220ULL, 0x000fe20000410000ULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x000000240d247220ULL, 0x050fe20000410000ULL, 0x000000230d237220ULL, 0x040fe20000410000ULL,
0x000000220d227220ULL, 0x000fe20000410000ULL, 0x00000003030e7812ULL, 0x000fe200078ec0ffULL,
0x000000210d217220ULL, 0x040fe20000410000ULL, 0x000000200d207220ULL, 0x040fe20000410000ULL,
0x0000001f0d1f7220ULL, 0x040fe20000410000ULL, 0x0000001e0d1e7220ULL, 0x000fe20000410000ULL,
0x000000010e0f7824ULL, 0x000fc400078e020fULL, 0x0000001d0d1d7220ULL, 0x040fe20000410000ULL,
0x0000001c0d1c7220ULL, 0x040fe20000410000ULL, 0x0000001b0d1b7220ULL, 0x040fe20000410000ULL,
0x0000001a0d1a7220ULL, 0x040fe20000410000ULL, 0x000000190d197220ULL, 0x040fe20000410000ULL,
0x000000180d187220ULL, 0x040fe20000410000ULL, 0x000000170d177220ULL, 0x040fe20000410000ULL,
0x000000160d167220ULL, 0x040fe20000410000ULL, 0x000000010e107824ULL, 0x000fe400078e0211ULL,
0x000000150d0d7220ULL, 0x000fe20000410000ULL, 0x000000040f0e7836ULL, 0x000fe20000000000ULL,
0x000000050605723eULL, 0x000fe200000000ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x000000043304723eULL, 0x000fe200000000ffULL, 0x0000000c0f117836ULL, 0x000fe20000000000ULL,
0xfffffff8120f7812ULL, 0x000fc400078ee20fULL, 0xfffffff8130e7812ULL, 0x000fe400078ee20eULL,
0xfffffff815107812ULL, 0x000fe400078ee210ULL, 0xfffffff814117812ULL, 0x000fe400078ee211ULL,
0x000000302f06723eULL, 0x000fe400000000ffULL, 0x000000070807723eULL, 0x000fe400000000ffULL,
0x000000160f0f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000002c2b08723eULL, 0x000fe400000000ffULL,
0x000000090209723eULL, 0x000fe200000000ffULL, 0x000000040f007844ULL, 0x0003e20000000200ULL,
0x0000000a270a723eULL, 0x000fe400000000ffULL, 0x0000000b0c0b723eULL, 0x000fe400000000ffULL,
0x000000160e0e7c11ULL, 0x000fe4000f8e20ffULL, 0x000000242324723eULL, 0x000fc400000000ffULL,
0x000000222125723eULL, 0x000fe200000000ffULL, 0x000000080e007844ULL, 0x0003e20000000200ULL,
0x000000201f26723eULL, 0x000fe400000000ffULL, 0x0000001e1d27723eULL, 0x000fe400000000ffULL,
0x0000001610107c11ULL, 0x000fe4000f8e20ffULL, 0x0000001c1b1c723eULL, 0x000fe400000000ffULL,
0x0000001a191d723eULL, 0x000fe200000000ffULL, 0x0000002410007844ULL, 0x0003e20000000200ULL,
0x00000018171e723eULL, 0x000fc400000000ffULL, 0x000000160d1f723eULL, 0x000fe400000000ffULL,
0x0000001611117c11ULL, 0x000fca000f8e20ffULL, 0x0000001c11007844ULL, 0x0003e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002000117836ULL, 0x00efe20000000000ULL,
0x0000000000057919ULL, 0x000e620000002600ULL, 0x0000000103067824ULL, 0x000fe200078e0200ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000003ff027819ULL, 0x000fe20000011611ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000706077812ULL, 0x000fe200078ec0ffULL, 0x00000012ff127e24ULL, 0x000fe4000f8e00ffULL,
0x0000000111047824ULL, 0x000fe200078e0202ULL, 0x0ffffff807077812ULL, 0x000fc800078ef800ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000607087c11ULL, 0x000fe4000f8e20ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef811ULL, 0x0000000700077812ULL, 0x000fe400078ec0ffULL,
0x0000000604047c11ULL, 0x000fe2000f8e20ffULL, 0x0120000008087984ULL, 0x000ee20000000c00ULL,
0x0000000711007812ULL, 0x000fe200078ec0ffULL, 0x00000005040472a4ULL, 0x004fc4000f8e023fULL,
0x01200000040c7984ULL, 0x0005220000000c00ULL, 0x1ffffff807077812ULL, 0x000fe400078ef812ULL,
0x1ffffff800117812ULL, 0x000fe200078ef812ULL, 0x0000000805067824ULL, 0x042fe400078e00ffULL,
0x0000000805057824ULL, 0x000fc600078e00ffULL, 0xfffffff806037812ULL, 0x000fe400078ee203ULL,
0xfffffff805027812ULL, 0x000fe400078ee202ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000402057c10ULL, 0x000fe2000ff3e0ffULL, 0x0000860000047ab9ULL, 0x000fe40000000a00ULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x0000000403027c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x004fc4000f8248ffULL,
0x0000000503037c11ULL, 0x000fe400080f4c10ULL, 0x0000000505057c11ULL, 0x000fe200088f4c06ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d0eULL, 0x0000000c04007986ULL, 0x010fe2000c101d0eULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000001105147291ULL, 0x000fe2000f8e103fULL,
0x00000001ff027424ULL, 0x000fc600078e00ffULL, 0x000000061400728cULL, 0x000fc6000bf06070ULL,
0x01c60002ff0279a7ULL, 0x000e660008500004ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000001080c8899ULL, 0x000fe2000800063fULL, 0x00009000000a8ab9ULL, 0x000fc60000000800ULL,
0x0000000a0c0c82a4ULL, 0x000fc6000f8e0214ULL, 0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL,
0x000000040c0a88a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff047e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff057e24ULL, 0x000fca000f8e00ffULL, 0x0000000e04048981ULL, 0x000ea2000c1e1900ULL,
0x00000001050a7890ULL, 0x000fe2000fffe03fULL, 0xffffffff00187882ULL, 0x000fe20000000000ULL,
0x0000000611157899ULL, 0x000fe4000800063fULL, 0x000000070a00728cULL, 0x000fe4000bf26070ULL,
0x000000060d0a7899ULL, 0x000fe4000800063fULL, 0x0000000609097899ULL, 0x000fe2000800063fULL,
0x00000000040b82caULL, 0x004fc400000e0000ULL, 0x000000000000781cULL, 0x000fd60003f0f018ULL,
0x0000000b00188c82ULL, 0x000fe40008000000ULL, 0x0000000a180d72a4ULL, 0x000fe2000f8e023fULL,
0x0000000c00b48947ULL, 0x002ff60003800000ULL, 0x00000003ff1b7819ULL, 0x100fe20000011600ULL,
0x00000000000a7919ULL, 0x000e620000002600ULL, 0x00000015050b7291ULL, 0x000fe2000f8e403fULL,
0x0000007008087812ULL, 0x000fe200078ec0ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x000000041b1f7836ULL, 0x000fe20000000000ULL, 0x0000000b1300728cULL, 0x000fe2000bf01070ULL,
0x000000081b217836ULL, 0x000fe40000000000ULL, 0x000000011f047824ULL, 0x040fe200078e0200ULL,
0x0000000b130c7287ULL, 0x000fe2000c000000ULL, 0x000000081f057824ULL, 0x000fc400078e00ffULL,
0x0000000c1b257836ULL, 0x000fe20000000000ULL, 0x0000000c0b0c7290ULL, 0x000fe2000fffe13fULL,
0x0000000821077824ULL, 0x040fe200078e00ffULL, 0xfffffff805247812ULL, 0x000fe200078ee204ULL,
0x0000000121047824ULL, 0x100fe200078e0200ULL, 0x00000004110b7291ULL, 0x000fe2000f8e703fULL,
0x000000101b297836ULL, 0x000fe20000000000ULL, 0x0000000c1f007c0cULL, 0x000fe2000bf66070ULL,
0x000000181b2f7836ULL, 0x000fe20000000000ULL, 0xfffffff807287812ULL, 0x000fe200078ee204ULL,
0x0000000125057824ULL, 0x100fe200078e0200ULL, 0x0000000c21007c0cULL, 0x000fe2000bf86070ULL,
0x00000008252a7824ULL, 0x000fe200078e00ffULL, 0x000020000b0b7890ULL, 0x000fe2000fffe03fULL,
0x0000000129067824ULL, 0x000fc400078e0200ULL, 0x0000000829097824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL, 0x000000141b2b7836ULL, 0x000fe40000000000ULL,
0x000000012f127824ULL, 0x140fe200078e0200ULL, 0xfffffff8092c7812ULL, 0x000fe200078ee206ULL,
0x000000082f077824ULL, 0x000fe400078e00ffULL, 0x000000201b237836ULL, 0x000fe40000000000ULL,
0x000000281b177836ULL, 0x000fe20000000000ULL, 0xfffffff807127812ULL, 0x000fe200078ee212ULL,
0x000000012b147824ULL, 0x000fc400078e0200ULL, 0x000000082b057824ULL, 0x000fe400078e00ffULL,
0x0000001c1b317836ULL, 0x000fe40000000000ULL, 0x00000001230e7824ULL, 0x140fe200078e0200ULL,
0xfffffff805147812ULL, 0x000fe200078ee214ULL, 0x0000000823077824ULL, 0x000fe400078e00ffULL,
0x0000000117097824ULL, 0x040fe400078e0200ULL, 0x0000000817047824ULL, 0x000fe200078e00ffULL,
0xfffffff8070e7812ULL, 0x000fe200078ee20eULL, 0x000000301b0f7836ULL, 0x000fc40000000000ULL,
0x0000000131107824ULL, 0x140fe200078e0200ULL, 0xfffffff804097812ULL, 0x000fe200078ee209ULL,
0x0000000831057824ULL, 0x000fe400078e00ffULL, 0x000000241b157836ULL, 0x000fe40000000000ULL,
0x000000010f077824ULL, 0x140fe200078e0200ULL, 0xfffffff805107812ULL, 0x000fe200078ee210ULL,
0x000000080f047824ULL, 0x000fe400078e00ffULL, 0x00000001150c7824ULL, 0x000fc400078e0200ULL,
0x0000000815057824ULL, 0x000fe200078e00ffULL, 0xfffffff804077812ULL, 0x000fe200078ee207ULL,
0x0000002c1b137836ULL, 0x000fe40000000000ULL, 0x000000011b047824ULL, 0x100fe200078e0200ULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x000000400a0a7824ULL, 0x002fe400078e021bULL,
0x000000341b117836ULL, 0x000fe20000000000ULL, 0x0000000704197812ULL, 0x000fe200078ec0ffULL,
0x0000003c1b0d7836ULL, 0x000fe20000000000ULL, 0x0000000d0a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000113067824ULL, 0x040fe200078e0200ULL, 0x0ffffff8191e7812ULL, 0x000fe200078ef800ULL,
0x0000000813057824ULL, 0x000fc400078e00ffULL, 0x000000381b0b7836ULL, 0x000fe40000000000ULL,
0x0000000111047824ULL, 0x140fe200078e0200ULL, 0xfffffff805067812ULL, 0x000fe200078ee206ULL,
0x0000000811277824ULL, 0x000fe400078e00ffULL, 0x000000010d167824ULL, 0x040fe400078e0200ULL,
0x000000080d2d7824ULL, 0x000fe400078e00ffULL, 0x000000080a227836ULL, 0x000fc40000000000ULL,
0x000000040a1c7836ULL, 0x000fe40000000000ULL, 0x000000010b057824ULL, 0x040fe200078e0200ULL,
0xfffffff827007812ULL, 0x000fe200078ee204ULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x000000161a1d7c11ULL, 0x040fe2000f8048ffULL, 0x000000080b187824ULL, 0x000fe200078e00ffULL,
0xfffffff82d047812ULL, 0x000fe200078ee216ULL, 0x0000000c0a167836ULL, 0x000fe20000000000ULL,
0x0000000d22227c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100a207836ULL, 0x000fe20000000000ULL,
0x0000000d1c1c7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000140a267836ULL, 0x000fe20000000000ULL,
0x000000171a1a7c11ULL, 0x000fe200080f4c19ULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x0000000c1b007c0cULL, 0x000fe2000bf06070ULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x0000001622277c11ULL, 0x000fc4000f8a48ffULL, 0x0000000d16167c10ULL, 0x000fe4000ffde0ffULL,
0x000000161c1f7c11ULL, 0x000fe4000f8248ffULL, 0x0000001722227c11ULL, 0x000fe2000a8f4c19ULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0x000000171c1c7c11ULL, 0x000fe400088f4c1bULL,
0x0000001616217c11ULL, 0x000fe4000f8248ffULL, 0xfffffff818057812ULL, 0x000fc400078ee205ULL,
0x0000001716167c11ULL, 0x000fe400088f4c19ULL, 0x0000001d08187210ULL, 0x000fe40007f3e0ffULL,
0x0000000b1e1d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000180a1e7836ULL, 0x000fe20000000000ULL,
0x0000000d20207c10ULL, 0x000fe2000ffbe0ffULL, 0x000000ffff197224ULL, 0x000fe200008e061aULL,
0x0000000d26267c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000c25007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff1b7224ULL, 0x000fe200028e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181d7faeULL, 0x0003e2000c101c4eULL, 0x0000001f081a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x0000001620257c11ULL, 0x000fc4000f8c48ffULL,
0x00000016262d7c11ULL, 0x000fe4000f8248ffULL, 0x0000001720207c11ULL, 0x000fe2000b0f4c1bULL,
0x000000ffff1b7224ULL, 0x000fe200000e061cULL, 0x0000000d1e1e7c10ULL, 0x000fe4000ffde0ffULL,
0x0000001726267c11ULL, 0x000fe400088f4c1fULL, 0x0000000b241f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001c0a247836ULL, 0x000fe20000000000ULL, 0x0000000c2b007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff197224ULL, 0x002fe200030e06ffULL, 0x000000161e2b7c11ULL, 0x000fe2000f8248ffULL,
0x000000001a1f7faeULL, 0x0003e2000d901c4eULL, 0x0000000d24247c10ULL, 0x000fc4000ff7e0ffULL,
0x0000002708187210ULL, 0x000fe40007fde0ffULL, 0x000000171e1e7c11ULL, 0x000fe400088f4c19ULL,
0x00000021081c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0x0000000c29007c0cULL, 0x000fe2000bfa6070ULL, 0x000000ffff197224ULL, 0x000fe200030e0622ULL,
0x0000001624297c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e0616ULL,
0x0000000b281f7c11ULL, 0x002fe2000f8e20ffULL, 0x000000200a167836ULL, 0x000fe20000000000ULL,
0x0000001724247c11ULL, 0x000fc4000b0f4c21ULL, 0x0000000b2a217c11ULL, 0x000fe2000f8e20ffULL,
0x00000000181f7faeULL, 0x0003e2000e101c4eULL, 0x0000000d16227c10ULL, 0x000fe2000ff9e0ffULL,
0x000000240a167836ULL, 0x000fe20000000000ULL, 0x0000000c2f007c0cULL, 0x000fe2000bf66070ULL,
0x000000001c217faeULL, 0x0005e2000d101c4eULL, 0x00000025081a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x0000001622277c11ULL, 0x000fe4000f8848ffULL,
0x0000000c31007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff1b7224ULL, 0x000fe200010e0620ULL,
0x0000000d16207c10ULL, 0x000fe2000ffde0ffULL, 0x000000280a167836ULL, 0x000fe20000000000ULL,
0x0000000b2c1f7c11ULL, 0x002fc4000f8e20ffULL, 0x0000001722227c11ULL, 0x000fe2000a0f4c25ULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0x0000001620257c11ULL, 0x040fe2000f8848ffULL,
0x000000001a1f7faeULL, 0x0003e2000e901c4eULL, 0x0000002d08187210ULL, 0x000fe40007fde0ffULL,
0x0000000d16167c10ULL, 0x000fe4000ffbe0ffULL, 0x0000001720207c11ULL, 0x000fe2000a0f4c19ULL,
0x000000ffff197224ULL, 0x000fe200030e0626ULL, 0x0000002b081c7210ULL, 0x004fe20007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200028e06ffULL, 0x0000000c17007c0cULL, 0x000fc4000bfc6070ULL,
0x0000000c23007c0cULL, 0x000fe2000bf46070ULL, 0x000000ffff1d7224ULL, 0x000fe200020e061eULL,
0x0000000b14177c11ULL, 0x000fe2000f8e20ffULL, 0x0000002c0a147836ULL, 0x000fe20000000000ULL,
0x0000001616237c11ULL, 0x000fe4000f8a48ffULL, 0x0000000b121b7c11ULL, 0x002fe2000f8e20ffULL,
0x0000000018177faeULL, 0x0003e2000c101c4eULL, 0x00000017161e7c11ULL, 0x000fe2000a8f4c21ULL,
0x000000300a127836ULL, 0x000fe20000000000ULL, 0x0000000d141a7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000001c1b7faeULL, 0x0005e2000d901c4eULL, 0x0000002908147210ULL, 0x000fc40007f1e0ffULL,
0x0000000c15007c0cULL, 0x000fe2000bf86070ULL, 0x000000ffff1f7224ULL, 0x000fe200028e06ffULL,
0x000000161a217c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff157224ULL, 0x000fe200000e0624ULL,
0x0000000c13007c0cULL, 0x000fe4000bf06070ULL, 0x0000000d12137c10ULL, 0x000fe4000ffbe0ffULL,
0x0000000b10197c11ULL, 0x002fe2000f8e20ffULL, 0x000000340a107836ULL, 0x000fe20000000000ULL,
0x000000171a1a7c11ULL, 0x000fe200098f4c1fULL, 0x000000ffff187224ULL, 0x000fe200028e06ffULL,
0x00000016131f7c11ULL, 0x000fe2000f8648ffULL, 0x0000000014197faeULL, 0x0003e2000c901c4eULL,
0x0000000d10107c10ULL, 0x000fc4000ffbe0ffULL, 0x0000002708127210ULL, 0x000fe40007f3e0ffULL,
0x0000001713187c11ULL, 0x000fe200098f4c18ULL, 0x000000ffff1b7224ULL, 0x004fe200028e06ffULL,
0x0000002508167210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0622ULL,
0x00000016101d7c11ULL, 0x000fe4000f8248ffULL, 0x0000000c0f007c0cULL, 0x000fe2000bfa6070ULL,
0x000000ffff177224ULL, 0x000fe200018e0620ULL, 0x0000000b0e157c11ULL, 0x002fe2000f8e20ffULL,
0x000000380a0e7836ULL, 0x000fe20000000000ULL, 0x0000001710147c11ULL, 0x000fe200088f4c1bULL,
0x0000003c0a0a7836ULL, 0x000fe20000000000ULL, 0x0000000b0c197c11ULL, 0x000fe2000f8e20ffULL,
0x0000000012157faeULL, 0x0003e2000d101c4eULL, 0x0000000d0e0c7c10ULL, 0x000fc4000ff3e0ffULL,
0x00000023080e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000016197faeULL, 0x0005e2000e101c4eULL,
0x0000000c11007c0cULL, 0x000fe2000bf66070ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x000000160c1b7c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e061eULL,
0x0000000d0a0a7c10ULL, 0x000fe4000ff5e0ffULL, 0x000000170c0c7c11ULL, 0x000fe400088f4c11ULL,
0x0000001f08127210ULL, 0x002fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200010e06ffULL,
0x0000002108107210ULL, 0x000fc40007f9e0ffULL, 0x000000160a197c11ULL, 0x044fe2000f8448ffULL,
0x000000ffff137224ULL, 0x000fe200008e0618ULL, 0x0000000c0d007c0cULL, 0x000fe2000bf26070ULL,
0x000000ffff117224ULL, 0x000fe200020e061aULL, 0x0000000b090d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000170a097c11ULL, 0x000fe400090f4c15ULL, 0x0000000b06157c11ULL, 0x000fe2000f8e20ffULL,
0x000000000e0d7faeULL, 0x0003e2000f101c4eULL, 0x0000000b07177c11ULL, 0x000fc4000f8e20ffULL,
0x0000000c0b007c0cULL, 0x000fe2000bf86070ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000001d08067210ULL, 0x000fe40007f1e0ffULL, 0x0000001b080a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000012177faeULL, 0x0003e2000e901c4eULL, 0x0000001908087210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0614ULL, 0x0000000b00197c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060cULL, 0x0000000b05057c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x0000000b041b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000006197faeULL, 0x0003e8000d901c4eULL, 0x000000000a057faeULL, 0x0003e8000e101c4eULL,
0x00000000081b7faeULL, 0x0003e2000c901c4eULL, 0x0000000c00587947ULL, 0x000fea0003800000ULL,
0x00000010002b7811ULL, 0x040fe200078fe8ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000800277811ULL, 0x040fe200078fe8ffULL, 0x00000004110b7291ULL, 0x000fe2000f8e703fULL,
0x0000002000137811ULL, 0x040fe200078fe8ffULL, 0x000000012b0f7824ULL, 0x140fe200078e0200ULL,
0x0000000c00297811ULL, 0x040fe200078fe8ffULL, 0x000000082b067824ULL, 0x000fe200078e00ffULL,
0x0000001800317811ULL, 0x040fe200078fe8ffULL, 0x0000000127117824ULL, 0x140fe200078e0200ULL,
0x0000002800177811ULL, 0x040fe200078fe8ffULL, 0x0000000827047824ULL, 0x000fe200078e00ffULL,
0xfffffff8060f7812ULL, 0x000fe200078ee20fULL, 0x0000000113097824ULL, 0x140fe200078e0200ULL,
0x0000000400257811ULL, 0x040fe200078fe8ffULL, 0x0000000813067824ULL, 0x000fe200078e00ffULL,
0xfffffff804117812ULL, 0x000fe200078ee211ULL, 0x0000000129107824ULL, 0x140fe200078e0200ULL,
0x0000001c00337811ULL, 0x040fe200078fe8ffULL, 0x0000000829077824ULL, 0x000fe200078e00ffULL,
0xfffffff806097812ULL, 0x000fe200078ee209ULL, 0x00000001310d7824ULL, 0x140fe200078e0200ULL,
0x00000030001b7811ULL, 0x040fe200078fe8ffULL, 0x0000000831047824ULL, 0x000fe200078e00ffULL,
0xfffffff807107812ULL, 0x000fe200078ee210ULL, 0x0000000117067824ULL, 0x140fe200078e0200ULL,
0x00000014002d7811ULL, 0x040fe200078fe8ffULL, 0x00000008170b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8040d7812ULL, 0x000fe200078ee20dULL, 0x0000000125147824ULL, 0x140fe200078e0200ULL,
0x0000002400157811ULL, 0x040fe200078fe8ffULL, 0x0000000825057824ULL, 0x000fe200078e00ffULL,
0xfffffff80b067812ULL, 0x000fe200078ee206ULL, 0x00000001330a7824ULL, 0x140fe200078e0200ULL,
0x00000009003c7c11ULL, 0x040fe2000f8fe8ffULL, 0x0000000833077824ULL, 0x000fe200078e00ffULL,
0x00000000000b7211ULL, 0x040fe200078fe8ffULL, 0x000000011b047824ULL, 0x140fe200078e0200ULL,
0xfffffff805147812ULL, 0x000fe200078ee214ULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8070a7812ULL, 0x000fe200078ee20aULL, 0x000000012d0e7824ULL, 0x100fe200078e0200ULL,
0x000000070b237812ULL, 0x000fe200078ec0ffULL, 0x000000082d057824ULL, 0x000fe200078e00ffULL,
0xfffffff81d047812ULL, 0x000fe200078ee204ULL, 0x0000000115077824ULL, 0x140fe200078e0200ULL,
0x0000000d3c3c7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000008150c7824ULL, 0x000fe200078e00ffULL,
0x0000002c00197811ULL, 0x040fe200078fe8ffULL, 0x00000009253b7c36ULL, 0x000fe20008000000ULL,
0x00000034001d7811ULL, 0x040fe200078fe8ffULL, 0x0000000927397c36ULL, 0x000fe20008000000ULL,
0x00000038001f7811ULL, 0x040fe200078fe8ffULL, 0x0000000819127824ULL, 0x040fe200078e00ffULL,
0x0000003c00217811ULL, 0x000fe200078fe8ffULL, 0x000000092b367c36ULL, 0x000fe20008000000ULL,
0x0ffffff8233e7812ULL, 0x000fe200078ef800ULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0xfffffff8050e7812ULL, 0x000fe200078ee20eULL, 0x0000000119057824ULL, 0x100fe200078e0200ULL,
0xfffffff80c077812ULL, 0x000fe200078ee207ULL, 0x000000011d0c7824ULL, 0x100fe200078e0200ULL,
0x000000163c2f7c11ULL, 0x040fe2000f8048ffULL, 0x000000011f0b7824ULL, 0x100fe200078e0200ULL,
0x0000000d39397c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000121007824ULL, 0x040fe200078e0200ULL,
0x000000173c3c7c11ULL, 0x000fe200080f4c23ULL, 0x0000000821377824ULL, 0x000fe200078e00ffULL,
0x0000000d3b3b7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000092d2d7c36ULL, 0x000fe20008000000ULL,
0xfffffff812057812ULL, 0x000fe200078ee205ULL, 0x000000081f127824ULL, 0x000fe200078e00ffULL,
0xfffffff837007812ULL, 0x000fe200078ee200ULL, 0x0000000929377c36ULL, 0x000fe20008000000ULL,
0x0000000d36367c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x000000163b3a7c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x0000000d37377c10ULL, 0x000fe2000ff5e0ffULL, 0x00000009312b7c36ULL, 0x000fe20008000000ULL,
0x0000001639387c11ULL, 0x000fe2000f8248ffULL, 0x0000000933297c36ULL, 0x000fe20008000000ULL,
0x000000173b3b7c11ULL, 0x000fe200080f4c18ULL, 0x000000ffff237224ULL, 0x000fe200018e06ffULL,
0xfffffff8120b7812ULL, 0x000fe200078ee20bULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000000d2d2d7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000913137c36ULL, 0x000fe20008000000ULL,
0x0000001739397c11ULL, 0x000fe200088f4c16ULL, 0x0000000915157c36ULL, 0x000fe20008000000ULL,
0x00000016371c7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x0000000d2b2b7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000081d357824ULL, 0x000fe200078e00ffULL,
0x00000016361e7c11ULL, 0x040fe2000f8648ffULL, 0x0000000917177c36ULL, 0x000fe20008000000ULL,
0x0000001737377c11ULL, 0x000fe200090f4c12ULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x000000162d207c11ULL, 0x000fe2000f8048ffULL, 0x0000000919197c36ULL, 0x000fe20008000000ULL,
0x0000000d29297c10ULL, 0x000fe2000ff5e0ffULL, 0x000000091b1b7c36ULL, 0x000fe20008000000ULL,
0x000000162b227c11ULL, 0x000fe2000f8248ffULL, 0x000000091d1d7c36ULL, 0x000fe20008000000ULL,
0x0000001736367c11ULL, 0x000fe200098f4c23ULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x000000172d2d7c11ULL, 0x000fe200080f4c1aULL, 0x000000091f1f7c36ULL, 0x000fe20008000000ULL,
0x0000000d13137c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000921217c36ULL, 0x000fe20008000000ULL,
0x0000000d15157c10ULL, 0x000fe2000ff1e0ffULL, 0x000020000b0b7890ULL, 0x000fe2000fffe03fULL,
0xfffffff8350c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x000000172b2b7c11ULL, 0x000fe200088f4c18ULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x0000001629237c11ULL, 0x000fc4000f8448ffULL, 0x0000000d17357c10ULL, 0x000fe4000ff3e0ffULL,
0x0000001613247c11ULL, 0x000fe4000f8648ffULL, 0x0000001729297c11ULL, 0x000fe200090f4c16ULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x0000001615267c11ULL, 0x000fe4000f8048ffULL,
0x0000001635177c11ULL, 0x000fe4000f8248ffULL, 0x0000001713257c11ULL, 0x000fc400098f4c12ULL,
0x0000000d19197c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001715277c11ULL, 0x000fe400080f4c18ULL,
0x0000000d1b1b7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x0000000d1d1d7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001735357c11ULL, 0x000fe200088f4c16ULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x0000000d1f1f7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x0000001619287c11ULL, 0x000fc4000f8448ffULL,
0x000000161b2a7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x000000161d2c7c11ULL, 0x000fe4000f8048ffULL, 0x00000070083d7812ULL, 0x000fe400078ec0ffULL,
0x000000161f2e7c11ULL, 0x000fe4000f8248ffULL, 0x0000001719347c11ULL, 0x000fe400090f4c34ULL,
0x000000171b337c11ULL, 0x000fc400098f4c12ULL, 0x0000000d21217c10ULL, 0x000fe4000ff5e0ffULL,
0x000000171d327c11ULL, 0x000fe400080f4c32ULL, 0x0000002f3d127210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200010e06ffULL, 0x000000171f2f7c11ULL, 0x000fe400088f4c16ULL,
0x0000003a3d187210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e063cULL,
0x0000001621307c11ULL, 0x000fc4000f8448ffULL, 0x0000001e3d1e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200008e063bULL, 0x000000233d167210ULL, 0x000fe40007f3e0ffULL,
0x0000001721317c11ULL, 0x000fe200090f4c08ULL, 0x000000ffff1f7224ULL, 0x000fe200028e0636ULL,
0x000000383d1a7210ULL, 0x000fe40007f5e0ffULL, 0x000000223d227210ULL, 0x000fe40007f1e0ffULL,
0x0000001c3d1c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e0639ULL,
0x000000203d207210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff237224ULL, 0x000fe200000e062bULL,
0x000000173d087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0629ULL,
0x0000000b3e157c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e0637ULL,
0x0000000b14297c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff217224ULL, 0x000fe200020e062dULL,
0x0000000b11117c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000b901c4eULL, 0x000000243d247210ULL, 0x000fc40007f5e0ffULL,
0x0000000b102b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000018297faeULL, 0x0005e2000b901c4eULL,
0x000000263d267210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fe200010e0625ULL,
0x0000000b0f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a117faeULL, 0x000fe2000b901c4eULL,
0x0000000b0e2d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff277224ULL, 0x000fe200018e0627ULL,
0x000000283d287210ULL, 0x000fe20007f9e0ffULL, 0x000000001c2b7faeULL, 0x0007e2000b901c4eULL,
0x0000000b0d0d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000002a3d2a7210ULL, 0x000fe20007f1e0ffULL,
0x000000001e0f7faeULL, 0x0009e2000b901c4eULL, 0x0000000b0a137c11ULL, 0x002fe2000f8e20ffULL,
0x000000ffff297224ULL, 0x004fe200020e0634ULL, 0x0000002c3d2c7210ULL, 0x000fe20007f3e0ffULL,
0x00000000202d7faeULL, 0x0003e2000b901c4eULL, 0x0000000b09157c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff097224ULL, 0x000fe200028e0635ULL, 0x0000002e3d2e7210ULL, 0x000fe20007f5e0ffULL,
0x00000000220d7faeULL, 0x0005e2000b901c4eULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2b7224ULL, 0x008fe200000e0633ULL, 0x000000303d307210ULL, 0x000fe20007f7e0ffULL,
0x0000000016137faeULL, 0x000fe2000b901c4eULL, 0x0000000b06117c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e062fULL, 0x0000000b05057c11ULL, 0x000fe2000f8e20ffULL,
0x0000000024157faeULL, 0x000fe2000b901c4eULL, 0x0000000b040f7c11ULL, 0x010fe2000f8e20ffULL,
0x000000ffff2d7224ULL, 0x002fe200008e0632ULL, 0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000026077faeULL, 0x0003e2000b901c4eULL, 0x0000000b0c0d7c11ULL, 0x004fe2000f8e20ffULL,
0x000000ffff317224ULL, 0x000fc400018e0631ULL, 0x0000000008117faeULL, 0x0007e8000b901c4eULL,
0x0000000028057faeULL, 0x0007e2000b901c4eULL, 0x0000000b00077c11ULL, 0x002fc6000f8e20ffULL,
0x000000002a0f7faeULL, 0x0007e8000b901c4eULL, 0x000000002c0d7faeULL, 0x0007e8000b901c4eULL,
0x000000002e0b7faeULL, 0x0007e8000b901c4eULL, 0x0000000030077faeULL, 0x0007e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000047805ULL, 0x00afe20000015200ULL,
0x01c60003ff0075a7ULL, 0x000ea40008000144ULL, 0x00000000005c0947ULL, 0x00efea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01c60003ff0075a7ULL, 0x000e640008000144ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000070500728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00009000000b7ab9ULL, 0x000fe40000000800ULL, 0x0000000b080b72a4ULL, 0x000fd8000f8e023fULL,
0x0000001505127291ULL, 0x000fc8000f8e403fULL, 0x000000121300728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x002fea0003800000ULL,
0x0000000105087890ULL, 0x000fe2000fffe03fULL, 0x0000000000487919ULL, 0x000e620000000000ULL,
0x000000180a1972a4ULL, 0x000fe4000f8e023fULL, 0x000000070800728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000c00688947ULL, 0x000fea0003800000ULL,
0x00000003ff187819ULL, 0x102fe20000011648ULL, 0x80000012130c7290ULL, 0x000fe2000fffe03fULL,
0x0ffffff848677812ULL, 0x000fe200078ec0ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000411087291ULL, 0x000fe2000f8e703fULL, 0x0000000418007836ULL, 0x000fe40000000000ULL,
0x0000000918047c36ULL, 0x000fe20008000000ULL, 0x00004000080d7890ULL, 0x000fe2000fffe03fULL,
0x0000000100027824ULL, 0x040fe200078e0248ULL, 0x0000000c00007c0cULL, 0x040fe2000bf86070ULL,
0x00000008001f7824ULL, 0x000fe200078e00ffULL, 0x0000001904047c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000818037836ULL, 0x000fc40000000000ULL, 0x0000000c180f7836ULL, 0x000fe20000000000ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee202ULL, 0x0000000900027c36ULL, 0x000fe20008000000ULL,
0x0000000c03007c0cULL, 0x000fe2000bfa6070ULL, 0x0000000903007c36ULL, 0x000fe20008000000ULL,
0x0000000d1f1f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000103067824ULL, 0x040fe200078e0248ULL,
0x0000001902027c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000803217824ULL, 0x000fe200078e00ffULL,
0x0000001900007c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x0000001604167c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff037224ULL, 0x000fe200010e06ffULL,
0x0000001602107c11ULL, 0x000fe2000f8448ffULL, 0x0000001418227836ULL, 0x000fe20000000000ULL,
0x0000001704177c11ULL, 0x000fe200088f4c05ULL, 0x000000090f047c36ULL, 0x000fe20008000000ULL,
0x0000001702117c11ULL, 0x000fe200090f4c03ULL, 0x000000ffff037224ULL, 0x000fe200018e06ffULL,
0x0000001600147c11ULL, 0x040fe2000f8248ffULL, 0x00000010181b7836ULL, 0x000fe20000000000ULL,
0x0000001904047c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001818247836ULL, 0x000fe20000000000ULL,
0x0000001700157c11ULL, 0x000fe200088f4c03ULL, 0x0000000922007c36ULL, 0x000fe20008000000ULL,
0xfffffff821217812ULL, 0x000fe200078ee206ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x0000001604127c11ULL, 0x040fe2000f8448ffULL, 0x000000091b027c36ULL, 0x000fe20008000000ULL,
0x0000001900007c10ULL, 0x000fe2000ff3e0ffULL, 0x0000002018267836ULL, 0x000fe20000000000ULL,
0x0000001704137c11ULL, 0x000fe200090f4c07ULL, 0x0000000924047c36ULL, 0x000fe20008000000ULL,
0x0000001902027c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e06ffULL,
0x0000001600087c11ULL, 0x040fe2000f8248ffULL, 0x0000002418277836ULL, 0x000fe20000000000ULL,
0x0000000d21217c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x0000001700097c11ULL, 0x000fe200088f4c03ULL, 0x0000001c18257836ULL, 0x000fe20000000000ULL,
0x0000001904037c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000926007c36ULL, 0x000fe20008000000ULL,
0x00000016020c7c11ULL, 0x000fe2000f8648ffULL, 0x0000000925077c36ULL, 0x000fc40008000000ULL,
0x000000ffff047224ULL, 0x000fe200008e06ffULL, 0x00000017020d7c11ULL, 0x000fe200098f4c05ULL,
0x0000000927027c36ULL, 0x000fe20008000000ULL, 0x00000016030a7c11ULL, 0x000fe2000f8248ffULL,
0x0000002818287836ULL, 0x000fe20000000000ULL, 0x0000001900057c10ULL, 0x000fe2000ff7e0ffULL,
0x000000010f1e7824ULL, 0x000fe200078e0248ULL, 0x00000017030b7c11ULL, 0x000fe200088f4c04ULL,
0x000000080f237824ULL, 0x000fe200078e00ffULL, 0x0000001902007c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x0000001907077c10ULL, 0x000fe2000ff5e0ffULL,
0x000000011b207824ULL, 0x000fe200078e0248ULL, 0x0000001605047c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x0000001600027c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x0000001607067c11ULL, 0x000fe2000f8448ffULL,
0x000000081b2b7824ULL, 0x000fe200078e00ffULL, 0x0000001705057c11ULL, 0x000fe200098f4c0eULL,
0x00000001180e7824ULL, 0x000fe200078e0248ULL, 0x0000001700037c11ULL, 0x000fe200088f4c03ULL,
0x0000002c18297836ULL, 0x000fe20000000000ULL, 0x0000001707077c11ULL, 0x000fe200090f4c1aULL,
0x00000034182a7836ULL, 0x000fe20000000000ULL, 0x0000000748007812ULL, 0x000fc400078ec0ffULL,
0x0000000c18007c0cULL, 0x000fe4000bf46070ULL, 0x00000007671d7812ULL, 0x000fe200078ef80eULL,
0x00000009280e7c36ULL, 0x000fe20008000000ULL, 0x0000000800197812ULL, 0x000fe400078efcffULL,
0x0000000c0f007c0cULL, 0x000fe4000bf66070ULL, 0x0000000c1b007c0cULL, 0x000fe2000bf26070ULL,
0x00000010191a7825ULL, 0x000fe200078e0016ULL, 0x000000190e0f7c10ULL, 0x000fc4000ffde0ffULL,
0x0000000d1d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000929167c36ULL, 0x000fe20008000000ULL,
0xfffffff8231e7812ULL, 0x000fe200078ee21eULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x000000160f0e7c11ULL, 0x040fe2000f8c48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a1d7faeULL, 0x0003e2000d101c4eULL, 0x0000000c22007c0cULL, 0x040fe2000bf46070ULL,
0x0000000122237824ULL, 0x040fe200078e0248ULL, 0x000000170f0f7c11ULL, 0x000fe2000b0f4c1cULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x0000001916177c10ULL, 0x000fe2000ffde0ffULL,
0x0000001019107825ULL, 0x000fe200078e0010ULL, 0xfffffff82b207812ULL, 0x000fc400078ee220ULL,
0xfffffff822237812ULL, 0x000fe200078ee223ULL, 0x0000003018227836ULL, 0x000fe20000000000ULL,
0x00000000101f7faeULL, 0x0005e2000e101c4eULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0000001617167c11ULL, 0x000fe2000f8c48ffULL, 0x0000001019147825ULL, 0x000fe200078e0014ULL,
0x0000000d1e1b7c11ULL, 0x002fe4000f8e20ffULL, 0x0000001717177c11ULL, 0x000fe2000b0f4c1cULL,
0x00000009221a7c36ULL, 0x000fe20008000000ULL, 0x0000000014217faeULL, 0x0003e2000e901c4eULL,
0x0000000c24007c0cULL, 0x040fe2000bfa6070ULL, 0x00000001241c7824ULL, 0x140fe200078e0248ULL,
0x0000000c25007c0cULL, 0x040fe2000bf86070ULL, 0x00000008242b7824ULL, 0x000fe200078e00ffULL,
0x000000191a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x00000001251d7824ULL, 0x000fe200078e0248ULL,
0x0000000d231f7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000825247824ULL, 0x000fe200078e00ffULL,
0xfffffff82b1c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x000000161a107c11ULL, 0x000fe2000f8c48ffULL, 0x0000001019147825ULL, 0x002fe200078e0012ULL,
0xfffffff8241e7812ULL, 0x000fc400078ee21dULL, 0x0000000d201d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000092a127c36ULL, 0x000fe20008000000ULL, 0x000000171a117c11ULL, 0x000fe2000b0f4c11ULL,
0x0000003818207836ULL, 0x000fe20000000000ULL, 0x00000000141b7faeULL, 0x0003e2000d901c4eULL,
0x00000010190c7825ULL, 0x040fe200078e000cULL, 0x0000001912137c10ULL, 0x000fe4000ffde0ffULL,
0x0000000c26007c0cULL, 0x000fe2000bf66070ULL, 0x0000001019087825ULL, 0x000fe200078e0008ULL,
0x000000000c1d7faeULL, 0x0005e2000c901c4eULL, 0x0000000c28007c0cULL, 0x000fc4000bf26070ULL,
0x000000ffff1a7224ULL, 0x000fe200030e06ffULL, 0x00000000081f7faeULL, 0x0007e2000d101c4eULL,
0x0000001613127c11ULL, 0x040fe2000f8c48ffULL, 0x0000000920147c36ULL, 0x002fe20008000000ULL,
0x0000000d1c157c11ULL, 0x000fe2000f8e20ffULL, 0x0000003c18237836ULL, 0x000fe20000000000ULL,
0x0000001713137c11ULL, 0x000fe2000b0f4c1aULL, 0x0000000126217824ULL, 0x140fe200078e0248ULL,
0x0000001914147c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000826267824ULL, 0x000fe200078e00ffULL,
0x0000000c27007c0cULL, 0x040fe2000bfc6070ULL, 0x00000001271a7824ULL, 0x000fc400078e0248ULL,
0x000000ffff0d7224ULL, 0x004fe200010e06ffULL, 0x0000001614087c11ULL, 0x048fe2000f8448ffULL,
0x00000010190a7825ULL, 0x000fe200078e000aULL, 0xfffffff826217812ULL, 0x000fe400078ee221ULL,
0x0000001714097c11ULL, 0x000fe200090f4c0dULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x000000000a157faeULL, 0x0003e2000e901c4eULL, 0x00000001281b7824ULL, 0x040fe200078e0248ULL,
0x0000000d211d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000009230c7c36ULL, 0x000fe20008000000ULL,
0xfffffff8271a7812ULL, 0x000fe200078ee21aULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000000c29007c0cULL, 0x000fe2000bf46070ULL, 0x0000001019067825ULL, 0x000fe200078e0006ULL,
0x000000190c0d7c10ULL, 0x000fc4000ffbe0ffULL, 0xfffffff828187812ULL, 0x000fe200078ee21bULL,
0x0000001019047825ULL, 0x040fe200078e0004ULL, 0x0000000d1e1b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000d1a1f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001019027825ULL, 0x000fe400078e0002ULL,
0x00000000061b7faeULL, 0x0005e2000e101c4eULL, 0x0000000c2a007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff147224ULL, 0x000fe200028e06ffULL, 0x000000160d0c7c11ULL, 0x000fe2000f8a48ffULL,
0x00000001291c7824ULL, 0x040fe200078e0248ULL, 0x00000000041d7faeULL, 0x000fe2000d901c4eULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x000000170d0d7c11ULL, 0x000fe2000a8f4c14ULL,
0x00000001220a7824ULL, 0x142fe200078e0248ULL, 0x00000000021f7faeULL, 0x0003e2000f101c4eULL,
0x0000000822157824ULL, 0x000fe200078e00ffULL, 0x0000000c23007c0cULL, 0x000fe2000bfc6070ULL,
0x000000012a0b7824ULL, 0x100fe200078e0248ULL, 0x0000000c22007c0cULL, 0x000fe2000bf66070ULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000c20007c0cULL, 0x040fe2000bfa6070ULL,
0x0000000120147824ULL, 0x040fe200078e0248ULL, 0xfffffff8291c7812ULL, 0x000fe200078ee21cULL,
0x0000000820077824ULL, 0x004fe200078e00ffULL, 0xfffffff8150a7812ULL, 0x000fe200078ee20aULL,
0x00000010190e7825ULL, 0x000fe200078e000eULL, 0xfffffff82a067812ULL, 0x000fc400078ee20bULL,
0xfffffff807147812ULL, 0x000fe200078ee214ULL, 0x0000000123027824ULL, 0x042fe200078e0248ULL,
0x0000000d18077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x0000000d0a0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001019167825ULL, 0x040fe200078e0016ULL,
0x0000000d14157c11ULL, 0x000fe2000f8e20ffULL, 0x000000000e077faeULL, 0x0003e2000c901c4eULL,
0xfffffff8231a7812ULL, 0x000fe200078ee202ULL, 0x0000001019027825ULL, 0x000fe200078e0008ULL,
0x0000000d1c097c11ULL, 0x000fc6000f8e20ffULL, 0x0000001019107825ULL, 0x040fe400078e0010ULL,
0x0000000016097faeULL, 0x0003e4000d101c4eULL, 0x0000001019047825ULL, 0x040fe200078e000cULL,
0x0000000d060d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000100b7faeULL, 0x0003e4000d901c4eULL,
0x0000001019127825ULL, 0x000fe200078e0012ULL, 0x0000000d1a197c11ULL, 0x000fc8000f8e20ffULL,
0x00000000120d7faeULL, 0x0003e8000e101c4eULL, 0x0000000002157faeULL, 0x0003e8000e901c4eULL,
0x0000000004197faeULL, 0x0003e2000f101c4eULL, 0x0000000c001c7947ULL, 0x000fea0003800000ULL,
0x0000000848047811ULL, 0x042fe200078fe8ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000448027811ULL, 0x040fe200078fe8ffULL, 0x0000000411087291ULL, 0x000fe2000f8e703fULL,
0x0000001848187811ULL, 0x000fe200078fe8ffULL, 0x0000000104237824ULL, 0x100fe200078e0248ULL,
0x0000000c48057811ULL, 0x000fe200078fe8ffULL, 0x0000000804007824ULL, 0x000fe200078e00ffULL,
0x0000002848277811ULL, 0x000fe200078fe8ffULL, 0x0000000102247824ULL, 0x100fe200078e0248ULL,
0x0000001448167811ULL, 0x000fe200078fe8ffULL, 0x0000000802037824ULL, 0x000fe200078e00ffULL,
0xfffffff800237812ULL, 0x000fe200078ee223ULL, 0x00000001181f7824ULL, 0x100fe200078e0248ULL,
0x0000001c48197811ULL, 0x000fe200078fe8ffULL, 0x0000000818007824ULL, 0x000fe200078e00ffULL,
0xfffffff803247812ULL, 0x000fe200078ee224ULL, 0x0000000105227824ULL, 0x140fe200078e0248ULL,
0x0000001048067811ULL, 0x040fe200078fe8ffULL, 0x0000000805037824ULL, 0x000fe200078e00ffULL,
0xfffffff8001f7812ULL, 0x000fe200078ee21fULL, 0x0000000127157824ULL, 0x140fe200078e0248ULL,
0x0000002448267811ULL, 0x000fe200078fe8ffULL, 0x0000000827007824ULL, 0x000fe200078e00ffULL,
0xfffffff803227812ULL, 0x000fe200078ee222ULL, 0x0000000116207824ULL, 0x100fe200078e0248ULL,
0x0000002c48287811ULL, 0x000fe200078fe8ffULL, 0x0000000816077824ULL, 0x000fe200078e00ffULL,
0xfffffff800157812ULL, 0x000fe200078ee215ULL, 0x00000001191e7824ULL, 0x140fe200078e0248ULL,
0x0000000948007c11ULL, 0x000fe2000f8fe8ffULL, 0x0000000819037824ULL, 0x000fe200078e00ffULL,
0xfffffff807207812ULL, 0x000fe200078ee220ULL, 0x0000000106217824ULL, 0x100fe200078e0248ULL,
0x00000020481d7811ULL, 0x000fe200078fe8ffULL, 0x0000000806087824ULL, 0x000fe200078e00ffULL,
0xfffffff8031e7812ULL, 0x000fe200078ee21eULL, 0x00000001261a7824ULL, 0x100fe200078e0248ULL,
0x00000034482d7811ULL, 0x000fe200078fe8ffULL, 0x0000000826077824ULL, 0x000fe200078e00ffULL,
0x0000001900007c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000128147824ULL, 0x140fe200078e0248ULL,
0xfffffff808217812ULL, 0x000fe200078ee221ULL, 0x0000000828037824ULL, 0x000fe200078e00ffULL,
0xfffffff8071a7812ULL, 0x000fe200078ee21aULL, 0x000000011d1b7824ULL, 0x140fe200078e0248ULL,
0x00000030482b7811ULL, 0x040fe200078fe8ffULL, 0x000000081d087824ULL, 0x000fe200078e00ffULL,
0xfffffff803147812ULL, 0x000fe200078ee214ULL, 0x000000012d127824ULL, 0x140fe200078e0248ULL,
0x0000003c48307811ULL, 0x000fe200078fe8ffULL, 0x000000082d077824ULL, 0x000fe200078e00ffULL,
0xfffffff8081b7812ULL, 0x000fe200078ee21bULL, 0x000000ffff037224ULL, 0x000fe200008e06ffULL,
0x00000016000e7c11ULL, 0x040fe2000f8248ffULL, 0x0000000902027c36ULL, 0x000fe20008000000ULL,
0xfffffff807127812ULL, 0x000fe200078ee212ULL, 0x000000012b137824ULL, 0x140fe200078e0248ULL,
0x00000017000f7c11ULL, 0x000fe200088f4c03ULL, 0x000000082b087824ULL, 0x000fe200078e00ffULL,
0x00000038482e7811ULL, 0x000fe200078fe8ffULL, 0x0000000130107824ULL, 0x140fe200078e0248ULL,
0x0000001902007c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000830077824ULL, 0x000fe200078e00ffULL,
0xfffffff808137812ULL, 0x000fe200078ee213ULL, 0x0000000905057c36ULL, 0x000fe20008000000ULL,
0x0ffffff848677812ULL, 0x000fe200078ec0ffULL, 0x0000000904047c36ULL, 0x000fe20008000000ULL,
0xfffffff807107812ULL, 0x000fe200078ee210ULL, 0x000000012e117824ULL, 0x040fe200078e0248ULL,
0x0000001905027c10ULL, 0x000fe2000ff7e0ffULL, 0x000000082e087824ULL, 0x000fe200078e00ffULL,
0x0000001904047c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00000016000c7c11ULL, 0x040fe2000f8248ffULL, 0x0000000906067c36ULL, 0x000fe20008000000ULL,
0xfffffff808117812ULL, 0x000fe200078ee211ULL, 0x000000ffff037224ULL, 0x000fe200018e06ffULL,
0x00000017000d7c11ULL, 0x000fe200088f4c07ULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x0000001602087c11ULL, 0x000fe2000f8648ffULL, 0x0000000916177c36ULL, 0x000fe20008000000ULL,
0x0000001906007c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000919197c36ULL, 0x000fe20008000000ULL,
0x00000016040a7c11ULL, 0x000fe2000f8448ffULL, 0x000000091d257c36ULL, 0x000fe20008000000ULL,
0x0000001702097c11ULL, 0x000fe200098f4c03ULL, 0x000000ffff037224ULL, 0x000fe200008e06ffULL,
0x00000017040b7c11ULL, 0x000fe200090f4c05ULL, 0x0000000918057c36ULL, 0x000fe20008000000ULL,
0x0000001600067c11ULL, 0x040fe2000f8248ffULL, 0x00000009261d7c36ULL, 0x000fe20008000000ULL,
0x0000001917177c10ULL, 0x000fe2000ff5e0ffULL, 0x000000092b2b7c36ULL, 0x000fe20008000000ULL,
0x0000001700077c11ULL, 0x000fe200088f4c03ULL, 0x000000092d2d7c36ULL, 0x000fe20008000000ULL,
0x0000001905057c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x0000001919007c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000927197c36ULL, 0x000fe20008000000ULL,
0x0000001617167c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x0000001600027c11ULL, 0x040fe2000f8648ffULL, 0x000000ffff037224ULL, 0x000fe200020e06ffULL,
0x0000001717177c11ULL, 0x000fe200088f4c1cULL, 0x000000092e2f7c36ULL, 0x000fe20008000000ULL,
0x0000001925257c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000930317c36ULL, 0x000fe20008000000ULL,
0x0000001700037c11ULL, 0x000fe200098f4c03ULL, 0x0000000928007c36ULL, 0x000fe20008000000ULL,
0x0000001605047c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff2c7224ULL, 0x000fe200008e06ffULL,
0x0000001919197c10ULL, 0x000fe2000ff7e0ffULL, 0x00004000080d7890ULL, 0x000fe2000fffe03fULL,
0x0000001705057c11ULL, 0x000fc400090f4c18ULL, 0x000000191d1d7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x0000001625267c11ULL, 0x000fe4000f8248ffULL,
0x0000001900007c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x0000001619187c11ULL, 0x000fe4000f8648ffULL, 0x0000001725277c11ULL, 0x000fe200088f4c2cULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x0000001719197c11ULL, 0x000fc400098f4c28ULL,
0x000000161d1c7c11ULL, 0x040fe4000f8448ffULL, 0x0000001600287c11ULL, 0x040fe4000f8248ffULL,
0x000000171d1d7c11ULL, 0x000fe400090f4c2aULL, 0x0000001700297c11ULL, 0x000fe400088f4c25ULL,
0x0000000748007812ULL, 0x000fe400078ec0ffULL, 0x000000192b2b7c10ULL, 0x000fc4000ff5e0ffULL,
0x00000048482a7211ULL, 0x000fe400078fe8ffULL, 0x000000192d2d7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x000000192f2f7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001931317c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x0000000800337812ULL, 0x000fe200078efcffULL, 0x000000ffff347224ULL, 0x000fe200020e06ffULL,
0x0000000767257812ULL, 0x000fe200078ef82aULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x000000162b2a7c11ULL, 0x000fe2000f8448ffULL, 0x00000010330e7825ULL, 0x000fe200078e000eULL,
0x000000162d2c7c11ULL, 0x000fc4000f8648ffULL, 0x000000162f2e7c11ULL, 0x000fe2000f8848ffULL,
0x00000010330c7825ULL, 0x000fe200078e000cULL, 0x0000000d25257c11ULL, 0x000fe4000f8e20ffULL,
0x0000001631307c11ULL, 0x000fe2000f8248ffULL, 0x00000010330a7825ULL, 0x000fe200078e000aULL,
0x000000172b2b7c11ULL, 0x000fe200090f4c38ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e257faeULL, 0x0003e2000b901c4eULL, 0x000000172d2d7c11ULL, 0x000fe200098f4c36ULL,
0x0000001033087825ULL, 0x000fe200078e0008ULL, 0x000000172f2f7c11ULL, 0x000fc4000a0f4c34ULL,
0x0000001731317c11ULL, 0x000fe200088f4c32ULL, 0x0000001033067825ULL, 0x000fe200078e0006ULL,
0x0000000d23237c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d21217c11ULL, 0x000fe2000f8e20ffULL,
0x0000001033167825ULL, 0x000fe200078e0016ULL, 0x0000000d1f1f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000d24257c11ULL, 0x002fe2000f8e20ffULL, 0x00000010330e7825ULL, 0x000fe200078e002aULL,
0x0000000d1e357c11ULL, 0x000fc4000f8e20ffULL, 0x0000000d1b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010332a7825ULL, 0x040fe200078e002cULL, 0x000000000c257faeULL, 0x000fe2000b901c4eULL,
0x0000000d1a377c11ULL, 0x000fe4000f8e20ffULL, 0x00000010332c7825ULL, 0x000fe200078e002eULL,
0x000000000a237faeULL, 0x0005e2000b901c4eULL, 0x0000000d15157c11ULL, 0x000fe4000f8e20ffULL,
0x00000010332e7825ULL, 0x000fe200078e0030ULL, 0x0000000d22317c11ULL, 0x000fc4000f8e20ffULL,
0x0000000d13137c11ULL, 0x000fe2000f8e20ffULL, 0x0000001033047825ULL, 0x000fe200078e0004ULL,
0x0000000d11117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000008317faeULL, 0x0007e4000b901c4eULL,
0x0000001033027825ULL, 0x040fe200078e0002ULL, 0x0000000d100b7c11ULL, 0x004fe2000f8e20ffULL,
0x0000000006217faeULL, 0x0005e4000b901c4eULL, 0x0000001033267825ULL, 0x000fc800078e0026ULL,
0x00000010331c7825ULL, 0x000fe200078e001cULL, 0x0000000d12097c11ULL, 0x008fc6000f8e20ffULL,
0x0000001033187825ULL, 0x000fe200078e0018ULL, 0x0000000d14077c11ULL, 0x004fc6000f8e20ffULL,
0x0000001033287825ULL, 0x000fe200078e0028ULL, 0x0000000d20337c11ULL, 0x000fca000f8e20ffULL,
0x0000000016337faeULL, 0x0003e8000b901c4eULL, 0x00000000041f7faeULL, 0x0003e8000b901c4eULL,
0x0000000002357faeULL, 0x0003e8000b901c4eULL, 0x00000000261b7faeULL, 0x0003e8000b901c4eULL,
0x000000001c377faeULL, 0x0003e8000b901c4eULL, 0x0000000018157faeULL, 0x0003e8000b901c4eULL,
0x0000000028077faeULL, 0x0003e8000b901c4eULL, 0x000000000e137faeULL, 0x0003e8000b901c4eULL,
0x000000002a097faeULL, 0x0003e8000b901c4eULL, 0x000000002c117faeULL, 0x0003e8000b901c4eULL,
0x000000002e0b7faeULL, 0x0003e4000b901c4eULL, 0x00000004ff037819ULL, 0x102fe20000011648ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000003ff047819ULL, 0x000fe20000011648ULL,
0x0000200008087890ULL, 0x000fe2000fffe03fULL, 0x0000000800027812ULL, 0x000fe200078ef848ULL,
0x0000000803057824ULL, 0x000fe200078e00ffULL, 0x0000000104087812ULL, 0x000fc600078ec0ffULL,
0x0000000102037824ULL, 0x040fe200078e0203ULL, 0xfffffff805247812ULL, 0x000fe200078ee200ULL,
0x0000002002047824ULL, 0x040fe400078e00ffULL, 0x00000020020a7824ULL, 0x000fe400078e00ffULL,
0x0000000108347824ULL, 0x000fe200078e0224ULL, 0xffffffe004047812ULL, 0x000fe200078ee203ULL,
0x0000000824057824ULL, 0x040fe400078e00ffULL, 0x00000008240b7824ULL, 0x000fe200078e00ffULL,
0x0000000404047c11ULL, 0x000fe2000f8e20ffULL, 0x00000002346e7836ULL, 0x000fe20000000000ULL,
0xfffffff8054a7812ULL, 0x000fe200078ee234ULL, 0x0000001024357836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000084a097c11ULL, 0x000fe2000f8e20ffULL,
0x000000000404783bULL, 0x000fe20000000200ULL, 0xfffffff80b6e7812ULL, 0x000fe200078ee26eULL,
0x0000000108697824ULL, 0x000fe400078e0235ULL, 0x00000000090c783bULL, 0x000e620000000200ULL,
0x000000086e107c11ULL, 0x000fe2000f8e20ffULL, 0x0000002024367836ULL, 0x000fe40000000000ULL,
0x0000840901007387ULL, 0x0005e20000100800ULL, 0x0000003024377836ULL, 0x000fc40000000000ULL,
0x00000001086c7824ULL, 0x000fe200078e0236ULL, 0x000000001014783bULL, 0x000fe20000000200ULL,
0x00000008360b7824ULL, 0x000fe400078e00ffULL, 0x00000001086d7824ULL, 0x000fe200078e0237ULL,
0x0000a01001007387ULL, 0x0007e20000100800ULL, 0x0000000837087824ULL, 0x000fe200078e00ffULL,
0xfffffff80b6c7812ULL, 0x000fe200078ee26cULL, 0x0000000203097836ULL, 0x004fe40000000000ULL,
0x00000012346f7836ULL, 0x000fe20000000000ULL, 0xfffffff8086d7812ULL, 0x000fe200078ee26dULL,
0x0000002234717836ULL, 0x000fe20000000000ULL, 0xffffffe00a097812ULL, 0x000fe200078ee209ULL,
0x00000008350a7824ULL, 0x000fe200078e00ffULL, 0x000000086d117c11ULL, 0x000fe2000f8e20ffULL,
0x0000000835107824ULL, 0x008fe200078e00ffULL, 0x0000000409097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000836267824ULL, 0x000fe200078e00ffULL, 0xfffffff80a697812ULL, 0x000fe200078ee269ULL,
0x000000001120783bULL, 0x000ea20000000200ULL, 0xfffffff8106f7812ULL, 0x000fe200078ee26fULL,
0x00000008243e7824ULL, 0x000fe200078e00ffULL, 0xfffffff826717812ULL, 0x000fe200078ee271ULL,
0x00000000091c783bULL, 0x0007220000000200ULL, 0x000000086f107c11ULL, 0x000fe2000f8e20ffULL,
0x0000000837267824ULL, 0x000fe200078e00ffULL, 0x0000000871257c11ULL, 0x000fe2000f8e20ffULL,
0x00000006343d7836ULL, 0x000fe20000000000ULL, 0x0000000869097c11ULL, 0x008fe2000f8e20ffULL,
0x0000000c0440723cULL, 0x002fe600000018ffULL, 0xfffffff83e3d7812ULL, 0x000fe200078ee23dULL,
0x0000880901007387ULL, 0x000fe60000100800ULL, 0x000000083d3f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000e040c723cULL, 0x000fe200000018ffULL, 0x000000000918783bULL, 0x0002e40000000200ULL,
0x000000086c097c11ULL, 0x002fca000f8e20ffULL, 0x00008c0901007387ULL, 0x000fe80000100800ULL,
0x000000000908783bULL, 0x000e620000000200ULL, 0x000000200438723cULL, 0x004fe600000018ffULL,
0x00009c1101007387ULL, 0x000fe80000100800ULL, 0x0000ac1001007387ULL, 0x000fe20000100800ULL,
0x000000141c40723cULL, 0x010fe20000001840ULL, 0x0000000837217824ULL, 0x000fc400078e00ffULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x0000000837377824ULL, 0x000fe400078e00ffULL,
0x000000161c14723cULL, 0x000fe2000000180cULL, 0x0000b82501007387ULL, 0x000fe80000100800ULL,
0x00000000250c783bULL, 0x0009620000000200ULL, 0x000000180428723cULL, 0x008fe200000018ffULL,
0x0000003234257836ULL, 0x010fca0000000000ULL, 0x0000001a0418723cULL, 0x000fe200000018ffULL,
0xfffffff826277812ULL, 0x000fc800078ee225ULL, 0x0000000827207c11ULL, 0x000fe2000f8e20ffULL,
0x00004c2701007387ULL, 0x000fe20000100800ULL, 0x000000080430723cULL, 0x002fe600000018ffULL,
0x00000000202c783bULL, 0x000e660000000200ULL, 0x0000000a0408723cULL, 0x000fe200000018ffULL,
0x0000a82001007387ULL, 0x0007ea0000100800ULL, 0x000000101c28723cULL, 0x004fe20000001828ULL,
0x0000000835207824ULL, 0x008fca00078e00ffULL, 0x000000121c10723cULL, 0x000fe20000001818ULL,
0x0000000835357824ULL, 0x000fca00078e00ffULL, 0x0000000c1c30723cULL, 0x020fe20000001830ULL,
0x0000002002197824ULL, 0x000fe400078e00ffULL, 0x0000000403187836ULL, 0x000fe40000000000ULL,
0x00000008241b7824ULL, 0x000fe200078e00ffULL, 0x000000220404723cULL, 0x000fe200000018ffULL,
0x00000004340c7836ULL, 0x000fe20000000000ULL, 0xffffffe019187812ULL, 0x000fe200078ee218ULL,
0x00000014340d7836ULL, 0x000fe40000000000ULL, 0x0000002434197836ULL, 0x000fe20000000000ULL,
0xfffffff81b257812ULL, 0x000fe200078ee20cULL, 0x0000000836227824ULL, 0x000fe200078e00ffULL,
0xfffffff820277812ULL, 0x000fe200078ee20dULL, 0x00000034341a7836ULL, 0x000fe20000000000ULL,
0x0000000e1c0c723cULL, 0x000fe20000001808ULL, 0x0000502501007387ULL, 0x0005e20000100800ULL,
0xfffffff822267812ULL, 0x000fe200078ee219ULL, 0x0000002002197824ULL, 0x000fe200078e00ffULL,
0xfffffff821237812ULL, 0x000fe200078ee21aULL, 0x0000542701007387ULL, 0x000fe20000100800ULL,
0x0000000827207c11ULL, 0x000fe2000f8e20ffULL, 0x0000002c1c38723cULL, 0x002fe20000001838ULL,
0x0000000418087c11ULL, 0x000fe2000f8e20ffULL, 0x0000582601007387ULL, 0x000fe20000100800ULL,
0x00000008261b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000603187836ULL, 0x000fe20000000000ULL,
0x0000000825257c11ULL, 0x004fe2000f8e20ffULL, 0x00005c2301007387ULL, 0x000fe20000100800ULL,
0x00000008231a7c11ULL, 0x000fe2000f8e20ffULL, 0x00000016342c7836ULL, 0x000fe20000000000ULL,
0xffffffe0193c7812ULL, 0x000fe200078ee218ULL, 0x0000a42501007387ULL, 0x000fe20000100800ULL,
0x0000000836367824ULL, 0x000fe200078e00ffULL, 0x0000002e1c1c723cULL, 0x000fe20000001804ULL,
0x00000026342d7836ULL, 0x000fe20000000000ULL, 0x00000000254c783bULL, 0x000fe20000000200ULL,
0x0000003634347836ULL, 0x000fe20000000000ULL, 0xfffffff835457812ULL, 0x000fc400078ee22cULL,
0x0000b02001007387ULL, 0x000fe20000100800ULL, 0xfffffff8364b7812ULL, 0x000fe400078ee22dULL,
0xfffffff837497812ULL, 0x000fe200078ee234ULL, 0x000000002024783bULL, 0x000fe20000000200ULL,
0x00000008452c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000043c447c11ULL, 0x000fe2000f8e20ffULL,
0x0000b41b01007387ULL, 0x000fe20000100800ULL, 0x000000084b057c11ULL, 0x000fe4000f8e20ffULL,
0x0000000849047c11ULL, 0x000fe2000f8e20ffULL, 0x000000000808783bULL, 0x000e680000000200ULL,
0x000000001b20783bULL, 0x000ea80000000200ULL, 0x0000bc1a01007387ULL, 0x000fe80000100800ULL,
0x000000001a18783bULL, 0x000ee80000000200ULL, 0x0000603d01007387ULL, 0x000fe80000100800ULL,
0x0000644501007387ULL, 0x000fe80000100800ULL, 0x0000684b01007387ULL, 0x000fe80000100800ULL,
0x0000704901007387ULL, 0x000fe80000100800ULL, 0x0000c43f01007387ULL, 0x000fe80000100800ULL,
0x0000c02c01007387ULL, 0x000fe80000100800ULL, 0x0000c80501007387ULL, 0x000fe20000100800ULL,
0x0000004c0840723cULL, 0x002fe60000001840ULL, 0x000000004444783bULL, 0x000fe60000000200ULL,
0x000000240828723cULL, 0x000fe20000001828ULL, 0x000000003f3c783bULL, 0x000e620000000200ULL,
0x00000003ff4c7819ULL, 0x000fc60000011648ULL, 0x000000002c2c783bULL, 0x000f220000000200ULL,
0x000000200830723cULL, 0x004fe60000001830ULL, 0x000000000534783bULL, 0x000ea60000000200ULL,
0x0000004e0814723cULL, 0x000fe20000001814ULL, 0x0000cc0401007387ULL, 0x000fe80000100800ULL,
0x000000000404783bULL, 0x000f620000000200ULL, 0x000000260810723cULL, 0x000fe20000001810ULL,
0x00000000004d7919ULL, 0x000eaa0000000000ULL, 0x00000022080c723cULL, 0x000fec000000180cULL,
0x000000180838723cULL, 0x008fec0000001838ULL, 0x0000001a0808723cULL, 0x000fec000000181cULL,
0x0000003c4440723cULL, 0x002fec0000001840ULL, 0x0000002c4428723cULL, 0x010fec0000001828ULL,
0x000000344430723cULL, 0x004fec0000001830ULL, 0x0000003e443c723cULL, 0x000fec0000001814ULL,
0x0000002e442c723cULL, 0x000fec0000001810ULL, 0x000000364434723cULL, 0x000fec000000180cULL,
0x000000044438723cULL, 0x020fec0000001838ULL, 0x000000064444723cULL, 0x000fe20000001808ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000c009c8947ULL, 0x000fde0003800000ULL,
0x000000044c537836ULL, 0x000fe20000000000ULL, 0x80000012130c7290ULL, 0x000fe2000fffe03fULL,
0x0000000c4c517836ULL, 0x000fe20000000000ULL, 0x00000010004b7812ULL, 0x000fe200078efcffULL,
0x00000001536a7824ULL, 0x140fe400078e024dULL, 0x0000000853057824ULL, 0x000fe400078e00ffULL,
0x000000014c047824ULL, 0x100fe400078e024dULL, 0x0000000151687824ULL, 0x140fe200078e024dULL,
0xfffffff8056a7812ULL, 0x000fe200078ee26aULL, 0x0000000851057824ULL, 0x000fe200078e00ffULL,
0x0000000767677812ULL, 0x000fe200078ef804ULL, 0x000000084c527836ULL, 0x000fe20000000000ULL,
0x000000086a497c11ULL, 0x000fe2000f8e20ffULL, 0x000000104c507836ULL, 0x000fe20000000000ULL,
0xfffffff805687812ULL, 0x000fe200078ee268ULL, 0x00000001526b7824ULL, 0x040fe200078e024dULL,
0x00000008674e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000852047824ULL, 0x000fe200078e00ffULL,
0x0000000868557c11ULL, 0x000fe2000f8e20ffULL, 0x0000001c4c057836ULL, 0x000fc40000000000ULL,
0x000000144c277836ULL, 0x000fe20000000000ULL, 0xfffffff8046b7812ULL, 0x000fe200078ee26bULL,
0x0000000150667824ULL, 0x140fe400078e024dULL, 0x0000000850077824ULL, 0x000fe200078e00ffULL,
0x000000086b487c11ULL, 0x000fe2000f8e20ffULL, 0x0000000105637824ULL, 0x040fe400078e024dULL,
0x0000000805067824ULL, 0x000fe200078e00ffULL, 0xfffffff807667812ULL, 0x000fe200078ee266ULL,
0x000000184c267836ULL, 0x000fc40000000000ULL, 0x0000000127657824ULL, 0x140fe200078e024dULL,
0xfffffff806637812ULL, 0x000fe200078ee263ULL, 0x0000000827047824ULL, 0x000fe200078e00ffULL,
0x0000000866547c11ULL, 0x000fe2000f8e20ffULL, 0x000000244c597836ULL, 0x000fe20000000000ULL,
0x00000008637d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000126647824ULL, 0x140fe200078e024dULL,
0xfffffff804657812ULL, 0x000fe200078ee265ULL, 0x0000000826077824ULL, 0x000fe400078e00ffULL,
0x0000000159617824ULL, 0x000fe200078e024dULL, 0x00000008654f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000859067824ULL, 0x000fe200078e00ffULL, 0xfffffff807647812ULL, 0x000fe200078ee264ULL,
0x000000284c587836ULL, 0x000fc40000000000ULL, 0x000000204c047836ULL, 0x000fe20000000000ULL,
0xfffffff806617812ULL, 0x000fe200078ee261ULL, 0x0000000158607824ULL, 0x140fe400078e024dULL,
0x0000000858097824ULL, 0x000fe200078e00ffULL, 0x00000008617a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000104627824ULL, 0x040fe400078e024dULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0xfffffff809607812ULL, 0x000fe200078ee260ULL, 0x0000000953067c36ULL, 0x000fc40008000000ULL,
0x000000094c087c36ULL, 0x000fe20008000000ULL, 0xfffffff807627812ULL, 0x000fe200078ee262ULL,
0x000000304c567836ULL, 0x000fe20000000000ULL, 0x0000001906097c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000952117c36ULL, 0x000fe20008000000ULL, 0x0000001908077c10ULL, 0x000fe2000ff3e0ffULL,
0x00000009510d7c36ULL, 0x000fe20008000000ULL, 0x0000480801007387ULL, 0x0003e20000100800ULL,
0x00000001565e7824ULL, 0x100fe200078e024dULL, 0x00000008627b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000008560b7824ULL, 0x000fe200078e00ffULL, 0x0000400601007387ULL, 0x0005e20000100800ULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000000860797c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000381101007387ULL, 0x000fe20000100800ULL,
0x0000000927107c36ULL, 0x000fe20008000000ULL, 0x0000001609087c11ULL, 0x002fe2000f8448ffULL,
0x00000009500f7c36ULL, 0x000fe20008000000ULL, 0x0000300d01007387ULL, 0x0003e20000100800ULL,
0xfffffff80b5e7812ULL, 0x000fe200078ee25eULL, 0x0000002c4c577836ULL, 0x000fe20000000000ULL,
0x0000001607067c11ULL, 0x004fe2000f8248ffULL, 0x0000000926137c36ULL, 0x000fe20008000000ULL,
0x0000001709097c11ULL, 0x000fe200090f4c0cULL, 0x0000000905157c36ULL, 0x000fe20008000000ULL,
0x0000001707077c11ULL, 0x000fe200088f4c0aULL, 0x00002c0f01007387ULL, 0x0005e20000100800ULL,
0x00000019110b7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000904177c36ULL, 0x000fe20008000000ULL,
0x000000190d0d7c10ULL, 0x002fe2000ff7e0ffULL, 0x00000001575f7824ULL, 0x000fe200078e024dULL,
0x0000001910117c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000281001007387ULL, 0x0003e20000100800ULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x000000160d0c7c11ULL, 0x000fe2000f8648ffULL, 0x00000008570e7824ULL, 0x000fe200078e00ffULL,
0x000000190f0f7c10ULL, 0x004fe2000ff9e0ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x000000160b0a7c11ULL, 0x000fe2000f8448ffULL, 0x0000000959197c36ULL, 0x000fe20008000000ULL,
0x0000241301007387ULL, 0x0005e20000100800ULL, 0x000000170d0d7c11ULL, 0x000fe200098f4c14ULL,
0x000000ffff167224ULL, 0x000fe200020e06ffULL, 0x0000001611107c11ULL, 0x002fe2000f8248ffULL,
0x0000201501007387ULL, 0x0003e20000100800ULL, 0x000000170b0b7c11ULL, 0x000fe200090f4c12ULL,
0x00000009581f7c36ULL, 0x000fe20008000000ULL, 0xfffffff80e5f7812ULL, 0x000fe200078ee25fULL,
0x00001c1701007387ULL, 0x0007e20000100800ULL, 0x0000001711117c11ULL, 0x000fe200088f4c18ULL,
0x00000009571e7c36ULL, 0x000fe20008000000ULL, 0x0000001913137c10ULL, 0x004fe2000ff5e0ffULL,
0x0000181901007387ULL, 0x0005e20000100800ULL, 0x000000160f0e7c11ULL, 0x000fe2000f8848ffULL,
0x000000104b207825ULL, 0x000fe200078e0008ULL, 0x0000001915157c10ULL, 0x002fe2000ff7e0ffULL,
0x0000141f01007387ULL, 0x000fe20000100800ULL, 0x000000170f0f7c11ULL, 0x000fe2000a0f4c16ULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x0000001917177c10ULL, 0x008fe2000ff9e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x0000001615147c11ULL, 0x000fe2000f8648ffULL,
0x0000081e01007387ULL, 0x0003e20000100800ULL, 0x0000001919197c10ULL, 0x004fe2000ff3e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x0000001613127c11ULL, 0x000fe2000f8448ffULL,
0x000000104b227825ULL, 0x000fe200078e000aULL, 0x0000001715157c11ULL, 0x000fe200098f4c1bULL,
0x0000444e01007387ULL, 0x0005e20000100800ULL, 0x0000001713137c11ULL, 0x000fe200090f4c1aULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x0000001619187c11ULL, 0x040fe2000f8248ffULL,
0x00003c4901007387ULL, 0x000fe20000100800ULL, 0x0000000c4c007c0cULL, 0x000fe2000bf66070ULL,
0x00000009567c7c36ULL, 0x000fe20008000000ULL, 0x0000001719197c11ULL, 0x000fe200088f4c1dULL,
0x0000344801007387ULL, 0x0007e20000100800ULL, 0x0000000c53007c0cULL, 0x000fe2000bf46070ULL,
0x0000003c4c5a7836ULL, 0x000fe20000000000ULL, 0x0000001617167c11ULL, 0x040fe2000f8848ffULL,
0x0000105501007387ULL, 0x0009e20000100800ULL, 0x0000000c52007c0cULL, 0x000fe2000bf26070ULL,
0x000000095a727c36ULL, 0x000fe20008000000ULL, 0x0000001717177c11ULL, 0x000fe2000a0f4c1cULL,
0x00000c5401007387ULL, 0x000be20000100800ULL, 0x000000191f1b7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000015a5b7824ULL, 0x000fe200078e024dULL, 0x000000191e1d7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000104b1e7825ULL, 0x002fe200078e0006ULL, 0x000000085f787c11ULL, 0x000fe2000f8e20ffULL,
0x0000044f01007387ULL, 0x0005e20000100800ULL, 0x000000085e777c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x000000161b1a7c11ULL, 0x000fe2000f8848ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e4e7faeULL, 0x0003e2000d901c4eULL,
0x0000000c27007c0cULL, 0x000fe2000bf66070ULL, 0x000000ffff257224ULL, 0x000fe200028e06ffULL,
0x000000161d1c7c11ULL, 0x000fe2000f8a48ffULL, 0x0000000020497faeULL, 0x0005e2000d101c4eULL,
0x0000000c50007c0cULL, 0x000fc4000bf46070ULL, 0x000000171b1b7c11ULL, 0x000fe2000a0f4c24ULL,
0x0000000022487faeULL, 0x0007e2000c901c4eULL, 0x0000000c51007c0cULL, 0x000fe4000bf26070ULL,
0x000000171d1d7c11ULL, 0x000fe2000a8f4c25ULL, 0x000000104b1e7825ULL, 0x002fe200078e000cULL,
0x0000000c26007c0cULL, 0x000fe4000bf86070ULL, 0x0000000c05007c0cULL, 0x000fe2000bfa6070ULL,
0x000000104b207825ULL, 0x004fe200078e000eULL, 0x00000008644e7c11ULL, 0x000fc6000f8e20ffULL,
0x000000104b227825ULL, 0x048fe400078e0010ULL, 0x000000001e557faeULL, 0x0009e2000c901c4eULL,
0x0000000c58007c0cULL, 0x000fe2000bf26070ULL, 0x000000104b247825ULL, 0x000fe400078e0012ULL,
0x0000000020547faeULL, 0x0003e2000d101c4eULL, 0x0000000c57007c0cULL, 0x000fe2000bf46070ULL,
0x000000104b487825ULL, 0x000fe400078e0014ULL, 0x00000000224f7faeULL, 0x0005e2000d901c4eULL,
0x0000000c04007c0cULL, 0x000fc6000bf66070ULL, 0x00000000244e7faeULL, 0x0007e2000e101c4eULL,
0x0000000c59007c0cULL, 0x000fe2000bf86070ULL, 0x000000344c557836ULL, 0x010fe40000000000ULL,
0x00000000487d7faeULL, 0x0009e2000e901c4eULL, 0x000000197c1f7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000104b207825ULL, 0x042fe400078e0016ULL, 0x0000004e01007387ULL, 0x0003e40000100800ULL,
0x000000104b227825ULL, 0x004fc400078e0018ULL, 0x00000000207b7faeULL, 0x000fe2000d901c4eULL,
0x0000000c56007c0cULL, 0x000fe2000bf66070ULL, 0x000000104b247825ULL, 0x008fe400078e001aULL,
0x00000000227a7faeULL, 0x0005e4000e101c4eULL, 0x000000ffff487224ULL, 0x010fe200028e06ffULL,
0x000000161f1e7c11ULL, 0x040fe2000f8a48ffULL, 0x0000000955767c36ULL, 0x000fe20008000000ULL,
0x0000000024797faeULL, 0x000fe2000c901c4eULL, 0x000000384c547836ULL, 0x020fe20000000000ULL,
0x000000171f1f7c11ULL, 0x000fe2000a8f4c48ULL, 0x00000001555d7824ULL, 0x000fc400078e024dULL,
0x00000001545c7824ULL, 0x000fe400078e024dULL, 0x000000104b227825ULL, 0x004fc800078e001cULL,
0x000000104b207825ULL, 0x000fe200078e001eULL, 0x0000000022787faeULL, 0x0005e6000d101c4eULL,
0x0000000954747c36ULL, 0x000fe20008000000ULL, 0x0000000020777faeULL, 0x0007e2000d901c4eULL,
0x0000000855227824ULL, 0x004fc600078e00ffULL, 0x0000001974237c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000854207824ULL, 0x008fe200078e00ffULL, 0x0000001976217c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0xfffffff8225d7812ULL, 0x000fe400078ee25dULL,
0xfffffff8205c7812ULL, 0x000fe200078ee25cULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0x0000001621207c11ULL, 0x000fe4000f8248ffULL, 0x000000085d757c11ULL, 0x000fe4000f8e20ffULL,
0x0000001721217c11ULL, 0x000fe400088f4c22ULL, 0x0000000c55007c0cULL, 0x000fc4000bf26070ULL,
0x0000001623227c11ULL, 0x040fe4000f8448ffULL, 0x000000085c737c11ULL, 0x000fe4000f8e20ffULL,
0x0000001723237c11ULL, 0x000fe200090f4c24ULL, 0x000000104b247825ULL, 0x000fe200078e0020ULL,
0x0000000c54007c0cULL, 0x000fca000bf46070ULL, 0x0000000024757faeULL, 0x0005e4000c901c4eULL,
0x000000104b247825ULL, 0x004fcc00078e0022ULL, 0x0000000024737faeULL, 0x0005e4000d101c4eULL,
0x0000001972257c10ULL, 0x004fca000ff3e0ffULL, 0x000000ffff487224ULL, 0x000fe200008e06ffULL,
0x0000001625247c11ULL, 0x000fc8000f8248ffULL, 0x0000001725257c11ULL, 0x000fe200088f4c48ULL,
0x000000085a487824ULL, 0x040fe200078e00ffULL, 0x0000000c5a007c0cULL, 0x000fc8000bf26070ULL,
0xfffffff8485b7812ULL, 0x000fe200078ee25bULL, 0x000000104b487825ULL, 0x000fc600078e0024ULL,
0x000000085b707c11ULL, 0x000fca000f8e20ffULL, 0x0000000048707faeULL, 0x0003e2000c901c4eULL,
0x0000000c00547947ULL, 0x000fea0003800000ULL, 0x000000044c537836ULL, 0x000fe20000000000ULL,
0x00000010004b7812ULL, 0x000fe200078efcffULL, 0x0000000c4c517836ULL, 0x000fe40000000000ULL,
0x00000001536a7824ULL, 0x140fe400078e024dULL, 0x0000000853057824ULL, 0x000fe400078e00ffULL,
0x000000084c527836ULL, 0x000fe40000000000ULL, 0x0000000151687824ULL, 0x040fe200078e024dULL,
0xfffffff8056a7812ULL, 0x000fe200078ee26aULL, 0x0000000851057824ULL, 0x000fc400078e00ffULL,
0x00000001526b7824ULL, 0x100fe200078e024dULL, 0x000000086a4f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000852067824ULL, 0x000fe200078e00ffULL, 0xfffffff805687812ULL, 0x000fe200078ee268ULL,
0x000000014c047824ULL, 0x100fe400078e024dULL, 0x000000104c507836ULL, 0x000fe20000000000ULL,
0xfffffff8066b7812ULL, 0x000fe200078ee26bULL, 0x0000001c4c057836ULL, 0x000fe20000000000ULL,
0x0000000767677812ULL, 0x000fe200078ef804ULL, 0x000000144c277836ULL, 0x000fe20000000000ULL,
0x000000086b4e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000150667824ULL, 0x140fe200078e024dULL,
0x0000000867547c11ULL, 0x000fe2000f8e20ffULL, 0x0000000850077824ULL, 0x000fe200078e00ffULL,
0x0000000868497c11ULL, 0x000fe2000f8e20ffULL, 0x0000000105637824ULL, 0x000fc400078e024dULL,
0x0000000805067824ULL, 0x000fe200078e00ffULL, 0xfffffff807667812ULL, 0x000fe200078ee266ULL,
0x0000000127657824ULL, 0x140fe400078e024dULL, 0x0000000827047824ULL, 0x000fe200078e00ffULL,
0xfffffff806637812ULL, 0x000fe200078ee263ULL, 0x000000184c267836ULL, 0x000fe20000000000ULL,
0x0000000866487c11ULL, 0x000fe2000f8e20ffULL, 0x000000244c597836ULL, 0x000fe20000000000ULL,
0xfffffff804657812ULL, 0x000fe200078ee265ULL, 0x0000002c4c577836ULL, 0x000fe20000000000ULL,
0x00000008637d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000126647824ULL, 0x000fc400078e024dULL,
0x0000000826077824ULL, 0x000fe400078e00ffULL, 0x0000000159617824ULL, 0x140fe400078e024dULL,
0x0000000859067824ULL, 0x000fe200078e00ffULL, 0xfffffff807647812ULL, 0x000fe200078ee264ULL,
0x00000001575f7824ULL, 0x040fe400078e024dULL, 0x0000000857087824ULL, 0x000fe200078e00ffULL,
0xfffffff806617812ULL, 0x000fe200078ee261ULL, 0x000000204c047836ULL, 0x000fc40000000000ULL,
0x000000284c587836ULL, 0x000fe20000000000ULL, 0xfffffff8085f7812ULL, 0x000fe200078ee25fULL,
0x0000000104627824ULL, 0x140fe200078e024dULL, 0x00000008617a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000804097824ULL, 0x000fe200078e00ffULL, 0x000000085f787c11ULL, 0x000fe2000f8e20ffULL,
0x0000000158607824ULL, 0x040fe400078e024dULL, 0x0000000858077824ULL, 0x000fe200078e00ffULL,
0xfffffff809627812ULL, 0x000fe200078ee262ULL, 0x0000000953087c36ULL, 0x000fc40008000000ULL,
0x0000000952067c36ULL, 0x000fe20008000000ULL, 0xfffffff807607812ULL, 0x000fe200078ee260ULL,
0x000000094c0a7c36ULL, 0x000fe20008000000ULL, 0x0000001908097c10ULL, 0x000fe2000ff5e0ffULL,
0x000000304c567836ULL, 0x000fe20000000000ULL, 0x00000019060b7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000951137c36ULL, 0x000fe20008000000ULL, 0x000000190a077c10ULL, 0x000fe2000ff3e0ffULL,
0x0000480a01007387ULL, 0x0003e20000100800ULL, 0x00000001565e7824ULL, 0x000fe200078e024dULL,
0x00000008627b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000008560d7824ULL, 0x000fe200078e00ffULL,
0x0000400801007387ULL, 0x0005e20000100800ULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x0000000860797c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x0000380601007387ULL, 0x0007e20000100800ULL, 0x00000009500f7c36ULL, 0x000fe20008000000ULL,
0x000000160b0a7c11ULL, 0x002fe2000f8648ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000301301007387ULL, 0x000fe20000100800ULL, 0x0000000927117c36ULL, 0x000fe20008000000ULL,
0x0000001609087c11ULL, 0x004fe2000f8448ffULL, 0x0000000926127c36ULL, 0x000fe20008000000ULL,
0xfffffff80d5e7812ULL, 0x000fe200078ee25eULL, 0x00002c0f01007387ULL, 0x0003e20000100800ULL,
0x0000001607067c11ULL, 0x008fe2000f8248ffULL, 0x0000000905157c36ULL, 0x000fe20008000000ULL,
0x0000001709097c11ULL, 0x000fe200090f4c0eULL, 0x0000281101007387ULL, 0x0005e20000100800ULL,
0x000000170b0b7c11ULL, 0x000fe200098f4c10ULL, 0x0000000904177c36ULL, 0x000fe20008000000ULL,
0x0000001707077c11ULL, 0x000fe200088f4c0cULL, 0x0000000959197c36ULL, 0x000fe20008000000ULL,
0x00000019130d7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000241201007387ULL, 0x0007e20000100800ULL,
0x000000190f0f7c10ULL, 0x002fe2000ff7e0ffULL, 0x00000009581b7c36ULL, 0x000fe20008000000ULL,
0x0000001912137c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x0000001911117c10ULL, 0x004fe2000ff9e0ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x000000160d0c7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x000000160f0e7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x0000001611107c11ULL, 0x000fe2000f8848ffULL, 0x0000201501007387ULL, 0x0003e20000100800ULL,
0x0000001613127c11ULL, 0x008fe2000f8248ffULL, 0x000000104b207825ULL, 0x000fe200078e000aULL,
0x000000170d0d7c11ULL, 0x000fe200090f4c14ULL, 0x00001c1701007387ULL, 0x0005e20000100800ULL,
0x000000170f0f7c11ULL, 0x000fe200098f4c16ULL, 0x00000009567c7c36ULL, 0x000fe20008000000ULL,
0x0000001711117c11ULL, 0x000fe2000a0f4c18ULL, 0x0000181901007387ULL, 0x0007e20000100800ULL,
0x0000001713137c11ULL, 0x000fe200088f4c1aULL, 0x000000104b227825ULL, 0x040fe200078e000cULL,
0x0000001915157c10ULL, 0x002fe2000ff5e0ffULL, 0x0000141b01007387ULL, 0x0003e20000100800ULL,
0x000000085e777c11ULL, 0x000fe2000f8e20ffULL, 0x000000104b247825ULL, 0x000fe200078e000eULL,
0x0000001917177c10ULL, 0x004fe2000ff7e0ffULL, 0x0000445401007387ULL, 0x0005e20000100800ULL,
0x0000001919197c10ULL, 0x008fe2000ff9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x0000001615147c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x000000191b1b7c10ULL, 0x002fe2000ff3e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200020e06ffULL,
0x0000001617167c11ULL, 0x000fe2000f8648ffULL, 0x00003c4f01007387ULL, 0x000fe20000100800ULL,
0x0000001619187c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e06ffULL,
0x000000161b1a7c11ULL, 0x000fe2000f8248ffULL, 0x0000344e01007387ULL, 0x000fe20000100800ULL,
0x0000001715157c11ULL, 0x000fe200090f4c1cULL, 0x000000344c557836ULL, 0x000fe20000000000ULL,
0x0000001717177c11ULL, 0x000fe200098f4c1dULL, 0x000000104b1c7825ULL, 0x000fe200078e0006ULL,
0x0000001719197c11ULL, 0x000fe2000a0f4c1eULL, 0x0000104901007387ULL, 0x000fe20000100800ULL,
0x000000171b1b7c11ULL, 0x000fe200088f4c1fULL, 0x000000104b1e7825ULL, 0x000fc400078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c547faeULL, 0x0003e4000b901c4eULL,
0x0000000955767c36ULL, 0x000fe40008000000ULL, 0x000000001e4f7faeULL, 0x0007e2000b901c4eULL,
0x00000001555d7824ULL, 0x000fe400078e024dULL, 0x0000003c4c5a7836ULL, 0x000fe20000000000ULL,
0x00000000204e7faeULL, 0x0009e6000b901c4eULL, 0x000000095a727c36ULL, 0x000fe20008000000ULL,
0x0000000022497faeULL, 0x000be2000b901c4eULL, 0x000000104b1c7825ULL, 0x002fc600078e0010ULL,
0x00000c4801007387ULL, 0x0003e20000100800ULL, 0x000000104b1e7825ULL, 0x008fc600078e0012ULL,
0x0000000024487faeULL, 0x0003e2000b901c4eULL, 0x000000104b207825ULL, 0x010fe200078e0014ULL,
0x0000000864227c11ULL, 0x020fc6000f8e20ffULL, 0x0000000957237c36ULL, 0x000fe40008000000ULL,
0x000000384c547836ULL, 0x004fe40000000000ULL, 0x000000015a5b7824ULL, 0x000fe200078e024dULL,
0x0000082301007387ULL, 0x000fe20000100800ULL, 0x0000000954747c36ULL, 0x000fe20008000000ULL,
0x0000000865487c11ULL, 0x002fe2000f8e20ffULL, 0x000000104b247825ULL, 0x000fc800078e001aULL,
0x000000001c487faeULL, 0x0003e2000b901c4eULL, 0x00000001545c7824ULL, 0x000fc600078e024dULL,
0x0000044801007387ULL, 0x0005e80000100800ULL, 0x000000001e227faeULL, 0x0007e2000b901c4eULL,
0x00000019231d7c10ULL, 0x002fc6000ff3e0ffULL, 0x00000000207d7faeULL, 0x0003e4000b901c4eULL,
0x000000ffff487224ULL, 0x004fe200008e06ffULL, 0x000000161d1c7c11ULL, 0x040fe2000f8248ffULL,
0x0000002201007387ULL, 0x0005e20000100800ULL, 0x000000197c1f7c10ULL, 0x008fe4000ff5e0ffULL,
0x000000171d1d7c11ULL, 0x000fe200088f4c48ULL, 0x000000104b207825ULL, 0x002fc800078e0016ULL,
0x000000ffff497224ULL, 0x000fe200010e06ffULL, 0x000000161f1e7c11ULL, 0x000fe2000f8448ffULL,
0x000000104b227825ULL, 0x004fe200078e0018ULL, 0x00000000207b7faeULL, 0x0003e4000b901c4eULL,
0x000000171f1f7c11ULL, 0x000fe400090f4c49ULL, 0x00000000227a7faeULL, 0x0005e8000b901c4eULL,
0x0000000024797faeULL, 0x000fe2000b901c4eULL, 0x000000104b207825ULL, 0x002fc800078e001cULL,
0x000000104b227825ULL, 0x004fe200078e001eULL, 0x0000000020787faeULL, 0x0003e8000b901c4eULL,
0x0000000022777faeULL, 0x0005e2000b901c4eULL, 0x0000000855207824ULL, 0x002fe200078e00ffULL,
0x0000001976217c10ULL, 0x000fc8000ff3e0ffULL, 0xfffffff8205d7812ULL, 0x000fe200078ee25dULL,
0x000000ffff227224ULL, 0x004fe200008e06ffULL, 0x0000001621207c11ULL, 0x000fe4000f8248ffULL,
0x000000085d757c11ULL, 0x000fe4000f8e20ffULL, 0x0000001721217c11ULL, 0x000fe400088f4c22ULL,
0x0000001974237c10ULL, 0x000fca000ff3e0ffULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0x0000001623227c11ULL, 0x000fc8000f8248ffULL, 0x0000001723237c11ULL, 0x000fe400088f4c24ULL,
0x0000001972257c10ULL, 0x000fca000ff3e0ffULL, 0x000000ffff487224ULL, 0x000fe200008e06ffULL,
0x0000001625247c11ULL, 0x000fc8000f8248ffULL, 0x0000001725257c11ULL, 0x000fe200088f4c48ULL,
0x000000104b487825ULL, 0x000fca00078e0020ULL, 0x0000000048757faeULL, 0x0003e4000b901c4eULL,
0x0000000854487824ULL, 0x002fca00078e00ffULL, 0xfffffff8485c7812ULL, 0x000fe200078ee25cULL,
0x000000104b487825ULL, 0x000fc600078e0022ULL, 0x000000085c737c11ULL, 0x000fca000f8e20ffULL,
0x0000000048737faeULL, 0x0003e4000b901c4eULL, 0x000000085a487824ULL, 0x002fca00078e00ffULL,
0xfffffff8485b7812ULL, 0x000fe200078ee25bULL, 0x000000104b487825ULL, 0x000fc600078e0024ULL,
0x000000085b707c11ULL, 0x000fca000f8e20ffULL, 0x0000000048707faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000803487836ULL, 0x002fe20000000000ULL,
0x0000000d4a4c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002002497824ULL, 0x000fe200078e00ffULL,
0x0000000d69697c11ULL, 0x000fc6000f8e20ffULL, 0x0000984c01007387ULL, 0x000fe20000100800ULL,
0xffffffe049487812ULL, 0x000fc600078ee248ULL, 0x0000946901007387ULL, 0x000fe20000100800ULL,
0x0000000448487c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fca0000000000ULL,
0x000000004848783bULL, 0x000fe80000000200ULL, 0x000000004c4c783bULL, 0x000e640000000200ULL,
0x0000004c4840723cULL, 0x002fec0000001840ULL, 0x0000004e483c723cULL, 0x000fe2000000183cULL,
0x00000000694c783bULL, 0x0002a40000000200ULL, 0x0000000d6c697c11ULL, 0x002fc4000f8e20ffULL,
0x00004c00016c7983ULL, 0x000ee20000300800ULL, 0x0000004c4828723cULL, 0x004fec0000001828ULL,
0x0000004e482c723cULL, 0x000fe2000000182cULL, 0x00000000694c783bULL, 0x000e680000000200ULL,
0x0000906901007387ULL, 0x0005e40000100800ULL, 0x0000000d6d697c11ULL, 0x004fca000f8e20ffULL,
0x0000806901007387ULL, 0x000fe20000100800ULL, 0x0000004c4830723cULL, 0x002fec0000001830ULL,
0x0000004e4834723cULL, 0x000fe20000001834ULL, 0x00000000694c783bULL, 0x0002a80000000200ULL,
0x0000500001697983ULL, 0x002f220000300800ULL, 0x0000000d6e6d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000004c4838723cULL, 0x004fec0000001838ULL, 0x0000004e4844723cULL, 0x000fe20000001844ULL,
0x000000006d4c783bULL, 0x000fec0000000200ULL, 0x0000000a03487836ULL, 0x000fc40000000000ULL,
0x0000002002497824ULL, 0x000fca00078e00ffULL, 0xffffffe049487812ULL, 0x000fc800078ee248ULL,
0x0000000448487c11ULL, 0x000fcc000f8e20ffULL, 0x000000004848783bULL, 0x000e680000000200ULL,
0x00007c6d01007387ULL, 0x0005e40000100800ULL, 0x0000000d6f6d7c11ULL, 0x004fe2000f8e20ffULL,
0x0000004c4840723cULL, 0x002fec0000001840ULL, 0x0000004e483c723cULL, 0x000fe2000000183cULL,
0x000000006d4c783bULL, 0x000e680000000200ULL, 0x0000786d01007387ULL, 0x0005e80000100800ULL,
0x00005c00016f7983ULL, 0x000f620000300800ULL, 0x0000000d716d7c11ULL, 0x004fc6000f8e20ffULL,
0x0000580001717983ULL, 0x000ea20000300800ULL, 0x0000004c4828723cULL, 0x002fec0000001828ULL,
0x0000004e482c723cULL, 0x000fe2000000182cULL, 0x000000006d4c783bULL, 0x000e6a0000000200ULL,
0x0000004c4830723cULL, 0x002fe20000001830ULL, 0x0000000d6c6c7c11ULL, 0x008fca000f8e20ffULL,
0x0000004e4834723cULL, 0x000fe20000001834ULL, 0x000000006c4c783bULL, 0x000e6a0000000200ULL,
0x0000004c4838723cULL, 0x002fec0000001838ULL, 0x0000004e4848723cULL, 0x000fee0000001844ULL,
0x0000000c03447836ULL, 0x000fc40000000000ULL, 0x0000002002457824ULL, 0x000fca00078e00ffULL,
0xffffffe045447812ULL, 0x000fc800078ee244ULL, 0x0000000444447c11ULL, 0x000fca000f8e20ffULL,
0x00000000444c783bULL, 0x000fe20000000200ULL, 0x0000000d69697c11ULL, 0x010fca000f8e20ffULL,
0x000000006944783bULL, 0x000e680000000200ULL, 0x0000746d01007387ULL, 0x0007e80000100800ULL,
0x00006c6c01007387ULL, 0x0009e80000100800ULL, 0x00006000016e7983ULL, 0x000f680000300800ULL,
0x00006400016d7983ULL, 0x008ee80000300800ULL, 0x00006800016c7983ULL, 0x010f280000300800ULL,
0x0000506901007387ULL, 0x0003e80000100800ULL, 0x0000700001697983ULL, 0x002ee20000300800ULL,
0x000000444c40723cULL, 0x000fec0000001840ULL, 0x000000464c44723cULL, 0x000fe2000000183cULL,
0x00005400013f7983ULL, 0x000ee20000300800ULL, 0x0000000d71717c11ULL, 0x004fc4000f8e20ffULL,
0x0000000d6f6f7c11ULL, 0x020fc6000f8e20ffULL, 0x0000000d3f3f7c11ULL, 0x008fca000f8e20ffULL,
0x00004c3f01007387ULL, 0x000fe80000100800ULL, 0x000000003f3c783bULL, 0x000e640000000200ULL,
0x0000003c4c28723cULL, 0x002fec0000001828ULL, 0x0000003e4c3c723cULL, 0x000fe2000000182cULL,
0x00000000712c783bULL, 0x000e6a0000000200ULL, 0x0000002c4c30723cULL, 0x002fec0000001830ULL,
0x0000002e4c34723cULL, 0x000fe20000001834ULL, 0x000000006f2c783bULL, 0x000e620000000200ULL,
0x0000000d6e6e7c11ULL, 0x000fc8000f8e20ffULL, 0x0000002c4c38723cULL, 0x002fee0000001838ULL,
0x0000000e032c7836ULL, 0x000fe40000000000ULL, 0x00000020022d7824ULL, 0x000fca00078e00ffULL,
0xffffffe02d2c7812ULL, 0x000fc800078ee22cULL, 0x000000042c2c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000002e4c48723cULL, 0x000fe80000001848ULL, 0x000000002c4c783bULL, 0x000fe80000000200ULL,
0x000000006e2c783bULL, 0x000e620000000200ULL, 0x0000000d6d6d7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000d6c6c7c11ULL, 0x010fe2000f8e20ffULL, 0x0000002c4c40723cULL, 0x002fec0000001840ULL,
0x0000002e4c44723cULL, 0x000fe20000001844ULL, 0x000000006d2c783bULL, 0x000e620000000200ULL,
0x0000000d69697c11ULL, 0x000fc8000f8e20ffULL, 0x0000002c4c28723cULL, 0x002fec0000001828ULL,
0x0000002e4c3c723cULL, 0x000fe2000000183cULL, 0x000000006c2c783bULL, 0x000e6a0000000200ULL,
0x0000002c4c30723cULL, 0x002fec0000001830ULL, 0x0000002e4c34723cULL, 0x000fe20000001834ULL,
0x00000000692c783bULL, 0x000e6a0000000200ULL, 0x0000002c4c38723cULL, 0x002fec0000001838ULL,
0x0000002e4c48723cULL, 0x000fe20000001848ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000400208947ULL, 0x000fde0003800000ULL, 0x00000000002d7919ULL, 0x000e620000000000ULL,
0x8000001213087290ULL, 0x000fe2000fffe03fULL, 0x00000018002c7812ULL, 0x000fe400078efcffULL,
0x0000000d67677c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d6a6a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c067825ULL, 0x000fe200078e0006ULL, 0x0000000d6b6b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000d68687c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c087825ULL, 0x000fe200078e0008ULL,
0x0000000d66667c11ULL, 0x000fc4000f8e20ffULL, 0x0000000826007c0cULL, 0x000fe2000bf26070ULL,
0x000000102c0a7825ULL, 0x000fe200078e000aULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0000000804007c0cULL, 0x000fe2000bf66070ULL, 0x000000102c0c7825ULL, 0x000fe200078e000cULL,
0x0000000d65657c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d64647c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c0e7825ULL, 0x000fe200078e000eULL, 0x0000000d63637c11ULL, 0x000fc4000f8e20ffULL,
0x0000000d62627c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c107825ULL, 0x000fe200078e0010ULL,
0x0000000855007c0cULL, 0x000fe4000bf86070ULL, 0x0000000854007c0cULL, 0x000fe2000bfa6070ULL,
0x000000102c127825ULL, 0x000fe200078e0012ULL, 0x00000003ff2d7819ULL, 0x002fe4000001162dULL,
0x000000085a007c0cULL, 0x000fe2000bfc6070ULL, 0x000000102c147825ULL, 0x000fe200078e0014ULL,
0x000000082d007c0cULL, 0x000fc4000bf06070ULL, 0x0000000d61617c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c167825ULL, 0x000fe200078e0016ULL, 0x0000000d60607c11ULL, 0x000fe4000f8e20ffULL,
0x0000000d5f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c187825ULL, 0x000fe200078e0018ULL,
0x0000000d5e5e7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d5d5d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c1a7825ULL, 0x000fe200078e001aULL, 0x0000000d5c5c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006677faeULL, 0x0003e2000c101c4eULL,
0x0000000853007c0cULL, 0x000fe2000bf06070ULL, 0x000000102c1c7825ULL, 0x000fe200078e001cULL,
0x0000000d5b5b7c11ULL, 0x000fc6000f8e20ffULL, 0x000000102c1e7825ULL, 0x000fc800078e001eULL,
0x000000102c207825ULL, 0x000fc800078e0020ULL, 0x00000000086a7faeULL, 0x0003e2000c101c4eULL,
0x0000000852007c0cULL, 0x000fe2000bf06070ULL, 0x000000102c227825ULL, 0x000fc800078e0022ULL,
0x000000102c247825ULL, 0x000fd000078e0024ULL, 0x000000000a6b7faeULL, 0x0003e2000c101c4eULL,
0x0000000851007c0cULL, 0x000fda000bf06070ULL, 0x000000000c687faeULL, 0x0003e2000c101c4eULL,
0x0000000850007c0cULL, 0x000fda000bf06070ULL, 0x000000000e667faeULL, 0x0003e2000c101c4eULL,
0x0000000827007c0cULL, 0x000fda000bf06070ULL, 0x0000000010657faeULL, 0x0003e2000c101c4eULL,
0x0000000859007c0cULL, 0x000fc6000bf06070ULL, 0x0000000012647faeULL, 0x0003e2000c901c4eULL,
0x0000000858007c0cULL, 0x000fc6000bf26070ULL, 0x0000000014637faeULL, 0x0003e2000d101c4eULL,
0x0000000857007c0cULL, 0x000fc6000bf46070ULL, 0x0000000016627faeULL, 0x0003e2000d901c4eULL,
0x0000000856007c0cULL, 0x000fc6000bf66070ULL, 0x0000000018617faeULL, 0x0003e8000c101c4eULL,
0x000000001a607faeULL, 0x0003e8000c901c4eULL, 0x000000001c5f7faeULL, 0x0003e8000d101c4eULL,
0x000000001e5e7faeULL, 0x0003e8000d901c4eULL, 0x00000000205d7faeULL, 0x0003e8000e101c4eULL,
0x00000000225c7faeULL, 0x0003e8000e901c4eULL, 0x00000000245b7faeULL, 0x0003e2000f101c4eULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x00000018002c7812ULL, 0x000fe400078efcffULL,
0x0000000d67677c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d6a6a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c067825ULL, 0x000fe200078e0006ULL, 0x0000000d6b6b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000d68687c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c087825ULL, 0x000fe200078e0008ULL,
0x0000000d66667c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006677faeULL, 0x0003e2000b901c4eULL, 0x0000000d65657c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c0a7825ULL, 0x000fe200078e000aULL, 0x0000000d64647c11ULL, 0x000fe2000f8e20ffULL,
0x00000000086a7faeULL, 0x0003e2000b901c4eULL, 0x0000000d63637c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c0c7825ULL, 0x000fe200078e000cULL, 0x0000000d62627c11ULL, 0x000fe2000f8e20ffULL,
0x000000000a6b7faeULL, 0x0003e2000b901c4eULL, 0x0000000d61617c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c0e7825ULL, 0x000fe200078e000eULL, 0x0000000d60607c11ULL, 0x000fe2000f8e20ffULL,
0x000000000c687faeULL, 0x0003e2000b901c4eULL, 0x0000000d5f5f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c107825ULL, 0x000fe200078e0010ULL, 0x0000000d5e5e7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000e667faeULL, 0x0003e2000b901c4eULL, 0x0000000d5d5d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c127825ULL, 0x000fe200078e0012ULL, 0x0000000d5c5c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000010657faeULL, 0x0003e2000b901c4eULL, 0x0000000d5b5b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c147825ULL, 0x000fc400078e0014ULL, 0x0000000012647faeULL, 0x0003e4000b901c4eULL,
0x000000102c167825ULL, 0x040fe400078e0016ULL, 0x0000000014637faeULL, 0x0003e4000b901c4eULL,
0x000000102c187825ULL, 0x040fe400078e0018ULL, 0x0000000016627faeULL, 0x0003e4000b901c4eULL,
0x000000102c1a7825ULL, 0x000fc400078e001aULL, 0x0000000018617faeULL, 0x0003e4000b901c4eULL,
0x000000102c1c7825ULL, 0x040fe400078e001cULL, 0x000000001a607faeULL, 0x0003e4000b901c4eULL,
0x000000102c1e7825ULL, 0x040fe400078e001eULL, 0x000000001c5f7faeULL, 0x0003e4000b901c4eULL,
0x000000102c207825ULL, 0x000fc400078e0020ULL, 0x000000001e5e7faeULL, 0x0003e4000b901c4eULL,
0x000000102c227825ULL, 0x040fe400078e0022ULL, 0x00000000205d7faeULL, 0x0003e4000b901c4eULL,
0x000000102c247825ULL, 0x000fe400078e0024ULL, 0x00000000225c7faeULL, 0x0003e8000b901c4eULL,
0x00000000245b7faeULL, 0x0003e4000b901c4eULL, 0x0000840001087983ULL, 0x002ea80000300800ULL,
0x0000880001117983ULL, 0x000ee80000300800ULL, 0x00008c0001107983ULL, 0x000f280000300800ULL,
0x00009c0001147983ULL, 0x000f620000300800ULL, 0x0000001003067836ULL, 0x000fc40000000000ULL,
0x0000002002077824ULL, 0x000fe200078e00ffULL, 0x0000a00001197983ULL, 0x000ee80000300800ULL,
0x0000ac0001187983ULL, 0x000ee20000300800ULL, 0xffffffe007067812ULL, 0x000fc600078ee206ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000406067c11ULL, 0x000fc6000f8e20ffULL,
0x0000b80001177983ULL, 0x000ee80000300800ULL, 0x0000a80001167983ULL, 0x000ee80000300800ULL,
0x0000a40001157983ULL, 0x000ee20000300800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001410147291ULL, 0x000fc8000f8e103fULL, 0x000000061400728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x000000140b088291ULL, 0x000fe2000f8e083fULL,
0x00008c00000c8ab9ULL, 0x000fc60000000a00ULL, 0x00000004080c88a5ULL, 0x000fcc000f8e000cULL,
0x0000000dff077e24ULL, 0x000fe2000f8e00ffULL, 0x00000000080c783bULL, 0x004fe80000000200ULL,
0x000000000608783bULL, 0x000e640000000200ULL, 0x0000000c0840723cULL, 0x002fec0000001840ULL,
0x0000000e0844723cULL, 0x000fe20000001844ULL, 0x00000000110c783bULL, 0x008e680000000200ULL,
0x000000001010783bULL, 0x010ea20000000200ULL, 0x0000000c0828723cULL, 0x002fec0000001828ULL,
0x0000000e083c723cULL, 0x000fe2000000183cULL, 0x00000000140c783bULL, 0x0202e80000000200ULL,
0x0000b00001147983ULL, 0x002f680000300800ULL, 0x0000b400011d7983ULL, 0x000f680000300800ULL,
0x0000bc00011c7983ULL, 0x000f620000300800ULL, 0x000000100830723cULL, 0x004fe60000001830ULL,
0x0000c400011b7983ULL, 0x000ea60000300800ULL, 0x000000120834723cULL, 0x000fe20000001834ULL,
0x0000c000011a7983ULL, 0x000ea80000300800ULL, 0x000000001910783bULL, 0x0003e80000000200ULL,
0x0000c80001197983ULL, 0x002ea20000300800ULL, 0x0000000c0838723cULL, 0x008fec0000001838ULL,
0x0000000e0848723cULL, 0x000fe20000001848ULL, 0x00000000180c783bULL, 0x0003e80000000200ULL,
0x0000cc0001187983ULL, 0x002ee20000300800ULL, 0x0000000cff067e24ULL, 0x000fc6000f8e00ffULL,
0x0000480001687983ULL, 0x000f280000100800ULL, 0x0000000e06068981ULL, 0x0002e8000c1e1900ULL,
0x0000400001677983ULL, 0x0003280000100800ULL, 0x0000380001667983ULL, 0x0003280000100800ULL,
0x0000300001657983ULL, 0x0003280000100800ULL, 0x00002c0001647983ULL, 0x0003280000100800ULL,
0x0000280001637983ULL, 0x0003280000100800ULL, 0x0000240001627983ULL, 0x0003280000100800ULL,
0x0000200001617983ULL, 0x0003280000100800ULL, 0x00001c0001607983ULL, 0x0003280000100800ULL,
0x00001800015f7983ULL, 0x0003280000100800ULL, 0x00001400015e7983ULL, 0x0003280000100800ULL,
0x00000800015d7983ULL, 0x0003280000100800ULL, 0x00004400015b7983ULL, 0x0003280000100800ULL,
0x00003c00014f7983ULL, 0x0003280000100800ULL, 0x00003400014e7983ULL, 0x0003280000100800ULL,
0x00001000014d7983ULL, 0x0003280000100800ULL, 0x00000c00014c7983ULL, 0x0003280000100800ULL,
0x00000400012f7983ULL, 0x0003280000100800ULL, 0x00000000012e7983ULL, 0x0003220000100800ULL,
0x0000001203087836ULL, 0x000fc40000000000ULL, 0x0000002002097824ULL, 0x000fca00078e00ffULL,
0xffffffe009087812ULL, 0x000fc800078ee208ULL, 0x0000000408087c11ULL, 0x000fcc000f8e20ffULL,
0x000000000808783bULL, 0x000e640000000200ULL, 0x000000100840723cULL, 0x002fec0000001840ULL,
0x000000120844723cULL, 0x000fe20000001844ULL, 0x000000001710783bULL, 0x000e6a0000000200ULL,
0x0000000c0828723cULL, 0x000fec0000001828ULL, 0x0000000e083c723cULL, 0x000fe2000000183cULL,
0x00000000160c783bULL, 0x000e620000000200ULL, 0x0000001403077836ULL, 0x000fc80000000000ULL,
0x000000100830723cULL, 0x002fec0000001830ULL, 0x000000120834723cULL, 0x000fec0000001834ULL,
0x0000000c0838723cULL, 0x000fec0000001838ULL, 0x0000000e0848723cULL, 0x000fe20000001848ULL,
0x00000000150c783bULL, 0x000fec0000000200ULL, 0x0000002002087824ULL, 0x000fca00078e00ffULL,
0xffffffe008077812ULL, 0x000fc800078ee207ULL, 0x0000000407077c11ULL, 0x000fca000f8e20ffULL,
0x000000000708783bULL, 0x000e680000000200ULL, 0x000000001414783bULL, 0x020f680000000200ULL,
0x000000001c10783bULL, 0x000fe20000000200ULL, 0x0000000c0840723cULL, 0x002fec0000001840ULL,
0x0000000e0844723cULL, 0x000fe20000001844ULL, 0x000000001d0c783bULL, 0x000e620000000200ULL,
0x0000002002077824ULL, 0x000fe200078e00ffULL, 0x00000005100d7290ULL, 0x000fc6000fffe03fULL,
0x000000140828723cULL, 0x020fec0000001828ULL, 0x00000016083c723cULL, 0x000fe2000000183cULL,
0x000000001914783bULL, 0x004fea0000000200ULL, 0x0000000c0830723cULL, 0x002fee0000001830ULL,
0x00000016030c7836ULL, 0x000fca0000000000ULL, 0xffffffe0070c7812ULL, 0x000fc800078ee20cULL,
0x000000040c0c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000e0834723cULL, 0x000fea0000001834ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x000000100838723cULL, 0x000fec0000001838ULL,
0x000000120848723cULL, 0x000fe20000001848ULL, 0x000000001b08783bULL, 0x000ea80000000200ULL,
0x000000001a10783bULL, 0x000f680000000200ULL, 0x000000001818783bULL, 0x008ee20000000200ULL,
0x000000010d0c7890ULL, 0x000fe2000fffe03fULL, 0x00000000060882caULL, 0x000fe200000e0000ULL,
0x00000000005c7919ULL, 0x000ea40000000000ULL, 0x000000070c00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fe20003f0f018ULL, 0xffffffff00187882ULL, 0x000fc60000000000ULL,
0x0000000800188c82ULL, 0x000fe40008000000ULL, 0x0000000a181972a4ULL, 0x000fe2000f8e023fULL,
0x000000140c30723cULL, 0x002fec0000001830ULL, 0x000000160c34723cULL, 0x000fec0000001834ULL,
0x000000080c40723cULL, 0x004fec0000001840ULL, 0x0000000a0c44723cULL, 0x000fec0000001844ULL,
0x000000100c28723cULL, 0x020fec0000001828ULL, 0x000000120c3c723cULL, 0x000fec000000183cULL,
0x000000180c38723cULL, 0x008fec0000001838ULL, 0x0000001a0c48723cULL, 0x000fe20000001848ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000800308947ULL, 0x000fde0003800000ULL,
0x0000001967097c10ULL, 0x010fe2000ff3e0ffULL, 0x00000000002c7919ULL, 0x000e620000000000ULL,
0x00000019660b7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000150d087291ULL, 0x000fe2000f8e403fULL,
0x0000001968077c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x000000160b0a7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x00000019650c7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000001607067c11ULL, 0x000fe2000f8048ffULL, 0x000000081300728cULL, 0x000fe2000bf01070ULL,
0x000000170b0b7c11ULL, 0x000fe200088f4c0eULL, 0x000000ffff0d7224ULL, 0x000fe200018e06ffULL,
0x0000001707077c11ULL, 0x000fe200080f4c08ULL, 0x00000008130c7287ULL, 0x000fe2000c000000ULL,
0x00000019630e7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000001609087c11ULL, 0x040fe2000f8048ffULL,
0x0000000c080c7290ULL, 0x000fe2000fffe13fULL, 0x000000160c207c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000001709097c11ULL, 0x000fe400080f4c10ULL,
0x00000019640f7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000160e1f7c11ULL, 0x000fe4000f8248ffULL,
0x000000170c0c7c11ULL, 0x000fe200090f4c0dULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x000000170e0e7c11ULL, 0x000fc400088f4c13ULL, 0x0000001960137c10ULL, 0x000fe4000ff3e0ffULL,
0x0000001962107c10ULL, 0x000fe4000ff5e0ffULL, 0x000000160f217c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x0000001613147c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000170f0f7c11ULL, 0x000fe400080f4c12ULL,
0x0000001961127c10ULL, 0x000fc4000ff1e0ffULL, 0x00000016100d7c11ULL, 0x040fe4000f8448ffULL,
0x0000001713137c11ULL, 0x000fe200088f4c18ULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x0000001710107c11ULL, 0x000fe400090f4c11ULL, 0x000000195d197c10ULL, 0x000fe4000ff3e0ffULL,
0x000000195f157c10ULL, 0x000fe4000ff5e0ffULL, 0x00000016121e7c11ULL, 0x040fe2000f8048ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00000003ff2d7819ULL, 0x002fe2000001162cULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x0000001712127c11ULL, 0x000fc400080f4c17ULL,
0x000000195e187c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001619177c11ULL, 0x000fe4000f8248ffULL,
0x0000001615117c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e06ffULL,
0x0000001719197c11ULL, 0x000fe400088f4c1aULL, 0x0000001715157c11ULL, 0x000fe400090f4c16ULL,
0x00000019761a7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000001618167c11ULL, 0x040fe4000f8048ffULL,
0x0000001974247c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff237224ULL, 0x000fe200008e06ffULL,
0x0000001718187c11ULL, 0x000fe400080f4c1bULL, 0x000000197c1b7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff257224ULL, 0x000fe200010e06ffULL, 0x000000161a1c7c11ULL, 0x040fe4000f8248ffULL,
0x00000019722c7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000ffff227224ULL, 0x000fe200000e06ffULL,
0x000000171a1a7c11ULL, 0x000fe200088f4c23ULL, 0x000000105c237824ULL, 0x000fe200078e00ffULL,
0x000000161b1d7c11ULL, 0x000fc4000f8048ffULL, 0x0000000c52007c0cULL, 0x000fe4000bf26070ULL,
0x000000171b1b7c11ULL, 0x000fe400080f4c22ULL, 0x0000007023237812ULL, 0x000fe400078ec0ffULL,
0x0000001624227c11ULL, 0x040fe4000f8448ffULL, 0x0000000623067210ULL, 0x000fe40007f9e0ffULL,
0x0000001724247c11ULL, 0x000fc400090f4c25ULL, 0x0000000c2d007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff077224ULL, 0x000fe200020e0607ULL, 0x0000000c53007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff2d7224ULL, 0x000fe200028e06ffULL, 0x0000000823087210ULL, 0x000fe40007f9e0ffULL,
0x0000000a230a7210ULL, 0x000fe40007fbe0ffULL, 0x0000000c51007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x0000000c50007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff0b7224ULL, 0x000fe200028e060bULL, 0x0000000c27007c0cULL, 0x000fe2000bfa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000065b7faeULL, 0x0003e2000d101c4eULL,
0x000000162c257c11ULL, 0x000fc6000f8c48ffULL, 0x00000000084f7faeULL, 0x0005e2000c101c4eULL,
0x000000172c2c7c11ULL, 0x000fe4000b0f4c2dULL, 0x0000001623167210ULL, 0x000fe20007fde0ffULL,
0x000000000a4e7faeULL, 0x0007e2000c901c4eULL, 0x0000002023067210ULL, 0x002fe40007f1e0ffULL,
0x0000002123087210ULL, 0x004fc60007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e060cULL,
0x0000000c26007c0cULL, 0x000fe4000bf06070ULL, 0x0000001f230a7210ULL, 0x008fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e060fULL, 0x00000000064d7faeULL, 0x0003e2000d901c4eULL,
0x0000000c05007c0cULL, 0x000fe4000bf26070ULL, 0x000000ffff0b7224ULL, 0x000fe200010e060eULL,
0x0000000c04007c0cULL, 0x000fe2000bf46070ULL, 0x00000000084c7faeULL, 0x0005e2000e101c4eULL,
0x0000000d23047210ULL, 0x000fc60007f9e0ffULL, 0x000000000a2f7faeULL, 0x000fe4000e901c4eULL,
0x000000ffff057224ULL, 0x000fe200020e0610ULL, 0x0000001e23067210ULL, 0x002fe40007fbe0ffULL,
0x0000000c59007c0cULL, 0x000fe4000bf86070ULL, 0x00000000042e7faeULL, 0x0003e2000c101c4eULL,
0x0000001423087210ULL, 0x004fe20007f7e0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0612ULL,
0x0000000c58007c0cULL, 0x000fc6000bfa6070ULL, 0x000000ffff097224ULL, 0x000fe200018e0613ULL,
0x0000000c57007c0cULL, 0x000fe2000bf66070ULL, 0x00000000067d7faeULL, 0x0005e2000c901c4eULL,
0x0000000c56007c0cULL, 0x000fe4000bf26070ULL, 0x0000001123047210ULL, 0x002fe20007f1e0ffULL,
0x00000000087b7faeULL, 0x0003e8000d101c4eULL, 0x000000ffff057224ULL, 0x000fe200000e0615ULL,
0x0000000c55007c0cULL, 0x000fc4000bf06070ULL, 0x0000001723067210ULL, 0x004fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0618ULL, 0x00000000047a7faeULL, 0x0005e6000e101c4eULL,
0x000000ffff077224ULL, 0x000fe200010e0619ULL, 0x0000000016797faeULL, 0x0005e2000e901c4eULL,
0x0000001d23087210ULL, 0x002fe40007f9e0ffULL, 0x0000001c231c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000006787faeULL, 0x0005e2000d901c4eULL, 0x0000000c54007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff097224ULL, 0x000fe200020e061bULL, 0x0000000c5a007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff1d7224ULL, 0x000fe200028e061aULL, 0x0000002223227210ULL, 0x000fc40007f9e0ffULL,
0x00000025230a7210ULL, 0x000fe20007fbe0ffULL, 0x0000000008777faeULL, 0x0005e4000c901c4eULL,
0x000000ffff237224ULL, 0x000fe400020e0624ULL, 0x000000ffff0b7224ULL, 0x000fe200028e062cULL,
0x000000001c757faeULL, 0x0005e8000c101c4eULL, 0x0000000022737faeULL, 0x0005e8000d101c4eULL,
0x000000000a707faeULL, 0x0005e2000d901c4eULL, 0x0000000400d47947ULL, 0x000fea0003800000ULL,
0x0000001968057c10ULL, 0x010fe2000ff1e0ffULL, 0x000000105c257824ULL, 0x000fe200078e00ffULL,
0x0000001966097c10ULL, 0x000fe4000ff5e0ffULL, 0x00000019650b7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000001967077c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x0000001605047c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x000000160b0a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x0000001705057c11ULL, 0x000fc400080f4c06ULL,
0x00000019640d7c10ULL, 0x000fe4000ff9e0ffULL, 0x0000001609087c11ULL, 0x000fe4000f8248ffULL,
0x0000001607067c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x000000170b0b7c11ULL, 0x000fe400090f4c12ULL, 0x0000001961137c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001709097c11ULL, 0x000fc400088f4c10ULL, 0x0000001707077c11ULL, 0x000fe200080f4c0eULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x0000001962117c10ULL, 0x000fe4000ff3e0ffULL,
0x000000160d0c7c11ULL, 0x000fe4000f8648ffULL, 0x00000019630f7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x0000001613127c11ULL, 0x000fe4000f8448ffULL,
0x000000170d0d7c11ULL, 0x000fe200098f4c14ULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000001960157c10ULL, 0x000fc4000ff7e0ffULL, 0x0000001611107c11ULL, 0x000fe4000f8248ffULL,
0x000000160f0e7c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x0000001713137c11ULL, 0x000fe400090f4c1aULL, 0x000000195d1b7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001711117c11ULL, 0x000fe400088f4c18ULL, 0x000000170f0f7c11ULL, 0x000fe200080f4c16ULL,
0x000000ffff227224ULL, 0x000fe200010e06ffULL, 0x000000195e197c10ULL, 0x000fc4000ff3e0ffULL,
0x0000001615147c11ULL, 0x000fe4000f8648ffULL, 0x000000195f177c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff207224ULL, 0x000fe200008e06ffULL, 0x000000161b1a7c11ULL, 0x000fe4000f8448ffULL,
0x0000001715157c11ULL, 0x000fe200098f4c1cULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x000000197c1d7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001619187c11ULL, 0x000fc4000f8248ffULL,
0x0000001617167c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x000000171b1b7c11ULL, 0x000fe400090f4c22ULL, 0x0000001972237c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001719197c11ULL, 0x000fe400088f4c20ULL, 0x0000001717177c11ULL, 0x000fe200080f4c1eULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x0000001974217c10ULL, 0x000fc4000ff3e0ffULL,
0x000000161d1c7c11ULL, 0x000fe4000f8648ffULL, 0x00000019761f7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff267224ULL, 0x000fe200008e06ffULL, 0x0000001623227c11ULL, 0x000fe4000f8448ffULL,
0x000000171d1d7c11ULL, 0x000fe200098f4c24ULL, 0x000000ffff247224ULL, 0x000fe200000e06ffULL,
0x0000007025257812ULL, 0x000fe400078ec0ffULL, 0x0000001621207c11ULL, 0x000fc4000f8248ffULL,
0x000000161f1e7c11ULL, 0x000fe4000f8048ffULL, 0x0000001723237c11ULL, 0x000fe400090f4c2cULL,
0x0000000425047210ULL, 0x000fe40007f5e0ffULL, 0x0000001721217c11ULL, 0x000fe400088f4c26ULL,
0x0000000625067210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x000000171f1f7c11ULL, 0x000fc400080f4c24ULL, 0x0000000825087210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000000a250a7210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000045b7faeULL, 0x0003e2000b901c4eULL,
0x0000000c250c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000000e250e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000001025107210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0x0000001225127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e060fULL,
0x0000001425147210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0611ULL,
0x0000001625167210ULL, 0x000fe20007f1e0ffULL, 0x00000000064f7faeULL, 0x0003e2000b901c4eULL,
0x0000001825187210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000001a251a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000084e7faeULL, 0x0003e2000b901c4eULL,
0x0000001c251c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000001e251e7210ULL, 0x000fe20007f5e0ffULL, 0x000000000a4d7faeULL, 0x0003e2000b901c4eULL,
0x0000002025207210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000002225227210ULL, 0x000fe20007f1e0ffULL, 0x000000000c4c7faeULL, 0x0003e2000b901c4eULL,
0x000000ffff197224ULL, 0x000fc400028e0619ULL, 0x000000ffff1b7224ULL, 0x000fe200020e061bULL,
0x000000000e2f7faeULL, 0x0003e2000b901c4eULL, 0x000000ffff1d7224ULL, 0x000fe400018e061dULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x00000000102e7faeULL, 0x0003e2000b901c4eULL,
0x000000ffff217224ULL, 0x000fe400008e0621ULL, 0x000000ffff237224ULL, 0x000fe200000e0623ULL,
0x00000000127d7faeULL, 0x0003e8000b901c4eULL, 0x00000000147b7faeULL, 0x0003e8000b901c4eULL,
0x00000000167a7faeULL, 0x0003e8000b901c4eULL, 0x0000000018797faeULL, 0x0003e8000b901c4eULL,
0x000000001a787faeULL, 0x0003e8000b901c4eULL, 0x000000001c777faeULL, 0x0003e8000b901c4eULL,
0x000000001e757faeULL, 0x0003e8000b901c4eULL, 0x0000000020737faeULL, 0x0003e8000b901c4eULL,
0x0000000022707faeULL, 0x0003e4000b901c4eULL, 0x0000980001067983ULL, 0x006ea80000300800ULL,
0x00009400010c7983ULL, 0x000ee80000300800ULL, 0x0000900001107983ULL, 0x000f280000300800ULL,
0x0000800001167983ULL, 0x000f680000300800ULL, 0x00007c0001197983ULL, 0x000f680000300800ULL,
0x0000780001207983ULL, 0x000f680000300800ULL, 0x0000740001237983ULL, 0x000f680000300800ULL,
0x00006c0001227983ULL, 0x000f680000300800ULL, 0x0000500001217983ULL, 0x000f620000300800ULL,
0x0000001803047836ULL, 0x000fc40000000000ULL, 0x0000002002057824ULL, 0x000fe200078e00ffULL,
0x00004c00012c7983ULL, 0x000f680000300800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe005047812ULL, 0x000fc800078ee204ULL, 0x0000000404047c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001a03147836ULL, 0x000fe20000000000ULL,
0x000000007170783bULL, 0x000fe20000000200ULL, 0x0000002002157824ULL, 0x000fc600078e00ffULL,
0x000000006968783bULL, 0x000fe40000000200ULL, 0xffffffe015187812ULL, 0x000fc800078ee214ULL,
0x00000004181c7c11ULL, 0x000fcc000f8e20ffULL, 0x000000001c1c783bULL, 0x000fe20000000200ULL,
0x0000000411087291ULL, 0x000fc6000f8e183fULL, 0x000000000608783bULL, 0x004fe80000000200ULL,
0x000000000404783bULL, 0x000e680000000200ULL, 0x000000000c0c783bULL, 0x008ea80000000200ULL,
0x000000001010783bULL, 0x010ee80000000200ULL, 0x000000001614783bULL, 0x020f280000000200ULL,
0x000000001918783bULL, 0x000f620000000200ULL, 0x000000080440723cULL, 0x002fec0000001840ULL,
0x0000000c0428723cULL, 0x004fee0000001828ULL, 0x0000001c030c7836ULL, 0x000fc40000000000ULL,
0x00000020020d7824ULL, 0x000fe200078e00ffULL, 0x0000000a0444723cULL, 0x000fe20000001844ULL,
0x000000002008783bULL, 0x0002aa0000000200ULL, 0x0000000e043c723cULL, 0x000fe2000000183cULL,
0xffffffe00d207812ULL, 0x002fca00078ee20cULL, 0x000000100430723cULL, 0x008fe20000001830ULL,
0x00000000230c783bULL, 0x000e6a0000000200ULL, 0x000000120434723cULL, 0x000fe20000001834ULL,
0x000000002210783bULL, 0x000ee20000000200ULL, 0x0000000420247c11ULL, 0x000fc8000f8e20ffULL,
0x000000140438723cULL, 0x010fe20000001838ULL, 0x000000002120783bULL, 0x000fe80000000200ULL,
0x000000002424783bULL, 0x000f220000000200ULL, 0x000000160448723cULL, 0x000fe60000001848ULL,
0x000000002c04783bULL, 0x000ee80000000200ULL, 0x000000006f14783bULL, 0x000ee20000000200ULL,
0x0000001e03037836ULL, 0x000fc40000000000ULL, 0x0000002002027824ULL, 0x000fe200078e00ffULL,
0x000000181c40723cULL, 0x020fe80000001840ULL, 0xffffffe002037812ULL, 0x000fe400078ee203ULL,
0x0000001a1c44723cULL, 0x000fe40000001844ULL, 0x0000000403037c11ULL, 0x000fe2000f8e20ffULL,
0x000000006e18783bULL, 0x000fe60000000200ULL, 0x000000081c28723cULL, 0x004fec0000001828ULL,
0x0000000a1c3c723cULL, 0x000fe2000000183cULL, 0x000000000308783bULL, 0x000eaa0000000200ULL,
0x0000000c1c30723cULL, 0x002fec0000001830ULL, 0x0000000e1c34723cULL, 0x000fe20000001834ULL,
0x000000006c0c783bULL, 0x000fea0000000200ULL, 0x000000101c38723cULL, 0x008fec0000001838ULL,
0x000000121c48723cULL, 0x000fe20000001848ULL, 0x000000006d10783bULL, 0x000e6a0000000200ULL,
0x000000202440723cULL, 0x010fec0000001840ULL, 0x000000222444723cULL, 0x000fec0000001844ULL,
0x000000042428723cULL, 0x000fec0000001828ULL, 0x00000006243c723cULL, 0x000fec000000183cULL,
0x000000702430723cULL, 0x000fec0000001830ULL, 0x000000722434723cULL, 0x000fec0000001834ULL,
0x000000142404723cULL, 0x000fec0000001838ULL, 0x000000162448723cULL, 0x000fec0000001848ULL,
0x000000180840723cULL, 0x004fec0000001840ULL, 0x0000001a0844723cULL, 0x000fec0000001844ULL,
0x000000100818723cULL, 0x002fec0000001828ULL, 0x000000120814723cULL, 0x000fe2000000183cULL,
0x00000001ff2a7424ULL, 0x000fca00078e00ffULL, 0x0000000c0810723cULL, 0x000fe20000001830ULL,
0x01c6882aff2a79a7ULL, 0x000e6a0008500008ULL, 0x0000000e080c723cULL, 0x000fec0000001834ULL,
0x000000680804723cULL, 0x000fec0000001804ULL, 0x0000006a0808723cULL, 0x000fe20000001848ULL,
0x3d80000019217820ULL, 0x000fe20000410000ULL, 0x3d80000014257820ULL, 0x000fe20000410000ULL,
0x3d80000018227820ULL, 0x000fe20000410000ULL, 0x3d80000015207820ULL, 0x000fc40000410000ULL,
0x3d80000010247820ULL, 0x000fe20000410000ULL, 0x3d800000111f7820ULL, 0x000fe20000410000ULL,
0x3d80000040297820ULL, 0x000fe20000410000ULL, 0x3d80000041267820ULL, 0x000fe20000410000ULL,
0x3d800000421c7820ULL, 0x000fe20000410000ULL, 0x3d80000043037820ULL, 0x000fe20000410000ULL,
0x3d8000000c197820ULL, 0x000fe20000410000ULL, 0x3d8000000d147820ULL, 0x000fe20000410000ULL,
0x3d8000000e107820ULL, 0x000fe20000410000ULL, 0x3d8000000f117820ULL, 0x000fe20000410000ULL,
0x3d80000044277820ULL, 0x000fe20000410000ULL, 0x3d80000045237820ULL, 0x000fe20000410000ULL,
0x3d800000461d7820ULL, 0x000fe20000410000ULL, 0x3d800000471e7820ULL, 0x000fe20000410000ULL,
0x3d8000001a1a7820ULL, 0x000fe20000410000ULL, 0x3d8000001b1b7820ULL, 0x000fe20000410000ULL,
0x3d80000016167820ULL, 0x000fe20000410000ULL, 0x3d80000017177820ULL, 0x000fe20000410000ULL,
0x3d80000012127820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fe20000410000ULL,
0x3d80000004187820ULL, 0x000fe20000410000ULL, 0x3d80000005157820ULL, 0x000fe20000410000ULL,
0x3d800000060f7820ULL, 0x000fe20000410000ULL, 0x3d800000070c7820ULL, 0x000fe20000410000ULL,
0x3d80000008087820ULL, 0x000fe20000410000ULL, 0x3d80000009097820ULL, 0x000fe20000410000ULL,
0x3d8000000a0d7820ULL, 0x000fe20000410000ULL, 0x3d8000000b0e7820ULL, 0x000fe20000410000ULL,
0x0000000000047805ULL, 0x000fe20000015200ULL, 0x01c6882bff0075a7ULL, 0x002e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01c6882bff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000317919ULL, 0x000e620000000000ULL, 0xffffffff070c7890ULL, 0x000fe4000fffe03fULL,
0x0000000411087291ULL, 0x000fe4000f8e383fULL, 0x0000000c0500728cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000431027824ULL, 0x002fca00078e00ffULL,
0xfffffff002027812ULL, 0x000fca00078ec0ffULL, 0x01c4000802047984ULL, 0x0002a40008000c00ULL,
0x0000000400080947ULL, 0x000fea0003800000ULL, 0x00000002310a7824ULL, 0x000fe200078e00ffULL,
0x8000001213127290ULL, 0x000fc8000fffe03fULL, 0x000000060a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000010a0b7812ULL, 0x040fe400078efcffULL, 0x000000080a287812ULL, 0x040fe400078efcffULL,
0x000000120b007c0cULL, 0x000fe4000bf26070ULL, 0x000000100a0b7812ULL, 0x000fe400078efcffULL,
0x0000001228007c0cULL, 0x000fe4000bf06070ULL, 0x000000120b007c0cULL, 0x000fc4000bfc6070ULL,
0x000000110a287812ULL, 0x040fe400078efcffULL, 0x000000180a0b7812ULL, 0x040fe400078efcffULL,
0x000000120a007c0cULL, 0x000fe4000bf46070ULL, 0x0000001228007c0cULL, 0x000fe4000bfa6070ULL,
0x000000120b007c0cULL, 0x000fe4000bf66070ULL, 0x000000090a2a7812ULL, 0x000fc400078efcffULL,
0x000000190a287812ULL, 0x040fe400078efcffULL, 0x000000200a0b7812ULL, 0x000fe400078efcffULL,
0xff8000001c1c7808ULL, 0x000fe40005000000ULL, 0xff80000029297808ULL, 0x000fe40005000000ULL,
0xff80000003037808ULL, 0x000fe40004800000ULL, 0xff80000026267808ULL, 0x000fc40004800000ULL,
0x000000122a007c0cULL, 0x000fe4000bf86070ULL, 0x0000001228007c0cULL, 0x000fe4000bf46070ULL,
0x000000120b007c0cULL, 0x000fe4000bf26070ULL, 0x000000210a287812ULL, 0x040fe400078efcffULL,
0x000000280a0b7812ULL, 0x000fe400078efcffULL, 0xff8000001d1d7808ULL, 0x000fc40004000000ULL,
0xff80000027277808ULL, 0x000fe40004000000ULL, 0xff8000001e1e7808ULL, 0x000fe40006000000ULL,
0xff80000023237808ULL, 0x000fe40006000000ULL, 0x0000001228007c0cULL, 0x000fe4000bf06070ULL,
0x000000120b007c0cULL, 0x000fe4000bf86070ULL, 0x000000290a287812ULL, 0x000fc400078efcffULL,
0x000000300a0b7812ULL, 0x000fe400078efcffULL, 0xff8000001a1a7808ULL, 0x000fe40007000000ULL,
0xff80000022227808ULL, 0x000fe40007000000ULL, 0xff8000001b1b7808ULL, 0x000fe40006800000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0x0000001228007c0cULL, 0x000fc4000bfc6070ULL,
0x000000120b007c0cULL, 0x000fe4000bfa6070ULL, 0x000000310a287812ULL, 0x040fe400078efcffULL,
0x000000380a0b7812ULL, 0x040fe400078efcffULL, 0x000000390a0a7812ULL, 0x000fe400078efcffULL,
0xff80000016167808ULL, 0x000fe40005800000ULL, 0xff80000025257808ULL, 0x000fc40005800000ULL,
0xff80000017177808ULL, 0x000fe40005000000ULL, 0xff80000020207808ULL, 0x000fe40005000000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0xff80000024247808ULL, 0x000fe40004800000ULL,
0x0000001228007c0cULL, 0x000fe4000bf66070ULL, 0x000000120b007c0cULL, 0x000fc4000bf46070ULL,
0x000000120a007c0cULL, 0x000fe4000bf26070ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004000000ULL, 0xff80000010107808ULL, 0x000fe40006000000ULL,
0xff80000019197808ULL, 0x000fe40006000000ULL, 0xff80000011117808ULL, 0x000fc40007000000ULL,
0xff80000014147808ULL, 0x000fe40007000000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0xff80000018187808ULL, 0x000fe40006800000ULL, 0xff8000000c0c7808ULL, 0x000fe40005800000ULL,
0xff80000015157808ULL, 0x000fe40005800000ULL, 0xff8000000d0d7808ULL, 0x000fc40005000000ULL,
0xff80000008087808ULL, 0x000fe40005000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004800000ULL,
0xff80000009097808ULL, 0x000fce0004800000ULL, 0x000000290400720bULL, 0x004fe20003f1e000ULL,
0x0000000000327919ULL, 0x000ea20000000000ULL, 0x0000000411057291ULL, 0x000fe4000f8e583fULL,
0x00000004290b7208ULL, 0x000fe20004000000ULL, 0x000000070d00728cULL, 0x000fe4000bf06070ULL,
0x0001200005057890ULL, 0x000fe2000fffe03fULL, 0x000000260b00720bULL, 0x000fe20003f1e000ULL,
0x00000004110c7291ULL, 0x000fc6000f8e283fULL, 0x0000000b26047208ULL, 0x000fc80004000000ULL,
0x000000270400720bULL, 0x000fc80003f1e000ULL, 0x0000000427047208ULL, 0x000fc80004000000ULL,
0x000000230400720bULL, 0x000fc80003f1e000ULL, 0x00000004230b7208ULL, 0x000fc80004000000ULL,
0x000000220b00720bULL, 0x000fe40003f1e000ULL, 0x00000003ff327819ULL, 0x004fe40000011632ULL,
0x0000000b22047208ULL, 0x000fc80004000000ULL, 0x000000210400720bULL, 0x000fc80003f1e000ULL,
0x0000000421047208ULL, 0x000fc80004000000ULL, 0x000000250400720bULL, 0x000fc80003f1e000ULL,
0x00000004250b7208ULL, 0x000fc80004000000ULL, 0x000000200b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b200b7208ULL, 0x000fc80004000000ULL, 0x000000240b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b24047208ULL, 0x000fc80004000000ULL, 0x0000001f0400720bULL, 0x000fc80003f1e000ULL,
0x000000041f047208ULL, 0x000fc80004000000ULL, 0x000000190400720bULL, 0x000fc80003f1e000ULL,
0x00000004190b7208ULL, 0x000fe40004000000ULL, 0x0000001c0500720bULL, 0x000fe40003f1e000ULL,
0x000000140b00720bULL, 0x000fe40003f3e000ULL, 0x000000051c047208ULL, 0x000fe40004000000ULL,
0x0000000b140b7208ULL, 0x000fe40004800000ULL, 0x000000030400720bULL, 0x000fc40003f1e000ULL,
0x000000180b00720bULL, 0x000fe40003f3e000ULL, 0x0000000403047208ULL, 0x000fe40004000000ULL,
0x0000000b180a7208ULL, 0x000fe40004800000ULL, 0x0000001d0400720bULL, 0x000fe40003f1e000ULL,
0x000000150a00720bULL, 0x000fe40003f3e000ULL, 0x000000041d057208ULL, 0x000fc40004000000ULL,
0x0000000a150b7208ULL, 0x000fe40004800000ULL, 0x0000001e0500720bULL, 0x000fe40003f1e000ULL,
0x000000080b00720bULL, 0x000fe40003f3e000ULL, 0x000000051e057208ULL, 0x000fe40004000000ULL,
0x0000000b08047208ULL, 0x000fe40004800000ULL, 0x0000001a0500720bULL, 0x000fc40003f1e000ULL,
0x000000090400720bULL, 0x000fc80003f3e000ULL, 0x00000004090a7208ULL, 0x000fe40004800000ULL,
0x000000051a047208ULL, 0x000fc60004000000ULL, 0x0c401f000a0b7f89ULL, 0x000ea200000e0000ULL,
0x0000001b0400720bULL, 0x000fc80003f1e000ULL, 0x000000041b057208ULL, 0x000fc80004000000ULL,
0x000000160500720bULL, 0x000fc80003f1e000ULL, 0x0000000516047208ULL, 0x000fc80004000000ULL,
0x000000170400720bULL, 0x000fc80003f1e000ULL, 0x0000000417057208ULL, 0x000fe40004000000ULL,
0x0000000b0a00720bULL, 0x004fe40003f3e000ULL, 0x000000120500720bULL, 0x000fe40003f1e000ULL,
0x0000000a0b0b7208ULL, 0x000fe40004800000ULL, 0x0000000512047208ULL, 0x000fc60004000000ULL,
0x0c201f000b287f89ULL, 0x000ea200000e0000ULL, 0x000000130400720bULL, 0x000fc80003f1e000ULL,
0x0000000413057208ULL, 0x000fc80004000000ULL, 0x000000100500720bULL, 0x000fc80003f1e000ULL,
0x0000000510047208ULL, 0x000fc80004000000ULL, 0x000000110400720bULL, 0x000fc80003f1e000ULL,
0x00000004110a7208ULL, 0x000fe40004000000ULL, 0x000000280b00720bULL, 0x004fe40003f3e000ULL,
0x0000000f0a00720bULL, 0x000fe40003f1e000ULL, 0x0000000b28047208ULL, 0x000fe40004800000ULL,
0x0000000a0f057208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b04287820ULL, 0x000fe20000410000ULL,
0x0000000c0500720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010828ULL,
0x000000050c0a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010828ULL,
0x0000000d0a00720bULL, 0x000fe20003f1e000ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010828ULL,
0x0000000a0d057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010828ULL,
0x0000000e0500720bULL, 0x000fe20003f1e000ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010828ULL,
0x000000050e057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010828ULL, 0x0c401f00050a7f89ULL, 0x000ee200000e0000ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b15157823ULL, 0x000fce0000010828ULL,
0x00000023002a7308ULL, 0x000f300000000800ULL, 0x0000001900237308ULL, 0x000be20000000800ULL,
0x0000000a0500720bULL, 0x008fce0003f1e000ULL, 0x00000018002b7308ULL, 0x0007e20000000800ULL,
0x3c003c00ff197424ULL, 0x022fe200078e00ffULL, 0x000000050a057208ULL, 0x000fca0004000000ULL,
0x0c201f00050a7f89ULL, 0x000e6200000e0000ULL, 0x00000008002d7308ULL, 0x0005e20000000800ULL,
0x3c003c00ff187424ULL, 0x008fce00078e00ffULL, 0x0000000900287308ULL, 0x000fe20000000800ULL,
0x000000292608723eULL, 0x004fce00000000ffULL, 0x00000014002c7308ULL, 0x000fe20000000800ULL,
0x0000000a0500720bULL, 0x002fce0003f1e000ULL, 0x00000015002e7308ULL, 0x000fe20000000800ULL,
0x000000050a057208ULL, 0x000fe40004000000ULL, 0x000000272a0a723eULL, 0x010fc600000000ffULL,
0x3fb8aa3b052f7820ULL, 0x000fe40000410000ULL, 0x0000002200227308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b03037823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082fULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b17267823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b11277823ULL, 0x000fca000001082fULL,
0x0000000300037308ULL, 0x000e700000000800ULL, 0x0000001d000b7308ULL, 0x0005e20000000800ULL,
0x0000001c0309723eULL, 0x002fce00000000ffULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b121c7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b131d7823ULL, 0x004fcc000001082fULL,
0x0000001600307308ULL, 0x0005e20000000800ULL, 0x0000000b1e0b723eULL, 0x002fce00000000ffULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x3fb8aa3b101e7823ULL, 0x000fe2000001082fULL,
0x000000180814723cULL, 0x004fec00000018ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x000000222110723eULL, 0x002fce00000000ffULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x3fb8aa3b0d217823ULL, 0x000fce000001082fULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000252012723eULL, 0x002fce00000000ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b0c207823ULL, 0x000fce000001082fULL, 0x0000002600037308ULL, 0x0004e20000000800ULL,
0x0000001a1b11723eULL, 0x002fce00000000ffULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0c401f00071a7f89ULL, 0x000e6200000e0000ULL, 0x3fb8aa3b0f1b7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b0e2f7823ULL, 0x000fe2000001082fULL, 0x000000232c0e723eULL, 0x000fe200000000ffULL,
0x000000ffff267224ULL, 0x004fe200078e0010ULL, 0x0000000332237812ULL, 0x000fe400078ec0ffULL,
0x000000300313723eULL, 0x008fe200000000ffULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x0c401f0006037f89ULL, 0x000ee200000e0000ULL, 0x000000ffff297224ULL, 0x000fc800078e000eULL,
0x000000181014723cULL, 0x000fe40000001814ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x000000241f0c723eULL, 0x004fce00000000ffULL, 0x0000001d001d7308ULL, 0x000ea20000000800ULL,
0x0000001a0700720bULL, 0x002fe20003f3e000ULL, 0x000000ffff247224ULL, 0x000fe400078e0008ULL,
0x000000ffff087224ULL, 0x000fe200078e0009ULL, 0x000000071a077208ULL, 0x000fe20004800000ULL,
0x000000ffff097224ULL, 0x000fe200078e000bULL, 0xfffffff8ff1a7812ULL, 0x000fe200078ee200ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x000000030600720bULL, 0x008fe20003f1e000ULL,
0x0c201f0007007f89ULL, 0x000e6200000e0000ULL, 0x000000ffff0b7224ULL, 0x000fc400078e0013ULL,
0x0000000603067208ULL, 0x000fe20004000000ULL, 0x000000081a257824ULL, 0x000fe200078e00ffULL,
0x0000001c1d0d723eULL, 0x004fe200000000ffULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x0000002b2e1c723eULL, 0x000fe200000000ffULL, 0x0c201f0006037f89ULL, 0x000ee800000e0000ULL,
0x000000ffff2a7224ULL, 0x000fe400078e001cULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x0000001e270f723eULL, 0x004fce00000000ffULL, 0x0000002000207308ULL, 0x000ea20000000800ULL,
0x0000002d281e723eULL, 0x000fe200000000ffULL, 0x000000ffff277224ULL, 0x000fe200078e0012ULL,
0x000000000700720bULL, 0x002fe20003f3e000ULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x000000180c14723cULL, 0x000fe20000001814ULL, 0x000000ffff2b7224ULL, 0x000fe400078e001eULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x0000000700077208ULL, 0x000fe20004800000ULL,
0x00000001ff007424ULL, 0x000fe200078e00ffULL, 0x000000030600720bULL, 0x008fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000dULL, 0x0000001b201d723eULL, 0x004fc600000000ffULL,
0x0000002f00227308ULL, 0x000e620000000800ULL, 0x00000001231b7824ULL, 0x000fe200078e021aULL,
0x0000000603067208ULL, 0x000fe20004000000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e000fULL,
0x0000000331ff7812ULL, 0x000fe2000780c0ffULL, 0x000000041b207836ULL, 0x000fe40000000000ULL,
0x000000ffff0e7224ULL, 0x000fc600078e001dULL, 0xfffffff825207812ULL, 0x000fe200078ee220ULL,
0x000000ffff257224ULL, 0x000fe400078e000aULL, 0x000000ffff0a7224ULL, 0x000fe200078e0011ULL,
0x0000000520207c11ULL, 0x000fe4000f8e20ffULL, 0x00000021221f723eULL, 0x002fe200000000ffULL,
0x000000081a217836ULL, 0x000fe40000000000ULL, 0x000000081a1a7824ULL, 0x000fe400078e00ffULL,
0x0000000123227824ULL, 0x000fc400078e0221ULL, 0x000000181c14723cULL, 0x000fe20000001814ULL,
0x0000000821237824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee21bULL,
0x0000000c1b1b7836ULL, 0x000fc60000000000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e001fULL,
0xfffffff823227812ULL, 0x000fe200078ee222ULL, 0x0000000821187824ULL, 0x000fe200078e00ffULL,
0x000000051a1a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000522227c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff8181b7812ULL, 0x000fe200078ee21bULL, 0x000000241a007844ULL, 0x0003e60000000200ULL,
0x000000051b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002820007844ULL, 0x0003e20000000200ULL,
0x0000000d00057c82ULL, 0x000fc60008000000ULL, 0x0000000822007844ULL, 0x0003e40000000200ULL,
0x000000ffff157224ULL, 0x000fe400078e0016ULL, 0x0000000c1b007844ULL, 0x0003e80000000200ULL,
0x01c0000402008988ULL, 0x0003e80008000c08ULL, 0x01c2001402008988ULL, 0x0003e20008000a08ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x01c60800ffff79a7ULL, 0x0003e2000850000cULL,
0x01c61000ffff79a7ULL, 0x0003e2000850000cULL, 0x01c61800ffff79a7ULL, 0x0003e2000850000cULL,
0x01c62000ffff79a7ULL, 0x0003f2000850000cULL, 0xffffff7c00188947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000002007836ULL, 0x000fe20000000000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x7f80000000037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000200008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff02ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000002037812ULL, 0x000fd600078ec0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000200007308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffffe6804e87950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x00000000000004c5ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000640ULL,
0x0000000000000210ULL, 0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000850ULL,
0x00000000000000d0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000920ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000974ULL,
0x00000000000004acULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e20ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e20ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e68ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL,
0x0000000000019500ULL, 0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a380ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a3c0ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000001a3c0ULL,
0x0000000000000260ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x000000000001a9a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x000000000001a9a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e68ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019500ULL, 0x0000000000019500ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001a380ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x000000000001a3c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000260ULL,
0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 109296;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
