/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b350ULL, 0x000000000001afd0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x00000000000190a0ULL, 0x0000000000000180ULL,
0x000b0022000004bdULL, 0x0000000000019220ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x0000000000019260ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x00000000000192a0ULL,
0x0000000000000160ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000019400ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000190a000000000ULL, 0x0000040400000000ULL,
0x810c0000015c0400ULL, 0x0062c00400288080ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808508288080ULL, 0x8092082880809008ULL,
0x0828808096082880ULL, 0x80809a0828808099ULL, 0x9d082880809b0828ULL, 0x2880809e08288080ULL,
0x80a0082880809f08ULL, 0x08288080a2082880ULL, 0x8080c108288080c0ULL, 0xc308288080c20828ULL,
0x288080c508288080ULL, 0x80c708288080c608ULL, 0x08288080ca082880ULL, 0x8080cd08288080ccULL,
0x8408288080d20828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808084920000ULL,
0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x000190a000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x000000b4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808f08288080ULL, 0x8096082880809208ULL, 0x0828808099082880ULL, 0x80809b082880809aULL,
0x9e082880809d0828ULL, 0x288080a108288080ULL, 0x80c008288080a208ULL, 0x08288080c1082880ULL,
0x8080c308288080c2ULL, 0xc508288080c40828ULL, 0x288080c608288080ULL, 0x80ca08288080c708ULL,
0x08288080cd082880ULL, 0x80809008288080d2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809092ULL, 0x0000001cffffffffULL, 0x0000018000000000ULL, 0x0001922000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000bcffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808508288080ULL, 0x8092082880809008ULL, 0x0828808096082880ULL,
0x80809a0828808099ULL, 0x9d082880809b0828ULL, 0x2880809e08288080ULL, 0x80a208288080a108ULL,
0x08288080c0082880ULL, 0x8080c208288080c1ULL, 0xc408288080c30828ULL, 0x288080c508288080ULL,
0x80c708288080c608ULL, 0x08288080cc082880ULL, 0x8080d208288080cdULL, 0x8016288080ca0828ULL,
0x0000000310288082ULL, 0x80ca920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x0000026800000000ULL, 0x0001926000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000b4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808508288080ULL,
0x8092082880809008ULL, 0x0828808096082880ULL, 0x80809a0828808099ULL, 0x9d082880809b0828ULL,
0x2880809e08288080ULL, 0x80a208288080a108ULL, 0x08288080c0082880ULL, 0x8080c208288080c1ULL,
0xc408288080c30828ULL, 0x288080c508288080ULL, 0x80ca08288080c608ULL, 0x08288080cd082880ULL,
0x8080c708288080d2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080c792ULL,
0x0000002cffffffffULL, 0x0000035800000000ULL, 0x000192a000000000ULL, 0x0000016000000000ULL,
0x0000140400000000ULL, 0x80c2288080c70900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL,
0x0008230400000087ULL, 0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL,
0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL,
0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL,
0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0048016000000017ULL, 0x000c170400481903ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01982904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01982804ffffffffULL, 0x00000120000000f0ULL, 0x00001c7000000470ULL,
0x00001df000001d00ULL, 0x000023b000001f60ULL, 0x00002450000023e0ULL, 0x00004170000024c0ULL,
0x00004210000041a0ULL, 0x00005f2000004280ULL, 0x000060c000005fb0ULL, 0x0000669000006220ULL,
0x00006730000066c0ULL, 0x00008220000067a0ULL, 0x000082c000008250ULL, 0x00009e9000008330ULL,
0x0000a02000009f10ULL, 0x0000a5f00000a180ULL, 0x0000a6900000a620ULL, 0x0000c1800000a700ULL,
0x0000c2200000c1b0ULL, 0x0000ddf00000c290ULL, 0x0000df800000de70ULL, 0x0000e5500000e0e0ULL,
0x0000e5f00000e580ULL, 0x000101200000e660ULL, 0x000101c000010150ULL, 0x0001131000010230ULL,
0x00011af000011320ULL, 0x000171b000017170ULL, 0x000171d0000171c0ULL, 0x0001724000017220ULL,
0x0001727000017260ULL, 0x00017f1000017eb0ULL, 0x0001801000017f90ULL, 0x0001811000018090ULL,
0x0001820000018190ULL, 0x000182c000018260ULL, 0x000183a000018330ULL, 0x0001849000018420ULL,
0x0001858000018510ULL, 0x00018640000185e0ULL, 0x00018720000186b0ULL, 0x00018810000187a0ULL,
0x0001890000018890ULL, 0x000189c000018960ULL, 0x00018aa000018a30ULL, 0x00018b9000018b20ULL,
0x00018c8000018c10ULL, 0x00018d8000018d00ULL, 0x00018e8000018e00ULL, 0x00018f8000018f00ULL,
0x0001908000019000ULL, 0x0000021006003904ULL, 0x00018600000000ffULL, 0x00000260003f0100ULL,
0x000186080000000fULL, 0x00000320003f0120ULL, 0x000186880000000fULL, 0x00000410003f0120ULL,
0x000186a80000000fULL, 0x00000440003f0120ULL, 0x000186b8000000ffULL, 0x00000500003f0100ULL,
0x00018600000000ffULL, 0x00000600003f0107ULL, 0x0001868c0000000bULL, 0x00000690003f0102ULL,
0x000186880000000bULL, 0x00000d10003f0101ULL, 0x000186a8000000ffULL, 0x00000e30003f0107ULL,
0x000186a8000000ffULL, 0x00000e90003f0101ULL, 0x000186b8000000ffULL, 0x00000fc0003f0101ULL,
0x000186bc000000ffULL, 0x00001190003f0105ULL, 0x000186bc000000ffULL, 0x000018c0003f0105ULL,
0x000186b0000000ffULL, 0x00001940003f0107ULL, 0x000186b0000000ffULL, 0x000019a0003f0101ULL,
0x000186080000000bULL, 0x000019c0003f0101ULL, 0x0001860c0000000bULL, 0x00001b90003f0105ULL,
0x0001860c0000000bULL, 0x00002110003f0105ULL, 0x000186ac000000ffULL, 0x000022e0003f0105ULL,
0x000186ac000000ffULL, 0x00003570003f0105ULL, 0x000186b8000000ffULL, 0x000035a0003f0101ULL,
0x000186bc000000ffULL, 0x00003760003f0105ULL, 0x000186bc000000ffULL, 0x00003e40003f0105ULL,
0x000186a8000000ffULL, 0x00003ec0003f0107ULL, 0x000186a8000000ffULL, 0x00003ef0003f0101ULL,
0x000186b4000000ffULL, 0x000040c0003f0105ULL, 0x000186b4000000ffULL, 0x00005240003f0105ULL,
0x000186b8000000ffULL, 0x000052b0003f0101ULL, 0x00018688000000ffULL, 0x00005310003f0101ULL,
0x000186bc000000ffULL, 0x000054e0003f0105ULL, 0x000186bc000000ffULL, 0x00005bc0003f0105ULL,
0x000186b0000000ffULL, 0x00005c40003f0107ULL, 0x000186b0000000ffULL, 0x00005ca0003f0101ULL,
0x000186280000000bULL, 0x00005cc0003f0101ULL, 0x0001862c0000000bULL, 0x00005e90003f0105ULL,
0x0001862c0000000bULL, 0x000063f0003f0105ULL, 0x000186ac000000ffULL, 0x000065c0003f0105ULL,
0x000186ac000000ffULL, 0x00007620003f0105ULL, 0x000186b8000000ffULL, 0x00007650003f0101ULL,
0x000186bc000000ffULL, 0x00007810003f0105ULL, 0x000186bc000000ffULL, 0x00007ef0003f0105ULL,
0x000186a8000000ffULL, 0x00007f70003f0107ULL, 0x000186a8000000ffULL, 0x00007fa0003f0101ULL,
0x000186b4000000ffULL, 0x00008170003f0105ULL, 0x000186b4000000ffULL, 0x000091c0003f0105ULL,
0x000186b8000000ffULL, 0x00009230003f0101ULL, 0x00018690000000ffULL, 0x00009280003f0101ULL,
0x000186bc000000ffULL, 0x00009450003f0105ULL, 0x000186bc000000ffULL, 0x00009b30003f0105ULL,
0x000186b0000000ffULL, 0x00009bb0003f0107ULL, 0x000186b0000000ffULL, 0x00009c10003f0101ULL,
0x000186480000000bULL, 0x00009c30003f0101ULL, 0x0001864c0000000bULL, 0x00009e00003f0105ULL,
0x0001864c0000000bULL, 0x0000a350003f0105ULL, 0x000186ac000000ffULL, 0x0000a520003f0105ULL,
0x000186ac000000ffULL, 0x0000b580003f0105ULL, 0x000186b8000000ffULL, 0x0000b5b0003f0101ULL,
0x000186bc000000ffULL, 0x0000b770003f0105ULL, 0x000186bc000000ffULL, 0x0000be50003f0105ULL,
0x000186a8000000ffULL, 0x0000bed0003f0107ULL, 0x000186a8000000ffULL, 0x0000bf00003f0101ULL,
0x000186b4000000ffULL, 0x0000c0d0003f0105ULL, 0x000186b4000000ffULL, 0x0000d120003f0105ULL,
0x000186b8000000ffULL, 0x0000d190003f0101ULL, 0x00018698000000ffULL, 0x0000d1e0003f0101ULL,
0x000186bc000000ffULL, 0x0000d3b0003f0105ULL, 0x000186bc000000ffULL, 0x0000da90003f0105ULL,
0x000186b0000000ffULL, 0x0000db10003f0107ULL, 0x000186b0000000ffULL, 0x0000db70003f0101ULL,
0x000186680000000bULL, 0x0000db90003f0101ULL, 0x0001866c0000000bULL, 0x0000dd60003f0105ULL,
0x0001866c0000000bULL, 0x0000e2b0003f0105ULL, 0x000186ac000000ffULL, 0x0000e480003f0105ULL,
0x000186ac000000ffULL, 0x0000f500003f0105ULL, 0x000186b8000000ffULL, 0x0000f530003f0101ULL,
0x000186bc000000ffULL, 0x0000f6f0003f0105ULL, 0x000186bc000000ffULL, 0x0000fdf0003f0105ULL,
0x000186a8000000ffULL, 0x0000fe70003f0107ULL, 0x000186a8000000ffULL, 0x0000fea0003f0101ULL,
0x000186b4000000ffULL, 0x00010070003f0105ULL, 0x000186b4000000ffULL, 0x000110f0003f0105ULL,
0x000186b8000000ffULL, 0x00011150003f0101ULL, 0x000186a0000000ffULL, 0x00011ce0003f0101ULL,
0x00018600000000ffULL, 0x00013330003f0101ULL, 0x00018604000000ffULL, 0x00013500003f0105ULL,
0x00018604000000ffULL, 0x00013870003f0105ULL, 0x00018600000000ffULL, 0x000138a0003f0101ULL,
0x00018604000000ffULL, 0x00013a60003f0105ULL, 0x00018604000000ffULL, 0x00016590003f0105ULL,
0x0000000000000009ULL, 0x000166c0003f0101ULL, 0x0000000400000009ULL, 0x00016890003f0105ULL,
0x0000000400000009ULL, 0x00017d00003f0105ULL, 0x000000000000000eULL, 0x00017d60003f0101ULL,
0x000000080000000eULL, 0x00017dc0003f0101ULL, 0x000000100000000eULL, 0x00017e30003f0101ULL,
0x000000180000000eULL, 0x00053803003f0101ULL, 0x00011c3000101c04ULL, 0x00013b7000013ac0ULL,
0x0000040100017e70ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000042cULL, 0x0000001a00000002ULL,
0x0000000000000344ULL, 0x0000001a00000002ULL, 0x0000000000000254ULL, 0x0000001a00000002ULL,
0x0000000000000154ULL, 0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL,
0x0000000000000408ULL, 0x0000001a00000002ULL, 0x000000000000031dULL, 0x0000001a00000002ULL,
0x0000000000000230ULL, 0x0000001a00000002ULL, 0x000000000000012aULL, 0x0000001a00000002ULL,
0x0000000000018700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001300077300ULL, 0x000fe200000e0000ULL, 0x0000000805057824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000ee80000002200ULL, 0x00000000000e7919ULL, 0x000f220000000000ULL,
0x0000001300137309ULL, 0x000ea60000000000ULL, 0x0000000000147919ULL, 0x000f280000002600ULL,
0x0000000000087919ULL, 0x000f220000000000ULL, 0x00000005ff0d7819ULL, 0x002fc6000001160fULL,
0x0000000000127919ULL, 0x000e680000002700ULL, 0x00001fff03007589ULL, 0x0045e200000e0000ULL,
0x000000ffff157224ULL, 0x000fe400078e0a13ULL, 0x0000010003027a24ULL, 0x008fe200078e0202ULL,
0x00001fff0d0d7589ULL, 0x000ee600000e0000ULL, 0x00000000020f7a24ULL, 0x000fc400078e020fULL,
0x000000100e107824ULL, 0x010fe400078e00ffULL, 0x0000000814047824ULL, 0x000fe200078e00ffULL,
0x000000ff0f00720cULL, 0x040fe40003f25270ULL, 0x0000000f0f00780cULL, 0x040fe40003f44070ULL,
0x0000007f0f00780cULL, 0x040fe40003f84070ULL, 0x000000030f00780cULL, 0x000fe40003f64070ULL,
0x000000080700720cULL, 0x000fe20003f02070ULL, 0x0000001205087224ULL, 0x002fe200078e0204ULL,
0x000001f010117812ULL, 0x000fc600078ec0ffULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x004fe400078e00ffULL, 0x0000000400067824ULL, 0x008fe400078e020dULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x01860002ff009388ULL, 0x0003e20000000a00ULL,
0x0000000206097824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05a424ULL, 0x000fc400078e00ffULL,
0x00000001090a7824ULL, 0x040fe400078e020eULL, 0x00000020090b7824ULL, 0x000fe200078e00ffULL,
0x018608040f00a388ULL, 0x0005e20000008a00ULL, 0x000000010f00780cULL, 0x000fe20003f44070ULL,
0x0000000108027824ULL, 0x002fe400078e0209ULL, 0xffffffe00b0c7812ULL, 0x000fe200078ee20aULL,
0xff317217ff16c424ULL, 0x000fe200078e00ffULL, 0x00000008090a7817ULL, 0x000fe20007800000ULL,
0x3fffff60ff06b424ULL, 0x000fc400078e00ffULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x018400160f00c388ULL, 0x0003e20000004800ULL, 0x000000010a0a7824ULL, 0x000fe200078e0a09ULL,
0x0000000109097810ULL, 0x000fe20007ffe0ffULL, 0x00000200ff0b7424ULL, 0x000fe200078e00ffULL,
0x018688060f00b388ULL, 0x0007e40000008a00ULL, 0x000000ff0a00720cULL, 0x000fe20003f63070ULL,
0x0000000108047824ULL, 0x004fe200078e0209ULL, 0x000000010a00780cULL, 0x000fe20003f83070ULL,
0x00005c0002027625ULL, 0x000fc800078e000bULL, 0x0000002009167824ULL, 0x002fe400078e00ffULL,
0x00005c0004047625ULL, 0x000fe200078e000bULL, 0x0000001102067210ULL, 0x008fc60007fbe0ffULL,
0x0000000109077824ULL, 0x000fe200078e020eULL, 0x0000001104047210ULL, 0x000fe20007fde0ffULL,
0x3fffff00ff08a424ULL, 0x000fe400078e00ffULL, 0x7fffff00ff09a424ULL, 0x000fe200078e00ffULL,
0xffffffe016027812ULL, 0x000fe200078ee207ULL, 0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x0186a8080f00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff077224ULL, 0x000fc400028e0603ULL, 0x000000100c117824ULL, 0x000fe200078e00ffULL,
0x0186b80aff009388ULL, 0x000fe20000000a00ULL, 0x000000ffff057224ULL, 0x000fe400030e0605ULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff087224ULL, 0x000fe200078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x00000004ff037424ULL, 0x000fc600078e00ffULL,
0x0000000004137faeULL, 0x0003e2000e101c46ULL, 0x0000600012027625ULL, 0x000fc600078e0003ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01860408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01860000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006020c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fc40003f05270ULL,
0x000000ff0c007810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff0a7819ULL, 0x000fce0000011600ULL,
0x0001167000008947ULL, 0x000fea0003800000ULL, 0x000000080d0b7824ULL, 0x000fe400078e00ffULL,
0x00000003ff027424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01868c020bff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000000212097824ULL, 0x000fe200078e00ffULL,
0x0000580014007a10ULL, 0x000fe20007ffe0ffULL, 0x018688000bff7f8cULL, 0x0007e8000c80043fULL,
0x0000580009097a24ULL, 0x000fcc00078e0200ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0000000b0c007217ULL, 0x008fe40007800000ULL, 0x00000004ff027819ULL, 0x004fe4000001160eULL,
0x000000f010157812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x0000000202047810ULL, 0x042fe20007ffe0ffULL, 0x000000010b037824ULL, 0x000fe200078e0202ULL,
0x0000000402057810ULL, 0x040fe40007ffe0ffULL, 0x000000000200720cULL, 0x0c0fe20003f66070ULL,
0x0000001003117824ULL, 0x040fe200078e00ffULL, 0x00000006020f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103027824ULL, 0x000fe200078e020eULL, 0x000000000400720cULL, 0x080fe20003f46070ULL,
0x000000010b047824ULL, 0x000fe200078e0204ULL, 0x000000000500720cULL, 0x080fe20003f26070ULL,
0x000000010b067824ULL, 0x000fe200078e0205ULL, 0x000000000f00720cULL, 0x000fe20003f06070ULL,
0x0000620009037a24ULL, 0x000fe200078e0203ULL, 0xfffffff011007812ULL, 0x000fe200078ee202ULL,
0x00000100ff117424ULL, 0x000fc400078e00ffULL, 0x0000000104057824ULL, 0x140fe400078e020eULL,
0x0000001004087824ULL, 0x000fe400078e00ffULL, 0x000000010b0f7824ULL, 0x000fe400078e020fULL,
0x0000000106077824ULL, 0x000fe200078e020eULL, 0xfffffff008087812ULL, 0x000fe200078ee205ULL,
0x0000001006127824ULL, 0x000fe400078e00ffULL, 0x00005e0003027625ULL, 0x000fc600078e0011ULL,
0xfffffff012127812ULL, 0x000fe200078ee207ULL, 0x0000620009047a24ULL, 0x040fe200078e0204ULL,
0x0000001502027210ULL, 0x000fe20007fbe0ffULL, 0x0000620009067a24ULL, 0x040fe400078e0206ULL,
0x0000620009107a24ULL, 0x000fe400078e020fULL, 0x00005e0004047625ULL, 0x000fc800078e0011ULL,
0x00005e0006067625ULL, 0x000fe200078e0011ULL, 0x0000001504047210ULL, 0x000fc60007f9e0ffULL,
0x00005e0010107625ULL, 0x000fc800078e0011ULL, 0x000000010f137824ULL, 0x040fe200078e020eULL,
0x0000001510107210ULL, 0x080fe20007fde0ffULL, 0x000000100f147824ULL, 0x000fe200078e00ffULL,
0x00014000000f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x0000001506067210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0xfffffff014147812ULL, 0x000fe200078ee213ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0001400008137811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0001400012157811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0003e2000d901c46ULL, 0x0001400014177811ULL, 0x000fc600078e20ffULL,
0x0000000004137faeULL, 0x0003e8000d101c46ULL, 0x0000000006157faeULL, 0x0003e8000c901c46ULL,
0x0000000010177faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000b0e007211ULL, 0x008fe400078fe0ffULL, 0x000000f010137812ULL, 0x002fc400078ec0ffULL,
0x0000000400057810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x144fe200078e020eULL,
0x0000000200037810ULL, 0x040fe20007ffe0ffULL, 0x0000001000077824ULL, 0x000fe400078e00ffULL,
0x0000000105067824ULL, 0x040fe400078e020eULL, 0x0000001005117824ULL, 0x000fe200078e00ffULL,
0xfffffff007087812ULL, 0x000fe200078ee202ULL, 0x0000000103047824ULL, 0x040fe400078e020eULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0xfffffff011147812ULL, 0x000fe200078ee206ULL,
0x00000100ff117424ULL, 0x000fc400078e00ffULL, 0x0000620009027a24ULL, 0x000fe200078e0200ULL,
0xfffffff00f127812ULL, 0x000fe200078ee204ULL, 0x0000620009047a24ULL, 0x000fe200078e0203ULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0011ULL,
0x0001400014157811ULL, 0x000fc600078e20ffULL, 0x0000620009067a24ULL, 0x040fe200078e0205ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x0000620009107a24ULL, 0x000fe400078e0200ULL,
0x00005e0004047625ULL, 0x000fc800078e0011ULL, 0x00005e0006067625ULL, 0x000fe200078e0011ULL,
0x0000001304047210ULL, 0x000fc60007f3e0ffULL, 0x00000001000f7824ULL, 0x000fe400078e020eULL,
0x00005e0010107625ULL, 0x000fc800078e0011ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x0000001310107210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000001306067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0xfffffff000007812ULL, 0x000fe200078ee20fULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x00014000080f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0001400012137811ULL, 0x000fe400078e20ffULL, 0x0001400000177811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020f7faeULL, 0x0003e8000b901c46ULL,
0x0000000004137faeULL, 0x0003e8000b901c46ULL, 0x0000000006157faeULL, 0x0003e8000b901c46ULL,
0x0000000010177faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff147f8cULL, 0x002e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b800ff027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0001027000008947ULL, 0x000fea0003800000ULL,
0x000000ffff447224ULL, 0x004fe400078e0003ULL, 0xff317217ff1e7424ULL, 0x000fc400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff3f7224ULL, 0x000fc400078e00ffULL,
0x0000010007057824ULL, 0x000fca00078e00ffULL, 0x0000000c0500720cULL, 0x000fda0003f06070ULL,
0x000101c000000947ULL, 0x002fea0003800000ULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x0186bc00ff057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210057210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e11ULL, 0x003d09000500780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400500780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011412ULL,
0x0000000500007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0612ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x004fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000107057810ULL, 0x040fe40007ffe0ffULL, 0x0000002007067811ULL, 0x000fe400078e40ffULL,
0x0000000a0500720cULL, 0x000fc60003f26070ULL, 0x00006200090f7a24ULL, 0x000fd400078e0206ULL,
0x000003b000009947ULL, 0x000fea0003800000ULL, 0x000000060c057217ULL, 0x000fe40007800000ULL,
0x00000004ff107819ULL, 0x000fc6000001160eULL, 0x0000000105007824ULL, 0x000fe200078e0a06ULL,
0x0000000210127810ULL, 0x040fe20007ffe0ffULL, 0x000000010b057824ULL, 0x040fe200078e0210ULL,
0x0000000610187810ULL, 0x000fe40007ffe0ffULL, 0x000000000b007217ULL, 0x040fe20007800000ULL,
0x000000010b137824ULL, 0x000fe400078e0212ULL, 0x0000000105117824ULL, 0x040fe400078e020eULL,
0x0000001005147824ULL, 0x002fc400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a0bULL,
0x0000000113167824ULL, 0x040fe200078e020eULL, 0xfffffff014147812ULL, 0x000fe200078ee211ULL,
0x0000001013177824ULL, 0x000fe200078e00ffULL, 0x000000001200720cULL, 0x080fe20003f66070ULL,
0x000000100e117824ULL, 0x000fe200078e00ffULL, 0x0000000410127810ULL, 0x040fe20007ffe0ffULL,
0x000000010b1c7824ULL, 0x000fe200078e0218ULL, 0xfffffff0171a7812ULL, 0x000fe200078ee216ULL,
0x00000100ff177424ULL, 0x000fe200078e00ffULL, 0x000000001000720cULL, 0x080fe20003f86070ULL,
0x0000000105107824ULL, 0x000fe200078e020fULL, 0x000000f011057812ULL, 0x000fe200078ec0ffULL,
0x000000010b167824ULL, 0x000fe200078e0212ULL, 0x000000001200720cULL, 0x080fe20003f46070ULL,
0x00005e0010107625ULL, 0x000fe200078e0017ULL, 0x000000001800720cULL, 0x000fc60003f06070ULL,
0x0000000113127824ULL, 0x000fe200078e020fULL, 0x0000000510187210ULL, 0x000fe20007fbe0ffULL,
0x0000000116197824ULL, 0x040fe400078e020eULL, 0x0000001016407824ULL, 0x000fe400078e00ffULL,
0x00005e0012127625ULL, 0x000fc600078e0017ULL, 0xfffffff0401b7812ULL, 0x000fe200078ee219ULL,
0x0000000116007824ULL, 0x100fe400078e020fULL, 0x000000011c167824ULL, 0x000fe200078e020fULL,
0x000160001b1b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff197224ULL, 0x000fe200028e0611ULL,
0x0000000512127210ULL, 0x000fe20007fbe0ffULL, 0x00005e0000107625ULL, 0x000fc800078e0017ULL,
0x00005e0016167625ULL, 0x000fc800078e0017ULL, 0x000000011c007824ULL, 0x000fe200078e020eULL,
0x0000000516167210ULL, 0x080fe20007fde0ffULL, 0x000000101c0f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x0000000510107210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0xfffffff00f007812ULL, 0x000fe400078ee200ULL,
0x0001600014057811ULL, 0x000fe200078e20ffULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x000160001a0f7811ULL, 0x000fc400078e20ffULL, 0x00016000001d7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018057faeULL, 0x0003e8000e101c46ULL,
0x00000000120f7faeULL, 0x0003e8000d901c46ULL, 0x00000000101b7faeULL, 0x0003e8000d101c46ULL,
0x00000000161d7faeULL, 0x0003e2000c101c46ULL, 0x000002e000007947ULL, 0x000fea0003800000ULL,
0x0000000b0e007211ULL, 0x000fe200078fe0ffULL, 0x00000100ff197424ULL, 0x000fc600078e00ffULL,
0x0000000200127810ULL, 0x040fe20007ffe0ffULL, 0x0000000100057824ULL, 0x140fe200078e020eULL,
0x0000000400167810ULL, 0x040fe20007ffe0ffULL, 0x0000001000147824ULL, 0x002fe400078e00ffULL,
0x0000000112107824ULL, 0x140fe400078e020eULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0xfffffff014147812ULL, 0x000fe200078ee205ULL, 0x0000000116117824ULL, 0x040fe400078e020eULL,
0x0000001016187824ULL, 0x000fe200078e00ffULL, 0xfffffff0131a7812ULL, 0x000fe200078ee210ULL,
0x000000100e057824ULL, 0x000fc400078e00ffULL, 0x0000000100107824ULL, 0x140fe200078e020fULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x0000000112127824ULL, 0x000fe200078e020fULL,
0xfffffff0181b7812ULL, 0x000fe200078ee211ULL, 0x00005e0010107625ULL, 0x000fe200078e0019ULL,
0x000000f005057812ULL, 0x000fe400078ec0ffULL, 0x000160001b1b7811ULL, 0x000fe200078e20ffULL,
0x0000000116167824ULL, 0x100fe200078e020fULL, 0x0000000510107210ULL, 0x000fe20007f1e0ffULL,
0x0000000100187824ULL, 0x000fc400078e020fULL, 0x00005e0012127625ULL, 0x000fc800078e0019ULL,
0x00005e0016167625ULL, 0x000fe200078e0019ULL, 0x0000000512127210ULL, 0x000fc60007f5e0ffULL,
0x00000001000f7824ULL, 0x000fe400078e020eULL, 0x00005e0018187625ULL, 0x000fc800078e0019ULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x0000000518187210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000000516167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0xfffffff0001d7812ULL, 0x000fe200078ee20fULL,
0x000000ffff197224ULL, 0x000fe200018e0619ULL, 0x0001600014057811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x000160001a0f7811ULL, 0x000fe400078e20ffULL,
0x000160001d1d7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010057faeULL, 0x0003e8000b901c46ULL, 0x00000000120f7faeULL, 0x0003e8000b901c46ULL,
0x00000000161b7faeULL, 0x0003e8000b901c46ULL, 0x00000000181d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff447f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018608000b167f8cULL, 0x0022e4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x01860c000b057984ULL, 0x000f240000000800ULL, 0x8000000005ff7812ULL, 0x018fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210057210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e11ULL, 0x003d09000500780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400500780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011412ULL,
0x0000000500007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0612ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01860c000b057984ULL, 0x000ee40000000800ULL,
0x8000000005ff7812ULL, 0x008fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100e057824ULL, 0x000fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc8000001160eULL,
0x0000000c000f7812ULL, 0x000fe400078ec0ffULL, 0x0000007005167812ULL, 0x000fca00078ec0ffULL,
0x0000000116167824ULL, 0x000fca00078e020fULL, 0x01800000160f7984ULL, 0x000ee80000000800ULL,
0x0182000016117984ULL, 0x0002a20000000800ULL, 0x0000001e0f00720bULL, 0x008fe20003f1d000ULL,
0x000162127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x002fc800000e0100ULL,
0x0000ffff00137812ULL, 0x000fe2000780c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x00000001ff007424ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x000fd200078e001eULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x0000001e0f00720bULL, 0x000fe20003f54000ULL, 0x000161e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x000fc400010e0100ULL, 0x0000000f1e1d7209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x0000991010127816ULL, 0x000fc600000000ffULL,
0x0184001d16008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000001d1e127221ULL, 0x002fe20000010000ULL,
0x000000ff10ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL, 0x0000001200177308ULL, 0x0002ec0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff127819ULL, 0x002fe2000001160eULL,
0x000161527f007947ULL, 0x000fea000b800000ULL, 0x00001f1217127589ULL, 0x0082e400000e0000ULL,
0x0000001220207220ULL, 0x088fe40000410000ULL, 0x0000001221217220ULL, 0x080fe40000410000ULL,
0x0000001224247220ULL, 0x000fc40000410000ULL, 0x0000001225257220ULL, 0x080fe40000410000ULL,
0x0000001228287220ULL, 0x080fe40000410000ULL, 0x0000001229297220ULL, 0x080fe40000410000ULL,
0x000000122c2c7220ULL, 0x080fe40000410000ULL, 0x000000122d2d7220ULL, 0x080fe40000410000ULL,
0x0000001230307220ULL, 0x000fc40000410000ULL, 0x0000001231317220ULL, 0x080fe40000410000ULL,
0x0000001234347220ULL, 0x080fe40000410000ULL, 0x0000001235357220ULL, 0x080fe40000410000ULL,
0x0000001238387220ULL, 0x080fe40000410000ULL, 0x0000001239397220ULL, 0x080fe40000410000ULL,
0x000000123c3c7220ULL, 0x000fc40000410000ULL, 0x000000123d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0010ff7812ULL, 0x000fe2000780c0ffULL,
0x0000001708087220ULL, 0x008fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080e127811ULL, 0x002fe200078ff0ffULL, 0x000160627f007947ULL, 0x000fea000b800000ULL,
0x00001f1217127589ULL, 0x0002e400000e0000ULL, 0x0000001222227220ULL, 0x088fe40000410000ULL,
0x0000001223237220ULL, 0x080fe40000410000ULL, 0x0000001226267220ULL, 0x080fe40000410000ULL,
0x0000001227277220ULL, 0x080fe40000410000ULL, 0x000000122a2a7220ULL, 0x080fe40000410000ULL,
0x000000122b2b7220ULL, 0x000fc40000410000ULL, 0x000000122e2e7220ULL, 0x080fe40000410000ULL,
0x000000122f2f7220ULL, 0x080fe40000410000ULL, 0x0000001232327220ULL, 0x080fe40000410000ULL,
0x0000001233337220ULL, 0x080fe40000410000ULL, 0x0000001236367220ULL, 0x080fe40000410000ULL,
0x0000001237377220ULL, 0x000fc40000410000ULL, 0x000000123a3a7220ULL, 0x080fe40000410000ULL,
0x000000123b3b7220ULL, 0x080fe40000410000ULL, 0x000000123e3e7220ULL, 0x080fe40000410000ULL,
0x000000123f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff13ff7812ULL, 0x000fda0007806010ULL, 0x8000001d0f0f0221ULL, 0x000fe20000010000ULL,
0x00007610ff000816ULL, 0x000fc60000000000ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00040308ULL, 0x000e640000000800ULL, 0x0000000411110220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000811087221ULL, 0x004fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0186ac00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011413ULL, 0x000000120f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x000000020f0f7819ULL, 0x000fc80000001212ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991000007816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f45270ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000004ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe4000001160eULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x00015c927f007947ULL, 0x000fea000b800000ULL, 0x00001f0f00037589ULL, 0x0002a400000e0000ULL,
0x000000080f027810ULL, 0x000fe20007ffe0ffULL, 0x00015ce27f007947ULL, 0x000fea000b800000ULL,
0x00001f0200027589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100f4d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0000ULL,
0x00002460004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x00016e0000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180f4d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e0000ULL, 0x000024d0004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00016d9000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000080e0f7812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff007819ULL, 0x108fe4000001160eULL, 0x000000070f0f7812ULL, 0x000fe400078ef80eULL,
0x000000020d1b7811ULL, 0x040fe200078e10ffULL, 0x000000040d467824ULL, 0x000fe400078e0200ULL,
0x000000100f117824ULL, 0x040fe400078e00ffULL, 0x000000010f107824ULL, 0x000fc400078e0246ULL,
0x00000001001e7824ULL, 0x000fe400078e021bULL, 0x000000100f157824ULL, 0x000fe200078e00ffULL,
0xfffffff011107812ULL, 0x000fe200078ee210ULL, 0x000000010f147824ULL, 0x000fc600078e021eULL,
0x0001400010177811ULL, 0x000fe400078e20ffULL, 0xfffffff015147812ULL, 0x000fc600078ee214ULL,
0x000000001710783bULL, 0x000e620000004200ULL, 0x0001400014187811ULL, 0x000fca00078e20ffULL,
0x000000001840783bULL, 0x000ee20000004200ULL, 0x00008880111a7816ULL, 0x042fe200000000ffULL,
0x00000100111f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe20000011411ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x0000001a005a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff147819ULL, 0x000fe40000011410ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff517819ULL, 0x000fc40000011412ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000001900617306ULL, 0x0009e20000200c00ULL, 0x00000100131a7824ULL, 0x002fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011413ULL, 0x00000018ff577819ULL, 0x008fe40000011440ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001f005b7306ULL, 0x0003e20000200c00ULL,
0x0000010010197824ULL, 0x010fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011441ULL,
0x00000018ff557819ULL, 0x000fe40000011443ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000001a00687306ULL, 0x0007e20000200c00ULL, 0x000000100f1f7812ULL, 0x002fe400078efcffULL,
0x00000018ff157819ULL, 0x000fe40000011442ULL, 0x0000001b1f547210ULL, 0x000fe20007ffe000ULL,
0x0000000146477824ULL, 0x000fc400078e021fULL, 0x0000001900537306ULL, 0x0003e20000200c00ULL,
0x000000101f1a7824ULL, 0x048fe400078e00ffULL, 0x000000101f1f7824ULL, 0x000fc600078e00ffULL,
0xfffffff01a477812ULL, 0x000fe400078ee247ULL, 0x0000001400527306ULL, 0x0007e20000200c00ULL,
0x0000888013197816ULL, 0x042fe200000000ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0xfffffff01f547812ULL, 0x000fe400078ee254ULL, 0x00008880431f7816ULL, 0x000fe400000000ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000001900657306ULL, 0x0003220000200c00ULL,
0x0000888010147816ULL, 0x048fe200000000ffULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x00014000541a7811ULL, 0x000fc800078e20ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x00000014001c7306ULL, 0x0007e20000200c00ULL, 0x0001400047197811ULL, 0x002fca00078e20ffULL,
0x00000000194c783bULL, 0x004e640000004200ULL, 0x0000001000597306ULL, 0x0004a20000200c00ULL,
0x0000888012147816ULL, 0x008fe400000000ffULL, 0x0000541065657816ULL, 0x010fca0000000068ULL,
0x0000001400637306ULL, 0x0007e20000200c00ULL, 0x0000010012107824ULL, 0x044fe400078e00ffULL,
0x0001000012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000001f00717306ULL, 0x0005e20000200c00ULL, 0x0000010041147824ULL, 0x008fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x0000541059527816ULL, 0x000fe40000000052ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000001000647306ULL, 0x0007220000200c00ULL,
0x000000070e1f7812ULL, 0x004fc800078ec0ffULL, 0x000000081f1f7812ULL, 0x000fc600078ef80eULL,
0x00000014006e7306ULL, 0x0005e20000200c00ULL, 0x0000888040107816ULL, 0x008fe400000000ffULL,
0x00000018ff5f7819ULL, 0x002fca000001144eULL, 0x0000001000697306ULL, 0x0003e20000200c00ULL,
0x0000888042147816ULL, 0x004fe400000000ffULL, 0x00000018ff607819ULL, 0x000fe4000001144fULL,
0x0000541063647816ULL, 0x010fc60000000064ULL, 0x00000014006f7306ULL, 0x0005e20000200c00ULL,
0x0000010042107824ULL, 0x042fe400078e00ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe40000011410ULL, 0x0000001100627306ULL, 0x0002e20000200c00ULL,
0x00000018ff147819ULL, 0x004fe4000001144cULL, 0x00000018ff427819ULL, 0x000fca0000011442ULL,
0x0000001b00707306ULL, 0x0005e20000200c00ULL, 0x0000010040117824ULL, 0x042fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000001400777306ULL, 0x0003e20000200c00ULL, 0x00000018ff1b7819ULL, 0x004fe4000001144dULL,
0x00000018ff407819ULL, 0x000fca0000011440ULL, 0x0000001b007b7306ULL, 0x0005e20000200c00ULL,
0x0000000100147824ULL, 0x002fce00078e021fULL, 0x0000001200667306ULL, 0x0003e20000200c00ULL,
0x000000081f1b7824ULL, 0x004fca00078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe400078ee214ULL,
0x0000001300677306ULL, 0x000fe20000200c00ULL, 0x0000888041127816ULL, 0x042fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x000120001b487811ULL, 0x000fc800078e20ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x00000011006a7306ULL, 0x000fe20000200c00ULL,
0x000000004848783bULL, 0x000e6e0000000200ULL, 0x00000012006b7306ULL, 0x0005f00000200c00ULL,
0x00000040006c7306ULL, 0x0009e20000200c00ULL, 0x000000001a10783bULL, 0x004eae0000004200ULL,
0x00000041006d7306ULL, 0x0007e20000200c00ULL, 0x0000010043407824ULL, 0x010fc400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x000001004c417824ULL, 0x008fe200078e00ffULL,
0x0000004000747306ULL, 0x0007e80000200c00ULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x000000034848a232ULL, 0x002fc60000000000ULL, 0x0000004100787306ULL, 0x0003e20000200c00ULL,
0x000088804c407816ULL, 0x048fe200000000ffULL, 0x000000034a4aa232ULL, 0x000fe20000000000ULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x000000024949a232ULL, 0x080fe40000000000ULL,
0x000000024b4ba232ULL, 0x000fe40000000000ULL, 0x0000004000757306ULL, 0x0007e20000200c00ULL,
0x000001004e417824ULL, 0x002fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc6000001144cULL,
0x000000644828723cULL, 0x000f620000001828ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004300767306ULL, 0x0003e20000200c00ULL, 0x000088804e407816ULL, 0x048fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x004fe40000011410ULL,
0x00000018ff5e7819ULL, 0x000fe40000011411ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x00000040007d7306ULL, 0x0005e20000200c00ULL, 0x000001004d437824ULL, 0x002fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fc40000011412ULL, 0x00000018ff5c7819ULL, 0x000fe40000011413ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000004100807306ULL, 0x0002e20000200c00ULL,
0x000054101c407816ULL, 0x004fe40000000053ULL, 0x0000541062537816ULL, 0x000fe40000000061ULL,
0x00000002141c7810ULL, 0x000fc60007ffe0ffULL, 0x0000004200727306ULL, 0x0005e20000200c00ULL,
0x000054105a417816ULL, 0x002fe2000000005bULL, 0x000000524824723cULL, 0x040bec0000001824ULL,
0x00000043007c7306ULL, 0x0003e20000200c00ULL, 0x000088804d427816ULL, 0x044fe200000000ffULL,
0x000000404820723cULL, 0x000b620000001820ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x0000888011537816ULL, 0x020fc400000000ffULL, 0x000054107d807816ULL, 0x008fe40000000080ULL,
0x0000004200797306ULL, 0x0005e20000200c00ULL, 0x000000081f417824ULL, 0x000fe200078e00ffULL,
0x0000888010407816ULL, 0x040fe200000000ffULL, 0x000001004f437824ULL, 0x002fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0xfffffff8411c7812ULL, 0x000fe200078ee21cULL,
0x000000ffff527224ULL, 0x000fe200078e0040ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000010010417824ULL, 0x000fe200078e00ffULL, 0x000088804f427816ULL, 0x044fe200000000ffULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000120001c407811ULL, 0x000fe200078e20ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011441ULL,
0x0001000010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000004200817306ULL, 0x000fe20000200c00ULL, 0x00000018ff107819ULL, 0x000fce0000011410ULL,
0x0000004300847306ULL, 0x0002b00000200c00ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000000004040783bULL, 0x002e6e0000000200ULL, 0x0000005800587306ULL, 0x000ee20000200c00ULL,
0x0000541081817816ULL, 0x004fce0000000084ULL, 0x0000004c007a7306ULL, 0x0005f00000200c00ULL,
0x0000004d007e7306ULL, 0x0009e20000200c00ULL, 0x00005410664c7816ULL, 0x004fe40000000051ULL,
0x000054106b517816ULL, 0x000fc4000000006eULL, 0x000054106d6d7816ULL, 0x008fe40000000058ULL,
0x000054106f587816ULL, 0x000fe20000000070ULL, 0x0000001500157306ULL, 0x000ea20000200c00ULL,
0x00005410674d7816ULL, 0x010fe40000000050ULL, 0x0000541069507816ULL, 0x000fca000000006aULL,
0x0000004e00827306ULL, 0x000fe20000200c00ULL, 0x000000034040a232ULL, 0x082fe40000000000ULL,
0x000000034242a232ULL, 0x000fe40000000000ULL, 0x000000024141a232ULL, 0x080fe40000000000ULL,
0x000000024343a232ULL, 0x000fe20000000000ULL, 0x0000004f007f7306ULL, 0x0003e20000200c00ULL,
0x0000541072727816ULL, 0x004fca0000000015ULL, 0x000000804028723cULL, 0x000fe40000001828ULL,
0x0000005700577306ULL, 0x000eac0000200c00ULL, 0x0000004c484c723cULL, 0x002be4000000182cULL,
0x0000005500557306ULL, 0x000e6a0000200c00ULL, 0x000000ffff2c7224ULL, 0x020fc400078e0053ULL,
0x00000100112d7824ULL, 0x040fe200078e00ffULL, 0x0000005900627306ULL, 0x0007e20000200c00ULL,
0x000054106c6c7816ULL, 0x004fe20000000057ULL, 0x0001000011117824ULL, 0x000fe400078e00ffULL,
0x00000018ff2d7819ULL, 0x000fc6000001142dULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000002c00637306ULL, 0x0005e20000200c00ULL, 0x0000541071597816ULL, 0x008fe20000000074ULL,
0x0000006c4834723cULL, 0x000f620000001834ULL, 0x0000541076737816ULL, 0x002fca0000000055ULL,
0x0000005200617306ULL, 0x0003e20000200c00ULL, 0x00008880122c7816ULL, 0x044fe200000000ffULL,
0x000000584858723cULL, 0x040be80000001838ULL, 0x000000ffff157224ULL, 0x000fe400078e002cULL,
0x00000100122c7824ULL, 0x040fe200078e00ffULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000000504850723cULL, 0x002b620000001830ULL, 0x0001000012127824ULL, 0x000fc400078e00ffULL,
0x00000018ff387819ULL, 0x020fe4000001142cULL, 0x00008880132c7816ULL, 0x000fe400000000ffULL,
0x0000541075307816ULL, 0x000fe20000000078ULL, 0x00000072483c723cULL, 0x000f62000000183cULL,
0x0000541079317816ULL, 0x000fe2000000007cULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x000fca0000011412ULL, 0x000000304030723cULL, 0x000b640000001820ULL,
0x0000001000107306ULL, 0x000fea0000200c00ULL, 0x000000ffff207224ULL, 0x020fe200078e002cULL,
0x000054107a2c7816ULL, 0x000fe20000000077ULL, 0x0000010013217824ULL, 0x000fe200078e00ffULL,
0x0000001100117306ULL, 0x000e680000200c00ULL, 0x00000018ff217819ULL, 0x000fc80000011421ULL,
0x0000002000497306ULL, 0x0005f00000200c00ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x0001000013207824ULL, 0x004fe200078e00ffULL, 0x0000541011397816ULL, 0x002fc8000000005eULL,
0x00000018ff4b7819ULL, 0x000fe40000011420ULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x0000541061207816ULL, 0x000fce0000000062ULL, 0x0000002d00647306ULL, 0x0005300000200c00ULL,
0x0000001500157306ULL, 0x000fe20000200c00ULL, 0x000054107e2d7816ULL, 0x004fce000000007bULL,
0x0000003800487306ULL, 0x0005220000200c00ULL, 0x0000002c402c723cULL, 0x000b6e0000001824ULL,
0x00000021004a7306ULL, 0x0009220000200c00ULL, 0x0000541010387816ULL, 0x004fe4000000005dULL,
0x0000541082247816ULL, 0x028fc4000000005fULL, 0x000054107f257816ULL, 0x002fc60000000060ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000b620000001834ULL,
0x0000541063217816ULL, 0x010fcc0000000064ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000541015347816ULL, 0x020fe20000000048ULL, 0x000000244024723cULL, 0x000b62000000184cULL,
0x0000541049357816ULL, 0x000fca000000004aULL, 0x0000001200137306ULL, 0x000e640000200c00ULL,
0x000000204020723cULL, 0x040b6c0000001850ULL, 0x0000004b004b7306ULL, 0x000ea40000200c00ULL,
0x000000344034723cULL, 0x000b620000001858ULL, 0x0000541013567816ULL, 0x002fc40000000056ULL,
0x000054104b577816ULL, 0x004fce000000005cULL, 0x000000564040723cULL, 0x000b62000000183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x0186bc00ff137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x006fe4000780483dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002006117810ULL, 0x000fca0007ffe0ffULL,
0x00006200093c7a24ULL, 0x000fe200078e0211ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x000000010b137824ULL, 0x000fe200078e0200ULL, 0x000000110c107217ULL, 0x000fe20007800000ULL,
0x00000100ff3d7424ULL, 0x000fe200078e00ffULL, 0x00000004004c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000113157824ULL, 0x040fe200078e020eULL, 0x00000002004a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001013487824ULL, 0x000fe200078e00ffULL, 0x000000f005497812ULL, 0x000fe200078ec0ffULL,
0x0000000110127824ULL, 0x000fe400078e0a11ULL, 0x000000010b3f7824ULL, 0x000fe200078e024cULL,
0xfffffff048487812ULL, 0x000fe200078ee215ULL, 0x0000000113107824ULL, 0x000fe200078e023cULL,
0x000000120b127217ULL, 0x040fe20007800000ULL, 0x000000010b157824ULL, 0x000fc400078e024aULL,
0x000000013f3e7824ULL, 0x040fe400078e020eULL, 0x000000103f4d7824ULL, 0x000fe400078e00ffULL,
0x00005e0010107625ULL, 0x000fc600078e003dULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee23eULL,
0x0000000115137824ULL, 0x040fe200078e020eULL, 0x00000049103e7210ULL, 0x000fe20007f1e0ffULL,
0x00000010154e7824ULL, 0x000fe200078e00ffULL, 0x000140004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000115107824ULL, 0x100fe400078e023cULL, 0x0000000112157824ULL, 0x000fe200078e0a0bULL,
0xfffffff04e4b7812ULL, 0x000fe200078ee213ULL, 0x000000013f137824ULL, 0x000fe200078e023cULL,
0x00000006004e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e0611ULL,
0x000000154a00720cULL, 0x000fe20003f66070ULL, 0x00005e0010107625ULL, 0x000fe200078e003dULL,
0x000000150000720cULL, 0x000fc40003f86070ULL, 0x000000154c00720cULL, 0x000fe20003f06070ULL,
0x000000010b4f7824ULL, 0x000fe200078e024eULL, 0x0000004910107210ULL, 0x000fe20007fbe0ffULL,
0x00005e0013127625ULL, 0x000fe200078e003dULL, 0x000140004b4b7811ULL, 0x000fc600078e20ffULL,
0x000000014f3c7824ULL, 0x040fe200078e023cULL, 0x0000004912127210ULL, 0x000fe20007fde0ffULL,
0x000000014f4a7824ULL, 0x000fe400078e020eULL, 0x00005e003c3c7625ULL, 0x000fc800078e003dULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x000000154e00720cULL, 0x000fe20003fa6070ULL,
0x000000104f4f7824ULL, 0x000fe200078e00ffULL, 0x0001400048157811ULL, 0x000fe200078e20ffULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x000000493c3c7210ULL, 0x000fe40007fde0ffULL,
0xfffffff04f4a7812ULL, 0x000fe200078ee24aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e157faeULL, 0x0003e4000e101c46ULL, 0x000000ffff3d7224ULL, 0x000fe200030e063dULL,
0x000140004a497811ULL, 0x000fe200078e20ffULL, 0x00000000104b7faeULL, 0x0003e8000d901c46ULL,
0x00000000124d7faeULL, 0x0003e8000c101c46ULL, 0x000000003c497faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x000000010b3d7824ULL, 0x000fe200078e0200ULL,
0x000000f0054b7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff4a7424ULL, 0x000fc400078e00ffULL,
0x000000013d157824ULL, 0x040fe200078e020eULL, 0x000000023d117810ULL, 0x040fe20007ffe0ffULL,
0x000000103d4c7824ULL, 0x040fe200078e00ffULL, 0x000000043d137810ULL, 0x040fe20007ffe0ffULL,
0x000000013d3e7824ULL, 0x040fe200078e023cULL, 0x000000063d3d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111107824ULL, 0x140fe200078e020eULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee215ULL,
0x00000010113f7824ULL, 0x000fe400078e00ffULL, 0x0000000113127824ULL, 0x040fe200078e020eULL,
0x000140004c4d7811ULL, 0x000fe200078e20ffULL, 0x0000001013497824ULL, 0x000fe200078e00ffULL,
0xfffffff03f157812ULL, 0x000fe200078ee210ULL, 0x00005e003e3e7625ULL, 0x000fc600078e004aULL,
0xfffffff049487812ULL, 0x000fe200078ee212ULL, 0x000000013c117824ULL, 0x000fe200078e0211ULL,
0x0000004b3e3e7210ULL, 0x000fe20007f7e0ffULL, 0x000000013c137824ULL, 0x040fe200078e0213ULL,
0x0001400015157811ULL, 0x000fe200078e20ffULL, 0x000000013c3c7824ULL, 0x000fe400078e023dULL,
0x00005e0011107625ULL, 0x000fc800078e004aULL, 0x000000013d497824ULL, 0x040fe200078e020eULL,
0x0000004b10107210ULL, 0x000fe20007f1e0ffULL, 0x000000103d4e7824ULL, 0x000fe400078e00ffULL,
0x00005e0013127625ULL, 0x000fc800078e004aULL, 0x00005e003c3c7625ULL, 0x000fe200078e004aULL,
0xfffffff04e4a7812ULL, 0x000fe400078ee249ULL, 0x0001400048497811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e063fULL, 0x0000004b12127210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000004b3c3c7210ULL, 0x000fe40007f9e0ffULL,
0x000140004a4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff137224ULL, 0x000fe200018e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e4d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff3d7224ULL, 0x000fc600020e063dULL, 0x0000000010157faeULL, 0x0003e8000b901c46ULL,
0x0000000012497faeULL, 0x0003e8000b901c46ULL, 0x000000003c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff107f8cULL, 0x000e64000c80043fULL, 0x000000ffff157224ULL, 0x002fc400078e0011ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0186b400ff137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fc40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012103d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000003d12127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186b400ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000004ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff117819ULL, 0x000fe4000001160eULL, 0x0000541002107816ULL, 0x000fe20000000002ULL,
0x00013fd27f007947ULL, 0x000fea000b800000ULL, 0x00001f1110037589ULL, 0x0002a400000e0000ULL,
0x00000008114d7810ULL, 0x002fe20007ffe0ffULL, 0x000140227f007947ULL, 0x000fea000b800000ULL,
0x00001f4d10027589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010114d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0010ULL,
0x00004220004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0001504000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018114d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e0010ULL, 0x00004290004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00014fd000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0001600047127811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0001600054117811ULL, 0x000fe200078e20ffULL, 0x000000010f467824ULL, 0x040fe400078e0246ULL,
0x000000001248783bULL, 0x000f220000004200ULL, 0x000000100f457824ULL, 0x000fc400078e00ffULL,
0x000000010f1e7824ULL, 0x040fe200078e021eULL, 0x00000000113c783bULL, 0x000fe20000004200ULL,
0x000000100f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff00f0f7812ULL, 0x000fc800078ee21eULL,
0x000160000f0f7811ULL, 0x000fca00078e20ffULL, 0x000000000f4c783bULL, 0x006e620000004200ULL,
0x0000010048107824ULL, 0x050fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011448ULL,
0x0000010049137824ULL, 0x000fe200078e00ffULL, 0x00008880486a7816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x00000018ff5d7819ULL, 0x000fc4000001144bULL, 0x000088804b657816ULL, 0x000fe400000000ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff627819ULL, 0x000fe20000011449ULL,
0x00000010006b7306ULL, 0x0005e20000200c00ULL, 0x00000018ff5c7819ULL, 0x000fe4000001144aULL,
0x00008880496c7816ULL, 0x040fe200000000ffULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x000088804a667816ULL, 0x000fe200000000ffULL, 0x000001004c777824ULL, 0x002fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe2000001144dULL, 0x00000013006f7306ULL, 0x0003e20000200c00ULL,
0x000001004a107824ULL, 0x044fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe2000001144eULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc40000011449ULL,
0x00000018ff677819ULL, 0x000fe40000011410ULL, 0xfffffff045107812ULL, 0x000fe200078ee246ULL,
0x000001004b137824ULL, 0x042fe200078e00ffULL, 0x0000004800697306ULL, 0x000fe20000200c00ULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x0001600010107811ULL, 0x000fe400078e20ffULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x000000001044783bULL, 0x000e620000004200ULL, 0x0000001300687306ULL, 0x0005e20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fc4000001144aULL, 0x00000018ff547819ULL, 0x000fe4000001144fULL,
0x000088804c767816ULL, 0x000fe400000000ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000004b00647306ULL, 0x0009e20000200c00ULL, 0x000001003c137824ULL, 0x044fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001143cULL, 0x000088803c5f7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011413ULL,
0x000001003d137824ULL, 0x000fe200078e00ffULL, 0x00000049006d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff4b7819ULL, 0x010fe2000001144cULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff617819ULL, 0x000fe40000011413ULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000004b00787306ULL, 0x000fe20000200c00ULL,
0x00000018ff5b7819ULL, 0x000fe4000001143dULL, 0x000088803d5e7816ULL, 0x000fe400000000ffULL,
0x00000018ff587819ULL, 0x000fe4000001143eULL, 0x00000018ff597819ULL, 0x000fe2000001143fULL,
0x0000004a00637306ULL, 0x0009e20000200c00ULL, 0x00000018ff137819ULL, 0x002fce0000011444ULL,
0x00000051007a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff487819ULL, 0x000fe40000011445ULL,
0x00000018ff497819ULL, 0x004fe40000011446ULL, 0x00000018ff4a7819ULL, 0x010fe40000011447ULL,
0x0000888046577816ULL, 0x000fe200000000ffULL, 0x0000001300527306ULL, 0x0003e20000200c00ULL,
0x0000888047707816ULL, 0x000fce00000000ffULL, 0x0000004800557306ULL, 0x0005e20000200c00ULL,
0x0000888044137816ULL, 0x002fce00000000ffULL, 0x0000001300507306ULL, 0x0003e20000200c00ULL,
0x0000010044487824ULL, 0x044fe400078e00ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0001000045137824ULL, 0x002fe200078e00ffULL, 0x00000053007e7306ULL, 0x000fe80000200c00ULL,
0x00000018ff4b7819ULL, 0x000fe20000011413ULL, 0x0000010046137824ULL, 0x040fe400078e00ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000004800517306ULL, 0x0002a80000200c00ULL,
0x00000018ff467819ULL, 0x000fc80000011446ULL, 0x0000004400537306ULL, 0x0008e20000200c00ULL,
0x000000081f487824ULL, 0x002fce00078e00ffULL, 0x00000049006e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff447819ULL, 0x010fe40000011413ULL, 0x0000000414137810ULL, 0x000fe40007ffe0ffULL,
0x0000541050507816ULL, 0x004fe40000000051ULL, 0xfffffff848137812ULL, 0x000fe200078ee213ULL,
0x0000004a00747306ULL, 0x0005e20000200c00ULL, 0x0000888045497816ULL, 0x002fe400000000ffULL,
0x0001200013487811ULL, 0x000fc400078e20ffULL, 0x0000000614147810ULL, 0x000fe40007ffe0ffULL,
0x0000541053527816ULL, 0x008fe20000000052ULL, 0x0000005400807306ULL, 0x000fe20000200c00ULL,
0x00000100454a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000004900547306ULL, 0x0003f00000200c00ULL, 0x0000004a00457306ULL, 0x000ea20000200c00ULL,
0x0000010047497824ULL, 0x002fc400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011449ULL, 0x0000004b00567306ULL, 0x0002e20000200c00ULL,
0x00000018ff477819ULL, 0x000fce0000011447ULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x000000004848783bULL, 0x002e620000000200ULL, 0x0000541054517816ULL, 0x004fe20000000045ULL,
0x000000081f457824ULL, 0x000fca00078e00ffULL, 0x0000004400447306ULL, 0x000ea20000200c00ULL,
0xfffffff845147812ULL, 0x000fe400078ee214ULL, 0x0000541056537816ULL, 0x008fca0000000055ULL,
0x0000007000707306ULL, 0x000ff00000200c00ULL, 0x0000007200737306ULL, 0x0007220000200c00ULL,
0x0000541057447816ULL, 0x004fce0000000044ULL, 0x0000004600717306ULL, 0x0005e20000200c00ULL,
0x000088804d727816ULL, 0x008fce00000000ffULL, 0x0000004700757306ULL, 0x0007e20000200c00ULL,
0x000001004d467824ULL, 0x044fe200078e00ffULL, 0x000000034848a232ULL, 0x082fe20000000000ULL,
0x0000541070457816ULL, 0x010fe20000000073ULL, 0x000000034a4aa232ULL, 0x000fe20000000000ULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x000000024949a232ULL, 0x080fe20000000000ULL, 0x0000004c00797306ULL, 0x0002a20000200c00ULL,
0x000001004e477824ULL, 0x008fe200078e00ffULL, 0x000000024b4ba232ULL, 0x000fe20000000000ULL,
0x00000018ff4d7819ULL, 0x000fc6000001144dULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x00000046007b7306ULL, 0x0007e20000200c00ULL, 0x000088804f4c7816ULL, 0x002fe200000000ffULL,
0x000000444828723cULL, 0x040fe80000001828ULL, 0x000000ffff1f7224ULL, 0x000fe200078e004cULL,
0x00012000144c7811ULL, 0x000fe200078e20ffULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x000088804e467816ULL, 0x048fe200000000ffULL, 0x000000504830723cULL, 0x000b620000001830ULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x0000541079787816ULL, 0x004fc80000000078ULL,
0x00000046007c7306ULL, 0x0003e20000200c00ULL, 0x0000541071507816ULL, 0x020fe2000000006eULL,
0x00000052482c723cULL, 0x000f62000000182cULL, 0x0000541075517816ULL, 0x000fca0000000074ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x000001004f467824ULL, 0x042fe200078e00ffULL,
0x000000504850723cULL, 0x000b680000001824ULL, 0x00000018ff547819ULL, 0x000fe40000011446ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x000100004f247824ULL, 0x020fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000047007f7306ULL, 0x0007f00000200c00ULL,
0x0000004d007d7306ULL, 0x0003220000200c00ULL, 0x000000004c44783bULL, 0x0084ee0000000200ULL,
0x0000001f00557306ULL, 0x0009e20000200c00ULL, 0x00005410764c7816ULL, 0x004fc40000000077ULL,
0x00005410724d7816ULL, 0x002fca000000007bULL, 0x0000005400567306ULL, 0x0002a20000200c00ULL,
0x00000018ff1f7819ULL, 0x010fe4000001144eULL, 0x0000004c484c723cULL, 0x000be20000001820ULL,
0x000054107d797816ULL, 0x000fc8000000007aULL, 0x0000002400217306ULL, 0x0208e20000200c00ULL,
0x000054107c547816ULL, 0x002fe2000000007fULL, 0x000100003d207824ULL, 0x000fe200078e00ffULL,
0x000088803e237816ULL, 0x040fe200000000ffULL, 0x000001003e227824ULL, 0x040fe200078e00ffULL,
0x000000784838723cULL, 0x000f620000001838ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541055557816ULL, 0x004fe40000000056ULL, 0x000088803f247816ULL, 0x010fc400000000ffULL,
0x00000018ff3e7819ULL, 0x000fc6000001143eULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x000000544854723cULL, 0x000b620000001834ULL, 0x00005410217f7816ULL, 0x008fe20000000080ULL,
0x000000034444a232ULL, 0x080fe40000000000ULL, 0x000000034646a232ULL, 0x000fe40000000000ULL,
0x000000024545a232ULL, 0x080fe20000000000ULL, 0x0000001f001f7306ULL, 0x000ea20000200c00ULL,
0x000000024747a232ULL, 0x000fe20000000000ULL, 0x00000018ff357819ULL, 0x020fcc0000011422ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x000054106c217816ULL, 0x002fce000000006fULL,
0x0000002000347306ULL, 0x0003e20000200c00ULL, 0x000054101f7e7816ULL, 0x004fe2000000007eULL,
0x000000ffff1f7224ULL, 0x000fe200078e0023ULL, 0x000054106d257816ULL, 0x008fca0000000062ULL,
0x0000003c003d7306ULL, 0x000fe20000200c00ULL, 0x000054106a207816ULL, 0x002fe2000000006bULL,
0x0000007e4840723cULL, 0x000f6c0000001840ULL, 0x0000001f003c7306ULL, 0x0003e40000200c00ULL,
0x000000204420723cULL, 0x000b6c0000001830ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000000ffff307224ULL, 0x020fe200078e0024ULL, 0x0000541069247816ULL, 0x000fe20000000060ULL,
0x000001003f1f7824ULL, 0x002fca00078e00ffULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x000000244424723cULL, 0x000b62000000182cULL, 0x00000018ff1f7819ULL, 0x000fcc000001141fULL,
0x000100003f2c7824ULL, 0x020fe200078e00ffULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x000054103d5a7816ULL, 0x004fc6000000005aULL, 0x00000018ff4a7819ULL, 0x000fe4000001142cULL,
0x00005410345b7816ULL, 0x002fe4000000005bULL, 0x0000006700677306ULL, 0x000e700000200c00ULL,
0x0000005c005c7306ULL, 0x000eb00000200c00ULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x0000541066667816ULL, 0x002fce0000000067ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00005410635c7816ULL, 0x004fce000000005cULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00005410645d7816ULL, 0x008fce000000005dULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x0000005c442c723cULL, 0x000f6e0000001850ULL, 0x0000005f005f7306ULL, 0x000ff00000200c00ULL,
0x0000001e001e7306ULL, 0x000ea20000200c00ULL, 0x0000541065677816ULL, 0x002fce0000000068ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000664428723cULL, 0x000f6e0000001828ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000054105f1e7816ULL, 0x004fce000000001eULL,
0x0000003500497306ULL, 0x0002b00000200c00ULL, 0x0000003000487306ULL, 0x000fe20000200c00ULL,
0x0000005a4434723cULL, 0x002b6e0000001838ULL, 0x0000001f004b7306ULL, 0x0002e20000200c00ULL,
0x000054103c387816ULL, 0x024fce0000000049ULL, 0x0000003e003f7306ULL, 0x000ea20000200c00ULL,
0x000054105e1f7816ULL, 0x002fce0000000061ULL, 0x0000004a004a7306ULL, 0x000e620000200c00ULL,
0x0000541048397816ULL, 0x008fe2000000004bULL, 0x0000001e4430723cULL, 0x000b62000000184cULL,
0x000054103f587816ULL, 0x004fce0000000058ULL, 0x000000384438723cULL, 0x000b620000001854ULL,
0x000054104a597816ULL, 0x002fce0000000059ULL, 0x00000058443c723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff1e7f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000002006417810ULL, 0x000fe20007ffe0ffULL, 0x01868800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff447224ULL, 0x002fe400078e001fULL, 0x0000000c4100720cULL, 0x000fe20003f06070ULL,
0x000000ffff1e7224ULL, 0x000fd800078e001dULL, 0x0000be7000000947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fcc0000015200ULL,
0x000000401e437210ULL, 0x000fca0007f1e1ffULL, 0x0000000141417824ULL, 0x000fe200000e0e1fULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff407819ULL, 0x000fc80000011441ULL, 0x0000004340407211ULL, 0x000fca00078110ffULL,
0x000000ffff417224ULL, 0x000fca00000e0641ULL, 0x0000000240407819ULL, 0x000fc80000001241ULL,
0x000000400000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000142427810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000040061f7810ULL, 0x000fca0007ffe0ffULL,
0x0000620009437a24ULL, 0x000fe200078e021fULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000004004c7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b407824ULL, 0x040fe200078e0200ULL,
0x00000002004a7810ULL, 0x000fe40007ffe0ffULL, 0x0000001f0c1e7217ULL, 0x000fe20007800000ULL,
0x000000010b457824ULL, 0x040fe200078e024cULL, 0x00000006004e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b427824ULL, 0x000fe200078e024aULL, 0x000000f005497812ULL, 0x000fe200078ec0ffULL,
0x0000000145467824ULL, 0x000fc400078e020eULL, 0x00000010454d7824ULL, 0x000fe400078e00ffULL,
0x000000011e1e7824ULL, 0x000fe400078e0a1fULL, 0x0000000140417824ULL, 0x040fe200078e020eULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee246ULL, 0x0000001040487824ULL, 0x000fe400078e00ffULL,
0x0000000142447824ULL, 0x040fe200078e020eULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x00000010424b7824ULL, 0x000fe200078e00ffULL, 0xfffffff048487812ULL, 0x000fe200078ee241ULL,
0x00000100ff467424ULL, 0x000fc400078e00ffULL, 0x00000001401f7824ULL, 0x100fe200078e0243ULL,
0x0000001e0b407217ULL, 0x000fe20007800000ULL, 0x0000000142417824ULL, 0x000fe200078e0243ULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee244ULL, 0x000000010b447824ULL, 0x000fe400078e024eULL,
0x00005e001f1e7625ULL, 0x000fe200078e0046ULL, 0x000160004b4b7811ULL, 0x000fc600078e20ffULL,
0x0000000140477824ULL, 0x000fe400078e0a0bULL, 0x0000000145427824ULL, 0x100fe400078e0243ULL,
0x00005e0041407625ULL, 0x000fe200078e0046ULL, 0x000000470000720cULL, 0x080fe40003f66070ULL,
0x000000474a00720cULL, 0x000fe20003f46070ULL, 0x0000000144437824ULL, 0x000fe200078e0243ULL,
0x0000004940407210ULL, 0x000fe20007f9e0ffULL, 0x0000000144457824ULL, 0x000fc400078e020eULL,
0x0000001044507824ULL, 0x000fe200078e00ffULL, 0x000000491e447210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff417224ULL, 0x000fe200020e0641ULL, 0x000000474e00720cULL, 0x080fe40003f86070ULL,
0xfffffff0504f7812ULL, 0x000fe200078ee245ULL, 0x000000ffff457224ULL, 0x000fe200000e061fULL,
0x000000474c00720cULL, 0x000fe20003f06070ULL, 0x00005e00421e7625ULL, 0x080fe200078e0046ULL,
0x0001600048477811ULL, 0x000fe400078e20ffULL, 0x000160004f4f7811ULL, 0x000fe200078e20ffULL,
0x00005e0043427625ULL, 0x000fe200078e0046ULL, 0x000000491e1e7210ULL, 0x080fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044477faeULL, 0x0003e6000d901c46ULL,
0x0000004942427210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1f7224ULL, 0x000fe200028e061fULL,
0x00000000404b7faeULL, 0x0003e6000d101c46ULL, 0x000000ffff437224ULL, 0x000fe200030e0643ULL,
0x000000001e4d7faeULL, 0x0003e8000c101c46ULL, 0x00000000424f7faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x000000010b1e7824ULL, 0x000fe200078e0200ULL,
0x000000f005497812ULL, 0x000fe200078ec0ffULL, 0x00000100ff477424ULL, 0x000fc400078e00ffULL,
0x000000011e1f7824ULL, 0x040fe200078e020eULL, 0x000000041e427810ULL, 0x040fe20007ffe0ffULL,
0x000000101e467824ULL, 0x040fe200078e00ffULL, 0x000000021e407810ULL, 0x000fc60007ffe0ffULL,
0x0000000142447824ULL, 0x100fe200078e020eULL, 0xfffffff046467812ULL, 0x000fe200078ee21fULL,
0x0000001042457824ULL, 0x000fe200078e00ffULL, 0x000000061e1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000140417824ULL, 0x000fe200078e020eULL, 0x00016000464d7811ULL, 0x000fe200078e20ffULL,
0x0000001040487824ULL, 0x000fe200078e00ffULL, 0xfffffff0454a7812ULL, 0x000fe200078ee244ULL,
0x000000011e447824ULL, 0x100fe400078e0243ULL, 0x00000001401e7824ULL, 0x000fe200078e0243ULL,
0xfffffff048487812ULL, 0x000fe200078ee241ULL, 0x00005e0044447625ULL, 0x000fc800078e0047ULL,
0x0000000142407824ULL, 0x100fe200078e0243ULL, 0x0000004944447210ULL, 0x000fe20007f5e0ffULL,
0x000000011f427824ULL, 0x040fe400078e0243ULL, 0x000000011f4b7824ULL, 0x040fe400078e020eULL,
0x000000101f4c7824ULL, 0x000fe400078e00ffULL, 0x00005e001e1e7625ULL, 0x000fc600078e0047ULL,
0xfffffff04c4b7812ULL, 0x000fe200078ee24bULL, 0x00005e0040407625ULL, 0x000fe200078e0047ULL,
0x000000491e1e7210ULL, 0x000fe40007f1e0ffULL, 0x000160004b4b7811ULL, 0x000fe200078e20ffULL,
0x00005e0042427625ULL, 0x000fe200078e0047ULL, 0x0001600048477811ULL, 0x000fc600078e20ffULL,
0x000000ffff457224ULL, 0x000fe200010e0645ULL, 0x0000004940407210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x0000004942427210ULL, 0x000fe40007f7e0ffULL,
0x000160004a497811ULL, 0x000fe200078e20ffULL, 0x000000ffff417224ULL, 0x000fe200010e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000444d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff437224ULL, 0x000fc600018e0643ULL, 0x000000001e477faeULL, 0x0003e8000b901c46ULL,
0x0000000040497faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff487f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018628000b427f8cULL, 0x0004e4000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0x01862c000b417984ULL, 0x000f240000000800ULL, 0x8000000041ff7812ULL, 0x018fc40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x000000401e457210ULL, 0x000fca0007f1e1ffULL,
0x0000000141417824ULL, 0x000fe200000e0e1fULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff407819ULL, 0x000fc80000011441ULL,
0x0000004540407211ULL, 0x000fca00078110ffULL, 0x000000ffff417224ULL, 0x000fca00000e0641ULL,
0x0000000240407819ULL, 0x000fc80000001241ULL, 0x000000400000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01862c000b417984ULL, 0x000ee40000000800ULL,
0x8000000041ff7812ULL, 0x008fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0180800016407984ULL, 0x000ee80000000800ULL, 0x01828000161f7984ULL, 0x0004620000000800ULL,
0x0000001d4000720bULL, 0x008fe20003f1d000ULL, 0x000123127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000417806ULL, 0x004fc800000e0100ULL, 0x0000ffff41ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff447424ULL, 0x000fc400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fd200078e001dULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000010d00780cULL, 0x000fe40003f05270ULL, 0x0000001d4000720bULL, 0x000fe20003f54000ULL,
0x000122e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001e7806ULL, 0x000fc400010e0100ULL,
0x0000001d40438209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099101e427816ULL, 0x000fc600000000ffULL, 0x0184804316008388ULL, 0x0005e20000000800ULL,
0x000000ff4200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001d40427209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff1eff7812ULL, 0x000fc6000780c0ffULL, 0x0000001d42427221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x0000004200437308ULL, 0x000ea40000000800ULL,
0x0000004308087220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff4d7819ULL, 0x000fe2000001160eULL, 0x000122327f007947ULL, 0x000fea000b800000ULL,
0x00001f4d43427589ULL, 0x0004e400000e0000ULL, 0x0000004220207220ULL, 0x088fe40000410000ULL,
0x0000004221217220ULL, 0x080fe40000410000ULL, 0x0000004224247220ULL, 0x080fe40000410000ULL,
0x0000004225257220ULL, 0x000fc40000410000ULL, 0x0000004228287220ULL, 0x080fe40000410000ULL,
0x0000004229297220ULL, 0x080fe40000410000ULL, 0x000000422c2c7220ULL, 0x080fe40000410000ULL,
0x000000422d2d7220ULL, 0x080fe40000410000ULL, 0x0000004230307220ULL, 0x080fe40000410000ULL,
0x0000004231317220ULL, 0x000fc40000410000ULL, 0x0000004234347220ULL, 0x080fe40000410000ULL,
0x0000004235357220ULL, 0x080fe40000410000ULL, 0x0000004238387220ULL, 0x080fe40000410000ULL,
0x0000004239397220ULL, 0x080fe40000410000ULL, 0x000000423c3c7220ULL, 0x080fe40000410000ULL,
0x000000423d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001eff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080e4d7811ULL, 0x006fe200078ff0ffULL, 0x000121427f007947ULL, 0x000fea000b800000ULL,
0x00001f4d43427589ULL, 0x0002a400000e0000ULL, 0x0000004222227220ULL, 0x084fe40000410000ULL,
0x0000004223237220ULL, 0x080fe40000410000ULL, 0x0000004226267220ULL, 0x080fe40000410000ULL,
0x0000004227277220ULL, 0x080fe40000410000ULL, 0x000000422a2a7220ULL, 0x080fe40000410000ULL,
0x000000422b2b7220ULL, 0x000fc40000410000ULL, 0x000000422e2e7220ULL, 0x080fe40000410000ULL,
0x000000422f2f7220ULL, 0x080fe40000410000ULL, 0x0000004232327220ULL, 0x080fe40000410000ULL,
0x0000004233337220ULL, 0x080fe40000410000ULL, 0x0000004236367220ULL, 0x080fe40000410000ULL,
0x0000004237377220ULL, 0x000fc40000410000ULL, 0x000000423a3a7220ULL, 0x080fe40000410000ULL,
0x000000423b3b7220ULL, 0x080fe40000410000ULL, 0x000000423e3e7220ULL, 0x080fe40000410000ULL,
0x000000423f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1eff7812ULL, 0x000fe20007800841ULL, 0x00000001ff447424ULL, 0x000fe200078e00ffULL,
0x0000001d401e7209ULL, 0x000fd60007810000ULL, 0x8000001e40400221ULL, 0x000fe20000010000ULL,
0x00007610ff440816ULL, 0x000fc60000000044ULL, 0x3fb8aa3b40400820ULL, 0x000fc80000410000ULL,
0x0000004000040308ULL, 0x000ea40000000800ULL, 0x000000041f1f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000081f087221ULL, 0x002fc40000010000ULL,
0x0000000000407805ULL, 0x000fca0000015200ULL, 0x0186ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240427210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011443ULL, 0x000000421d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0643ULL, 0x000000021d1d7819ULL, 0x000fc80000001242ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991044157816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1500720cULL, 0x000fda0003f45270ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000004ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff407819ULL, 0x000fe4000001160eULL, 0x0000541002157816ULL, 0x000fe20000000002ULL,
0x00011d427f007947ULL, 0x000fea000b800000ULL, 0x00001f4015037589ULL, 0x0002a400000e0000ULL,
0x00000008404d7810ULL, 0x002fe20007ffe0ffULL, 0x00011d927f007947ULL, 0x000fea000b800000ULL,
0x00001f4d15027589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010404d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x00006740004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x00012b2000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018404d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e0015ULL, 0x000067b0004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00012ab000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001750783bULL, 0x000f280000004200ULL,
0x00000000184c783bULL, 0x006e680000004200ULL, 0x000000001944783bULL, 0x000ea80000004200ULL,
0x000000001a40783bULL, 0x000fe20000004200ULL, 0x00000018ff157819ULL, 0x010fe20000011450ULL,
0x0000010050557824ULL, 0x040fe200078e00ffULL, 0x0000888050547816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe20000011451ULL,
0x0000010051607824ULL, 0x040fe200078e00ffULL, 0x00008880515f7816ULL, 0x040fe200000000ffULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000010053657824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe20000011452ULL,
0x000001004c6b7824ULL, 0x002fe200078e00ffULL, 0x0000005000577306ULL, 0x0003e20000200c00ULL,
0x0000888052637816ULL, 0x000fe200000000ffULL, 0x000001004e6f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fc40000011451ULL, 0x00000018ff4a7819ULL, 0x000fe40000011453ULL,
0x00000018ff5d7819ULL, 0x000fe2000001144cULL, 0x0000005100627306ULL, 0x000fe20000200c00ULL,
0x0000010052507824ULL, 0x042fe200078e00ffULL, 0x0000888053667816ULL, 0x040fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x000088804c6a7816ULL, 0x040fe200000000ffULL,
0x0001000053537824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011465ULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000018ff5e7819ULL, 0x000fc4000001144dULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff5b7819ULL, 0x000fe2000001144eULL, 0x0000006700517306ULL, 0x0003e20000200c00ULL,
0x00000018ff5c7819ULL, 0x000fe4000001144fULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000018ff597819ULL, 0x004fc40000011444ULL, 0x0000888044767816ULL, 0x000fe200000000ffULL,
0x0000005200657306ULL, 0x0005e20000200c00ULL, 0x000088804d677816ULL, 0x042fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x00000018ff5a7819ULL, 0x000fe20000011445ULL, 0x0000005300697306ULL, 0x0003e20000200c00ULL,
0x000001004d527824ULL, 0x044fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011446ULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011447ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000004c006c7306ULL, 0x0005e20000200c00ULL,
0x000088804e537816ULL, 0x042fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x00000052006e7306ULL, 0x0003e20000200c00ULL,
0x000001004f4c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc8000001146fULL,
0x00000018ff717819ULL, 0x000fe4000001144cULL, 0x0000004d006d7306ULL, 0x0005e20000200c00ULL,
0x000088804f527816ULL, 0x042fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x000128001b4c7811ULL, 0x000fca00078e20ffULL, 0x0000005300707306ULL, 0x0003e20000200c00ULL,
0x00000100444d7824ULL, 0x044fe400078e00ffULL, 0x0001000044447824ULL, 0x000fca00078e00ffULL,
0x0000005200737306ULL, 0x0005e20000200c00ULL, 0x00000018ff537819ULL, 0x002fe4000001144fULL,
0x00000018ff447819ULL, 0x000fca0000011444ULL, 0x0000004e00727306ULL, 0x0003e20000200c00ULL,
0x00000018ff527819ULL, 0x004fce000001144dULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x000000004c4c783bULL, 0x002e6e0000000200ULL, 0x0000006600667306ULL, 0x000f300000200c00ULL,
0x0000007100747306ULL, 0x0007e20000200c00ULL, 0x0000541063507816ULL, 0x004fce0000000050ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000010045717824ULL, 0x008fe200078e00ffULL,
0x0000541066517816ULL, 0x010fc80000000051ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000005500557306ULL, 0x000eb00000200c00ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x000000034c4ca232ULL, 0x002fc40000000000ULL, 0x000000034e4ea232ULL, 0x000fe40000000000ULL,
0x000000024d4da232ULL, 0x080fe40000000000ULL, 0x000000024f4fa232ULL, 0x000fe20000000000ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x0000541054547816ULL, 0x004fce0000000055ULL,
0x0000005300757306ULL, 0x0005f00000200c00ULL, 0x0000004400787306ULL, 0x0007e20000200c00ULL,
0x0000888045537816ULL, 0x044fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x000054105f557816ULL, 0x002fc80000000060ULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000005200777306ULL, 0x0003e20000200c00ULL, 0x0000010046447824ULL, 0x048fe200078e00ffULL,
0x000000544c20723cULL, 0x000be80000001820ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000005300797306ULL, 0x0005e20000200c00ULL, 0x0000888046527816ULL, 0x042fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000888040547816ULL, 0x020fc800000000ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x00000071007a7306ULL, 0x0003e20000200c00ULL,
0x0000888047537816ULL, 0x004fce00000000ffULL, 0x00000045007b7306ULL, 0x0005e20000200c00ULL,
0x0000010047717824ULL, 0x042fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x00000044007d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000010040457824ULL, 0x004fcc00078e00ffULL,
0x00000052007c7306ULL, 0x000fe20000200c00ULL, 0x000128001c447811ULL, 0x002fce00078e20ffULL,
0x00000053007f7306ULL, 0x0003f00000200c00ULL, 0x0000001500567306ULL, 0x0004e20000200c00ULL,
0x000000504c50723cULL, 0x002bee0000001828ULL, 0x00000046007e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff287819ULL, 0x020fe20000011445ULL, 0x00000100412a7824ULL, 0x040fe200078e00ffULL,
0x0000888041297816ULL, 0x000fc400000000ffULL, 0x00000018ff157819ULL, 0x004fe40000011442ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x00000047005f7306ULL, 0x0003e20000200c00ULL,
0x0000541057567816ULL, 0x008fce0000000056ULL, 0x0000001d00617306ULL, 0x0004e20000200c00ULL,
0x000000004444783bULL, 0x002e6e0000000200ULL, 0x0000001f00647306ULL, 0x0009220000200c00ULL,
0x00000018ff1d7819ULL, 0x004fce0000011443ULL, 0x0000004a00687306ULL, 0x0004a20000200c00ULL,
0x0000541062577816ULL, 0x008fe40000000061ULL, 0x00000018ff1f7819ULL, 0x010fe20000011440ULL,
0x0001000040407824ULL, 0x000fc800078e00ffULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000000564c24723cULL, 0x000f620000001824ULL, 0x0000541065647816ULL, 0x000fe40000000064ULL,
0x00000018ff4a7819ULL, 0x004fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x0000541069657816ULL, 0x000fe40000000068ULL, 0x00000018ff417819ULL, 0x000fca0000011441ULL,
0x0000005b005b7306ULL, 0x000f220000200c00ULL, 0x000054106c6c7816ULL, 0x008fe2000000005dULL,
0x000000644c2c723cULL, 0x000f62000000182cULL, 0x000000034444a232ULL, 0x082fe40000000000ULL,
0x000000034646a232ULL, 0x000fe40000000000ULL, 0x000000024545a232ULL, 0x080fe20000000000ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000054106d6d7816ULL, 0x004fe2000000005eULL,
0x000000024747a232ULL, 0x000fcc0000000000ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541072727816ULL, 0x010fe2000000005bULL, 0x0000006c4c34723cULL, 0x000f6c0000001834ULL,
0x0000006b006b7306ULL, 0x000ff00000200c00ULL, 0x0000006700677306ULL, 0x000e700000200c00ULL,
0x0000006f006f7306ULL, 0x000eb00000200c00ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0000541067557816ULL, 0x002fce000000006eULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x0000541070707816ULL, 0x004fce000000006fULL, 0x0000007100807306ULL, 0x0004f00000200c00ULL,
0x0000005400607306ULL, 0x0009e20000200c00ULL, 0x0000541073717816ULL, 0x004fe40000000074ULL,
0x0000541075737816ULL, 0x000fca000000005cULL, 0x0000002900627306ULL, 0x0005e20000200c00ULL,
0x000054106a547816ULL, 0x010fe2000000006bULL, 0x000000704c38723cULL, 0x040fec0000001838ULL,
0x0000002800617306ULL, 0x0009e20000200c00ULL, 0x0000010042297824ULL, 0x044fe200078e00ffULL,
0x000000544c54723cULL, 0x040b6c0000001830ULL, 0x0000002a00637306ULL, 0x000fe20000200c00ULL,
0x0000888042287816ULL, 0x050fe200000000ffULL, 0x000000724c3c723cULL, 0x000b64000000183cULL,
0x00000018ff307819ULL, 0x020fe20000011429ULL, 0x0000010043327824ULL, 0x000fe200078e00ffULL,
0x000054107b297816ULL, 0x002fe2000000005aULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x0000888043317816ULL, 0x040fe200000000ffULL, 0x00000028004c7306ULL, 0x0003e20000200c00ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc40000011432ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x0000541078287816ULL, 0x002fce0000000059ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000000284428723cULL, 0x000b6e0000001824ULL,
0x000054107c247816ULL, 0x020fe2000000007dULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x000054107f257816ULL, 0x008fce0000000080ULL, 0x00000030004d7306ULL, 0x0004e20000200c00ULL,
0x000000244424723cULL, 0x000f6e0000001850ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x000054107e307816ULL, 0x004fe4000000004bULL, 0x0000541076767816ULL, 0x002fc40000000077ULL,
0x0000541079777816ULL, 0x000fc6000000007aULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000054104c4c7816ULL, 0x008fc6000000004dULL, 0x000000764420723cULL, 0x000f680000001820ULL,
0x0000004000407306ULL, 0x000e700000200c00ULL, 0x0000004100417306ULL, 0x000eb00000200c00ULL,
0x00000031004f7306ULL, 0x0007e20000200c00ULL, 0x0000541040407816ULL, 0x002fce000000001fULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x000054105f317816ULL, 0x008fe40000000058ULL,
0x0000541041417816ULL, 0x004fca000000004aULL, 0x0000001500157306ULL, 0x000fe20000200c00ULL,
0x000000304430723cULL, 0x040b6e000000182cULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x00005410602c7816ULL, 0x020fe20000000061ULL, 0x000000404434723cULL, 0x000b620000001834ULL,
0x00005410622d7816ULL, 0x000fc40000000063ULL, 0x000054104f4d7816ULL, 0x002fc6000000004eULL,
0x0000004200427306ULL, 0x000e640000200c00ULL, 0x0000002c442c723cULL, 0x040b6c0000001854ULL,
0x0000004300507306ULL, 0x000ea40000200c00ULL, 0x0000004c4438723cULL, 0x000b620000001838ULL,
0x0000541042427816ULL, 0x002fc40000000015ULL, 0x0000541050437816ULL, 0x004fce000000001dULL,
0x000000424444723cULL, 0x000b62000000183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff407f8cULL, 0x020e62000c80043fULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x006fe40007804841ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff157819ULL, 0x000fc8000001143fULL,
0x0000003e15157211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x0000000215157819ULL, 0x000fc8000000123eULL, 0x000000150000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011d1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000060063e7810ULL, 0x000fca0007ffe0ffULL, 0x0000620009407a24ULL, 0x000fe200078e023eULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x000000010b1d7824ULL, 0x000fe200078e0200ULL,
0x00000004004c7810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x0000003e0c157217ULL, 0x000fe20007800000ULL, 0x000000011d1f7824ULL, 0x040fe200078e020eULL,
0x00000002004a7810ULL, 0x000fe20007ffe0ffULL, 0x000000101d3c7824ULL, 0x000fe400078e00ffULL,
0x000000010b437824ULL, 0x000fe400078e024cULL, 0x00000001153e7824ULL, 0x000fe200078e0a3eULL,
0xfffffff03c1f7812ULL, 0x000fe200078ee21fULL, 0x000000011d3c7824ULL, 0x000fe200078e0240ULL,
0x000000f0051d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b157824ULL, 0x040fe200078e024aULL,
0x0000003e0b3e7217ULL, 0x000fe20007800000ULL, 0x0000000143427824ULL, 0x000fe200078e020eULL,
0x000140001f1f7811ULL, 0x000fe200078e20ffULL, 0x00000010434d7824ULL, 0x000fc400078e00ffULL,
0x00005e003c3c7625ULL, 0x000fc600078e0041ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL,
0x00000001153f7824ULL, 0x040fe200078e020eULL, 0x0000001d3c427210ULL, 0x000fe20007f1e0ffULL,
0x00000010154e7824ULL, 0x000fe200078e00ffULL, 0x000140004d4d7811ULL, 0x000fe200078e20ffULL,
0x00000001153c7824ULL, 0x100fe400078e0240ULL, 0x000000013e157824ULL, 0x000fe200078e0a0bULL,
0xfffffff04e4b7812ULL, 0x000fe200078ee23fULL, 0x00000001433f7824ULL, 0x000fe200078e0240ULL,
0x00000006004e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe200000e063dULL,
0x000000154a00720cULL, 0x000fe20003f66070ULL, 0x00005e003c3c7625ULL, 0x000fe200078e0041ULL,
0x000000150000720cULL, 0x000fc40003f86070ULL, 0x000000154c00720cULL, 0x000fe20003f06070ULL,
0x000000010b4f7824ULL, 0x000fe200078e024eULL, 0x0000001d3c3c7210ULL, 0x000fe20007fbe0ffULL,
0x00005e003f3e7625ULL, 0x000fe200078e0041ULL, 0x000140004b4b7811ULL, 0x000fc600078e20ffULL,
0x000000014f407824ULL, 0x040fe200078e0240ULL, 0x0000001d3e3e7210ULL, 0x000fe20007fde0ffULL,
0x000000014f4a7824ULL, 0x040fe400078e020eULL, 0x00005e0040407625ULL, 0x000fe200078e0041ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000421f7faeULL, 0x0003e6000e101c46ULL,
0x000000ffff3d7224ULL, 0x000fe200028e063dULL, 0x000000154e00720cULL, 0x000fe20003fa6070ULL,
0x000000104f4f7824ULL, 0x000fc400078e00ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063fULL,
0x0000001d40407210ULL, 0x000fe20007fde0ffULL, 0x000000003c4b7faeULL, 0x0003e2000d901c46ULL,
0xfffffff04f4a7812ULL, 0x000fc600078ee24aULL, 0x000000ffff417224ULL, 0x000fe200030e0641ULL,
0x000140004a157811ULL, 0x000fe200078e20ffULL, 0x000000003e4d7faeULL, 0x0003e8000c101c46ULL,
0x0000000040157faeULL, 0x0003e2000e901c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000010b157824ULL, 0x000fc800078e0200ULL, 0x00000001151d7824ULL, 0x040fe200078e020eULL,
0x00000002153d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001015427824ULL, 0x040fe200078e00ffULL,
0x00000004153f7810ULL, 0x000fc60007ffe0ffULL, 0x000000013d3c7824ULL, 0x140fe200078e020eULL,
0xfffffff0421f7812ULL, 0x000fe200078ee21dULL, 0x000000103d417824ULL, 0x000fe200078e00ffULL,
0x000000f0051d7812ULL, 0x000fe200078ec0ffULL, 0x000000013f3e7824ULL, 0x000fe200078e020eULL,
0x000140001f1f7811ULL, 0x000fe200078e20ffULL, 0x000000103f4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff0414a7812ULL, 0x000fe200078ee23cULL, 0x00000100ff417424ULL, 0x000fe400078e00ffULL,
0x0000000115427824ULL, 0x140fe200078e0240ULL, 0x0000000615157810ULL, 0x000fe20007ffe0ffULL,
0x000000013d3c7824ULL, 0x000fe200078e0240ULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee23eULL,
0x00005e0042427625ULL, 0x000fc600078e0041ULL, 0x000140004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000013f3e7824ULL, 0x100fe200078e0240ULL, 0x0000001d42427210ULL, 0x000fe20007f7e0ffULL,
0x0000000115407824ULL, 0x000fe400078e0240ULL, 0x00005e003c3c7625ULL, 0x000fc800078e0041ULL,
0x00005e003e3e7625ULL, 0x000fe200078e0041ULL, 0x0000001d3c3c7210ULL, 0x000fc60007f1e0ffULL,
0x00000001154c7824ULL, 0x000fe400078e020eULL, 0x00005e0040407625ULL, 0x000fc800078e0041ULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0x0000001d40407210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff437224ULL, 0x000fe200018e0643ULL, 0x0000001d3e3e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063dULL, 0xfffffff0154c7812ULL, 0x000fe200078ee24cULL,
0x000000ffff417224ULL, 0x000fe200020e0641ULL, 0x000140004a157811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e063fULL, 0x000140004c1d7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000421f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c157faeULL, 0x0003e8000b901c46ULL, 0x000000003e4b7faeULL, 0x0003e8000b901c46ULL,
0x00000000401d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff3c7f8cULL, 0x000e64000c80043fULL,
0x000000ffff157224ULL, 0x002fc400078e003dULL, 0x00000000003c7805ULL, 0x000fca0000015200ULL,
0x0186b400ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc8000001143fULL,
0x0000003e1d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x000000021d1d7819ULL, 0x000fc8000000123eULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x00000004ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff3c7819ULL, 0x000fe4000001160eULL,
0x00005410021d7816ULL, 0x000fe20000000002ULL, 0x000102a27f007947ULL, 0x000fea000b800000ULL,
0x00001f3c1d037589ULL, 0x0002a400000e0000ULL, 0x000000083c4d7810ULL, 0x002fe20007ffe0ffULL,
0x000102f27f007947ULL, 0x000fea000b800000ULL, 0x00001f4d1d027589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000103c4d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200078e001dULL, 0x000082d0004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00010f9000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000183c4d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x004fe200078e001dULL,
0x00008340004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x00010f2000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000104c783bULL, 0x006e680000004200ULL, 0x000000000f48783bULL, 0x000ea80000004200ULL,
0x000000001240783bULL, 0x000f280000004200ULL, 0x00000000113c783bULL, 0x000ee20000004200ULL,
0x00000018ff507819ULL, 0x002fe2000001144eULL, 0x000001004f637824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe2000001144fULL, 0x000001004d5f7824ULL, 0x000fe200078e00ffULL,
0x0000005000627306ULL, 0x0003e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe2000001144cULL,
0x0000010048697824ULL, 0x004fe200078e00ffULL, 0x000088804e617816ULL, 0x000fe200000000ffULL,
0x000001004a6e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011448ULL,
0x0000010041767824ULL, 0x010fe200078e00ffULL, 0x000088804f647816ULL, 0x040fe200000000ffULL,
0x0000005100667306ULL, 0x0005e20000200c00ULL, 0x000088804c507816ULL, 0x002fe200000000ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x0000888048687816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fc40000011463ULL,
0x00000018ff5d7819ULL, 0x000fe20000011449ULL, 0x0000001d00527306ULL, 0x000fe20000200c00ULL,
0x000001004c517824ULL, 0x044fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00008880496a7816ULL, 0x000fe400000000ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000004f00677306ULL, 0x0003e20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fc4000001144aULL,
0x00000018ff5b7819ULL, 0x000fe4000001144bULL, 0x00000018ff1f7819ULL, 0x000fe4000001144dULL,
0x000088804d5e7816ULL, 0x040fe200000000ffULL, 0x0000004c00537306ULL, 0x0005220000200c00ULL,
0x000088804a4f7816ULL, 0x042fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011440ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x0000888040757816ULL, 0x000fc400000000ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x00000048006b7306ULL, 0x0003e20000200c00ULL, 0x000001004e4c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x000001004b487824ULL, 0x002fe200078e00ffULL,
0x0000004f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fc4000001145fULL,
0x00000018ff597819ULL, 0x000fe40000011441ULL, 0x00000018ff707819ULL, 0x000fe40000011448ULL,
0x0001280013487811ULL, 0x000fe200078e20ffULL, 0x0000004e00637306ULL, 0x0002a20000200c00ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000018ff567819ULL, 0x000fe40000011442ULL,
0x00000018ff577819ULL, 0x000fc40000011443ULL, 0x0000541053527816ULL, 0x010fe20000000052ULL,
0x0000004a00717306ULL, 0x000fe20000200c00ULL, 0x00000100494e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000001f00607306ULL, 0x0003e20000200c00ULL,
0x0000541063627816ULL, 0x004fc40000000062ULL, 0x0000541067637816ULL, 0x000fe40000000066ULL,
0x00000018ff547819ULL, 0x008fe4000001143cULL, 0x00000018ff1d7819ULL, 0x000fe2000001143eULL,
0x0000004e006d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff1f7819ULL, 0x002fe4000001143fULL,
0x00000018ff557819ULL, 0x000fca000001143dULL, 0x00000049006c7306ULL, 0x0003e20000200c00ULL,
0x000088804b4e7816ULL, 0x044fe200000000ffULL, 0x000100004b4b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144bULL, 0x0000004e00727306ULL, 0x0005e20000200c00ULL,
0x0000010040497824ULL, 0x042fe400078e00ffULL, 0x0001000040407824ULL, 0x000fca00078e00ffULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x00000018ff4e7819ULL, 0x004fe40000011449ULL,
0x000000004848783bULL, 0x000ea20000000200ULL, 0x00000018ff407819ULL, 0x000fc80000011440ULL,
0x0000006100617306ULL, 0x000ff00000200c00ULL, 0x0000004c004c7306ULL, 0x000ee20000200c00ULL,
0x000054104d537816ULL, 0x002fce0000000060ULL, 0x0000006400647306ULL, 0x000ff00000200c00ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x00005410614c7816ULL, 0x008fce000000004cULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000000034848a232ULL, 0x084fe40000000000ULL,
0x000000034a4aa232ULL, 0x000fe40000000000ULL, 0x000000024949a232ULL, 0x000fc60000000000ULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x000000024b4ba232ULL, 0x000fe20000000000ULL,
0x00005410644d7816ULL, 0x002fcc0000000065ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000624830723cULL, 0x040f6e0000001830ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000541050507816ULL, 0x004fe20000000051ULL, 0x000000524828723cULL, 0x000fec0000001828ULL,
0x0000004f00747306ULL, 0x0005f00000200c00ULL, 0x0000004000777306ULL, 0x0007e20000200c00ULL,
0x00008880414f7816ULL, 0x044fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x000054105e517816ULL, 0x002fc8000000005fULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000007000737306ULL, 0x000fe20000200c00ULL, 0x0000010042407824ULL, 0x008fe200078e00ffULL,
0x000000504820723cULL, 0x000be80000001820ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004e00707306ULL, 0x0003e20000200c00ULL, 0x000088803c507816ULL, 0x020fce00000000ffULL,
0x0000004f00787306ULL, 0x0005e20000200c00ULL, 0x00008880424e7816ULL, 0x042fe200000000ffULL,
0x0001000042427824ULL, 0x000fca00078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000007600797306ULL, 0x0003e20000200c00ULL, 0x00008880434f7816ULL, 0x004fce00000000ffULL,
0x00000041007a7306ULL, 0x0005e20000200c00ULL, 0x0000010043767824ULL, 0x042fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000040007c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x000001003c417824ULL, 0x044fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc800078e00ffULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0001280014407811ULL, 0x002fe400078e20ffULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000006900697306ULL, 0x000ff00000200c00ULL,
0x0000006a006a7306ULL, 0x000e700000200c00ULL, 0x0000004e007b7306ULL, 0x000ff00000200c00ULL,
0x0000004f007e7306ULL, 0x0005e20000200c00ULL, 0x000054106a517816ULL, 0x002fce000000006dULL,
0x00000042007d7306ULL, 0x000fe20000200c00ULL, 0x0000004c484c723cULL, 0x004bee0000001824ULL,
0x00000043005e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff247819ULL, 0x020fe20000011441ULL,
0x000001003d267824ULL, 0x040fe200078e00ffULL, 0x000088803d257816ULL, 0x000fc800000000ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x000000004040783bULL, 0x002e6e0000000200ULL, 0x0000005c005c7306ULL, 0x000ef00000200c00ULL,
0x0000005d005d7306ULL, 0x000f220000200c00ULL, 0x000054106f6e7816ULL, 0x004fc4000000006eULL,
0x00005410726f7816ULL, 0x000fca0000000073ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000054106b5c7816ULL, 0x008fe2000000005cULL, 0x0000006e4838723cULL, 0x000fec0000001838ULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x000054106c5d7816ULL, 0x010fce000000005dULL,
0x00000050005f7306ULL, 0x0009e20000200c00ULL, 0x00005410715a7816ULL, 0x004fe2000000005aULL,
0x0000005c4834723cULL, 0x000fe20000001834ULL, 0x000000034040a232ULL, 0x082fe20000000000ULL,
0x0000541078717816ULL, 0x000fe20000000079ULL, 0x000000034242a232ULL, 0x000fe40000000000ULL,
0x000000024141a232ULL, 0x080fe20000000000ULL, 0x00005410745b7816ULL, 0x008fe2000000005bULL,
0x0000002500617306ULL, 0x0003e20000200c00ULL, 0x0000541068507816ULL, 0x010fe20000000069ULL,
0x000000024343a232ULL, 0x000fc80000000000ULL, 0x0000005a4844723cULL, 0x000fe40000001844ULL,
0x0000002600627306ULL, 0x0005e20000200c00ULL, 0x000088803e257816ULL, 0x002fca00000000ffULL,
0x000000504850723cULL, 0x000b64000000182cULL, 0x0000002400607306ULL, 0x0003e20000200c00ULL,
0x000001003e267824ULL, 0x044fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fe400078e00ffULL,
0x000001003f2e7824ULL, 0x060fe200078e00ffULL, 0x000088803f2d7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x000100003d247824ULL, 0x002fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc4000001142eULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff2c7819ULL, 0x000fe40000011426ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff3f7819ULL, 0x000fca000001143fULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x0000541077587816ULL, 0x004fce0000000058ULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x000054107a597816ULL, 0x002fce0000000059ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000054107d567816ULL, 0x008fce0000000056ULL, 0x0000003c003d7306ULL, 0x000e620000200c00ULL,
0x000054105e577816ULL, 0x004fce0000000057ULL, 0x00000025003c7306ULL, 0x000ff00000200c00ULL,
0x0000002c00497306ULL, 0x000ea20000200c00ULL, 0x000054103d547816ULL, 0x002fce0000000054ULL,
0x0000002d004a7306ULL, 0x0003f00000200c00ULL, 0x00000048004b7306ULL, 0x000ee20000200c00ULL,
0x00000056402c723cULL, 0x002b620000001830ULL, 0x000054103c3c7816ULL, 0x004fcc0000000049ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x000054105f307816ULL, 0x020fe40000000060ULL,
0x0000541061317816ULL, 0x000fca0000000062ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x000054104a3d7816ULL, 0x008fe2000000004bULL, 0x000000304030723cULL, 0x040f6c0000001850ULL,
0x0000001f001f7306ULL, 0x000fe40000200c00ULL, 0x0000003c4038723cULL, 0x000f6c0000001838ULL,
0x0000007500757306ULL, 0x000e700000200c00ULL, 0x00000076007f7306ULL, 0x000eb00000200c00ULL,
0x00000024005c7306ULL, 0x0007220000200c00ULL, 0x0000541075707816ULL, 0x002fce0000000070ULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x000000584024723cULL, 0x048b6e0000001828ULL,
0x0000003f00487306ULL, 0x000ee20000200c00ULL, 0x000054107b287816ULL, 0x020fe2000000007cULL,
0x000000704020723cULL, 0x000b620000001820ULL, 0x000054107e297816ULL, 0x004fc4000000007fULL,
0x000054105c557816ULL, 0x010fe40000000055ULL, 0x000054103e3e7816ULL, 0x002fc6000000001dULL,
0x000000284028723cULL, 0x000b62000000184cULL, 0x00005410483f7816ULL, 0x008fce000000001fULL,
0x000000544034723cULL, 0x040b700000001834ULL, 0x0000003e403c723cULL, 0x000b620000001844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff407f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000060061d7810ULL, 0x000fe20007ffe0ffULL, 0x01869000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff447224ULL, 0x002fc400078e0041ULL, 0x0000000c1d00720cULL, 0x000fda0003f06070ULL,
0x00007f0000000947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x0186bc00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240427210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc80000011443ULL,
0x000000421d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff427224ULL, 0x000fca00000e0643ULL,
0x000000021d1d7819ULL, 0x000fc80000001242ULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008006407810ULL, 0x000fca0007ffe0ffULL, 0x0000620009447a24ULL, 0x000fe200078e0240ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x00000002004c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b417824ULL, 0x040fe200078e0200ULL, 0x000000400c1d7217ULL, 0x000fe20007800000ULL,
0x00000100ff487424ULL, 0x000fe200078e00ffULL, 0x00000004004e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b437824ULL, 0x000fe200078e024cULL, 0x0000000600507810ULL, 0x000fe20007ffe0ffULL,
0x000000011d407824ULL, 0x000fe200078e0a40ULL, 0x000000f005497812ULL, 0x000fe200078ec0ffULL,
0x0000000143427824ULL, 0x000fc400078e020eULL, 0x00000010434b7824ULL, 0x000fe400078e00ffULL,
0x00000001411f7824ULL, 0x040fe400078e020eULL, 0x00000010414a7824ULL, 0x000fe200078e00ffULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee242ULL, 0x000000010b457824ULL, 0x040fe200078e024eULL,
0x000000400b427217ULL, 0x000fe20007800000ULL, 0x0000000141417824ULL, 0x000fe200078e0244ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee21fULL, 0x000000010b1d7824ULL, 0x000fe200078e0250ULL,
0x000160004b4b7811ULL, 0x000fe200078e20ffULL, 0x0000000145467824ULL, 0x000fc400078e020eULL,
0x00000010454d7824ULL, 0x000fe400078e00ffULL, 0x0000000143437824ULL, 0x000fe400078e0244ULL,
0x00005e0041407625ULL, 0x000fe200078e0048ULL, 0xfffffff04d4d7812ULL, 0x000fc600078ee246ULL,
0x00000001451f7824ULL, 0x100fe200078e0244ULL, 0x0000004940467210ULL, 0x000fe20007f1e0ffULL,
0x000000011d447824ULL, 0x000fe200078e0244ULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000011d457824ULL, 0x040fe400078e020eULL, 0x000000101d527824ULL, 0x000fe400078e00ffULL,
0x00000001421d7824ULL, 0x000fe400078e0a0bULL, 0x00005e0043427625ULL, 0x000fe200078e0048ULL,
0xfffffff0524f7812ULL, 0x000fc400078ee245ULL, 0x0000001d0000720cULL, 0x000fe20003f66070ULL,
0x000000ffff477224ULL, 0x000fe200000e0641ULL, 0x0000004942427210ULL, 0x000fe20007f9e0ffULL,
0x00005e001f407625ULL, 0x080fe200078e0048ULL, 0x0000001d4c00720cULL, 0x080fe40003f46070ULL,
0x0000001d4e00720cULL, 0x000fe20003f06070ULL, 0x00005e0044447625ULL, 0x000fe200078e0048ULL,
0x0000004940407210ULL, 0x000fe40007fbe0ffULL, 0x000160004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fe200020e0643ULL, 0x0000001d5000720cULL, 0x000fe20003f86070ULL,
0x000000ffff417224ULL, 0x000fe200028e0641ULL, 0x0000004944447210ULL, 0x000fc40007fde0ffULL,
0x000160004a1d7811ULL, 0x000fc600078e20ffULL, 0x000000ffff457224ULL, 0x000fe400030e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000461d7faeULL, 0x0003e8000d901c46ULL,
0x00000000424b7faeULL, 0x0003e8000d101c46ULL, 0x00000000404d7faeULL, 0x0003e8000c101c46ULL,
0x00000000444f7faeULL, 0x0003e2000e101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000010b1d7824ULL, 0x000fc800078e0200ULL, 0x000000011d1f7824ULL, 0x040fe200078e020eULL,
0x000000041d437810ULL, 0x040fe20007ffe0ffULL, 0x000000101d487824ULL, 0x040fe200078e00ffULL,
0x000000021d417810ULL, 0x040fe20007ffe0ffULL, 0x000000011d467824ULL, 0x040fe200078e0244ULL,
0x000000061d1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000143427824ULL, 0x140fe200078e020eULL,
0xfffffff048487812ULL, 0x000fe200078ee21fULL, 0x0000001043457824ULL, 0x000fe200078e00ffULL,
0x000000f0051f7812ULL, 0x000fe200078ec0ffULL, 0x0000000141407824ULL, 0x000fc400078e020eULL,
0x0000001041497824ULL, 0x000fe200078e00ffULL, 0xfffffff0454a7812ULL, 0x000fe200078ee242ULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x0000000143427824ULL, 0x000fe200078e0244ULL,
0xfffffff049497812ULL, 0x000fe200078ee240ULL, 0x00005e0046467625ULL, 0x000fc600078e0045ULL,
0x0001600049497811ULL, 0x000fe200078e20ffULL, 0x0000000141407824ULL, 0x100fe200078e0244ULL,
0x0000001f46467210ULL, 0x000fe20007f5e0ffULL, 0x000000011d447824ULL, 0x000fe400078e0244ULL,
0x00005e0040407625ULL, 0x000fc800078e0045ULL, 0x00005e0042427625ULL, 0x000fe200078e0045ULL,
0x0000001f40407210ULL, 0x000fc60007f1e0ffULL, 0x00005e0044447625ULL, 0x000fc800078e0045ULL,
0x000000011d4b7824ULL, 0x040fe200078e020eULL, 0x0000001f44447210ULL, 0x080fe20007f7e0ffULL,
0x000000101d4c7824ULL, 0x000fe200078e00ffULL, 0x00016000481d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200010e0647ULL, 0x0000001f42427210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff417224ULL, 0x000fe200000e0641ULL, 0xfffffff04c4b7812ULL, 0x000fe200078ee24bULL,
0x000000ffff457224ULL, 0x000fe200018e0645ULL, 0x000160004a1f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fe200010e0643ULL, 0x000160004b4b7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000461d7faeULL, 0x0003e8000b901c46ULL,
0x0000000040497faeULL, 0x0003e8000b901c46ULL, 0x00000000421f7faeULL, 0x0003e8000b901c46ULL,
0x00000000444b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff487f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018648000b447f8cULL, 0x0004e4000c80043fULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x01864c000b1d7984ULL, 0x000f240000000800ULL,
0x800000001dff7812ULL, 0x018fc40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240427210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011443ULL, 0x000000421d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0643ULL, 0x000000021d1d7819ULL, 0x000fc80000001242ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01864c000b1d7984ULL, 0x000ee40000000800ULL, 0x800000001dff7812ULL, 0x008fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01810000161d7984ULL, 0x000ee80000000800ULL,
0x01830000161f7984ULL, 0x0004620000000800ULL, 0x0000001e1d00720bULL, 0x008fe20003f1d000ULL,
0x0000e7227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000407806ULL, 0x004fc800000e0100ULL,
0x0000ffff40ff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff447424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000020d00780cULL, 0x000fe40003f05270ULL, 0x0000001e1d00720bULL, 0x000fe20003f54000ULL,
0x0000e7027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000417806ULL, 0x000fc400010e0100ULL,
0x0000001d1e438209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991041427816ULL, 0x000fc600000000ffULL, 0x0185004316008388ULL, 0x0005e20000000800ULL,
0x000000ff4200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001d1e437209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff41ff7812ULL, 0x000fc6000780c0ffULL, 0x800000431e427221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x0000004200437308ULL, 0x000ea40000000800ULL,
0x0000004308087220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff4d7819ULL, 0x000fe2000001160eULL, 0x0000e6527f007947ULL, 0x000fea000b800000ULL,
0x00001f4d43427589ULL, 0x0004e400000e0000ULL, 0x0000004220207220ULL, 0x088fe40000410000ULL,
0x0000004221217220ULL, 0x080fe40000410000ULL, 0x0000004224247220ULL, 0x080fe40000410000ULL,
0x0000004225257220ULL, 0x000fc40000410000ULL, 0x0000004228287220ULL, 0x080fe40000410000ULL,
0x0000004229297220ULL, 0x080fe40000410000ULL, 0x000000422c2c7220ULL, 0x080fe40000410000ULL,
0x000000422d2d7220ULL, 0x080fe40000410000ULL, 0x0000004230307220ULL, 0x080fe40000410000ULL,
0x0000004231317220ULL, 0x000fc40000410000ULL, 0x0000004234347220ULL, 0x080fe40000410000ULL,
0x0000004235357220ULL, 0x080fe40000410000ULL, 0x0000004238387220ULL, 0x080fe40000410000ULL,
0x0000004239397220ULL, 0x080fe40000410000ULL, 0x000000423c3c7220ULL, 0x080fe40000410000ULL,
0x000000423d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0041ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080e4d7811ULL, 0x006fe200078ff0ffULL, 0x0000e5627f007947ULL, 0x000fea000b800000ULL,
0x00001f4d43427589ULL, 0x0002a400000e0000ULL, 0x0000004222227220ULL, 0x084fe40000410000ULL,
0x0000004223237220ULL, 0x080fe40000410000ULL, 0x0000004226267220ULL, 0x080fe40000410000ULL,
0x0000004227277220ULL, 0x080fe40000410000ULL, 0x000000422a2a7220ULL, 0x080fe40000410000ULL,
0x000000422b2b7220ULL, 0x000fc40000410000ULL, 0x000000422e2e7220ULL, 0x080fe40000410000ULL,
0x000000422f2f7220ULL, 0x080fe40000410000ULL, 0x0000004232327220ULL, 0x080fe40000410000ULL,
0x0000004233337220ULL, 0x080fe40000410000ULL, 0x0000004236367220ULL, 0x080fe40000410000ULL,
0x0000004237377220ULL, 0x000fc40000410000ULL, 0x000000423a3a7220ULL, 0x080fe40000410000ULL,
0x000000423b3b7220ULL, 0x080fe40000410000ULL, 0x000000423e3e7220ULL, 0x080fe40000410000ULL,
0x000000423f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff41ff7812ULL, 0x000fe20007800840ULL, 0x00000001ff447424ULL, 0x000fe200078e00ffULL,
0x0000001d1e1e7209ULL, 0x000fd60007810000ULL, 0x8000001e1d1d0221ULL, 0x000fe20000010000ULL,
0x00007610ff440816ULL, 0x000fc60000000044ULL, 0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL,
0x0000001d00040308ULL, 0x000ea40000000800ULL, 0x000000041f1f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000081f087221ULL, 0x002fc40000010000ULL,
0x0000000000407805ULL, 0x000fca0000015200ULL, 0x0186ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240427210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011443ULL, 0x000000421d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0643ULL, 0x000000021d1d7819ULL, 0x000fc80000001242ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991044157816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1500720cULL, 0x000fda0003f45270ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000004ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff407819ULL, 0x000fe4000001160eULL, 0x0000541002157816ULL, 0x000fe20000000002ULL,
0x0000e1627f007947ULL, 0x000fea000b800000ULL, 0x00001f4015037589ULL, 0x0002a400000e0000ULL,
0x00000008404d7810ULL, 0x002fe20007ffe0ffULL, 0x0000e1b27f007947ULL, 0x000fea000b800000ULL,
0x00001f4d15027589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010404d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x0000a6a0004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0000ebc000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018404d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e0015ULL, 0x0000a710004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x0000eb5000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001750783bULL, 0x000f280000004200ULL,
0x00000000184c783bULL, 0x006e680000004200ULL, 0x000000001944783bULL, 0x000ea80000004200ULL,
0x000000001a40783bULL, 0x000fe20000004200ULL, 0x00000018ff157819ULL, 0x010fe20000011450ULL,
0x0000010050557824ULL, 0x040fe200078e00ffULL, 0x0000888050547816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe20000011451ULL,
0x0000010051607824ULL, 0x040fe200078e00ffULL, 0x00008880515f7816ULL, 0x040fe200000000ffULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000010053657824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe20000011452ULL,
0x000001004c6b7824ULL, 0x002fe200078e00ffULL, 0x0000005000577306ULL, 0x0003e20000200c00ULL,
0x0000888052637816ULL, 0x000fe200000000ffULL, 0x000001004e6f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fc40000011451ULL, 0x00000018ff4a7819ULL, 0x000fe40000011453ULL,
0x00000018ff5d7819ULL, 0x000fe2000001144cULL, 0x0000005100627306ULL, 0x000fe20000200c00ULL,
0x0000010052507824ULL, 0x042fe200078e00ffULL, 0x0000888053667816ULL, 0x040fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x000088804c6a7816ULL, 0x040fe200000000ffULL,
0x0001000053537824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011465ULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000018ff5e7819ULL, 0x000fc4000001144dULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff5b7819ULL, 0x000fe2000001144eULL, 0x0000006700517306ULL, 0x0003e20000200c00ULL,
0x00000018ff5c7819ULL, 0x000fe4000001144fULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000018ff597819ULL, 0x004fc40000011444ULL, 0x0000888044767816ULL, 0x000fe200000000ffULL,
0x0000005200657306ULL, 0x0005e20000200c00ULL, 0x000088804d677816ULL, 0x042fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x00000018ff5a7819ULL, 0x000fe20000011445ULL, 0x0000005300697306ULL, 0x0003e20000200c00ULL,
0x000001004d527824ULL, 0x044fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011446ULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011447ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000004c006c7306ULL, 0x0005e20000200c00ULL,
0x000088804e537816ULL, 0x042fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x00000052006e7306ULL, 0x0003e20000200c00ULL,
0x000001004f4c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc8000001146fULL,
0x00000018ff717819ULL, 0x000fe4000001144cULL, 0x0000004d006d7306ULL, 0x0005e20000200c00ULL,
0x000088804f527816ULL, 0x042fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x000130001b4c7811ULL, 0x000fca00078e20ffULL, 0x0000005300707306ULL, 0x0003e20000200c00ULL,
0x00000100444d7824ULL, 0x044fe400078e00ffULL, 0x0001000044447824ULL, 0x000fca00078e00ffULL,
0x0000005200737306ULL, 0x0005e20000200c00ULL, 0x00000018ff537819ULL, 0x002fe4000001144fULL,
0x00000018ff447819ULL, 0x000fca0000011444ULL, 0x0000004e00727306ULL, 0x0003e20000200c00ULL,
0x00000018ff527819ULL, 0x004fce000001144dULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x000000004c4c783bULL, 0x002e6e0000000200ULL, 0x0000006600667306ULL, 0x000f300000200c00ULL,
0x0000007100747306ULL, 0x0007e20000200c00ULL, 0x0000541063507816ULL, 0x004fce0000000050ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000010045717824ULL, 0x008fe200078e00ffULL,
0x0000541066517816ULL, 0x010fc80000000051ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000005500557306ULL, 0x000eb00000200c00ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x000000034c4ca232ULL, 0x002fc40000000000ULL, 0x000000034e4ea232ULL, 0x000fe40000000000ULL,
0x000000024d4da232ULL, 0x080fe40000000000ULL, 0x000000024f4fa232ULL, 0x000fe20000000000ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x0000541054547816ULL, 0x004fce0000000055ULL,
0x0000005300757306ULL, 0x0005f00000200c00ULL, 0x0000004400787306ULL, 0x0007e20000200c00ULL,
0x0000888045537816ULL, 0x044fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x000054105f557816ULL, 0x002fc80000000060ULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000005200777306ULL, 0x0003e20000200c00ULL, 0x0000010046447824ULL, 0x048fe200078e00ffULL,
0x000000544c20723cULL, 0x000be80000001820ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000005300797306ULL, 0x0005e20000200c00ULL, 0x0000888046527816ULL, 0x042fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000888040547816ULL, 0x020fc800000000ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x00000071007a7306ULL, 0x0003e20000200c00ULL,
0x0000888047537816ULL, 0x004fce00000000ffULL, 0x00000045007b7306ULL, 0x0005e20000200c00ULL,
0x0000010047717824ULL, 0x042fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x00000044007d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000010040457824ULL, 0x004fcc00078e00ffULL,
0x00000052007c7306ULL, 0x000fe20000200c00ULL, 0x000130001c447811ULL, 0x002fce00078e20ffULL,
0x00000053007f7306ULL, 0x0003f00000200c00ULL, 0x0000001500567306ULL, 0x0004e20000200c00ULL,
0x000000504c50723cULL, 0x002bee0000001828ULL, 0x00000046007e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff287819ULL, 0x020fe20000011445ULL, 0x00000100412a7824ULL, 0x040fe200078e00ffULL,
0x0000888041297816ULL, 0x000fc400000000ffULL, 0x00000018ff157819ULL, 0x004fe40000011442ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x00000047005f7306ULL, 0x0003e20000200c00ULL,
0x0000541057567816ULL, 0x008fce0000000056ULL, 0x0000001d00617306ULL, 0x0004e20000200c00ULL,
0x000000004444783bULL, 0x002e6e0000000200ULL, 0x0000001f00647306ULL, 0x0009220000200c00ULL,
0x00000018ff1d7819ULL, 0x004fce0000011443ULL, 0x0000004a00687306ULL, 0x0004a20000200c00ULL,
0x0000541062577816ULL, 0x008fe40000000061ULL, 0x00000018ff1f7819ULL, 0x010fe20000011440ULL,
0x0001000040407824ULL, 0x000fc800078e00ffULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000000564c24723cULL, 0x000f620000001824ULL, 0x0000541065647816ULL, 0x000fe40000000064ULL,
0x00000018ff4a7819ULL, 0x004fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x0000541069657816ULL, 0x000fe40000000068ULL, 0x00000018ff417819ULL, 0x000fca0000011441ULL,
0x0000005b005b7306ULL, 0x000f220000200c00ULL, 0x000054106c6c7816ULL, 0x008fe2000000005dULL,
0x000000644c2c723cULL, 0x000f62000000182cULL, 0x000000034444a232ULL, 0x082fe40000000000ULL,
0x000000034646a232ULL, 0x000fe40000000000ULL, 0x000000024545a232ULL, 0x080fe20000000000ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000054106d6d7816ULL, 0x004fe2000000005eULL,
0x000000024747a232ULL, 0x000fcc0000000000ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541072727816ULL, 0x010fe2000000005bULL, 0x0000006c4c34723cULL, 0x000f6c0000001834ULL,
0x0000006b006b7306ULL, 0x000ff00000200c00ULL, 0x0000006700677306ULL, 0x000e700000200c00ULL,
0x0000006f006f7306ULL, 0x000eb00000200c00ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0000541067557816ULL, 0x002fce000000006eULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x0000541070707816ULL, 0x004fce000000006fULL, 0x0000007100807306ULL, 0x0004f00000200c00ULL,
0x0000005400607306ULL, 0x0009e20000200c00ULL, 0x0000541073717816ULL, 0x004fe40000000074ULL,
0x0000541075737816ULL, 0x000fca000000005cULL, 0x0000002900627306ULL, 0x0005e20000200c00ULL,
0x000054106a547816ULL, 0x010fe2000000006bULL, 0x000000704c38723cULL, 0x040fec0000001838ULL,
0x0000002800617306ULL, 0x0009e20000200c00ULL, 0x0000010042297824ULL, 0x044fe200078e00ffULL,
0x000000544c54723cULL, 0x040b6c0000001830ULL, 0x0000002a00637306ULL, 0x000fe20000200c00ULL,
0x0000888042287816ULL, 0x050fe200000000ffULL, 0x000000724c3c723cULL, 0x000b64000000183cULL,
0x00000018ff307819ULL, 0x020fe20000011429ULL, 0x0000010043327824ULL, 0x000fe200078e00ffULL,
0x000054107b297816ULL, 0x002fe2000000005aULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x0000888043317816ULL, 0x040fe200000000ffULL, 0x00000028004c7306ULL, 0x0003e20000200c00ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc40000011432ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x0000541078287816ULL, 0x002fce0000000059ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000000284428723cULL, 0x000b6e0000001824ULL,
0x000054107c247816ULL, 0x020fe2000000007dULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x000054107f257816ULL, 0x008fce0000000080ULL, 0x00000030004d7306ULL, 0x0004e20000200c00ULL,
0x000000244424723cULL, 0x000f6e0000001850ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x000054107e307816ULL, 0x004fe4000000004bULL, 0x0000541076767816ULL, 0x002fc40000000077ULL,
0x0000541079777816ULL, 0x000fc6000000007aULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000054104c4c7816ULL, 0x008fc6000000004dULL, 0x000000764420723cULL, 0x000f680000001820ULL,
0x0000004000407306ULL, 0x000e700000200c00ULL, 0x0000004100417306ULL, 0x000eb00000200c00ULL,
0x00000031004f7306ULL, 0x0007e20000200c00ULL, 0x0000541040407816ULL, 0x002fce000000001fULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x000054105f317816ULL, 0x008fe40000000058ULL,
0x0000541041417816ULL, 0x004fca000000004aULL, 0x0000001500157306ULL, 0x000fe20000200c00ULL,
0x000000304430723cULL, 0x040b6e000000182cULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x00005410602c7816ULL, 0x020fe20000000061ULL, 0x000000404434723cULL, 0x000b620000001834ULL,
0x00005410622d7816ULL, 0x000fc40000000063ULL, 0x000054104f4d7816ULL, 0x002fc6000000004eULL,
0x0000004200427306ULL, 0x000e640000200c00ULL, 0x0000002c442c723cULL, 0x040b6c0000001854ULL,
0x0000004300507306ULL, 0x000ea40000200c00ULL, 0x0000004c4438723cULL, 0x000b620000001838ULL,
0x0000541042427816ULL, 0x002fc40000000015ULL, 0x0000541050437816ULL, 0x004fce000000001dULL,
0x000000424444723cULL, 0x000b62000000183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff407f8cULL, 0x020e62000c80043fULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x006fe40007804841ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff157819ULL, 0x000fc8000001143fULL,
0x0000003e15157211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x0000000215157819ULL, 0x000fc8000000123eULL, 0x000000150000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011d1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000a0063e7810ULL, 0x000fca0007ffe0ffULL, 0x0000620009407a24ULL, 0x000fe200078e023eULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x000000010b1d7824ULL, 0x000fe200078e0200ULL,
0x00000004004c7810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x0000003e0c157217ULL, 0x000fe20007800000ULL, 0x000000011d1f7824ULL, 0x040fe200078e020eULL,
0x00000002004a7810ULL, 0x000fe20007ffe0ffULL, 0x000000101d3c7824ULL, 0x000fe400078e00ffULL,
0x000000010b437824ULL, 0x000fe400078e024cULL, 0x00000001153e7824ULL, 0x000fe200078e0a3eULL,
0xfffffff03c1f7812ULL, 0x000fe200078ee21fULL, 0x000000011d3c7824ULL, 0x000fe200078e0240ULL,
0x000000f0051d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b157824ULL, 0x040fe200078e024aULL,
0x0000003e0b3e7217ULL, 0x000fe20007800000ULL, 0x0000000143427824ULL, 0x000fe200078e020eULL,
0x000140001f1f7811ULL, 0x000fe200078e20ffULL, 0x00000010434d7824ULL, 0x000fc400078e00ffULL,
0x00005e003c3c7625ULL, 0x000fc600078e0041ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL,
0x00000001153f7824ULL, 0x040fe200078e020eULL, 0x0000001d3c427210ULL, 0x000fe20007f1e0ffULL,
0x00000010154e7824ULL, 0x000fe200078e00ffULL, 0x000140004d4d7811ULL, 0x000fe200078e20ffULL,
0x00000001153c7824ULL, 0x100fe400078e0240ULL, 0x000000013e157824ULL, 0x000fe200078e0a0bULL,
0xfffffff04e4b7812ULL, 0x000fe200078ee23fULL, 0x00000001433f7824ULL, 0x000fe200078e0240ULL,
0x00000006004e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe200000e063dULL,
0x000000154a00720cULL, 0x000fe20003f66070ULL, 0x00005e003c3c7625ULL, 0x000fe200078e0041ULL,
0x000000150000720cULL, 0x000fc40003f86070ULL, 0x000000154c00720cULL, 0x000fe20003f06070ULL,
0x000000010b4f7824ULL, 0x000fe200078e024eULL, 0x0000001d3c3c7210ULL, 0x000fe20007fbe0ffULL,
0x00005e003f3e7625ULL, 0x000fe200078e0041ULL, 0x000140004b4b7811ULL, 0x000fc600078e20ffULL,
0x000000014f407824ULL, 0x040fe200078e0240ULL, 0x0000001d3e3e7210ULL, 0x000fe20007fde0ffULL,
0x000000014f4a7824ULL, 0x040fe400078e020eULL, 0x00005e0040407625ULL, 0x000fe200078e0041ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000421f7faeULL, 0x0003e6000e101c46ULL,
0x000000ffff3d7224ULL, 0x000fe200028e063dULL, 0x000000154e00720cULL, 0x000fe20003fa6070ULL,
0x000000104f4f7824ULL, 0x000fc400078e00ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063fULL,
0x0000001d40407210ULL, 0x000fe20007fde0ffULL, 0x000000003c4b7faeULL, 0x0003e2000d901c46ULL,
0xfffffff04f4a7812ULL, 0x000fc600078ee24aULL, 0x000000ffff417224ULL, 0x000fe200030e0641ULL,
0x000140004a157811ULL, 0x000fe200078e20ffULL, 0x000000003e4d7faeULL, 0x0003e8000c101c46ULL,
0x0000000040157faeULL, 0x0003e2000e901c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000010b157824ULL, 0x000fc800078e0200ULL, 0x00000001151d7824ULL, 0x040fe200078e020eULL,
0x00000002153d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001015427824ULL, 0x040fe200078e00ffULL,
0x00000004153f7810ULL, 0x000fc60007ffe0ffULL, 0x000000013d3c7824ULL, 0x140fe200078e020eULL,
0xfffffff0421f7812ULL, 0x000fe200078ee21dULL, 0x000000103d417824ULL, 0x000fe200078e00ffULL,
0x000000f0051d7812ULL, 0x000fe200078ec0ffULL, 0x000000013f3e7824ULL, 0x000fe200078e020eULL,
0x000140001f1f7811ULL, 0x000fe200078e20ffULL, 0x000000103f4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff0414a7812ULL, 0x000fe200078ee23cULL, 0x00000100ff417424ULL, 0x000fe400078e00ffULL,
0x0000000115427824ULL, 0x140fe200078e0240ULL, 0x0000000615157810ULL, 0x000fe20007ffe0ffULL,
0x000000013d3c7824ULL, 0x000fe200078e0240ULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee23eULL,
0x00005e0042427625ULL, 0x000fc600078e0041ULL, 0x000140004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000013f3e7824ULL, 0x100fe200078e0240ULL, 0x0000001d42427210ULL, 0x000fe20007f7e0ffULL,
0x0000000115407824ULL, 0x000fe400078e0240ULL, 0x00005e003c3c7625ULL, 0x000fc800078e0041ULL,
0x00005e003e3e7625ULL, 0x000fe200078e0041ULL, 0x0000001d3c3c7210ULL, 0x000fc60007f1e0ffULL,
0x00000001154c7824ULL, 0x000fe400078e020eULL, 0x00005e0040407625ULL, 0x000fc800078e0041ULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0x0000001d40407210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff437224ULL, 0x000fe200018e0643ULL, 0x0000001d3e3e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063dULL, 0xfffffff0154c7812ULL, 0x000fe200078ee24cULL,
0x000000ffff417224ULL, 0x000fe200020e0641ULL, 0x000140004a157811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e063fULL, 0x000140004c1d7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000421f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c157faeULL, 0x0003e8000b901c46ULL, 0x000000003e4b7faeULL, 0x0003e8000b901c46ULL,
0x00000000401d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff3c7f8cULL, 0x000e64000c80043fULL,
0x000000ffff157224ULL, 0x002fc400078e003dULL, 0x00000000003c7805ULL, 0x000fca0000015200ULL,
0x0186b400ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc8000001143fULL,
0x0000003e1d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x000000021d1d7819ULL, 0x000fc8000000123eULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x00000004ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff3c7819ULL, 0x000fe4000001160eULL,
0x00005410021d7816ULL, 0x000fe20000000002ULL, 0x0000c6c27f007947ULL, 0x000fea000b800000ULL,
0x00001f3c1d037589ULL, 0x0002a400000e0000ULL, 0x000000083c4d7810ULL, 0x002fe20007ffe0ffULL,
0x0000c7127f007947ULL, 0x000fea000b800000ULL, 0x00001f4d1d027589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000103c4d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200078e001dULL, 0x0000c230004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x0000d03000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000183c4d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x004fe200078e001dULL,
0x0000c2a0004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0000cfc000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000104c783bULL, 0x006e680000004200ULL, 0x000000000f48783bULL, 0x000ea80000004200ULL,
0x000000001240783bULL, 0x000f280000004200ULL, 0x00000000113c783bULL, 0x000ee20000004200ULL,
0x00000018ff507819ULL, 0x002fe2000001144eULL, 0x000001004f637824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe2000001144fULL, 0x000001004d5f7824ULL, 0x000fe200078e00ffULL,
0x0000005000627306ULL, 0x0003e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe2000001144cULL,
0x0000010048697824ULL, 0x004fe200078e00ffULL, 0x000088804e617816ULL, 0x000fe200000000ffULL,
0x000001004a6e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011448ULL,
0x0000010041767824ULL, 0x010fe200078e00ffULL, 0x000088804f647816ULL, 0x040fe200000000ffULL,
0x0000005100667306ULL, 0x0005e20000200c00ULL, 0x000088804c507816ULL, 0x002fe200000000ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x0000888048687816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fc40000011463ULL,
0x00000018ff5d7819ULL, 0x000fe20000011449ULL, 0x0000001d00527306ULL, 0x000fe20000200c00ULL,
0x000001004c517824ULL, 0x044fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00008880496a7816ULL, 0x000fe400000000ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000004f00677306ULL, 0x0003e20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fc4000001144aULL,
0x00000018ff5b7819ULL, 0x000fe4000001144bULL, 0x00000018ff1f7819ULL, 0x000fe4000001144dULL,
0x000088804d5e7816ULL, 0x040fe200000000ffULL, 0x0000004c00537306ULL, 0x0005220000200c00ULL,
0x000088804a4f7816ULL, 0x042fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011440ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x0000888040757816ULL, 0x000fc400000000ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x00000048006b7306ULL, 0x0003e20000200c00ULL, 0x000001004e4c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x000001004b487824ULL, 0x002fe200078e00ffULL,
0x0000004f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fc4000001145fULL,
0x00000018ff597819ULL, 0x000fe40000011441ULL, 0x00000018ff707819ULL, 0x000fe40000011448ULL,
0x0001300013487811ULL, 0x000fe200078e20ffULL, 0x0000004e00637306ULL, 0x0002a20000200c00ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000018ff567819ULL, 0x000fe40000011442ULL,
0x00000018ff577819ULL, 0x000fc40000011443ULL, 0x0000541053527816ULL, 0x010fe20000000052ULL,
0x0000004a00717306ULL, 0x000fe20000200c00ULL, 0x00000100494e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000001f00607306ULL, 0x0003e20000200c00ULL,
0x0000541063627816ULL, 0x004fc40000000062ULL, 0x0000541067637816ULL, 0x000fe40000000066ULL,
0x00000018ff547819ULL, 0x008fe4000001143cULL, 0x00000018ff1d7819ULL, 0x000fe2000001143eULL,
0x0000004e006d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff1f7819ULL, 0x002fe4000001143fULL,
0x00000018ff557819ULL, 0x000fca000001143dULL, 0x00000049006c7306ULL, 0x0003e20000200c00ULL,
0x000088804b4e7816ULL, 0x044fe200000000ffULL, 0x000100004b4b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144bULL, 0x0000004e00727306ULL, 0x0005e20000200c00ULL,
0x0000010040497824ULL, 0x042fe400078e00ffULL, 0x0001000040407824ULL, 0x000fca00078e00ffULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x00000018ff4e7819ULL, 0x004fe40000011449ULL,
0x000000004848783bULL, 0x000ea20000000200ULL, 0x00000018ff407819ULL, 0x000fc80000011440ULL,
0x0000006100617306ULL, 0x000ff00000200c00ULL, 0x0000004c004c7306ULL, 0x000ee20000200c00ULL,
0x000054104d537816ULL, 0x002fce0000000060ULL, 0x0000006400647306ULL, 0x000ff00000200c00ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x00005410614c7816ULL, 0x008fce000000004cULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000000034848a232ULL, 0x084fe40000000000ULL,
0x000000034a4aa232ULL, 0x000fe40000000000ULL, 0x000000024949a232ULL, 0x000fc60000000000ULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x000000024b4ba232ULL, 0x000fe20000000000ULL,
0x00005410644d7816ULL, 0x002fcc0000000065ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000624830723cULL, 0x040f6e0000001830ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000541050507816ULL, 0x004fe20000000051ULL, 0x000000524828723cULL, 0x000fec0000001828ULL,
0x0000004f00747306ULL, 0x0005f00000200c00ULL, 0x0000004000777306ULL, 0x0007e20000200c00ULL,
0x00008880414f7816ULL, 0x044fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x000054105e517816ULL, 0x002fc8000000005fULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000007000737306ULL, 0x000fe20000200c00ULL, 0x0000010042407824ULL, 0x008fe200078e00ffULL,
0x000000504820723cULL, 0x000be80000001820ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004e00707306ULL, 0x0003e20000200c00ULL, 0x000088803c507816ULL, 0x020fce00000000ffULL,
0x0000004f00787306ULL, 0x0005e20000200c00ULL, 0x00008880424e7816ULL, 0x042fe200000000ffULL,
0x0001000042427824ULL, 0x000fca00078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000007600797306ULL, 0x0003e20000200c00ULL, 0x00008880434f7816ULL, 0x004fce00000000ffULL,
0x00000041007a7306ULL, 0x0005e20000200c00ULL, 0x0000010043767824ULL, 0x042fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000040007c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x000001003c417824ULL, 0x044fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc800078e00ffULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0001300014407811ULL, 0x002fe400078e20ffULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000006900697306ULL, 0x000ff00000200c00ULL,
0x0000006a006a7306ULL, 0x000e700000200c00ULL, 0x0000004e007b7306ULL, 0x000ff00000200c00ULL,
0x0000004f007e7306ULL, 0x0005e20000200c00ULL, 0x000054106a517816ULL, 0x002fce000000006dULL,
0x00000042007d7306ULL, 0x000fe20000200c00ULL, 0x0000004c484c723cULL, 0x004bee0000001824ULL,
0x00000043005e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff247819ULL, 0x020fe20000011441ULL,
0x000001003d267824ULL, 0x040fe200078e00ffULL, 0x000088803d257816ULL, 0x000fc800000000ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x000000004040783bULL, 0x002e6e0000000200ULL, 0x0000005c005c7306ULL, 0x000ef00000200c00ULL,
0x0000005d005d7306ULL, 0x000f220000200c00ULL, 0x000054106f6e7816ULL, 0x004fc4000000006eULL,
0x00005410726f7816ULL, 0x000fca0000000073ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000054106b5c7816ULL, 0x008fe2000000005cULL, 0x0000006e4838723cULL, 0x000fec0000001838ULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x000054106c5d7816ULL, 0x010fce000000005dULL,
0x00000050005f7306ULL, 0x0009e20000200c00ULL, 0x00005410715a7816ULL, 0x004fe2000000005aULL,
0x0000005c4834723cULL, 0x000fe20000001834ULL, 0x000000034040a232ULL, 0x082fe20000000000ULL,
0x0000541078717816ULL, 0x000fe20000000079ULL, 0x000000034242a232ULL, 0x000fe40000000000ULL,
0x000000024141a232ULL, 0x080fe20000000000ULL, 0x00005410745b7816ULL, 0x008fe2000000005bULL,
0x0000002500617306ULL, 0x0003e20000200c00ULL, 0x0000541068507816ULL, 0x010fe20000000069ULL,
0x000000024343a232ULL, 0x000fc80000000000ULL, 0x0000005a4844723cULL, 0x000fe40000001844ULL,
0x0000002600627306ULL, 0x0005e20000200c00ULL, 0x000088803e257816ULL, 0x002fca00000000ffULL,
0x000000504850723cULL, 0x000b64000000182cULL, 0x0000002400607306ULL, 0x0003e20000200c00ULL,
0x000001003e267824ULL, 0x044fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fe400078e00ffULL,
0x000001003f2e7824ULL, 0x060fe200078e00ffULL, 0x000088803f2d7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x000100003d247824ULL, 0x002fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc4000001142eULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff2c7819ULL, 0x000fe40000011426ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff3f7819ULL, 0x000fca000001143fULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x0000541077587816ULL, 0x004fce0000000058ULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x000054107a597816ULL, 0x002fce0000000059ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000054107d567816ULL, 0x008fce0000000056ULL, 0x0000003c003d7306ULL, 0x000e620000200c00ULL,
0x000054105e577816ULL, 0x004fce0000000057ULL, 0x00000025003c7306ULL, 0x000ff00000200c00ULL,
0x0000002c00497306ULL, 0x000ea20000200c00ULL, 0x000054103d547816ULL, 0x002fce0000000054ULL,
0x0000002d004a7306ULL, 0x0003f00000200c00ULL, 0x00000048004b7306ULL, 0x000ee20000200c00ULL,
0x00000056402c723cULL, 0x002b620000001830ULL, 0x000054103c3c7816ULL, 0x004fcc0000000049ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x000054105f307816ULL, 0x020fe40000000060ULL,
0x0000541061317816ULL, 0x000fca0000000062ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x000054104a3d7816ULL, 0x008fe2000000004bULL, 0x000000304030723cULL, 0x040f6c0000001850ULL,
0x0000001f001f7306ULL, 0x000fe40000200c00ULL, 0x0000003c4038723cULL, 0x000f6c0000001838ULL,
0x0000007500757306ULL, 0x000e700000200c00ULL, 0x00000076007f7306ULL, 0x000eb00000200c00ULL,
0x00000024005c7306ULL, 0x0007220000200c00ULL, 0x0000541075707816ULL, 0x002fce0000000070ULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x000000584024723cULL, 0x048b6e0000001828ULL,
0x0000003f00487306ULL, 0x000ee20000200c00ULL, 0x000054107b287816ULL, 0x020fe2000000007cULL,
0x000000704020723cULL, 0x000b620000001820ULL, 0x000054107e297816ULL, 0x004fc4000000007fULL,
0x000054105c557816ULL, 0x010fe40000000055ULL, 0x000054103e3e7816ULL, 0x002fc6000000001dULL,
0x000000284028723cULL, 0x000b62000000184cULL, 0x00005410483f7816ULL, 0x008fce000000001fULL,
0x000000544034723cULL, 0x040b700000001834ULL, 0x0000003e403c723cULL, 0x000b620000001844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff407f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000a0061d7810ULL, 0x000fe20007ffe0ffULL, 0x01869800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff447224ULL, 0x002fc400078e0041ULL, 0x0000000c1d00720cULL, 0x000fda0003f06070ULL,
0x00003fa000000947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x0186bc00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240427210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc80000011443ULL,
0x000000421d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff427224ULL, 0x000fca00000e0643ULL,
0x000000021d1d7819ULL, 0x000fc80000001242ULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c006407810ULL, 0x000fca0007ffe0ffULL, 0x00006200091f7a24ULL, 0x000fe200078e0240ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x000000400c1d7217ULL, 0x000fe20007800000ULL,
0x000000010b417824ULL, 0x000fe200078e0200ULL, 0x00000002004a7810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000004004c7810ULL, 0x040fe20007ffe0ffULL,
0x000000011d407824ULL, 0x000fe200078e0a40ULL, 0x00000006004e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b427824ULL, 0x000fe400078e024aULL, 0x00000001411d7824ULL, 0x000fe200078e020eULL,
0x000000400b407217ULL, 0x040fe20007800000ULL, 0x000000010b447824ULL, 0x000fc400078e024cULL,
0x0000001041487824ULL, 0x000fe400078e00ffULL, 0x0000000142437824ULL, 0x140fe400078e020eULL,
0x0000001042467824ULL, 0x000fe200078e00ffULL, 0xfffffff048487812ULL, 0x000fe200078ee21dULL,
0x0000000144457824ULL, 0x040fe400078e020eULL, 0x0000001044507824ULL, 0x000fe200078e00ffULL,
0xfffffff046497812ULL, 0x000fe200078ee243ULL, 0x000000010b1d7824ULL, 0x000fc400078e024eULL,
0x0000000141417824ULL, 0x000fe200078e021fULL, 0xfffffff0504b7812ULL, 0x000fe200078ee245ULL,
0x000000011d467824ULL, 0x000fe200078e021fULL, 0x0001600049497811ULL, 0x000fe200078e20ffULL,
0x000000011d437824ULL, 0x000fe200078e020eULL, 0x000160004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000101d507824ULL, 0x000fe400078e00ffULL, 0x00000001401d7824ULL, 0x000fe400078e0a0bULL,
0x0000000142427824ULL, 0x000fe200078e021fULL, 0xfffffff0504d7812ULL, 0x000fe200078ee243ULL,
0x0000000144447824ULL, 0x000fe200078e021fULL, 0x000000f0051f7812ULL, 0x000fe200078ec0ffULL,
0x00005e0041407625ULL, 0x000fe200078e0047ULL, 0x0000001d0000720cULL, 0x000fc40003f66070ULL,
0x0000001d4a00720cULL, 0x000fe20003f46070ULL, 0x00005e0042427625ULL, 0x000fe200078e0047ULL,
0x0000001f40407210ULL, 0x000fe40007fbe0ffULL, 0x0000001d4c00720cULL, 0x000fe20003f26070ULL,
0x00005e0044447625ULL, 0x000fe200078e0047ULL, 0x0000001d4e00720cULL, 0x000fe40003f06070ULL,
0x0000001f42427210ULL, 0x000fe20007f9e0ffULL, 0x00005e0046467625ULL, 0x000fe200078e0047ULL,
0x00016000481d7811ULL, 0x000fc400078e20ffULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff417224ULL, 0x000fe200028e0641ULL, 0x0000001f44447210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff437224ULL, 0x000fe200020e0643ULL, 0x0000001f46467210ULL, 0x000fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000401d7faeULL, 0x0003e2000d901c46ULL,
0x000000ffff457224ULL, 0x000fe400028e0645ULL, 0x000000ffff477224ULL, 0x000fe200030e0647ULL,
0x0000000042497faeULL, 0x0003e8000d101c46ULL, 0x00000000444b7faeULL, 0x0003e8000c901c46ULL,
0x00000000464d7faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000010b1d7824ULL, 0x000fe200078e0200ULL, 0x000000f005497812ULL, 0x000fc600078ec0ffULL,
0x000000011d407824ULL, 0x140fe200078e020eULL, 0x000000021d417810ULL, 0x040fe20007ffe0ffULL,
0x000000101d457824ULL, 0x040fe200078e00ffULL, 0x000000041d437810ULL, 0x040fe20007ffe0ffULL,
0x000000011d467824ULL, 0x040fe200078e021fULL, 0x000000061d1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000141427824ULL, 0x000fe200078e020eULL, 0xfffffff045487812ULL, 0x000fe200078ee240ULL,
0x0000001041477824ULL, 0x000fe400078e00ffULL, 0x00000100ff457424ULL, 0x000fc400078e00ffULL,
0x0000000143447824ULL, 0x000fe200078e020eULL, 0xfffffff0474a7812ULL, 0x000fe200078ee242ULL,
0x00000010434b7824ULL, 0x000fe400078e00ffULL, 0x00005e0046467625ULL, 0x000fc600078e0045ULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee244ULL, 0x0000000141407824ULL, 0x100fe200078e021fULL,
0x0000004946467210ULL, 0x000fe20007f3e0ffULL, 0x0000000143427824ULL, 0x100fe200078e021fULL,
0x000160004b4b7811ULL, 0x000fe200078e20ffULL, 0x000000011d447824ULL, 0x000fe400078e021fULL,
0x00005e0040407625ULL, 0x000fc800078e0045ULL, 0x00005e0042427625ULL, 0x000fe200078e0045ULL,
0x0000004940407210ULL, 0x000fc60007f1e0ffULL, 0x00005e0044447625ULL, 0x000fc800078e0045ULL,
0x000000011d1f7824ULL, 0x040fe200078e020eULL, 0x0000004944447210ULL, 0x080fe20007f5e0ffULL,
0x000000101d4c7824ULL, 0x000fe200078e00ffULL, 0x00016000481d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200008e0647ULL, 0x0000004942427210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff417224ULL, 0x000fe200000e0641ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee21fULL,
0x000000ffff457224ULL, 0x000fe200010e0645ULL, 0x000160004a1f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fe200008e0643ULL, 0x000160004c497811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000461d7faeULL, 0x0003e8000b901c46ULL,
0x00000000401f7faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e8000b901c46ULL,
0x0000000044497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff407f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018668000b467f8cULL, 0x0004e4000c80043fULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x01866c000b1d7984ULL, 0x000f240000000800ULL,
0x800000001dff7812ULL, 0x018fc40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011445ULL, 0x000000441d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x000000021d1d7819ULL, 0x000fc80000001244ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01866c000b1d7984ULL, 0x000ee40000000800ULL, 0x800000001dff7812ULL, 0x008fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01818000161d7984ULL, 0x000ee80000000800ULL,
0x01838000161f7984ULL, 0x0004620000000800ULL, 0x0000001e1d00720bULL, 0x008fe20003f1d000ULL,
0x0000ab427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000447806ULL, 0x004fc800000e0100ULL,
0x0000ffff44ff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff467424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000030d00780cULL, 0x000fe40003f05270ULL, 0x0000001e1d00720bULL, 0x000fe20003f34000ULL,
0x0000ab227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000437806ULL, 0x000fc400008e0100ULL,
0x0000001e1d458209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991043427816ULL, 0x000fc600000000ffULL, 0x0185804516008388ULL, 0x0005e20000000800ULL,
0x000000ff4200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001e1d457209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff43ff7812ULL, 0x000fc6000780c0ffULL, 0x0000001e45167221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b16167820ULL, 0x000fc80000410000ULL, 0x0000001600457308ULL, 0x000ea40000000800ULL,
0x0000004508087220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff4d7819ULL, 0x000fe2000001160eULL, 0x0000aa727f007947ULL, 0x000fea000b800000ULL,
0x00001f4d45167589ULL, 0x0004e400000e0000ULL, 0x0000001620207220ULL, 0x088fe40000410000ULL,
0x0000001621217220ULL, 0x080fe40000410000ULL, 0x0000001624247220ULL, 0x080fe40000410000ULL,
0x0000001625257220ULL, 0x000fc40000410000ULL, 0x0000001628287220ULL, 0x080fe40000410000ULL,
0x0000001629297220ULL, 0x080fe40000410000ULL, 0x000000162c2c7220ULL, 0x080fe40000410000ULL,
0x000000162d2d7220ULL, 0x080fe40000410000ULL, 0x0000001630307220ULL, 0x080fe40000410000ULL,
0x0000001631317220ULL, 0x000fc40000410000ULL, 0x0000001634347220ULL, 0x080fe40000410000ULL,
0x0000001635357220ULL, 0x080fe40000410000ULL, 0x0000001638387220ULL, 0x080fe40000410000ULL,
0x0000001639397220ULL, 0x080fe40000410000ULL, 0x000000163c3c7220ULL, 0x080fe40000410000ULL,
0x000000163d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0043ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080e4d7811ULL, 0x006fe200078ff0ffULL, 0x0000a9827f007947ULL, 0x000fea000b800000ULL,
0x00001f4d45167589ULL, 0x0002a400000e0000ULL, 0x0000001622227220ULL, 0x084fe40000410000ULL,
0x0000001623237220ULL, 0x080fe40000410000ULL, 0x0000001626267220ULL, 0x080fe40000410000ULL,
0x0000001627277220ULL, 0x080fe40000410000ULL, 0x000000162a2a7220ULL, 0x080fe40000410000ULL,
0x000000162b2b7220ULL, 0x000fc40000410000ULL, 0x000000162e2e7220ULL, 0x080fe40000410000ULL,
0x000000162f2f7220ULL, 0x080fe40000410000ULL, 0x0000001632327220ULL, 0x080fe40000410000ULL,
0x0000001633337220ULL, 0x080fe40000410000ULL, 0x0000001636367220ULL, 0x080fe40000410000ULL,
0x0000001637377220ULL, 0x000fc40000410000ULL, 0x000000163a3a7220ULL, 0x080fe40000410000ULL,
0x000000163b3b7220ULL, 0x080fe40000410000ULL, 0x000000163e3e7220ULL, 0x080fe40000410000ULL,
0x000000163f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff43ff7812ULL, 0x000fe20007800844ULL, 0x00000001ff467424ULL, 0x000fe200078e00ffULL,
0x0000001e1d1e7209ULL, 0x000fd60007810000ULL, 0x8000001e1d1d0221ULL, 0x000fe20000010000ULL,
0x00007610ff460816ULL, 0x000fc60000000046ULL, 0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL,
0x0000001d00040308ULL, 0x000ea40000000800ULL, 0x000000041f1f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000081f087221ULL, 0x002fc40000010000ULL,
0x0000000000427805ULL, 0x000fca0000015200ULL, 0x0186ac00ff167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x00000044421d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000145447824ULL, 0x000fe200000e0e43ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff4400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff4400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011444ULL, 0x0000001d16167211ULL, 0x000fca00078110ffULL,
0x000000ffff1d7224ULL, 0x000fca00000e0644ULL, 0x0000000216167819ULL, 0x000fc8000000121dULL,
0x000000160000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff167984ULL, 0x000e640000000800ULL, 0x8000000016ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991046157816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1500720cULL, 0x000fda0003f25270ULL,
0x0000016000001947ULL, 0x000fea0003800000ULL, 0x00000004ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff167819ULL, 0x000fe4000001160eULL, 0x0000541002157816ULL, 0x000fe20000000002ULL,
0x0000a5827f007947ULL, 0x000fea000b800000ULL, 0x00001f1615037589ULL, 0x0002a400000e0000ULL,
0x00000008164d7810ULL, 0x002fe20007ffe0ffULL, 0x0000a5d27f007947ULL, 0x000fea000b800000ULL,
0x00001f4d15027589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010164d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x0000e600004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0000ac6000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018164d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x004fe200078e0015ULL, 0x0000e670004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x0000abf000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000174c783bULL, 0x006e620000004200ULL,
0x000138001b1b7811ULL, 0x000fe400078e20ffULL, 0x000138001c1c7811ULL, 0x000fe200078e20ffULL,
0x000000001850783bULL, 0x0003e80000004200ULL, 0x000000001948783bULL, 0x0005280000004200ULL,
0x000000001a44783bULL, 0x0007220000004200ULL, 0x000088804c187816ULL, 0x042fe200000000ffULL,
0x000001004c197824ULL, 0x044fe200078e00ffULL, 0x000088804d1a7816ULL, 0x048fe200000000ffULL,
0x000001004d5b7824ULL, 0x000fe200078e00ffULL, 0x0000001800597306ULL, 0x0003e20000200c00ULL,
0x00000018ff157819ULL, 0x000fe2000001144cULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000010049707824ULL, 0x010fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x000001004a747824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000001a005d7306ULL, 0x0005e20000200c00ULL,
0x000100004d187824ULL, 0x002fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011448ULL,
0x00008880486e7816ULL, 0x000fe400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000019005a7306ULL, 0x0002e20000200c00ULL, 0x000001004e1a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe4000001144dULL, 0x00000018ff727819ULL, 0x000fe40000011470ULL,
0x00000018ff1a7819ULL, 0x000fc4000001141aULL, 0x0000001800607306ULL, 0x0005e20000200c00ULL,
0x000088804e197816ULL, 0x042fe400000000ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001144fULL,
0x00000018ff1d7819ULL, 0x000fe2000001144eULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011449ULL, 0x0000005b005e7306ULL, 0x0003e20000200c00ULL,
0x000100004f187824ULL, 0x004fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fc4000001144bULL,
0x0000888049717816ULL, 0x040fe200000000ffULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000001900617306ULL, 0x0005e20000200c00ULL,
0x000088804f5b7816ULL, 0x002fe400000000ffULL, 0x000088804b777816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000001a00627306ULL, 0x0003220000200c00ULL, 0x0000888050197816ULL, 0x004fc400000000ffULL,
0x00000018ff577819ULL, 0x000fe40000011450ULL, 0x00000018ff587819ULL, 0x000fe40000011451ULL,
0x00000018ff557819ULL, 0x000fe20000011452ULL, 0x0000005b00637306ULL, 0x0005e20000200c00ULL,
0x00000100501a7824ULL, 0x042fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011453ULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00005410595a7816ULL, 0x008fe4000000005aULL,
0x00000018ff1a7819ULL, 0x000fc4000001141aULL, 0x0000001800667306ULL, 0x0003e20000200c00ULL,
0x00008880515b7816ULL, 0x004fe400000000ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000541061627816ULL, 0x010fe40000000062ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000001900677306ULL, 0x0005e20000200c00ULL, 0x0000888052187816ULL, 0x002fe400000000ffULL,
0x00000018ff177819ULL, 0x000fca0000011444ULL, 0x0000005b00697306ULL, 0x0003e20000200c00ULL,
0x0000010052197824ULL, 0x044fe400078e00ffULL, 0x0001000052527824ULL, 0x000fc600078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018006a7306ULL, 0x0005e20000200c00ULL,
0x00000100535b7824ULL, 0x002fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fc80000011452ULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x0000001a00687306ULL, 0x0002e20000200c00ULL,
0x0000010048187824ULL, 0x044fe400078e00ffULL, 0x0001000048487824ULL, 0x000fca00078e00ffULL,
0x0000004c004d7306ULL, 0x0005e20000200c00ULL, 0x00008880531a7816ULL, 0x042fe200000000ffULL,
0x0001000053537824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc80000011448ULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000005b006d7306ULL, 0x0003e20000200c00ULL,
0x000001004f4c7824ULL, 0x004fe200078e00ffULL, 0x0000541067687816ULL, 0x008fc80000000068ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000019006b7306ULL, 0x000ea20000200c00ULL,
0x00000018ff5b7819ULL, 0x002fce0000011418ULL, 0x0000001a006c7306ULL, 0x0002f00000200c00ULL,
0x00000015005c7306ULL, 0x0009220000200c00ULL, 0x000000001b18783bULL, 0x002e620000000200ULL,
0x000054106a6a7816ULL, 0x004fcc000000006bULL, 0x0000004800707306ULL, 0x0005e20000200c00ULL,
0x000054106c6b7816ULL, 0x008fe4000000006dULL, 0x00000018ff157819ULL, 0x010fca0000011446ULL,
0x0000004c004c7306ULL, 0x000ee20000200c00ULL, 0x000001004b487824ULL, 0x004fe200078e00ffULL,
0x000054104d5c7816ULL, 0x000fe2000000005cULL, 0x000100004b4b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000001f00657306ULL, 0x0005220000200c00ULL,
0x00000018ff4b7819ULL, 0x000fce000001144bULL, 0x0000005b006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1f7819ULL, 0x004fe4000001144aULL, 0x0000541063637816ULL, 0x008fca000000004cULL,
0x0000004800787306ULL, 0x0005e20000200c00ULL, 0x000088804a5b7816ULL, 0x042fe200000000ffULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x0000000318189232ULL, 0x080fe20000000000ULL,
0x0000541066657816ULL, 0x010fe20000000065ULL, 0x000000031a1a9232ULL, 0x000fe40000000000ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000004e004f7306ULL, 0x0003e20000200c00ULL,
0x0000888044487816ULL, 0x004fe200000000ffULL, 0x0000000219199232ULL, 0x000fc40000000000ULL,
0x000000021b1b9232ULL, 0x000fe40000000000ULL, 0x000000ffff4d7224ULL, 0x000fe400078e0048ULL,
0x0000010044487824ULL, 0x040fe200078e00ffULL, 0x0000004900737306ULL, 0x000fe20000200c00ULL,
0x00000100514e7824ULL, 0x042fe200078e00ffULL, 0x000000621828723cULL, 0x000fe20000001828ULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe20000011448ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc4000001144eULL,
0x0000004a00767306ULL, 0x000fe20000200c00ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000006a1838723cULL, 0x000fe20000001838ULL, 0x00000018ff447819ULL, 0x000fca0000011444ULL,
0x0000004b00597306ULL, 0x0003f00000200c00ULL, 0x00000016005f7306ULL, 0x0005e20000200c00ULL,
0x000000001c48783bULL, 0x002e6e0000000200ULL, 0x0000001d00647306ULL, 0x0007220000200c00ULL,
0x00000018ff167819ULL, 0x004fce0000011447ULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00000018ff1d7819ULL, 0x008fce0000011445ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000054104f647816ULL, 0x010fce0000000064ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000064182c723cULL, 0x000fee000000182cULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000000348489232ULL, 0x082fe40000000000ULL, 0x000000034a4a9232ULL, 0x000fc40000000000ULL,
0x0000000249499232ULL, 0x080fe40000000000ULL, 0x000000024b4b9232ULL, 0x000fe20000000000ULL,
0x0000004e004e7306ULL, 0x000e700000200c00ULL, 0x0000005000507306ULL, 0x000eb00000200c00ULL,
0x0000005100517306ULL, 0x000ee20000200c00ULL, 0x0000541069697816ULL, 0x002fc4000000004eULL,
0x00008880464e7816ULL, 0x000fca00000000ffULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x0000541050507816ULL, 0x004fe20000000057ULL, 0x000000681830723cULL, 0x000fec0000001830ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000541051517816ULL, 0x008fce0000000058ULL,
0x0000005b00757306ULL, 0x0007e20000200c00ULL, 0x0000541052527816ULL, 0x002fe20000000055ULL,
0x000000501834723cULL, 0x000bec0000001834ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000054105d5b7816ULL, 0x008fe2000000005eULL, 0x0000010047517824ULL, 0x020fe200078e00ffULL,
0x00005410605d7816ULL, 0x000fc4000000005fULL, 0x0000541053537816ULL, 0x004fe40000000056ULL,
0x0000888047507816ULL, 0x040fe200000000ffULL, 0x0000005a1820723cULL, 0x000b620000001820ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0001000047477824ULL, 0x000fc800078e00ffULL, 0x00008880455a7816ULL, 0x060fe200000000ffULL,
0x0000005c1824723cULL, 0x040f620000001824ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x000000ffff4f7224ULL, 0x000fe400078e005aULL,
0x00000100455a7824ULL, 0x040fe400078e00ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x00000052183c723cULL, 0x000b62000000183cULL,
0x00000018ff5a7819ULL, 0x000fc4000001145aULL, 0x00000018ff457819ULL, 0x000fc80000011445ULL,
0x0000005400547306ULL, 0x000ee20000200c00ULL, 0x0000010046187824ULL, 0x060fe200078e00ffULL,
0x0000541071197816ULL, 0x002fe20000000072ULL, 0x0001000046467824ULL, 0x000fca00078e00ffULL,
0x00000045001c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff467819ULL, 0x000fce0000011446ULL,
0x0000007400747306ULL, 0x000f220000200c00ULL, 0x00000018ff457819ULL, 0x002fe40000011418ULL,
0x000054106e187816ULL, 0x000fca000000006fULL, 0x0000007700777306ULL, 0x000e640000200c00ULL,
0x000000184818723cULL, 0x000b6c0000001820ULL, 0x0000001f001f7306ULL, 0x000e620000200c00ULL,
0x0000541070207816ULL, 0x024fe40000000043ULL, 0x0000541073217816ULL, 0x008fca0000000054ULL,
0x0000004200427306ULL, 0x000ea40000200c00ULL, 0x000000204820723cULL, 0x000b6c0000001824ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541075247816ULL, 0x030fe40000000074ULL,
0x0000541077257816ULL, 0x002fca0000000078ULL, 0x0000004c004c7306ULL, 0x000e640000200c00ULL,
0x000000244824723cULL, 0x000b6c0000001828ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541076287816ULL, 0x020fe4000000001fULL, 0x0000541059297816ULL, 0x004fca0000000042ULL,
0x0000005a005a7306ULL, 0x000ea40000200c00ULL, 0x000000284828723cULL, 0x000b6c000000182cULL,
0x0000001700177306ULL, 0x000fe20000200c00ULL, 0x000054104d2c7816ULL, 0x022fce000000004cULL,
0x0000001d001d7306ULL, 0x000e620000200c00ULL, 0x000054104f2d7816ULL, 0x004fce000000005aULL,
0x0000004400447306ULL, 0x000ea20000200c00ULL, 0x0000002c482c723cULL, 0x000b6e0000001830ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x000054101c317816ULL, 0x022fce000000001dULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x0000541044307816ULL, 0x004fce0000000017ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000000304830723cULL, 0x000b6e0000001834ULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x000054104e347816ULL, 0x022fce0000000045ULL,
0x0000001500157306ULL, 0x000ff00000200c00ULL, 0x0000001600167306ULL, 0x000fe20000200c00ULL,
0x0000541050357816ULL, 0x004fce0000000051ULL, 0x0000004600467306ULL, 0x000e620000200c00ULL,
0x000000344834723cULL, 0x000b6e0000001838ULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x0000541046387816ULL, 0x022fe40000000015ULL, 0x0000541047397816ULL, 0x004fce0000000016ULL,
0x000000384838723cULL, 0x000b62000000183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff3c7f8cULL, 0x020e62000c80043fULL, 0x000000ffff1f7224ULL, 0x000fce00078e00ffULL,
0x0000000000167805ULL, 0x000fc40000015200ULL, 0x0186bc00ff157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x006fe4000780483dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c161c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e17ULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff157819ULL, 0x000fc8000001141dULL,
0x0000001c15157211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x0000000215157819ULL, 0x000fc8000000121cULL, 0x000000150000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000207157810ULL, 0x000fc80007ffe0ffULL, 0x0000000a1500720cULL, 0x000fe40003f06070ULL,
0x000000e006157810ULL, 0x000fca0007ffe0ffULL, 0x00006200093c7a24ULL, 0x000fcc00078e0215ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x0000000200447810ULL, 0x040fe20007ffe0ffULL,
0x000000010b177824ULL, 0x040fe200078e0200ULL, 0x0000000400467810ULL, 0x000fe40007ffe0ffULL,
0x000000150c067217ULL, 0x000fe20007800000ULL, 0x000000010b1d7824ULL, 0x040fe200078e0244ULL,
0x0000000600487810ULL, 0x000fe20007ffe0ffULL, 0x000000010b3f7824ULL, 0x000fe400078e0246ULL,
0x0000000117167824ULL, 0x040fe400078e020eULL, 0x00000010173d7824ULL, 0x000fc400078e00ffULL,
0x000000011d1c7824ULL, 0x040fe400078e020eULL, 0x000000101d437824ULL, 0x000fe200078e00ffULL,
0xfffffff03d427812ULL, 0x000fe200078ee216ULL, 0x000000013f1f7824ULL, 0x040fe400078e020eULL,
0x000000103f3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff043437812ULL, 0x000fe200078ee21cULL,
0x0000000106067824ULL, 0x000fe400078e0a15ULL, 0x00000100ff3d7424ULL, 0x000fe200078e00ffULL,
0xfffffff03e457812ULL, 0x000fe200078ee21fULL, 0x0000000117167824ULL, 0x100fe200078e023cULL,
0x000000f0051f7812ULL, 0x000fe200078ec0ffULL, 0x000000011d1c7824ULL, 0x000fe200078e023cULL,
0x000000060b067217ULL, 0x040fe20007800000ULL, 0x000000010b057824ULL, 0x000fe200078e0248ULL,
0x0001400043437811ULL, 0x000fe200078e20ffULL, 0x00005e0016167625ULL, 0x000fe200078e003dULL,
0x0001400045457811ULL, 0x000fc600078e20ffULL, 0x000000013f157824ULL, 0x000fe200078e023cULL,
0x0000001f163e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e001c1c7625ULL, 0x000fc800078e003dULL,
0x00000001053f7824ULL, 0x040fe200078e020eULL, 0x0000001f1c1c7210ULL, 0x000fe20007f9e0ffULL,
0x00000010054a7824ULL, 0x040fe400078e00ffULL, 0x00000001053c7824ULL, 0x000fe400078e023cULL,
0x0000000106057824ULL, 0x000fe200078e0a0bULL, 0xfffffff04a067812ULL, 0x000fe200078ee23fULL,
0x000000ffff3f7224ULL, 0x000fe400000e0617ULL, 0x00005e0015167625ULL, 0x000fe200078e003dULL,
0x000000050000720cULL, 0x000fc40003f66070ULL, 0x000000054400720cULL, 0x000fe20003f46070ULL,
0x00005e003c3c7625ULL, 0x000fe200078e003dULL, 0x000000054600720cULL, 0x000fe40003f06070ULL,
0x0000001f16167210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x000000054800720cULL, 0x000fe40003f86070ULL, 0x0000001f3c3c7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x0001400042057811ULL, 0x000fc400078e20ffULL,
0x0001400006157811ULL, 0x000fe200078e20ffULL, 0x000000ffff3d7224ULL, 0x000fe400030e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e057faeULL, 0x0003e8000d901c46ULL,
0x000000001c437faeULL, 0x0003e8000d101c46ULL, 0x0000000016457faeULL, 0x0003e8000c101c46ULL,
0x000000003c157faeULL, 0x0003e2000e101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000010b157824ULL, 0x000fe200078e0200ULL, 0x000000f005057812ULL, 0x000fc600078ec0ffULL,
0x0000000115007824ULL, 0x040fe200078e020eULL, 0x0000000215177810ULL, 0x040fe20007ffe0ffULL,
0x00000010151f7824ULL, 0x040fe200078e00ffULL, 0x00000004151d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001153e7824ULL, 0x040fe200078e023cULL, 0x0000000615157810ULL, 0x000fe20007ffe0ffULL,
0x0000000117067824ULL, 0x000fe200078e020eULL, 0xfffffff01f007812ULL, 0x000fe200078ee200ULL,
0x00000010173d7824ULL, 0x000fe400078e00ffULL, 0x000000011d167824ULL, 0x000fc400078e020eULL,
0x000000101d3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff03d067812ULL, 0x000fe200078ee206ULL,
0x00000100ff3d7424ULL, 0x000fe400078e00ffULL, 0x000000011d1c7824ULL, 0x000fe200078e023cULL,
0xfffffff03f1f7812ULL, 0x000fe200078ee216ULL, 0x00005e003e3e7625ULL, 0x000fc600078e003dULL,
0x000140001f1f7811ULL, 0x000fe200078e20ffULL, 0x0000000117167824ULL, 0x100fe200078e023cULL,
0x000000053e3e7210ULL, 0x000fe20007f5e0ffULL, 0x00000001153c7824ULL, 0x000fe400078e023cULL,
0x00005e0016167625ULL, 0x000fc800078e003dULL, 0x00005e001c1c7625ULL, 0x000fe200078e003dULL,
0x0000000516167210ULL, 0x000fc60007f1e0ffULL, 0x0000000115427824ULL, 0x000fe400078e020eULL,
0x00005e003c3c7625ULL, 0x000fc800078e003dULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x000000053c3c7210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e063fULL,
0x000000051c1c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0xfffffff015427812ULL, 0x000fe200078ee242ULL, 0x000000ffff3d7224ULL, 0x000fe200018e063dULL,
0x0001400000057811ULL, 0x000fe200078e20ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x0001400006157811ULL, 0x000fe400078e20ffULL, 0x0001400042437811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e057faeULL, 0x0003e8000b901c46ULL,
0x0000000016157faeULL, 0x0003e8000b901c46ULL, 0x000000001c1f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c437faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff167f8cULL, 0x002e64000c80043fULL,
0x000000ffff157224ULL, 0x002fc400078e0017ULL, 0x0000000000167805ULL, 0x000fca0000015200ULL,
0x0186b400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804841ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c16057210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1c7824ULL, 0x000fe200000e0e17ULL, 0x003d09000500780cULL, 0x000fc80003f06070ULL,
0x000000ff1c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400500780cULL, 0x000fc80003f06070ULL, 0x000000ff1c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001141cULL,
0x0000000500007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e061cULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x00000004ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff057819ULL, 0x000fe4000001160eULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x00008aa27f007947ULL, 0x000fea000b800000ULL,
0x00001f0500037589ULL, 0x0002a400000e0000ULL, 0x00000008054d7810ULL, 0x002fe20007ffe0ffULL,
0x00008af27f007947ULL, 0x000fea000b800000ULL, 0x00001f4d00027589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010054d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0000ULL, 0x000101d0004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x0000909000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018054d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x004fe200078e0000ULL,
0x00010240004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0000902000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000f48783bULL, 0x000f220000004200ULL, 0x0001380013137811ULL, 0x000fe400078e20ffULL,
0x0001380014147811ULL, 0x000fe200078e20ffULL, 0x000000001040783bULL, 0x0008680000004200ULL,
0x000000001244783bULL, 0x000ee80000004200ULL, 0x00000000113c783bULL, 0x0004e20000004200ULL,
0x00000018ff107819ULL, 0x010fc40000011449ULL, 0x00000018ff0f7819ULL, 0x000fe40000011448ULL,
0x0000001000617306ULL, 0x0009e20000200c00ULL, 0x00000018ff007819ULL, 0x002fe20000011440ULL,
0x0000010040117824ULL, 0x044fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fe20000011441ULL,
0x00000100414f7824ULL, 0x040fe200078e00ffULL, 0x0000888041127816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x00000000004e7306ULL, 0x000fe20000200c00ULL,
0x0000888040107816ULL, 0x050fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff067819ULL, 0x000fc40000011442ULL, 0x00000018ff167819ULL, 0x000fe40000011443ULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x00000010004c7306ULL, 0x0003e20000200c00ULL,
0x0000888043577816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x008fe40000011444ULL,
0x00000018ff1d7819ULL, 0x000fe40000011445ULL, 0x00000018ff177819ULL, 0x000fe20000011447ULL,
0x00000011004d7306ULL, 0x0004e20000200c00ULL, 0x0001000041107824ULL, 0x002fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x00000018ff1f7819ULL, 0x000fe4000001144aULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000004000417306ULL, 0x0003220000200c00ULL,
0x0000888042117816ULL, 0x004fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001144bULL,
0x00000018ff007819ULL, 0x000fc6000001143eULL, 0x0000001200507306ULL, 0x0005e20000200c00ULL,
0x0000010043407824ULL, 0x042fe200078e00ffULL, 0x000054104c4c7816ULL, 0x008fe2000000004dULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000001100537306ULL, 0x0003e20000200c00ULL, 0x0000010042127824ULL, 0x044fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x0000004000587306ULL, 0x0005e20000200c00ULL,
0x0000010048117824ULL, 0x002fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fc80000011442ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000001000527306ULL, 0x0003e20000200c00ULL,
0x0000010049407824ULL, 0x004fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000001200547306ULL, 0x0005e20000200c00ULL, 0x0000888048107816ULL, 0x042fe200000000ffULL,
0x0001000048487824ULL, 0x000fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x00000010005b7306ULL, 0x0003e20000200c00ULL, 0x0000888049127816ULL, 0x044fe200000000ffULL,
0x0001000049497824ULL, 0x000fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x00000011005e7306ULL, 0x0005e20000200c00ULL, 0x000088804a107816ULL, 0x002fce00000000ffULL,
0x0000004000627306ULL, 0x0003e20000200c00ULL, 0x000001004a117824ULL, 0x044fe400078e00ffULL,
0x000100004a4a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000012005f7306ULL, 0x0005e20000200c00ULL, 0x000001004b407824ULL, 0x002fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fc8000001144aULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000001000637306ULL, 0x0003e20000200c00ULL, 0x000088804b127816ULL, 0x044fe200000000ffULL,
0x000100004b4b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x00000040006a7306ULL, 0x0005e20000200c00ULL, 0x0000010044107824ULL, 0x002fce00078e00ffULL,
0x0000001100667306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x004fce0000011410ULL,
0x0000001200657306ULL, 0x0003f00000200c00ULL, 0x0000004200567306ULL, 0x0005e20000200c00ULL,
0x000000001310783bULL, 0x002e6e0000000200ULL, 0x0000000500517306ULL, 0x0006620000200c00ULL,
0x0000888044427816ULL, 0x044fe200000000ffULL, 0x0001000044447824ULL, 0x000fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x00000043005a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff057819ULL, 0x008fce000001143fULL, 0x00000044006b7306ULL, 0x0007e20000200c00ULL,
0x0000888045437816ULL, 0x004fce00000000ffULL, 0x00000040006c7306ULL, 0x0005e20000200c00ULL,
0x0000010047447824ULL, 0x008fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000001600597306ULL, 0x0007e20000200c00ULL, 0x0000888046407816ULL, 0x004fe200000000ffULL,
0x0000000310109232ULL, 0x082fe40000000000ULL, 0x0000000312129232ULL, 0x000fe40000000000ULL,
0x0000000211119232ULL, 0x080fe40000000000ULL, 0x0000004800607306ULL, 0x0003e20000200c00ULL,
0x00000018ff167819ULL, 0x008fe20000011446ULL, 0x0000000213139232ULL, 0x000fcc0000000000ULL,
0x0000004200677306ULL, 0x0005e20000200c00ULL, 0x0000010045487824ULL, 0x042fe400078e00ffULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000043006d7306ULL, 0x0003e20000200c00ULL, 0x0000010046427824ULL, 0x044fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000040006f7306ULL, 0x0009e20000200c00ULL,
0x0000888047437816ULL, 0x042fe200000000ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fc80000011446ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000004400747306ULL, 0x0003e20000200c00ULL, 0x0000541041407816ULL, 0x010fe4000000004eULL,
0x0000541052417816ULL, 0x000fe40000000051ULL, 0x000054105f517816ULL, 0x000fc60000000062ULL,
0x0000004200727306ULL, 0x000fe20000200c00ULL, 0x000088803c447816ULL, 0x002fce00000000ffULL,
0x0000004300737306ULL, 0x0003f00000200c00ULL, 0x0000004500707306ULL, 0x000fe20000200c00ULL,
0x000000401040723cULL, 0x002bee0000001820ULL, 0x0000004600717306ULL, 0x000fe20000200c00ULL,
0x000000ffff207224ULL, 0x020fc400078e0044ULL, 0x000001003c217824ULL, 0x000fe400078e00ffULL,
0x000001003d227824ULL, 0x000fc600078e00ffULL, 0x0000004700767306ULL, 0x0003e20000200c00ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff227819ULL, 0x000fca0000011422ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x000000001444783bULL, 0x002e6e0000000200ULL,
0x0000000600557306ULL, 0x0007300000200c00ULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00005410504d7816ULL, 0x004fc4000000004fULL, 0x000054105b507816ULL, 0x000fe4000000005eULL,
0x00000018ff067819ULL, 0x008fe2000001143cULL, 0x000100003c3c7824ULL, 0x000fe400078e00ffULL,
0x0000001f001f7306ULL, 0x000fe20000200c00ULL, 0x0000004c1018723cULL, 0x000be40000001818ULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000004a00687306ULL, 0x000ea20000200c00ULL,
0x00005410564c7816ULL, 0x030fe40000000055ULL, 0x000054105a4d7816ULL, 0x000fe40000000059ULL,
0x0000541065597816ULL, 0x000fc6000000006aULL, 0x00000048006e7306ULL, 0x0007220000200c00ULL,
0x0000000344449232ULL, 0x082fe20000000000ULL, 0x0000004c104c723cULL, 0x000b620000001828ULL,
0x0000000346469232ULL, 0x000fe40000000000ULL, 0x0000000245459232ULL, 0x080fe40000000000ULL,
0x0000000247479232ULL, 0x000fe20000000000ULL, 0x0000002000757306ULL, 0x0003e20000200c00ULL,
0x0000541068687816ULL, 0x004fe4000000001fULL, 0x0000541053487816ULL, 0x008fc40000000054ULL,
0x000000501050723cULL, 0x000f64000000182cULL, 0x0000541073297816ULL, 0x020fe20000000074ULL,
0x0000002100787306ULL, 0x0005e20000200c00ULL, 0x000088803d207816ULL, 0x002fce00000000ffULL,
0x0000004900647306ULL, 0x0002e20000200c00ULL, 0x000088803e217816ULL, 0x004fca00000000ffULL,
0x000000ffff1f7224ULL, 0x000fe400078e0021ULL, 0x0000002000777306ULL, 0x0005e20000200c00ULL,
0x0000541057497816ULL, 0x002fe20000000058ULL, 0x000001003e217824ULL, 0x040fe200078e00ffULL,
0x0000541063587816ULL, 0x000fe20000000066ULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011421ULL, 0x0000000f005d7306ULL, 0x0002620000200c00ULL,
0x000100003d207824ULL, 0x004fe200078e00ffULL, 0x000000581058723cULL, 0x000fe20000001834ULL,
0x000054106d217816ULL, 0x010fe4000000006eULL, 0x0000541064557816ULL, 0x008fe40000000061ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff0f7819ULL, 0x002fc4000001143dULL, 0x00000018ff3e7819ULL, 0x000fca000001143eULL,
0x0000001600167306ULL, 0x000e620000200c00ULL, 0x0000541060547816ULL, 0x000fce000000005dULL,
0x0000001700177306ULL, 0x000ea20000200c00ULL, 0x000000541054723cULL, 0x000b6e0000001830ULL,
0x0000004b00697306ULL, 0x0007220000200c00ULL, 0x0000541071167816ULL, 0x002fe40000000016ULL,
0x0000541075307816ULL, 0x020fca0000000078ULL, 0x0000002000367306ULL, 0x0003e20000200c00ULL,
0x000000481048723cULL, 0x008b620000001824ULL, 0x0000541076177816ULL, 0x004fcc0000000017ULL,
0x0000002200147306ULL, 0x0004e20000200c00ULL, 0x0000541067207816ULL, 0x002fe2000000006cULL,
0x00000016442c723cULL, 0x000fe2000000184cULL, 0x000088803f247816ULL, 0x020fe400000000ffULL,
0x0000541069697816ULL, 0x010fc6000000005cULL, 0x0000000600067306ULL, 0x000fe40000200c00ULL,
0x000000204420723cULL, 0x004bec0000001818ULL, 0x0000003c003d7306ULL, 0x000e620000200c00ULL,
0x000001003f197824ULL, 0x060fe200078e00ffULL, 0x000000681010723cULL, 0x000b620000001838ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000541077317816ULL, 0x008fe20000000014ULL,
0x000000ffff187224ULL, 0x000fe200078e0024ULL, 0x00000018ff1a7819ULL, 0x000fc40000011419ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000001c001c7306ULL, 0x000ea40000200c00ULL,
0x000000304430723cULL, 0x000b620000001850ULL, 0x000054103d347816ULL, 0x002fca0000000006ULL,
0x0000001d001d7306ULL, 0x000e700000200c00ULL, 0x0000000f000f7306ULL, 0x000ee20000200c00ULL,
0x000054106b1c7816ULL, 0x004fce000000001cULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x00005410701d7816ULL, 0x002fce000000001dULL, 0x0000000500057306ULL, 0x000fe20000200c00ULL,
0x0000541036357816ULL, 0x008fe2000000000fULL, 0x0000001c4424723cULL, 0x040b6c0000001840ULL,
0x0000001f001f7306ULL, 0x000fe40000200c00ULL, 0x000000344434723cULL, 0x000b6c0000001854ULL,
0x0000002800387306ULL, 0x0202b00000200c00ULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x000054106f287816ULL, 0x002fce0000000072ULL, 0x0000001a00397306ULL, 0x000e620000200c00ULL,
0x000054101f387816ULL, 0x004fe20000000038ULL, 0x000000284428723cULL, 0x000b6c0000001848ULL,
0x0000003e00197306ULL, 0x000eb00000200c00ULL, 0x0000003f00167306ULL, 0x000ee20000200c00ULL,
0x0000541018397816ULL, 0x002fc40000000039ULL, 0x00005410193c7816ULL, 0x004fca0000000000ULL,
0x000000384438723cULL, 0x000b620000001858ULL, 0x00005410163d7816ULL, 0x008fce0000000005ULL,
0x0000003c443c723cULL, 0x000b620000001810ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff107f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff447224ULL, 0x002fc600078e0011ULL, 0x0000000107077810ULL, 0x000fc80007ffe0ffULL,
0x0000000a0700720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffefdd000007947ULL, 0x000fea000383ffffULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x0000036000008947ULL, 0x000fea0003800000ULL, 0x0180000008007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0001124000047802ULL, 0x000fc40000000f00ULL, 0x00007e6000007944ULL, 0x006fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000800037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000008ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000057919ULL, 0x000ee40000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x014fca0000410000ULL, 0x00001f0700047589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000002004207220ULL, 0x044fe40000410000ULL,
0x0000002104217220ULL, 0x040fe40000410000ULL, 0x0000002404247220ULL, 0x040fe40000410000ULL,
0x0000002504257220ULL, 0x000fc40000410000ULL, 0x0000002804287220ULL, 0x040fe40000410000ULL,
0x0000002904297220ULL, 0x040fe40000410000ULL, 0x0000002c042c7220ULL, 0x040fe40000410000ULL,
0x0000002d042d7220ULL, 0x040fe40000410000ULL, 0x0000003004307220ULL, 0x040fe40000410000ULL,
0x0000003104317220ULL, 0x000fc40000410000ULL, 0x0000003404347220ULL, 0x040fe40000410000ULL,
0x0000003504357220ULL, 0x040fe40000410000ULL, 0x0000003804387220ULL, 0x040fe40000410000ULL,
0x0000003904397220ULL, 0x040fe40000410000ULL, 0x0000003c043c7220ULL, 0x040fe40000410000ULL,
0x0000003d043d7220ULL, 0x000fc40000410000ULL, 0x0000002205227220ULL, 0x048fe40000410000ULL,
0x0000002305237220ULL, 0x040fe40000410000ULL, 0x0000002605267220ULL, 0x040fe40000410000ULL,
0x0000002705277220ULL, 0x040fe40000410000ULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002b052b7220ULL, 0x000fc40000410000ULL, 0x0000002e052e7220ULL, 0x040fe40000410000ULL,
0x0000002f052f7220ULL, 0x040fe40000410000ULL, 0x0000003205327220ULL, 0x040fe40000410000ULL,
0x0000003305337220ULL, 0x040fe40000410000ULL, 0x0000003605367220ULL, 0x040fe40000410000ULL,
0x0000003705377220ULL, 0x000fc40000410000ULL, 0x0000003a053a7220ULL, 0x040fe40000410000ULL,
0x0000003b053b7220ULL, 0x040fe40000410000ULL, 0x0000003e053e7220ULL, 0x040fe40000410000ULL,
0x0000003f053f7220ULL, 0x000fc40000410000ULL, 0x0000000000147919ULL, 0x002e620000000000ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff037819ULL, 0x006fc60000011614ULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000214007812ULL, 0x040fe400078ec0ffULL, 0x0000000814077811ULL, 0x000fe200078ff0ffULL,
0x0000000803097824ULL, 0x040fe200078e00ffULL, 0x0000000300027211ULL, 0x040fe200078ff8ffULL,
0x0000000803117824ULL, 0x000fe200078e00ffULL, 0x0000000700057211ULL, 0x000fe200078ff8ffULL,
0x0000000807067824ULL, 0x000fe200078e00ffULL, 0x0000000402047810ULL, 0x040fe20007ffe0ffULL,
0x00000008030f7824ULL, 0x040fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe20007ffe0ffULL,
0x0000000803137824ULL, 0x000fe200078e00ffULL, 0xfffffff809037812ULL, 0x000fc400078ee202ULL,
0xfffffff811077812ULL, 0x000fe200078ee204ULL, 0x0000000814047824ULL, 0x000fe200078e00ffULL,
0xfffffff806097812ULL, 0x000fe400078ee205ULL, 0x0000000602027810ULL, 0x000fe40007ffe0ffULL,
0x000120000d067811ULL, 0x000fe400078e58ffULL, 0x00000020140c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80f057812ULL, 0x000fe200078ee200ULL, 0x0000001003037824ULL, 0x000fe200078e0206ULL,
0xfffffff8130f7812ULL, 0x000fe200078ee202ULL, 0x00000010090d7824ULL, 0x100fe200078e0206ULL,
0x0000000804047812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x100fe200078e0206ULL,
0x000000202100723eULL, 0x000fe200000000ffULL, 0x0000001007097824ULL, 0x000fe200078e0206ULL,
0x000000242502723eULL, 0x000fe200000000ffULL, 0x0000000103037824ULL, 0x000fe200078e0204ULL,
0x00000003ff157819ULL, 0x000fe2000001160cULL, 0x000000100f0f7824ULL, 0x000fe200078e0206ULL,
0x0000541000107816ULL, 0x100fe20000000002ULL, 0x0000000104077824ULL, 0x000fe200078e0205ULL,
0x0000763200117816ULL, 0x000fe20000000002ULL, 0x000000010c027824ULL, 0x000fe200078e0215ULL,
0x00000003ff087819ULL, 0x000fe20000011614ULL, 0x00000001040d7824ULL, 0x000fc400078e020dULL,
0x0000001003007388ULL, 0x0003e20000000a00ULL, 0x0000000104097824ULL, 0x000fe400078e0209ULL,
0x0000000108007824ULL, 0x000fe400078e0214ULL, 0x00000001040f7824ULL, 0x000fe200078e020fULL,
0x000000343504723eULL, 0x000fe400000000ffULL, 0x0000000702117812ULL, 0x002fe400078ec0ffULL,
0x0000000700037812ULL, 0x000fc400078ec0ffULL, 0x0ffffff811117812ULL, 0x000fe400078ef80cULL,
0x000000282900723eULL, 0x000fe400000000ffULL, 0x0000002c2d02723eULL, 0x000fe200000000ffULL,
0x00000010110e7824ULL, 0x000fe200078e0206ULL, 0x0ffffff803057812ULL, 0x000fe400078ef814ULL,
0x0000541000107816ULL, 0x140fe40000000002ULL, 0x0000763200117816ULL, 0x000fe20000000002ULL,
0x00000010050a7824ULL, 0x000fe200078e0206ULL, 0x000000303103723eULL, 0x000fc400000000ffULL,
0x000000383900723eULL, 0x000fe200000000ffULL, 0x0000001007007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d02723eULL, 0x000fe400000000ffULL, 0x0000002a2b05723eULL, 0x000fe400000000ffULL,
0x0000002e2f06723eULL, 0x000fe400000000ffULL, 0x0000000714147812ULL, 0x000fe400078ec0ffULL,
0x000000070c0c7812ULL, 0x000fc400078ec0ffULL, 0x0000541003107816ULL, 0x142fe40000000004ULL,
0x0000763203117816ULL, 0x000fe40000000004ULL, 0x000000222303723eULL, 0x000fe400000000ffULL,
0x000000262704723eULL, 0x000fe200000000ffULL, 0x0000001009007388ULL, 0x0003e40000000a00ULL,
0x0000541000107816ULL, 0x142fe40000000002ULL, 0x0000763200117816ULL, 0x000fc40000000002ULL,
0x000000323300723eULL, 0x000fe400000000ffULL, 0x000000363702723eULL, 0x000fe200000000ffULL,
0x000000100f007388ULL, 0x0003e40000000a00ULL, 0x0000541003107816ULL, 0x142fe40000000004ULL,
0x0000763203117816ULL, 0x000fe40000000004ULL, 0x0000003a3b03723eULL, 0x000fe400000000ffULL,
0x0000003e3f04723eULL, 0x000fe200000000ffULL, 0x000000100d007388ULL, 0x0003e40000000a00ULL,
0x0000541005107816ULL, 0x002fc40000000006ULL, 0x0000763205117816ULL, 0x000fe40000000006ULL,
0x0000000000057919ULL, 0x000e620000002600ULL, 0x0000541000067816ULL, 0x000fc60000000002ULL,
0x0004001007007388ULL, 0x0005e40000000a00ULL, 0x0000763200077816ULL, 0x004fe40000000002ULL,
0x0000541003027816ULL, 0x140fe40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004000609007388ULL, 0x0005e20000000a00ULL, 0x00000008050d7824ULL, 0x002fc600078e00ffULL,
0x000400020f007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000a107984ULL, 0x000ee20000000c00ULL, 0x0000000805007824ULL, 0x000fe200078e00ffULL,
0xfffffff80d087812ULL, 0x000fe400078ee208ULL, 0x000000000e187984ULL, 0x000f220000000c00ULL,
0x1ffffff814077812ULL, 0x004fe400078ef80bULL, 0xfffffff800157812ULL, 0x000fe400078ee215ULL,
0x0000000408087c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000415157c10ULL, 0x000fc4000ff3e0ffULL,
0x1ffffff80c0b7812ULL, 0x000fe200078ef80bULL, 0x000000ffff037224ULL, 0x002fe200000e06ffULL,
0x00005a0008027a11ULL, 0x040fe200078048ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005a0015047a11ULL, 0x040fe400078248ffULL, 0x00005b0008037a11ULL, 0x000fe400000f4c03ULL,
0x00005b0015057a11ULL, 0x000fc600008f4c00ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100b047825ULL, 0x000fe200078e0004ULL, 0x0000001002007986ULL, 0x008fe8000c101d06ULL,
0x0000001804007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff087624ULL, 0x002fe400078e00ffULL, 0x00006700ff097624ULL, 0x000fca00078e00ffULL,
0x0000000608087981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000000212077824ULL, 0x000fe200078e00ffULL,
0x01860000ff047f8cULL, 0x000ea2000c80043fULL, 0x000000400d037824ULL, 0x000fe400078e00ffULL,
0x0000580007007a24ULL, 0x000fc800078e0214ULL, 0x0000620000097a24ULL, 0x002fc800078e0203ULL,
0x00000b9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff2b7819ULL, 0x100fe2000001160eULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x00000070102f7812ULL, 0x000fe400078ec0ffULL,
0x000000042b0b7810ULL, 0x040fe40007ffe0ffULL, 0x000000082b0f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c2b137810ULL, 0x000fe20007ffe0ffULL, 0x000000010b027824ULL, 0x100fe200078e020eULL,
0x000000102b177810ULL, 0x000fe20007ffe0ffULL, 0x000000080b077824ULL, 0x000fe200078e00ffULL,
0x000000182b217810ULL, 0x000fe20007ffe0ffULL, 0x000000010f067824ULL, 0x000fe200078e020eULL,
0x0000001c2b277810ULL, 0x000fe20007ffe0ffULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0xfffffff807207812ULL, 0x000fe200078ee202ULL, 0x0000000113077824ULL, 0x040fe200078e020eULL,
0x000000030c027217ULL, 0x000fe20007800000ULL, 0x0000000813247824ULL, 0x000fe200078e00ffULL,
0xfffffff811227812ULL, 0x000fe200078ee206ULL, 0x0000000109067824ULL, 0x000fe200078e022bULL,
0x000000202b297810ULL, 0x000fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a03ULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x00005e0006067625ULL, 0x000fc600078e002dULL,
0x000000020b00720cULL, 0x000fe20003f86070ULL, 0x00000001090b7824ULL, 0x000fe200078e020bULL,
0x000000062f147210ULL, 0x000fe20007f1e0ffULL, 0x0000000117117824ULL, 0x000fe200078e020eULL,
0x000000020f00720cULL, 0x080fe20003f46070ULL, 0x0000000817267824ULL, 0x000fe200078e00ffULL,
0x000000021300720cULL, 0x080fe20003f66070ULL, 0x0000000109107824ULL, 0x000fe200078e020fULL,
0x000000142b0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0607ULL,
0xfffffff826267812ULL, 0x000fe200078ee211ULL, 0x00005e000b067625ULL, 0x000fe200078e002dULL,
0x000000021700720cULL, 0x000fc60003f06070ULL, 0x00005e0010107625ULL, 0x000fe200078e002dULL,
0x000000062f167210ULL, 0x000fc60007f3e0ffULL, 0x0000000109137824ULL, 0x000fe200078e0213ULL,
0x000000102f187210ULL, 0x000fe20007fbe0ffULL, 0x0000000109107824ULL, 0x000fe400078e0217ULL,
0x000000ffff177224ULL, 0x000fe400008e0607ULL, 0x00005e0013067625ULL, 0x000fc800078e002dULL,
0x0000000109127824ULL, 0x000fe200078e020fULL, 0x000000062f1a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe400028e0611ULL, 0x00005e0010107625ULL, 0x000fc800078e002dULL,
0x00005e0012127625ULL, 0x000fe200078e002dULL, 0x000000102f1c7210ULL, 0x000fc60007fbe0ffULL,
0x0000000109067824ULL, 0x000fe200078e0221ULL, 0x000000122f127210ULL, 0x000fe20007fde0ffULL,
0x000000012b0b7824ULL, 0x000fe400078e020eULL, 0x000000ffff1b7224ULL, 0x000fe200008e0607ULL,
0x000000020f00720cULL, 0x000fe20003f26070ULL, 0x00005e0006067625ULL, 0x000fc800078e002dULL,
0x000000ffff1d7224ULL, 0x000fe200028e0611ULL, 0x000000070b117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x000000062f1e7210ULL, 0x000fe20007fde0ffULL,
0x000000010f107824ULL, 0x100fe200078e020eULL, 0x000020000d0b7811ULL, 0x000fe200078e70ffULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x0ffffff811067812ULL, 0x000fe200078ef80eULL,
0x000000ffff1f7224ULL, 0x000fe200030e0607ULL, 0x000000022b00720cULL, 0x000fe20003fa6070ULL,
0x0000001020237824ULL, 0x100fe200078e020bULL, 0xfffffff80f287812ULL, 0x000fe200078ee210ULL,
0x00000010060f7824ULL, 0x000fc400078e020bULL, 0x0000000109067824ULL, 0x000fe400078e0227ULL,
0x0000000121257824ULL, 0x000fe400078e020eULL, 0x00005e0006067625ULL, 0x000fc800078e002dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140f7faeULL, 0x0003e2000e901c46ULL,
0x000000062f207210ULL, 0x000fe20007fde0ffULL, 0x00000008212a7824ULL, 0x040fe200078e00ffULL,
0x000000022100720cULL, 0x080fe20003fa6070ULL, 0x0000000016237faeULL, 0x0007e2000e101c46ULL,
0x000000022700720cULL, 0x040fe20003f86070ULL, 0x0000000127067824ULL, 0x000fe400078e020eULL,
0x0000000109107824ULL, 0x000fe400078e0229ULL, 0x0000000827277824ULL, 0x000fc400078e00ffULL,
0x00005e0010107625ULL, 0x000fe200078e002dULL, 0x000000242b237810ULL, 0x008fc60007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0607ULL, 0xfffffff82a167812ULL, 0x000fe200078ee225ULL,
0x00000010220f7824ULL, 0x002fe200078e020bULL, 0xfffffff8272a7812ULL, 0x000fe200078ee206ULL,
0x0000000109067824ULL, 0x000fe200078e0223ULL, 0x000000102f107210ULL, 0x000fe20007fde0ffULL,
0x0000001024177824ULL, 0x000fe200078e020bULL, 0x00000000180f7faeULL, 0x0003e2000d101c46ULL,
0x00005e0006067625ULL, 0x000fe200078e002dULL, 0x000000022300720cULL, 0x000fe40003f46070ULL,
0x000000001a177faeULL, 0x0007e2000d901c46ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x000000062f147210ULL, 0x000fe20007fde0ffULL, 0x0000000129157824ULL, 0x140fe200078e020eULL,
0x000000022900720cULL, 0x0c0fe20003f66070ULL, 0x0000000829247824ULL, 0x000fe200078e00ffULL,
0x0000002c2b257810ULL, 0x000fe20007ffe0ffULL, 0x0000000123227824ULL, 0x000fe200078e020eULL,
0x000000302b277810ULL, 0x000fe20007ffe0ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0xfffffff824067812ULL, 0x000fe200078ee215ULL, 0x00000010260f7824ULL, 0x002fe200078e020bULL,
0x000000382b297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200030e0607ULL,
0xfffffff823227812ULL, 0x000fe200078ee222ULL, 0x0000001028077824ULL, 0x100fe200078e020bULL,
0x000000282b237810ULL, 0x000fe20007ffe0ffULL, 0x0000001016177824ULL, 0x108fe200078e020bULL,
0x000000001c0f7faeULL, 0x0003e2000c101c46ULL, 0x000000102a197824ULL, 0x100fe200078e020bULL,
0x000000022300720cULL, 0x0c0fe20003fc6070ULL, 0x00000010061b7824ULL, 0x000fe200078e020bULL,
0x0000000012077faeULL, 0x0007e2000c901c46ULL, 0x0000000123067824ULL, 0x100fe200078e020eULL,
0x000000022900720cULL, 0x080fe20003f26070ULL, 0x0000000825187824ULL, 0x040fe200078e00ffULL,
0x000000001e177faeULL, 0x0005e2000e901c46ULL, 0x000000022500720cULL, 0x080fe20003fa6070ULL,
0x0000000109167824ULL, 0x000fe200078e0227ULL, 0x000000342b1d7810ULL, 0x042fe20007ffe0ffULL,
0x0000000020197faeULL, 0x0003e2000e101c46ULL, 0x0000003c2b2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000010220f7824ULL, 0x000fe200078e020bULL, 0x000000022700720cULL, 0x080fe20003f86070ULL,
0x0000000823077824ULL, 0x008fe200078e00ffULL, 0x00000000101b7faeULL, 0x0007e2000d901c46ULL,
0x000000021d00720cULL, 0x080fe20003f66070ULL, 0x0000000125137824ULL, 0x000fe200078e020eULL,
0x000000022b00720cULL, 0x000fe20003f06070ULL, 0x00000000140f7faeULL, 0x0003e2000d101c46ULL,
0xfffffff807027812ULL, 0x000fe200078ee206ULL, 0x0000000109067824ULL, 0x000fe200078e0223ULL,
0xfffffff818187812ULL, 0x000fe200078ee213ULL, 0x000000081d1c7824ULL, 0x000fc400078e00ffULL,
0x00005e0006067625ULL, 0x000fc800078e002dULL, 0x0000000109107824ULL, 0x008fe200078e0225ULL,
0x000000062f127210ULL, 0x000fe20007f5e0ffULL, 0x000000011d0f7824ULL, 0x002fe400078e020eULL,
0x00005e0010107625ULL, 0x000fc600078e002dULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL,
0x000000ffff137224ULL, 0x000fe200010e0607ULL, 0x000000102f147210ULL, 0x000fe20007f5e0ffULL,
0x00005e0016067625ULL, 0x000fc800078e002dULL, 0x0000000109107824ULL, 0x000fe400078e021dULL,
0x0000000127177824ULL, 0x044fe400078e020eULL, 0x00000008271a7824ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200010e0611ULL, 0x000000062f167210ULL, 0x000fe20007f5e0ffULL,
0x00005e0010107625ULL, 0x000fe200078e002dULL, 0xfffffff81a1a7812ULL, 0x000fc600078ee217ULL,
0x0000000109067824ULL, 0x040fe400078e0229ULL, 0x00000001090f7824ULL, 0x000fe400078e022bULL,
0x000000ffff177224ULL, 0x000fe200010e0607ULL, 0x000000102f107210ULL, 0x000fe20007f5e0ffULL,
0x0000000129097824ULL, 0x100fe400078e020eULL, 0x000000012b0e7824ULL, 0x000fe400078e020eULL,
0x00005e0006067625ULL, 0x000fc800078e002dULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000062f067210ULL, 0x000fe20007f5e0ffULL,
0x00000008291e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b207812ULL, 0x000fe200078ee20eULL,
0x00005e000f0e7625ULL, 0x000fc600078e002dULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x0000000e2f0e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001002097824ULL, 0x100fe400078e020bULL, 0x0000001018197824ULL, 0x100fe400078e020bULL,
0x000000101a1b7824ULL, 0x100fe200078e020bULL, 0x0000000012097faeULL, 0x0003e2000f101c46ULL,
0x000000101c1d7824ULL, 0x100fe400078e020bULL, 0x000000101e1f7824ULL, 0x100fe200078e020bULL,
0x0000000014197faeULL, 0x0003e2000e901c46ULL, 0x00000010200b7824ULL, 0x000fc400078e020bULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x00000000161b7faeULL, 0x0003e8000e101c46ULL,
0x00000000101d7faeULL, 0x0003e8000d901c46ULL, 0x00000000061f7faeULL, 0x0003e8000c901c46ULL,
0x000000000e0b7faeULL, 0x0003e2000c101c46ULL, 0x00000a5000007947ULL, 0x000fea0003800000ULL,
0x000000040e077811ULL, 0x040fe200078fe8ffULL, 0x00000100ff347424ULL, 0x000fe200078e00ffULL,
0x000000100e157811ULL, 0x000fc400078fe8ffULL, 0x000000080e0f7811ULL, 0x040fe200078fe8ffULL,
0x0000000107027824ULL, 0x140fe200078e020eULL, 0x0000000c0e117811ULL, 0x040fe200078fe8ffULL,
0x0000000807137824ULL, 0x000fe200078e00ffULL, 0x0000001c0e1c7811ULL, 0x040fe200078fe8ffULL,
0x0000000115167824ULL, 0x040fe200078e020eULL, 0x000000240e237811ULL, 0x040fe200078fe8ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0xfffffff813127812ULL, 0x000fe200078ee202ULL,
0x000000010f067824ULL, 0x040fe200078e020eULL, 0x000000280e257811ULL, 0x040fe200078fe8ffULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0xfffffff819187812ULL, 0x000fe200078ee216ULL,
0x00000001110b7824ULL, 0x040fe200078e020eULL, 0x000000140e167811ULL, 0x000fe200078fe8ffULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0xfffffff817137812ULL, 0x000fe200078ee206ULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0x000000180e177811ULL, 0x000fe200078fe8ffULL,
0x0000000116027824ULL, 0x100fe200078e020eULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x00000008161b7824ULL, 0x000fe200078e00ffULL, 0x000000200e1e7811ULL, 0x040fe200078fe8ffULL,
0x0000000117067824ULL, 0x040fe200078e020eULL, 0x0000002c0e277811ULL, 0x000fe200078fe8ffULL,
0x00000008171d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1a7812ULL, 0x000fe200078ee202ULL,
0x000000011c0b7824ULL, 0x100fe200078e020eULL, 0x000000300e297811ULL, 0x000fe200078fe8ffULL,
0x0000000123027824ULL, 0x000fe200078e020eULL, 0xfffffff81d1b7812ULL, 0x000fe200078ee206ULL,
0x00000008231f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8201d7812ULL, 0x000fe200078ee20bULL,
0x0000000125067824ULL, 0x040fe200078e020eULL, 0x0000007010497812ULL, 0x000fe200078ec0ffULL,
0x0000000825217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f247812ULL, 0x000fe200078ee202ULL,
0x000000011e197824ULL, 0x000fe200078e020eULL, 0x0000000e0e027211ULL, 0x000fe200078fe8ffULL,
0x000000081e227824ULL, 0x000fe200078e00ffULL, 0xfffffff821267812ULL, 0x000fe200078ee206ULL,
0x00000001270b7824ULL, 0x140fe200078e020eULL, 0x000000090e067211ULL, 0x000fe200078fe8ffULL,
0x0000000827287824ULL, 0x000fe200078e00ffULL, 0xfffffff822207812ULL, 0x000fe200078ee219ULL,
0x0000000129197824ULL, 0x040fe200078e020eULL, 0x000000340e107811ULL, 0x000fe200078fe8ffULL,
0x00000008292a7824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20bULL,
0x00000001091f7824ULL, 0x040fe200078e0217ULL, 0x00000007020b7812ULL, 0x000fe200078ec0ffULL,
0x0000000109027824ULL, 0x000fe200078e0207ULL, 0x000000380e2b7811ULL, 0x000fe200078fe8ffULL,
0x00005e0006067625ULL, 0x000fe200078e0034ULL, 0xfffffff82a2a7812ULL, 0x000fc400078ee219ULL,
0x0000003c0e2d7811ULL, 0x000fe200078fe8ffULL, 0x0000000109217824ULL, 0x000fe200078e021cULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef80eULL, 0x0000000109197824ULL, 0x000fe200078e0216ULL,
0x0000004906167210ULL, 0x000fe20007f1e0ffULL, 0x0000000110177824ULL, 0x040fe200078e020eULL,
0x000020000d477811ULL, 0x000fe200078e70ffULL, 0x00000008101c7824ULL, 0x000fe400078e00ffULL,
0x00000001092e7824ULL, 0x040fe400078e0210ULL, 0x00000001092c7824ULL, 0x000fe200078e0229ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL, 0x000000012b107824ULL, 0x000fc400078e020eULL,
0x000000012d0e7824ULL, 0x040fe400078e020eULL, 0x000000082d297824ULL, 0x000fe400078e00ffULL,
0x0000000109307824ULL, 0x040fe400078e022bULL, 0x00000001090f7824ULL, 0x000fe200078e020fULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400000e0607ULL, 0x00005e0002067625ULL, 0x000fc800078e0034ULL,
0x0000000109117824ULL, 0x040fe400078e0211ULL, 0x0000000109157824ULL, 0x040fe400078e0215ULL,
0x0000000109227824ULL, 0x000fe200078e021eULL, 0xfffffff82b1e7812ULL, 0x000fe200078ee210ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0034ULL, 0x0000000109237824ULL, 0x040fe400078e0223ULL,
0x0000000109257824ULL, 0x040fe400078e0225ULL, 0x0000000109277824ULL, 0x040fe400078e0227ULL,
0x0000000109327824ULL, 0x000fe400078e022dULL, 0x0000001018317824ULL, 0x000fe200078e0247ULL,
0x0000004906187210ULL, 0x000fe20007f1e0ffULL, 0x00005e0011107625ULL, 0x000fc800078e0034ULL,
0x0000001012097824ULL, 0x100fe400078e0247ULL, 0x00000010132d7824ULL, 0x000fe400078e0247ULL,
0x00005e0015127625ULL, 0x000fc800078e0034ULL, 0x000000101a337824ULL, 0x100fe200078e0247ULL,
0x000000490e1a7210ULL, 0x080fe20007f3e0ffULL, 0x00000010142f7824ULL, 0x100fe400078e0247ULL,
0x000000101c437824ULL, 0x000fe200078e0247ULL, 0x00000049101c7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0019147625ULL, 0x000fc800078e0034ULL, 0x000000101e457824ULL, 0x000fe400078e0247ULL,
0x000000ffff197224ULL, 0x000fe200000e0607ULL, 0x00000049121e7210ULL, 0x000fe20007f1e0ffULL,
0x000000101b357824ULL, 0x000fe400078e0247ULL, 0x00005e001f067625ULL, 0x000fc800078e0034ULL,
0x0000001020397824ULL, 0x000fe400078e0247ULL, 0x000000ffff1b7224ULL, 0x000fe200008e060fULL,
0x0000004914207210ULL, 0x000fe20007f3e0ffULL, 0x000000101d377824ULL, 0x000fe400078e0247ULL,
0x000000ffff1d7224ULL, 0x000fe400010e0611ULL, 0x00005e00210e7625ULL, 0x000fc800078e0034ULL,
0x000000ffff1f7224ULL, 0x000fe400000e0613ULL, 0x00005e0022107625ULL, 0x000fe200078e0034ULL,
0x0000004906227210ULL, 0x000fc60007f1e0ffULL, 0x00000010243b7824ULL, 0x000fe400078e0247ULL,
0x000000ffff217224ULL, 0x000fe200008e0615ULL, 0x000000490e247210ULL, 0x000fe20007f3e0ffULL,
0x00005e0023127625ULL, 0x000fc800078e0034ULL, 0x00000010263d7824ULL, 0x000fe400078e0247ULL,
0x00005e0025147625ULL, 0x000fc800078e0034ULL, 0x000000ffff237224ULL, 0x000fe200000e0607ULL,
0x0000004910267210ULL, 0x000fe20007f1e0ffULL, 0x00005e0027067625ULL, 0x000fc800078e0034ULL,
0x00000010283f7824ULL, 0x000fe400078e0247ULL, 0x000000ffff257224ULL, 0x000fe200008e060fULL,
0x0000004912287210ULL, 0x080fe20007f3e0ffULL, 0x000000102a417824ULL, 0x100fe200078e0247ULL,
0x00000049142a7210ULL, 0x080fe20007f5e0ffULL, 0x000000100b0b7824ULL, 0x000fe400078e0247ULL,
0x000000ffff277224ULL, 0x000fe200000e0611ULL, 0x0000004906067210ULL, 0x000fe20007f1e0ffULL,
0x0000001029477824ULL, 0x000fe200078e0247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000160b7faeULL, 0x0003e2000b901c46ULL, 0x00005e002c0e7625ULL, 0x000fc600078e0034ULL,
0x0000000018097faeULL, 0x0003e2000b901c46ULL, 0x000000ffff297224ULL, 0x000fe400008e0613ULL,
0x00005e002e107625ULL, 0x080fe200078e0034ULL, 0x000000001a2d7faeULL, 0x0003e6000b901c46ULL,
0x000000ffff2b7224ULL, 0x000fe200010e0615ULL, 0x0000004910107210ULL, 0x080fe20007f3e0ffULL,
0x00005e0030127625ULL, 0x080fe200078e0034ULL, 0x000000001c2f7faeULL, 0x0003e6000b901c46ULL,
0x00005e0032147625ULL, 0x000fe200078e0034ULL, 0x0000004912127210ULL, 0x080fe20007f5e0ffULL,
0x000000001e317faeULL, 0x0003e4000b901c46ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x000000490e0e7210ULL, 0x080fe20007f1e0ffULL, 0x0000000020337faeULL, 0x0003e2000b901c46ULL,
0x0000004914147210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fc400008e0611ULL,
0x0000000022357faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fe400000e060fULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x0000000024377faeULL, 0x0003e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fc600018e0615ULL, 0x0000000026397faeULL, 0x0003e8000b901c46ULL,
0x00000000283b7faeULL, 0x0003e8000b901c46ULL, 0x000000002a3d7faeULL, 0x0003e8000b901c46ULL,
0x00000000063f7faeULL, 0x0003e8000b901c46ULL, 0x000000000e417faeULL, 0x0003e8000b901c46ULL,
0x0000000010437faeULL, 0x0003e8000b901c46ULL, 0x0000000012457faeULL, 0x0003e8000b901c46ULL,
0x0000000014477faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01860400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e06097210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e07ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc8000001140eULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e060eULL, 0x0000000202027819ULL, 0x000fc80000001209ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x000000200d027824ULL, 0x002fca00078e0202ULL, 0x00000003ff047819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000102047810ULL, 0x040fe20007ffe0ffULL, 0x00000020020e7824ULL, 0x040fe400078e00ffULL,
0x0000000102067824ULL, 0x040fe400078e0205ULL, 0x0000000105077824ULL, 0x040fe200078e0204ULL,
0x0000001005057810ULL, 0x000fe20007ffe0ffULL, 0x0000002002097824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fc400078ec0ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x100fe200078e0205ULL, 0x000001e009067812ULL, 0x000fe200078ee206ULL,
0x0000000102097824ULL, 0x000fe200078e0205ULL, 0x000001e00e077812ULL, 0x000fe200078ee207ULL,
0x0000002002057824ULL, 0x000fe200078e00ffULL, 0x0000001f04047812ULL, 0x000fe200078ec0ffULL,
0x0000000006147984ULL, 0x000e62000000cc00ULL, 0x0000001f09097812ULL, 0x000fe400078ec0ffULL,
0x000001e005047812ULL, 0x000fe200078ee204ULL, 0x0000000007107984ULL, 0x000ea2000000cc00ULL,
0x000001e00e097812ULL, 0x000fe200078ee209ULL, 0x000000ffff187224ULL, 0x002fc400078e0014ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0013ULL, 0x0000001806007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1c7224ULL, 0x000fc400078e0015ULL, 0x000000ffff1d7224ULL, 0x000fca00078e0017ULL,
0x0000001c07007388ULL, 0x000fe8000000cc00ULL, 0x0000000004107984ULL, 0x000e68000000cc00ULL,
0x0000000009147984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e0012ULL,
0x000000ffff227224ULL, 0x000fc400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff207224ULL, 0x004fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x0000002009007388ULL, 0x0003e8000000cc00ULL, 0x0000001004007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01860000ff0e7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0b7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01860400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc4000780480fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3d80000008087820ULL, 0x010fe20000410000ULL, 0x000186880d097811ULL, 0x040fe200078e18ffULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0xffffffff0a0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000186080d0e7811ULL, 0x000fc400078e28ffULL,
0x000001002c0f7824ULL, 0x000fe200078e0203ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000000f0c00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e002eULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff2d7224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fc4000001ff00ULL,
0x000000012d317810ULL, 0x000fe20007ffe0ffULL, 0x000014e000007945ULL, 0x000fe60003800000ULL,
0x0000002c312e7211ULL, 0x000fc400078ff8ffULL, 0x000000023100780cULL, 0x040fe40003f06070ULL,
0x000000012e2f7810ULL, 0x040fe20007ffe0ffULL, 0x000001002e357824ULL, 0x020fe200078e0203ULL,
0x0000000131337812ULL, 0x000fe400078ec0ffULL, 0x0000000a2f00720cULL, 0x000fe20003f26070ULL,
0x000000ffff2f7224ULL, 0x000fe200078e002dULL, 0x00000001302e7812ULL, 0x000fe200078e0cffULL,
0x000000ffff2d7224ULL, 0x000fe400078e0031ULL, 0x0000620000317a24ULL, 0x000fd000078e0235ULL,
0x00000ab000009947ULL, 0x000fea0003800000ULL, 0x00000003ff497819ULL, 0x002fe20000011602ULL,
0x00000008333f7824ULL, 0x000fe200078e00ffULL, 0x000000350c327217ULL, 0x000fe20007800000ULL,
0x000000020d3e7824ULL, 0x000fe200078e022eULL, 0x0000000449377810ULL, 0x040fe20007ffe0ffULL,
0x0000000149337824ULL, 0x140fe200078e0202ULL, 0x0000000849397810ULL, 0x040fe20007ffe0ffULL,
0x00000001323c7824ULL, 0x000fe200078e0a35ULL, 0x0000001049477810ULL, 0x000fe20007ffe0ffULL,
0x0000000137347824ULL, 0x100fe200078e0202ULL, 0x0000000c493b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000837417824ULL, 0x000fe200078e00ffULL, 0x00000014494f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000139327824ULL, 0x000fe200078e0202ULL, 0x0000001849537810ULL, 0x000fe20007ffe0ffULL,
0x0000000839437824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee234ULL,
0x0000000147357824ULL, 0x100fe200078e0202ULL, 0x00000020495b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000847387824ULL, 0x000fe200078e00ffULL, 0x0000001c49577810ULL, 0x000fe20007ffe0ffULL,
0x000000013b347824ULL, 0x000fe200078e0202ULL, 0xfffffff843437812ULL, 0x000fe200078ee232ULL,
0x000000083b457824ULL, 0x000fe200078e00ffULL, 0x00000024495f7810ULL, 0x000fe20007ffe0ffULL,
0x000000014f367824ULL, 0x040fe200078e0202ULL, 0xfffffff8384d7812ULL, 0x000fe200078ee235ULL,
0x000000084f517824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee234ULL,
0x0000000153327824ULL, 0x000fe200078e0202ULL, 0x0000003c4900720cULL, 0x080fe20003f26070ULL,
0x0000000853557824ULL, 0x000fe200078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee236ULL,
0x000000015b357824ULL, 0x100fe200078e0202ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee202ULL,
0x000000085b387824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fe200078ee232ULL,
0x0000000157347824ULL, 0x140fe200078e0202ULL, 0x000020003e3e7811ULL, 0x000fe200078e68ffULL,
0x0000000857597824ULL, 0x000fe200078e00ffULL, 0xfffffff8385d7812ULL, 0x000fe200078ee235ULL,
0x000000015f367824ULL, 0x000fe200078e0202ULL, 0x0000000733357812ULL, 0x000fe200078ec0ffULL,
0x000000085f617824ULL, 0x000fe200078e00ffULL, 0xfffffff859597812ULL, 0x000fe200078ee234ULL,
0x00000100ff4b7424ULL, 0x000fe200078e00ffULL, 0x0000003c3700720cULL, 0x080fe20003f46070ULL,
0x0000000149327824ULL, 0x100fe200078e0231ULL, 0xfffffff861617812ULL, 0x000fe200078ee236ULL,
0x0000000137347824ULL, 0x100fe200078e0231ULL, 0x0ffffff8353d7812ULL, 0x000fe200078ef802ULL,
0x0000000139367824ULL, 0x040fe200078e0231ULL, 0x0000003c3900720cULL, 0x080fe20003f66070ULL,
0x00005e0032327625ULL, 0x000fe200078e004bULL, 0x0000003c3b00720cULL, 0x000fc40003f86070ULL,
0x0000003c4700720cULL, 0x000fe20003fa6070ULL, 0x000000013b387824ULL, 0x100fe400078e0231ULL,
0x00000001473a7824ULL, 0x000fe400078e0231ULL, 0x00005e0034347625ULL, 0x000fc800078e004bULL,
0x00005e0036367625ULL, 0x000fc800078e004bULL, 0x00005e0038387625ULL, 0x000fc800078e004bULL,
0x000000103f327825ULL, 0x000fc800078e0032ULL, 0x000000103d3d7824ULL, 0x000fe400078e023eULL,
0x00005e003a3a7625ULL, 0x000fc600078e004bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000323d7faeULL, 0x0003e2000c901c46ULL, 0x0000001041417824ULL, 0x000fe200078e023eULL,
0x0000003c4f00720cULL, 0x000fe20003f26070ULL, 0x000000103f347825ULL, 0x000fc800078e0034ULL,
0x0000001043437824ULL, 0x000fe200078e023eULL, 0x0000000034417faeULL, 0x0005e2000d101c46ULL,
0x000000103f367825ULL, 0x000fe200078e0036ULL, 0x0000003c5300720cULL, 0x000fc60003f46070ULL,
0x0000001045457824ULL, 0x000fe200078e023eULL, 0x0000000036437faeULL, 0x0007e2000d901c46ULL,
0x000000103f387825ULL, 0x000fe200078e0038ULL, 0x0000003c5700720cULL, 0x000fc60003f66070ULL,
0x000000104d477824ULL, 0x000fe200078e023eULL, 0x0000000038457faeULL, 0x0009e2000e101c46ULL,
0x000000103f3a7825ULL, 0x000fe200078e003aULL, 0x0000003c5b00720cULL, 0x080fe40003f86070ULL,
0x00000030494d7810ULL, 0x000fe20007ffe0ffULL, 0x000000014f327824ULL, 0x102fe200078e0231ULL,
0x000000003a477faeULL, 0x0003e2000e901c46ULL, 0x0000000153347824ULL, 0x004fe200078e0231ULL,
0x0000003c5f00720cULL, 0x000fe20003fa6070ULL, 0x00005e0032327625ULL, 0x000fe200078e004bULL,
0x00000034494f7810ULL, 0x000fc60007ffe0ffULL, 0x0000000157407824ULL, 0x100fe400078e0231ULL,
0x000000015b417824ULL, 0x000fe400078e0231ULL, 0x00005e0034347625ULL, 0x000fe200078e004bULL,
0x0000002c49477810ULL, 0x002fc60007ffe0ffULL, 0x000000015f3a7824ULL, 0x000fe400078e0231ULL,
0x00005e0040367625ULL, 0x008fc800078e004bULL, 0x00005e0041387625ULL, 0x010fc800078e004bULL,
0x00000010513d7824ULL, 0x000fe200078e023eULL, 0x0000003849517810ULL, 0x000fe20007ffe0ffULL,
0x000000103f327825ULL, 0x000fc800078e0032ULL, 0x00005e003a3a7625ULL, 0x000fe200078e004bULL,
0x00000000323d7faeULL, 0x0003e6000c901c46ULL, 0x0000001055417824ULL, 0x000fe400078e023eULL,
0x000000103f347825ULL, 0x000fc800078e0034ULL, 0x0000001059437824ULL, 0x000fe200078e023eULL,
0x0000000034417faeULL, 0x0005e2000d101c46ULL, 0x000000103f367825ULL, 0x000fe200078e0036ULL,
0x00000028493d7810ULL, 0x042fe40007ffe0ffULL, 0x0000003c49497810ULL, 0x000fe20007ffe0ffULL,
0x000000105d457824ULL, 0x000fe200078e023eULL, 0x0000000036437faeULL, 0x0003e2000d901c46ULL,
0x000000103f387825ULL, 0x000fe200078e0038ULL, 0x0000003c3d00720cULL, 0x080fe40003f26070ULL,
0x0000003c4700720cULL, 0x080fe20003f46070ULL, 0x0000001061337824ULL, 0x000fe200078e023eULL,
0x0000000038457faeULL, 0x0007e2000e101c46ULL, 0x000000103f3a7825ULL, 0x000fe200078e003aULL,
0x0000003c4d00720cULL, 0x000fc40003f66070ULL, 0x0000003c4f00720cULL, 0x080fe20003f86070ULL,
0x0000000847347824ULL, 0x004fe200078e00ffULL, 0x000000003a337faeULL, 0x0005e2000e901c46ULL,
0x000000013d327824ULL, 0x100fe200078e0202ULL, 0x0000003c5100720cULL, 0x080fe20003fa6070ULL,
0x000000083d417824ULL, 0x000fe200078e00ffULL, 0x0000003c4900720cULL, 0x000fe20003fc6070ULL,
0x000000084d407824ULL, 0x000fe400078e00ffULL, 0x000000014f357824ULL, 0x000fe200078e0202ULL,
0xfffffff841417812ULL, 0x000fe200078ee232ULL, 0x000000084f427824ULL, 0x000fc400078e00ffULL,
0x0000000149377824ULL, 0x102fe400078e0202ULL, 0x0000000147337824ULL, 0x104fe400078e0202ULL,
0x0000000849467824ULL, 0x000fe400078e00ffULL, 0x000000013d327824ULL, 0x000fe200078e0231ULL,
0xfffffff834437812ULL, 0x000fe200078ee233ULL, 0x000000014d337824ULL, 0x000fe400078e0202ULL,
0x0000000147347824ULL, 0x000fe200078e0231ULL, 0xfffffff842477812ULL, 0x000fe200078ee235ULL,
0x000000014d367824ULL, 0x000fe200078e0231ULL, 0xfffffff840457812ULL, 0x008fe200078ee233ULL,
0x000000014f387824ULL, 0x000fe200078e0231ULL, 0xfffffff8464d7812ULL, 0x000fe200078ee237ULL,
0x00000001513a7824ULL, 0x000fc400078e0231ULL, 0x00000001493c7824ULL, 0x000fe400078e0231ULL,
0x0000000151317824ULL, 0x040fe400078e0202ULL, 0x0000000851447824ULL, 0x000fe400078e00ffULL,
0x00005e0032327625ULL, 0x000fc600078e004bULL, 0xfffffff844497812ULL, 0x000fe200078ee231ULL,
0x00005e0034347625ULL, 0x000fc800078e004bULL, 0x00005e0036367625ULL, 0x000fc800078e004bULL,
0x00005e0038387625ULL, 0x000fc800078e004bULL, 0x00005e003a3a7625ULL, 0x000fc800078e004bULL,
0x00005e003c3c7625ULL, 0x000fc800078e004bULL, 0x000000103f327825ULL, 0x000fc800078e0032ULL,
0x000000103f347825ULL, 0x000fc800078e0034ULL, 0x000000103f367825ULL, 0x000fc800078e0036ULL,
0x000000103f387825ULL, 0x000fc800078e0038ULL, 0x000000103f3a7825ULL, 0x000fc800078e003aULL,
0x000000103f3c7825ULL, 0x000fc800078e003cULL, 0x0000001041317824ULL, 0x100fe400078e023eULL,
0x00000010433f7824ULL, 0x100fe400078e023eULL, 0x0000001045417824ULL, 0x100fe200078e023eULL,
0x0000000032317faeULL, 0x0003e2000c901c46ULL, 0x0000001047437824ULL, 0x100fe400078e023eULL,
0x0000001049457824ULL, 0x100fe200078e023eULL, 0x00000000343f7faeULL, 0x0003e2000d101c46ULL,
0x000000104d477824ULL, 0x000fc600078e023eULL, 0x0000000036417faeULL, 0x0003e8000d901c46ULL,
0x0000000038437faeULL, 0x0003e8000e101c46ULL, 0x000000003a457faeULL, 0x0003e8000e901c46ULL,
0x000000003c477faeULL, 0x0003e2000f101c46ULL, 0x0000097000007947ULL, 0x000fea0003800000ULL,
0x00000014023c7811ULL, 0x042fe200078fe8ffULL, 0x0000000833537824ULL, 0x000fe200078e00ffULL,
0x00000010023a7811ULL, 0x040fe200078fe8ffULL, 0x00000100ff517424ULL, 0x000fe200078e00ffULL,
0x0000000402347811ULL, 0x000fe200078fe8ffULL, 0x000000013c397824ULL, 0x100fe200078e0202ULL,
0x0000000c02387811ULL, 0x000fe200078fe8ffULL, 0x000000083c427824ULL, 0x000fe200078e00ffULL,
0x0000000802367811ULL, 0x000fe200078fe8ffULL, 0x000000013a377824ULL, 0x100fe200078e0202ULL,
0x0000002402447811ULL, 0x000fe200078fe8ffULL, 0x000000083a407824ULL, 0x000fe200078e00ffULL,
0xfffffff8425d7812ULL, 0x000fe200078ee239ULL, 0x0000000134327824ULL, 0x100fe200078e0202ULL,
0x0000002002427811ULL, 0x000fe200078fe8ffULL, 0x0000000834557824ULL, 0x000fe200078e00ffULL,
0xfffffff8405b7812ULL, 0x000fe200078ee237ULL, 0x0000000138357824ULL, 0x000fe200078e0202ULL,
0x0000001c02407811ULL, 0x000fe200078fe8ffULL, 0x00000008383e7824ULL, 0x000fe200078e00ffULL,
0xfffffff855557812ULL, 0x000fe200078ee232ULL, 0x0000000136327824ULL, 0x100fe200078e0202ULL,
0x00000034024c7811ULL, 0x000fe200078fe8ffULL, 0x0000000836577824ULL, 0x000fe200078e00ffULL,
0xfffffff83e597812ULL, 0x000fe200078ee235ULL, 0x0000000142377824ULL, 0x000fe200078e0202ULL,
0x00000018023e7811ULL, 0x000fe200078fe8ffULL, 0x0000000842487824ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee232ULL, 0x0000000140357824ULL, 0x100fe200078e0202ULL,
0x0000003802337811ULL, 0x000fe200078fe8ffULL, 0x0000000840467824ULL, 0x000fe200078e00ffULL,
0xfffffff848637812ULL, 0x000fe200078ee237ULL, 0x0000000144397824ULL, 0x100fe200078e0202ULL,
0x0000002c02487811ULL, 0x000fe200078fe8ffULL, 0x00000008444a7824ULL, 0x000fe200078e00ffULL,
0xfffffff846617812ULL, 0x000fe200078ee235ULL, 0x000000013e327824ULL, 0x100fe200078e0202ULL,
0x0000002802467811ULL, 0x000fe200078fe8ffULL, 0x000000083e5f7824ULL, 0x000fe200078e00ffULL,
0xfffffff84a657812ULL, 0x000fe200078ee239ULL, 0x0000000148357824ULL, 0x000fe200078e0202ULL,
0x00000030024a7811ULL, 0x000fe200078fe8ffULL, 0x00000008484e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee232ULL, 0x0000000146327824ULL, 0x100fe200078e0202ULL,
0x0000003c023b7811ULL, 0x000fe200078fe8ffULL, 0x0000000846677824ULL, 0x000fe200078e00ffULL,
0xfffffff84e697812ULL, 0x000fe200078ee235ULL, 0x000000014a377824ULL, 0x000fe200078e0202ULL,
0x0000000202357211ULL, 0x000fe200078fe8ffULL, 0x000000084a507824ULL, 0x000fe200078e00ffULL,
0xfffffff867677812ULL, 0x000fe200078ee232ULL, 0x000000014c397824ULL, 0x100fe200078e0202ULL,
0x0000003102327211ULL, 0x000fe200078fe8ffULL, 0x000000084c527824ULL, 0x000fe200078e00ffULL,
0xfffffff8506b7812ULL, 0x000fe200078ee237ULL, 0x0000000134347824ULL, 0x100fe200078e0231ULL,
0x0000000735357812ULL, 0x000fe200078ec0ffULL, 0x0000000136367824ULL, 0x000fe200078e0231ULL,
0xfffffff8526d7812ULL, 0x000fe200078ee239ULL, 0x0000000138387824ULL, 0x100fe200078e0231ULL,
0xfffffff853537812ULL, 0x000fe200078ee202ULL, 0x000000013a3a7824ULL, 0x000fc400078e0231ULL,
0x000000013c3c7824ULL, 0x100fe400078e0231ULL, 0x000000013e3e7824ULL, 0x100fe400078e0231ULL,
0x0000000140407824ULL, 0x100fe400078e0231ULL, 0x0000000142427824ULL, 0x100fe400078e0231ULL,
0x0000000144447824ULL, 0x100fe400078e0231ULL, 0x0000000146467824ULL, 0x000fc400078e0231ULL,
0x0000000148487824ULL, 0x100fe400078e0231ULL, 0x000000014a4a7824ULL, 0x100fe400078e0231ULL,
0x000000014c4c7824ULL, 0x100fe400078e0231ULL, 0x00000001334e7824ULL, 0x100fe400078e0231ULL,
0x000000013b507824ULL, 0x000fe400078e0231ULL, 0x0000000133397824ULL, 0x000fc400078e0202ULL,
0x0000000833527824ULL, 0x000fe400078e00ffULL, 0x000000013b317824ULL, 0x040fe400078e0202ULL,
0x000000083b547824ULL, 0x000fe200078e00ffULL, 0xfffffff8526f7812ULL, 0x000fe200078ee239ULL,
0x000000020d377824ULL, 0x000fe400078e022eULL, 0x00005e0032327625ULL, 0x080fe200078e0051ULL,
0xfffffff854717812ULL, 0x000fe400078ee231ULL, 0x0000200037527811ULL, 0x000fe200078e68ffULL,
0x00005e0036367625ULL, 0x000fe200078e0051ULL, 0x0ffffff835317812ULL, 0x000fc600078ef802ULL,
0x00005e0034347625ULL, 0x000fc800078e0051ULL, 0x00005e0038387625ULL, 0x000fc800078e0051ULL,
0x00005e003a3a7625ULL, 0x000fc800078e0051ULL, 0x00005e003c3c7625ULL, 0x000fc800078e0051ULL,
0x00005e003e3e7625ULL, 0x000fc800078e0051ULL, 0x00005e0040407625ULL, 0x000fc800078e0051ULL,
0x00005e0042427625ULL, 0x000fc800078e0051ULL, 0x00005e0044447625ULL, 0x000fc800078e0051ULL,
0x00005e0046467625ULL, 0x000fc800078e0051ULL, 0x00005e0048487625ULL, 0x000fc800078e0051ULL,
0x00005e004a4a7625ULL, 0x000fc800078e0051ULL, 0x00005e004c4c7625ULL, 0x000fc800078e0051ULL,
0x00005e004e4e7625ULL, 0x000fc800078e0051ULL, 0x00005e0050507625ULL, 0x000fc800078e0051ULL,
0x0000001053327825ULL, 0x000fc800078e0032ULL, 0x0000001053347825ULL, 0x000fc800078e0034ULL,
0x0000001053367825ULL, 0x000fc800078e0036ULL, 0x0000001053387825ULL, 0x000fc800078e0038ULL,
0x00000010533a7825ULL, 0x000fc800078e003aULL, 0x00000010533c7825ULL, 0x000fc800078e003cULL,
0x00000010533e7825ULL, 0x000fc800078e003eULL, 0x0000001053407825ULL, 0x000fc800078e0040ULL,
0x0000001053427825ULL, 0x000fc800078e0042ULL, 0x0000001053447825ULL, 0x000fc800078e0044ULL,
0x0000001053467825ULL, 0x000fc800078e0046ULL, 0x0000001053487825ULL, 0x000fc800078e0048ULL,
0x00000010534a7825ULL, 0x000fc800078e004aULL, 0x00000010534c7825ULL, 0x000fc800078e004cULL,
0x00000010534e7825ULL, 0x000fc800078e004eULL, 0x0000001053507825ULL, 0x000fc800078e0050ULL,
0x0000001031317824ULL, 0x100fe400078e0252ULL, 0x0000001055537824ULL, 0x100fe400078e0252ULL,
0x0000001057557824ULL, 0x100fe200078e0252ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032317faeULL, 0x0003e2000b901c46ULL, 0x0000001059577824ULL, 0x100fe400078e0252ULL,
0x000000105b597824ULL, 0x100fe200078e0252ULL, 0x0000000034537faeULL, 0x0003e2000b901c46ULL,
0x000000105d5b7824ULL, 0x000fc400078e0252ULL, 0x000000105f5d7824ULL, 0x100fe200078e0252ULL,
0x0000000036557faeULL, 0x0003e2000b901c46ULL, 0x00000010615f7824ULL, 0x100fe400078e0252ULL,
0x0000001063617824ULL, 0x100fe200078e0252ULL, 0x0000000038577faeULL, 0x0003e2000b901c46ULL,
0x0000001065637824ULL, 0x100fe400078e0252ULL, 0x0000001067657824ULL, 0x100fe200078e0252ULL,
0x000000003a597faeULL, 0x0003e2000b901c46ULL, 0x0000001069677824ULL, 0x000fc400078e0252ULL,
0x000000106b697824ULL, 0x100fe200078e0252ULL, 0x000000003c5b7faeULL, 0x0003e2000b901c46ULL,
0x000000106d6b7824ULL, 0x100fe400078e0252ULL, 0x000000106f6d7824ULL, 0x100fe200078e0252ULL,
0x000000003e5d7faeULL, 0x0003e2000b901c46ULL, 0x00000010716f7824ULL, 0x000fc600078e0252ULL,
0x00000000405f7faeULL, 0x0003e8000b901c46ULL, 0x0000000042617faeULL, 0x0003e8000b901c46ULL,
0x0000000044637faeULL, 0x0003e8000b901c46ULL, 0x0000000046657faeULL, 0x0003e8000b901c46ULL,
0x0000000048677faeULL, 0x0003e8000b901c46ULL, 0x000000004a697faeULL, 0x0003e8000b901c46ULL,
0x000000004c6b7faeULL, 0x0003e8000b901c46ULL, 0x000000004e6d7faeULL, 0x0003e8000b901c46ULL,
0x00000000506f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002002417810ULL, 0x042fe20007ffe0ffULL,
0x000000020d3c7824ULL, 0x000fe200078e0230ULL, 0x00000007023d7812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0xfffffff8023f7812ULL, 0x000fc400078ec0ffULL,
0xfffffff841417812ULL, 0x000fe400078ec0ffULL, 0x000020003c3c7811ULL, 0x000fe400078e68ffULL,
0x000000083d3d7812ULL, 0x100fe400078ef802ULL, 0x000000073f3f7812ULL, 0x100fe400078ef802ULL,
0x0000000741417812ULL, 0x000fe200078ef802ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000013f307824ULL, 0x140fe200078e023eULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000083f317824ULL, 0x000fe200078e00ffULL, 0x000000013e467810ULL, 0x000fe20007ffe0ffULL,
0x0000000141347824ULL, 0x020fc400078e023eULL, 0x0000000841357824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee230ULL, 0x0000000841477824ULL, 0x000fc600078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee234ULL, 0x0000001031317824ULL, 0x000fc800078e023cULL,
0x0000001035357824ULL, 0x000fe400078e023cULL, 0x000000003130783bULL, 0x000e680000000200ULL,
0x000000003534783bULL, 0x000ea20000000200ULL, 0x00000018ff3a7819ULL, 0x002fe20000011432ULL,
0x00010000313b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011431ULL,
0x0000003a00547306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fc40000011430ULL,
0x00000018ff457819ULL, 0x000fe40000011433ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff447819ULL, 0x004fe20000011434ULL, 0x0000003900507306ULL, 0x0005e20000200c00ULL,
0x00008880313a7816ULL, 0x042fe200000000ffULL, 0x0000010031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011435ULL, 0x00000018ff427819ULL, 0x000fc40000011436ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x00000038004c7306ULL, 0x0003e20000200c00ULL,
0x0001000030397824ULL, 0x004fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fc80000011437ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003100537306ULL, 0x0005e20000200c00ULL,
0x0000888030387816ULL, 0x042fe200000000ffULL, 0x0000010030307824ULL, 0x000fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x00000039004d7306ULL, 0x0003e20000200c00ULL,
0x0001000033317824ULL, 0x004fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000038004a7306ULL, 0x0005e20000200c00ULL, 0x0000888033397816ULL, 0x042fe200000000ffULL,
0x0000010033337824ULL, 0x000fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x00000030004f7306ULL, 0x0003e20000200c00ULL, 0x0000888032387816ULL, 0x004fce00000000ffULL,
0x0000003800527306ULL, 0x0005e20000200c00ULL, 0x0001000032307824ULL, 0x042fe400078e00ffULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003300587306ULL, 0x0003e20000200c00ULL, 0x000000083f387824ULL, 0x004fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fcc0000011432ULL, 0x0000003000557306ULL, 0x0004e20000200c00ULL,
0x000000013f337824ULL, 0x102fe400078e0246ULL, 0x0000000141467824ULL, 0x000fc600078e0246ULL,
0xfffffff838337812ULL, 0x000fe400078ee233ULL, 0x0000003a004e7306ULL, 0x000fe20000200c00ULL,
0x0000888034307816ULL, 0x004fe400000000ffULL, 0x0000001033337824ULL, 0x000fe200078e023cULL,
0xfffffff847477812ULL, 0x000fc800078ee246ULL, 0x00000030005a7306ULL, 0x0003e20000200c00ULL,
0x0000541052527816ULL, 0x008fce0000000055ULL, 0x0000003b00517306ULL, 0x000ea20000200c00ULL,
0x0001000035307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003900567306ULL, 0x0003f00000200c00ULL, 0x0000003200577306ULL, 0x0007e20000200c00ULL,
0x000000003338783bULL, 0x002e620000000200ULL, 0x000054104e4e7816ULL, 0x004fcc0000000051ULL,
0x0000003100597306ULL, 0x0005220000200c00ULL, 0x0001000034327824ULL, 0x048fe400078e00ffULL,
0x0000010034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000030005f7306ULL, 0x0007e20000200c00ULL, 0x0000888035317816ULL, 0x044fe200000000ffULL,
0x0000010035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc80000011434ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x00000031005c7306ULL, 0x0004620000200c00ULL,
0x0000001047307824ULL, 0x008fe200078e023cULL, 0x0000541056567816ULL, 0x010fe20000000059ULL,
0x0001000037477824ULL, 0x000fca00078e00ffULL, 0x00000032005b7306ULL, 0x0007220000200c00ULL,
0x0001000036317824ULL, 0x004fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fc80000011447ULL,
0x00000018ff467819ULL, 0x000fe40000011431ULL, 0x00000034005d7306ULL, 0x0005e20000200c00ULL,
0x000000003030783bULL, 0x008ee20000000200ULL, 0x00000018ff4b7819ULL, 0x002fe2000001143bULL,
0x000100003a6e7824ULL, 0x000fe200078e00ffULL, 0x0000888039687816ULL, 0x000fe400000000ffULL,
0x000054105c5c7816ULL, 0x000fe4000000005fULL, 0x00000035005e7306ULL, 0x0003e20000200c00ULL,
0x0000888036347816ULL, 0x044fe200000000ffULL, 0x0000010036367824ULL, 0x000fe200078e00ffULL,
0x000054105a5a7816ULL, 0x010fc4000000005bULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003400607306ULL, 0x0005e20000200c00ULL,
0x0000888037357816ULL, 0x042fe200000000ffULL, 0x0000010037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000004b00747306ULL, 0x0003e20000200c00ULL,
0x00000018ff347819ULL, 0x004fce0000011438ULL, 0x0000003600637306ULL, 0x0005e20000200c00ULL,
0x000000082f4b7824ULL, 0x002fe200078e023eULL, 0x000000023e3e7810ULL, 0x000fc60007ffe0ffULL,
0x000000024b4b7824ULL, 0x000fe200078e00ffULL, 0x000000083e00780cULL, 0x000fe40003f25270ULL,
0x0000003400667306ULL, 0x0003e20000200c00ULL, 0x00000018ff367819ULL, 0x004fe40000011439ULL,
0x00000018ff497819ULL, 0x008fe40000011430ULL, 0x00000018ff487819ULL, 0x000fc60000011431ULL,
0x0000004600617306ULL, 0x0004e20000200c00ULL, 0x0001000038347824ULL, 0x002fce00078e00ffULL,
0x00000036006c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff467819ULL, 0x004fce000001143aULL,
0x0000003700677306ULL, 0x0005e20000200c00ULL, 0x00000018ff367819ULL, 0x002fe40000011434ULL,
0x0000004b02347211ULL, 0x000fe400078fe0ffULL, 0x000000024b4b7810ULL, 0x000fe40007ffe0ffULL,
0x0000541060607816ULL, 0x008fe20000000061ULL, 0x0000004600727306ULL, 0x000fe20000200c00ULL,
0x00000018ff377819ULL, 0x004fe20000011433ULL, 0x000000013d347824ULL, 0x000fcc00078e0234ULL,
0x0000003700467306ULL, 0x0003f00000200c00ULL, 0x0000003500627306ULL, 0x0005e20000200c00ULL,
0x000000203d377824ULL, 0x002fca00078e00ffULL, 0xffffffe037347812ULL, 0x000fe400078ee234ULL,
0x0000003600697306ULL, 0x000fe20000200c00ULL, 0x0000888038357816ULL, 0x044fe200000000ffULL,
0x0000010038387824ULL, 0x000fe400078e00ffULL, 0x0000001034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000003500647306ULL, 0x0002b00000200c00ULL,
0x00000038006b7306ULL, 0x0007e20000200c00ULL, 0x0001000039357824ULL, 0x002fc400078e00ffULL,
0x0000010039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011435ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000004400447306ULL, 0x000f220000200c00ULL, 0x000088803a387816ULL, 0x048fe200000000ffULL,
0x000001003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541064647816ULL, 0x004fc80000000069ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x00000039006f7306ULL, 0x0004f00000200c00ULL,
0x0000003800707306ULL, 0x0007e20000200c00ULL, 0x000100003b397824ULL, 0x004fe200078e00ffULL,
0x000054105d5b7816ULL, 0x010fc80000000044ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x000054104a387816ULL, 0x008fe4000000004dULL,
0x000054106f697816ULL, 0x000fca000000006cULL, 0x0000003900757306ULL, 0x0007e20000200c00ULL,
0x0000005a3418723cULL, 0x002fee0000001818ULL, 0x0000004500457306ULL, 0x000e620000200c00ULL,
0x000054104f397816ULL, 0x008fe4000000004cULL, 0x00005410534f7816ULL, 0x000fc40000000050ULL,
0x0000541057537816ULL, 0x000fe40000000054ULL, 0x0000541063617816ULL, 0x004fe20000000042ULL,
0x000000383428723cULL, 0x000b620000001828ULL, 0x0000004300437306ULL, 0x000ea20000200c00ULL,
0x00008880314c7816ULL, 0x000fca00000000ffULL, 0x0000004b02387211ULL, 0x020fe200078fe0ffULL,
0x000000203d4b7824ULL, 0x040fe200078e00ffULL, 0x0000004000407306ULL, 0x000ee20000200c00ULL,
0x0001000030397824ULL, 0x000fe200078e00ffULL, 0x0000541058577816ULL, 0x002fe20000000045ULL,
0x000000013d387824ULL, 0x000fe200078e0238ULL, 0x0000004e3424723cULL, 0x040fe20000001824ULL,
0x000000ffff457224ULL, 0x000fe200078e004cULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x00010000314c7824ULL, 0x000fe200078e00ffULL, 0x0000004700657306ULL, 0x0003220000200c00ULL,
0xffffffe04b387812ULL, 0x000fe200078ee238ULL, 0x0000010031317824ULL, 0x000fe200078e00ffULL,
0x000054105e5d7816ULL, 0x004fe20000000043ULL, 0x000000523420723cULL, 0x040f620000001820ULL,
0x0000888032437816ULL, 0x000fe200000000ffULL, 0x0000001038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000006a006d7306ULL, 0x0005e20000200c00ULL,
0x0000541067637816ULL, 0x008fe20000000040ULL, 0x000000ffff427224ULL, 0x000fe200078e0043ULL,
0x00000018ff477819ULL, 0x002fe20000011432ULL, 0x00000056341c723cULL, 0x040f62000000181cULL,
0x0001000032437824ULL, 0x040fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000010032327824ULL, 0x000fe200078e00ffULL, 0x0000003a00737306ULL, 0x0003e20000200c00ULL,
0x000088803b6a7816ULL, 0x044fe200000000ffULL, 0x000001003b3b7824ULL, 0x000fe200078e00ffULL,
0x0000541062627816ULL, 0x010fe20000000065ULL, 0x0000005c3414723cULL, 0x000f620000001814ULL,
0x00000018ff437819ULL, 0x000fc40000011443ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x00000039004b7306ULL, 0x000fe20000200c00ULL, 0x00008880303a7816ULL, 0x042fe200000000ffULL,
0x0000010030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x000000603410723cULL, 0x040f620000001810ULL, 0x000054106b657816ULL, 0x000fe40000000066ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000003b004d7306ULL, 0x000e680000200c00ULL,
0x000000623404723cULL, 0x000b680000001804ULL, 0x0000003a004a7306ULL, 0x0004e60000200c00ULL,
0x0000888033347816ULL, 0x060fe200000000ffULL, 0x0001000033357824ULL, 0x000fc400078e00ffULL,
0x0000010033337824ULL, 0x000fe400078e00ffULL, 0x0000006e00717306ULL, 0x000f220000200c00ULL,
0x000000003838783bULL, 0x004ea20000000200ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x000054104d6b7816ULL, 0x002fe40000000074ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000054104a4a7816ULL, 0x008fce000000004bULL,
0x0000004300437306ULL, 0x000e620000200c00ULL, 0x0000541070707816ULL, 0x010fe40000000071ULL,
0x0000541073717816ULL, 0x000fca0000000072ULL, 0x0000003400347306ULL, 0x000ff00000200c00ULL,
0x0000003500357306ULL, 0x000ee20000200c00ULL, 0x0000541042427816ULL, 0x002fce0000000043ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000000643828723cULL, 0x044b6e0000001828ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x0000541034347816ULL, 0x008fe20000000035ULL,
0x000000703820723cULL, 0x000b6c0000001820ULL, 0x0000004700477306ULL, 0x000ff00000200c00ULL,
0x0000006800687306ULL, 0x000e700000200c00ULL, 0x0000006a006a7306ULL, 0x000eb00000200c00ULL,
0x0000003000307306ULL, 0x000ee20000200c00ULL, 0x0000541068687816ULL, 0x002fce000000006dULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x000054106a6a7816ULL, 0x004fe20000000075ULL,
0x000000683824723cULL, 0x040b6c0000001824ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x00005410304b7816ULL, 0x008fe20000000049ULL, 0x0000006a381c723cULL, 0x040b6c000000181cULL,
0x0000003100317306ULL, 0x000ea40000200c00ULL, 0x0000004a3818723cULL, 0x000b6c0000001818ULL,
0x0000003200327306ULL, 0x000ee20000200c00ULL, 0x00005410454c7816ULL, 0x002fce000000004cULL,
0x0000003300337306ULL, 0x000e620000200c00ULL, 0x00005410314d7816ULL, 0x004fe40000000048ULL,
0x0000541032437816ULL, 0x008fca0000000047ULL, 0x0000004c3814723cULL, 0x000b620000001814ULL,
0x0000541033357816ULL, 0x002fce0000000046ULL, 0x000000423810723cULL, 0x040b700000001810ULL,
0x000000343804723cULL, 0x000b620000001804ULL, 0xfffff06000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff307224ULL, 0x000fe200078e002eULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffda6000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x000000081e307220ULL, 0x0a0fe40000410000ULL,
0x000000081f317220ULL, 0x000fc40000410000ULL, 0x0000000820207220ULL, 0x080fe40000410000ULL,
0x0000000821217220ULL, 0x080fe40000410000ULL, 0x00000008222d7220ULL, 0x080fe40000410000ULL,
0x00000008232f7220ULL, 0x080fe40000410000ULL, 0x000000081d1d7220ULL, 0x080fe40000410000ULL,
0x00000008181e7220ULL, 0x000fc40000410000ULL, 0x00000008191f7220ULL, 0x080fe40000410000ULL,
0x0000000828287220ULL, 0x080fe40000410000ULL, 0x0000000829297220ULL, 0x080fe40000410000ULL,
0x0000000824247220ULL, 0x080fe40000410000ULL, 0x0000000825257220ULL, 0x080fe40000410000ULL,
0x000000081c1c7220ULL, 0x000fc40000410000ULL, 0x0000000814227220ULL, 0x080fe40000410000ULL,
0x0000000815237220ULL, 0x080fe40000410000ULL, 0x0000000810107220ULL, 0x080fe40000410000ULL,
0x0000000811117220ULL, 0x080fe40000410000ULL, 0x0000000804047220ULL, 0x080fe40000410000ULL,
0x000000081a327220ULL, 0x000fc40000410000ULL, 0x000000081b337220ULL, 0x080fe40000410000ULL,
0x0000000816347220ULL, 0x080fe40000410000ULL, 0x0000000817357220ULL, 0x080fe40000410000ULL,
0x0000000812367220ULL, 0x080fe40000410000ULL, 0x0000000813377220ULL, 0x000fe40000410000ULL,
0x000000ffff167224ULL, 0x000fc400078e0020ULL, 0x000000ffff177224ULL, 0x000fe400078e0021ULL,
0x000000ffff197224ULL, 0x000fe400078e001dULL, 0x000000ffff1a7224ULL, 0x000fe400078e001eULL,
0x000000ffff1b7224ULL, 0x000fe400078e001fULL, 0x000000082a2a7220ULL, 0x080fe40000410000ULL,
0x000000082b2b7220ULL, 0x000fc40000410000ULL, 0x0000000826267220ULL, 0x080fe40000410000ULL,
0x0000000827277220ULL, 0x080fe40000410000ULL, 0x0000000805057220ULL, 0x080fe40000410000ULL,
0x0000000806067220ULL, 0x080fe40000410000ULL, 0x0000000807077220ULL, 0x000fe40000410000ULL,
0x000000ffff137224ULL, 0x000fc400078e0028ULL, 0x000000ffff127224ULL, 0x000fe400078e0029ULL,
0x000000ffff147224ULL, 0x000fe400078e0024ULL, 0x000000ffff157224ULL, 0x000fe400078e0025ULL,
0x000000ffff187224ULL, 0x000fe400078e001cULL, 0x000000ffff1d7224ULL, 0x000fe400078e0022ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0023ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0010ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff217224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000009107f8cULL, 0x0002a2000c80043fULL,
0x000000ffff257224ULL, 0x000fe400078e0026ULL, 0x000000ffff267224ULL, 0x000fe400078e0027ULL,
0x000000ffff247224ULL, 0x000fc400078e002aULL, 0x000000ffff237224ULL, 0x000fe400078e002bULL,
0x000000ffff277224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002fULL,
0x000000ffff297224ULL, 0x000fe400078e0030ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0031ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0032ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0033ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0034ULL, 0x000000ffff227224ULL, 0x000fe400078e0005ULL,
0x000000ffff307224ULL, 0x000fe400078e0035ULL, 0x000000ffff317224ULL, 0x000fe400078e0036ULL,
0x000000ffff327224ULL, 0x000fc400078e0037ULL, 0x000000ffff337224ULL, 0x000fe400078e0006ULL,
0x000000ffff347224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040009077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604357210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000003506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040009077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000402357824ULL, 0x000fe200078e00ffULL, 0x0000000b2c00720cULL, 0x000fc80003f05270ULL,
0xfffffff0351c7812ULL, 0x000fca00078ec0ffULL, 0x000000800d1c7824ULL, 0x000fca00078e021cULL,
0x018400001c047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000202107824ULL, 0x000fe400078e00ffULL, 0x000000010c0f7824ULL, 0x000fc600078e0a0fULL,
0x0000000610107812ULL, 0x000fc800078ec0ffULL, 0x0000000110367812ULL, 0x040fe400078efcffULL,
0x0000000810387812ULL, 0x000fe400078efcffULL, 0x0000000f3600720cULL, 0x080fe40003f26070ULL,
0x0000001010367812ULL, 0x000fe400078efcffULL, 0x0000000f3800720cULL, 0x080fe40003f06070ULL,
0x0000000f3600720cULL, 0x000fc40003fc6070ULL, 0x0000001110387812ULL, 0x040fe400078efcffULL,
0x0000001810367812ULL, 0x040fe400078efcffULL, 0x0000000f1000720cULL, 0x080fe40003f46070ULL,
0x0000000f3800720cULL, 0x080fe40003fa6070ULL, 0x0000000f3600720cULL, 0x000fe40003f66070ULL,
0x00000009103a7812ULL, 0x000fc400078efcffULL, 0x0000001910387812ULL, 0x040fe400078efcffULL,
0x0000002010367812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40005000000ULL,
0xff80000013137808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fc40004800000ULL, 0x0000000f3a00720cULL, 0x080fe40003f86070ULL,
0x0000000f3800720cULL, 0x080fe40003f46070ULL, 0x0000000f3600720cULL, 0x000fe40003f26070ULL,
0x0000002110387812ULL, 0x040fe400078efcffULL, 0x0000002810367812ULL, 0x000fe400078efcffULL,
0xff80000025257808ULL, 0x000fc40004000000ULL, 0xff80000014147808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000015157808ULL, 0x000fe40006000000ULL,
0x0000000f3800720cULL, 0x080fe40003f06070ULL, 0x0000000f3600720cULL, 0x000fe40003f86070ULL,
0x0000002910387812ULL, 0x000fc400078efcffULL, 0x0000003010367812ULL, 0x000fe400078efcffULL,
0xff80000027277808ULL, 0x000fe40007000000ULL, 0xff80000016167808ULL, 0x000fe40007000000ULL,
0xff80000028287808ULL, 0x000fe40006800000ULL, 0xff80000017177808ULL, 0x000fe40006800000ULL,
0x0000000f3800720cULL, 0x000fc40003fc6070ULL, 0x0000000f3600720cULL, 0x000fe40003fa6070ULL,
0x0000003110387812ULL, 0x040fe400078efcffULL, 0x0000003810367812ULL, 0x040fe400078efcffULL,
0x0000003910107812ULL, 0x000fe400078efcffULL, 0xff80000029297808ULL, 0x000fe40005800000ULL,
0xff80000018187808ULL, 0x000fc40005800000ULL, 0xff8000002a2a7808ULL, 0x000fe40005000000ULL,
0xff80000019197808ULL, 0x000fe40005000000ULL, 0xff8000002b2b7808ULL, 0x000fe40004800000ULL,
0xff8000001a1a7808ULL, 0x000fe40004800000ULL, 0x0000000f3800720cULL, 0x080fe40003f66070ULL,
0x0000000f3600720cULL, 0x000fc40003f46070ULL, 0x0000000f1000720cULL, 0x000fe40003f26070ULL,
0xff8000002d2d7808ULL, 0x000fe40004000000ULL, 0xff8000001b1b7808ULL, 0x000fe40004000000ULL,
0xff8000002f2f7808ULL, 0x000fe40006000000ULL, 0xff8000001d1d7808ULL, 0x000fe40006000000ULL,
0xff80000030307808ULL, 0x000fc40007000000ULL, 0xff8000001e1e7808ULL, 0x000fe40007000000ULL,
0xff80000031317808ULL, 0x000fe40006800000ULL, 0xff8000001f1f7808ULL, 0x000fe40006800000ULL,
0xff80000032327808ULL, 0x000fe40005800000ULL, 0xff80000020207808ULL, 0x000fe40005800000ULL,
0xff80000033337808ULL, 0x000fc40005000000ULL, 0xff80000021217808ULL, 0x000fe40005000000ULL,
0xff80000034347808ULL, 0x000fe40004800000ULL, 0xff80000022227808ULL, 0x000fc40004800000ULL,
0x000000130400720bULL, 0x004fe40003f1e000ULL, 0x000000240500720bULL, 0x000fe40003f3e000ULL,
0x00000004130f7208ULL, 0x000fe40004000000ULL, 0x0000000524047208ULL, 0x000fc40004800000ULL,
0x000000120f00720bULL, 0x000fe40003f1e000ULL, 0x000000230400720bULL, 0x000fe40003f3e000ULL,
0x0000000f120f7208ULL, 0x000fe40004000000ULL, 0x0000000423047208ULL, 0x000fe40004800000ULL,
0x000000140f00720bULL, 0x000fe40003f1e000ULL, 0x000000250400720bULL, 0x000fc40003f3e000ULL,
0x0000000f14107208ULL, 0x000fe40004000000ULL, 0x0000000425057208ULL, 0x000fe40004800000ULL,
0x000000151000720bULL, 0x000fe40003f1e000ULL, 0x000000260500720bULL, 0x000fe40003f3e000ULL,
0x00000010150f7208ULL, 0x000fe40004000000ULL, 0x0000000526047208ULL, 0x000fc40004800000ULL,
0x000000160f00720bULL, 0x000fe40003f1e000ULL, 0x000000270400720bULL, 0x000fe40003f3e000ULL,
0x0000000f16107208ULL, 0x000fe40004000000ULL, 0x0000000427057208ULL, 0x000fe40004800000ULL,
0x000000171000720bULL, 0x000fe40003f1e000ULL, 0x000000280500720bULL, 0x000fc40003f3e000ULL,
0x00000010170f7208ULL, 0x000fe40004000000ULL, 0x0000000528047208ULL, 0x000fe40004800000ULL,
0x000000180f00720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fe40003f3e000ULL,
0x0000000f18107208ULL, 0x000fe40004000000ULL, 0x0000000429057208ULL, 0x000fc40004800000ULL,
0x000000191000720bULL, 0x000fe40003f1e000ULL, 0x0000002a0500720bULL, 0x000fe40003f3e000ULL,
0x00000010190f7208ULL, 0x000fe40004000000ULL, 0x000000052a047208ULL, 0x000fe40004800000ULL,
0x0000001a0f00720bULL, 0x000fe40003f1e000ULL, 0x0000002b0400720bULL, 0x000fc40003f3e000ULL,
0x0000000f1a107208ULL, 0x000fe40004000000ULL, 0x000000042b047208ULL, 0x000fe40004800000ULL,
0x0000001b1000720bULL, 0x000fe40003f1e000ULL, 0x0000002d0400720bULL, 0x000fe40003f3e000ULL,
0x000000101b107208ULL, 0x000fe40004000000ULL, 0x000000042d047208ULL, 0x000fc40004800000ULL,
0x0000001d1000720bULL, 0x000fe40003f1e000ULL, 0x0000002f0400720bULL, 0x000fe40003f3e000ULL,
0x000000101d057208ULL, 0x000fe40004000000ULL, 0x000000042f0f7208ULL, 0x000fe40004800000ULL,
0x0000001e0500720bULL, 0x000fe40003f1e000ULL, 0x000000300f00720bULL, 0x000fc40003f3e000ULL,
0x000000051e047208ULL, 0x000fe40004000000ULL, 0x0000000f30107208ULL, 0x000fe40004800000ULL,
0x0000001f0400720bULL, 0x000fe40003f1e000ULL, 0x000000311000720bULL, 0x000fe40003f3e000ULL,
0x000000041f057208ULL, 0x000fe40004000000ULL, 0x00000010310f7208ULL, 0x000fc40004800000ULL,
0x000000200500720bULL, 0x000fe40003f1e000ULL, 0x000000320f00720bULL, 0x000fe40003f3e000ULL,
0x0000000520047208ULL, 0x000fe40004000000ULL, 0x0000000f32107208ULL, 0x000fe40004800000ULL,
0x000000210400720bULL, 0x000fe40003f1e000ULL, 0x000000331000720bULL, 0x000fc40003f3e000ULL,
0x0000000421057208ULL, 0x000fe40004000000ULL, 0x00000010330f7208ULL, 0x000fe40004800000ULL,
0x000000220500720bULL, 0x000fe40003f1e000ULL, 0x000000340f00720bULL, 0x000fe40003f3e000ULL,
0x0000000522057208ULL, 0x000fe40004000000ULL, 0x0000000f34397208ULL, 0x000fe20004800000ULL,
0x00001b427f007947ULL, 0x000fec000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x000000040500720bULL, 0x008fc80003f1e000ULL, 0x00000005043a7208ULL, 0x000fe20004000000ULL,
0x00001b827f007947ULL, 0x000fea000b800000ULL, 0x0c401f0039047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0007367f89ULL, 0x000f2200000e0000ULL,
0x000000043900720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x004fe40003f3e000ULL,
0x00000039040f7208ULL, 0x002fe40004000000ULL, 0x0000000605107208ULL, 0x000fe20004800000ULL,
0x0c201f003a047f89ULL, 0x000e6200000e0000ULL, 0x000000360700720bULL, 0x010fc60003f1e000ULL,
0x0c201f000f387f89ULL, 0x000ea200000e0000ULL, 0x0000000736367208ULL, 0x000fc60004000000ULL,
0x0c201f0010117f89ULL, 0x000ee800000e0000ULL, 0x0c201f0036377f89ULL, 0x0002e400000e0000ULL,
0x000000043a00720bULL, 0x002fe40003f1e000ULL, 0x000000380f00720bULL, 0x004fe40003f3e000ULL,
0x0000003a04047208ULL, 0x000fc40004000000ULL, 0x000000111000720bULL, 0x008fe40003f5e000ULL,
0x0000000f38057208ULL, 0x000fe40004800000ULL, 0x0000001011067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b05387820ULL, 0x002fe20000410000ULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x000000373600720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b14147823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x0000001300107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b24247823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b23237823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b12127823ULL, 0x000fe20000010807ULL, 0x0000002400117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b25257823ULL, 0x000fc40000010838ULL, 0x3c003c00ff3b7424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b16167823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x00000023003a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b18187823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b19197823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b27277823ULL, 0x000fc40000010838ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010838ULL, 0x00000012000f7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b29297823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b2a2a7823ULL, 0x000fe40000010838ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe20000010807ULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x000000113a11723eULL, 0x002fe200000000ffULL,
0x3c003c00ff3a7424ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe40000010807ULL, 0x0000001500157308ULL, 0x000e620000000800ULL,
0x000000100f10723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b30307823ULL, 0x000fc40000010838ULL,
0x0000002500137308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fe40000010838ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000141512723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b22077823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b32327823ULL, 0x100fe40000010838ULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b34347823ULL, 0x000fe20000010838ULL, 0x000000132613723eULL, 0x004fc800000000ffULL,
0x0000001700177308ULL, 0x000e660000000800ULL, 0x0000003a103c723cULL, 0x000f6a00000018ffULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x004fce00000000ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x000000272815723eULL, 0x002fe400000000ffULL, 0x00000002ff287819ULL, 0x000fc80000011602ULL,
0x0000000228187810ULL, 0x040fe20007ffe0ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000000828267824ULL, 0x040fe200078e00ffULL, 0x0000000328197810ULL, 0x040fe20007ffe0ffULL,
0x0000000828257824ULL, 0x040fe200078e00ffULL, 0x0000000428237810ULL, 0x040fe20007ffe0ffULL,
0x0000000828387824ULL, 0x000fe200078e00ffULL, 0x000000292a17723eULL, 0x004fe400000000ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x00000008282a7824ULL, 0x040fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee218ULL, 0x0000000828297824ULL, 0x000fe200078e00ffULL,
0xfffffff838277812ULL, 0x000fe200078ee223ULL, 0x0000003a143c723cULL, 0x020f62000000183cULL,
0xffffffff28237810ULL, 0x000fc40007ffe0ffULL, 0x0000001d001d7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ea20000000800ULL, 0x0000001a1b18723eULL, 0x002fce00000000ffULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002d00247308ULL, 0x0003e20000000800ULL,
0x0000001d1e1a723eULL, 0x004fe400000000ffULL, 0x00000006281e7810ULL, 0x000fc40007ffe0ffULL,
0x00000005281d7810ULL, 0x000fc60007ffe0ffULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x00000008282d7810ULL, 0x002fce0007ffe0ffULL, 0x0000003000307308ULL, 0x000e700000000800ULL,
0x0000000700227308ULL, 0x0005e20000000800ULL, 0x0000002f301b723eULL, 0x002fce00000000ffULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x0000000128077810ULL, 0x004fe20007ffe0ffULL,
0x000000082d307824ULL, 0x000fc600078e00ffULL, 0xfffffff8260f7812ULL, 0x000fe200078ee207ULL,
0x0000000828077824ULL, 0x000fe200078e00ffULL, 0xfffffff82a267812ULL, 0x000fe200078ee219ULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x0000002b2419723eULL, 0x000fe200000000ffULL,
0x0000000828247824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee223ULL,
0xfffffff8302d7812ULL, 0x000fe400078ee22dULL, 0xfffffff807077812ULL, 0x000fe200078ee228ULL,
0x0000003a183c723cULL, 0x020f62000000183cULL, 0x0000002000207308ULL, 0x000ea20000000800ULL,
0x000000212222723eULL, 0x002fc400000000ffULL, 0x000120000d307811ULL, 0x000fe400078e58ffULL,
0xfffffff829287812ULL, 0x000fe400078ee21eULL, 0x0000000c351e7812ULL, 0x000fe200078ec0ffULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0xfffffff824247812ULL, 0x000fe200078ee21dULL,
0x0000001007077824ULL, 0x100fe400078e0230ULL, 0x000000100f0f7824ULL, 0x100fe400078e0230ULL,
0x0000001025257824ULL, 0x000fc400078e0230ULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x0000001f2020723eULL, 0x004fe200000000ffULL, 0x00000010261d7824ULL, 0x100fe400078e0230ULL,
0x0000001027277824ULL, 0x000fe400078e0230ULL, 0x0000000107077824ULL, 0x000fe400078e021eULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x00000010241f7824ULL, 0x100fe400078e0230ULL,
0x000000011e0f7824ULL, 0x000fe200078e020fULL, 0x0000001007007388ULL, 0x0005e20000000800ULL,
0x0000001028297824ULL, 0x000fc400078e0230ULL, 0x000000011e257824ULL, 0x000fe200078e0225ULL,
0x0000003400347308ULL, 0x000ee20000000800ULL, 0x000000313221723eULL, 0x002fe200000000ffULL,
0x000000102a2b7824ULL, 0x100fe200078e0230ULL, 0x000000120f007388ULL, 0x0003e20000000800ULL,
0x000000011e1d7824ULL, 0x040fe400078e021dULL, 0x000000102d2d7824ULL, 0x000fe200078e0230ULL,
0x0000001425007388ULL, 0x0003e20000000800ULL, 0x000000011e277824ULL, 0x040fe200078e0227ULL,
0x0000003637077208ULL, 0x004fe20004800000ULL, 0x000000011e1f7824ULL, 0x040fe200078e021fULL,
0x000000161d007388ULL, 0x0003e20000000800ULL, 0x000000011e297824ULL, 0x000fc400078e0229ULL,
0x000000011e2b7824ULL, 0x000fe200078e022bULL, 0x0000001827007388ULL, 0x0003e20000000800ULL,
0x000000333423723eULL, 0x008fe200000000ffULL, 0x000000011e1e7824ULL, 0x000fe400078e022dULL,
0x0000001a1f007388ULL, 0x0003e80000000800ULL, 0x0000003a203c723cULL, 0x020f62000000183cULL,
0x0000002029007388ULL, 0x0003e80000000800ULL, 0x000000222b007388ULL, 0x0003e80000000800ULL,
0x000000111e007388ULL, 0x0003e80000000800ULL, 0x000400130f007388ULL, 0x0003e80000000800ULL,
0x0004001525007388ULL, 0x0003e80000000800ULL, 0x000400171d007388ULL, 0x0003e60000000800ULL,
0x000000ffff3d7224ULL, 0x020fe200078e003eULL, 0x0004001927007388ULL, 0x0003e80000000800ULL,
0x0004001b1f007388ULL, 0x0003e80000000800ULL, 0x0004002129007388ULL, 0x0003e80000000800ULL,
0x000400232b007388ULL, 0x0003e80000000800ULL, 0x018000041c008388ULL, 0x0003e80000000c00ULL,
0x0182003c1c008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000eff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008000eff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010000eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000012c2c7810ULL, 0x000fe20007ffe0ffULL, 0x000018000eff7f8cULL, 0x0003e6000c80043fULL,
0x0000000a2c00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffbcd000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff427807ULL, 0x002fe20004000000ULL, 0xffffffffff437424ULL, 0x000fe200078e00ffULL,
0x00017ec000477802ULL, 0x000fc40000000f00ULL, 0x000013e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0046ULL, 0xfffe9da000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x000fe20005000000ULL, 0xffffffffff437424ULL, 0x000fe200078e00ffULL,
0x00017f2000477802ULL, 0x000fc40000000f00ULL, 0x0000138000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0046ULL, 0xfffe9dd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0012ULL, 0x00017fa0004a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x008fe400078e0017ULL, 0x0000001fff4e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x000012c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e004cULL, 0xfffe9e4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0017ULL, 0x00018020004a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fe400078e0012ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0000124000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e004cULL, 0xfffe9f3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0000ULL, 0x000180a0004a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e000fULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x000011c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e004cULL, 0xfffea30000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x002fe200078e0002ULL, 0x00018120004a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fe400078e0000ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0000114000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e004cULL, 0xfffea2b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0010ULL, 0x000181a0004a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0011ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x000010c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e004cULL, 0xfffebfc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0010ULL, 0x00018210004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x0000105000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e004cULL,
0xfffebf8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x004fe20004000000ULL,
0xffffffffff437424ULL, 0x000fe200078e00ffULL, 0x0001827000477802ULL, 0x000fc40000000f00ULL,
0x0000103000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff417224ULL, 0x000fe200078e0046ULL,
0xfffedca000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe20005000000ULL,
0xffffffffff437424ULL, 0x000fe200078e00ffULL, 0x000182d000477802ULL, 0x000fc40000000f00ULL,
0x00000fd000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0046ULL,
0xfffedcd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0043ULL,
0x00018340004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x00000f2000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e004cULL, 0xfffedd7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0043ULL, 0x000183b0004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00000eb000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e004cULL,
0xfffede6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x00018430004a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4d7224ULL, 0x000fe400078e0040ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00000e3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e004cULL,
0xfffee25000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x000184a0004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x00000dc000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e004cULL, 0xfffee21000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e001dULL, 0x00018520004a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fe400078e003cULL, 0x0000001fff4e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x00000d4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e004cULL, 0xfffefcf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e001dULL, 0x00018590004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00000cd000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e004cULL,
0xfffefcb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x004fe20004000000ULL,
0xffffffffff437424ULL, 0x000fe200078e00ffULL, 0x000185f000477802ULL, 0x000fc40000000f00ULL,
0x00000cb000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff407224ULL, 0x000fe200078e0046ULL,
0xffff189000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe20005000000ULL,
0xffffffffff437424ULL, 0x000fe200078e00ffULL, 0x0001865000477802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff417224ULL, 0x000fe200078e0046ULL,
0xffff18b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0043ULL,
0x000186c0004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x00000ba000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e004cULL, 0xffff195000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0043ULL, 0x00018730004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00000b3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e004cULL,
0xffff1a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x000187b0004a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4d7224ULL, 0x000fe400078e0040ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x00000ab000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e004cULL,
0xffff1e3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x00018820004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x00000a4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e004cULL, 0xffff1df000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e001dULL, 0x000188a0004a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fe400078e003cULL, 0x0000001fff4e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x000009c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e004cULL, 0xffff38d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e001dULL, 0x00018910004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x0000095000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e004cULL,
0xffff389000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x004fe20004000000ULL,
0xffffffffff437424ULL, 0x000fe200078e00ffULL, 0x0001897000477802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff447224ULL, 0x000fe200078e0046ULL,
0xffff547000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe20004800000ULL,
0xffffffffff437424ULL, 0x000fe200078e00ffULL, 0x000189d000477802ULL, 0x000fc40000000f00ULL,
0x000008d000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff437224ULL, 0x000fe200078e0046ULL,
0xffff549000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0045ULL,
0x00018a40004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0000082000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e004cULL, 0xffff553000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0045ULL, 0x00018ab0004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x000007b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e004cULL,
0xffff562000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x00018b30004a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff4d7224ULL, 0x000fe400078e0016ULL,
0x0000001fff4e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x0000073000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e004cULL,
0xffff5a1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0015ULL,
0x00018ba0004a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x000006c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e004cULL, 0xffff59d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0000ULL, 0x00018c20004a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fe400078e0005ULL, 0x0000001fff4e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4f7424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e004cULL, 0xffff74f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0000ULL, 0x00018c90004a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4f7424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e004cULL,
0xffff74b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0f7224ULL, 0x000fe200078e0005ULL,
0x00018d1000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0037ULL,
0xffffe45000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0f7224ULL, 0x002fe200078e0039ULL,
0x00018d9000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x004fea0003c00000ULL, 0x000000373900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0006ULL, 0x00018e1000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x000fe200078e00ffULL, 0x00000039373c7208ULL, 0x000fe20004000000ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000370600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0007ULL, 0x00018e9000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x000fe200078e00ffULL, 0x0000000637067208ULL, 0x000fe20004000000ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000370700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e003aULL, 0x00018f1000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000000737367208ULL, 0x000fe20004000000ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000373a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e003cULL, 0x00018f9000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000003a37047208ULL, 0x000fe20004000000ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000373c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0006ULL, 0x0001901000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000003c37057208ULL, 0x000fe20004000000ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000370600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0036ULL, 0x0001909000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000000637067208ULL, 0x000fe20004000000ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe24000007947ULL, 0x000fea000383ffffULL,
0x0180000008007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000800008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff08ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000008027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000800007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe6de002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff117424ULL, 0x000fe200078e00ffULL, 0x0000003e00007348ULL, 0x000fe80003800000ULL,
0x0c0000380f377389ULL, 0x0002a200000e0037ULL, 0xfffe6da010007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff4b7424ULL, 0x000fe200078e00ffULL, 0x0000004f00007348ULL, 0x000fe80003800000ULL,
0x0000004d4c4c7389ULL, 0x0002a200000e004eULL, 0xfffe6d604a007950ULL, 0x000fea0003c3ffffULL,
0x000000014200780cULL, 0x000fe20003f45070ULL, 0x0000004300007348ULL, 0x000fd80003800000ULL,
0x0000000000427806ULL, 0x000fc800050e0100ULL, 0x0000004342467212ULL, 0x000fe200078ec0ffULL,
0x000000ffff427224ULL, 0x000fe400078e0047ULL, 0x00000000ff437424ULL, 0x000fc800078e00ffULL,
0xfffe6cf042007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000450ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e18ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ed8ULL, 0x0000000000000a08ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018e0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018f0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001980ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001984ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b80ULL, 0x0000000000019400ULL, 0x8700001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001af80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001afd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b350ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001980ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019600ULL, 0x0000000000019600ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001af80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b350ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin_len = 111664;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
