/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000196d0ULL, 0x0000000000019350ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x00000000000174b0ULL, 0x0000000000000180ULL,
0x000b0022000004bdULL, 0x0000000000017630ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x0000000000017670ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x00000000000176b0ULL,
0x0000000000000150ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000017800ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000174b000000000ULL, 0x0000040400000000ULL,
0x810c0000015c0400ULL, 0x005bc40400288080ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8808288080820828ULL, 0x2880808908288080ULL, 0x808e082880808d08ULL,
0x082880808f082880ULL, 0x8080910828808090ULL, 0xa108288080920828ULL, 0x288080c008288080ULL,
0x80c408288080c208ULL, 0x08288080c5082880ULL, 0x8080c708288080c6ULL, 0xcd08288080c90828ULL,
0x288080de08288080ULL, 0x8280162880808408ULL, 0x0000000003102880ULL, 0x8080849200000000ULL,
0x0000000000220028ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x000174b000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808908288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080910828808090ULL,
0xa108288080920828ULL, 0x288080c008288080ULL, 0x80c408288080c208ULL, 0x08288080c5082880ULL,
0x8080c908288080c7ULL, 0xde08288080cd0828ULL, 0x2880808808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808088ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0001763000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808808288080ULL, 0x808d082880808908ULL,
0x082880808e082880ULL, 0x808090082880808fULL, 0x9208288080910828ULL, 0x288080a108288080ULL,
0x80c408288080c208ULL, 0x08288080c5082880ULL, 0x8080c708288080c6ULL, 0xcd08288080c90828ULL,
0x288080de08288080ULL, 0x828016288080c008ULL, 0x0000000003102880ULL, 0x8080c09200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000023000000000ULL, 0x0001767000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808808288080ULL, 0x808d082880808908ULL, 0x082880808e082880ULL,
0x808090082880808fULL, 0x9208288080910828ULL, 0x288080a108288080ULL, 0x80c208288080c008ULL,
0x08288080c4082880ULL, 0x8080c608288080c5ULL, 0xcd08288080c70828ULL, 0x288080de08288080ULL,
0x828016288080c908ULL, 0x0000000003102880ULL, 0x8080c99200000000ULL, 0x0000000000220028ULL,
0x0000002cffffffffULL, 0x0000030800000000ULL, 0x000176b000000000ULL, 0x0000015000000000ULL,
0x0000180400000000ULL, 0x80c0288080c90900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL,
0x0008230400000087ULL, 0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL,
0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL,
0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL,
0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL,
0x0000001700080a04ULL, 0x0048190300480160ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x0198290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000010001982804ULL, 0x0000046000000120ULL, 0x00001d3000001c80ULL,
0x00001f9000001e20ULL, 0x00002410000023e0ULL, 0x000024b000002460ULL, 0x0000415000004120ULL,
0x000041f0000041a0ULL, 0x00005ef000005e60ULL, 0x0000616000006000ULL, 0x00006600000065d0ULL,
0x000066a000006650ULL, 0x0000816000008130ULL, 0x00008200000081b0ULL, 0x00009e1000009d80ULL,
0x0000a08000009f20ULL, 0x0000a5200000a4f0ULL, 0x0000a5c00000a570ULL, 0x0000c0800000c050ULL,
0x0000c1200000c0d0ULL, 0x0000dd400000dcb0ULL, 0x0000dfb00000de50ULL, 0x0000e4500000e420ULL,
0x0000e4f00000e4a0ULL, 0x0000ffd00000ffa0ULL, 0x0001007000010020ULL, 0x0001113000011120ULL,
0x00015a10000118e0ULL, 0x00015a6000015a50ULL, 0x00015ac000015a70ULL, 0x00015b0000015ae0ULL,
0x0001674000015b10ULL, 0x000167f000016790ULL, 0x000168b000016850ULL, 0x0001697000016910ULL,
0x00016a10000169c0ULL, 0x00016ab000016a60ULL, 0x00016b6000016b00ULL, 0x00016c1000016bb0ULL,
0x00016cb000016c60ULL, 0x00016d5000016d00ULL, 0x00016e0000016da0ULL, 0x00016eb000016e50ULL,
0x00016f5000016f00ULL, 0x00016ff000016fa0ULL, 0x000170a000017040ULL, 0x00017150000170f0ULL,
0x000171f0000171a0ULL, 0x000172b000017250ULL, 0x0001737000017310ULL, 0x00017430000173d0ULL,
0x0600390400017490ULL, 0x000000ff00000200ULL, 0x003f010000010600ULL, 0x0000000f00000250ULL,
0x003f012000010608ULL, 0x0000000f000002f0ULL, 0x003f012000010688ULL, 0x0000000f00000400ULL,
0x003f0120000106a8ULL, 0x000000ff00000430ULL, 0x003f0100000106b8ULL, 0x000000ff00000500ULL,
0x003f010700010600ULL, 0x0000001400000600ULL, 0x003f01020001068cULL, 0x0000001400000690ULL,
0x003f010100010688ULL, 0x000000ff00000d10ULL, 0x003f0107000106a8ULL, 0x000000ff00000e30ULL,
0x003f0101000106a8ULL, 0x000000ff00000e90ULL, 0x003f0101000106b8ULL, 0x000000ff00000fc0ULL,
0x003f0105000106bcULL, 0x000000ff00001190ULL, 0x003f0105000106bcULL, 0x000000ff000018c0ULL,
0x003f0107000106b0ULL, 0x000000ff00001940ULL, 0x003f0101000106b0ULL, 0x00000014000019a0ULL,
0x003f010100010608ULL, 0x00000014000019c0ULL, 0x003f01050001060cULL, 0x0000001400001b90ULL,
0x003f01050001060cULL, 0x000000ff00002140ULL, 0x003f0105000106acULL, 0x000000ff00002310ULL,
0x003f0105000106acULL, 0x000000ff00003530ULL, 0x003f0101000106b8ULL, 0x000000ff00003560ULL,
0x003f0105000106bcULL, 0x000000ff00003720ULL, 0x003f0105000106bcULL, 0x000000ff00003e00ULL,
0x003f0107000106a8ULL, 0x000000ff00003e80ULL, 0x003f0101000106a8ULL, 0x000000ff00003ea0ULL,
0x003f0105000106b4ULL, 0x000000ff00004070ULL, 0x003f0105000106b4ULL, 0x000000ff00005180ULL,
0x003f0101000106b8ULL, 0x000000ff000051f0ULL, 0x003f010100010688ULL, 0x000000ff00005250ULL,
0x003f0105000106bcULL, 0x000000ff00005420ULL, 0x003f0105000106bcULL, 0x000000ff00005b00ULL,
0x003f0107000106b0ULL, 0x000000ff00005b80ULL, 0x003f0101000106b0ULL, 0x0000001400005be0ULL,
0x003f010100010628ULL, 0x0000001400005c00ULL, 0x003f01050001062cULL, 0x0000001400005dd0ULL,
0x003f01050001062cULL, 0x000000ff00006330ULL, 0x003f0105000106acULL, 0x000000ff00006500ULL,
0x003f0105000106acULL, 0x000000ff00007530ULL, 0x003f0101000106b8ULL, 0x000000ff00007560ULL,
0x003f0105000106bcULL, 0x000000ff00007720ULL, 0x003f0105000106bcULL, 0x000000ff00007e00ULL,
0x003f0107000106a8ULL, 0x000000ff00007e80ULL, 0x003f0101000106a8ULL, 0x000000ff00007eb0ULL,
0x003f0105000106b4ULL, 0x000000ff00008080ULL, 0x003f0105000106b4ULL, 0x000000ff000090b0ULL,
0x003f0101000106b8ULL, 0x000000ff00009120ULL, 0x003f010100010690ULL, 0x000000ff00009170ULL,
0x003f0105000106bcULL, 0x000000ff00009340ULL, 0x003f0105000106bcULL, 0x000000ff00009a20ULL,
0x003f0107000106b0ULL, 0x000000ff00009aa0ULL, 0x003f0101000106b0ULL, 0x0000001400009b00ULL,
0x003f010100010648ULL, 0x0000001400009b20ULL, 0x003f01050001064cULL, 0x0000001400009cf0ULL,
0x003f01050001064cULL, 0x000000ff0000a250ULL, 0x003f0105000106acULL, 0x000000ff0000a420ULL,
0x003f0105000106acULL, 0x000000ff0000b450ULL, 0x003f0101000106b8ULL, 0x000000ff0000b480ULL,
0x003f0105000106bcULL, 0x000000ff0000b640ULL, 0x003f0105000106bcULL, 0x000000ff0000bd20ULL,
0x003f0107000106a8ULL, 0x000000ff0000bda0ULL, 0x003f0101000106a8ULL, 0x000000ff0000bdd0ULL,
0x003f0105000106b4ULL, 0x000000ff0000bfa0ULL, 0x003f0105000106b4ULL, 0x000000ff0000cfd0ULL,
0x003f0101000106b8ULL, 0x000000ff0000d040ULL, 0x003f010100010698ULL, 0x000000ff0000d0a0ULL,
0x003f0105000106bcULL, 0x000000ff0000d270ULL, 0x003f0105000106bcULL, 0x000000ff0000d950ULL,
0x003f0107000106b0ULL, 0x000000ff0000d9d0ULL, 0x003f0101000106b0ULL, 0x000000140000da30ULL,
0x003f010100010668ULL, 0x000000140000da50ULL, 0x003f01050001066cULL, 0x000000140000dc20ULL,
0x003f01050001066cULL, 0x000000ff0000e180ULL, 0x003f0105000106acULL, 0x000000ff0000e350ULL,
0x003f0105000106acULL, 0x000000ff0000f380ULL, 0x003f0101000106b8ULL, 0x000000ff0000f3b0ULL,
0x003f0105000106bcULL, 0x000000ff0000f570ULL, 0x003f0105000106bcULL, 0x000000ff0000fc70ULL,
0x003f0107000106a8ULL, 0x000000ff0000fcf0ULL, 0x003f0101000106a8ULL, 0x000000ff0000fd20ULL,
0x003f0105000106b4ULL, 0x000000ff0000fef0ULL, 0x003f0105000106b4ULL, 0x000000ff00010f00ULL,
0x003f0101000106b8ULL, 0x000000ff00010f60ULL, 0x003f0101000106a0ULL, 0x000000ff00011af0ULL,
0x003f010100010600ULL, 0x000000ff000125e0ULL, 0x003f010500010604ULL, 0x000000ff000127b0ULL,
0x003f010500010604ULL, 0x000000ff00012b30ULL, 0x003f010100010600ULL, 0x000000ff00012b60ULL,
0x003f010500010604ULL, 0x000000ff00012d20ULL, 0x003f010500010604ULL, 0x0000001700014e10ULL,
0x003f010100000000ULL, 0x0000001700014f40ULL, 0x003f010500000004ULL, 0x0000001700015110ULL,
0x003f010500000004ULL, 0x0000001a000165a0ULL, 0x003f010100000000ULL, 0x0000001a00016600ULL,
0x003f010100000008ULL, 0x0000001a00016660ULL, 0x003f010100000010ULL, 0x0000001a000166d0ULL,
0x003f010100000018ULL, 0x00101c0400053803ULL, 0x00012d8000011a40ULL, 0x0001671000012e30ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003ccULL, 0x0000001a00000002ULL,
0x00000000000002f4ULL, 0x0000001a00000002ULL, 0x000000000000021cULL, 0x0000001a00000002ULL,
0x0000000000000134ULL, 0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL,
0x00000000000003a4ULL, 0x0000001a00000002ULL, 0x00000000000002ccULL, 0x0000001a00000002ULL,
0x00000000000001f7ULL, 0x0000001a00000002ULL, 0x000000000000010cULL, 0x0000001a00000002ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x0000001300067300ULL, 0x000ee200000e0000ULL, 0x0000000805057824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000f220000002200ULL, 0x00000200ff0b7424ULL, 0x000fc600078e00ffULL,
0x0000000000177919ULL, 0x000ee20000000000ULL, 0x0000001300137309ULL, 0x000ea60000000000ULL,
0x0000000000127919ULL, 0x000ee80000002600ULL, 0x0000000000107919ULL, 0x000ee20000002700ULL,
0x00000005ff187819ULL, 0x002fc6000001160fULL, 0x0000000000077919ULL, 0x000e680000000000ULL,
0x00001fff020d7589ULL, 0x0045e200000e0000ULL, 0x0000010002007a24ULL, 0x010fc600078e0203ULL,
0x00001fff18187589ULL, 0x000f2200000e0000ULL, 0x00000000000f7a24ULL, 0x000fe400078e020fULL,
0x00000010170c7824ULL, 0x008fe400078e00ffULL, 0x0000000812007824ULL, 0x000fe200078e00ffULL,
0x000000ff0f00720cULL, 0x040fe40003f25270ULL, 0x0000000f0f00780cULL, 0x000fe20003f44070ULL,
0x0000001005007224ULL, 0x000fe200078e0200ULL, 0x000000030f00780cULL, 0x000fc40003f64070ULL,
0x0000007f0f00780cULL, 0x000fe40003f84070ULL, 0x000000070600720cULL, 0x002fca0003f02070ULL,
0x3fffff80ff029424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x000000040d047824ULL, 0x010fe400078e0218ULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x01060002ff009388ULL, 0x0003e20000000a00ULL, 0x0000000204087824ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fc400078e00ffULL, 0x0000000108097824ULL, 0x040fe400078e0217ULL,
0x00000020080e7824ULL, 0x000fe200078e00ffULL, 0x010608040f00a388ULL, 0x0005e20000008a00ULL,
0x000000010f00780cULL, 0x000fe20003f44070ULL, 0x0000000100027824ULL, 0x002fe400078e0208ULL,
0xffffffe00e0e7812ULL, 0x000fe200078ee209ULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x0000000808097817ULL, 0x000fe20007800000ULL, 0x7fffff60ff07b424ULL, 0x000fc400078e00ffULL,
0xff317217ff0ac424ULL, 0x000fe400078e00ffULL, 0x0000000109097824ULL, 0x000fe200078e0a08ULL,
0x0000000108087810ULL, 0x000fe20007ffe0ffULL, 0x010688060f00b388ULL, 0x0003e20000008a00ULL,
0x00005c0002027625ULL, 0x000fe400078e000bULL, 0x000000ff0900720cULL, 0x040fe20003f63070ULL,
0x0104000a0f00c388ULL, 0x0007e20000004800ULL, 0x0000000100047824ULL, 0x004fe200078e0208ULL,
0x000000010900780cULL, 0x000fe20003f83070ULL, 0x0000000108007824ULL, 0x000fc400078e0217ULL,
0x0000002008117824ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x000fe200078e000bULL,
0x000001f00c077812ULL, 0x002fe400078ec0ffULL, 0xffffffe011007812ULL, 0x000fe200078ee200ULL,
0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL, 0x0000000702067210ULL, 0x080fe20007fbe0ffULL,
0x7fffff00ff09a424ULL, 0x000fe200078e00ffULL, 0x0000000704047210ULL, 0x000fe20007fde0ffULL,
0x3fffff80ff0a9424ULL, 0x008fc400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL,
0x0106a8080f00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff027224ULL, 0x000fe400078e0a13ULL,
0x000000ffff077224ULL, 0x000fe200028e0603ULL, 0x0106b80aff009388ULL, 0x000fe20000000a00ULL,
0x000000100e117824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001000137824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e2000d901c46ULL,
0x000000ffff007224ULL, 0x000fc400078e0002ULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x0000000004137faeULL, 0x0003e6000e101c46ULL, 0x0000600010027625ULL, 0x000fe200078e0003ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01060400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602157981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fc40003f05270ULL,
0x000000ff15007810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff167819ULL, 0x000fce0000011600ULL,
0x0001148000008947ULL, 0x000fea0003800000ULL, 0x0000000818147824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0314ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000000210137824ULL, 0x000fe200078e00ffULL,
0x0000580012007a10ULL, 0x000fe20007ffe0ffULL, 0x0106880014ff7f8cULL, 0x0005e8000c80043fULL,
0x0000580013137a24ULL, 0x000fcc00078e0200ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0000001415037217ULL, 0x006fe20007800000ULL, 0x00000100ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff007819ULL, 0x100fe40000011617ULL, 0x000000f00c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a14ULL, 0x0000000200047810ULL, 0x000fe20007ffe0ffULL,
0x0000000114027824ULL, 0x000fe200078e0200ULL, 0x0000000400057810ULL, 0x040fe40007ffe0ffULL,
0x000000030000720cULL, 0x080fe20003f66070ULL, 0x0000001002097824ULL, 0x000fe200078e00ffULL,
0x0000000600087810ULL, 0x000fe20007ffe0ffULL, 0x0000000102007824ULL, 0x000fe200078e0217ULL,
0x000000030400720cULL, 0x080fe20003f46070ULL, 0x0000000114047824ULL, 0x040fe200078e0204ULL,
0x000000030500720cULL, 0x080fe20003f26070ULL, 0x0000000114067824ULL, 0x000fe200078e0205ULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x0000620013027a24ULL, 0x000fe200078e0202ULL,
0xfffffff009007812ULL, 0x000fe200078ee200ULL, 0x0000000104057824ULL, 0x000fc400078e0217ULL,
0x00000010040a7824ULL, 0x000fe400078e00ffULL, 0x0000000114087824ULL, 0x000fe400078e0208ULL,
0x0000000106077824ULL, 0x000fe200078e0217ULL, 0xfffffff00a0a7812ULL, 0x000fe200078ee205ULL,
0x00000010060e7824ULL, 0x000fe400078e00ffULL, 0x00005e0002027625ULL, 0x000fc600078e000fULL,
0xfffffff00e0e7812ULL, 0x000fe200078ee207ULL, 0x0000620013047a24ULL, 0x040fe200078e0204ULL,
0x0000000d02027210ULL, 0x000fe20007fbe0ffULL, 0x0000620013067a24ULL, 0x040fe400078e0206ULL,
0x0000620013097a24ULL, 0x000fe400078e0208ULL, 0x00005e0004047625ULL, 0x000fc800078e000fULL,
0x00000001080b7824ULL, 0x000fe200078e0217ULL, 0x0000000d04047210ULL, 0x000fe20007f9e0ffULL,
0x00000010080c7824ULL, 0x000fe400078e00ffULL, 0x00005e0006067625ULL, 0x000fc600078e000fULL,
0xfffffff00c0c7812ULL, 0x000fe200078ee20bULL, 0x00005e0009087625ULL, 0x000fe200078e000fULL,
0x0000c000000b7811ULL, 0x000fe400078e20ffULL, 0x0000c0000e0f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff037224ULL, 0x000fe200028e0603ULL, 0x0000000d06067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200020e0605ULL, 0x0000000d08087210ULL, 0x000fe40007fde0ffULL,
0x0000c0000a0d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000c0000c117811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e8000d901c46ULL,
0x00000000040d7faeULL, 0x0003e8000d101c46ULL, 0x00000000060f7faeULL, 0x0003e8000c901c46ULL,
0x0000000008117faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000001417007211ULL, 0x004fe200078fe0ffULL, 0x00000100ff097424ULL, 0x000fe200078e00ffULL,
0x000000f00c0f7812ULL, 0x000fc400078ec0ffULL, 0x0000000200047810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x140fe200078e0217ULL, 0x0000000400067810ULL, 0x040fe20007ffe0ffULL,
0x0000001000077824ULL, 0x000fe400078e00ffULL, 0x0000000104037824ULL, 0x142fe400078e0217ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0xfffffff0070a7812ULL, 0x000fe200078ee202ULL,
0x0000620013027a24ULL, 0x000fe200078e0200ULL, 0x0000000600007810ULL, 0x000fe20007ffe0ffULL,
0x0000000106057824ULL, 0x000fe200078e0217ULL, 0xfffffff0080d7812ULL, 0x000fe200078ee203ULL,
0x00000010060e7824ULL, 0x000fc400078e00ffULL, 0x00005e0002027625ULL, 0x000fe200078e0009ULL,
0x0000c0000d0d7811ULL, 0x000fe400078e20ffULL, 0xfffffff00e0e7812ULL, 0x000fe200078ee205ULL,
0x0000620013047a24ULL, 0x040fe200078e0204ULL, 0x0000000f02027210ULL, 0x000fe20007f1e0ffULL,
0x0000620013067a24ULL, 0x040fe400078e0206ULL, 0x0000620013087a24ULL, 0x000fe400078e0200ULL,
0x00005e0004047625ULL, 0x000fc800078e0009ULL, 0x00005e0006067625ULL, 0x000fe200078e0009ULL,
0x0000000f04047210ULL, 0x000fc60007f3e0ffULL, 0x00000001000b7824ULL, 0x000fe400078e0217ULL,
0x00005e0008087625ULL, 0x000fc800078e0009ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x0000000f08087210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000000f06067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0xfffffff000007812ULL, 0x000fe200078ee20bULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000c0000a0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000c0000e0f7811ULL, 0x000fe400078e20ffULL, 0x0000c00000117811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e8000b901c46ULL,
0x00000000040d7faeULL, 0x0003e8000b901c46ULL, 0x00000000060f7faeULL, 0x0003e8000b901c46ULL,
0x0000000008117faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff1600720cULL, 0x000fe20003f05270ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff1e7f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff027f8cULL, 0x002e62000c80043fULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0001008000008947ULL, 0x000fea0003800000ULL,
0x000000ffff447224ULL, 0x002fe400078e0003ULL, 0xff317217ff487424ULL, 0x000fc400078e00ffULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fc400078e00ffULL,
0x0000010011007824ULL, 0x000fca00078e00ffULL, 0x000000150000720cULL, 0x000fda0003f06070ULL,
0x0000ffd000000947ULL, 0x004fea0003800000ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0106bc00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000111037810ULL, 0x040fe40007ffe0ffULL, 0x0000002011107811ULL, 0x000fe400078e40ffULL,
0x000000160300720cULL, 0x000fc60003f26070ULL, 0x0000620013077a24ULL, 0x000fd400078e0210ULL,
0x000003b000009947ULL, 0x000fea0003800000ULL, 0x0000001015037217ULL, 0x000fe40007800000ULL,
0x00000004ff007819ULL, 0x000fc60000011617ULL, 0x0000000103037824ULL, 0x000fe200078e0a10ULL,
0x0000000200057810ULL, 0x000fe20007ffe0ffULL, 0x0000000114027824ULL, 0x000fc600078e0200ULL,
0x0000000314037217ULL, 0x040fe20007800000ULL, 0x0000000114067824ULL, 0x000fe400078e0205ULL,
0x0000000102047824ULL, 0x140fe400078e0217ULL, 0x0000000103037824ULL, 0x000fe400078e0a14ULL,
0x00000010020d7824ULL, 0x000fe400078e00ffULL, 0x00000001060b7824ULL, 0x040fe200078e0217ULL,
0x000000030500720cULL, 0x080fe20003f66070ULL, 0x00000010060c7824ULL, 0x000fe200078e00ffULL,
0x0000000400057810ULL, 0x000fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0207ULL,
0x000000030000720cULL, 0x000fc40003f86070ULL, 0xfffffff00d0e7812ULL, 0x000fe200078ee204ULL,
0x0000001017047824ULL, 0x000fe200078e00ffULL, 0xfffffff00c197812ULL, 0x000fe200078ee20bULL,
0x00000100ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000600007810ULL, 0x000fe20007ffe0ffULL,
0x00000001140c7824ULL, 0x000fe200078e0205ULL, 0x000000030500720cULL, 0x080fe40003f46070ULL,
0x000000030000720cULL, 0x000fe20003f06070ULL, 0x00005e0002027625ULL, 0x000fe200078e000bULL,
0x000000f0040f7812ULL, 0x000fc600078ec0ffULL, 0x0000000106047824ULL, 0x100fe400078e0207ULL,
0x00000001141c7824ULL, 0x000fe400078e0200ULL, 0x000000010c007824ULL, 0x040fe400078e0207ULL,
0x000000010c0d7824ULL, 0x040fe400078e0217ULL, 0x000000100c1a7824ULL, 0x000fe200078e00ffULL,
0x0000000f020c7210ULL, 0x000fe20007fbe0ffULL, 0x00005e0004047625ULL, 0x000fc600078e000bULL,
0xfffffff01a1a7812ULL, 0x000fe200078ee20dULL, 0x000000011c067824ULL, 0x000fe400078e0207ULL,
0x000000ffff0d7224ULL, 0x000fe200028e0603ULL, 0x0000000f04047210ULL, 0x000fe20007fbe0ffULL,
0x00005e0000027625ULL, 0x000fc800078e000bULL, 0x00005e0006067625ULL, 0x000fc800078e000bULL,
0x000000011c007824ULL, 0x000fe200078e0217ULL, 0x0000000f06067210ULL, 0x080fe20007fde0ffULL,
0x000000101c0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0x0000000f02027210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0xfffffff00b007812ULL, 0x000fe400078ee200ULL, 0x0000e0000e0b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff037224ULL, 0x000fe200028e0603ULL, 0x0000e000190f7811ULL, 0x000fc400078e20ffULL,
0x0000e0001a197811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000e101c46ULL, 0x0000e000001b7811ULL, 0x000fc600078e20ffULL,
0x00000000040f7faeULL, 0x0003e8000d901c46ULL, 0x0000000002197faeULL, 0x0003e8000d101c46ULL,
0x00000000061b7faeULL, 0x0003e2000c101c46ULL, 0x000002e000007947ULL, 0x000fea0003800000ULL,
0x0000001417007211ULL, 0x000fe200078fe0ffULL, 0x00000100ff0d7424ULL, 0x000fc600078e00ffULL,
0x0000000200047810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e0217ULL,
0x0000000400067810ULL, 0x040fe20007ffe0ffULL, 0x00000010000b7824ULL, 0x000fe400078e00ffULL,
0x0000000104037824ULL, 0x040fe400078e0217ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0xfffffff00b0e7812ULL, 0x000fe200078ee202ULL, 0x0000000100027824ULL, 0x040fe200078e0207ULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x0000000106057824ULL, 0x000fe200078e0217ULL,
0xfffffff00c0f7812ULL, 0x000fe200078ee203ULL, 0x0000001017037824ULL, 0x000fc400078e00ffULL,
0x00000010061a7824ULL, 0x000fe200078e00ffULL, 0x0000e0000f0f7811ULL, 0x000fe200078e20ffULL,
0x0000000104047824ULL, 0x000fe200078e0207ULL, 0x000000f0030b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e000dULL, 0xfffffff01a197812ULL, 0x000fc600078ee205ULL,
0x0000000106067824ULL, 0x100fe200078e0207ULL, 0x0000000b02027210ULL, 0x000fe20007f1e0ffULL,
0x00000001000c7824ULL, 0x000fe200078e0207ULL, 0x0000e00019197811ULL, 0x000fe200078e20ffULL,
0x00005e0004047625ULL, 0x000fc800078e000dULL, 0x00005e0006067625ULL, 0x000fe200078e000dULL,
0x0000000b04047210ULL, 0x000fc60007f5e0ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e000dULL,
0x00000001001a7824ULL, 0x000fe200078e0217ULL, 0x0000000b0c0c7210ULL, 0x080fe20007f7e0ffULL,
0x00000010001b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000000b06067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0xfffffff01b1a7812ULL, 0x000fe200078ee21aULL, 0x000000ffff0d7224ULL, 0x000fe200018e060dULL,
0x0000e0000e0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000e0001a1b7811ULL, 0x000fc600078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000b901c46ULL, 0x00000000040f7faeULL, 0x0003e8000b901c46ULL,
0x0000000006197faeULL, 0x0003e8000b901c46ULL, 0x000000000c1b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff1a7f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080014067f8cULL, 0x0006a4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01060c0014057984ULL, 0x000f240000000800ULL, 0x8000000005ff7812ULL, 0x014fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x00000004020b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c0014057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x004fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010170f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fe20000011617ULL,
0xffffffffff0d7424ULL, 0x000fc600078e00ffULL, 0x0000000c00037812ULL, 0x000fe400078ec0ffULL,
0x000000700f0e7812ULL, 0x000fca00078ec0ffULL, 0x000000010e0e7824ULL, 0x000fca00078e0203ULL,
0x010000000e037984ULL, 0x000ea80000000800ULL, 0x010200000e057984ULL, 0x0006620000000800ULL,
0x000000480300720bULL, 0x004fe20003f1d000ULL, 0x00014aa27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800000e0100ULL, 0x0000ffff00077812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff007424ULL, 0x000fe400078e00ffULL,
0x000000ffff5d7224ULL, 0x000fc400078e0048ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff0b7424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff1800720cULL, 0x000fe40003f05270ULL, 0x000000480300720bULL, 0x000fe20003f54000ULL,
0x00014a427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000027806ULL, 0x000fc400010e0100ULL,
0x00000003485d7209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991002047816ULL, 0x000fc600000000ffULL, 0x0104005d0e008388ULL, 0x0005e20000000800ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000005d48047221ULL, 0x004fe20000010000ULL, 0x000000ff02ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL,
0x0000000400197308ULL, 0x0004ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff047819ULL, 0x004fe20000011617ULL, 0x000149a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0419047589ULL, 0x0084e400000e0000ULL, 0x000000043c3c7220ULL, 0x088fe20000410000ULL,
0x000000043d3d7220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x000000042c2c7220ULL, 0x080fe20000410000ULL,
0x000000042d2d7220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x080fe20000410000ULL, 0x0000000428287220ULL, 0x080fe20000410000ULL,
0x0000000429297220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x0000000430307220ULL, 0x080fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000438387220ULL, 0x080fe20000410000ULL,
0x0000000439397220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0002ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001912127220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817047811ULL, 0x004fe200078ff0ffULL,
0x000148927f007947ULL, 0x000fea000b800000ULL, 0x00001f0419047589ULL, 0x0004e400000e0000ULL,
0x000000043e3e7220ULL, 0x088fe20000410000ULL, 0x000000043f3f7220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x080fe20000410000ULL,
0x000000042a2a7220ULL, 0x080fe20000410000ULL, 0x000000042b2b7220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x000000043a3a7220ULL, 0x080fe20000410000ULL, 0x000000043b3b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff07ff7812ULL, 0x000fda0007806002ULL,
0x8000005d03030221ULL, 0x000fe20000010000ULL, 0x00007610ff000816ULL, 0x000fc60000000000ULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x00000003000a0308ULL, 0x000ea40000000800ULL,
0x0000000a05050220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001205127221ULL, 0x002fc20000010000ULL, 0x0000000000027805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991000007816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000000aff00723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe40000011617ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000144a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0300097589ULL, 0x0002a400000e0000ULL, 0x0000000803087810ULL, 0x000fe20007ffe0ffULL,
0x000144d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0800087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010034d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x000fe200078e0000ULL, 0x0000247000407802ULL, 0x000fc40000000f00ULL,
0x0001520000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018034d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x004fe200078e0000ULL,
0x000024c000407802ULL, 0x000fc40000000f00ULL, 0x000151b000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000817487812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff077819ULL, 0x000fc40000011617ULL,
0x0000000748487812ULL, 0x000fe400078ef817ULL, 0x0000000717507812ULL, 0x000fe200078ec0ffULL,
0x00000004184b7824ULL, 0x000fe200078e0207ULL, 0x00000010484a7812ULL, 0x040fe200078efcffULL,
0x0000001048037824ULL, 0x002fe200078e00ffULL, 0x0000000850507812ULL, 0x000fe200078ef817ULL,
0x0000000148007824ULL, 0x008fc800078e024bULL, 0x0000000107517824ULL, 0x000fe200078e0250ULL,
0xfffffff003007812ULL, 0x000fc800078ee200ULL, 0x0000c00000067811ULL, 0x000fe400078e20ffULL,
0x0000000218007811ULL, 0x000fc600078e10ffULL, 0x00000000061c783bULL, 0x000e640000004200ULL,
0x0000000107497824ULL, 0x000fc800078e0200ULL, 0x0000000148027824ULL, 0x000fca00078e0249ULL,
0xfffffff003027812ULL, 0x000fc800078ee202ULL, 0x0000c00002057811ULL, 0x000fca00078e20ffULL,
0x000000000544783bULL, 0x004ea20000004200ULL, 0x00000018ff037819ULL, 0x002fe2000001141dULL,
0x000001001d197824ULL, 0x040fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fe4000001141cULL,
0x0000000300627306ULL, 0x0003e20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fe4000001141eULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x000088801d047816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001141fULL,
0x00000002005e7306ULL, 0x0007e20000200c00ULL, 0x000001001c037824ULL, 0x002fc400078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc6000001141dULL, 0x00000018ff037819ULL, 0x000fe40000011403ULL,
0x0000001900637306ULL, 0x0003e20000200c00ULL, 0x000088801c027816ULL, 0x048fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x004fe40000011445ULL,
0x00000018ff4c7819ULL, 0x000fe40000011444ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x00000002005c7306ULL, 0x0005e20000200c00ULL, 0x000001001f197824ULL, 0x002fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc40000011446ULL, 0x00000018ff537819ULL, 0x000fe40000011447ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000003005f7306ULL, 0x0003e20000200c00ULL,
0x000088801e027816ULL, 0x004fce00000000ffULL, 0x0000000400607306ULL, 0x0005e20000200c00ULL,
0x000001001e037824ULL, 0x042fe400078e00ffULL, 0x000100001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff037819ULL, 0x000fe40000011403ULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000001900697306ULL, 0x0003e20000200c00ULL, 0x000088801f047816ULL, 0x044fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0000001e00667306ULL, 0x0005e20000200c00ULL, 0x000000014b197824ULL, 0x002fce00078e024aULL,
0x0000000400687306ULL, 0x0003e20000200c00ULL, 0x000000104a1e7824ULL, 0x004fca00078e00ffULL,
0xfffffff01e197812ULL, 0x000fe400078ee219ULL, 0x0000001d00657306ULL, 0x0005e20000200c00ULL,
0x0000010045047824ULL, 0x002fce00078e00ffULL, 0x0000000300677306ULL, 0x0003e20000200c00ULL,
0x00000018ff1d7819ULL, 0x004fe40000011404ULL, 0x0000c00019047811ULL, 0x000fca00078e20ffULL,
0x000000000440783bULL, 0x000ea20000004200ULL, 0x0000010044037824ULL, 0x002fe200078e00ffULL,
0x0000000200647306ULL, 0x0002e80000200c00ULL, 0x00000018ff037819ULL, 0x000fc80000011403ULL,
0x00000003006d7306ULL, 0x0009e20000200c00ULL, 0x0000888044027816ULL, 0x042fe200000000ffULL,
0x0001000044447824ULL, 0x000fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x00000002006a7306ULL, 0x0003e20000200c00ULL, 0x000000104a037824ULL, 0x010fe200078e00ffULL,
0x0000541064647816ULL, 0x008fcc0000000067ULL, 0x0000001c00617306ULL, 0x0007220000200c00ULL,
0x000000004a027210ULL, 0x002fe40007ffe007ULL, 0x0000888046007816ULL, 0x040fe400000000ffULL,
0xfffffff0034a7812ULL, 0x000fe200078ee202ULL, 0x0000010046027824ULL, 0x040fe400078e00ffULL,
0x00000044006f7306ULL, 0x0003e20000200c00ULL, 0x00008880451c7816ULL, 0x048fe200000000ffULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fe20000011402ULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000c0004a037811ULL, 0x000fe200078e20ffULL,
0x00000100417c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000000200737306ULL, 0x0005e20000200c00ULL, 0x0000888047447816ULL, 0x002fc400000000ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff5a7819ULL, 0x000fe40000011440ULL,
0x00000018ff5b7819ULL, 0x000fe20000011441ULL, 0x00000045006e7306ULL, 0x0003e20000200c00ULL,
0x0000000850027824ULL, 0x004fe200078e00ffULL, 0x00008880417a7816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0xfffffff802027812ULL, 0x000fc400078ee251ULL, 0x0000004400727306ULL, 0x0005e20000200c00ULL,
0x0000010047457824ULL, 0x042fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x00005410615e7816ULL, 0x010fe4000000005eULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000004600757306ULL, 0x000fe20000200c00ULL, 0x0000a00002447811ULL, 0x004fc400078e20ffULL,
0x00000018ff587819ULL, 0x000fe40000011442ULL, 0x00000018ff597819ULL, 0x000fe40000011443ULL,
0x0000888043807816ULL, 0x000fe200000000ffULL, 0x0000004500777306ULL, 0x0003e20000200c00ULL,
0x000054106a6a7816ULL, 0x000fce000000006dULL, 0x0000004700747306ULL, 0x0005e20000200c00ULL,
0x0000010040457824ULL, 0x002fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011445ULL,
0x0000001f006b7306ULL, 0x000fe20000200c00ULL, 0x000000004444783bULL, 0x004e6e0000000200ULL,
0x0000001c006c7306ULL, 0x000ff00000200c00ULL, 0x0000001d00717306ULL, 0x0005f00000200c00ULL,
0x0000000000707306ULL, 0x0007e20000200c00ULL, 0x00000000031c783bULL, 0x004eae0000004200ULL,
0x0000007600797306ULL, 0x000fe20000200c00ULL, 0x0000888040007816ULL, 0x048fe200000000ffULL,
0x0001000040407824ULL, 0x000fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000004100767306ULL, 0x0007e20000200c00ULL, 0x000000094444a232ULL, 0x082fe40000000000ULL,
0x000000094646a232ULL, 0x000fe40000000000ULL, 0x000000084545a232ULL, 0x080fe40000000000ULL,
0x000000084747a232ULL, 0x000fe20000000000ULL, 0x00000040007b7306ULL, 0x0003e20000200c00ULL,
0x0000541060417816ULL, 0x008fce0000000063ULL, 0x0000000000787306ULL, 0x0007220000200c00ULL,
0x0000010042407824ULL, 0x002fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000007c007d7306ULL, 0x0003e20000200c00ULL, 0x0000888042007816ULL, 0x048fe200000000ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x004fe4000001141cULL,
0x000088801d607816ULL, 0x000fe400000000ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x00000040007f7306ULL, 0x0005e20000200c00ULL, 0x00000100437c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe2000001141dULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc4000001141eULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000000007e7306ULL, 0x0003e20000200c00ULL, 0x000054105c407816ULL, 0x004fe4000000005fULL,
0x00005410655f7816ULL, 0x000fe20000000062ULL, 0x000100001d627824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000541068657816ULL, 0x000fe20000000069ULL,
0x00000040443c723cULL, 0x000be2000000183cULL, 0x0000000251007810ULL, 0x002fe20007ffe0ffULL,
0x0000004200817306ULL, 0x000fe20000200c00ULL, 0x00000018ff627819ULL, 0x000fc40000011462ULL,
0x00000018ff557819ULL, 0x000fe4000001141fULL, 0x0000000850417824ULL, 0x020fe200078e00ffULL,
0x000088801c407816ULL, 0x000fe200000000ffULL, 0x0000005e4434723cULL, 0x040b620000001834ULL,
0x00000043005c7306ULL, 0x0003e20000200c00ULL, 0x0000541078787816ULL, 0x010fe40000000079ULL,
0xfffffff841007812ULL, 0x000fe200078ee200ULL, 0x000001001c417824ULL, 0x000fe400078e00ffULL,
0x000000ffff5e7224ULL, 0x020fe200078e0040ULL, 0x0000a00000407811ULL, 0x000fe200078e20ffULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fe20000011441ULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000064442c723cULL, 0x000f64000000182cULL,
0x000000004040783bULL, 0x002e640000000200ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000004d004d7306ULL, 0x000ef00000200c00ULL, 0x0000004f004f7306ULL, 0x000f220000200c00ULL,
0x000054106f4c7816ULL, 0x004fce000000004cULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000054106e4d7816ULL, 0x008fce000000004dULL, 0x0000005200527306ULL, 0x000ee20000200c00ULL,
0x0000541066667816ULL, 0x010fe2000000004fULL, 0x000001001d4f7824ULL, 0x000fe200078e00ffULL,
0x0000004c4424723cULL, 0x000bea0000001824ULL, 0x0000005300537306ULL, 0x000f220000200c00ULL,
0x000054106b677816ULL, 0x004fe2000000004eULL, 0x000000ffff4e7224ULL, 0x000fe200078e0060ULL,
0x000054106c6b7816ULL, 0x000fc40000000071ULL, 0x00005410704c7816ULL, 0x020fe20000000073ULL,
0x000000094040a232ULL, 0x082fe20000000000ULL, 0x00005410724d7816ULL, 0x000fe20000000077ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x0000541075527816ULL, 0x008fe20000000052ULL,
0x000000664420723cULL, 0x040fe20000001820ULL, 0x00000018ff607819ULL, 0x000fe2000001144fULL,
0x000000094242a232ULL, 0x000fe40000000000ULL, 0x000000084141a232ULL, 0x080fe40000000000ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x0000541074537816ULL, 0x010fe20000000053ULL,
0x0000006a4428723cULL, 0x000f620000001828ULL, 0x000000084343a232ULL, 0x000fca0000000000ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000007c00837306ULL, 0x000ef00000200c00ULL,
0x0000001c001d7306ULL, 0x0009f00000200c00ULL, 0x0000004e00617306ULL, 0x0003e20000200c00ULL,
0x000001001e1c7824ULL, 0x010fca00078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000004c444c723cULL, 0x042b6e0000001830ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x000000524444723cULL, 0x000b640000001838ULL,
0x000088801e307816ULL, 0x060fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x000088801f317816ULL, 0x000fc600000000ffULL, 0x0000006000607306ULL, 0x000f220000200c00ULL,
0x000054107b387816ULL, 0x000fe4000000005aULL, 0x0000541076397816ULL, 0x004fe4000000005bULL,
0x00000018ff1e7819ULL, 0x000fc6000001141eULL, 0x0000003000527306ULL, 0x0005e40000200c00ULL,
0x000000384038723cULL, 0x000b6c0000001834ULL, 0x0000001c00537306ULL, 0x0003e20000200c00ULL,
0x000001001f307824ULL, 0x004fe200078e00ffULL, 0x000054107e347816ULL, 0x020fc4000000007fULL,
0x0000541080357816ULL, 0x008fe40000000083ULL, 0x00000018ff5a7819ULL, 0x000fe40000011430ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x000100001f1c7824ULL, 0x002fe400078e00ffULL,
0x000000344034723cULL, 0x000b66000000182cULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000005900597306ULL, 0x000fe40000200c00ULL, 0x000054105e2c7816ULL, 0x020fe4000000005fULL,
0x00005410612d7816ULL, 0x010fc80000000060ULL, 0x0000005600567306ULL, 0x000e620000200c00ULL,
0x0000541081307816ULL, 0x004fe40000000058ULL, 0x0000002c402c723cULL, 0x000b6a0000001828ULL,
0x0000005700577306ULL, 0x000ff00000200c00ULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x000054101d287816ULL, 0x022fce0000000056ULL, 0x0000005400547306ULL, 0x000ff00000200c00ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x0000541062297816ULL, 0x004fce0000000057ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x000000284028723cULL, 0x000f6e0000001824ULL,
0x0000003100637306ULL, 0x0005f00000200c00ULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x000054105c317816ULL, 0x004fc40000000059ULL, 0x000054107a797816ULL, 0x002fca000000007dULL,
0x0000001e001f7306ULL, 0x000e620000200c00ULL, 0x000000304030723cULL, 0x040b6e0000001820ULL,
0x0000001c001c7306ULL, 0x000ea20000200c00ULL, 0x0000541052207816ULL, 0x020fe20000000053ULL,
0x00000078403c723cULL, 0x000b62000000183cULL, 0x0000541063217816ULL, 0x008fc4000000005aULL,
0x000054101f247816ULL, 0x002fca0000000054ULL, 0x000000204020723cULL, 0x000b62000000184cULL,
0x000054101c257816ULL, 0x004fce0000000055ULL, 0x000000244024723cULL, 0x000b620000001844ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff407f8cULL, 0x020e62000c80043fULL,
0x000000ffff427224ULL, 0x000fce00078e00ffULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fe40007804841ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c437210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000431e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000142427810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020101e7810ULL, 0x000fca0007ffe0ffULL,
0x0000620013417a24ULL, 0x000fe200078e021eULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x0000000114407824ULL, 0x000fe200078e0207ULL, 0x0000001e151c7217ULL, 0x000fe20007800000ULL,
0x00000100ff457424ULL, 0x000fe200078e00ffULL, 0x00000004074f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001401d7824ULL, 0x040fe200078e0217ULL, 0x00000002074d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001040467824ULL, 0x000fe200078e00ffULL, 0x000000f00f477812ULL, 0x000fe200078ec0ffULL,
0x000000011c1f7824ULL, 0x000fe400078e0a1eULL, 0x0000000114447824ULL, 0x000fe200078e024fULL,
0xfffffff046467812ULL, 0x000fe200078ee21dULL, 0x00000001401c7824ULL, 0x000fe200078e0241ULL,
0x0000001f141f7217ULL, 0x000fe20007800000ULL, 0x0000000144427824ULL, 0x000fc400078e0217ULL,
0x0000001044537824ULL, 0x000fe400078e00ffULL, 0x00000001141e7824ULL, 0x000fe400078e024dULL,
0x00005e001c1c7625ULL, 0x000fe200078e0045ULL, 0xfffffff0534e7812ULL, 0x000fe400078ee242ULL,
0x0000000607537810ULL, 0x000fe20007ffe0ffULL, 0x000000011e407824ULL, 0x000fe200078e0217ULL,
0x000000471c427210ULL, 0x000fe20007f1e0ffULL, 0x000000101e437824ULL, 0x000fc400078e00ffULL,
0x000000011e1c7824ULL, 0x100fe400078e0241ULL, 0x00000001441e7824ULL, 0x000fe200078e0241ULL,
0xfffffff0434c7812ULL, 0x000fe200078ee240ULL, 0x000000ffff437224ULL, 0x000fe400000e061dULL,
0x00005e001c1c7625ULL, 0x000fc800078e0045ULL, 0x0000000114527824ULL, 0x000fe200078e0253ULL,
0x000000471c1c7210ULL, 0x000fe20007fbe0ffULL, 0x000000011f447824ULL, 0x000fe400078e0a14ULL,
0x00005e001e1e7625ULL, 0x000fc600078e0045ULL, 0x000000444d00720cULL, 0x080fe20003f66070ULL,
0x0000000152407824ULL, 0x000fe200078e0241ULL, 0x000000471e1e7210ULL, 0x000fe20007fde0ffULL,
0x00000001524d7824ULL, 0x000fe200078e0217ULL, 0x000000440700720cULL, 0x080fe20003f86070ULL,
0x00005e0040407625ULL, 0x000fe200078e0045ULL, 0x000000444f00720cULL, 0x080fe40003f06070ULL,
0x0000c00046457811ULL, 0x000fe200078e20ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x000000445300720cULL, 0x000fe20003fa6070ULL, 0x0000001052527824ULL, 0x000fc400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fe200030e061fULL, 0x0000004740407210ULL, 0x000fe40007fde0ffULL,
0xfffffff052447812ULL, 0x000fe200078ee24dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042457faeULL, 0x0003e2000e101c46ULL, 0x0000c0004c477811ULL, 0x000fe200078e20ffULL,
0x000000ffff417224ULL, 0x000fe200030e0641ULL, 0x0000c0004e4d7811ULL, 0x000fe400078e20ffULL,
0x0000c000444f7811ULL, 0x000fe200078e20ffULL, 0x000000001c477faeULL, 0x0003e8000d901c46ULL,
0x000000001e4d7faeULL, 0x0003e8000c101c46ULL, 0x00000000404f7faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000114407824ULL, 0x000fe200078e0207ULL,
0x000000f00f4d7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff477424ULL, 0x000fc400078e00ffULL,
0x0000000140427824ULL, 0x040fe200078e0217ULL, 0x00000002401c7810ULL, 0x040fe20007ffe0ffULL,
0x0000001040437824ULL, 0x040fe200078e00ffULL, 0x00000004401e7810ULL, 0x000fc60007ffe0ffULL,
0x000000011c1d7824ULL, 0x000fe200078e0217ULL, 0xfffffff0434e7812ULL, 0x000fe200078ee242ULL,
0x0000000140427824ULL, 0x040fe200078e0241ULL, 0x0000000640407810ULL, 0x000fe20007ffe0ffULL,
0x000000101c447824ULL, 0x000fe200078e00ffULL, 0x0000c0004e4f7811ULL, 0x000fe200078e20ffULL,
0x000000011e1f7824ULL, 0x040fe400078e0217ULL, 0x000000101e467824ULL, 0x000fe200078e00ffULL,
0xfffffff044447812ULL, 0x000fe200078ee21dULL, 0x00005e0042427625ULL, 0x000fc600078e0047ULL,
0xfffffff046467812ULL, 0x000fe200078ee21fULL, 0x00000001411c7824ULL, 0x040fe200078e021cULL,
0x0000004d42427210ULL, 0x000fe20007f7e0ffULL, 0x00000001411e7824ULL, 0x040fe400078e021eULL,
0x0000000141417824ULL, 0x000fe400078e0240ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0047ULL,
0x0000000140457824ULL, 0x000fe200078e0217ULL, 0x0000004d1c1c7210ULL, 0x000fe20007f1e0ffULL,
0x00000010404c7824ULL, 0x000fe400078e00ffULL, 0x00005e001e1e7625ULL, 0x000fc600078e0047ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee245ULL, 0x00005e0041407625ULL, 0x000fe200078e0047ULL,
0x0000c00044457811ULL, 0x000fe400078e20ffULL, 0x0000c00046477811ULL, 0x000fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fe200018e0643ULL, 0x0000004d1e1e7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000004d40407210ULL, 0x000fe40007f9e0ffULL,
0x0000c0004c4d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000424f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff417224ULL, 0x000fc600020e0641ULL, 0x000000001c457faeULL, 0x0003e8000b901c46ULL,
0x000000001e477faeULL, 0x0003e8000b901c46ULL, 0x00000000404d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff1e7f8cULL, 0x000e64000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x0106b400ff417984ULL, 0x000ea40000000800ULL, 0x8000000041ff7812ULL, 0x004fc4000780481bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x000000401c437210ULL, 0x000fca0007f1e1ffULL,
0x0000000141417824ULL, 0x000fe200000e0e1dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x002fc80000011441ULL,
0x000000431e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff417224ULL, 0x000fca00000e0641ULL,
0x000000021e1e7819ULL, 0x000fc80000001241ULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff417984ULL, 0x000ea40000000800ULL,
0x8000000041ff7812ULL, 0x004fe4000780481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fe400000000ffULL, 0x00000002ff1b7819ULL, 0x000fe40000011617ULL,
0x00005410081a7816ULL, 0x000fe20000000008ULL, 0x000128227f007947ULL, 0x000fea000b800000ULL,
0x00001f1b1a097589ULL, 0x0004e400000e0000ULL, 0x000000081b4d7810ULL, 0x002fe20007ffe0ffULL,
0x000128527f007947ULL, 0x000fea000b800000ULL, 0x00001f4d1a087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101b4d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x000fe200078e001aULL, 0x000041b000407802ULL, 0x000fc40000000f00ULL,
0x000134c000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181b4d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x004fe200078e001aULL,
0x0000420000407802ULL, 0x000fc40000000f00ULL, 0x0001347000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000e00019197811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0004a1a7811ULL, 0x006fe200078e20ffULL,
0x00000001484b7824ULL, 0x000fc400078e024bULL, 0x000000001944783bULL, 0x000e620000004200ULL,
0x00000010481e7824ULL, 0x040fe400078e00ffULL, 0x0000000148497824ULL, 0x000fe200078e0249ULL,
0x000000001a40783bULL, 0x000ea20000004200ULL, 0x00000100441b7824ULL, 0x002fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011446ULL, 0x00000100451c7824ULL, 0x000fe200078e00ffULL,
0x00008880466a7816ULL, 0x000fe200000000ffULL, 0x00000100401d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff1b7819ULL, 0x000fc4000001141bULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00000018ff637819ULL, 0x000fe2000001141dULL,
0x00000100411d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011444ULL,
0x0000888044717816ULL, 0x040fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe2000001141dULL, 0x0000001b00727306ULL, 0x0003e20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fc40000011445ULL, 0x0000888045737816ULL, 0x040fe200000000ffULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000018ff627819ULL, 0x000fe20000011447ULL, 0x0000001c00747306ULL, 0x0005e20000200c00ULL,
0x00000100461b7824ULL, 0x042fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000888047697816ULL, 0x000fe400000000ffULL,
0x00000018ff6b7819ULL, 0x000fc4000001141bULL, 0xfffffff01e1b7812ULL, 0x000fe200078ee24bULL,
0x00000100471c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x00000044006f7306ULL, 0x0003e20000200c00ULL, 0x0000e0001b1b7811ULL, 0x000fe200078e20ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001141cULL,
0x00000010481c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011440ULL,
0x000000001b4c783bULL, 0x000ea20000004200ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000004600687306ULL, 0x000fe20000200c00ULL, 0xfffffff01c1c7812ULL, 0x000fc400078ee249ULL,
0x00000018ff607819ULL, 0x000fe40000011441ULL, 0x0000e0001c1c7811ULL, 0x000fe400078e20ffULL,
0x0000888040667816ULL, 0x040fe200000000ffULL, 0x0000004500707306ULL, 0x0009e20000200c00ULL,
0x0000888041647816ULL, 0x040fe200000000ffULL, 0x000000001c48783bULL, 0x000ee20000004200ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011442ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fc40000011443ULL,
0x0000004700677306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff417819ULL, 0x000fca0000011441ULL, 0x0000006c006c7306ULL, 0x000e700000200c00ULL,
0x0000006d006d7306ULL, 0x000ee20000200c00ULL, 0x00000018ff1d7819ULL, 0x004fe4000001144cULL,
0x00000018ff1e7819ULL, 0x000fca000001144dULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x00000018ff447819ULL, 0x002fe4000001144eULL, 0x00000018ff457819ULL, 0x010fe4000001144fULL,
0x000088804f757816ULL, 0x000fe400000000ffULL, 0x000054106f6c7816ULL, 0x000fe2000000006cULL,
0x0000001d00547306ULL, 0x0003e20000200c00ULL, 0x00000018ff467819ULL, 0x008fe20000011448ULL,
0x0000010048797824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc4000001144aULL,
0x00000018ff567819ULL, 0x000fe4000001144bULL, 0x00000018ff477819ULL, 0x000fe20000011449ULL,
0x0000001e00577306ULL, 0x0007e20000200c00ULL, 0x000088804c1d7816ULL, 0x002fe400000000ffULL,
0x00008880497d7816ULL, 0x000fe400000000ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x00005410706d7816ULL, 0x000fe2000000006dULL, 0x0000001d00527306ULL, 0x0003e20000200c00ULL,
0x000001004c1e7824ULL, 0x048fe200078e00ffULL, 0x0000541071727816ULL, 0x004fe20000000072ULL,
0x000100004c4c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000046007b7306ULL, 0x0005e20000200c00ULL, 0x000100004d1d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fcc000001144cULL, 0x00000044005a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff467819ULL, 0x004fe2000001141dULL, 0x000001004e1d7824ULL, 0x000fcc00078e00ffULL,
0x0000004500777306ULL, 0x0005e20000200c00ULL, 0x000088804d447816ULL, 0x002fce00000000ffULL,
0x0000005500837306ULL, 0x000fe20000200c00ULL, 0x000001004d457824ULL, 0x004fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000005600847306ULL, 0x000ff00000200c00ULL,
0x0000004c00557306ULL, 0x0003f00000200c00ULL, 0x0000004400567306ULL, 0x0005e20000200c00ULL,
0x00000018ff4c7819ULL, 0x002fc4000001141dULL, 0x00000004511d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000651517810ULL, 0x000fc60007ffe0ffULL, 0x00000047007f7306ULL, 0x0003e20000200c00ULL,
0x0000000850447824ULL, 0x044fe400078e00ffULL, 0x0000000850507824ULL, 0x000fc600078e00ffULL,
0xfffffff8441d7812ULL, 0x000fe400078ee21dULL, 0x00000045004d7306ULL, 0x0005e20000200c00ULL,
0x000088804e477816ULL, 0x042fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x0000a0001d447811ULL, 0x000fc800078e20ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000001e00537306ULL, 0x000e620000200c00ULL, 0x000001004f457824ULL, 0x044fe400078e00ffULL,
0x000100004f4f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011445ULL,
0x00000046001e7306ULL, 0x000ea20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fce000001144fULL,
0x0000004700587306ULL, 0x0007e20000200c00ULL, 0x0000541052527816ULL, 0x002fe40000000053ULL,
0x0000541056537816ULL, 0x000fca000000004dULL, 0x0000004c00597306ULL, 0x0003220000200c00ULL,
0x000000004444783bULL, 0x008ee20000000200ULL, 0x000054101e4d7816ULL, 0x004fe40000000057ULL,
0xfffffff8501e7812ULL, 0x000fc800078ee251ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00008880484c7816ULL, 0x042fe200000000ffULL, 0x0001000048487824ULL, 0x000fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x0000541058507816ULL, 0x010fce0000000059ULL, 0x0000004e005b7306ULL, 0x0005300000200c00ULL,
0x0000004c007a7306ULL, 0x0007e20000200c00ULL, 0x00000100494e7824ULL, 0x004fe200078e00ffULL,
0x0000541075517816ULL, 0x002fe20000000076ULL, 0x0001000049497824ULL, 0x000fc600078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000048007c7306ULL, 0x000e620000200c00ULL,
0x000088804a4c7816ULL, 0x008fe200000000ffULL, 0x000000094444a232ULL, 0x080fe20000000000ULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x000000094646a232ULL, 0x000fe20000000000ULL,
0x000054105b5a7816ULL, 0x010fe2000000005aULL, 0x000000084545a232ULL, 0x080fe40000000000ULL,
0x0000004c00817306ULL, 0x0005e20000200c00ULL, 0x000000084747a232ULL, 0x000fce0000000000ULL,
0x0000004e007e7306ULL, 0x0007e20000200c00ULL, 0x00005410554c7816ULL, 0x004fe20000000054ULL,
0x00000052443c723cULL, 0x000fe2000000183cULL, 0x000054107c547816ULL, 0x002fca000000007bULL,
0x0000004f00787306ULL, 0x0002a20000200c00ULL, 0x000001004a4e7824ULL, 0x048fe200078e00ffULL,
0x000000504450723cULL, 0x000be20000001834ULL, 0x000100004a4a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe4000001144eULL, 0x0000004900807306ULL, 0x0007220000200c00ULL,
0x000100004b377824ULL, 0x020fe200078e00ffULL, 0x0000004c444c723cULL, 0x002b620000001838ULL,
0x00000018ff347819ULL, 0x000fc6000001144aULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000004800827306ULL, 0x000e620000200c00ULL, 0x000001004b387824ULL, 0x060fe200078e00ffULL,
0x0000a0001e397811ULL, 0x000fe400078e20ffULL, 0x000088804b497816ULL, 0x008fe400000000ffULL,
0x00000018ff357819ULL, 0x000fe40000011438ULL, 0x000000003938783bULL, 0x000ee20000000200ULL,
0x0000004900597306ULL, 0x000fe20000200c00ULL, 0x00005410785b7816ULL, 0x004fc40000000077ULL,
0x0000541080557816ULL, 0x010fe4000000007fULL, 0x0000541081587816ULL, 0x002fc60000000082ULL,
0x0000003500367306ULL, 0x000e620000200c00ULL, 0x0000005a4430723cULL, 0x040fee0000001830ULL,
0x0000007900797306ULL, 0x000ea20000200c00ULL, 0x000000544454723cULL, 0x000fee0000001828ULL,
0x0000007d007d7306ULL, 0x000f220000200c00ULL, 0x0000541059597816ULL, 0x002fce0000000036ULL,
0x0000003400347306ULL, 0x000e620000200c00ULL, 0x000000584458723cULL, 0x000be20000001820ULL,
0x000054107a487816ULL, 0x004fe20000000079ULL, 0x000000093838a232ULL, 0x008fca0000000000ULL,
0x0000003700357306ULL, 0x000ea20000200c00ULL, 0x0000888042207816ULL, 0x060fe200000000ffULL,
0x000000093a3aa232ULL, 0x000fe20000000000ULL, 0x000054107d497816ULL, 0x010fe2000000007eULL,
0x000000083939a232ULL, 0x080fe20000000000ULL, 0x0000010042217824ULL, 0x040fe200078e00ffULL,
0x000000083b3ba232ULL, 0x000fe20000000000ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x0000541034347816ULL, 0x002fe20000000083ULL, 0x0000002000757306ULL, 0x0003e20000200c00ULL,
0x000000484448723cULL, 0x000f62000000182cULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x0000888043227816ULL, 0x000fe400000000ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000541035357816ULL, 0x004fe20000000084ULL, 0x0000010043207824ULL, 0x042fe200078e00ffULL,
0x0000006200627306ULL, 0x000fea0000200c00ULL, 0x000000344444723cULL, 0x000b660000001824ULL,
0x0000005f005f7306ULL, 0x000fe80000200c00ULL, 0x00000018ff247819ULL, 0x020fe20000011420ULL,
0x0001000043207824ULL, 0x000fe200078e00ffULL, 0x0000006c3834723cULL, 0x000b64000000184cULL,
0x0000006000607306ULL, 0x000fea0000200c00ULL, 0x00000018ff4d7819ULL, 0x020fc40000011420ULL,
0x0000541068207816ULL, 0x000fe20000000061ULL, 0x0000007300737306ULL, 0x000e700000200c00ULL,
0x0000006a006a7306ULL, 0x000ff00000200c00ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x0000541073737816ULL, 0x002fce0000000074ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00000072383c723cULL, 0x000f6e000000183cULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x000054106a2c7816ULL, 0x004fce000000006bULL, 0x0000006600667306ULL, 0x000ff00000200c00ULL,
0x0000006300637306ULL, 0x000ea20000200c00ULL, 0x00005410692d7816ULL, 0x002fce000000006eULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000002c382c723cULL, 0x000f6e0000001850ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x0000541066287816ULL, 0x004fce0000000063ULL,
0x0000004000407306ULL, 0x000ff00000200c00ULL, 0x0000004100417306ULL, 0x000ea20000200c00ULL,
0x0000541064297816ULL, 0x002fce0000000065ULL, 0x0000002100767306ULL, 0x0002e20000200c00ULL,
0x000000283828723cULL, 0x000f6e0000001848ULL, 0x0000002200717306ULL, 0x0009e20000200c00ULL,
0x0000541067217816ULL, 0x002fe40000000062ULL, 0x0000541041257816ULL, 0x004fca0000000060ULL,
0x00000024004c7306ULL, 0x0002a20000200c00ULL, 0x000000203820723cULL, 0x010b6e0000001830ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000541040247816ULL, 0x002fe4000000005fULL,
0x0000541075307816ULL, 0x028fca0000000076ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000541071317816ULL, 0x004fe2000000004cULL, 0x000000243824723cULL, 0x040b6c0000001854ULL,
0x0000004200437306ULL, 0x000e640000200c00ULL, 0x000000303830723cULL, 0x000b6c0000001858ULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x0000541043407816ULL, 0x002fc4000000005cULL,
0x000054104d417816ULL, 0x004fce000000005eULL, 0x000000403838723cULL, 0x000b620000001844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff407f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000002010407810ULL, 0x002fe20007ffe0ffULL, 0x01068800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff447224ULL, 0x000fe400078e0041ULL, 0x000000154000720cULL, 0x000fe20003f06070ULL,
0x000000ffff487224ULL, 0x000fd800078e005dULL, 0x0000bd4000000947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x0106bc00ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004010427810ULL, 0x000fca0007ffe0ffULL,
0x0000620013457a24ULL, 0x000fe200078e0242ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000004074f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114447824ULL, 0x040fe200078e0207ULL,
0x0000004215407217ULL, 0x000fe40007800000ULL, 0x00000002074d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000114487824ULL, 0x000fe200078e024fULL, 0x0000000607517810ULL, 0x000fe20007ffe0ffULL,
0x0000000144437824ULL, 0x100fe200078e0217ULL, 0x000000f00f4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000148497824ULL, 0x000fc400078e0217ULL, 0x00000010484e7824ULL, 0x000fe400078e00ffULL,
0x00000010444a7824ULL, 0x000fe400078e00ffULL, 0x0000000140417824ULL, 0x000fe200078e0a42ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee249ULL, 0x0000000114467824ULL, 0x000fe200078e024dULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee243ULL, 0x00000100ff497424ULL, 0x000fe200078e00ffULL,
0x0000004114437217ULL, 0x000fe20007800000ULL, 0x0000000144407824ULL, 0x000fc400078e0245ULL,
0x0000000146477824ULL, 0x040fe400078e0217ULL, 0x00000010464c7824ULL, 0x000fe400078e00ffULL,
0x0000000114507824ULL, 0x000fe400078e0251ULL, 0x0000000146427824ULL, 0x000fe200078e0245ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee247ULL, 0x00005e0040407625ULL, 0x000fc800078e0049ULL,
0x0000000148447824ULL, 0x100fe200078e0245ULL, 0x0000004b40467210ULL, 0x000fe20007f1e0ffULL,
0x0000000143487824ULL, 0x000fe400078e0a14ULL, 0x0000000150457824ULL, 0x040fe400078e0245ULL,
0x0000000150477824ULL, 0x000fe200078e0217ULL, 0x000000480700720cULL, 0x080fe20003f66070ULL,
0x00005e0042427625ULL, 0x000fe200078e0049ULL, 0x000000484d00720cULL, 0x000fe40003f46070ULL,
0x0000e0004e4d7811ULL, 0x000fe200078e20ffULL, 0x0000001050507824ULL, 0x000fe200078e00ffULL,
0x0000004b42427210ULL, 0x000fc80007f9e0ffULL, 0xfffffff050507812ULL, 0x000fe200078ee247ULL,
0x000000ffff477224ULL, 0x000fe200000e0641ULL, 0x000000484f00720cULL, 0x000fe20003f06070ULL,
0x00005e0044407625ULL, 0x000fe200078e0049ULL, 0x0000e000504f7811ULL, 0x000fc600078e20ffULL,
0x00005e0045447625ULL, 0x000fe200078e0049ULL, 0x0000004b40407210ULL, 0x080fe40007fbe0ffULL,
0x0000e0004a497811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200020e0643ULL,
0x000000485100720cULL, 0x000fe20003f86070ULL, 0x000000ffff417224ULL, 0x000fe200028e0641ULL,
0x0000004b44447210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046497faeULL, 0x0003e2000d901c46ULL, 0x0000e0004c4b7811ULL, 0x000fc600078e20ffULL,
0x000000ffff457224ULL, 0x000fe400030e0645ULL, 0x00000000424b7faeULL, 0x0003e8000d101c46ULL,
0x00000000404d7faeULL, 0x0003e8000c101c46ULL, 0x00000000444f7faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000114407824ULL, 0x000fe200078e0207ULL,
0x000000f00f4b7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff497424ULL, 0x000fc400078e00ffULL,
0x0000000140417824ULL, 0x140fe200078e0217ULL, 0x0000000440447810ULL, 0x040fe20007ffe0ffULL,
0x0000001040487824ULL, 0x040fe200078e00ffULL, 0x0000000240427810ULL, 0x040fe40007ffe0ffULL,
0x00000006404e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000144467824ULL, 0x000fe200078e0217ULL,
0xfffffff048487812ULL, 0x000fe200078ee241ULL, 0x0000001044477824ULL, 0x000fe400078e00ffULL,
0x0000000142437824ULL, 0x000fe200078e0217ULL, 0x0000e000484f7811ULL, 0x000fe200078e20ffULL,
0x00000010424a7824ULL, 0x000fe200078e00ffULL, 0xfffffff0474c7812ULL, 0x000fe200078ee246ULL,
0x0000000140467824ULL, 0x000fc400078e0245ULL, 0x0000000142407824ULL, 0x000fe200078e0245ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee243ULL, 0x00005e0046467625ULL, 0x000fc800078e0049ULL,
0x0000000144427824ULL, 0x100fe200078e0245ULL, 0x0000004b46467210ULL, 0x000fe20007f5e0ffULL,
0x000000014e447824ULL, 0x000fe400078e0245ULL, 0x00005e0040407625ULL, 0x000fc800078e0049ULL,
0x00005e0042427625ULL, 0x000fe200078e0049ULL, 0x0000004b40407210ULL, 0x000fc60007f1e0ffULL,
0x000000014e4d7824ULL, 0x000fe400078e0217ULL, 0x00005e0044447625ULL, 0x000fe200078e0049ULL,
0x0000e0004a497811ULL, 0x000fc600078e20ffULL, 0x000000104e4e7824ULL, 0x000fe200078e00ffULL,
0x0000004b44447210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff477224ULL, 0x000fe200010e0647ULL,
0x0000004b42427210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff417224ULL, 0x000fe200000e0641ULL,
0xfffffff04e4d7812ULL, 0x000fe200078ee24dULL, 0x000000ffff457224ULL, 0x000fe200018e0645ULL,
0x0000e0004c4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200010e0643ULL,
0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000464f7faeULL, 0x0003e8000b901c46ULL, 0x0000000040497faeULL, 0x0003e8000b901c46ULL,
0x00000000424b7faeULL, 0x0003e8000b901c46ULL, 0x00000000444d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280014447f8cULL, 0x0004e4000c80043fULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x01062c0014437984ULL, 0x000f240000000800ULL, 0x8000000043ff7812ULL, 0x018fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240477210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004742427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01062c0014437984ULL, 0x000ee40000000800ULL,
0x8000000043ff7812ULL, 0x008fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010080000e427984ULL, 0x000ee80000000800ULL, 0x010280000e437984ULL, 0x0004620000000800ULL,
0x0000005d4200720bULL, 0x008fe20003f1d000ULL, 0x00010b927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000447806ULL, 0x004fc800000e0100ULL, 0x0000ffff44ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff457424ULL, 0x000fc400078e00ffULL,
0x000000ffff487224ULL, 0x000fd200078e005dULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000011800780cULL, 0x000fe40003f05270ULL, 0x0000005d4200720bULL, 0x000fe20003f54000ULL,
0x00010b527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000457806ULL, 0x000fc400010e0100ULL,
0x0000005d42418209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991045407816ULL, 0x000fc600000000ffULL, 0x010480410e008388ULL, 0x0005e20000000800ULL,
0x000000ff4000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000005d42407209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff45ff7812ULL, 0x000fc6000780c0ffULL, 0x0000005d40407221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b40407820ULL, 0x000fc80000410000ULL, 0x0000004000477308ULL, 0x000ea40000000800ULL,
0x0000004712127220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff4d7819ULL, 0x000fe20000011617ULL, 0x00010a927f007947ULL, 0x000fea000b800000ULL,
0x00001f4d47407589ULL, 0x0004e400000e0000ULL, 0x000000403c3c7220ULL, 0x088fe20000410000ULL,
0x000000403d3d7220ULL, 0x080fe20000410000ULL, 0x0000004034347220ULL, 0x080fe20000410000ULL,
0x0000004035357220ULL, 0x080fe20000410000ULL, 0x000000402c2c7220ULL, 0x080fe20000410000ULL,
0x000000402d2d7220ULL, 0x080fe20000410000ULL, 0x0000004020207220ULL, 0x080fe20000410000ULL,
0x0000004021217220ULL, 0x080fe20000410000ULL, 0x0000004028287220ULL, 0x080fe20000410000ULL,
0x0000004029297220ULL, 0x080fe20000410000ULL, 0x0000004024247220ULL, 0x080fe20000410000ULL,
0x0000004025257220ULL, 0x080fe20000410000ULL, 0x0000004030307220ULL, 0x080fe20000410000ULL,
0x0000004031317220ULL, 0x080fe20000410000ULL, 0x0000004038387220ULL, 0x080fe20000410000ULL,
0x0000004039397220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0045ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008174d7811ULL, 0x006fe200078ff0ffULL, 0x000109827f007947ULL, 0x000fea000b800000ULL,
0x00001f4d47407589ULL, 0x0002a400000e0000ULL, 0x000000403e3e7220ULL, 0x084fe20000410000ULL,
0x000000403f3f7220ULL, 0x080fe20000410000ULL, 0x0000004036367220ULL, 0x080fe20000410000ULL,
0x0000004037377220ULL, 0x080fe20000410000ULL, 0x000000402e2e7220ULL, 0x080fe20000410000ULL,
0x000000402f2f7220ULL, 0x080fe20000410000ULL, 0x0000004022227220ULL, 0x080fe20000410000ULL,
0x0000004023237220ULL, 0x080fe20000410000ULL, 0x000000402a2a7220ULL, 0x080fe20000410000ULL,
0x000000402b2b7220ULL, 0x080fe20000410000ULL, 0x0000004026267220ULL, 0x080fe20000410000ULL,
0x0000004027277220ULL, 0x080fe20000410000ULL, 0x0000004032327220ULL, 0x080fe20000410000ULL,
0x0000004033337220ULL, 0x080fe20000410000ULL, 0x000000403a3a7220ULL, 0x080fe20000410000ULL,
0x000000403b3b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff45ff7812ULL, 0x000fe20007800844ULL, 0x00000001ff457424ULL, 0x000fe200078e00ffULL,
0x0000005d42487209ULL, 0x000fd60007810000ULL, 0x8000004842420221ULL, 0x000fe20000010000ULL,
0x00007610ff450816ULL, 0x000fc60000000045ULL, 0x3fb8aa3b42420820ULL, 0x000fc80000410000ULL,
0x00000042000a0308ULL, 0x000ea40000000800ULL, 0x0000000a43430220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001243127221ULL, 0x002fc20000010000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe4000780481fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240477210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004742427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe4000780481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910451f7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1f00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fe400000000ffULL,
0x00000002ff427819ULL, 0x000fe40000011617ULL, 0x00005410081f7816ULL, 0x000fe20000000008ULL,
0x000105627f007947ULL, 0x000fea000b800000ULL, 0x00001f421f097589ULL, 0x0002a400000e0000ULL,
0x00000008424d7810ULL, 0x002fe20007ffe0ffULL, 0x000105927f007947ULL, 0x000fea000b800000ULL,
0x00001f4d1f087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010424d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x000fe200078e001fULL,
0x0000666000407802ULL, 0x000fc40000000f00ULL, 0x0001101000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018424d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x004fe200078e001fULL, 0x000066b000407802ULL, 0x000fc40000000f00ULL,
0x00010fc000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000650783bULL, 0x000f280000004200ULL,
0x000000000544783bULL, 0x004ea80000004200ULL, 0x00000000044c783bULL, 0x002e680000004200ULL,
0x000000000340783bULL, 0x000ee20000004200ULL, 0x00000018ff1f7819ULL, 0x010fe20000011450ULL,
0x0000010050577824ULL, 0x040fe200078e00ffULL, 0x0000888050567816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011452ULL,
0x00000100446c7824ULL, 0x004fe200078e00ffULL, 0x00008880525f7816ULL, 0x000fe200000000ffULL,
0x0000010053697824ULL, 0x040fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x00010000536a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011444ULL,
0x0000010046727824ULL, 0x000fe200078e00ffULL, 0x00000050005b7306ULL, 0x0005e20000200c00ULL,
0x00008880446b7816ULL, 0x040fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011453ULL, 0x00000100515d7824ULL, 0x000fe200078e00ffULL,
0x0000888053687816ULL, 0x000fe200000000ffULL, 0x000001004d7b7824ULL, 0x002fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011445ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000010052507824ULL, 0x044fe200078e00ffULL, 0x00008880456e7816ULL, 0x000fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x000001004f7f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fc40000011446ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x00000044006d7306ULL, 0x0003e20000200c00ULL,
0x0000888046717816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011447ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000005200537306ULL, 0x0005e20000200c00ULL,
0x0000010047447824ULL, 0x002fe200078e00ffULL, 0x00008880515c7816ULL, 0x000fc400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000018ff747819ULL, 0x000fe40000011444ULL,
0x0000a80002447811ULL, 0x000fe200078e20ffULL, 0x0000010045527824ULL, 0x044fe200078e00ffULL,
0x0000004600737306ULL, 0x000fe20000200c00ULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff527819ULL, 0x000fc40000011452ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000052006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff647819ULL, 0x000fe4000001144cULL,
0x000088804c777816ULL, 0x040fe400000000ffULL, 0x00000018ff497819ULL, 0x000fe20000011451ULL,
0x0000004500707306ULL, 0x0005e20000200c00ULL, 0x0000888047527816ULL, 0x042fe200000000ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe2000001144dULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x000088804d7a7816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011447ULL,
0x0000005200757306ULL, 0x0003e20000200c00ULL, 0x000001004c457824ULL, 0x044fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x00000018ff627819ULL, 0x000fe4000001144eULL,
0x0000005700577306ULL, 0x000ea20000200c00ULL, 0x00000018ff527819ULL, 0x002fe40000011445ULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff637819ULL, 0x000fc4000001144fULL, 0x000088804f807816ULL, 0x040fe200000000ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe4000001147fULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000005d005d7306ULL, 0x000f220000200c00ULL,
0x0000541056567816ULL, 0x004fe40000000057ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff7b7819ULL, 0x000fc4000001147bULL, 0x00000018ff607819ULL, 0x008fe20000011440ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff617819ULL, 0x000fce0000011441ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000054105c577816ULL, 0x010fce000000005dULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000094444a232ULL, 0x082fe40000000000ULL,
0x000000094646a232ULL, 0x000fe40000000000ULL, 0x000000084545a232ULL, 0x000fc60000000000ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000000084747a232ULL, 0x000fce0000000000ULL,
0x0000004c00797306ULL, 0x0003e20000200c00ULL, 0x00000056443c723cULL, 0x000b6e000000183cULL,
0x0000001f005a7306ULL, 0x0004e20000200c00ULL, 0x000001004e4c7824ULL, 0x002fe200078e00ffULL,
0x0000a80000567811ULL, 0x020fc400078e20ffULL, 0x0000888040577816ULL, 0x000fe400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000005200787306ULL, 0x0003e20000200c00ULL,
0x00000018ff1f7819ULL, 0x004fce0000011442ULL, 0x00000049005e7306ULL, 0x0005e20000200c00ULL,
0x000088804e527816ULL, 0x042fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x000054105b5a7816ULL, 0x008fc8000000005aULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x00000018ff497819ULL, 0x004fce0000011443ULL,
0x0000004d007c7306ULL, 0x0005f00000200c00ULL, 0x0000004c007e7306ULL, 0x0007e20000200c00ULL,
0x00005410684d7816ULL, 0x004fe40000000069ULL, 0x00005410515b7816ULL, 0x002fca000000005eULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000054105f4c7816ULL, 0x008fe20000000050ULL,
0x0000010040507824ULL, 0x040fe200078e00ffULL, 0x0000005a4434723cULL, 0x000be20000001834ULL,
0x0001000040407824ULL, 0x000fc800078e00ffULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff5a7819ULL, 0x020fe40000011450ULL,
0x00008880415b7816ULL, 0x000fc600000000ffULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x0000541053507816ULL, 0x002fce0000000054ULL, 0x00000052007d7306ULL, 0x0003f00000200c00ULL,
0x0000004e007f7306ULL, 0x0007e20000200c00ULL, 0x00000018ff527819ULL, 0x002fe4000001144fULL,
0x000054106a517816ULL, 0x004fca0000000055ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000004c444c723cULL, 0x008b64000000182cULL, 0x00000000562c783bULL, 0x020e6a0000000200ULL,
0x0000006c006c7306ULL, 0x000eb00000200c00ULL, 0x0000006e006e7306ULL, 0x000ef00000200c00ULL,
0x0000005800587306ULL, 0x000f220000200c00ULL, 0x000054106b547816ULL, 0x004fce000000006cULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x000054106e557816ULL, 0x008fce000000006fULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000054106d587816ULL, 0x010fe20000000058ULL,
0x000000092c2ca232ULL, 0x082fe40000000000ULL, 0x000000092e2ea232ULL, 0x000fe40000000000ULL,
0x000000082d2da232ULL, 0x080fe40000000000ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541070597816ULL, 0x004fe20000000059ULL, 0x000000082f2fa232ULL, 0x000fcc0000000000ULL,
0x0000007400747306ULL, 0x000eb00000200c00ULL, 0x0000006600667306ULL, 0x000ee20000200c00ULL,
0x00005410715c7816ULL, 0x002fce0000000072ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00005410755d7816ULL, 0x004fce0000000074ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x0000541073667816ULL, 0x008fe20000000066ULL, 0x0000005c445c723cULL, 0x000bec0000001830ULL,
0x0000005200827306ULL, 0x0005e20000200c00ULL, 0x0000888043307816ULL, 0x020fce00000000ffULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x000000504450723cULL, 0x004be20000001820ULL,
0x0000541076677816ULL, 0x002fcc0000000067ULL, 0x0000010041217824ULL, 0x020fe200078e00ffULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x000000ffff207224ULL, 0x000fc600078e005bULL,
0x00000018ff217819ULL, 0x000fc80000011421ULL, 0x0000007b007b7306ULL, 0x000e700000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000eb00000200c00ULL,
0x0000002000697306ULL, 0x0007f00000200c00ULL, 0x00000021006a7306ULL, 0x0009e20000200c00ULL,
0x0001000041207824ULL, 0x008fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000005700837306ULL, 0x0007e20000200c00ULL, 0x0000010042217824ULL, 0x010fce00078e00ffULL,
0x0000005a00687306ULL, 0x0009e20000200c00ULL, 0x000000544454723cULL, 0x048bee0000001828ULL,
0x0000010043297824ULL, 0x060fe200078e00ffULL, 0x000000584458723cULL, 0x010b620000001824ULL,
0x00000018ff287819ULL, 0x000fe20000011421ULL, 0x00000020006c7306ULL, 0x0007e20000200c00ULL,
0x000054107a217816ULL, 0x002fe2000000007bULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fc40000011429ULL, 0x0000888042247816ULL, 0x060fe200000000ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x000000664444723cULL, 0x000b620000001838ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541077207816ULL, 0x008fe40000000078ULL,
0x0000541080297816ULL, 0x004fe40000000081ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x000000202c20723cULL, 0x000b6e000000183cULL, 0x0000002800677306ULL, 0x0205f00000200c00ULL,
0x0000004000417306ULL, 0x000fe20000200c00ULL, 0x000054107d287816ULL, 0x004fc4000000007eULL,
0x000054107c257816ULL, 0x002fca0000000065ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000000282c28723cULL, 0x000f6e000000184cULL, 0x0000006300637306ULL, 0x000ff00000200c00ULL,
0x0000006000607306ULL, 0x000e700000200c00ULL, 0x0000006100617306ULL, 0x000eb00000200c00ULL,
0x0000002400407306ULL, 0x0007220000200c00ULL, 0x0000541041387816ULL, 0x002fce0000000060ULL,
0x00000030003d7306ULL, 0x0003e20000200c00ULL, 0x0000541079247816ULL, 0x008fe40000000064ULL,
0x000054106c397816ULL, 0x004fca0000000061ULL, 0x00000031003e7306ULL, 0x0004e20000200c00ULL,
0x000000242c24723cULL, 0x000b620000001834ULL, 0x0000541083307816ULL, 0x002fe40000000068ULL,
0x00005410403c7816ULL, 0x010fc80000000067ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x000054107f347816ULL, 0x020fe20000000062ULL, 0x000000382c38723cULL, 0x000b620000001858ULL,
0x0000541082357816ULL, 0x000fe40000000063ULL, 0x0000541069317816ULL, 0x004fc6000000006aULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000054103d3d7816ULL, 0x008fe2000000003eULL,
0x000000342c34723cULL, 0x040b6c0000001850ULL, 0x0000004200427306ULL, 0x000e640000200c00ULL,
0x000000302c30723cULL, 0x040b6c0000001854ULL, 0x00000043004c7306ULL, 0x000ea40000200c00ULL,
0x0000003c2c3c723cULL, 0x000b62000000185cULL, 0x0000541042427816ULL, 0x002fc4000000001fULL,
0x000054104c437816ULL, 0x004fce0000000049ULL, 0x000000422c2c723cULL, 0x000b620000001844ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff447f8cULL, 0x020e62000c80043fULL,
0x000000ffff467224ULL, 0x000fce00078e00ffULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x0106bc00ff1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fe40007804845ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240427210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011443ULL, 0x000000421f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0643ULL, 0x000000021f1f7819ULL, 0x000fc80000001242ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000006010407810ULL, 0x000fca0007ffe0ffULL,
0x0000620013447a24ULL, 0x000fe200078e0240ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000040151f7217ULL, 0x000fe20007800000ULL, 0x0000000114417824ULL, 0x040fe200078e0207ULL,
0x0000000407517810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff457424ULL, 0x000fe200078e00ffULL,
0x00000002074f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0a40ULL,
0x000000f00f497812ULL, 0x000fe200078ec0ffULL, 0x0000000114477824ULL, 0x040fe400078e0251ULL,
0x0000000141407824ULL, 0x040fe200078e0244ULL, 0x0000001f141f7217ULL, 0x000fe20007800000ULL,
0x0000000141427824ULL, 0x000fc400078e0217ULL, 0x00000010414d7824ULL, 0x000fe400078e00ffULL,
0x0000000147467824ULL, 0x040fe400078e0217ULL, 0x0000001047537824ULL, 0x000fe200078e00ffULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL, 0x00005e0040407625ULL, 0x000fc600078e0045ULL,
0xfffffff053507812ULL, 0x000fe200078ee246ULL, 0x0000000114427824ULL, 0x000fe200078e024fULL,
0x0000004940467210ULL, 0x000fe20007f1e0ffULL, 0x000000011f4c7824ULL, 0x000fe200078e0a14ULL,
0x0000000607537810ULL, 0x000fe20007ffe0ffULL, 0x0000000142407824ULL, 0x140fe200078e0244ULL,
0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL, 0x0000000142437824ULL, 0x040fe200078e0217ULL,
0x0000004c0700720cULL, 0x080fe20003f86070ULL, 0x00000010424e7824ULL, 0x000fe200078e00ffULL,
0x0000004c4f00720cULL, 0x000fe20003f66070ULL, 0x0000000147427824ULL, 0x000fc400078e0244ULL,
0x000000ffff477224ULL, 0x000fe200000e0641ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee243ULL,
0x00005e0040407625ULL, 0x000fe200078e0045ULL, 0x0000004c5100720cULL, 0x000fc60003f06070ULL,
0x00000001141f7824ULL, 0x000fe200078e0253ULL, 0x0000004940407210ULL, 0x000fe20007fbe0ffULL,
0x00005e0042427625ULL, 0x000fe200078e0045ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000464d7faeULL, 0x0003e6000e101c46ULL, 0x000000011f447824ULL, 0x000fe200078e0244ULL,
0x0000004942427210ULL, 0x000fe20007fde0ffULL, 0x000000ffff417224ULL, 0x000fe200028e0641ULL,
0x0000004c5300720cULL, 0x000fe20003fa6070ULL, 0x00005e0044447625ULL, 0x000fc800078e0045ULL,
0x000000011f4f7824ULL, 0x040fe400078e0217ULL, 0x000000101f527824ULL, 0x000fe200078e00ffULL,
0x0000c0004e1f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200030e0643ULL,
0x0000004944447210ULL, 0x000fe40007fde0ffULL, 0xfffffff0524f7812ULL, 0x000fe200078ee24fULL,
0x00000000401f7faeULL, 0x0003e2000d901c46ULL, 0x0000c00050497811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200030e0645ULL, 0x0000c0004f4f7811ULL, 0x000fc600078e20ffULL,
0x0000000042497faeULL, 0x0003e8000c101c46ULL, 0x00000000444f7faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x00000001141f7824ULL, 0x000fe200078e0207ULL,
0x000000f00f497812ULL, 0x000fc600078ec0ffULL, 0x000000011f407824ULL, 0x140fe200078e0217ULL,
0x000000041f437810ULL, 0x040fe20007ffe0ffULL, 0x000000101f477824ULL, 0x040fe200078e00ffULL,
0x000000021f417810ULL, 0x040fe20007ffe0ffULL, 0x000000011f467824ULL, 0x040fe200078e0244ULL,
0x000000061f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000143457824ULL, 0x100fe200078e0217ULL,
0xfffffff0474c7812ULL, 0x000fe200078ee240ULL, 0x00000010434e7824ULL, 0x000fe400078e00ffULL,
0x0000000141427824ULL, 0x000fc400078e0217ULL, 0x00000010414d7824ULL, 0x040fe200078e00ffULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee245ULL, 0x00000100ff457424ULL, 0x000fe400078e00ffULL,
0x0000000141407824ULL, 0x000fe200078e0244ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL,
0x00005e0046467625ULL, 0x000fc600078e0045ULL, 0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000143427824ULL, 0x100fe200078e0244ULL, 0x0000004946467210ULL, 0x000fe20007f7e0ffULL,
0x000000011f447824ULL, 0x000fe400078e0244ULL, 0x00005e0040407625ULL, 0x000fc800078e0045ULL,
0x00005e0042427625ULL, 0x000fe200078e0045ULL, 0x0000004940407210ULL, 0x000fc60007f1e0ffULL,
0x00005e0044447625ULL, 0x000fc800078e0045ULL, 0x000000011f4f7824ULL, 0x040fe200078e0217ULL,
0x0000004944447210ULL, 0x080fe20007f9e0ffULL, 0x000000101f507824ULL, 0x000fe200078e00ffULL,
0x0000c0004c1f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200018e0647ULL,
0x0000004942427210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff417224ULL, 0x000fe200000e0641ULL,
0xfffffff0504f7812ULL, 0x000fe200078ee24fULL, 0x000000ffff457224ULL, 0x000fe200020e0645ULL,
0x0000c0004e497811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200018e0643ULL,
0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000461f7faeULL, 0x0003e8000b901c46ULL, 0x00000000404d7faeULL, 0x0003e8000b901c46ULL,
0x0000000042497faeULL, 0x0003e8000b901c46ULL, 0x00000000444f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff407f8cULL, 0x000e64000c80043fULL, 0x000000ffff1f7224ULL, 0x002fc400078e0041ULL,
0x0000000000407805ULL, 0x000fca0000015200ULL, 0x0106b400ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fc4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fe400000000ffULL,
0x00000002ff437819ULL, 0x000fe40000011617ULL, 0x0000541008427816ULL, 0x000fe20000000008ULL,
0x0000eab27f007947ULL, 0x000fea000b800000ULL, 0x00001f4342097589ULL, 0x0002a400000e0000ULL,
0x00000008434d7810ULL, 0x002fe20007ffe0ffULL, 0x0000eae27f007947ULL, 0x000fea000b800000ULL,
0x00001f4d42087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010434d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x000fe200078e0042ULL,
0x000081c000407802ULL, 0x000fc40000000f00ULL, 0x0000f4b000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018434d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x004fe200078e0042ULL, 0x0000821000407802ULL, 0x000fc40000000f00ULL,
0x0000f46000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001b50783bULL, 0x000f280000004200ULL,
0x000000001c4c783bULL, 0x002e680000004200ULL, 0x000000001944783bULL, 0x004ea80000004200ULL,
0x000000001a40783bULL, 0x000ee20000004200ULL, 0x00000018ff4b7819ULL, 0x010fe20000011452ULL,
0x0000010052647824ULL, 0x040fe200078e00ffULL, 0x0000888052637816ULL, 0x040fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x002fe2000001144cULL,
0x0000010053677824ULL, 0x040fe200078e00ffULL, 0x000088804c6b7816ULL, 0x040fe200000000ffULL,
0x000001004c6c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011453ULL,
0x0001000053697824ULL, 0x040fe200078e00ffULL, 0x0000888053657816ULL, 0x000fe200000000ffULL,
0x000001004e717824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000005200537306ULL, 0x0003e20000200c00ULL, 0x00000018ff557819ULL, 0x000fe2000001144dULL,
0x0000010050577824ULL, 0x000fe200078e00ffULL, 0x000088804d6d7816ULL, 0x000fe200000000ffULL,
0x0000010051617824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000010045797824ULL, 0x004fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001144eULL,
0x0000006700687306ULL, 0x000fe20000200c00ULL, 0x000001004d527824ULL, 0x042fe200078e00ffULL,
0x000088804e6f7816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001144fULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x0000004c00677306ULL, 0x0003e20000200c00ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x00000052006e7306ULL, 0x0005e20000200c00ULL, 0x000001004f4c7824ULL, 0x002fe200078e00ffULL,
0x0000888051607816ULL, 0x000fc400000000ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x00000018ff737819ULL, 0x000fe4000001144cULL, 0x0000004d00707306ULL, 0x0003e20000200c00ULL,
0x000088804f527816ULL, 0x044fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x0000a8001d4c7811ULL, 0x000fe400078e20ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011444ULL,
0x00000018ff777819ULL, 0x000fe2000001144fULL, 0x0000005200757306ULL, 0x0005e20000200c00ULL,
0x00000100444d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fc40000011445ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff597819ULL, 0x000fe40000011446ULL,
0x0000004e00747306ULL, 0x0003e20000200c00ULL, 0x00000018ff527819ULL, 0x004fe4000001144dULL,
0x00000018ff5a7819ULL, 0x000fe40000011447ULL, 0x00008880477f7816ULL, 0x000fe400000000ffULL,
0x00000018ff497819ULL, 0x000fe20000011450ULL, 0x00000056006a7306ULL, 0x0005e20000200c00ULL,
0x000000004c4c783bULL, 0x002e620000000200ULL, 0x00000018ff4a7819ULL, 0x000fe20000011451ULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fc40000011469ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000007100727306ULL, 0x0009e20000200c00ULL,
0x0000888050567816ULL, 0x044fe200000000ffULL, 0x0001000050507824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000888044717816ULL, 0x050fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x008fc80000011441ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000005700577306ULL, 0x000eb00000200c00ULL, 0x0000006000607306ULL, 0x000ff00000200c00ULL,
0x0000006100617306ULL, 0x000ee20000200c00ULL, 0x0000541056567816ULL, 0x004fe20000000057ULL,
0x000000094c4ca232ULL, 0x002fc40000000000ULL, 0x000000094e4ea232ULL, 0x000fe40000000000ULL,
0x000000084d4da232ULL, 0x080fe40000000000ULL, 0x0000007300767306ULL, 0x0003e20000200c00ULL,
0x000000084f4fa232ULL, 0x000fce0000000000ULL, 0x00000044007a7306ULL, 0x0005e20000200c00ULL,
0x0000888045737816ULL, 0x042fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x0000541060577816ULL, 0x008fc80000000061ULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000005200787306ULL, 0x0003e20000200c00ULL, 0x0000010046447824ULL, 0x044fe200078e00ffULL,
0x000000564c20723cULL, 0x000b680000001820ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000079007c7306ULL, 0x0005e20000200c00ULL, 0x0000888046527816ULL, 0x042fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000888040567816ULL, 0x020fc800000000ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x00000045007b7306ULL, 0x0003e20000200c00ULL,
0x0000010047797824ULL, 0x044fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000044007e7306ULL, 0x0005e20000200c00ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000010040457824ULL, 0x002fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011445ULL, 0x0000004600807306ULL, 0x000fe20000200c00ULL,
0x0000a8001e447811ULL, 0x004fce00078e20ffULL, 0x0000004700617306ULL, 0x0003f00000200c00ULL,
0x00000049005f7306ULL, 0x0005e20000200c00ULL, 0x000000004444783bULL, 0x002e6e0000000200ULL,
0x0000004a00627306ULL, 0x0007e20000200c00ULL, 0x00000018ff497819ULL, 0x004fce0000011442ULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x00000018ff4a7819ULL, 0x008fce0000011443ULL,
0x0000005100517306ULL, 0x000ef00000200c00ULL, 0x0000005400547306ULL, 0x000f220000200c00ULL,
0x0000541050507816ULL, 0x004fce000000005fULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x0000541051517816ULL, 0x008fe20000000062ULL, 0x000000094444a232ULL, 0x082fe20000000000ULL,
0x0000888041627816ULL, 0x000fe200000000ffULL, 0x000000094646a232ULL, 0x000fe40000000000ULL,
0x000000084545a232ULL, 0x080fe40000000000ULL, 0x0000004b00667306ULL, 0x0002e20000200c00ULL,
0x0000541067547816ULL, 0x010fe20000000054ULL, 0x000000504c24723cULL, 0x000b620000001824ULL,
0x000000084747a232ULL, 0x000fca0000000000ULL, 0x0000006900697306ULL, 0x000f220000200c00ULL,
0x0000541070557816ULL, 0x004fe40000000055ULL, 0x00000018ff4b7819ULL, 0x002fe20000011440ULL,
0x0001000040407824ULL, 0x000fc800078e00ffULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000541053507816ULL, 0x028fe20000000066ULL, 0x000000544c38723cULL, 0x000be20000001838ULL,
0x00000018ff407819ULL, 0x000fca0000011440ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000541069517816ULL, 0x010fe4000000006aULL, 0x0000541075557816ULL, 0x020fca0000000076ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000054106f547816ULL, 0x002fce0000000072ULL,
0x0000006500657306ULL, 0x000e700000200c00ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000541063647816ULL, 0x004fce0000000064ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x0000541065657816ULL, 0x002fce0000000068ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x000000644c28723cULL, 0x000f6e0000001828ULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000054106b6c7816ULL, 0x004fce000000006cULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000054106d6d7816ULL, 0x002fce000000006eULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x0000541074747816ULL, 0x008fe2000000005dULL, 0x0000006c4c30723cULL, 0x000f6c0000001830ULL,
0x0000007100717306ULL, 0x000eb00000200c00ULL, 0x0000007300737306ULL, 0x000ee20000200c00ULL,
0x0000541077757816ULL, 0x002fce000000005eULL, 0x0000005b005b7306ULL, 0x000ff00000200c00ULL,
0x0000005c005c7306ULL, 0x000e700000200c00ULL, 0x00000052007d7306ULL, 0x0009f00000200c00ULL,
0x00000056005f7306ULL, 0x000fe20000200c00ULL, 0x000000504c50723cULL, 0x010b6e0000001834ULL,
0x0000005700607306ULL, 0x0009e20000200c00ULL, 0x000000ffff347224ULL, 0x020fc400078e0062ULL,
0x0000010041357824ULL, 0x040fe400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x0000003400627306ULL, 0x0003e20000200c00ULL, 0x000000544c54723cULL, 0x010b62000000183cULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff417819ULL, 0x000fc80000011441ULL,
0x00005410713c7816ULL, 0x024fe20000000078ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00005410733d7816ULL, 0x008fe2000000007cULL, 0x000000744c4c723cULL, 0x000b62000000182cULL,
0x0000888042347816ULL, 0x002fca00000000ffULL, 0x0000007900827306ULL, 0x000e620000200c00ULL,
0x00000100422c7824ULL, 0x060fe200078e00ffULL, 0x0000003c443c723cULL, 0x000b620000001820ULL,
0x00008880432d7816ULL, 0x040fe200000000ffULL, 0x0001000042427824ULL, 0x000fe400078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000003500637306ULL, 0x0005e20000200c00ULL,
0x0000010043217824ULL, 0x060fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0001000043437824ULL, 0x000fc400078e00ffULL, 0x000000ffff207224ULL, 0x000fc600078e002dULL,
0x00000034005d7306ULL, 0x0007e20000200c00ULL, 0x000054107b357816ULL, 0x004fe4000000005cULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x000054107f2d7816ULL, 0x002fc60000000082ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x000054107a347816ULL, 0x008fce000000005bULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000000344434723cULL, 0x000b6e0000001824ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x020fce0000011421ULL,
0x0000004100417306ULL, 0x000e700000200c00ULL, 0x0000002c005e7306ULL, 0x0005f00000200c00ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000054107d2c7816ULL, 0x004fc4000000007eULL,
0x0000541041257816ULL, 0x002fca0000000058ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x0000002c442c723cULL, 0x000b6e0000001828ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054105f287816ULL, 0x020fe40000000060ULL, 0x0000541062297816ULL, 0x000fca0000000063ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000541061217816ULL, 0x002fe2000000005aULL,
0x000000284428723cULL, 0x000b6c0000001830ULL, 0x0000002000647306ULL, 0x0003e20000200c00ULL,
0x000054105d307816ULL, 0x020fce000000005eULL, 0x00000024005b7306ULL, 0x0004e20000200c00ULL,
0x0000541080207816ULL, 0x002fce0000000059ULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x0000541040247816ULL, 0x004fe2000000004bULL, 0x000000204420723cULL, 0x040f6c0000001850ULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x0000541064317816ULL, 0x008fe2000000005bULL,
0x000000244424723cULL, 0x040b6e0000001838ULL, 0x0000541042387816ULL, 0x022fe20000000049ULL,
0x000000304430723cULL, 0x000b620000001854ULL, 0x0000541043397816ULL, 0x004fce000000004aULL,
0x000000384438723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff407f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006010407810ULL, 0x002fe20007ffe0ffULL,
0x01069000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff447224ULL, 0x020fe400078e0041ULL,
0x000000154000720cULL, 0x000fda0003f06070ULL, 0x00007e2000000947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x0106bc00ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008010427810ULL, 0x000fca0007ffe0ffULL,
0x0000620013457a24ULL, 0x000fe200078e0242ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000004074f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114447824ULL, 0x040fe200078e0207ULL,
0x0000004215407217ULL, 0x000fe40007800000ULL, 0x00000002074d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001144a7824ULL, 0x000fe200078e024fULL, 0x0000000607517810ULL, 0x000fe20007ffe0ffULL,
0x0000000144437824ULL, 0x100fe200078e0217ULL, 0x000000f00f4b7812ULL, 0x000fe200078ec0ffULL,
0x000000014a497824ULL, 0x000fc400078e0217ULL, 0x000000104a507824ULL, 0x000fe400078e00ffULL,
0x00000010444c7824ULL, 0x000fe400078e00ffULL, 0x0000000140417824ULL, 0x000fe200078e0a42ULL,
0xfffffff050507812ULL, 0x000fe200078ee249ULL, 0x0000000114467824ULL, 0x000fe200078e024dULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee243ULL, 0x00000100ff497424ULL, 0x000fe200078e00ffULL,
0x0000004114437217ULL, 0x000fe20007800000ULL, 0x0000000144407824ULL, 0x000fc400078e0245ULL,
0x0000000146477824ULL, 0x040fe400078e0217ULL, 0x00000010464e7824ULL, 0x000fe400078e00ffULL,
0x0000000114527824ULL, 0x000fe400078e0251ULL, 0x0000000146427824ULL, 0x000fe200078e0245ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee247ULL, 0x00005e0040407625ULL, 0x000fc800078e0049ULL,
0x000000014a447824ULL, 0x100fe200078e0245ULL, 0x0000004b40467210ULL, 0x000fe20007f1e0ffULL,
0x00000001434a7824ULL, 0x000fe400078e0a14ULL, 0x0000000152457824ULL, 0x040fe400078e0245ULL,
0x0000000152477824ULL, 0x000fe200078e0217ULL, 0x0000004a0700720cULL, 0x080fe20003f66070ULL,
0x00005e0042427625ULL, 0x000fe200078e0049ULL, 0x0000004a4d00720cULL, 0x000fe40003f46070ULL,
0x0000e000504d7811ULL, 0x000fe200078e20ffULL, 0x0000001052527824ULL, 0x000fe200078e00ffULL,
0x0000004b42427210ULL, 0x000fc80007f9e0ffULL, 0xfffffff052527812ULL, 0x000fe200078ee247ULL,
0x000000ffff477224ULL, 0x000fe200000e0641ULL, 0x0000004a4f00720cULL, 0x000fe20003f06070ULL,
0x00005e0044407625ULL, 0x000fe200078e0049ULL, 0x0000e000524f7811ULL, 0x000fc600078e20ffULL,
0x00005e0045447625ULL, 0x000fe200078e0049ULL, 0x0000004b40407210ULL, 0x080fe40007fbe0ffULL,
0x0000e0004c497811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200020e0643ULL,
0x0000004a5100720cULL, 0x000fe20003f86070ULL, 0x000000ffff417224ULL, 0x000fe200028e0641ULL,
0x0000004b44447210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046497faeULL, 0x0003e2000d901c46ULL, 0x0000e0004e4b7811ULL, 0x000fc600078e20ffULL,
0x000000ffff457224ULL, 0x000fe400030e0645ULL, 0x00000000424b7faeULL, 0x0003e8000d101c46ULL,
0x00000000404d7faeULL, 0x0003e8000c101c46ULL, 0x00000000444f7faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000114407824ULL, 0x000fe200078e0207ULL,
0x000000f00f4b7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff497424ULL, 0x000fc400078e00ffULL,
0x0000000140417824ULL, 0x140fe200078e0217ULL, 0x0000000440447810ULL, 0x040fe20007ffe0ffULL,
0x00000010404a7824ULL, 0x040fe200078e00ffULL, 0x0000000240427810ULL, 0x040fe40007ffe0ffULL,
0x00000006404e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000144467824ULL, 0x000fe200078e0217ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee241ULL, 0x00000010444d7824ULL, 0x000fe400078e00ffULL,
0x0000000142437824ULL, 0x000fc400078e0217ULL, 0x00000010424c7824ULL, 0x000fe200078e00ffULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee246ULL, 0x0000000140467824ULL, 0x100fe400078e0245ULL,
0x0000000142407824ULL, 0x000fe200078e0245ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee243ULL,
0x00005e0046467625ULL, 0x000fe200078e0049ULL, 0x0000e0004d4d7811ULL, 0x000fc600078e20ffULL,
0x0000000144427824ULL, 0x100fe200078e0245ULL, 0x0000004b46467210ULL, 0x000fe20007f5e0ffULL,
0x000000014e447824ULL, 0x000fe400078e0245ULL, 0x00005e0040407625ULL, 0x000fc800078e0049ULL,
0x00005e0042427625ULL, 0x000fe200078e0049ULL, 0x0000004b40407210ULL, 0x000fc60007f1e0ffULL,
0x000000014e4f7824ULL, 0x000fe400078e0217ULL, 0x00005e0044447625ULL, 0x000fe200078e0049ULL,
0x0000e0004a497811ULL, 0x000fc600078e20ffULL, 0x000000104e4e7824ULL, 0x000fe200078e00ffULL,
0x0000004b44447210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff477224ULL, 0x000fe200010e0647ULL,
0x0000004b42427210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff417224ULL, 0x000fe200000e0641ULL,
0xfffffff04e4f7812ULL, 0x000fe200078ee24fULL, 0x000000ffff457224ULL, 0x000fe200018e0645ULL,
0x0000e0004c4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200010e0643ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046497faeULL, 0x0003e8000b901c46ULL, 0x00000000404b7faeULL, 0x0003e8000b901c46ULL,
0x00000000424d7faeULL, 0x0003e8000b901c46ULL, 0x00000000444f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106480014447f8cULL, 0x0004e4000c80043fULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x01064c0014437984ULL, 0x000f240000000800ULL, 0x8000000043ff7812ULL, 0x018fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240477210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004742427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01064c0014437984ULL, 0x000ee40000000800ULL,
0x8000000043ff7812ULL, 0x008fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010100000e437984ULL, 0x000ee80000000800ULL, 0x010300000e457984ULL, 0x0004620000000800ULL,
0x000000484300720bULL, 0x008fe20003f1d000ULL, 0x0000cf127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000427806ULL, 0x004fc800000e0100ULL, 0x0000ffff42ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff447424ULL, 0x000fc400078e00ffULL,
0x000000ffff4c7224ULL, 0x000fd200078e0048ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000021800780cULL, 0x000fe40003f05270ULL, 0x000000484300720bULL, 0x000fe20003f54000ULL,
0x0000ced27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000477806ULL, 0x000fc400010e0100ULL,
0x0000004348418209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991047407816ULL, 0x000fc600000000ffULL, 0x010500410e008388ULL, 0x0005e20000000800ULL,
0x000000ff4000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004348417209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff47ff7812ULL, 0x000fc6000780c0ffULL, 0x8000004148407221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b40407820ULL, 0x000fc80000410000ULL, 0x0000004000497308ULL, 0x000ea40000000800ULL,
0x0000004912127220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff4d7819ULL, 0x000fe20000011617ULL, 0x0000ce127f007947ULL, 0x000fea000b800000ULL,
0x00001f4d49407589ULL, 0x0004e400000e0000ULL, 0x000000403c3c7220ULL, 0x088fe20000410000ULL,
0x000000403d3d7220ULL, 0x080fe20000410000ULL, 0x0000004034347220ULL, 0x080fe20000410000ULL,
0x0000004035357220ULL, 0x080fe20000410000ULL, 0x000000402c2c7220ULL, 0x080fe20000410000ULL,
0x000000402d2d7220ULL, 0x080fe20000410000ULL, 0x0000004020207220ULL, 0x080fe20000410000ULL,
0x0000004021217220ULL, 0x080fe20000410000ULL, 0x0000004028287220ULL, 0x080fe20000410000ULL,
0x0000004029297220ULL, 0x080fe20000410000ULL, 0x0000004024247220ULL, 0x080fe20000410000ULL,
0x0000004025257220ULL, 0x080fe20000410000ULL, 0x0000004030307220ULL, 0x080fe20000410000ULL,
0x0000004031317220ULL, 0x080fe20000410000ULL, 0x0000004038387220ULL, 0x080fe20000410000ULL,
0x0000004039397220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0047ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008174d7811ULL, 0x006fe200078ff0ffULL, 0x0000cd027f007947ULL, 0x000fea000b800000ULL,
0x00001f4d49407589ULL, 0x0002a400000e0000ULL, 0x000000403e3e7220ULL, 0x084fe20000410000ULL,
0x000000403f3f7220ULL, 0x080fe20000410000ULL, 0x0000004036367220ULL, 0x080fe20000410000ULL,
0x0000004037377220ULL, 0x080fe20000410000ULL, 0x000000402e2e7220ULL, 0x080fe20000410000ULL,
0x000000402f2f7220ULL, 0x080fe20000410000ULL, 0x0000004022227220ULL, 0x080fe20000410000ULL,
0x0000004023237220ULL, 0x080fe20000410000ULL, 0x000000402a2a7220ULL, 0x080fe20000410000ULL,
0x000000402b2b7220ULL, 0x080fe20000410000ULL, 0x0000004026267220ULL, 0x080fe20000410000ULL,
0x0000004027277220ULL, 0x080fe20000410000ULL, 0x0000004032327220ULL, 0x080fe20000410000ULL,
0x0000004033337220ULL, 0x080fe20000410000ULL, 0x000000403a3a7220ULL, 0x080fe20000410000ULL,
0x000000403b3b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff47ff7812ULL, 0x000fe20007800842ULL, 0x00000001ff447424ULL, 0x000fe200078e00ffULL,
0x00000043484c7209ULL, 0x000fd60007810000ULL, 0x8000004c43430221ULL, 0x000fe20000010000ULL,
0x00007610ff440816ULL, 0x000fc60000000044ULL, 0x3fb8aa3b43430820ULL, 0x000fc80000410000ULL,
0x00000043000a0308ULL, 0x000ea40000000800ULL, 0x0000000a45450220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001245127221ULL, 0x002fc20000010000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe4000780481fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe4000780481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910441f7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1f00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fe400000000ffULL,
0x00000002ff427819ULL, 0x000fe40000011617ULL, 0x00005410081f7816ULL, 0x000fe20000000008ULL,
0x0000c8e27f007947ULL, 0x000fea000b800000ULL, 0x00001f421f097589ULL, 0x0002a400000e0000ULL,
0x00000008424d7810ULL, 0x002fe20007ffe0ffULL, 0x0000c9127f007947ULL, 0x000fea000b800000ULL,
0x00001f4d1f087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010424d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x000fe200078e001fULL,
0x0000a58000407802ULL, 0x000fc40000000f00ULL, 0x0000d0f000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018424d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x004fe200078e001fULL, 0x0000a5d000407802ULL, 0x000fc40000000f00ULL,
0x0000d0a000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000650783bULL, 0x000f280000004200ULL,
0x000000000544783bULL, 0x004ea80000004200ULL, 0x000000000448783bULL, 0x000e680000004200ULL,
0x000000000340783bULL, 0x000ee20000004200ULL, 0x00000018ff1f7819ULL, 0x012fe20000011450ULL,
0x0000010050577824ULL, 0x040fe200078e00ffULL, 0x0000888050567816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011452ULL,
0x00000100446c7824ULL, 0x004fe200078e00ffULL, 0x00008880525f7816ULL, 0x000fe200000000ffULL,
0x0000010053697824ULL, 0x040fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x00010000536a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011444ULL,
0x0000010046727824ULL, 0x000fe200078e00ffULL, 0x00000050005b7306ULL, 0x0003e20000200c00ULL,
0x00008880446b7816ULL, 0x040fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011453ULL, 0x00000100515d7824ULL, 0x000fe200078e00ffULL,
0x0000888053687816ULL, 0x000fe200000000ffULL, 0x00000100497b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011445ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000010052507824ULL, 0x042fe200078e00ffULL, 0x00008880456e7816ULL, 0x000fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x000001004b7f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fc40000011446ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x00000044006d7306ULL, 0x0003e20000200c00ULL,
0x0000888046717816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011447ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000005200537306ULL, 0x0005e20000200c00ULL,
0x0000010047447824ULL, 0x002fe200078e00ffULL, 0x00008880515c7816ULL, 0x000fc400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000018ff747819ULL, 0x000fe40000011444ULL,
0x0000b00002447811ULL, 0x000fe200078e20ffULL, 0x0000010045527824ULL, 0x044fe200078e00ffULL,
0x0000004600737306ULL, 0x000fe20000200c00ULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff527819ULL, 0x000fc40000011452ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000052006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff647819ULL, 0x000fe40000011448ULL,
0x0000888048777816ULL, 0x040fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011451ULL,
0x0000004500707306ULL, 0x0005e20000200c00ULL, 0x0000888047527816ULL, 0x042fe200000000ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011449ULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x00008880497a7816ULL, 0x040fe200000000ffULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011447ULL,
0x0000005200757306ULL, 0x0003e20000200c00ULL, 0x0000010048457824ULL, 0x044fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fc40000011449ULL, 0x00000018ff627819ULL, 0x000fe4000001144aULL,
0x0000005700577306ULL, 0x000ea20000200c00ULL, 0x00000018ff527819ULL, 0x002fe40000011445ULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff637819ULL, 0x000fc4000001144bULL, 0x000088804b807816ULL, 0x040fe200000000ffULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe4000001147fULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000005d005d7306ULL, 0x000f220000200c00ULL,
0x0000541056567816ULL, 0x004fe40000000057ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff7b7819ULL, 0x000fc4000001147bULL, 0x00000018ff607819ULL, 0x008fe20000011440ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff617819ULL, 0x000fce0000011441ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000054105c577816ULL, 0x010fce000000005dULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000094444a232ULL, 0x082fe40000000000ULL,
0x000000094646a232ULL, 0x000fe40000000000ULL, 0x000000084545a232ULL, 0x000fc60000000000ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000000084747a232ULL, 0x000fce0000000000ULL,
0x0000004800797306ULL, 0x0003e20000200c00ULL, 0x00000056443c723cULL, 0x000b6e000000183cULL,
0x0000001f005a7306ULL, 0x0004e20000200c00ULL, 0x000001004a487824ULL, 0x002fe200078e00ffULL,
0x0000b00000567811ULL, 0x020fc400078e20ffULL, 0x0000888040577816ULL, 0x000fe400000000ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000005200787306ULL, 0x0003e20000200c00ULL,
0x00000018ff1f7819ULL, 0x004fce0000011442ULL, 0x0000004d005e7306ULL, 0x0005e20000200c00ULL,
0x000088804a527816ULL, 0x042fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x000054105b5a7816ULL, 0x008fc8000000005aULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x00000018ff4d7819ULL, 0x004fce0000011443ULL,
0x00000049007c7306ULL, 0x0005f00000200c00ULL, 0x00000048007e7306ULL, 0x0007e20000200c00ULL,
0x0000541068497816ULL, 0x004fe40000000069ULL, 0x00005410515b7816ULL, 0x002fca000000005eULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000054105f487816ULL, 0x008fe20000000050ULL,
0x0000010040507824ULL, 0x040fe200078e00ffULL, 0x0000005a4434723cULL, 0x000be20000001834ULL,
0x0001000040407824ULL, 0x000fc800078e00ffULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff5a7819ULL, 0x020fe40000011450ULL,
0x00008880415b7816ULL, 0x000fc600000000ffULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x0000541053507816ULL, 0x002fce0000000054ULL, 0x00000052007d7306ULL, 0x0003f00000200c00ULL,
0x0000004a007f7306ULL, 0x0007e20000200c00ULL, 0x00000018ff527819ULL, 0x002fe4000001144bULL,
0x000054106a517816ULL, 0x004fca0000000055ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000484448723cULL, 0x008b64000000182cULL, 0x00000000562c783bULL, 0x020e6a0000000200ULL,
0x0000006c006c7306ULL, 0x000eb00000200c00ULL, 0x0000006e006e7306ULL, 0x000ef00000200c00ULL,
0x0000005800587306ULL, 0x000f220000200c00ULL, 0x000054106b547816ULL, 0x004fce000000006cULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x000054106e557816ULL, 0x008fce000000006fULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000054106d587816ULL, 0x010fe20000000058ULL,
0x000000092c2ca232ULL, 0x082fe40000000000ULL, 0x000000092e2ea232ULL, 0x000fe40000000000ULL,
0x000000082d2da232ULL, 0x080fe40000000000ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541070597816ULL, 0x004fe20000000059ULL, 0x000000082f2fa232ULL, 0x000fcc0000000000ULL,
0x0000007400747306ULL, 0x000eb00000200c00ULL, 0x0000006600667306ULL, 0x000ee20000200c00ULL,
0x00005410715c7816ULL, 0x002fce0000000072ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00005410755d7816ULL, 0x004fce0000000074ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x0000541073667816ULL, 0x008fe20000000066ULL, 0x0000005c445c723cULL, 0x000bec0000001830ULL,
0x0000005200827306ULL, 0x0005e20000200c00ULL, 0x0000888043307816ULL, 0x020fce00000000ffULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x000000504450723cULL, 0x004be20000001820ULL,
0x0000541076677816ULL, 0x002fcc0000000067ULL, 0x0000010041217824ULL, 0x020fe200078e00ffULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x000000ffff207224ULL, 0x000fc600078e005bULL,
0x00000018ff217819ULL, 0x000fc80000011421ULL, 0x0000007b007b7306ULL, 0x000e700000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000eb00000200c00ULL,
0x0000002000697306ULL, 0x0007f00000200c00ULL, 0x00000021006a7306ULL, 0x0009e20000200c00ULL,
0x0001000041207824ULL, 0x008fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000005700837306ULL, 0x0007e20000200c00ULL, 0x0000010042217824ULL, 0x010fce00078e00ffULL,
0x0000005a00687306ULL, 0x0009e20000200c00ULL, 0x000000544454723cULL, 0x048bee0000001828ULL,
0x0000010043297824ULL, 0x060fe200078e00ffULL, 0x000000584458723cULL, 0x010b620000001824ULL,
0x00000018ff287819ULL, 0x000fe20000011421ULL, 0x00000020006c7306ULL, 0x0007e20000200c00ULL,
0x000054107a217816ULL, 0x002fe2000000007bULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fc40000011429ULL, 0x0000888042247816ULL, 0x060fe200000000ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x000000664444723cULL, 0x000b620000001838ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541077207816ULL, 0x008fe40000000078ULL,
0x0000541080297816ULL, 0x004fe40000000081ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x000000202c20723cULL, 0x000b6e000000183cULL, 0x0000002800677306ULL, 0x0205f00000200c00ULL,
0x0000004000417306ULL, 0x000fe20000200c00ULL, 0x000054107d287816ULL, 0x004fc4000000007eULL,
0x000054107c257816ULL, 0x002fca0000000065ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000000282c28723cULL, 0x000f6e0000001848ULL, 0x0000006300637306ULL, 0x000ff00000200c00ULL,
0x0000006000607306ULL, 0x000e700000200c00ULL, 0x0000006100617306ULL, 0x000eb00000200c00ULL,
0x0000002400407306ULL, 0x0007220000200c00ULL, 0x0000541041387816ULL, 0x002fce0000000060ULL,
0x00000030003d7306ULL, 0x0003e20000200c00ULL, 0x0000541079247816ULL, 0x008fe40000000064ULL,
0x000054106c397816ULL, 0x004fca0000000061ULL, 0x00000031003e7306ULL, 0x0004e20000200c00ULL,
0x000000242c24723cULL, 0x000b620000001834ULL, 0x0000541083307816ULL, 0x002fe40000000068ULL,
0x00005410403c7816ULL, 0x010fc80000000067ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x000054107f347816ULL, 0x020fe20000000062ULL, 0x000000382c38723cULL, 0x000b620000001858ULL,
0x0000541082357816ULL, 0x000fe40000000063ULL, 0x0000541069317816ULL, 0x004fc6000000006aULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x000054103d3d7816ULL, 0x008fe2000000003eULL,
0x000000342c34723cULL, 0x040b6c0000001850ULL, 0x0000004200427306ULL, 0x000e640000200c00ULL,
0x000000302c30723cULL, 0x040b6c0000001854ULL, 0x0000004300487306ULL, 0x000ea40000200c00ULL,
0x0000003c2c3c723cULL, 0x000b62000000185cULL, 0x0000541042427816ULL, 0x002fc4000000001fULL,
0x0000541048437816ULL, 0x004fce000000004dULL, 0x000000422c2c723cULL, 0x000b620000001844ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff447f8cULL, 0x020e62000c80043fULL,
0x000000ffff467224ULL, 0x000fce00078e00ffULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x0106bc00ff1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fe40007804845ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240427210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011443ULL, 0x000000421f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0643ULL, 0x000000021f1f7819ULL, 0x000fc80000001242ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000a010407810ULL, 0x000fca0007ffe0ffULL,
0x0000620013447a24ULL, 0x000fe200078e0240ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000040151f7217ULL, 0x000fe20007800000ULL, 0x0000000114417824ULL, 0x000fe200078e0207ULL,
0x0000000407517810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff457424ULL, 0x000fe200078e00ffULL,
0x00000002074b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000141427824ULL, 0x000fe200078e0217ULL,
0x000000f00f497812ULL, 0x000fe200078ec0ffULL, 0x0000001041437824ULL, 0x000fe400078e00ffULL,
0x000000011f1f7824ULL, 0x000fc400078e0a40ULL, 0x0000000114477824ULL, 0x040fe200078e0251ULL,
0xfffffff0434a7812ULL, 0x000fe200078ee242ULL, 0x0000000141407824ULL, 0x000fe200078e0244ULL,
0x0000001f141f7217ULL, 0x000fe20007800000ULL, 0x0000000147467824ULL, 0x040fe400078e0217ULL,
0x0000001047537824ULL, 0x000fe400078e00ffULL, 0x00005e0040407625ULL, 0x000fc600078e0045ULL,
0xfffffff053507812ULL, 0x000fe200078ee246ULL, 0x0000000114427824ULL, 0x000fe200078e024bULL,
0x0000004940467210ULL, 0x000fe40007f1e0ffULL, 0x0000000607537810ULL, 0x000fe20007ffe0ffULL,
0x0000000142437824ULL, 0x040fe400078e0217ULL, 0x0000001042487824ULL, 0x040fe400078e00ffULL,
0x0000000142407824ULL, 0x100fe400078e0244ULL, 0x0000000147427824ULL, 0x000fe200078e0244ULL,
0xfffffff0484d7812ULL, 0x000fe200078ee243ULL, 0x000000ffff477224ULL, 0x000fc400000e0641ULL,
0x000000011f487824ULL, 0x000fe200078e0a14ULL, 0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL,
0x00005e0040407625ULL, 0x000fc600078e0045ULL, 0x000000480700720cULL, 0x080fe20003f86070ULL,
0x00000001141f7824ULL, 0x000fe200078e0253ULL, 0x0000004940407210ULL, 0x000fe20007fbe0ffULL,
0x00005e0042427625ULL, 0x000fe200078e0045ULL, 0x000000484b00720cULL, 0x080fe40003f66070ULL,
0x000000485100720cULL, 0x080fe20003f06070ULL, 0x000000011f447824ULL, 0x000fe200078e0244ULL,
0x0000004942427210ULL, 0x000fe20007fde0ffULL, 0x000000ffff417224ULL, 0x000fe200028e0641ULL,
0x000000485300720cULL, 0x000fe20003fa6070ULL, 0x00005e0044447625ULL, 0x000fc800078e0045ULL,
0x000000011f4b7824ULL, 0x040fe400078e0217ULL, 0x000000101f527824ULL, 0x000fe200078e00ffULL,
0x0000c0004a1f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200030e0643ULL,
0x0000004944447210ULL, 0x000fe40007fde0ffULL, 0xfffffff0524b7812ULL, 0x000fe200078ee24bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000461f7faeULL, 0x0003e2000e101c46ULL,
0x0000c00050497811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200030e0645ULL,
0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL, 0x00000000404d7faeULL, 0x0003e8000d901c46ULL,
0x0000000042497faeULL, 0x0003e8000c101c46ULL, 0x00000000444b7faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x00000001141f7824ULL, 0x000fc800078e0207ULL,
0x000000011f407824ULL, 0x040fe200078e0217ULL, 0x000000041f437810ULL, 0x040fe20007ffe0ffULL,
0x000000101f477824ULL, 0x040fe200078e00ffULL, 0x000000021f417810ULL, 0x000fc60007ffe0ffULL,
0x0000000143457824ULL, 0x100fe200078e0217ULL, 0xfffffff047487812ULL, 0x000fe200078ee240ULL,
0x0000001043467824ULL, 0x000fe400078e00ffULL, 0x0000000141427824ULL, 0x040fe400078e0217ULL,
0x0000001041497824ULL, 0x000fe200078e00ffULL, 0xfffffff0464b7812ULL, 0x000fe200078ee245ULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x000000011f467824ULL, 0x140fe200078e0244ULL,
0x000000061f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000141407824ULL, 0x000fe200078e0244ULL,
0xfffffff0494a7812ULL, 0x000fe200078ee242ULL, 0x00005e0046467625ULL, 0x000fe200078e0045ULL,
0x000000f00f497812ULL, 0x000fc400078ec0ffULL, 0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL,
0x0000000143427824ULL, 0x100fe200078e0244ULL, 0x0000004946467210ULL, 0x000fe20007f7e0ffULL,
0x000000011f447824ULL, 0x000fe400078e0244ULL, 0x00005e0040407625ULL, 0x000fc800078e0045ULL,
0x00005e0042427625ULL, 0x000fe200078e0045ULL, 0x0000004940407210ULL, 0x000fc60007f1e0ffULL,
0x00005e0044447625ULL, 0x000fc800078e0045ULL, 0x000000011f4d7824ULL, 0x040fe200078e0217ULL,
0x0000004944447210ULL, 0x080fe20007f9e0ffULL, 0x000000101f507824ULL, 0x000fe200078e00ffULL,
0x0000c000481f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200018e0647ULL,
0x0000004942427210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff417224ULL, 0x000fe200000e0641ULL,
0xfffffff0504d7812ULL, 0x000fe200078ee24dULL, 0x000000ffff457224ULL, 0x000fe200020e0645ULL,
0x0000c0004a497811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200018e0643ULL,
0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000461f7faeULL, 0x0003e8000b901c46ULL, 0x0000000040497faeULL, 0x0003e8000b901c46ULL,
0x00000000424b7faeULL, 0x0003e8000b901c46ULL, 0x00000000444d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff407f8cULL, 0x000e64000c80043fULL, 0x000000ffff1f7224ULL, 0x002fc400078e0041ULL,
0x0000000000407805ULL, 0x000fca0000015200ULL, 0x0106b400ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fc4000780484fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe4000780484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fe400000000ffULL,
0x00000002ff437819ULL, 0x000fe40000011617ULL, 0x0000541008427816ULL, 0x000fe20000000008ULL,
0x0000ae327f007947ULL, 0x000fea000b800000ULL, 0x00001f4342097589ULL, 0x0002a400000e0000ULL,
0x00000008434d7810ULL, 0x002fe20007ffe0ffULL, 0x0000ae627f007947ULL, 0x000fea000b800000ULL,
0x00001f4d42087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010434d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x000fe200078e0042ULL,
0x0000c0e000407802ULL, 0x000fc40000000f00ULL, 0x0000b59000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018434d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x004fe200078e0042ULL, 0x0000c13000407802ULL, 0x000fc40000000f00ULL,
0x0000b54000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001b50783bULL, 0x000f280000004200ULL,
0x000000001c48783bULL, 0x000e680000004200ULL, 0x000000001944783bULL, 0x004ea80000004200ULL,
0x000000001a40783bULL, 0x002e620000004200ULL, 0x00000018ff4f7819ULL, 0x010fe20000011452ULL,
0x0000010052647824ULL, 0x040fe200078e00ffULL, 0x0000888052637816ULL, 0x040fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011448ULL,
0x0000010053677824ULL, 0x040fe200078e00ffULL, 0x00008880486b7816ULL, 0x040fe200000000ffULL,
0x00000100486c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011453ULL,
0x0001000053697824ULL, 0x040fe200078e00ffULL, 0x0000888053657816ULL, 0x000fe200000000ffULL,
0x000001004a717824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000005200537306ULL, 0x0009e20000200c00ULL, 0x00000018ff557819ULL, 0x000fe20000011449ULL,
0x0000010050577824ULL, 0x000fe200078e00ffULL, 0x00008880496d7816ULL, 0x000fe200000000ffULL,
0x0000010051617824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000010045797824ULL, 0x004fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001144aULL,
0x0000006700687306ULL, 0x000fe20000200c00ULL, 0x0000010049527824ULL, 0x050fe200078e00ffULL,
0x000088804a6f7816ULL, 0x040fe200000000ffULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001144bULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x0000004800677306ULL, 0x0005e20000200c00ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x00000052006e7306ULL, 0x0009e20000200c00ULL, 0x000001004b487824ULL, 0x004fe200078e00ffULL,
0x0000888051607816ULL, 0x000fc400000000ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x00000018ff737819ULL, 0x000fe40000011448ULL, 0x0000004900707306ULL, 0x0005e20000200c00ULL,
0x000088804b527816ULL, 0x050fe200000000ffULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x0000b0001d487811ULL, 0x000fe400078e20ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011444ULL,
0x00000018ff777819ULL, 0x000fe2000001144bULL, 0x0000005200757306ULL, 0x0009e20000200c00ULL,
0x0000010044497824ULL, 0x004fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fc40000011445ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff597819ULL, 0x000fe40000011446ULL,
0x0000004a00747306ULL, 0x0005e20000200c00ULL, 0x00000018ff527819ULL, 0x010fe40000011449ULL,
0x00000018ff5a7819ULL, 0x000fe40000011447ULL, 0x00008880477f7816ULL, 0x000fe400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011450ULL, 0x00000056006a7306ULL, 0x0009e20000200c00ULL,
0x000000004848783bULL, 0x004ea20000000200ULL, 0x00000018ff4e7819ULL, 0x000fe20000011451ULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fc40000011469ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000007100727306ULL, 0x0007e20000200c00ULL,
0x0000888050567816ULL, 0x050fe200000000ffULL, 0x0001000050507824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000888044717816ULL, 0x048fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x002fc80000011441ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x0000006000607306ULL, 0x000ff00000200c00ULL,
0x0000006100617306ULL, 0x000ee20000200c00ULL, 0x0000541056567816ULL, 0x002fe20000000057ULL,
0x000000094848a232ULL, 0x004fc40000000000ULL, 0x000000094a4aa232ULL, 0x000fe40000000000ULL,
0x000000084949a232ULL, 0x080fe40000000000ULL, 0x0000007300767306ULL, 0x0003e20000200c00ULL,
0x000000084b4ba232ULL, 0x000fce0000000000ULL, 0x00000044007a7306ULL, 0x0005e20000200c00ULL,
0x0000888045737816ULL, 0x042fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x0000541060577816ULL, 0x008fc80000000061ULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000005200787306ULL, 0x0003e20000200c00ULL, 0x0000010046447824ULL, 0x044fe200078e00ffULL,
0x000000564820723cULL, 0x000b680000001820ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000079007c7306ULL, 0x0005e20000200c00ULL, 0x0000888046527816ULL, 0x042fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000888040567816ULL, 0x020fc800000000ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x00000045007b7306ULL, 0x0003e20000200c00ULL,
0x0000010047797824ULL, 0x044fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000044007e7306ULL, 0x0005e20000200c00ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000010040457824ULL, 0x002fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011445ULL, 0x0000004600807306ULL, 0x000fe20000200c00ULL,
0x0000b0001e447811ULL, 0x004fce00078e20ffULL, 0x0000004700617306ULL, 0x0003f00000200c00ULL,
0x0000004d005f7306ULL, 0x0005e20000200c00ULL, 0x000000004444783bULL, 0x002e6e0000000200ULL,
0x0000004e00627306ULL, 0x0007e20000200c00ULL, 0x00000018ff4d7819ULL, 0x004fce0000011442ULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x00000018ff4e7819ULL, 0x008fce0000011443ULL,
0x0000005100517306ULL, 0x000ef00000200c00ULL, 0x0000005400547306ULL, 0x000f220000200c00ULL,
0x0000541050507816ULL, 0x004fce000000005fULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x0000541051517816ULL, 0x008fe20000000062ULL, 0x000000094444a232ULL, 0x082fe20000000000ULL,
0x0000888041627816ULL, 0x000fe200000000ffULL, 0x000000094646a232ULL, 0x000fe40000000000ULL,
0x000000084545a232ULL, 0x080fe40000000000ULL, 0x0000004f00667306ULL, 0x0002e20000200c00ULL,
0x0000541067547816ULL, 0x010fe20000000054ULL, 0x000000504824723cULL, 0x000b620000001824ULL,
0x000000084747a232ULL, 0x000fca0000000000ULL, 0x0000006900697306ULL, 0x000f220000200c00ULL,
0x0000541070557816ULL, 0x004fe40000000055ULL, 0x00000018ff4f7819ULL, 0x002fe20000011440ULL,
0x0001000040407824ULL, 0x000fc800078e00ffULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000541053507816ULL, 0x028fe20000000066ULL, 0x000000544838723cULL, 0x000be20000001838ULL,
0x00000018ff407819ULL, 0x000fca0000011440ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000541069517816ULL, 0x010fe4000000006aULL, 0x0000541075557816ULL, 0x020fca0000000076ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000054106f547816ULL, 0x002fce0000000072ULL,
0x0000006500657306ULL, 0x000e700000200c00ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000541063647816ULL, 0x004fce0000000064ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x0000541065657816ULL, 0x002fce0000000068ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x000000644828723cULL, 0x000f6e0000001828ULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000054106b6c7816ULL, 0x004fce000000006cULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000054106d6d7816ULL, 0x002fce000000006eULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x0000541074747816ULL, 0x008fe2000000005dULL, 0x0000006c4830723cULL, 0x000f6c0000001830ULL,
0x0000007100717306ULL, 0x000eb00000200c00ULL, 0x0000007300737306ULL, 0x000ee20000200c00ULL,
0x0000541077757816ULL, 0x002fce000000005eULL, 0x0000005b005b7306ULL, 0x000ff00000200c00ULL,
0x0000005c005c7306ULL, 0x000e700000200c00ULL, 0x00000052007d7306ULL, 0x0009f00000200c00ULL,
0x00000056005f7306ULL, 0x000fe20000200c00ULL, 0x000000504850723cULL, 0x010b6e0000001834ULL,
0x0000005700607306ULL, 0x0009e20000200c00ULL, 0x000000ffff347224ULL, 0x020fc400078e0062ULL,
0x0000010041357824ULL, 0x040fe400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x0000003400627306ULL, 0x0003e20000200c00ULL, 0x000000544854723cULL, 0x010b62000000183cULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff417819ULL, 0x000fc80000011441ULL,
0x00005410713c7816ULL, 0x024fe20000000078ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00005410733d7816ULL, 0x008fe2000000007cULL, 0x000000744848723cULL, 0x000b62000000182cULL,
0x0000888042347816ULL, 0x002fca00000000ffULL, 0x0000007900827306ULL, 0x000e620000200c00ULL,
0x00000100422c7824ULL, 0x060fe200078e00ffULL, 0x0000003c443c723cULL, 0x000b620000001820ULL,
0x00008880432d7816ULL, 0x040fe200000000ffULL, 0x0001000042427824ULL, 0x000fe400078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000003500637306ULL, 0x0005e20000200c00ULL,
0x0000010043217824ULL, 0x060fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0001000043437824ULL, 0x000fc400078e00ffULL, 0x000000ffff207224ULL, 0x000fc600078e002dULL,
0x00000034005d7306ULL, 0x0007e20000200c00ULL, 0x000054107b357816ULL, 0x004fe4000000005cULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x000054107f2d7816ULL, 0x002fc60000000082ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x000054107a347816ULL, 0x008fce000000005bULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000000344434723cULL, 0x000b6e0000001824ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x020fce0000011421ULL,
0x0000004100417306ULL, 0x000e700000200c00ULL, 0x0000002c005e7306ULL, 0x0005f00000200c00ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000054107d2c7816ULL, 0x004fc4000000007eULL,
0x0000541041257816ULL, 0x002fca0000000058ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x0000002c442c723cULL, 0x000b6e0000001828ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x000054105f287816ULL, 0x020fe40000000060ULL, 0x0000541062297816ULL, 0x000fca0000000063ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000541061217816ULL, 0x002fe2000000005aULL,
0x000000284428723cULL, 0x000b6c0000001830ULL, 0x0000002000647306ULL, 0x0003e20000200c00ULL,
0x000054105d307816ULL, 0x020fce000000005eULL, 0x00000024005b7306ULL, 0x0004e20000200c00ULL,
0x0000541080207816ULL, 0x002fce0000000059ULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x0000541040247816ULL, 0x004fe2000000004fULL, 0x000000204420723cULL, 0x040f6c0000001850ULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x0000541064317816ULL, 0x008fe2000000005bULL,
0x000000244424723cULL, 0x040b6e0000001838ULL, 0x0000541042387816ULL, 0x022fe2000000004dULL,
0x000000304430723cULL, 0x000b620000001854ULL, 0x0000541043397816ULL, 0x004fce000000004eULL,
0x000000384438723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff407f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000a010407810ULL, 0x002fe20007ffe0ffULL,
0x01069800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff447224ULL, 0x020fe400078e0041ULL,
0x000000154000720cULL, 0x000fe20003f06070ULL, 0x000000ffff487224ULL, 0x000fd800078e004cULL,
0x00003ef000000947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240457210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004542427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c010427810ULL, 0x000fca0007ffe0ffULL, 0x0000620013437a24ULL, 0x000fe200078e0242ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x0000004215407217ULL, 0x000fe20007800000ULL,
0x0000000114447824ULL, 0x000fe200078e0207ULL, 0x00000004074d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000207457810ULL, 0x040fe20007ffe0ffULL, 0x0000000140417824ULL, 0x000fe200078e0a42ULL,
0x00000006074f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114487824ULL, 0x040fe400078e024dULL,
0x0000000114427824ULL, 0x040fe200078e0245ULL, 0x0000004114417217ULL, 0x000fe20007800000ULL,
0x0000000144407824ULL, 0x000fc400078e0217ULL, 0x0000001044497824ULL, 0x000fe400078e00ffULL,
0x0000000148477824ULL, 0x140fe400078e0217ULL, 0x00000010484e7824ULL, 0x000fe200078e00ffULL,
0xfffffff0494a7812ULL, 0x000fe200078ee240ULL, 0x0000000142467824ULL, 0x040fe200078e0217ULL,
0x000000f00f497812ULL, 0x000fe200078ec0ffULL, 0x00000010424b7824ULL, 0x000fe200078e00ffULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee247ULL, 0x0000000114507824ULL, 0x000fc400078e024fULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee246ULL,
0x0000000144407824ULL, 0x100fe400078e0243ULL, 0x0000000142427824ULL, 0x100fe200078e0243ULL,
0x0000e0004b4b7811ULL, 0x000fe200078e20ffULL, 0x0000000148447824ULL, 0x100fe400078e0243ULL,
0x0000000150467824ULL, 0x040fe400078e0243ULL, 0x0000000150437824ULL, 0x000fc400078e0217ULL,
0x0000001050507824ULL, 0x000fe400078e00ffULL, 0x0000000141487824ULL, 0x000fe400078e0a14ULL,
0x00005e0040407625ULL, 0x080fe200078e0047ULL, 0xfffffff050507812ULL, 0x000fe400078ee243ULL,
0x000000484500720cULL, 0x080fe20003f46070ULL, 0x00005e0042427625ULL, 0x000fe200078e0047ULL,
0x0000004940407210ULL, 0x000fe40007fbe0ffULL, 0x000000480700720cULL, 0x080fe20003f66070ULL,
0x00005e0044447625ULL, 0x000fe200078e0047ULL, 0x000000484d00720cULL, 0x000fc40003f26070ULL,
0x000000484f00720cULL, 0x000fe20003f06070ULL, 0x00005e0046467625ULL, 0x000fe200078e0047ULL,
0x0000004942427210ULL, 0x080fe40007f9e0ffULL, 0x0000e0004e4d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff417224ULL, 0x000fe200028e0641ULL, 0x0000004944447210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff437224ULL, 0x000fe200020e0643ULL, 0x0000004946467210ULL, 0x000fe40007fde0ffULL,
0x0000e0004a497811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200028e0645ULL,
0x0000e000504f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fc400030e0647ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040497faeULL, 0x0003e8000d901c46ULL,
0x00000000424b7faeULL, 0x0003e8000d101c46ULL, 0x00000000444d7faeULL, 0x0003e8000c901c46ULL,
0x00000000464f7faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000114407824ULL, 0x000fe200078e0207ULL, 0x000000f00f497812ULL, 0x000fc600078ec0ffULL,
0x0000000140417824ULL, 0x140fe200078e0217ULL, 0x00000004404e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001040487824ULL, 0x040fe200078e00ffULL, 0x0000000240427810ULL, 0x040fe40007ffe0ffULL,
0x0000000640507810ULL, 0x000fe20007ffe0ffULL, 0x000000014e457824ULL, 0x000fe200078e0217ULL,
0xfffffff048487812ULL, 0x000fe200078ee241ULL, 0x000000104e467824ULL, 0x000fe400078e00ffULL,
0x0000000142447824ULL, 0x000fc400078e0217ULL, 0x0000001042477824ULL, 0x000fe200078e00ffULL,
0xfffffff0464d7812ULL, 0x000fe200078ee245ULL, 0x00000100ff457424ULL, 0x000fe400078e00ffULL,
0x0000000140467824ULL, 0x100fe200078e0243ULL, 0xfffffff0474a7812ULL, 0x000fe200078ee244ULL,
0x0000000142407824ULL, 0x000fe200078e0243ULL, 0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL,
0x00005e0046467625ULL, 0x000fc800078e0045ULL, 0x000000014e427824ULL, 0x100fe200078e0243ULL,
0x0000004946467210ULL, 0x000fe20007f3e0ffULL, 0x0000000150447824ULL, 0x000fe400078e0243ULL,
0x00005e0040407625ULL, 0x000fc800078e0045ULL, 0x00005e0042427625ULL, 0x000fe200078e0045ULL,
0x0000004940407210ULL, 0x000fc60007f1e0ffULL, 0x00005e0044447625ULL, 0x000fc800078e0045ULL,
0x00000001504b7824ULL, 0x000fe200078e0217ULL, 0x0000004944447210ULL, 0x080fe20007f5e0ffULL,
0x00000010504e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff477224ULL, 0x000fe200008e0647ULL,
0x0000004942427210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff417224ULL, 0x000fe200000e0641ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee24bULL, 0x000000ffff457224ULL, 0x000fe200010e0645ULL,
0x0000e00048497811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200008e0643ULL,
0x0000e0004a4b7811ULL, 0x000fc400078e20ffULL, 0x0000e0004e4f7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046497faeULL, 0x0003e8000b901c46ULL,
0x00000000404b7faeULL, 0x0003e8000b901c46ULL, 0x00000000424d7faeULL, 0x0003e8000b901c46ULL,
0x00000000444f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff447f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106680014467f8cULL, 0x0004e4000c80043fULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x01066c0014437984ULL, 0x000f240000000800ULL,
0x8000000043ff7812ULL, 0x018fc40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240497210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004900780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404900780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004942427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01066c0014437984ULL, 0x000ee40000000800ULL, 0x8000000043ff7812ULL, 0x008fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010180000e437984ULL, 0x000ee80000000800ULL,
0x010380000e477984ULL, 0x0004620000000800ULL, 0x0000004c4300720bULL, 0x008fe20003f1d000ULL,
0x000092827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000427806ULL, 0x004fc800000e0100ULL,
0x0000ffff42ff7812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff467424ULL, 0x000fc400078e00ffULL, 0x000000ffff487224ULL, 0x000fd200078e004cULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000031800780cULL, 0x000fe40003f05270ULL,
0x0000004c4300720bULL, 0x000fe20003f34000ULL, 0x000092427f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x000fc400008e0100ULL, 0x0000004c43418209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100d407816ULL, 0x000fc600000000ffULL,
0x010580410e008388ULL, 0x0005e20000000800ULL, 0x000000ff4000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004c43417209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL,
0x0000004c410e7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL,
0x0000000e00497308ULL, 0x000ea40000000800ULL, 0x0000004912127220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff4d7819ULL, 0x000fe20000011617ULL,
0x000091827f007947ULL, 0x000fea000b800000ULL, 0x00001f4d490e7589ULL, 0x0004e400000e0000ULL,
0x0000000e3c3c7220ULL, 0x088fe20000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000e34347220ULL, 0x080fe20000410000ULL, 0x0000000e35357220ULL, 0x080fe20000410000ULL,
0x0000000e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000e20207220ULL, 0x080fe20000410000ULL, 0x0000000e21217220ULL, 0x080fe20000410000ULL,
0x0000000e28287220ULL, 0x080fe20000410000ULL, 0x0000000e29297220ULL, 0x080fe20000410000ULL,
0x0000000e24247220ULL, 0x080fe20000410000ULL, 0x0000000e25257220ULL, 0x080fe20000410000ULL,
0x0000000e30307220ULL, 0x080fe20000410000ULL, 0x0000000e31317220ULL, 0x080fe20000410000ULL,
0x0000000e38387220ULL, 0x080fe20000410000ULL, 0x0000000e39397220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008174d7811ULL, 0x006fe200078ff0ffULL,
0x000090727f007947ULL, 0x000fea000b800000ULL, 0x00001f4d490e7589ULL, 0x0002a400000e0000ULL,
0x0000000e3e3e7220ULL, 0x084fe20000410000ULL, 0x0000000e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000e36367220ULL, 0x080fe20000410000ULL, 0x0000000e37377220ULL, 0x080fe20000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000e22227220ULL, 0x080fe20000410000ULL, 0x0000000e23237220ULL, 0x080fe20000410000ULL,
0x0000000e2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000e26267220ULL, 0x080fe20000410000ULL, 0x0000000e27277220ULL, 0x080fe20000410000ULL,
0x0000000e32327220ULL, 0x080fe20000410000ULL, 0x0000000e33337220ULL, 0x080fe20000410000ULL,
0x0000000e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000e3b3b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff0dff7812ULL, 0x000fe20007800842ULL,
0x00000001ff467424ULL, 0x000fe200078e00ffULL, 0x0000004c43487209ULL, 0x000fd60007810000ULL,
0x8000004843430221ULL, 0x000fe20000010000ULL, 0x00007610ff460816ULL, 0x000fc60000000046ULL,
0x3fb8aa3b43430820ULL, 0x000fc80000410000ULL, 0x00000043000a0308ULL, 0x000ea40000000800ULL,
0x0000000a47470220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001247127221ULL, 0x002fc20000010000ULL, 0x0000000000407805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x00000042400e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000143427824ULL, 0x000fe200000e0e41ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff4200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff4200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011442ULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0642ULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910460d7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0d00720cULL, 0x000fda0003f25270ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011617ULL,
0x00005410080d7816ULL, 0x000fe20000000008ULL, 0x00008c527f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d097589ULL, 0x0002a400000e0000ULL, 0x000000080e4d7810ULL, 0x002fe20007ffe0ffULL,
0x00008c827f007947ULL, 0x000fea000b800000ULL, 0x00001f4d0d087589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e4d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x000fe200078e000dULL, 0x0000e4b000407802ULL, 0x000fc40000000f00ULL,
0x000091c000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e4d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x004fe200078e000dULL,
0x0000e50000407802ULL, 0x000fc40000000f00ULL, 0x0000917000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000064c783bULL, 0x002e620000004200ULL, 0x0000b80002027811ULL, 0x000fc400078e20ffULL,
0x0000b80000007811ULL, 0x000fe200078e20ffULL, 0x000000000554783bULL, 0x000f280000004200ULL,
0x000000000450783bULL, 0x000ee80000004200ULL, 0x000000000340783bULL, 0x000ea20000004200ULL,
0x00000018ff0d7819ULL, 0x002fe2000001144cULL, 0x000001004c597824ULL, 0x040fe200078e00ffULL,
0x000088804c587816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001144eULL, 0x000001004d5b7824ULL, 0x000fe200078e00ffULL,
0x000088804e607816ULL, 0x040fe200000000ffULL, 0x000001004e617824ULL, 0x040fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145bULL, 0x0000010054687824ULL, 0x010fe200078e00ffULL,
0x0000004c005b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff0e7819ULL, 0x000fe2000001144dULL,
0x0000010051757824ULL, 0x008fe200078e00ffULL, 0x000088804d5c7816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x004fc4000001144fULL,
0x000088804f647816ULL, 0x040fe200000000ffULL, 0x0000001f00627306ULL, 0x0005e20000200c00ULL,
0x000001004f4c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000004e00637306ULL, 0x0003e20000200c00ULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x00000018ff4b7819ULL, 0x000fe40000011454ULL,
0x00000018ff4a7819ULL, 0x000fe40000011455ULL, 0x00000018ff1f7819ULL, 0x004fe20000011450ULL,
0x0000004c00657306ULL, 0x0005e20000200c00ULL, 0x00000100554e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff477819ULL, 0x000fe40000011456ULL,
0x00000018ff4e7819ULL, 0x000fc4000001144eULL, 0x0000004d005f7306ULL, 0x0003e20000200c00ULL,
0x00008880554c7816ULL, 0x044fe200000000ffULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x00000018ff497819ULL, 0x000fe40000011457ULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000004c006b7306ULL, 0x0005e20000200c00ULL,
0x00008880544d7816ULL, 0x042fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fc40000011468ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000004f00677306ULL, 0x0003e20000200c00ULL,
0x00000100564c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011440ULL,
0x00000018ff067819ULL, 0x000fe40000011441ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000004d00697306ULL, 0x0005e20000200c00ULL, 0x00000100574f7824ULL, 0x002fe200078e00ffULL,
0x00000018ff037819ULL, 0x000fc40000011442ULL, 0x00000018ff047819ULL, 0x000fe40000011443ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000004e006c7306ULL, 0x0003e20000200c00ULL,
0x00008880564d7816ULL, 0x044fe200000000ffULL, 0x0001000056567824ULL, 0x000fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000004c006f7306ULL, 0x0005e20000200c00ULL,
0x00008880574e7816ULL, 0x042fe200000000ffULL, 0x0001000057577824ULL, 0x000fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x00000054006a7306ULL, 0x0003e20000200c00ULL,
0x00000100504c7824ULL, 0x004fce00078e00ffULL, 0x00000055006d7306ULL, 0x0005e20000200c00ULL,
0x0000888050547816ULL, 0x042fe200000000ffULL, 0x0001000050507824ULL, 0x000fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000004d006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x004fce000001144cULL, 0x0000004e00717306ULL, 0x000ff00000200c00ULL,
0x0000004f00727306ULL, 0x0003f00000200c00ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00000000024c783bULL, 0x0022ae0000000200ULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x0000888052027816ULL, 0x002fce00000000ffULL, 0x0000005c005c7306ULL, 0x000ff00000200c00ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x0000541058587816ULL, 0x008fce0000000059ULL,
0x0000005000787306ULL, 0x0007f00000200c00ULL, 0x0000000d005a7306ULL, 0x0009220000200c00ULL,
0x0000010053507824ULL, 0x008fe200078e00ffULL, 0x000054105c597816ULL, 0x002fe2000000005dULL,
0x000000094c4c9232ULL, 0x004fc40000000000ULL, 0x000000094e4e9232ULL, 0x000fe20000000000ULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x000000084d4d9232ULL, 0x080fe20000000000ULL,
0x0000000e005e7306ULL, 0x0002a20000200c00ULL, 0x00000018ff0d7819ULL, 0x010fe20000011452ULL,
0x000000084f4f9232ULL, 0x000fcc0000000000ULL, 0x0000004600667306ULL, 0x0007e20000200c00ULL,
0x00000018ff0e7819ULL, 0x002fe20000011453ULL, 0x000000584c3c723cULL, 0x000b62000000183cULL,
0x000054105b5a7816ULL, 0x000fca000000005aULL, 0x0000005600707306ULL, 0x0003e20000200c00ULL,
0x00000018ff467819ULL, 0x008fe40000011451ULL, 0x0000888041597816ULL, 0x020fe400000000ffULL,
0x0000888040587816ULL, 0x000fe400000000ffULL, 0x000054105f5b7816ULL, 0x004fe2000000005eULL,
0x0000005400737306ULL, 0x0005e20000200c00ULL, 0x0000888051567816ULL, 0x042fe200000000ffULL,
0x0001000051517824ULL, 0x000fc800078e00ffULL, 0x0000005a4c34723cULL, 0x000f620000001834ULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000005500767306ULL, 0x0003e20000200c00ULL,
0x0000010052547824ULL, 0x044fe400078e00ffULL, 0x0001000052527824ULL, 0x000fc600078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000050007e7306ULL, 0x0005e20000200c00ULL,
0x0000888053557816ULL, 0x042fe200000000ffULL, 0x0001000053537824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc80000011452ULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000005100797306ULL, 0x000fe20000200c00ULL, 0x0000010040507824ULL, 0x044fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011450ULL,
0x00000052007c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fce0000011440ULL,
0x00000053007d7306ULL, 0x0003f00000200c00ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000000000050783bULL, 0x002e6e0000000200ULL, 0x0000006100617306ULL, 0x000eb00000200c00ULL,
0x0000006400647306ULL, 0x000ef00000200c00ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000541060607816ULL, 0x004fce0000000061ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x0000541064617816ULL, 0x008fce0000000065ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000000604c2c723cULL, 0x000b62000000182cULL, 0x0000000950509232ULL, 0x082fe40000000000ULL,
0x0000000952529232ULL, 0x000fe40000000000ULL, 0x0000000851519232ULL, 0x080fe40000000000ULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x000054106d5d7816ULL, 0x004fe2000000004aULL,
0x0000000853539232ULL, 0x000fe20000000000ULL, 0x000054106e607816ULL, 0x020fc4000000006fULL,
0x0000541071617816ULL, 0x000fc60000000072ULL, 0x0000004900497306ULL, 0x000ff00000200c00ULL,
0x0000005700747306ULL, 0x000ea20000200c00ULL, 0x0000541070707816ULL, 0x002fce0000000047ULL,
0x00000075007a7306ULL, 0x000ff00000200c00ULL, 0x0000005400757306ULL, 0x0003e20000200c00ULL,
0x0000541074717816ULL, 0x004fce0000000049ULL, 0x00000055007b7306ULL, 0x0005e20000200c00ULL,
0x0000541063547816ULL, 0x002fe40000000062ULL, 0x000000604c60723cULL, 0x000bea0000001830ULL,
0x0000005600777306ULL, 0x0002e20000200c00ULL, 0x0000541067557816ULL, 0x004fe40000000066ULL,
0x0000888043307816ULL, 0x020fca00000000ffULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x000000544c54723cULL, 0x002bee0000001820ULL, 0x0000005c00647306ULL, 0x0003e20000200c00ULL,
0x000000ffff207224ULL, 0x020fe200078e0059ULL, 0x000054106b597816ULL, 0x000fe2000000006cULL,
0x0000010041217824ULL, 0x000fc400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x00000058007f7306ULL, 0x0005e20000200c00ULL, 0x000054106a5c7816ULL, 0x002fe4000000004bULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff417819ULL, 0x000fc60000011441ULL,
0x0000002000657306ULL, 0x0003e20000200c00ULL, 0x0000541069587816ULL, 0x004fe20000000068ULL,
0x0000005c4c5c723cULL, 0x040bec0000001824ULL, 0x0000002100007306ULL, 0x0007e20000200c00ULL,
0x0000010042207824ULL, 0x042fe200078e00ffULL, 0x000000584c58723cULL, 0x000b640000001828ULL,
0x0000888042247816ULL, 0x060fe200000000ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x0000004600467306ULL, 0x000e620000200c00ULL, 0x0000010043297824ULL, 0x040fe200078e00ffULL,
0x000000704c4c723cULL, 0x000b620000001838ULL, 0x00000018ff287819ULL, 0x000fe20000011420ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x0000541073207816ULL, 0x000fe40000000076ULL,
0x0000541077217816ULL, 0x008fe2000000007aULL, 0x0000000200027306ULL, 0x000ea20000200c00ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff437819ULL, 0x000fc60000011443ULL,
0x000000205020723cULL, 0x000f64000000183cULL, 0x0000002400387306ULL, 0x0207e20000200c00ULL,
0x0000541079257816ULL, 0x002fce0000000046ULL, 0x0000002800397306ULL, 0x0004620000200c00ULL,
0x0000541078247816ULL, 0x008fe4000000001fULL, 0x00000018ff1f7819ULL, 0x000fe40000011429ULL,
0x000054107b297816ULL, 0x000fc6000000007eULL, 0x0000000d000d7306ULL, 0x000fe20000200c00ULL,
0x0000541002287816ULL, 0x004fe20000000075ULL, 0x000000245024723cULL, 0x040f6c0000001834ULL,
0x0000000e000e7306ULL, 0x000ea20000200c00ULL, 0x0000541038387816ULL, 0x002fe20000000039ULL,
0x000000285028723cULL, 0x000b6c000000182cULL, 0x0000000500057306ULL, 0x000fe20000200c00ULL,
0x000054107f2c7816ULL, 0x020fc40000000064ULL, 0x00005410652d7816ULL, 0x000fca0000000000ULL,
0x0000000600067306ULL, 0x000fe20000200c00ULL, 0x000054107d317816ULL, 0x004fe2000000000eULL,
0x0000002c502c723cULL, 0x000b6c0000001858ULL, 0x0000000300037306ULL, 0x000ff00000200c00ULL,
0x0000000400047306ULL, 0x000ff00000200c00ULL, 0x0000004000407306ULL, 0x000e700000200c00ULL,
0x0000004100417306ULL, 0x000eb00000200c00ULL, 0x00000030003a7306ULL, 0x0007e20000200c00ULL,
0x0000541040347816ULL, 0x002fce0000000005ULL, 0x0000001f001f7306ULL, 0x000e620000200c00ULL,
0x000054107c307816ULL, 0x008fe4000000000dULL, 0x0000541041357816ULL, 0x004fca0000000006ULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x000000305030723cULL, 0x040b6e0000001854ULL,
0x00000043003d7306ULL, 0x000ee20000200c00ULL, 0x000054103a397816ULL, 0x002fe2000000001fULL,
0x000000345034723cULL, 0x000b62000000185cULL, 0x00005410423c7816ULL, 0x004fce0000000003ULL,
0x000000385038723cULL, 0x000b620000001860ULL, 0x000054103d3d7816ULL, 0x008fce0000000004ULL,
0x0000003c503c723cULL, 0x000b62000000184cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff407f8cULL, 0x000e62000c80043fULL, 0x000000ffff067224ULL, 0x000fce00078e00ffULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x0106bc00ff057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x006fe40007804841ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x00000004020d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000d00007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000211037810ULL, 0x000fe40007ffe0ffULL, 0x000000e010107810ULL, 0x000fe40007ffe0ffULL,
0x000000160300720cULL, 0x000fc60003f06070ULL, 0x00006200130d7a24ULL, 0x000fd400078e0210ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x0000000407477810ULL, 0x040fe20007ffe0ffULL,
0x0000000114027824ULL, 0x040fe200078e0207ULL, 0x0000000207437810ULL, 0x000fe40007ffe0ffULL,
0x0000001015007217ULL, 0x000fe20007800000ULL, 0x00000001140e7824ULL, 0x040fe200078e0247ULL,
0x0000000607497810ULL, 0x000fe20007ffe0ffULL, 0x0000000114067824ULL, 0x000fe400078e0243ULL,
0x000000010e1f7824ULL, 0x040fe400078e0217ULL, 0x000000100e427824ULL, 0x000fc400078e00ffULL,
0x0000000106057824ULL, 0x040fe400078e0217ULL, 0x0000001006407824ULL, 0x000fe200078e00ffULL,
0xfffffff042427812ULL, 0x000fe200078ee21fULL, 0x0000000100037824ULL, 0x000fe400078e0a10ULL,
0x0000000102047824ULL, 0x000fe200078e0217ULL, 0xfffffff040407812ULL, 0x000fe200078ee205ULL,
0x0000001002417824ULL, 0x000fe200078e00ffULL, 0x0000000314057217ULL, 0x000fe20007800000ULL,
0x00000100ff1f7424ULL, 0x000fc400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e020dULL,
0xfffffff041107812ULL, 0x000fe200078ee204ULL, 0x0000000114007824ULL, 0x000fe200078e0249ULL,
0x000000f00f417812ULL, 0x000fe200078ec0ffULL, 0x0000000106047824ULL, 0x000fe400078e020dULL,
0x00005e0002027625ULL, 0x000fc800078e001fULL, 0x000000010e067824ULL, 0x100fe200078e020dULL,
0x00000041020e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001000d7824ULL, 0x040fe400078e020dULL,
0x00000001000f7824ULL, 0x040fe400078e0217ULL, 0x0000001000467824ULL, 0x000fe400078e00ffULL,
0x0000000105007824ULL, 0x000fe400078e0a14ULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0xfffffff046467812ULL, 0x000fc400078ee20fULL, 0x000000000700720cULL, 0x080fe20003f66070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e0603ULL, 0x0000004104047210ULL, 0x000fe20007f9e0ffULL,
0x00005e0006027625ULL, 0x080fe200078e001fULL, 0x000000004300720cULL, 0x080fe40003f46070ULL,
0x000000004700720cULL, 0x080fe20003f06070ULL, 0x00005e000d067625ULL, 0x000fe200078e001fULL,
0x0000004102027210ULL, 0x080fe40007fbe0ffULL, 0x0000c000100d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200020e0605ULL, 0x000000004900720cULL, 0x000fe20003f86070ULL,
0x000000ffff037224ULL, 0x000fe200028e0603ULL, 0x0000004106067210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e2000d901c46ULL,
0x0000c000401f7811ULL, 0x000fc400078e20ffULL, 0x0000c00042417811ULL, 0x000fe200078e20ffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000c00046437811ULL, 0x000fe200078e20ffULL,
0x00000000041f7faeULL, 0x0003e8000d101c46ULL, 0x0000000002417faeULL, 0x0003e8000c101c46ULL,
0x0000000006437faeULL, 0x0003e2000e101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000114007824ULL, 0x000fe200078e0207ULL, 0x000000f00f1f7812ULL, 0x000fc600078ec0ffULL,
0x0000000100027824ULL, 0x040fe200078e0217ULL, 0x0000000400067810ULL, 0x040fe20007ffe0ffULL,
0x0000001000077824ULL, 0x040fe200078e00ffULL, 0x0000000200047810ULL, 0x000fc60007ffe0ffULL,
0x0000000106057824ULL, 0x140fe200078e0217ULL, 0xfffffff007107812ULL, 0x000fe200078ee202ULL,
0x00000010060e7824ULL, 0x000fe400078e00ffULL, 0x00000100ff077424ULL, 0x000fe400078e00ffULL,
0x0000000104037824ULL, 0x000fe200078e0217ULL, 0xfffffff00e417812ULL, 0x000fe200078ee205ULL,
0x00000001000e7824ULL, 0x040fe200078e020dULL, 0x0000000600007810ULL, 0x000fe20007ffe0ffULL,
0x0000001004407824ULL, 0x000fe200078e00ffULL, 0x0000c00041417811ULL, 0x000fe200078e20ffULL,
0x00005e000e0e7625ULL, 0x000fc600078e0007ULL, 0xfffffff040407812ULL, 0x000fe200078ee203ULL,
0x0000000104027824ULL, 0x100fe200078e020dULL, 0x0000001f0e0e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000106047824ULL, 0x100fe400078e020dULL, 0x0000000100067824ULL, 0x000fe400078e020dULL,
0x00005e0002027625ULL, 0x000fc800078e0007ULL, 0x00005e0004047625ULL, 0x000fe200078e0007ULL,
0x0000001f02027210ULL, 0x000fc60007f1e0ffULL, 0x00000001000d7824ULL, 0x000fe400078e0217ULL,
0x00005e0006067625ULL, 0x000fc800078e0007ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x0000001f06067210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x0000001f04047210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0xfffffff000007812ULL, 0x000fe200078ee20dULL, 0x000000ffff077224ULL, 0x000fe200018e0607ULL,
0x0000c000100d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000c000401f7811ULL, 0x000fe400078e20ffULL, 0x0000c00000437811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e8000b901c46ULL,
0x00000000021f7faeULL, 0x0003e8000b901c46ULL, 0x0000000004417faeULL, 0x0003e8000b901c46ULL,
0x0000000006437faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff027f8cULL, 0x002e64000c80043fULL,
0x000000ffff1f7224ULL, 0x002fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x0106b400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x0000000aff00723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe40000011617ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000071827f007947ULL, 0x000fea000b800000ULL,
0x00001f0300097589ULL, 0x0002a400000e0000ULL, 0x00000008034d7810ULL, 0x022fe20007ffe0ffULL,
0x000071b27f007947ULL, 0x000fea000b800000ULL, 0x00001f4d00087589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010034d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x000fe200078e0000ULL, 0x0001003000407802ULL, 0x000fc40000000f00ULL,
0x0000764000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018034d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x004fe200078e0000ULL,
0x0001008000407802ULL, 0x000fc40000000f00ULL, 0x000075f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001b0c783bULL, 0x002e620000004200ULL, 0x0000b8001e1e7811ULL, 0x000fc600078e20ffULL,
0x000000001c44783bULL, 0x004ea80000004200ULL, 0x000000001940783bULL, 0x0008e80000004200ULL,
0x000000001a04783bULL, 0x0003e40000004200ULL, 0x00000018ff007819ULL, 0x002fe2000001140cULL,
0x000001000c4b7824ULL, 0x040fe200078e00ffULL, 0x000088800c4a7816ULL, 0x040fe200000000ffULL,
0x000100000c0c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fe2000001140dULL,
0x000001000d4d7824ULL, 0x060fe200078e00ffULL, 0x00000018ff037819ULL, 0x000fe2000001140eULL,
0x000001000e537824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x00000100445a7824ULL, 0x004fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144dULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x000088800d4e7816ULL, 0x040fe200000000ffULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x000088800e527816ULL, 0x040fe200000000ffULL,
0x000100000e0e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x000fc4000001140fULL,
0x000088800f567816ULL, 0x040fe200000000ffULL, 0x0000000c004d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x00000018ff107819ULL, 0x000fe40000011444ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000000d00517306ULL, 0x0005e20000200c00ULL, 0x000001000f0c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff197819ULL, 0x010fe20000011445ULL, 0x000100000f0f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1b7819ULL, 0x008fc40000011440ULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x0000000e00557306ULL, 0x0003e20000200c00ULL, 0x00000018ff0f7819ULL, 0x000fe4000001140fULL,
0x00008880440d7816ULL, 0x044fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe40000011446ULL, 0x00000018ff1a7819ULL, 0x000fe20000011441ULL,
0x0000000c00577306ULL, 0x0005e20000200c00ULL, 0x00000100450e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fc40000011444ULL, 0x00000018ff497819ULL, 0x000fe40000011447ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x0000000f00597306ULL, 0x0003e20000200c00ULL,
0x00008880450c7816ULL, 0x044fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000000c005e7306ULL, 0x0005e20000200c00ULL,
0x00000100470f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe4000001140fULL,
0x0000000d005b7306ULL, 0x0003e20000200c00ULL, 0x00000100460c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000000e005f7306ULL, 0x0005e20000200c00ULL,
0x00008880460d7816ULL, 0x042fe200000000ffULL, 0x0001000046467824ULL, 0x000fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000000d00627306ULL, 0x0003e20000200c00ULL,
0x00008880470e7816ULL, 0x044fe200000000ffULL, 0x0001000047477824ULL, 0x000fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000000c00637306ULL, 0x0004e20000200c00ULL,
0x00000100400d7824ULL, 0x002fce00078e00ffULL, 0x0000000e00647306ULL, 0x000fe20000200c00ULL,
0x0000b8001d0c7811ULL, 0x004fe400078e20ffULL, 0x00000018ff1d7819ULL, 0x000fca000001140dULL,
0x0000000f00677306ULL, 0x0002a20000200c00ULL, 0x0000541062627816ULL, 0x008fce0000000063ULL,
0x00000044005d7306ULL, 0x0007e20000200c00ULL, 0x000000000c0c783bULL, 0x002e6e0000000200ULL,
0x0000004b004b7306ULL, 0x000f220000200c00ULL, 0x0000888040447816ULL, 0x048fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x0000541064637816ULL, 0x004fc80000000067ULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x000054104a4a7816ULL, 0x010fce000000004bULL,
0x0000004500617306ULL, 0x0007f00000200c00ULL, 0x00000040006a7306ULL, 0x0009e20000200c00ULL,
0x0000888041457816ULL, 0x008fe200000000ffULL, 0x000000090c0c9232ULL, 0x082fe20000000000ULL,
0x000054104e4b7816ULL, 0x004fe2000000004fULL, 0x000000090e0e9232ULL, 0x000fc40000000000ULL,
0x000000080d0d9232ULL, 0x080fe40000000000ULL, 0x00000010005c7306ULL, 0x0003e20000200c00ULL,
0x0000010043407824ULL, 0x010fe200078e00ffULL, 0x000000080f0f9232ULL, 0x000fc80000000000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000001900607306ULL, 0x0005e20000200c00ULL,
0x00000018ff107819ULL, 0x002fe20000011442ULL, 0x0000004a0c20723cULL, 0x040b6c0000001820ULL,
0x0000004600657306ULL, 0x0003e20000200c00ULL, 0x00000018ff197819ULL, 0x004fe20000011443ULL,
0x000000620c38723cULL, 0x000fec0000001838ULL, 0x0000004400687306ULL, 0x0005e20000200c00ULL,
0x0000010041467824ULL, 0x002fc400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000001d00697306ULL, 0x0003e20000200c00ULL,
0x0000010042447824ULL, 0x004fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc80000011441ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000045006b7306ULL, 0x0005e20000200c00ULL,
0x00008880421d7816ULL, 0x042fe200000000ffULL, 0x0001000042427824ULL, 0x000fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000004000737306ULL, 0x0003e20000200c00ULL,
0x0000888043457816ULL, 0x044fe200000000ffULL, 0x0001000043437824ULL, 0x000fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x00000041006d7306ULL, 0x000fe20000200c00ULL,
0x0000010004407824ULL, 0x002fca00078e00ffULL, 0x00000018ff4b7819ULL, 0x020fe40000011440ULL,
0x0000004200717306ULL, 0x000ff00000200c00ULL, 0x00000043004a7306ULL, 0x0003f00000200c00ULL,
0x00000000004c7306ULL, 0x0004e20000200c00ULL, 0x000000001e40783bULL, 0x002e6e0000000200ULL,
0x0000000200507306ULL, 0x0009220000200c00ULL, 0x00000018ff007819ULL, 0x004fce0000011406ULL,
0x0000000300547306ULL, 0x0004a20000200c00ULL, 0x000054104d4c7816ULL, 0x008fe4000000004cULL,
0x00000018ff027819ULL, 0x010fca0000011407ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x00005410514d7816ULL, 0x000fe40000000050ULL, 0x00000018ff037819ULL, 0x004fca0000011404ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000004c0c24723cULL, 0x000be20000001824ULL,
0x0000541055547816ULL, 0x000fcc0000000054ULL, 0x0000000b00587306ULL, 0x0007220000200c00ULL,
0x00000100054c7824ULL, 0x020fe200078e00ffULL, 0x00005410614d7816ULL, 0x000fe20000000060ULL,
0x0000000940409232ULL, 0x082fe40000000000ULL, 0x0000000942429232ULL, 0x000fe20000000000ULL,
0x00000018ff1e7819ULL, 0x000fe2000001144cULL, 0x0000000841419232ULL, 0x080fe20000000000ULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x0000541052527816ULL, 0x004fe20000000053ULL,
0x0000000843439232ULL, 0x000fe20000000000ULL, 0x000054105d4c7816ULL, 0x000fc4000000005cULL,
0x00000018ff0b7819ULL, 0x008fc60000011405ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541059557816ULL, 0x010fe20000000058ULL, 0x0000004c0c4c723cULL, 0x040fec0000001834ULL,
0x0000001c001c7306ULL, 0x000ea20000200c00ULL, 0x0000541056537816ULL, 0x002fe20000000057ULL,
0x000000540c30723cULL, 0x040f6c0000001830ULL, 0x0000004900497306ULL, 0x000fe40000200c00ULL,
0x000000520c28723cULL, 0x000f6c0000001828ULL, 0x0000004700667306ULL, 0x000e620000200c00ULL,
0x00005410651c7816ULL, 0x004fce000000001cULL, 0x0000001d006e7306ULL, 0x0005f00000200c00ULL,
0x00000046006c7306ULL, 0x000fe20000200c00ULL, 0x00008880041d7816ULL, 0x044fe200000000ffULL,
0x0001000004047824ULL, 0x000fca00078e00ffULL, 0x00000018ff047819ULL, 0x000fe20000011404ULL,
0x0000001d00507306ULL, 0x0005f00000200c00ULL, 0x00000044006f7306ULL, 0x0007e20000200c00ULL,
0x00008880051d7816ULL, 0x044fe200000000ffULL, 0x0001000005057824ULL, 0x000fca00078e00ffULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x0000004500707306ULL, 0x0005220000200c00ULL,
0x000054105b447816ULL, 0x008fce000000005aULL, 0x0000001d00517306ULL, 0x0003e20000200c00ULL,
0x000054105e457816ULL, 0x004fce000000005fULL, 0x0000001a001a7306ULL, 0x000ea20000200c00ULL,
0x00005410661d7816ULL, 0x002fe20000000049ULL, 0x000000440c44723cULL, 0x040b6c000000182cULL,
0x0000001900197306ULL, 0x000e620000200c00ULL, 0x00008880062c7816ULL, 0x020fe200000000ffULL,
0x0000001c0c0c723cULL, 0x000b62000000183cULL, 0x00005410702d7816ULL, 0x010fca0000000073ULL,
0x0000000500527306ULL, 0x0007e20000200c00ULL, 0x00005410683c7816ULL, 0x020fe20000000069ULL,
0x00000100061c7824ULL, 0x040fe200078e00ffULL, 0x000054106b3d7816ULL, 0x000fe2000000006cULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x000054106d357816ULL, 0x004fe4000000001aULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001000107306ULL, 0x000ea20000200c00ULL,
0x0000888007057816ULL, 0x008fe200000000ffULL, 0x0000003c403c723cULL, 0x000b620000001820ULL,
0x00000018ff067819ULL, 0x000fca0000011406ULL, 0x0000000500497306ULL, 0x0007e20000200c00ULL,
0x0000010007207824ULL, 0x020fe200078e00ffULL, 0x000054104a217816ULL, 0x002fc80000000019ULL,
0x00000018ff1a7819ULL, 0x000fe40000011420ULL, 0x0000002c001d7306ULL, 0x0003e20000200c00ULL,
0x0001000007057824ULL, 0x008fe200078e00ffULL, 0x0000541071207816ULL, 0x004fc80000000010ULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000001c001c7306ULL, 0x000ea20000200c00ULL,
0x000054106e2c7816ULL, 0x002fe2000000006fULL, 0x000000204020723cULL, 0x040f6c0000001830ULL,
0x0000001a001a7306ULL, 0x000e640000200c00ULL, 0x0000002c402c723cULL, 0x000b6c0000001828ULL,
0x0000001b001b7306ULL, 0x000ee20000200c00ULL, 0x000054101d1c7816ULL, 0x004fce000000001cULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x00005410491d7816ULL, 0x002fce000000001aULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x000054106a347816ULL, 0x008fe2000000001bULL,
0x0000001c4030723cULL, 0x040b6c0000001838ULL, 0x0000000000007306ULL, 0x000fe40000200c00ULL,
0x000000344034723cULL, 0x000b6c0000001824ULL, 0x0000000200027306ULL, 0x000ff00000200c00ULL,
0x0000004b004b7306ULL, 0x000e700000200c00ULL, 0x0000001e001e7306ULL, 0x000eb00000200c00ULL,
0x0000000400047306ULL, 0x000ee20000200c00ULL, 0x0000541050287816ULL, 0x022fce000000004bULL,
0x0000000600077306ULL, 0x000e620000200c00ULL, 0x0000541051297816ULL, 0x004fce000000001eULL,
0x0000000500197306ULL, 0x0005220000200c00ULL, 0x0000541004047816ULL, 0x008fe20000000003ULL,
0x000000284028723cULL, 0x000b620000001844ULL, 0x0000541007387816ULL, 0x002fe40000000000ULL,
0x0000541052057816ULL, 0x004fe4000000000bULL, 0x0000541019397816ULL, 0x010fca0000000002ULL,
0x000000044024723cULL, 0x040b70000000184cULL, 0x000000384038723cULL, 0x000b62000000180cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff027f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff447224ULL, 0x022fc600078e0003ULL,
0x0000000111117810ULL, 0x000fc80007ffe0ffULL, 0x000000161100720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffeffc000007947ULL, 0x000fea000383ffffULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x0000036000008947ULL, 0x000fea0003800000ULL,
0x0180000012007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0001105000047802ULL, 0x000fc40000000f00ULL,
0x0000646000007944ULL, 0x006fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001200037308ULL, 0x002e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000012ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x01cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000003c043c7220ULL, 0x042fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x000fe20000410000ULL,
0x0000003e053e7220ULL, 0x044fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x000fc20000410000ULL,
0x0000000000127919ULL, 0x000ee20000000000ULL, 0x0000a00018187811ULL, 0x000fe200078e58ffULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff037819ULL, 0x00afc40000011612ULL, 0x0000000212007812ULL, 0x040fe200078ec0ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x0000000812077811ULL, 0x000fe200078ff0ffULL,
0x00000008030d7824ULL, 0x040fe200078e00ffULL, 0x0000000300027211ULL, 0x040fe200078ff8ffULL,
0x0000000803097824ULL, 0x000fe200078e00ffULL, 0x0000000700057211ULL, 0x000fe200078ff8ffULL,
0x0000000807067824ULL, 0x000fe200078e00ffULL, 0x0000000402047810ULL, 0x040fe20007ffe0ffULL,
0x00000008030b7824ULL, 0x040fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe20007ffe0ffULL,
0x00000008030f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d077812ULL, 0x000fe200078ee204ULL,
0x0000000812047824ULL, 0x000fe200078e00ffULL, 0xfffffff809037812ULL, 0x000fc400078ee202ULL,
0x0000000602027810ULL, 0x000fe40007ffe0ffULL, 0xfffffff806097812ULL, 0x000fe200078ee205ULL,
0x0000001003037824ULL, 0x000fe200078e0218ULL, 0x0000002012107810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80b057812ULL, 0x000fe200078ee200ULL, 0x00000010090d7824ULL, 0x000fe200078e0218ULL,
0xfffffff80f0b7812ULL, 0x000fe200078ee202ULL, 0x0000001007097824ULL, 0x100fe200078e0218ULL,
0x0000000804047812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x100fe200078e0218ULL,
0x0000003c3d00723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0218ULL,
0x000000343502723eULL, 0x000fe200000000ffULL, 0x0000000103037824ULL, 0x000fe200078e0204ULL,
0x00000003ff087819ULL, 0x000fe20000011612ULL, 0x0000000104077824ULL, 0x040fe200078e0205ULL,
0x00000003ff117819ULL, 0x000fe20000011610ULL, 0x00000001040d7824ULL, 0x000fe200078e020dULL,
0x00005410000e7816ULL, 0x100fe20000000002ULL, 0x0000000104097824ULL, 0x000fe200078e0209ULL,
0x00007632000f7816ULL, 0x000fe20000000002ULL, 0x0000000108007824ULL, 0x000fe200078e0212ULL,
0x000000222306723eULL, 0x000fe200000000ffULL, 0x0000000110027824ULL, 0x000fc400078e0211ULL,
0x0000000e03007388ULL, 0x0003e20000000a00ULL, 0x00000001040b7824ULL, 0x000fe200078e020bULL,
0x000000242504723eULL, 0x000fe400000000ffULL, 0x0000000700037812ULL, 0x002fe400078ec0ffULL,
0x00000007020f7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803057812ULL, 0x000fe400078ef812ULL,
0x0ffffff80f0f7812ULL, 0x000fc400078ef810ULL, 0x0000002c2d00723eULL, 0x000fe200000000ffULL,
0x00000010050a7824ULL, 0x100fe200078e0218ULL, 0x000000202102723eULL, 0x000fe200000000ffULL,
0x000000100f187824ULL, 0x000fe200078e0218ULL, 0x000000282903723eULL, 0x000fe400000000ffULL,
0x00005410000e7816ULL, 0x140fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x000000303100723eULL, 0x000fc400000000ffULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x0000000e07007388ULL, 0x0003e20000000a00ULL, 0x0000002e2f05723eULL, 0x000fc800000000ffULL,
0x00005410050c7816ULL, 0x000fe40000000006ULL, 0x00005410030e7816ULL, 0x142fe40000000004ULL,
0x00007632030f7816ULL, 0x000fe40000000004ULL, 0x0000003e3f03723eULL, 0x000fe400000000ffULL,
0x000000363704723eULL, 0x000fe200000000ffULL, 0x0000000e09007388ULL, 0x0003e40000000a00ULL,
0x00005410000e7816ULL, 0x002fc40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000002a2b00723eULL, 0x000fe400000000ffULL, 0x000000262702723eULL, 0x000fe200000000ffULL,
0x0000000e0b007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x142fe40000000004ULL,
0x00007632030f7816ULL, 0x000fe40000000004ULL, 0x000000323303723eULL, 0x000fc400000000ffULL,
0x0000003a3b04723eULL, 0x000fe200000000ffULL, 0x0000000e0d007388ULL, 0x0003e40000000a00ULL,
0x00007632050d7816ULL, 0x002fe40000000006ULL, 0x0000000000057919ULL, 0x000e620000002600ULL,
0x0000541000067816ULL, 0x000fc60000000002ULL, 0x0004000c07007388ULL, 0x0007e40000000a00ULL,
0x0000763200077816ULL, 0x008fe40000000002ULL, 0x0000541003027816ULL, 0x140fe40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004000609007388ULL, 0x0007e20000000a00ULL,
0x0000000805137824ULL, 0x002fc600078e00ffULL, 0x000400020b007388ULL, 0x0003e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000000a0c7984ULL, 0x000f220000000c00ULL,
0x0000000805007824ULL, 0x000fe200078e00ffULL, 0xfffffff813087812ULL, 0x000fe400078ee208ULL,
0x0000000018187984ULL, 0x000ea20000000c00ULL, 0x0000000712077812ULL, 0x008fe400078ec0ffULL,
0xfffffff800117812ULL, 0x000fe400078ee211ULL, 0x0000000408087c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000411117c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000710097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x002fe200000e06ffULL, 0x00005a0008027a11ULL, 0x040fe200078048ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0011047a11ULL, 0x000fe400078248ffULL,
0x00005b0008037a11ULL, 0x000fe400000f4c03ULL, 0x1ffffff807077812ULL, 0x000fe400078ef814ULL,
0x00005b0011057a11ULL, 0x000fc400008f4c00ULL, 0x1ffffff809097812ULL, 0x000fe200078ef814ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001009047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x010fe8000c101d06ULL, 0x0000001804007986ULL, 0x004fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff027624ULL, 0x000fe400078e00ffULL,
0x00006700ff037624ULL, 0x000fca00078e00ffULL, 0x0000000602207981ULL, 0x000322000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000000210037824ULL, 0x002fe200078e00ffULL, 0x01060000ff047f8cULL, 0x000e62000c80043fULL,
0x0000004018007824ULL, 0x000fe400078e00ffULL, 0x0000580003037a24ULL, 0x000fc800078e0212ULL,
0x0000620003027a24ULL, 0x000fc800078e0200ULL, 0x000005a000000947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x000fe20000011617ULL, 0x00000100ff257424ULL, 0x000fe200078e00ffULL,
0x000000300c237812ULL, 0x000fe400078ec0ffULL, 0x0000000821137810ULL, 0x040fe20007ffe0ffULL,
0x0000000102067824ULL, 0x040fe200078e0221ULL, 0x0000001021277810ULL, 0x040fe40007ffe0ffULL,
0x0000001821297810ULL, 0x040fe20007ffe0ffULL, 0x0000000102087824ULL, 0x000fe200078e0213ULL,
0x0000002021197810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0025ULL,
0x00000000150f7217ULL, 0x000fc40007800000ULL, 0x0000001717127211ULL, 0x000fe200078fe8ffULL,
0x00005e0008087625ULL, 0x000fe200078e0025ULL, 0x00000023060a7210ULL, 0x080fe40007f1e0ffULL,
0x00000028211d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001020e7824ULL, 0x000fe200078e0227ULL,
0x00000023080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000102087824ULL, 0x000fe200078e0229ULL,
0x0000000312147812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x00002000181c7811ULL, 0x000fe200078e68ffULL, 0x00005e000e067625ULL, 0x000fe200078e0025ULL,
0x0ffffffc14177812ULL, 0x000fc400078ef817ULL, 0x00000030211f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e0609ULL, 0x00000023060e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0008087625ULL, 0x000fc800078e0025ULL, 0x0000000102067824ULL, 0x000fe200078e0219ULL,
0x0000002308107210ULL, 0x000fe20007f3e0ffULL, 0x000000010f087824ULL, 0x000fe400078e0a00ULL,
0x000000ffff0f7224ULL, 0x000fe400000e0607ULL, 0x00005e0006067625ULL, 0x000fe200078e0025ULL,
0x000000082100720cULL, 0x0c0fe40003f06070ULL, 0x0000003821217810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0609ULL, 0x0000002306127210ULL, 0x000fe20007f5e0ffULL,
0x0000000413097824ULL, 0x040fe200078e00ffULL, 0x000000081300720cULL, 0x080fe20003f26070ULL,
0x0000000102067824ULL, 0x000fe200078e021dULL, 0x000000082700720cULL, 0x080fe20003fa6070ULL,
0x000000ffff137224ULL, 0x000fe200010e0607ULL, 0xfffffffc09097812ULL, 0x000fe200078ee214ULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x000000082900720cULL, 0x000fc40003f86070ULL,
0x000000081900720cULL, 0x080fe20003f66070ULL, 0x0000001017177824ULL, 0x100fe200078e021cULL,
0x00000023061a7210ULL, 0x000fe20007fde0ffULL, 0x0000001009097824ULL, 0x000fe200078e021cULL,
0x000000081d00720cULL, 0x080fe20003f46070ULL, 0x0000000102067824ULL, 0x000fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a177faeULL, 0x0005e2000c101c46ULL,
0x000000ffff1b7224ULL, 0x000fe200030e0607ULL, 0x000000082100720cULL, 0x080fe20003f06070ULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x000000000c097faeULL, 0x0007e2000c901c46ULL,
0x000000081f00720cULL, 0x000fc40003f26070ULL, 0x0000000102087824ULL, 0x000fe200078e0221ULL,
0x0000002306067210ULL, 0x000fe20007fde0ffULL, 0x00000004270b7824ULL, 0x004fe400078e00ffULL,
0x0000000419177824ULL, 0x000fe400078e00ffULL, 0x00000004290d7824ULL, 0x008fe200078e00ffULL,
0xfffffffc0b0b7812ULL, 0x100fe200078ee214ULL, 0x000000041d197824ULL, 0x000fe200078e00ffULL,
0xfffffffc17177812ULL, 0x100fe200078ee214ULL, 0x000000041f1d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0d0d7812ULL, 0x100fe200078ee214ULL, 0x00000004211f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc19197812ULL, 0x100fe200078ee214ULL, 0x00005e0008087625ULL, 0x000fe200078e0025ULL,
0xfffffffc1d1d7812ULL, 0x000fc400078ee214ULL, 0xfffffffc1f1f7812ULL, 0x000fe200078ee214ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000002308087210ULL, 0x000fe20007fde0ffULL,
0x000000100b0b7824ULL, 0x100fe400078e021cULL, 0x000000100d0d7824ULL, 0x100fe400078e021cULL,
0x0000001017177824ULL, 0x100fe200078e021cULL, 0x000000000e0b7faeULL, 0x0005e2000e901c46ULL,
0x0000001019197824ULL, 0x100fe400078e021cULL, 0x000000101d1d7824ULL, 0x100fe200078e021cULL,
0x00000000100d7faeULL, 0x0005e2000e101c46ULL, 0x000000101f1f7824ULL, 0x000fc400078e021cULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000000012177faeULL, 0x0005e8000d901c46ULL,
0x000000001a197faeULL, 0x0005e8000d101c46ULL, 0x00000000061d7faeULL, 0x0005e8000c901c46ULL,
0x00000000081f7faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x0000001717087211ULL, 0x040fe200078fe8ffULL, 0x00000100ff277424ULL, 0x000fe200078e00ffULL,
0x0000000817097811ULL, 0x000fc400078ff0ffULL, 0x0000001017077811ULL, 0x040fe400078ff0ffULL,
0x0000000217067211ULL, 0x000fe200078ff0ffULL, 0x0000000409197824ULL, 0x000fe200078e00ffULL,
0x00000003081a7812ULL, 0x000fe200078ec0ffULL, 0x0000000102087824ULL, 0x040fe200078e0209ULL,
0x0000003017117811ULL, 0x040fe200078ff0ffULL, 0x0000000102097824ULL, 0x000fe200078e0207ULL,
0x00000028170f7811ULL, 0x000fe200078ff0ffULL, 0x00000004071b7824ULL, 0x000fe200078e00ffULL,
0x000000300c297812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0x0000003817137811ULL, 0x000fc400078ff0ffULL, 0x00000018170b7811ULL, 0x000fe200078ff0ffULL,
0x00000001021c7824ULL, 0x000fe200078e0211ULL, 0x0000002906107210ULL, 0x000fe20007f1e0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x00000020170d7811ULL, 0x000fe200078ff0ffULL,
0x000000040f1f7824ULL, 0x000fe200078e00ffULL, 0x0000200018227811ULL, 0x000fe200078e68ffULL,
0x00000001021e7824ULL, 0x040fe200078e0213ULL, 0xfffffffc1b0c7812ULL, 0x100fe200078ee21aULL,
0x0000000413217824ULL, 0x000fe200078e00ffULL, 0xfffffffc11137812ULL, 0x100fe200078ee21aULL,
0x00000001020a7824ULL, 0x000fe200078e020bULL, 0xfffffffc1f127812ULL, 0x100fe200078ee21aULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0xfffffffc211b7812ULL, 0x000fe200078ee21aULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc1a177812ULL, 0x000fe200078ef817ULL,
0x00005e0008067625ULL, 0x000fc800078e0027ULL, 0x000000040d1d7824ULL, 0x000fe400078e00ffULL,
0x00005e0009087625ULL, 0x000fc800078e0027ULL, 0x00000001020e7824ULL, 0x000fe200078e020dULL,
0xfffffffc0b0d7812ULL, 0x000fe200078ee21aULL, 0x0000001012217824ULL, 0x000fe200078e0222ULL,
0x0000002906127210ULL, 0x000fe20007f1e0ffULL, 0x0000000102147824ULL, 0x000fe200078e020fULL,
0xfffffffc19027812ULL, 0x100fe200078ee21aULL, 0x00005e000a0a7625ULL, 0x000fe200078e0027ULL,
0xfffffffc1d0f7812ULL, 0x000fe400078ee21aULL, 0x00000029081a7210ULL, 0x000fe20007f3e0ffULL,
0x0000001013237824ULL, 0x000fc400078e0222ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x000000290a0a7210ULL, 0x000fe20007f1e0ffULL, 0x000000101b257824ULL, 0x000fe400078e0222ULL,
0x000000ffff1b7224ULL, 0x000fe400008e0609ULL, 0x00005e000e067625ULL, 0x000fc800078e0027ULL,
0x000000100c197824ULL, 0x100fe400078e0222ULL, 0x000000100d1d7824ULL, 0x000fe400078e0222ULL,
0x00005e0014087625ULL, 0x000fc800078e0027ULL, 0x000000100f1f7824ULL, 0x000fe200078e0222ULL,
0x0000002908087210ULL, 0x000fe20007f3e0ffULL, 0x00005e001c0c7625ULL, 0x000fc800078e0027ULL,
0x00005e001e0e7625ULL, 0x000fe200078e0027ULL, 0x000000290c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002906067210ULL, 0x080fe20007f1e0ffULL,
0x00000010172b7824ULL, 0x100fe200078e0222ULL, 0x000000290e0e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001002177824ULL, 0x000fe400078e0222ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102b7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fe400008e0609ULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x0000000012177faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x000000001a197faeULL, 0x0005e8000b901c46ULL, 0x000000000a1d7faeULL, 0x0005e8000b901c46ULL,
0x00000000061f7faeULL, 0x0005e8000b901c46ULL, 0x0000000008217faeULL, 0x0005e8000b901c46ULL,
0x000000000c237faeULL, 0x0005e8000b901c46ULL, 0x000000000e257faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x004fc40000015200ULL,
0x01060400ff097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011409ULL,
0x0000000b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000202027819ULL, 0x000fc80000001209ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002018027824ULL, 0x002fca00078e0205ULL,
0x00000003ff047819ULL, 0x000fe40000011602ULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000102047810ULL, 0x040fe20007ffe0ffULL,
0x0000002002087824ULL, 0x040fe400078e00ffULL, 0x0000000102067824ULL, 0x040fe400078e0205ULL,
0x0000000105077824ULL, 0x040fe200078e0204ULL, 0x0000001005057810ULL, 0x000fe20007ffe0ffULL,
0x0000002002097824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x000fe200078ec0ffULL,
0x0000002002117824ULL, 0x000fe200078e00ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x100fe200078e0205ULL, 0x000001e009067812ULL, 0x000fe200078ee206ULL,
0x0000000102107824ULL, 0x000fe200078e0205ULL, 0x000001e008077812ULL, 0x000fe200078ee207ULL,
0x0000002002057824ULL, 0x000fe200078e00ffULL, 0x0000001f04047812ULL, 0x000fe200078ec0ffULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000001f10107812ULL, 0x000fc400078ec0ffULL,
0x000001e011047812ULL, 0x000fe200078ee204ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000001e005107812ULL, 0x000fe200078ee210ULL, 0x000000ffff1c7224ULL, 0x002fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff1e7224ULL, 0x004fe400078e0008ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000aULL, 0x000000ffff267224ULL, 0x000fc400078e0009ULL,
0x000000ffff277224ULL, 0x000fe200078e000bULL, 0x0000001c06007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff247224ULL, 0x000fe400078e000dULL, 0x000000ffff257224ULL, 0x000fca00078e000fULL,
0x0000002407007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x00000000100c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff2b7224ULL, 0x002fe400078e000aULL,
0x000000ffff2a7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff287224ULL, 0x004fe400078e000cULL, 0x000000ffff297224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000002810007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff087f8cULL, 0x002e62000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01060400ff077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1600720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3d80000020147820ULL, 0x010fe20000410000ULL, 0x0001068818177811ULL, 0x000fe200078e18ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0xffffffff16197810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200078e00ffULL, 0x00010608181a7811ULL, 0x000fc400078e28ffULL,
0x000001001b2c7824ULL, 0x000fe200078e0200ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000002c1500720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e002dULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fc4000001ff00ULL,
0x000000012e307810ULL, 0x020fe20007ffe0ffULL, 0x00000a8000007945ULL, 0x000fe60003800000ULL,
0x0000001b302d7211ULL, 0x000fc400078ff0ffULL, 0x000000043000780cULL, 0x040fe40003f06070ULL,
0x000000012d2f7810ULL, 0x040fe20007ffe0ffULL, 0x000001002d347824ULL, 0x000fe200078e0200ULL,
0x00000001412d7812ULL, 0x000fe400078e0cffULL, 0x000000162f00720cULL, 0x000fe20003f26070ULL,
0x000000ffff2f7224ULL, 0x000fe200078e002eULL, 0x0000000330317812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2e7224ULL, 0x000fe400078e0030ULL, 0x0000620003397a24ULL, 0x000fd000078e0234ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x00000004313d7824ULL, 0x000fe200078e00ffULL,
0x0000000202317211ULL, 0x002fe200078fe8ffULL, 0x00000002183c7824ULL, 0x000fe200078e022dULL,
0x0000003415307217ULL, 0x000fe20007800000ULL, 0x00000100ff3f7424ULL, 0x000fe200078e00ffULL,
0x00000002ff367819ULL, 0x000fe40000011602ULL, 0x00000003313b7812ULL, 0x000fe200078ec0ffULL,
0x0000000130347824ULL, 0x000fe200078e0a34ULL, 0x0000000836317810ULL, 0x040fe20007ffe0ffULL,
0x0000000136307824ULL, 0x000fe200078e0239ULL, 0xfffffffc3d3d7812ULL, 0x000fc400078ee202ULL,
0x000000343600720cULL, 0x080fe20003f26070ULL, 0x0000000131327824ULL, 0x040fe200078e0239ULL,
0x000000343100720cULL, 0x040fe20003f46070ULL, 0x0000000431387824ULL, 0x000fe200078e00ffULL,
0x000020003c3c7811ULL, 0x000fe200078e60ffULL, 0x00005e0030307625ULL, 0x080fe200078e003fULL,
0x0ffffffc3b357812ULL, 0x000fe400078ef802ULL, 0xfffffffc38377812ULL, 0x000fe200078ee23bULL,
0x00005e0032327625ULL, 0x000fe200078e003fULL, 0x0000001036387810ULL, 0x000fc40007ffe0ffULL,
0x00000018363a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001035357824ULL, 0x000fe200078e023cULL,
0x00000020363e7810ULL, 0x040fe20007ffe0ffULL, 0x000000103d307825ULL, 0x000fe200078e0030ULL,
0x0000002836407810ULL, 0x040fe40007ffe0ffULL, 0x0000003036427810ULL, 0x040fe20007ffe0ffULL,
0x0000001037377824ULL, 0x000fe200078e023cULL, 0x0000003836437810ULL, 0x000fe20007ffe0ffULL,
0x000000103d327825ULL, 0x000fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030357faeULL, 0x0003e2000c901c46ULL, 0x000000343800720cULL, 0x000fc40003f26070ULL,
0x000000343e00720cULL, 0x080fe20003f66070ULL, 0x0000000032377faeULL, 0x0005e2000d101c46ULL,
0x000000343a00720cULL, 0x080fe20003f46070ULL, 0x0000000438447824ULL, 0x000fe200078e00ffULL,
0x000000344000720cULL, 0x0c0fe20003f86070ULL, 0x0000000140367824ULL, 0x100fe200078e0239ULL,
0x000000344200720cULL, 0x080fe20003fa6070ULL, 0x000000043a467824ULL, 0x000fe200078e00ffULL,
0x000000344300720cULL, 0x000fe20003fc6070ULL, 0x0000000138307824ULL, 0x102fe400078e0239ULL,
0x000000013e347824ULL, 0x000fe200078e0239ULL, 0xfffffffc46457812ULL, 0x000fe200078ee23bULL,
0x0000000142387824ULL, 0x000fc400078e0239ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e477812ULL, 0x100fe200078ee23bULL, 0x0000000443487824ULL, 0x040fe200078e00ffULL,
0xfffffffc40497812ULL, 0x000fe200078ee23bULL, 0x000000013a327824ULL, 0x004fe200078e0239ULL,
0xfffffffc424b7812ULL, 0x000fe200078ee23bULL, 0x00000001433a7824ULL, 0x000fe200078e0239ULL,
0xfffffffc44437812ULL, 0x100fe200078ee23bULL, 0x00005e0030307625ULL, 0x000fe200078e003fULL,
0xfffffffc484d7812ULL, 0x000fc600078ee23bULL, 0x00005e0032327625ULL, 0x000fc800078e003fULL,
0x00005e0034347625ULL, 0x000fc800078e003fULL, 0x00005e0036367625ULL, 0x000fc800078e003fULL,
0x00005e0038387625ULL, 0x000fc800078e003fULL, 0x00005e003a3a7625ULL, 0x000fc800078e003fULL,
0x000000103d307825ULL, 0x000fc800078e0030ULL, 0x000000103d327825ULL, 0x000fc800078e0032ULL,
0x000000103d347825ULL, 0x000fc800078e0034ULL, 0x000000103d367825ULL, 0x000fc800078e0036ULL,
0x000000103d387825ULL, 0x000fc800078e0038ULL, 0x000000103d3a7825ULL, 0x000fc800078e003aULL,
0x00000010433d7824ULL, 0x100fe400078e023cULL, 0x00000010453f7824ULL, 0x100fe400078e023cULL,
0x0000001047437824ULL, 0x100fe200078e023cULL, 0x00000000303d7faeULL, 0x0003e2000c901c46ULL,
0x0000001049457824ULL, 0x100fe400078e023cULL, 0x000000104b477824ULL, 0x100fe200078e023cULL,
0x00000000323f7faeULL, 0x0003e2000d101c46ULL, 0x000000104d497824ULL, 0x000fc600078e023cULL,
0x0000000034437faeULL, 0x0003e8000d901c46ULL, 0x0000000036457faeULL, 0x0003e8000e101c46ULL,
0x0000000038477faeULL, 0x0003e8000e901c46ULL, 0x000000003a497faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x0000000218327824ULL, 0x000fe200078e022dULL,
0x0000000802347811ULL, 0x042fe200078ff0ffULL, 0x0000000431437824ULL, 0x000fe200078e00ffULL,
0x0000001002367811ULL, 0x040fe200078ff0ffULL, 0x00000100ff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001802387811ULL, 0x000fe200078ff0ffULL, 0x0000000434427824ULL, 0x000fe200078e00ffULL,
0x00000020023a7811ULL, 0x000fe200078ff0ffULL, 0x0000000436447824ULL, 0x000fe200078e00ffULL,
0x00000028023c7811ULL, 0x000fe200078ff0ffULL, 0x0000000438467824ULL, 0x000fe200078e00ffULL,
0x00000030023e7811ULL, 0x000fe200078ff0ffULL, 0x000000043a487824ULL, 0x000fe200078e00ffULL,
0x0000003802407811ULL, 0x000fe200078ff0ffULL, 0x000000043c4a7824ULL, 0x000fe200078e00ffULL,
0x00002000324f7811ULL, 0x000fe200078e60ffULL, 0x0000000134327824ULL, 0x100fe200078e0239ULL,
0x0000000202317211ULL, 0x000fe200078fe8ffULL, 0x0000000136347824ULL, 0x100fe200078e0239ULL,
0x0000003902307211ULL, 0x000fe200078ff0ffULL, 0x0000000138367824ULL, 0x100fe200078e0239ULL,
0x0000000331337812ULL, 0x000fe200078ec0ffULL, 0x000000013a387824ULL, 0x000fe200078e0239ULL,
0xfffffffc43437812ULL, 0x000fe200078ee202ULL, 0x000000043e4c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc42427812ULL, 0x100fe200078ee233ULL, 0x00000004404e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc44447812ULL, 0x000fe200078ee233ULL, 0x000000013c3a7824ULL, 0x000fe200078e0239ULL,
0xfffffffc46467812ULL, 0x000fe200078ee233ULL, 0x000000013e3c7824ULL, 0x000fe200078e0239ULL,
0xfffffffc48487812ULL, 0x000fe200078ee233ULL, 0x00000001403e7824ULL, 0x000fe200078e0239ULL,
0xfffffffc4a4a7812ULL, 0x100fe200078ee233ULL, 0x00005e0030307625ULL, 0x000fe200078e003fULL,
0xfffffffc4c4c7812ULL, 0x000fc400078ee233ULL, 0xfffffffc4e4e7812ULL, 0x000fe200078ee233ULL,
0x00005e0034347625ULL, 0x000fe200078e003fULL, 0x0ffffffc33407812ULL, 0x000fc600078ef802ULL,
0x00005e0032327625ULL, 0x000fc800078e003fULL, 0x00005e0036367625ULL, 0x000fc800078e003fULL,
0x00005e0038387625ULL, 0x000fc800078e003fULL, 0x00005e003a3a7625ULL, 0x000fc800078e003fULL,
0x00005e003c3c7625ULL, 0x000fc800078e003fULL, 0x00005e003e3e7625ULL, 0x000fc800078e003fULL,
0x0000001043307825ULL, 0x000fc800078e0030ULL, 0x0000001043327825ULL, 0x000fc800078e0032ULL,
0x0000001043347825ULL, 0x000fc800078e0034ULL, 0x0000001043367825ULL, 0x000fc800078e0036ULL,
0x0000001043387825ULL, 0x000fc800078e0038ULL, 0x00000010433a7825ULL, 0x000fc800078e003aULL,
0x00000010433c7825ULL, 0x000fc800078e003cULL, 0x00000010433e7825ULL, 0x000fc800078e003eULL,
0x0000001040517824ULL, 0x100fe400078e024fULL, 0x0000001042437824ULL, 0x100fe400078e024fULL,
0x0000001044457824ULL, 0x100fe200078e024fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030517faeULL, 0x0003e2000b901c46ULL, 0x0000001046477824ULL, 0x100fe400078e024fULL,
0x0000001048497824ULL, 0x100fe200078e024fULL, 0x0000000032437faeULL, 0x0003e2000b901c46ULL,
0x000000104a4b7824ULL, 0x000fc400078e024fULL, 0x000000104c4d7824ULL, 0x100fe200078e024fULL,
0x0000000034457faeULL, 0x0003e2000b901c46ULL, 0x000000104e4f7824ULL, 0x000fc600078e024fULL,
0x0000000036477faeULL, 0x0003e8000b901c46ULL, 0x0000000038497faeULL, 0x0003e8000b901c46ULL,
0x000000003a4b7faeULL, 0x0003e8000b901c46ULL, 0x000000003c4d7faeULL, 0x0003e8000b901c46ULL,
0x000000003e4f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002002317810ULL, 0x002fe20007ffe0ffULL,
0x00000002183e7824ULL, 0x000fe200078e0241ULL, 0xfffffff8023d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fc400078ec0ffULL,
0x00000007023f7812ULL, 0x000fe400078ec0ffULL, 0x000000073d3d7812ULL, 0x100fe400078ef802ULL,
0x0000000731407812ULL, 0x100fe400078ef802ULL, 0x000020003e3e7811ULL, 0x000fe400078e60ffULL,
0x000000083f3f7812ULL, 0x000fe400078ef802ULL, 0x00000001ff417819ULL, 0x000fc4000001163dULL,
0x00000001ff437819ULL, 0x000fe20000011640ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000141307824ULL, 0x120fe200078e023cULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000043d317824ULL, 0x000fe200078e00ffULL, 0x000000013c487810ULL, 0x000fe20007ffe0ffULL,
0x0000000143347824ULL, 0x000fe400078e023cULL, 0x0000000440357824ULL, 0x040fe200078e00ffULL,
0xfffffffc31317812ULL, 0x000fe200078ee230ULL, 0x0000000440497824ULL, 0x000fe400078e00ffULL,
0x000000042f4d7824ULL, 0x000fe200078e023cULL, 0xfffffffc35357812ULL, 0x000fe200078ee234ULL,
0x0000001031317824ULL, 0x000fe200078e023eULL, 0x000000023c3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000024d4d7824ULL, 0x000fc400078e00ffULL, 0x0000001035357824ULL, 0x000fe200078e023eULL,
0x000000043c00780cULL, 0x000fe20003f25270ULL, 0x000000003130783bULL, 0x000e680000000200ULL,
0x000000003534783bULL, 0x000ea20000000200ULL, 0x00000018ff3a7819ULL, 0x002fe20000011432ULL,
0x00010000313b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011431ULL,
0x0000003a00587306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fc40000011430ULL,
0x00000018ff477819ULL, 0x000fe40000011433ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff467819ULL, 0x004fe20000011434ULL, 0x0000003900547306ULL, 0x0005e20000200c00ULL,
0x00008880313a7816ULL, 0x042fe200000000ffULL, 0x0000010031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011435ULL, 0x00000018ff447819ULL, 0x000fc40000011436ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000003800507306ULL, 0x0003e20000200c00ULL,
0x0001000030397824ULL, 0x004fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fc80000011437ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003100557306ULL, 0x0005e20000200c00ULL,
0x0000888030387816ULL, 0x042fe200000000ffULL, 0x0000010030307824ULL, 0x000fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x00000039004f7306ULL, 0x0003e20000200c00ULL,
0x0001000033317824ULL, 0x004fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000038004e7306ULL, 0x0004e20000200c00ULL, 0x0000888033397816ULL, 0x042fe200000000ffULL,
0x0000010033337824ULL, 0x000fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000003000517306ULL, 0x0003220000200c00ULL, 0x0000888032387816ULL, 0x004fce00000000ffULL,
0x0000003800567306ULL, 0x0005e20000200c00ULL, 0x0001000032307824ULL, 0x002fe200078e00ffULL,
0x000054104e4e7816ULL, 0x008fe2000000004fULL, 0x0000010032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000033005c7306ULL, 0x0003e20000200c00ULL,
0x000000043d387824ULL, 0x004fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00005410514f7816ULL, 0x010fc80000000050ULL, 0x0000003000577306ULL, 0x0004e20000200c00ULL,
0x0000000141337824ULL, 0x102fe400078e0248ULL, 0x0000000143487824ULL, 0x000fc600078e0248ULL,
0xfffffffc38337812ULL, 0x000fe400078ee233ULL, 0x0000003a00527306ULL, 0x000fe20000200c00ULL,
0x0000888034307816ULL, 0x004fe400000000ffULL, 0x0000001033337824ULL, 0x000fe200078e023eULL,
0xfffffffc49497812ULL, 0x000fc800078ee248ULL, 0x00000030005d7306ULL, 0x0003e20000200c00ULL,
0x0000541056567816ULL, 0x008fce0000000057ULL, 0x0000003b00537306ULL, 0x000ea20000200c00ULL,
0x0001000035307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003200597306ULL, 0x0002f00000200c00ULL, 0x00000039005a7306ULL, 0x0009e20000200c00ULL,
0x0001000034327824ULL, 0x002fe200078e00ffULL, 0x0000541052527816ULL, 0x004fe20000000053ULL,
0x0000010034347824ULL, 0x000fe200078e00ffULL, 0x0000541055537816ULL, 0x000fc40000000054ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000031005b7306ULL, 0x0002a20000200c00ULL,
0x000000003338783bULL, 0x010f220000000200ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000541059577816ULL, 0x008fc80000000058ULL, 0x0000003000617306ULL, 0x0007e20000200c00ULL,
0x0000888035317816ULL, 0x042fe200000000ffULL, 0x0000010035357824ULL, 0x000fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003100607306ULL, 0x0002620000200c00ULL,
0x0000001049307824ULL, 0x008fe200078e023eULL, 0x000054105a5a7816ULL, 0x004fe2000000005bULL,
0x0001000037497824ULL, 0x000fca00078e00ffULL, 0x00000032005e7306ULL, 0x0004e20000200c00ULL,
0x0001000036317824ULL, 0x002fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc80000011449ULL,
0x00000018ff487819ULL, 0x000fe40000011431ULL, 0x00000034005f7306ULL, 0x0003e20000200c00ULL,
0x000000003030783bULL, 0x004ea20000000200ULL, 0x0000541060607816ULL, 0x000fcc0000000061ULL,
0x0000003500627306ULL, 0x0007e20000200c00ULL, 0x0000888036347816ULL, 0x042fe200000000ffULL,
0x0000010036367824ULL, 0x000fe200078e00ffULL, 0x00008880396c7816ULL, 0x010fe200000000ffULL,
0x000100003a727824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001143bULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003400637306ULL, 0x0003e20000200c00ULL,
0x0000888037357816ULL, 0x048fe200000000ffULL, 0x0000010037377824ULL, 0x000fe200078e00ffULL,
0x000054105d5e7816ULL, 0x000fc4000000005eULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000003600657306ULL, 0x0007e20000200c00ULL,
0x00000018ff347819ULL, 0x002fce0000011438ULL, 0x00000034006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff367819ULL, 0x008fce0000011439ULL, 0x0000004800647306ULL, 0x0007220000200c00ULL,
0x0001000038347824ULL, 0x002fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x004fe40000011431ULL,
0x00000018ff4b7819ULL, 0x000fe40000011430ULL, 0x0000888032507816ULL, 0x000fe400000000ffULL,
0x0000003600707306ULL, 0x0003e20000200c00ULL, 0x00000018ff487819ULL, 0x008fce000001143aULL,
0x0000003700697306ULL, 0x0005e20000200c00ULL, 0x00000018ff367819ULL, 0x002fe40000011434ULL,
0x0000004d02347211ULL, 0x000fe400078fe0ffULL, 0x000000024d4d7810ULL, 0x000fe40007ffe0ffULL,
0x0000541063647816ULL, 0x010fe20000000064ULL, 0x0000004800747306ULL, 0x000fe20000200c00ULL,
0x00000018ff377819ULL, 0x004fe20000011433ULL, 0x000000013f347824ULL, 0x000fcc00078e0234ULL,
0x0000003700487306ULL, 0x0003f00000200c00ULL, 0x0000003500667306ULL, 0x0005e20000200c00ULL,
0x000000203f377824ULL, 0x002fca00078e00ffULL, 0xffffffe037347812ULL, 0x000fe400078ee234ULL,
0x00000036006b7306ULL, 0x000fe20000200c00ULL, 0x0000888038357816ULL, 0x044fe200000000ffULL,
0x0000010038387824ULL, 0x000fe400078e00ffULL, 0x0000001034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000003500687306ULL, 0x0002b00000200c00ULL,
0x00000038006d7306ULL, 0x0007e20000200c00ULL, 0x0001000039357824ULL, 0x002fc400078e00ffULL,
0x0000010039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011435ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x000088803a387816ULL, 0x048fe200000000ffULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x000001003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541068687816ULL, 0x004fc8000000006bULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000003800737306ULL, 0x0005f00000200c00ULL,
0x0000003900717306ULL, 0x0009e20000200c00ULL, 0x0000004d02387211ULL, 0x004fc400078fe0ffULL,
0x000054105c5b7816ULL, 0x008fc60000000047ULL, 0x000000013f387824ULL, 0x000fe400078e0238ULL,
0x0000004900677306ULL, 0x0004e20000200c00ULL, 0x000100003b397824ULL, 0x010fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000004600467306ULL, 0x000f220000200c00ULL,
0x00000018ff497819ULL, 0x004fe20000011432ULL, 0x0000004e3428723cULL, 0x042b6c0000001828ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x0000541066667816ULL, 0x008fe20000000067ULL,
0x000000203f4f7824ULL, 0x020fe200078e00ffULL, 0x000000523424723cULL, 0x000fea0000001824ULL,
0x0000004400447306ULL, 0x000ea20000200c00ULL, 0x000054105f5f7816ULL, 0x010fc40000000046ULL,
0xffffffe04f387812ULL, 0x000fe400078ee238ULL, 0x00008880314f7816ULL, 0x040fe200000000ffULL,
0x000000563420723cULL, 0x040fe40000001820ULL, 0x0000004200427306ULL, 0x000ee20000200c00ULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0x0000541062617816ULL, 0x002fe20000000045ULL,
0x000000ffff477224ULL, 0x000fe400078e004fULL, 0x00010000314f7824ULL, 0x040fe200078e00ffULL,
0x0000005a341c723cULL, 0x000fe2000000181cULL, 0x0000010031317824ULL, 0x000fe200078e00ffULL,
0x0000006e006f7306ULL, 0x0003e20000200c00ULL, 0x0000541065657816ULL, 0x004fe20000000044ULL,
0x000000ffff447224ULL, 0x000fe200078e0050ULL, 0x00000018ff4f7819ULL, 0x000fc4000001144fULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000005e3410723cULL, 0x040fe40000001810ULL,
0x0000003900777306ULL, 0x0005e20000200c00ULL, 0x000088803b6e7816ULL, 0x042fe200000000ffULL,
0x000001003b3b7824ULL, 0x000fe200078e00ffULL, 0x0000541069677816ULL, 0x008fe40000000042ULL,
0x000054106d697816ULL, 0x000fe2000000006aULL, 0x00000060340c723cULL, 0x000f62000000180cULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000003a00757306ULL, 0x0003e20000200c00ULL,
0x0001000030397824ULL, 0x004fe200078e00ffULL, 0x00005410716d7816ULL, 0x000fc80000000070ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x000000643408723cULL, 0x000f620000001808ULL,
0x0000003b00517306ULL, 0x0005e20000200c00ULL, 0x00008880303a7816ULL, 0x002fcc00000000ffULL,
0x000000663404723cULL, 0x000b620000001804ULL, 0x0000003a004d7306ULL, 0x000fe20000200c00ULL,
0x00000100303b7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001143bULL,
0x0001000033347824ULL, 0x020fe200078e00ffULL, 0x0000003900307306ULL, 0x0002a80000200c00ULL,
0x00000018ff347819ULL, 0x000fc80000011434ULL, 0x0000004f00467306ULL, 0x0007e20000200c00ULL,
0x000000003838783bULL, 0x002e6e0000000200ULL, 0x0000003100457306ULL, 0x0009e20000200c00ULL,
0x00010000324f7824ULL, 0x048fe200078e00ffULL, 0x000054104d307816ULL, 0x004fe20000000030ULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x0000888033317816ULL, 0x050fe200000000ffULL, 0x0000010033337824ULL, 0x000fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000004a004a7306ULL, 0x000ef00000200c00ULL,
0x0000006c006c7306ULL, 0x000f220000200c00ULL, 0x0000541047467816ULL, 0x004fce0000000046ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x0000541045477816ULL, 0x008fe2000000004aULL,
0x000000683828723cULL, 0x042b6c0000001828ULL, 0x0000003100357306ULL, 0x000fe20000200c00ULL,
0x000054106c6c7816ULL, 0x010fe2000000006fULL, 0x00000046380c723cULL, 0x040b6c000000180cULL,
0x0000003400347306ULL, 0x000e620000200c00ULL, 0x0000541073727816ULL, 0x004fe20000000072ULL,
0x0000006c3824723cULL, 0x000b620000001824ULL, 0x0000541075737816ULL, 0x000fca0000000074ULL,
0x0000004c004c7306ULL, 0x000ea40000200c00ULL, 0x000000723820723cULL, 0x000b6c0000001820ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541035347816ULL, 0x002fce0000000034ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x00005410516f7816ULL, 0x004fce000000004cULL,
0x0000006e006e7306ULL, 0x000e700000200c00ULL, 0x0000004e004e7306ULL, 0x000eb00000200c00ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x000054106e6e7816ULL, 0x002fce0000000077ULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000054104e317816ULL, 0x004fe2000000004bULL,
0x0000006e381c723cULL, 0x040b6c000000181cULL, 0x0000003200327306ULL, 0x000ea40000200c00ULL,
0x000000303810723cULL, 0x000b6c0000001810ULL, 0x0000003300337306ULL, 0x000ee20000200c00ULL,
0x0000541044447816ULL, 0x002fc4000000004fULL, 0x0000541032457816ULL, 0x004fce0000000049ULL,
0x000000443808723cULL, 0x000b620000001808ULL, 0x0000541033357816ULL, 0x008fce0000000048ULL,
0x000000343804723cULL, 0x000b620000001804ULL, 0xfffff06000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff417224ULL, 0x000fe200078e002dULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe4a000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x000000141e307220ULL, 0x0a0fe20000410000ULL,
0x000000141f317220ULL, 0x080fe20000410000ULL, 0x0000001420207220ULL, 0x080fe20000410000ULL,
0x0000001421217220ULL, 0x080fe20000410000ULL, 0x00000014222e7220ULL, 0x080fe20000410000ULL,
0x00000014232f7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x00000014101e7220ULL, 0x080fe20000410000ULL, 0x00000014111f7220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000140c227220ULL, 0x080fe20000410000ULL,
0x000000140d237220ULL, 0x080fe20000410000ULL, 0x0000001408087220ULL, 0x080fe20000410000ULL,
0x0000001409097220ULL, 0x080fe20000410000ULL, 0x0000001404047220ULL, 0x080fe20000410000ULL,
0x0000001412327220ULL, 0x080fe20000410000ULL, 0x0000001413337220ULL, 0x080fe20000410000ULL,
0x000000140e347220ULL, 0x080fe20000410000ULL, 0x000000140f357220ULL, 0x080fe20000410000ULL,
0x000000140a367220ULL, 0x080fe20000410000ULL, 0x000000140b377220ULL, 0x080fe20000410000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0020ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0021ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000ffff117224ULL, 0x000fe200078e001dULL, 0x0000001426267220ULL, 0x080fe20000410000ULL,
0x000000ffff127224ULL, 0x000fe200078e001eULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x000000ffff137224ULL, 0x000fe200078e001fULL, 0x0000001405057220ULL, 0x080fe20000410000ULL,
0x0000001406067220ULL, 0x080fe20000410000ULL, 0x0000001407077220ULL, 0x000fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fc400078e0028ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0029ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0024ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0025ULL,
0x000000ffff107224ULL, 0x000fe400078e001cULL, 0x000000ffff1d7224ULL, 0x000fe400078e0022ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0023ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0008ULL,
0x000000ffff207224ULL, 0x000fe400078e0009ULL, 0x000000ffff217224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000017087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff257224ULL, 0x000fe400078e0026ULL, 0x000000ffff267224ULL, 0x000fe400078e0027ULL,
0x000000ffff247224ULL, 0x000fc400078e002aULL, 0x000000ffff237224ULL, 0x000fe400078e002bULL,
0x000000ffff277224ULL, 0x000fe400078e002eULL, 0x000000ffff287224ULL, 0x000fe400078e002fULL,
0x000000ffff297224ULL, 0x000fe400078e0030ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0031ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0032ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0033ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0034ULL, 0x000000ffff227224ULL, 0x000fe400078e0005ULL,
0x000000ffff307224ULL, 0x000fe400078e0035ULL, 0x000000ffff317224ULL, 0x000fe400078e0036ULL,
0x000000ffff327224ULL, 0x000fc400078e0037ULL, 0x000000ffff337224ULL, 0x000fe400078e0006ULL,
0x000000ffff347224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040017077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604357210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000003506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040017077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000402357824ULL, 0x000fe200078e00ffULL, 0x000000191b00720cULL, 0x000fc80003f05270ULL,
0xfffffff035057812ULL, 0x000fca00078ec0ffULL, 0x00000080181c7824ULL, 0x000fca00078e0205ULL,
0x010400001c047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000202087824ULL, 0x000fe400078e00ffULL, 0x00000001152c7824ULL, 0x000fc600078e0a2cULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109377812ULL, 0x040fe400078efcffULL,
0x0000000809397812ULL, 0x000fe400078efcffULL, 0x0000002c3700720cULL, 0x080fe40003f26070ULL,
0x0000001009377812ULL, 0x000fe400078efcffULL, 0x0000002c3900720cULL, 0x080fe40003f06070ULL,
0x0000002c3700720cULL, 0x000fc40003fc6070ULL, 0x0000001109397812ULL, 0x040fe400078efcffULL,
0x0000001809377812ULL, 0x040fe400078efcffULL, 0x0000002c0900720cULL, 0x080fe40003f46070ULL,
0x0000002c3900720cULL, 0x080fe40003fa6070ULL, 0x0000002c3700720cULL, 0x000fe40003f66070ULL,
0x00000009093b7812ULL, 0x000fc400078efcffULL, 0x0000001909397812ULL, 0x040fe400078efcffULL,
0x0000002009377812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x0000002c3b00720cULL, 0x080fe40003f86070ULL,
0x0000002c3900720cULL, 0x080fe40003f46070ULL, 0x0000002c3700720cULL, 0x000fe40003f26070ULL,
0x0000002109397812ULL, 0x040fe400078efcffULL, 0x0000002809377812ULL, 0x000fe400078efcffULL,
0xff80000025257808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x0000002c3900720cULL, 0x080fe40003f06070ULL, 0x0000002c3700720cULL, 0x000fe40003f86070ULL,
0x0000002909397812ULL, 0x000fc400078efcffULL, 0x0000003009377812ULL, 0x000fe400078efcffULL,
0xff80000027277808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000028287808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x0000002c3900720cULL, 0x000fc40003fc6070ULL, 0x0000002c3700720cULL, 0x000fe40003fa6070ULL,
0x0000003109397812ULL, 0x040fe400078efcffULL, 0x0000003809377812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff80000029297808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff8000002a2a7808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff8000002b2b7808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x0000002c3900720cULL, 0x080fe40003f66070ULL,
0x0000002c3700720cULL, 0x000fc40003f46070ULL, 0x0000002c0900720cULL, 0x000fe40003f26070ULL,
0xff8000002e2e7808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff8000002f2f7808ULL, 0x000fe40006000000ULL, 0xff8000001d1d7808ULL, 0x000fe40006000000ULL,
0xff80000030307808ULL, 0x000fc40007000000ULL, 0xff8000001e1e7808ULL, 0x000fe40007000000ULL,
0xff80000031317808ULL, 0x000fe40006800000ULL, 0xff8000001f1f7808ULL, 0x000fe40006800000ULL,
0xff80000032327808ULL, 0x000fe40005800000ULL, 0xff80000020207808ULL, 0x000fe40005800000ULL,
0xff80000033337808ULL, 0x000fc40005000000ULL, 0xff80000021217808ULL, 0x000fe40005000000ULL,
0xff80000034347808ULL, 0x000fe40004800000ULL, 0xff80000022227808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff3b7424ULL, 0x000fe200078e00ffULL,
0x000000240500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3c7424ULL, 0x000fe200078e00ffULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x0000000524047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x000000230400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x0000000423047208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x000000250400720bULL, 0x000fc40003f3e000ULL,
0x000000090c087208ULL, 0x000fe40004000000ULL, 0x0000000425057208ULL, 0x000fe40004800000ULL,
0x0000000d0800720bULL, 0x000fe40003f1e000ULL, 0x000000260500720bULL, 0x000fe40003f3e000ULL,
0x000000080d097208ULL, 0x000fe40004000000ULL, 0x0000000526047208ULL, 0x000fc40004800000ULL,
0x0000000e0900720bULL, 0x000fe40003f1e000ULL, 0x000000270400720bULL, 0x000fe40003f3e000ULL,
0x000000090e087208ULL, 0x000fe40004000000ULL, 0x0000000427057208ULL, 0x000fe40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000280500720bULL, 0x000fc40003f3e000ULL,
0x000000080f097208ULL, 0x000fe40004000000ULL, 0x0000000528047208ULL, 0x000fe40004800000ULL,
0x000000100900720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fe40003f3e000ULL,
0x0000000910087208ULL, 0x000fe40004000000ULL, 0x0000000429057208ULL, 0x000fc40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x0000002a0500720bULL, 0x000fe40003f3e000ULL,
0x0000000811097208ULL, 0x000fe40004000000ULL, 0x000000052a047208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x0000002b0400720bULL, 0x000fc40003f3e000ULL,
0x0000000912087208ULL, 0x000fe40004000000ULL, 0x000000042b057208ULL, 0x000fe40004800000ULL,
0x000000130800720bULL, 0x000fe40003f1e000ULL, 0x0000002e0500720bULL, 0x000fe40003f3e000ULL,
0x0000000813087208ULL, 0x000fe40004000000ULL, 0x000000052e047208ULL, 0x000fc40004800000ULL,
0x0000001d0800720bULL, 0x000fe40003f1e000ULL, 0x0000002f0400720bULL, 0x000fe40003f3e000ULL,
0x000000081d057208ULL, 0x000fe40004000000ULL, 0x000000042f097208ULL, 0x000fe40004800000ULL,
0x0000001e0500720bULL, 0x000fe40003f1e000ULL, 0x000000300900720bULL, 0x000fc40003f3e000ULL,
0x000000051e047208ULL, 0x000fe40004000000ULL, 0x0000000930087208ULL, 0x000fe40004800000ULL,
0x0000001f0400720bULL, 0x000fe40003f1e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x000000041f057208ULL, 0x000fe40004000000ULL, 0x0000000831097208ULL, 0x000fc40004800000ULL,
0x000000200500720bULL, 0x000fe40003f1e000ULL, 0x000000320900720bULL, 0x000fe40003f3e000ULL,
0x0000000520047208ULL, 0x000fe40004000000ULL, 0x0000000932087208ULL, 0x000fe40004800000ULL,
0x000000210400720bULL, 0x000fe40003f1e000ULL, 0x000000330800720bULL, 0x000fc40003f3e000ULL,
0x0000000421057208ULL, 0x000fe40004000000ULL, 0x0000000833097208ULL, 0x000fe40004800000ULL,
0x000000220500720bULL, 0x000fe40003f1e000ULL, 0x000000340900720bULL, 0x000fe40003f3e000ULL,
0x0000000522367208ULL, 0x000fe40004000000ULL, 0x0000000934387208ULL, 0x000fe20004800000ULL,
0x000017c27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0036047f89ULL, 0x0004e400000e0000ULL,
0x000000043600720bULL, 0x008fc80003f1e000ULL, 0x00000036043a7208ULL, 0x000fe20004000000ULL,
0x000017d27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0038047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000e6200000e0000ULL,
0x000000043800720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000003804087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f003a047f89ULL, 0x000ee200000e0000ULL, 0x0000002c0700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000e6200000e0000ULL, 0x000000072c2c7208ULL, 0x000fc60004000000ULL,
0x0c201f0009367f89ULL, 0x004ea800000e0000ULL, 0x0c201f002c377f89ULL, 0x0002a200000e0000ULL,
0x000000043a00720bULL, 0x008fe40003f1e000ULL, 0x000000050800720bULL, 0x002fe40003f3e000ULL,
0x0000003a04047208ULL, 0x000fe40004000000ULL, 0x000000360900720bULL, 0x004fc40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x0000000936067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05367820ULL, 0x002fe20000410000ULL,
0x3c003c00ff3c7424ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010836ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3c003c00ff3d7424ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010836ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010836ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010836ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b34347823ULL, 0x000fe20000010836ULL, 0x3fb8aa3b22077823ULL, 0x000fe20000010807ULL,
0x0000a000183f7811ULL, 0x000fc400078e58ffULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0000000302ff7812ULL, 0x000fe4000780c0ffULL, 0x000000372c00720bULL, 0x004fca0003f3e000ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000000ffULL,
0x00000025000b7308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000242309723eULL, 0x002fce00000000ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b260b723eULL, 0x004fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000003c0838723cULL, 0x000f6e00000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x004fce00000000ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000ea20000000800ULL, 0x00000027280d723eULL, 0x002fe400000000ffULL,
0x00000002ff287819ULL, 0x000fc80000011602ULL, 0x0000000228107810ULL, 0x040fe20007ffe0ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000000828257824ULL, 0x040fe200078e00ffULL,
0x0000000328117810ULL, 0x040fe20007ffe0ffULL, 0x0000000828267824ULL, 0x040fe200078e00ffULL,
0x0000000428237810ULL, 0x040fe20007ffe0ffULL, 0x0000000828247824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe400078ee210ULL, 0x000000292a0f723eULL, 0x004fe200000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0xfffffff826267812ULL, 0x000fe200078ee211ULL,
0x00000008282a7824ULL, 0x000fc400078e00ffULL, 0x0000000828297824ULL, 0x000fe400078e00ffULL,
0x0000003c0c38723cULL, 0x020f620000001838ULL, 0xfffffff82a277812ULL, 0x000fe200078ee223ULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0xffffffff28237810ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x100fe400078e023fULL, 0x0000001027277824ULL, 0x000fc800078e023fULL,
0x0000001e001e7308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x0000001d1e12723eULL, 0x004fe400000000ffULL, 0x00000005281d7810ULL, 0x000fc40007ffe0ffULL,
0x00000006281e7810ULL, 0x000fc60007ffe0ffULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x0000002b2e11723eULL, 0x002fe200000000ffULL,
0x00000008282e7824ULL, 0x000fca00078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee223ULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x0000002f3013723eULL, 0x004fce00000000ffULL,
0x0000000700227308ULL, 0x0002a20000000800ULL, 0x0000000828307810ULL, 0x000fe20007ffe0ffULL,
0x000000102e2f7824ULL, 0x000fe200078e023fULL, 0x0000003c1038723cULL, 0x020f660000001838ULL,
0x00000008302b7824ULL, 0x000fe400078e00ffULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x0000000128077810ULL, 0x002fe40007ffe0ffULL, 0xfffffff82b307812ULL, 0x000fc400078ee230ULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x0000000828077824ULL, 0x000fe400078e00ffULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x000000212222723eULL, 0x004fe400000000ffULL,
0xfffffff807077812ULL, 0x000fe400078ee228ULL, 0xfffffff82a287812ULL, 0x000fe200078ee21dULL,
0x00000010241d7824ULL, 0x100fe400078e023fULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0xfffffff8292a7812ULL, 0x000fe200078ee21eULL, 0x0000001007077824ULL, 0x100fe200078e023fULL,
0x0000000c351e7812ULL, 0x000fe200078ec0ffULL, 0x0000001028297824ULL, 0x000fc400078e023fULL,
0x000000102a2b7824ULL, 0x100fe400078e023fULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x0000001f2020723eULL, 0x002fe200000000ffULL, 0x00000010261f7824ULL, 0x000fe400078e023fULL,
0x0000000107077824ULL, 0x000fe400078e021eULL, 0x000000011e1d7824ULL, 0x040fe400078e021dULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x000000011e257824ULL, 0x040fe200078e0225ULL,
0x0000000807007388ULL, 0x0003e20000000800ULL, 0x000000011e1f7824ULL, 0x000fc400078e021fULL,
0x000000011e277824ULL, 0x040fe200078e0227ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x000000011e297824ULL, 0x000fe200078e0229ULL, 0x0000003400347308ULL, 0x000f220000000800ULL,
0x000000313221723eULL, 0x004fe200000000ffULL, 0x0000001030317824ULL, 0x000fe200078e023fULL,
0x0000000c25007388ULL, 0x0007e20000000800ULL, 0x000000011e2b7824ULL, 0x040fe200078e022bULL,
0x0000002c37077208ULL, 0x002fe20004800000ULL, 0x000000011e2f7824ULL, 0x040fe200078e022fULL,
0x0000000e1f007388ULL, 0x0007e20000000800ULL, 0x000000011e1e7824ULL, 0x000fc600078e0231ULL,
0x0000001027007388ULL, 0x0007e80000000800ULL, 0x0000001229007388ULL, 0x0007e20000000800ULL,
0x000000333423723eULL, 0x010fc600000000ffULL, 0x000000202b007388ULL, 0x0007e80000000800ULL,
0x0000003c2038723cULL, 0x020f620000001838ULL, 0x000000222f007388ULL, 0x0007e80000000800ULL,
0x000000091e007388ULL, 0x0007e80000000800ULL, 0x0004000b1d007388ULL, 0x0007e80000000800ULL,
0x0004000d25007388ULL, 0x0007e80000000800ULL, 0x0004000f1f007388ULL, 0x0007e80000000800ULL,
0x0004001127007388ULL, 0x0007e60000000800ULL, 0x000000ffff397224ULL, 0x020fe200078e003aULL,
0x0004001329007388ULL, 0x0007e80000000800ULL, 0x000400212b007388ULL, 0x0007e80000000800ULL,
0x000400232f007388ULL, 0x0007e80000000800ULL, 0x010000041c008388ULL, 0x0007e80000000c00ULL,
0x010200381c008388ULL, 0x0007e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000001aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008001aff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010001aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000011b1b7810ULL, 0x000fe20007ffe0ffULL, 0x000018001aff7f8cULL, 0x0003e6000c80043fULL,
0x000000161b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffc6f000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff407807ULL, 0x008fe40004000000ULL, 0x0001675000497802ULL, 0x000fc40000000f00ULL,
0x00000f6000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0046ULL,
0xfffeb52000007947ULL, 0x000fea000383ffffULL, 0x00000001ff407807ULL, 0x000fe40005000000ULL,
0x000167a000497802ULL, 0x000fc40000000f00ULL, 0x00000f1000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0046ULL, 0xfffeb58000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0004ULL, 0x0001680000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff467224ULL, 0x008fc400078e0019ULL, 0x00000e7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0046ULL, 0xfffeb61000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0019ULL, 0x0001686000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x002fc400078e0004ULL, 0x00000e1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0046ULL, 0xfffeb72000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0000ULL, 0x000168c000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0003ULL, 0x00000db000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0046ULL, 0xfffebb1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x002fe200078e0008ULL, 0x0001692000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff467224ULL, 0x000fc400078e0000ULL, 0x00000d5000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0046ULL, 0xfffebae000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e001aULL, 0x0001698000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e001bULL, 0x00000cf000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0046ULL, 0xfffed79000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e001aULL, 0x000169d000407802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0046ULL,
0xfffed77000007947ULL, 0x000fea000383ffffULL, 0x00000001ff407807ULL, 0x004fe40004000000ULL,
0x00016a2000497802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff447224ULL, 0x000fe200078e0046ULL, 0xfffef43000007947ULL, 0x000fea000383ffffULL,
0x00000001ff407807ULL, 0x000fe40005000000ULL, 0x00016a7000497802ULL, 0x000fc40000000f00ULL,
0x00000c4000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff457224ULL, 0x000fe200078e0046ULL,
0xfffef47000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e0047ULL,
0x00016ac000407802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff407224ULL, 0x004fe200078e0046ULL, 0xfffef53000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0047ULL, 0x00016b1000407802ULL, 0x000fc40000000f00ULL,
0x00000b6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff407224ULL, 0x004fe200078e0046ULL,
0xfffef64000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e001fULL,
0x00016b7000407802ULL, 0x000fe20000000f00ULL, 0x000000ffff4d7224ULL, 0x000fc400078e0042ULL,
0x00000b0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0046ULL,
0xfffefa5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e001fULL,
0x00016bc000407802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0046ULL, 0xfffefa3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0042ULL, 0x00016c2000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0043ULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0046ULL, 0xffff150000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0042ULL, 0x00016c7000407802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0046ULL,
0xffff14e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff407807ULL, 0x004fe40004000000ULL,
0x00016cc000497802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff427224ULL, 0x000fe200078e0046ULL, 0xffff30b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff407807ULL, 0x000fe40005000000ULL, 0x00016d1000497802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff477224ULL, 0x000fe200078e0046ULL,
0xffff30f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e0049ULL,
0x00016d6000407802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff407224ULL, 0x004fe200078e0046ULL, 0xffff31b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0049ULL, 0x00016db000407802ULL, 0x000fc40000000f00ULL,
0x000008c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff407224ULL, 0x004fe200078e0046ULL,
0xffff32c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e001fULL,
0x00016e1000407802ULL, 0x000fe20000000f00ULL, 0x000000ffff4d7224ULL, 0x000fc400078e0042ULL,
0x0000086000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0046ULL,
0xffff36d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e001fULL,
0x00016e6000407802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0046ULL, 0xffff36b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0042ULL, 0x00016ec000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0043ULL, 0x000007b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0046ULL, 0xffff518000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0042ULL, 0x00016f1000407802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0046ULL,
0xffff516000007947ULL, 0x000fea000383ffffULL, 0x00000001ff407807ULL, 0x004fe40004000000ULL,
0x00016f6000497802ULL, 0x000fc40000000f00ULL, 0x0000075000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff427224ULL, 0x000fe200078e0046ULL, 0xffff6d4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff407807ULL, 0x000fe40004800000ULL, 0x00016fb000497802ULL, 0x000fc40000000f00ULL,
0x0000070000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0046ULL,
0xffff6d8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e0049ULL,
0x0001700000407802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0046ULL, 0xffff6e4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0049ULL, 0x0001705000407802ULL, 0x000fc40000000f00ULL,
0x0000062000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0046ULL,
0xffff6f5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e000dULL,
0x000170b000407802ULL, 0x000fe20000000f00ULL, 0x000000ffff4d7224ULL, 0x000fc400078e000eULL,
0x000005c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0046ULL,
0xffff736000007947ULL, 0x000fea000383ffffULL, 0x000000ffff467224ULL, 0x000fe200078e000dULL,
0x0001710000407802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0046ULL, 0xffff734000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0000ULL, 0x0001716000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x020fc400078e0003ULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0046ULL, 0xffff8e3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff467224ULL, 0x000fe200078e0000ULL, 0x000171b000407802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0046ULL,
0xffff8e1000007947ULL, 0x000fea000383ffffULL, 0x00000002ff397424ULL, 0x000fe200078e00ffULL,
0x0001720000087802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0037ULL, 0xffffe80000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x006fe200078e0038ULL, 0x0001726000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff397424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000373800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff367224ULL, 0x002fe200078e0006ULL,
0x000172c000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff397424ULL, 0x000fe200078e00ffULL,
0x0000003837387208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000370600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff367224ULL, 0x002fe200078e0007ULL,
0x0001732000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff397424ULL, 0x000fe200078e00ffULL,
0x0000000637067208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000370700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff367224ULL, 0x002fe200078e003aULL,
0x0001738000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x00000007372c7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000373a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff367224ULL, 0x002fe200078e0038ULL,
0x000173e000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000003a37047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000373800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff367224ULL, 0x002fe200078e0006ULL,
0x0001744000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000003837057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000370600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff367224ULL, 0x002fe200078e002cULL,
0x000174a000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000000637067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe6d000007947ULL, 0x000fea000383ffffULL, 0x0180000012007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000001200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff12ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000012027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000001200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe89d002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0c00003936377389ULL, 0x0002a200000e003bULL,
0xfffe899008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff417424ULL, 0x000fe200078e00ffULL,
0x0000000b00007348ULL, 0x000fe80003800000ULL, 0x0000004d46467389ULL, 0x0002a200000e000cULL,
0xfffe895040007950ULL, 0x000fea0003c3ffffULL, 0x000000014000780cULL, 0x000fe20003f45070ULL,
0x0000000d00007348ULL, 0x000fe80003800000ULL, 0x00000000ff417424ULL, 0x000fd000078e00ffULL,
0x0000000000407806ULL, 0x000fc800050e0100ULL, 0x0000000d40467212ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fc800078e0049ULL, 0xfffe88e040007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x00000000000003f0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e78ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001890ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001920ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001924ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b00ULL, 0x0000000000017800ULL, 0x8700001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019300ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019350ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000196d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001920ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000179e0ULL, 0x00000000000179e0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000019300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000196d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_89_cubin_len = 104368;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
