/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017aa8ULL, 0x0000000000017728ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL, 0x326a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45386aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x5f24000000000000ULL,
0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL, 0x5f6e725f7063725fULL,
0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL, 0x656e72656b2e7478ULL,
0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x72656b240061686dULL,
0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL, 0x656d6172665f6775ULL,
0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL, 0x72665f6775626564ULL,
0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x0000000061686d5fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000036eULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000003b5ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000403ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000448ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000004a3ULL, 0x0000000000015f40ULL, 0x0000000000000240ULL, 0x0004000300000519ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000016180ULL, 0x000d000300000549ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00015f4000000000ULL, 0x00007c0400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808592ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL, 0x00015f4000000000ULL,
0x0000024000000000ULL, 0x0000580400000000ULL, 0x8082288080850900ULL, 0x0000000000002880ULL,
0x0000001600082f04ULL, 0x000823040000007cULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL,
0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b82904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x00b82804ffffffffULL, 0x0000012000000100ULL, 0x00001e4000000730ULL,
0x00001f6000001ea0ULL, 0x00002530000020a0ULL, 0x00003fe000002540ULL, 0x000059f000003ff0ULL,
0x00005b2000005a50ULL, 0x0000601000005c60ULL, 0x0000791000006020ULL, 0x0000925000007920ULL,
0x00009380000092b0ULL, 0x00009870000094c0ULL, 0x0000b17000009880ULL, 0x0000cab00000b180ULL,
0x0000cbe00000cb10ULL, 0x0000d0d00000cd20ULL, 0x0000ea000000d0e0ULL, 0x0000fa700000ea10ULL,
0x000102a00000fa80ULL, 0x0001543000015380ULL, 0x0001572000015660ULL, 0x00015a20000159a0ULL,
0x00015c6000015b10ULL, 0x0000024005f03904ULL, 0x00018600000000ffULL, 0x0000032000040100ULL,
0x000186080000000bULL, 0x00000430003f0100ULL, 0x000186880000000bULL, 0x00000550003f0100ULL,
0x000186a800000002ULL, 0x00000640003f0100ULL, 0x000186b8000000ffULL, 0x000008f000040100ULL,
0x0001860000000004ULL, 0x000009e0003f0107ULL, 0x0001868800000003ULL, 0x000010c0003f0101ULL,
0x000186a800000004ULL, 0x000011a0003f0107ULL, 0x000186a800000004ULL, 0x00001240003f0101ULL,
0x000186b800000004ULL, 0x000012e0003f0101ULL, 0x000186b800000004ULL, 0x00001450003f0109ULL,
0x000186b800000004ULL, 0x00001b90003f0109ULL, 0x000186b000000004ULL, 0x00001be0003f0107ULL,
0x000186b000000004ULL, 0x00001bf0003f0101ULL, 0x0001860800000003ULL, 0x00001c10003f0101ULL,
0x0001860800000003ULL, 0x00001d80003f0109ULL, 0x0001860800000003ULL, 0x00002230003f0109ULL,
0x000186a800000004ULL, 0x000023a0003f0109ULL, 0x000186a800000004ULL, 0x00003390003f0109ULL,
0x000186b800000004ULL, 0x000034c0003f0101ULL, 0x000186b800000004ULL, 0x00003630003f0109ULL,
0x000186b800000004ULL, 0x00003d10003f0109ULL, 0x00000000000000ffULL, 0x00003d5000050107ULL,
0x000186a800000004ULL, 0x00003d80003f0101ULL, 0x000186b000000004ULL, 0x00003ef0003f0109ULL,
0x000186b000000004ULL, 0x00004d90003f0109ULL, 0x000186b800000004ULL, 0x00004db0003f0101ULL,
0x0001868800000004ULL, 0x00004f50003f0101ULL, 0x000186b800000004ULL, 0x000050c0003f0109ULL,
0x000186b800000004ULL, 0x000057a0003f0109ULL, 0x00000000000000ffULL, 0x000057e000060107ULL,
0x000186b000000004ULL, 0x000057f0003f0101ULL, 0x0001862800000003ULL, 0x00005810003f0101ULL,
0x0001862800000003ULL, 0x00005980003f0109ULL, 0x0001862800000003ULL, 0x00005e10003f0109ULL,
0x000186a800000004ULL, 0x00005f80003f0109ULL, 0x000186a800000004ULL, 0x00006d20003f0109ULL,
0x000186b800000004ULL, 0x00006e70003f0101ULL, 0x000186b800000004ULL, 0x00006fe0003f0109ULL,
0x000186b800000004ULL, 0x000076c0003f0109ULL, 0x00000000000000ffULL, 0x0000770000050107ULL,
0x000186a800000004ULL, 0x00007730003f0101ULL, 0x000186b000000004ULL, 0x000078a0003f0109ULL,
0x000186b000000004ULL, 0x00008610003f0109ULL, 0x000186b800000004ULL, 0x00008640003f0101ULL,
0x0001869000000004ULL, 0x000087c0003f0101ULL, 0x000186b800000004ULL, 0x00008930003f0109ULL,
0x000186b800000004ULL, 0x00009010003f0109ULL, 0x00000000000000ffULL, 0x0000905000060107ULL,
0x000186b000000004ULL, 0x00009060003f0101ULL, 0x0001864800000003ULL, 0x00009080003f0101ULL,
0x0001864800000003ULL, 0x000091f0003f0109ULL, 0x0001864800000003ULL, 0x00009670003f0109ULL,
0x000186a800000004ULL, 0x000097e0003f0109ULL, 0x000186a800000004ULL, 0x0000a580003f0109ULL,
0x000186b800000004ULL, 0x0000a6d0003f0101ULL, 0x000186b800000004ULL, 0x0000a840003f0109ULL,
0x000186b800000004ULL, 0x0000af20003f0109ULL, 0x00000000000000ffULL, 0x0000af6000050107ULL,
0x000186a800000004ULL, 0x0000af90003f0101ULL, 0x000186b000000004ULL, 0x0000b100003f0109ULL,
0x000186b000000004ULL, 0x0000be70003f0109ULL, 0x000186b800000004ULL, 0x0000bea0003f0101ULL,
0x0001869800000004ULL, 0x0000c020003f0101ULL, 0x000186b800000004ULL, 0x0000c190003f0109ULL,
0x000186b800000004ULL, 0x0000c870003f0109ULL, 0x00000000000000ffULL, 0x0000c8b000060107ULL,
0x000186b000000004ULL, 0x0000c8c0003f0101ULL, 0x0001866800000003ULL, 0x0000c8e0003f0101ULL,
0x0001866800000003ULL, 0x0000ca50003f0109ULL, 0x0001866800000003ULL, 0x0000ced0003f0109ULL,
0x000186a800000004ULL, 0x0000d040003f0109ULL, 0x000186a800000004ULL, 0x0000df10003f0109ULL,
0x000186b800000004ULL, 0x0000df40003f0101ULL, 0x000186b800000004ULL, 0x0000e0b0003f0109ULL,
0x000186b800000004ULL, 0x0000e7b0003f0109ULL, 0x00000000000000ffULL, 0x0000e7f000050107ULL,
0x000186a800000004ULL, 0x0000e820003f0101ULL, 0x000186b000000004ULL, 0x0000e990003f0109ULL,
0x000186b000000004ULL, 0x0000f7b0003f0109ULL, 0x000186b800000004ULL, 0x0000f7f0003f0101ULL,
0x000186a000000004ULL, 0x00010440003f0101ULL, 0x0001860000000004ULL, 0x00011a90003f0101ULL,
0x0001860000000004ULL, 0x00011c00003f0109ULL, 0x0001860000000004ULL, 0x00011f50003f0109ULL,
0x0001860000000004ULL, 0x00011f70003f0101ULL, 0x0001860000000004ULL, 0x000120e0003f0109ULL,
0x0001860000000004ULL, 0x000148d0003f0109ULL, 0x0001868800000006ULL, 0x00014aa0003f0101ULL,
0x0001868800000006ULL, 0x00014c10003f0109ULL, 0x0001868800000006ULL, 0x00015ee0003f0109ULL,
0x0001860800000008ULL, 0x00015ef0003f0101ULL, 0x0001861000000008ULL, 0x00015f00003f0101ULL,
0x0001861800000008ULL, 0x00015f10003f0101ULL, 0x0001862000000008ULL, 0x00053803003f0101ULL,
0x000103b000101c04ULL, 0x000121b000012110ULL, 0x000c050400015f30ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0048190300000000ULL, 0x0000001700080a04ULL, 0x0000000000480210ULL,
0x00000000000000bcULL, 0x0000001600000002ULL, 0x0000000000015f40ULL, 0x0000000000000044ULL,
0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001600000002ULL,
0x0000000000000000ULL, 0x0000000000018700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008400ff0e7b82ULL, 0x000ee20000000800ULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x0000000000007919ULL, 0x000ea20000002200ULL,
0x0000000000377919ULL, 0x000f2a0000002100ULL, 0x00008800ff067b82ULL, 0x000ee20000000a00ULL,
0x0000000000137919ULL, 0x000ee20000002700ULL, 0x0000000000057919ULL, 0x000eec0000000000ULL,
0x00000000000679c3ULL, 0x000ee20000002600ULL, 0x00000000000a7919ULL, 0x000ee20000008800ULL,
0x0000000403007c24ULL, 0x004fe2000f8e0200ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400027c24ULL, 0x110fe2000f8e0237ULL, 0x00000005ff377819ULL, 0x000fe20000011637ULL,
0x00001fff03007589ULL, 0x0005e600000e0000ULL, 0x0000007f0200780cULL, 0x040fe40003f64070ULL,
0x00001fff37377589ULL, 0x000f2200000e0000ULL, 0x000000ff0200720cULL, 0x040fe40003f45270ULL,
0x0000000f0200780cULL, 0x000fc40003f04070ULL, 0x000000030200780cULL, 0x040fe40003fa4070ULL,
0x000000010200780cULL, 0x000fc80003f84070ULL, 0x000000000009b919ULL, 0x000ea20000008800ULL,
0x000004000004b802ULL, 0x000fe20000000f00ULL, 0xff317217ff08b424ULL, 0x000fc600078e00ffULL,
0x000006540903b816ULL, 0x004fe20000000004ULL, 0x0000000400047824ULL, 0x010fe200078e0237ULL,
0x0000040000097802ULL, 0x000fc60000000f00ULL, 0x000000040203b824ULL, 0x000fe200078e0203ULL,
0x0000000000242947ULL, 0x00afec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01860008043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000380947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x00000004020b7c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x000000000b0712caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01860804073f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000385947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x00000004020b7c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x000000000b0712caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01868804073f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018400080300b388ULL, 0x0003e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ff8000000057882ULL, 0x000fc60000000000ULL, 0x0000000402027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffe0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x002fca0000000000ULL,
0x00000000020712caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0186a804073f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x0000000000242947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x004fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000eb40000000000ULL,
0x0186b808043f75b2ULL, 0x0004a40008000100ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000306047899ULL, 0x000fe2000800063fULL,
0x0000000204037824ULL, 0x002fe200078e00ffULL, 0x000006540a047816ULL, 0x000fe20000000009ULL,
0x000000080e027824ULL, 0x000fe200078e00ffULL, 0x0000820000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000103097824ULL, 0x040fe200078e0205ULL, 0x0000000803087848ULL, 0x000fe20007fe0000ULL,
0x00000020030c7824ULL, 0x000fe200078e00ffULL, 0x00000000040572caULL, 0x000fe200000e0000ULL,
0x0000000402027e24ULL, 0x000fe2000f8e0213ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000001030a7836ULL, 0x000fe20000000000ULL, 0xffffffe00c0f7812ULL, 0x000fe200078ee209ULL,
0x00000001020b7824ULL, 0x000fc400078e0203ULL, 0x00000001020d7824ULL, 0x000fe200078e020aULL,
0x0001860005047890ULL, 0x000fe2000fffe03fULL, 0x0000001005097824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fe400078e0a03ULL, 0x000002000b027825ULL, 0x100fe200078e0006ULL,
0x000001f009117812ULL, 0x000fe400078ec0ffULL, 0x000000ff0800720cULL, 0x040fe20003f03070ULL,
0x000002000d067825ULL, 0x000fe200078e0006ULL, 0x000000010800780cULL, 0x000fe20003f23070ULL,
0x00008c00ff0c7b82ULL, 0x000e640000000a00ULL, 0x000000010a0b7824ULL, 0x040fe200078e0205ULL,
0x0000001106067210ULL, 0x000fe20007f7e0ffULL, 0x000000200a107824ULL, 0x000fe200078e00ffULL,
0x00000011020a7210ULL, 0x000fe20007f5e0ffULL, 0x000000100f0f7824ULL, 0x000fc400078e0204ULL,
0x000000ffff077224ULL, 0x000fe200018e0607ULL, 0xffffffe010117812ULL, 0x000fe200078ee20bULL,
0x000000ffff0b7224ULL, 0x000fc800010e0603ULL, 0x0000001011117824ULL, 0x000fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0005e8000c101c48ULL,
0x0000000006117faeULL, 0x0005e2000c901c48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x0000000413027825ULL, 0x002fe200078e000cULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000802357981ULL, 0x000ee2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x000000ff35007836ULL, 0x008fca0000000000ULL, 0x00000008ff0f7819ULL, 0x004fce0000011600ULL,
0x000000f8008c8947ULL, 0x000fea0003800000ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000000837347824ULL, 0x000fe400078e00ffULL, 0x00000004ff027424ULL, 0x000fe400078e00ffULL,
0x0000000104037824ULL, 0x000fe400078e0234ULL, 0x000000060e077c36ULL, 0x000fe40008000000ULL,
0x0186880203ff79a7ULL, 0x0003e4000850003fULL, 0x0000000213027824ULL, 0x002fc800078e00ffULL,
0x0000000e02027224ULL, 0x000fe200078e0207ULL, 0x0000000000e80947ULL, 0x000fec0003800000ULL,
0x0000003435077248ULL, 0x000fe20007fe0000ULL, 0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL,
0x00000004ff007819ULL, 0x100fe20000011605ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x000000f009197812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x000fe400078e0a34ULL,
0x0000000200087836ULL, 0x000fe40000000000ULL, 0x00000004000a7836ULL, 0x000fe20000000000ULL,
0x000000070000720cULL, 0x080fe20003f66070ULL, 0x00000006000b7836ULL, 0x000fe20000000000ULL,
0x000000070800720cULL, 0x080fe20003f46070ULL, 0x0000000134087824ULL, 0x000fe200078e0208ULL,
0x000000070a00720cULL, 0x080fe20003f26070ULL, 0x0000000134067824ULL, 0x000fe200078e0200ULL,
0x000000070b00720cULL, 0x000fe20003f06070ULL, 0x0000000108077824ULL, 0x000fc400078e0205ULL,
0x00000010080e7824ULL, 0x000fe400078e00ffULL, 0x00000001340a7824ULL, 0x040fe400078e020aULL,
0x0000000134127824ULL, 0x000fe200078e020bULL, 0xfffffff00e0e7812ULL, 0x000fe200078ee207ULL,
0x0000000402077c24ULL, 0x000fe4000f8e0206ULL, 0x000000010a0b7824ULL, 0x040fe400078e0205ULL,
0x000000100a107824ULL, 0x000fc400078e00ffULL, 0x0000000106007824ULL, 0x040fe400078e0205ULL,
0x0000001006117824ULL, 0x000fe200078e00ffULL, 0xfffffff010107812ULL, 0x000fe200078ee20bULL,
0x0000010007067825ULL, 0x002fc600078e000cULL, 0xfffffff011007812ULL, 0x000fe200078ee200ULL,
0x0000000402097c24ULL, 0x040fe2000f8e0208ULL, 0x0000001906067210ULL, 0x000fe20007f9e0ffULL,
0x00000004020b7c24ULL, 0x040fe4000f8e020aULL, 0x0000000402137c24ULL, 0x000fe4000f8e0212ULL,
0x0000000112117824ULL, 0x040fe400078e0205ULL, 0x0000001012147824ULL, 0x000fe400078e00ffULL,
0x0000010009087825ULL, 0x000fc600078e000cULL, 0xfffffff014147812ULL, 0x000fe200078ee211ULL,
0x000001000b0a7825ULL, 0x000fc800078e000cULL, 0x00000100130c7825ULL, 0x000fe200078e000cULL,
0x000000190a0a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200020e0607ULL,
0x0000001908087210ULL, 0x000fe20007f9e0ffULL, 0x0001400004117836ULL, 0x000fe20000000000ULL,
0x000000190c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0b7224ULL, 0x000fe400028e060bULL,
0x0000001000137824ULL, 0x100fe400078e0211ULL, 0x000000100e157824ULL, 0x000fe400078e0211ULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006137faeULL, 0x0003e2000d901c48ULL, 0x0000001010177824ULL, 0x000fc400078e0211ULL,
0x0000001014117824ULL, 0x000fe200078e0211ULL, 0x0000000008157faeULL, 0x0003e2000d101c48ULL,
0x000000ffff0d7224ULL, 0x000fc600030e060dULL, 0x000000000a177faeULL, 0x0003e8000c901c48ULL,
0x000000000c117faeULL, 0x0003e2000c101c48ULL, 0x0000000000bc7947ULL, 0x000fea0003800000ULL,
0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL, 0x0000003405007211ULL, 0x000fe200078fe0ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x000000f009177812ULL, 0x000fe200078ec0ffULL,
0x0001400004197836ULL, 0x000fe40000000000ULL, 0x0000000100067824ULL, 0x040fe400078e0205ULL,
0x0000001000077824ULL, 0x000fe400078e00ffULL, 0x0000000200087836ULL, 0x000fc40000000000ULL,
0x00000004000a7836ULL, 0x000fe20000000000ULL, 0xfffffff0070e7812ULL, 0x000fe200078ee206ULL,
0x0000000108067824ULL, 0x140fe400078e0205ULL, 0x0000001008077824ULL, 0x000fe400078e00ffULL,
0x000000010a0b7824ULL, 0x040fe400078e0205ULL, 0x000000100a147824ULL, 0x000fe200078e00ffULL,
0xfffffff007107812ULL, 0x000fe200078ee206ULL, 0x0000000402077c24ULL, 0x000fc4000f8e0200ULL,
0x0000000600117836ULL, 0x000fe20000000000ULL, 0xfffffff014007812ULL, 0x000fe200078ee20bULL,
0x0000010007067825ULL, 0x002fc800078e000cULL, 0x0000000402097c24ULL, 0x040fe2000f8e0208ULL,
0x0000001706067210ULL, 0x000fe20007f1e0ffULL, 0x0000000111127824ULL, 0x040fe400078e0205ULL,
0x0000001011137824ULL, 0x000fe400078e00ffULL, 0x00000004020b7c24ULL, 0x040fe4000f8e020aULL,
0x0000000402117c24ULL, 0x000fe2000f8e0211ULL, 0xfffffff013127812ULL, 0x000fe200078ee212ULL,
0x0000010009087825ULL, 0x000fc800078e000cULL, 0x000001000b0a7825ULL, 0x000fc800078e000cULL,
0x00000100110c7825ULL, 0x000fe200078e000cULL, 0x000000170a0a7210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000001708087210ULL, 0x000fe20007f1e0ffULL,
0x000000100e117824ULL, 0x100fe200078e0219ULL, 0x000000170c0c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001010137824ULL, 0x000fe400078e0219ULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e2000b901c48ULL,
0x0000001000157824ULL, 0x000fe400078e0219ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000000008137faeULL, 0x0003e2000b901c48ULL, 0x0000001012177824ULL, 0x000fc400078e0219ULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000000a157faeULL, 0x0003e8000b901c48ULL,
0x000000000c177faeULL, 0x0003e4000b901c48ULL, 0x000186a805057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x00000001ff077424ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0186a807044879a7ULL, 0x0002a2000850003fULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0186b807040679a7ULL, 0x0022e2000850003fULL, 0x000000e400948947ULL, 0x000fea0003800000ULL,
0x000000ffff397224ULL, 0x008fe200078e0007ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0xff317217ff487424ULL, 0x004fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e00ffULL,
0x0000000804067899ULL, 0x000fcc000800063fULL, 0x0000000635007c0cULL, 0x000fda000bf03070ULL,
0x000000e4006c0947ULL, 0x002fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0186b839040075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001140bULL, 0x0000000a09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000209097819ULL, 0x000fc8000000120aULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x0186b839040075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x00008e00ff397b82ULL, 0x000ea20000000800ULL,
0x0000000104067890ULL, 0x000fe4000fffe03fULL, 0x0000002004077891ULL, 0x000fc8000f8e403fULL,
0x000000060f007c0cULL, 0x000fe4000bf23070ULL, 0x0000000702397e24ULL, 0x004fd6000f8e0239ULL,
0x0000000000f09947ULL, 0x000fea0003800000ULL, 0x0000000735067c48ULL, 0x000fe4000ffe0000ULL,
0x00000004ff0a7819ULL, 0x000fc60000011605ULL, 0x8000000706077c36ULL, 0x000fe40008000000ULL,
0x00000001340e7824ULL, 0x000fe400078e020aULL, 0x000000020a307836ULL, 0x000fe20000000000ULL,
0x0000000734077248ULL, 0x000fe20007fe0000ULL, 0x000000010e0b7824ULL, 0x040fe400078e0205ULL,
0x000000100e367824ULL, 0x000fe400078e00ffULL, 0x0000000107097824ULL, 0x000fc400078e0a34ULL,
0x00008a00ff067b82ULL, 0x000ea20000000a00ULL, 0x0000000134327824ULL, 0x000fe200078e0230ULL,
0xfffffff036367812ULL, 0x000fe200078ee20bULL, 0x000000060a317836ULL, 0x000fe20000000000ULL,
0x000000093000720cULL, 0x080fe20003f66070ULL, 0x000000040a307836ULL, 0x000fe20000000000ULL,
0x000000090a00720cULL, 0x080fe20003f86070ULL, 0x00000010050a7824ULL, 0x000fe200078e00ffULL,
0x000000093100720cULL, 0x080fe20003f06070ULL, 0x00000001320b7824ULL, 0x000fe200078e0205ULL,
0x000000093000720cULL, 0x000fe20003f46070ULL, 0x0000001032387824ULL, 0x000fe200078e00ffULL,
0x000000f00a3d7812ULL, 0x000fe200078ec0ffULL, 0x0000000134307824ULL, 0x000fc400078e0230ULL,
0x00000001340a7824ULL, 0x000fe200078e0231ULL, 0xfffffff038387812ULL, 0x000fe200078ee20bULL,
0x000000010e0b7824ULL, 0x100fe400078e0239ULL, 0x0000000132317824ULL, 0x100fe400078e0239ULL,
0x0000000130337824ULL, 0x100fe400078e0239ULL, 0x000000010a397824ULL, 0x040fe400078e0239ULL,
0x000000010a327824ULL, 0x000fc400078e0205ULL, 0x000000100a3b7824ULL, 0x000fe400078e00ffULL,
0x0000000130097824ULL, 0x040fe400078e0205ULL, 0x00000010300e7824ULL, 0x000fe200078e00ffULL,
0xfffffff03b3a7812ULL, 0x000fe200078ee232ULL, 0x000001000b0a7825ULL, 0x004fc600078e0006ULL,
0xfffffff00e0e7812ULL, 0x000fe200078ee209ULL, 0x0000010031307825ULL, 0x000fe200078e0006ULL,
0x0000003d0a0a7210ULL, 0x000fc60007fbe0ffULL, 0x0000010033327825ULL, 0x000fe200078e0006ULL,
0x0000003d30307210ULL, 0x000fc60007fde0ffULL, 0x0000010039067825ULL, 0x000fc800078e0006ULL,
0x0001600004097836ULL, 0x000fe40000000000ULL, 0x000000ffff0b7224ULL, 0x000fe200028e060bULL,
0x0000003d32327210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200030e0631ULL,
0x0000003d06067210ULL, 0x000fe20007fde0ffULL, 0x0000001036397824ULL, 0x100fe400078e0209ULL,
0x00000010383b7824ULL, 0x100fe400078e0209ULL, 0x000000100e3d7824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a397faeULL, 0x0005e2000e101c48ULL,
0x000000ffff337224ULL, 0x000fc400028e0633ULL, 0x000000103a097824ULL, 0x000fe200078e0209ULL,
0x00000000303b7faeULL, 0x0005e2000d901c48ULL, 0x000000ffff077224ULL, 0x000fc600030e0607ULL,
0x00000000323d7faeULL, 0x0005e8000d101c48ULL, 0x0000000006097faeULL, 0x0005e2000c101c48ULL,
0x0000000000bc7947ULL, 0x000fea0003800000ULL, 0x00008a00ff327b82ULL, 0x000ea20000000a00ULL,
0x0000003405067211ULL, 0x040fe200078fe0ffULL, 0x00000010050a7824ULL, 0x000fe400078e00ffULL,
0x00016000043f7836ULL, 0x000fe40000000000ULL, 0x0000000106077824ULL, 0x000fe200078e0205ULL,
0x000000f00a3d7812ULL, 0x000fe200078ec0ffULL, 0x00000010060e7824ULL, 0x000fe400078e00ffULL,
0x0000000206307836ULL, 0x000fc40000000000ULL, 0x0000000406387836ULL, 0x000fe20000000000ULL,
0xfffffff00e0e7812ULL, 0x000fe200078ee207ULL, 0x0000000106077824ULL, 0x000fe400078e0239ULL,
0x0000000130097824ULL, 0x040fe400078e0205ULL, 0x0000001030367824ULL, 0x040fe400078e00ffULL,
0x00000006063a7836ULL, 0x000fe40000000000ULL, 0x00000001300b7824ULL, 0x000fe200078e0239ULL,
0xfffffff036367812ULL, 0x000fe200078ee209ULL, 0x0000010007067825ULL, 0x004fc800078e0032ULL,
0x0000000138307824ULL, 0x040fe200078e0205ULL, 0x0000003d06067210ULL, 0x000fe20007f1e0ffULL,
0x00000010383b7824ULL, 0x040fe400078e00ffULL, 0x0000000138317824ULL, 0x100fe400078e0239ULL,
0x000000013a097824ULL, 0x000fe200078e0239ULL, 0xfffffff03b387812ULL, 0x000fe200078ee230ULL,
0x000001000b0a7825ULL, 0x000fc800078e0032ULL, 0x000000013a397824ULL, 0x000fe400078e0205ULL,
0x0000010031307825ULL, 0x000fc800078e0032ULL, 0x000000103a3a7824ULL, 0x000fe200078e00ffULL,
0x0000003d30307210ULL, 0x000fe20007f5e0ffULL, 0x0000010009327825ULL, 0x000fc600078e0032ULL,
0xfffffff03a3a7812ULL, 0x000fe200078ee239ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000003d0a0a7210ULL, 0x000fe20007f1e0ffULL, 0x000000100e097824ULL, 0x100fe200078e023fULL,
0x0000003d32327210ULL, 0x000fe20007f7e0ffULL, 0x0000001036397824ULL, 0x000fe400078e023fULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0005e2000b901c48ULL, 0x00000010383b7824ULL, 0x000fe400078e023fULL,
0x000000ffff317224ULL, 0x000fe200010e0631ULL, 0x000000000a397faeULL, 0x0005e2000b901c48ULL,
0x000000103a3d7824ULL, 0x000fc400078e023fULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x00000000303b7faeULL, 0x0005e8000b901c48ULL, 0x00000000323d7faeULL, 0x0005e4000b901c48ULL,
0x00000000040672caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x00000001ff307424ULL, 0x000fd600078e00ffULL, 0x000186b006067890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0186b030044c79a7ULL, 0x0004e4000850003fULL, 0x01860830033079a7ULL, 0x004464000850003fULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x01860831030075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e07ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001140bULL,
0x0000000a09097211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000209097819ULL, 0x000fc8000000120aULL, 0x000000090000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01860831030075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000001ff077819ULL, 0x000fe20000011605ULL, 0x0000001005067824ULL, 0x000fe400078e00ffULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000c07097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0048ULL, 0x0000007006077812ULL, 0x000fc800078ec0ffULL,
0x0000000409077210ULL, 0x000fca0007ffe007ULL, 0x0180000007097984ULL, 0x000e680000000800ULL,
0x01820000070b7984ULL, 0x0009220000000800ULL, 0x000000480900720bULL, 0x002fda0003f1d000ULL,
0x00000000000a7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0a307812ULL, 0x000fda000780c0ffULL,
0x0000000000e88947ULL, 0x01cfea0003800000ULL, 0x000000480900720bULL, 0x000fe40003f14000ULL,
0x000000ff3700720cULL, 0x000fe40003f45270ULL, 0x00000009484a7209ULL, 0x000fd20007810000ULL,
0x0000000000317806ULL, 0x000fe400000e0100ULL, 0x0184004a0700a388ULL, 0x0003e40000000800ULL,
0x00009910310a7816ULL, 0x000fc800000000ffULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000004a480a7221ULL, 0x000fe20000010000ULL,
0x000000ff31ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0031ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00337308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff0a7819ULL, 0x002fcc0000011605ULL,
0x00001f0a330a7589ULL, 0x004e6400000e0000ULL, 0x0000000a10107220ULL, 0x082fe20000410000ULL,
0x0000000a11117220ULL, 0x080fe20000410000ULL, 0x0000000a14147220ULL, 0x080fe20000410000ULL,
0x0000000a15157220ULL, 0x080fe20000410000ULL, 0x0000000a18187220ULL, 0x080fe20000410000ULL,
0x0000000a19197220ULL, 0x080fe20000410000ULL, 0x0000000a1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000a1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000a20207220ULL, 0x080fe20000410000ULL,
0x0000000a21217220ULL, 0x080fe20000410000ULL, 0x0000000a24247220ULL, 0x080fe20000410000ULL,
0x0000000a25257220ULL, 0x080fe20000410000ULL, 0x0000000a28287220ULL, 0x080fe20000410000ULL,
0x0000000a29297220ULL, 0x080fe20000410000ULL, 0x0000000a2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000a2d2d7220ULL, 0x000fce0000410000ULL, 0x0000003300007220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x00000008050a7811ULL, 0x002fcc00078ff0ffULL,
0x00001f0a330a7589ULL, 0x000e6400000e0000ULL, 0x0000000a12127220ULL, 0x082fe20000410000ULL,
0x0000000a13137220ULL, 0x080fe20000410000ULL, 0x0000000a16167220ULL, 0x080fe20000410000ULL,
0x0000000a17177220ULL, 0x080fe20000410000ULL, 0x0000000a1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000a1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000a1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000a1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000a22227220ULL, 0x080fe20000410000ULL,
0x0000000a23237220ULL, 0x080fe20000410000ULL, 0x0000000a26267220ULL, 0x080fe20000410000ULL,
0x0000000a27277220ULL, 0x080fe20000410000ULL, 0x0000000a2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000a2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000a2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000a2f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff30ff7812ULL, 0x000fda0007806031ULL,
0x8000004a09090221ULL, 0x000fe20000010000ULL, 0x00007610ff0e0816ULL, 0x000fc6000000000eULL,
0x3fb8aa3b09090820ULL, 0x000fc80000410000ULL, 0x0000000900080308ULL, 0x000ea40000000800ULL,
0x000000080b0b0220ULL, 0x004fce0000410000ULL, 0x000000000b007221ULL, 0x000fe20000010000ULL,
0x00000000000a7805ULL, 0x002fe20000015200ULL, 0x0186a849040075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff327224ULL, 0x000fce00078e00ffULL,
0x000000103200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x000000300a307210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e0bULL, 0x003d09003000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011431ULL,
0x0000003009097211ULL, 0x000fca00078110ffULL, 0x000000ffff307224ULL, 0x000fca00000e0631ULL,
0x0000000209097819ULL, 0x000fc80000001230ULL, 0x000000090000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000132327836ULL, 0x000fce0000000000ULL,
0x0186a849040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000705467812ULL, 0x040fe200078ec0ffULL, 0x0001400004407836ULL, 0x000fe20000000000ULL,
0x00000008050a7812ULL, 0x000fe400078ec0ffULL, 0x00000004ff097819ULL, 0x000fe40000011605ULL,
0x000099100e0b7816ULL, 0x000fe400000000ffULL, 0x0000000846467812ULL, 0x000fe200078ef805ULL,
0x0000000437447824ULL, 0x000fe200078e0209ULL, 0x000000070a4b7812ULL, 0x000fc400078ef805ULL,
0x000000ff0b00720cULL, 0x000fe20003f45270ULL, 0x0000000109457824ULL, 0x000fe200078e0246ULL,
0x0000000237487811ULL, 0x000fe200078e10ffULL, 0x00000008460e7824ULL, 0x000fe400078e00ffULL,
0x000000014b0a7824ULL, 0x040fe400078e0244ULL, 0x000000104b317824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0b7812ULL, 0x000fc800078ee245ULL, 0xfffffff031317812ULL, 0x000fe200078ee20aULL,
0x000000100b0a7824ULL, 0x000fc800078e0204ULL, 0x00000010310b7824ULL, 0x000fe200078e0240ULL,
0x0000000000182947ULL, 0x000fec0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x00000008ff0c723eULL, 0x000fc600000000ffULL, 0x000000080d317836ULL, 0x000fe20000000000ULL,
0x000054100c0e7816ULL, 0x000fca000000000cULL, 0x00001f0d0e0d7589ULL, 0x0002a800000e0000ULL,
0x00001f310e0c7589ULL, 0x0002e400000e0000ULL, 0x012000000a30783bULL, 0x0022e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x000000000b3c783bULL, 0x000f220000004200ULL,
0x0000000109427824ULL, 0x000fe400078e0248ULL, 0x000000104b397824ULL, 0x040fe400078e00ffULL,
0x000000014b0e7824ULL, 0x000fca00078e0242ULL, 0xfffffff039397812ULL, 0x000fca00078ee20eULL,
0x00000010390e7824ULL, 0x000fca00078e0240ULL, 0x000000000e38783bULL, 0x000f620000004200ULL,
0x00000018ff4f7819ULL, 0x010fe2000001143cULL, 0x000001003c517824ULL, 0x040fe200078e00ffULL,
0x000088803c527816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe2000001143dULL, 0x000001003d537824ULL, 0x040fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x000001003e547824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000088803d597816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff4e7819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003c00587306ULL, 0x0009e20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff497819ULL, 0x000fe4000001143fULL,
0x00000018ff477819ULL, 0x022fe40000011438ULL, 0x00000018ff367819ULL, 0x000fe20000011439ULL,
0x00000051005b7306ULL, 0x0003620000200c00ULL, 0x000001003f3c7824ULL, 0x010fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fc4000001143aULL, 0x000088803b617816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000088803e517816ULL, 0x042fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fc8000001143bULL, 0x00000018ff577819ULL, 0x000fe2000001143eULL,
0x0000005300607306ULL, 0x0003220000200c00ULL, 0x00008880383e7816ULL, 0x000fce00000000ffULL,
0x0000003d005d7306ULL, 0x0009e20000200c00ULL, 0x000088803f537816ULL, 0x042fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000005400567306ULL, 0x0003e20000200c00ULL, 0x00000100383d7824ULL, 0x054fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c005e7306ULL, 0x0005e20000200c00ULL, 0x0000888039547816ULL, 0x002fe400000000ffULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000004f004f7306ULL, 0x000e620000200c00ULL,
0x00000100393c7824ULL, 0x044fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001143cULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fca00000000ffULL,
0x0000003f005c7306ULL, 0x000ff00000200c00ULL, 0x00000038005a7306ULL, 0x000bf00000200c00ULL,
0x00000039003f7306ULL, 0x0009e20000200c00ULL, 0x0000541052387816ULL, 0x028fe2000000005bULL,
0x000000ffff527224ULL, 0x000fcc00078e0061ULL, 0x0000005100517306ULL, 0x000ee20000200c00ULL,
0x0000541059397816ULL, 0x010fe20000000060ULL, 0x000001003b597824ULL, 0x040fe400078e00ffULL,
0x000100003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000005300537306ULL, 0x000f220000200c00ULL, 0x000000383010723cULL, 0x000fe20000001810ULL,
0x00000018ff3b7819ULL, 0x000fcc000001143bULL, 0x0000541058387816ULL, 0x002fe2000000004fULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x000054105d397816ULL, 0x004fce0000000050ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x000000383014723cULL, 0x000fee0000001814ULL,
0x0000005700577306ULL, 0x000ea20000200c00ULL, 0x0000541051387816ULL, 0x008fe40000000056ULL,
0x0000541053397816ULL, 0x010fc4000000005eULL, 0x000054105c4f7816ULL, 0x002fc60000000049ULL,
0x0000003d00557306ULL, 0x0003e20000200c00ULL, 0x000000104b497812ULL, 0x000fe200078efcffULL,
0x000000383018723cULL, 0x000fe20000001818ULL, 0x00005410574e7816ULL, 0x004fca000000004eULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000001003a3d7824ULL, 0x042fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fe400078e00ffULL, 0x0000000245397836ULL, 0x000fe20000000000ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000004e301c723cULL, 0x000fe2000000181cULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000004700477306ULL, 0x000e6a0000200c00ULL,
0x00000008464e7824ULL, 0x000fe200078e00ffULL, 0x000054103e5e7816ULL, 0x004fc40000000055ULL,
0x0000003600367306ULL, 0x000ea40000200c00ULL, 0xfffffff84e397812ULL, 0x000fe400078ee239ULL,
0x000054105a3e7816ULL, 0x002fc80000000047ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000000144477824ULL, 0x000fe200078e0249ULL, 0x000054103f3f7816ULL, 0x004fcc0000000036ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000001049367824ULL, 0x000fca00078e00ffULL,
0xfffffff036477812ULL, 0x000fe200078ee247ULL, 0x0000001039367824ULL, 0x000fe200078e0204ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x0000003e3024723cULL, 0x000fe20000001824ULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000004300437306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000ff00000200c00ULL, 0x0000005f005f7306ULL, 0x000e700000200c00ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x00005410545f7816ULL, 0x002fce000000005fULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x0000005e3020723cULL, 0x000fee0000001820ULL,
0x0000003a003a7306ULL, 0x000ea20000200c00ULL, 0x00005410523d7816ULL, 0x002fce0000000059ULL,
0x0000003b00387306ULL, 0x000e620000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103a3a7816ULL, 0x004fe20000000041ULL, 0x0000001047417824ULL, 0x000fe200078e0240ULL,
0x00005410383b7816ULL, 0x002fce0000000043ULL, 0x0000003a302c723cULL, 0x000fe2000000182cULL,
0x012000003630783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x084fe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x0000004849487210ULL, 0x040fe20007ffe009ULL,
0x0000001049497824ULL, 0x000fe200078e00ffULL, 0x00000000413c783bULL, 0x000ee80000004200ULL,
0xfffffff049487812ULL, 0x000fca00078ee248ULL, 0x0000001048407824ULL, 0x000fca00078e0240ULL,
0x000000004038783bULL, 0x000f220000004200ULL, 0x00000018ff587819ULL, 0x008fe2000001143cULL,
0x000001003c507824ULL, 0x040fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe2000001143dULL,
0x000001003d517824ULL, 0x040fe200078e00ffULL, 0x000088803c5b7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d607816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff4e7819ULL, 0x010fe40000011438ULL,
0x0000888038527816ULL, 0x000fe200000000ffULL, 0x0000003c005f7306ULL, 0x0007e20000200c00ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff567819ULL, 0x000fe4000001143fULL,
0x000088803f5c7816ULL, 0x000fc400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe20000011439ULL,
0x0000003d00647306ULL, 0x0009e20000200c00ULL, 0x000001003f3c7824ULL, 0x008fe200078e00ffULL,
0x0000888039547816ULL, 0x000fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000088803e5a7816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000100383d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fc4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005000627306ULL, 0x0007e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff437819ULL, 0x000fe4000001143aULL, 0x00000018ff497819ULL, 0x000fc6000001143bULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000001003e507824ULL, 0x048fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005100657306ULL, 0x000ee20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c00637306ULL, 0x0009f00000200c00ULL, 0x0000003800517306ULL, 0x000be20000200c00ULL,
0x00000100393c7824ULL, 0x050fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe4000001143cULL, 0x0000005900597306ULL, 0x000f220000200c00ULL,
0x000001003b387824ULL, 0x022fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000050005d7306ULL, 0x000ff00000200c00ULL, 0x0000003f00617306ULL, 0x000ff00000200c00ULL,
0x0000003900507306ULL, 0x0007f00000200c00ULL, 0x00000038003f7306ULL, 0x0003e20000200c00ULL,
0x0000541060397816ULL, 0x008fce0000000065ULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x000054105b387816ULL, 0x002fce0000000062ULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x000000383010723cULL, 0x004fee0000001810ULL, 0x0000003d00537306ULL, 0x0005e20000200c00ULL,
0x000054105f387816ULL, 0x000fe40000000058ULL, 0x0000541064397816ULL, 0x010fca0000000059ULL,
0x0000003e005e7306ULL, 0x0009e20000200c00ULL, 0x000001003a3d7824ULL, 0x044fe200078e00ffULL,
0x000000383014723cULL, 0x000fe20000001814ULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x000088803b3e7816ULL, 0x050fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x000054105a387816ULL, 0x008fe4000000005dULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x000054105c397816ULL, 0x002fce0000000063ULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x000000383018723cULL, 0x000fee0000001818ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054105e387816ULL, 0x004fe40000000057ULL, 0x0000541061397816ULL, 0x008fc40000000056ULL,
0x0000541052527816ULL, 0x002fc60000000053ULL, 0x0000003d003d7306ULL, 0x000e640000200c00ULL,
0x00000038301c723cULL, 0x000fec000000181cULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x0186b839043879a7ULL, 0x000ee2000850003fULL,
0x00005410514e7816ULL, 0x004fcc000000004eULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x00005410504f7816ULL, 0x002fce000000004fULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000004e3024723cULL, 0x000fee0000001824ULL, 0x0000005400547306ULL, 0x000ff00000200c00ULL,
0x0000005500557306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0000541054537816ULL, 0x002fce0000000055ULL, 0x0000003a003a7306ULL, 0x000e620000200c00ULL,
0x000000523020723cULL, 0x000fe20000001820ULL, 0x000054103e3d7816ULL, 0x004fcc000000003fULL,
0x0000003b00587306ULL, 0x000ea20000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103a3a7816ULL, 0x002fe40000000043ULL, 0x00005410583b7816ULL, 0x004fce0000000049ULL,
0x0000003a302c723cULL, 0x000fee000000182cULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b839040075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fdc0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186b839040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008e00ff437b82ULL, 0x000e620000000800ULL,
0x00000020070a7890ULL, 0x000fcc000fffe03fULL, 0x0000000a02437e24ULL, 0x002fe2000f8e0243ULL,
0x0000000000e89947ULL, 0x000fec0003800000ULL, 0x00008a00ff307b82ULL, 0x000e620000000a00ULL,
0x0000000134387824ULL, 0x000fe200078e0209ULL, 0x000000f006497812ULL, 0x000fe200078ec0ffULL,
0x00000002094f7836ULL, 0x000fe40000000000ULL, 0x0000000138327824ULL, 0x040fe400078e0205ULL,
0x0000001038397824ULL, 0x000fe400078e00ffULL, 0x00000001343a7824ULL, 0x000fe400078e024fULL,
0x0000000409517836ULL, 0x000fe20000000000ULL, 0xfffffff0393e7812ULL, 0x000fe200078ee232ULL,
0x000000013a337824ULL, 0x040fe200078e0205ULL, 0x0000000a35327c48ULL, 0x000fe2000ffe0000ULL,
0x000000103a4e7824ULL, 0x000fc400078e00ffULL, 0x0000000609537836ULL, 0x000fe40000000000ULL,
0x00000001383b7824ULL, 0x000fe200078e0243ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee233ULL,
0x8000000a32337c36ULL, 0x000fe40008000000ULL, 0x0000000134327824ULL, 0x040fe400078e0251ULL,
0x00000001343c7824ULL, 0x000fe200078e0253ULL, 0x0000003334397248ULL, 0x000fe20007fe0000ULL,
0x0000000132387824ULL, 0x000fc400078e0205ULL, 0x0000001032557824ULL, 0x000fe400078e00ffULL,
0x000000013a3d7824ULL, 0x100fe400078e0243ULL, 0x00000001323f7824ULL, 0x000fe200078e0243ULL,
0xfffffff055507812ULL, 0x000fe200078ee238ULL, 0x000000013c3a7824ULL, 0x040fe400078e0205ULL,
0x000000103c577824ULL, 0x000fe400078e00ffULL, 0x000001003b327825ULL, 0x002fc600078e0030ULL,
0xfffffff057527812ULL, 0x000fe200078ee23aULL, 0x000000013c437824ULL, 0x000fe200078e0243ULL,
0x0000004932327210ULL, 0x000fe20007f9e0ffULL, 0x00000001393c7824ULL, 0x000fe400078e0a34ULL,
0x000001003d387825ULL, 0x000fc600078e0030ULL, 0x0000003c4f00720cULL, 0x080fe20003f06070ULL,
0x000001003f3a7825ULL, 0x000fe200078e0030ULL, 0x0000004938387210ULL, 0x000fe40007fde0ffULL,
0x0000003c5100720cULL, 0x080fe20003f66070ULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x0000003c0900720cULL, 0x000fe20003f86070ULL, 0x0000010043307825ULL, 0x000fe200078e0030ULL,
0x000000493a3a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x0000003c5300720cULL, 0x000fe20003fc6070ULL, 0x00014000043d7836ULL, 0x000fe40000000000ULL,
0x000000ffff3b7224ULL, 0x000fe200028e063bULL, 0x0000004930307210ULL, 0x000fe20007fbe0ffULL,
0x000000103e3f7824ULL, 0x100fe400078e023dULL, 0x000000104e437824ULL, 0x100fe400078e023dULL,
0x0000001050497824ULL, 0x100fe200078e023dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000323f7faeULL, 0x0003e2000e101c48ULL, 0x00000010523d7824ULL, 0x000fc400078e023dULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x0000000038437faeULL, 0x0003e8000c101c48ULL,
0x000000003a497faeULL, 0x0003e8000d901c48ULL, 0x00000000303d7faeULL, 0x0003e2000f101c48ULL,
0x0000000000b87947ULL, 0x000fea0003800000ULL, 0x00008a00ff307b82ULL, 0x000e620000000a00ULL,
0x00000001343a7824ULL, 0x000fe200078e0209ULL, 0x000000f0064f7812ULL, 0x000fe200078ec0ffULL,
0x0001400004497836ULL, 0x000fe40000000000ULL, 0x000000023a327836ULL, 0x000fe40000000000ULL,
0x000000013a387824ULL, 0x140fe400078e0205ULL, 0x000000103a397824ULL, 0x000fe400078e00ffULL,
0x0000000132337824ULL, 0x000fc400078e0205ULL, 0x00000010323c7824ULL, 0x000fe200078e00ffULL,
0xfffffff0394e7812ULL, 0x000fe200078ee238ULL, 0x000000043a387836ULL, 0x000fe40000000000ULL,
0x000000063a3e7836ULL, 0x000fe20000000000ULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee233ULL,
0x000000013a337824ULL, 0x000fe400078e0243ULL, 0x0000000143397824ULL, 0x040fe400078e0232ULL,
0x00000001433b7824ULL, 0x000fc400078e0238ULL, 0x00000001433d7824ULL, 0x000fe400078e023eULL,
0x00000001383a7824ULL, 0x140fe400078e0205ULL, 0x00000010383f7824ULL, 0x000fe400078e00ffULL,
0x000000013e387824ULL, 0x040fe400078e0205ULL, 0x000000103e437824ULL, 0x000fe200078e00ffULL,
0xfffffff03f3e7812ULL, 0x000fe200078ee23aULL, 0x0000010033327825ULL, 0x002fc600078e0030ULL,
0xfffffff043437812ULL, 0x000fe200078ee238ULL, 0x0000010039387825ULL, 0x000fe200078e0030ULL,
0x0000004f32327210ULL, 0x000fc60007f1e0ffULL, 0x000001003b3a7825ULL, 0x000fc800078e0030ULL,
0x000001003d307825ULL, 0x000fe200078e0030ULL, 0x0000004f3a3a7210ULL, 0x000fc60007f7e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e0633ULL, 0x0000004f38387210ULL, 0x000fe20007f1e0ffULL,
0x000000104e517824ULL, 0x100fe200078e0249ULL, 0x0000004f30307210ULL, 0x000fe20007f9e0ffULL,
0x000000103c3d7824ULL, 0x000fe400078e0249ULL, 0x000000ffff397224ULL, 0x000fe200000e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032517faeULL, 0x0003e2000b901c48ULL,
0x000000103e3f7824ULL, 0x000fe400078e0249ULL, 0x000000ffff3b7224ULL, 0x000fe200018e063bULL,
0x00000000383d7faeULL, 0x0003e2000b901c48ULL, 0x0000001043437824ULL, 0x000fc400078e0249ULL,
0x000000ffff317224ULL, 0x000fe200020e0631ULL, 0x000000003a3f7faeULL, 0x0003e8000b901c48ULL,
0x0000000030437faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0186a831043079a7ULL, 0x000e64000850003fULL,
0x000000ffff497224ULL, 0x002fe200078e0031ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b04d040075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186b04d040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000445307836ULL, 0x000fe40000000000ULL,
0x0000000846317824ULL, 0x000fe400078e00ffULL, 0x000000014b447824ULL, 0x040fe400078e0244ULL,
0x000000104b437824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee230ULL,
0x00016000044c7836ULL, 0x000fc60000000000ULL, 0xfffffff043437812ULL, 0x000fe200078ee244ULL,
0x0000001031447824ULL, 0x000fe200078e0204ULL, 0x0000000000182947ULL, 0x000fec0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe40000011605ULL, 0x00000008ff0c723eULL, 0x000fc600000000ffULL,
0x000000080d317836ULL, 0x000fe20000000000ULL, 0x000054100c307816ULL, 0x000fca000000000cULL,
0x00001f0d300d7589ULL, 0x0002a800000e0000ULL, 0x00001f31300c7589ULL, 0x0002e400000e0000ULL,
0x012000004430783bULL, 0x0022e20000000200ULL, 0x0000001043437824ULL, 0x000fe200078e024cULL,
0x0000000000102947ULL, 0x000fec0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x00000000433c783bULL, 0x000f220000004200ULL,
0x000000014b427824ULL, 0x040fe400078e0242ULL, 0x000000104b397824ULL, 0x000fe400078e00ffULL,
0x0000000645457836ULL, 0x000fe40000000000ULL, 0x0000000846467824ULL, 0x000fe200078e00ffULL,
0xfffffff039397812ULL, 0x000fe200078ee242ULL, 0x0000001047477824ULL, 0x000fc600078e024cULL,
0xfffffff846457812ULL, 0x000fe200078ee245ULL, 0x0000001039427824ULL, 0x000fc800078e024cULL,
0x0000001045457824ULL, 0x000fe200078e0204ULL, 0x000000004238783bULL, 0x000f620000004200ULL,
0x00000018ff587819ULL, 0x010fe2000001143cULL, 0x000001003c507824ULL, 0x040fe200078e00ffULL,
0x000088803c5b7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe2000001143dULL, 0x000001003d517824ULL, 0x040fe200078e00ffULL,
0x000088803d617816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff557819ULL, 0x000fe2000001143fULL,
0x0000003c005f7306ULL, 0x0009e20000200c00ULL, 0x000088803f5a7816ULL, 0x000fe200000000ffULL,
0x000001003b657824ULL, 0x022fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011438ULL,
0x00000018ff4f7819ULL, 0x000fc40000011439ULL, 0x0000888038527816ULL, 0x000fe200000000ffULL,
0x0000005000607306ULL, 0x0003620000200c00ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x000088803e597816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe4000001143eULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000001003e507824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fc4000001143aULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005100647306ULL, 0x0003220000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff4d7819ULL, 0x000fca000001143bULL, 0x0000003d00627306ULL, 0x0009e20000200c00ULL,
0x0000888039517816ULL, 0x002fce00000000ffULL, 0x0000003c00637306ULL, 0x0003e20000200c00ULL,
0x00000100383d7824ULL, 0x054fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x00000100393c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe4000001143cULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fca00000000ffULL, 0x00000050005c7306ULL, 0x000ff00000200c00ULL,
0x0000003f005e7306ULL, 0x000ff00000200c00ULL, 0x00000038003f7306ULL, 0x000bf00000200c00ULL,
0x0000003900507306ULL, 0x0009e20000200c00ULL, 0x000054105b387816ULL, 0x028fc40000000060ULL,
0x00000018ff5b7819ULL, 0x000fca0000011465ULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x0000541061397816ULL, 0x010fce0000000064ULL, 0x0000005a005a7306ULL, 0x000f220000200c00ULL,
0x000000383010723cULL, 0x000fee0000001810ULL, 0x000054105f387816ULL, 0x004fe20000000058ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x0000541062397816ULL, 0x002fce0000000057ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x000000383014723cULL, 0x000fee0000001814ULL,
0x0000003e005d7306ULL, 0x0002a20000200c00ULL, 0x0000541059387816ULL, 0x008fe4000000005cULL,
0x000054105a397816ULL, 0x010fca0000000063ULL, 0x0000003d00537306ULL, 0x0007e20000200c00ULL,
0x000088803b3e7816ULL, 0x042fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383018723cULL, 0x000fe80000001818ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x000001003a3d7824ULL, 0x048fe200078e00ffULL,
0x000054105d387816ULL, 0x004fe20000000056ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000054105e397816ULL, 0x000fc40000000055ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000003c003c7306ULL, 0x000fe40000200c00ULL,
0x00000038301c723cULL, 0x000fe2000000181cULL, 0x0000541052527816ULL, 0x002fca0000000053ULL,
0x0000003d003d7306ULL, 0x000e700000200c00ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000004f004f7306ULL, 0x000e620000200c00ULL,
0x000054103f4e7816ULL, 0x004fce000000004eULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00005410504f7816ULL, 0x002fce000000004fULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x0000004e3024723cULL, 0x000fee0000001824ULL, 0x0000005100517306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0000541051537816ULL, 0x002fce0000000054ULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x000000523020723cULL, 0x000fee0000001820ULL, 0x0000003a003a7306ULL, 0x000ea20000200c00ULL,
0x000054103e3d7816ULL, 0x002fce000000005bULL, 0x0000003b00387306ULL, 0x000e620000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054103a3a7816ULL, 0x004fe4000000004bULL,
0x00005410383b7816ULL, 0x002fce000000004dULL, 0x0000003a302c723cULL, 0x000fe2000000182cULL,
0x012000004530783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x084fe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x00000000473c783bULL, 0x000ee20000004200ULL,
0x0000001048467824ULL, 0x000fe200078e024cULL, 0x00000020070a7890ULL, 0x000fc8000fffe03fULL,
0x000000004638783bULL, 0x000f240000004200ULL, 0x0000000a35007c0cULL, 0x000fe4000bf03070ULL,
0x00000018ff517819ULL, 0x008fe2000001143cULL, 0x000001003c527824ULL, 0x040fe200078e00ffULL,
0x000088803c567816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe2000001143dULL, 0x000001003d537824ULL, 0x040fe200078e00ffULL,
0x000088803d5a7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x000001003b637824ULL, 0x010fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff4e7819ULL, 0x000fe2000001143fULL, 0x0000003c005e7306ULL, 0x0007e20000200c00ULL,
0x000088803f597816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011438ULL,
0x00000018ff4d7819ULL, 0x000fe40000011439ULL, 0x0000888039557816ULL, 0x000fe200000000ffULL,
0x00000052005b7306ULL, 0x0009620000200c00ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000088803e547816ULL, 0x000fc400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000001003e527824ULL, 0x050fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe4000001143aULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000005300617306ULL, 0x0007220000200c00ULL, 0x00000018ff3e7819ULL, 0x000fc4000001143eULL,
0x00000018ff4b7819ULL, 0x000fca000001143bULL, 0x0000003d005f7306ULL, 0x0009e20000200c00ULL,
0x0000888038537816ULL, 0x008fce00000000ffULL, 0x0000003c00627306ULL, 0x0007e20000200c00ULL,
0x00000100383d7824ULL, 0x054fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x00000100393c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff607819ULL, 0x000fe4000001143cULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000005200577306ULL, 0x000fe20000200c00ULL,
0x000088803a3c7816ULL, 0x000fce00000000ffULL, 0x0000003f005d7306ULL, 0x000ff00000200c00ULL,
0x00000038003f7306ULL, 0x000bf00000200c00ULL, 0x0000003900527306ULL, 0x0007e20000200c00ULL,
0x0000541056387816ULL, 0x022fc4000000005bULL, 0x00000018ff5b7819ULL, 0x000fca0000011463ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x000054105a397816ULL, 0x008fce0000000061ULL,
0x0000003d00587306ULL, 0x0007e20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x000054105f397816ULL, 0x004fe20000000050ULL, 0x000001003a3d7824ULL, 0x008fe200078e00ffULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x000100003b507824ULL, 0x000fe200078e00ffULL,
0x000054105e387816ULL, 0x002fe20000000051ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x000000383014723cULL, 0x000fec0000001814ULL, 0x0000003e005c7306ULL, 0x0007e20000200c00ULL,
0x0000541054387816ULL, 0x004fc40000000057ULL, 0x0000541059397816ULL, 0x002fca0000000062ULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000088803b3e7816ULL, 0x008fe200000000ffULL,
0x000000383018723cULL, 0x000fec0000001818ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000054105c387816ULL, 0x002fce000000004fULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x00000001ff4f7424ULL, 0x000fe200078e00ffULL, 0x000054105d397816ULL, 0x004fcc000000004eULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x00000038301c723cULL, 0x000fee000000181cULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0186b84f043879a7ULL, 0x0004ae000850003fULL,
0x0000003a003b7306ULL, 0x000ee20000200c00ULL, 0x0186884f04ff79a7ULL, 0x0005e2000850003fULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000054103b3a7816ULL, 0x008fce0000000048ULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x000000ffff487224ULL, 0x000fe200078e004aULL, 0x000054103f4c7816ULL, 0x002fcc000000004cULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x00005410524d7816ULL, 0x008fce000000004dULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x0000004c3024723cULL, 0x000fee0000001824ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x0000541053547816ULL, 0x002fce0000000058ULL,
0x0000006000607306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0000541055557816ULL, 0x002fce0000000060ULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x000000543020723cULL, 0x000fee0000001820ULL, 0x0000005000507306ULL, 0x000ee20000200c00ULL,
0x000054103e3d7816ULL, 0x002fce000000005bULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x00005410503b7816ULL, 0x008fce000000004bULL, 0x0000003a302c723cULL, 0x000fe2000000182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000000a800500947ULL, 0x004fde0003800000ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b839040075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b839040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff3f7b82ULL, 0x000e620000000800ULL, 0x00000040070a7890ULL, 0x000fcc000fffe03fULL,
0x0000000a023f7e24ULL, 0x002fe2000f8e023fULL, 0x0000000000e89947ULL, 0x000fec0003800000ULL,
0x0000000134387824ULL, 0x000fe200078e0209ULL, 0x0000000a35327c48ULL, 0x000fe2000ffe0000ULL,
0x00000002094b7836ULL, 0x000fe40000000000ULL, 0x0000000138307824ULL, 0x040fe400078e0205ULL,
0x00000010384d7824ULL, 0x000fe400078e00ffULL, 0x8000000a32337c36ULL, 0x000fe40008000000ULL,
0x0000000409517836ULL, 0x000fe20000000000ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee230ULL,
0x0000000134327824ULL, 0x040fe200078e024bULL, 0x00008a00ff307b82ULL, 0x000e620000000a00ULL,
0x00000001343a7824ULL, 0x000fe200078e0251ULL, 0x0000003334337248ULL, 0x000fe20007fe0000ULL,
0x0000000138397824ULL, 0x000fc400078e023fULL, 0x00000001323b7824ULL, 0x040fe400078e023fULL,
0x0000000132387824ULL, 0x040fe400078e0205ULL, 0x00000010324f7824ULL, 0x000fe400078e00ffULL,
0x000000013a3d7824ULL, 0x040fe400078e023fULL, 0x000000013a327824ULL, 0x040fe200078e0205ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee238ULL, 0x000000103a537824ULL, 0x000fc400078e00ffULL,
0x0000000609557836ULL, 0x000fe40000000000ULL, 0x00000001333a7824ULL, 0x000fe200078e0a34ULL,
0xfffffff053537812ULL, 0x000fe200078ee232ULL, 0x00000001343c7824ULL, 0x000fc600078e0255ULL,
0x0000003a4b00720cULL, 0x080fe20003f66070ULL, 0x0000010039327825ULL, 0x102fe200078e0030ULL,
0x000000f0064b7812ULL, 0x000fe400078ec0ffULL, 0x0000003a5100720cULL, 0x080fe20003f46070ULL,
0x000001003b387825ULL, 0x000fe200078e0030ULL, 0x0000003a5500720cULL, 0x080fe40003f06070ULL,
0x0000003a0900720cULL, 0x000fe20003f86070ULL, 0x000000013c3f7824ULL, 0x000fe200078e023fULL,
0x0000004b32327210ULL, 0x000fe20007fbe0ffULL, 0x000001003d3a7825ULL, 0x000fe200078e0030ULL,
0x0000004b38387210ULL, 0x000fc60007fde0ffULL, 0x000000013c3e7824ULL, 0x040fe400078e0205ULL,
0x000000103c577824ULL, 0x000fe400078e00ffULL, 0x000001003f307825ULL, 0x000fc600078e0030ULL,
0xfffffff057577812ULL, 0x000fe200078ee23eULL, 0x00016000043c7836ULL, 0x000fe40000000000ULL,
0x000000ffff337224ULL, 0x000fe200028e0633ULL, 0x0000004b3a3a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000004b30307210ULL, 0x000fe20007fde0ffULL,
0x000000104d4d7824ULL, 0x100fe400078e023cULL, 0x000000104f4f7824ULL, 0x100fe400078e023cULL,
0x0000001053537824ULL, 0x000fe200078e023cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000324d7faeULL, 0x0003e2000e101c48ULL, 0x000000ffff3b7224ULL, 0x000fc400028e063bULL,
0x0000001057577824ULL, 0x000fe200078e023cULL, 0x00000000384f7faeULL, 0x0003e2000d901c48ULL,
0x000000ffff317224ULL, 0x000fc600030e0631ULL, 0x000000003a537faeULL, 0x0003e8000d101c48ULL,
0x0000000030577faeULL, 0x0003e2000c101c48ULL, 0x0000000000b87947ULL, 0x000fea0003800000ULL,
0x00008a00ff327b82ULL, 0x000e620000000a00ULL, 0x0000000134307824ULL, 0x000fe200078e0209ULL,
0x000000f0064d7812ULL, 0x000fc600078ec0ffULL, 0x0000000230387836ULL, 0x000fe40000000000ULL,
0x0000000130317824ULL, 0x140fe400078e0205ULL, 0x00000010303c7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0205ULL, 0x00000010383e7824ULL, 0x000fe200078e00ffULL,
0xfffffff03c3c7812ULL, 0x000fe200078ee231ULL, 0x00000004303a7836ULL, 0x000fc40000000000ULL,
0x0000000630487836ULL, 0x000fe20000000000ULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee239ULL,
0x0000000130317824ULL, 0x100fe400078e023fULL, 0x0000000138397824ULL, 0x100fe400078e023fULL,
0x000000013a3b7824ULL, 0x100fe400078e023fULL, 0x00000001483d7824ULL, 0x000fe400078e023fULL,
0x000000013a387824ULL, 0x000fc400078e0205ULL, 0x000000103a3f7824ULL, 0x000fe400078e00ffULL,
0x0000010031307825ULL, 0x002fc800078e0032ULL, 0x00000001483a7824ULL, 0x040fe200078e0205ULL,
0x0000004d30307210ULL, 0x000fe20007f1e0ffULL, 0x00000010484b7824ULL, 0x000fe200078e00ffULL,
0xfffffff03f487812ULL, 0x000fe200078ee238ULL, 0x0000010039387825ULL, 0x000fc600078e0032ULL,
0xfffffff04b4c7812ULL, 0x000fe200078ee23aULL, 0x000001003b3a7825ULL, 0x000fc800078e0032ULL,
0x000001003d327825ULL, 0x000fe200078e0032ULL, 0x0000004d3a3a7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e0631ULL, 0x0000004d38387210ULL, 0x000fe20007f1e0ffULL,
0x00016000044b7836ULL, 0x000fe20000000000ULL, 0x0000004d32327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400010e063bULL, 0x000000103c4f7824ULL, 0x100fe400078e024bULL,
0x000000103e3d7824ULL, 0x000fe400078e024bULL, 0x000000ffff397224ULL, 0x000fe200000e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000304f7faeULL, 0x0003e2000b901c48ULL,
0x00000010483f7824ULL, 0x000fc400078e024bULL, 0x000000104c4b7824ULL, 0x000fe200078e024bULL,
0x00000000383d7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff337224ULL, 0x000fc600018e0633ULL,
0x000000003a3f7faeULL, 0x0003e8000b901c48ULL, 0x00000000324b7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0186b038044c79a7ULL, 0x0002a4000850003fULL, 0x01862838033879a7ULL, 0x0022e4000850003fULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x01862839030075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01862839030075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0180800007317984ULL, 0x000ee20000000800ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0x000000ffff487224ULL, 0x000fe200078e004aULL, 0x0182800007337984ULL, 0x0009220000000800ULL,
0x0000004a3100720bULL, 0x008fda0003f1d000ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x016fea0003800000ULL,
0x000000013700780cULL, 0x000fe40003f45270ULL, 0x0000004a3100720bULL, 0x000fd60003f14000ULL,
0x0000004a3130a209ULL, 0x000fe40007810000ULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x018480300700a388ULL, 0x0003e20000000800ULL, 0x0000991038327816ULL, 0x000fc800000000ffULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000004a313b7209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000784c0ffULL, 0x0000004a3b307221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x00000030003b7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc0000011605ULL,
0x00001f303b307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b00007220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000805307811ULL, 0x002fcc00078ff0ffULL,
0x00001f303b307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000004a31487209ULL, 0x000fd60007810000ULL,
0x8000004831310221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100080308ULL, 0x000ea40000000800ULL,
0x0000000833330220ULL, 0x004fce0000410000ULL, 0x0000000033007221ULL, 0x000fe20000010000ULL,
0x0000000000307805ULL, 0x002fe20000015200ULL, 0x0186a849040075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186a849040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991038307816ULL, 0x000fc800000000ffULL, 0x000000ff3000720cULL, 0x000fda0003f45270ULL,
0x0000000000182947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x00000008ff0c723eULL, 0x000fc600000000ffULL, 0x000000080d317836ULL, 0x000fe20000000000ULL,
0x000054100c307816ULL, 0x000fca000000000cULL, 0x00001f0d300d7589ULL, 0x0002a800000e0000ULL,
0x00001f31300c7589ULL, 0x0002e400000e0000ULL, 0x012800000a30783bULL, 0x0022e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x000000000b3c783bULL, 0x000f280000004200ULL,
0x000000000e38783bULL, 0x000f620000004200ULL, 0x00000018ff537819ULL, 0x010fe2000001143cULL,
0x000001003c4f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe2000001143dULL,
0x000001003d507824ULL, 0x040fe200078e00ffULL, 0x000088803c577816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d5e7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x022fe20000011438ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000888038567816ULL, 0x000fe400000000ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000003c005c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff527819ULL, 0x000fe4000001143eULL,
0x00000018ff517819ULL, 0x000fc4000001143fULL, 0x000088803e557816ULL, 0x000fe200000000ffULL,
0x0000003d00617306ULL, 0x0009e20000200c00ULL, 0x000001003f3c7824ULL, 0x042fe200078e00ffULL,
0x000088803f597816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011439ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x00000100383d7824ULL, 0x050fe200078e00ffULL,
0x0000888039587816ULL, 0x000fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc4000001143fULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004f00607306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff497819ULL, 0x000fe4000001143aULL, 0x00000018ff4a7819ULL, 0x000fc6000001143bULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000001003e4f7824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000005000637306ULL, 0x000e620000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c00647306ULL, 0x0009f00000200c00ULL, 0x0000003800507306ULL, 0x000be20000200c00ULL,
0x00000100393c7824ULL, 0x050fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143cULL, 0x0000005400547306ULL, 0x000f220000200c00ULL,
0x000001003b387824ULL, 0x068fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003e005f7306ULL, 0x0007f00000200c00ULL, 0x0000003d005b7306ULL, 0x000be20000200c00ULL,
0x000088803b3e7816ULL, 0x048fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000004f005a7306ULL, 0x000fe20000200c00ULL,
0x000001003a3d7824ULL, 0x064fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003f00627306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x00000039004f7306ULL, 0x0003f00000200c00ULL,
0x00000038003f7306ULL, 0x0005e20000200c00ULL, 0x000054105e397816ULL, 0x002fce0000000063ULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x0000541057387816ULL, 0x004fce0000000060ULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x000054105c387816ULL, 0x000fe20000000053ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000541061397816ULL, 0x010fce0000000054ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000000383014723cULL, 0x000fee0000001814ULL, 0x0000003d003d7306ULL, 0x000ee20000200c00ULL,
0x0000541055387816ULL, 0x002fe4000000005aULL, 0x0000541059397816ULL, 0x004fca0000000064ULL,
0x0000005200527306ULL, 0x000e640000200c00ULL, 0x000000383018723cULL, 0x000fe20000001818ULL,
0x000054103c3c7816ULL, 0x008fca000000003dULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x0000541062397816ULL, 0x000fe40000000051ULL, 0x000054105f387816ULL, 0x002fca0000000052ULL,
0x0000004e004e7306ULL, 0x000e640000200c00ULL, 0x00000038301c723cULL, 0x000fe2000000181cULL,
0x0000541050507816ULL, 0x004fca000000004bULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054104f517816ULL, 0x002fce000000004eULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000000503024723cULL, 0x000fee0000001824ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000541056567816ULL, 0x002fce000000005bULL,
0x0000005d005d7306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0000541058577816ULL, 0x002fce000000005dULL, 0x0000003a003a7306ULL, 0x000e620000200c00ULL,
0x000000563020723cULL, 0x000fe20000001820ULL, 0x000054103e3d7816ULL, 0x004fcc000000003fULL,
0x0000003b003b7306ULL, 0x000ea20000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103a3a7816ULL, 0x002fe40000000049ULL, 0x000054103b3b7816ULL, 0x004fce000000004aULL,
0x0000003a302c723cULL, 0x000fe2000000182cULL, 0x012800003630783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000c31317232ULL, 0x080fe40000000000ULL, 0x0000000c33337232ULL, 0x000fce0000000000ULL,
0x00000000413c783bULL, 0x000ee80000004200ULL, 0x000000004038783bULL, 0x000f220000004200ULL,
0x00000018ff537819ULL, 0x008fe2000001143cULL, 0x000001003c4f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe2000001143dULL, 0x000001003d507824ULL, 0x040fe200078e00ffULL,
0x000088803c577816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d5e7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x010fe20000011438ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888038567816ULL, 0x000fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000003c005c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000018ff517819ULL, 0x000fe4000001143fULL, 0x000088803f597816ULL, 0x000fc400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011439ULL, 0x0000003d00617306ULL, 0x0009e20000200c00ULL,
0x000001003f3c7824ULL, 0x008fe200078e00ffULL, 0x0000888039587816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe4000001143eULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00000100383d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x000088803e557816ULL, 0x000fc400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004f00607306ULL, 0x0007e20000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff497819ULL, 0x000fe4000001143aULL,
0x00000018ff4a7819ULL, 0x000fc6000001143bULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000001003e4f7824ULL, 0x048fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000005000637306ULL, 0x000ee20000200c00ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003c00647306ULL, 0x0009f00000200c00ULL,
0x0000003800507306ULL, 0x000be20000200c00ULL, 0x00000100393c7824ULL, 0x050fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001143cULL,
0x0000005400547306ULL, 0x000f220000200c00ULL, 0x000001003b387824ULL, 0x022fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004f005a7306ULL, 0x000ff00000200c00ULL,
0x0000003f00627306ULL, 0x000ff00000200c00ULL, 0x00000039004f7306ULL, 0x0007f00000200c00ULL,
0x00000038003f7306ULL, 0x0003e20000200c00ULL, 0x000054105e397816ULL, 0x008fce0000000063ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x0000541057387816ULL, 0x002fce0000000060ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000000383010723cULL, 0x004fee0000001810ULL,
0x0000003e005f7306ULL, 0x0005e20000200c00ULL, 0x000054105c387816ULL, 0x000fe40000000053ULL,
0x0000541061397816ULL, 0x010fca0000000054ULL, 0x0000003d005b7306ULL, 0x0009e20000200c00ULL,
0x000088803b3e7816ULL, 0x044fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383014723cULL, 0x000fe80000001814ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x000001003a3d7824ULL, 0x050fe200078e00ffULL,
0x0000541055387816ULL, 0x008fe2000000005aULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541059397816ULL, 0x002fc40000000064ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000000383018723cULL, 0x000fea0000001818ULL, 0x0000003c003c7306ULL, 0x000fe40000200c00ULL,
0x000054105f387816ULL, 0x004fc40000000052ULL, 0x0000541062397816ULL, 0x002fc80000000051ULL,
0x0000003d003d7306ULL, 0x000e660000200c00ULL, 0x00000038301c723cULL, 0x000fea000000181cULL,
0x0000004b004b7306ULL, 0x000ea40000200c00ULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x000054103c3c7816ULL, 0x002fca000000003dULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x0186b839043879a7ULL, 0x000ee2000850003fULL, 0x0000541050507816ULL, 0x004fcc000000004bULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000054104f517816ULL, 0x002fce000000004eULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x000000503024723cULL, 0x000fee0000001824ULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x0000541056567816ULL, 0x002fce000000005bULL, 0x0000005d005d7306ULL, 0x000e700000200c00ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000541058577816ULL, 0x002fce000000005dULL,
0x0000003a003a7306ULL, 0x000e620000200c00ULL, 0x000000563020723cULL, 0x000fe20000001820ULL,
0x000054103e3d7816ULL, 0x004fcc000000003fULL, 0x0000003b003b7306ULL, 0x000ea20000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054103a3a7816ULL, 0x002fe40000000049ULL,
0x000054103b3b7816ULL, 0x004fce000000004aULL, 0x0000003a302c723cULL, 0x000fee000000182cULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b839040075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fdc0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186b839040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff497b82ULL, 0x000e620000000800ULL, 0x00000060070a7890ULL, 0x000fcc000fffe03fULL,
0x0000000a02497e24ULL, 0x002fe2000f8e0249ULL, 0x0000000000e89947ULL, 0x000fec0003800000ULL,
0x00008a00ff307b82ULL, 0x000e620000000a00ULL, 0x0000000134387824ULL, 0x000fe200078e0209ULL,
0x000000f0064b7812ULL, 0x000fe200078ec0ffULL, 0x00000002094f7836ULL, 0x000fe40000000000ULL,
0x0000000138327824ULL, 0x040fe400078e0205ULL, 0x0000001038397824ULL, 0x000fe400078e00ffULL,
0x00000001343a7824ULL, 0x000fe400078e024fULL, 0x0000000409517836ULL, 0x000fe20000000000ULL,
0xfffffff0393e7812ULL, 0x000fe200078ee232ULL, 0x000000013a337824ULL, 0x040fe200078e0205ULL,
0x0000000a35327c48ULL, 0x000fe2000ffe0000ULL, 0x000000103a4a7824ULL, 0x000fc400078e00ffULL,
0x0000000609537836ULL, 0x000fe40000000000ULL, 0x00000001383b7824ULL, 0x000fe200078e0249ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee233ULL, 0x8000000a32337c36ULL, 0x000fe40008000000ULL,
0x0000000134327824ULL, 0x040fe400078e0251ULL, 0x00000001343c7824ULL, 0x000fe200078e0253ULL,
0x0000003334397248ULL, 0x000fe20007fe0000ULL, 0x0000000132387824ULL, 0x000fc400078e0205ULL,
0x0000001032557824ULL, 0x000fe400078e00ffULL, 0x000000013a3d7824ULL, 0x100fe400078e0249ULL,
0x00000001323f7824ULL, 0x000fe200078e0249ULL, 0xfffffff0554e7812ULL, 0x000fe200078ee238ULL,
0x000000013c3a7824ULL, 0x040fe400078e0205ULL, 0x000000103c577824ULL, 0x000fe400078e00ffULL,
0x000001003b327825ULL, 0x002fc600078e0030ULL, 0xfffffff057507812ULL, 0x000fe200078ee23aULL,
0x000000013c497824ULL, 0x000fe200078e0249ULL, 0x0000004b32327210ULL, 0x000fe20007f9e0ffULL,
0x00000001393c7824ULL, 0x000fe400078e0a34ULL, 0x000001003d387825ULL, 0x000fc600078e0030ULL,
0x0000003c4f00720cULL, 0x080fe20003f06070ULL, 0x000001003f3a7825ULL, 0x000fe200078e0030ULL,
0x0000004b38387210ULL, 0x000fe40007fde0ffULL, 0x0000003c5100720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200020e0633ULL, 0x0000003c0900720cULL, 0x000fe20003f86070ULL,
0x0000010049307825ULL, 0x000fe200078e0030ULL, 0x0000004b3a3a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000003c5300720cULL, 0x000fe20003fc6070ULL,
0x00014000043d7836ULL, 0x000fe40000000000ULL, 0x000000ffff3b7224ULL, 0x000fe200028e063bULL,
0x0000004b30307210ULL, 0x000fe20007fbe0ffULL, 0x000000103e3f7824ULL, 0x100fe400078e023dULL,
0x000000104a497824ULL, 0x100fe400078e023dULL, 0x000000104e4b7824ULL, 0x100fe200078e023dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000323f7faeULL, 0x0003e2000e101c48ULL,
0x00000010503d7824ULL, 0x000fc400078e023dULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x0000000038497faeULL, 0x0003e8000c101c48ULL, 0x000000003a4b7faeULL, 0x0003e8000d901c48ULL,
0x00000000303d7faeULL, 0x0003e2000f101c48ULL, 0x0000000000b87947ULL, 0x000fea0003800000ULL,
0x00008a00ff307b82ULL, 0x000e620000000a00ULL, 0x0000000134327824ULL, 0x000fe200078e0209ULL,
0x000000f0063f7812ULL, 0x000fc600078ec0ffULL, 0x0000000232387836ULL, 0x000fe40000000000ULL,
0x0000000132337824ULL, 0x140fe400078e0205ULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0205ULL, 0x00000010383c7824ULL, 0x000fe200078e00ffULL,
0xfffffff03a4b7812ULL, 0x000fe200078ee233ULL, 0x00000004323a7836ULL, 0x000fc40000000000ULL,
0x0000000132337824ULL, 0x100fe200078e0249ULL, 0xfffffff03c4f7812ULL, 0x000fe200078ee239ULL,
0x00000006323c7836ULL, 0x000fe40000000000ULL, 0x00000001383b7824ULL, 0x100fe400078e0249ULL,
0x000000013a397824ULL, 0x100fe400078e0249ULL, 0x000000013c3d7824ULL, 0x000fe400078e0249ULL,
0x000000013a387824ULL, 0x000fc400078e0205ULL, 0x000000103a497824ULL, 0x000fe400078e00ffULL,
0x000000013c3a7824ULL, 0x040fe400078e0205ULL, 0x000000103c517824ULL, 0x000fe200078e00ffULL,
0xfffffff049497812ULL, 0x000fe200078ee238ULL, 0x0000010033327825ULL, 0x002fc600078e0030ULL,
0xfffffff051517812ULL, 0x000fe200078ee23aULL, 0x000001003b3a7825ULL, 0x000fe200078e0030ULL,
0x0000003f32327210ULL, 0x000fc60007f1e0ffULL, 0x0000010039387825ULL, 0x000fc800078e0030ULL,
0x000001003d307825ULL, 0x000fe200078e0030ULL, 0x0000003f38387210ULL, 0x000fc60007f7e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e0633ULL, 0x0000003f3a3a7210ULL, 0x000fe20007f1e0ffULL,
0x00014000043c7836ULL, 0x000fe20000000000ULL, 0x0000003f30307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe400018e0639ULL, 0x000000104b4b7824ULL, 0x100fe400078e023cULL,
0x000000104f4f7824ULL, 0x100fe400078e023cULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000324b7faeULL, 0x0003e2000b901c48ULL,
0x0000001049497824ULL, 0x000fc400078e023cULL, 0x0000001051517824ULL, 0x000fe200078e023cULL,
0x000000003a4f7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff317224ULL, 0x000fc600020e0631ULL,
0x0000000038497faeULL, 0x0003e8000b901c48ULL, 0x0000000030517faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff317424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0186a831043079a7ULL, 0x000e64000850003fULL, 0x000000ffff497224ULL, 0x002fe200078e0031ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b04d040075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b04d040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000182947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x00000008ff0c723eULL, 0x000fc600000000ffULL, 0x000000080d317836ULL, 0x000fe20000000000ULL,
0x000054100c307816ULL, 0x000fca000000000cULL, 0x00001f0d300d7589ULL, 0x0002a800000e0000ULL,
0x00001f31300c7589ULL, 0x0002e400000e0000ULL, 0x012800004430783bULL, 0x0022e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x00000000433c783bULL, 0x000f280000004200ULL,
0x000000004238783bULL, 0x000f620000004200ULL, 0x00000018ff537819ULL, 0x010fe2000001143dULL,
0x000001003d4f7824ULL, 0x040fe200078e00ffULL, 0x000088803d5e7816ULL, 0x040fe200000000ffULL,
0x000001003c4e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe2000001143cULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x000088803c577816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x022fe20000011438ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000888038557816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000003d00627306ULL, 0x0003e20000200c00ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x00000018ff507819ULL, 0x000fe4000001143fULL,
0x000088803f587816ULL, 0x000fc400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011439ULL,
0x0000003c005d7306ULL, 0x0009e20000200c00ULL, 0x00000100383d7824ULL, 0x042fe200078e00ffULL,
0x0000888039567816ULL, 0x000fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe4000001143eULL, 0x000088803e547816ULL, 0x000fe400000000ffULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004e00607306ULL, 0x0003220000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff4a7819ULL, 0x000fe4000001143aULL, 0x00000018ff4b7819ULL, 0x000fc6000001143bULL,
0x0000004f00637306ULL, 0x000f620000200c00ULL, 0x000001003e4e7824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000003c00617306ULL, 0x0003e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x00000038004f7306ULL, 0x0009e20000200c00ULL, 0x00000100393c7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001143cULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x000001003b387824ULL, 0x014fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x040fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005300537306ULL, 0x000eb00000200c00ULL,
0x0000003d005a7306ULL, 0x0009f00000200c00ULL, 0x0000003f005f7306ULL, 0x000fe20000200c00ULL,
0x000001003a3d7824ULL, 0x010fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004e00597306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x00000038003f7306ULL, 0x0009f00000200c00ULL,
0x00000039004e7306ULL, 0x000be20000200c00ULL, 0x0000541057387816ULL, 0x010fe20000000060ULL,
0x000100003b577824ULL, 0x000fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000005400547306ULL, 0x000f220000200c00ULL, 0x000054105e397816ULL, 0x028fce0000000063ULL,
0x0000005800587306ULL, 0x000ee20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x0000003e005c7306ULL, 0x000be20000200c00ULL, 0x000054105d387816ULL, 0x002fe40000000052ULL,
0x0000541062397816ULL, 0x004fca0000000053ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000088803b3e7816ULL, 0x020fe200000000ffULL, 0x000000383014723cULL, 0x000fec0000001814ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000541054387816ULL, 0x010fe40000000059ULL,
0x0000541058397816ULL, 0x008fca0000000061ULL, 0x0000005100517306ULL, 0x000ea40000200c00ULL,
0x000000383018723cULL, 0x000fe20000001818ULL, 0x000054103c3c7816ULL, 0x002fca000000003dULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000054105c387816ULL, 0x004fce0000000051ULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x000054105f397816ULL, 0x002fce0000000050ULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x00000038301c723cULL, 0x000fe2000000181cULL,
0x000054104f4c7816ULL, 0x004fcc000000004cULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000054104e4d7816ULL, 0x002fce000000004dULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000004c3024723cULL, 0x000fee0000001824ULL, 0x0000005500557306ULL, 0x000e700000200c00ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x00005410555a7816ULL, 0x002fce000000005aULL,
0x0000005b005b7306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x00005410565b7816ULL, 0x002fce000000005bULL, 0x0000003a003b7306ULL, 0x000e620000200c00ULL,
0x0000005a3020723cULL, 0x000fe20000001820ULL, 0x000054103e3d7816ULL, 0x004fcc000000003fULL,
0x0000005700527306ULL, 0x000ea20000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103b4a7816ULL, 0x002fe4000000004aULL, 0x00005410524b7816ULL, 0x004fce000000004bULL,
0x0000004a302c723cULL, 0x000fe2000000182cULL, 0x012800004530783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000c31317232ULL, 0x080fe40000000000ULL, 0x0000000c33337232ULL, 0x000fce0000000000ULL,
0x00000000473c783bULL, 0x000ee20000004200ULL, 0x00000060070a7890ULL, 0x000fc6000fffe03fULL,
0x000000004638783bULL, 0x000f260000004200ULL, 0x0000000a35007c0cULL, 0x000fe4000bf03070ULL,
0x00000018ff517819ULL, 0x008fe2000001143cULL, 0x000001003c527824ULL, 0x040fe200078e00ffULL,
0x000088803c567816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe2000001143dULL, 0x000001003d537824ULL, 0x040fe200078e00ffULL,
0x000088803d5a7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x000001003b637824ULL, 0x010fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff4e7819ULL, 0x000fe2000001143fULL, 0x0000003c005e7306ULL, 0x0007e20000200c00ULL,
0x000088803f597816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011438ULL,
0x00000018ff4d7819ULL, 0x000fe40000011439ULL, 0x0000888039557816ULL, 0x000fe200000000ffULL,
0x00000052005b7306ULL, 0x0009620000200c00ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000088803e547816ULL, 0x000fc400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000001003e527824ULL, 0x050fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001143aULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000005300617306ULL, 0x0007220000200c00ULL, 0x00000018ff3e7819ULL, 0x000fc4000001143eULL,
0x00000018ff4b7819ULL, 0x000fca000001143bULL, 0x0000003d005f7306ULL, 0x0009e20000200c00ULL,
0x0000888038537816ULL, 0x008fce00000000ffULL, 0x0000003c00627306ULL, 0x0007e20000200c00ULL,
0x00000100383d7824ULL, 0x054fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x00000100393c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff607819ULL, 0x000fe4000001143cULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000005200577306ULL, 0x000fe20000200c00ULL,
0x000088803a3c7816ULL, 0x000fce00000000ffULL, 0x0000003f005d7306ULL, 0x000ff00000200c00ULL,
0x00000038003f7306ULL, 0x000bf00000200c00ULL, 0x0000003900527306ULL, 0x0007e20000200c00ULL,
0x0000541056387816ULL, 0x022fc4000000005bULL, 0x00000018ff5b7819ULL, 0x000fca0000011463ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x000054105a397816ULL, 0x008fce0000000061ULL,
0x0000003d00587306ULL, 0x0007e20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x000054105f397816ULL, 0x004fe20000000050ULL, 0x000001003a3d7824ULL, 0x008fe200078e00ffULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x000100003b507824ULL, 0x000fe200078e00ffULL,
0x000054105e387816ULL, 0x002fe20000000051ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x000000383014723cULL, 0x000fec0000001814ULL, 0x0000003e005c7306ULL, 0x0007e20000200c00ULL,
0x0000541054387816ULL, 0x004fc40000000057ULL, 0x0000541059397816ULL, 0x002fca0000000062ULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000088803b3e7816ULL, 0x008fe200000000ffULL,
0x000000383018723cULL, 0x000fec0000001818ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000054105c387816ULL, 0x002fce000000004fULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x00000001ff4f7424ULL, 0x000fe200078e00ffULL, 0x000054105d397816ULL, 0x004fcc000000004eULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00000038301c723cULL, 0x000fee000000181cULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x0186b84f043879a7ULL, 0x0006e2000850003fULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x0186904f04ff79a7ULL, 0x0007e2000850003fULL, 0x000054103f4c7816ULL, 0x004fcc000000004cULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x00005410524d7816ULL, 0x002fce000000004dULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000004c3024723cULL, 0x000fee0000001824ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x0000541053547816ULL, 0x002fce0000000058ULL, 0x0000006000607306ULL, 0x000e700000200c00ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000541055557816ULL, 0x002fce0000000060ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x000000543020723cULL, 0x000fee0000001820ULL,
0x0000003a003b7306ULL, 0x000ea20000200c00ULL, 0x000054103e3d7816ULL, 0x002fce000000005bULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103b4a7816ULL, 0x004fe4000000004aULL, 0x00005410504b7816ULL, 0x002fce000000004bULL,
0x0000004a302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000007000340947ULL, 0x008fde0003800000ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b839040075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186b839040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008e00ff3f7b82ULL, 0x000e620000000800ULL,
0x00000080070a7890ULL, 0x000fcc000fffe03fULL, 0x0000000a023f7e24ULL, 0x002fe2000f8e023fULL,
0x0000000000e89947ULL, 0x000fec0003800000ULL, 0x0000000134387824ULL, 0x000fe200078e0209ULL,
0x0000000a35327c48ULL, 0x000fe2000ffe0000ULL, 0x00000002094b7836ULL, 0x000fe40000000000ULL,
0x0000000138307824ULL, 0x040fe400078e0205ULL, 0x00000010384d7824ULL, 0x000fe400078e00ffULL,
0x8000000a32337c36ULL, 0x000fe40008000000ULL, 0x0000000409517836ULL, 0x000fe20000000000ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee230ULL, 0x0000000134327824ULL, 0x040fe200078e024bULL,
0x00008a00ff307b82ULL, 0x000e620000000a00ULL, 0x00000001343a7824ULL, 0x000fe200078e0251ULL,
0x0000003334337248ULL, 0x000fe20007fe0000ULL, 0x0000000138397824ULL, 0x000fc400078e023fULL,
0x00000001323b7824ULL, 0x040fe400078e023fULL, 0x0000000132387824ULL, 0x040fe400078e0205ULL,
0x00000010324f7824ULL, 0x000fe400078e00ffULL, 0x000000013a3d7824ULL, 0x040fe400078e023fULL,
0x000000013a327824ULL, 0x040fe200078e0205ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee238ULL,
0x000000103a537824ULL, 0x000fc400078e00ffULL, 0x0000000609557836ULL, 0x000fe40000000000ULL,
0x00000001333a7824ULL, 0x000fe200078e0a34ULL, 0xfffffff053537812ULL, 0x000fe200078ee232ULL,
0x00000001343c7824ULL, 0x000fc600078e0255ULL, 0x0000003a4b00720cULL, 0x080fe20003f66070ULL,
0x0000010039327825ULL, 0x102fe200078e0030ULL, 0x000000f0064b7812ULL, 0x000fe400078ec0ffULL,
0x0000003a5100720cULL, 0x080fe20003f46070ULL, 0x000001003b387825ULL, 0x000fe200078e0030ULL,
0x0000003a5500720cULL, 0x080fe40003f06070ULL, 0x0000003a0900720cULL, 0x000fe20003f86070ULL,
0x000000013c3f7824ULL, 0x000fe200078e023fULL, 0x0000004b32327210ULL, 0x000fe20007fbe0ffULL,
0x000001003d3a7825ULL, 0x000fe200078e0030ULL, 0x0000004b38387210ULL, 0x000fc60007fde0ffULL,
0x000000013c3e7824ULL, 0x040fe400078e0205ULL, 0x000000103c577824ULL, 0x000fe400078e00ffULL,
0x000001003f307825ULL, 0x000fc600078e0030ULL, 0xfffffff057577812ULL, 0x000fe200078ee23eULL,
0x00016000043c7836ULL, 0x000fe40000000000ULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x0000004b3a3a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x0000004b30307210ULL, 0x000fe20007fde0ffULL, 0x000000104d4d7824ULL, 0x100fe400078e023cULL,
0x000000104f4f7824ULL, 0x100fe400078e023cULL, 0x0000001053537824ULL, 0x000fe200078e023cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000324d7faeULL, 0x0003e2000e101c48ULL,
0x000000ffff3b7224ULL, 0x000fc400028e063bULL, 0x0000001057577824ULL, 0x000fe200078e023cULL,
0x00000000384f7faeULL, 0x0003e2000d901c48ULL, 0x000000ffff317224ULL, 0x000fc600030e0631ULL,
0x000000003a537faeULL, 0x0003e8000d101c48ULL, 0x0000000030577faeULL, 0x0003e2000c101c48ULL,
0x0000000000b87947ULL, 0x000fea0003800000ULL, 0x00008a00ff307b82ULL, 0x000e620000000a00ULL,
0x0000000134327824ULL, 0x000fc800078e0209ULL, 0x0000000232387836ULL, 0x000fe40000000000ULL,
0x0000000132337824ULL, 0x140fe400078e0205ULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0205ULL, 0x00000010383c7824ULL, 0x000fe200078e00ffULL,
0xfffffff03a4b7812ULL, 0x000fe200078ee233ULL, 0x00000004323a7836ULL, 0x000fc40000000000ULL,
0x0000000132337824ULL, 0x100fe200078e023fULL, 0xfffffff03c4d7812ULL, 0x000fe200078ee239ULL,
0x00000006323c7836ULL, 0x000fe40000000000ULL, 0x00000001383b7824ULL, 0x100fe400078e023fULL,
0x000000013a397824ULL, 0x040fe400078e023fULL, 0x000000013a387824ULL, 0x040fe400078e0205ULL,
0x000000103a4f7824ULL, 0x000fc400078e00ffULL, 0x000000013c3d7824ULL, 0x000fe200078e023fULL,
0x000000f0063f7812ULL, 0x000fe200078ec0ffULL, 0x000000013c3a7824ULL, 0x040fe200078e0205ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee238ULL, 0x000000103c517824ULL, 0x000fe400078e00ffULL,
0x0000010033327825ULL, 0x002fc600078e0030ULL, 0xfffffff051517812ULL, 0x000fe200078ee23aULL,
0x000001003b3a7825ULL, 0x000fe200078e0030ULL, 0x0000003f32327210ULL, 0x000fc60007f1e0ffULL,
0x0000010039387825ULL, 0x000fc800078e0030ULL, 0x000001003d307825ULL, 0x000fe200078e0030ULL,
0x0000003f38387210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x0000003f3a3a7210ULL, 0x000fe20007f1e0ffULL, 0x00016000043c7836ULL, 0x000fe20000000000ULL,
0x0000003f30307210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff397224ULL, 0x000fe400010e0639ULL,
0x000000104b4b7824ULL, 0x100fe400078e023cULL, 0x000000104d4d7824ULL, 0x100fe400078e023cULL,
0x000000ffff3b7224ULL, 0x000fe200000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000324b7faeULL, 0x0003e2000b901c48ULL, 0x000000104f4f7824ULL, 0x000fc400078e023cULL,
0x0000001051517824ULL, 0x000fe200078e023cULL, 0x000000003a4d7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff317224ULL, 0x000fc600018e0631ULL, 0x00000000384f7faeULL, 0x0003e8000b901c48ULL,
0x0000000030517faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0186b038044a79a7ULL, 0x0002a4000850003fULL,
0x01864838033879a7ULL, 0x0022e4000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01864839030075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01864839030075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0181000007317984ULL, 0x000ee20000000800ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x0183000007337984ULL, 0x0009220000000800ULL,
0x000000483100720bULL, 0x008fda0003f1d000ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x016fea0003800000ULL,
0x000000023700780cULL, 0x000fe40003f45270ULL, 0x000000483100720bULL, 0x000fd60003f14000ULL,
0x000000314830a209ULL, 0x000fe40007810000ULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x018500300700a388ULL, 0x0003e20000000800ULL, 0x0000991038327816ULL, 0x000fc800000000ffULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x00000031483b7209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000784c0ffULL, 0x8000003b48307221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x00000030003b7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc0000011605ULL,
0x00001f303b307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b00007220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000805307811ULL, 0x002fcc00078ff0ffULL,
0x00001f303b307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000003148487209ULL, 0x000fd60007810000ULL,
0x8000004831310221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100080308ULL, 0x000ea40000000800ULL,
0x0000000833330220ULL, 0x004fce0000410000ULL, 0x0000000033007221ULL, 0x000fe20000010000ULL,
0x0000000000307805ULL, 0x002fe20000015200ULL, 0x0186a849040075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186a849040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991038307816ULL, 0x000fc800000000ffULL, 0x000000ff3000720cULL, 0x000fda0003f45270ULL,
0x0000000000182947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x00000008ff0c723eULL, 0x000fc600000000ffULL, 0x000000080d317836ULL, 0x000fe20000000000ULL,
0x000054100c307816ULL, 0x000fca000000000cULL, 0x00001f0d300d7589ULL, 0x0002a800000e0000ULL,
0x00001f31300c7589ULL, 0x0002e400000e0000ULL, 0x013000000a30783bULL, 0x0022e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x000000000b3c783bULL, 0x000f280000004200ULL,
0x000000000e38783bULL, 0x000f620000004200ULL, 0x00000018ff537819ULL, 0x010fe2000001143cULL,
0x000001003c4f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe2000001143dULL,
0x000001003d507824ULL, 0x040fe200078e00ffULL, 0x000088803c577816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d5e7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x022fe20000011438ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000888038567816ULL, 0x000fe400000000ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000003c005c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff527819ULL, 0x000fe4000001143eULL,
0x00000018ff517819ULL, 0x000fc4000001143fULL, 0x000088803e557816ULL, 0x000fe200000000ffULL,
0x0000003d00617306ULL, 0x0009e20000200c00ULL, 0x000001003f3c7824ULL, 0x042fe200078e00ffULL,
0x000088803f597816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011439ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x00000100383d7824ULL, 0x050fe200078e00ffULL,
0x0000888039587816ULL, 0x000fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc4000001143fULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004f00607306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff497819ULL, 0x000fe4000001143aULL, 0x00000018ff4c7819ULL, 0x000fc6000001143bULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000001003e4f7824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000005000637306ULL, 0x000e620000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c00647306ULL, 0x0009f00000200c00ULL, 0x0000003800507306ULL, 0x000be20000200c00ULL,
0x00000100393c7824ULL, 0x050fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143cULL, 0x0000005400547306ULL, 0x000f220000200c00ULL,
0x000001003b387824ULL, 0x068fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003e005f7306ULL, 0x0007f00000200c00ULL, 0x0000003d005b7306ULL, 0x000be20000200c00ULL,
0x000088803b3e7816ULL, 0x048fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000004f005a7306ULL, 0x000fe20000200c00ULL,
0x000001003a3d7824ULL, 0x064fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003f00627306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x00000039004f7306ULL, 0x0003f00000200c00ULL,
0x00000038003f7306ULL, 0x0005e20000200c00ULL, 0x000054105e397816ULL, 0x002fce0000000063ULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x0000541057387816ULL, 0x004fce0000000060ULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x000054105c387816ULL, 0x000fe20000000053ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000541061397816ULL, 0x010fce0000000054ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000000383014723cULL, 0x000fee0000001814ULL, 0x0000003d003d7306ULL, 0x000ee20000200c00ULL,
0x0000541055387816ULL, 0x002fe4000000005aULL, 0x0000541059397816ULL, 0x004fca0000000064ULL,
0x0000005200527306ULL, 0x000e640000200c00ULL, 0x000000383018723cULL, 0x000fe20000001818ULL,
0x000054103c3c7816ULL, 0x008fca000000003dULL, 0x0000004d004d7306ULL, 0x000ea20000200c00ULL,
0x0000541062397816ULL, 0x000fe40000000051ULL, 0x000054105f387816ULL, 0x002fca0000000052ULL,
0x0000004e004e7306ULL, 0x000e640000200c00ULL, 0x00000038301c723cULL, 0x000fe2000000181cULL,
0x0000541050507816ULL, 0x004fca000000004dULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054104f517816ULL, 0x002fce000000004eULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000000503024723cULL, 0x000fee0000001824ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000541056567816ULL, 0x002fce000000005bULL,
0x0000005d005d7306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0000541058577816ULL, 0x002fce000000005dULL, 0x0000003a003a7306ULL, 0x000e620000200c00ULL,
0x000000563020723cULL, 0x000fe20000001820ULL, 0x000054103e3d7816ULL, 0x004fcc000000003fULL,
0x0000003b003b7306ULL, 0x000ea20000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103a3a7816ULL, 0x002fe40000000049ULL, 0x000054103b3b7816ULL, 0x004fce000000004cULL,
0x0000003a302c723cULL, 0x000fe2000000182cULL, 0x013000003630783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000c31317232ULL, 0x080fe40000000000ULL, 0x0000000c33337232ULL, 0x000fce0000000000ULL,
0x00000000413c783bULL, 0x000ee80000004200ULL, 0x000000004038783bULL, 0x000f220000004200ULL,
0x00000018ff537819ULL, 0x008fe2000001143cULL, 0x000001003c4f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe2000001143dULL, 0x000001003d507824ULL, 0x040fe200078e00ffULL,
0x000088803c577816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d5e7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x010fe20000011438ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888038567816ULL, 0x000fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000003c005c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000018ff517819ULL, 0x000fe4000001143fULL, 0x000088803f597816ULL, 0x000fc400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011439ULL, 0x0000003d00617306ULL, 0x0009e20000200c00ULL,
0x000001003f3c7824ULL, 0x008fe200078e00ffULL, 0x0000888039587816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe4000001143eULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00000100383d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x000088803e557816ULL, 0x000fc400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004f00607306ULL, 0x0007e20000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff497819ULL, 0x000fe4000001143aULL,
0x00000018ff4c7819ULL, 0x000fc6000001143bULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000001003e4f7824ULL, 0x048fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000005000637306ULL, 0x000ee20000200c00ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003c00647306ULL, 0x0009f00000200c00ULL,
0x0000003800507306ULL, 0x000be20000200c00ULL, 0x00000100393c7824ULL, 0x050fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001143cULL,
0x0000005400547306ULL, 0x000f220000200c00ULL, 0x000001003b387824ULL, 0x022fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004f005a7306ULL, 0x000ff00000200c00ULL,
0x0000003f00627306ULL, 0x000ff00000200c00ULL, 0x00000039004f7306ULL, 0x0007f00000200c00ULL,
0x00000038003f7306ULL, 0x0003e20000200c00ULL, 0x000054105e397816ULL, 0x008fce0000000063ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x0000541057387816ULL, 0x002fce0000000060ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000000383010723cULL, 0x004fee0000001810ULL,
0x0000003e005f7306ULL, 0x0005e20000200c00ULL, 0x000054105c387816ULL, 0x000fe40000000053ULL,
0x0000541061397816ULL, 0x010fca0000000054ULL, 0x0000003d005b7306ULL, 0x0009e20000200c00ULL,
0x000088803b3e7816ULL, 0x044fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383014723cULL, 0x000fe80000001814ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x000001003a3d7824ULL, 0x050fe200078e00ffULL,
0x0000541055387816ULL, 0x008fe2000000005aULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541059397816ULL, 0x002fc40000000064ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000000383018723cULL, 0x000fea0000001818ULL, 0x0000003c003c7306ULL, 0x000fe40000200c00ULL,
0x000054105f387816ULL, 0x004fc40000000052ULL, 0x0000541062397816ULL, 0x002fc80000000051ULL,
0x0000003d003d7306ULL, 0x000e660000200c00ULL, 0x00000038301c723cULL, 0x000fea000000181cULL,
0x0000004d004d7306ULL, 0x000ea40000200c00ULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x000054103c3c7816ULL, 0x002fca000000003dULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x0186b839043879a7ULL, 0x000ee2000850003fULL, 0x0000541050507816ULL, 0x004fcc000000004dULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000054104f517816ULL, 0x002fce000000004eULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000000503024723cULL, 0x000fee0000001824ULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x0000541056567816ULL, 0x002fce000000005bULL, 0x0000005d005d7306ULL, 0x000e700000200c00ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000541058577816ULL, 0x002fce000000005dULL,
0x0000003a003a7306ULL, 0x000e620000200c00ULL, 0x000000563020723cULL, 0x000fe20000001820ULL,
0x000054103e3d7816ULL, 0x004fcc000000003fULL, 0x0000003b003b7306ULL, 0x000ea20000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054103a3a7816ULL, 0x002fe40000000049ULL,
0x000054103b3b7816ULL, 0x004fce000000004cULL, 0x0000003a302c723cULL, 0x000fee000000182cULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b839040075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fdc0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186b839040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff497b82ULL, 0x000e620000000800ULL, 0x000000a0070a7890ULL, 0x000fcc000fffe03fULL,
0x0000000a02497e24ULL, 0x002fe2000f8e0249ULL, 0x0000000000e89947ULL, 0x000fec0003800000ULL,
0x00008a00ff307b82ULL, 0x000e620000000a00ULL, 0x0000000134387824ULL, 0x000fe200078e0209ULL,
0x000000f0064d7812ULL, 0x000fe200078ec0ffULL, 0x00000002094f7836ULL, 0x000fe40000000000ULL,
0x0000000138327824ULL, 0x040fe400078e0205ULL, 0x0000001038397824ULL, 0x000fe400078e00ffULL,
0x00000001343a7824ULL, 0x000fe400078e024fULL, 0x0000000409517836ULL, 0x000fe20000000000ULL,
0xfffffff0393e7812ULL, 0x000fe200078ee232ULL, 0x000000013a337824ULL, 0x040fe200078e0205ULL,
0x0000000a35327c48ULL, 0x000fe2000ffe0000ULL, 0x000000103a4c7824ULL, 0x000fc400078e00ffULL,
0x0000000609537836ULL, 0x000fe40000000000ULL, 0x00000001383b7824ULL, 0x000fe200078e0249ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee233ULL, 0x8000000a32337c36ULL, 0x000fe40008000000ULL,
0x0000000134327824ULL, 0x040fe400078e0251ULL, 0x00000001343c7824ULL, 0x000fe200078e0253ULL,
0x0000003334397248ULL, 0x000fe20007fe0000ULL, 0x0000000132387824ULL, 0x000fc400078e0205ULL,
0x0000001032557824ULL, 0x000fe400078e00ffULL, 0x000000013a3d7824ULL, 0x100fe400078e0249ULL,
0x00000001323f7824ULL, 0x000fe200078e0249ULL, 0xfffffff0554e7812ULL, 0x000fe200078ee238ULL,
0x000000013c3a7824ULL, 0x040fe400078e0205ULL, 0x000000103c577824ULL, 0x000fe400078e00ffULL,
0x000001003b327825ULL, 0x002fc600078e0030ULL, 0xfffffff057507812ULL, 0x000fe200078ee23aULL,
0x000000013c497824ULL, 0x000fe200078e0249ULL, 0x0000004d32327210ULL, 0x000fe20007f9e0ffULL,
0x00000001393c7824ULL, 0x000fe400078e0a34ULL, 0x000001003d387825ULL, 0x000fc600078e0030ULL,
0x0000003c4f00720cULL, 0x080fe20003f06070ULL, 0x000001003f3a7825ULL, 0x000fe200078e0030ULL,
0x0000004d38387210ULL, 0x000fe40007fde0ffULL, 0x0000003c5100720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200020e0633ULL, 0x0000003c0900720cULL, 0x000fe20003f86070ULL,
0x0000010049307825ULL, 0x000fe200078e0030ULL, 0x0000004d3a3a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000003c5300720cULL, 0x000fe20003fc6070ULL,
0x00014000043d7836ULL, 0x000fe40000000000ULL, 0x000000ffff3b7224ULL, 0x000fe200028e063bULL,
0x0000004d30307210ULL, 0x000fe20007fbe0ffULL, 0x000000103e3f7824ULL, 0x100fe400078e023dULL,
0x000000104c497824ULL, 0x100fe400078e023dULL, 0x000000104e4d7824ULL, 0x100fe200078e023dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000323f7faeULL, 0x0003e2000e101c48ULL,
0x00000010503d7824ULL, 0x000fc400078e023dULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x0000000038497faeULL, 0x0003e8000c101c48ULL, 0x000000003a4d7faeULL, 0x0003e8000d901c48ULL,
0x00000000303d7faeULL, 0x0003e2000f101c48ULL, 0x0000000000b87947ULL, 0x000fea0003800000ULL,
0x00008a00ff307b82ULL, 0x000e620000000a00ULL, 0x0000000134327824ULL, 0x000fe200078e0209ULL,
0x000000f0063f7812ULL, 0x000fc600078ec0ffULL, 0x0000000232387836ULL, 0x000fe40000000000ULL,
0x0000000132337824ULL, 0x140fe400078e0205ULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0205ULL, 0x00000010383c7824ULL, 0x000fe200078e00ffULL,
0xfffffff03a4d7812ULL, 0x000fe200078ee233ULL, 0x00000004323a7836ULL, 0x000fc40000000000ULL,
0x0000000132337824ULL, 0x100fe200078e0249ULL, 0xfffffff03c4f7812ULL, 0x000fe200078ee239ULL,
0x00000006323c7836ULL, 0x000fe40000000000ULL, 0x00000001383b7824ULL, 0x100fe400078e0249ULL,
0x000000013a397824ULL, 0x100fe400078e0249ULL, 0x000000013c3d7824ULL, 0x000fe400078e0249ULL,
0x000000013a387824ULL, 0x000fc400078e0205ULL, 0x000000103a497824ULL, 0x000fe400078e00ffULL,
0x000000013c3a7824ULL, 0x040fe400078e0205ULL, 0x000000103c517824ULL, 0x000fe200078e00ffULL,
0xfffffff049497812ULL, 0x000fe200078ee238ULL, 0x0000010033327825ULL, 0x002fc600078e0030ULL,
0xfffffff051517812ULL, 0x000fe200078ee23aULL, 0x000001003b3a7825ULL, 0x000fe200078e0030ULL,
0x0000003f32327210ULL, 0x000fc60007f1e0ffULL, 0x0000010039387825ULL, 0x000fc800078e0030ULL,
0x000001003d307825ULL, 0x000fe200078e0030ULL, 0x0000003f38387210ULL, 0x000fc60007f7e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e0633ULL, 0x0000003f3a3a7210ULL, 0x000fe20007f1e0ffULL,
0x00014000043c7836ULL, 0x000fe20000000000ULL, 0x0000003f30307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe400018e0639ULL, 0x000000104d4d7824ULL, 0x100fe400078e023cULL,
0x000000104f4f7824ULL, 0x100fe400078e023cULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000324d7faeULL, 0x0003e2000b901c48ULL,
0x0000001049497824ULL, 0x000fc400078e023cULL, 0x0000001051517824ULL, 0x000fe200078e023cULL,
0x000000003a4f7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff317224ULL, 0x000fc600020e0631ULL,
0x0000000038497faeULL, 0x0003e8000b901c48ULL, 0x0000000030517faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff317424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0186a831043079a7ULL, 0x000e64000850003fULL, 0x000000ffff497224ULL, 0x002fe200078e0031ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b04b040075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b04b040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000182947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x00000008ff0c723eULL, 0x000fc600000000ffULL, 0x000000080d317836ULL, 0x000fe20000000000ULL,
0x000054100c307816ULL, 0x000fca000000000cULL, 0x00001f0d300d7589ULL, 0x0002a800000e0000ULL,
0x00001f31300c7589ULL, 0x0002e400000e0000ULL, 0x013000004430783bULL, 0x0022e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x00000000433c783bULL, 0x000f280000004200ULL,
0x000000004238783bULL, 0x000f620000004200ULL, 0x00000018ff537819ULL, 0x010fe2000001143dULL,
0x000001003d4f7824ULL, 0x040fe200078e00ffULL, 0x000088803d5e7816ULL, 0x040fe200000000ffULL,
0x000001003c4e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe2000001143cULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x000088803c577816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x022fe20000011438ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000888038557816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000003d00627306ULL, 0x0003e20000200c00ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x00000018ff507819ULL, 0x000fe4000001143fULL,
0x000088803f587816ULL, 0x000fc400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011439ULL,
0x0000003c005d7306ULL, 0x0009e20000200c00ULL, 0x00000100383d7824ULL, 0x042fe200078e00ffULL,
0x0000888039567816ULL, 0x000fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe4000001143eULL, 0x000088803e547816ULL, 0x000fe400000000ffULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004e00607306ULL, 0x0003220000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff4a7819ULL, 0x000fe4000001143aULL, 0x00000018ff4b7819ULL, 0x000fc6000001143bULL,
0x0000004f00637306ULL, 0x000f620000200c00ULL, 0x000001003e4e7824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000003c00617306ULL, 0x0003e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x00000038004f7306ULL, 0x0009e20000200c00ULL, 0x00000100393c7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001143cULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x000001003b387824ULL, 0x014fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x040fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005300537306ULL, 0x000eb00000200c00ULL,
0x0000003d005a7306ULL, 0x0009f00000200c00ULL, 0x0000003f005f7306ULL, 0x000fe20000200c00ULL,
0x000001003a3d7824ULL, 0x010fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004e00597306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x00000038003f7306ULL, 0x0009f00000200c00ULL,
0x00000039004e7306ULL, 0x000be20000200c00ULL, 0x0000541057387816ULL, 0x010fe20000000060ULL,
0x000100003b577824ULL, 0x000fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000005400547306ULL, 0x000f220000200c00ULL, 0x000054105e397816ULL, 0x028fce0000000063ULL,
0x0000005800587306ULL, 0x000ee20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x0000003e005c7306ULL, 0x000be20000200c00ULL, 0x000054105d387816ULL, 0x002fe40000000052ULL,
0x0000541062397816ULL, 0x004fca0000000053ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000088803b3e7816ULL, 0x020fe200000000ffULL, 0x000000383014723cULL, 0x000fec0000001814ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000541054387816ULL, 0x010fe40000000059ULL,
0x0000541058397816ULL, 0x008fca0000000061ULL, 0x0000005100517306ULL, 0x000ea40000200c00ULL,
0x000000383018723cULL, 0x000fe20000001818ULL, 0x000054103c3c7816ULL, 0x002fca000000003dULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000054105c387816ULL, 0x004fce0000000051ULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x000054105f397816ULL, 0x002fce0000000050ULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x00000038301c723cULL, 0x000fe2000000181cULL,
0x000054104f4c7816ULL, 0x004fcc000000004cULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000054104e4d7816ULL, 0x002fce000000004dULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000004c3024723cULL, 0x000fee0000001824ULL, 0x0000005500557306ULL, 0x000e700000200c00ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x00005410555a7816ULL, 0x002fce000000005aULL,
0x0000005b005b7306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x00005410565b7816ULL, 0x002fce000000005bULL, 0x0000003a003b7306ULL, 0x000e620000200c00ULL,
0x0000005a3020723cULL, 0x000fe20000001820ULL, 0x000054103e3d7816ULL, 0x004fcc000000003fULL,
0x0000005700527306ULL, 0x000ea20000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103b4a7816ULL, 0x002fe4000000004aULL, 0x00005410524b7816ULL, 0x004fce000000004bULL,
0x0000004a302c723cULL, 0x000fe2000000182cULL, 0x013000004530783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000c31317232ULL, 0x080fe40000000000ULL, 0x0000000c33337232ULL, 0x000fce0000000000ULL,
0x00000000473c783bULL, 0x000ee20000004200ULL, 0x000000a0070a7890ULL, 0x000fc6000fffe03fULL,
0x000000004638783bULL, 0x000f260000004200ULL, 0x0000000a35007c0cULL, 0x000fe4000bf03070ULL,
0x00000018ff517819ULL, 0x008fe2000001143cULL, 0x000001003c527824ULL, 0x040fe200078e00ffULL,
0x000088803c567816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe2000001143dULL, 0x000001003d537824ULL, 0x040fe200078e00ffULL,
0x000088803d5a7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x000001003b637824ULL, 0x010fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff4e7819ULL, 0x000fe2000001143fULL, 0x0000003c005e7306ULL, 0x0007e20000200c00ULL,
0x000088803f597816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011438ULL,
0x00000018ff4d7819ULL, 0x000fe40000011439ULL, 0x0000888039557816ULL, 0x000fe200000000ffULL,
0x00000052005b7306ULL, 0x0009620000200c00ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000088803e547816ULL, 0x000fc400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000001003e527824ULL, 0x050fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001143aULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000005300617306ULL, 0x0007220000200c00ULL, 0x00000018ff3e7819ULL, 0x000fc4000001143eULL,
0x00000018ff4b7819ULL, 0x000fca000001143bULL, 0x0000003d005f7306ULL, 0x0009e20000200c00ULL,
0x0000888038537816ULL, 0x008fce00000000ffULL, 0x0000003c00627306ULL, 0x0007e20000200c00ULL,
0x00000100383d7824ULL, 0x054fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x00000100393c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff607819ULL, 0x000fe4000001143cULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000005200577306ULL, 0x000fe20000200c00ULL,
0x000088803a3c7816ULL, 0x000fce00000000ffULL, 0x0000003f005d7306ULL, 0x000ff00000200c00ULL,
0x00000038003f7306ULL, 0x000bf00000200c00ULL, 0x0000003900527306ULL, 0x0007e20000200c00ULL,
0x0000541056387816ULL, 0x022fc4000000005bULL, 0x00000018ff5b7819ULL, 0x000fca0000011463ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x000054105a397816ULL, 0x008fce0000000061ULL,
0x0000003d00587306ULL, 0x0007e20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x000054105f397816ULL, 0x004fe20000000050ULL, 0x000001003a3d7824ULL, 0x008fe200078e00ffULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x000100003b507824ULL, 0x000fe200078e00ffULL,
0x000054105e387816ULL, 0x002fe20000000051ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x000000383014723cULL, 0x000fec0000001814ULL, 0x0000003e005c7306ULL, 0x0007e20000200c00ULL,
0x0000541054387816ULL, 0x004fc40000000057ULL, 0x0000541059397816ULL, 0x002fca0000000062ULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000088803b3e7816ULL, 0x008fe200000000ffULL,
0x000000383018723cULL, 0x000fec0000001818ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000054105c387816ULL, 0x002fce000000004fULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x00000001ff4f7424ULL, 0x000fe200078e00ffULL, 0x000054105d397816ULL, 0x004fcc000000004eULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00000038301c723cULL, 0x000fee000000181cULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x0186b84f043879a7ULL, 0x0006e2000850003fULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x0186984f04ff79a7ULL, 0x0007e2000850003fULL, 0x000054103f4c7816ULL, 0x004fcc000000004cULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x00005410524d7816ULL, 0x002fce000000004dULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000004c3024723cULL, 0x000fee0000001824ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x0000541053547816ULL, 0x002fce0000000058ULL, 0x0000006000607306ULL, 0x000e700000200c00ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000541055557816ULL, 0x002fce0000000060ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x000000543020723cULL, 0x000fee0000001820ULL,
0x0000003a003b7306ULL, 0x000ea20000200c00ULL, 0x000054103e3d7816ULL, 0x002fce000000005bULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103b4a7816ULL, 0x004fe4000000004aULL, 0x00005410504b7816ULL, 0x002fce000000004bULL,
0x0000004a302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000038001c0947ULL, 0x008fde0003800000ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b839040075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186b839040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008e00ff3f7b82ULL, 0x000e620000000800ULL,
0x000000c0070a7890ULL, 0x000fcc000fffe03fULL, 0x0000000a023f7e24ULL, 0x002fe2000f8e023fULL,
0x0000000000e89947ULL, 0x000fec0003800000ULL, 0x0000000134387824ULL, 0x000fe200078e0209ULL,
0x0000000a35327c48ULL, 0x000fe2000ffe0000ULL, 0x00000002094b7836ULL, 0x000fe40000000000ULL,
0x0000000138307824ULL, 0x040fe400078e0205ULL, 0x00000010384d7824ULL, 0x040fe400078e00ffULL,
0x8000000a32337c36ULL, 0x000fe40008000000ULL, 0x0000000409517836ULL, 0x000fe20000000000ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee230ULL, 0x0000000138397824ULL, 0x000fe200078e023fULL,
0x00008a00ff307b82ULL, 0x000e620000000a00ULL, 0x0000000134327824ULL, 0x040fe200078e024bULL,
0x0000003334337248ULL, 0x000fe20007fe0000ULL, 0x0000000134387824ULL, 0x000fc400078e0251ULL,
0x00000001323b7824ULL, 0x040fe400078e023fULL, 0x00000001323a7824ULL, 0x040fe400078e0205ULL,
0x00000010324f7824ULL, 0x000fe400078e00ffULL, 0x00000001383d7824ULL, 0x040fe400078e023fULL,
0x0000000138327824ULL, 0x040fe200078e0205ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee23aULL,
0x0000001038537824ULL, 0x000fc400078e00ffULL, 0x0000000133387824ULL, 0x000fe400078e0a34ULL,
0x0000000609557836ULL, 0x000fe20000000000ULL, 0xfffffff053537812ULL, 0x000fe400078ee232ULL,
0x000000384b00720cULL, 0x080fe20003f46070ULL, 0x00000001343c7824ULL, 0x000fe200078e0255ULL,
0x000000f0064b7812ULL, 0x000fe200078ec0ffULL, 0x0000010039327825ULL, 0x002fe200078e0030ULL,
0x000000385100720cULL, 0x080fe40003f26070ULL, 0x000000385500720cULL, 0x080fe20003f06070ULL,
0x000000013c3f7824ULL, 0x000fe200078e023fULL, 0x0000004b32327210ULL, 0x000fe20007f9e0ffULL,
0x000001003b3a7825ULL, 0x000fe200078e0030ULL, 0x000000380900720cULL, 0x000fc60003f66070ULL,
0x000001003d387825ULL, 0x000fc800078e0030ULL, 0x000000013c3e7824ULL, 0x040fe200078e0205ULL,
0x0000004b38387210ULL, 0x000fe20007fbe0ffULL, 0x000000103c577824ULL, 0x000fe400078e00ffULL,
0x000001003f307825ULL, 0x000fc600078e0030ULL, 0xfffffff057577812ULL, 0x000fe200078ee23eULL,
0x000000ffff337224ULL, 0x000fe200020e0633ULL, 0x0000004b3a3a7210ULL, 0x000fe20007f9e0ffULL,
0x00016000043c7836ULL, 0x000fe20000000000ULL, 0x0000004b30307210ULL, 0x000fe20007fde0ffULL,
0x000000ffff397224ULL, 0x000fe400028e0639ULL, 0x000000104d4d7824ULL, 0x100fe400078e023cULL,
0x000000104f4f7824ULL, 0x100fe400078e023cULL, 0x000000ffff3b7224ULL, 0x000fe200020e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000324d7faeULL, 0x0003e2000d901c48ULL,
0x0000001053537824ULL, 0x000fc400078e023cULL, 0x0000001057577824ULL, 0x000fe200078e023cULL,
0x000000003a4f7faeULL, 0x0003e2000d101c48ULL, 0x000000ffff317224ULL, 0x000fc600030e0631ULL,
0x0000000038537faeULL, 0x0003e8000c901c48ULL, 0x0000000030577faeULL, 0x0003e2000c101c48ULL,
0x0000000000b87947ULL, 0x000fea0003800000ULL, 0x00008a00ff307b82ULL, 0x000e620000000a00ULL,
0x0000000134327824ULL, 0x000fc800078e0209ULL, 0x0000000232387836ULL, 0x000fe40000000000ULL,
0x0000000132337824ULL, 0x140fe400078e0205ULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0205ULL, 0x00000010383c7824ULL, 0x000fe200078e00ffULL,
0xfffffff03a4b7812ULL, 0x000fe200078ee233ULL, 0x00000004323a7836ULL, 0x000fc40000000000ULL,
0x0000000132337824ULL, 0x100fe200078e023fULL, 0xfffffff03c4d7812ULL, 0x000fe200078ee239ULL,
0x00000006323c7836ULL, 0x000fe40000000000ULL, 0x00000001383b7824ULL, 0x100fe400078e023fULL,
0x000000013a397824ULL, 0x040fe400078e023fULL, 0x000000013a387824ULL, 0x040fe400078e0205ULL,
0x000000103a4f7824ULL, 0x000fc400078e00ffULL, 0x000000013c3d7824ULL, 0x000fe200078e023fULL,
0x000000f0063f7812ULL, 0x000fe200078ec0ffULL, 0x000000013c3a7824ULL, 0x040fe200078e0205ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee238ULL, 0x000000103c517824ULL, 0x000fe400078e00ffULL,
0x0000010033327825ULL, 0x002fc600078e0030ULL, 0xfffffff051517812ULL, 0x000fe200078ee23aULL,
0x000001003b3a7825ULL, 0x000fe200078e0030ULL, 0x0000003f32327210ULL, 0x000fc60007f1e0ffULL,
0x0000010039387825ULL, 0x000fc800078e0030ULL, 0x000001003d307825ULL, 0x000fe200078e0030ULL,
0x0000003f38387210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x0000003f3a3a7210ULL, 0x000fe20007f1e0ffULL, 0x00016000043c7836ULL, 0x000fe20000000000ULL,
0x0000003f30307210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff397224ULL, 0x000fe400008e0639ULL,
0x000000104b4b7824ULL, 0x100fe400078e023cULL, 0x000000104d4d7824ULL, 0x100fe400078e023cULL,
0x000000ffff3b7224ULL, 0x000fe200000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000324b7faeULL, 0x0003e2000b901c48ULL, 0x000000104f4f7824ULL, 0x000fc400078e023cULL,
0x0000001051517824ULL, 0x000fe200078e023cULL, 0x000000003a4d7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff317224ULL, 0x000fc600010e0631ULL, 0x00000000384f7faeULL, 0x0003e8000b901c48ULL,
0x0000000030517faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0186b038044a79a7ULL, 0x0002a4000850003fULL,
0x01866838033879a7ULL, 0x0022e4000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01866839030075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01866839030075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0181800007317984ULL, 0x000ee20000000800ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x0183800007337984ULL, 0x0009220000000800ULL,
0x000000483100720bULL, 0x008fda0003f1d000ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x016fea0003800000ULL,
0x000000033700780cULL, 0x000fe40003f25270ULL, 0x000000483100720bULL, 0x000fd60003f14000ULL,
0x0000004831309209ULL, 0x000fe40007810000ULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x0185803007009388ULL, 0x0003e20000000800ULL, 0x0000991038327816ULL, 0x000fc800000000ffULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000004831077209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x0000004807077221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL, 0x00000007003b7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x000fca0000011605ULL,
0x00001f303b077589ULL, 0x006e6400000e0000ULL, 0x0000000710107220ULL, 0x082fe20000410000ULL,
0x0000000711117220ULL, 0x080fe20000410000ULL, 0x0000000714147220ULL, 0x080fe20000410000ULL,
0x0000000715157220ULL, 0x080fe20000410000ULL, 0x0000000718187220ULL, 0x080fe20000410000ULL,
0x0000000719197220ULL, 0x080fe20000410000ULL, 0x000000071c1c7220ULL, 0x080fe20000410000ULL,
0x000000071d1d7220ULL, 0x080fe20000410000ULL, 0x0000000720207220ULL, 0x080fe20000410000ULL,
0x0000000721217220ULL, 0x080fe20000410000ULL, 0x0000000724247220ULL, 0x080fe20000410000ULL,
0x0000000725257220ULL, 0x080fe20000410000ULL, 0x0000000728287220ULL, 0x080fe20000410000ULL,
0x0000000729297220ULL, 0x080fe20000410000ULL, 0x000000072c2c7220ULL, 0x080fe20000410000ULL,
0x000000072d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b00007220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x0000000805307811ULL, 0x000fca00078ff0ffULL,
0x00001f303b077589ULL, 0x002e6400000e0000ULL, 0x0000000712127220ULL, 0x082fe20000410000ULL,
0x0000000713137220ULL, 0x080fe20000410000ULL, 0x0000000716167220ULL, 0x080fe20000410000ULL,
0x0000000717177220ULL, 0x080fe20000410000ULL, 0x000000071a1a7220ULL, 0x080fe20000410000ULL,
0x000000071b1b7220ULL, 0x080fe20000410000ULL, 0x000000071e1e7220ULL, 0x080fe20000410000ULL,
0x000000071f1f7220ULL, 0x080fe20000410000ULL, 0x0000000722227220ULL, 0x080fe20000410000ULL,
0x0000000723237220ULL, 0x080fe20000410000ULL, 0x0000000726267220ULL, 0x080fe20000410000ULL,
0x0000000727277220ULL, 0x080fe20000410000ULL, 0x000000072a2a7220ULL, 0x080fe20000410000ULL,
0x000000072b2b7220ULL, 0x080fe20000410000ULL, 0x000000072e2e7220ULL, 0x080fe20000410000ULL,
0x000000072f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000004831487209ULL, 0x000fd60007810000ULL,
0x8000004831310221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100080308ULL, 0x000ea40000000800ULL,
0x0000000833330220ULL, 0x004fce0000410000ULL, 0x0000000033007221ULL, 0x000fce0000010000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x0186a849040075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff397224ULL, 0x000fce00078e00ffULL,
0x000000103900780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x0000003230327210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x002fc80000011433ULL,
0x0000003207077211ULL, 0x000fca00078110ffULL, 0x000000ffff327224ULL, 0x000fca00000e0633ULL,
0x0000000207077819ULL, 0x000fc80000001232ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000139397836ULL, 0x000fce0000000000ULL,
0x0186a849040075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000991038077816ULL, 0x002fc800000000ffULL, 0x000000ff0700720cULL, 0x000fda0003f25270ULL,
0x0000000000181947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x000fe40000011605ULL,
0x00000008ff07723eULL, 0x000fc600000000ffULL, 0x00000008300c7836ULL, 0x000fe20000000000ULL,
0x0000541007077816ULL, 0x000fca0000000007ULL, 0x00001f30070d7589ULL, 0x0002a800000e0000ULL,
0x00001f0c070c7589ULL, 0x0002e400000e0000ULL, 0x013800000a30783bULL, 0x0022e20000000200ULL,
0x0000000000101947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x000000000b38783bULL, 0x000f280000004200ULL,
0x000000000e3c783bULL, 0x000f620000004200ULL, 0x00000100380b7824ULL, 0x050fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe20000011438ULL, 0x0000010039517824ULL, 0x040fe200078e00ffULL,
0x00008880380a7816ULL, 0x042fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe2000001140bULL, 0x000001003a527824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011439ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x00008880390b7816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fc40000011451ULL, 0x00000018ff4d7819ULL, 0x000fe4000001143aULL,
0x000088803a517816ULL, 0x040fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000000a000a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff4e7819ULL, 0x000fe4000001143bULL,
0x000088803b537816ULL, 0x000fc400000000ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000003800587306ULL, 0x0003e20000200c00ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff497819ULL, 0x020fe4000001143cULL, 0x00000018ff4c7819ULL, 0x000fe4000001143dULL,
0x00000018ff077819ULL, 0x000fe2000001143eULL, 0x0000003900597306ULL, 0x0009e20000200c00ULL,
0x000001003b387824ULL, 0x042fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001143fULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x000088803d567816ULL, 0x000fc400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003a005a7306ULL, 0x0003e20000200c00ULL,
0x000001003c397824ULL, 0x010fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fc8000001143bULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000005700577306ULL, 0x000f220000200c00ULL,
0x000001003e3a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001143aULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x000088803f3a7816ULL, 0x000fe400000000ffULL,
0x000054100a0a7816ULL, 0x010fca0000000057ULL, 0x0000005e005e7306ULL, 0x000e700000200c00ULL,
0x0000005200547306ULL, 0x0009e20000200c00ULL, 0x000054100b0b7816ULL, 0x002fce000000005eULL,
0x00000038005c7306ULL, 0x0003e20000200c00ULL, 0x000088803c527816ULL, 0x050fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x0000000a3010723cULL, 0x008fe80000001810ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000003b005b7306ULL, 0x0007e20000200c00ULL,
0x000001003d387824ULL, 0x042fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00005410580a7816ULL, 0x000fc4000000004fULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003900557306ULL, 0x0003e20000200c00ULL, 0x000001003f3b7824ULL, 0x048fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000005000507306ULL, 0x000ee20000200c00ULL,
0x000088803e397816ULL, 0x042fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc8000001143fULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x00000038005d7306ULL, 0x000fe20000200c00ULL, 0x00005410590b7816ULL, 0x008fce0000000050ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x0000000a3014723cULL, 0x000fee0000001814ULL,
0x0000003900397306ULL, 0x000fe20000200c00ULL, 0x00005410530b7816ULL, 0x002fce000000005cULL,
0x0000005f00387306ULL, 0x000e700000200c00ULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x0000541039387816ULL, 0x002fce0000000038ULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x000054105a5a7816ULL, 0x008fce000000004dULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054105b5b7816ULL, 0x002fce000000004eULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000005a301c723cULL, 0x000fee000000181cULL, 0x0000000700077306ULL, 0x000ff00000200c00ULL,
0x0000000e000e7306ULL, 0x000ff00000200c00ULL, 0x0000005100517306ULL, 0x000e700000200c00ULL,
0x0000005200527306ULL, 0x000ee20000200c00ULL, 0x00005410510a7816ULL, 0x002fce0000000054ULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x0000000a3018723cULL, 0x000fe20000001818ULL,
0x0000541052527816ULL, 0x008fcc0000000055ULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x0000541056537816ULL, 0x002fce000000005dULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000000523020723cULL, 0x000fe20000001820ULL, 0x000054103c3c7816ULL, 0x008fcc0000000049ULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x000054103d3d7816ULL, 0x002fce000000004cULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x0000003c3024723cULL, 0x000fee0000001824ULL,
0x0000003e003e7306ULL, 0x000ee20000200c00ULL, 0x000054103a397816ULL, 0x002fce000000003bULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000000383028723cULL, 0x000fe20000001828ULL,
0x000054103e3e7816ULL, 0x008fe40000000007ULL, 0x000054103f3f7816ULL, 0x002fce000000000eULL,
0x0000003e302c723cULL, 0x000fe2000000182cULL, 0x013800003630783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000101947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000c31317232ULL, 0x080fe40000000000ULL, 0x0000000c33337232ULL, 0x000fce0000000000ULL,
0x000000004138783bULL, 0x000f280000004200ULL, 0x00000000403c783bULL, 0x000f620000004200ULL,
0x00000018ff4d7819ULL, 0x010fe20000011438ULL, 0x00000100380b7824ULL, 0x040fe200078e00ffULL,
0x00008880380a7816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011439ULL, 0x0000010039417824ULL, 0x040fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe2000001140bULL, 0x000001003a4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000000a000a7306ULL, 0x000fe20000200c00ULL,
0x00008880390b7816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc40000011441ULL, 0x00000018ff497819ULL, 0x000fe4000001143aULL,
0x000088803a417816ULL, 0x040fe200000000ffULL, 0x0000003800567306ULL, 0x0009e20000200c00ULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff4c7819ULL, 0x000fe4000001143bULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003900557306ULL, 0x000be20000200c00ULL, 0x000001003b387824ULL, 0x050fe200078e00ffULL,
0x000088803b507816ULL, 0x040fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003a00587306ULL, 0x000fe20000200c00ULL, 0x000001003c397824ULL, 0x022fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff367819ULL, 0x000fe4000001143cULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000038005b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff077819ULL, 0x000fc4000001143eULL, 0x00000018ff0e7819ULL, 0x000fe4000001143fULL,
0x00000018ff407819ULL, 0x000fe4000001143dULL, 0x000088803d517816ULL, 0x040fe200000000ffULL,
0x0000004f00527306ULL, 0x0009e20000200c00ULL, 0x000001003d387824ULL, 0x002fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011438ULL, 0x000100003c387824ULL, 0x040fe200078e00ffULL,
0x0000003b00577306ULL, 0x0003e20000200c00ULL, 0x000088803c4f7816ULL, 0x010fc600000000ffULL,
0x00000018ff3a7819ULL, 0x000fe20000011438ULL, 0x000100003d387824ULL, 0x000fc600078e00ffULL,
0x0000003900547306ULL, 0x0009e20000200c00ULL, 0x000001003f3b7824ULL, 0x002fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011438ULL, 0x000001003e387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000005c003c7306ULL, 0x0003e20000200c00ULL,
0x000088803e397816ULL, 0x050fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc80000011438ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000005300537306ULL, 0x000f220000200c00ULL, 0x000088803f5c7816ULL, 0x042fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x000054100a0a7816ULL, 0x010fce0000000053ULL,
0x0000005a005a7306ULL, 0x000e700000200c00ULL, 0x0000004d004d7306ULL, 0x000f220000200c00ULL,
0x000054100b0b7816ULL, 0x002fce000000005aULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x0000000a3010723cULL, 0x008fee0000001810ULL, 0x0000004900497306ULL, 0x000ee20000200c00ULL,
0x00005410560a7816ULL, 0x010fe4000000004dULL, 0x00005410550b7816ULL, 0x002fca000000004eULL,
0x0000005000507306ULL, 0x000e640000200c00ULL, 0x0000000a3014723cULL, 0x000fe20000001814ULL,
0x0000541058567816ULL, 0x008fca0000000049ULL, 0x0000003a003d7306ULL, 0x000fe20000200c00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000541050537816ULL, 0x002fcc000000005bULL,
0x0000003900397306ULL, 0x000ff00000200c00ULL, 0x0000003800387306ULL, 0x000e700000200c00ULL,
0x0000004c004c7306ULL, 0x000ee20000200c00ULL, 0x0000541039387816ULL, 0x002fce0000000038ULL,
0x0000003600367306ULL, 0x000e620000200c00ULL, 0x0000541057577816ULL, 0x008fce000000004cULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x00000056301c723cULL, 0x000fe2000000181cULL,
0x000054103d587816ULL, 0x002fcc0000000036ULL, 0x0000000700077306ULL, 0x000ff00000200c00ULL,
0x0000000e000e7306ULL, 0x000ff00000200c00ULL, 0x0000004100417306ULL, 0x000e700000200c00ULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x0000541041527816ULL, 0x002fce0000000052ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x000000523018723cULL, 0x000fe20000001818ULL,
0x000054104f507816ULL, 0x008fcc0000000054ULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x0000541051517816ULL, 0x002fce000000003cULL, 0x0000005c003a7306ULL, 0x000fe20000200c00ULL,
0x000000503020723cULL, 0x000fe20000001820ULL, 0x0000541059597816ULL, 0x008fcc0000000040ULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x000000583024723cULL, 0x000fee0000001824ULL,
0x0000003e003e7306ULL, 0x000ee20000200c00ULL, 0x000054103a397816ULL, 0x002fce000000003bULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000000383028723cULL, 0x000fe20000001828ULL,
0x000054103e3e7816ULL, 0x008fe40000000007ULL, 0x000054103f3f7816ULL, 0x002fce000000000eULL,
0x0000003e302c723cULL, 0x000fe2000000182cULL, 0x0186b80b043279a7ULL, 0x0002de000850003fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x0186b833040075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x000000300a0e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000131307824ULL, 0x000fe200000e0e0bULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011430ULL, 0x0000000e07077211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e0630ULL, 0x0000000207077819ULL, 0x000fc8000000120eULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0186b833040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008e00ff3b7b82ULL, 0x000e620000000800ULL,
0x0000000204067890ULL, 0x000fe4000fffe03fULL, 0x000000e007077890ULL, 0x000fc8000fffe03fULL,
0x000000060f007c0cULL, 0x000fe4000bf03070ULL, 0x00000007023b7e24ULL, 0x002fd6000f8e023bULL,
0x0000000000e88947ULL, 0x000fea0003800000ULL, 0x00000001340e7824ULL, 0x000fe200078e0209ULL,
0x0000000735077c48ULL, 0x000fe2000ffe0000ULL, 0x00000002093d7836ULL, 0x000fe40000000000ULL,
0x000000010e0a7824ULL, 0x040fe400078e0205ULL, 0x000000100e0b7824ULL, 0x040fe400078e00ffULL,
0x8000000707077c36ULL, 0x000fe40008000000ULL, 0x000000010e317824ULL, 0x000fe200078e023bULL,
0xfffffff00b367812ULL, 0x000fe200078ee20aULL, 0x00000001340e7824ULL, 0x000fe200078e023dULL,
0x00008a00ff0a7b82ULL, 0x000e620000000a00ULL, 0x0000000734077248ULL, 0x000fe20007fe0000ULL,
0x00000004093f7836ULL, 0x000fc40000000000ULL, 0x0000000609417836ULL, 0x000fe40000000000ULL,
0x000000010e337824ULL, 0x040fe400078e023bULL, 0x000000010e307824ULL, 0x040fe400078e0205ULL,
0x000000100e497824ULL, 0x000fe400078e00ffULL, 0x00000001070e7824ULL, 0x000fe400078e0a34ULL,
0x0000000134327824ULL, 0x000fc400078e023fULL, 0x0000000134387824ULL, 0x000fe200078e0241ULL,
0x0000000e3d00720cULL, 0x080fe20003f66070ULL, 0x0000000132397824ULL, 0x000fe200078e023bULL,
0x000000f0063d7812ULL, 0x000fe200078ec0ffULL, 0x00000001323a7824ULL, 0x040fe200078e0205ULL,
0x0000000e0900720cULL, 0x080fe20003f86070ULL, 0x00000010324d7824ULL, 0x000fe200078e00ffULL,
0x0000000e3f00720cULL, 0x080fe20003f46070ULL, 0x00000001383b7824ULL, 0x040fe200078e023bULL,
0x0000000e4100720cULL, 0x000fe20003f06070ULL, 0x0000000138327824ULL, 0x040fe200078e0205ULL,
0xfffffff04d3a7812ULL, 0x000fe200078ee23aULL, 0x00000010384f7824ULL, 0x000fe200078e00ffULL,
0xfffffff049387812ULL, 0x000fe200078ee230ULL, 0x0000010031067825ULL, 0x002fc600078e000aULL,
0xfffffff04f3c7812ULL, 0x000fe200078ee232ULL, 0x0000010033307825ULL, 0x000fe200078e000aULL,
0x0000003d06067210ULL, 0x000fc60007fbe0ffULL, 0x0000010039327825ULL, 0x000fe200078e000aULL,
0x0000003d30307210ULL, 0x000fc60007fde0ffULL, 0x000001003b0a7825ULL, 0x000fc800078e000aULL,
0x0001400004097836ULL, 0x000fe40000000000ULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000003d32327210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200030e0631ULL,
0x0000003d0a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001036397824ULL, 0x100fe400078e0209ULL,
0x00000010383b7824ULL, 0x100fe400078e0209ULL, 0x000000103a3d7824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006397faeULL, 0x0003e2000e101c48ULL,
0x000000ffff337224ULL, 0x000fc400028e0633ULL, 0x000000103c097824ULL, 0x000fe200078e0209ULL,
0x00000000303b7faeULL, 0x0003e2000d901c48ULL, 0x000000ffff0b7224ULL, 0x000fc600030e060bULL,
0x00000000323d7faeULL, 0x0003e8000d101c48ULL, 0x000000000a097faeULL, 0x0003e2000c101c48ULL,
0x0000000000b87947ULL, 0x000fea0003800000ULL, 0x00008a00ff0a7b82ULL, 0x000e620000000a00ULL,
0x00000001340e7824ULL, 0x000fe200078e0209ULL, 0x000000f006397812ULL, 0x000fc600078ec0ffULL,
0x000000020e307836ULL, 0x000fe40000000000ULL, 0x000000010e077824ULL, 0x140fe400078e0205ULL,
0x000000100e327824ULL, 0x000fe400078e00ffULL, 0x0000000130097824ULL, 0x040fe400078e0205ULL,
0x0000001030367824ULL, 0x000fe200078e00ffULL, 0xfffffff0323d7812ULL, 0x000fe200078ee207ULL,
0x000000040e327836ULL, 0x000fc40000000000ULL, 0x000000010e337824ULL, 0x100fe200078e023bULL,
0xfffffff0363f7812ULL, 0x000fe200078ee209ULL, 0x000000060e367836ULL, 0x000fe40000000000ULL,
0x0000000130077824ULL, 0x100fe400078e023bULL, 0x0000000132317824ULL, 0x100fe400078e023bULL,
0x0000000136097824ULL, 0x000fe400078e023bULL, 0x00000001320e7824ULL, 0x000fc400078e0205ULL,
0x00000010323b7824ULL, 0x000fe400078e00ffULL, 0x0000010033327825ULL, 0x002fc600078e000aULL,
0xfffffff03b3b7812ULL, 0x000fe200078ee20eULL, 0x0000000136307824ULL, 0x040fe200078e0205ULL,
0x0000003932327210ULL, 0x000fe20007f1e0ffULL, 0x0000001036417824ULL, 0x000fe400078e00ffULL,
0x0000010007067825ULL, 0x000fc600078e000aULL, 0xfffffff041417812ULL, 0x000fe200078ee230ULL,
0x0000010031307825ULL, 0x000fc800078e000aULL, 0x00000100090a7825ULL, 0x000fe200078e000aULL,
0x0000003930307210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x0000003906067210ULL, 0x000fe20007f1e0ffULL, 0x00014000040e7836ULL, 0x000fe20000000000ULL,
0x000000390a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe400010e0631ULL,
0x000000103d3d7824ULL, 0x100fe400078e020eULL, 0x000000103f3f7824ULL, 0x100fe400078e020eULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000323d7faeULL, 0x0003e2000b901c48ULL, 0x000000103b3b7824ULL, 0x000fc400078e020eULL,
0x0000001041417824ULL, 0x000fe200078e020eULL, 0x00000000063f7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff0b7224ULL, 0x000fc600018e060bULL, 0x00000000303b7faeULL, 0x0003e8000b901c48ULL,
0x000000000a417faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff077424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0186a807040679a7ULL, 0x000e64000850003fULL,
0x000000ffff497224ULL, 0x002fce00078e0007ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0186b04b040075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001140bULL, 0x0000000a09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000209097819ULL, 0x000fc8000000120aULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x0186b04b040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000181947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x004fe40000011605ULL, 0x00000008ff06723eULL, 0x000fc600000000ffULL,
0x000000080d077836ULL, 0x000fe20000000000ULL, 0x0000541006067816ULL, 0x000fca0000000006ULL,
0x00001f0d060d7589ULL, 0x0002a800000e0000ULL, 0x00001f07060c7589ULL, 0x0002e400000e0000ULL,
0x013800004430783bULL, 0x0002e20000000200ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000c31317232ULL, 0x080fe40000000000ULL, 0x0000000c33337232ULL, 0x000fce0000000000ULL,
0x00000000433c783bULL, 0x000f280000004200ULL, 0x000000004238783bULL, 0x000b620000004200ULL,
0x000001003c077824ULL, 0x052fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe2000001143cULL,
0x000001003d427824ULL, 0x020fe200078e00ffULL, 0x000088803c067816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011407ULL,
0x000001003f4a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x000001003e437824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe2000001143dULL,
0x000001003b537824ULL, 0x008fe200078e00ffULL, 0x000088803d077816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x0000004200527306ULL, 0x0003e20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fc4000001143cULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff407819ULL, 0x000fe4000001143eULL, 0x00000018ff367819ULL, 0x000fe2000001143fULL,
0x0000004a00557306ULL, 0x0007e20000200c00ULL, 0x000088803e3c7816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000088803f427816ULL, 0x042fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff4d7819ULL, 0x000fe2000001143eULL, 0x00000100383e7824ULL, 0x040fe200078e00ffULL,
0x0000003d004e7306ULL, 0x0003e20000200c00ULL, 0x00000100394a7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001143fULL, 0x00000018ff0b7819ULL, 0x000fe40000011438ULL,
0x00000018ff0e7819ULL, 0x000fe40000011439ULL, 0x00008880393f7816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00008880383d7816ULL, 0x042fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000000600067306ULL, 0x000fe20000200c00ULL, 0x00000018ff517819ULL, 0x000fe20000011439ULL,
0x000001003a397824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc40000011438ULL,
0x00000018ff097819ULL, 0x000fe4000001143aULL, 0x00000018ff0a7819ULL, 0x000fe2000001143bULL,
0x0000004a00507306ULL, 0x0003e20000200c00ULL, 0x000088803a387816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000005700577306ULL, 0x000ee20000200c00ULL, 0x000088803b4a7816ULL, 0x042fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc40000011453ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000000700077306ULL, 0x000e620000200c00ULL, 0x0000541006067816ULL, 0x008fce0000000057ULL,
0x0000004100417306ULL, 0x000ee20000200c00ULL, 0x0000541007077816ULL, 0x002fce0000000052ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000000063010723cULL, 0x000fee0000001810ULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000054104e077816ULL, 0x008fce0000000041ULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x000054104d407816ULL, 0x002fce0000000040ULL,
0x0000003900397306ULL, 0x000e700000200c00ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541038387816ULL, 0x002fce0000000039ULL, 0x0000003600367306ULL, 0x000ff00000200c00ULL,
0x0000000b000b7306ULL, 0x000ff00000200c00ULL, 0x0000000e000e7306ULL, 0x000ff00000200c00ULL,
0x0000000900097306ULL, 0x000ff00000200c00ULL, 0x0000000a000a7306ULL, 0x000ff00000200c00ULL,
0x0000004b004b7306ULL, 0x000e700000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054104b067816ULL, 0x002fce0000000044ULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x000000063014723cULL, 0x000fee0000001814ULL, 0x0000004200427306ULL, 0x000ee20000200c00ULL,
0x000054103c547816ULL, 0x002fce0000000043ULL, 0x0000004f004f7306ULL, 0x000e620000200c00ULL,
0x0000541042557816ULL, 0x008fce0000000055ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x000000543018723cULL, 0x000fe20000001818ULL, 0x000054104f417816ULL, 0x002fcc0000000036ULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x00000040301c723cULL, 0x000fee000000181cULL,
0x0000003f003f7306ULL, 0x000ee20000200c00ULL, 0x000054103d3e7816ULL, 0x002fce000000003eULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x000054103f3f7816ULL, 0x008fce0000000050ULL,
0x0000005100517306ULL, 0x000ee20000200c00ULL, 0x0000003e3020723cULL, 0x000fe20000001820ULL,
0x000054104c4c7816ULL, 0x002fcc000000000bULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x00005410514d7816ULL, 0x008fce000000000eULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x0000004c3024723cULL, 0x000fee0000001824ULL, 0x0000003a003a7306ULL, 0x000ee20000200c00ULL,
0x000054104a397816ULL, 0x002fce0000000053ULL, 0x0000003b003b7306ULL, 0x000e620000200c00ULL,
0x000000383028723cULL, 0x000fe20000001828ULL, 0x000054103a3a7816ULL, 0x008fe40000000009ULL,
0x000054103b3b7816ULL, 0x002fce000000000aULL, 0x0000003a302c723cULL, 0x000fe2000000182cULL,
0x013800004530783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000101947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000c31317232ULL, 0x080fe40000000000ULL,
0x0000000c33337232ULL, 0x000fce0000000000ULL, 0x00000000473c783bULL, 0x000f280000004200ULL,
0x000000004638783bULL, 0x000f620000004200ULL, 0x00000018ff407819ULL, 0x010fe2000001143cULL,
0x000001003c417824ULL, 0x040fe200078e00ffULL, 0x000088803c4b7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe2000001143dULL,
0x000001003d437824ULL, 0x040fe200078e00ffULL, 0x000088803d427816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x000001003b547824ULL, 0x022fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011443ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff0b7819ULL, 0x000fe2000001143fULL,
0x0000003c004f7306ULL, 0x0003e20000200c00ULL, 0x000088803f4a7816ULL, 0x040fe400000000ffULL,
0x00000018ff097819ULL, 0x000fe40000011438ULL, 0x00000018ff0a7819ULL, 0x000fe40000011439ULL,
0x00000018ff0e7819ULL, 0x000fe2000001143eULL, 0x00000041004e7306ULL, 0x0009e20000200c00ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff067819ULL, 0x000fe2000001143aULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff077819ULL, 0x000fc4000001143bULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000004200527306ULL, 0x0003e20000200c00ULL,
0x000088803e417816ULL, 0x010fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001143fULL,
0x00008880383f7816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000004300537306ULL, 0x0009620000200c00ULL, 0x000001003e427824ULL, 0x002fc400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000003d004d7306ULL, 0x0003e20000200c00ULL, 0x0000888039437816ULL, 0x010fe400000000ffULL,
0x00000018ff3e7819ULL, 0x000fca000001143eULL, 0x0000003c00517306ULL, 0x0009e20000200c00ULL,
0x00000100383d7824ULL, 0x042fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004000407306ULL, 0x000e620000200c00ULL,
0x00000100393c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x000088803a387816ULL, 0x040fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003600367306ULL, 0x000f220000200c00ULL,
0x00000018ff457819ULL, 0x000fe20000011439ULL, 0x000001003a397824ULL, 0x000fc400078e00ffULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000004200467306ULL, 0x000fe20000200c00ULL, 0x00000018ff3a7819ULL, 0x000fce000001143aULL,
0x0000003d00427306ULL, 0x000bf00000200c00ULL, 0x0000003c00507306ULL, 0x0003e20000200c00ULL,
0x00005410523d7816ULL, 0x028fce0000000053ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000054104b3c7816ULL, 0x006fce000000004eULL, 0x0000004a004a7306ULL, 0x000e620000200c00ULL,
0x0000003c3010723cULL, 0x000fee0000001810ULL, 0x000054104f3c7816ULL, 0x000fe20000000040ULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x000054104d3d7816ULL, 0x010fe20000000036ULL,
0x000100003b367824ULL, 0x000fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x0000003c3014723cULL, 0x000fee0000001814ULL,
0x0000003e00477306ULL, 0x0004f00000200c00ULL, 0x0000004c004c7306ULL, 0x000f220000200c00ULL,
0x000088803b3e7816ULL, 0x004fc400000000ffULL, 0x000054104a3b7816ULL, 0x002fca0000000051ULL,
0x0000003a003d7306ULL, 0x0003f00000200c00ULL, 0x0000000900097306ULL, 0x000fe20000200c00ULL,
0x00005410413a7816ULL, 0x002fce0000000046ULL, 0x0000000a000a7306ULL, 0x000fe20000200c00ULL,
0x0000003a3018723cULL, 0x000fee0000001818ULL, 0x0000000600067306ULL, 0x000e620000200c00ULL,
0x00005410473a7816ULL, 0x008fe4000000000eULL, 0x000054104c3b7816ULL, 0x010fca000000000bULL,
0x0000000700077306ULL, 0x000fe40000200c00ULL, 0x0000003a301c723cULL, 0x000fe2000000181cULL,
0x000054103d067816ULL, 0x002fca0000000006ULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x00000001ff3b7424ULL, 0x000fce00078e00ffULL, 0x0000004300437306ULL, 0x000ea20000200c00ULL,
0x000054103f427816ULL, 0x002fce0000000042ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x0000541043437816ULL, 0x004fce0000000050ULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x000000423020723cULL, 0x000fe20000001820ULL, 0x0000541044447816ULL, 0x002fcc0000000009ULL,
0x0000003600367306ULL, 0x000e620000200c00ULL, 0x0000541045457816ULL, 0x004fce000000000aULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x0186b83b040a79a7ULL, 0x000ea2000850003fULL,
0x000000443024723cULL, 0x000fe20000001824ULL, 0x0000541036077816ULL, 0x002fca0000000007ULL,
0x0000003900397306ULL, 0x000e620000200c00ULL, 0x0186a03b04ff79a7ULL, 0x0007e2000850003fULL,
0x00000006302c723cULL, 0x000fec000000182cULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0000541038387816ULL, 0x002fce0000000039ULL, 0x00000054004b7306ULL, 0x000e640000200c00ULL,
0x000054103e397816ULL, 0x002fce000000004bULL, 0x000000383028723cULL, 0x000fee0000001828ULL,
0x000000ffff397224ULL, 0x00cfde00078e000bULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040f007c0cULL, 0x000fda000bf03070ULL,
0xffffff18007c8947ULL, 0x000fea000383ffffULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x000000ffff317224ULL, 0x000fe400078e001dULL, 0x000000ffff0f7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0019ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0013ULL,
0x000000ffff157224ULL, 0x000fc800078e0012ULL, 0x0000000000dc8947ULL, 0x000fea0003800000ULL,
0x0180000000027836ULL, 0x000fe20000000000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e0000ULL,
0x0000f9a000057802ULL, 0x000fce0000000f00ULL, 0x0000006400687944ULL, 0x00efea0003c00000ULL,
0x000000ffff057224ULL, 0x008fe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000000057308ULL, 0x000f240000001000ULL, 0xbf80000005027423ULL, 0x010fc80000000000ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000205057223ULL, 0x000fce0000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x000f240000000a00ULL,
0x0000000802027981ULL, 0x010f22000c1e9900ULL, 0x0000000000067919ULL, 0x008ee40000000000ULL,
0x00000002ff007819ULL, 0x008fe40000011606ULL, 0x0000000806067811ULL, 0x000fe200078ff0ffULL,
0x0000000502057220ULL, 0x010fca0000410000ULL, 0x00001f0005007589ULL, 0x000ee800000e0000ULL,
0x00001f0605067589ULL, 0x000f2200000e0000ULL, 0x0000001000107220ULL, 0x048fe20000410000ULL,
0x0000001100117220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000000f000f7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x000fe20000410000ULL, 0x0000001506157220ULL, 0x050fe20000410000ULL,
0x0000000e060e7220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001706177220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001b061b7220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001f061f7220ULL, 0x040fe20000410000ULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000080037047824ULL, 0x002fe200078e0204ULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x00000000000579c3ULL, 0x000e700000002700ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000282928723eULL, 0x000fe200000000ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000161716723eULL, 0x000fe200000000ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000001a1b1a723eULL, 0x000fe200000000ffULL, 0x0000860000067ab9ULL, 0x000fe20000000a00ULL,
0x000000222322723eULL, 0x000fc400000000ffULL, 0x0000002a2b2a723eULL, 0x000fe200000000ffULL,
0x00000005040472a4ULL, 0x002fe2000f8e023fULL, 0x0000000800077811ULL, 0x04cfe400078ff0ffULL,
0x0000000200027812ULL, 0x000fe400078ec0ffULL, 0x00000002ff057819ULL, 0x000fe20000011600ULL,
0x0000000807067824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x040fe400078ff8ffULL,
0x0000000502027211ULL, 0x000fe200078ff8ffULL, 0x00000008050a7824ULL, 0x040fe200078e00ffULL,
0xfffffff8060d7812ULL, 0x000fe200078ee203ULL, 0x0000000805037824ULL, 0x000fc400078e00ffULL,
0x0000000805097824ULL, 0x040fe400078e00ffULL, 0x00000008050b7824ULL, 0x000fe200078e00ffULL,
0xfffffff803037812ULL, 0x000fe200078ee202ULL, 0x0000000202057836ULL, 0x000fe40000000000ULL,
0x0000000402067836ULL, 0x000fe40000000000ULL, 0x0000000602087836ULL, 0x000fe20000000000ULL,
0xfffffff80a077812ULL, 0x000fe200078ee205ULL, 0x0001200004027836ULL, 0x000fe20000000000ULL,
0xfffffff809097812ULL, 0x000fe200078ee206ULL, 0x00000020000a7836ULL, 0x000fe20000000000ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee208ULL, 0x0000001003057824ULL, 0x000fe200078e0202ULL,
0x000000140f03723eULL, 0x000fe200000000ffULL, 0x0000000800067824ULL, 0x000fe200078e00ffULL,
0x00000003ff0f7819ULL, 0x000fe20000011600ULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0x00000003ff197819ULL, 0x000fe2000001160aULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x0000002c2d14723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0x000000101102723eULL, 0x000fe200000000ffULL, 0x000000010f087824ULL, 0x000fe200078e0200ULL,
0x000000242510723eULL, 0x000fe200000000ffULL, 0x000000010a0c7824ULL, 0x000fe200078e0219ULL,
0x0000541002127816ULL, 0x140fe20000000003ULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x0000763202137816ULL, 0x000fe20000000003ULL, 0x0000000106077824ULL, 0x000fe200078e0207ULL,
0x0000000708037812ULL, 0x000fe200078ec0ffULL, 0x0000000106087824ULL, 0x000fe200078e020dULL,
0x000000070c117812ULL, 0x000fe200078ec0ffULL, 0x0000001205007388ULL, 0x0003e20000000a00ULL,
0x0ffffff8030d7812ULL, 0x000fe200078ef800ULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x0ffffff811117812ULL, 0x000fe200078ef80aULL, 0x00000001060b7824ULL, 0x000fe200078e020bULL,
0x000000181d02723eULL, 0x000fc400000000ffULL, 0x0000001c3103723eULL, 0x000fe200000000ffULL,
0x0000001011067824ULL, 0x100fe200078e0204ULL, 0x000000262711723eULL, 0x000fe200000000ffULL,
0x000000100d127824ULL, 0x002fe200078e0204ULL, 0x0000541002047816ULL, 0x140fe40000000003ULL,
0x0000763202057816ULL, 0x000fe40000000003ULL, 0x000000150e02723eULL, 0x000fe400000000ffULL,
0x00000000000e7919ULL, 0x000e620000002600ULL, 0x0000001e1f0d723eULL, 0x000fc400000000ffULL,
0x0000763222037816ULL, 0x000fe20000000011ULL, 0x0000000407007388ULL, 0x0005e20000000a00ULL,
0x000054101a0c7816ULL, 0x140fe4000000000dULL, 0x000076321a0d7816ULL, 0x000fe4000000000dULL,
0x0000002e2f15723eULL, 0x000fe400000000ffULL, 0x0000541020047816ULL, 0x144fe40000000010ULL,
0x0000763220057816ULL, 0x000fca0000000010ULL, 0x0000000409007388ULL, 0x0005e40000000a00ULL,
0x0000541028047816ULL, 0x144fe40000000014ULL, 0x0000763228057816ULL, 0x000fca0000000014ULL,
0x000000040b007388ULL, 0x0005e40000000a00ULL, 0x0000541002047816ULL, 0x144fe40000000016ULL,
0x0000763202057816ULL, 0x000fe40000000016ULL, 0x0000541022027816ULL, 0x000fc60000000011ULL,
0x0000000408007388ULL, 0x0003e80000000a00ULL, 0x0004000c07007388ULL, 0x0005e80000000a00ULL,
0x0004000209007388ULL, 0x0007e20000000a00ULL, 0x000000080e047824ULL, 0x042fe400078e00ffULL,
0x000000080e0e7824ULL, 0x000fe200078e00ffULL, 0x0000000700077812ULL, 0x004fc400078ec0ffULL,
0xfffffff8040f7812ULL, 0x000fe400078ee20fULL, 0x000054102a027816ULL, 0x148fe40000000015ULL,
0x000076322a037816ULL, 0x000fe40000000015ULL, 0xfffffff80e197812ULL, 0x000fe400078ee219ULL,
0x000000040f0f7c10ULL, 0x000fe2000ff1e0ffULL, 0x000400020b007388ULL, 0x000fe20000000a00ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0120000012107984ULL, 0x000e620000000c00ULL,
0x0000000419197c10ULL, 0x000fe4000ff3e0ffULL, 0x000000070a097812ULL, 0x000fe200078ec0ffULL,
0x0120000006147984ULL, 0x0004e20000000c00ULL, 0x1ffffff807077812ULL, 0x000fe200078ef834ULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x0000000619047c11ULL, 0x040fe4000f8248ffULL,
0x1ffffff809097812ULL, 0x000fe400078ef834ULL, 0x0000000719057c11ULL, 0x000fe200088f4c00ULL,
0x000000ffff067224ULL, 0x004fe200000e06ffULL, 0x000000060f027c11ULL, 0x000fe2000f8048ffULL,
0x0000001009047825ULL, 0x000fc600078e0004ULL, 0x000000070f037c11ULL, 0x000fc600080f4c06ULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000001002007986ULL, 0x002fe8000c101d08ULL,
0x0000001404007986ULL, 0x008fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009200ff0a7b82ULL, 0x000e620000000a00ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000000213037824ULL, 0x000fe200078e00ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x000000080a087981ULL, 0x002322000c1e9900ULL, 0x00000001ff077424ULL, 0x000fe400078e00ffULL,
0x0000004037007824ULL, 0x000fe400078e00ffULL, 0x0000000603037e24ULL, 0x000fe4000f8e020eULL,
0x01860007040679a7ULL, 0x0002a4000850003fULL, 0x0000000403027c24ULL, 0x000fe2000f8e0200ULL,
0x0000000800e80947ULL, 0x000fec0003800000ULL, 0x00008a00ff0a7b82ULL, 0x002e620000000a00ULL,
0x00000003ff337819ULL, 0x100fe40000011605ULL, 0x0000000035117248ULL, 0x000fe40007fe0000ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x0000000833157836ULL, 0x000fe40000000000ULL,
0x0000000433137836ULL, 0x000fe40000000000ULL, 0x00000001150d7824ULL, 0x000fc400078e0205ULL,
0x00000008150e7824ULL, 0x000fe400078e00ffULL, 0x00000001130c7824ULL, 0x040fe400078e0205ULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0xfffffff80e277812ULL, 0x000fe200078ee20dULL,
0x00000001020d7824ULL, 0x000fe400078e0233ULL, 0x00000001110e7824ULL, 0x000fe200078e0a00ULL,
0xfffffff817177812ULL, 0x000fe200078ee20cULL, 0x0000000c33197836ULL, 0x000fc40000000000ULL,
0x000001000d0c7825ULL, 0x002fe200078e000aULL, 0x0000000e1300720cULL, 0x080fe40003f86070ULL,
0x0000000e1900720cULL, 0x080fe20003f66070ULL, 0x0000000102137824ULL, 0x000fe200078e0213ULL,
0x0000000c091a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010331d7836ULL, 0x000fe20000000000ULL,
0x0000000e1500720cULL, 0x080fe20003f46070ULL, 0x0000000119107824ULL, 0x000fe400078e0205ULL,
0x000000ffff1b7224ULL, 0x000fe200000e060dULL, 0x0000000e1d00720cULL, 0x000fe20003f06070ULL,
0x0000000819297824ULL, 0x000fc400078e00ffULL, 0x00000100130c7825ULL, 0x000fc600078e000aULL,
0xfffffff829297812ULL, 0x000fe200078ee210ULL, 0x0000000102117824ULL, 0x040fe200078e0215ULL,
0x0000000c091c7210ULL, 0x000fe20007f3e0ffULL, 0x000000011d127824ULL, 0x040fe400078e0205ULL,
0x000000081d2b7824ULL, 0x000fe400078e00ffULL, 0x0000000102137824ULL, 0x000fe400078e0219ULL,
0x0000010011107825ULL, 0x000fe200078e000aULL, 0xfffffff82b2b7812ULL, 0x000fc600078ee212ULL,
0x0000001433197836ULL, 0x000fe40000000000ULL, 0x0000000102157824ULL, 0x000fe400078e021dULL,
0x0000010013127825ULL, 0x000fc800078e000aULL, 0x000000ffff1d7224ULL, 0x000fe200008e060dULL,
0x00000010091e7210ULL, 0x000fe20007f3e0ffULL, 0x00000001021f7824ULL, 0x000fe200078e0219ULL,
0x0000001209207210ULL, 0x000fe20007fbe0ffULL, 0x00000100150c7825ULL, 0x000fc800078e000aULL,
0x000001001f147825ULL, 0x000fc800078e000aULL, 0x000000ffff1f7224ULL, 0x000fe200008e0611ULL,
0x0000000c09127210ULL, 0x000fe20007f3e0ffULL, 0x0000001833237836ULL, 0x000fe40000000000ULL,
0x00000001330c7824ULL, 0x000fe400078e0205ULL, 0x000000ffff217224ULL, 0x000fe200028e0613ULL,
0x0000001409107210ULL, 0x000fe20007fbe0ffULL, 0x0000000102257824ULL, 0x000fe200078e0223ULL,
0x000000070c187812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200008e060dULL,
0x0000000e1900720cULL, 0x000fe20003f26070ULL, 0x00000100250c7825ULL, 0x000fc800078e000aULL,
0x000000ffff117224ULL, 0x000fe200028e0615ULL, 0x0000000c09147210ULL, 0x000fe20007fde0ffULL,
0x0000400037157824ULL, 0x000fe200078e0204ULL, 0x0000000e3300720cULL, 0x000fe20003fa6070ULL,
0x0000001c332f7836ULL, 0x000fe40000000000ULL, 0x00002000150c7836ULL, 0x000fe40000000000ULL,
0x0000000119167824ULL, 0x040fe400078e0205ULL, 0x00000008192d7824ULL, 0x000fe200078e00ffULL,
0x0ffffff818197812ULL, 0x000fe200078ef805ULL, 0x0000001017257824ULL, 0x000fc400078e020cULL,
0x0000000102177824ULL, 0x000fe200078e022fULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee216ULL,
0x000000ffff157224ULL, 0x000fe400030e060dULL, 0x00000010190d7824ULL, 0x000fe400078e020cULL,
0x0000010017167825ULL, 0x000fc600078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a0d7faeULL, 0x0003e2000e901c48ULL, 0x0000002033317836ULL, 0x000fe20000000000ULL,
0x0000001609227210ULL, 0x000fe20007fde0ffULL, 0x0000000123247824ULL, 0x040fe200078e0205ULL,
0x000000001c257faeULL, 0x0007e2000e101c48ULL, 0x0000000823397824ULL, 0x040fe200078e00ffULL,
0x0000000e2300720cULL, 0x080fe20003fa6070ULL, 0x0000000102197824ULL, 0x040fe200078e0231ULL,
0x0000000e2f00720cULL, 0x080fe20003f86070ULL, 0x0000001027277824ULL, 0x100fe400078e020cULL,
0x0000001029297824ULL, 0x000fe200078e020cULL, 0xfffffff8390d7812ULL, 0x002fe200078ee224ULL,
0x0000010019187825ULL, 0x000fe200078e000aULL, 0x000000001e277faeULL, 0x000fe6000d101c48ULL,
0x00000024331d7836ULL, 0x008fe20000000000ULL, 0x0000000020297faeULL, 0x0003e2000d901c48ULL,
0x000000012f167824ULL, 0x000fe200078e0205ULL, 0x0000000e3100720cULL, 0x080fe20003f66070ULL,
0x000000082f1b7824ULL, 0x000fe200078e00ffULL, 0x0000000e1d00720cULL, 0x000fe20003f46070ULL,
0x000000ffff237224ULL, 0x000fe200030e0617ULL, 0x0000001809187210ULL, 0x000fe20007fde0ffULL,
0x0000000102177824ULL, 0x000fe200078e021dULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee216ULL,
0x000000102b2b7824ULL, 0x000fc400078e020cULL, 0x00000001311a7824ULL, 0x000fe400078e0205ULL,
0x000000102d2d7824ULL, 0x100fe200078e020cULL, 0x00000000122b7faeULL, 0x000fe2000c101c48ULL,
0x0000000831317824ULL, 0x000fe400078e00ffULL, 0x000000100d0d7824ULL, 0x000fe200078e020cULL,
0x00000000102d7faeULL, 0x0007e2000c901c48ULL, 0x0000010017167825ULL, 0x000fc600078e000aULL,
0x00000000140d7faeULL, 0x000be2000e901c48ULL, 0x000000011d1c7824ULL, 0x040fe400078e0205ULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0xfffffff8311d7812ULL, 0x000fe200078ee21aULL,
0x0000002833217836ULL, 0x002fe40000000000ULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x0000001609167210ULL, 0x000fe20007fde0ffULL, 0x0000000821107824ULL, 0x008fe200078e00ffULL,
0xfffffff8251f7812ULL, 0x000fe200078ee21cULL, 0x0000000102117824ULL, 0x000fc400078e0221ULL,
0x00000001210d7824ULL, 0x024fe400078e0205ULL, 0x000000101b1b7824ULL, 0x100fe400078e020cULL,
0x000000101d1d7824ULL, 0x100fe200078e020cULL, 0xfffffff8100d7812ULL, 0x000fe200078ee20dULL,
0x0000002c33257836ULL, 0x000fe20000000000ULL, 0x00000000221b7faeULL, 0x000fe2000e101c48ULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000000e2100720cULL, 0x080fe20003fc6070ULL,
0x000000101f1f7824ULL, 0x000fe200078e020cULL, 0x00000000181d7faeULL, 0x0003e2000d901c48ULL,
0x0000003033277836ULL, 0x000fe20000000000ULL, 0x0000000e2500720cULL, 0x080fe20003fa6070ULL,
0x0000010011107825ULL, 0x000fe200078e000aULL, 0x00000000161f7faeULL, 0x0005e4000d101c48ULL,
0x0000000e2700720cULL, 0x000fe20003f86070ULL, 0x0000003433297836ULL, 0x000fe20000000000ULL,
0x0000001009147210ULL, 0x000fe20007f5e0ffULL, 0x00000038332b7836ULL, 0x000fc40000000000ULL,
0x0000003c332d7836ULL, 0x000fe20000000000ULL, 0x0000000e2900720cULL, 0x080fe20003f66070ULL,
0x0000000102137824ULL, 0x000fe200078e0225ULL, 0x0000000e2b00720cULL, 0x080fe20003f26070ULL,
0x0000000127157824ULL, 0x000fe200078e0205ULL, 0x0000000e2d00720cULL, 0x000fe20003f06070ULL,
0x0000000827187824ULL, 0x002fe400078e00ffULL, 0x0000010013127825ULL, 0x000fc600078e000aULL,
0xfffffff8181d7812ULL, 0x000fe200078ee215ULL, 0x00000001250e7824ULL, 0x040fe400078e0205ULL,
0x00000008251b7824ULL, 0x000fe400078e00ffULL, 0x0000000102197824ULL, 0x000fe400078e0227ULL,
0x000000ffff157224ULL, 0x000fe200010e0611ULL, 0x0000001209167210ULL, 0x004fe20007f5e0ffULL,
0x0000010019107825ULL, 0x000fe200078e000aULL, 0xfffffff81b1b7812ULL, 0x000fc600078ee20eULL,
0x00000001290e7824ULL, 0x040fe400078e0205ULL, 0x00000008291f7824ULL, 0x000fe400078e00ffULL,
0x0000000102297824ULL, 0x000fe400078e0229ULL, 0x000000ffff177224ULL, 0x000fe200010e0613ULL,
0x0000001009187210ULL, 0x000fe20007f5e0ffULL, 0x0000010029127825ULL, 0x000fe200078e000aULL,
0xfffffff81f1f7812ULL, 0x000fc600078ee20eULL, 0x0000000102217824ULL, 0x000fe400078e022bULL,
0x000000ffff197224ULL, 0x000fe200010e0611ULL, 0x0000001209127210ULL, 0x000fe20007f5e0ffULL,
0x0000010021107825ULL, 0x000fc800078e000aULL, 0x0000000102237824ULL, 0x000fe400078e022dULL,
0x000000012b027824ULL, 0x040fe400078e0205ULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000001009107210ULL, 0x000fe20007f5e0ffULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x000000012d0e7824ULL, 0x040fe400078e0205ULL, 0x000000082d217824ULL, 0x000fe200078e00ffULL,
0xfffffff82b057812ULL, 0x000fe200078ee202ULL, 0x00000100230a7825ULL, 0x000fc600078e000aULL,
0xfffffff821217812ULL, 0x000fe200078ee20eULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x0000000a090a7210ULL, 0x000fe20007f5e0ffULL, 0x000000100d0d7824ULL, 0x100fe400078e020cULL,
0x000000101b1b7824ULL, 0x100fe400078e020cULL, 0x000000101d1d7824ULL, 0x100fe200078e020cULL,
0x00000000140d7faeULL, 0x0003e2000f101c48ULL, 0x000000101f1f7824ULL, 0x100fe400078e020cULL,
0x0000001005057824ULL, 0x100fe200078e020cULL, 0x00000000161b7faeULL, 0x0003e2000e901c48ULL,
0x0000001021217824ULL, 0x000fc400078e020cULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x00000000181d7faeULL, 0x0003e8000e101c48ULL, 0x00000000121f7faeULL, 0x0003e8000d901c48ULL,
0x0000000010057faeULL, 0x0003e8000c901c48ULL, 0x000000000a217faeULL, 0x0003e2000c101c48ULL,
0x0000000800987947ULL, 0x000fea0003800000ULL, 0x00000004050e7811ULL, 0x000fe200078fe8ffULL,
0x00004000372d7824ULL, 0x000fe200078e0204ULL, 0x0000000805127811ULL, 0x040fe400078fe8ffULL,
0x0000001405197811ULL, 0x040fe200078fe8ffULL, 0x000000010e0a7824ULL, 0x142fe200078e0205ULL,
0x00000018051b7811ULL, 0x040fe200078fe8ffULL, 0x000000080e117824ULL, 0x000fe200078e00ffULL,
0x0000000c05157811ULL, 0x040fe200078fe8ffULL, 0x00000001120b7824ULL, 0x140fe200078e0205ULL,
0x0000002405217811ULL, 0x000fe200078fe8ffULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe200078ee20aULL, 0x00000001190a7824ULL, 0x100fe200078e0205ULL,
0x0000002805237811ULL, 0x000fe200078fe8ffULL, 0x0000000819117824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20bULL, 0x000000011b0b7824ULL, 0x100fe200078e0205ULL,
0x0000001c051d7811ULL, 0x000fe200078fe8ffULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0x0000001005177811ULL, 0x000fe200078fe8ffULL, 0x00000001150c7824ULL, 0x140fe200078e0205ULL,
0xfffffff8111a7812ULL, 0x000fe200078ee20aULL, 0x0000000815137824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x00000001210a7824ULL, 0x100fe200078e0205ULL,
0x0000002c05257811ULL, 0x000fe200078fe8ffULL, 0x0000000821117824ULL, 0x000fe200078e00ffULL,
0xfffffff813167812ULL, 0x000fe200078ee20cULL, 0x00000001230b7824ULL, 0x100fe200078e0205ULL,
0x00000020051f7811ULL, 0x000fe200078fe8ffULL, 0x0000000823247824ULL, 0x000fe200078e00ffULL,
0xfffffff811227812ULL, 0x000fe200078ee20aULL, 0x000000011d0c7824ULL, 0x100fe200078e0205ULL,
0x0000003005277811ULL, 0x000fe200078fe8ffULL, 0x000000081d137824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20bULL, 0x00000001170d7824ULL, 0x140fe200078e0205ULL,
0x00008a00ff0a7b82ULL, 0x000e620000000a00ULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee20cULL, 0x00000001250c7824ULL, 0x100fe200078e0205ULL,
0x00000038052a7811ULL, 0x000fe200078fe8ffULL, 0x0000000825137824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee20dULL, 0x000000011f0d7824ULL, 0x100fe200078e0205ULL,
0x0000003405297811ULL, 0x000fe200078fe8ffULL, 0x000000081f207824ULL, 0x000fe200078e00ffULL,
0xfffffff813267812ULL, 0x000fe200078ee20cULL, 0x0000000827287824ULL, 0x000fe200078e00ffULL,
0x00000005050c7211ULL, 0x000fe200078fe8ffULL, 0x0000000102137824ULL, 0x040fe200078e0212ULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x00000001270d7824ULL, 0x100fe200078e0205ULL,
0x0000003c052c7811ULL, 0x040fe200078fe8ffULL, 0x0000000102117824ULL, 0x000fe200078e020eULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000012a127824ULL, 0x040fe200078e0205ULL,
0xfffffff828287812ULL, 0x000fe200078ee20dULL, 0x000000082a2f7824ULL, 0x000fe200078e00ffULL,
0x00000002050d7211ULL, 0x000fe200078fe8ffULL, 0x0000000102157824ULL, 0x040fe200078e0215ULL,
0x0ffffff80c0c7812ULL, 0x000fe200078ef805ULL, 0x0000000102177824ULL, 0x040fe200078e0217ULL,
0xfffffff82f127812ULL, 0x000fe200078ee212ULL, 0x0000000102197824ULL, 0x040fe200078e0219ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x00000001021b7824ULL, 0x000fc400078e021bULL,
0x00000001021d7824ULL, 0x040fe400078e021dULL, 0x00000001021f7824ULL, 0x040fe400078e021fULL,
0x0000000102217824ULL, 0x040fe400078e0221ULL, 0x0000000102237824ULL, 0x040fe400078e0223ULL,
0x0000000102257824ULL, 0x040fe400078e0225ULL, 0x0000000102277824ULL, 0x000fc400078e0227ULL,
0x00000001022b7824ULL, 0x040fe400078e0229ULL, 0x00000001290e7824ULL, 0x100fe400078e0205ULL,
0x00000001024b7824ULL, 0x040fe400078e022aULL, 0x00000001024f7824ULL, 0x000fe400078e022cULL,
0x000000012c057824ULL, 0x040fe400078e0205ULL, 0x000000082c027824ULL, 0x000fc400078e00ffULL,
0x000020002d517836ULL, 0x000fe40000000000ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff802027812ULL, 0x000fe200078ee205ULL, 0x000000100c057824ULL, 0x100fe400078e0251ULL,
0x00000010102d7824ULL, 0x000fe200078e0251ULL, 0xfffffff8290e7812ULL, 0x000fe200078ee20eULL,
0x000001000d0c7825ULL, 0x002fc800078e000aULL, 0x00000010124d7824ULL, 0x000fe200078e0251ULL,
0x000000090c0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010011107825ULL, 0x000fc800078e000aULL,
0x00000010142f7824ULL, 0x000fe200078e0251ULL, 0x0000000910107210ULL, 0x000fe20007f3e0ffULL,
0x0000010013127825ULL, 0x000fc800078e000aULL, 0x0000010015147825ULL, 0x000fe200078e000aULL,
0x0000000912127210ULL, 0x000fc60007f5e0ffULL, 0x0000001016317824ULL, 0x100fe200078e0251ULL,
0x0000000914147210ULL, 0x000fe20007f7e0ffULL, 0x0000001018337824ULL, 0x000fe400078e0251ULL,
0x0000010017167825ULL, 0x000fc800078e000aULL, 0x000000101a397824ULL, 0x000fe400078e0251ULL,
0x0000010019187825ULL, 0x000fc800078e000aULL, 0x000000101c3b7824ULL, 0x000fe400078e0251ULL,
0x000001001b1a7825ULL, 0x000fc800078e000aULL, 0x000001001d1c7825ULL, 0x000fc800078e000aULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000000916167210ULL, 0x000fe20007f1e0ffULL,
0x000000101e3d7824ULL, 0x000fe400078e0251ULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000000918187210ULL, 0x000fe20007f3e0ffULL, 0x00000010203f7824ULL, 0x000fe200078e0251ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c057faeULL, 0x0003e2000b901c48ULL,
0x000001001f1e7825ULL, 0x000fc600078e000aULL, 0x00000000102d7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x000000091a1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001022417824ULL, 0x000fe400078e0251ULL, 0x0000010021207825ULL, 0x000fe200078e000aULL,
0x00000000122f7faeULL, 0x0003e6000b901c48ULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x000000091c1c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001024437824ULL, 0x000fc400078e0251ULL,
0x0000010023227825ULL, 0x100fe200078e000aULL, 0x0000000014317faeULL, 0x0003e6000b901c48ULL,
0x0000010025247825ULL, 0x000fc800078e000aULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x000000091e1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001026457824ULL, 0x000fe400078e0251ULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x0000000920207210ULL, 0x000fe20007f3e0ffULL,
0x0000001028477824ULL, 0x000fe200078e0251ULL, 0x0000000016337faeULL, 0x0003e2000b901c48ULL,
0x0000010027267825ULL, 0x000fc600078e000aULL, 0x0000000018397faeULL, 0x0003e2000b901c48ULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x0000000922227210ULL, 0x000fe20007f5e0ffULL,
0x000001002b287825ULL, 0x000fc600078e000aULL, 0x000000001a3b7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff1d7224ULL, 0x000fe200018e061dULL, 0x0000000924247210ULL, 0x000fe20007f7e0ffULL,
0x000001004b2a7825ULL, 0x000fc600078e000aULL, 0x000000001c3d7faeULL, 0x0003e2000b901c48ULL,
0x000001004f0a7825ULL, 0x000fc800078e000aULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000000926267210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff217224ULL, 0x000fe200008e0621ULL,
0x0000000928287210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e0623ULL,
0x000000092a2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200018e0625ULL,
0x000000090a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000001e3f7faeULL, 0x0003e2000b901c48ULL, 0x000000100e497824ULL, 0x000fc400078e0251ULL,
0x000000ffff297224ULL, 0x000fe200008e0629ULL, 0x0000000020417faeULL, 0x0003e2000b901c48ULL,
0x000000ffff2b7224ULL, 0x000fe400010e062bULL, 0x0000001002517824ULL, 0x000fe200078e0251ULL,
0x0000000022437faeULL, 0x0003e2000b901c48ULL, 0x000000ffff0b7224ULL, 0x000fc600018e060bULL,
0x0000000024457faeULL, 0x0003e8000b901c48ULL, 0x0000000026477faeULL, 0x0003e8000b901c48ULL,
0x0000000028497faeULL, 0x0003e8000b901c48ULL, 0x000000002a4d7faeULL, 0x0003e8000b901c48ULL,
0x000000000a517faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x01860007040075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff097224ULL, 0x000fce00078e00ffULL,
0x000000100900780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a057210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e0bULL, 0x003d09000500780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400500780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140cULL,
0x0000000502027211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e060cULL,
0x0000000202027819ULL, 0x000fc80000001205ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000109097836ULL, 0x000fce0000000000ULL,
0x01860007040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000002037027824ULL, 0x002fca00078e0202ULL,
0x00000003ff057819ULL, 0x000fe40000011602ULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe05057812ULL, 0x000fc600078ec0ffULL, 0x0000000102067836ULL, 0x000fe40000000000ULL,
0x0000000102077824ULL, 0x040fe400078e0205ULL, 0x0000000105097824ULL, 0x000fe400078e0206ULL,
0x00000020020c7824ULL, 0x040fe200078e00ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x00000020020a7824ULL, 0x000fe200078e00ffULL, 0x0000001f09097812ULL, 0x000fe200078ec0ffULL,
0x0000001005057836ULL, 0x000fc40000000000ULL, 0x00000020020b7824ULL, 0x040fe200078e00ffULL,
0x000001e00c097812ULL, 0x000fe200078ee209ULL, 0x00000020020d7824ULL, 0x040fe200078e00ffULL,
0x000001e00a077812ULL, 0x000fe200078ee207ULL, 0x00000001020a7824ULL, 0x100fe400078e0205ULL,
0x0000001009097824ULL, 0x100fe400078e0204ULL, 0x0000001007077824ULL, 0x000fe200078e0204ULL,
0x0000001f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000106057824ULL, 0x000fe200078e0205ULL,
0x0000000009107984ULL, 0x000e680000000c00ULL, 0x0000000007147984ULL, 0x000ea20000000c00ULL,
0x0000001f05027812ULL, 0x000fc400078ec0ffULL, 0x000001e00b057812ULL, 0x000fe400078ee20aULL,
0x000001e00d0b7812ULL, 0x000fe200078ee202ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001005057824ULL, 0x100fe400078e0204ULL, 0x000000100b0b7824ULL, 0x000fe400078e0204ULL,
0x000000ffff1a7224ULL, 0x002fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0012ULL,
0x000000ffff187224ULL, 0x004fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0013ULL,
0x0000001807007388ULL, 0x000fe20000000c00ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fca00078e0017ULL, 0x0000001c09007388ULL, 0x000fe80000000c00ULL,
0x000000000b107984ULL, 0x000e680000000c00ULL, 0x0000000005147984ULL, 0x000ea20000000c00ULL,
0x000000ffff237224ULL, 0x002fe400078e0012ULL, 0x000000ffff227224ULL, 0x000fc400078e0010ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff207224ULL, 0x004fe400078e0014ULL,
0x000000ffff217224ULL, 0x000fe400078e0016ULL, 0x000000ffff107224ULL, 0x000fe400078e0015ULL,
0x000000ffff117224ULL, 0x000fe200078e0017ULL, 0x0000002005007388ULL, 0x0003e80000000c00ULL,
0x000000100b007388ULL, 0x0003e20000000c00ULL, 0x0186000d040c79a7ULL, 0x0002a4000850003fULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x0186000d040075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff097224ULL, 0x000fce00078e00ffULL,
0x000000100900780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x0000000a06057210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e07ULL, 0x003d09000500780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400500780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140aULL,
0x0000000502027211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e060aULL,
0x0000000202027819ULL, 0x000fc80000001205ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000109097836ULL, 0x000fce0000000000ULL,
0x0186000d040075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x3d80000008057820ULL, 0x012fe20000410000ULL,
0x0000000837067824ULL, 0x140fe400078e0204ULL, 0xffffffff0f077836ULL, 0x000fe40000000000ULL,
0x0000002037087824ULL, 0x000fe400078e0204ULL, 0x000000ffff0a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fce00078e00ffULL, 0x000001000a0c7824ULL, 0x000fca00078e0200ULL,
0x0000000c3500720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x004fea0003800000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0009ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fce000001ff00ULL,
0x000000010b117836ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff367224ULL, 0x000fe400078e000bULL, 0x000000ffff0b7224ULL, 0x000fe200078e0011ULL,
0x0000000a11097211ULL, 0x040fe400078ff8ffULL, 0x000000021100780cULL, 0x040fe40003f06070ULL,
0x0000000111127812ULL, 0x000fe200078ec0ffULL, 0x00000001090e7836ULL, 0x000fca0000000000ULL,
0x0000000f0e00720cULL, 0x000fe20003f26070ULL, 0x00000100090e7824ULL, 0x000fe200078e0200ULL,
0x000000010d097812ULL, 0x000fc600078e0cffULL, 0x0000000403137c24ULL, 0x000fd0000f8e020eULL,
0x0000000800b09947ULL, 0x000fea0003800000ULL, 0x00000003ff147819ULL, 0x004fe20000011602ULL,
0x00000008121f7824ULL, 0x000fe200078e00ffULL, 0x0000000e35177248ULL, 0x000fc60007fe0000ULL,
0x0000000414407836ULL, 0x000fe20000000000ULL, 0xfffffff81f127812ULL, 0x000fe200078ee202ULL,
0x00000008144c7836ULL, 0x000fe40000000000ULL, 0x0000000c14507836ULL, 0x000fe40000000000ULL,
0x0000000117177824ULL, 0x000fe400078e0a0eULL, 0x00000001400e7824ULL, 0x140fe400078e0202ULL,
0x0000000840157824ULL, 0x000fe200078e00ffULL, 0x000000171400720cULL, 0x080fe20003f26070ULL,
0x000000014c107824ULL, 0x100fe200078e0202ULL, 0x000000174000720cULL, 0x080fe20003f46070ULL,
0x000000084c1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8154a7812ULL, 0x000fe200078ee20eULL,
0x0000000150117824ULL, 0x100fe200078e0202ULL, 0x000000174c00720cULL, 0x080fe20003f66070ULL,
0x0000000850527824ULL, 0x040fe200078e00ffULL, 0xfffffff81d4e7812ULL, 0x000fe200078ee210ULL,
0x0000001014547836ULL, 0x000fe20000000000ULL, 0x000000175000720cULL, 0x080fe20003f86070ULL,
0x0000001414587836ULL, 0x000fe20000000000ULL, 0xfffffff852527812ULL, 0x000fe200078ee211ULL,
0x00000001540e7824ULL, 0x040fe200078e0202ULL, 0x000000175400720cULL, 0x040fe20003fa6070ULL,
0x0000000854117824ULL, 0x000fc400078e00ffULL, 0x0000000158107824ULL, 0x140fe400078e0202ULL,
0x0000000858157824ULL, 0x000fe200078e00ffULL, 0xfffffff811567812ULL, 0x000fe200078ee20eULL,
0x0000001814467836ULL, 0x000fe40000000000ULL, 0x0000001c145c7836ULL, 0x000fe20000000000ULL,
0xfffffff8155a7812ULL, 0x000fe200078ee210ULL, 0x0000000146347824ULL, 0x040fe200078e0202ULL,
0x00008a00ff107b82ULL, 0x000e620000000a00ULL, 0x00000008461d7824ULL, 0x000fc400078e00ffULL,
0x00000020145e7836ULL, 0x000fe40000000000ULL, 0x000000015c1e7824ULL, 0x140fe200078e0202ULL,
0xfffffff81d347812ULL, 0x000fe200078ee234ULL, 0x000000085c157824ULL, 0x000fe400078e00ffULL,
0x000000015e1c7824ULL, 0x040fe400078e0202ULL, 0x000000085e1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8151e7812ULL, 0x000fe200078ee21eULL, 0x0000002414447836ULL, 0x000fc40000000000ULL,
0x00004000370e7824ULL, 0x000fe200078e0204ULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee21cULL,
0x0000000144167824ULL, 0x140fe400078e0202ULL, 0x0000000844157824ULL, 0x000fe400078e00ffULL,
0x00000001141d7824ULL, 0x040fe400078e0202ULL, 0x0000000114417824ULL, 0x100fe200078e0213ULL,
0xfffffff815167812ULL, 0x000fe200078ee216ULL, 0x0000200009157824ULL, 0x000fe200078e020eULL,
0x000000071d1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000140437824ULL, 0x000fc400078e0213ULL,
0x0000200015157836ULL, 0x000fe20000000000ULL, 0x0ffffff81d487812ULL, 0x000fe200078ef802ULL,
0x0000010041407825ULL, 0x002fc800078e0010ULL, 0x000000014c497824ULL, 0x100fe400078e0213ULL,
0x00000001504b7824ULL, 0x000fe400078e0213ULL, 0x0000010043427825ULL, 0x000fc800078e0010ULL,
0x00000001544d7824ULL, 0x000fe400078e0213ULL, 0x00000010481d7824ULL, 0x100fe400078e0215ULL,
0x000000104a1f7824ULL, 0x000fe400078e0215ULL, 0x0000010049487825ULL, 0x000fc800078e0010ULL,
0x0000001012407825ULL, 0x000fc800078e0040ULL, 0x000001004b4a7825ULL, 0x100fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000401d7faeULL, 0x0003e2000c901c48ULL,
0x000000175800720cULL, 0x000fe40003f26070ULL, 0x000001004d4c7825ULL, 0x000fc800078e0010ULL,
0x0000001012427825ULL, 0x000fc800078e0042ULL, 0x000000104e457824ULL, 0x000fe200078e0215ULL,
0x00000000421f7faeULL, 0x0005e2000d101c48ULL, 0x0000001012487825ULL, 0x000fe200078e0048ULL,
0x000000174600720cULL, 0x000fc60003f46070ULL, 0x0000001052477824ULL, 0x000fe200078e0215ULL,
0x0000000048457faeULL, 0x0007e2000d901c48ULL, 0x00000010124a7825ULL, 0x000fe200078e004aULL,
0x000000175c00720cULL, 0x000fc60003f66070ULL, 0x0000000158417824ULL, 0x002fe200078e0213ULL,
0x000000004a477faeULL, 0x0003e2000e101c48ULL, 0x00000010564f7824ULL, 0x000fe200078e0215ULL,
0x000000175e00720cULL, 0x000fe20003f86070ULL, 0x00000010124c7825ULL, 0x000fc800078e004cULL,
0x0000000146437824ULL, 0x004fe200078e0213ULL, 0x000000004c4f7faeULL, 0x0005e2000e901c48ULL,
0x0000010041407825ULL, 0x000fe200078e0010ULL, 0x000000174400720cULL, 0x000fc60003fa6070ULL,
0x000000015c1f7824ULL, 0x100fe400078e0213ULL, 0x000000015e497824ULL, 0x108fe400078e0213ULL,
0x00000001444b7824ULL, 0x002fe400078e0213ULL, 0x0000010043427825ULL, 0x000fc800078e0010ULL,
0x000001001f447825ULL, 0x000fc800078e0010ULL, 0x0000010049467825ULL, 0x000fc800078e0010ULL,
0x000000105a1d7824ULL, 0x000fe400078e0215ULL, 0x0000001012407825ULL, 0x000fc800078e0040ULL,
0x000001004b487825ULL, 0x000fe200078e0010ULL, 0x00000000401d7faeULL, 0x0003e6000c901c48ULL,
0x00000010341f7824ULL, 0x000fe400078e0215ULL, 0x0000001012427825ULL, 0x000fc800078e0042ULL,
0x000000101e4b7824ULL, 0x000fe200078e0215ULL, 0x00000000421f7faeULL, 0x0007e2000d101c48ULL,
0x0000001012447825ULL, 0x000fc800078e0044ULL, 0x000000101c4d7824ULL, 0x004fe200078e0215ULL,
0x00000000444b7faeULL, 0x000fe2000d901c48ULL, 0x0000001012467825ULL, 0x000fc800078e0046ULL,
0x00000010161d7824ULL, 0x002fe200078e0215ULL, 0x00000000464d7faeULL, 0x000fe2000e101c48ULL,
0x0000001012487825ULL, 0x000fc800078e0048ULL, 0x0000002c141c7836ULL, 0x000fe20000000000ULL,
0x00000000481d7faeULL, 0x0003e2000e901c48ULL, 0x0000002814167836ULL, 0x000fe40000000000ULL,
0x0000003014347836ULL, 0x000fe20000000000ULL, 0x000000171c00720cULL, 0x080fe20003f46070ULL,
0x0000003414407836ULL, 0x000fe20000000000ULL, 0x000000171600720cULL, 0x080fe20003f26070ULL,
0x00000038144a7836ULL, 0x000fe20000000000ULL, 0x000000173400720cULL, 0x080fe20003f66070ULL,
0x0000003c14427836ULL, 0x008fe20000000000ULL, 0x000000174000720cULL, 0x080fe20003f86070ULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0x000000174a00720cULL, 0x080fe20003fa6070ULL,
0x000000011c1d7824ULL, 0x102fe200078e0202ULL, 0x000000174200720cULL, 0x000fe20003fc6070ULL,
0x0000000116147824ULL, 0x000fc400078e0202ULL, 0x00000008161f7824ULL, 0x040fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee21dULL, 0x0000000116177824ULL, 0x100fe400078e0213ULL,
0x000000011c1d7824ULL, 0x100fe200078e0213ULL, 0xfffffff81f147812ULL, 0x000fe200078ee214ULL,
0x00000001341f7824ULL, 0x040fe400078e0213ULL, 0x0000000134167824ULL, 0x040fe400078e0202ULL,
0x0000000834437824ULL, 0x000fc400078e00ffULL, 0x0000000140417824ULL, 0x140fe400078e0213ULL,
0x00000001401c7824ULL, 0x140fe200078e0202ULL, 0xfffffff843167812ULL, 0x000fe200078ee216ULL,
0x0000000840457824ULL, 0x000fe400078e00ffULL, 0x000000014a497824ULL, 0x100fe400078e0213ULL,
0x00000001424d7824ULL, 0x000fe200078e0213ULL, 0xfffffff8451c7812ULL, 0x000fe200078ee21cULL,
0x000000014a137824ULL, 0x000fc400078e0202ULL, 0x000000084a347824ULL, 0x000fe400078e00ffULL,
0x0000000142407824ULL, 0x040fe400078e0202ULL, 0x0000000842477824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee213ULL, 0x0000001014137824ULL, 0x100fe400078e0215ULL,
0x000000101e437824ULL, 0x100fe200078e0215ULL, 0xfffffff847407812ULL, 0x000fe200078ee240ULL,
0x0000001016457824ULL, 0x000fc400078e0215ULL, 0x000000101c477824ULL, 0x100fe400078e0215ULL,
0x00000010344b7824ULL, 0x100fe400078e0215ULL, 0x00000010404f7824ULL, 0x000fe400078e0215ULL,
0x0000010017147825ULL, 0x000fc800078e0010ULL, 0x000001001d167825ULL, 0x000fc800078e0010ULL,
0x000001001f1c7825ULL, 0x000fc800078e0010ULL, 0x00000100411e7825ULL, 0x000fc800078e0010ULL,
0x0000010049407825ULL, 0x000fc800078e0010ULL, 0x000001004d107825ULL, 0x000fc800078e0010ULL,
0x0000001012147825ULL, 0x000fc800078e0014ULL, 0x0000001012167825ULL, 0x040fe200078e0016ULL,
0x0000000014137faeULL, 0x0003e6000c901c48ULL, 0x00000010121c7825ULL, 0x040fe200078e001cULL,
0x0000000016437faeULL, 0x0003e6000d101c48ULL, 0x00000010121e7825ULL, 0x040fe200078e001eULL,
0x000000001c457faeULL, 0x0003e6000d901c48ULL, 0x0000001012407825ULL, 0x040fe200078e0040ULL,
0x000000001e477faeULL, 0x0003e6000e101c48ULL, 0x0000001012107825ULL, 0x000fe200078e0010ULL,
0x00000000404b7faeULL, 0x0003e8000e901c48ULL, 0x00000000104f7faeULL, 0x0003e2000f101c48ULL,
0x0000000800607947ULL, 0x000fea0003800000ULL, 0x0000000802597811ULL, 0x044fe200078fe8ffULL,
0x00008a00ff427b82ULL, 0x000e620000000a00ULL, 0x00000004025b7811ULL, 0x000fe200078fe8ffULL,
0x0000000812757824ULL, 0x000fe200078e00ffULL, 0x00000018025d7811ULL, 0x040fe200078fe8ffULL,
0x0000000159637824ULL, 0x140fe200078e0202ULL, 0x0000001002557811ULL, 0x040fe200078fe8ffULL,
0x0000000859107824ULL, 0x000fe200078e00ffULL, 0x00000014025f7811ULL, 0x040fe200078fe8ffULL,
0x000000015b657824ULL, 0x140fe200078e0202ULL, 0x0000002002517811ULL, 0x040fe200078fe8ffULL,
0x000000085b0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff810637812ULL, 0x000fe200078ee263ULL,
0x000000015d1d7824ULL, 0x140fe200078e0202ULL, 0x0000002c024b7811ULL, 0x040fe200078fe8ffULL,
0x000000085d107824ULL, 0x000fe200078e00ffULL, 0xfffffff80e657812ULL, 0x000fe200078ee265ULL,
0x00000001551f7824ULL, 0x140fe200078e0202ULL, 0x00000024024f7811ULL, 0x040fe200078fe8ffULL,
0x00000008550e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8101d7812ULL, 0x000fe200078ee21dULL,
0x000000015f1e7824ULL, 0x140fe200078e0202ULL, 0x0000003402477811ULL, 0x040fe200078fe8ffULL,
0x000000085f117824ULL, 0x000fe200078e00ffULL, 0xfffffff80e1f7812ULL, 0x000fe200078ee21fULL,
0x0000000151177824ULL, 0x140fe200078e0202ULL, 0x0000000c02577811ULL, 0x040fe200078fe8ffULL,
0x0000000851107824ULL, 0x000fe200078e00ffULL, 0x0000001c02537811ULL, 0x040fe200078fe8ffULL,
0x000000014b0e7824ULL, 0x140fe200078e0202ULL, 0x0000003002497811ULL, 0x040fe200078fe8ffULL,
0x000000084b697824ULL, 0x000fe200078e00ffULL, 0xfffffff8111e7812ULL, 0x000fe200078ee21eULL,
0x000000014f167824ULL, 0x140fe200078e0202ULL, 0xfffffff810177812ULL, 0x000fe200078ee217ULL,
0x000000084f117824ULL, 0x000fe200078e00ffULL, 0x0000003802457811ULL, 0x040fe200078fe8ffULL,
0x0000000147107824ULL, 0x140fe200078e0202ULL, 0xfffffff869697812ULL, 0x000fe200078ee20eULL,
0x00000008476f7824ULL, 0x000fe200078e00ffULL, 0x00000028024d7811ULL, 0x040fe200078fe8ffULL,
0x0000000157617824ULL, 0x140fe200078e0202ULL, 0xfffffff811167812ULL, 0x000fe200078ee216ULL,
0x0000000857147824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee210ULL,
0x00000001531c7824ULL, 0x140fe200078e0202ULL, 0x0000000202107211ULL, 0x040fe200078fe8ffULL,
0x0000000853157824ULL, 0x000fe200078e00ffULL, 0xfffffff814617812ULL, 0x000fe200078ee261ULL,
0x00000001490e7824ULL, 0x140fe200078e0202ULL, 0x0000003c026b7811ULL, 0x040fe200078fe8ffULL,
0x00000008496d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8151c7812ULL, 0x000fe200078ee21cULL,
0x0000000145117824ULL, 0x140fe200078e0202ULL, 0x0000001302417211ULL, 0x000fe200078fe8ffULL,
0x0000000845347824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee20eULL,
0x000000014d157824ULL, 0x000fc400078e0202ULL, 0x000000084d147824ULL, 0x000fe200078e00ffULL,
0xfffffff834717812ULL, 0x000fe200078ee211ULL, 0x00004000370e7824ULL, 0x000fe200078e0204ULL,
0x0000000710117812ULL, 0x000fe200078ec0ffULL, 0x000000086b737824ULL, 0x000fe200078e00ffULL,
0xfffffff814157812ULL, 0x000fe200078ee215ULL, 0x0000200009107824ULL, 0x000fe200078e020eULL,
0x0ffffff811117812ULL, 0x000fe200078ef802ULL, 0x000000016b147824ULL, 0x000fe400078e0202ULL,
0x0000200010107836ULL, 0x000fc40000000000ULL, 0x000000015b5b7824ULL, 0x100fe200078e0213ULL,
0xfffffff873737812ULL, 0x000fe200078ee214ULL, 0x0000000159597824ULL, 0x100fe400078e0213ULL,
0x0000000157577824ULL, 0x100fe400078e0213ULL, 0x0000000155557824ULL, 0x000fe400078e0213ULL,
0x0000001069147824ULL, 0x000fe200078e0210ULL, 0xfffffff875697812ULL, 0x000fe200078ee202ULL,
0x0000010041407825ULL, 0x002fc800078e0042ULL, 0x000000015f5f7824ULL, 0x000fe400078e0213ULL,
0x000001005b5a7825ULL, 0x000fc800078e0042ULL, 0x000000015d5d7824ULL, 0x000fe400078e0213ULL,
0x0000010059587825ULL, 0x000fc800078e0042ULL, 0x0000000153537824ULL, 0x000fe400078e0213ULL,
0x0000010057567825ULL, 0x000fc800078e0042ULL, 0x0000000151517824ULL, 0x000fe400078e0213ULL,
0x0000010055547825ULL, 0x000fc800078e0042ULL, 0x000000014f4f7824ULL, 0x000fe400078e0213ULL,
0x000001005f5e7825ULL, 0x000fc800078e0042ULL, 0x000000014d4d7824ULL, 0x000fe400078e0213ULL,
0x0000001011677824ULL, 0x000fe400078e0210ULL, 0x000001005d5c7825ULL, 0x000fc800078e0042ULL,
0x0000001069407825ULL, 0x000fc800078e0040ULL, 0x000000014b4b7824ULL, 0x000fe200078e0213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040677faeULL, 0x0003e2000b901c48ULL,
0x0000001065657824ULL, 0x000fe400078e0210ULL, 0x0000010053527825ULL, 0x000fc800078e0042ULL,
0x00000010695a7825ULL, 0x000fc800078e005aULL, 0x0000000149497824ULL, 0x000fe200078e0213ULL,
0x000000005a657faeULL, 0x0003e2000b901c48ULL, 0x0000001063637824ULL, 0x000fe400078e0210ULL,
0x0000010051507825ULL, 0x000fc800078e0042ULL, 0x0000001069587825ULL, 0x000fc800078e0058ULL,
0x0000000147477824ULL, 0x000fe200078e0213ULL, 0x0000000058637faeULL, 0x0003e2000b901c48ULL,
0x0000001061617824ULL, 0x000fe400078e0210ULL, 0x000001004f4e7825ULL, 0x000fc800078e0042ULL,
0x0000001069567825ULL, 0x000fc800078e0056ULL, 0x0000000145457824ULL, 0x000fe200078e0213ULL,
0x0000000056617faeULL, 0x0003e2000b901c48ULL, 0x000000101f1f7824ULL, 0x000fe400078e0210ULL,
0x000001004d4c7825ULL, 0x000fc800078e0042ULL, 0x0000001069547825ULL, 0x000fc800078e0054ULL,
0x000000016b6b7824ULL, 0x000fe200078e0213ULL, 0x00000000541f7faeULL, 0x0003e2000b901c48ULL,
0x000000101e1e7824ULL, 0x000fe400078e0210ULL, 0x000001004b4a7825ULL, 0x000fc800078e0042ULL,
0x00000010695e7825ULL, 0x000fc800078e005eULL, 0x000000101d1d7824ULL, 0x000fe200078e0210ULL,
0x000000005e1e7faeULL, 0x0003e2000b901c48ULL, 0x0000010049487825ULL, 0x000fc800078e0042ULL,
0x00000010695c7825ULL, 0x000fc800078e005cULL, 0x000000101c1c7824ULL, 0x000fe200078e0210ULL,
0x000000005c1d7faeULL, 0x0003e2000b901c48ULL, 0x0000010047467825ULL, 0x000fc800078e0042ULL,
0x0000001069527825ULL, 0x000fc800078e0052ULL, 0x0000001017177824ULL, 0x000fe200078e0210ULL,
0x00000000521c7faeULL, 0x0003e2000b901c48ULL, 0x0000010045447825ULL, 0x000fc800078e0042ULL,
0x0000001069507825ULL, 0x000fc800078e0050ULL, 0x0000001016167824ULL, 0x000fe200078e0210ULL,
0x0000000050177faeULL, 0x0003e2000b901c48ULL, 0x000001006b427825ULL, 0x000fc800078e0042ULL,
0x00000010694e7825ULL, 0x000fc800078e004eULL, 0x0000001015157824ULL, 0x000fe200078e0210ULL,
0x000000004e167faeULL, 0x0003e2000b901c48ULL, 0x00000010694c7825ULL, 0x000fc800078e004cULL,
0x00000010694a7825ULL, 0x000fe200078e004aULL, 0x000000004c157faeULL, 0x0003e6000b901c48ULL,
0x000000106d137824ULL, 0x000fe200078e0210ULL, 0x000000004a147faeULL, 0x0003e2000b901c48ULL,
0x0000001069487825ULL, 0x000fc800078e0048ULL, 0x000000106f127824ULL, 0x000fe200078e0210ULL,
0x0000000048137faeULL, 0x0003e2000b901c48ULL, 0x0000001069467825ULL, 0x000fc800078e0046ULL,
0x0000001071117824ULL, 0x000fe200078e0210ULL, 0x0000000046127faeULL, 0x0003e2000b901c48ULL,
0x0000001069447825ULL, 0x000fc800078e0044ULL, 0x0000001073107824ULL, 0x000fe200078e0210ULL,
0x0000000044117faeULL, 0x0003e2000b901c48ULL, 0x0000001069427825ULL, 0x000fca00078e0042ULL,
0x0000000042107faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002137836ULL, 0x002fe20000000000ULL, 0xfffffff802117812ULL, 0x040fe200078ec0ffULL,
0x000020000d0d7824ULL, 0x000fe200078e020eULL, 0x0000000702437812ULL, 0x000fe200078ec0ffULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ec0ffULL,
0x000020000d0d7836ULL, 0x000fe20000000000ULL, 0x00000007110e7812ULL, 0x000fe400078ef802ULL,
0x0000000843347812ULL, 0x000fc400078ef802ULL, 0x0000000713407812ULL, 0x000fe200078ef802ULL,
0x000080400000791aULL, 0x000fcc0000000000ULL, 0x000000010e107824ULL, 0x140fe400078e0241ULL,
0x000000080e117824ULL, 0x000fe400078e00ffULL, 0x0000000140147824ULL, 0x140fe400078e0241ULL,
0x0000000840157824ULL, 0x000fe200078e00ffULL, 0xfffffff811107812ULL, 0x000fe200078ee210ULL,
0x0000000141457836ULL, 0x000fe40000000000ULL, 0x0000000836797824ULL, 0x000fe200078e0241ULL,
0xfffffff815147812ULL, 0x000fe200078ee214ULL, 0x0000001010107824ULL, 0x000fc400078e020dULL,
0x0000000279797824ULL, 0x000fe400078e00ffULL, 0x0000001014147824ULL, 0x000fe400078e020dULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x0000000241417836ULL, 0x000fc60000000000ULL,
0x000000001414783bULL, 0x000ea40000000200ULL, 0x000000084100780cULL, 0x000fe40003f25270ULL,
0x00000018ff597819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x00008880105b7816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x0000888011727816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x000fc40000011412ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000888012547816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x00000010005a7306ULL, 0x0002e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff687819ULL, 0x004fe40000011414ULL, 0x00008880146a7816ULL, 0x000fc400000000ffULL,
0x00000018ff627819ULL, 0x000fe20000011415ULL, 0x0000001100757306ULL, 0x0005e20000200c00ULL,
0x0001000012107824ULL, 0x042fe200078e00ffULL, 0x0000888015667816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011416ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x004fe200078e00ffULL, 0x0000001c005c7306ULL, 0x000fe20000200c00ULL,
0x0000888016647816ULL, 0x000fc400000000ffULL, 0x00000018ff427819ULL, 0x000fe40000011417ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880175e7816ULL, 0x000fe200000000ffULL,
0x0000001200707306ULL, 0x0003e20000200c00ULL, 0x00000018ff677819ULL, 0x000fe40000011413ULL,
0x00008880136e7816ULL, 0x040fe200000000ffULL, 0x0000010013137824ULL, 0x000fc800078e00ffULL,
0x0000001100717306ULL, 0x0005e20000200c00ULL, 0x000000080e127824ULL, 0x002fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fcc0000011413ULL, 0x0000001d00777306ULL, 0x0003e20000200c00ULL,
0x000000010e117824ULL, 0x104fe400078e0245ULL, 0x0000000140457824ULL, 0x000fc600078e0245ULL,
0xfffffff812127812ULL, 0x000fe200078ee211ULL, 0x0001000015117824ULL, 0x040fe200078e00ffULL,
0x0000001000737306ULL, 0x0005e20000200c00ULL, 0x0000010015157824ULL, 0x000fe400078e00ffULL,
0x0000001012127824ULL, 0x000fe200078e020dULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000000121c783bULL, 0x002e620000000200ULL,
0x0001000014107824ULL, 0x044fe200078e00ffULL, 0x00000011006b7306ULL, 0x000fe20000200c00ULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000010006f7306ULL, 0x0005f00000200c00ULL,
0x00000014006d7306ULL, 0x0009e20000200c00ULL, 0x0001000016107824ULL, 0x004fc400078e00ffULL,
0x0000010016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011410ULL,
0x0000001500697306ULL, 0x0005e20000200c00ULL, 0x0000000840147824ULL, 0x010fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fc80000011416ULL, 0xfffffff814147812ULL, 0x000fe400078ee245ULL,
0x0000001600637306ULL, 0x0009e60000200c00ULL, 0x0000001014117824ULL, 0x000fe400078e020dULL,
0x0001000017147824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x002fe2000001141cULL,
0x000100001d157824ULL, 0x004fe200078e00ffULL, 0x00000013006c7306ULL, 0x0003e20000200c00ULL,
0x0000002034167824ULL, 0x010fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000010017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fc40000011415ULL,
0x0000007902157211ULL, 0x000fe200078fe0ffULL, 0x0000000279797836ULL, 0x000fe20000000000ULL,
0x0000001400617306ULL, 0x0005e20000200c00ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x000000001110783bULL, 0x002e620000000200ULL, 0x0000000134157824ULL, 0x000fe200078e0215ULL,
0x000088801c467816ULL, 0x040fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001141dULL,
0xffffffe016157812ULL, 0x000fe200078ee215ULL, 0x000100001c147824ULL, 0x044fe200078e00ffULL,
0x00000017005f7306ULL, 0x000fe20000200c00ULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x000088801d4e7816ULL, 0x000fe200000000ffULL, 0x0000001015157824ULL, 0x000fe200078e0204ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000014004d7306ULL, 0x0005e20000200c00ULL,
0x0000007902797211ULL, 0x000fe400078fe0ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff4b7819ULL, 0x000fe2000001141eULL, 0x0000000134797824ULL, 0x000fe200078e0279ULL,
0x000088801e507816ULL, 0x040fe200000000ffULL, 0x0000005b005b7306ULL, 0x000f220000200c00ULL,
0x000100001e147824ULL, 0x044fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001141fULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x000088801f527816ULL, 0x000fc400000000ffULL,
0x00000018ff577819ULL, 0x000fe40000011414ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x0000001c004f7306ULL, 0x000be20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff497819ULL, 0x002fca0000011410ULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x000100001f1c7824ULL, 0x060fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011411ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011412ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff457819ULL, 0x000fca0000011413ULL,
0x0000001d00537306ULL, 0x0007f00000200c00ULL, 0x0000001c005d7306ULL, 0x0009e20000200c00ULL,
0x000054105a1d7816ULL, 0x008fe20000000059ULL, 0x00010000105a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x000054105b1c7816ULL, 0x010fce000000005cULL, 0x0000001c143c723cULL, 0x004fe2000000183cULL,
0x0000005400547306ULL, 0x000eac0000200c00ULL, 0x00000020341c7824ULL, 0x000fe200078e00ffULL,
0x00005410751d7816ULL, 0x002fe20000000060ULL, 0x0000001e00567306ULL, 0x0003e20000200c00ULL,
0x0000541070557816ULL, 0x008fc40000000055ULL, 0xffffffe01c797812ULL, 0x000fe400078ee279ULL,
0x00005410721c7816ULL, 0x000fe40000000077ULL, 0x0000541054547816ULL, 0x004fe20000000073ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x00008880101e7816ULL, 0x042fe200000000ffULL,
0x0000010010107824ULL, 0x000fe400078e00ffULL, 0x0000001c1438723cULL, 0x000fe60000001838ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000006e006e7306ULL, 0x000e640000200c00ULL,
0x000000541430723cULL, 0x000fe20000001830ULL, 0x00010000111d7824ULL, 0x000fc400078e00ffULL,
0x00000010791c7824ULL, 0x000fc600078e0204ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000010011547824ULL, 0x000fce00078e00ffULL, 0x0000006a006a7306ULL, 0x000ef00000200c00ULL,
0x00000010005c7306ULL, 0x0009f00000200c00ULL, 0x0000001e00597306ULL, 0x000be20000200c00ULL,
0x00000018ff107819ULL, 0x010fce000001141dULL, 0x0000001000557306ULL, 0x0003e20000200c00ULL,
0x00008880111e7816ULL, 0x020fe400000000ffULL, 0x000054106c117816ULL, 0x004fe40000000067ULL,
0x00000018ff677819ULL, 0x000fe20000011454ULL, 0x000000ffff607224ULL, 0x000fe200078e001eULL,
0x0000888012547816ULL, 0x000fe200000000ffULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000054106e107816ULL, 0x002fce0000000071ULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x00000010142c723cULL, 0x000fee000000182cULL, 0x000054106a107816ULL, 0x008fe2000000006fULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000054106d117816ULL, 0x000fe20000000068ULL,
0x0001000012687824ULL, 0x000fc400078e00ffULL, 0x0000010012127824ULL, 0x000fc600078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000000101428723cULL, 0x000fe20000001828ULL, 0x00000018ff127819ULL, 0x000fcc0000011412ULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x0000541066107816ULL, 0x002fe4000000006bULL,
0x0000541069117816ULL, 0x000fca0000000062ULL, 0x0000001f005b7306ULL, 0x0003e40000200c00ULL,
0x000000101424723cULL, 0x000fec0000001824ULL, 0x0000004200427306ULL, 0x000ee20000200c00ULL,
0x000000001c1c783bULL, 0x002e620000000200ULL, 0x0000541064107816ULL, 0x004fc40000000065ULL,
0x0000541063117816ULL, 0x000fe40000000058ULL, 0x0000888013587816ULL, 0x000fe400000000ffULL,
0x0000005e005e7306ULL, 0x000ea60000200c00ULL, 0x000000101420723cULL, 0x000fea0000001820ULL,
0x0000004400447306ULL, 0x000fe40000200c00ULL, 0x000054105f117816ULL, 0x008fe20000000042ULL,
0x000000ffff427224ULL, 0x000fe200078e0058ULL, 0x000054105e107816ULL, 0x004fc80000000061ULL,
0x0000004600467306ULL, 0x000ea60000200c00ULL, 0x000000101418723cULL, 0x000fea0000001818ULL,
0x0000004c004c7306ULL, 0x000ee40000200c00ULL, 0x0001000013117824ULL, 0x000fc400078e00ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x0000541046107816ULL, 0x004fc6000000004dULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x00000018ff157819ULL, 0x000fe40000011411ULL,
0x000054104f117816ULL, 0x000fe40000000044ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x00005410534f7816ULL, 0x008fe2000000004cULL, 0x0000004e004e7306ULL, 0x000fe40000200c00ULL,
0x000000101c3c723cULL, 0x002fe2000000183cULL, 0x000054105b537816ULL, 0x004fca000000004aULL,
0x0000005100517306ULL, 0x000e700000200c00ULL, 0x0000004200147306ULL, 0x000fe20000200c00ULL,
0x000054104e4e7816ULL, 0x002fce0000000051ULL, 0x0000001500157306ULL, 0x000e620000200c00ULL,
0x0000004e1c38723cULL, 0x000fee0000001838ULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x0000541014147816ULL, 0x002fce0000000015ULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x0000541056517816ULL, 0x004fce000000004bULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054105c5b7816ULL, 0x002fce0000000049ULL, 0x0000004700477306ULL, 0x000ff00000200c00ULL,
0x0000004500457306ULL, 0x000ff00000200c00ULL, 0x0000005000507306ULL, 0x000ff00000200c00ULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x0000541050507816ULL, 0x002fce0000000057ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000000501c30723cULL, 0x000fe20000001830ULL, 0x0000541052527816ULL, 0x004fcc000000005dULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x000000521c2c723cULL, 0x000fe2000000182cULL,
0x00005410595a7816ULL, 0x002fcc000000005aULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x0000005a1c28723cULL, 0x000fe20000001828ULL, 0x0000541060607816ULL, 0x004fcc0000000055ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541067617816ULL, 0x002fce0000000048ULL,
0x0000006800697306ULL, 0x000e620000200c00ULL, 0x000000601c24723cULL, 0x000fee0000001824ULL,
0x0000001200127306ULL, 0x000ea20000200c00ULL, 0x0000541054467816ULL, 0x002fce0000000069ULL,
0x0000001300107306ULL, 0x000e620000200c00ULL, 0x0000541012477816ULL, 0x004fce0000000047ULL,
0x000000461c20723cULL, 0x000fe20000001820ULL, 0x0000541010157816ULL, 0x002fce0000000045ULL,
0x000000141c18723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff000181947ULL, 0x000fde000383ffffULL, 0x000000ffff0d7224ULL, 0x000fe200078e0009ULL,
0xffffffd8009c8947ULL, 0x000fec000383ffffULL, 0x00000001ff117424ULL, 0x000fe400078e00ffULL,
0x000000053c0d7220ULL, 0x080fe20000410000ULL, 0x000000053d3d7220ULL, 0x080fe20000410000ULL,
0x000000053e3e7220ULL, 0x080fe20000410000ULL, 0x000000053f3f7220ULL, 0x080fe20000410000ULL,
0x0000000538387220ULL, 0x080fe20000410000ULL, 0x01868811061079a7ULL, 0x000e62000850003fULL,
0x0000000539397220ULL, 0x080fe20000410000ULL, 0x000000053a3a7220ULL, 0x080fe20000410000ULL,
0x000000053b3b7220ULL, 0x080fe20000410000ULL, 0x0000000530307220ULL, 0x080fe20000410000ULL,
0x0000000531317220ULL, 0x080fe20000410000ULL, 0x0000000532327220ULL, 0x080fe20000410000ULL,
0x0000000533337220ULL, 0x080fe20000410000ULL, 0x000000052c2c7220ULL, 0x080fe20000410000ULL,
0x000000052d2d7220ULL, 0x080fe20000410000ULL, 0x000000052e2e7220ULL, 0x080fe20000410000ULL,
0x000000052f2f7220ULL, 0x080fe20000410000ULL, 0x0000000528287220ULL, 0x080fe20000410000ULL,
0x0000000529297220ULL, 0x080fe20000410000ULL, 0x000000052a2a7220ULL, 0x080fe20000410000ULL,
0x000000052b2b7220ULL, 0x080fe20000410000ULL, 0x0000000524247220ULL, 0x080fe20000410000ULL,
0x0000000525257220ULL, 0x080fe20000410000ULL, 0x0000000526267220ULL, 0x080fe20000410000ULL,
0x0000000527277220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000521217220ULL, 0x080fe20000410000ULL, 0x0000000522227220ULL, 0x080fe20000410000ULL,
0x0000000523237220ULL, 0x080fe20000410000ULL, 0x0000000518187220ULL, 0x080fe20000410000ULL,
0x0000000519197220ULL, 0x080fe20000410000ULL, 0x000000051a0e7220ULL, 0x080fe20000410000ULL,
0x000000051b1c7220ULL, 0x000fe20000410000ULL, 0x0000000000127805ULL, 0x000fe20000015200ULL,
0x01868811060075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff167224ULL, 0x000fce00078e00ffULL, 0x000000101600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011415ULL, 0x000000140b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x000000020b0b7819ULL, 0x000fc80000001214ULL,
0x0000000b0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000116167836ULL, 0x000fce0000000000ULL, 0x01868811060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000402107824ULL, 0x000fe200078e00ffULL,
0x000000070a00720cULL, 0x000fe20003f05270ULL, 0x00000080370b7824ULL, 0x000fc600078e0204ULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x000000010b0b7824ULL, 0x000fca00078e0210ULL,
0x018400000b107984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000202147824ULL, 0x000fe400078e00ffULL, 0x00000001350c7824ULL, 0x000fc600078e0a0cULL,
0x0000000614157812ULL, 0x000fc800078ec0ffULL, 0x0000000115177812ULL, 0x040fe400078efcffULL,
0x00000008151b7812ULL, 0x000fe400078efcffULL, 0x0000000c1700720cULL, 0x080fe40003f26070ULL,
0x0000001015177812ULL, 0x000fe400078efcffULL, 0x0000000c1b00720cULL, 0x080fe40003f06070ULL,
0x0000000c1700720cULL, 0x000fc40003fc6070ULL, 0x00000011151b7812ULL, 0x040fe400078efcffULL,
0x0000001815177812ULL, 0x040fe400078efcffULL, 0x0000000c1500720cULL, 0x080fe40003f46070ULL,
0x0000000c1b00720cULL, 0x080fe40003fa6070ULL, 0x0000000c1700720cULL, 0x000fe40003f66070ULL,
0x00000009151d7812ULL, 0x000fc400078efcffULL, 0x00000019151b7812ULL, 0x040fe400078efcffULL,
0x0000002015177812ULL, 0x000fe400078efcffULL, 0xff8000003e3e7808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff8000003f3f7808ULL, 0x000fe40004800000ULL,
0xff8000003d3d7808ULL, 0x000fc40004800000ULL, 0x0000000c1d00720cULL, 0x080fe40003f86070ULL,
0x0000000c1b00720cULL, 0x080fe40003f46070ULL, 0x0000000c1700720cULL, 0x000fe40003f26070ULL,
0x00000021151b7812ULL, 0x040fe400078efcffULL, 0x0000002815177812ULL, 0x000fe400078efcffULL,
0xff8000003a3a7808ULL, 0x000fc40004000000ULL, 0xff80000038387808ULL, 0x000fe40004000000ULL,
0xff8000003b3b7808ULL, 0x000fe40006000000ULL, 0xff80000039397808ULL, 0x000fe40006000000ULL,
0x0000000c1b00720cULL, 0x080fe40003f06070ULL, 0x0000000c1700720cULL, 0x000fe40003f86070ULL,
0x00000029151b7812ULL, 0x000fc400078efcffULL, 0x0000003015177812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40007000000ULL, 0xff80000030307808ULL, 0x000fe40007000000ULL,
0xff80000033337808ULL, 0x000fe40006800000ULL, 0xff80000031317808ULL, 0x000fe40006800000ULL,
0x0000000c1b00720cULL, 0x000fc40003fc6070ULL, 0x0000000c1700720cULL, 0x000fe40003fa6070ULL,
0x00000031151b7812ULL, 0x040fe400078efcffULL, 0x0000003815177812ULL, 0x040fe400078efcffULL,
0x0000003915157812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fe40005800000ULL,
0xff8000002c2c7808ULL, 0x000fc40005800000ULL, 0xff8000002f2f7808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40005000000ULL, 0xff8000002a2a7808ULL, 0x000fe40004800000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0x0000000c1b00720cULL, 0x080fe40003f66070ULL,
0x0000000c1700720cULL, 0x000fc40003f46070ULL, 0x0000000c1500720cULL, 0x000fe40003f26070ULL,
0xff8000002b2b7808ULL, 0x000fe40004000000ULL, 0xff80000029297808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000024247808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fc40007000000ULL, 0xff80000025257808ULL, 0x000fe40007000000ULL,
0xff80000022227808ULL, 0x000fe40006800000ULL, 0xff80000020207808ULL, 0x000fe40006800000ULL,
0xff80000023237808ULL, 0x000fe40005800000ULL, 0xff80000021217808ULL, 0x000fe40005800000ULL,
0xff8000000e0e7808ULL, 0x000fc40005000000ULL, 0xff80000018187808ULL, 0x000fe40005000000ULL,
0xff8000001c1c7808ULL, 0x000fe40004800000ULL, 0xff80000019197808ULL, 0x000fce0004800000ULL,
0x0000000d1000720bULL, 0x004fe20003f1e000ULL, 0x000000010a0a7836ULL, 0x000fe20000000000ULL,
0xfffffff8ff437812ULL, 0x000fe400078ee243ULL, 0x000000100d107208ULL, 0x000fc80004000000ULL,
0x0000003d1000720bULL, 0x000fc80003f1e000ULL, 0x000000103d157208ULL, 0x000fc80004000000ULL,
0x000000381500720bULL, 0x000fc80003f1e000ULL, 0x00000015380c7208ULL, 0x000fc80004000000ULL,
0x000000390c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c39157208ULL, 0x000fc80004000000ULL,
0x000000301500720bULL, 0x000fc80003f1e000ULL, 0x00000015300c7208ULL, 0x000fc80004000000ULL,
0x000000310c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c31157208ULL, 0x000fc80004000000ULL,
0x0000002c1500720bULL, 0x000fc80003f1e000ULL, 0x000000152c0c7208ULL, 0x000fc80004000000ULL,
0x0000002d0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c2d157208ULL, 0x000fc80004000000ULL,
0x000000281500720bULL, 0x000fc80003f1e000ULL, 0x00000015280c7208ULL, 0x000fc80004000000ULL,
0x000000290c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c29157208ULL, 0x000fc80004000000ULL,
0x000000241500720bULL, 0x000fc80003f1e000ULL, 0x00000015240c7208ULL, 0x000fe40004000000ULL,
0x0000003e1100720bULL, 0x000fe40003f1e000ULL, 0x000000250c00720bULL, 0x000fc80003f3e000ULL,
0x0000000c25157208ULL, 0x000fe40004800000ULL, 0x000000113e0c7208ULL, 0x000fe40004000000ULL,
0x000000201500720bULL, 0x000fe40003f3e000ULL, 0x0000003f0c00720bULL, 0x000fe40003f1e000ULL,
0x0000001520107208ULL, 0x000fe40004800000ULL, 0x0000000c3f117208ULL, 0x000fc40004000000ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000003a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001021157208ULL, 0x000fe40004800000ULL, 0x000000113a0c7208ULL, 0x000fe40004000000ULL,
0x000000181500720bULL, 0x000fe40003f3e000ULL, 0x0000003b0c00720bULL, 0x000fc40003f1e000ULL,
0x0000001518107208ULL, 0x000fe40004800000ULL, 0x0000000c3b117208ULL, 0x000fe40004000000ULL,
0x000000191000720bULL, 0x000fe40003f3e000ULL, 0x000000321100720bULL, 0x000fe40003f1e000ULL,
0x0000001019107208ULL, 0x000fe40004800000ULL, 0x00000011320c7208ULL, 0x000fc60004000000ULL,
0x0c401f0010157f89ULL, 0x000ea200000e0000ULL, 0x000000330c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c33117208ULL, 0x000fc80004000000ULL, 0x0000002e1100720bULL, 0x000fc80003f1e000ULL,
0x000000112e0c7208ULL, 0x000fc80004000000ULL, 0x0000002f0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c2f117208ULL, 0x000fe40004000000ULL, 0x000000151000720bULL, 0x004fe40003f3e000ULL,
0x0000002a1100720bULL, 0x000fe40003f1e000ULL, 0x0000001015157208ULL, 0x000fe40004800000ULL,
0x000000112a0c7208ULL, 0x000fc60004000000ULL, 0x0c201f0015107f89ULL, 0x000ea200000e0000ULL,
0x0000002b0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c2b117208ULL, 0x000fc80004000000ULL,
0x000000261100720bULL, 0x000fc80003f1e000ULL, 0x00000011260c7208ULL, 0x000fc80004000000ULL,
0x000000270c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c27117208ULL, 0x000fe40004000000ULL,
0x000000101500720bULL, 0x004fe40003f3e000ULL, 0x000000221100720bULL, 0x000fe40003f1e000ULL,
0x0000001510107208ULL, 0x000fe40004800000ULL, 0x00000011220c7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10147820ULL, 0x000fe20000410000ULL, 0x000000230c00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b0d117823ULL, 0x100fe20000010814ULL, 0x0000000c230d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010814ULL,
0x0000001100157308ULL, 0x000fe20000000800ULL, 0x0000000e0d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010814ULL, 0x0000000d0e0d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010814ULL,
0x0000003d00167308ULL, 0x000ea20000000800ULL, 0x0000001c0d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010814ULL, 0x0000000d1c0d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010814ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010814ULL,
0x0c401f000d0c7f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b19147823ULL, 0x000fc80000010814ULL, 0x0000003900397308ULL, 0x000f300000000800ULL,
0x0000001400417308ULL, 0x0005f00000000800ULL, 0x00000021003d7308ULL, 0x000be20000000800ULL,
0x000000151614723eULL, 0x004fc400000000ffULL, 0x0000000c0d00720bULL, 0x008fe40003f1e000ULL,
0x000000383916723eULL, 0x010fe400000000ffULL, 0x0000000d0c0c7208ULL, 0x000fe20004000000ULL,
0x3c003c00ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000028001d7308ULL, 0x000fe60000000800ULL,
0x0c201f000c117f89ULL, 0x000eaa00000e0000ULL, 0x00000029001e7308ULL, 0x000ff00000000800ULL,
0x0000002c001a7308ULL, 0x000ff00000000800ULL, 0x00000020002c7308ULL, 0x000fe20000000800ULL,
0x000000110c00720bULL, 0x004fc80003f1e000ULL, 0x0000000c11117208ULL, 0x000fc60004000000ULL,
0x0000003000307308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b111f7820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001081fULL,
0x0000003a00177308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b2a217823ULL, 0x122fe2000001081fULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001081fULL,
0x0000003b000c7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b0e0e7823ULL, 0x000fce000001081fULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x000000170c17723eULL, 0x002fce00000000ffULL,
0x0000003f003f7308ULL, 0x000e620000000800ULL, 0x3c003c00ff0c7424ULL, 0x000fce00078e00ffULL,
0x0000002e001b7308ULL, 0x0005e20000000800ULL, 0x0000003e3f15723eULL, 0x002fce00000000ffULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2e7823ULL, 0x004fe4000001081fULL,
0x0000000c1428723cULL, 0x000fea00000018ffULL, 0x0000002d002d7308ULL, 0x000e700000000800ULL,
0x0000003200197308ULL, 0x000fe20000000800ULL, 0x0000001a2d1a723eULL, 0x002fce00000000ffULL,
0x0000003300207308ULL, 0x000e700000000800ULL, 0x0000002f00367308ULL, 0x0004e20000000800ULL,
0x000000192019723eULL, 0x002fce00000000ffULL, 0x0000001800347308ULL, 0x0003e20000000800ULL,
0x0c401f0013207f89ULL, 0x000f2200000e0000ULL, 0x3fb8aa3b1c2f7823ULL, 0x004fe2000001081fULL,
0x0000001d1e1c723eULL, 0x000fe400000000ffULL, 0x0000001b361b723eULL, 0x008fc600000000ffULL,
0x0000002100327308ULL, 0x0005e20000000800ULL, 0x000000303118723eULL, 0x002fce00000000ffULL,
0x0000000c1828723cULL, 0x000fe20000001828ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0c401f0012217f89ULL, 0x004e6e00000e0000ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000201300720bULL, 0x010fc80003f3e000ULL, 0x0000001320137208ULL, 0x000fe40004800000ULL,
0x0000002c3d20723eULL, 0x000fe200000000ffULL, 0x0000002e00337308ULL, 0x000ee20000000800ULL,
0x00000008432c7824ULL, 0x000fe200078e00ffULL, 0x00000024251e723eULL, 0x004fcc00000000ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000211200720bULL, 0x002fe20003f1e000ULL,
0x0000000843257836ULL, 0x000fe20000000000ULL, 0x00000003ff247819ULL, 0x000fe40000011602ULL,
0x0000001221127208ULL, 0x000fe40004000000ULL, 0x00000032331d723eULL, 0x008fe200000000ffULL,
0x0000002700277308ULL, 0x000e640000000800ULL, 0x0c201f0012317f89ULL, 0x000eac00000e0000ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x00000026271f723eULL, 0x002fce00000000ffULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x0000080037277824ULL, 0x000fc800078e0204ULL,
0x0001200027307836ULL, 0x000fe20000000000ULL, 0x0000000c1c28723cULL, 0x000fe40000001828ULL,
0x00000022002d7308ULL, 0x0007e20000000800ULL, 0x000000311200720bULL, 0x004fc80003f1e000ULL,
0x0000001231127208ULL, 0x000fc60004000000ULL, 0x00000023002e7308ULL, 0x0002a20000000800ULL,
0x000000344122723eULL, 0x008fe400000000ffULL, 0x0000000302ff7812ULL, 0x000fc6000780c0ffULL,
0x000000ffff277224ULL, 0x000fe200078e0022ULL, 0x0000000e2f23723eULL, 0x002fe200000000ffULL,
0x000000ffff2f7224ULL, 0x000fe200078e001aULL, 0x00000003240e7812ULL, 0x000fe200078ec0ffULL,
0x0000000843247824ULL, 0x000fe200078e00ffULL, 0x0000002d2e21723eULL, 0x004fc600000000ffULL,
0x000000010e437824ULL, 0x040fe400078e0243ULL, 0x000000010e267824ULL, 0x000fe400078e0225ULL,
0x0c201f00130e7f89ULL, 0x000e6200000e0000ULL, 0x00000008252d7824ULL, 0x040fe200078e00ffULL,
0x0000000c2028723cULL, 0x000fe20000001828ULL, 0x00000008252e7824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee243ULL, 0x0000000443257836ULL, 0x000fe20000000000ULL,
0xfffffff82d267812ULL, 0x000fe200078ee226ULL, 0x0000000c43437836ULL, 0x000fc40000000000ULL,
0x00000010240c7824ULL, 0x000fe200078e0230ULL, 0xfffffff82c257812ULL, 0x000fe200078ee225ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0014ULL, 0xfffffff82e437812ULL, 0x000fe200078ee243ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0016ULL, 0x00000010250d7824ULL, 0x000fe400078e0230ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0018ULL, 0x000000ffff147224ULL, 0x000fc400078e0015ULL,
0x000000ffff247224ULL, 0x000fe200078e001cULL, 0x0000002c0c007844ULL, 0x000fe20000000200ULL,
0x0000001026297824ULL, 0x000fe200078e0230ULL, 0x0000000e1300720bULL, 0x002fe20003f3e000ULL,
0x000000ffff257224ULL, 0x000fe400078e001eULL, 0x000000ffff267224ULL, 0x000fe200078e0020ULL,
0x000000130e137208ULL, 0x000fe20004800000ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x000000240d007844ULL, 0x0003e20000000200ULL,
0x000000ffff177224ULL, 0x000fc400078e001bULL, 0x0000001043437824ULL, 0x000fe400078e0230ULL,
0x000000ffff187224ULL, 0x000fe200078e001dULL, 0x0000001429007844ULL, 0x0005e20000000200ULL,
0x000000ffff197224ULL, 0x000fe400078e001fULL, 0x000000ffff1a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0023ULL, 0x000000ffff1c7224ULL, 0x000fc400078e0028ULL,
0x000000ffff1d7224ULL, 0x000fe200078e002aULL, 0x0000001843007844ULL, 0x0005e20000000200ULL,
0x00000001ff0d7424ULL, 0x002fc600078e00ffULL, 0x018000100b008388ULL, 0x0005e80000000c00ULL,
0x0182001c0b008388ULL, 0x0005e20000000a00ULL, 0x0000000f0a00720cULL, 0x000fe20003f06070ULL,
0x0186080d08ff79a7ULL, 0x0005e2000850003fULL, 0x0186100d08ff79a7ULL, 0x0005e2000850003fULL,
0x0186180d08ff79a7ULL, 0x0005e2000850003fULL, 0x0186200d08ff79a7ULL, 0x0005f2000850003fULL,
0xffffffc000988947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000002007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000200008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff02ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000002027812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x006fe400078e0005ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffe9c02d07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000562ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006e0ULL, 0x0000000000000240ULL, 0x0000001600000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000920ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a00ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a54ULL, 0x0000000000000828ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001280ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001280ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000012c8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001300ULL, 0x0000000000016180ULL, 0x0000001600000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000017480ULL, 0x0000000000000044ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x00000000000174d0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000174d0ULL, 0x0000000000000258ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000017aa8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000017aa8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000012c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001300ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000016180ULL, 0x0000000000016180ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017480ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000174d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000258ULL, 0x0000000000000258ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_90_cubin_len = 97272;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
