/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001d0d0ULL, 0x000000000001cd50ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x000000000001ae70ULL, 0x0000000000000170ULL,
0x000b0022000004bdULL, 0x000000000001afe0ULL, 0x0000000000000050ULL, 0x000b0022000004e8ULL,
0x000000000001b030ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x000000000001b070ULL,
0x0000000000000110ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000001b180ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001ae7000000000ULL, 0x0000040400000000ULL,
0x810c0000015c0400ULL, 0x006a340400288080ULL, 0x0000000000000000ULL, 0x000000b4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808f0828808081ULL, 0x9408288080930828ULL, 0x2880809808288080ULL, 0x809d082880809b08ULL,
0x082880809e082880ULL, 0x8080a1082880809fULL, 0xa308288080a20828ULL, 0x288080ae08288080ULL,
0x80ba08288080b808ULL, 0x08288080bc082880ULL, 0x8080c108288080beULL, 0xc308288080c20828ULL,
0x288080c608288080ULL, 0x80cc08288080c908ULL, 0x08288080cd082880ULL, 0x8082801628808084ULL,
0x0000000000031028ULL, 0x2880808492000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001ae7000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x000000b4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8a08288080880828ULL, 0x2880808c08288080ULL,
0x8090082880808e08ULL, 0x0828808091082880ULL, 0x8080930828808092ULL, 0x9e08288080940828ULL,
0x288080a108288080ULL, 0x80a308288080a208ULL, 0x08288080ae082880ULL, 0x8080ba08288080b8ULL,
0xc108288080be0828ULL, 0x288080c208288080ULL, 0x80c608288080c308ULL, 0x08288080cc082880ULL,
0x8080b208288080cdULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080b292ULL,
0x0000002cffffffffULL, 0x0000015800000000ULL, 0x0001afe000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8088288080b20900ULL, 0x0000000000002880ULL, 0x000000b4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080860828808081ULL, 0x8c082880808a0828ULL, 0x2880808e08288080ULL, 0x8091082880809008ULL,
0x0828808092082880ULL, 0x8080940828808093ULL, 0xa1082880809e0828ULL, 0x288080a208288080ULL,
0x80ae08288080a308ULL, 0x08288080b8082880ULL, 0x8080bc08288080baULL, 0xc108288080be0828ULL,
0x288080c308288080ULL, 0x80c908288080c608ULL, 0x08288080cc082880ULL, 0x8080c208288080cdULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080c292ULL, 0x0000001cffffffffULL,
0x0000025000000000ULL, 0x0001b03000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000b4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8c082880808a0828ULL, 0x2880808e08288080ULL,
0x8091082880809008ULL, 0x0828808092082880ULL, 0x8080940828808093ULL, 0xa1082880809e0828ULL,
0x288080a208288080ULL, 0x80ae08288080a308ULL, 0x08288080b8082880ULL, 0x8080bc08288080baULL,
0xc108288080be0828ULL, 0x288080c208288080ULL, 0x80cc08288080c608ULL, 0x08288080cd082880ULL,
0x80828016288080c3ULL, 0x0000000000031028ULL, 0x288080c392000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x0000033800000000ULL, 0x0001b07000000000ULL, 0x0000011000000000ULL,
0x0000140400000000ULL, 0x80c2288080c30900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL,
0x000823040000008aULL, 0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL,
0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL,
0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL,
0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0050016000000017ULL, 0x000c170400501903ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01982904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01982804ffffffffULL, 0x00000100000000e0ULL, 0x0000205000000470ULL,
0x000021d0000020e0ULL, 0x0000279000002340ULL, 0x00002820000027c0ULL, 0x0000469000002880ULL,
0x00004730000046c0ULL, 0x00006620000047a0ULL, 0x000067c0000066b0ULL, 0x00006db000006920ULL,
0x00006e4000006de0ULL, 0x00008aa000006ea0ULL, 0x00008b3000008ad0ULL, 0x0000a8a000008b90ULL,
0x0000aa400000a930ULL, 0x0000b0300000aba0ULL, 0x0000b0d00000b060ULL, 0x0000cd400000b140ULL,
0x0000cde00000cd70ULL, 0x0000ebf00000ce50ULL, 0x0000ed900000ec80ULL, 0x0000f3800000eef0ULL,
0x0000f4200000f3b0ULL, 0x000110c00000f490ULL, 0x00011160000110f0ULL, 0x000123b0000111d0ULL,
0x00012b90000123c0ULL, 0x00018f8000018f40ULL, 0x00018fa000018f90ULL, 0x0001901000018ff0ULL,
0x0001904000019030ULL, 0x00019cf000019c90ULL, 0x00019dd000019d60ULL, 0x00019eb000019e40ULL,
0x00019fb000019f30ULL, 0x0001a0700001a010ULL, 0x0001a1500001a0e0ULL, 0x0001a2300001a1c0ULL,
0x0001a3100001a2a0ULL, 0x0001a3d00001a370ULL, 0x0001a4b00001a440ULL, 0x0001a5b00001a530ULL,
0x0001a6b00001a630ULL, 0x0001a7700001a710ULL, 0x0001a8500001a7e0ULL, 0x0001a9500001a8d0ULL,
0x0001aa500001a9d0ULL, 0x0001ab500001aad0ULL, 0x0001ac500001abd0ULL, 0x0001ad500001acd0ULL,
0x0001ae500001add0ULL, 0x0000020006003904ULL, 0x00018600000000ffULL, 0x000002c0003f0100ULL,
0x000186080000000fULL, 0x000002f0003f0120ULL, 0x000186880000000fULL, 0x00000440003f0120ULL,
0x000186a80000000fULL, 0x00000460003f0120ULL, 0x000186b8000000ffULL, 0x000004f0003f0100ULL,
0x00018600000000ffULL, 0x00000640003f0107ULL, 0x0001868c00000017ULL, 0x000006a0003f0102ULL,
0x0001868800000017ULL, 0x00000f00003f0101ULL, 0x000186a8000000ffULL, 0x00001020003f0107ULL,
0x000186a8000000ffULL, 0x00001080003f0101ULL, 0x000186b8000000ffULL, 0x00001210003f0101ULL,
0x000186bc000000ffULL, 0x000013e0003f0105ULL, 0x000186bc000000ffULL, 0x00001ca0003f0105ULL,
0x000186b0000000ffULL, 0x00001d20003f0107ULL, 0x000186b0000000ffULL, 0x00001d80003f0101ULL,
0x0001860800000017ULL, 0x00001da0003f0101ULL, 0x0001860c00000017ULL, 0x00001f70003f0105ULL,
0x0001860c00000017ULL, 0x000024f0003f0105ULL, 0x000186ac000000ffULL, 0x000026c0003f0105ULL,
0x000186ac000000ffULL, 0x00003920003f0105ULL, 0x000186b8000000ffULL, 0x00003950003f0101ULL,
0x000186bc000000ffULL, 0x00003b10003f0105ULL, 0x000186bc000000ffULL, 0x00004360003f0105ULL,
0x000186a8000000ffULL, 0x000043e0003f0107ULL, 0x000186a8000000ffULL, 0x00004410003f0101ULL,
0x000186b4000000ffULL, 0x000045e0003f0105ULL, 0x000186b4000000ffULL, 0x00005760003f0105ULL,
0x000186b8000000ffULL, 0x000057d0003f0101ULL, 0x00018688000000ffULL, 0x00005820003f0101ULL,
0x000186bc000000ffULL, 0x000059f0003f0105ULL, 0x000186bc000000ffULL, 0x00006240003f0105ULL,
0x000186b0000000ffULL, 0x00006340003f0107ULL, 0x000186b0000000ffULL, 0x000063a0003f0101ULL,
0x0001862800000017ULL, 0x000063c0003f0101ULL, 0x0001862c00000017ULL, 0x00006590003f0105ULL,
0x0001862c00000017ULL, 0x00006b10003f0105ULL, 0x000186ac000000ffULL, 0x00006ce0003f0105ULL,
0x000186ac000000ffULL, 0x00007d30003f0105ULL, 0x000186b8000000ffULL, 0x00007d60003f0101ULL,
0x000186bc000000ffULL, 0x00007f20003f0105ULL, 0x000186bc000000ffULL, 0x00008770003f0105ULL,
0x000186a8000000ffULL, 0x000087f0003f0107ULL, 0x000186a8000000ffULL, 0x00008820003f0101ULL,
0x000186b4000000ffULL, 0x000089f0003f0105ULL, 0x000186b4000000ffULL, 0x00009a50003f0105ULL,
0x000186b8000000ffULL, 0x00009ac0003f0101ULL, 0x00018690000000ffULL, 0x00009b20003f0101ULL,
0x000186bc000000ffULL, 0x00009cf0003f0105ULL, 0x000186bc000000ffULL, 0x0000a540003f0105ULL,
0x000186b0000000ffULL, 0x0000a5c0003f0107ULL, 0x000186b0000000ffULL, 0x0000a620003f0101ULL,
0x0001864800000017ULL, 0x0000a640003f0101ULL, 0x0001864c00000017ULL, 0x0000a810003f0105ULL,
0x0001864c00000017ULL, 0x0000ad90003f0105ULL, 0x000186ac000000ffULL, 0x0000af60003f0105ULL,
0x000186ac000000ffULL, 0x0000bfd0003f0105ULL, 0x000186b8000000ffULL, 0x0000c000003f0101ULL,
0x000186bc000000ffULL, 0x0000c1c0003f0105ULL, 0x000186bc000000ffULL, 0x0000ca10003f0105ULL,
0x000186a8000000ffULL, 0x0000ca90003f0107ULL, 0x000186a8000000ffULL, 0x0000cac0003f0101ULL,
0x000186b4000000ffULL, 0x0000cc90003f0105ULL, 0x000186b4000000ffULL, 0x0000dd10003f0105ULL,
0x000186b8000000ffULL, 0x0000dd80003f0101ULL, 0x00018698000000ffULL, 0x0000ddf0003f0101ULL,
0x000186bc000000ffULL, 0x0000dfc0003f0105ULL, 0x000186bc000000ffULL, 0x0000e810003f0105ULL,
0x000186b0000000ffULL, 0x0000e910003f0107ULL, 0x000186b0000000ffULL, 0x0000e970003f0101ULL,
0x0001866800000017ULL, 0x0000e990003f0101ULL, 0x0001866c00000017ULL, 0x0000eb60003f0105ULL,
0x0001866c00000017ULL, 0x0000f0e0003f0105ULL, 0x000186ac000000ffULL, 0x0000f2b0003f0105ULL,
0x000186ac000000ffULL, 0x00010330003f0105ULL, 0x000186b8000000ffULL, 0x00010360003f0101ULL,
0x000186bc000000ffULL, 0x00010520003f0105ULL, 0x000186bc000000ffULL, 0x00010d90003f0105ULL,
0x000186a8000000ffULL, 0x00010e10003f0107ULL, 0x000186a8000000ffULL, 0x00010e40003f0101ULL,
0x000186b4000000ffULL, 0x00011010003f0105ULL, 0x000186b4000000ffULL, 0x00012070003f0105ULL,
0x000186b8000000ffULL, 0x000120d0003f0101ULL, 0x000186a0000000ffULL, 0x00012e00003f0101ULL,
0x00018600000000ffULL, 0x00014a30003f0101ULL, 0x00018604000000ffULL, 0x00014c00003f0105ULL,
0x00018604000000ffULL, 0x00014f70003f0105ULL, 0x00018600000000ffULL, 0x00014fa0003f0101ULL,
0x00018604000000ffULL, 0x00015160003f0105ULL, 0x00018604000000ffULL, 0x00018380003f0105ULL,
0x000000000000002dULL, 0x00018490003f0101ULL, 0x000000040000002dULL, 0x00018660003f0105ULL,
0x000000040000002dULL, 0x00019ae0003f0105ULL, 0x000000000000002fULL, 0x00019b40003f0101ULL,
0x000000080000002fULL, 0x00019ba0003f0101ULL, 0x000000100000002fULL, 0x00019c10003f0101ULL,
0x000000180000002fULL, 0x00053803003f0101ULL, 0x00012cd000101c04ULL, 0x00015270000151c0ULL,
0x0000040100019c50ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000040cULL, 0x0000001a00000002ULL,
0x0000000000000324ULL, 0x0000001a00000002ULL, 0x000000000000022cULL, 0x0000001a00000002ULL,
0x0000000000000144ULL, 0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL,
0x00000000000003e3ULL, 0x0000001a00000002ULL, 0x0000000000000300ULL, 0x0000001a00000002ULL,
0x0000000000000208ULL, 0x0000001a00000002ULL, 0x000000000000011bULL, 0x0000001a00000002ULL,
0x0000000000018700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x00000000000c7806ULL, 0x000fe200038e0000ULL, 0x00005800ff297624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000000c00087300ULL, 0x000fe200000e0000ULL, 0x0000000829077824ULL, 0x000fe400078e00ffULL,
0x0000000000047919ULL, 0x000ee80000002200ULL, 0x0000000000007919ULL, 0x000f220000002600ULL,
0x0000000c00137309ULL, 0x000ea60000000000ULL, 0x00000000000a7919ULL, 0x000f280000000000ULL,
0x00000000002b7919ULL, 0x000f220000002700ULL, 0x00000005ff027819ULL, 0x002fc6000001160fULL,
0x00001fff030e7589ULL, 0x0047e200000e0000ULL, 0x000000ffff137224ULL, 0x000fc600078e0a13ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000010003037a24ULL, 0x008fe400078e0204ULL,
0x0000000800067824ULL, 0x010fe400078e00ffULL, 0x00000000030f7a24ULL, 0x000fe200078e020fULL,
0x0000000a0800720cULL, 0x000fe20003f02070ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000002b07087224ULL, 0x000fe400078e0206ULL, 0x000000ff0f00720cULL, 0x000fc40003f25270ULL,
0x0000000f0f00780cULL, 0x040fe40003f44070ULL, 0x000000030f00780cULL, 0x040fe40003f64070ULL,
0x0000007f0f00780cULL, 0x000fe20003f84070ULL, 0x000000040e097824ULL, 0x002fcc00078e0202ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x0000000209097824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x01860004ff009388ULL, 0x0003e20000000a00ULL, 0x00000001090a7824ULL, 0x044fe400078e0203ULL,
0x0000002009107824ULL, 0x000fc400078e00ffULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0xff317217ff0bc424ULL, 0x000fe200078e00ffULL, 0xffffffe010107812ULL, 0x000fe200078ee20aULL,
0x00000200ff0a7424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff04a424ULL, 0x002fe200078e00ffULL,
0x0184000b0f00c388ULL, 0x000fe20000004800ULL, 0x7fffffc0ff05a424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0c9424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL,
0x018608040f00a388ULL, 0x0003e20000008a00ULL, 0x000000010f00780cULL, 0x000fe20003f44070ULL,
0x0000001010107824ULL, 0x000fe400078e00ffULL, 0x018688060f00b388ULL, 0x0005e20000008a00ULL,
0x0000000809047817ULL, 0x002fe20007800000ULL, 0x0000000108057824ULL, 0x000fd000078e0209ULL,
0x7fffff00ff0ba424ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe200078e0a09ULL,
0x0000000109097810ULL, 0x000fe20007ffe0ffULL, 0x0000001003067824ULL, 0x004fc600078e00ffULL,
0x000000ff0400720cULL, 0x000fe20003f63070ULL, 0x0000000108087824ULL, 0x000fe200078e0209ULL,
0x000000010400780cULL, 0x000fe20003f83070ULL, 0x00005c0005047625ULL, 0x000fe200078e000aULL,
0x000001f006117812ULL, 0x000fc600078ec0ffULL, 0x0000000109077824ULL, 0x040fe200078e0203ULL,
0x0000001104047210ULL, 0x000fe20007fbe0ffULL, 0x0000002009127824ULL, 0x000fe400078e00ffULL,
0x00005c0008087625ULL, 0x000fc600078e000aULL, 0xffffffe012077812ULL, 0x000fe200078ee207ULL,
0x3fffff00ff0aa424ULL, 0x000fe200078e00ffULL, 0x0000001108087210ULL, 0x000fe20007fde0ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0x0186a80a0f00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff097224ULL, 0x000fc600030e0609ULL,
0x0186b80cff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004107faeULL, 0x0003e8000d901c46ULL,
0x0000000008077faeULL, 0x0005e2000e101c46ULL, 0x000000ffff047224ULL, 0x002fc400078e0013ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x004fe60000000000ULL,
0x000062002b147625ULL, 0x000fe200078e0005ULL, 0x01860404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01860000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000614147981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fc40003f05270ULL,
0x0000007f14157810ULL, 0x044fe40007ffe0ffULL, 0x000000ff14077810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff157819ULL, 0x000fe40000011615ULL, 0x00000008ff167819ULL, 0x000fca0000011607ULL,
0x000126f000008947ULL, 0x000fea0003800000ULL, 0x000001ff0700780cULL, 0x000fe20003f24070ULL,
0x0000000802177824ULL, 0x000fe200078e00ffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x00000003ff047424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01868c0417ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186880017ff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff187424ULL, 0x000fe200078e00ffULL,
0x0000005000008947ULL, 0x000fea0003800000ULL, 0x000000022b047824ULL, 0x002fe400078e00ffULL,
0x00006400ff077624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0207ULL,
0x0000600004187625ULL, 0x000fcc00078e0005ULL, 0x0000000618187981ULL, 0x000324000c1e1900ULL,
0x0000580018047a24ULL, 0x012fc800078e02ffULL, 0x00000080040d7824ULL, 0x000fe200078e00ffULL,
0x0000043000001947ULL, 0x000fea0003800000ULL, 0x0000001714047217ULL, 0x000fe40007800000ULL,
0x00000004ff057819ULL, 0x000fe40000011603ULL, 0x000000f006137812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a17ULL, 0x0000000205087810ULL, 0x000fe20007ffe0ffULL,
0x0000000117077824ULL, 0x000fe200078e0205ULL, 0x00000004050a7810ULL, 0x040fe40007ffe0ffULL,
0x000000040500720cULL, 0x080fe20003f06070ULL, 0x0000000117097824ULL, 0x000fe200078e0208ULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008000057824ULL, 0x000fe200078e0207ULL,
0x000000040800720cULL, 0x080fe20003f26070ULL, 0x0000000107087824ULL, 0x140fe200078e0203ULL,
0x000000040a00720cULL, 0x000fe20003f46070ULL, 0x00000010070e7824ULL, 0x000fe200078e00ffULL,
0x000000050d197210ULL, 0x000fe20007f7e0ffULL, 0x0000000109077824ULL, 0x000fc400078e0203ULL,
0x00000010090f7824ULL, 0x000fe200078e00ffULL, 0x00005e00190c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x000000040b00720cULL, 0x000fe20003f66070ULL,
0x00000001170a7824ULL, 0x000fe200078e020aULL, 0x0000000205047810ULL, 0x000fe20007ffe0ffULL,
0x00000001170b7824ULL, 0x000fe200078e020bULL, 0x00005f0019197a11ULL, 0x000fe400020f4409ULL,
0x0000000405097810ULL, 0x000fe20007ffe0ffULL, 0x000000010b067824ULL, 0x100fe200078e0203ULL,
0x0000000605057810ULL, 0x000fe20007ffe0ffULL, 0x000000100b1a7824ULL, 0x000fe200078e00ffULL,
0x000000040d127210ULL, 0x000fe20007fde0ffULL, 0x000000010a047824ULL, 0x000fe200078e0203ULL,
0xfffffff00f077812ULL, 0x000fc400078ee207ULL, 0x000000090d0f7210ULL, 0x040fe20007f9e0ffULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x000000050d0d7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200030e06ffULL, 0x00005e0012117a11ULL, 0x040fe200078c40ffULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0xfffffff009097812ULL, 0x000fe200078ee204ULL,
0x000000ffff0b7224ULL, 0x000fe200028e06ffULL, 0x00005f0012127a11ULL, 0x000fe400030f4405ULL,
0x0000000c13047210ULL, 0x000fc40007fde0ffULL, 0xfffffff00e087812ULL, 0x000fe400078ee208ULL,
0x00005e000f0e7a11ULL, 0x000fe200078840ffULL, 0x000000ffff057224ULL, 0x000fe200030e0619ULL,
0x0001400008087811ULL, 0x000fe400078e20ffULL, 0x00005e000d0a7a11ULL, 0x000fe400078a40ffULL,
0xfffffff01a0c7812ULL, 0x000fe200078ee206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004087faeULL, 0x0003e2000c101c46ULL, 0x00005f000f0f7a11ULL, 0x000fc400020f4410ULL,
0x00005f000d0d7a11ULL, 0x000fe400028f440bULL, 0x000000130e067210ULL, 0x080fe40007f9e0ffULL,
0x00014000090b7811ULL, 0x000fe400078e20ffULL, 0x000140000c0c7811ULL, 0x000fe400078e20ffULL,
0x0000001311047210ULL, 0x082fe40007f1e0ffULL, 0x000000130a087210ULL, 0x000fc40007fbe0ffULL,
0x00014000070a7811ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe400000e0612ULL,
0x000000ffff077224ULL, 0x000fe400020e060fULL, 0x000000ffff097224ULL, 0x000fe200028e060dULL,
0x00000000040a7faeULL, 0x0003e8000c901c46ULL, 0x00000000060b7faeULL, 0x0003e8000d101c46ULL,
0x00000000080c7faeULL, 0x0003e2000d901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000001703047211ULL, 0x000fe400078fe0ffULL, 0x000000f006137812ULL, 0x000fc400078ec0ffULL,
0x0000000204077810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x140fe200078e0203ULL,
0x00000006040b7810ULL, 0x040fe20007ffe0ffULL, 0x0000001004097824ULL, 0x000fe400078e00ffULL,
0x0000000107087824ULL, 0x040fe400078e0203ULL, 0x00000010070a7824ULL, 0x000fe200078e00ffULL,
0xfffffff009077812ULL, 0x000fe200078ee205ULL, 0x0000008000057824ULL, 0x000fe400078e0204ULL,
0x000000100b117824ULL, 0x000fe200078e00ffULL, 0xfffffff00a097812ULL, 0x000fc400078ee208ULL,
0x0000000404087810ULL, 0x000fe40007ffe0ffULL, 0x000000050d127210ULL, 0x000fe40007f1e0ffULL,
0x0000000205047810ULL, 0x040fe20007ffe0ffULL, 0x00000010080f7824ULL, 0x040fe200078e00ffULL,
0x00000004050a7810ULL, 0x040fe40007ffe0ffULL, 0x00000006050c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108057824ULL, 0x100fe200078e0203ULL, 0x000000040d107210ULL, 0x000fe20007f3e0ffULL,
0x000000010b087824ULL, 0x000fe200078e0203ULL, 0x0000000a0d0e7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000c0d0d7210ULL, 0x000fc40007f7e0ffULL,
0x00005e0012047a11ULL, 0x040fe200078040ffULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0xfffffff00f0b7812ULL, 0x000fe200078ee205ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x00005f0012127a11ULL, 0x000fe400000f440aULL, 0xfffffff0110c7812ULL, 0x000fe200078ee208ULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x00005e000d0a7a11ULL, 0x000fe400078640ffULL,
0x0000000413047210ULL, 0x000fc40007f1e0ffULL, 0x00005e000e087a11ULL, 0x000fe400078440ffULL,
0x00005e00100f7a11ULL, 0x000fe400078240ffULL, 0x00005f000d0d7a11ULL, 0x000fe200018f4405ULL,
0x000000ffff057224ULL, 0x000fe200000e0612ULL, 0x00005f000e0e7a11ULL, 0x000fe400010f4406ULL,
0x0001400007077811ULL, 0x000fe400078e20ffULL, 0x00005f0010107a11ULL, 0x000fc400008f4411ULL,
0x0000000f13067210ULL, 0x040fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000b901c46ULL, 0x0000000813087210ULL, 0x040fe40007f3e0ffULL,
0x0000000a130a7210ULL, 0x000fe40007f5e0ffULL, 0x000140000c0c7811ULL, 0x000fe400078e20ffULL,
0x0001400009047811ULL, 0x002fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0610ULL,
0x000140000b057811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fc400008e060eULL,
0x000000ffff0b7224ULL, 0x000fe200010e060dULL, 0x0000000006047faeULL, 0x0003e8000b901c46ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000a0c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff1600720cULL, 0x000fe20003f05270ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff1a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b800ff1c7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0001101000008947ULL, 0x000fea0003800000ULL, 0x000000022b1a7824ULL, 0x002fe400078e00ffULL,
0x00006400ff1c7624ULL, 0x008fc400078e00ffULL, 0x000000ffff417224ULL, 0x000fe400078e001bULL,
0x000064001a1a7624ULL, 0x000fe400078e021cULL, 0x000000ffff497224ULL, 0x000fe400078e001dULL,
0xff317217ff487424ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x000fc400078e00ffULL, 0x000000ffff3f7224ULL, 0x000fc400078e00ffULL,
0x000001001b1d7824ULL, 0x000fca00078e00ffULL, 0x000000141d00720cULL, 0x000fda0003f06070ULL,
0x00010f1000000947ULL, 0x024fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fc400078e001cULL,
0x00000000001e7805ULL, 0x000fca0000015200ULL, 0x0186bc00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x000000241e247210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e1fULL,
0x003d09002400780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402400780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011425ULL, 0x0000002423237211ULL, 0x000fca00078110ffULL,
0x000000ffff247224ULL, 0x000fca00000e0625ULL, 0x0000000223237819ULL, 0x000fc80000001224ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011b1e7810ULL, 0x000fe20007ffe0ffULL,
0x00005800185d7a24ULL, 0x000fc600078e02ffULL, 0x000000161e00720cULL, 0x000fe20003f26070ULL,
0x000000805d5d7824ULL, 0x000fd800078e00ffULL, 0x0000048000009947ULL, 0x000fea0003800000ULL,
0x000000201b1e7811ULL, 0x000fe400078e40ffULL, 0x00000004ff297819ULL, 0x000fe40000011603ULL,
0x0000001e141f7217ULL, 0x000fe40007800000ULL, 0x00000004293b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000117237824ULL, 0x000fe200078e0229ULL, 0x0000000229387810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0a1eULL, 0x00000020001e7811ULL, 0x000fe200078e38ffULL,
0x0000000123247824ULL, 0x000fe200078e0203ULL, 0x0000000629427810ULL, 0x000fe20007ffe0ffULL,
0x0000001023397824ULL, 0x000fe200078e00ffULL, 0x0000001f171f7217ULL, 0x040fe20007800000ULL,
0x0000000117267824ULL, 0x000fc400078e023bULL, 0x0000000117257824ULL, 0x000fe200078e0238ULL,
0xfffffff039397812ULL, 0x000fe200078ee224ULL, 0x0000000126277824ULL, 0x140fe400078e0203ULL,
0x0000001026407824ULL, 0x000fe400078e00ffULL, 0x0000000123237824ULL, 0x000fe400078e021eULL,
0x0000000125247824ULL, 0x040fe200078e0203ULL, 0xfffffff040407812ULL, 0x000fe200078ee227ULL,
0x00000010253a7824ULL, 0x000fe200078e00ffULL, 0x000000235d277210ULL, 0x000fe20007f1e0ffULL,
0x0000000117287824ULL, 0x000fc400078e0242ULL, 0x000000011f237824ULL, 0x000fe200078e0a17ULL,
0xfffffff03a3a7812ULL, 0x000fe200078ee224ULL, 0x0000000125247824ULL, 0x100fe400078e021eULL,
0x0000000126257824ULL, 0x100fe400078e021eULL, 0x00000001281e7824ULL, 0x040fe200078e021eULL,
0x000000245d247210ULL, 0x040fe20007f5e0ffULL, 0x00000001282a7824ULL, 0x040fe200078e0203ULL,
0x000000255d257210ULL, 0x000fe20007f9e0ffULL, 0x0000001028437824ULL, 0x000fc400078e00ffULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x00005e0027267a11ULL, 0x040fe200078040ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x000000233800720cULL, 0x080fe40003f46070ULL,
0x00005f00271f7a11ULL, 0x000fe200000f4428ULL, 0x0000001003277824ULL, 0x000fe200078e00ffULL,
0xfffffff043437812ULL, 0x000fe400078ee22aULL, 0x000000232900720cULL, 0x000fe20003f06070ULL,
0x000000ffff297224ULL, 0x000fe200020e06ffULL, 0x000000f027387812ULL, 0x000fc400078ec0ffULL,
0x00005e00242a7a11ULL, 0x040fe400078640ffULL, 0x0000001e5d277210ULL, 0x000fe40007fde0ffULL,
0x00005e0025287a11ULL, 0x040fe400078a40ffULL, 0x00005f00242b7a11ULL, 0x000fe200018f442bULL,
0x000000ffff247224ULL, 0x000fe200030e06ffULL, 0x00000038261e7210ULL, 0x000fe40007f9e0ffULL,
0x00005f0025297a11ULL, 0x000fc400028f4429ULL, 0x00005e0027267a11ULL, 0x000fe200078a40ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e061fULL, 0x0001600039257811ULL, 0x000fe400078e20ffULL,
0x00005f0027277a11ULL, 0x000fe400028f4424ULL, 0x000000382a247210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e257faeULL, 0x0003e2000c101c46ULL,
0x000000233b00720cULL, 0x080fe40003f66070ULL, 0x000000234200720cULL, 0x000fc40003f86070ULL,
0x000160003a237811ULL, 0x000fe400078e20ffULL, 0x00000038281e7210ULL, 0x082fe20007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200028e062bULL, 0x0000003826267210ULL, 0x000fe40007fbe0ffULL,
0x0001600040287811ULL, 0x000fe200078e20ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e0629ULL,
0x0001600043297811ULL, 0x000fe200078e20ffULL, 0x000000ffff277224ULL, 0x000fe200028e0627ULL,
0x0000000024237faeULL, 0x0003e8000d101c46ULL, 0x000000001e287faeULL, 0x0003e8000d901c46ULL,
0x0000000026297faeULL, 0x0003e2000e101c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x00000017031f7211ULL, 0x000fe400078fe0ffULL, 0x0000002000237811ULL, 0x000fc400078e38ffULL,
0x000000021f247810ULL, 0x040fe20007ffe0ffULL, 0x000000011f1e7824ULL, 0x140fe200078e0203ULL,
0x000000061f277810ULL, 0x040fe20007ffe0ffULL, 0x000000101f3a7824ULL, 0x040fe400078e00ffULL,
0x0000000124257824ULL, 0x040fe400078e0203ULL, 0x00000010243b7824ULL, 0x000fe200078e00ffULL,
0xfffffff03a3a7812ULL, 0x000fe200078ee21eULL, 0x000000011f1e7824ULL, 0x000fe400078e0223ULL,
0x0000001027427824ULL, 0x000fe200078e00ffULL, 0xfffffff03b3b7812ULL, 0x000fc400078ee225ULL,
0x000000041f257810ULL, 0x000fe40007ffe0ffULL, 0x0000001e5d387210ULL, 0x000fe20007f1e0ffULL,
0x00000001241e7824ULL, 0x000fe400078e0223ULL, 0x0000000125267824ULL, 0x040fe400078e0203ULL,
0x0000001025407824ULL, 0x040fe400078e00ffULL, 0x00000001251f7824ULL, 0x000fe400078e0223ULL,
0x0000000127257824ULL, 0x040fe200078e0203ULL, 0xfffffff040407812ULL, 0x000fe200078ee226ULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005e00382b7a11ULL, 0x000fe200078040ffULL,
0x0000000127237824ULL, 0x000fe200078e0223ULL, 0xfffffff042427812ULL, 0x000fe200078ee225ULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x00005f0038387a11ULL, 0x000fc400000f4424ULL,
0x0000001e5d257210ULL, 0x040fe40007f1e0ffULL, 0x0000001f5d1f7210ULL, 0x040fe40007f7e0ffULL,
0x000000235d237210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200000e06ffULL,
0x000000f026397812ULL, 0x000fe200078ec0ffULL, 0x000000ffff277224ULL, 0x000fe200018e06ffULL,
0x00005e001f267a11ULL, 0x000fe200078640ffULL, 0x000000ffff297224ULL, 0x000fe200020e06ffULL,
0x00005e0023287a11ULL, 0x000fc400078840ffULL, 0x000000392b1e7210ULL, 0x000fe40007f1e0ffULL,
0x00005e0025247a11ULL, 0x000fe400078440ffULL, 0x00005f001f277a11ULL, 0x000fe200018f4427ULL,
0x000000ffff1f7224ULL, 0x000fe200000e0638ULL, 0x00005f0023297a11ULL, 0x000fe400020f4429ULL,
0x000160003a237811ULL, 0x000fe400078e20ffULL, 0x00005f0025257a11ULL, 0x000fc400010f442aULL,
0x0000003924247210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e237faeULL, 0x0003e2000b901c46ULL, 0x0000003926267210ULL, 0x080fe40007f5e0ffULL,
0x0000003928287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fe400000e0625ULL,
0x000000ffff277224ULL, 0x000fe400010e0627ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x000160003b1e7811ULL, 0x002fc400078e20ffULL, 0x00016000401f7811ULL, 0x000fe400078e20ffULL,
0x0001600042237811ULL, 0x000fe200078e20ffULL, 0x00000000241e7faeULL, 0x0003e8000b901c46ULL,
0x00000000261f7faeULL, 0x0003e8000b901c46ULL, 0x0000000028237faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff507f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186080017267f8cULL, 0x0006a4000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0x01860c0017237984ULL, 0x000f240000000800ULL, 0x8000000023ff7812ULL, 0x014fc40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x000000241e247210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e1fULL, 0x003d09002400780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402400780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011425ULL,
0x0000002423237211ULL, 0x000fca00078110ffULL, 0x000000ffff247224ULL, 0x000fca00000e0625ULL,
0x0000000223237819ULL, 0x000fc80000001224ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01860c0017237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x004fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff1f7819ULL, 0x000fe20000011603ULL, 0x00000010031e7824ULL, 0x000fc600078e00ffULL,
0x0000000c1f237812ULL, 0x000fe400078ec0ffULL, 0x000000701e1f7812ULL, 0x000fca00078ec0ffULL,
0x000000011f1f7824ULL, 0x000fca00078e0223ULL, 0x018000001f237984ULL, 0x000ea80000000800ULL,
0x018200001f247984ULL, 0x0006620000000800ULL, 0x000000482300720bULL, 0x004fe20003f1d000ULL,
0x00017c127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x0000ffff25277812ULL, 0x000fe2000780c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x00000001ff287424ULL, 0x000fe400078e00ffULL, 0x000000ffff5c7224ULL, 0x000fd200078e0048ULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x000000482300720bULL, 0x000fe20003f54000ULL, 0x00017be27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400010e0100ULL, 0x00000023485c7209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x0000991025267816ULL, 0x000fc600000000ffULL,
0x0184005c1f008388ULL, 0x0005e20000000800ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000005c48267221ULL, 0x004fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b26267820ULL, 0x000fcc0000410000ULL, 0x0000002600267308ULL, 0x000ea80000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff4c7819ULL, 0x000fe20000011603ULL,
0x00017b527f007947ULL, 0x000fea000b800000ULL, 0x00001f4c264c7589ULL, 0x0044e400000e0000ULL,
0x0000004c34347220ULL, 0x088fe40000410000ULL, 0x0000004c35357220ULL, 0x080fe40000410000ULL,
0x0000004c30307220ULL, 0x080fe40000410000ULL, 0x0000004c31317220ULL, 0x000fc40000410000ULL,
0x0000004c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000004c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000004c10107220ULL, 0x080fe40000410000ULL, 0x0000004c11117220ULL, 0x080fe40000410000ULL,
0x0000004c08087220ULL, 0x080fe40000410000ULL, 0x0000004c09097220ULL, 0x000fc40000410000ULL,
0x0000004c04047220ULL, 0x080fe40000410000ULL, 0x0000004c05057220ULL, 0x080fe40000410000ULL,
0x0000004c0c0c7220ULL, 0x080fe40000410000ULL, 0x0000004c0d0d7220ULL, 0x080fe40000410000ULL,
0x0000004c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000004c3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fe2000780c0ffULL,
0x0000002619197220ULL, 0x004fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008034c7811ULL, 0x000fe200078ff0ffULL, 0x00017a527f007947ULL, 0x000fea000b800000ULL,
0x00001f4c264c7589ULL, 0x0004e400000e0000ULL, 0x0000004c36367220ULL, 0x088fe40000410000ULL,
0x0000004c37377220ULL, 0x080fe40000410000ULL, 0x0000004c32327220ULL, 0x080fe40000410000ULL,
0x0000004c33337220ULL, 0x080fe40000410000ULL, 0x0000004c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000004c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000004c12127220ULL, 0x080fe40000410000ULL,
0x0000004c13137220ULL, 0x080fe40000410000ULL, 0x0000004c0a0a7220ULL, 0x080fe40000410000ULL,
0x0000004c0b0b7220ULL, 0x080fe40000410000ULL, 0x0000004c06067220ULL, 0x080fe40000410000ULL,
0x0000004c07077220ULL, 0x000fc40000410000ULL, 0x0000004c0e0e7220ULL, 0x080fe40000410000ULL,
0x0000004c0f0f7220ULL, 0x080fe40000410000ULL, 0x0000004c3e3e7220ULL, 0x080fe40000410000ULL,
0x0000004c3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff27ff7812ULL, 0x000fda0007806025ULL, 0x8000005c23230221ULL, 0x000fe20000010000ULL,
0x00007610ff280816ULL, 0x000fc60000000028ULL, 0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL,
0x0000002300200308ULL, 0x000ea40000000800ULL, 0x0000002024240220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001924197221ULL, 0x002fc40000010000ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x0186ac00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991028237816ULL, 0x000fe200000000ffULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000ff2300720cULL, 0x000fda0003f45270ULL,
0x0000014000002947ULL, 0x000fea0003800000ULL, 0x00000020ff21723eULL, 0x000fe400000000ffULL,
0x00000002ff237819ULL, 0x000fe40000011603ULL, 0x00005410214d7816ULL, 0x000fe20000000021ULL,
0x000176727f007947ULL, 0x000fea000b800000ULL, 0x00001f234d217589ULL, 0x0002a400000e0000ULL,
0x0000000823227810ULL, 0x000fe20007ffe0ffULL, 0x000176b27f007947ULL, 0x000fea000b800000ULL,
0x00001f224d227589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010234c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff437424ULL, 0x000fe200078e00ffULL,
0x0000283000427802ULL, 0x000fe20000000f00ULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x0001880000007944ULL, 0x00efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018234c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff437424ULL, 0x000fe200078e00ffULL,
0x0000289000427802ULL, 0x000fe20000000f00ULL, 0xffffffffff497424ULL, 0x004fc400078e00ffULL,
0x000187a000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000803527812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff237819ULL, 0x002fc40000011603ULL, 0x0000000752527812ULL, 0x000fe400078ef803ULL,
0x0000000202277811ULL, 0x040fe200078e10ffULL, 0x0000000402567824ULL, 0x000fe200078e0223ULL,
0x0000000703557812ULL, 0x000fe200078ec0ffULL, 0x0000001052257824ULL, 0x040fe400078e00ffULL,
0x0000000152247824ULL, 0x040fe200078e0256ULL, 0x0000000855557812ULL, 0x000fe200078ef803ULL,
0x0000000123537824ULL, 0x000fe400078e0227ULL, 0x0000001052267824ULL, 0x040fe200078e00ffULL,
0xfffffff025247812ULL, 0x000fe200078ee224ULL, 0x0000000152257824ULL, 0x000fc400078e0253ULL,
0x0000000123547824ULL, 0x000fe200078e0255ULL, 0x0001400024247811ULL, 0x000fe400078e20ffULL,
0xfffffff026257812ULL, 0x000fc600078ee225ULL, 0x000000002438783bULL, 0x000e620000004200ULL,
0x0001400025257811ULL, 0x000fca00078e20ffULL, 0x000000002528783bULL, 0x000f220000004200ULL,
0x00000018ff267819ULL, 0x002fe20000011438ULL, 0x0000010038407824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x004fe4000001143aULL, 0x00000026004e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff487819ULL, 0x000fe4000001143bULL, 0x00000018ff4c7819ULL, 0x010fe40000011428ULL,
0x00000018ff4d7819ULL, 0x008fc40000011429ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x00000018ff267819ULL, 0x002fe40000011439ULL,
0x00000018ff597819ULL, 0x000fe4000001142aULL, 0x00000018ff5a7819ULL, 0x000fc6000001142bULL,
0x0000002600657306ULL, 0x0003f00000200c00ULL, 0x00000040004b7306ULL, 0x000fe20000200c00ULL,
0x0000888038267816ULL, 0x042fe200000000ffULL, 0x0001000038387824ULL, 0x000fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x00000026004a7306ULL, 0x0003f00000200c00ULL,
0x00000038004f7306ULL, 0x0004e20000200c00ULL, 0x0000888039267816ULL, 0x002fce00000000ffULL,
0x0000002600637306ULL, 0x0003e20000200c00ULL, 0x0000010039387824ULL, 0x044fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000088803a267816ULL, 0x002fe400000000ffULL, 0x000054104f4e7816ULL, 0x008fca000000004eULL,
0x0000002600677306ULL, 0x0003f00000200c00ULL, 0x0000003900667306ULL, 0x0004e20000200c00ULL,
0x000088803b267816ULL, 0x002fce00000000ffULL, 0x0000002600697306ULL, 0x0003e20000200c00ULL,
0x0000001052397812ULL, 0x004fc800078efcffULL, 0x0000002739587210ULL, 0x000fe20007ffe023ULL,
0x0000000156577824ULL, 0x000fe200078e0239ULL, 0x000088802a277816ULL, 0x000fe200000000ffULL,
0x0000003800647306ULL, 0x0005e20000200c00ULL, 0x0000888028267816ULL, 0x002fe400000000ffULL,
0x00005410664f7816ULL, 0x008fca0000000065ULL, 0x00000026006d7306ULL, 0x0003e20000200c00ULL,
0x000001003a387824ULL, 0x044fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000002700737306ULL, 0x000fe20000200c00ULL, 0x0000888029267816ULL, 0x002fce00000000ffULL,
0x0000002600707306ULL, 0x0003f00000200c00ULL, 0x0000003800687306ULL, 0x0004e20000200c00ULL,
0x0000001039267824ULL, 0x042fe400078e00ffULL, 0x0000001039397824ULL, 0x000fc600078e00ffULL,
0xfffffff026577812ULL, 0x000fe400078ee257ULL, 0xfffffff039587812ULL, 0x000fe200078ee258ULL,
0x000001003b387824ULL, 0x004fe200078e00ffULL, 0x0001400057267811ULL, 0x000fe200078e20ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x0001400058277811ULL, 0x000fe200078e20ffULL,
0x0000003a006a7306ULL, 0x000e620000200c00ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x000000002644783bULL, 0x000ea20000004200ULL, 0x00000018ff3b7819ULL, 0x000fc4000001143bULL,
0x0000541067687816ULL, 0x008fc60000000068ULL, 0x00000038006b7306ULL, 0x0007300000200c00ULL,
0x0000003b006c7306ULL, 0x000f220000200c00ULL, 0x0000010028387824ULL, 0x008fe200078e00ffULL,
0x000054106a6a7816ULL, 0x002fe20000000049ULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541069697816ULL, 0x010fe4000000006bULL,
0x000054106c6b7816ULL, 0x000fca0000000048ULL, 0x00000038006e7306ULL, 0x0003f00000200c00ULL,
0x00000028006f7306ULL, 0x0007220000200c00ULL, 0x0000010029387824ULL, 0x042fe200078e00ffULL,
0x00000018ff617819ULL, 0x004fe20000011444ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011445ULL, 0x0000010044417824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc40000011438ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x000001002a287824ULL, 0x048fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000003800717306ULL, 0x0002a20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fe20000011446ULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff607819ULL, 0x000fe40000011447ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002900727306ULL, 0x0007e20000200c00ULL, 0x000000002738783bULL, 0x002e620000004200ULL,
0x000054106f4c7816ULL, 0x010fcc000000004cULL, 0x0000002800747306ULL, 0x0009e20000200c00ULL,
0x000088802b297816ULL, 0x008fe400000000ffULL, 0x0000541070497816ULL, 0x004fca0000000071ULL,
0x00000041007a7306ULL, 0x000fe20000200c00ULL, 0x000000ffff287224ULL, 0x010fe400078e0029ULL,
0x000001002b297824ULL, 0x040fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x0000002800767306ULL, 0x0005e20000200c00ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff2b7819ULL, 0x000fca000001142bULL, 0x0000002900777306ULL, 0x0007e20000200c00ULL,
0x0000000855287824ULL, 0x004fca00078e00ffULL, 0xfffffff828287812ULL, 0x000fe400078ee254ULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x0000888044297816ULL, 0x048fe200000000ffULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x0001200028407811ULL, 0x000fe400078e20ffULL,
0x00000018ff5e7819ULL, 0x002fe40000011438ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000002900797306ULL, 0x0003e20000200c00ULL, 0x000000004040783bULL, 0x000ee20000000200ULL,
0x00000018ff5b7819ULL, 0x000fcc0000011439ULL, 0x00000044007b7306ULL, 0x0009e20000200c00ULL,
0x0000888045297816ULL, 0x002fe400000000ffULL, 0x00005410724d7816ULL, 0x004fca000000004dULL,
0x00000029007c7306ULL, 0x0003e20000200c00ULL, 0x0000010045447824ULL, 0x050fe400078e00ffULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0000888046297816ULL, 0x002fce00000000ffULL, 0x00000044007d7306ULL, 0x0003f00000200c00ULL,
0x00000029007f7306ULL, 0x0005e20000200c00ULL, 0x0000010046447824ULL, 0x042fe200078e00ffULL,
0x000000214040a232ULL, 0x088fe20000000000ULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x000000214242a232ULL, 0x000fc40000000000ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x000000224141a232ULL, 0x080fe20000000000ULL, 0x00000045007e7306ULL, 0x0003e20000200c00ULL,
0x0000888047297816ULL, 0x004fe200000000ffULL, 0x000000224343a232ULL, 0x000fe20000000000ULL,
0x00000018ff467819ULL, 0x000fca0000011446ULL, 0x0000004400807306ULL, 0x0005e20000200c00ULL,
0x0000541063457816ULL, 0x002fe20000000064ULL, 0x0000004e4030723cULL, 0x040bec0000001830ULL,
0x0000002900827306ULL, 0x0003e20000200c00ULL, 0x0000010047447824ULL, 0x004fe200078e00ffULL,
0x0000004c4004723cULL, 0x000be40000001804ULL, 0x00000100394e7824ULL, 0x020fc400078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004600817306ULL, 0x000fe20000200c00ULL,
0x0001000047297824ULL, 0x002fe200078e00ffULL, 0x00005410734c7816ULL, 0x000fe20000000074ULL,
0x00000068402c723cULL, 0x000fe2000000182cULL, 0x00005410764d7816ULL, 0x000fe40000000077ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000004400837306ULL, 0x0003e20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fc4000001144eULL, 0x0000006a4010723cULL, 0x000fea0000001810ULL,
0x0000002900637306ULL, 0x0005e20000200c00ULL, 0x000054104a447816ULL, 0x002fe4000000004bULL,
0x00008880394b7816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fc800078e00ffULL,
0x000000444044723cULL, 0x000b620000001834ULL, 0x0000000254297810ULL, 0x004fe20007ffe0ffULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000000ffff487224ULL, 0x000fe200078e004bULL,
0x00000018ff397819ULL, 0x000fc60000011439ULL, 0x0000000855357824ULL, 0x020fe200078e00ffULL,
0x0000888038347816ULL, 0x040fe400000000ffULL, 0x0000002a00757306ULL, 0x0002a40000200c00ULL,
0xfffffff835297812ULL, 0x000fe200078ee229ULL, 0x0000010038357824ULL, 0x040fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x0000003400647306ULL, 0x0007e20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fe40000011435ULL, 0x00000018ff2a7819ULL, 0x002fe4000001143aULL,
0x00000018ff387819ULL, 0x000fc60000011438ULL, 0x0000002b00787306ULL, 0x0003220000200c00ULL,
0x0001200029347811ULL, 0x008fcc00078e20ffULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000004800667306ULL, 0x0005e20000200c00ULL, 0x00000018ff2b7819ULL, 0x002fce000001143bULL,
0x0000004a00657306ULL, 0x0003e20000200c00ULL, 0x000054106d487816ULL, 0x004fce000000006eULL,
0x0000004e00677306ULL, 0x0005e20000200c00ULL, 0x000000484048723cULL, 0x042b6e0000001808ULL,
0x0000541075087816ULL, 0x020fe20000000059ULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x0000541078097816ULL, 0x010fe2000000005aULL, 0x0000004c404c723cULL, 0x004f62000000180cULL,
0x000088803a0a7816ULL, 0x000fca00000000ffULL, 0x0000006200627306ULL, 0x000ea40000200c00ULL,
0x000000084040723cULL, 0x000b62000000183cULL, 0x000000213434a232ULL, 0x088fe40000000000ULL,
0x000000213636a232ULL, 0x000fc80000000000ULL, 0x000001003a087824ULL, 0x060fe200078e00ffULL,
0x000088803b097816ULL, 0x000fe200000000ffULL, 0x000000223535a232ULL, 0x080fe20000000000ULL,
0x00005410793c7816ULL, 0x000fe2000000007aULL, 0x000000223737a232ULL, 0x000fe20000000000ULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000054107c3d7816ULL, 0x000fe2000000007dULL, 0x0000005f005f7306ULL, 0x000ee60000200c00ULL,
0x00000018ff3a7819ULL, 0x000fc6000001143aULL, 0x0000003c343c723cULL, 0x000b640000001844ULL,
0x00000008005a7306ULL, 0x0009ea0000200c00ULL, 0x000054107b447816ULL, 0x022fe40000000061ULL,
0x000054107e457816ULL, 0x004fe20000000062ULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x000000ffff087224ULL, 0x010fe200078e0009ULL, 0x00005410810c7816ULL, 0x008fe2000000005fULL,
0x000001003b097824ULL, 0x000fc400078e00ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000443444723cULL, 0x000f640000001830ULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00005410630d7816ULL, 0x002fca0000000060ULL, 0x0000005b005b7306ULL, 0x000fe40000200c00ULL,
0x0000000c340c723cULL, 0x000b6c0000001810ULL, 0x0000003800387306ULL, 0x000fe20000200c00ULL,
0x0000541064107816ULL, 0x020fe40000000065ULL, 0x0000541066117816ULL, 0x000fca0000000067ULL,
0x0000003900397306ULL, 0x000fe40000200c00ULL, 0x000000103410723cULL, 0x000f6c0000001848ULL,
0x0000000a00597306ULL, 0x000e700000200c00ULL, 0x0000000800687306ULL, 0x0005f00000200c00ULL,
0x0000000900317306ULL, 0x0007220000200c00ULL, 0x000054107f087816ULL, 0x004fc40000000080ULL,
0x0000541059307816ULL, 0x002fca000000005aULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x0000541082097816ULL, 0x008fce0000000083ULL, 0x0000002b002b7306ULL, 0x000fe20000200c00ULL,
0x000000083408723cULL, 0x000b62000000182cULL, 0x0000541068317816ULL, 0x010fcc0000000031ULL,
0x0000003a003a7306ULL, 0x000e620000200c00ULL, 0x00005410382c7816ULL, 0x020fe2000000005eULL,
0x000000303430723cULL, 0x000b62000000184cULL, 0x00005410392d7816ULL, 0x000fca000000005bULL,
0x0000003b003b7306ULL, 0x000ea40000200c00ULL, 0x0000002c342c723cULL, 0x000b620000001804ULL,
0x000054103a2a7816ULL, 0x002fe4000000002aULL, 0x000054103b2b7816ULL, 0x004fce000000002bULL,
0x0000002a3434723cULL, 0x000b620000001840ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff2a7f8cULL, 0x020e62000c80043fULL, 0x000000ffff397224ULL, 0x000fce00078e00ffULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x0186bc00ff067984ULL, 0x000ea40000000800ULL,
0x8000000006ff7812ULL, 0x006fe4000780482bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604387210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000003806067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000139397810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000401b2a7811ULL, 0x000fe200078e40ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000117057824ULL, 0x000fe200078e0223ULL, 0x0000004000067811ULL, 0x000fe400078e38ffULL,
0x00000002233a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105047824ULL, 0x100fe200078e0203ULL,
0x0000000423487810ULL, 0x000fe20007ffe0ffULL, 0x0000001005427824ULL, 0x040fe200078e00ffULL,
0x000000f01e417812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x00000006234a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000117077824ULL, 0x040fe200078e023aULL,
0xfffffff042427812ULL, 0x000fe200078ee204ULL, 0x00000001173b7824ULL, 0x000fe200078e0248ULL,
0x0000002a14047217ULL, 0x000fe20007800000ULL, 0x00000001072b7824ULL, 0x000fe200078e0203ULL,
0x000000055d397210ULL, 0x000fe20007f1e0ffULL, 0x0000001007437824ULL, 0x000fe200078e00ffULL,
0x0001400042427811ULL, 0x000fe200078e20ffULL, 0x0000000104047824ULL, 0x000fc400078e0a2aULL,
0x0000000107057824ULL, 0x000fe200078e0206ULL, 0xfffffff043437812ULL, 0x000fe200078ee22bULL,
0x000000013b407824ULL, 0x000fe200078e0203ULL, 0x0000000417047217ULL, 0x000fe20007800000ULL,
0x000000103b497824ULL, 0x000fe200078e00ffULL, 0x000000055d057210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x00005e00392b7a11ULL, 0x000fe200078040ffULL,
0x0000000104077824ULL, 0x000fe200078e0a17ULL, 0xfffffff049497812ULL, 0x000fe200078ee240ULL,
0x000000013b047824ULL, 0x000fe200078e0206ULL, 0x00005f0039397a11ULL, 0x000fe200000f4438ULL,
0x000000ffff407224ULL, 0x000fe200018e06ffULL, 0x00005e0005387a11ULL, 0x000fe200078640ffULL,
0x00000001174b7824ULL, 0x000fe200078e024aULL, 0x000000072300720cULL, 0x000fc40003f86070ULL,
0x000000045d3b7210ULL, 0x000fe20007fbe0ffULL, 0x000000014b067824ULL, 0x000fe200078e0206ULL,
0x00005f0005407a11ULL, 0x000fe400018f4440ULL, 0x000000412b047210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e06ffULL, 0x000000073a00720cULL, 0x080fe40003f06070ULL,
0x00005e003b3a7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff057224ULL, 0x000fe200018e0639ULL,
0x000000074800720cULL, 0x000fc40003f66070ULL, 0x00005f003b3b7a11ULL, 0x000fe400028f442bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004427faeULL, 0x0003e2000e101c46ULL,
0x000000065d2b7210ULL, 0x000fe40007f9e0ffULL, 0x000000413a067210ULL, 0x080fe40007fde0ffULL,
0x0001400043437811ULL, 0x000fe200078e20ffULL, 0x000000ffff397224ULL, 0x000fe200020e06ffULL,
0x0001400049497811ULL, 0x000fe400078e20ffULL, 0x0000004138047210ULL, 0x002fe20007fbe0ffULL,
0x000000014b427824ULL, 0x000fe200078e0203ULL, 0x00005e002b387a11ULL, 0x000fe200078840ffULL,
0x000000104b4b7824ULL, 0x000fc400078e00ffULL, 0x000000ffff057224ULL, 0x000fe200028e0640ULL,
0x000000074a00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff077224ULL, 0x000fe200030e063bULL,
0x00005f002b2b7a11ULL, 0x000fe400020f4439ULL, 0x0000004138387210ULL, 0x000fe20007f9e0ffULL,
0x0000000004437faeULL, 0x0003e2000c101c46ULL, 0xfffffff04b427812ULL, 0x000fc600078ee242ULL,
0x000000ffff397224ULL, 0x000fe200020e062bULL, 0x0001400042427811ULL, 0x000fe200078e20ffULL,
0x0000000006497faeULL, 0x0003e8000d901c46ULL, 0x0000000038427faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x00000040003a7811ULL, 0x000fe200078e38ffULL,
0x0000000117387824ULL, 0x000fe200078e0223ULL, 0x000000f01e4a7812ULL, 0x000fc600078ec0ffULL,
0x0000000138057824ULL, 0x140fe200078e023aULL, 0x0000000238047810ULL, 0x040fe20007ffe0ffULL,
0x0000000138067824ULL, 0x140fe200078e0203ULL, 0x0000000438077810ULL, 0x040fe20007ffe0ffULL,
0x00000010384b7824ULL, 0x040fe200078e00ffULL, 0x0000000638387810ULL, 0x000fe20007ffe0ffULL,
0x0000001004397824ULL, 0x040fe200078e00ffULL, 0x000000055d417210ULL, 0x000fe20007f1e0ffULL,
0x0000000104057824ULL, 0x040fe200078e023aULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee206ULL,
0x0000000104067824ULL, 0x000fc400078e0203ULL, 0x0000000107047824ULL, 0x100fe200078e023aULL,
0x000140004b4b7811ULL, 0x000fe200078e20ffULL, 0x00000001383a7824ULL, 0x040fe400078e023aULL,
0x00000001383b7824ULL, 0x140fe400078e0203ULL, 0x0000001038427824ULL, 0x000fe400078e00ffULL,
0x00000001072b7824ULL, 0x040fe400078e0203ULL, 0x0000001007407824ULL, 0x000fe200078e00ffULL,
0xfffffff039077812ULL, 0x000fe200078ee206ULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0x00005e0041487a11ULL, 0x000fc400078040ffULL, 0xfffffff040397812ULL, 0x000fe400078ee22bULL,
0x00005f0041497a11ULL, 0x000fe400000f4438ULL, 0xfffffff042407812ULL, 0x000fe400078ee23bULL,
0x000000055d437210ULL, 0x040fe40007f1e0ffULL, 0x0000003a5d417210ULL, 0x040fe40007f9e0ffULL,
0x000000045d427210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e06ffULL,
0x00005e00432b7a11ULL, 0x000fe200078040ffULL, 0x000000ffff047224ULL, 0x000fe200020e06ffULL,
0x00005e0041387a11ULL, 0x000fe200078840ffULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x0000004a483a7210ULL, 0x000fc40007fbe0ffULL, 0x00005e0042067a11ULL, 0x040fe400078640ffULL,
0x00005f0043437a11ULL, 0x000fe200000f443bULL, 0x000000ffff3b7224ULL, 0x000fe200028e0649ULL,
0x00005f0041417a11ULL, 0x000fe400020f4404ULL, 0x00005f0042427a11ULL, 0x000fe400018f4405ULL,
0x0000004a2b047210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e2000b901c46ULL, 0x0000004a06067210ULL, 0x000fc40007f7e0ffULL,
0x0000004a38387210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0643ULL,
0x00014000072b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200018e0642ULL,
0x0001400040407811ULL, 0x000fc600078e20ffULL, 0x00000000042b7faeULL, 0x0005e2000b901c46ULL,
0x00014000393a7811ULL, 0x002fe200078e20ffULL, 0x000000ffff397224ULL, 0x000fc800020e0641ULL,
0x00000000063a7faeULL, 0x0005e8000b901c46ULL, 0x0000000038407faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x006fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff047f8cULL, 0x000e64000c80043fULL, 0x000000ffff417224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x0186b400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007804851ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006042b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000002b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186b400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000020ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff057819ULL, 0x000fe40000011603ULL, 0x0000541004047816ULL, 0x000fe20000000004ULL,
0x000158527f007947ULL, 0x000fea000b800000ULL, 0x00001f0504217589ULL, 0x0002a400000e0000ULL,
0x0000000805227810ULL, 0x000fe20007ffe0ffULL, 0x000158a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2204227589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010054c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e0004ULL,
0x0000474000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x000168f000007944ULL, 0x00efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018054c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0004ULL, 0x000047b000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff497424ULL, 0x004fc400078e00ffULL,
0x0001688000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00016000572b7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0001600058387811ULL, 0x000fe200078e20ffULL, 0x0000000152567824ULL, 0x040fe400078e0256ULL,
0x000000002b48783bULL, 0x004ea20000004200ULL, 0x00000010523a7824ULL, 0x000fc400078e00ffULL,
0x0000000152537824ULL, 0x000fe200078e0253ULL, 0x000000003804783bULL, 0x00ae640000004200ULL,
0xfffffff03a567812ULL, 0x000fe200078ee256ULL, 0x0000010048397824ULL, 0x044fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011448ULL, 0x000001004b3a7824ULL, 0x000fe200078e00ffULL,
0x0000888048707816ULL, 0x000fe200000000ffULL, 0x00000100043b7824ULL, 0x002fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3b7819ULL, 0x000fc4000001143bULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff6c7819ULL, 0x000fe40000011449ULL, 0x0000888049727816ULL, 0x000fe200000000ffULL,
0x0000003900717306ULL, 0x0003e20000200c00ULL, 0x00000018ff607819ULL, 0x000fe4000001144aULL,
0x000088804a697816ULL, 0x000fe400000000ffULL, 0x00000018ff617819ULL, 0x000fc4000001144bULL,
0x000088804b687816ULL, 0x000fe200000000ffULL, 0x0000003a006e7306ULL, 0x0005e20000200c00ULL,
0x0000010049397824ULL, 0x042fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011404ULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011405ULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003b00627306ULL, 0x0003e20000200c00ULL, 0x00000010523a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fc40000011449ULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0xfffffff03a3a7812ULL, 0x000fe400078ee253ULL, 0x0000003900737306ULL, 0x0005e20000200c00ULL,
0x00000100053b7824ULL, 0x042fe200078e00ffULL, 0x000160003a3a7811ULL, 0x000fe400078e20ffULL,
0x0000888004647816ULL, 0x040fe200000000ffULL, 0x0001000004047824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x000000003a50783bULL, 0x000fe20000004200ULL,
0x00000048006d7306ULL, 0x000fe20000200c00ULL, 0x000001004a397824ULL, 0x044fe200078e00ffULL,
0x0000888005637816ULL, 0x040fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011406ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fc40000011439ULL, 0x0000003b00657306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x00000018ff437819ULL, 0x000fe40000011407ULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x00000039006a7306ULL, 0x0003f00000200c00ULL, 0x00000049006f7306ULL, 0x0005e20000200c00ULL,
0x0001600056397811ULL, 0x002fca00078e20ffULL, 0x00000000394c783bULL, 0x000e640000004200ULL,
0x0000004a00677306ULL, 0x0007e20000200c00ULL, 0x0000000855497824ULL, 0x044fe400078e00ffULL,
0x0000000855557824ULL, 0x000fca00078e00ffULL, 0x0000004b00667306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000ff00000200c00ULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff3b7819ULL, 0x002fe2000001144cULL,
0x000001004d487824ULL, 0x000fe200078e00ffULL, 0x000088804c407816ULL, 0x000fca00000000ffULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x000088804f4a7816ULL, 0x008fe400000000ffULL,
0x00000018ff487819ULL, 0x000fca0000011448ULL, 0x0000003b00577306ULL, 0x0005f00000200c00ULL,
0x0000006100617306ULL, 0x000ee20000200c00ULL, 0x00000018ff3b7819ULL, 0x004fe4000001144dULL,
0x0000541067607816ULL, 0x002fca0000000060ULL, 0x0000003b005a7306ULL, 0x0003f00000200c00ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00000018ff3b7819ULL, 0x002fe4000001144eULL,
0x0000541066617816ULL, 0x008fca0000000061ULL, 0x0000003b00767306ULL, 0x0003f00000200c00ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00000018ff3b7819ULL, 0x002fce000001144fULL,
0x0000003b007a7306ULL, 0x0003f00000200c00ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3b7819ULL, 0x002fce0000011450ULL, 0x0000003b007e7306ULL, 0x0003f00000200c00ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3b7819ULL, 0x002fce0000011451ULL,
0x0000003b00827306ULL, 0x0003f00000200c00ULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x00000018ff3b7819ULL, 0x002fce0000011452ULL, 0x0000003b00867306ULL, 0x0003f00000200c00ULL,
0x0000006300637306ULL, 0x000ee20000200c00ULL, 0x00000018ff3b7819ULL, 0x002fe40000011453ULL,
0x0000541064627816ULL, 0x004fca0000000062ULL, 0x0000003b00877306ULL, 0x0003f00000200c00ULL,
0x0000000400047306ULL, 0x000ea20000200c00ULL, 0x000000ffff3b7224ULL, 0x002fe200078e0040ULL,
0x0000541063637816ULL, 0x008fe20000000065ULL, 0x000001004c407824ULL, 0x000fc400078e00ffULL,
0x000100004c4c7824ULL, 0x000fc600078e00ffULL, 0x0000003b00567306ULL, 0x0003e20000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff4c7819ULL, 0x000fca000001144cULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000088804d3b7816ULL, 0x002fe400000000ffULL,
0x0000541004047816ULL, 0x004fca000000005eULL, 0x0000003b00597306ULL, 0x0003f00000200c00ULL,
0x0000004c00587306ULL, 0x0004e20000200c00ULL, 0x000100004d3b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000048004d7306ULL, 0x0003220000200c00ULL,
0x00008880504c7816ULL, 0x004fce00000000ffULL, 0x0000003b005b7306ULL, 0x0005220000200c00ULL,
0x000088804e487816ULL, 0x002fe400000000ffULL, 0x0000541058587816ULL, 0x008fca0000000057ULL,
0x0000004c007c7306ULL, 0x0003e20000200c00ULL, 0x000000ffff3b7224ULL, 0x004fe200078e0048ULL,
0x00005410594d7816ULL, 0x010fe2000000004dULL, 0x000001004e487824ULL, 0x040fe400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x0000003b00747306ULL, 0x0005e20000200c00ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00008880514c7816ULL, 0x002fe400000000ffULL, 0x000054105b597816ULL, 0x000fe2000000005aULL,
0x0000004800757306ULL, 0x0002e20000200c00ULL, 0x00000004543b7810ULL, 0x004fc80007ffe0ffULL,
0xfffffff8493b7812ULL, 0x000fe200078ee23bULL, 0x000001004f497824ULL, 0x040fe400078e00ffULL,
0x0000004e00777306ULL, 0x0005220000200c00ULL, 0x000000ffff487224ULL, 0x002fe400078e004aULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x000100004f4f7824ULL, 0x000fc800078e00ffULL,
0x0000004800787306ULL, 0x0003e20000200c00ULL, 0x00000100504e7824ULL, 0x044fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0001000050507824ULL, 0x000fe200078e00ffULL,
0x0000541074747816ULL, 0x008fe40000000075ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004900797306ULL, 0x0004e20000200c00ULL, 0x000120003b487811ULL, 0x002fe400078e20ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x0000541077767816ULL, 0x010fc60000000076ULL,
0x0000004c00807306ULL, 0x0003e20000200c00ULL, 0x000000004848783bULL, 0x004eae0000000200ULL,
0x0000004e007d7306ULL, 0x0009e20000200c00ULL, 0x00008880524c7816ULL, 0x002fe400000000ffULL,
0x0000541078757816ULL, 0x008fca0000000079ULL, 0x0000004c00847306ULL, 0x0003e20000200c00ULL,
0x00000100514e7824ULL, 0x050fe400078e00ffULL, 0x0001000051517824ULL, 0x000fc600078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000004f007b7306ULL, 0x000ee20000200c00ULL,
0x00005410564c7816ULL, 0x002fe40000000040ULL, 0x0000000654407810ULL, 0x000fe20007ffe0ffULL,
0x0001000053547824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0xfffffff855407812ULL, 0x000fe200078ee240ULL, 0x0000004e00817306ULL, 0x000e620000200c00ULL,
0x00000018ff547819ULL, 0x000fce0000011454ULL, 0x00000050007f7306ULL, 0x0009e20000200c00ULL,
0x000000214848a232ULL, 0x084fe20000000000ULL, 0x000054107b777816ULL, 0x008fe2000000007aULL,
0x000000214a4aa232ULL, 0x000fe40000000000ULL, 0x000000224949a232ULL, 0x080fe40000000000ULL,
0x000000224b4ba232ULL, 0x000fe20000000000ULL, 0x0000005100837306ULL, 0x0002a20000200c00ULL,
0x0000010052507824ULL, 0x050fe400078e00ffULL, 0x0001000052527824ULL, 0x000fc600078e00ffULL,
0x0000004c484c723cULL, 0x040b62000000183cULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000000500057306ULL, 0x000ee20000200c00ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000541080517816ULL, 0x002fe40000000081ULL, 0x00008880533c7816ULL, 0x060fe200000000ffULL,
0x000000584844723cULL, 0x000b620000001844ULL, 0x00000100533d7824ULL, 0x000fe200078e00ffULL,
0x0000005000857306ULL, 0x0003220000200c00ULL, 0x0000541083557816ULL, 0x004fca0000000082ULL,
0x000000744808723cULL, 0x000b640000001808ULL, 0x0000003c00597306ULL, 0x0205e20000200c00ULL,
0x00000018ff507819ULL, 0x002fe4000001143dULL, 0x0000541005057816ULL, 0x008fc6000000005fULL,
0x00000076480c723cULL, 0x000f64000000180cULL, 0x00000050005a7306ULL, 0x0002e20000200c00ULL,
0x00012000403c7811ULL, 0x004fe400078e20ffULL, 0x0000541084587816ULL, 0x010fc80000000085ULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x0000005200747306ULL, 0x0008e20000200c00ULL,
0x000054107c507816ULL, 0x002fce000000007dULL, 0x0000005400757306ULL, 0x0002620000200c00ULL,
0x000000504850723cULL, 0x010b620000001810ULL, 0x0000541059597816ULL, 0x008fcc000000005aULL,
0x0000010006117824ULL, 0x020fe200078e00ffULL, 0x000054107f547816ULL, 0x002fe2000000007eULL,
0x000000584858723cULL, 0x040be20000001830ULL, 0x0000541074747816ULL, 0x000fe20000000086ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000888006107816ULL, 0x040fe200000000ffULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000541075757816ULL, 0x000fe20000000087ULL, 0x000000544854723cULL, 0x000b64000000182cULL,
0x000054106d307816ULL, 0x020fe2000000006bULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x000054106f317816ULL, 0x000fc4000000006cULL, 0x00000018ff067819ULL, 0x000fe40000011406ULL,
0x00005410692c7816ULL, 0x000fe2000000006aULL, 0x000000744848723cULL, 0x000b620000001834ULL,
0x00005410682d7816ULL, 0x000fe2000000006eULL, 0x0000001000747306ULL, 0x0203e20000200c00ULL,
0x000000213c3ca232ULL, 0x084fe40000000000ULL, 0x000000213e3ea232ULL, 0x000fe40000000000ULL,
0x0000541070347816ULL, 0x000fe20000000071ULL, 0x000000223d3da232ULL, 0x000fc40000000000ULL,
0x0000001100757306ULL, 0x0004e20000200c00ULL, 0x0000888007107816ULL, 0x042fe200000000ffULL,
0x000000223f3fa232ULL, 0x000fe20000000000ULL, 0x0000541072357816ULL, 0x000fe20000000073ULL,
0x0000010007117824ULL, 0x004fcc00078e00ffULL, 0x000000343c34723cULL, 0x000b62000000184cULL,
0x0001000007077824ULL, 0x000fe200078e00ffULL, 0x00000010004c7306ULL, 0x020fe20000200c00ULL,
0x00000018ff117819ULL, 0x000fc60000011411ULL, 0x00000018ff077819ULL, 0x000fe40000011407ULL,
0x000000303c30723cULL, 0x040b640000001844ULL, 0x0000001100457306ULL, 0x0202ac0000200c00ULL,
0x0000002c3c2c723cULL, 0x040f640000001808ULL, 0x0000000600447306ULL, 0x000f2c0000200c00ULL,
0x000000603c10723cULL, 0x042b64000000180cULL, 0x0000000700467306ULL, 0x00026a0000200c00ULL,
0x00005410740c7816ULL, 0x028fe20000000075ULL, 0x000000623c08723cULL, 0x000b620000001850ULL,
0x000054104c0d7816ULL, 0x004fc40000000045ULL, 0x0000541044427816ULL, 0x010fca0000000042ULL,
0x000000043c04723cULL, 0x002b620000001854ULL, 0x0000541046437816ULL, 0x000fce0000000043ULL,
0x0000000c3c0c723cULL, 0x040b700000001858ULL, 0x000000423c3c723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff427f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000142a00720cULL, 0x000fe20003f06070ULL, 0x01868800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff497224ULL, 0x002fc400078e0043ULL, 0x000000ffff487224ULL, 0x000fd200078e005cULL,
0x0000c8f000000947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x0186bc00ff187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442447210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011445ULL,
0x0000004418187211ULL, 0x000fca00078110ffULL, 0x000000ffff447224ULL, 0x000fca00000e0645ULL,
0x0000000218187819ULL, 0x000fc80000001244ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000202a187810ULL, 0x000fe20007ffe0ffULL,
0x0000000117437824ULL, 0x000fe200078e0223ULL, 0x00000004234f7810ULL, 0x000fe40007ffe0ffULL,
0x0000001814427217ULL, 0x000fe20007800000ULL, 0x0000000143447824ULL, 0x000fe200078e0203ULL,
0x0000000223487810ULL, 0x000fe20007ffe0ffULL, 0x00000010434d7824ULL, 0x000fe200078e00ffULL,
0x0000000623517810ULL, 0x000fe20007ffe0ffULL, 0x0000000142427824ULL, 0x000fe200078e0a18ULL,
0x0000006000187811ULL, 0x000fe200078e38ffULL, 0x0000000117467824ULL, 0x000fe200078e024fULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee244ULL, 0x0000000117457824ULL, 0x040fe200078e0248ULL,
0x0000004217427217ULL, 0x000fe20007800000ULL, 0x0000000146477824ULL, 0x000fe200078e0203ULL,
0x000000f01e4c7812ULL, 0x000fe200078ec0ffULL, 0x0000001046507824ULL, 0x000fe200078e00ffULL,
0x000160004d4d7811ULL, 0x000fe200078e20ffULL, 0x0000000143437824ULL, 0x000fc400078e0218ULL,
0x0000000145447824ULL, 0x040fe200078e0203ULL, 0xfffffff050507812ULL, 0x000fe200078ee247ULL,
0x00000010454e7824ULL, 0x000fe200078e00ffULL, 0x000000435d4b7210ULL, 0x000fe20007f1e0ffULL,
0x0000000117477824ULL, 0x000fe200078e0251ULL, 0x0001600050507811ULL, 0x000fe200078e20ffULL,
0x0000000145437824ULL, 0x000fe200078e0218ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee244ULL,
0x0000000146447824ULL, 0x100fe400078e0218ULL, 0x0000000147457824ULL, 0x000fe200078e0218ULL,
0x000000435d437210ULL, 0x000fe20007f9e0ffULL, 0x0000000147497824ULL, 0x000fe200078e0203ULL,
0x000000445d447210ULL, 0x000fe20007f7e0ffULL, 0x0000001047527824ULL, 0x000fe200078e00ffULL,
0x000000455d457210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff477224ULL, 0x000fe200000e06ffULL,
0x00005e004b467a11ULL, 0x040fe200078040ffULL, 0x0000000142187824ULL, 0x000fe200078e0a17ULL,
0xfffffff052527812ULL, 0x000fe200078ee249ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005f004b4b7a11ULL, 0x000fc400000f4447ULL, 0x000000184800720cULL, 0x080fe20003f06070ULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x00005e0043497a11ULL, 0x000fe400078c40ffULL,
0x00005e0044477a11ULL, 0x040fe400078a40ffULL, 0x000000182300720cULL, 0x000fe40003f86070ULL,
0x00005f00434a7a11ULL, 0x000fe400030f444aULL, 0x00005f0044487a11ULL, 0x000fe200028f4448ULL,
0x000000ffff447224ULL, 0x000fe200010e06ffULL, 0x0000004c46427210ULL, 0x000fc40007fde0ffULL,
0x00005e0045467a11ULL, 0x000fe400078a40ffULL, 0x000000184f00720cULL, 0x080fe20003f66070ULL,
0x000000ffff437224ULL, 0x000fe200030e064bULL, 0x000000185100720cULL, 0x000fe40003f46070ULL,
0x00005f0045187a11ULL, 0x000fe400028f4444ULL, 0x0000004c49447210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000424d7faeULL, 0x0003e2000e101c46ULL,
0x000160004e4e7811ULL, 0x000fc400078e20ffULL, 0x0001600052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200028e064aULL, 0x0000004c46467210ULL, 0x000fc80007fbe0ffULL,
0x00000000444e7faeULL, 0x0005e2000c101c46ULL, 0x0000004c47427210ULL, 0x002fe20007f9e0ffULL,
0x000000ffff477224ULL, 0x000fc800028e0618ULL, 0x000000ffff437224ULL, 0x000fca00020e0648ULL,
0x0000000042507faeULL, 0x0005e8000d901c46ULL, 0x0000000046527faeULL, 0x0005e2000d101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000000117187824ULL, 0x000fe200078e0223ULL,
0x0000006000437811ULL, 0x000fe400078e38ffULL, 0x000000f01e4c7812ULL, 0x000fe200078ec0ffULL,
0x0000000118427824ULL, 0x040fe200078e0203ULL, 0x0000000218457810ULL, 0x040fe20007ffe0ffULL,
0x00000010184d7824ULL, 0x040fe200078e00ffULL, 0x0000000418467810ULL, 0x000fc40007ffe0ffULL,
0x0000000618477810ULL, 0x040fe20007ffe0ffULL, 0x0000000145447824ULL, 0x000fe200078e0203ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL, 0x00000010454e7824ULL, 0x000fe400078e00ffULL,
0x0000000118427824ULL, 0x100fe200078e0243ULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000145187824ULL, 0x000fe200078e0243ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee244ULL,
0x0000000146457824ULL, 0x040fe200078e0203ULL, 0x000000425d447210ULL, 0x040fe20007f7e0ffULL,
0x0000000146427824ULL, 0x100fe200078e0243ULL, 0x000000185d4a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000147437824ULL, 0x000fe200078e0243ULL, 0x00005e0044487a11ULL, 0x000fe200078840ffULL,
0x00000010464f7824ULL, 0x000fe200078e00ffULL, 0x000000425d427210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x000000435d437210ULL, 0x000fe20007f7e0ffULL,
0x0000000147467824ULL, 0x000fe200078e0203ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee245ULL,
0x0000001047507824ULL, 0x000fe200078e00ffULL, 0x00005f00444b7a11ULL, 0x000fe200020f4418ULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005e004a187a11ULL, 0x000fe200078040ffULL,
0x000000ffff457224ULL, 0x000fe200010e06ffULL, 0x00005e0042447a11ULL, 0x000fe200078440ffULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x0000004c48487210ULL, 0x000fc40007f9e0ffULL,
0xfffffff050507812ULL, 0x000fe400078ee246ULL, 0x00005e0043467a11ULL, 0x040fe400078640ffULL,
0x00005f004a4a7a11ULL, 0x000fe200000f4449ULL, 0x000000ffff497224ULL, 0x000fe200020e064bULL,
0x00005f0042457a11ULL, 0x000fe400010f4445ULL, 0x0000004c18427210ULL, 0x080fe40007f1e0ffULL,
0x00005f0043477a11ULL, 0x000fe200018f4447ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000484d7faeULL, 0x0003e2000b901c46ULL, 0x0000004c44447210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e064aULL, 0x0000004c46467210ULL, 0x000fc40007f7e0ffULL,
0x000160004e187811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe400010e0645ULL,
0x000000ffff477224ULL, 0x000fe400018e0647ULL, 0x0000000042187faeULL, 0x0005e2000b901c46ULL,
0x000160004f487811ULL, 0x002fe400078e20ffULL, 0x0001600050497811ULL, 0x000fc600078e20ffULL,
0x0000000044487faeULL, 0x0005e8000b901c46ULL, 0x0000000046497faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000000011c187810ULL, 0x000fc80007ffe0ffULL,
0x000000151800720cULL, 0x000fe20003f06070ULL, 0xffffffffff187424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000011a427810ULL, 0x000fe20007ffe01cULL,
0x00000004ff437424ULL, 0x000fc800078e00ffULL, 0x0000600042427625ULL, 0x000fca00078e0043ULL,
0x0000000642187981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff4a7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186280017467f8cULL, 0x000664000c80043fULL, 0x0000000000427805ULL, 0x002fc40000015200ULL,
0x01862c0017447984ULL, 0x000e640000000800ULL, 0x8000000044ff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442487210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff447819ULL, 0x000fc80000011445ULL,
0x0000004844447211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e0645ULL,
0x0000000244447819ULL, 0x000fc80000001245ULL, 0x000000440000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01862c0017447984ULL, 0x000e640000000800ULL,
0x8000000044ff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018080001f447984ULL, 0x000e680000000800ULL, 0x018280001f457984ULL, 0x0006a20000000800ULL,
0x0000005c4400720bULL, 0x002fe20003f1d000ULL, 0x000139c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000467806ULL, 0x008fc800000e0100ULL, 0x0000ffff46ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff477424ULL, 0x000fc400078e00ffULL,
0x000000ffff487224ULL, 0x000fd200078e005cULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000010200780cULL, 0x000fe40003f05270ULL, 0x0000005c4400720bULL, 0x000fe20003f54000ULL,
0x000139927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000477806ULL, 0x000fc400010e0100ULL,
0x0000005c44428209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x018480421f008388ULL, 0x0003e40000000800ULL, 0x0000991047427816ULL, 0x002fc800000000ffULL,
0x000000ff4200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000005c44427209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff47ff7812ULL, 0x000fc6000780c0ffULL, 0x0000005c42427221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x00000042004d7308ULL, 0x000e640000000800ULL,
0x0000004d19197220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff427819ULL, 0x000fe20000011603ULL, 0x000138e27f007947ULL, 0x000fea000b800000ULL,
0x00001f424d427589ULL, 0x0002e400000e0000ULL, 0x0000004234347220ULL, 0x088fe40000410000ULL,
0x0000004235357220ULL, 0x080fe40000410000ULL, 0x0000004230307220ULL, 0x080fe40000410000ULL,
0x0000004231317220ULL, 0x000fc40000410000ULL, 0x000000422c2c7220ULL, 0x080fe40000410000ULL,
0x000000422d2d7220ULL, 0x080fe40000410000ULL, 0x0000004210107220ULL, 0x080fe40000410000ULL,
0x0000004211117220ULL, 0x080fe40000410000ULL, 0x0000004208087220ULL, 0x080fe40000410000ULL,
0x0000004209097220ULL, 0x000fc40000410000ULL, 0x0000004204047220ULL, 0x080fe40000410000ULL,
0x0000004205057220ULL, 0x080fe40000410000ULL, 0x000000420c0c7220ULL, 0x080fe40000410000ULL,
0x000000420d0d7220ULL, 0x080fe40000410000ULL, 0x000000423c3c7220ULL, 0x080fe40000410000ULL,
0x000000423d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0047ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803427811ULL, 0x000fe200078ff0ffULL, 0x000137f27f007947ULL, 0x000fea000b800000ULL,
0x00001f424d427589ULL, 0x00066400000e0000ULL, 0x0000004236367220ULL, 0x082fe40000410000ULL,
0x0000004237377220ULL, 0x080fe40000410000ULL, 0x0000004232327220ULL, 0x080fe40000410000ULL,
0x0000004233337220ULL, 0x080fe40000410000ULL, 0x000000422e2e7220ULL, 0x080fe40000410000ULL,
0x000000422f2f7220ULL, 0x000fc40000410000ULL, 0x0000004212127220ULL, 0x080fe40000410000ULL,
0x0000004213137220ULL, 0x080fe40000410000ULL, 0x000000420a0a7220ULL, 0x080fe40000410000ULL,
0x000000420b0b7220ULL, 0x080fe40000410000ULL, 0x0000004206067220ULL, 0x080fe40000410000ULL,
0x0000004207077220ULL, 0x000fc40000410000ULL, 0x000000420e0e7220ULL, 0x080fe40000410000ULL,
0x000000420f0f7220ULL, 0x080fe40000410000ULL, 0x000000423e3e7220ULL, 0x080fe40000410000ULL,
0x000000423f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff47ff7812ULL, 0x000fe20007800846ULL, 0x00000001ff477424ULL, 0x000fe200078e00ffULL,
0x0000005c445c7209ULL, 0x000fca0007810000ULL, 0x000000ffff487224ULL, 0x000fcc00078e005cULL,
0x8000005c44440221ULL, 0x100fe20000010000ULL, 0x00007610ff470816ULL, 0x000fe20000000047ULL,
0x000000ffff480224ULL, 0x000fe400078e005cULL, 0x3fb8aa3b44440820ULL, 0x000fc80000410000ULL,
0x0000004400200308ULL, 0x000e640000000800ULL, 0x0000002045450220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001945197221ULL, 0x004fc40000010000ULL,
0x0000000000427805ULL, 0x000fca0000015200ULL, 0x0186ac00ff447984ULL, 0x000e640000000800ULL,
0x8000000044ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff497224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442467210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff447819ULL, 0x000fc80000011445ULL, 0x0000004644447211ULL, 0x000fca00078110ffULL,
0x000000ffff457224ULL, 0x000fca00000e0645ULL, 0x0000000244447819ULL, 0x000fc80000001245ULL,
0x000000440000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000149497810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff447984ULL, 0x000e640000000800ULL, 0x8000000044ff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991047417816ULL, 0x000fe200000000ffULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000ff4100720cULL, 0x000fda0003f45270ULL,
0x0000014000002947ULL, 0x000fea0003800000ULL, 0x00000020ff21723eULL, 0x000fe400000000ffULL,
0x00000002ff417819ULL, 0x000fe40000011603ULL, 0x00005410214d7816ULL, 0x008fe20000000021ULL,
0x000133d27f007947ULL, 0x000fea000b800000ULL, 0x00001f414d217589ULL, 0x0002a400000e0000ULL,
0x0000000841227810ULL, 0x000fe20007ffe0ffULL, 0x000134127f007947ULL, 0x000fea000b800000ULL,
0x00001f224d227589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010414c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff437424ULL, 0x000fe200078e00ffULL,
0x00006e5000427802ULL, 0x000fe20000000f00ULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x000141e000007944ULL, 0x01efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018414c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff437424ULL, 0x000fe200078e00ffULL,
0x00006eb000427802ULL, 0x000fe20000000f00ULL, 0xffffffffff497424ULL, 0x004fc400078e00ffULL,
0x0001418000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000254c783bULL, 0x00ae680000004200ULL,
0x000000002650783bULL, 0x000fe80000004200ULL, 0x000000002454783bULL, 0x000ee80000004200ULL,
0x000000002744783bULL, 0x000ea20000004200ULL, 0x00000018ff597819ULL, 0x002fe2000001144dULL,
0x000001004d6f7824ULL, 0x040fe200078e00ffULL, 0x000088804d6e7816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe2000001144cULL,
0x000001004c6d7824ULL, 0x040fe200078e00ffULL, 0x000088804c6c7816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000006e00707306ULL, 0x000fe20000200c00ULL, 0x00000018ff647819ULL, 0x000fe2000001144eULL,
0x00000100545d7824ULL, 0x008fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000010055667824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe2000001144fULL,
0x0000010056697824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011450ULL,
0x0000004d00717306ULL, 0x0003e20000200c00ULL, 0x00008880517b7816ULL, 0x000fe200000000ffULL,
0x00000100576b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc40000011454ULL,
0x00000018ff637819ULL, 0x000fe40000011451ULL, 0x00008880545c7816ULL, 0x000fe200000000ffULL,
0x0000004c006e7306ULL, 0x0007e20000200c00ULL, 0x000001004e4d7824ULL, 0x002fe200078e00ffULL,
0x00008880555f7816ULL, 0x000fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x0000888056687816ULL, 0x000fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000041005e7306ULL, 0x0003e20000200c00ULL, 0x000088804e4c7816ULL, 0x048fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004d00737306ULL, 0x0007e20000200c00ULL, 0x00000018ff417819ULL, 0x002fe20000011455ULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x00008880576a7816ULL, 0x000fe400000000ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000004c00727306ULL, 0x0003e20000200c00ULL, 0x000001004f4d7824ULL, 0x008fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fc4000001145dULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004e00747306ULL, 0x000fe20000200c00ULL,
0x000088804f4c7816ULL, 0x042fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe20000011456ULL, 0x0001000056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011457ULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000004c00757306ULL, 0x0003e20000200c00ULL,
0x00000018ff567819ULL, 0x000fc40000011456ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff607819ULL, 0x000fe40000011452ULL, 0x00000018ff617819ULL, 0x000fe20000011453ULL,
0x0000004d00767306ULL, 0x0007e20000200c00ULL, 0x00008880504c7816ULL, 0x002fe400000000ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x00000018ff6f7819ULL, 0x000fc4000001146fULL,
0x00000018ff437819ULL, 0x004fe20000011444ULL, 0x0000004c00787306ULL, 0x0003e20000200c00ULL,
0x00000100504d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011445ULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011447ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004f00777306ULL, 0x000fe20000200c00ULL,
0x00012800284c7811ULL, 0x002fc400078e20ffULL, 0x00000018ff507819ULL, 0x000fca0000011450ULL,
0x0000004d00797306ULL, 0x0003f00000200c00ULL, 0x00000050007a7306ULL, 0x0005e20000200c00ULL,
0x000000004c4c783bULL, 0x002e6e0000000200ULL, 0x0000004100677306ULL, 0x0007e20000200c00ULL,
0x000000ffff507224ULL, 0x004fc400078e007bULL, 0x00000100517b7824ULL, 0x040fe400078e00ffULL,
0x0001000051517824ULL, 0x000fc600078e00ffULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff417819ULL, 0x008fc60000011446ULL, 0x00000051007d7306ULL, 0x0007f00000200c00ULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x0000010052517824ULL, 0x008fe200078e00ffULL,
0x0000541054547816ULL, 0x004fc8000000005eULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000214c4ca232ULL, 0x082fe40000000000ULL,
0x000000214e4ea232ULL, 0x000fe40000000000ULL, 0x000000224d4da232ULL, 0x080fe40000000000ULL,
0x000000224f4fa232ULL, 0x000fe20000000000ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541055557816ULL, 0x000fce0000000067ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000000544c30723cULL, 0x000bee0000001830ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0001280029547811ULL, 0x020fe200078e20ffULL, 0x0000010044557824ULL, 0x000fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x00000051007f7306ULL, 0x0003f00000200c00ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000010053517824ULL, 0x002fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005d005d7306ULL, 0x000e700000200c00ULL,
0x0000005f005f7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce000000005dULL, 0x00000050007c7306ULL, 0x0003f00000200c00ULL,
0x0000005100827306ULL, 0x0007e20000200c00ULL, 0x0000888052507816ULL, 0x042fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x000054105f5d7816ULL, 0x004fc80000000066ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x00000050007e7306ULL, 0x0003e20000200c00ULL,
0x0000888044517816ULL, 0x048fe200000000ffULL, 0x0000005c4c34723cULL, 0x000b620000001834ULL,
0x0001000044447824ULL, 0x000fca00078e00ffULL, 0x0000005100677306ULL, 0x0005e20000200c00ULL,
0x0000888053507816ULL, 0x042fe200000000ffULL, 0x0001000053537824ULL, 0x000fe200078e00ffULL,
0x00005410725c7816ULL, 0x020fe40000000073ULL, 0x00005410755d7816ULL, 0x000fe40000000076ULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000005000817306ULL, 0x0003e20000200c00ULL,
0x000054106a517816ULL, 0x004fe4000000006bULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000005c4c5c723cULL, 0x000be8000000180cULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541068507816ULL, 0x002fc40000000069ULL, 0x00005410780c7816ULL, 0x020fca0000000079ULL,
0x0000005b005b7306ULL, 0x000ff00000200c00ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000005700577306ULL, 0x000eb00000200c00ULL, 0x0000005200807306ULL, 0x000fe20000200c00ULL,
0x00005410565a7816ULL, 0x002fce000000005aULL, 0x0000005300667306ULL, 0x0003e20000200c00ULL,
0x00005410575b7816ULL, 0x004fce000000005bULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x000000504c50723cULL, 0x042be4000000182cULL, 0x00000000542c783bULL, 0x0202ea0000000200ULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x0000005a4c10723cULL, 0x000be20000001810ULL,
0x0000888045547816ULL, 0x002fcc00000000ffULL, 0x0000006400647306ULL, 0x000e620000200c00ULL,
0x00000100455a7824ULL, 0x060fe200078e00ffULL, 0x000054106e587816ULL, 0x004fe20000000058ULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x0000541071597816ULL, 0x000fe40000000059ULL,
0x00000018ff457819ULL, 0x000fca0000011445ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000541074647816ULL, 0x002fce0000000064ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000541077657816ULL, 0x004fe20000000065ULL, 0x000000212c2ca232ULL, 0x088fe40000000000ULL,
0x000000212e2ea232ULL, 0x000fe40000000000ULL, 0x000000222d2da232ULL, 0x080fe40000000000ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000000644c3c723cULL, 0x000fe2000000183cULL,
0x000000222f2fa232ULL, 0x000fcc0000000000ULL, 0x0000007b007b7306ULL, 0x000e700000200c00ULL,
0x0000005a006a7306ULL, 0x0005f00000200c00ULL, 0x0000005500687306ULL, 0x0006e20000200c00ULL,
0x000000584c58723cULL, 0x004be20000001804ULL, 0x000054107c0d7816ULL, 0x002fcc000000007bULL,
0x0000005400697306ULL, 0x0002a20000200c00ULL, 0x0000010046057824ULL, 0x020fe200078e00ffULL,
0x0000541070557816ULL, 0x008fe2000000006fULL, 0x0000000c2c0c723cULL, 0x000fe20000001834ULL,
0x0000888046047816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000006200627306ULL, 0x000ee20000200c00ULL,
0x000054106c547816ULL, 0x002fe4000000006dULL, 0x00000018ff467819ULL, 0x000fc40000011446ULL,
0x0000541067687816ULL, 0x000fc60000000068ULL, 0x000000544c54723cULL, 0x000b620000001808ULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x0000541069697816ULL, 0x004fca000000006aULL,
0x000054107a087816ULL, 0x028fe40000000062ULL, 0x00000004004c7306ULL, 0x0005f00000200c00ULL,
0x00000005004d7306ULL, 0x0006e20000200c00ULL, 0x0000888047047816ULL, 0x004fc400000000ffULL,
0x000054107d097816ULL, 0x002fc80000000063ULL, 0x000000682c54723cULL, 0x000f620000001854ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x0000010047057824ULL, 0x048fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x000000082c08723cULL, 0x000b620000001830ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000006100617306ULL, 0x000ea20000200c00ULL, 0x000054104c347816ULL, 0x000fe4000000004dULL,
0x0000541080607816ULL, 0x002fca0000000060ULL, 0x0000004300437306ULL, 0x000ff00000200c00ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x0000541066617816ULL, 0x004fce0000000061ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x000000602c10723cULL, 0x000b6e0000001810ULL,
0x0000004500457306ULL, 0x000eb00000200c00ULL, 0x0000000400357306ULL, 0x0007e20000200c00ULL,
0x0000541044307816ULL, 0x022fce0000000043ULL, 0x0000000500367306ULL, 0x0002620000200c00ULL,
0x000054107e047816ULL, 0x008fe4000000007fULL, 0x0000541045317816ULL, 0x004fca0000000049ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x0000541081057816ULL, 0x002fe20000000082ULL,
0x000000302c30723cULL, 0x040b6c0000001858ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000541035357816ULL, 0x000fe20000000036ULL, 0x000000042c04723cULL, 0x040b6c0000001850ULL,
0x0000004600467306ULL, 0x000e640000200c00ULL, 0x000000342c34723cULL, 0x000b6c000000185cULL,
0x0000004700477306ULL, 0x000ea20000200c00ULL, 0x0000541046467816ULL, 0x002fc40000000041ULL,
0x0000541047477816ULL, 0x004fce0000000042ULL, 0x000000462c2c723cULL, 0x000b62000000183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff427f8cULL, 0x000e62000c80043fULL,
0x000000ffff447224ULL, 0x000fce00078e00ffULL, 0x00000000003c7805ULL, 0x020fc40000015200ULL,
0x0186bc00ff3e7984ULL, 0x000ea40000000800ULL, 0x800000003eff7812ULL, 0x006fe40007804843ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000413e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580018447a24ULL, 0x010fc800078e02ffULL,
0x0000008044447824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000402a3c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001173e7824ULL, 0x000fe200078e0223ULL,
0x00000002234d7810ULL, 0x040fe40007ffe0ffULL, 0x0000003c143d7217ULL, 0x000fe20007800000ULL,
0x0000008000477824ULL, 0x000fe200078e023eULL, 0x00000004234f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013e3f7824ULL, 0x000fe200078e0203ULL, 0x000000f01e497812ULL, 0x000fe200078ec0ffULL,
0x000000103e4c7824ULL, 0x000fe200078e00ffULL, 0x0000004447437210ULL, 0x080fe20007f1e0ffULL,
0x00000001173e7824ULL, 0x000fe200078e024dULL, 0x0000000247467810ULL, 0x000fe20007ffe0ffULL,
0x000000013d3d7824ULL, 0x000fe200078e0a3cULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee23fULL,
0x00000001173c7824ULL, 0x000fe200078e024fULL, 0x0000000447457810ULL, 0x000fe20007ffe0ffULL,
0x000000013e3f7824ULL, 0x140fe200078e0203ULL, 0x0000003d173d7217ULL, 0x000fe20007800000ULL,
0x000000103e4e7824ULL, 0x000fe200078e00ffULL, 0x0000004445457210ULL, 0x000fe20007f7e0ffULL,
0x000000013c3e7824ULL, 0x000fe200078e0203ULL, 0x000140004c4c7811ULL, 0x000fe200078e20ffULL,
0x000000103c507824ULL, 0x000fe200078e00ffULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee23fULL,
0x000000ffff3c7224ULL, 0x000fe200000e06ffULL, 0x00005e0043417a11ULL, 0x000fe200078040ffULL,
0x000000013d3f7824ULL, 0x000fe200078e0a17ULL, 0xfffffff050507812ULL, 0x000fe200078ee23eULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005f0043437a11ULL, 0x000fc400000f443cULL,
0x0000004446467210ULL, 0x000fe40007f1e0ffULL, 0x0000003f2300720cULL, 0x000fe40003f86070ULL,
0x00005e00453e7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x00005e0046427a11ULL, 0x040fe400078040ffULL, 0x00005f0045457a11ULL, 0x000fe400028f443dULL,
0x00005f0046467a11ULL, 0x000fc400000f443cULL, 0x00000049413c7210ULL, 0x000fe40007f7e0ffULL,
0x0000003f4d00720cULL, 0x080fe40003f06070ULL, 0x00000006234d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e0643ULL, 0x0000000647417810ULL, 0x000fe40007ffe0ffULL,
0x0000003f4f00720cULL, 0x000fe20003f66070ULL, 0x0000000117437824ULL, 0x000fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4c7faeULL, 0x0003e2000e101c46ULL,
0x0000004441417210ULL, 0x000fc40007f9e0ffULL, 0x0000000143477824ULL, 0x040fe200078e0203ULL,
0x000000493e3e7210ULL, 0x080fe40007fde0ffULL, 0x000140004e4e7811ULL, 0x000fe400078e20ffULL,
0x0001400050507811ULL, 0x000fe400078e20ffULL, 0x00000049423c7210ULL, 0x002fe20007fbe0ffULL,
0x00000010434c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff437224ULL, 0x000fe200020e06ffULL,
0x00005e0041427a11ULL, 0x000fe200078840ffULL, 0x000000ffff3d7224ULL, 0x000fe200028e0646ULL,
0x0000003f4d00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff3f7224ULL, 0x000fe200030e0645ULL,
0x00005f0041417a11ULL, 0x000fc400020f4443ULL, 0x0000004942427210ULL, 0x000fe20007f9e0ffULL,
0x000000003c4e7faeULL, 0x0003e2000c101c46ULL, 0xfffffff04c477812ULL, 0x000fc600078ee247ULL,
0x000000ffff437224ULL, 0x000fe200020e0641ULL, 0x0001400047477811ULL, 0x000fe200078e20ffULL,
0x000000003e507faeULL, 0x0003e8000d901c46ULL, 0x0000000042477faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x00000001173c7824ULL, 0x000fe200078e0223ULL,
0x000000f01e467812ULL, 0x000fc600078ec0ffULL, 0x000000013c3d7824ULL, 0x040fe200078e0203ULL,
0x000000023c3e7810ULL, 0x040fe20007ffe0ffULL, 0x000000103c417824ULL, 0x000fc800078e00ffULL,
0x000000013e3f7824ULL, 0x040fe200078e0203ULL, 0xfffffff041417812ULL, 0x000fe200078ee23dULL,
0x000000103e457824ULL, 0x000fe200078e00ffULL, 0x000000043c3e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080003d7824ULL, 0x000fe200078e023cULL, 0x0001400041417811ULL, 0x000fe400078e20ffULL,
0xfffffff045457812ULL, 0x000fe200078ee23fULL, 0x000000013e427824ULL, 0x000fe200078e0203ULL,
0x000000063c3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000103e4d7824ULL, 0x000fe200078e00ffULL,
0x000000443d3c7210ULL, 0x000fc40007f1e0ffULL, 0x0001400045457811ULL, 0x000fe200078e20ffULL,
0x000000013f437824ULL, 0x000fe200078e0203ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL,
0x000000103f517824ULL, 0x000fe200078e00ffULL, 0x000000023d427810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e003c3f7a11ULL, 0x040fe400078040ffULL,
0xfffffff051517812ULL, 0x000fe400078ee243ULL, 0x00005f003c3e7a11ULL, 0x000fc400000f443eULL,
0x000000043d3c7810ULL, 0x040fe40007ffe0ffULL, 0x000000063d3d7810ULL, 0x000fe40007ffe0ffULL,
0x0000004442427210ULL, 0x080fe40007f1e0ffULL, 0x000000443c477210ULL, 0x080fe40007f7e0ffULL,
0x000000443d4e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e06ffULL,
0x00005e0042437a11ULL, 0x000fe200078040ffULL, 0x000000ffff497224ULL, 0x000fe200018e06ffULL,
0x000000463f3c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200028e06ffULL,
0x00005e00474c7a11ULL, 0x000fc400078840ffULL, 0x00005e004e507a11ULL, 0x000fe400078a40ffULL,
0x00005f00423f7a11ULL, 0x000fe200000f443dULL, 0x000000ffff3d7224ULL, 0x000fe200018e063eULL,
0x00000046433e7210ULL, 0x080fe40007f1e0ffULL, 0x00005f0047497a11ULL, 0x000fe400020f4449ULL,
0x000000464c427210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e063fULL,
0x00005f004e4f7a11ULL, 0x000fe200028f444fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c417faeULL, 0x0003e2000b901c46ULL, 0x0000004650467210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff437224ULL, 0x000fe200018e0649ULL, 0x000140004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000003e457faeULL, 0x0003e2000b901c46ULL, 0x0001400051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fc400020e064fULL, 0x00000000424d7faeULL, 0x0003e8000b901c46ULL,
0x0000000046517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff3c7f8cULL, 0x000e64000c80043fULL,
0x000000ffff417224ULL, 0x002fc400078e003dULL, 0x00000000003c7805ULL, 0x000fca0000015200ULL,
0x0186b400ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fc4000780484bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff437224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c427210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004200780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404200780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000423e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000143437810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000016000007945ULL, 0x000fe20003800000ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x00000020ff21723eULL, 0x000fe400000000ffULL, 0x00000002ff3c7819ULL, 0x000fe40000011603ULL,
0x00005410214d7816ULL, 0x000fe20000000021ULL, 0x000117c27f007947ULL, 0x000fea000b800000ULL,
0x00001f3c4d217589ULL, 0x0002a400000e0000ULL, 0x000000083c227810ULL, 0x000fe20007ffe0ffULL,
0x000118027f007947ULL, 0x000fea000b800000ULL, 0x00001f224d227589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000103c4c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x00008b4000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x000124f000007944ULL, 0x00efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000183c4c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x00008ba000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff497424ULL, 0x004fc400078e00ffULL, 0x0001249000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000128003b627811ULL, 0x000fc400078e20ffULL, 0x000000003a50783bULL, 0x000f280000004200ULL,
0x000000002b4c783bULL, 0x00afe80000004200ULL, 0x000000003958783bULL, 0x000e620000004200ULL,
0x00000018ff5d7819ULL, 0x010fe20000011451ULL, 0x0000010051707824ULL, 0x040fe200078e00ffULL,
0x00008880516f7816ULL, 0x040fe200000000ffULL, 0x0001000051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011450ULL, 0x00000100506e7824ULL, 0x040fe200078e00ffULL,
0x00008880506d7816ULL, 0x040fe200000000ffULL, 0x0001000050507824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000010058647824ULL, 0x002fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x0000010059677824ULL, 0x000fe200078e00ffULL,
0x0000005100727306ULL, 0x0003e20000200c00ULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x000001005a6a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011452ULL,
0x000001005b6c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc40000011453ULL,
0x00000018ff3c7819ULL, 0x000fe20000011458ULL, 0x0000007000717306ULL, 0x000fe20000200c00ULL,
0x0000010052517824ULL, 0x002fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144cULL,
0x000088804d7b7816ULL, 0x000fe400000000ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005000707306ULL, 0x0003e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fc4000001144dULL,
0x0000888058637816ULL, 0x040fe200000000ffULL, 0x0001000058587824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000888059657816ULL, 0x000fe200000000ffULL,
0x0000005100747306ULL, 0x0007e20000200c00ULL, 0x0000888052507816ULL, 0x042fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x00000018ff587819ULL, 0x000fc40000011458ULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0000005000737306ULL, 0x0003e20000200c00ULL, 0x0000010053517824ULL, 0x048fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe4000001144eULL, 0x00000018ff497819ULL, 0x004fe4000001144fULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000003c00667306ULL, 0x0005e20000200c00ULL,
0x0000888053507816ULL, 0x042fe200000000ffULL, 0x0001000053537824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fc4000001145aULL, 0x00000018ff5f7819ULL, 0x000fe4000001145bULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000005100777306ULL, 0x0003e20000200c00ULL,
0x00000018ff3c7819ULL, 0x004fe20000011459ULL, 0x0001000059597824ULL, 0x000fe200078e00ffULL,
0x000088805a697816ULL, 0x040fe200000000ffULL, 0x000100005a5a7824ULL, 0x000fe200078e00ffULL,
0x000088805b6b7816ULL, 0x040fe200000000ffULL, 0x000100005b5b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000005000767306ULL, 0x0005e20000200c00ULL,
0x000001004c517824ULL, 0x002fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fc4000001145aULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005200757306ULL, 0x000fe20000200c00ULL, 0x000088804c507816ULL, 0x044fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000005300787306ULL, 0x000fe20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fce000001146eULL,
0x0000005000797306ULL, 0x000ff00000200c00ULL, 0x00000051007a7306ULL, 0x0003f00000200c00ULL,
0x0000003c00687306ULL, 0x0005e20000200c00ULL, 0x000000006250783bULL, 0x0022ee0000000200ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000000383c783bULL, 0x004eae0000004200ULL,
0x0000004c00627306ULL, 0x0023f00000200c00ULL, 0x0000006400647306ULL, 0x000f220000200c00ULL,
0x000000ffff4c7224ULL, 0x002fc400078e007bULL, 0x000001004d7b7824ULL, 0x040fe400078e00ffULL,
0x000100004d4d7824ULL, 0x000fc600078e00ffULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x00000018ff4d7819ULL, 0x000fca000001144dULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x000000215050a232ULL, 0x088fe20000000000ULL,
0x0000541063647816ULL, 0x010fe20000000064ULL, 0x000000215252a232ULL, 0x000fe40000000000ULL,
0x000000225151a232ULL, 0x080fe40000000000ULL, 0x000000225353a232ULL, 0x000fe20000000000ULL,
0x0000004d007d7306ULL, 0x0007e20000200c00ULL, 0x00000018ff457819ULL, 0x004fe4000001143cULL,
0x00000018ff467819ULL, 0x000fc4000001143dULL, 0x00000018ff427819ULL, 0x000fe4000001143eULL,
0x00000018ff437819ULL, 0x000fe2000001143fULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x000001004e4d7824ULL, 0x008fe200078e00ffULL, 0x0000541065657816ULL, 0x002fc80000000067ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x00000064500c723cULL, 0x000f6e000000180cULL, 0x0000004c007c7306ULL, 0x0007e20000200c00ULL,
0x0000541058587816ULL, 0x004fce0000000066ULL, 0x0000004d007f7306ULL, 0x0005e20000200c00ULL,
0x000088804e4c7816ULL, 0x048fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x0000541059597816ULL, 0x002fc80000000068ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004c007e7306ULL, 0x0003e20000200c00ULL, 0x000001004f4d7824ULL, 0x044fe200078e00ffULL,
0x000000585008723cULL, 0x000be80000001808ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004e00807306ULL, 0x000fe20000200c00ULL, 0x000088804f4c7816ULL, 0x042fe200000000ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x000088803d597816ULL, 0x020fc800000000ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000004c00817306ULL, 0x0003f00000200c00ULL,
0x0000004d00827306ULL, 0x0005e20000200c00ULL, 0x000088803c4c7816ULL, 0x002fce00000000ffULL,
0x0000004c00647306ULL, 0x0003e20000200c00ULL, 0x000001003c4d7824ULL, 0x044fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001144dULL,
0x0000004f00637306ULL, 0x0005e20000200c00ULL, 0x00012800404c7811ULL, 0x002fe400078e20ffULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000004c4c783bULL, 0x004e6e0000000200ULL, 0x0000005f005f7306ULL, 0x000ff00000200c00ULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000005d005d7306ULL, 0x000ff00000200c00ULL,
0x0000005a005a7306ULL, 0x000eb00000200c00ULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x000000214c4ca232ULL, 0x002fc40000000000ULL, 0x000000214e4ea232ULL, 0x000fe40000000000ULL,
0x000000224d4da232ULL, 0x080fe40000000000ULL, 0x000000224f4fa232ULL, 0x000fe20000000000ULL,
0x0000005800657306ULL, 0x0003e20000200c00ULL, 0x000054105a5e7816ULL, 0x004fce000000005eULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000000ffff587224ULL, 0x002fe200078e0059ULL,
0x000054105b5f7816ULL, 0x008fe2000000005fULL, 0x000001003d597824ULL, 0x040fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000005e5010723cULL, 0x000fe20000001810ULL,
0x00000018ff3d7819ULL, 0x000fca000001143dULL, 0x0000006b006b7306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x00005410696a7816ULL, 0x002fce000000006aULL,
0x0000006d006d7306ULL, 0x000ff00000200c00ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x000054106b6b7816ULL, 0x004fce000000006cULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x0000006a5004723cULL, 0x000f6e0000001804ULL, 0x0000006000607306ULL, 0x000ee20000200c00ULL,
0x000054106d6e7816ULL, 0x002fce000000006eULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x000054106f6f7816ULL, 0x004fce0000000071ULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x0000541075607816ULL, 0x008fe20000000060ULL, 0x0000006e5054723cULL, 0x000fec0000001854ULL,
0x0000005800667306ULL, 0x0005e20000200c00ULL, 0x0000541078617816ULL, 0x002fce0000000061ULL,
0x0000005900677306ULL, 0x0003e20000200c00ULL, 0x0000541070587816ULL, 0x004fe4000000005cULL,
0x00005410735c7816ULL, 0x000fca0000000074ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x0000541072597816ULL, 0x002fe4000000005dULL, 0x00005410765d7816ULL, 0x000fca0000000077ULL,
0x000000585058723cULL, 0x040b620000001830ULL, 0x0000004b004b7306ULL, 0x000e6c0000200c00ULL,
0x000088803e307816ULL, 0x060fe200000000ffULL, 0x0000005c505c723cULL, 0x000b620000001834ULL,
0x000001003e317824ULL, 0x040fe200078e00ffULL, 0x0000004700477306ULL, 0x000ee20000200c00ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00005410624a7816ULL, 0x004fc4000000004aULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000541079347816ULL, 0x020fe2000000007aULL,
0x000000605050723cULL, 0x000b62000000182cULL, 0x000054107c357816ULL, 0x000fe2000000007bULL,
0x0000004900497306ULL, 0x000ea20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x000054107d4b7816ULL, 0x002fe4000000004bULL, 0x000088803f2c7816ULL, 0x020fe200000000ffULL,
0x000000344c34723cULL, 0x000b62000000180cULL, 0x00005410812d7816ULL, 0x000fe20000000082ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000541080807816ULL, 0x008fc80000000047ULL,
0x000001003f0d7824ULL, 0x060fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e002cULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000054107e2c7816ULL, 0x000fe4000000007fULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000541063817816ULL, 0x004fc80000000049ULL, 0x0000002c4c2c723cULL, 0x040b660000001804ULL,
0x0000004300437306ULL, 0x000fea0000200c00ULL, 0x000000804c10723cULL, 0x000f660000001810ULL,
0x0000003c003c7306ULL, 0x000e700000200c00ULL, 0x0000003d003d7306ULL, 0x000eb00000200c00ULL,
0x0000003000607306ULL, 0x000fe20000200c00ULL, 0x000054103c047816ULL, 0x022fce0000000045ULL,
0x0000003100617306ULL, 0x0002e20000200c00ULL, 0x000054103d057816ULL, 0x004fce0000000046ULL,
0x0000000c000e7306ULL, 0x0007e20000200c00ULL, 0x0000004a4c30723cULL, 0x042b6e0000001808ULL,
0x0000000d000d7306ULL, 0x000e620000200c00ULL, 0x0000541064087816ULL, 0x020fe20000000065ULL,
0x000000044c04723cULL, 0x000b620000001858ULL, 0x0000541066097816ULL, 0x000fc40000000067ULL,
0x00005410600c7816ULL, 0x008fc60000000061ULL, 0x0000003e003e7306ULL, 0x000ea40000200c00ULL,
0x000000084c08723cULL, 0x000b6c0000001854ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x000054100e0d7816ULL, 0x002fe4000000000dULL, 0x000054103e3e7816ULL, 0x004fca0000000042ULL,
0x0000000c4c0c723cULL, 0x000b62000000185cULL, 0x000054103f3f7816ULL, 0x008fce0000000043ULL,
0x0000003e4c3c723cULL, 0x000b620000001850ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff427f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000402a427810ULL, 0x002fe20007ffe0ffULL,
0x01869000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff497224ULL, 0x000fe200078e0043ULL,
0x000000011c1c7810ULL, 0x000fe40007ffe0ffULL, 0x000000144200720cULL, 0x000fda0003f06070ULL,
0x000085f000000947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x0186bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004642457210ULL, 0x000fca0007f1e1ffULL,
0x0000000147467824ULL, 0x000fe200000e0e43ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc80000011446ULL,
0x000000451c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e0646ULL,
0x000000021c1c7819ULL, 0x000fc80000001245ULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000602a1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000117437824ULL, 0x000fe200078e0223ULL, 0x0000000223477810ULL, 0x000fe40007ffe0ffULL,
0x0000001c14427217ULL, 0x000fe20007800000ULL, 0x0000000143457824ULL, 0x000fe200078e0203ULL,
0x00000004234a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010434f7824ULL, 0x020fe200078e00ffULL,
0x0000000623527810ULL, 0x000fe20007ffe0ffULL, 0x0000000142427824ULL, 0x000fe200078e0a1cULL,
0x00000020001c7811ULL, 0x000fe200078e38ffULL, 0x0000000117467824ULL, 0x000fe200078e024aULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee245ULL, 0x0000000117457824ULL, 0x040fe200078e0247ULL,
0x0000004217427217ULL, 0x040fe20007800000ULL, 0x00000001174b7824ULL, 0x000fe200078e0252ULL,
0x000000f01e4e7812ULL, 0x000fe200078ec0ffULL, 0x00000001434d7824ULL, 0x100fe200078e021cULL,
0x000160004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000001454c7824ULL, 0x000fc400078e021cULL,
0x0000000146497824ULL, 0x100fe200078e021cULL, 0x000000444d4d7210ULL, 0x080fe20007f1e0ffULL,
0x000000014b537824ULL, 0x000fe200078e021cULL, 0x000000444c4c7210ULL, 0x080fe20007f5e0ffULL,
0x0000000145437824ULL, 0x100fe200078e0203ULL, 0x0000004449497210ULL, 0x000fe20007f7e0ffULL,
0x0000001045507824ULL, 0x000fe400078e00ffULL, 0x000000014b1c7824ULL, 0x040fe400078e0203ULL,
0x000000104b547824ULL, 0x000fe200078e00ffULL, 0xfffffff050507812ULL, 0x000fe200078ee243ULL,
0x0000000146457824ULL, 0x000fc400078e0203ULL, 0x0000001046517824ULL, 0x000fe200078e00ffULL,
0xfffffff054547812ULL, 0x000fe200078ee21cULL, 0x000000ffff437224ULL, 0x000fe200000e06ffULL,
0x00005e004d467a11ULL, 0x000fe200078040ffULL, 0x00000001421c7824ULL, 0x000fe200078e0a17ULL,
0xfffffff051517812ULL, 0x000fe200078ee245ULL, 0x000000ffff427224ULL, 0x000fe200010e06ffULL,
0x00005e004c4b7a11ULL, 0x000fe400078440ffULL, 0x00005f004d4d7a11ULL, 0x000fe200000f4443ULL,
0x000000ffff437224ULL, 0x000fe200018e06ffULL, 0x0000001c4700720cULL, 0x000fc40003f06070ULL,
0x00005f004c4c7a11ULL, 0x000fe400010f4442ULL, 0x0000004453457210ULL, 0x000fe40007fde0ffULL,
0x00005e0049477a11ULL, 0x000fe400078a40ffULL, 0x0000001c2300720cULL, 0x000fe40003f46070ULL,
0x0000004e46427210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff467224ULL, 0x000fe200030e06ffULL,
0x0000001c4a00720cULL, 0x000fc40003f66070ULL, 0x00005f0049497a11ULL, 0x000fe200028f4443ULL,
0x000000ffff437224ULL, 0x000fe200020e064dULL, 0x00005e00454a7a11ULL, 0x040fe400078a40ffULL,
0x0000001c5200720cULL, 0x000fe40003f86070ULL, 0x00005f00451c7a11ULL, 0x000fe200028f4446ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000424f7faeULL, 0x0003e2000d101c46ULL,
0x0000004e4b467210ULL, 0x000fe40007fbe0ffULL, 0x0001600050507811ULL, 0x000fc400078e20ffULL,
0x0001600051517811ULL, 0x000fe400078e20ffULL, 0x0001600054547811ULL, 0x000fe400078e20ffULL,
0x0000004e47427210ULL, 0x082fe20007f5e0ffULL, 0x000000ffff477224ULL, 0x000fe200028e064cULL,
0x0000004e4a4a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff437224ULL, 0x000fe200010e0649ULL,
0x0000000046507faeULL, 0x0003e2000c101c46ULL, 0x000000ffff4b7224ULL, 0x000fc600028e061cULL,
0x0000000042517faeULL, 0x0003e8000d901c46ULL, 0x000000004a547faeULL, 0x0003e2000e101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x00000001171c7824ULL, 0x000fe200078e0223ULL,
0x0000002000437811ULL, 0x000fe400078e38ffULL, 0x000000f01e4e7812ULL, 0x020fe200078ec0ffULL,
0x000000011c457824ULL, 0x040fe200078e0203ULL, 0x000000021c467810ULL, 0x040fe20007ffe0ffULL,
0x000000101c4f7824ULL, 0x040fe200078e00ffULL, 0x000000041c497810ULL, 0x040fe20007ffe0ffULL,
0x000000011c427824ULL, 0x040fe200078e0243ULL, 0x000000061c4b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001431c7824ULL, 0x000fe200078e0246ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee245ULL,
0x0000000146477824ULL, 0x000fe200078e0203ULL, 0x0000004442457210ULL, 0x000fe20007f1e0ffULL,
0x0000001046507824ULL, 0x000fe200078e00ffULL, 0x000160004f4f7811ULL, 0x000fe200078e20ffULL,
0x0000000143427824ULL, 0x000fc400078e0249ULL, 0x00000001494a7824ULL, 0x040fe200078e0203ULL,
0xfffffff050507812ULL, 0x000fe200078ee247ULL, 0x0000001049517824ULL, 0x000fe200078e00ffULL,
0x0000004244427210ULL, 0x000fe20007f5e0ffULL, 0x000000014b497824ULL, 0x040fe200078e0203ULL,
0x0001600050507811ULL, 0x000fe200078e20ffULL, 0x000000104b527824ULL, 0x000fe200078e00ffULL,
0xfffffff051517812ULL, 0x000fe200078ee24aULL, 0x000000ffff467224ULL, 0x000fe200000e06ffULL,
0x00005e00454c7a11ULL, 0x000fe200078040ffULL, 0x0000000143437824ULL, 0x000fe200078e024bULL,
0xfffffff052527812ULL, 0x000fc400078ee249ULL, 0x00005f00454d7a11ULL, 0x000fe200000f4446ULL,
0x000000ffff457224ULL, 0x000fe200010e06ffULL, 0x0000001c44497210ULL, 0x040fe40007f1e0ffULL,
0x0000004344437210ULL, 0x000fe40007f7e0ffULL, 0x00005e0042467a11ULL, 0x000fe200078440ffULL,
0x000000ffff4b7224ULL, 0x000fe200000e06ffULL, 0x00005e0049477a11ULL, 0x000fe200078040ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00005e00434a7a11ULL, 0x000fc400078640ffULL,
0x0000004e4c4c7210ULL, 0x080fe40007f9e0ffULL, 0x00005f0049497a11ULL, 0x000fe400000f444bULL,
0x00005f0042457a11ULL, 0x000fe200010f4445ULL, 0x000000ffff4d7224ULL, 0x000fe200020e064dULL,
0x0000004e47427210ULL, 0x080fe40007f1e0ffULL, 0x00005f00431c7a11ULL, 0x000fe400018f441cULL,
0x0000004e46467210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0649ULL,
0x0000004e4a4a7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c4f7faeULL, 0x0003e2000b901c46ULL, 0x0001600051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200010e0645ULL, 0x0001600052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e061cULL, 0x0000000042507faeULL, 0x0003e8000b901c46ULL,
0x0000000046517faeULL, 0x0003e8000b901c46ULL, 0x000000004a527faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff467f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01864800174c7f8cULL, 0x0004e4000c80043fULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x01864c00171c7984ULL, 0x000f240000000800ULL, 0x800000001cff7812ULL, 0x018fc4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a42457210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e43ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc8000001144aULL,
0x000000451c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e064aULL,
0x000000021c1c7819ULL, 0x000fc80000001245ULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01864c00171c7984ULL, 0x000ee40000000800ULL,
0x800000001cff7812ULL, 0x008fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018100001f1c7984ULL, 0x000ee80000000800ULL, 0x018300001f4a7984ULL, 0x0004620000000800ULL,
0x000000481c00720bULL, 0x008fe20003f1d000ULL, 0x0000faa27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff4bff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4c7424ULL, 0x000fc400078e00ffULL,
0x000000ffff457224ULL, 0x000fd200078e0048ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000020200780cULL, 0x000fe40003f05270ULL, 0x000000481c00720bULL, 0x000fe20003f54000ULL,
0x0000fa727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000457806ULL, 0x000fc400010e0100ULL,
0x0000001c48428209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x018500421f008388ULL, 0x0005e40000000800ULL, 0x0000991045427816ULL, 0x004fc800000000ffULL,
0x000000ff4200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001c48427209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff45ff7812ULL, 0x000fc6000780c0ffULL, 0x8000004248427221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x00000042004d7308ULL, 0x000ea40000000800ULL,
0x0000004d19197220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff427819ULL, 0x000fe20000011603ULL, 0x0000f9c27f007947ULL, 0x000fea000b800000ULL,
0x00001f424d427589ULL, 0x0004e400000e0000ULL, 0x0000004234347220ULL, 0x088fe40000410000ULL,
0x0000004235357220ULL, 0x080fe40000410000ULL, 0x0000004230307220ULL, 0x080fe40000410000ULL,
0x0000004231317220ULL, 0x000fc40000410000ULL, 0x000000422c2c7220ULL, 0x080fe40000410000ULL,
0x000000422d2d7220ULL, 0x080fe40000410000ULL, 0x0000004210107220ULL, 0x080fe40000410000ULL,
0x0000004211117220ULL, 0x080fe40000410000ULL, 0x0000004208087220ULL, 0x080fe40000410000ULL,
0x0000004209097220ULL, 0x000fc40000410000ULL, 0x0000004204047220ULL, 0x080fe40000410000ULL,
0x0000004205057220ULL, 0x080fe40000410000ULL, 0x000000420c0c7220ULL, 0x080fe40000410000ULL,
0x000000420d0d7220ULL, 0x080fe40000410000ULL, 0x000000423c3c7220ULL, 0x080fe40000410000ULL,
0x000000423d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0045ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803427811ULL, 0x000fe200078ff0ffULL, 0x0000f8d27f007947ULL, 0x000fea000b800000ULL,
0x00001f424d427589ULL, 0x0006a400000e0000ULL, 0x0000004236367220ULL, 0x084fe40000410000ULL,
0x0000004237377220ULL, 0x080fe40000410000ULL, 0x0000004232327220ULL, 0x080fe40000410000ULL,
0x0000004233337220ULL, 0x080fe40000410000ULL, 0x000000422e2e7220ULL, 0x080fe40000410000ULL,
0x000000422f2f7220ULL, 0x000fc40000410000ULL, 0x0000004212127220ULL, 0x080fe40000410000ULL,
0x0000004213137220ULL, 0x080fe40000410000ULL, 0x000000420a0a7220ULL, 0x080fe40000410000ULL,
0x000000420b0b7220ULL, 0x080fe40000410000ULL, 0x0000004206067220ULL, 0x080fe40000410000ULL,
0x0000004207077220ULL, 0x000fc40000410000ULL, 0x000000420e0e7220ULL, 0x080fe40000410000ULL,
0x000000420f0f7220ULL, 0x080fe40000410000ULL, 0x000000423e3e7220ULL, 0x080fe40000410000ULL,
0x000000423f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff45ff7812ULL, 0x000fe2000780084bULL, 0x00000001ff4c7424ULL, 0x000fe200078e00ffULL,
0x0000001c48487209ULL, 0x000fca0007810000ULL, 0x000000ffff457224ULL, 0x000fcc00078e0048ULL,
0x800000481c1c0221ULL, 0x000fe20000010000ULL, 0x00007610ff4c0816ULL, 0x000fe2000000004cULL,
0x000000ffff450224ULL, 0x000fe400078e0048ULL, 0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL,
0x0000001c00200308ULL, 0x000f240000000800ULL, 0x000000204a4a0220ULL, 0x012fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000194a197221ULL, 0x002fc40000010000ULL,
0x0000000000427805ULL, 0x000fca0000015200ULL, 0x0186ac00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004842487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e43ULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011449ULL, 0x000000481c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x000000021c1c7819ULL, 0x000fc80000001248ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104c1c7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f45270ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000020ff1c723eULL, 0x000fe400000000ffULL,
0x00000002ff417819ULL, 0x000fe40000011603ULL, 0x000054101c1c7816ULL, 0x000fe2000000001cULL,
0x0000f4b27f007947ULL, 0x000fea000b800000ULL, 0x00001f411c217589ULL, 0x0002a400000e0000ULL,
0x0000000841227810ULL, 0x000fe20007ffe0ffULL, 0x0000f5027f007947ULL, 0x000fea000b800000ULL,
0x00001f221c227589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010414c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x00cfe200078e001cULL,
0x0000b0e000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x0000ff5000007944ULL, 0x002fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018414c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x00cfe200078e001cULL, 0x0000b15000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x0000fee000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000254c783bULL, 0x00cea80000004200ULL,
0x000000002650783bULL, 0x000fe80000004200ULL, 0x000000002454783bULL, 0x000ee80000004200ULL,
0x000000002748783bULL, 0x000f220000004200ULL, 0x00000018ff597819ULL, 0x004fe2000001144dULL,
0x000001004d6f7824ULL, 0x040fe200078e00ffULL, 0x000088804d6e7816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe2000001144cULL,
0x000001004c6d7824ULL, 0x040fe200078e00ffULL, 0x000088804c6c7816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000006e00707306ULL, 0x000fe20000200c00ULL, 0x00000018ff607819ULL, 0x000fe2000001144eULL,
0x0000010054637824ULL, 0x008fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000010055667824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe2000001144fULL,
0x0000010056697824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011450ULL,
0x0000004d00717306ULL, 0x0005e20000200c00ULL, 0x00008880517b7816ULL, 0x000fe200000000ffULL,
0x00000100576b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x002fc40000011454ULL,
0x00000018ff5f7819ULL, 0x000fe40000011451ULL, 0x0000888054627816ULL, 0x000fe200000000ffULL,
0x0000004c006e7306ULL, 0x0003e20000200c00ULL, 0x000001004e4d7824ULL, 0x004fe200078e00ffULL,
0x0000888055657816ULL, 0x000fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000001c00647306ULL, 0x0005e20000200c00ULL, 0x000088804e4c7816ULL, 0x042fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fc40000011466ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004d00737306ULL, 0x0003e20000200c00ULL, 0x00000018ff1c7819ULL, 0x004fe20000011455ULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x0000888056687816ULL, 0x000fe400000000ffULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000004c00727306ULL, 0x0005e20000200c00ULL, 0x000001004f4d7824ULL, 0x002fe200078e00ffULL,
0x00008880576a7816ULL, 0x000fc400000000ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004e00747306ULL, 0x000fe20000200c00ULL,
0x000088804f4c7816ULL, 0x044fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011452ULL, 0x00000018ff5d7819ULL, 0x000fe40000011453ULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000004c00757306ULL, 0x0003e20000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe20000011456ULL, 0x0001000056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011457ULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fc4000001146dULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000004d00767306ULL, 0x0005e20000200c00ULL, 0x00008880504c7816ULL, 0x042fe400000000ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff437819ULL, 0x010fe20000011449ULL, 0x0000004c00787306ULL, 0x0003e20000200c00ULL,
0x00000100504d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011448ULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc4000001144bULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004f00777306ULL, 0x000fe20000200c00ULL,
0x00013000284c7811ULL, 0x002fe400078e20ffULL, 0x00000018ff507819ULL, 0x000fca0000011450ULL,
0x0000004d00797306ULL, 0x0003f00000200c00ULL, 0x00000050007a7306ULL, 0x0005e20000200c00ULL,
0x000000004c4c783bULL, 0x002e6e0000000200ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000000ffff507224ULL, 0x004fc400078e007bULL, 0x00000100517b7824ULL, 0x040fe400078e00ffULL,
0x0001000051517824ULL, 0x000fc600078e00ffULL, 0x0000006300637306ULL, 0x000ea20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x00000018ff517819ULL, 0x000fca0000011451ULL,
0x00000051007d7306ULL, 0x0007f00000200c00ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000010052517824ULL, 0x008fe200078e00ffULL, 0x0000541062627816ULL, 0x004fc80000000063ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x000000214c4ca232ULL, 0x082fe40000000000ULL, 0x000000214e4ea232ULL, 0x000fe40000000000ULL,
0x000000224d4da232ULL, 0x080fe40000000000ULL, 0x000000224f4fa232ULL, 0x000fe20000000000ULL,
0x0000001c00677306ULL, 0x0003f00000200c00ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x0000541065637816ULL, 0x004fc40000000066ULL, 0x00000018ff1c7819ULL, 0x002fca000001144aULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x000000624c34723cULL, 0x000fee0000001834ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000541054547816ULL, 0x008fce0000000064ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000541055557816ULL, 0x002fce0000000067ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000000544c30723cULL, 0x000bee0000001830ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0001300029547811ULL, 0x020fe200078e20ffULL,
0x0000010048557824ULL, 0x000fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x00000051007f7306ULL, 0x0003f00000200c00ULL, 0x00000050007c7306ULL, 0x0005e20000200c00ULL,
0x0000010053517824ULL, 0x002fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000888052507816ULL, 0x044fe200000000ffULL,
0x0001000052527824ULL, 0x000fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x00000050007e7306ULL, 0x0002b00000200c00ULL, 0x0000005100827306ULL, 0x0007e20000200c00ULL,
0x0000888053507816ULL, 0x042fe200000000ffULL, 0x0001000053537824ULL, 0x000fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000005000817306ULL, 0x0003220000200c00ULL,
0x0000888048517816ULL, 0x048fe200000000ffULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x000054107e7e7816ULL, 0x004fc8000000007fULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000005100637306ULL, 0x0005e20000200c00ULL, 0x0000541068507816ULL, 0x002fce0000000069ULL,
0x0000005200807306ULL, 0x000fe20000200c00ULL, 0x000054106a517816ULL, 0x004fe4000000006bULL,
0x00005410817f7816ULL, 0x010fca0000000082ULL, 0x0000005300627306ULL, 0x0003f00000200c00ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000000504c50723cULL, 0x002b64000000182cULL,
0x00000000542c783bULL, 0x0202aa0000000200ULL, 0x0000005500647306ULL, 0x0007220000200c00ULL,
0x0000888049547816ULL, 0x002fce00000000ffULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000010049557824ULL, 0x048fe400078e00ffULL, 0x0001000049497824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000541063647816ULL, 0x010fca0000000064ULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000005700577306ULL, 0x000ee20000200c00ULL,
0x000000212c2ca232ULL, 0x084fe40000000000ULL, 0x000000212e2ea232ULL, 0x000fc40000000000ULL,
0x000000222d2da232ULL, 0x000fc60000000000ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00005410565a7816ULL, 0x002fe2000000005aULL, 0x000000222f2fa232ULL, 0x000fcc0000000000ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x00005410575b7816ULL, 0x008fe2000000005bULL,
0x0000007e2c50723cULL, 0x000fec0000001850ULL, 0x0000006000607306ULL, 0x000ea40000200c00ULL,
0x0000005a4c10723cULL, 0x000fec0000001810ULL, 0x0000006100617306ULL, 0x000ee20000200c00ULL,
0x000054106c6c7816ULL, 0x002fce000000006dULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000541074607816ULL, 0x004fce0000000060ULL, 0x0000005400657306ULL, 0x0005e20000200c00ULL,
0x0000541077617816ULL, 0x008fce0000000061ULL, 0x0000005500667306ULL, 0x0007220000200c00ULL,
0x000054106e547816ULL, 0x004fe20000000058ULL, 0x000000604c3c723cULL, 0x000fe2000000183cULL,
0x0000541072587816ULL, 0x000fe40000000073ULL, 0x00005410706d7816ULL, 0x002fc6000000006fULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541071557816ULL, 0x008fe40000000059ULL,
0x0000541075597816ULL, 0x000fe20000000076ULL, 0x0000006c4c08723cULL, 0x000f680000001808ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x0000541065657816ULL, 0x010fc60000000066ULL,
0x000000544c54723cULL, 0x040b680000001804ULL, 0x0000005f005f7306ULL, 0x000ea60000200c00ULL,
0x000001004a057824ULL, 0x060fe200078e00ffULL, 0x000088804a047816ULL, 0x040fe200000000ffULL,
0x000000584c58723cULL, 0x000b62000000180cULL, 0x000100004a4a7824ULL, 0x000fc400078e00ffULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x00000049000d7306ULL, 0x020fe20000200c00ULL,
0x000054107a5e7816ULL, 0x002fe4000000005eULL, 0x000088804b0c7816ULL, 0x040fe200000000ffULL,
0x000001004b0e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x000054107d5f7816ULL, 0x004fe2000000005fULL,
0x0000000400497306ULL, 0x0003e20000200c00ULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x000000642c08723cULL, 0x000f620000001808ULL, 0x00000018ff4b7819ULL, 0x000fca000001144bULL,
0x00000005004c7306ULL, 0x0004e20000200c00ULL, 0x0000541078047816ULL, 0x002fe20000000079ULL,
0x0000005e2c30723cULL, 0x000f6c0000001830ULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x000054107c057816ULL, 0x004fce000000007bULL, 0x000000042c04723cULL, 0x000b620000001834ULL,
0x0000005d005d7306ULL, 0x000eac0000200c00ULL, 0x0000541049347816ULL, 0x028fe4000000004cULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x00005410805c7816ULL, 0x002fce000000005cULL,
0x0000004300437306ULL, 0x000e620000200c00ULL, 0x00005410625d7816ULL, 0x004fce000000005dULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x0000005c2c10723cULL, 0x000b6e0000001810ULL,
0x0000000c00357306ULL, 0x0005e20000200c00ULL, 0x000054100d0d7816ULL, 0x002fce0000000043ULL,
0x0000000e00367306ULL, 0x0002e20000200c00ULL, 0x00005410480c7816ULL, 0x004fce0000000042ULL,
0x0000001c001c7306ULL, 0x000fe20000200c00ULL, 0x0000000c2c0c723cULL, 0x002b6e0000001854ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x0000541035357816ULL, 0x008fce0000000036ULL,
0x0000004a004a7306ULL, 0x000e620000200c00ULL, 0x000000342c34723cULL, 0x000b6e0000001858ULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x000054104a4a7816ULL, 0x002fe4000000001cULL,
0x000054104b4b7816ULL, 0x004fce0000000041ULL, 0x0000004a2c2c723cULL, 0x000b62000000183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff427f8cULL, 0x000e62000c80043fULL,
0x000000ffff417224ULL, 0x000fce00078e00ffULL, 0x00000000003c7805ULL, 0x020fc40000015200ULL,
0x0186bc00ff1c7984ULL, 0x000ea40000000800ULL, 0x800000001cff7812ULL, 0x006fe40007804843ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc8000001143fULL, 0x0000003e1c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x000000021c1c7819ULL, 0x000fc8000000123eULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x00000001173d7824ULL, 0x000fe200078e0223ULL, 0x000000802a3c7810ULL, 0x000fe40007ffe0ffULL,
0x0000004000497811ULL, 0x000fe200078e38ffULL, 0x000000013d1c7824ULL, 0x000fe200078e0203ULL,
0x00000002233e7810ULL, 0x000fe20007ffe0ffULL, 0x000000103d4b7824ULL, 0x000fe200078e00ffULL,
0x00000004234d7810ULL, 0x000fe20007ffe0ffULL, 0x000000013d427824ULL, 0x000fe200078e0249ULL,
0x000000f01e4a7812ULL, 0x000fe200078ec0ffULL, 0x00000001173f7824ULL, 0x000fe200078e023eULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee21cULL, 0x0000000117437824ULL, 0x000fe200078e024dULL,
0x0000003c141c7217ULL, 0x000fe20007800000ULL, 0x000000013f417824ULL, 0x040fe200078e0203ULL,
0x0000004442427210ULL, 0x000fe20007f1e0ffULL, 0x000000103f4c7824ULL, 0x000fe200078e00ffULL,
0x00000006234f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e0a3cULL,
0x000140004b4b7811ULL, 0x000fe200078e20ffULL, 0x000000013f487824ULL, 0x000fe200078e0249ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee241ULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x0000001c171c7217ULL, 0x000fe20007800000ULL, 0x0000000143417824ULL, 0x040fe200078e0203ULL,
0x00005e00423d7a11ULL, 0x000fe200078040ffULL, 0x00000010434e7824ULL, 0x040fe200078e00ffULL,
0x0000004448487210ULL, 0x000fe20007f7e0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e0a17ULL,
0x00005f0042427a11ULL, 0x000fe200000f443cULL, 0x0000000143437824ULL, 0x000fe200078e0249ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee241ULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x00005e0048417a11ULL, 0x000fe200078640ffULL, 0x0000000117547824ULL, 0x000fe200078e024fULL,
0x0000001c2300720cULL, 0x000fc40003f86070ULL, 0x00005f0048487a11ULL, 0x000fe200018f443cULL,
0x0000000154497824ULL, 0x000fe200078e0249ULL, 0x0000004443437210ULL, 0x000fe40007fbe0ffULL,
0x0000004a3d3c7210ULL, 0x000fe40007f7e0ffULL, 0x0000001c3e00720cULL, 0x080fe20003f06070ULL,
0x000000ffff3f7224ULL, 0x000fe200028e06ffULL, 0x00005e00433e7a11ULL, 0x000fe200078a40ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e0642ULL, 0x0000001c4d00720cULL, 0x000fc40003f66070ULL,
0x00005f0043437a11ULL, 0x000fe400028f443fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c4b7faeULL, 0x0003e2000e101c46ULL, 0x00000044493f7210ULL, 0x000fe20007f9e0ffULL,
0x0000000154497824ULL, 0x000fe200078e0203ULL, 0x0000004a3e3e7210ULL, 0x000fe20007fde0ffULL,
0x0000001054547824ULL, 0x000fe200078e00ffULL, 0x000140004c4c7811ULL, 0x000fe400078e20ffULL,
0x000140004e4e7811ULL, 0x000fe400078e20ffULL, 0xfffffff054497812ULL, 0x000fc400078ee249ULL,
0x0000004a413c7210ULL, 0x002fe20007fbe0ffULL, 0x000000ffff417224ULL, 0x000fe200020e06ffULL,
0x00005e003f427a11ULL, 0x000fe400078840ffULL, 0x0001400049497811ULL, 0x000fe200078e20ffULL,
0x000000ffff3d7224ULL, 0x000fe200028e0648ULL, 0x0000001c4f00720cULL, 0x000fe40003fa6070ULL,
0x00005f003f1c7a11ULL, 0x000fe200020f4441ULL, 0x000000ffff3f7224ULL, 0x000fe200030e0643ULL,
0x0000004a42427210ULL, 0x000fe20007f9e0ffULL, 0x000000003c4c7faeULL, 0x0003e8000c101c46ULL,
0x000000ffff437224ULL, 0x000fe200020e061cULL, 0x000000003e4e7faeULL, 0x0003e8000d901c46ULL,
0x0000000042497faeULL, 0x0003e2000e901c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x00000040003c7811ULL, 0x000fe200078e38ffULL, 0x00000001171c7824ULL, 0x000fe200078e0223ULL,
0x000000f01e4b7812ULL, 0x000fc600078ec0ffULL, 0x000000011c3e7824ULL, 0x140fe200078e0203ULL,
0x000000021c3f7810ULL, 0x040fe20007ffe0ffULL, 0x000000101c4c7824ULL, 0x040fe200078e00ffULL,
0x000000041c417810ULL, 0x040fe20007ffe0ffULL, 0x000000011c3d7824ULL, 0x140fe200078e023cULL,
0x000000061c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000013f437824ULL, 0x040fe200078e023cULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee23eULL, 0x000000013f3e7824ULL, 0x000fe200078e0203ULL,
0x000000443d3d7210ULL, 0x000fe20007f1e0ffULL, 0x000000103f4d7824ULL, 0x000fe200078e00ffULL,
0x000140004c4c7811ULL, 0x000fe200078e20ffULL, 0x00000001413f7824ULL, 0x000fc400078e023cULL,
0x000000011c427824ULL, 0x040fe200078e023cULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee23eULL,
0x00000001413c7824ULL, 0x100fe200078e0203ULL, 0x000000443f3f7210ULL, 0x000fe20007f7e0ffULL,
0x00000010414e7824ULL, 0x000fe200078e00ffULL, 0x000140004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000011c417824ULL, 0x040fe400078e0203ULL, 0x000000101c4f7824ULL, 0x000fe200078e00ffULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee23cULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005e003d487a11ULL, 0x000fc400078040ffULL, 0xfffffff04f4f7812ULL, 0x000fe400078ee241ULL,
0x00005f003d4a7a11ULL, 0x000fe200000f441cULL, 0x000000ffff3d7224ULL, 0x000fe200018e06ffULL,
0x0000004443437210ULL, 0x080fe40007f1e0ffULL, 0x00000044421c7210ULL, 0x000fe40007f9e0ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff497224ULL, 0x000fe200000e06ffULL,
0x00005e0043417a11ULL, 0x000fe200078040ffULL, 0x000000ffff3c7224ULL, 0x000fe200020e06ffULL,
0x00005e001c427a11ULL, 0x000fc400078840ffULL, 0x0000004b48487210ULL, 0x080fe40007fbe0ffULL,
0x00005f0043437a11ULL, 0x000fe400000f4449ULL, 0x00005f001c1c7a11ULL, 0x000fe200020f443cULL,
0x000000ffff497224ULL, 0x000fe200028e064aULL, 0x00005f003f3f7a11ULL, 0x000fe400018f443dULL,
0x0000004b413c7210ULL, 0x080fe40007f1e0ffULL, 0x0000004b3e3e7210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000484c7faeULL, 0x0003e2000b901c46ULL,
0x0000004b42427210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0643ULL,
0x000140004e4e7811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e063fULL,
0x000140004f4f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200020e061cULL,
0x000000003c4d7faeULL, 0x0003e8000b901c46ULL, 0x000000003e4e7faeULL, 0x0003e8000b901c46ULL,
0x00000000424f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff3c7f8cULL, 0x002e64000c80043fULL,
0x000000ffff417224ULL, 0x002fc400078e003dULL, 0x00000000003c7805ULL, 0x000fca0000015200ULL,
0x0186b400ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fc40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc8000001143fULL,
0x0000003e1c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x000000021c1c7819ULL, 0x000fc8000000123eULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x00000020ff1c723eULL, 0x000fe400000000ffULL, 0x00000002ff3c7819ULL, 0x000fe40000011603ULL,
0x000054101c1c7816ULL, 0x000fe2000000001cULL, 0x0000d8a27f007947ULL, 0x000fea000b800000ULL,
0x00001f3c1c217589ULL, 0x0002a400000e0000ULL, 0x000000083c227810ULL, 0x000fe20007ffe0ffULL,
0x0000d8f27f007947ULL, 0x000fea000b800000ULL, 0x00001f221c227589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000103c4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e001cULL, 0x0000cdf000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x0000e24000007944ULL, 0x00efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000183c4c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e001cULL,
0x0000ce6000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x004fc400078e00ffULL, 0x0000e1d000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000130003b617811ULL, 0x000fc400078e20ffULL, 0x000000003a4c783bULL, 0x000f280000004200ULL,
0x000000002b48783bULL, 0x004fe80000004200ULL, 0x000000003954783bULL, 0x000ea80000004200ULL,
0x00000000383c783bULL, 0x002e620000004200ULL, 0x00000018ff5d7819ULL, 0x010fe2000001144dULL,
0x000001004d6f7824ULL, 0x040fe200078e00ffULL, 0x000088804d6e7816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001144cULL,
0x000001004c6d7824ULL, 0x040fe200078e00ffULL, 0x000088804c6c7816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000006e00707306ULL, 0x000fe20000200c00ULL, 0x00000018ff5b7819ULL, 0x000fe2000001144eULL,
0x0000010054637824ULL, 0x004fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000010055667824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001144fULL,
0x00000100576b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011448ULL,
0x0000004d00717306ULL, 0x0005e20000200c00ULL, 0x00008880497a7816ULL, 0x000fe200000000ffULL,
0x0000010056697824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x008fc40000011454ULL,
0x0000888054627816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000004c006e7306ULL, 0x0007e20000200c00ULL,
0x000001004e4d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011449ULL,
0x0000888055657816ULL, 0x000fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000001c00647306ULL, 0x0005e20000200c00ULL, 0x000088804e4c7816ULL, 0x048fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fc40000011466ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004d00737306ULL, 0x0007e20000200c00ULL, 0x00000018ff1c7819ULL, 0x004fe20000011455ULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe4000001144aULL,
0x00000018ff587819ULL, 0x000fe4000001144bULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000004c00727306ULL, 0x0005e20000200c00ULL, 0x000001004f4d7824ULL, 0x008fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc40000011457ULL, 0x00008880576a7816ULL, 0x040fe200000000ffULL,
0x0001000057577824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004e00747306ULL, 0x000fe20000200c00ULL, 0x000088804f4c7816ULL, 0x044fe200000000ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011456ULL,
0x0000888056687816ULL, 0x040fe200000000ffULL, 0x0001000056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000004d00767306ULL, 0x0005e20000200c00ULL,
0x00000018ff577819ULL, 0x000fc40000011457ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000004c00757306ULL, 0x0007e20000200c00ULL, 0x00000100484d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x0000004f00777306ULL, 0x000fe20000200c00ULL,
0x00008880484c7816ULL, 0x048fe200000000ffULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x002fe4000001143cULL, 0x00000018ff467819ULL, 0x000fe4000001143dULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000004c00787306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fce000001143fULL, 0x0000004d00797306ULL, 0x0003f00000200c00ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x00000000614c783bULL, 0x0022ae0000000200ULL,
0x0000006300637306ULL, 0x000ef00000200c00ULL, 0x0000004800617306ULL, 0x0023f00000200c00ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000000ffff487224ULL, 0x002fe200078e007aULL,
0x0000541062627816ULL, 0x008fe20000000063ULL, 0x00000100497a7824ULL, 0x000fc400078e00ffULL,
0x0001000049497824ULL, 0x000fc600078e00ffULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x00000018ff497819ULL, 0x000fca0000011449ULL,
0x00000049007c7306ULL, 0x0007e20000200c00ULL, 0x000000214c4ca232ULL, 0x084fe40000000000ULL,
0x000000214e4ea232ULL, 0x000fe40000000000ULL, 0x000000224d4da232ULL, 0x080fe40000000000ULL,
0x000000224f4fa232ULL, 0x000fe20000000000ULL, 0x0000001c00677306ULL, 0x0005e20000200c00ULL,
0x000001004a497824ULL, 0x008fe200078e00ffULL, 0x0000541065637816ULL, 0x002fc80000000066ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000000624c04723cULL, 0x000fe20000001804ULL, 0x00000018ff1c7819ULL, 0x004fcc000001143eULL,
0x0000005500557306ULL, 0x000eb00000200c00ULL, 0x00000048007b7306ULL, 0x0007e20000200c00ULL,
0x0000541054547816ULL, 0x002fce0000000064ULL, 0x00000049007e7306ULL, 0x0003e20000200c00ULL,
0x000088804a487816ULL, 0x048fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x0000541055557816ULL, 0x004fc80000000067ULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x00000048007d7306ULL, 0x0005e20000200c00ULL, 0x000001004b497824ULL, 0x042fe200078e00ffULL,
0x000000544c30723cULL, 0x000be80000001830ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000004a007f7306ULL, 0x000fe20000200c00ULL, 0x000088804b487816ULL, 0x044fe200000000ffULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x000088803d557816ULL, 0x020fc800000000ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000004800807306ULL, 0x0003f00000200c00ULL,
0x0000004900817306ULL, 0x0005e20000200c00ULL, 0x000088803c487816ULL, 0x002fce00000000ffULL,
0x0000004800637306ULL, 0x0003e20000200c00ULL, 0x000001003c497824ULL, 0x044fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011449ULL,
0x0000004b00627306ULL, 0x0005e20000200c00ULL, 0x0001300040487811ULL, 0x002fe400078e20ffULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000000004848783bULL, 0x004e6e0000000200ULL, 0x0000005700577306ULL, 0x000eb00000200c00ULL,
0x0000005f005f7306ULL, 0x000ff00000200c00ULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x0000541057577816ULL, 0x004fce0000000060ULL, 0x0000005400647306ULL, 0x0005300000200c00ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000ffff547224ULL, 0x004fe200078e0055ULL,
0x0000541056567816ULL, 0x008fe2000000005fULL, 0x000001003d557824ULL, 0x040fe200078e00ffULL,
0x000000214848a232ULL, 0x082fe20000000000ULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x000000214a4aa232ULL, 0x000fc40000000000ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x000000564c10723cULL, 0x000fe20000001810ULL,
0x000000224949a232ULL, 0x080fe20000000000ULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000000224b4ba232ULL, 0x000fe20000000000ULL, 0x0000541063647816ULL, 0x010fe40000000064ULL,
0x0000006c006c7306ULL, 0x000ff00000200c00ULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x0000541068687816ULL, 0x002fce0000000069ULL, 0x0000005e005e7306ULL, 0x000e700000200c00ULL,
0x0000005d005d7306ULL, 0x000ee20000200c00ULL, 0x000054106c6c7816ULL, 0x004fce000000006dULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054106e5e7816ULL, 0x002fce000000005eULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x00005410715f7816ULL, 0x008fce000000005dULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000005e4c0c723cULL, 0x000fee000000180cULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x000054106a697816ULL, 0x002fce000000006bULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x00005410706d7816ULL, 0x004fe2000000006fULL,
0x000000684c50723cULL, 0x040fec0000001850ULL, 0x0000005400657306ULL, 0x0005e20000200c00ULL,
0x0000541074747816ULL, 0x008fe2000000005bULL, 0x0000006c4c08723cULL, 0x000f6c0000001808ULL,
0x0000005500607306ULL, 0x0007220000200c00ULL, 0x0000541072547816ULL, 0x004fce0000000073ULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x0000541075557816ULL, 0x008fe40000000076ULL,
0x0000541077757816ULL, 0x002fca000000005cULL, 0x000000544c54723cULL, 0x000b620000001834ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x010fca0000000060ULL,
0x000001003e357824ULL, 0x060fe200078e00ffULL, 0x000088803e347816ULL, 0x040fe200000000ffULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x000000744c4c723cULL, 0x000b62000000182cULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x00000034005b7306ULL, 0x0007e20000200c00ULL,
0x000088803f2c7816ULL, 0x020fe200000000ffULL, 0x000000644808723cULL, 0x000f620000001808ULL,
0x00005410802d7816ULL, 0x000fca0000000081ULL, 0x00000035005c7306ULL, 0x0005e20000200c00ULL,
0x0000541078347816ULL, 0x008fce0000000079ULL, 0x0000004700477306ULL, 0x000ee20000200c00ULL,
0x000054107b357816ULL, 0x004fce000000007aULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x000000344834723cULL, 0x000b6e0000001804ULL, 0x000000ffff047224ULL, 0x020fe200078e002cULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x000001003f067824ULL, 0x040fe200078e00ffULL,
0x000054107c057816ULL, 0x002fe2000000005aULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000054107d2c7816ULL, 0x000fc4000000007eULL, 0x00000018ff067819ULL, 0x000fe40000011406ULL,
0x00000004005d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000002c482c723cULL, 0x000f6a0000001850ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x0000541061047816ULL, 0x002fce0000000059ULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x000000044830723cULL, 0x000b6e0000001830ULL, 0x0000003d003d7306ULL, 0x000f220000200c00ULL,
0x000054107f047816ULL, 0x028fe40000000047ULL, 0x0000541062057816ULL, 0x004fca0000000058ULL,
0x0000001c001c7306ULL, 0x000fe40000200c00ULL, 0x000000044810723cULL, 0x000b6c0000001810ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000054103c047816ULL, 0x022fe40000000043ULL,
0x000054103d057816ULL, 0x010fca0000000046ULL, 0x0000000600597306ULL, 0x0002b00000200c00ULL,
0x0000003e003e7306ULL, 0x000ee20000200c00ULL, 0x000000044804723cULL, 0x002b6e000000180cULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000054105b0c7816ULL, 0x020fc4000000005cULL,
0x000054105d0d7816ULL, 0x004fe40000000059ULL, 0x000054103e3e7816ULL, 0x008fca000000001cULL,
0x0000000c480c723cULL, 0x000b620000001854ULL, 0x000054103f3f7816ULL, 0x002fce0000000042ULL,
0x0000003e483c723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff427f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000802a1c7810ULL, 0x000fe20007ffe0ffULL,
0x01869800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff497224ULL, 0x022fe400078e0043ULL,
0x000000141c00720cULL, 0x000fe20003f06070ULL, 0x000000ffff487224ULL, 0x000fe200078e0045ULL,
0x000000011d1c7810ULL, 0x000fd60007ffe0ffULL, 0x0000432000000947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x0186bc00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x00000046421c7210ULL, 0x000fca0007f1e1ffULL, 0x0000000147467824ULL, 0x000fe200000e0e43ULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff4600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff4600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011446ULL, 0x0000001c18187211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e0646ULL, 0x0000000218187819ULL, 0x000fc8000000121cULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000a02a187810ULL, 0x000fe20007ffe0ffULL, 0x0000000117427824ULL, 0x000fe200078e0223ULL,
0x0000000223467810ULL, 0x040fe40007ffe0ffULL, 0x00000018141c7217ULL, 0x000fe20007800000ULL,
0x0000000142437824ULL, 0x000fe200078e0203ULL, 0x0000000423487810ULL, 0x000fe20007ffe0ffULL,
0x0000000117477824ULL, 0x000fe200078e0246ULL, 0x0000000623517810ULL, 0x000fe20007ffe0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e0a18ULL, 0x0000006000187811ULL, 0x000fe200078e38ffULL,
0x00000010424e7824ULL, 0x000fe200078e00ffULL, 0x000000f01e4d7812ULL, 0x000fe200078ec0ffULL,
0x0000000117497824ULL, 0x040fe200078e0248ULL, 0x0000001c171c7217ULL, 0x000fe20007800000ULL,
0x00000001474b7824ULL, 0x040fe200078e0218ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee243ULL,
0x0000000147437824ULL, 0x000fc400078e0203ULL, 0x00000010474f7824ULL, 0x000fe200078e00ffULL,
0x000000444b4b7210ULL, 0x080fe20007f3e0ffULL, 0x00000001424c7824ULL, 0x100fe200078e0218ULL,
0x000160004e4e7811ULL, 0x000fe200078e20ffULL, 0x0000000117427824ULL, 0x000fe200078e0251ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee243ULL, 0x00000001494a7824ULL, 0x040fe200078e0203ULL,
0x000000444c4c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001049507824ULL, 0x000fe200078e00ffULL,
0x000160004f4f7811ULL, 0x000fe200078e20ffULL, 0x0000000149477824ULL, 0x000fc400078e0218ULL,
0x0000000142187824ULL, 0x000fe200078e0218ULL, 0xfffffff050507812ULL, 0x000fe200078ee24aULL,
0x0000000142437824ULL, 0x040fe200078e0203ULL, 0x00005e004b4a7a11ULL, 0x000fe200078440ffULL,
0x0000001042527824ULL, 0x000fe200078e00ffULL, 0x0000004447477210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff427224ULL, 0x000fe200008e06ffULL, 0x0000004418187210ULL, 0x000fe20007f7e0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e0a17ULL, 0xfffffff052527812ULL, 0x000fe200078ee243ULL,
0x000000ffff447224ULL, 0x000fe200000e06ffULL, 0x00005e004c437a11ULL, 0x000fe200078040ffULL,
0x000000ffff497224ULL, 0x000fe200020e06ffULL, 0x00005f004b4b7a11ULL, 0x000fc400010f4442ULL,
0x0000001c2300720cULL, 0x080fe40003f46070ULL, 0x00005f004c4c7a11ULL, 0x000fe200000f4444ULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x0000004d43427210ULL, 0x000fe40007fbe0ffULL,
0x0000001c4600720cULL, 0x080fe40003f26070ULL, 0x00005e0047467a11ULL, 0x000fe200078840ffULL,
0x000000ffff437224ULL, 0x000fe200028e064cULL, 0x0000001c4800720cULL, 0x000fc40003f06070ULL,
0x00005e0018487a11ULL, 0x000fe400078c40ffULL, 0x0000001c5100720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000424e7faeULL, 0x0003e2000d101c46ULL,
0x00005f00471c7a11ULL, 0x000fe400020f4449ULL, 0x0000004d46467210ULL, 0x080fe40007f9e0ffULL,
0x00005f0018187a11ULL, 0x000fe400030f4444ULL, 0x0000004d48487210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff477224ULL, 0x000fe200020e061cULL, 0x0001600050507811ULL, 0x000fc400078e20ffULL,
0x0001600052527811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200028e0618ULL,
0x0000004d4a427210ULL, 0x002fca0007f5e0ffULL, 0x000000ffff437224ULL, 0x000fca00010e064bULL,
0x00000000424f7faeULL, 0x0003e8000c901c46ULL, 0x0000000046507faeULL, 0x0003e8000c101c46ULL,
0x0000000048527faeULL, 0x0003e2000d901c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000117187824ULL, 0x000fe200078e0223ULL, 0x00000060001c7811ULL, 0x000fc400078e38ffULL,
0x000000f01e4c7812ULL, 0x000fe200078ec0ffULL, 0x0000000118427824ULL, 0x040fe200078e0203ULL,
0x0000000218467810ULL, 0x040fe20007ffe0ffULL, 0x00000010184d7824ULL, 0x040fe200078e00ffULL,
0x0000000418487810ULL, 0x000fc60007ffe0ffULL, 0x0000000146437824ULL, 0x040fe200078e0203ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL, 0x00000010464e7824ULL, 0x000fe400078e00ffULL,
0x0000000118427824ULL, 0x140fe200078e021cULL, 0x0000000618187810ULL, 0x000fe20007ffe0ffULL,
0x0000000146477824ULL, 0x100fe200078e021cULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee243ULL,
0x0000000148467824ULL, 0x100fe200078e0203ULL, 0x0000004442437210ULL, 0x080fe20007f5e0ffULL,
0x0000000148427824ULL, 0x100fe200078e021cULL, 0x0000004447477210ULL, 0x080fe20007f1e0ffULL,
0x0000000118497824ULL, 0x000fe200078e021cULL, 0x00005e00434a7a11ULL, 0x000fe200078640ffULL,
0x00000010484f7824ULL, 0x000fe200078e00ffULL, 0x0000004442427210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000118487824ULL, 0x040fe200078e0203ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL,
0x0000001018507824ULL, 0x000fe200078e00ffULL, 0x0000004449187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005f00434b7a11ULL, 0x000fe200018f441cULL,
0x000000ffff447224ULL, 0x000fe200008e06ffULL, 0x00005e0047437a11ULL, 0x000fe200078040ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x00005e0042467a11ULL, 0x000fc400078240ffULL,
0xfffffff050507812ULL, 0x000fe400078ee248ULL, 0x00005e0018487a11ULL, 0x000fe400078440ffULL,
0x0000004c4a4a7210ULL, 0x080fe40007f7e0ffULL, 0x00005f0047477a11ULL, 0x000fe400000f4449ULL,
0x00005f0042447a11ULL, 0x000fe200008f4444ULL, 0x000000ffff4b7224ULL, 0x000fe200018e064bULL,
0x0000004c43427210ULL, 0x000fc40007f1e0ffULL, 0x00005f0018187a11ULL, 0x000fe400010f441cULL,
0x0000004c46467210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0647ULL,
0x0000004c48487210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004a4d7faeULL, 0x0003e2000b901c46ULL, 0x000160004e4e7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200008e0644ULL, 0x000160004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200010e0618ULL, 0x0001600050507811ULL, 0x000fe200078e20ffULL,
0x00000000424e7faeULL, 0x0003e8000b901c46ULL, 0x00000000464f7faeULL, 0x0003e8000b901c46ULL,
0x0000000048507faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000021d427810ULL, 0x002fc80007ffe0ffULL, 0x000000154200720cULL, 0x000fe20003f06070ULL,
0xffffffffff187424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000011a427824ULL, 0x000fe400078e0242ULL, 0x00000004ff437424ULL, 0x000fc800078e00ffULL,
0x0000600042427625ULL, 0x000fca00078e0043ULL, 0x0000000642187981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff467f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01866800174a7f8cULL, 0x000664000c80043fULL,
0x0000000000427805ULL, 0x002fc40000015200ULL, 0x01866c00171c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004842447210ULL, 0x000fca0007f1e1ffULL, 0x0000000149487824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011448ULL, 0x000000441c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0648ULL, 0x000000021c1c7819ULL, 0x000fc80000001244ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01866c00171c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018180001f1c7984ULL, 0x000e680000000800ULL,
0x018380001f447984ULL, 0x0006a20000000800ULL, 0x000000451c00720bULL, 0x002fe20003f1d000ULL,
0x0000baf27f007947ULL, 0x000fd8000b800000ULL, 0x00000000004a7806ULL, 0x008fc800000e0100ULL,
0x0000ffff4aff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff497424ULL, 0x000fc400078e00ffULL, 0x000000ffff487224ULL, 0x000fd200078e0045ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x000fe40003f05270ULL,
0x000000451c00720bULL, 0x000fe20003f34000ULL, 0x0000bac27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000487806ULL, 0x000fc400008e0100ULL, 0x000000451c428209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x018580421f008388ULL, 0x0003e40000000800ULL,
0x00009910481f7816ULL, 0x002fc800000000ffULL, 0x000000ff1f00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000451c1f7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff48ff7812ULL, 0x000fc6000780c0ffULL,
0x000000451f1f7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL,
0x0000001f004d7308ULL, 0x000e640000000800ULL, 0x0000004d19197220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe20000011603ULL,
0x0000ba127f007947ULL, 0x000fea000b800000ULL, 0x00001f1f4d1f7589ULL, 0x0002e400000e0000ULL,
0x0000001f34347220ULL, 0x088fe40000410000ULL, 0x0000001f35357220ULL, 0x080fe40000410000ULL,
0x0000001f30307220ULL, 0x080fe40000410000ULL, 0x0000001f31317220ULL, 0x000fc40000410000ULL,
0x0000001f2c2c7220ULL, 0x080fe40000410000ULL, 0x0000001f2d2d7220ULL, 0x080fe40000410000ULL,
0x0000001f10107220ULL, 0x080fe40000410000ULL, 0x0000001f11117220ULL, 0x080fe40000410000ULL,
0x0000001f08087220ULL, 0x080fe40000410000ULL, 0x0000001f09097220ULL, 0x000fc40000410000ULL,
0x0000001f04047220ULL, 0x080fe40000410000ULL, 0x0000001f05057220ULL, 0x080fe40000410000ULL,
0x0000001f0c0c7220ULL, 0x080fe40000410000ULL, 0x0000001f0d0d7220ULL, 0x080fe40000410000ULL,
0x0000001f3c3c7220ULL, 0x080fe40000410000ULL, 0x0000001f3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0048ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008031f7811ULL, 0x000fe200078ff0ffULL,
0x0000b9227f007947ULL, 0x000fea000b800000ULL, 0x00001f1f4d1f7589ULL, 0x00066400000e0000ULL,
0x0000001f36367220ULL, 0x082fe40000410000ULL, 0x0000001f37377220ULL, 0x080fe40000410000ULL,
0x0000001f32327220ULL, 0x080fe40000410000ULL, 0x0000001f33337220ULL, 0x080fe40000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001f2f2f7220ULL, 0x000fc40000410000ULL,
0x0000001f12127220ULL, 0x080fe40000410000ULL, 0x0000001f13137220ULL, 0x080fe40000410000ULL,
0x0000001f0a0a7220ULL, 0x080fe40000410000ULL, 0x0000001f0b0b7220ULL, 0x080fe40000410000ULL,
0x0000001f06067220ULL, 0x080fe40000410000ULL, 0x0000001f07077220ULL, 0x000fc40000410000ULL,
0x0000001f0e0e7220ULL, 0x080fe40000410000ULL, 0x0000001f0f0f7220ULL, 0x080fe40000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001f3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff48ff7812ULL, 0x000fe2000780084aULL,
0x00000001ff497424ULL, 0x000fe200078e00ffULL, 0x000000451c457209ULL, 0x000fca0007810000ULL,
0x000000ffff487224ULL, 0x000fcc00078e0045ULL, 0x800000451c1c0221ULL, 0x000fe20000010000ULL,
0x00007610ff490816ULL, 0x000fe20000000049ULL, 0x000000ffff480224ULL, 0x000fe400078e0045ULL,
0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL, 0x0000001c00200308ULL, 0x000e640000000800ULL,
0x0000002044440220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001944197221ULL, 0x004fc40000010000ULL, 0x0000000000427805ULL, 0x000fca0000015200ULL,
0x0186ac00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x00000044421f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000145447824ULL, 0x000fe200000e0e43ULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff4400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff4400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc80000011444ULL,
0x0000001f1c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e0644ULL,
0x000000021c1c7819ULL, 0x000fc8000000121fULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910491c7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1c00720cULL, 0x000fda0003f25270ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x00000020ff1c723eULL, 0x000fe400000000ffULL, 0x00000002ff1f7819ULL, 0x000fe40000011603ULL,
0x000054101c1c7816ULL, 0x000fe2000000001cULL, 0x0000b5027f007947ULL, 0x000fea000b800000ULL,
0x00001f1f1c217589ULL, 0x0002a400000e0000ULL, 0x000000081f227810ULL, 0x000fe20007ffe0ffULL,
0x0000b5527f007947ULL, 0x000fea000b800000ULL, 0x00001f221c227589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000101f4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x008fe200078e001cULL, 0x0000f43000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x0000bc0000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000181f4c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x008fe200078e001cULL,
0x0000f4a000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff497424ULL, 0x004fc400078e00ffULL, 0x0000bb9000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000244c783bULL, 0x008ee20000004200ULL, 0x0001380028287811ULL, 0x000fe400078e20ffULL,
0x0001380029297811ULL, 0x000fe200078e20ffULL, 0x000000002554783bULL, 0x000e680000004200ULL,
0x000000002650783bULL, 0x000ea80000004200ULL, 0x000000002724783bULL, 0x000ea20000004200ULL,
0x00000018ff1c7819ULL, 0x00afe2000001144cULL, 0x000001004d5e7824ULL, 0x040fe200078e00ffULL,
0x000088804d5d7816ULL, 0x000fe200000000ffULL, 0x000001004c5b7824ULL, 0x040fe200078e00ffULL,
0x0000001c005c7306ULL, 0x0003e20000200c00ULL, 0x000088804c5a7816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fc40000011454ULL,
0x00000018ff497819ULL, 0x004fe40000011451ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000005d005f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1c7819ULL, 0x002fe2000001144dULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011450ULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004c005d7306ULL, 0x0002a20000200c00ULL, 0x00000018ff5e7819ULL, 0x000fc4000001145eULL,
0x00000018ff437819ULL, 0x000fe40000011452ULL, 0x00000018ff447819ULL, 0x000fe40000011453ULL,
0x00000018ff587819ULL, 0x000fe20000011455ULL, 0x0000004d00617306ULL, 0x0007e20000200c00ULL,
0x000088804e4c7816ULL, 0x002fe400000000ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011456ULL,
0x00000018ff4b7819ULL, 0x000fc40000011457ULL, 0x00000018ff417819ULL, 0x000fe20000011424ULL,
0x0000004c00627306ULL, 0x0003e20000200c00ULL, 0x000001004e4d7824ULL, 0x008fe200078e00ffULL,
0x000054105d5c7816ULL, 0x004fe4000000005cULL, 0x00000018ff427819ULL, 0x000fe40000011425ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000001c00607306ULL, 0x0004e20000200c00ULL,
0x000088804f4c7816ULL, 0x002fc400000000ffULL, 0x00000018ff1f7819ULL, 0x000fca0000011427ULL,
0x0000004d00637306ULL, 0x0002e20000200c00ULL, 0x00000018ff1c7819ULL, 0x004fe2000001144eULL,
0x000100004e4e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004c00667306ULL, 0x0005e20000200c00ULL, 0x000001004f4d7824ULL, 0x002fe200078e00ffULL,
0x00005410615d7816ULL, 0x008fc80000000060ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000001c00647306ULL, 0x0003e20000200c00ULL, 0x00008880544c7816ULL, 0x004fe400000000ffULL,
0x0000541062627816ULL, 0x000fca0000000063ULL, 0x0000004d00677306ULL, 0x0004e20000200c00ULL,
0x00000018ff1c7819ULL, 0x002fe2000001144fULL, 0x000100004f4f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000004c006a7306ULL, 0x0003e20000200c00ULL,
0x00000100544d7824ULL, 0x044fe400078e00ffULL, 0x0001000054547824ULL, 0x000fc600078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000004e00657306ULL, 0x000ea20000200c00ULL, 0x00008880554c7816ULL, 0x002fe400000000ffULL,
0x0000541066637816ULL, 0x008fca0000000067ULL, 0x0000004d006b7306ULL, 0x0003f00000200c00ULL,
0x0000004c006d7306ULL, 0x0007e20000200c00ULL, 0x00000100554d7824ULL, 0x002fe200078e00ffULL,
0x0000541065647816ULL, 0x004fe20000000064ULL, 0x0001000055557824ULL, 0x000fc600078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000054006c7306ULL, 0x0003e20000200c00ULL,
0x00008880564c7816ULL, 0x008fe400000000ffULL, 0x00000018ff557819ULL, 0x000fca0000011455ULL,
0x0000004d006e7306ULL, 0x0005e20000200c00ULL, 0x0000888051547816ULL, 0x002fce00000000ffULL,
0x0000004c00707306ULL, 0x0003e20000200c00ULL, 0x00000100564d7824ULL, 0x044fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004f00697306ULL, 0x000fe20000200c00ULL, 0x00008880574c7816ULL, 0x002fe400000000ffULL,
0x00000018ff567819ULL, 0x000fca0000011456ULL, 0x0000004d00717306ULL, 0x0003f00000200c00ULL,
0x0000004c00737306ULL, 0x0005e20000200c00ULL, 0x00000100574d7824ULL, 0x042fe400078e00ffULL,
0x0001000057577824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00008880504c7816ULL, 0x004fe400000000ffULL,
0x00000018ff577819ULL, 0x000fca0000011457ULL, 0x0000004d00747306ULL, 0x0003f00000200c00ULL,
0x0000004c00767306ULL, 0x000fe20000200c00ULL, 0x00000100504d7824ULL, 0x042fe400078e00ffULL,
0x0001000050507824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000005b005b7306ULL, 0x000e700000200c00ULL,
0x0000004d00777306ULL, 0x0005f00000200c00ULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x00000000284c783bULL, 0x0044e20000000200ULL, 0x000054105a5a7816ULL, 0x002fcc000000005bULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000000ffff287224ULL, 0x004fe400078e0054ULL,
0x0000010051547824ULL, 0x040fe400078e00ffULL, 0x0001000051517824ULL, 0x000fc600078e00ffULL,
0x0000002800787306ULL, 0x000fe20000200c00ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x000054105f5b7816ULL, 0x008fc6000000005eULL,
0x00000051007a7306ULL, 0x0003f00000200c00ULL, 0x0000005000287306ULL, 0x0005e20000200c00ULL,
0x0000010052517824ULL, 0x002fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005400797306ULL, 0x000fe20000200c00ULL, 0x0000888052507816ULL, 0x044fe200000000ffULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x000000214c4c9232ULL, 0x080fe40000000000ULL,
0x000000214e4e9232ULL, 0x000fe40000000000ULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x00000051007c7306ULL, 0x0003e20000200c00ULL, 0x000000224d4d9232ULL, 0x000fc40000000000ULL,
0x000000224f4f9232ULL, 0x000fca0000000000ULL, 0x00000050007b7306ULL, 0x0005e20000200c00ULL,
0x0000010053517824ULL, 0x042fe200078e00ffULL, 0x0000005a4c34723cULL, 0x040be80000001834ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000052007d7306ULL, 0x000fe20000200c00ULL,
0x0000888053507816ULL, 0x044fe200000000ffULL, 0x0001000053537824ULL, 0x000fe200078e00ffULL,
0x000000624c2c723cULL, 0x000fe2000000182cULL, 0x00000100255a7824ULL, 0x020fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x00000050007e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x0000005c4c30723cULL, 0x000b6a0000001830ULL,
0x00000051007f7306ULL, 0x0005e20000200c00ULL, 0x0000888024507816ULL, 0x002fc400000000ffULL,
0x00005410705c7816ULL, 0x020fe40000000071ULL, 0x00005410735d7816ULL, 0x000fc60000000074ULL,
0x0000005300807306ULL, 0x000fe20000200c00ULL, 0x0000010024517824ULL, 0x044fe400078e00ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000005c4c5c723cULL, 0x000f64000000180cULL,
0x00000018ff547819ULL, 0x000fe40000011451ULL, 0x0000005000607306ULL, 0x0003e20000200c00ULL,
0x00000018ff247819ULL, 0x000fce0000011424ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000000002950783bULL, 0x002e6e0000000200ULL, 0x00000055006f7306ULL, 0x0004f00000200c00ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000888025557816ULL, 0x044fe200000000ffULL,
0x0001000025257824ULL, 0x000fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x000054106f5b7816ULL, 0x008fce0000000058ULL,
0x0000005600727306ULL, 0x000eb00000200c00ULL, 0x0000005700757306ULL, 0x000ee20000200c00ULL,
0x0000002150509232ULL, 0x082fe40000000000ULL, 0x0000002152529232ULL, 0x000fc40000000000ULL,
0x0000002251519232ULL, 0x080fe40000000000ULL, 0x0000002253539232ULL, 0x000fe20000000000ULL,
0x0000005a00637306ULL, 0x0003e20000200c00ULL, 0x00005410724a7816ULL, 0x004fce000000004aULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x000054106c5a7816ULL, 0x002fe40000000059ULL,
0x00005410754b7816ULL, 0x008fca000000004bULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x0000005a4c58723cULL, 0x040bee0000001804ULL, 0x0000005400297306ULL, 0x0007e20000200c00ULL,
0x0000010026057824ULL, 0x060fe200078e00ffULL, 0x0000888026047816ULL, 0x000fe200000000ffULL,
0x0000004a4c3c723cULL, 0x000be2000000183cULL, 0x00005410280c7816ULL, 0x004fc40000000045ULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000001c00687306ULL, 0x0004a20000200c00ULL,
0x000000ffff547224ULL, 0x008fe200078e0055ULL, 0x000054106d557816ULL, 0x000fe4000000006eULL,
0x000054107a0d7816ULL, 0x002fc80000000049ULL, 0x0000005400627306ULL, 0x0003e20000200c00ULL,
0x00000018ff1c7819ULL, 0x004fe20000011426ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000000c500c723cULL, 0x000fe80000001830ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x00000004004a7306ULL, 0x0205e20000200c00ULL, 0x000054106a547816ULL, 0x002fe4000000006bULL,
0x0000541069657816ULL, 0x000fca0000000068ULL, 0x000000544c54723cULL, 0x000be20000001808ULL,
0x00000005004b7306ULL, 0x0002e20000200c00ULL, 0x0000541076047816ULL, 0x004fca0000000077ULL,
0x0000010027097824ULL, 0x060fe200078e00ffULL, 0x0000888027087816ULL, 0x040fe200000000ffULL,
0x000000644c10723cULL, 0x000f620000001810ULL, 0x0000541078057816ULL, 0x002fe20000000079ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000004300437306ULL, 0x000fe80000200c00ULL, 0x000000045004723cULL, 0x000b620000001834ULL,
0x000054104a307816ULL, 0x008fc6000000004bULL, 0x0000000800347306ULL, 0x0203f00000200c00ULL,
0x0000000900317306ULL, 0x0004e20000200c00ULL, 0x000054107b087816ULL, 0x002fce000000007cULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x000054107e097816ULL, 0x004fce000000007fULL,
0x000000085008723cULL, 0x000b62000000182cULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x0000541034317816ULL, 0x008fca0000000031ULL, 0x00000018ff2c7819ULL, 0x020fe40000011427ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000000305030723cULL, 0x000f6e000000185cULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000001f001f7306ULL, 0x000ff00000200c00ULL,
0x0000002400617306ULL, 0x0005f00000200c00ULL, 0x0000002500647306ULL, 0x0002e20000200c00ULL,
0x000054107d247816ULL, 0x004fce0000000043ULL, 0x0000002600287306ULL, 0x0004e20000200c00ULL,
0x0000541080257816ULL, 0x002fce0000000044ULL, 0x0000002c00357306ULL, 0x0002620000200c00ULL,
0x000000245024723cULL, 0x004b620000001810ULL, 0x00005410642d7816ULL, 0x008fcc0000000042ULL,
0x0000541060107816ULL, 0x020fe40000000029ULL, 0x0000541062117816ULL, 0x000fe40000000063ULL,
0x00005410612c7816ULL, 0x002fe40000000041ULL, 0x0000541028347816ULL, 0x000fe4000000001cULL,
0x0000541035357816ULL, 0x000fe2000000001fULL, 0x000000105010723cULL, 0x040b700000001854ULL,
0x0000002c502c723cULL, 0x040b700000001858ULL, 0x000000345034723cULL, 0x000b62000000183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff3e7f8cULL, 0x020e62000c80043fULL,
0x000000ffff417224ULL, 0x000fce00078e00ffULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x0186bc00ff1c7984ULL, 0x000ea40000000800ULL, 0x800000001cff7812ULL, 0x006fc4000780483fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0000003c281f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3c7824ULL, 0x000fe200000e0e29ULL,
0x003d09001f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc8000001143cULL, 0x0000001f1c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e063cULL, 0x000000021c1c7819ULL, 0x000fc8000000121fULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000021b1c7810ULL, 0x000fc80007ffe0ffULL,
0x000000161c00720cULL, 0x000fe20003f06070ULL, 0x00005800181c7a24ULL, 0x010fc800078e02ffULL,
0x000000801c287824ULL, 0x000fd000078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000c02a2a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001171f7824ULL, 0x000fe200078e0223ULL,
0x0000000223437810ULL, 0x000fe40007ffe0ffULL, 0x0000002a141c7217ULL, 0x000fe20007800000ULL,
0x000000011f297824ULL, 0x000fe200078e0203ULL, 0x0000000423457810ULL, 0x000fe20007ffe0ffULL,
0x000000101f427824ULL, 0x000fe200078e00ffULL, 0x00000006234a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001173c7824ULL, 0x000fe400078e0243ULL, 0x000000011c1c7824ULL, 0x000fe200078e0a2aULL,
0xfffffff042427812ULL, 0x000fe200078ee229ULL, 0x00000080001f7824ULL, 0x000fc400078e021fULL,
0x00000001172a7824ULL, 0x040fe200078e0245ULL, 0x0000001c171c7217ULL, 0x000fe20007800000ULL,
0x000000013c297824ULL, 0x140fe200078e0203ULL, 0x000000281f3f7210ULL, 0x0c0fe20007f1e0ffULL,
0x000000103c447824ULL, 0x000fe200078e00ffULL, 0x000000021f3e7810ULL, 0x040fe20007ffe0ffULL,
0x000000012a3c7824ULL, 0x040fe200078e0203ULL, 0x000000061f3d7810ULL, 0x000fe20007ffe0ffULL,
0x000000102a497824ULL, 0x000fe200078e00ffULL, 0xfffffff044447812ULL, 0x000fe200078ee229ULL,
0x0000000117297824ULL, 0x000fe200078e024aULL, 0x000000041f2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e06ffULL, 0xfffffff049497812ULL, 0x000fe200078ee23cULL,
0x000000011c1c7824ULL, 0x000fe200078e0a17ULL, 0x00005e003f3c7a11ULL, 0x000fe200078440ffULL,
0x0000000129417824ULL, 0x040fe200078e0203ULL, 0x000000283e3e7210ULL, 0x000fe20007f9e0ffULL,
0x00000010294b7824ULL, 0x000fe200078e00ffULL, 0x00005f003f3f7a11ULL, 0x000fc400010f441fULL,
0x000000282a2a7210ULL, 0x000fe40007f7e0ffULL, 0x0000001c2300720cULL, 0x000fe20003f46070ULL,
0x000000ffff237224ULL, 0x000fe200020e06ffULL, 0x000000283d287210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200018e06ffULL, 0xfffffff04b4b7812ULL, 0x000fe400078ee241ULL,
0x00005e003e3d7a11ULL, 0x000fe400078840ffULL, 0x000000f01e417812ULL, 0x000fc400078ec0ffULL,
0x00005e002a297a11ULL, 0x000fe400078640ffULL, 0x00005f003e3e7a11ULL, 0x000fe200020f4423ULL,
0x000000ffff237224ULL, 0x000fe200000e06ffULL, 0x000000413c1e7210ULL, 0x000fe40007fbe0ffULL,
0x00005e00283c7a11ULL, 0x000fe400078c40ffULL, 0x00005f002a2a7a11ULL, 0x000fe200018f441fULL,
0x000000ffff1f7224ULL, 0x000fe200028e063fULL, 0x0000001c4300720cULL, 0x000fc40003f86070ULL,
0x0000001c4500720cULL, 0x080fe40003f66070ULL, 0x0001400042427811ULL, 0x000fe400078e20ffULL,
0x0000001c4a00720cULL, 0x000fe40003f06070ULL, 0x00005f00281c7a11ULL, 0x000fe200030f4423ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e427faeULL, 0x0003e2000d101c46ULL,
0x000000413d287210ULL, 0x000fe40007fbe0ffULL, 0x0001400044447811ULL, 0x000fc400078e20ffULL,
0x0001400049497811ULL, 0x000fe400078e20ffULL, 0x000140004b4b7811ULL, 0x000fe400078e20ffULL,
0x00000041291e7210ULL, 0x082fe20007f5e0ffULL, 0x000000ffff297224ULL, 0x000fe200028e063eULL,
0x000000413c3c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e062aULL,
0x0000000028447faeULL, 0x0003e2000e101c46ULL, 0x000000ffff3d7224ULL, 0x000fc600028e061cULL,
0x000000001e497faeULL, 0x0003e8000d901c46ULL, 0x000000003c4b7faeULL, 0x0003e2000c101c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000117237824ULL, 0x000fc800078e0223ULL,
0x00000001231c7824ULL, 0x040fe200078e0203ULL, 0x00000002231f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001023297824ULL, 0x040fe200078e00ffULL, 0x00000006233f7810ULL, 0x000fc60007ffe0ffULL,
0x000000011f2a7824ULL, 0x000fe200078e0203ULL, 0xfffffff029297812ULL, 0x000fe200078ee21cULL,
0x000000101f3d7824ULL, 0x000fe400078e00ffULL, 0x00000080001c7824ULL, 0x000fe200078e0223ULL,
0x0001400029297811ULL, 0x000fe200078e20ffULL, 0x000000013f447824ULL, 0x000fe200078e0203ULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee22aULL, 0x000000103f497824ULL, 0x000fe200078e00ffULL,
0x00000004232a7810ULL, 0x000fe40007ffe0ffULL, 0x000000281c1f7210ULL, 0x000fc40007f1e0ffULL,
0x000000021c237810ULL, 0x000fe20007ffe0ffULL, 0x000000012a3e7824ULL, 0x000fe200078e0203ULL,
0x000000041c3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000102a427824ULL, 0x000fe200078e00ffULL,
0x000000061c417810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00000028232a7210ULL, 0x000fe40007f5e0ffULL, 0x00005e001f237a11ULL, 0x000fe400078040ffULL,
0xfffffff042427812ULL, 0x000fc400078ee23eULL, 0x000000283c3c7210ULL, 0x080fe40007f7e0ffULL,
0x000000f01e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000002841437210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x00005f001f1c7a11ULL, 0x000fe200000f441cULL,
0x000000ffff1f7224ULL, 0x000fe200010e06ffULL, 0x00005e002a287a11ULL, 0x000fe400078440ffULL,
0x0000003e231e7210ULL, 0x000fc40007f1e0ffULL, 0xfffffff049497812ULL, 0x000fe200078ee244ULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005e003c417a11ULL, 0x000fe400078640ffULL,
0x00005e0043457a11ULL, 0x000fe400078840ffULL, 0x00005f002a2a7a11ULL, 0x000fe200010f441fULL,
0x000000ffff1f7224ULL, 0x000fe200000e061cULL, 0x00005f003c3f7a11ULL, 0x000fe400018f443fULL,
0x0000003e28287210ULL, 0x000fc40007f1e0ffULL, 0x0000003e413c7210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e297faeULL, 0x0003e2000b901c46ULL,
0x00005f0043447a11ULL, 0x000fe400020f4444ULL, 0x0000003e453e7210ULL, 0x000fe40007f7e0ffULL,
0x000140003d1c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff3d7224ULL, 0x000fe200010e063fULL,
0x0001400042427811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e0644ULL,
0x0001400049497811ULL, 0x000fe200078e20ffULL, 0x000000ffff297224ULL, 0x002fca00000e062aULL,
0x00000000281c7faeULL, 0x0003e8000b901c46ULL, 0x000000003c427faeULL, 0x0003e8000b901c46ULL,
0x000000003e497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff1e7f8cULL, 0x000e64000c80043fULL,
0x000000ffff417224ULL, 0x002fc400078e001fULL, 0x00000000001e7805ULL, 0x000fca0000015200ULL,
0x0186b400ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fc40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x000000281e237210ULL, 0x000fca0007f1e1ffULL,
0x0000000129287824ULL, 0x000fe200000e0e1fULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc80000011428ULL,
0x000000231c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0628ULL,
0x000000021c1c7819ULL, 0x000fc80000001223ULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x00000020ff1c723eULL, 0x000fe400000000ffULL, 0x00000002ff1e7819ULL, 0x000fe40000011603ULL,
0x000054101c1c7816ULL, 0x000fe2000000001cULL, 0x000098c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e1c217589ULL, 0x0002a400000e0000ULL, 0x000000081e227810ULL, 0x000fe20007ffe0ffULL,
0x000099127f007947ULL, 0x000fea000b800000ULL, 0x00001f221c227589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000101e4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e001cULL, 0x0001117000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x00009ec000007944ULL, 0x00efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000181e4c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e001cULL,
0x000111e000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x004fc400078e00ffULL, 0x00009e5000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000138003b4e7811ULL, 0x000fc400078e20ffULL, 0x00000000393c783bULL, 0x000f280000004200ULL,
0x000000003a44783bULL, 0x000ee80000004200ULL, 0x000000002b28783bULL, 0x000ea80000004200ULL,
0x000000003838783bULL, 0x000e640000004200ULL, 0x00000018ff1c7819ULL, 0x01afe2000001143cULL,
0x000001003d537824ULL, 0x040fe200078e00ffULL, 0x000088803d517816ULL, 0x000fe200000000ffULL,
0x000001003c507824ULL, 0x040fe200078e00ffULL, 0x0000001c00527306ULL, 0x0003e20000200c00ULL,
0x000088803c4f7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff4c7819ULL, 0x000fe40000011444ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005300557306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x002fe2000001143dULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011445ULL, 0x00000018ff4a7819ULL, 0x004fe40000011429ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003c00537306ULL, 0x0002a20000200c00ULL,
0x00000018ff497819ULL, 0x000fc40000011428ULL, 0x00000018ff437819ULL, 0x000fe4000001142aULL,
0x00000018ff427819ULL, 0x000fe4000001142bULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000003d00577306ULL, 0x0007e20000200c00ULL, 0x000088803e3c7816ULL, 0x002fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011446ULL, 0x00000018ff4b7819ULL, 0x000fc40000011447ULL,
0x00000018ff1f7819ULL, 0x000fe20000011438ULL, 0x0000003c00587306ULL, 0x0003e20000200c00ULL,
0x000001003e3d7824ULL, 0x008fe200078e00ffULL, 0x0000541053527816ULL, 0x004fe40000000052ULL,
0x00000018ff237819ULL, 0x000fe40000011439ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000001c00567306ULL, 0x0004e20000200c00ULL, 0x000088803f3c7816ULL, 0x002fc400000000ffULL,
0x00000018ff1e7819ULL, 0x000fca000001143bULL, 0x0000003d00597306ULL, 0x0003220000200c00ULL,
0x00000018ff1c7819ULL, 0x004fe2000001143eULL, 0x000100003e3e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003c005c7306ULL, 0x0005e20000200c00ULL,
0x000001003f3d7824ULL, 0x002fe200078e00ffULL, 0x0000541057537816ULL, 0x008fc80000000056ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000001c005a7306ULL, 0x0003e20000200c00ULL,
0x00008880443c7816ULL, 0x004fe400000000ffULL, 0x0000541058587816ULL, 0x010fca0000000059ULL,
0x0000003d005d7306ULL, 0x0004e20000200c00ULL, 0x00000018ff1c7819ULL, 0x002fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003c00607306ULL, 0x0003e20000200c00ULL, 0x00000100443d7824ULL, 0x044fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000003e005b7306ULL, 0x000ea20000200c00ULL,
0x00008880453c7816ULL, 0x002fe400000000ffULL, 0x000054105c597816ULL, 0x008fca000000005dULL,
0x0000003d00617306ULL, 0x0003f00000200c00ULL, 0x0000003c00637306ULL, 0x0007e20000200c00ULL,
0x00000100453d7824ULL, 0x002fe200078e00ffULL, 0x000054105b5a7816ULL, 0x004fe2000000005aULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000004400627306ULL, 0x0003e20000200c00ULL,
0x00008880463c7816ULL, 0x008fce00000000ffULL, 0x0000003d00647306ULL, 0x0005e20000200c00ULL,
0x0000888029447816ULL, 0x002fce00000000ffULL, 0x0000004500657306ULL, 0x0003e20000200c00ULL,
0x00000100463d7824ULL, 0x044fe400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00667306ULL, 0x0005e20000200c00ULL,
0x0000010029457824ULL, 0x042fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003d00677306ULL, 0x0003e20000200c00ULL, 0x00008880473c7816ULL, 0x004fe400000000ffULL,
0x00000018ff297819ULL, 0x000fca0000011429ULL, 0x0000003c00697306ULL, 0x0005e20000200c00ULL,
0x00000100473d7824ULL, 0x042fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000002900717306ULL, 0x0003e20000200c00ULL,
0x00008880283c7816ULL, 0x004fe400000000ffULL, 0x00000018ff477819ULL, 0x000fca0000011447ULL,
0x0000003d006a7306ULL, 0x0005e20000200c00ULL, 0x000001002a297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000003f005f7306ULL, 0x000fe20000200c00ULL,
0x00000100283d7824ULL, 0x044fe400078e00ffULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000003c006c7306ULL, 0x000ff00000200c00ULL, 0x0000003d006d7306ULL, 0x0003f00000200c00ULL,
0x00000028006e7306ULL, 0x0005e20000200c00ULL, 0x000000004e3c783bULL, 0x0022ee0000000200ULL,
0x0000002900737306ULL, 0x0009e20000200c00ULL, 0x000088802a287816ULL, 0x044fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fc400078e00ffULL, 0x00000100394e7824ULL, 0x002fc600078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000002800727306ULL, 0x0003e20000200c00ULL,
0x000001002b297824ULL, 0x010fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc8000001144eULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a00747306ULL, 0x000fe20000200c00ULL,
0x000088802b287816ULL, 0x042fe200000000ffULL, 0x000100002b2b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002800757306ULL, 0x0003f00000200c00ULL,
0x0000002900767306ULL, 0x0005e20000200c00ULL, 0x0000888038287816ULL, 0x002fe200000000ffULL,
0x000000213c3c9232ULL, 0x008fc40000000000ULL, 0x000000213e3e9232ULL, 0x000fe40000000000ULL,
0x000000223d3d9232ULL, 0x080fe40000000000ULL, 0x0000002800567306ULL, 0x0003e20000200c00ULL,
0x0000010038297824ULL, 0x044fe200078e00ffULL, 0x000000223f3f9232ULL, 0x000fe20000000000ULL,
0x0001000038387824ULL, 0x000fca00078e00ffULL, 0x0000002b00777306ULL, 0x0005e20000200c00ULL,
0x0001380040287811ULL, 0x002fe200078e20ffULL, 0x000000523c0c723cULL, 0x000f62000000180cULL,
0x00000018ff407819ULL, 0x000fe40000011429ULL, 0x00000018ff387819ULL, 0x000fc60000011438ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x000000002828783bULL, 0x004e620000000200ULL,
0x000000583c08723cULL, 0x000fec0000001808ULL, 0x0000005000507306ULL, 0x000eb00000200c00ULL,
0x0000005100517306ULL, 0x000ef00000200c00ULL, 0x0000001c005e7306ULL, 0x0008620000200c00ULL,
0x000054104f507816ULL, 0x004fce0000000050ULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x0000541051517816ULL, 0x008fe40000000055ULL, 0x00000018ff1c7819ULL, 0x010fca000001143aULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x000000503c04723cULL, 0x040b620000001804ULL,
0x000054105f5b7816ULL, 0x002fe2000000005eULL, 0x0000002128289232ULL, 0x080fe40000000000ULL,
0x000000212a2a9232ULL, 0x000fe40000000000ULL, 0x0000002229299232ULL, 0x080fe20000000000ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x00005410624c7816ULL, 0x004fe2000000004cULL,
0x0000005a3c24723cULL, 0x000fe20000001824ULL, 0x0000541066507816ULL, 0x020fe20000000067ULL,
0x000000222b2b9232ULL, 0x000fe20000000000ULL, 0x0000541069517816ULL, 0x000fc6000000006aULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x00005410654d7816ULL, 0x008fc6000000004dULL,
0x000000503c50723cULL, 0x000fe80000001830ULL, 0x0000004600687306ULL, 0x000e700000200c00ULL,
0x00000047006b7306ULL, 0x000eb00000200c00ULL, 0x00000044006f7306ULL, 0x0007e20000200c00ULL,
0x0000541068547816ULL, 0x002fce0000000054ULL, 0x0000004500707306ULL, 0x0003e20000200c00ULL,
0x0000888039447816ULL, 0x048fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x000054106b557816ULL, 0x004fc8000000004bULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000004400577306ULL, 0x0005e20000200c00ULL, 0x0000541063457816ULL, 0x002fce0000000064ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x0000541060447816ULL, 0x004fce0000000061ULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x000000443c44723cULL, 0x000b6e0000001810ULL,
0x0000004e00587306ULL, 0x0007e20000200c00ULL, 0x000088803a107816ULL, 0x060fe200000000ffULL,
0x000001003a117824ULL, 0x000fe200078e00ffULL, 0x000054106e307816ULL, 0x002fe20000000049ULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x00000010004b7306ULL, 0x0003e20000200c00ULL, 0x0000004c3c4c723cULL, 0x008b62000000182cULL,
0x0000541071317816ULL, 0x004fe4000000004aULL, 0x00000018ff3a7819ULL, 0x000fc8000001143aULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x000000543c3c723cULL, 0x000b620000001834ULL,
0x000088803b107816ULL, 0x002fe400000000ffULL, 0x00005410722c7816ULL, 0x020fe40000000073ULL,
0x00005410752d7816ULL, 0x000fe40000000076ULL, 0x000054106c347816ULL, 0x000fe2000000006dULL,
0x000000302830723cULL, 0x040f62000000180cULL, 0x000054106f357816ULL, 0x000fe20000000070ULL,
0x0000004200427306ULL, 0x000fec0000200c00ULL, 0x000000342834723cULL, 0x040b640000001804ULL,
0x0000001f001f7306ULL, 0x000fea0000200c00ULL, 0x000001003b057824ULL, 0x060fe200078e00ffULL,
0x0000002c282c723cULL, 0x000b620000001808ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x0000002300237306ULL, 0x000fe20000200c00ULL, 0x000000ffff047224ULL, 0x000fe200078e0010ULL,
0x00000018ff057819ULL, 0x000fc40000011405ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000541074107816ULL, 0x004fe40000000043ULL, 0x0000001c001c7306ULL, 0x000fe20000200c00ULL,
0x0000541057097816ULL, 0x020fce0000000058ULL, 0x0000001e001e7306ULL, 0x000ff00000200c00ULL,
0x0000004000407306ULL, 0x000e700000200c00ULL, 0x0000003800387306ULL, 0x000eb00000200c00ULL,
0x0000003900397306ULL, 0x000fe20000200c00ULL, 0x0000541056087816ULL, 0x002fce0000000040ULL,
0x0000001100547306ULL, 0x0002e20000200c00ULL, 0x000000082808723cULL, 0x000b6e0000001844ULL,
0x0000000400557306ULL, 0x0005e20000200c00ULL, 0x0000541077117816ULL, 0x002fce0000000042ULL,
0x00000005000d7306ULL, 0x0003220000200c00ULL, 0x0000541038047816ULL, 0x004fe2000000001fULL,
0x000000102810723cULL, 0x000b620000001824ULL, 0x000054104b0c7816ULL, 0x008fca0000000054ULL,
0x0000003a003a7306ULL, 0x000ea20000200c00ULL, 0x0000541039057816ULL, 0x002fce0000000023ULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x00005410550d7816ULL, 0x010fe2000000000dULL,
0x000000042804723cULL, 0x000b62000000184cULL, 0x000054103a3a7816ULL, 0x004fce000000001cULL,
0x0000000c280c723cULL, 0x000b620000001850ULL, 0x000054103b3b7816ULL, 0x002fce000000001eULL,
0x0000003a283c723cULL, 0x000b62000000183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff1e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000021d1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x002fc400078e001fULL,
0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL, 0x000000161b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffef08000007947ULL, 0x000fea000383ffffULL,
0x000000ff1600720cULL, 0x000fe20003f05270ULL, 0x000000ffff227224ULL, 0x020fe400078e000fULL,
0x000000ffff217224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x000fe400078e0013ULL,
0x000000ffff207224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fe400078e000cULL,
0x000000ffff1e7224ULL, 0x000fc400078e0007ULL, 0x000000ffff1d7224ULL, 0x008fe400078e0006ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0005ULL, 0x000000ffff1b7224ULL, 0x002fe400078e0004ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000bULL, 0x000000ffff187224ULL, 0x000fe400078e000aULL,
0x000000ffff167224ULL, 0x000fc400078e0009ULL, 0x000000ffff157224ULL, 0x000fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e0012ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0010ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000019007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x000fe200078e0019ULL,
0x000122e000047802ULL, 0x000fc40000000f00ULL, 0x00008b9000007944ULL, 0x004fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001900007308ULL, 0x000e640000001000ULL,
0xbf80000000197423ULL, 0x002fc80000000019ULL, 0x800000ff19197221ULL, 0x000fc80000010100ULL,
0x0000001900007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff047624ULL, 0x000fe400078e00ffULL, 0x00006900ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604047981ULL, 0x0088e8000c1e9900ULL, 0x0000000000057919ULL, 0x010f240000000000ULL,
0x00000002ff037819ULL, 0x016fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000004007220ULL, 0x008fca0000410000ULL, 0x00001f0300037589ULL, 0x000e6800000e0000ULL,
0x00001f0500007589ULL, 0x000ea200000e0000ULL, 0x0000003403347220ULL, 0x042fe40000410000ULL,
0x0000003503357220ULL, 0x040fe40000410000ULL, 0x0000003003307220ULL, 0x040fe40000410000ULL,
0x0000003103317220ULL, 0x000fc40000410000ULL, 0x0000002c032c7220ULL, 0x040fe40000410000ULL,
0x0000002d032d7220ULL, 0x040fe40000410000ULL, 0x0000000e030e7220ULL, 0x040fe40000410000ULL,
0x0000000f030f7220ULL, 0x040fe40000410000ULL, 0x0000001503157220ULL, 0x040fe40000410000ULL,
0x0000001603167220ULL, 0x000fc40000410000ULL, 0x0000001b031b7220ULL, 0x040fe40000410000ULL,
0x0000001c031c7220ULL, 0x040fe40000410000ULL, 0x0000001f031f7220ULL, 0x040fe40000410000ULL,
0x0000002003207220ULL, 0x040fe40000410000ULL, 0x0000003c033c7220ULL, 0x040fe40000410000ULL,
0x0000003d033d7220ULL, 0x000fc40000410000ULL, 0x0000003600367220ULL, 0x044fe40000410000ULL,
0x0000003700377220ULL, 0x040fe40000410000ULL, 0x0000003200327220ULL, 0x040fe40000410000ULL,
0x0000003300337220ULL, 0x040fe40000410000ULL, 0x0000002e002e7220ULL, 0x040fe40000410000ULL,
0x0000002f002f7220ULL, 0x000fc40000410000ULL, 0x0000001300137220ULL, 0x040fe40000410000ULL,
0x0000001400147220ULL, 0x040fe40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001a001a7220ULL, 0x040fe40000410000ULL, 0x0000001d001d7220ULL, 0x040fe40000410000ULL,
0x0000001e001e7220ULL, 0x000fc40000410000ULL, 0x0000002100217220ULL, 0x040fe40000410000ULL,
0x0000002200227220ULL, 0x040fe40000410000ULL, 0x0000003e003e7220ULL, 0x040fe40000410000ULL,
0x0000003f003f7220ULL, 0x000fc40000410000ULL, 0x0000000000237919ULL, 0x000e620000000000ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff047819ULL, 0x002fc60000011623ULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000223007812ULL, 0x040fe400078ec0ffULL, 0x0000000823057811ULL, 0x000fe200078ff0ffULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x0000000400037211ULL, 0x000fe200078ff8ffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000000500067211ULL, 0x000fe200078ff8ffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000000203007810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x040fe200078e00ffULL, 0x0000000403057810ULL, 0x000fe20007ffe0ffULL,
0x00000008040b7824ULL, 0x000fe200078e00ffULL, 0xfffffff807047812ULL, 0x000fc400078ee203ULL,
0x0000000603037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff809097812ULL, 0x000fe400078ee206ULL,
0xfffffff808067812ULL, 0x000fe400078ee200ULL, 0xfffffff80b087812ULL, 0x000fe200078ee203ULL,
0x0000000823037824ULL, 0x000fe200078e00ffULL, 0xfffffff80a077812ULL, 0x000fe400078ee205ULL,
0x0001200002057811ULL, 0x000fc400078e58ffULL, 0x0000000803037812ULL, 0x000fe400078ec0ffULL,
0x000000343500723eULL, 0x000fe200000000ffULL, 0x0000001004047824ULL, 0x100fe200078e0205ULL,
0x000000303102723eULL, 0x000fe200000000ffULL, 0x0000001009097824ULL, 0x000fe200078e0205ULL,
0x00000003ff0b7819ULL, 0x000fe20000011623ULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x00005410000c7816ULL, 0x100fe20000000002ULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x00007632000d7816ULL, 0x000fe20000000002ULL, 0x0000001007007824ULL, 0x100fe200078e0205ULL,
0x0000002023107810ULL, 0x000fe20007ffe0ffULL, 0x0000001008027824ULL, 0x000fc400078e0205ULL,
0x0000000c04007388ULL, 0x0003e20000000a00ULL, 0x00000003ff117819ULL, 0x000fe20000011610ULL,
0x00000001030a7824ULL, 0x040fe400078e0209ULL, 0x0000000103077824ULL, 0x040fe400078e0206ULL,
0x0000000103087824ULL, 0x000fe200078e0200ULL, 0x0000002c2d00723eULL, 0x000fe200000000ffULL,
0x0000000103097824ULL, 0x000fe200078e0202ULL, 0x0000000e0f02723eULL, 0x000fe400000000ffULL,
0x000000151603723eULL, 0x000fe200000000ffULL, 0x000000010b047824ULL, 0x002fe200078e0223ULL,
0x00005410000e7816ULL, 0x100fe20000000002ULL, 0x00000001100c7824ULL, 0x000fe200078e0211ULL,
0x00007632000f7816ULL, 0x000fc40000000002ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000e07007388ULL, 0x000fe20000000a00ULL,
0x0ffffff804067812ULL, 0x000fe400078ef823ULL, 0x0000001b1c04723eULL, 0x000fe400000000ffULL,
0x0ffffff80c0d7812ULL, 0x000fe200078ef810ULL, 0x00000010060c7824ULL, 0x000fe200078e0205ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x000000100d127824ULL, 0x000fe200078e0205ULL, 0x0000001f2000723eULL, 0x000fe400000000ffULL,
0x000000323304723eULL, 0x000fe200000000ffULL, 0x0000000208007388ULL, 0x0003e20000000a00ULL,
0x0000002e2f05723eULL, 0x000fe400000000ffULL, 0x000000131406723eULL, 0x000fe400000000ffULL,
0x0000000723237812ULL, 0x000fc400078ec0ffULL, 0x0000000710107812ULL, 0x000fc800078ec0ffULL,
0x1ffffff810107812ULL, 0x000fe400078ef817ULL, 0x0000003c3d02723eULL, 0x002fe400000000ffULL,
0x000000363703723eULL, 0x000fe400000000ffULL, 0x00005410000e7816ULL, 0x140fe40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0000000e09007388ULL, 0x000fe20000000a00ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000020a007388ULL, 0x0003e20000000a00ULL, 0x000000181a00723eULL, 0x000fc600000000ffULL,
0x0004000407007388ULL, 0x0007e20000000a00ULL, 0x0000001d1e02723eULL, 0x002fe400000000ffULL,
0x000000212203723eULL, 0x000fe200000000ffULL, 0x0000000000057919ULL, 0x008e620000002600ULL,
0x0000003e3f04723eULL, 0x000fe400000000ffULL, 0x0000541000067816ULL, 0x140fe40000000002ULL,
0x0000763200077816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004000608007388ULL, 0x000fe80000000a00ULL,
0x0004000209007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000c0c7984ULL, 0x000f220000000c00ULL, 0x0000000805007824ULL, 0x002fc600078e00ffULL,
0x0000000012187984ULL, 0x000e620000000c00ULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff8000b7812ULL, 0x000fc800078ee20bULL, 0xfffffff805117812ULL, 0x000fe400078ee211ULL,
0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000411117c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a000b027a11ULL, 0x008fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a0011047a11ULL, 0x000fe400078248ffULL,
0x00005b000b037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff823007812ULL, 0x000fe400078ef817ULL,
0x00005b0011057a11ULL, 0x000fc600008f4c05ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x0000001010047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x010fe8000c101d06ULL,
0x0000001804007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff177819ULL, 0x000fe20000011602ULL, 0xffffffffff287424ULL, 0x000fc600078e00ffULL,
0x000000151700720cULL, 0x000fda0003f06070ULL, 0x000000022b048824ULL, 0x002fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e0217ULL, 0x0000600004048625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff2c7624ULL, 0x000fe200078e00ffULL,
0x0000000604288981ULL, 0x0002a2000c1e1900ULL, 0x00006900ff2d7624ULL, 0x000fca00078e00ffULL,
0x000000062c2c7981ULL, 0x000722000c1e9900ULL, 0x000001ff0700780cULL, 0x000fe20003f04070ULL,
0x0000008000007824ULL, 0x000fe400078e00ffULL, 0x00000040022a7824ULL, 0x000fe200078e00ffULL,
0x01860000ff047f8cULL, 0x002e62000c80043fULL, 0x0000008029297824ULL, 0x000fc600078e00ffULL,
0x0000004000087812ULL, 0x000fe200078ef82aULL, 0x0000002928077224ULL, 0x004fc800078e02ffULL,
0x00000e8000000947ULL, 0x000fea0003800000ULL, 0x00000003ff257819ULL, 0x00afe40000011603ULL,
0x0000002a14097217ULL, 0x000fe40007800000ULL, 0x00000004250b7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x040fe200078e0225ULL, 0x00000008250d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a2aULL, 0x0000001425127810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0c7824ULL, 0x000fe200078e0203ULL, 0x0000000a071e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001080a7824ULL, 0x000fe200078e020bULL, 0x000000090b00720cULL, 0x040fe20003f06070ULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x0000001825187810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0b7824ULL, 0x000fe200078e0203ULL, 0x0000000a070a7210ULL, 0x000fe20007f5e0ffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20cULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x00005e001e137a11ULL, 0x000fe200078240ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e06ffULL, 0x00005e000a197a11ULL, 0x000fe200078440ffULL,
0x0000000108117824ULL, 0x000fe200078e0212ULL, 0xfffffff80f0f7812ULL, 0x000fc400078ee20bULL,
0x00005f000a1d7a11ULL, 0x000fe400010f441dULL, 0x0000000c250a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f001e1e7a11ULL, 0x000fe400008f4410ULL, 0x000000090d00720cULL, 0x000fe20003f26070ULL,
0x00000001080b7824ULL, 0x040fe200078e020aULL, 0x0000001025107810ULL, 0x000fe20007ffe0ffULL,
0x00000001080d7824ULL, 0x000fe200078e020dULL, 0x0000001107117210ULL, 0x040fe20007f7e0ffULL,
0x000000080a277824ULL, 0x000fe200078e00ffULL, 0x0000000b070b7210ULL, 0x040fe20007fbe0ffULL,
0x00000001080c7824ULL, 0x000fe200078e0210ULL, 0x0000000d070d7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x00005e0011207a11ULL, 0x000fe200078640ffULL,
0x000000ffff247224ULL, 0x000fe200028e06ffULL, 0x00005e000b237a11ULL, 0x000fe200078a40ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x0000000c070c7210ULL, 0x000fe20007f5e0ffULL,
0x00000008102d7824ULL, 0x000fe200078e00ffULL, 0x00005f000b247a11ULL, 0x000fe200028f4424ULL,
0x00000001250b7824ULL, 0x000fe200078e0203ULL, 0x00005e000d1a7a11ULL, 0x000fe200078840ffULL,
0x000000ffff227224ULL, 0x000fe200010e06ffULL, 0x00005e000c1b7a11ULL, 0x000fc400078440ffULL,
0x00005f000d1c7a11ULL, 0x000fe400020f441cULL, 0x000000070b0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001080b7824ULL, 0x000fe200078e0218ULL, 0x0000007006267812ULL, 0x000fe400078ec0ffULL,
0x00005f000c227a11ULL, 0x000fe200010f4422ULL, 0x000000010a0c7824ULL, 0x000fe200078e0203ULL,
0x00005f0011217a11ULL, 0x000fe200018f4421ULL, 0x0000000110117824ULL, 0x000fe200078e0203ULL,
0x000000090a00720cULL, 0x000fc40003fa6070ULL, 0x0000000b071f7210ULL, 0x000fe40007fde0ffULL,
0x00000013260a7210ULL, 0x000fe40007f7e0ffULL, 0x000000092500720cULL, 0x080fe20003f46070ULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x0000200002067811ULL, 0x000fe200078e70ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e061eULL, 0x0ffffff80d0d7812ULL, 0x000fe400078ef803ULL,
0x00005e001f1e7a11ULL, 0x000fe200078640ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0206ULL,
0x000000091000720cULL, 0x000fe20003f86070ULL, 0x000000100d0d7824ULL, 0x000fe200078e0206ULL,
0xfffffff827107812ULL, 0x000fe200078ee20cULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0x00005f001f1f7a11ULL, 0x000fe200018f4413ULL, 0x0000000112137824ULL, 0x100fe200078e0203ULL,
0x00000019260c7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000d101c46ULL, 0x0000001c25197810ULL, 0x000fe20007ffe0ffULL,
0x0000000812277824ULL, 0x040fe200078e00ffULL, 0x000000091200720cULL, 0x000fe20003f46070ULL,
0x0000000118127824ULL, 0x000fe200078e0203ULL, 0xfffffff82d117812ULL, 0x000fe200078ee211ULL,
0x0000001010107824ULL, 0x000fe200078e0206ULL, 0xfffffff827137812ULL, 0x000fc600078ee213ULL,
0x0000001011117824ULL, 0x100fe400078e0206ULL, 0x000000ffff0d7224ULL, 0x002fe200018e061dULL,
0x0000001a260a7210ULL, 0x000fe20007f7e0ffULL, 0x00000001081a7824ULL, 0x000fe400078e0219ULL,
0x0000001013137824ULL, 0x000fe200078e0206ULL, 0x000000000c0e7faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200018e061cULL, 0x0000001a071a7210ULL, 0x000fe40007fde0ffULL,
0x000000091800720cULL, 0x040fe20003f66070ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x000000000a0f7faeULL, 0x0005e2000c901c46ULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x00005e001a1c7a11ULL, 0x000fc400078c40ffULL, 0xfffffff818127812ULL, 0x000fe400078ee212ULL,
0x00005f001a1d7a11ULL, 0x000fe200030f441dULL, 0x00000001190e7824ULL, 0x042fe200078e0203ULL,
0x00000023260c7210ULL, 0x000fe20007fde0ffULL, 0x0000001012127824ULL, 0x000fe200078e0206ULL,
0x000000091900720cULL, 0x040fe20003f06070ULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x00000020250f7810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e0624ULL,
0x0000001b260a7210ULL, 0x000fc40007f3e0ffULL, 0xfffffff8190e7812ULL, 0x000fe200078ee20eULL,
0x0000000108187824ULL, 0x000fe200078e020fULL, 0x000000000c107faeULL, 0x0003e2000e901c46ULL,
0x000000ffff0b7224ULL, 0x000fe200008e0622ULL, 0x000000090f00720cULL, 0x040fe20003f26070ULL,
0x000000080f227824ULL, 0x000fe200078e00ffULL, 0x00000018071b7210ULL, 0x000fe20007fde0ffULL,
0x000000010f187824ULL, 0x000fe200078e0203ULL, 0x000000000a117faeULL, 0x0005e6000e101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x00005e001b1a7a11ULL, 0x000fc400078c40ffULL,
0xfffffff822187812ULL, 0x000fe400078ee218ULL, 0x00005f001b1b7a11ULL, 0x000fe400030f440fULL,
0x00000024250f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001018187824ULL, 0x000fe200078e0206ULL,
0x00000020260a7210ULL, 0x004fe40007fbe0ffULL, 0x000000090f00720cULL, 0x000fe20003f86070ULL,
0x00000001080c7824ULL, 0x002fe400078e020fULL, 0x000000ffff0b7224ULL, 0x000fc400028e0621ULL,
0x000000010f0d7824ULL, 0x000fe200078e0203ULL, 0x0000000c07197210ULL, 0x000fe20007fde0ffULL,
0x000000080f107824ULL, 0x000fe200078e00ffULL, 0x0000001e260c7210ULL, 0x000fe20007fbe0ffULL,
0x000000000a137faeULL, 0x0003e4000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x00005e0019117a11ULL, 0x040fe400078c40ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20dULL,
0x000000ffff0d7224ULL, 0x000fe200028e061fULL, 0x00005f0019197a11ULL, 0x000fe200030f440fULL,
0x000000100e0f7824ULL, 0x000fc400078e0206ULL, 0x0000001010107824ULL, 0x000fe200078e0206ULL,
0x000000000c127faeULL, 0x0005e2000d901c46ULL, 0x0000001c260a7210ULL, 0x002fe40007f5e0ffULL,
0x0000003825137810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e061dULL,
0x00000011260e7210ULL, 0x040fe20007f5e0ffULL, 0x00000008131e7824ULL, 0x000fe200078e00ffULL,
0x0000003425117810ULL, 0x000fe40007ffe0ffULL, 0x000000000a0f7faeULL, 0x0003e2000c101c46ULL,
0x0000001a260c7210ULL, 0x004fe40007f7e0ffULL, 0x00000008111d7824ULL, 0x000fc600078e00ffULL,
0x000000ffff0d7224ULL, 0x000fca00018e061bULL, 0x000000000c187faeULL, 0x0005e2000c901c46ULL,
0x00000028250a7810ULL, 0x042fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e0619ULL,
0x0000003c25197810ULL, 0x000fe40007ffe0ffULL, 0x000000090a00720cULL, 0x080fe20003fa6070ULL,
0x00000001080b7824ULL, 0x000fe200078e020aULL, 0x000000000e107faeULL, 0x0003e2000e101c46ULL,
0x000000091100720cULL, 0x080fe40003f46070ULL, 0x000000091300720cULL, 0x000fc40003f26070ULL,
0x0000002c250d7810ULL, 0x004fe20007ffe0ffULL, 0x000000010a0c7824ULL, 0x000fc600078e0203ULL,
0x000000090d00720cULL, 0x040fe20003f86070ULL, 0x000000080d187824ULL, 0x000fe200078e00ffULL,
0x0000000b07107210ULL, 0x002fe20007f1e0ffULL, 0x000000080a0e7824ULL, 0x000fe200078e00ffULL,
0x00000030250f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0a7824ULL, 0x000fe200078e0203ULL,
0x00005e00100b7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x000000090f00720cULL, 0x080fe20003f66070ULL, 0x00000001080d7824ULL, 0x000fe200078e020dULL,
0x000000091900720cULL, 0x000fc40003f06070ULL, 0xfffffff80e097812ULL, 0x000fe200078ee20cULL,
0x000000010f0c7824ULL, 0x040fe200078e0203ULL, 0xfffffff8180e7812ULL, 0x000fe200078ee20aULL,
0x000000080f187824ULL, 0x000fe200078e00ffULL, 0x00005f0010107a11ULL, 0x000fe200030f4412ULL,
0x00000001080f7824ULL, 0x000fe200078e020fULL, 0x0000000b260a7210ULL, 0x000fe20007fde0ffULL,
0x0000000111127824ULL, 0x100fe400078e0203ULL, 0x0000001009097824ULL, 0x000fe400078e0206ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0610ULL, 0x0000000d071b7210ULL, 0x000fe20007fde0ffULL,
0x00000001130d7824ULL, 0x000fe200078e0203ULL, 0xfffffff818107812ULL, 0x000fe200078ee20cULL,
0x0000000108117824ULL, 0x040fe200078e0211ULL, 0x000000000a097faeULL, 0x0003e2000e901c46ULL,
0x000000ffff1c7224ULL, 0x000fe200030e06ffULL, 0x00005e001b1a7a11ULL, 0x040fe200078c40ffULL,
0x0000000108137824ULL, 0x000fe200078e0213ULL, 0xfffffff81e187812ULL, 0x000fe200078ee20dULL,
0x0000000108087824ULL, 0x000fe200078e0219ULL, 0x00005f001b0d7a11ULL, 0x000fe200030f441cULL,
0x0000000119037824ULL, 0x040fe200078e0203ULL, 0x0000001a260c7210ULL, 0x000fe20007fde0ffULL,
0x00000008191b7824ULL, 0x000fe200078e00ffULL, 0x0000001107117210ULL, 0x000fe20007fbe0ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0206ULL, 0xfffffff81d127812ULL, 0x000fe200078ee212ULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0000000f071a7210ULL, 0x000fe20007fde0ffULL,
0x0000001010107824ULL, 0x100fe200078e0206ULL, 0xfffffff81b037812ULL, 0x000fe200078ee203ULL,
0x0000001012127824ULL, 0x100fe200078e0206ULL, 0x000000000c0e7faeULL, 0x0005e2000e101c46ULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0x00005e001a0f7a11ULL, 0x000fe200078c40ffULL,
0x0000001018187824ULL, 0x100fe200078e0206ULL, 0x0000001307137210ULL, 0x000fe20007f9e0ffULL,
0x0000001003037824ULL, 0x000fe200078e0206ULL, 0x00005f001a197a11ULL, 0x000fc600030f4419ULL,
0x000000ffff0b7224ULL, 0x002fe200020e06ffULL, 0x00005e00130a7a11ULL, 0x000fe400078840ffULL,
0x00000008070d7210ULL, 0x004fe20007fde0ffULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x00005e0011087a11ULL, 0x000fe400078a40ffULL, 0x00005f00130b7a11ULL, 0x000fe200020f440bULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005f00110e7a11ULL, 0x000fe400028f440eULL,
0x0000000f26067210ULL, 0x000fc40007fbe0ffULL, 0x00005e000d0c7a11ULL, 0x040fe400078c40ffULL,
0x0000000a260a7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0619ULL,
0x0000000826087210ULL, 0x040fe40007fbe0ffULL, 0x00005f000d0d7a11ULL, 0x000fe200030f4409ULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x0000000006107faeULL, 0x0003e2000d901c46ULL,
0x000000ffff097224ULL, 0x000fe200028e060eULL, 0x0000000c260c7210ULL, 0x000fc80007fbe0ffULL,
0x0000000008127faeULL, 0x0003e2000d101c46ULL, 0x000000ffff0d7224ULL, 0x000fc600028e060dULL,
0x000000000a187faeULL, 0x0003e8000c901c46ULL, 0x000000000c037faeULL, 0x0003e2000c101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x0000000c030f7811ULL, 0x04afe400078fe8ffULL,
0x00000008030d7811ULL, 0x040fe400078fe8ffULL, 0x00000004030b7811ULL, 0x000fe200078fe8ffULL,
0x000000010f107824ULL, 0x100fe200078e0203ULL, 0x0000001003117811ULL, 0x000fe200078fe8ffULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0x0000001c031b7811ULL, 0x000fe200078fe8ffULL,
0x000000010d0a7824ULL, 0x100fe200078e0203ULL, 0x0000001803197811ULL, 0x000fe200078fe8ffULL,
0x000000080d0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff813107812ULL, 0x000fe200078ee210ULL,
0x000000010b097824ULL, 0x100fe200078e0203ULL, 0x0000001403137811ULL, 0x000fe200078fe8ffULL,
0x000000080b0c7824ULL, 0x000fe200078e00ffULL, 0x00000020031d7811ULL, 0x000fe200078fe8ffULL,
0x0000000111127824ULL, 0x040fe200078e0203ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20aULL,
0x0000000811187824ULL, 0x000fe200078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL,
0x000000011b1c7824ULL, 0x100fe200078e0203ULL, 0x0000002803217811ULL, 0x000fe200078fe8ffULL,
0x000000081b1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff818127812ULL, 0x000fe200078ee212ULL,
0x00000001190a7824ULL, 0x100fe200078e0203ULL, 0x0000002c03237811ULL, 0x000fe200078fe8ffULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x0000000113097824ULL, 0x100fe200078e0203ULL, 0x00000024031f7811ULL, 0x000fe200078fe8ffULL,
0x0000000813187824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20aULL,
0x000000011d1e7824ULL, 0x000fe200078e0203ULL, 0x0000003003257811ULL, 0x000fe200078fe8ffULL,
0x000000081d207824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x00000001210a7824ULL, 0x100fe200078e0203ULL, 0x00000038032e7811ULL, 0x000fe200078fe8ffULL,
0x0000000821227824ULL, 0x000fe200078e00ffULL, 0xfffffff8201e7812ULL, 0x000fe200078ee21eULL,
0x000000011f097824ULL, 0x100fe200078e0203ULL, 0x0000003c03307811ULL, 0x000fe200078fe8ffULL,
0x000000081f207824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20aULL,
0x0000000123247824ULL, 0x000fe200078e0203ULL, 0x00000003030a7211ULL, 0x000fe200078fe8ffULL,
0x0000000823277824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x0000000125267824ULL, 0x100fe200078e0203ULL, 0x0000000803097211ULL, 0x000fe200078fe8ffULL,
0x00000008252d7824ULL, 0x000fe200078e00ffULL, 0xfffffff827247812ULL, 0x000fe200078ee224ULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x0000003403277811ULL, 0x000fe200078fe8ffULL,
0x0000000108317824ULL, 0x000fe200078e0230ULL, 0x000000070a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000830377824ULL, 0x000fe200078e00ffULL, 0x00000009074b7210ULL, 0x000fe20007f1e0ffULL,
0x00000001080b7824ULL, 0x000fe200078e020bULL, 0xfffffff82d267812ULL, 0x000fe200078ee226ULL,
0x00000001272d7824ULL, 0x100fe200078e0203ULL, 0x0ffffff80a0a7812ULL, 0x100fe200078ef803ULL,
0x0000000130037824ULL, 0x000fe200078e0203ULL, 0x00000070064c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x00005e004b4a7a11ULL, 0x000fe200078040ffULL,
0x00000001080d7824ULL, 0x040fe200078e020dULL, 0xfffffff837377812ULL, 0x000fe200078ee203ULL,
0x0000000108117824ULL, 0x040fe200078e0211ULL, 0x00005f004b4b7a11ULL, 0x000fe200000f4430ULL,
0x00000001080f7824ULL, 0x040fe200078e020fULL, 0x0000000b070b7210ULL, 0x040fe20007f1e0ffULL,
0x0000000108137824ULL, 0x040fe200078e0213ULL, 0x0000000d070d7210ULL, 0x040fe20007f3e0ffULL,
0x0000000108197824ULL, 0x040fe200078e0219ULL, 0x0000001107117210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x0000000f07457210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff477224ULL, 0x000fe200008e06ffULL, 0x00005e000b487a11ULL, 0x000fe200078040ffULL,
0x000000ffff437224ULL, 0x000fe200018e06ffULL, 0x00005e000d467a11ULL, 0x000fe200078240ffULL,
0x00000001081d7824ULL, 0x040fe200078e021dULL, 0x00005e00110f7a11ULL, 0x000fe200078640ffULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x00005e0045447a11ULL, 0x000fe200078440ffULL,
0x00000001081b7824ULL, 0x040fe200078e021bULL, 0x00005f000b497a11ULL, 0x000fe200000f4449ULL,
0x0000000827327824ULL, 0x000fe200078e00ffULL, 0x00005f000d477a11ULL, 0x000fe200008f4447ULL,
0x00000001081f7824ULL, 0x040fe200078e021fULL, 0x00005f0011437a11ULL, 0x000fe200018f4443ULL,
0x0000000108257824ULL, 0x040fe200078e0225ULL, 0x0000001307427210ULL, 0x000fe20007f1e0ffULL,
0x0000000108217824ULL, 0x040fe200078e0221ULL, 0x00005f0045457a11ULL, 0x000fe200010f4403ULL,
0x0000000108097824ULL, 0x040fe200078e0227ULL, 0x0000001907417210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x0000001d071d7210ULL, 0x040fe20007f7e0ffULL,
0x0000000108237824ULL, 0x000fe200078e0223ULL, 0x0000001b07407210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x00005e0042117a11ULL, 0x000fe200078040ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x00005e0041137a11ULL, 0x000fe200078240ffULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x00005e001d1b7a11ULL, 0x000fe200078640ffULL,
0x0000000108277824ULL, 0x000fe200078e022eULL, 0x00005e0040197a11ULL, 0x000fe200078440ffULL,
0x000000082e2e7824ULL, 0x000fe200078e00ffULL, 0x00005f0042427a11ULL, 0x000fc400000f440dULL,
0xfffffff832087812ULL, 0x000fe400078ee22dULL, 0x00005f0041417a11ULL, 0x000fe400008f440bULL,
0x00005f001d3f7a11ULL, 0x000fe400018f443fULL, 0x00002000020d7811ULL, 0x000fe400078e70ffULL,
0x00005f0040407a11ULL, 0x000fe400010f4403ULL, 0x0000001f071f7210ULL, 0x040fe20007f7e0ffULL,
0x0000001008357824ULL, 0x100fe200078e020dULL, 0x00000025073b7210ULL, 0x040fe20007f3e0ffULL,
0x0000001022327824ULL, 0x100fe200078e020dULL, 0x00000021073d7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x00000023073c7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x0000000907097210ULL, 0x040fe20007f7e0ffULL,
0x000000101e307824ULL, 0x100fe200078e020dULL, 0x0000002707397210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00005e003b227a11ULL, 0x000fe200078240ffULL,
0x000000100a037824ULL, 0x000fe200078e020dULL, 0x00005e003d1e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee22fULL,
0x0000001024337824ULL, 0x100fe200078e020dULL, 0x0000003107077210ULL, 0x000fe20007fbe0ffULL,
0x0000001020317824ULL, 0x100fe200078e020dULL, 0x00005f003b3b7a11ULL, 0x000fe200008f4408ULL,
0x0000001026347824ULL, 0x000fe200078e020dULL, 0x00005e003c207a11ULL, 0x000fe200078040ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005f003d3d7a11ULL, 0x000fe200010f440bULL,
0x000000ffff087224ULL, 0x000fe200020e06ffULL, 0x00005e0009247a11ULL, 0x000fe200078240ffULL,
0x000000102e367824ULL, 0x100fe200078e020dULL, 0x00005e0039267a11ULL, 0x000fe200078440ffULL,
0x000000ffff387224ULL, 0x000fe200028e06ffULL, 0x00005e001f1d7a11ULL, 0x000fe200078c40ffULL,
0x000000100e217824ULL, 0x100fe200078e020dULL, 0x00005e00072e7a11ULL, 0x000fe200078640ffULL,
0x0000001010237824ULL, 0x100fe200078e020dULL, 0x00005f003c3c7a11ULL, 0x000fe200000f440aULL,
0x0000001012257824ULL, 0x100fe200078e020dULL, 0x0000004a4c067210ULL, 0x000fe20007f1e0ffULL,
0x0000001018277824ULL, 0x100fe200078e020dULL, 0x00005f00093a7a11ULL, 0x000fe200008f443aULL,
0x000000101a2d7824ULL, 0x100fe200078e020dULL, 0x00005f0039397a11ULL, 0x000fe200010f4408ULL,
0x000000101c2f7824ULL, 0x100fe200078e020dULL, 0x00005f001f3e7a11ULL, 0x000fe200030f443eULL,
0x000000100c1f7824ULL, 0x100fe200078e020dULL, 0x000000484c087210ULL, 0x040fe20007f3e0ffULL,
0x0000001037377824ULL, 0x000fe200078e020dULL, 0x00005f0007387a11ULL, 0x000fe200018f4438ULL,
0x000000ffff077224ULL, 0x000fe200000e064bULL, 0x000000464c0a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0649ULL, 0x000000444c0c7210ULL, 0x000fc40007f7e0ffULL,
0x0000000f4c0e7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e0647ULL,
0x000000114c107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e0645ULL,
0x000000134c127210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e0643ULL,
0x000000194c187210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0642ULL,
0x0000001b4c1a7210ULL, 0x040fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e2000b901c46ULL, 0x0000001d4c1c7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0641ULL, 0x0000001e4c1e7210ULL, 0x040fe20007fbe0ffULL,
0x00000000081f7faeULL, 0x0005e2000b901c46ULL, 0x000000204c207210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0640ULL, 0x000000224c227210ULL, 0x040fe20007f1e0ffULL,
0x000000000a217faeULL, 0x0007e2000b901c46ULL, 0x000000244c247210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e063fULL, 0x000000264c267210ULL, 0x040fe20007f5e0ffULL,
0x000000000c237faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1d7224ULL, 0x000fe200018e063eULL,
0x0000002e4c2e7210ULL, 0x000fc40007f7e0ffULL, 0x000000000e257faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1f7224ULL, 0x004fc600028e063dULL, 0x0000000010277faeULL, 0x0005e2000b901c46ULL,
0x000000ffff217224ULL, 0x008fc600020e063cULL, 0x00000000122d7faeULL, 0x0007e2000b901c46ULL,
0x000000ffff237224ULL, 0x002fc600000e063bULL, 0x00000000182f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff257224ULL, 0x000fc600008e063aULL, 0x000000001a307faeULL, 0x0007e2000b901c46ULL,
0x000000ffff277224ULL, 0x004fc600010e0639ULL, 0x000000001c317faeULL, 0x0007e8000b901c46ULL,
0x000000001e327faeULL, 0x0007e2000b901c46ULL, 0x000000ffff2f7224ULL, 0x002fc600018e0638ULL,
0x0000000020337faeULL, 0x0007e8000b901c46ULL, 0x0000000022347faeULL, 0x0007e8000b901c46ULL,
0x0000000024357faeULL, 0x0007e8000b901c46ULL, 0x0000000026367faeULL, 0x0007e8000b901c46ULL,
0x000000002e377faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01860400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002002037824ULL, 0x002fca00078e0203ULL, 0x00000003ff047819ULL, 0x000fe40000011603ULL,
0x0000000f03037812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x0000000103057810ULL, 0x040fe20007ffe0ffULL, 0x0000002003097824ULL, 0x040fe400078e00ffULL,
0x0000000103067824ULL, 0x040fe400078e0204ULL, 0x0000000104077824ULL, 0x040fe200078e0205ULL,
0x0000001004047810ULL, 0x000fe20007ffe0ffULL, 0x0000002003087824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fc400078ec0ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000103107824ULL, 0x000fe200078e0204ULL, 0x000001e008067812ULL, 0x000fe200078ee206ULL,
0x0000000105047824ULL, 0x000fe200078e0204ULL, 0x000001e009077812ULL, 0x000fe200078ee207ULL,
0x0000002003057824ULL, 0x040fe200078e00ffULL, 0x0000001f10107812ULL, 0x000fe200078ec0ffULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000002003037824ULL, 0x000fe200078e00ffULL,
0x0000001f04047812ULL, 0x000fe400078ec0ffULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000001e005107812ULL, 0x000fc400078ee210ULL, 0x000001e003047812ULL, 0x000fe200078ee204ULL,
0x000000ffff187224ULL, 0x002fe400078e000cULL, 0x000000ffff197224ULL, 0x000fe400078e000eULL,
0x000000ffff1b7224ULL, 0x00cfe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff087224ULL, 0x000fe200078e000dULL,
0x0000001806007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff097224ULL, 0x000fca00078e000fULL,
0x0000000807007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x00000000100c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000aULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1c7224ULL, 0x004fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000001c10007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01860000ff087f8cULL, 0x002e62000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01860400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1600720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000064002b2b7a24ULL, 0x000fe200078e02ffULL, 0x00018688022d7811ULL, 0x000fe200078e18ffULL,
0x3d8000002c2c7820ULL, 0x010fe20000410000ULL, 0xffffffff162e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00018608022f7811ULL, 0x000fca00078e28ffULL,
0x0000010030327824ULL, 0x000fe200078e022aULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000321400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e0031ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x0000000133367810ULL, 0x000fe20007ffe0ffULL, 0x00001ae000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fc400078e0033ULL, 0x0000003036317211ULL, 0x000fe200078ff8ffULL,
0x00000029284c7224ULL, 0x010fe200078e02ffULL, 0x000000023600780cULL, 0x000fe20003f06070ULL,
0x000000ffff337224ULL, 0x000fe200078e0036ULL, 0x0000000131377810ULL, 0x040fe20007ffe0ffULL,
0x0000010031527824ULL, 0x020fe200078e022aULL, 0x0000000135317812ULL, 0x000fe400078e0cffULL,
0x000000163700720cULL, 0x000fe40003f26070ULL, 0x00000040524d7812ULL, 0x000fc400078ec0ffULL,
0x0000000136667812ULL, 0x000fc600078ec0ffULL, 0x00000001004d7824ULL, 0x000fcc00078e024dULL,
0x00000da000009947ULL, 0x000fea0003800000ULL, 0x0000005214367217ULL, 0x000fe20007800000ULL,
0x0000000866537824ULL, 0x000fe200078e00ffULL, 0x00000003ff587819ULL, 0x002fe20000011603ULL,
0x0000000202547824ULL, 0x000fe400078e0231ULL, 0x0000000136527824ULL, 0x000fe200078e0a52ULL,
0x0000000458377810ULL, 0x040fe20007ffe0ffULL, 0x0000000158367824ULL, 0x040fe200078e024dULL,
0x0000000858397810ULL, 0x040fe40007ffe0ffULL, 0x000000523700720cULL, 0x040fe20003f86070ULL,
0x0000000137387824ULL, 0x040fe200078e0203ULL, 0x0000000c58557810ULL, 0x000fe20007ffe0ffULL,
0x0000000837577824ULL, 0x040fe200078e00ffULL, 0x000000364c3b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000137377824ULL, 0x000fe200078e024dULL, 0x000000523900720cULL, 0x040fe20003fa6070ULL,
0x00000001393a7824ULL, 0x000fe200078e0203ULL, 0xfffffff857577812ULL, 0x000fe200078ee238ULL,
0x0000000839597824ULL, 0x040fe200078e00ffULL, 0x0000001058567810ULL, 0x000fe20007ffe0ffULL,
0x0000000139367824ULL, 0x100fe200078e024dULL, 0x000000374c397210ULL, 0x040fe20007f5e0ffULL,
0x0000000155377824ULL, 0x000fe200078e024dULL, 0xfffffff859597812ULL, 0x000fe200078ee23aULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x000000364c387210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x000000374c377210ULL, 0x000fe20007fde0ffULL,
0x00000001555a7824ULL, 0x100fe200078e0203ULL, 0x00005e00394e7a11ULL, 0x000fe200078440ffULL,
0x00000008555d7824ULL, 0x000fe200078e00ffULL, 0x00005e003b487a11ULL, 0x000fe200078240ffULL,
0x000000ffff367224ULL, 0x000fe200030e06ffULL, 0x00005f00394f7a11ULL, 0x000fe200010f443aULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x00005e0037447a11ULL, 0x000fe200078440ffULL,
0x00000001565b7824ULL, 0x040fe200078e0203ULL, 0x00005f003b497a11ULL, 0x000fe200008f443cULL,
0x0000000856677824ULL, 0x040fe200078e00ffULL, 0x00005f0037457a11ULL, 0x000fe200010f4436ULL,
0x0000000156367824ULL, 0x000fe200078e024dULL, 0x00005e0038507a11ULL, 0x000fc400078240ffULL,
0x00000014585c7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0038517a11ULL, 0x000fe400008f4439ULL,
0x000000364c397210ULL, 0x000fe20007f3e0ffULL, 0x000000015c377824ULL, 0x100fe200078e024dULL,
0x00000018585e7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c585f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e06ffULL, 0x000000374c3a7210ULL, 0x000fe20007f5e0ffULL,
0x000000015e387824ULL, 0x100fe200078e024dULL, 0x00005e00394a7a11ULL, 0x000fe200078240ffULL,
0x000000015f377824ULL, 0x000fe200078e024dULL, 0x0000002058607810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3c7224ULL, 0x000fe200010e06ffULL, 0x00005f00394b7a11ULL, 0x000fc400008f443dULL,
0x00005e003a367a11ULL, 0x000fe400078440ffULL, 0x000000384c3b7210ULL, 0x040fe40007f7e0ffULL,
0x000000374c397210ULL, 0x000fe40007fde0ffULL, 0x00005f003a377a11ULL, 0x000fe200010f443cULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078240ffULL,
0x000000ffff3c7224ULL, 0x000fe200030e06ffULL, 0x00005e0039387a11ULL, 0x000fc400078440ffULL,
0x0000002458617810ULL, 0x000fe40007ffe0ffULL, 0x00005f003b3b7a11ULL, 0x000fe400008f443dULL,
0x00005f0039397a11ULL, 0x000fe200010f443cULL, 0x00000001603c7824ULL, 0x100fe200078e024dULL,
0x0000002c58637810ULL, 0x040fe20007ffe0ffULL, 0x00000001613d7824ULL, 0x000fe200078e024dULL,
0x0000002858627810ULL, 0x000fe40007ffe0ffULL, 0x0000003c4c437210ULL, 0x000fc40007f3e0ffULL,
0x0000003d4c3e7210ULL, 0x000fe20007f5e0ffULL, 0x00000001633d7824ULL, 0x100fe200078e024dULL,
0x0000003058647810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x000fe200008e06ffULL,
0x00005e0043427a11ULL, 0x040fe200078240ffULL, 0x00000001623c7824ULL, 0x000fe200078e024dULL,
0x0000003d4c3d7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff417224ULL, 0x000fe200010e06ffULL,
0x00005e003e407a11ULL, 0x000fe400078440ffULL, 0x00005f0043437a11ULL, 0x000fe200008f4446ULL,
0x000000ffff467224ULL, 0x000fe200030e06ffULL, 0x0000003c4c3f7210ULL, 0x000fc40007f7e0ffULL,
0x00005f003e417a11ULL, 0x000fe400010f4441ULL, 0x00005e003d3c7a11ULL, 0x000fe200078440ffULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x00005e003f3e7a11ULL, 0x000fe400078240ffULL,
0x00005f003d3d7a11ULL, 0x000fe200010f4446ULL, 0x0000000158467824ULL, 0x000fe200078e0203ULL,
0x00005f003f3f7a11ULL, 0x000fe400008f4447ULL, 0x000000525500720cULL, 0x000fc40003f26070ULL,
0x0000000746477812ULL, 0x000fe200078ec0ffULL, 0x0000000164467824ULL, 0x000fe200078e024dULL,
0x000000525800720cULL, 0x000fe40003f66070ULL, 0x0ffffff847557812ULL, 0x100fe400078ef803ULL,
0x000000464c477210ULL, 0x000fe40007fde0ffULL, 0x000000525600720cULL, 0x000fe40003f46070ULL,
0xfffffff853537812ULL, 0x000fe200078ee203ULL, 0x000000ffff567224ULL, 0x000fe200030e06ffULL,
0x0000200054547811ULL, 0x000fc400078e68ffULL, 0x0000003458657810ULL, 0x000fe20007ffe0ffULL,
0x0000001053487825ULL, 0x000fe200078e0048ULL, 0x00005e0047467a11ULL, 0x000fe400078c40ffULL,
0xfffffff85d5a7812ULL, 0x000fe200078ee25aULL, 0x0000001055557824ULL, 0x000fe200078e0254ULL,
0x00005f0047477a11ULL, 0x000fe200030f4456ULL, 0x0000000165567824ULL, 0x000fe200078e024dULL,
0xfffffff8675b7812ULL, 0x000fe200078ee25bULL, 0x00000010534e7825ULL, 0x000fe200078e004eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048557faeULL, 0x0003e2000d901c46ULL,
0x000000525c00720cULL, 0x000fc40003f66070ULL, 0x0000001053507825ULL, 0x000fc800078e0050ULL,
0x0000001053447825ULL, 0x000fc800078e0044ULL, 0x00000010534a7825ULL, 0x000fe200078e004aULL,
0x000000564c497210ULL, 0x002fc60007fde0ffULL, 0x0000001057557824ULL, 0x100fe400078e0254ULL,
0x000000ffff577224ULL, 0x000fe200030e06ffULL, 0x00005e0049487a11ULL, 0x000fe200078c40ffULL,
0x0000001059567824ULL, 0x000fe200078e0254ULL, 0x000000004e557faeULL, 0x0003e2000e101c46ULL,
0x000000015c5d7824ULL, 0x040fe200078e0203ULL, 0x00005f0049497a11ULL, 0x000fe200030f4457ULL,
0x000000085c5c7824ULL, 0x000fe200078e00ffULL, 0x0000003858577810ULL, 0x040fe20007ffe0ffULL,
0x0000000050567faeULL, 0x0005e2000e901c46ULL, 0x0000003c58587810ULL, 0x000fe20007ffe0ffULL,
0x0000001053367825ULL, 0x000fe200078e0036ULL, 0x000000525e00720cULL, 0x000fc40003fa6070ULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee25dULL, 0x00000010533a7825ULL, 0x000fc800078e003aULL,
0x00000001574e7824ULL, 0x102fe400078e024dULL, 0x00000001584f7824ULL, 0x000fe400078e024dULL,
0x000000105a4d7824ULL, 0x100fe200078e0254ULL, 0x0000004e4c517210ULL, 0x004fe20007f9e0ffULL,
0x000000105b507824ULL, 0x000fe400078e0254ULL, 0x000000015e567824ULL, 0x000fe200078e0203ULL,
0x00005e00514e7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff557224ULL, 0x000fe200020e06ffULL,
0x0000004f4c4c7210ULL, 0x000fe20007f9e0ffULL, 0x00000000444d7faeULL, 0x0003e2000c901c46ULL,
0x000000085e5e7824ULL, 0x000fe200078e00ffULL, 0x000000526000720cULL, 0x000fe20003f26070ULL,
0x0000001053387825ULL, 0x000fe200078e0038ULL, 0x000000004a507faeULL, 0x0005e2000d101c46ULL,
0x00005f00514f7a11ULL, 0x000fc400030f4455ULL, 0x000000525f00720cULL, 0x000fe20003f46070ULL,
0x0000000161517824ULL, 0x000fe200078e0203ULL, 0xfffffff85e567812ULL, 0x000fe200078ee256ULL,
0x0000001053427825ULL, 0x000fe200078e0042ULL, 0x00005e004c447a11ULL, 0x002fc600078c40ffULL,
0x000000085f4d7824ULL, 0x040fe400078e00ffULL, 0x000000015f4a7824ULL, 0x104fe400078e0203ULL,
0x00000001604b7824ULL, 0x040fe400078e0203ULL, 0x0000000860507824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee24aULL, 0x000000ffff457224ULL, 0x000fe200020e06ffULL,
0x000000526100720cULL, 0x0c0fe20003f86070ULL, 0x0000000861617824ULL, 0x000fe200078e00ffULL,
0xfffffff850507812ULL, 0x000fe200078ee24bULL, 0x000000105d4a7824ULL, 0x100fe200078e0254ULL,
0x00005f004c457a11ULL, 0x000fe200030f4445ULL, 0x00000010564b7824ULL, 0x100fe200078e0254ULL,
0xfffffff861517812ULL, 0x000fe200078ee251ULL, 0x000000104d4c7824ULL, 0x100fe200078e0254ULL,
0x00000000364a7faeULL, 0x0003e2000d901c46ULL, 0x00000010504d7824ULL, 0x100fe200078e0254ULL,
0x000000526400720cULL, 0x080fe20003f66070ULL, 0x0000001051507824ULL, 0x000fe200078e0254ULL,
0x000000003a4b7faeULL, 0x0005e2000e901c46ULL, 0x0000001053407825ULL, 0x000fe200078e0040ULL,
0x000000525700720cULL, 0x000fc40003fa6070ULL, 0x00000000384c7faeULL, 0x0007e2000d101c46ULL,
0x000000526300720cULL, 0x080fe20003f46070ULL, 0x00000010533e7825ULL, 0x000fe200078e003eULL,
0x000000525800720cULL, 0x080fe20003fc6070ULL, 0x00000000424d7faeULL, 0x0009e2000c901c46ULL,
0x000000526200720cULL, 0x0c0fe20003f26070ULL, 0x0000000162367824ULL, 0x142fe400078e0203ULL,
0x0000000862627824ULL, 0x000fe200078e00ffULL, 0x0000000040507faeULL, 0x0003e2000e101c46ULL,
0x0000000163377824ULL, 0x100fe200078e0203ULL, 0x000000526500720cULL, 0x000fe20003f86070ULL,
0x0000000863637824ULL, 0x000fe200078e00ffULL, 0xfffffff862367812ULL, 0x000fe200078ee236ULL,
0x0000000164387824ULL, 0x008fc400078e0203ULL, 0x0000000864647824ULL, 0x000fe200078e00ffULL,
0xfffffff863377812ULL, 0x000fe200078ee237ULL, 0x0000000165397824ULL, 0x140fe400078e0203ULL,
0x0000000865657824ULL, 0x000fe200078e00ffULL, 0xfffffff864387812ULL, 0x000fe200078ee238ULL,
0x00000001573a7824ULL, 0x044fe400078e0203ULL, 0x0000000857427824ULL, 0x010fe200078e00ffULL,
0xfffffff865397812ULL, 0x000fe200078ee239ULL, 0x00000001583b7824ULL, 0x000fc400078e0203ULL,
0x0000000858437824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee23aULL,
0x00000010363a7824ULL, 0x000fe400078e0254ULL, 0x00000010533c7825ULL, 0x000fe200078e003cULL,
0xfffffff843437812ULL, 0x000fe400078ee23bULL, 0x000000003e3a7faeULL, 0x0005e2000c901c46ULL,
0x00000010373b7824ULL, 0x100fe400078e0254ULL, 0x0000001038407824ULL, 0x002fc400078e0254ULL,
0x0000001053467825ULL, 0x000fe200078e0046ULL, 0x000000003c3b7faeULL, 0x0005e6000d101c46ULL,
0x0000001039417824ULL, 0x000fe200078e0254ULL, 0x0000000046407faeULL, 0x0005e2000d901c46ULL,
0x0000001053487825ULL, 0x000fc800078e0048ULL, 0x0000001042427824ULL, 0x000fe200078e0254ULL,
0x0000000048417faeULL, 0x0005e2000e101c46ULL, 0x0000001053367825ULL, 0x000fc800078e004eULL,
0x0000001043547824ULL, 0x000fe200078e0254ULL, 0x0000000036427faeULL, 0x0005e2000e901c46ULL,
0x0000001053387825ULL, 0x000fca00078e0044ULL, 0x0000000038547faeULL, 0x0005e2000f101c46ULL,
0x00000c6000007947ULL, 0x000fea0003800000ULL, 0x0000000403377811ULL, 0x042fe200078fe8ffULL,
0x00000008666b7824ULL, 0x000fe200078e00ffULL, 0x0000000c033d7811ULL, 0x040fe400078fe8ffULL,
0x00000010033e7811ULL, 0x000fe200078fe8ffULL, 0x0000000137367824ULL, 0x100fe200078e0203ULL,
0x0000001803467811ULL, 0x000fe200078fe8ffULL, 0x0000000837577824ULL, 0x000fe200078e00ffULL,
0x0000001c03477811ULL, 0x000fe200078fe8ffULL, 0x000000013d397824ULL, 0x100fe200078e0203ULL,
0x0000002403497811ULL, 0x000fe200078fe8ffULL, 0x000000083d597824ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee236ULL, 0x000000013e367824ULL, 0x040fe200078e0203ULL,
0x00000008033c7811ULL, 0x000fe200078fe8ffULL, 0x000000083e5a7824ULL, 0x000fe200078e00ffULL,
0xfffffff859597812ULL, 0x000fe200078ee239ULL, 0x0000000146397824ULL, 0x140fe200078e0203ULL,
0x0000002803507811ULL, 0x000fe200078fe8ffULL, 0x00000008465c7824ULL, 0x000fe200078e00ffULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee236ULL, 0x0000000147367824ULL, 0x000fe200078e0203ULL,
0x0000003003527811ULL, 0x000fe200078fe8ffULL, 0x00000008475d7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee239ULL, 0x0000000149397824ULL, 0x100fe200078e0203ULL,
0x00000014033f7811ULL, 0x000fe200078fe8ffULL, 0x00000008495f7824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL, 0x000000013c387824ULL, 0x040fe200078e0203ULL,
0x0000002003487811ULL, 0x000fe200078fe8ffULL, 0x000000083c587824ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee239ULL, 0x0000000150367824ULL, 0x140fe200078e0203ULL,
0x0000002c03517811ULL, 0x040fe200078fe8ffULL, 0x0000000850607824ULL, 0x000fe200078e00ffULL,
0xfffffff858587812ULL, 0x000fe200078ee238ULL, 0x0000000152397824ULL, 0x140fe200078e0203ULL,
0x0000003803547811ULL, 0x000fe200078fe8ffULL, 0x0000000852627824ULL, 0x000fe200078e00ffULL,
0xfffffff860607812ULL, 0x000fe200078ee236ULL, 0x000000013f387824ULL, 0x000fe200078e0203ULL,
0x0000004d03367211ULL, 0x000fe200078fe8ffULL, 0x000000083f5b7824ULL, 0x000fe200078e00ffULL,
0xfffffff862627812ULL, 0x000fe200078ee239ULL, 0x00000008485e7824ULL, 0x000fe200078e00ffULL,
0x000000364c397210ULL, 0x000fe20007f3e0ffULL, 0x0000000137367824ULL, 0x000fe200078e024dULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee238ULL, 0x0000000148387824ULL, 0x100fe200078e0203ULL,
0x0000003403537811ULL, 0x000fe200078fe8ffULL, 0x0000000851617824ULL, 0x040fe200078e00ffULL,
0x000000364c377210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e06ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee238ULL, 0x0000000151387824ULL, 0x100fe200078e0203ULL,
0x0000003c03657811ULL, 0x000fe200078fe8ffULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078440ffULL, 0x0000000154417824ULL, 0x140fe200078e0203ULL,
0xfffffff861617812ULL, 0x000fe200078ee238ULL, 0x0000000854647824ULL, 0x000fe200078e00ffULL,
0x00005e0039387a11ULL, 0x000fe200078240ffULL, 0x0000000153407824ULL, 0x000fe200078e0203ULL,
0x00005f0037377a11ULL, 0x000fe200010f443aULL, 0x000000013c3a7824ULL, 0x000fe200078e024dULL,
0x00005f0039397a11ULL, 0x000fe200008f443bULL, 0x000000013e3c7824ULL, 0x000fe200078e024dULL,
0xfffffff864647812ULL, 0x000fe200078ee241ULL, 0x000000013d3b7824ULL, 0x100fe200078e024dULL,
0x0000003a4c417210ULL, 0x040fe20007f5e0ffULL, 0x000000013f3d7824ULL, 0x000fe200078e024dULL,
0x0000003c4c437210ULL, 0x040fe20007f9e0ffULL, 0x0000000853637824ULL, 0x000fe200078e00ffULL,
0x0000003b4c3f7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff457224ULL, 0x000fe200010e06ffULL,
0x0000003d4c3b7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200020e06ffULL,
0xfffffff863637812ULL, 0x000fe200078ee240ULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x00005e00433c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff427224ULL, 0x000fe200008e06ffULL,
0x00005e0041407a11ULL, 0x000fc400078440ffULL, 0x00005e003f3e7a11ULL, 0x000fe400078640ffULL,
0x00005e003b3a7a11ULL, 0x000fe400078240ffULL, 0x00005f00433d7a11ULL, 0x000fe200020f443dULL,
0x0000000147437824ULL, 0x000fe200078e024dULL, 0x00005f0041417a11ULL, 0x000fe200010f4445ULL,
0x0000000149457824ULL, 0x100fe200078e024dULL, 0x00005f003f3f7a11ULL, 0x000fe200018f4444ULL,
0x0000000148447824ULL, 0x100fe200078e024dULL, 0x00005f003b3b7a11ULL, 0x000fe200008f4442ULL,
0x0000000146427824ULL, 0x000fe200078e024dULL, 0x000000434c477210ULL, 0x000fc40007f7e0ffULL,
0x000000454c437210ULL, 0x040fe40007f3e0ffULL, 0x000000424c497210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x000000444c4b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200008e06ffULL, 0x00005e0043427a11ULL, 0x000fe200078240ffULL,
0x000000ffff4f7224ULL, 0x000fe200010e06ffULL, 0x00005e0049487a11ULL, 0x000fe200078440ffULL,
0x000000ffff457224ULL, 0x000fe200020e06ffULL, 0x00005e0047467a11ULL, 0x000fc400078640ffULL,
0x00005e004b447a11ULL, 0x000fe400078840ffULL, 0x00005f0043437a11ULL, 0x000fe200008f444aULL,
0x00000001504a7824ULL, 0x000fe200078e024dULL, 0x00005f0049497a11ULL, 0x000fe200010f444fULL,
0x00000001534f7824ULL, 0x100fe200078e024dULL, 0x00005f0047477a11ULL, 0x000fe200018f444eULL,
0x00000001524e7824ULL, 0x000fe200078e024dULL, 0x00005f004b457a11ULL, 0x000fe200020f4445ULL,
0x00000001514b7824ULL, 0x100fe200078e024dULL, 0x0000000303567211ULL, 0x000fe200078fe8ffULL,
0x0000000154507824ULL, 0x100fe200078e024dULL, 0x0000004a4c547210ULL, 0x040fe20007fde0ffULL,
0x00000001654d7824ULL, 0x000fe200078e024dULL, 0x0000004b4c527210ULL, 0x000fc40007fbe0ffULL,
0x0000004e4c6a7210ULL, 0x040fe20007f9e0ffULL, 0x00000008654e7824ULL, 0x040fe200078e00ffULL,
0x0000004f4c517210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200030e06ffULL,
0x000000504c537210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200020e06ffULL,
0x0000004d4c557210ULL, 0x000fe20007f7e0ffULL, 0x00000002024c7824ULL, 0x000fe200078e0231ULL,
0x0000000756567812ULL, 0x000fe200078ec0ffULL, 0x00000001654d7824ULL, 0x100fe200078e0203ULL,
0xfffffff86b6b7812ULL, 0x100fe200078ee203ULL, 0x000000ffff697224ULL, 0x000fe200008e06ffULL,
0x000020004c657811ULL, 0x000fe200078e68ffULL, 0x000000ffff687224ULL, 0x000fe200010e06ffULL,
0x0ffffff856567812ULL, 0x000fe200078ef803ULL, 0x000000106b387825ULL, 0x000fe200078e0038ULL,
0xfffffff84e4e7812ULL, 0x000fc400078ee24dULL, 0x00005e00544a7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff4d7224ULL, 0x000fe200028e06ffULL, 0x00005e00524c7a11ULL, 0x000fe200078a40ffULL,
0x0000001056567824ULL, 0x100fe200078e0265ULL, 0x00005e0051507a11ULL, 0x000fe200078240ffULL,
0x0000001057577824ULL, 0x000fe200078e0265ULL, 0x00005f00524d7a11ULL, 0x000fe200028f444dULL,
0x0000001058587824ULL, 0x000fe200078e0265ULL, 0x00005f00544b7a11ULL, 0x000fe200030f444bULL,
0x0000001059597824ULL, 0x100fe200078e0265ULL, 0x00005e0053527a11ULL, 0x000fe200078440ffULL,
0x000000105a5a7824ULL, 0x100fe200078e0265ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038567faeULL, 0x0003e2000b901c46ULL, 0x000000105b5b7824ULL, 0x000fe200078e0265ULL,
0x00005f0051517a11ULL, 0x000fe200008f4469ULL, 0x000000105c5c7824ULL, 0x100fe200078e0265ULL,
0x00005f0053537a11ULL, 0x000fe200010f4468ULL, 0x000000105d5d7824ULL, 0x000fc400078e0265ULL,
0x000000105e5e7824ULL, 0x100fe400078e0265ULL, 0x000000105f5f7824ULL, 0x100fe400078e0265ULL,
0x0000001060607824ULL, 0x100fe400078e0265ULL, 0x0000001061617824ULL, 0x100fe400078e0265ULL,
0x0000001062627824ULL, 0x100fe400078e0265ULL, 0x0000001063637824ULL, 0x000fc400078e0265ULL,
0x0000001064647824ULL, 0x000fe400078e0265ULL, 0x000000106b367825ULL, 0x000fc800078e0036ULL,
0x000000104e657824ULL, 0x000fe200078e0265ULL, 0x00005e006a4e7a11ULL, 0x040fe200078840ffULL,
0x000000106b407825ULL, 0x040fe200078e0040ULL, 0x0000000036577faeULL, 0x0005e4000b901c46ULL,
0x00005f006a4f7a11ULL, 0x000fe200020f444fULL, 0x000000106b3e7825ULL, 0x040fe200078e003eULL,
0x0000000040587faeULL, 0x0005e6000b901c46ULL, 0x000000106b3c7825ULL, 0x000fe200078e003cULL,
0x000000003e597faeULL, 0x0005e6000b901c46ULL, 0x000000ffff677224ULL, 0x000fe200018e06ffULL,
0x00005e0055547a11ULL, 0x000fe200078640ffULL, 0x000000106b3a7825ULL, 0x000fe200078e003aULL,
0x000000003c5a7faeULL, 0x0005e4000b901c46ULL, 0x00005f0055557a11ULL, 0x000fe200018f4467ULL,
0x000000106b487825ULL, 0x040fe200078e0048ULL, 0x000000003a5b7faeULL, 0x0005e6000b901c46ULL,
0x000000106b467825ULL, 0x040fe200078e0046ULL, 0x00000000485c7faeULL, 0x0005e6000b901c46ULL,
0x000000106b447825ULL, 0x040fe200078e0044ULL, 0x00000000465d7faeULL, 0x0005e6000b901c46ULL,
0x000000106b427825ULL, 0x040fe200078e0042ULL, 0x00000000445e7faeULL, 0x0005e6000b901c46ULL,
0x000000106b387825ULL, 0x042fe200078e004aULL, 0x00000000425f7faeULL, 0x0005e6000b901c46ULL,
0x000000106b4a7825ULL, 0x040fe200078e004cULL, 0x0000000038607faeULL, 0x0005e6000b901c46ULL,
0x000000106b4c7825ULL, 0x040fe200078e004eULL, 0x000000004a617faeULL, 0x0005e6000b901c46ULL,
0x000000106b4e7825ULL, 0x040fe200078e0050ULL, 0x000000004c627faeULL, 0x0005e6000b901c46ULL,
0x000000106b507825ULL, 0x040fe200078e0052ULL, 0x000000004e637faeULL, 0x0005e6000b901c46ULL,
0x000000106b527825ULL, 0x000fe200078e0054ULL, 0x0000000050647faeULL, 0x0005e8000b901c46ULL,
0x0000000052657faeULL, 0x0005e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6600720cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000009947ULL, 0x000fea0003800000ULL, 0x0000000217177810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff287424ULL, 0x000fc600078e00ffULL, 0x000000151700720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000022b367824ULL, 0x004fe400078e0217ULL,
0x00000004ff377424ULL, 0x000fc800078e00ffULL, 0x0000600036367625ULL, 0x000fca00078e0037ULL,
0x0000000636287981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002003457810ULL, 0x044fe20007ffe0ffULL,
0x0000000202357824ULL, 0x000fe200078e0235ULL, 0x0000000703367812ULL, 0x042fe200078ec0ffULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0xfffffff803447812ULL, 0x000fe400078ec0ffULL,
0xfffffff845457812ULL, 0x000fe400078ec0ffULL, 0x0000200035357811ULL, 0x000fe400078e68ffULL,
0x0000000836367812ULL, 0x000fc400078ef803ULL, 0x0000000744447812ULL, 0x100fe400078ef803ULL,
0x0000000745457812ULL, 0x000fe200078ef803ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000144387824ULL, 0x160fe200078e0237ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000844397824ULL, 0x000fe400078e00ffULL, 0x00000001453c7824ULL, 0x040fe400078e0237ULL,
0x00000008453d7824ULL, 0x000fe200078e00ffULL, 0xfffffff839387812ULL, 0x000fc800078ee238ULL,
0xfffffff83d3c7812ULL, 0x000fe200078ee23cULL, 0x0000001038387824ULL, 0x000fc800078e0235ULL,
0x000000103c3c7824ULL, 0x000fe400078e0235ULL, 0x000000003838783bULL, 0x000e680000000200ULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x00000018ff407819ULL, 0x002fe20000011438ULL,
0x0001000038417824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001143aULL,
0x0000004000537306ULL, 0x0003e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fc4000001143bULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff497819ULL, 0x004fe4000001143cULL,
0x00000018ff487819ULL, 0x000fe2000001143dULL, 0x0000004100527306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x002fe40000011439ULL, 0x00000018ff477819ULL, 0x000fe4000001143eULL,
0x00000018ff467819ULL, 0x000fc6000001143fULL, 0x0000004000577306ULL, 0x0003f00000200c00ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000888038407816ULL, 0x042fe200000000ffULL,
0x0000010038387824ULL, 0x000fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000004000517306ULL, 0x0002b00000200c00ULL, 0x0000003800547306ULL, 0x0006e20000200c00ULL,
0x0000888039407816ULL, 0x002fc400000000ffULL, 0x0000541051527816ULL, 0x004fc60000000052ULL,
0x000000ffff387224ULL, 0x008fe400078e0040ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x0001000039407824ULL, 0x040fe400078e00ffULL, 0x0000010039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003800557306ULL, 0x0003e20000200c00ULL, 0x0000541054537816ULL, 0x000fce0000000053ULL,
0x0000003900587306ULL, 0x0004e20000200c00ULL, 0x000088803a387816ULL, 0x002fce00000000ffULL,
0x0000003800597306ULL, 0x0003e20000200c00ULL, 0x000100003a397824ULL, 0x044fe400078e00ffULL,
0x000001003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000004000567306ULL, 0x000ea20000200c00ULL,
0x000088803b387816ULL, 0x002fe400000000ffULL, 0x0000541058577816ULL, 0x008fca0000000057ULL,
0x00000039005a7306ULL, 0x0002f00000200c00ULL, 0x0000003a005b7306ULL, 0x0007e20000200c00ULL,
0x000100003b397824ULL, 0x002fe200078e00ffULL, 0x0000541055567816ULL, 0x004fe20000000056ULL,
0x000001003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x00000038005c7306ULL, 0x0003e20000200c00ULL,
0x00000001373a7810ULL, 0x008fe40007ffe0ffULL, 0x00005410595a7816ULL, 0x000fca000000005aULL,
0x00000039005d7306ULL, 0x0004e20000200c00ULL, 0x000088803c387816ULL, 0x002fce00000000ffULL,
0x0000003b005e7306ULL, 0x0002e20000200c00ULL, 0x000100003c397824ULL, 0x044fe400078e00ffULL,
0x000001003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x00000008443b7824ULL, 0x002fe200078e00ffULL,
0x0000003900607306ULL, 0x0003e20000200c00ULL, 0x000054105c5c7816ULL, 0x008fe4000000005dULL,
0x000054105e5d7816ULL, 0x000fca000000004bULL, 0x00000038005f7306ULL, 0x0004e20000200c00ULL,
0x0000000144397824ULL, 0x102fe400078e023aULL, 0x00000001453a7824ULL, 0x000fc600078e023aULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee239ULL, 0x000100003d397824ULL, 0x040fe200078e00ffULL,
0x0000003c00617306ULL, 0x0003e20000200c00ULL, 0x000088803d387816ULL, 0x044fe200000000ffULL,
0x000001003d3d7824ULL, 0x000fe400078e00ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0235ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003800627306ULL, 0x0005e20000200c00ULL, 0x000000003b40783bULL, 0x000ea20000000200ULL,
0x000088803f3c7816ULL, 0x002fc400000000ffULL, 0x000054105f607816ULL, 0x008fc80000000060ULL,
0x0000003900637306ULL, 0x0002e20000200c00ULL, 0x000088803e387816ULL, 0x004fce00000000ffULL,
0x0000003c00687306ULL, 0x000fe20000200c00ULL, 0x0000000845397824ULL, 0x002fca00078e00ffULL,
0xfffffff8393a7812ULL, 0x000fe200078ee23aULL, 0x000100003e397824ULL, 0x040fe200078e00ffULL,
0x0000003d00647306ULL, 0x0002a20000200c00ULL, 0x000001003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000541062627816ULL, 0x008fe20000000063ULL, 0x000000103a3a7824ULL, 0x000fe200078e0235ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003800657306ULL, 0x000fe20000200c00ULL, 0x000100003f3d7824ULL, 0x002fc400078e00ffULL,
0x000001003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003e00677306ULL, 0x0003e20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe40000011440ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000888042737816ULL, 0x000fe400000000ffULL,
0x00000018ff507819ULL, 0x000fe20000011443ULL, 0x0000003c006d7306ULL, 0x0007e20000200c00ULL,
0x00000008343e7824ULL, 0x002fe200078e0237ULL, 0x0000541064637816ULL, 0x004fc40000000048ULL,
0x0000000237377810ULL, 0x000fc80007ffe0ffULL, 0x0000003d00697306ULL, 0x0002a20000200c00ULL,
0x00000018ff3c7819ULL, 0x008fe40000011441ULL, 0x000000083700780cULL, 0x000fca0003f25270ULL,
0x0000003c00717306ULL, 0x0007e20000200c00ULL, 0x00010000403d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003f006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3c7819ULL, 0x008fe40000011442ULL, 0x0000541068687816ULL, 0x004fca0000000069ULL,
0x0000003c00757306ULL, 0x0005e20000200c00ULL, 0x00008880413f7816ULL, 0x002fce00000000ffULL,
0x0000003d006c7306ULL, 0x000fe20000200c00ULL, 0x00008880403c7816ULL, 0x004fce00000000ffULL,
0x0000003c006b7306ULL, 0x0002b00000200c00ULL, 0x0000003900667306ULL, 0x0006a20000200c00ULL,
0x00000100403c7824ULL, 0x002fe400078e00ffULL, 0x000000023e407824ULL, 0x000fc400078e00ffULL,
0x00000020363e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143cULL,
0x00000040033c7211ULL, 0x000fe200078fe0ffULL, 0x000000003a38783bULL, 0x008e620000000200ULL,
0x0000003d006e7306ULL, 0x0006e20000200c00ULL, 0x0000000240407810ULL, 0x000fe40007ffe0ffULL,
0x00000001363c7824ULL, 0x000fe200078e023cULL, 0x000054106b6c7816ULL, 0x004fe4000000006cULL,
0x0000004003407211ULL, 0x000fc400078fe0ffULL, 0xffffffe03e3c7812ULL, 0x000fe200078ee23cULL,
0x00010000413e7824ULL, 0x000fe200078e00ffULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x000000ffff3d7224ULL, 0x008fe200078e003fULL, 0x0000541065667816ULL, 0x000fe20000000066ULL,
0x000000103c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000010041417824ULL, 0x000fe200078e00ffULL, 0x000054106e6d7816ULL, 0x000fe2000000006dULL,
0x0000000136407824ULL, 0x000fe200078e0240ULL, 0x0000003d006f7306ULL, 0x000fe40000200c00ULL,
0x00000018ff417819ULL, 0x000fcc0000011441ULL, 0x0000003e00707306ULL, 0x0006620000200c00ULL,
0x000054105b5b7816ULL, 0x004fce000000004fULL, 0x0000004100727306ULL, 0x0004a20000200c00ULL,
0x000000003c3c783bULL, 0x008ee20000000200ULL, 0x00000018ff4d7819ULL, 0x002fe40000011439ULL,
0x000088803a487816ULL, 0x000fc800000000ffULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x000000ffff417224ULL, 0x004fe200078e0073ULL, 0x00000018ff4e7819ULL, 0x000fe20000011438ULL,
0x0001000042737824ULL, 0x040fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001143aULL,
0x0000010042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001143bULL,
0x0000004100747306ULL, 0x0005e20000200c00ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff427819ULL, 0x000fc40000011442ULL, 0x000054106f707816ULL, 0x000fe40000000070ULL,
0x0000541072717816ULL, 0x000fe20000000071ULL, 0x0000004200767306ULL, 0x0002e20000200c00ULL,
0x0000888043417816ULL, 0x004fe400000000ffULL, 0x0000541061617816ULL, 0x002fca0000000049ULL,
0x0000004100777306ULL, 0x0003e20000200c00ULL, 0x0001000043427824ULL, 0x040fe400078e00ffULL,
0x0000010043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000004700477306ULL, 0x000ea20000200c00ULL, 0x0000888038417816ULL, 0x002fe200000000ffULL,
0x000000523c24723cULL, 0x008b620000001824ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000541076757816ULL, 0x000fc60000000075ULL, 0x0000004600467306ULL, 0x000e620000200c00ULL,
0x0000888039527816ULL, 0x060fe200000000ffULL, 0x000000563c20723cULL, 0x040f680000001820ULL,
0x000000ffff4b7224ULL, 0x000fe400078e0052ULL, 0x0000004100517306ULL, 0x0007e20000200c00ULL,
0x0001000039527824ULL, 0x000fe200078e00ffULL, 0x0000541067677816ULL, 0x004fe20000000047ULL,
0x0000010039397824ULL, 0x000fe200078e00ffULL, 0x0000005a3c1c723cULL, 0x000fe2000000181cULL,
0x000100003a477824ULL, 0x040fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x000001003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000004200787306ULL, 0x0004a20000200c00ULL,
0x0000002036417824ULL, 0x008fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc40000011439ULL,
0x000054106a697816ULL, 0x002fe20000000046ULL, 0x0000005c3c18723cULL, 0x040f620000001818ULL,
0xffffffe041407812ULL, 0x000fe200078ee240ULL, 0x0000010038417824ULL, 0x040fe200078e00ffULL,
0x0000004300797306ULL, 0x000fe20000200c00ULL, 0x0001000038427824ULL, 0x004fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000001040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x000000603c10723cULL, 0x000f620000001810ULL,
0x00000018ff427819ULL, 0x000fc40000011442ULL, 0x00000041004f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000541077787816ULL, 0x000fe40000000078ULL,
0x000000623c0c723cULL, 0x040f66000000180cULL, 0x0000004200387306ULL, 0x0002aa0000200c00ULL,
0x000000663c08723cULL, 0x040f660000001808ULL, 0x0000003900537306ULL, 0x0007e20000200c00ULL,
0x000000004040783bULL, 0x002e680000000200ULL, 0x000000683c04723cULL, 0x000b660000001804ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000000ffff397224ULL, 0x008fe200078e0048ULL,
0x0000541051387816ULL, 0x004fc40000000038ULL, 0x000100003b3c7824ULL, 0x020fc800078e00ffULL,
0x0000003900487306ULL, 0x0005e20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fce000001143cULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000088803b397816ULL, 0x044fe200000000ffULL,
0x000001003b3b7824ULL, 0x000fe200078e00ffULL, 0x0000541079797816ULL, 0x002fc80000000050ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x00000039003d7306ULL, 0x000e700000200c00ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x0000006c4024723cULL, 0x040b6e0000001824ULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x000054103d3c7816ULL, 0x002fe2000000003cULL,
0x000000704020723cULL, 0x040b6c0000001820ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000054104f397816ULL, 0x004fe2000000004eULL, 0x000000784018723cULL, 0x040b6c0000001818ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000541053537816ULL, 0x008fe2000000004dULL,
0x000000384010723cULL, 0x000b6c0000001810ULL, 0x0000007300737306ULL, 0x000e700000200c00ULL,
0x0000004b004b7306ULL, 0x000ff00000200c00ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x0000541074747816ULL, 0x002fce0000000073ULL, 0x0000004700477306ULL, 0x000e620000200c00ULL,
0x00000074401c723cULL, 0x000b6e000000181cULL, 0x0000003a003a7306ULL, 0x000ee20000200c00ULL,
0x000054104b527816ULL, 0x004fce0000000052ULL, 0x0000003b003b7306ULL, 0x000ea20000200c00ULL,
0x0000541048487816ULL, 0x002fe20000000047ULL, 0x00000052400c723cULL, 0x000b62000000180cULL,
0x000054103a497816ULL, 0x008fce000000004cULL, 0x000000484008723cULL, 0x000b620000001808ULL,
0x000054103b3d7816ULL, 0x004fce000000004aULL, 0x0000003c4004723cULL, 0x000b620000001804ULL,
0xfffff03000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff357224ULL, 0x000fe200078e0031ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd37000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000002c1a357220ULL, 0x0a0fe40000410000ULL, 0x0000002c1e337220ULL, 0x080fe40000410000ULL,
0x0000002c1b367220ULL, 0x080fe40000410000ULL, 0x0000002c101a7220ULL, 0x080fe40000410000ULL,
0x0000002c1c1c7220ULL, 0x000fc40000410000ULL, 0x0000002c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000002c1f347220ULL, 0x080fe40000410000ULL, 0x0000002c111b7220ULL, 0x080fe40000410000ULL,
0x0000002c0c1e7220ULL, 0x080fe40000410000ULL, 0x0000002c24247220ULL, 0x080fe40000410000ULL,
0x0000002c25257220ULL, 0x000fc40000410000ULL, 0x0000002c20207220ULL, 0x080fe40000410000ULL,
0x0000002c21217220ULL, 0x080fe40000410000ULL, 0x0000002c18187220ULL, 0x080fe40000410000ULL,
0x0000002c19197220ULL, 0x080fe40000410000ULL, 0x0000002c0d1f7220ULL, 0x080fe40000410000ULL,
0x0000002c08087220ULL, 0x000fc40000410000ULL, 0x0000002c09097220ULL, 0x080fe40000410000ULL,
0x0000002c04047220ULL, 0x080fe40000410000ULL, 0x0000002c12377220ULL, 0x080fe40000410000ULL,
0x0000002c13387220ULL, 0x080fe40000410000ULL, 0x0000002c0e397220ULL, 0x080fe40000410000ULL,
0x0000002c0f3a7220ULL, 0x000fc40000410000ULL, 0x000000ffff127224ULL, 0x000fe400078e001aULL,
0x0000002c0a3b7220ULL, 0x080fe40000410000ULL, 0x0000002c0b3c7220ULL, 0x000fe40000410000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e001cULL, 0x000000ffff0f7224ULL, 0x000fe400078e001dULL,
0x000000ffff137224ULL, 0x000fc400078e001bULL, 0x000000ffff1a7224ULL, 0x000fe400078e001eULL,
0x0000002c26267220ULL, 0x080fe40000410000ULL, 0x0000002c27277220ULL, 0x080fe40000410000ULL,
0x0000002c22227220ULL, 0x080fe40000410000ULL, 0x0000002c23237220ULL, 0x080fe40000410000ULL,
0x0000002c05057220ULL, 0x000fc40000410000ULL, 0x0000002c06067220ULL, 0x080fe40000410000ULL,
0x0000002c07077220ULL, 0x000fe40000410000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0024ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0025ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0021ULL, 0x000000ffff107224ULL, 0x000fe400078e0018ULL,
0x000000ffff117224ULL, 0x000fe400078e0019ULL, 0x000000ffff1b7224ULL, 0x000fe400078e001fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002d087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fc400078e0026ULL,
0x000000ffff217224ULL, 0x000fe400078e0027ULL, 0x000000ffff247224ULL, 0x000fe400078e0033ULL,
0x000000ffff257224ULL, 0x000fe400078e0034ULL, 0x000000ffff267224ULL, 0x000fe400078e0035ULL,
0x000000ffff277224ULL, 0x000fe400078e0036ULL, 0x000000ffff337224ULL, 0x000fc400078e0037ULL,
0x000000ffff347224ULL, 0x000fe400078e0038ULL, 0x000000ffff357224ULL, 0x000fe400078e0039ULL,
0x000000ffff367224ULL, 0x000fe400078e003aULL, 0x000000ffff1f7224ULL, 0x000fe400078e0005ULL,
0x000000ffff377224ULL, 0x000fe400078e003bULL, 0x000000ffff387224ULL, 0x000fc400078e003cULL,
0x000000ffff397224ULL, 0x000fe400078e0006ULL, 0x000000ffff3a7224ULL, 0x000fc400078e0007ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x000004002d067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604187210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000001806067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000119197810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004002d067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403197824ULL, 0x000fe200078e00ffULL,
0x0000002e3000720cULL, 0x000fc80003f05270ULL, 0xfffffff019187812ULL, 0x000fca00078ec0ffULL,
0x0000008002187824ULL, 0x000fca00078e0218ULL, 0x0184000018047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000203087824ULL, 0x000fe400078e00ffULL,
0x0000000114327824ULL, 0x000fc600078e0a32ULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108097812ULL, 0x040fe400078efcffULL, 0x00000008083b7812ULL, 0x040fe400078efcffULL,
0x000000320900720cULL, 0x080fe40003f26070ULL, 0x0000001008097812ULL, 0x000fe400078efcffULL,
0x000000323b00720cULL, 0x080fe40003f06070ULL, 0x000000320900720cULL, 0x000fc40003fc6070ULL,
0x00000011083b7812ULL, 0x040fe400078efcffULL, 0x0000001808097812ULL, 0x040fe400078efcffULL,
0x000000320800720cULL, 0x0c0fe40003f46070ULL, 0x000000323b00720cULL, 0x080fe40003fa6070ULL,
0x000000320900720cULL, 0x000fe40003f66070ULL, 0x00000009083c7812ULL, 0x000fc400078efcffULL,
0x00000019083b7812ULL, 0x040fe400078efcffULL, 0x0000002008097812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40005000000ULL, 0xff8000000a0a7808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0xff8000000b0b7808ULL, 0x000fc40004800000ULL,
0x000000323c00720cULL, 0x080fe40003f86070ULL, 0x000000323b00720cULL, 0x080fe40003f46070ULL,
0x000000320900720cULL, 0x000fe40003f26070ULL, 0x00000021083b7812ULL, 0x040fe400078efcffULL,
0x0000002808097812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fc40004000000ULL,
0xff8000000c0c7808ULL, 0x000fe40004000000ULL, 0xff80000023237808ULL, 0x000fe40006000000ULL,
0xff8000000d0d7808ULL, 0x000fe40006000000ULL, 0x000000323b00720cULL, 0x080fe40003f06070ULL,
0x000000320900720cULL, 0x000fe40003f86070ULL, 0x00000029083b7812ULL, 0x000fc400078efcffULL,
0x0000003008097812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40007000000ULL,
0xff8000000e0e7808ULL, 0x000fe40007000000ULL, 0xff80000025257808ULL, 0x000fe40006800000ULL,
0xff8000000f0f7808ULL, 0x000fe40006800000ULL, 0x000000323b00720cULL, 0x000fc40003fc6070ULL,
0x000000320900720cULL, 0x000fe40003fa6070ULL, 0x00000031083b7812ULL, 0x040fe400078efcffULL,
0x0000003808097812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff80000026267808ULL, 0x000fe40005800000ULL, 0xff80000010107808ULL, 0x000fc40005800000ULL,
0xff80000027277808ULL, 0x000fe40005000000ULL, 0xff80000011117808ULL, 0x000fe40005000000ULL,
0xff80000033337808ULL, 0x000fe40004800000ULL, 0xff80000012127808ULL, 0x000fe40004800000ULL,
0x000000323b00720cULL, 0x080fe40003f66070ULL, 0x000000320900720cULL, 0x000fc40003f46070ULL,
0x000000320800720cULL, 0x000fe40003f26070ULL, 0xff80000034347808ULL, 0x000fe40004000000ULL,
0xff80000013137808ULL, 0x000fe40004000000ULL, 0xff80000035357808ULL, 0x000fe40006000000ULL,
0xff8000001a1a7808ULL, 0x000fe40006000000ULL, 0xff80000036367808ULL, 0x000fc40007000000ULL,
0xff8000001b1b7808ULL, 0x000fe40007000000ULL, 0xff80000037377808ULL, 0x000fe40006800000ULL,
0xff8000001c1c7808ULL, 0x000fe40006800000ULL, 0xff80000038387808ULL, 0x000fe40005800000ULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff80000039397808ULL, 0x000fc40005000000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff8000003a3a7808ULL, 0x000fe40004800000ULL,
0xff8000001f1f7808ULL, 0x000fc40004800000ULL, 0x0000000a0400720bULL, 0x004fe40003f1e000ULL,
0x000000200500720bULL, 0x000fe40003f3e000ULL, 0x000000040a047208ULL, 0x000fe40004000000ULL,
0x0000000520057208ULL, 0x000fc40004800000ULL, 0x0000000b0400720bULL, 0x000fe40003f1e000ULL,
0x000000210500720bULL, 0x000fe40003f3e000ULL, 0x000000040b047208ULL, 0x000fe40004000000ULL,
0x0000000521057208ULL, 0x000fe40004800000ULL, 0x0000000c0400720bULL, 0x000fe40003f1e000ULL,
0x000000220500720bULL, 0x000fc40003f3e000ULL, 0x000000040c047208ULL, 0x000fe40004000000ULL,
0x0000000522057208ULL, 0x000fe40004800000ULL, 0x0000000d0400720bULL, 0x000fe40003f1e000ULL,
0x000000230500720bULL, 0x000fe40003f3e000ULL, 0x000000040d047208ULL, 0x000fe40004000000ULL,
0x0000000523057208ULL, 0x000fc40004800000ULL, 0x0000000e0400720bULL, 0x000fe40003f1e000ULL,
0x000000240500720bULL, 0x000fe40003f3e000ULL, 0x000000040e047208ULL, 0x000fe40004000000ULL,
0x0000000524057208ULL, 0x000fe40004800000ULL, 0x0000000f0400720bULL, 0x000fe40003f1e000ULL,
0x000000250500720bULL, 0x000fc40003f3e000ULL, 0x000000040f047208ULL, 0x000fe40004000000ULL,
0x0000000525057208ULL, 0x000fe40004800000ULL, 0x000000100400720bULL, 0x000fe40003f1e000ULL,
0x000000260500720bULL, 0x000fe40003f3e000ULL, 0x0000000410047208ULL, 0x000fe40004000000ULL,
0x0000000526057208ULL, 0x000fc40004800000ULL, 0x000000110400720bULL, 0x000fe40003f1e000ULL,
0x000000270500720bULL, 0x000fe40003f3e000ULL, 0x0000000411047208ULL, 0x000fe40004000000ULL,
0x0000000527057208ULL, 0x000fe40004800000ULL, 0x000000120400720bULL, 0x000fe40003f1e000ULL,
0x000000330500720bULL, 0x000fc40003f3e000ULL, 0x0000000412047208ULL, 0x000fe40004000000ULL,
0x0000000533057208ULL, 0x000fe40004800000ULL, 0x000000130400720bULL, 0x000fe40003f1e000ULL,
0x000000340500720bULL, 0x000fe40003f3e000ULL, 0x0000000413047208ULL, 0x000fe40004000000ULL,
0x0000000534057208ULL, 0x000fc40004800000ULL, 0x0000001a0400720bULL, 0x000fe40003f1e000ULL,
0x000000350500720bULL, 0x000fe40003f3e000ULL, 0x000000041a047208ULL, 0x000fe40004000000ULL,
0x0000000535057208ULL, 0x000fe40004800000ULL, 0x0000001b0400720bULL, 0x000fe40003f1e000ULL,
0x000000360500720bULL, 0x000fc40003f3e000ULL, 0x000000041b047208ULL, 0x000fe40004000000ULL,
0x0000000536057208ULL, 0x000fe40004800000ULL, 0x0000001c0400720bULL, 0x000fe40003f1e000ULL,
0x000000370500720bULL, 0x000fe40003f3e000ULL, 0x000000041c047208ULL, 0x000fe40004000000ULL,
0x0000000537057208ULL, 0x000fc40004800000ULL, 0x0000001d0400720bULL, 0x000fe40003f1e000ULL,
0x000000380500720bULL, 0x000fe40003f3e000ULL, 0x000000041d047208ULL, 0x000fe40004000000ULL,
0x0000000538057208ULL, 0x000fe40004800000ULL, 0x0000001e0400720bULL, 0x000fe40003f1e000ULL,
0x000000390500720bULL, 0x000fc40003f3e000ULL, 0x000000041e047208ULL, 0x000fe40004000000ULL,
0x0000000539057208ULL, 0x000fe40004800000ULL, 0x0000001f0400720bULL, 0x000fe40003f1e000ULL,
0x0000003a0500720bULL, 0x000fe40003f3e000ULL, 0x000000041f3c7208ULL, 0x000fe40004000000ULL,
0x000000053a057208ULL, 0x000fe20004800000ULL, 0x00001b427f007947ULL, 0x000fec000b800000ULL,
0x0c401f003c047f89ULL, 0x0004e400000e0000ULL, 0x000000043c00720bULL, 0x008fc80003f1e000ULL,
0x0000003c043c7208ULL, 0x004fe20004000000ULL, 0x00001b827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006087f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007097f89ULL, 0x000e6200000e0000ULL, 0x000000040500720bULL, 0x004fc40003f1e000ULL,
0x000000080600720bULL, 0x008fe40003f3e000ULL, 0x0000000504057208ULL, 0x000fe40004000000ULL,
0x0000000608067208ULL, 0x000fe20004800000ULL, 0x0c201f003c047f89ULL, 0x000ea200000e0000ULL,
0x000000090700720bULL, 0x002fc60003f1e000ULL, 0x0c201f0005087f89ULL, 0x000e6200000e0000ULL,
0x0000000709077208ULL, 0x000fc60004000000ULL, 0x0c201f0006327f89ULL, 0x000ee800000e0000ULL,
0x0c201f00073b7f89ULL, 0x0002e200000e0000ULL, 0x000000043c00720bULL, 0x004fe40003f1e000ULL,
0x000000080500720bULL, 0x002fe40003f3e000ULL, 0x0000003c04047208ULL, 0x000fe40004000000ULL,
0x000000320600720bULL, 0x008fc40003f5e000ULL, 0x0000000508057208ULL, 0x000fe40004800000ULL,
0x0000000632067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3c003c00ff447424ULL, 0x000fe200078e00ffULL,
0x0000000c19197812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010808ULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010808ULL,
0x0000003b0700720bULL, 0x004fe20003f3e000ULL, 0x0000001c003f7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0b0b7823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010808ULL,
0x000000073b077208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010808ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b051c7820ULL, 0x002fe40000410000ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fe40000010808ULL,
0x3fb8aa3b21217823ULL, 0x000fc4000001081cULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081cULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b20207823ULL, 0x000fe4000001081cULL, 0x3fb8aa3b10107823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010808ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12127823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010808ULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b1f087823ULL, 0x000fc40000010808ULL,
0x3c003c00ff457424ULL, 0x000fe200078e00ffULL, 0x0000002000097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b24247823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b25257823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x3fb8aa3b33337823ULL, 0x000fc4000001081cULL,
0x3fb8aa3b34347823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b35357823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001081cULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b37377823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b38387823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b39397823ULL, 0x000fc4000001081cULL, 0x3fb8aa3b3a3a7823ULL, 0x000fe2000001081cULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x000000092109723eULL, 0x002fce00000000ffULL,
0x0000000800427308ULL, 0x0003f00000000800ULL, 0x0000001000327308ULL, 0x000fe20000000800ULL,
0x0000000a0b08723eULL, 0x002fe400000000ffULL, 0x0000000c0d0a723eULL, 0x000fc400000000ffULL,
0x00000022230b723eULL, 0x004fc600000000ffULL, 0x00000011003c7308ULL, 0x000ff00000000800ULL,
0x00000012003d7308ULL, 0x000ff00000000800ULL, 0x00000013003e7308ULL, 0x0003f00000000800ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x000000440810723cULL, 0x002f6e00000018ffULL,
0x0000000f000f7308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x0000000e0f0c723eULL, 0x002fc400000000ffULL,
0x000000323c0e723eULL, 0x000fe400000000ffULL, 0x00000002ff3c7819ULL, 0x000fc60000011603ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000013c207810ULL, 0x040fe40007ffe0ffULL,
0x000000023c217810ULL, 0x040fe40007ffe0ffULL, 0x000000063c327810ULL, 0x000fc60007ffe0ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x00000024250d723eULL, 0x004fe200000000ffULL,
0x000000083c247824ULL, 0x040fe400078e00ffULL, 0x000000083c257824ULL, 0x000fc600078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee220ULL, 0x0000001d00407308ULL, 0x000fe20000000800ULL,
0xfffffff825257812ULL, 0x000fe400078ee221ULL, 0x00000026270f723eULL, 0x002fca00000000ffULL,
0x0000001e00417308ULL, 0x0003e20000000800ULL, 0x000000083c267824ULL, 0x040fe400078e00ffULL,
0x000000083c277824ULL, 0x000fca00078e00ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000440c1c723cULL, 0x022b6e0000001810ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x000000033c107810ULL, 0x060fe40007ffe0ffULL, 0x000000043c117810ULL, 0x000fc40007ffe0ffULL,
0xfffffff826267812ULL, 0x000fe400078ee210ULL, 0xfffffff827277812ULL, 0x000fe200078ee211ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x0000003d3e10723eULL, 0x000fce00000000ffULL,
0x0000003400347308ULL, 0x000ea20000000800ULL, 0x0000001a1b12723eULL, 0x002fe200000000ffULL,
0x000000083c1a7824ULL, 0x040fe200078e00ffULL, 0x000000053c1b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee23cULL, 0x0000003500357308ULL, 0x000ff00000000800ULL,
0x0000003600367308ULL, 0x000e620000000800ULL, 0x000000333411723eULL, 0x004fc400000000ffULL,
0x000000083c347810ULL, 0x040fe40007ffe0ffULL, 0xffffffff3c337810ULL, 0x000fc60007ffe0ffULL,
0x0000003700377308ULL, 0x000fe20000000800ULL, 0x000000353613723eULL, 0x002fce00000000ffULL,
0x0000003800387308ULL, 0x000e620000000800ULL, 0x000000083c357824ULL, 0x040fe400078e00ffULL,
0x000000083c367824ULL, 0x040fe400078e00ffULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x000000441020723cULL, 0x000b62000000181cULL, 0xfffffff8351b7812ULL, 0x000fe200078ee21bULL,
0x0000003900397308ULL, 0x000fe20000000800ULL, 0x0001200002357811ULL, 0x000fe400078e58ffULL,
0xfffffff836327812ULL, 0x000fc400078ee232ULL, 0x00000008341c7824ULL, 0x020fe200078e00ffULL,
0x00000041421e723eULL, 0x000fe200000000ffULL, 0x000000101a1a7824ULL, 0x100fe200078e0235ULL,
0x0000003a003a7308ULL, 0x000ea20000000800ULL, 0x00000037381d723eULL, 0x002fe200000000ffULL,
0x0000001024247824ULL, 0x100fe200078e0235ULL, 0xfffffff81c347812ULL, 0x000fe200078ee234ULL,
0x0000001025257824ULL, 0x100fe200078e0235ULL, 0x0000003f401c723eULL, 0x000fe200000000ffULL,
0x0000001026267824ULL, 0x000fe200078e0235ULL, 0xfffffff83c337812ULL, 0x000fe200078ee233ULL,
0x0000001027277824ULL, 0x000fc400078e0235ULL, 0x000000011a1a7824ULL, 0x000fe400078e0219ULL,
0x000000101b1b7824ULL, 0x100fe400078e0235ULL, 0x0000000119247824ULL, 0x040fe200078e0224ULL,
0x000000081a007388ULL, 0x0003e20000000800ULL, 0x000000393a1f723eULL, 0x004fe200000000ffULL,
0x0000001032327824ULL, 0x000fe400078e0235ULL, 0x0000000119257824ULL, 0x000fe200078e0225ULL,
0x0000000a24007388ULL, 0x0003e20000000800ULL, 0x0000001033337824ULL, 0x000fc400078e0235ULL,
0x000000441c20723cULL, 0x000f620000001820ULL, 0x0000000119267824ULL, 0x040fe200078e0226ULL,
0x0000000c25007388ULL, 0x0003e20000000800ULL, 0x0000001034347824ULL, 0x000fe400078e0235ULL,
0x0000000119277824ULL, 0x040fe200078e0227ULL, 0x0000000e26007388ULL, 0x0003e20000000800ULL,
0x00000001191b7824ULL, 0x040fe400078e021bULL, 0x0000000119327824ULL, 0x040fe200078e0232ULL,
0x0000001027007388ULL, 0x0003e20000000800ULL, 0x0000000119337824ULL, 0x000fc400078e0233ULL,
0x0000000119347824ULL, 0x000fe200078e0234ULL, 0x000000121b007388ULL, 0x0003e80000000800ULL,
0x0000001c32007388ULL, 0x0003e80000000800ULL, 0x0000001e33007388ULL, 0x0003e40000000800ULL,
0x000000ffff217224ULL, 0x020fc400078e0022ULL, 0x0000000934007388ULL, 0x0003e80000000800ULL,
0x0004000b24007388ULL, 0x0003e80000000800ULL, 0x0004000d25007388ULL, 0x0003e80000000800ULL,
0x0004000f26007388ULL, 0x0003e80000000800ULL, 0x0004001127007388ULL, 0x0003e80000000800ULL,
0x000400131b007388ULL, 0x0003e80000000800ULL, 0x0004001d32007388ULL, 0x0003e80000000800ULL,
0x0004001f33007388ULL, 0x0003e80000000800ULL, 0x0180000418008388ULL, 0x0003e80000000c00ULL,
0x0182002018008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002fff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008002fff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010002fff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000130307810ULL, 0x000fe20007ffe0ffULL, 0x000018002fff7f8cULL, 0x0003e6000c80043fULL,
0x000000163000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb5f000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff427807ULL, 0x008fe20004000000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x00019ca000437802ULL, 0x000fc40000000f00ULL, 0x000013d000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0049ULL, 0xfffe83a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x000fe20005000000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x00019d0000437802ULL, 0x000fc40000000f00ULL, 0x0000137000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0049ULL, 0xfffe83d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x004fe200078e0026ULL, 0x00019d7000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x000012c000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff4c7224ULL, 0x004fe200078e0049ULL,
0xfffe845000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4d7224ULL, 0x000fe200078e0026ULL,
0x00019de000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x0000125000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff4c7224ULL, 0x004fe200078e0049ULL, 0xfffe855000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0023ULL, 0x00019e5000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x000011e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff217224ULL, 0x004fe200078e0049ULL,
0xfffe893000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0022ULL,
0x00019ec000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x0000117000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0049ULL, 0xfffe88f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0004ULL, 0x00019f4000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0005ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x000010f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x004fe200078e0049ULL, 0xfffea74000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0022ULL, 0x00019fc000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fe400078e0004ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x0000107000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0049ULL, 0xfffea6f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x008fe20004000000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x0001a02000437802ULL, 0x000fc40000000f00ULL, 0x0000105000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff467224ULL, 0x000fe200078e0049ULL, 0xfffec5f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x000fe20005000000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x0001a08000437802ULL, 0x000fc40000000f00ULL, 0x00000ff000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff477224ULL, 0x000fe200078e0049ULL, 0xfffec62000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0042ULL, 0x0001a0f000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x00000f4000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0049ULL,
0xfffec6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0042ULL,
0x0001a16000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x00000ed000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0049ULL, 0xfffec7b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0041ULL, 0x0001a1d000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x00000e6000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff217224ULL, 0x004fe200078e0049ULL,
0xfffecbd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0022ULL,
0x0001a24000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x00000df000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0049ULL, 0xfffecb9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e003cULL, 0x0001a2b000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x00000d8000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff217224ULL, 0x004fe200078e0049ULL,
0xfffee7e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0022ULL,
0x0001a32000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x00000d1000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0049ULL, 0xfffee7a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x004fe20004000000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x0001a38000437802ULL, 0x000fc40000000f00ULL, 0x00000cf000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e0049ULL, 0xffff051000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x000fe20005000000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x0001a3e000437802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff457224ULL, 0x000fe200078e0049ULL, 0xffff054000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0042ULL, 0x0001a45000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0049ULL,
0xffff05e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0042ULL,
0x0001a4c000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x00000b7000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0049ULL, 0xffff06d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x00cfe200078e001cULL, 0x0001a54000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fe400078e0041ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x004fe200078e0049ULL, 0xffff0ae000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0022ULL, 0x0001a5c000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x00cfe400078e001cULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x00000a7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0049ULL, 0xffff0a9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e001cULL, 0x0001a64000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e003cULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x000009f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x004fe200078e0049ULL, 0xffff26f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0022ULL, 0x0001a6c000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fe400078e001cULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x0000097000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0049ULL, 0xffff26a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x008fe20004000000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x0001a72000437802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0049ULL, 0xffff44c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x000fe20004800000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x0001a78000437802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff487224ULL, 0x000fe200078e0049ULL, 0xffff44f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e001fULL, 0x0001a7f000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff497424ULL, 0x000fc400078e00ffULL,
0x0000084000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e0049ULL,
0xffff459000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e001fULL,
0x0001a86000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x000007d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e0049ULL, 0xffff468000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x008fe200078e001cULL, 0x0001a8e000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fe400078e001fULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x0000075000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff217224ULL, 0x004fe200078e0049ULL, 0xffff4a9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0022ULL, 0x0001a96000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x008fe400078e001cULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x000006d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0049ULL, 0xffff4a4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e001cULL, 0x0001a9e000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e001eULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x0000065000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x004fe200078e0049ULL, 0xffff66d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0022ULL, 0x0001aa6000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fe400078e001cULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff497424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0049ULL, 0xffff668000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e003cULL, 0x0001aae000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fc400078e00ffULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fc400078e00ffULL, 0x0000050000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e003bULL, 0xffffe45000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0001ab6000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe400078e00ffULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fc400078e00ffULL, 0x0000048000007944ULL, 0x012fea0003c00000ULL,
0x0000003b0500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001abe000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x000000053b057208ULL, 0x000fe20004000000ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fc400078e00ffULL, 0x0000040000007944ULL, 0x000fea0003c00000ULL,
0x0000003b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0001ac6000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x000000063b067208ULL, 0x000fe20004000000ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fc400078e00ffULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x0000003b0700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e003cULL,
0x0001ace000327802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000073b077208ULL, 0x000fe20004000000ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x0000003b3c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x0001ad6000327802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000003c3b047208ULL, 0x000fe20004000000ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fc400078e00ffULL, 0x0000028000007944ULL, 0x000fea0003c00000ULL,
0x0000003b0500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001ade000327802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000053b057208ULL, 0x000fe20004000000ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fc400078e00ffULL, 0x0000020000007944ULL, 0x000fea0003c00000ULL,
0x0000003b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0001ae6000327802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000063b067208ULL, 0x000fe20004000000ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fc400078e00ffULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffe24000007947ULL, 0x000fea000383ffffULL, 0x0180000003007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000300008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000003037812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fda000780c0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000300007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe502004007950ULL, 0x000fea0003c3ffffULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x0c000009083b7389ULL, 0x0002a400000e003bULL,
0x000000ffff087224ULL, 0x002fe400078e0032ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe4fd008007950ULL, 0x000fea0003c3ffffULL, 0x0000004900007348ULL, 0x000fe80003800000ULL,
0x0000004c4d497389ULL, 0x0002a400000e0043ULL, 0x00000000ff437424ULL, 0x002fc800078e00ffULL,
0xfffe4f9042007950ULL, 0x000fea0003c3ffffULL, 0x000000014200780cULL, 0x000fe20003f45070ULL,
0x0000004900007348ULL, 0x000fd80003800000ULL, 0x0000000000427806ULL, 0x000fc800050e0100ULL,
0x0000004942497212ULL, 0x000fe200078ec0ffULL, 0x000000ffff427224ULL, 0x000fe400078e0043ULL,
0x00000000ff437424ULL, 0x000fc800078e00ffULL, 0xfffe4f2042007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000430ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000df8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eb8ULL, 0x0000000000000a08ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018c0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018d0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001960ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001964ULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b80ULL, 0x000000000001b180ULL, 0x8a00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001cd00ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001cd50ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001d0d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001960ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001b3a0ULL, 0x000000000001b3a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001cd00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001d0d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 119216;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
