/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b150ULL, 0x000000000001add0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000018e00ULL, 0x0000000000000170ULL,
0x000b0022000004bdULL, 0x0000000000018f70ULL, 0x0000000000000050ULL, 0x000b0022000004e8ULL,
0x0000000000018fc0ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x0000000000019000ULL,
0x0000000000000100ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000019100ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00018e0000000000ULL, 0x0000040400000000ULL,
0x810c0000015c0400ULL, 0x0062180400288080ULL, 0x0000000000000000ULL, 0x000000ecffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808a0828808081ULL, 0x9508288080920828ULL, 0x2880809608288080ULL, 0x8099082880809808ULL,
0x082880809a082880ULL, 0x8080a4082880809cULL, 0xad08288080ac0828ULL, 0x288080ae08288080ULL,
0x80b008288080af08ULL, 0x08288080b1082880ULL, 0x8080b408288080b3ULL, 0xb608288080b50828ULL,
0x288080b708288080ULL, 0x80b908288080b808ULL, 0x08288080ba082880ULL, 0x8080c008288080bbULL,
0xc408288080c20828ULL, 0x288080c508288080ULL, 0x80c708288080c608ULL, 0x08288080c8082880ULL,
0x8080ca08288080c9ULL, 0xcc08288080cb0828ULL, 0x2880808408288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808084ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00018e0000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000104ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8808288080860828ULL, 0x2880808c08288080ULL, 0x808f082880808e08ULL,
0x0828808090082880ULL, 0x8080930828808092ULL, 0xa0082880809a0828ULL, 0x288080a108288080ULL,
0x80a308288080a208ULL, 0x08288080a4082880ULL, 0x8080ad08288080acULL, 0xaf08288080ae0828ULL,
0x288080b008288080ULL, 0x80b308288080b108ULL, 0x08288080b4082880ULL, 0x8080b608288080b5ULL,
0xb808288080b70828ULL, 0x288080b908288080ULL, 0x80bb08288080ba08ULL, 0x08288080c0082880ULL,
0x8080c408288080c2ULL, 0xc608288080c50828ULL, 0x288080c808288080ULL, 0x80ca08288080c908ULL,
0x08288080cb082880ULL, 0x8080b208288080ccULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080b292ULL, 0x0000002cffffffffULL, 0x0000019000000000ULL, 0x00018f7000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8088288080b20900ULL, 0x0000000000002880ULL,
0x00000104ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8c08288080880828ULL, 0x2880808e08288080ULL,
0x8090082880808f08ULL, 0x0828808092082880ULL, 0x80809a0828808093ULL, 0xa108288080a00828ULL,
0x288080a208288080ULL, 0x80a408288080a308ULL, 0x08288080ac082880ULL, 0x8080ae08288080adULL,
0xb008288080af0828ULL, 0x288080b108288080ULL, 0x80b408288080b308ULL, 0x08288080b5082880ULL,
0x8080b708288080b6ULL, 0xb908288080b80828ULL, 0x288080ba08288080ULL, 0x80c008288080bb08ULL,
0x08288080c2082880ULL, 0x8080c508288080c4ULL, 0xc708288080c60828ULL, 0x288080c908288080ULL,
0x80cb08288080ca08ULL, 0x08288080cc082880ULL, 0x80828016288080c8ULL, 0x0000000000031028ULL,
0x288080c892000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x000002d800000000ULL,
0x00018fc000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000104ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080860828808081ULL, 0x8c08288080880828ULL, 0x2880808e08288080ULL, 0x8090082880808f08ULL,
0x0828808092082880ULL, 0x80809a0828808093ULL, 0xa108288080a00828ULL, 0x288080a208288080ULL,
0x80a408288080a308ULL, 0x08288080ac082880ULL, 0x8080ae08288080adULL, 0xb008288080af0828ULL,
0x288080b108288080ULL, 0x80b408288080b308ULL, 0x08288080b5082880ULL, 0x8080b708288080b6ULL,
0xb908288080b80828ULL, 0x288080ba08288080ULL, 0x80c008288080bb08ULL, 0x08288080c2082880ULL,
0x8080c508288080c4ULL, 0xc708288080c60828ULL, 0x288080c908288080ULL, 0x80cb08288080ca08ULL,
0x08288080cc082880ULL, 0x80828016288080c8ULL, 0x0000000000031028ULL, 0x288080c892000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000041000000000ULL, 0x0001900000000000ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001a00082f04ULL, 0x000823040000008dULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x0198290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000e001982804ULL, 0x0000047000000100ULL, 0x0000211000002060ULL, 0x0000237000002200ULL,
0x000027f0000027c0ULL, 0x0000289000002840ULL, 0x000046e0000046b0ULL, 0x0000478000004730ULL,
0x0000669000006600ULL, 0x00006900000067a0ULL, 0x00006dc000006d90ULL, 0x00006e6000006e10ULL,
0x00008ac000008a90ULL, 0x00008b6000008b10ULL, 0x0000a8f00000a870ULL, 0x0000ab600000aa00ULL,
0x0000b0000000afd0ULL, 0x0000b0a00000b050ULL, 0x0000cd000000ccd0ULL, 0x0000cda00000cd50ULL,
0x0000eba00000eb20ULL, 0x0000ee100000ecb0ULL, 0x0000f2b00000f280ULL, 0x0000f3500000f300ULL,
0x00010fa000010f70ULL, 0x0001104000010ff0ULL, 0x0001233000012320ULL, 0x0001733000012b00ULL,
0x0001738000017370ULL, 0x000173e000017390ULL, 0x0001742000017400ULL, 0x0001807000017430ULL,
0x00018110000180c0ULL, 0x000181a000018150ULL, 0x0001826000018200ULL, 0x00018310000182c0ULL,
0x000183b000018360ULL, 0x00018440000183f0ULL, 0x00018500000184a0ULL, 0x000185b000018560ULL,
0x0001865000018600ULL, 0x000186e000018690ULL, 0x000187a000018740ULL, 0x0001885000018800ULL,
0x00018900000188a0ULL, 0x000189c000018960ULL, 0x00018a8000018a20ULL, 0x00018b4000018ae0ULL,
0x00018c0000018ba0ULL, 0x00018cc000018c60ULL, 0x00018d8000018d20ULL, 0x0600390400018de0ULL,
0x000000ff00000200ULL, 0x003f010000010600ULL, 0x0000000d000002d0ULL, 0x003f012000010608ULL,
0x0000000d00000300ULL, 0x003f012000010688ULL, 0x0000000d00000440ULL, 0x003f0120000106a8ULL,
0x000000ff00000460ULL, 0x003f0100000106b8ULL, 0x000000ff000004f0ULL, 0x003f010700010600ULL,
0x0000002700000640ULL, 0x003f01020001068cULL, 0x00000027000006a0ULL, 0x003f010100010688ULL,
0x000000ff00000f00ULL, 0x003f0107000106a8ULL, 0x000000ff00001020ULL, 0x003f0101000106a8ULL,
0x000000ff00001080ULL, 0x003f0101000106b8ULL, 0x000000ff00001210ULL, 0x003f0105000106bcULL,
0x000000ff000013e0ULL, 0x003f0105000106bcULL, 0x000000ff00001ca0ULL, 0x003f0107000106b0ULL,
0x000000ff00001d20ULL, 0x003f0101000106b0ULL, 0x0000002700001d80ULL, 0x003f010100010608ULL,
0x0000002700001da0ULL, 0x003f01050001060cULL, 0x0000002700001f70ULL, 0x003f01050001060cULL,
0x000000ff00002520ULL, 0x003f0105000106acULL, 0x000000ff000026f0ULL, 0x003f0105000106acULL,
0x000000ff00003940ULL, 0x003f0101000106b8ULL, 0x000000ff00003970ULL, 0x003f0105000106bcULL,
0x000000ff00003b30ULL, 0x003f0105000106bcULL, 0x000000ff00004380ULL, 0x003f0107000106a8ULL,
0x000000ff00004400ULL, 0x003f0101000106a8ULL, 0x000000ff00004430ULL, 0x003f0105000106b4ULL,
0x000000ff00004600ULL, 0x003f0105000106b4ULL, 0x000000ff00005740ULL, 0x003f0101000106b8ULL,
0x000000ff000057b0ULL, 0x003f010100010688ULL, 0x000000ff00005800ULL, 0x003f0105000106bcULL,
0x000000ff000059d0ULL, 0x003f0105000106bcULL, 0x000000ff00006220ULL, 0x003f0107000106b0ULL,
0x000000ff00006320ULL, 0x003f0101000106b0ULL, 0x0000002700006380ULL, 0x003f010100010628ULL,
0x00000027000063a0ULL, 0x003f01050001062cULL, 0x0000002700006570ULL, 0x003f01050001062cULL,
0x000000ff00006af0ULL, 0x003f0105000106acULL, 0x000000ff00006cc0ULL, 0x003f0105000106acULL,
0x000000ff00007d20ULL, 0x003f0101000106b8ULL, 0x000000ff00007d50ULL, 0x003f0105000106bcULL,
0x000000ff00007f10ULL, 0x003f0105000106bcULL, 0x000000ff00008760ULL, 0x003f0107000106a8ULL,
0x000000ff000087e0ULL, 0x003f0101000106a8ULL, 0x000000ff00008810ULL, 0x003f0105000106b4ULL,
0x000000ff000089e0ULL, 0x003f0105000106b4ULL, 0x000000ff00009a20ULL, 0x003f0101000106b8ULL,
0x000000ff00009a90ULL, 0x003f010100010690ULL, 0x000000ff00009af0ULL, 0x003f0105000106bcULL,
0x000000ff00009cc0ULL, 0x003f0105000106bcULL, 0x000000ff0000a510ULL, 0x003f0107000106b0ULL,
0x000000ff0000a590ULL, 0x003f0101000106b0ULL, 0x000000270000a5f0ULL, 0x003f010100010648ULL,
0x000000270000a610ULL, 0x003f01050001064cULL, 0x000000270000a7e0ULL, 0x003f01050001064cULL,
0x000000ff0000ad30ULL, 0x003f0105000106acULL, 0x000000ff0000af00ULL, 0x003f0105000106acULL,
0x000000ff0000bf60ULL, 0x003f0101000106b8ULL, 0x000000ff0000bf90ULL, 0x003f0105000106bcULL,
0x000000ff0000c150ULL, 0x003f0105000106bcULL, 0x000000ff0000c9a0ULL, 0x003f0107000106a8ULL,
0x000000ff0000ca20ULL, 0x003f0101000106a8ULL, 0x000000ff0000ca50ULL, 0x003f0105000106b4ULL,
0x000000ff0000cc20ULL, 0x003f0105000106b4ULL, 0x000000ff0000dc50ULL, 0x003f0101000106b8ULL,
0x000000ff0000dcc0ULL, 0x003f010100010698ULL, 0x000000ff0000dd20ULL, 0x003f0105000106bcULL,
0x000000ff0000def0ULL, 0x003f0105000106bcULL, 0x000000ff0000e740ULL, 0x003f0107000106b0ULL,
0x000000ff0000e840ULL, 0x003f0101000106b0ULL, 0x000000270000e8a0ULL, 0x003f010100010668ULL,
0x000000270000e8c0ULL, 0x003f01050001066cULL, 0x000000270000ea90ULL, 0x003f01050001066cULL,
0x000000ff0000efe0ULL, 0x003f0105000106acULL, 0x000000ff0000f1b0ULL, 0x003f0105000106acULL,
0x000000ff000101e0ULL, 0x003f0101000106b8ULL, 0x000000ff00010210ULL, 0x003f0105000106bcULL,
0x000000ff000103d0ULL, 0x003f0105000106bcULL, 0x000000ff00010c40ULL, 0x003f0107000106a8ULL,
0x000000ff00010cc0ULL, 0x003f0101000106a8ULL, 0x000000ff00010cf0ULL, 0x003f0105000106b4ULL,
0x000000ff00010ec0ULL, 0x003f0105000106b4ULL, 0x000000ff00011f00ULL, 0x003f0101000106b8ULL,
0x000000ff00011f60ULL, 0x003f0101000106a0ULL, 0x000000ff00012d70ULL, 0x003f010100010600ULL,
0x000000ff00013b40ULL, 0x003f010500010604ULL, 0x000000ff00013d10ULL, 0x003f010500010604ULL,
0x000000ff00014080ULL, 0x003f010100010600ULL, 0x000000ff000140b0ULL, 0x003f010500010604ULL,
0x000000ff00014270ULL, 0x003f010500010604ULL, 0x0000002d00016750ULL, 0x003f010100000000ULL,
0x0000002d00016860ULL, 0x003f010500000004ULL, 0x0000002d00016a30ULL, 0x003f010500000004ULL,
0x0000002f00017ed0ULL, 0x003f010100000000ULL, 0x0000002f00017f30ULL, 0x003f010100000008ULL,
0x0000002f00017f90ULL, 0x003f010100000010ULL, 0x0000002f00018000ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x000142d000012c40ULL, 0x0001804000014380ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000534ULL, 0x0000001a00000002ULL, 0x00000000000003fcULL,
0x0000001a00000002ULL, 0x00000000000002b4ULL, 0x0000001a00000002ULL, 0x000000000000017cULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x000000000000050bULL,
0x0000001a00000002ULL, 0x00000000000003d3ULL, 0x0000001a00000002ULL, 0x0000000000000290ULL,
0x0000001a00000002ULL, 0x0000000000000157ULL, 0x0000001a00000002ULL, 0x0000000000010700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff297624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001000087300ULL, 0x000fe200000e0000ULL, 0x0000000829077824ULL, 0x000fe400078e00ffULL,
0x0000000000047919ULL, 0x000ee80000002200ULL, 0x0000000000007919ULL, 0x000f220000002600ULL,
0x0000001000137309ULL, 0x000ea60000000000ULL, 0x00000000000a7919ULL, 0x000f280000000000ULL,
0x00000000002b7919ULL, 0x000f220000002700ULL, 0x00000005ff027819ULL, 0x002fc6000001160dULL,
0x00001fff030c7589ULL, 0x0047e200000e0000ULL, 0x000000ffff137224ULL, 0x000fc600078e0a13ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000010003037a24ULL, 0x008fe400078e0204ULL,
0x0000000800067824ULL, 0x010fe400078e00ffULL, 0x00000000030d7a24ULL, 0x000fe200078e020dULL,
0x0000000a0800720cULL, 0x000fe20003f02070ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000002b07087224ULL, 0x000fe400078e0206ULL, 0x000000ff0d00720cULL, 0x000fc40003f25270ULL,
0x0000000f0d00780cULL, 0x040fe40003f44070ULL, 0x000000030d00780cULL, 0x040fe40003f64070ULL,
0x0000007f0d00780cULL, 0x000fe20003f84070ULL, 0x000000040c097824ULL, 0x002fcc00078e0202ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x0000000209097824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x01060004ff009388ULL, 0x0003e20000000a00ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0xff317217ff0bc424ULL, 0x000fc400078e00ffULL, 0x00000001090a7824ULL, 0x044fe400078e0203ULL,
0x00000020090f7824ULL, 0x000fe200078e00ffULL, 0x0104000b0d00c388ULL, 0x0005e20000004800ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff04a424ULL, 0x002fe200078e00ffULL,
0xffffffe00f0f7812ULL, 0x000fe200078ee20aULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x000001f00e117812ULL, 0x000fe200078ec0ffULL, 0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x010608040d00a388ULL, 0x0003e20000008a00ULL,
0x000000010d00780cULL, 0x000fe20003f44070ULL, 0x7fffff80ff0b9424ULL, 0x004fe400078e00ffULL,
0x010688060d00b388ULL, 0x0005e20000008a00ULL, 0x0000000809047817ULL, 0x042fe20007800000ULL,
0x0000000108057824ULL, 0x100fe400078e0209ULL, 0x00000200ff077424ULL, 0x004fe400078e00ffULL,
0x0000000104047824ULL, 0x000fe200078e0a09ULL, 0x0000000109097810ULL, 0x000fc80007ffe0ffULL,
0x000000ff0400720cULL, 0x000fe20003f63070ULL, 0x0000000108067824ULL, 0x000fe200078e0209ULL,
0x000000010400780cULL, 0x000fe20003f83070ULL, 0x00005c0005047625ULL, 0x000fc800078e0007ULL,
0x0000000109107824ULL, 0x040fe200078e0203ULL, 0x0000001104047210ULL, 0x000fe20007fbe0ffULL,
0x0000002009127824ULL, 0x000fe400078e00ffULL, 0x00005c0006067625ULL, 0x000fc600078e0007ULL,
0xffffffe012107812ULL, 0x000fe200078ee210ULL, 0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL,
0x0000001106067210ULL, 0x000fe20007fde0ffULL, 0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0106a8080d00a388ULL, 0x000fe20000008a00ULL, 0x0000001010107824ULL, 0x000fc600078e00ffULL,
0x0106b80aff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e8000d901c46ULL,
0x0000000006107faeULL, 0x0005e2000e101c46ULL, 0x000000ffff047224ULL, 0x002fc400078e0013ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x004fe60000000000ULL,
0x000062002b247625ULL, 0x000fe200078e0005ULL, 0x01060404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000624247981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fc40003f05270ULL,
0x0000007f24257810ULL, 0x044fe40007ffe0ffULL, 0x000000ff24067810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff257819ULL, 0x000fe40000011625ULL, 0x00000008ff267819ULL, 0x000fca0000011606ULL,
0x0001266000008947ULL, 0x000fea0003800000ULL, 0x000001ff0600780cULL, 0x000fe20003f24070ULL,
0x0000000802277824ULL, 0x000fe200078e00ffULL, 0x000000ff2500720cULL, 0x000fe20003f05270ULL,
0x00000003ff047424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0427ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106880027ff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff287424ULL, 0x000fe200078e00ffULL,
0x0000005000008947ULL, 0x000fea0003800000ULL, 0x000000022b047824ULL, 0x002fe400078e00ffULL,
0x00006400ff067624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0206ULL,
0x0000600004287625ULL, 0x000fcc00078e0005ULL, 0x0000000628287981ULL, 0x000324000c1e1900ULL,
0x0000580028047a24ULL, 0x012fc800078e02ffULL, 0x0000008004107824ULL, 0x000fe200078e00ffULL,
0x0000043000001947ULL, 0x000fea0003800000ULL, 0x0000002724047217ULL, 0x000fe40007800000ULL,
0x00000004ff057819ULL, 0x000fe40000011603ULL, 0x000000f00e137812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a27ULL, 0x0000000205077810ULL, 0x000fe20007ffe0ffULL,
0x0000000127067824ULL, 0x000fe200078e0205ULL, 0x00000004050a7810ULL, 0x040fe40007ffe0ffULL,
0x000000040500720cULL, 0x080fe20003f06070ULL, 0x0000000127087824ULL, 0x000fe200078e0207ULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008000057824ULL, 0x000fe200078e0206ULL,
0x000000040700720cULL, 0x080fe20003f26070ULL, 0x0000000106077824ULL, 0x100fe200078e0203ULL,
0x000000040a00720cULL, 0x000fe20003f46070ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0x00000005100c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000108067824ULL, 0x000fc400078e0203ULL,
0x00000010080f7824ULL, 0x000fe200078e00ffULL, 0xfffffff009077812ULL, 0x000fe200078ee207ULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x000000040b00720cULL, 0x000fe20003f66070ULL,
0x00000001270a7824ULL, 0x000fe200078e020aULL, 0x0000000205047810ULL, 0x000fe40007ffe0ffULL,
0x00005e000c087a11ULL, 0x000fe400078840ffULL, 0xfffffff00f097812ULL, 0x000fe400078ee206ULL,
0x0000000405067810ULL, 0x000fc40007ffe0ffULL, 0x0000000410127210ULL, 0x000fe20007fde0ffULL,
0x000000010a047824ULL, 0x000fe200078e0203ULL, 0x00005f000c0c7a11ULL, 0x000fe200020f440dULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000605057810ULL, 0x000fe40007ffe0ffULL,
0x00000006100f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005e0012117a11ULL, 0x000fe400078c40ffULL, 0x00000005100d7210ULL, 0x000fe20007fbe0ffULL,
0x0000000127057824ULL, 0x000fe200078e020bULL, 0xfffffff00a0b7812ULL, 0x000fe200078ee204ULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x00005f0012127a11ULL, 0x000fe200030f4406ULL,
0x0000000105067824ULL, 0x000fe200078e0203ULL, 0x0000000813047210ULL, 0x000fe20007fde0ffULL,
0x0000001005147824ULL, 0x000fe200078e00ffULL, 0x0000c00007077811ULL, 0x000fe200078e20ffULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078840ffULL,
0x000000ffff057224ULL, 0x000fe200030e060cULL, 0x00005e000d087a11ULL, 0x000fc400078a40ffULL,
0xfffffff0140c7812ULL, 0x000fe400078ee206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c46ULL, 0x00005f000f0f7a11ULL, 0x000fe400020f4410ULL,
0x00005f000d0d7a11ULL, 0x000fe400028f440aULL, 0x000000130e067210ULL, 0x080fe40007f9e0ffULL,
0x0000001308087210ULL, 0x000fe40007fbe0ffULL, 0x0000c000090a7811ULL, 0x000fc400078e20ffULL,
0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x002fe200020e060fULL,
0x0000001311047210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e060dULL,
0x0000c0000c0c7811ULL, 0x000fc600078e20ffULL, 0x000000ffff057224ULL, 0x000fca00000e0612ULL,
0x00000000040a7faeULL, 0x0003e8000c901c46ULL, 0x00000000060b7faeULL, 0x0003e8000d101c46ULL,
0x00000000080c7faeULL, 0x0003e2000d901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000002703047211ULL, 0x000fe400078fe0ffULL, 0x000000f00e137812ULL, 0x000fc400078ec0ffULL,
0x0000000204067810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x140fe200078e0203ULL,
0x00000006040a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001004087824ULL, 0x000fe400078e00ffULL,
0x0000000106077824ULL, 0x040fe400078e0203ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0xfffffff008067812ULL, 0x000fe200078ee205ULL, 0x0000008000057824ULL, 0x000fc600078e0204ULL,
0xfffffff009097812ULL, 0x000fe400078ee207ULL, 0x0000000404077810ULL, 0x000fe40007ffe0ffULL,
0x0000000510127210ULL, 0x040fe40007f1e0ffULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x0000000205047810ULL, 0x040fe40007ffe0ffULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107057824ULL, 0x100fe200078e0203ULL,
0x00000008100f7210ULL, 0x000fe20007f5e0ffULL, 0x000000010a077824ULL, 0x000fe200078e0203ULL,
0x0000000410117210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000b100d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0012047a11ULL, 0x000fe200078040ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffff00c0b7812ULL, 0x000fe200078ee205ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0xfffffff00a0c7812ULL, 0x000fe200078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005f0012127a11ULL, 0x000fc400000f4408ULL, 0x00005e0011107a11ULL, 0x000fe400078240ffULL,
0x00005e000d0a7a11ULL, 0x000fe400078640ffULL, 0x0000000413047210ULL, 0x000fe40007f1e0ffULL,
0x00005e000f087a11ULL, 0x000fe400078440ffULL, 0x00005f0011117a11ULL, 0x000fe400008f4407ULL,
0x00005f000d0d7a11ULL, 0x000fe200018f4405ULL, 0x000000ffff057224ULL, 0x000fe200000e0612ULL,
0x0000c00006077811ULL, 0x000fc400078e20ffULL, 0x0000001013067210ULL, 0x000fe40007f1e0ffULL,
0x00005f000f0e7a11ULL, 0x000fe200010f440eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000b901c46ULL, 0x0000000813087210ULL, 0x040fe40007f3e0ffULL,
0x0000000a130a7210ULL, 0x000fe40007f5e0ffULL, 0x0000c0000c0c7811ULL, 0x000fe400078e20ffULL,
0x0000c00009047811ULL, 0x002fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0611ULL,
0x0000c0000b057811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fc400008e060eULL,
0x000000ffff0b7224ULL, 0x000fe200010e060dULL, 0x0000000006047faeULL, 0x0003e8000b901c46ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000a0c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff2600720cULL, 0x000fe20003f05270ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff2c7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00010ea000008947ULL, 0x000fea0003800000ULL, 0x000000022b2a7824ULL, 0x000fe400078e00ffULL,
0x00006400ff237624ULL, 0x000fc400078e00ffULL, 0x000000ffff447224ULL, 0x002fe400078e0045ULL,
0x000064002a2a7624ULL, 0x000fe400078e0223ULL, 0x000000ffff4c7224ULL, 0x008fe400078e002dULL,
0xff317217ff467424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fc400078e00ffULL, 0x000000ffff237224ULL, 0x000fc400078e00ffULL,
0x000001002b2d7824ULL, 0x000fca00078e00ffULL, 0x000000242d00720cULL, 0x000fda0003f06070ULL,
0x00010da000000947ULL, 0x024fea0003800000ULL, 0x000000ffff2d7224ULL, 0x000fc400078e002cULL,
0x00000000002e7805ULL, 0x000fca0000015200ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe4000780484cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x000000302e327210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e2fULL,
0x003d09003200780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403200780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff307819ULL, 0x000fc80000011431ULL, 0x0000003230307211ULL, 0x000fca00078110ffULL,
0x000000ffff317224ULL, 0x000fca00000e0631ULL, 0x0000000230307819ULL, 0x000fc80000001231ULL,
0x000000300000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe4000780484cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000012b2e7810ULL, 0x000fe20007ffe0ffULL,
0x0000580028697a24ULL, 0x000fc600078e02ffULL, 0x000000262e00720cULL, 0x000fe20003f26070ULL,
0x0000008069697824ULL, 0x000fd800078e00ffULL, 0x0000048000009947ULL, 0x000fea0003800000ULL,
0x000000202b2e7811ULL, 0x000fe400078e40ffULL, 0x00000004ff397819ULL, 0x000fe40000011603ULL,
0x0000002e242f7217ULL, 0x000fe40007800000ULL, 0x00000004393f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127307824ULL, 0x000fe200078e0239ULL, 0x00000002393c7810ULL, 0x000fe20007ffe0ffULL,
0x000000012f2f7824ULL, 0x000fe200078e0a2eULL, 0x00000020002e7811ULL, 0x000fe200078e38ffULL,
0x0000000130317824ULL, 0x040fe200078e0203ULL, 0x0000000639417810ULL, 0x000fe20007ffe0ffULL,
0x00000010303d7824ULL, 0x000fe200078e00ffULL, 0x0000002f272f7217ULL, 0x040fe20007800000ULL,
0x0000000127367824ULL, 0x000fc400078e023fULL, 0x0000000127327824ULL, 0x000fe200078e023cULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee231ULL, 0x0000000136377824ULL, 0x140fe400078e0203ULL,
0x0000001036407824ULL, 0x000fe400078e00ffULL, 0x0000000130307824ULL, 0x000fe400078e022eULL,
0x0000000132317824ULL, 0x000fe200078e0203ULL, 0xfffffff040407812ULL, 0x000fe200078ee237ULL,
0x00000010323e7824ULL, 0x000fe200078e00ffULL, 0x0000003069377210ULL, 0x000fe20007f1e0ffULL,
0x0000000127387824ULL, 0x000fc400078e0241ULL, 0x000000012f307824ULL, 0x000fe200078e0a27ULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee231ULL, 0x0000000132317824ULL, 0x100fe400078e022eULL,
0x0000000136327824ULL, 0x100fe400078e022eULL, 0x00000001382e7824ULL, 0x040fe200078e022eULL,
0x0000003169317210ULL, 0x040fe20007f5e0ffULL, 0x00000001383a7824ULL, 0x040fe200078e0203ULL,
0x0000003269327210ULL, 0x000fe20007f9e0ffULL, 0x0000001038427824ULL, 0x000fc400078e00ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x00005e0037367a11ULL, 0x040fe200078040ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x000000303c00720cULL, 0x080fe40003f46070ULL,
0x00005f00372f7a11ULL, 0x000fe200000f4438ULL, 0x0000001003377824ULL, 0x000fe200078e00ffULL,
0x000000303900720cULL, 0x000fe20003f06070ULL, 0x000000ffff397224ULL, 0x000fe200020e06ffULL,
0x00005e0032387a11ULL, 0x000fe400078a40ffULL, 0x000000f0373c7812ULL, 0x000fc400078ec0ffULL,
0x0000002e69377210ULL, 0x000fe40007fde0ffULL, 0xfffffff042427812ULL, 0x000fe400078ee23aULL,
0x0000003c362e7210ULL, 0x000fe40007f9e0ffULL, 0x00005f0032397a11ULL, 0x000fe200028f4439ULL,
0x000000ffff327224ULL, 0x000fe200030e06ffULL, 0x00005e00313a7a11ULL, 0x000fe200078640ffULL,
0x000000ffff2f7224ULL, 0x000fe200020e062fULL, 0x00005e0037367a11ULL, 0x000fc400078a40ffULL,
0x00005f00313b7a11ULL, 0x000fe400018f443bULL, 0x000000303f00720cULL, 0x080fe40003f66070ULL,
0x0000e0003d317811ULL, 0x000fe400078e20ffULL, 0x000000304100720cULL, 0x000fe40003f86070ULL,
0x00005f0037377a11ULL, 0x000fe200028f4432ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e317faeULL, 0x0003e2000c101c46ULL, 0x0000003c3a307210ULL, 0x000fc40007fbe0ffULL,
0x0000e0003e327811ULL, 0x000fe400078e20ffULL, 0x0000003c382e7210ULL, 0x082fe20007f1e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e063bULL, 0x0000003c36367210ULL, 0x000fe40007fbe0ffULL,
0x0000e00040387811ULL, 0x000fe200078e20ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e0639ULL,
0x0000e00042397811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x000fe200028e0637ULL,
0x0000000030327faeULL, 0x0003e8000d101c46ULL, 0x000000002e387faeULL, 0x0003e8000d901c46ULL,
0x0000000036397faeULL, 0x0003e2000e101c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x00000027032f7211ULL, 0x000fe400078fe0ffULL, 0x0000002000307811ULL, 0x000fc400078e38ffULL,
0x000000022f317810ULL, 0x040fe20007ffe0ffULL, 0x000000012f2e7824ULL, 0x140fe200078e0203ULL,
0x000000062f377810ULL, 0x040fe20007ffe0ffULL, 0x000000102f3e7824ULL, 0x000fe400078e00ffULL,
0x0000000131327824ULL, 0x140fe400078e0203ULL, 0x00000010313f7824ULL, 0x000fe200078e00ffULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee22eULL, 0x000000012f2e7824ULL, 0x000fe400078e0230ULL,
0x0000000137387824ULL, 0x000fe200078e0203ULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee232ULL,
0x0000001037417824ULL, 0x000fe200078e00ffULL, 0x0000002e693c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001312e7824ULL, 0x000fe200078e0230ULL, 0x000000042f327810ULL, 0x000fc40007ffe0ffULL,
0xfffffff041417812ULL, 0x000fe200078ee238ULL, 0x000000ffff317224ULL, 0x000fe200000e06ffULL,
0x00005e003c3b7a11ULL, 0x000fe200078040ffULL, 0x00000001322f7824ULL, 0x100fe400078e0230ULL,
0x0000000137307824ULL, 0x000fe200078e0230ULL, 0x00005f003c3c7a11ULL, 0x000fe200000f4431ULL,
0x0000000132367824ULL, 0x040fe200078e0203ULL, 0x0000002e693a7210ULL, 0x040fe20007f1e0ffULL,
0x0000001032407824ULL, 0x000fe200078e00ffULL, 0x0000002f692f7210ULL, 0x000fe20007f7e0ffULL,
0x0000001003327824ULL, 0x000fe200078e00ffULL, 0x0000003069307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0xfffffff040407812ULL, 0x000fe200078ee236ULL,
0x000000ffff377224ULL, 0x000fe200018e06ffULL, 0x000000f0323d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff327224ULL, 0x000fe200020e06ffULL, 0x00005e003a397a11ULL, 0x000fc400078440ffULL,
0x00005e002f367a11ULL, 0x000fe400078640ffULL, 0x0000003d3b2e7210ULL, 0x000fe40007f1e0ffULL,
0x00005e0030387a11ULL, 0x000fe400078840ffULL, 0x00005f003a3a7a11ULL, 0x000fe400010f4431ULL,
0x00005f002f377a11ULL, 0x000fe200018f4437ULL, 0x000000ffff2f7224ULL, 0x000fe200000e063cULL,
0x00005f0030327a11ULL, 0x000fc400020f4432ULL, 0x0000e0003e317811ULL, 0x000fe400078e20ffULL,
0x0000003d39307210ULL, 0x080fe40007f1e0ffULL, 0x0000003d36367210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000b901c46ULL,
0x0000003d38387210ULL, 0x000fc60007f7e0ffULL, 0x000000ffff377224ULL, 0x000fe400010e0637ULL,
0x000000ffff397224ULL, 0x000fe200018e0632ULL, 0x0000e00041327811ULL, 0x000fe400078e20ffULL,
0x0000e0003f2e7811ULL, 0x002fe200078e20ffULL, 0x000000ffff317224ULL, 0x000fe200000e063aULL,
0x0000e000402f7811ULL, 0x000fc800078e20ffULL, 0x00000000302e7faeULL, 0x0003e8000b901c46ULL,
0x00000000362f7faeULL, 0x0003e8000b901c46ULL, 0x0000000038327faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff507f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080027367f8cULL, 0x0006a4000c80043fULL, 0x00000000002e7805ULL, 0x000fc40000015200ULL,
0x01060c0027307984ULL, 0x000f240000000800ULL, 0x8000000030ff7812ULL, 0x014fc40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x000000302e327210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e2fULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff307819ULL, 0x000fc80000011431ULL,
0x0000003230307211ULL, 0x000fca00078110ffULL, 0x000000ffff317224ULL, 0x000fca00000e0631ULL,
0x0000000230307819ULL, 0x000fc80000001231ULL, 0x000000300000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c0027307984ULL, 0x000ea40000000800ULL,
0x8000000030ff7812ULL, 0x004fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff2f7819ULL, 0x000fe20000011603ULL, 0x00000010032e7824ULL, 0x000fc600078e00ffULL,
0x0000000c2f307812ULL, 0x000fe400078ec0ffULL, 0x000000702e2f7812ULL, 0x000fca00078ec0ffULL,
0x000000012f2f7824ULL, 0x000fe400078e0230ULL, 0xffffffffff307424ULL, 0x000fc600078e00ffULL,
0x010000002f367984ULL, 0x000ea80000000800ULL, 0x010200002f377984ULL, 0x0006620000000800ULL,
0x000000463600720bULL, 0x004fe20003f1d000ULL, 0x00015ff27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000317806ULL, 0x008fc800000e0100ULL, 0x0000ffff313b7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff687224ULL, 0x000fc400078e0046ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000463600720bULL, 0x000fe20003f54000ULL,
0x00015f927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000387806ULL, 0x000fc400010e0100ULL,
0x0000003646687209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991038397816ULL, 0x000fc600000000ffULL, 0x010400682f008388ULL, 0x0005e20000000800ULL,
0x000000ff3900720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000006846397221ULL, 0x004fe20000010000ULL, 0x000000ff38ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b39397820ULL, 0x000fcc0000410000ULL,
0x0000003900397308ULL, 0x000ea80000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff477819ULL, 0x000fe20000011603ULL, 0x00015ef27f007947ULL, 0x000fea000b800000ULL,
0x00001f4739477589ULL, 0x0044e400000e0000ULL, 0x0000004708087220ULL, 0x08cfe20000410000ULL,
0x0000004709097220ULL, 0x080fe20000410000ULL, 0x000000470c0c7220ULL, 0x080fe20000410000ULL,
0x000000470d0d7220ULL, 0x080fe20000410000ULL, 0x0000004710107220ULL, 0x080fe20000410000ULL,
0x0000004711117220ULL, 0x080fe20000410000ULL, 0x0000004704047220ULL, 0x080fe20000410000ULL,
0x0000004705057220ULL, 0x080fe20000410000ULL, 0x0000004714147220ULL, 0x080fe20000410000ULL,
0x0000004715157220ULL, 0x080fe20000410000ULL, 0x0000004718187220ULL, 0x080fe20000410000ULL,
0x0000004719197220ULL, 0x080fe20000410000ULL, 0x000000471c1c7220ULL, 0x080fe20000410000ULL,
0x000000471d1d7220ULL, 0x080fe20000410000ULL, 0x0000004720207220ULL, 0x080fe20000410000ULL,
0x0000004721217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0038ff7812ULL, 0x000fe2000780c0ffULL, 0x0000003929297220ULL, 0x004fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803477811ULL, 0x000fe200078ff0ffULL,
0x00015dc27f007947ULL, 0x000fea000b800000ULL, 0x00001f4739477589ULL, 0x0004e400000e0000ULL,
0x000000470a0a7220ULL, 0x08cfe20000410000ULL, 0x000000470b0b7220ULL, 0x080fe20000410000ULL,
0x000000470e0e7220ULL, 0x080fe20000410000ULL, 0x000000470f0f7220ULL, 0x080fe20000410000ULL,
0x0000004712127220ULL, 0x080fe20000410000ULL, 0x0000004713137220ULL, 0x080fe20000410000ULL,
0x0000004706067220ULL, 0x080fe20000410000ULL, 0x0000004707077220ULL, 0x080fe20000410000ULL,
0x0000004716167220ULL, 0x080fe20000410000ULL, 0x0000004717177220ULL, 0x080fe20000410000ULL,
0x000000471a1a7220ULL, 0x080fe20000410000ULL, 0x000000471b1b7220ULL, 0x080fe20000410000ULL,
0x000000471e1e7220ULL, 0x080fe20000410000ULL, 0x000000471f1f7220ULL, 0x080fe20000410000ULL,
0x0000004722227220ULL, 0x080fe20000410000ULL, 0x0000004723237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fda0007806038ULL,
0x8000006836360221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600330308ULL, 0x000ea40000000800ULL,
0x0000003337370220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002937297221ULL, 0x002fc40000010000ULL, 0x0000000000367805ULL, 0x000fca0000015200ULL,
0x0106ac00ff387984ULL, 0x000e640000000800ULL, 0x8000000038ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038363b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e37ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff387984ULL, 0x000e640000000800ULL,
0x8000000038ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103a367816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff3600720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000033ff34723eULL, 0x000fe400000000ffULL, 0x00000002ff377819ULL, 0x000fe40000011603ULL,
0x0000541034367816ULL, 0x000fe20000000034ULL, 0x000159b27f007947ULL, 0x000fea000b800000ULL,
0x00001f3736347589ULL, 0x0002a400000e0000ULL, 0x0000000837357810ULL, 0x000fe20007ffe0ffULL,
0x000159e27f007947ULL, 0x000fea000b800000ULL, 0x00001f3536357589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001037477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0036ULL, 0x0000285000487802ULL, 0x000fc40000000f00ULL,
0x0001677000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001837477810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0036ULL,
0x000028a000487802ULL, 0x000fc40000000f00ULL, 0x0001672000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000803527812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff367819ULL, 0x00afc40000011603ULL,
0x0000000752527812ULL, 0x100fe400078ef803ULL, 0x00000002023a7811ULL, 0x040fe200078e10ffULL,
0x0000000402547824ULL, 0x000fe200078e0236ULL, 0x0000001052407812ULL, 0x040fe200078efcffULL,
0x0000001052387824ULL, 0x040fe200078e00ffULL, 0x0000000703587812ULL, 0x000fe200078ec0ffULL,
0x0000000152377824ULL, 0x000fe200078e0254ULL, 0x0000003a40567210ULL, 0x000fe20007ffe036ULL,
0x0000000136537824ULL, 0x000fe200078e023aULL, 0x0000000858587812ULL, 0x000fe200078ef803ULL,
0x0000001052397824ULL, 0x000fe200078e00ffULL, 0xfffffff038377812ULL, 0x000fe200078ee237ULL,
0x0000000152387824ULL, 0x000fc400078e0253ULL, 0x0000000154557824ULL, 0x000fe200078e0240ULL,
0x0000c00037377811ULL, 0x000fe200078e20ffULL, 0x0000000136597824ULL, 0x000fe200078e0258ULL,
0xfffffff039387812ULL, 0x000fc600078ee238ULL, 0x00000000373c783bULL, 0x000e620000004200ULL,
0x0000c00038387811ULL, 0x000fca00078e20ffULL, 0x000000003844783bULL, 0x004ea20000004200ULL,
0x00000018ff397819ULL, 0x002fe2000001143cULL, 0x000001003c3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001143eULL, 0x00000039004e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fe4000001143fULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff487819ULL, 0x004fc40000011444ULL, 0x00000018ff497819ULL, 0x000fe20000011445ULL,
0x0000003b004d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff397819ULL, 0x002fe4000001143dULL,
0x00000018ff577819ULL, 0x000fe40000011446ULL, 0x00000018ff5a7819ULL, 0x000fe40000011447ULL,
0x00008880463a7816ULL, 0x000fe200000000ffULL, 0x0000003900657306ULL, 0x0003e20000200c00ULL,
0x000001003d3b7824ULL, 0x004fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003a00757306ULL, 0x000fe20000200c00ULL, 0x000088803c397816ULL, 0x042fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x00000039004c7306ULL, 0x0002b00000200c00ULL, 0x0000003b00647306ULL, 0x0007e20000200c00ULL,
0x000088803d397816ULL, 0x042fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003900637306ULL, 0x0003220000200c00ULL,
0x000001003e3b7824ULL, 0x008fe200078e00ffULL, 0x000054104c4c7816ULL, 0x004fc8000000004dULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000003c004f7306ULL, 0x000ea20000200c00ULL,
0x000088803e397816ULL, 0x042fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003900677306ULL, 0x0003e20000200c00ULL,
0x00005410634d7816ULL, 0x010fce0000000064ULL, 0x0000003b006a7306ULL, 0x0007220000200c00ULL,
0x000088803f397816ULL, 0x002fe400000000ffULL, 0x000054104f4e7816ULL, 0x004fca000000004eULL,
0x00000039006b7306ULL, 0x0003e20000200c00ULL, 0x000001003f3b7824ULL, 0x048fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000003d00667306ULL, 0x000ea20000200c00ULL,
0x0000888044397816ULL, 0x002fe400000000ffULL, 0x00005410676a7816ULL, 0x010fca000000006aULL,
0x00000039006f7306ULL, 0x0003f00000200c00ULL, 0x0000003b006d7306ULL, 0x0007220000200c00ULL,
0x0000888045397816ULL, 0x002fe400000000ffULL, 0x00005410664f7816ULL, 0x004fca0000000065ULL,
0x0000003900717306ULL, 0x0003e20000200c00ULL, 0x00000100443b7824ULL, 0x048fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003e006c7306ULL, 0x000fe20000200c00ULL, 0x0000001040397824ULL, 0x042fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000001040407824ULL, 0x000fe200078e00ffULL,
0x000054106b6b7816ULL, 0x010fe4000000006dULL, 0xfffffff039557812ULL, 0x000fe400078ee255ULL,
0x0000003f006e7306ULL, 0x0003e20000200c00ULL, 0xfffffff040567812ULL, 0x000fc400078ee256ULL,
0x0000c00055397811ULL, 0x000fe400078e20ffULL, 0x0000c000563a7811ULL, 0x000fc600078e20ffULL,
0x0000003b00707306ULL, 0x0004e20000200c00ULL, 0x00000000393c783bULL, 0x002e680000004200ULL,
0x000000003a40783bULL, 0x000f260000004200ULL, 0x0000004400727306ULL, 0x0007e20000200c00ULL,
0x00000100453b7824ULL, 0x044fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x0000888047447816ULL, 0x008fe400000000ffULL,
0x000054106f707816ULL, 0x000fca0000000070ULL, 0x0000003b00737306ULL, 0x0006700000200c00ULL,
0x0000004500747306ULL, 0x0003e20000200c00ULL, 0x00000100463b7824ULL, 0x008fe200078e00ffULL,
0x000054106c4a7816ULL, 0x004fe2000000004aULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x000001003c457824ULL, 0x002fe200078e00ffULL, 0x0000003b00767306ULL, 0x0003e20000200c00ULL,
0x00000018ff617819ULL, 0x000fe2000001143cULL, 0x000001003e807824ULL, 0x000fe200078e00ffULL,
0x000088803d7e7816ULL, 0x000fe200000000ffULL, 0x000001003f827824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000888041657816ULL, 0x010fe200000000ffULL,
0x0000004600777306ULL, 0x000fe20000200c00ULL, 0x000000ffff3b7224ULL, 0x002fe200078e0044ULL,
0x0000541071717816ULL, 0x000fe20000000073ULL, 0x0000010047447824ULL, 0x040fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe2000001143dULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fc40000011480ULL, 0x0000003b00787306ULL, 0x0003e20000200c00ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x00000018ff5e7819ULL, 0x000fe20000011440ULL,
0x0000004400797306ULL, 0x0005e20000200c00ULL, 0x00000008583b7824ULL, 0x002fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fc40000011441ULL, 0x00000018ff5f7819ULL, 0x000fe4000001143eULL,
0xfffffff83b3b7812ULL, 0x000fe400078ee259ULL, 0x00000047007a7306ULL, 0x000fe20000200c00ULL,
0x000088803c447816ULL, 0x044fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001143fULL, 0x00000018ff5b7819ULL, 0x000fe40000011442ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x00000044007b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff5c7819ULL, 0x000fce0000011443ULL, 0x00000045007c7306ULL, 0x0005e20000200c00ULL,
0x0000a0003b447811ULL, 0x002fce00078e20ffULL, 0x0000003c007d7306ULL, 0x0003e20000200c00ULL,
0x000000004444783bULL, 0x004eae0000000200ULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x000000ffff3c7224ULL, 0x002fe400078e007eULL, 0x000001003d7e7824ULL, 0x000fc400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x0000003c007f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff3d7819ULL, 0x000fca000001143dULL,
0x0000004800487306ULL, 0x000f220000200c00ULL, 0x000088803e3c7816ULL, 0x042fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000054106e4b7816ULL, 0x008fc8000000004bULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003c00817306ULL, 0x0003f00000200c00ULL,
0x0000004900497306ULL, 0x000ee20000200c00ULL, 0x000000344444a232ULL, 0x084fe20000000000ULL,
0x000088803f3c7816ULL, 0x042fe200000000ffULL, 0x000000344646a232ULL, 0x000fe20000000000ULL,
0x0000541072487816ULL, 0x010fe20000000048ULL, 0x000000354545a232ULL, 0x080fe20000000000ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000000354747a232ULL, 0x000fe20000000000ULL,
0x0000003c00837306ULL, 0x0003e60000200c00ULL, 0x00000018ff3f7819ULL, 0x000fc6000001143fULL,
0x0000004c4408723cULL, 0x040b640000001808ULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x00000002593c7810ULL, 0x002fe40007ffe0ffULL, 0x0000541074497816ULL, 0x008fe40000000049ULL,
0x00000008584d7824ULL, 0x020fe200078e00ffULL, 0x00008880404c7816ULL, 0x040fe200000000ffULL,
0x0000004e440c723cULL, 0x000f62000000180cULL, 0x0000005a005a7306ULL, 0x000e640000200c00ULL,
0xfffffff84d3c7812ULL, 0x000fe200078ee23cULL, 0x00000100404d7824ULL, 0x000fc400078e00ffULL,
0x0001000040407824ULL, 0x000fe400078e00ffULL, 0x0000004a4404723cULL, 0x000be20000001804ULL,
0x0000004c00647306ULL, 0x0007e20000200c00ULL, 0x00000018ff637819ULL, 0x000fe4000001144dULL,
0x00000018ff407819ULL, 0x000fc60000011440ULL, 0x00000100414b7824ULL, 0x060fe200078e00ffULL,
0x000000484418723cULL, 0x040be20000001818ULL, 0x000000ffff4a7224ULL, 0x000fe200078e0065ULL,
0x0000a0003c4c7811ULL, 0x008fe200078e20ffULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0001000041417824ULL, 0x000fe400078e00ffULL,
0x0000541075487816ULL, 0x020fe20000000076ULL, 0x000000004c4c783bULL, 0x000f220000000200ULL,
0x0000541078497816ULL, 0x000fe20000000079ULL, 0x0000006a4410723cULL, 0x000f620000001810ULL,
0x0000004a00657306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x000fcc0000011441ULL,
0x000000704414723cULL, 0x040f620000001814ULL, 0x0000004b00667306ULL, 0x0003f00000200c00ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000000484448723cULL, 0x002b6e000000181cULL,
0x00005410771c7816ULL, 0x024fe20000000057ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000054107a1d7816ULL, 0x000fc4000000005aULL, 0x00008880421e7816ULL, 0x000fca00000000ffULL,
0x0000001c4444723cULL, 0x000b620000001820ULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x000000344c4ca232ULL, 0x090fe40000000000ULL, 0x000000344e4ea232ULL, 0x000fc60000000000ULL,
0x00000100421c7824ULL, 0x060fe200078e00ffULL, 0x000000354d4da232ULL, 0x080fe20000000000ULL,
0x000054107f1d7816ULL, 0x008fe2000000007eULL, 0x000000354f4fa232ULL, 0x000fe20000000000ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x0000888043207816ULL, 0x000fe400000000ffULL,
0x000054103d217816ULL, 0x002fe40000000062ULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000001c005a7306ULL, 0x0003f00000200c00ULL, 0x0000001e00577306ULL, 0x0007e20000200c00ULL,
0x000054107b1c7816ULL, 0x002fce000000007cULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000001c4c1c723cULL, 0x008b6e0000001808ULL, 0x0000010043097824ULL, 0x020fe200078e00ffULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x000000ffff087224ULL, 0x000fc400078e0020ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff097819ULL, 0x000fc80000011409ULL,
0x0000000800677306ULL, 0x0005e20000200c00ULL, 0x00000018ff437819ULL, 0x000fce0000011443ULL,
0x00000009003d7306ULL, 0x0007e20000200c00ULL, 0x0000541081087816ULL, 0x004fe40000000080ULL,
0x000054107d207816ULL, 0x002fca0000000061ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000541083097816ULL, 0x008fe20000000082ULL, 0x000000204c20723cULL, 0x040f6c000000180cULL,
0x0000005d005d7306ULL, 0x000fe40000200c00ULL, 0x000000084c08723cULL, 0x000b6c0000001810ULL,
0x0000004000407306ULL, 0x000e620000200c00ULL, 0x0000541064107816ULL, 0x020fc40000000063ULL,
0x0000541065117816ULL, 0x000fca0000000066ULL, 0x0000004100417306ULL, 0x000ea40000200c00ULL,
0x000000104c10723cULL, 0x000b6c0000001814ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x0000541040147816ULL, 0x022fce000000005eULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000541041157816ULL, 0x004fce000000005dULL, 0x0000003e003e7306ULL, 0x000e620000200c00ULL,
0x000000144c14723cULL, 0x000b6e0000001818ULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x0000541057187816ULL, 0x020fe4000000005aULL, 0x0000541067197816ULL, 0x000fca000000003dULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x000054103e0c7816ULL, 0x002fe2000000005fULL,
0x000000184c18723cULL, 0x000b6c0000001848ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000054103f0d7816ULL, 0x004fce0000000060ULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x0000000c4c0c723cULL, 0x000b6e0000001804ULL, 0x0000004300437306ULL, 0x000ea20000200c00ULL,
0x0000541042427816ULL, 0x002fe4000000005bULL, 0x0000541043437816ULL, 0x004fce000000005cULL,
0x000000424c4c723cULL, 0x000b620000001844ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3e7f8cULL, 0x000e62000c80043fULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x0000000000047805ULL, 0x020fc40000015200ULL, 0x0106bc00ff067984ULL, 0x000ea40000000800ULL,
0x8000000006ff7812ULL, 0x006fe4000780483fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006043d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000003d06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000140407810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000402b3d7811ULL, 0x000fe200078e40ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000127057824ULL, 0x000fe200078e0236ULL, 0x0000004000067811ULL, 0x000fe400078e38ffULL,
0x0000000236417810ULL, 0x040fe20007ffe0ffULL, 0x0000000105047824ULL, 0x040fe200078e0203ULL,
0x0000000436477810ULL, 0x000fe20007ffe0ffULL, 0x0000001005457824ULL, 0x040fe200078e00ffULL,
0x000000f02e447812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x0000000636497810ULL, 0x000fe20007ffe0ffULL, 0x0000000127077824ULL, 0x000fe200078e0241ULL,
0xfffffff045457812ULL, 0x000fe200078ee204ULL, 0x0000000127427824ULL, 0x000fe200078e0247ULL,
0x0000003d24047217ULL, 0x000fe20007800000ULL, 0x00000001073e7824ULL, 0x000fe200078e0203ULL,
0x00000005693f7210ULL, 0x000fe20007f1e0ffULL, 0x0000001007467824ULL, 0x000fe200078e00ffULL,
0x0000c00045457811ULL, 0x000fe200078e20ffULL, 0x0000000104047824ULL, 0x000fc400078e0a3dULL,
0x0000000107057824ULL, 0x000fe200078e0206ULL, 0xfffffff046467812ULL, 0x000fe200078ee23eULL,
0x0000000142437824ULL, 0x040fe200078e0203ULL, 0x0000000427047217ULL, 0x000fe20007800000ULL,
0x0000001042487824ULL, 0x000fe200078e00ffULL, 0x0000000569057210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff407224ULL, 0x000fe200000e06ffULL, 0x00005e003f3e7a11ULL, 0x040fe200078040ffULL,
0x0000000104077824ULL, 0x000fe200078e0a27ULL, 0xfffffff048487812ULL, 0x000fe200078ee243ULL,
0x0000000142047824ULL, 0x000fe200078e0206ULL, 0x00005f003f3f7a11ULL, 0x000fe200000f4440ULL,
0x000000ffff437224ULL, 0x000fe200018e06ffULL, 0x00005e0005407a11ULL, 0x000fe200078640ffULL,
0x00000001274a7824ULL, 0x000fe200078e0249ULL, 0x000000073600720cULL, 0x000fc40003f86070ULL,
0x0000000469427210ULL, 0x000fe20007fbe0ffULL, 0x000000014a067824ULL, 0x000fe200078e0206ULL,
0x00005f0005437a11ULL, 0x000fe400018f4443ULL, 0x000000443e047210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200028e06ffULL, 0x000000074100720cULL, 0x080fe40003f06070ULL,
0x00005e0042417a11ULL, 0x000fe200078a40ffULL, 0x000000ffff057224ULL, 0x000fe200018e063fULL,
0x000000074700720cULL, 0x000fc40003f66070ULL, 0x00005f0042427a11ULL, 0x000fe400028f443eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004457faeULL, 0x0003e2000e101c46ULL,
0x00000006693f7210ULL, 0x000fe40007f9e0ffULL, 0x0000004441067210ULL, 0x080fe40007fde0ffULL,
0x0000c00046467811ULL, 0x000fe400078e20ffULL, 0x0000c00048487811ULL, 0x000fe400078e20ffULL,
0x0000004440047210ULL, 0x002fe20007fbe0ffULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078840ffULL, 0x000000014a457824ULL, 0x000fc400078e0203ULL,
0x000000104a4a7824ULL, 0x000fe200078e00ffULL, 0x00005f003f3f7a11ULL, 0x000fe200020f4440ULL,
0x000000ffff057224ULL, 0x000fe200028e0643ULL, 0x000000074900720cULL, 0x000fe20003fa6070ULL,
0x000000ffff077224ULL, 0x000fe200030e0642ULL, 0x000000443e3e7210ULL, 0x000fe40007f9e0ffULL,
0xfffffff04a457812ULL, 0x000fe200078ee245ULL, 0x0000000004467faeULL, 0x0003e4000c101c46ULL,
0x000000ffff3f7224ULL, 0x000fe200020e063fULL, 0x0000c00045457811ULL, 0x000fe200078e20ffULL,
0x0000000006487faeULL, 0x0003e8000d901c46ULL, 0x000000003e457faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000004000407811ULL, 0x000fe200078e38ffULL,
0x00000001273f7824ULL, 0x000fe200078e0236ULL, 0x000000f02e497812ULL, 0x000fc600078ec0ffULL,
0x000000013f057824ULL, 0x140fe200078e0240ULL, 0x000000023f047810ULL, 0x040fe20007ffe0ffULL,
0x000000013f067824ULL, 0x140fe200078e0203ULL, 0x000000043f077810ULL, 0x040fe20007ffe0ffULL,
0x000000103f4a7824ULL, 0x040fe200078e00ffULL, 0x000000063f3f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001004427824ULL, 0x040fe200078e00ffULL, 0x0000000569437210ULL, 0x000fe20007f1e0ffULL,
0x0000000104057824ULL, 0x000fe200078e0240ULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee206ULL,
0x0000000104067824ULL, 0x000fc400078e0203ULL, 0x000000013f417824ULL, 0x140fe200078e0203ULL,
0x0000c0004a4a7811ULL, 0x000fe200078e20ffULL, 0x000000103f467824ULL, 0x000fe400078e00ffULL,
0x000000ffff447224ULL, 0x000fe200000e06ffULL, 0x00005e0043477a11ULL, 0x000fe200078040ffULL,
0x0000000107047824ULL, 0x100fe400078e0240ULL, 0x000000013f407824ULL, 0x000fe200078e0240ULL,
0x00005f0043487a11ULL, 0x000fe200000f4444ULL, 0x00000001073e7824ULL, 0x000fe200078e0203ULL,
0x0000000469447210ULL, 0x000fe20007f7e0ffULL, 0x0000001007457824ULL, 0x000fe200078e00ffULL,
0xfffffff042077812ULL, 0x000fc400078ee206ULL, 0xfffffff046427812ULL, 0x000fe400078ee241ULL,
0x0000000569467210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x0000004069437210ULL, 0x000fe40007f9e0ffULL, 0xfffffff0453f7812ULL, 0x000fe200078ee23eULL,
0x000000ffff417224ULL, 0x000fe200000e06ffULL, 0x00005e0046457a11ULL, 0x000fe200078040ffULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x0000004947407210ULL, 0x000fc40007fbe0ffULL,
0x00005e00433e7a11ULL, 0x040fe400078840ffULL, 0x00005e0044067a11ULL, 0x000fe400078640ffULL,
0x00005f0046467a11ULL, 0x000fe200000f4441ULL, 0x000000ffff417224ULL, 0x000fe200028e0648ULL,
0x00005f0043437a11ULL, 0x000fe400020f4404ULL, 0x00005f0044447a11ULL, 0x000fe400018f4405ULL,
0x0000004945047210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000404a7faeULL, 0x0003e2000b901c46ULL, 0x0000004906067210ULL, 0x000fc40007f7e0ffULL,
0x000000493e3e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0646ULL,
0x0000c00042427811ULL, 0x000fe400078e20ffULL, 0x0000c00007407811ULL, 0x002fe200078e20ffULL,
0x000000ffff077224ULL, 0x000fe200018e0644ULL, 0x0000c0003f417811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe400020e0643ULL, 0x0000000004407faeULL, 0x0003e8000b901c46ULL,
0x0000000006417faeULL, 0x0003e8000b901c46ULL, 0x000000003e427faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000e64000c80043fULL, 0x000000ffff447224ULL, 0x002fc400078e0045ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x0106b400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007804851ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006043e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000003e06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013f3f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000033ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff057819ULL, 0x000fe40000011603ULL, 0x0000541004047816ULL, 0x000fe20000000004ULL,
0x00013b827f007947ULL, 0x000fea000b800000ULL, 0x00001f0504347589ULL, 0x0002a400000e0000ULL,
0x0000000805357810ULL, 0x000fe20007ffe0ffULL, 0x00013bb27f007947ULL, 0x000fea000b800000ULL,
0x00001f3504357589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001005477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0004ULL,
0x0000474000487802ULL, 0x000fc40000000f00ULL, 0x0001488000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001805477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0004ULL, 0x0000479000487802ULL, 0x000fc40000000f00ULL,
0x0001483000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000e000553e7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000e000563f7811ULL, 0x000fe200078e20ffULL, 0x0000000152547824ULL, 0x000fc400078e0254ULL,
0x000000003e40783bULL, 0x000f220000004200ULL, 0x0000000152537824ULL, 0x000fe400078e0253ULL,
0x0000000858497824ULL, 0x040fe200078e00ffULL, 0x000000003f04783bULL, 0x00ae620000004200ULL,
0x0000000858587824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x010fe20000011440ULL,
0x0000010040487824ULL, 0x040fe200078e00ffULL, 0x00008880407b7816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fc40000011441ULL,
0x00008880417d7816ULL, 0x000fe200000000ffULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff6b7819ULL, 0x000fe40000011442ULL,
0x0000888042747816ULL, 0x000fe400000000ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000004000787306ULL, 0x0007220000200c00ULL, 0x00000018ff6c7819ULL, 0x000fc40000011443ULL,
0x0000888043737816ULL, 0x000fe400000000ffULL, 0x00000018ff6a7819ULL, 0x002fe40000011405ULL,
0x00008880056e7816ULL, 0x000fe200000000ffULL, 0x00000048007c7306ULL, 0x000fe20000200c00ULL,
0x0000010041407824ULL, 0x048fe200078e00ffULL, 0x00000018ff477819ULL, 0x004fe20000011404ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00008880046f7816ULL, 0x000fe400000000ffULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000007b007b7306ULL, 0x000e620000200c00ULL, 0x00000018ff457819ULL, 0x000fe40000011406ULL,
0x00000018ff467819ULL, 0x000fe40000011407ULL, 0x0000541078767816ULL, 0x010fc60000000076ULL,
0x00000040007e7306ULL, 0x0005f00000200c00ULL, 0x00000041007a7306ULL, 0x0007e20000200c00ULL,
0x0000010042407824ULL, 0x044fe200078e00ffULL, 0x000054107b7c7816ULL, 0x002fe2000000007cULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000001052417824ULL, 0x008fe200078e00ffULL,
0x0000004000757306ULL, 0x0003e80000200c00ULL, 0xfffffff041547812ULL, 0x000fe200078ee254ULL,
0x0000010043417824ULL, 0x040fe400078e00ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x0000004200727306ULL, 0x0005e20000200c00ULL, 0x0000e00054407811ULL, 0x002fc400078e20ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x000000004054783bULL, 0x000e640000004200ULL, 0x0000004100797306ULL, 0x0007e20000200c00ULL,
0x0000010004427824ULL, 0x044fe400078e00ffULL, 0x0001000004047824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000004300717306ULL, 0x000fe20000200c00ULL,
0x0000001052417824ULL, 0x008fe200078e00ffULL, 0x00000018ff047819ULL, 0x000fc80000011404ULL,
0xfffffff041417812ULL, 0x000fe400078ee253ULL, 0x00000042006d7306ULL, 0x0005e40000200c00ULL,
0x0000e00041417811ULL, 0x000fca00078e20ffULL, 0x000000004150783bULL, 0x000ee20000004200ULL,
0x0000007d007d7306ULL, 0x000f220000200c00ULL, 0x0000010005427824ULL, 0x044fe400078e00ffULL,
0x0001000005057824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x0000010055487824ULL, 0x002fe200078e00ffULL, 0x00008880574a7816ULL, 0x000fe200000000ffULL,
0x0000010054437824ULL, 0x000fca00078e00ffULL, 0x0000004200707306ULL, 0x0003e20000200c00ULL,
0x000054107d7d7816ULL, 0x010fe4000000007eULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff437819ULL, 0x000fc60000011443ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x002fe40000011454ULL, 0x000054107a777816ULL, 0x004fca0000000077ULL,
0x00000042005c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7f7819ULL, 0x008fce0000011453ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x002fce0000011455ULL,
0x00000042005d7306ULL, 0x0003f00000200c00ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x002fce0000011456ULL, 0x0000004200617306ULL, 0x0003f00000200c00ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x002fce0000011457ULL,
0x0000004200657306ULL, 0x0003f00000200c00ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x002fce0000011450ULL, 0x0000004200817306ULL, 0x0003f00000200c00ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x002fce0000011451ULL,
0x0000004200857306ULL, 0x0003f00000200c00ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x002fce0000011452ULL, 0x0000004200897306ULL, 0x0003f00000200c00ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000888054427816ULL, 0x042fe200000000ffULL,
0x0001000054547824ULL, 0x000fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x00000042005a7306ULL, 0x0002b00000200c00ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x0000888055427816ULL, 0x002fce00000000ffULL, 0x00000042005b7306ULL, 0x0003e20000200c00ULL,
0x000054105a5a7816ULL, 0x004fe40000000043ULL, 0x0000000659437810ULL, 0x000fc80007ffe0ffULL,
0xfffffff858437812ULL, 0x000fe200078ee243ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0001000055427824ULL, 0x002fe200078e00ffULL, 0x0000541054547816ULL, 0x008fc8000000005cULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000004800557306ULL, 0x0002b00000200c00ULL,
0x00000042005e7306ULL, 0x0007220000200c00ULL, 0x0000888056487816ULL, 0x002fc400000000ffULL,
0x000054105b5b7816ULL, 0x004fc60000000055ULL, 0x000000ffff427224ULL, 0x008fe400078e0048ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000010056487824ULL, 0x040fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000042005f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x000054105e557816ULL, 0x010fca000000005dULL, 0x0000004800607306ULL, 0x0004e20000200c00ULL,
0x0000000459427810ULL, 0x002fc80007ffe0ffULL, 0xfffffff849427812ULL, 0x000fe200078ee242ULL,
0x0000010057497824ULL, 0x040fe400078e00ffULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x0000005600627306ULL, 0x0003220000200c00ULL, 0x000000ffff487224ULL, 0x004fe200078e004aULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x000054105f587816ULL, 0x008fc40000000060ULL, 0x0000004800637306ULL, 0x0005e20000200c00ULL,
0x0000888050567816ULL, 0x002fce00000000ffULL, 0x0000004900647306ULL, 0x0002e20000200c00ULL,
0x0000a00042487811ULL, 0x004fe400078e20ffULL, 0x00005410625c7816ULL, 0x010fca0000000061ULL,
0x0000005700667306ULL, 0x0005220000200c00ULL, 0x000000004848783bULL, 0x002e6e0000000200ULL,
0x0000005600677306ULL, 0x0009e20000200c00ULL, 0x0000010050577824ULL, 0x044fe200078e00ffULL,
0x0000541063597816ULL, 0x008fe20000000064ULL, 0x0001000050507824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000888051567816ULL, 0x010fe400000000ffULL,
0x00005410665d7816ULL, 0x000fca0000000065ULL, 0x0000005700807306ULL, 0x0005f00000200c00ULL,
0x0000005000827306ULL, 0x0007220000200c00ULL, 0x0000010051577824ULL, 0x044fe400078e00ffULL,
0x0001000051517824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x000000344848a232ULL, 0x082fe20000000000ULL, 0x0000888052507816ULL, 0x008fe200000000ffULL,
0x000000344a4aa232ULL, 0x000fe20000000000ULL, 0x0000005600837306ULL, 0x000fe20000200c00ULL,
0x000000354949a232ULL, 0x080fe20000000000ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x000000354b4ba232ULL, 0x000fe20000000000ULL, 0x0000541082607816ULL, 0x010fc80000000081ULL,
0x0000005000877306ULL, 0x0003e40000200c00ULL, 0x0000005a481c723cULL, 0x040f6c000000181cULL,
0x0000005700847306ULL, 0x0005e20000200c00ULL, 0x0000888053507816ULL, 0x042fe200000000ffULL,
0x000000584858723cULL, 0x040bec0000001808ULL, 0x0000005100867306ULL, 0x0002e20000200c00ULL,
0x00010000530a7824ULL, 0x020fe200078e00ffULL, 0x000000544854723cULL, 0x004b680000001820ULL,
0x00000018ff0a7819ULL, 0x000fc4000001140aULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x000000ffff207224ULL, 0x020fe200078e0050ULL, 0x0000541067507816ULL, 0x000fe20000000080ULL,
0x0000010053217824ULL, 0x000fe200078e00ffULL, 0x0000005c485c723cULL, 0x000fe2000000180cULL,
0x0000010052517824ULL, 0x042fe400078e00ffULL, 0x0001000052527824ULL, 0x000fe200078e00ffULL,
0x00000020008a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff087819ULL, 0x000fe40000011421ULL,
0x00000018ff517819ULL, 0x000fc40000011451ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000541086617816ULL, 0x008fe20000000085ULL, 0x0000005100887306ULL, 0x0004e20000200c00ULL,
0x0000a00043207811ULL, 0x002fca00078e20ffULL, 0x000000604860723cULL, 0x000b620000001814ULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x0000000800097306ULL, 0x000f220000200c00ULL,
0x0000541083517816ULL, 0x004fc80000000084ULL, 0x000054106e157816ULL, 0x020fc60000000070ULL,
0x0000005200087306ULL, 0x0004a20000200c00ULL, 0x0000541087647816ULL, 0x008fce0000000088ULL,
0x0000000a000a7306ULL, 0x000ee20000200c00ULL, 0x000054108a657816ULL, 0x010fe20000000009ULL,
0x000000504850723cULL, 0x004b620000001810ULL, 0x0000541008087816ULL, 0x000fca0000000089ULL,
0x0000000400807306ULL, 0x0005240000200c00ULL, 0x000000644864723cULL, 0x000b640000001818ULL,
0x0000541074107816ULL, 0x020fe40000000075ULL, 0x0000541073117816ULL, 0x000fe40000000079ULL,
0x000054100a097816ULL, 0x008fe2000000007fULL, 0x0000000500197306ULL, 0x0007220000200c00ULL,
0x0000888006047816ULL, 0x004fca00000000ffULL, 0x00000008484c723cULL, 0x000b62000000184cULL,
0x000000342020a232ULL, 0x082fe20000000000ULL, 0x0000000400487306ULL, 0x0203e20000200c00ULL,
0x0000010006057824ULL, 0x048fe200078e00ffULL, 0x000000342222a232ULL, 0x000fe20000000000ULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x000000352121a232ULL, 0x080fe20000000000ULL,
0x0000541080187816ULL, 0x010fe20000000047ULL, 0x000000352323a232ULL, 0x000fe20000000000ULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000888007047816ULL, 0x002fc400000000ffULL,
0x0000000500497306ULL, 0x0002a20000200c00ULL, 0x00000018ff067819ULL, 0x000fe20000011406ULL,
0x0000007c2008723cULL, 0x000b62000000181cULL, 0x0000541019197816ULL, 0x000fca000000006aULL,
0x00000004001d7306ULL, 0x0207e20000200c00ULL, 0x0000010007057824ULL, 0x042fe200078e00ffULL,
0x00000076200c723cULL, 0x000b620000001854ULL, 0x0001000007077824ULL, 0x000fc600078e00ffULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x00000018ff147819ULL, 0x000fe20000011407ULL,
0x00000006004a7306ULL, 0x000e620000200c00ULL, 0x0000541072047816ULL, 0x008fe2000000006bULL,
0x000000102010723cULL, 0x000b620000001858ULL, 0x00005410481c7816ULL, 0x004fca0000000049ULL,
0x00000005001e7306ULL, 0x0004e40000200c00ULL, 0x000000182018723cULL, 0x000b6c0000001860ULL,
0x00000014004b7306ULL, 0x0009220000200c00ULL, 0x0000541071057816ULL, 0x004fe4000000006cULL,
0x000054104a4a7816ULL, 0x002fc40000000045ULL, 0x000054101d1d7816ULL, 0x008fc6000000001eULL,
0x000000042004723cULL, 0x000b62000000185cULL, 0x000054106f147816ULL, 0x010fe4000000006dULL,
0x000054104b4b7816ULL, 0x000fca0000000046ULL, 0x000000142014723cULL, 0x040b700000001850ULL,
0x0000001c201c723cULL, 0x040b700000001864ULL, 0x0000004a2020723cULL, 0x000b62000000184cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff467f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000243d00720cULL, 0x000fe20003f06070ULL, 0x01068800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4c7224ULL, 0x022fc400078e0047ULL, 0x000000ffff467224ULL, 0x000fd200078e0068ULL,
0x0000c7a000000947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fc40000015200ULL,
0x0106bc00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe4000780484cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0000004846457210ULL, 0x000fca0007f1e1ffULL,
0x0000000149487824ULL, 0x000fe200000e0e47ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011448ULL,
0x0000004528287211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e0648ULL,
0x0000000228287819ULL, 0x000fc80000001245ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe4000780484cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000203d287810ULL, 0x000fe20007ffe0ffULL,
0x0000000127467824ULL, 0x000fe200078e0236ULL, 0x0000000436527810ULL, 0x000fe40007ffe0ffULL,
0x0000002824457217ULL, 0x000fe20007800000ULL, 0x0000000146477824ULL, 0x000fe200078e0203ULL,
0x00000002364a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001046507824ULL, 0x000fe200078e00ffULL,
0x0000000636547810ULL, 0x000fe20007ffe0ffULL, 0x0000000145457824ULL, 0x000fe200078e0a28ULL,
0x0000006000287811ULL, 0x000fe200078e38ffULL, 0x0000000127497824ULL, 0x040fe200078e0252ULL,
0xfffffff050507812ULL, 0x000fe200078ee247ULL, 0x0000000127487824ULL, 0x040fe200078e024aULL,
0x0000004527457217ULL, 0x000fe20007800000ULL, 0x0000000146467824ULL, 0x000fe200078e0228ULL,
0x000000f02e4f7812ULL, 0x000fe200078ec0ffULL, 0x00000001494b7824ULL, 0x140fe200078e0203ULL,
0x0000e00050507811ULL, 0x000fe200078e20ffULL, 0x0000001049537824ULL, 0x000fe200078e00ffULL,
0x00000046694e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000148477824ULL, 0x000fc400078e0203ULL,
0x0000001048517824ULL, 0x040fe200078e00ffULL, 0xfffffff053537812ULL, 0x000fe200078ee24bULL,
0x0000000148467824ULL, 0x000fe400078e0228ULL, 0x00000001274b7824ULL, 0x000fe200078e0254ULL,
0xfffffff051517812ULL, 0x000fe200078ee247ULL, 0x0000000149477824ULL, 0x100fe200078e0228ULL,
0x0000004669467210ULL, 0x000fe20007f9e0ffULL, 0x000000014b4c7824ULL, 0x000fe200078e0203ULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000104b557824ULL, 0x000fe200078e00ffULL,
0x0000004769477210ULL, 0x000fe20007f7e0ffULL, 0x000000014b287824ULL, 0x000fe200078e0228ULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200000e06ffULL,
0x00005e004e487a11ULL, 0x000fe200078040ffULL, 0x0000000145457824ULL, 0x000fe200078e0a27ULL,
0xfffffff055557812ULL, 0x000fe200078ee24cULL, 0x000000ffff4d7224ULL, 0x000fe200020e06ffULL,
0x00005e00464c7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff4b7224ULL, 0x000fe200018e06ffULL,
0x0000002869287210ULL, 0x000fc40007f5e0ffULL, 0x00005f004e4e7a11ULL, 0x000fe400000f4449ULL,
0x00005e0047497a11ULL, 0x000fe400078a40ffULL, 0x000000453600720cULL, 0x000fe40003f86070ULL,
0x00005f00464d7a11ULL, 0x000fe400030f444dULL, 0x0000004f48467210ULL, 0x000fe20007fde0ffULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x000000454a00720cULL, 0x000fc40003f06070ULL,
0x00005f00474b7a11ULL, 0x000fe200028f444bULL, 0x000000ffff477224ULL, 0x000fe200030e064eULL,
0x00005e00284a7a11ULL, 0x000fe400078a40ffULL, 0x000000455200720cULL, 0x000fe40003f66070ULL,
0x00005f0028287a11ULL, 0x000fe200028f4448ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046507faeULL, 0x0003e2000e101c46ULL, 0x0000004f4c487210ULL, 0x000fe40007fbe0ffULL,
0x000000455400720cULL, 0x000fc40003f46070ULL, 0x0000e00055557811ULL, 0x000fe400078e20ffULL,
0x0000004f49467210ULL, 0x082fe20007f9e0ffULL, 0x000000ffff497224ULL, 0x000fe200028e064dULL,
0x0000004f4a4a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff477224ULL, 0x000fe200020e064bULL,
0x0000000048517faeULL, 0x0003e2000c101c46ULL, 0x000000ffff4b7224ULL, 0x000fc600028e0628ULL,
0x0000000046537faeULL, 0x0003e8000d901c46ULL, 0x000000004a557faeULL, 0x0003e2000d101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000000127287824ULL, 0x000fe200078e0236ULL,
0x0000006000467811ULL, 0x000fe400078e38ffULL, 0x000000f02e4f7812ULL, 0x000fe200078ec0ffULL,
0x0000000128457824ULL, 0x040fe200078e0203ULL, 0x0000000228487810ULL, 0x040fe20007ffe0ffULL,
0x0000001028507824ULL, 0x040fe200078e00ffULL, 0x0000000428497810ULL, 0x000fc40007ffe0ffULL,
0x00000006284b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000148477824ULL, 0x000fe200078e0203ULL,
0xfffffff050507812ULL, 0x000fe200078ee245ULL, 0x0000001048517824ULL, 0x000fe400078e00ffULL,
0x0000000128457824ULL, 0x100fe200078e0246ULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x0000000148287824ULL, 0x100fe200078e0246ULL, 0xfffffff051517812ULL, 0x000fe200078ee247ULL,
0x00000001494a7824ULL, 0x100fe200078e0203ULL, 0x0000004569477210ULL, 0x000fe20007f7e0ffULL,
0x0000000149457824ULL, 0x100fe200078e0246ULL, 0x0000002869287210ULL, 0x000fe20007f1e0ffULL,
0x000000014b467824ULL, 0x000fe200078e0246ULL, 0x00005e00474c7a11ULL, 0x000fe200078840ffULL,
0x0000001049527824ULL, 0x000fe200078e00ffULL, 0x0000004569457210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x0000004669467210ULL, 0x000fe20007f7e0ffULL,
0x000000014b497824ULL, 0x040fe200078e0203ULL, 0xfffffff052527812ULL, 0x000fe200078ee24aULL,
0x000000104b537824ULL, 0x000fe200078e00ffULL, 0x00005f00474d7a11ULL, 0x000fe200020f4448ULL,
0x000000ffff4e7224ULL, 0x000fe200000e06ffULL, 0x00005e0028477a11ULL, 0x000fe200078040ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0xfffffff053537812ULL, 0x000fe200078ee249ULL,
0x000000ffff497224ULL, 0x000fe200010e06ffULL, 0x00005e00464a7a11ULL, 0x000fc400078640ffULL,
0x00005e0045487a11ULL, 0x040fe400078440ffULL, 0x0000004f4c4c7210ULL, 0x080fe40007f9e0ffULL,
0x00005f00284e7a11ULL, 0x000fe400000f444eULL, 0x00005f00464b7a11ULL, 0x000fe200018f444bULL,
0x000000ffff4d7224ULL, 0x000fe200020e064dULL, 0x00005f0045497a11ULL, 0x000fe400010f4449ULL,
0x0000004f47467210ULL, 0x000fc40007f1e0ffULL, 0x0000004f48487210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004c507faeULL, 0x0003e2000b901c46ULL,
0x0000004f4a4a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff477224ULL, 0x000fe200000e064eULL,
0x0000e00051287811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200010e0649ULL,
0x0000e00052457811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe400018e064bULL,
0x0000000046287faeULL, 0x0005e2000b901c46ULL, 0x0000e000534c7811ULL, 0x002fc600078e20ffULL,
0x0000000048457faeULL, 0x0005e8000b901c46ULL, 0x000000004a4c7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000000012c287810ULL, 0x000fc80007ffe0ffULL,
0x000000252800720cULL, 0x000fe20003f06070ULL, 0xffffffffff287424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000012a467810ULL, 0x002fe20007ffe02cULL,
0x00000004ff477424ULL, 0x000fc800078e00ffULL, 0x0000600046467625ULL, 0x000fca00078e0047ULL,
0x0000000646287981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff607f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01062800274a7f8cULL, 0x0022e4000c80043fULL, 0x0000000000467805ULL, 0x000fc40000015200ULL,
0x01062c0027457984ULL, 0x000e640000000800ULL, 0x8000000045ff7812ULL, 0x00afe4000780484bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0000004846487210ULL, 0x000fca0007f1e1ffULL,
0x0000000149497824ULL, 0x000fe200000e0e47ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff457819ULL, 0x000fc80000011449ULL,
0x0000004845457211ULL, 0x000fca00078110ffULL, 0x000000ffff487224ULL, 0x000fca00000e0649ULL,
0x0000000245457819ULL, 0x000fc80000001248ULL, 0x000000450000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01062c0027457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010080002f457984ULL, 0x000e680000000800ULL, 0x010280002f4a7984ULL, 0x0006a20000000800ULL,
0x000000684500720bULL, 0x002fe20003f1d000ULL, 0x00011cf27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004b7806ULL, 0x008fc800000e0100ULL, 0x0000ffff4bff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff477424ULL, 0x000fc400078e00ffULL,
0x000000ffff467224ULL, 0x000fd200078e0068ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000010200780cULL, 0x000fe40003f05270ULL, 0x000000684500720bULL, 0x000fe20003f54000ULL,
0x00011cb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x000fc400010e0100ULL,
0x0000006845478209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x010480472f008388ULL, 0x0003e40000000800ULL, 0x0000991046477816ULL, 0x002fc800000000ffULL,
0x000000ff4700720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000006845477209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff46ff7812ULL, 0x000fc6000780c0ffULL, 0x0000006847477221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b47477820ULL, 0x000fc80000410000ULL, 0x00000047004c7308ULL, 0x000e640000000800ULL,
0x0000004c29297220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff477819ULL, 0x000fe20000011603ULL, 0x00011bf27f007947ULL, 0x000fea000b800000ULL,
0x00001f474c477589ULL, 0x0002e400000e0000ULL, 0x0000004708087220ULL, 0x08cfe20000410000ULL,
0x0000004709097220ULL, 0x080fe20000410000ULL, 0x000000470c0c7220ULL, 0x080fe20000410000ULL,
0x000000470d0d7220ULL, 0x080fe20000410000ULL, 0x0000004710107220ULL, 0x080fe20000410000ULL,
0x0000004711117220ULL, 0x080fe20000410000ULL, 0x0000004704047220ULL, 0x080fe20000410000ULL,
0x0000004705057220ULL, 0x080fe20000410000ULL, 0x0000004714147220ULL, 0x080fe20000410000ULL,
0x0000004715157220ULL, 0x080fe20000410000ULL, 0x0000004718187220ULL, 0x080fe20000410000ULL,
0x0000004719197220ULL, 0x080fe20000410000ULL, 0x000000471c1c7220ULL, 0x080fe20000410000ULL,
0x000000471d1d7220ULL, 0x080fe20000410000ULL, 0x0000004720207220ULL, 0x080fe20000410000ULL,
0x0000004721217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0046ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803477811ULL, 0x000fe200078ff0ffULL, 0x00011ad27f007947ULL, 0x000fea000b800000ULL,
0x00001f474c477589ULL, 0x00066400000e0000ULL, 0x000000470a0a7220ULL, 0x086fe20000410000ULL,
0x000000470b0b7220ULL, 0x080fe20000410000ULL, 0x000000470e0e7220ULL, 0x080fe20000410000ULL,
0x000000470f0f7220ULL, 0x080fe20000410000ULL, 0x0000004712127220ULL, 0x080fe20000410000ULL,
0x0000004713137220ULL, 0x080fe20000410000ULL, 0x0000004706067220ULL, 0x080fe20000410000ULL,
0x0000004707077220ULL, 0x080fe20000410000ULL, 0x0000004716167220ULL, 0x080fe20000410000ULL,
0x0000004717177220ULL, 0x080fe20000410000ULL, 0x000000471a1a7220ULL, 0x080fe20000410000ULL,
0x000000471b1b7220ULL, 0x080fe20000410000ULL, 0x000000471e1e7220ULL, 0x080fe20000410000ULL,
0x000000471f1f7220ULL, 0x080fe20000410000ULL, 0x0000004722227220ULL, 0x080fe20000410000ULL,
0x0000004723237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff46ff7812ULL, 0x000fe2000780084bULL, 0x00000001ff477424ULL, 0x000fe200078e00ffULL,
0x0000006845687209ULL, 0x000fca0007810000ULL, 0x000000ffff467224ULL, 0x000fcc00078e0068ULL,
0x8000006845450221ULL, 0x100fe20000010000ULL, 0x000000ffff460224ULL, 0x000fe200078e0068ULL,
0x00007610ff470816ULL, 0x000fe40000000047ULL, 0x3fb8aa3b45450820ULL, 0x000fc80000410000ULL,
0x0000004500330308ULL, 0x000e640000000800ULL, 0x000000334a4a0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000294a297221ULL, 0x004fc20000010000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x008fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a484a7210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4b7824ULL, 0x000fe200000e0e49ULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff457819ULL, 0x000fc8000001144bULL, 0x0000004a45457211ULL, 0x000fca00078110ffULL,
0x000000ffff4a7224ULL, 0x000fca00000e064bULL, 0x0000000245457819ULL, 0x000fc8000000124aULL,
0x000000450000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff457984ULL, 0x000e640000000800ULL, 0x8000000045ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991047447816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff4400720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000033ff34723eULL, 0x000fe400000000ffULL,
0x00000002ff457819ULL, 0x000fe40000011603ULL, 0x0000541034447816ULL, 0x000fe20000000034ULL,
0x000116827f007947ULL, 0x000fea000b800000ULL, 0x00001f4544347589ULL, 0x0002a400000e0000ULL,
0x0000000845357810ULL, 0x000fe20007ffe0ffULL, 0x000116b27f007947ULL, 0x000fea000b800000ULL,
0x00001f3544357589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001045477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0044ULL,
0x00006e2000487802ULL, 0x000fc40000000f00ULL, 0x000121a000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001845477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0044ULL, 0x00006e7000487802ULL, 0x000fc40000000f00ULL,
0x0001215000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003750783bULL, 0x000ee80000004200ULL,
0x000000003854783bULL, 0x000ea80000004200ULL, 0x00000000394c783bULL, 0x000e680000004200ULL,
0x000000003a48783bULL, 0x000e640000004200ULL, 0x00000018ff447819ULL, 0x00afe20000011450ULL,
0x00000100505d7824ULL, 0x040fe200078e00ffULL, 0x00008880505c7816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x0000888051697816ULL, 0x000fe200000000ffULL,
0x00000044005e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff587819ULL, 0x004fc40000011454ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff657819ULL, 0x000fe4000001144cULL,
0x00000018ff667819ULL, 0x000fe2000001144dULL, 0x00000050005f7306ULL, 0x0004e20000200c00ULL,
0x00000018ff447819ULL, 0x002fe40000011451ULL, 0x00000018ff5a7819ULL, 0x000fe40000011452ULL,
0x00000018ff5b7819ULL, 0x000fc40000011453ULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000000ffff507224ULL, 0x004fe200078e0069ULL,
0x00000018ff637819ULL, 0x000fe2000001144eULL, 0x0000010051697824ULL, 0x040fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe2000001144fULL, 0x0001000051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011455ULL, 0x00000050006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff697819ULL, 0x000fc40000011469ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff677819ULL, 0x000fe40000011456ULL, 0x00000018ff687819ULL, 0x000fe20000011457ULL,
0x00000051006c7306ULL, 0x0005e20000200c00ULL, 0x0000888052507816ULL, 0x002fe400000000ffULL,
0x000054105f5e7816ULL, 0x008fe4000000005eULL, 0x00000018ff477819ULL, 0x000fc40000011448ULL,
0x00000018ff627819ULL, 0x000fe20000011449ULL, 0x00000050006d7306ULL, 0x0003e20000200c00ULL,
0x0000010052517824ULL, 0x044fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe2000001144bULL,
0x0001000052527824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000888053507816ULL, 0x002fce00000000ffULL, 0x00000051006e7306ULL, 0x0002f00000200c00ULL,
0x00000050006f7306ULL, 0x0007e20000200c00ULL, 0x0000010053517824ULL, 0x042fe200078e00ffULL,
0x000054105c5c7816ULL, 0x004fe2000000005dULL, 0x0001000053537824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000005200707306ULL, 0x000fe20000200c00ULL, 0x0000888054507816ULL, 0x008fe400000000ffULL,
0x000054106d6e7816ULL, 0x000fca000000006eULL, 0x0000005100717306ULL, 0x0002b00000200c00ULL,
0x0000005000737306ULL, 0x0007e20000200c00ULL, 0x0000010054517824ULL, 0x042fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000005300727306ULL, 0x000fe20000200c00ULL,
0x0000888055507816ULL, 0x008fe400000000ffULL, 0x000054106f6f7816ULL, 0x004fca0000000071ULL,
0x0000005100747306ULL, 0x0003f00000200c00ULL, 0x0000005000767306ULL, 0x0005e20000200c00ULL,
0x0000010055517824ULL, 0x042fe400078e00ffULL, 0x0001000055557824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005400757306ULL, 0x0003e20000200c00ULL,
0x0000888056507816ULL, 0x004fe400000000ffULL, 0x00000018ff557819ULL, 0x000fca0000011455ULL,
0x0000005100777306ULL, 0x0005e20000200c00ULL, 0x000088804d547816ULL, 0x002fce00000000ffULL,
0x0000005000797306ULL, 0x0003e20000200c00ULL, 0x0000010056517824ULL, 0x044fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x0000888057507816ULL, 0x002fe400000000ffULL,
0x00000018ff567819ULL, 0x000fca0000011456ULL, 0x00000051007a7306ULL, 0x0003f00000200c00ULL,
0x00000050007c7306ULL, 0x0007e20000200c00ULL, 0x0000010057517824ULL, 0x042fe200078e00ffULL,
0x000054106a5d7816ULL, 0x004fe20000000069ULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000044006b7306ULL, 0x0002a20000200c00ULL,
0x000088804c507816ULL, 0x008fe400000000ffULL, 0x00000018ff577819ULL, 0x000fca0000011457ULL,
0x00000051007d7306ULL, 0x0007e20000200c00ULL, 0x00000018ff447819ULL, 0x002fce000001144aULL,
0x00000050007f7306ULL, 0x0003e20000200c00ULL, 0x000001004c517824ULL, 0x008fe200078e00ffULL,
0x000054106c5f7816ULL, 0x004fe2000000006bULL, 0x000100004c4c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x0000a8003b507811ULL, 0x002fce00078e20ffULL,
0x0000004c00817306ULL, 0x0003f00000200c00ULL, 0x0000005100807306ULL, 0x0007e20000200c00ULL,
0x000000ffff4c7224ULL, 0x002fe200078e0054ULL, 0x00005410705a7816ULL, 0x004fe2000000005aULL,
0x000001004d547824ULL, 0x000fc400078e00ffULL, 0x000100004d4d7824ULL, 0x000fc600078e00ffULL,
0x0000004c00827306ULL, 0x0003e20000200c00ULL, 0x000000005050783bULL, 0x008ea20000000200ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff547819ULL, 0x000fc80000011454ULL,
0x0000004d00847306ULL, 0x0007e20000200c00ULL, 0x000088804e4c7816ULL, 0x002fce00000000ffULL,
0x0000004c00857306ULL, 0x0003e20000200c00ULL, 0x000001004e4d7824ULL, 0x048fe400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000005400837306ULL, 0x000fe20000200c00ULL,
0x000088804f4c7816ULL, 0x002fce00000000ffULL, 0x0000004d00867306ULL, 0x0003f00000200c00ULL,
0x0000004c00887306ULL, 0x0007e20000200c00ULL, 0x000001004f4d7824ULL, 0x042fe200078e00ffULL,
0x000000345050a232ULL, 0x084fe20000000000ULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x000000345252a232ULL, 0x000fc40000000000ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x000000355151a232ULL, 0x080fe20000000000ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000004e00877306ULL, 0x000fe20000200c00ULL, 0x00008880484c7816ULL, 0x008fe200000000ffULL,
0x000000355353a232ULL, 0x000fcc0000000000ULL, 0x0000004d00897306ULL, 0x0003e20000200c00ULL,
0x0000005c5008723cULL, 0x040bee0000001808ULL, 0x0000004c006a7306ULL, 0x0005e20000200c00ULL,
0x00000100484d7824ULL, 0x002fe200078e00ffULL, 0x00005410795c7816ULL, 0x020fe2000000007aULL,
0x0000005e500c723cULL, 0x000fe2000000180cULL, 0x000054107c5d7816ULL, 0x000fe2000000007dULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc4000001144dULL,
0x0000004f00697306ULL, 0x0003e20000200c00ULL, 0x0000a8003c4c7811ULL, 0x004fe400078e20ffULL,
0x0000006e5010723cULL, 0x000f620000001810ULL, 0x00000018ff487819ULL, 0x000fc80000011448ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000000004c4c783bULL, 0x002e640000000200ULL,
0x0000005c505c723cULL, 0x000fea000000181cULL, 0x0000005500787306ULL, 0x0007f00000200c00ULL,
0x0000005800587306ULL, 0x000e620000200c00ULL, 0x0000888049557816ULL, 0x008fc400000000ffULL,
0x00005410725b7816ULL, 0x004fca000000005bULL, 0x0000005900597306ULL, 0x000ea40000200c00ULL,
0x0000005a5004723cULL, 0x000bec0000001804ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00000100495a7824ULL, 0x020fe200078e00ffULL, 0x0000541075587816ULL, 0x002fe20000000058ULL,
0x0001000049497824ULL, 0x000fc600078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000541078597816ULL, 0x004fe20000000059ULL,
0x000000344c4ca232ULL, 0x080fe20000000000ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x000000344e4ea232ULL, 0x000fe40000000000ULL, 0x000000354d4da232ULL, 0x080fe40000000000ULL,
0x00000056007b7306ULL, 0x000e620000200c00ULL, 0x000000354f4fa232ULL, 0x000fce0000000000ULL,
0x00000057007e7306ULL, 0x000eb00000200c00ULL, 0x00000054006b7306ULL, 0x0007f00000200c00ULL,
0x0000005a006d7306ULL, 0x0003e20000200c00ULL, 0x000000ffff547224ULL, 0x008fe200078e0055ULL,
0x0000541076557816ULL, 0x000fcc0000000077ULL, 0x00000054006c7306ULL, 0x0007e20000200c00ULL,
0x000000585058723cULL, 0x002bee0000001818ULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x0000541073547816ULL, 0x008fe40000000074ULL, 0x0000541085187816ULL, 0x020fc40000000086ULL,
0x0000541088197816ULL, 0x000fc60000000089ULL, 0x000000545054723cULL, 0x000b620000001814ULL,
0x0000006600667306ULL, 0x000eec0000200c00ULL, 0x000054107b147816ULL, 0x020fe20000000067ULL,
0x000000184c18723cULL, 0x000be20000001810ULL, 0x000054107e157816ULL, 0x004fe20000000068ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000088804a167816ULL, 0x000fc400000000ffULL,
0x00005410811c7816ULL, 0x002fe40000000065ULL, 0x000054106a107816ULL, 0x020fe2000000006bULL,
0x000000145050723cULL, 0x000b620000001820ULL, 0x00005410841d7816ULL, 0x008fe20000000066ULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x000054106c117816ULL, 0x000fc8000000006dULL,
0x000054107f207816ULL, 0x020fe20000000080ULL, 0x000001004a147824ULL, 0x000fe200078e00ffULL,
0x0000541082217816ULL, 0x000fe20000000083ULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x000088804b157816ULL, 0x000fe200000000ffULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001c4c1c723cULL, 0x000f62000000180cULL,
0x00000018ff4a7819ULL, 0x000fca000001144aULL, 0x0000006200627306ULL, 0x000fe40000200c00ULL,
0x000000204c20723cULL, 0x040b6c0000001808ULL, 0x0000004800487306ULL, 0x000ea20000200c00ULL,
0x000001004b097824ULL, 0x060fe200078e00ffULL, 0x000000104c10723cULL, 0x000b620000001854ULL,
0x000100004b4b7824ULL, 0x000fc400078e00ffULL, 0x000000ffff087224ULL, 0x000fe200078e0015ULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000004900497306ULL, 0x000ee20000200c00ULL, 0x0000541069157816ULL, 0x002fe40000000064ULL,
0x00005410480c7816ULL, 0x004fca0000000047ULL, 0x0000001600677306ULL, 0x000ff00000200c00ULL,
0x0000001400687306ULL, 0x0002a20000200c00ULL, 0x00005410490d7816ULL, 0x008fce0000000062ULL,
0x00000008000a7306ULL, 0x0005e20000200c00ULL, 0x0000541087147816ULL, 0x002fe20000000063ULL,
0x0000000c4c0c723cULL, 0x040b6c0000001858ULL, 0x0000000900097306ULL, 0x000e620000200c00ULL,
0x0000541067087816ULL, 0x004fe20000000068ULL, 0x000000144c14723cULL, 0x000b6c0000001804ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x000054100a097816ULL, 0x002fce0000000009ULL, 0x0000004a004a7306ULL, 0x000e620000200c00ULL,
0x000000084c08723cULL, 0x000b6e000000185cULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x000054104a447816ULL, 0x002fe40000000044ULL, 0x000054104b457816ULL, 0x004fce0000000045ULL,
0x000000444c4c723cULL, 0x000b620000001850ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x020e62000c80043fULL, 0x000000ffff487224ULL, 0x000fce00078e00ffULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x0106bc00ff067984ULL, 0x000ea40000000800ULL,
0x8000000006ff7812ULL, 0x006fe40007804845ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604477210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09004700780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404700780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000004706067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000580028457a24ULL, 0x010fc800078e02ffULL, 0x0000008045457824ULL, 0x000fe200078e00ffULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000403d047810ULL, 0x000fe20007ffe0ffULL,
0x0000000127067824ULL, 0x000fe200078e0236ULL, 0x0000000236527810ULL, 0x000fe40007ffe0ffULL,
0x0000000424057217ULL, 0x000fe20007800000ULL, 0x00000080004b7824ULL, 0x000fe200078e0206ULL,
0x0000000436547810ULL, 0x000fe20007ffe0ffULL, 0x0000000106077824ULL, 0x000fe200078e0203ULL,
0x000000f02e507812ULL, 0x000fe200078ec0ffULL, 0x0000001006517824ULL, 0x000fe200078e00ffULL,
0x000000454b487210ULL, 0x000fe20007f1e0ffULL, 0x0000000127067824ULL, 0x000fe200078e0252ULL,
0x000000024b4a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a04ULL,
0xfffffff051517812ULL, 0x000fe200078ee207ULL, 0x0000000127047824ULL, 0x000fe200078e0254ULL,
0x000000044b497810ULL, 0x000fe20007ffe0ffULL, 0x0000000106077824ULL, 0x140fe200078e0203ULL,
0x0000000527057217ULL, 0x000fe20007800000ULL, 0x0000001006537824ULL, 0x000fe200078e00ffULL,
0x0000004549497210ULL, 0x000fe20007f7e0ffULL, 0x0000000104067824ULL, 0x040fe200078e0203ULL,
0x0000c00051517811ULL, 0x000fe200078e20ffULL, 0x0000001004557824ULL, 0x000fe200078e00ffULL,
0xfffffff053537812ULL, 0x000fe200078ee207ULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005e0048447a11ULL, 0x040fe200078040ffULL, 0x0000000105077824ULL, 0x000fe200078e0a27ULL,
0xfffffff055557812ULL, 0x000fe200078ee206ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x00005f0048487a11ULL, 0x000fc400000f4404ULL, 0x000000454a4a7210ULL, 0x000fe40007f1e0ffULL,
0x000000073600720cULL, 0x000fe40003f86070ULL, 0x00005e0049067a11ULL, 0x040fe200078a40ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005e004a477a11ULL, 0x040fe400078040ffULL,
0x00005f0049497a11ULL, 0x000fe400028f4405ULL, 0x00005f004a4a7a11ULL, 0x000fc400000f4404ULL,
0x0000005044047210ULL, 0x000fe40007f7e0ffULL, 0x000000075200720cULL, 0x080fe40003f06070ULL,
0x0000000636527810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200018e0648ULL,
0x000000064b447810ULL, 0x000fe40007ffe0ffULL, 0x000000075400720cULL, 0x000fe20003f66070ULL,
0x0000000127487824ULL, 0x000fe200078e0252ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004517faeULL, 0x0003e2000e101c46ULL, 0x0000004544447210ULL, 0x000fc40007f9e0ffULL,
0x00000001484b7824ULL, 0x000fe200078e0203ULL, 0x0000005006067210ULL, 0x080fe40007fde0ffULL,
0x0000c00053537811ULL, 0x000fe400078e20ffULL, 0x0000c00055557811ULL, 0x000fe400078e20ffULL,
0x0000005047047210ULL, 0x002fe20007fbe0ffULL, 0x0000001048517824ULL, 0x000fe400078e00ffULL,
0x000000ffff477224ULL, 0x000fe200020e06ffULL, 0x00005e0044487a11ULL, 0x000fe200078840ffULL,
0x000000ffff057224ULL, 0x000fe200028e064aULL, 0x000000075200720cULL, 0x000fe20003fa6070ULL,
0x000000ffff077224ULL, 0x000fe200030e0649ULL, 0x00005f0044447a11ULL, 0x000fc400020f4447ULL,
0x0000005048487210ULL, 0x000fe20007f9e0ffULL, 0x0000000004537faeULL, 0x0003e2000c101c46ULL,
0xfffffff0514b7812ULL, 0x000fc600078ee24bULL, 0x000000ffff497224ULL, 0x000fe200020e0644ULL,
0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL, 0x0000000006557faeULL, 0x0003e8000d901c46ULL,
0x00000000484b7faeULL, 0x0003e2000e901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000000127047824ULL, 0x000fe200078e0236ULL, 0x000000f02e4a7812ULL, 0x000fc600078ec0ffULL,
0x0000000104057824ULL, 0x040fe200078e0203ULL, 0x0000000204067810ULL, 0x040fe20007ffe0ffULL,
0x0000001004447824ULL, 0x000fc800078e00ffULL, 0x0000000106077824ULL, 0x000fe200078e0203ULL,
0xfffffff044447812ULL, 0x000fe200078ee205ULL, 0x0000001006497824ULL, 0x000fe200078e00ffULL,
0x0000000404067810ULL, 0x000fe20007ffe0ffULL, 0x0000008000057824ULL, 0x000fe200078e0204ULL,
0x0000c00044447811ULL, 0x000fe400078e20ffULL, 0xfffffff049497812ULL, 0x000fe200078ee207ULL,
0x0000000106477824ULL, 0x000fe200078e0203ULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000001006527824ULL, 0x000fe200078e00ffULL, 0x0000004505047210ULL, 0x000fc60007f1e0ffULL,
0x0000000107487824ULL, 0x040fe200078e0203ULL, 0xfffffff052527812ULL, 0x000fe200078ee247ULL,
0x0000001007567824ULL, 0x000fe200078e00ffULL, 0x0000000205477810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e0004077a11ULL, 0x000fe400078040ffULL,
0xfffffff056567812ULL, 0x000fe400078ee248ULL, 0x00005f0004067a11ULL, 0x000fe400000f4406ULL,
0x0000000405047810ULL, 0x000fc40007ffe0ffULL, 0x0000000605057810ULL, 0x000fe40007ffe0ffULL,
0x0000004547477210ULL, 0x080fe40007f1e0ffULL, 0x00000045044b7210ULL, 0x080fe40007f7e0ffULL,
0x0000004505537210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x00005e0047487a11ULL, 0x000fe200078040ffULL, 0x000000ffff507224ULL, 0x000fe200018e06ffULL,
0x0000004a07047210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff547224ULL, 0x000fe200028e06ffULL,
0x00005e004b517a11ULL, 0x000fc400078840ffULL, 0x00005e0053557a11ULL, 0x000fe400078a40ffULL,
0x00005f0047477a11ULL, 0x000fe200000f4405ULL, 0x000000ffff057224ULL, 0x000fe200018e0606ULL,
0x0000004a48067210ULL, 0x080fe40007f1e0ffULL, 0x00005f004b507a11ULL, 0x000fe400020f4450ULL,
0x0000004a51487210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004447faeULL, 0x0003e2000b901c46ULL, 0x00005f0053547a11ULL, 0x000fe200028f4454ULL,
0x000000ffff077224ULL, 0x000fe200000e0647ULL, 0x0000004a554a7210ULL, 0x000fc40007f9e0ffULL,
0x0000c00052527811ULL, 0x000fe400078e20ffULL, 0x0000c00056567811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200020e0654ULL, 0x0000c00049047811ULL, 0x002fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fc800018e0650ULL, 0x0000000006047faeULL, 0x0003e8000b901c46ULL,
0x0000000048527faeULL, 0x0003e8000b901c46ULL, 0x000000004a567faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff047f8cULL, 0x000e64000c80043fULL, 0x000000ffff447224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x0106b400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007804861ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604477210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000004706067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000033ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff057819ULL, 0x000fe40000011603ULL, 0x0000541004047816ULL, 0x000fe20000000004ULL,
0x0000fa427f007947ULL, 0x000fea000b800000ULL, 0x00001f0504347589ULL, 0x0002a400000e0000ULL,
0x0000000805357810ULL, 0x000fe20007ffe0ffULL, 0x0000fa727f007947ULL, 0x000fea000b800000ULL,
0x00001f3504357589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001005477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0004ULL,
0x00008b2000487802ULL, 0x000fc40000000f00ULL, 0x000104a000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001805477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0004ULL, 0x00008b7000487802ULL, 0x000fc40000000f00ULL,
0x0001045000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a800425c7811ULL, 0x000fc400078e20ffULL,
0x000000004048783bULL, 0x000f280000004200ULL, 0x000000004154783bULL, 0x000ee80000004200ULL,
0x000000003e50783bULL, 0x000ea20000004200ULL, 0x00000018ff047819ULL, 0x01afe20000011448ULL,
0x00000100496a7824ULL, 0x040fe200078e00ffULL, 0x0000888049697816ULL, 0x000fe200000000ffULL,
0x00000100485e7824ULL, 0x040fe200078e00ffULL, 0x00000004005f7306ULL, 0x0003e20000200c00ULL,
0x00008880485d7816ULL, 0x040fe200000000ffULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc4000001144aULL, 0x00000018ff5b7819ULL, 0x000fe4000001144bULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x00000069006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff047819ULL, 0x002fe20000011449ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011454ULL, 0x00000018ff657819ULL, 0x004fe40000011450ULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000004800697306ULL, 0x0003e20000200c00ULL,
0x00000018ff667819ULL, 0x000fc40000011451ULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x00000018ff637819ULL, 0x000fe20000011452ULL,
0x00000049006d7306ULL, 0x0005e20000200c00ULL, 0x000088804a487816ULL, 0x002fe400000000ffULL,
0x00000018ff647819ULL, 0x000fe40000011453ULL, 0x00000018ff597819ULL, 0x000fc40000011455ULL,
0x00000018ff677819ULL, 0x000fe20000011456ULL, 0x00000048006e7306ULL, 0x0003e20000200c00ULL,
0x000001004a497824ULL, 0x044fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011457ULL,
0x000100004a4a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x00000004006c7306ULL, 0x0005e20000200c00ULL,
0x000088804b487816ULL, 0x002fce00000000ffULL, 0x00000049006f7306ULL, 0x0002e20000200c00ULL,
0x000000003f04783bULL, 0x004eae0000004200ULL, 0x0000004800717306ULL, 0x0009e20000200c00ULL,
0x000001004b497824ULL, 0x042fe400078e00ffULL, 0x000100004b4b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000004a00707306ULL, 0x000fe20000200c00ULL, 0x0000888054487816ULL, 0x010fe400000000ffULL,
0x000054106e6e7816ULL, 0x008fca000000006fULL, 0x0000004900727306ULL, 0x0002f00000200c00ULL,
0x0000004800747306ULL, 0x0009e20000200c00ULL, 0x0000010054497824ULL, 0x042fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000004b00737306ULL, 0x000fe20000200c00ULL,
0x0000888055487816ULL, 0x010fe400000000ffULL, 0x00005410716f7816ULL, 0x008fe40000000072ULL,
0x00000018ff627819ULL, 0x004fe40000011405ULL, 0x00000018ff617819ULL, 0x000fe20000011404ULL,
0x0000004900757306ULL, 0x0003e20000200c00ULL, 0x00000018ff477819ULL, 0x000fc40000011406ULL,
0x00000018ff607819ULL, 0x000fca0000011407ULL, 0x0000004800777306ULL, 0x0005e20000200c00ULL,
0x0000010055497824ULL, 0x042fe400078e00ffULL, 0x0001000055557824ULL, 0x000fc600078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000005400767306ULL, 0x0003e20000200c00ULL,
0x0000888056487816ULL, 0x004fe400000000ffULL, 0x00000018ff557819ULL, 0x000fca0000011455ULL,
0x0000004900787306ULL, 0x0005e20000200c00ULL, 0x0000888051547816ULL, 0x002fce00000000ffULL,
0x00000048007a7306ULL, 0x0003e20000200c00ULL, 0x0000010056497824ULL, 0x044fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000888057487816ULL, 0x002fe400000000ffULL,
0x00000018ff567819ULL, 0x000fca0000011456ULL, 0x00000049007b7306ULL, 0x0002b00000200c00ULL,
0x00000048007d7306ULL, 0x0007e20000200c00ULL, 0x0000010057497824ULL, 0x042fe400078e00ffULL,
0x0001000057577824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000888050487816ULL, 0x008fe400000000ffULL,
0x00000018ff577819ULL, 0x000fca0000011457ULL, 0x00000049007e7306ULL, 0x0003f00000200c00ULL,
0x0000004800807306ULL, 0x000fe20000200c00ULL, 0x0000010050497824ULL, 0x042fe400078e00ffULL,
0x0001000050507824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000006a006a7306ULL, 0x000ff00000200c00ULL,
0x0000004900817306ULL, 0x0003f00000200c00ULL, 0x0000005000827306ULL, 0x0007e20000200c00ULL,
0x000000005c48783bULL, 0x00246e0000000200ULL, 0x0000005a005a7306ULL, 0x000f220000200c00ULL,
0x000000ffff507224ULL, 0x008fe200078e0054ULL, 0x000054107a5c7816ULL, 0x004fe2000000007bULL,
0x0000010051547824ULL, 0x000fc400078e00ffULL, 0x0001000051517824ULL, 0x000fc600078e00ffULL,
0x0000005000837306ULL, 0x0005e20000200c00ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff517819ULL, 0x000fca0000011451ULL, 0x0000005100857306ULL, 0x0007e20000200c00ULL,
0x0000888052507816ULL, 0x004fe400000000ffULL, 0x00005410705a7816ULL, 0x010fca000000005aULL,
0x0000005000867306ULL, 0x0005e20000200c00ULL, 0x0000010052517824ULL, 0x048fe400078e00ffULL,
0x0001000052527824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x000000344848a232ULL, 0x082fe20000000000ULL,
0x0000005100877306ULL, 0x0003e20000200c00ULL, 0x0000888053507816ULL, 0x004fe200000000ffULL,
0x000000344a4aa232ULL, 0x000fe40000000000ULL, 0x000000354949a232ULL, 0x080fe40000000000ULL,
0x000000354b4ba232ULL, 0x000fc40000000000ULL, 0x0000005000897306ULL, 0x0005e20000200c00ULL,
0x0000010053517824ULL, 0x002fc800078e00ffULL, 0x0000006e4818723cULL, 0x000fe20000001818ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005400847306ULL, 0x0003e20000200c00ULL,
0x000054105d507816ULL, 0x004fe4000000005eULL, 0x000054107d5d7816ULL, 0x000fca000000007eULL,
0x00000051008a7306ULL, 0x0005e20000200c00ULL, 0x0001000053547824ULL, 0x002fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005200887306ULL, 0x0003e20000200c00ULL,
0x000054106b517816ULL, 0x004fce000000006aULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x000000504850723cULL, 0x042b6e0000001820ULL, 0x0000541069207816ULL, 0x020fe2000000005fULL,
0x00000054006a7306ULL, 0x0003e20000200c00ULL, 0x000054106d217816ULL, 0x000fe2000000006cULL,
0x0000005c485c723cULL, 0x000be20000001808ULL, 0x0000888004227816ULL, 0x000fc400000000ffULL,
0x00005410735b7816ULL, 0x004fc6000000005bULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x0000541080087816ULL, 0x020fe20000000081ULL, 0x00000020481c723cULL, 0x000b62000000181cULL,
0x0000541083097816ULL, 0x000fca0000000084ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000000ffff207224ULL, 0x020fe200078e0022ULL, 0x0000005a4814723cULL, 0x000b620000001814ULL,
0x0000010004217824ULL, 0x040fe400078e00ffULL, 0x0001000004047824ULL, 0x000fc600078e00ffULL,
0x0000002000697306ULL, 0x0007e20000200c00ULL, 0x00000018ff547819ULL, 0x002fe20000011421ULL,
0x00000100055a7824ULL, 0x020fe200078e00ffULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x0000541076587816ULL, 0x004fe40000000058ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000a80043207811ULL, 0x008fcc00078e20ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x0000006800687306ULL, 0x000ff00000200c00ULL,
0x0000005500797306ULL, 0x0004f00000200c00ULL, 0x00000056007c7306ULL, 0x000f220000200c00ULL,
0x0000888005557816ULL, 0x044fe200000000ffULL, 0x0001000005057824ULL, 0x000fca00078e00ffULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x00000057007f7306ULL, 0x000ea20000200c00ULL,
0x0000541079597816ULL, 0x008fce0000000059ULL, 0x00000054006b7306ULL, 0x0007e20000200c00ULL,
0x000054107c7c7816ULL, 0x010fe20000000067ULL, 0x000000342020a232ULL, 0x002fcc0000000000ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x000000ffff547224ULL, 0x008fe200078e0055ULL,
0x0000541077557816ULL, 0x000fe20000000078ULL, 0x000000342222a232ULL, 0x000fe20000000000ULL,
0x000054107f7d7816ULL, 0x004fe20000000068ULL, 0x000000352121a232ULL, 0x080fe40000000000ULL,
0x000000352323a232ULL, 0x000fe20000000000ULL, 0x0000006600667306ULL, 0x000ea60000200c00ULL,
0x0000007c484c723cULL, 0x000fea000000184cULL, 0x00000054006d7306ULL, 0x0007e60000200c00ULL,
0x000000082008723cULL, 0x000fea0000001850ULL, 0x00000005006f7306ULL, 0x0009e20000200c00ULL,
0x0000541074547816ULL, 0x008fce0000000075ULL, 0x00000004006c7306ULL, 0x0007e20000200c00ULL,
0x0000010006057824ULL, 0x050fe200078e00ffULL, 0x000000544854723cULL, 0x000b680000001810ULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000005a006e7306ULL, 0x0009e20000200c00ULL,
0x0000888006047816ULL, 0x048fe200000000ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x0000541086107816ULL, 0x020fc40000000087ULL, 0x0000541089117816ULL, 0x000fe4000000008aULL,
0x00000018ff067819ULL, 0x000fe20000011406ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000000584858723cULL, 0x010b6e000000180cULL, 0x0000000400487306ULL, 0x0207e20000200c00ULL,
0x00005410820c7816ULL, 0x002fe20000000065ULL, 0x000000102010723cULL, 0x000b620000001818ULL,
0x00005410850d7816ULL, 0x004fca0000000066ULL, 0x0000000500497306ULL, 0x0002a20000200c00ULL,
0x0000888007047816ULL, 0x048fe200000000ffULL, 0x0000000c200c723cULL, 0x000b6c000000181cULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000010007057824ULL, 0x042fe400078e00ffULL,
0x0001000007077824ULL, 0x000fc600078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x00000018ff187819ULL, 0x020fe20000011407ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00005410481c7816ULL, 0x004fce0000000049ULL, 0x0000006200627306ULL, 0x000e700000200c00ULL,
0x00000004004b7306ULL, 0x0005f00000200c00ULL, 0x00000005001d7306ULL, 0x0007220000200c00ULL,
0x0000541088047816ULL, 0x004fc40000000063ULL, 0x000054106f197816ULL, 0x002fca0000000062ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000054106a057816ULL, 0x008fce0000000064ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054104b1d7816ULL, 0x010fce000000001dULL,
0x00000006004a7306ULL, 0x0002a20000200c00ULL, 0x0000001c201c723cULL, 0x040f6e000000185cULL,
0x0000001800507306ULL, 0x0007220000200c00ULL, 0x000000042004723cULL, 0x002b6e0000001814ULL,
0x0000541069147816ULL, 0x020fc4000000006bULL, 0x000054106d157816ULL, 0x000fe4000000006eULL,
0x000054106c187816ULL, 0x008fe40000000061ULL, 0x000054104a4a7816ULL, 0x004fe40000000047ULL,
0x00005410504b7816ULL, 0x010fe20000000060ULL, 0x000000142014723cULL, 0x040b700000001854ULL,
0x000000182018723cULL, 0x040b700000001858ULL, 0x0000004a2020723cULL, 0x000b62000000184cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff487f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000403d477810ULL, 0x000fe20007ffe0ffULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4c7224ULL, 0x022fe200078e0049ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x000000244700720cULL, 0x000fda0003f06070ULL, 0x000084b000000947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fc40000015200ULL, 0x0106bc00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe4000780484cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a48477210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4a7824ULL, 0x000fe200000e0e49ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001144aULL, 0x000000472c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e064aULL, 0x000000022c2c7819ULL, 0x000fc80000001247ULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014d4d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe4000780484cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000603d2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127487824ULL, 0x000fe200078e0236ULL,
0x00000002364a7810ULL, 0x000fe40007ffe0ffULL, 0x0000002c24477217ULL, 0x000fe20007800000ULL,
0x0000000148497824ULL, 0x000fe200078e0203ULL, 0x00000004364c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001048527824ULL, 0x000fe200078e00ffULL, 0x0000000636557810ULL, 0x000fe20007ffe0ffULL,
0x0000000147477824ULL, 0x000fe200078e0a2cULL, 0x00000020002c7811ULL, 0x000fe200078e38ffULL,
0x00000001274b7824ULL, 0x040fe200078e024cULL, 0xfffffff052527812ULL, 0x000fe200078ee249ULL,
0x0000000127497824ULL, 0x040fe200078e024aULL, 0x0000004727477217ULL, 0x040fe20007800000ULL,
0x00000001274e7824ULL, 0x000fe200078e0255ULL, 0x000000f02e517812ULL, 0x000fe200078ec0ffULL,
0x0000000148507824ULL, 0x100fe200078e022cULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x00000001494f7824ULL, 0x000fc400078e022cULL, 0x0000000149487824ULL, 0x140fe200078e0203ULL,
0x0000004550507210ULL, 0x080fe20007f1e0ffULL, 0x0000001049537824ULL, 0x000fe200078e00ffULL,
0x000000454f4f7210ULL, 0x080fe20007f5e0ffULL, 0x000000014b4d7824ULL, 0x100fe400078e022cULL,
0x000000014e567824ULL, 0x040fe200078e022cULL, 0xfffffff053537812ULL, 0x000fe200078ee248ULL,
0x000000014b497824ULL, 0x100fe200078e0203ULL, 0x000000454d4d7210ULL, 0x000fe20007f7e0ffULL,
0x000000104b547824ULL, 0x000fe200078e00ffULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000014e2c7824ULL, 0x040fe200078e0203ULL, 0x00005e004d4b7a11ULL, 0x000fe200078a40ffULL,
0x000000104e577824ULL, 0x000fe200078e00ffULL, 0xfffffff054547812ULL, 0x000fe200078ee249ULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005e0050487a11ULL, 0x000fe200078040ffULL,
0x0000000147477824ULL, 0x000fe200078e0a27ULL, 0xfffffff057577812ULL, 0x000fe200078ee22cULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e004f4e7a11ULL, 0x000fc400078440ffULL,
0x00005f0050507a11ULL, 0x000fe200000f4449ULL, 0x000000ffff497224ULL, 0x000fe200018e06ffULL,
0x00005f004f4f7a11ULL, 0x000fe400010f442cULL, 0x00000045562c7210ULL, 0x000fe40007fde0ffULL,
0x000000473600720cULL, 0x080fe40003f46070ULL, 0x000000474a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x0000005148487210ULL, 0x000fc40007f9e0ffULL,
0x000000474c00720cULL, 0x080fe40003f66070ULL, 0x00005f004d4d7a11ULL, 0x000fe200028f4449ULL,
0x000000ffff497224ULL, 0x000fe200020e0650ULL, 0x00005e002c4c7a11ULL, 0x040fe400078a40ffULL,
0x000000475500720cULL, 0x000fe40003f86070ULL, 0x00005f002c2c7a11ULL, 0x000fe200028f444aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048527faeULL, 0x0003e2000d101c46ULL,
0x000000514e4a7210ULL, 0x000fc40007fbe0ffULL, 0x0000e00054547811ULL, 0x000fe400078e20ffULL,
0x0000e00057577811ULL, 0x000fe400078e20ffULL, 0x000000514b487210ULL, 0x082fe20007f5e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200028e064fULL, 0x000000514c4c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff497224ULL, 0x000fe200010e064dULL, 0x000000004a537faeULL, 0x0003e2000c101c46ULL,
0x000000ffff4d7224ULL, 0x000fc600028e062cULL, 0x0000000048547faeULL, 0x0003e8000d901c46ULL,
0x000000004c577faeULL, 0x0003e2000e101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x00000001272c7824ULL, 0x000fe200078e0236ULL, 0x0000002000487811ULL, 0x000fe400078e38ffULL,
0x000000f02e517812ULL, 0x000fe200078ec0ffULL, 0x000000012c497824ULL, 0x040fe200078e0203ULL,
0x000000022c4a7810ULL, 0x040fe20007ffe0ffULL, 0x000000102c527824ULL, 0x040fe200078e00ffULL,
0x000000042c4c7810ULL, 0x040fe20007ffe0ffULL, 0x000000012c477824ULL, 0x040fe200078e0248ULL,
0x000000062c4e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001482c7824ULL, 0x000fe200078e024aULL,
0xfffffff052527812ULL, 0x000fe200078ee249ULL, 0x000000014a4b7824ULL, 0x040fe200078e0203ULL,
0x0000004547497210ULL, 0x000fe20007f1e0ffULL, 0x000000104a537824ULL, 0x000fe200078e00ffULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x0000000148477824ULL, 0x000fc400078e024cULL,
0x000000014c4d7824ULL, 0x040fe200078e0203ULL, 0xfffffff053537812ULL, 0x000fe200078ee24bULL,
0x000000104c547824ULL, 0x000fe200078e00ffULL, 0x0000004745477210ULL, 0x000fe20007f5e0ffULL,
0x0000000148487824ULL, 0x000fe200078e024eULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000014e4c7824ULL, 0x000fe200078e0203ULL, 0xfffffff054547812ULL, 0x000fe200078ee24dULL,
0x000000104e557824ULL, 0x000fe200078e00ffULL, 0x0000004845487210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200000e06ffULL, 0x00005e00494e7a11ULL, 0x000fc400078040ffULL,
0xfffffff055557812ULL, 0x000fe400078ee24cULL, 0x00005f0049507a11ULL, 0x000fe200000f444aULL,
0x000000ffff497224ULL, 0x000fe200010e06ffULL, 0x0000002c454d7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x00005e00484c7a11ULL, 0x000fe400078640ffULL,
0x00005e00474a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff4f7224ULL, 0x000fe200000e06ffULL,
0x00005e004d4b7a11ULL, 0x000fc400078040ffULL, 0x000000514e4e7210ULL, 0x080fe40007f9e0ffULL,
0x00005f004d4d7a11ULL, 0x000fe400000f444fULL, 0x00005f00482c7a11ULL, 0x000fe200018f442cULL,
0x000000ffff4f7224ULL, 0x000fe200020e0650ULL, 0x00005f0047477a11ULL, 0x000fe400010f4449ULL,
0x000000514b487210ULL, 0x080fe40007f1e0ffULL, 0x000000514a4a7210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e527faeULL, 0x0003e2000b901c46ULL,
0x000000514c4c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff497224ULL, 0x000fe200000e064dULL,
0x0000e00054547811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe200010e0647ULL,
0x0000e00055557811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200018e062cULL,
0x0000000048537faeULL, 0x0003e8000b901c46ULL, 0x000000004a547faeULL, 0x0003e8000b901c46ULL,
0x000000004c557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff607f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01064800274c7f8cULL, 0x0022e4000c80043fULL,
0x0000000000487805ULL, 0x000fc40000015200ULL, 0x01064c00272c7984ULL, 0x000f240000000800ULL,
0x800000002cff7812ULL, 0x018fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a48477210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4a7824ULL, 0x000fe200000e0e49ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001144aULL, 0x000000472c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e064aULL, 0x000000022c2c7819ULL, 0x000fc80000001247ULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01064c00272c7984ULL, 0x000ee40000000800ULL, 0x800000002cff7812ULL, 0x008fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010100002f2c7984ULL, 0x000ee80000000800ULL,
0x010300002f4a7984ULL, 0x0002a20000000800ULL, 0x000000462c00720bULL, 0x008fe20003f1d000ULL,
0x0000dd227f007947ULL, 0x000fd8000b800000ULL, 0x00000000004b7806ULL, 0x002fc800000e0100ULL,
0x0000ffff4bff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff477424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000020200780cULL, 0x000fe40003f05270ULL, 0x000000462c00720bULL, 0x000fe20003f54000ULL,
0x0000dcf27f007947ULL, 0x000fd8000b800000ULL, 0x00000000004c7806ULL, 0x000fc400010e0100ULL,
0x0000002c46478209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x010500472f008388ULL, 0x0003e40000000800ULL, 0x000099104c477816ULL, 0x002fc800000000ffULL,
0x000000ff4700720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000002c46477209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff4cff7812ULL, 0x000fc6000780c0ffULL, 0x8000004746477221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b47477820ULL, 0x000fc80000410000ULL, 0x00000047004d7308ULL, 0x000e640000000800ULL,
0x0000004d29297220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff477819ULL, 0x000fe20000011603ULL, 0x0000dc327f007947ULL, 0x000fea000b800000ULL,
0x00001f474d477589ULL, 0x0002e400000e0000ULL, 0x0000004708087220ULL, 0x08cfe20000410000ULL,
0x0000004709097220ULL, 0x080fe20000410000ULL, 0x000000470c0c7220ULL, 0x080fe20000410000ULL,
0x000000470d0d7220ULL, 0x080fe20000410000ULL, 0x0000004710107220ULL, 0x080fe20000410000ULL,
0x0000004711117220ULL, 0x080fe20000410000ULL, 0x0000004704047220ULL, 0x080fe20000410000ULL,
0x0000004705057220ULL, 0x080fe20000410000ULL, 0x0000004714147220ULL, 0x080fe20000410000ULL,
0x0000004715157220ULL, 0x080fe20000410000ULL, 0x0000004718187220ULL, 0x080fe20000410000ULL,
0x0000004719197220ULL, 0x080fe20000410000ULL, 0x000000471c1c7220ULL, 0x080fe20000410000ULL,
0x000000471d1d7220ULL, 0x080fe20000410000ULL, 0x0000004720207220ULL, 0x080fe20000410000ULL,
0x0000004721217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff004cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803477811ULL, 0x000fe200078ff0ffULL, 0x0000db127f007947ULL, 0x000fea000b800000ULL,
0x00001f474d477589ULL, 0x00066400000e0000ULL, 0x000000470a0a7220ULL, 0x086fe20000410000ULL,
0x000000470b0b7220ULL, 0x080fe20000410000ULL, 0x000000470e0e7220ULL, 0x080fe20000410000ULL,
0x000000470f0f7220ULL, 0x080fe20000410000ULL, 0x0000004712127220ULL, 0x080fe20000410000ULL,
0x0000004713137220ULL, 0x080fe20000410000ULL, 0x0000004706067220ULL, 0x080fe20000410000ULL,
0x0000004707077220ULL, 0x080fe20000410000ULL, 0x0000004716167220ULL, 0x080fe20000410000ULL,
0x0000004717177220ULL, 0x080fe20000410000ULL, 0x000000471a1a7220ULL, 0x080fe20000410000ULL,
0x000000471b1b7220ULL, 0x080fe20000410000ULL, 0x000000471e1e7220ULL, 0x080fe20000410000ULL,
0x000000471f1f7220ULL, 0x080fe20000410000ULL, 0x0000004722227220ULL, 0x080fe20000410000ULL,
0x0000004723237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff4cff7812ULL, 0x000fe2000780084bULL, 0x00000001ff477424ULL, 0x000fe200078e00ffULL,
0x0000002c46467209ULL, 0x000fd60007810000ULL, 0x800000462c2c0221ULL, 0x000fe20000010000ULL,
0x00007610ff470816ULL, 0x000fc60000000047ULL, 0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL,
0x0000002c00330308ULL, 0x000f240000000800ULL, 0x000000334a4a0220ULL, 0x014fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000294a297221ULL, 0x004fc20000010000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff2c7984ULL, 0x000ea40000000800ULL,
0x800000002cff7812ULL, 0x004fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a484a7210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4b7824ULL, 0x000fe200000e0e49ULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001144bULL, 0x0000004a2c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff4a7224ULL, 0x000fca00000e064bULL, 0x000000022c2c7819ULL, 0x000fc8000000124aULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff2c7984ULL, 0x000ea40000000800ULL, 0x800000002cff7812ULL, 0x004fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910472c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2c00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000033ff2c723eULL, 0x000fe400000000ffULL,
0x00000002ff447819ULL, 0x000fe40000011603ULL, 0x000054102c2c7816ULL, 0x000fe2000000002cULL,
0x0000d6e27f007947ULL, 0x000fea000b800000ULL, 0x00001f442c347589ULL, 0x00046400000e0000ULL,
0x0000000844357810ULL, 0x000fe20007ffe0ffULL, 0x0000d7127f007947ULL, 0x000fea000b800000ULL,
0x00001f352c357589ULL, 0x0004e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001044477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e002cULL,
0x0000b06000487802ULL, 0x000fc40000000f00ULL, 0x0000df6000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001844477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e002cULL, 0x0000b0b000487802ULL, 0x000fc40000000f00ULL,
0x0000df1000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003750783bULL, 0x000f280000004200ULL,
0x000000003854783bULL, 0x000ee80000004200ULL, 0x00000000394c783bULL, 0x00ae680000004200ULL,
0x000000003a48783bULL, 0x000ee20000004200ULL, 0x00000018ff2c7819ULL, 0x014fe20000011450ULL,
0x00000100505d7824ULL, 0x040fe200078e00ffULL, 0x00008880505c7816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x0000888051697816ULL, 0x000fe200000000ffULL,
0x0000002c005e7306ULL, 0x0005e20000200c00ULL, 0x00000018ff587819ULL, 0x000fc40000011454ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff657819ULL, 0x002fe4000001144cULL,
0x00000018ff667819ULL, 0x000fe2000001144dULL, 0x00000050005f7306ULL, 0x0003220000200c00ULL,
0x00000018ff2c7819ULL, 0x004fe40000011451ULL, 0x00000018ff5a7819ULL, 0x000fe40000011452ULL,
0x00000018ff5b7819ULL, 0x000fc40000011453ULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000000ffff507224ULL, 0x002fe200078e0069ULL,
0x00000018ff637819ULL, 0x000fe2000001144eULL, 0x0000010051697824ULL, 0x040fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe2000001144fULL, 0x0001000051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011455ULL, 0x00000050006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff697819ULL, 0x000fc40000011469ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff677819ULL, 0x000fe40000011456ULL, 0x00000018ff687819ULL, 0x000fe20000011457ULL,
0x00000051006c7306ULL, 0x0005e20000200c00ULL, 0x0000888052507816ULL, 0x002fe400000000ffULL,
0x000054105f5e7816ULL, 0x010fe4000000005eULL, 0x00000018ff477819ULL, 0x008fc40000011448ULL,
0x00000018ff627819ULL, 0x000fe20000011449ULL, 0x00000050006d7306ULL, 0x0003e20000200c00ULL,
0x0000010052517824ULL, 0x044fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe2000001144bULL,
0x0001000052527824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000888053507816ULL, 0x002fce00000000ffULL, 0x00000051006e7306ULL, 0x0002f00000200c00ULL,
0x00000050006f7306ULL, 0x0009e20000200c00ULL, 0x0000010053517824ULL, 0x042fe200078e00ffULL,
0x000054105c5c7816ULL, 0x004fe2000000005dULL, 0x0001000053537824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000005200707306ULL, 0x000fe20000200c00ULL, 0x0000888054507816ULL, 0x010fe400000000ffULL,
0x000054106d6e7816ULL, 0x008fca000000006eULL, 0x0000005100717306ULL, 0x0002b00000200c00ULL,
0x0000005000737306ULL, 0x0007e20000200c00ULL, 0x0000010054517824ULL, 0x042fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000005300727306ULL, 0x000fe20000200c00ULL,
0x0000888055507816ULL, 0x008fe400000000ffULL, 0x000054106f6f7816ULL, 0x004fca0000000071ULL,
0x0000005100747306ULL, 0x0003f00000200c00ULL, 0x0000005000767306ULL, 0x0005e20000200c00ULL,
0x0000010055517824ULL, 0x042fe400078e00ffULL, 0x0001000055557824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005400757306ULL, 0x0003e20000200c00ULL,
0x0000888056507816ULL, 0x004fe400000000ffULL, 0x00000018ff557819ULL, 0x000fca0000011455ULL,
0x0000005100777306ULL, 0x0005e20000200c00ULL, 0x000088804d547816ULL, 0x002fce00000000ffULL,
0x0000005000797306ULL, 0x0003e20000200c00ULL, 0x0000010056517824ULL, 0x044fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x0000888057507816ULL, 0x002fe400000000ffULL,
0x00000018ff567819ULL, 0x000fca0000011456ULL, 0x00000051007a7306ULL, 0x0003f00000200c00ULL,
0x00000050007c7306ULL, 0x0007e20000200c00ULL, 0x0000010057517824ULL, 0x042fe200078e00ffULL,
0x000054106a5d7816ULL, 0x004fe20000000069ULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000002c006b7306ULL, 0x0002a20000200c00ULL,
0x000088804c507816ULL, 0x008fe400000000ffULL, 0x00000018ff577819ULL, 0x000fca0000011457ULL,
0x00000051007d7306ULL, 0x0007220000200c00ULL, 0x00000018ff2c7819ULL, 0x002fce000001144aULL,
0x00000050007f7306ULL, 0x0003e20000200c00ULL, 0x000001004c517824ULL, 0x008fe200078e00ffULL,
0x000054106c5f7816ULL, 0x004fe2000000006bULL, 0x000100004c4c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000005500787306ULL, 0x0005e20000200c00ULL, 0x0000b0003b507811ULL, 0x002fce00078e20ffULL,
0x0000004c00817306ULL, 0x0003e20000200c00ULL, 0x0000888049557816ULL, 0x004fce00000000ffULL,
0x0000005100807306ULL, 0x0004e20000200c00ULL, 0x000000ffff4c7224ULL, 0x002fe400078e0054ULL,
0x000001004d547824ULL, 0x040fe400078e00ffULL, 0x000100004d4d7824ULL, 0x000fc600078e00ffULL,
0x0000004c00827306ULL, 0x0003e20000200c00ULL, 0x000000005050783bULL, 0x004ea20000000200ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff547819ULL, 0x000fc80000011454ULL,
0x0000004d00847306ULL, 0x0007e20000200c00ULL, 0x000088804e4c7816ULL, 0x002fce00000000ffULL,
0x0000004c00857306ULL, 0x0003e20000200c00ULL, 0x000001004e4d7824ULL, 0x048fe400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000005400837306ULL, 0x000ee20000200c00ULL,
0x000088804f4c7816ULL, 0x002fce00000000ffULL, 0x0000004d00867306ULL, 0x0003f00000200c00ULL,
0x0000004c00887306ULL, 0x0007e20000200c00ULL, 0x000001004f4d7824ULL, 0x042fe200078e00ffULL,
0x000000345050a232ULL, 0x084fe20000000000ULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x000000345252a232ULL, 0x000fc40000000000ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x000000355151a232ULL, 0x080fe20000000000ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000004e00877306ULL, 0x000fe20000200c00ULL, 0x00008880484c7816ULL, 0x008fe200000000ffULL,
0x000000355353a232ULL, 0x000fcc0000000000ULL, 0x0000004d00897306ULL, 0x0003e20000200c00ULL,
0x0000005c5008723cULL, 0x040b6e0000001808ULL, 0x0000004c006a7306ULL, 0x0005e20000200c00ULL,
0x00000100484d7824ULL, 0x002fe200078e00ffULL, 0x00005410795c7816ULL, 0x020fe2000000007aULL,
0x0000005e500c723cULL, 0x000f62000000180cULL, 0x000054107c5d7816ULL, 0x010fe2000000007dULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc4000001144dULL,
0x0000004f00697306ULL, 0x0003e20000200c00ULL, 0x0000b0003c4c7811ULL, 0x004fe400078e20ffULL,
0x0000005c505c723cULL, 0x000be2000000181cULL, 0x00000018ff487819ULL, 0x000fc80000011448ULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x000000004c4c783bULL, 0x002e620000000200ULL,
0x000054107f1c7816ULL, 0x020fe20000000080ULL, 0x0000006e5010723cULL, 0x000fe20000001810ULL,
0x00005410821d7816ULL, 0x000fc80000000083ULL, 0x0000005b005b7306ULL, 0x000ef00000200c00ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x00005410705a7816ULL, 0x004fce000000005aULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00005410725b7816ULL, 0x008fce000000005bULL,
0x00000056007b7306ULL, 0x000fe20000200c00ULL, 0x0000005a5004723cULL, 0x000bee0000001804ULL,
0x00000057007e7306ULL, 0x000fe20000200c00ULL, 0x000000344c4ca232ULL, 0x082fe20000000000ULL,
0x00000100495a7824ULL, 0x060fe200078e00ffULL, 0x000000344e4ea232ULL, 0x000fe20000000000ULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x000000354d4da232ULL, 0x000fc40000000000ULL,
0x000000354f4fa232ULL, 0x000fe20000000000ULL, 0x00000054006b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x00000018ff497819ULL, 0x000fc60000011449ULL,
0x0000001c4c1c723cULL, 0x000be40000001808ULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x000000ffff547224ULL, 0x002fe200078e0055ULL, 0x0000541076557816ULL, 0x000fc60000000077ULL,
0x000001004b097824ULL, 0x020fc600078e00ffULL, 0x00000054006c7306ULL, 0x0003e40000200c00ULL,
0x00000018ff097819ULL, 0x000fcc0000011409ULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x0000541073547816ULL, 0x002fe40000000074ULL, 0x0000541075587816ULL, 0x004fca0000000058ULL,
0x000000545054723cULL, 0x000b620000001814ULL, 0x0000006500657306ULL, 0x000e6c0000200c00ULL,
0x000054107b147816ULL, 0x020fe40000000067ULL, 0x000054107e157816ULL, 0x000fe20000000068ULL,
0x0000006600667306ULL, 0x000ea20000200c00ULL, 0x000088804a167816ULL, 0x000fc400000000ffULL,
0x0000541078597816ULL, 0x008fc60000000059ULL, 0x000000145020723cULL, 0x000be40000001820ULL,
0x0000006300637306ULL, 0x000fea0000200c00ULL, 0x000001004a147824ULL, 0x060fe200078e00ffULL,
0x000088804b157816ULL, 0x040fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000000ffff087224ULL, 0x000fe200078e0015ULL,
0x00000018ff4a7819ULL, 0x000fc4000001144aULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000005a006d7306ULL, 0x0007220000200c00ULL, 0x0000541088157816ULL, 0x000fce0000000089ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000000585058723cULL, 0x008b6e0000001818ULL,
0x0000001400517306ULL, 0x0207e20000200c00ULL, 0x0000541081187816ULL, 0x002fe40000000065ULL,
0x0000541084197816ULL, 0x004fca0000000066ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000541085147816ULL, 0x008fe20000000086ULL, 0x000000184c18723cULL, 0x000b6c000000180cULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x000054106a0c7816ULL, 0x020fe4000000006bULL,
0x000054106c0d7816ULL, 0x010fca000000006dULL, 0x0000004900497306ULL, 0x000ea40000200c00ULL,
0x0000000c4c0c723cULL, 0x040f6c0000001854ULL, 0x0000001600507306ULL, 0x0007300000200c00ULL,
0x0000000800527306ULL, 0x0003e20000200c00ULL, 0x000000144c14723cULL, 0x008b6e0000001810ULL,
0x0000000900537306ULL, 0x0004e20000200c00ULL, 0x0000541087107816ULL, 0x020fc40000000063ULL,
0x0000541069117816ULL, 0x000fe40000000064ULL, 0x0000541048087816ULL, 0x002fc60000000047ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x0000541049097816ULL, 0x004fe20000000062ULL,
0x000000104c10723cULL, 0x040b6c0000001804ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541050047816ULL, 0x030fe20000000051ULL, 0x000000084c08723cULL, 0x000b620000001858ULL,
0x0000541052057816ULL, 0x008fca0000000053ULL, 0x0000004a004a7306ULL, 0x000e640000200c00ULL,
0x000000044c04723cULL, 0x000b6c000000185cULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x000054104a4a7816ULL, 0x002fe4000000002cULL, 0x000054104b4b7816ULL, 0x004fce0000000044ULL,
0x0000004a4c4c723cULL, 0x000b620000001820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff487f8cULL, 0x000e62000c80043fULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x0000000000207805ULL, 0x020fc40000015200ULL, 0x0106bc00ff227984ULL, 0x000ea40000000800ULL,
0x8000000022ff7812ULL, 0x006fe40007804849ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x00000022202c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011423ULL,
0x0000002c22227211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x0000000222227819ULL, 0x000fc80000001223ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x0000000127227824ULL, 0x000fe200078e0236ULL,
0x000000803d217810ULL, 0x000fe40007ffe0ffULL, 0x00000002362c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000122207824ULL, 0x100fe200078e0203ULL, 0x00000040004a7811ULL, 0x000fe200078e38ffULL,
0x0000001022507824ULL, 0x000fe200078e00ffULL, 0x0000000436527810ULL, 0x000fe20007ffe0ffULL,
0x0000000127237824ULL, 0x000fe200078e022cULL, 0x000000f02e4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000122487824ULL, 0x000fe200078e024aULL, 0xfffffff050507812ULL, 0x000fe200078ee220ULL,
0x0000000123447824ULL, 0x040fe200078e0203ULL, 0x0000002124207217ULL, 0x000fe20007800000ULL,
0x0000001023517824ULL, 0x040fe200078e00ffULL, 0x0000004548487210ULL, 0x080fe20007f1e0ffULL,
0x0000000123497824ULL, 0x000fe200078e024aULL, 0x0000000636547810ULL, 0x000fe20007ffe0ffULL,
0x0000000120207824ULL, 0x000fe200078e0a21ULL, 0xfffffff051517812ULL, 0x000fe200078ee244ULL,
0x0000000127477824ULL, 0x000fe200078e0252ULL, 0x0000004549497210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff227224ULL, 0x000fe200000e06ffULL, 0x0000002027207217ULL, 0x000fe20007800000ULL,
0x0000000147447824ULL, 0x040fe200078e0203ULL, 0x00005e0048217a11ULL, 0x000fe200078040ffULL,
0x0000001047537824ULL, 0x000fe200078e00ffULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x0000000120237824ULL, 0x000fe200078e0a27ULL, 0x00005f0048487a11ULL, 0x000fe200000f4422ULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0xfffffff053537812ULL, 0x000fe200078ee244ULL,
0x0000000147477824ULL, 0x000fe200078e024aULL, 0x00005e0049447a11ULL, 0x000fe200078640ffULL,
0x0000000127557824ULL, 0x000fe200078e0254ULL, 0x000000233600720cULL, 0x000fc40003f86070ULL,
0x00005f0049497a11ULL, 0x000fe200018f4420ULL, 0x00000001554a7824ULL, 0x000fe200078e024aULL,
0x0000004547477210ULL, 0x000fe40007fbe0ffULL, 0x0000004b21207210ULL, 0x000fe40007f7e0ffULL,
0x000000232c00720cULL, 0x080fe20003f06070ULL, 0x000000ffff2c7224ULL, 0x000fe200028e06ffULL,
0x00005e0047227a11ULL, 0x000fe200078a40ffULL, 0x000000ffff217224ULL, 0x000fe200018e0648ULL,
0x000000235200720cULL, 0x000fc40003f66070ULL, 0x00005f0047477a11ULL, 0x000fe400028f442cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020507faeULL, 0x0003e2000e101c46ULL,
0x000000454a2c7210ULL, 0x000fe20007f9e0ffULL, 0x00000001554a7824ULL, 0x040fe200078e0203ULL,
0x0000004b22227210ULL, 0x000fe20007fde0ffULL, 0x0000001055557824ULL, 0x000fe200078e00ffULL,
0x0000c00051517811ULL, 0x000fe400078e20ffULL, 0x0000c00053537811ULL, 0x000fe400078e20ffULL,
0xfffffff0554a7812ULL, 0x000fc400078ee24aULL, 0x0000004b44207210ULL, 0x002fe20007fbe0ffULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005e002c487a11ULL, 0x000fe400078840ffULL,
0x0000c0004a4a7811ULL, 0x000fe200078e20ffULL, 0x000000ffff217224ULL, 0x000fe200028e0649ULL,
0x000000235400720cULL, 0x000fe20003fa6070ULL, 0x000000ffff237224ULL, 0x000fe200030e0647ULL,
0x00005f002c2c7a11ULL, 0x000fe400020f4444ULL, 0x0000004b48487210ULL, 0x000fe20007f9e0ffULL,
0x0000000020517faeULL, 0x0003e8000c101c46ULL, 0x000000ffff497224ULL, 0x000fe200020e062cULL,
0x0000000022537faeULL, 0x0003e8000d901c46ULL, 0x00000000484a7faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000004000217811ULL, 0x000fe200078e38ffULL,
0x0000000127207824ULL, 0x000fe200078e0236ULL, 0x000000f02e507812ULL, 0x000fc600078ec0ffULL,
0x0000000120237824ULL, 0x040fe200078e0203ULL, 0x00000002202c7810ULL, 0x040fe20007ffe0ffULL,
0x0000001020517824ULL, 0x040fe200078e00ffULL, 0x0000000420447810ULL, 0x040fe20007ffe0ffULL,
0x0000000120227824ULL, 0x140fe200078e0221ULL, 0x0000000620207810ULL, 0x000fe20007ffe0ffULL,
0x000000012c477824ULL, 0x040fe200078e0221ULL, 0xfffffff051517812ULL, 0x000fe200078ee223ULL,
0x000000012c237824ULL, 0x000fe200078e0203ULL, 0x0000004522227210ULL, 0x000fe20007f1e0ffULL,
0x000000102c527824ULL, 0x000fe200078e00ffULL, 0x0000c00051517811ULL, 0x000fe200078e20ffULL,
0x00000001442c7824ULL, 0x000fc400078e0221ULL, 0x0000000120487824ULL, 0x000fe200078e0221ULL,
0xfffffff052527812ULL, 0x000fe200078ee223ULL, 0x0000000144217824ULL, 0x100fe200078e0203ULL,
0x000000452c237210ULL, 0x080fe20007f7e0ffULL, 0x0000001044537824ULL, 0x000fe200078e00ffULL,
0x00000045482c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000120447824ULL, 0x000fe200078e0203ULL,
0x0000c00052527811ULL, 0x000fe200078e20ffULL, 0x0000001020547824ULL, 0x000fe200078e00ffULL,
0xfffffff053537812ULL, 0x000fe200078ee221ULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x00005e00224a7a11ULL, 0x000fe200078040ffULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0xfffffff054547812ULL, 0x000fc400078ee244ULL, 0x00005f00224b7a11ULL, 0x000fe200000f4420ULL,
0x000000ffff207224ULL, 0x000fe200020e06ffULL, 0x0000004547477210ULL, 0x000fe40007f1e0ffULL,
0x00005e002c487a11ULL, 0x000fe400078840ffULL, 0x00005e0023227a11ULL, 0x000fe200078640ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005e0047447a11ULL, 0x000fe400078040ffULL,
0x000000504a4a7210ULL, 0x000fc40007fbe0ffULL, 0x00005f0047477a11ULL, 0x000fe400000f4449ULL,
0x00005f002c2c7a11ULL, 0x000fe200020f4420ULL, 0x000000ffff4b7224ULL, 0x000fe200028e064bULL,
0x00005f0023237a11ULL, 0x000fe400018f4421ULL, 0x0000005044207210ULL, 0x080fe40007f1e0ffULL,
0x0000005022227210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004a517faeULL, 0x0003e2000b901c46ULL, 0x0000005048487210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e0647ULL, 0x0000c00053537811ULL, 0x000fe200078e20ffULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x0000c00054547811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200020e062cULL, 0x0000000020527faeULL, 0x0003e8000b901c46ULL,
0x0000000022537faeULL, 0x0003e8000b901c46ULL, 0x0000000048547faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff207f8cULL, 0x000e64000c80043fULL, 0x000000ffff447224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x0106b400ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fc40007804861ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x00000022202c7210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011423ULL, 0x0000002c22227211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000222227819ULL, 0x000fc80000001223ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000147477810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000033ff20723eULL, 0x000fe400000000ffULL,
0x00000002ff217819ULL, 0x000fe40000011603ULL, 0x0000541020207816ULL, 0x000fe20000000020ULL,
0x0000baa27f007947ULL, 0x000fea000b800000ULL, 0x00001f2120347589ULL, 0x0002a400000e0000ULL,
0x0000000821357810ULL, 0x000fe20007ffe0ffULL, 0x0000bad27f007947ULL, 0x000fea000b800000ULL,
0x00001f3520357589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001021477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0020ULL,
0x0000cd6000487802ULL, 0x000fc40000000f00ULL, 0x0000c26000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001821477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0020ULL, 0x0000cdb000487802ULL, 0x000fc40000000f00ULL,
0x0000c21000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b000425a7811ULL, 0x000fc400078e20ffULL,
0x000000004050783bULL, 0x000f280000004200ULL, 0x000000004154783bULL, 0x000ee80000004200ULL,
0x000000003e48783bULL, 0x000ea20000004200ULL, 0x00000018ff207819ULL, 0x01afe20000011450ULL,
0x0000010051617824ULL, 0x040fe200078e00ffULL, 0x00008880515f7816ULL, 0x000fe200000000ffULL,
0x00000100505e7824ULL, 0x040fe200078e00ffULL, 0x0000002000607306ULL, 0x0003e20000200c00ULL,
0x00008880505b7816ULL, 0x040fe200000000ffULL, 0x0001000050507824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fc40000011461ULL, 0x00000018ff5c7819ULL, 0x000fe40000011454ULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000006100627306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x002fe20000011451ULL, 0x0001000051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x004fe40000011448ULL, 0x00000018ff587819ULL, 0x000fe40000011452ULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000005000617306ULL, 0x0002a20000200c00ULL,
0x00000018ff597819ULL, 0x000fc40000011453ULL, 0x00000018ff697819ULL, 0x000fe40000011449ULL,
0x00000018ff667819ULL, 0x000fe4000001144aULL, 0x00000018ff677819ULL, 0x000fe2000001144bULL,
0x00000051006c7306ULL, 0x0007e20000200c00ULL, 0x0000888052507816ULL, 0x002fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x00000018ff5d7819ULL, 0x000fc40000011455ULL,
0x00000018ff6a7819ULL, 0x000fe20000011456ULL, 0x00000050006d7306ULL, 0x0003e20000200c00ULL,
0x0000010052517824ULL, 0x048fe200078e00ffULL, 0x0000541061607816ULL, 0x004fe20000000060ULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011457ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000002000637306ULL, 0x0004e20000200c00ULL,
0x0000888053507816ULL, 0x002fc400000000ffULL, 0x00000018ff527819ULL, 0x000fca0000011452ULL,
0x00000051006e7306ULL, 0x0003220000200c00ULL, 0x000000003f20783bULL, 0x004eae0000004200ULL,
0x00000050006f7306ULL, 0x0009e20000200c00ULL, 0x0000010053517824ULL, 0x042fe200078e00ffULL,
0x000054106c617816ULL, 0x008fe20000000063ULL, 0x0001000053537824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000005200707306ULL, 0x000fe20000200c00ULL, 0x0000888054507816ULL, 0x010fe400000000ffULL,
0x000054106d6e7816ULL, 0x000fca000000006eULL, 0x0000005100717306ULL, 0x0002f00000200c00ULL,
0x0000005000737306ULL, 0x0009e20000200c00ULL, 0x0000010054517824ULL, 0x042fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000005300727306ULL, 0x000fe20000200c00ULL,
0x0000888055507816ULL, 0x010fe400000000ffULL, 0x000054106f6f7816ULL, 0x008fe40000000071ULL,
0x00000018ff647819ULL, 0x004fe40000011420ULL, 0x00000018ff657819ULL, 0x000fe20000011421ULL,
0x0000005100747306ULL, 0x0003e20000200c00ULL, 0x00000018ff2c7819ULL, 0x000fc40000011422ULL,
0x00000018ff477819ULL, 0x000fca0000011423ULL, 0x0000005000767306ULL, 0x0005e20000200c00ULL,
0x0000010055517824ULL, 0x042fe400078e00ffULL, 0x0001000055557824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005400757306ULL, 0x0003e20000200c00ULL,
0x0000888056507816ULL, 0x004fe400000000ffULL, 0x00000018ff557819ULL, 0x000fca0000011455ULL,
0x0000005100777306ULL, 0x0005e20000200c00ULL, 0x0000888049547816ULL, 0x002fce00000000ffULL,
0x0000005000797306ULL, 0x0003e20000200c00ULL, 0x0000010056517824ULL, 0x044fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000888057507816ULL, 0x002fe400000000ffULL,
0x00000018ff567819ULL, 0x000fca0000011456ULL, 0x00000051007a7306ULL, 0x0003f00000200c00ULL,
0x00000050007c7306ULL, 0x0005e20000200c00ULL, 0x0000010057517824ULL, 0x042fe400078e00ffULL,
0x0001000057577824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x0000888048507816ULL, 0x004fe400000000ffULL,
0x00000018ff577819ULL, 0x000fca0000011457ULL, 0x00000051007d7306ULL, 0x0005f00000200c00ULL,
0x00000050007f7306ULL, 0x000fe20000200c00ULL, 0x0000010048517824ULL, 0x044fe200078e00ffULL,
0x000054105b5e7816ULL, 0x002fe2000000005eULL, 0x0001000048487824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000005f005f7306ULL, 0x000e700000200c00ULL, 0x0000004800817306ULL, 0x0005f00000200c00ULL,
0x0000005100807306ULL, 0x0007e20000200c00ULL, 0x000000ffff487224ULL, 0x004fe200078e0054ULL,
0x000054105f5f7816ULL, 0x002fe20000000062ULL, 0x0000010049547824ULL, 0x000fc400078e00ffULL,
0x0001000049497824ULL, 0x000fc600078e00ffULL, 0x0000004800827306ULL, 0x0003e20000200c00ULL,
0x000000005a50783bULL, 0x0084e20000000200ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff547819ULL, 0x000fc80000011454ULL, 0x0000004900847306ULL, 0x0009e20000200c00ULL,
0x000088804a487816ULL, 0x002fe400000000ffULL, 0x00008880215a7816ULL, 0x004fca00000000ffULL,
0x0000004800857306ULL, 0x0003e20000200c00ULL, 0x000001004a497824ULL, 0x050fe400078e00ffULL,
0x000100004a4a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000005400837306ULL, 0x000fe20000200c00ULL,
0x000088804b487816ULL, 0x002fce00000000ffULL, 0x0000004900867306ULL, 0x0003f00000200c00ULL,
0x0000004800887306ULL, 0x0005e20000200c00ULL, 0x000001004b497824ULL, 0x042fe200078e00ffULL,
0x000000345050a232ULL, 0x088fe20000000000ULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x000000345252a232ULL, 0x000fc40000000000ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x000000355151a232ULL, 0x080fe20000000000ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000004a00877306ULL, 0x000fe20000200c00ULL, 0x0000888020487816ULL, 0x004fe200000000ffULL,
0x000000355353a232ULL, 0x000fcc0000000000ULL, 0x0000004900897306ULL, 0x0003e20000200c00ULL,
0x000000605018723cULL, 0x040bee0000001818ULL, 0x00000048006c7306ULL, 0x0005e20000200c00ULL,
0x0000010020497824ULL, 0x002fe200078e00ffULL, 0x0000541079607816ULL, 0x020fe2000000007aULL,
0x0000005e501c723cULL, 0x000f62000000181cULL, 0x000054107c617816ULL, 0x000fe2000000007dULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011449ULL,
0x0000004b008a7306ULL, 0x0003e20000200c00ULL, 0x0000b00043487811ULL, 0x004fe400078e20ffULL,
0x000000605060723cULL, 0x000be20000001804ULL, 0x00000018ff207819ULL, 0x000fc80000011420ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000000004848783bULL, 0x002e620000000200ULL,
0x0000010022057824ULL, 0x060fe200078e00ffULL, 0x0000888022047816ULL, 0x040fe200000000ffULL,
0x0000006e5014723cULL, 0x000f620000001814ULL, 0x0001000022227824ULL, 0x000fe400078e00ffULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x0000005900597306ULL, 0x000fe40000200c00ULL,
0x00000018ff227819ULL, 0x000fcc0000011422ULL, 0x0000005c005c7306ULL, 0x000eb00000200c00ULL,
0x0000005d005d7306ULL, 0x000ff00000200c00ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00005410755c7816ULL, 0x004fce000000005cULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000344848a232ULL, 0x082fe40000000000ULL, 0x000000344a4aa232ULL, 0x000fe40000000000ULL,
0x000000354949a232ULL, 0x080fe40000000000ULL, 0x000000354b4ba232ULL, 0x000fe20000000000ULL,
0x0000005500787306ULL, 0x0002b00000200c00ULL, 0x00000056007b7306ULL, 0x000ee20000200c00ULL,
0x0000541072557816ULL, 0x002fc40000000059ULL, 0x0000541076597816ULL, 0x000fca0000000077ULL,
0x00000057007e7306ULL, 0x000e620000200c00ULL, 0x00005410785d7816ULL, 0x004fce000000005dULL,
0x00000054006d7306ULL, 0x0005e20000200c00ULL, 0x000054107b6a7816ULL, 0x008fe2000000006aULL,
0x0000005c505c723cULL, 0x000be20000001808ULL, 0x000054107e6b7816ULL, 0x002fca000000006bULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x0000541070547816ULL, 0x004fe40000000058ULL,
0x0000541073587816ULL, 0x000fe40000000074ULL, 0x000054107f087816ULL, 0x020fe20000000080ULL,
0x0000006a504c723cULL, 0x040fe2000000184cULL, 0x0000541082097816ULL, 0x000fe20000000083ULL,
0x0000006900697306ULL, 0x000eac0000200c00ULL, 0x000000545054723cULL, 0x000be40000001810ULL,
0x0000006600667306ULL, 0x000ee20000200c00ULL, 0x0000541081687816ULL, 0x002fc80000000068ULL,
0x000000ffff107224ULL, 0x020fe200078e005aULL, 0x000000084808723cULL, 0x000fe2000000181cULL,
0x0000010021117824ULL, 0x040fe200078e00ffULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000541084697816ULL, 0x004fe40000000069ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x000000585058723cULL, 0x000b62000000180cULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000000400507306ULL, 0x0205e20000200c00ULL,
0x0000541087667816ULL, 0x008fca0000000066ULL, 0x00000068480c723cULL, 0x000f640000001818ULL,
0x0000000500517306ULL, 0x0007220000200c00ULL, 0x0000888023047816ULL, 0x004fe400000000ffULL,
0x000054108a677816ULL, 0x002fca0000000067ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000010023057824ULL, 0x048fe400078e00ffULL, 0x0001000023237824ULL, 0x000fc600078e00ffULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x00005410501c7816ULL, 0x010fce0000000051ULL,
0x0000002c002c7306ULL, 0x000ff00000200c00ULL, 0x0000004700477306ULL, 0x000ff00000200c00ULL,
0x00000010006e7306ULL, 0x0003f00000200c00ULL, 0x00000011006f7306ULL, 0x0004e20000200c00ULL,
0x0000541085107816ULL, 0x002fce0000000086ULL, 0x0000002000207306ULL, 0x000e620000200c00ULL,
0x0000541088117816ULL, 0x004fce0000000089ULL, 0x0000002100217306ULL, 0x000ea20000200c00ULL,
0x000000104810723cULL, 0x000b6e0000001814ULL, 0x00000004001d7306ULL, 0x000fe20000200c00ULL,
0x000054106c147816ULL, 0x020fe4000000006dULL, 0x000054106e157816ULL, 0x008fc4000000006fULL,
0x0000541020647816ULL, 0x002fc60000000064ULL, 0x00000005001e7306ULL, 0x0002e20000200c00ULL,
0x0000541021657816ULL, 0x004fe20000000065ULL, 0x000000144814723cULL, 0x040b6c0000001858ULL,
0x0000002200227306ULL, 0x000ea40000200c00ULL, 0x000000664804723cULL, 0x042b6c0000001854ULL,
0x0000002300237306ULL, 0x000e620000200c00ULL, 0x000054101d1d7816ULL, 0x008fe2000000001eULL,
0x000000644818723cULL, 0x000b62000000185cULL, 0x0000541022227816ULL, 0x004fce000000002cULL,
0x0000001c481c723cULL, 0x000b620000001860ULL, 0x0000541023237816ULL, 0x002fce0000000047ULL,
0x000000224820723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff487f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000803d2c7810ULL, 0x000fe20007ffe0ffULL,
0x01069800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4c7224ULL, 0x002fe400078e0049ULL,
0x000000242c00720cULL, 0x000fe40003f06070ULL, 0x000000012d2c7810ULL, 0x000fd60007ffe0ffULL,
0x0000428000000947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fc40000015200ULL,
0x0106bc00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe4000780484cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a482c7210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e49ULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc8000001144aULL,
0x0000002c28287211ULL, 0x000fca00078110ffULL, 0x000000ffff2c7224ULL, 0x000fca00000e064aULL,
0x0000000228287819ULL, 0x000fc8000000122cULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe4000780484cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x0000000127477824ULL, 0x000fe200078e0236ULL,
0x000000a03d287810ULL, 0x000fe40007ffe0ffULL, 0x00000002364b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000147487824ULL, 0x040fe200078e0203ULL, 0x00000004364c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001047507824ULL, 0x000fe200078e00ffULL, 0x00000028242c7217ULL, 0x000fe20007800000ULL,
0x00000001274a7824ULL, 0x040fe200078e024bULL, 0x0000000636537810ULL, 0x000fe20007ffe0ffULL,
0x00000001274d7824ULL, 0x040fe200078e024cULL, 0xfffffff050507812ULL, 0x000fe200078ee248ULL,
0x000000012c2c7824ULL, 0x000fe200078e0a28ULL, 0x0000006000287811ULL, 0x000fe200078e38ffULL,
0x000000014a487824ULL, 0x100fe200078e0203ULL, 0x000000f02e4f7812ULL, 0x000fe200078ec0ffULL,
0x000000104a517824ULL, 0x000fe200078e00ffULL, 0x0000002c272c7217ULL, 0x000fe20007800000ULL,
0x000000014d4e7824ULL, 0x040fe200078e0203ULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000104d527824ULL, 0x000fe200078e00ffULL, 0xfffffff051517812ULL, 0x000fe200078ee248ULL,
0x0000000127487824ULL, 0x000fc400078e0253ULL, 0x0000000147497824ULL, 0x000fe200078e0228ULL,
0xfffffff052527812ULL, 0x000fe200078ee24eULL, 0x000000014a4e7824ULL, 0x100fe200078e0228ULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000014d477824ULL, 0x100fe200078e0228ULL,
0x0000004549497210ULL, 0x080fe20007f1e0ffULL, 0x0000000148287824ULL, 0x000fe200078e0228ULL,
0x000000454e4e7210ULL, 0x080fe20007f3e0ffULL, 0x00000001484a7824ULL, 0x040fe200078e0203ULL,
0x0000004547477210ULL, 0x080fe20007f9e0ffULL, 0x0000001048547824ULL, 0x000fe200078e00ffULL,
0x0000004528287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff457224ULL, 0x000fe200008e06ffULL,
0x00005e004e4d7a11ULL, 0x000fe200078440ffULL, 0x000000012c2c7824ULL, 0x000fe200078e0a27ULL,
0xfffffff054547812ULL, 0x000fe200078ee24aULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0x00005e0049487a11ULL, 0x000fc400078040ffULL, 0x00005f004e4e7a11ULL, 0x000fe200010f4445ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x0000002c3600720cULL, 0x080fe40003f46070ULL,
0x00005f0049497a11ULL, 0x000fe400000f444aULL, 0x0000004f48487210ULL, 0x000fe40007fbe0ffULL,
0x0000002c4b00720cULL, 0x080fe20003f26070ULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x00005e00474a7a11ULL, 0x000fe200078840ffULL, 0x000000ffff497224ULL, 0x000fe200028e0649ULL,
0x0000002c4c00720cULL, 0x000fc40003f06070ULL, 0x00005e00284c7a11ULL, 0x000fe400078c40ffULL,
0x0000002c5300720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048507faeULL, 0x0003e2000d101c46ULL, 0x00005f00472c7a11ULL, 0x000fe400020f444bULL,
0x0000004f4a4a7210ULL, 0x080fe40007f9e0ffULL, 0x00005f0028287a11ULL, 0x000fe400030f4445ULL,
0x0000004f4c4c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff4b7224ULL, 0x000fe200020e062cULL,
0x0000e00052527811ULL, 0x000fc400078e20ffULL, 0x0000e00054547811ULL, 0x000fe400078e20ffULL,
0x0000004f4d487210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff4d7224ULL, 0x000fc800028e0628ULL,
0x000000ffff497224ULL, 0x000fca00010e064eULL, 0x0000000048517faeULL, 0x0003e8000c901c46ULL,
0x000000004a527faeULL, 0x0003e8000c101c46ULL, 0x000000004c547faeULL, 0x0003e2000d901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000000127287824ULL, 0x000fe200078e0236ULL,
0x00000060002c7811ULL, 0x000fc400078e38ffULL, 0x000000f02e507812ULL, 0x000fe200078ec0ffULL,
0x0000000128477824ULL, 0x040fe200078e0203ULL, 0x0000000228497810ULL, 0x040fe20007ffe0ffULL,
0x0000001028517824ULL, 0x040fe200078e00ffULL, 0x00000004284a7810ULL, 0x000fc60007ffe0ffULL,
0x0000000149487824ULL, 0x000fe200078e0203ULL, 0xfffffff051517812ULL, 0x000fe200078ee247ULL,
0x0000001049527824ULL, 0x040fe400078e00ffULL, 0x0000000128477824ULL, 0x140fe200078e022cULL,
0x0000000628287810ULL, 0x000fe20007ffe0ffULL, 0x0000000149497824ULL, 0x000fe200078e022cULL,
0xfffffff052527812ULL, 0x000fe200078ee248ULL, 0x000000014a4b7824ULL, 0x140fe200078e0203ULL,
0x0000004547487210ULL, 0x080fe20007f5e0ffULL, 0x000000014a477824ULL, 0x100fe200078e022cULL,
0x0000004549497210ULL, 0x080fe20007f1e0ffULL, 0x00000001284c7824ULL, 0x000fe200078e022cULL,
0x00005e00484e7a11ULL, 0x000fe200078640ffULL, 0x000000104a537824ULL, 0x000fe200078e00ffULL,
0x0000004547477210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x00000001284a7824ULL, 0x040fe200078e0203ULL,
0xfffffff053537812ULL, 0x000fe200078ee24bULL, 0x0000001028547824ULL, 0x000fe200078e00ffULL,
0x000000454c287210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200000e06ffULL,
0x00005f00484d7a11ULL, 0x000fe200018f442cULL, 0x000000ffff457224ULL, 0x000fe200008e06ffULL,
0xfffffff054547812ULL, 0x000fe200078ee24aULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e0049487a11ULL, 0x000fc400078040ffULL, 0x00005e00474a7a11ULL, 0x000fe400078240ffULL,
0x00005e00284c7a11ULL, 0x000fe400078440ffULL, 0x000000504e4e7210ULL, 0x080fe40007f7e0ffULL,
0x00005f0049497a11ULL, 0x000fe400000f444bULL, 0x00005f0047457a11ULL, 0x000fe200008f4445ULL,
0x000000ffff4f7224ULL, 0x000fe200018e064dULL, 0x0000005048487210ULL, 0x000fc40007f1e0ffULL,
0x00005f0028287a11ULL, 0x000fe400010f442cULL, 0x000000504a4a7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e0649ULL, 0x000000504c4c7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e517faeULL, 0x0003e2000b901c46ULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe200008e0645ULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200010e0628ULL,
0x0000e00054547811ULL, 0x000fe200078e20ffULL, 0x0000000048527faeULL, 0x0003e8000b901c46ULL,
0x000000004a537faeULL, 0x0003e8000b901c46ULL, 0x000000004c547faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000022d487810ULL, 0x002fc80007ffe0ffULL,
0x000000254800720cULL, 0x000fe20003f06070ULL, 0xffffffffff287424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000012a487824ULL, 0x000fe400078e0248ULL,
0x00000004ff497424ULL, 0x000fc800078e00ffULL, 0x0000600048487625ULL, 0x000fca00078e0049ULL,
0x0000000648287981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4c7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01066800274e7f8cULL, 0x000664000c80043fULL, 0x0000000000487805ULL, 0x002fc40000015200ULL,
0x01066c00272c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe4000780484fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a48457210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e49ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001144aULL,
0x000000452c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e064aULL,
0x000000022c2c7819ULL, 0x000fc80000001245ULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01066c00272c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe4000780484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010180002f2c7984ULL, 0x000e680000000800ULL, 0x010380002f457984ULL, 0x0006a20000000800ULL,
0x000000462c00720bULL, 0x002fe20003f1d000ULL, 0x00009d127f007947ULL, 0x000fd8000b800000ULL,
0x00000000004a7806ULL, 0x008fc800000e0100ULL, 0x0000ffff4aff7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff477424ULL, 0x000fd600078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x000fe40003f05270ULL,
0x000000462c00720bULL, 0x000fe20003f34000ULL, 0x00009ce27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x000fc400008e0100ULL, 0x000000462c478209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x010580472f008388ULL, 0x0003e40000000800ULL,
0x00009910302f7816ULL, 0x002fc800000000ffULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000462c2f7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff30ff7812ULL, 0x000fc6000780c0ffULL,
0x000000462f2f7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b2f2f7820ULL, 0x000fc80000410000ULL,
0x0000002f004b7308ULL, 0x000e640000000800ULL, 0x0000004b29297220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff2f7819ULL, 0x000fe20000011603ULL,
0x00009c227f007947ULL, 0x000fea000b800000ULL, 0x00001f2f4b2f7589ULL, 0x0002e400000e0000ULL,
0x0000002f08087220ULL, 0x088fe20000410000ULL, 0x0000002f09097220ULL, 0x080fe20000410000ULL,
0x0000002f0c0c7220ULL, 0x080fe20000410000ULL, 0x0000002f0d0d7220ULL, 0x080fe20000410000ULL,
0x0000002f10107220ULL, 0x080fe20000410000ULL, 0x0000002f11117220ULL, 0x080fe20000410000ULL,
0x0000002f04047220ULL, 0x080fe20000410000ULL, 0x0000002f05057220ULL, 0x080fe20000410000ULL,
0x0000002f14147220ULL, 0x080fe20000410000ULL, 0x0000002f15157220ULL, 0x080fe20000410000ULL,
0x0000002f18187220ULL, 0x080fe20000410000ULL, 0x0000002f19197220ULL, 0x080fe20000410000ULL,
0x0000002f1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002f1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002f20207220ULL, 0x080fe20000410000ULL, 0x0000002f21217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0030ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008032f7811ULL, 0x000fe200078ff0ffULL,
0x00009b227f007947ULL, 0x000fea000b800000ULL, 0x00001f2f4b2f7589ULL, 0x00066400000e0000ULL,
0x0000002f0a0a7220ULL, 0x082fe20000410000ULL, 0x0000002f0b0b7220ULL, 0x080fe20000410000ULL,
0x0000002f0e0e7220ULL, 0x080fe20000410000ULL, 0x0000002f0f0f7220ULL, 0x080fe20000410000ULL,
0x0000002f12127220ULL, 0x080fe20000410000ULL, 0x0000002f13137220ULL, 0x080fe20000410000ULL,
0x0000002f06067220ULL, 0x080fe20000410000ULL, 0x0000002f07077220ULL, 0x080fe20000410000ULL,
0x0000002f16167220ULL, 0x080fe20000410000ULL, 0x0000002f17177220ULL, 0x080fe20000410000ULL,
0x0000002f1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002f1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002f1e1e7220ULL, 0x080fe20000410000ULL, 0x0000002f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000002f22227220ULL, 0x080fe20000410000ULL, 0x0000002f23237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff30ff7812ULL, 0x000fe2000780084aULL,
0x00000001ff477424ULL, 0x000fe200078e00ffULL, 0x000000462c467209ULL, 0x000fd60007810000ULL,
0x800000462c2c0221ULL, 0x000fe20000010000ULL, 0x00007610ff470816ULL, 0x000fc60000000047ULL,
0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL, 0x0000002c00330308ULL, 0x000e640000000800ULL,
0x0000003345450220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002945297221ULL, 0x004fc20000010000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x008fcc0000015200ULL, 0x0000004a482f7210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e49ULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001144aULL,
0x0000002f2c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e064aULL,
0x000000022c2c7819ULL, 0x000fc8000000122fULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910472c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2c00720cULL, 0x000fda0003f25270ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000033ff2c723eULL, 0x000fe400000000ffULL, 0x00000002ff2f7819ULL, 0x000fe40000011603ULL,
0x000054102c2c7816ULL, 0x000fe2000000002cULL, 0x000097127f007947ULL, 0x000fea000b800000ULL,
0x00001f2f2c347589ULL, 0x0002a400000e0000ULL, 0x000000082f357810ULL, 0x000fe20007ffe0ffULL,
0x000097427f007947ULL, 0x000fea000b800000ULL, 0x00001f352c357589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000102f477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e002cULL, 0x0000f31000487802ULL, 0x000fc40000000f00ULL,
0x00009cb000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000182f477810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e002cULL,
0x0000f36000487802ULL, 0x000fc40000000f00ULL, 0x00009c6000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003750783bULL, 0x000e620000004200ULL, 0x0000b8003b3b7811ULL, 0x000fc600078e20ffULL,
0x000000003954783bULL, 0x0002e80000004200ULL, 0x000000003858783bULL, 0x0004e80000004200ULL,
0x000000003a48783bULL, 0x008ee20000004200ULL, 0x0000010050397824ULL, 0x042fe200078e00ffULL,
0x0000888050387816ULL, 0x004fc400000000ffULL, 0x00000018ff2c7819ULL, 0x000fe20000011450ULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x00000038005e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff477819ULL, 0x000fe40000011454ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff4e7819ULL, 0x000fe40000011455ULL,
0x00000018ff5d7819ULL, 0x000fe20000011458ULL, 0x00000039005f7306ULL, 0x0005e20000200c00ULL,
0x0000888051387816ULL, 0x002fc400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011459ULL,
0x00000018ff4f7819ULL, 0x000fe4000001145aULL, 0x00000018ff647819ULL, 0x000fe2000001145bULL,
0x0000003800627306ULL, 0x0003e20000200c00ULL, 0x0000010051397824ULL, 0x004fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011456ULL, 0x00000018ff457819ULL, 0x000fe40000011457ULL,
0x00000018ff397819ULL, 0x000fc40000011439ULL, 0x0000002c00607306ULL, 0x0005e20000200c00ULL,
0x0000888052387816ULL, 0x002fe400000000ffULL, 0x00000018ff307819ULL, 0x008fe40000011448ULL,
0x00000018ff377819ULL, 0x000fe40000011449ULL, 0x00000018ff2f7819ULL, 0x000fe2000001144bULL,
0x0000003900637306ULL, 0x0003e20000200c00ULL, 0x00000018ff2c7819ULL, 0x004fe20000011451ULL,
0x0001000051517824ULL, 0x000fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000003800677306ULL, 0x0005e20000200c00ULL, 0x0000010052397824ULL, 0x002fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000005100667306ULL, 0x0003e20000200c00ULL,
0x0000888053387816ULL, 0x004fce00000000ffULL, 0x0000003900687306ULL, 0x0005e20000200c00ULL,
0x0000010055517824ULL, 0x002fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000038006b7306ULL, 0x0003e20000200c00ULL, 0x0000010053397824ULL, 0x004fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000051007f7306ULL, 0x0005e20000200c00ULL,
0x0000888058387816ULL, 0x002fce00000000ffULL, 0x00000039006c7306ULL, 0x0003e20000200c00ULL,
0x0000010056517824ULL, 0x004fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000038006f7306ULL, 0x0005e20000200c00ULL, 0x0000010058397824ULL, 0x042fe400078e00ffULL,
0x0001000058587824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000002c00657306ULL, 0x0003e20000200c00ULL, 0x0000888059387816ULL, 0x004fe400000000ffULL,
0x00000018ff587819ULL, 0x000fca0000011458ULL, 0x0000003900707306ULL, 0x0004e20000200c00ULL,
0x00000018ff2c7819ULL, 0x002fe20000011452ULL, 0x0001000052527824ULL, 0x000fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000003800717306ULL, 0x0003e20000200c00ULL,
0x0000010059397824ULL, 0x044fe400078e00ffULL, 0x0001000059597824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000005000617306ULL, 0x0004a20000200c00ULL,
0x000088805a387816ULL, 0x002fe400000000ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x000054106f707816ULL, 0x008fc60000000070ULL, 0x0000003900737306ULL, 0x0002e20000200c00ULL,
0x0000888055507816ULL, 0x044fe200000000ffULL, 0x0001000055557824ULL, 0x000fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000003800757306ULL, 0x0005e20000200c00ULL,
0x000001005a397824ULL, 0x042fe200078e00ffULL, 0x0000541061607816ULL, 0x000fe20000000060ULL,
0x000100005a5a7824ULL, 0x000fe200078e00ffULL, 0x0000541066617816ULL, 0x000fe40000000065ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000002c00697306ULL, 0x0003e20000200c00ULL,
0x000088805b387816ULL, 0x004fc400000000ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000541071717816ULL, 0x008fc60000000073ULL, 0x0000003900767306ULL, 0x0004e20000200c00ULL,
0x00000018ff2c7819ULL, 0x002fe20000011453ULL, 0x0001000053537824ULL, 0x000fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000003800787306ULL, 0x0003e20000200c00ULL,
0x000001005b397824ULL, 0x044fe400078e00ffULL, 0x000100005b5b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000050007e7306ULL, 0x0005e20000200c00ULL,
0x0000888054387816ULL, 0x002fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fca000001145bULL,
0x0000003900797306ULL, 0x0002e20000200c00ULL, 0x0000888056507816ULL, 0x044fe200000000ffULL,
0x0001000056567824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x00000038007b7306ULL, 0x000fe20000200c00ULL, 0x0000010054397824ULL, 0x042fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000005100827306ULL, 0x0003e20000200c00ULL, 0x00000018ff547819ULL, 0x000fce0000011454ULL,
0x00000039007c7306ULL, 0x0005e20000200c00ULL, 0x0000010057517824ULL, 0x002fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005000817306ULL, 0x0003e20000200c00ULL,
0x000000003b38783bULL, 0x004eae0000000200ULL, 0x0000002c006d7306ULL, 0x0007e20000200c00ULL,
0x0000888057507816ULL, 0x042fe200000000ffULL, 0x0001000057577824ULL, 0x000fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x00000052006a7306ULL, 0x000e620000200c00ULL,
0x00000018ff2c7819ULL, 0x008fce000001144aULL, 0x00000053006e7306ULL, 0x000ef00000200c00ULL,
0x0000005000847306ULL, 0x0003f00000200c00ULL, 0x0000005100857306ULL, 0x0007e20000200c00ULL,
0x0000003438389232ULL, 0x084fe20000000000ULL, 0x000054105e507816ULL, 0x002fe2000000005fULL,
0x000000343a3a9232ULL, 0x000fc40000000000ULL, 0x0000003539399232ULL, 0x080fe40000000000ULL,
0x000000353b3b9232ULL, 0x000fe20000000000ULL, 0x00000054007d7306ULL, 0x0003e20000200c00ULL,
0x0000541062517816ULL, 0x008fca0000000063ULL, 0x00000060380c723cULL, 0x000be4000000180cULL,
0x0000005500807306ULL, 0x0005e20000200c00ULL, 0x0000541067547816ULL, 0x002fc80000000068ULL,
0x0000541075607816ULL, 0x020fe20000000076ULL, 0x000000503850723cULL, 0x000be20000001808ULL,
0x0000541078617816ULL, 0x000fe20000000079ULL, 0x0000005800727306ULL, 0x0003e20000200c00ULL,
0x000054106b557816ULL, 0x004fc8000000006cULL, 0x0000888048087816ULL, 0x060fe200000000ffULL,
0x0000010048097824ULL, 0x000fe200078e00ffULL, 0x000000703814723cULL, 0x000f620000001814ULL,
0x0000005900747306ULL, 0x0005e20000200c00ULL, 0x000054106a587816ULL, 0x002fe20000000069ULL,
0x0001000048487824ULL, 0x000fca00078e00ffULL, 0x000000603860723cULL, 0x000fe2000000181cULL,
0x0000000800657306ULL, 0x0003e20000200c00ULL, 0x000054106e597816ULL, 0x004fe4000000006dULL,
0x00000018ff487819ULL, 0x000fca0000011448ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000b8003c087811ULL, 0x002fce00078e20ffULL, 0x0000005c005c7306ULL, 0x000e700000200c00ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x00005410725e7816ULL, 0x004fce000000005dULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x00005410745f7816ULL, 0x002fce000000005cULL,
0x0000005a00777306ULL, 0x000fe20000200c00ULL, 0x0000005e385c723cULL, 0x000bee0000001818ULL,
0x0000005b007a7306ULL, 0x0002a20000200c00ULL, 0x000001004b187824ULL, 0x020fca00078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000005600837306ULL, 0x000fe20000200c00ULL,
0x000000583858723cULL, 0x002b6e0000001804ULL, 0x0000005700867306ULL, 0x0003e20000200c00ULL,
0x0000010049057824ULL, 0x020fe200078e00ffULL, 0x000088804a067816ULL, 0x000fc800000000ffULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000000543854723cULL, 0x002b6e0000001810ULL, 0x00000018ff107819ULL, 0x020fe20000011409ULL,
0x0000000500677306ULL, 0x0005e20000200c00ULL, 0x000000000808783bULL, 0x000e620000000200ULL,
0x0000888049117816ULL, 0x040fe200000000ffULL, 0x0001000049497824ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fe200078e0011ULL, 0x00000010003c7306ULL, 0x0006e20000200c00ULL,
0x000054107a057816ULL, 0x004fe40000000064ULL, 0x00000018ff497819ULL, 0x000fca0000011449ULL,
0x0000000400667306ULL, 0x0004620000200c00ULL, 0x000088804b107816ULL, 0x048fe200000000ffULL,
0x000100004b4b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000004e004e7306ULL, 0x000ee20000200c00ULL, 0x0000541077047816ULL, 0x004fe4000000004fULL,
0x00005410651c7816ULL, 0x000fca000000003cULL, 0x000000043838723cULL, 0x000b620000001820ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x00005410661d7816ULL, 0x002fca0000000067ULL,
0x000001004a047824ULL, 0x020fe200078e00ffULL, 0x0000541080117816ULL, 0x008fe2000000004eULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x0000000600207306ULL, 0x000fe20000200c00ULL,
0x0000003408089232ULL, 0x080fe20000000000ULL, 0x00000018ff047819ULL, 0x000fe20000011404ULL,
0x000000340a0a9232ULL, 0x000fe20000000000ULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000003509099232ULL, 0x080fe20000000000ULL, 0x000054107e057816ULL, 0x000fe2000000007fULL,
0x000000350b0b9232ULL, 0x000fe20000000000ULL, 0x0000000400217306ULL, 0x0002ac0000200c00ULL,
0x0000001c0814723cULL, 0x000b640000001814ULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x000054107b047816ULL, 0x002fce000000007cULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x0000541020207816ULL, 0x004fe20000000021ULL, 0x000000040804723cULL, 0x000f6c0000001850ULL,
0x0000003700377306ULL, 0x000fe20000200c00ULL, 0x0000541086197816ULL, 0x008fce0000000045ULL,
0x0000004800487306ULL, 0x000e700000200c00ULL, 0x0000004900497306ULL, 0x000eb00000200c00ULL,
0x0000001000227306ULL, 0x0007e20000200c00ULL, 0x00005410481c7816ULL, 0x022fce0000000030ULL,
0x0000001800237306ULL, 0x0002620000200c00ULL, 0x000054107d107816ULL, 0x008fe40000000047ULL,
0x00005410491d7816ULL, 0x004fca0000000037ULL, 0x0000002c002c7306ULL, 0x000fe20000200c00ULL,
0x000000100810723cULL, 0x000b62000000180cULL, 0x0000541083187816ULL, 0x002fcc0000000044ULL,
0x0000002f002f7306ULL, 0x000fe20000200c00ULL, 0x00005410810c7816ULL, 0x020fe20000000082ULL,
0x000000180818723cULL, 0x000b620000001858ULL, 0x00005410840d7816ULL, 0x000fe40000000085ULL,
0x0000541022217816ULL, 0x000fc60000000023ULL, 0x0000004a004a7306ULL, 0x000e640000200c00ULL,
0x0000000c080c723cULL, 0x040b6c0000001854ULL, 0x0000004b004b7306ULL, 0x000ea40000200c00ULL,
0x0000001c081c723cULL, 0x000b62000000185cULL, 0x000054104a4a7816ULL, 0x002fce000000002cULL,
0x000000200820723cULL, 0x000b620000001860ULL, 0x000054104b4b7816ULL, 0x004fce000000002fULL,
0x0000004a0808723cULL, 0x000b620000001838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x000e62000c80043fULL, 0x000000ffff307224ULL, 0x000fce00078e00ffULL,
0x0000000000387805ULL, 0x020fc40000015200ULL, 0x0106bc00ff2c7984ULL, 0x000ea40000000800ULL,
0x800000002cff7812ULL, 0x006fe40007804845ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a382f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3a7824ULL, 0x000fe200000e0e39ULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001143aULL,
0x0000002f2c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e063aULL,
0x000000022c2c7819ULL, 0x000fc8000000122fULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000022b2c7810ULL, 0x000fc80007ffe0ffULL, 0x000000262c00720cULL, 0x000fe20003f06070ULL,
0x00005800282c7a24ULL, 0x010fc800078e02ffULL, 0x000000802c307824ULL, 0x000fd000078e00ffULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000c03d3d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001272f7824ULL, 0x000fe200078e0236ULL, 0x0000000236457810ULL, 0x040fe40007ffe0ffULL,
0x0000000436487810ULL, 0x000fe20007ffe0ffULL, 0x000000012f377824ULL, 0x040fe200078e0203ULL,
0x0000003d242c7217ULL, 0x000fe20007800000ULL, 0x000000102f447824ULL, 0x000fe200078e00ffULL,
0x00000006364a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127387824ULL, 0x000fe400078e0245ULL,
0x00000080002f7824ULL, 0x000fe200078e022fULL, 0xfffffff044447812ULL, 0x000fe200078ee237ULL,
0x000000012c2c7824ULL, 0x000fc400078e0a3dULL, 0x0000000127397824ULL, 0x000fe200078e0248ULL,
0x000000302f3c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000138377824ULL, 0x140fe200078e0203ULL,
0x0000002c272c7217ULL, 0x000fe20007800000ULL, 0x0000001038477824ULL, 0x000fe200078e00ffULL,
0x000000022f3b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000139387824ULL, 0x000fe200078e0203ULL,
0x000000062f3a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001039497824ULL, 0x000fe200078e00ffULL,
0xfffffff047477812ULL, 0x000fe200078ee237ULL, 0x0000000127377824ULL, 0x000fe200078e024aULL,
0x000000042f397810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e06ffULL,
0xfffffff049497812ULL, 0x000fe200078ee238ULL, 0x000000012c2c7824ULL, 0x000fe200078e0a27ULL,
0x00005e003c387a11ULL, 0x040fe200078440ffULL, 0x00000001373d7824ULL, 0x000fe200078e0203ULL,
0x000000303b3b7210ULL, 0x000fe20007f9e0ffULL, 0x00000010374b7824ULL, 0x000fe200078e00ffULL,
0x00005f003c3c7a11ULL, 0x000fc400010f442fULL, 0x0000003039397210ULL, 0x000fe40007f7e0ffULL,
0x0000002c3600720cULL, 0x000fe20003f46070ULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0x000000303a307210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200018e06ffULL,
0xfffffff04b4b7812ULL, 0x000fe400078ee23dULL, 0x00005e003b3a7a11ULL, 0x000fe400078840ffULL,
0x000000f02e3d7812ULL, 0x000fc400078ec0ffULL, 0x00005e0039377a11ULL, 0x000fe400078640ffULL,
0x00005f003b3b7a11ULL, 0x000fe200020f4436ULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x0000003d382e7210ULL, 0x000fe40007fbe0ffULL, 0x00005e0030387a11ULL, 0x000fe400078c40ffULL,
0x00005f0039397a11ULL, 0x000fe200018f442fULL, 0x000000ffff2f7224ULL, 0x000fe200028e063cULL,
0x0000002c4500720cULL, 0x000fc40003f86070ULL, 0x0000002c4800720cULL, 0x080fe40003f66070ULL,
0x0000c00044447811ULL, 0x000fe400078e20ffULL, 0x0000002c4a00720cULL, 0x000fe40003f06070ULL,
0x00005f00302c7a11ULL, 0x000fe200030f4436ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e447faeULL, 0x0003e2000d101c46ULL, 0x0000003d3a367210ULL, 0x000fe40007fbe0ffULL,
0x0000c00047477811ULL, 0x000fc400078e20ffULL, 0x0000c00049497811ULL, 0x000fe400078e20ffULL,
0x0000c0004b4b7811ULL, 0x000fe400078e20ffULL, 0x0000003d372e7210ULL, 0x082fe20007f5e0ffULL,
0x000000ffff377224ULL, 0x000fe200028e063bULL, 0x0000003d38387210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e0639ULL, 0x0000000036477faeULL, 0x0003e2000e101c46ULL,
0x000000ffff397224ULL, 0x000fc600028e062cULL, 0x000000002e497faeULL, 0x0003e8000d901c46ULL,
0x00000000384b7faeULL, 0x0003e2000c101c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000000127367824ULL, 0x000fc800078e0236ULL, 0x00000001362c7824ULL, 0x040fe200078e0203ULL,
0x00000002362f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001036377824ULL, 0x040fe200078e00ffULL,
0x00000006363c7810ULL, 0x000fc60007ffe0ffULL, 0x000000012f387824ULL, 0x100fe200078e0203ULL,
0xfffffff037377812ULL, 0x000fe200078ee22cULL, 0x000000102f3b7824ULL, 0x000fe400078e00ffULL,
0x00000080002c7824ULL, 0x000fe200078e0236ULL, 0x0000c00037377811ULL, 0x000fe200078e20ffULL,
0x000000013c447824ULL, 0x040fe200078e0203ULL, 0xfffffff03b3b7812ULL, 0x000fe200078ee238ULL,
0x000000103c4a7824ULL, 0x000fe200078e00ffULL, 0x0000000436387810ULL, 0x000fe40007ffe0ffULL,
0x000000302c2f7210ULL, 0x000fc40007f1e0ffULL, 0x000000022c367810ULL, 0x000fe20007ffe0ffULL,
0x00000001383a7824ULL, 0x000fe200078e0203ULL, 0x000000042c397810ULL, 0x000fe20007ffe0ffULL,
0x0000001038457824ULL, 0x000fe200078e00ffULL, 0x000000062c3d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x0000003036387210ULL, 0x000fe40007f5e0ffULL,
0x00005e002f367a11ULL, 0x000fe400078040ffULL, 0xfffffff045457812ULL, 0x000fc400078ee23aULL,
0x000000f02e3a7812ULL, 0x000fe400078ec0ffULL, 0x00000030393c7210ULL, 0x080fe40007f7e0ffULL,
0x000000303d477210ULL, 0x000fe40007f9e0ffULL, 0x00005f002f2c7a11ULL, 0x000fe200000f442cULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x00005e0038307a11ULL, 0x000fe200078440ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x0000003a362e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0xfffffff04a4a7812ULL, 0x000fc400078ee244ULL,
0x00005e003c447a11ULL, 0x000fe400078640ffULL, 0x00005e0047497a11ULL, 0x040fe400078840ffULL,
0x00005f0038397a11ULL, 0x000fe200010f442fULL, 0x000000ffff2f7224ULL, 0x000fe200000e062cULL,
0x0000003a30367210ULL, 0x080fe40007f1e0ffULL, 0x00005f003c3d7a11ULL, 0x000fe400018f443dULL,
0x0000003a44387210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e377faeULL, 0x0003e2000b901c46ULL, 0x00005f0047487a11ULL, 0x000fc400020f4448ULL,
0x0000003a493a7210ULL, 0x000fe40007f7e0ffULL, 0x0000c0003b2c7811ULL, 0x000fe400078e20ffULL,
0x0000c00045457811ULL, 0x000fe200078e20ffULL, 0x000000ffff3b7224ULL, 0x000fe200018e0648ULL,
0x0000c0004a4a7811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x002fe400000e0639ULL,
0x000000ffff397224ULL, 0x000fc600010e063dULL, 0x00000000362c7faeULL, 0x0003e8000b901c46ULL,
0x0000000038457faeULL, 0x0003e8000b901c46ULL, 0x000000003a4a7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000e64000c80043fULL, 0x000000ffff447224ULL, 0x002fc400078e0045ULL,
0x00000000002e7805ULL, 0x000fca0000015200ULL, 0x0106b400ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x000000362e307210ULL, 0x000fca0007f1e1ffULL, 0x0000000137367824ULL, 0x000fe200000e0e2fULL,
0x003d09003000780cULL, 0x000fc80003f06070ULL, 0x000000ff3600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403000780cULL, 0x000fc80003f06070ULL,
0x000000ff3600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc80000011436ULL, 0x000000302c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff307224ULL, 0x000fca00000e0636ULL, 0x000000022c2c7819ULL, 0x000fc80000001230ULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000033ff2c723eULL, 0x000fe400000000ffULL,
0x00000002ff2e7819ULL, 0x000fe40000011603ULL, 0x000054102c2c7816ULL, 0x000fe2000000002cULL,
0x00007ae27f007947ULL, 0x000fea000b800000ULL, 0x00001f2e2c347589ULL, 0x0002a400000e0000ULL,
0x000000082e357810ULL, 0x000fe20007ffe0ffULL, 0x00007b127f007947ULL, 0x000fea000b800000ULL,
0x00001f352c357589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000102e477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e002cULL,
0x0001100000487802ULL, 0x000fc40000000f00ULL, 0x00007fc000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000182e477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e002cULL, 0x0001105000487802ULL, 0x000fc40000000f00ULL,
0x00007f7000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b80042427811ULL, 0x000fc400078e20ffULL,
0x000000004038783bULL, 0x000f220000004200ULL, 0x0000b80043437811ULL, 0x000fc600078e20ffULL,
0x00000000414c783bULL, 0x0007e80000004200ULL, 0x000000003e48783bULL, 0x000ea80000004200ULL,
0x000000003f3c783bULL, 0x000e640000004200ULL, 0x00000018ff2c7819ULL, 0x01afe20000011438ULL,
0x0000010039547824ULL, 0x040fe200078e00ffULL, 0x0000888039537816ULL, 0x000fe200000000ffULL,
0x0000010038417824ULL, 0x040fe200078e00ffULL, 0x0000002c00527306ULL, 0x0003e20000200c00ULL,
0x0000888038407816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00008880496a7816ULL, 0x004fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000005300557306ULL, 0x000fe20000200c00ULL,
0x00000018ff2c7819ULL, 0x002fe20000011439ULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011448ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000003800537306ULL, 0x0002a20000200c00ULL,
0x00000018ff377819ULL, 0x000fc40000011449ULL, 0x00000018ff327819ULL, 0x000fe4000001144aULL,
0x00000018ff317819ULL, 0x000fe4000001144bULL, 0x00000018ff507819ULL, 0x000fe2000001144cULL,
0x0000003900577306ULL, 0x0007e20000200c00ULL, 0x000088803a387816ULL, 0x002fe400000000ffULL,
0x00000018ff517819ULL, 0x000fe4000001144dULL, 0x00000018ff477819ULL, 0x000fc4000001144eULL,
0x00000018ff457819ULL, 0x000fe2000001144fULL, 0x0000003800587306ULL, 0x0003e20000200c00ULL,
0x000001003a397824ULL, 0x008fe200078e00ffULL, 0x0000541053527816ULL, 0x004fe40000000052ULL,
0x00000018ff2f7819ULL, 0x000fe4000001143cULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000002c00567306ULL, 0x0004e20000200c00ULL, 0x000088803b387816ULL, 0x002fc400000000ffULL,
0x00000018ff307819ULL, 0x000fe4000001143dULL, 0x00000018ff2e7819ULL, 0x000fc6000001143fULL,
0x0000003900597306ULL, 0x0003e20000200c00ULL, 0x00000018ff2c7819ULL, 0x004fe2000001143aULL,
0x000100003a3a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x00000038005c7306ULL, 0x0005e20000200c00ULL, 0x000001003b397824ULL, 0x002fe200078e00ffULL,
0x0000541057537816ULL, 0x008fc80000000056ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000002c005a7306ULL, 0x0003e20000200c00ULL, 0x000088804c387816ULL, 0x004fce00000000ffULL,
0x00000039005d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff2c7819ULL, 0x002fe2000001143bULL,
0x000100003b3b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003800607306ULL, 0x0003e20000200c00ULL, 0x000001004c397824ULL, 0x044fe400078e00ffULL,
0x000100004c4c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003a005b7306ULL, 0x000ea20000200c00ULL, 0x000088804d387816ULL, 0x002fe400000000ffULL,
0x00000018ff4c7819ULL, 0x000fca000001144cULL, 0x0000003900617306ULL, 0x0002f00000200c00ULL,
0x0000003800627306ULL, 0x0009e20000200c00ULL, 0x000001004d397824ULL, 0x002fe200078e00ffULL,
0x000054105b5a7816ULL, 0x004fe2000000005aULL, 0x000100004d4d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003b005f7306ULL, 0x000fe20000200c00ULL,
0x000088804e387816ULL, 0x010fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000541060607816ULL, 0x008fc60000000061ULL, 0x0000003900637306ULL, 0x0002b00000200c00ULL,
0x0000003800647306ULL, 0x0007e20000200c00ULL, 0x000001004e397824ULL, 0x042fe400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000088804f387816ULL, 0x008fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000541062617816ULL, 0x004fc60000000063ULL,
0x0000003900657306ULL, 0x0002b00000200c00ULL, 0x0000003800667306ULL, 0x0007e20000200c00ULL,
0x000001004f397824ULL, 0x042fe400078e00ffULL, 0x000100004f4f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x0000888048387816ULL, 0x008fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000541064647816ULL, 0x004fc60000000065ULL, 0x0000003900677306ULL, 0x0004f00000200c00ULL,
0x0000003800687306ULL, 0x000fe20000200c00ULL, 0x0000010048397824ULL, 0x004fe200078e00ffULL,
0x0000541040407816ULL, 0x002fe20000000041ULL, 0x0001000048487824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x0000541066657816ULL, 0x008fce0000000067ULL,
0x0000003900697306ULL, 0x0005e20000200c00ULL, 0x0000541055417816ULL, 0x002fe20000000054ULL,
0x000000004238783bULL, 0x0042ac0000000200ULL, 0x0000002c005e7306ULL, 0x0007220000200c00ULL,
0x000000ffff427224ULL, 0x002fce00078e006aULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x00000100496a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x008fe2000001143eULL,
0x0001000049497824ULL, 0x000fc600078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000042006b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x000054105f5b7816ULL, 0x010fca000000005eULL, 0x0000006a006c7306ULL, 0x000fe20000200c00ULL,
0x000088804a427816ULL, 0x002fce00000000ffULL, 0x00000048006a7306ULL, 0x0003e20000200c00ULL,
0x0000003438389232ULL, 0x004fce0000000000ULL, 0x00000042006e7306ULL, 0x0005e20000200c00ULL,
0x000001004a487824ULL, 0x042fe200078e00ffULL, 0x000000343a3a9232ULL, 0x000fe20000000000ULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x0000003539399232ULL, 0x080fe40000000000ULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x000000353b3b9232ULL, 0x000fe20000000000ULL,
0x00000049006d7306ULL, 0x0003e20000200c00ULL, 0x000088804b427816ULL, 0x004fe400000000ffULL,
0x00000018ff4a7819ULL, 0x000fc6000001144aULL, 0x000000403804723cULL, 0x000b640000001804ULL,
0x00000048006f7306ULL, 0x0005e20000200c00ULL, 0x000054105c497816ULL, 0x002fc8000000005dULL,
0x000088803c407816ULL, 0x060fe200000000ffULL, 0x000001003c417824ULL, 0x040fe200078e00ffULL,
0x000000523810723cULL, 0x040be20000001810ULL, 0x0000004a00707306ULL, 0x000fe20000200c00ULL,
0x000001004b487824ULL, 0x044fe400078e00ffULL, 0x000100004b4b7824ULL, 0x000fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000005a3818723cULL, 0x000fe20000001818ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000004200717306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fca000001143cULL,
0x000000603814723cULL, 0x040f640000001814ULL, 0x0000004800727306ULL, 0x0003ec0000200c00ULL,
0x000000643820723cULL, 0x000fe40000001820ULL, 0x0000004b00547306ULL, 0x0005e20000200c00ULL,
0x0000541058487816ULL, 0x002fce0000000059ULL, 0x0000004000527306ULL, 0x0203e20000200c00ULL,
0x000000483848723cULL, 0x004b6e000000180cULL, 0x00000018ff0c7819ULL, 0x020fe20000011441ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000000004340783bULL, 0x002e620000000200ULL,
0x000088803d0d7816ULL, 0x000fcc00000000ffULL, 0x0000004c004c7306ULL, 0x000eb00000200c00ULL,
0x0000004d004d7306ULL, 0x000ef00000200c00ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000054104c507816ULL, 0x004fce0000000050ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x000054104d517816ULL, 0x008fce0000000051ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x00000050381c723cULL, 0x000f62000000181cULL, 0x0000003440409232ULL, 0x082fe40000000000ULL,
0x0000003442429232ULL, 0x000fe40000000000ULL, 0x0000003541419232ULL, 0x080fe40000000000ULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x0000003543439232ULL, 0x000fe20000000000ULL,
0x000054104e4e7816ULL, 0x004fcc0000000047ULL, 0x0000003600367306ULL, 0x000ea20000200c00ULL,
0x000054104f4f7816ULL, 0x002fce0000000045ULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000004e3838723cULL, 0x000b6e0000001808ULL, 0x0000000c00537306ULL, 0x0007220000200c00ULL,
0x000054106a367816ULL, 0x004fe40000000036ULL, 0x0000541068087816ULL, 0x020fc40000000069ULL,
0x000054106b097816ULL, 0x000fc6000000006cULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x000000ffff0c7224ULL, 0x008fe200078e000dULL, 0x000054106d377816ULL, 0x002fe20000000037ULL,
0x000001003d0d7824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x000000084008723cULL, 0x000b640000001804ULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x0000541052527816ULL, 0x010fe20000000053ULL, 0x000001003f057824ULL, 0x020fc800078e00ffULL,
0x0000000c00557306ULL, 0x0003e20000200c00ULL, 0x00000018ff057819ULL, 0x000fce0000011405ULL,
0x0000000d00567306ULL, 0x0004e20000200c00ULL, 0x000088803e0c7816ULL, 0x002fce00000000ffULL,
0x0000000c00457306ULL, 0x0003e20000200c00ULL, 0x000001003e0d7824ULL, 0x044fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x0000002f002f7306ULL, 0x000fe20000200c00ULL, 0x000088803f0c7816ULL, 0x042fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000541055537816ULL, 0x008fe20000000056ULL, 0x000000ffff047224ULL, 0x000fe200078e000cULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000003000307306ULL, 0x000fe80000200c00ULL,
0x000000524014723cULL, 0x040f680000001814ULL, 0x0000003c003c7306ULL, 0x000e700000200c00ULL,
0x0000003d003d7306ULL, 0x000eb00000200c00ULL, 0x0000000d00477306ULL, 0x0007300000200c00ULL,
0x00000004004c7306ULL, 0x0003e20000200c00ULL, 0x00000036400c723cULL, 0x008b6e0000001810ULL,
0x0000000500367306ULL, 0x0206a20000200c00ULL, 0x0000541070047816ULL, 0x002fc40000000032ULL,
0x000054106e107816ULL, 0x000fe4000000006fULL, 0x0000541071117816ULL, 0x000fc60000000072ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x0000541054057816ULL, 0x008fc60000000031ULL,
0x000000104010723cULL, 0x040f680000001848ULL, 0x0000002e002e7306ULL, 0x000fe80000200c00ULL,
0x000000044004723cULL, 0x000b680000001818ULL, 0x0000003e003e7306ULL, 0x000e660000200c00ULL,
0x000054103c187816ULL, 0x020fc4000000002fULL, 0x000054103d197816ULL, 0x004fc60000000030ULL,
0x0000003f003f7306ULL, 0x000ea80000200c00ULL, 0x000000184018723cULL, 0x000b6e000000181cULL,
0x00005410451c7816ULL, 0x030fc40000000047ULL, 0x000054104c1d7816ULL, 0x000fce0000000036ULL,
0x0000001c401c723cULL, 0x000b6e0000001820ULL, 0x000054103e207816ULL, 0x022fe4000000002cULL,
0x000054103f217816ULL, 0x004fce000000002eULL, 0x000000204020723cULL, 0x000b620000001838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff2e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000022d2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x002fc400078e002fULL, 0x000000012b2b7810ULL, 0x000fc80007ffe0ffULL,
0x000000262b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffef1f000007947ULL, 0x000fea000383ffffULL, 0x000000ff2600720cULL, 0x000fe20003f05270ULL,
0x000000ffff2f7224ULL, 0x020fe400078e0023ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0022ULL,
0x000000ffff2a7224ULL, 0x000fe400078e001eULL, 0x000000ffff237224ULL, 0x000fe400078e0019ULL,
0x000000ffff2d7224ULL, 0x008fe400078e0021ULL, 0x000000ffff2c7224ULL, 0x000fc400078e0020ULL,
0x000000ffff2b7224ULL, 0x000fe400078e001fULL, 0x000000ffff227224ULL, 0x000fe400078e0018ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fe400078e0013ULL,
0x000000ffff287224ULL, 0x000fe400078e001dULL, 0x000000ffff267224ULL, 0x000fc400078e001cULL,
0x000000ffff257224ULL, 0x000fe400078e001bULL, 0x000000ffff247224ULL, 0x000fe400078e001aULL,
0x000000ffff217224ULL, 0x000fe400078e0017ULL, 0x000000ffff207224ULL, 0x000fe400078e0016ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0015ULL, 0x000000ffff187224ULL, 0x000fc400078e0012ULL,
0x000000ffff147224ULL, 0x000fe400078e000bULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff1d7224ULL, 0x000fe400078e0007ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0006ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff1a7224ULL, 0x000fc400078e0004ULL,
0x000000ffff177224ULL, 0x000fe400078e0011ULL, 0x000000ffff127224ULL, 0x000fe400078e0010ULL,
0x000000ffff167224ULL, 0x000fe400078e000fULL, 0x000000ffff157224ULL, 0x000fe400078e000eULL,
0x000000ffff0b7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0008ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000029007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe200078e0029ULL, 0x0001225000047802ULL, 0x000fc40000000f00ULL,
0x00006bb000007944ULL, 0x006fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002900007308ULL, 0x000ee40000001000ULL, 0xbf80000000297423ULL, 0x008fc80000000029ULL,
0x800000ff29297221ULL, 0x000fc80000010100ULL, 0x0000002900007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006800ff047624ULL, 0x000fe400078e00ffULL,
0x00006900ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604047981ULL, 0x0088e8000c1e9900ULL,
0x0000000000057919ULL, 0x010f240000000000ULL, 0x00000002ff037819ULL, 0x016fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000004007220ULL, 0x008fca0000410000ULL,
0x00001f0300037589ULL, 0x000e6800000e0000ULL, 0x00001f0500007589ULL, 0x000ea200000e0000ULL,
0x0000000a030a7220ULL, 0x042fe20000410000ULL, 0x0000000b030b7220ULL, 0x040fe20000410000ULL,
0x0000000c030c7220ULL, 0x040fe20000410000ULL, 0x0000000d030d7220ULL, 0x040fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001703177220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002803287220ULL, 0x040fe20000410000ULL,
0x0000002c032c7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x000fe20000410000ULL,
0x0000001300137220ULL, 0x044fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x040fe20000410000ULL, 0x0000001600167220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002a002a7220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002e002e7220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x000fc20000410000ULL,
0x0000000000297919ULL, 0x000ee20000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff047819ULL, 0x008fc60000011629ULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x0000000229007812ULL, 0x040fe400078ec0ffULL,
0x0000000829057811ULL, 0x000fe200078ff0ffULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0x0000000400037211ULL, 0x000fe200078ff8ffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000000500067211ULL, 0x000fe200078ff8ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0000000203007810ULL, 0x040fe20007ffe0ffULL, 0x00000008040e7824ULL, 0x040fe200078e00ffULL,
0x0000000403057810ULL, 0x000fe20007ffe0ffULL, 0x00000008040f7824ULL, 0x000fe200078e00ffULL,
0xfffffff807047812ULL, 0x000fc400078ee203ULL, 0x0000000603037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff809097812ULL, 0x000fe400078ee206ULL, 0xfffffff808067812ULL, 0x000fe400078ee200ULL,
0xfffffff80f087812ULL, 0x000fe200078ee203ULL, 0x0000000829037824ULL, 0x000fe200078e00ffULL,
0xfffffff80e077812ULL, 0x000fe400078ee205ULL, 0x0000a00002057811ULL, 0x000fc400078e58ffULL,
0x0000000803037812ULL, 0x000fe400078ec0ffULL, 0x0000000a0b00723eULL, 0x000fe200000000ffULL,
0x0000001004047824ULL, 0x100fe200078e0205ULL, 0x0000000c0d02723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x000fe200078e0205ULL, 0x00000003ff0b7819ULL, 0x000fe20000011629ULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x00005410000c7816ULL, 0x100fe20000000002ULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x00007632000d7816ULL, 0x000fe20000000002ULL,
0x0000001007007824ULL, 0x100fe200078e0205ULL, 0x0000002029107810ULL, 0x000fe20007ffe0ffULL,
0x0000001008027824ULL, 0x000fc400078e0205ULL, 0x0000000c04007388ULL, 0x0007e20000000a00ULL,
0x00000003ff117819ULL, 0x000fe20000011610ULL, 0x00000001030a7824ULL, 0x040fe400078e0209ULL,
0x0000000103077824ULL, 0x040fe400078e0206ULL, 0x0000000103087824ULL, 0x000fe200078e0200ULL,
0x000000121700723eULL, 0x000fe200000000ffULL, 0x0000000103097824ULL, 0x000fe200078e0202ULL,
0x0000001a1b02723eULL, 0x000fe400000000ffULL, 0x0000001e1f03723eULL, 0x000fe200000000ffULL,
0x000000010b047824ULL, 0x008fe200078e0229ULL, 0x00005410000e7816ULL, 0x100fe20000000002ULL,
0x00000001100c7824ULL, 0x000fe200078e0211ULL, 0x00007632000f7816ULL, 0x000fc40000000002ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000e07007388ULL, 0x000fe20000000a00ULL, 0x0ffffff804067812ULL, 0x000fe400078ef829ULL,
0x000000222304723eULL, 0x000fe400000000ffULL, 0x0ffffff80c0d7812ULL, 0x000fe200078ef810ULL,
0x00000010060c7824ULL, 0x000fe200078e0205ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x000000100d127824ULL, 0x000fe200078e0205ULL,
0x000000262800723eULL, 0x000fe400000000ffULL, 0x000000151604723eULL, 0x000fe200000000ffULL,
0x0000000208007388ULL, 0x0007e20000000a00ULL, 0x000000181905723eULL, 0x000fe400000000ffULL,
0x0000001c1d06723eULL, 0x000fe400000000ffULL, 0x0000000729297812ULL, 0x000fc400078ec0ffULL,
0x0000000710107812ULL, 0x000fc800078ec0ffULL, 0x1ffffff810107812ULL, 0x000fe400078ef827ULL,
0x0000002c2d02723eULL, 0x008fe400000000ffULL, 0x000000131403723eULL, 0x000fe400000000ffULL,
0x00005410000e7816ULL, 0x140fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0000000e09007388ULL, 0x000fe20000000a00ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x000000020a007388ULL, 0x0007e20000000a00ULL,
0x000000202100723eULL, 0x000fc600000000ffULL, 0x0004000407007388ULL, 0x0009e20000000a00ULL,
0x000000242502723eULL, 0x008fe400000000ffULL, 0x0000002a2b03723eULL, 0x000fe200000000ffULL,
0x0000000000057919ULL, 0x010ee20000002600ULL, 0x0000002e2f04723eULL, 0x000fe400000000ffULL,
0x0000541000067816ULL, 0x140fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004000608007388ULL, 0x000fe80000000a00ULL, 0x0004000209007388ULL, 0x0009e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000000c0c7984ULL, 0x000ea20000000c00ULL,
0x0000000805007824ULL, 0x008fc600078e00ffULL, 0x0000000012147984ULL, 0x000ee20000000c00ULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0xfffffff8000b7812ULL, 0x000fc800078ee20bULL,
0xfffffff805117812ULL, 0x000fe400078ee211ULL, 0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000411117c10ULL, 0x000fc6000ff3e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005a000b027a11ULL, 0x010fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0011047a11ULL, 0x000fe400078248ffULL, 0x00005b000b037a11ULL, 0x000fe400000f4c00ULL,
0x1ffffff829007812ULL, 0x000fe400078ef827ULL, 0x00005b0011057a11ULL, 0x000fc600008f4c05ULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001010047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x004fe8000c101d06ULL, 0x0000001404007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff277819ULL, 0x000fe20000011602ULL,
0xffffffffff287424ULL, 0x000fc600078e00ffULL, 0x000000252700720cULL, 0x000fda0003f06070ULL,
0x000000022b048824ULL, 0x002fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0227ULL,
0x0000600004048625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff2c7624ULL, 0x000fe200078e00ffULL, 0x0000000604288981ULL, 0x0002a2000c1e1900ULL,
0x00006900ff2d7624ULL, 0x000fca00078e00ffULL, 0x000000062c2c7981ULL, 0x000722000c1e9900ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000008000007824ULL, 0x000fe400078e00ffULL,
0x00000040022a7824ULL, 0x000fe200078e00ffULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000008029297824ULL, 0x000fc600078e00ffULL, 0x00000040000c7812ULL, 0x000fe200078ef82aULL,
0x0000002928177224ULL, 0x004fc800078e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x00afe40000011603ULL, 0x000000300e167812ULL, 0x000fe400078ec0ffULL,
0x0000000818197810ULL, 0x000fe20007ffe0ffULL, 0x000000010c067824ULL, 0x000fe200078e0218ULL,
0x00000010181a7810ULL, 0x040fe40007ffe0ffULL, 0x00000018181b7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c077824ULL, 0x040fe200078e0219ULL, 0x0000000617157210ULL, 0x000fe20007f1e0ffULL,
0x000000010c067824ULL, 0x000fe200078e021aULL, 0x00002000020e7811ULL, 0x000fc400078e68ffULL,
0x0000000717147210ULL, 0x040fe20007f3e0ffULL, 0x000000010c077824ULL, 0x000fe200078e021bULL,
0x00000006170b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0015117a11ULL, 0x000fe200078040ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0014107a11ULL, 0x000fe400078240ffULL, 0x0000000717137210ULL, 0x000fe40007f7e0ffULL,
0x0000002a24067217ULL, 0x000fc40007800000ULL, 0x00005f0015157a11ULL, 0x000fe200000f4409ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078040ffULL,
0x00000001060d7824ULL, 0x000fe200078e0a2aULL, 0x00005f0014147a11ULL, 0x000fe200008f4408ULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x0000000303077211ULL, 0x000fe400078fe8ffULL,
0x00005e0013127a11ULL, 0x000fe400078240ffULL, 0x00005f000b0b7a11ULL, 0x000fe200000f4409ULL,
0x0000000419097824ULL, 0x000fe200078e00ffULL, 0x0000001116067210ULL, 0x000fe20007f7e0ffULL,
0x000000041a117824ULL, 0x000fe200078e00ffULL, 0x00000003070f7812ULL, 0x000fc400078ec0ffULL,
0x00005f0013137a11ULL, 0x000fe200008f4408ULL, 0x000000ffff077224ULL, 0x000fe200018e0615ULL,
0x0000000d1800720cULL, 0x080fe40003f06070ULL, 0x0000000d1900720cULL, 0x080fe40003f26070ULL,
0x0ffffffc0f037812ULL, 0x000fe400078ef803ULL, 0xfffffffc09097812ULL, 0x000fe400078ee20fULL,
0x0000001610087210ULL, 0x080fe20007f7e0ffULL, 0x0000001003037824ULL, 0x100fe200078e020eULL,
0x000000160a0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001009107824ULL, 0x000fe200078e020eULL,
0x0000000d1a00720cULL, 0x080fe20003f46070ULL, 0x000000ffff097224ULL, 0x000fe200018e0614ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x0000000d1b00720cULL, 0x040fe20003f86070ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000008107faeULL, 0x0005e2000c901c46ULL,
0xfffffffc11117812ULL, 0x000fca00078ee20fULL, 0x0000001011117824ULL, 0x000fe200078e020eULL,
0x0000001612067210ULL, 0x002fc80007fbe0ffULL, 0x000000000a117faeULL, 0x0003e2000d101c46ULL,
0x0000002018087810ULL, 0x044fe40007ffe0ffULL, 0x0000002818097810ULL, 0x040fe40007ffe0ffULL,
0x0000003818107810ULL, 0x000fe20007ffe0ffULL, 0x000000010c037824ULL, 0x000fe200078e0208ULL,
0x0000000d0800720cULL, 0x080fe40003f66070ULL, 0x0000000d0900720cULL, 0x000fe40003f46070ULL,
0x0000000317157210ULL, 0x000fe20007f1e0ffULL, 0x000000010c0a7824ULL, 0x002fe200078e0209ULL,
0xfffffffc1b037812ULL, 0x000fc400078ee20fULL, 0x00005e0015147a11ULL, 0x000fe200078c40ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00000030180b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003037824ULL, 0x000fe200078e020eULL, 0x0000000d1000720cULL, 0x080fe40003f06070ULL,
0x00005f0015157a11ULL, 0x000fe200030f4407ULL, 0x000000ffff077224ULL, 0x000fe200028e0613ULL,
0x0000000a170a7210ULL, 0x000fe40007fbe0ffULL, 0x0000000d0b00720cULL, 0x000fe20003f26070ULL,
0x000000010c0d7824ULL, 0x000fe200078e020bULL, 0x0000000006037faeULL, 0x0003e2000e101c46ULL,
0x000000ffff137224ULL, 0x000fe200028e06ffULL, 0x00005e000a127a11ULL, 0x000fe200078a40ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0210ULL, 0x0000000d17117210ULL, 0x000fc40007f9e0ffULL,
0x00005f000a137a11ULL, 0x000fe400028f4413ULL, 0x0000000c170d7210ULL, 0x000fe20007fde0ffULL,
0x0000000409067824ULL, 0x002fe400078e00ffULL, 0x0000000408037824ULL, 0x000fe400078e00ffULL,
0x000000040b077824ULL, 0x000fe200078e00ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee20fULL,
0x0000000410087824ULL, 0x000fe200078e00ffULL, 0xfffffffc03037812ULL, 0x100fe200078ee20fULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0xfffffffc07077812ULL, 0x100fe200078ee20fULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0xfffffffc08087812ULL, 0x000fe200078ee20fULL,
0x00000010060f7824ULL, 0x100fe200078e020eULL, 0x0000001614067210ULL, 0x080fe20007fbe0ffULL,
0x0000001003037824ULL, 0x100fe200078e020eULL, 0x00005e00110a7a11ULL, 0x000fe200078840ffULL,
0x0000001007107824ULL, 0x100fe200078e020eULL, 0x00005e000d0c7a11ULL, 0x000fe200078c40ffULL,
0x00000010080e7824ULL, 0x000fe200078e020eULL, 0x00005f00110b7a11ULL, 0x000fe200020f440bULL,
0x000000ffff077224ULL, 0x000fe200028e0615ULL, 0x0000001612087210ULL, 0x000fc40007fbe0ffULL,
0x00005f000d0d7a11ULL, 0x000fe400030f4409ULL, 0x000000160a0a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0613ULL, 0x000000160c0c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000006037faeULL, 0x0003e4000d901c46ULL, 0x000000ffff0b7224ULL, 0x000fe400020e060bULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x00000000080f7faeULL, 0x0003e8000d101c46ULL,
0x000000000a107faeULL, 0x0003e8000c901c46ULL, 0x000000000c0e7faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000000c03067211ULL, 0x04afe400078ff0ffULL,
0x0000000803167811ULL, 0x000fc400078ff0ffULL, 0x0000000617067210ULL, 0x000fe40007f1e0ffULL,
0x0000001003077811ULL, 0x040fe400078ff0ffULL, 0x0000001803097811ULL, 0x040fe200078ff0ffULL,
0x000000ffff217224ULL, 0x000fe200000e06ffULL, 0x00005e0006207a11ULL, 0x000fe200078040ffULL,
0x000000010c087824ULL, 0x040fe200078e0207ULL, 0x0000000303157211ULL, 0x040fe200078fe8ffULL,
0x000000010c0a7824ULL, 0x000fe200078e0209ULL, 0x00005f0006217a11ULL, 0x000fe200000f4421ULL,
0x000000010c067824ULL, 0x000fe200078e0216ULL, 0x00000020030b7811ULL, 0x040fe200078ff0ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x00000028030f7811ULL, 0x000fc400078ff0ffULL,
0x00000006171f7210ULL, 0x000fe20007fde0ffULL, 0x0000000407067824ULL, 0x000fe200078e00ffULL,
0x0000003003117811ULL, 0x000fe200078ff0ffULL, 0x0000000409077824ULL, 0x000fe200078e00ffULL,
0x0000003803137811ULL, 0x000fe200078ff0ffULL, 0x000000010c0d7824ULL, 0x040fe200078e020bULL,
0x0000000315157812ULL, 0x000fe200078ec0ffULL, 0x000000040f097824ULL, 0x000fe200078e00ffULL,
0x0000000817147210ULL, 0x040fe20007fbe0ffULL, 0x000000010c107824ULL, 0x000fe200078e020fULL,
0x0000000a171d7210ULL, 0x000fe20007f1e0ffULL, 0x000000040b087824ULL, 0x000fe200078e00ffULL,
0x0000200002197811ULL, 0x000fe200078e68ffULL, 0x000000010c127824ULL, 0x000fe200078e0211ULL,
0xfffffffc07077812ULL, 0x100fe200078ee215ULL, 0x00000004110a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x000fe200078ee215ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078c40ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0213ULL,
0x0000000d171b7210ULL, 0x000fe20007f3e0ffULL, 0x00000004130b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc09097812ULL, 0x000fe200078ee215ULL, 0x0000001007117824ULL, 0x000fe200078e0219ULL,
0xfffffffc08087812ULL, 0x100fe200078ee215ULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0xfffffffc0a0a7812ULL, 0x000fc400078ee215ULL, 0x00005f001f1f7a11ULL, 0x000fe200030f440fULL,
0x00000010060f7824ULL, 0x100fe200078e0219ULL, 0x00000010171a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00000012170d7210ULL, 0x040fe20007f7e0ffULL,
0x000000100a187824ULL, 0x100fe200078e0219ULL, 0x0000000c170c7210ULL, 0x000fe20007f9e0ffULL,
0x0000001009177824ULL, 0x000fe200078e0219ULL, 0x0ffffffc15107812ULL, 0x000fe200078ef803ULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x00005e001d1c7a11ULL, 0x000fc400078040ffULL,
0xfffffffc16037812ULL, 0x000fe200078ee215ULL, 0x0000001008167824ULL, 0x000fe200078e0219ULL,
0x00005e001b097a11ULL, 0x000fe200078240ffULL, 0x000000ffff087224ULL, 0x000fe200028e06ffULL,
0xfffffffc0b0b7812ULL, 0x000fe200078ee215ULL, 0x0000001010237824ULL, 0x100fe200078e0219ULL,
0x000000300e227812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x100fe200078e0219ULL,
0x00005e00140a7a11ULL, 0x000fe200078a40ffULL, 0x000000100b197824ULL, 0x000fe200078e0219ULL,
0x00005f001d1d7a11ULL, 0x000fe200000f4407ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe200008f4406ULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x00005e001a107a11ULL, 0x000fc400078240ffULL, 0x0000002022067210ULL, 0x000fe40007f1e0ffULL,
0x00005f00140b7a11ULL, 0x000fe400028f4408ULL, 0x00005e000d127a11ULL, 0x000fe400078440ffULL,
0x00005e000c147a11ULL, 0x000fe400078640ffULL, 0x00005f001a1a7a11ULL, 0x000fe200008f4407ULL,
0x000000ffff077224ULL, 0x000fe200000e0621ULL, 0x0000001e22087210ULL, 0x000fc40007f1e0ffULL,
0x00005f000d137a11ULL, 0x000fe400010f4413ULL, 0x00005f000c157a11ULL, 0x000fe200018f4415ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006237faeULL, 0x0003e2000b901c46ULL,
0x0000000a220a7210ULL, 0x040fe40007f3e0ffULL, 0x0000001c220c7210ULL, 0x040fe40007f5e0ffULL,
0x00000009220e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e061fULL,
0x0000001022107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001222127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e061dULL,
0x0000001422147210ULL, 0x000fe20007f1e0ffULL, 0x0000000008037faeULL, 0x0003e4000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400028e0613ULL, 0x000000000a0f7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fc600000e0615ULL, 0x000000000c117faeULL, 0x0007e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x004fe400018e061bULL, 0x000000ffff117224ULL, 0x008fc600020e061aULL,
0x000000000e167faeULL, 0x0003e8000b901c46ULL, 0x0000000010177faeULL, 0x0003e8000b901c46ULL,
0x0000000012187faeULL, 0x0003e8000b901c46ULL, 0x0000000014197faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01060400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002002037824ULL, 0x002fca00078e0203ULL,
0x00000003ff047819ULL, 0x000fe40000011603ULL, 0x0000000f03037812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x0000000103057810ULL, 0x040fe20007ffe0ffULL,
0x0000002003097824ULL, 0x040fe400078e00ffULL, 0x0000000103067824ULL, 0x040fe400078e0204ULL,
0x0000000104077824ULL, 0x040fe200078e0205ULL, 0x0000001004047810ULL, 0x000fe20007ffe0ffULL,
0x0000002003087824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x000fc400078ec0ffULL,
0x0000001f07077812ULL, 0x000fe200078ec0ffULL, 0x0000000103107824ULL, 0x000fe200078e0204ULL,
0x000001e008067812ULL, 0x000fe200078ee206ULL, 0x0000000105047824ULL, 0x000fe200078e0204ULL,
0x000001e009077812ULL, 0x000fe200078ee207ULL, 0x0000002003057824ULL, 0x040fe200078e00ffULL,
0x0000001f10107812ULL, 0x000fe200078ec0ffULL, 0x00000000060c7984ULL, 0x000e62000000cc00ULL,
0x0000002003037824ULL, 0x000fe200078e00ffULL, 0x0000001f04047812ULL, 0x000fe400078ec0ffULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000001e005107812ULL, 0x000fc400078ee210ULL,
0x000001e003047812ULL, 0x000fe200078ee204ULL, 0x000000ffff147224ULL, 0x002fe400078e000cULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff177224ULL, 0x004fe400078e000aULL,
0x000000ffff167224ULL, 0x000fe400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff087224ULL, 0x000fe200078e000dULL, 0x0000001406007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff097224ULL, 0x000fca00078e000fULL, 0x0000000807007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1b7224ULL, 0x002fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff187224ULL, 0x004fe400078e000cULL,
0x000000ffff197224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001810007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff087f8cULL, 0x002e62000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x01060400ff037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff2600720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000064002b2b7a24ULL, 0x000fe200078e02ffULL,
0x3d8000002c2c7820ULL, 0x010fe20000410000ULL, 0x00010688022d7811ULL, 0x000fe200078e18ffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0xffffffff262e7810ULL, 0x000fe40007ffe0ffULL,
0x00010608022f7811ULL, 0x000fc600078e28ffULL, 0x0000010030327824ULL, 0x000fe200078e022aULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000322400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e0031ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff337224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fc4000001ff00ULL, 0x0000000133357810ULL, 0x000fe20007ffe0ffULL,
0x00000d8000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fc400078e0033ULL,
0x0000003035317211ULL, 0x040fe200078ff0ffULL, 0x0000002928477224ULL, 0x010fe200078e02ffULL,
0x000000043500780cULL, 0x000fe20003f06070ULL, 0x000000ffff337224ULL, 0x000fe200078e0035ULL,
0x0000000131367810ULL, 0x040fe20007ffe0ffULL, 0x0000010031407824ULL, 0x000fe200078e022aULL,
0x0000000134317812ULL, 0x000fe400078e0cffULL, 0x000000263600720cULL, 0x000fe40003f26070ULL,
0x0000004040367812ULL, 0x000fc400078ec0ffULL, 0x0000000335557812ULL, 0x000fc600078ec0ffULL,
0x0000000100417824ULL, 0x000fcc00078e0236ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff427819ULL, 0x002fe20000011603ULL, 0x0000000202487824ULL, 0x000fc600078e0231ULL,
0x00000010424f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000142357824ULL, 0x140fe200078e0241ULL,
0x0000000842447810ULL, 0x040fe40007ffe0ffULL, 0x0000001842507810ULL, 0x000fe20007ffe0ffULL,
0x000000014f377824ULL, 0x100fe200078e0241ULL, 0x00000035473f7210ULL, 0x040fe20007f3e0ffULL,
0x0000000144367824ULL, 0x000fe200078e0241ULL, 0x0000004024357217ULL, 0x000fe20007800000ULL,
0x00000004444a7824ULL, 0x000fe200078e00ffULL, 0x0000003747397210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x00000036473b7210ULL, 0x000fe20007f5e0ffULL,
0x0000000135357824ULL, 0x000fe200078e0a40ULL, 0x00005e003f367a11ULL, 0x000fe200078240ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005e00393c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x00005e003b3a7a11ULL, 0x000fc400078440ffULL,
0x00005f00393d7a11ULL, 0x000fe200018f443dULL, 0x0000000150397824ULL, 0x100fe200078e0241ULL,
0x0000002042517810ULL, 0x040fe40007ffe0ffULL, 0x0000002842527810ULL, 0x040fe40007ffe0ffULL,
0x0000003042537810ULL, 0x040fe40007ffe0ffULL, 0x0000003842547810ULL, 0x000fe40007ffe0ffULL,
0x00005f003b3b7a11ULL, 0x000fe200010f443eULL, 0x00000001513e7824ULL, 0x000fe200078e0241ULL,
0x00005f003f377a11ULL, 0x000fe200008f4437ULL, 0x00000001523f7824ULL, 0x100fe200078e0241ULL,
0x000000354200720cULL, 0x000fe20003f46070ULL, 0x0000000153407824ULL, 0x100fe200078e0241ULL,
0x0000003947427210ULL, 0x040fe20007f3e0ffULL, 0x0000000154397824ULL, 0x000fe200078e0241ULL,
0x0000003e47417210ULL, 0x000fc40007fbe0ffULL, 0x0000003f47437210ULL, 0x040fe20007fde0ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e06ffULL, 0x0000004047457210ULL, 0x040fe40007f9e0ffULL,
0x0000003947477210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4d7224ULL, 0x000fe200030e06ffULL,
0x0000000303397211ULL, 0x000fe200078fe8ffULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005e00423e7a11ULL, 0x040fe200078240ffULL, 0x000000ffff4b7224ULL, 0x000fe200018e06ffULL,
0x00000003394e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff397224ULL, 0x000fe200028e06ffULL,
0x00005f00423f7a11ULL, 0x000fe200008f443fULL, 0x0000000455427824ULL, 0x000fe200078e00ffULL,
0x00005e0041407a11ULL, 0x000fc400078a40ffULL, 0x000000354400720cULL, 0x000fe40003f26070ULL,
0x00005f0041417a11ULL, 0x000fe400028f4439ULL, 0x0000200048487811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4e497812ULL, 0x100fe400078ef803ULL, 0xfffffffc42397812ULL, 0x000fe400078ee203ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e0248ULL,
0x00005e0043427a11ULL, 0x000fe200078a40ffULL, 0x0000001039367825ULL, 0x000fe200078e0036ULL,
0x00005e0045447a11ULL, 0x000fc400078640ffULL, 0x00005e0047467a11ULL, 0x000fe200078840ffULL,
0x000000104a4a7824ULL, 0x000fe200078e0248ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036497faeULL, 0x0003e2000d101c46ULL, 0x00000010393a7825ULL, 0x000fe200078e003aULL,
0x00005f0043437a11ULL, 0x000fe400028f444dULL, 0x00005f0045457a11ULL, 0x000fe200018f444cULL,
0x00000004534c7824ULL, 0x000fe200078e00ffULL, 0x00005f0047477a11ULL, 0x000fe200020f444bULL,
0x000000003a4a7faeULL, 0x0005e2000c901c46ULL, 0x000000354f00720cULL, 0x080fe20003f26070ULL,
0x00000004524b7824ULL, 0x000fe200078e00ffULL, 0x000000355000720cULL, 0x000fc40003f46070ULL,
0x000000355100720cULL, 0x080fe20003f66070ULL, 0x0000000450497824ULL, 0x002fe200078e00ffULL,
0x000000355200720cULL, 0x080fe20003f86070ULL, 0x0000001039367825ULL, 0x000fe200078e003cULL,
0x000000355300720cULL, 0x080fe40003fa6070ULL, 0x000000355400720cULL, 0x040fe20003fc6070ULL,
0x000000044f357824ULL, 0x000fe200078e00ffULL, 0xfffffffc49497812ULL, 0x100fe200078ee24eULL,
0x00000004514a7824ULL, 0x004fe200078e00ffULL, 0xfffffffc4b4b7812ULL, 0x100fe200078ee24eULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc35357812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL,
0x00000010393a7825ULL, 0x000fe200078e003eULL, 0xfffffffc4c4c7812ULL, 0x000fc400078ee24eULL,
0xfffffffc544e7812ULL, 0x000fe200078ee24eULL, 0x0000001035357824ULL, 0x100fe400078e0248ULL,
0x000000104a4a7824ULL, 0x000fe400078e0248ULL, 0x00000010393c7825ULL, 0x000fe200078e0040ULL,
0x0000000036357faeULL, 0x0003e6000c901c46ULL, 0x000000104b4b7824ULL, 0x000fe200078e0248ULL,
0x000000003a497faeULL, 0x0003e2000d101c46ULL, 0x00000010393e7825ULL, 0x000fc600078e0042ULL,
0x000000003c4a7faeULL, 0x0003e2000d901c46ULL, 0x000000104c4c7824ULL, 0x000fe400078e0248ULL,
0x0000001039407825ULL, 0x040fe200078e0044ULL, 0x000000003e4b7faeULL, 0x0003e6000e101c46ULL,
0x000000104e487824ULL, 0x000fe200078e0248ULL, 0x00000000404c7faeULL, 0x0003e2000e901c46ULL,
0x0000001039427825ULL, 0x000fca00078e0046ULL, 0x0000000042487faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x00000008033d7811ULL, 0x002fe200078ff0ffULL,
0x0000000455517824ULL, 0x000fe200078e00ffULL, 0x0000004103357211ULL, 0x040fe400078ff0ffULL,
0x00000018033e7811ULL, 0x000fe200078ff0ffULL, 0x000000013d367824ULL, 0x000fe200078e0241ULL,
0x0000003547377210ULL, 0x000fe20007f3e0ffULL, 0x000000043d457824ULL, 0x000fe200078e00ffULL,
0x00000020033f7811ULL, 0x000fe200078ff0ffULL, 0x000000043e487824ULL, 0x000fe200078e00ffULL,
0x0000003647357210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078240ffULL, 0x000000043f497824ULL, 0x000fe200078e00ffULL,
0x0000002803427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x00005e00353a7a11ULL, 0x000fc400078440ffULL, 0x00005f0037377a11ULL, 0x000fe200008f443bULL,
0x00000004424a7824ULL, 0x000fe200078e00ffULL, 0x00005f00353b7a11ULL, 0x000fe200010f4439ULL,
0x0000000202357824ULL, 0x000fe200078e0231ULL, 0x0000001003397811ULL, 0x040fe200078ff0ffULL,
0x00000001423d7824ULL, 0x100fe200078e0241ULL, 0x0000003003437811ULL, 0x040fe400078ff0ffULL,
0x0000003803447811ULL, 0x000fe200078ff0ffULL, 0x0000000439467824ULL, 0x000fe200078e00ffULL,
0x00000003033c7211ULL, 0x000fe200078fe8ffULL, 0x00000004434b7824ULL, 0x000fe200078e00ffULL,
0x00002000354c7811ULL, 0x000fe200078e60ffULL, 0x0000000139357824ULL, 0x000fe200078e0241ULL,
0x000000033c407812ULL, 0x000fe200078ec0ffULL, 0x00000004444d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc51517812ULL, 0x000fe200078ee203ULL, 0x000000013e397824ULL, 0x100fe200078e0241ULL,
0x0000003547357210ULL, 0x000fe20007f7e0ffULL, 0x000000013f3c7824ULL, 0x100fe200078e0241ULL,
0xfffffffc46467812ULL, 0x100fe200078ee240ULL, 0x00000001433e7824ULL, 0x100fe200078e0241ULL,
0xfffffffc48487812ULL, 0x100fe200078ee240ULL, 0x00000001443f7824ULL, 0x000fe200078e0241ULL,
0xfffffffc45447812ULL, 0x000fe200078ee240ULL, 0x0000001051367825ULL, 0x000fe200078e0036ULL,
0xfffffffc49497812ULL, 0x000fc400078ee240ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee240ULL,
0x0000001048487824ULL, 0x000fe200078e024cULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee240ULL,
0x0000001049497824ULL, 0x000fe200078e024cULL, 0xfffffffc4d4d7812ULL, 0x000fe200078ee240ULL,
0x000000104a4a7824ULL, 0x100fe200078e024cULL, 0x0ffffffc40427812ULL, 0x000fe200078ef803ULL,
0x000000104b4b7824ULL, 0x100fe200078e024cULL, 0x0000003947407210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x0000003c47417210ULL, 0x040fe20007f3e0ffULL,
0x0000001042527824ULL, 0x000fe200078e024cULL, 0x0000003d47437210ULL, 0x000fc40007f7e0ffULL,
0x0000003e47457210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff507224ULL, 0x000fe200008e06ffULL,
0x0000003f47477210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e06ffULL,
0x00005e00353c7a11ULL, 0x040fe200078c40ffULL, 0x000000ffff4f7224ULL, 0x000fe200018e06ffULL,
0x00005e00403e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff4e7224ULL, 0x000fe200020e06ffULL,
0x00005f00353d7a11ULL, 0x000fe200030f4439ULL, 0x0000001044357824ULL, 0x100fe200078e024cULL,
0x00005f00403f7a11ULL, 0x000fe200010f443fULL, 0x0000001046397824ULL, 0x100fe200078e024cULL,
0x00005e0041407a11ULL, 0x000fe200078240ffULL, 0x000000104d4c7824ULL, 0x000fe200078e024cULL,
0x00005e0043427a11ULL, 0x000fe200078440ffULL, 0x000000ffff4d7224ULL, 0x000fe200028e06ffULL,
0x00005e0045447a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036527faeULL, 0x0003e2000b901c46ULL, 0x00005e0047467a11ULL, 0x000fc400078840ffULL,
0x00005f0041417a11ULL, 0x000fe400008f4450ULL, 0x00005f0043437a11ULL, 0x000fe400010f444fULL,
0x00005f0045457a11ULL, 0x000fe400018f444eULL, 0x00005f0047477a11ULL, 0x000fe200020f444dULL,
0x0000001051367825ULL, 0x002fc800078e003aULL, 0x00000010513a7825ULL, 0x040fe200078e003cULL,
0x0000000036357faeULL, 0x0003e6000b901c46ULL, 0x00000010513c7825ULL, 0x040fe200078e003eULL,
0x000000003a397faeULL, 0x0003e6000b901c46ULL, 0x00000010513e7825ULL, 0x040fe200078e0040ULL,
0x000000003c487faeULL, 0x0003e6000b901c46ULL, 0x0000001051407825ULL, 0x040fe200078e0042ULL,
0x000000003e497faeULL, 0x0003e6000b901c46ULL, 0x0000001051427825ULL, 0x040fe200078e0044ULL,
0x00000000404a7faeULL, 0x0003e6000b901c46ULL, 0x0000001051447825ULL, 0x000fe200078e0046ULL,
0x00000000424b7faeULL, 0x0003e8000b901c46ULL, 0x00000000444c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000035500780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000227277810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff287424ULL, 0x000fc600078e00ffULL,
0x000000252700720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000022b367824ULL, 0x002fe400078e0227ULL, 0x00000004ff377424ULL, 0x000fc800078e00ffULL,
0x0000600036367625ULL, 0x000fca00078e0037ULL, 0x0000000636287981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002003477810ULL, 0x040fe20007ffe0ffULL, 0x00000002023b7824ULL, 0x002fe200078e0234ULL,
0xfffffff8033a7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe400078ec0ffULL, 0x0000000703447812ULL, 0x000fe400078ec0ffULL,
0x000000073a3a7812ULL, 0x100fe400078ef803ULL, 0x0000000747477812ULL, 0x000fc400078ef803ULL,
0x000020003b3b7811ULL, 0x000fe400078e60ffULL, 0x0000000844447812ULL, 0x000fe400078ef803ULL,
0x00000001ff457819ULL, 0x000fe4000001163aULL, 0x00000001ff467819ULL, 0x000fe20000011647ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000145347824ULL, 0x120fe200078e0239ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000043a357824ULL, 0x000fe400078e00ffULL,
0x00000001463c7824ULL, 0x000fc400078e0239ULL, 0x00000004473d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc35347812ULL, 0x000fc800078ee234ULL, 0xfffffffc3d3c7812ULL, 0x000fe200078ee23cULL,
0x0000001034347824ULL, 0x000fc800078e023bULL, 0x000000103c3c7824ULL, 0x000fe400078e023bULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x00000018ff407819ULL, 0x002fe20000011434ULL, 0x0001000034417824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011436ULL, 0x0000004000567306ULL, 0x0003e20000200c00ULL,
0x00000018ff4f7819ULL, 0x000fc40000011437ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff4b7819ULL, 0x004fe4000001143cULL, 0x00000018ff4a7819ULL, 0x000fe2000001143dULL,
0x0000004100557306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x002fe40000011435ULL,
0x00000018ff497819ULL, 0x000fe4000001143eULL, 0x00000018ff487819ULL, 0x000fc6000001143fULL,
0x00000040005a7306ULL, 0x0003f00000200c00ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000888034407816ULL, 0x042fe200000000ffULL, 0x0000010034347824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000004000547306ULL, 0x0002b00000200c00ULL,
0x0000003400577306ULL, 0x0006e20000200c00ULL, 0x0000888035407816ULL, 0x002fc400000000ffULL,
0x0000541054547816ULL, 0x004fc60000000055ULL, 0x000000ffff347224ULL, 0x008fe400078e0040ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x0001000035407824ULL, 0x040fe400078e00ffULL,
0x0000010035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003400587306ULL, 0x0003e20000200c00ULL,
0x0000541057557816ULL, 0x000fce0000000056ULL, 0x00000035005b7306ULL, 0x0005e20000200c00ULL,
0x0000888036347816ULL, 0x002fce00000000ffULL, 0x00000034005c7306ULL, 0x0003e20000200c00ULL,
0x0001000036357824ULL, 0x044fe400078e00ffULL, 0x0000010036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000004000597306ULL, 0x000ea20000200c00ULL, 0x0000888037347816ULL, 0x002fce00000000ffULL,
0x00000035005d7306ULL, 0x0002f00000200c00ULL, 0x00000036005e7306ULL, 0x0006e20000200c00ULL,
0x0001000037357824ULL, 0x042fe200078e00ffULL, 0x0000541058587816ULL, 0x004fe20000000059ULL,
0x0000010037377824ULL, 0x000fe200078e00ffULL, 0x000054105b597816ULL, 0x000fc4000000005aULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x00000034005f7306ULL, 0x0003e20000200c00ULL, 0x0000000139367810ULL, 0x008fe40007ffe0ffULL,
0x000054105c5c7816ULL, 0x000fe4000000005dULL, 0x000054105e5d7816ULL, 0x000fc60000000051ULL,
0x0000003500607306ULL, 0x0004e20000200c00ULL, 0x000088803c347816ULL, 0x002fce00000000ffULL,
0x0000003700617306ULL, 0x0002e20000200c00ULL, 0x000100003c357824ULL, 0x044fe400078e00ffULL,
0x000001003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400627306ULL, 0x0005e20000200c00ULL, 0x000000043a377824ULL, 0x002fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000054105f607816ULL, 0x008fc80000000060ULL,
0x0000003500637306ULL, 0x0002e20000200c00ULL, 0x000088803d347816ULL, 0x004fe400000000ffULL,
0x0000541061617816ULL, 0x000fca000000004fULL, 0x0000003c00647306ULL, 0x0005e20000200c00ULL,
0x0000000145357824ULL, 0x102fe400078e0236ULL, 0x0000000146367824ULL, 0x000fc600078e0236ULL,
0xfffffffc37377812ULL, 0x000fe200078ee235ULL, 0x000100003d357824ULL, 0x040fe200078e00ffULL,
0x0000003400657306ULL, 0x0003e20000200c00ULL, 0x000001003d3d7824ULL, 0x000fe200078e00ffULL,
0x000088803f3c7816ULL, 0x004fe200000000ffULL, 0x0000001037377824ULL, 0x000fe200078e023bULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000000003740783bULL, 0x000ea20000000200ULL, 0x0000003500667306ULL, 0x0006e20000200c00ULL,
0x000088803e347816ULL, 0x002fc400000000ffULL, 0x0000541062627816ULL, 0x008fca0000000063ULL,
0x0000003d00677306ULL, 0x0003e20000200c00ULL, 0x0000000447357824ULL, 0x000fca00078e00ffULL,
0xfffffffc35367812ULL, 0x000fe200078ee236ULL, 0x000100003e357824ULL, 0x040fe200078e00ffULL,
0x0000003c006b7306ULL, 0x0005e20000200c00ULL, 0x000100003f3d7824ULL, 0x002fe200078e00ffULL,
0x0000541065667816ULL, 0x000fe20000000066ULL, 0x000001003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000001003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000001036367824ULL, 0x000fe200078e023bULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003400687306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fce000001143fULL, 0x0000003d006c7306ULL, 0x0002e20000200c00ULL,
0x00000018ff3c7819ULL, 0x004fce0000011440ULL, 0x0000003e006a7306ULL, 0x0005e20000200c00ULL,
0x00010000403d7824ULL, 0x002fe200078e00ffULL, 0x0000888042767816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011442ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00707306ULL, 0x0003e20000200c00ULL, 0x00000004383e7824ULL, 0x004fe200078e0239ULL,
0x00000018ff527819ULL, 0x000fc40000011443ULL, 0x000054106b6c7816ULL, 0x008fe4000000006cULL,
0x0000000239397810ULL, 0x000fe40007ffe0ffULL, 0x0000003d006f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x002fe40000011441ULL, 0x000000043900780cULL, 0x000fca0003f25270ULL,
0x0000003c00747306ULL, 0x0003f00000200c00ULL, 0x0000003f006d7306ULL, 0x0005e20000200c00ULL,
0x00008880403c7816ULL, 0x002fce00000000ffULL, 0x0000003c006e7306ULL, 0x0002e20000200c00ULL,
0x00008880413f7816ULL, 0x004fce00000000ffULL, 0x0000003500697306ULL, 0x0004e20000200c00ULL,
0x00000100403c7824ULL, 0x002fe400078e00ffULL, 0x000000023e407824ULL, 0x000fe400078e00ffULL,
0x00000020443e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143cULL,
0x00000040033c7211ULL, 0x000fe200078fe0ffULL, 0x000000003634783bULL, 0x004e620000000200ULL,
0x0000003d00717306ULL, 0x0004a20000200c00ULL, 0x0000000240407810ULL, 0x000fc40007ffe0ffULL,
0x00000001443c7824ULL, 0x000fe200078e023cULL, 0x000054106e6e7816ULL, 0x008fe4000000006fULL,
0x0000004003407211ULL, 0x000fe400078fe0ffULL, 0xffffffe03e3c7812ULL, 0x000fe200078ee23cULL,
0x00010000413e7824ULL, 0x040fe200078e00ffULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x000000ffff3d7224ULL, 0x004fe200078e003fULL, 0x0000541068687816ULL, 0x000fe20000000069ULL,
0x000000103c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000010041417824ULL, 0x000fe200078e00ffULL, 0x00005410716f7816ULL, 0x000fe20000000070ULL,
0x0000000144407824ULL, 0x000fe200078e0240ULL, 0x0000003d00727306ULL, 0x000fe40000200c00ULL,
0x00000018ff417819ULL, 0x000fcc0000011441ULL, 0x0000003e00737306ULL, 0x0004620000200c00ULL,
0x0000541064637816ULL, 0x008fce000000004bULL, 0x0000004100757306ULL, 0x0006e20000200c00ULL,
0x000000003c3c783bULL, 0x004ea20000000200ULL, 0x00000018ff507819ULL, 0x002fe40000011434ULL,
0x00000018ff4e7819ULL, 0x000fc80000011435ULL, 0x0000004a004a7306ULL, 0x000e620000200c00ULL,
0x000000ffff417224ULL, 0x008fe200078e0076ULL, 0x00008880364b7816ULL, 0x000fe200000000ffULL,
0x0001000042767824ULL, 0x040fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011436ULL,
0x0000010042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011437ULL,
0x0000004100777306ULL, 0x0007e20000200c00ULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000018ff427819ULL, 0x000fc40000011442ULL, 0x0000541072727816ULL, 0x000fe40000000073ULL,
0x0000541075737816ULL, 0x000fe20000000074ULL, 0x0000004200787306ULL, 0x0003e20000200c00ULL,
0x0000888043417816ULL, 0x008fe400000000ffULL, 0x0000541067677816ULL, 0x002fca000000004aULL,
0x0000004100797306ULL, 0x0003e20000200c00ULL, 0x0001000043427824ULL, 0x040fe400078e00ffULL,
0x0000010043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x000000543c20723cULL, 0x044b620000001820ULL,
0x0000888034417816ULL, 0x042fe200000000ffULL, 0x00000042007a7306ULL, 0x0002aa0000200c00ULL,
0x0000888035557816ULL, 0x020fe200000000ffULL, 0x000000623c10723cULL, 0x000fe40000001810ULL,
0x0000004100547306ULL, 0x0007e20000200c00ULL, 0x0001000034427824ULL, 0x002fc400078e00ffULL,
0x000000ffff4f7224ULL, 0x000fe400078e0055ULL, 0x0001000035557824ULL, 0x040fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000010035357824ULL, 0x000fe200078e00ffULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x0000002044417824ULL, 0x008fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x000000583c1c723cULL, 0x000f62000000181cULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0xffffffe041407812ULL, 0x000fe200078ee240ULL,
0x0000010034417824ULL, 0x000fe200078e00ffULL, 0x0000004800487306ULL, 0x000ee20000200c00ULL,
0x00005410797a7816ULL, 0x004fc4000000007aULL, 0x0000001040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000005c3c18723cULL, 0x040fe60000001818ULL,
0x00000043007b7306ULL, 0x000fe20000200c00ULL, 0x000054106a697816ULL, 0x002fe20000000049ULL,
0x0001000036497824ULL, 0x040fe400078e00ffULL, 0x0000010036367824ULL, 0x000fe200078e00ffULL,
0x000000603c14723cULL, 0x000fe40000001814ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000004200347306ULL, 0x000e620000200c00ULL, 0x000054106d6d7816ULL, 0x008fc40000000048ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x000000663c0c723cULL, 0x040f66000000180cULL,
0x0000004100517306ULL, 0x0005ea0000200c00ULL, 0x000000683c08723cULL, 0x000f660000001808ULL,
0x00000035004a7306ULL, 0x0007e20000200c00ULL, 0x000000004040783bULL, 0x004ea20000000200ULL,
0x0000541054347816ULL, 0x002fc60000000034ULL, 0x0000006c3c04723cULL, 0x000b660000001804ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000000ffff357224ULL, 0x008fc600078e004bULL,
0x00010000373c7824ULL, 0x020fc800078e00ffULL, 0x00000035004b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fce000001143cULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000888037357816ULL, 0x048fe200000000ffULL, 0x0000010037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000004f004f7306ULL, 0x000ff00000200c00ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x0000006e4020723cULL, 0x044f6e0000001820ULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x00000072401c723cULL, 0x000f6e000000181cULL,
0x00000035003d7306ULL, 0x0003f00000200c00ULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x0000541051357816ULL, 0x002fc40000000050ULL, 0x0000541077767816ULL, 0x004fca0000000076ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x000000344010723cULL, 0x000b6e0000001810ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x000054104f347816ULL, 0x020fe40000000055ULL,
0x000054104a357816ULL, 0x000fc4000000004eULL, 0x000054103d3c7816ULL, 0x008fc6000000003cULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541078777816ULL, 0x002fe20000000053ULL,
0x00000034400c723cULL, 0x040b6c000000180cULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000054107b7b7816ULL, 0x004fe20000000052ULL, 0x000000764018723cULL, 0x040b6c0000001818ULL,
0x0000004900497306ULL, 0x000e640000200c00ULL, 0x0000007a4014723cULL, 0x000b6c0000001814ULL,
0x0000003600367306ULL, 0x000eb00000200c00ULL, 0x0000003700377306ULL, 0x000ee20000200c00ULL,
0x000054104b347816ULL, 0x022fc40000000049ULL, 0x0000541036357816ULL, 0x004fce000000004dULL,
0x000000344008723cULL, 0x000b620000001808ULL, 0x00005410373d7816ULL, 0x008fce000000004cULL,
0x0000003c4004723cULL, 0x000b620000001804ULL, 0xfffff03000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff347224ULL, 0x020fe200078e0031ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe0b000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000002c16357220ULL, 0x080fe20000410000ULL,
0x0000002c1a337220ULL, 0x080fe20000410000ULL, 0x0000002c17367220ULL, 0x080fe20000410000ULL,
0x0000002c10167220ULL, 0x080fe20000410000ULL, 0x0000002c18187220ULL, 0x080fe20000410000ULL,
0x0000002c19197220ULL, 0x080fe20000410000ULL, 0x0000002c1b347220ULL, 0x080fe20000410000ULL,
0x0000002c11177220ULL, 0x080fe20000410000ULL, 0x0000002c0c1a7220ULL, 0x080fe20000410000ULL,
0x0000002c20207220ULL, 0x080fe20000410000ULL, 0x0000002c21217220ULL, 0x080fe20000410000ULL,
0x0000002c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002c14147220ULL, 0x080fe20000410000ULL, 0x0000002c15157220ULL, 0x080fe20000410000ULL,
0x0000002c0d1b7220ULL, 0x080fe20000410000ULL, 0x0000002c08087220ULL, 0x080fe20000410000ULL,
0x0000002c09097220ULL, 0x080fe20000410000ULL, 0x0000002c04047220ULL, 0x080fe20000410000ULL,
0x0000002c12377220ULL, 0x080fe20000410000ULL, 0x0000002c13387220ULL, 0x080fe20000410000ULL,
0x0000002c0e397220ULL, 0x080fe20000410000ULL, 0x0000002c0f3a7220ULL, 0x080fe20000410000ULL,
0x000000ffff127224ULL, 0x000fe200078e0016ULL, 0x0000002c0a3b7220ULL, 0x080fe20000410000ULL,
0x0000002c0b3c7220ULL, 0x080fe20000410000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0018ULL,
0x0000002c22227220ULL, 0x080fe20000410000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0019ULL,
0x0000002c23237220ULL, 0x080fe20000410000ULL, 0x000000ffff137224ULL, 0x000fe200078e0017ULL,
0x0000002c1e1e7220ULL, 0x080fe20000410000ULL, 0x000000ffff167224ULL, 0x000fe200078e001aULL,
0x0000002c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002c05057220ULL, 0x080fe20000410000ULL,
0x0000002c06067220ULL, 0x080fe20000410000ULL, 0x0000002c07077220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0020ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0021ULL,
0x000000ffff0c7224ULL, 0x000fe400078e001cULL, 0x000000ffff0d7224ULL, 0x000fe400078e001dULL,
0x000000ffff107224ULL, 0x000fe400078e0014ULL, 0x000000ffff117224ULL, 0x000fe400078e0015ULL,
0x000000ffff177224ULL, 0x000fc400078e001bULL, 0x000000ffff187224ULL, 0x000fe400078e0008ULL,
0x000000ffff197224ULL, 0x000fe400078e0009ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002d087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0022ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0023ULL,
0x000000ffff207224ULL, 0x000fc400078e0033ULL, 0x000000ffff217224ULL, 0x000fe400078e0034ULL,
0x000000ffff227224ULL, 0x000fe400078e0035ULL, 0x000000ffff237224ULL, 0x000fe400078e0036ULL,
0x000000ffff337224ULL, 0x000fe400078e0037ULL, 0x000000ffff347224ULL, 0x000fe400078e0038ULL,
0x000000ffff357224ULL, 0x000fc400078e0039ULL, 0x000000ffff367224ULL, 0x000fe400078e003aULL,
0x000000ffff1b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff377224ULL, 0x000fe400078e003bULL,
0x000000ffff387224ULL, 0x000fe400078e003cULL, 0x000000ffff397224ULL, 0x000fe400078e0006ULL,
0x000000ffff3a7224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004002d067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604147210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001406067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000115157810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004002d067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000403157824ULL, 0x000fe200078e00ffULL, 0x0000002e3000720cULL, 0x000fc80003f05270ULL,
0xfffffff015147812ULL, 0x000fca00078ec0ffULL, 0x0000008002147824ULL, 0x000fca00078e0214ULL,
0x0104000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000203087824ULL, 0x000fe400078e00ffULL, 0x0000000124327824ULL, 0x000fc600078e0a32ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108097812ULL, 0x040fe400078efcffULL,
0x00000008083b7812ULL, 0x040fe400078efcffULL, 0x000000320900720cULL, 0x080fe40003f26070ULL,
0x0000001008097812ULL, 0x000fe400078efcffULL, 0x000000323b00720cULL, 0x080fe40003f06070ULL,
0x000000320900720cULL, 0x000fc40003fc6070ULL, 0x00000011083b7812ULL, 0x040fe400078efcffULL,
0x0000001808097812ULL, 0x040fe400078efcffULL, 0x000000320800720cULL, 0x0c0fe40003f46070ULL,
0x000000323b00720cULL, 0x080fe40003fa6070ULL, 0x000000320900720cULL, 0x000fe40003f66070ULL,
0x00000009083c7812ULL, 0x000fc400078efcffULL, 0x00000019083b7812ULL, 0x040fe400078efcffULL,
0x0000002008097812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000a0a7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000b0b7808ULL, 0x000fc40004800000ULL, 0x000000323c00720cULL, 0x080fe40003f86070ULL,
0x000000323b00720cULL, 0x080fe40003f46070ULL, 0x000000320900720cULL, 0x000fe40003f26070ULL,
0x00000021083b7812ULL, 0x040fe400078efcffULL, 0x0000002808097812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000323b00720cULL, 0x080fe40003f06070ULL, 0x000000320900720cULL, 0x000fe40003f86070ULL,
0x00000029083b7812ULL, 0x000fc400078efcffULL, 0x0000003008097812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000323b00720cULL, 0x000fc40003fc6070ULL, 0x000000320900720cULL, 0x000fe40003fa6070ULL,
0x00000031083b7812ULL, 0x040fe400078efcffULL, 0x0000003808097812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000033337808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000323b00720cULL, 0x080fe40003f66070ULL,
0x000000320900720cULL, 0x000fc40003f46070ULL, 0x000000320800720cULL, 0x000fe40003f26070ULL,
0xff80000034347808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000035357808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000036367808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000037377808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff80000038387808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff80000039397808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000003a3a7808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000a0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff3d7424ULL, 0x000fe200078e00ffULL,
0x0000001c0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x000000040a047208ULL, 0x000fe40004000000ULL, 0x000000051c057208ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x000fe40003f1e000ULL, 0x0000001d0500720bULL, 0x000fe40003f3e000ULL,
0x000000040b047208ULL, 0x000fe40004000000ULL, 0x000000051d057208ULL, 0x000fe40004800000ULL,
0x0000000c0400720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000040c047208ULL, 0x000fe40004000000ULL, 0x000000051e057208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0500720bULL, 0x000fe40003f3e000ULL,
0x000000040d047208ULL, 0x000fe40004000000ULL, 0x000000051f057208ULL, 0x000fc40004800000ULL,
0x0000000e0400720bULL, 0x000fe40003f1e000ULL, 0x000000200500720bULL, 0x000fe40003f3e000ULL,
0x000000040e047208ULL, 0x000fe40004000000ULL, 0x0000000520057208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210500720bULL, 0x000fc40003f3e000ULL,
0x000000040f047208ULL, 0x000fe40004000000ULL, 0x0000000521057208ULL, 0x000fe40004800000ULL,
0x000000100400720bULL, 0x000fe40003f1e000ULL, 0x000000220500720bULL, 0x000fe40003f3e000ULL,
0x0000000410047208ULL, 0x000fe40004000000ULL, 0x0000000522057208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230500720bULL, 0x000fe40003f3e000ULL,
0x0000000411047208ULL, 0x000fe40004000000ULL, 0x0000000523057208ULL, 0x000fe40004800000ULL,
0x000000120400720bULL, 0x000fe40003f1e000ULL, 0x000000330500720bULL, 0x000fc40003f3e000ULL,
0x0000000412047208ULL, 0x000fe40004000000ULL, 0x0000000533057208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000340500720bULL, 0x000fe40003f3e000ULL,
0x0000000413047208ULL, 0x000fe40004000000ULL, 0x0000000534057208ULL, 0x000fc40004800000ULL,
0x000000160400720bULL, 0x000fe40003f1e000ULL, 0x000000350500720bULL, 0x000fe40003f3e000ULL,
0x0000000416047208ULL, 0x000fe40004000000ULL, 0x0000000535057208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000360500720bULL, 0x000fc40003f3e000ULL,
0x0000000417047208ULL, 0x000fe40004000000ULL, 0x0000000536057208ULL, 0x000fe40004800000ULL,
0x000000180400720bULL, 0x000fe40003f1e000ULL, 0x000000370500720bULL, 0x000fe40003f3e000ULL,
0x0000000418047208ULL, 0x000fe40004000000ULL, 0x0000000537057208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x000000380500720bULL, 0x000fe40003f3e000ULL,
0x0000000419047208ULL, 0x000fe40004000000ULL, 0x0000000538057208ULL, 0x000fe40004800000ULL,
0x0000001a0400720bULL, 0x000fe40003f1e000ULL, 0x000000390500720bULL, 0x000fc40003f3e000ULL,
0x000000041a047208ULL, 0x000fe40004000000ULL, 0x0000000539057208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000003a0500720bULL, 0x000fe40003f3e000ULL,
0x000000041b3c7208ULL, 0x000fe40004000000ULL, 0x000000053a057208ULL, 0x000fe20004800000ULL,
0x000017e27f007947ULL, 0x000fec000b800000ULL, 0x0c401f003c047f89ULL, 0x0004e400000e0000ULL,
0x000000043c00720bULL, 0x008fc80003f1e000ULL, 0x0000003c043c7208ULL, 0x004fe20004000000ULL,
0x000018027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006087f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007097f89ULL, 0x000e6200000e0000ULL,
0x000000040500720bULL, 0x004fc40003f1e000ULL, 0x000000080600720bULL, 0x008fe40003f3e000ULL,
0x0000000504057208ULL, 0x000fe40004000000ULL, 0x0000000608067208ULL, 0x000fe20004800000ULL,
0x0c201f003c047f89ULL, 0x000ea200000e0000ULL, 0x000000090700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0005087f89ULL, 0x000e6200000e0000ULL, 0x0000000709077208ULL, 0x000fc60004000000ULL,
0x0c201f0006327f89ULL, 0x000ee800000e0000ULL, 0x0c201f00073b7f89ULL, 0x0002e200000e0000ULL,
0x000000043c00720bULL, 0x004fe40003f1e000ULL, 0x000000080500720bULL, 0x002fe40003f3e000ULL,
0x0000003c04047208ULL, 0x000fe40004000000ULL, 0x000000320600720bULL, 0x008fc40003f5e000ULL,
0x0000000508057208ULL, 0x000fe40004800000ULL, 0x0000000632067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL, 0x3c003c00ff447424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3c003c00ff457424ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010808ULL,
0x00000018003f7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010808ULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b05187820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b19197823ULL, 0x000fe20000010808ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010818ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fe20000010818ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b1b087823ULL, 0x000fe20000010808ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010818ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010818ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010818ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010818ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010818ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010818ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b3a3a7823ULL, 0x000fe20000010818ULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x0000000c15157812ULL, 0x000fc400078ec0ffULL, 0x0000000303ff7812ULL, 0x000fe4000780c0ffULL,
0x0000003b0700720bULL, 0x004fc60003f3e000ULL, 0x0000001c00097308ULL, 0x000fe20000000800ULL,
0x000000073b077208ULL, 0x000fce0004800000ULL, 0x0000001d001d7308ULL, 0x000e700000000800ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x000000091d09723eULL, 0x002fce00000000ffULL, 0x0000000800427308ULL, 0x0003f00000000800ULL,
0x0000001000327308ULL, 0x000fe20000000800ULL, 0x0000000a0b08723eULL, 0x002fe400000000ffULL,
0x0000000c0d0a723eULL, 0x000fc400000000ffULL, 0x0000001e1f0b723eULL, 0x004fc600000000ffULL,
0x00000011003c7308ULL, 0x000ff00000000800ULL, 0x00000012003d7308ULL, 0x000ff00000000800ULL,
0x00000013003e7308ULL, 0x0003f00000000800ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000440810723cULL, 0x002f6e00000018ffULL, 0x0000000f000f7308ULL, 0x000e700000000800ULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fc400000000ffULL, 0x000000323c0e723eULL, 0x000fe400000000ffULL,
0x00000002ff3c7819ULL, 0x000fc60000011603ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x000000013c1c7810ULL, 0x040fe40007ffe0ffULL, 0x000000023c1d7810ULL, 0x040fe40007ffe0ffULL,
0x000000063c327810ULL, 0x000fc60007ffe0ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x00000020210d723eULL, 0x004fe200000000ffULL, 0x000000083c207824ULL, 0x040fe400078e00ffULL,
0x000000083c217824ULL, 0x000fc600078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee21cULL,
0x0000001900407308ULL, 0x000fe20000000800ULL, 0xfffffff821217812ULL, 0x000fe400078ee21dULL,
0x00000022230f723eULL, 0x002fca00000000ffULL, 0x0000001a00417308ULL, 0x0003e20000000800ULL,
0x000000083c227824ULL, 0x040fe400078e00ffULL, 0x000000083c237824ULL, 0x000fca00078e00ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000440c18723cULL, 0x022b6e0000001810ULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000033c107810ULL, 0x060fe40007ffe0ffULL,
0x000000043c117810ULL, 0x000fc40007ffe0ffULL, 0xfffffff822227812ULL, 0x000fe400078ee210ULL,
0xfffffff823237812ULL, 0x000fe200078ee211ULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x0000003d3e10723eULL, 0x000fce00000000ffULL, 0x0000003400347308ULL, 0x000ea20000000800ULL,
0x000000161712723eULL, 0x002fe200000000ffULL, 0x000000083c167824ULL, 0x040fe200078e00ffULL,
0x000000053c177810ULL, 0x000fc80007ffe0ffULL, 0xfffffff816167812ULL, 0x000fe200078ee23cULL,
0x0000003500357308ULL, 0x000ff00000000800ULL, 0x0000003600367308ULL, 0x000e620000000800ULL,
0x000000333411723eULL, 0x004fc400000000ffULL, 0x000000083c347810ULL, 0x040fe40007ffe0ffULL,
0xffffffff3c337810ULL, 0x000fc60007ffe0ffULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x000000353613723eULL, 0x002fce00000000ffULL, 0x0000003800387308ULL, 0x000e620000000800ULL,
0x000000083c357824ULL, 0x040fe400078e00ffULL, 0x000000083c367824ULL, 0x040fe400078e00ffULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x00000044101c723cULL, 0x000b620000001818ULL,
0xfffffff835177812ULL, 0x000fe200078ee217ULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x0000a00002357811ULL, 0x000fe400078e58ffULL, 0xfffffff836327812ULL, 0x000fc400078ee232ULL,
0x0000000834187824ULL, 0x020fe200078e00ffULL, 0x00000041421a723eULL, 0x000fe200000000ffULL,
0x0000001016167824ULL, 0x100fe200078e0235ULL, 0x0000003a003a7308ULL, 0x000ea20000000800ULL,
0x000000373819723eULL, 0x002fe200000000ffULL, 0x0000001020207824ULL, 0x100fe200078e0235ULL,
0xfffffff818347812ULL, 0x000fe200078ee234ULL, 0x0000001021217824ULL, 0x100fe200078e0235ULL,
0x0000003f4018723eULL, 0x000fe200000000ffULL, 0x0000001022227824ULL, 0x000fe200078e0235ULL,
0xfffffff83c337812ULL, 0x000fe200078ee233ULL, 0x0000001023237824ULL, 0x000fc400078e0235ULL,
0x0000000116167824ULL, 0x000fe400078e0215ULL, 0x0000001017177824ULL, 0x100fe400078e0235ULL,
0x0000000115207824ULL, 0x040fe200078e0220ULL, 0x0000000816007388ULL, 0x0003e20000000800ULL,
0x000000393a1b723eULL, 0x004fe200000000ffULL, 0x0000001032327824ULL, 0x000fe400078e0235ULL,
0x0000000115217824ULL, 0x000fe200078e0221ULL, 0x0000000a20007388ULL, 0x0003e20000000800ULL,
0x0000001033337824ULL, 0x000fc400078e0235ULL, 0x00000044181c723cULL, 0x000f62000000181cULL,
0x0000000115227824ULL, 0x040fe200078e0222ULL, 0x0000000c21007388ULL, 0x0003e20000000800ULL,
0x0000001034347824ULL, 0x000fe400078e0235ULL, 0x0000000115237824ULL, 0x040fe200078e0223ULL,
0x0000000e22007388ULL, 0x0003e20000000800ULL, 0x0000000115177824ULL, 0x040fe400078e0217ULL,
0x0000000115327824ULL, 0x040fe200078e0232ULL, 0x0000001023007388ULL, 0x0003e20000000800ULL,
0x0000000115337824ULL, 0x000fc400078e0233ULL, 0x0000000115347824ULL, 0x000fe200078e0234ULL,
0x0000001217007388ULL, 0x0003e80000000800ULL, 0x0000001832007388ULL, 0x0003e80000000800ULL,
0x0000001a33007388ULL, 0x0003e40000000800ULL, 0x000000ffff1d7224ULL, 0x020fc400078e001eULL,
0x0000000934007388ULL, 0x0003e80000000800ULL, 0x0004000b20007388ULL, 0x0003e80000000800ULL,
0x0004000d21007388ULL, 0x0003e80000000800ULL, 0x0004000f22007388ULL, 0x0003e80000000800ULL,
0x0004001123007388ULL, 0x0003e80000000800ULL, 0x0004001317007388ULL, 0x0003e80000000800ULL,
0x0004001932007388ULL, 0x0003e80000000800ULL, 0x0004001b33007388ULL, 0x0003e80000000800ULL,
0x0100000414008388ULL, 0x0003e80000000c00ULL, 0x0102001c14008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002fff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002fff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000130307810ULL, 0x000fe20007ffe0ffULL,
0x000018002fff7f8cULL, 0x0003e6000c80043fULL, 0x000000263000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc31000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff477807ULL, 0x008fe40004000000ULL,
0x0001808000487802ULL, 0x000fc40000000f00ULL, 0x00000f8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff317224ULL, 0x000fe200078e0047ULL, 0xfffe9fd000007947ULL, 0x000fea000383ffffULL,
0x00000001ff477807ULL, 0x000fe40005000000ULL, 0x000180d000487802ULL, 0x000fc40000000f00ULL,
0x00000f3000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff387224ULL, 0x000fe200078e0047ULL,
0xfffea03000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x004fe200078e0039ULL,
0x0001812000487802ULL, 0x000fc40000000f00ULL, 0x00000ea000007944ULL, 0x002fea0003c00000ULL,
0xfffea0e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0039ULL,
0x0001816000487802ULL, 0x000fc40000000f00ULL, 0x00000e6000007944ULL, 0x002fea0003c00000ULL,
0xfffea21000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0036ULL,
0x000181b000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0037ULL,
0x00000e1000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e0047ULL,
0xfffea60000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0035ULL,
0x0001821000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0036ULL,
0x00000db000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xfffea5d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0004ULL,
0x0001827000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0005ULL,
0x00000d5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e0047ULL,
0xfffec43000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0035ULL,
0x000182d000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0004ULL,
0x00000cf000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xfffec40000007947ULL, 0x000fea000383ffffULL, 0x00000001ff477807ULL, 0x008fe40004000000ULL,
0x0001832000487802ULL, 0x000fc40000000f00ULL, 0x00000ce000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e0047ULL, 0xfffee2d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff477807ULL, 0x000fe40005000000ULL, 0x0001837000487802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff467224ULL, 0x000fe200078e0047ULL,
0xfffee31000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e004cULL,
0x000183c000487802ULL, 0x000fc40000000f00ULL, 0x00000c0000007944ULL, 0x014fea0003c00000ULL,
0xfffee3e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e004cULL,
0x0001840000487802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x016fea0003c00000ULL,
0xfffee50000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0044ULL,
0x0001845000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0045ULL,
0x00000b7000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e0047ULL,
0xfffee93000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0035ULL,
0x000184b000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0044ULL,
0x00000b1000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xfffee90000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0004ULL,
0x0001851000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0005ULL,
0x00000ab000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e0047ULL,
0xffff057000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0035ULL,
0x0001857000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0004ULL,
0x00000a5000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xffff054000007947ULL, 0x000fea000383ffffULL, 0x00000001ff477807ULL, 0x002fe40004000000ULL,
0x000185c000487802ULL, 0x000fc40000000f00ULL, 0x00000a4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e0047ULL, 0xffff22a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff477807ULL, 0x000fe40005000000ULL, 0x0001861000487802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0047ULL,
0xffff22d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e004dULL,
0x0001866000487802ULL, 0x000fc40000000f00ULL, 0x0000096000007944ULL, 0x004fea0003c00000ULL,
0xffff23a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e004dULL,
0x000186a000487802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x006fea0003c00000ULL,
0xffff24c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e002cULL,
0x000186f000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0044ULL,
0x000008d000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e0047ULL,
0xffff28d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0035ULL,
0x0001875000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e002cULL,
0x0000087000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xffff28a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0020ULL,
0x000187b000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0021ULL,
0x0000081000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e0047ULL,
0xffff451000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0035ULL,
0x0001881000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0020ULL,
0x000007b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xffff44e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff477807ULL, 0x008fe40004000000ULL,
0x0001886000487802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0047ULL, 0xffff62b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff477807ULL, 0x000fe40004800000ULL, 0x000188b000487802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e0047ULL,
0xffff62e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e002fULL,
0x0001891000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e004bULL,
0x000006b000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0047ULL,
0xffff639000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e004bULL,
0x0001897000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e002fULL,
0x0000065000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0047ULL,
0xffff649000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e002cULL,
0x000189d000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e002fULL,
0x000005f000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e0047ULL,
0xffff68a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0035ULL,
0x00018a3000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e002cULL,
0x0000059000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xffff687000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e002cULL,
0x00018a9000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e002eULL,
0x0000053000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e0047ULL,
0xffff84d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0035ULL,
0x00018af000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e002cULL,
0x000004d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xffff84a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e003cULL,
0x00018b5000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fc400078e00ffULL,
0x0000042000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e003bULL,
0xffffe7d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x00018bb000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fc400078e00ffULL,
0x000003c000007944ULL, 0x012fea0003c00000ULL, 0x0000003b0500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0006ULL, 0x00018c1000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0x000000053b057208ULL, 0x000fc80004000000ULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x0000003b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x00018c7000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0x000000063b067208ULL, 0x000fc80004000000ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x0000003b0700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e003cULL, 0x00018cd000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000073b077208ULL, 0x000fc80004000000ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x0000003b3c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x00018d3000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000003c3b047208ULL, 0x000fc80004000000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x0000003b0500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0006ULL, 0x00018d9000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000053b057208ULL, 0x000fc80004000000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x0000003b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x00018df000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000063b067208ULL, 0x000fc80004000000ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffe6a000007947ULL, 0x000fea000383ffffULL,
0x0180000003007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000300008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000003037812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000005ff7212ULL, 0x000fda000780c0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000300007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe709004007950ULL, 0x000fea0003c3ffffULL, 0x0000003e00007348ULL, 0x000fe80003800000ULL,
0x0c000009083b7389ULL, 0x0002a400000e003dULL, 0x000000ffff087224ULL, 0x002fe400078e0032ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe704008007950ULL, 0x000fea0003c3ffffULL,
0x0000003200007348ULL, 0x000fe80003800000ULL, 0x0000004749477389ULL, 0x0002a400000e0031ULL,
0x00000000ff497424ULL, 0x002fc800078e00ffULL, 0xfffe700048007950ULL, 0x000fea0003c3ffffULL,
0x000000014700780cULL, 0x000fe20003f45070ULL, 0x00000000ff497424ULL, 0x000fe200078e00ffULL,
0x0000003000007348ULL, 0x000ff60003800000ULL, 0x0000000000477806ULL, 0x000fc800050e0100ULL,
0x0000003047477212ULL, 0x000fe200078ec0ffULL, 0xfffe6fa048007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000548ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f10ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000fd0ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000019d8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000019e8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001a78ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001a7cULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001c80ULL, 0x0000000000019100ULL, 0x8d00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001ad80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001add0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b150ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001a78ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019308ULL, 0x0000000000019308ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001ad80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b150ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 111152;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
