/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001cf50ULL, 0x000000000001cbd0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x000000000001adb0ULL, 0x0000000000000190ULL,
0x000b0022000004bdULL, 0x000000000001af40ULL, 0x0000000000000050ULL, 0x000b0022000004e8ULL,
0x000000000001af90ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x000000000001afd0ULL,
0x0000000000000130ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000001b100ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001adb000000000ULL, 0x0000040400000000ULL,
0x810c000001580400ULL, 0x006a080400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x9208288080840828ULL, 0x2880809408288080ULL, 0x8096082880809508ULL,
0x08288080bc082880ULL, 0x8080c208288080c1ULL, 0xc608288080c30828ULL, 0x288080d908288080ULL,
0x808508288080da08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080859200ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001adb000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880808c08288080ULL,
0x8094082880809208ULL, 0x0828808095082880ULL, 0x8080bc0828808096ULL, 0xc208288080c10828ULL,
0x288080c308288080ULL, 0x80d908288080c608ULL, 0x08288080da082880ULL, 0x80828016288080b1ULL,
0x0000000000031028ULL, 0x288080b192000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x0000013800000000ULL, 0x0001af4000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x808c288080b10900ULL, 0x0000000000002880ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8508288080840828ULL, 0x2880809208288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL,
0x8080c108288080bcULL, 0xc608288080c30828ULL, 0x288080d908288080ULL, 0x80c208288080da08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080c29200ULL, 0x0000001cffffffffULL,
0x0000020800000000ULL, 0x0001af9000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880809208288080ULL,
0x8095082880809408ULL, 0x0828808096082880ULL, 0x8080c108288080bcULL, 0xc608288080c20828ULL,
0x288080d908288080ULL, 0x80c308288080da08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080c39200ULL, 0x0000002cffffffffULL, 0x000002b800000000ULL, 0x0001afd000000000ULL,
0x0000013000000000ULL, 0x0000140400000000ULL, 0x80c2288080c30900ULL, 0x0000000000002880ULL,
0x0000001a00082f04ULL, 0x0008230400000086ULL, 0x0000000000000016ULL, 0x0000001600081204ULL,
0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL,
0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0050016000000017ULL, 0x000c170400501903ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01982904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01982804ffffffffULL, 0x00000100000000e0ULL,
0x000020e000000460ULL, 0x0000226000002170ULL, 0x00002820000023d0ULL, 0x000028b000002850ULL,
0x0000474000002910ULL, 0x000047d000004770ULL, 0x000066d000004830ULL, 0x0000687000006760ULL,
0x00006e60000069d0ULL, 0x00006ef000006e90ULL, 0x00008b6000006f50ULL, 0x00008bf000008b90ULL,
0x0000a9f000008c50ULL, 0x0000ab800000aa70ULL, 0x0000b1500000ace0ULL, 0x0000b1e00000b180ULL,
0x0000ce500000b240ULL, 0x0000cee00000ce80ULL, 0x0000ece00000cf40ULL, 0x0000ee700000ed60ULL,
0x0000f4400000efd0ULL, 0x0000f4e00000f470ULL, 0x000111800000f550ULL, 0x00011220000111b0ULL,
0x0001239000011290ULL, 0x00012b70000123a0ULL, 0x00018f3000018ef0ULL, 0x00018f5000018f40ULL,
0x00018fc000018fa0ULL, 0x00018ff000018fe0ULL, 0x00019ca000019c40ULL, 0x00019d8000019d10ULL,
0x00019e6000019df0ULL, 0x00019f4000019ed0ULL, 0x0001a00000019fa0ULL, 0x0001a0e00001a070ULL,
0x0001a1c00001a150ULL, 0x0001a2a00001a230ULL, 0x0001a3600001a300ULL, 0x0001a4400001a3d0ULL,
0x0001a5200001a4b0ULL, 0x0001a6000001a590ULL, 0x0001a6c00001a660ULL, 0x0001a7900001a720ULL,
0x0001a8900001a810ULL, 0x0001a9900001a910ULL, 0x0001aa900001aa10ULL, 0x0001ab900001ab10ULL,
0x0001ac900001ac10ULL, 0x0001ad900001ad10ULL, 0x000001c006003904ULL, 0x00018600000000ffULL,
0x000001f0003f0100ULL, 0x000186080000000dULL, 0x000002a0003f0120ULL, 0x000186880000000dULL,
0x00000430003f0120ULL, 0x000186a80000000dULL, 0x00000450003f0120ULL, 0x000186b8000000ffULL,
0x000004e0003f0100ULL, 0x00018600000000ffULL, 0x00000630003f0107ULL, 0x0001868c00000007ULL,
0x00000690003f0102ULL, 0x0001868800000007ULL, 0x00000ef0003f0101ULL, 0x000186a8000000ffULL,
0x00001010003f0107ULL, 0x000186a8000000ffULL, 0x00001070003f0101ULL, 0x000186b8000000ffULL,
0x00001200003f0101ULL, 0x000186bc000000ffULL, 0x000013d0003f0105ULL, 0x000186bc000000ffULL,
0x00001c90003f0105ULL, 0x000186b0000000ffULL, 0x00001db0003f0107ULL, 0x000186b0000000ffULL,
0x00001e10003f0101ULL, 0x0001860800000007ULL, 0x00001e30003f0101ULL, 0x0001860c00000007ULL,
0x00002000003f0105ULL, 0x0001860c00000007ULL, 0x00002580003f0105ULL, 0x000186ac000000ffULL,
0x00002750003f0105ULL, 0x000186ac000000ffULL, 0x000039d0003f0105ULL, 0x000186b8000000ffULL,
0x00003a00003f0101ULL, 0x000186bc000000ffULL, 0x00003bc0003f0105ULL, 0x000186bc000000ffULL,
0x00004410003f0105ULL, 0x000186a8000000ffULL, 0x00004490003f0107ULL, 0x000186a8000000ffULL,
0x000044c0003f0101ULL, 0x000186b4000000ffULL, 0x00004690003f0105ULL, 0x000186b4000000ffULL,
0x00005800003f0105ULL, 0x000186b8000000ffULL, 0x00005870003f0101ULL, 0x00018688000000ffULL,
0x000058d0003f0101ULL, 0x000186bc000000ffULL, 0x00005aa0003f0105ULL, 0x000186bc000000ffULL,
0x000062f0003f0105ULL, 0x000186b0000000ffULL, 0x000063f0003f0107ULL, 0x000186b0000000ffULL,
0x00006450003f0101ULL, 0x0001862800000007ULL, 0x00006470003f0101ULL, 0x0001862c00000007ULL,
0x00006640003f0105ULL, 0x0001862c00000007ULL, 0x00006bc0003f0105ULL, 0x000186ac000000ffULL,
0x00006d90003f0105ULL, 0x000186ac000000ffULL, 0x00007df0003f0105ULL, 0x000186b8000000ffULL,
0x00007e20003f0101ULL, 0x000186bc000000ffULL, 0x00007fe0003f0105ULL, 0x000186bc000000ffULL,
0x00008830003f0105ULL, 0x000186a8000000ffULL, 0x000088b0003f0107ULL, 0x000186a8000000ffULL,
0x000088e0003f0101ULL, 0x000186b4000000ffULL, 0x00008ab0003f0105ULL, 0x000186b4000000ffULL,
0x00009b20003f0105ULL, 0x000186b8000000ffULL, 0x00009b90003f0101ULL, 0x00018690000000ffULL,
0x00009bf0003f0101ULL, 0x000186bc000000ffULL, 0x00009dc0003f0105ULL, 0x000186bc000000ffULL,
0x0000a610003f0105ULL, 0x000186b0000000ffULL, 0x0000a710003f0107ULL, 0x000186b0000000ffULL,
0x0000a770003f0101ULL, 0x0001864800000007ULL, 0x0000a790003f0101ULL, 0x0001864c00000007ULL,
0x0000a960003f0105ULL, 0x0001864c00000007ULL, 0x0000aeb0003f0105ULL, 0x000186ac000000ffULL,
0x0000b080003f0105ULL, 0x000186ac000000ffULL, 0x0000c0e0003f0105ULL, 0x000186b8000000ffULL,
0x0000c110003f0101ULL, 0x000186bc000000ffULL, 0x0000c2d0003f0105ULL, 0x000186bc000000ffULL,
0x0000cb20003f0105ULL, 0x000186a8000000ffULL, 0x0000cba0003f0107ULL, 0x000186a8000000ffULL,
0x0000cbd0003f0101ULL, 0x000186b4000000ffULL, 0x0000cda0003f0105ULL, 0x000186b4000000ffULL,
0x0000de10003f0105ULL, 0x000186b8000000ffULL, 0x0000de80003f0101ULL, 0x00018698000000ffULL,
0x0000dee0003f0101ULL, 0x000186bc000000ffULL, 0x0000e0b0003f0105ULL, 0x000186bc000000ffULL,
0x0000e900003f0105ULL, 0x000186b0000000ffULL, 0x0000ea00003f0107ULL, 0x000186b0000000ffULL,
0x0000ea60003f0101ULL, 0x0001866800000007ULL, 0x0000ea80003f0101ULL, 0x0001866c00000007ULL,
0x0000ec50003f0105ULL, 0x0001866c00000007ULL, 0x0000f1a0003f0105ULL, 0x000186ac000000ffULL,
0x0000f370003f0105ULL, 0x000186ac000000ffULL, 0x000103f0003f0105ULL, 0x000186b8000000ffULL,
0x00010420003f0101ULL, 0x000186bc000000ffULL, 0x000105e0003f0105ULL, 0x000186bc000000ffULL,
0x00010e50003f0105ULL, 0x000186a8000000ffULL, 0x00010ed0003f0107ULL, 0x000186a8000000ffULL,
0x00010f00003f0101ULL, 0x000186b4000000ffULL, 0x000110d0003f0105ULL, 0x000186b4000000ffULL,
0x00012150003f0105ULL, 0x000186b8000000ffULL, 0x000121b0003f0101ULL, 0x000186a0000000ffULL,
0x00012dd0003f0101ULL, 0x00018600000000ffULL, 0x000149f0003f0101ULL, 0x00018604000000ffULL,
0x00014bc0003f0105ULL, 0x00018604000000ffULL, 0x00014f30003f0105ULL, 0x00018600000000ffULL,
0x00014f60003f0101ULL, 0x00018604000000ffULL, 0x00015120003f0105ULL, 0x00018604000000ffULL,
0x00018330003f0105ULL, 0x000000000000002bULL, 0x00018440003f0101ULL, 0x000000040000002bULL,
0x00018610003f0105ULL, 0x000000040000002bULL, 0x00019a90003f0105ULL, 0x000000000000002dULL,
0x00019af0003f0101ULL, 0x000000080000002dULL, 0x00019b50003f0101ULL, 0x000000100000002dULL,
0x00019bc0003f0101ULL, 0x000000180000002dULL, 0x00053803003f0101ULL, 0x00012cb000101c04ULL,
0x0001524000015180ULL, 0x0000040100019c00ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000354ULL,
0x0000001a00000002ULL, 0x00000000000002a4ULL, 0x0000001a00000002ULL, 0x00000000000001e4ULL,
0x0000001a00000002ULL, 0x000000000000010cULL, 0x0000001a00000002ULL, 0x0000000000000044ULL,
0x0000001a00000002ULL, 0x0000000000000331ULL, 0x0000001a00000002ULL, 0x0000000000000281ULL,
0x0000001a00000002ULL, 0x00000000000001bbULL, 0x0000001a00000002ULL, 0x00000000000000e9ULL,
0x0000001a00000002ULL, 0x0000000000018700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00000000000b7919ULL, 0x000ea20000002300ULL, 0x0000000e00097300ULL, 0x000ee200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000027919ULL, 0x000ea20000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000037919ULL, 0x000f220000002600ULL,
0x0000000e00147309ULL, 0x0002a60000000000ULL, 0x00000000000a7919ULL, 0x000ee80000002700ULL,
0x00000000000c7919ULL, 0x000ee20000000000ULL, 0x00000005ff007819ULL, 0x002fcc000001160dULL,
0x00001fff00007589ULL, 0x000fe200000e0000ULL, 0x000001000b027a24ULL, 0x004fc600078e0202ULL,
0x00001fff0b0b7589ULL, 0x000e6200000e0000ULL, 0x00000000020d7a24ULL, 0x000fc600078e020dULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x000000ff0d00720cULL, 0x040fe40003f25270ULL,
0x0000000f0d00780cULL, 0x040fe40003f44070ULL, 0x000000030d00780cULL, 0x040fe40003f64070ULL,
0x0000007f0d00780cULL, 0x000fe40003f84070ULL, 0x0000000c0900720cULL, 0x008fca0003f02070ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x01860004ff009388ULL, 0x0007e20000000a00ULL, 0x000000040b087824ULL, 0x002fe400078e0200ULL,
0xff317217ff09c424ULL, 0x000fe200078e00ffULL, 0x018608060d00a388ULL, 0x0009e20000008a00ULL,
0x0000000208087824ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f44070ULL,
0x00000010020c7824ULL, 0x004fe200078e00ffULL, 0x018400090d00c388ULL, 0x0003e20000004800ULL,
0x0000002008107824ULL, 0x000fc400078e00ffULL, 0x3fffff60ff04b424ULL, 0x008fe200078e00ffULL,
0x000001f00c127812ULL, 0x000fe200078ec0ffULL, 0x7fffff60ff05b424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0e9424ULL, 0x000fe400078e00ffULL, 0x0000000803067824ULL, 0x010fe200078e00ffULL,
0x018688040d00b388ULL, 0x0005e20000008a00ULL, 0x0000000108077824ULL, 0x000fe400078e0202ULL,
0x000000050a067c24ULL, 0x000fc4000f8e0206ULL, 0x7fffff00ff09a424ULL, 0x002fe200078e00ffULL,
0xffffffe010107812ULL, 0x000fe200078ee207ULL, 0x00000200ff077424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0f9424ULL, 0x000fe400078e00ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x0000000808047817ULL, 0x004fe20007800000ULL, 0x0000000106057824ULL, 0x000fc800078e0208ULL,
0x0000000104047824ULL, 0x000fe200078e0a08ULL, 0x0000000108087810ULL, 0x000fc80007ffe0ffULL,
0x000000ff0400720cULL, 0x000fe20003f63070ULL, 0x0000000106067824ULL, 0x000fe200078e0208ULL,
0x000000010400780cULL, 0x000fe20003f83070ULL, 0x00005c0005047625ULL, 0x000fc800078e0007ULL,
0x0000000108117824ULL, 0x000fe200078e0202ULL, 0x0000001204047210ULL, 0x000fe20007fbe0ffULL,
0x0000002008137824ULL, 0x000fe400078e00ffULL, 0x00005c0006067625ULL, 0x000fc600078e0007ULL,
0xffffffe013117812ULL, 0x000fe200078ee211ULL, 0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL,
0x0000001206067210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fe400028e0605ULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x0186a8080d00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff077224ULL, 0x000fc600030e0607ULL, 0x0186b80eff009388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004107faeULL, 0x0003e2000d901c46ULL, 0x000000ffff087224ULL, 0x000fc400078e0a14ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0x0000000006117faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x01860408ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01860000ff0079b0ULL, 0x000fe20008000a3fULL, 0x000062000a047625ULL, 0x000fc600078e0009ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000604047981ULL, 0x004ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000003f04057810ULL, 0x044fe40007ffe0ffULL,
0x000000ff040b7810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff057819ULL, 0x000fe40000011605ULL,
0x00000008ff067819ULL, 0x000fca000001160bULL, 0x000126e000008947ULL, 0x000fea0003800000ULL,
0x000001ff0b00780cULL, 0x000fe20003f24070ULL, 0x0000000800077824ULL, 0x000fe200078e00ffULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01868c0807ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186880007ff7f8cULL, 0x0005e2000c80043fULL,
0xffffffffff087424ULL, 0x002fe200078e00ffULL, 0x0000005000008947ULL, 0x000fea0003800000ULL,
0x000000020a087824ULL, 0x000fe400078e00ffULL, 0x00006400ff0b7624ULL, 0x000fc800078e00ffULL,
0x0000640008087624ULL, 0x000fc800078e020bULL, 0x0000600008087625ULL, 0x000fcc00078e0009ULL,
0x0000000608087981ULL, 0x000324000c1e1900ULL, 0x0000580008097a24ULL, 0x012fc800078e02ffULL,
0x0000004009147824ULL, 0x000fe200078e00ffULL, 0x0000043000001947ULL, 0x000fea0003800000ULL,
0x0000000704097217ULL, 0x000fe40007800000ULL, 0x00000004ff0b7819ULL, 0x000fe40000011602ULL,
0x000000f00c197812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe200078e0a07ULL,
0x000000020b0e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001070d7824ULL, 0x000fe200078e020bULL,
0x000000040b107810ULL, 0x040fe40007ffe0ffULL, 0x000000090b00720cULL, 0x080fe20003f06070ULL,
0x00000001070f7824ULL, 0x000fe200078e020eULL, 0x000000060b117810ULL, 0x000fe20007ffe0ffULL,
0x00000040030b7824ULL, 0x000fe200078e020dULL, 0x000000090e00720cULL, 0x080fe20003f26070ULL,
0x000000010d0e7824ULL, 0x140fe200078e0202ULL, 0x000000091000720cULL, 0x000fe20003f46070ULL,
0x000000100d157824ULL, 0x000fe200078e00ffULL, 0x0000000b141a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f0d7824ULL, 0x000fc400078e0202ULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x00005e001a127a11ULL, 0x000fe200078840ffULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x000000091100720cULL, 0x000fe20003f66070ULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000020b097810ULL, 0x000fe20007ffe0ffULL, 0x0000000107117824ULL, 0x000fe200078e0211ULL,
0xfffffff00f0f7812ULL, 0x000fe400078ee20dULL, 0x000000040b0d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000914187210ULL, 0x000fe20007fde0ffULL, 0x0000000110097824ULL, 0x000fe200078e0202ULL,
0xfffffff0150e7812ULL, 0x000fc400078ee20eULL, 0x00005f001a1a7a11ULL, 0x000fe400020f4413ULL,
0x0000000d14157210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x00005e0018177a11ULL, 0x040fe400078c40ffULL, 0x000000060b0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200020e06ffULL, 0x00005f0018187a11ULL, 0x000fe400030f440dULL,
0x0000000b14137210ULL, 0x000fe20007fbe0ffULL, 0x00000010100b7824ULL, 0x000fe200078e00ffULL,
0x00000012190c7210ULL, 0x000fc40007fde0ffULL, 0x000140000e0e7811ULL, 0x000fe200078e20ffULL,
0x000000ffff127224ULL, 0x000fe200028e06ffULL, 0xfffffff00b0b7812ULL, 0x000fe200078ee209ULL,
0x000000ffff0d7224ULL, 0x000fe200030e061aULL, 0x00005e0015147a11ULL, 0x000fe200078840ffULL,
0x0000000111097824ULL, 0x000fe200078e0202ULL, 0x00005e0013107a11ULL, 0x000fe200078a40ffULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0e7faeULL, 0x0003e2000c101c46ULL, 0x00005f0015157a11ULL, 0x000fe400020f4416ULL,
0x00005f0013137a11ULL, 0x000fc400028f4412ULL, 0xfffffff011117812ULL, 0x000fe400078ee209ULL,
0x0000001910107210ULL, 0x080fe40007fbe0ffULL, 0x000140000f097811ULL, 0x000fe400078e20ffULL,
0x000140000b0b7811ULL, 0x000fe400078e20ffULL, 0x00000019170c7210ULL, 0x082fe40007f1e0ffULL,
0x00000019140e7210ULL, 0x000fc40007f9e0ffULL, 0x0001400011127811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fe400000e0618ULL, 0x000000ffff0f7224ULL, 0x000fe400020e0615ULL,
0x000000ffff117224ULL, 0x000fe200028e0613ULL, 0x000000000c097faeULL, 0x0003e8000c901c46ULL,
0x000000000e0b7faeULL, 0x0003e8000d101c46ULL, 0x0000000010127faeULL, 0x0003e2000d901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000702097211ULL, 0x000fe400078fe0ffULL,
0x000000f00c1a7812ULL, 0x000fc400078ec0ffULL, 0x00000002090d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090b7824ULL, 0x140fe200078e0202ULL, 0x0000000609117810ULL, 0x040fe20007ffe0ffULL,
0x00000010090e7824ULL, 0x000fe400078e00ffULL, 0x000000010d0f7824ULL, 0x040fe400078e0202ULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff00e0e7812ULL, 0x000fe200078ee20bULL,
0x00000040030b7824ULL, 0x000fe400078e0209ULL, 0x0000001011177824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0f7812ULL, 0x000fc400078ee20fULL, 0x00000004090d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000b14197210ULL, 0x040fe40007f1e0ffULL, 0x000000020b097810ULL, 0x000fe20007ffe0ffULL,
0x000000100d157824ULL, 0x000fe200078e00ffULL, 0x000000040b107810ULL, 0x040fe40007ffe0ffULL,
0x000000060b127810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0b7824ULL, 0x100fe200078e0202ULL,
0x0000000914167210ULL, 0x040fe20007f3e0ffULL, 0x00000001110d7824ULL, 0x000fe200078e0202ULL,
0x0000001014117210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0019187a11ULL, 0x000fc400078040ffULL, 0x0000001214137210ULL, 0x000fe40007f7e0ffULL,
0xfffffff017147812ULL, 0x000fe200078ee20dULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x00005f0019197a11ULL, 0x000fe200000f4409ULL, 0x000000ffff097224ULL, 0x000fe200018e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078440ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005e0013127a11ULL, 0x000fe400078640ffULL, 0x000000181a0c7210ULL, 0x000fc40007f1e0ffULL,
0xfffffff0150b7812ULL, 0x000fe400078ee20bULL, 0x00005e0016157a11ULL, 0x000fe400078240ffULL,
0x00005f0011117a11ULL, 0x000fe200010f440dULL, 0x000000ffff0d7224ULL, 0x000fe200000e0619ULL,
0x00005f0013137a11ULL, 0x000fe400018f4409ULL, 0x000140000e097811ULL, 0x000fe400078e20ffULL,
0x00005f0016167a11ULL, 0x000fc400008f4417ULL, 0x000000151a0e7210ULL, 0x040fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000b901c46ULL,
0x000000101a107210ULL, 0x040fe40007f3e0ffULL, 0x000000121a127210ULL, 0x000fe40007f5e0ffULL,
0x000140000b0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0001400014147811ULL, 0x000fe200078e20ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x000140000f097811ULL, 0x002fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e0616ULL,
0x000000000e097faeULL, 0x0003e8000b901c46ULL, 0x00000000100b7faeULL, 0x0003e8000b901c46ULL,
0x0000000012147faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x000000ffff357224ULL, 0x000fc400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff407f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b800ff0c7f8cULL, 0x000ee2000c80043fULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0001110000008947ULL, 0x000fea0003800000ULL,
0x000000020a0a7824ULL, 0x000fe400078e00ffULL, 0x00006400ff0b7624ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x002fe400078e0041ULL, 0x000064000a0a7624ULL, 0x000fe400078e020bULL,
0x000000ffff467224ULL, 0x008fe400078e000dULL, 0xff317217ff507424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff557224ULL, 0x000fc400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc400078e00ffULL, 0x000001000b0c7824ULL, 0x000fca00078e00ffULL,
0x000000040c00720cULL, 0x000fda0003f06070ULL, 0x0001100000000947ULL, 0x004fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0055ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x0186bc00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014120e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e13ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011414ULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0614ULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010b0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000580008087a24ULL, 0x000fc600078e02ffULL,
0x000000060d00720cULL, 0x000fe20003f26070ULL, 0x0000004008147824ULL, 0x000fd800078e00ffULL,
0x0000048000009947ULL, 0x000fea0003800000ULL, 0x00000004ff157819ULL, 0x100fe40000011602ULL,
0x000000200b087811ULL, 0x000fe400078e40ffULL, 0x0000000215167810ULL, 0x000fe20007ffe0ffULL,
0x00000001070e7824ULL, 0x000fe200078e0215ULL, 0x00000008040d7217ULL, 0x000fe40007800000ULL,
0x0000000415227810ULL, 0x040fe20007ffe0ffULL, 0x000000010e127824ULL, 0x040fe200078e0202ULL,
0x0000000615417810ULL, 0x000fe20007ffe0ffULL, 0x000000100e207824ULL, 0x000fc400078e00ffULL,
0x0000000107137824ULL, 0x000fe400078e0216ULL, 0x000000010d0d7824ULL, 0x000fe200078e0a08ULL,
0xfffffff020207812ULL, 0x000fe200078ee212ULL, 0x0000000113127824ULL, 0x000fe200078e0202ULL,
0x0000002003087811ULL, 0x000fe200078e30ffULL, 0x0000001013217824ULL, 0x000fe200078e00ffULL,
0x0000000d070d7217ULL, 0x040fe20007800000ULL, 0x0000000107197824ULL, 0x040fe400078e0222ULL,
0x00000001071a7824ULL, 0x000fe200078e0241ULL, 0xfffffff021217812ULL, 0x000fe200078ee212ULL,
0x000000010e0e7824ULL, 0x000fc400078e0208ULL, 0x0000000113127824ULL, 0x100fe400078e0208ULL,
0x0000000119137824ULL, 0x140fe200078e0208ULL, 0x0000000e140e7210ULL, 0x000fe20007f1e0ffULL,
0x000000011a087824ULL, 0x000fe200078e0208ULL, 0x0000001214127210ULL, 0x040fe20007f5e0ffULL,
0x0000001019237824ULL, 0x040fe200078e00ffULL, 0x0000001314187210ULL, 0x000fe20007fbe0ffULL,
0x000000101a427824ULL, 0x000fe200078e00ffULL, 0x0000000814177210ULL, 0x000fe20007fde0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e000e137a11ULL, 0x000fe200078040ffULL,
0x0000000119147824ULL, 0x000fc400078e0202ULL, 0x000000011a197824ULL, 0x000fe200078e0202ULL,
0x00005f000e087a11ULL, 0x000fe200000f4408ULL, 0x00000010020e7824ULL, 0x000fe200078e00ffULL,
0xfffffff023237812ULL, 0x000fe200078ee214ULL, 0x000000010d0d7824ULL, 0x000fe200078e0a07ULL,
0xfffffff042427812ULL, 0x000fe200078ee219ULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00005e0012197a11ULL, 0x000fe200078840ffULL, 0x000000ffff147224ULL, 0x000fe200028e06ffULL,
0x000000f00e1b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0e7224ULL, 0x000fe200030e06ffULL,
0x0000000d1500720cULL, 0x000fc40003f66070ULL, 0x00005f00121a7a11ULL, 0x000fe400020f441aULL,
0x0000001b13127210ULL, 0x000fe40007f9e0ffULL, 0x00005e0018157a11ULL, 0x000fe400078a40ffULL,
0x0000000d1600720cULL, 0x000fe20003f46070ULL, 0x000000ffff137224ULL, 0x000fe200020e0608ULL,
0x0001600020087811ULL, 0x000fe400078e20ffULL, 0x00005f0018187a11ULL, 0x000fc400028f4414ULL,
0x0000001b19147210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012087faeULL, 0x0003e2000d901c46ULL, 0x0000000d2200720cULL, 0x080fe40003f06070ULL,
0x00005e0017167a11ULL, 0x000fe400078c40ffULL, 0x0000000d4100720cULL, 0x000fe40003f86070ULL,
0x00005f0017177a11ULL, 0x000fe400030f440eULL, 0x00016000230d7811ULL, 0x000fc400078e20ffULL,
0x00016000420e7811ULL, 0x000fe400078e20ffULL, 0x0000001b15127210ULL, 0x082fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e061aULL, 0x0000001b16167210ULL, 0x000fe40007fbe0ffULL,
0x0001600021087811ULL, 0x000fe200078e20ffULL, 0x000000ffff137224ULL, 0x000fe400018e0618ULL,
0x000000ffff177224ULL, 0x000fe400028e0617ULL, 0x0000000014087faeULL, 0x0003e8000d101c46ULL,
0x00000000120d7faeULL, 0x0003e8000c101c46ULL, 0x00000000160e7faeULL, 0x0003e2000e101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000000702087211ULL, 0x000fe400078fe0ffULL,
0x0000002003127811ULL, 0x000fc400078e30ffULL, 0x00000002080e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080d7824ULL, 0x140fe200078e0202ULL, 0x0000000608167810ULL, 0x040fe20007ffe0ffULL,
0x00000010081b7824ULL, 0x000fe400078e00ffULL, 0x000000010e137824ULL, 0x040fe400078e0202ULL,
0x000000100e207824ULL, 0x040fe200078e00ffULL, 0xfffffff01b1b7812ULL, 0x000fe200078ee20dULL,
0x000000010e0d7824ULL, 0x000fe400078e0212ULL, 0x0000001016227824ULL, 0x000fe200078e00ffULL,
0xfffffff020207812ULL, 0x000fc400078ee213ULL, 0x0000000408137810ULL, 0x040fe20007ffe0ffULL,
0x0000000108087824ULL, 0x100fe200078e0212ULL, 0x0000000d14157210ULL, 0x000fe20007f5e0ffULL,
0x00000010020d7824ULL, 0x000fe400078e00ffULL, 0x00000001130e7824ULL, 0x100fe200078e0212ULL,
0x0000000814087210ULL, 0x000fe20007f1e0ffULL, 0x0000000116127824ULL, 0x000fe200078e0212ULL,
0x000000f00d1a7812ULL, 0x000fe200078ec0ffULL, 0x0000001013217824ULL, 0x040fe200078e00ffULL,
0x0000000e14177210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x00000012140e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000113147824ULL, 0x100fe200078e0202ULL,
0x00005e0008127a11ULL, 0x000fe200078040ffULL, 0x0000000116137824ULL, 0x000fc400078e0202ULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x00005f0008197a11ULL, 0x000fe200000f4419ULL,
0x000000ffff087224ULL, 0x000fe200020e06ffULL, 0xfffffff022227812ULL, 0x000fe200078ee213ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0xfffffff021217812ULL, 0x000fe400078ee214ULL,
0x00005e0015147a11ULL, 0x000fe400078440ffULL, 0x00005e000e187a11ULL, 0x000fe400078840ffULL,
0x0000001a12127210ULL, 0x000fc40007f1e0ffULL, 0x00005e0017167a11ULL, 0x000fe400078640ffULL,
0x00005f0015157a11ULL, 0x000fe200010f4413ULL, 0x000000ffff137224ULL, 0x000fe200000e0619ULL,
0x00005f000e0e7a11ULL, 0x000fe400020f4408ULL, 0x000160001b087811ULL, 0x000fe400078e20ffULL,
0x00005f0017177a11ULL, 0x000fe400018f440dULL, 0x0000001a14147210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012087faeULL, 0x0003e2000b901c46ULL,
0x0000001a16167210ULL, 0x000fc40007f5e0ffULL, 0x0000001a18187210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00016000210d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe400010e0617ULL, 0x000000ffff197224ULL, 0x000fe200018e060eULL,
0x00016000220e7811ULL, 0x000fe400078e20ffULL, 0x0001600020087811ULL, 0x002fca00078e20ffULL,
0x0000000014087faeULL, 0x0003e8000b901c46ULL, 0x00000000160d7faeULL, 0x0003e8000b901c46ULL,
0x00000000180e7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000155127810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe60003800000ULL,
0x000000051200720cULL, 0x000fe20003f06070ULL, 0xffffffffff087424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010a127824ULL, 0x000fe400078e0212ULL,
0x00000004ff137424ULL, 0x000fc800078e00ffULL, 0x0000600012127625ULL, 0x000fca00078e0013ULL,
0x0000000612087981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff1a7f8cULL, 0x000ee2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186080007167f8cULL, 0x0002a4000c80043fULL,
0x0000000000127805ULL, 0x002fc40000015200ULL, 0x01860c00070d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x006fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x00000014120e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e13ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011414ULL, 0x0000000e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e0614ULL, 0x000000020d0d7819ULL, 0x000fc8000000120eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860c00070d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x00000010020d7824ULL, 0x000fc600078e00ffULL, 0x0000000c0e127812ULL, 0x000fe400078ec0ffULL,
0x000000700d0e7812ULL, 0x000fca00078ec0ffULL, 0x000000010e0e7824ULL, 0x000fca00078e0212ULL,
0x018000000e127984ULL, 0x000e680000000800ULL, 0x018200000e137984ULL, 0x0004e20000000800ULL,
0x000000501200720bULL, 0x002fe20003f1d000ULL, 0x00017b327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff14177812ULL, 0x000fe2000780c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff547224ULL, 0x000fd200078e0050ULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f05270ULL, 0x000000501200720bULL, 0x000fe20003f54000ULL,
0x00017b027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x0000001250547209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991014157816ULL, 0x000fc600000000ffULL, 0x018400540e008388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000005450157221ULL, 0x002fe20000010000ULL, 0x000000ff14ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b15157820ULL, 0x000fcc0000410000ULL,
0x0000001500157308ULL, 0x000e680000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff597819ULL, 0x000fe20000011602ULL, 0x00017a727f007947ULL, 0x000fea000b800000ULL,
0x00001f5915597589ULL, 0x0022a400000e0000ULL, 0x000000591c1c7220ULL, 0x084fe40000410000ULL,
0x000000591d1d7220ULL, 0x080fe40000410000ULL, 0x0000005924247220ULL, 0x080fe40000410000ULL,
0x0000005925257220ULL, 0x000fc40000410000ULL, 0x0000005928287220ULL, 0x080fe40000410000ULL,
0x0000005929297220ULL, 0x080fe40000410000ULL, 0x000000592c2c7220ULL, 0x080fe40000410000ULL,
0x000000592d2d7220ULL, 0x080fe40000410000ULL, 0x0000005934347220ULL, 0x080fe40000410000ULL,
0x0000005935357220ULL, 0x000fc40000410000ULL, 0x0000005930307220ULL, 0x080fe40000410000ULL,
0x0000005931317220ULL, 0x080fe40000410000ULL, 0x0000005938387220ULL, 0x080fe40000410000ULL,
0x0000005939397220ULL, 0x080fe40000410000ULL, 0x000000593c3c7220ULL, 0x080fe40000410000ULL,
0x000000593d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0014ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001509097220ULL, 0x002fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802597811ULL, 0x000fe200078ff0ffULL,
0x000179727f007947ULL, 0x000fea000b800000ULL, 0x00001f5915597589ULL, 0x0002a400000e0000ULL,
0x000000591e1e7220ULL, 0x084fe40000410000ULL, 0x000000591f1f7220ULL, 0x080fe40000410000ULL,
0x0000005926267220ULL, 0x080fe40000410000ULL, 0x0000005927277220ULL, 0x080fe40000410000ULL,
0x000000592a2a7220ULL, 0x080fe40000410000ULL, 0x000000592b2b7220ULL, 0x000fc40000410000ULL,
0x000000592e2e7220ULL, 0x080fe40000410000ULL, 0x000000592f2f7220ULL, 0x080fe40000410000ULL,
0x0000005936367220ULL, 0x080fe40000410000ULL, 0x0000005937377220ULL, 0x080fe40000410000ULL,
0x0000005932327220ULL, 0x080fe40000410000ULL, 0x0000005933337220ULL, 0x000fc40000410000ULL,
0x000000593a3a7220ULL, 0x080fe40000410000ULL, 0x000000593b3b7220ULL, 0x080fe40000410000ULL,
0x000000593e3e7220ULL, 0x080fe40000410000ULL, 0x000000593f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff17ff7812ULL, 0x000fda0007806014ULL,
0x8000005412120221ULL, 0x000fe20000010000ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x00000012000f0308ULL, 0x000e640000000800ULL,
0x0000000f13130220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000913097221ULL, 0x008fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x0186ac00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804840ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804840ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016127816ULL, 0x000fe200000000ffULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000ff1200720cULL, 0x000fda0003f45270ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000fff10723eULL, 0x000fe400000000ffULL, 0x00000002ff127819ULL, 0x000fe40000011602ULL,
0x00005410105a7816ULL, 0x000fe20000000010ULL, 0x000175927f007947ULL, 0x000fea000b800000ULL,
0x00001f125a107589ULL, 0x0002a400000e0000ULL, 0x0000000812117810ULL, 0x000fe20007ffe0ffULL,
0x000175d27f007947ULL, 0x000fea000b800000ULL, 0x00001f115a117589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001012597810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x000028c000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x000186d000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001812597810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x0000292000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff517424ULL, 0x004fc400078e00ffULL, 0x0001867000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802487812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff127819ULL, 0x002fc40000011602ULL,
0x0000000748487812ULL, 0x000fe400078ef802ULL, 0x0000000200167811ULL, 0x040fe200078e10ffULL,
0x00000004004a7824ULL, 0x000fe200078e0212ULL, 0x0000000702577812ULL, 0x000fe200078ec0ffULL,
0x0000001048147824ULL, 0x040fe400078e00ffULL, 0x0000000148137824ULL, 0x000fe200078e024aULL,
0x0000000857577812ULL, 0x000fe200078ef802ULL, 0x0000000112497824ULL, 0x000fe400078e0216ULL,
0x0000001048157824ULL, 0x000fe200078e00ffULL, 0xfffffff014137812ULL, 0x000fe200078ee213ULL,
0x0000000148147824ULL, 0x000fc400078e0249ULL, 0x0000000112567824ULL, 0x000fe200078e0257ULL,
0x0001400013137811ULL, 0x000fe400078e20ffULL, 0xfffffff015147812ULL, 0x000fc600078ee214ULL,
0x000000001320783bULL, 0x000e620000004200ULL, 0x0001400014147811ULL, 0x000fca00078e20ffULL,
0x000000001440783bULL, 0x000ee20000004200ULL, 0x00000018ff157819ULL, 0x002fe20000011420ULL,
0x0000010020177824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011422ULL,
0x0000001500517306ULL, 0x0043e20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fe40000011423ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000018ff4c7819ULL, 0x008fc40000011440ULL,
0x00000018ff4d7819ULL, 0x000fe20000011441ULL, 0x0000001700507306ULL, 0x0005e20000200c00ULL,
0x00000018ff157819ULL, 0x002fe40000011421ULL, 0x00000018ff197819ULL, 0x000fe40000011442ULL,
0x00000018ff597819ULL, 0x000fc60000011443ULL, 0x0000001500637306ULL, 0x0003e20000200c00ULL,
0x0000010021177824ULL, 0x004fca00078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x0000888020157816ULL, 0x042fe200000000ffULL,
0x0001000020207824ULL, 0x000fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000001500187306ULL, 0x0003f00000200c00ULL, 0x0000001700627306ULL, 0x0005e20000200c00ULL,
0x0000888021157816ULL, 0x042fe200000000ffULL, 0x0001000021217824ULL, 0x000fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000001500537306ULL, 0x0003e20000200c00ULL,
0x0000010022177824ULL, 0x004fca00078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000002000527306ULL, 0x0005e20000200c00ULL, 0x0000888022157816ULL, 0x042fe200000000ffULL,
0x0001000022227824ULL, 0x000fca00078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000001500657306ULL, 0x0003e20000200c00ULL, 0x0000001048207812ULL, 0x004fc800078efcffULL,
0x0000001620587210ULL, 0x000fe20007ffe012ULL, 0x000000014a4b7824ULL, 0x000fe200078e0220ULL,
0x0000888042167816ULL, 0x000fe200000000ffULL, 0x0000001700667306ULL, 0x0004e20000200c00ULL,
0x0000888023157816ULL, 0x002fce00000000ffULL, 0x0000001500677306ULL, 0x0003e20000200c00ULL,
0x0000010023177824ULL, 0x044fe400078e00ffULL, 0x0001000023237824ULL, 0x000fc600078e00ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0000001600717306ULL, 0x000fe20000200c00ULL, 0x0000888040157816ULL, 0x002fe400000000ffULL,
0x0000541065667816ULL, 0x008fca0000000066ULL, 0x00000015006b7306ULL, 0x0003f00000200c00ULL,
0x0000001700697306ULL, 0x0004e20000200c00ULL, 0x0000888041157816ULL, 0x002fce00000000ffULL,
0x00000015006d7306ULL, 0x0003e20000200c00ULL, 0x0000010040177824ULL, 0x044fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000001020157824ULL, 0x042fe200078e00ffULL,
0x00000017006c7306ULL, 0x0002a20000200c00ULL, 0x0000001020207824ULL, 0x000fe200078e00ffULL,
0x0000541067677816ULL, 0x008fe40000000069ULL, 0xfffffff0154b7812ULL, 0x000fe400078ee24bULL,
0xfffffff020587812ULL, 0x000fc400078ee258ULL, 0x000140004b157811ULL, 0x000fe200078e20ffULL,
0x0000010041177824ULL, 0x042fe200078e00ffULL, 0x00000040006e7306ULL, 0x0003e20000200c00ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x0001400058167811ULL, 0x000fe200078e20ffULL,
0x000000001544783bULL, 0x000ee20000004200ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000017006f7306ULL, 0x0004a20000200c00ULL,
0x0000888043407816ULL, 0x002fc400000000ffULL, 0x000054106b6c7816ULL, 0x004fca000000006cULL,
0x0000004100707306ULL, 0x000fe20000200c00ULL, 0x0000010042177824ULL, 0x040fe400078e00ffULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000002100647306ULL, 0x000fe20000200c00ULL,
0x000054106d6d7816ULL, 0x000fce000000006fULL, 0x0000001700727306ULL, 0x0003f00000200c00ULL,
0x0000004200737306ULL, 0x000fe20000200c00ULL, 0x000000ffff177224ULL, 0x002fe200078e0040ULL,
0x00000018ff607819ULL, 0x008fe20000011444ULL, 0x0000010043407824ULL, 0x000fe200078e00ffULL,
0x0000888045797816ULL, 0x000fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011445ULL, 0x0000010044417824ULL, 0x000fe200078e00ffULL,
0x0000001700747306ULL, 0x0003e20000200c00ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0001000047827824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011443ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff5e7819ULL, 0x000fe20000011446ULL,
0x0000004000757306ULL, 0x0005e20000200c00ULL, 0x0000000857177824ULL, 0x002fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011447ULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0xfffffff817177812ULL, 0x000fe400078ee256ULL, 0x0000004300767306ULL, 0x000fe20000200c00ULL,
0x0000888044407816ULL, 0x044fe200000000ffULL, 0x0001000044447824ULL, 0x000fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000004000777306ULL, 0x0003f00000200c00ULL,
0x0000004100787306ULL, 0x0004e20000200c00ULL, 0x0001200017407811ULL, 0x002fce00078e20ffULL,
0x00000044007a7306ULL, 0x0003e20000200c00ULL, 0x000000004040783bULL, 0x004eae0000000200ULL,
0x0000002200687306ULL, 0x000ee20000200c00ULL, 0x000000ffff447224ULL, 0x002fe200078e0079ULL,
0x0000541077787816ULL, 0x008fe20000000078ULL, 0x0000010045797824ULL, 0x000fc400078e00ffULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000023006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff457819ULL, 0x000fca0000011445ULL,
0x00000045007c7306ULL, 0x0007e20000200c00ULL, 0x000000001620783bULL, 0x002e620000004200ULL,
0x0000541068687816ULL, 0x000fcc000000004fULL, 0x00000044007b7306ULL, 0x0005e20000200c00ULL,
0x0000010046457824ULL, 0x008fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004e004e7306ULL, 0x000ee20000200c00ULL, 0x0000888046447816ULL, 0x044fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x000000104040a232ULL, 0x080fe40000000000ULL,
0x000000104242a232ULL, 0x000fe40000000000ULL, 0x000000114141a232ULL, 0x080fe20000000000ULL,
0x00000045007e7306ULL, 0x0005e20000200c00ULL, 0x000000114343a232ULL, 0x000fe20000000000ULL,
0x00000018ff467819ULL, 0x000fcc0000011446ULL, 0x00000044007d7306ULL, 0x0002620000200c00ULL,
0x0000010047457824ULL, 0x044fe200078e00ffULL, 0x000054106a697816ULL, 0x008fe2000000004eULL,
0x000000664028723cULL, 0x040f660000001828ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004600807306ULL, 0x000fe20000200c00ULL, 0x0000888047447816ULL, 0x002fe200000000ffULL,
0x00000100214f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe20000011420ULL,
0x00000068402c723cULL, 0x000fe2000000182cULL, 0x00000018ff5c7819ULL, 0x000fc40000011421ULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x00000044007f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe40000011422ULL, 0x00000018ff5b7819ULL, 0x000fe20000011423ULL,
0x0000006c4034723cULL, 0x000fe20000001834ULL, 0x000054107d7e7816ULL, 0x000fc6000000007eULL,
0x0000004500817306ULL, 0x0004e20000200c00ULL, 0x0000541018447816ULL, 0x002fe20000000050ULL,
0x0000000857507824ULL, 0x000fe200078e00ffULL, 0x0000000256187810ULL, 0x000fc80007ffe0ffULL,
0xfffffff850187812ULL, 0x000fe200078ee218ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x0000541053457816ULL, 0x004fce0000000062ULL, 0x000000444044723cULL, 0x000be2000000181cULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x000054107f7f7816ULL, 0x008fca0000000081ULL,
0x00005410521c7816ULL, 0x020fe40000000051ULL, 0x00005410641d7816ULL, 0x000fe20000000063ULL,
0x0000001900197306ULL, 0x000fe20000200c00ULL, 0x0000888020517816ULL, 0x000fe400000000ffULL,
0x000054106e4c7816ULL, 0x002fc6000000004cULL, 0x0000001c401c723cULL, 0x000b620000001824ULL,
0x00005410704d7816ULL, 0x004fe2000000004dULL, 0x0000005900597306ULL, 0x000fea0000200c00ULL,
0x000000ffff247224ULL, 0x020fe200078e0051ULL, 0x0000888021517816ULL, 0x000fe200000000ffULL,
0x0000010020257824ULL, 0x040fe200078e00ffULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0001000020207824ULL, 0x000fc400078e00ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0051ULL,
0x00000018ff507819ULL, 0x000fe20000011425ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x0000541074517816ULL, 0x000fe40000000075ULL, 0x0000002400627306ULL, 0x0003e20000200c00ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff217819ULL, 0x000fca0000011421ULL,
0x0000005000637306ULL, 0x0004e20000200c00ULL, 0x0001200018247811ULL, 0x002fcc00078e20ffULL,
0x000000002424783bULL, 0x000e620000000200ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000541071507816ULL, 0x004fce0000000072ULL, 0x000000504050723cULL, 0x000be20000001838ULL,
0x0000002000647306ULL, 0x0005e20000200c00ULL, 0x0000541062627816ULL, 0x008fce0000000063ULL,
0x0000002100397306ULL, 0x0207e20000200c00ULL, 0x0000541073207816ULL, 0x004fce0000000019ULL,
0x0000004e00657306ULL, 0x000fe20000200c00ULL, 0x0000541076217816ULL, 0x008fce0000000059ULL,
0x0000004f00667306ULL, 0x0004e20000200c00ULL, 0x000000102424a232ULL, 0x082fe40000000000ULL,
0x000000102626a232ULL, 0x000fe20000000000ULL, 0x0000004c404c723cULL, 0x004b620000001830ULL,
0x000000112525a232ULL, 0x000fc60000000000ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000112727a232ULL, 0x000fe40000000000ULL, 0x0000888022307816ULL, 0x020fe200000000ffULL,
0x000000204040723cULL, 0x000b62000000183cULL, 0x0000541065637816ULL, 0x008fc60000000066ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x000000ffff197224ULL, 0x000fe400078e0030ULL,
0x0000010023307824ULL, 0x040fe200078e00ffULL, 0x0000888023217816ULL, 0x060fe200000000ffULL,
0x0000010022207824ULL, 0x000fe200078e00ffULL, 0x000054107a3c7816ULL, 0x000fe20000000060ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x000054107c3d7816ULL, 0x000fe20000000061ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000007e2428723cULL, 0x000f620000001828ULL, 0x00000018ff237819ULL, 0x000fc40000011423ULL,
0x00000018ff307819ULL, 0x000fc60000011430ULL, 0x0000005c005c7306ULL, 0x000ea40000200c00ULL,
0x0000003c243c723cULL, 0x040b6c000000181cULL, 0x0000007900797306ULL, 0x000ee20000200c00ULL,
0x0000541064387816ULL, 0x002fe2000000005dULL, 0x000000622434723cULL, 0x000b6c0000001834ULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x0000541039397816ULL, 0x004fce000000005cULL,
0x0000001900197306ULL, 0x000fe20000200c00ULL, 0x000054107b797816ULL, 0x008fe20000000079ULL,
0x000000382438723cULL, 0x040b6c000000184cULL, 0x0000002000207306ULL, 0x000ea20000200c00ULL,
0x0000541082317816ULL, 0x002fe2000000005fULL, 0x000000782444723cULL, 0x000b6c0000001844ULL,
0x0000002100217306ULL, 0x000ff00000200c00ULL, 0x00000030001d7306ULL, 0x0202e20000200c00ULL,
0x00005410191c7816ULL, 0x004fce0000000020ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541080307816ULL, 0x002fce000000005eULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00005410211d7816ULL, 0x008fe2000000001dULL, 0x000000302430723cULL, 0x040b6c000000182cULL,
0x0000002200227306ULL, 0x000e640000200c00ULL, 0x0000001c241c723cULL, 0x000b6c0000001850ULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x00005410225a7816ULL, 0x002fc4000000005aULL,
0x00005410235b7816ULL, 0x004fce000000005bULL, 0x0000005a2424723cULL, 0x000b620000001840ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff2c7f8cULL, 0x020e62000c80043fULL,
0x000000ffff2e7224ULL, 0x000fce00078e00ffULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x0186bc00ff197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x006fe4000780482dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220227210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff197819ULL, 0x000fc80000011423ULL, 0x0000002219197211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0623ULL, 0x0000000219197819ULL, 0x000fc80000001222ULL,
0x000000190000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fe4000780482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580008417a24ULL, 0x010fe200078e02ffULL,
0x000000400b197811ULL, 0x000fc600078e40ffULL, 0x0000004041417824ULL, 0x000fe200078e00ffULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x0000001904207217ULL, 0x000fe20007800000ULL,
0x0000000107217824ULL, 0x000fe200078e0212ULL, 0x00000002122c7810ULL, 0x040fe40007ffe0ffULL,
0x00000004124e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000121227824ULL, 0x000fe200078e0202ULL,
0x000000f00d437812ULL, 0x000fe200078ec0ffULL, 0x00000010214c7824ULL, 0x000fe400078e00ffULL,
0x0000000120207824ULL, 0x000fc400078e0a19ULL, 0x0000004003427824ULL, 0x000fe200078e0221ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee222ULL, 0x0000000107237824ULL, 0x040fe200078e022cULL,
0x0000002007207217ULL, 0x040fe20007800000ULL, 0x0000000107217824ULL, 0x000fe200078e024eULL,
0x00000041422d7210ULL, 0x0c0fe20007f1e0ffULL, 0x0000000123227824ULL, 0x140fe200078e0202ULL,
0x0000000242407810ULL, 0x040fe20007ffe0ffULL, 0x00000010234d7824ULL, 0x000fe200078e00ffULL,
0x00000004422f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001212e7824ULL, 0x040fe200078e0202ULL,
0x0000004140407210ULL, 0x080fe20007f7e0ffULL, 0x00000010214f7824ULL, 0x000fe200078e00ffULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee222ULL, 0x0000000120237824ULL, 0x000fe200078e0a07ULL,
0x000000412f2f7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0x00005e002d227a11ULL, 0x000fc400078040ffULL, 0x000000231200720cULL, 0x000fe40003f86070ULL,
0x00005f002d2d7a11ULL, 0x000fe200000f4421ULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0xfffffff04f4f7812ULL, 0x000fe400078ee22eULL, 0x00005e00402e7a11ULL, 0x000fe400078a40ffULL,
0x0000004322207210ULL, 0x000fe40007f7e0ffULL, 0x00005f0040407a11ULL, 0x000fc400028f4421ULL,
0x000000232c00720cULL, 0x080fe20003f06070ULL, 0x000000ffff217224ULL, 0x000fe200018e062dULL,
0x000140004c4c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff2c7224ULL, 0x000fe200030e06ffULL,
0x000000234e00720cULL, 0x000fe40003f66070ULL, 0x00005e002f227a11ULL, 0x000fe200078a40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000204c7faeULL, 0x0003e2000e101c46ULL,
0x00000006124e7810ULL, 0x000fe40007ffe0ffULL, 0x00000006422d7810ULL, 0x000fc40007ffe0ffULL,
0x00005f002f2f7a11ULL, 0x000fe200028f442cULL, 0x00000001072c7824ULL, 0x000fe200078e024eULL,
0x000000412d2d7210ULL, 0x000fe40007f9e0ffULL, 0x0000004322227210ULL, 0x080fe20007fde0ffULL,
0x000000012c427824ULL, 0x040fe200078e0202ULL, 0x000140004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000102c4c7824ULL, 0x002fe200078e00ffULL, 0x000000432e207210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200020e06ffULL, 0x00005e002d2c7a11ULL, 0x000fc400078840ffULL,
0xfffffff04c427812ULL, 0x000fe200078ee242ULL, 0x000000ffff217224ULL, 0x000fe200028e0640ULL,
0x000000234e00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff237224ULL, 0x000fe200030e062fULL,
0x00005f002d2d7a11ULL, 0x000fe400020f442eULL, 0x000000432c2c7210ULL, 0x000fe20007f9e0ffULL,
0x00000000204d7faeULL, 0x0003e2000c101c46ULL, 0x000140004f4f7811ULL, 0x000fe400078e20ffULL,
0x0001400042427811ULL, 0x000fe200078e20ffULL, 0x000000ffff2d7224ULL, 0x000fc400020e062dULL,
0x00000000224f7faeULL, 0x0003e8000d901c46ULL, 0x000000002c427faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000107227824ULL, 0x000fc800078e0212ULL,
0x0000000122237824ULL, 0x040fe200078e0202ULL, 0x0000000222207810ULL, 0x040fe20007ffe0ffULL,
0x0000001022427824ULL, 0x000fe400078e00ffULL, 0x00000040032c7824ULL, 0x000fe400078e0222ULL,
0x0000000120217824ULL, 0x000fe200078e0202ULL, 0xfffffff042427812ULL, 0x000fe200078ee223ULL,
0x00000010202d7824ULL, 0x000fe200078e00ffULL, 0x0000000422207810ULL, 0x040fe40007ffe0ffULL,
0x0000000622227810ULL, 0x000fc40007ffe0ffULL, 0xfffffff02d237812ULL, 0x000fe200078ee221ULL,
0x0000000120217824ULL, 0x100fe200078e0202ULL, 0x000000412c2e7210ULL, 0x000fe20007f1e0ffULL,
0x00000010202d7824ULL, 0x000fe200078e00ffULL, 0x000000042c437810ULL, 0x000fe20007ffe0ffULL,
0x0000000122207824ULL, 0x000fe200078e0202ULL, 0x0001400042427811ULL, 0x000fe200078e20ffULL,
0x0000001022407824ULL, 0x000fe200078e00ffULL, 0xfffffff02d2d7812ULL, 0x000fe200078ee221ULL,
0x000000ffff227224ULL, 0x000fe200000e06ffULL, 0x00005e002e2f7a11ULL, 0x000fc400078040ffULL,
0xfffffff040407812ULL, 0x000fe400078ee220ULL, 0x000000022c207810ULL, 0x000fe40007ffe0ffULL,
0x00005f002e227a11ULL, 0x000fe400000f4422ULL, 0x000000062c2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000004120217210ULL, 0x080fe40007f1e0ffULL, 0x00000041434c7210ULL, 0x000fc40007f7e0ffULL,
0x000000f00d2e7812ULL, 0x000fe400078ec0ffULL, 0x000000412c4f7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x00005e0021437a11ULL, 0x000fe200078040ffULL,
0x000000ffff4d7224ULL, 0x000fe200018e06ffULL, 0x0000002e2f207210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff507224ULL, 0x000fe200028e06ffULL, 0x00005e004c4e7a11ULL, 0x000fe400078840ffULL,
0x00005f00212f7a11ULL, 0x000fe200000f442cULL, 0x000000ffff217224ULL, 0x000fe200018e0622ULL,
0x00005e004f517a11ULL, 0x000fc400078a40ffULL, 0x0000002e43227210ULL, 0x080fe40007f1e0ffULL,
0x00005f004c4d7a11ULL, 0x000fe200020f444dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020427faeULL, 0x0003e2000b901c46ULL, 0x0000002e4e2c7210ULL, 0x080fe40007f7e0ffULL,
0x00005f004f507a11ULL, 0x000fe400028f4450ULL, 0x0000002e512e7210ULL, 0x000fe40007f9e0ffULL,
0x0001400040407811ULL, 0x000fc400078e20ffULL, 0x0001400023207811ULL, 0x002fe200078e20ffULL,
0x000000ffff237224ULL, 0x000fe200000e062fULL, 0x000140002d217811ULL, 0x000fe200078e20ffULL,
0x000000ffff2d7224ULL, 0x000fe400018e064dULL, 0x000000ffff2f7224ULL, 0x000fe200020e0650ULL,
0x0000000022207faeULL, 0x0003e8000b901c46ULL, 0x000000002c217faeULL, 0x0003e8000b901c46ULL,
0x000000002e407faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff207f8cULL, 0x000e64000c80043fULL,
0x000000ffff407224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x0186b400ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fc4000780481bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x00000022202c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011423ULL,
0x0000002c22227211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x0000000222227819ULL, 0x000fc80000001223ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012d2d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe4000780481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000016000007945ULL, 0x000fe20003800000ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000fff10723eULL, 0x000fe400000000ffULL, 0x00000002ff1a7819ULL, 0x000fe40000011602ULL,
0x00005410105a7816ULL, 0x000fe20000000010ULL, 0x000157527f007947ULL, 0x000fea000b800000ULL,
0x00001f1a5a107589ULL, 0x0002a400000e0000ULL, 0x000000081a117810ULL, 0x000fe20007ffe0ffULL,
0x000157927f007947ULL, 0x000fea000b800000ULL, 0x00001f115a117589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000101a597810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x000047e000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x000167b000007944ULL, 0x00efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000181a597810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x0000484000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff517424ULL, 0x004fc400078e00ffULL, 0x0001675000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000160004b1a7811ULL, 0x002fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00016000581b7811ULL, 0x000fe200078e20ffULL,
0x00000001484a7824ULL, 0x000fc400078e024aULL, 0x000000001a20783bULL, 0x000e620000004200ULL,
0x0000000148497824ULL, 0x000fc600078e0249ULL, 0x000000001b2c783bULL, 0x000f220000004200ULL,
0x00000018ff657819ULL, 0x002fe20000011420ULL, 0x00000100204b7824ULL, 0x040fe200078e00ffULL,
0x00008880206a7816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011421ULL, 0x00008880216c7816ULL, 0x000fe200000000ffULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff5a7819ULL, 0x008fc40000011422ULL, 0x0000888022637816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011423ULL, 0x0000002000677306ULL, 0x0003e20000200c00ULL,
0x0000888023627816ULL, 0x000fe400000000ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x00000018ff587819ULL, 0x010fe4000001142cULL, 0x000088802c5e7816ULL, 0x000fe200000000ffULL,
0x0000004b006b7306ULL, 0x000fe20000200c00ULL, 0x0000010021207824ULL, 0x042fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe2000001142dULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x000088802d5d7816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff437819ULL, 0x000fe4000001142fULL, 0x00000018ff427819ULL, 0x000fca000001142eULL,
0x00000020006d7306ULL, 0x0003f00000200c00ULL, 0x0000002100697306ULL, 0x0007e20000200c00ULL,
0x0000010022207824ULL, 0x042fe400078e00ffULL, 0x0001000022227824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000001048217824ULL, 0x008fe200078e00ffULL, 0x0000002000647306ULL, 0x0003e80000200c00ULL,
0xfffffff0214a7812ULL, 0x000fe200078ee24aULL, 0x0000010023217824ULL, 0x040fe400078e00ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x0000002200617306ULL, 0x0007e20000200c00ULL,
0x000160004a207811ULL, 0x002fc400078e20ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x000000002050783bULL, 0x004e640000004200ULL,
0x0000002100687306ULL, 0x0005e20000200c00ULL, 0x000001002c227824ULL, 0x008fca00078e00ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000002300607306ULL, 0x000fe20000200c00ULL,
0x0000001048217824ULL, 0x004fca00078e00ffULL, 0xfffffff021217812ULL, 0x000fe200078ee249ULL,
0x0000000857497824ULL, 0x040fe200078e00ffULL, 0x00000022005c7306ULL, 0x0005e20000200c00ULL,
0x0000000857577824ULL, 0x000fe200078e00ffULL, 0x0001600021217811ULL, 0x000fca00078e20ffULL,
0x00000000214c783bULL, 0x000ee20000004200ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x000001002d227824ULL, 0x044fe400078e00ffULL, 0x000100002d2d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x0000888050237816ULL, 0x002fe200000000ffULL,
0x0000010051487824ULL, 0x000fe200078e00ffULL, 0x00008880534a7816ULL, 0x000fca00000000ffULL,
0x00000022005f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff487819ULL, 0x000fce0000011448ULL,
0x0000005b005b7306ULL, 0x000f220000200c00ULL, 0x00000018ff227819ULL, 0x002fe40000011450ULL,
0x00005410615a7816ULL, 0x004fca000000005aULL, 0x0000002200707306ULL, 0x0003f00000200c00ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x00000018ff227819ULL, 0x002fe40000011451ULL,
0x00005410605b7816ULL, 0x010fca000000005bULL, 0x0000002200717306ULL, 0x0003f00000200c00ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00000018ff227819ULL, 0x002fce0000011452ULL,
0x0000002200767306ULL, 0x0003f00000200c00ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00000018ff227819ULL, 0x002fce0000011453ULL, 0x0000002200797306ULL, 0x0007f00000200c00ULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x00000018ff227819ULL, 0x008fce000001144cULL,
0x00000022007e7306ULL, 0x0005f00000200c00ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x00000018ff227819ULL, 0x004fe4000001144dULL, 0x0000541063647816ULL, 0x002fca0000000064ULL,
0x0000002200807306ULL, 0x0003f00000200c00ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x00000018ff227819ULL, 0x002fce000001144eULL, 0x0000002200827306ULL, 0x0003f00000200c00ULL,
0x0000005d005d7306ULL, 0x000ee20000200c00ULL, 0x00000018ff227819ULL, 0x002fe4000001144fULL,
0x000054105e5c7816ULL, 0x004fca000000005cULL, 0x0000002200837306ULL, 0x0003f00000200c00ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000000ffff227224ULL, 0x002fe200078e0023ULL,
0x000054105d5d7816ULL, 0x008fe2000000005fULL, 0x0000010050237824ULL, 0x000fc400078e00ffULL,
0x0001000050507824ULL, 0x000fc600078e00ffULL, 0x00000022006e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x00000018ff507819ULL, 0x000fca0000011450ULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000888051227816ULL, 0x002fce00000000ffULL,
0x00000022006f7306ULL, 0x0003f00000200c00ULL, 0x0000005000507306ULL, 0x000ee20000200c00ULL,
0x0001000051227824ULL, 0x002fe200078e00ffULL, 0x000054106e6e7816ULL, 0x004fc40000000023ULL,
0x0000000656237810ULL, 0x000fe40007ffe0ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000004800517306ULL, 0x0002a20000200c00ULL, 0xfffffff857237812ULL, 0x000fce00078ee223ULL,
0x0000002200727306ULL, 0x0009220000200c00ULL, 0x0000888052487816ULL, 0x002fe400000000ffULL,
0x0000541050507816ULL, 0x008fe40000000070ULL, 0x000054106f6f7816ULL, 0x004fe20000000051ULL,
0x000000ffff227224ULL, 0x010fe400078e0048ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000010052487824ULL, 0x040fe400078e00ffULL, 0x0001000052527824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000002200737306ULL, 0x0003e20000200c00ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000541072517816ULL, 0x000fca0000000071ULL,
0x0000004800747306ULL, 0x0004e20000200c00ULL, 0x0000000456227810ULL, 0x002fc80007ffe0ffULL,
0xfffffff849227812ULL, 0x000fe200078ee222ULL, 0x0000010053497824ULL, 0x040fe400078e00ffULL,
0x0001000053537824ULL, 0x000fe200078e00ffULL, 0x0000005200777306ULL, 0x0003220000200c00ULL,
0x000000ffff487224ULL, 0x004fe200078e004aULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000541073747816ULL, 0x008fc40000000074ULL,
0x0000004800757306ULL, 0x0005e20000200c00ULL, 0x000088804c527816ULL, 0x002fce00000000ffULL,
0x0000004900787306ULL, 0x0002e20000200c00ULL, 0x0001200022487811ULL, 0x004fe400078e20ffULL,
0x0000541077767816ULL, 0x010fca0000000076ULL, 0x00000053007a7306ULL, 0x0005220000200c00ULL,
0x000000004848783bULL, 0x002e6e0000000200ULL, 0x00000052007b7306ULL, 0x0009e20000200c00ULL,
0x000001004c537824ULL, 0x044fe200078e00ffULL, 0x0000541075757816ULL, 0x008fe20000000078ULL,
0x000100004c4c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000053007c7306ULL, 0x0004e20000200c00ULL,
0x000088804d527816ULL, 0x010fe400000000ffULL, 0x000054107a777816ULL, 0x000fca0000000079ULL,
0x00000052007d7306ULL, 0x0009e20000200c00ULL, 0x000001004d537824ULL, 0x044fe400078e00ffULL,
0x000100004d4d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x000088804e527816ULL, 0x010fe400000000ffULL, 0x000054107b7c7816ULL, 0x008fe2000000007cULL,
0x000000104848a232ULL, 0x082fe40000000000ULL, 0x000000104a4aa232ULL, 0x000fe40000000000ULL,
0x00000053007f7306ULL, 0x0002e20000200c00ULL, 0x000000114949a232ULL, 0x000fc40000000000ULL,
0x000000114b4ba232ULL, 0x000fe20000000000ULL, 0x000054104c4c7816ULL, 0x004fc8000000007eULL,
0x0000005200817306ULL, 0x000fe20000200c00ULL, 0x000001004e537824ULL, 0x042fe200078e00ffULL,
0x0000006e4844723cULL, 0x000be20000001844ULL, 0x000100004e4e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x000088804f6e7816ULL, 0x020fe200000000ffULL, 0x000000744828723cULL, 0x000fe20000001828ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x000054107d7d7816ULL, 0x008fc6000000007fULL,
0x0000005300567306ULL, 0x0004e40000200c00ULL, 0x000000764830723cULL, 0x000fe20000001830ULL,
0x000054104d4d7816ULL, 0x002fce0000000080ULL, 0x000000504850723cULL, 0x044bee000000183cULL,
0x000000ffff3c7224ULL, 0x020fe200078e006eULL, 0x0000004c4838723cULL, 0x000be20000001838ULL,
0x000001004f3d7824ULL, 0x040fe400078e00ffULL, 0x0000003c006e7306ULL, 0x0003e20000200c00ULL,
0x000100004f4f7824ULL, 0x000fc400078e00ffULL, 0x00000018ff577819ULL, 0x000fe4000001143dULL,
0x00005410814c7816ULL, 0x028fe20000000056ULL, 0x0000007c4834723cULL, 0x000f620000001834ULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x00000057006f7306ULL, 0x000ea20000200c00ULL,
0x00012000233c7811ULL, 0x002fcc00078e20ffULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x0000004e00577306ULL, 0x0007220000200c00ULL, 0x000054106e4d7816ULL, 0x004fe2000000006fULL,
0x000100002c4e7824ULL, 0x008fcc00078e00ffULL, 0x0000002d00567306ULL, 0x000ea20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000541057827816ULL, 0x010fca0000000082ULL,
0x0000004f002c7306ULL, 0x000ef00000200c00ULL, 0x0000004e00707306ULL, 0x0008620000200c00ULL,
0x0000541056597816ULL, 0x004fe40000000059ULL, 0x000054102c837816ULL, 0x008fe20000000083ULL,
0x0000004c484c723cULL, 0x010b62000000181cULL, 0x000001002f2c7824ULL, 0x000fe200078e00ffULL,
0x000000103c3ca232ULL, 0x002fc40000000000ULL, 0x000000103e3ea232ULL, 0x000fc60000000000ULL,
0x000001002e1d7824ULL, 0x060fe200078e00ffULL, 0x000088802e1c7816ULL, 0x040fe200000000ffULL,
0x000000113d3da232ULL, 0x080fe20000000000ULL, 0x000000824848723cULL, 0x000b620000001824ULL,
0x000000113f3fa232ULL, 0x000fe20000000000ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000001c00577306ULL, 0x0003e20000200c00ULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x000088802f247816ULL, 0x060fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000005c3c34723cULL, 0x000f620000001834ULL, 0x0000001d006e7306ULL, 0x0005e20000200c00ULL,
0x000054106a1c7816ULL, 0x002fc4000000006bULL, 0x0000541070587816ULL, 0x000fe40000000058ULL,
0x0000541069257816ULL, 0x000fe40000000066ULL, 0x000054106c1d7816ULL, 0x004fce000000006dULL,
0x0000001c3c1c723cULL, 0x000b640000001844ULL, 0x0000002400457306ULL, 0x0203ea0000200c00ULL,
0x00000018ff477819ULL, 0x000fc6000001142fULL, 0x0000002c00467306ULL, 0x000fe20000200c00ULL,
0x0000541067247816ULL, 0x002fe40000000065ULL, 0x0000541062657816ULL, 0x000fca0000000068ULL,
0x0000002e00447306ULL, 0x0002a20000200c00ULL, 0x000000243c24723cULL, 0x040f6e0000001850ULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x0000005a3c2c723cULL, 0x002f620000001830ULL,
0x0000541044427816ULL, 0x004fce0000000042ULL, 0x000000583c30723cULL, 0x040b6e0000001838ULL,
0x0000541057387816ULL, 0x020fe2000000006eULL, 0x000000643c28723cULL, 0x000b620000001828ULL,
0x0000541045397816ULL, 0x000fe40000000046ULL, 0x0000541047437816ULL, 0x008fca0000000043ULL,
0x000000383c38723cULL, 0x040b70000000184cULL, 0x000000423c3c723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff427f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000041900720cULL, 0x000fe20003f06070ULL, 0x01868800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x002fe200078e0043ULL, 0x0000000155557810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff507224ULL, 0x000fd200078e0054ULL, 0x0000c92000000947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x0186bc00ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011445ULL, 0x0000004408087211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000208087819ULL, 0x000fc80000001244ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000147477810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000002019087810ULL, 0x000fe20007ffe0ffULL, 0x0000000107437824ULL, 0x000fe200078e0212ULL,
0x00000004124e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000804427217ULL, 0x000fe20007800000ULL,
0x0000000143447824ULL, 0x040fe200078e0202ULL, 0x0000000212457810ULL, 0x040fe20007ffe0ffULL,
0x00000010434c7824ULL, 0x000fe200078e00ffULL, 0x0000000612507810ULL, 0x000fe20007ffe0ffULL,
0x0000000142427824ULL, 0x000fe200078e0a08ULL, 0x0000002003087811ULL, 0x000fe200078e30ffULL,
0x0000000107477824ULL, 0x040fe200078e024eULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee244ULL,
0x0000000107467824ULL, 0x040fe200078e0245ULL, 0x0000004207427217ULL, 0x000fe20007800000ULL,
0x00000001434a7824ULL, 0x000fe200078e0208ULL, 0x000000f00d4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000147487824ULL, 0x040fe200078e0202ULL, 0x000160004c4c7811ULL, 0x000fe200078e20ffULL,
0x00000010474f7824ULL, 0x000fe200078e00ffULL, 0x000000414a4a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000146497824ULL, 0x000fc400078e0208ULL, 0x0000000146447824ULL, 0x040fe200078e0202ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee248ULL, 0x00000010464d7824ULL, 0x000fe200078e00ffULL,
0x0000004149497210ULL, 0x080fe20007f9e0ffULL, 0x0000000107437824ULL, 0x000fe200078e0250ULL,
0x000160004f4f7811ULL, 0x000fe200078e20ffULL, 0x0000000147477824ULL, 0x000fe200078e0208ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee244ULL, 0x0000000143467824ULL, 0x040fe400078e0208ULL,
0x0000000143487824ULL, 0x000fe200078e0202ULL, 0x0000004147477210ULL, 0x080fe20007f7e0ffULL,
0x0000001043517824ULL, 0x000fe200078e00ffULL, 0x0000004146417210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e06ffULL, 0x00005e004a447a11ULL, 0x000fe200078040ffULL,
0x0000000142087824ULL, 0x000fe200078e0a07ULL, 0xfffffff051517812ULL, 0x000fe200078ee248ULL,
0x000000ffff427224ULL, 0x000fe200020e06ffULL, 0x00005f004a4a7a11ULL, 0x000fe200000f4443ULL,
0x000000ffff437224ULL, 0x000fe200018e06ffULL, 0x00005e0049487a11ULL, 0x000fc400078c40ffULL,
0x000000084500720cULL, 0x080fe40003f06070ULL, 0x00005e0047457a11ULL, 0x000fe400078a40ffULL,
0x000000081200720cULL, 0x000fe40003f86070ULL, 0x00005f0049497a11ULL, 0x000fe400030f4442ULL,
0x0000004b44427210ULL, 0x000fe20007fde0ffULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x00005f0047477a11ULL, 0x000fc400028f4443ULL, 0x00005e0041467a11ULL, 0x040fe200078a40ffULL,
0x000000ffff437224ULL, 0x000fe200030e064aULL, 0x000000084e00720cULL, 0x080fe40003f66070ULL,
0x000000085000720cULL, 0x000fe40003f46070ULL, 0x00005f0041087a11ULL, 0x000fe200028f4444ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000424c7faeULL, 0x0003e2000e101c46ULL,
0x0000004b48447210ULL, 0x000fe40007fbe0ffULL, 0x000160004d4d7811ULL, 0x000fc400078e20ffULL,
0x0001600051517811ULL, 0x000fe400078e20ffULL, 0x0000004b45427210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff457224ULL, 0x000fe200028e0649ULL, 0x0000004b46467210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff437224ULL, 0x000fe200020e0647ULL, 0x00000000444d7faeULL, 0x0003e2000c101c46ULL,
0x000000ffff477224ULL, 0x000fc600028e0608ULL, 0x00000000424f7faeULL, 0x0003e8000d901c46ULL,
0x0000000046517faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0212ULL, 0x0000002003437811ULL, 0x000fe400078e30ffULL,
0x000000f00d4b7812ULL, 0x000fe200078ec0ffULL, 0x0000000108427824ULL, 0x040fe200078e0202ULL,
0x0000000208457810ULL, 0x040fe20007ffe0ffULL, 0x00000010084c7824ULL, 0x040fe200078e00ffULL,
0x0000000408467810ULL, 0x000fc40007ffe0ffULL, 0x0000000608477810ULL, 0x000fe20007ffe0ffULL,
0x0000000145447824ULL, 0x040fe200078e0202ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee242ULL,
0x00000010454d7824ULL, 0x000fe400078e00ffULL, 0x0000000108427824ULL, 0x000fe200078e0243ULL,
0x000160004c4c7811ULL, 0x000fe200078e20ffULL, 0x0000000143087824ULL, 0x000fe200078e0245ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee244ULL, 0x0000000146457824ULL, 0x000fe200078e0202ULL,
0x0000004142447210ULL, 0x000fe20007f7e0ffULL, 0x0000000143427824ULL, 0x000fe200078e0246ULL,
0x0000000841497210ULL, 0x000fe20007f1e0ffULL, 0x0000000143437824ULL, 0x000fe200078e0247ULL,
0x00005e0044487a11ULL, 0x000fe200078840ffULL, 0x00000010464e7824ULL, 0x000fe200078e00ffULL,
0x0000004241427210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x0000004341437210ULL, 0x000fe20007f7e0ffULL, 0x0000000147467824ULL, 0x040fe200078e0202ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee245ULL, 0x00000010474f7824ULL, 0x000fe200078e00ffULL,
0x00005f00444a7a11ULL, 0x000fe200020f4408ULL, 0x000000ffff417224ULL, 0x000fe200000e06ffULL,
0x00005e0049087a11ULL, 0x000fe200078040ffULL, 0x000000ffff457224ULL, 0x000fe200010e06ffULL,
0x00005e0042447a11ULL, 0x000fe200078440ffULL, 0x000000ffff477224ULL, 0x000fe200018e06ffULL,
0xfffffff04f4f7812ULL, 0x000fc400078ee246ULL, 0x0000004b48487210ULL, 0x080fe40007f9e0ffULL,
0x00005e0043467a11ULL, 0x000fe400078640ffULL, 0x00005f0049417a11ULL, 0x000fe200000f4441ULL,
0x000000ffff497224ULL, 0x000fe200020e064aULL, 0x00005f0042457a11ULL, 0x000fe400010f4445ULL,
0x0000004b08427210ULL, 0x080fe40007f1e0ffULL, 0x00005f0043477a11ULL, 0x000fe200018f4447ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000484c7faeULL, 0x0003e2000b901c46ULL,
0x0000004b44447210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0641ULL,
0x0000004b46467210ULL, 0x000fc40007f7e0ffULL, 0x000160004d087811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200010e0645ULL, 0x000160004e417811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe400018e0647ULL, 0x0000000042087faeULL, 0x0005e2000b901c46ULL,
0x000160004f487811ULL, 0x002fc600078e20ffULL, 0x0000000044417faeULL, 0x0005e8000b901c46ULL,
0x0000000046487faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000020c087810ULL, 0x000fc80007ffe0ffULL, 0x000000050800720cULL, 0x000fe20003f06070ULL,
0xffffffffff087424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000020a427810ULL, 0x002fe20007ffe00cULL, 0x00000004ff437424ULL, 0x000fc800078e00ffULL,
0x0000600042427625ULL, 0x000fca00078e0043ULL, 0x0000000642087981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff527f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186280007467f8cULL, 0x0022e4000c80043fULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x01862c0007417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x00afe40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011445ULL, 0x0000004441417211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000241417819ULL, 0x000fc80000001244ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01862c0007417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018080000e417984ULL, 0x000e680000000800ULL,
0x018280000e447984ULL, 0x0006a20000000800ULL, 0x000000544100720bULL, 0x002fe20003f1d000ULL,
0x000138a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000457806ULL, 0x008fc800000e0100ULL,
0x0000ffff45ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff467424ULL, 0x000fc400078e00ffULL, 0x000000ffff507224ULL, 0x000fd200078e0054ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x000000544100720bULL, 0x000fe20003f54000ULL, 0x000138727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000467806ULL, 0x000fc400010e0100ULL, 0x0000005441428209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x018480420e008388ULL, 0x0003e40000000800ULL,
0x0000991046427816ULL, 0x002fc800000000ffULL, 0x000000ff4200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000005441427209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff46ff7812ULL, 0x000fc6000780c0ffULL,
0x0000005442427221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL,
0x00000042005a7308ULL, 0x000e640000000800ULL, 0x0000005a09097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff427819ULL, 0x000fe20000011602ULL,
0x000137c27f007947ULL, 0x000fea000b800000ULL, 0x00001f425a427589ULL, 0x0002e400000e0000ULL,
0x000000421c1c7220ULL, 0x088fe40000410000ULL, 0x000000421d1d7220ULL, 0x080fe40000410000ULL,
0x0000004224247220ULL, 0x080fe40000410000ULL, 0x0000004225257220ULL, 0x000fc40000410000ULL,
0x0000004228287220ULL, 0x080fe40000410000ULL, 0x0000004229297220ULL, 0x080fe40000410000ULL,
0x000000422c2c7220ULL, 0x080fe40000410000ULL, 0x000000422d2d7220ULL, 0x080fe40000410000ULL,
0x0000004234347220ULL, 0x080fe40000410000ULL, 0x0000004235357220ULL, 0x000fc40000410000ULL,
0x0000004230307220ULL, 0x080fe40000410000ULL, 0x0000004231317220ULL, 0x080fe40000410000ULL,
0x0000004238387220ULL, 0x080fe40000410000ULL, 0x0000004239397220ULL, 0x080fe40000410000ULL,
0x000000423c3c7220ULL, 0x080fe40000410000ULL, 0x000000423d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0046ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802427811ULL, 0x000fe200078ff0ffULL,
0x000136d27f007947ULL, 0x000fea000b800000ULL, 0x00001f425a427589ULL, 0x00066400000e0000ULL,
0x000000421e1e7220ULL, 0x082fe40000410000ULL, 0x000000421f1f7220ULL, 0x080fe40000410000ULL,
0x0000004226267220ULL, 0x080fe40000410000ULL, 0x0000004227277220ULL, 0x080fe40000410000ULL,
0x000000422a2a7220ULL, 0x080fe40000410000ULL, 0x000000422b2b7220ULL, 0x000fc40000410000ULL,
0x000000422e2e7220ULL, 0x080fe40000410000ULL, 0x000000422f2f7220ULL, 0x080fe40000410000ULL,
0x0000004236367220ULL, 0x080fe40000410000ULL, 0x0000004237377220ULL, 0x080fe40000410000ULL,
0x0000004232327220ULL, 0x080fe40000410000ULL, 0x0000004233337220ULL, 0x000fc40000410000ULL,
0x000000423a3a7220ULL, 0x080fe40000410000ULL, 0x000000423b3b7220ULL, 0x080fe40000410000ULL,
0x000000423e3e7220ULL, 0x080fe40000410000ULL, 0x000000423f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff46ff7812ULL, 0x000fe20007800845ULL,
0x00000001ff467424ULL, 0x000fe200078e00ffULL, 0x0000005441547209ULL, 0x000fca0007810000ULL,
0x000000ffff507224ULL, 0x000fcc00078e0054ULL, 0x8000005441410221ULL, 0x000fe20000010000ULL,
0x00007610ff460816ULL, 0x000fe20000000046ULL, 0x000000ffff500224ULL, 0x000fe400078e0054ULL,
0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL, 0x00000041000f0308ULL, 0x000e640000000800ULL,
0x0000000f44440220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000944097221ULL, 0x004fc40000010000ULL, 0x0000000000427805ULL, 0x000fca0000015200ULL,
0x0186ac00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804840ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442447210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011445ULL,
0x0000004441417211ULL, 0x000fca00078110ffULL, 0x000000ffff447224ULL, 0x000fca00000e0645ULL,
0x0000000241417819ULL, 0x000fc80000001244ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804840ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991046407816ULL, 0x000fe200000000ffULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000ff4000720cULL, 0x000fda0003f45270ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000fff10723eULL, 0x000fe400000000ffULL, 0x00000002ff407819ULL, 0x000fe40000011602ULL,
0x00005410105a7816ULL, 0x008fe20000000010ULL, 0x000132b27f007947ULL, 0x000fea000b800000ULL,
0x00001f405a107589ULL, 0x0002a400000e0000ULL, 0x0000000840117810ULL, 0x000fe20007ffe0ffULL,
0x000132f27f007947ULL, 0x000fea000b800000ULL, 0x00001f115a117589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001040597810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x00006f0000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x0001409000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001840597810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x00006f6000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff517424ULL, 0x004fc400078e00ffULL, 0x0001403000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000134c783bULL, 0x000ee80000004200ULL, 0x000000001444783bULL, 0x000ea80000004200ULL,
0x000000001548783bULL, 0x000e620000004200ULL, 0x00000018ff607819ULL, 0x008fe2000001144fULL,
0x000001004f6a7824ULL, 0x040fe200078e00ffULL, 0x000088804f697816ULL, 0x040fe200000000ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001144eULL,
0x000001004e687824ULL, 0x040fe200078e00ffULL, 0x000088804e677816ULL, 0x040fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x000001004c627824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x000001004d657824ULL, 0x000fe200078e00ffULL, 0x0000004f006c7306ULL, 0x0007e20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fc4000001144eULL, 0x00000018ff5d7819ULL, 0x004fe40000011445ULL,
0x00000018ff5e7819ULL, 0x000fe40000011444ULL, 0x00000018ff5b7819ULL, 0x000fe20000011446ULL,
0x0000006a006b7306ULL, 0x000fe20000200c00ULL, 0x00000100444f7824ULL, 0x008fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011447ULL, 0x00000018ff407819ULL, 0x002fe4000001144cULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x0000004e006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff597819ULL, 0x000fe40000011448ULL, 0x00000018ff5a7819ULL, 0x000fe40000011449ULL,
0x000088804c617816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0000004f006e7306ULL, 0x0005e20000200c00ULL,
0x00008880444e7816ULL, 0x042fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x000088804d647816ULL, 0x000fc400000000ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000004e006d7306ULL, 0x0002e20000200c00ULL,
0x00000100454f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff577819ULL, 0x000fe4000001144aULL, 0x00000018ff587819ULL, 0x000fe4000001144bULL,
0x0000004400707306ULL, 0x0005e20000200c00ULL, 0x00008880454e7816ULL, 0x042fe200000000ffULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fc40000011468ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000004000637306ULL, 0x0003e20000200c00ULL, 0x0000888046447816ULL, 0x004fe400000000ffULL,
0x000054106d6e7816ULL, 0x008fca000000006eULL, 0x0000004500727306ULL, 0x0005e20000200c00ULL,
0x00000018ff407819ULL, 0x002fe2000001144dULL, 0x000100004d4d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004400737306ULL, 0x0003e20000200c00ULL,
0x0000010046457824ULL, 0x044fe400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000004e006f7306ULL, 0x0005e20000200c00ULL, 0x0000888047447816ULL, 0x002fce00000000ffULL,
0x0000004500747306ULL, 0x0002e20000200c00ULL, 0x00008880494e7816ULL, 0x004fce00000000ffULL,
0x0000004400757306ULL, 0x0005e20000200c00ULL, 0x0000010047457824ULL, 0x042fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000004600767306ULL, 0x000fe20000200c00ULL,
0x0000888048447816ULL, 0x004fe400000000ffULL, 0x0000541073747816ULL, 0x008fca0000000074ULL,
0x0000004500777306ULL, 0x0002b00000200c00ULL, 0x0000004400797306ULL, 0x0007e20000200c00ULL,
0x0000010048457824ULL, 0x042fe400078e00ffULL, 0x0001000048487824ULL, 0x000fc600078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004700787306ULL, 0x000fe20000200c00ULL,
0x0001280017447811ULL, 0x008fe400078e20ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000541075757816ULL, 0x004fc60000000077ULL, 0x00000045007a7306ULL, 0x0003f00000200c00ULL,
0x0000004000667306ULL, 0x0005e20000200c00ULL, 0x000000004444783bULL, 0x002e6e0000000200ULL,
0x00000048007b7306ULL, 0x0007e20000200c00ULL, 0x000000001640783bULL, 0x004eae0000004200ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000000ffff487224ULL, 0x008fc400078e004eULL,
0x00000100494e7824ULL, 0x040fe400078e00ffULL, 0x0001000049497824ULL, 0x000fc600078e00ffULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff497819ULL, 0x000fca0000011449ULL, 0x00000049007e7306ULL, 0x0007f00000200c00ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000001004a497824ULL, 0x008fe200078e00ffULL,
0x000000104444a232ULL, 0x002fc40000000000ULL, 0x000000104646a232ULL, 0x000fe40000000000ULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x000000114545a232ULL, 0x080fe20000000000ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000000114747a232ULL, 0x000fe20000000000ULL,
0x00000018ff557819ULL, 0x004fe40000011440ULL, 0x00000018ff517819ULL, 0x000fe40000011442ULL,
0x00000018ff547819ULL, 0x000fc40000011443ULL, 0x00000048007c7306ULL, 0x0003e20000200c00ULL,
0x000000744438723cULL, 0x000fe20000001838ULL, 0x00000018ff567819ULL, 0x000fcc0000011441ULL,
0x0000004900807306ULL, 0x0005e20000200c00ULL, 0x000088804a487816ULL, 0x042fe200000000ffULL,
0x000100004a4a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x000001004b497824ULL, 0x004fca00078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000004d004d7306ULL, 0x000eb00000200c00ULL,
0x00000048007f7306ULL, 0x0006a20000200c00ULL, 0x000054104c4c7816ULL, 0x002fce0000000063ULL,
0x0000004900837306ULL, 0x0003e20000200c00ULL, 0x000088804b487816ULL, 0x008fe400000000ffULL,
0x000054104d4d7816ULL, 0x004fca0000000066ULL, 0x0000004800817306ULL, 0x0004e20000200c00ULL,
0x0000541064497816ULL, 0x002fe40000000065ULL, 0x000054107f807816ULL, 0x000fca0000000080ULL,
0x0000004e007d7306ULL, 0x0003e20000200c00ULL, 0x0000541061487816ULL, 0x004fce0000000062ULL,
0x0000004a00827306ULL, 0x0005e20000200c00ULL, 0x000100004b4e7824ULL, 0x002fe200078e00ffULL,
0x0000541081817816ULL, 0x008fc80000000083ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x000000484448723cULL, 0x004bee000000181cULL,
0x00008880401c7816ULL, 0x060fe200000000ffULL, 0x00000100401d7824ULL, 0x040fe200078e00ffULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x000054106a6a7816ULL, 0x002fcc000000005fULL, 0x0000001c00627306ULL, 0x0003e20000200c00ULL,
0x00000018ff407819ULL, 0x000fce0000011440ULL, 0x0000006000607306ULL, 0x000ee20000200c00ULL,
0x00012800181c7811ULL, 0x002fe400078e20ffULL, 0x0000541069697816ULL, 0x004fca000000006bULL,
0x0000005e005e7306ULL, 0x000e700000200c00ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x000054106c6b7816ULL, 0x008fce0000000060ULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x00005410705e7816ULL, 0x002fe2000000005eULL, 0x0000006a442c723cULL, 0x000fec000000182cULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x00005410725f7816ULL, 0x004fce000000005dULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541076767816ULL, 0x008fe2000000005bULL,
0x0000005e4430723cULL, 0x000fec0000001830ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000541078777816ULL, 0x002fce000000005cULL, 0x0000004f00717306ULL, 0x000e620000200c00ULL,
0x00000076443c723cULL, 0x040fee000000183cULL, 0x0000004e00617306ULL, 0x0007e20000200c00ULL,
0x0000541067687816ULL, 0x004fe40000000068ULL, 0x000054106f6f7816ULL, 0x002fe20000000071ULL,
0x0000004c444c723cULL, 0x048be80000001824ULL, 0x00000040005d7306ULL, 0x0003e60000200c00ULL,
0x00000018ff247819ULL, 0x020fe2000001141dULL, 0x000000684428723cULL, 0x000f620000001828ULL,
0x000000001c1c783bULL, 0x000ea20000000200ULL, 0x0000888041257816ULL, 0x000fc400000000ffULL,
0x0000002400637306ULL, 0x0006e20000200c00ULL, 0x0000888043407816ULL, 0x002fc600000000ffULL,
0x0000006e4434723cULL, 0x000b680000001834ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000000ffff247224ULL, 0x008fe400078e0025ULL, 0x0000010041257824ULL, 0x000fe400078e00ffULL,
0x0000010043467824ULL, 0x060fe400078e00ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000002400607306ULL, 0x0003e20000200c00ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fc40000011446ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000002500647306ULL, 0x0006a20000200c00ULL, 0x0000888042247816ULL, 0x002fe400000000ffULL,
0x0000541062627816ULL, 0x000fca0000000063ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000010042257824ULL, 0x048fe400078e00ffULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x000000101c1ca232ULL, 0x084fe40000000000ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x000000101e1ea232ULL, 0x000fe20000000000ULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000002400447306ULL, 0x0003e20000200c00ULL, 0x000000111d1da232ULL, 0x080fe20000000000ULL,
0x0000541060637816ULL, 0x000fe20000000064ULL, 0x000000111f1fa232ULL, 0x000fca0000000000ULL,
0x0000002500457306ULL, 0x0004e20000200c00ULL, 0x0000541079247816ULL, 0x002fe2000000007aULL,
0x000000801c28723cULL, 0x040f6c0000001828ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x000054107c257816ULL, 0x004fe2000000007dULL, 0x000000621c34723cULL, 0x040f6c0000001834ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x0000541044447816ULL, 0x008fe20000000045ULL,
0x000000241c24723cULL, 0x000f6c0000001848ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x0000541082827816ULL, 0x002fce0000000057ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000541061837816ULL, 0x004fce0000000058ULL, 0x00000041005e7306ULL, 0x0002a20000200c00ULL,
0x000000821c2c723cULL, 0x000f6e000000182cULL, 0x0000004000477306ULL, 0x0005e20000200c00ULL,
0x000054107e417816ULL, 0x002fce000000005aULL, 0x0000004600467306ULL, 0x000e620000200c00ULL,
0x000054107b407816ULL, 0x004fce0000000059ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x000000401c4c723cULL, 0x000b6e000000184cULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000054105d407816ULL, 0x028fe40000000055ULL, 0x000054105e417816ULL, 0x000fc40000000056ULL,
0x0000541047457816ULL, 0x002fc60000000046ULL, 0x0000004200427306ULL, 0x000e640000200c00ULL,
0x000000401c30723cULL, 0x040b6c0000001830ULL, 0x0000004300437306ULL, 0x000ea40000200c00ULL,
0x000000441c38723cULL, 0x000b620000001838ULL, 0x0000541042427816ULL, 0x002fc40000000051ULL,
0x0000541043437816ULL, 0x004fce0000000054ULL, 0x000000421c1c723cULL, 0x000b62000000183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff407f8cULL, 0x020e62000c80043fULL,
0x000000ffff437224ULL, 0x000fce00078e00ffULL, 0x00000000003c7805ULL, 0x000fc40000015200ULL,
0x0186bc00ff3e7984ULL, 0x000ea40000000800ULL, 0x800000003eff7812ULL, 0x006fe40007804841ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c427210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000423e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000143437810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580008417a24ULL, 0x010fc800078e02ffULL,
0x0000004041417824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000040193c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001073e7824ULL, 0x000fe200078e0212ULL,
0x0000000212497810ULL, 0x000fe40007ffe0ffULL, 0x0000003c043d7217ULL, 0x000fe20007800000ULL,
0x0000004003467824ULL, 0x000fe200078e023eULL, 0x00000004124b7810ULL, 0x000fe20007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe200078e0202ULL, 0x000000f00d477812ULL, 0x000fe200078ec0ffULL,
0x000000103e487824ULL, 0x000fe200078e00ffULL, 0x0000004146437210ULL, 0x040fe20007f1e0ffULL,
0x00000001073e7824ULL, 0x000fe200078e0249ULL, 0x0000000246457810ULL, 0x000fe20007ffe0ffULL,
0x000000013d3d7824ULL, 0x000fe200078e0a3cULL, 0xfffffff048487812ULL, 0x000fe200078ee23fULL,
0x00000001073c7824ULL, 0x040fe200078e024bULL, 0x0000000446447810ULL, 0x000fe20007ffe0ffULL,
0x000000013e3f7824ULL, 0x140fe200078e0202ULL, 0x0000003d073d7217ULL, 0x000fe20007800000ULL,
0x000000103e4a7824ULL, 0x000fe200078e00ffULL, 0x0000004144447210ULL, 0x000fe20007f7e0ffULL,
0x000000013c3e7824ULL, 0x000fe200078e0202ULL, 0x0001400048487811ULL, 0x000fe200078e20ffULL,
0x000000103c517824ULL, 0x000fe200078e00ffULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee23fULL,
0x000000ffff3c7224ULL, 0x000fe200000e06ffULL, 0x00005e0043407a11ULL, 0x000fe200078040ffULL,
0x000000013d3f7824ULL, 0x000fe200078e0a07ULL, 0xfffffff051517812ULL, 0x000fe200078ee23eULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005f0043437a11ULL, 0x000fc400000f443cULL,
0x0000004145457210ULL, 0x000fe40007f1e0ffULL, 0x0000003f1200720cULL, 0x000fe40003f86070ULL,
0x00005e00443e7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x00005e0045427a11ULL, 0x040fe400078040ffULL, 0x00005f0044447a11ULL, 0x000fe400028f443dULL,
0x00005f0045457a11ULL, 0x000fc400000f443cULL, 0x00000047403c7210ULL, 0x000fe40007f7e0ffULL,
0x0000003f4900720cULL, 0x080fe40003f06070ULL, 0x0000000612497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e0643ULL, 0x0000000646407810ULL, 0x000fe40007ffe0ffULL,
0x0000003f4b00720cULL, 0x000fe20003f66070ULL, 0x0000000107437824ULL, 0x000fe200078e0249ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c487faeULL, 0x0003e2000e101c46ULL,
0x0000004140407210ULL, 0x000fc40007f9e0ffULL, 0x0000000143467824ULL, 0x000fe200078e0202ULL,
0x000000473e3e7210ULL, 0x080fe40007fde0ffULL, 0x000140004a4a7811ULL, 0x000fe400078e20ffULL,
0x0001400051517811ULL, 0x000fe400078e20ffULL, 0x00000047423c7210ULL, 0x002fe20007fbe0ffULL,
0x0000001043487824ULL, 0x000fe400078e00ffULL, 0x000000ffff437224ULL, 0x000fe200020e06ffULL,
0x00005e0040427a11ULL, 0x040fe200078840ffULL, 0x000000ffff3d7224ULL, 0x000fe200028e0645ULL,
0x0000003f4900720cULL, 0x000fe20003fa6070ULL, 0x000000ffff3f7224ULL, 0x000fe200030e0644ULL,
0x00005f0040407a11ULL, 0x000fc400020f4443ULL, 0x0000004742427210ULL, 0x000fe20007f9e0ffULL,
0x000000003c4a7faeULL, 0x0003e2000c101c46ULL, 0xfffffff048467812ULL, 0x000fc600078ee246ULL,
0x000000ffff437224ULL, 0x000fe200020e0640ULL, 0x0001400046467811ULL, 0x000fe200078e20ffULL,
0x000000003e517faeULL, 0x0003e8000d901c46ULL, 0x0000000042467faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x00000001073c7824ULL, 0x000fe200078e0212ULL,
0x000000f00d447812ULL, 0x000fc600078ec0ffULL, 0x000000013c3d7824ULL, 0x040fe200078e0202ULL,
0x000000023c3e7810ULL, 0x040fe20007ffe0ffULL, 0x000000103c407824ULL, 0x000fc800078e00ffULL,
0x000000013e3f7824ULL, 0x000fe200078e0202ULL, 0xfffffff040407812ULL, 0x000fe200078ee23dULL,
0x000000103e457824ULL, 0x000fe200078e00ffULL, 0x000000043c3e7810ULL, 0x000fe20007ffe0ffULL,
0x00000040033d7824ULL, 0x000fe200078e023cULL, 0x0001400040407811ULL, 0x000fe400078e20ffULL,
0xfffffff045457812ULL, 0x000fe200078ee23fULL, 0x000000013e427824ULL, 0x000fe200078e0202ULL,
0x000000063c3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000103e497824ULL, 0x000fe200078e00ffULL,
0x000000413d3c7210ULL, 0x000fc60007f1e0ffULL, 0x000000013f437824ULL, 0x000fe200078e0202ULL,
0xfffffff049497812ULL, 0x000fe200078ee242ULL, 0x000000103f547824ULL, 0x000fe200078e00ffULL,
0x000000023d427810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff3e7224ULL, 0x000fe200000e06ffULL,
0x00005e003c3f7a11ULL, 0x000fe400078040ffULL, 0xfffffff054547812ULL, 0x000fe400078ee243ULL,
0x00005f003c3e7a11ULL, 0x000fe400000f443eULL, 0x000000043d3c7810ULL, 0x000fc40007ffe0ffULL,
0x000000063d3d7810ULL, 0x000fe40007ffe0ffULL, 0x0000004142427210ULL, 0x080fe40007f1e0ffULL,
0x000000413c467210ULL, 0x080fe40007f7e0ffULL, 0x000000413d4a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e06ffULL, 0x00005e0042437a11ULL, 0x000fe200078040ffULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x000000443f3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200028e06ffULL, 0x00005e0046487a11ULL, 0x000fc400078840ffULL,
0x00005e004a517a11ULL, 0x000fe400078a40ffULL, 0x00005f00423f7a11ULL, 0x000fe200000f443dULL,
0x000000ffff3d7224ULL, 0x000fe200018e063eULL, 0x00000044433e7210ULL, 0x080fe40007f1e0ffULL,
0x00005f0046477a11ULL, 0x000fe400020f4447ULL, 0x0000004448427210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c407faeULL, 0x0003e2000b901c46ULL,
0x00005f004a4b7a11ULL, 0x000fe200028f444bULL, 0x000000ffff3f7224ULL, 0x000fe200000e063fULL,
0x0000004451447210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff437224ULL, 0x000fe200018e0647ULL,
0x0001400049497811ULL, 0x000fc400078e20ffULL, 0x0001400054547811ULL, 0x000fe400078e20ffULL,
0x00014000453c7811ULL, 0x002fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fc800020e064bULL,
0x000000003e3c7faeULL, 0x0003e8000b901c46ULL, 0x0000000042497faeULL, 0x0003e8000b901c46ULL,
0x0000000044547faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff3c7f8cULL, 0x000e64000c80043fULL,
0x000000ffff407224ULL, 0x002fc400078e003dULL, 0x00000000003c7805ULL, 0x000fca0000015200ULL,
0x0186b400ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fc40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff437224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c427210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004200780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404200780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000423e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000143437810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000016000007945ULL, 0x000fe20003800000ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000fff10723eULL, 0x000fe400000000ffULL, 0x00000002ff3c7819ULL, 0x000fe40000011602ULL,
0x00005410105a7816ULL, 0x000fe20000000010ULL, 0x000116927f007947ULL, 0x000fea000b800000ULL,
0x00001f3c5a107589ULL, 0x0002a400000e0000ULL, 0x000000083c117810ULL, 0x000fe20007ffe0ffULL,
0x000116d27f007947ULL, 0x000fea000b800000ULL, 0x00001f115a117589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000103c597810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x00008c0000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x0001239000007944ULL, 0x00efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000183c597810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff437424ULL, 0x000fe200078e00ffULL, 0x00008c6000427802ULL, 0x000fe20000000f00ULL,
0xffffffffff517424ULL, 0x004fc400078e00ffULL, 0x0001233000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002148783bULL, 0x000f280000004200ULL, 0x000000001a44783bULL, 0x000fe80000004200ULL,
0x000000002054783bULL, 0x000ee20000004200ULL, 0x00000018ff5d7819ULL, 0x010fe20000011449ULL,
0x00000100496e7824ULL, 0x040fe200078e00ffULL, 0x00008880496d7816ULL, 0x040fe200000000ffULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011448ULL,
0x00000100486c7824ULL, 0x040fe200078e00ffULL, 0x00008880486b7816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000010054627824ULL, 0x008fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001146eULL,
0x0000010055657824ULL, 0x000fe200078e00ffULL, 0x0000004900707306ULL, 0x0007e20000200c00ULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000010056687824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001144aULL, 0x00000100576a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fc4000001144bULL, 0x00000018ff3c7819ULL, 0x002fe20000011454ULL,
0x0000006e006f7306ULL, 0x000fe20000200c00ULL, 0x000001004a497824ULL, 0x008fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011444ULL, 0x0000888054617816ULL, 0x040fe200000000ffULL,
0x0001000054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000048006e7306ULL, 0x0003e20000200c00ULL, 0x0000888055637816ULL, 0x000fc400000000ffULL,
0x00008880457a7816ULL, 0x000fe400000000ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011445ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000004900727306ULL, 0x0007e20000200c00ULL,
0x000088804a487816ULL, 0x042fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000018ff537819ULL, 0x000fc40000011446ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000004800717306ULL, 0x0003220000200c00ULL,
0x000001004b497824ULL, 0x048fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011447ULL,
0x00000018ff5f7819ULL, 0x000fe40000011456ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000003c00647306ULL, 0x0007e20000200c00ULL, 0x000088804b487816ULL, 0x042fe200000000ffULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x0000888056677816ULL, 0x040fe200000000ffULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fc40000011457ULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000004800737306ULL, 0x0003e20000200c00ULL,
0x00000018ff3c7819ULL, 0x008fe20000011455ULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x0000888057697816ULL, 0x040fe200000000ffULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000004900757306ULL, 0x0006a20000200c00ULL, 0x0000888044487816ULL, 0x002fc400000000ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000004800777306ULL, 0x0003e20000200c00ULL,
0x0000010044497824ULL, 0x048fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff497819ULL, 0x000fc40000011449ULL, 0x0000004a00747306ULL, 0x000fe20000200c00ULL,
0x0001280022487811ULL, 0x002fe400078e20ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000541071727816ULL, 0x010fe40000000072ULL, 0x0000541073737816ULL, 0x004fe20000000075ULL,
0x0000004b00767306ULL, 0x000ff00000200c00ULL, 0x0000004900787306ULL, 0x0003f00000200c00ULL,
0x0000003c00667306ULL, 0x0005e20000200c00ULL, 0x000000004848783bULL, 0x002e6e0000000200ULL,
0x0000004400797306ULL, 0x0007e20000200c00ULL, 0x000000001b3c783bULL, 0x004eae0000004200ULL,
0x0000005400547306ULL, 0x000f220000200c00ULL, 0x000000ffff447224ULL, 0x008fc400078e007aULL,
0x00000100457a7824ULL, 0x040fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff457819ULL, 0x000fca0000011445ULL, 0x00000045007c7306ULL, 0x0003e20000200c00ULL,
0x0000541054547816ULL, 0x010fce0000000064ULL, 0x00000044007b7306ULL, 0x0009e20000200c00ULL,
0x0000010046457824ULL, 0x042fe200078e00ffULL, 0x000000104848a232ULL, 0x080fe20000000000ULL,
0x0000541055557816ULL, 0x008fe20000000066ULL, 0x000000104a4aa232ULL, 0x000fe40000000000ULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x000000114949a232ULL, 0x080fe20000000000ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000888046447816ULL, 0x050fe200000000ffULL,
0x000000114b4ba232ULL, 0x000fe20000000000ULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x004fc4000001143cULL, 0x00000018ff527819ULL, 0x000fe4000001143dULL,
0x0000006200627306ULL, 0x000e620000200c00ULL, 0x00000054484c723cULL, 0x040be2000000184cULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff427819ULL, 0x000fe4000001143eULL,
0x00000018ff437819ULL, 0x000fe4000001143fULL, 0x00000044007d7306ULL, 0x0005e20000200c00ULL,
0x000000724838723cULL, 0x000fee0000001838ULL, 0x00000045007e7306ULL, 0x0007220000200c00ULL,
0x0000888047447816ULL, 0x004fc400000000ffULL, 0x0000541061627816ULL, 0x002fca0000000062ULL,
0x00000044007f7306ULL, 0x0003e20000200c00ULL, 0x0000010047457824ULL, 0x048fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000004600807306ULL, 0x000fe20000200c00ULL,
0x000088803c447816ULL, 0x002fe400000000ffULL, 0x000054107d7e7816ULL, 0x010fca000000007eULL,
0x0000004500817306ULL, 0x0002b00000200c00ULL, 0x0000004400557306ULL, 0x0207e20000200c00ULL,
0x000001003c457824ULL, 0x042fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011445ULL, 0x0000004700617306ULL, 0x0003e20000200c00ULL,
0x0001280023447811ULL, 0x008fe400078e20ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000054107f7f7816ULL, 0x004fc60000000081ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000000004444783bULL, 0x002e6e0000000200ULL, 0x0000006500657306ULL, 0x000eb00000200c00ULL,
0x0000005f005f7306ULL, 0x000ff00000200c00ULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x0000541063637816ULL, 0x004fce0000000065ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000000624824723cULL, 0x000bee0000001824ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x0000541056567816ULL, 0x008fe2000000005fULL, 0x000000104444a232ULL, 0x082fe20000000000ULL,
0x000088803d627816ULL, 0x020fe200000000ffULL, 0x000000104646a232ULL, 0x000fc40000000000ULL,
0x000000114545a232ULL, 0x080fe40000000000ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x000000114747a232ULL, 0x000fce0000000000ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054106e5e7816ULL, 0x004fce000000005eULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x00005410705f7816ULL, 0x002fe4000000005dULL, 0x000088803e5d7816ULL, 0x000fca00000000ffULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000005e4830723cULL, 0x000fee0000001830ULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x0000541067687816ULL, 0x004fce0000000068ULL,
0x0000005700577306ULL, 0x000eb00000200c00ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000541069697816ULL, 0x002fce000000006aULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x0000541057577816ULL, 0x004fe20000000060ULL, 0x000000684828723cULL, 0x040f6c0000001828ULL,
0x0000006d006d7306ULL, 0x000ea40000200c00ULL, 0x00000056482c723cULL, 0x000b6c000000182cULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x000054106b6c7816ULL, 0x002fe2000000006cULL,
0x000001003d577824ULL, 0x020fc400078e00ffULL, 0x000100003d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff567224ULL, 0x000fe200078e0062ULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x000054106d6d7816ULL, 0x004fe2000000006fULL,
0x0000007e4428723cULL, 0x000fe20000001828ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000541074747816ULL, 0x008fc6000000005bULL, 0x0000007a007a7306ULL, 0x000ea40000200c00ULL,
0x0000006c4834723cULL, 0x040f620000001834ULL, 0x000000ffff5b7224ULL, 0x000fe200078e005dULL,
0x000088803f5d7816ULL, 0x000fe400000000ffULL, 0x0000541076757816ULL, 0x002fe4000000005cULL,
0x0000005100517306ULL, 0x000fea0000200c00ULL, 0x000000744848723cULL, 0x000b66000000181cULL,
0x0000005200527306ULL, 0x000fe80000200c00ULL, 0x000001003e1c7824ULL, 0x060fe200078e00ffULL,
0x000054107b1d7816ULL, 0x004fe2000000007aULL, 0x000100003e3e7824ULL, 0x000fc400078e00ffULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff3e7819ULL, 0x000fca000001143eULL, 0x0000001c005c7306ULL, 0x0005f00000200c00ULL,
0x0000003c003c7306ULL, 0x000ee20000200c00ULL, 0x00005410771c7816ULL, 0x004fe40000000078ULL,
0x0000541055547816ULL, 0x002fca0000000054ULL, 0x0000001c441c723cULL, 0x000b620000001824ULL,
0x0000003d003d7306ULL, 0x000e6c0000200c00ULL, 0x000000ffff247224ULL, 0x020fe200078e005dULL,
0x000054103c3c7816ULL, 0x008fe20000000051ULL, 0x000001003f5d7824ULL, 0x040fe200078e00ffULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x000054103d3d7816ULL, 0x002fce0000000052ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x0000003c4430723cULL, 0x000b6e0000001830ULL,
0x0000005800587306ULL, 0x000ee20000200c00ULL, 0x000054107c257816ULL, 0x004fce000000005aULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000541080807816ULL, 0x002fce0000000053ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x0000541061817816ULL, 0x008fce0000000058ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x00000080442c723cULL, 0x000b6e000000182cULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x0000005b005b7306ULL, 0x000eb00000200c00ULL,
0x00000024005e7306ULL, 0x0007e20000200c00ULL, 0x0000541056557816ULL, 0x002fce0000000057ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x0000541079247816ULL, 0x008fe20000000059ULL,
0x000000544434723cULL, 0x000b620000001834ULL, 0x000054105b5c7816ULL, 0x004fca000000005cULL,
0x0000003e003e7306ULL, 0x000ea40000200c00ULL, 0x000000244424723cULL, 0x000b6c000000184cULL,
0x0000003f003f7306ULL, 0x000ee20000200c00ULL, 0x000054105e5d7816ULL, 0x002fe4000000005dULL,
0x000054103e3e7816ULL, 0x004fca0000000042ULL, 0x0000005c4438723cULL, 0x000b620000001838ULL,
0x000054103f3f7816ULL, 0x008fce0000000043ULL, 0x0000003e443c723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff427f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004019427810ULL, 0x002fe20007ffe0ffULL, 0x01869000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x020fe200078e0043ULL, 0x000000020c557810ULL, 0x000fe40007ffe0ffULL,
0x000000044200720cULL, 0x000fda0003f06070ULL, 0x0000860000000947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x0186bc00ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011445ULL, 0x0000004408087211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000208087819ULL, 0x000fc80000001244ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000147477810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000006019087810ULL, 0x000fe20007ffe0ffULL, 0x0000000107437824ULL, 0x000fe200078e0212ULL,
0x00000004124e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000804427217ULL, 0x000fe20007800000ULL,
0x0000000143447824ULL, 0x040fe200078e0202ULL, 0x0000000212457810ULL, 0x040fe20007ffe0ffULL,
0x00000010434c7824ULL, 0x000fe200078e00ffULL, 0x0000000612517810ULL, 0x000fe20007ffe0ffULL,
0x0000000142427824ULL, 0x000fe200078e0a08ULL, 0x0000002003087811ULL, 0x000fe200078e30ffULL,
0x0000000107477824ULL, 0x040fe200078e024eULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee244ULL,
0x0000000107467824ULL, 0x040fe200078e0245ULL, 0x0000004207427217ULL, 0x000fe20007800000ULL,
0x00000001434a7824ULL, 0x000fe200078e0208ULL, 0x000000f00d4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000147487824ULL, 0x040fe200078e0202ULL, 0x000160004c4c7811ULL, 0x000fe200078e20ffULL,
0x00000010474f7824ULL, 0x000fe200078e00ffULL, 0x000000414a4a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000146497824ULL, 0x000fc400078e0208ULL, 0x0000000146447824ULL, 0x040fe200078e0202ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee248ULL, 0x00000010464d7824ULL, 0x000fe200078e00ffULL,
0x0000004149497210ULL, 0x080fe20007f9e0ffULL, 0x0000000107437824ULL, 0x000fe200078e0251ULL,
0x000160004f4f7811ULL, 0x000fe200078e20ffULL, 0x0000000147477824ULL, 0x000fe200078e0208ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee244ULL, 0x0000000143467824ULL, 0x040fe400078e0208ULL,
0x0000000143487824ULL, 0x000fe200078e0202ULL, 0x0000004147477210ULL, 0x080fe20007f7e0ffULL,
0x0000001043527824ULL, 0x000fe200078e00ffULL, 0x0000004146417210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e06ffULL, 0x00005e004a447a11ULL, 0x000fe200078040ffULL,
0x0000000142087824ULL, 0x000fe200078e0a07ULL, 0xfffffff052527812ULL, 0x000fe200078ee248ULL,
0x000000ffff427224ULL, 0x000fe200020e06ffULL, 0x00005f004a4a7a11ULL, 0x000fe200000f4443ULL,
0x000000ffff437224ULL, 0x000fe200018e06ffULL, 0x00005e0049487a11ULL, 0x000fc400078c40ffULL,
0x000000084500720cULL, 0x080fe40003f06070ULL, 0x00005e0047457a11ULL, 0x000fe400078a40ffULL,
0x000000081200720cULL, 0x000fe40003f86070ULL, 0x00005f0049497a11ULL, 0x000fe400030f4442ULL,
0x0000004b44427210ULL, 0x000fe20007fde0ffULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x00005f0047477a11ULL, 0x000fc400028f4443ULL, 0x00005e0041467a11ULL, 0x000fe200078a40ffULL,
0x000000ffff437224ULL, 0x000fe200030e064aULL, 0x000000084e00720cULL, 0x080fe40003f66070ULL,
0x000000085100720cULL, 0x000fe40003f46070ULL, 0x00005f0041087a11ULL, 0x000fe200028f4444ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000424c7faeULL, 0x0003e2000e101c46ULL,
0x0000004b48447210ULL, 0x000fe40007fbe0ffULL, 0x000160004d4d7811ULL, 0x000fc400078e20ffULL,
0x0001600052527811ULL, 0x000fe400078e20ffULL, 0x0000004b45427210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff457224ULL, 0x000fe200028e0649ULL, 0x0000004b46467210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff437224ULL, 0x000fe200020e0647ULL, 0x00000000444d7faeULL, 0x0003e2000c101c46ULL,
0x000000ffff477224ULL, 0x000fc600028e0608ULL, 0x00000000424f7faeULL, 0x0003e8000d901c46ULL,
0x0000000046527faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0212ULL, 0x0000002003427811ULL, 0x000fe400078e30ffULL,
0x000000f00d4b7812ULL, 0x000fe200078ec0ffULL, 0x0000000108437824ULL, 0x040fe200078e0202ULL,
0x0000000208447810ULL, 0x040fe20007ffe0ffULL, 0x00000010084c7824ULL, 0x040fe200078e00ffULL,
0x0000000608467810ULL, 0x000fc60007ffe0ffULL, 0x0000000144457824ULL, 0x000fe200078e0202ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee243ULL, 0x00000010444d7824ULL, 0x000fe400078e00ffULL,
0x0000000108437824ULL, 0x000fe200078e0242ULL, 0x000160004c4c7811ULL, 0x000fe200078e20ffULL,
0x0000000142477824ULL, 0x040fe200078e0244ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee245ULL,
0x0000000142497824ULL, 0x000fe200078e0246ULL, 0x0000000408457810ULL, 0x000fe20007ffe0ffULL,
0x00000001464a7824ULL, 0x140fe200078e0202ULL, 0x0000004143437210ULL, 0x080fe20007f7e0ffULL,
0x00000010464f7824ULL, 0x000fe200078e00ffULL, 0x0000004147477210ULL, 0x080fe20007f1e0ffULL,
0x0000000142087824ULL, 0x000fe200078e0245ULL, 0x00005e0043487a11ULL, 0x000fe200078840ffULL,
0x0000000145447824ULL, 0x000fe200078e0202ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee24aULL,
0x00000010454e7824ULL, 0x000fe200078e00ffULL, 0x0000004108457210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff427224ULL, 0x000fe200018e06ffULL, 0x0000004149087210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0xfffffff04e4e7812ULL, 0x000fc400078ee244ULL,
0x00005f00434a7a11ULL, 0x000fe200020f4442ULL, 0x000000ffff427224ULL, 0x000fe200010e06ffULL,
0x00005e0047437a11ULL, 0x000fe200078040ffULL, 0x000000ffff417224ULL, 0x000fe200018e06ffULL,
0x00005e0045447a11ULL, 0x000fe400078440ffULL, 0x00005e0008467a11ULL, 0x000fe400078640ffULL,
0x0000004b48487210ULL, 0x000fe40007f9e0ffULL, 0x00005f0047477a11ULL, 0x000fc400000f4449ULL,
0x00005f0045457a11ULL, 0x000fe200010f4442ULL, 0x000000ffff497224ULL, 0x000fe200020e064aULL,
0x0000004b43427210ULL, 0x080fe40007f1e0ffULL, 0x00005f0008087a11ULL, 0x000fe400018f4441ULL,
0x0000004b44447210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0647ULL,
0x0000004b46467210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000484c7faeULL, 0x0003e2000b901c46ULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200010e0645ULL, 0x000160004e4e7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200018e0608ULL, 0x000160004f4f7811ULL, 0x000fe200078e20ffULL,
0x00000000424d7faeULL, 0x0003e8000b901c46ULL, 0x00000000444e7faeULL, 0x0003e8000b901c46ULL,
0x00000000464f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000030c427810ULL, 0x002fc80007ffe0ffULL, 0x000000054200720cULL, 0x000fe20003f06070ULL,
0xffffffffff087424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000010a427824ULL, 0x000fe400078e0242ULL, 0x00000004ff437424ULL, 0x000fc800078e00ffULL,
0x0000600042427625ULL, 0x000fca00078e0043ULL, 0x0000000642087981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff527f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186480007467f8cULL, 0x000664000c80043fULL,
0x0000000000427805ULL, 0x002fc40000015200ULL, 0x01864c0007417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011445ULL, 0x0000004441417211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000241417819ULL, 0x000fc80000001244ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01864c0007417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018100000e417984ULL, 0x000e680000000800ULL,
0x018300000e447984ULL, 0x0006a20000000800ULL, 0x000000504100720bULL, 0x002fe20003f1d000ULL,
0x0000f8e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000457806ULL, 0x008fc800000e0100ULL,
0x0000ffff45ff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff467424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000020000780cULL, 0x000fe40003f05270ULL, 0x000000504100720bULL, 0x000fe20003f54000ULL,
0x0000f8c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x000fc400010e0100ULL,
0x0000004150428209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x018500420e008388ULL, 0x0003e40000000800ULL, 0x0000991046427816ULL, 0x002fc800000000ffULL,
0x000000ff4200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004150427209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff46ff7812ULL, 0x000fc6000780c0ffULL, 0x8000004250427221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x00000042005a7308ULL, 0x000e640000000800ULL,
0x0000005a09097220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff427819ULL, 0x000fe20000011602ULL, 0x0000f8127f007947ULL, 0x000fea000b800000ULL,
0x00001f425a427589ULL, 0x0002e400000e0000ULL, 0x000000421c1c7220ULL, 0x088fe40000410000ULL,
0x000000421d1d7220ULL, 0x080fe40000410000ULL, 0x0000004224247220ULL, 0x080fe40000410000ULL,
0x0000004225257220ULL, 0x000fc40000410000ULL, 0x0000004228287220ULL, 0x080fe40000410000ULL,
0x0000004229297220ULL, 0x080fe40000410000ULL, 0x000000422c2c7220ULL, 0x080fe40000410000ULL,
0x000000422d2d7220ULL, 0x080fe40000410000ULL, 0x0000004234347220ULL, 0x080fe40000410000ULL,
0x0000004235357220ULL, 0x000fc40000410000ULL, 0x0000004230307220ULL, 0x080fe40000410000ULL,
0x0000004231317220ULL, 0x080fe40000410000ULL, 0x0000004238387220ULL, 0x080fe40000410000ULL,
0x0000004239397220ULL, 0x080fe40000410000ULL, 0x000000423c3c7220ULL, 0x080fe40000410000ULL,
0x000000423d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0046ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802427811ULL, 0x000fe200078ff0ffULL, 0x0000f7227f007947ULL, 0x000fea000b800000ULL,
0x00001f425a427589ULL, 0x00066400000e0000ULL, 0x000000421e1e7220ULL, 0x082fe40000410000ULL,
0x000000421f1f7220ULL, 0x080fe40000410000ULL, 0x0000004226267220ULL, 0x080fe40000410000ULL,
0x0000004227277220ULL, 0x080fe40000410000ULL, 0x000000422a2a7220ULL, 0x080fe40000410000ULL,
0x000000422b2b7220ULL, 0x000fc40000410000ULL, 0x000000422e2e7220ULL, 0x080fe40000410000ULL,
0x000000422f2f7220ULL, 0x080fe40000410000ULL, 0x0000004236367220ULL, 0x080fe40000410000ULL,
0x0000004237377220ULL, 0x080fe40000410000ULL, 0x0000004232327220ULL, 0x080fe40000410000ULL,
0x0000004233337220ULL, 0x000fc40000410000ULL, 0x000000423a3a7220ULL, 0x080fe40000410000ULL,
0x000000423b3b7220ULL, 0x080fe40000410000ULL, 0x000000423e3e7220ULL, 0x080fe40000410000ULL,
0x000000423f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff46ff7812ULL, 0x000fe20007800845ULL, 0x00000001ff467424ULL, 0x000fe200078e00ffULL,
0x0000004150507209ULL, 0x000fd60007810000ULL, 0x8000005041410221ULL, 0x000fe20000010000ULL,
0x00007610ff460816ULL, 0x000fc60000000046ULL, 0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL,
0x00000041000f0308ULL, 0x000e640000000800ULL, 0x0000000f44440220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000944097221ULL, 0x004fc40000010000ULL,
0x0000000000427805ULL, 0x000fca0000015200ULL, 0x0186ac00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804840ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011445ULL, 0x0000004441417211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000241417819ULL, 0x000fc80000001244ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000147477810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804840ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991046407816ULL, 0x000fe200000000ffULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000ff4000720cULL, 0x000fda0003f45270ULL,
0x0000014000002947ULL, 0x000fea0003800000ULL, 0x0000000fff10723eULL, 0x000fe400000000ffULL,
0x00000002ff407819ULL, 0x000fe40000011602ULL, 0x00005410105a7816ULL, 0x008fe20000000010ULL,
0x0000f3227f007947ULL, 0x000fea000b800000ULL, 0x00001f405a107589ULL, 0x0002a400000e0000ULL,
0x0000000840117810ULL, 0x000fe20007ffe0ffULL, 0x0000f3627f007947ULL, 0x000fea000b800000ULL,
0x00001f115a117589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001040597810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff437424ULL, 0x000fe200078e00ffULL,
0x0000b1f000427802ULL, 0x000fe20000000f00ULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x0000fda000007944ULL, 0x01efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001840597810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff437424ULL, 0x000fe200078e00ffULL,
0x0000b25000427802ULL, 0x000fe20000000f00ULL, 0xffffffffff517424ULL, 0x004fc400078e00ffULL,
0x0000fd4000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000134c783bULL, 0x000ee80000004200ULL,
0x000000001444783bULL, 0x000ea80000004200ULL, 0x000000001548783bULL, 0x000e620000004200ULL,
0x00000018ff607819ULL, 0x008fe2000001144fULL, 0x000001004f6a7824ULL, 0x040fe200078e00ffULL,
0x000088804f697816ULL, 0x040fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001144eULL, 0x000001004e687824ULL, 0x040fe200078e00ffULL,
0x000088804e677816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x000001004c627824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x000001004d657824ULL, 0x000fe200078e00ffULL,
0x0000004f006c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fc4000001144eULL,
0x00000018ff5d7819ULL, 0x004fe40000011445ULL, 0x00000018ff5e7819ULL, 0x000fe40000011444ULL,
0x00000018ff5b7819ULL, 0x000fe20000011446ULL, 0x0000006a006b7306ULL, 0x000fe20000200c00ULL,
0x00000100444f7824ULL, 0x008fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011447ULL,
0x00000018ff407819ULL, 0x002fe4000001144cULL, 0x00000018ff4f7819ULL, 0x000fc4000001144fULL,
0x0000004e006a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff597819ULL, 0x000fe40000011448ULL,
0x00000018ff5a7819ULL, 0x000fe40000011449ULL, 0x000088804c617816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x0000004f006e7306ULL, 0x0005e20000200c00ULL, 0x00008880444e7816ULL, 0x042fe200000000ffULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x000088804d647816ULL, 0x000fc400000000ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000004e006d7306ULL, 0x0002e20000200c00ULL, 0x00000100454f7824ULL, 0x044fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff577819ULL, 0x000fe4000001144aULL,
0x00000018ff587819ULL, 0x000fe4000001144bULL, 0x0000004400707306ULL, 0x0005e20000200c00ULL,
0x00008880454e7816ULL, 0x042fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fc40000011468ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000004000637306ULL, 0x0003e20000200c00ULL,
0x0000888046447816ULL, 0x004fe400000000ffULL, 0x000054106d6e7816ULL, 0x008fca000000006eULL,
0x0000004500727306ULL, 0x0005e20000200c00ULL, 0x00000018ff407819ULL, 0x002fe2000001144dULL,
0x000100004d4d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004400737306ULL, 0x0003e20000200c00ULL, 0x0000010046457824ULL, 0x044fe400078e00ffULL,
0x0001000046467824ULL, 0x000fc600078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000004e006f7306ULL, 0x0005e20000200c00ULL,
0x0000888047447816ULL, 0x002fce00000000ffULL, 0x0000004500747306ULL, 0x0002e20000200c00ULL,
0x00008880494e7816ULL, 0x004fce00000000ffULL, 0x0000004400757306ULL, 0x0005e20000200c00ULL,
0x0000010047457824ULL, 0x042fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000004600767306ULL, 0x000fe20000200c00ULL, 0x0000888048447816ULL, 0x004fe400000000ffULL,
0x0000541073747816ULL, 0x008fca0000000074ULL, 0x0000004500777306ULL, 0x0002b00000200c00ULL,
0x0000004400797306ULL, 0x0007e20000200c00ULL, 0x0000010048457824ULL, 0x042fe400078e00ffULL,
0x0001000048487824ULL, 0x000fc600078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004700787306ULL, 0x000fe20000200c00ULL, 0x0001300017447811ULL, 0x008fe400078e20ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000541075757816ULL, 0x004fc60000000077ULL,
0x00000045007a7306ULL, 0x0003f00000200c00ULL, 0x0000004000667306ULL, 0x0005e20000200c00ULL,
0x000000004444783bULL, 0x002e6e0000000200ULL, 0x00000048007b7306ULL, 0x0007e20000200c00ULL,
0x000000001640783bULL, 0x004eae0000004200ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x000000ffff487224ULL, 0x008fc400078e004eULL, 0x00000100494e7824ULL, 0x040fe400078e00ffULL,
0x0001000049497824ULL, 0x000fc600078e00ffULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff497819ULL, 0x000fca0000011449ULL,
0x00000049007e7306ULL, 0x0007f00000200c00ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000001004a497824ULL, 0x008fe200078e00ffULL, 0x000000104444a232ULL, 0x002fc40000000000ULL,
0x000000104646a232ULL, 0x000fe40000000000ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x000000114545a232ULL, 0x080fe20000000000ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x000000114747a232ULL, 0x000fe20000000000ULL, 0x00000018ff557819ULL, 0x004fe40000011440ULL,
0x00000018ff517819ULL, 0x000fe40000011442ULL, 0x00000018ff547819ULL, 0x000fc40000011443ULL,
0x00000048007c7306ULL, 0x0003e20000200c00ULL, 0x000000744438723cULL, 0x000fe20000001838ULL,
0x00000018ff567819ULL, 0x000fcc0000011441ULL, 0x0000004900807306ULL, 0x0005e20000200c00ULL,
0x000088804a487816ULL, 0x042fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000001004b497824ULL, 0x004fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000004d004d7306ULL, 0x000eb00000200c00ULL, 0x00000048007f7306ULL, 0x0006a20000200c00ULL,
0x000054104c4c7816ULL, 0x002fce0000000063ULL, 0x0000004900837306ULL, 0x0003e20000200c00ULL,
0x000088804b487816ULL, 0x008fe400000000ffULL, 0x000054104d4d7816ULL, 0x004fca0000000066ULL,
0x0000004800817306ULL, 0x0004e20000200c00ULL, 0x0000541064497816ULL, 0x002fe40000000065ULL,
0x000054107f807816ULL, 0x000fca0000000080ULL, 0x0000004e007d7306ULL, 0x0003e20000200c00ULL,
0x0000541061487816ULL, 0x004fce0000000062ULL, 0x0000004a00827306ULL, 0x0005e20000200c00ULL,
0x000100004b4e7824ULL, 0x002fe200078e00ffULL, 0x0000541081817816ULL, 0x008fc80000000083ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x000000484448723cULL, 0x004bee000000181cULL, 0x00008880401c7816ULL, 0x060fe200000000ffULL,
0x00000100401d7824ULL, 0x040fe200078e00ffULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x000054106a6a7816ULL, 0x002fcc000000005fULL,
0x0000001c00627306ULL, 0x0003e20000200c00ULL, 0x00000018ff407819ULL, 0x000fce0000011440ULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x00013000181c7811ULL, 0x002fe400078e20ffULL,
0x0000541069697816ULL, 0x004fca000000006bULL, 0x0000005e005e7306ULL, 0x000e700000200c00ULL,
0x0000005d005d7306ULL, 0x000ea20000200c00ULL, 0x000054106c6b7816ULL, 0x008fce0000000060ULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x00005410705e7816ULL, 0x002fe2000000005eULL,
0x0000006a442c723cULL, 0x000fec000000182cULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x00005410725f7816ULL, 0x004fce000000005dULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x0000541076767816ULL, 0x008fe2000000005bULL, 0x0000005e4430723cULL, 0x000fec0000001830ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000541078777816ULL, 0x002fce000000005cULL,
0x0000004f00717306ULL, 0x000e620000200c00ULL, 0x00000076443c723cULL, 0x040fee000000183cULL,
0x0000004e00617306ULL, 0x0007e20000200c00ULL, 0x0000541067687816ULL, 0x004fe40000000068ULL,
0x000054106f6f7816ULL, 0x002fe20000000071ULL, 0x0000004c444c723cULL, 0x048be80000001824ULL,
0x00000040005d7306ULL, 0x0003e60000200c00ULL, 0x00000018ff247819ULL, 0x020fe2000001141dULL,
0x000000684428723cULL, 0x000f620000001828ULL, 0x000000001c1c783bULL, 0x000ea20000000200ULL,
0x0000888041257816ULL, 0x000fc400000000ffULL, 0x0000002400637306ULL, 0x0006e20000200c00ULL,
0x0000888043407816ULL, 0x002fc600000000ffULL, 0x0000006e4434723cULL, 0x000b680000001834ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000000ffff247224ULL, 0x008fe400078e0025ULL,
0x0000010041257824ULL, 0x000fe400078e00ffULL, 0x0000010043467824ULL, 0x060fe400078e00ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000002400607306ULL, 0x0003e20000200c00ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fc40000011446ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000002500647306ULL, 0x0006a20000200c00ULL,
0x0000888042247816ULL, 0x002fe400000000ffULL, 0x0000541062627816ULL, 0x000fca0000000063ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x0000010042257824ULL, 0x048fe400078e00ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x000000101c1ca232ULL, 0x084fe40000000000ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x000000101e1ea232ULL, 0x000fe20000000000ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000002400447306ULL, 0x0003e20000200c00ULL,
0x000000111d1da232ULL, 0x080fe20000000000ULL, 0x0000541060637816ULL, 0x000fe20000000064ULL,
0x000000111f1fa232ULL, 0x000fca0000000000ULL, 0x0000002500457306ULL, 0x0004e20000200c00ULL,
0x0000541079247816ULL, 0x002fe2000000007aULL, 0x000000801c28723cULL, 0x040f6c0000001828ULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x000054107c257816ULL, 0x004fe2000000007dULL,
0x000000621c34723cULL, 0x040f6c0000001834ULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x0000541044447816ULL, 0x008fe20000000045ULL, 0x000000241c24723cULL, 0x000f6c0000001848ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x0000541082827816ULL, 0x002fce0000000057ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x0000541061837816ULL, 0x004fce0000000058ULL,
0x00000041005e7306ULL, 0x0002a20000200c00ULL, 0x000000821c2c723cULL, 0x000f6e000000182cULL,
0x0000004000477306ULL, 0x0005e20000200c00ULL, 0x000054107e417816ULL, 0x002fce000000005aULL,
0x0000004600467306ULL, 0x000e620000200c00ULL, 0x000054107b407816ULL, 0x004fce0000000059ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000000401c4c723cULL, 0x000b6e000000184cULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x000054105d407816ULL, 0x028fe40000000055ULL,
0x000054105e417816ULL, 0x000fc40000000056ULL, 0x0000541047457816ULL, 0x002fc60000000046ULL,
0x0000004200427306ULL, 0x000e640000200c00ULL, 0x000000401c30723cULL, 0x040b6c0000001830ULL,
0x0000004300437306ULL, 0x000ea40000200c00ULL, 0x000000441c38723cULL, 0x000b620000001838ULL,
0x0000541042427816ULL, 0x002fc40000000051ULL, 0x0000541043437816ULL, 0x004fce0000000054ULL,
0x000000421c1c723cULL, 0x000b62000000183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff407f8cULL, 0x020e62000c80043fULL, 0x000000ffff437224ULL, 0x000fce00078e00ffULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff3e7984ULL, 0x000ea40000000800ULL,
0x800000003eff7812ULL, 0x006fe40007804841ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c427210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004200780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404200780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000423e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000143437810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000580008417a24ULL, 0x010fc800078e02ffULL, 0x0000004041417824ULL, 0x000fe200078e00ffULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000080193c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001073e7824ULL, 0x000fe200078e0212ULL, 0x0000000212497810ULL, 0x000fe40007ffe0ffULL,
0x0000003c043d7217ULL, 0x000fe20007800000ULL, 0x0000004003467824ULL, 0x000fe200078e023eULL,
0x00000004124b7810ULL, 0x000fe20007ffe0ffULL, 0x000000013e3f7824ULL, 0x040fe200078e0202ULL,
0x000000f00d477812ULL, 0x000fe200078ec0ffULL, 0x000000103e487824ULL, 0x000fe200078e00ffULL,
0x0000004146437210ULL, 0x040fe20007f1e0ffULL, 0x00000001073e7824ULL, 0x000fe200078e0249ULL,
0x0000000246457810ULL, 0x000fe20007ffe0ffULL, 0x000000013d3d7824ULL, 0x000fe200078e0a3cULL,
0xfffffff048487812ULL, 0x000fe200078ee23fULL, 0x00000001073c7824ULL, 0x040fe200078e024bULL,
0x0000000446447810ULL, 0x000fe20007ffe0ffULL, 0x000000013e3f7824ULL, 0x140fe200078e0202ULL,
0x0000003d073d7217ULL, 0x000fe20007800000ULL, 0x000000103e4a7824ULL, 0x000fe200078e00ffULL,
0x0000004144447210ULL, 0x000fe20007f7e0ffULL, 0x000000013c3e7824ULL, 0x000fe200078e0202ULL,
0x0001400048487811ULL, 0x000fe200078e20ffULL, 0x000000103c517824ULL, 0x000fe200078e00ffULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee23fULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x00005e0043407a11ULL, 0x000fe200078040ffULL, 0x000000013d3f7824ULL, 0x000fe200078e0a07ULL,
0xfffffff051517812ULL, 0x000fe200078ee23eULL, 0x000000ffff3d7224ULL, 0x000fe200018e06ffULL,
0x00005f0043437a11ULL, 0x000fc400000f443cULL, 0x0000004145457210ULL, 0x000fe40007f1e0ffULL,
0x0000003f1200720cULL, 0x000fe40003f86070ULL, 0x00005e00443e7a11ULL, 0x040fe200078a40ffULL,
0x000000ffff3c7224ULL, 0x000fe200000e06ffULL, 0x00005e0045427a11ULL, 0x040fe400078040ffULL,
0x00005f0044447a11ULL, 0x000fe400028f443dULL, 0x00005f0045457a11ULL, 0x000fc400000f443cULL,
0x00000047403c7210ULL, 0x000fe40007f7e0ffULL, 0x0000003f4900720cULL, 0x080fe40003f06070ULL,
0x0000000612497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e0643ULL,
0x0000000646407810ULL, 0x000fe40007ffe0ffULL, 0x0000003f4b00720cULL, 0x000fe20003f66070ULL,
0x0000000107437824ULL, 0x000fe200078e0249ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c487faeULL, 0x0003e2000e101c46ULL, 0x0000004140407210ULL, 0x000fc40007f9e0ffULL,
0x0000000143467824ULL, 0x000fe200078e0202ULL, 0x000000473e3e7210ULL, 0x080fe40007fde0ffULL,
0x000140004a4a7811ULL, 0x000fe400078e20ffULL, 0x0001400051517811ULL, 0x000fe400078e20ffULL,
0x00000047423c7210ULL, 0x002fe20007fbe0ffULL, 0x0000001043487824ULL, 0x000fe400078e00ffULL,
0x000000ffff437224ULL, 0x000fe200020e06ffULL, 0x00005e0040427a11ULL, 0x040fe200078840ffULL,
0x000000ffff3d7224ULL, 0x000fe200028e0645ULL, 0x0000003f4900720cULL, 0x000fe20003fa6070ULL,
0x000000ffff3f7224ULL, 0x000fe200030e0644ULL, 0x00005f0040407a11ULL, 0x000fc400020f4443ULL,
0x0000004742427210ULL, 0x000fe20007f9e0ffULL, 0x000000003c4a7faeULL, 0x0003e2000c101c46ULL,
0xfffffff048467812ULL, 0x000fc600078ee246ULL, 0x000000ffff437224ULL, 0x000fe200020e0640ULL,
0x0001400046467811ULL, 0x000fe200078e20ffULL, 0x000000003e517faeULL, 0x0003e8000d901c46ULL,
0x0000000042467faeULL, 0x0003e2000e901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x00000001073c7824ULL, 0x000fe200078e0212ULL, 0x000000f00d447812ULL, 0x000fc600078ec0ffULL,
0x000000013c3d7824ULL, 0x040fe200078e0202ULL, 0x000000023c3e7810ULL, 0x040fe20007ffe0ffULL,
0x000000103c407824ULL, 0x000fc800078e00ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0202ULL,
0xfffffff040407812ULL, 0x000fe200078ee23dULL, 0x000000103e457824ULL, 0x000fe200078e00ffULL,
0x000000043c3e7810ULL, 0x000fe20007ffe0ffULL, 0x00000040033d7824ULL, 0x000fe200078e023cULL,
0x0001400040407811ULL, 0x000fe400078e20ffULL, 0xfffffff045457812ULL, 0x000fe200078ee23fULL,
0x000000013e427824ULL, 0x000fe200078e0202ULL, 0x000000063c3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000103e497824ULL, 0x000fe200078e00ffULL, 0x000000413d3c7210ULL, 0x000fc60007f1e0ffULL,
0x000000013f437824ULL, 0x000fe200078e0202ULL, 0xfffffff049497812ULL, 0x000fe200078ee242ULL,
0x000000103f547824ULL, 0x000fe200078e00ffULL, 0x000000023d427810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e003c3f7a11ULL, 0x000fe400078040ffULL,
0xfffffff054547812ULL, 0x000fe400078ee243ULL, 0x00005f003c3e7a11ULL, 0x000fe400000f443eULL,
0x000000043d3c7810ULL, 0x000fc40007ffe0ffULL, 0x000000063d3d7810ULL, 0x000fe40007ffe0ffULL,
0x0000004142427210ULL, 0x080fe40007f1e0ffULL, 0x000000413c467210ULL, 0x080fe40007f7e0ffULL,
0x000000413d4a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e06ffULL,
0x00005e0042437a11ULL, 0x000fe200078040ffULL, 0x000000ffff477224ULL, 0x000fe200018e06ffULL,
0x000000443f3c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200028e06ffULL,
0x00005e0046487a11ULL, 0x000fc400078840ffULL, 0x00005e004a517a11ULL, 0x000fe400078a40ffULL,
0x00005f00423f7a11ULL, 0x000fe200000f443dULL, 0x000000ffff3d7224ULL, 0x000fe200018e063eULL,
0x00000044433e7210ULL, 0x080fe40007f1e0ffULL, 0x00005f0046477a11ULL, 0x000fe400020f4447ULL,
0x0000004448427210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c407faeULL, 0x0003e2000b901c46ULL, 0x00005f004a4b7a11ULL, 0x000fe200028f444bULL,
0x000000ffff3f7224ULL, 0x000fe200000e063fULL, 0x0000004451447210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff437224ULL, 0x000fe200018e0647ULL, 0x0001400049497811ULL, 0x000fc400078e20ffULL,
0x0001400054547811ULL, 0x000fe400078e20ffULL, 0x00014000453c7811ULL, 0x002fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fc800020e064bULL, 0x000000003e3c7faeULL, 0x0003e8000b901c46ULL,
0x0000000042497faeULL, 0x0003e8000b901c46ULL, 0x0000000044547faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff3c7f8cULL, 0x000e64000c80043fULL, 0x000000ffff407224ULL, 0x002fc400078e003dULL,
0x00000000003c7805ULL, 0x000fca0000015200ULL, 0x0186b400ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fc40007804853ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c427210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000423e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000143437810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186b400ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804853ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000016000007945ULL, 0x000fe20003800000ULL,
0x0000014000002947ULL, 0x000fea0003800000ULL, 0x0000000fff10723eULL, 0x000fe400000000ffULL,
0x00000002ff3c7819ULL, 0x000fe40000011602ULL, 0x00005410105a7816ULL, 0x000fe20000000010ULL,
0x0000d7027f007947ULL, 0x000fea000b800000ULL, 0x00001f3c5a107589ULL, 0x0002a400000e0000ULL,
0x000000083c117810ULL, 0x000fe20007ffe0ffULL, 0x0000d7427f007947ULL, 0x000fea000b800000ULL,
0x00001f115a117589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000103c597810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff437424ULL, 0x000fe200078e00ffULL,
0x0000cef000427802ULL, 0x000fe20000000f00ULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x0000e0a000007944ULL, 0x00efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000183c597810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff437424ULL, 0x000fe200078e00ffULL,
0x0000cf5000427802ULL, 0x000fe20000000f00ULL, 0xffffffffff517424ULL, 0x004fc400078e00ffULL,
0x0000e04000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002148783bULL, 0x000f280000004200ULL,
0x000000001a44783bULL, 0x000fe80000004200ULL, 0x000000002054783bULL, 0x000ee20000004200ULL,
0x00000018ff5d7819ULL, 0x010fe20000011449ULL, 0x00000100496e7824ULL, 0x040fe200078e00ffULL,
0x00008880496d7816ULL, 0x040fe200000000ffULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe20000011448ULL, 0x00000100486c7824ULL, 0x040fe200078e00ffULL,
0x00008880486b7816ULL, 0x040fe200000000ffULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000010054627824ULL, 0x008fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000010055657824ULL, 0x000fe200078e00ffULL,
0x0000004900707306ULL, 0x0007e20000200c00ULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000010056687824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001144aULL,
0x00000100576a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fc4000001144bULL,
0x00000018ff3c7819ULL, 0x002fe20000011454ULL, 0x0000006e006f7306ULL, 0x000fe20000200c00ULL,
0x000001004a497824ULL, 0x008fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011444ULL,
0x0000888054617816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000048006e7306ULL, 0x0003e20000200c00ULL,
0x0000888055637816ULL, 0x000fc400000000ffULL, 0x00008880457a7816ULL, 0x000fe400000000ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011445ULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000004900727306ULL, 0x0007e20000200c00ULL, 0x000088804a487816ULL, 0x042fe200000000ffULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x00000018ff537819ULL, 0x000fc40000011446ULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000004800717306ULL, 0x0003220000200c00ULL, 0x000001004b497824ULL, 0x048fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011447ULL, 0x00000018ff5f7819ULL, 0x000fe40000011456ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000003c00647306ULL, 0x0007e20000200c00ULL,
0x000088804b487816ULL, 0x042fe200000000ffULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x0000888056677816ULL, 0x040fe200000000ffULL, 0x0001000056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc40000011457ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000004800737306ULL, 0x0003e20000200c00ULL, 0x00000018ff3c7819ULL, 0x008fe20000011455ULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x0000888057697816ULL, 0x040fe200000000ffULL,
0x0001000057577824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000004900757306ULL, 0x0006a20000200c00ULL,
0x0000888044487816ULL, 0x002fc400000000ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000004800777306ULL, 0x0003e20000200c00ULL, 0x0000010044497824ULL, 0x048fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x00000018ff497819ULL, 0x000fc40000011449ULL,
0x0000004a00747306ULL, 0x000fe20000200c00ULL, 0x0001300022487811ULL, 0x002fe400078e20ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000541071727816ULL, 0x010fe40000000072ULL,
0x0000541073737816ULL, 0x004fe20000000075ULL, 0x0000004b00767306ULL, 0x000ff00000200c00ULL,
0x0000004900787306ULL, 0x0003f00000200c00ULL, 0x0000003c00667306ULL, 0x0005e20000200c00ULL,
0x000000004848783bULL, 0x002e6e0000000200ULL, 0x0000004400797306ULL, 0x0007e20000200c00ULL,
0x000000001b3c783bULL, 0x004eae0000004200ULL, 0x0000005400547306ULL, 0x000f220000200c00ULL,
0x000000ffff447224ULL, 0x008fc400078e007aULL, 0x00000100457a7824ULL, 0x040fe400078e00ffULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x00000018ff457819ULL, 0x000fca0000011445ULL,
0x00000045007c7306ULL, 0x0003e20000200c00ULL, 0x0000541054547816ULL, 0x010fce0000000064ULL,
0x00000044007b7306ULL, 0x0009e20000200c00ULL, 0x0000010046457824ULL, 0x042fe200078e00ffULL,
0x000000104848a232ULL, 0x080fe20000000000ULL, 0x0000541055557816ULL, 0x008fe20000000066ULL,
0x000000104a4aa232ULL, 0x000fe40000000000ULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x000000114949a232ULL, 0x080fe20000000000ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000888046447816ULL, 0x050fe200000000ffULL, 0x000000114b4ba232ULL, 0x000fe20000000000ULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x004fc4000001143cULL,
0x00000018ff527819ULL, 0x000fe4000001143dULL, 0x0000006200627306ULL, 0x000e620000200c00ULL,
0x00000054484c723cULL, 0x040be2000000184cULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000018ff427819ULL, 0x000fe4000001143eULL, 0x00000018ff437819ULL, 0x000fe4000001143fULL,
0x00000044007d7306ULL, 0x0005e20000200c00ULL, 0x000000724838723cULL, 0x000fee0000001838ULL,
0x00000045007e7306ULL, 0x0007220000200c00ULL, 0x0000888047447816ULL, 0x004fc400000000ffULL,
0x0000541061627816ULL, 0x002fca0000000062ULL, 0x00000044007f7306ULL, 0x0003e20000200c00ULL,
0x0000010047457824ULL, 0x048fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000004600807306ULL, 0x000fe20000200c00ULL, 0x000088803c447816ULL, 0x002fe400000000ffULL,
0x000054107d7e7816ULL, 0x010fca000000007eULL, 0x0000004500817306ULL, 0x0002b00000200c00ULL,
0x0000004400557306ULL, 0x0207e20000200c00ULL, 0x000001003c457824ULL, 0x042fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011445ULL,
0x0000004700617306ULL, 0x0003e20000200c00ULL, 0x0001300023447811ULL, 0x008fe400078e20ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000054107f7f7816ULL, 0x004fc60000000081ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000000004444783bULL, 0x002e6e0000000200ULL,
0x0000006500657306ULL, 0x000eb00000200c00ULL, 0x0000005f005f7306ULL, 0x000ff00000200c00ULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x0000541063637816ULL, 0x004fce0000000065ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000000624824723cULL, 0x000bee0000001824ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x0000541056567816ULL, 0x008fe2000000005fULL,
0x000000104444a232ULL, 0x082fe20000000000ULL, 0x000088803d627816ULL, 0x020fe200000000ffULL,
0x000000104646a232ULL, 0x000fc40000000000ULL, 0x000000114545a232ULL, 0x080fe40000000000ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x000000114747a232ULL, 0x000fce0000000000ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054106e5e7816ULL, 0x004fce000000005eULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x00005410705f7816ULL, 0x002fe4000000005dULL,
0x000088803e5d7816ULL, 0x000fca00000000ffULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000005e4830723cULL, 0x000fee0000001830ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x0000541067687816ULL, 0x004fce0000000068ULL, 0x0000005700577306ULL, 0x000eb00000200c00ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000541069697816ULL, 0x002fce000000006aULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x0000541057577816ULL, 0x004fe20000000060ULL,
0x000000684828723cULL, 0x040f6c0000001828ULL, 0x0000006d006d7306ULL, 0x000ea40000200c00ULL,
0x00000056482c723cULL, 0x000b6c000000182cULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x000054106b6c7816ULL, 0x002fe2000000006cULL, 0x000001003d577824ULL, 0x020fc400078e00ffULL,
0x000100003d3d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff567224ULL, 0x000fe200078e0062ULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x000054106d6d7816ULL, 0x004fe2000000006fULL, 0x0000007e4428723cULL, 0x000fe20000001828ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000541074747816ULL, 0x008fc6000000005bULL,
0x0000007a007a7306ULL, 0x000ea40000200c00ULL, 0x0000006c4834723cULL, 0x040f620000001834ULL,
0x000000ffff5b7224ULL, 0x000fe200078e005dULL, 0x000088803f5d7816ULL, 0x000fe400000000ffULL,
0x0000541076757816ULL, 0x002fe4000000005cULL, 0x0000005100517306ULL, 0x000fea0000200c00ULL,
0x000000744848723cULL, 0x000b66000000181cULL, 0x0000005200527306ULL, 0x000fe80000200c00ULL,
0x000001003e1c7824ULL, 0x060fe200078e00ffULL, 0x000054107b1d7816ULL, 0x004fe2000000007aULL,
0x000100003e3e7824ULL, 0x000fc400078e00ffULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff3e7819ULL, 0x000fca000001143eULL,
0x0000001c005c7306ULL, 0x0005f00000200c00ULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x00005410771c7816ULL, 0x004fe40000000078ULL, 0x0000541055547816ULL, 0x002fca0000000054ULL,
0x0000001c441c723cULL, 0x000b620000001824ULL, 0x0000003d003d7306ULL, 0x000e6c0000200c00ULL,
0x000000ffff247224ULL, 0x020fe200078e005dULL, 0x000054103c3c7816ULL, 0x008fe20000000051ULL,
0x000001003f5d7824ULL, 0x040fe200078e00ffULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000054103d3d7816ULL, 0x002fce0000000052ULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x0000003c4430723cULL, 0x000b6e0000001830ULL, 0x0000005800587306ULL, 0x000ee20000200c00ULL,
0x000054107c257816ULL, 0x004fce000000005aULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000541080807816ULL, 0x002fce0000000053ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000541061817816ULL, 0x008fce0000000058ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000080442c723cULL, 0x000b6e000000182cULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000005b005b7306ULL, 0x000eb00000200c00ULL, 0x00000024005e7306ULL, 0x0007e20000200c00ULL,
0x0000541056557816ULL, 0x002fce0000000057ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x0000541079247816ULL, 0x008fe20000000059ULL, 0x000000544434723cULL, 0x000b620000001834ULL,
0x000054105b5c7816ULL, 0x004fca000000005cULL, 0x0000003e003e7306ULL, 0x000ea40000200c00ULL,
0x000000244424723cULL, 0x000b6c000000184cULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x000054105e5d7816ULL, 0x002fe4000000005dULL, 0x000054103e3e7816ULL, 0x004fca0000000042ULL,
0x0000005c4438723cULL, 0x000b620000001838ULL, 0x000054103f3f7816ULL, 0x008fce0000000043ULL,
0x0000003e443c723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff427f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008019427810ULL, 0x002fe20007ffe0ffULL,
0x01869800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff467224ULL, 0x020fe200078e0043ULL,
0x000000030c557810ULL, 0x000fe40007ffe0ffULL, 0x000000044200720cULL, 0x000fda0003f06070ULL,
0x0000431000000947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x0186bc00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442447210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011445ULL,
0x0000004408087211ULL, 0x000fca00078110ffULL, 0x000000ffff447224ULL, 0x000fca00000e0645ULL,
0x0000000208087819ULL, 0x000fc80000001244ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000a019087810ULL, 0x000fe20007ffe0ffULL,
0x0000000107437824ULL, 0x000fe200078e0212ULL, 0x0000000212457810ULL, 0x000fe40007ffe0ffULL,
0x0000000804427217ULL, 0x000fe20007800000ULL, 0x0000000143447824ULL, 0x040fe200078e0202ULL,
0x0000000412487810ULL, 0x040fe20007ffe0ffULL, 0x00000010434d7824ULL, 0x000fe200078e00ffULL,
0x0000000612517810ULL, 0x000fe20007ffe0ffULL, 0x0000000142427824ULL, 0x000fe200078e0a08ULL,
0x0000002003087811ULL, 0x000fe200078e30ffULL, 0x0000000107467824ULL, 0x000fe200078e0245ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee244ULL, 0x0000000107477824ULL, 0x040fe200078e0248ULL,
0x0000004207427217ULL, 0x000fe20007800000ULL, 0x00000001434b7824ULL, 0x100fe200078e0208ULL,
0x000000f00d4c7812ULL, 0x000fe200078ec0ffULL, 0x0000000107437824ULL, 0x000fe200078e0251ULL,
0x000160004d4d7811ULL, 0x000fe200078e20ffULL, 0x00000001464a7824ULL, 0x000fe200078e0208ULL,
0x000000414b4b7210ULL, 0x000fe20007f1e0ffULL, 0x0000000147497824ULL, 0x000fc400078e0202ULL,
0x00000010474f7824ULL, 0x000fe200078e00ffULL, 0x000000414a4a7210ULL, 0x080fe20007f3e0ffULL,
0x0000000146447824ULL, 0x040fe400078e0202ULL, 0x00000010464e7824ULL, 0x000fe200078e00ffULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee249ULL, 0x0000000147477824ULL, 0x100fe200078e0208ULL,
0x00005e004a497a11ULL, 0x000fe200078440ffULL, 0x0000000143087824ULL, 0x040fe200078e0208ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee244ULL, 0x0000000143447824ULL, 0x000fe200078e0202ULL,
0x0000004147477210ULL, 0x080fe20007f9e0ffULL, 0x0000001043527824ULL, 0x000fe200078e00ffULL,
0x0000004108417210ULL, 0x000fe20007f7e0ffULL, 0x0000000142087824ULL, 0x000fe200078e0a07ULL,
0x000160004e4e7811ULL, 0x000fe200078e20ffULL, 0x000000ffff427224ULL, 0x000fe200008e06ffULL,
0xfffffff052527812ULL, 0x000fe200078ee244ULL, 0x000000ffff447224ULL, 0x000fe200000e06ffULL,
0x00005e004b437a11ULL, 0x000fc400078040ffULL, 0x00005f004a4a7a11ULL, 0x000fe400010f4442ULL,
0x000000081200720cULL, 0x000fe40003f46070ULL, 0x00005f004b4b7a11ULL, 0x000fe200000f4444ULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x0000004c43427210ULL, 0x000fe40007fbe0ffULL,
0x000000084800720cULL, 0x080fe20003f06070ULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x000000084500720cULL, 0x000fe20003f26070ULL, 0x000000ffff437224ULL, 0x000fe200028e064bULL,
0x00005e0047457a11ULL, 0x000fc400078840ffULL, 0x00005e0041467a11ULL, 0x000fe400078c40ffULL,
0x000000085100720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000424d7faeULL, 0x0003e2000d101c46ULL, 0x00005f0047477a11ULL, 0x000fe400020f4448ULL,
0x00005f0041087a11ULL, 0x000fe400030f4444ULL, 0x0000004c45447210ULL, 0x080fe40007f9e0ffULL,
0x0000004c46467210ULL, 0x000fc40007fbe0ffULL, 0x000160004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200020e0647ULL, 0x0001600052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200028e0608ULL, 0x0000004c49427210ULL, 0x002fca0007f5e0ffULL,
0x000000ffff437224ULL, 0x000fca00010e064aULL, 0x00000000424e7faeULL, 0x0003e8000c901c46ULL,
0x00000000444f7faeULL, 0x0003e8000c101c46ULL, 0x0000000046527faeULL, 0x0003e2000d901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0212ULL,
0x0000002003427811ULL, 0x000fc400078e30ffULL, 0x000000f00d4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000108437824ULL, 0x040fe200078e0202ULL, 0x0000000208447810ULL, 0x040fe20007ffe0ffULL,
0x00000010084c7824ULL, 0x040fe200078e00ffULL, 0x0000000608467810ULL, 0x000fc60007ffe0ffULL,
0x0000000144457824ULL, 0x000fe200078e0202ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee243ULL,
0x00000010444d7824ULL, 0x000fe400078e00ffULL, 0x0000000108437824ULL, 0x000fe200078e0242ULL,
0x000160004c4c7811ULL, 0x000fe200078e20ffULL, 0x0000000142477824ULL, 0x040fe200078e0244ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee245ULL, 0x0000000142497824ULL, 0x000fe200078e0246ULL,
0x0000000408457810ULL, 0x000fe20007ffe0ffULL, 0x00000001464a7824ULL, 0x140fe200078e0202ULL,
0x0000004143437210ULL, 0x080fe20007f5e0ffULL, 0x00000010464f7824ULL, 0x000fe200078e00ffULL,
0x0000004147477210ULL, 0x080fe20007f1e0ffULL, 0x0000000142087824ULL, 0x000fe200078e0245ULL,
0x00005e0043487a11ULL, 0x000fe200078640ffULL, 0x0000000145447824ULL, 0x000fe200078e0202ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee24aULL, 0x00000010454e7824ULL, 0x000fe200078e00ffULL,
0x0000004108457210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff427224ULL, 0x000fe200010e06ffULL,
0x0000004149087210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff497224ULL, 0x000fe200000e06ffULL,
0xfffffff04e4e7812ULL, 0x000fc400078ee244ULL, 0x00005f00434a7a11ULL, 0x000fe200018f4442ULL,
0x000000ffff427224ULL, 0x000fe200008e06ffULL, 0x00005e0047437a11ULL, 0x000fe200078040ffULL,
0x000000ffff417224ULL, 0x000fe200010e06ffULL, 0x00005e0045447a11ULL, 0x000fe400078240ffULL,
0x00005e0008467a11ULL, 0x000fe400078440ffULL, 0x0000004b48487210ULL, 0x000fe40007f7e0ffULL,
0x00005f0047477a11ULL, 0x000fc400000f4449ULL, 0x00005f0045457a11ULL, 0x000fe200008f4442ULL,
0x000000ffff497224ULL, 0x000fe200018e064aULL, 0x0000004b43427210ULL, 0x080fe40007f1e0ffULL,
0x00005f0008087a11ULL, 0x000fe400010f4441ULL, 0x0000004b44447210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e0647ULL, 0x0000004b46467210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000484c7faeULL, 0x0003e2000b901c46ULL,
0x000160004d4d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200008e0645ULL,
0x000160004e4e7811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200010e0608ULL,
0x000160004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000424d7faeULL, 0x0003e8000b901c46ULL,
0x00000000444e7faeULL, 0x0003e8000b901c46ULL, 0x00000000464f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000040c427810ULL, 0x002fc80007ffe0ffULL,
0x000000054200720cULL, 0x000fe20003f06070ULL, 0xffffffffff087424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010a427824ULL, 0x000fe400078e0242ULL,
0x00000004ff437424ULL, 0x000fc800078e00ffULL, 0x0000600042427625ULL, 0x000fca00078e0043ULL,
0x0000000642087981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff447f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186680007487f8cULL, 0x000664000c80043fULL, 0x0000000000427805ULL, 0x002fc40000015200ULL,
0x01866c0007417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004642467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e43ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011447ULL,
0x0000004641417211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000241417819ULL, 0x000fc80000001246ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01866c0007417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018180000e417984ULL, 0x000e680000000800ULL, 0x018380000e467984ULL, 0x0006a20000000800ULL,
0x000000504100720bULL, 0x002fe20003f1d000ULL, 0x0000b9527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000477806ULL, 0x008fc800000e0100ULL, 0x0000ffff47ff7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff487424ULL, 0x000fd600078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000030000780cULL, 0x000fe40003f05270ULL,
0x000000504100720bULL, 0x000fe20003f34000ULL, 0x0000b9327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000487806ULL, 0x000fc400008e0100ULL, 0x0000005041428209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x018580420e008388ULL, 0x0003e40000000800ULL,
0x00009910480e7816ULL, 0x002fc800000000ffULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000050410e7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff48ff7812ULL, 0x000fc6000780c0ffULL,
0x000000500e0e7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL,
0x0000000e005a7308ULL, 0x000e640000000800ULL, 0x0000005a09097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0e7819ULL, 0x000fe20000011602ULL,
0x0000b8727f007947ULL, 0x000fea000b800000ULL, 0x00001f0e5a0e7589ULL, 0x0002e400000e0000ULL,
0x0000000e1c1c7220ULL, 0x088fe40000410000ULL, 0x0000000e1d1d7220ULL, 0x080fe40000410000ULL,
0x0000000e24247220ULL, 0x080fe40000410000ULL, 0x0000000e25257220ULL, 0x000fc40000410000ULL,
0x0000000e28287220ULL, 0x080fe40000410000ULL, 0x0000000e29297220ULL, 0x080fe40000410000ULL,
0x0000000e2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000e2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000e34347220ULL, 0x080fe40000410000ULL, 0x0000000e35357220ULL, 0x000fc40000410000ULL,
0x0000000e30307220ULL, 0x080fe40000410000ULL, 0x0000000e31317220ULL, 0x080fe40000410000ULL,
0x0000000e38387220ULL, 0x080fe40000410000ULL, 0x0000000e39397220ULL, 0x080fe40000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000e3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0048ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008020e7811ULL, 0x000fe200078ff0ffULL,
0x0000b7827f007947ULL, 0x000fea000b800000ULL, 0x00001f0e5a0e7589ULL, 0x00066400000e0000ULL,
0x0000000e1e1e7220ULL, 0x082fe40000410000ULL, 0x0000000e1f1f7220ULL, 0x080fe40000410000ULL,
0x0000000e26267220ULL, 0x080fe40000410000ULL, 0x0000000e27277220ULL, 0x080fe40000410000ULL,
0x0000000e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000000e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000e36367220ULL, 0x080fe40000410000ULL, 0x0000000e37377220ULL, 0x080fe40000410000ULL,
0x0000000e32327220ULL, 0x080fe40000410000ULL, 0x0000000e33337220ULL, 0x000fc40000410000ULL,
0x0000000e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff48ff7812ULL, 0x000fe20007800847ULL,
0x00000001ff487424ULL, 0x000fe200078e00ffULL, 0x0000005041507209ULL, 0x000fd60007810000ULL,
0x8000005041410221ULL, 0x000fe20000010000ULL, 0x00007610ff480816ULL, 0x000fc60000000048ULL,
0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL, 0x00000041000f0308ULL, 0x000e640000000800ULL,
0x0000000f46460220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000946097221ULL, 0x004fc40000010000ULL, 0x0000000000427805ULL, 0x000fca0000015200ULL,
0x0186ac00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe40007804840ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004642417210ULL, 0x000fca0007f1e1ffULL,
0x0000000147467824ULL, 0x000fe200000e0e43ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff4600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff4600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011446ULL,
0x000000410e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff417224ULL, 0x000fca00000e0646ULL,
0x000000020e0e7819ULL, 0x000fc80000001241ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe40007804840ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910480e7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0e00720cULL, 0x000fda0003f25270ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x0000000fff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff407819ULL, 0x000fe40000011602ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x0000b3827f007947ULL, 0x000fea000b800000ULL,
0x00001f400e107589ULL, 0x0002a400000e0000ULL, 0x0000000840117810ULL, 0x000fe20007ffe0ffULL,
0x0000b3d27f007947ULL, 0x000fea000b800000ULL, 0x00001f110e117589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001040597810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x008fe200078e000eULL, 0x0000f4f000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x0000baa000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001840597810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x008fe200078e000eULL,
0x0000f56000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff517424ULL, 0x004fc400078e00ffULL, 0x0000ba3000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001348783bULL, 0x000e620000004200ULL, 0x0001380017177811ULL, 0x000fe400078e20ffULL,
0x0001380018187811ULL, 0x000fe200078e20ffULL, 0x00000000154c783bULL, 0x0002e80000004200ULL,
0x000000001454783bULL, 0x0004e80000004200ULL, 0x000000001640783bULL, 0x002e620000004200ULL,
0x0000010048157824ULL, 0x040fe200078e00ffULL, 0x0000888048147816ULL, 0x004fc400000000ffULL,
0x00000018ff0e7819ULL, 0x000fe20000011448ULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x00000014005d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff537819ULL, 0x008fe4000001144cULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff5c7819ULL, 0x000fe40000011454ULL, 0x00000018ff5b7819ULL, 0x000fe20000011455ULL,
0x00000015005e7306ULL, 0x0006620000200c00ULL, 0x0000888049147816ULL, 0x004fc400000000ffULL,
0x00000018ff597819ULL, 0x000fe40000011456ULL, 0x00000018ff5a7819ULL, 0x000fe40000011457ULL,
0x00000018ff587819ULL, 0x000fe2000001144dULL, 0x00000014005f7306ULL, 0x0005e20000200c00ULL,
0x0000010049157824ULL, 0x008fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe4000001144eULL,
0x00000018ff527819ULL, 0x000fe4000001144fULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x0000000e00607306ULL, 0x0007e20000200c00ULL, 0x000088804a147816ULL, 0x004fe400000000ffULL,
0x000054105d5e7816ULL, 0x002fe4000000005eULL, 0x00000018ff467819ULL, 0x000fe40000011440ULL,
0x00000018ff477819ULL, 0x000fe20000011441ULL, 0x0000001500617306ULL, 0x0002a20000200c00ULL,
0x00000018ff0e7819ULL, 0x008fe20000011449ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fc80000011443ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000001400637306ULL, 0x0007e20000200c00ULL, 0x000001004a157824ULL, 0x002fca00078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000000e00627306ULL, 0x0003e20000200c00ULL,
0x000088804b147816ULL, 0x008fe400000000ffULL, 0x000054105f5f7816ULL, 0x004fca0000000061ULL,
0x0000001500647306ULL, 0x0004e20000200c00ULL, 0x00000018ff0e7819ULL, 0x002fe2000001144aULL,
0x000100004a4a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000001400657306ULL, 0x0003e20000200c00ULL, 0x000001004b157824ULL, 0x004fca00078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000000e00667306ULL, 0x0005e20000200c00ULL,
0x0000888054147816ULL, 0x002fe400000000ffULL, 0x0000541063647816ULL, 0x008fca0000000064ULL,
0x0000001500687306ULL, 0x0002e20000200c00ULL, 0x00000018ff0e7819ULL, 0x004fe2000001144bULL,
0x000100004b4b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x00000014006b7306ULL, 0x0005e20000200c00ULL, 0x0000010054157824ULL, 0x042fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000004b006a7306ULL, 0x0003e20000200c00ULL, 0x0000888055147816ULL, 0x004fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000541065657816ULL, 0x008fc60000000068ULL,
0x00000015006c7306ULL, 0x0004e20000200c00ULL, 0x000001004d4b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000014006d7306ULL, 0x0003e20000200c00ULL,
0x0000010055157824ULL, 0x044fe400078e00ffULL, 0x0001000055557824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000004800487306ULL, 0x000ea20000200c00ULL,
0x0000888056147816ULL, 0x002fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x000054106b6c7816ULL, 0x008fc6000000006cULL, 0x00000015006e7306ULL, 0x0002f00000200c00ULL,
0x00000014006f7306ULL, 0x0007e20000200c00ULL, 0x0000010056157824ULL, 0x002fe200078e00ffULL,
0x0000541048487816ULL, 0x004fe20000000060ULL, 0x0001000056567824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x0000888057147816ULL, 0x008fe400000000ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x000054106d6d7816ULL, 0x000fc6000000006eULL, 0x0000001500707306ULL, 0x0004f00000200c00ULL,
0x0000001400717306ULL, 0x0007e20000200c00ULL, 0x0000010057157824ULL, 0x004fe200078e00ffULL,
0x0000541049497816ULL, 0x002fe20000000062ULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000004a00677306ULL, 0x0002a20000200c00ULL,
0x000088804c147816ULL, 0x008fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x000054106f707816ULL, 0x000fc60000000070ULL, 0x0000001500727306ULL, 0x0006a20000200c00ULL,
0x000088804d4a7816ULL, 0x042fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000001400737306ULL, 0x000fe20000200c00ULL,
0x000001004c157824ULL, 0x048fe200078e00ffULL, 0x0000541067667816ULL, 0x004fe20000000066ULL,
0x000100004c4c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000004a00757306ULL, 0x0003e20000200c00ULL, 0x0000541071717816ULL, 0x000fe40000000072ULL,
0x00000018ff4c7819ULL, 0x000fca000001144cULL, 0x0000001500747306ULL, 0x0005e20000200c00ULL,
0x000088804e4a7816ULL, 0x002fce00000000ffULL, 0x0000004b00767306ULL, 0x0003e20000200c00ULL,
0x000000001714783bULL, 0x004eae0000000200ULL, 0x0000004a00777306ULL, 0x0007e20000200c00ULL,
0x000001004e4b7824ULL, 0x042fe400078e00ffULL, 0x000100004e4e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000000e00697306ULL, 0x0002620000200c00ULL,
0x000088804f4a7816ULL, 0x008fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fca000001144eULL,
0x0000004b00787306ULL, 0x0007e20000200c00ULL, 0x00000018ff0e7819ULL, 0x002fce0000011442ULL,
0x0000004a00797306ULL, 0x0003e20000200c00ULL, 0x000001004f4b7824ULL, 0x048fe200078e00ffULL,
0x000054106a677816ULL, 0x000fe20000000069ULL, 0x000100004f4f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000001014149232ULL, 0x084fe20000000000ULL, 0x00008880404a7816ULL, 0x042fe200000000ffULL,
0x0000001016169232ULL, 0x000fe20000000000ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000001115159232ULL, 0x080fe40000000000ULL, 0x0000001117179232ULL, 0x000fe20000000000ULL,
0x0000004b007a7306ULL, 0x000fec0000200c00ULL, 0x000000481424723cULL, 0x040b640000001824ULL,
0x0000005b005b7306ULL, 0x000fea0000200c00ULL, 0x000000ffff487224ULL, 0x020fe200078e004aULL,
0x0000005e141c723cULL, 0x000b62000000181cULL, 0x0000010040497824ULL, 0x040fe200078e00ffULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x0001000040407824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011449ULL, 0x00000100415f7824ULL, 0x020fe200078e00ffULL,
0x000000641428723cULL, 0x000f620000001828ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x00000048005e7306ULL, 0x0003e40000200c00ULL, 0x00000018ff5f7819ULL, 0x000fc8000001145fULL,
0x00000066142c723cULL, 0x040fe4000000182cULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000000001848783bULL, 0x0022aa0000000200ULL, 0x0000006c1434723cULL, 0x000f640000001834ULL,
0x0000005400547306ULL, 0x000ee20000200c00ULL, 0x0000888041187816ULL, 0x042fe200000000ffULL,
0x0001000041417824ULL, 0x000fc800078e00ffULL, 0x000000701438723cULL, 0x000f620000001838ULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000005500557306ULL, 0x000e700000200c00ULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x0000541054547816ULL, 0x008fce000000005cULL,
0x0000005700577306ULL, 0x000ee20000200c00ULL, 0x0000541055557816ULL, 0x002fe4000000005bULL,
0x0000541056567816ULL, 0x004fca0000000059ULL, 0x000000541430723cULL, 0x000b620000001830ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x0000001048489232ULL, 0x080fe40000000000ULL,
0x000000104a4a9232ULL, 0x000fe40000000000ULL, 0x0000001149499232ULL, 0x080fe20000000000ULL,
0x0000541057577816ULL, 0x008fe2000000005aULL, 0x000000114b4b9232ULL, 0x000fe20000000000ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000888042547816ULL, 0x020fc800000000ffULL,
0x00000056143c723cULL, 0x000b66000000183cULL, 0x0000004c004c7306ULL, 0x000e680000200c00ULL,
0x0000010042147824ULL, 0x060fe200078e00ffULL, 0x0000541075157816ULL, 0x000fe20000000076ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x0000888043567816ULL, 0x000fe200000000ffULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff427819ULL, 0x000fca0000011442ULL, 0x0000001400557306ULL, 0x0007e20000200c00ULL,
0x000054104c4c7816ULL, 0x002fe40000000053ULL, 0x000054104d4d7816ULL, 0x004fca0000000058ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x0000541073147816ULL, 0x008fe20000000074ULL,
0x0000004c4824723cULL, 0x040f6c0000001824ULL, 0x0000001800187306ULL, 0x000fe40000200c00ULL,
0x000000144814723cULL, 0x000b6c000000181cULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x00000100431d7824ULL, 0x020fc400078e00ffULL, 0x000000ffff1c7224ULL, 0x000fca00078e0056ULL,
0x0000005400547306ULL, 0x000ee20000200c00ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc8000001141dULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000001c00567306ULL, 0x0003f00000200c00ULL, 0x0000001d004c7306ULL, 0x0004e20000200c00ULL,
0x00005410771c7816ULL, 0x002fce0000000078ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x00005410791d7816ULL, 0x004fce000000007aULL, 0x0000001c481c723cULL, 0x000b620000001828ULL,
0x0000005200527306ULL, 0x000fec0000200c00ULL, 0x000054105e287816ULL, 0x020fe4000000005dULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x0000541018297816ULL, 0x000fce000000005fULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000000284828723cULL, 0x000b6e0000001834ULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x0000541054347816ULL, 0x028fe40000000055ULL,
0x0000541056357816ULL, 0x000fca000000004cULL, 0x0000001300137306ULL, 0x000fe40000200c00ULL,
0x000000344834723cULL, 0x000b6c0000001838ULL, 0x0000004e004e7306ULL, 0x000e700000200c00ULL,
0x0000004f004f7306ULL, 0x000eb00000200c00ULL, 0x0000004000407306ULL, 0x000ee20000200c00ULL,
0x000054104e4e7816ULL, 0x002fce0000000051ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x000054104f4f7816ULL, 0x004fce0000000052ULL, 0x0000004200427306ULL, 0x000ea20000200c00ULL,
0x0000541040467816ULL, 0x008fe20000000046ULL, 0x0000004e482c723cULL, 0x000b6c000000182cULL,
0x0000004300437306ULL, 0x000ee20000200c00ULL, 0x0000541041477816ULL, 0x002fe40000000047ULL,
0x0000541042387816ULL, 0x024fca000000000eULL, 0x000000464830723cULL, 0x000b620000001830ULL,
0x0000541043397816ULL, 0x008fce0000000013ULL, 0x000000384838723cULL, 0x000b62000000183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff407f8cULL, 0x000e62000c80043fULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x00000000003c7805ULL, 0x020fc40000015200ULL,
0x0186bc00ff0e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x006fe40007804841ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c137210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3e7824ULL, 0x000fe200000e0e3dULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff3e00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff3e00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001143eULL, 0x000000130e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e063eULL, 0x000000020e0e7819ULL, 0x000fc80000001213ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020b0e7810ULL, 0x000fc80007ffe0ffULL,
0x000000060e00720cULL, 0x000fe20003f06070ULL, 0x00005800080e7a24ULL, 0x010fc800078e02ffULL,
0x000000400e187824ULL, 0x000fd000078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000c019197810ULL, 0x000fe20007ffe0ffULL, 0x0000000107137824ULL, 0x000fe200078e0212ULL,
0x0000000212437810ULL, 0x040fe40007ffe0ffULL, 0x0000000412477810ULL, 0x000fe20007ffe0ffULL,
0x00000001133c7824ULL, 0x040fe200078e0202ULL, 0x00000019040e7217ULL, 0x000fe20007800000ULL,
0x0000001013427824ULL, 0x000fe200078e00ffULL, 0x0000000612497810ULL, 0x000fe20007ffe0ffULL,
0x00000001073d7824ULL, 0x000fe400078e0243ULL, 0x0000004003137824ULL, 0x000fe200078e0213ULL,
0xfffffff042427812ULL, 0x000fe200078ee23cULL, 0x000000010e0e7824ULL, 0x000fc400078e0a19ULL,
0x00000001073e7824ULL, 0x000fe200078e0247ULL, 0x0000001813407210ULL, 0x000fe20007f1e0ffULL,
0x000000013d197824ULL, 0x100fe200078e0202ULL, 0x0000000e070e7217ULL, 0x000fe20007800000ULL,
0x000000103d467824ULL, 0x000fe200078e00ffULL, 0x00000004133d7810ULL, 0x040fe20007ffe0ffULL,
0x000000013e3c7824ULL, 0x040fe200078e0202ULL, 0x00000002133f7810ULL, 0x000fe20007ffe0ffULL,
0x000000103e487824ULL, 0x000fe200078e00ffULL, 0xfffffff046467812ULL, 0x000fe200078ee219ULL,
0x0000000107197824ULL, 0x000fe200078e0249ULL, 0x00000006133e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0xfffffff048487812ULL, 0x000fe200078ee23cULL,
0x000000010e0e7824ULL, 0x000fe200078e0a07ULL, 0x00005e00403c7a11ULL, 0x040fe200078440ffULL,
0x0000000119417824ULL, 0x000fe200078e0202ULL, 0x000000183d3d7210ULL, 0x000fe20007f7e0ffULL,
0x00000010194a7824ULL, 0x000fe200078e00ffULL, 0x00005f0040407a11ULL, 0x000fc400010f4413ULL,
0x0000000e1200720cULL, 0x000fe20003f46070ULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x000000183f3f7210ULL, 0x080fe40007f9e0ffULL, 0xfffffff04a4a7812ULL, 0x000fe400078ee241ULL,
0x00005e003d197a11ULL, 0x000fe200078640ffULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x000000183e187210ULL, 0x000fe40007f1e0ffULL, 0x000000f00d417812ULL, 0x000fc400078ec0ffULL,
0x00005f003d3d7a11ULL, 0x000fe200018f4412ULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e003f3e7a11ULL, 0x040fe400078840ffULL, 0x000000413c127210ULL, 0x000fe40007fbe0ffULL,
0x00005e00183c7a11ULL, 0x000fe400078c40ffULL, 0x00005f003f3f7a11ULL, 0x000fe200020f4413ULL,
0x000000ffff137224ULL, 0x000fe200028e0640ULL, 0x0001400042427811ULL, 0x000fc400078e20ffULL,
0x00005f00180d7a11ULL, 0x000fe400030f440dULL, 0x000000413e187210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012427faeULL, 0x0003e2000d101c46ULL,
0x0000000e4300720cULL, 0x080fe40003f86070ULL, 0x0000000e4700720cULL, 0x080fe40003f66070ULL,
0x0000000e4900720cULL, 0x000fe40003f06070ULL, 0x0001400046467811ULL, 0x000fc400078e20ffULL,
0x0001400048487811ULL, 0x000fe400078e20ffULL, 0x000140004a4a7811ULL, 0x000fe400078e20ffULL,
0x0000004119127210ULL, 0x082fe20007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe200028e063fULL,
0x000000413c3c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e063dULL,
0x0000000018467faeULL, 0x0003e2000e101c46ULL, 0x000000ffff3d7224ULL, 0x000fc600028e060dULL,
0x0000000012487faeULL, 0x0003e8000d901c46ULL, 0x000000003c4a7faeULL, 0x0003e2000c101c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x000000f00d0d7812ULL, 0x000fc600078ec0ffULL, 0x00000001120e7824ULL, 0x040fe200078e0202ULL,
0x0000000212137810ULL, 0x040fe20007ffe0ffULL, 0x0000001012197824ULL, 0x040fe200078e00ffULL,
0x00000006123e7810ULL, 0x000fc60007ffe0ffULL, 0x00000001133c7824ULL, 0x000fe200078e0202ULL,
0xfffffff019197812ULL, 0x000fe200078ee20eULL, 0x0000001013407824ULL, 0x000fe400078e00ffULL,
0x00000040030e7824ULL, 0x000fe200078e0212ULL, 0x0001400019197811ULL, 0x000fe200078e20ffULL,
0x000000013e427824ULL, 0x000fe200078e0202ULL, 0xfffffff040407812ULL, 0x000fe200078ee23cULL,
0x000000103e497824ULL, 0x000fe200078e00ffULL, 0x00000004123c7810ULL, 0x000fe40007ffe0ffULL,
0x000000180e127210ULL, 0x000fc40007f1e0ffULL, 0x000000020e137810ULL, 0x000fe20007ffe0ffULL,
0x000000013c3f7824ULL, 0x000fe200078e0202ULL, 0x000000040e3d7810ULL, 0x000fe20007ffe0ffULL,
0x000000103c437824ULL, 0x000fe200078e00ffULL, 0x000000060e417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00000018133c7210ULL, 0x080fe40007f5e0ffULL,
0x00005e0012137a11ULL, 0x000fe400078040ffULL, 0x000000183d3e7210ULL, 0x000fc40007f7e0ffULL,
0x0000001841467210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x00005f00120e7a11ULL, 0x000fe200000f440eULL, 0x000000ffff417224ULL, 0x000fe200018e06ffULL,
0x0000000d13127210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff477224ULL, 0x000fe200020e06ffULL,
0x00005e003c3d7a11ULL, 0x000fe400078440ffULL, 0xfffffff049497812ULL, 0x000fe200078ee242ULL,
0x000000ffff137224ULL, 0x000fe200000e060eULL, 0x00005e003e427a11ULL, 0x000fc400078640ffULL,
0xfffffff043437812ULL, 0x000fe400078ee23fULL, 0x00005e0046487a11ULL, 0x000fe200078840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012197faeULL, 0x0003e2000b901c46ULL,
0x00005f003c3f7a11ULL, 0x000fe400010f4418ULL, 0x0000000d3d187210ULL, 0x080fe40007f1e0ffULL,
0x00005f003e417a11ULL, 0x000fe400018f4441ULL, 0x0000000d423c7210ULL, 0x000fc40007f5e0ffULL,
0x00005f0046477a11ULL, 0x000fe400020f4447ULL, 0x0000000d483e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x002fe200000e063fULL, 0x0001400040407811ULL, 0x000fe200078e20ffULL,
0x000000ffff3d7224ULL, 0x000fe200010e0641ULL, 0x0001400043437811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e0647ULL, 0x0001400049497811ULL, 0x000fe200078e20ffULL,
0x0000000018407faeULL, 0x0003e8000b901c46ULL, 0x000000003c437faeULL, 0x0003e8000b901c46ULL,
0x000000003e497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff407f8cULL, 0x002e64000c80043fULL,
0x000000ffff407224ULL, 0x002fc400078e0041ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x0186b400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018120e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000119187824ULL, 0x000fe200000e0e13ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011418ULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0618ULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x0000000fff0d723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011602ULL,
0x000054100d0d7816ULL, 0x000fe2000000000dULL, 0x000097427f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d107589ULL, 0x0002a400000e0000ULL, 0x000000080e117810ULL, 0x000fe20007ffe0ffULL,
0x000097927f007947ULL, 0x000fea000b800000ULL, 0x00001f110d117589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100e597810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e000dULL, 0x0001123000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x00009d6000007944ULL, 0x00efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180e597810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e000dULL,
0x000112a000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x004fc400078e00ffULL, 0x00009cf000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000203c783bULL, 0x000f220000004200ULL, 0x0001380022227811ULL, 0x000fe400078e20ffULL,
0x0001380023237811ULL, 0x000fe200078e20ffULL, 0x000000002148783bULL, 0x0006a80000004200ULL,
0x000000001a44783bULL, 0x000e680000004200ULL, 0x000000001b18783bULL, 0x000e640000004200ULL,
0x00000018ff0d7819ULL, 0x01afe2000001143cULL, 0x000001003d547824ULL, 0x040fe200078e00ffULL,
0x000088803d4f7816ULL, 0x000fe200000000ffULL, 0x000001003c217824ULL, 0x040fe200078e00ffULL,
0x0000000d004e7306ULL, 0x0003e20000200c00ULL, 0x000088803c207816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x004fc40000011448ULL,
0x00000018ff437819ULL, 0x000fe40000011444ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004f00557306ULL, 0x000fe20000200c00ULL, 0x00000018ff0d7819ULL, 0x002fe2000001143dULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003c004f7306ULL, 0x0002a20000200c00ULL, 0x00000018ff517819ULL, 0x000fc40000011445ULL,
0x00000018ff427819ULL, 0x000fe40000011446ULL, 0x00000018ff417819ULL, 0x000fe40000011447ULL,
0x00000018ff4d7819ULL, 0x000fe20000011449ULL, 0x0000003d00577306ULL, 0x0007e20000200c00ULL,
0x000088803e3c7816ULL, 0x002fe400000000ffULL, 0x00000018ff527819ULL, 0x000fe4000001144aULL,
0x00000018ff537819ULL, 0x000fc4000001144bULL, 0x00000018ff127819ULL, 0x000fe20000011418ULL,
0x0000003c00587306ULL, 0x0003e20000200c00ULL, 0x000001003e3d7824ULL, 0x008fe200078e00ffULL,
0x000054104f4e7816ULL, 0x004fe4000000004eULL, 0x00000018ff137819ULL, 0x000fe40000011419ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000000d00567306ULL, 0x0004e20000200c00ULL,
0x000088803f3c7816ULL, 0x002fc400000000ffULL, 0x00000018ff0e7819ULL, 0x000fca000001141bULL,
0x0000003d00597306ULL, 0x0003e20000200c00ULL, 0x00000018ff0d7819ULL, 0x004fe2000001143eULL,
0x000100003e3e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000003c005c7306ULL, 0x0005e20000200c00ULL, 0x000001003f3d7824ULL, 0x002fe200078e00ffULL,
0x00005410574f7816ULL, 0x008fc80000000056ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000000d005a7306ULL, 0x0003e20000200c00ULL, 0x00008880483c7816ULL, 0x004fce00000000ffULL,
0x0000003d005d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff0d7819ULL, 0x002fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003c00607306ULL, 0x0003e20000200c00ULL, 0x00000100483d7824ULL, 0x044fe400078e00ffULL,
0x0001000048487824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003e005b7306ULL, 0x000ea20000200c00ULL, 0x00008880493c7816ULL, 0x002fe400000000ffULL,
0x00000018ff487819ULL, 0x000fca0000011448ULL, 0x0000003d00617306ULL, 0x0003f00000200c00ULL,
0x0000003c00637306ULL, 0x0007e20000200c00ULL, 0x00000100493d7824ULL, 0x002fe200078e00ffULL,
0x000054105b5a7816ULL, 0x004fe2000000005aULL, 0x0001000049497824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003f005f7306ULL, 0x000fe20000200c00ULL,
0x000088804a3c7816ULL, 0x008fe400000000ffULL, 0x00000018ff497819ULL, 0x000fca0000011449ULL,
0x0000003d00647306ULL, 0x0003f00000200c00ULL, 0x0000003c00667306ULL, 0x0005e20000200c00ULL,
0x000001004a3d7824ULL, 0x042fe400078e00ffULL, 0x000100004a4a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x000088804b3c7816ULL, 0x004fe400000000ffULL, 0x00000018ff4a7819ULL, 0x000fca000001144aULL,
0x0000003d00677306ULL, 0x0003f00000200c00ULL, 0x0000003c00697306ULL, 0x0005e20000200c00ULL,
0x000001004b3d7824ULL, 0x042fe400078e00ffULL, 0x000100004b4b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x00008880443c7816ULL, 0x004fe400000000ffULL, 0x00000018ff4b7819ULL, 0x000fca000001144bULL,
0x0000003d006a7306ULL, 0x0005f00000200c00ULL, 0x0000003c006c7306ULL, 0x000fe20000200c00ULL,
0x00000100443d7824ULL, 0x004fe200078e00ffULL, 0x0000541020207816ULL, 0x002fe20000000021ULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000005400547306ULL, 0x000e700000200c00ULL,
0x0000003d006d7306ULL, 0x0005f00000200c00ULL, 0x00000044006e7306ULL, 0x0007e20000200c00ULL,
0x00000000223c783bULL, 0x0045220000000200ULL, 0x0000541055217816ULL, 0x002fcc0000000054ULL,
0x0000004800627306ULL, 0x0003e20000200c00ULL, 0x0000010046447824ULL, 0x008fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004c004c7306ULL, 0x000ee20000200c00ULL,
0x0000888045487816ULL, 0x002fca00000000ffULL, 0x000000ffff227224ULL, 0x004fe400078e0048ULL,
0x0000010045487824ULL, 0x040fe200078e00ffULL, 0x0000004400737306ULL, 0x0003e20000200c00ULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000022006f7306ULL, 0x0005e20000200c00ULL,
0x0000010047447824ULL, 0x002fe200078e00ffULL, 0x00005410624c7816ULL, 0x008fc8000000004cULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x000000103c3c9232ULL, 0x090fe20000000000ULL,
0x0000888046227816ULL, 0x044fe200000000ffULL, 0x000000103e3e9232ULL, 0x000fe20000000000ULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x000000113d3d9232ULL, 0x080fe20000000000ULL,
0x0000002200727306ULL, 0x0003e20000200c00ULL, 0x000000113f3f9232ULL, 0x000fe40000000000ULL,
0x00000018ff467819ULL, 0x000fca0000011446ULL, 0x0000004500717306ULL, 0x0005e20000200c00ULL,
0x0000888047227816ULL, 0x042fe200000000ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x000000203c14723cULL, 0x040be80000001814ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000004400767306ULL, 0x0003e20000200c00ULL, 0x000054105c457816ULL, 0x004fe2000000005dULL,
0x0000010018217824ULL, 0x060fe200078e00ffULL, 0x0000888018207816ULL, 0x040fe200000000ffULL,
0x0000004e3c24723cULL, 0x000fe20000001824ULL, 0x0001000018187824ULL, 0x000fc600078e00ffULL,
0x0000004600747306ULL, 0x000fe20000200c00ULL, 0x0000541058447816ULL, 0x002fe40000000059ULL,
0x00000018ff187819ULL, 0x000fca0000011418ULL, 0x0000004700547306ULL, 0x0003f00000200c00ULL,
0x0000002200757306ULL, 0x000fe20000200c00ULL, 0x000000443c44723cULL, 0x002bee000000181cULL,
0x0000002000557306ULL, 0x0003e20000200c00ULL, 0x00000018ff1c7819ULL, 0x020fc40000011421ULL,
0x00008880191d7816ULL, 0x000fca00000000ffULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x000000002320783bULL, 0x002e6e0000000200ULL, 0x0000004900657306ULL, 0x0004f00000200c00ULL,
0x0000000d005e7306ULL, 0x0009220000200c00ULL, 0x0000541063497816ULL, 0x004fce0000000064ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x00005410654d7816ULL, 0x008fe4000000004dULL,
0x00000018ff0d7819ULL, 0x010fca000001141aULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x0000004c3c30723cULL, 0x000be20000001830ULL, 0x000054105f5b7816ULL, 0x000fcc000000005eULL,
0x0000004a00687306ULL, 0x000ea20000200c00ULL, 0x00005410664c7816ULL, 0x020fe20000000067ULL,
0x0000005a3c2c723cULL, 0x040fe2000000182cULL, 0x00005410694d7816ULL, 0x000fe2000000006aULL,
0x0000001020209232ULL, 0x082fe40000000000ULL, 0x0000001022229232ULL, 0x000fe40000000000ULL,
0x0000004b006b7306ULL, 0x000e620000200c00ULL, 0x0000001121219232ULL, 0x080fe20000000000ULL,
0x0000004c3c4c723cULL, 0x000be20000001834ULL, 0x0000001123239232ULL, 0x000fca0000000000ULL,
0x0000001c00567306ULL, 0x0007220000200c00ULL, 0x0000541068527816ULL, 0x004fce0000000052ULL,
0x0000004800707306ULL, 0x0005e20000200c00ULL, 0x000000ffff1c7224ULL, 0x008fe200078e001dULL,
0x000054106b537816ULL, 0x002fe20000000053ULL, 0x00000100191d7824ULL, 0x040fe400078e00ffULL,
0x0001000019197824ULL, 0x000fc600078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000001c00577306ULL, 0x0003e20000200c00ULL, 0x0000541060487816ULL, 0x004fe40000000061ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000541055347816ULL, 0x030fc60000000056ULL,
0x0000001d00587306ULL, 0x0004e20000200c00ULL, 0x000088801a1c7816ULL, 0x042fe200000000ffULL,
0x000000483c48723cULL, 0x040b6c0000001828ULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x000001001a1d7824ULL, 0x044fe200078e00ffULL, 0x000000523c3c723cULL, 0x000b640000001838ULL,
0x000088801b287816ULL, 0x020fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x0000541075297816ULL, 0x000fc40000000076ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000001c00387306ULL, 0x0005e20000200c00ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000541057357816ULL, 0x008fca0000000058ULL, 0x0000001d00397306ULL, 0x0007220000200c00ULL,
0x000054106c1c7816ULL, 0x004fe2000000006dULL, 0x000000342034723cULL, 0x000f620000001848ULL,
0x000054106e6e7816ULL, 0x002fca0000000043ULL, 0x0000005100517306ULL, 0x000e620000200c00ULL,
0x000054106f1d7816ULL, 0x008fce0000000070ULL, 0x0000001c201c723cULL, 0x000b620000001814ULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x0000541038387816ULL, 0x010fca0000000039ULL,
0x000001001b157824ULL, 0x020fe200078e00ffULL, 0x00005410716f7816ULL, 0x002fe20000000051ULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x000000ffff147224ULL, 0x000fe200078e0028ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x0000006e2024723cULL, 0x000b620000001824ULL,
0x0000541072287816ULL, 0x000fe40000000073ULL, 0x0000001200127306ULL, 0x000fe20000200c00ULL,
0x0000541074427816ULL, 0x004fc80000000042ULL, 0x000000282028723cULL, 0x000b660000001844ULL,
0x0000001300137306ULL, 0x000fe20000200c00ULL, 0x0000541054437816ULL, 0x002fce0000000041ULL,
0x0000000d000d7306ULL, 0x000fe20000200c00ULL, 0x00000042202c723cULL, 0x000b6e000000182cULL,
0x0000000e000e7306ULL, 0x000ff00000200c00ULL, 0x0000001800187306ULL, 0x000e700000200c00ULL,
0x0000001900197306ULL, 0x000eb00000200c00ULL, 0x0000001400147306ULL, 0x000fe20000200c00ULL,
0x0000541018127816ULL, 0x002fce0000000012ULL, 0x0000001500157306ULL, 0x000e620000200c00ULL,
0x0000541019137816ULL, 0x004fce0000000013ULL, 0x0000001a001a7306ULL, 0x000ea20000200c00ULL,
0x000000122030723cULL, 0x000b6e0000001830ULL, 0x0000001b001b7306ULL, 0x000ee20000200c00ULL,
0x0000541014397816ULL, 0x002fe40000000015ULL, 0x000054101a1a7816ULL, 0x004fca000000000dULL,
0x000000382038723cULL, 0x000b62000000184cULL, 0x000054101b1b7816ULL, 0x008fce000000000eULL,
0x0000001a203c723cULL, 0x000b62000000183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff127f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000040c557810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x002fc400078e0013ULL,
0x000000010b0b7810ULL, 0x000fc80007ffe0ffULL, 0x000000060b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffeef9000007947ULL, 0x000fea000383ffffULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000009027810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x000fe200078e0009ULL,
0x000122c000057802ULL, 0x000fc40000000f00ULL, 0x00008af000007944ULL, 0x00efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000900047308ULL, 0x000f240000001000ULL,
0xbf80000004097423ULL, 0x010fc80000000009ULL, 0x800000ff09097221ULL, 0x000fc80000010100ULL,
0x0000000904047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff027624ULL, 0x000fe400078e00ffULL, 0x00006900ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x0048a8000c1e9900ULL, 0x0000000000057919ULL, 0x000f240000000000ULL,
0x00000002ff037819ULL, 0x010fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000402027220ULL, 0x004fca0000410000ULL, 0x00001f0302037589ULL, 0x000ea800000e0000ULL,
0x00001f0502027589ULL, 0x000f2200000e0000ULL, 0x0000001c031c7220ULL, 0x044fe40000410000ULL,
0x0000001d031d7220ULL, 0x040fe40000410000ULL, 0x0000002403247220ULL, 0x040fe40000410000ULL,
0x0000002503257220ULL, 0x000fc40000410000ULL, 0x0000002803287220ULL, 0x040fe40000410000ULL,
0x0000002903297220ULL, 0x040fe40000410000ULL, 0x0000002c032c7220ULL, 0x040fe40000410000ULL,
0x0000002d032d7220ULL, 0x040fe40000410000ULL, 0x0000003403347220ULL, 0x040fe40000410000ULL,
0x0000003503357220ULL, 0x000fc40000410000ULL, 0x0000003003307220ULL, 0x040fe40000410000ULL,
0x0000003103317220ULL, 0x040fe40000410000ULL, 0x0000003803387220ULL, 0x040fe40000410000ULL,
0x0000003903397220ULL, 0x040fe40000410000ULL, 0x0000003c033c7220ULL, 0x040fe40000410000ULL,
0x0000003d033d7220ULL, 0x000fc40000410000ULL, 0x0000001e021e7220ULL, 0x050fe40000410000ULL,
0x0000001f021f7220ULL, 0x040fe40000410000ULL, 0x0000002602267220ULL, 0x040fe40000410000ULL,
0x0000002702277220ULL, 0x040fe40000410000ULL, 0x0000002a022a7220ULL, 0x040fe40000410000ULL,
0x0000002b022b7220ULL, 0x000fc40000410000ULL, 0x0000002e022e7220ULL, 0x040fe40000410000ULL,
0x0000002f022f7220ULL, 0x040fe40000410000ULL, 0x0000003602367220ULL, 0x040fe40000410000ULL,
0x0000003702377220ULL, 0x040fe40000410000ULL, 0x0000003202327220ULL, 0x040fe40000410000ULL,
0x0000003302337220ULL, 0x000fc40000410000ULL, 0x0000003a023a7220ULL, 0x040fe40000410000ULL,
0x0000003b023b7220ULL, 0x040fe40000410000ULL, 0x0000003e023e7220ULL, 0x040fe40000410000ULL,
0x0000003f023f7220ULL, 0x000fc40000410000ULL, 0x0000000000147919ULL, 0x000f220000000000ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff047819ULL, 0x010fc60000011614ULL, 0x00000005040472a4ULL, 0x004fe2000f8e023fULL,
0x0000000214027812ULL, 0x040fe400078ec0ffULL, 0x0000000814057811ULL, 0x000fe200078ff0ffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000000402037211ULL, 0x000fe200078ff8ffULL,
0x0000000804097824ULL, 0x000fe200078e00ffULL, 0x0000000502067211ULL, 0x000fe200078ff8ffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000203027810ULL, 0x040fe20007ffe0ffULL,
0x00000008040b7824ULL, 0x040fe200078e00ffULL, 0x0000000403057810ULL, 0x000fe20007ffe0ffULL,
0x00000008040c7824ULL, 0x008fe200078e00ffULL, 0xfffffff808047812ULL, 0x000fc400078ee203ULL,
0x0000000603037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee206ULL,
0xfffffff809067812ULL, 0x000fe400078ee202ULL, 0xfffffff80c097812ULL, 0x000fe200078ee203ULL,
0x0000000814037824ULL, 0x000fe200078e00ffULL, 0xfffffff80b087812ULL, 0x000fe400078ee205ULL,
0x0001200000057811ULL, 0x000fc400078e58ffULL, 0x0000000803037812ULL, 0x000fe400078ec0ffULL,
0x0000001c1d00723eULL, 0x000fe200000000ffULL, 0x0000001004047824ULL, 0x100fe200078e0205ULL,
0x000000242502723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x00000003ff0c7819ULL, 0x000fe20000011614ULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x0000541000107816ULL, 0x100fe20000000002ULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x0000763200117816ULL, 0x000fe20000000002ULL, 0x0000001008007824ULL, 0x100fe200078e0205ULL,
0x00000020140e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001009027824ULL, 0x000fc400078e0205ULL,
0x0000001004007388ULL, 0x0005e20000000a00ULL, 0x00000003ff0f7819ULL, 0x000fe2000001160eULL,
0x00000001030b7824ULL, 0x040fe400078e020aULL, 0x0000000103087824ULL, 0x040fe400078e0206ULL,
0x0000000103097824ULL, 0x000fe200078e0200ULL, 0x000000282900723eULL, 0x000fe200000000ffULL,
0x00000001030a7824ULL, 0x000fe200078e0202ULL, 0x0000002c2d02723eULL, 0x000fe200000000ffULL,
0x000000010e0d7824ULL, 0x000fe200078e020fULL, 0x000000343503723eULL, 0x000fe200000000ffULL,
0x000000010c047824ULL, 0x004fe200078e0214ULL, 0x0000541000127816ULL, 0x000fc40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001208007388ULL, 0x000fe20000000a00ULL,
0x0ffffff804067812ULL, 0x000fe400078ef814ULL, 0x000000303104723eULL, 0x000fe400000000ffULL,
0x0ffffff80d107812ULL, 0x000fe200078ef80eULL, 0x00000010060d7824ULL, 0x000fe200078e0205ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0000001010107824ULL, 0x000fe200078e0205ULL, 0x000000383900723eULL, 0x000fe400000000ffULL,
0x000000262704723eULL, 0x000fe200000000ffULL, 0x0000000209007388ULL, 0x0005e20000000a00ULL,
0x0000002a2b05723eULL, 0x000fe400000000ffULL, 0x0000002e2f06723eULL, 0x000fe400000000ffULL,
0x0000000714147812ULL, 0x000fc400078ec0ffULL, 0x000000070e0e7812ULL, 0x000fc800078ec0ffULL,
0x1ffffff80e0e7812ULL, 0x000fe400078ef807ULL, 0x0000003c3d02723eULL, 0x004fe400000000ffULL,
0x0000001e1f03723eULL, 0x000fe400000000ffULL, 0x0000541000127816ULL, 0x140fe40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x000000120a007388ULL, 0x000fe20000000a00ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000020b007388ULL, 0x0005e20000000a00ULL, 0x000000363700723eULL, 0x000fc600000000ffULL,
0x0004000408007388ULL, 0x0007e20000000a00ULL, 0x000000323302723eULL, 0x004fe400000000ffULL,
0x0000003a3b03723eULL, 0x000fe200000000ffULL, 0x0000000000057919ULL, 0x008ea20000002600ULL,
0x0000003e3f04723eULL, 0x000fe400000000ffULL, 0x0000541000127816ULL, 0x140fe40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004001209007388ULL, 0x000fe80000000a00ULL,
0x000400020a007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000d087984ULL, 0x000f220000000c00ULL, 0x0000000805007824ULL, 0x004fc600078e00ffULL,
0x0000000010107984ULL, 0x000ea20000000c00ULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff8000c7812ULL, 0x000fc800078ee20cULL, 0xfffffff8050f7812ULL, 0x000fe400078ee20fULL,
0x000000040c0c7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040f0f7c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a000c027a11ULL, 0x048fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a000f047a11ULL, 0x040fe400078248ffULL,
0x00005b000c037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff814007812ULL, 0x000fe400078ef807ULL,
0x00005b000f057a11ULL, 0x000fc600008f4c05ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x000000100e047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000001004007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000050000720cULL, 0x000fe20003f06070ULL, 0xffffffffff077424ULL, 0x000fd800078e00ffULL,
0x000000020a088824ULL, 0x000fc800078e00ffULL, 0x0000640008088a24ULL, 0x000fc800078e0200ULL,
0x0000600008088625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff2a7624ULL, 0x000fe200078e00ffULL, 0x0000000608078981ULL, 0x0002a2000c1e1900ULL,
0x00006900ff2b7624ULL, 0x000fca00078e00ffULL, 0x000000062a2a7981ULL, 0x000722000c1e9900ULL,
0x000001ff0b00780cULL, 0x000fe20003f04070ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000004000287824ULL, 0x000fe200078e00ffULL, 0x01860000ff087f8cULL, 0x002e62000c80043fULL,
0x0000004003297824ULL, 0x000fc600078e00ffULL, 0x00000004070b7c24ULL, 0x004fcc000f8e02ffULL,
0x00000e8000000947ULL, 0x000fea0003800000ULL, 0x00000003ff247819ULL, 0x00afe40000011602ULL,
0x00000028040d7217ULL, 0x000fe40007800000ULL, 0x00000008240f7810ULL, 0x000fe20007ffe0ffULL,
0x0000004003137824ULL, 0x000fe200078e0224ULL, 0x000000700c257812ULL, 0x000fe200078ec0ffULL,
0x000000010d127824ULL, 0x000fe200078e0a28ULL, 0x00000004240d7810ULL, 0x040fe20007ffe0ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x0000000413037810ULL, 0x000fe20007ffe0ffULL,
0x00000001240c7824ULL, 0x100fe200078e0202ULL, 0x000000130b167210ULL, 0x000fe20007f5e0ffULL,
0x000000010d0e7824ULL, 0x140fe200078e0202ULL, 0x000000120d00720cULL, 0x0c0fe20003f06070ULL,
0x000000080d107824ULL, 0x000fe200078e00ffULL, 0x000000120f00720cULL, 0x040fe20003f26070ULL,
0x000000010f0d7824ULL, 0x000fe200078e0202ULL, 0x000000030b037210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e06ffULL, 0x00005e0016157a11ULL, 0x000fc400078440ffULL,
0xfffffff811117812ULL, 0x000fe200078ee20dULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x00005e0003187a11ULL, 0x000fe400078640ffULL, 0x00005f0016167a11ULL, 0x000fe400010f440fULL,
0x00000014130f7810ULL, 0x000fe40007ffe0ffULL, 0x00005f00031d7a11ULL, 0x000fe400018f441dULL,
0x0000000813037810ULL, 0x000fc40007ffe0ffULL, 0x0000000f0b0f7210ULL, 0x000fe40007f7e0ffULL,
0x0000000c130d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20eULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x000000030b037210ULL, 0x000fe40007f9e0ffULL,
0x00000010130e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000d0b0d7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x00005e000f207a11ULL, 0x000fc400078640ffULL,
0x0000000e0b0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200028e06ffULL,
0x00005e0003197a11ULL, 0x000fe400078840ffULL, 0x00005f000f217a11ULL, 0x000fe200018f4421ULL,
0x000000ffff1b7224ULL, 0x000fe200010e06ffULL, 0x00005e000d227a11ULL, 0x000fe400078a40ffULL,
0x000000070c0f7812ULL, 0x000fe400078ec0ffULL, 0x00000018130c7810ULL, 0x000fc40007ffe0ffULL,
0x00005f00031c7a11ULL, 0x000fe400020f441cULL, 0x00005e000e1a7a11ULL, 0x000fe400078440ffULL,
0x00005f000d237a11ULL, 0x000fe400028f4423ULL, 0x0000000c24037810ULL, 0x040fe40007ffe0ffULL,
0x00000010240d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c0b1f7210ULL, 0x000fe20007fde0ffULL,
0x0000000803267824ULL, 0x000fe200078e00ffULL, 0x00000015250c7210ULL, 0x000fe20007f7e0ffULL,
0x000000080d277824ULL, 0x000fe200078e00ffULL, 0x00005f000e1b7a11ULL, 0x000fe200010f441bULL,
0x00000001030e7824ULL, 0x000fe200078e0202ULL, 0x000000122400720cULL, 0x000fc40003f46070ULL,
0x000000120300720cULL, 0x080fe20003fa6070ULL, 0x000000010d037824ULL, 0x040fe200078e0202ULL,
0x000000120d00720cULL, 0x000fe20003f86070ULL, 0x000000ffff0d7224ULL, 0x000fe200018e0616ULL,
0x0ffffff80f177812ULL, 0x000fe200078ef802ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x0000200000147811ULL, 0x000fe400078e70ffULL, 0x00005e001f1e7a11ULL, 0x000fe400078640ffULL,
0xfffffff826157812ULL, 0x000fe200078ee20eULL, 0x0000001010107824ULL, 0x100fe200078e0214ULL,
0xfffffff827167812ULL, 0x000fe200078ee203ULL, 0x0000001017037824ULL, 0x100fe200078e0214ULL,
0x00005f001f1f7a11ULL, 0x000fe200018f440fULL, 0x0000001011117824ULL, 0x100fe200078e0214ULL,
0x00000018250e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001015157824ULL, 0x100fe200078e0214ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c037faeULL, 0x0003e2000d101c46ULL,
0x0000001424177810ULL, 0x000fe20007ffe0ffULL, 0x0000001016167824ULL, 0x000fe200078e0214ULL,
0x0000001824187810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e061dULL,
0x000000121700720cULL, 0x040fe20003f46070ULL, 0x0000000817267824ULL, 0x000fc600078e00ffULL,
0x000000000e107faeULL, 0x0005e2000c101c46ULL, 0x00000019250c7210ULL, 0x002fe20007f7e0ffULL,
0x0000000117037824ULL, 0x100fe200078e0202ULL, 0x0000001c13197810ULL, 0x000fe20007ffe0ffULL,
0x0000000118177824ULL, 0x040fe400078e0202ULL, 0x000000ffff0d7224ULL, 0x000fe200018e061cULL,
0x000000190b197210ULL, 0x000fe40007fde0ffULL, 0x000000121800720cULL, 0x040fe20003f66070ULL,
0x0000000818187824ULL, 0x000fe200078e00ffULL, 0x000000000c117faeULL, 0x0003e2000c901c46ULL,
0x000000ffff1d7224ULL, 0x000fe200030e06ffULL, 0x00005e00191c7a11ULL, 0x000fc400078c40ffULL,
0xfffffff818177812ULL, 0x000fe400078ee217ULL, 0x00005f00191d7a11ULL, 0x000fe400030f441dULL,
0x00000022250e7210ULL, 0x004fe20007fde0ffULL, 0x0000001017177824ULL, 0x000fe200078e0214ULL,
0x0000002013197810ULL, 0x000fe40007ffe0ffULL, 0x0000001a250c7210ULL, 0x002fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e0623ULL, 0x0000001c24107810ULL, 0x000fc40007ffe0ffULL,
0x0000002024187810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e061bULL,
0x000000190b197210ULL, 0x000fe20007fde0ffULL, 0x0000000110117824ULL, 0x140fe200078e0202ULL,
0x000000121000720cULL, 0x0c0fe20003f06070ULL, 0x0000000810227824ULL, 0x000fe200078e00ffULL,
0x000000121800720cULL, 0x040fe20003f26070ULL, 0x0000000118107824ULL, 0x040fe200078e0202ULL,
0x000000000e157faeULL, 0x0003e2000e901c46ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0xfffffff826037812ULL, 0x000fe200078ee203ULL, 0x000000ffff1b7224ULL, 0x000fe200030e06ffULL,
0x00005e00191a7a11ULL, 0x000fe200078c40ffULL, 0x000000000c167faeULL, 0x0005e2000e101c46ULL,
0xfffffff818107812ULL, 0x000fe200078ee210ULL, 0x0000001003037824ULL, 0x000fe200078e0214ULL,
0x00005f00191b7a11ULL, 0x000fc400030f441bULL, 0xfffffff822117812ULL, 0x000fe400078ee211ULL,
0x00000024240e7810ULL, 0x002fe40007ffe0ffULL, 0x00000024130f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e0214ULL, 0x000000120e00720cULL, 0x040fe20003f86070ULL,
0x000000080e157824ULL, 0x040fe200078e00ffULL, 0x00000020250c7210ULL, 0x004fe40007fbe0ffULL,
0x0000000f0b187210ULL, 0x000fe20007fde0ffULL, 0x000000010e0f7824ULL, 0x000fc400078e0202ULL,
0x000000ffff0d7224ULL, 0x000fe200028e0621ULL, 0x0000001e250e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0xfffffff815157812ULL, 0x000fe400078ee20fULL,
0x000000000c037faeULL, 0x0003e2000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fe200028e061fULL,
0x00005e0018167a11ULL, 0x000fe200078c40ffULL, 0x0000001015157824ULL, 0x000fc600078e0214ULL,
0x000000000e177faeULL, 0x0005e2000d901c46ULL, 0x00005f0018187a11ULL, 0x000fe400030f4419ULL,
0x0000001c250c7210ULL, 0x002fe20007f5e0ffULL, 0x0000001010037824ULL, 0x000fc800078e0214ULL,
0x000000ffff0d7224ULL, 0x000fe200010e061dULL, 0x0000001a250e7210ULL, 0x044fe40007f7e0ffULL,
0x0000001625107210ULL, 0x000fe40007f5e0ffULL, 0x000000000c117faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200018e061bULL, 0x0000003824167810ULL, 0x040fe40007ffe0ffULL,
0x0000003c24177810ULL, 0x000fe40007ffe0ffULL, 0x000000000e037faeULL, 0x0005e2000c901c46ULL,
0x000000121600720cULL, 0x000fc40003f26070ULL, 0x000000121700720cULL, 0x000fe20003f06070ULL,
0x000000ffff117224ULL, 0x002fe200010e0618ULL, 0x00000028130c7810ULL, 0x000fc80007ffe0ffULL,
0x0000000010157faeULL, 0x0003e2000e101c46ULL, 0x0000002824037810ULL, 0x044fe40007ffe0ffULL,
0x0000002c240e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c0b0f7210ULL, 0x000fe20007fde0ffULL,
0x00000001030d7824ULL, 0x040fe200078e0202ULL, 0x000000120300720cULL, 0x0c0fe20003fa6070ULL,
0x0000000803037824ULL, 0x000fe200078e00ffULL, 0x000000120e00720cULL, 0x000fe40003f86070ULL,
0x0000003024107810ULL, 0x002fe20007ffe0ffULL, 0x000000080e117824ULL, 0x000fe200078e00ffULL,
0x0000003424157810ULL, 0x000fc40007ffe0ffULL, 0x000000121000720cULL, 0x080fe40003f66070ULL,
0x000000121500720cULL, 0x000fe20003f46070ULL, 0x000000ffff127224ULL, 0x000fe200030e06ffULL,
0x00005e000f0c7a11ULL, 0x000fe200078c40ffULL, 0x0000000815187824ULL, 0x000fe200078e00ffULL,
0xfffffff803037812ULL, 0x000fe200078ee20dULL, 0x000000010e0d7824ULL, 0x000fe200078e0202ULL,
0x00005f000f127a11ULL, 0x000fe400030f4412ULL, 0x0000000c250c7210ULL, 0x000fe20007fde0ffULL,
0x0000001003037824ULL, 0x000fe200078e0214ULL, 0x0000002c130e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8110f7812ULL, 0x000fe200078ee20dULL, 0x0000000110117824ULL, 0x040fe400078e0202ULL,
0x000000ffff0d7224ULL, 0x000fe200030e0612ULL, 0x0000000e0b197210ULL, 0x000fe20007fde0ffULL,
0x0000000810107824ULL, 0x000fe400078e00ffULL, 0x00000001150e7824ULL, 0x000fe200078e0202ULL,
0x000000000c037faeULL, 0x0003e2000e901c46ULL, 0x000000ffff157224ULL, 0x000fe200030e06ffULL,
0xfffffff810117812ULL, 0x000fe200078ee211ULL, 0x000000100f0f7824ULL, 0x000fe200078e0214ULL,
0xfffffff818107812ULL, 0x000fc400078ee20eULL, 0x00000030130e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e0214ULL, 0x00005e0019127a11ULL, 0x000fe400078c40ffULL,
0x0000000e0b187210ULL, 0x000fe20007fbe0ffULL, 0x00000008160e7824ULL, 0x000fe200078e00ffULL,
0x00005f0019197a11ULL, 0x000fe200030f4415ULL, 0x00000001170c7824ULL, 0x142fe400078e0202ULL,
0x0000000817157824ULL, 0x000fe200078e00ffULL, 0x00005e0018177a11ULL, 0x000fe200078c40ffULL,
0x0000000116037824ULL, 0x000fc400078e0202ULL, 0x000000ffff0d7224ULL, 0x000fe200028e06ffULL,
0x0000001225027210ULL, 0x000fe40007fbe0ffULL, 0xfffffff815157812ULL, 0x000fe400078ee20cULL,
0x00000034130c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x000000ffff037224ULL, 0x000fe200028e0619ULL, 0x0000000c0b167210ULL, 0x000fe20007fbe0ffULL,
0x0000001015157824ULL, 0x100fe200078e0214ULL, 0x00005f0018187a11ULL, 0x000fe200030f440dULL,
0x000000100e127824ULL, 0x000fe200078e0214ULL, 0x00000000020f7faeULL, 0x0003e2000e101c46ULL,
0x00000038130d7810ULL, 0x000fc40007ffe0ffULL, 0x0000003c13137810ULL, 0x000fc80007ffe0ffULL,
0x000000130b137210ULL, 0x040fe20007fde0ffULL, 0x000000ffff027224ULL, 0x002fe200028e06ffULL,
0x00005e00160c7a11ULL, 0x000fe400078a40ffULL, 0x0000000d0b0f7210ULL, 0x000fe20007f9e0ffULL,
0x00000010100b7824ULL, 0x000fe200078e0214ULL, 0x00005f0016167a11ULL, 0x000fe200028f4402ULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x0000001725027210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff147224ULL, 0x000fe200020e06ffULL, 0x00005e000f0e7a11ULL, 0x000fc400078840ffULL,
0x00005e0013107a11ULL, 0x000fe200078c40ffULL, 0x000000ffff037224ULL, 0x000fe200028e0618ULL,
0x0000000c250c7210ULL, 0x000fe40007fbe0ffULL, 0x00005f000f0f7a11ULL, 0x000fe400020f4414ULL,
0x00005f0013137a11ULL, 0x000fe200030f440dULL, 0x000000ffff0d7224ULL, 0x000fe200028e0616ULL,
0x0000000e250e7210ULL, 0x040fe20007f9e0ffULL, 0x0000000002117faeULL, 0x0003e2000d901c46ULL,
0x0000001025107210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e060fULL,
0x000000000c0b7faeULL, 0x0005e8000d101c46ULL, 0x000000000e127faeULL, 0x0005e2000c901c46ULL,
0x000000ffff117224ULL, 0x002fca00028e0613ULL, 0x0000000010157faeULL, 0x0005e2000c101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x00000008020f7811ULL, 0x04afe400078fe8ffULL,
0x00000004020d7811ULL, 0x040fe400078fe8ffULL, 0x0000000c02117811ULL, 0x040fe200078fe8ffULL,
0x000000010f107824ULL, 0x140fe200078e0202ULL, 0x0000001402157811ULL, 0x040fe200078fe8ffULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0x0000001802177811ULL, 0x040fe200078fe8ffULL,
0x000000010d037824ULL, 0x040fe200078e0202ULL, 0x00000020021b7811ULL, 0x040fe200078fe8ffULL,
0x000000080d0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff813107812ULL, 0x000fe200078ee210ULL,
0x0000000111127824ULL, 0x140fe200078e0202ULL, 0x0000001002137811ULL, 0x000fe200078fe8ffULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000000115167824ULL, 0x040fe200078e0202ULL, 0x00000024021d7811ULL, 0x000fe200078fe8ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0xfffffff814127812ULL, 0x000fe200078ee212ULL,
0x0000000113037824ULL, 0x040fe200078e0202ULL, 0x0000002c02217811ULL, 0x040fe200078fe8ffULL,
0x0000000813147824ULL, 0x000fe200078e00ffULL, 0xfffffff819167812ULL, 0x000fe200078ee216ULL,
0x0000000117187824ULL, 0x140fe200078e0202ULL, 0x0000001c02197811ULL, 0x000fe200078fe8ffULL,
0x00000008171a7824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee203ULL,
0x000000011b1c7824ULL, 0x040fe200078e0202ULL, 0x0000003002237811ULL, 0x000fe200078fe8ffULL,
0x000000081b1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a187812ULL, 0x000fe200078ee218ULL,
0x0000000119037824ULL, 0x040fe200078e0202ULL, 0x0000003402257811ULL, 0x040fe200078fe8ffULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x000000011d1e7824ULL, 0x140fe200078e0202ULL, 0x00000028021f7811ULL, 0x000fe200078fe8ffULL,
0x000000081d207824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL,
0x0000000121227824ULL, 0x100fe200078e0202ULL, 0x0000200000357811ULL, 0x000fe200078e70ffULL,
0x000000011f037824ULL, 0x040fe200078e0202ULL, 0xfffffff8201e7812ULL, 0x000fe200078ee21eULL,
0x000000081f207824ULL, 0x000fe200078e00ffULL, 0x000000700c4a7812ULL, 0x000fe200078ec0ffULL,
0x0000000821267824ULL, 0x000fc400078e00ffULL, 0x00000001290d7824ULL, 0x000fe200078e020dULL,
0xfffffff820207812ULL, 0x000fe200078ee203ULL, 0x0000000123247824ULL, 0x040fe200078e0202ULL,
0x0000002902037211ULL, 0x000fe200078fe8ffULL, 0x0000000823277824ULL, 0x000fe200078e00ffULL,
0xfffffff826227812ULL, 0x000fe200078ee222ULL, 0x0000000125267824ULL, 0x000fe200078e0202ULL,
0x000000030b497210ULL, 0x000fe20007f1e0ffULL, 0x00000008252b7824ULL, 0x000fe200078e00ffULL,
0x0000000d0b477210ULL, 0x000fe20007f3e0ffULL, 0x00000001290f7824ULL, 0x000fe200078e020fULL,
0xfffffff827247812ULL, 0x000fe200078ee224ULL, 0x000000ffff2c7224ULL, 0x000fe200000e06ffULL,
0x00005e0049487a11ULL, 0x000fe200078040ffULL, 0x0000000129137824ULL, 0x040fe200078e0213ULL,
0x0000003802277811ULL, 0x000fe200078fe8ffULL, 0x0000000129117824ULL, 0x000fe200078e0211ULL,
0xfffffff82b267812ULL, 0x000fe200078ee226ULL, 0x000000ffff2b7224ULL, 0x000fe200008e06ffULL,
0x00005f0049497a11ULL, 0x000fe200000f442cULL, 0x0000000127037824ULL, 0x100fe200078e0202ULL,
0x0000000f0b0f7210ULL, 0x000fe20007f1e0ffULL, 0x00000008270d7824ULL, 0x000fe200078e00ffULL,
0x00005e0047467a11ULL, 0x000fe200078240ffULL, 0x0000000129157824ULL, 0x000fe200078e0215ULL,
0x000000130b417210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e06ffULL,
0x00005f0047477a11ULL, 0x000fe200008f442bULL, 0x0000000129177824ULL, 0x000fe200078e0217ULL,
0x000000110b117210ULL, 0x000fe20007f3e0ffULL, 0x0000000129197824ULL, 0x000fe200078e0219ULL,
0x00005e000f447a11ULL, 0x000fe200078040ffULL, 0x00000001291b7824ULL, 0x000fe200078e021bULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee203ULL, 0x000000ffff037224ULL, 0x000fe200010e06ffULL,
0x00005f000f457a11ULL, 0x000fe200000f4445ULL, 0x000000ffff437224ULL, 0x000fe200008e06ffULL,
0x00005e0041137a11ULL, 0x000fe200078440ffULL, 0x00000001291d7824ULL, 0x000fe200078e021dULL,
0x000000150b407210ULL, 0x000fe20007f1e0ffULL, 0x00000001291f7824ULL, 0x000fe200078e021fULL,
0x00005e0011427a11ULL, 0x000fe200078240ffULL, 0x0000000129237824ULL, 0x000fe200078e0223ULL,
0x00005f0041417a11ULL, 0x000fe200010f4403ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005f0011437a11ULL, 0x000fe200008f4443ULL, 0x0000000129217824ULL, 0x040fe200078e0221ULL,
0x00005e0040157a11ULL, 0x040fe200078040ffULL, 0x0000000129257824ULL, 0x000fe200078e0225ULL,
0x000000170b3f7210ULL, 0x000fe20007f3e0ffULL, 0x0000000129277824ULL, 0x000fe200078e0227ULL,
0x000000190b3e7210ULL, 0x000fe20007f5e0ffULL, 0x000000100d347824ULL, 0x000fe200078e0235ULL,
0x0000001b0b3d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005f0040407a11ULL, 0x000fe200000f4403ULL, 0x000000ffff037224ULL, 0x000fe200010e06ffULL,
0x00005e003e197a11ULL, 0x000fe200078240ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e06ffULL,
0x00005e003d1b7a11ULL, 0x040fe200078440ffULL, 0x000000101e2f7824ULL, 0x000fe200078e0235ULL,
0x00005f003e3e7a11ULL, 0x000fe200008f4403ULL, 0x0000001022317824ULL, 0x100fe200078e0235ULL,
0x0000000202037211ULL, 0x000fe200078fe8ffULL, 0x0000001020307824ULL, 0x000fe200078e0235ULL,
0x00005f003d3d7a11ULL, 0x000fe200010f440fULL, 0x0000001024327824ULL, 0x100fe200078e0235ULL,
0x00005e003f177a11ULL, 0x000fe200078040ffULL, 0x0000001026337824ULL, 0x100fe200078e0235ULL,
0x0000003c020f7811ULL, 0x000fe200078fe8ffULL, 0x000000101a2d7824ULL, 0x100fe200078e0235ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x000000101c2e7824ULL, 0x000fe200078e0235ULL,
0x00005f003f3f7a11ULL, 0x000fe200000f4411ULL, 0x000000010f117824ULL, 0x100fe200078e0202ULL,
0x0ffffff803037812ULL, 0x000fe200078ef802ULL, 0x0000000129027824ULL, 0x000fe200078e020fULL,
0x0000001d0b3c7210ULL, 0x000fe20007f9e0ffULL, 0x000000080f2b7824ULL, 0x000fe200078e00ffULL,
0x0000001f0b3b7210ULL, 0x040fe20007f7e0ffULL, 0x000000100e1f7824ULL, 0x100fe200078e0235ULL,
0x000000230b397210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0x000000210b3a7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e06ffULL,
0x000000250b387210ULL, 0x040fe20007f5e0ffULL, 0x0000001010217824ULL, 0x100fe200078e0235ULL,
0x000000270b377210ULL, 0x040fe20007f9e0ffULL, 0x0000001012237824ULL, 0x100fe200078e0235ULL,
0x000000020b367210ULL, 0x000fe20007fbe0ffULL, 0x00000010030b7824ULL, 0x000fe200078e0235ULL,
0x00005e003b1e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x00005e0039227a11ULL, 0x000fe200078240ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e003a207a11ULL, 0x000fe200078040ffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe200018f440dULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x00005f0039397a11ULL, 0x000fe200008f4402ULL, 0x0000001014257824ULL, 0x000fe200078e0235ULL,
0x00005f003a3a7a11ULL, 0x000fe200000f4403ULL, 0x000000ffff037224ULL, 0x000fe200028e06ffULL,
0x00005e0038247a11ULL, 0x000fe200078240ffULL, 0x0000001016277824ULL, 0x000fe200078e0235ULL,
0x00005e0037267a11ULL, 0x000fc400078440ffULL, 0x00005e00362c7a11ULL, 0x000fe400078640ffULL,
0x000000484a027210ULL, 0x000fe40007f1e0ffULL, 0x00005f0038387a11ULL, 0x000fe400008f440dULL,
0x00005f0037377a11ULL, 0x000fe400010f440cULL, 0x000000464a0c7210ULL, 0x000fe40007f3e0ffULL,
0x00005e003c1d7a11ULL, 0x000fc400078c40ffULL, 0xfffffff82b117812ULL, 0x000fe200078ee211ULL,
0x00000010182b7824ULL, 0x000fe200078e0235ULL, 0x00005f0036367a11ULL, 0x000fe200018f4403ULL,
0x000000ffff037224ULL, 0x000fe200000e0649ULL, 0x000000444a0e7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e0647ULL, 0x000000424a107210ULL, 0x040fe20007f7e0ffULL,
0x0000001011357824ULL, 0x000fe200078e0235ULL, 0x000000134a127210ULL, 0x040fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e2000b901c46ULL,
0x000000154a147210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0643ULL,
0x00005f003c3c7a11ULL, 0x000fe200030f440fULL, 0x000000ffff0f7224ULL, 0x000fe200010e0645ULL,
0x000000174a167210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e0641ULL,
0x000000194a187210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200020e0640ULL,
0x0000001b4a1a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e063fULL,
0x0000001d4a1c7210ULL, 0x040fe20007f7e0ffULL, 0x000000000c1f7faeULL, 0x0005e2000b901c46ULL,
0x0000001e4a1e7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200008e063eULL,
0x000000204a207210ULL, 0x040fe20007f9e0ffULL, 0x000000000e217faeULL, 0x0007e2000b901c46ULL,
0x000000224a227210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e063dULL,
0x000000244a247210ULL, 0x040fe20007f3e0ffULL, 0x0000000010237faeULL, 0x0003e2000b901c46ULL,
0x000000264a267210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e063cULL,
0x0000002c4a2c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000012257faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1f7224ULL, 0x004fc600028e063bULL, 0x0000000014277faeULL, 0x0005e2000b901c46ULL,
0x000000ffff217224ULL, 0x008fc600020e063aULL, 0x00000000162b7faeULL, 0x0007e2000b901c46ULL,
0x000000ffff237224ULL, 0x002fc600000e0639ULL, 0x00000000182d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff257224ULL, 0x000fc600008e0638ULL, 0x000000001a2e7faeULL, 0x0007e2000b901c46ULL,
0x000000ffff277224ULL, 0x004fc600010e0637ULL, 0x000000001c2f7faeULL, 0x0007e8000b901c46ULL,
0x000000001e307faeULL, 0x0007e2000b901c46ULL, 0x000000ffff2d7224ULL, 0x002fc600018e0636ULL,
0x0000000020317faeULL, 0x0007e8000b901c46ULL, 0x0000000022327faeULL, 0x0007e8000b901c46ULL,
0x0000000024337faeULL, 0x0007e8000b901c46ULL, 0x0000000026347faeULL, 0x0007e8000b901c46ULL,
0x000000002c357faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x01860400ff0b7984ULL, 0x004e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c020c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e03ULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001140dULL, 0x0000000c0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e060dULL, 0x000000020b0b7819ULL, 0x000fc8000000120cULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0202ULL, 0x00000003ff037819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe03037812ULL, 0x000fe400078ec0ffULL,
0x0000000102087810ULL, 0x040fe20007ffe0ffULL, 0x00000020020d7824ULL, 0x040fe400078e00ffULL,
0x0000000102097824ULL, 0x040fe400078e0203ULL, 0x00000001030b7824ULL, 0x040fe200078e0208ULL,
0x0000001003037810ULL, 0x000fe20007ffe0ffULL, 0x00000020020c7824ULL, 0x000fe200078e00ffULL,
0x0000001f09097812ULL, 0x000fc400078ec0ffULL, 0x0000001f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000102147824ULL, 0x000fe200078e0203ULL, 0x000001e00c097812ULL, 0x000fe200078ee209ULL,
0x0000000108037824ULL, 0x000fe200078e0203ULL, 0x000001e00d0b7812ULL, 0x000fe200078ee20bULL,
0x0000002002087824ULL, 0x000fe200078e00ffULL, 0x0000001f14147812ULL, 0x000fe200078ec0ffULL,
0x0000000009107984ULL, 0x000e62000000cc00ULL, 0x0000002002027824ULL, 0x000fe200078e00ffULL,
0x0000001f03037812ULL, 0x000fe400078ec0ffULL, 0x000000000b0c7984ULL, 0x000ea2000000cc00ULL,
0x000001e008147812ULL, 0x000fc400078ee214ULL, 0x000001e002037812ULL, 0x000fe200078ee203ULL,
0x000000ffff187224ULL, 0x002fe400078e0010ULL, 0x000000ffff197224ULL, 0x000fe400078e0012ULL,
0x000000ffff1b7224ULL, 0x00cfe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff0c7224ULL, 0x000fe200078e0011ULL,
0x0000001809007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff0d7224ULL, 0x000fca00078e0013ULL,
0x0000000c0b007388ULL, 0x000fe8000000cc00ULL, 0x00000000030c7984ULL, 0x000e68000000cc00ULL,
0x0000000014107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c14007388ULL, 0x0003e8000000cc00ULL, 0x0000000c03007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01860000ff0c7f8cULL, 0x002e62000c80043fULL,
0x000000ffff0e7224ULL, 0x000fc600078e00ffULL, 0x0000000000027805ULL, 0x000fc80000015200ULL,
0x01860400ff087984ULL, 0x000ea40000000800ULL, 0x8000000008ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008020b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e03ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x000064000a037a24ULL, 0x000fe200078e02ffULL, 0x00018688002b7811ULL, 0x000fe200078e18ffULL,
0x3d8000002a2a7820ULL, 0x010fe20000410000ULL, 0xffffffff062c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00018608002d7811ULL, 0x000fe200078e28ffULL,
0x000000ffff307224ULL, 0x000fc800078e0000ULL, 0x000001002e317824ULL, 0x000fe200078e0228ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000310400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e002fULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fc4000001ff00ULL, 0x0000000132367810ULL, 0x000fe20007ffe0ffULL,
0x00001ac000007945ULL, 0x000fe20003800000ULL, 0x000000ffff337224ULL, 0x000fc400078e0032ULL,
0x0000002e36377211ULL, 0x040fe200078ff8ffULL, 0x0000000407357c24ULL, 0x010fe2000f8e02ffULL,
0x000000023600780cULL, 0x040fe20003f06070ULL, 0x000000ffff327224ULL, 0x000fe200078e0036ULL,
0x00000001372f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000136657812ULL, 0x000fe400078ec0ffULL,
0x000000062f00720cULL, 0x000fe40003f26070ULL, 0x00000001342f7812ULL, 0x000fd600078e0cffULL,
0x00000db000009947ULL, 0x000fea0003800000ULL, 0x0000010037367824ULL, 0x000fe200078e0228ULL,
0x00000003ff4f7819ULL, 0x002fe20000011602ULL, 0x00000008654b7824ULL, 0x000fe400078e00ffULL,
0x00000002004c7824ULL, 0x000fe200078e022fULL, 0x0000003604377217ULL, 0x000fe40007800000ULL,
0x000000084f3b7810ULL, 0x040fe40007ffe0ffULL, 0x000000044f387810ULL, 0x000fe20007ffe0ffULL,
0x00000001374a7824ULL, 0x000fe200078e0a36ULL, 0x0000000c4f407810ULL, 0x000fe20007ffe0ffULL,
0x000000013b3a7824ULL, 0x000fe200078e0202ULL, 0x000000104f527810ULL, 0x000fe20007ffe0ffULL,
0x000000083b507824ULL, 0x000fe200078e00ffULL, 0x0000004a3800720cULL, 0x000fe20003f46070ULL,
0x0000000129367824ULL, 0x000fe200078e024fULL, 0x000000144f537810ULL, 0x000fe20007ffe0ffULL,
0x0000000129377824ULL, 0x000fe200078e0238ULL, 0xfffffff850507812ULL, 0x000fe200078ee23aULL,
0x0000000138397824ULL, 0x140fe200078e0202ULL, 0x00000036353a7210ULL, 0x040fe20007f3e0ffULL,
0x00000008384e7824ULL, 0x000fe200078e00ffULL, 0x0000003735387210ULL, 0x000fe20007f9e0ffULL,
0x0000000129367824ULL, 0x000fe200078e023bULL, 0x0000004a3b00720cULL, 0x000fe20003f66070ULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x00005e003a3c7a11ULL, 0x000fe200078240ffULL,
0x0000000140417824ULL, 0x000fe200078e0202ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee239ULL,
0x000000ffff397224ULL, 0x000fe200020e06ffULL, 0x00005f003a3d7a11ULL, 0x000fe200008f4437ULL,
0x0000000129377824ULL, 0x000fe200078e0240ULL, 0x00005e0038427a11ULL, 0x000fe200078840ffULL,
0x0000000840517824ULL, 0x000fe200078e00ffULL, 0x00000036353a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000129367824ULL, 0x000fe200078e0252ULL, 0x00005f0038437a11ULL, 0x000fe200020f4439ULL,
0x0000000852547824ULL, 0x000fe200078e00ffULL, 0x0000003735387210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x00005e003a447a11ULL, 0x040fe200078240ffULL,
0x00000008535a7824ULL, 0x000fe200078e00ffULL, 0x0000001c4f567810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff397224ULL, 0x000fe200020e06ffULL, 0x00005f003a457a11ULL, 0x000fe200008f4437ULL,
0x0000000129377824ULL, 0x000fe200078e0253ULL, 0x00005e0038467a11ULL, 0x000fc400078840ffULL,
0x00000036353b7210ULL, 0x040fe40007f3e0ffULL, 0x00005f0038477a11ULL, 0x000fe400020f4439ULL,
0x0000003735387210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff377224ULL, 0x000fe200008e06ffULL,
0x00005e003b487a11ULL, 0x000fe400078240ffULL, 0x000000184f557810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff397224ULL, 0x000fe200020e06ffULL, 0x00005f003b497a11ULL, 0x000fe200008f4437ULL,
0x0000000129377824ULL, 0x040fe200078e0256ULL, 0x00005e00383a7a11ULL, 0x040fe200078840ffULL,
0x0000000129367824ULL, 0x000fe200078e0255ULL, 0x000000204f577810ULL, 0x000fe20007ffe0ffULL,
0x00000008555b7824ULL, 0x000fe200078e00ffULL, 0x00005f00383b7a11ULL, 0x000fc400020f4439ULL,
0x0000003735377210ULL, 0x040fe40007f9e0ffULL, 0x0000003635397210ULL, 0x000fe40007f3e0ffULL,
0x0000004a4000720cULL, 0x000fe20003fa6070ULL, 0x000000ffff387224ULL, 0x000fe200020e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078840ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x00005e00393e7a11ULL, 0x000fe400078240ffULL, 0x00005f0037377a11ULL, 0x000fe200020f4438ULL,
0x000000014f387824ULL, 0x000fe200078e0202ULL, 0x00005f00393f7a11ULL, 0x000fc400008f443fULL,
0x0000004a4f00720cULL, 0x000fe40003f26070ULL, 0x0000000738397812ULL, 0x000fe200078ec0ffULL,
0x0000000129387824ULL, 0x000fe200078e0257ULL, 0xfffffff851517812ULL, 0x000fe200078ee241ULL,
0x0000000152417824ULL, 0x100fe200078e0202ULL, 0x0ffffff839407812ULL, 0x100fe400078ef802ULL,
0x0000003835397210ULL, 0x000fe40007f9e0ffULL, 0xfffffff84b4b7812ULL, 0x000fc400078ee202ULL,
0x000020004c4c7811ULL, 0x000fe200078e68ffULL, 0x000000ffff4d7224ULL, 0x000fe200020e06ffULL,
0x000000244f587810ULL, 0x000fe20007ffe0ffULL, 0x000000104b3c7825ULL, 0x000fe200078e003cULL,
0x0000004a5200720cULL, 0x000fe40003f86070ULL, 0xfffffff854527812ULL, 0x000fe200078ee241ULL,
0x0000001040407824ULL, 0x000fe200078e024cULL, 0x00005e0039387a11ULL, 0x000fe200078c40ffULL,
0x0000000129417824ULL, 0x000fe200078e0258ULL, 0x000000284f597810ULL, 0x000fe20007ffe0ffULL,
0x0000000153547824ULL, 0x000fe200078e0202ULL, 0x00005f0039397a11ULL, 0x000fe200030f444dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c407faeULL, 0x0003e2000c901c46ULL,
0x0000004135417210ULL, 0x000fe20007f3e0ffULL, 0x000000104e4d7824ULL, 0x000fe200078e024cULL,
0xfffffff85a547812ULL, 0x000fe200078ee254ULL, 0x000000104b3a7825ULL, 0x000fe200078e003aULL,
0x0000002c4f5a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x0000004a5300720cULL, 0x000fe20003f26070ULL, 0x0000000155537824ULL, 0x000fe400078e0202ULL,
0x000000104b3c7825ULL, 0x002fe200078e0042ULL, 0x00005e0041407a11ULL, 0x000fe400078c40ffULL,
0xfffffff85b537812ULL, 0x000fe200078ee253ULL, 0x0000000129427824ULL, 0x000fe200078e0259ULL,
0x000000003c4d7faeULL, 0x0003e2000d101c46ULL, 0x00005f0041417a11ULL, 0x000fe200030f444eULL,
0x00000008565b7824ULL, 0x000fc400078e00ffULL, 0x000000104b3e7825ULL, 0x000fc800078e003eULL,
0x000000104b367825ULL, 0x000fe200078e0036ULL, 0x00000042353d7210ULL, 0x002fc60007f5e0ffULL,
0x00000010504d7824ULL, 0x000fe400078e024cULL, 0x000000104b427825ULL, 0x000fe200078e0044ULL,
0x00005e003d3c7a11ULL, 0x000fc600078c40ffULL, 0x000000ffff4e7224ULL, 0x000fe200010e06ffULL,
0x0000004a5500720cULL, 0x000fe20003f46070ULL, 0x0000000129447824ULL, 0x000fe200078e025aULL,
0x000000304f557810ULL, 0x000fe20007ffe0ffULL, 0x00000000424d7faeULL, 0x0003e2000d901c46ULL,
0x00005f003d3d7a11ULL, 0x000fe200030f444eULL, 0x0000000156507824ULL, 0x000fe400078e0202ULL,
0x000000104b387825ULL, 0x000fc600078e0038ULL, 0xfffffff85b507812ULL, 0x000fe200078ee250ULL,
0x00000008575b7824ULL, 0x000fe400078e00ffULL, 0x000000104b407825ULL, 0x000fe200078e0040ULL,
0x0000004435437210ULL, 0x002fc60007f7e0ffULL, 0x00000010514d7824ULL, 0x000fe400078e024cULL,
0x000000104b447825ULL, 0x000fe200078e0046ULL, 0x00005e0043427a11ULL, 0x000fc600078c40ffULL,
0x0000000129467824ULL, 0x000fe200078e0255ULL, 0x00000000444d7faeULL, 0x0003e2000e901c46ULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x0000004a5600720cULL, 0x000fe20003f66070ULL,
0x0000000157517824ULL, 0x000fe200078e0202ULL, 0x0000004635477210ULL, 0x000fe20007fbe0ffULL,
0x000000104b3c7825ULL, 0x000fe200078e003cULL, 0x000000344f567810ULL, 0x000fe40007ffe0ffULL,
0x00005f0043437a11ULL, 0x000fe200030f444eULL, 0x000000ffff4e7224ULL, 0x000fe200028e06ffULL,
0x00005e0047467a11ULL, 0x000fe200078c40ffULL, 0x00000010524d7824ULL, 0x002fe200078e024cULL,
0x0000004a5700720cULL, 0x000fe20003fa6070ULL, 0x000000104b447825ULL, 0x000fe200078e0048ULL,
0x00005f0047477a11ULL, 0x000fc400030f444eULL, 0x000000384f577810ULL, 0x000fe20007ffe0ffULL,
0x0000001054487824ULL, 0x100fe200078e024cULL, 0x00000000444d7faeULL, 0x0003e2000e101c46ULL,
0x0000001053497824ULL, 0x000fe200078e024cULL, 0x0000003c4f537810ULL, 0x000fe20007ffe0ffULL,
0x00000001584e7824ULL, 0x040fe200078e0202ULL, 0x000000003a487faeULL, 0x0005e2000c901c46ULL,
0x0000004a5800720cULL, 0x040fe20003f86070ULL, 0x0000000858587824ULL, 0x000fe200078e00ffULL,
0xfffffff85b517812ULL, 0x000fe200078ee251ULL, 0x000000003e497faeULL, 0x0007e2000d101c46ULL,
0x00000008594f7824ULL, 0x000fc400078e00ffULL, 0xfffffff8584e7812ULL, 0x000fe200078ee24eULL,
0x0000000129447824ULL, 0x042fe400078e0256ULL, 0x000000015a527824ULL, 0x000fe400078e0202ULL,
0x00000001293b7824ULL, 0x004fe200078e0253ULL, 0x0000004435457210ULL, 0x000fe20007fde0ffULL,
0x0000001051487824ULL, 0x000fe400078e024cULL, 0x00000001593f7824ULL, 0x008fe400078e0202ULL,
0x000000ffff4d7224ULL, 0x000fe200030e06ffULL, 0x00005e0045447a11ULL, 0x000fe200078c40ffULL,
0x000000104e497824ULL, 0x000fe200078e024cULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee23fULL,
0x000000104b427825ULL, 0x000fe200078e0042ULL, 0x00005f0045457a11ULL, 0x000fc400030f444dULL,
0x0000003b353f7210ULL, 0x000fe20007fde0ffULL, 0x00000001294d7824ULL, 0x000fca00078e0257ULL,
0x0000004d354d7210ULL, 0x000fe20007f3e0ffULL, 0x0000001050357824ULL, 0x000fc600078e024cULL,
0x00005e004d3a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x0000000036357faeULL, 0x0003e2000d901c46ULL, 0x0000004a5900720cULL, 0x080fe40003f26070ULL,
0x0000004a5500720cULL, 0x080fe20003f66070ULL, 0x0000000038487faeULL, 0x0005e2000e901c46ULL,
0x00005f004d3b7a11ULL, 0x000fe200010f443eULL, 0x000000ffff4d7224ULL, 0x000fe200030e06ffULL,
0x00005e003f3e7a11ULL, 0x040fe200078c40ffULL, 0x0000000040497faeULL, 0x0007e2000e101c46ULL,
0x0000004a5a00720cULL, 0x0c0fe20003f46070ULL, 0x000000085a5a7824ULL, 0x000fe200078e00ffULL,
0x00005f003f3f7a11ULL, 0x000fe200030f444dULL, 0x0000000156367824ULL, 0x142fe200078e0202ULL,
0x0000004a5600720cULL, 0x0c0fe20003f86070ULL, 0x0000000157377824ULL, 0x140fe200078e0202ULL,
0x0000004a5700720cULL, 0x080fe20003fa6070ULL, 0x0000000155357824ULL, 0x000fe200078e0202ULL,
0x0000004a5300720cULL, 0x000fe20003fc6070ULL, 0x0000000856567824ULL, 0x000fe200078e00ffULL,
0xfffffff85a527812ULL, 0x000fe200078ee252ULL, 0x0000000855417824ULL, 0x008fc400078e00ffULL,
0x0000000857577824ULL, 0x000fe200078e00ffULL, 0xfffffff856367812ULL, 0x000fe200078ee236ULL,
0x0000000153387824ULL, 0x004fe200078e0202ULL, 0xfffffff841417812ULL, 0x000fe200078ee235ULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0xfffffff857377812ULL, 0x000fe200078ee237ULL,
0x000000104f357824ULL, 0x100fe400078e024cULL, 0x0000001052407824ULL, 0x000fe200078e024cULL,
0xfffffff853387812ULL, 0x000fe200078ee238ULL, 0x0000001041417824ULL, 0x100fe200078e024cULL,
0x000000003c357faeULL, 0x0003e2000c901c46ULL, 0x0000001036487824ULL, 0x000fc400078e024cULL,
0x0000001037497824ULL, 0x100fe200078e024cULL, 0x0000000042407faeULL, 0x0003e2000d101c46ULL,
0x00000010384c7824ULL, 0x000fe400078e024cULL, 0x000000104b367825ULL, 0x000fc800078e0046ULL,
0x000000104b387825ULL, 0x040fe200078e0044ULL, 0x0000000036417faeULL, 0x0003e6000d901c46ULL,
0x000000104b3a7825ULL, 0x040fe200078e003aULL, 0x0000000038487faeULL, 0x0003e6000e101c46ULL,
0x000000104b3e7825ULL, 0x000fe200078e003eULL, 0x000000003a497faeULL, 0x0003e8000e901c46ULL,
0x000000003e4c7faeULL, 0x0003e2000f101c46ULL, 0x00000c6000007947ULL, 0x000fea0003800000ULL,
0x0000000402367811ULL, 0x042fe200078fe8ffULL, 0x00000008656a7824ULL, 0x000fe200078e00ffULL,
0x00000010023e7811ULL, 0x000fc400078fe8ffULL, 0x0000000c023d7811ULL, 0x000fe200078fe8ffULL,
0x0000000136377824ULL, 0x100fe200078e0202ULL, 0x0000001c02477811ULL, 0x000fe200078fe8ffULL,
0x0000000836567824ULL, 0x000fe200078e00ffULL, 0x00000008023c7811ULL, 0x000fe200078fe8ffULL,
0x000000083e597824ULL, 0x000fe200078e00ffULL, 0x0000001802467811ULL, 0x000fe200078fe8ffULL,
0x000000013d397824ULL, 0x140fe200078e0202ULL, 0xfffffff856567812ULL, 0x000fe200078ee237ULL,
0x000000013e377824ULL, 0x100fe200078e0202ULL, 0x00000028024e7811ULL, 0x040fe200078fe8ffULL,
0x000000083d587824ULL, 0x000fe200078e00ffULL, 0x0000001402407811ULL, 0x000fe200078fe8ffULL,
0x00000008475c7824ULL, 0x000fe200078e00ffULL, 0xfffffff859597812ULL, 0x000fe200078ee237ULL,
0x0000000147377824ULL, 0x100fe200078e0202ULL, 0xfffffff858587812ULL, 0x000fe200078ee239ULL,
0x000000013c387824ULL, 0x100fe200078e0202ULL, 0x00000024024a7811ULL, 0x000fe200078fe8ffULL,
0x000000083c577824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee237ULL,
0x0000000146397824ULL, 0x000fe200078e0202ULL, 0x0000002002487811ULL, 0x000fe200078fe8ffULL,
0x00000008465b7824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee238ULL,
0x000000014e377824ULL, 0x100fe200078e0202ULL, 0x0000003002507811ULL, 0x000fe200078fe8ffULL,
0x000000084e5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee239ULL,
0x0000000140387824ULL, 0x100fe200078e0202ULL, 0x0000003802527811ULL, 0x000fe200078fe8ffULL,
0x00000008405a7824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee237ULL,
0x000000014a397824ULL, 0x000fe200078e0202ULL, 0x0000003402517811ULL, 0x000fe200078fe8ffULL,
0x000000084a5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee238ULL,
0x0000000129377824ULL, 0x000fe200078e0236ULL, 0x0000002c024f7811ULL, 0x000fe200078fe8ffULL,
0x0000000148387824ULL, 0x100fe200078e0202ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee239ULL,
0x00000008485d7824ULL, 0x000fe200078e00ffULL, 0x0000002902397211ULL, 0x000fe200078fe8ffULL,
0x00000001503a7824ULL, 0x040fe200078e0202ULL, 0x0000003537377210ULL, 0x080fe20007f5e0ffULL,
0x0000000850617824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee238ULL,
0x0000000152417824ULL, 0x040fe200078e0202ULL, 0x0000003539397210ULL, 0x080fe20007f3e0ffULL,
0x0000000852637824ULL, 0x000fe200078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee23aULL,
0x00000001513f7824ULL, 0x140fe200078e0202ULL, 0x0000003c02547811ULL, 0x000fe200078fe8ffULL,
0x0000000851627824ULL, 0x000fe200078e00ffULL, 0xfffffff863637812ULL, 0x000fe200078ee241ULL,
0x000000014f387824ULL, 0x140fe200078e0202ULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee202ULL,
0x000000084f607824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ee23fULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078440ffULL,
0x0000000129417824ULL, 0x000fe200078e023cULL, 0xfffffff860607812ULL, 0x000fe200078ee238ULL,
0x000000ffff3b7224ULL, 0x000fe200008e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078240ffULL,
0x00000001293f7824ULL, 0x000fe200078e023dULL, 0x00005f0037377a11ULL, 0x000fe200010f443aULL,
0x00000001293d7824ULL, 0x000fe200078e023eULL, 0x0000003541417210ULL, 0x080fe20007f5e0ffULL,
0x0000000129497824ULL, 0x000fe200078e0246ULL, 0x00005f0039397a11ULL, 0x000fe200008f443bULL,
0x00000001293b7824ULL, 0x000fe200078e0240ULL, 0x000000353d3d7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff457224ULL, 0x000fe200010e06ffULL, 0x00005e0041407a11ULL, 0x000fe200078440ffULL,
0x0000000129477824ULL, 0x000fe200078e0247ULL, 0x000000353b3b7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff437224ULL, 0x000fe200020e06ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078840ffULL,
0x0000000129517824ULL, 0x000fe200078e0251ULL, 0x00005f0041417a11ULL, 0x000fe200010f4445ULL,
0x0000000129457824ULL, 0x000fe200078e0248ULL, 0x000000353f3f7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff427224ULL, 0x000fe200008e06ffULL, 0x00005f003d3d7a11ULL, 0x000fe200020f4443ULL,
0x0000000129437824ULL, 0x000fe200078e024aULL, 0x00005e003b3a7a11ULL, 0x000fe200078240ffULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x0000003545457210ULL, 0x080fe20007f9e0ffULL,
0x0000000129537824ULL, 0x000fe200078e0252ULL, 0x00005e003f3e7a11ULL, 0x000fe200078640ffULL,
0x0000000129557824ULL, 0x000fe200078e0254ULL, 0x00005f003b3b7a11ULL, 0x000fe200008f4442ULL,
0x000000ffff4b7224ULL, 0x000fe200020e06ffULL, 0x0000003549497210ULL, 0x080fe20007f5e0ffULL,
0x000000106a387825ULL, 0x000fe200078e0038ULL, 0x0000003543437210ULL, 0x000fc40007f3e0ffULL,
0x00005f003f3f7a11ULL, 0x000fe200018f4444ULL, 0x000000ffff4d7224ULL, 0x000fe200010e06ffULL,
0x00005e0045447a11ULL, 0x000fe200078840ffULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0x0000003547477210ULL, 0x080fe20007f7e0ffULL, 0x000000106a367825ULL, 0x000fe200078e0036ULL,
0x00005e0049487a11ULL, 0x000fe400078440ffULL, 0x00005e0043427a11ULL, 0x000fe200078240ffULL,
0x000000ffff4c7224ULL, 0x000fe200018e06ffULL, 0x00005f0045457a11ULL, 0x000fe200020f444bULL,
0x00000001294b7824ULL, 0x000fe200078e024eULL, 0x00005e0047467a11ULL, 0x000fe200078640ffULL,
0x00000002004e7824ULL, 0x000fe200078e022fULL, 0x00005f0049497a11ULL, 0x000fe200010f444dULL,
0x00000001294d7824ULL, 0x000fe200078e024fULL, 0x00005f0043437a11ULL, 0x000fe200008f444aULL,
0x00000001294f7824ULL, 0x000fe200078e0250ULL, 0x00000002024a7211ULL, 0x000fe200078fe8ffULL,
0x0000000154507824ULL, 0x040fe200078e0202ULL, 0x000000354b4b7210ULL, 0x000fe20007fde0ffULL,
0x0000000854547824ULL, 0x000fe200078e00ffULL, 0x00005f0047477a11ULL, 0x000fe200018f444cULL,
0x000000106a407825ULL, 0x000fe200078e0040ULL, 0x000000074a4c7812ULL, 0x000fc400078ec0ffULL,
0x000000354d4d7210ULL, 0x080fe20007fbe0ffULL, 0x000000106a3e7825ULL, 0x040fe200078e003eULL,
0x000000354f4f7210ULL, 0x080fe40007f9e0ffULL, 0x0000003551517210ULL, 0x080fe20007f3e0ffULL,
0x000000106a3c7825ULL, 0x000fe200078e003cULL, 0x0000003553537210ULL, 0x080fe40007f5e0ffULL,
0x0000003555557210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff357224ULL, 0x000fe200030e06ffULL,
0x00005e004b4a7a11ULL, 0x040fe200078c40ffULL, 0x000000ffff697224ULL, 0x000fe200020e06ffULL,
0x000020004e647811ULL, 0x000fe200078e68ffULL, 0x000000ffff4e7224ULL, 0x000fe200028e06ffULL,
0x0ffffff84c4c7812ULL, 0x000fe200078ef802ULL, 0x000000ffff687224ULL, 0x000fe200008e06ffULL,
0x00005f004b4b7a11ULL, 0x000fe200030f4435ULL, 0x0000001056567824ULL, 0x000fe200078e0264ULL,
0xfffffff854507812ULL, 0x000fe200078ee250ULL, 0x000000104c357824ULL, 0x100fe200078e0264ULL,
0x00005e004d4c7a11ULL, 0x000fe200078a40ffULL, 0x0000001057577824ULL, 0x000fc400078e0264ULL,
0x0000001058587824ULL, 0x000fe200078e0264ULL, 0x00005f004d4d7a11ULL, 0x000fe200028f444eULL,
0x0000001059597824ULL, 0x100fe200078e0264ULL, 0x00005e004f4e7a11ULL, 0x000fe200078840ffULL,
0x000000105a5a7824ULL, 0x100fe200078e0264ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038357faeULL, 0x0003e2000b901c46ULL, 0x000000105b5b7824ULL, 0x100fe200078e0264ULL,
0x00005f004f4f7a11ULL, 0x000fe200020f4469ULL, 0x000000105c5c7824ULL, 0x100fe200078e0264ULL,
0x0000000036567faeULL, 0x0005e2000b901c46ULL, 0x000000105d5d7824ULL, 0x000fc400078e0264ULL,
0x000000105e5e7824ULL, 0x100fe200078e0264ULL, 0x0000000040577faeULL, 0x0005e2000b901c46ULL,
0x000000105f5f7824ULL, 0x100fe400078e0264ULL, 0x0000001060607824ULL, 0x100fe200078e0264ULL,
0x000000003e587faeULL, 0x0005e2000b901c46ULL, 0x0000001061617824ULL, 0x100fe400078e0264ULL,
0x0000001062627824ULL, 0x100fe200078e0264ULL, 0x000000003c597faeULL, 0x0005e2000b901c46ULL,
0x0000001063637824ULL, 0x000fc400078e0264ULL, 0x0000001050647824ULL, 0x000fe200078e0264ULL,
0x00005e0051507a11ULL, 0x000fe200078240ffULL, 0x000000ffff677224ULL, 0x000fe200010e06ffULL,
0x00005e0053527a11ULL, 0x000fe200078440ffULL, 0x000000ffff667224ULL, 0x000fe200018e06ffULL,
0x00005e0055547a11ULL, 0x000fe200078640ffULL, 0x000000106a3a7825ULL, 0x040fe200078e003aULL,
0x00005f0051517a11ULL, 0x000fe400008f4468ULL, 0x00005f0053537a11ULL, 0x000fe200010f4467ULL,
0x000000106a487825ULL, 0x040fe200078e0048ULL, 0x00005f0055557a11ULL, 0x000fe200018f4466ULL,
0x000000003a5a7faeULL, 0x0005e4000b901c46ULL, 0x000000106a467825ULL, 0x000fc400078e0046ULL,
0x00000000485b7faeULL, 0x0005e4000b901c46ULL, 0x000000106a447825ULL, 0x040fe400078e0044ULL,
0x00000000465c7faeULL, 0x0005e4000b901c46ULL, 0x000000106a427825ULL, 0x040fe400078e0042ULL,
0x00000000445d7faeULL, 0x0005e4000b901c46ULL, 0x000000106a387825ULL, 0x002fc400078e004aULL,
0x00000000425e7faeULL, 0x0005e4000b901c46ULL, 0x000000106a4a7825ULL, 0x040fe400078e004cULL,
0x00000000385f7faeULL, 0x0005e4000b901c46ULL, 0x000000106a4c7825ULL, 0x040fe400078e004eULL,
0x000000004a607faeULL, 0x0005e4000b901c46ULL, 0x000000106a4e7825ULL, 0x000fc400078e0050ULL,
0x000000004c617faeULL, 0x0005e4000b901c46ULL, 0x000000106a507825ULL, 0x040fe400078e0052ULL,
0x000000004e627faeULL, 0x0005e4000b901c46ULL, 0x000000106a527825ULL, 0x000fe400078e0054ULL,
0x0000000050637faeULL, 0x0005e8000b901c46ULL, 0x0000000052647faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6500720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x0000000430307810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff077424ULL, 0x000fc600078e00ffULL,
0x000000053000720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000203367824ULL, 0x006fe400078e0230ULL, 0x00000004ff377424ULL, 0x000fc800078e00ffULL,
0x0000600036367625ULL, 0x000fca00078e0037ULL, 0x0000000636077981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002447810ULL, 0x004fe20007ffe0ffULL, 0x0000000200407824ULL, 0x002fe200078e0234ULL,
0x0000000702417812ULL, 0x040fe200078ec0ffULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0xfffffff802437812ULL, 0x000fe400078ec0ffULL, 0xfffffff844447812ULL, 0x000fe400078ec0ffULL,
0x0000200040407811ULL, 0x000fe400078e68ffULL, 0x0000000841417812ULL, 0x000fc400078ef802ULL,
0x0000000743437812ULL, 0x100fe400078ef802ULL, 0x0000000744447812ULL, 0x000fe200078ef802ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000143347824ULL, 0x160fe200078e0242ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000843357824ULL, 0x000fe400078e00ffULL,
0x0000000144387824ULL, 0x040fe400078e0242ULL, 0x0000000844397824ULL, 0x000fe200078e00ffULL,
0xfffffff835347812ULL, 0x000fc800078ee234ULL, 0xfffffff839387812ULL, 0x000fe200078ee238ULL,
0x0000001034347824ULL, 0x000fc800078e0240ULL, 0x0000001038387824ULL, 0x000fe400078e0240ULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x00000018ff3c7819ULL, 0x002fe20000011434ULL, 0x00010000343d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011436ULL, 0x0000003c00527306ULL, 0x0003e20000200c00ULL,
0x00000018ff497819ULL, 0x000fc40000011437ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff487819ULL, 0x004fe40000011438ULL, 0x00000018ff477819ULL, 0x000fe20000011439ULL,
0x0000003d00517306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x002fe40000011435ULL,
0x00000018ff467819ULL, 0x000fe4000001143aULL, 0x00000018ff457819ULL, 0x000fc6000001143bULL,
0x0000003c00567306ULL, 0x0003f00000200c00ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x00008880343c7816ULL, 0x042fe200000000ffULL, 0x0000010034347824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000003c00507306ULL, 0x0002b00000200c00ULL,
0x0000003400537306ULL, 0x0006a20000200c00ULL, 0x00008880353c7816ULL, 0x002fce00000000ffULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000000ffff347224ULL, 0x008fe200078e003cULL,
0x0000541050507816ULL, 0x004fe20000000051ULL, 0x00010000353c7824ULL, 0x040fe400078e00ffULL,
0x0000010035357824ULL, 0x000fc600078e00ffULL, 0x0000003400547306ULL, 0x0003e20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000541053517816ULL, 0x000fc60000000052ULL, 0x0000003500577306ULL, 0x0005e20000200c00ULL,
0x0000888036347816ULL, 0x002fce00000000ffULL, 0x0000003400587306ULL, 0x0003e20000200c00ULL,
0x0001000036357824ULL, 0x044fe400078e00ffULL, 0x0000010036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000003c00557306ULL, 0x000ea20000200c00ULL, 0x0000888037347816ULL, 0x002fce00000000ffULL,
0x0000003500597306ULL, 0x0002f00000200c00ULL, 0x00000036005a7306ULL, 0x0006e20000200c00ULL,
0x0001000037357824ULL, 0x042fe200078e00ffULL, 0x0000541054547816ULL, 0x004fe20000000055ULL,
0x0000010037377824ULL, 0x000fe200078e00ffULL, 0x0000541057557816ULL, 0x000fc40000000056ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x00000034005b7306ULL, 0x0003e20000200c00ULL, 0x0000000142367810ULL, 0x008fe40007ffe0ffULL,
0x0000541058587816ULL, 0x000fe40000000059ULL, 0x000054105a597816ULL, 0x000fc6000000004eULL,
0x00000035005c7306ULL, 0x0004e20000200c00ULL, 0x0000888038347816ULL, 0x002fce00000000ffULL,
0x00000037005d7306ULL, 0x0002e20000200c00ULL, 0x0001000038357824ULL, 0x044fe400078e00ffULL,
0x0000010038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000000843377824ULL, 0x002fe200078e00ffULL,
0x00000035005f7306ULL, 0x0003e20000200c00ULL, 0x000054105b5c7816ULL, 0x008fe4000000005cULL,
0x000054105d5d7816ULL, 0x000fca0000000049ULL, 0x00000034005e7306ULL, 0x0004e20000200c00ULL,
0x0000000143357824ULL, 0x102fe400078e0236ULL, 0x0000000144367824ULL, 0x000fc600078e0236ULL,
0xfffffff837377812ULL, 0x000fe200078ee235ULL, 0x0001000039357824ULL, 0x040fe200078e00ffULL,
0x0000003800607306ULL, 0x0003e20000200c00ULL, 0x0000888039347816ULL, 0x044fe200000000ffULL,
0x0000010039397824ULL, 0x000fe400078e00ffULL, 0x0000001037377824ULL, 0x000fe200078e0240ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003400617306ULL, 0x0005e20000200c00ULL, 0x00000000373c783bULL, 0x000ea20000000200ULL,
0x000088803b387816ULL, 0x002fc400000000ffULL, 0x000054105e5e7816ULL, 0x008fc8000000005fULL,
0x0000003500627306ULL, 0x0002e20000200c00ULL, 0x000088803a347816ULL, 0x004fce00000000ffULL,
0x0000003800677306ULL, 0x000fe20000200c00ULL, 0x0000000844357824ULL, 0x002fca00078e00ffULL,
0xfffffff835367812ULL, 0x000fe200078ee236ULL, 0x000100003a357824ULL, 0x040fe200078e00ffULL,
0x0000003900637306ULL, 0x0003e20000200c00ULL, 0x000001003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541061627816ULL, 0x008fe20000000062ULL, 0x0000001036367824ULL, 0x000fe200078e0240ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003400647306ULL, 0x000fe20000200c00ULL, 0x000100003b397824ULL, 0x002fc400078e00ffULL,
0x000001003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003a00667306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe4000001143cULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x000088803e727816ULL, 0x000fe400000000ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001143fULL, 0x00000038006c7306ULL, 0x0005e20000200c00ULL,
0x00000008333a7824ULL, 0x002fe200078e0242ULL, 0x0000000242427810ULL, 0x000fc80007ffe0ffULL,
0x000000084200780cULL, 0x000fe40003f25270ULL, 0x0000003900687306ULL, 0x0002e20000200c00ULL,
0x00000018ff387819ULL, 0x004fce000001143dULL, 0x0000003800707306ULL, 0x0005e20000200c00ULL,
0x000100003c397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003b00697306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x004fe4000001143eULL,
0x0000541067687816ULL, 0x008fca0000000068ULL, 0x0000003800747306ULL, 0x0005e20000200c00ULL,
0x000088803d3b7816ULL, 0x002fce00000000ffULL, 0x00000039006b7306ULL, 0x000fe20000200c00ULL,
0x000088803c387816ULL, 0x004fce00000000ffULL, 0x00000038006a7306ULL, 0x0002b00000200c00ULL,
0x0000003500657306ULL, 0x0006a20000200c00ULL, 0x000001003c387824ULL, 0x002fe400078e00ffULL,
0x000000023a3c7824ULL, 0x000fc400078e00ffULL, 0x00000020413a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011438ULL, 0x0000003c02387211ULL, 0x000fe200078fe0ffULL,
0x000000003634783bULL, 0x008e620000000200ULL, 0x00000039006d7306ULL, 0x0006e20000200c00ULL,
0x000000023c3c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000141387824ULL, 0x000fe200078e0238ULL,
0x000054106a6a7816ULL, 0x004fe4000000006bULL, 0x0000003c023c7211ULL, 0x000fc400078fe0ffULL,
0xffffffe03a387812ULL, 0x000fe200078ee238ULL, 0x000100003d3a7824ULL, 0x040fe200078e00ffULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x000000ffff397224ULL, 0x008fe200078e003bULL,
0x0000541064647816ULL, 0x000fe20000000065ULL, 0x0000001038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x000001003d3d7824ULL, 0x000fe200078e00ffULL,
0x000054106d6b7816ULL, 0x000fe2000000006cULL, 0x00000001413c7824ULL, 0x000fe200078e023cULL,
0x00000039006e7306ULL, 0x000fe40000200c00ULL, 0x00000018ff3d7819ULL, 0x000fcc000001143dULL,
0x0000003a006f7306ULL, 0x0007e20000200c00ULL, 0x00005410605f7816ULL, 0x004fce0000000048ULL,
0x0000003d00717306ULL, 0x0005e20000200c00ULL, 0x000000003838783bULL, 0x008ee20000000200ULL,
0x00008880354e7816ULL, 0x002fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fc80000011435ULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x000000ffff3d7224ULL, 0x004fe200078e0072ULL,
0x00000018ff4d7819ULL, 0x000fe20000011434ULL, 0x000100003e727824ULL, 0x040fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011436ULL, 0x000001003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011437ULL, 0x000000ffff497224ULL, 0x000fe200078e004eULL,
0x0000003d00737306ULL, 0x0005e20000200c00ULL, 0x00010000354e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000010035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc40000011472ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000003e00757306ULL, 0x0003e20000200c00ULL, 0x000088803f3d7816ULL, 0x004fe400000000ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000541063637816ULL, 0x002fe40000000047ULL,
0x000054106e6e7816ULL, 0x000fe2000000006fULL, 0x0000003d00767306ULL, 0x0003e20000200c00ULL,
0x000100003f3e7824ULL, 0x000fe200078e00ffULL, 0x00005410716f7816ULL, 0x000fe20000000070ULL,
0x000001003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000004600467306ULL, 0x000ea20000200c00ULL, 0x00008880343d7816ULL, 0x002fe200000000ffULL,
0x000000503824723cULL, 0x008b620000001824ULL, 0x00000018ff3f7819ULL, 0x000fca000001143fULL,
0x0000004500457306ULL, 0x000e640000200c00ULL, 0x000000543820723cULL, 0x040f6c0000001820ULL,
0x0000003d00507306ULL, 0x0207e20000200c00ULL, 0x0000541066657816ULL, 0x004fe20000000046ULL,
0x00000058381c723cULL, 0x000f62000000181cULL, 0x0001000036467824ULL, 0x000fca00078e00ffULL,
0x0000003e00777306ULL, 0x0005e20000200c00ULL, 0x00000020413d7824ULL, 0x008fe200078e00ffULL,
0x0000541069697816ULL, 0x002fe20000000045ULL, 0x0000005c3818723cULL, 0x040fe20000001818ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0xffffffe03d3c7812ULL, 0x000fe200078ee23cULL,
0x00000100343d7824ULL, 0x040fe200078e00ffULL, 0x0000004e00487306ULL, 0x0003e20000200c00ULL,
0x00010000343e7824ULL, 0x004fe400078e00ffULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000005e3814723cULL, 0x000fe20000001814ULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x0000003f00527306ULL, 0x000fe20000200c00ULL,
0x00008880364e7816ULL, 0x042fe200000000ffULL, 0x0000010036367824ULL, 0x000fc600078e00ffULL,
0x000000623810723cULL, 0x040f640000001810ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000003e00347306ULL, 0x000e6a0000200c00ULL, 0x00000064380c723cULL, 0x040f66000000180cULL,
0x0000003d00517306ULL, 0x0005ea0000200c00ULL, 0x000000683808723cULL, 0x000b660000001808ULL,
0x0000003500477306ULL, 0x0007e20000200c00ULL, 0x000000003c3c783bULL, 0x004ea20000000200ULL,
0x0000541050347816ULL, 0x002fc40000000034ULL, 0x0001000037387824ULL, 0x020fc800078e00ffULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x000000ffff357224ULL, 0x008fe200078e004eULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00005410764e7816ULL, 0x000fc80000000077ULL,
0x0000003500537306ULL, 0x0007f00000200c00ULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x0000888037357816ULL, 0x048fe200000000ffULL, 0x0000010037377824ULL, 0x000fe200078e00ffULL,
0x0000541049487816ULL, 0x002fc80000000048ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000007200727306ULL, 0x000e700000200c00ULL, 0x0000003500397306ULL, 0x000fe20000200c00ULL,
0x0000541047497816ULL, 0x004fe2000000004cULL, 0x0000006a3c24723cULL, 0x040b6c0000001824ULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x0000541073727816ULL, 0x002fe20000000072ULL,
0x0000006e3c20723cULL, 0x000b620000001820ULL, 0x0000541075737816ULL, 0x000fca0000000074ULL,
0x0000004f004f7306ULL, 0x000e640000200c00ULL, 0x000000723c1c723cULL, 0x040b6c000000181cULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x0000541039387816ULL, 0x004fe20000000038ULL,
0x000000483c10723cULL, 0x000b6c0000001810ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00005410524f7816ULL, 0x002fce000000004fULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x0000541051357816ULL, 0x008fe2000000004dULL, 0x0000004e3c18723cULL, 0x040b6c0000001818ULL,
0x0000004600467306ULL, 0x000e640000200c00ULL, 0x000000343c14723cULL, 0x000b6c0000001814ULL,
0x0000003600367306ULL, 0x000eb00000200c00ULL, 0x0000003700377306ULL, 0x000ee20000200c00ULL,
0x0000541053467816ULL, 0x002fc40000000046ULL, 0x0000541036477816ULL, 0x004fce000000004bULL,
0x000000463c0c723cULL, 0x000b62000000180cULL, 0x0000541037397816ULL, 0x008fce000000004aULL,
0x000000383c08723cULL, 0x000b620000001808ULL, 0xfffff03000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff347224ULL, 0x020fe200078e002fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd39000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000002a1a347220ULL, 0x080fe40000410000ULL,
0x0000002a1e327220ULL, 0x080fe40000410000ULL, 0x0000002a1b357220ULL, 0x080fe40000410000ULL,
0x0000002a141a7220ULL, 0x080fe40000410000ULL, 0x0000002a1c1c7220ULL, 0x000fc40000410000ULL,
0x0000002a1d1d7220ULL, 0x080fe40000410000ULL, 0x0000002a1f337220ULL, 0x080fe40000410000ULL,
0x0000002a151b7220ULL, 0x080fe40000410000ULL, 0x0000002a101e7220ULL, 0x080fe40000410000ULL,
0x0000002a24247220ULL, 0x080fe40000410000ULL, 0x0000002a25257220ULL, 0x000fc40000410000ULL,
0x0000002a20207220ULL, 0x080fe40000410000ULL, 0x0000002a21217220ULL, 0x080fe40000410000ULL,
0x0000002a18187220ULL, 0x080fe40000410000ULL, 0x0000002a19197220ULL, 0x080fe40000410000ULL,
0x0000002a111f7220ULL, 0x080fe40000410000ULL, 0x0000002a0c0c7220ULL, 0x000fc40000410000ULL,
0x0000002a0d0d7220ULL, 0x080fe40000410000ULL, 0x0000002a08087220ULL, 0x080fe40000410000ULL,
0x0000002a16367220ULL, 0x080fe40000410000ULL, 0x0000002a17377220ULL, 0x080fe40000410000ULL,
0x0000002a12387220ULL, 0x080fe40000410000ULL, 0x0000002a13397220ULL, 0x000fc40000410000ULL,
0x000000ffff167224ULL, 0x000fe400078e001aULL, 0x0000002a0e3a7220ULL, 0x080fe40000410000ULL,
0x0000002a0f3b7220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fe400078e001cULL,
0x000000ffff137224ULL, 0x000fe400078e001dULL, 0x000000ffff177224ULL, 0x000fc400078e001bULL,
0x000000ffff1a7224ULL, 0x000fe400078e001eULL, 0x0000002a26267220ULL, 0x080fe40000410000ULL,
0x0000002a27277220ULL, 0x080fe40000410000ULL, 0x0000002a22227220ULL, 0x080fe40000410000ULL,
0x0000002a23237220ULL, 0x080fe40000410000ULL, 0x0000002a09097220ULL, 0x000fc40000410000ULL,
0x0000002a0a0a7220ULL, 0x080fe40000410000ULL, 0x0000002a0b0b7220ULL, 0x000fe40000410000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0024ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0025ULL,
0x000000ffff107224ULL, 0x000fe400078e0020ULL, 0x000000ffff117224ULL, 0x000fc400078e0021ULL,
0x000000ffff147224ULL, 0x000fe400078e0018ULL, 0x000000ffff157224ULL, 0x000fe400078e0019ULL,
0x000000ffff1b7224ULL, 0x000fe400078e001fULL, 0x000000ffff1c7224ULL, 0x000fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000dULL, 0x000000ffff1e7224ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002b0c7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff207224ULL, 0x000fc400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff247224ULL, 0x000fe400078e0032ULL, 0x000000ffff257224ULL, 0x000fe400078e0033ULL,
0x000000ffff267224ULL, 0x000fe400078e0034ULL, 0x000000ffff277224ULL, 0x000fe400078e0035ULL,
0x000000ffff327224ULL, 0x000fc400078e0036ULL, 0x000000ffff337224ULL, 0x000fe400078e0037ULL,
0x000000ffff347224ULL, 0x000fe400078e0038ULL, 0x000000ffff357224ULL, 0x000fe400078e0039ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0009ULL, 0x000000ffff367224ULL, 0x000fe400078e003aULL,
0x000000ffff377224ULL, 0x000fc400078e003bULL, 0x000000ffff387224ULL, 0x000fe400078e000aULL,
0x000000ffff397224ULL, 0x000fc400078e000bULL, 0x0000000000087805ULL, 0x006fca0000015200ULL,
0x000004002b0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08187210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09001800780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401800780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x000000180a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000119197810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004002b0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000402197824ULL, 0x000fe200078e00ffULL, 0x0000002c2e00720cULL, 0x000fc80003f05270ULL,
0xfffffff019187812ULL, 0x000fca00078ec0ffULL, 0x0000008000187824ULL, 0x000fca00078e0218ULL,
0x0184000018087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002020c7824ULL, 0x000fe400078e00ffULL, 0x0000000104317824ULL, 0x000fc600078e0a31ULL,
0x000000060c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000010c0d7812ULL, 0x040fe400078efcffULL,
0x000000080c3a7812ULL, 0x040fe400078efcffULL, 0x000000310d00720cULL, 0x080fe40003f26070ULL,
0x000000100c0d7812ULL, 0x000fe400078efcffULL, 0x000000313a00720cULL, 0x080fe40003f06070ULL,
0x000000310d00720cULL, 0x000fc40003fc6070ULL, 0x000000110c3a7812ULL, 0x040fe400078efcffULL,
0x000000180c0d7812ULL, 0x040fe400078efcffULL, 0x000000310c00720cULL, 0x080fe40003f46070ULL,
0x000000313a00720cULL, 0x080fe40003fa6070ULL, 0x000000310d00720cULL, 0x000fe40003f66070ULL,
0x000000090c3b7812ULL, 0x000fc400078efcffULL, 0x000000190c3a7812ULL, 0x040fe400078efcffULL,
0x000000200c0d7812ULL, 0x000fe400078efcffULL, 0xff80000020207808ULL, 0x000fe40005000000ULL,
0xff8000000e0e7808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0xff8000000f0f7808ULL, 0x000fc40004800000ULL, 0x000000313b00720cULL, 0x080fe40003f86070ULL,
0x000000313a00720cULL, 0x080fe40003f46070ULL, 0x000000310d00720cULL, 0x000fe40003f26070ULL,
0x000000210c3a7812ULL, 0x040fe400078efcffULL, 0x000000280c0d7812ULL, 0x000fe400078efcffULL,
0xff80000022227808ULL, 0x000fc40004000000ULL, 0xff80000010107808ULL, 0x000fe40004000000ULL,
0xff80000023237808ULL, 0x000fe40006000000ULL, 0xff80000011117808ULL, 0x000fe40006000000ULL,
0x000000313a00720cULL, 0x080fe40003f06070ULL, 0x000000310d00720cULL, 0x000fe40003f86070ULL,
0x000000290c3a7812ULL, 0x000fc400078efcffULL, 0x000000300c0d7812ULL, 0x000fe400078efcffULL,
0xff80000024247808ULL, 0x000fe40007000000ULL, 0xff80000012127808ULL, 0x000fe40007000000ULL,
0xff80000025257808ULL, 0x000fe40006800000ULL, 0xff80000013137808ULL, 0x000fe40006800000ULL,
0x000000313a00720cULL, 0x000fc40003fc6070ULL, 0x000000310d00720cULL, 0x000fe40003fa6070ULL,
0x000000310c3a7812ULL, 0x040fe400078efcffULL, 0x000000380c0d7812ULL, 0x040fe400078efcffULL,
0x000000390c0c7812ULL, 0x000fe400078efcffULL, 0xff80000026267808ULL, 0x000fe40005800000ULL,
0xff80000014147808ULL, 0x000fc40005800000ULL, 0xff80000027277808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40005000000ULL, 0xff80000032327808ULL, 0x000fe40004800000ULL,
0xff80000016167808ULL, 0x000fe40004800000ULL, 0x000000313a00720cULL, 0x080fe40003f66070ULL,
0x000000310d00720cULL, 0x000fc40003f46070ULL, 0x000000310c00720cULL, 0x000fe40003f26070ULL,
0xff80000033337808ULL, 0x000fe40004000000ULL, 0xff80000017177808ULL, 0x000fe40004000000ULL,
0xff80000034347808ULL, 0x000fe40006000000ULL, 0xff8000001a1a7808ULL, 0x000fe40006000000ULL,
0xff80000035357808ULL, 0x000fc40007000000ULL, 0xff8000001b1b7808ULL, 0x000fe40007000000ULL,
0xff80000036367808ULL, 0x000fe40006800000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff80000037377808ULL, 0x000fe40005800000ULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff80000038387808ULL, 0x000fc40005000000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff80000039397808ULL, 0x000fe40004800000ULL, 0xff8000001f1f7808ULL, 0x000fc40004800000ULL,
0x0000000e0800720bULL, 0x004fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000080e087208ULL, 0x000fe40004000000ULL, 0x0000000920097208ULL, 0x000fc40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000210900720bULL, 0x000fe40003f3e000ULL,
0x000000080f087208ULL, 0x000fe40004000000ULL, 0x0000000921097208ULL, 0x000fe40004800000ULL,
0x000000100800720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fc40003f3e000ULL,
0x0000000810087208ULL, 0x000fe40004000000ULL, 0x0000000922097208ULL, 0x000fe40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x000000230900720bULL, 0x000fe40003f3e000ULL,
0x0000000811087208ULL, 0x000fe40004000000ULL, 0x0000000923097208ULL, 0x000fc40004800000ULL,
0x000000120800720bULL, 0x000fe40003f1e000ULL, 0x000000240900720bULL, 0x000fe40003f3e000ULL,
0x0000000812087208ULL, 0x000fe40004000000ULL, 0x0000000924097208ULL, 0x000fe40004800000ULL,
0x000000130800720bULL, 0x000fe40003f1e000ULL, 0x000000250900720bULL, 0x000fc40003f3e000ULL,
0x0000000813087208ULL, 0x000fe40004000000ULL, 0x0000000925097208ULL, 0x000fe40004800000ULL,
0x000000140800720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fe40003f3e000ULL,
0x0000000814087208ULL, 0x000fe40004000000ULL, 0x0000000926097208ULL, 0x000fc40004800000ULL,
0x000000150800720bULL, 0x000fe40003f1e000ULL, 0x000000270900720bULL, 0x000fe40003f3e000ULL,
0x0000000815087208ULL, 0x000fe40004000000ULL, 0x0000000927097208ULL, 0x000fe40004800000ULL,
0x000000160800720bULL, 0x000fe40003f1e000ULL, 0x000000320900720bULL, 0x000fc40003f3e000ULL,
0x0000000816087208ULL, 0x000fe40004000000ULL, 0x0000000932097208ULL, 0x000fe40004800000ULL,
0x000000170800720bULL, 0x000fe40003f1e000ULL, 0x000000330900720bULL, 0x000fe40003f3e000ULL,
0x0000000817087208ULL, 0x000fe40004000000ULL, 0x0000000933097208ULL, 0x000fc40004800000ULL,
0x0000001a0800720bULL, 0x000fe40003f1e000ULL, 0x000000340900720bULL, 0x000fe40003f3e000ULL,
0x000000081a087208ULL, 0x000fe40004000000ULL, 0x0000000934097208ULL, 0x000fe40004800000ULL,
0x0000001b0800720bULL, 0x000fe40003f1e000ULL, 0x000000350900720bULL, 0x000fc40003f3e000ULL,
0x000000081b087208ULL, 0x000fe40004000000ULL, 0x0000000935097208ULL, 0x000fe40004800000ULL,
0x0000001c0800720bULL, 0x000fe40003f1e000ULL, 0x000000360900720bULL, 0x000fe40003f3e000ULL,
0x000000081c087208ULL, 0x000fe40004000000ULL, 0x0000000936097208ULL, 0x000fc40004800000ULL,
0x0000001d0800720bULL, 0x000fe40003f1e000ULL, 0x000000370900720bULL, 0x000fe40003f3e000ULL,
0x000000081d087208ULL, 0x000fe40004000000ULL, 0x0000000937097208ULL, 0x000fe40004800000ULL,
0x0000001e0800720bULL, 0x000fe40003f1e000ULL, 0x000000380900720bULL, 0x000fc40003f3e000ULL,
0x000000081e087208ULL, 0x000fe40004000000ULL, 0x0000000938097208ULL, 0x000fe40004800000ULL,
0x0000001f0800720bULL, 0x000fe40003f1e000ULL, 0x000000390900720bULL, 0x000fe40003f3e000ULL,
0x000000081f3b7208ULL, 0x000fe40004000000ULL, 0x0000000939097208ULL, 0x000fe20004800000ULL,
0x00001ad27f007947ULL, 0x000fec000b800000ULL, 0x0c401f003b087f89ULL, 0x0004e400000e0000ULL,
0x000000083b00720bULL, 0x008fc80003f1e000ULL, 0x0000003b083b7208ULL, 0x004fe20004000000ULL,
0x00001b127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009087f89ULL, 0x000ea800000e0000ULL,
0x0c401f000a0c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000b0d7f89ULL, 0x000e6200000e0000ULL,
0x000000080900720bULL, 0x004fc40003f1e000ULL, 0x0000000c0a00720bULL, 0x008fe40003f3e000ULL,
0x0000000908097208ULL, 0x000fe40004000000ULL, 0x0000000a0c0a7208ULL, 0x000fe20004800000ULL,
0x0c201f003b087f89ULL, 0x000ea200000e0000ULL, 0x0000000d0b00720bULL, 0x002fc60003f1e000ULL,
0x0c201f00090c7f89ULL, 0x000e6200000e0000ULL, 0x0000000b0d0b7208ULL, 0x000fc60004000000ULL,
0x0c201f000a317f89ULL, 0x000ee800000e0000ULL, 0x0c201f000b3a7f89ULL, 0x0002e200000e0000ULL,
0x000000083b00720bULL, 0x004fe40003f1e000ULL, 0x0000000c0900720bULL, 0x002fe40003f3e000ULL,
0x0000003b08087208ULL, 0x000fe40004000000ULL, 0x000000310a00720bULL, 0x008fc40003f5e000ULL,
0x000000090c097208ULL, 0x000fe40004800000ULL, 0x0000000a310a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080c7820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff427424ULL, 0x000fe200078e00ffULL, 0x0000000c19197812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080cULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080cULL, 0x0000003a0b00720bULL, 0x004fe20003f3e000ULL,
0x0000001c003e7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080cULL, 0x0000000b3a0b7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b11117823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001080cULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b091c7820ULL, 0x002fe40000410000ULL,
0x3fb8aa3b13137823ULL, 0x000fe4000001080cULL, 0x3fb8aa3b21217823ULL, 0x000fc4000001081cULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001081cULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b20207823ULL, 0x000fe4000001081cULL,
0x3fb8aa3b14147823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001080cULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080cULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b1f0c7823ULL, 0x000fc4000001080cULL, 0x3c003c00ff437424ULL, 0x000fe200078e00ffULL,
0x00000020000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b25257823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x3fb8aa3b32327823ULL, 0x000fc4000001081cULL, 0x3fb8aa3b33337823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b34347823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001081cULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b36367823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b37377823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b38387823ULL, 0x000fc4000001081cULL,
0x3fb8aa3b39397823ULL, 0x000fe2000001081cULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x0000000d210d723eULL, 0x002fce00000000ffULL, 0x0000000c00417308ULL, 0x0003f00000000800ULL,
0x0000001400317308ULL, 0x000fe20000000800ULL, 0x0000000e0f0c723eULL, 0x002fe400000000ffULL,
0x00000010110e723eULL, 0x000fc400000000ffULL, 0x00000022230f723eULL, 0x004fc600000000ffULL,
0x00000015003b7308ULL, 0x000ff00000000800ULL, 0x00000016003c7308ULL, 0x000ff00000000800ULL,
0x00000017003d7308ULL, 0x0003f00000000800ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x000000420c14723cULL, 0x002f6e00000018ffULL, 0x0000001300137308ULL, 0x000e700000000800ULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000121310723eULL, 0x002fc400000000ffULL, 0x000000313b12723eULL, 0x000fe400000000ffULL,
0x00000002ff3b7819ULL, 0x000fc60000011602ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000013b207810ULL, 0x040fe40007ffe0ffULL, 0x000000023b217810ULL, 0x040fe40007ffe0ffULL,
0x000000063b317810ULL, 0x000fc60007ffe0ffULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000242511723eULL, 0x004fe200000000ffULL, 0x000000083b247824ULL, 0x040fe400078e00ffULL,
0x000000083b257824ULL, 0x000fc600078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee220ULL,
0x0000001d003f7308ULL, 0x000fe20000000800ULL, 0xfffffff825257812ULL, 0x000fe400078ee221ULL,
0x000000262713723eULL, 0x002fca00000000ffULL, 0x0000001e00407308ULL, 0x0003e20000000800ULL,
0x000000083b267824ULL, 0x040fe400078e00ffULL, 0x000000083b277824ULL, 0x000fca00078e00ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x00000042101c723cULL, 0x022b6e0000001814ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000033b147810ULL, 0x060fe40007ffe0ffULL,
0x000000043b157810ULL, 0x000fc40007ffe0ffULL, 0xfffffff826267812ULL, 0x000fe400078ee214ULL,
0xfffffff827277812ULL, 0x000fe200078ee215ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000003c3d14723eULL, 0x000fce00000000ffULL, 0x0000003300337308ULL, 0x000ea20000000800ULL,
0x0000001a1b16723eULL, 0x002fe200000000ffULL, 0x000000083b1a7824ULL, 0x040fe200078e00ffULL,
0x000000053b1b7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee23bULL,
0x0000003400347308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000e620000000800ULL,
0x000000323315723eULL, 0x004fc400000000ffULL, 0x000000083b337810ULL, 0x040fe40007ffe0ffULL,
0xffffffff3b327810ULL, 0x000fc60007ffe0ffULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000343517723eULL, 0x002fce00000000ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000083b347824ULL, 0x040fe400078e00ffULL, 0x000000083b357824ULL, 0x040fe400078e00ffULL,
0x000000083b3b7824ULL, 0x000fe200078e00ffULL, 0x000000421420723cULL, 0x000b62000000181cULL,
0xfffffff8341b7812ULL, 0x000fe200078ee21bULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x0001200000347811ULL, 0x000fe400078e58ffULL, 0xfffffff835317812ULL, 0x000fc400078ee231ULL,
0x00000008331c7824ULL, 0x020fe200078e00ffULL, 0x00000040411e723eULL, 0x000fe200000000ffULL,
0x000000101a1a7824ULL, 0x100fe200078e0234ULL, 0x0000003900397308ULL, 0x000ea20000000800ULL,
0x00000036371d723eULL, 0x002fe200000000ffULL, 0x0000001024247824ULL, 0x100fe200078e0234ULL,
0xfffffff81c337812ULL, 0x000fe200078ee233ULL, 0x0000001025257824ULL, 0x100fe200078e0234ULL,
0x0000003e3f1c723eULL, 0x000fe200000000ffULL, 0x0000001026267824ULL, 0x000fe200078e0234ULL,
0xfffffff83b327812ULL, 0x000fe200078ee232ULL, 0x0000001027277824ULL, 0x000fc400078e0234ULL,
0x000000011a1a7824ULL, 0x000fe400078e0219ULL, 0x000000101b1b7824ULL, 0x000fe400078e0234ULL,
0x0000000119247824ULL, 0x000fe200078e0224ULL, 0x0000000c1a007388ULL, 0x0003e20000000800ULL,
0x00000038391f723eULL, 0x004fe200000000ffULL, 0x0000001031317824ULL, 0x100fe400078e0234ULL,
0x0000000119257824ULL, 0x000fe200078e0225ULL, 0x0000000e24007388ULL, 0x0003e20000000800ULL,
0x0000001032327824ULL, 0x000fc400078e0234ULL, 0x000000421c20723cULL, 0x000f620000001820ULL,
0x0000000119267824ULL, 0x000fe200078e0226ULL, 0x0000001025007388ULL, 0x0003e20000000800ULL,
0x0000001033337824ULL, 0x000fe400078e0234ULL, 0x0000000119277824ULL, 0x040fe200078e0227ULL,
0x0000001226007388ULL, 0x0003e20000000800ULL, 0x00000001191b7824ULL, 0x040fe400078e021bULL,
0x0000000119317824ULL, 0x040fe200078e0231ULL, 0x0000001427007388ULL, 0x0003e20000000800ULL,
0x0000000119327824ULL, 0x000fc400078e0232ULL, 0x0000000119337824ULL, 0x000fe200078e0233ULL,
0x000000161b007388ULL, 0x0003e80000000800ULL, 0x0000001c31007388ULL, 0x0003e80000000800ULL,
0x0000001e32007388ULL, 0x0003e40000000800ULL, 0x000000ffff217224ULL, 0x020fc400078e0022ULL,
0x0000000d33007388ULL, 0x0003e80000000800ULL, 0x0004000f24007388ULL, 0x0003e80000000800ULL,
0x0004001125007388ULL, 0x0003e80000000800ULL, 0x0004001326007388ULL, 0x0003e80000000800ULL,
0x0004001527007388ULL, 0x0003e80000000800ULL, 0x000400171b007388ULL, 0x0003e80000000800ULL,
0x0004001d31007388ULL, 0x0003e80000000800ULL, 0x0004001f32007388ULL, 0x0003e80000000800ULL,
0x0180000818008388ULL, 0x0003e80000000c00ULL, 0x0182002018008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002dff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002dff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000012e2e7810ULL, 0x000fe20007ffe0ffULL,
0x000018002dff7f8cULL, 0x0003e6000c80043fULL, 0x000000062e00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb61000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff427807ULL, 0x004fe20004000000ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x00019c5000437802ULL, 0x000fc40000000f00ULL,
0x0000138000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0048ULL,
0xfffe848000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe20005000000ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x00019cb000437802ULL, 0x000fc40000000f00ULL,
0x0000132000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0048ULL,
0xfffe84b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x002fe200078e0015ULL,
0x00019d2000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x0000127000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff597224ULL, 0x004fe200078e0051ULL, 0xfffe853000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0015ULL, 0x00019d9000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x0000120000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff597224ULL, 0x004fe200078e0051ULL,
0xfffe863000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0012ULL,
0x00019e0000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x0000119000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0051ULL, 0xfffe8a1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x00019e7000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x0000112000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0051ULL,
0xfffe89d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e001aULL,
0x00019ee000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x000010b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0051ULL, 0xfffea85000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x00019f5000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x0000104000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0051ULL,
0xfffea81000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x008fe20004000000ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x00019fb000437802ULL, 0x000fc40000000f00ULL,
0x0000102000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff457224ULL, 0x000fe200078e0048ULL,
0xfffec71000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe20005000000ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x0001a01000437802ULL, 0x000fc40000000f00ULL,
0x00000fc000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff467224ULL, 0x000fe200078e0048ULL,
0xfffec74000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0042ULL,
0x0001a08000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x00000f1000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0051ULL, 0xfffec7e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0042ULL, 0x0001a0f000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x00000ea000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0051ULL,
0xfffec8d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0040ULL,
0x0001a16000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0051ULL, 0xfffeccf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x0001a1d000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x00000dc000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0051ULL,
0xfffeccb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e003cULL,
0x0001a24000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0051ULL, 0xfffee91000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x0001a2b000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0051ULL,
0xfffee8d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x008fe20004000000ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x0001a31000437802ULL, 0x000fc40000000f00ULL,
0x00000cc000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff457224ULL, 0x000fe200078e0048ULL,
0xffff06d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe20005000000ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x0001a37000437802ULL, 0x000fc40000000f00ULL,
0x00000c6000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff467224ULL, 0x000fe200078e0048ULL,
0xffff06f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0042ULL,
0x0001a3e000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x00000bb000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0051ULL, 0xffff079000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0042ULL, 0x0001a45000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x00000b4000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0051ULL,
0xffff088000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0040ULL,
0x0001a4c000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x00000ad000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0051ULL, 0xffff0c8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x0001a53000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x00000a6000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0051ULL,
0xffff0c4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e003cULL,
0x0001a5a000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x000009f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0051ULL, 0xffff28a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x0001a61000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x0000098000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0051ULL,
0xffff286000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x008fe20004000000ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x0001a67000437802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff477224ULL, 0x000fe200078e0048ULL,
0xffff466000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe20004800000ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x0001a6d000437802ULL, 0x000fc40000000f00ULL,
0x0000090000007944ULL, 0x014fea0003c00000ULL, 0xffff469000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e000eULL, 0x0001a73000427802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff517424ULL, 0x000fc400078e00ffULL,
0x0000086000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0051ULL,
0xffff473000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e000eULL,
0x0001a7a000427802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x000007f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0051ULL, 0xffff482000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x008fe200078e000eULL, 0x0001a82000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fe400078e0040ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x0000077000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0051ULL, 0xffff4c1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x0001a8a000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x008fe400078e000eULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x000006f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0051ULL, 0xffff4bc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e000dULL, 0x0001a92000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fc400078e000eULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x0000067000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0051ULL, 0xffff685000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x0001a9a000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fe400078e000dULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fc400078e00ffULL, 0x000005f000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0051ULL, 0xffff680000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x000fe200078e003bULL, 0x0001aa2000317802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fc400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003aULL, 0xffffe4c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0x0001aaa000317802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x012fea0003c00000ULL,
0x0000003a0900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000aULL,
0x0001ab2000317802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000093a097208ULL, 0x000fe20004000000ULL, 0x0000001fff3a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000bULL,
0x0001aba000317802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000a3a0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e003bULL,
0x0001ac2000317802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000b3a0b7208ULL, 0x000fe20004000000ULL, 0x0000001fff3a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x0000003a3b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0009ULL,
0x0001aca000317802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003b3a087208ULL, 0x000fe20004000000ULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000aULL,
0x0001ad2000317802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000093a097208ULL, 0x000fe20004000000ULL, 0x0000001fff3a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000bULL,
0x0001ada000317802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000a3a0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0xffffe2b000007947ULL, 0x000fea000383ffffULL, 0x0180000003027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000000300028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000204ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000003037812ULL, 0x002fe400078ec0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000204ff7212ULL, 0x000fda000780c0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000300027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x002fc800078e00ffULL, 0xfffe50c002007950ULL, 0x000fea0003c3ffffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0c00000d0c3a7389ULL, 0x0002a400000e003aULL,
0x000000ffff0c7224ULL, 0x002fe400078e0031ULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffe50700c007950ULL, 0x000fea0003c3ffffULL, 0x0000005100007348ULL, 0x000fe80003800000ULL,
0x000000595a517389ULL, 0x0002a400000e0043ULL, 0x00000000ff437424ULL, 0x002fc800078e00ffULL,
0xfffe503042007950ULL, 0x000fea0003c3ffffULL, 0x000000014200780cULL, 0x000fe20003f45070ULL,
0x0000004800007348ULL, 0x000fd80003800000ULL, 0x0000000000427806ULL, 0x000fc800050e0100ULL,
0x0000004842487212ULL, 0x000fe200078ec0ffULL, 0x000000ffff427224ULL, 0x000fe400078e0043ULL,
0x00000000ff437424ULL, 0x000fc800078e00ffULL, 0xfffe4fc042007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000378ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000000a08ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001808ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001818ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000018a8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000018acULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001a80ULL, 0x000000000001b100ULL, 0x8600001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001cb80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001cbd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001cf50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000018a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001b2d8ULL, 0x000000000001b2d8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001cb80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001cf50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 118832;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
