/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b250ULL, 0x000000000001aed0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x2e766e2e00667542ULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL, 0x6265642e006d6172ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL, 0x0000000000006e6fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000018f40ULL, 0x0000000000000190ULL,
0x000b0022000004bdULL, 0x00000000000190d0ULL, 0x0000000000000050ULL, 0x000b0022000004e8ULL,
0x0000000000019120ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x0000000000019160ULL,
0x0000000000000120ULL, 0x000a000300000580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000019280ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00018f4000000000ULL, 0x0000040400000000ULL,
0x810c0000015c0400ULL, 0x0062680400288080ULL, 0x0000000000000000ULL, 0x000000ccffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x9608288080930828ULL, 0x2880809708288080ULL, 0x80a0082880809e08ULL,
0x08288080a1082880ULL, 0x8080a408288080a2ULL, 0xa708288080a50828ULL, 0x288080a808288080ULL,
0x80ad08288080ab08ULL, 0x08288080b2082880ULL, 0x8080b608288080b4ULL, 0xba08288080b80828ULL,
0x288080be08288080ULL, 0x80c408288080c108ULL, 0x08288080c5082880ULL, 0x8080c708288080c6ULL,
0xc908288080c80828ULL, 0x288080ca08288080ULL, 0x808508288080e408ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080859200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x00018f4000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL,
0x0900000004042880ULL, 0x2880808228808085ULL, 0x000000e4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8608288080840828ULL, 0x2880808808288080ULL, 0x8092082880808a08ULL, 0x0828808093082880ULL,
0x80809e0828808096ULL, 0xa208288080a10828ULL, 0x288080a308288080ULL, 0x80a508288080a408ULL,
0x08288080a7082880ULL, 0x8080ab08288080a8ULL, 0xb208288080ad0828ULL, 0x288080b408288080ULL,
0x80b808288080b608ULL, 0x08288080ba082880ULL, 0x8080c108288080beULL, 0xc508288080c40828ULL,
0x288080c608288080ULL, 0x80c808288080c708ULL, 0x08288080c9082880ULL, 0x8080e408288080caULL,
0x8016288080b10828ULL, 0x0000000310288082ULL, 0x80b1920000000000ULL, 0x0000000022002880ULL,
0x0000002cffffffffULL, 0x0000018800000000ULL, 0x000190d000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8088288080b10900ULL, 0x0000000000002880ULL, 0x000000dcffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8a08288080860828ULL, 0x2880809208288080ULL, 0x8096082880809308ULL,
0x082880809e082880ULL, 0x8080a208288080a1ULL, 0xa408288080a30828ULL, 0x288080a508288080ULL,
0x80a808288080a708ULL, 0x08288080ab082880ULL, 0x8080b208288080adULL, 0xb608288080b40828ULL,
0x288080b808288080ULL, 0x80be08288080ba08ULL, 0x08288080c1082880ULL, 0x8080c608288080c5ULL,
0xc808288080c70828ULL, 0x288080c908288080ULL, 0x80ce08288080ca08ULL, 0x08288080e4082880ULL,
0x80828016288080c4ULL, 0x0000000000031028ULL, 0x288080c492000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x000002b000000000ULL, 0x0001912000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000d4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8a08288080860828ULL,
0x2880809208288080ULL, 0x8096082880809308ULL, 0x082880809e082880ULL, 0x8080a208288080a1ULL,
0xa408288080a30828ULL, 0x288080a508288080ULL, 0x80a808288080a708ULL, 0x08288080ab082880ULL,
0x8080b208288080adULL, 0xb608288080b40828ULL, 0x288080b808288080ULL, 0x80be08288080ba08ULL,
0x08288080c1082880ULL, 0x8080c608288080c4ULL, 0xc808288080c70828ULL, 0x288080c908288080ULL,
0x80e408288080ca08ULL, 0x16288080c5082880ULL, 0x0000031028808280ULL, 0xc592000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x000003c000000000ULL, 0x0001916000000000ULL,
0x0000012000000000ULL, 0x0000140400000000ULL, 0x80c4288080c50900ULL, 0x0000000000002880ULL,
0x0000001a00082f04ULL, 0x000823040000008dULL, 0x0000000000000016ULL, 0x0000001600081204ULL,
0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL,
0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL,
0x0000007b00043704ULL, 0x0000001700080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x0198290400000020ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001982804ULL, 0x0000047000000110ULL,
0x000021b000002100ULL, 0x00002410000022a0ULL, 0x0000289000002860ULL, 0x00002930000028e0ULL,
0x0000479000004760ULL, 0x00004830000047e0ULL, 0x00006760000066d0ULL, 0x000069d000006870ULL,
0x00006e9000006e60ULL, 0x00006f3000006ee0ULL, 0x00008b7000008b40ULL, 0x00008c1000008bc0ULL,
0x0000aa200000a990ULL, 0x0000ac900000ab30ULL, 0x0000b1500000b120ULL, 0x0000b1f00000b1a0ULL,
0x0000ce300000ce00ULL, 0x0000ced00000ce80ULL, 0x0000ecf00000ec60ULL, 0x0000ef600000ee00ULL,
0x0000f4200000f3f0ULL, 0x0000f4c00000f470ULL, 0x00011120000110f0ULL, 0x000111c000011170ULL,
0x00012400000123f0ULL, 0x000173e000012bd0ULL, 0x0001743000017420ULL, 0x0001749000017440ULL,
0x000174d0000174b0ULL, 0x00018120000174e0ULL, 0x000181c000018170ULL, 0x0001827000018210ULL,
0x00018330000182d0ULL, 0x000183e000018390ULL, 0x0001849000018430ULL, 0x00018550000184f0ULL,
0x00018610000185b0ULL, 0x000186c000018670ULL, 0x0001876000018710ULL, 0x00018820000187c0ULL,
0x000188e000018880ULL, 0x0001899000018940ULL, 0x00018a40000189e0ULL, 0x00018b0000018aa0ULL,
0x00018bc000018b60ULL, 0x00018c8000018c20ULL, 0x00018d4000018ce0ULL, 0x00018e0000018da0ULL,
0x00018ec000018e60ULL, 0x0600390400018f20ULL, 0x000000ff000001d0ULL, 0x003f010000010600ULL,
0x0000000d00000200ULL, 0x003f012000010608ULL, 0x0000000d000002b0ULL, 0x003f012000010688ULL,
0x0000000d00000440ULL, 0x003f0120000106a8ULL, 0x000000ff00000460ULL, 0x003f0100000106b8ULL,
0x000000ff000004f0ULL, 0x003f010700010600ULL, 0x0000001b00000640ULL, 0x003f01020001068cULL,
0x0000001b000006a0ULL, 0x003f010100010688ULL, 0x000000ff00000f00ULL, 0x003f0107000106a8ULL,
0x000000ff00001020ULL, 0x003f0101000106a8ULL, 0x000000ff00001080ULL, 0x003f0101000106b8ULL,
0x000000ff00001210ULL, 0x003f0105000106bcULL, 0x000000ff000013e0ULL, 0x003f0105000106bcULL,
0x000000ff00001ca0ULL, 0x003f0107000106b0ULL, 0x000000ff00001dc0ULL, 0x003f0101000106b0ULL,
0x0000001b00001e20ULL, 0x003f010100010608ULL, 0x0000001b00001e40ULL, 0x003f01050001060cULL,
0x0000001b00002010ULL, 0x003f01050001060cULL, 0x000000ff000025c0ULL, 0x003f0105000106acULL,
0x000000ff00002790ULL, 0x003f0105000106acULL, 0x000000ff000039f0ULL, 0x003f0101000106b8ULL,
0x000000ff00003a20ULL, 0x003f0105000106bcULL, 0x000000ff00003be0ULL, 0x003f0105000106bcULL,
0x000000ff00004430ULL, 0x003f0107000106a8ULL, 0x000000ff000044b0ULL, 0x003f0101000106a8ULL,
0x000000ff000044e0ULL, 0x003f0105000106b4ULL, 0x000000ff000046b0ULL, 0x003f0105000106b4ULL,
0x000000ff00005800ULL, 0x003f0101000106b8ULL, 0x000000ff00005870ULL, 0x003f010100010688ULL,
0x000000ff000058d0ULL, 0x003f0105000106bcULL, 0x000000ff00005aa0ULL, 0x003f0105000106bcULL,
0x000000ff000062f0ULL, 0x003f0107000106b0ULL, 0x000000ff000063f0ULL, 0x003f0101000106b0ULL,
0x0000001b00006450ULL, 0x003f010100010628ULL, 0x0000001b00006470ULL, 0x003f01050001062cULL,
0x0000001b00006640ULL, 0x003f01050001062cULL, 0x000000ff00006bc0ULL, 0x003f0105000106acULL,
0x000000ff00006d90ULL, 0x003f0105000106acULL, 0x000000ff00007dd0ULL, 0x003f0101000106b8ULL,
0x000000ff00007e00ULL, 0x003f0105000106bcULL, 0x000000ff00007fc0ULL, 0x003f0105000106bcULL,
0x000000ff00008810ULL, 0x003f0107000106a8ULL, 0x000000ff00008890ULL, 0x003f0101000106a8ULL,
0x000000ff000088c0ULL, 0x003f0105000106b4ULL, 0x000000ff00008a90ULL, 0x003f0105000106b4ULL,
0x000000ff00009ac0ULL, 0x003f0101000106b8ULL, 0x000000ff00009b30ULL, 0x003f010100010690ULL,
0x000000ff00009b90ULL, 0x003f0105000106bcULL, 0x000000ff00009d60ULL, 0x003f0105000106bcULL,
0x000000ff0000a5b0ULL, 0x003f0107000106b0ULL, 0x000000ff0000a6b0ULL, 0x003f0101000106b0ULL,
0x0000001b0000a710ULL, 0x003f010100010648ULL, 0x0000001b0000a730ULL, 0x003f01050001064cULL,
0x0000001b0000a900ULL, 0x003f01050001064cULL, 0x000000ff0000ae80ULL, 0x003f0105000106acULL,
0x000000ff0000b050ULL, 0x003f0105000106acULL, 0x000000ff0000c090ULL, 0x003f0101000106b8ULL,
0x000000ff0000c0c0ULL, 0x003f0105000106bcULL, 0x000000ff0000c280ULL, 0x003f0105000106bcULL,
0x000000ff0000cad0ULL, 0x003f0107000106a8ULL, 0x000000ff0000cb50ULL, 0x003f0101000106a8ULL,
0x000000ff0000cb80ULL, 0x003f0105000106b4ULL, 0x000000ff0000cd50ULL, 0x003f0105000106b4ULL,
0x000000ff0000dd80ULL, 0x003f0101000106b8ULL, 0x000000ff0000ddf0ULL, 0x003f010100010698ULL,
0x000000ff0000de60ULL, 0x003f0105000106bcULL, 0x000000ff0000e030ULL, 0x003f0105000106bcULL,
0x000000ff0000e880ULL, 0x003f0107000106b0ULL, 0x000000ff0000e980ULL, 0x003f0101000106b0ULL,
0x0000001b0000e9e0ULL, 0x003f010100010668ULL, 0x0000001b0000ea00ULL, 0x003f01050001066cULL,
0x0000001b0000ebd0ULL, 0x003f01050001066cULL, 0x000000ff0000f150ULL, 0x003f0105000106acULL,
0x000000ff0000f320ULL, 0x003f0105000106acULL, 0x000000ff00010360ULL, 0x003f0101000106b8ULL,
0x000000ff00010390ULL, 0x003f0105000106bcULL, 0x000000ff00010550ULL, 0x003f0105000106bcULL,
0x000000ff00010dc0ULL, 0x003f0107000106a8ULL, 0x000000ff00010e40ULL, 0x003f0101000106a8ULL,
0x000000ff00010e70ULL, 0x003f0105000106b4ULL, 0x000000ff00011040ULL, 0x003f0105000106b4ULL,
0x000000ff00012070ULL, 0x003f0101000106b8ULL, 0x000000ff000120d0ULL, 0x003f0101000106a0ULL,
0x000000ff00012e30ULL, 0x003f010100010600ULL, 0x000000ff00013bf0ULL, 0x003f010500010604ULL,
0x000000ff00013dc0ULL, 0x003f010500010604ULL, 0x000000ff00014130ULL, 0x003f010100010600ULL,
0x000000ff00014160ULL, 0x003f010500010604ULL, 0x000000ff00014320ULL, 0x003f010500010604ULL,
0x0000002b00016800ULL, 0x003f010100000000ULL, 0x0000002b00016910ULL, 0x003f010500000004ULL,
0x0000002b00016ae0ULL, 0x003f010500000004ULL, 0x0000002d00017f80ULL, 0x003f010100000000ULL,
0x0000002d00017fe0ULL, 0x003f010100000008ULL, 0x0000002d00018040ULL, 0x003f010100000010ULL,
0x0000002d000180b0ULL, 0x003f010100000018ULL, 0x00101c0400053803ULL, 0x0001438000012d10ULL,
0x000180f000014450ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000004b4ULL,
0x0000001a00000002ULL, 0x00000000000003acULL, 0x0000001a00000002ULL, 0x000000000000028cULL,
0x0000001a00000002ULL, 0x000000000000015cULL, 0x0000001a00000002ULL, 0x0000000000000044ULL,
0x0000001a00000002ULL, 0x000000000000048eULL, 0x0000001a00000002ULL, 0x0000000000000383ULL,
0x0000001a00000002ULL, 0x0000000000000265ULL, 0x0000001a00000002ULL, 0x0000000000000139ULL,
0x0000001a00000002ULL, 0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x00000000000a7806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00000000000c7919ULL, 0x000ea20000002300ULL, 0x0000000a00097300ULL, 0x000fe200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000027919ULL, 0x000ea20000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000037919ULL, 0x000ee20000002600ULL,
0x0000000a00137309ULL, 0x000f260000000000ULL, 0x00000000001e7919ULL, 0x000ee80000002700ULL,
0x00000000000b7919ULL, 0x000ee20000000000ULL, 0x00000005ff007819ULL, 0x002fe2000001160dULL,
0x000000ffff137224ULL, 0x010fca00078e0a13ULL, 0x00001fff00007589ULL, 0x000fe200000e0000ULL,
0x000001000c027a24ULL, 0x004fc600078e0202ULL, 0x00001fff0c0c7589ULL, 0x000e6200000e0000ULL,
0x00000000020d7a24ULL, 0x000fc600078e020dULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x0000000f0d00780cULL, 0x040fe40003f44070ULL,
0x000000030d00780cULL, 0x040fe40003f64070ULL, 0x0000007f0d00780cULL, 0x000fe40003f84070ULL,
0x0000000b0900720cULL, 0x008fca0003f02070ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff06a424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0007e20000000a00ULL,
0x000000040c087824ULL, 0x002fe400078e0200ULL, 0xff317217ff09c424ULL, 0x000fe200078e00ffULL,
0x010608060d00a388ULL, 0x0003e20000008a00ULL, 0x0000000208087824ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f44070ULL, 0x00000010020e7824ULL, 0x004fe200078e00ffULL,
0x010400090d00c388ULL, 0x0005e20000004800ULL, 0x00000020080f7824ULL, 0x000fc400078e00ffULL,
0x3fffff60ff04b424ULL, 0x008fe200078e00ffULL, 0x000001f00e117812ULL, 0x000fe200078ec0ffULL,
0x7fffff60ff05b424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL,
0x0000000803067824ULL, 0x002fe200078e00ffULL, 0x010688040d00b388ULL, 0x0003e20000008a00ULL,
0x0000000108077824ULL, 0x000fe400078e0202ULL, 0x000000051e067c24ULL, 0x000fc4000f8e0206ULL,
0x7fffff00ff09a424ULL, 0x004fe200078e00ffULL, 0xffffffe00f0f7812ULL, 0x000fe200078ee207ULL,
0x00000200ff077424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000808047817ULL, 0x002fe20007800000ULL,
0x0000000106057824ULL, 0x000fc800078e0208ULL, 0x0000000104047824ULL, 0x000fe200078e0a08ULL,
0x0000000108087810ULL, 0x000fc80007ffe0ffULL, 0x000000ff0400720cULL, 0x000fe20003f63070ULL,
0x0000000106067824ULL, 0x000fe200078e0208ULL, 0x000000010400780cULL, 0x000fe20003f83070ULL,
0x00005c0005047625ULL, 0x000fc800078e0007ULL, 0x0000000108107824ULL, 0x000fe200078e0202ULL,
0x0000001104047210ULL, 0x000fe20007fbe0ffULL, 0x0000002008127824ULL, 0x000fe400078e00ffULL,
0x00005c0006067625ULL, 0x000fc600078e0007ULL, 0xffffffe012107812ULL, 0x000fe200078ee210ULL,
0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL, 0x0000001106067210ULL, 0x000fe20007fde0ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x0106a8080d00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff077224ULL, 0x000fc600030e0607ULL,
0x0106b80aff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e8000d901c46ULL,
0x0000000006107faeULL, 0x0005e2000e101c46ULL, 0x000000ffff047224ULL, 0x002fc400078e0013ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x004fe60000000000ULL,
0x000062001e187625ULL, 0x000fe200078e0005ULL, 0x01060404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000618187981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fc40003f05270ULL,
0x0000003f18197810ULL, 0x044fe40007ffe0ffULL, 0x000000ff18067810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff197819ULL, 0x000fe40000011619ULL, 0x00000008ff1a7819ULL, 0x000fca0000011606ULL,
0x0001273000008947ULL, 0x000fea0003800000ULL, 0x000001ff0600780cULL, 0x000fe20003f24070ULL,
0x00000008001b7824ULL, 0x000fe200078e00ffULL, 0x000000ff1900720cULL, 0x000fe20003f05270ULL,
0x00000003ff047424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c041bff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010688001bff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005000008947ULL, 0x000fea0003800000ULL, 0x000000021e047824ULL, 0x002fe400078e00ffULL,
0x00006400ff067624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0206ULL,
0x00006000041c7625ULL, 0x000fcc00078e0005ULL, 0x000000061c1c7981ULL, 0x000324000c1e1900ULL,
0x000058001c047a24ULL, 0x012fc800078e02ffULL, 0x0000004004107824ULL, 0x000fe200078e00ffULL,
0x0000043000001947ULL, 0x000fea0003800000ULL, 0x0000001b18047217ULL, 0x000fe40007800000ULL,
0x00000004ff057819ULL, 0x000fe40000011602ULL, 0x000000f00e137812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a1bULL, 0x0000000205077810ULL, 0x000fe20007ffe0ffULL,
0x000000011b067824ULL, 0x000fe200078e0205ULL, 0x00000004050a7810ULL, 0x040fe40007ffe0ffULL,
0x000000040500720cULL, 0x080fe20003f06070ULL, 0x000000011b087824ULL, 0x000fe200078e0207ULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000004003057824ULL, 0x000fe200078e0206ULL,
0x000000040700720cULL, 0x080fe20003f26070ULL, 0x0000000106077824ULL, 0x100fe200078e0202ULL,
0x000000040a00720cULL, 0x000fe20003f46070ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0x00000005100c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000108067824ULL, 0x000fc400078e0202ULL,
0x00000010080f7824ULL, 0x000fe200078e00ffULL, 0xfffffff009077812ULL, 0x000fe200078ee207ULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x000000040b00720cULL, 0x000fe20003f66070ULL,
0x000000011b0a7824ULL, 0x000fe200078e020aULL, 0x0000000205047810ULL, 0x000fe40007ffe0ffULL,
0x00005e000c087a11ULL, 0x000fe400078840ffULL, 0xfffffff00f097812ULL, 0x000fe400078ee206ULL,
0x0000000405067810ULL, 0x000fc40007ffe0ffULL, 0x0000000410127210ULL, 0x000fe20007fde0ffULL,
0x000000010a047824ULL, 0x000fe200078e0202ULL, 0x00005f000c0c7a11ULL, 0x000fe200020f440dULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000605057810ULL, 0x000fe40007ffe0ffULL,
0x00000006100f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005e0012117a11ULL, 0x000fe400078c40ffULL, 0x00000005100d7210ULL, 0x000fe20007fbe0ffULL,
0x000000011b057824ULL, 0x000fe200078e020bULL, 0xfffffff00a0b7812ULL, 0x000fe200078ee204ULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x00005f0012127a11ULL, 0x000fe200030f4406ULL,
0x0000000105067824ULL, 0x000fe200078e0202ULL, 0x0000000813047210ULL, 0x000fe20007fde0ffULL,
0x0000001005147824ULL, 0x000fe200078e00ffULL, 0x0000c00007077811ULL, 0x000fe200078e20ffULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078840ffULL,
0x000000ffff057224ULL, 0x000fe200030e060cULL, 0x00005e000d087a11ULL, 0x000fc400078a40ffULL,
0xfffffff0140c7812ULL, 0x000fe400078ee206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c46ULL, 0x00005f000f0f7a11ULL, 0x000fe400020f4410ULL,
0x00005f000d0d7a11ULL, 0x000fe400028f440aULL, 0x000000130e067210ULL, 0x080fe40007f9e0ffULL,
0x0000001308087210ULL, 0x000fe40007fbe0ffULL, 0x0000c000090a7811ULL, 0x000fc400078e20ffULL,
0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x002fe200020e060fULL,
0x0000001311047210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e060dULL,
0x0000c0000c0c7811ULL, 0x000fc600078e20ffULL, 0x000000ffff057224ULL, 0x000fca00000e0612ULL,
0x00000000040a7faeULL, 0x0003e8000c901c46ULL, 0x00000000060b7faeULL, 0x0003e8000d101c46ULL,
0x00000000080c7faeULL, 0x0003e2000d901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000001b02047211ULL, 0x000fe400078fe0ffULL, 0x000000f00e137812ULL, 0x000fc400078ec0ffULL,
0x0000000204067810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x140fe200078e0202ULL,
0x00000006040a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001004087824ULL, 0x000fe400078e00ffULL,
0x0000000106077824ULL, 0x040fe400078e0202ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0xfffffff008067812ULL, 0x000fe200078ee205ULL, 0x0000004003057824ULL, 0x000fc600078e0204ULL,
0xfffffff009097812ULL, 0x000fe400078ee207ULL, 0x0000000404077810ULL, 0x000fe40007ffe0ffULL,
0x0000000510127210ULL, 0x040fe40007f1e0ffULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x0000000205047810ULL, 0x040fe40007ffe0ffULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107057824ULL, 0x100fe200078e0202ULL,
0x00000008100f7210ULL, 0x000fe20007f5e0ffULL, 0x000000010a077824ULL, 0x000fe200078e0202ULL,
0x0000000410117210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000b100d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0012047a11ULL, 0x000fe200078040ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffff00c0b7812ULL, 0x000fe200078ee205ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0xfffffff00a0c7812ULL, 0x000fe200078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005f0012127a11ULL, 0x000fc400000f4408ULL, 0x00005e0011107a11ULL, 0x000fe400078240ffULL,
0x00005e000d0a7a11ULL, 0x000fe400078640ffULL, 0x0000000413047210ULL, 0x000fe40007f1e0ffULL,
0x00005e000f087a11ULL, 0x000fe400078440ffULL, 0x00005f0011117a11ULL, 0x000fe400008f4407ULL,
0x00005f000d0d7a11ULL, 0x000fe200018f4405ULL, 0x000000ffff057224ULL, 0x000fe200000e0612ULL,
0x0000c00006077811ULL, 0x000fc400078e20ffULL, 0x0000001013067210ULL, 0x000fe40007f1e0ffULL,
0x00005f000f0e7a11ULL, 0x000fe200010f440eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000b901c46ULL, 0x0000000813087210ULL, 0x040fe40007f3e0ffULL,
0x0000000a130a7210ULL, 0x000fe40007f5e0ffULL, 0x0000c0000c0c7811ULL, 0x000fe400078e20ffULL,
0x0000c00009047811ULL, 0x002fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0611ULL,
0x0000c0000b057811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fc400008e060eULL,
0x000000ffff0b7224ULL, 0x000fe200010e060dULL, 0x0000000006047faeULL, 0x0003e8000b901c46ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000a0c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff1a00720cULL, 0x000fe20003f05270ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff207f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff227f8cULL, 0x000ee2000c80043fULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0001101000008947ULL, 0x000fea0003800000ULL, 0x000000021e1e7824ULL, 0x000fe400078e00ffULL,
0x00006400ff177624ULL, 0x000fc400078e00ffULL, 0x000000ffff437224ULL, 0x002fe400078e0021ULL,
0x000064001e1e7624ULL, 0x000fe400078e0217ULL, 0x000000ffff4a7224ULL, 0x008fe400078e0023ULL,
0xff317217ff467424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff557224ULL, 0x000fc400078e00ffULL, 0x000000ffff177224ULL, 0x000fc400078e00ffULL,
0x000001001f207824ULL, 0x000fca00078e00ffULL, 0x000000182000720cULL, 0x000fda0003f06070ULL,
0x00010f1000000947ULL, 0x004fea0003800000ULL, 0x000000ffff207224ULL, 0x000fc400078e0055ULL,
0x0000000000227805ULL, 0x000fca0000015200ULL, 0x0106bc00ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x0000002422247210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e23ULL,
0x003d09002400780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402400780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc80000011425ULL, 0x0000002421217211ULL, 0x000fca00078110ffULL,
0x000000ffff247224ULL, 0x000fca00000e0625ULL, 0x0000000221217819ULL, 0x000fc80000001224ULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011f217810ULL, 0x000fe20007ffe0ffULL,
0x000058001c1c7a24ULL, 0x000fc600078e02ffULL, 0x0000001a2100720cULL, 0x000fe20003f26070ULL,
0x000000401c2a7824ULL, 0x000fd800078e00ffULL, 0x0000048000009947ULL, 0x000fea0003800000ULL,
0x00000004ff2c7819ULL, 0x000fe40000011602ULL, 0x000000201f1c7811ULL, 0x000fe400078e40ffULL,
0x000000022c3d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011b227824ULL, 0x000fe200078e022cULL,
0x0000001c18217217ULL, 0x000fe40007800000ULL, 0x000000042c3f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000122237824ULL, 0x000fe200078e0202ULL, 0x000000062c417810ULL, 0x000fe20007ffe0ffULL,
0x00000010223c7824ULL, 0x000fc400078e00ffULL, 0x000000011b247824ULL, 0x000fe400078e023dULL,
0x0000000121217824ULL, 0x000fe200078e0a1cULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee223ULL,
0x0000000124237824ULL, 0x040fe200078e0202ULL, 0x00000020031c7811ULL, 0x000fe200078e30ffULL,
0x00000010243e7824ULL, 0x000fe200078e00ffULL, 0x000000211b217217ULL, 0x040fe20007800000ULL,
0x000000011b2d7824ULL, 0x040fe400078e023fULL, 0x000000011b2e7824ULL, 0x000fe200078e0241ULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee223ULL, 0x0000000124237824ULL, 0x000fc400078e021cULL,
0x000000012d247824ULL, 0x140fe400078e021cULL, 0x0000000122227824ULL, 0x000fe200078e021cULL,
0x000000232a237210ULL, 0x040fe20007f5e0ffULL, 0x000000102d407824ULL, 0x040fe200078e00ffULL,
0x000000242a297210ULL, 0x040fe20007fbe0ffULL, 0x000000012d247824ULL, 0x000fe200078e0202ULL,
0x000000222a257210ULL, 0x000fe20007f1e0ffULL, 0x000000012e1c7824ULL, 0x040fe200078e021cULL,
0x00005e00232d7a11ULL, 0x000fe200078840ffULL, 0x000000102e427824ULL, 0x000fe200078e00ffULL,
0xfffffff040407812ULL, 0x000fe200078ee224ULL, 0x0000001002247824ULL, 0x000fe200078e00ffULL,
0x0000001c2a2b7210ULL, 0x000fe20007fde0ffULL, 0x000000012e2a7824ULL, 0x000fc400078e0202ULL,
0x0000000121217824ULL, 0x000fe200078e0a1bULL, 0x000000f0242f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0xfffffff042427812ULL, 0x000fe200078ee22aULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005e0025227a11ULL, 0x000fe200078040ffULL,
0x000000ffff247224ULL, 0x000fe200030e06ffULL, 0x000000212c00720cULL, 0x000fe20003f66070ULL,
0x000000ffff2c7224ULL, 0x000fe200028e06ffULL, 0x00005f00232e7a11ULL, 0x000fe400020f442eULL,
0x00005f00251c7a11ULL, 0x000fc400000f441cULL, 0x0000002f22227210ULL, 0x080fe40007f9e0ffULL,
0x00005e0029257a11ULL, 0x000fe400078a40ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff237224ULL, 0x000fe200020e061cULL, 0x0000e0003c1c7811ULL, 0x000fe400078e20ffULL,
0x00005f0029297a11ULL, 0x000fe400028f442cULL, 0x00005f002b2b7a11ULL, 0x000fe200030f4424ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221c7faeULL, 0x0003e2000d901c46ULL,
0x0000002f2d247210ULL, 0x000fc40007fbe0ffULL, 0x000000213d00720cULL, 0x080fe40003f46070ULL,
0x000000213f00720cULL, 0x080fe40003f06070ULL, 0x000000214100720cULL, 0x000fe40003f86070ULL,
0x0000e00040217811ULL, 0x000fe400078e20ffULL, 0x0000002f25227210ULL, 0x082fe20007f7e0ffULL,
0x000000ffff257224ULL, 0x000fe200028e062eULL, 0x0000002f2a2a7210ULL, 0x000fc40007fbe0ffULL,
0x0000e0003e1c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff237224ULL, 0x000fe200018e0629ULL,
0x0000e00042297811ULL, 0x000fe200078e20ffULL, 0x000000ffff2b7224ULL, 0x000fe400028e062bULL,
0x00000000241c7faeULL, 0x0003e8000d101c46ULL, 0x0000000022217faeULL, 0x0003e8000c101c46ULL,
0x000000002a297faeULL, 0x0003e2000e101c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x0000001b021c7211ULL, 0x000fe400078fe0ffULL, 0x0000002003237811ULL, 0x000fc400078e30ffULL,
0x000000021c227810ULL, 0x040fe20007ffe0ffULL, 0x000000011c217824ULL, 0x140fe200078e0202ULL,
0x000000061c297810ULL, 0x040fe20007ffe0ffULL, 0x000000101c2f7824ULL, 0x000fe400078e00ffULL,
0x0000000122247824ULL, 0x040fe400078e0202ULL, 0x00000010223c7824ULL, 0x040fe200078e00ffULL,
0xfffffff02f2f7812ULL, 0x000fe200078ee221ULL, 0x0000000122217824ULL, 0x000fe400078e0223ULL,
0x00000010293e7824ULL, 0x000fe200078e00ffULL, 0xfffffff03c3c7812ULL, 0x000fc400078ee224ULL,
0x000000041c247810ULL, 0x040fe20007ffe0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e0223ULL,
0x000000212a217210ULL, 0x000fc60007f5e0ffULL, 0x0000000124227824ULL, 0x100fe200078e0223ULL,
0x0000001c2a1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000129237824ULL, 0x040fe400078e0223ULL,
0x0000000124257824ULL, 0x100fe200078e0202ULL, 0x000000222a2b7210ULL, 0x000fe20007f7e0ffULL,
0x00000010243d7824ULL, 0x000fe200078e00ffULL, 0x000000232a237210ULL, 0x000fe20007f9e0ffULL,
0x0000001002247824ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e06ffULL,
0x00005e001c227a11ULL, 0x000fe200078040ffULL, 0x00000001292a7824ULL, 0x000fe200078e0202ULL,
0x000000f0242e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff297224ULL, 0x000fe200020e06ffULL,
0x00005f001c2d7a11ULL, 0x000fe200000f442dULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0xfffffff03e3e7812ULL, 0x000fc400078ee22aULL, 0xfffffff03d3d7812ULL, 0x000fe200078ee225ULL,
0x000000ffff257224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe400078640ffULL,
0x00005e00232c7a11ULL, 0x000fe400078840ffULL, 0x0000002e22227210ULL, 0x000fe40007f1e0ffULL,
0x00005e0021247a11ULL, 0x000fe400078440ffULL, 0x00005f002b2b7a11ULL, 0x000fc400018f441cULL,
0x00005f0023297a11ULL, 0x000fe200020f4429ULL, 0x000000ffff237224ULL, 0x000fe200000e062dULL,
0x0000e0002f1c7811ULL, 0x000fe400078e20ffULL, 0x00005f0021217a11ULL, 0x000fe400010f4425ULL,
0x0000002e24247210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000221c7faeULL, 0x0003e2000b901c46ULL, 0x0000002e2a2a7210ULL, 0x080fe40007f5e0ffULL,
0x0000002e2c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0621ULL,
0x0000e0003d217811ULL, 0x000fe200078e20ffULL, 0x000000ffff2b7224ULL, 0x000fc400010e062bULL,
0x000000ffff2d7224ULL, 0x000fe200018e0629ULL, 0x0000e0003c1c7811ULL, 0x002fe400078e20ffULL,
0x0000e0003e227811ULL, 0x000fc600078e20ffULL, 0x00000000241c7faeULL, 0x0003e8000b901c46ULL,
0x000000002a217faeULL, 0x0003e8000b901c46ULL, 0x000000002c227faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000155227810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe60003800000ULL, 0x000000192200720cULL, 0x000fe20003f06070ULL,
0xffffffffff1c7424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000011e227824ULL, 0x000fe400078e0222ULL, 0x00000004ff237424ULL, 0x000fc800078e00ffULL,
0x0000600022227625ULL, 0x000fca00078e0023ULL, 0x00000006221c7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff507f8cULL, 0x000ee2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010608001b2a7f8cULL, 0x0002a4000c80043fULL, 0x0000000000227805ULL, 0x002fc40000015200ULL,
0x01060c001b217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x006fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000002422247210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e23ULL, 0x003d09002400780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402400780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc80000011425ULL,
0x0000002421217211ULL, 0x000fca00078110ffULL, 0x000000ffff247224ULL, 0x000fca00000e0625ULL,
0x0000000221217819ULL, 0x000fc80000001224ULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c001b217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff227819ULL, 0x000fe20000011602ULL, 0x0000001002217824ULL, 0x000fc600078e00ffULL,
0x0000000c22237812ULL, 0x000fe400078ec0ffULL, 0x0000007021227812ULL, 0x000fca00078ec0ffULL,
0x0000000122227824ULL, 0x000fe400078e0223ULL, 0xffffffffff237424ULL, 0x000fc600078e00ffULL,
0x0100000022297984ULL, 0x000e680000000800ULL, 0x01020000222a7984ULL, 0x0004e20000000800ULL,
0x000000462900720bULL, 0x002fe20003f1d000ULL, 0x000160027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x004fc800000e0100ULL, 0x0000ffff242d7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff547224ULL, 0x000fc400078e0046ULL, 0x0000001fff247424ULL, 0x000fe400078e00ffULL,
0xffffffffff257424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f05270ULL, 0x000000462900720bULL, 0x000fe20003f54000ULL,
0x00015fa27f007947ULL, 0x000fd8000b800000ULL, 0x00000000002b7806ULL, 0x000fc400010e0100ULL,
0x0000002946547209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x000099102b2c7816ULL, 0x000fc600000000ffULL, 0x0104005422008388ULL, 0x0003e20000000800ULL,
0x000000ff2c00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x80000054462c7221ULL, 0x002fe20000010000ULL, 0x000000ff2bff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b2c2c7820ULL, 0x000fcc0000410000ULL,
0x0000002c002c7308ULL, 0x000e680000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff457819ULL, 0x000fe20000011602ULL, 0x00015f027f007947ULL, 0x000fea000b800000ULL,
0x00001f452c457589ULL, 0x0022a400000e0000ULL, 0x0000004538387220ULL, 0x084fe20000410000ULL,
0x0000004539397220ULL, 0x080fe20000410000ULL, 0x0000004534347220ULL, 0x080fe20000410000ULL,
0x0000004535357220ULL, 0x080fe20000410000ULL, 0x0000004530307220ULL, 0x080fe20000410000ULL,
0x0000004531317220ULL, 0x080fe20000410000ULL, 0x0000004504047220ULL, 0x080fe20000410000ULL,
0x0000004505057220ULL, 0x080fe20000410000ULL, 0x0000004510107220ULL, 0x080fe20000410000ULL,
0x0000004511117220ULL, 0x080fe20000410000ULL, 0x000000450c0c7220ULL, 0x080fe20000410000ULL,
0x000000450d0d7220ULL, 0x080fe20000410000ULL, 0x0000004508087220ULL, 0x080fe20000410000ULL,
0x0000004509097220ULL, 0x080fe20000410000ULL, 0x0000004514147220ULL, 0x080fe20000410000ULL,
0x0000004515157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff002bff7812ULL, 0x000fe2000780c0ffULL, 0x0000002c1d1d7220ULL, 0x002fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802457811ULL, 0x000fe200078ff0ffULL,
0x00015de27f007947ULL, 0x000fea000b800000ULL, 0x00001f452c457589ULL, 0x0002a400000e0000ULL,
0x000000453a3a7220ULL, 0x084fe20000410000ULL, 0x000000453b3b7220ULL, 0x080fe20000410000ULL,
0x0000004536367220ULL, 0x080fe20000410000ULL, 0x0000004537377220ULL, 0x080fe20000410000ULL,
0x0000004532327220ULL, 0x080fe20000410000ULL, 0x0000004533337220ULL, 0x080fe20000410000ULL,
0x0000004506067220ULL, 0x080fe20000410000ULL, 0x0000004507077220ULL, 0x080fe20000410000ULL,
0x0000004512127220ULL, 0x080fe20000410000ULL, 0x0000004513137220ULL, 0x080fe20000410000ULL,
0x000000450e0e7220ULL, 0x080fe20000410000ULL, 0x000000450f0f7220ULL, 0x080fe20000410000ULL,
0x000000450a0a7220ULL, 0x080fe20000410000ULL, 0x000000450b0b7220ULL, 0x080fe20000410000ULL,
0x0000004516167220ULL, 0x080fe20000410000ULL, 0x0000004517177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff2dff7812ULL, 0x000fda000780602bULL,
0x8000005429290221ULL, 0x000fe20000010000ULL, 0x00007610ff2e0816ULL, 0x000fc6000000002eULL,
0x3fb8aa3b29290820ULL, 0x000fc80000410000ULL, 0x0000002900260308ULL, 0x000e640000000800ULL,
0x000000262a2a0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001d2a1d7221ULL, 0x008fc40000010000ULL, 0x00000000002a7805ULL, 0x000fca0000015200ULL,
0x0106ac00ff297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c2a2c7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e2bULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff297819ULL, 0x000fc8000001142dULL,
0x0000002c29297211ULL, 0x000fca00078110ffULL, 0x000000ffff2c7224ULL, 0x000fca00000e062dULL,
0x0000000229297819ULL, 0x000fc8000000122cULL, 0x000000290000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012f2f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099102e297816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2900720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000026ff27723eULL, 0x000fe400000000ffULL, 0x00000002ff2a7819ULL, 0x000fe40000011602ULL,
0x0000541027297816ULL, 0x000fe20000000027ULL, 0x000159e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a29277589ULL, 0x0002a400000e0000ULL, 0x000000082a287810ULL, 0x000fe20007ffe0ffULL,
0x00015a127f007947ULL, 0x000fea000b800000ULL, 0x00001f2829287589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000102a457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0029ULL, 0x000028f000447802ULL, 0x000fc40000000f00ULL,
0x0001683000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000182a457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e0029ULL,
0x0000294000447802ULL, 0x000fc40000000f00ULL, 0x000167e000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802527812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff297819ULL, 0x00afc40000011602ULL,
0x0000000752527812ULL, 0x000fe400078ef802ULL, 0x0000000200407811ULL, 0x040fe200078e10ffULL,
0x0000000400587824ULL, 0x000fe200078e0229ULL, 0x0000000702567812ULL, 0x000fe200078ec0ffULL,
0x00000010522b7824ULL, 0x040fe400078e00ffULL, 0x00000001522a7824ULL, 0x000fe200078e0258ULL,
0x0000000856567812ULL, 0x000fe200078ef802ULL, 0x0000000129537824ULL, 0x000fe400078e0240ULL,
0x00000010522c7824ULL, 0x040fe200078e00ffULL, 0xfffffff02b2a7812ULL, 0x000fe200078ee22aULL,
0x00000001522b7824ULL, 0x000fc400078e0253ULL, 0x0000000129577824ULL, 0x000fe200078e0256ULL,
0x0000c0002a2a7811ULL, 0x000fe400078e20ffULL, 0xfffffff02c2b7812ULL, 0x000fc600078ee22bULL,
0x000000002a3c783bULL, 0x000e620000004200ULL, 0x0000c0002b2b7811ULL, 0x000fca00078e20ffULL,
0x000000002b2c783bULL, 0x000ee20000004200ULL, 0x00000018ff417819ULL, 0x002fe2000001143cULL,
0x000001003c427824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x004fe4000001143eULL,
0x00000041004a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fe4000001143fULL,
0x00000018ff4c7819ULL, 0x008fe4000001142cULL, 0x00000018ff4d7819ULL, 0x000fc4000001142dULL,
0x00000018ff5b7819ULL, 0x000fe2000001142eULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff417819ULL, 0x002fe4000001143dULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff5c7819ULL, 0x000fc6000001142fULL, 0x0000004100677306ULL, 0x0003f00000200c00ULL,
0x0000004200497306ULL, 0x000fe20000200c00ULL, 0x000088803c417816ULL, 0x042fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004100487306ULL, 0x0002b00000200c00ULL, 0x0000003c004b7306ULL, 0x0006e20000200c00ULL,
0x000088803d417816ULL, 0x002fc400000000ffULL, 0x0000541048487816ULL, 0x004fc60000000049ULL,
0x000000ffff3c7224ULL, 0x008fe400078e0041ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x000001003d417824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000003c00657306ULL, 0x0003e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000054104b4a7816ULL, 0x000fca000000004aULL,
0x0000003d00687306ULL, 0x0004e20000200c00ULL, 0x000088803e3c7816ULL, 0x002fce00000000ffULL,
0x0000003c00697306ULL, 0x0003e20000200c00ULL, 0x000001003e3d7824ULL, 0x044fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000004100667306ULL, 0x0004a20000200c00ULL,
0x000088803f3c7816ULL, 0x002fe400000000ffULL, 0x00005410684b7816ULL, 0x008fca0000000067ULL,
0x0000003c006b7306ULL, 0x0003e20000200c00ULL, 0x000001002f417824ULL, 0x004fca00078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000003e006c7306ULL, 0x0004e20000200c00ULL,
0x000088802c3c7816ULL, 0x002fe400000000ffULL, 0x0000541065497816ULL, 0x000fca0000000066ULL,
0x0000003c006f7306ULL, 0x0003e20000200c00ULL, 0x00000010523e7812ULL, 0x004fc800078efcffULL,
0x000000403e5a7210ULL, 0x000fe20007ffe029ULL, 0x0000000158597824ULL, 0x000fe200078e023eULL,
0x000088802f407816ULL, 0x000fe200000000ffULL, 0x0000003d006a7306ULL, 0x0004a20000200c00ULL,
0x000088802d3c7816ULL, 0x002fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fe200078e00ffULL,
0x000054106c4e7816ULL, 0x008fc8000000004eULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000003c00717306ULL, 0x0003e20000200c00ULL, 0x000001003f3d7824ULL, 0x044fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004100797306ULL, 0x000fe20000200c00ULL, 0x000000103e3c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000000103e3e7824ULL, 0x000fe200078e00ffULL,
0x00005410696a7816ULL, 0x000fe4000000006aULL, 0xfffffff03c597812ULL, 0x000fe200078ee259ULL,
0x000100002c3c7824ULL, 0x000fe200078e00ffULL, 0x0000003d006d7306ULL, 0x0002a20000200c00ULL,
0xfffffff03e5a7812ULL, 0x000fc600078ee25aULL, 0x00000018ff3c7819ULL, 0x000fc8000001143cULL,
0x0000003c00727306ULL, 0x0007e20000200c00ULL, 0x000001002c3d7824ULL, 0x002fe200078e00ffULL,
0x0000c000592c7811ULL, 0x000fc800078e20ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000000002c44783bULL, 0x000e620000004200ULL, 0x0000004000787306ULL, 0x000fe20000200c00ULL,
0x000088802e3c7816ULL, 0x008fe400000000ffULL, 0x000054106b6b7816ULL, 0x004fca000000006dULL,
0x0000003d00707306ULL, 0x0004f00000200c00ULL, 0x0000002f007a7306ULL, 0x000fe20000200c00ULL,
0x000001002d3d7824ULL, 0x044fe400078e00ffULL, 0x000100002d2d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000003f006e7306ULL, 0x000ea20000200c00ULL, 0x000054106f707816ULL, 0x008fce0000000070ULL,
0x0000002d00747306ULL, 0x0007e20000200c00ULL, 0x0000010044417824ULL, 0x002fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fcc0000011444ULL, 0x0000003d00737306ULL, 0x000e620000200c00ULL,
0x000000ffff2d7224ULL, 0x008fe200078e003cULL, 0x00008880442f7816ULL, 0x000fe200000000ffULL,
0x000001002e3c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011445ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000041007c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff2e7819ULL, 0x000fc4000001142eULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x000054106e4f7816ULL, 0x004fe2000000004fULL,
0x0000002e00777306ULL, 0x0005e20000200c00ULL, 0x00000018ff617819ULL, 0x000fe40000011446ULL,
0x00000018ff627819ULL, 0x000fe40000011447ULL, 0x0000541071717816ULL, 0x002fc60000000073ULL,
0x0000002d00757306ULL, 0x0003e20000200c00ULL, 0x00000008562e7824ULL, 0x004fca00078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee257ULL, 0x0000003c00767306ULL, 0x0005e20000200c00ULL,
0x0000c0005a2d7811ULL, 0x002fe400078e20ffULL, 0x0000a0002e407811ULL, 0x000fca00078e20ffULL,
0x00000044007e7306ULL, 0x0003e20000200c00ULL, 0x000000004040783bULL, 0x000ee80000000200ULL,
0x000000002d3c783bULL, 0x004ea60000004200ULL, 0x0000002f007b7306ULL, 0x0002640000200c00ULL,
0x0000010045447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00008880452f7816ULL, 0x040fe200000000ffULL,
0x0001000045457824ULL, 0x000fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x00000044007f7306ULL, 0x0003e20000200c00ULL, 0x000054107b7c7816ULL, 0x000fce000000007cULL,
0x0000002f007d7306ULL, 0x0006a20000200c00ULL, 0x0000010046447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500807306ULL, 0x0003e20000200c00ULL,
0x00008880462f7816ULL, 0x048fe200000000ffULL, 0x000000274040a232ULL, 0x080fe20000000000ULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x000000274242a232ULL, 0x000fe20000000000ULL,
0x00000018ff607819ULL, 0x004fe2000001143cULL, 0x000000284141a232ULL, 0x080fe20000000000ULL,
0x00000018ff5f7819ULL, 0x000fe2000001143dULL, 0x0000004400827306ULL, 0x0005e20000200c00ULL,
0x000000284343a232ULL, 0x000fe20000000000ULL, 0x000088803c457816ULL, 0x002fc400000000ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff5d7819ULL, 0x000fe4000001143eULL,
0x0000002f00817306ULL, 0x0003e20000200c00ULL, 0x0000010047447824ULL, 0x004fe200078e00ffULL,
0x000000484038723cULL, 0x040f620000001838ULL, 0x00000018ff5e7819ULL, 0x000fe4000001143fULL,
0x000054107d7d7816ULL, 0x000fe4000000007fULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x00008880472f7816ULL, 0x042fe200000000ffULL,
0x0000004a4048723cULL, 0x000b620000001834ULL, 0x0001000047477824ULL, 0x000fca00078e00ffULL,
0x0000004400857306ULL, 0x0003e20000200c00ULL, 0x000001003c357824ULL, 0x060fe200078e00ffULL,
0x0000004e4004723cULL, 0x040fe20000001804ULL, 0x000000ffff347224ULL, 0x000fe200078e0045ULL,
0x000088803d457816ULL, 0x000fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000002f00847306ULL, 0x0005e20000200c00ULL,
0x0000000856447824ULL, 0x002fe200078e00ffULL, 0x0000006a4030723cULL, 0x000fe20000001830ULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000002572f7810ULL, 0x004fe20007ffe0ffULL, 0x000000704010723cULL, 0x000f660000001810ULL,
0xfffffff8442f7812ULL, 0x000fe400078ee22fULL, 0x00000018ff447819ULL, 0x000fe20000011435ULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000004400677306ULL, 0x0003f00000200c00ULL,
0x0000003400667306ULL, 0x0004e20000200c00ULL, 0x000000ffff447224ULL, 0x002fc400078e0045ULL,
0x000001003d457824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000004400687306ULL, 0x0003e20000200c00ULL,
0x0000a0002f347811ULL, 0x004fe400078e20ffULL, 0x00000018ff3d7819ULL, 0x000fc8000001143dULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x0000004500697306ULL, 0x0006e20000200c00ULL,
0x0000541072447816ULL, 0x002fe4000000004cULL, 0x00005410754c7816ULL, 0x000fe40000000076ULL,
0x0000541066667816ULL, 0x008fc60000000067ULL, 0x0000004600837306ULL, 0x000fe20000200c00ULL,
0x0000541074457816ULL, 0x000fe4000000004dULL, 0x00005410784d7816ULL, 0x000fca0000000079ULL,
0x0000004700657306ULL, 0x0003e20000200c00ULL, 0x0000541068677816ULL, 0x000fe20000000069ULL,
0x0000004c404c723cULL, 0x040bec0000001808ULL, 0x0000006300637306ULL, 0x000ee20000200c00ULL,
0x0000541077087816ULL, 0x020fe2000000005bULL, 0x000000444044723cULL, 0x002f62000000180cULL,
0x000054107a097816ULL, 0x000fc4000000005cULL, 0x000088803e0a7816ULL, 0x000fc600000000ffULL,
0x0000006400647306ULL, 0x000e640000200c00ULL, 0x000000084040723cULL, 0x000b620000001814ULL,
0x000000273434a232ULL, 0x004fe20000000000ULL, 0x000054107e7e7816ULL, 0x008fca0000000063ULL,
0x000001003e087824ULL, 0x060fe200078e00ffULL, 0x000088803f097816ULL, 0x000fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x000000273636a232ULL, 0x000fe20000000000ULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x000000283535a232ULL, 0x080fe20000000000ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000000283737a232ULL, 0x000fe20000000000ULL, 0x00005410807f7816ULL, 0x002fe40000000064ULL,
0x00000008005c7306ULL, 0x0003e80000200c00ULL, 0x0000007c3438723cULL, 0x040f680000001838ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x000000ffff087224ULL, 0x002fe200078e0009ULL,
0x00005410830c7816ULL, 0x004fe20000000061ULL, 0x000001003f097824ULL, 0x040fe200078e00ffULL,
0x0000007e3448723cULL, 0x000f620000001848ULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff097819ULL, 0x000fe20000011409ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000663410723cULL, 0x000f620000001810ULL,
0x00005410650d7816ULL, 0x008fc80000000062ULL, 0x0000005f005f7306ULL, 0x000fe60000200c00ULL,
0x0000000c340c723cULL, 0x000f6a0000001804ULL, 0x0000003c003c7306ULL, 0x000e700000200c00ULL,
0x0000003d003d7306ULL, 0x000eb00000200c00ULL, 0x0000000a005b7306ULL, 0x000ee20000200c00ULL,
0x000054103c147816ULL, 0x002fce0000000060ULL, 0x00000008006a7306ULL, 0x0003e20000200c00ULL,
0x000054103d157816ULL, 0x004fce000000005fULL, 0x0000000900637306ULL, 0x0004e20000200c00ULL,
0x0000541081087816ULL, 0x002fe20000000082ULL, 0x000000143414723cULL, 0x000f6c0000001844ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000541084097816ULL, 0x004fce0000000085ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000083408723cULL, 0x000b6e0000001830ULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x000054105b307816ULL, 0x028fe4000000005cULL,
0x000054106a317816ULL, 0x000fca0000000063ULL, 0x0000003f003f7306ULL, 0x000ea40000200c00ULL,
0x000000303430723cULL, 0x000b62000000184cULL, 0x000054103e3e7816ULL, 0x002fe4000000005dULL,
0x000054103f3f7816ULL, 0x004fce000000005eULL, 0x0000003e3434723cULL, 0x000b620000001840ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3c7f8cULL, 0x000e62000c80043fULL,
0x000000ffff3f7224ULL, 0x020fce00078e00ffULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x0106bc00ff067984ULL, 0x000ea40000000800ULL, 0x8000000006ff7812ULL, 0x006fe4000780483dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006043e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000003e06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013f3f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000058001c5b7a24ULL, 0x010fe200078e02ffULL,
0x000000401f3c7811ULL, 0x000fc600078e40ffULL, 0x000000405b5b7824ULL, 0x000fe200078e00ffULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x000000011b057824ULL, 0x000fe200078e0229ULL,
0x00000002293d7810ULL, 0x000fe40007ffe0ffULL, 0x0000003c18047217ULL, 0x000fe20007800000ULL,
0x0000000105067824ULL, 0x000fe200078e0202ULL, 0x0000000429467810ULL, 0x000fe20007ffe0ffULL,
0x0000001005447824ULL, 0x000fe200078e00ffULL, 0x000000f021437812ULL, 0x000fe200078ec0ffULL,
0x0000004003427824ULL, 0x000fe400078e0205ULL, 0x000000011b077824ULL, 0x000fe200078e023dULL,
0xfffffff044447812ULL, 0x000fe200078ee206ULL, 0x0000000104047824ULL, 0x000fe200078e0a3cULL,
0x0000005b423f7210ULL, 0x0c0fe20007f1e0ffULL, 0x0000000107067824ULL, 0x040fe200078e0202ULL,
0x0000000242417810ULL, 0x000fe20007ffe0ffULL, 0x0000001007457824ULL, 0x000fe200078e00ffULL,
0x000000041b047217ULL, 0x040fe20007800000ULL, 0x000000011b057824ULL, 0x000fe200078e0246ULL,
0x0000005b41417210ULL, 0x000fc40007f7e0ffULL, 0xfffffff045457812ULL, 0x000fe200078ee206ULL,
0x00000001053e7824ULL, 0x040fe200078e0202ULL, 0x0000000442407810ULL, 0x000fe20007ffe0ffULL,
0x0000001005477824ULL, 0x000fe200078e00ffULL, 0x0000c00044447811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200000e06ffULL, 0x00005e003f067a11ULL, 0x000fe200078040ffULL,
0x0000000104077824ULL, 0x000fe200078e0a1bULL, 0xfffffff047477812ULL, 0x000fe400078ee23eULL,
0x00005f003f3f7a11ULL, 0x000fe200000f4405ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x0000005b40407210ULL, 0x000fc40007fde0ffULL, 0x00005e00413e7a11ULL, 0x000fe400078a40ffULL,
0x000000072900720cULL, 0x000fe40003f86070ULL, 0x0000004306047210ULL, 0x000fe40007f7e0ffULL,
0x000000073d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff3d7224ULL, 0x000fe200030e06ffULL,
0x00005f0041417a11ULL, 0x000fe200028f4405ULL, 0x000000ffff057224ULL, 0x000fe200018e063fULL,
0x00005e0040067a11ULL, 0x000fc400078a40ffULL, 0x000000074600720cULL, 0x000fe40003f66070ULL,
0x0000000629467810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004447faeULL, 0x0003e2000e101c46ULL, 0x00005f0040407a11ULL, 0x000fe400028f443dULL,
0x00000006423d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011b3f7824ULL, 0x000fe200078e0246ULL,
0x0000004306067210ULL, 0x000fe40007fde0ffULL, 0x0000005b3d3d7210ULL, 0x000fe20007f9e0ffULL,
0x000000013f427824ULL, 0x000fe200078e0202ULL, 0x0000c00045457811ULL, 0x000fc400078e20ffULL,
0x0000c00047477811ULL, 0x000fe200078e20ffULL, 0x000000103f447824ULL, 0x002fe200078e00ffULL,
0x000000433e047210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200020e06ffULL,
0x00005e003d3e7a11ULL, 0x040fe400078840ffULL, 0xfffffff044427812ULL, 0x000fe200078ee242ULL,
0x000000ffff057224ULL, 0x000fe200028e0641ULL, 0x000000074600720cULL, 0x000fe20003fa6070ULL,
0x000000ffff077224ULL, 0x000fe200030e0640ULL, 0x00005f003d3d7a11ULL, 0x000fc400020f443fULL,
0x000000433e3e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000004457faeULL, 0x0003e2000c101c46ULL,
0x0000c00042427811ULL, 0x000fc600078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200020e063dULL,
0x0000000006477faeULL, 0x0003e8000d901c46ULL, 0x000000003e427faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x000000011b067824ULL, 0x000fe200078e0229ULL,
0x000000f021417812ULL, 0x000fc600078ec0ffULL, 0x00000040033e7824ULL, 0x000fe200078e0206ULL,
0x0000000206047810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x140fe400078e0202ULL,
0x0000001006437824ULL, 0x000fe200078e00ffULL, 0x0000005b3e3f7210ULL, 0x000fe20007f1e0ffULL,
0x0000000104057824ULL, 0x040fe400078e0202ULL, 0x00000010043d7824ULL, 0x000fe200078e00ffULL,
0x0000000406047810ULL, 0x040fe40007ffe0ffULL, 0x0000000606067810ULL, 0x000fc40007ffe0ffULL,
0xfffffff043437812ULL, 0x000fe400078ee207ULL, 0xfffffff03d077812ULL, 0x000fe200078ee205ULL,
0x0000000104057824ULL, 0x140fe200078e0202ULL, 0x0000c00043437811ULL, 0x000fe200078e20ffULL,
0x00000010043d7824ULL, 0x000fe400078e00ffULL, 0x0000000106047824ULL, 0x040fe400078e0202ULL,
0x0000001006427824ULL, 0x000fe200078e00ffULL, 0xfffffff03d3d7812ULL, 0x000fe200078ee205ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e003f407a11ULL, 0x000fc400078040ffULL,
0xfffffff042427812ULL, 0x000fe400078ee204ULL, 0x00005f003f067a11ULL, 0x000fe400000f4406ULL,
0x000000023e047810ULL, 0x040fe40007ffe0ffULL, 0x000000043e3f7810ULL, 0x040fe40007ffe0ffULL,
0x000000063e3e7810ULL, 0x000fe40007ffe0ffULL, 0x0000005b04057210ULL, 0x000fc40007f1e0ffULL,
0x0000005b3f457210ULL, 0x080fe40007f7e0ffULL, 0x0000005b3e4c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e00053f7a11ULL, 0x000fe200078040ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x0000004140047210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200028e06ffULL, 0x00005e0045477a11ULL, 0x000fe400078840ffULL,
0x00005f0005447a11ULL, 0x000fe200000f443eULL, 0x000000ffff057224ULL, 0x000fe200018e0606ULL,
0x00005e004c4e7a11ULL, 0x000fc400078a40ffULL, 0x000000413f067210ULL, 0x080fe40007f1e0ffULL,
0x00005f0045467a11ULL, 0x000fe200020f4446ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004437faeULL, 0x0003e2000b901c46ULL, 0x00000041473e7210ULL, 0x080fe40007f7e0ffULL,
0x00005f004c4d7a11ULL, 0x000fe400028f444dULL, 0x000000414e407210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e0646ULL, 0x0000c0003d3d7811ULL, 0x000fc400078e20ffULL,
0x0000c00042427811ULL, 0x000fe200078e20ffULL, 0x000000ffff417224ULL, 0x000fe200020e064dULL,
0x0000c00007047811ULL, 0x002fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fca00000e0644ULL,
0x0000000006047faeULL, 0x0003e8000b901c46ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x0000000040427faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff047f8cULL, 0x000e64000c80043fULL,
0x000000ffff437224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x0106b400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc40007804851ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006043d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000003d06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000026ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff057819ULL, 0x000fe40000011602ULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x00013ba27f007947ULL, 0x000fea000b800000ULL,
0x00001f0504277589ULL, 0x0002a400000e0000ULL, 0x0000000805287810ULL, 0x000fe20007ffe0ffULL,
0x00013bd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2804287589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001005457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0004ULL, 0x000047f000447802ULL, 0x000fc40000000f00ULL,
0x0001493000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001805457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e0004ULL,
0x0000484000447802ULL, 0x000fc40000000f00ULL, 0x000148e000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000e000593d7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0005a3e7811ULL, 0x000fe200078e20ffULL,
0x0000000152587824ULL, 0x000fc400078e0258ULL, 0x000000003d4c783bULL, 0x004ea20000004200ULL,
0x0000001052407824ULL, 0x040fe400078e00ffULL, 0x0000000152537824ULL, 0x000fe200078e0253ULL,
0x000000003e04783bULL, 0x00ae640000004200ULL, 0xfffffff040587812ULL, 0x000fe200078ee258ULL,
0x000001004c3f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe2000001144cULL,
0x000001004f407824ULL, 0x000fe200078e00ffULL, 0x000088804c6d7816ULL, 0x000fe200000000ffULL,
0x0000010004417824ULL, 0x002fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x000fc40000011441ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff697819ULL, 0x000fe4000001144dULL,
0x000088804d6f7816ULL, 0x000fe200000000ffULL, 0x0000003f006e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff5e7819ULL, 0x000fe4000001144eULL, 0x000088804e667816ULL, 0x000fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fc4000001144fULL, 0x000088804f657816ULL, 0x000fe200000000ffULL,
0x00000040006b7306ULL, 0x0005e20000200c00ULL, 0x000001004d3f7824ULL, 0x042fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011404ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x0000888004617816ULL, 0x000fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000004c006a7306ULL, 0x000e620000200c00ULL,
0x0000001052407824ULL, 0x004fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc4000001144dULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0xfffffff040407812ULL, 0x000fe400078ee253ULL,
0x0000003f00707306ULL, 0x0005e20000200c00ULL, 0x00000018ff5d7819ULL, 0x000fe40000011405ULL,
0x0000e00040407811ULL, 0x000fe400078e20ffULL, 0x0000888005607816ULL, 0x000fe400000000ffULL,
0x00000018ff597819ULL, 0x000fe20000011406ULL, 0x000000004050783bULL, 0x000ee20000004200ULL,
0x000001004e3f7824ULL, 0x044fe200078e00ffULL, 0x0000004d006c7306ULL, 0x0005e20000200c00ULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fc40000011407ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000003f00677306ULL, 0x0009e20000200c00ULL, 0x00000008564d7824ULL, 0x004fe200078e00ffULL,
0x000054106a687816ULL, 0x002fe20000000068ULL, 0x0000000856567824ULL, 0x000fca00078e00ffULL,
0x0000004e00647306ULL, 0x000fe20000200c00ULL, 0x0000e000583f7811ULL, 0x010fca00078e20ffULL,
0x000000003f44783bULL, 0x000e640000004200ULL, 0x0000004100587306ULL, 0x0005f00000200c00ULL,
0x0000004f00637306ULL, 0x000fe20000200c00ULL, 0x0000010005417824ULL, 0x004fc400078e00ffULL,
0x0001000005057824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff717819ULL, 0x008fe20000011453ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00000018ff057819ULL, 0x000fce0000011405ULL, 0x0000004100627306ULL, 0x0003f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x002fe20000011444ULL,
0x00000100454c7824ULL, 0x000fe200078e00ffULL, 0x00008880474e7816ULL, 0x000fe200000000ffULL,
0x0000010044427824ULL, 0x000fc800078e00ffULL, 0x0000004100747306ULL, 0x0003e20000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff427819ULL, 0x000fca0000011442ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x002fce0000011445ULL,
0x0000004100757306ULL, 0x0003f00000200c00ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x00000018ff417819ULL, 0x002fce0000011446ULL, 0x00000041007a7306ULL, 0x0003f00000200c00ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x00000018ff417819ULL, 0x002fce0000011447ULL,
0x00000041007d7306ULL, 0x0003f00000200c00ULL, 0x0000006d006d7306ULL, 0x000ee20000200c00ULL,
0x00000018ff417819ULL, 0x002fe40000011450ULL, 0x000054106c697816ULL, 0x004fca0000000069ULL,
0x0000004100827306ULL, 0x0003f00000200c00ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x00000018ff417819ULL, 0x002fe40000011451ULL, 0x000054106d6e7816ULL, 0x008fca000000006eULL,
0x0000004100847306ULL, 0x0003f00000200c00ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x00000018ff417819ULL, 0x002fe40000011452ULL, 0x00005410645e7816ULL, 0x004fca000000005eULL,
0x0000004100867306ULL, 0x0003f00000200c00ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000888044417816ULL, 0x042fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00005410635f7816ULL, 0x008fc8000000005fULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000004100727306ULL, 0x0002b00000200c00ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x0000888045417816ULL, 0x002fce00000000ffULL, 0x0000004100737306ULL, 0x0003e20000200c00ULL,
0x0000541072727816ULL, 0x004fe40000000042ULL, 0x0000000657427810ULL, 0x000fc80007ffe0ffULL,
0xfffffff856427812ULL, 0x000fe200078ee242ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0001000045417824ULL, 0x002fe200078e00ffULL, 0x0000541044447816ULL, 0x008fc80000000074ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004c00457306ULL, 0x0002b00000200c00ULL,
0x0000004100767306ULL, 0x0007220000200c00ULL, 0x00008880464c7816ULL, 0x002fc400000000ffULL,
0x0000541073737816ULL, 0x004fc60000000045ULL, 0x000000ffff417224ULL, 0x008fe400078e004cULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00000100464c7824ULL, 0x040fe400078e00ffULL,
0x0001000046467824ULL, 0x000fc600078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000004100777306ULL, 0x0003e20000200c00ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000541076457816ULL, 0x010fca0000000075ULL, 0x0000004c00787306ULL, 0x0004e20000200c00ULL,
0x0000000457417810ULL, 0x002fc80007ffe0ffULL, 0xfffffff84d417812ULL, 0x000fe200078ee241ULL,
0x00000100474d7824ULL, 0x040fe400078e00ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000046007b7306ULL, 0x0003220000200c00ULL, 0x000000ffff4c7224ULL, 0x004fe200078e004eULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000541077787816ULL, 0x008fc40000000078ULL, 0x0000004c00797306ULL, 0x0005e20000200c00ULL,
0x0000888050467816ULL, 0x002fce00000000ffULL, 0x0000004d007c7306ULL, 0x0002e20000200c00ULL,
0x0000a000414c7811ULL, 0x004fe400078e20ffULL, 0x000054107b7a7816ULL, 0x010fca000000007aULL,
0x00000047007e7306ULL, 0x0005220000200c00ULL, 0x000000004c4c783bULL, 0x002e6e0000000200ULL,
0x00000046007f7306ULL, 0x0009e20000200c00ULL, 0x0000010050477824ULL, 0x044fe200078e00ffULL,
0x0000541079797816ULL, 0x008fe2000000007cULL, 0x0001000050507824ULL, 0x000fc600078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000888051467816ULL, 0x010fe400000000ffULL,
0x000054107e7b7816ULL, 0x000fca000000007dULL, 0x0000004700807306ULL, 0x0004f00000200c00ULL,
0x0000004600817306ULL, 0x0009e20000200c00ULL, 0x0000010051477824ULL, 0x044fe400078e00ffULL,
0x0001000051517824ULL, 0x000fc600078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x000000274c4ca232ULL, 0x082fe20000000000ULL, 0x0000888052467816ULL, 0x010fe200000000ffULL,
0x000000274e4ea232ULL, 0x000fe20000000000ULL, 0x0000004700837306ULL, 0x0002a20000200c00ULL,
0x000000284d4da232ULL, 0x080fe20000000000ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x000000284f4fa232ULL, 0x000fe20000000000ULL, 0x000054107f807816ULL, 0x008fc80000000080ULL,
0x0000004600857306ULL, 0x0007e20000200c00ULL, 0x0000010052477824ULL, 0x042fe200078e00ffULL,
0x000000444c48723cULL, 0x000b620000001848ULL, 0x0001000052527824ULL, 0x000fc600078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x0000888053467816ULL, 0x048fe200000000ffULL, 0x000000724c38723cULL, 0x040be40000001838ULL,
0x0000010053457824ULL, 0x060fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0001000053537824ULL, 0x000fe200078e00ffULL, 0x0000541081817816ULL, 0x004fe20000000083ULL,
0x000000ffff447224ULL, 0x000fe200078e0046ULL, 0x0000005100517306ULL, 0x000ea20000200c00ULL,
0x00000018ff567819ULL, 0x000fe20000011445ULL, 0x000000784c08723cULL, 0x000f620000001808ULL,
0x00000018ff537819ULL, 0x000fca0000011453ULL, 0x0000004400727306ULL, 0x0007e20000200c00ULL,
0x0000541050507816ULL, 0x002fe20000000082ULL, 0x0000007a4c0c723cULL, 0x040f6c000000180cULL,
0x0000004700577306ULL, 0x0003220000200c00ULL, 0x0000a00042447811ULL, 0x008fe200078e20ffULL,
0x000000804c10723cULL, 0x000fe20000001810ULL, 0x0000541051517816ULL, 0x004fca0000000084ULL,
0x0000005600737306ULL, 0x000ea20000200c00ULL, 0x000000004444783bULL, 0x002e620000000200ULL,
0x000000504c14723cULL, 0x000b6c0000001814ULL, 0x0000005200567306ULL, 0x0006e20000200c00ULL,
0x0000541085507816ULL, 0x030fe40000000057ULL, 0x0000541072517816ULL, 0x004fe20000000073ULL,
0x0001000004527824ULL, 0x008fc800078e00ffULL, 0x0000000500727306ULL, 0x000ea20000200c00ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000541056567816ULL, 0x000fca0000000086ULL,
0x0000005300047306ULL, 0x000ef00000200c00ULL, 0x0000005200747306ULL, 0x0009220000200c00ULL,
0x00005410725d7816ULL, 0x004fe2000000005dULL, 0x000000274444a232ULL, 0x082fe20000000000ULL,
0x0000541004577816ULL, 0x008fe20000000071ULL, 0x000000504c50723cULL, 0x010be20000001830ULL,
0x000000274646a232ULL, 0x000fe20000000000ULL, 0x0000888007047816ULL, 0x000fe200000000ffULL,
0x000000284545a232ULL, 0x080fe20000000000ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000000284747a232ULL, 0x000fc40000000000ULL, 0x0000010006307824ULL, 0x060fe200078e00ffULL,
0x0000888006317816ULL, 0x040fe200000000ffULL, 0x000000564c4c723cULL, 0x000b620000001834ULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x00005410745c7816ULL, 0x000fe2000000005cULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000ffff057224ULL, 0x000fe200078e0031ULL, 0x0000541065317816ULL, 0x000fe4000000006bULL,
0x00000018ff067819ULL, 0x000fe20000011406ULL, 0x000000684434723cULL, 0x000f640000001848ULL,
0x0000003000577306ULL, 0x0203f00000200c00ULL, 0x0000000500567306ULL, 0x0005e20000200c00ULL,
0x0000541066307816ULL, 0x002fce0000000067ULL, 0x000000304430723cULL, 0x000b620000001808ULL,
0x0000010007057824ULL, 0x044fe200078e00ffULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0001000007077824ULL, 0x000fc600078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x00000018ff087819ULL, 0x020fe40000011407ULL, 0x00000004006d7306ULL, 0x000fe20000200c00ULL,
0x0000541060097816ULL, 0x000fce0000000062ULL, 0x0000000500497306ULL, 0x000fe20000200c00ULL,
0x000054106f6f7816ULL, 0x002fce0000000070ULL, 0x0000000600487306ULL, 0x0002a20000200c00ULL,
0x0000006e4438723cULL, 0x040f6e0000001838ULL, 0x00000008004a7306ULL, 0x0007220000200c00ULL,
0x0000005e4404723cULL, 0x002f62000000180cULL, 0x0000541061087816ULL, 0x008fce0000000058ULL,
0x0000005c440c723cULL, 0x040b6e0000001814ULL, 0x0000541048147816ULL, 0x024fe20000000059ULL,
0x000000084410723cULL, 0x000b620000001810ULL, 0x000054104a157816ULL, 0x010fcc000000005aULL,
0x0000541056087816ULL, 0x020fe20000000057ULL, 0x000000144414723cULL, 0x000b62000000184cULL,
0x000054106d097816ULL, 0x000fce0000000049ULL, 0x000000084408723cULL, 0x000b620000001850ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000183c00720cULL, 0x000fe20003f06070ULL, 0x01068800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4a7224ULL, 0x002fe200078e0045ULL, 0x0000000155557810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x000fd200078e0054ULL, 0x0000c84000000947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fc40000015200ULL, 0x0106bc00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004644467210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e45ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011447ULL, 0x000000461c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff467224ULL, 0x000fca00000e0647ULL, 0x000000021c1c7819ULL, 0x000fc80000001246ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000203c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000011b457824ULL, 0x000fe200078e0229ULL,
0x0000000429507810ULL, 0x000fe40007ffe0ffULL, 0x0000001c18447217ULL, 0x000fe20007800000ULL,
0x0000000145467824ULL, 0x000fe200078e0202ULL, 0x0000000229477810ULL, 0x000fe20007ffe0ffULL,
0x00000010454e7824ULL, 0x000fe200078e00ffULL, 0x0000000629527810ULL, 0x000fe20007ffe0ffULL,
0x0000000144447824ULL, 0x000fe200078e0a1cULL, 0x00000020031c7811ULL, 0x000fe200078e30ffULL,
0x000000011b497824ULL, 0x040fe200078e0250ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee246ULL,
0x000000011b487824ULL, 0x040fe200078e0247ULL, 0x000000441b447217ULL, 0x000fe20007800000ULL,
0x00000001454c7824ULL, 0x000fe200078e021cULL, 0x000000f0214d7812ULL, 0x000fe200078ec0ffULL,
0x00000001494a7824ULL, 0x040fe200078e0202ULL, 0x0000e0004e4e7811ULL, 0x000fe200078e20ffULL,
0x0000001049517824ULL, 0x000fe200078e00ffULL, 0x0000005b4c4c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001484b7824ULL, 0x000fc400078e021cULL, 0x0000000148467824ULL, 0x040fe200078e0202ULL,
0xfffffff051517812ULL, 0x000fe200078ee24aULL, 0x00000010484f7824ULL, 0x000fe200078e00ffULL,
0x0000005b4b4b7210ULL, 0x080fe20007f9e0ffULL, 0x000000011b457824ULL, 0x000fe200078e0252ULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x0000000149497824ULL, 0x000fe200078e021cULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL, 0x0000000145487824ULL, 0x040fe400078e021cULL,
0x00000001454a7824ULL, 0x000fe200078e0202ULL, 0x0000005b49497210ULL, 0x080fe20007f7e0ffULL,
0x0000001045537824ULL, 0x000fe200078e00ffULL, 0x0000005b485b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff457224ULL, 0x000fe200000e06ffULL, 0x00005e004c467a11ULL, 0x000fe200078040ffULL,
0x00000001441c7824ULL, 0x000fe200078e0a1bULL, 0xfffffff053537812ULL, 0x000fe200078ee24aULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005f004c4c7a11ULL, 0x000fe200000f4445ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x00005e004b4a7a11ULL, 0x000fc400078c40ffULL,
0x0000001c4700720cULL, 0x080fe40003f06070ULL, 0x00005e0049477a11ULL, 0x000fe400078a40ffULL,
0x0000001c2900720cULL, 0x000fe40003f86070ULL, 0x00005f004b4b7a11ULL, 0x000fe400030f4444ULL,
0x0000004d46447210ULL, 0x000fe20007fde0ffULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0x00005f0049497a11ULL, 0x000fc400028f4445ULL, 0x00005e005b487a11ULL, 0x040fe200078a40ffULL,
0x000000ffff457224ULL, 0x000fe200030e064cULL, 0x0000001c5000720cULL, 0x080fe40003f66070ULL,
0x0000001c5200720cULL, 0x000fe40003f46070ULL, 0x00005f005b1c7a11ULL, 0x000fe200028f4446ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000444e7faeULL, 0x0003e2000e101c46ULL,
0x0000004d4a467210ULL, 0x000fe40007fbe0ffULL, 0x0000e0004f4f7811ULL, 0x000fc400078e20ffULL,
0x0000e00053537811ULL, 0x000fe400078e20ffULL, 0x0000004d47447210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff477224ULL, 0x000fe200028e064bULL, 0x0000004d48487210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff457224ULL, 0x000fe200020e0649ULL, 0x00000000464f7faeULL, 0x0003e2000c101c46ULL,
0x000000ffff497224ULL, 0x000fc600028e061cULL, 0x0000000044517faeULL, 0x0003e8000d901c46ULL,
0x0000000048537faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x000000011b1c7824ULL, 0x000fe200078e0229ULL, 0x0000002003457811ULL, 0x000fe400078e30ffULL,
0x000000f0214e7812ULL, 0x000fe200078ec0ffULL, 0x000000011c447824ULL, 0x040fe200078e0202ULL,
0x000000021c477810ULL, 0x040fe20007ffe0ffULL, 0x000000101c4f7824ULL, 0x040fe200078e00ffULL,
0x000000041c487810ULL, 0x000fc40007ffe0ffULL, 0x000000061c497810ULL, 0x040fe20007ffe0ffULL,
0x0000000147467824ULL, 0x000fe200078e0202ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee244ULL,
0x0000001047507824ULL, 0x000fe400078e00ffULL, 0x000000011c447824ULL, 0x000fe200078e0245ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000001451c7824ULL, 0x040fe200078e0247ULL,
0xfffffff050507812ULL, 0x000fe200078ee246ULL, 0x0000000148477824ULL, 0x000fe200078e0202ULL,
0x0000005b44467210ULL, 0x000fe20007f7e0ffULL, 0x0000000145447824ULL, 0x000fe200078e0248ULL,
0x0000001c5b4c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000145457824ULL, 0x000fe200078e0249ULL,
0x00005e00464a7a11ULL, 0x000fe200078840ffULL, 0x0000001048517824ULL, 0x000fe200078e00ffULL,
0x000000445b447210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x000000455b457210ULL, 0x000fe20007f7e0ffULL, 0x0000000149487824ULL, 0x000fe200078e0202ULL,
0xfffffff051517812ULL, 0x000fe200078ee247ULL, 0x0000001049527824ULL, 0x000fe200078e00ffULL,
0x00005f00464d7a11ULL, 0x000fe200020f441cULL, 0x000000ffff4b7224ULL, 0x000fe200000e06ffULL,
0x00005e004c1c7a11ULL, 0x000fe200078040ffULL, 0x000000ffff477224ULL, 0x000fe200010e06ffULL,
0x00005e0044467a11ULL, 0x000fe200078440ffULL, 0x000000ffff497224ULL, 0x000fe200018e06ffULL,
0x0000004e4a4a7210ULL, 0x000fc40007f9e0ffULL, 0xfffffff052527812ULL, 0x000fe400078ee248ULL,
0x00005e0045487a11ULL, 0x040fe400078640ffULL, 0x00005f004c4c7a11ULL, 0x000fe200000f444bULL,
0x000000ffff4b7224ULL, 0x000fe200020e064dULL, 0x00005f0044477a11ULL, 0x000fe400010f4447ULL,
0x0000004e1c447210ULL, 0x080fe40007f1e0ffULL, 0x00005f0045497a11ULL, 0x000fe200018f4449ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004a4f7faeULL, 0x0003e2000b901c46ULL,
0x0000004e46467210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e064cULL,
0x0000004e48487210ULL, 0x000fc40007f7e0ffULL, 0x0000e000501c7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe400010e0647ULL, 0x000000ffff497224ULL, 0x000fe400018e0649ULL,
0x00000000441c7faeULL, 0x0005e2000b901c46ULL, 0x0000e000514a7811ULL, 0x002fe400078e20ffULL,
0x0000e000524b7811ULL, 0x000fc600078e20ffULL, 0x00000000464a7faeULL, 0x0005e8000b901c46ULL,
0x00000000484b7faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x00000002201c7810ULL, 0x000fc80007ffe0ffULL, 0x000000191c00720cULL, 0x000fe20003f06070ULL,
0xffffffffff1c7424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000021e447810ULL, 0x002fe20007ffe020ULL, 0x00000004ff457424ULL, 0x000fc800078e00ffULL,
0x0000600044447625ULL, 0x000fca00078e0045ULL, 0x00000006441c7981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff687f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010628001b487f8cULL, 0x0022e4000c80043fULL,
0x0000000000447805ULL, 0x000fc40000015200ULL, 0x01062c001b467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x00afe40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x00000046444a7210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e45ULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff467819ULL, 0x000fc80000011447ULL, 0x0000004a46467211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e0647ULL, 0x0000000246467819ULL, 0x000fc80000001247ULL,
0x000000460000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01062c001b467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0100800022477984ULL, 0x000e680000000800ULL,
0x0102800022487984ULL, 0x0006a20000000800ULL, 0x000000544700720bULL, 0x002fe20003f1d000ULL,
0x00011cf27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000497806ULL, 0x008fc800000e0100ULL,
0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4a7424ULL, 0x000fc400078e00ffULL, 0x000000ffff467224ULL, 0x000fd200078e0054ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x000000544700720bULL, 0x000fe20003f54000ULL, 0x00011cb27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000467806ULL, 0x000fc400010e0100ULL, 0x0000005447448209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0104804422008388ULL, 0x0003e40000000800ULL,
0x0000991046447816ULL, 0x002fc800000000ffULL, 0x000000ff4400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000005447447209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff46ff7812ULL, 0x000fc6000780c0ffULL,
0x0000005444447221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b44447820ULL, 0x000fc80000410000ULL,
0x00000044004a7308ULL, 0x000e640000000800ULL, 0x0000004a1d1d7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff447819ULL, 0x000fe20000011602ULL,
0x00011bf27f007947ULL, 0x000fea000b800000ULL, 0x00001f444a447589ULL, 0x0002e400000e0000ULL,
0x0000004438387220ULL, 0x088fe20000410000ULL, 0x0000004439397220ULL, 0x080fe20000410000ULL,
0x0000004434347220ULL, 0x080fe20000410000ULL, 0x0000004435357220ULL, 0x080fe20000410000ULL,
0x0000004430307220ULL, 0x080fe20000410000ULL, 0x0000004431317220ULL, 0x080fe20000410000ULL,
0x0000004404047220ULL, 0x080fe20000410000ULL, 0x0000004405057220ULL, 0x080fe20000410000ULL,
0x0000004410107220ULL, 0x080fe20000410000ULL, 0x0000004411117220ULL, 0x080fe20000410000ULL,
0x000000440c0c7220ULL, 0x080fe20000410000ULL, 0x000000440d0d7220ULL, 0x080fe20000410000ULL,
0x0000004408087220ULL, 0x080fe20000410000ULL, 0x0000004409097220ULL, 0x080fe20000410000ULL,
0x0000004414147220ULL, 0x080fe20000410000ULL, 0x0000004415157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0046ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802447811ULL, 0x000fe200078ff0ffULL,
0x00011af27f007947ULL, 0x000fea000b800000ULL, 0x00001f444a447589ULL, 0x00066400000e0000ULL,
0x000000443a3a7220ULL, 0x082fe20000410000ULL, 0x000000443b3b7220ULL, 0x080fe20000410000ULL,
0x0000004436367220ULL, 0x080fe20000410000ULL, 0x0000004437377220ULL, 0x080fe20000410000ULL,
0x0000004432327220ULL, 0x080fe20000410000ULL, 0x0000004433337220ULL, 0x080fe20000410000ULL,
0x0000004406067220ULL, 0x080fe20000410000ULL, 0x0000004407077220ULL, 0x080fe20000410000ULL,
0x0000004412127220ULL, 0x080fe20000410000ULL, 0x0000004413137220ULL, 0x080fe20000410000ULL,
0x000000440e0e7220ULL, 0x080fe20000410000ULL, 0x000000440f0f7220ULL, 0x080fe20000410000ULL,
0x000000440a0a7220ULL, 0x080fe20000410000ULL, 0x000000440b0b7220ULL, 0x080fe20000410000ULL,
0x0000004416167220ULL, 0x080fe20000410000ULL, 0x0000004417177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff46ff7812ULL, 0x000fe20007800849ULL,
0x00000001ff4a7424ULL, 0x00afe200078e00ffULL, 0x0000005447547209ULL, 0x000fca0007810000ULL,
0x000000ffff467224ULL, 0x000fcc00078e0054ULL, 0x8000005447470221ULL, 0x100fe20000010000ULL,
0x000000ffff460224ULL, 0x000fe200078e0054ULL, 0x00007610ff4a0816ULL, 0x000fe4000000004aULL,
0x3fb8aa3b47470820ULL, 0x000fc80000410000ULL, 0x0000004700260308ULL, 0x000e640000000800ULL,
0x0000002648480220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001d481d7221ULL, 0x004fc20000010000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff477984ULL, 0x000e640000000800ULL, 0x8000000047ff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0000004844487210ULL, 0x000fca0007f1e1ffULL,
0x0000000149497824ULL, 0x000fe200000e0e45ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff477819ULL, 0x000fc80000011449ULL,
0x0000004847477211ULL, 0x000fca00078110ffULL, 0x000000ffff487224ULL, 0x000fca00000e0649ULL,
0x0000000247477819ULL, 0x000fc80000001248ULL, 0x000000470000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff477984ULL, 0x000e640000000800ULL,
0x8000000047ff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104a437816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff4300720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000026ff27723eULL, 0x000fe400000000ffULL, 0x00000002ff477819ULL, 0x000fe40000011602ULL,
0x0000541027437816ULL, 0x000fe20000000027ULL, 0x000116c27f007947ULL, 0x000fea000b800000ULL,
0x00001f4743277589ULL, 0x0002a400000e0000ULL, 0x0000000847287810ULL, 0x000fe20007ffe0ffULL,
0x000116f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2843287589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001047457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0043ULL, 0x00006ef000447802ULL, 0x000fc40000000f00ULL,
0x0001223000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001847457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e0043ULL,
0x00006f4000447802ULL, 0x000fc40000000f00ULL, 0x000121e000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002a54783bULL, 0x000ee80000004200ULL, 0x000000002b4c783bULL, 0x004ea80000004200ULL,
0x000000002c50783bULL, 0x000e680000004200ULL, 0x000000002d48783bULL, 0x000e620000004200ULL,
0x00000018ff5d7819ULL, 0x008fe20000011457ULL, 0x0000010057657824ULL, 0x040fe200078e00ffULL,
0x0000888057647816ULL, 0x040fe200000000ffULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011456ULL, 0x0000010056637824ULL, 0x040fe200078e00ffULL,
0x0000888056627816ULL, 0x040fe200000000ffULL, 0x0001000056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000006400667306ULL, 0x000fe20000200c00ULL,
0x00000018ff617819ULL, 0x004fe2000001144dULL, 0x0000010054597824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x00000100555e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc4000001144cULL, 0x00000018ff6e7819ULL, 0x000fe2000001144eULL,
0x0000005700677306ULL, 0x0005e20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fe4000001144fULL,
0x00000018ff6c7819ULL, 0x002fe40000011450ULL, 0x00000018ff6d7819ULL, 0x000fe40000011451ULL,
0x00000018ff437819ULL, 0x000fe20000011454ULL, 0x0000005600647306ULL, 0x0003e20000200c00ULL,
0x000001004c577824ULL, 0x004fe200078e00ffULL, 0x0000888054587816ULL, 0x040fe200000000ffULL,
0x0001000054547824ULL, 0x000fe200078e00ffULL, 0x00008880555b7816ULL, 0x000fc400000000ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000043005a7306ULL, 0x0005e20000200c00ULL,
0x000088804c567816ULL, 0x042fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000005600707306ULL, 0x0003e20000200c00ULL,
0x00000018ff437819ULL, 0x004fe20000011455ULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00000018ff6a7819ULL, 0x000fe40000011452ULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000005700717306ULL, 0x0005e20000200c00ULL,
0x000088804d567816ULL, 0x042fe400000000ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011453ULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000004c00727306ULL, 0x0003e20000200c00ULL, 0x000001004d577824ULL, 0x044fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011449ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fc40000011448ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000005600737306ULL, 0x0005e20000200c00ULL,
0x000088804e4c7816ULL, 0x002fe400000000ffULL, 0x00000018ff447819ULL, 0x000fca000001144bULL,
0x0000004d00757306ULL, 0x0003e20000200c00ULL, 0x0000888051567816ULL, 0x004fce00000000ffULL,
0x0000004c00767306ULL, 0x0005e20000200c00ULL, 0x000001004e4d7824ULL, 0x042fe400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000088804f4c7816ULL, 0x004fce00000000ffULL, 0x0000004d00777306ULL, 0x0003f00000200c00ULL,
0x0000004c00797306ULL, 0x0005e20000200c00ULL, 0x000001004f4d7824ULL, 0x042fe400078e00ffULL,
0x000100004f4f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000004e00787306ULL, 0x000fe20000200c00ULL,
0x00008880504c7816ULL, 0x004fce00000000ffULL, 0x0000004d007a7306ULL, 0x0003f00000200c00ULL,
0x0000004c007c7306ULL, 0x0005e20000200c00ULL, 0x00000100504d7824ULL, 0x042fe400078e00ffULL,
0x0001000050507824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004f007b7306ULL, 0x000fe20000200c00ULL, 0x0000a8002e4c7811ULL, 0x004fe400078e20ffULL,
0x00000018ff507819ULL, 0x000fca0000011450ULL, 0x0000004d007d7306ULL, 0x0003f00000200c00ULL,
0x00000050007e7306ULL, 0x0005e20000200c00ULL, 0x000000004c4c783bULL, 0x002e6e0000000200ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000000ffff507224ULL, 0x004fc400078e0056ULL,
0x0000010051567824ULL, 0x040fe400078e00ffULL, 0x0001000051517824ULL, 0x000fc600078e00ffULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff517819ULL, 0x000fca0000011451ULL, 0x0000005100817306ULL, 0x0005f00000200c00ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000010052517824ULL, 0x004fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000043005f7306ULL, 0x0005e20000200c00ULL,
0x000000274c4ca232ULL, 0x082fe40000000000ULL, 0x000000274e4ea232ULL, 0x000fe40000000000ULL,
0x000000284d4da232ULL, 0x080fe40000000000ULL, 0x000000284f4fa232ULL, 0x000fe20000000000ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x00000018ff437819ULL, 0x004fce000001144aULL,
0x0000005500557306ULL, 0x000eb00000200c00ULL, 0x00000050007f7306ULL, 0x0007e20000200c00ULL,
0x0000541054547816ULL, 0x002fce000000005aULL, 0x0000005100837306ULL, 0x0003e20000200c00ULL,
0x0000888052507816ULL, 0x048fe200000000ffULL, 0x0001000052527824ULL, 0x000fe200078e00ffULL,
0x0000541055557816ULL, 0x004fc8000000005fULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0000005000827306ULL, 0x0005e20000200c00ULL, 0x0000010053517824ULL, 0x002fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005600807306ULL, 0x0003e20000200c00ULL,
0x0000888053507816ULL, 0x004fce00000000ffULL, 0x0000005000857306ULL, 0x0005e20000200c00ULL,
0x0001000053567824ULL, 0x002fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000005100867306ULL, 0x0003e20000200c00ULL, 0x0000541058507816ULL, 0x004fce0000000059ULL,
0x0000005200847306ULL, 0x0005e20000200c00ULL, 0x000054105b517816ULL, 0x002fce000000005eULL,
0x0000005700747306ULL, 0x000fe20000200c00ULL, 0x000000504c50723cULL, 0x044bee0000001838ULL,
0x0000888048387816ULL, 0x060fe200000000ffULL, 0x0000005600877306ULL, 0x0003f00000200c00ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000000544c54723cULL, 0x002bee0000001834ULL,
0x000000ffff347224ULL, 0x020fe200078e0038ULL, 0x0000a8002f387811ULL, 0x000fe200078e20ffULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x0000010048357824ULL, 0x000fc400078e00ffULL,
0x0001000048487824ULL, 0x000fe400078e00ffULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x00000018ff487819ULL, 0x000fce0000011448ULL, 0x0000005c005c7306ULL, 0x000ee20000200c00ULL,
0x0000541062587816ULL, 0x002fce0000000063ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x0000541066597816ULL, 0x008fe40000000065ULL, 0x0000541079657816ULL, 0x000fca000000007aULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x00005410645c7816ULL, 0x000fe2000000005cULL,
0x000000584c58723cULL, 0x000b620000001830ULL, 0x0000541076647816ULL, 0x000fca0000000077ULL,
0x0000006100617306ULL, 0x000ee20000200c00ULL, 0x00005410675d7816ULL, 0x002fe2000000005dULL,
0x0000010049317824ULL, 0x060fe200078e00ffULL, 0x0000888049307816ULL, 0x040fe200000000ffULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x000000644c64723cULL, 0x040be20000001808ULL,
0x000000273838a232ULL, 0x084fe20000000000ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541072607816ULL, 0x008fe20000000060ULL,
0x000000273a3aa232ULL, 0x000fe20000000000ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x000001004a0a7824ULL, 0x060fe200078e00ffULL, 0x0000005c4c04723cULL, 0x000b620000001804ULL,
0x000088804a087816ULL, 0x040fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000541075617816ULL, 0x000fe20000000061ULL,
0x000000283939a232ULL, 0x080fe20000000000ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x000000283b3ba232ULL, 0x000fe20000000000ULL, 0x00005410705c7816ULL, 0x020fc40000000071ULL,
0x00005410735d7816ULL, 0x000fe20000000074ULL, 0x000000604c60723cULL, 0x000fe2000000180cULL,
0x00005410786e7816ULL, 0x002fe2000000006eULL, 0x0000004900097306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x000054107b6f7816ULL, 0x004fc6000000006fULL,
0x0000005c4c5c723cULL, 0x040f640000001810ULL, 0x0000000800497306ULL, 0x0003ec0000200c00ULL,
0x0000006e4c4c723cULL, 0x000b640000001814ULL, 0x0000003400887306ULL, 0x0005e20000200c00ULL,
0x000088804b087816ULL, 0x002fc800000000ffULL, 0x0000541082147816ULL, 0x020fc60000000083ULL,
0x0000000a006e7306ULL, 0x0003e20000200c00ULL, 0x000054107c347816ULL, 0x004fe4000000007dULL,
0x0000541085157816ULL, 0x000fca0000000086ULL, 0x0000003500897306ULL, 0x0004e20000200c00ULL,
0x000001004b0a7824ULL, 0x042fe200078e00ffULL, 0x000000143814723cULL, 0x000f620000001858ULL,
0x000100004b4b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x000054107f357816ULL, 0x004fe40000000080ULL,
0x00000018ff4b7819ULL, 0x000fca000001144bULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x000000343834723cULL, 0x000f620000001850ULL, 0x00005410880c7816ULL, 0x008fcc0000000089ULL,
0x0000006c006c7306ULL, 0x000ee20000200c00ULL, 0x0000541084107816ULL, 0x002fce000000006aULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x0000541087117816ULL, 0x004fce000000006bULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x000000103810723cULL, 0x000b6e0000001804ULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x0000541049047816ULL, 0x020fce000000006eULL,
0x00000030008a7306ULL, 0x0007f00000200c00ULL, 0x0000003100707306ULL, 0x0004a20000200c00ULL,
0x000054107e307816ULL, 0x008fe4000000006cULL, 0x0000541009097816ULL, 0x002fca0000000047ULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x0000541081317816ULL, 0x004fce000000006dULL,
0x0000000800507306ULL, 0x0003e20000200c00ULL, 0x000054108a0d7816ULL, 0x000fe20000000070ULL,
0x000000303830723cULL, 0x040b6c0000001854ULL, 0x0000000a00517306ULL, 0x0004e20000200c00ULL,
0x0000541048087816ULL, 0x002fe20000000045ULL, 0x0000000c380c723cULL, 0x040b6c000000185cULL,
0x0000004300437306ULL, 0x000fe40000200c00ULL, 0x000000083808723cULL, 0x004b6c0000001860ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x0000541050057816ULL, 0x008fce0000000051ULL,
0x0000004a004a7306ULL, 0x000e620000200c00ULL, 0x000000043804723cULL, 0x000b6e0000001864ULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x000054104a4a7816ULL, 0x002fe40000000043ULL,
0x000054104b4b7816ULL, 0x004fce0000000044ULL, 0x0000004a3838723cULL, 0x000b62000000184cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff4a7f8cULL, 0x020e62000c80043fULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x0000000000447805ULL, 0x000fc40000015200ULL,
0x0106bc00ff437984ULL, 0x000ea40000000800ULL, 0x8000000043ff7812ULL, 0x006fe4000780484bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004844477210ULL, 0x000fca0007f1e1ffULL, 0x0000000149487824ULL, 0x000fe200000e0e45ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff437819ULL, 0x000fc80000011448ULL, 0x0000004743437211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e0648ULL, 0x0000000243437819ULL, 0x000fc80000001247ULL,
0x000000430000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000058001c477a24ULL, 0x010fc800078e02ffULL,
0x0000004047477824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000403c437810ULL, 0x000fe20007ffe0ffULL, 0x000000011b457824ULL, 0x000fe200078e0229ULL,
0x0000000229517810ULL, 0x000fe40007ffe0ffULL, 0x0000004318447217ULL, 0x000fe20007800000ULL,
0x00000040034e7824ULL, 0x000fe200078e0245ULL, 0x0000000429537810ULL, 0x000fe20007ffe0ffULL,
0x0000000145487824ULL, 0x000fe200078e0202ULL, 0x000000f0214f7812ULL, 0x000fe200078ec0ffULL,
0x0000001045507824ULL, 0x000fe200078e00ffULL, 0x000000474e4b7210ULL, 0x0c0fe20007f1e0ffULL,
0x000000011b457824ULL, 0x040fe200078e0251ULL, 0x000000024e4d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000144447824ULL, 0x000fe200078e0a43ULL, 0xfffffff050507812ULL, 0x000fe200078ee248ULL,
0x000000011b437824ULL, 0x000fe200078e0253ULL, 0x000000044e4c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000145487824ULL, 0x100fe200078e0202ULL, 0x000000441b447217ULL, 0x000fe20007800000ULL,
0x0000001045527824ULL, 0x000fe200078e00ffULL, 0x000000474c4c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000143457824ULL, 0x040fe200078e0202ULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x0000001043547824ULL, 0x000fe200078e00ffULL, 0xfffffff052527812ULL, 0x000fe200078ee248ULL,
0x000000ffff437224ULL, 0x000fe200000e06ffULL, 0x00005e004b497a11ULL, 0x000fc400078040ffULL,
0xfffffff054547812ULL, 0x000fe200078ee245ULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0x00005f004b4b7a11ULL, 0x000fe200000f4443ULL, 0x0000000144437824ULL, 0x000fe200078e0a1bULL,
0x000000474d4d7210ULL, 0x000fe40007f1e0ffULL, 0x00005e004c487a11ULL, 0x000fe400078a40ffULL,
0x000000432900720cULL, 0x000fe20003f86070ULL, 0x000000ffff447224ULL, 0x000fe200000e06ffULL,
0x00005e004d4a7a11ULL, 0x000fc400078040ffULL, 0x00005f004c4c7a11ULL, 0x000fe400028f4445ULL,
0x00005f004d4d7a11ULL, 0x000fe400000f4444ULL, 0x0000004f49447210ULL, 0x000fe40007f7e0ffULL,
0x000000435100720cULL, 0x000fe40003f06070ULL, 0x0000000629517810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff457224ULL, 0x000fe200018e064bULL, 0x000000064e497810ULL, 0x000fc40007ffe0ffULL,
0x000000435300720cULL, 0x000fe20003f66070ULL, 0x000000011b4b7824ULL, 0x000fe200078e0251ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044507faeULL, 0x0003e2000e101c46ULL,
0x0000004749497210ULL, 0x000fe40007f9e0ffULL, 0x000000014b4e7824ULL, 0x000fe200078e0202ULL,
0x0000004f48487210ULL, 0x000fe40007fde0ffULL, 0x0000c00052527811ULL, 0x000fe400078e20ffULL,
0x0000c00054547811ULL, 0x000fc400078e20ffULL, 0x0000004f4a447210ULL, 0x002fe20007fbe0ffULL,
0x000000104b507824ULL, 0x000fe400078e00ffULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x00005e00494a7a11ULL, 0x000fe200078840ffULL, 0x000000ffff457224ULL, 0x000fe200028e064dULL,
0x000000435100720cULL, 0x000fe40003fa6070ULL, 0x00005f0049437a11ULL, 0x000fe200020f444bULL,
0x000000ffff497224ULL, 0x000fe200030e064cULL, 0x0000004f4a4a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000044527faeULL, 0x0003e2000c101c46ULL, 0xfffffff0504e7812ULL, 0x000fc600078ee24eULL,
0x000000ffff4b7224ULL, 0x000fe200020e0643ULL, 0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL,
0x0000000048547faeULL, 0x0003e8000d901c46ULL, 0x000000004a4e7faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x000000011b437824ULL, 0x000fe200078e0229ULL,
0x000000f0214c7812ULL, 0x000fc600078ec0ffULL, 0x0000000143447824ULL, 0x040fe200078e0202ULL,
0x0000000243457810ULL, 0x040fe20007ffe0ffULL, 0x0000001043497824ULL, 0x000fc800078e00ffULL,
0x0000000145487824ULL, 0x000fe200078e0202ULL, 0xfffffff049497812ULL, 0x000fe200078ee244ULL,
0x00000010454d7824ULL, 0x000fe200078e00ffULL, 0x0000000443457810ULL, 0x000fe20007ffe0ffULL,
0x0000004003447824ULL, 0x000fe200078e0243ULL, 0x0000c00049497811ULL, 0x000fe400078e20ffULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee248ULL, 0x00000001454a7824ULL, 0x000fe200078e0202ULL,
0x0000000643487810ULL, 0x000fe20007ffe0ffULL, 0x0000001045517824ULL, 0x000fe200078e00ffULL,
0x0000004744437210ULL, 0x000fc60007f1e0ffULL, 0x00000001484b7824ULL, 0x040fe200078e0202ULL,
0xfffffff051517812ULL, 0x000fe200078ee24aULL, 0x0000001048557824ULL, 0x000fe200078e00ffULL,
0x00000002444a7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff457224ULL, 0x000fe200000e06ffULL,
0x00005e0043487a11ULL, 0x000fe400078040ffULL, 0xfffffff055557812ULL, 0x000fe400078ee24bULL,
0x00005f0043457a11ULL, 0x000fe400000f4445ULL, 0x0000000444437810ULL, 0x000fc40007ffe0ffULL,
0x0000000644447810ULL, 0x000fe40007ffe0ffULL, 0x00000047434e7210ULL, 0x080fe40007f7e0ffULL,
0x000000474a4a7210ULL, 0x080fe40007f1e0ffULL, 0x0000004744527210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff4f7224ULL, 0x000fe200018e06ffULL, 0x0000004c48447210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e06ffULL, 0x00005e004a4b7a11ULL, 0x000fe200078040ffULL,
0x000000ffff537224ULL, 0x000fe200028e06ffULL, 0x00005e004e507a11ULL, 0x000fe200078840ffULL,
0x000000ffff457224ULL, 0x000fe200018e0645ULL, 0x00005e0052547a11ULL, 0x000fc400078a40ffULL,
0x00005f004a437a11ULL, 0x000fe400000f4443ULL, 0x0000004c4b487210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044497faeULL, 0x0003e2000b901c46ULL,
0x00005f004e4f7a11ULL, 0x000fe400020f444fULL, 0x0000004c504a7210ULL, 0x080fe40007f7e0ffULL,
0x00005f0052537a11ULL, 0x000fe400028f4453ULL, 0x0000004c544c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e064fULL, 0x0000c00051517811ULL, 0x000fc400078e20ffULL,
0x0000c00055557811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x002fe200000e0643ULL,
0x0000c0004d447811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fc800020e0653ULL,
0x0000000048447faeULL, 0x0003e8000b901c46ULL, 0x000000004a517faeULL, 0x0003e8000b901c46ULL,
0x000000004c557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff447f8cULL, 0x002e64000c80043fULL,
0x000000ffff437224ULL, 0x002fc400078e0045ULL, 0x0000000000447805ULL, 0x000fca0000015200ULL,
0x0106b400ff487984ULL, 0x000e640000000800ULL, 0x8000000048ff7812ULL, 0x002fc40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x00000048444a7210ULL, 0x000fca0007f1e1ffULL,
0x0000000149497824ULL, 0x000fe200000e0e45ULL, 0x003d09004a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff487819ULL, 0x000fc80000011449ULL,
0x0000004a48487211ULL, 0x000fca00078110ffULL, 0x000000ffff497224ULL, 0x000fca00000e0649ULL,
0x0000000248487819ULL, 0x000fc80000001249ULL, 0x000000480000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff487984ULL, 0x000e640000000800ULL,
0x8000000048ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000026ff27723eULL, 0x000fe400000000ffULL, 0x00000002ff497819ULL, 0x000fe40000011602ULL,
0x0000541027487816ULL, 0x000fe20000000027ULL, 0x0000faa27f007947ULL, 0x000fea000b800000ULL,
0x00001f4948277589ULL, 0x0002a400000e0000ULL, 0x0000000849287810ULL, 0x000fe20007ffe0ffULL,
0x0000fad27f007947ULL, 0x000fea000b800000ULL, 0x00001f2848287589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001049457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0048ULL, 0x00008bd000447802ULL, 0x000fc40000000f00ULL,
0x0001055000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001849457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e0048ULL,
0x00008c2000447802ULL, 0x000fc40000000f00ULL, 0x0001050000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003f4c783bULL, 0x004ea80000004200ULL, 0x000000004054783bULL, 0x000f280000004200ULL,
0x000000003d50783bULL, 0x000ee80000004200ULL, 0x000000003e48783bULL, 0x00ae620000004200ULL,
0x00000018ff447819ULL, 0x004fe2000001144cULL, 0x000001004c657824ULL, 0x040fe200078e00ffULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x000088804d687816ULL, 0x000fe200000000ffULL, 0x0000004400667306ULL, 0x0005e20000200c00ULL,
0x00000018ff627819ULL, 0x000fc4000001144eULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff637819ULL, 0x000fe4000001144fULL, 0x00000018ff5e7819ULL, 0x010fe20000011456ULL,
0x0000004c00677306ULL, 0x0007220000200c00ULL, 0x00000018ff447819ULL, 0x004fe4000001144dULL,
0x00000018ff5c7819ULL, 0x000fe40000011450ULL, 0x00000018ff5d7819ULL, 0x000fc40000011451ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000000ffff4c7224ULL, 0x008fe200078e0068ULL, 0x00000018ff5a7819ULL, 0x000fe20000011452ULL,
0x000001004d687824ULL, 0x040fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011453ULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe40000011454ULL,
0x0000004c00697306ULL, 0x0005e20000200c00ULL, 0x00000018ff687819ULL, 0x000fc40000011468ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff617819ULL, 0x000fe40000011455ULL,
0x00000018ff5f7819ULL, 0x000fe20000011457ULL, 0x0000004d006b7306ULL, 0x0007e20000200c00ULL,
0x000088804e4c7816ULL, 0x004fe400000000ffULL, 0x0000541067667816ULL, 0x010fe40000000066ULL,
0x00000018ff587819ULL, 0x002fc40000011448ULL, 0x00000018ff597819ULL, 0x000fe20000011449ULL,
0x0000004c006c7306ULL, 0x0003e20000200c00ULL, 0x000001004e4d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe2000001144bULL, 0x000100004e4e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x000088804f4c7816ULL, 0x002fce00000000ffULL,
0x0000004d006d7306ULL, 0x0003f00000200c00ULL, 0x0000004c006f7306ULL, 0x0007e20000200c00ULL,
0x000001004f4d7824ULL, 0x042fe200078e00ffULL, 0x0000541064647816ULL, 0x004fe20000000065ULL,
0x000100004f4f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000004e006e7306ULL, 0x000fe20000200c00ULL,
0x00008880544c7816ULL, 0x008fce00000000ffULL, 0x0000004d00707306ULL, 0x0003f00000200c00ULL,
0x0000004c00727306ULL, 0x0005e20000200c00ULL, 0x00000100544d7824ULL, 0x042fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004f00717306ULL, 0x000fe20000200c00ULL, 0x00008880554c7816ULL, 0x004fe400000000ffULL,
0x00000018ff547819ULL, 0x000fca0000011454ULL, 0x0000004d00737306ULL, 0x0002b00000200c00ULL,
0x0000004c00747306ULL, 0x0007e20000200c00ULL, 0x00000100554d7824ULL, 0x042fe400078e00ffULL,
0x0001000055557824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x00008880564c7816ULL, 0x008fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000541072727816ULL, 0x004fc60000000073ULL,
0x0000004d00757306ULL, 0x0004f00000200c00ULL, 0x0000004c00767306ULL, 0x0009e20000200c00ULL,
0x00000100564d7824ULL, 0x044fe200078e00ffULL, 0x0000541069657816ULL, 0x002fe20000000068ULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x00000044006a7306ULL, 0x0002a20000200c00ULL,
0x00008880574c7816ULL, 0x010fe400000000ffULL, 0x0000541074737816ULL, 0x008fca0000000075ULL,
0x0000004d00777306ULL, 0x0007e20000200c00ULL, 0x00000018ff447819ULL, 0x002fce000001144aULL,
0x0000004c00797306ULL, 0x0003e20000200c00ULL, 0x00000100574d7824ULL, 0x008fe200078e00ffULL,
0x000054106b677816ULL, 0x004fe2000000006aULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000005600787306ULL, 0x0005e20000200c00ULL,
0x00008880504c7816ULL, 0x002fe400000000ffULL, 0x00000018ff577819ULL, 0x000fca0000011457ULL,
0x0000004d007a7306ULL, 0x0003e20000200c00ULL, 0x0000888051567816ULL, 0x004fce00000000ffULL,
0x0000004c007c7306ULL, 0x0005e20000200c00ULL, 0x00000100504d7824ULL, 0x042fe400078e00ffULL,
0x0001000050507824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000006200627306ULL, 0x000e620000200c00ULL,
0x0000a800414c7811ULL, 0x004fce00078e20ffULL, 0x0000004d007d7306ULL, 0x0005f00000200c00ULL,
0x00000050007e7306ULL, 0x0007e20000200c00ULL, 0x000000004c4c783bULL, 0x004ea20000000200ULL,
0x000054106e627816ULL, 0x002fcc0000000062ULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x000000ffff507224ULL, 0x008fe400078e0056ULL, 0x0000010051567824ULL, 0x040fe400078e00ffULL,
0x0001000051517824ULL, 0x000fc600078e00ffULL, 0x00000050007f7306ULL, 0x0007e20000200c00ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff517819ULL, 0x000fca0000011451ULL,
0x0000005100817306ULL, 0x0009e20000200c00ULL, 0x0000888052507816ULL, 0x008fe400000000ffULL,
0x0000541071637816ULL, 0x002fca0000000063ULL, 0x0000005000827306ULL, 0x0003e20000200c00ULL,
0x0000010052517824ULL, 0x050fe400078e00ffULL, 0x0001000052527824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005600807306ULL, 0x0007e20000200c00ULL,
0x000000274c4ca232ULL, 0x084fe20000000000ULL, 0x0000888053507816ULL, 0x002fe200000000ffULL,
0x000000274e4ea232ULL, 0x000fe20000000000ULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x000000284d4da232ULL, 0x080fe40000000000ULL, 0x000000284f4fa232ULL, 0x000fe20000000000ULL,
0x0000005100837306ULL, 0x0003e20000200c00ULL, 0x0000a80042567811ULL, 0x008fca00078e20ffULL,
0x000000644c34723cULL, 0x000b640000001834ULL, 0x0000005000857306ULL, 0x0005e20000200c00ULL,
0x0000010053517824ULL, 0x042fe400078e00ffULL, 0x0001000053537824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x000000664c30723cULL, 0x000f620000001830ULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000005200847306ULL, 0x000fe20000200c00ULL,
0x000054106c507816ULL, 0x004fca000000006dULL, 0x000000624c10723cULL, 0x040fe40000001810ULL,
0x0000005100867306ULL, 0x0003ec0000200c00ULL, 0x000000724c0c723cULL, 0x000fe4000000180cULL,
0x0000005300647306ULL, 0x020fe20000200c00ULL, 0x0000888048517816ULL, 0x002fce00000000ffULL,
0x0000005100657306ULL, 0x0003f00000200c00ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000054106f517816ULL, 0x002fce0000000070ULL, 0x000000504c50723cULL, 0x000b620000001814ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000000005614783bULL, 0x0202ae0000000200ULL,
0x0000005400547306ULL, 0x000ee20000200c00ULL, 0x0000888049567816ULL, 0x002fce00000000ffULL,
0x0000005500557306ULL, 0x000e700000200c00ULL, 0x00000057007b7306ULL, 0x0009e20000200c00ULL,
0x0000541054607816ULL, 0x008fe40000000060ULL, 0x0000541076547816ULL, 0x000fca0000000077ULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x0000010048577824ULL, 0x050fe200078e00ffULL,
0x0000541055617816ULL, 0x002fe20000000061ULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x0000541079557816ULL, 0x000fe4000000007aULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x000000604c08723cULL, 0x000f620000001808ULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x000000271414a232ULL, 0x004fc40000000000ULL,
0x000000271616a232ULL, 0x000fe40000000000ULL, 0x000000281515a232ULL, 0x080fe20000000000ULL,
0x0000005700667306ULL, 0x0005e20000200c00ULL, 0x00005410785e7816ULL, 0x008fe2000000005eULL,
0x000000281717a232ULL, 0x000fcc0000000000ULL, 0x0000005c005c7306ULL, 0x000ee20000200c00ULL,
0x0000010049577824ULL, 0x004fe200078e00ffULL, 0x000054107b5f7816ULL, 0x002fe2000000005fULL,
0x0001000049497824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x00000018ff497819ULL, 0x000fce0000011449ULL,
0x0000005600627306ULL, 0x000fe20000200c00ULL, 0x000054107e5c7816ULL, 0x008fce000000005cULL,
0x0000005700637306ULL, 0x0005e20000200c00ULL, 0x00005410815d7816ULL, 0x002fce000000005dULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x000000544c54723cULL, 0x044b6e0000001804ULL,
0x000001004a057824ULL, 0x060fe200078e00ffULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x000088804a047816ULL, 0x040fe200000000ffULL, 0x0000005e4c4c723cULL, 0x000b620000001838ULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fc40000011405ULL,
0x00005410845a7816ULL, 0x002fe4000000005aULL, 0x00000004005e7306ULL, 0x0203e20000200c00ULL,
0x000054107c387816ULL, 0x000fe4000000007dULL, 0x000054107f397816ULL, 0x000fe40000000080ULL,
0x00000018ff4a7819ULL, 0x000fc6000001144aULL, 0x00000005005f7306ULL, 0x0007e20000200c00ULL,
0x000088804b047816ULL, 0x002fe200000000ffULL, 0x000000381438723cULL, 0x000f620000001834ULL,
0x00005410645b7816ULL, 0x004fca000000005bULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000001004b057824ULL, 0x048fe200078e00ffULL, 0x0000005c1434723cULL, 0x000b620000001830ULL,
0x000100004b4b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000541082307816ULL, 0x020fe40000000083ULL, 0x0000541085317816ULL, 0x000fc60000000086ULL,
0x0000004800487306ULL, 0x000e680000200c00ULL, 0x000000301430723cULL, 0x000f680000001850ULL,
0x0000004900497306ULL, 0x000eb00000200c00ULL, 0x0000000400607306ULL, 0x000fe20000200c00ULL,
0x0000541048587816ULL, 0x002fce0000000058ULL, 0x00000005005c7306ULL, 0x0003e20000200c00ULL,
0x0000541049597816ULL, 0x004fce0000000059ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000005a1404723cULL, 0x002b6e0000001810ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000541065107816ULL, 0x020fe40000000066ULL, 0x0000541062117816ULL, 0x000fca0000000063ULL,
0x0000004a004a7306ULL, 0x000e640000200c00ULL, 0x000000101410723cULL, 0x040f6c000000180cULL,
0x0000004b004b7306ULL, 0x000ea40000200c00ULL, 0x00000058140c723cULL, 0x000b620000001808ULL,
0x000054104a447816ULL, 0x002fcc0000000044ULL, 0x000054105e087816ULL, 0x020fe4000000005fULL,
0x0000541060097816ULL, 0x000fe4000000005cULL, 0x000054104b457816ULL, 0x004fca0000000045ULL,
0x000000081408723cULL, 0x040b700000001854ULL, 0x000000441414723cULL, 0x000b62000000184cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000403c447810ULL, 0x002fe20007ffe0ffULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4a7224ULL, 0x000fe200078e0045ULL, 0x0000000220557810ULL, 0x000fc40007ffe0ffULL,
0x000000184400720cULL, 0x000fda0003f06070ULL, 0x0000858000000947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fc40000015200ULL, 0x0106bc00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004844487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e45ULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011449ULL, 0x000000481c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x000000021c1c7819ULL, 0x000fc80000001248ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000603c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000011b457824ULL, 0x000fe200078e0229ULL,
0x0000000429527810ULL, 0x000fe40007ffe0ffULL, 0x0000001c18447217ULL, 0x000fe20007800000ULL,
0x0000000145487824ULL, 0x000fe200078e0202ULL, 0x0000000229497810ULL, 0x000fe20007ffe0ffULL,
0x0000001045507824ULL, 0x000fe200078e00ffULL, 0x0000000629547810ULL, 0x000fe20007ffe0ffULL,
0x0000000144447824ULL, 0x000fe200078e0a1cULL, 0x00000020031c7811ULL, 0x000fe200078e30ffULL,
0x000000011b4b7824ULL, 0x040fe200078e0252ULL, 0xfffffff050507812ULL, 0x000fe200078ee248ULL,
0x000000011b4a7824ULL, 0x040fe200078e0249ULL, 0x000000441b447217ULL, 0x000fe20007800000ULL,
0x00000001454e7824ULL, 0x000fe200078e021cULL, 0x000000f0214f7812ULL, 0x000fe200078ec0ffULL,
0x000000014b4c7824ULL, 0x040fe200078e0202ULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000104b537824ULL, 0x000fe200078e00ffULL, 0x000000474e4e7210ULL, 0x000fe20007f1e0ffULL,
0x000000014a4d7824ULL, 0x000fc400078e021cULL, 0x000000014a487824ULL, 0x040fe200078e0202ULL,
0xfffffff053537812ULL, 0x000fe200078ee24cULL, 0x000000104a517824ULL, 0x000fe200078e00ffULL,
0x000000474d4d7210ULL, 0x080fe20007f9e0ffULL, 0x000000011b457824ULL, 0x000fe200078e0254ULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000014b4b7824ULL, 0x000fe200078e021cULL,
0xfffffff051517812ULL, 0x000fe200078ee248ULL, 0x00000001454a7824ULL, 0x040fe400078e021cULL,
0x00000001454c7824ULL, 0x000fe200078e0202ULL, 0x000000474b4b7210ULL, 0x080fe20007f7e0ffULL,
0x0000001045557824ULL, 0x000fe200078e00ffULL, 0x000000474a477210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff457224ULL, 0x000fe200000e06ffULL, 0x00005e004e487a11ULL, 0x000fe200078040ffULL,
0x00000001441c7824ULL, 0x000fe200078e0a1bULL, 0xfffffff055557812ULL, 0x000fe200078ee24cULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005f004e4e7a11ULL, 0x000fe200000f4445ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x00005e004d4c7a11ULL, 0x000fc400078c40ffULL,
0x0000001c4900720cULL, 0x080fe40003f06070ULL, 0x00005e004b497a11ULL, 0x000fe400078a40ffULL,
0x0000001c2900720cULL, 0x000fe40003f86070ULL, 0x00005f004d4d7a11ULL, 0x000fe400030f4444ULL,
0x0000004f48447210ULL, 0x000fe20007fde0ffULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x00005f004b4b7a11ULL, 0x000fc400028f4445ULL, 0x00005e00474a7a11ULL, 0x040fe200078a40ffULL,
0x000000ffff457224ULL, 0x000fe200030e064eULL, 0x0000001c5200720cULL, 0x080fe40003f66070ULL,
0x0000001c5400720cULL, 0x000fe40003f46070ULL, 0x00005f00471c7a11ULL, 0x000fe200028f4448ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044507faeULL, 0x0003e2000e101c46ULL,
0x0000004f4c487210ULL, 0x000fe40007fbe0ffULL, 0x0000e00051517811ULL, 0x000fc400078e20ffULL,
0x0000e00055557811ULL, 0x000fe400078e20ffULL, 0x0000004f49447210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff497224ULL, 0x000fe200028e064dULL, 0x0000004f4a4a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff457224ULL, 0x000fe200020e064bULL, 0x0000000048517faeULL, 0x0003e2000c101c46ULL,
0x000000ffff4b7224ULL, 0x000fc600028e061cULL, 0x0000000044537faeULL, 0x0003e8000d901c46ULL,
0x000000004a557faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x000000011b1c7824ULL, 0x000fe200078e0229ULL, 0x0000002003447811ULL, 0x000fe400078e30ffULL,
0x000000f0214f7812ULL, 0x000fe200078ec0ffULL, 0x000000011c457824ULL, 0x040fe200078e0202ULL,
0x000000021c497810ULL, 0x040fe20007ffe0ffULL, 0x000000101c507824ULL, 0x040fe200078e00ffULL,
0x000000041c4a7810ULL, 0x000fc60007ffe0ffULL, 0x0000000149487824ULL, 0x040fe200078e0202ULL,
0xfffffff050507812ULL, 0x000fe200078ee245ULL, 0x0000001049517824ULL, 0x000fe400078e00ffULL,
0x000000011c457824ULL, 0x040fe200078e0244ULL, 0x000000061c1c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001444b7824ULL, 0x000fe200078e0249ULL, 0xfffffff051517812ULL, 0x000fe200078ee248ULL,
0x000000014a497824ULL, 0x000fe200078e0202ULL, 0x0000004745487210ULL, 0x080fe20007f7e0ffULL,
0x00000001444d7824ULL, 0x040fe200078e021cULL, 0x000000474b4b7210ULL, 0x080fe20007f1e0ffULL,
0x0000000144457824ULL, 0x000fe200078e024aULL, 0x00005e00484c7a11ULL, 0x000fe200078840ffULL,
0x000000104a527824ULL, 0x000fe200078e00ffULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000011c4a7824ULL, 0x040fe200078e0202ULL, 0x0000004745457210ULL, 0x080fe20007f5e0ffULL,
0x000000101c537824ULL, 0x000fe200078e00ffULL, 0xfffffff052527812ULL, 0x000fe200078ee249ULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x000000474d1c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200000e06ffULL, 0xfffffff053537812ULL, 0x000fe200078ee24aULL,
0x000000ffff477224ULL, 0x000fe200010e06ffULL, 0x00005f00484e7a11ULL, 0x000fe200020f4444ULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x00005e004b497a11ULL, 0x000fc400078040ffULL,
0x00005e001c4a7a11ULL, 0x000fe400078640ffULL, 0x00005e0045487a11ULL, 0x000fe400078440ffULL,
0x0000004f4c4c7210ULL, 0x000fe40007f9e0ffULL, 0x00005f004b4b7a11ULL, 0x000fe400000f444dULL,
0x00005f001c1c7a11ULL, 0x000fe200018f4444ULL, 0x000000ffff4d7224ULL, 0x000fe200020e064eULL,
0x00005f0045477a11ULL, 0x000fc400010f4447ULL, 0x0000004f49447210ULL, 0x080fe40007f1e0ffULL,
0x0000004f48487210ULL, 0x080fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c507faeULL, 0x0003e2000b901c46ULL, 0x0000004f4a4a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff457224ULL, 0x000fe200000e064bULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200010e0647ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e061cULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x0000000044517faeULL, 0x0003e8000b901c46ULL, 0x0000000048527faeULL, 0x0003e8000b901c46ULL,
0x000000004a537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000320447810ULL, 0x002fc80007ffe0ffULL, 0x000000194400720cULL, 0x000fe20003f06070ULL,
0xffffffffff1c7424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000011e447824ULL, 0x000fe400078e0244ULL, 0x00000004ff457424ULL, 0x000fc800078e00ffULL,
0x0000600044447625ULL, 0x000fca00078e0045ULL, 0x00000006441c7981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff667f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010648001b4a7f8cULL, 0x000664000c80043fULL,
0x0000000000447805ULL, 0x002fc40000015200ULL, 0x01064c001b477984ULL, 0x000e640000000800ULL,
0x8000000047ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004844487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e45ULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff477819ULL, 0x000fc80000011449ULL, 0x0000004847477211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x0000000247477819ULL, 0x000fc80000001248ULL,
0x000000470000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01064c001b477984ULL, 0x000e640000000800ULL, 0x8000000047ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101000022477984ULL, 0x000e680000000800ULL,
0x0103000022487984ULL, 0x0006a20000000800ULL, 0x000000464700720bULL, 0x002fe20003f1d000ULL,
0x0000dd127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000497806ULL, 0x008fc800000e0100ULL,
0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4a7424ULL, 0x000fc400078e00ffULL, 0x000000ffff647224ULL, 0x000fd200078e0046ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f05270ULL,
0x000000464700720bULL, 0x000fe20003f54000ULL, 0x0000dcd27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004a7806ULL, 0x000fc400010e0100ULL, 0x0000004746448209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0105004422008388ULL, 0x0003e40000000800ULL,
0x000099104a447816ULL, 0x002fc800000000ffULL, 0x000000ff4400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004746447209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff4aff7812ULL, 0x000fc6000780c0ffULL,
0x8000004446447221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b44447820ULL, 0x000fc80000410000ULL,
0x00000044004b7308ULL, 0x000e640000000800ULL, 0x0000004b1d1d7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff447819ULL, 0x000fe20000011602ULL,
0x0000dc027f007947ULL, 0x000fea000b800000ULL, 0x00001f444b447589ULL, 0x0002e400000e0000ULL,
0x0000004438387220ULL, 0x088fe20000410000ULL, 0x0000004439397220ULL, 0x080fe20000410000ULL,
0x0000004434347220ULL, 0x080fe20000410000ULL, 0x0000004435357220ULL, 0x080fe20000410000ULL,
0x0000004430307220ULL, 0x080fe20000410000ULL, 0x0000004431317220ULL, 0x080fe20000410000ULL,
0x0000004404047220ULL, 0x080fe20000410000ULL, 0x0000004405057220ULL, 0x080fe20000410000ULL,
0x0000004410107220ULL, 0x080fe20000410000ULL, 0x0000004411117220ULL, 0x080fe20000410000ULL,
0x000000440c0c7220ULL, 0x080fe20000410000ULL, 0x000000440d0d7220ULL, 0x080fe20000410000ULL,
0x0000004408087220ULL, 0x080fe20000410000ULL, 0x0000004409097220ULL, 0x080fe20000410000ULL,
0x0000004414147220ULL, 0x080fe20000410000ULL, 0x0000004415157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff004aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802447811ULL, 0x000fe200078ff0ffULL,
0x0000db027f007947ULL, 0x000fea000b800000ULL, 0x00001f444b447589ULL, 0x00066400000e0000ULL,
0x000000443a3a7220ULL, 0x082fe20000410000ULL, 0x000000443b3b7220ULL, 0x080fe20000410000ULL,
0x0000004436367220ULL, 0x080fe20000410000ULL, 0x0000004437377220ULL, 0x080fe20000410000ULL,
0x0000004432327220ULL, 0x080fe20000410000ULL, 0x0000004433337220ULL, 0x080fe20000410000ULL,
0x0000004406067220ULL, 0x080fe20000410000ULL, 0x0000004407077220ULL, 0x080fe20000410000ULL,
0x0000004412127220ULL, 0x080fe20000410000ULL, 0x0000004413137220ULL, 0x080fe20000410000ULL,
0x000000440e0e7220ULL, 0x080fe20000410000ULL, 0x000000440f0f7220ULL, 0x080fe20000410000ULL,
0x000000440a0a7220ULL, 0x080fe20000410000ULL, 0x000000440b0b7220ULL, 0x080fe20000410000ULL,
0x0000004416167220ULL, 0x080fe20000410000ULL, 0x0000004417177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff4aff7812ULL, 0x000fe20007800849ULL,
0x00000001ff4a7424ULL, 0x000fe200078e00ffULL, 0x0000004746467209ULL, 0x000fca0007810000ULL,
0x000000ffff647224ULL, 0x000fcc00078e0046ULL, 0x8000004647470221ULL, 0x100fe20000010000ULL,
0x000000ffff640224ULL, 0x000fe200078e0046ULL, 0x00007610ff4a0816ULL, 0x000fe4000000004aULL,
0x3fb8aa3b47470820ULL, 0x000fc80000410000ULL, 0x0000004700260308ULL, 0x000e640000000800ULL,
0x0000002648480220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001d481d7221ULL, 0x004fc20000010000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644487210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff467819ULL, 0x000fc80000011447ULL,
0x0000004846467211ULL, 0x000fca00078110ffULL, 0x000000ffff477224ULL, 0x000fca00000e0647ULL,
0x0000000246467819ULL, 0x000fc80000001247ULL, 0x000000460000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104a437816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff4300720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000026ff27723eULL, 0x000fe400000000ffULL, 0x00000002ff467819ULL, 0x000fe40000011602ULL,
0x0000541027437816ULL, 0x000fe20000000027ULL, 0x0000d6d27f007947ULL, 0x000fea000b800000ULL,
0x00001f4643277589ULL, 0x0002a400000e0000ULL, 0x0000000846287810ULL, 0x000fe20007ffe0ffULL,
0x0000d7027f007947ULL, 0x000fea000b800000ULL, 0x00001f2843287589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001046457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0043ULL, 0x0000b1b000447802ULL, 0x000fc40000000f00ULL,
0x0000df7000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001846457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e0043ULL,
0x0000b20000447802ULL, 0x000fc40000000f00ULL, 0x0000df2000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002a50783bULL, 0x000e680000004200ULL, 0x000000002b48783bULL, 0x008ee80000004200ULL,
0x000000002c4c783bULL, 0x004ea80000004200ULL, 0x000000002d44783bULL, 0x002e620000004200ULL,
0x00000018ff597819ULL, 0x000fe20000011453ULL, 0x0000010053617824ULL, 0x040fe200078e00ffULL,
0x0000888053607816ULL, 0x040fe200000000ffULL, 0x0001000053537824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011452ULL, 0x00000100525f7824ULL, 0x040fe200078e00ffULL,
0x00008880525e7816ULL, 0x040fe200000000ffULL, 0x0001000052527824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000006000627306ULL, 0x000fe20000200c00ULL,
0x00000018ff5d7819ULL, 0x008fe20000011449ULL, 0x0000010050557824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x00000100515a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fc40000011448ULL, 0x00000018ff6e7819ULL, 0x000fe2000001144aULL,
0x0000005300637306ULL, 0x0007e20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fe4000001144bULL,
0x00000018ff6c7819ULL, 0x004fe4000001144cULL, 0x00000018ff6d7819ULL, 0x000fe4000001144dULL,
0x00000018ff437819ULL, 0x000fe20000011450ULL, 0x0000005200607306ULL, 0x0005e20000200c00ULL,
0x0000010048537824ULL, 0x008fe200078e00ffULL, 0x0000888050547816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x0000888051577816ULL, 0x000fc400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000004300567306ULL, 0x0007e20000200c00ULL,
0x0000888048527816ULL, 0x044fe200000000ffULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000005200707306ULL, 0x0005e20000200c00ULL,
0x00000018ff437819ULL, 0x008fe20000011451ULL, 0x0001000051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000005300717306ULL, 0x0007e20000200c00ULL,
0x0000888049527816ULL, 0x044fe400000000ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000004800727306ULL, 0x0005e20000200c00ULL, 0x0000010049537824ULL, 0x048fe200078e00ffULL,
0x00000018ff697819ULL, 0x002fe20000011445ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fc40000011444ULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000005200737306ULL, 0x0003e20000200c00ULL,
0x000088804a487816ULL, 0x004fe400000000ffULL, 0x00000018ff657819ULL, 0x000fca0000011447ULL,
0x0000004900757306ULL, 0x0005e20000200c00ULL, 0x000088804d527816ULL, 0x002fce00000000ffULL,
0x0000004800767306ULL, 0x0003e20000200c00ULL, 0x000001004a497824ULL, 0x044fe400078e00ffULL,
0x000100004a4a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000088804b487816ULL, 0x002fce00000000ffULL, 0x0000004900777306ULL, 0x0003f00000200c00ULL,
0x0000004800797306ULL, 0x0005e20000200c00ULL, 0x000001004b497824ULL, 0x042fe400078e00ffULL,
0x000100004b4b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000004a00787306ULL, 0x000fe20000200c00ULL,
0x000088804c487816ULL, 0x004fce00000000ffULL, 0x00000049007a7306ULL, 0x0003f00000200c00ULL,
0x00000048007c7306ULL, 0x0005e20000200c00ULL, 0x000001004c497824ULL, 0x042fe400078e00ffULL,
0x000100004c4c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000004b007b7306ULL, 0x000fe20000200c00ULL, 0x0000b0002e487811ULL, 0x004fe400078e20ffULL,
0x00000018ff4c7819ULL, 0x000fca000001144cULL, 0x00000049007d7306ULL, 0x0003f00000200c00ULL,
0x0000004c007e7306ULL, 0x0005e20000200c00ULL, 0x000000004848783bULL, 0x002e6e0000000200ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x000000ffff4c7224ULL, 0x004fc400078e0052ULL,
0x000001004d527824ULL, 0x040fe400078e00ffULL, 0x000100004d4d7824ULL, 0x000fc600078e00ffULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff4d7819ULL, 0x000fca000001144dULL, 0x0000004d00817306ULL, 0x0005f00000200c00ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000001004e4d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000043005b7306ULL, 0x0005e20000200c00ULL,
0x000000274848a232ULL, 0x082fe40000000000ULL, 0x000000274a4aa232ULL, 0x000fe40000000000ULL,
0x000000284949a232ULL, 0x080fe40000000000ULL, 0x000000284b4ba232ULL, 0x000fe20000000000ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x00000018ff437819ULL, 0x004fce0000011446ULL,
0x0000005100517306ULL, 0x000eb00000200c00ULL, 0x0000004c007f7306ULL, 0x0007e20000200c00ULL,
0x0000541050507816ULL, 0x002fce0000000056ULL, 0x0000004d00837306ULL, 0x0003e20000200c00ULL,
0x000088804e4c7816ULL, 0x048fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x0000541051517816ULL, 0x004fc8000000005bULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004c00827306ULL, 0x0005e20000200c00ULL, 0x000001004f4d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000005200807306ULL, 0x0003e20000200c00ULL,
0x000088804f4c7816ULL, 0x004fce00000000ffULL, 0x0000004c00857306ULL, 0x0005e20000200c00ULL,
0x000100004f527824ULL, 0x002fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000004d00867306ULL, 0x0003e20000200c00ULL, 0x00005410544c7816ULL, 0x004fce0000000055ULL,
0x0000004e00847306ULL, 0x0005e20000200c00ULL, 0x00005410574d7816ULL, 0x002fce000000005aULL,
0x0000005300747306ULL, 0x000fe20000200c00ULL, 0x0000004c484c723cULL, 0x044bee0000001838ULL,
0x0000888044387816ULL, 0x060fe200000000ffULL, 0x0000005200877306ULL, 0x0003f00000200c00ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000504850723cULL, 0x002bee0000001834ULL,
0x000000ffff347224ULL, 0x020fe200078e0038ULL, 0x0000b0002f387811ULL, 0x000fe200078e20ffULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x0000010044357824ULL, 0x000fc400078e00ffULL,
0x0001000044447824ULL, 0x000fe400078e00ffULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000006100617306ULL, 0x000ee20000200c00ULL,
0x00000018ff447819ULL, 0x000fce0000011444ULL, 0x0000005800587306ULL, 0x000ee20000200c00ULL,
0x000054105e547816ULL, 0x002fce000000005fULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x0000541062557816ULL, 0x008fe40000000061ULL, 0x0000541079617816ULL, 0x000fca000000007aULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x0000541060587816ULL, 0x000fe20000000058ULL,
0x000000544854723cULL, 0x000b620000001830ULL, 0x0000541076607816ULL, 0x000fca0000000077ULL,
0x0000005d005d7306ULL, 0x000ee20000200c00ULL, 0x0000541063597816ULL, 0x002fe20000000059ULL,
0x0000010045317824ULL, 0x060fe200078e00ffULL, 0x0000888045307816ULL, 0x040fe200000000ffULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x000000604860723cULL, 0x040be20000001808ULL,
0x000000273838a232ULL, 0x084fe20000000000ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x00005410725c7816ULL, 0x008fe2000000005cULL,
0x000000273a3aa232ULL, 0x000fe20000000000ULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x00000100460a7824ULL, 0x060fe200078e00ffULL, 0x000000584804723cULL, 0x000b620000001804ULL,
0x0000888046087816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x00005410755d7816ULL, 0x000fe2000000005dULL,
0x000000283939a232ULL, 0x080fe20000000000ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x000000283b3ba232ULL, 0x000fe20000000000ULL, 0x0000541070587816ULL, 0x020fc40000000071ULL,
0x0000541073597816ULL, 0x000fe20000000074ULL, 0x0000005c485c723cULL, 0x000fe2000000180cULL,
0x00005410786e7816ULL, 0x002fe2000000006eULL, 0x0000004500097306ULL, 0x000fe20000200c00ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x000054107b6f7816ULL, 0x004fc6000000006fULL,
0x000000584858723cULL, 0x040f640000001810ULL, 0x0000000800457306ULL, 0x0003ec0000200c00ULL,
0x0000006e4848723cULL, 0x000b640000001814ULL, 0x0000003400887306ULL, 0x0005e20000200c00ULL,
0x0000888047087816ULL, 0x002fc800000000ffULL, 0x0000541082147816ULL, 0x020fc60000000083ULL,
0x0000000a006e7306ULL, 0x0003e20000200c00ULL, 0x000054107c347816ULL, 0x004fe4000000007dULL,
0x0000541085157816ULL, 0x000fca0000000086ULL, 0x0000003500897306ULL, 0x0004e20000200c00ULL,
0x00000100470a7824ULL, 0x042fe200078e00ffULL, 0x000000143814723cULL, 0x000f620000001854ULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x000054107f357816ULL, 0x004fe40000000080ULL,
0x00000018ff477819ULL, 0x000fca0000011447ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x000000343834723cULL, 0x000f62000000184cULL, 0x00005410880c7816ULL, 0x008fcc0000000089ULL,
0x0000006c006c7306ULL, 0x000ee20000200c00ULL, 0x0000541084107816ULL, 0x002fce000000006aULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x0000541087117816ULL, 0x004fce000000006bULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000103810723cULL, 0x000b6e0000001804ULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x0000541045047816ULL, 0x020fce000000006eULL,
0x00000030008a7306ULL, 0x0007f00000200c00ULL, 0x0000003100707306ULL, 0x0004a20000200c00ULL,
0x000054107e307816ULL, 0x008fe4000000006cULL, 0x0000541009097816ULL, 0x002fca0000000069ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x0000541081317816ULL, 0x004fce000000006dULL,
0x00000008004c7306ULL, 0x0003e20000200c00ULL, 0x000054108a0d7816ULL, 0x000fe20000000070ULL,
0x000000303830723cULL, 0x040b6c0000001850ULL, 0x0000000a004d7306ULL, 0x0004e20000200c00ULL,
0x0000541044087816ULL, 0x002fe20000000068ULL, 0x0000000c380c723cULL, 0x040b6c0000001858ULL,
0x0000004300437306ULL, 0x000fe40000200c00ULL, 0x000000083808723cULL, 0x004b6c000000185cULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000054104c057816ULL, 0x008fce000000004dULL,
0x0000004600467306ULL, 0x000e620000200c00ULL, 0x000000043804723cULL, 0x000b6e0000001860ULL,
0x0000004700477306ULL, 0x000ea20000200c00ULL, 0x0000541046467816ULL, 0x002fe40000000043ULL,
0x0000541047477816ULL, 0x004fce0000000065ULL, 0x000000463838723cULL, 0x000b620000001848ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff487f8cULL, 0x020e62000c80043fULL,
0x000000ffff4a7224ULL, 0x000fce00078e00ffULL, 0x0000000000447805ULL, 0x000fc40000015200ULL,
0x0106bc00ff437984ULL, 0x000ea40000000800ULL, 0x8000000043ff7812ULL, 0x006fe40007804849ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004644467210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e45ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff437819ULL, 0x000fc80000011447ULL, 0x0000004643437211ULL, 0x000fca00078110ffULL,
0x000000ffff467224ULL, 0x000fca00000e0647ULL, 0x0000000243437819ULL, 0x000fc80000001246ULL,
0x000000430000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000058001c547a24ULL, 0x010fc800078e02ffULL,
0x0000004054547824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000803c437810ULL, 0x000fe20007ffe0ffULL, 0x000000011b457824ULL, 0x000fe200078e0229ULL,
0x00000002294f7810ULL, 0x000fe40007ffe0ffULL, 0x0000004318447217ULL, 0x000fe20007800000ULL,
0x00000040034c7824ULL, 0x000fe200078e0245ULL, 0x0000000429517810ULL, 0x000fe20007ffe0ffULL,
0x0000000145467824ULL, 0x000fe200078e0202ULL, 0x000000f0214d7812ULL, 0x000fe200078ec0ffULL,
0x00000010454e7824ULL, 0x000fe200078e00ffULL, 0x000000544c497210ULL, 0x040fe20007f1e0ffULL,
0x000000011b457824ULL, 0x040fe200078e024fULL, 0x000000024c4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000144447824ULL, 0x000fe200078e0a43ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee246ULL,
0x000000011b437824ULL, 0x000fe200078e0251ULL, 0x000000044c4a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000145467824ULL, 0x100fe200078e0202ULL, 0x000000441b447217ULL, 0x000fe20007800000ULL,
0x0000001045507824ULL, 0x000fe200078e00ffULL, 0x000000544a4a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000143457824ULL, 0x040fe200078e0202ULL, 0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL,
0x0000001043527824ULL, 0x000fe200078e00ffULL, 0xfffffff050507812ULL, 0x000fe200078ee246ULL,
0x000000ffff437224ULL, 0x000fe200000e06ffULL, 0x00005e0049477a11ULL, 0x000fc400078040ffULL,
0xfffffff052527812ULL, 0x000fe200078ee245ULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0x00005f0049497a11ULL, 0x000fe200000f4443ULL, 0x0000000144437824ULL, 0x000fe200078e0a1bULL,
0x000000544b4b7210ULL, 0x000fe40007f1e0ffULL, 0x00005e004a467a11ULL, 0x000fe400078a40ffULL,
0x000000432900720cULL, 0x000fe20003f86070ULL, 0x000000ffff447224ULL, 0x000fe200000e06ffULL,
0x00005e004b487a11ULL, 0x000fc400078040ffULL, 0x00005f004a4a7a11ULL, 0x000fe400028f4445ULL,
0x00005f004b4b7a11ULL, 0x000fe400000f4444ULL, 0x0000004d47447210ULL, 0x000fe40007f7e0ffULL,
0x000000434f00720cULL, 0x000fe40003f06070ULL, 0x00000006294f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff457224ULL, 0x000fe200018e0649ULL, 0x000000064c477810ULL, 0x000fc40007ffe0ffULL,
0x000000435100720cULL, 0x000fe20003f66070ULL, 0x000000011b497824ULL, 0x000fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000444e7faeULL, 0x0003e2000e101c46ULL,
0x0000005447477210ULL, 0x000fe40007f9e0ffULL, 0x00000001494c7824ULL, 0x000fe200078e0202ULL,
0x0000004d46467210ULL, 0x000fe40007fde0ffULL, 0x0000c00050507811ULL, 0x000fe400078e20ffULL,
0x0000c00052527811ULL, 0x000fc400078e20ffULL, 0x0000004d48447210ULL, 0x002fe20007fbe0ffULL,
0x00000010494e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff497224ULL, 0x000fe200020e06ffULL,
0x00005e0047487a11ULL, 0x000fe200078840ffULL, 0x000000ffff457224ULL, 0x000fe200028e064bULL,
0x000000434f00720cULL, 0x000fe40003fa6070ULL, 0x00005f0047437a11ULL, 0x000fe200020f4449ULL,
0x000000ffff477224ULL, 0x000fe200030e064aULL, 0x0000004d48487210ULL, 0x000fe20007f9e0ffULL,
0x0000000044507faeULL, 0x0003e2000c101c46ULL, 0xfffffff04e4c7812ULL, 0x000fc600078ee24cULL,
0x000000ffff497224ULL, 0x000fe200020e0643ULL, 0x0000c0004c4c7811ULL, 0x000fe200078e20ffULL,
0x0000000046527faeULL, 0x0003e8000d901c46ULL, 0x00000000484c7faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x000000011b437824ULL, 0x000fe200078e0229ULL,
0x000000f0214a7812ULL, 0x000fc600078ec0ffULL, 0x0000000143447824ULL, 0x040fe200078e0202ULL,
0x0000000243457810ULL, 0x040fe20007ffe0ffULL, 0x0000001043477824ULL, 0x000fc800078e00ffULL,
0x0000000145467824ULL, 0x000fe200078e0202ULL, 0xfffffff047477812ULL, 0x000fe200078ee244ULL,
0x00000010454b7824ULL, 0x000fe200078e00ffULL, 0x0000000443457810ULL, 0x000fe20007ffe0ffULL,
0x0000004003447824ULL, 0x000fe200078e0243ULL, 0x0000c00047477811ULL, 0x000fe400078e20ffULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee246ULL, 0x0000000145487824ULL, 0x000fe200078e0202ULL,
0x0000000643467810ULL, 0x000fe20007ffe0ffULL, 0x00000010454f7824ULL, 0x000fe200078e00ffULL,
0x0000005444437210ULL, 0x000fc60007f1e0ffULL, 0x0000000146497824ULL, 0x040fe200078e0202ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee248ULL, 0x0000001046537824ULL, 0x000fe200078e00ffULL,
0x0000000244487810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff457224ULL, 0x000fe200000e06ffULL,
0x00005e0043467a11ULL, 0x000fe400078040ffULL, 0xfffffff053537812ULL, 0x000fe400078ee249ULL,
0x00005f0043457a11ULL, 0x000fe400000f4445ULL, 0x0000000444437810ULL, 0x000fc40007ffe0ffULL,
0x0000000644447810ULL, 0x000fe40007ffe0ffULL, 0x00000054434c7210ULL, 0x080fe40007f7e0ffULL,
0x0000005448487210ULL, 0x080fe40007f1e0ffULL, 0x0000005444507210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200018e06ffULL, 0x0000004a46447210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e06ffULL, 0x00005e0048497a11ULL, 0x000fe200078040ffULL,
0x000000ffff517224ULL, 0x000fe200028e06ffULL, 0x00005e004c4e7a11ULL, 0x000fe200078840ffULL,
0x000000ffff457224ULL, 0x000fe200018e0645ULL, 0x00005e0050527a11ULL, 0x000fc400078a40ffULL,
0x00005f0048437a11ULL, 0x000fe400000f4443ULL, 0x0000004a49467210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044477faeULL, 0x0003e2000b901c46ULL,
0x00005f004c4d7a11ULL, 0x000fe400020f444dULL, 0x0000004a4e487210ULL, 0x080fe40007f7e0ffULL,
0x00005f0050517a11ULL, 0x000fe400028f4451ULL, 0x0000004a524a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff497224ULL, 0x000fe200018e064dULL, 0x0000c0004f4f7811ULL, 0x000fc400078e20ffULL,
0x0000c00053537811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x002fe200000e0643ULL,
0x0000c0004b447811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fc800020e0651ULL,
0x0000000046447faeULL, 0x0003e8000b901c46ULL, 0x00000000484f7faeULL, 0x0003e8000b901c46ULL,
0x000000004a537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff447f8cULL, 0x002e64000c80043fULL,
0x000000ffff437224ULL, 0x002fc400078e0045ULL, 0x0000000000447805ULL, 0x000fca0000015200ULL,
0x0106b400ff467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fc40007804867ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644487210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff467819ULL, 0x000fc80000011447ULL,
0x0000004846467211ULL, 0x000fca00078110ffULL, 0x000000ffff477224ULL, 0x000fca00000e0647ULL,
0x0000000246467819ULL, 0x000fc80000001247ULL, 0x000000460000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000026ff27723eULL, 0x000fe400000000ffULL, 0x00000002ff477819ULL, 0x000fe40000011602ULL,
0x0000541027467816ULL, 0x000fe20000000027ULL, 0x0000bab27f007947ULL, 0x000fea000b800000ULL,
0x00001f4746277589ULL, 0x0002a400000e0000ULL, 0x0000000847287810ULL, 0x000fe20007ffe0ffULL,
0x0000bae27f007947ULL, 0x000fea000b800000ULL, 0x00001f2846287589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001047457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0046ULL, 0x0000ce9000447802ULL, 0x000fc40000000f00ULL,
0x0000c29000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001847457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x004fe200078e0046ULL,
0x0000cee000447802ULL, 0x000fc40000000f00ULL, 0x0000c24000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003f48783bULL, 0x000f280000004200ULL, 0x000000004050783bULL, 0x000ee80000004200ULL,
0x000000003d4c783bULL, 0x004ea20000004200ULL, 0x00000018ff447819ULL, 0x010fe20000011448ULL,
0x0000010048657824ULL, 0x040fe200078e00ffULL, 0x0000888048637816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x0000888049687816ULL, 0x000fe200000000ffULL,
0x0000004400667306ULL, 0x0009e20000200c00ULL, 0x00000018ff617819ULL, 0x000fc4000001144aULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff627819ULL, 0x000fe4000001144bULL,
0x00000018ff5d7819ULL, 0x008fe20000011452ULL, 0x0000004800677306ULL, 0x0006620000200c00ULL,
0x00000018ff447819ULL, 0x010fe40000011449ULL, 0x00000018ff5b7819ULL, 0x004fe4000001144cULL,
0x00000018ff5c7819ULL, 0x000fc4000001144dULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x00000044006a7306ULL, 0x0005e20000200c00ULL, 0x000000ffff487224ULL, 0x008fe200078e0068ULL,
0x00000018ff5f7819ULL, 0x000fe20000011450ULL, 0x0000010049687824ULL, 0x040fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011451ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe4000001144eULL, 0x0000004800697306ULL, 0x0007e20000200c00ULL,
0x000000003e44783bULL, 0x006e620000004200ULL, 0x00000018ff497819ULL, 0x000fc40000011449ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff5a7819ULL, 0x000fe4000001144fULL,
0x00000049006b7306ULL, 0x0005220000200c00ULL, 0x000088804a487816ULL, 0x008fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe40000011453ULL, 0x0000541067667816ULL, 0x000fc60000000066ULL,
0x00000048006c7306ULL, 0x0007e20000200c00ULL, 0x000001004a497824ULL, 0x044fe400078e00ffULL,
0x000100004a4a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000088804b487816ULL, 0x008fe400000000ffULL, 0x000054106b677816ULL, 0x010fca000000006aULL,
0x00000049006d7306ULL, 0x0005f00000200c00ULL, 0x00000048006f7306ULL, 0x0007e20000200c00ULL,
0x000001004b497824ULL, 0x044fe200078e00ffULL, 0x00000018ff577819ULL, 0x002fe20000011444ULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011445ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000004a006e7306ULL, 0x000fe20000200c00ULL, 0x0000888050487816ULL, 0x008fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011446ULL, 0x00000018ff567819ULL, 0x000fc60000011447ULL,
0x0000004900707306ULL, 0x0003f00000200c00ULL, 0x0000004800727306ULL, 0x0005e20000200c00ULL,
0x0000010050497824ULL, 0x042fe400078e00ffULL, 0x0001000050507824ULL, 0x000fc600078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000004b00717306ULL, 0x000fe20000200c00ULL,
0x0000888051487816ULL, 0x004fe400000000ffULL, 0x00000018ff507819ULL, 0x000fca0000011450ULL,
0x0000004900737306ULL, 0x0002b00000200c00ULL, 0x0000004800747306ULL, 0x0007e20000200c00ULL,
0x0000010051497824ULL, 0x042fe400078e00ffULL, 0x0001000051517824ULL, 0x000fc600078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000888052487816ULL, 0x008fe400000000ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000541072727816ULL, 0x004fc60000000073ULL, 0x0000004900757306ULL, 0x0002b00000200c00ULL,
0x0000004800767306ULL, 0x0007e20000200c00ULL, 0x0000010052497824ULL, 0x042fe400078e00ffULL,
0x0001000052527824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x0000888053487816ULL, 0x008fe400000000ffULL, 0x0000541074737816ULL, 0x004fca0000000075ULL,
0x0000004900777306ULL, 0x0005f00000200c00ULL, 0x0000004800797306ULL, 0x0007e20000200c00ULL,
0x0000010053497824ULL, 0x044fe400078e00ffULL, 0x0001000053537824ULL, 0x000fc600078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000005200787306ULL, 0x0005e20000200c00ULL,
0x000088804c487816ULL, 0x008fe400000000ffULL, 0x00000018ff537819ULL, 0x000fca0000011453ULL,
0x00000049007a7306ULL, 0x0007e20000200c00ULL, 0x000088804d527816ULL, 0x004fce00000000ffULL,
0x00000048007c7306ULL, 0x0005e20000200c00ULL, 0x000001004c497824ULL, 0x048fe400078e00ffULL,
0x000100004c4c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x0000b00041487811ULL, 0x004fce00078e20ffULL, 0x00000049007d7306ULL, 0x0005f00000200c00ULL,
0x0000004c007e7306ULL, 0x0007e20000200c00ULL, 0x000000004848783bULL, 0x004eae0000000200ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000000ffff4c7224ULL, 0x008fc400078e0052ULL,
0x000001004d527824ULL, 0x040fe400078e00ffULL, 0x000100004d4d7824ULL, 0x000fc600078e00ffULL,
0x0000004c007f7306ULL, 0x0007e20000200c00ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff4d7819ULL, 0x000fca000001144dULL, 0x0000004d00817306ULL, 0x0009e20000200c00ULL,
0x000088804e4c7816ULL, 0x008fce00000000ffULL, 0x0000004c00827306ULL, 0x0007e20000200c00ULL,
0x000001004e4d7824ULL, 0x050fe400078e00ffULL, 0x000100004e4e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000005200807306ULL, 0x0009e20000200c00ULL,
0x000088804f4c7816ULL, 0x008fe200000000ffULL, 0x000000274848a232ULL, 0x084fe20000000000ULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x000000274a4aa232ULL, 0x000fe40000000000ULL,
0x000000284949a232ULL, 0x080fe40000000000ULL, 0x0000004d00837306ULL, 0x0005e20000200c00ULL,
0x000000284b4ba232ULL, 0x000fe20000000000ULL, 0x0000b00042527811ULL, 0x010fcc00078e20ffULL,
0x0000004c00857306ULL, 0x0007e20000200c00ULL, 0x000001004f4d7824ULL, 0x044fe200078e00ffULL,
0x000000664830723cULL, 0x000fe20000001830ULL, 0x000100004f4f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x00005410634c7816ULL, 0x008fe20000000065ULL,
0x00000072480c723cULL, 0x000fec000000180cULL, 0x0000004d00867306ULL, 0x0003f00000200c00ULL,
0x0000005100517306ULL, 0x000ee20000200c00ULL, 0x00005410694d7816ULL, 0x002fc40000000068ULL,
0x0000541050507816ULL, 0x004fca000000005fULL, 0x0000004c4834723cULL, 0x000b620000001834ULL,
0x0000004e00847306ULL, 0x000fec0000200c00ULL, 0x00008880444d7816ULL, 0x020fe400000000ffULL,
0x000054106c4c7816ULL, 0x000fe2000000006dULL, 0x0000004f00637306ULL, 0x000fe20000200c00ULL,
0x0000541051517816ULL, 0x008fce0000000060ULL, 0x0000004d00657306ULL, 0x0003e20000200c00ULL,
0x000000504808723cULL, 0x000bee0000001808ULL, 0x00000053007b7306ULL, 0x0005e20000200c00ULL,
0x000054106f4d7816ULL, 0x002fe40000000070ULL, 0x0000541076507816ULL, 0x020fc40000000077ULL,
0x0000541079517816ULL, 0x000fc6000000007aULL, 0x0000004c484c723cULL, 0x000be20000001814ULL,
0x0000010044537824ULL, 0x044fe200078e00ffULL, 0x000000005214783bULL, 0x0202a20000000200ULL,
0x0000006100617306ULL, 0x000ee20000200c00ULL, 0x0001000044447824ULL, 0x000fe400078e00ffULL,
0x00000018ff537819ULL, 0x000fc60000011453ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000006200627306ULL, 0x000f220000200c00ULL, 0x0000888045527816ULL, 0x002fce00000000ffULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x000054106e6e7816ULL, 0x008fce0000000061ULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x00005410716f7816ULL, 0x010fce0000000062ULL,
0x0000005300667306ULL, 0x0009e20000200c00ULL, 0x0000541078787816ULL, 0x002fe2000000005dULL,
0x0000006e4810723cULL, 0x000f620000001810ULL, 0x000000271414a232ULL, 0x004fca0000000000ULL,
0x0000005200617306ULL, 0x000fe20000200c00ULL, 0x0000010045537824ULL, 0x010fe200078e00ffULL,
0x000054107b797816ULL, 0x008fe2000000005eULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x000000271616a232ULL, 0x000fe40000000000ULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x000000281515a232ULL, 0x080fe20000000000ULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x000000281717a232ULL, 0x000fe20000000000ULL, 0x00000018ff457819ULL, 0x000fcc0000011445ULL,
0x0000005300627306ULL, 0x0005f00000200c00ULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x000000504850723cULL, 0x044b6e0000001804ULL, 0x0000010046057824ULL, 0x060fe200078e00ffULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000000784848723cULL, 0x000b620000001838ULL,
0x0000888046047816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff057819ULL, 0x000fc80000011405ULL, 0x00000005005e7306ULL, 0x0005e20000200c00ULL,
0x000054107c387816ULL, 0x020fe4000000007dULL, 0x000054107f397816ULL, 0x000fe40000000080ULL,
0x00000018ff467819ULL, 0x000fc60000011446ULL, 0x00000004005d7306ULL, 0x0009e20000200c00ULL,
0x0000010047057824ULL, 0x044fe200078e00ffULL, 0x000000381438723cULL, 0x000b680000001834ULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x0000888047047816ULL, 0x050fe200000000ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x000054107e347816ULL, 0x022fc8000000005bULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x00000004005f7306ULL, 0x0007f00000200c00ULL, 0x00000005005b7306ULL, 0x0003e20000200c00ULL,
0x0000541084047816ULL, 0x008fc40000000059ULL, 0x0000541081357816ULL, 0x004fca000000005cULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000541063057816ULL, 0x002fe2000000005aULL,
0x000000341434723cULL, 0x040b6c0000001830ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x0000541082307816ULL, 0x020fe20000000083ULL, 0x000000041404723cULL, 0x000b620000001810ULL,
0x0000541085317816ULL, 0x000fca0000000086ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x0000541065107816ULL, 0x020fe20000000066ULL, 0x000000301430723cULL, 0x000f62000000184cULL,
0x0000541061117816ULL, 0x000fca0000000062ULL, 0x0000004500457306ULL, 0x000ea40000200c00ULL,
0x000000101410723cULL, 0x000b6c000000180cULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00005410440c7816ULL, 0x022fce0000000057ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00005410450d7816ULL, 0x004fce0000000058ULL, 0x0000004600467306ULL, 0x000e620000200c00ULL,
0x0000000c140c723cULL, 0x000b6e0000001808ULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x000054105d087816ULL, 0x020fe4000000005eULL, 0x000054105f097816ULL, 0x000fc4000000005bULL,
0x0000541046467816ULL, 0x002fca0000000055ULL, 0x000000081408723cULL, 0x000b620000001850ULL,
0x0000541047477816ULL, 0x004fce0000000056ULL, 0x000000461414723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000803c447810ULL, 0x002fe20007ffe0ffULL, 0x01069800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4a7224ULL, 0x020fe200078e0045ULL, 0x0000000320557810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff467224ULL, 0x000fe200078e0064ULL, 0x000000184400720cULL, 0x000fda0003f06070ULL,
0x000042b000000947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fc40000015200ULL,
0x0106bc00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc80000011447ULL,
0x000000461c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x000000021c1c7819ULL, 0x000fc80000001246ULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000a03c1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000011b457824ULL, 0x000fe200078e0229ULL, 0x0000000229477810ULL, 0x000fe40007ffe0ffULL,
0x0000001c18447217ULL, 0x000fe20007800000ULL, 0x0000000145467824ULL, 0x000fe200078e0202ULL,
0x00000004294a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010454f7824ULL, 0x000fe200078e00ffULL,
0x0000000629527810ULL, 0x000fe20007ffe0ffULL, 0x0000000144447824ULL, 0x000fe200078e0a1cULL,
0x00000020031c7811ULL, 0x000fe200078e30ffULL, 0x000000011b487824ULL, 0x000fe200078e0247ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL, 0x000000011b497824ULL, 0x040fe200078e024aULL,
0x000000441b447217ULL, 0x000fe20007800000ULL, 0x00000001454d7824ULL, 0x000fe200078e021cULL,
0x000000f0214e7812ULL, 0x000fe200078ec0ffULL, 0x000000011b457824ULL, 0x000fe200078e0252ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000001484c7824ULL, 0x000fe200078e021cULL,
0x000000544d4d7210ULL, 0x000fe20007f1e0ffULL, 0x00000001494b7824ULL, 0x000fc400078e0202ULL,
0x0000001049517824ULL, 0x000fe200078e00ffULL, 0x000000544c4c7210ULL, 0x080fe20007f3e0ffULL,
0x0000000148467824ULL, 0x040fe400078e0202ULL, 0x0000001048507824ULL, 0x000fe200078e00ffULL,
0xfffffff051517812ULL, 0x000fe200078ee24bULL, 0x0000000149497824ULL, 0x100fe200078e021cULL,
0x00005e004c4b7a11ULL, 0x000fe200078440ffULL, 0x00000001451c7824ULL, 0x040fe200078e021cULL,
0xfffffff050507812ULL, 0x000fe200078ee246ULL, 0x0000000145467824ULL, 0x000fe200078e0202ULL,
0x0000005449497210ULL, 0x080fe20007f9e0ffULL, 0x0000001045537824ULL, 0x000fe200078e00ffULL,
0x000000541c547210ULL, 0x000fe20007f7e0ffULL, 0x00000001441c7824ULL, 0x000fe200078e0a1bULL,
0x0000e00050507811ULL, 0x000fe200078e20ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0xfffffff053537812ULL, 0x000fe200078ee246ULL, 0x000000ffff467224ULL, 0x000fe200000e06ffULL,
0x00005e004d457a11ULL, 0x000fc400078040ffULL, 0x00005f004c4c7a11ULL, 0x000fe400010f4444ULL,
0x0000001c2900720cULL, 0x000fe40003f46070ULL, 0x00005f004d4d7a11ULL, 0x000fe200000f4446ULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x0000004e45447210ULL, 0x000fe40007fbe0ffULL,
0x0000001c4a00720cULL, 0x080fe20003f06070ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x0000001c4700720cULL, 0x000fe20003f26070ULL, 0x000000ffff457224ULL, 0x000fe200028e064dULL,
0x00005e0049477a11ULL, 0x000fc400078840ffULL, 0x00005e0054487a11ULL, 0x000fe400078c40ffULL,
0x0000001c5200720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000444f7faeULL, 0x0003e2000d101c46ULL, 0x00005f0049497a11ULL, 0x000fe400020f444aULL,
0x00005f00541c7a11ULL, 0x000fe400030f4446ULL, 0x0000004e47467210ULL, 0x080fe40007f9e0ffULL,
0x0000004e48487210ULL, 0x000fc40007fbe0ffULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200020e0649ULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200028e061cULL, 0x0000004e4b447210ULL, 0x002fca0007f5e0ffULL,
0x000000ffff457224ULL, 0x000fca00010e064cULL, 0x0000000044507faeULL, 0x0003e8000c901c46ULL,
0x0000000046517faeULL, 0x0003e8000c101c46ULL, 0x0000000048537faeULL, 0x0003e2000d901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x000000011b1c7824ULL, 0x000fe200078e0229ULL,
0x0000002003447811ULL, 0x000fc400078e30ffULL, 0x000000f0214e7812ULL, 0x000fe200078ec0ffULL,
0x000000011c457824ULL, 0x040fe200078e0202ULL, 0x000000021c467810ULL, 0x040fe20007ffe0ffULL,
0x000000101c4f7824ULL, 0x040fe200078e00ffULL, 0x000000061c487810ULL, 0x000fc60007ffe0ffULL,
0x0000000146477824ULL, 0x040fe200078e0202ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee245ULL,
0x0000001046507824ULL, 0x000fe400078e00ffULL, 0x000000011c457824ULL, 0x000fe200078e0244ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000001444c7824ULL, 0x000fe200078e0246ULL,
0xfffffff050507812ULL, 0x000fe200078ee247ULL, 0x0000000144497824ULL, 0x000fe200078e0248ULL,
0x000000041c477810ULL, 0x000fe20007ffe0ffULL, 0x00000001484b7824ULL, 0x140fe200078e0202ULL,
0x0000005445457210ULL, 0x080fe20007f5e0ffULL, 0x0000001048527824ULL, 0x000fe200078e00ffULL,
0x000000544c4c7210ULL, 0x080fe20007f1e0ffULL, 0x00000001441c7824ULL, 0x000fe200078e0247ULL,
0x00005e00454a7a11ULL, 0x000fe200078640ffULL, 0x0000000147467824ULL, 0x040fe200078e0202ULL,
0xfffffff052527812ULL, 0x000fe200078ee24bULL, 0x0000001047517824ULL, 0x000fe200078e00ffULL,
0x000000541c477210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x00000054491c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200000e06ffULL,
0xfffffff051517812ULL, 0x000fc400078ee246ULL, 0x00005f00454d7a11ULL, 0x000fe200018f4444ULL,
0x000000ffff447224ULL, 0x000fe200010e06ffULL, 0x00005e004c497a11ULL, 0x000fe200078040ffULL,
0x000000ffff457224ULL, 0x000fe200008e06ffULL, 0x00005e001c487a11ULL, 0x000fe400078440ffULL,
0x00005e0047467a11ULL, 0x000fe400078240ffULL, 0x0000004e4a4a7210ULL, 0x000fe40007f7e0ffULL,
0x00005f004c4c7a11ULL, 0x000fc400000f444bULL, 0x00005f001c1c7a11ULL, 0x000fe200010f4444ULL,
0x000000ffff4b7224ULL, 0x000fe200018e064dULL, 0x00005f0047477a11ULL, 0x000fe400008f4445ULL,
0x0000004e49447210ULL, 0x080fe40007f1e0ffULL, 0x0000004e46467210ULL, 0x080fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004a4f7faeULL, 0x0003e2000b901c46ULL,
0x0000004e48487210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e064cULL,
0x0000e00050507811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200008e0647ULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200010e061cULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x0000000044507faeULL, 0x0003e8000b901c46ULL,
0x0000000046517faeULL, 0x0003e8000b901c46ULL, 0x0000000048527faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000420447810ULL, 0x002fc80007ffe0ffULL,
0x000000194400720cULL, 0x000fe20003f06070ULL, 0xffffffffff1c7424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000011e447824ULL, 0x000fe400078e0244ULL,
0x00000004ff457424ULL, 0x000fc800078e00ffULL, 0x0000600044447625ULL, 0x000fca00078e0045ULL,
0x00000006441c7981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4c7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010668001b487f8cULL, 0x000664000c80043fULL, 0x0000000000447805ULL, 0x002fc40000015200ULL,
0x01066c001b467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x00000046444a7210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff467819ULL, 0x000fc80000011447ULL,
0x0000004a46467211ULL, 0x000fca00078110ffULL, 0x000000ffff477224ULL, 0x000fca00000e0647ULL,
0x0000000246467819ULL, 0x000fc80000001247ULL, 0x000000460000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01066c001b467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101800022477984ULL, 0x000e680000000800ULL, 0x0103800022487984ULL, 0x0006a20000000800ULL,
0x000000644700720bULL, 0x002fe20003f1d000ULL, 0x00009d127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000497806ULL, 0x008fc800000e0100ULL, 0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff467224ULL, 0x000fd200078e0064ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f05270ULL, 0x000000644700720bULL, 0x000fe20003f34000ULL,
0x00009cd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000237806ULL, 0x000fc400008e0100ULL,
0x0000006447448209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0105804422008388ULL, 0x0003e40000000800ULL, 0x0000991023227816ULL, 0x002fc800000000ffULL,
0x000000ff2200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000006447227209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff23ff7812ULL, 0x000fc6000780c0ffULL, 0x0000006422227221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b22227820ULL, 0x000fc80000410000ULL, 0x0000002200467308ULL, 0x000e640000000800ULL,
0x000000461d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff227819ULL, 0x000fe20000011602ULL, 0x00009c127f007947ULL, 0x000fea000b800000ULL,
0x00001f2246227589ULL, 0x0002e400000e0000ULL, 0x0000002238387220ULL, 0x088fe20000410000ULL,
0x0000002239397220ULL, 0x080fe20000410000ULL, 0x0000002234347220ULL, 0x080fe20000410000ULL,
0x0000002235357220ULL, 0x080fe20000410000ULL, 0x0000002230307220ULL, 0x080fe20000410000ULL,
0x0000002231317220ULL, 0x080fe20000410000ULL, 0x0000002204047220ULL, 0x080fe20000410000ULL,
0x0000002205057220ULL, 0x080fe20000410000ULL, 0x0000002210107220ULL, 0x080fe20000410000ULL,
0x0000002211117220ULL, 0x080fe20000410000ULL, 0x000000220c0c7220ULL, 0x080fe20000410000ULL,
0x000000220d0d7220ULL, 0x080fe20000410000ULL, 0x0000002208087220ULL, 0x080fe20000410000ULL,
0x0000002209097220ULL, 0x080fe20000410000ULL, 0x0000002214147220ULL, 0x080fe20000410000ULL,
0x0000002215157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0023ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802227811ULL, 0x000fe200078ff0ffULL, 0x00009b127f007947ULL, 0x000fea000b800000ULL,
0x00001f2246227589ULL, 0x00066400000e0000ULL, 0x000000223a3a7220ULL, 0x082fe20000410000ULL,
0x000000223b3b7220ULL, 0x080fe20000410000ULL, 0x0000002236367220ULL, 0x080fe20000410000ULL,
0x0000002237377220ULL, 0x080fe20000410000ULL, 0x0000002232327220ULL, 0x080fe20000410000ULL,
0x0000002233337220ULL, 0x080fe20000410000ULL, 0x0000002206067220ULL, 0x080fe20000410000ULL,
0x0000002207077220ULL, 0x080fe20000410000ULL, 0x0000002212127220ULL, 0x080fe20000410000ULL,
0x0000002213137220ULL, 0x080fe20000410000ULL, 0x000000220e0e7220ULL, 0x080fe20000410000ULL,
0x000000220f0f7220ULL, 0x080fe20000410000ULL, 0x000000220a0a7220ULL, 0x080fe20000410000ULL,
0x000000220b0b7220ULL, 0x080fe20000410000ULL, 0x0000002216167220ULL, 0x080fe20000410000ULL,
0x0000002217177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff23ff7812ULL, 0x000fe20007800849ULL, 0x00000001ff4a7424ULL, 0x000fe200078e00ffULL,
0x0000006447647209ULL, 0x000fca0007810000ULL, 0x000000ffff467224ULL, 0x00afcc00078e0064ULL,
0x8000006447470221ULL, 0x100fe20000010000ULL, 0x000000ffff460224ULL, 0x000fe200078e0064ULL,
0x00007610ff4a0816ULL, 0x000fe4000000004aULL, 0x3fb8aa3b47470820ULL, 0x000fc80000410000ULL,
0x0000004700260308ULL, 0x000e640000000800ULL, 0x0000002648480220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001d481d7221ULL, 0x004fc20000010000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff447984ULL, 0x000e640000000800ULL,
0x8000000044ff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004422477210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e23ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff447819ULL, 0x000fc80000011445ULL, 0x0000004744447211ULL, 0x000fca00078110ffULL,
0x000000ffff457224ULL, 0x000fca00000e0645ULL, 0x0000000244447819ULL, 0x000fc80000001245ULL,
0x000000440000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff447984ULL, 0x000e640000000800ULL, 0x8000000044ff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104a227816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2200720cULL, 0x000fda0003f25270ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000026ff22723eULL, 0x000fe400000000ffULL,
0x00000002ff237819ULL, 0x000fe40000011602ULL, 0x0000541022227816ULL, 0x000fe20000000022ULL,
0x000096e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2322277589ULL, 0x0002a400000e0000ULL,
0x0000000823287810ULL, 0x000fe20007ffe0ffULL, 0x000097127f007947ULL, 0x000fea000b800000ULL,
0x00001f2822287589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001023457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0022ULL,
0x0000f48000447802ULL, 0x000fc40000000f00ULL, 0x00009ca000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001823457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x004fe200078e0022ULL, 0x0000f4d000447802ULL, 0x000fc40000000f00ULL,
0x00009c5000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002a50783bULL, 0x000ee20000004200ULL,
0x0000b8002e2e7811ULL, 0x000fc400078e20ffULL, 0x0000b8002f2f7811ULL, 0x000fe200078e20ffULL,
0x000000002b58783bULL, 0x000ea80000004200ULL, 0x000000002c54783bULL, 0x000e680000004200ULL,
0x000000002d48783bULL, 0x0006640000004200ULL, 0x00000018ff227819ULL, 0x00afe20000011450ULL,
0x0000010051607824ULL, 0x040fe200078e00ffULL, 0x00008880515f7816ULL, 0x000fe200000000ffULL,
0x00000100502d7824ULL, 0x040fe200078e00ffULL, 0x00000022005e7306ULL, 0x0003e20000200c00ULL,
0x00008880502c7816ULL, 0x040fe200000000ffULL, 0x0001000050507824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc40000011460ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000005f00617306ULL, 0x000fe20000200c00ULL,
0x00000018ff227819ULL, 0x002fe20000011451ULL, 0x0001000051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x004fe4000001145aULL, 0x00000018ff457819ULL, 0x000fe40000011454ULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x00000050005f7306ULL, 0x0002a20000200c00ULL,
0x00000018ff5d7819ULL, 0x000fc40000011458ULL, 0x00000018ff5c7819ULL, 0x000fe40000011459ULL,
0x00000018ff477819ULL, 0x000fe40000011455ULL, 0x00000018ff4f7819ULL, 0x000fe2000001145bULL,
0x0000005100637306ULL, 0x0007e20000200c00ULL, 0x0000888052507816ULL, 0x002fe400000000ffULL,
0x00000018ff437819ULL, 0x000fe40000011456ULL, 0x00000018ff447819ULL, 0x000fc40000011457ULL,
0x00000018ff2a7819ULL, 0x000fe20000011448ULL, 0x0000005000647306ULL, 0x0003e20000200c00ULL,
0x0000010052517824ULL, 0x008fe200078e00ffULL, 0x000054105f5e7816ULL, 0x004fe4000000005eULL,
0x00000018ff2b7819ULL, 0x000fe40000011449ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000002200627306ULL, 0x0004e20000200c00ULL, 0x0000888053507816ULL, 0x002fc400000000ffULL,
0x00000018ff237819ULL, 0x000fca000001144bULL, 0x0000005100657306ULL, 0x0002e20000200c00ULL,
0x00000018ff227819ULL, 0x004fe20000011452ULL, 0x0001000052527824ULL, 0x000fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000005000687306ULL, 0x0005e20000200c00ULL,
0x0000010053517824ULL, 0x002fe200078e00ffULL, 0x00005410635f7816ULL, 0x008fc80000000062ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000002200667306ULL, 0x0003e20000200c00ULL,
0x0000888058507816ULL, 0x004fe400000000ffULL, 0x0000541064647816ULL, 0x000fca0000000065ULL,
0x0000005100697306ULL, 0x0004e20000200c00ULL, 0x00000018ff227819ULL, 0x002fe20000011453ULL,
0x0001000053537824ULL, 0x000fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x00000050006c7306ULL, 0x0003e20000200c00ULL, 0x0000010058517824ULL, 0x044fe400078e00ffULL,
0x0001000058587824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005200677306ULL, 0x000fe20000200c00ULL, 0x0000888059507816ULL, 0x002fe400000000ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000541068657816ULL, 0x008fc60000000069ULL,
0x00000051006d7306ULL, 0x0002b00000200c00ULL, 0x00000050006e7306ULL, 0x0007e20000200c00ULL,
0x0000010059517824ULL, 0x042fe400078e00ffULL, 0x0001000059597824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000053006b7306ULL, 0x000fe20000200c00ULL,
0x000088805a507816ULL, 0x008fe400000000ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x000054106c6c7816ULL, 0x004fc6000000006dULL, 0x00000051006f7306ULL, 0x0002b00000200c00ULL,
0x0000005000707306ULL, 0x0007e20000200c00ULL, 0x000001005a517824ULL, 0x042fe400078e00ffULL,
0x000100005a5a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x000088805b507816ULL, 0x008fe400000000ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x000054106e6d7816ULL, 0x004fc6000000006fULL,
0x0000005100717306ULL, 0x0003f00000200c00ULL, 0x0000005000737306ULL, 0x0005e20000200c00ULL,
0x000001005b517824ULL, 0x042fe400078e00ffULL, 0x000100005b5b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000002d002d7306ULL, 0x000e620000200c00ULL,
0x0000888054507816ULL, 0x004fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fca000001145bULL,
0x0000005100747306ULL, 0x0005f00000200c00ULL, 0x0000005000767306ULL, 0x000fe20000200c00ULL,
0x0000010054517824ULL, 0x004fe200078e00ffULL, 0x000054102c2c7816ULL, 0x002fe2000000002dULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x00000018ff547819ULL, 0x000fce0000011454ULL,
0x0000005100777306ULL, 0x0005f00000200c00ULL, 0x0000005a00727306ULL, 0x0007e20000200c00ULL,
0x000000002e50783bULL, 0x0044a20000000200ULL, 0x00005410612d7816ULL, 0x002fcc0000000060ULL,
0x0000005400787306ULL, 0x0003e20000200c00ULL, 0x00008880555a7816ULL, 0x008fca00000000ffULL,
0x000000ffff2e7224ULL, 0x004fe400078e005aULL, 0x00000022006a7306ULL, 0x0004e20000200c00ULL,
0x0000010056547824ULL, 0x002fe400078e00ffULL, 0x00000100555a7824ULL, 0x040fe400078e00ffULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000002e00797306ULL, 0x0003e20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fc4000001145aULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff227819ULL, 0x004fc6000001144aULL,
0x00000054007d7306ULL, 0x0005e20000200c00ULL, 0x00008880562e7816ULL, 0x042fe200000000ffULL,
0x0001000056567824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000002e007c7306ULL, 0x0003e20000200c00ULL, 0x0000002750509232ULL, 0x080fe20000000000ULL,
0x0000010057547824ULL, 0x044fe200078e00ffULL, 0x0000002752529232ULL, 0x000fe40000000000ULL,
0x0000002851519232ULL, 0x080fe40000000000ULL, 0x0000002853539232ULL, 0x000fe20000000000ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x00000055007b7306ULL, 0x0007e20000200c00ULL,
0x00008880572e7816ULL, 0x042fe200000000ffULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x0000002c5038723cULL, 0x000be40000001838ULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000005400807306ULL, 0x0003e20000200c00ULL, 0x000054106b557816ULL, 0x008fc6000000006aULL,
0x00008880482c7816ULL, 0x060fe200000000ffULL, 0x00000100482d7824ULL, 0x040fe200078e00ffULL,
0x0000005e5034723cULL, 0x040f620000001834ULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x0000002e007f7306ULL, 0x000fe40000200c00ULL, 0x00000018ff547819ULL, 0x002fe4000001142dULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x000000645030723cULL, 0x040fe40000001830ULL,
0x0000002c00617306ULL, 0x0003ec0000200c00ULL, 0x0000006c5010723cULL, 0x000f640000001810ULL,
0x0000005400627306ULL, 0x0004e20000200c00ULL, 0x000000002f2c783bULL, 0x002e6e0000000200ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000541067547816ULL, 0x004fce0000000066ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000541061627816ULL, 0x008fce0000000062ULL,
0x0000005800587306ULL, 0x000eb00000200c00ULL, 0x0000005900597306ULL, 0x000ef00000200c00ULL,
0x0000004e004e7306ULL, 0x000ee20000200c00ULL, 0x0000541058587816ULL, 0x004fe2000000005dULL,
0x000000272c2c9232ULL, 0x082fe20000000000ULL, 0x00005410735d7816ULL, 0x000fe20000000074ULL,
0x000000272e2e9232ULL, 0x000fc40000000000ULL, 0x000000282d2d9232ULL, 0x080fe40000000000ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x0000541059597816ULL, 0x008fe2000000005cULL,
0x000000282f2f9232ULL, 0x000fe20000000000ULL, 0x00005410705c7816ULL, 0x000fca0000000071ULL,
0x0000005b00757306ULL, 0x000e620000200c00ULL, 0x00005410724e7816ULL, 0x000fe2000000004eULL,
0x0000005c505c723cULL, 0x000bec0000001808ULL, 0x00000056007e7306ULL, 0x000fe20000200c00ULL,
0x000088804b087816ULL, 0x060fe200000000ffULL, 0x000001004b097824ULL, 0x000fc400078e00ffULL,
0x000100004b4b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000005700607306ULL, 0x0005e20000200c00ULL, 0x00005410754f7816ULL, 0x002fe4000000004fULL,
0x00000018ff4b7819ULL, 0x000fca000001144bULL, 0x0000004500457306ULL, 0x000e620000200c00ULL,
0x000000545054723cULL, 0x004b6e0000001804ULL, 0x0000010049057824ULL, 0x020fe200078e00ffULL,
0x0000004700477306ULL, 0x000ea80000200c00ULL, 0x00000018ff057819ULL, 0x000fc80000011405ULL,
0x0000005a007a7306ULL, 0x0006700000200c00ULL, 0x0000000500647306ULL, 0x0003e20000200c00ULL,
0x00008880495a7816ULL, 0x048fe200000000ffULL, 0x0001000049497824ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fe200078e005aULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x000000585058723cULL, 0x040b62000000180cULL, 0x000001004a057824ULL, 0x002fe200078e00ffULL,
0x0000000400637306ULL, 0x0002e80000200c00ULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000004e5050723cULL, 0x000b640000001814ULL, 0x00005410780c7816ULL, 0x020fe20000000045ULL,
0x00000005004f7306ULL, 0x0007e20000200c00ULL, 0x000088804a047816ULL, 0x042fe200000000ffULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x000054107b0d7816ULL, 0x004fc80000000047ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x00000004004e7306ULL, 0x0002a20000200c00ULL,
0x0000541079057816ULL, 0x008fe2000000007aULL, 0x0000000c2c0c723cULL, 0x000b620000001834ULL,
0x0000541063637816ULL, 0x000fca0000000064ULL, 0x0000004300437306ULL, 0x000ee20000200c00ULL,
0x0000541076047816ULL, 0x002fe20000000077ULL, 0x000000622c10723cULL, 0x040f6c0000001810ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x000054104e347816ULL, 0x024fe2000000004fULL,
0x000000042c04723cULL, 0x000b6c0000001838ULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x000054107e147816ULL, 0x008fce0000000043ULL, 0x0000002b002b7306ULL, 0x000fe20000200c00ULL,
0x0000541060157816ULL, 0x002fce0000000044ULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x000000142c14723cULL, 0x000b6e0000001854ULL, 0x0000004900497306ULL, 0x000eb00000200c00ULL,
0x0000000800387306ULL, 0x0207e20000200c00ULL, 0x00005410482a7816ULL, 0x002fce000000002aULL,
0x0000000900357306ULL, 0x0002620000200c00ULL, 0x000054107c087816ULL, 0x008fe4000000007dULL,
0x00005410492b7816ULL, 0x004fca000000002bULL, 0x0000002200227306ULL, 0x000fe20000200c00ULL,
0x000054107f097816ULL, 0x002fce0000000080ULL, 0x0000002300237306ULL, 0x000fe20000200c00ULL,
0x0000541038357816ULL, 0x000fe20000000035ULL, 0x000000082c08723cULL, 0x040b6c0000001830ULL,
0x0000004a004a7306ULL, 0x000e640000200c00ULL, 0x0000002a2c30723cULL, 0x040b6c0000001858ULL,
0x0000004b004b7306ULL, 0x000ea40000200c00ULL, 0x000000342c34723cULL, 0x000b62000000185cULL,
0x000054104a227816ULL, 0x002fc40000000022ULL, 0x000054104b237816ULL, 0x004fce0000000023ULL,
0x000000222c2c723cULL, 0x000b620000001850ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff387f8cULL, 0x000e62000c80043fULL, 0x000000ffff3b7224ULL, 0x000fce00078e00ffULL,
0x0000000000227805ULL, 0x020fc40000015200ULL, 0x0106bc00ff2a7984ULL, 0x000ea40000000800ULL,
0x800000002aff7812ULL, 0x006fe40007804839ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a223a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e23ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x0000003a2a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff2a7984ULL, 0x000e640000000800ULL,
0x800000002aff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021f227810ULL, 0x000fc80007ffe0ffULL, 0x0000001a2200720cULL, 0x000fe20003f06070ULL,
0x000058001c227a24ULL, 0x010fc800078e02ffULL, 0x00000040222b7824ULL, 0x000fd000078e00ffULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000011b237824ULL, 0x000fe200078e0229ULL,
0x0000000229457810ULL, 0x000fe40007ffe0ffULL, 0x000000c03c3c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001232a7824ULL, 0x000fe200078e0202ULL, 0x0000000429487810ULL, 0x000fe20007ffe0ffULL,
0x0000001023447824ULL, 0x000fe200078e00ffULL, 0x0000003c18227217ULL, 0x000fe20007800000ULL,
0x000000011b387824ULL, 0x000fe200078e0245ULL, 0x00000006294a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004003237824ULL, 0x000fe200078e0223ULL, 0xfffffff044447812ULL, 0x000fe200078ee22aULL,
0x00000001382a7824ULL, 0x000fc400078e0202ULL, 0x0000001038477824ULL, 0x000fe200078e00ffULL,
0x00000002233b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000122227824ULL, 0x000fe200078e0a3cULL,
0x0000002b233c7210ULL, 0x080fe20007f1e0ffULL, 0x000000011b397824ULL, 0x000fe200078e0248ULL,
0xfffffff047477812ULL, 0x000fe200078ee22aULL, 0x000000011b2a7824ULL, 0x040fe200078e024aULL,
0x000000221b227217ULL, 0x000fe20007800000ULL, 0x0000000139387824ULL, 0x100fe200078e0202ULL,
0x00000006233a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001039497824ULL, 0x000fe200078e00ffULL,
0x0000000423397810ULL, 0x000fe20007ffe0ffULL, 0x000000012a437824ULL, 0x040fe200078e0202ULL,
0x0000002b3b3b7210ULL, 0x080fe20007f9e0ffULL, 0x000000102a4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff049497812ULL, 0x000fe200078ee238ULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x0000002b39397210ULL, 0x000fe20007f7e0ffULL, 0x00000001222a7824ULL, 0x000fe200078e0a1bULL,
0x00005e003c387a11ULL, 0x000fc400078440ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee243ULL,
0x000000ffff227224ULL, 0x000fe200018e06ffULL, 0x00005f003c3c7a11ULL, 0x000fe200010f4423ULL,
0x000000ffff237224ULL, 0x000fe200020e06ffULL, 0x0000002a2900720cULL, 0x000fe40003f46070ULL,
0x00005e0039297a11ULL, 0x000fe400078640ffULL, 0x000000f021437812ULL, 0x000fe400078ec0ffULL,
0x0000002b3a2b7210ULL, 0x000fc40007f1e0ffULL, 0x00005f0039397a11ULL, 0x000fe400018f4422ULL,
0x00005e003b3a7a11ULL, 0x040fe200078840ffULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0x0000004338227210ULL, 0x000fe40007fbe0ffULL, 0x00005f003b3b7a11ULL, 0x000fe400020f4423ULL,
0x0000002a4500720cULL, 0x080fe20003f86070ULL, 0x000000ffff237224ULL, 0x000fe200028e063cULL,
0x0000002a4800720cULL, 0x000fc40003f66070ULL, 0x0000c00044447811ULL, 0x000fe400078e20ffULL,
0x0000002a4a00720cULL, 0x000fe40003f06070ULL, 0x00005e002b387a11ULL, 0x040fe200078c40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022447faeULL, 0x0003e2000d101c46ULL,
0x000000433a2a7210ULL, 0x080fe40007fbe0ffULL, 0x00005f002b217a11ULL, 0x000fe400030f4421ULL,
0x0000c00047477811ULL, 0x000fe200078e20ffULL, 0x000000ffff2b7224ULL, 0x000fe200028e063bULL,
0x0000004338387210ULL, 0x000fc40007fbe0ffULL, 0x0000c00049497811ULL, 0x000fe400078e20ffULL,
0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL, 0x000000002a477faeULL, 0x0005e2000e101c46ULL,
0x0000004329227210ULL, 0x002fca0007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe400010e0639ULL,
0x000000ffff397224ULL, 0x000fc600028e0621ULL, 0x0000000022497faeULL, 0x0005e8000d901c46ULL,
0x00000000384b7faeULL, 0x0005e2000c101c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x000000011b297824ULL, 0x000fe200078e0229ULL, 0x000000f021217812ULL, 0x000fc600078ec0ffULL,
0x0000000129227824ULL, 0x040fe200078e0202ULL, 0x0000000229237810ULL, 0x040fe20007ffe0ffULL,
0x00000010292a7824ULL, 0x040fe200078e00ffULL, 0x00000006293a7810ULL, 0x000fc60007ffe0ffULL,
0x0000000123387824ULL, 0x040fe200078e0202ULL, 0xfffffff02a2a7812ULL, 0x000fe200078ee222ULL,
0x00000010233b7824ULL, 0x000fe400078e00ffULL, 0x0000004003227824ULL, 0x000fe400078e0229ULL,
0x000000013a477824ULL, 0x040fe200078e0202ULL, 0xfffffff03b3b7812ULL, 0x000fe200078ee238ULL,
0x000000103a497824ULL, 0x000fe200078e00ffULL, 0x0000000429387810ULL, 0x000fe40007ffe0ffULL,
0x0000002b22237210ULL, 0x000fc40007f1e0ffULL, 0x0000000222297810ULL, 0x000fe20007ffe0ffULL,
0x00000001383c7824ULL, 0x000fe200078e0202ULL, 0x0000000422397810ULL, 0x000fe20007ffe0ffULL,
0x0000001038447824ULL, 0x000fe200078e00ffULL, 0x0000000622437810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff227224ULL, 0x000fe200000e06ffULL, 0x0000002b29387210ULL, 0x080fe40007f5e0ffULL,
0x00005e0023297a11ULL, 0x000fe400078040ffULL, 0x0000002b393a7210ULL, 0x000fc40007f7e0ffULL,
0x0000002b43457210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e06ffULL,
0x00005f0023237a11ULL, 0x000fe400000f4422ULL, 0x0000002129227210ULL, 0x000fe40007f1e0ffULL,
0xfffffff044447812ULL, 0x000fe200078ee23cULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0xfffffff049497812ULL, 0x000fe200078ee247ULL, 0x000000ffff477224ULL, 0x000fe200020e06ffULL,
0x00005e0038397a11ULL, 0x000fe200078440ffULL, 0x000000ffff237224ULL, 0x000fe200000e0623ULL,
0x00005e003a437a11ULL, 0x000fc400078640ffULL, 0x00005e0045487a11ULL, 0x000fe400078840ffULL,
0x0000c0002a297811ULL, 0x000fe400078e20ffULL, 0x00005f00382b7a11ULL, 0x000fe400010f442bULL,
0x00000021392a7210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022297faeULL, 0x0003e2000b901c46ULL, 0x00005f003a3c7a11ULL, 0x000fe400018f443cULL,
0x0000002143387210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e062bULL,
0x00005f0045477a11ULL, 0x000fc400020f4447ULL, 0x00000021483a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff397224ULL, 0x000fe200010e063cULL, 0x0000c0003b217811ULL, 0x000fe400078e20ffULL,
0x0000c00044447811ULL, 0x000fe200078e20ffULL, 0x000000ffff3b7224ULL, 0x000fe200018e0647ULL,
0x0000c00049497811ULL, 0x000fe200078e20ffULL, 0x000000002a217faeULL, 0x0003e8000b901c46ULL,
0x0000000038447faeULL, 0x0003e8000b901c46ULL, 0x000000003a497faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff227f8cULL, 0x004e64000c80043fULL, 0x000000ffff437224ULL, 0x002fc400078e0023ULL,
0x0000000000227805ULL, 0x000fca0000015200ULL, 0x0106b400ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a22297210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2a7824ULL, 0x000fe200000e0e23ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc8000001142aULL, 0x0000002921217211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e062aULL, 0x0000000221217819ULL, 0x000fc80000001229ULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000026ff21723eULL, 0x000fe400000000ffULL,
0x00000002ff227819ULL, 0x000fe40000011602ULL, 0x0000541021217816ULL, 0x000fe20000000021ULL,
0x00007aa27f007947ULL, 0x000fea000b800000ULL, 0x00001f2221277589ULL, 0x0002a400000e0000ULL,
0x0000000822287810ULL, 0x000fe20007ffe0ffULL, 0x00007ad27f007947ULL, 0x000fea000b800000ULL,
0x00001f2821287589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001022457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0021ULL,
0x0001118000447802ULL, 0x000fc40000000f00ULL, 0x00007fa000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001822457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x004fe200078e0021ULL, 0x000111d000447802ULL, 0x000fc40000000f00ULL,
0x00007f5000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003f38783bULL, 0x000f220000004200ULL,
0x0000b80042427811ULL, 0x000fc600078e20ffULL, 0x00000000404c783bULL, 0x004fe80000004200ULL,
0x000000003d48783bULL, 0x000ea80000004200ULL, 0x000000003e3c783bULL, 0x000ee40000004200ULL,
0x00000018ff217819ULL, 0x01afe20000011438ULL, 0x0000010039547824ULL, 0x040fe200078e00ffULL,
0x0000888039537816ULL, 0x000fe200000000ffULL, 0x0000010038517824ULL, 0x040fe200078e00ffULL,
0x0000002100527306ULL, 0x0003e20000200c00ULL, 0x0000888038507816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff2a7819ULL, 0x004fe40000011448ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000005300557306ULL, 0x000fe20000200c00ULL, 0x00000018ff217819ULL, 0x002fe20000011439ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff407819ULL, 0x000fe4000001144eULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003800537306ULL, 0x0002a20000200c00ULL, 0x00000018ff2b7819ULL, 0x000fc40000011449ULL,
0x00000018ff297819ULL, 0x000fe4000001144aULL, 0x00000018ff257819ULL, 0x000fe4000001144bULL,
0x00000018ff457819ULL, 0x000fe2000001144cULL, 0x0000003900577306ULL, 0x0007e20000200c00ULL,
0x000088803a387816ULL, 0x002fe400000000ffULL, 0x00000018ff477819ULL, 0x000fe4000001144dULL,
0x00000018ff447819ULL, 0x000fc4000001144fULL, 0x00000018ff237819ULL, 0x000fe2000001143cULL,
0x0000003800587306ULL, 0x0003e20000200c00ULL, 0x000001003a397824ULL, 0x008fe200078e00ffULL,
0x0000541053527816ULL, 0x004fe40000000052ULL, 0x00000018ff247819ULL, 0x000fe4000001143dULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000002100567306ULL, 0x0004e20000200c00ULL,
0x000088803b387816ULL, 0x002fc400000000ffULL, 0x00000018ff227819ULL, 0x000fca000001143fULL,
0x0000003900597306ULL, 0x0003220000200c00ULL, 0x00000018ff217819ULL, 0x004fe2000001143aULL,
0x000100003a3a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x00000038005c7306ULL, 0x0005e20000200c00ULL, 0x000001003b397824ULL, 0x002fe200078e00ffULL,
0x0000541057537816ULL, 0x008fc80000000056ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000021005a7306ULL, 0x0003e20000200c00ULL, 0x000088804c387816ULL, 0x004fe400000000ffULL,
0x0000541058587816ULL, 0x010fca0000000059ULL, 0x00000039005d7306ULL, 0x0004e20000200c00ULL,
0x00000018ff217819ULL, 0x002fe2000001143bULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000003800607306ULL, 0x0003e20000200c00ULL,
0x000001004c397824ULL, 0x044fe400078e00ffULL, 0x000100004c4c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a005b7306ULL, 0x000ea20000200c00ULL,
0x000088804d387816ULL, 0x002fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x000054105c597816ULL, 0x008fc6000000005dULL, 0x0000003900617306ULL, 0x0002f00000200c00ULL,
0x0000003800627306ULL, 0x0009e20000200c00ULL, 0x000001004d397824ULL, 0x002fe200078e00ffULL,
0x000054105b5a7816ULL, 0x004fe2000000005aULL, 0x000100004d4d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003b005f7306ULL, 0x000fe20000200c00ULL,
0x000088804e387816ULL, 0x010fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000541060607816ULL, 0x008fc60000000061ULL, 0x0000003900637306ULL, 0x0002b00000200c00ULL,
0x0000003800647306ULL, 0x0007e20000200c00ULL, 0x000001004e397824ULL, 0x042fe400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000088804f387816ULL, 0x008fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000541062617816ULL, 0x004fc60000000063ULL,
0x0000003900657306ULL, 0x0003f00000200c00ULL, 0x0000003800677306ULL, 0x0005e20000200c00ULL,
0x000001004f397824ULL, 0x042fe400078e00ffULL, 0x000100004f4f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000005100517306ULL, 0x000e620000200c00ULL,
0x0000888048387816ULL, 0x004fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fca000001144fULL,
0x0000003900687306ULL, 0x0005f00000200c00ULL, 0x00000038006a7306ULL, 0x0007e20000200c00ULL,
0x0000010048397824ULL, 0x004fe200078e00ffULL, 0x0000541050507816ULL, 0x002fe20000000051ULL,
0x0001000048487824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x0000b80041387811ULL, 0x008fe400078e20ffULL, 0x0000888049417816ULL, 0x000fca00000000ffULL,
0x00000048006c7306ULL, 0x0005f00000200c00ULL, 0x00000039006b7306ULL, 0x0007e20000200c00ULL,
0x000001004a487824ULL, 0x004fe200078e00ffULL, 0x0000541055517816ULL, 0x002fc80000000054ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000041006d7306ULL, 0x0003e20000200c00ULL,
0x000000003838783bULL, 0x008eae0000000200ULL, 0x0000004800717306ULL, 0x0007e20000200c00ULL,
0x000088804a417816ULL, 0x042fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000004e00667306ULL, 0x0003e20000200c00ULL,
0x000001004b487824ULL, 0x008fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004100707306ULL, 0x0007e20000200c00ULL, 0x00000100494e7824ULL, 0x042fe400078e00ffULL,
0x0001000049497824ULL, 0x000fc600078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004800747306ULL, 0x0003e20000200c00ULL, 0x000088804b417816ULL, 0x048fe200000000ffULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc80000011449ULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000004100737306ULL, 0x0007e20000200c00ULL,
0x000001003c487824ULL, 0x042fe200078e00ffULL, 0x0000002738389232ULL, 0x084fe40000000000ULL,
0x000000273a3a9232ULL, 0x000fe40000000000ULL, 0x0000002839399232ULL, 0x080fe40000000000ULL,
0x00000049006f7306ULL, 0x000fe20000200c00ULL, 0x000088803c417816ULL, 0x048fe200000000ffULL,
0x000000283b3b9232ULL, 0x000fe20000000000ULL, 0x000100003c3c7824ULL, 0x000fca00078e00ffULL,
0x0000004100557306ULL, 0x0003e20000200c00ULL, 0x000000503804723cULL, 0x000be20000001804ULL,
0x00000018ff3c7819ULL, 0x000fcc000001143cULL, 0x0000004a00727306ULL, 0x000fe20000200c00ULL,
0x00000018ff417819ULL, 0x002fe20000011448ULL, 0x00000052380c723cULL, 0x040f64000000180cULL,
0x0000541064507816ULL, 0x020fe40000000065ULL, 0x0000541067517816ULL, 0x000fe40000000068ULL,
0x0000004b00547306ULL, 0x0003e40000200c00ULL, 0x000000583808723cULL, 0x040f6c0000001808ULL,
0x00000021005e7306ULL, 0x0004e20000200c00ULL, 0x000000004248783bULL, 0x002e620000000200ULL,
0x000000603810723cULL, 0x040fec0000001810ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x00000018ff217819ULL, 0x004fe2000001143eULL, 0x000000503850723cULL, 0x000fec0000001834ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000054105f5b7816ULL, 0x008fce000000005eULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x0000005a3814723cULL, 0x000f6e0000001814ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000004c004c7306ULL, 0x000ee20000200c00ULL,
0x0000541066407816ULL, 0x004fe20000000040ULL, 0x0000002748489232ULL, 0x002fc40000000000ULL,
0x000000274a4a9232ULL, 0x000fe40000000000ULL, 0x0000002849499232ULL, 0x080fe40000000000ULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000000284b4b9232ULL, 0x000fce0000000000ULL,
0x0000004f00697306ULL, 0x000ea20000200c00ULL, 0x000054104c4c7816ULL, 0x008fce0000000045ULL,
0x0000004e006e7306ULL, 0x0007e20000200c00ULL, 0x000054104d4d7816ULL, 0x002fce0000000047ULL,
0x0000004100427306ULL, 0x0003e20000200c00ULL, 0x000088803d4e7816ULL, 0x008fce00000000ffULL,
0x0000002a002a7306ULL, 0x000ee20000200c00ULL, 0x000000ffff417224ULL, 0x002fe400078e004eULL,
0x000001003d4e7824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x0000004100567306ULL, 0x0005e20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff3d7819ULL, 0x000fca000001143dULL, 0x0000002b002b7306ULL, 0x000e620000200c00ULL,
0x0000541069417816ULL, 0x004fe40000000044ULL, 0x000054106c2a7816ULL, 0x008fca000000002aULL,
0x0000004e00577306ULL, 0x0005e20000200c00ULL, 0x00000040382c723cULL, 0x040fee000000182cULL,
0x0000002900297306ULL, 0x000ee20000200c00ULL, 0x0000004c384c723cULL, 0x004b620000001830ULL,
0x000054106f2b7816ULL, 0x002fcc000000002bULL, 0x000054106a387816ULL, 0x020fe2000000006bULL,
0x0000002500257306ULL, 0x000e620000200c00ULL, 0x000054106d397816ULL, 0x000fe2000000006eULL,
0x000001003e317824ULL, 0x040fe200078e00ffULL, 0x000088803e307816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000002a4834723cULL, 0x000f64000000180cULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000003000407306ULL, 0x0005e20000200c00ULL,
0x00000018ff3e7819ULL, 0x000fc8000001143eULL, 0x000000384838723cULL, 0x000b660000001804ULL,
0x0000003100417306ULL, 0x0008620000200c00ULL, 0x000088803f307816ULL, 0x004fc600000000ffULL,
0x000001003f057824ULL, 0x060fe400078e00ffULL, 0x000000ffff047224ULL, 0x000fe200078e0030ULL,
0x0000541070307816ULL, 0x000fe20000000071ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x0000000400447306ULL, 0x0007e20000200c00ULL,
0x0000541073317816ULL, 0x010fe40000000074ULL, 0x00000018ff3f7819ULL, 0x000fca000001143fULL,
0x00000005002a7306ULL, 0x0002a20000200c00ULL, 0x0000541072047816ULL, 0x008fe20000000029ULL,
0x000000304830723cULL, 0x000b6c0000001808ULL, 0x0000002300237306ULL, 0x000fe20000200c00ULL,
0x0000541054057816ULL, 0x002fe40000000025ULL, 0x0000541055087816ULL, 0x020fc40000000042ULL,
0x0000541056097816ULL, 0x000fc60000000057ULL, 0x000000044804723cULL, 0x040f620000001814ULL,
0x0000002400247306ULL, 0x000fee0000200c00ULL, 0x000000084810723cULL, 0x000b620000001810ULL,
0x0000002100217306ULL, 0x000fec0000200c00ULL, 0x0000541040087816ULL, 0x020fc40000000041ULL,
0x0000002200227306ULL, 0x000fe20000200c00ULL, 0x0000541044097816ULL, 0x004fce000000002aULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x000000084808723cULL, 0x000b6e0000001850ULL,
0x0000003d003d7306ULL, 0x000eb00000200c00ULL, 0x0000003e003e7306ULL, 0x000ee20000200c00ULL,
0x000054103c0c7816ULL, 0x002fce0000000023ULL, 0x0000003f00157306ULL, 0x000e620000200c00ULL,
0x000054103d0d7816ULL, 0x004fe40000000024ULL, 0x000054103e147816ULL, 0x008fca0000000021ULL,
0x0000000c480c723cULL, 0x000b62000000184cULL, 0x0000541015157816ULL, 0x002fce0000000022ULL,
0x000000144814723cULL, 0x000b62000000182cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff227f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000000420557810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x022fc400078e0023ULL,
0x000000011f1f7810ULL, 0x000fc80007ffe0ffULL, 0x0000001a1f00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffef08000007947ULL, 0x000fea000383ffffULL,
0x000000ff1a00720cULL, 0x000fe20003f05270ULL, 0x000000ffff257224ULL, 0x000fe400078e0017ULL,
0x000000ffff247224ULL, 0x000fe400078e0016ULL, 0x000000ffff237224ULL, 0x008fe400078e0015ULL,
0x000000ffff227224ULL, 0x000fe400078e0014ULL, 0x000000ffff1c7224ULL, 0x000fe400078e000fULL,
0x000000ffff1a7224ULL, 0x000fc400078e000eULL, 0x000000ffff177224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x000fe400078e0012ULL, 0x000000ffff217224ULL, 0x002fe400078e000bULL,
0x000000ffff207224ULL, 0x000fe400078e000aULL, 0x000000ffff1f7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x000000ffff197224ULL, 0x000fe400078e000dULL,
0x000000ffff187224ULL, 0x000fe400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e0011ULL,
0x000000ffff127224ULL, 0x000fe400078e0010ULL, 0x000000ffff147224ULL, 0x000fe400078e0007ULL,
0x000000ffff137224ULL, 0x000fc400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0005ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000001d027810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x000fe200078e001dULL,
0x0001232000057802ULL, 0x000fc40000000f00ULL, 0x00006c2000007944ULL, 0x004fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001d00047308ULL, 0x000e640000001000ULL,
0xbf800000041d7423ULL, 0x002fc8000000001dULL, 0x800000ff1d1d7221ULL, 0x000fc80000010100ULL,
0x0000001d04047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff027624ULL, 0x000fe400078e00ffULL, 0x00006900ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x0002e8000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff037819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000402027220ULL, 0x008fca0000410000ULL, 0x00001f0302037589ULL, 0x000e6800000e0000ULL,
0x00001f0502027589ULL, 0x000ee200000e0000ULL, 0x0000003803387220ULL, 0x042fe20000410000ULL,
0x0000003903397220ULL, 0x040fe20000410000ULL, 0x0000003403347220ULL, 0x040fe20000410000ULL,
0x0000003503357220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x040fe20000410000ULL, 0x0000000e030e7220ULL, 0x040fe20000410000ULL,
0x0000000f030f7220ULL, 0x040fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000001503157220ULL, 0x040fe20000410000ULL, 0x0000001803187220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x000fe20000410000ULL, 0x0000003a023a7220ULL, 0x048fe20000410000ULL,
0x0000003b023b7220ULL, 0x040fe20000410000ULL, 0x0000003602367220ULL, 0x040fe20000410000ULL,
0x0000003702377220ULL, 0x040fe20000410000ULL, 0x0000003202327220ULL, 0x040fe20000410000ULL,
0x0000003302337220ULL, 0x040fe20000410000ULL, 0x0000001302137220ULL, 0x040fe20000410000ULL,
0x0000001402147220ULL, 0x040fe20000410000ULL, 0x0000001602167220ULL, 0x040fe20000410000ULL,
0x0000001702177220ULL, 0x040fe20000410000ULL, 0x0000001a021a7220ULL, 0x040fe20000410000ULL,
0x0000001c021c7220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002502257220ULL, 0x000fc20000410000ULL, 0x00000000001d7919ULL, 0x000e620000000000ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000580000047ab9ULL, 0x000fc40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff047819ULL, 0x002fc6000001161dULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x000000021d027812ULL, 0x040fe400078ec0ffULL, 0x000000081d057811ULL, 0x000fe200078ff0ffULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x0000000402037211ULL, 0x000fe200078ff8ffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000000502067211ULL, 0x000fe200078ff8ffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000000203027810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x040fe200078e00ffULL, 0x0000000403057810ULL, 0x000fe20007ffe0ffULL,
0x00000008040b7824ULL, 0x000fe200078e00ffULL, 0xfffffff807047812ULL, 0x000fc400078ee203ULL,
0x0000000603037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff809097812ULL, 0x000fe400078ee206ULL,
0xfffffff808067812ULL, 0x000fe400078ee202ULL, 0xfffffff80b087812ULL, 0x000fe200078ee203ULL,
0x000000081d037824ULL, 0x000fe200078e00ffULL, 0xfffffff80a077812ULL, 0x000fe400078ee205ULL,
0x0000a00000057811ULL, 0x000fc400078e58ffULL, 0x0000000803037812ULL, 0x000fe400078ec0ffULL,
0x000000383900723eULL, 0x000fe200000000ffULL, 0x0000001004047824ULL, 0x100fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000000ffULL, 0x0000001009097824ULL, 0x000fe200078e0205ULL,
0x00000003ff0b7819ULL, 0x000fe2000001161dULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x00005410000c7816ULL, 0x100fe20000000002ULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x00007632000d7816ULL, 0x000fe20000000002ULL, 0x0000001007007824ULL, 0x100fe200078e0205ULL,
0x000000201d107810ULL, 0x000fe20007ffe0ffULL, 0x0000001008027824ULL, 0x000fc400078e0205ULL,
0x0000000c04007388ULL, 0x0003e20000000a00ULL, 0x00000003ff117819ULL, 0x000fe20000011610ULL,
0x00000001030a7824ULL, 0x040fe400078e0209ULL, 0x0000000103077824ULL, 0x040fe400078e0206ULL,
0x0000000103087824ULL, 0x000fe200078e0200ULL, 0x000000303100723eULL, 0x000fe200000000ffULL,
0x0000000103097824ULL, 0x000fe200078e0202ULL, 0x0000000e0f02723eULL, 0x000fe400000000ffULL,
0x000000121503723eULL, 0x000fe200000000ffULL, 0x000000010b047824ULL, 0x002fe200078e021dULL,
0x00005410000e7816ULL, 0x100fe20000000002ULL, 0x00000001100c7824ULL, 0x000fe200078e0211ULL,
0x00007632000f7816ULL, 0x000fc40000000002ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000e07007388ULL, 0x000fe20000000a00ULL,
0x0ffffff804067812ULL, 0x000fe400078ef81dULL, 0x000000181904723eULL, 0x000fe400000000ffULL,
0x0ffffff80c0d7812ULL, 0x000fe200078ef810ULL, 0x00000010060c7824ULL, 0x000fe200078e0205ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x000000100d127824ULL, 0x000fe200078e0205ULL, 0x0000001e1f00723eULL, 0x000fe400000000ffULL,
0x000000363704723eULL, 0x000fe200000000ffULL, 0x0000000208007388ULL, 0x0003e20000000a00ULL,
0x000000323305723eULL, 0x000fe400000000ffULL, 0x000000131406723eULL, 0x000fe400000000ffULL,
0x000000071d1d7812ULL, 0x000fc400078ec0ffULL, 0x0000000710107812ULL, 0x000fc800078ec0ffULL,
0x1ffffff810107812ULL, 0x000fe400078ef81bULL, 0x000000222302723eULL, 0x002fe400000000ffULL,
0x0000003a3b03723eULL, 0x000fe400000000ffULL, 0x00005410000e7816ULL, 0x140fe40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0000000e09007388ULL, 0x000fe20000000a00ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000020a007388ULL, 0x0003e20000000a00ULL, 0x000000161700723eULL, 0x000fc600000000ffULL,
0x0004000407007388ULL, 0x0007e20000000a00ULL, 0x0000001a1c02723eULL, 0x002fe400000000ffULL,
0x000000202103723eULL, 0x000fe200000000ffULL, 0x0000000000057919ULL, 0x008e620000002600ULL,
0x000000242504723eULL, 0x000fe400000000ffULL, 0x0000541000067816ULL, 0x140fe40000000002ULL,
0x0000763200077816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004000608007388ULL, 0x000fe80000000a00ULL,
0x0004000209007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000c0c7984ULL, 0x000f220000000c00ULL, 0x0000000805007824ULL, 0x002fc600078e00ffULL,
0x0000000012147984ULL, 0x000e620000000c00ULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff8000b7812ULL, 0x000fc800078ee20bULL, 0xfffffff805117812ULL, 0x000fe400078ee211ULL,
0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000411117c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a000b027a11ULL, 0x008fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a0011047a11ULL, 0x000fe400078248ffULL,
0x00005b000b037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff81d007812ULL, 0x000fe400078ef81bULL,
0x00005b0011057a11ULL, 0x000fc600008f4c05ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x0000001010047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x010fe8000c101d06ULL,
0x0000001404007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000190000720cULL, 0x000fe20003f06070ULL, 0xffffffffff1b7424ULL, 0x000fd800078e00ffULL,
0x000000021e048824ULL, 0x002fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0200ULL,
0x0000600004048625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff2a7624ULL, 0x000fe200078e00ffULL, 0x00000006041b8981ULL, 0x0002a2000c1e1900ULL,
0x00006900ff2b7624ULL, 0x000fca00078e00ffULL, 0x000000062a2a7981ULL, 0x000722000c1e9900ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000004000287824ULL, 0x000fe200078e00ffULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000004003297824ULL, 0x000fc600078e00ffULL, 0x000000041b167c24ULL, 0x004fcc000f8e02ffULL,
0x0000071000000947ULL, 0x000fea0003800000ULL, 0x00000002ff177819ULL, 0x00afe40000011602ULL,
0x000000300e157812ULL, 0x000fe400078ec0ffULL, 0x00002000000d7811ULL, 0x000fe200078e68ffULL,
0x00000040030c7824ULL, 0x000fca00078e0217ULL, 0x000000080c037810ULL, 0x040fe40007ffe0ffULL,
0x000000100c067810ULL, 0x000fe40007ffe0ffULL, 0x0000000316037210ULL, 0x040fe40007f3e0ffULL,
0x0000000616067210ULL, 0x040fe40007f5e0ffULL, 0x0000000c16147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x00005e00030f7a11ULL, 0x000fe200078240ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x000000180c077810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005e0006087a11ULL, 0x000fc400078440ffULL,
0x00005f0003137a11ULL, 0x000fe400008f4413ULL, 0x0000000716077210ULL, 0x000fe40007f7e0ffULL,
0x00005e0014097a11ULL, 0x000fe400078040ffULL, 0x0000002818037217ULL, 0x000fe20007800000ULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x00005f0006127a11ULL, 0x000fe400010f4412ULL,
0x0000000202067211ULL, 0x000fc400078fe8ffULL, 0x00005f0014147a11ULL, 0x000fe200000f440aULL,
0x00000001030a7824ULL, 0x000fe200078e0a28ULL, 0x00005e0007107a11ULL, 0x000fe400078640ffULL,
0x00000003060b7812ULL, 0x000fe400078ec0ffULL, 0x0000000817067810ULL, 0x000fe40007ffe0ffULL,
0x00005f0007117a11ULL, 0x000fe400018f4411ULL, 0x0000000a1700720cULL, 0x000fc40003f06070ULL,
0x0000001017077810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffc0b037812ULL, 0x000fe400078ef802ULL,
0x0000000a0600720cULL, 0x0c0fe20003f26070ULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x0000000915027210ULL, 0x000fe20007f7e0ffULL, 0x00000004070e7824ULL, 0x040fe200078e00ffULL,
0x0000000a0700720cULL, 0x000fe20003f46070ULL, 0x0000001003097824ULL, 0x000fe200078e020dULL,
0xfffffffc06077812ULL, 0x000fe200078ee20bULL, 0x000000ffff037224ULL, 0x000fe200018e0614ULL,
0x000000150f067210ULL, 0x000fc40007f7e0ffULL, 0xfffffffc0e0f7812ULL, 0x000fe200078ee20bULL,
0x00000010070e7824ULL, 0x000fe200078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000c101c46ULL, 0x000000ffff077224ULL, 0x000fe200018e0613ULL,
0x0000001508087210ULL, 0x000fe20007f9e0ffULL, 0x000000100f0f7824ULL, 0x000fc600078e020dULL,
0x00000000060e7faeULL, 0x0005e2000c901c46ULL, 0x0000001817037810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0612ULL, 0x000000200c027810ULL, 0x000fe40007ffe0ffULL,
0x0000000a0300720cULL, 0x040fe40003f86070ULL, 0x0000000216147210ULL, 0x000fe20007f1e0ffULL,
0x0000000403067824ULL, 0x004fe200078e00ffULL, 0x0000001510027210ULL, 0x000fe20007fbe0ffULL,
0x00000000080f7faeULL, 0x0003e2000d101c46ULL, 0x00005e0014137a11ULL, 0x000fe200078c40ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0xfffffffc06067812ULL, 0x000fc400078ee20bULL,
0x0000002017077810ULL, 0x040fe40007ffe0ffULL, 0x00005f0014147a11ULL, 0x000fe200030f4403ULL,
0x000000ffff037224ULL, 0x000fe200028e0611ULL, 0x00000030170e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001006067824ULL, 0x000fe200078e020dULL, 0x0000000a0700720cULL, 0x000fe40003f66070ULL,
0x0000002817087810ULL, 0x042fe40007ffe0ffULL, 0x00000038170f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000002067faeULL, 0x0003e2000e101c46ULL, 0x000000280c097810ULL, 0x000fc40007ffe0ffULL,
0x0000000a0800720cULL, 0x080fe40003f46070ULL, 0x0000000916127210ULL, 0x000fe40007fbe0ffULL,
0x0000000a0e00720cULL, 0x080fe40003f26070ULL, 0x0000000a0f00720cULL, 0x000fe40003f06070ULL,
0x000000300c0a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000407027824ULL, 0x002fe200078e00ffULL,
0x000000380c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000408037824ULL, 0x000fe200078e00ffULL,
0x0000000a16107210ULL, 0x000fe20007f9e0ffULL, 0x000000040e067824ULL, 0x000fe200078e00ffULL,
0xfffffffc02027812ULL, 0x100fe200078ee20bULL, 0x000000040f077824ULL, 0x000fe200078e00ffULL,
0xfffffffc03037812ULL, 0x000fc400078ee20bULL, 0xfffffffc06067812ULL, 0x100fe400078ee20bULL,
0xfffffffc07077812ULL, 0x000fe200078ee20bULL, 0x00000010020b7824ULL, 0x100fe200078e020dULL,
0x0000000c16097210ULL, 0x000fe20007fde0ffULL, 0x000000ffff027224ULL, 0x000fe200028e06ffULL,
0x00005e0012117a11ULL, 0x000fe200078a40ffULL, 0x00000010030c7824ULL, 0x100fe400078e020dULL,
0x00000010060e7824ULL, 0x100fe200078e020dULL, 0x00005f0012127a11ULL, 0x000fe200028f4402ULL,
0x00000010070d7824ULL, 0x000fe200078e020dULL, 0x0000001513027210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x00005e0010087a11ULL, 0x000fe200078840ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x00005e00090a7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff037224ULL, 0x000fe200028e0614ULL, 0x0000001511067210ULL, 0x000fc40007fbe0ffULL,
0x00005f0010107a11ULL, 0x000fe400020f4407ULL, 0x0000001508087210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff077224ULL, 0x000fe200028e0612ULL, 0x00005f00090f7a11ULL, 0x000fe200030f440fULL,
0x00000000020b7faeULL, 0x0003e2000d901c46ULL, 0x000000150a0a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe400020e0610ULL, 0x00000000060c7faeULL, 0x0005e8000d101c46ULL,
0x00000000080e7faeULL, 0x0005e2000c901c46ULL, 0x000000ffff0b7224ULL, 0x002fca00028e060fULL,
0x000000000a0d7faeULL, 0x0005e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000002902037211ULL, 0x04afe400078ff0ffULL, 0x0000000802157811ULL, 0x000fe400078ff0ffULL,
0x0000000316037210ULL, 0x000fe40007f1e0ffULL, 0x0000001802087811ULL, 0x040fe400078ff0ffULL,
0x00000020020a7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005e0003247a11ULL, 0x000fe200078040ffULL, 0x0000000129097824ULL, 0x040fe200078e0208ULL,
0x0000001002067811ULL, 0x040fe200078ff0ffULL, 0x00000001290b7824ULL, 0x000fe200078e020aULL,
0x00005f0003257a11ULL, 0x000fe200000f4425ULL, 0x0000000129037824ULL, 0x040fe200078e0215ULL,
0x00000028020c7811ULL, 0x040fe200078ff0ffULL, 0x0000000129077824ULL, 0x000fe200078e0206ULL,
0x0000000202147211ULL, 0x040fe200078fe8ffULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x00000030020f7811ULL, 0x000fe200078ff0ffULL, 0x00000001290d7824ULL, 0x000fe200078e020cULL,
0x0000000316237210ULL, 0x000fe20007fde0ffULL, 0x0000000406037824ULL, 0x000fe200078e00ffULL,
0x0000003802117811ULL, 0x000fe200078ff0ffULL, 0x0000000408067824ULL, 0x000fe200078e00ffULL,
0x0000000916207210ULL, 0x000fe20007f1e0ffULL, 0x000000040c087824ULL, 0x000fe200078e00ffULL,
0x0000000314147812ULL, 0x000fe200078ec0ffULL, 0x000000040f097824ULL, 0x000fe200078e00ffULL,
0x0000000b160b7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200030e06ffULL,
0x0000000d161d7210ULL, 0x000fe20007f5e0ffULL, 0x0000000129107824ULL, 0x000fe200078e020fULL,
0x00005e0023227a11ULL, 0x000fe200078c40ffULL, 0x0000000129127824ULL, 0x000fe200078e0211ULL,
0x0000200000177811ULL, 0x000fe200078e68ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e06ffULL,
0x0ffffffc140d7812ULL, 0x000fc400078ef802ULL, 0xfffffffc03037812ULL, 0x100fe400078ee214ULL,
0x0000000716217210ULL, 0x000fe20007fbe0ffULL, 0x000000040a077824ULL, 0x000fe200078e00ffULL,
0xfffffffc15027812ULL, 0x100fe200078ee214ULL, 0x000000100d267824ULL, 0x100fe200078e0217ULL,
0xfffffffc08087812ULL, 0x100fe200078ee214ULL, 0x00000010030f7824ULL, 0x100fe200078e0217ULL,
0xfffffffc09097812ULL, 0x000fe200078ee214ULL, 0x00000004110a7824ULL, 0x000fe200078e00ffULL,
0x00005f0023237a11ULL, 0x000fe200030f440cULL, 0x00000010020d7824ULL, 0x100fe200078e0217ULL,
0x00005e000b0c7a11ULL, 0x000fe200078240ffULL, 0x0000001008157824ULL, 0x100fe200078e0217ULL,
0x00000010161c7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff037224ULL, 0x000fe200028e06ffULL,
0x0000001216137210ULL, 0x000fe20007f9e0ffULL, 0x0000001009167824ULL, 0x000fe200078e0217ULL,
0xfffffffc06067812ULL, 0x100fe200078ee214ULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0xfffffffc07077812ULL, 0x000fc400078ee214ULL, 0x00005e0021087a11ULL, 0x000fe200078a40ffULL,
0x0000001006117824ULL, 0x000fe200078e0217ULL, 0x00005e0020097a11ULL, 0x000fe200078040ffULL,
0x000000ffff067224ULL, 0x000fe200018e06ffULL, 0x00005f000b1f7a11ULL, 0x000fe400008f441fULL,
0x000000300e0b7812ULL, 0x000fe400078ec0ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee214ULL,
0x0000001007147824ULL, 0x000fe200078e0217ULL, 0x00005f0021217a11ULL, 0x000fe200028f4403ULL,
0x000000ffff037224ULL, 0x000fe200020e06ffULL, 0x00005f0020207a11ULL, 0x000fe200000f4402ULL,
0x000000ffff077224ULL, 0x000fe200010e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078640ffULL,
0x000000100a177824ULL, 0x000fe200078e0217ULL, 0x000000240b027210ULL, 0x000fc40007f1e0ffULL,
0x00005e001c107a11ULL, 0x040fe400078440ffULL, 0x00005e001d0e7a11ULL, 0x000fe400078240ffULL,
0x00005f0013137a11ULL, 0x000fe200018f4403ULL, 0x000000ffff037224ULL, 0x000fe200000e0625ULL,
0x00005f001c1c7a11ULL, 0x000fe400010f4406ULL, 0x00005f001d1d7a11ULL, 0x000fe400008f4407ULL,
0x000000220b067210ULL, 0x040fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002267faeULL, 0x0003e2000b901c46ULL, 0x000000080b087210ULL, 0x000fc40007f3e0ffULL,
0x000000090b0a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0623ULL,
0x0000000c0b0c7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0621ULL,
0x0000000e0b0e7210ULL, 0x040fe40007f9e0ffULL, 0x000000100b107210ULL, 0x040fe20007fbe0ffULL,
0x00000000060d7faeULL, 0x0005e2000b901c46ULL, 0x000000120b127210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe400010e0620ULL, 0x00000000080f7faeULL, 0x0007e4000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400000e0613ULL, 0x000000000a117faeULL, 0x0003e2000b901c46ULL,
0x000000ffff0d7224ULL, 0x004fe400018e061fULL, 0x000000ffff0f7224ULL, 0x008fc600020e061dULL,
0x000000000c147faeULL, 0x0005e2000b901c46ULL, 0x000000ffff117224ULL, 0x002fc600028e061cULL,
0x000000000e157faeULL, 0x0005e8000b901c46ULL, 0x0000000010167faeULL, 0x0005e8000b901c46ULL,
0x0000000012177faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x01060400ff067984ULL, 0x004e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000602087210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e03ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000806067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0202ULL, 0x00000003ff037819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe03037812ULL, 0x000fe400078ec0ffULL,
0x0000000102047810ULL, 0x040fe20007ffe0ffULL, 0x0000002002087824ULL, 0x040fe400078e00ffULL,
0x0000000102057824ULL, 0x040fe400078e0203ULL, 0x0000000103067824ULL, 0x040fe200078e0204ULL,
0x0000001003037810ULL, 0x000fe20007ffe0ffULL, 0x0000002002077824ULL, 0x000fe200078e00ffULL,
0x0000001f05057812ULL, 0x000fc400078ec0ffULL, 0x0000001f06067812ULL, 0x000fe400078ec0ffULL,
0x000001e007057812ULL, 0x000fe200078ee205ULL, 0x0000000102077824ULL, 0x100fe200078e0203ULL,
0x000001e008067812ULL, 0x000fe200078ee206ULL, 0x0000000104037824ULL, 0x000fe400078e0203ULL,
0x00000000050c7984ULL, 0x000e62000000cc00ULL, 0x0000002002047824ULL, 0x040fe200078e00ffULL,
0x0000001f07077812ULL, 0x000fe200078ec0ffULL, 0x0000002002027824ULL, 0x000fe200078e00ffULL,
0x0000000006087984ULL, 0x000ea2000000cc00ULL, 0x0000001f03037812ULL, 0x000fc400078ec0ffULL,
0x000001e004077812ULL, 0x000fe400078ee207ULL, 0x000001e002037812ULL, 0x000fe200078ee203ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff137224ULL, 0x004fe400078e000aULL, 0x000000ffff127224ULL, 0x000fe400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0009ULL, 0x000000ffff087224ULL, 0x000fe200078e000dULL,
0x0000001005007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff097224ULL, 0x000fca00078e000fULL,
0x0000000806007388ULL, 0x000fe8000000cc00ULL, 0x0000000003087984ULL, 0x000e68000000cc00ULL,
0x00000000070c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff177224ULL, 0x002fe400078e000aULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff147224ULL, 0x004fe400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000001407007388ULL, 0x0003e8000000cc00ULL, 0x0000000803007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff067f8cULL, 0x002e62000c80043fULL,
0x000000ffff097224ULL, 0x000fc600078e00ffULL, 0x0000000000027805ULL, 0x000fc80000015200ULL,
0x01060400ff047984ULL, 0x000ea40000000800ULL, 0x8000000004ff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402087210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000804047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x000064001e037a24ULL, 0x000fe200078e02ffULL, 0x3d8000002a2a7820ULL, 0x010fe20000410000ULL,
0x00010688002b7811ULL, 0x000fe200078e18ffULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0xffffffff1a2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x00010608002d7811ULL, 0x000fe200078e28ffULL, 0x000000ffff2f7224ULL, 0x000fc400078e0000ULL,
0x000001002e317824ULL, 0x000fe200078e0228ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000311800720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e0030ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x0000000132347810ULL, 0x020fe20007ffe0ffULL, 0x00000d6000007945ULL, 0x000fe20003800000ULL,
0x000000ffff337224ULL, 0x000fc400078e0032ULL, 0x0000002e34357211ULL, 0x040fe200078ff0ffULL,
0x000000041b437c24ULL, 0x010fe2000f8e02ffULL, 0x000000043400780cULL, 0x040fe20003f06070ULL,
0x000000ffff327224ULL, 0x000fe200078e0034ULL, 0x0000000135307810ULL, 0x000fe40007ffe0ffULL,
0x0000000334547812ULL, 0x000fe400078ec0ffULL, 0x0000001a3000720cULL, 0x000fe40003f26070ULL,
0x0000000144307812ULL, 0x000fd600078e0cffULL, 0x000006c000009947ULL, 0x000fea0003800000ULL,
0x00000002ff3f7819ULL, 0x002fe20000011602ULL, 0x0000010035357824ULL, 0x000fe400078e0228ULL,
0x0000000200477824ULL, 0x000fe200078e0230ULL, 0x000000103f4e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129347824ULL, 0x000fe200078e023fULL, 0x000000083f467810ULL, 0x040fe40007ffe0ffULL,
0x000000183f4f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129387824ULL, 0x000fe200078e024eULL,
0x00000034433d7210ULL, 0x000fe20007f3e0ffULL, 0x0000000129367824ULL, 0x000fe200078e0246ULL,
0x0000003518377217ULL, 0x000fe20007800000ULL, 0x0000000446497824ULL, 0x000fe200078e00ffULL,
0x0000003843397210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x00000036433b7210ULL, 0x000fe20007f5e0ffULL, 0x0000000137457824ULL, 0x000fe200078e0a35ULL,
0x000000203f507810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005e0039387a11ULL, 0x000fe200078640ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e003b367a11ULL, 0x000fc400078440ffULL, 0x00005f0039397a11ULL, 0x000fe200018f443aULL,
0x00000001293a7824ULL, 0x000fe200078e024fULL, 0x000000283f517810ULL, 0x000fe40007ffe0ffULL,
0x00005e003d347a11ULL, 0x000fe400078240ffULL, 0x000000303f527810ULL, 0x040fe40007ffe0ffULL,
0x000000383f537810ULL, 0x000fe40007ffe0ffULL, 0x00005f003b377a11ULL, 0x000fe200010f443cULL,
0x00000001293b7824ULL, 0x000fe200078e0250ULL, 0x00005f003d357a11ULL, 0x000fe200008f443eULL,
0x00000001293c7824ULL, 0x000fe200078e0251ULL, 0x0000003a43427210ULL, 0x000fe20007f3e0ffULL,
0x00000001293d7824ULL, 0x000fe200078e0252ULL, 0x000000453f00720cULL, 0x000fe20003f46070ULL,
0x00000001293e7824ULL, 0x000fe200078e0253ULL, 0x0000003b43407210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200008e06ffULL, 0x0000003c433f7210ULL, 0x000fc40007fde0ffULL,
0x00000002023c7211ULL, 0x000fe400078fe8ffULL, 0x00005e00423a7a11ULL, 0x000fe200078240ffULL,
0x000000ffff4c7224ULL, 0x000fe200030e06ffULL, 0x0000003d43417210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200028e06ffULL, 0x0000003e43437210ULL, 0x000fe20007f7e0ffULL,
0x00000004543e7824ULL, 0x000fe200078e00ffULL, 0x000000033c4d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4b7224ULL, 0x000fe200020e06ffULL, 0x00005f00423b7a11ULL, 0x000fe200008f443bULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x000000454600720cULL, 0x000fc40003f26070ULL,
0x0000200047477811ULL, 0x000fe400078e60ffULL, 0x0ffffffc4d487812ULL, 0x100fe400078ef802ULL,
0xfffffffc3e467812ULL, 0x000fe400078ee202ULL, 0xfffffffc49497812ULL, 0x000fe200078ee24dULL,
0x0000001048487824ULL, 0x000fe200078e0247ULL, 0x00005e00403c7a11ULL, 0x000fe200078a40ffULL,
0x0000001046347825ULL, 0x000fe200078e0034ULL, 0x00005e0043427a11ULL, 0x000fc400078640ffULL,
0x00005f00403d7a11ULL, 0x000fe200028f443dULL, 0x0000001049497824ULL, 0x000fe200078e0247ULL,
0x00005e003f3e7a11ULL, 0x000fe200078a40ffULL, 0x0000001046367825ULL, 0x000fe200078e0036ULL,
0x00005e0041407a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034487faeULL, 0x0003e2000d101c46ULL, 0x00005f003f3f7a11ULL, 0x000fe400028f444cULL,
0x00005f0041417a11ULL, 0x000fe200020f444bULL, 0x0000000036497faeULL, 0x0005e2000c901c46ULL,
0x00005f0043437a11ULL, 0x000fe200018f444aULL, 0x00000004514a7824ULL, 0x000fe200078e00ffULL,
0x000000454e00720cULL, 0x080fe20003f26070ULL, 0x00000004524b7824ULL, 0x000fe200078e00ffULL,
0x000000454f00720cULL, 0x000fc40003f46070ULL, 0x000000455000720cULL, 0x080fe20003f66070ULL,
0x000000044f487824ULL, 0x002fe200078e00ffULL, 0x000000455100720cULL, 0x080fe20003f86070ULL,
0x0000001046347825ULL, 0x000fe200078e0038ULL, 0x000000455200720cULL, 0x080fe40003fa6070ULL,
0x000000455300720cULL, 0x040fe20003fc6070ULL, 0x000000044e457824ULL, 0x000fe200078e00ffULL,
0xfffffffc48487812ULL, 0x100fe200078ee24dULL, 0x0000000450497824ULL, 0x004fe200078e00ffULL,
0xfffffffc4a4a7812ULL, 0x100fe200078ee24dULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0xfffffffc45457812ULL, 0x000fe200078ee24dULL, 0x0000001048487824ULL, 0x000fe200078e0247ULL,
0xfffffffc49497812ULL, 0x000fe200078ee24dULL, 0x0000001046367825ULL, 0x000fe200078e003aULL,
0xfffffffc4b4b7812ULL, 0x000fc400078ee24dULL, 0xfffffffc534d7812ULL, 0x000fe200078ee24dULL,
0x0000001045457824ULL, 0x100fe400078e0247ULL, 0x0000001049497824ULL, 0x000fe400078e0247ULL,
0x0000001046387825ULL, 0x000fe200078e003cULL, 0x0000000034457faeULL, 0x0003e6000c901c46ULL,
0x000000104a4a7824ULL, 0x000fe200078e0247ULL, 0x0000000036487faeULL, 0x0003e2000d101c46ULL,
0x00000010463a7825ULL, 0x000fc600078e003eULL, 0x0000000038497faeULL, 0x0003e2000d901c46ULL,
0x000000104b4b7824ULL, 0x000fe400078e0247ULL, 0x00000010463c7825ULL, 0x040fe200078e0040ULL,
0x000000003a4a7faeULL, 0x0003e6000e101c46ULL, 0x000000104d477824ULL, 0x000fe200078e0247ULL,
0x000000003c4b7faeULL, 0x0003e2000e901c46ULL, 0x00000010463e7825ULL, 0x000fca00078e0042ULL,
0x000000003e477faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008023e7811ULL, 0x002fe200078ff0ffULL, 0x0000000454507824ULL, 0x000fe200078e00ffULL,
0x0000002902357211ULL, 0x040fe400078ff0ffULL, 0x0000001002407811ULL, 0x000fe200078ff0ffULL,
0x0000000129377824ULL, 0x000fe200078e023eULL, 0x0000004335357210ULL, 0x080fe20007f3e0ffULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x0000001802427811ULL, 0x040fe400078ff0ffULL,
0x0000004337377210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff397224ULL, 0x000fe200008e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078240ffULL, 0x00000001293b7824ULL, 0x000fe200078e0242ULL,
0x0000002002457811ULL, 0x000fe200078ff0ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078440ffULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x0000002802467811ULL, 0x040fe200078ff0ffULL, 0x00000001293d7824ULL, 0x000fe200078e0245ULL,
0x0000003002477811ULL, 0x000fc400078ff0ffULL, 0x0000003802487811ULL, 0x000fe200078ff0ffULL,
0x00000001293f7824ULL, 0x000fe200078e0246ULL, 0x00005f0035357a11ULL, 0x000fe200008f4439ULL,
0x0000000129397824ULL, 0x000fe200078e0240ULL, 0x00005f0037377a11ULL, 0x000fe200010f4438ULL,
0x0000000200387824ULL, 0x000fe200078e0230ULL, 0x00000002023a7211ULL, 0x000fe200078fe8ffULL,
0x0000000129417824ULL, 0x000fe200078e0247ULL, 0x0000004339397210ULL, 0x080fe20007fde0ffULL,
0x00000001293c7824ULL, 0x000fe200078e0248ULL, 0x000000433b3b7210ULL, 0x080fe20007fbe0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x000000433d3d7210ULL, 0x080fe20007f9e0ffULL,
0x0000000446497824ULL, 0x000fe200078e00ffULL, 0x000000433f3f7210ULL, 0x080fe20007f3e0ffULL,
0x00000004474a7824ULL, 0x000fe200078e00ffULL, 0x0000004341417210ULL, 0x080fe20007f5e0ffULL,
0x00000004484c7824ULL, 0x000fe200078e00ffULL, 0x00002000384b7811ULL, 0x000fe200078e60ffULL,
0x0000000445387824ULL, 0x000fe200078e00ffULL, 0x000000433c437210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4f7224ULL, 0x000fe200020e06ffULL, 0x000000033a3c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3a7224ULL, 0x000fe200030e06ffULL, 0xfffffffc50507812ULL, 0x000fe200078ee202ULL,
0x000000ffff4e7224ULL, 0x000fe200008e06ffULL, 0xfffffffc38487812ULL, 0x000fe200078ee23cULL,
0x000000ffff4d7224ULL, 0x000fe200010e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078c40ffULL,
0x0000001050347825ULL, 0x000fe200078e0034ULL, 0xfffffffc3e457812ULL, 0x000fc400078ee23cULL,
0xfffffffc40467812ULL, 0x100fe200078ee23cULL, 0x0000001048487824ULL, 0x100fe200078e024bULL,
0xfffffffc42477812ULL, 0x100fe200078ee23cULL, 0x0000001045457824ULL, 0x100fe200078e024bULL,
0xfffffffc49497812ULL, 0x100fe200078ee23cULL, 0x0000001046467824ULL, 0x100fe200078e024bULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee23cULL, 0x0000001047477824ULL, 0x100fe200078e024bULL,
0x0ffffffc3c3e7812ULL, 0x000fe200078ef802ULL, 0x0000001049497824ULL, 0x100fe200078e024bULL,
0xfffffffc4c407812ULL, 0x000fe200078ee23cULL, 0x000000ffff3c7224ULL, 0x000fe200028e06ffULL,
0x00005f0039397a11ULL, 0x000fe200030f443aULL, 0x000000103e517824ULL, 0x100fe200078e024bULL,
0x00005e003b3a7a11ULL, 0x000fe200078a40ffULL, 0x000000104a4a7824ULL, 0x100fe200078e024bULL,
0x00005e003f3e7a11ULL, 0x000fe200078240ffULL, 0x00000010404b7824ULL, 0x000fe200078e024bULL,
0x00005f003b3b7a11ULL, 0x000fe200028f443cULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034517faeULL, 0x0003e2000b901c46ULL, 0x00005e0041407a11ULL, 0x000fc400078440ffULL,
0x00005e0043427a11ULL, 0x000fe400078640ffULL, 0x00005f003d3d7a11ULL, 0x000fe400020f444fULL,
0x00005f003f3f7a11ULL, 0x000fe400008f444eULL, 0x00005f0041417a11ULL, 0x000fe400010f444dULL,
0x00005f0043437a11ULL, 0x000fe200018f444cULL, 0x0000001050347825ULL, 0x002fc800078e0036ULL,
0x0000001050367825ULL, 0x040fe200078e0038ULL, 0x0000000034457faeULL, 0x0003e6000b901c46ULL,
0x0000001050387825ULL, 0x040fe200078e003aULL, 0x0000000036467faeULL, 0x0003e6000b901c46ULL,
0x00000010503a7825ULL, 0x040fe200078e003cULL, 0x0000000038477faeULL, 0x0003e6000b901c46ULL,
0x00000010503c7825ULL, 0x040fe200078e003eULL, 0x000000003a487faeULL, 0x0003e6000b901c46ULL,
0x00000010503e7825ULL, 0x040fe200078e0040ULL, 0x000000003c497faeULL, 0x0003e6000b901c46ULL,
0x0000001050407825ULL, 0x000fe200078e0042ULL, 0x000000003e4a7faeULL, 0x0003e8000b901c46ULL,
0x00000000404b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035400780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x000000042f2f7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff1b7424ULL, 0x000fc600078e00ffULL, 0x000000192f00720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000203347824ULL, 0x002fe400078e022fULL,
0x00000004ff357424ULL, 0x000fc800078e00ffULL, 0x0000600034347625ULL, 0x000fca00078e0035ULL,
0x00000006341b7981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002002467810ULL, 0x002fe20007ffe0ffULL,
0x0000000200427824ULL, 0x000fe200078e0244ULL, 0xfffffff802417812ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe400078ec0ffULL,
0x0000000702437812ULL, 0x000fe400078ec0ffULL, 0x0000000741417812ULL, 0x100fe400078ef802ULL,
0x0000000746467812ULL, 0x000fc400078ef802ULL, 0x0000200042427811ULL, 0x000fe400078e60ffULL,
0x0000000843437812ULL, 0x000fe400078ef802ULL, 0x00000001ff447819ULL, 0x000fe40000011641ULL,
0x00000001ff457819ULL, 0x000fe20000011646ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000144347824ULL, 0x120fe200078e0240ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000441357824ULL, 0x000fe400078e00ffULL, 0x0000000145387824ULL, 0x000fc400078e0240ULL,
0x0000000446397824ULL, 0x000fe200078e00ffULL, 0xfffffffc35347812ULL, 0x000fc800078ee234ULL,
0xfffffffc39387812ULL, 0x000fe200078ee238ULL, 0x0000001034347824ULL, 0x000fc800078e0242ULL,
0x0000001038387824ULL, 0x000fe400078e0242ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000003838783bULL, 0x000ea20000000200ULL, 0x00000018ff3c7819ULL, 0x002fe20000011434ULL,
0x00010000343d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011436ULL,
0x0000003c00547306ULL, 0x0003e20000200c00ULL, 0x00000018ff4d7819ULL, 0x000fc40000011437ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff4a7819ULL, 0x004fe40000011438ULL,
0x00000018ff497819ULL, 0x000fe20000011439ULL, 0x0000003d00537306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x002fe40000011435ULL, 0x00000018ff487819ULL, 0x000fe4000001143aULL,
0x00000018ff477819ULL, 0x000fc6000001143bULL, 0x0000003c00587306ULL, 0x0003f00000200c00ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x00008880343c7816ULL, 0x042fe200000000ffULL,
0x0000010034347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000003c00527306ULL, 0x0002b00000200c00ULL, 0x0000003400557306ULL, 0x0006e20000200c00ULL,
0x00008880353c7816ULL, 0x002fc400000000ffULL, 0x0000541052527816ULL, 0x004fc60000000053ULL,
0x000000ffff347224ULL, 0x008fe400078e003cULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x00010000353c7824ULL, 0x040fe400078e00ffULL, 0x0000010035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003400567306ULL, 0x0003e20000200c00ULL, 0x0000541055537816ULL, 0x000fce0000000054ULL,
0x0000003500597306ULL, 0x0005e20000200c00ULL, 0x0000888036347816ULL, 0x002fce00000000ffULL,
0x00000034005a7306ULL, 0x0003e20000200c00ULL, 0x0001000036357824ULL, 0x044fe400078e00ffULL,
0x0000010036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003c00577306ULL, 0x000ea20000200c00ULL,
0x0000888037347816ULL, 0x002fce00000000ffULL, 0x00000035005b7306ULL, 0x0002f00000200c00ULL,
0x00000036005c7306ULL, 0x0006e20000200c00ULL, 0x0001000037357824ULL, 0x042fe200078e00ffULL,
0x0000541056567816ULL, 0x004fe20000000057ULL, 0x0000010037377824ULL, 0x000fe200078e00ffULL,
0x0000541059577816ULL, 0x000fc40000000058ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x00000034005d7306ULL, 0x0003e20000200c00ULL,
0x0000000140367810ULL, 0x008fe40007ffe0ffULL, 0x000054105a5a7816ULL, 0x000fe4000000005bULL,
0x000054105c5b7816ULL, 0x000fc60000000050ULL, 0x00000035005e7306ULL, 0x0004e20000200c00ULL,
0x0000888038347816ULL, 0x002fce00000000ffULL, 0x00000037005f7306ULL, 0x0002e20000200c00ULL,
0x0001000038357824ULL, 0x044fe400078e00ffULL, 0x0000010038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000000441377824ULL, 0x002fe200078e00ffULL, 0x0000003500617306ULL, 0x0003e20000200c00ULL,
0x000054105d5e7816ULL, 0x008fe4000000005eULL, 0x000054105f5f7816ULL, 0x000fca000000004dULL,
0x0000003400607306ULL, 0x0004e20000200c00ULL, 0x0000000144357824ULL, 0x102fe400078e0236ULL,
0x0000000145367824ULL, 0x000fc600078e0236ULL, 0xfffffffc37377812ULL, 0x000fe200078ee235ULL,
0x0001000039357824ULL, 0x040fe200078e00ffULL, 0x0000003800627306ULL, 0x0003e20000200c00ULL,
0x0000888039347816ULL, 0x044fe200000000ffULL, 0x0000010039397824ULL, 0x000fe400078e00ffULL,
0x0000001037377824ULL, 0x000fe200078e0242ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000003400637306ULL, 0x0005e20000200c00ULL,
0x00000000373c783bULL, 0x000ea20000000200ULL, 0x000088803b387816ULL, 0x002fc400000000ffULL,
0x0000541060607816ULL, 0x008fc80000000061ULL, 0x0000003500647306ULL, 0x0002e20000200c00ULL,
0x000088803a347816ULL, 0x004fce00000000ffULL, 0x0000003800697306ULL, 0x000fe20000200c00ULL,
0x0000000446357824ULL, 0x002fca00078e00ffULL, 0xfffffffc35367812ULL, 0x000fe200078ee236ULL,
0x000100003a357824ULL, 0x040fe200078e00ffULL, 0x0000003900657306ULL, 0x0003e20000200c00ULL,
0x000001003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541063647816ULL, 0x008fe20000000064ULL,
0x0000001036367824ULL, 0x000fe200078e0242ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003400667306ULL, 0x000fe20000200c00ULL,
0x000100003b397824ULL, 0x002fc400078e00ffULL, 0x000001003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00687306ULL, 0x0003e20000200c00ULL,
0x00000018ff387819ULL, 0x000fe4000001143cULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x000088803e747816ULL, 0x000fe400000000ffULL, 0x00000018ff517819ULL, 0x000fe2000001143fULL,
0x00000038006e7306ULL, 0x0005e20000200c00ULL, 0x00000004333a7824ULL, 0x002fe200078e0240ULL,
0x0000000240407810ULL, 0x000fc80007ffe0ffULL, 0x000000044000780cULL, 0x000fe40003f25270ULL,
0x00000039006a7306ULL, 0x0002e20000200c00ULL, 0x00000018ff387819ULL, 0x004fce000001143dULL,
0x0000003800727306ULL, 0x0005e20000200c00ULL, 0x000100003c397824ULL, 0x002fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003b006b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff387819ULL, 0x004fe4000001143eULL, 0x00005410696a7816ULL, 0x008fca000000006aULL,
0x0000003800767306ULL, 0x0005e20000200c00ULL, 0x000088803d3b7816ULL, 0x002fce00000000ffULL,
0x00000039006d7306ULL, 0x000fe20000200c00ULL, 0x000088803c387816ULL, 0x004fce00000000ffULL,
0x00000038006c7306ULL, 0x0002b00000200c00ULL, 0x0000003500677306ULL, 0x0006a20000200c00ULL,
0x000001003c387824ULL, 0x002fe400078e00ffULL, 0x000000023a3c7824ULL, 0x000fc400078e00ffULL,
0x00000020433a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011438ULL,
0x0000003c02387211ULL, 0x000fe200078fe0ffULL, 0x000000003634783bULL, 0x008e620000000200ULL,
0x00000039006f7306ULL, 0x0006e20000200c00ULL, 0x000000023c3c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000143387824ULL, 0x000fe200078e0238ULL, 0x000054106c6c7816ULL, 0x004fe4000000006dULL,
0x0000003c023c7211ULL, 0x000fc400078fe0ffULL, 0xffffffe03a387812ULL, 0x000fe200078ee238ULL,
0x000100003d3a7824ULL, 0x040fe200078e00ffULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x000000ffff397224ULL, 0x008fe200078e003bULL, 0x0000541066667816ULL, 0x000fe20000000067ULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x000001003d3d7824ULL, 0x000fe200078e00ffULL, 0x000054106f6d7816ULL, 0x000fe2000000006eULL,
0x00000001433c7824ULL, 0x000fe200078e023cULL, 0x0000003900707306ULL, 0x000fe40000200c00ULL,
0x00000018ff3d7819ULL, 0x000fcc000001143dULL, 0x0000003a00717306ULL, 0x0007e20000200c00ULL,
0x0000541062617816ULL, 0x004fce000000004aULL, 0x0000003d00737306ULL, 0x0005e20000200c00ULL,
0x000000003838783bULL, 0x008ee20000000200ULL, 0x0000888035507816ULL, 0x002fe400000000ffULL,
0x00000018ff4f7819ULL, 0x000fc80000011434ULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x000000ffff3d7224ULL, 0x004fe200078e0074ULL, 0x00000018ff4e7819ULL, 0x000fe20000011435ULL,
0x000100003e747824ULL, 0x040fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe20000011436ULL,
0x000001003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011437ULL,
0x000000ffff4d7224ULL, 0x000fe200078e0050ULL, 0x0000003d00757306ULL, 0x0005e20000200c00ULL,
0x0001000035507824ULL, 0x040fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000010035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fc40000011474ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000003e00777306ULL, 0x0003e20000200c00ULL,
0x000088803f3d7816ULL, 0x004fe400000000ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000541065657816ULL, 0x002fe40000000049ULL, 0x0000541070707816ULL, 0x000fe20000000071ULL,
0x0000003d00787306ULL, 0x0003e20000200c00ULL, 0x000100003f3e7824ULL, 0x000fe200078e00ffULL,
0x0000541073717816ULL, 0x000fe20000000072ULL, 0x000001003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000004800487306ULL, 0x000ea20000200c00ULL,
0x00008880343d7816ULL, 0x002fe200000000ffULL, 0x000000523824723cULL, 0x008b620000001824ULL,
0x00000018ff3f7819ULL, 0x000fca000001143fULL, 0x0000003d00527306ULL, 0x0203e40000200c00ULL,
0x000000563820723cULL, 0x040f6c0000001820ULL, 0x0000003e00797306ULL, 0x0007e20000200c00ULL,
0x00000020433d7824ULL, 0x002fe200078e00ffULL, 0x0000541068677816ULL, 0x004fe20000000048ULL,
0x0000005a381c723cULL, 0x000fe2000000181cULL, 0x0001000036487824ULL, 0x000fc400078e00ffULL,
0xffffffe03d3c7812ULL, 0x000fe200078ee23cULL, 0x00000100343d7824ULL, 0x040fe200078e00ffULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x00010000343e7824ULL, 0x008fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000005e3814723cULL, 0x040fe20000001814ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003f00547306ULL, 0x000fea0000200c00ULL,
0x000000603810723cULL, 0x000f660000001810ULL, 0x0000003e00347306ULL, 0x000ea20000200c00ULL,
0x000054106b6b7816ULL, 0x002fc80000000047ULL, 0x00000064380c723cULL, 0x040f66000000180cULL,
0x0000003d00537306ULL, 0x0003ea0000200c00ULL, 0x000000663808723cULL, 0x000f660000001808ULL,
0x00000050004a7306ULL, 0x0007e20000200c00ULL, 0x000000003c3c783bULL, 0x002e620000000200ULL,
0x0000541052347816ULL, 0x004fc60000000034ULL, 0x0000006a3804723cULL, 0x000b660000001804ULL,
0x0000003500497306ULL, 0x0005e20000200c00ULL, 0x0000888036507816ULL, 0x048fe200000000ffULL,
0x0000010036367824ULL, 0x000fe400078e00ffULL, 0x0001000037387824ULL, 0x020fc600078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000004f004f7306ULL, 0x000ee20000200c00ULL,
0x000000ffff357224ULL, 0x004fe200078e0050ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000541078507816ULL, 0x000fc80000000079ULL, 0x0000003500557306ULL, 0x0005f00000200c00ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000888037357816ULL, 0x044fe200000000ffULL,
0x0000010037377824ULL, 0x000fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000007400747306ULL, 0x000ea20000200c00ULL, 0x0000006c3c24723cULL, 0x042f6e0000001824ULL,
0x0000003500397306ULL, 0x0007e20000200c00ULL, 0x000000703c20723cULL, 0x000f6e0000001820ULL,
0x0000003800387306ULL, 0x000e620000200c00ULL, 0x0000541053357816ULL, 0x008fc4000000004fULL,
0x0000541075747816ULL, 0x004fe40000000074ULL, 0x0000541077757816ULL, 0x000fc60000000076ULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x000000343c10723cULL, 0x040b6e0000001810ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541049357816ULL, 0x020fe2000000004eULL,
0x000000743c1c723cULL, 0x000b62000000181cULL, 0x0000541039387816ULL, 0x002fca0000000038ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541054517816ULL, 0x004fce0000000051ULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000000503c14723cULL, 0x000b6e0000001814ULL,
0x0000004800487306ULL, 0x000eb00000200c00ULL, 0x0000003600367306ULL, 0x000ee20000200c00ULL,
0x000054104d347816ULL, 0x002fce000000004aULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000541055487816ULL, 0x004fe20000000048ULL, 0x000000343c0c723cULL, 0x000b62000000180cULL,
0x0000541036497816ULL, 0x008fce000000004cULL, 0x000000483c08723cULL, 0x000b620000001808ULL,
0x0000541037397816ULL, 0x002fce000000004bULL, 0x000000383c04723cULL, 0x000b620000001804ULL,
0xfffff03000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff447224ULL, 0x000fe200078e0030ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe0d000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000002a16347220ULL, 0x0a0fe20000410000ULL, 0x0000002a1e327220ULL, 0x080fe20000410000ULL,
0x0000002a17357220ULL, 0x080fe20000410000ULL, 0x0000002a10167220ULL, 0x080fe20000410000ULL,
0x0000002a1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002a1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002a1f337220ULL, 0x080fe20000410000ULL, 0x0000002a11177220ULL, 0x080fe20000410000ULL,
0x0000002a0c1e7220ULL, 0x080fe20000410000ULL, 0x0000002a24247220ULL, 0x080fe20000410000ULL,
0x0000002a25257220ULL, 0x080fe20000410000ULL, 0x0000002a20207220ULL, 0x080fe20000410000ULL,
0x0000002a21217220ULL, 0x080fe20000410000ULL, 0x0000002a14147220ULL, 0x080fe20000410000ULL,
0x0000002a15157220ULL, 0x080fe20000410000ULL, 0x0000002a0d1f7220ULL, 0x080fe20000410000ULL,
0x0000002a08087220ULL, 0x080fe20000410000ULL, 0x0000002a09097220ULL, 0x080fe20000410000ULL,
0x0000002a04047220ULL, 0x080fe20000410000ULL, 0x0000002a12367220ULL, 0x080fe20000410000ULL,
0x0000002a13377220ULL, 0x080fe20000410000ULL, 0x0000002a0e387220ULL, 0x080fe20000410000ULL,
0x0000002a0f397220ULL, 0x080fe20000410000ULL, 0x000000ffff127224ULL, 0x000fe200078e0016ULL,
0x0000002a0a3a7220ULL, 0x080fe20000410000ULL, 0x0000002a0b3b7220ULL, 0x080fe20000410000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e001cULL, 0x0000002a26267220ULL, 0x080fe20000410000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e001dULL, 0x0000002a27277220ULL, 0x080fe20000410000ULL,
0x000000ffff137224ULL, 0x000fe200078e0017ULL, 0x0000002a22227220ULL, 0x080fe20000410000ULL,
0x000000ffff167224ULL, 0x000fe200078e001eULL, 0x0000002a23237220ULL, 0x080fe20000410000ULL,
0x0000002a05057220ULL, 0x080fe20000410000ULL, 0x0000002a06067220ULL, 0x080fe20000410000ULL,
0x0000002a07077220ULL, 0x000fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fc400078e0024ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0025ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0021ULL, 0x000000ffff107224ULL, 0x000fe400078e0014ULL,
0x000000ffff117224ULL, 0x000fe400078e0015ULL, 0x000000ffff177224ULL, 0x000fc400078e001fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002b087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fe400078e0026ULL,
0x000000ffff217224ULL, 0x000fe400078e0027ULL, 0x000000ffff247224ULL, 0x000fc400078e0032ULL,
0x000000ffff257224ULL, 0x000fe400078e0033ULL, 0x000000ffff267224ULL, 0x000fe400078e0034ULL,
0x000000ffff277224ULL, 0x000fe400078e0035ULL, 0x000000ffff327224ULL, 0x000fe400078e0036ULL,
0x000000ffff337224ULL, 0x000fe400078e0037ULL, 0x000000ffff347224ULL, 0x000fc400078e0038ULL,
0x000000ffff357224ULL, 0x000fe400078e0039ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0005ULL,
0x000000ffff367224ULL, 0x000fe400078e003aULL, 0x000000ffff377224ULL, 0x000fe400078e003bULL,
0x000000ffff387224ULL, 0x000fe400078e0006ULL, 0x000000ffff397224ULL, 0x000fc400078e0007ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x000004002b067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604147210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000001406067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000115157810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004002b067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000402157824ULL, 0x000fe200078e00ffULL,
0x0000002c2e00720cULL, 0x000fc80003f05270ULL, 0xfffffff015147812ULL, 0x000fca00078ec0ffULL,
0x0000008000147824ULL, 0x000fca00078e0214ULL, 0x0104000014047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202087824ULL, 0x000fe400078e00ffULL,
0x0000000118317824ULL, 0x000fc600078e0a31ULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108097812ULL, 0x040fe400078efcffULL, 0x00000008083a7812ULL, 0x040fe400078efcffULL,
0x000000310900720cULL, 0x080fe40003f26070ULL, 0x0000001008097812ULL, 0x000fe400078efcffULL,
0x000000313a00720cULL, 0x080fe40003f06070ULL, 0x000000310900720cULL, 0x000fc40003fc6070ULL,
0x00000011083a7812ULL, 0x040fe400078efcffULL, 0x0000001808097812ULL, 0x040fe400078efcffULL,
0x000000310800720cULL, 0x080fe40003f46070ULL, 0x000000313a00720cULL, 0x080fe40003fa6070ULL,
0x000000310900720cULL, 0x000fe40003f66070ULL, 0x00000009083b7812ULL, 0x000fc400078efcffULL,
0x00000019083a7812ULL, 0x040fe400078efcffULL, 0x0000002008097812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40005000000ULL, 0xff8000000a0a7808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0xff8000000b0b7808ULL, 0x000fc40004800000ULL,
0x000000313b00720cULL, 0x080fe40003f86070ULL, 0x000000313a00720cULL, 0x080fe40003f46070ULL,
0x000000310900720cULL, 0x000fe40003f26070ULL, 0x00000021083a7812ULL, 0x040fe400078efcffULL,
0x0000002808097812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fc40004000000ULL,
0xff8000000c0c7808ULL, 0x000fe40004000000ULL, 0xff80000023237808ULL, 0x000fe40006000000ULL,
0xff8000000d0d7808ULL, 0x000fe40006000000ULL, 0x000000313a00720cULL, 0x080fe40003f06070ULL,
0x000000310900720cULL, 0x000fe40003f86070ULL, 0x00000029083a7812ULL, 0x000fc400078efcffULL,
0x0000003008097812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40007000000ULL,
0xff8000000e0e7808ULL, 0x000fe40007000000ULL, 0xff80000025257808ULL, 0x000fe40006800000ULL,
0xff8000000f0f7808ULL, 0x000fe40006800000ULL, 0x000000313a00720cULL, 0x000fc40003fc6070ULL,
0x000000310900720cULL, 0x000fe40003fa6070ULL, 0x00000031083a7812ULL, 0x040fe400078efcffULL,
0x0000003808097812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff80000026267808ULL, 0x000fe40005800000ULL, 0xff80000010107808ULL, 0x000fc40005800000ULL,
0xff80000027277808ULL, 0x000fe40005000000ULL, 0xff80000011117808ULL, 0x000fe40005000000ULL,
0xff80000032327808ULL, 0x000fe40004800000ULL, 0xff80000012127808ULL, 0x000fe40004800000ULL,
0x000000313a00720cULL, 0x080fe40003f66070ULL, 0x000000310900720cULL, 0x000fc40003f46070ULL,
0x000000310800720cULL, 0x000fe40003f26070ULL, 0xff80000033337808ULL, 0x000fe40004000000ULL,
0xff80000013137808ULL, 0x000fe40004000000ULL, 0xff80000034347808ULL, 0x000fe40006000000ULL,
0xff80000016167808ULL, 0x000fe40006000000ULL, 0xff80000035357808ULL, 0x000fc40007000000ULL,
0xff80000017177808ULL, 0x000fe40007000000ULL, 0xff80000036367808ULL, 0x000fe40006800000ULL,
0xff8000001c1c7808ULL, 0x000fe40006800000ULL, 0xff80000037377808ULL, 0x000fe40005800000ULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff80000038387808ULL, 0x000fc40005000000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff80000039397808ULL, 0x000fe40004800000ULL,
0xff8000001f1f7808ULL, 0x000fc40004800000ULL, 0x0000000a0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x000000200500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x000000040a047208ULL, 0x000fe40004000000ULL,
0x0000000520057208ULL, 0x000fc40004800000ULL, 0x0000000b0400720bULL, 0x000fe40003f1e000ULL,
0x000000210500720bULL, 0x000fe40003f3e000ULL, 0x000000040b047208ULL, 0x000fe40004000000ULL,
0x0000000521057208ULL, 0x000fe40004800000ULL, 0x0000000c0400720bULL, 0x000fe40003f1e000ULL,
0x000000220500720bULL, 0x000fc40003f3e000ULL, 0x000000040c047208ULL, 0x000fe40004000000ULL,
0x0000000522057208ULL, 0x000fe40004800000ULL, 0x0000000d0400720bULL, 0x000fe40003f1e000ULL,
0x000000230500720bULL, 0x000fe40003f3e000ULL, 0x000000040d047208ULL, 0x000fe40004000000ULL,
0x0000000523057208ULL, 0x000fc40004800000ULL, 0x0000000e0400720bULL, 0x000fe40003f1e000ULL,
0x000000240500720bULL, 0x000fe40003f3e000ULL, 0x000000040e047208ULL, 0x000fe40004000000ULL,
0x0000000524057208ULL, 0x000fe40004800000ULL, 0x0000000f0400720bULL, 0x000fe40003f1e000ULL,
0x000000250500720bULL, 0x000fc40003f3e000ULL, 0x000000040f047208ULL, 0x000fe40004000000ULL,
0x0000000525057208ULL, 0x000fe40004800000ULL, 0x000000100400720bULL, 0x000fe40003f1e000ULL,
0x000000260500720bULL, 0x000fe40003f3e000ULL, 0x0000000410047208ULL, 0x000fe40004000000ULL,
0x0000000526057208ULL, 0x000fc40004800000ULL, 0x000000110400720bULL, 0x000fe40003f1e000ULL,
0x000000270500720bULL, 0x000fe40003f3e000ULL, 0x0000000411047208ULL, 0x000fe40004000000ULL,
0x0000000527057208ULL, 0x000fe40004800000ULL, 0x000000120400720bULL, 0x000fe40003f1e000ULL,
0x000000320500720bULL, 0x000fc40003f3e000ULL, 0x0000000412047208ULL, 0x000fe40004000000ULL,
0x0000000532057208ULL, 0x000fe40004800000ULL, 0x000000130400720bULL, 0x000fe40003f1e000ULL,
0x000000330500720bULL, 0x000fe40003f3e000ULL, 0x0000000413047208ULL, 0x000fe40004000000ULL,
0x0000000533057208ULL, 0x000fc40004800000ULL, 0x000000160400720bULL, 0x000fe40003f1e000ULL,
0x000000340500720bULL, 0x000fe40003f3e000ULL, 0x0000000416047208ULL, 0x000fe40004000000ULL,
0x0000000534057208ULL, 0x000fe40004800000ULL, 0x000000170400720bULL, 0x000fe40003f1e000ULL,
0x000000350500720bULL, 0x000fc40003f3e000ULL, 0x0000000417047208ULL, 0x000fe40004000000ULL,
0x0000000535057208ULL, 0x000fe40004800000ULL, 0x0000001c0400720bULL, 0x000fe40003f1e000ULL,
0x000000360500720bULL, 0x000fe40003f3e000ULL, 0x000000041c047208ULL, 0x000fe40004000000ULL,
0x0000000536057208ULL, 0x000fc40004800000ULL, 0x0000001d0400720bULL, 0x000fe40003f1e000ULL,
0x000000370500720bULL, 0x000fe40003f3e000ULL, 0x000000041d047208ULL, 0x000fe40004000000ULL,
0x0000000537057208ULL, 0x000fe40004800000ULL, 0x0000001e0400720bULL, 0x000fe40003f1e000ULL,
0x000000380500720bULL, 0x000fc40003f3e000ULL, 0x000000041e047208ULL, 0x000fe40004000000ULL,
0x0000000538057208ULL, 0x000fe40004800000ULL, 0x0000001f0400720bULL, 0x000fe40003f1e000ULL,
0x000000390500720bULL, 0x000fe40003f3e000ULL, 0x000000041f3b7208ULL, 0x000fe40004000000ULL,
0x0000000539057208ULL, 0x000fe20004800000ULL, 0x000018727f007947ULL, 0x000fec000b800000ULL,
0x0c401f003b047f89ULL, 0x0004e400000e0000ULL, 0x000000043b00720bULL, 0x008fc80003f1e000ULL,
0x0000003b043b7208ULL, 0x004fe20004000000ULL, 0x000018927f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006087f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007097f89ULL, 0x000e6200000e0000ULL, 0x000000040500720bULL, 0x004fc40003f1e000ULL,
0x000000080600720bULL, 0x008fe40003f3e000ULL, 0x0000000504057208ULL, 0x000fe40004000000ULL,
0x0000000608067208ULL, 0x000fe20004800000ULL, 0x0c201f003b047f89ULL, 0x000ea200000e0000ULL,
0x000000090700720bULL, 0x002fc60003f1e000ULL, 0x0c201f0005087f89ULL, 0x000e6200000e0000ULL,
0x0000000709077208ULL, 0x000fc60004000000ULL, 0x0c201f0006317f89ULL, 0x000ee800000e0000ULL,
0x0c201f00073a7f89ULL, 0x0002e200000e0000ULL, 0x000000043b00720bULL, 0x004fe40003f1e000ULL,
0x000000080500720bULL, 0x002fe40003f3e000ULL, 0x0000003b04047208ULL, 0x000fe40004000000ULL,
0x000000310600720bULL, 0x008fc40003f5e000ULL, 0x0000000508057208ULL, 0x000fe40004800000ULL,
0x0000000631067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL,
0x3c003c00ff427424ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff437424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010808ULL, 0x0000001c003e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010808ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b051c7820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fe20000010808ULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b20207823ULL, 0x000fe2000001081cULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b1f087823ULL, 0x000fe20000010808ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001081cULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b39397823ULL, 0x000fe2000001081cULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x0000000c15157812ULL, 0x000fc400078ec0ffULL,
0x0000000302ff7812ULL, 0x000fe4000780c0ffULL, 0x0000003a0700720bULL, 0x004fc60003f3e000ULL,
0x0000002000097308ULL, 0x000fe20000000800ULL, 0x000000073a077208ULL, 0x000fce0004800000ULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x000000092109723eULL, 0x002fce00000000ffULL,
0x0000000800417308ULL, 0x0003f00000000800ULL, 0x0000001000317308ULL, 0x000fe20000000800ULL,
0x0000000a0b08723eULL, 0x002fe400000000ffULL, 0x0000000c0d0a723eULL, 0x000fc400000000ffULL,
0x00000022230b723eULL, 0x004fc600000000ffULL, 0x00000011003b7308ULL, 0x000ff00000000800ULL,
0x00000012003c7308ULL, 0x000ff00000000800ULL, 0x00000013003d7308ULL, 0x0003f00000000800ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x000000420810723cULL, 0x002f6e00000018ffULL,
0x0000000f000f7308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x0000000e0f0c723eULL, 0x002fc400000000ffULL,
0x000000313b0e723eULL, 0x000fe400000000ffULL, 0x00000002ff3b7819ULL, 0x000fc60000011602ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000013b207810ULL, 0x040fe40007ffe0ffULL,
0x000000023b217810ULL, 0x040fe40007ffe0ffULL, 0x000000063b317810ULL, 0x000fc60007ffe0ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x00000024250d723eULL, 0x004fe200000000ffULL,
0x000000083b247824ULL, 0x040fe400078e00ffULL, 0x000000083b257824ULL, 0x000fc600078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee220ULL, 0x0000001d003f7308ULL, 0x000fe20000000800ULL,
0xfffffff825257812ULL, 0x000fe400078ee221ULL, 0x00000026270f723eULL, 0x002fca00000000ffULL,
0x0000001e00407308ULL, 0x0003e20000000800ULL, 0x000000083b267824ULL, 0x040fe400078e00ffULL,
0x000000083b277824ULL, 0x000fca00078e00ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000420c1c723cULL, 0x022b6e0000001810ULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000033b107810ULL, 0x060fe40007ffe0ffULL, 0x000000043b117810ULL, 0x000fc40007ffe0ffULL,
0xfffffff826267812ULL, 0x000fe400078ee210ULL, 0xfffffff827277812ULL, 0x000fe200078ee211ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x0000003c3d10723eULL, 0x000fce00000000ffULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x000000161712723eULL, 0x002fe200000000ffULL,
0x000000083b167824ULL, 0x040fe200078e00ffULL, 0x000000053b177810ULL, 0x000fc80007ffe0ffULL,
0xfffffff816167812ULL, 0x000fe200078ee23bULL, 0x0000003400347308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x000000323311723eULL, 0x004fc400000000ffULL,
0x000000083b337810ULL, 0x040fe40007ffe0ffULL, 0xffffffff3b327810ULL, 0x000fc60007ffe0ffULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000343513723eULL, 0x002fce00000000ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000083b347824ULL, 0x040fe400078e00ffULL,
0x000000083b357824ULL, 0x040fe400078e00ffULL, 0x000000083b3b7824ULL, 0x000fe200078e00ffULL,
0x000000421020723cULL, 0x000b62000000181cULL, 0xfffffff834177812ULL, 0x000fe200078ee217ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x0000a00000347811ULL, 0x000fe400078e58ffULL,
0xfffffff835317812ULL, 0x000fc400078ee231ULL, 0x00000008331c7824ULL, 0x020fe200078e00ffULL,
0x00000040411e723eULL, 0x000fe200000000ffULL, 0x0000001016167824ULL, 0x100fe200078e0234ULL,
0x0000003900397308ULL, 0x000ea20000000800ULL, 0x00000036371d723eULL, 0x002fe200000000ffULL,
0x0000001024247824ULL, 0x100fe200078e0234ULL, 0xfffffff81c337812ULL, 0x000fe200078ee233ULL,
0x0000001025257824ULL, 0x100fe200078e0234ULL, 0x0000003e3f1c723eULL, 0x000fe200000000ffULL,
0x0000001026267824ULL, 0x000fe200078e0234ULL, 0xfffffff83b327812ULL, 0x000fe200078ee232ULL,
0x0000001027277824ULL, 0x000fc400078e0234ULL, 0x0000000116167824ULL, 0x000fe400078e0215ULL,
0x0000001017177824ULL, 0x000fe400078e0234ULL, 0x0000000115247824ULL, 0x000fe200078e0224ULL,
0x0000000816007388ULL, 0x0003e20000000800ULL, 0x00000038391f723eULL, 0x004fe200000000ffULL,
0x0000001031317824ULL, 0x100fe400078e0234ULL, 0x0000000115257824ULL, 0x000fe200078e0225ULL,
0x0000000a24007388ULL, 0x0003e20000000800ULL, 0x0000001032327824ULL, 0x000fc400078e0234ULL,
0x000000421c20723cULL, 0x000f620000001820ULL, 0x0000000115267824ULL, 0x000fe200078e0226ULL,
0x0000000c25007388ULL, 0x0003e20000000800ULL, 0x0000001033337824ULL, 0x000fe400078e0234ULL,
0x0000000115277824ULL, 0x040fe200078e0227ULL, 0x0000000e26007388ULL, 0x0003e20000000800ULL,
0x0000000115177824ULL, 0x040fe400078e0217ULL, 0x0000000115317824ULL, 0x040fe200078e0231ULL,
0x0000001027007388ULL, 0x0003e20000000800ULL, 0x0000000115327824ULL, 0x000fc400078e0232ULL,
0x0000000115337824ULL, 0x000fe200078e0233ULL, 0x0000001217007388ULL, 0x0003e80000000800ULL,
0x0000001c31007388ULL, 0x0003e80000000800ULL, 0x0000001e32007388ULL, 0x0003e40000000800ULL,
0x000000ffff217224ULL, 0x020fc400078e0022ULL, 0x0000000933007388ULL, 0x0003e80000000800ULL,
0x0004000b24007388ULL, 0x0003e80000000800ULL, 0x0004000d25007388ULL, 0x0003e80000000800ULL,
0x0004000f26007388ULL, 0x0003e80000000800ULL, 0x0004001127007388ULL, 0x0003e80000000800ULL,
0x0004001317007388ULL, 0x0003e80000000800ULL, 0x0004001d31007388ULL, 0x0003e80000000800ULL,
0x0004001f32007388ULL, 0x0003e80000000800ULL, 0x0100000414008388ULL, 0x0003e80000000c00ULL,
0x0102002014008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002dff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008002dff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010002dff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000012e2e7810ULL, 0x000fe20007ffe0ffULL, 0x000018002dff7f8cULL, 0x0003e6000c80043fULL,
0x0000001a2e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffc33000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff447807ULL, 0x004fe40004000000ULL, 0x0001813000457802ULL, 0x000fc40000000f00ULL,
0x0000103000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e004aULL,
0xfffe9fc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x000fe40005000000ULL,
0x0001818000457802ULL, 0x000fc40000000f00ULL, 0x00000fe000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e004aULL, 0xfffea02000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4e7224ULL, 0x002fe200078e002cULL, 0x000181d000447802ULL, 0x000fc40000000f00ULL,
0x00000f5000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff457224ULL, 0x004fe200078e004eULL,
0xfffea0c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e002cULL,
0x0001822000447802ULL, 0x000fc40000000f00ULL, 0x00000f0000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff457224ULL, 0x004fe200078e004eULL, 0xfffea1e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0029ULL, 0x0001828000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff457224ULL, 0x000fc400078e002aULL, 0x00000ea000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e004eULL, 0xfffea5d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff457224ULL, 0x000fe200078e0028ULL, 0x000182e000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff4e7224ULL, 0x000fc400078e0029ULL, 0x00000e4000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e004eULL, 0xfffea5a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0004ULL, 0x0001834000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff457224ULL, 0x000fc400078e0005ULL, 0x00000de000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e004eULL, 0xfffec41000007947ULL, 0x000fea000383ffffULL,
0x000000ffff457224ULL, 0x000fe200078e0028ULL, 0x000183a000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff4e7224ULL, 0x000fc400078e0004ULL, 0x00000d8000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e004eULL, 0xfffec3e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff447807ULL, 0x008fe40004000000ULL, 0x000183f000457802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff497224ULL, 0x000fe200078e004aULL,
0xfffee2d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x000fe40005000000ULL,
0x0001844000457802ULL, 0x000fc40000000f00ULL, 0x00000d2000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff467224ULL, 0x000fe200078e004aULL, 0xfffee31000007947ULL, 0x000fea000383ffffULL,
0x000000ffff457224ULL, 0x000fe200078e0044ULL, 0x000184a000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff4e7224ULL, 0x000fc400078e004aULL, 0x00000c8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff447224ULL, 0x004fe200078e004eULL, 0xfffee3c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff457224ULL, 0x000fe200078e0044ULL, 0x0001850000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff4e7224ULL, 0x000fc400078e004aULL, 0x00000c2000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff447224ULL, 0x004fe200078e004eULL, 0xfffee4c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0043ULL, 0x0001856000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff457224ULL, 0x000fc400078e0047ULL, 0x00000bc000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e004eULL, 0xfffee8f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff457224ULL, 0x000fe200078e0028ULL, 0x000185c000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff4e7224ULL, 0x000fc400078e0043ULL, 0x00000b6000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e004eULL, 0xfffee8c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0048ULL, 0x0001862000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff457224ULL, 0x000fc400078e0049ULL, 0x00000b0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e004eULL, 0xffff051000007947ULL, 0x000fea000383ffffULL,
0x000000ffff457224ULL, 0x000fe200078e0028ULL, 0x0001868000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff4e7224ULL, 0x000fc400078e0048ULL, 0x00000aa000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e004eULL, 0xffff04e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff447807ULL, 0x008fe40004000000ULL, 0x000186d000457802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff497224ULL, 0x000fe200078e004aULL,
0xffff22b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x000fe40005000000ULL,
0x0001872000457802ULL, 0x000fc40000000f00ULL, 0x00000a4000007944ULL, 0x014fea0003c00000ULL,
0xffff230000007947ULL, 0x000fea000383ffffULL, 0x000000ffff457224ULL, 0x000fe200078e0044ULL,
0x0001877000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e004bULL,
0x000009b000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff447224ULL, 0x004fe200078e004eULL,
0xffff23b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff457224ULL, 0x000fe200078e0044ULL,
0x000187d000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e004bULL,
0x0000095000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff447224ULL, 0x004fe200078e004eULL,
0xffff24b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0043ULL,
0x0001883000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff457224ULL, 0x000fc400078e0046ULL,
0x000008f000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e004eULL,
0xffff28e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff457224ULL, 0x000fe200078e0028ULL,
0x0001889000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0043ULL,
0x0000089000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e004eULL,
0xffff28b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0046ULL,
0x000188f000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff457224ULL, 0x000fc400078e0047ULL,
0x0000083000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e004eULL,
0xffff450000007947ULL, 0x000fea000383ffffULL, 0x000000ffff457224ULL, 0x000fe200078e0028ULL,
0x0001895000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0046ULL,
0x000007d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e004eULL,
0xffff44d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x008fe40004000000ULL,
0x000189a000457802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff497224ULL, 0x000fe200078e004aULL, 0xffff62b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff447807ULL, 0x000fe40004800000ULL, 0x000189f000457802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff237224ULL, 0x000fe200078e004aULL,
0xffff62f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff457224ULL, 0x000fe200078e0022ULL,
0x00018a5000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0046ULL,
0x000006d000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff227224ULL, 0x004fe200078e004eULL,
0xffff63a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0046ULL,
0x00018ab000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff457224ULL, 0x000fc400078e0022ULL,
0x0000067000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff227224ULL, 0x004fe200078e004eULL,
0xffff64a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0022ULL,
0x00018b1000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff457224ULL, 0x000fc400078e0023ULL,
0x0000061000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e004eULL,
0xffff68d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff457224ULL, 0x000fe200078e0028ULL,
0x00018b7000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0022ULL,
0x000005b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e004eULL,
0xffff68a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0021ULL,
0x00018bd000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff457224ULL, 0x000fc400078e0022ULL,
0x0000055000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e004eULL,
0xffff851000007947ULL, 0x000fea000383ffffULL, 0x000000ffff457224ULL, 0x000fe200078e0028ULL,
0x00018c3000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0021ULL,
0x000004f000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e004eULL,
0xffff84e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e003bULL,
0x00018c9000317802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fc400078e00ffULL,
0x0000044000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e003aULL,
0xffffe74000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x00018cf000317802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x012fea0003c00000ULL, 0x0000003a0500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0006ULL, 0x00018d5000317802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0x000000053a057208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x00018db000317802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0x000000063a067208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e003bULL, 0x00018e1000317802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000073a077208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x0000003a3b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x00018e7000317802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000003b3a047208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0006ULL, 0x00018ed000317802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000053a057208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x00018f3000317802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000063a067208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe61000007947ULL, 0x000fea000383ffffULL,
0x0180000003027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000300028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000204ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000003037812ULL, 0x002fe400078ec0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000204ff7212ULL, 0x000fda000780c0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000300027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x002fc800078e00ffULL,
0xfffe6f3002007950ULL, 0x000fea0003c3ffffULL, 0x0000003d00007348ULL, 0x000fe80003800000ULL,
0x0c000009083a7389ULL, 0x0002a400000e003cULL, 0x000000ffff087224ULL, 0x002fe400078e0031ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe6ee008007950ULL, 0x000fea0003c3ffffULL,
0x0000002500007348ULL, 0x000fe80003800000ULL, 0x000000454e4e7389ULL, 0x0002a400000e0024ULL,
0x00000000ff457424ULL, 0x002fc800078e00ffULL, 0xfffe6ea044007950ULL, 0x000fea0003c3ffffULL,
0x000000014400780cULL, 0x000fe20003f45070ULL, 0x0000002300007348ULL, 0x000fd80003800000ULL,
0x0000000000447806ULL, 0x000fc800050e0100ULL, 0x00000023444a7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff447224ULL, 0x000fe400078e0045ULL, 0x00000000ff457424ULL, 0x000fc800078e00ffULL,
0xfffe6e3044007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005dfULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x00000000000004d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ea0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001968ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001978ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001a08ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001a0cULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001c00ULL, 0x0000000000019280ULL, 0x8d00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001ae80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001aed0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b250ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001a08ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019478ULL, 0x0000000000019478ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001ae80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b250ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 111408;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
