/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000198b0ULL, 0x0000000000019530ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL, 0x326a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45386aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x5f24000000000000ULL,
0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL, 0x5f6e725f7063725fULL,
0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL, 0x656e72656b2e7478ULL,
0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x72656b240061686dULL,
0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL, 0x656d6172665f6775ULL,
0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL, 0x72665f6775626564ULL,
0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x0000000061686d5fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000036eULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000003b5ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000403ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000448ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000004a3ULL, 0x0000000000017d60ULL, 0x0000000000000220ULL, 0x0004000300000519ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000017f80ULL, 0x000d000300000549ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00017d6000000000ULL, 0x0000740400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808592ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL, 0x00017d6000000000ULL,
0x0000022000000000ULL, 0x0000580400000000ULL, 0x8082288080850900ULL, 0x0000000000002880ULL,
0x0000001600082f04ULL, 0x000823040000007aULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b82904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x00b82804ffffffffULL, 0x00000130000000e0ULL, 0x000022d000000790ULL,
0x000023f000002330ULL, 0x000029c000002530ULL, 0x00004610000029d0ULL, 0x0000622000004620ULL,
0x0000635000006280ULL, 0x0000684000006490ULL, 0x000082e000006850ULL, 0x00009e30000082f0ULL,
0x00009f6000009e90ULL, 0x0000a4500000a0a0ULL, 0x0000bef00000a460ULL, 0x0000da400000bf00ULL,
0x0000db700000daa0ULL, 0x0000e0600000dcb0ULL, 0x0000fb200000e070ULL, 0x00010b800000fb30ULL,
0x000113e000010b90ULL, 0x00017260000171b0ULL, 0x0001751000017490ULL, 0x0001787000017830ULL,
0x00017ac000017a70ULL, 0x0000022005f03904ULL, 0x00018600000000ffULL, 0x0000030000040100ULL,
0x0001860800000007ULL, 0x00000410003f0100ULL, 0x0001868800000007ULL, 0x00000530003f0100ULL,
0x000186a800000000ULL, 0x00000620003f0100ULL, 0x000186b8000000ffULL, 0x000008f000040100ULL,
0x0001860000000007ULL, 0x00000a10003f0107ULL, 0x0001868800000003ULL, 0x000012c0003f0101ULL,
0x000186a800000007ULL, 0x000013a0003f0107ULL, 0x000186a800000007ULL, 0x00001440003f0101ULL,
0x000186b800000007ULL, 0x00001540003f0101ULL, 0x000186b800000007ULL, 0x000016b0003f0109ULL,
0x000186b800000007ULL, 0x00002020003f0109ULL, 0x000186b000000007ULL, 0x00002070003f0107ULL,
0x000186b000000007ULL, 0x00002080003f0101ULL, 0x0001860800000003ULL, 0x000020a0003f0101ULL,
0x0001860800000003ULL, 0x00002210003f0109ULL, 0x0001860800000003ULL, 0x000026c0003f0109ULL,
0x000186a800000007ULL, 0x00002830003f0109ULL, 0x000186a800000007ULL, 0x000038b0003f0109ULL,
0x000186b800000007ULL, 0x00003960003f0101ULL, 0x000186b800000007ULL, 0x00003ad0003f0109ULL,
0x000186b800000007ULL, 0x00004340003f0109ULL, 0x00000000000000ffULL, 0x0000438000050107ULL,
0x000186a800000007ULL, 0x000043b0003f0101ULL, 0x000186b000000007ULL, 0x00004520003f0109ULL,
0x000186b000000007ULL, 0x00005430003f0109ULL, 0x000186b800000007ULL, 0x00005460003f0101ULL,
0x0001868800000007ULL, 0x00005580003f0101ULL, 0x000186b800000007ULL, 0x000056f0003f0109ULL,
0x000186b800000007ULL, 0x00005f50003f0109ULL, 0x00000000000000ffULL, 0x0000601000060107ULL,
0x000186b000000007ULL, 0x00006020003f0101ULL, 0x0001862800000003ULL, 0x00006040003f0101ULL,
0x0001862800000003ULL, 0x000061b0003f0109ULL, 0x0001862800000003ULL, 0x00006640003f0109ULL,
0x000186a800000007ULL, 0x000067b0003f0109ULL, 0x000186a800000007ULL, 0x00007600003f0109ULL,
0x000186b800000007ULL, 0x000076b0003f0101ULL, 0x000186b800000007ULL, 0x00007820003f0109ULL,
0x000186b800000007ULL, 0x00008090003f0109ULL, 0x00000000000000ffULL, 0x000080d000050107ULL,
0x000186a800000007ULL, 0x00008100003f0101ULL, 0x000186b000000007ULL, 0x00008270003f0109ULL,
0x000186b000000007ULL, 0x00009040003f0109ULL, 0x000186b800000007ULL, 0x00009070003f0101ULL,
0x0001869000000007ULL, 0x000091a0003f0101ULL, 0x000186b800000007ULL, 0x00009310003f0109ULL,
0x000186b800000007ULL, 0x00009b70003f0109ULL, 0x00000000000000ffULL, 0x00009c3000060107ULL,
0x000186b000000007ULL, 0x00009c40003f0101ULL, 0x0001864800000003ULL, 0x00009c60003f0101ULL,
0x0001864800000003ULL, 0x00009dd0003f0109ULL, 0x0001864800000003ULL, 0x0000a250003f0109ULL,
0x000186a800000007ULL, 0x0000a3c0003f0109ULL, 0x000186a800000007ULL, 0x0000b210003f0109ULL,
0x000186b800000007ULL, 0x0000b2c0003f0101ULL, 0x000186b800000007ULL, 0x0000b430003f0109ULL,
0x000186b800000007ULL, 0x0000bca0003f0109ULL, 0x00000000000000ffULL, 0x0000bce000050107ULL,
0x000186a800000007ULL, 0x0000bd10003f0101ULL, 0x000186b000000007ULL, 0x0000be80003f0109ULL,
0x000186b000000007ULL, 0x0000cc50003f0109ULL, 0x000186b800000007ULL, 0x0000cc80003f0101ULL,
0x0001869800000007ULL, 0x0000cdb0003f0101ULL, 0x000186b800000007ULL, 0x0000cf20003f0109ULL,
0x000186b800000007ULL, 0x0000d780003f0109ULL, 0x00000000000000ffULL, 0x0000d84000060107ULL,
0x000186b000000007ULL, 0x0000d850003f0101ULL, 0x0001866800000003ULL, 0x0000d870003f0101ULL,
0x0001866800000003ULL, 0x0000d9e0003f0109ULL, 0x0001866800000003ULL, 0x0000de60003f0109ULL,
0x000186a800000007ULL, 0x0000dfd0003f0109ULL, 0x000186a800000007ULL, 0x0000ed50003f0109ULL,
0x000186b800000007ULL, 0x0000eed0003f0101ULL, 0x000186b800000007ULL, 0x0000f040003f0109ULL,
0x000186b800000007ULL, 0x0000f8d0003f0109ULL, 0x00000000000000ffULL, 0x0000f91000050107ULL,
0x000186a800000007ULL, 0x0000f940003f0101ULL, 0x000186b000000007ULL, 0x0000fab0003f0109ULL,
0x000186b000000007ULL, 0x00010770003f0109ULL, 0x000186b800000007ULL, 0x00010790003f0101ULL,
0x000186a000000007ULL, 0x00011500003f0101ULL, 0x0001860000000007ULL, 0x00013210003f0101ULL,
0x0001860000000007ULL, 0x00013380003f0109ULL, 0x0001860000000007ULL, 0x000136d0003f0109ULL,
0x0001860000000007ULL, 0x000136f0003f0101ULL, 0x0001860000000007ULL, 0x00013860003f0109ULL,
0x0001860000000007ULL, 0x00016700003f0109ULL, 0x0001868800000009ULL, 0x000168d0003f0101ULL,
0x0001868800000009ULL, 0x00016a40003f0109ULL, 0x0001868800000009ULL, 0x00017d00003f0109ULL,
0x000186080000000bULL, 0x00017d10003f0101ULL, 0x000186100000000bULL, 0x00017d20003f0101ULL,
0x000186180000000bULL, 0x00017d30003f0101ULL, 0x000186200000000bULL, 0x00053803003f0101ULL,
0x000114c000101c04ULL, 0x0001395000013890ULL, 0x000c050400017d50ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0050190300000000ULL, 0x0000001700080a04ULL, 0x0000000000500210ULL,
0x00000000000000bcULL, 0x0000001600000002ULL, 0x0000000000017d60ULL, 0x0000000000000044ULL,
0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001600000002ULL,
0x0000000000000000ULL, 0x0000000000018700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000137919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008800ff047b82ULL, 0x000ee20000000a00ULL,
0x0000022000007945ULL, 0x000fe20003800000ULL, 0x0000000000007919ULL, 0x000ea20000002200ULL,
0x0000040000067802ULL, 0x000fe20000000f00ULL, 0x0000000000037919ULL, 0x000f220000002100ULL,
0x00000000000e7919ULL, 0x000ee20000002700ULL, 0x0000000000087919ULL, 0x000ee20000002600ULL,
0x0000000000097919ULL, 0x000ee20000000000ULL, 0x00000000000b7919ULL, 0x000ee20000008800ULL,
0x0000000413007c24ULL, 0x004fe2000f8e0200ULL, 0x0000000000047ab9ULL, 0x000fe20000000800ULL,
0x00001fff13137589ULL, 0x000ee400000e0000ULL, 0x0000000400007c24ULL, 0x110fe2000f8e0203ULL,
0x00000005ff347819ULL, 0x000fc80000011603ULL, 0x0000007f0000780cULL, 0x040fe40003f64070ULL,
0x000000ff0000720cULL, 0x040fe20003f45270ULL, 0x00001fff34347589ULL, 0x000ee200000e0000ULL,
0x0000000f0000780cULL, 0x040fe40003f04070ULL, 0x000000030000780cULL, 0x040fe40003fa4070ULL,
0x000000010000780cULL, 0x000fca0003f84070ULL, 0x000000000007b919ULL, 0x000ea20000008800ULL,
0x000004000002b802ULL, 0x000fe20000000f00ULL, 0xff317217ff03b424ULL, 0x000fc600078e00ffULL,
0x000006540707b816ULL, 0x004fca0000000002ULL, 0x000000040002b824ULL, 0x000fe200078e0207ULL,
0x0000000000242947ULL, 0x00afec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01860006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000380947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000400077c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000070612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01860804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000385947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000400077c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000070612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01868804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018400030200b388ULL, 0x0003e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ff8000000057882ULL, 0x000fc60000000000ULL, 0x0000000400007c11ULL, 0x000fe2000f8e18ffULL,
0x001ffe0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x002fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0186a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x0000000000242947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x004fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000eb40000000000ULL,
0x0186b806043f75b2ULL, 0x0004a40008000100ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000413007824ULL, 0x000fe200078e0234ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000808037824ULL, 0x002fe200078e00ffULL,
0x0000000304057899ULL, 0x000fe2000800063fULL, 0x0000000200007824ULL, 0x000fe200078e00ffULL,
0x000006540b077816ULL, 0x000fe20000000006ULL, 0x0000820000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000100027824ULL, 0x000fe200078e0209ULL, 0x00000008000b7848ULL, 0x000fe20007fe0000ULL,
0x000000050e037c24ULL, 0x000fe2000f8e0203ULL, 0x00000000070572caULL, 0x000fe200000e0000ULL,
0x00000020000d7824ULL, 0x000fc400078e00ffULL, 0x0000000100067836ULL, 0x000fe40000000000ULL,
0x00000001030f7824ULL, 0x100fe400078e0200ULL, 0x000000010b0b7824ULL, 0x000fe200078e0a00ULL,
0xffffffe00d007812ULL, 0x000fe200078ee202ULL, 0x00000010090d7824ULL, 0x000fe400078e00ffULL,
0x0000000103117824ULL, 0x000fe200078e0206ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000002000f027825ULL, 0x100fe200078e0004ULL, 0x000001f00d0f7812ULL, 0x000fe200078ec0ffULL,
0x0001860005067890ULL, 0x000fe2000fffe03fULL, 0x000000ff0b00720cULL, 0x000fe20003f03070ULL,
0x0000020011047825ULL, 0x000fe200078e0004ULL, 0x000000010b00780cULL, 0x000fe20003f23070ULL,
0x00008e00ff107b82ULL, 0x000e620000000a00ULL, 0x0000000f020a7210ULL, 0x000fe20007f5e0ffULL,
0x00000001060c7824ULL, 0x040fe200078e0209ULL, 0x0000000f04047210ULL, 0x000fe20007f7e0ffULL,
0x0000002006157824ULL, 0x000fc400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe400010e0603ULL,
0x00000010000f7824ULL, 0x000fe200078e0207ULL, 0xffffffe0150c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fc600018e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0005e2000c101c48ULL, 0x000000100c157824ULL, 0x000fca00078e0207ULL,
0x0000000004157faeULL, 0x0005e2000c901c48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200406ULL, 0x000000040e027825ULL, 0x002fe200078e0010ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a86ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000008020f7981ULL, 0x004ea2000c1e1900ULL, 0x000000ff1300720cULL, 0x000fe20003f05270ULL,
0x0000003f0f067836ULL, 0x004fe40000000000ULL, 0x000000ff0f147836ULL, 0x000fc60000000000ULL,
0x00000006ff067819ULL, 0x000fe40000011606ULL, 0x00000008ff057819ULL, 0x000fca0000011614ULL,
0x0000010800c88947ULL, 0x000fea0003800000ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x0000000834047824ULL, 0x000fe200078e00ffULL, 0x000001ff1400780cULL, 0x000fe20003f24070ULL,
0x00000004ff007424ULL, 0x000fe400078e00ffULL, 0x0000000107037824ULL, 0x000fe400078e0204ULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x0186880003ff79a7ULL, 0x0003e8000850003fULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00009000ff117b82ULL, 0x000ea20000000800ULL,
0x000000020e007824ULL, 0x002fce00078e00ffULL, 0x00008c00ff0a7b82ULL, 0x000e620000000a00ULL,
0x0000001100117224ULL, 0x004fc800078e0211ULL, 0x00000004110a7825ULL, 0x002fca00078e000aULL,
0x000000080a027981ULL, 0x000324000c1e1900ULL, 0x0000000402007c24ULL, 0x012fc8000f8e02ffULL,
0x0000004000157824ULL, 0x000fe200078e00ffULL, 0x0000000400141947ULL, 0x000fec0003800000ULL,
0x000000040f0b7248ULL, 0x000fe20007fe0000ULL, 0x00008a0000067ab9ULL, 0x000fe20000000a00ULL,
0x00000004ff007819ULL, 0x000fe40000011609ULL, 0x000000f00d1f7812ULL, 0x000fe200078ec0ffULL,
0x000000010b0b7824ULL, 0x000fe400078e0a04ULL, 0x00000001040a7824ULL, 0x000fe400078e0200ULL,
0x00000002000c7836ULL, 0x000fe20000000000ULL, 0x0000000b0000720cULL, 0x000fe20003f66070ULL,
0x0000000400117836ULL, 0x000fc40000000000ULL, 0x0000000600137836ULL, 0x000fe20000000000ULL,
0x0000000b0c00720cULL, 0x080fe20003f46070ULL, 0x0000004008007824ULL, 0x000fe200078e020aULL,
0x0000000b1100720cULL, 0x080fe20003f26070ULL, 0x0000000104107824ULL, 0x000fe400078e020cULL,
0x000000010a0c7824ULL, 0x140fe200078e0209ULL, 0x00000000151b7210ULL, 0x000fe20007f1e0ffULL,
0x000000100a177824ULL, 0x000fe400078e00ffULL, 0x00000001100a7824ULL, 0x040fe200078e0209ULL,
0x000000061b1c7c11ULL, 0x000fe2000f8840ffULL, 0x0000001010197824ULL, 0x000fe200078e00ffULL,
0xfffffff0170c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x0000000b1300720cULL, 0x000fe20003f06070ULL, 0x0000000104147824ULL, 0x040fe200078e0213ULL,
0xfffffff019107812ULL, 0x000fe200078ee20aULL, 0x00000002000a7836ULL, 0x000fe20000000000ULL,
0x000000071b1b7c11ULL, 0x000fe2000a0f4412ULL, 0x0000000104127824ULL, 0x000fc400078e0211ULL,
0x00000004000b7836ULL, 0x000fe20000000000ULL, 0x0000000a151a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000600117836ULL, 0x000fe40000000000ULL, 0x0000000112007824ULL, 0x140fe200078e0209ULL,
0x0000000b15187210ULL, 0x000fe20007fbe0ffULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x0000001115167210ULL, 0x000fe20007fde0ffULL, 0x00000001140a7824ULL, 0x040fe400078e0209ULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0xfffffff013007812ULL, 0x000fe200078ee200ULL,
0x0000001014137824ULL, 0x000fe200078e00ffULL, 0x000000061a147c11ULL, 0x000fe2000f8840ffULL,
0x0001400007117836ULL, 0x000fc40000000000ULL, 0x000000ffff1d7224ULL, 0x000fe200028e06ffULL,
0xfffffff013127812ULL, 0x000fe200078ee20aULL, 0x000000100c157824ULL, 0x000fe200078e0211ULL,
0x000000071a1a7c11ULL, 0x000fe2000a0f440bULL, 0x0000001010177824ULL, 0x100fe200078e0211ULL,
0x0000001c1f0a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x0000000618107c11ULL, 0x000fe2000f8a40ffULL, 0x0000001000197824ULL, 0x000fe200078e0211ULL,
0x0000000616137c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e061bULL,
0x0000001f140c7210ULL, 0x000fe20007f9e0ffULL, 0x00000010121b7824ULL, 0x000fe200078e0211ULL,
0x0000000718117c11ULL, 0x000fc4000a8f441dULL, 0x0000000716007c11ULL, 0x000fe2000b0f440dULL,
0x000000ffff0d7224ULL, 0x000fe200020e061aULL, 0x0000001f10107210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a157faeULL, 0x0003e2000d901c48ULL,
0x0000001f13127210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x000000000c177faeULL, 0x0003e2000d101c48ULL, 0x000000ffff137224ULL, 0x000fc600020e0600ULL,
0x0000000010197faeULL, 0x0003e8000c901c48ULL, 0x00000000121b7faeULL, 0x0003e2000c101c48ULL,
0x0000000000e87947ULL, 0x000fea0003800000ULL, 0x0000000409007211ULL, 0x000fe200078fe0ffULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x00014000071b7836ULL, 0x000fe20000000000ULL,
0x000000f00d1d7812ULL, 0x000fe400078ec0ffULL, 0x00000002000a7836ULL, 0x000fe40000000000ULL,
0x00000001000b7824ULL, 0x140fe400078e0209ULL, 0x0000001000107824ULL, 0x000fe400078e00ffULL,
0x000000010a0c7824ULL, 0x000fc400078e0209ULL, 0x000000100a117824ULL, 0x000fe200078e00ffULL,
0xfffffff0100b7812ULL, 0x000fe200078ee20bULL, 0x00000040080a7824ULL, 0x000fe400078e0200ULL,
0x0000000400127836ULL, 0x000fe20000000000ULL, 0xfffffff011107812ULL, 0x000fe200078ee20cULL,
0x000000020a0c7836ULL, 0x000fe20000000000ULL, 0x0000000a15187210ULL, 0x000fe20007f3e0ffULL,
0x000000040a117836ULL, 0x000fe40000000000ULL, 0x000000060a137836ULL, 0x000fe20000000000ULL,
0x0000000c15167210ULL, 0x000fe20007f5e0ffULL, 0x00000006000a7836ULL, 0x000fe20000000000ULL,
0x0000001115117210ULL, 0x000fe20007f7e0ffULL, 0x0000000112007824ULL, 0x040fe200078e0209ULL,
0x0000001315137210ULL, 0x000fe20007f1e0ffULL, 0x0000001012177824ULL, 0x000fc400078e00ffULL,
0x000000010a0c7824ULL, 0x040fe400078e0209ULL, 0x000000100a197824ULL, 0x000fe200078e00ffULL,
0xfffffff017007812ULL, 0x000fe200078ee200ULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x00000006180a7c11ULL, 0x000fe2000f8240ffULL, 0x0000001010177824ULL, 0x100fe200078e021bULL,
0xfffffff0190c7812ULL, 0x000fe200078ee20cULL, 0x0000001000197824ULL, 0x000fe200078e021bULL,
0x0000000718187c11ULL, 0x000fe200088f4415ULL, 0x000000100b157824ULL, 0x100fe200078e021bULL,
0x0000000616147c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x0000000611107c11ULL, 0x000fe2000f8440ffULL, 0x000000100c1b7824ULL, 0x000fc400078e021bULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x00000007160d7c11ULL, 0x000fe200088f440bULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x0000000a1d0a7210ULL, 0x000fe40007f3e0ffULL,
0x0000000613127c11ULL, 0x000fe4000f8640ffULL, 0x0000000711117c11ULL, 0x000fe200090f440cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0618ULL, 0x000000141d0c7210ULL, 0x000fe40007f1e0ffULL,
0x000000101d107210ULL, 0x000fc40007f3e0ffULL, 0x0000000713007c11ULL, 0x000fe200098f4400ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000121d127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e6000b901c48ULL, 0x000000ffff137224ULL, 0x000fe200010e0600ULL,
0x000000000c177faeULL, 0x0003e8000b901c48ULL, 0x0000000010197faeULL, 0x0003e8000b901c48ULL,
0x00000000121b7faeULL, 0x0003e4000b901c48ULL, 0x000186a805057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x00000001ff0a7424ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0186a80a074c79a7ULL, 0x0002a2000850003fULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0186b80a070a79a7ULL, 0x0022e2000850003fULL, 0x000000f400608947ULL, 0x000fea0003800000ULL,
0x00009000ff0d7b82ULL, 0x000f220000000800ULL, 0x000000020e0a7824ULL, 0x008fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff4c7224ULL, 0x004fe400078e004dULL,
0x000000ffff397224ULL, 0x000fe400078e000bULL, 0xff317217ff4d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff4f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fc400078e00ffULL,
0x0000000d0a0a7224ULL, 0x010fce00078e020dULL, 0x0000000804067899ULL, 0x000fcc000800063fULL,
0x000000060f007c0cULL, 0x000fda000bf03070ULL, 0x000000f400240947ULL, 0x002fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fce00078e004fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0186b839070075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000000104067890ULL, 0x000fe2000fffe03fULL,
0x0000840000077ab9ULL, 0x000fe40000000800ULL, 0x0000000702027c24ULL, 0x000fc6000f8e02ffULL,
0x0000000605007c0cULL, 0x000fe2000bf23070ULL, 0x0000004002397824ULL, 0x000fd800078e00ffULL,
0x0000000400289947ULL, 0x000fea0003800000ULL, 0x00000004ff3d7819ULL, 0x000fe20000011609ULL,
0x0000002004067891ULL, 0x000fc8000f8e403fULL, 0x000000023d417836ULL, 0x000fe40000000000ULL,
0x0000000104327824ULL, 0x040fe400078e023dULL, 0x0000000104337824ULL, 0x000fe400078e0241ULL,
0x0000000132027824ULL, 0x140fe400078e0209ULL, 0x00000010323f7824ULL, 0x000fe400078e00ffULL,
0x0000000133307824ULL, 0x000fc400078e0209ULL, 0x0000001033437824ULL, 0x000fe200078e00ffULL,
0xfffffff03f3f7812ULL, 0x000fe200078ee202ULL, 0x000000043d457836ULL, 0x000fe20000000000ULL,
0x000000060f027c48ULL, 0x000fe2000ffe0000ULL, 0x000000063d497836ULL, 0x000fe20000000000ULL,
0xfffffff043437812ULL, 0x000fe200078ee230ULL, 0x0000000104357824ULL, 0x000fe200078e0245ULL,
0x0000002008307811ULL, 0x000fe200078e30ffULL, 0x0000000104367824ULL, 0x000fe400078e0249ULL,
0x8000000602317c36ULL, 0x000fe20008000000ULL, 0x00008a0000067ab9ULL, 0x000fe20000000a00ULL,
0x0000000132327824ULL, 0x000fc400078e0230ULL, 0x0000000133027824ULL, 0x100fe200078e0230ULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x0000000135337824ULL, 0x140fe200078e0230ULL,
0x0000003239327210ULL, 0x000fe20007f1e0ffULL, 0x0000000136307824ULL, 0x000fe200078e0230ULL,
0x0000000239377210ULL, 0x000fe20007f5e0ffULL, 0x0000001035477824ULL, 0x040fe200078e00ffULL,
0x0000003339337210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e06ffULL,
0x0000003039397210ULL, 0x000fe20007fde0ffULL, 0x0000000135307824ULL, 0x100fe200078e0209ULL,
0x0000000632357c11ULL, 0x000fe2000f8040ffULL, 0x0000000136387824ULL, 0x000fc400078e0209ULL,
0x00000010364b7824ULL, 0x000fe200078e00ffULL, 0xfffffff047477812ULL, 0x000fe200078ee230ULL,
0x0000001009367824ULL, 0x000fe400078e00ffULL, 0x0000000131027824ULL, 0x000fe200078e0a04ULL,
0x0000000732317c11ULL, 0x000fe200080f443bULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x0000000637327c11ULL, 0x040fe2000f8a40ffULL, 0x000000ffff3a7224ULL, 0x000fe200030e06ffULL,
0x000000f0363b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee238ULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x0000000737377c11ULL, 0x000fc4000a8f4430ULL,
0x0000003b35307210ULL, 0x000fe40007f9e0ffULL, 0x0000000633367c11ULL, 0x000fe4000f8a40ffULL,
0x0000003b32327210ULL, 0x000fe20007fde0ffULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000023d00720cULL, 0x080fe40003f66070ULL, 0x0000000733357c11ULL, 0x000fe2000a8f4438ULL,
0x000000ffff337224ULL, 0x000fe200030e0637ULL, 0x000000024100720cULL, 0x000fc40003f46070ULL,
0x0000000639387c11ULL, 0x000fe4000f8840ffULL, 0x000000024500720cULL, 0x080fe40003f06070ULL,
0x0000003b36367210ULL, 0x000fe40007fde0ffULL, 0x000000024900720cULL, 0x000fe20003fa6070ULL,
0x0001600007027836ULL, 0x000fe20000000000ULL, 0x0000000739397c11ULL, 0x000fe2000a0f443aULL,
0x000000ffff377224ULL, 0x000fe200030e0635ULL, 0x0000003b38387210ULL, 0x000fe20007f9e0ffULL,
0x000000103f357824ULL, 0x000fc400078e0202ULL, 0x00000010433b7824ULL, 0x100fe400078e0202ULL,
0x00000010473d7824ULL, 0x100fe200078e0202ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030357faeULL, 0x0005e2000d901c48ULL, 0x000000104b3f7824ULL, 0x000fe400078e0202ULL,
0x000000ffff397224ULL, 0x000fe200020e0639ULL, 0x00000000323b7faeULL, 0x0005e8000d101c48ULL,
0x00000000363d7faeULL, 0x0005e8000c101c48ULL, 0x00000000383f7faeULL, 0x0005e2000e901c48ULL,
0x0000000000f07947ULL, 0x000fea0003800000ULL, 0x0000000409027211ULL, 0x000fe200078fe0ffULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002008337811ULL, 0x000fc600078e30ffULL,
0x0000000202327836ULL, 0x000fe40000000000ULL, 0x0000000102307824ULL, 0x100fe400078e0209ULL,
0x0000000132317824ULL, 0x040fe400078e0209ULL, 0x0000001032367824ULL, 0x000fe400078e00ffULL,
0x0000001002357824ULL, 0x040fe400078e00ffULL, 0x0000000602387836ULL, 0x000fe20000000000ULL,
0xfffffff0363b7812ULL, 0x000fe200078ee231ULL, 0x0000000402367836ULL, 0x000fe20000000000ULL,
0xfffffff035357812ULL, 0x000fe200078ee230ULL, 0x0000000102027824ULL, 0x000fc400078e0233ULL,
0x0000000132307824ULL, 0x100fe400078e0233ULL, 0x0000000138327824ULL, 0x100fe200078e0233ULL,
0x00000002393c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000136317824ULL, 0x040fe200078e0233ULL,
0x0000003039307210ULL, 0x000fe20007f7e0ffULL, 0x00000010363d7824ULL, 0x040fe200078e00ffULL,
0x0000003239027210ULL, 0x000fe20007f1e0ffULL, 0x0000000136327824ULL, 0x100fe200078e0209ULL,
0x0000003139317210ULL, 0x000fe20007f9e0ffULL, 0x0000000138397824ULL, 0x000fc400078e0209ULL,
0x000000ffff337224ULL, 0x000fe200010e06ffULL, 0x000000063c377c11ULL, 0x000fe2000f8440ffULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0xfffffff03d3d7812ULL, 0x000fe200078ee232ULL,
0x0000001009327824ULL, 0x000fe200078e00ffULL, 0x000000073c3c7c11ULL, 0x000fe200090f4433ULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0xfffffff0383f7812ULL, 0x000fe200078ee239ULL,
0x0001600007367836ULL, 0x000fe20000000000ULL, 0x0000000630397c11ULL, 0x000fe4000f8440ffULL,
0x000000f0323e7812ULL, 0x000fe200078ec0ffULL, 0x0000001035357824ULL, 0x100fe200078e0236ULL,
0x00000007303a7c11ULL, 0x000fe200090f4433ULL, 0x000000103b3b7824ULL, 0x100fe200078e0236ULL,
0x0000003e37307210ULL, 0x000fe20007f5e0ffULL, 0x000000103d3d7824ULL, 0x000fc400078e0236ULL,
0x000000103f3f7824ULL, 0x000fe200078e0236ULL, 0x0000000631367c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff327224ULL, 0x000fe200020e06ffULL, 0x0000000602387c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff337224ULL, 0x000fc600000e06ffULL, 0x0000000731377c11ULL, 0x000fe200098f4432ULL,
0x000000ffff317224ULL, 0x000fe200010e063cULL, 0x0000003e39327210ULL, 0x000fe40007f1e0ffULL,
0x0000003e36367210ULL, 0x000fe40007f5e0ffULL, 0x0000000702027c11ULL, 0x000fe2000a0f4433ULL,
0x000000ffff337224ULL, 0x000fe200000e063aULL, 0x0000003e38387210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff377224ULL, 0x000fe200010e0637ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030357faeULL, 0x0005e6000b901c48ULL, 0x000000ffff397224ULL, 0x000fe200018e0602ULL,
0x00000000323b7faeULL, 0x0005e8000b901c48ULL, 0x00000000363d7faeULL, 0x0005e8000b901c48ULL,
0x00000000383f7faeULL, 0x0005e4000b901c48ULL, 0x000000014f337836ULL, 0x004fe40000000000ULL,
0xffffffffff027424ULL, 0x000fc600078e00ffULL, 0x000000063300720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00008c00ff307b82ULL, 0x000ea20000000a00ULL,
0x000000010a337824ULL, 0x000fc800078e0233ULL, 0x0000000433307825ULL, 0x004fca00078e0030ULL,
0x0000000830027981ULL, 0x000524000c1e1900ULL, 0x00000000070672caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x00000001ff367424ULL, 0x000fd600078e00ffULL,
0x000186b006067890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0186b036075479a7ULL, 0x0004e4000850003fULL,
0x01860836033679a7ULL, 0x004464000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01860837030075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x01860837030075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001ff307819ULL, 0x000fe20000011609ULL,
0x0000001009367824ULL, 0x000fe400078e00ffULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000c304b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e004dULL,
0x0000007036307812ULL, 0x000fc800078ec0ffULL, 0x000000074b4b7210ULL, 0x000fca0007ffe030ULL,
0x018000004b307984ULL, 0x000e680000000800ULL, 0x018200004b337984ULL, 0x000b620000000800ULL,
0x0000004d3000720bULL, 0x002fda0003f1d000ULL, 0x0000000000317806ULL, 0x000fc800000e0100ULL,
0x0000ffff31327812ULL, 0x000fda000780c0ffULL, 0x0000000000e88947ULL, 0x02cfea0003800000ULL,
0x0000004d3000720bULL, 0x000fe40003f14000ULL, 0x000000ff3400720cULL, 0x000fe40003f45270ULL,
0x000000304d4e7209ULL, 0x000fd20007810000ULL, 0x0000000000357806ULL, 0x000fe400000e0100ULL,
0x0184004e4b00a388ULL, 0x0003e40000000800ULL, 0x0000991035317816ULL, 0x000fc800000000ffULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x8000004e4d317221ULL, 0x000fe20000010000ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100387308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x002fcc0000011609ULL, 0x00001f3138317589ULL, 0x004e6400000e0000ULL,
0x0000003110107220ULL, 0x082fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003128287220ULL, 0x080fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000003800007220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000809317811ULL, 0x002fcc00078ff0ffULL, 0x00001f3138317589ULL, 0x000e6400000e0000ULL,
0x0000003112127220ULL, 0x082fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x000000312a2a7220ULL, 0x080fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff32ff7812ULL, 0x000fda0007806035ULL, 0x8000004e30300221ULL, 0x000fe20000010000ULL,
0x00007610ff370816ULL, 0x000fc60000000037ULL, 0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL,
0x00000030000c0308ULL, 0x000ea40000000800ULL, 0x0000000c33330220ULL, 0x004fce0000410000ULL,
0x0000000033007221ULL, 0x000fce0000010000ULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x0186a84c070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186a84c070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000709407812ULL, 0x040fe200078ec0ffULL,
0x0001400007447836ULL, 0x000fe20000000000ULL, 0x0000000809307812ULL, 0x000fe400078ec0ffULL,
0x00000004ff357819ULL, 0x000fe40000011609ULL, 0x0000991037317816ULL, 0x000fe400000000ffULL,
0x0000000840407812ULL, 0x000fe200078ef809ULL, 0x0000000434527824ULL, 0x000fe200078e0235ULL,
0x0000000730517812ULL, 0x000fc400078ef809ULL, 0x000000ff3100720cULL, 0x000fe20003f45270ULL,
0x0000000135377824ULL, 0x000fe200078e0240ULL, 0x00000002344c7811ULL, 0x000fe200078e10ffULL,
0x0000000151307824ULL, 0x040fe400078e0252ULL, 0x0000001051497824ULL, 0x000fe400078e00ffULL,
0x00000008404a7824ULL, 0x000fc600078e00ffULL, 0xfffffff049497812ULL, 0x000fe400078ee230ULL,
0xfffffff84a4a7812ULL, 0x000fc600078ee237ULL, 0x0000001049497824ULL, 0x000fe400078e0244ULL,
0x000000104a4a7824ULL, 0x000fe200078e0207ULL, 0x0000000000182947ULL, 0x000fec0003800000ULL,
0x00000002ff337819ULL, 0x000fe40000011609ULL, 0x0000000cff0d723eULL, 0x000fc600000000ffULL,
0x0000000833317836ULL, 0x000fe20000000000ULL, 0x000054100d307816ULL, 0x000fca000000000dULL,
0x00001f33300d7589ULL, 0x0002a800000e0000ULL, 0x00001f31300e7589ULL, 0x0002e400000e0000ULL,
0x012000004a30783bULL, 0x0022e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000493c783bULL, 0x000f620000004200ULL, 0x0000000135427824ULL, 0x000fe400078e024cULL,
0x0000001051397824ULL, 0x040fe400078e00ffULL, 0x0000000151387824ULL, 0x000fca00078e0242ULL,
0xfffffff039397812ULL, 0x000fca00078ee238ULL, 0x0000001039487824ULL, 0x000fca00078e0244ULL,
0x000000004838783bULL, 0x000f640000004200ULL, 0x00000018ff597819ULL, 0x022fe2000001143cULL,
0x000001003c477824ULL, 0x040fe200078e00ffULL, 0x000088803c577816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001143dULL,
0x000001003d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x000088803d5f7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff587819ULL, 0x000fe2000001143eULL,
0x0000004700647306ULL, 0x0003e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff537819ULL, 0x000fe4000001143fULL, 0x000088803e5b7816ULL, 0x000fc400000000ffULL,
0x000088803f5c7816ULL, 0x040fe200000000ffULL, 0x0000003c00607306ULL, 0x000be20000200c00ULL,
0x000001003e477824ULL, 0x042fe200078e00ffULL, 0x00000018ff467819ULL, 0x008fe20000011438ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011439ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x000001003f3c7824ULL, 0x064fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000088803b657816ULL, 0x000fc400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff457819ULL, 0x000fe4000001143bULL,
0x00000018ff437819ULL, 0x000fc6000001143aULL, 0x0000004d00667306ULL, 0x0004f00000200c00ULL,
0x0000003d00617306ULL, 0x000be20000200c00ULL, 0x00008880384d7816ULL, 0x004fce00000000ffULL,
0x00000047005e7306ULL, 0x0005e20000200c00ULL, 0x00000100383d7824ULL, 0x060fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00637306ULL, 0x000be20000200c00ULL, 0x0000888039477816ULL, 0x004fe400000000ffULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x00000100393c7824ULL, 0x060fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff567819ULL, 0x000fe4000001143cULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003e005d7306ULL, 0x000fe20000200c00ULL, 0x000088803a3c7816ULL, 0x000fce00000000ffULL,
0x0000003f00627306ULL, 0x000ff00000200c00ULL, 0x00000038003f7306ULL, 0x0003f00000200c00ULL,
0x00000039003e7306ULL, 0x0007e20000200c00ULL, 0x0000541057387816ULL, 0x002fe20000000064ULL,
0x000000ffff577224ULL, 0x000fcc00078e0065ULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x000054105f397816ULL, 0x008fe20000000066ULL, 0x000001003b5f7824ULL, 0x040fe400078e00ffULL,
0x000100003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x000000383010723cULL, 0x000fe20000001810ULL,
0x00000018ff3b7819ULL, 0x000fcc000001143bULL, 0x0000541060387816ULL, 0x000fe20000000059ULL,
0x0000005800587306ULL, 0x000f620000200c00ULL, 0x0000541061397816ULL, 0x004fce000000005aULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x000000383014723cULL, 0x000fee0000001814ULL,
0x000100003a397824ULL, 0x000fe200078e00ffULL, 0x000054105b387816ULL, 0x002fe2000000005eULL,
0x0000004d004d7306ULL, 0x000fe60000200c00ULL, 0x00000018ff597819ULL, 0x000fc40000011439ULL,
0x000054105c397816ULL, 0x008fc60000000063ULL, 0x0000003d00507306ULL, 0x0002e80000200c00ULL,
0x000000383018723cULL, 0x000fe80000001818ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000001003a3d7824ULL, 0x002fe400078e00ffULL, 0x000054105d387816ULL, 0x020fc40000000058ULL,
0x0000541062397816ULL, 0x004fe40000000053ULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000005600567306ULL, 0x000e680000200c00ULL, 0x00000038301c723cULL, 0x000fe8000000181cULL,
0x0000004600467306ULL, 0x000ea60000200c00ULL, 0x000054104d387816ULL, 0x008fe20000000050ULL,
0x0000000840507824ULL, 0x000fe200078e00ffULL, 0x00000010514d7812ULL, 0x000fc400078efcffULL,
0x0000541047397816ULL, 0x002fe20000000056ULL, 0x0000004100417306ULL, 0x000e6c0000200c00ULL,
0x000000383020723cULL, 0x000fe20000001820ULL, 0x000054103f467816ULL, 0x004fe20000000046ULL,
0x0000003c003c7306ULL, 0x000fea0000200c00ULL, 0x0000000237397836ULL, 0x000fe20000000000ULL,
0x000054103e477816ULL, 0x002fc40000000041ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x0000000152417824ULL, 0x000fe400078e024dULL, 0x000000104d3e7824ULL, 0x000fe400078e00ffULL,
0x000000463024723cULL, 0x000fe60000001824ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0xfffffff03e417812ULL, 0x000fc600078ee241ULL, 0xfffffff850467812ULL, 0x000fe400078ee239ULL,
0x000054103c3c7816ULL, 0x002fe4000000003dULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000001046467824ULL, 0x000fce00078e0207ULL, 0x0000005700577306ULL, 0x000ff00000200c00ULL,
0x0000005f003a7306ULL, 0x000e700000200c00ULL, 0x00000059005a7306ULL, 0x000ea20000200c00ULL,
0x00005410573d7816ULL, 0x002fce000000003aULL, 0x0000003b00387306ULL, 0x000e620000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054105a5a7816ULL, 0x004fe40000000043ULL,
0x00005410385b7816ULL, 0x002fe20000000045ULL, 0x0000001041457824ULL, 0x000fcc00078e0244ULL,
0x0000005a302c723cULL, 0x000fe2000000182cULL, 0x012000004630783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x0000004c4d4c7210ULL, 0x040fe20007ffe035ULL, 0x000000104d4d7824ULL, 0x000fe200078e00ffULL,
0x00000000453c783bULL, 0x000ee80000004200ULL, 0xfffffff04d4d7812ULL, 0x000fca00078ee24cULL,
0x000000104d447824ULL, 0x000fca00078e0244ULL, 0x000000004438783bULL, 0x000f620000004200ULL,
0x00000018ff5f7819ULL, 0x008fe2000001143cULL, 0x000001003c537824ULL, 0x040fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001143dULL, 0x000001003d567824ULL, 0x040fe200078e00ffULL,
0x000088803c617816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d657816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff507819ULL, 0x022fe40000011438ULL, 0x0000888038587816ULL, 0x000fe200000000ffULL,
0x0000003c00647306ULL, 0x0003e20000200c00ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff5a7819ULL, 0x000fe4000001143fULL, 0x000088803f627816ULL, 0x000fc400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011439ULL, 0x0000003d00697306ULL, 0x0007e20000200c00ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x000088803e607816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001143eULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00000100383d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc4000001143aULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005300667306ULL, 0x0003e20000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff477819ULL, 0x000fca000001143bULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000001003e537824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005600687306ULL, 0x0002e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c006b7306ULL, 0x000be20000200c00ULL, 0x0000888039567816ULL, 0x002fce00000000ffULL,
0x0000003800577306ULL, 0x0003e20000200c00ULL, 0x00000100393c7824ULL, 0x064fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001143cULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000001003b387824ULL, 0x002fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005300637306ULL, 0x000ff00000200c00ULL,
0x0000003f005d7306ULL, 0x000ff00000200c00ULL, 0x0000003900537306ULL, 0x0007f00000200c00ULL,
0x00000038003f7306ULL, 0x0003e20000200c00ULL, 0x0000541065397816ULL, 0x008fce0000000068ULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x0000541061387816ULL, 0x002fce0000000066ULL,
0x0000006200627306ULL, 0x000e620000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x0000541064387816ULL, 0x000fe2000000005fULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000541069397816ULL, 0x004fce000000005eULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000000383014723cULL, 0x000fee0000001814ULL, 0x0000003e00677306ULL, 0x0005620000200c00ULL,
0x0000541060387816ULL, 0x008fe40000000063ULL, 0x0000541062397816ULL, 0x002fca000000006bULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000088803b3e7816ULL, 0x044fe200000000ffULL,
0x000000383018723cULL, 0x000fe20000001818ULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x0000003d00597306ULL, 0x0002a20000200c00ULL, 0x0000541067387816ULL, 0x020fe4000000005cULL,
0x000054105d397816ULL, 0x000fe4000000005aULL, 0x00000018ff3b7819ULL, 0x000fc6000001143bULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000001003a3d7824ULL, 0x042fe200078e00ffULL,
0x00000038301c723cULL, 0x000fe2000000181cULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000541058387816ULL, 0x004fca0000000059ULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x0000541056397816ULL, 0x002fce000000005bULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x000000383020723cULL, 0x000fee0000001820ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000541057387816ULL, 0x004fe40000000050ULL,
0x0000541053397816ULL, 0x002fca000000004cULL, 0x0000003d003d7306ULL, 0x000e640000200c00ULL,
0x000000383024723cULL, 0x000fec0000001824ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x0186b838073879a7ULL, 0x00026e000850003fULL,
0x0000003e003e7306ULL, 0x000eb00000200c00ULL, 0x0000003a003a7306ULL, 0x000ee20000200c00ULL,
0x000054103e3d7816ULL, 0x004fce000000003fULL, 0x0000003b005e7306ULL, 0x000ea20000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054103a3a7816ULL, 0x008fe40000000043ULL,
0x000054105e3b7816ULL, 0x004fce0000000047ULL, 0x0000003a302c723cULL, 0x002fde000000182cULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008400000a7ab9ULL, 0x000fe20000000800ULL,
0x0000004004077891ULL, 0x000fe2000f8e403fULL, 0x0000000a02507c24ULL, 0x010fc8000f8e02ffULL,
0x0000004050507824ULL, 0x000fe200078e00ffULL, 0x0000000400189947ULL, 0x000fec0003800000ULL,
0x0000000104317824ULL, 0x000fe200078e0235ULL, 0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000002353d7836ULL, 0x000fe20000000000ULL, 0x000000f036437812ULL, 0x000fe200078ec0ffULL,
0x0000000131307824ULL, 0x040fe400078e0209ULL, 0x0000001031397824ULL, 0x000fe400078e00ffULL,
0x0000000104327824ULL, 0x000fe400078e023dULL, 0x00000040083b7824ULL, 0x000fe200078e0231ULL,
0xfffffff0393c7812ULL, 0x000fe200078ee230ULL, 0x0000000132337824ULL, 0x040fe200078e0209ULL,
0x000000070f307c48ULL, 0x000fe2000ffe0000ULL, 0x00000010324c7824ULL, 0x000fe200078e00ffULL,
0x000000503b397210ULL, 0x000fe20007f1e0ffULL, 0x0000000435477836ULL, 0x000fc40000000000ULL,
0x8000000730317c36ULL, 0x000fe20008000000ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee233ULL,
0x000000023b337836ULL, 0x000fe40000000000ULL, 0x0000000104327824ULL, 0x000fe200078e0247ULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff307224ULL, 0x000fe200000e06ffULL,
0x00000050333e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000132387824ULL, 0x040fe400078e0209ULL,
0x00000010323f7824ULL, 0x000fe200078e00ffULL, 0x0000000a39327c11ULL, 0x000fe2000f8040ffULL,
0x00000001313a7824ULL, 0x000fc400078e0a04ULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x0000000a3e317c11ULL, 0x040fe2000f8640ffULL, 0x0000000635537836ULL, 0x000fe20000000000ULL,
0xfffffff03f567812ULL, 0x000fe200078ee238ULL, 0x000000043b3f7836ULL, 0x000fe20000000000ULL,
0x0000000b3e3e7c11ULL, 0x000fe400098f4433ULL, 0x0000003a3500720cULL, 0x000fe40003f86070ULL,
0x0000000b39397c11ULL, 0x000fe400080f4430ULL, 0x0000004332327210ULL, 0x000fc40007f7e0ffULL,
0x0000003a3d00720cULL, 0x080fe40003f06070ULL, 0x000000503f3d7210ULL, 0x000fe20007fbe0ffULL,
0x00014000073f7836ULL, 0x000fe40000000000ULL, 0x000000ffff337224ULL, 0x000fe200018e0639ULL,
0x0000003a4700720cULL, 0x000fe20003f66070ULL, 0x000000103c477824ULL, 0x000fe400078e023fULL,
0x000000063b397836ULL, 0x000fe40000000000ULL, 0x000000ffff307224ULL, 0x000fe200028e06ffULL,
0x0000000a3d387c11ULL, 0x000fe2000f8a40ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032477faeULL, 0x0003e2000e101c48ULL, 0x00000001043c7824ULL, 0x000fe200078e0253ULL,
0x0000005039397210ULL, 0x000fc40007f9e0ffULL, 0x0000000b3d3d7c11ULL, 0x000fe2000a8f4430ULL,
0x000000013c577824ULL, 0x040fe200078e0209ULL, 0x0000004331307210ULL, 0x000fe20007fbe0ffULL,
0x000000103c587824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fe20007fde0ffULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x0000000a393b7c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff317224ULL, 0x000fe200028e063eULL, 0x0000003a5300720cULL, 0x000fe40003fa6070ULL,
0x0000000b39337c11ULL, 0x002fe2000a0f443cULL, 0x000000ffff397224ULL, 0x000fe200030e063dULL,
0xfffffff0583e7812ULL, 0x000fe200078ee257ULL, 0x00000010563d7824ULL, 0x100fe200078e023fULL,
0x000000433b327210ULL, 0x000fe20007f9e0ffULL, 0x000000104c3b7824ULL, 0x000fc400078e023fULL,
0x000000103e3f7824ULL, 0x000fe400078e023fULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x00000000303b7faeULL, 0x0003e8000c101c48ULL, 0x00000000383d7faeULL, 0x0003e8000d901c48ULL,
0x00000000323f7faeULL, 0x0003e2000e901c48ULL, 0x0000000000e87947ULL, 0x000fea0003800000ULL,
0x0000000104337824ULL, 0x000fe200078e0235ULL, 0x00008a00000a7ab9ULL, 0x000fc60000000a00ULL,
0x0000000133317824ULL, 0x140fe400078e0209ULL, 0x0000001033387824ULL, 0x000fe400078e00ffULL,
0x0000000233307836ULL, 0x000fe40000000000ULL, 0x0000000433327836ULL, 0x000fe20000000000ULL,
0xfffffff0383d7812ULL, 0x000fe200078ee231ULL, 0x0000000130317824ULL, 0x040fe400078e0209ULL,
0x0000001030387824ULL, 0x000fc400078e00ffULL, 0x0000004008397824ULL, 0x000fe400078e0233ULL,
0x0000000132307824ULL, 0x140fe200078e0209ULL, 0xfffffff038317812ULL, 0x000fe200078ee231ULL,
0x00000010323b7824ULL, 0x000fe200078e00ffULL, 0x0000005039387210ULL, 0x000fe20007f1e0ffULL,
0x0000000633327836ULL, 0x000fe40000000000ULL, 0x00000002393f7836ULL, 0x000fe20000000000ULL,
0xfffffff03b307812ULL, 0x000fe200078ee230ULL, 0x0000000132337824ULL, 0x000fc400078e0209ULL,
0x0000001032327824ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e06ffULL,
0x0000000a383a7c11ULL, 0x040fe2000f8040ffULL, 0x0000000439537836ULL, 0x000fe20000000000ULL,
0xfffffff032337812ULL, 0x000fe200078ee233ULL, 0x0001400007327836ULL, 0x000fe20000000000ULL,
0x0000000b383b7c11ULL, 0x000fe200080f443bULL, 0x0000000639577836ULL, 0x000fe20000000000ULL,
0x000000503f387210ULL, 0x000fe20007f1e0ffULL, 0x000000103d477824ULL, 0x100fe200078e0232ULL,
0x0000005053537210ULL, 0x000fe20007f7e0ffULL, 0x00000010313d7824ULL, 0x100fe200078e0232ULL,
0x0000005057577210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e06ffULL,
0x0000000a383c7c11ULL, 0x000fe2000f8040ffULL, 0x0000001033437824ULL, 0x100fe200078e0232ULL,
0x000000f036337812ULL, 0x000fe200078ec0ffULL, 0x00000010303f7824ULL, 0x000fe200078e0232ULL,
0x0000000b38397c11ULL, 0x000fe200080f4431ULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x000000333a307210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x0000000a53387c11ULL, 0x000fc4000f8640ffULL, 0x0000000a573e7c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff317224ULL, 0x000fe200000e063bULL, 0x0000000b53537c11ULL, 0x000fe400098f4432ULL,
0x000000333c327210ULL, 0x000fe40007f1e0ffULL, 0x0000000b57577c11ULL, 0x000fe2000a0f443aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030477faeULL, 0x0003e2000b901c48ULL,
0x0000003338387210ULL, 0x000fe40007f7e0ffULL, 0x000000333e3a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff337224ULL, 0x000fc400000e0639ULL, 0x000000ffff397224ULL, 0x000fe400018e0653ULL,
0x000000ffff3b7224ULL, 0x000fe200020e0657ULL, 0x00000000323d7faeULL, 0x0003e8000b901c48ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a437faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff307424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0186a830073079a7ULL, 0x000e64000850003fULL, 0x000000ffff4c7224ULL, 0x002fe200078e0031ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b055070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b055070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000437307836ULL, 0x000fe40000000000ULL, 0x0000000840337824ULL, 0x000fe400078e00ffULL,
0x0000000151317824ULL, 0x040fe400078e0252ULL, 0x0000001051327824ULL, 0x000fe200078e00ffULL,
0xfffffff833307812ULL, 0x000fe200078ee230ULL, 0x0001600007527836ULL, 0x000fc60000000000ULL,
0xfffffff032437812ULL, 0x000fe200078ee231ULL, 0x0000001030477824ULL, 0x000fe200078e0207ULL,
0x0000000000182947ULL, 0x000fec0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011609ULL,
0x0000000cff0d723eULL, 0x000fc600000000ffULL, 0x0000000831337836ULL, 0x000fe20000000000ULL,
0x000054100d307816ULL, 0x000fca000000000dULL, 0x00001f31300d7589ULL, 0x0002a800000e0000ULL,
0x00001f33300e7589ULL, 0x0002e400000e0000ULL, 0x012000004730783bULL, 0x0022e20000000200ULL,
0x0000001043437824ULL, 0x000fe200078e0252ULL, 0x0000000000102947ULL, 0x000fec0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000433c783bULL, 0x000f220000004200ULL, 0x0000000151427824ULL, 0x040fe400078e0242ULL,
0x0000001051397824ULL, 0x000fe400078e00ffULL, 0x0000000637377836ULL, 0x000fe40000000000ULL,
0x0000001041417824ULL, 0x000fe200078e0252ULL, 0xfffffff039397812ULL, 0x000fca00078ee242ULL,
0x0000001039427824ULL, 0x000fca00078e0252ULL, 0x000000004238783bULL, 0x000f620000004200ULL,
0x00000018ff617819ULL, 0x010fe2000001143cULL, 0x000001003c567824ULL, 0x040fe200078e00ffULL,
0x000088803c577816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe2000001143dULL, 0x000001003d587824ULL, 0x040fe200078e00ffULL,
0x000088803d657816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00000018ff567819ULL, 0x000fc40000011456ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5c7819ULL, 0x000fe2000001143fULL,
0x0000003c00667306ULL, 0x0009e20000200c00ULL, 0x000088803f647816ULL, 0x000fe200000000ffULL,
0x000001003b6b7824ULL, 0x022fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011438ULL,
0x00000018ff557819ULL, 0x000fc40000011439ULL, 0x0000888038597816ULL, 0x000fe200000000ffULL,
0x0000005600687306ULL, 0x0003620000200c00ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x000088803e627816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143eULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000001003e567824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fc4000001143aULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000058006a7306ULL, 0x0003220000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff537819ULL, 0x000fca000001143bULL, 0x0000003d00677306ULL, 0x0009e20000200c00ULL,
0x0000888039587816ULL, 0x002fce00000000ffULL, 0x0000003c00697306ULL, 0x0003e20000200c00ULL,
0x00000100383d7824ULL, 0x054fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x00000100393c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001143cULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fca00000000ffULL, 0x0000005600637306ULL, 0x000ff00000200c00ULL,
0x0000003f005f7306ULL, 0x000ff00000200c00ULL, 0x00000038003f7306ULL, 0x000bf00000200c00ULL,
0x0000003900567306ULL, 0x0009e20000200c00ULL, 0x0000541057387816ULL, 0x028fc40000000068ULL,
0x00000018ff577819ULL, 0x000fca000001146bULL, 0x0000006200627306ULL, 0x000ee20000200c00ULL,
0x0000541065397816ULL, 0x010fce000000006aULL, 0x0000006400647306ULL, 0x000f220000200c00ULL,
0x000000383010723cULL, 0x000fee0000001810ULL, 0x0000541066387816ULL, 0x004fe20000000061ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000541067397816ULL, 0x002fce0000000060ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000000383014723cULL, 0x000fee0000001814ULL,
0x0000003e005e7306ULL, 0x0002a20000200c00ULL, 0x0000541062387816ULL, 0x008fe40000000063ULL,
0x0000541064397816ULL, 0x010fca0000000069ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000088803b3e7816ULL, 0x042fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383018723cULL, 0x000fe80000001818ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003d005a7306ULL, 0x0002e40000200c00ULL, 0x000054105e387816ULL, 0x004fc4000000005dULL,
0x000054105f397816ULL, 0x000fc8000000005cULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000001003a3d7824ULL, 0x042fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000038301c723cULL, 0x000fe4000000181cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000541059387816ULL, 0x008fca000000005aULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541058397816ULL, 0x002fce000000005bULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000000383020723cULL, 0x000fee0000001820ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000000840387824ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0xfffffff838387812ULL, 0x000fe400078ee237ULL,
0x000054103f547816ULL, 0x004fca0000000054ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000001038377824ULL, 0x000fe200078e0207ULL, 0x0000541056557816ULL, 0x002fcc0000000055ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000000543024723cULL, 0x000fee0000001824ULL,
0x0000003e003e7306ULL, 0x000ff00000200c00ULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000003a003a7306ULL, 0x000ea20000200c00ULL, 0x000054103e3d7816ULL, 0x002fce0000000057ULL,
0x0000003b005c7306ULL, 0x000e620000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103a3a7816ULL, 0x004fe40000000051ULL, 0x000054105c3b7816ULL, 0x002fce0000000053ULL,
0x0000003a302c723cULL, 0x000fe2000000182cULL, 0x012000003730783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000413c783bULL, 0x000ee20000004200ULL, 0x000000104d407824ULL, 0x000fe200078e0252ULL,
0x000000070f007c0cULL, 0x000fe2000bf03070ULL, 0x000000014f4f7836ULL, 0x000fc60000000000ULL,
0x000000004038783bULL, 0x000f220000004200ULL, 0x00000018ff5c7819ULL, 0x008fe2000001143cULL,
0x000001003c547824ULL, 0x040fe200078e00ffULL, 0x000088803c5e7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d557824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000001003b6a7824ULL, 0x010fe200078e00ffULL, 0x000088803d627816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff5a7819ULL, 0x000fe2000001143eULL, 0x0000005400637306ULL, 0x0007e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803e5d7816ULL, 0x040fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011438ULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003c00677306ULL, 0x0009e20000200c00ULL, 0x000001003e547824ULL, 0x008fe200078e00ffULL,
0x0000888038567816ULL, 0x000fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000088803f5f7816ULL, 0x000fc400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff587819ULL, 0x000fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x00000018ff517819ULL, 0x000fc4000001143bULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff4d7819ULL, 0x000fe4000001143aULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000005500697306ULL, 0x000f300000200c00ULL,
0x0000003d00647306ULL, 0x000bf00000200c00ULL, 0x0000005400607306ULL, 0x0007e20000200c00ULL,
0x00000100383d7824ULL, 0x022fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00667306ULL, 0x0003e20000200c00ULL,
0x0000888039547816ULL, 0x00cfe400000000ffULL, 0x00000018ff387819ULL, 0x000fca0000011438ULL,
0x0000003e00617306ULL, 0x000fe20000200c00ULL, 0x00000100393c7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000005b005b7306ULL, 0x000e700000200c00ULL,
0x00000038003e7306ULL, 0x0005f00000200c00ULL, 0x0000003900557306ULL, 0x0009e20000200c00ULL,
0x000054105e387816ULL, 0x004fce0000000063ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000541062397816ULL, 0x010fce0000000069ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x000000383010723cULL, 0x000fee0000001810ULL, 0x000100003a397824ULL, 0x000fe200078e00ffULL,
0x0000541067387816ULL, 0x000fe2000000005cULL, 0x0000003d00577306ULL, 0x0009e60000200c00ULL,
0x00000018ff5c7819ULL, 0x000fc40000011439ULL, 0x0000541064397816ULL, 0x002fc6000000005bULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000001003a3d7824ULL, 0x010fc600078e00ffULL,
0x000000383014723cULL, 0x000fe40000001814ULL, 0x00000018ff687819ULL, 0x000fe4000001143dULL,
0x0000003f00657306ULL, 0x0003220000200c00ULL, 0x000088803b3d7816ULL, 0x040fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x000054105d387816ULL, 0x004fe40000000060ULL,
0x000054105f397816ULL, 0x008fe40000000066ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x000088803a3f7816ULL, 0x002fc600000000ffULL,
0x000000383018723cULL, 0x000fe80000001818ULL, 0x0000005600567306ULL, 0x000e660000200c00ULL,
0x0000541065397816ULL, 0x010fe40000000058ULL, 0x0000541061387816ULL, 0x004fc6000000005aULL,
0x0000005400547306ULL, 0x000fe80000200c00ULL, 0x00000038301c723cULL, 0x000fe8000000181cULL,
0x0000003c00597306ULL, 0x000ea60000200c00ULL, 0x0000541056387816ULL, 0x002fe20000000057ULL,
0x00000001ff567424ULL, 0x000fc800078e00ffULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x0000541054397816ULL, 0x004fce0000000059ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x000000383020723cULL, 0x000fe20000001820ULL, 0x000054103e547816ULL, 0x002fcc0000000053ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0186b856073879a7ULL, 0x000262000850003fULL,
0x0000541055557816ULL, 0x004fcc0000000052ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0186885607ff79a7ULL, 0x0003e2000850003fULL, 0x000000543024723cULL, 0x000fec0000001824ULL,
0x0000003f003f7306ULL, 0x000ff00000200c00ULL, 0x00000068003c7306ULL, 0x000eb00000200c00ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x000054103f3c7816ULL, 0x004fce000000003cULL,
0x0000006a003a7306ULL, 0x000eb00000200c00ULL, 0x0000005c005c7306ULL, 0x000ee20000200c00ULL,
0x000054103d3d7816ULL, 0x004fce000000003aULL, 0x0000003b00587306ULL, 0x000ea20000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054105c5c7816ULL, 0x008fe2000000004dULL,
0x000000ffff4d7224ULL, 0x000fe200078e004eULL, 0x00005410585d7816ULL, 0x004fce0000000051ULL,
0x0000005c302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x000000b400100947ULL, 0x002fde0003800000ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011433ULL, 0x0000003b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000202027819ULL, 0x000fc80000001233ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000400209947ULL, 0x000fea0003800000ULL,
0x0000000435517836ULL, 0x000fe20000000000ULL, 0x00000020070a7890ULL, 0x000fe2000fffe03fULL,
0x0000000104027824ULL, 0x000fe200078e0235ULL, 0x0000002008337811ULL, 0x000fe200078e30ffULL,
0x0000000104387824ULL, 0x000fe200078e0251ULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x00000002354d7836ULL, 0x000fe40000000000ULL, 0x0000000102307824ULL, 0x040fe400078e0209ULL,
0x00000010023f7824ULL, 0x000fc400078e00ffULL, 0x0000000138317824ULL, 0x040fe400078e0209ULL,
0x00000010383a7824ULL, 0x000fe200078e00ffULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee230ULL,
0x0000000104327824ULL, 0x000fe400078e024dULL, 0x0000000635557836ULL, 0x000fe20000000000ULL,
0xfffffff03a537812ULL, 0x000fe200078ee231ULL, 0x0000000132307824ULL, 0x040fe400078e0209ULL,
0x00000010324f7824ULL, 0x000fc400078e00ffULL, 0x0000000102317824ULL, 0x000fe200078e0233ULL,
0x0000000a0f027c48ULL, 0x000fe2000ffe0000ULL, 0x00000001043a7824ULL, 0x000fe200078e0255ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee230ULL, 0x0000000132397824ULL, 0x100fe200078e0233ULL,
0x0000005031307210ULL, 0x000fe20007f1e0ffULL, 0x8000000a02317c36ULL, 0x000fe40008000000ULL,
0x00000001383b7824ULL, 0x100fe400078e0233ULL, 0x000000013a577824ULL, 0x040fe200078e0233ULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff3d7224ULL, 0x000fe200000e06ffULL,
0x0000005039337210ULL, 0x000fe20007f9e0ffULL, 0x000000013a327824ULL, 0x040fe200078e0209ULL,
0x000000503b3b7210ULL, 0x000fe20007f5e0ffULL, 0x000000103a597824ULL, 0x000fe200078e00ffULL,
0x0000000c30397c11ULL, 0x040fe2000f8040ffULL, 0x0000000131027824ULL, 0x000fe200078e0a04ULL,
0x0000005057507210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x0000000d30317c11ULL, 0x000fe200080f443dULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0xfffffff059577812ULL, 0x000fe200078ee232ULL, 0x00016000073c7836ULL, 0x000fe20000000000ULL,
0x0000000c33327c11ULL, 0x000fc4000f8840ffULL, 0x0000000c3b387c11ULL, 0x000fe2000f8a40ffULL,
0x000000103f3f7824ULL, 0x100fe200078e023cULL, 0x000000f0363d7812ULL, 0x000fe200078ec0ffULL,
0x000000104f4f7824ULL, 0x000fe200078e023cULL, 0x0000000d33337c11ULL, 0x000fe2000a0f443aULL,
0x0000001053537824ULL, 0x000fe200078e023cULL, 0x0000000d3b3b7c11ULL, 0x000fe2000a8f4430ULL,
0x0000001057577824ULL, 0x000fe200078e023cULL, 0x0000003d39307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x0000003d32327210ULL, 0x000fc40007fbe0ffULL,
0x000000024d00720cULL, 0x080fe20003f06070ULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000023500720cULL, 0x080fe20003f86070ULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x0000000c503a7c11ULL, 0x000fe4000f8640ffULL, 0x000000025100720cULL, 0x080fe40003f46070ULL,
0x000000025500720cULL, 0x000fe40003fa6070ULL, 0x0000003d38387210ULL, 0x000fc40007fde0ffULL,
0x0000000d50027c11ULL, 0x000fe400098f4439ULL, 0x0000003d3a3a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff397224ULL, 0x000fe200030e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303f7faeULL, 0x0003e6000e101c48ULL, 0x000000ffff3b7224ULL, 0x000fe200018e0602ULL,
0x00000000324f7faeULL, 0x0003e8000c101c48ULL, 0x0000000038537faeULL, 0x0003e8000d101c48ULL,
0x000000003a577faeULL, 0x0003e2000e901c48ULL, 0x0000000000ec7947ULL, 0x000fea0003800000ULL,
0x0000000104027824ULL, 0x000fe200078e0235ULL, 0x0000002008397811ULL, 0x000fe200078e30ffULL,
0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL, 0x00016000074d7836ULL, 0x000fe20000000000ULL,
0x000000f036517812ULL, 0x000fe200078ec0ffULL, 0x0000000202387836ULL, 0x000fe40000000000ULL,
0x0000000102307824ULL, 0x140fe400078e0209ULL, 0x0000001002337824ULL, 0x000fe400078e00ffULL,
0x0000000138317824ULL, 0x000fc400078e0209ULL, 0x00000010383a7824ULL, 0x000fe200078e00ffULL,
0xfffffff033327812ULL, 0x000fe200078ee230ULL, 0x0000000402307836ULL, 0x000fe40000000000ULL,
0x00000006023c7836ULL, 0x000fe20000000000ULL, 0xfffffff03a3a7812ULL, 0x000fe200078ee231ULL,
0x0000000139317824ULL, 0x040fe400078e0238ULL, 0x00000001023b7824ULL, 0x000fe400078e0239ULL,
0x0000000139337824ULL, 0x040fe200078e0230ULL, 0x0000003150317210ULL, 0x000fe20007f5e0ffULL,
0x0000000139397824ULL, 0x000fe200078e023cULL, 0x000000503b3b7210ULL, 0x000fe20007f9e0ffULL,
0x0000000130387824ULL, 0x140fe200078e0209ULL, 0x0000003350337210ULL, 0x000fe20007f7e0ffULL,
0x00000010303f7824ULL, 0x000fe200078e00ffULL, 0x0000003950397210ULL, 0x000fe20007f1e0ffULL,
0x000000013c3d7824ULL, 0x000fc400078e0209ULL, 0x000000103c507824ULL, 0x000fe200078e00ffULL,
0xfffffff03f387812ULL, 0x000fe200078ee238ULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x0000000a313c7c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff027224ULL, 0x000fe200020e06ffULL,
0x0000000a3b307c11ULL, 0x000fe2000f8840ffULL, 0x0000001032537824ULL, 0x100fe200078e024dULL,
0x0000000b313e7c11ULL, 0x000fe200090f443eULL, 0x00000010383f7824ULL, 0x100fe200078e024dULL,
0xfffffff050507812ULL, 0x000fe200078ee23dULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x0000000b3b4f7c11ULL, 0x000fe2000a0f4402ULL, 0x000000103a3d7824ULL, 0x100fe200078e024dULL,
0x0000000a33387c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x0000000a393a7c11ULL, 0x000fe2000f8640ffULL, 0x00000010504d7824ULL, 0x000fe200078e024dULL,
0x0000005130307210ULL, 0x000fc40007f9e0ffULL, 0x0000000b333b7c11ULL, 0x000fe400090f4432ULL,
0x000000513c327210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff317224ULL, 0x000fe200020e064fULL,
0x0000000b39027c11ULL, 0x000fe400098f4402ULL, 0x0000005138387210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e063eULL, 0x000000513a3a7210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030537faeULL, 0x0003e4000b901c48ULL,
0x000000ffff397224ULL, 0x000fc400010e063bULL, 0x000000ffff3b7224ULL, 0x000fe200018e0602ULL,
0x00000000323d7faeULL, 0x0003e8000b901c48ULL, 0x00000000383f7faeULL, 0x0003e8000b901c48ULL,
0x000000003a4d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000020b317836ULL, 0x000fe40000000000ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x000000063100720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00008c00ff307b82ULL, 0x000e620000000a00ULL,
0x000000020a337810ULL, 0x000fca0007ffe00bULL, 0x0000000433307825ULL, 0x002fca00078e0030ULL,
0x0000000830027981ULL, 0x000324000c1e1900ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0186b038075079a7ULL, 0x0004e4000850003fULL,
0x01862838033879a7ULL, 0x004464000850003fULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x01862839030075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01862839030075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x018080004b317984ULL, 0x000e620000000800ULL,
0x00000001ff387424ULL, 0x000fe400078e00ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e004eULL,
0x018280004b337984ULL, 0x000b620000000800ULL, 0x0000004e3100720bULL, 0x002fda0003f1d000ULL,
0x0000000000397806ULL, 0x000fc800000e0100ULL, 0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL,
0x0000000000f48947ULL, 0x02cfea0003800000ULL, 0x000000013400780cULL, 0x000fe40003f45270ULL,
0x0000004e3100720bULL, 0x000fd60003f14000ULL, 0x0000004e3130a209ULL, 0x000fe40007810000ULL,
0x0000000000387806ULL, 0x000fc600000e0100ULL, 0x018480304b00a388ULL, 0x0003e20000000800ULL,
0x0000991038327816ULL, 0x000fc800000000ffULL, 0x000000ff3200720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000004e313b7209ULL, 0x000fe40007810000ULL,
0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0038ff7812ULL, 0x000fe2000784c0ffULL,
0x0000004e3b307221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x00000030003b7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff307819ULL, 0x002fcc0000011609ULL, 0x00001f303b307589ULL, 0x004e6400000e0000ULL,
0x0000003010107220ULL, 0x082fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x0000003014147220ULL, 0x080fe20000410000ULL, 0x0000003015157220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x080fe20000410000ULL,
0x0000003028287220ULL, 0x080fe20000410000ULL, 0x0000003029297220ULL, 0x080fe20000410000ULL,
0x000000302c2c7220ULL, 0x080fe20000410000ULL, 0x000000302d2d7220ULL, 0x000fce0000410000ULL,
0x0000003b00007220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000809307811ULL, 0x002fcc00078ff0ffULL, 0x00001f303b307589ULL, 0x000e6400000e0000ULL,
0x0000003012127220ULL, 0x082fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x0000003016167220ULL, 0x080fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x000000302a2a7220ULL, 0x080fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff38ff7812ULL, 0x000fe20007800839ULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x0000004e314d7209ULL, 0x000fd60007810000ULL, 0x8000004d31310221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x00000031000c0308ULL, 0x000ea40000000800ULL, 0x0000000c33330220ULL, 0x004fce0000410000ULL,
0x0000000033007221ULL, 0x000fce0000010000ULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x0186a84c070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186a84c070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991038307816ULL, 0x000fc800000000ffULL,
0x000000ff3000720cULL, 0x000fda0003f45270ULL, 0x0000000000182947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x000fe40000011609ULL, 0x0000000cff0d723eULL, 0x000fc600000000ffULL,
0x0000000831337836ULL, 0x000fe20000000000ULL, 0x000054100d307816ULL, 0x000fca000000000dULL,
0x00001f31300d7589ULL, 0x0002a800000e0000ULL, 0x00001f33300e7589ULL, 0x0002e400000e0000ULL,
0x012800004a30783bULL, 0x0022e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000493c783bULL, 0x000f680000004200ULL, 0x000000004838783bULL, 0x000f640000004200ULL,
0x00000018ff5c7819ULL, 0x022fe2000001143cULL, 0x000001003c537824ULL, 0x040fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001143dULL, 0x000001003d547824ULL, 0x040fe200078e00ffULL,
0x000088803c5e7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d627816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x008fe20000011438ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888038567816ULL, 0x000fe400000000ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000003c00617306ULL, 0x0003e20000200c00ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff597819ULL, 0x000fe4000001143fULL, 0x000088803f5f7816ULL, 0x000fc400000000ffULL,
0x00000018ff527819ULL, 0x000fe20000011439ULL, 0x0000003d00647306ULL, 0x0007e20000200c00ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x0000888039557816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000088803e5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000100383d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fc4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005300657306ULL, 0x0003e20000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff4c7819ULL, 0x000fe4000001143aULL,
0x00000018ff4e7819ULL, 0x000fc6000001143bULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000001003e537824ULL, 0x042fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005400677306ULL, 0x000e620000200c00ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003c00687306ULL, 0x0007f00000200c00ULL,
0x0000003800547306ULL, 0x000be20000200c00ULL, 0x00000100393c7824ULL, 0x048fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001143cULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x000001003b387824ULL, 0x024fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005300607306ULL, 0x000ff00000200c00ULL,
0x0000003f00667306ULL, 0x000ff00000200c00ULL, 0x0000003900537306ULL, 0x0003f00000200c00ULL,
0x00000038003f7306ULL, 0x0005e20000200c00ULL, 0x0000541062397816ULL, 0x002fce0000000067ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x000054105e387816ULL, 0x004fe20000000065ULL,
0x000100003b5e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x0000541061387816ULL, 0x000fe2000000005cULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541064397816ULL, 0x008fce000000005bULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000000383014723cULL, 0x000fee0000001814ULL, 0x0000003e00637306ULL, 0x0007620000200c00ULL,
0x000054105d387816ULL, 0x002fe40000000060ULL, 0x000054105f397816ULL, 0x004fca0000000068ULL,
0x0000003d00577306ULL, 0x0003e20000200c00ULL, 0x000088803b3e7816ULL, 0x008fe200000000ffULL,
0x000000383018723cULL, 0x000fec0000001818ULL, 0x0000005600567306ULL, 0x000ea20000200c00ULL,
0x000001003a3d7824ULL, 0x042fe200078e00ffULL, 0x0000541063387816ULL, 0x020fe2000000005aULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541066397816ULL, 0x000fc40000000059ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000038301c723cULL, 0x000fea000000181cULL,
0x0000005800587306ULL, 0x000e640000200c00ULL, 0x0000541056387816ULL, 0x004fcc0000000057ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000541055397816ULL, 0x002fce0000000058ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000000383020723cULL, 0x000fee0000001820ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003dULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x0000541054547816ULL, 0x004fce000000004fULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541053557816ULL, 0x002fce0000000052ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x000000543024723cULL, 0x000fee0000001824ULL,
0x0000003e003e7306ULL, 0x000e700000200c00ULL, 0x0000003a003b7306ULL, 0x000ea20000200c00ULL,
0x000054103e3d7816ULL, 0x002fce000000003fULL, 0x0000005e005b7306ULL, 0x000e620000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054103b387816ULL, 0x004fe4000000004cULL,
0x000054105b397816ULL, 0x002fce000000004eULL, 0x00000038302c723cULL, 0x000fe2000000182cULL,
0x012800004630783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x084fe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000e31317232ULL, 0x080fe40000000000ULL,
0x0000000e33337232ULL, 0x000fce0000000000ULL, 0x00000000453c783bULL, 0x000ee80000004200ULL,
0x000000004438783bULL, 0x000f620000004200ULL, 0x00000018ff5c7819ULL, 0x008fe2000001143cULL,
0x000001003c537824ULL, 0x040fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d547824ULL, 0x040fe200078e00ffULL, 0x000088803c5e7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d627816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x022fe20000011438ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000888038567816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000003c00617306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff597819ULL, 0x000fe4000001143fULL,
0x000088803f5f7816ULL, 0x000fc400000000ffULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003d00647306ULL, 0x0007e20000200c00ULL, 0x000001003f3c7824ULL, 0x002fe200078e00ffULL,
0x0000888039557816ULL, 0x000fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000088803e5d7816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000100383d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005300657306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff4c7819ULL, 0x000fe4000001143aULL, 0x00000018ff4e7819ULL, 0x000fc6000001143bULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000001003e537824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005400677306ULL, 0x000e620000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c00687306ULL, 0x0007f00000200c00ULL, 0x0000003800547306ULL, 0x000be20000200c00ULL,
0x00000100393c7824ULL, 0x048fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001143cULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x000001003b387824ULL, 0x024fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000005300607306ULL, 0x000ff00000200c00ULL, 0x0000003f00667306ULL, 0x000ff00000200c00ULL,
0x0000003900537306ULL, 0x0003f00000200c00ULL, 0x00000038003f7306ULL, 0x0005e20000200c00ULL,
0x0000541062397816ULL, 0x002fce0000000067ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x000054105e387816ULL, 0x004fe20000000065ULL, 0x000100003b5e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x000000383010723cULL, 0x000fee0000001810ULL, 0x0000541061387816ULL, 0x000fe2000000005cULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x0000541064397816ULL, 0x008fce000000005bULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000000383014723cULL, 0x000fee0000001814ULL,
0x0000003e00637306ULL, 0x0007620000200c00ULL, 0x000054105d387816ULL, 0x002fe40000000060ULL,
0x000054105f397816ULL, 0x004fca0000000068ULL, 0x0000003d00577306ULL, 0x0003e20000200c00ULL,
0x000088803b3e7816ULL, 0x008fe200000000ffULL, 0x000000383018723cULL, 0x000fec0000001818ULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x000001003a3d7824ULL, 0x042fe200078e00ffULL,
0x0000541063387816ULL, 0x020fe2000000005aULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541066397816ULL, 0x000fc40000000059ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038301c723cULL, 0x000fea000000181cULL, 0x0000005800587306ULL, 0x000e640000200c00ULL,
0x0000541056387816ULL, 0x004fcc0000000057ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541055397816ULL, 0x002fce0000000058ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x000000383020723cULL, 0x000fee0000001820ULL, 0x0000003a003b7306ULL, 0x0002b00000200c00ULL,
0x0000005e005b7306ULL, 0x000ee20000200c00ULL, 0x00000001ff3a7424ULL, 0x002fe200078e00ffULL,
0x000054103b387816ULL, 0x004fcc000000004cULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054105b397816ULL, 0x008fce000000004eULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x00000038302c723cULL, 0x000fee000000182cULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x0186b83a073879a7ULL, 0x0006e2000850003fULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x0000541054547816ULL, 0x004fce000000004fULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000541053557816ULL, 0x002fce0000000052ULL,
0x000000543024723cULL, 0x000fe20000001824ULL, 0x000054103e3d7816ULL, 0x004fce000000003fULL,
0x0000003c3028723cULL, 0x008fde0000001828ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008400000a7ab9ULL, 0x000fe40000000800ULL, 0x0000000a024e7c24ULL, 0x010fc8000f8e02ffULL,
0x000000404e4e7824ULL, 0x000fe200078e00ffULL, 0x00000004001c9947ULL, 0x000fec0003800000ULL,
0x0000000235537836ULL, 0x000fe20000000000ULL, 0x00000040070a7890ULL, 0x000fe2000fffe03fULL,
0x0000000104307824ULL, 0x040fe200078e0235ULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000104327824ULL, 0x000fe200078e0253ULL, 0x000000f0364c7812ULL, 0x000fe200078ec0ffULL,
0x0000000130317824ULL, 0x140fe400078e0209ULL, 0x00000010303a7824ULL, 0x000fe400078e00ffULL,
0x00000040083f7824ULL, 0x000fe200078e0230ULL, 0x0000000a0f307c48ULL, 0x000fe2000ffe0000ULL,
0x0000000132337824ULL, 0x040fe200078e0209ULL, 0xfffffff03a4f7812ULL, 0x000fe200078ee231ULL,
0x00000010323c7824ULL, 0x000fe200078e00ffULL, 0x0000004e3f397210ULL, 0x000fe20007f1e0ffULL,
0x0000000435577836ULL, 0x000fc40000000000ULL, 0x8000000a30317c36ULL, 0x000fe20008000000ULL,
0xfffffff03c557812ULL, 0x000fe200078ee233ULL, 0x000000023f337836ULL, 0x000fe40000000000ULL,
0x0000000104387824ULL, 0x000fe200078e0257ULL, 0x0000003104317248ULL, 0x000fe20007fe0000ULL,
0x000000043f3d7836ULL, 0x000fe20000000000ULL, 0x0000004e33307210ULL, 0x000fe20007f7e0ffULL,
0x0000000138327824ULL, 0x040fe400078e0209ULL, 0x0000001038597824ULL, 0x000fc400078e00ffULL,
0x00000001313a7824ULL, 0x000fe400078e0a04ULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0xfffffff059597812ULL, 0x000fe200078ee232ULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x0000000c39327c11ULL, 0x000fe2000f8040ffULL, 0x00014000073e7836ULL, 0x000fe20000000000ULL,
0x0000000c303b7c11ULL, 0x040fe4000f8640ffULL, 0x0000003a3500720cULL, 0x000fe20003f86070ULL,
0x000000104f4f7824ULL, 0x000fe200078e023eULL, 0x0000000d39397c11ULL, 0x000fe200080f4438ULL,
0x0000001055557824ULL, 0x100fe200078e023eULL, 0x0000000d30317c11ULL, 0x000fe200098f4433ULL,
0x0000001059597824ULL, 0x000fe200078e023eULL, 0x0000004e3d3d7210ULL, 0x000fc40007f1e0ffULL,
0x0000004c32327210ULL, 0x000fe40007f7e0ffULL, 0x0000000c3d387c11ULL, 0x000fe2000f8a40ffULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x0000003a5300720cULL, 0x080fe20003f06070ULL,
0x000000ffff337224ULL, 0x000fe200018e0639ULL, 0x0000003a5700720cULL, 0x000fe20003f66070ULL,
0x000000063f397836ULL, 0x000fe20000000000ULL, 0x0000000d3d3d7c11ULL, 0x000fe2000a8f4430ULL,
0x0000000635537836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000324f7faeULL, 0x0003e2000e101c48ULL, 0x0000004c3b307210ULL, 0x000fc40007fbe0ffULL,
0x00000001043c7824ULL, 0x000fe200078e0253ULL, 0x0000004e39397210ULL, 0x000fe40007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x0000003a5300720cULL, 0x000fe20003fa6070ULL,
0x000000013c3f7824ULL, 0x040fe200078e0209ULL, 0x0000004c38387210ULL, 0x000fe20007fde0ffULL,
0x000000103c527824ULL, 0x000fe200078e00ffULL, 0x0000000030557faeULL, 0x0005e2000c101c48ULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x0000000c393b7c11ULL, 0x000fc4000f8840ffULL,
0xfffffff0523f7812ULL, 0x000fe400078ee23fULL, 0x0000000d39337c11ULL, 0x002fe2000a0f443cULL,
0x000000ffff397224ULL, 0x000fe200030e063dULL, 0x0000004c3b327210ULL, 0x000fe20007f9e0ffULL,
0x000000103f3f7824ULL, 0x000fc600078e023eULL, 0x0000000038597faeULL, 0x0005e2000d901c48ULL,
0x000000ffff337224ULL, 0x000fca00020e0633ULL, 0x00000000323f7faeULL, 0x0005e2000e901c48ULL,
0x0000000000e87947ULL, 0x000fea0003800000ULL, 0x0000000104307824ULL, 0x000fe200078e0235ULL,
0x00008a00000a7ab9ULL, 0x000fc60000000a00ULL, 0x0000000130317824ULL, 0x140fe400078e0209ULL,
0x00000010303a7824ULL, 0x000fe400078e00ffULL, 0x0000000230327836ULL, 0x000fe40000000000ULL,
0x0000000430387836ULL, 0x000fe20000000000ULL, 0xfffffff03a397812ULL, 0x000fe200078ee231ULL,
0x0000000132337824ULL, 0x040fe400078e0209ULL, 0x00000010323a7824ULL, 0x000fc400078e00ffULL,
0x0000000138327824ULL, 0x140fe400078e0209ULL, 0x0000001038537824ULL, 0x000fe200078e00ffULL,
0xfffffff03a3f7812ULL, 0x000fe200078ee233ULL, 0x0000004008317824ULL, 0x000fe400078e0230ULL,
0x0000000630307836ULL, 0x000fe20000000000ULL, 0xfffffff053537812ULL, 0x000fe200078ee232ULL,
0x00000002313b7836ULL, 0x000fe20000000000ULL, 0x0000004e31327210ULL, 0x000fe20007f1e0ffULL,
0x00000001303a7824ULL, 0x000fc400078e0209ULL, 0x0000001030557824ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x0000000a32387c11ULL, 0x040fe2000f8040ffULL,
0x0001400007307836ULL, 0x000fe20000000000ULL, 0xfffffff055557812ULL, 0x000fe200078ee23aULL,
0x00000004314f7836ULL, 0x000fe20000000000ULL, 0x0000000b32337c11ULL, 0x000fe200080f4433ULL,
0x0000000631317836ULL, 0x000fe20000000000ULL, 0x0000004e3b3b7210ULL, 0x000fe20007f1e0ffULL,
0x00000010393d7824ULL, 0x100fe200078e0230ULL, 0x0000004e4f4f7210ULL, 0x000fe20007f7e0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0230ULL, 0x0000004e313e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x0000000a3b3a7c11ULL, 0x000fe2000f8040ffULL,
0x0000001053537824ULL, 0x000fc400078e0230ULL, 0x0000001055577824ULL, 0x000fe200078e0230ULL,
0x0000000b3b397c11ULL, 0x000fe200080f4432ULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x000000f0363b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff557224ULL, 0x000fe200020e06ffULL,
0x0000000a4f3c7c11ULL, 0x040fe4000f8640ffULL, 0x0000003b38307210ULL, 0x000fe40007f1e0ffULL,
0x0000000a3e4c7c11ULL, 0x000fe4000f8840ffULL, 0x0000000b4f4f7c11ULL, 0x000fe200098f4432ULL,
0x000000ffff317224ULL, 0x000fe200000e0633ULL, 0x0000003b3a327210ULL, 0x000fc40007f1e0ffULL,
0x0000000b3e557c11ULL, 0x000fe4000a0f4455ULL, 0x0000003b3c387210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e0639ULL, 0x0000003b4c3a7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303d7faeULL, 0x0003e4000b901c48ULL,
0x000000ffff397224ULL, 0x000fe400018e064fULL, 0x000000ffff3b7224ULL, 0x000fe200020e0655ULL,
0x00000000323f7faeULL, 0x0003e8000b901c48ULL, 0x0000000038537faeULL, 0x0003e8000b901c48ULL,
0x000000003a577faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x006fe20000000000ULL,
0x00000001ff307424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0186a830073079a7ULL, 0x000e64000850003fULL,
0x000000ffff4c7224ULL, 0x002fe200078e0031ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b051070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186b051070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000182947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x000fe40000011609ULL, 0x0000000cff0d723eULL, 0x000fc600000000ffULL,
0x0000000831337836ULL, 0x000fe20000000000ULL, 0x000054100d307816ULL, 0x000fca000000000dULL,
0x00001f31300d7589ULL, 0x0002a800000e0000ULL, 0x00001f33300e7589ULL, 0x0002e400000e0000ULL,
0x012800004730783bULL, 0x0022e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000433c783bULL, 0x000f280000004200ULL, 0x000000004238783bULL, 0x000f620000004200ULL,
0x00000018ff5c7819ULL, 0x010fe2000001143cULL, 0x000001003c537824ULL, 0x040fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001143dULL, 0x000001003d547824ULL, 0x040fe200078e00ffULL,
0x000088803c5e7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d627816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x022fe20000011438ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888038567816ULL, 0x000fe400000000ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000003c00617306ULL, 0x0003e20000200c00ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff597819ULL, 0x000fe4000001143fULL, 0x000088803f5f7816ULL, 0x000fc400000000ffULL,
0x00000018ff527819ULL, 0x000fe20000011439ULL, 0x0000003d00647306ULL, 0x0009e20000200c00ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x0000888039557816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001143eULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000100383d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x000088803e5d7816ULL, 0x000fc400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005300657306ULL, 0x0003e20000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff4f7819ULL, 0x000fe4000001143aULL,
0x00000018ff507819ULL, 0x000fc6000001143bULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000001003e537824ULL, 0x042fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005400677306ULL, 0x000e620000200c00ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003c00687306ULL, 0x0009f00000200c00ULL,
0x0000003800547306ULL, 0x000be20000200c00ULL, 0x00000100393c7824ULL, 0x050fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001143cULL,
0x0000005b005b7306ULL, 0x000f220000200c00ULL, 0x000001003b387824ULL, 0x028fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005300607306ULL, 0x000ff00000200c00ULL,
0x0000003f00667306ULL, 0x000ff00000200c00ULL, 0x0000003900537306ULL, 0x0003f00000200c00ULL,
0x00000038003f7306ULL, 0x0007e20000200c00ULL, 0x0000541062397816ULL, 0x002fce0000000067ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x000054105e387816ULL, 0x008fce0000000065ULL,
0x0000005f005f7306ULL, 0x000ee20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x0000003e00637306ULL, 0x000be20000200c00ULL, 0x0000541061387816ULL, 0x000fe4000000005cULL,
0x0000541064397816ULL, 0x010fca000000005bULL, 0x0000003d00577306ULL, 0x0009e20000200c00ULL,
0x000088803b3e7816ULL, 0x064fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383014723cULL, 0x000fe80000001814ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x000001003a3d7824ULL, 0x050fe200078e00ffULL,
0x000054105d387816ULL, 0x002fe20000000060ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000054105f397816ULL, 0x008fc40000000068ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000000383018723cULL, 0x000fea0000001818ULL, 0x0000005500557306ULL, 0x000fe40000200c00ULL,
0x0000541063387816ULL, 0x004fc4000000005aULL, 0x0000541066397816ULL, 0x002fc80000000059ULL,
0x0000005800587306ULL, 0x000e660000200c00ULL, 0x00000038301c723cULL, 0x000fea000000181cULL,
0x0000003c003c7306ULL, 0x000fe40000200c00ULL, 0x0000541055397816ULL, 0x002fcc0000000058ULL,
0x0000003d003d7306ULL, 0x000e700000200c00ULL, 0x0000005100517306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x0000541054547816ULL, 0x004fce0000000051ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541053557816ULL, 0x002fce0000000052ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000000543024723cULL, 0x000fee0000001824ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000541056387816ULL, 0x002fce0000000057ULL,
0x0000003a003a7306ULL, 0x000e620000200c00ULL, 0x000000383020723cULL, 0x000fe20000001820ULL,
0x000054103e3d7816ULL, 0x004fcc000000003fULL, 0x0000003b003b7306ULL, 0x000ea20000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054103a3a7816ULL, 0x002fe4000000004fULL,
0x000054103b3b7816ULL, 0x004fce0000000050ULL, 0x0000003a302c723cULL, 0x000fe2000000182cULL,
0x012800003730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x084fe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000e31317232ULL, 0x080fe40000000000ULL,
0x0000000e33337232ULL, 0x000fce0000000000ULL, 0x00000000413c783bULL, 0x000ee20000004200ULL,
0x00000040070a7890ULL, 0x000fc6000fffe03fULL, 0x000000004038783bULL, 0x000f260000004200ULL,
0x0000000a0f007c0cULL, 0x000fe4000bf03070ULL, 0x00000018ff5c7819ULL, 0x008fe2000001143cULL,
0x000001003c537824ULL, 0x040fe200078e00ffULL, 0x000088803c577816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d547824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000001003b677824ULL, 0x010fe200078e00ffULL, 0x000088803d607816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff597819ULL, 0x000fe2000001143fULL, 0x0000005300627306ULL, 0x0007e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803f5f7816ULL, 0x000fe400000000ffULL,
0x00000018ff517819ULL, 0x000fe40000011438ULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003c00637306ULL, 0x0009e20000200c00ULL, 0x000001003e537824ULL, 0x008fe200078e00ffULL,
0x0000888038557816ULL, 0x000fc400000000ffULL, 0x000088803e5d7816ULL, 0x040fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005700577306ULL, 0x000ee20000200c00ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001143aULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff507819ULL, 0x000fc6000001143bULL,
0x0000005400657306ULL, 0x000f300000200c00ULL, 0x0000003d00667306ULL, 0x000bf00000200c00ULL,
0x00000053005e7306ULL, 0x0007e20000200c00ULL, 0x00000100383d7824ULL, 0x022fc400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00687306ULL, 0x0003e20000200c00ULL, 0x0000888039537816ULL, 0x00cfe400000000ffULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x00000100393c7824ULL, 0x042fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001143cULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003f00647306ULL, 0x000fe20000200c00ULL, 0x000088803a3c7816ULL, 0x000fce00000000ffULL,
0x0000003800547306ULL, 0x0003f00000200c00ULL, 0x00000039003f7306ULL, 0x0009e20000200c00ULL,
0x0000541057387816ULL, 0x002fe40000000062ULL, 0x00000018ff577819ULL, 0x000fca0000011467ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x0000541060397816ULL, 0x010fce0000000065ULL,
0x0000005f005f7306ULL, 0x000ee20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x0000003e00617306ULL, 0x0009e20000200c00ULL, 0x0000541063387816ULL, 0x000fe4000000005cULL,
0x0000541066397816ULL, 0x004fca000000005bULL, 0x0000003d00567306ULL, 0x0005e20000200c00ULL,
0x000088803b3e7816ULL, 0x050fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383014723cULL, 0x000fe80000001814ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005a005a7306ULL, 0x000f220000200c00ULL, 0x000001003a3d7824ULL, 0x044fe200078e00ffULL,
0x000054105d387816ULL, 0x002fe2000000005eULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000054105f397816ULL, 0x008fc40000000068ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000000383018723cULL, 0x000fea0000001818ULL, 0x0000005500557306ULL, 0x000ea40000200c00ULL,
0x0000541061387816ULL, 0x010fc4000000005aULL, 0x0000541064397816ULL, 0x002fc80000000059ULL,
0x0000005300537306ULL, 0x000fe60000200c00ULL, 0x00000038301c723cULL, 0x000fea000000181cULL,
0x0000005800587306ULL, 0x000e640000200c00ULL, 0x0000541055387816ULL, 0x004fe20000000056ULL,
0x00000001ff567424ULL, 0x000fca00078e00ffULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541053397816ULL, 0x002fce0000000058ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000000383020723cULL, 0x000fee0000001820ULL, 0x0000005100517306ULL, 0x000ea20000200c00ULL,
0x0186b856073879a7ULL, 0x0006e2000850003fULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x0186905607ff79a7ULL, 0x0007e2000850003fULL,
0x0000541054547816ULL, 0x004fcc0000000051ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x000054103f557816ULL, 0x002fce0000000052ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000000543024723cULL, 0x000fee0000001824ULL, 0x0000003e003e7306ULL, 0x000ff00000200c00ULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x0000003a003a7306ULL, 0x000ea20000200c00ULL,
0x000054103e3d7816ULL, 0x002fce0000000057ULL, 0x0000003b003b7306ULL, 0x000e620000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054103a3a7816ULL, 0x004fe2000000004fULL,
0x000000020b4f7836ULL, 0x000fe20000000000ULL, 0x000054103b3b7816ULL, 0x002fce0000000050ULL,
0x0000003a302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000007800080947ULL, 0x008fde0003800000ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011433ULL, 0x0000003b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000202027819ULL, 0x000fc80000001233ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000400209947ULL, 0x000fea0003800000ULL,
0x0000000435537836ULL, 0x000fe20000000000ULL, 0x00000060070a7890ULL, 0x000fe2000fffe03fULL,
0x0000000104027824ULL, 0x000fe200078e0235ULL, 0x0000002008337811ULL, 0x000fe200078e30ffULL,
0x0000000104387824ULL, 0x000fe200078e0253ULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x00000002354f7836ULL, 0x000fe40000000000ULL, 0x0000000102307824ULL, 0x040fe400078e0209ULL,
0x00000010023f7824ULL, 0x000fc400078e00ffULL, 0x0000000138317824ULL, 0x040fe400078e0209ULL,
0x00000010383a7824ULL, 0x000fe200078e00ffULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee230ULL,
0x0000000104327824ULL, 0x000fe400078e024fULL, 0x0000000635577836ULL, 0x000fe20000000000ULL,
0xfffffff03a557812ULL, 0x000fe200078ee231ULL, 0x0000000132307824ULL, 0x040fe400078e0209ULL,
0x0000001032517824ULL, 0x000fc400078e00ffULL, 0x0000000102317824ULL, 0x000fe200078e0233ULL,
0x0000000a0f027c48ULL, 0x000fe2000ffe0000ULL, 0x00000001043a7824ULL, 0x000fe200078e0257ULL,
0xfffffff051517812ULL, 0x000fe200078ee230ULL, 0x0000000132397824ULL, 0x100fe200078e0233ULL,
0x0000004e31307210ULL, 0x000fe20007f1e0ffULL, 0x8000000a02317c36ULL, 0x000fe40008000000ULL,
0x00000001383b7824ULL, 0x100fe400078e0233ULL, 0x000000013a597824ULL, 0x040fe200078e0233ULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff3d7224ULL, 0x000fe200000e06ffULL,
0x0000004e39337210ULL, 0x000fe20007f9e0ffULL, 0x000000013a327824ULL, 0x040fe200078e0209ULL,
0x0000004e3b3b7210ULL, 0x000fe20007f5e0ffULL, 0x000000103a5b7824ULL, 0x000fe200078e00ffULL,
0x0000000c30397c11ULL, 0x040fe2000f8040ffULL, 0x0000000131027824ULL, 0x000fe200078e0a04ULL,
0x0000004e594e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x0000000d30317c11ULL, 0x000fe200080f443dULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0xfffffff05b597812ULL, 0x000fe200078ee232ULL, 0x00016000073c7836ULL, 0x000fe20000000000ULL,
0x0000000c33327c11ULL, 0x000fc4000f8840ffULL, 0x0000000c3b387c11ULL, 0x000fe2000f8a40ffULL,
0x000000103f3f7824ULL, 0x100fe200078e023cULL, 0x000000f0363d7812ULL, 0x000fe200078ec0ffULL,
0x0000001051517824ULL, 0x000fe200078e023cULL, 0x0000000d33337c11ULL, 0x000fe2000a0f443aULL,
0x0000001055557824ULL, 0x000fe200078e023cULL, 0x0000000d3b3b7c11ULL, 0x000fe2000a8f4430ULL,
0x0000001059597824ULL, 0x000fe200078e023cULL, 0x0000003d39307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x0000003d32327210ULL, 0x000fc40007fbe0ffULL,
0x000000024f00720cULL, 0x080fe20003f06070ULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000023500720cULL, 0x080fe20003f86070ULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x0000000c4e3a7c11ULL, 0x000fe4000f8640ffULL, 0x000000025300720cULL, 0x080fe40003f46070ULL,
0x000000025700720cULL, 0x000fe40003fa6070ULL, 0x0000003d38387210ULL, 0x000fc40007fde0ffULL,
0x0000000d4e027c11ULL, 0x000fe400098f4439ULL, 0x0000003d3a3a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff397224ULL, 0x000fe200030e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303f7faeULL, 0x0003e6000e101c48ULL, 0x000000ffff3b7224ULL, 0x000fe200018e0602ULL,
0x0000000032517faeULL, 0x0003e8000c101c48ULL, 0x0000000038557faeULL, 0x0003e8000d101c48ULL,
0x000000003a597faeULL, 0x0003e2000e901c48ULL, 0x0000000000ec7947ULL, 0x000fea0003800000ULL,
0x0000000104027824ULL, 0x000fe200078e0235ULL, 0x0000002008317811ULL, 0x000fe200078e30ffULL,
0x00008a00000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000202327836ULL, 0x000fe40000000000ULL,
0x0000000102307824ULL, 0x140fe400078e0209ULL, 0x00000010023b7824ULL, 0x000fe400078e00ffULL,
0x0000000132337824ULL, 0x000fc400078e0209ULL, 0x0000001032387824ULL, 0x000fe200078e00ffULL,
0xfffffff03b3b7812ULL, 0x000fe200078ee230ULL, 0x0000000402307836ULL, 0x000fe40000000000ULL,
0x0000000131397824ULL, 0x040fe200078e0232ULL, 0xfffffff0383f7812ULL, 0x000fe200078ee233ULL,
0x0000000602387836ULL, 0x000fe40000000000ULL, 0x0000000102337824ULL, 0x000fe200078e0231ULL,
0x0000004e393c7210ULL, 0x000fe20007f5e0ffULL, 0x00000001313d7824ULL, 0x000fc400078e0230ULL,
0x0000000131317824ULL, 0x000fe200078e0238ULL, 0x0000004e33337210ULL, 0x000fe20007f9e0ffULL,
0x00000010303e7824ULL, 0x000fe200078e00ffULL, 0x0000004e3d397210ULL, 0x000fe20007f7e0ffULL,
0x00000001383d7824ULL, 0x100fe200078e0209ULL, 0x0000004e31027210ULL, 0x000fe20007f1e0ffULL,
0x0000000130317824ULL, 0x000fe400078e0209ULL, 0x0000001038387824ULL, 0x000fe400078e00ffULL,
0x0001600007307836ULL, 0x000fe20000000000ULL, 0xfffffff03e537812ULL, 0x000fe200078ee231ULL,
0x000000ffff327224ULL, 0x000fe200020e06ffULL, 0x0000000a333a7c11ULL, 0x000fe2000f8840ffULL,
0x000000103b4f7824ULL, 0x100fe200078e0230ULL, 0xfffffff038557812ULL, 0x000fe200078ee23dULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x0000000a3c3b7c11ULL, 0x000fe2000f8440ffULL,
0x000000103f517824ULL, 0x100fe200078e0230ULL, 0x000000f0363f7812ULL, 0x000fe200078ec0ffULL,
0x0000001053537824ULL, 0x000fe200078e0230ULL, 0x0000000b333d7c11ULL, 0x000fe2000a0f4432ULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x0000000b3c3c7c11ULL, 0x000fe200090f4431ULL,
0x0000001055557824ULL, 0x000fe200078e0230ULL, 0x0000000a39387c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x0000003f3a307210ULL, 0x000fc40007f9e0ffULL,
0x0000000a023a7c11ULL, 0x040fe4000f8640ffULL, 0x0000000b39397c11ULL, 0x000fe200090f4432ULL,
0x000000ffff317224ULL, 0x000fe200020e063dULL, 0x0000003f3b327210ULL, 0x000fe40007f1e0ffULL,
0x0000000b02027c11ULL, 0x000fe400098f4433ULL, 0x0000003f38387210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e063cULL, 0x0000003f3a3a7210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000304f7faeULL, 0x0003e4000b901c48ULL,
0x000000ffff397224ULL, 0x000fc400010e0639ULL, 0x000000ffff3b7224ULL, 0x000fe200018e0602ULL,
0x0000000032517faeULL, 0x0003e8000b901c48ULL, 0x0000000038537faeULL, 0x0003e8000b901c48ULL,
0x000000003a557faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000030b337836ULL, 0x000fe40000000000ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x000000063300720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00008c00ff307b82ULL, 0x000e620000000a00ULL,
0x000000010a337824ULL, 0x000fc800078e0233ULL, 0x0000000433307825ULL, 0x002fca00078e0030ULL,
0x0000000830027981ULL, 0x000324000c1e1900ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0186b038075079a7ULL, 0x0004e4000850003fULL,
0x01864838033879a7ULL, 0x004464000850003fULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x01864839030075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01864839030075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x018100004b307984ULL, 0x000e620000000800ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x018300004b317984ULL, 0x000b620000000800ULL,
0x0000004d3000720bULL, 0x002fda0003f1d000ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x02cfea0003800000ULL,
0x000000023400780cULL, 0x000fe40003f45270ULL, 0x0000004d3000720bULL, 0x000fd60003f14000ULL,
0x000000304d32a209ULL, 0x000fe40007810000ULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x018500324b00a388ULL, 0x0003e20000000800ULL, 0x0000991038337816ULL, 0x000fc800000000ffULL,
0x000000ff3300720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x000000304d327209ULL, 0x040fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000784c0ffULL, 0x800000324d327221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b32327820ULL, 0x000fc80000410000ULL, 0x0000003200337308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff327819ULL, 0x002fcc0000011609ULL,
0x00001f3233327589ULL, 0x004e6400000e0000ULL, 0x0000003210107220ULL, 0x082fe20000410000ULL,
0x0000003211117220ULL, 0x080fe20000410000ULL, 0x0000003214147220ULL, 0x080fe20000410000ULL,
0x0000003215157220ULL, 0x080fe20000410000ULL, 0x0000003218187220ULL, 0x080fe20000410000ULL,
0x0000003219197220ULL, 0x080fe20000410000ULL, 0x000000321c1c7220ULL, 0x080fe20000410000ULL,
0x000000321d1d7220ULL, 0x080fe20000410000ULL, 0x0000003220207220ULL, 0x080fe20000410000ULL,
0x0000003221217220ULL, 0x080fe20000410000ULL, 0x0000003224247220ULL, 0x080fe20000410000ULL,
0x0000003225257220ULL, 0x080fe20000410000ULL, 0x0000003228287220ULL, 0x080fe20000410000ULL,
0x0000003229297220ULL, 0x080fe20000410000ULL, 0x000000322c2c7220ULL, 0x080fe20000410000ULL,
0x000000322d2d7220ULL, 0x000fce0000410000ULL, 0x0000003300007220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000809327811ULL, 0x002fcc00078ff0ffULL,
0x00001f3233327589ULL, 0x000e6400000e0000ULL, 0x0000003212127220ULL, 0x082fe20000410000ULL,
0x0000003213137220ULL, 0x080fe20000410000ULL, 0x0000003216167220ULL, 0x080fe20000410000ULL,
0x0000003217177220ULL, 0x080fe20000410000ULL, 0x000000321a1a7220ULL, 0x080fe20000410000ULL,
0x000000321b1b7220ULL, 0x080fe20000410000ULL, 0x000000321e1e7220ULL, 0x080fe20000410000ULL,
0x000000321f1f7220ULL, 0x080fe20000410000ULL, 0x0000003222227220ULL, 0x080fe20000410000ULL,
0x0000003223237220ULL, 0x080fe20000410000ULL, 0x0000003226267220ULL, 0x080fe20000410000ULL,
0x0000003227277220ULL, 0x080fe20000410000ULL, 0x000000322a2a7220ULL, 0x080fe20000410000ULL,
0x000000322b2b7220ULL, 0x080fe20000410000ULL, 0x000000322e2e7220ULL, 0x080fe20000410000ULL,
0x000000322f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x000000304d4d7209ULL, 0x000fd60007810000ULL,
0x8000004d30300221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL, 0x00000030000c0308ULL, 0x000ea40000000800ULL,
0x0000000c31310220ULL, 0x004fce0000410000ULL, 0x0000000031007221ULL, 0x000fce0000010000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x0186a84c070075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x002fce0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186a84c070075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000991038307816ULL, 0x000fc800000000ffULL, 0x000000ff3000720cULL, 0x000fda0003f45270ULL,
0x0000000000182947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011609ULL,
0x0000000cff0d723eULL, 0x000fc600000000ffULL, 0x0000000831337836ULL, 0x000fe20000000000ULL,
0x000054100d307816ULL, 0x000fca000000000dULL, 0x00001f31300d7589ULL, 0x0004e800000e0000ULL,
0x00001f33300e7589ULL, 0x00046400000e0000ULL, 0x013000004a30783bULL, 0x0062a20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000e31317232ULL, 0x080fe40000000000ULL,
0x0000000e33337232ULL, 0x000fce0000000000ULL, 0x00000000493c783bULL, 0x000f680000004200ULL,
0x000000004838783bULL, 0x000f640000004200ULL, 0x00000018ff5c7819ULL, 0x022fe2000001143cULL,
0x000001003c537824ULL, 0x040fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d547824ULL, 0x040fe200078e00ffULL, 0x000088803c5e7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d627816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x008fe20000011438ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000888038567816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000003c00617306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff597819ULL, 0x000fe4000001143fULL,
0x000088803f5f7816ULL, 0x000fc400000000ffULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003d00647306ULL, 0x0007e20000200c00ULL, 0x000001003f3c7824ULL, 0x002fe200078e00ffULL,
0x0000888039557816ULL, 0x000fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000088803e5d7816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000100383d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005300657306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff4c7819ULL, 0x000fe4000001143aULL, 0x00000018ff4e7819ULL, 0x000fc6000001143bULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000001003e537824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005400677306ULL, 0x000e620000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c00687306ULL, 0x0007f00000200c00ULL, 0x0000003800547306ULL, 0x000be20000200c00ULL,
0x00000100393c7824ULL, 0x048fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001143cULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x000001003b387824ULL, 0x024fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000005300607306ULL, 0x000ff00000200c00ULL, 0x0000003f00667306ULL, 0x000ff00000200c00ULL,
0x0000003900537306ULL, 0x0003f00000200c00ULL, 0x00000038003f7306ULL, 0x0005e20000200c00ULL,
0x0000541062397816ULL, 0x002fce0000000067ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x000054105e387816ULL, 0x004fe20000000065ULL, 0x000100003b5e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x000000383010723cULL, 0x000fee0000001810ULL, 0x0000541061387816ULL, 0x000fe2000000005cULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x0000541064397816ULL, 0x008fce000000005bULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000000383014723cULL, 0x000fee0000001814ULL,
0x0000003e00637306ULL, 0x0007620000200c00ULL, 0x000054105d387816ULL, 0x002fe40000000060ULL,
0x000054105f397816ULL, 0x004fca0000000068ULL, 0x0000003d00577306ULL, 0x0003e20000200c00ULL,
0x000088803b3e7816ULL, 0x008fe200000000ffULL, 0x000000383018723cULL, 0x000fec0000001818ULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x000001003a3d7824ULL, 0x042fe200078e00ffULL,
0x0000541063387816ULL, 0x020fe2000000005aULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541066397816ULL, 0x000fc40000000059ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038301c723cULL, 0x000fea000000181cULL, 0x0000005800587306ULL, 0x000e640000200c00ULL,
0x0000541056387816ULL, 0x004fcc0000000057ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541055397816ULL, 0x002fce0000000058ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000000383020723cULL, 0x000fee0000001820ULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x0000541054547816ULL, 0x004fce000000004fULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541053557816ULL, 0x002fce0000000052ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x000000543024723cULL, 0x000fee0000001824ULL, 0x0000003e003e7306ULL, 0x000e700000200c00ULL,
0x0000003a003b7306ULL, 0x000ea20000200c00ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000005e005b7306ULL, 0x000e620000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103b387816ULL, 0x004fe4000000004cULL, 0x000054105b397816ULL, 0x002fce000000004eULL,
0x00000038302c723cULL, 0x000fe2000000182cULL, 0x013000004630783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000453c783bULL, 0x000ee80000004200ULL, 0x000000004438783bULL, 0x000f620000004200ULL,
0x00000018ff5c7819ULL, 0x008fe2000001143cULL, 0x000001003c537824ULL, 0x040fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001143dULL, 0x000001003d547824ULL, 0x040fe200078e00ffULL,
0x000088803c5e7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d627816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x022fe20000011438ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888038567816ULL, 0x000fe400000000ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000003c00617306ULL, 0x0003e20000200c00ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff597819ULL, 0x000fe4000001143fULL, 0x000088803f5f7816ULL, 0x000fc400000000ffULL,
0x00000018ff527819ULL, 0x000fe20000011439ULL, 0x0000003d00647306ULL, 0x0007e20000200c00ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x0000888039557816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000088803e5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000100383d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fc4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005300657306ULL, 0x0003e20000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff4c7819ULL, 0x000fe4000001143aULL,
0x00000018ff4e7819ULL, 0x000fc6000001143bULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000001003e537824ULL, 0x042fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005400677306ULL, 0x000e620000200c00ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003c00687306ULL, 0x0007f00000200c00ULL,
0x0000003800547306ULL, 0x000be20000200c00ULL, 0x00000100393c7824ULL, 0x048fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001143cULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x000001003b387824ULL, 0x024fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005300607306ULL, 0x000ff00000200c00ULL,
0x0000003f00667306ULL, 0x000ff00000200c00ULL, 0x0000003900537306ULL, 0x0003f00000200c00ULL,
0x00000038003f7306ULL, 0x0005e20000200c00ULL, 0x0000541062397816ULL, 0x002fce0000000067ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x000054105e387816ULL, 0x004fe20000000065ULL,
0x000100003b5e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x0000541061387816ULL, 0x000fe2000000005cULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541064397816ULL, 0x008fce000000005bULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000000383014723cULL, 0x000fee0000001814ULL, 0x0000003e00637306ULL, 0x0007620000200c00ULL,
0x000054105d387816ULL, 0x002fe40000000060ULL, 0x000054105f397816ULL, 0x004fca0000000068ULL,
0x0000003d00577306ULL, 0x0003e20000200c00ULL, 0x000088803b3e7816ULL, 0x008fe200000000ffULL,
0x000000383018723cULL, 0x000fec0000001818ULL, 0x0000005600567306ULL, 0x000ea20000200c00ULL,
0x000001003a3d7824ULL, 0x042fe200078e00ffULL, 0x0000541063387816ULL, 0x020fe2000000005aULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541066397816ULL, 0x000fc40000000059ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000038301c723cULL, 0x000fea000000181cULL,
0x0000005800587306ULL, 0x000e640000200c00ULL, 0x0000541056387816ULL, 0x004fcc0000000057ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541055397816ULL, 0x002fce0000000058ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x000000383020723cULL, 0x000fee0000001820ULL,
0x0000003a003b7306ULL, 0x0002b00000200c00ULL, 0x0000005e005b7306ULL, 0x000ee20000200c00ULL,
0x00000001ff3a7424ULL, 0x002fe200078e00ffULL, 0x000054103b387816ULL, 0x004fcc000000004cULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054105b397816ULL, 0x008fce000000004eULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00000038302c723cULL, 0x000fee000000182cULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x0186b83a073879a7ULL, 0x0006e2000850003fULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x0000541054547816ULL, 0x004fce000000004fULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0000541053557816ULL, 0x002fce0000000052ULL, 0x000000543024723cULL, 0x000fe20000001824ULL,
0x000054103e3d7816ULL, 0x004fce000000003fULL, 0x0000003c3028723cULL, 0x008fde0000001828ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008400000a7ab9ULL, 0x000fe40000000800ULL,
0x0000000a024e7c24ULL, 0x010fc8000f8e02ffULL, 0x000000404e4e7824ULL, 0x000fe200078e00ffULL,
0x00000004001c9947ULL, 0x000fec0003800000ULL, 0x0000000235537836ULL, 0x000fe20000000000ULL,
0x00000080070a7890ULL, 0x000fe2000fffe03fULL, 0x0000000104307824ULL, 0x040fe200078e0235ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000104327824ULL, 0x000fe200078e0253ULL,
0x000000f0364c7812ULL, 0x000fe200078ec0ffULL, 0x0000000130317824ULL, 0x140fe400078e0209ULL,
0x00000010303a7824ULL, 0x000fe400078e00ffULL, 0x00000040083f7824ULL, 0x000fe200078e0230ULL,
0x0000000a0f307c48ULL, 0x000fe2000ffe0000ULL, 0x0000000132337824ULL, 0x040fe200078e0209ULL,
0xfffffff03a4f7812ULL, 0x000fe200078ee231ULL, 0x00000010323c7824ULL, 0x000fe200078e00ffULL,
0x0000004e3f397210ULL, 0x000fe20007f1e0ffULL, 0x0000000435577836ULL, 0x000fc40000000000ULL,
0x8000000a30317c36ULL, 0x000fe20008000000ULL, 0xfffffff03c557812ULL, 0x000fe200078ee233ULL,
0x000000023f337836ULL, 0x000fe40000000000ULL, 0x0000000104387824ULL, 0x000fe200078e0257ULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x000000043f3d7836ULL, 0x000fe20000000000ULL,
0x0000004e33307210ULL, 0x000fe20007f7e0ffULL, 0x0000000138327824ULL, 0x040fe400078e0209ULL,
0x0000001038597824ULL, 0x000fc400078e00ffULL, 0x00000001313a7824ULL, 0x000fe400078e0a04ULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0xfffffff059597812ULL, 0x000fe200078ee232ULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x0000000c39327c11ULL, 0x000fe2000f8040ffULL,
0x00014000073e7836ULL, 0x000fe20000000000ULL, 0x0000000c303b7c11ULL, 0x040fe4000f8640ffULL,
0x0000003a3500720cULL, 0x000fe20003f86070ULL, 0x000000104f4f7824ULL, 0x000fe200078e023eULL,
0x0000000d39397c11ULL, 0x000fe200080f4438ULL, 0x0000001055557824ULL, 0x100fe200078e023eULL,
0x0000000d30317c11ULL, 0x000fe200098f4433ULL, 0x0000001059597824ULL, 0x000fe200078e023eULL,
0x0000004e3d3d7210ULL, 0x000fc40007f1e0ffULL, 0x0000004c32327210ULL, 0x000fe40007f7e0ffULL,
0x0000000c3d387c11ULL, 0x000fe2000f8a40ffULL, 0x000000ffff307224ULL, 0x000fe200000e06ffULL,
0x0000003a5300720cULL, 0x080fe20003f06070ULL, 0x000000ffff337224ULL, 0x000fe200018e0639ULL,
0x0000003a5700720cULL, 0x000fe20003f66070ULL, 0x000000063f397836ULL, 0x000fe20000000000ULL,
0x0000000d3d3d7c11ULL, 0x000fe2000a8f4430ULL, 0x0000000635537836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000324f7faeULL, 0x0003e2000e101c48ULL,
0x0000004c3b307210ULL, 0x000fc40007fbe0ffULL, 0x00000001043c7824ULL, 0x000fe200078e0253ULL,
0x0000004e39397210ULL, 0x000fe40007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x0000003a5300720cULL, 0x000fe20003fa6070ULL, 0x000000013c3f7824ULL, 0x040fe200078e0209ULL,
0x0000004c38387210ULL, 0x000fe20007fde0ffULL, 0x000000103c527824ULL, 0x000fe200078e00ffULL,
0x0000000030557faeULL, 0x0005e2000c101c48ULL, 0x000000ffff3c7224ULL, 0x000fe200020e06ffULL,
0x0000000c393b7c11ULL, 0x000fc4000f8840ffULL, 0xfffffff0523f7812ULL, 0x000fe400078ee23fULL,
0x0000000d39337c11ULL, 0x002fe2000a0f443cULL, 0x000000ffff397224ULL, 0x000fe200030e063dULL,
0x0000004c3b327210ULL, 0x000fe20007f9e0ffULL, 0x000000103f3f7824ULL, 0x000fc600078e023eULL,
0x0000000038597faeULL, 0x0005e2000d901c48ULL, 0x000000ffff337224ULL, 0x000fca00020e0633ULL,
0x00000000323f7faeULL, 0x0005e2000e901c48ULL, 0x0000000000e87947ULL, 0x000fea0003800000ULL,
0x0000000104307824ULL, 0x000fe200078e0235ULL, 0x00008a00000a7ab9ULL, 0x000fc60000000a00ULL,
0x0000000130317824ULL, 0x140fe400078e0209ULL, 0x00000010303a7824ULL, 0x000fe400078e00ffULL,
0x0000000230327836ULL, 0x000fe40000000000ULL, 0x0000000430387836ULL, 0x000fe20000000000ULL,
0xfffffff03a397812ULL, 0x000fe200078ee231ULL, 0x0000000132337824ULL, 0x040fe400078e0209ULL,
0x00000010323a7824ULL, 0x000fc400078e00ffULL, 0x0000000138327824ULL, 0x140fe400078e0209ULL,
0x0000001038537824ULL, 0x000fe200078e00ffULL, 0xfffffff03a3f7812ULL, 0x000fe200078ee233ULL,
0x0000004008317824ULL, 0x000fe400078e0230ULL, 0x0000000630307836ULL, 0x000fe20000000000ULL,
0xfffffff053537812ULL, 0x000fe200078ee232ULL, 0x00000002313b7836ULL, 0x000fe20000000000ULL,
0x0000004e31327210ULL, 0x000fe20007f1e0ffULL, 0x00000001303a7824ULL, 0x000fc400078e0209ULL,
0x0000001030557824ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fe200000e06ffULL,
0x0000000a32387c11ULL, 0x040fe2000f8040ffULL, 0x0001400007307836ULL, 0x000fe20000000000ULL,
0xfffffff055557812ULL, 0x000fe200078ee23aULL, 0x00000004314f7836ULL, 0x000fe20000000000ULL,
0x0000000b32337c11ULL, 0x000fe200080f4433ULL, 0x0000000631317836ULL, 0x000fe20000000000ULL,
0x0000004e3b3b7210ULL, 0x000fe20007f1e0ffULL, 0x00000010393d7824ULL, 0x100fe200078e0230ULL,
0x0000004e4f4f7210ULL, 0x000fe20007f7e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0230ULL,
0x0000004e313e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff327224ULL, 0x000fe200000e06ffULL,
0x0000000a3b3a7c11ULL, 0x000fe2000f8040ffULL, 0x0000001053537824ULL, 0x000fc400078e0230ULL,
0x0000001055577824ULL, 0x000fe200078e0230ULL, 0x0000000b3b397c11ULL, 0x000fe200080f4432ULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x000000f0363b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff557224ULL, 0x000fe200020e06ffULL, 0x0000000a4f3c7c11ULL, 0x040fe4000f8640ffULL,
0x0000003b38307210ULL, 0x000fe40007f1e0ffULL, 0x0000000a3e4c7c11ULL, 0x000fe4000f8840ffULL,
0x0000000b4f4f7c11ULL, 0x000fe200098f4432ULL, 0x000000ffff317224ULL, 0x000fe200000e0633ULL,
0x0000003b3a327210ULL, 0x000fc40007f1e0ffULL, 0x0000000b3e557c11ULL, 0x000fe4000a0f4455ULL,
0x0000003b3c387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0639ULL,
0x0000003b4c3a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303d7faeULL, 0x0003e4000b901c48ULL, 0x000000ffff397224ULL, 0x000fe400018e064fULL,
0x000000ffff3b7224ULL, 0x000fe200020e0655ULL, 0x00000000323f7faeULL, 0x0003e8000b901c48ULL,
0x0000000038537faeULL, 0x0003e8000b901c48ULL, 0x000000003a577faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x006fe20000000000ULL, 0x00000001ff307424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0186a830073079a7ULL, 0x000e64000850003fULL, 0x000000ffff4c7224ULL, 0x002fe200078e0031ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b051070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b051070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000182947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011609ULL,
0x0000000cff0d723eULL, 0x000fc600000000ffULL, 0x0000000831337836ULL, 0x000fe20000000000ULL,
0x000054100d307816ULL, 0x000fca000000000dULL, 0x00001f31300d7589ULL, 0x0002a800000e0000ULL,
0x00001f33300e7589ULL, 0x0002e400000e0000ULL, 0x013000004730783bULL, 0x0022e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000e31317232ULL, 0x080fe40000000000ULL,
0x0000000e33337232ULL, 0x000fce0000000000ULL, 0x00000000433c783bULL, 0x000f280000004200ULL,
0x000000004238783bULL, 0x000f620000004200ULL, 0x00000018ff5c7819ULL, 0x010fe2000001143cULL,
0x000001003c537824ULL, 0x040fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d547824ULL, 0x040fe200078e00ffULL, 0x000088803c5e7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d627816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x022fe20000011438ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000888038567816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000003c00617306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff597819ULL, 0x000fe4000001143fULL,
0x000088803f5f7816ULL, 0x000fc400000000ffULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003d00647306ULL, 0x0009e20000200c00ULL, 0x000001003f3c7824ULL, 0x002fe200078e00ffULL,
0x0000888039557816ULL, 0x000fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001143eULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000100383d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x000088803e5d7816ULL, 0x000fc400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005300657306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff4f7819ULL, 0x000fe4000001143aULL, 0x00000018ff507819ULL, 0x000fc6000001143bULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000001003e537824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005400677306ULL, 0x000e620000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c00687306ULL, 0x0009f00000200c00ULL, 0x0000003800547306ULL, 0x000be20000200c00ULL,
0x00000100393c7824ULL, 0x050fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001143cULL, 0x0000005b005b7306ULL, 0x000f220000200c00ULL,
0x000001003b387824ULL, 0x028fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000005300607306ULL, 0x000ff00000200c00ULL, 0x0000003f00667306ULL, 0x000ff00000200c00ULL,
0x0000003900537306ULL, 0x0003f00000200c00ULL, 0x00000038003f7306ULL, 0x0007e20000200c00ULL,
0x0000541062397816ULL, 0x002fce0000000067ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x000054105e387816ULL, 0x008fce0000000065ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x000000383010723cULL, 0x000fee0000001810ULL, 0x0000003e00637306ULL, 0x000be20000200c00ULL,
0x0000541061387816ULL, 0x000fe4000000005cULL, 0x0000541064397816ULL, 0x010fca000000005bULL,
0x0000003d00577306ULL, 0x0009e20000200c00ULL, 0x000088803b3e7816ULL, 0x064fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x000000383014723cULL, 0x000fe80000001814ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000001003a3d7824ULL, 0x050fe200078e00ffULL, 0x000054105d387816ULL, 0x002fe20000000060ULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000054105f397816ULL, 0x008fc40000000068ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x000000383018723cULL, 0x000fea0000001818ULL,
0x0000005500557306ULL, 0x000fe40000200c00ULL, 0x0000541063387816ULL, 0x004fc4000000005aULL,
0x0000541066397816ULL, 0x002fc80000000059ULL, 0x0000005800587306ULL, 0x000e660000200c00ULL,
0x00000038301c723cULL, 0x000fea000000181cULL, 0x0000003c003c7306ULL, 0x000fe40000200c00ULL,
0x0000541055397816ULL, 0x002fcc0000000058ULL, 0x0000003d003d7306ULL, 0x000e700000200c00ULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003dULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x0000541054547816ULL, 0x004fce0000000051ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x0000541053557816ULL, 0x002fce0000000052ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000000543024723cULL, 0x000fee0000001824ULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0000541056387816ULL, 0x002fce0000000057ULL, 0x0000003a003a7306ULL, 0x000e620000200c00ULL,
0x000000383020723cULL, 0x000fe20000001820ULL, 0x000054103e3d7816ULL, 0x004fcc000000003fULL,
0x0000003b003b7306ULL, 0x000ea20000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103a3a7816ULL, 0x002fe4000000004fULL, 0x000054103b3b7816ULL, 0x004fce0000000050ULL,
0x0000003a302c723cULL, 0x000fe2000000182cULL, 0x013000003730783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000413c783bULL, 0x000ee20000004200ULL, 0x00000080070a7890ULL, 0x000fc6000fffe03fULL,
0x000000004038783bULL, 0x000f260000004200ULL, 0x0000000a0f007c0cULL, 0x000fe4000bf03070ULL,
0x00000018ff5c7819ULL, 0x008fe2000001143cULL, 0x000001003c537824ULL, 0x040fe200078e00ffULL,
0x000088803c577816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001143dULL, 0x000001003d547824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000001003b677824ULL, 0x010fe200078e00ffULL,
0x000088803d607816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00000018ff597819ULL, 0x000fe2000001143fULL,
0x0000005300627306ULL, 0x0007e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000088803f5f7816ULL, 0x000fe400000000ffULL, 0x00000018ff517819ULL, 0x000fe40000011438ULL,
0x00000018ff527819ULL, 0x000fe20000011439ULL, 0x0000003c00637306ULL, 0x0009e20000200c00ULL,
0x000001003e537824ULL, 0x008fe200078e00ffULL, 0x0000888038557816ULL, 0x000fc400000000ffULL,
0x000088803e5d7816ULL, 0x040fe400000000ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005700577306ULL, 0x000ee20000200c00ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001143aULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff507819ULL, 0x000fc6000001143bULL, 0x0000005400657306ULL, 0x000f300000200c00ULL,
0x0000003d00667306ULL, 0x000bf00000200c00ULL, 0x00000053005e7306ULL, 0x0007e20000200c00ULL,
0x00000100383d7824ULL, 0x022fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00687306ULL, 0x0003e20000200c00ULL,
0x0000888039537816ULL, 0x00cfe400000000ffULL, 0x00000018ff387819ULL, 0x000fca0000011438ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x00000100393c7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001143cULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000003f00647306ULL, 0x000fe20000200c00ULL,
0x000088803a3c7816ULL, 0x000fce00000000ffULL, 0x0000003800547306ULL, 0x0003f00000200c00ULL,
0x00000039003f7306ULL, 0x0009e20000200c00ULL, 0x0000541057387816ULL, 0x002fe40000000062ULL,
0x00000018ff577819ULL, 0x000fca0000011467ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x0000541060397816ULL, 0x010fce0000000065ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x000000383010723cULL, 0x000fee0000001810ULL, 0x0000003e00617306ULL, 0x0009e20000200c00ULL,
0x0000541063387816ULL, 0x000fe4000000005cULL, 0x0000541066397816ULL, 0x004fca000000005bULL,
0x0000003d00567306ULL, 0x0005e20000200c00ULL, 0x000088803b3e7816ULL, 0x050fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x000000383014723cULL, 0x000fe80000001814ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000005a005a7306ULL, 0x000f220000200c00ULL,
0x000001003a3d7824ULL, 0x044fe200078e00ffULL, 0x000054105d387816ULL, 0x002fe2000000005eULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000054105f397816ULL, 0x008fc40000000068ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x000000383018723cULL, 0x000fea0000001818ULL,
0x0000005500557306ULL, 0x000ea40000200c00ULL, 0x0000541061387816ULL, 0x010fc4000000005aULL,
0x0000541064397816ULL, 0x002fc80000000059ULL, 0x0000005300537306ULL, 0x000fe60000200c00ULL,
0x00000038301c723cULL, 0x000fea000000181cULL, 0x0000005800587306ULL, 0x000e640000200c00ULL,
0x0000541055387816ULL, 0x004fe20000000056ULL, 0x00000001ff567424ULL, 0x000fca00078e00ffULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000541053397816ULL, 0x002fce0000000058ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000000383020723cULL, 0x000fee0000001820ULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x0186b856073879a7ULL, 0x0006e2000850003fULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x0186985607ff79a7ULL, 0x0007e2000850003fULL, 0x0000541054547816ULL, 0x004fcc0000000051ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x000054103f557816ULL, 0x002fce0000000052ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000000543024723cULL, 0x000fee0000001824ULL,
0x0000003e003e7306ULL, 0x000ff00000200c00ULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000003a003a7306ULL, 0x000ea20000200c00ULL, 0x000054103e3d7816ULL, 0x002fce0000000057ULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103a3a7816ULL, 0x004fe2000000004fULL, 0x000000030b4f7836ULL, 0x000fe20000000000ULL,
0x000054103b3b7816ULL, 0x002fce0000000050ULL, 0x0000003a302c723cULL, 0x000fe2000000182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000003c00040947ULL, 0x008fde0003800000ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011433ULL,
0x0000003b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000202027819ULL, 0x000fc80000001233ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000400209947ULL, 0x000fea0003800000ULL, 0x0000000104027824ULL, 0x000fe200078e0235ULL,
0x0000002008317811ULL, 0x000fe200078e30ffULL, 0x00000002353f7836ULL, 0x000fe20000000000ULL,
0x000000a0070a7890ULL, 0x000fe2000fffe03fULL, 0x0000000435537836ULL, 0x000fe20000000000ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000102307824ULL, 0x040fe400078e0209ULL,
0x0000001002337824ULL, 0x000fe400078e00ffULL, 0x0000000104327824ULL, 0x000fc400078e023fULL,
0x0000000104387824ULL, 0x000fe200078e0253ULL, 0xfffffff033337812ULL, 0x000fe200078ee230ULL,
0x0000000132307824ULL, 0x140fe400078e0209ULL, 0x00000010323b7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0209ULL, 0x00000010383a7824ULL, 0x000fe200078e00ffULL,
0xfffffff03b3b7812ULL, 0x000fe200078ee230ULL, 0x0000000635577836ULL, 0x000fc40000000000ULL,
0x00000001023d7824ULL, 0x000fe200078e0231ULL, 0xfffffff03a557812ULL, 0x000fe200078ee239ULL,
0x0000000104307824ULL, 0x000fe200078e0257ULL, 0x0000000a0f027c48ULL, 0x000fe2000ffe0000ULL,
0x0000000132397824ULL, 0x100fe200078e0231ULL, 0x0000004e3d3d7210ULL, 0x000fe20007f3e0ffULL,
0x00000001384f7824ULL, 0x100fe400078e0231ULL, 0x0000000130317824ULL, 0x040fe200078e0231ULL,
0x0000004e393c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000130387824ULL, 0x040fe200078e0209ULL,
0x0000004e4f397210ULL, 0x000fe20007f7e0ffULL, 0x0000001030597824ULL, 0x000fe200078e00ffULL,
0x0000004e314e7210ULL, 0x000fe20007f1e0ffULL, 0x8000000a02317c36ULL, 0x000fc40008000000ULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x0000000c3d307c11ULL, 0x040fe2000f8240ffULL,
0x0001600007327836ULL, 0x000fe20000000000ULL, 0x0000003104317248ULL, 0x000fe40007fe0000ULL,
0x0000000d3d3d7c11ULL, 0x000fe200088f4402ULL, 0x00000010334f7824ULL, 0x000fe200078e0232ULL,
0xfffffff059597812ULL, 0x000fe200078ee238ULL, 0x0000000131027824ULL, 0x000fe200078e0a04ULL,
0x0000000c39387c11ULL, 0x000fe2000f8a40ffULL, 0x000000103b517824ULL, 0x000fc400078e0232ULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x000000023f00720cULL, 0x080fe20003f26070ULL,
0x0000001055557824ULL, 0x100fe200078e0232ULL, 0x000000f0363f7812ULL, 0x000fe200078ec0ffULL,
0x0000001059597824ULL, 0x000fe200078e0232ULL, 0x0000000c3c3b7c11ULL, 0x040fe2000f8440ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x0000003f30307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x0000000d3c3c7c11ULL, 0x000fe400090f4431ULL,
0x0000000d39397c11ULL, 0x000fe2000a8f4432ULL, 0x000000ffff317224ULL, 0x000fe200020e063dULL,
0x000000023500720cULL, 0x000fc40003f66070ULL, 0x0000000c4e3a7c11ULL, 0x040fe4000f8a40ffULL,
0x0000003f3b327210ULL, 0x000fe40007f9e0ffULL, 0x000000025300720cULL, 0x080fe40003f46070ULL,
0x000000025700720cULL, 0x000fe40003f06070ULL, 0x0000000d4e027c11ULL, 0x000fe2000a8f4433ULL,
0x000000ffff337224ULL, 0x000fe200020e063cULL, 0x0000003f38387210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000304f7faeULL, 0x0003e2000d901c48ULL,
0x0000003f3a3a7210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff397224ULL, 0x000fe200028e0639ULL,
0x0000000032517faeULL, 0x0003e2000c901c48ULL, 0x000000ffff3b7224ULL, 0x000fc600020e0602ULL,
0x0000000038557faeULL, 0x0003e8000d101c48ULL, 0x000000003a597faeULL, 0x0003e2000c101c48ULL,
0x0000000000ec7947ULL, 0x000fea0003800000ULL, 0x0000000104027824ULL, 0x000fe200078e0235ULL,
0x0000002008317811ULL, 0x000fe200078e30ffULL, 0x00008a00000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000202327836ULL, 0x000fe40000000000ULL, 0x0000000102307824ULL, 0x140fe400078e0209ULL,
0x00000010023b7824ULL, 0x000fe400078e00ffULL, 0x0000000132337824ULL, 0x000fc400078e0209ULL,
0x0000001032387824ULL, 0x000fe200078e00ffULL, 0xfffffff03b3b7812ULL, 0x000fe200078ee230ULL,
0x0000000402307836ULL, 0x000fe40000000000ULL, 0x0000000131397824ULL, 0x040fe200078e0232ULL,
0xfffffff0383f7812ULL, 0x000fe200078ee233ULL, 0x0000000602387836ULL, 0x000fe40000000000ULL,
0x0000000102337824ULL, 0x000fe200078e0231ULL, 0x0000004e393c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001313d7824ULL, 0x000fc400078e0230ULL, 0x0000000131317824ULL, 0x000fe200078e0238ULL,
0x0000004e33337210ULL, 0x000fe20007f7e0ffULL, 0x00000010303e7824ULL, 0x000fe200078e00ffULL,
0x0000004e3d397210ULL, 0x000fe20007f5e0ffULL, 0x00000001383d7824ULL, 0x100fe200078e0209ULL,
0x0000004e31027210ULL, 0x000fe20007f1e0ffULL, 0x0000000130317824ULL, 0x000fe400078e0209ULL,
0x0000001038387824ULL, 0x000fe400078e00ffULL, 0x0001600007307836ULL, 0x000fe20000000000ULL,
0xfffffff03e537812ULL, 0x000fe200078ee231ULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x0000000a333a7c11ULL, 0x000fe2000f8640ffULL, 0x000000103b4f7824ULL, 0x100fe200078e0230ULL,
0xfffffff038557812ULL, 0x000fe200078ee23dULL, 0x000000ffff317224ULL, 0x000fe200008e06ffULL,
0x0000000a3c3b7c11ULL, 0x000fe2000f8240ffULL, 0x000000103f517824ULL, 0x100fe200078e0230ULL,
0x000000f0363f7812ULL, 0x000fe200078ec0ffULL, 0x0000001053537824ULL, 0x000fe200078e0230ULL,
0x0000000b333d7c11ULL, 0x000fe200098f4432ULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x0000000b3c3c7c11ULL, 0x000fe200088f4431ULL, 0x0000001055557824ULL, 0x000fe200078e0230ULL,
0x0000000a39387c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff337224ULL, 0x000fe200000e06ffULL,
0x0000003f3a307210ULL, 0x000fc40007f7e0ffULL, 0x0000000a023a7c11ULL, 0x040fe4000f8440ffULL,
0x0000000b39397c11ULL, 0x000fe200088f4432ULL, 0x000000ffff317224ULL, 0x000fe200018e063dULL,
0x0000003f3b327210ULL, 0x000fe40007f1e0ffULL, 0x0000000b02027c11ULL, 0x000fe400090f4433ULL,
0x0000003f38387210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e063cULL,
0x0000003f3a3a7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000304f7faeULL, 0x0003e4000b901c48ULL, 0x000000ffff397224ULL, 0x000fc400008e0639ULL,
0x000000ffff3b7224ULL, 0x000fe200010e0602ULL, 0x0000000032517faeULL, 0x0003e8000b901c48ULL,
0x0000000038537faeULL, 0x0003e8000b901c48ULL, 0x000000003a557faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000040b337836ULL, 0x000fe40000000000ULL,
0x00000001ff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0x000000063300720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00008c00ff307b82ULL, 0x000e620000000a00ULL, 0x000000010a337824ULL, 0x000fc800078e0233ULL,
0x0000000433307825ULL, 0x002fca00078e0030ULL, 0x0000000830027981ULL, 0x000324000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0186b038074e79a7ULL, 0x0004e4000850003fULL, 0x01866838033879a7ULL, 0x004464000850003fULL,
0x0000000000307805ULL, 0x002fce0000015200ULL, 0x01866839030075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01866839030075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x018180004b307984ULL, 0x000e620000000800ULL, 0x00000001ff387424ULL, 0x000fc600078e00ffULL,
0x018380004b317984ULL, 0x000b620000000800ULL, 0x0000004d3000720bULL, 0x002fda0003f1d000ULL,
0x0000000000397806ULL, 0x000fc800000e0100ULL, 0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL,
0x0000000000f48947ULL, 0x02cfea0003800000ULL, 0x000000033400780cULL, 0x000fe40003f25270ULL,
0x0000004d3000720bULL, 0x000fd60003f14000ULL, 0x0000004d30329209ULL, 0x000fe40007810000ULL,
0x0000000000387806ULL, 0x000fc600000e0100ULL, 0x018580324b009388ULL, 0x0003e20000000800ULL,
0x0000991038337816ULL, 0x000fc800000000ffULL, 0x000000ff3300720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000004d30327209ULL, 0x000fe40007810000ULL,
0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL,
0x0000004d32327221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b32327820ULL, 0x000fc80000410000ULL,
0x0000003200337308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff327819ULL, 0x002fcc0000011609ULL, 0x00001f3233327589ULL, 0x004e6400000e0000ULL,
0x0000003210107220ULL, 0x082fe20000410000ULL, 0x0000003211117220ULL, 0x080fe20000410000ULL,
0x0000003214147220ULL, 0x080fe20000410000ULL, 0x0000003215157220ULL, 0x080fe20000410000ULL,
0x0000003218187220ULL, 0x080fe20000410000ULL, 0x0000003219197220ULL, 0x080fe20000410000ULL,
0x000000321c1c7220ULL, 0x080fe20000410000ULL, 0x000000321d1d7220ULL, 0x080fe20000410000ULL,
0x0000003220207220ULL, 0x080fe20000410000ULL, 0x0000003221217220ULL, 0x080fe20000410000ULL,
0x0000003224247220ULL, 0x080fe20000410000ULL, 0x0000003225257220ULL, 0x080fe20000410000ULL,
0x0000003228287220ULL, 0x080fe20000410000ULL, 0x0000003229297220ULL, 0x080fe20000410000ULL,
0x000000322c2c7220ULL, 0x080fe20000410000ULL, 0x000000322d2d7220ULL, 0x000fce0000410000ULL,
0x0000003300007220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000809327811ULL, 0x002fcc00078ff0ffULL, 0x00001f3233327589ULL, 0x000e6400000e0000ULL,
0x0000003212127220ULL, 0x082fe20000410000ULL, 0x0000003213137220ULL, 0x080fe20000410000ULL,
0x0000003216167220ULL, 0x080fe20000410000ULL, 0x0000003217177220ULL, 0x080fe20000410000ULL,
0x000000321a1a7220ULL, 0x080fe20000410000ULL, 0x000000321b1b7220ULL, 0x080fe20000410000ULL,
0x000000321e1e7220ULL, 0x080fe20000410000ULL, 0x000000321f1f7220ULL, 0x080fe20000410000ULL,
0x0000003222227220ULL, 0x080fe20000410000ULL, 0x0000003223237220ULL, 0x080fe20000410000ULL,
0x0000003226267220ULL, 0x080fe20000410000ULL, 0x0000003227277220ULL, 0x080fe20000410000ULL,
0x000000322a2a7220ULL, 0x080fe20000410000ULL, 0x000000322b2b7220ULL, 0x080fe20000410000ULL,
0x000000322e2e7220ULL, 0x080fe20000410000ULL, 0x000000322f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff38ff7812ULL, 0x000fe20007800839ULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x0000004d304d7209ULL, 0x000fd60007810000ULL, 0x8000004d30300221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL,
0x00000030000c0308ULL, 0x000ea40000000800ULL, 0x0000000c31310220ULL, 0x004fce0000410000ULL,
0x0000000031007221ULL, 0x000fce0000010000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0186a84c070075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x002fce0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186a84c070075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000991038307816ULL, 0x000fc800000000ffULL,
0x000000ff3000720cULL, 0x000fda0003f25270ULL, 0x0000000000181947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x000fe40000011609ULL, 0x0000000cff0d723eULL, 0x000fc600000000ffULL,
0x0000000831337836ULL, 0x000fe20000000000ULL, 0x000054100d307816ULL, 0x000fca000000000dULL,
0x00001f31300d7589ULL, 0x0004e800000e0000ULL, 0x00001f33300e7589ULL, 0x00046400000e0000ULL,
0x013800004a30783bULL, 0x0062a20000000200ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000493c783bULL, 0x000f680000004200ULL, 0x000000004838783bULL, 0x000f640000004200ULL,
0x00000018ff547819ULL, 0x022fe2000001143dULL, 0x000001003d517824ULL, 0x040fe200078e00ffULL,
0x000088803d5e7816ULL, 0x040fe200000000ffULL, 0x000001003c4c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe2000001143cULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x000088803c577816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x008fe20000011438ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000888038567816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000003d00617306ULL, 0x0003e20000200c00ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff507819ULL, 0x000fe4000001143fULL, 0x000088803f597816ULL, 0x000fc400000000ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011439ULL, 0x0000003c005c7306ULL, 0x0007e20000200c00ULL,
0x00000100383d7824ULL, 0x042fe200078e00ffULL, 0x0000888039587816ULL, 0x000fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe4000001143eULL,
0x000088803e557816ULL, 0x000fe400000000ffULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000004c00607306ULL, 0x0002e20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff487819ULL, 0x000fe4000001143aULL,
0x00000018ff497819ULL, 0x000fc6000001143bULL, 0x0000005100657306ULL, 0x000f620000200c00ULL,
0x000001003e4c7824ULL, 0x042fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000003c00627306ULL, 0x0003e20000200c00ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003800517306ULL, 0x0007e20000200c00ULL,
0x00000100393c7824ULL, 0x042fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143cULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x000001003b387824ULL, 0x00cfe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x040fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000005400547306ULL, 0x000eb00000200c00ULL, 0x0000003d005b7306ULL, 0x0007f00000200c00ULL,
0x0000003f00637306ULL, 0x000fe20000200c00ULL, 0x000001003a3d7824ULL, 0x008fc400078e00ffULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004c005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3a7819ULL, 0x000fce000001143aULL,
0x00000038003f7306ULL, 0x0007f00000200c00ULL, 0x00000039004c7306ULL, 0x000be20000200c00ULL,
0x0000541057387816ULL, 0x008fe20000000060ULL, 0x000100003b577824ULL, 0x000fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x000054105e397816ULL, 0x020fce0000000065ULL, 0x0000005900597306ULL, 0x000f620000200c00ULL,
0x000000383010723cULL, 0x000fee0000001810ULL, 0x0000003e005f7306ULL, 0x0007e20000200c00ULL,
0x000054105c387816ULL, 0x002fe40000000053ULL, 0x0000541061397816ULL, 0x004fca0000000054ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000088803b3e7816ULL, 0x008fe200000000ffULL,
0x000000383014723cULL, 0x000fec0000001814ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x0000541055387816ULL, 0x000fe4000000005aULL, 0x0000541059397816ULL, 0x020fca0000000062ULL,
0x0000005200527306ULL, 0x000ea40000200c00ULL, 0x000000383018723cULL, 0x000fe20000001818ULL,
0x000054103c3c7816ULL, 0x002fca000000003dULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x000054105f387816ULL, 0x004fce0000000052ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x0000541063397816ULL, 0x002fce0000000050ULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x00000038301c723cULL, 0x000fe2000000181cULL, 0x00005410514a7816ULL, 0x004fcc000000004aULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x000054104c4b7816ULL, 0x002fce000000004bULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x0000004a3024723cULL, 0x000fee0000001824ULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x0000541056567816ULL, 0x002fce000000005bULL, 0x0000005d005d7306ULL, 0x000ff00000200c00ULL,
0x0000003e003e7306ULL, 0x000e700000200c00ULL, 0x0000003a003b7306ULL, 0x000ea20000200c00ULL,
0x000054103e3d7816ULL, 0x002fce000000003fULL, 0x0000005700547306ULL, 0x0002e20000200c00ULL,
0x0000003c3028723cULL, 0x000fe20000001828ULL, 0x000054103b487816ULL, 0x004fe40000000048ULL,
0x0000541058577816ULL, 0x002fe4000000005dULL, 0x0000541054497816ULL, 0x008fca0000000049ULL,
0x000000563020723cULL, 0x000fec0000001820ULL, 0x00000048302c723cULL, 0x000fe2000000182cULL,
0x013800004630783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000101947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x084fe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000e31317232ULL, 0x080fe40000000000ULL,
0x0000000e33337232ULL, 0x000fce0000000000ULL, 0x00000000453c783bULL, 0x000ee80000004200ULL,
0x000000004438783bULL, 0x000f620000004200ULL, 0x00000018ff4c7819ULL, 0x008fe2000001143dULL,
0x000001003d517824ULL, 0x040fe200078e00ffULL, 0x000088803d5a7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001143cULL,
0x000001003e527824ULL, 0x000fe200078e00ffULL, 0x000088803c547816ULL, 0x040fe200000000ffULL,
0x000001003c507824ULL, 0x040fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff467819ULL, 0x022fc40000011438ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000003d005f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff497819ULL, 0x000fe4000001143fULL, 0x000088803f557816ULL, 0x000fe400000000ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001143eULL, 0x00000018ff487819ULL, 0x000fe20000011439ULL,
0x0000005200577306ULL, 0x0007e20000200c00ULL, 0x00000100383d7824ULL, 0x042fe200078e00ffULL,
0x0000888039567816ULL, 0x000fe400000000ffULL, 0x00000018ff447819ULL, 0x000fe4000001143aULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00587306ULL, 0x0003e20000200c00ULL,
0x0000888038527816ULL, 0x048fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fc8000001143bULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x000001003f3c7824ULL, 0x042fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000050005d7306ULL, 0x0002e20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fce000001143fULL,
0x0000005100637306ULL, 0x000f620000200c00ULL, 0x000088803e507816ULL, 0x042fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000003800517306ULL, 0x0003f00000200c00ULL, 0x0000003c005e7306ULL, 0x0007e20000200c00ULL,
0x000001003b387824ULL, 0x002fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x00000100393c7824ULL, 0x04cfe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff397819ULL, 0x000fce0000011439ULL,
0x0000003f005c7306ULL, 0x000ff00000200c00ULL, 0x0000003e005b7306ULL, 0x0007f00000200c00ULL,
0x00000038003f7306ULL, 0x0003e20000200c00ULL, 0x000001003a3e7824ULL, 0x008fca00078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001143eULL, 0x0000003d00597306ULL, 0x0007e20000200c00ULL,
0x0000541054387816ULL, 0x002fe2000000005dULL, 0x000100003b547824ULL, 0x040fe200078e00ffULL,
0x000088803b3e7816ULL, 0x000fc800000000ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000003900537306ULL, 0x000be20000200c00ULL, 0x000088803a3d7816ULL, 0x048fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000054105a397816ULL, 0x020fce0000000063ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x000000383010723cULL, 0x000fee0000001810ULL,
0x0000003c00617306ULL, 0x000fe20000200c00ULL, 0x0000541058387816ULL, 0x000fe4000000004bULL,
0x000054105f397816ULL, 0x004fca000000004cULL, 0x0000005200527306ULL, 0x000ea40000200c00ULL,
0x000000383014723cULL, 0x000fec0000001814ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000541050387816ULL, 0x002fe40000000057ULL, 0x0000541055397816ULL, 0x008fca000000005eULL,
0x00000060003c7306ULL, 0x0004640000200c00ULL, 0x000000383018723cULL, 0x000fec0000001818ULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x0000541052607816ULL, 0x004fe20000000059ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x000054103d3c7816ULL, 0x002fca000000003cULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x0186b838073879a7ULL, 0x0004a2000850003fULL,
0x000054105b4a7816ULL, 0x008fcc000000004aULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x000054105c4b7816ULL, 0x002fce0000000049ULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x0000004a301c723cULL, 0x000fe2000000181cULL, 0x0000541051527816ULL, 0x008fcc0000000046ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x0000541053537816ULL, 0x002fce0000000048ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x000000523024723cULL, 0x000fee0000001824ULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000003e003e7306ULL, 0x000ee20000200c00ULL,
0x0000541056617816ULL, 0x002fce0000000061ULL, 0x0000003a003b7306ULL, 0x000e620000200c00ULL,
0x000000603020723cULL, 0x000fe20000001820ULL, 0x000054103e3d7816ULL, 0x008fcc000000003fULL,
0x0000005400547306ULL, 0x000ee20000200c00ULL, 0x0000003c3028723cULL, 0x000fe20000001828ULL,
0x000054103b447816ULL, 0x002fe40000000044ULL, 0x0000541054457816ULL, 0x008fce0000000045ULL,
0x00000044302c723cULL, 0x004fde000000182cULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000204067890ULL, 0x000fe2000fffe03fULL, 0x00008400000a7ab9ULL, 0x000fe40000000800ULL,
0x0000000a02307c24ULL, 0x010fc6000f8e02ffULL, 0x0000000605007c0cULL, 0x000fe2000bf03070ULL,
0x0000004030397824ULL, 0x000fd800078e00ffULL, 0x00000004001c8947ULL, 0x000fea0003800000ULL,
0x00000002353f7836ULL, 0x000fe20000000000ULL, 0x000000c007067890ULL, 0x000fe2000fffe03fULL,
0x0000000435457836ULL, 0x000fe20000000000ULL, 0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000104317824ULL, 0x040fe400078e0235ULL, 0x0000000104327824ULL, 0x040fe400078e023fULL,
0x0000000104387824ULL, 0x000fe400078e0245ULL, 0x0000000131307824ULL, 0x000fc400078e0209ULL,
0x00000010313b7824ULL, 0x000fe400078e00ffULL, 0x0000000132337824ULL, 0x140fe400078e0209ULL,
0x0000001032467824ULL, 0x000fe200078e00ffULL, 0xfffffff03b447812ULL, 0x000fe200078ee230ULL,
0x0000000138327824ULL, 0x040fe200078e0209ULL, 0x000000060f307c48ULL, 0x000fe2000ffe0000ULL,
0x00000010383d7824ULL, 0x000fe200078e00ffULL, 0xfffffff046467812ULL, 0x000fe200078ee233ULL,
0x0000000635497836ULL, 0x000fc60000000000ULL, 0xfffffff03d487812ULL, 0x000fe200078ee232ULL,
0x0000004008327824ULL, 0x000fe400078e0231ULL, 0x8000000630317c36ULL, 0x000fe40008000000ULL,
0x0000000232307836ULL, 0x000fe20000000000ULL, 0x00000039323d7210ULL, 0x000fe20007f1e0ffULL,
0x0000000104387824ULL, 0x000fe200078e0249ULL, 0x0000003104317248ULL, 0x000fe20007fe0000ULL,
0x00000004323c7836ULL, 0x000fe20000000000ULL, 0x0000003930337210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x0000000a3d3b7c11ULL, 0x040fe2000f8040ffULL,
0x0000000632327836ULL, 0x000fe20000000000ULL, 0x000000393c3c7210ULL, 0x000fe20007f5e0ffULL,
0x00000001383e7824ULL, 0x040fe200078e0209ULL, 0x0000000b3d3d7c11ULL, 0x000fe200080f4430ULL,
0x00000010384b7824ULL, 0x000fe200078e00ffULL, 0x0000003932397210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x0000000a33327c11ULL, 0x000fe2000f8640ffULL,
0x00000001313a7824ULL, 0x000fe200078e0a04ULL, 0xfffffff04b4a7812ULL, 0x000fe200078ee23eULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x000000f0363e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff367224ULL, 0x000fe200020e06ffULL, 0x0000000a3c387c11ULL, 0x000fc4000f8440ffULL,
0x0000000b33337c11ULL, 0x000fe400098f4430ULL, 0x0000003e32327210ULL, 0x000fe40007fbe0ffULL,
0x0000003e3b307210ULL, 0x000fe40007fde0ffULL, 0x0000003a3500720cULL, 0x080fe20003f06070ULL,
0x000000ffff337224ULL, 0x000fe200028e0633ULL, 0x0000003a3f00720cULL, 0x080fe40003f66070ULL,
0x0000000b3c3c7c11ULL, 0x000fe200090f4431ULL, 0x000000ffff317224ULL, 0x000fe200030e063dULL,
0x0000000a393b7c11ULL, 0x000fe2000f8840ffULL, 0x00014000073d7836ULL, 0x000fe20000000000ULL,
0x0000003a4500720cULL, 0x000fc40003f46070ULL, 0x0000003a4900720cULL, 0x000fe20003fa6070ULL,
0x00000010443f7824ULL, 0x100fe200078e023dULL, 0x0000003e38387210ULL, 0x000fe20007fde0ffULL,
0x0000001046457824ULL, 0x100fe200078e023dULL, 0x0000000b39357c11ULL, 0x000fe2000a0f4436ULL,
0x0000001048497824ULL, 0x100fe200078e023dULL, 0x0000003e3b3a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200030e063cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303f7faeULL, 0x0003e2000c101c48ULL, 0x000000104a3d7824ULL, 0x000fe400078e023dULL,
0x000000ffff3b7224ULL, 0x000fe200020e0635ULL, 0x0000000032457faeULL, 0x0003e8000d901c48ULL,
0x0000000038497faeULL, 0x0003e8000d101c48ULL, 0x000000003a3d7faeULL, 0x0003e2000e901c48ULL,
0x0000000000e87947ULL, 0x000fea0003800000ULL, 0x0000000104357824ULL, 0x000fe200078e0235ULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x000000f036367812ULL, 0x000fe400078ec0ffULL,
0x0000000235327836ULL, 0x000fe40000000000ULL, 0x0000000435387836ULL, 0x000fe40000000000ULL,
0x0000000132317824ULL, 0x040fe400078e0209ULL, 0x00000010323a7824ULL, 0x000fc400078e00ffULL,
0x0000000138327824ULL, 0x140fe400078e0209ULL, 0x00000010383f7824ULL, 0x000fe200078e00ffULL,
0xfffffff03a3d7812ULL, 0x000fe200078ee231ULL, 0x00000006353c7836ULL, 0x000fe40000000000ULL,
0x0000000135307824ULL, 0x040fe200078e0209ULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee232ULL,
0x0000004008327824ULL, 0x000fe400078e0235ULL, 0x00000010353b7824ULL, 0x000fc400078e00ffULL,
0x0000000232387836ULL, 0x000fe20000000000ULL, 0x0000003932317210ULL, 0x000fe20007f1e0ffULL,
0x00000004323a7836ULL, 0x000fe20000000000ULL, 0xfffffff03b3b7812ULL, 0x000fe200078ee230ULL,
0x00000006323e7836ULL, 0x000fe20000000000ULL, 0x0000003938387210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x0000000631337c11ULL, 0x040fe2000f8440ffULL,
0x000000013c357824ULL, 0x040fe200078e0209ULL, 0x000000393a3a7210ULL, 0x000fe20007f9e0ffULL,
0x000000103c3c7824ULL, 0x000fe200078e00ffULL, 0x0000000731327c11ULL, 0x000fe200090f4432ULL,
0x0001400007307836ULL, 0x000fe20000000000ULL, 0x000000393e3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff317224ULL, 0x000fe200018e06ffULL, 0xfffffff03c497812ULL, 0x000fe200078ee235ULL,
0x000000103b357824ULL, 0x100fe200078e0230ULL, 0x0000000638397c11ULL, 0x000fe2000f8440ffULL,
0x000000103d3d7824ULL, 0x000fc400078e0230ULL, 0x000000103f457824ULL, 0x100fe200078e0230ULL,
0x00000007383b7c11ULL, 0x000fe200090f4431ULL, 0x00000010494b7824ULL, 0x000fe200078e0230ULL,
0x000000063a3f7c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff317224ULL, 0x000fe200020e06ffULL,
0x0000003633307210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e06ffULL,
0x000000063e497c11ULL, 0x000fe4000f8840ffULL, 0x000000073a3c7c11ULL, 0x000fe200098f4431ULL,
0x000000ffff317224ULL, 0x000fe200010e0632ULL, 0x0000003639327210ULL, 0x000fc40007f1e0ffULL,
0x000000363f387210ULL, 0x000fe40007f5e0ffULL, 0x000000073e3e7c11ULL, 0x000fe2000a0f4433ULL,
0x000000ffff337224ULL, 0x000fe200000e063bULL, 0x00000036493a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff397224ULL, 0x000fe200010e063cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030357faeULL, 0x0003e6000b901c48ULL, 0x000000ffff3b7224ULL, 0x000fe200018e063eULL,
0x00000000323d7faeULL, 0x0003e8000b901c48ULL, 0x0000000038457faeULL, 0x0003e8000b901c48ULL,
0x000000003a4b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff307424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0186a830073079a7ULL, 0x000e64000850003fULL,
0x000000ffff4c7224ULL, 0x002fe200078e0031ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b04f070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0186b04f070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000181947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x000fe40000011609ULL, 0x0000000cff0d723eULL, 0x000fc600000000ffULL,
0x0000000831337836ULL, 0x000fe20000000000ULL, 0x000054100d307816ULL, 0x000fca000000000dULL,
0x00001f31300d7589ULL, 0x0002a800000e0000ULL, 0x00001f33300e7589ULL, 0x0002e400000e0000ULL,
0x013800004730783bULL, 0x0022e20000000200ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000000000ULL, 0x0000000d32327232ULL, 0x000fe40000000000ULL,
0x0000000e31317232ULL, 0x080fe40000000000ULL, 0x0000000e33337232ULL, 0x000fce0000000000ULL,
0x00000000433c783bULL, 0x000f280000004200ULL, 0x000000004238783bULL, 0x000f620000004200ULL,
0x000001003c497824ULL, 0x050fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe4000001143cULL,
0x000088803c487816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x022fe20000011438ULL, 0x00000100384e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff477819ULL, 0x000fc4000001143dULL, 0x000088803d507816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe4000001143cULL, 0x00000018ff447819ULL, 0x000fe2000001143eULL,
0x0000004a00437306ULL, 0x0003e20000200c00ULL, 0x000088803e3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff457819ULL, 0x000fe4000001143fULL, 0x00000018ff4f7819ULL, 0x000fc4000001144eULL,
0x00000018ff427819ULL, 0x000fe20000011439ULL, 0x0000004900517306ULL, 0x0009e20000200c00ULL,
0x000001003d4a7824ULL, 0x002fe200078e00ffULL, 0x00008880394e7816ULL, 0x000fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe4000001143bULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000001003e497824ULL, 0x050fe200078e00ffULL, 0x0000004a005b7306ULL, 0x0003e20000200c00ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc4000001143aULL,
0x00000018ff4b7819ULL, 0x000fe40000011449ULL, 0x000088803f497816ULL, 0x040fe400000000ffULL,
0x0000003d00567306ULL, 0x0009e20000200c00ULL, 0x000001003f4a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003e00557306ULL, 0x0003e20000200c00ULL, 0x00008880383d7816ULL, 0x050fe200000000ffULL,
0x0001000038387824ULL, 0x000fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x00000100393e7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe4000001143eULL,
0x0000003f00547306ULL, 0x0003e20000200c00ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3e7816ULL, 0x000fca00000000ffULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000001003a3f7824ULL, 0x002fce00078e00ffULL, 0x0000003800527306ULL, 0x0003300000200c00ULL,
0x0000004a00587306ULL, 0x000fe20000200c00ULL, 0x000001003b387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004f004a7306ULL, 0x0003e20000200c00ULL,
0x0000541052527816ULL, 0x010fce0000000043ULL, 0x0000003900577306ULL, 0x0009e20000200c00ULL,
0x00000018ff4f7819ULL, 0x002fe4000001143fULL, 0x000088803b3f7816ULL, 0x040fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fc800078e00ffULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x000100003a397824ULL, 0x010fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fcc000001143bULL,
0x00000038003a7306ULL, 0x0009f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541048387816ULL, 0x010fe40000000051ULL, 0x00000018ff487819ULL, 0x000fc40000011439ULL,
0x0000541050397816ULL, 0x000fc6000000005bULL, 0x0000004b004b7306ULL, 0x000fe80000200c00ULL,
0x000000383010723cULL, 0x008fe80000001810ULL, 0x0000004700477306ULL, 0x000ee60000200c00ULL,
0x0000541053387816ULL, 0x002fca0000000046ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x0000541056397816ULL, 0x008fce0000000047ULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x000000383014723cULL, 0x000fe20000001814ULL, 0x0000541055447816ULL, 0x002fcc0000000044ULL,
0x0000004200427306ULL, 0x000e620000200c00ULL, 0x0000541054457816ULL, 0x008fce0000000045ULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x00000044301c723cULL, 0x000fe2000000181cULL,
0x0000541057537816ULL, 0x002fcc0000000042ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x000000523024723cULL, 0x000fee0000001824ULL, 0x0000004900497306ULL, 0x000e700000200c00ULL,
0x0000003d003d7306ULL, 0x000ee20000200c00ULL, 0x0000541049497816ULL, 0x002fce0000000058ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x000054103d4a7816ULL, 0x008fce000000004aULL,
0x0000005900597306ULL, 0x000ff00000200c00ULL, 0x0000003e003e7306ULL, 0x000ff00000200c00ULL,
0x0000004f004f7306ULL, 0x000e700000200c00ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x000054103e3e7816ULL, 0x002fce000000004fULL, 0x0000004800507306ULL, 0x0003220000200c00ULL,
0x000054103f3f7816ULL, 0x008fce000000003aULL, 0x0000003b003b7306ULL, 0x000ee20000200c00ULL,
0x000054103c487816ULL, 0x002fe4000000004bULL, 0x000054104e4b7816ULL, 0x000fe20000000059ULL,
0x0000003e3028723cULL, 0x000fe20000001828ULL, 0x0000541050507816ULL, 0x010fca0000000035ULL,
0x000000483018723cULL, 0x000fe20000001818ULL, 0x000054103b517816ULL, 0x008fca0000000036ULL,
0x0000004a3020723cULL, 0x000fec0000001820ULL, 0x00000050302c723cULL, 0x000fe2000000182cULL,
0x013800003730783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000101947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000000000ULL,
0x0000000d32327232ULL, 0x000fe40000000000ULL, 0x0000000e31317232ULL, 0x080fe40000000000ULL,
0x0000000e33337232ULL, 0x000fce0000000000ULL, 0x000000004038783bULL, 0x000f280000004200ULL,
0x00000000413c783bULL, 0x000f620000004200ULL, 0x00000018ff477819ULL, 0x010fe20000011438ULL,
0x00000100394e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011439ULL,
0x00000018ff467819ULL, 0x022fe2000001143cULL, 0x000001003c377824ULL, 0x040fe200078e00ffULL,
0x000088803c367816ULL, 0x040fe200000000ffULL, 0x0000004700417306ULL, 0x0003e20000200c00ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe2000001143dULL,
0x000001003e497824ULL, 0x000fe200078e00ffULL, 0x000088803d547816ULL, 0x000fc400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff447819ULL, 0x000fe2000001143eULL,
0x000001003d477824ULL, 0x042fe200078e00ffULL, 0x000088803e487816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x0000888039567816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011447ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003c00477306ULL, 0x0003e20000200c00ULL, 0x00000018ff437819ULL, 0x000fc4000001143fULL,
0x000088803f4a7816ULL, 0x040fe400000000ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff4f7819ULL, 0x000fe20000011439ULL, 0x0000003d00527306ULL, 0x0009e20000200c00ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe2000001144eULL,
0x000001003a397824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc4000001143cULL,
0x00008880383c7816ULL, 0x040fe200000000ffULL, 0x00000100383d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x0000003e004b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff357819ULL, 0x000fe4000001143aULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff4e7819ULL, 0x000fe40000011438ULL,
0x00000018ff407819ULL, 0x000fe2000001143bULL, 0x0000003d003f7306ULL, 0x0003e20000200c00ULL,
0x000088803a387816ULL, 0x040fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fc80000011449ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x00000056003e7306ULL, 0x0009e20000200c00ULL, 0x00000018ff3d7819ULL, 0x002fe40000011439ULL,
0x000088803b397816ULL, 0x000fca00000000ffULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x000001003b567824ULL, 0x050fe400078e00ffULL, 0x000100003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x00000018ff3b7819ULL, 0x000fce000001143bULL, 0x0000004600467306ULL, 0x000f220000200c00ULL,
0x0000541036367816ULL, 0x002fce0000000037ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541047467816ULL, 0x010fce0000000046ULL, 0x0000005500557306ULL, 0x000e700000200c00ULL,
0x0000004500457306ULL, 0x000f220000200c00ULL, 0x0000541054377816ULL, 0x002fce0000000055ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x000000363010723cULL, 0x008fe20000001810ULL,
0x0000541052477816ULL, 0x010fcc0000000045ULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x000000463014723cULL, 0x000fee0000001814ULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x0000541050457816ULL, 0x002fce0000000043ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054103c507816ULL, 0x008fce000000003fULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x00000001ff3c7424ULL, 0x000fc800078e00ffULL, 0x0186b83c073679a7ULL, 0x000ee6000850003fULL,
0x0000004400447306ULL, 0x000f220000200c00ULL, 0x0186a03c07ff79a7ULL, 0x000be2000850003fULL,
0x0000541048487816ULL, 0x002fcc0000000049ULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x000054104b447816ULL, 0x010fce0000000044ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x00000044301c723cULL, 0x000fee000000181cULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000005100517306ULL, 0x000f220000200c00ULL,
0x000054104a497816ULL, 0x002fce0000000053ULL, 0x0000003a003a7306ULL, 0x000e620000200c00ULL,
0x000000483018723cULL, 0x000fe20000001818ULL, 0x000054103e517816ULL, 0x010fcc0000000051ULL,
0x0000003b003b7306ULL, 0x000f220000200c00ULL, 0x000000503020723cULL, 0x000fe20000001820ULL,
0x000054103a3a7816ULL, 0x002fcc0000000035ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x000054103b3b7816ULL, 0x010fce0000000040ULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x0000003a302c723cULL, 0x000fee000000182cULL, 0x0000004f004f7306ULL, 0x000f220000200c00ULL,
0x000054104e4e7816ULL, 0x002fce0000000041ULL, 0x0000003800387306ULL, 0x000fe20000200c00ULL,
0x000054104f4f7816ULL, 0x010fce0000000042ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x0000004e3024723cULL, 0x000fee0000001824ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x000000040b4f7836ULL, 0x000fe20000000000ULL, 0x0000541038387816ULL, 0x002fcc000000003dULL,
0x0000005600567306ULL, 0x000e640000200c00ULL, 0x0000541039397816ULL, 0x002fce0000000056ULL,
0x000000383028723cULL, 0x000fee0000001828ULL, 0x000000ffff397224ULL, 0x02cfde00078e0037ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000405007c0cULL, 0x000fda000bf03070ULL, 0xffffff0800c48947ULL, 0x000fea000383ffffULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x000000ffff337224ULL, 0x000fe400078e001dULL,
0x000000ffff1d7224ULL, 0x000fe400078e0019ULL, 0x000000ffff317224ULL, 0x000fd000078e0013ULL,
0x0000000000dc8947ULL, 0x000fea0003800000ULL, 0x0180000000027836ULL, 0x000fe20000000000ULL,
0x000000d000007945ULL, 0x000fe80003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e0000ULL, 0x00010ab000057802ULL, 0x000fce0000000f00ULL,
0x0000007000ac7944ULL, 0x00efea0003c00000ULL, 0x000000ffff057224ULL, 0x008fe200078e0000ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000000057308ULL, 0x000f240000001000ULL,
0xbf80000005027423ULL, 0x010fc80000000000ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000205057223ULL, 0x000fce0000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009400ff027b82ULL, 0x000f240000000a00ULL, 0x0000000802027981ULL, 0x010f22000c1e9900ULL,
0x0000000000067919ULL, 0x000f640000000000ULL, 0x00000002ff007819ULL, 0x022fe40000011606ULL,
0x0000000806067811ULL, 0x000fe200078ff0ffULL, 0x0000000502057220ULL, 0x010fca0000410000ULL,
0x00001f0005007589ULL, 0x000e6800000e0000ULL, 0x00001f0605067589ULL, 0x000f2200000e0000ULL,
0x0000001000107220ULL, 0x042fe20000410000ULL, 0x0000001100117220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000003300337220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x000fe20000410000ULL,
0x0000001206127220ULL, 0x050fe20000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x0000001606167220ULL, 0x040fe20000410000ULL, 0x0000001706177220ULL, 0x040fe20000410000ULL,
0x0000001a061a7220ULL, 0x040fe20000410000ULL, 0x0000001b061b7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002e062e7220ULL, 0x040fe20000410000ULL, 0x0000002f062f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000f220000000000ULL, 0x0000080034077824ULL, 0x002fe200078e0207ULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x00000000000579c3ULL, 0x000e700000002700ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282928723eULL, 0x000fe200000000ffULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000161716723eULL, 0x000fe200000000ffULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000001a1b1a723eULL, 0x000fe200000000ffULL,
0x0000860000067ab9ULL, 0x000fe20000000a00ULL, 0x000000222322723eULL, 0x000fc400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe200000000ffULL, 0x00000005040472a4ULL, 0x002fe2000f8e023fULL,
0x0000000800097811ULL, 0x050fe400078ff0ffULL, 0x0000000200027812ULL, 0x000fe400078ec0ffULL,
0x00000002ff057819ULL, 0x100fe20000011600ULL, 0x0000000809067824ULL, 0x000fe200078e00ffULL,
0x0000000902037211ULL, 0x040fe400078ff8ffULL, 0x0000000502027211ULL, 0x000fe200078ff8ffULL,
0x00000008050a7824ULL, 0x048fe200078e00ffULL, 0xfffffff8060f7812ULL, 0x000fe200078ee203ULL,
0x0000000805037824ULL, 0x040fe200078e00ffULL, 0x00000003ff137819ULL, 0x000fe20000011600ULL,
0x00000008050b7824ULL, 0x000fc400078e00ffULL, 0x00000008050d7824ULL, 0x000fe200078e00ffULL,
0xfffffff803037812ULL, 0x000fe200078ee202ULL, 0x0000000202057836ULL, 0x000fe40000000000ULL,
0x0000000402067836ULL, 0x000fe40000000000ULL, 0x0000000602087836ULL, 0x000fe20000000000ULL,
0xfffffff80a097812ULL, 0x000fe200078ee205ULL, 0x00000020000a7836ULL, 0x000fe20000000000ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee206ULL, 0x0001200007027836ULL, 0x000fe20000000000ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL, 0x0000000113087824ULL, 0x000fe200078e0200ULL,
0x00000003ff197819ULL, 0x000fe2000001160aULL, 0x0000001003057824ULL, 0x100fe200078e0202ULL,
0x000000141503723eULL, 0x000fe200000000ffULL, 0x000000100f0f7824ULL, 0x000fc400078e0202ULL,
0x0000001009097824ULL, 0x100fe400078e0202ULL, 0x000000100b0b7824ULL, 0x100fe400078e0202ULL,
0x000000100d0d7824ULL, 0x000fe200078e0202ULL, 0x000000101102723eULL, 0x000fe200000000ffULL,
0x000000010a0c7824ULL, 0x000fe200078e0219ULL, 0x000000242510723eULL, 0x000fe200000000ffULL,
0x0000000800067824ULL, 0x000fe200078e00ffULL, 0x0000541002147816ULL, 0x140fe40000000003ULL,
0x0000763202157816ULL, 0x000fc40000000003ULL, 0x0000000708037812ULL, 0x000fe400078ec0ffULL,
0x000000070c117812ULL, 0x000fe400078ec0ffULL, 0x0000000806067812ULL, 0x000fe400078ec0ffULL,
0x0ffffff803087812ULL, 0x000fe400078ef800ULL, 0x0ffffff8110c7812ULL, 0x000fe200078ef80aULL,
0x0000000105057824ULL, 0x000fe200078e0206ULL, 0x000000181d02723eULL, 0x000fe200000000ffULL,
0x00000001060f7824ULL, 0x040fe200078e020fULL, 0x0000001c3303723eULL, 0x000fe200000000ffULL,
0x0000000106097824ULL, 0x040fe200078e0209ULL, 0x0000001405007388ULL, 0x0003e20000000a00ULL,
0x00000001060b7824ULL, 0x000fe200078e020bULL, 0x00005410201c7816ULL, 0x100fe20000000010ULL,
0x0000001008087824ULL, 0x000fe200078e0207ULL, 0x00007632201d7816ULL, 0x000fe20000000010ULL,
0x0000000106067824ULL, 0x000fe200078e020dULL, 0x00007632020d7816ULL, 0x000fe20000000003ULL,
0x000000100c077824ULL, 0x000fe200078e0207ULL, 0x00005410020c7816ULL, 0x000fc40000000003ULL,
0x000000123102723eULL, 0x000fe200000000ffULL, 0x0000000000057919ULL, 0x002e620000002600ULL,
0x0000002c2d14723eULL, 0x000fe400000000ffULL, 0x000000262711723eULL, 0x000fe200000000ffULL,
0x0000000c09007388ULL, 0x0007e20000000a00ULL, 0x0000002e2f15723eULL, 0x000fe400000000ffULL,
0x0000541022107816ULL, 0x140fe20000000011ULL, 0x0000001c0b007388ULL, 0x0009e20000000a00ULL,
0x0000763222117816ULL, 0x000fc40000000011ULL, 0x000076322a037816ULL, 0x000fe40000000015ULL,
0x0000001e1f0d723eULL, 0x008fe400000000ffULL, 0x00005410281c7816ULL, 0x150fe40000000014ULL,
0x00007632281d7816ULL, 0x000fe40000000014ULL, 0x000054101a0c7816ULL, 0x140fe4000000000dULL,
0x000076321a0d7816ULL, 0x000fe2000000000dULL, 0x0000001c06007388ULL, 0x0007e20000000a00ULL,
0x0000000805127824ULL, 0x002fc400078e00ffULL, 0x0000000805187824ULL, 0x000fe200078e00ffULL,
0x0000000700057812ULL, 0x000fe400078ec0ffULL, 0xfffffff812137812ULL, 0x000fe400078ee213ULL,
0x00005410021c7816ULL, 0x148fe40000000016ULL, 0x00007632021d7816ULL, 0x000fe40000000016ULL,
0x000054102a027816ULL, 0x000fe40000000015ULL, 0xfffffff818197812ULL, 0x000fe200078ee219ULL,
0x0000001c0f007388ULL, 0x000fe20000000a00ULL, 0x0000000413137c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000419197c10ULL, 0x000fe2000ff3e0ffULL, 0x0004000c09007388ULL, 0x0003e20000000a00ULL,
0x1ffffff805057812ULL, 0x000fc600078ef804ULL, 0x000400100b007388ULL, 0x000fe20000000a00ULL,
0x000000ffff007224ULL, 0x000fc600008e06ffULL, 0x0004000206007388ULL, 0x0007e20000000a00ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x01200000080c7984ULL, 0x0009620000000c00ULL,
0x000000070a097812ULL, 0x002fc600078ec0ffULL, 0x0120000007147984ULL, 0x0003620000000c00ULL,
0x0000000619067c11ULL, 0x008fe4000f8248ffULL, 0x1ffffff809097812ULL, 0x000fe200078ef804ULL,
0x000000ffff087224ULL, 0x010fe200000e06ffULL, 0x0000000613027c11ULL, 0x000fe4000f8048ffULL,
0x0000000719077c11ULL, 0x002fe400088f4c00ULL, 0x0000000713037c11ULL, 0x000fc600080f4c08ULL,
0x0000001005027825ULL, 0x000fc800078e0002ULL, 0x0000001009047825ULL, 0x000fe200078e0006ULL,
0x0000000c02007986ULL, 0x024fe8000c101d08ULL, 0x0000001404007986ULL, 0x000fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000063400720cULL, 0x000fe20003f06070ULL,
0x00009400ff127b82ULL, 0x000e620000000a00ULL, 0x00000001ff0a7424ULL, 0x000fcc00078e00ffULL,
0x0186000a070a79a7ULL, 0x0004aa000850003fULL, 0x000000020e038824ULL, 0x000fe200078e00ffULL,
0x00009000ff008b82ULL, 0x000ef00000000800ULL, 0x00008c00ff108b82ULL, 0x000f620000000a00ULL,
0x00000008120c7981ULL, 0x002522000c1e9900ULL, 0x0000000003038224ULL, 0x008fc400078e0234ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000403108825ULL, 0x020fca00078e0010ULL,
0x0000000810008981ULL, 0x000ee2000c1e1900ULL, 0x000001ff1400780cULL, 0x000fe20003f04070ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004034027824ULL, 0x000fe400078e00ffULL,
0x0000004008047824ULL, 0x000fc600078e00ffULL, 0x0000000400037c24ULL, 0x008fcc000f8e02ffULL,
0x0000000c00a80947ULL, 0x004fea0003800000ULL, 0x00000003ff127819ULL, 0x100fe20000011609ULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x000000020f117248ULL, 0x000fe40007fe0000ULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000412107836ULL, 0x000fe40000000000ULL,
0x0000000111117824ULL, 0x000fe400078e0a02ULL, 0x0000004008087824ULL, 0x000fe400078e0212ULL,
0x0000000110137824ULL, 0x040fe200078e0209ULL, 0x000000111000720cULL, 0x040fe20003f86070ULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0x00000008031f7210ULL, 0x000fe20007f1e0ffULL,
0x0000000812147836ULL, 0x000fc40000000000ULL, 0x0000000408107836ULL, 0x000fe20000000000ULL,
0xfffffff8161b7812ULL, 0x000fe200078ee213ULL, 0x0000000114137824ULL, 0x040fe200078e0209ULL,
0x000000111400720cULL, 0x040fe20003fa6070ULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x0000001003207210ULL, 0x000fe20007f3e0ffULL, 0x0000000808107836ULL, 0x000fe40000000000ULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x000000061f1a7c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x0000001003237210ULL, 0x000fe20007f5e0ffULL,
0x0000000c08107836ULL, 0x000fe20000000000ULL, 0x000000071f1f7c11ULL, 0x000fe200080f4414ULL,
0x0000001008147836ULL, 0x000fe20000000000ULL, 0x00000006201e7c11ULL, 0x040fe2000f8240ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0xfffffff8161d7812ULL, 0x000fe200078ee213ULL,
0x0000001408167836ULL, 0x000fe20000000000ULL, 0x0000000720207c11ULL, 0x000fe200088f4415ULL,
0x0000000112137824ULL, 0x000fe200078e0209ULL, 0x0000001003107210ULL, 0x000fc40007f3e0ffULL,
0x0000001403147210ULL, 0x000fe40007f5e0ffULL, 0x0000001603167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e06ffULL, 0x0000000614227c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x00000006231c7c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x00000006162c7c11ULL, 0x000fe4000f8440ffULL,
0x0000000714297c11ULL, 0x000fe200088f4429ULL, 0x0000000c12147836ULL, 0x000fe20000000000ULL,
0x0000000723237c11ULL, 0x000fe200080f4418ULL, 0x0000001808187836ULL, 0x000fe20000000000ULL,
0x0000000716277c11ULL, 0x000fe200090f4427ULL, 0x0000001012167836ULL, 0x000fe20000000000ULL,
0x0000000713247812ULL, 0x000fe200078ec0ffULL, 0x0000000114137824ULL, 0x140fe200078e0209ULL,
0x000000111400720cULL, 0x0c0fe20003f66070ULL, 0x0000000814267824ULL, 0x000fe200078e00ffULL,
0x0000001803187210ULL, 0x000fe20007fde0ffULL, 0x0000000116177824ULL, 0x040fe200078e0209ULL,
0x0000001a0d147210ULL, 0x000fe20007f3e0ffULL, 0x00000014121a7836ULL, 0x000fe20000000000ULL,
0x000000111600720cULL, 0x040fe20003f46070ULL, 0x0000000816167824ULL, 0x000fe200078e00ffULL,
0x00000006102e7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff197224ULL, 0x000fe200030e06ffULL,
0x0ffffff824257812ULL, 0x000fe200078ef809ULL, 0x000000ffff157224ULL, 0x000fe200008e061fULL,
0x0000000618287c11ULL, 0x000fc4000f8240ffULL, 0xfffffff816217812ULL, 0x000fe400078ee217ULL,
0x00000007182a7c11ULL, 0x000fe400088f4419ULL, 0x00000007102b7c11ULL, 0x000fe200080f442bULL,
0x0000400034107824ULL, 0x000fe200078e0207ULL, 0x0000001e0d167210ULL, 0x000fe20007f3e0ffULL,
0x00000018121e7836ULL, 0x000fe20000000000ULL, 0x000000111200720cULL, 0x000fe20003f06070ULL,
0x0000200010107836ULL, 0x000fe20000000000ULL, 0xfffffff8261f7812ULL, 0x000fe200078ee213ULL,
0x000000ffff177224ULL, 0x000fe200008e0620ULL, 0x0000001c0d187210ULL, 0x000fe20007f3e0ffULL,
0x0000001c08207836ULL, 0x000fc40000000000ULL, 0x0000001025137824ULL, 0x100fe400078e0210ULL,
0x000000011a1c7824ULL, 0x040fe200078e0209ULL, 0x0000002003207210ULL, 0x000fe20007fde0ffULL,
0x000000081a257824ULL, 0x040fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014137faeULL, 0x0003e2000c101c48ULL, 0x000000ffff197224ULL, 0x000fe200008e0623ULL,
0x000000111a00720cULL, 0x080fe20003f06070ULL, 0x000000081e2d7824ULL, 0x040fe200078e00ffULL,
0xfffffff825237812ULL, 0x000fe200078ee21cULL, 0x000000101d1d7824ULL, 0x000fe200078e0210ULL,
0x000000111e00720cULL, 0x000fe20003f26070ULL, 0x0000001c121c7836ULL, 0x000fc40000000000ULL,
0x000000101f1f7824ULL, 0x100fe400078e0210ULL, 0x0000001021217824ULL, 0x100fe400078e0210ULL,
0x000000101b137824ULL, 0x002fe400078e0210ULL, 0x000000011e147824ULL, 0x100fe400078e0209ULL,
0x000000ffff157224ULL, 0x000fe200030e06ffULL, 0x0000000620247c11ULL, 0x000fe2000f8c40ffULL,
0x0000000016137faeULL, 0x0003e2000e101c48ULL, 0xfffffff82d257812ULL, 0x000fe200078ee214ULL,
0x000000011c1e7824ULL, 0x000fe200078e0209ULL, 0x0000000720267c11ULL, 0x000fe2000b0f4415ULL,
0x00000000181d7faeULL, 0x0005e2000e901c48ULL, 0x0000002e0d147210ULL, 0x000fe20007fde0ffULL,
0x0000002012207836ULL, 0x000fe20000000000ULL, 0x000000220d1a7210ULL, 0x000fe20007fbe0ffULL,
0x0000002008227836ULL, 0x000fe20000000000ULL, 0x000000111c00720cULL, 0x000fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fc400030e062bULL, 0x0000000120167824ULL, 0x042fe200078e0209ULL,
0x0000002203227210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e0629ULL,
0x000000112000720cULL, 0x0c0fe20003fa6070ULL, 0x00000008201d7824ULL, 0x004fe200078e00ffULL,
0x00000000141f7faeULL, 0x0003e2000d901c48ULL, 0x000000081c2b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL,
0x0000002408167836ULL, 0x000fe20000000000ULL, 0x0000000622207c11ULL, 0x040fe2000f8c40ffULL,
0x0000002412187836ULL, 0x000fe20000000000ULL, 0xfffffff82b137812ULL, 0x000fe200078ee21eULL,
0x000000001a217faeULL, 0x0005e2000d101c48ULL, 0x0000000722227c11ULL, 0x000fe2000b0f4417ULL,
0x0000000118197824ULL, 0x040fe200078e0209ULL, 0x00000016031e7210ULL, 0x000fe20007fde0ffULL,
0x0000001023237824ULL, 0x100fe200078e0210ULL, 0x0000002c0d167210ULL, 0x000fe20007f7e0ffULL,
0x0000001025257824ULL, 0x000fe200078e0210ULL, 0x000000111800720cULL, 0x040fe20003f46070ULL,
0x0000000818187824ULL, 0x000fc400078e00ffULL, 0x000000ffff177224ULL, 0x000fe200018e0627ULL,
0x000000280d147210ULL, 0x002fe20007f7e0ffULL, 0x000000ffff297224ULL, 0x000fe200030e06ffULL,
0xfffffff818277812ULL, 0x000fe200078ee219ULL, 0x0000001013137824ULL, 0x000fe200078e0210ULL,
0x0000000016237faeULL, 0x0003e2000c101c48ULL, 0x000000ffff157224ULL, 0x000fe200018e062aULL,
0x000000240d187210ULL, 0x000fe20007f1e0ffULL, 0x000000101d1f7824ULL, 0x000fe200078e0210ULL,
0x000000061e1c7c11ULL, 0x040fe2000f8c40ffULL, 0x0000003c12247836ULL, 0x000fe20000000000ULL,
0x0000000014257faeULL, 0x0007e2000c901c48ULL, 0x000000ffff197224ULL, 0x000fe200000e0626ULL,
0x000000071e1e7c11ULL, 0x000fe2000b0f4429ULL, 0x0000001027277824ULL, 0x000fe200078e0210ULL,
0x000000200d1a7210ULL, 0x004fe20007f3e0ffULL, 0x0000003412207836ULL, 0x000fe20000000000ULL,
0x0000001c0d1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000002c12167836ULL, 0x002fe20000000000ULL,
0x0000000018137faeULL, 0x0003e2000e101c48ULL, 0x000000ffff1b7224ULL, 0x000fc400008e0622ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061eULL, 0x000000111600720cULL, 0x080fe20003f86070ULL,
0x0000002812147836ULL, 0x008fe20000000000ULL, 0x000000001a1f7faeULL, 0x0005e2000e901c48ULL,
0x00000030121e7836ULL, 0x000fe20000000000ULL, 0x000000112400720cULL, 0x080fe20003f06070ULL,
0x0000003812227836ULL, 0x000fe20000000000ULL, 0x000000111400720cULL, 0x0c0fe20003fa6070ULL,
0x0000002808127836ULL, 0x000fe20000000000ULL, 0x000000001c277faeULL, 0x0007e2000d101c48ULL,
0x0000000114137824ULL, 0x002fe200078e0209ULL, 0x000000111e00720cULL, 0x000fe20003f66070ULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0x0000001203147210ULL, 0x000fc40007fde0ffULL,
0x000000112000720cULL, 0x0c0fe20003f46070ULL, 0x00000008201b7824ULL, 0x004fe200078e00ffULL,
0x000000112200720cULL, 0x000fe20003f26070ULL, 0x000000ffff157224ULL, 0x000fe200030e06ffULL,
0x0000000614127c11ULL, 0x000fe4000f8c40ffULL, 0xfffffff818117812ULL, 0x000fe200078ee213ULL,
0x0000000116137824ULL, 0x040fe400078e0209ULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0x0000000714167c11ULL, 0x000fe2000b0f4415ULL, 0x0000002c08147836ULL, 0x000fe20000000000ULL,
0x000000120d127210ULL, 0x000fe20007fde0ffULL, 0x000000011e157824ULL, 0x040fe200078e0209ULL,
0xfffffff818177812ULL, 0x000fe200078ee213ULL, 0x000000081e1e7824ULL, 0x000fc400078e00ffULL,
0x000000ffff137224ULL, 0x000fe200030e0616ULL, 0x00000014031c7210ULL, 0x008fe20007fde0ffULL,
0x0000000120147824ULL, 0x100fe200078e0209ULL, 0xfffffff81e197812ULL, 0x000fe200078ee215ULL,
0x0000001011117824ULL, 0x000fe400078e0210ULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee214ULL, 0x0000003008147836ULL, 0x000fe20000000000ULL,
0x0000000012117faeULL, 0x0003e2000e901c48ULL, 0x000000061c1a7c11ULL, 0x000fe2000f8c40ffULL,
0x0000000122157824ULL, 0x000fc400078e0209ULL, 0x00000014031e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x000000071c1c7c11ULL, 0x000fe2000b0f441dULL,
0x0000000124167824ULL, 0x000fe200078e0209ULL, 0x000000061e187c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e06ffULL, 0x0000001a0d147210ULL, 0x000fe20007fbe0ffULL,
0x00000008241d7824ULL, 0x000fe200078e00ffULL, 0xfffffff822097812ULL, 0x000fe200078ee215ULL,
0x0000003408127836ULL, 0x002fe20000000000ULL, 0x000000071e1e7c11ULL, 0x000fe2000b0f441fULL,
0x000000ffff157224ULL, 0x000fe200028e061cULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL,
0x0000003808167836ULL, 0x000fe20000000000ULL, 0x0000001203127210ULL, 0x000fe20007fbe0ffULL,
0x0000001017177824ULL, 0x000fc400078e0210ULL, 0x0000003c08087836ULL, 0x000fe40000000000ULL,
0x000000ffff1f7224ULL, 0x000fe200028e06ffULL, 0x00000006121a7c11ULL, 0x040fe2000f8a40ffULL,
0x0000000014177faeULL, 0x0003e2000e101c48ULL, 0x0000000803117210ULL, 0x000fe20007fde0ffULL,
0x0000001019197824ULL, 0x100fe200078e0210ULL, 0x00000007121c7c11ULL, 0x000fe2000a8f441fULL,
0x000000101b1b7824ULL, 0x100fe200078e0210ULL, 0x0000001603137210ULL, 0x000fe20007f9e0ffULL,
0x0000001009037824ULL, 0x100fe200078e0210ULL, 0x000000180d087210ULL, 0x000fe20007fbe0ffULL,
0x000000101d1d7824ULL, 0x000fc400078e0210ULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x0000000613127c11ULL, 0x000fe2000f8840ffULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x0000000611147c11ULL, 0x002fe2000f8c40ffULL, 0x000000ffff097224ULL, 0x000fe200028e061eULL,
0x0000001a0d107210ULL, 0x000fe40007fbe0ffULL, 0x0000000713137c11ULL, 0x000fe4000a0f4418ULL,
0x0000000711157c11ULL, 0x000fe2000b0f4416ULL, 0x000000ffff117224ULL, 0x000fe200028e061cULL,
0x000000120d127210ULL, 0x000fe20007f9e0ffULL, 0x0000000008197faeULL, 0x0003e2000d901c48ULL,
0x000000140d147210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0613ULL,
0x00000000101b7faeULL, 0x0003e2000d101c48ULL, 0x000000ffff157224ULL, 0x000fc600028e0615ULL,
0x0000000012037faeULL, 0x0003e8000c901c48ULL, 0x00000000141d7faeULL, 0x0003e2000c101c48ULL,
0x0000000c00587947ULL, 0x000fea0003800000ULL, 0x0000000409107811ULL, 0x040fe200078fe8ffULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000809117811ULL, 0x040fe200078fe8ffULL,
0x0000400034327824ULL, 0x000fe200078e0207ULL, 0x0000000c09127811ULL, 0x040fe200078fe8ffULL,
0x00000001102d7824ULL, 0x140fe200078e0209ULL, 0x0000001009137811ULL, 0x040fe200078fe8ffULL,
0x0000000810087824ULL, 0x000fe200078e00ffULL, 0x0000001809177811ULL, 0x000fe200078fe8ffULL,
0x00000001112c7824ULL, 0x100fe200078e0209ULL, 0x00000020091d7811ULL, 0x000fe200078fe8ffULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0xfffffff8082d7812ULL, 0x000fe200078ee22dULL,
0x00000001122b7824ULL, 0x140fe200078e0209ULL, 0x0000002409317811ULL, 0x000fe200078fe8ffULL,
0x0000000812087824ULL, 0x000fe200078e00ffULL, 0xfffffff8152c7812ULL, 0x000fe200078ee22cULL,
0x00000001132a7824ULL, 0x100fe200078e0209ULL, 0x0000001409157811ULL, 0x000fe200078fe8ffULL,
0x0000000813197824ULL, 0x000fe200078e00ffULL, 0xfffffff8082b7812ULL, 0x000fe200078ee22bULL,
0x0000000117287824ULL, 0x100fe200078e0209ULL, 0x0000002809337811ULL, 0x000fe200078fe8ffULL,
0x0000000115297824ULL, 0x140fe200078e0209ULL, 0xfffffff8192a7812ULL, 0x000fe200078ee22aULL,
0x0000000815087824ULL, 0x000fe200078e00ffULL, 0x0000001c09197811ULL, 0x000fe200078fe8ffULL,
0x00000008171b7824ULL, 0x000fe200078e00ffULL, 0x0000002c09357811ULL, 0x000fe200078fe8ffULL,
0x000000011d267824ULL, 0x100fe200078e0209ULL, 0xfffffff808297812ULL, 0x000fe200078ee229ULL,
0x0000000119277824ULL, 0x140fe200078e0209ULL, 0xfffffff81b287812ULL, 0x000fe200078ee228ULL,
0x0000000819087824ULL, 0x000fe200078e00ffULL, 0x0000003009377811ULL, 0x000fe200078fe8ffULL,
0x000000081d1b7824ULL, 0x000fe200078e00ffULL, 0x0000003409397811ULL, 0x000fe200078fe8ffULL,
0x0000000131257824ULL, 0x140fe200078e0209ULL, 0xfffffff808277812ULL, 0x000fe200078ee227ULL,
0x0000000831087824ULL, 0x000fe200078e00ffULL, 0xfffffff81b267812ULL, 0x000fe200078ee226ULL,
0x0000000133247824ULL, 0x100fe200078e0209ULL, 0x00000038093b7811ULL, 0x000fe200078fe8ffULL,
0x00000008331b7824ULL, 0x000fe200078e00ffULL, 0xfffffff808257812ULL, 0x000fe200078ee225ULL,
0x0000000135237824ULL, 0x100fe200078e0209ULL, 0x00000009092f7211ULL, 0x000fe200078fe8ffULL,
0x0000000835087824ULL, 0x000fe200078e00ffULL, 0xfffffff81b247812ULL, 0x000fe200078ee224ULL,
0x0000000137227824ULL, 0x100fe200078e0209ULL, 0x000000700d497812ULL, 0x000fe200078ec0ffULL,
0x00000008371b7824ULL, 0x000fe200078e00ffULL, 0xfffffff808237812ULL, 0x000fe200078ee223ULL,
0x0000000104107824ULL, 0x040fe200078e0210ULL, 0x0000000409087211ULL, 0x000fe200078fe8ffULL,
0x0000000139217824ULL, 0x140fe200078e0209ULL, 0xfffffff81b227812ULL, 0x000fe200078ee222ULL,
0x0000000839147824ULL, 0x000fe200078e00ffULL, 0x00000008031a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b2e7824ULL, 0x040fe200078e0209ULL, 0x0000001003187210ULL, 0x000fe20007f3e0ffULL,
0x000000083b1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff814217812ULL, 0x000fe200078ee221ULL,
0x0000000104147824ULL, 0x000fc400078e0211ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0xfffffff81b2e7812ULL, 0x000fe200078ee22eULL, 0x000000ffff1b7224ULL, 0x000fe200000e06ffULL,
0x000000061a087c11ULL, 0x000fe2000f8040ffULL, 0x0000000104167824ULL, 0x000fe200078e0212ULL,
0x0000000618107c11ULL, 0x000fe2000f8240ffULL, 0x0000200032477836ULL, 0x000fe20000000000ULL,
0x000000071a127c11ULL, 0x000fe200080f441bULL, 0x0000000104327824ULL, 0x000fe200078e0231ULL,
0x0000000718117c11ULL, 0x000fe200088f4411ULL, 0x0000000104187824ULL, 0x040fe200078e0215ULL,
0x00000014031f7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104387824ULL, 0x040fe200078e0235ULL,
0x00000016031a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000104167824ULL, 0x000fe200078e0213ULL,
0x0000003203427210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x000000061f1c7c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x000000061a147c11ULL, 0x000fe2000f8240ffULL, 0x00000001043a7824ULL, 0x040fe200078e0237ULL,
0x00000016031e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000104367824ULL, 0x040fe200078e0233ULL,
0x000000071f137c11ULL, 0x000fe200080f4420ULL, 0x00000001043c7824ULL, 0x000fe200078e0239ULL,
0x000000071a157c11ULL, 0x000fe200088f441bULL, 0x000000ffff1f7224ULL, 0x000fe200010e06ffULL,
0x00000018031b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000104187824ULL, 0x000fe200078e0217ULL,
0x000000061e167c11ULL, 0x000fe2000f8040ffULL, 0x00000001043e7824ULL, 0x000fe200078e023bULL,
0x0000003603367210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x000000071e177c11ULL, 0x000fe200080f441fULL, 0x00000001041e7824ULL, 0x040fe200078e0219ULL,
0x0000001803207210ULL, 0x000fe20007f1e0ffULL, 0x0000000104187824ULL, 0x000fe200078e021dULL,
0x000000061b1a7c11ULL, 0x000fe2000f8240ffULL, 0x0000001027377824ULL, 0x100fe200078e0247ULL,
0x0000000642327c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x000000071b1b7c11ULL, 0x000fe200088f4430ULL, 0x0000001029337824ULL, 0x100fe200078e0247ULL,
0x0000001e03197210ULL, 0x000fe20007f3e0ffULL, 0x0000001026397824ULL, 0x100fe200078e0247ULL,
0x0000001803187210ULL, 0x000fe20007f5e0ffULL, 0x0000001028357824ULL, 0x000fe200078e0247ULL,
0x00000006201f7c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x00000006191e7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff3d7224ULL, 0x000fe200010e06ffULL,
0x00000007201d7c11ULL, 0x000fe200080f441dULL, 0x00000010253b7824ULL, 0x100fe200078e0247ULL,
0x0000000618207c11ULL, 0x040fe2000f8040ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0247ULL,
0x0000000719197c11ULL, 0x000fe200088f4430ULL, 0x000000102b2b7824ULL, 0x000fe200078e0247ULL,
0x0000000718187c11ULL, 0x000fe200080f443dULL, 0x000000102a317824ULL, 0x100fe200078e0247ULL,
0x0000003c093d7811ULL, 0x000fe200078fe8ffULL, 0x00000010233f7824ULL, 0x000fe200078e0247ULL,
0x000000072f307812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2f7224ULL, 0x000fe200020e06ffULL,
0x0000003803387210ULL, 0x000fe20007f1e0ffULL, 0x000000083d447824ULL, 0x040fe200078e00ffULL,
0x0ffffff830307812ULL, 0x000fe200078ef809ULL, 0x000000013d097824ULL, 0x000fe200078e0209ULL,
0x0000003a033a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000104407824ULL, 0x000fe200078e023dULL,
0x0000003c033c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e06ffULL,
0xfffffff844097812ULL, 0x000fe200078ee209ULL, 0x000000ffff297224ULL, 0x000fe200008e06ffULL,
0x0000003e033e7210ULL, 0x000fe20007f9e0ffULL, 0x00000010243d7824ULL, 0x100fe200078e0247ULL,
0x0000000638267c11ULL, 0x000fe2000f8040ffULL, 0x0000001022417824ULL, 0x100fe200078e0247ULL,
0x0000004003407210ULL, 0x000fe20007fbe0ffULL, 0x0000001030037824ULL, 0x000fe200078e0247ULL,
0x0000000742427c11ULL, 0x000fe2000b0f442fULL, 0x000000102c2f7824ULL, 0x100fe200078e0247ULL,
0x000000063a287c11ULL, 0x000fe2000f8240ffULL, 0x0000001021437824ULL, 0x000fe200078e0247ULL,
0x0000000738277c11ULL, 0x000fe200080f4427ULL, 0x000000102e457824ULL, 0x000fe200078e0247ULL,
0x000000073a297c11ULL, 0x000fe200088f4429ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x0000000636247c11ULL, 0x000fe2000f8640ffULL, 0x0000001009477824ULL, 0x000fe200078e0247ULL,
0x0000000849087210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x000000063e237c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff097224ULL, 0x000fe200020e06ffULL,
0x000000063c2a7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e06ffULL,
0x0000000736257c11ULL, 0x000fc400098f4425ULL, 0x00000006402c7c11ULL, 0x000fe4000f8640ffULL,
0x000000073e2e7c11ULL, 0x000fe200090f4409ULL, 0x000000ffff097224ULL, 0x000fe200000e0612ULL,
0x000000073c307c11ULL, 0x000fe400088f4421ULL, 0x0000001049107210ULL, 0x000fe40007f3e0ffULL,
0x0000001c49127210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008037faeULL, 0x000fe2000b901c48ULL, 0x00000007400d7c11ULL, 0x000fe200098f440dULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000001449147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x0000001649167210ULL, 0x000fc40007fbe0ffULL,
0x0000001a491a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x0000001f491c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x0000001e491e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e061bULL,
0x0000002049207210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x0000003249227210ULL, 0x000fe20007f7e0ffULL, 0x00000000102d7faeULL, 0x0005e2000b901c48ULL,
0x0000002449247210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e0619ULL,
0x0000002649267210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff217224ULL, 0x000fe200010e0618ULL,
0x0000002849287210ULL, 0x000fe20007f1e0ffULL, 0x00000000122f7faeULL, 0x000fe2000b901c48ULL,
0x0000002a492a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x0000002349187210ULL, 0x000fe20007f5e0ffULL, 0x00000000142b7faeULL, 0x0007e2000b901c48ULL,
0x000000ffff237224ULL, 0x000fe200018e0642ULL, 0x0000002c492c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200020e0627ULL, 0x0000000016317faeULL, 0x0003e2000b901c48ULL,
0x000000ffff297224ULL, 0x000fc400000e0629ULL, 0x000000ffff197224ULL, 0x000fe200010e062eULL,
0x000000001a337faeULL, 0x0003e2000b901c48ULL, 0x000000ffff2d7224ULL, 0x004fc600018e060dULL,
0x000000001c357faeULL, 0x0003e2000b901c48ULL, 0x000000ffff2b7224ULL, 0x008fc600008e0630ULL,
0x000000001e377faeULL, 0x0003e8000b901c48ULL, 0x0000000020397faeULL, 0x0003e8000b901c48ULL,
0x00000000223b7faeULL, 0x0003e8000b901c48ULL, 0x00000000243d7faeULL, 0x0003e8000b901c48ULL,
0x00000000263f7faeULL, 0x0003e8000b901c48ULL, 0x0000000028417faeULL, 0x0003e8000b901c48ULL,
0x000000002a437faeULL, 0x0003e8000b901c48ULL, 0x0000000018457faeULL, 0x0003e8000b901c48ULL,
0x000000002c477faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fce0000015200ULL, 0x0186000b070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0d7224ULL, 0x000fce00078e00ffULL,
0x000000100d00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x0000001008107210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e09ULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011411ULL,
0x0000001003037211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0611ULL,
0x0000000203037819ULL, 0x000fc80000001210ULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010d0d7836ULL, 0x000fce0000000000ULL,
0x0186000b070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002034037824ULL, 0x002fca00078e0203ULL,
0x00000003ff087819ULL, 0x000fe40000011603ULL, 0x0000000f03037812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe08087812ULL, 0x000fc600078ec0ffULL, 0x0000000103097836ULL, 0x000fe40000000000ULL,
0x00000001030a7824ULL, 0x040fe400078e0208ULL, 0x00000001080b7824ULL, 0x000fe400078e0209ULL,
0x0000002003107824ULL, 0x040fe200078e00ffULL, 0x0000001f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000020030d7824ULL, 0x000fe200078e00ffULL, 0x0000001f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000001008087836ULL, 0x000fc40000000000ULL, 0x0000002003127824ULL, 0x040fe200078e00ffULL,
0x000001e010107812ULL, 0x000fe200078ee20bULL, 0x00000001030b7824ULL, 0x100fe200078e0208ULL,
0x000001e00d0a7812ULL, 0x000fe200078ee20aULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000001010107824ULL, 0x100fe200078e0207ULL, 0x0000001f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000100a0a7824ULL, 0x000fe400078e0207ULL, 0x00000020031c7824ULL, 0x000fe200078e00ffULL,
0x0000000010147984ULL, 0x000e620000000c00ULL, 0x0000001f08037812ULL, 0x000fc400078ec0ffULL,
0x000001e012087812ULL, 0x000fe200078ee20bULL, 0x000000000a187984ULL, 0x000ea20000000c00ULL,
0x000001e01c127812ULL, 0x000fc600078ee203ULL, 0x0000001008087824ULL, 0x100fe400078e0207ULL,
0x0000001012127824ULL, 0x000fe400078e0207ULL, 0x000000ffff1e7224ULL, 0x002fe400078e0014ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff1c7224ULL, 0x004fe400078e0018ULL,
0x000000ffff1d7224ULL, 0x000fc400078e001aULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff237224ULL, 0x000fe200078e0017ULL, 0x0000001c0a007388ULL, 0x000fe20000000c00ULL,
0x000000ffff207224ULL, 0x000fe400078e0019ULL, 0x000000ffff217224ULL, 0x000fca00078e001bULL,
0x0000002010007388ULL, 0x0003e80000000c00ULL, 0x0000000012147984ULL, 0x000ea80000000c00ULL,
0x0000000008187984ULL, 0x000ee20000000c00ULL, 0x00000001ff107424ULL, 0x002fe400078e00ffULL,
0x000000ffff277224ULL, 0x004fc400078e0016ULL, 0x000000ffff267224ULL, 0x000fe400078e0014ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff247224ULL, 0x008fe400078e0018ULL,
0x000000ffff257224ULL, 0x000fe400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x0000002408007388ULL, 0x0003e80000000c00ULL,
0x0000001412007388ULL, 0x0003e20000000c00ULL, 0x01860010071079a7ULL, 0x0002a4000850003fULL,
0x0000000000087805ULL, 0x002fce0000015200ULL, 0x01860011070075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0d7224ULL, 0x000fce00078e00ffULL,
0x000000100d00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140bULL,
0x0000000a03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000203037819ULL, 0x000fc8000000120aULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010d0d7836ULL, 0x000fce0000000000ULL,
0x01860011070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff0500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000900000057ab9ULL, 0x000fe20000000800ULL,
0x3d8000000c087820ULL, 0x010fe20000410000ULL, 0x0000000834097824ULL, 0x140fe200078e0207ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0xffffffff050a7836ULL, 0x000fe40000000000ULL,
0x00000020340b7824ULL, 0x000fe400078e0207ULL, 0x000000ffff357224ULL, 0x000fe400078e0034ULL,
0x000000050e0e7c24ULL, 0x000fce000f8e02ffULL, 0x000001000d367824ULL, 0x000fca00078e0202ULL,
0x000000360f00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x014fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fce000001ff00ULL,
0x0000000137147836ULL, 0x000fe40000000000ULL, 0x000000ffff437224ULL, 0x000fe400078e0037ULL,
0x0000000400127c24ULL, 0x010fe2000f8e02ffULL, 0x0000000d14137211ULL, 0x040fe200078ff8ffULL,
0x000000ffff377224ULL, 0x000fe200078e0014ULL, 0x000000021400780cULL, 0x040fe40003f06070ULL,
0x0000000114117812ULL, 0x000fe200078ec0ffULL, 0x00000001130c7836ULL, 0x000fca0000000000ULL,
0x000000050c00720cULL, 0x000fe40003f26070ULL, 0x00000001100c7812ULL, 0x000fd600078e0cffULL,
0x0000000c00749947ULL, 0x000fea0003800000ULL, 0x00000100134e7824ULL, 0x000fe200078e0202ULL,
0x00000003ff537819ULL, 0x002fe20000011603ULL, 0x00008a0000067ab9ULL, 0x000fc60000000a00ULL,
0x0000004e0f137248ULL, 0x000fe20007fe0000ULL, 0x0000000104157824ULL, 0x040fe400078e0253ULL,
0x0000000453177836ULL, 0x000fe40000000000ULL, 0x00000001134e7824ULL, 0x000fe200078e0a4eULL,
0x0000001512157210ULL, 0x000fe20007f3e0ffULL, 0x0000000104137824ULL, 0x040fe400078e0217ULL,
0x00000008531d7836ULL, 0x000fe20000000000ULL, 0x0000004e1700720cULL, 0x080fe20003f46070ULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x0000000615407c11ULL, 0x040fe2000f8240ffULL,
0x0000000c534f7836ULL, 0x000fe20000000000ULL, 0x0000001312147210ULL, 0x000fe20007f7e0ffULL,
0x0000000104137824ULL, 0x000fe200078e021dULL, 0x0000000715417c11ULL, 0x000fe200088f4416ULL,
0x0000001053557836ULL, 0x000fe20000000000ULL, 0x0000000614447c11ULL, 0x040fe2000f8240ffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x0000004e1d00720cULL, 0x080fe20003f66070ULL,
0x0000001453597836ULL, 0x000fe20000000000ULL, 0x0000004e4f00720cULL, 0x000fe20003fa6070ULL,
0x00000001174d7824ULL, 0x040fe200078e0203ULL, 0x0000000714457c11ULL, 0x000fe200088f4415ULL,
0x0000000104157824ULL, 0x000fe200078e024fULL, 0x0000001312167210ULL, 0x000fe20007f3e0ffULL,
0x00000008171c7824ULL, 0x000fc400078e00ffULL, 0x000000011d577824ULL, 0x040fe200078e0203ULL,
0x0000001512147210ULL, 0x000fe20007f9e0ffULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c4d7812ULL, 0x000fe200078ee24dULL, 0x000000ffff1d7224ULL, 0x000fe200008e06ffULL,
0x0000000616487c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x00000006144a7c11ULL, 0x000fe2000f8840ffULL, 0x0000000104137824ULL, 0x000fe200078e0255ULL,
0x0000000716497c11ULL, 0x000fe200088f441dULL, 0x0000000104157824ULL, 0x000fe200078e0259ULL,
0x00000007144b7c11ULL, 0x000fe2000a0f4417ULL, 0x0000001853617836ULL, 0x000fe20000000000ULL,
0x0000001312137210ULL, 0x000fe20007f3e0ffULL, 0x0000001c535f7836ULL, 0x000fe20000000000ULL,
0x0000001512157210ULL, 0x000fe20007f9e0ffULL, 0x000000014f637824ULL, 0x000fe200078e0203ULL,
0xfffffff81e577812ULL, 0x000fe200078ee257ULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x0000000613467c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x00000006151e7c11ULL, 0x000fe2000f8840ffULL, 0x000000084f4c7824ULL, 0x000fe200078e00ffULL,
0x0000000713477c11ULL, 0x000fe200088f4416ULL, 0x0000000104137824ULL, 0x040fe200078e0261ULL,
0x00000007151f7c11ULL, 0x000fe2000a0f4414ULL, 0x0000000104157824ULL, 0x040fe200078e025fULL,
0xfffffff84c637812ULL, 0x000fe200078ee263ULL, 0x00000020535d7836ULL, 0x000fe20000000000ULL,
0x0000001312137210ULL, 0x000fe20007f3e0ffULL, 0x00000024535b7836ULL, 0x000fe20000000000ULL,
0x0000001512157210ULL, 0x000fe20007f9e0ffULL, 0x0000000104177824ULL, 0x000fc400078e025dULL,
0x000000ffff427224ULL, 0x000fe200008e06ffULL, 0x00000006131c7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff167224ULL, 0x000fe200020e06ffULL, 0x0000000615147c11ULL, 0x000fe2000f8840ffULL,
0x0000000155657824ULL, 0x100fe200078e0203ULL, 0x00000007131d7c11ULL, 0x000fe200088f4442ULL,
0x0000000811427824ULL, 0x000fe200078e00ffULL, 0x0000000715157c11ULL, 0x000fe2000a0f4416ULL,
0x0000000153167824ULL, 0x040fe200078e0203ULL, 0x0000004e5300720cULL, 0x000fe20003f26070ULL,
0x0000400034137824ULL, 0x000fe200078e0207ULL, 0xfffffff8424f7812ULL, 0x000fe200078ee203ULL,
0x0000000855527824ULL, 0x000fe200078e00ffULL, 0x0000000716167812ULL, 0x000fe200078ec0ffULL,
0x000020000c427824ULL, 0x000fe200078e0213ULL, 0x0000001712177210ULL, 0x000fe20007f9e0ffULL,
0x000000104f507825ULL, 0x000fe200078e0040ULL, 0x0ffffff816697812ULL, 0x000fc400078ef803ULL,
0x0000000617167c11ULL, 0x000fe2000f8c40ffULL, 0x0000200042427836ULL, 0x000fe20000000000ULL,
0xfffffff852657812ULL, 0x000fe200078ee265ULL, 0x0000000104417824ULL, 0x000fe400078e025bULL,
0x0000001069697824ULL, 0x100fe400078e0242ULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x0000004e5500720cULL, 0x000fe20003f86070ULL, 0x0000002853557836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000050697faeULL, 0x0003e2000c901c48ULL,
0x0000004112417210ULL, 0x000fe20007f3e0ffULL, 0x000000104d6b7824ULL, 0x000fe200078e0242ULL,
0x0000000717177c11ULL, 0x000fe2000b0f444cULL, 0x000000104f4c7825ULL, 0x000fe200078e0044ULL,
0x0000000641407c11ULL, 0x000fc6000f8c40ffULL, 0x000000ffff527224ULL, 0x000fe200008e06ffULL,
0x0000004e5900720cULL, 0x040fe20003f26070ULL, 0x0000000104457824ULL, 0x000fe200078e0255ULL,
0x000000004c6b7faeULL, 0x0005e2000d101c48ULL, 0x0000000159677824ULL, 0x000fe200078e0203ULL,
0x0000000741417c11ULL, 0x000fe2000b0f4452ULL, 0x0000000859547824ULL, 0x000fe200078e00ffULL,
0x0000004512457210ULL, 0x000fe20007f5e0ffULL, 0x0000002c53597836ULL, 0x000fe40000000000ULL,
0x0000001057697824ULL, 0x002fe200078e0242ULL, 0xfffffff854677812ULL, 0x000fe200078ee267ULL,
0x000000104f507825ULL, 0x000fe200078e0048ULL, 0x0000000645447c11ULL, 0x000fc6000f8c40ffULL,
0x0000000104497824ULL, 0x000fe200078e0259ULL, 0x0000000050697faeULL, 0x0003e2000d901c48ULL,
0x0000003053577836ULL, 0x000fe40000000000ULL, 0x000000ffff527224ULL, 0x000fe200010e06ffULL,
0x0000004912497210ULL, 0x000fe20007f7e0ffULL, 0x0000000161547824ULL, 0x040fe200078e0203ULL,
0x0000004e6100720cULL, 0x040fe20003f46070ULL, 0x00000008616d7824ULL, 0x000fe200078e00ffULL,
0x0000000745457c11ULL, 0x000fe2000b0f4452ULL, 0x0000001063637824ULL, 0x000fe200078e0242ULL,
0x0000000649487c11ULL, 0x000fe2000f8c40ffULL, 0x000000104f4c7825ULL, 0x004fe200078e004aULL,
0xfffffff86d6d7812ULL, 0x000fc600078ee254ULL, 0x00000001044b7824ULL, 0x000fe200078e0257ULL,
0x000000004c637faeULL, 0x0005e2000e901c48ULL, 0x000000ffff527224ULL, 0x000fe200018e06ffULL,
0x0000004e5f00720cULL, 0x0c0fe20003f66070ULL, 0x000000015f617824ULL, 0x140fe200078e0203ULL,
0x0000004b124b7210ULL, 0x000fe20007fbe0ffULL, 0x000000085f547824ULL, 0x000fe200078e00ffULL,
0x0000000749497c11ULL, 0x000fe2000b0f4452ULL, 0x000000085d697824ULL, 0x002fe200078e00ffULL,
0x000000064b4a7c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff527224ULL, 0x000fe200028e06ffULL,
0xfffffff854617812ULL, 0x000fe200078ee261ULL, 0x000000015d547824ULL, 0x040fe200078e0203ULL,
0x0000004e5d00720cULL, 0x000fe20003fa6070ULL, 0x00000034535d7836ULL, 0x000fe20000000000ULL,
0x000000074b4b7c11ULL, 0x000fe2000b0f4452ULL, 0x000000104f507825ULL, 0x000fe200078e0046ULL,
0xfffffff869697812ULL, 0x000fc600078ee254ULL, 0x0000000104477824ULL, 0x000fe400078e025dULL,
0x0000001065657824ULL, 0x100fe400078e0242ULL, 0x00000038535f7836ULL, 0x000fe20000000000ULL,
0x0000004712477210ULL, 0x000fe20007fde0ffULL, 0x0000001067677824ULL, 0x000fe200078e0242ULL,
0x0000000050657faeULL, 0x0003e2000e101c48ULL, 0x000000104f1e7825ULL, 0x000fe200078e001eULL,
0x0000004e5b00720cULL, 0x000fc60003f86070ULL, 0x000000104f4c7825ULL, 0x004fe200078e001cULL,
0x000000001e677faeULL, 0x000fe6000c901c48ULL, 0x00000001041d7824ULL, 0x000fe400078e025fULL,
0x000000015b547824ULL, 0x040fe400078e0203ULL, 0x0000003c53657836ULL, 0x002fe20000000000ULL,
0x0000001d12507210ULL, 0x000fe20007f3e0ffULL, 0x000000085b637824ULL, 0x000fc400078e00ffULL,
0x000000ffff527224ULL, 0x000fe200030e06ffULL, 0x0000000647467c11ULL, 0x000fe2000f8c40ffULL,
0x000000106d5b7824ULL, 0x000fe200078e0242ULL, 0xfffffff863637812ULL, 0x000fe200078ee254ULL,
0x00000001041d7824ULL, 0x000fe200078e0265ULL, 0x0000000747477c11ULL, 0x000fe2000b0f4452ULL,
0x000000ffff517224ULL, 0x000fe200008e06ffULL, 0x000000004c5b7faeULL, 0x0003e2000d101c48ULL,
0x00000006501c7c11ULL, 0x000fe2000f8440ffULL, 0x0000001061617824ULL, 0x000fe200078e0242ULL,
0x0000001d12127210ULL, 0x000fe20007fde0ffULL, 0x000000104f147825ULL, 0x000fe200078e0014ULL,
0x0000004e5500720cULL, 0x000fc40003f26070ULL, 0x00000007501d7c11ULL, 0x000fe200090f4451ULL,
0x0000000155527824ULL, 0x040fe200078e0203ULL, 0x0000000014617faeULL, 0x0005e2000d901c48ULL,
0x0000000855537824ULL, 0x000fe200078e00ffULL, 0x0000004e5700720cULL, 0x080fe20003f66070ULL,
0x00000010694d7824ULL, 0x002fe200078e0242ULL, 0x0000004e5900720cULL, 0x000fe20003f46070ULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x00000006121e7c11ULL, 0x000fe2000f8c40ffULL,
0x000000104f167825ULL, 0x000fe200078e0016ULL, 0xfffffff853537812ULL, 0x000fc400078ee252ULL,
0x00000007121f7c11ULL, 0x000fe2000b0f441fULL, 0x00000001594c7824ULL, 0x040fe200078e0203ULL,
0x00000000164d7faeULL, 0x0003e2000e901c48ULL, 0x0000000859557824ULL, 0x000fe200078e00ffULL,
0x0000004e5f00720cULL, 0x080fe20003fa6070ULL, 0x0000001063517824ULL, 0x000fe200078e0242ULL,
0x0000004e6500720cULL, 0x000fe20003fc6070ULL, 0x000000104f407825ULL, 0x000fe200078e0040ULL,
0xfffffff855557812ULL, 0x000fc600078ee24cULL, 0x0000000157127824ULL, 0x100fe200078e0203ULL,
0x0000000040517faeULL, 0x0007e2000e101c48ULL, 0x0000004e5d00720cULL, 0x000fe20003f86070ULL,
0x0000000857577824ULL, 0x000fe400078e00ffULL, 0x000000015d4c7824ULL, 0x140fe400078e0203ULL,
0x000000085d5d7824ULL, 0x000fe400078e00ffULL, 0x000000015f147824ULL, 0x144fe400078e0203ULL,
0x000000085f5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff85d4d7812ULL, 0x002fe200078ee24cULL,
0x0000000165157824ULL, 0x040fe200078e0203ULL, 0xfffffff857417812ULL, 0x008fe200078ee212ULL,
0x0000000865167824ULL, 0x000fe200078e00ffULL, 0xfffffff85f517812ULL, 0x000fe200078ee214ULL,
0x000000104f447825ULL, 0x000fc600078e0044ULL, 0xfffffff816577812ULL, 0x000fe200078ee215ULL,
0x0000001053157824ULL, 0x100fe400078e0242ULL, 0x0000001055177824ULL, 0x000fe400078e0242ULL,
0x000000104f487825ULL, 0x000fe200078e0048ULL, 0x0000000044157faeULL, 0x0003e6000c901c48ULL,
0x0000001041417824ULL, 0x000fe200078e0242ULL, 0x0000000048177faeULL, 0x0003e2000d101c48ULL,
0x000000104f4a7825ULL, 0x000fc800078e004aULL, 0x000000104d4d7824ULL, 0x000fe200078e0242ULL,
0x000000004a417faeULL, 0x0003e2000d901c48ULL, 0x000000104f467825ULL, 0x000fc800078e0046ULL,
0x0000001051517824ULL, 0x000fe200078e0242ULL, 0x00000000464d7faeULL, 0x0003e2000e101c48ULL,
0x000000104f1c7825ULL, 0x000fc800078e001cULL, 0x0000001057537824ULL, 0x000fe200078e0242ULL,
0x000000001c517faeULL, 0x0003e2000e901c48ULL, 0x000000104f1e7825ULL, 0x000fca00078e001eULL,
0x000000001e537faeULL, 0x0003e2000f101c48ULL, 0x0000000c00207947ULL, 0x000fea0003800000ULL,
0x0000000c034d7811ULL, 0x042fe200078fe8ffULL, 0x00008a0000067ab9ULL, 0x000fe20000000a00ULL,
0x00000008034c7811ULL, 0x040fe400078fe8ffULL, 0x0000001c03457811ULL, 0x000fe200078fe8ffULL,
0x000000014d697824ULL, 0x100fe200078e0203ULL, 0x00000010034e7811ULL, 0x000fe200078fe8ffULL,
0x000000084d1e7824ULL, 0x000fe200078e00ffULL, 0x0000001803467811ULL, 0x040fe200078fe8ffULL,
0x000000014c6b7824ULL, 0x140fe200078e0203ULL, 0x0000002403477811ULL, 0x000fe200078fe8ffULL,
0x000000084c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e697812ULL, 0x000fe200078ee269ULL,
0x0000000145617824ULL, 0x100fe200078e0203ULL, 0x0000000403147811ULL, 0x000fe200078fe8ffULL,
0x00000008451e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c6b7812ULL, 0x000fe200078ee26bULL,
0x000000014e677824ULL, 0x140fe200078e0203ULL, 0x0000002003447811ULL, 0x040fe200078fe8ffULL,
0x000000084e407824ULL, 0x000fe200078e00ffULL, 0xfffffff81e617812ULL, 0x000fe200078ee261ULL,
0x0000000146637824ULL, 0x140fe200078e0203ULL, 0x00000028031e7811ULL, 0x000fe200078fe8ffULL,
0x00000008461c7824ULL, 0x000fe200078e00ffULL, 0xfffffff840677812ULL, 0x000fe200078ee267ULL,
0x00000001471d7824ULL, 0x100fe200078e0203ULL, 0x0000002c03407811ULL, 0x040fe200078fe8ffULL,
0x000000081e157824ULL, 0x040fe200078e00ffULL, 0xfffffff81c637812ULL, 0x000fe200078ee263ULL,
0x000000011e1c7824ULL, 0x100fe200078e0203ULL, 0x00000014034f7811ULL, 0x040fe200078fe8ffULL,
0x0000000140177824ULL, 0x140fe200078e0203ULL, 0x0000003803417811ULL, 0x000fe200078fe8ffULL,
0x00000008404a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8151c7812ULL, 0x000fe200078ee21cULL,
0x0000000847487824ULL, 0x000fe200078e00ffULL, 0x0000000403157211ULL, 0x000fe200078fe8ffULL,
0x00000001146d7824ULL, 0x140fe200078e0203ULL, 0xfffffff84a177812ULL, 0x000fe200078ee217ULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x00000012154a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000104157824ULL, 0x000fe200078e0214ULL, 0xfffffff8481d7812ULL, 0x000fe200078ee21dULL,
0x0000000144427824ULL, 0x140fe200078e0203ULL, 0xfffffff8166d7812ULL, 0x000fe200078ee26dULL,
0x0000000844137824ULL, 0x000fe200078e00ffULL, 0x0000001215487210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200008e06ffULL, 0x000000064a5e7c11ULL, 0x000fe2000f8240ffULL,
0x000000014f657824ULL, 0x040fe200078e0203ULL, 0xfffffff813427812ULL, 0x000fe200078ee242ULL,
0x000000084f167824ULL, 0x000fe200078e00ffULL, 0x0000003003137811ULL, 0x000fe200078fe8ffULL,
0x000000ffff497224ULL, 0x000fe200010e06ffULL, 0x00000006485c7c11ULL, 0x000fe2000f8440ffULL,
0x00000001044f7824ULL, 0x000fe200078e024fULL, 0x000000074a5f7c11ULL, 0x000fe200088f444bULL,
0x00000001044b7824ULL, 0x000fe200078e024eULL, 0xfffffff816657812ULL, 0x000fe200078ee265ULL,
0x0000000113167824ULL, 0x040fe200078e0203ULL, 0x00000007485d7c11ULL, 0x000fe200090f4449ULL,
0x00000008131f7824ULL, 0x000fe200078e00ffULL, 0x000000124f4a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000104497824ULL, 0x040fe200078e024cULL, 0x000000124b4c7210ULL, 0x000fe20007f9e0ffULL,
0x00000001044d7824ULL, 0x040fe200078e024dULL, 0xfffffff81f167812ULL, 0x000fe200078ee216ULL,
0x000000ffff4b7224ULL, 0x000fe200008e06ffULL, 0x00000034031f7811ULL, 0x000fe200078fe8ffULL,
0x0000000104477824ULL, 0x000fe200078e0247ULL, 0x000000124d4e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200020e06ffULL, 0x000000064c587c11ULL, 0x000fe2000f8840ffULL,
0x000000011f147824ULL, 0x140fe200078e0203ULL, 0x000000064a567c11ULL, 0x000fe2000f8240ffULL,
0x000000081f517824ULL, 0x000fe200078e00ffULL, 0x0000001249497210ULL, 0x000fe20007f5e0ffULL,
0x0000000141507824ULL, 0x040fe200078e0203ULL, 0x000000074c597c11ULL, 0x000fe2000a0f444dULL,
0x0000000841537824ULL, 0x000fe200078e00ffULL, 0x000000074a577c11ULL, 0x000fe200088f444bULL,
0x000000ffff4f7224ULL, 0x000fe200018e06ffULL, 0x000000064e5a7c11ULL, 0x000fe2000f8640ffULL,
0x0000000104457824ULL, 0x040fe200078e0245ULL, 0xfffffff851157812ULL, 0x000fe200078ee214ULL,
0x00000001044d7824ULL, 0x040fe200078e0244ULL, 0x0000001247447210ULL, 0x000fe20007f3e0ffULL,
0x00000001044b7824ULL, 0x000fe200078e0246ULL, 0xfffffff853147812ULL, 0x000fe200078ee250ULL,
0x000000ffff507224ULL, 0x000fe200010e06ffULL, 0x000000074e5b7c11ULL, 0x000fe200098f444fULL,
0x0000000104137824ULL, 0x000fe200078e0213ULL, 0x0000000649487c11ULL, 0x000fc4000f8440ffULL,
0x00000012454a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff457224ULL, 0x000fe200008e06ffULL,
0x000000124d467210ULL, 0x000fe40007f9e0ffULL, 0x00000006444e7c11ULL, 0x000fe4000f8240ffULL,
0x0000000749497c11ULL, 0x000fe200090f4450ULL, 0x000000ffff477224ULL, 0x000fe200020e06ffULL,
0x000000124b4c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200018e06ffULL,
0x0000000646507c11ULL, 0x000fc4000f8840ffULL, 0x00000007444f7c11ULL, 0x000fe200088f4445ULL,
0x0000000104457824ULL, 0x000fe200078e021eULL, 0x0000000746517c11ULL, 0x000fe2000a0f4447ULL,
0x000000ffff4d7224ULL, 0x000fe200010e06ffULL, 0x000000064c547c11ULL, 0x000fe2000f8440ffULL,
0x0000000104477824ULL, 0x000fe200078e0240ULL, 0x0000001245407210ULL, 0x000fe40007fde0ffULL,
0x000000064a527c11ULL, 0x000fe4000f8640ffULL, 0x0000003c03467811ULL, 0x040fe200078fe8ffULL,
0x000000ffff457224ULL, 0x000fe200030e06ffULL, 0x000000074c557c11ULL, 0x000fe200090f444dULL,
0x00000001044d7824ULL, 0x000fe200078e0241ULL, 0x000000074a537c11ULL, 0x000fe200098f444bULL,
0x00000001044b7824ULL, 0x000fe200078e021fULL, 0x00000006404c7c11ULL, 0x000fe2000f8c40ffULL,
0x00000001046f7824ULL, 0x000fe200078e0246ULL, 0x0000000303447211ULL, 0x000fc400078fe8ffULL,
0x00000012131f7210ULL, 0x000fe20007f9e0ffULL, 0x0000400034137824ULL, 0x000fe200078e0207ULL,
0x000000124d607210ULL, 0x000fe40007f5e0ffULL, 0x00000007404d7c11ULL, 0x000fe2000b0f4445ULL,
0x0000000811407824ULL, 0x000fe200078e00ffULL, 0x00000012471e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000146477824ULL, 0x040fe200078e0203ULL, 0x000000124b417210ULL, 0x000fe20007f3e0ffULL,
0x0000000846467824ULL, 0x000fe200078e00ffULL, 0x000000126f627210ULL, 0x000fe20007f7e0ffULL,
0x000020000c127824ULL, 0x000fe200078e0213ULL, 0x0000000744447812ULL, 0x000fe200078ec0ffULL,
0x000000ffff457224ULL, 0x000fe200028e06ffULL, 0xfffffff8406f7812ULL, 0x000fe200078ee203ULL,
0x0000200012127836ULL, 0x000fe20000000000ULL, 0x0ffffff844447812ULL, 0x000fe200078ef803ULL,
0x000000ffff667224ULL, 0x000fe200020e06ffULL, 0xfffffff846477812ULL, 0x000fe200078ee247ULL,
0x000000106f5e7825ULL, 0x000fe200078e005eULL, 0x000000061e4a7c11ULL, 0x000fc4000f8a40ffULL,
0x000000061f467c11ULL, 0x000fe2000f8840ffULL, 0x0000001044717824ULL, 0x100fe200078e0212ULL,
0x000000071e4b7c11ULL, 0x000fe2000a8f4445ULL, 0x000000106d6d7824ULL, 0x000fe400078e0212ULL,
0x000000106f5c7825ULL, 0x000fe200078e005cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005e717faeULL, 0x0003e6000b901c48ULL, 0x000000106b6b7824ULL, 0x000fe200078e0212ULL,
0x000000005c6d7faeULL, 0x0003e2000b901c48ULL, 0x000000106f487825ULL, 0x000fc800078e0048ULL,
0x0000001069697824ULL, 0x000fe200078e0212ULL, 0x00000000486b7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff647224ULL, 0x000fe200008e06ffULL, 0x0000000641447c11ULL, 0x000fe2000f8240ffULL,
0x000000106f5a7825ULL, 0x000fc600078e005aULL, 0x0000000741457c11ULL, 0x000fe200088f4464ULL,
0x0000001067677824ULL, 0x000fe200078e0212ULL, 0x000000005a697faeULL, 0x0003e2000b901c48ULL,
0x000000ffff757224ULL, 0x000fe200010e06ffULL, 0x0000000660407c11ULL, 0x000fe2000f8440ffULL,
0x000000106f587825ULL, 0x000fc600078e0058ULL, 0x0000000760417c11ULL, 0x000fe200090f4475ULL,
0x0000001065657824ULL, 0x100fe200078e0212ULL, 0x0000000058677faeULL, 0x0003e2000b901c48ULL,
0x0000001063637824ULL, 0x100fe400078e0212ULL, 0x0000001061617824ULL, 0x100fe400078e0212ULL,
0x0000001042427824ULL, 0x100fe400078e0212ULL, 0x000000101d1d7824ULL, 0x100fe400078e0212ULL,
0x000000101c1c7824ULL, 0x000fc400078e0212ULL, 0x0000001017177824ULL, 0x100fe400078e0212ULL,
0x0000001016167824ULL, 0x100fe400078e0212ULL, 0x0000001015157824ULL, 0x100fe400078e0212ULL,
0x0000001014147824ULL, 0x000fe400078e0212ULL, 0x000000ffff737224ULL, 0x000fe200018e06ffULL,
0x00000006621e7c11ULL, 0x000fe2000f8640ffULL, 0x000000106f567825ULL, 0x000fc800078e0056ULL,
0x0000001047127824ULL, 0x000fe200078e0212ULL, 0x000000071f477c11ULL, 0x000fe2000a0f4466ULL,
0x000000106f547825ULL, 0x040fe200078e0054ULL, 0x00000007621f7c11ULL, 0x000fe200098f4473ULL,
0x0000000056657faeULL, 0x0003e4000b901c48ULL, 0x000000106f527825ULL, 0x040fe400078e0052ULL,
0x0000000054637faeULL, 0x0003e4000b901c48ULL, 0x000000106f507825ULL, 0x000fc400078e0050ULL,
0x0000000052617faeULL, 0x0003e4000b901c48ULL, 0x000000106f4e7825ULL, 0x040fe400078e004eULL,
0x0000000050427faeULL, 0x0003e4000b901c48ULL, 0x000000106f4c7825ULL, 0x040fe400078e004cULL,
0x000000004e1d7faeULL, 0x0003e4000b901c48ULL, 0x000000106f4a7825ULL, 0x000fc400078e004aULL,
0x000000004c1c7faeULL, 0x0003e4000b901c48ULL, 0x000000106f467825ULL, 0x040fe400078e0046ULL,
0x000000004a177faeULL, 0x0003e4000b901c48ULL, 0x000000106f447825ULL, 0x040fe400078e0044ULL,
0x0000000046167faeULL, 0x0003e4000b901c48ULL, 0x000000106f407825ULL, 0x000fc400078e0040ULL,
0x0000000044157faeULL, 0x0003e4000b901c48ULL, 0x000000106f1e7825ULL, 0x000fe400078e001eULL,
0x0000000040147faeULL, 0x0003e8000b901c48ULL, 0x000000001e127faeULL, 0x0003e4000b901c48ULL,
0x000000ff1100720cULL, 0x000fda0003f25270ULL, 0x0000000000209947ULL, 0x000fea0003800000ULL,
0x0000000435357836ULL, 0x000fe40000000000ULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x000000063500720cULL, 0x000fda0003f26070ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x00008c00ff147b82ULL, 0x002e620000000a00ULL, 0x000000020e117824ULL, 0x000fc800078e0235ULL,
0x0000000411147825ULL, 0x002fca00078e0014ULL, 0x0000000814007981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002003127836ULL, 0x002fe20000000000ULL,
0x0000000703467812ULL, 0x040fe200078ec0ffULL, 0x0000200010407824ULL, 0x000fe200078e0213ULL,
0xfffffff803107812ULL, 0x000fe200078ec0ffULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ec0ffULL, 0x0000200040407836ULL, 0x000fe20000000000ULL,
0x0000000710417812ULL, 0x000fe400078ef803ULL, 0x0000000846427812ULL, 0x000fc400078ef803ULL,
0x0000000712457812ULL, 0x000fe200078ef803ULL, 0x000080400000791aULL, 0x000fcc0000000000ULL,
0x0000000141107824ULL, 0x140fe400078e0244ULL, 0x0000000841117824ULL, 0x000fe400078e00ffULL,
0x0000000145147824ULL, 0x140fe400078e0244ULL, 0x0000000845157824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee210ULL, 0x0000000843767824ULL, 0x000fe400078e0244ULL,
0x0000000845497824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x0000001011117824ULL, 0x000fc400078e0240ULL, 0x0000000276767824ULL, 0x000fe400078e00ffULL,
0x0000001015157824ULL, 0x000fe400078e0240ULL, 0x000000001110783bULL, 0x000e680000000200ULL,
0x000000001514783bULL, 0x000ea20000000200ULL, 0x00000018ff567819ULL, 0x002fe20000011410ULL,
0x00010000101c7824ULL, 0x040fe200078e00ffULL, 0x00008880105a7816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011411ULL,
0x00010000111d7824ULL, 0x040fe200078e00ffULL, 0x00008880115d7816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x00000018ff637819ULL, 0x000fc40000011412ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880125e7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe20000011413ULL, 0x00000010005f7306ULL, 0x0002e20000200c00ULL,
0x0000888013727816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff687819ULL, 0x004fe20000011414ULL,
0x00000011005c7306ULL, 0x0005e20000200c00ULL, 0x0001000012107824ULL, 0x002fe200078e00ffULL,
0x00008880146e7816ULL, 0x000fe200000000ffULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011415ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000013117824ULL, 0x044fe200078e00ffULL,
0x0000001c00777306ULL, 0x0003e20000200c00ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00008880156c7816ULL, 0x000fc400000000ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000001200747306ULL, 0x0005e20000200c00ULL,
0x00000008411c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011416ULL,
0x00000018ff477819ULL, 0x000fe40000011417ULL, 0x0000888016667816ULL, 0x000fc400000000ffULL,
0x0000001100737306ULL, 0x0003e20000200c00ULL, 0x0000000144127836ULL, 0x004fe20000000000ULL,
0x0000888017617816ULL, 0x000fe200000000ffULL, 0x0000000244447836ULL, 0x000fca0000000000ULL,
0x0000001300707306ULL, 0x0005e20000200c00ULL, 0x0000000141117824ULL, 0x102fe200078e0212ULL,
0x000000084400780cULL, 0x000fe20003f25270ULL, 0x0000000145127824ULL, 0x000fca00078e0212ULL,
0x0000001d00607306ULL, 0x0003e20000200c00ULL, 0xfffffff81c137812ULL, 0x004fe200078ee211ULL,
0x0001000015117824ULL, 0x040fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee212ULL,
0x0000010015157824ULL, 0x000fe400078e00ffULL, 0x0000001013137824ULL, 0x000fe200078e0240ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000001000757306ULL, 0x0005e20000200c00ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000000131c783bULL, 0x002e6a0000000200ULL,
0x00000015006a7306ULL, 0x000be20000200c00ULL, 0x0001000014107824ULL, 0x004fc400078e00ffULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x00000011006d7306ULL, 0x0005e20000200c00ULL,
0x0000007603157211ULL, 0x020fe200078fe0ffULL, 0x0000000276767836ULL, 0x000fc80000000000ULL,
0x0000000142157824ULL, 0x000fe400078e0215ULL, 0x00000014006f7306ULL, 0x000be20000200c00ULL,
0x0000001049117824ULL, 0x004fce00078e0240ULL, 0x0000001000717306ULL, 0x0005e20000200c00ULL,
0x0001000017147824ULL, 0x060fe400078e00ffULL, 0x0000010017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0001000016107824ULL, 0x044fe200078e00ffULL, 0x0000001400647306ULL, 0x0005e20000200c00ULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x002fe4000001141cULL,
0x000088801c4a7816ULL, 0x000fe400000000ffULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x0000001700627306ULL, 0x000fe20000200c00ULL, 0x000100001c147824ULL, 0x044fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011410ULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x000000001110783bULL, 0x000e620000000200ULL, 0x00000018ff507819ULL, 0x000fe4000001141dULL,
0x00000018ff517819ULL, 0x000fe20000011414ULL, 0x0000002042147824ULL, 0x000fe200078e00ffULL,
0x0000001600697306ULL, 0x0005e20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x000088801d527816ULL, 0x040fe400000000ffULL, 0xffffffe014147812ULL, 0x000fe200078ee215ULL,
0x000100001d157824ULL, 0x040fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001141eULL,
0x0000005a005a7306ULL, 0x000f620000200c00ULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x000088801e547816ULL, 0x000fe200000000ffULL, 0x0000001014147824ULL, 0x000fe200078e0207ULL,
0x00000018ff577819ULL, 0x000fe40000011415ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x0000001c00537306ULL, 0x0007e20000200c00ULL, 0x000000001414783bULL, 0x004ea20000000200ULL,
0x00000018ff4e7819ULL, 0x000fcc000001141fULL, 0x0000001d00557306ULL, 0x000be20000200c00ULL,
0x000100001e1c7824ULL, 0x048fe400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x000054105f1d7816ULL, 0x020fe40000000056ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff4d7819ULL, 0x002fe40000011410ULL, 0x00000018ff4c7819ULL, 0x000fe20000011411ULL,
0x0000001c00597306ULL, 0x0003e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fc40000011412ULL,
0x00000018ff497819ULL, 0x000fca0000011413ULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000054105a1c7816ULL, 0x002fe40000000077ULL, 0x000088801f5a7816ULL, 0x000fca00000000ffULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000001c143c723cULL, 0x004fee000000183cULL,
0x000100001f1d7824ULL, 0x000fe200078e00ffULL, 0x000054105d1c7816ULL, 0x008fe20000000060ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x000001001f1f7824ULL, 0x000fc400078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc6000001141dULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001d005f7306ULL, 0x0005f00000200c00ULL, 0x0000001e00567306ULL, 0x0007e20000200c00ULL,
0x000054105c1d7816ULL, 0x004fe2000000005bULL, 0x00010000105c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000001c1438723cULL, 0x000fe20000001838ULL,
0x00008880101e7816ULL, 0x048fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x0000006700677306ULL, 0x000ea80000200c00ULL, 0x00000076031d7211ULL, 0x000fe400078fe0ffULL,
0x00000018ff607819ULL, 0x000fe20000011410ULL, 0x0000002042107824ULL, 0x040fe200078e00ffULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x00000001421d7824ULL, 0x000fe200078e021dULL,
0x000054105e1c7816ULL, 0x002fc40000000075ULL, 0x0000888011767816ULL, 0x040fe400000000ffULL,
0xffffffe010107812ULL, 0x000fe400078ee21dULL, 0x00005410741d7816ULL, 0x000fe20000000063ULL,
0x0000001e005b7306ULL, 0x0003e20000200c00ULL, 0x0000010011747824ULL, 0x000fe400078e00ffULL,
0x0000001010107824ULL, 0x000fc600078e0207ULL, 0x0000001c1430723cULL, 0x000fe40000001830ULL,
0x0000006e006e7306ULL, 0x000f620000200c00ULL, 0x00010000111e7824ULL, 0x002fe200078e00ffULL,
0x0000541070117816ULL, 0x004fe40000000067ULL, 0x00000018ff677819ULL, 0x000fe40000011474ULL,
0x00000018ff637819ULL, 0x000fe4000001141eULL, 0x0000001f005d7306ULL, 0x0003f00000200c00ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x00000000101c783bULL, 0x00266e0000000200ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541072107816ULL, 0x008fce0000000073ULL,
0x0000006c006c7306ULL, 0x000ee20000200c00ULL, 0x00000010142c723cULL, 0x000fee000000182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000054106e107816ULL, 0x020fc60000000071ULL, 0x000000ffff6e7224ULL, 0x000fe200078e0011ULL,
0x000054106f117816ULL, 0x004fe20000000068ULL, 0x00010000126f7824ULL, 0x040fe400078e00ffULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000010012127824ULL, 0x000fc600078e00ffULL,
0x000000101428723cULL, 0x000fe40000001828ULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x0000006b006b7306ULL, 0x000ea60000200c00ULL, 0x000054106c107816ULL, 0x008fe4000000006dULL,
0x000054106a117816ULL, 0x000fe40000000065ULL, 0x00000018ff657819ULL, 0x000fe2000001146fULL,
0x0000004700477306ULL, 0x000fe80000200c00ULL, 0x000000101424723cULL, 0x000fe80000001824ULL,
0x0000006100617306ULL, 0x000ee60000200c00ULL, 0x0000541066107816ULL, 0x004fc4000000006bULL,
0x0000541069117816ULL, 0x000fe40000000058ULL, 0x0000888013587816ULL, 0x000fe200000000ffULL,
0x0000004800487306ULL, 0x000fe80000200c00ULL, 0x000000101420723cULL, 0x000fe80000001820ULL,
0x0000004a004a7306ULL, 0x000fe60000200c00ULL, 0x0000541061107816ULL, 0x008fc40000000064ULL,
0x0000541062117816ULL, 0x000fe20000000047ULL, 0x000000ffff477224ULL, 0x000fe400078e0058ULL,
0x0000005100517306ULL, 0x000ea80000200c00ULL, 0x000000101418723cULL, 0x000fe80000001818ULL,
0x0000005000507306ULL, 0x000ee60000200c00ULL, 0x0001000013117824ULL, 0x000fc400078e00ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x000054104a107816ULL, 0x004fe40000000051ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x00000018ff157819ULL, 0x000fe40000011411ULL,
0x0000541053117816ULL, 0x000fe40000000048ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000541055537816ULL, 0x008fe20000000050ULL, 0x0000005a005a7306ULL, 0x000ee40000200c00ULL,
0x000000101c3c723cULL, 0x002fe2000000183cULL, 0x000054105d177816ULL, 0x004fca000000004eULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000054105a167816ULL, 0x008fce000000005fULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x000000161c2c723cULL, 0x000fe2000000182cULL,
0x0000541056557816ULL, 0x002fcc000000004fULL, 0x0000004c004c7306ULL, 0x000ff00000200c00ULL,
0x0000004b004b7306ULL, 0x000ff00000200c00ULL, 0x0000004900497306ULL, 0x000ff00000200c00ULL,
0x0000005200527306ULL, 0x000ff00000200c00ULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000541052527816ULL, 0x002fce0000000057ULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x000000521c38723cULL, 0x000fe20000001838ULL,
0x0000541054547816ULL, 0x004fcc0000000059ULL, 0x0000006000607306ULL, 0x000ea20000200c00ULL,
0x000000541c30723cULL, 0x000fe20000001830ULL, 0x000054105b5c7816ULL, 0x002fcc000000005cULL,
0x00000076005e7306ULL, 0x000fe20000200c00ULL, 0x00005410605d7816ULL, 0x004fce000000004dULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x0000005c1c28723cULL, 0x000fee0000001828ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054105e5e7816ULL, 0x002fce0000000063ULL,
0x0000006e00687306ULL, 0x000fe20000200c00ULL, 0x00005410675f7816ULL, 0x004fce000000004cULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x0000005e1c24723cULL, 0x000fee0000001824ULL,
0x0000001200127306ULL, 0x000ea20000200c00ULL, 0x00005410684a7816ULL, 0x002fce0000000065ULL,
0x0000004700147306ULL, 0x000fe20000200c00ULL, 0x00005410124b7816ULL, 0x004fce000000004bULL,
0x0000001500117306ULL, 0x000e620000200c00ULL, 0x0000004a1c20723cULL, 0x000fee0000001820ULL,
0x0000001300107306ULL, 0x000ea20000200c00ULL, 0x0000541014147816ULL, 0x002fe40000000011ULL,
0x0000541010157816ULL, 0x004fce0000000049ULL, 0x000000141c18723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff000181947ULL, 0x000fde000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0xffffffd000f88947ULL, 0x000fec000383ffffULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x0000000824147220ULL, 0x080fe20000410000ULL,
0x0000000821177220ULL, 0x080fe20000410000ULL, 0x000000083c157220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x000000083e3e7220ULL, 0x080fe20000410000ULL,
0x01868810091079a7ULL, 0x000262000850003fULL, 0x000000083f3f7220ULL, 0x080fe20000410000ULL,
0x0000000838387220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x000000083a3a7220ULL, 0x080fe20000410000ULL, 0x000000083b3b7220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000832327220ULL, 0x080fe20000410000ULL, 0x0000000833337220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x000000082e2e7220ULL, 0x080fe20000410000ULL, 0x000000082f2f7220ULL, 0x080fe20000410000ULL,
0x0000000828287220ULL, 0x080fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000082a2a7220ULL, 0x080fe20000410000ULL, 0x000000082b2b7220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000826267220ULL, 0x080fe20000410000ULL,
0x0000000827277220ULL, 0x080fe20000410000ULL, 0x0000000820167220ULL, 0x080fe20000410000ULL,
0x0000000822227220ULL, 0x080fe20000410000ULL, 0x0000000823237220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x000000081a217220ULL, 0x080fe20000410000ULL, 0x000000081b247220ULL, 0x002fce0000410000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x01868811090075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a121d7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e13ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001d1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01868811090075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000403107824ULL, 0x000fe200078e00ffULL, 0x0000000a0d00720cULL, 0x000fe20003f05270ULL,
0x0000008034207824ULL, 0x000fc600078e0207ULL, 0xfffffff010117812ULL, 0x000fca00078ec0ffULL,
0x0000000120207824ULL, 0x000fca00078e0211ULL, 0x0184000020107984ULL, 0x0002a20000000c00ULL,
0x0000000400080947ULL, 0x000fea0003800000ULL, 0x00000002031a7824ULL, 0x000fe400078e00ffULL,
0x000000010f367824ULL, 0x000fc600078e0a36ULL, 0x000000061a1b7812ULL, 0x000fc800078ec0ffULL,
0x000000011b1d7812ULL, 0x040fe400078efcffULL, 0x000000081b1f7812ULL, 0x000fe400078efcffULL,
0x000000361d00720cULL, 0x080fe40003f26070ULL, 0x000000101b1d7812ULL, 0x000fe400078efcffULL,
0x000000361f00720cULL, 0x080fe40003f06070ULL, 0x000000361d00720cULL, 0x000fc40003fc6070ULL,
0x000000111b1f7812ULL, 0x040fe400078efcffULL, 0x000000181b1d7812ULL, 0x040fe400078efcffULL,
0x000000361b00720cULL, 0x080fe40003f46070ULL, 0x000000361f00720cULL, 0x080fe40003fa6070ULL,
0x000000361d00720cULL, 0x000fe40003f66070ULL, 0x000000091b377812ULL, 0x000fc400078efcffULL,
0x000000191b1f7812ULL, 0x040fe400078efcffULL, 0x000000201b1d7812ULL, 0x000fe400078efcffULL,
0xff8000003e3e7808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40005000000ULL,
0xff8000003f3f7808ULL, 0x000fe40004800000ULL, 0xff8000003d3d7808ULL, 0x000fc40004800000ULL,
0x000000363700720cULL, 0x080fe40003f86070ULL, 0x000000361f00720cULL, 0x080fe40003f46070ULL,
0x000000361d00720cULL, 0x000fe40003f26070ULL, 0x000000211b1f7812ULL, 0x040fe400078efcffULL,
0x000000281b1d7812ULL, 0x000fe400078efcffULL, 0xff8000003a3a7808ULL, 0x000fc40004000000ULL,
0xff80000038387808ULL, 0x000fe40004000000ULL, 0xff8000003b3b7808ULL, 0x000fe40006000000ULL,
0xff80000039397808ULL, 0x000fe40006000000ULL, 0x000000361f00720cULL, 0x080fe40003f06070ULL,
0x000000361d00720cULL, 0x000fe40003f86070ULL, 0x000000291b1f7812ULL, 0x000fc400078efcffULL,
0x000000301b1d7812ULL, 0x000fe400078efcffULL, 0xff80000032327808ULL, 0x000fe40007000000ULL,
0xff80000030307808ULL, 0x000fe40007000000ULL, 0xff80000033337808ULL, 0x000fe40006800000ULL,
0xff80000031317808ULL, 0x000fe40006800000ULL, 0x000000361f00720cULL, 0x000fc40003fc6070ULL,
0x000000361d00720cULL, 0x000fe40003fa6070ULL, 0x000000311b1f7812ULL, 0x040fe400078efcffULL,
0x000000381b1d7812ULL, 0x040fe400078efcffULL, 0x000000391b1b7812ULL, 0x000fe400078efcffULL,
0xff8000002e2e7808ULL, 0x000fe40005800000ULL, 0xff8000002c2c7808ULL, 0x000fc40005800000ULL,
0xff8000002f2f7808ULL, 0x000fe40005000000ULL, 0xff8000002d2d7808ULL, 0x000fe40005000000ULL,
0xff8000002a2a7808ULL, 0x000fe40004800000ULL, 0xff80000028287808ULL, 0x000fe40004800000ULL,
0x000000361f00720cULL, 0x080fe40003f66070ULL, 0x000000361d00720cULL, 0x000fc40003f46070ULL,
0x000000361b00720cULL, 0x000fe40003f26070ULL, 0xff8000002b2b7808ULL, 0x000fe40004000000ULL,
0xff80000029297808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff80000014147808ULL, 0x000fe40006000000ULL, 0xff80000027277808ULL, 0x000fc40007000000ULL,
0xff80000025257808ULL, 0x000fe40007000000ULL, 0xff80000022227808ULL, 0x000fe40006800000ULL,
0xff80000016167808ULL, 0x000fe40006800000ULL, 0xff80000023237808ULL, 0x000fe40005800000ULL,
0xff80000017177808ULL, 0x000fe40005800000ULL, 0xff80000021217808ULL, 0x000fc40005000000ULL,
0xff80000018187808ULL, 0x000fe40005000000ULL, 0xff80000024247808ULL, 0x000fe40004800000ULL,
0xff80000019197808ULL, 0x000fce0004800000ULL, 0x000000151000720bULL, 0x004fe20003f1e000ULL,
0x000000010d0d7836ULL, 0x000fe20000000000ULL, 0xfffffff8ff467812ULL, 0x000fe400078ee246ULL,
0x0000001015107208ULL, 0x000fc80004000000ULL, 0x0000003d1000720bULL, 0x000fc80003f1e000ULL,
0x000000103d1b7208ULL, 0x000fc80004000000ULL, 0x000000381b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b38107208ULL, 0x000fc80004000000ULL, 0x000000391000720bULL, 0x000fc80003f1e000ULL,
0x00000010391b7208ULL, 0x000fc80004000000ULL, 0x000000301b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b30107208ULL, 0x000fc80004000000ULL, 0x000000311000720bULL, 0x000fc80003f1e000ULL,
0x00000010311b7208ULL, 0x000fc80004000000ULL, 0x0000002c1b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b2c107208ULL, 0x000fc80004000000ULL, 0x0000002d1000720bULL, 0x000fc80003f1e000ULL,
0x000000102d1b7208ULL, 0x000fc80004000000ULL, 0x000000281b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b28107208ULL, 0x000fc80004000000ULL, 0x000000291000720bULL, 0x000fc80003f1e000ULL,
0x00000010291b7208ULL, 0x000fc80004000000ULL, 0x000000141b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b14107208ULL, 0x000fe40004000000ULL, 0x0000003e1100720bULL, 0x000fe40003f1e000ULL,
0x000000251000720bULL, 0x000fc80003f3e000ULL, 0x00000010251b7208ULL, 0x000fe40004800000ULL,
0x000000113e107208ULL, 0x000fe40004000000ULL, 0x000000161b00720bULL, 0x000fe40003f3e000ULL,
0x0000003f1000720bULL, 0x000fe40003f1e000ULL, 0x0000001b161a7208ULL, 0x000fe40004800000ULL,
0x000000103f117208ULL, 0x000fc40004000000ULL, 0x000000171a00720bULL, 0x000fe40003f3e000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x0000001a171b7208ULL, 0x000fe40004800000ULL,
0x000000113a107208ULL, 0x000fe40004000000ULL, 0x000000181b00720bULL, 0x000fe40003f3e000ULL,
0x0000003b1000720bULL, 0x000fc40003f1e000ULL, 0x0000001b181a7208ULL, 0x000fe40004800000ULL,
0x000000103b117208ULL, 0x000fe40004000000ULL, 0x000000191a00720bULL, 0x000fe40003f3e000ULL,
0x000000321100720bULL, 0x000fe40003f1e000ULL, 0x0000001a191a7208ULL, 0x000fe40004800000ULL,
0x0000001132107208ULL, 0x000fc60004000000ULL, 0x0c401f001a1b7f89ULL, 0x000ea200000e0000ULL,
0x000000331000720bULL, 0x000fc80003f1e000ULL, 0x0000001033117208ULL, 0x000fc80004000000ULL,
0x0000002e1100720bULL, 0x000fc80003f1e000ULL, 0x000000112e107208ULL, 0x000fc80004000000ULL,
0x0000002f1000720bULL, 0x000fc80003f1e000ULL, 0x000000102f117208ULL, 0x000fe40004000000ULL,
0x0000001b1a00720bULL, 0x004fe40003f3e000ULL, 0x0000002a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001a1b1b7208ULL, 0x000fe40004800000ULL, 0x000000112a107208ULL, 0x000fc60004000000ULL,
0x0c201f001b1a7f89ULL, 0x000ea200000e0000ULL, 0x0000002b1000720bULL, 0x000fc80003f1e000ULL,
0x000000102b117208ULL, 0x000fc80004000000ULL, 0x000000261100720bULL, 0x000fc80003f1e000ULL,
0x0000001126107208ULL, 0x000fc80004000000ULL, 0x000000271000720bULL, 0x000fc80003f1e000ULL,
0x0000001027117208ULL, 0x000fe40004000000ULL, 0x0000001a1b00720bULL, 0x004fe40003f3e000ULL,
0x000000221100720bULL, 0x000fe40003f1e000ULL, 0x0000001b1a107208ULL, 0x000fe40004800000ULL,
0x00000011221a7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b101c7820ULL, 0x000fe20000410000ULL,
0x000000231a00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL,
0x0000001a231a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001081cULL,
0x000000211a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe2000001081cULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x0000001a21117208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081cULL,
0x000000241100720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001081cULL, 0x0000003d001e7308ULL, 0x000ea20000000800ULL,
0x0000001124117208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001081cULL, 0x0c401f00111a7f89ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b25257823ULL, 0x000fe2000001081cULL, 0x0000001700427308ULL, 0x000ff00000000800ULL,
0x0000001800437308ULL, 0x000ff00000000800ULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x0000001a1100720bULL, 0x008fce0003f1e000ULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x000000111a117208ULL, 0x000fca0004000000ULL, 0x0c201f00111a7f89ULL, 0x000ee400000e0000ULL,
0x00000014003d7308ULL, 0x0005f00000000800ULL, 0x0000002c001b7308ULL, 0x000be20000000800ULL,
0x000000151e14723eULL, 0x004fce00000000ffULL, 0x0000002d00367308ULL, 0x0004a20000000800ULL,
0x3c003c00ff2c7424ULL, 0x022fe200078e00ffULL, 0x0000001a1100720bULL, 0x008fcc0003f1e000ULL,
0x0000001600417308ULL, 0x0003e20000000800ULL, 0x3c003c00ff2d7424ULL, 0x004fe200078e00ffULL,
0x000000111a117208ULL, 0x000fe40004000000ULL, 0x0000001b361a723eULL, 0x000fc600000000ffULL,
0x3fb8aa3b11457820ULL, 0x000fe20000410000ULL, 0x000000383916723eULL, 0x002fe200000000ffULL,
0x0000001900447308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010845ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010845ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010845ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010845ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010845ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010845ULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010845ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010845ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010845ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010845ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010845ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010845ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010845ULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b21217823ULL, 0x000fce0000010845ULL, 0x0000003a00177308ULL, 0x000fe20000000800ULL,
0x0000003e3f15723eULL, 0x002fce00000000ffULL, 0x0000003b00187308ULL, 0x000e700000000800ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000171817723eULL, 0x002fce00000000ffULL,
0x0000003100317308ULL, 0x000e620000000800ULL, 0x0000002c141c723cULL, 0x000fee00000018ffULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x000000303118723eULL, 0x002fce00000000ffULL,
0x0000003300197308ULL, 0x000e620000000800ULL, 0x0000000846317824ULL, 0x000fce00078e00ffULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000321919723eULL, 0x002fce00000000ffULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x000000ffff3a7224ULL, 0x000fce00078e0019ULL,
0x0000002800377308ULL, 0x0005e20000000800ULL, 0x0000002e2f1b723eULL, 0x002fce00000000ffULL,
0x0000002500407308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b26287823ULL, 0x104fe20000010845ULL,
0x3fb8aa3b24457823ULL, 0x000fe20000010845ULL, 0x0c401f0013267f89ULL, 0x000ea200000e0000ULL,
0x000000414224723eULL, 0x000fe200000000ffULL, 0x000000ffff3b7224ULL, 0x000fc600078e001bULL,
0x00000029003c7308ULL, 0x000ee20000000800ULL, 0x0c401f0012257f89ULL, 0x002e6e00000e0000ULL,
0x0000002a00337308ULL, 0x000ff00000000800ULL, 0x0000002b00387308ULL, 0x000f620000000800ULL,
0x000000261300720bULL, 0x004fc80003f3e000ULL, 0x0000001326137208ULL, 0x000fc60004800000ULL,
0x0000002800397308ULL, 0x0005e20000000800ULL, 0x000000251200720bULL, 0x002fe40003f1e000ULL,
0x000000434426723eULL, 0x000fe400000000ffULL, 0x0000001225127208ULL, 0x000fc60004000000ULL,
0x0000002700307308ULL, 0x000e620000000800ULL, 0x0000002c1828723cULL, 0x004fee000000181cULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x000000373c1c723eULL, 0x008fe400000000ffULL,
0x0000003d401e723eULL, 0x000fc400000000ffULL, 0x00000033381d723eULL, 0x020fe200000000ffULL,
0x000000ffff387224ULL, 0x000fe200078e0015ULL, 0x00000039301f723eULL, 0x002fe200000000ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000080034307824ULL, 0x000fe400078e0207ULL,
0x000000ffff397224ULL, 0x000fe400078e0017ULL, 0x0001200030367836ULL, 0x000fe40000000000ULL,
0x000000ffff307224ULL, 0x000fe200078e001cULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x0000002c1c28723cULL, 0x000fec0000001828ULL, 0x000000ffff197224ULL, 0x000fe200078e001fULL,
0x000000222325723eULL, 0x002fe200000000ffULL, 0x00000045002e7308ULL, 0x000e620000000800ULL,
0x00000003ff227819ULL, 0x000fe20000011603ULL, 0x0000000846237824ULL, 0x000fe200078e00ffULL,
0x000000212e27723eULL, 0x002fe200000000ffULL, 0x00000008462e7836ULL, 0x000fe20000000000ULL,
0x0000000322217812ULL, 0x000fc400078ec0ffULL, 0x0c201f0013227f89ULL, 0x000e6200000e0000ULL,
0x000000082e327824ULL, 0x000fe400078e00ffULL, 0x0000000121467824ULL, 0x000fcc00078e0246ULL,
0x0000002c2428723cULL, 0x000fe20000001828ULL, 0x00000001212f7824ULL, 0x000fe400078e022eULL,
0x0c201f0012217f89ULL, 0x000ea200000e0000ULL, 0x000000082e337824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee246ULL, 0x00000004462e7836ULL, 0x000fe20000000000ULL,
0xfffffff8322f7812ULL, 0x000fe200078ee22fULL, 0x0000000c46467836ULL, 0x000fe40000000000ULL,
0x0000001023237824ULL, 0x000fe200078e0236ULL, 0xfffffff8312e7812ULL, 0x000fe200078ee22eULL,
0x000000ffff2c7224ULL, 0x000fe200078e0014ULL, 0xfffffff833467812ULL, 0x000fe200078ee246ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0016ULL, 0x000000ffff317224ULL, 0x000fe400078e001eULL,
0x000000ffff327224ULL, 0x000fe400078e0024ULL, 0x000000102f2b7824ULL, 0x100fe200078e0236ULL,
0x000000221300720bULL, 0x002fe20003f3e000ULL, 0x000000102e297824ULL, 0x000fe400078e0236ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0018ULL, 0x0000001322137208ULL, 0x000fe20004800000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e001aULL, 0x000000211200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x000fc400078e0026ULL, 0x0000001046467824ULL, 0x000fe200078e0236ULL,
0x0000001221127208ULL, 0x000fe20004000000ULL, 0x0000002c23007844ULL, 0x000fe20000000200ULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff187224ULL, 0x000fe400078e001dULL,
0x0000003029007844ULL, 0x0003e20000000200ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0027ULL, 0x000000382b007844ULL, 0x0005e20000000200ULL,
0x00000001ff147424ULL, 0x000fc600078e00ffULL, 0x0000001846007844ULL, 0x0005e80000000200ULL,
0x0180001020008388ULL, 0x0005e20000000c00ULL, 0x000000ffff297224ULL, 0x002fca00078e002aULL,
0x0182002820008388ULL, 0x0005e20000000a00ULL, 0x000000050d00720cULL, 0x000fe20003f06070ULL,
0x018608140bff79a7ULL, 0x0005e2000850003fULL, 0x018610140bff79a7ULL, 0x0005e2000850003fULL,
0x018618140bff79a7ULL, 0x0005e2000850003fULL, 0x018620140bff79a7ULL, 0x0005f2000850003fULL,
0xffffffb800f88947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000002007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000200008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff02ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000002027812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x006fe400078e0005ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffe8002487950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000562ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000006e0ULL, 0x0000000000000240ULL, 0x0000001600000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000920ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a00ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a54ULL, 0x0000000000000828ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000012c8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001300ULL, 0x0000000000017f80ULL, 0x0000001600000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019280ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000192d0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000192d0ULL, 0x0000000000000260ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000198b0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000198b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000012c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017f80ULL,
0x0000000000017f80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000192d0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 104960;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
