/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_e4m3_pagedKV_128_nqpkv_1_m_1_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b0c8ULL, 0x000000000001ad48ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL, 0x326a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45346aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x5f24000000000000ULL,
0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL, 0x5f6e725f7063725fULL,
0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL, 0x656e72656b2e7478ULL,
0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x72656b240061686dULL,
0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL, 0x656d6172665f6775ULL,
0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL, 0x72665f6775626564ULL,
0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x0000000061686d5fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000036eULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000003b5ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000403ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000448ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000004a3ULL, 0x0000000000019300ULL, 0x0000000000000280ULL, 0x0004000300000519ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000019580ULL, 0x000d000300000549ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001930000000000ULL, 0x0000700400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL, 0x0001930000000000ULL,
0x0000028000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000001600082f04ULL, 0x0008230400000073ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL, 0x000c17040021f000ULL,
0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL, 0x000c17040061f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x00c82804ffffffffULL, 0x00000100000000b0ULL, 0x0000330000000780ULL,
0x0000343000003370ULL, 0x0000382000003570ULL, 0x0000541000003830ULL, 0x0000733000005420ULL,
0x00007450000073a0ULL, 0x0000775000007580ULL, 0x0000919000007760ULL, 0x0000afd0000091a0ULL,
0x0000b0f00000b040ULL, 0x0000b3f00000b220ULL, 0x0000ce300000b400ULL, 0x0000ec700000ce40ULL,
0x0000ed900000ece0ULL, 0x0000f0900000eec0ULL, 0x00010ad00000f0a0ULL, 0x000114c000010ae0ULL,
0x00011c10000114d0ULL, 0x0001439000011f80ULL, 0x0001702000014dc0ULL, 0x0001870000018540ULL,
0x00018890000187e0ULL, 0x00018b1000018aa0ULL, 0x00018dd000018b90ULL, 0x0000021007d03904ULL,
0x00018ad0000000ffULL, 0x000002f000040100ULL, 0x00018ad800000008ULL, 0x00000400003f0100ULL,
0x00018b5800000008ULL, 0x00000520003f0100ULL, 0x00018b7800000003ULL, 0x00000610003f0100ULL,
0x00018b88000000ffULL, 0x000008f000040100ULL, 0x00018ad0000000ffULL, 0x00000b7000070107ULL,
0x00018b580000005dULL, 0x00000bb000070101ULL, 0x00018b88000000ffULL, 0x00000be000070101ULL,
0x00018b88000000ffULL, 0x00000d5000070109ULL, 0x00018b88000000ffULL, 0x000017d000070109ULL,
0x00018b88000000ffULL, 0x0000180000070101ULL, 0x00018b88000000ffULL, 0x0000197000070109ULL,
0x00018b88000000ffULL, 0x00001ad000070109ULL, 0x00018b78000000ffULL, 0x00001b1000070107ULL,
0x00018b78000000ffULL, 0x00001b9000070101ULL, 0x00018b88000000ffULL, 0x00001d9000070101ULL,
0x00018b78000000ffULL, 0x00001f0000070109ULL, 0x00018b78000000ffULL, 0x00001f3000070109ULL,
0x00018b88000000ffULL, 0x000020a000070109ULL, 0x00018b88000000ffULL, 0x00002b2000070109ULL,
0x00018b88000000ffULL, 0x00002b5000070101ULL, 0x00018b88000000ffULL, 0x00002cc000070109ULL,
0x00018b88000000ffULL, 0x0000305000070109ULL, 0x00018b80000000ffULL, 0x0000309000070107ULL,
0x00018b80000000ffULL, 0x000030b000070101ULL, 0x00018ad80000005dULL, 0x000030e000070101ULL,
0x00018ad80000005dULL, 0x0000325000070109ULL, 0x00018ad80000005dULL, 0x000041b000070109ULL,
0x00018b88000000ffULL, 0x0000426000070101ULL, 0x00018b80000000ffULL, 0x000043d000070109ULL,
0x00018b80000000ffULL, 0x0000440000070109ULL, 0x00018b88000000ffULL, 0x0000457000070109ULL,
0x00018b88000000ffULL, 0x00004fe000070109ULL, 0x00018b88000000ffULL, 0x0000501000070101ULL,
0x00018b88000000ffULL, 0x0000518000070109ULL, 0x00018b88000000ffULL, 0x0000537000070109ULL,
0x00000000000000ffULL, 0x000053d000080107ULL, 0x00018b78000000ffULL, 0x00005cc000070101ULL,
0x00018b88000000ffULL, 0x00005d1000070101ULL, 0x00018b58000000ffULL, 0x00005de000070101ULL,
0x00018b78000000ffULL, 0x00005f5000070109ULL, 0x00018b78000000ffULL, 0x00005f8000070109ULL,
0x00018b88000000ffULL, 0x000060f000070109ULL, 0x00018b88000000ffULL, 0x00006b7000070109ULL,
0x00018b88000000ffULL, 0x00006ba000070101ULL, 0x00018b88000000ffULL, 0x00006d1000070109ULL,
0x00018b88000000ffULL, 0x0000707000070109ULL, 0x00000000000000ffULL, 0x000070a0000d0107ULL,
0x00018b80000000ffULL, 0x000070e000070101ULL, 0x00018af80000005dULL, 0x0000711000070101ULL,
0x00018af80000005dULL, 0x0000728000070109ULL, 0x00018af80000005dULL, 0x00007f7000070109ULL,
0x00018b88000000ffULL, 0x0000804000070101ULL, 0x00018b80000000ffULL, 0x000081b000070109ULL,
0x00018b80000000ffULL, 0x000081e000070109ULL, 0x00018b88000000ffULL, 0x0000835000070109ULL,
0x00018b88000000ffULL, 0x00008dc000070109ULL, 0x00018b88000000ffULL, 0x00008df000070101ULL,
0x00018b88000000ffULL, 0x00008f6000070109ULL, 0x00018b88000000ffULL, 0x0000912000070109ULL,
0x00000000000000ffULL, 0x0000915000080107ULL, 0x00018b78000000ffULL, 0x0000997000070101ULL,
0x00018b88000000ffULL, 0x000099b000070101ULL, 0x00018b60000000ffULL, 0x00009a8000070101ULL,
0x00018b78000000ffULL, 0x00009bf000070109ULL, 0x00018b78000000ffULL, 0x00009c2000070109ULL,
0x00018b88000000ffULL, 0x00009d9000070109ULL, 0x00018b88000000ffULL, 0x0000a81000070109ULL,
0x00018b88000000ffULL, 0x0000a84000070101ULL, 0x00018b88000000ffULL, 0x0000a9b000070109ULL,
0x00018b88000000ffULL, 0x0000ad1000070109ULL, 0x00000000000000ffULL, 0x0000ad40000d0107ULL,
0x00018b80000000ffULL, 0x0000ad8000070101ULL, 0x00018b180000005dULL, 0x0000adb000070101ULL,
0x00018b180000005dULL, 0x0000af2000070109ULL, 0x00018b180000005dULL, 0x0000bc1000070109ULL,
0x00018b88000000ffULL, 0x0000bce000070101ULL, 0x00018b80000000ffULL, 0x0000be5000070109ULL,
0x00018b80000000ffULL, 0x0000be8000070109ULL, 0x00018b88000000ffULL, 0x0000bff000070109ULL,
0x00018b88000000ffULL, 0x0000ca6000070109ULL, 0x00018b88000000ffULL, 0x0000ca9000070101ULL,
0x00018b88000000ffULL, 0x0000cc0000070109ULL, 0x00018b88000000ffULL, 0x0000cdc000070109ULL,
0x00000000000000ffULL, 0x0000cdf000080107ULL, 0x00018b78000000ffULL, 0x0000d61000070101ULL,
0x00018b88000000ffULL, 0x0000d65000070101ULL, 0x00018b68000000ffULL, 0x0000d72000070101ULL,
0x00018b78000000ffULL, 0x0000d89000070109ULL, 0x00018b78000000ffULL, 0x0000d8c000070109ULL,
0x00018b88000000ffULL, 0x0000da3000070109ULL, 0x00018b88000000ffULL, 0x0000e4b000070109ULL,
0x00018b88000000ffULL, 0x0000e4e000070101ULL, 0x00018b88000000ffULL, 0x0000e65000070109ULL,
0x00018b88000000ffULL, 0x0000e9b000070109ULL, 0x00000000000000ffULL, 0x0000e9e0000d0107ULL,
0x00018b80000000ffULL, 0x0000ea2000070101ULL, 0x00018b380000005dULL, 0x0000ea5000070101ULL,
0x00018b380000005dULL, 0x0000ebc000070109ULL, 0x00018b380000005dULL, 0x0000f8b000070109ULL,
0x00018b88000000ffULL, 0x0000f98000070101ULL, 0x00018b80000000ffULL, 0x0000faf000070109ULL,
0x00018b80000000ffULL, 0x0000fb2000070109ULL, 0x00018b88000000ffULL, 0x0000fc9000070109ULL,
0x00018b88000000ffULL, 0x0001070000070109ULL, 0x00018b88000000ffULL, 0x0001073000070101ULL,
0x00018b88000000ffULL, 0x000108a000070109ULL, 0x00018b88000000ffULL, 0x00010a6000070109ULL,
0x00000000000000ffULL, 0x00010a9000080107ULL, 0x00018b78000000ffULL, 0x000112b000070101ULL,
0x00018b88000000ffULL, 0x000112f000070101ULL, 0x00018b70000000ffULL, 0x00011e9000070101ULL,
0x00018ad0000000ffULL, 0x000143c000070101ULL, 0x00018ad0000000ffULL, 0x0001453000070109ULL,
0x00018ad0000000ffULL, 0x0001489000070109ULL, 0x00018ad0000000ffULL, 0x000148c000070101ULL,
0x00018ad0000000ffULL, 0x00014a3000070109ULL, 0x00018ad0000000ffULL, 0x00017c9000070109ULL,
0x00018b5800000003ULL, 0x00017e70003f0101ULL, 0x00018b5800000003ULL, 0x00017fe0003f0109ULL,
0x00018b5800000003ULL, 0x000192a0003f0109ULL, 0x00018ad800000004ULL, 0x000192b0003f0101ULL,
0x00018ae000000004ULL, 0x000192c0003f0101ULL, 0x00018ae800000004ULL, 0x000192d0003f0101ULL,
0x00018af000000004ULL, 0x00053803003f0101ULL, 0x00011cc000101c04ULL, 0x00014b3000014a60ULL,
0x000c0504000192f0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0068190300000000ULL,
0x0000001700080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL, 0x0000001600000002ULL,
0x0000000000019300ULL, 0x0000000000000044ULL, 0x0000001600000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000018c00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000e7919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008800ff067b82ULL, 0x000ee20000000a00ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x0000000000617919ULL, 0x000f220000002100ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000000137919ULL, 0x000ee20000002700ULL, 0x000000040e007c24ULL, 0x004fe2000f8e0203ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x00001fff0e0e7589ULL, 0x000fe400000e0000ULL,
0x0000000400037c24ULL, 0x110fe2000f8e0261ULL, 0x00000005ff617819ULL, 0x000fe20000011661ULL,
0x0000000000007919ULL, 0x000ee60000002600ULL, 0x0000007f0300780cULL, 0x000fc40003f64070ULL,
0x00001fff61617589ULL, 0x000ea200000e0000ULL, 0x000000ff0300720cULL, 0x040fe40003f45270ULL,
0x0000000f0300780cULL, 0x040fe40003f04070ULL, 0x000000030300780cULL, 0x040fe40003fa4070ULL,
0x000000010300780cULL, 0x000fc80003f84070ULL, 0x000000000005b919ULL, 0x000f220000008800ULL,
0x000004000004b802ULL, 0x000fe20000000f00ULL, 0xff317217ff09b424ULL, 0x000fc600078e00ffULL,
0x000006540504b816ULL, 0x012fe20000000004ULL, 0x000000040e057824ULL, 0x004fc800078e0261ULL,
0x000000040304b824ULL, 0x000fe200078e0204ULL, 0x0000000000242947ULL, 0x008fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x018ad006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000403087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x018ad804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000403087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b5804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018400090400b388ULL, 0x0003e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000030612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b7804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x018b8806043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000840000067ab9ULL, 0x000fe20000000800ULL,
0x0000000205057824ULL, 0x000fe200078e00ffULL, 0x0000000206047899ULL, 0x000fe2000800063fULL,
0x0000001002107824ULL, 0x000fe200078e00ffULL, 0x00008200000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000001050c7836ULL, 0x000fe20000000000ULL, 0x0000000405047848ULL, 0x002fe20007fe0000ULL,
0x0000000105087824ULL, 0x000fe200078e0202ULL, 0x000001f0100f7812ULL, 0x000fe200078ec0ffULL,
0x0000000413037c24ULL, 0x000fe2000f8e0200ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x00000020050d7824ULL, 0x000fc400078e00ffULL, 0x0000000104097824ULL, 0x000fe400078e0a05ULL,
0x0000000605057c24ULL, 0x100fe4000f8e0203ULL, 0x000000060c0b7c24ULL, 0x040fe2000f8e0203ULL,
0xffffffe00d037812ULL, 0x000fe200078ee208ULL, 0x0000020005047825ULL, 0x100fe200078e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002000b067825ULL, 0x000fe200078e0006ULL,
0x000000ff0900720cULL, 0x040fe20003f03070ULL, 0x0000065405077896ULL, 0x010fe20008000004ULL,
0x000000010900780cULL, 0x000fe20003f23070ULL, 0x000000010c0d7824ULL, 0x040fe200078e0202ULL,
0x000000050c0c7819ULL, 0x000fe200000006ffULL, 0x00018ad007047890ULL, 0x000fe2000fffe03fULL,
0x0000000f04087210ULL, 0x000fe20007f5e0ffULL, 0x00008e00ff0a7b82ULL, 0x000e620000000a00ULL,
0x0000000f06067210ULL, 0x000fe20007f7e0ffULL, 0x00000004135c7824ULL, 0x000fe200078e00ffULL,
0xffffffe00c0d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff097224ULL, 0x000fe200010e0605ULL,
0x0000000703037c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff077224ULL, 0x000fe200018e0607ULL,
0x000000070d0f7c11ULL, 0x000fc4000f8e20ffULL, 0x00009600ff0c7b82ULL, 0x000ea20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008037faeULL, 0x000fe8000c101c4aULL,
0x00000000060f7faeULL, 0x0007e2000c901c4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x000000045c047825ULL, 0x002fe200078e000aULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000000a04047981ULL, 0x000f22000c1e1900ULL, 0x000000045c067825ULL, 0x00cfcc00078e000cULL,
0x0000000a06067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x00000000040972caULL, 0x010fe400000e0000ULL, 0x00000008ff5f7819ULL, 0x004fd60000011606ULL,
0x0000007f09047890ULL, 0x000fe4000fffe03fULL, 0x000000ff09087890ULL, 0x000fe4000fffe03fULL,
0x000000073f057899ULL, 0x000fe40008011604ULL, 0x000000083f0c7899ULL, 0x000fe20008011608ULL,
0x0000011000b88947ULL, 0x000ff60003800000ULL, 0x0000002061067824ULL, 0x040fe400078e0202ULL,
0x00000008615d7824ULL, 0x000fc600078e00ffULL, 0x000000030600780cULL, 0x040fe40003f44070ULL,
0x0000001f0600780cULL, 0x000fd60003f04070ULL, 0x00009000ff08ab82ULL, 0x000e620000000800ULL,
0x000000041307a824ULL, 0x000fe200078e0206ULL, 0x0000000906008c0cULL, 0x000fe4000bf26070ULL,
0x00000005ff00ac0cULL, 0x000fe2000bf65270ULL, 0x000000020707a824ULL, 0x000fc600078e00ffULL,
0x00009400ff0b8b82ULL, 0x000eb00000000800ULL, 0x00008c00ff04ab82ULL, 0x000ef00000000a00ULL,
0x00009200ff028b82ULL, 0x000f220000000a00ULL, 0x000000080709a224ULL, 0x002fc400078e0208ULL,
0x00000004ff087424ULL, 0x000fe400078e00ffULL, 0x0000000b5c078224ULL, 0x004fe200078e0206ULL,
0x00000007060bac11ULL, 0x040fe2000f8e10ffULL, 0x000000040904a825ULL, 0x008fe200078e0004ULL,
0x0000000706098c11ULL, 0x000fc6000f8e10ffULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x0000000407028825ULL, 0x010fca00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000002098faeULL, 0x0003e2000c92184aULL, 0x018b58085dff79a7ULL, 0x0005e60008500007ULL,
0x18ac0000040bafaeULL, 0x0007e8000992184aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x018b8806ff0679a7ULL, 0x000ea40008500007ULL,
0x000000ffff087224ULL, 0x004fe200078e0007ULL, 0x0000000000027805ULL, 0x002fc60000015200ULL,
0x018b8808ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x00afea0003800000ULL,
0x000000ff00067202ULL, 0x000fce0000000f00ULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x018b8808ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001ff0800788cULL, 0x000fe2000bf04070ULL,
0x00000080005b7824ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000400540947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x00008a00ff067b82ULL, 0x000ea20000000a00ULL, 0x0001400007067890ULL, 0x000fe2000fffe03fULL,
0x00000004ff087819ULL, 0x002fe20000011611ULL, 0x00000010110f7824ULL, 0x000fc800078e00ffULL,
0x000000015d047824ULL, 0x000fe200078e0208ULL, 0x000000f00f0f7812ULL, 0x000fc600078ec0ffULL,
0x000000015b037824ULL, 0x000fe200078e0204ULL, 0x0000000704097c11ULL, 0x040fe2000f8e10ffULL,
0x0000000104057824ULL, 0x000fc800078e0211ULL, 0x018a000009007984ULL, 0x000e640000000800ULL,
0x00000007000a7c11ULL, 0x002fe4000f8e10ffULL, 0x000000095d007c48ULL, 0x000fc6000ffe0000ULL,
0x018ac0000a027984ULL, 0x0002e40000000800ULL, 0x0000000100007824ULL, 0x000fca00078e0a5dULL,
0x000000000800720cULL, 0x000fe20003f06070ULL, 0x00000010040a7824ULL, 0x002fe400078e00ffULL,
0x0000000402037c24ULL, 0x008fc8000f8e0203ULL, 0x0000010003027825ULL, 0x004fc600078e0006ULL,
0x0000000f02047210ULL, 0x000fe40007f3e0ffULL, 0xfffffff00a027812ULL, 0x000fe400078ee205ULL,
0x00000003ff057210ULL, 0x000fe40000ffe4ffULL, 0x00000006020b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000c101c4aULL,
0x018a080009027984ULL, 0x000ea40000000800ULL, 0x00000007020d7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000208027836ULL, 0x000fc80000000000ULL, 0x018ac0000d037984ULL, 0x000ea20000000800ULL,
0x000000015d0a7824ULL, 0x000fe200078e0202ULL, 0x000000000200720cULL, 0x000fc60003f06070ULL,
0x000000015b0c7824ULL, 0x000fe400078e020aULL, 0x000000100a057824ULL, 0x042fe400078e00ffULL,
0x0000000403037c24ULL, 0x004fe4000f8e020cULL, 0x000000010a0c7824ULL, 0x000fe400078e0211ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0xfffffff0050c7812ULL, 0x000fe400078ee20cULL,
0x0000000f02047210ULL, 0x000fe40007f3e0ffULL, 0x000000060c0b7c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff057224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000c101c4aULL, 0x018a100009027984ULL, 0x000ea40000000800ULL,
0x00000007020d7c11ULL, 0x004fe2000f8e10ffULL, 0x0000000408027836ULL, 0x000fe40000000000ULL,
0x0000000608087836ULL, 0x000fe40000000000ULL, 0x018ac0000d037984ULL, 0x000ea20000000800ULL,
0x000000015d0a7824ULL, 0x000fe200078e0202ULL, 0x000000000200720cULL, 0x000fc60003f06070ULL,
0x000000015b0c7824ULL, 0x000fe200078e020aULL, 0x000000040a057819ULL, 0x002fc600000006ffULL,
0x0000000403037c24ULL, 0x004fe4000f8e020cULL, 0x000000010a0c7824ULL, 0x000fe400078e0211ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000015d0a7824ULL, 0x000fe200078e0208ULL, 0x0000000f02047210ULL, 0x000fe40007f3e0ffULL,
0x000000060c0b7c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff057224ULL, 0x000fe400008e0603ULL,
0x000000015b037824ULL, 0x000fc600078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000c101c4aULL, 0x000000000800720cULL, 0x000fe20003f06070ULL,
0x000000010a007824ULL, 0x040fe400078e0211ULL, 0x018a180009097984ULL, 0x000ea20000000800ULL,
0x000000100a057824ULL, 0x002fca00078e00ffULL, 0xfffffff005007812ULL, 0x000fc800078ee200ULL,
0x0000000600057c11ULL, 0x000fe4000f8e20ffULL, 0x00000007090c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0x0000000f02027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c4aULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00008a00ff087b82ULL, 0x000ea20000000a00ULL,
0x0001400007067890ULL, 0x000fe2000fffe03fULL, 0x0000005d0d007211ULL, 0x042fe200078fe0ffULL,
0x000000100d047824ULL, 0x000fc600078e00ffULL, 0x00000007000a7c11ULL, 0x000fe2000f8e10ffULL,
0x000000015b037824ULL, 0x000fe200078e0200ULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x0000000100057824ULL, 0x040fe200078e020dULL, 0x00000004000c7819ULL, 0x000fe200000006ffULL,
0x018a00000a027984ULL, 0x000e640000000800ULL, 0x0000000702067c11ULL, 0x002fca000f8e10ffULL,
0x018ac00006027984ULL, 0x0002e40000000800ULL, 0x0000000200067836ULL, 0x002fc80000000000ULL,
0x0000000106077824ULL, 0x040fe400078e020dULL, 0x00000010060e7824ULL, 0x000fe400078e00ffULL,
0x0000000402037c24ULL, 0x008fc8000f8e0203ULL, 0x0000010003027825ULL, 0x004fc600078e0008ULL,
0x0000000f02047210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00c027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x00000006020b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015b037824ULL, 0x000fc800078e0206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000b901c4aULL, 0x018a08000a027984ULL, 0x000ea20000000800ULL,
0x0000000400047836ULL, 0x002fe40000000000ULL, 0x0000000600007836ULL, 0x000fe40000000000ULL,
0x0000000104057824ULL, 0x000fe200078e020dULL, 0x00000007020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000000f02067210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fe200078ee207ULL, 0x00000010040e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x00000006020b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015b037824ULL, 0x000fc800078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e8000b901c4aULL, 0x018a10000a027984ULL, 0x000ea20000000800ULL,
0x0000000100067824ULL, 0x002fe200078e020dULL, 0x00000007020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000000f02047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fe400078ee205ULL, 0x00000003ff057210ULL, 0x000fe200007fe4ffULL,
0x000000015b037824ULL, 0x000fe200078e0200ULL, 0x0000000602077c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c4aULL,
0x018a18000a0a7984ULL, 0x000ea40000000800ULL, 0x000000070a0b7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000b027984ULL, 0x000ea40000000800ULL, 0x0000000402037c24ULL, 0x004fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc800078e0008ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x0000000f02027210ULL, 0x000fc80007f1e0ffULL, 0xfffffff009067812ULL, 0x000fe200078ee206ULL,
0x000000ffff037224ULL, 0x000fc600000e0603ULL, 0x0000000606057c11ULL, 0x002fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000b901c4aULL,
0x00000001ff027424ULL, 0x002fcc00078e00ffULL, 0x018b8802ff0279a7ULL, 0x000e640008500007ULL,
0x000000ffff067224ULL, 0x002fe200078e0003ULL, 0x0000000000027805ULL, 0x000fc60000015200ULL,
0x018b8806ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fce0007ffe0ffULL, 0x018b8806ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000127919ULL, 0x000e620000000000ULL,
0x00018b7807087890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x00000001ff047424ULL, 0x000fe400078e00ffULL, 0x0000002061077824ULL, 0x002fca00078e0212ULL,
0x0000001f0700780cULL, 0x000fda0003f04070ULL, 0x0000000000300947ULL, 0x000fea0003800000ULL,
0x00009200ff027b82ULL, 0x000e620000000a00ULL, 0x0000002007007836ULL, 0x000fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe40000000800ULL, 0x000000045c057c24ULL, 0x000fe2000f8e0207ULL,
0x0000000707077c11ULL, 0x000fe4000f8e10ffULL, 0x0000000900007c0cULL, 0x000fe2000bf06070ULL,
0x0000002005057836ULL, 0x000fc80000000000ULL, 0x0000000405027825ULL, 0x002fd000078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000002077faeULL, 0x0003e4000c12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000cff007c0cULL, 0x000fe2000bf05270ULL, 0x018b7804ff0279a7ULL, 0x0026a20008500007ULL,
0x000000ffff5a7224ULL, 0x000fe200078e00ffULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000527805ULL, 0x000fc4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x018b8804ff0479a7ULL, 0x008e620008500007ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x00000000000c7805ULL, 0x000fc4000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000f400b88947ULL, 0x002fec0003800000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff157224ULL, 0x004fe200078e0003ULL, 0x0000000704067899ULL, 0x000fe2000800063fULL,
0x000000ffff1c7224ULL, 0x002fe400078e0005ULL, 0xff317217ff097424ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff5a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x0000000808007819ULL, 0x000fc800000006ffULL,
0x0000000900007c0cULL, 0x000fda000bf06070ULL, 0x000000f400800947ULL, 0x002fea0003800000ULL,
0x000000ffff547224ULL, 0x000fce00078e00ffULL, 0x000000085f00720cULL, 0x000fe40003f04070ULL,
0x00000002ff057819ULL, 0x000fe40000011654ULL, 0x0000000354027812ULL, 0x040fe400078ec0ffULL,
0x0000000554057207ULL, 0x000fe40000000000ULL, 0x000000ff02027207ULL, 0x000fe40004000000ULL,
0x0000000305177812ULL, 0x000fc400078ec0ffULL, 0x0000000805007211ULL, 0x000fe400078ff0ffULL,
0x0000000000187805ULL, 0x000fe20000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff167224ULL, 0x000fce00078e00ffULL,
0x000000101600780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a181d7210ULL, 0x000fca0007f3e1ffULL,
0x000000011b1b7824ULL, 0x000fe200008e0e19ULL, 0x003d09001d00780cULL, 0x000fc80003f26070ULL,
0x000000ff1b00720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f26070ULL, 0x000000ff1b00720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc8000001141bULL,
0x0000001d14147211ULL, 0x000fca00078310ffULL, 0x000000ffff1b7224ULL, 0x000fca00008e061bULL,
0x0000000214147819ULL, 0x000fc8000000121bULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000116167836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x018b881cff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018141b7210ULL, 0x000fca0007f3e1ffULL,
0x0000000119197824ULL, 0x000fe200008e0e15ULL, 0x003d09001b00780cULL, 0x000fc80003f26070ULL,
0x000000ff1900720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f26070ULL, 0x000000ff1900720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011419ULL,
0x0000001b16167211ULL, 0x000fca00078310ffULL, 0x000000ffff197224ULL, 0x000fca00008e0619ULL,
0x0000000216167819ULL, 0x000fc80000001219ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x018b881cff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x0000000100157836ULL, 0x000fe20000000000ULL, 0x0000001700147211ULL, 0x000fc800078e10ffULL,
0x0000000c15007c0cULL, 0x000fe4000bf26070ULL, 0x00000020141a7811ULL, 0x000fc800078e30ffULL,
0x000000605b167812ULL, 0x000fce00078ef81aULL, 0x0000000400589947ULL, 0x000fea0003800000ULL,
0x00000004ff1f7819ULL, 0x000fe20000011612ULL, 0x00000010121c7824ULL, 0x000fe200078e00ffULL,
0x000000091a187c48ULL, 0x000fe2000ffe0000ULL, 0x00016000070d7890ULL, 0x000fe4000fffe03fULL,
0x000000015d1d7824ULL, 0x000fe200078e021fULL, 0x000000f01c217812ULL, 0x000fe200078ec0ffULL,
0x0000000118187824ULL, 0x000fe400078e0a1aULL, 0x000000011d1a7824ULL, 0x040fe200078e0216ULL,
0x000000071d207c11ULL, 0x040fe2000f8e10ffULL, 0x000000011d1e7824ULL, 0x040fe200078e0212ULL,
0x000000185d187248ULL, 0x000fe20007fe0000ULL, 0x000000101d1d7824ULL, 0x000fc400078e00ffULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x000000021f227836ULL, 0x000fe40000000000ULL,
0x00000001181c7824ULL, 0x000fe200078e0a5dULL, 0xfffffff01d1d7812ULL, 0x000fe200078ee21eULL,
0x000000015d237824ULL, 0x000fc600078e0222ULL, 0x0000001c1f00720cULL, 0x000fe20003f26070ULL,
0x0000000123247824ULL, 0x000fe200078e0212ULL, 0x0000000d1d1d7c11ULL, 0x000fe4000f8e20ffULL,
0x00000007141b7c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac0001b197984ULL, 0x000ea40000000800ULL, 0x0000000619197c24ULL, 0x004fc8000f8e021aULL,
0x0000010019187825ULL, 0x002fc600078e0014ULL, 0x00000021181a7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e0619ULL, 0x0000001623197210ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0003e2000c901c4aULL,
0x0000001c2200720cULL, 0x000fe20003f26070ULL, 0x000000041f227836ULL, 0x000fe40000000000ULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0x000000061f1f7836ULL, 0x000fe40000000000ULL,
0x00000010231d7824ULL, 0x002fe400078e00ffULL, 0x000000015d237824ULL, 0x000fc600078e0222ULL,
0xfffffff01d1d7812ULL, 0x000fe200078ee224ULL, 0x0000000123247824ULL, 0x000fc600078e0212ULL,
0x0000000d1d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x00000021181a7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe400010e0619ULL, 0x0000000123197824ULL, 0x000fc600078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0003e2000c901c4aULL,
0x0000001c2200720cULL, 0x000fc60003f26070ULL, 0x018a100020187984ULL, 0x000ea20000000800ULL,
0x00000010231b7824ULL, 0x002fe200078e00ffULL, 0x0000001f5d237210ULL, 0x000fc80007ffe0ffULL,
0xfffffff01b1b7812ULL, 0x000fe200078ee224ULL, 0x00000001231d7824ULL, 0x040fe400078e0216ULL,
0x0000000123167824ULL, 0x000fe200078e0212ULL, 0x0000000d1b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001023237824ULL, 0x000fca00078e00ffULL, 0xfffffff023167812ULL, 0x000fe400078ee216ULL,
0x00000007181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181b7faeULL, 0x0003e2000c901c4aULL,
0x0000001c1f00720cULL, 0x000fc60003f26070ULL, 0x018a1800201a7984ULL, 0x000ea20000000800ULL,
0x0000000d16197c11ULL, 0x002fe4000f8e20ffULL, 0x000000071a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x018ac0001a1a7984ULL, 0x000e640000000800ULL, 0x000000061a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x0000005d12217211ULL, 0x040fe200078fe0ffULL, 0x00000010121a7824ULL, 0x000fe200078e00ffULL,
0x00016000070d7890ULL, 0x000fe4000fffe03fULL, 0x0000000721207c11ULL, 0x040fe2000f8e10ffULL,
0x0000000121197824ULL, 0x040fe200078e0216ULL, 0x000000f01a237812ULL, 0x000fe200078ec0ffULL,
0x00000001211b7824ULL, 0x040fe400078e0212ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x00000010211e7824ULL, 0x000fc400078e00ffULL, 0x00000002211d7836ULL, 0x000fc60000000000ULL,
0xfffffff01e1f7812ULL, 0x000fe200078ee21bULL, 0x000000011d227824ULL, 0x000fc600078e0212ULL,
0x0000000d1f1f7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007141c7c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac0001c187984ULL, 0x000ea40000000800ULL,
0x0000000618197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x002fc600078e0014ULL,
0x00000023181a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e0619ULL,
0x000000161d197210ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1f7faeULL, 0x0003e8000b901c4aULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0xfffffff01d1b7812ULL, 0x002fe200078ee222ULL,
0x00000004211f7836ULL, 0x000fe40000000000ULL, 0x0000000621217836ULL, 0x000fe20000000000ULL,
0x0000000d1b1b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x000000011f1e7824ULL, 0x002fe400078e0212ULL,
0x0000000618197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x00000023181c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe400008e0619ULL,
0x000000011f197824ULL, 0x140fe400078e0216ULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1b7faeULL, 0x0003e8000b901c4aULL,
0x018a100020187984ULL, 0x000ea20000000800ULL, 0xfffffff01f1b7812ULL, 0x002fe200078ee21eULL,
0x00000001211d7824ULL, 0x040fe200078e0216ULL, 0x0000001221167210ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e00ffULL, 0x0000000d1b1b7c11ULL, 0x000fc8000f8e20ffULL,
0xfffffff021167812ULL, 0x000fe400078ee216ULL, 0x00000007181a7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001a187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff197224ULL, 0x000fca00008e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181b7faeULL, 0x0003e8000b901c4aULL, 0x018a1800201a7984ULL, 0x000ea20000000800ULL,
0x0000000d16197c11ULL, 0x002fe4000f8e20ffULL, 0x000000071a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x018ac0001a1a7984ULL, 0x000e640000000800ULL, 0x000000061a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000002314147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e6000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff1a7224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x018b881aff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018141b7210ULL, 0x000fca0007f3e1ffULL,
0x0000000119197824ULL, 0x000fe200008e0e15ULL, 0x003d09001b00780cULL, 0x000fc80003f26070ULL,
0x000000ff1900720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f26070ULL, 0x000000ff1900720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011419ULL,
0x0000001b16167211ULL, 0x000fca00078310ffULL, 0x000000ffff197224ULL, 0x000fca00008e0619ULL,
0x0000000216167819ULL, 0x000fc80000001219ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018b881aff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x000000005f00720cULL, 0x0c0fe20003f64070ULL, 0x0000000102147836ULL, 0x000fe20000000000ULL,
0x000000005f00720cULL, 0x000fe20003f24070ULL, 0x00018b80070d7890ULL, 0x000fe2000fffe03fULL,
0x0000000105057812ULL, 0x000fe200078ec0ffULL, 0x00000001ff6e7424ULL, 0x000fe200078e00ffULL,
0x0000000314157812ULL, 0x000fe400078ec0ffULL, 0x000000030200780cULL, 0x000fe40004f25270ULL,
0x00000012616b7211ULL, 0x000fc400078e28ffULL, 0x000000010500780cULL, 0x000fe40000f45470ULL,
0x00000002ff14b819ULL, 0x000fe40000011614ULL, 0x0000001f6b00780cULL, 0x000fc60003f24070ULL,
0x0000000117177824ULL, 0x000fc800078e0214ULL, 0x0000004017027824ULL, 0x040fe200078e00ffULL,
0x0000000017007211ULL, 0x000fe400078ff0ffULL, 0x000000ff15177207ULL, 0x000fe40005800000ULL,
0x000000c002057812ULL, 0x000fca00078ec0ffULL, 0x0000010000027824ULL, 0x000fe200078e0205ULL,
0x0000000000502947ULL, 0x000fec0003800000ULL, 0x0000002061167824ULL, 0x000fe200078e0212ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x000000031600780cULL, 0x000fda0003f44070ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff187b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000000413007824ULL, 0x000fe200078e0216ULL, 0x0000000716197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000200057824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000418007c36ULL, 0x002fc80008000000ULL,
0x0000001805057224ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe80003800000ULL,
0x0000000000341947ULL, 0x000fea0003800000ULL, 0x00009400ff057b82ULL, 0x000ea20000000800ULL,
0x000000016b167824ULL, 0x140fe400078e0202ULL, 0x000000015c007824ULL, 0x000fe200078e0217ULL,
0x000000076b177c11ULL, 0x000fe4000f8e10ffULL, 0x0000000916007c0cULL, 0x000fe4000bf46070ULL,
0x00009200ff147b82ULL, 0x002e620000000a00ULL, 0x0000000500007224ULL, 0x004fc800078e0202ULL,
0x000000016b057824ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x002fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014177faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff5400720cULL, 0x000fe20003f45270ULL, 0x018b806eff6679a7ULL, 0x0004d80008500007ULL,
0x0000000400942947ULL, 0x004fea0003800000ULL, 0x018ad86e5d1479a7ULL, 0x002e640008500007ULL,
0x0000001500027202ULL, 0x002fce0000000f00ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x018ad8025d0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff077224ULL, 0x000fce00078e00ffULL, 0x000000100700780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614057210ULL, 0x000fca0007f5e1ffULL, 0x0000000117167824ULL, 0x000fe200010e0e15ULL,
0x003d09000500780cULL, 0x000fc80003f46070ULL, 0x000000ff1600720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f46070ULL,
0x000000ff1600720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011416ULL, 0x0000000500007211ULL, 0x000fca00078510ffULL,
0x000000ffff057224ULL, 0x000fca00010e0616ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000107077836ULL, 0x000fce0000000000ULL, 0x018ad8025d0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001012007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe20000011612ULL, 0x00000001ff077424ULL, 0x000fc600078e00ffULL,
0x0000007000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c02057812ULL, 0x000fc800078ec0ffULL,
0x0000000705007c10ULL, 0x000fca000fffe000ULL, 0x0180000000027984ULL, 0x000e680000000800ULL,
0x0182000000157984ULL, 0x0004a20000000800ULL, 0x000000090200720bULL, 0x002fda0003f5d000ULL,
0x0000000000057806ULL, 0x000fc800010e0100ULL, 0x0000ffff05167812ULL, 0x000fe2000784c0ffULL,
0x000000ffff057224ULL, 0x000fd800078e0009ULL, 0x0000000000e8a947ULL, 0x00cfea0003800000ULL,
0x000000090200720bULL, 0x000fe40003f54000ULL, 0x000000ff6100720cULL, 0x000fe40003f65270ULL,
0x0000000209057209ULL, 0x000fd20007810000ULL, 0x0000000000177806ULL, 0x000fe400010e0100ULL,
0x018400050000b388ULL, 0x0003e40000000800ULL, 0x0000991017147816ULL, 0x000fc800000000ffULL,
0x000000ff1400720cULL, 0x000fda0003f45270ULL, 0x0000000000b0a947ULL, 0x002fea0003800000ULL,
0x8000000509007221ULL, 0x000fe20000010000ULL, 0x000000ff17ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0017ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000097308ULL, 0x0002ac0000000800ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc0000011612ULL, 0x00001f0009007589ULL, 0x004e6400000e0000ULL,
0x000000000b0b7220ULL, 0x082fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x0000000042427220ULL, 0x080fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000046467220ULL, 0x080fe20000410000ULL,
0x0000000049497220ULL, 0x080fe20000410000ULL, 0x000000004a4a7220ULL, 0x080fe20000410000ULL,
0x000000004d4d7220ULL, 0x080fe20000410000ULL, 0x000000004e4e7220ULL, 0x080fe20000410000ULL,
0x0000000051517220ULL, 0x080fe20000410000ULL, 0x0000000052527220ULL, 0x080fe20000410000ULL,
0x0000000057577220ULL, 0x080fe20000410000ULL, 0x0000000058587220ULL, 0x000fce0000410000ULL,
0x000000090a0a7220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000000812007811ULL, 0x002fcc00078ff0ffULL, 0x00001f0009007589ULL, 0x000e6400000e0000ULL,
0x000000000d0d7220ULL, 0x082fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000043437220ULL, 0x080fe20000410000ULL, 0x0000000044447220ULL, 0x080fe20000410000ULL,
0x0000000047477220ULL, 0x080fe20000410000ULL, 0x0000000048487220ULL, 0x080fe20000410000ULL,
0x000000004b4b7220ULL, 0x080fe20000410000ULL, 0x000000004c4c7220ULL, 0x080fe20000410000ULL,
0x000000004f4f7220ULL, 0x080fe20000410000ULL, 0x0000000050507220ULL, 0x080fe20000410000ULL,
0x0000000053537220ULL, 0x080fe20000410000ULL, 0x0000000056567220ULL, 0x080fe20000410000ULL,
0x0000000059597220ULL, 0x080fe20000410000ULL, 0x000000005a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fda0007846017ULL, 0x8000000502022221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b02022820ULL, 0x000fc80000410000ULL,
0x0000000200062308ULL, 0x000ea40000000800ULL, 0x0000000615152220ULL, 0x004fce0000410000ULL,
0x0000000a150a7221ULL, 0x000fe20000010000ULL, 0x000000ffff097224ULL, 0x000fce00078e0005ULL,
0x0000000712057812ULL, 0x040fe400078ec0ffULL, 0x000000ff07ff7812ULL, 0x000fe4000786c0ffULL,
0x00000004ff667819ULL, 0x008fe40000011612ULL, 0x0000000805687812ULL, 0x000fe400078ef812ULL,
0x0000000812057812ULL, 0x000fe400078ec0ffULL, 0x00000066616d7211ULL, 0x000fe200078e10ffULL,
0x0000000166557824ULL, 0x000fe200078e0268ULL, 0x00000007056c7812ULL, 0x000fe200078ef812ULL,
0x0000000868007824ULL, 0x002fc800078e00ffULL, 0x000000016c027824ULL, 0x040fe200078e026dULL,
0xfffffff800057812ULL, 0x000fe200078ee255ULL, 0x000000106c177824ULL, 0x000fc600078e00ffULL,
0x0000000705057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000183947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011612ULL, 0x00000006ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000007816ULL, 0x000fca0000000000ULL,
0x00001f0300037589ULL, 0x0002a800000e0000ULL, 0x00001f1500047589ULL, 0x0002e400000e0000ULL,
0x01200000051c783bULL, 0x0002e20000000200ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x08cfe40000000000ULL, 0x000000031e1e7232ULL, 0x000fe40000000000ULL,
0x000000041d1d7232ULL, 0x080fe40000000000ULL, 0x000000041f1f7232ULL, 0x000fce0000000000ULL,
0x0000000261397811ULL, 0x000fe200078e10ffULL, 0x000000106c157824ULL, 0x002fe200078e00ffULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0xfffffff017027812ULL, 0x000fe400078ee202ULL,
0x0000000166657824ULL, 0x000fe200078e0239ULL, 0x000000106c387812ULL, 0x000fe400078efcffULL,
0x0000000e02027c11ULL, 0x000fe2000f8e20ffULL, 0x000000016c007824ULL, 0x000fe400078e0265ULL,
0x000000016d6a7824ULL, 0x000fc400078e0238ULL, 0x000000000218783bULL, 0x000e620000004200ULL,
0xfffffff015007812ULL, 0x000fc800078ee200ULL, 0x0000000e00007c11ULL, 0x000fca000f8e20ffULL,
0x000000000014783bULL, 0x000f220000004200ULL, 0x0000312019197816ULL, 0x002fe400000000ffULL,
0x0000312018187816ULL, 0x000fe400000000ffULL, 0x00000019ff3d723eULL, 0x000fe400020006ffULL,
0x00000019ff35723eULL, 0x000fe200030006ffULL, 0x0000000868197824ULL, 0x000fe200078e00ffULL,
0x000031201a1a7816ULL, 0x000fe400000000ffULL, 0x0000312014147816ULL, 0x010fc400000000ffULL,
0x000031201b1b7816ULL, 0x000fe400000000ffULL, 0x00000014ff28723eULL, 0x000fe400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x0000000255147836ULL, 0x000fe20000000000ULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fc400000000ffULL, 0xfffffff8195e7812ULL, 0x000fe400078ee214ULL,
0x00000018ff3c723eULL, 0x000fe400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x0000001aff30723eULL, 0x000fe400020006ffULL, 0x0000001bff31723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x008fe200000018ffULL, 0x0000001aff2c723eULL, 0x000fc400030006ffULL,
0x0000001bff2d723eULL, 0x000fe400030006ffULL, 0x00000015ff29723eULL, 0x000fe200020006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000015ff25723eULL, 0x000fe400030006ffULL,
0x00000016ff20723eULL, 0x000fe400020006ffULL, 0x00000017ff21723eULL, 0x000fe200020006ffULL,
0x000000301c30723cULL, 0x000fe200000018ffULL, 0x00000016ff14723eULL, 0x000fc400030006ffULL,
0x00000017ff15723eULL, 0x000fe200030006ffULL, 0x0000001038177824ULL, 0x000fe200078e00ffULL,
0x000000075e5e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002c1c2c723cULL, 0x000fe600000018ffULL,
0xfffffff0176a7812ULL, 0x000fe200078ee26aULL, 0x012000005e18783bULL, 0x0002e40000000200ULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000103947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x08cfe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x0000000e6a627c11ULL, 0x000fe2000f8e20ffULL, 0x0000042000007945ULL, 0x000fe20003800000ULL,
0x0000003938697210ULL, 0x040fe40007ffe066ULL, 0x0000000438387819ULL, 0x000fe200000006ffULL,
0x000000006214783bULL, 0x000e620000004200ULL, 0x000000085f00720cULL, 0x0c0fe40003fc3070ULL,
0xfffffff038697812ULL, 0x000fe400078ee269ULL, 0x000000085f00720cULL, 0x000fc40003f43070ULL,
0x0000000e69607c11ULL, 0x000fca000f8e20ffULL, 0x000000006038783bULL, 0x000f220000004200ULL,
0x0000312014647816ULL, 0x002fe400000000ffULL, 0x00003120156f7816ULL, 0x000fe400000000ffULL,
0x00000064ff14723eULL, 0x000fe400020006ffULL, 0x0000006fff15723eULL, 0x000fe400020006ffULL,
0x0000312016637816ULL, 0x000fe400000000ffULL, 0x0000312017707816ULL, 0x000fc400000000ffULL,
0x00000064ff16723eULL, 0x000fe200030006ffULL, 0x00000014183c723cULL, 0x008fe2000000183cULL,
0x0000006fff17723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x010fe400000000ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x00000063ff14723eULL, 0x000fe200020006ffULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x00000070ff15723eULL, 0x000fcc00020006ffULL,
0x00000063ff16723eULL, 0x000fe200030006ffULL, 0x000000141830723cULL, 0x000fe20000001830ULL,
0x00000070ff17723eULL, 0x000fe400030006ffULL, 0x00000002ff637819ULL, 0x000fc80000011612ULL,
0x00000038ff14723eULL, 0x000fe200020006ffULL, 0x00000016182c723cULL, 0x000fe2000000182cULL,
0x00000039ff15723eULL, 0x000fe200020006ffULL, 0x0000000863647836ULL, 0x000fe20000000000ULL,
0x000000546300720cULL, 0x000fc80003f86070ULL, 0x00000039ff17723eULL, 0x000fe200030006ffULL,
0x0000000154397836ULL, 0x000fe20000000000ULL, 0x00000038ff16723eULL, 0x000fe200030006ffULL,
0x000000141828723cULL, 0x000fe20000001828ULL, 0x000000546400720cULL, 0x040fe40003fa6070ULL,
0x000000396300720cULL, 0x080fe40006786470ULL, 0x000000396400720cULL, 0x000fe20006fa6470ULL,
0x000000161824723cULL, 0x000fe20000001824ULL, 0x000031203a147816ULL, 0x000fc400000000ffULL,
0x000031203b157816ULL, 0x000fc800000000ffULL, 0x00000014ff16723eULL, 0x000fe400020006ffULL,
0x00000015ff17723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fc600030006ffULL, 0x000000161820723cULL, 0x000fec0000001820ULL,
0x00000014181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000404947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x0000003510107221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000405947ULL, 0x000fea0001000000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b886eff6e79a7ULL, 0x000e620008500007ULL,
0x00000002ff147819ULL, 0x000fe40000011639ULL, 0x00000003391a7812ULL, 0x000fe400078ec0ffULL,
0x000000085f00720cULL, 0x000fe40003f43070ULL, 0x0000001439397207ULL, 0x000fe40000000000ULL,
0x000000085f00720cULL, 0x000fe40003fc3070ULL, 0x00000004ff387803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003391b7812ULL, 0x040fe400078ec0ffULL,
0x00000008391c7211ULL, 0x000fce00078ff0ffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8067ff0075a7ULL, 0x000ee40008040147ULL, 0x00000000005c2947ULL, 0x008fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b8067ff0075a7ULL, 0x000ee40008040147ULL,
0xfffffffc00a8a947ULL, 0x008fea000383ffffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b886fff0075a7ULL, 0x002e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b886fff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001b1c147211ULL, 0x000fca00078e10ffULL,
0x00000040141e7824ULL, 0x000fe400078e00ffULL, 0x000000011c147836ULL, 0x000fc60000000000ULL,
0x000000405b1d7812ULL, 0x000fe400078ef81eULL, 0x0000000c14007c0cULL, 0x000fda000bf46070ULL,
0x000000040054a947ULL, 0x000fea0003800000ULL, 0x000000015d207824ULL, 0x000fe200078e0266ULL,
0x000000091e187c48ULL, 0x000fe2000ffe0000ULL, 0x00000010121f7824ULL, 0x000fe200078e00ffULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000000120177824ULL, 0x040fe200078e021dULL,
0x0000000720227c11ULL, 0x000fe2000f8e10ffULL, 0x0000000118187824ULL, 0x000fe200078e0a1eULL,
0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL, 0x018a000022147984ULL, 0x000e620000000800ULL,
0x000000185d187248ULL, 0x000fca0007fe0000ULL, 0x0000000118217824ULL, 0x000fe200078e0a5dULL,
0x0000000714197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0007240000000800ULL, 0x0000000120197824ULL, 0x048fe400078e0212ULL,
0x0000001020207824ULL, 0x000fca00078e00ffULL, 0xfffffff020197812ULL, 0x000fe400078ee219ULL,
0x0000000266207810ULL, 0x000fe40007ffe0ffULL, 0x0000000e19237c11ULL, 0x000fc6000f8e20ffULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124197824ULL, 0x000fe400078e021dULL,
0x0000000616177c24ULL, 0x010fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000001f16167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x000000216600720cULL, 0x000fda0003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000d101c4aULL, 0x018a080022187984ULL, 0x000ee20000000800ULL,
0x0000000124167824ULL, 0x042fe400078e0212ULL, 0x0000001024177824ULL, 0x000fca00078e00ffULL,
0xfffffff017167812ULL, 0x000fc800078ee216ULL, 0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000001f18187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x000000212000720cULL, 0x000fe20003f46070ULL, 0x0000000466207836ULL, 0x000fe40000000000ULL,
0x0000000666667836ULL, 0x000fe40000000000ULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124177824ULL, 0x000fc800078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000d101c4aULL, 0x018a100022167984ULL, 0x000ee20000000800ULL,
0x0000000124187824ULL, 0x042fe200078e0212ULL, 0x0000000424197819ULL, 0x000fc800000006ffULL,
0xfffffff019187812ULL, 0x000fc800078ee218ULL, 0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL,
0x00000007161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x0002e40000000800ULL,
0x000000015d1e7824ULL, 0x002fc800078e0266ULL, 0x000000011e1d7824ULL, 0x000fe400078e021dULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000001f16167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x000000212000720cULL, 0x000fda0003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000d101c4aULL, 0x018a180022187984ULL, 0x000ee20000000800ULL,
0x000000011e167824ULL, 0x042fe400078e0212ULL, 0x000000101e177824ULL, 0x000fca00078e00ffULL,
0xfffffff017167812ULL, 0x000fc800078ee216ULL, 0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x00000006181d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc600078e0014ULL,
0x0000001f14147210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x000000216600720cULL, 0x000fda0003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015d667824ULL, 0x000fe200078e0266ULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000001012197824ULL, 0x000fe400078e00ffULL, 0x0000000166177824ULL, 0x040fe200078e021dULL,
0x0000000766227c11ULL, 0x040fe2000f8e10ffULL, 0x00000010661e7824ULL, 0x000fe200078e00ffULL,
0x000000f019237812ULL, 0x000fe400078ec0ffULL, 0x0000001266197210ULL, 0x000fe20007ffe0ffULL,
0x018a000022147984ULL, 0x000e660000000800ULL, 0xfffffff01e197812ULL, 0x000fe200078ee219ULL,
0x00000002661e7836ULL, 0x000fc60000000000ULL, 0x0000000e19217c11ULL, 0x000fe2000f8e20ffULL,
0x000000011d197824ULL, 0x000fe400078e021eULL, 0x000000011e1f7824ULL, 0x040fe400078e0212ULL,
0x000000101e1e7824ULL, 0x000fca00078e00ffULL, 0xfffffff01e1f7812ULL, 0x000fe200078ee21fULL,
0x00000004661e7836ULL, 0x000fc60000000000ULL, 0x0000000e1f1f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000714187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016217faeULL, 0x0003e8000b901c4aULL, 0x018a080022187984ULL, 0x000ee20000000800ULL,
0x000000011d177824ULL, 0x002fe200078e021eULL, 0x0000000718207c11ULL, 0x008fca000f8e10ffULL,
0x018ac00020187984ULL, 0x0002e40000000800ULL, 0x000000011e207824ULL, 0x002fe400078e0212ULL,
0x0000000618197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181f7faeULL, 0x0003e8000b901c4aULL,
0x018a100022167984ULL, 0x000ee20000000800ULL, 0x000000041e197819ULL, 0x002fc800000006ffULL,
0xfffffff019207812ULL, 0x000fc800078ee220ULL, 0x0000000e20197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000716217c11ULL, 0x008fca000f8e10ffULL, 0x018ac00021167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4aULL,
0x018a180022187984ULL, 0x000ee40000000800ULL, 0x00000007181e7c11ULL, 0x008fe2000f8e10ffULL,
0x0000000666187836ULL, 0x000fc80000000000ULL, 0x000000011d1d7824ULL, 0x000fe200078e0218ULL,
0x018ac0001e1e7984ULL, 0x000ee60000000800ULL, 0x000000061e1d7c24ULL, 0x008fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x00000001181d7824ULL, 0x040fe200078e0212ULL,
0x0000002314147210ULL, 0x000fe20007f5e0ffULL, 0x0000001018187824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0xfffffff0181d7812ULL, 0x000fc800078ee21dULL,
0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e4000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7810ULL, 0x000fce0007ffe0ffULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000455147836ULL, 0x000fe20000000000ULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x0000000868677824ULL, 0x000fe400078e00ffULL, 0x000000016c6d7824ULL, 0x000fc600078e026dULL,
0xfffffff867677812ULL, 0x000fe200078ee214ULL, 0x0000000000581947ULL, 0x000fec0003800000ULL,
0x0000001c5f00720cULL, 0x000fe20003f44070ULL, 0x00009400ff197b82ULL, 0x000e660000000800ULL,
0x000000ff1a147207ULL, 0x040fe40001000000ULL, 0x000000ff1a177207ULL, 0x000fc60005000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ee20000000a00ULL,
0x000000015c177824ULL, 0x000fe400078e0217ULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016187836ULL, 0x000fc80000000000ULL,
0x0000001917167224ULL, 0x002fc800078e0218ULL, 0x000000016b177824ULL, 0x040fe400078e0216ULL,
0x000000016b167824ULL, 0x040fe200078e0218ULL, 0x000000076b6b7c11ULL, 0x000fe2000f8e10ffULL,
0x0000000417147825ULL, 0x008fc600078e0014ULL, 0x0000000916007c0cULL, 0x000fda000bf46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a00000146b7faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001006e7802ULL, 0x000fe20000000f00ULL, 0x000000106c667824ULL, 0x000fe200078e00ffULL,
0x0000000767677c11ULL, 0x000fe2000f8e20ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a48ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x018b786eff6e79a7ULL, 0x000e620008500007ULL,
0x0000000000103947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x004fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0004e800000e0000ULL,
0x00001f6414047589ULL, 0x00046400000e0000ULL, 0x01200000671c783bULL, 0x0006a20000000200ULL,
0x0000000000103947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x082fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000016c657824ULL, 0x040fe200078e0265ULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x000000106c6c7824ULL, 0x000fe200078e00ffULL,
0xfffffff066667812ULL, 0x000fe200078ee26dULL, 0x0000000655557836ULL, 0x000fe40000000000ULL,
0x0000000868687824ULL, 0x000fe200078e00ffULL, 0xfffffff06c657812ULL, 0x000fe400078ee265ULL,
0x0000000e66667c11ULL, 0x000fe4000f8e20ffULL, 0x0000000e65657c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff868557812ULL, 0x000fe200078ee255ULL, 0x000000006618783bULL, 0x000f260000004200ULL,
0x0000000755687c11ULL, 0x000fe2000f8e20ffULL, 0x000000006514783bULL, 0x004ea20000004200ULL,
0x0000312018187816ULL, 0x010fe400000000ffULL, 0x0000312019197816ULL, 0x000fe400000000ffULL,
0x000031201a1a7816ULL, 0x000fc400000000ffULL, 0x000031201b1b7816ULL, 0x000fe400000000ffULL,
0x0000312014147816ULL, 0x004fe400000000ffULL, 0x0000312015157816ULL, 0x000fe400000000ffULL,
0x0000312016167816ULL, 0x000fe400000000ffULL, 0x0000312017177816ULL, 0x000fe400000000ffULL,
0x00000018ff3c723eULL, 0x000fc400020006ffULL, 0x00000019ff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff34723eULL, 0x000fe400030006ffULL, 0x00000019ff35723eULL, 0x000fe400030006ffULL,
0x0000001aff30723eULL, 0x000fe200020006ffULL, 0x0000003c1c3c723cULL, 0x000fe200000018ffULL,
0x0000001bff31723eULL, 0x000fe400020006ffULL, 0x0000001aff2c723eULL, 0x000fc400030006ffULL,
0x0000001bff2d723eULL, 0x000fe200030006ffULL, 0x000000341c34723cULL, 0x000fe200000018ffULL,
0x00000014ff28723eULL, 0x000fe200020006ffULL, 0x012000006818783bULL, 0x0004e20000000200ULL,
0x00000015ff29723eULL, 0x000fe400020006ffULL, 0x00000014ff24723eULL, 0x000fe200030006ffULL,
0x000000301c30723cULL, 0x000fe200000018ffULL, 0x00000015ff25723eULL, 0x000fe400030006ffULL,
0x00000016ff20723eULL, 0x000fc400020006ffULL, 0x00000017ff21723eULL, 0x000fe200020006ffULL,
0x0000002c1c2c723cULL, 0x000fe200000018ffULL, 0x00000016ff14723eULL, 0x000fe400030006ffULL,
0x00000017ff15723eULL, 0x000fc600030006ffULL, 0x000000281c28723cULL, 0x000fec00000018ffULL,
0x000000241c24723cULL, 0x000fec00000018ffULL, 0x000000201c20723cULL, 0x000fec00000018ffULL,
0x000000141c1c723cULL, 0x000fe200000018ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000103947ULL, 0x004fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000000000ULL,
0x000000031a1a7232ULL, 0x000fe40000000000ULL, 0x0000000419197232ULL, 0x082fe40000000000ULL,
0x000000041b1b7232ULL, 0x000fce0000000000ULL, 0x0000000e6a6a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000037000007945ULL, 0x000fe20003800000ULL, 0x0000000e69697c11ULL, 0x000fe4000f8e20ffULL,
0x000000ff3800720cULL, 0x000fe20003f45270ULL, 0x000000006a14783bULL, 0x000ea80000004200ULL,
0x000000006938783bULL, 0x000f220000004200ULL, 0x00003120146b7816ULL, 0x004fc400000000ffULL,
0x00003120156c7816ULL, 0x000fe400000000ffULL, 0x0000006bff14723eULL, 0x000fe400020006ffULL,
0x0000006cff15723eULL, 0x000fe400020006ffULL, 0x0000312016557816ULL, 0x000fe400000000ffULL,
0x00003120176d7816ULL, 0x000fe400000000ffULL, 0x0000006bff16723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x0000006cff17723eULL, 0x000fc400030006ffULL,
0x0000312038387816ULL, 0x010fe400000000ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x00000055ff14723eULL, 0x000fe200020006ffULL, 0x000000161834723cULL, 0x000fe20000001834ULL,
0x0000006dff15723eULL, 0x000fcc00020006ffULL, 0x00000055ff16723eULL, 0x000fe200030006ffULL,
0x000000141830723cULL, 0x000fe20000001830ULL, 0x0000006dff17723eULL, 0x000fcc00030006ffULL,
0x00000038ff14723eULL, 0x000fe200020006ffULL, 0x00000016182c723cULL, 0x000fe2000000182cULL,
0x00000039ff15723eULL, 0x000fcc00020006ffULL, 0x00000038ff16723eULL, 0x000fe200030006ffULL,
0x000000141828723cULL, 0x000fe20000001828ULL, 0x00000039ff17723eULL, 0x000fcc00030006ffULL,
0x000031203a147816ULL, 0x000fe200000000ffULL, 0x000000161824723cULL, 0x000fe20000001824ULL,
0x000031203b157816ULL, 0x000fcc00000000ffULL, 0x00000014ff16723eULL, 0x000fe400020006ffULL,
0x00000015ff17723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fc600030006ffULL, 0x000000161820723cULL, 0x000fec0000001820ULL,
0x00000014181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000404947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x0000003510107221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x002fc600078e006fULL,
0x0000000000405947ULL, 0x000fea0003000000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002253537221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x0000000154547836ULL, 0x000fe40000000000ULL,
0x018b8814ff1679a7ULL, 0x000e620008500007ULL, 0x00000004146b7807ULL, 0x000fc80000000000ULL,
0x0000006b5400720cULL, 0x000fe20003f46070ULL, 0x000000ffff1c7224ULL, 0x002fd800078e0017ULL,
0xffffffc00000a947ULL, 0x000fea000383ffffULL, 0x018b5814ffff79a7ULL, 0x0003e40008500007ULL,
0x0000004008147811ULL, 0x002fc800078e40ffULL, 0x0000000914007c0cULL, 0x000fda000bf46070ULL,
0x000000b4006c2947ULL, 0x000fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fce00078e00ffULL,
0x00000002ff177819ULL, 0x000fe4000001166cULL, 0x000000036c1b7812ULL, 0x040fe400078ec0ffULL,
0x000000176c177207ULL, 0x000fe40000000000ULL, 0x000000ff1b1b7207ULL, 0x000fe40004000000ULL,
0x00000001171f7810ULL, 0x000fc80007ffe0ffULL, 0x000000031f1d7812ULL, 0x040fe400078ec0ffULL,
0x000000081f1a7211ULL, 0x000fe400078ff0ffULL, 0x0000000000187805ULL, 0x000fe20000015200ULL,
0x018b7815ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fce00078e00ffULL, 0x000000101e00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001618217210ULL, 0x000fca0007f5e1ffULL, 0x0000000117177824ULL, 0x000fe200010e0e19ULL,
0x003d09002100780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011417ULL, 0x0000002114147211ULL, 0x000fca00078510ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x0000000214147819ULL, 0x000fc80000001217ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011e1e7836ULL, 0x000fce0000000000ULL, 0x018b7815ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b881cff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b881cff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011a157836ULL, 0x000fe20000000000ULL,
0x00000004ff707819ULL, 0x000fe20000011612ULL, 0x000000041a147824ULL, 0x000fc600078e021dULL,
0x0000000c15007c0cULL, 0x000fe4000bf46070ULL, 0x0000002014187811ULL, 0x000fc800078e30ffULL,
0x000000605b1c7812ULL, 0x000fce00078ef818ULL, 0x000000040054a947ULL, 0x000fea0003800000ULL,
0x000000705d237210ULL, 0x000fe20007ffe0ffULL, 0x00000010121e7824ULL, 0x000fe200078e00ffULL,
0x0000000918167c48ULL, 0x000fe2000ffe0000ULL, 0x00016000070e7890ULL, 0x000fe4000fffe03fULL,
0x0000000723207c11ULL, 0x040fe2000f8e10ffULL, 0x0000000270227836ULL, 0x000fe20000000000ULL,
0x000000f01e257812ULL, 0x000fe200078ec0ffULL, 0x0000000116167824ULL, 0x000fe400078e0a18ULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x0000000123187824ULL, 0x000fc400078e021cULL,
0x000000165d167248ULL, 0x000fe20007fe0000ULL, 0x000000015d277824ULL, 0x000fc800078e0222ULL,
0x0000000116217824ULL, 0x000fe200078e0a5dULL, 0x0000001227247210ULL, 0x000fc80007ffe0ffULL,
0x000000217000720cULL, 0x000fe40003f46070ULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019177984ULL, 0x0004e40000000800ULL,
0x0000000127197824ULL, 0x044fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027247812ULL, 0x000fe200078ee224ULL, 0x0000000617177c24ULL, 0x008fe4000f8e0218ULL,
0x0000000123187824ULL, 0x000fe400078e0212ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x0000002516167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff023187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fc600018e0617ULL,
0x0000000e18237c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fe20003f46070ULL,
0x0000000470227836ULL, 0x000fe40000000000ULL, 0x018a080020187984ULL, 0x000ea40000000800ULL,
0x000000015d277824ULL, 0x000fe200078e0222ULL, 0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL,
0x0000000127247824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fc60003f46070ULL,
0x018a100020187984ULL, 0x000ea20000000800ULL, 0xfffffff027247812ULL, 0x000fc800078ee224ULL,
0x0000000e24237c11ULL, 0x002fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x00000006701e7836ULL, 0x002fc80000000000ULL,
0x000000015d277824ULL, 0x000fe400078e021eULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0619ULL, 0x0000001c27197210ULL, 0x000fe20007ffe0ffULL,
0x00000001271c7824ULL, 0x040fe400078e0212ULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x000000211e00720cULL, 0x000fc60003f46070ULL, 0x018a180020187984ULL, 0x000ea20000000800ULL,
0xfffffff0271c7812ULL, 0x000fc800078ee21cULL, 0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc600078e0014ULL,
0x0000002514147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d237824ULL, 0x000fe200078e0270ULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000123177824ULL, 0x040fe200078e021cULL, 0x0000000723207c11ULL, 0x040fe2000f8e10ffULL,
0x00000010231e7824ULL, 0x000fe200078e00ffULL, 0x000000f019257812ULL, 0x000fe200078ec0ffULL,
0x0000000123197824ULL, 0x000fe400078e0212ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x0000000223277836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000127227824ULL, 0x000fe400078e0212ULL, 0x0000000e19217c11ULL, 0x000fe4000f8e20ffULL,
0x0000001c27197210ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x0000000714187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000616177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002516167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016217faeULL, 0x0003e8000b901c4aULL, 0x018a080020187984ULL, 0x000ea20000000800ULL,
0xfffffff027217812ULL, 0x002fe200078ee222ULL, 0x0000000423277836ULL, 0x000fe40000000000ULL,
0x0000000623237836ULL, 0x000fe20000000000ULL, 0x0000000e21217c11ULL, 0x000fe2000f8e20ffULL,
0x0000000127177824ULL, 0x000fc400078e021cULL, 0x0000000127227824ULL, 0x040fe400078e0212ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018217faeULL, 0x0003e8000b901c4aULL, 0x018a100020167984ULL, 0x000ea20000000800ULL,
0xfffffff027197812ULL, 0x002fe200078ee222ULL, 0x0000000123217824ULL, 0x040fe200078e021cULL,
0x00000012231c7210ULL, 0x000fe20007ffe0ffULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x0000000e19197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002516167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a180020187984ULL, 0x000ea20000000800ULL,
0xfffffff023177812ULL, 0x002fc800078ee21cULL, 0x0000000e17177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000618217c24ULL, 0x002fc8000f8e0221ULL, 0x0000010021147825ULL, 0x000fc600078e0014ULL,
0x0000002514147210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e6000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x000000011f1f7812ULL, 0x000fe200078ec0ffULL,
0x00000020616e7824ULL, 0x000fe200078e0212ULL, 0x000000031b00780cULL, 0x000fc80005745270ULL,
0x000000011f00780cULL, 0x000fda0001745470ULL, 0x00000000004c2947ULL, 0x000fea0003800000ULL,
0x000000036e00780cULL, 0x000fe20003f44070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000006e13167211ULL, 0x000fe400078e10ffULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x00008c00ff147b82ULL, 0x000ea20000000a00ULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x0000000417187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x000000011b147836ULL, 0x002fe20000000000ULL, 0x00009400ff187b82ULL, 0x000e680000000800ULL,
0x0000000314167812ULL, 0x000fc800078ec0ffULL, 0x000000ff16197207ULL, 0x000fc60005000000ULL,
0x00000002ff14a819ULL, 0x000fe40000011614ULL, 0x000000015c167824ULL, 0x000fc600078e0219ULL,
0x000000011d1d7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ea40000000a00ULL,
0x000000401d177824ULL, 0x040fe200078e00ffULL, 0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL,
0x000000c017177812ULL, 0x000fca00078ec0ffULL, 0x000001001a177824ULL, 0x000fc800078e0217ULL,
0x000000016e197824ULL, 0x100fe400078e0217ULL, 0x0000001816177224ULL, 0x002fc600078e0217ULL,
0x0000000919007c0cULL, 0x000fe2000bf46070ULL, 0x000000016e177824ULL, 0x040fe200078e0217ULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000417147825ULL, 0x004fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801cff1479a7ULL, 0x000e620008500007ULL, 0x000000ff6c00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018af81c5d1479a7ULL, 0x000e640008500007ULL, 0x0000001500187202ULL, 0x002fe40000000f00ULL,
0x0000000000167805ULL, 0x000fe40000015200ULL, 0x018af8185d0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018af8185d0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001012077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011612ULL,
0x000000ffff167224ULL, 0x000fc600078e0009ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000007141b7c10ULL, 0x000fca000fffe007ULL,
0x018080001b147984ULL, 0x000e680000000800ULL, 0x018280001b157984ULL, 0x0004a20000000800ULL,
0x000000091400720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000091400720bULL, 0x000fe40003f54000ULL,
0x000000016100780cULL, 0x000fe40003f65270ULL, 0x0000001409167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018480161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001609097221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900177308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f6317097589ULL, 0x006e6400000e0000ULL,
0x000000090b0b7220ULL, 0x082fe20000410000ULL, 0x000000090c0c7220ULL, 0x080fe20000410000ULL,
0x000000090f0f7220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x0000000942427220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x000000094a4a7220ULL, 0x080fe20000410000ULL,
0x000000094d4d7220ULL, 0x080fe20000410000ULL, 0x000000094e4e7220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x0000000958587220ULL, 0x000fce0000410000ULL,
0x000000170a0a7220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f6417097589ULL, 0x002e6400000e0000ULL, 0x000000090d0d7220ULL, 0x082fe20000410000ULL,
0x000000090e0e7220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000940407220ULL, 0x080fe20000410000ULL, 0x0000000943437220ULL, 0x080fe20000410000ULL,
0x0000000944447220ULL, 0x080fe20000410000ULL, 0x0000000947477220ULL, 0x080fe20000410000ULL,
0x0000000948487220ULL, 0x080fe20000410000ULL, 0x000000094b4b7220ULL, 0x080fe20000410000ULL,
0x000000094c4c7220ULL, 0x080fe20000410000ULL, 0x000000094f4f7220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000959597220ULL, 0x080fe20000410000ULL,
0x000000095a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001614142221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL, 0x0000001400062308ULL, 0x000ea40000000800ULL,
0x0000000615152220ULL, 0x004fce0000410000ULL, 0x0000000a150a7221ULL, 0x000fe20000010000ULL,
0x000000ffff097224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0002a800000e0000ULL,
0x00001f6414047589ULL, 0x0002e400000e0000ULL, 0x01280000051c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x080fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x002fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x008fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x012800005e18783bULL, 0x0002e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x08cfe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006214783bULL, 0x000e620000004200ULL, 0x0000006c6300720cULL, 0x000fe20003f66070ULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x000000085f00720cULL, 0x040fe20003fc3070ULL,
0x000000006038783bULL, 0x000f220000004200ULL, 0x0000006c6400720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x0000312014547816ULL, 0x002fe400000000ffULL,
0x0000312015557816ULL, 0x000fc400000000ffULL, 0x00000054ff14723eULL, 0x000fe400020006ffULL,
0x00000055ff15723eULL, 0x000fe400020006ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000054ff54723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x00000055ff55723eULL, 0x000fcc00030006ffULL,
0x00000016ff14723eULL, 0x000fe200020006ffULL, 0x000000541834723cULL, 0x000fe20000001834ULL,
0x00000017ff15723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe400030006ffULL,
0x00000017ff17723eULL, 0x000fc600030006ffULL, 0x000000141830723cULL, 0x000fec0000001830ULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x0000312038147816ULL, 0x010fe200000000ffULL,
0x000000016c387836ULL, 0x000fe20000000000ULL, 0x0000312039157816ULL, 0x000fc800000000ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fe400030006ffULL,
0x000000386300720cULL, 0x080fe20005f66470ULL, 0x000000161828723cULL, 0x000fe20000001828ULL,
0x000000386400720cULL, 0x000fca0006786470ULL, 0x000000141824723cULL, 0x000fee0000001824ULL,
0x000031203a147816ULL, 0x000fe400000000ffULL, 0x000031203b157816ULL, 0x000fe400000000ffULL,
0x00000014ff16723eULL, 0x000fc400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x0000003510107221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8816ff1479a7ULL, 0x000e620008500007ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000085f00720cULL, 0x0c0fe40003fc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x0000000117177810ULL, 0x000fe40007ffe0ffULL, 0x000000085f00720cULL, 0x000fc40003fa3070ULL,
0x00000040ff387803ULL, 0x000fe40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000008171c7211ULL, 0x000fe200078ff0ffULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000041c147824ULL, 0x000fca00078e021bULL,
0x00000006141e7819ULL, 0x000fe200000006ffULL, 0x000000011c147836ULL, 0x000fc60000000000ULL,
0x000000405b1d7812ULL, 0x000fe400078ef81eULL, 0x0000000c14007c0cULL, 0x000fda000bfc6070ULL,
0x000000040054e947ULL, 0x000fea0003800000ULL, 0x000000015d207824ULL, 0x000fe200078e0270ULL,
0x000000091e187c48ULL, 0x000fe2000ffe0000ULL, 0x00000010121f7824ULL, 0x000fe200078e00ffULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000000120177824ULL, 0x040fe200078e021dULL,
0x0000000720227c11ULL, 0x000fe2000f8e10ffULL, 0x0000000118187824ULL, 0x000fe200078e0a1eULL,
0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL, 0x018a000022147984ULL, 0x000e620000000800ULL,
0x000000185d187248ULL, 0x000fca0007fe0000ULL, 0x0000000118217824ULL, 0x000fe200078e0a5dULL,
0x0000000714197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0007240000000800ULL, 0x0000000120197824ULL, 0x048fe400078e0212ULL,
0x0000001020207824ULL, 0x000fca00078e00ffULL, 0xfffffff020197812ULL, 0x000fe200078ee219ULL,
0x0000000270207836ULL, 0x000fc60000000000ULL, 0x0000000e19237c11ULL, 0x000fe4000f8e20ffULL,
0x000000205d247210ULL, 0x000fca0007ffe0ffULL, 0x0000000124197824ULL, 0x000fe400078e021dULL,
0x0000000616177c24ULL, 0x010fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000001f16167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x000000217000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000f101c4aULL, 0x018a080022187984ULL, 0x000ee20000000800ULL,
0x0000000124167824ULL, 0x042fe400078e0212ULL, 0x0000001024177824ULL, 0x000fca00078e00ffULL,
0xfffffff017167812ULL, 0x000fc800078ee216ULL, 0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000001f18187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x000000212000720cULL, 0x000fe20003fc6070ULL, 0x0000000470207836ULL, 0x000fe20000000000ULL,
0x0000000670707810ULL, 0x000fc60007ffe0ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124177824ULL, 0x000fc800078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000f101c4aULL, 0x018a100022167984ULL, 0x000ee20000000800ULL,
0x0000000124187824ULL, 0x042fe400078e0212ULL, 0x0000001024197824ULL, 0x000fca00078e00ffULL,
0xfffffff019187812ULL, 0x000fc800078ee218ULL, 0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL,
0x00000007161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x0002e40000000800ULL,
0x000000015d1e7824ULL, 0x002fc800078e0270ULL, 0x000000011e1d7824ULL, 0x000fe400078e021dULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000001f16167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x000000212000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000f101c4aULL, 0x018a180022187984ULL, 0x000ee20000000800ULL,
0x000000011e167824ULL, 0x042fe400078e0212ULL, 0x000000101e177824ULL, 0x000fca00078e00ffULL,
0xfffffff017167812ULL, 0x000fc800078ee216ULL, 0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x00000006181d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc600078e0014ULL,
0x0000001f14147210ULL, 0x000fca0007fde0ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x000000217000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000f101c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015d707824ULL, 0x000fe200078e0270ULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000001012197824ULL, 0x000fe400078e00ffULL, 0x0000000170177824ULL, 0x040fe200078e021dULL,
0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL, 0x0000000270207836ULL, 0x000fe20000000000ULL,
0x000000f019217812ULL, 0x000fe200078ec0ffULL, 0x0000000170197824ULL, 0x140fe200078e0212ULL,
0x00000004701e7819ULL, 0x000fe200000006ffULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000120227824ULL, 0x000fc400078e0212ULL, 0xfffffff01e197812ULL, 0x000fc800078ee219ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000120197824ULL, 0x000fe200078e021dULL,
0x0000000714187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4aULL, 0x018a08001f187984ULL, 0x000ee20000000800ULL,
0x0000001020177824ULL, 0x002fe400078e00ffULL, 0x0000000470207836ULL, 0x000fe20000000000ULL,
0x0000000670707810ULL, 0x000fe40007ffe0ffULL, 0xfffffff017227812ULL, 0x000fe200078ee222ULL,
0x0000000120177824ULL, 0x000fc400078e021dULL, 0x00000001701d7824ULL, 0x000fe200078e021dULL,
0x0000000e22237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000120227824ULL, 0x000fe200078e0212ULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fca00030e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4aULL,
0x018a10001f167984ULL, 0x000ee20000000800ULL, 0x0000001020197824ULL, 0x002fca00078e00ffULL,
0xfffffff019227812ULL, 0x000fc800078ee222ULL, 0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL,
0x00000007161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4aULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x00000006181d7c24ULL, 0x008fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x00000001701d7824ULL, 0x040fe200078e0212ULL,
0x0000002114147210ULL, 0x000fe20007fde0ffULL, 0x0000001070707824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0xfffffff0701d7812ULL, 0x000fc800078ee21dULL,
0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e4000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000100547802ULL, 0x000fc60000000f00ULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000001c5f00720cULL, 0x000fe20003fc4070ULL,
0x00009400ff187b82ULL, 0x000e620000000800ULL, 0x000000076e197c11ULL, 0x000fe4000f8e10ffULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a177207ULL, 0x000fc60007000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ee20000000a00ULL,
0x000000015c177824ULL, 0x000fe400078e0217ULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016167836ULL, 0x000fc80000000000ULL,
0x0000001817177224ULL, 0x102fe400078e0216ULL, 0x000000016e167824ULL, 0x040fe400078e0216ULL,
0x000000016e177824ULL, 0x000fc600078e0217ULL, 0x0000000916007c0cULL, 0x000fe2000bfc6070ULL,
0x0000000417147825ULL, 0x008fd800078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000f12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a48ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b7854ff5479a7ULL, 0x000e620008500007ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x004fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0004e800000e0000ULL,
0x00001f6414047589ULL, 0x00046400000e0000ULL, 0x01280000671c783bULL, 0x0006a20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x082fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000006618783bULL, 0x000f280000004200ULL,
0x000000006514783bULL, 0x004ea20000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x004fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x000fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x012800006818783bULL, 0x0004e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x004fde0003800000ULL,
0x0000000318187232ULL, 0x088fe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x082fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006a14783bULL, 0x000ea20000004200ULL, 0x000000ff3800720cULL, 0x000fe20003f45270ULL,
0x0000034000007945ULL, 0x000fe40003800000ULL, 0x000000006938783bULL, 0x000f220000004200ULL,
0x00003120146e7816ULL, 0x004fe400000000ffULL, 0x00003120156f7816ULL, 0x000fe400000000ffULL,
0x0000006eff14723eULL, 0x000fe400020006ffULL, 0x0000006fff15723eULL, 0x000fc400020006ffULL,
0x00003120166d7816ULL, 0x000fe400000000ffULL, 0x0000312017707816ULL, 0x000fe400000000ffULL,
0x0000006eff16723eULL, 0x000fe200030006ffULL, 0x00000014183c723cULL, 0x008fe2000000183cULL,
0x0000006fff17723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x010fe400000000ffULL,
0x0000312039397816ULL, 0x000fc400000000ffULL, 0x0000006dff14723eULL, 0x000fe200020006ffULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x00000070ff15723eULL, 0x000fcc00020006ffULL,
0x0000006dff16723eULL, 0x000fe200030006ffULL, 0x000000141830723cULL, 0x000fe20000001830ULL,
0x00000070ff17723eULL, 0x000fcc00030006ffULL, 0x00000038ff14723eULL, 0x000fe200020006ffULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x00000039ff15723eULL, 0x000fcc00020006ffULL,
0x00000038ff16723eULL, 0x000fe200030006ffULL, 0x000000141828723cULL, 0x000fe20000001828ULL,
0x00000039ff17723eULL, 0x000fcc00030006ffULL, 0x000031203a147816ULL, 0x000fe200000000ffULL,
0x000000161824723cULL, 0x000fe20000001824ULL, 0x000031203b157816ULL, 0x000fcc00000000ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0001000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x0000003510107221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002051517221ULL, 0x000fe20000010000ULL, 0x0000002152527221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x002fc600078e0055ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x000000016c6c7836ULL, 0x000fe40000000000ULL, 0x018b8814ff1679a7ULL, 0x000e660008500007ULL,
0x0000006b6c00720cULL, 0x000fe40003f46070ULL, 0x00000017001c7202ULL, 0x002fd60000000f00ULL,
0xffffffc000eca947ULL, 0x000fea000383ffffULL, 0x018b6014ffff79a7ULL, 0x0003e40008500007ULL,
0x0000008008147811ULL, 0x002fc800078e40ffULL, 0x0000000914007c0cULL, 0x000fda000bf46070ULL,
0x0000007800442947ULL, 0x000fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fce00078e00ffULL,
0x00000002ff177819ULL, 0x000fe4000001166cULL, 0x000000036c1b7812ULL, 0x040fe400078ec0ffULL,
0x000000176c177207ULL, 0x000fe40000000000ULL, 0x000000ff1b1b7207ULL, 0x000fc60004000000ULL,
0x00000002171f7836ULL, 0x000fca0000000000ULL, 0x000000031f1d7812ULL, 0x040fe400078ec0ffULL,
0x000000081f1a7211ULL, 0x000fe400078ff0ffULL, 0x0000000000187805ULL, 0x000fe20000015200ULL,
0x018b7815ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fce00078e00ffULL, 0x000000101e00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001618217210ULL, 0x000fca0007f5e1ffULL, 0x0000000117177824ULL, 0x000fe200010e0e19ULL,
0x003d09002100780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011417ULL, 0x0000002114147211ULL, 0x000fca00078510ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x0000000214147819ULL, 0x000fc80000001217ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011e1e7836ULL, 0x000fce0000000000ULL, 0x018b7815ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b881cff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b881cff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011a157810ULL, 0x000fe20007ffe0ffULL,
0x000000041a147824ULL, 0x000fe200078e021dULL, 0x00000004ff707819ULL, 0x000fe40000011612ULL,
0x0000000c15007c0cULL, 0x000fe4000bf46070ULL, 0x0000002014187811ULL, 0x000fc800078e30ffULL,
0x000000605b1c7812ULL, 0x000fce00078ef818ULL, 0x000000040054a947ULL, 0x000fea0003800000ULL,
0x000000015d237824ULL, 0x000fe200078e0270ULL, 0x0000000918167c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121e7824ULL, 0x000fe200078e00ffULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000270227836ULL, 0x000fe20000000000ULL, 0x0000000723207c11ULL, 0x040fe2000f8e10ffULL,
0x0000000116167824ULL, 0x000fe200078e0a18ULL, 0x000000f01e257812ULL, 0x000fe200078ec0ffULL,
0x0000000123187824ULL, 0x000fe200078e021cULL, 0x000000225d277210ULL, 0x000fe20007ffe0ffULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x000000165d167248ULL, 0x000fc60007fe0000ULL,
0x0000000127247824ULL, 0x000fe400078e0212ULL, 0x0000000116217824ULL, 0x000fca00078e0a5dULL,
0x000000217000720cULL, 0x000fe40003f46070ULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019177984ULL, 0x0004e40000000800ULL,
0x0000000127197824ULL, 0x044fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027247812ULL, 0x000fe200078ee224ULL, 0x0000000617177c24ULL, 0x008fe4000f8e0218ULL,
0x0000000123187824ULL, 0x000fe400078e0212ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x0000002516167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff023187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fc600018e0617ULL,
0x0000000e18237c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fe20003f46070ULL,
0x0000000470227836ULL, 0x000fe40000000000ULL, 0x018a080020187984ULL, 0x000ea40000000800ULL,
0x000000015d277824ULL, 0x000fe200078e0222ULL, 0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL,
0x0000000127247824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fc60003f46070ULL,
0x018a100020187984ULL, 0x000ea20000000800ULL, 0xfffffff027247812ULL, 0x000fc800078ee224ULL,
0x0000000e24237c11ULL, 0x002fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x00000006701e7810ULL, 0x002fca0007ffe0ffULL,
0x000000015d277824ULL, 0x000fe400078e021eULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x00000001271c7824ULL, 0x040fe200078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x000000211e00720cULL, 0x000fe40003f46070ULL, 0x018a180020187984ULL, 0x000ea40000000800ULL,
0xfffffff0271c7812ULL, 0x000fc800078ee21cULL, 0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc600078e0014ULL,
0x0000002514147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d217824ULL, 0x000fe200078e0270ULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000121177824ULL, 0x040fe200078e021cULL, 0x0000000721207c11ULL, 0x040fe2000f8e10ffULL,
0x00000010211e7824ULL, 0x000fe200078e00ffULL, 0x000000f019237812ULL, 0x000fe200078ec0ffULL,
0x0000000121197824ULL, 0x000fe400078e0212ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x0000000221277836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000127227824ULL, 0x000fe400078e0212ULL, 0x0000000e19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027227812ULL, 0x000fe200078ee222ULL, 0x0000000421277836ULL, 0x000fe20000000000ULL,
0x0000000621217810ULL, 0x000fe40007ffe0ffULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000616177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fc80007f5e0ffULL, 0x00000017ff177210ULL, 0x000fca00017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000b901c4aULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL,
0x0000000127177824ULL, 0x040fe400078e021cULL, 0x0000000127227824ULL, 0x040fe400078e0212ULL,
0x0000001027277824ULL, 0x000fca00078e00ffULL, 0xfffffff027227812ULL, 0x000fe400078ee222ULL,
0x00000007181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4aULL,
0x018a100020167984ULL, 0x000ea20000000800ULL, 0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL,
0x0000000121197824ULL, 0x040fe400078e021cULL, 0x00000010211c7824ULL, 0x000fe200078e00ffULL,
0x00000007161e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000b901c4aULL,
0x018a180020187984ULL, 0x000ea40000000800ULL, 0x0000000718187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x0000000121197824ULL, 0x000fe200078e0212ULL,
0x0000002314147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff01c197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000e19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x00000020616e7824ULL, 0x000fe200078e0212ULL, 0x000000011f1f7812ULL, 0x000fe400078ec0ffULL,
0x000000031b00780cULL, 0x000fe40005745270ULL, 0x00000001001c7802ULL, 0x000fe40000000f00ULL,
0x000000011f00780cULL, 0x000fda0001745470ULL, 0x00000000004c2947ULL, 0x000fea0003800000ULL,
0x000000036e00780cULL, 0x000fe20003f44070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000000413167824ULL, 0x000fe200078e026eULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000417187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x000000011b147836ULL, 0x002fe20000000000ULL, 0x00009400ff187b82ULL, 0x000e680000000800ULL,
0x0000000314167812ULL, 0x000fc800078ec0ffULL, 0x000000ff16197207ULL, 0x000fc60005000000ULL,
0x00000002ff14a819ULL, 0x000fe40000011614ULL, 0x000000015c167824ULL, 0x000fc600078e0219ULL,
0x000000011d1d7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ea40000000a00ULL,
0x000000401d177824ULL, 0x040fe200078e00ffULL, 0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL,
0x000000c017177812ULL, 0x000fca00078ec0ffULL, 0x000001001a177824ULL, 0x000fc800078e0217ULL,
0x000000016e197824ULL, 0x100fe400078e0217ULL, 0x0000001816177224ULL, 0x002fc600078e0217ULL,
0x0000000919007c0cULL, 0x000fe4000bf46070ULL, 0x000000176e177210ULL, 0x000fe40007ffe0ffULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000417147825ULL, 0x004fcc00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801cff1479a7ULL, 0x000e620008500007ULL, 0x000000ff6c00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018b181c5d1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018b18185d0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018b18185d0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001012077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011612ULL,
0x000000ffff167224ULL, 0x000fc600078e0009ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000007141b7c10ULL, 0x000fca000fffe007ULL,
0x018100001b147984ULL, 0x000e680000000800ULL, 0x018300001b157984ULL, 0x0004a20000000800ULL,
0x000000091400720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000091400720bULL, 0x000fe40003f54000ULL,
0x000000026100780cULL, 0x000fe40003f65270ULL, 0x0000001409167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018500161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001609097221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900177308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f6317097589ULL, 0x006e6400000e0000ULL,
0x000000090b0b7220ULL, 0x082fe20000410000ULL, 0x000000090c0c7220ULL, 0x080fe20000410000ULL,
0x000000090f0f7220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x0000000942427220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x000000094a4a7220ULL, 0x080fe20000410000ULL,
0x000000094d4d7220ULL, 0x080fe20000410000ULL, 0x000000094e4e7220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x0000000958587220ULL, 0x000fce0000410000ULL,
0x000000170a0a7220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f6417097589ULL, 0x002e6400000e0000ULL, 0x000000090d0d7220ULL, 0x082fe20000410000ULL,
0x000000090e0e7220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000940407220ULL, 0x080fe20000410000ULL, 0x0000000943437220ULL, 0x080fe20000410000ULL,
0x0000000944447220ULL, 0x080fe20000410000ULL, 0x0000000947477220ULL, 0x080fe20000410000ULL,
0x0000000948487220ULL, 0x080fe20000410000ULL, 0x000000094b4b7220ULL, 0x080fe20000410000ULL,
0x000000094c4c7220ULL, 0x080fe20000410000ULL, 0x000000094f4f7220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000959597220ULL, 0x080fe20000410000ULL,
0x000000095a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001614142221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL, 0x0000001400062308ULL, 0x000ea40000000800ULL,
0x0000000615152220ULL, 0x004fce0000410000ULL, 0x0000000a150a7221ULL, 0x000fe20000010000ULL,
0x000000ffff097224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0002a800000e0000ULL,
0x00001f6414047589ULL, 0x0002e400000e0000ULL, 0x01300000051c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x080fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x002fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x008fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x013000005e18783bULL, 0x0002e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x08cfe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006214783bULL, 0x000e620000004200ULL, 0x0000006c6300720cULL, 0x000fe20003f66070ULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x000000085f00720cULL, 0x040fe20003fc3070ULL,
0x000000006038783bULL, 0x000f220000004200ULL, 0x0000006c6400720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x0000312014547816ULL, 0x002fe400000000ffULL,
0x0000312015557816ULL, 0x000fc400000000ffULL, 0x00000054ff14723eULL, 0x000fe400020006ffULL,
0x00000055ff15723eULL, 0x000fe400020006ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000054ff54723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x00000055ff55723eULL, 0x000fcc00030006ffULL,
0x00000016ff14723eULL, 0x000fe200020006ffULL, 0x000000541834723cULL, 0x000fe20000001834ULL,
0x00000017ff15723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe400030006ffULL,
0x00000017ff17723eULL, 0x000fc600030006ffULL, 0x000000141830723cULL, 0x000fec0000001830ULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x0000312038147816ULL, 0x010fe400000000ffULL,
0x0000312039157816ULL, 0x000fe400000000ffULL, 0x000000016c387810ULL, 0x000fc40007ffe0ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fe400030006ffULL,
0x000000386300720cULL, 0x080fe20005f66470ULL, 0x000000161828723cULL, 0x000fe20000001828ULL,
0x000000386400720cULL, 0x000fca0006786470ULL, 0x000000141824723cULL, 0x000fee0000001824ULL,
0x000031203a147816ULL, 0x000fe400000000ffULL, 0x000031203b157816ULL, 0x000fe400000000ffULL,
0x00000014ff16723eULL, 0x000fc400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x0000003510107221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8816ff1479a7ULL, 0x000e620008500007ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000085f00720cULL, 0x0c0fe40003fc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x000000085f00720cULL, 0x000fe20003fa3070ULL, 0x0000000217177836ULL, 0x000fe20000000000ULL,
0x00000040ff387803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000008171c7211ULL, 0x000fe200078ff0ffULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7810ULL, 0x000fce0007ffe0ffULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000041c147824ULL, 0x000fc800078e021bULL,
0x00000040141e7824ULL, 0x000fe400078e00ffULL, 0x000000011c147836ULL, 0x000fc60000000000ULL,
0x000000405b1d7812ULL, 0x000fe400078ef81eULL, 0x0000000c14007c0cULL, 0x000fda000bfc6070ULL,
0x000000040054e947ULL, 0x000fea0003800000ULL, 0x000000015d207824ULL, 0x000fe200078e0270ULL,
0x000000091e187c48ULL, 0x000fe2000ffe0000ULL, 0x00000010121f7824ULL, 0x000fe200078e00ffULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000000120177824ULL, 0x040fe200078e021dULL,
0x0000000720227c11ULL, 0x000fe2000f8e10ffULL, 0x0000000118187824ULL, 0x000fe200078e0a1eULL,
0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL, 0x018a000022147984ULL, 0x000e620000000800ULL,
0x000000185d187248ULL, 0x000fc80007fe0000ULL, 0x000000185d217210ULL, 0x000fe40007ffe1ffULL,
0x0000000714197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0007240000000800ULL, 0x0000000120197824ULL, 0x048fe400078e0212ULL,
0x0000001020207824ULL, 0x000fca00078e00ffULL, 0xfffffff020197812ULL, 0x000fe200078ee219ULL,
0x0000000270207836ULL, 0x000fc60000000000ULL, 0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124197824ULL, 0x000fe400078e021dULL,
0x0000000616177c24ULL, 0x010fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000001f16167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x000000217000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000f101c4aULL, 0x018a080022187984ULL, 0x000ee20000000800ULL,
0x0000000124167824ULL, 0x042fe400078e0212ULL, 0x0000001024177824ULL, 0x000fca00078e00ffULL,
0xfffffff017167812ULL, 0x000fc800078ee216ULL, 0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000001f18187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x000000212000720cULL, 0x000fe20003fc6070ULL, 0x0000000470207836ULL, 0x000fe40000000000ULL,
0x0000000670707836ULL, 0x000fe40000000000ULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124177824ULL, 0x000fc800078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000f101c4aULL, 0x018a100022167984ULL, 0x000ee20000000800ULL,
0x0000001024197824ULL, 0x002fe200078e00ffULL, 0x0000001224187210ULL, 0x000fc80007ffe0ffULL,
0xfffffff019187812ULL, 0x000fc800078ee218ULL, 0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL,
0x00000007161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x0002e40000000800ULL,
0x000000015d1e7824ULL, 0x002fc800078e0270ULL, 0x000000011e1d7824ULL, 0x000fe400078e021dULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000001f16167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x000000212000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000f101c4aULL, 0x018a180022187984ULL, 0x000ee20000000800ULL,
0x000000011e167824ULL, 0x042fe400078e0212ULL, 0x000000101e177824ULL, 0x000fca00078e00ffULL,
0xfffffff017167812ULL, 0x000fc800078ee216ULL, 0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x00000006181d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc600078e0014ULL,
0x0000001f14147210ULL, 0x000fca0007fde0ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x000000217000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000f101c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015d707824ULL, 0x000fe200078e0270ULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000001012197824ULL, 0x000fe400078e00ffULL, 0x0000000170177824ULL, 0x040fe200078e021dULL,
0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL, 0x00000010701e7824ULL, 0x040fe200078e00ffULL,
0x000000f019217812ULL, 0x000fe200078ec0ffULL, 0x0000000170197824ULL, 0x000fe400078e0212ULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x0000000270207836ULL, 0x000fc40000000000ULL,
0xfffffff01e197812ULL, 0x000fe400078ee219ULL, 0x0000000120227824ULL, 0x040fe400078e0212ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000120197824ULL, 0x000fe200078e021dULL,
0x0000000714187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fc80007fde0ffULL,
0x00000017ff177210ULL, 0x000fca00037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4aULL, 0x018a08001f187984ULL, 0x000ee20000000800ULL,
0x0000001020177824ULL, 0x002fe400078e00ffULL, 0x0000000470207836ULL, 0x000fe40000000000ULL,
0x0000000670707836ULL, 0x000fe20000000000ULL, 0xfffffff017227812ULL, 0x000fe200078ee222ULL,
0x0000000120177824ULL, 0x000fc400078e021dULL, 0x00000001701d7824ULL, 0x000fe200078e021dULL,
0x0000000e22237c11ULL, 0x000fe4000f8e20ffULL, 0x0000001220227210ULL, 0x000fe40007ffe0ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fca00030e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4aULL,
0x018a10001f167984ULL, 0x000ee20000000800ULL, 0x0000001020197824ULL, 0x002fca00078e00ffULL,
0xfffffff019227812ULL, 0x000fc800078ee222ULL, 0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL,
0x00000007161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4aULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x00000006181d7c24ULL, 0x008fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x00000001701d7824ULL, 0x040fe200078e0212ULL,
0x0000002114147210ULL, 0x000fe20007fde0ffULL, 0x0000001070707824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0xfffffff0701d7812ULL, 0x000fc800078ee21dULL,
0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e4000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fc800078d10ffULL, 0x00000015ff157210ULL, 0x000fc800037fe4ffULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000001ff547424ULL, 0x000fc600078e00ffULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000001c5f00720cULL, 0x000fe20003fc4070ULL,
0x00009400ff187b82ULL, 0x000e620000000800ULL, 0x000000076e197c11ULL, 0x000fe4000f8e10ffULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a177207ULL, 0x000fc60007000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ee20000000a00ULL,
0x000000015c177824ULL, 0x000fe400078e0217ULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016167836ULL, 0x000fc80000000000ULL,
0x0000001817177224ULL, 0x102fe400078e0216ULL, 0x000000016e167824ULL, 0x040fe400078e0216ULL,
0x000000016e177824ULL, 0x000fc600078e0217ULL, 0x0000000916007c0cULL, 0x000fe2000bfc6070ULL,
0x0000000417147825ULL, 0x008fd800078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000f12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a48ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b7854ff5479a7ULL, 0x000e620008500007ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x004fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0004e800000e0000ULL,
0x00001f6414047589ULL, 0x00046400000e0000ULL, 0x01300000671c783bULL, 0x0006a20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x082fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000006618783bULL, 0x000f280000004200ULL,
0x000000006514783bULL, 0x004ea20000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x004fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x000fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x013000006818783bULL, 0x0004e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x004fde0003800000ULL,
0x0000000318187232ULL, 0x088fe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x082fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006a14783bULL, 0x000ea20000004200ULL, 0x000000ff3800720cULL, 0x000fe20003f45270ULL,
0x0000034000007945ULL, 0x000fe40003800000ULL, 0x000000006938783bULL, 0x000f220000004200ULL,
0x00003120146e7816ULL, 0x004fe400000000ffULL, 0x00003120156f7816ULL, 0x000fe400000000ffULL,
0x0000006eff14723eULL, 0x000fe400020006ffULL, 0x0000006fff15723eULL, 0x000fc400020006ffULL,
0x00003120166d7816ULL, 0x000fe400000000ffULL, 0x0000312017707816ULL, 0x000fe400000000ffULL,
0x0000006eff16723eULL, 0x000fe200030006ffULL, 0x00000014183c723cULL, 0x008fe2000000183cULL,
0x0000006fff17723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x010fe400000000ffULL,
0x0000312039397816ULL, 0x000fc400000000ffULL, 0x0000006dff14723eULL, 0x000fe200020006ffULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x00000070ff15723eULL, 0x000fcc00020006ffULL,
0x0000006dff16723eULL, 0x000fe200030006ffULL, 0x000000141830723cULL, 0x000fe20000001830ULL,
0x00000070ff17723eULL, 0x000fcc00030006ffULL, 0x00000038ff14723eULL, 0x000fe200020006ffULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x00000039ff15723eULL, 0x000fcc00020006ffULL,
0x00000038ff16723eULL, 0x000fe200030006ffULL, 0x000000141828723cULL, 0x000fe20000001828ULL,
0x00000039ff17723eULL, 0x000fcc00030006ffULL, 0x000031203a147816ULL, 0x000fe200000000ffULL,
0x000000161824723cULL, 0x000fe20000001824ULL, 0x000031203b157816ULL, 0x000fcc00000000ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0001000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x0000003510107221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002051517221ULL, 0x000fe20000010000ULL, 0x0000002152527221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x002fc600078e0055ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000100147802ULL, 0x000fe20000000f00ULL,
0x000000016c6c7836ULL, 0x000fc60000000000ULL, 0x018b8814ff1679a7ULL, 0x000e640008500007ULL,
0x0000006b6c00720cULL, 0x000fe20003f46070ULL, 0x000000ffff1c7224ULL, 0x002fd800078e0017ULL,
0xffffffc000eca947ULL, 0x000fea000383ffffULL, 0x018b6814ffff79a7ULL, 0x0003e40008500007ULL,
0x000000c008147811ULL, 0x002fc800078e40ffULL, 0x0000000914007c0cULL, 0x000fda000bf46070ULL,
0x0000003c001c2947ULL, 0x000fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fce00078e00ffULL,
0x00000002ff177819ULL, 0x000fe4000001166cULL, 0x000000036c1b7812ULL, 0x040fe400078ec0ffULL,
0x000000176c177207ULL, 0x000fe40000000000ULL, 0x000000ff1b1b7207ULL, 0x000fc60004000000ULL,
0x00000003171f7836ULL, 0x000fca0000000000ULL, 0x000000031f1d7812ULL, 0x040fe400078ec0ffULL,
0x000000081f1a7211ULL, 0x000fe400078ff0ffULL, 0x0000000000187805ULL, 0x000fe20000015200ULL,
0x018b7815ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fce00078e00ffULL, 0x000000101e00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001618217210ULL, 0x000fca0007f5e1ffULL, 0x0000000117177824ULL, 0x000fe200010e0e19ULL,
0x003d09002100780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011417ULL, 0x0000002114147211ULL, 0x000fca00078510ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x0000000214147819ULL, 0x000fc80000001217ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011e1e7836ULL, 0x000fce0000000000ULL, 0x018b7815ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b881cff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fc800078510ffULL,
0x00000015ff157210ULL, 0x000fc800017fe4ffULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b881cff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011a157836ULL, 0x000fe20000000000ULL,
0x00000004ff707819ULL, 0x000fe20000011612ULL, 0x000000041a147824ULL, 0x000fc600078e021dULL,
0x0000000c15007c0cULL, 0x000fe4000bf46070ULL, 0x0000002014187811ULL, 0x000fc800078e30ffULL,
0x000000605b1c7812ULL, 0x000fce00078ef818ULL, 0x000000040054a947ULL, 0x000fea0003800000ULL,
0x000000015d237824ULL, 0x000fe200078e0270ULL, 0x0000000918167c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121e7824ULL, 0x000fe200078e00ffULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000270227836ULL, 0x000fe20000000000ULL, 0x0000000723207c11ULL, 0x040fe2000f8e10ffULL,
0x0000000116167824ULL, 0x000fe200078e0a18ULL, 0x000000f01e257812ULL, 0x000fe200078ec0ffULL,
0x0000000123187824ULL, 0x000fe400078e021cULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x000000165d167248ULL, 0x000fe20007fe0000ULL, 0x000000015d277824ULL, 0x000fc800078e0222ULL,
0x0000000116217824ULL, 0x000fe400078e0a5dULL, 0x0000000127247824ULL, 0x000fc600078e0212ULL,
0x000000217000720cULL, 0x000fe40003f46070ULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019177984ULL, 0x0004e40000000800ULL,
0x0000000127197824ULL, 0x044fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027247812ULL, 0x000fe200078ee224ULL, 0x0000000617177c24ULL, 0x008fe4000f8e0218ULL,
0x0000000123187824ULL, 0x000fe400078e0212ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x0000002516167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff023187812ULL, 0x000fe400078ee218ULL, 0x00000017ff177210ULL, 0x000fe40001ffe4ffULL,
0x0000000e18237c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fe20003f46070ULL,
0x0000000470227836ULL, 0x000fe40000000000ULL, 0x018a080020187984ULL, 0x000ea40000000800ULL,
0x000000015d277824ULL, 0x000fe200078e0222ULL, 0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL,
0x0000000127247824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe200078e021cULL,
0x0000000427277819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fe40003f46070ULL,
0xfffffff027247812ULL, 0x000fe200078ee224ULL, 0x018a100020187984ULL, 0x000ea60000000800ULL,
0x0000000e24237c11ULL, 0x002fc4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x00000006701e7836ULL, 0x002fc80000000000ULL,
0x000000015d277824ULL, 0x000fe400078e021eULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x00000001271c7824ULL, 0x040fe200078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x000000211e00720cULL, 0x000fe40003f46070ULL, 0x018a180020187984ULL, 0x000ea40000000800ULL,
0xfffffff0271c7812ULL, 0x000fc800078ee21cULL, 0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc600078e0014ULL,
0x0000002514147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d217824ULL, 0x000fe200078e0270ULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000121177824ULL, 0x040fe200078e021cULL, 0x0000000721207c11ULL, 0x040fe2000f8e10ffULL,
0x00000010211e7824ULL, 0x000fe200078e00ffULL, 0x000000f019237812ULL, 0x000fe200078ec0ffULL,
0x0000000221277836ULL, 0x000fe20000000000ULL, 0x0000001221197210ULL, 0x000fe20007ffe0ffULL,
0x018a000020147984ULL, 0x000e640000000800ULL, 0x0000000127227824ULL, 0x000fe200078e0212ULL,
0xfffffff01e197812ULL, 0x000fc800078ee219ULL, 0x0000000e19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027227812ULL, 0x000fe200078ee222ULL, 0x0000000421277836ULL, 0x000fe40000000000ULL,
0x0000000621217836ULL, 0x000fe20000000000ULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000616177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000b901c4aULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL,
0x0000000127177824ULL, 0x040fe400078e021cULL, 0x0000000127227824ULL, 0x040fe200078e0212ULL,
0x0000000427277819ULL, 0x000fc800000006ffULL, 0xfffffff027227812ULL, 0x000fe400078ee222ULL,
0x00000007181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4aULL,
0x018a100020167984ULL, 0x000ea20000000800ULL, 0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL,
0x0000000121197824ULL, 0x040fe400078e021cULL, 0x00000010211c7824ULL, 0x000fe200078e00ffULL,
0x00000007161e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000b901c4aULL,
0x018a180020187984ULL, 0x000ea40000000800ULL, 0x0000000718187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x0000000121197824ULL, 0x000fe200078e0212ULL,
0x0000002314147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff01c197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000e19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fc800078510ffULL,
0x00000015ff157210ULL, 0x000fc800017fe4ffULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x000000011f1f7812ULL, 0x000fe200078ec0ffULL,
0x00000020616e7824ULL, 0x000fe200078e0212ULL, 0x000000031b00780cULL, 0x000fc80005745270ULL,
0x000000011f00780cULL, 0x000fda0001745470ULL, 0x00000000004c2947ULL, 0x000fea0003800000ULL,
0x000000036e00780cULL, 0x000fe20003f44070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000000413167824ULL, 0x000fe200078e026eULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000417187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x000000011b147836ULL, 0x002fe20000000000ULL, 0x00009400ff187b82ULL, 0x000e680000000800ULL,
0x0000000314167812ULL, 0x000fc800078ec0ffULL, 0x000000ff16197207ULL, 0x000fc60005000000ULL,
0x00000002ff14a819ULL, 0x000fe40000011614ULL, 0x000000195c167210ULL, 0x000fc60007ffe0ffULL,
0x000000011d1d7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ea40000000a00ULL,
0x000000401d177824ULL, 0x040fe200078e00ffULL, 0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL,
0x000000c017177812ULL, 0x000fca00078ec0ffULL, 0x000001001a177824ULL, 0x000fc800078e0217ULL,
0x000000016e197824ULL, 0x100fe400078e0217ULL, 0x0000001816177224ULL, 0x002fc600078e0217ULL,
0x0000000919007c0cULL, 0x000fe2000bf46070ULL, 0x000000016e177824ULL, 0x040fe200078e0217ULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000417147825ULL, 0x004fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801cff1479a7ULL, 0x000e620008500007ULL, 0x000000ff6c00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018b381c5d1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018b38185d0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018b38185d0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001012077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe40000011612ULL,
0x0000000900167202ULL, 0x000fe40000000f00ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000007141b7c10ULL, 0x000fca000fffe007ULL,
0x018180001b147984ULL, 0x000e680000000800ULL, 0x018380001b157984ULL, 0x0004a20000000800ULL,
0x000000091400720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000091400720bULL, 0x000fe40003f54000ULL,
0x000000036100780cULL, 0x000fe40003f65270ULL, 0x0000001409167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018580161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001609097221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900177308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f6317097589ULL, 0x006e6400000e0000ULL,
0x000000090b0b7220ULL, 0x082fe20000410000ULL, 0x000000090c0c7220ULL, 0x080fe20000410000ULL,
0x000000090f0f7220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x0000000942427220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x000000094a4a7220ULL, 0x080fe20000410000ULL,
0x000000094d4d7220ULL, 0x080fe20000410000ULL, 0x000000094e4e7220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x0000000958587220ULL, 0x000fce0000410000ULL,
0x000000170a0a7220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f6417097589ULL, 0x002e6400000e0000ULL, 0x000000090d0d7220ULL, 0x082fe20000410000ULL,
0x000000090e0e7220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000940407220ULL, 0x080fe20000410000ULL, 0x0000000943437220ULL, 0x080fe20000410000ULL,
0x0000000944447220ULL, 0x080fe20000410000ULL, 0x0000000947477220ULL, 0x080fe20000410000ULL,
0x0000000948487220ULL, 0x080fe20000410000ULL, 0x000000094b4b7220ULL, 0x080fe20000410000ULL,
0x000000094c4c7220ULL, 0x080fe20000410000ULL, 0x000000094f4f7220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000959597220ULL, 0x080fe20000410000ULL,
0x000000095a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001614142221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL, 0x0000001400062308ULL, 0x000ea40000000800ULL,
0x0000000615152220ULL, 0x004fce0000410000ULL, 0x0000000a150a7221ULL, 0x000fe20000010000ULL,
0x000000ffff097224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0002a800000e0000ULL,
0x00001f6414047589ULL, 0x0002e400000e0000ULL, 0x01380000051c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x080fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x002fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x008fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x013800005e18783bULL, 0x0002e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x08cfe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006214783bULL, 0x000e620000004200ULL, 0x0000006c6300720cULL, 0x000fe20003f66070ULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x000000085f00720cULL, 0x040fe20003fc3070ULL,
0x000000006038783bULL, 0x000f220000004200ULL, 0x0000006c6400720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x0000312014547816ULL, 0x002fe400000000ffULL,
0x0000312015557816ULL, 0x000fc400000000ffULL, 0x00000054ff14723eULL, 0x000fe400020006ffULL,
0x00000055ff15723eULL, 0x000fe400020006ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000054ff54723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x00000055ff55723eULL, 0x000fcc00030006ffULL,
0x00000016ff14723eULL, 0x000fe200020006ffULL, 0x000000541834723cULL, 0x000fe20000001834ULL,
0x00000017ff15723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe400030006ffULL,
0x00000017ff17723eULL, 0x000fc600030006ffULL, 0x000000141830723cULL, 0x000fec0000001830ULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x0000312038147816ULL, 0x010fe200000000ffULL,
0x000000016c387836ULL, 0x000fe20000000000ULL, 0x0000312039157816ULL, 0x000fc800000000ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fe400030006ffULL,
0x000000386300720cULL, 0x080fe20005f66470ULL, 0x000000161828723cULL, 0x000fe20000001828ULL,
0x000000386400720cULL, 0x000fca0006786470ULL, 0x000000141824723cULL, 0x000fee0000001824ULL,
0x000031203a147816ULL, 0x000fe400000000ffULL, 0x000031203b157816ULL, 0x000fe400000000ffULL,
0x00000014ff16723eULL, 0x000fc400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x0000003510107221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8816ff1479a7ULL, 0x000e620008500007ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000085f00720cULL, 0x0c0fe40003fc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x000000085f00720cULL, 0x000fe20003fa3070ULL, 0x0000000317177836ULL, 0x000fe20000000000ULL,
0x00000040ff387803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000008171c7211ULL, 0x000fe200078ff0ffULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fc80007fde1ffULL, 0x0000001517157210ULL, 0x000fe400037fe5ffULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000041c147824ULL, 0x000fc800078e021bULL,
0x00000040141e7824ULL, 0x000fe400078e00ffULL, 0x000000011c147836ULL, 0x000fc60000000000ULL,
0x000000405b1d7812ULL, 0x000fe400078ef81eULL, 0x0000000c14007c0cULL, 0x000fda000bfc6070ULL,
0x000000040054e947ULL, 0x000fea0003800000ULL, 0x000000015d207824ULL, 0x000fe200078e0270ULL,
0x000000091e187c48ULL, 0x000fe2000ffe0000ULL, 0x00000010121f7824ULL, 0x000fe200078e00ffULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000000120177824ULL, 0x040fe200078e021dULL,
0x0000000720227c11ULL, 0x000fe4000f8e10ffULL, 0x000000181e187210ULL, 0x000fe40007ffe1ffULL,
0x000000f01f1f7812ULL, 0x000fe200078ec0ffULL, 0x018a000022147984ULL, 0x000e620000000800ULL,
0x000000185d187248ULL, 0x000fca0007fe0000ULL, 0x0000000118217824ULL, 0x000fe200078e0a5dULL,
0x0000000714197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0007240000000800ULL, 0x0000000120197824ULL, 0x048fe400078e0212ULL,
0x0000001020207824ULL, 0x000fca00078e00ffULL, 0xfffffff020197812ULL, 0x000fe200078ee219ULL,
0x0000000270207836ULL, 0x000fc60000000000ULL, 0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124197824ULL, 0x000fe400078e021dULL,
0x0000000616177c24ULL, 0x010fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000001f16167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x000000217000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000f101c4aULL, 0x018a080022187984ULL, 0x000ee20000000800ULL,
0x0000000124167824ULL, 0x042fe400078e0212ULL, 0x0000001024177824ULL, 0x000fca00078e00ffULL,
0xfffffff017167812ULL, 0x000fc800078ee216ULL, 0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000001f18187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x000000212000720cULL, 0x000fe40003fc6070ULL, 0x0000000470207810ULL, 0x000fe20007ffe0ffULL,
0x0000000670707836ULL, 0x000fc80000000000ULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124177824ULL, 0x040fe400078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000f101c4aULL, 0x018a100022167984ULL, 0x000ee20000000800ULL,
0x0000000124187824ULL, 0x042fe400078e0212ULL, 0x0000001024197824ULL, 0x000fca00078e00ffULL,
0xfffffff019187812ULL, 0x000fc800078ee218ULL, 0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL,
0x00000007161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x0002e40000000800ULL,
0x000000015d1e7824ULL, 0x002fc800078e0270ULL, 0x000000011e1d7824ULL, 0x000fe400078e021dULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000001f16167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x000000212000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000f101c4aULL, 0x018a180022187984ULL, 0x000ee20000000800ULL,
0x000000101e177824ULL, 0x002fe200078e00ffULL, 0x000000121e167210ULL, 0x000fc80007ffe0ffULL,
0xfffffff017167812ULL, 0x000fc800078ee216ULL, 0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x00000006181d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc600078e0014ULL,
0x0000001f14147210ULL, 0x000fca0007fde0ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x000000217000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000f101c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015d707824ULL, 0x000fe200078e0270ULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000001012197824ULL, 0x000fe400078e00ffULL, 0x0000000170177824ULL, 0x040fe200078e021dULL,
0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL, 0x00000010701e7824ULL, 0x040fe200078e00ffULL,
0x000000f019217812ULL, 0x000fe200078ec0ffULL, 0x0000000170197824ULL, 0x000fe400078e0212ULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x0000000270207836ULL, 0x000fc40000000000ULL,
0xfffffff01e197812ULL, 0x000fe400078ee219ULL, 0x0000000120227824ULL, 0x040fe400078e0212ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000120197824ULL, 0x000fe200078e021dULL,
0x0000000714187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4aULL, 0x018a08001f187984ULL, 0x000ee20000000800ULL,
0x0000001020177824ULL, 0x002fe400078e00ffULL, 0x0000000470207836ULL, 0x000fe40000000000ULL,
0x0000000670707836ULL, 0x000fe20000000000ULL, 0xfffffff017227812ULL, 0x000fe200078ee222ULL,
0x0000000120177824ULL, 0x000fc400078e021dULL, 0x00000001701d7824ULL, 0x000fe200078e021dULL,
0x0000000e22237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000120227824ULL, 0x000fe200078e0212ULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fc80007fde0ffULL, 0x00000019ff197210ULL, 0x000fca00037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4aULL,
0x018a10001f167984ULL, 0x000ee20000000800ULL, 0x0000001020197824ULL, 0x002fca00078e00ffULL,
0xfffffff019227812ULL, 0x000fc800078ee222ULL, 0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL,
0x00000007161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4aULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x00000006181d7c24ULL, 0x008fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x00000001701d7824ULL, 0x040fe200078e0212ULL,
0x0000002114147210ULL, 0x000fe20007fde0ffULL, 0x0000001070707824ULL, 0x000fc600078e00ffULL,
0x00000015ff157210ULL, 0x000fe400037fe4ffULL, 0xfffffff0701d7812ULL, 0x000fc800078ee21dULL,
0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e4000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000001ff547424ULL, 0x000fc600078e00ffULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000001c5f00720cULL, 0x000fe20003fc4070ULL,
0x00009400ff187b82ULL, 0x000e620000000800ULL, 0x000000076e197c11ULL, 0x000fe4000f8e10ffULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a177207ULL, 0x000fe40007000000ULL,
0x000000141b1b7210ULL, 0x000fe40007ffe0ffULL, 0x00009200ff147b82ULL, 0x000ee20000000a00ULL,
0x000000015c177824ULL, 0x000fc400078e0217ULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016167836ULL, 0x000fc80000000000ULL,
0x0000001817177224ULL, 0x102fe400078e0216ULL, 0x000000016e167824ULL, 0x040fe400078e0216ULL,
0x000000016e177824ULL, 0x000fc600078e0217ULL, 0x0000000916007c0cULL, 0x000fe2000bfc6070ULL,
0x0000000417147825ULL, 0x008fd800078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000f12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a48ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b7854ff5479a7ULL, 0x000e620008500007ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x004fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0004e800000e0000ULL,
0x00001f6414047589ULL, 0x00046400000e0000ULL, 0x01380000671c783bULL, 0x0006a20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x082fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000006618783bULL, 0x000f280000004200ULL,
0x000000006514783bULL, 0x004ea20000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x004fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x000fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x013800006818783bULL, 0x0004e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x004fde0003800000ULL,
0x0000000318187232ULL, 0x088fe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x082fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006a14783bULL, 0x000ea20000004200ULL, 0x000000ff3800720cULL, 0x000fe20003f45270ULL,
0x0000034000007945ULL, 0x000fe40003800000ULL, 0x000000006938783bULL, 0x000f220000004200ULL,
0x00003120146e7816ULL, 0x004fe400000000ffULL, 0x00003120156f7816ULL, 0x000fe400000000ffULL,
0x0000006eff14723eULL, 0x000fe400020006ffULL, 0x0000006fff15723eULL, 0x000fc400020006ffULL,
0x00003120166d7816ULL, 0x000fe400000000ffULL, 0x0000312017707816ULL, 0x000fe400000000ffULL,
0x0000006eff16723eULL, 0x000fe200030006ffULL, 0x00000014183c723cULL, 0x008fe2000000183cULL,
0x0000006fff17723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x010fe400000000ffULL,
0x0000312039397816ULL, 0x000fc400000000ffULL, 0x0000006dff14723eULL, 0x000fe200020006ffULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x00000070ff15723eULL, 0x000fcc00020006ffULL,
0x0000006dff16723eULL, 0x000fe200030006ffULL, 0x000000141830723cULL, 0x000fe20000001830ULL,
0x00000070ff17723eULL, 0x000fcc00030006ffULL, 0x00000038ff14723eULL, 0x000fe200020006ffULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x00000039ff15723eULL, 0x000fcc00020006ffULL,
0x00000038ff16723eULL, 0x000fe200030006ffULL, 0x000000141828723cULL, 0x000fe20000001828ULL,
0x00000039ff17723eULL, 0x000fcc00030006ffULL, 0x000031203a147816ULL, 0x000fe200000000ffULL,
0x000000161824723cULL, 0x000fe20000001824ULL, 0x000031203b157816ULL, 0x000fcc00000000ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0001000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x0000003510107221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002051517221ULL, 0x000fe20000010000ULL, 0x0000002152527221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x002fc600078e0055ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x000000016c6c7836ULL, 0x000fe40000000000ULL, 0x018b8814ff1679a7ULL, 0x000e660008500007ULL,
0x0000006b6c00720cULL, 0x000fe40003f46070ULL, 0x00000017001c7202ULL, 0x002fd60000000f00ULL,
0xffffffc000eca947ULL, 0x000fea000383ffffULL, 0x018b7014ffff79a7ULL, 0x0003e40008500007ULL,
0x0000000108087836ULL, 0x000fca0000000000ULL, 0x0000000c08007c0cULL, 0x000fda000bf06070ULL,
0xffffff0800688947ULL, 0x000fea000383ffffULL, 0x0000000cff007c0cULL, 0x000fe2000bf05270ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff117224ULL, 0x000fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e000eULL, 0x000000ffff097224ULL, 0x000fcc00078e000cULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x018000000a007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0001140000047802ULL, 0x002fce0000000f00ULL, 0x0000007c00c07944ULL, 0x004fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000a00037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc8000000000aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f240000000a00ULL, 0x0000000a02037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x01cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000000b040b7220ULL, 0x042fe20000410000ULL, 0x0000000904097220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000004204427220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004604467220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004a044a7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000004e044e7220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000005204527220ULL, 0x040fe20000410000ULL,
0x0000005704577220ULL, 0x040fe20000410000ULL, 0x0000005804587220ULL, 0x000fe20000410000ULL,
0x0000000d050d7220ULL, 0x044fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000004005407220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000004405447220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004805487220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004c054c7220ULL, 0x040fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005005507220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005905597220ULL, 0x040fe20000410000ULL, 0x0000005a055a7220ULL, 0x000fce0000410000ULL,
0x0000000000147919ULL, 0x002e620000000000ULL, 0x0000000761617c11ULL, 0x000fe2000f8e58ffULL,
0x00000000000479c3ULL, 0x000ee20000002600ULL, 0x0000004d4e4d723eULL, 0x000fce00000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000515251723eULL, 0x000fe400000000ffULL,
0x000000575857723eULL, 0x000fe400000000ffULL, 0x000000434443723eULL, 0x000fc400000000ffULL,
0x000000474847723eULL, 0x000fe400000000ffULL, 0x0000004b4c4b723eULL, 0x000fe400000000ffULL,
0x0000004f504f723eULL, 0x000fe400000000ffULL, 0x000000535653723eULL, 0x000fe400000000ffULL,
0x000000595a59723eULL, 0x000fe400000000ffULL, 0x000054104b4e7816ULL, 0x000fc4000000004fULL,
0x000076324b4f7816ULL, 0x000fe4000000004fULL, 0x0000541053587816ULL, 0x000fe40000000059ULL,
0x00000002ff077819ULL, 0x002fe40000011614ULL, 0x0000000214007812ULL, 0x040fe400078ec0ffULL,
0x0000000814057811ULL, 0x000fe200078ff0ffULL, 0x0000000807087824ULL, 0x000fe200078e00ffULL,
0x0000000700027211ULL, 0x004fc400078ff8ffULL, 0x0000000500037211ULL, 0x000fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000307157819ULL, 0x040fe200000006ffULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000763253597816ULL, 0x000fe20000000059ULL,
0x0000000202007836ULL, 0x000fe20000000000ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL,
0x0000000402037836ULL, 0x000fe40000000000ULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0xfffffff805067812ULL, 0x000fc400078ee200ULL, 0x00000003ff057819ULL, 0x100fe40000011614ULL,
0xfffffff815007812ULL, 0x000fe200078ee202ULL, 0x0000000602027836ULL, 0x000fe20000000000ULL,
0xfffffff808087812ULL, 0x000fe200078ee203ULL, 0x0000000105047824ULL, 0x000fe400078e0214ULL,
0x0001200061037836ULL, 0x000fe20000000000ULL, 0xfffffff8070a7812ULL, 0x000fe200078ee202ULL,
0x0000000814027824ULL, 0x000fe200078e00ffULL, 0x0000000704077812ULL, 0x000fe200078ec0ffULL,
0x0000001000047824ULL, 0x100fe200078e0203ULL, 0x0000000306067211ULL, 0x000fe200078e20ffULL,
0x000000100c0c7824ULL, 0x100fe200078e0203ULL, 0x0ffffff807007812ULL, 0x000fe200078ef814ULL,
0x0000001008087824ULL, 0x100fe200078e0203ULL, 0x0000000714147812ULL, 0x000fe200078ec0ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0x0000000802037812ULL, 0x000fe200078ec0ffULL,
0x0000001000617824ULL, 0x000fe200078e0261ULL, 0x0000000b0900723eULL, 0x000fc400000000ffULL,
0x0000000f1102723eULL, 0x000fe200000000ffULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x1ffffff8145d7812ULL, 0x000fe200078ef85dULL, 0x0000000103067824ULL, 0x040fe200078e0206ULL,
0x00005410000e7816ULL, 0x040fe20000000002ULL, 0x00000001030c7824ULL, 0x040fe200078e020cULL,
0x00007632000f7816ULL, 0x000fe20000000002ULL, 0x0000000103087824ULL, 0x040fe200078e0208ULL,
0x000000414200723eULL, 0x000fe200000000ffULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x000000454602723eULL, 0x000fe200000000ffULL, 0x0000000e04007388ULL, 0x0003e20000000a00ULL,
0x000000494a03723eULL, 0x000fc400000000ffULL, 0x0000541043467816ULL, 0x140fe40000000047ULL,
0x0000763243477816ULL, 0x000fe40000000047ULL, 0x00005410000e7816ULL, 0x142fe40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x0000000d1000723eULL, 0x000fe400000000ffULL,
0x000000124002723eULL, 0x000fe200000000ffULL, 0x0000000e06007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x002fc4000000004dULL, 0x00007632030f7816ULL, 0x000fca000000004dULL,
0x0000000e08007388ULL, 0x0003e40000000a00ULL, 0x00005410510e7816ULL, 0x142fe40000000057ULL,
0x00007632510f7816ULL, 0x000fca0000000057ULL, 0x0000000e0a007388ULL, 0x0003e40000000a00ULL,
0x00005410000e7816ULL, 0x142fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x00008400ff007b82ULL, 0x000e660000000800ULL, 0x0000000e0c007388ULL, 0x000fe80000000a00ULL,
0x0004004606007388ULL, 0x000fe80000000a00ULL, 0x0004004e08007388ULL, 0x000fe80000000a00ULL,
0x000400580a007388ULL, 0x000fe20000000a00ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x01200000610c7984ULL, 0x000ea20000000c00ULL, 0x0000000013137224ULL, 0x082fe400078e02ffULL,
0x0000000405007e24ULL, 0x008fe2000f8e0200ULL, 0x0000860000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000013007211ULL, 0x000fca00078010ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0000000400027c11ULL, 0x000fc8000f8048ffULL, 0x0000000500037c11ULL, 0x000fc600080f4c03ULL,
0x000000105d027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x004fe2000c101d0aULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x000fe20003f44070ULL,
0x00009400ff037b82ULL, 0x000e620000000800ULL, 0x00000006614b7819ULL, 0x040fe200000006ffULL,
0x0000002002047836ULL, 0x000fe20000000000ULL, 0x00000001ff477819ULL, 0x000fe40000011661ULL,
0x0000000761497c11ULL, 0x000fe2000f8e40ffULL, 0x000000014b057824ULL, 0x040fe400078e0204ULL,
0x00009200ff087b82ULL, 0x000ea20000000a00ULL, 0x000000014b067824ULL, 0x000fc400078e0202ULL,
0x0000000905007c0cULL, 0x000fe2000bf26070ULL, 0x000000041305a824ULL, 0x000fe200078e0202ULL,
0x000000054700ac0cULL, 0x000fe2000bf66070ULL, 0x00000004020f7824ULL, 0x000fe200078e0249ULL,
0x0000000906007c0cULL, 0x000fe2000bf06070ULL, 0x00009000ff0eab82ULL, 0x000ef00000000800ULL,
0x00008c00ff0aab82ULL, 0x000f220000000a00ULL, 0x000000035c037224ULL, 0x002fc800078e024bULL,
0x0000000103077824ULL, 0x040fe400078e0202ULL, 0x0000000103037824ULL, 0x000fe200078e0204ULL,
0x00009a00ff0c7b82ULL, 0x000e620000000a00ULL, 0x000000020504a824ULL, 0x000fe200078e00ffULL,
0x000000076105ac11ULL, 0x000fe2000f8e20ffULL, 0x0000000407067825ULL, 0x004fc600078e0008ULL,
0x000000050211a211ULL, 0x000fe200078e10ffULL, 0x0000000403087825ULL, 0x000fc800078e0008ULL,
0x0000000e0403a224ULL, 0x008fe400078e0247ULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x00000004030aa825ULL, 0x010fc800078e000aULL, 0x018ad004ff0479a7ULL, 0x000ea20008500007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18600000060f7faeULL, 0x0007e8000c12184aULL,
0x18680000080f7faeULL, 0x0007e8000c92184aULL, 0x18a800000a11afaeULL, 0x0007e8000d92184aULL,
0x00000000000079afULL, 0x000e280000000000ULL, 0x0000000a0c037981ULL, 0x002722000c1e9900ULL,
0x000001ff0800788cULL, 0x000fe2000bf04070ULL, 0x0000008000007824ULL, 0x000fe200078e00ffULL,
0x0000000706067899ULL, 0x000fc8000800063fULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x0000004000047812ULL, 0x004fe200078ef84bULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000001000a40947ULL, 0x008fea0003800000ULL,
0x00000003ff097819ULL, 0x100fe40000011602ULL, 0x0000000761087c11ULL, 0x000fe4000f8e20ffULL,
0x000000094b0e7c48ULL, 0x000fe2000ffe0000ULL, 0x00000004090a7824ULL, 0x040fe400078e0249ULL,
0x00000001040c7824ULL, 0x000fe400078e0209ULL, 0x00000001090f7824ULL, 0x000fe200078e0202ULL,
0x018600000a077984ULL, 0x000e620000000800ULL, 0x000000010e0e7824ULL, 0x000fc600078e0a4bULL,
0x000000070f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000e0900720cULL, 0x000fe20003f06070ULL,
0x00000004070d7824ULL, 0x002fe400078e0208ULL, 0x00008a00ff067b82ULL, 0x000e660000000a00ULL,
0x018a80000d0b7984ULL, 0x0004e40000000800ULL, 0x0ffffff80f0d7812ULL, 0x004fe200078ef802ULL,
0x000000060b117c24ULL, 0x008fe2000f8e020cULL, 0x00000070100b7812ULL, 0x000fc400078ec0ffULL,
0x00000007610c7c11ULL, 0x000fe2000f8e70ffULL, 0x0000010011107825ULL, 0x002fc800078e0006ULL,
0x000020000c0c7836ULL, 0x000fe20000000000ULL, 0x000000100b147210ULL, 0x000fc60007f3e0ffULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018610000a0f7984ULL, 0x000ea40000000800ULL, 0x000000080f167211ULL, 0x004fe200078e10ffULL,
0x00000004090f7836ULL, 0x000fc80000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018620000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000008090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe40003f06070ULL,
0x000000020f127210ULL, 0x000fe20007ffe0ffULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018630000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x0000000c090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fc800078ee212ULL, 0x0000000c0d0d7211ULL, 0x000fe200078e20ffULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018640000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000010090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018650000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000014090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x000000010f127824ULL, 0x040fe200078e0202ULL, 0x0000000f04117210ULL, 0x000fe40007ffe0ffULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018660000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000018090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff157210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018670000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x0000001c090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018680000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe200078e0208ULL,
0x00000020090f7810ULL, 0x000fc80007ffe0ffULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018690000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000024090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe200078e0202ULL, 0x000000030f0f7819ULL, 0x000fc800000006ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186a0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000028090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186b0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000080f167211ULL, 0x004fe200078e10ffULL,
0x0000002c090f7836ULL, 0x000fc80000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186c0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000030090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe40003f06070ULL,
0x000000020f127210ULL, 0x000fe20007ffe0ffULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186d0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000034090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fc800078ee212ULL, 0x0000000c0d0d7211ULL, 0x000fe200078e20ffULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186e0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000038090f7836ULL, 0x000fe40000000000ULL, 0x0000003c09097836ULL, 0x000fe20000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x000fc400078e0202ULL,
0x000000080f0f7824ULL, 0x000fe400078e00ffULL, 0x0000000109027824ULL, 0x000fc600078e0202ULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100d7faeULL, 0x0003e2000c101c4aULL,
0x0000000e0900720cULL, 0x000fc60003f06070ULL, 0x0186f0000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f087824ULL, 0x004fe200078e0208ULL, 0x00000009040f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000809097824ULL, 0x000fc800078e00ffULL, 0x018a800008087984ULL, 0x000ea20000000800ULL,
0xfffffff809097812ULL, 0x000fca00078ee202ULL, 0x0000001009097824ULL, 0x000fe400078e020cULL,
0x00000006080f7c24ULL, 0x004fc8000f8e020fULL, 0x000001000f067825ULL, 0x000fc600078e0006ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c4aULL,
0x0000001000587947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe40000011602ULL,
0x00000007610a7c11ULL, 0x040fe4000f8e20ffULL, 0x0000000761127c11ULL, 0x000fe2000f8e70ffULL,
0x00000004090c7824ULL, 0x000fe200078e0249ULL, 0x00000070100b7812ULL, 0x000fe200078ec0ffULL,
0x00000001040f7824ULL, 0x000fe400078e0209ULL, 0x0000000409157836ULL, 0x000fe20000000000ULL,
0x018600000c077984ULL, 0x000e660000000800ULL, 0x0000000815167824ULL, 0x000fc400078e00ffULL,
0x00000004070d7824ULL, 0x002fe400078e020aULL, 0x00008a00ff067b82ULL, 0x000e660000000a00ULL,
0x018a80000d087984ULL, 0x000ea40000000800ULL, 0x00000006080f7c24ULL, 0x004fe4000f8e020fULL,
0x0000000109087824ULL, 0x000fe400078e0202ULL, 0x000001000f0e7825ULL, 0x002fc600078e0006ULL,
0x0000000708117812ULL, 0x000fe200078ec0ffULL, 0x0000200012087836ULL, 0x000fe20000000000ULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fe200078e0215ULL,
0x0ffffff8110d7812ULL, 0x000fe400078ef802ULL, 0x0000000fff117210ULL, 0x000fc600007fe4ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018610000c0d7984ULL, 0x000ea20000000800ULL,
0x0000000809117810ULL, 0x002fe20007ffe0ffULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x018620000c0d7984ULL, 0x000ea20000000800ULL, 0x0000000c09157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe200000e060fULL, 0x0000000315167819ULL, 0x000fc600000006ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018630000c0d7984ULL, 0x000ea20000000800ULL,
0x0000001009117836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x018640000c0d7984ULL, 0x000ea20000000800ULL, 0x0000001409157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x0000000815167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018650000c0d7984ULL, 0x000ea20000000800ULL,
0x0000001809117836ULL, 0x002fe20000000000ULL, 0x0000000a0d127211ULL, 0x004fca00078e10ffULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x018660000c0d7984ULL, 0x000ea20000000800ULL, 0x0000001c09157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fe200078e0006ULL,
0x00000002110d7210ULL, 0x000fe40007ffe0ffULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fe200078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x0000000815167824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe400000e060fULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018670000c0d7984ULL, 0x000ea20000000800ULL,
0x0000002009117836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe200078e00ffULL, 0x000000080d177211ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x018680000c0d7984ULL, 0x000ea20000000800ULL, 0x0000002409157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe40007f1e0ffULL,
0x00000015040e7210ULL, 0x000fe40007ffe0ffULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x0000000815167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018690000c0d7984ULL, 0x000ea20000000800ULL,
0x0000002809117836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x0186a0000c0d7984ULL, 0x000ea20000000800ULL, 0x0000002c09157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0x0000000fff117210ULL, 0x000fc600007fe4ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x0186b0000c0d7984ULL, 0x000ea20000000800ULL,
0x0000003009117810ULL, 0x002fe20007ffe0ffULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x0186c0000c0d7984ULL, 0x000ea20000000800ULL, 0x0000003409157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe200000e060fULL, 0x0000000315167819ULL, 0x000fc600000006ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x0186d0000c0d7984ULL, 0x000ea20000000800ULL,
0x0000003809177836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x0002a40000000800ULL, 0x0000000817127824ULL, 0x002fe400078e00ffULL,
0x000000060d0d7c24ULL, 0x004fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001150d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0217ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff157224ULL, 0x000fc800000e060fULL, 0x000000100d117824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014117faeULL, 0x0003e8000b901c4aULL,
0x0186e0000c0d7984ULL, 0x000ea40000000800ULL, 0x000000040d107824ULL, 0x004fca00078e020aULL,
0x018a8000100d7984ULL, 0x000ea40000000800ULL, 0x000000060d0d7c24ULL, 0x004fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001170d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e0e7210ULL, 0x000fc80007f1e0ffULL, 0xfffffff8120d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff0f7224ULL, 0x000fc800000e060fULL, 0x000000100d117824ULL, 0x002fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e8000b901c4aULL,
0x0186f0000c0d7984ULL, 0x000ea40000000800ULL, 0x0000000a0d0a7211ULL, 0x004fe200078e10ffULL,
0x0000003c090d7836ULL, 0x000fc80000000000ULL, 0x0000000104097824ULL, 0x000fe200078e020dULL,
0x018a80000a0a7984ULL, 0x000ea20000000800ULL, 0x000000010d027824ULL, 0x000fe400078e0202ULL,
0x000000060a097c24ULL, 0x004fc8000f8e0209ULL, 0x0000010009067825ULL, 0x000fc800078e0006ULL,
0x000000080d097824ULL, 0x000fe200078e00ffULL, 0x0000000b06067210ULL, 0x000fc80007f1e0ffULL,
0xfffffff809097812ULL, 0x000fe200078ee202ULL, 0x000000ffff077224ULL, 0x000fc800000e0607ULL,
0x0000001009097824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e4000b901c4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fce0000015200ULL,
0x018ad005ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff047224ULL, 0x000fce00078e00ffULL, 0x000000100400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011409ULL, 0x0000000b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000202027819ULL, 0x000fc80000001209ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000104047810ULL, 0x000fce0007ffe0ffULL, 0x018ad005ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000002061027824ULL, 0x002fca00078e0202ULL, 0x00000003ff047819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe04057812ULL, 0x000fc600078ec0ffULL,
0x0000000102047836ULL, 0x000fe40000000000ULL, 0x0000000102067824ULL, 0x040fe400078e0205ULL,
0x0000000105077824ULL, 0x000fe400078e0204ULL, 0x0000002002087824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fe200078ec0ffULL, 0x0000002002097824ULL, 0x000fe200078e00ffULL,
0x0000001f07077812ULL, 0x000fe200078ec0ffULL, 0x0000001005057836ULL, 0x000fc40000000000ULL,
0x0000002002117824ULL, 0x040fe200078e00ffULL, 0x000001e008077812ULL, 0x000fe200078ee207ULL,
0x0000000102107824ULL, 0x100fe200078e0205ULL, 0x000001e009067812ULL, 0x000fe200078ee206ULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x0000000707077c11ULL, 0x000fe4000f8e20ffULL,
0x0000000706067c11ULL, 0x000fe4000f8e20ffULL, 0x0000000502057819ULL, 0x000fe200000006ffULL,
0x0000000007087984ULL, 0x000e620000000c00ULL, 0x0000001f10107812ULL, 0x000fc400078ec0ffULL,
0x0000001f04047812ULL, 0x000fe200078ec0ffULL, 0x00000000060c7984ULL, 0x000ea20000000c00ULL,
0x000001e005107812ULL, 0x000fe400078ee210ULL, 0x000001e011047812ULL, 0x000fe400078ee204ULL,
0x0000000710107c11ULL, 0x000fe4000f8e20ffULL, 0x0000000704027c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff047424ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x002fc400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff147224ULL, 0x004fe400078e000cULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fe200078e000bULL, 0x0000001406007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fc400078e000dULL, 0x000000ffff197224ULL, 0x000fca00078e000fULL,
0x0000001807007388ULL, 0x000fe80000000c00ULL, 0x0000000002087984ULL, 0x000e680000000c00ULL,
0x00000000100c7984ULL, 0x000ea20000000c00ULL, 0x00000008001e7202ULL, 0x002fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e000aULL, 0x000000ffff227224ULL, 0x000fe400078e0009ULL,
0x000000ffff1c7224ULL, 0x004fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff237224ULL, 0x000fe400078e000bULL, 0x000000ffff207224ULL, 0x000fe200078e000dULL,
0x0000001c10007388ULL, 0x0003e20000000c00ULL, 0x000000ffff217224ULL, 0x000fca00078e000fULL,
0x0000002002007388ULL, 0x0003e20000000c00ULL, 0x018ad004ff0479a7ULL, 0x000ea40008500007ULL,
0x000000ffff087224ULL, 0x006fce00078e0005ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x018ad008ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ff000a7202ULL, 0x000fce0000000f00ULL, 0x000000100a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010a0a7836ULL, 0x000fce0000000000ULL, 0x018ad008ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000cff007c0cULL, 0x000fda000bf05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3d80000003037820ULL, 0x010fe20000410000ULL, 0x0000000761047c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00000000030e72caULL, 0x000fe200000e0000ULL,
0xffffffff0c0d7890ULL, 0x000fe2000fffe03fULL, 0x0000000761037c11ULL, 0x000fe2000f8e18ffULL,
0x0000000704087899ULL, 0x000fd8000800063fULL, 0x0000010048607824ULL, 0x000fca00078e024bULL,
0x0000000960007c0cULL, 0x000fda000bf01070ULL, 0x000000000000894dULL, 0x00afea0003800000ULL,
0x00000001ff677424ULL, 0x000fe200078e00ffULL, 0x000000485f00720cULL, 0x000fe20003f44070ULL,
0x0000003f00047c82ULL, 0x000fc60008000000ULL, 0x0000000467677807ULL, 0x000fd20001000000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0006ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff6a7224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000400067c82ULL, 0x000fcc0008000000ULL, 0x000000016a0c7810ULL, 0x000fe20007ffe0ffULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000040c0d7c11ULL, 0x040fe2000f8ff8ffULL,
0x000000ffff667224ULL, 0x000fe200078e006aULL, 0x000000020c00780cULL, 0x040fe20003f06070ULL,
0x000000ffff6a7224ULL, 0x000fe200078e000cULL, 0x000000030d217812ULL, 0x000fe400078ec0ffULL,
0x00000002ff0da819ULL, 0x000fe4000001160dULL, 0x000000010c1f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff21217207ULL, 0x000fe20005000000ULL, 0x000000010d207824ULL, 0x000fc800078e0248ULL,
0x0000000120067836ULL, 0x000fe40000000000ULL, 0x00000100201c7824ULL, 0x000fc600078e024bULL,
0x0000000c06007c0cULL, 0x000fe4000bf26070ULL, 0x000000401c2b7812ULL, 0x000fe400078ec0ffULL,
0x000000011e067812ULL, 0x000fc600078e0cffULL, 0x00000001002b7824ULL, 0x000fe200078e022bULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000010006c9947ULL, 0x000fea0003800000ULL,
0x00000003ff227819ULL, 0x102fe20000011602ULL, 0x000000081f277824ULL, 0x000fe200078e00ffULL,
0x0000000761237c11ULL, 0x040fe4000f8e20ffULL, 0x000000091c297c48ULL, 0x000fe2000ffe0000ULL,
0x0000000422267824ULL, 0x040fe200078e0249ULL, 0x0000000761257c11ULL, 0x000fe2000f8e70ffULL,
0x00000001220f7824ULL, 0x040fe200078e022bULL, 0x000000291c297210ULL, 0x000fe20007ffe1ffULL,
0x00000001221c7824ULL, 0x100fe200078e0202ULL, 0x01860000260c7984ULL, 0x000e620000000800ULL,
0x0000200006247824ULL, 0x000fe200078e0225ULL, 0x000000292200720cULL, 0x000fe20003f26070ULL,
0x00000004222a7836ULL, 0x000fe20000000000ULL, 0x000000071c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000200024247836ULL, 0x000fe20000000000ULL, 0xfffffff827277812ULL, 0x000fe200078ee202ULL,
0x000000012a627824ULL, 0x000fe200078e0202ULL, 0x0ffffff81d1d7812ULL, 0x000fc400078ef802ULL,
0x000000032a697819ULL, 0x000fc600000006ffULL, 0x000000101d657824ULL, 0x000fe400078e0224ULL,
0x000000012a1d7824ULL, 0x000fe400078e022bULL, 0x000000040c0e7824ULL, 0x002fe400078e0223ULL,
0x00008a00ff0c7b82ULL, 0x000e680000000a00ULL, 0x018a80000e0e7984ULL, 0x000ea40000000800ULL,
0x000000080e0f7c24ULL, 0x004fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x002fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e657faeULL, 0x0003e2000c901c4aULL, 0x000000292a00720cULL, 0x000fe20003f26070ULL,
0x00000008222a7836ULL, 0x000fe40000000000ULL, 0x01861000261c7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x000000012a0f7824ULL, 0x040fe400078e022bULL,
0x000000012a627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e0224ULL,
0x000000082a697824ULL, 0x000fe400078e00ffULL, 0x000000041c287824ULL, 0x004fca00078e0223ULL,
0x018a8000281c7984ULL, 0x000e640000000800ULL, 0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010271c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000c901c4aULL,
0x000000292a00720cULL, 0x000fe20003f26070ULL, 0x0000000c222a7836ULL, 0x000fe40000000000ULL,
0x01862000260e7984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x000000012a627824ULL, 0x040fe200078e0202ULL, 0x0000002b2a1d7210ULL, 0x000fe20007ffe0ffULL,
0x000000082a697824ULL, 0x000fe400078e00ffULL, 0x0000001065657824ULL, 0x000fc400078e0224ULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e657faeULL, 0x0003e2000c901c4aULL, 0x000000292a00720cULL, 0x000fe20003f26070ULL,
0x00000010222a7836ULL, 0x000fe40000000000ULL, 0x01863000261c7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x000000012a0f7824ULL, 0x040fe400078e022bULL,
0x000000012a627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e0224ULL,
0x000000082a697824ULL, 0x000fe400078e00ffULL, 0x000000041c287824ULL, 0x004fca00078e0223ULL,
0x018a8000281c7984ULL, 0x000e640000000800ULL, 0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010271c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000c901c4aULL,
0x000000292a00720cULL, 0x000fe20003f26070ULL, 0x00000014222a7836ULL, 0x000fe40000000000ULL,
0x01864000260e7984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x000000012a1d7824ULL, 0x040fe400078e022bULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e0224ULL, 0x000000082a697824ULL, 0x000fe400078e00ffULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e657faeULL, 0x0003e2000c901c4aULL, 0x000000292a00720cULL, 0x000fe20003f26070ULL,
0x00000018222a7836ULL, 0x000fe40000000000ULL, 0x01865000261c7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x000000012a0f7824ULL, 0x040fe200078e022bULL,
0x000000032a697819ULL, 0x040fe200000006ffULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fe200078e0224ULL, 0x000000231c287211ULL, 0x004fca00078e10ffULL,
0x018a8000281c7984ULL, 0x000e640000000800ULL, 0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010271c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000c901c4aULL,
0x000000292a00720cULL, 0x000fe20003f26070ULL, 0x0000001c222a7836ULL, 0x000fe40000000000ULL,
0x01866000260e7984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x000000012a1d7824ULL, 0x040fe400078e022bULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e0224ULL, 0x000000082a697824ULL, 0x000fe400078e00ffULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e657faeULL, 0x0003e2000c901c4aULL, 0x000000292a00720cULL, 0x000fe20003f26070ULL,
0x00000020222a7836ULL, 0x000fe40000000000ULL, 0x01867000261c7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x000000012a627824ULL, 0x040fe200078e0202ULL,
0x0000002b2a0f7210ULL, 0x000fe20007ffe0ffULL, 0x000000082a697824ULL, 0x000fe400078e00ffULL,
0x0000001065657824ULL, 0x000fc400078e0224ULL, 0x000000041c287824ULL, 0x004fca00078e0223ULL,
0x018a8000281c7984ULL, 0x000e640000000800ULL, 0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010271c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000c901c4aULL,
0x000000292a00720cULL, 0x000fe20003f26070ULL, 0x00000024222a7836ULL, 0x000fe40000000000ULL,
0x01868000260e7984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x000000012a1d7824ULL, 0x040fe400078e022bULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e0224ULL, 0x000000082a697824ULL, 0x000fe400078e00ffULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e657faeULL, 0x0003e2000c901c4aULL, 0x000000292a00720cULL, 0x000fe20003f26070ULL,
0x00000028222a7836ULL, 0x000fe40000000000ULL, 0x01869000261c7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x000000012a0f7824ULL, 0x040fe400078e022bULL,
0x000000012a627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e0224ULL,
0x000000082a697824ULL, 0x000fe400078e00ffULL, 0x000000041c287824ULL, 0x004fca00078e0223ULL,
0x018a8000281c7984ULL, 0x000e640000000800ULL, 0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010271c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000c901c4aULL,
0x000000292a00720cULL, 0x000fe20003f26070ULL, 0x0000002c222a7836ULL, 0x000fe40000000000ULL,
0x0186a000260e7984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x000000012a1d7824ULL, 0x040fe200078e022bULL, 0x000000032a697819ULL, 0x040fe200000006ffULL,
0x000000012a627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fe200078e0224ULL,
0x000000230e287211ULL, 0x004fca00078e10ffULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e657faeULL, 0x0003e2000c901c4aULL, 0x000000292a00720cULL, 0x000fe20003f26070ULL,
0x00000030222a7836ULL, 0x000fe40000000000ULL, 0x0186b000261c7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x000000012a0f7824ULL, 0x040fe400078e022bULL,
0x000000012a627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e0224ULL,
0x000000082a697824ULL, 0x000fe400078e00ffULL, 0x000000041c287824ULL, 0x004fca00078e0223ULL,
0x018a8000281c7984ULL, 0x000e640000000800ULL, 0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010271c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000c901c4aULL,
0x000000292a00720cULL, 0x000fe20003f26070ULL, 0x00000034222a7836ULL, 0x000fe40000000000ULL,
0x0186c000260e7984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x000000012a627824ULL, 0x040fe200078e0202ULL, 0x0000002b2a1d7210ULL, 0x000fe20007ffe0ffULL,
0x000000082a697824ULL, 0x000fe400078e00ffULL, 0x0000001065657824ULL, 0x000fc400078e0224ULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e657faeULL, 0x0003e2000c901c4aULL, 0x000000292a00720cULL, 0x000fe20003f26070ULL,
0x00000038222a7836ULL, 0x000fe40000000000ULL, 0x0186d000261c7984ULL, 0x000ea20000000800ULL,
0x0000003c22227836ULL, 0x000fe20000000000ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x000000012a0f7824ULL, 0x040fe400078e022bULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e0224ULL, 0x000000082a697824ULL, 0x000fe400078e00ffULL,
0x00000001222b7824ULL, 0x000fe400078e022bULL, 0x000000041c287824ULL, 0x004fca00078e0223ULL,
0x018a8000281c7984ULL, 0x000e640000000800ULL, 0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010271c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000c901c4aULL,
0x000000292a00720cULL, 0x000fc60003f26070ULL, 0x0186e000260e7984ULL, 0x000ea20000000800ULL,
0xfffffff8691d7812ULL, 0x002fe200078ee262ULL, 0x0000000822657824ULL, 0x000fc800078e00ffULL,
0x000000101d1d7824ULL, 0x000fe400078e0224ULL, 0x000000040e287824ULL, 0x004fca00078e0223ULL,
0x018a8000280e7984ULL, 0x0002a40000000800ULL, 0x0000000122287824ULL, 0x002fe400078e0202ULL,
0x000000080e0f7c24ULL, 0x004fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e1d7faeULL, 0x0003e2000c901c4aULL, 0x000000292200720cULL, 0x000fc60003f26070ULL,
0x0186f00026267984ULL, 0x000ea20000000800ULL, 0xfffffff8650f7812ULL, 0x002fca00078ee228ULL,
0x000000100f0f7824ULL, 0x000fe200078e0224ULL, 0x00000023261c7211ULL, 0x004fcc00078e10ffULL,
0x018a80001c1c7984ULL, 0x000e640000000800ULL, 0x000000081c2b7c24ULL, 0x002fc8000f8e022bULL,
0x000001002b0c7825ULL, 0x000fc800078e000cULL, 0x00000010270c7825ULL, 0x000fca00078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c901c4aULL,
0x0000001000207947ULL, 0x000fea0003800000ULL, 0x00000003ff227819ULL, 0x102fe40000011602ULL,
0x0000000761237c11ULL, 0x040fe4000f8e20ffULL, 0x0000000761257c11ULL, 0x000fe2000f8e70ffULL,
0x0000000422267824ULL, 0x040fe200078e0249ULL, 0x000000031f277819ULL, 0x000fe200000006ffULL,
0x00000001220f7824ULL, 0x040fe400078e022bULL, 0x00000001221c7824ULL, 0x000fe200078e0202ULL,
0x01860000260c7984ULL, 0x000e620000000800ULL, 0x0000200006247824ULL, 0x000fe200078e0225ULL,
0xfffffff827277812ULL, 0x000fe200078ee202ULL, 0x00000004222a7836ULL, 0x000fe20000000000ULL,
0x000000071c1d7812ULL, 0x000fe200078ec0ffULL, 0x0000200024247836ULL, 0x000fc40000000000ULL,
0x000000012a627824ULL, 0x040fe200078e0202ULL, 0x0ffffff81d1d7812ULL, 0x000fe200078ef802ULL,
0x000000082a657824ULL, 0x000fc800078e00ffULL, 0x000000101d297824ULL, 0x000fe200078e0224ULL,
0xfffffff865657812ULL, 0x000fe200078ee262ULL, 0x000000012a1d7824ULL, 0x000fc800078e022bULL,
0x0000001065657824ULL, 0x000fe400078e0224ULL, 0x000000040c0e7824ULL, 0x002fe400078e0223ULL,
0x00008a00ff0c7b82ULL, 0x000e680000000a00ULL, 0x018a80000e0e7984ULL, 0x000ea40000000800ULL,
0x000000080e0f7c24ULL, 0x004fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x002fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e8000b901c4aULL, 0x01861000261c7984ULL, 0x000ea20000000800ULL,
0x0000000822297836ULL, 0x002fc80000000000ULL, 0x00000001290f7824ULL, 0x040fe400078e022bULL,
0x00000001292a7824ULL, 0x040fe400078e0202ULL, 0x0000000829297824ULL, 0x000fca00078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee22aULL, 0x0000000c222a7836ULL, 0x000fc80000000000ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x000000041c287824ULL, 0x004fca00078e0223ULL, 0x018a8000281c7984ULL, 0x000e640000000800ULL,
0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d1c7825ULL, 0x000fc800078e000cULL,
0x00000010271c7825ULL, 0x000fca00078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c657faeULL, 0x0003e8000b901c4aULL, 0x01862000260e7984ULL, 0x000ea20000000800ULL,
0x000000012a1d7824ULL, 0x042fe200078e022bULL, 0x000000032a657819ULL, 0x000fc800000006ffULL,
0xfffffff865657812ULL, 0x000fca00078ee262ULL, 0x0000001065657824ULL, 0x000fe200078e0224ULL,
0x000000230e287211ULL, 0x004fca00078e10ffULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e8000b901c4aULL, 0x01863000261c7984ULL, 0x000ea20000000800ULL,
0x0000001022297836ULL, 0x002fc80000000000ULL, 0x00000001290f7824ULL, 0x040fe400078e022bULL,
0x00000001292a7824ULL, 0x040fe400078e0202ULL, 0x0000000829297824ULL, 0x000fca00078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee22aULL, 0x00000014222a7836ULL, 0x000fc80000000000ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x000000041c287824ULL, 0x004fca00078e0223ULL, 0x018a8000281c7984ULL, 0x000e640000000800ULL,
0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d1c7825ULL, 0x000fc800078e000cULL,
0x00000010271c7825ULL, 0x000fca00078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c657faeULL, 0x0003e8000b901c4aULL, 0x01864000260e7984ULL, 0x000ea20000000800ULL,
0x0000002b2a1d7210ULL, 0x002fe20007ffe0ffULL, 0x000000082a657824ULL, 0x000fca00078e00ffULL,
0xfffffff865657812ULL, 0x000fca00078ee262ULL, 0x0000001065657824ULL, 0x000fe400078e0224ULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e8000b901c4aULL, 0x01865000261c7984ULL, 0x000ea20000000800ULL,
0x0000001822297836ULL, 0x002fc80000000000ULL, 0x00000001290f7824ULL, 0x040fe400078e022bULL,
0x00000001292a7824ULL, 0x040fe400078e0202ULL, 0x0000000829297824ULL, 0x000fca00078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee22aULL, 0x0000001c222a7836ULL, 0x000fc80000000000ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x000000041c287824ULL, 0x004fca00078e0223ULL, 0x018a8000281c7984ULL, 0x000e640000000800ULL,
0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d1c7825ULL, 0x000fc800078e000cULL,
0x00000010271c7825ULL, 0x000fca00078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c657faeULL, 0x0003e8000b901c4aULL, 0x01866000260e7984ULL, 0x000ea20000000800ULL,
0x000000012a1d7824ULL, 0x042fe400078e022bULL, 0x000000082a657824ULL, 0x000fca00078e00ffULL,
0xfffffff865657812ULL, 0x000fca00078ee262ULL, 0x0000001065657824ULL, 0x000fe400078e0224ULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e8000b901c4aULL, 0x01867000261c7984ULL, 0x000ea20000000800ULL,
0x0000002022297836ULL, 0x002fc80000000000ULL, 0x00000001290f7824ULL, 0x040fe400078e022bULL,
0x00000001292a7824ULL, 0x040fe200078e0202ULL, 0x0000000329297819ULL, 0x000fc800000006ffULL,
0xfffffff829297812ULL, 0x000fe200078ee22aULL, 0x00000024222a7836ULL, 0x000fc80000000000ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x000000012a627824ULL, 0x000fe200078e0202ULL,
0x000000231c287211ULL, 0x004fca00078e10ffULL, 0x018a8000281c7984ULL, 0x000e640000000800ULL,
0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d1c7825ULL, 0x000fc800078e000cULL,
0x00000010271c7825ULL, 0x000fca00078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c657faeULL, 0x0003e8000b901c4aULL, 0x01868000260e7984ULL, 0x000ea20000000800ULL,
0x000000012a1d7824ULL, 0x042fe400078e022bULL, 0x000000082a657824ULL, 0x000fca00078e00ffULL,
0xfffffff865657812ULL, 0x000fca00078ee262ULL, 0x0000001065657824ULL, 0x000fe400078e0224ULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e8000b901c4aULL, 0x01869000261c7984ULL, 0x000ea20000000800ULL,
0x0000002822297836ULL, 0x002fc80000000000ULL, 0x00000001292a7824ULL, 0x040fe200078e0202ULL,
0x0000002b290f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000829297824ULL, 0x000fca00078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee22aULL, 0x0000002c222a7836ULL, 0x000fc80000000000ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x000000041c287824ULL, 0x004fca00078e0223ULL, 0x018a8000281c7984ULL, 0x000e640000000800ULL,
0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d1c7825ULL, 0x000fc800078e000cULL,
0x00000010271c7825ULL, 0x000fca00078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c657faeULL, 0x0003e8000b901c4aULL, 0x0186a000260e7984ULL, 0x000ea20000000800ULL,
0x000000012a1d7824ULL, 0x042fe400078e022bULL, 0x000000082a657824ULL, 0x000fca00078e00ffULL,
0xfffffff865657812ULL, 0x000fca00078ee262ULL, 0x0000001065657824ULL, 0x000fe400078e0224ULL,
0x000000040e287824ULL, 0x004fca00078e0223ULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e8000b901c4aULL, 0x0186b000261c7984ULL, 0x000ea20000000800ULL,
0x0000003022297836ULL, 0x002fc80000000000ULL, 0x00000001290f7824ULL, 0x040fe400078e022bULL,
0x00000001292a7824ULL, 0x040fe400078e0202ULL, 0x0000000829297824ULL, 0x000fca00078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee22aULL, 0x00000034222a7836ULL, 0x000fc80000000000ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x000000012a627824ULL, 0x000fe400078e0202ULL,
0x000000041c287824ULL, 0x004fca00078e0223ULL, 0x018a8000281c7984ULL, 0x000e640000000800ULL,
0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL, 0x000001001d1c7825ULL, 0x000fc800078e000cULL,
0x00000010271c7825ULL, 0x000fca00078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c657faeULL, 0x0003e8000b901c4aULL, 0x0186c000260e7984ULL, 0x000ea20000000800ULL,
0x000000012a1d7824ULL, 0x042fe200078e022bULL, 0x000000032a657819ULL, 0x000fc800000006ffULL,
0xfffffff865657812ULL, 0x000fca00078ee262ULL, 0x0000001065657824ULL, 0x000fe200078e0224ULL,
0x000000230e287211ULL, 0x004fca00078e10ffULL, 0x018a8000280e7984ULL, 0x000e640000000800ULL,
0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e8000b901c4aULL, 0x0186d000261c7984ULL, 0x000ea20000000800ULL,
0x0000003822297836ULL, 0x002fe40000000000ULL, 0x0000003c22227836ULL, 0x000fe40000000000ULL,
0x00000001290f7824ULL, 0x040fe400078e022bULL, 0x00000001292a7824ULL, 0x000fc400078e0202ULL,
0x0000000829297824ULL, 0x000fca00078e00ffULL, 0xfffffff829297812ULL, 0x000fca00078ee22aULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x000000041c287824ULL, 0x004fca00078e0223ULL,
0x018a8000281c7984ULL, 0x000e640000000800ULL, 0x000000081c1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010271c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e8000b901c4aULL,
0x0186e000260e7984ULL, 0x000ea20000000800ULL, 0x0000002b221d7210ULL, 0x002fe20007ffe0ffULL,
0x00000008222b7824ULL, 0x000fe400078e00ffULL, 0x000000040e287824ULL, 0x004fca00078e0223ULL,
0x018a8000280e7984ULL, 0x0002a40000000800ULL, 0x0000000122287824ULL, 0x002fe400078e0202ULL,
0x000000080e0f7c24ULL, 0x004fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010270e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e8000b901c4aULL, 0x0186f00026267984ULL, 0x000ea40000000800ULL,
0x00000004261c7824ULL, 0x004fcc00078e0223ULL, 0x018a80001c1c7984ULL, 0x000ea40000000800ULL,
0x000000081c1d7c24ULL, 0x004fc8000f8e021dULL, 0x000001001d0c7825ULL, 0x000fe200078e000cULL,
0xfffffff82b1d7812ULL, 0x000fca00078ee228ULL, 0x000000101d1d7824ULL, 0x000fe400078e0224ULL,
0x00000010270c7825ULL, 0x000fca00078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1d7faeULL, 0x0003e4000b901c4aULL, 0x000000ff1f00720cULL, 0x000fe20003f25270ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000000bc9947ULL, 0x000fea0003800000ULL,
0x00009200ff0c7b82ULL, 0x002e620000000a00ULL, 0x00000001210e7836ULL, 0x000fe20000000000ULL,
0x000000032100780cULL, 0x000fe20003f85270ULL, 0x0000002002227836ULL, 0x000fe20000000000ULL,
0x000000205f00720cULL, 0x0c0fe40003f64070ULL, 0x000000205f00720cULL, 0x000fe40003f24070ULL,
0x00000002ff0f7819ULL, 0x000fe4000001160eULL, 0x000000030e0e7812ULL, 0x000fc400078ec0ffULL,
0x000000010f0f7807ULL, 0x000fe40004800000ULL, 0x000000ff0e1d7207ULL, 0x000fc60004800000ULL,
0x0000000120207824ULL, 0x000fe400078e020fULL, 0x000000015c1c7824ULL, 0x000fe400078e021dULL,
0x00000100201d7824ULL, 0x000fe200078e024bULL, 0x000000000044b947ULL, 0x000fec0002000000ULL,
0x000000030200780cULL, 0x000fe20003f24070ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000247477836ULL, 0x000fd60000000000ULL, 0x0000000000301947ULL, 0x000fea0003800000ULL,
0x00008c00ff0e7b82ULL, 0x000ea20000000a00ULL, 0x00000002131f7211ULL, 0x000fe200078e10ffULL,
0x00009000000f7ab9ULL, 0x000fe20000000800ULL, 0x0000000547007c0cULL, 0x000fe2000bf26070ULL,
0x0000000402237824ULL, 0x000fe400078e0223ULL, 0x000000021f207824ULL, 0x000fc800078e00ffULL,
0x0000000f201f7c24ULL, 0x000fc8000f8e0247ULL, 0x000000041f0e7825ULL, 0x004fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a800000e237faeULL, 0x0005e4000c92184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011d0e7824ULL, 0x104fe200078e0202ULL,
0x00009400000f7ab9ULL, 0x000fe20000000800ULL, 0x00000001220f7824ULL, 0x100fe400078e021dULL,
0x0000000f1c1d7c24ULL, 0x000fe2000f8e021dULL, 0x000000090e007c0cULL, 0x000fe2000bf26070ULL,
0x00000004021f7824ULL, 0x000fe200078e0249ULL, 0x000000090f007c0cULL, 0x000fe2000bf66070ULL,
0x000000011d0f7824ULL, 0x000fe400078e0202ULL, 0x00000001221d7824ULL, 0x000fc400078e021dULL,
0x000000040f0e7825ULL, 0x002fc800078e000cULL, 0x000000041d0c7825ULL, 0x000fe400078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x186000000e1f7faeULL, 0x0003e8000c92184aULL,
0x186800000c1f7faeULL, 0x0003e4000d92184aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020020d7836ULL, 0x002fe20000000000ULL, 0xfffffff802697812ULL, 0x000fe200078ec0ffULL,
0x000020001e647824ULL, 0x000fe200078e0225ULL, 0x0000000702657812ULL, 0x000fe400078ec0ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000200064647836ULL, 0x000fe20000000000ULL,
0x000000ff006b7202ULL, 0x000fe40000000f00ULL, 0x0000000769697812ULL, 0x000fc400078ef802ULL,
0x0000000865627812ULL, 0x000fe400078ef802ULL, 0x000000070d687812ULL, 0x000fce00078ef802ULL,
0x00000008660f7824ULL, 0x100fe400078e026bULL, 0x00000001690c7824ULL, 0x000fe400078e026bULL,
0x000000020f0f7824ULL, 0x000fe400078e00ffULL, 0x00000008691d7824ULL, 0x040fe400078e00ffULL,
0x000000016b6c7836ULL, 0x000fe20000000000ULL, 0x0000000f020d7211ULL, 0x000fe200078fe0ffULL,
0x0000000869297824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x00000020620c7824ULL, 0x000fc400078e00ffULL, 0x00000001620d7824ULL, 0x000fe400078e020dULL,
0x000000101d247824ULL, 0x000fe400078e0264ULL, 0x00000001690e7824ULL, 0x000fe200078e026cULL,
0xffffffe00c0d7812ULL, 0x000fe200078ee20dULL, 0x00000001680c7824ULL, 0x040fe200078e026bULL,
0x0000006c686c7210ULL, 0x000fe20007ffe0ffULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x000000070d1c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000020f0f7836ULL, 0x000fe20000000000ULL,
0x00000003680d7819ULL, 0x000fe200000006ffULL, 0x0000002062287824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x00000008686d7824ULL, 0x000fe200078e00ffULL,
0x000000001c1c783bULL, 0x000ea20000000200ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x000000026b6b7836ULL, 0x000fe20000000000ULL, 0x0000000f020f7211ULL, 0x000fc400078fe0ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee26cULL, 0x000000100d207824ULL, 0x000fe200078e0264ULL,
0x000000086b00780cULL, 0x000fe20003f25270ULL, 0x00000001620f7824ULL, 0x000fc800078e020fULL,
0x000000002020783bULL, 0x000ee20000000200ULL, 0xffffffe028287812ULL, 0x000fe400078ee20fULL,
0x00000024ff0c723eULL, 0x002fe400020006ffULL, 0x00000024ff0d723eULL, 0x000fe400030006ffULL,
0x00000025ff24723eULL, 0x000fe400020006ffULL, 0x00000025ff25723eULL, 0x000fe400030006ffULL,
0x00000026ff2a723eULL, 0x000fe200020006ffULL, 0x0000000c1c40723cULL, 0x004fe20000001840ULL,
0x00000026ff2b723eULL, 0x000fca00030006ffULL, 0x000000241c3c723cULL, 0x000fe2000000183cULL,
0x00000010290c7824ULL, 0x000fe200078e0264ULL, 0x00000027ff29723eULL, 0x000fc800030006ffULL,
0x0000002a1c38723cULL, 0x000fe20000001838ULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x0000000728247c11ULL, 0x000fe4000f8e20ffULL, 0x00000027ff28723eULL, 0x000fc600020006ffULL,
0x00000020ff2a723eULL, 0x008fe200020006ffULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x00000020ff2b723eULL, 0x000fe400030006ffULL, 0x000000281c34723cULL, 0x000fe20000001834ULL,
0x00000021ff20723eULL, 0x000fe400020006ffULL, 0x00000021ff21723eULL, 0x000fc600030006ffULL,
0x0000002a1c30723cULL, 0x000fe20000001830ULL, 0x000000106d287824ULL, 0x000fca00078e0264ULL,
0x000000201c2c723cULL, 0x000fe2000000182cULL, 0x000000002828783bULL, 0x000eec0000000200ULL,
0x00000022ff20723eULL, 0x000fe400020006ffULL, 0x00000022ff21723eULL, 0x000fe400030006ffULL,
0x00000023ff22723eULL, 0x000fc400020006ffULL, 0x00000023ff23723eULL, 0x000fc600030006ffULL,
0x000000201c14723cULL, 0x000fec0000001814ULL, 0x000000221c18723cULL, 0x000fee0000001818ULL,
0x0000000cff1c723eULL, 0x002fc400020006ffULL, 0x0000000cff1d723eULL, 0x000fe400030006ffULL,
0x0000000dff0c723eULL, 0x000fe400020006ffULL, 0x0000000dff0d723eULL, 0x000fc600030006ffULL,
0x0000001c2440723cULL, 0x004fec0000001840ULL, 0x0000000c243c723cULL, 0x000fee000000183cULL,
0x0000000eff0c723eULL, 0x000fc400020006ffULL, 0x0000000eff0d723eULL, 0x000fe400030006ffULL,
0x0000000fff0e723eULL, 0x000fe400020006ffULL, 0x0000000fff0f723eULL, 0x000fc600030006ffULL,
0x0000000c2438723cULL, 0x000fec0000001838ULL, 0x0000000e2434723cULL, 0x000fe20000001834ULL,
0x00000028ff0c723eULL, 0x008fe400020006ffULL, 0x00000028ff0d723eULL, 0x000fe400030006ffULL,
0x00000029ff28723eULL, 0x000fc400020006ffULL, 0x00000029ff29723eULL, 0x000fc600030006ffULL,
0x0000000c2430723cULL, 0x000fec0000001830ULL, 0x00000028242c723cULL, 0x000fe2000000182cULL,
0x0000002aff0c723eULL, 0x000fe400020006ffULL, 0x0000002aff0d723eULL, 0x000fe400030006ffULL,
0x0000002bff2a723eULL, 0x000fc400020006ffULL, 0x0000002bff2b723eULL, 0x000fc600030006ffULL,
0x0000000c2414723cULL, 0x000fec0000001814ULL, 0x0000002a2418723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff800a01947ULL, 0x000fde000383ffffULL,
0x000000ffff1e7224ULL, 0x000fe200078e0006ULL, 0xffffffd000cc8947ULL, 0x000fec000383ffffULL,
0x00000002ff0c7819ULL, 0x000fc80000011602ULL, 0x000000040c007c0cULL, 0x000fe2000bf06070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040c007c0cULL, 0x000fe2000c706470ULL,
0x000000080c0c7836ULL, 0x000fc60000000000ULL, 0x000000485f00720cULL, 0x000fe40000703070ULL,
0x000000060c007c0cULL, 0x000fc8000bf26070ULL, 0x000000040c007c0cULL, 0x000fc80008f21070ULL,
0x000000485f00720cULL, 0x000fc60000f24470ULL, 0x000000ffff5b8224ULL, 0x000fe200078e0019ULL,
0x0000002c00548202ULL, 0x000fe20000000f00ULL, 0x000000ffff588224ULL, 0x000fe200078e0018ULL,
0x00000040004a8202ULL, 0x000fe20000000f00ULL, 0x000000ffff598224ULL, 0x000fe200078e0015ULL,
0x0000005e1b5e7208ULL, 0x000fe20000800000ULL, 0x000000ffff568224ULL, 0x000fe200078e0014ULL,
0x000000631a637208ULL, 0x000fe20000800000ULL, 0x000000ffff578224ULL, 0x000fe200078e002dULL,
0x0000005a175a7208ULL, 0x000fe20000800000ULL, 0x000000ffff558224ULL, 0x000fe200078e0031ULL,
0x0000005d165d7208ULL, 0x000fe20000800000ULL, 0x000000ffff528224ULL, 0x000fe200078e0030ULL,
0x000000082f087208ULL, 0x000fe20000800000ULL, 0x000000ffff538224ULL, 0x000fe200078e0035ULL,
0x000000072e077208ULL, 0x000fe20000800000ULL, 0x000000ffff508224ULL, 0x000fe200078e0034ULL,
0x0000000a330a7208ULL, 0x000fe20000800000ULL, 0x000000ffff518224ULL, 0x000fe200078e0039ULL,
0x0000000932097208ULL, 0x000fe20000800000ULL, 0x000000ffff4e8224ULL, 0x000fe200078e0038ULL,
0x0000001037107208ULL, 0x000fe20000800000ULL, 0x000000ffff4f8224ULL, 0x000fe200078e003dULL,
0x0000000b360b7208ULL, 0x000fe20000800000ULL, 0x000000ffff4c8224ULL, 0x000fe200078e003cULL,
0x000000123b127208ULL, 0x000fe20000800000ULL, 0x000000ffff4d8224ULL, 0x000fe200078e0041ULL,
0x0000000467007c0cULL, 0x000fc4000bf03070ULL, 0x000000113a117208ULL, 0x000fe40000800000ULL,
0x000000443f447208ULL, 0x000fe40000800000ULL, 0x000000453e457208ULL, 0x000fe40000800000ULL,
0x0000004643467208ULL, 0x000fe40000800000ULL, 0x0000000542057208ULL, 0x000fc60000800000ULL,
0xffffffcc00d48947ULL, 0x000fea000383ffffULL, 0x00000001ff0e7424ULL, 0x000fe400078e00ffULL,
0x0000000e4a0d7c20ULL, 0x000fe20008410000ULL, 0x0000000e4d4d7c20ULL, 0x000fe20008410000ULL,
0x0000000e4c4c7c20ULL, 0x000fe20008410000ULL, 0x0000000e4f4f7c20ULL, 0x000fe20008410000ULL,
0x0000000e4e4e7c20ULL, 0x000fe20008410000ULL, 0x018b580e030e79a7ULL, 0x000e62000850003fULL,
0x0000000e51517c20ULL, 0x000fe20008410000ULL, 0x0000000e50507c20ULL, 0x000fe20008410000ULL,
0x0000000e53537c20ULL, 0x000fe20008410000ULL, 0x0000000e52527c20ULL, 0x000fe20008410000ULL,
0x0000000e55557c20ULL, 0x000fe20008410000ULL, 0x0000000e54547c20ULL, 0x000fe20008410000ULL,
0x0000000e57577c20ULL, 0x000fe20008410000ULL, 0x0000000e56567c20ULL, 0x000fe20008410000ULL,
0x0000000e59597c20ULL, 0x000fe20008410000ULL, 0x0000000e58587c20ULL, 0x000fe20008410000ULL,
0x0000000e5b5b7c20ULL, 0x000fe20008410000ULL, 0x0000000e050c7c20ULL, 0x000fe20008410000ULL,
0x0000000e46467c20ULL, 0x000fe20008410000ULL, 0x0000000e45457c20ULL, 0x000fe20008410000ULL,
0x0000000e44447c20ULL, 0x000fe20008410000ULL, 0x0000000e11117c20ULL, 0x000fe20008410000ULL,
0x0000000e12127c20ULL, 0x000fe20008410000ULL, 0x0000000e0b0b7c20ULL, 0x000fe20008410000ULL,
0x0000000e10107c20ULL, 0x000fe20008410000ULL, 0x0000000e09097c20ULL, 0x000fe20008410000ULL,
0x0000000e0a0a7c20ULL, 0x000fe20008410000ULL, 0x0000000e07077c20ULL, 0x000fe20008410000ULL,
0x0000000e08087c20ULL, 0x000fe20008410000ULL, 0x000000ffff167224ULL, 0x002fc400078e000fULL,
0x0000000e5d5d7c20ULL, 0x000fe20008410000ULL, 0x0000000e5a5a7c20ULL, 0x000fe20008410000ULL,
0x0000000e63637c20ULL, 0x000fe20008410000ULL, 0x0000000e5e5e7c20ULL, 0x000fe20008410000ULL,
0x00000000000e7805ULL, 0x000fe20000015200ULL, 0x018b5816030075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff177224ULL, 0x000fce00078e00ffULL,
0x000000101700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x000000140e147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e0fULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011415ULL,
0x0000001405057211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000205057819ULL, 0x000fc80000001214ULL, 0x000000050000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000117177836ULL, 0x000fce0000000000ULL,
0x018b5816030075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000402057824ULL, 0x000fe200078e00ffULL, 0x0000000761307c11ULL, 0x000fe4000f8e38ffULL,
0x0000000d48007c0cULL, 0x000fe4000bf05270ULL, 0xfffffff005057812ULL, 0x000fca00078ec0ffULL,
0x0000000130307824ULL, 0x000fca00078e0205ULL, 0x01840000301c7984ULL, 0x0002a20000000c00ULL,
0x0000000400080947ULL, 0x000fea0003800000ULL, 0x0000000202057824ULL, 0x000fe200078e00ffULL,
0x0000000960607c10ULL, 0x000fc8000fffe1ffULL, 0x0000000605057812ULL, 0x000fc800078ec0ffULL,
0x00000001050f7812ULL, 0x040fe400078efcffULL, 0x0000000805157812ULL, 0x000fe400078efcffULL,
0x000000600f00720cULL, 0x080fe40003f26070ULL, 0x00000010050f7812ULL, 0x000fe400078efcffULL,
0x000000601500720cULL, 0x080fe40003f06070ULL, 0x000000600f00720cULL, 0x000fc40003fc6070ULL,
0x0000001105157812ULL, 0x040fe400078efcffULL, 0x00000018050f7812ULL, 0x040fe400078efcffULL,
0x000000600500720cULL, 0x080fe40003f46070ULL, 0x000000601500720cULL, 0x080fe40003fa6070ULL,
0x000000600f00720cULL, 0x000fe40003f66070ULL, 0x0000000905177812ULL, 0x000fc400078efcffULL,
0x0000001905157812ULL, 0x040fe400078efcffULL, 0x00000020050f7812ULL, 0x000fe400078efcffULL,
0xff8000000c0c7808ULL, 0x000fe40005000000ULL, 0xff8000000d0d7808ULL, 0x000fe40005000000ULL,
0xff80000046467808ULL, 0x000fe40004800000ULL, 0xff8000004d4d7808ULL, 0x000fc40004800000ULL,
0x000000601700720cULL, 0x080fe40003f86070ULL, 0x000000601500720cULL, 0x080fe40003f46070ULL,
0x000000600f00720cULL, 0x000fe40003f26070ULL, 0x0000002105157812ULL, 0x040fe400078efcffULL,
0x00000028050f7812ULL, 0x000fe400078efcffULL, 0xff80000045457808ULL, 0x000fc40004000000ULL,
0xff8000004c4c7808ULL, 0x000fe40004000000ULL, 0xff80000044447808ULL, 0x000fe40006000000ULL,
0xff8000004f4f7808ULL, 0x000fe40006000000ULL, 0x000000601500720cULL, 0x080fe40003f06070ULL,
0x000000600f00720cULL, 0x000fe40003f86070ULL, 0x0000002905157812ULL, 0x000fc400078efcffULL,
0x00000030050f7812ULL, 0x000fe400078efcffULL, 0xff80000011117808ULL, 0x000fe40007000000ULL,
0xff8000004e4e7808ULL, 0x000fe40007000000ULL, 0xff80000012127808ULL, 0x000fe40006800000ULL,
0xff80000051517808ULL, 0x000fe40006800000ULL, 0x000000601500720cULL, 0x000fc40003fc6070ULL,
0x000000600f00720cULL, 0x000fe40003fa6070ULL, 0x0000003105157812ULL, 0x040fe400078efcffULL,
0x00000038050f7812ULL, 0x040fe400078efcffULL, 0x0000003905057812ULL, 0x000fe400078efcffULL,
0xff8000000b0b7808ULL, 0x000fe40005800000ULL, 0xff80000050507808ULL, 0x000fc40005800000ULL,
0xff80000010107808ULL, 0x000fe40005000000ULL, 0xff80000053537808ULL, 0x000fe40005000000ULL,
0xff80000009097808ULL, 0x000fe40004800000ULL, 0xff80000052527808ULL, 0x000fe40004800000ULL,
0x000000601500720cULL, 0x080fe40003f66070ULL, 0x000000600f00720cULL, 0x000fc40003f46070ULL,
0x000000600500720cULL, 0x000fe40003f26070ULL, 0xff8000000a0a7808ULL, 0x000fe40004000000ULL,
0xff80000055557808ULL, 0x000fe40004000000ULL, 0xff80000007077808ULL, 0x000fe40006000000ULL,
0xff80000054547808ULL, 0x000fe40006000000ULL, 0xff80000008087808ULL, 0x000fc40007000000ULL,
0xff80000057577808ULL, 0x000fe40007000000ULL, 0xff8000005d5d7808ULL, 0x000fe40006800000ULL,
0xff80000056567808ULL, 0x000fe40006800000ULL, 0xff8000005a5a7808ULL, 0x000fe40005800000ULL,
0xff80000059597808ULL, 0x000fe40005800000ULL, 0xff80000063637808ULL, 0x000fc40005000000ULL,
0xff80000058587808ULL, 0x000fe40005000000ULL, 0xff8000005e5e7808ULL, 0x000fe40004800000ULL,
0xff8000005b5b7808ULL, 0x000fce0004800000ULL, 0x0000000d1c00720bULL, 0x004fe20003f1e000ULL,
0x3c003c00ff257424ULL, 0x000fe200078e00ffULL, 0x3c003c0000247802ULL, 0x000fe20000000f00ULL,
0x0000000148487836ULL, 0x000fe20000000000ULL, 0x0000001c0d1c7208ULL, 0x000fe40004000000ULL,
0xfffffff8ff657812ULL, 0x000fe400078ee265ULL, 0x0000004d1c00720bULL, 0x000fe40003f1e000ULL,
0x0000000761297c11ULL, 0x000fe2000f8e58ffULL, 0x0000000865267824ULL, 0x000fe200078e00ffULL,
0x0000001c4d057208ULL, 0x000fe20004000000ULL, 0x00000008652a7824ULL, 0x000fe200078e00ffULL,
0x0c401f001f1c7f89ULL, 0x000fe200000e0000ULL, 0x0001200029347836ULL, 0x000fe20000000000ULL,
0x0000004c0500720bULL, 0x000fc80003f1e000ULL, 0x000000054c0e7208ULL, 0x000fc80004000000ULL,
0x0000004f0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e4f057208ULL, 0x000fc80004000000ULL,
0x0000004e0500720bULL, 0x000fc80003f1e000ULL, 0x000000054e0e7208ULL, 0x000fc80004000000ULL,
0x000000510e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e51057208ULL, 0x000fc80004000000ULL,
0x000000500500720bULL, 0x000fc80003f1e000ULL, 0x00000005500e7208ULL, 0x000fc80004000000ULL,
0x000000530e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e53057208ULL, 0x000fc80004000000ULL,
0x000000520500720bULL, 0x000fc80003f1e000ULL, 0x00000005520e7208ULL, 0x000fc80004000000ULL,
0x000000550e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e55057208ULL, 0x000fc80004000000ULL,
0x000000540500720bULL, 0x000fc80003f1e000ULL, 0x00000005540e7208ULL, 0x000fe40004000000ULL,
0x0000000c1d00720bULL, 0x000fe40003f1e000ULL, 0x000000570e00720bULL, 0x000fe40003f3e000ULL,
0x0000001d0c1d7208ULL, 0x000fe40004000000ULL, 0x0000000e57057208ULL, 0x000fe40004800000ULL,
0x000000461d00720bULL, 0x000fc40003f1e000ULL, 0x000000560500720bULL, 0x000fe40003f3e000ULL,
0x0000001d460e7208ULL, 0x000fe40004000000ULL, 0x0000000556147208ULL, 0x000fe20004800000ULL,
0x0c401f001e1d7f89ULL, 0x000fe200000e0000ULL, 0x000000450e00720bULL, 0x000fe40003f1e000ULL,
0x000000591400720bULL, 0x000fe40003f3e000ULL, 0x0000000e45057208ULL, 0x000fc40004000000ULL,
0x00000014590f7208ULL, 0x000fe40004800000ULL, 0x000000440500720bULL, 0x000fe40003f1e000ULL,
0x000000580f00720bULL, 0x000fe40003f3e000ULL, 0x00000005440e7208ULL, 0x000fe40004000000ULL,
0x0000000f58147208ULL, 0x000fe40004800000ULL, 0x000000110e00720bULL, 0x000fc40003f1e000ULL,
0x0000005b1400720bULL, 0x000fe40003f3e000ULL, 0x0000000e11057208ULL, 0x000fe40004000000ULL,
0x000000145b147208ULL, 0x000fe40004800000ULL, 0x000000120500720bULL, 0x000fc60003f1e000ULL,
0x0c401f00140f7f89ULL, 0x000ea200000e0000ULL, 0x00000005120e7208ULL, 0x000fc80004000000ULL,
0x0000000b0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e0b057208ULL, 0x000fc80004000000ULL,
0x000000100500720bULL, 0x000fc80003f1e000ULL, 0x00000005100e7208ULL, 0x000fc80004000000ULL,
0x000000090e00720bULL, 0x000fe40003f1e000ULL, 0x0000000f1400720bULL, 0x004fe40003f3e000ULL,
0x0000000e09057208ULL, 0x000fe40004000000ULL, 0x000000140f0f7208ULL, 0x000fe40004800000ULL,
0x0000000a0500720bULL, 0x000fc60003f1e000ULL, 0x0c201f000f2c7f89ULL, 0x000ea200000e0000ULL,
0x000000050a0e7208ULL, 0x000fc80004000000ULL, 0x000000070e00720bULL, 0x000fc80003f1e000ULL,
0x0000000e07057208ULL, 0x000fc80004000000ULL, 0x000000080500720bULL, 0x000fc80003f1e000ULL,
0x00000005080e7208ULL, 0x000fc80004000000ULL, 0x0000005d0e00720bULL, 0x000fe40003f1e000ULL,
0x0000002c0f00720bULL, 0x004fe40003f3e000ULL, 0x0000000e5d057208ULL, 0x000fe40004000000ULL,
0x0000000f2c2c7208ULL, 0x000fe40004800000ULL, 0x0000005a0500720bULL, 0x000fe40003f1e000ULL,
0x0000001c1f00720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2c147820ULL, 0x000fe20000410000ULL,
0x000000055a0e7208ULL, 0x000fc40004000000ULL, 0x0000001f1c2f7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010814ULL, 0x000000630e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010814ULL, 0x0000000e63057208ULL, 0x000fe20004000000ULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010814ULL, 0x0000005e0500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010814ULL, 0x000000055e057208ULL, 0x000fe20004000000ULL,
0x0000000d004a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010814ULL,
0x0c401f00050e7f89ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010814ULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b5b5b7823ULL, 0x000fe20000010814ULL,
0x00000003ff1c7819ULL, 0x000fe20000011602ULL, 0x0c201f002f327f89ULL, 0x000ee600000e0000ULL,
0x000000031c1c7812ULL, 0x000fc400078ec0ffULL, 0x0000004f004f7308ULL, 0x000ff00000000800ULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x0000000e0500720bULL, 0x004fc80003f1e000ULL,
0x000000050e057208ULL, 0x000fc60004000000ULL, 0x0000005100517308ULL, 0x000ea20000000800ULL,
0x000000322f00720bULL, 0x008fe20003f3e000ULL, 0x0c201f00050e7f89ULL, 0x000ee600000e0000ULL,
0x0000002f322f7208ULL, 0x000fc60004800000ULL, 0x0000005000507308ULL, 0x000fe20000000800ULL,
0x0000004e5114723eULL, 0x004fce00000000ffULL, 0x0000005300537308ULL, 0x000eb00000000800ULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x0000000e0500720bULL, 0x008fe40003f1e000ULL,
0x000000505316723eULL, 0x004fca00000000ffULL, 0x0000005500557308ULL, 0x000ea20000000800ULL,
0x000000050e2d7208ULL, 0x000fe40004000000ULL, 0x0000004c4f0e723eULL, 0x000fe400000000ffULL,
0x0000001d1e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d277820ULL, 0x000fe40000410000ULL,
0x0000005400547308ULL, 0x000fe20000000800ULL, 0x0000001e1d2e7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b0c057823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010827ULL,
0x0000004a4d0c723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010827ULL,
0x0000000500057308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b07077823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010827ULL,
0x0000004600467308ULL, 0x000ee20000000800ULL, 0x000000525518723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b5d5d7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b63637823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b5e5e7823ULL, 0x000fe20000010827ULL,
0x00000008651d7836ULL, 0x000fe20000000000ULL, 0x0c201f002e317f89ULL, 0x000ea200000e0000ULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x000000011c657824ULL, 0x000fc400078e0265ULL,
0x000000011c287824ULL, 0x000fe400078e021dULL, 0x000000081d2b7824ULL, 0x040fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee265ULL, 0x000000081d367824ULL, 0x000fe200078e00ffULL,
0x0000004400447308ULL, 0x000f220000000800ULL, 0x00000005460d723eULL, 0x008fe200000000ffULL,
0x0000000465277836ULL, 0x000fe20000000000ULL, 0x0000000c65657810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82b287812ULL, 0x000fc400078ee228ULL, 0xfffffff82a277812ULL, 0x000fe200078ee227ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0xfffffff836657812ULL, 0x000fe200078ee265ULL,
0x0000001028337824ULL, 0x000fe400078e0234ULL, 0x000000ffff287224ULL, 0x000fe400078e0018ULL,
0x0000001065657824ULL, 0x000fe200078e0234ULL, 0x00000045440f723eULL, 0x010fe200000000ffULL,
0x0000001200127308ULL, 0x000ee20000000800ULL, 0x000000312e00720bULL, 0x004fc80003f1e000ULL,
0x0000002e312e7208ULL, 0x000fe20004000000ULL, 0x000000240c20723cULL, 0x000fe200000018ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x000000111215723eULL, 0x008fce00000000ffULL, 0x0000001000107308ULL, 0x000eb00000000800ULL,
0x0000005700577308ULL, 0x000ee20000000800ULL, 0x0000000b1017723eULL, 0x004fce00000000ffULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x000000241420723cULL, 0x000fe20000001820ULL,
0x00000054571a723eULL, 0x008fcc00000000ffULL, 0x0000000a000a7308ULL, 0x000ea20000000800ULL,
0x0000001a00297202ULL, 0x000fce0000000f00ULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x000000090a19723eULL, 0x004fce00000000ffULL, 0x0000000800087308ULL, 0x000eb00000000800ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x00000007081b723eULL, 0x004fce00000000ffULL,
0x0000005900597308ULL, 0x000ea20000000800ULL, 0x000000241820723cULL, 0x000fee0000001820ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x00000056591c723eULL, 0x004fce00000000ffULL,
0x0000005b005b7308ULL, 0x000ea20000000800ULL, 0x000000ffff2a7224ULL, 0x000fce00078e001cULL,
0x0000005d005d7308ULL, 0x000fe20000000800ULL, 0x000000585b1e723eULL, 0x004fce00000000ffULL,
0x0000005a005a7308ULL, 0x000ea20000000800ULL, 0x000000ffff2b7224ULL, 0x000fce00078e001eULL,
0x0000006300637308ULL, 0x000fe20000000800ULL, 0x0000005d5a1d723eULL, 0x004fce00000000ffULL,
0x0000005e005e7308ULL, 0x000ea40000000800ULL, 0x000000635e1f723eULL, 0x004fce00000000ffULL,
0x000000241c20723cULL, 0x000fee0000001820ULL, 0x000000ffff247224ULL, 0x000fe400078e000cULL,
0x000000ffff257224ULL, 0x000fe400078e000eULL, 0x000000ffff0c7224ULL, 0x000fc400078e000dULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff0e7224ULL, 0x000fe400078e0015ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0017ULL, 0x000000ffff157224ULL, 0x000fe400078e001bULL,
0x0000001026217824ULL, 0x100fe400078e0234ULL, 0x0000001027237824ULL, 0x000fc400078e0234ULL,
0x000000ffff267224ULL, 0x000fe400078e0014ULL, 0x000000ffff277224ULL, 0x000fe200078e0016ULL,
0x0000001d00167202ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff177224ULL, 0x000fe200078e001fULL, 0x0000002421007844ULL, 0x0005e20000000200ULL,
0x00000001ff197424ULL, 0x000fc600078e00ffULL, 0x0000002823007844ULL, 0x0007e80000000200ULL,
0x0000000c33007844ULL, 0x0007e80000000200ULL, 0x0000001465007844ULL, 0x0007e20000000200ULL,
0x000000ffff217224ULL, 0x004fc600078e0022ULL, 0x0180002c30008388ULL, 0x0007e80000000c00ULL,
0x0182002030008388ULL, 0x0007e20000000a00ULL, 0x0000000c48007c0cULL, 0x000fe2000bf06070ULL,
0x018ad81904ff79a7ULL, 0x0007e2000850003fULL, 0x018ae01904ff79a7ULL, 0x0007e2000850003fULL,
0x018ae81904ff79a7ULL, 0x0007e2000850003fULL, 0x018af01904ff79a7ULL, 0x0007f2000850003fULL,
0xffffffb800088947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x018000000a007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000a00008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff0aff7812ULL, 0x040fe4000780c0ffULL, 0x800000000a027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000a00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffe6802e07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000562ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006e0ULL, 0x0000000000000240ULL, 0x0000001600000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000920ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a00ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a54ULL, 0x0000000000000a38ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001490ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001490ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000014d8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001500ULL, 0x0000000000019580ULL, 0x0000001600000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x000000000001aa80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x000000000001aad0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x000000000001aad0ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x000000000001b0c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x000000000001b0c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000014d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001500ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019580ULL, 0x0000000000019580ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001aa80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x000000000001aad0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_e4m3_pagedKV_128_nqpkv_1_m_1_sm_90_cubin_len = 111128;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
