/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_e4m3_pagedKV_64_nqpkv_1_m_1_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c150ULL, 0x000000000001bdd0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x65746e695f5f2400ULL,
0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL, 0x65722e00636e7973ULL,
0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL, 0x0066754265747942ULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x006d617261705f00ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL, 0x00006e6f69746361ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000019d10ULL, 0x0000000000000170ULL,
0x000b0022000004bdULL, 0x0000000000019e80ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x0000000000019ec0ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x0000000000019f00ULL,
0x0000000000000060ULL, 0x000b00220000053dULL, 0x0000000000019f60ULL, 0x0000000000000120ULL,
0x000a0003000005a4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005f4ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001a080ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00019d1000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x0065dc0400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80809c0828808081ULL,
0x8408288080a00828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808084920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00019d1000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0xa0082880809c0828ULL, 0x2880808c08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x000022002880808cULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x00019e8000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0xa0082880809c0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a0920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000017000000000ULL, 0x00019ec000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0xa0082880809c0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a0920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000001f000000000ULL, 0x00019f0000000000ULL,
0x0000006000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x9c08288080a00828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809c920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000027000000000ULL, 0x00019f6000000000ULL,
0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000079ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001b00082304ULL, 0x0008120400000000ULL,
0x000000000000001bULL, 0x0000001b00081104ULL, 0x0004370400000000ULL, 0x00080a040000007bULL,
0x0068016000000018ULL, 0x000c170400681903ULL, 0x0060000700000000ULL, 0x000c17040021f000ULL,
0x0058000600000000ULL, 0x000c17040021f000ULL, 0x0050000500000000ULL, 0x000c17040011f000ULL,
0x0038000400000000ULL, 0x000c17040061f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000003000043104ULL, 0xffffffff01bc2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001bc2804ULL,
0x0000048000000130ULL, 0x00003540000034b0ULL, 0x000037a000003640ULL, 0x00003a00000039d0ULL,
0x00003aa000003a50ULL, 0x000058d0000058b0ULL, 0x0000597000005920ULL, 0x00007c2000007b90ULL,
0x00007e6000007d10ULL, 0x000080a000008080ULL, 0x00008140000080f0ULL, 0x00009d8000009d60ULL,
0x00009e2000009dd0ULL, 0x0000bfb00000bf20ULL, 0x0000c1f00000c0a0ULL, 0x0000c4300000c410ULL,
0x0000c4d00000c480ULL, 0x0000e1100000e0f0ULL, 0x0000e1b00000e160ULL, 0x00010340000102b0ULL,
0x0001058000010430ULL, 0x000107c0000107a0ULL, 0x0001086000010810ULL, 0x000124a000012480ULL,
0x00012540000124f0ULL, 0x0001311000012fd0ULL, 0x00013710000136f0ULL, 0x00014c1000013b60ULL,
0x000156a000015680ULL, 0x0001675000016730ULL, 0x0001817000018130ULL, 0x0001819000018180ULL,
0x00018200000181a0ULL, 0x0001824000018220ULL, 0x00018eb000018e60ULL, 0x00018f7000018f10ULL,
0x0001903000018fd0ULL, 0x000190f000019090ULL, 0x0001919000019140ULL, 0x00019240000191e0ULL,
0x00019300000192a0ULL, 0x000193c000019360ULL, 0x0001946000019410ULL, 0x00019510000194b0ULL,
0x000195d000019570ULL, 0x0001969000019630ULL, 0x00019730000196e0ULL, 0x000197e000019780ULL,
0x000198a000019840ULL, 0x0001996000019900ULL, 0x00019a00000199b0ULL, 0x00019ab000019a50ULL,
0x00019b7000019b10ULL, 0x00019c3000019bd0ULL, 0x00019cf000019c90ULL, 0x0000023007e03904ULL,
0x00010ad0000000ffULL, 0x00000260003f0100ULL, 0x00010ad80000000bULL, 0x00000360003f0120ULL,
0x00010b580000000bULL, 0x00000390003f0120ULL, 0x00010b780000000bULL, 0x00000430003f0120ULL,
0x00010b88000000ffULL, 0x00000500003f0100ULL, 0x00010ad0000000ffULL, 0x000007f0003f0107ULL,
0x00010b5c000000ffULL, 0x0000085000050102ULL, 0x00010b58000000ffULL, 0x000009d000050101ULL,
0x00010b88000000ffULL, 0x00000a10003f0101ULL, 0x00010b8c000000ffULL, 0x00000bd0003f0105ULL,
0x00010b8c000000ffULL, 0x000015e0003f0105ULL, 0x00010b88000000ffULL, 0x00001610003f0101ULL,
0x00010b8c000000ffULL, 0x000017e0003f0105ULL, 0x00010b8c000000ffULL, 0x00001950003f0105ULL,
0x00010b78000000ffULL, 0x000019d0003f0107ULL, 0x00010b78000000ffULL, 0x00001a30003f0101ULL,
0x00010b88000000ffULL, 0x00001d00003f0101ULL, 0x00010b7c000000ffULL, 0x00001ec0003f0105ULL,
0x00010b7c000000ffULL, 0x00001f20003f0105ULL, 0x00010b8c000000ffULL, 0x000020f0003f0105ULL,
0x00010b8c000000ffULL, 0x00002b50003f0105ULL, 0x00010b88000000ffULL, 0x00002b80003f0101ULL,
0x00010b8c000000ffULL, 0x00002d50003f0105ULL, 0x00010b8c000000ffULL, 0x000030b0003f0105ULL,
0x00010b80000000ffULL, 0x00003140003f0107ULL, 0x00010b80000000ffULL, 0x000031d0003f0101ULL,
0x00010ad8000000ffULL, 0x0000320000050101ULL, 0x00010adc000000ffULL, 0x000033d000050105ULL,
0x00010adc000000ffULL, 0x0000450000050105ULL, 0x00010b88000000ffULL, 0x000045d0003f0101ULL,
0x00010b84000000ffULL, 0x00004790003f0105ULL, 0x00010b84000000ffULL, 0x000047f0003f0105ULL,
0x00010b8c000000ffULL, 0x000049c0003f0105ULL, 0x00010b8c000000ffULL, 0x000053f0003f0105ULL,
0x00010b88000000ffULL, 0x00005420003f0101ULL, 0x00010b8c000000ffULL, 0x000055f0003f0105ULL,
0x00010b8c000000ffULL, 0x000057c0003f0105ULL, 0x00010b78000000ffULL, 0x00005840003f0107ULL,
0x00010b78000000ffULL, 0x00006290003f0101ULL, 0x00010b88000000ffULL, 0x00006340003f0101ULL,
0x00010b58000000ffULL, 0x00006420003f0101ULL, 0x00010b7c000000ffULL, 0x000065e0003f0105ULL,
0x00010b7c000000ffULL, 0x00006640003f0105ULL, 0x00010b8c000000ffULL, 0x00006810003f0105ULL,
0x00010b8c000000ffULL, 0x00007260003f0105ULL, 0x00010b88000000ffULL, 0x00007290003f0101ULL,
0x00010b8c000000ffULL, 0x00007460003f0105ULL, 0x00010b8c000000ffULL, 0x00007790003f0105ULL,
0x00010b80000000ffULL, 0x00007810003f0107ULL, 0x00010b80000000ffULL, 0x000078b0003f0101ULL,
0x00010af8000000ffULL, 0x000078e000050101ULL, 0x00010afc000000ffULL, 0x00007ab000050105ULL,
0x00010afc000000ffULL, 0x000089a000050105ULL, 0x00010b88000000ffULL, 0x00008a80003f0101ULL,
0x00010b84000000ffULL, 0x00008c40003f0105ULL, 0x00010b84000000ffULL, 0x00008ca0003f0105ULL,
0x00010b8c000000ffULL, 0x00008e70003f0105ULL, 0x00010b8c000000ffULL, 0x000098a0003f0105ULL,
0x00010b88000000ffULL, 0x000098d0003f0101ULL, 0x00010b8c000000ffULL, 0x00009aa0003f0105ULL,
0x00010b8c000000ffULL, 0x00009c70003f0105ULL, 0x00010b78000000ffULL, 0x00009cf0003f0107ULL,
0x00010b78000000ffULL, 0x0000a640003f0101ULL, 0x00010b88000000ffULL, 0x0000a6d0003f0101ULL,
0x00010b60000000ffULL, 0x0000a7b0003f0101ULL, 0x00010b7c000000ffULL, 0x0000a970003f0105ULL,
0x00010b7c000000ffULL, 0x0000a9d0003f0105ULL, 0x00010b8c000000ffULL, 0x0000aba0003f0105ULL,
0x00010b8c000000ffULL, 0x0000b5f0003f0105ULL, 0x00010b88000000ffULL, 0x0000b620003f0101ULL,
0x00010b8c000000ffULL, 0x0000b7f0003f0105ULL, 0x00010b8c000000ffULL, 0x0000bb20003f0105ULL,
0x00010b80000000ffULL, 0x0000bba0003f0107ULL, 0x00010b80000000ffULL, 0x0000bc40003f0101ULL,
0x00010b18000000ffULL, 0x0000bc7000050101ULL, 0x00010b1c000000ffULL, 0x0000be4000050105ULL,
0x00010b1c000000ffULL, 0x0000cd3000050105ULL, 0x00010b88000000ffULL, 0x0000ce10003f0101ULL,
0x00010b84000000ffULL, 0x0000cfd0003f0105ULL, 0x00010b84000000ffULL, 0x0000d030003f0105ULL,
0x00010b8c000000ffULL, 0x0000d200003f0105ULL, 0x00010b8c000000ffULL, 0x0000dc30003f0105ULL,
0x00010b88000000ffULL, 0x0000dc60003f0101ULL, 0x00010b8c000000ffULL, 0x0000de30003f0105ULL,
0x00010b8c000000ffULL, 0x0000e000003f0105ULL, 0x00010b78000000ffULL, 0x0000e080003f0107ULL,
0x00010b78000000ffULL, 0x0000e9d0003f0101ULL, 0x00010b88000000ffULL, 0x0000ea60003f0101ULL,
0x00010b68000000ffULL, 0x0000eb40003f0101ULL, 0x00010b7c000000ffULL, 0x0000ed00003f0105ULL,
0x00010b7c000000ffULL, 0x0000ed60003f0105ULL, 0x00010b8c000000ffULL, 0x0000ef30003f0105ULL,
0x00010b8c000000ffULL, 0x0000f980003f0105ULL, 0x00010b88000000ffULL, 0x0000f9b0003f0101ULL,
0x00010b8c000000ffULL, 0x0000fb80003f0105ULL, 0x00010b8c000000ffULL, 0x0000feb0003f0105ULL,
0x00010b80000000ffULL, 0x0000ff30003f0107ULL, 0x00010b80000000ffULL, 0x0000ffd0003f0101ULL,
0x00010b38000000ffULL, 0x0001000000050101ULL, 0x00010b3c000000ffULL, 0x000101d000050105ULL,
0x00010b3c000000ffULL, 0x000110c000050105ULL, 0x00010b88000000ffULL, 0x000111a0003f0101ULL,
0x00010b84000000ffULL, 0x00011360003f0105ULL, 0x00010b84000000ffULL, 0x000113c0003f0105ULL,
0x00010b8c000000ffULL, 0x00011590003f0105ULL, 0x00010b8c000000ffULL, 0x00011fc0003f0105ULL,
0x00010b88000000ffULL, 0x00011ff0003f0101ULL, 0x00010b8c000000ffULL, 0x000121c0003f0105ULL,
0x00010b8c000000ffULL, 0x00012390003f0105ULL, 0x00010b78000000ffULL, 0x00012410003f0107ULL,
0x00010b78000000ffULL, 0x00012d60003f0101ULL, 0x00010b88000000ffULL, 0x00012de0003f0101ULL,
0x00010b70000000ffULL, 0x00013940003f0101ULL, 0x00010ad0000000ffULL, 0x00014c40003f0101ULL,
0x00010ad4000000ffULL, 0x00014e10003f0105ULL, 0x00010ad4000000ffULL, 0x00015190003f0105ULL,
0x00010ad0000000ffULL, 0x000151d0003f0101ULL, 0x00010ad4000000ffULL, 0x00015390003f0105ULL,
0x00010ad4000000ffULL, 0x00017430003f0105ULL, 0x0000000000000058ULL, 0x00017660003f0101ULL,
0x0000000400000058ULL, 0x00017830003f0105ULL, 0x0000000400000058ULL, 0x00018cc0003f0105ULL,
0x0000000000000057ULL, 0x00018d20003f0101ULL, 0x0000000800000057ULL, 0x00018d80003f0101ULL,
0x0000001000000057ULL, 0x00018df0003f0101ULL, 0x0000001800000057ULL, 0x00053803003f0101ULL,
0x0001384000101c04ULL, 0x000154d0000153f0ULL, 0x0000040100018e30ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000002dcULL, 0x0000001b00000002ULL, 0x000000000000025cULL, 0x0000001b00000002ULL,
0x00000000000001dcULL, 0x0000001b00000002ULL, 0x000000000000015cULL, 0x0000001b00000002ULL,
0x00000000000000dcULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x00000000000002b2ULL, 0x0000001b00000002ULL, 0x0000000000000232ULL, 0x0000001b00000002ULL,
0x00000000000001b2ULL, 0x0000001b00000002ULL, 0x0000000000000137ULL, 0x0000001b00000002ULL,
0x00000000000000b2ULL, 0x0000001b00000002ULL, 0x0000000000010c00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000b79c3ULL, 0x000ea20000002700ULL, 0x0000000000147806ULL, 0x000fe200038e0000ULL,
0x00005800ff107624ULL, 0x000fe200078e00ffULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x0000001400077300ULL, 0x000fe200000e0000ULL,
0x00004600000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ee20000002200ULL,
0x0000000400097882ULL, 0x000fc60000000000ULL, 0x00000000000f7919ULL, 0x000f240000000000ULL,
0x0000001400147309ULL, 0x000ee40000000000ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000005ff007819ULL, 0x002fe2000001160bULL, 0x000000020b0a7899ULL, 0x004fca000800063fULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x000000ffff147224ULL, 0x008fe400078e0a14ULL,
0x000001000a027a24ULL, 0x000fe400078e0203ULL, 0x00001fff0a0a7589ULL, 0x000ea400000e0000ULL,
0x00000000020b7a24ULL, 0x000fe200078e020bULL, 0x000000080700720cULL, 0x010fc80003f02070ULL,
0x000000ff0b00720cULL, 0x040fe40003f25270ULL, 0x0000000f0b00780cULL, 0x040fe40003f44070ULL,
0x000000030b00780cULL, 0x040fe40003f64070ULL, 0x000000010b00780cULL, 0x040fe40003fa4070ULL,
0x0000007f0b00780cULL, 0x000fe20003f84070ULL, 0x00000000000873c2ULL, 0x0022a800000e0000ULL,
0x3fffff80ff029424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x0000000000007919ULL, 0x002e620000002600ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0x3fffff00ff08d424ULL, 0x000fe200078e00ffULL, 0x010ad002ff009388ULL, 0x0007e20000000a00ULL,
0x7fffff00ff09d424ULL, 0x000fc400078e00ffULL, 0xff317217ff12c424ULL, 0x000fe200078e00ffULL,
0x010ad8040b00a388ULL, 0x0009e80000008a00ULL, 0x010400120b00c388ULL, 0x000fe20000004800ULL,
0x0000000410037824ULL, 0x008fe200078e00ffULL, 0x000000080a067c11ULL, 0x004fe2000f8e10ffULL,
0x000000100f047824ULL, 0x010fc800078e00ffULL, 0x00000002060c7824ULL, 0x000fe400078e00ffULL,
0x0000000b03037c24ULL, 0x002fe2000f8e0200ULL, 0x000001f004117812ULL, 0x000fe200078ec0ffULL,
0x000000010c0d7824ULL, 0x040fe200078e020fULL, 0x000000040c057817ULL, 0x040fe20007800000ULL,
0x000000200c0e7824ULL, 0x040fe200078e00ffULL, 0x000000010c107810ULL, 0x040fe20007ffe0ffULL,
0x3fffff60ff06b424ULL, 0x000fe400078e00ffULL, 0x000058000c027a24ULL, 0x000fe200078e0203ULL,
0xffffffe00e0e7812ULL, 0x000fe200078ee20dULL, 0x00000001050d7824ULL, 0x000fe200078e0a0cULL,
0x010b58060b00b388ULL, 0x0003e20000008a00ULL, 0x0000580010047a24ULL, 0x000fc400078e0203ULL,
0x00005c0002027625ULL, 0x080fe200078e0013ULL, 0x010b78080b00d388ULL, 0x0005e20000008a00ULL,
0x000000ff0d00720cULL, 0x040fe40003f43070ULL, 0x00005c0004047625ULL, 0x000fe200078e0013ULL,
0x000000010d00780cULL, 0x000fe40003f63070ULL, 0x0000001102027210ULL, 0x080fe40007f9e0ffULL,
0x0000001104047210ULL, 0x000fe20007fbe0ffULL, 0x3fffff80ff069424ULL, 0x002fc400078e00ffULL,
0x7fffff80ff079424ULL, 0x000fe400078e00ffULL, 0x0000000110087824ULL, 0x044fe400078e020fULL,
0x0000002010097824ULL, 0x000fe200078e00ffULL, 0x010b8806ff009388ULL, 0x000fe20000000a00ULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0xffffffe009087812ULL, 0x000fe200078ee208ULL, 0x000000100e097824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e2000d101c4cULL,
0x000000ffff087224ULL, 0x000fc600078e0014ULL, 0x00000000040b7faeULL, 0x0003e8000d901c4cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x010ad408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010ad000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000620000047ab9ULL, 0x000fe40000000a00ULL, 0x000000090a0472a5ULL, 0x000fc4000f8e0004ULL,
0x00006a0000067ab9ULL, 0x000fe40000000a00ULL, 0x000000090a0672a5ULL, 0x000fe4000f8e0006ULL,
0x00000004ff667e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff677e24ULL, 0x000fe4000f8e00ffULL,
0x00000006ff047e24ULL, 0x002fe4000f8e00ffULL, 0x00000007ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c66667981ULL, 0x000ea8000c1e1900ULL, 0x0000000c04047981ULL, 0x000ee2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0x0000003f66647810ULL, 0x004fc40007ffe0ffULL, 0x000000ff660c7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff637819ULL, 0x008fe40000011604ULL, 0x00000006ff647819ULL, 0x000fe40000011664ULL,
0x00000008ff657819ULL, 0x000fc6000001160cULL, 0x000131b000008947ULL, 0x000fea0003800000ULL,
0x00000008ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000308057899ULL, 0x000fe2000800063fULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x00000003ff067424ULL, 0x000fe400078e00ffULL,
0x0000002003077824ULL, 0x000fca00078e020fULL, 0x0000001f0700780cULL, 0x040fe40003f04070ULL,
0x000000030700780cULL, 0x000fd60003f24070ULL, 0x0000007000000947ULL, 0x000fea0003800000ULL,
0x0000000aff047e24ULL, 0x000fe2000f8e00ffULL, 0x000000660700720cULL, 0x040fe20003f06070ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x00010a0007097811ULL, 0x000fe200078e10ffULL,
0x0000680004047a24ULL, 0x000fc800078e0207ULL, 0x0000660004047625ULL, 0x000fcc00078e0005ULL,
0x0000000004097faeULL, 0x0003e4000c12184cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b5c06ffff798cULL, 0x0005e20008000005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b5800ffff7f8cULL, 0x000fe2000c800405ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x002e620000002700ULL, 0x00006400ff057624ULL, 0x000fe200078e00ffULL,
0x000000ff6400720cULL, 0x000fe20003f05270ULL, 0x00000004ff097424ULL, 0x000fe400078e00ffULL,
0x0000000404047824ULL, 0x002fe200078e0207ULL, 0x00010ac007077811ULL, 0x000fc600078e10ffULL,
0x0000000204047824ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0205ULL,
0x0000600004047625ULL, 0x000fca00078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000812184cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff047f8cULL, 0x002e62000c80043fULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x010b8c00ff067984ULL, 0x004e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010b8c00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000604047899ULL, 0x000fd4000800063fULL, 0x000004f000000947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0x0000000566047c17ULL, 0x000fe2000f800000ULL,
0x00000100ff157424ULL, 0x000fc600078e00ffULL, 0x8000000504087c10ULL, 0x000fe4000fffe0ffULL,
0x00000004ff097819ULL, 0x002fe20000011617ULL, 0x0000001017137824ULL, 0x000fc600078e00ffULL,
0x00000005090b7c10ULL, 0x000fe4000fffe0ffULL, 0x000000f013137812ULL, 0x000fe400078ec0ffULL,
0x000000080900720cULL, 0x000fe20003f06070ULL, 0x010a00000b067984ULL, 0x000e620000004800ULL,
0x00000040000d7824ULL, 0x000fe400078e020bULL, 0x000000010b077824ULL, 0x040fe400078e0217ULL,
0x000000100b0a7824ULL, 0x000fe200078e00ffULL, 0x000000020d117810ULL, 0x000fe20007ffe0ffULL,
0x010ac00006067984ULL, 0x002e640000004800ULL, 0x0000000406047c24ULL, 0x002fc8000f8e020dULL,
0x00005e0004047625ULL, 0x000fca00078e0015ULL, 0x0000001304067210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000c000040f7811ULL, 0x000fe400078e20ffULL, 0x0000000209057810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060f7faeULL, 0x0003e2000c101c4cULL,
0x00000005050a7c10ULL, 0x040fe4000fffe0ffULL, 0x000000080500720cULL, 0x000fe20003f06070ULL,
0x010a08000b0c7984ULL, 0x000ea40000004800ULL, 0x000000010a0e7824ULL, 0x000fe400078e0217ULL,
0x010ac0000c0c7984ULL, 0x004ea40000004800ULL, 0x000000040c047c24ULL, 0x004fc4000f8e0211ULL,
0x000000100a117824ULL, 0x000fe400078e00ffULL, 0x00005e0004047625ULL, 0x000fc600078e0015ULL,
0xfffffff0110e7812ULL, 0x000fe400078ee20eULL, 0x0000001304067210ULL, 0x002fe40007f3e0ffULL,
0x0000c0000e0f7811ULL, 0x000fe400078e20ffULL, 0x000000040d117810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000000409057810ULL, 0x000fe40007ffe0ffULL,
0x000000060d0d7810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c101c4cULL, 0x00000005050a7c10ULL, 0x040fe4000fffe0ffULL,
0x000000080500720cULL, 0x000fe20003f06070ULL, 0x010a10000b0c7984ULL, 0x000ea20000004800ULL,
0x0000000609097810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0e7824ULL, 0x000fe400078e0217ULL,
0x010ac0000c0c7984ULL, 0x004ea40000004800ULL, 0x000000040c047c24ULL, 0x004fc4000f8e0211ULL,
0x000000100a117824ULL, 0x000fe200078e00ffULL, 0x00000005090a7c10ULL, 0x000fe2000fffe0ffULL,
0x00005e0004047625ULL, 0x000fc600078e0015ULL, 0xfffffff0110e7812ULL, 0x000fe400078ee20eULL,
0x0000001304067210ULL, 0x002fe40007f3e0ffULL, 0x0000c0000e0f7811ULL, 0x000fc600078e20ffULL,
0x000000ffff077224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c101c4cULL, 0x000000080900720cULL, 0x000fe20003f06070ULL,
0x000000010a087824ULL, 0x040fe400078e0217ULL, 0x010a18000b0b7984ULL, 0x000ea20000004800ULL,
0x000000100a097824ULL, 0x000fca00078e00ffULL, 0xfffffff009087812ULL, 0x000fc800078ee208ULL,
0x0000c00008077811ULL, 0x002fe200078e20ffULL, 0x010ac0000b047984ULL, 0x004e640000004800ULL,
0x0000000404047c24ULL, 0x002fc8000f8e020dULL, 0x00005e0004047625ULL, 0x000fca00078e0015ULL,
0x0000001304047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c4cULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x00000100ff0c7424ULL, 0x000fe200078e00ffULL, 0x00000005110b7c11ULL, 0x042fe2000f8fe0ffULL,
0x0000001011057824ULL, 0x000fc800078e00ffULL, 0x010a00000b087984ULL, 0x000e620000004800ULL,
0x00000040000d7824ULL, 0x000fe200078e020bULL, 0x000000f005137812ULL, 0x000fe200078ec0ffULL,
0x000000010b077824ULL, 0x040fe400078e0211ULL, 0x000000100b0a7824ULL, 0x040fe200078e00ffULL,
0x010ac00008087984ULL, 0x002e640000004800ULL, 0x0000000408047c24ULL, 0x002fe2000f8e020dULL,
0x000000020b087810ULL, 0x000fc60007ffe0ffULL, 0x00005e0004047625ULL, 0x000fc800078e000cULL,
0x0000000108097824ULL, 0x000fe200078e0211ULL, 0x0000001304067210ULL, 0x000fe20007f1e0ffULL,
0x00000010080e7824ULL, 0x000fe200078e00ffULL, 0xfffffff00a047812ULL, 0x000fc600078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000c000040f7811ULL, 0x000fe400078e20ffULL,
0x000000020d057810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e8000b901c4cULL, 0x010a08000b0a7984ULL, 0x000ea20000004800ULL,
0x000000040b067810ULL, 0x002fca0007ffe0ffULL, 0x0000000106077824ULL, 0x000fe200078e0211ULL,
0x010ac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000cULL, 0x0000001304087210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e047812ULL, 0x000fe200078ee209ULL, 0x00000010060e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x0000c000040f7811ULL, 0x000fe400078e20ffULL,
0x000000040d057810ULL, 0x040fe40007ffe0ffULL, 0x000000060d0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e8000b901c4cULL,
0x010a10000b0a7984ULL, 0x000ea20000004800ULL, 0x000000060b087810ULL, 0x002fc60007ffe0ffULL,
0x010ac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000cULL, 0x0000001304067210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x0000c00004097811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000b901c4cULL, 0x010a18000b0a7984ULL, 0x000ea80000004800ULL,
0x010ac0000a0a7984ULL, 0x004ea40000004800ULL, 0x000000040a047c24ULL, 0x004fc4000f8e020dULL,
0x00000010080d7824ULL, 0x000fe400078e00ffULL, 0x00005e0004047625ULL, 0x000fc800078e000cULL,
0x00000001080c7824ULL, 0x000fe200078e0211ULL, 0x0000001304047210ULL, 0x000fc80007f1e0ffULL,
0xfffffff00d0c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff057224ULL, 0x000fc600000e0605ULL,
0x0000c0000c077811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000b901c4cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff047f8cULL, 0x002e64000c80043fULL, 0x000000ffff0b7224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x010b8c00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010b8c00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002003077824ULL, 0x002fca00078e0204ULL,
0x0000001f0700780cULL, 0x000fda0003f04070ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000000aff067e24ULL, 0x000fe2000f8e00ffULL, 0x0000002007057810ULL, 0x040fe40007ffe0ffULL,
0x00010a0007097811ULL, 0x000fe200078e10ffULL, 0x0000680006067a24ULL, 0x000fe200078e0207ULL,
0x000000660500720cULL, 0x000fe20003f06070ULL, 0x00000004ff057424ULL, 0x000fc600078e00ffULL,
0x0000002006067810ULL, 0x000fca0007ffe0ffULL, 0x0000660006067625ULL, 0x000fca00078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e4000c12184cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff067f8cULL, 0x002e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ff6500720cULL, 0x000fe20003f05270ULL, 0x000000ffff757224ULL, 0x002fe200078e0007ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x000000ffff627224ULL, 0x000fe200078e00ffULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e00ffULL, 0x0000001fff0d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x004fe400078e0009ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0001128000008947ULL, 0x000fea0003800000ULL,
0x00005800ff127624ULL, 0x000fe200078e00ffULL, 0x0001126000007945ULL, 0x000fe20003800000ULL,
0xff317217ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x000000ffff627224ULL, 0x000fc400078e00ffULL, 0x0000004012127824ULL, 0x000fc600078e00ffULL,
0x0000010010137824ULL, 0x000fca00078e00ffULL, 0x000000661300720cULL, 0x000fda0003f06070ULL,
0x000111a000000947ULL, 0x002fea0003800000ULL, 0x000000ffff747224ULL, 0x000fc600078e00ffULL,
0x000000106300720cULL, 0x000fe20003fa4070ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011674ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x0000000374147812ULL, 0x040fe400078ec0ffULL, 0x00000013741b7207ULL, 0x000fe40002800000ULL,
0x000000ff14137207ULL, 0x000fe40006800000ULL, 0x000000031b197812ULL, 0x000fc400078ec0ffULL,
0x000000101b147211ULL, 0x002fc400078ff0ffULL, 0x00000000001a7805ULL, 0x000fca0000015200ULL,
0x010b7c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c1a217210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e1bULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc8000001141dULL, 0x000000211c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff1d7224ULL, 0x000fca00000e061dULL, 0x000000021c1c7819ULL, 0x000fc8000000121dULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fc40000015200ULL,
0x010b8c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c1a217210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e1bULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc8000001141dULL,
0x000000211c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x000000021c1c7819ULL, 0x000fc8000000121dULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001141a7810ULL, 0x000fe20007ffe0ffULL, 0x000009a000017945ULL, 0x000fe60003800000ULL,
0x000000651a00720cULL, 0x000fda0003f06070ULL, 0x0000053000008947ULL, 0x000fea0003800000ULL,
0x00000004ff257819ULL, 0x000fe20000011604ULL, 0x00000004141b7824ULL, 0x000fe200078e0219ULL,
0x0000002000217811ULL, 0x000fe200078e30ffULL, 0x0000001004207824ULL, 0x000fe200078e00ffULL,
0x0000000525247c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff267424ULL, 0x000fe200078e00ffULL,
0x000000201b1b7811ULL, 0x000fe400078e30ffULL, 0x000000f020277812ULL, 0x000fe200078ec0ffULL,
0x010a0000241c7984ULL, 0x000e620000004800ULL, 0x0000001b661a7217ULL, 0x000fe20007800000ULL,
0x0000001024227824ULL, 0x000fe200078e00ffULL, 0x0000000225297810ULL, 0x000fc60007ffe0ffULL,
0x000000011a1a7824ULL, 0x000fe200078e0a1bULL, 0x0000000529287c10ULL, 0x000fe2000fffe0ffULL,
0x00000001241b7824ULL, 0x000fc600078e0221ULL, 0x000000051a1a7c17ULL, 0x000fe2000f800000ULL,
0x00000001282a7824ULL, 0x000fc600078e0204ULL, 0x800000051a207c10ULL, 0x000fc8000fffe0ffULL,
0x000000202500720cULL, 0x000fe20003f06070ULL, 0x010ac0001c1d7984ULL, 0x002e640000004800ULL,
0x0000001d121b7224ULL, 0x002fe400078e021bULL, 0x00000001241d7824ULL, 0x000fe400078e0204ULL,
0x00005e001b1a7625ULL, 0x000fc600078e0026ULL, 0xfffffff022237812ULL, 0x000fe400078ee21dULL,
0x000000271a1c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001281a7824ULL, 0x000fe200078e0221ULL,
0x0000e00023237811ULL, 0x000fc600078e20ffULL, 0x000000ffff1d7224ULL, 0x000fca00008e061bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c237faeULL, 0x0003e2000c101c4cULL,
0x000000202900720cULL, 0x000fe20003f06070ULL, 0x0000001028297824ULL, 0x000fe400078e00ffULL,
0x010a080024227984ULL, 0x000ea60000004800ULL, 0xfffffff029237812ULL, 0x002fe400078ee22aULL,
0x0000000425297810ULL, 0x000fe40007ffe0ffULL, 0x0000e00023237811ULL, 0x000fc400078e20ffULL,
0x0000000529287c10ULL, 0x000fe4000fffe0ffULL, 0x0000000625257810ULL, 0x000fc60007ffe0ffULL,
0x00000001282a7824ULL, 0x000fe200078e0204ULL, 0x010ac000221b7984ULL, 0x004e640000004800ULL,
0x0000001b121a7224ULL, 0x002fc800078e021aULL, 0x00005e001a1a7625ULL, 0x000fca00078e0026ULL,
0x000000271a1c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001281a7824ULL, 0x000fc800078e0221ULL,
0x000000ffff1d7224ULL, 0x000fca00008e061bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c237faeULL, 0x0003e2000c101c4cULL, 0x000000202900720cULL, 0x000fe20003f06070ULL,
0x0000001028297824ULL, 0x000fe200078e00ffULL, 0x0000000525287c10ULL, 0x000fe2000fffe0ffULL,
0x010a100024227984ULL, 0x000ea80000004800ULL, 0x0000000128217824ULL, 0x000fe200078e0221ULL,
0xfffffff029237812ULL, 0x002fc800078ee22aULL, 0x0000e00023237811ULL, 0x000fe200078e20ffULL,
0x010ac000221b7984ULL, 0x004e640000004800ULL, 0x0000001b121a7224ULL, 0x002fc800078e021aULL,
0x00005e001a1a7625ULL, 0x000fca00078e0026ULL, 0x000000271a1c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fca00008e061bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c237faeULL, 0x0003e2000c101c4cULL, 0x000000202500720cULL, 0x000fc60003f06070ULL,
0x010a180024227984ULL, 0x000ea80000004800ULL, 0x010ac000221b7984ULL, 0x004ea40000004800ULL,
0x0000001b121b7224ULL, 0x004fe400078e0221ULL, 0x0000000128217824ULL, 0x000fe400078e0204ULL,
0x00005e001b1a7625ULL, 0x000fc800078e0026ULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x000000271a1a7210ULL, 0x000fc80007f3e0ffULL, 0xfffffff0281d7812ULL, 0x002fe200078ee221ULL,
0x000000ffff1b7224ULL, 0x000fc600008e061bULL, 0x0000e0001d1d7811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0003e2000c101c4cULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000504257c11ULL, 0x040fe2000f8fe0ffULL,
0x00000010041c7824ULL, 0x000fe200078e00ffULL, 0x0000002000247811ULL, 0x000fe200078e30ffULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x0000000225217810ULL, 0x040fe20007ffe0ffULL,
0x010a000025207984ULL, 0x000e620000004800ULL, 0x000000f01c297812ULL, 0x000fe200078ec0ffULL,
0x00000001251a7824ULL, 0x040fe400078e0224ULL, 0x00000001251d7824ULL, 0x000fc400078e0204ULL,
0x0000001025227824ULL, 0x000fe400078e00ffULL, 0x0000000121267824ULL, 0x000fc600078e0204ULL,
0xfffffff022237812ULL, 0x000fc800078ee21dULL, 0x0000e00023237811ULL, 0x000fe200078e20ffULL,
0x010ac000201b7984ULL, 0x002e640000004800ULL, 0x0000001b121a7224ULL, 0x002fc800078e021aULL,
0x00005e001a1a7625ULL, 0x000fca00078e0027ULL, 0x000000291a1c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001211a7824ULL, 0x040fe400078e0224ULL, 0x0000001021217824ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x000fc600000e061bULL, 0xfffffff021267812ULL, 0x000fe400078ee226ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c237faeULL, 0x0003e8000b901c4cULL,
0x010a080025227984ULL, 0x000ea20000004800ULL, 0x0000e00026237811ULL, 0x002fe400078e20ffULL,
0x00000004251d7810ULL, 0x000fca0007ffe0ffULL, 0x000000011d267824ULL, 0x000fe200078e0204ULL,
0x010ac000221b7984ULL, 0x004e640000004800ULL, 0x0000001b121a7224ULL, 0x002fc800078e021aULL,
0x00005e001a1a7625ULL, 0x000fca00078e0027ULL, 0x000000291a207210ULL, 0x000fe20007f1e0ffULL,
0x000000011d1a7824ULL, 0x040fe400078e0224ULL, 0x000000101d1d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fc600000e061bULL, 0xfffffff01d267812ULL, 0x000fe400078ee226ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e8000b901c4cULL,
0x010a100025227984ULL, 0x000ea20000004800ULL, 0x0000e00026217811ULL, 0x002fe400078e20ffULL,
0x0000000625237810ULL, 0x000fe20007ffe0ffULL, 0x010ac000221b7984ULL, 0x0042a80000004800ULL,
0x0000000123227824ULL, 0x002fc400078e0204ULL, 0x0000001b121a7224ULL, 0x004fc800078e021aULL,
0x00005e001a1a7625ULL, 0x000fca00078e0027ULL, 0x000000291a1c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001231a7824ULL, 0x040fe400078e0224ULL, 0x0000001023237824ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x000fc600000e061bULL, 0xfffffff023227812ULL, 0x000fe400078ee222ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e8000b901c4cULL,
0x010a180025207984ULL, 0x000ea20000004800ULL, 0x0000e000221d7811ULL, 0x002fc600078e20ffULL,
0x010ac000201b7984ULL, 0x004e640000004800ULL, 0x0000001b121a7224ULL, 0x002fc800078e021aULL,
0x00005e001a1a7625ULL, 0x000fca00078e0027ULL, 0x000000291a1a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a1d7faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff1a7f8cULL, 0x002e64000c80043fULL,
0x000000ffff237224ULL, 0x002fc400078e001bULL, 0x00000000001a7805ULL, 0x000fca0000015200ULL,
0x010b8c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c1a217210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e1bULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc8000001141dULL,
0x000000211c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x000000021c1c7819ULL, 0x000fc8000000121dULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000146300720cULL, 0x000fe20003f04070ULL, 0x0000020000017945ULL, 0x000fe20003800000ULL,
0x00000001131a7810ULL, 0x040fe40007ffe0ffULL, 0x000000031300780cULL, 0x000fe20003f45270ULL,
0x0000002003137824ULL, 0x000fe200078e0204ULL, 0x000000031a1b7812ULL, 0x000fc400078ec0ffULL,
0x000000146300720cULL, 0x000fe40003f24070ULL, 0x0000001f1300780cULL, 0x000fc60003f84070ULL,
0x00000002ff1a8819ULL, 0x000fca000001161aULL, 0x0000000119197824ULL, 0x000fc800078e021aULL,
0x00000040191a7824ULL, 0x040fe200078e00ffULL, 0x0000001419147211ULL, 0x000fc800078ff0ffULL,
0x000000c01a197812ULL, 0x000fca00078ec0ffULL, 0x00000100141c7824ULL, 0x000fe200078e0219ULL,
0x000000ff1b197207ULL, 0x000fe20004000000ULL, 0x0000011000009947ULL, 0x000fea0001000000ULL,
0x00000020031a7824ULL, 0x000fe200078e0204ULL, 0x0000000111117810ULL, 0x000fc80007ffe0ffULL,
0x000000031a00780cULL, 0x000fda0003f04070ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000001b7919ULL, 0x000e620000002700ULL, 0x0000640011147a10ULL, 0x040fe20007ffe0ffULL,
0x00000004ff1d7424ULL, 0x000fe200078e00ffULL, 0x000000641100720cULL, 0x000fe40003f06070ULL,
0x00010ac01a217811ULL, 0x000fe200078e10ffULL, 0x000000041b1b7824ULL, 0x002fc800078e021aULL,
0x000000021b1b7824ULL, 0x000fc800078e00ffULL, 0x000064001b147a24ULL, 0x000fc800078e0214ULL,
0x00006000141a7625ULL, 0x000fca00078e001dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a217faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x0000000a19147c10ULL, 0x000fe2000fffe0ffULL, 0x0000000113197824ULL, 0x100fe400078e021cULL,
0x00000004ff1b7424ULL, 0x002fe400078e00ffULL, 0x0000680014147a24ULL, 0x000fe200078e021cULL,
0x000000661900720cULL, 0x000fe40003f06070ULL, 0x00010a0013197811ULL, 0x040fe200078e10ffULL,
0x0000000113147824ULL, 0x000fc800078e0214ULL, 0x00006600141a7625ULL, 0x000fcc00078e001bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a197faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff7400720cULL, 0x000fe20003f05270ULL,
0x010b8000ff4a7f8cULL, 0x000ea2000c80043fULL, 0x0000080000017945ULL, 0x000fe20003800000ULL,
0xffffffffff147424ULL, 0x000fd400078e00ffULL, 0x000007d000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad800ff1a7f8cULL, 0x002e64000c800405ULL,
0x000000ffff207224ULL, 0x002fc400078e001bULL, 0x00000000001a7805ULL, 0x000fca0000015200ULL,
0x010adc05ff157984ULL, 0x000e640008000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c1a1c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e1bULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff157819ULL, 0x000fc8000001141dULL,
0x0000001c15157211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x0000000215157819ULL, 0x000fc8000000121cULL, 0x000000150000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000119197810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010adc05ff157984ULL, 0x000e640008000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001004157824ULL, 0x000fe200078e00ffULL, 0x00000001ff197819ULL, 0x000fc80000011604ULL,
0x0000007015157812ULL, 0x000fe400078ec0ffULL, 0x0000000c191a7812ULL, 0x000fca00078ec0ffULL,
0x00000001151a7824ULL, 0x000fca00078e021aULL, 0x010000001a1c7984ULL, 0x000e680000000800ULL,
0x010200001a197984ULL, 0x0006a20000000800ULL, 0x0000000f1c00720bULL, 0x002fe20003f1d000ULL,
0x000159927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x008fc800000e0100ULL,
0x0000ffff15227812ULL, 0x000fe2000780c0ffULL, 0x0000045000027945ULL, 0x000fe20003800000ULL,
0x00000001ff157424ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fd200078e000fULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05270ULL,
0x0000000f1c00720bULL, 0x000fe20003f34000ULL, 0x000159527f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x000fc400008e0100ULL, 0x0000001c0f1b7209ULL, 0x000fe20007810000ULL,
0x0000035000037945ULL, 0x000fe20003800000ULL, 0x000099101d207816ULL, 0x000fc600000000ffULL,
0x0104001b1a008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000001b0f0f7221ULL, 0x002fe20000010000ULL,
0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL, 0x0000000f001a7308ULL, 0x000e640000000800ULL,
0x0000001a0c0c7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0f7819ULL, 0x000fe20000011604ULL, 0x000158a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f1a0f7589ULL, 0x0002e400000e0000ULL, 0x0000000f0b0b7220ULL, 0x088fe20000410000ULL,
0x0000000f0a0a7220ULL, 0x080fe20000410000ULL, 0x0000000f07077220ULL, 0x080fe20000410000ULL,
0x0000000f06067220ULL, 0x080fe20000410000ULL, 0x0000000f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000000f4f4f7220ULL, 0x080fe20000410000ULL,
0x0000000f50507220ULL, 0x080fe20000410000ULL, 0x0000000f53537220ULL, 0x080fe20000410000ULL,
0x0000000f54547220ULL, 0x080fe20000410000ULL, 0x0000000f57577220ULL, 0x080fe20000410000ULL,
0x0000000f58587220ULL, 0x080fe20000410000ULL, 0x0000000f5b5b7220ULL, 0x080fe20000410000ULL,
0x0000000f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000000f5f5f7220ULL, 0x080fe20000410000ULL,
0x0000000f60607220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008040f7811ULL, 0x000fe200078ff0ffULL, 0x000157a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f1a0f7589ULL, 0x00066400000e0000ULL, 0x0000000f09097220ULL, 0x082fe20000410000ULL,
0x0000000f08087220ULL, 0x080fe20000410000ULL, 0x0000000f05057220ULL, 0x080fe20000410000ULL,
0x0000000f1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000000f4e4e7220ULL, 0x080fe20000410000ULL, 0x0000000f51517220ULL, 0x080fe20000410000ULL,
0x0000000f52527220ULL, 0x080fe20000410000ULL, 0x0000000f55557220ULL, 0x080fe20000410000ULL,
0x0000000f56567220ULL, 0x080fe20000410000ULL, 0x0000000f59597220ULL, 0x080fe20000410000ULL,
0x0000000f5a5a7220ULL, 0x080fe20000410000ULL, 0x0000000f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000000f5e5e7220ULL, 0x080fe20000410000ULL, 0x0000000f61617220ULL, 0x080fe20000410000ULL,
0x0000000f62627220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff22ff7812ULL, 0x000fda000780601dULL, 0x8000001b1c1c0221ULL, 0x000fe20000010000ULL,
0x00007610ff150816ULL, 0x000fc60000000015ULL, 0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL,
0x0000001c00160308ULL, 0x000e640000000800ULL, 0x0000001619190220ULL, 0x006fcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000c190c7221ULL, 0x004fe20000010000ULL,
0x000000ffff0f7224ULL, 0x000fc400078e001bULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff15ff7812ULL, 0x000fe2000782c0ffULL, 0x0000014000017945ULL, 0x000fd80003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000016ff17723eULL, 0x000fe400000000ffULL,
0x00000002ff1a7819ULL, 0x00afe40000011604ULL, 0x0000541017197816ULL, 0x000fe20000000017ULL,
0x000155d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1a19177589ULL, 0x0002e400000e0000ULL,
0x000000081a187810ULL, 0x000fe20007ffe0ffULL, 0x000156027f007947ULL, 0x000fea000b800000ULL,
0x00001f1819187589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101a277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0019ULL,
0x00003a6000207802ULL, 0x000fc40000000f00ULL, 0x0001646000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181a277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x004fe200078e0019ULL, 0x00003ab000207802ULL, 0x000fc40000000f00ULL,
0x0001641000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000008046d7812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff1a7819ULL, 0x10afe20000011604ULL, 0x0000000208047891ULL, 0x000fe2000f8e103fULL,
0x0000000704697812ULL, 0x000fe200078ec0ffULL, 0x0000086000017945ULL, 0x000fe20003800000ULL,
0x000000076d6d7812ULL, 0x000fe200078ef804ULL, 0x00000004034a7824ULL, 0x004fe200078e021aULL,
0x0000000869697812ULL, 0x000fc400078ef804ULL, 0x000000106d397812ULL, 0x040fe200078efcffULL,
0x000000016d197824ULL, 0x040fe200078e024aULL, 0x000000041a707c10ULL, 0x040fe2000fffe0ffULL,
0x000000106d1c7824ULL, 0x000fe200078e00ffULL, 0x0000000439727c10ULL, 0x000fe2000fffe01aULL,
0x000000011a687824ULL, 0x000fe200078e0269ULL, 0x000000106300720cULL, 0x000fe20003fc3070ULL,
0x00000008691d7824ULL, 0x000fe200078e00ffULL, 0xfffffff01c1b7812ULL, 0x000fe200078ee219ULL,
0x000000014a717824ULL, 0x000fe200078e0239ULL, 0x00000002681c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001039207824ULL, 0x000fe200078e00ffULL, 0xfffffff81d197812ULL, 0x000fe200078ee268ULL,
0x000000106d317824ULL, 0x000fe200078e00ffULL, 0x0000c0001b1b7811ULL, 0x000fe200078e20ffULL,
0x0000001039397824ULL, 0x000fe200078e00ffULL, 0x0000a00019447811ULL, 0x000fc400078e20ffULL,
0xfffffff020717812ULL, 0x000fe200078ee271ULL, 0x000000001b2c783bULL, 0x000e620000004200ULL,
0xfffffff81d1c7812ULL, 0x000fe400078ee21cULL, 0x0000c000711d7811ULL, 0x000fe200078e20ffULL,
0x000000004444783bULL, 0x000ea20000000200ULL, 0x0000a0001c207811ULL, 0x000fe400078e20ffULL,
0xfffffff039727812ULL, 0x000fe200078ee272ULL, 0x000000001d28783bULL, 0x000fe20000004200ULL,
0x000000106300720cULL, 0x000fc40003f03070ULL, 0x0000c000726a7811ULL, 0x000fe200078e20ffULL,
0x000000002020783bULL, 0x000ee20000000200ULL, 0x000031202c347816ULL, 0x002fe200000000ffULL,
0x000000016d2c7824ULL, 0x000fe200078e0270ULL, 0x000031202d2d7816ULL, 0x000fe200000000ffULL,
0x0000001744449232ULL, 0x084fe20000000000ULL, 0x00000034ff24723eULL, 0x080fe200020006ffULL,
0x0000001746469232ULL, 0x080fe20000000000ULL, 0x0000002dff25723eULL, 0x080fe200020006ffULL,
0x0000001845459232ULL, 0x080fe20000000000ULL, 0xfffffff0312c7812ULL, 0x000fe200078ee22cULL,
0x0000001847479232ULL, 0x080fe20000000000ULL, 0x00000034ff34723eULL, 0x000fe200030006ffULL,
0x0000001720209232ULL, 0x088fe20000000000ULL, 0x0000002dff35723eULL, 0x000fe200030006ffULL,
0x0000001722229232ULL, 0x000fe20000000000ULL, 0x0000c0002c677811ULL, 0x000fe200078e20ffULL,
0x0000001821219232ULL, 0x080fe20000000000ULL, 0x000000244424723cULL, 0x000f6200000018ffULL,
0x000031202e2e7816ULL, 0x000fe200000000ffULL, 0x0000001823239232ULL, 0x000fe20000000000ULL,
0x000031202f317816ULL, 0x000fe200000000ffULL, 0x00000000673c783bULL, 0x000e620000004200ULL,
0x0000312028327816ULL, 0x000fc400000000ffULL, 0x0000312029387816ULL, 0x000fe200000000ffULL,
0x000000344434723cULL, 0x000f6200000018ffULL, 0x0000002eff2c723eULL, 0x000fe400020006ffULL,
0x00000031ff2d723eULL, 0x000fe400020006ffULL, 0x00000032ff28723eULL, 0x000fe400020006ffULL,
0x00000038ff29723eULL, 0x000fe400020006ffULL, 0x0000002eff30723eULL, 0x000fc400030006ffULL,
0x0000002c442c723cULL, 0x000f6200000018ffULL, 0x00000031ff31723eULL, 0x000fe400030006ffULL,
0x000031202a3a7816ULL, 0x000fe400000000ffULL, 0x000031202b3b7816ULL, 0x000fc600000000ffULL,
0x000000282024723cULL, 0x020be20000001824ULL, 0x0000003bff39723eULL, 0x000fcc00020006ffULL,
0x00000032ff28723eULL, 0x020fe400030006ffULL, 0x00000038ff29723eULL, 0x000fe200030006ffULL,
0x000000304430723cULL, 0x000f6200000018ffULL, 0x0000003aff38723eULL, 0x000fe400020006ffULL,
0x000031203c3c7816ULL, 0x002fca00000000ffULL, 0x000000282028723cULL, 0x040be20000001834ULL,
0x000031203d3d7816ULL, 0x000fe200000000ffULL, 0x000000006a34783bULL, 0x020e620000004200ULL,
0x000031203e487816ULL, 0x000fe400000000ffULL, 0x000031203f497816ULL, 0x000fe400000000ffULL,
0x00000048ff40723eULL, 0x080fe200020006ffULL, 0x00000038202c723cULL, 0x000be2000000182cULL,
0x00000049ff41723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fc400030006ffULL,
0x00000049ff49723eULL, 0x000fe400030006ffULL, 0x0000003aff38723eULL, 0x020fe200030006ffULL,
0x000000404440723cULL, 0x000fe200000018ffULL, 0x0000003bff39723eULL, 0x000fce00030006ffULL,
0x000000382030723cULL, 0x000bee0000001830ULL, 0x0000003cff38723eULL, 0x0a0fe400020006ffULL,
0x0000003dff39723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fc400030006ffULL,
0x0000003dff3d723eULL, 0x000fc600030006ffULL, 0x000000384438723cULL, 0x000f6200000018ffULL,
0x00003120346b7816ULL, 0x002fe400000000ffULL, 0x00003120356c7816ULL, 0x000fe400000000ffULL,
0x0000006bff34723eULL, 0x000fc600020006ffULL, 0x0000003c443c723cULL, 0x000f6200000018ffULL,
0x0000006cff35723eULL, 0x000fe400020006ffULL, 0x0000312036367816ULL, 0x000fe400000000ffULL,
0x0000312037377816ULL, 0x000fc600000000ffULL, 0x000000484444723cULL, 0x000b6e00000018ffULL,
0x0000000174487810ULL, 0x020fe20007ffe0ffULL, 0x000000342038723cULL, 0x000b6e0000001838ULL,
0x0000006bff34723eULL, 0x020fc400030006ffULL, 0x0000006cff35723eULL, 0x000fe400030006ffULL,
0x00000002ff6c7819ULL, 0x000fc80000011604ULL, 0x000000746c00720cULL, 0x040fe20003f46070ULL,
0x00000034203c723cULL, 0x000b62000000183cULL, 0x000000086c6b7810ULL, 0x040fe40007ffe0ffULL,
0x000000486c00720cULL, 0x000fe40005746470ULL, 0x000000746b00720cULL, 0x000fe40003f66070ULL,
0x00000036ff34723eULL, 0x020fe400020006ffULL, 0x00000037ff35723eULL, 0x000fc400020006ffULL,
0x000000486b00720cULL, 0x000fca0005f66470ULL, 0x000000342040723cULL, 0x000b6e0000001840ULL,
0x00000036ff34723eULL, 0x020fe400030006ffULL, 0x00000037ff35723eULL, 0x000fce00030006ffULL,
0x000000342044723cULL, 0x000b620000001844ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240b0b7221ULL, 0x000fe20000010000ULL,
0x000000250a0a7221ULL, 0x000fe20000010000ULL, 0x0000002807077221ULL, 0x000fe20000010000ULL,
0x0000002906067221ULL, 0x000fe20000010000ULL, 0x0000002c1f1f7221ULL, 0x000fe20000010000ULL,
0x0000002d4c4c7221ULL, 0x000fe20000010000ULL, 0x000000304f4f7221ULL, 0x000fe20000010000ULL,
0x0000003150507221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003954547221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x000fe20000010000ULL,
0x0000003d58587221ULL, 0x000fe20000010000ULL, 0x000000405b5b7221ULL, 0x000fe20000010000ULL,
0x000000415c5c7221ULL, 0x000fe20000010000ULL, 0x000000445f5f7221ULL, 0x020fe20000010000ULL,
0x0000004560607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x0000002609097221ULL, 0x000fe20000010000ULL, 0x0000002708087221ULL, 0x000fe20000010000ULL,
0x0000002a05057221ULL, 0x000fe20000010000ULL, 0x0000002b1e1e7221ULL, 0x000fe20000010000ULL,
0x0000002e4d4d7221ULL, 0x000fe20000010000ULL, 0x0000002f4e4e7221ULL, 0x000fe20000010000ULL,
0x0000003251517221ULL, 0x000fe20000010000ULL, 0x0000003352527221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b56567221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x000fe20000010000ULL, 0x0000003f5a5a7221ULL, 0x000fe20000010000ULL,
0x000000425d5d7221ULL, 0x000fe20000010000ULL, 0x000000435e5e7221ULL, 0x000fe20000010000ULL,
0x0000004661617221ULL, 0x020fe20000010000ULL, 0x0000004762627221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x020e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011648ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000000106300720cULL, 0x000fc40003f03070ULL,
0x0000002348257207ULL, 0x040fe40002800000ULL, 0x000000106300720cULL, 0x000fe40003fc3070ULL,
0x00000001ff2a7803ULL, 0x000fe40000000000ULL, 0x0000000325237812ULL, 0x000fe400078ec0ffULL,
0x0000000348207812ULL, 0x002fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x000fc600078e0021ULL,
0x000000ff20217207ULL, 0x000fe40006800000ULL, 0x0000001025207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8400ff227984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe2000780484bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff227984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000022ff7812ULL, 0x002fe2000780482bULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120227810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000652200720cULL, 0x000fda0003f06070ULL,
0x0000051000008947ULL, 0x000fea0003800000ULL, 0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000420277824ULL, 0x000fe200078e0223ULL, 0x000000021a2e7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2c7424ULL, 0x000fe400078e00ffULL, 0x010a00002b227984ULL, 0x000e620000004800ULL,
0x0000004027277824ULL, 0x000fe200078e00ffULL, 0x000000052e317c10ULL, 0x000fe2000fffe0ffULL,
0x0000004000287824ULL, 0x000fe400078e022bULL, 0x0000001004267824ULL, 0x000fc400078e00ffULL,
0x0000000131307824ULL, 0x140fe400078e0204ULL, 0x0000001031317824ULL, 0x000fe200078e00ffULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x000000012b267824ULL, 0x000fc600078e0204ULL,
0xfffffff031307812ULL, 0x000fe200078ee230ULL, 0x010ac00022257984ULL, 0x0022a40000004800ULL,
0x0000002766227217ULL, 0x002fca0007800000ULL, 0x0000000122227824ULL, 0x000fe400078e0a27ULL,
0x000000102b277824ULL, 0x000fc600078e00ffULL, 0x0000000522227c17ULL, 0x000fe4000f800000ULL,
0xfffffff027267812ULL, 0x000fe400078ee226ULL, 0x8000000522297c10ULL, 0x000fe4000fffe0ffULL,
0x0000c000262f7811ULL, 0x000fe400078e20ffULL, 0x0000000228267810ULL, 0x000fe20007ffe0ffULL,
0x0000002512257224ULL, 0x004fc800078e0228ULL, 0x00005e0025247625ULL, 0x000fca00078e002cULL,
0x0000002d24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000291a00720cULL, 0x000fda0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000c101c4cULL, 0x010a08002b227984ULL, 0x000ea20000004800ULL,
0x0000c000302f7811ULL, 0x002fe400078e20ffULL, 0x0000000428247810ULL, 0x040fe40007ffe0ffULL,
0x0000000628287810ULL, 0x000fe20007ffe0ffULL, 0x010ac00022277984ULL, 0x004e640000004800ULL,
0x0000002712277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002d26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000292e00720cULL, 0x000fe40003f06070ULL, 0x000000041a2e7810ULL, 0x000fc80007ffe0ffULL,
0x000000052e317c10ULL, 0x000fca000fffe0ffULL, 0x0000000131307824ULL, 0x040fe400078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c4cULL,
0x0000001031317824ULL, 0x000fc600078e00ffULL, 0x010a10002b227984ULL, 0x000ea40000004800ULL,
0xfffffff031307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x002fe200078e20ffULL,
0x010ac00022257984ULL, 0x004e640000004800ULL, 0x0000002512257224ULL, 0x002fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002cULL, 0x0000002d24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x000000292e00720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000c101c4cULL,
0x010a18002b227984ULL, 0x000ea80000004800ULL, 0x010ac00022277984ULL, 0x004ea40000004800ULL,
0x0000002712277224ULL, 0x004fe200078e0228ULL, 0x000000061a287810ULL, 0x000fc60007ffe0ffULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002d26267210ULL, 0x000fe40007f1e0ffULL,
0x00000005282d7c10ULL, 0x000fc6000fffe0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000292800720cULL, 0x000fe20003f06070ULL, 0x000000012d2c7824ULL, 0x040fe400078e0204ULL,
0x000000102d2d7824ULL, 0x000fca00078e00ffULL, 0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL,
0x0000c0002c257811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000c101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051a2d7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2e7424ULL, 0x000fe400078e00ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000022d297810ULL, 0x000fe20007ffe0ffULL,
0x010a00002d227984ULL, 0x000e620000004800ULL, 0x00000040002c7824ULL, 0x000fe400078e022dULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x0000000129287824ULL, 0x000fc400078e0204ULL,
0x0000001029297824ULL, 0x000fca00078e00ffULL, 0xfffffff029287812ULL, 0x000fc800078ee228ULL,
0x0000c00028297811ULL, 0x000fe200078e20ffULL, 0x010ac00022257984ULL, 0x002e640000004800ULL,
0x0000002512257224ULL, 0x002fc800078e022cULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002f24267210ULL, 0x000fe20007f1e0ffULL, 0x000000012d247824ULL, 0x000fc800078e0204ULL,
0x000000ffff277224ULL, 0x000fe400000e0625ULL, 0x000000102d257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000c000242b7811ULL, 0x000fe400078e20ffULL,
0x000000022c247810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e8000b901c4cULL, 0x010a08002d227984ULL, 0x000ea20000004800ULL,
0x000000042c267810ULL, 0x042fe40007ffe0ffULL, 0x000000042d2b7810ULL, 0x000fe40007ffe0ffULL,
0x000000062c2c7810ULL, 0x000fc60007ffe0ffULL, 0x000000012b287824ULL, 0x040fe400078e0204ULL,
0x000000102b2b7824ULL, 0x000fca00078e00ffULL, 0xfffffff02b287812ULL, 0x000fe400078ee228ULL,
0x000000062d2b7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00022257984ULL, 0x004e640000004800ULL,
0x0000002512257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e8000b901c4cULL,
0x010a10002d227984ULL, 0x000ea20000004800ULL, 0x0000c00028297811ULL, 0x002fe200078e20ffULL,
0x000000012b287824ULL, 0x040fe400078e0204ULL, 0x000000102b2b7824ULL, 0x000fca00078e00ffULL,
0xfffffff02b287812ULL, 0x000fe200078ee228ULL, 0x010ac00022277984ULL, 0x004e640000004800ULL,
0x0000002712277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002eULL,
0x0000002f26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c4cULL,
0x010a18002d227984ULL, 0x000ea20000004800ULL, 0x0000c00028277811ULL, 0x002fc600078e20ffULL,
0x010ac00022257984ULL, 0x004e640000004800ULL, 0x0000002512257224ULL, 0x002fc800078e022cULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe2000780482bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000206300720cULL, 0x000fe40003f04070ULL, 0x00010a0013257811ULL, 0x000fe400078e10ffULL,
0x000000ff21227207ULL, 0x000fc40000000000ULL, 0x000000ff21247207ULL, 0x000fc60004000000ULL,
0x0000000123237824ULL, 0x000fc800078e0222ULL, 0x0000004023217824ULL, 0x040fe200078e00ffULL,
0x0000002023207211ULL, 0x000fc800078ff0ffULL, 0x000000c021217812ULL, 0x000fca00078ec0ffULL,
0x0000010020207824ULL, 0x000fe200078e0221ULL, 0x0000000a24217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000113237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x000000662300720cULL, 0x000fe20003f06070ULL, 0x0000000113207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff207f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff757224ULL, 0x002fe200078e0021ULL, 0x0000010000001947ULL, 0x000fea0003800000ULL,
0x00000016ff17723eULL, 0x000fc800000000ffULL, 0x0000541017227816ULL, 0x000fe20000000017ULL,
0x000137b27f007947ULL, 0x000fea000b800000ULL, 0x00001f6c22177589ULL, 0x0002a400000e0000ULL,
0x000137f27f007947ULL, 0x000fea000b800000ULL, 0x00001f6b22187589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000106c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000593000207802ULL, 0x000fc40000000f00ULL,
0x0001459000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x000000186c277810ULL, 0x002fe40007ffe0ffULL,
0x0000598000207802ULL, 0x000fc40000000f00ULL, 0x0001454000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016d4a7824ULL, 0x040fe200078e024aULL,
0x00000004686f7810ULL, 0x000fe20007ffe0ffULL, 0x000000106d217824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000869207824ULL, 0x000fe200078e00ffULL,
0x0000e00071717811ULL, 0x000fe200078e20ffULL, 0x000000016d707824ULL, 0x000fe200078e0270ULL,
0xfffffff0214a7812ULL, 0x000fe200078ee24aULL, 0x000000106d6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8206f7812ULL, 0x000fe200078ee26fULL, 0x0000000869697824ULL, 0x000fe200078e00ffULL,
0x0000e0004a6e7811ULL, 0x000fe200078e20ffULL, 0x00000000712c783bULL, 0x000f220000004200ULL,
0x0000a0006f4b7811ULL, 0x000fe200078e20ffULL, 0x0000067000017945ULL, 0x000fe20003800000ULL,
0xfffffff06d6d7812ULL, 0x000fe200078ee270ULL, 0x000000006e20783bULL, 0x00ae620000004200ULL,
0x0000000668707810ULL, 0x000fc40007ffe0ffULL, 0x0000e0006d6d7811ULL, 0x000fe200078e20ffULL,
0x000000004b48783bULL, 0x000ee20000000200ULL, 0xfffffff869707812ULL, 0x000fe400078ee270ULL,
0x0000e00072727811ULL, 0x000fe200078e20ffULL, 0x000000006d3c783bULL, 0x000ea20000004200ULL,
0x000000ff2a00720cULL, 0x000fc60003f05270ULL, 0x000000007244783bULL, 0x000ea20000004200ULL,
0x000031202c737816ULL, 0x010fe400000000ffULL, 0x000031202d767816ULL, 0x000fe400000000ffULL,
0x0000312020207816ULL, 0x002fe400000000ffULL, 0x0000312021217816ULL, 0x000fe400000000ffULL,
0x00000020ff24723eULL, 0x080fe200020006ffULL, 0x0000001748489232ULL, 0x08cfe20000000000ULL,
0x00000020ff28723eULL, 0x000fe200030006ffULL, 0x000000174a4a9232ULL, 0x000fe20000000000ULL,
0x0000312022227816ULL, 0x000fe200000000ffULL, 0x0000001849499232ULL, 0x080fe20000000000ULL,
0x0000312023237816ULL, 0x000fe200000000ffULL, 0x000000184b4b9232ULL, 0x000fe20000000000ULL,
0x0000a00070207811ULL, 0x000fc400078e20ffULL, 0x00000021ff25723eULL, 0x080fe400020006ffULL,
0x00000021ff29723eULL, 0x000fe400030006ffULL, 0x00000022ff30723eULL, 0x080fe400020006ffULL,
0x00000023ff31723eULL, 0x080fe200020006ffULL, 0x000000244824723cULL, 0x000f6200000018ffULL,
0x00000022ff34723eULL, 0x000fe400030006ffULL, 0x00000023ff35723eULL, 0x000fc400030006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x00000073ff2c723eULL, 0x000fe400020006ffULL,
0x000000284828723cULL, 0x040f6200000018ffULL, 0x00000076ff2d723eULL, 0x000fe400020006ffULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x0000003cff38723eULL, 0x000fe200020006ffULL, 0x000000304830723cULL, 0x000f6200000018ffULL,
0x0000003dff39723eULL, 0x000fc400020006ffULL, 0x000031202e2e7816ULL, 0x000fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fe400000000ffULL, 0x0000003cff3c723eULL, 0x000fe200030006ffULL,
0x000000344834723cULL, 0x000f6200000018ffULL, 0x0000003dff3d723eULL, 0x000fe400030006ffULL,
0x000031203e687816ULL, 0x000fe400000000ffULL, 0x000031203f697816ULL, 0x000fc400000000ffULL,
0x00000068ff40723eULL, 0x080fe200020006ffULL, 0x000000384838723cULL, 0x040f6200000018ffULL,
0x00000069ff41723eULL, 0x080fe400020006ffULL, 0x0000312044447816ULL, 0x000fe400000000ffULL,
0x0000312045457816ULL, 0x000fe400000000ffULL, 0x00000068ff68723eULL, 0x000fe200030006ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x00000069ff69723eULL, 0x000fc400030006ffULL,
0x0000312046467816ULL, 0x000fe200000000ffULL, 0x0000001720209232ULL, 0x082fe20000000000ULL,
0x0000312047477816ULL, 0x000fe200000000ffULL, 0x0000001722229232ULL, 0x000fe40000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x0000001821219232ULL, 0x080fe40000000000ULL,
0x0000001823239232ULL, 0x000fca0000000000ULL, 0x000000684848723cULL, 0x000f7000000018ffULL,
0x0000002c2024723cULL, 0x020b6e0000001824ULL, 0x00000073ff2c723eULL, 0x020fc400030006ffULL,
0x00000076ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2028723cULL, 0x000b6e0000001828ULL,
0x0000002eff2c723eULL, 0x020fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2030723cULL, 0x000b6e0000001830ULL, 0x0000002eff2c723eULL, 0x020fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2034723cULL, 0x000b6e0000001834ULL,
0x00000044ff2c723eULL, 0x020fe400020006ffULL, 0x00000045ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2038723cULL, 0x000b6e0000001838ULL, 0x00000044ff2c723eULL, 0x020fe400030006ffULL,
0x00000045ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c203c723cULL, 0x000b6e000000183cULL,
0x00000046ff2c723eULL, 0x020fe400020006ffULL, 0x00000047ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2040723cULL, 0x000b6e0000001840ULL, 0x00000046ff2c723eULL, 0x020fe400030006ffULL,
0x00000047ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000000000ULL,
0x000000240b0b7221ULL, 0x000fe20000010000ULL, 0x000000250a0a7221ULL, 0x000fe20000010000ULL,
0x0000002807077221ULL, 0x000fe20000010000ULL, 0x0000002906067221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314c4c7221ULL, 0x000fe20000010000ULL,
0x000000344f4f7221ULL, 0x000fe20000010000ULL, 0x0000003550507221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003954547221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x000fe20000010000ULL, 0x0000003d58587221ULL, 0x000fe20000010000ULL,
0x000000405b5b7221ULL, 0x000fe20000010000ULL, 0x000000415c5c7221ULL, 0x000fe20000010000ULL,
0x000000485f5f7221ULL, 0x020fe20000010000ULL, 0x0000004960607221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x0000002609097221ULL, 0x000fe20000010000ULL,
0x0000002708087221ULL, 0x000fe20000010000ULL, 0x0000002a05057221ULL, 0x000fe20000010000ULL,
0x0000002b1e1e7221ULL, 0x000fe20000010000ULL, 0x000000324d4d7221ULL, 0x000fe20000010000ULL,
0x000000334e4e7221ULL, 0x000fe20000010000ULL, 0x0000003651517221ULL, 0x000fe20000010000ULL,
0x0000003752527221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b56567221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x000fe20000010000ULL,
0x0000003f5a5a7221ULL, 0x000fe20000010000ULL, 0x000000425d5d7221ULL, 0x000fe20000010000ULL,
0x000000435e5e7221ULL, 0x000fe20000010000ULL, 0x0000004a61617221ULL, 0x020fe20000010000ULL,
0x0000004b62627221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000174747810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff737424ULL, 0x000fe200078e00ffULL, 0x010b8800ff227f8cULL, 0x020e68000c80043fULL,
0x0000000173737807ULL, 0x000fc80006800000ULL, 0x000000737400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb98000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004010217811ULL, 0x000fe200078e40ffULL,
0x010b5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000662100720cULL, 0x000fda0003f06070ULL,
0x0000ca8000000947ULL, 0x000fea0003800000ULL, 0x000000ffff747224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x000fe20000011674ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000374227812ULL, 0x042fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000002174217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000121257810ULL, 0x000fc80007ffe0ffULL, 0x0000000325217812ULL, 0x040fe400078ec0ffULL,
0x0000001025207211ULL, 0x000fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x000fe20007ffe0ffULL, 0x0000099000017945ULL, 0x000fe60003800000ULL,
0x000000652400720cULL, 0x000fda0003f06070ULL, 0x0000052000008947ULL, 0x000fea0003800000ULL,
0x000000051a297c10ULL, 0x000fe2000fffe0ffULL, 0x0000000420237824ULL, 0x000fe200078e0221ULL,
0x00000020002a7811ULL, 0x000fe200078e30ffULL, 0x00000100ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000021a2e7810ULL, 0x000fe20007ffe0ffULL, 0x010a000029257984ULL, 0x000e620000004800ULL,
0x0000002023237811ULL, 0x000fe200078e30ffULL, 0x0000000129267824ULL, 0x040fe200078e022aULL,
0x000000052e2f7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000129277824ULL, 0x040fe200078e0204ULL,
0x0000002366247217ULL, 0x000fe20007800000ULL, 0x0000001029287824ULL, 0x000fc400078e00ffULL,
0x000000012f307824ULL, 0x000fe400078e0204ULL, 0x0000000124247824ULL, 0x000fe400078e0a23ULL,
0x0000001004237824ULL, 0x000fc600078e00ffULL, 0x0000000524247c17ULL, 0x000fe4000f800000ULL,
0x000000f0232b7812ULL, 0x000fe400078ec0ffULL, 0x8000000524237c10ULL, 0x000fc8000fffe0ffULL,
0x000000231a00720cULL, 0x000fe20003f06070ULL, 0x010ac00025257984ULL, 0x002e640000004800ULL,
0x0000002512267224ULL, 0x002fc800078e0226ULL, 0x00005e0026247625ULL, 0x000fca00078e002cULL,
0x0000002b24267210ULL, 0x000fe40007f3e0ffULL, 0xfffffff028247812ULL, 0x000fc600078ee227ULL,
0x000000ffff277224ULL, 0x000fe200008e0625ULL, 0x0000e000242d7811ULL, 0x000fe200078e20ffULL,
0x000000012f247824ULL, 0x040fe400078e022aULL, 0x000000102f2f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e2000c101c4cULL,
0x000000232e00720cULL, 0x000fe40003f06070ULL, 0xfffffff02f307812ULL, 0x000fe200078ee230ULL,
0x010a080029287984ULL, 0x000ea20000004800ULL, 0x000000041a2e7810ULL, 0x000fc80007ffe0ffULL,
0x000000052e2f7c10ULL, 0x000fe4000fffe0ffULL, 0x0000e000302d7811ULL, 0x002fc600078e20ffULL,
0x000000012f307824ULL, 0x000fe200078e0204ULL, 0x010ac00028257984ULL, 0x004e640000004800ULL,
0x0000002512257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002cULL,
0x0000002b24267210ULL, 0x000fe20007f3e0ffULL, 0x000000012f247824ULL, 0x040fe400078e022aULL,
0x000000102f2f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc600008e0625ULL,
0xfffffff02f307812ULL, 0x000fe400078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262d7faeULL, 0x0003e2000c101c4cULL, 0x000000232e00720cULL, 0x000fe40003f06070ULL,
0x000000061a2e7810ULL, 0x000fe20007ffe0ffULL, 0x010a100029287984ULL, 0x000ea60000004800ULL,
0x000000052e2f7c10ULL, 0x000fe4000fffe0ffULL, 0x0000e000302d7811ULL, 0x002fc600078e20ffULL,
0x000000012f2a7824ULL, 0x000fe200078e022aULL, 0x010ac00028257984ULL, 0x004e640000004800ULL,
0x0000002512257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002cULL,
0x0000002b24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242d7faeULL, 0x0003e2000c101c4cULL,
0x000000232e00720cULL, 0x000fc60003f06070ULL, 0x010a180029287984ULL, 0x000ea80000004800ULL,
0x010ac00028277984ULL, 0x004ea40000004800ULL, 0x0000002712277224ULL, 0x004fe400078e022aULL,
0x000000012f2a7824ULL, 0x000fe400078e0204ULL, 0x00005e0027267625ULL, 0x000fc800078e002cULL,
0x000000102f2f7824ULL, 0x000fe200078e00ffULL, 0x0000002b26247210ULL, 0x002fc80007f3e0ffULL,
0xfffffff02f2a7812ULL, 0x000fe200078ee22aULL, 0x000000ffff257224ULL, 0x000fc600008e0627ULL,
0x0000e0002a237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e2000c101c4cULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x000000051a2d7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001004257824ULL, 0x000fe200078e00ffULL,
0x00000020002a7811ULL, 0x000fe200078e30ffULL, 0x00000100ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000022d297810ULL, 0x000fe20007ffe0ffULL, 0x010a00002d237984ULL, 0x000e620000004800ULL,
0x000000f025317812ULL, 0x000fe200078ec0ffULL, 0x000000012d247824ULL, 0x040fe400078e022aULL,
0x000000012d277824ULL, 0x000fc400078e0204ULL, 0x000000102d287824ULL, 0x000fe400078e00ffULL,
0x00000001292c7824ULL, 0x000fe200078e0204ULL, 0x010ac00023237984ULL, 0x002e640000004800ULL,
0x0000002312247224ULL, 0x002fe200078e0224ULL, 0xfffffff028237812ULL, 0x000fc600078ee227ULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000e000232b7811ULL, 0x000fc800078e20ffULL,
0x0000003124267210ULL, 0x000fe20007f1e0ffULL, 0x000000012a247824ULL, 0x000fe400078e0229ULL,
0x0000001029297824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc600000e0625ULL,
0xfffffff0292c7812ULL, 0x000fe400078ee22cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e8000b901c4cULL, 0x010a08002d237984ULL, 0x000ea20000004800ULL,
0x0000e0002c2b7811ULL, 0x002fe400078e20ffULL, 0x000000042d277810ULL, 0x000fca0007ffe0ffULL,
0x00000001272c7824ULL, 0x000fe200078e0204ULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002312247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002fULL,
0x0000003124287210ULL, 0x000fe20007f1e0ffULL, 0x000000012a247824ULL, 0x000fe400078e0227ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x000000ffff297224ULL, 0x000fc600000e0625ULL,
0xfffffff0272c7812ULL, 0x000fe400078ee22cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e8000b901c4cULL, 0x010a10002d237984ULL, 0x000ea20000004800ULL,
0x0000e0002c297811ULL, 0x002fe400078e20ffULL, 0x000000062d2b7810ULL, 0x000fca0007ffe0ffULL,
0x000000012b287824ULL, 0x000fe200078e0204ULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002312247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002fULL,
0x0000003124267210ULL, 0x000fe20007f1e0ffULL, 0x000000012a247824ULL, 0x000fe400078e022bULL,
0x000000102b2b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc600000e0625ULL,
0xfffffff02b287812ULL, 0x000fe400078ee228ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c4cULL, 0x010a18002d237984ULL, 0x000ea20000004800ULL,
0x0000e00028277811ULL, 0x002fc600078e20ffULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002312247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002fULL,
0x0000003124247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e6000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000206300720cULL, 0x000fe20003f04070ULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000032200780cULL, 0x000fda0003f25270ULL,
0x0000010000008947ULL, 0x000fea0000800000ULL, 0x000000031300780cULL, 0x000fe40003f04070ULL,
0x0000000111117810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000247919ULL, 0x000e620000002700ULL, 0x000000641100720cULL, 0x040fe20003f06070ULL,
0x00000004ff257424ULL, 0x000fe400078e00ffULL, 0x0000000424237824ULL, 0x002fe200078e0213ULL,
0x0000640011247a10ULL, 0x000fc60007ffe0ffULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00010ac013237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000206300720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020227824ULL, 0x000fe200078e0221ULL,
0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL, 0x00010a0013237811ULL, 0x040fe200078e10ffULL,
0x0000000113217824ULL, 0x100fe400078e0222ULL, 0x0000680020207a24ULL, 0x000fc600078e0222ULL,
0x000000662100720cULL, 0x000fe20003f06070ULL, 0x00000004ff217424ULL, 0x000fe400078e00ffULL,
0x0000000113207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fcc00078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff7400720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff757224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010af800ff207f8cULL, 0x000e64000c800405ULL,
0x000000ffff247224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010afc05ff157984ULL, 0x000e640008000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220227210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff157819ULL, 0x000fc80000011423ULL,
0x0000002215157211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0623ULL,
0x0000000215157819ULL, 0x000fc80000001222ULL, 0x000000150000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010afc05ff157984ULL, 0x000e640008000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001004157824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011604ULL,
0x0000007015157812ULL, 0x000fe400078ec0ffULL, 0x0000000c20207812ULL, 0x000fca00078ec0ffULL,
0x0000000115277824ULL, 0x000fca00078e0220ULL, 0x0100800027227984ULL, 0x000e680000000800ULL,
0x0102800027237984ULL, 0x0004e20000000800ULL, 0x0000000f2200720bULL, 0x002fe20003f1d000ULL,
0x000115927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x004fc800000e0100ULL,
0x0000ffff15287812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff157424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e000fULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000010300780cULL, 0x000fe40003f05270ULL,
0x0000000f2200720bULL, 0x000fe20003f34000ULL, 0x000115527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x000000220f247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0104802427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000240f0f7221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL, 0x0000000f00297308ULL, 0x000e640000000800ULL,
0x000000290c0c7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000114a27f007947ULL, 0x000fea000b800000ULL, 0x00001f6c290f7589ULL, 0x0002a400000e0000ULL,
0x0000000f0b0b7220ULL, 0x084fe20000410000ULL, 0x0000000f0a0a7220ULL, 0x080fe20000410000ULL,
0x0000000f07077220ULL, 0x080fe20000410000ULL, 0x0000000f06067220ULL, 0x080fe20000410000ULL,
0x0000000f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000000f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000000f50507220ULL, 0x080fe20000410000ULL,
0x0000000f53537220ULL, 0x080fe20000410000ULL, 0x0000000f54547220ULL, 0x080fe20000410000ULL,
0x0000000f57577220ULL, 0x080fe20000410000ULL, 0x0000000f58587220ULL, 0x080fe20000410000ULL,
0x0000000f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000000f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000000f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000000f60607220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000113b27f007947ULL, 0x000fea000b800000ULL,
0x00001f6b290f7589ULL, 0x00046400000e0000ULL, 0x0000000f09097220ULL, 0x082fe20000410000ULL,
0x0000000f08087220ULL, 0x080fe20000410000ULL, 0x0000000f05057220ULL, 0x080fe20000410000ULL,
0x0000000f1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000000f4e4e7220ULL, 0x080fe20000410000ULL, 0x0000000f51517220ULL, 0x080fe20000410000ULL,
0x0000000f52527220ULL, 0x080fe20000410000ULL, 0x0000000f55557220ULL, 0x080fe20000410000ULL,
0x0000000f56567220ULL, 0x080fe20000410000ULL, 0x0000000f59597220ULL, 0x080fe20000410000ULL,
0x0000000f5a5a7220ULL, 0x080fe20000410000ULL, 0x0000000f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000000f5e5e7220ULL, 0x080fe20000410000ULL, 0x0000000f61617220ULL, 0x080fe20000410000ULL,
0x0000000f62627220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff28ff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff150816ULL, 0x000fc60000000015ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200160308ULL, 0x000e640000000800ULL, 0x0000001623230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000c230c7221ULL, 0x008fe20000010000ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff15ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000016ff17723eULL, 0x000fc800000000ffULL,
0x0000541017227816ULL, 0x000fe20000000017ULL, 0x000111f27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c22177589ULL, 0x0002e400000e0000ULL, 0x000112327f007947ULL, 0x000fea000b800000ULL,
0x00001f6b22187589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000106c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000810000207802ULL, 0x000fc40000000f00ULL, 0x00011dc000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x000000186c277810ULL, 0x002fe40007ffe0ffULL, 0x0000815000207802ULL, 0x000fc40000000f00ULL,
0x00011d7000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001b20783bULL, 0x002e620000004200ULL,
0x0000a80019247811ULL, 0x000fe200078e20ffULL, 0x0000068000017945ULL, 0x000fe20003800000ULL,
0x000000746c00720cULL, 0x000fe20003f46070ULL, 0x00000000673c783bULL, 0x000fe20000004200ULL,
0x000000106300720cULL, 0x000fc40003fc3070ULL, 0x000000746b00720cULL, 0x000fe20003f26070ULL,
0x000000002448783bULL, 0x000f220000000200ULL, 0x000000106300720cULL, 0x000fc60003f03070ULL,
0x000000001d2c783bULL, 0x000ee80000004200ULL, 0x000000006a44783bULL, 0x000ea20000004200ULL,
0x0000312020207816ULL, 0x002fe400000000ffULL, 0x0000312021217816ULL, 0x000fe400000000ffULL,
0x00000020ff26723eULL, 0x084fe400020006ffULL, 0x00000020ff28723eULL, 0x000fc400030006ffULL,
0x0000312022227816ULL, 0x000fe200000000ffULL, 0x000000174848b232ULL, 0x098fe20000000000ULL,
0x0000312023237816ULL, 0x000fe200000000ffULL, 0x000000174a4ab232ULL, 0x000fe20000000000ULL,
0x0000a8001c207811ULL, 0x000fe200078e20ffULL, 0x000000184949b232ULL, 0x080fe20000000000ULL,
0x00000021ff27723eULL, 0x080fe200020006ffULL, 0x000000184b4bb232ULL, 0x000fe20000000000ULL,
0x00000021ff29723eULL, 0x000fe400030006ffULL, 0x00000022ff30723eULL, 0x000fc400020006ffULL,
0x00000023ff31723eULL, 0x080fe400020006ffULL, 0x00000022ff34723eULL, 0x000fe200030006ffULL,
0x000000264824723cULL, 0x040f6200000018ffULL, 0x00000023ff35723eULL, 0x000fe400030006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x000031203c3c7816ULL, 0x000fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e687816ULL, 0x000fe200000000ffULL,
0x000000284828723cULL, 0x000f6200000018ffULL, 0x000031203f697816ULL, 0x000fc400000000ffULL,
0x0000003cff38723eULL, 0x080fe400020006ffULL, 0x0000003dff39723eULL, 0x080fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe200030006ffULL, 0x000000304830723cULL, 0x000f6200000018ffULL,
0x0000003dff3d723eULL, 0x000fe400030006ffULL, 0x00000068ff40723eULL, 0x000fe400020006ffULL,
0x00000069ff41723eULL, 0x000fc400020006ffULL, 0x00000068ff68723eULL, 0x000fe200030006ffULL,
0x000000344834723cULL, 0x040f6200000018ffULL, 0x00000069ff69723eULL, 0x000fe400030006ffULL,
0x000031202e2e7816ULL, 0x000fe400000000ffULL, 0x000031202f2f7816ULL, 0x000fe400000000ffULL,
0x0000312044447816ULL, 0x000fe200000000ffULL, 0x000000384838723cULL, 0x000f6200000018ffULL,
0x0000312045457816ULL, 0x000fc400000000ffULL, 0x0000312046467816ULL, 0x000fe400000000ffULL,
0x0000312047477816ULL, 0x000fc600000000ffULL, 0x0000003c483c723cULL, 0x000f6200000018ffULL,
0x000000172020b232ULL, 0x082fe40000000000ULL, 0x000000172222b232ULL, 0x000fe40000000000ULL,
0x000000182121b232ULL, 0x000fc60000000000ULL, 0x000000404840723cULL, 0x000f6200000018ffULL,
0x000000182323b232ULL, 0x000fce0000000000ULL, 0x000000684848723cULL, 0x000b6e00000018ffULL,
0x000031202c687816ULL, 0x020fe400000000ffULL, 0x000031202d697816ULL, 0x000fe400000000ffULL,
0x00000068ff2c723eULL, 0x000fc400020006ffULL, 0x00000069ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2024723cULL, 0x000b6e0000001824ULL, 0x00000068ff2c723eULL, 0x020fe400030006ffULL,
0x00000069ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2028723cULL, 0x000b6e0000001828ULL,
0x0000002eff2c723eULL, 0x020fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2030723cULL, 0x000b6e0000001830ULL, 0x0000002eff2c723eULL, 0x020fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fe400030006ffULL, 0x00000001742e7810ULL, 0x000fc80007ffe0ffULL,
0x0000002e6c00720cULL, 0x080fe20005746470ULL, 0x0000002c2034723cULL, 0x000b620000001834ULL,
0x0000002e6b00720cULL, 0x000fcc0004f26470ULL, 0x00000044ff2c723eULL, 0x020fe400020006ffULL,
0x00000045ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2038723cULL, 0x000b6e0000001838ULL,
0x00000044ff2c723eULL, 0x020fe400030006ffULL, 0x00000045ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c203c723cULL, 0x000b6e000000183cULL, 0x00000046ff2c723eULL, 0x020fe400020006ffULL,
0x00000047ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2040723cULL, 0x000b6e0000001840ULL,
0x00000046ff2c723eULL, 0x020fe400030006ffULL, 0x00000047ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2048723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240b0b7221ULL, 0x000fe20000010000ULL,
0x000000250a0a7221ULL, 0x000fe20000010000ULL, 0x0000002807077221ULL, 0x000fe20000010000ULL,
0x0000002906067221ULL, 0x000fe20000010000ULL, 0x000000301f1f7221ULL, 0x000fe20000010000ULL,
0x000000314c4c7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x0000003550507221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003954547221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x000fe20000010000ULL,
0x0000003d58587221ULL, 0x000fe20000010000ULL, 0x000000405b5b7221ULL, 0x000fe20000010000ULL,
0x000000415c5c7221ULL, 0x000fe20000010000ULL, 0x000000485f5f7221ULL, 0x020fe20000010000ULL,
0x0000004960607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000002609097221ULL, 0x000fe20000010000ULL, 0x0000002708087221ULL, 0x000fe20000010000ULL,
0x0000002a05057221ULL, 0x000fe20000010000ULL, 0x0000002b1e1e7221ULL, 0x000fe20000010000ULL,
0x000000324d4d7221ULL, 0x000fe20000010000ULL, 0x000000334e4e7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003752527221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b56567221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x000fe20000010000ULL, 0x0000003f5a5a7221ULL, 0x000fe20000010000ULL,
0x000000425d5d7221ULL, 0x000fe20000010000ULL, 0x000000435e5e7221ULL, 0x000fe20000010000ULL,
0x0000004a61617221ULL, 0x020fe20000010000ULL, 0x0000004b62627221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x020e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe2000001162eULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000000106300720cULL, 0x000fc40003fc3070ULL,
0x000000232e237207ULL, 0x040fe40002800000ULL, 0x000000032e247812ULL, 0x000fe400078ec0ffULL,
0x0000000123257810ULL, 0x000fe40007ffe0ffULL, 0x000000106300720cULL, 0x000fe40003f03070ULL,
0x00000040ff297803ULL, 0x000fe40000000000ULL, 0x000000ff24247207ULL, 0x000fc40006800000ULL,
0x0000000325237812ULL, 0x040fe400078ec0ffULL, 0x0000001025227211ULL, 0x000fe200078ff0ffULL,
0x000000ffff287224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8400ff267984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000026ff7812ULL, 0x002fe200078c4875ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8400ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe400078c4875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x010b8c00ff257984ULL, 0x000e620000000800ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000025ff7812ULL, 0x002fe200078c4828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe400078c4828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000122207810ULL, 0x000fe20007ffe0ffULL, 0x0000097000017945ULL, 0x000fe60003800000ULL,
0x000000652000720cULL, 0x000fda0003fc6070ULL, 0x000005100000e947ULL, 0x000fea0003800000ULL,
0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001004257824ULL, 0x000fe200078e00ffULL,
0x000000021a2e7810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2c7424ULL, 0x000fe400078e00ffULL,
0x010a00002b267984ULL, 0x000e620000004800ULL, 0x000000f0252d7812ULL, 0x000fe200078ec0ffULL,
0x0000000422257824ULL, 0x000fe200078e0223ULL, 0x000000052e317c10ULL, 0x000fe2000fffe0ffULL,
0x00000040002a7824ULL, 0x000fe400078e022bULL, 0x0000004025257824ULL, 0x000fc400078e00ffULL,
0x000000102b287824ULL, 0x000fe400078e00ffULL, 0x0000000131307824ULL, 0x040fe400078e0204ULL,
0x0000001031317824ULL, 0x000fca00078e00ffULL, 0xfffffff031307812ULL, 0x000fe200078ee230ULL,
0x010ac00026217984ULL, 0x0022a40000004800ULL, 0x0000002566267217ULL, 0x002fca0007800000ULL,
0x0000000126267824ULL, 0x000fe400078e0a25ULL, 0x000000012b257824ULL, 0x000fc600078e0204ULL,
0x0000000526267c17ULL, 0x000fe4000f800000ULL, 0xfffffff028277812ULL, 0x000fe400078ee225ULL,
0x8000000526257c10ULL, 0x000fe4000fffe0ffULL, 0x0000c000272f7811ULL, 0x000fe400078e20ffULL,
0x000000022a267810ULL, 0x000fe20007ffe0ffULL, 0x0000002112217224ULL, 0x004fc800078e022aULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002d20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x000000251a00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202f7faeULL, 0x0003e8000f101c4cULL,
0x010a08002b287984ULL, 0x000ea20000004800ULL, 0x0000c000302f7811ULL, 0x002fe400078e20ffULL,
0x000000042a207810ULL, 0x040fe40007ffe0ffULL, 0x000000062a2a7810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028277984ULL, 0x004e640000004800ULL, 0x0000002712277224ULL, 0x002fc800078e0226ULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000252e00720cULL, 0x000fe40003fc6070ULL,
0x000000041a2e7810ULL, 0x000fc80007ffe0ffULL, 0x000000052e317c10ULL, 0x000fca000fffe0ffULL,
0x0000000131307824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c4cULL, 0x0000001031317824ULL, 0x000fc600078e00ffULL,
0x010a10002b287984ULL, 0x000ea40000004800ULL, 0xfffffff031307812ULL, 0x000fc800078ee230ULL,
0x0000c000302f7811ULL, 0x002fe200078e20ffULL, 0x010ac00028217984ULL, 0x004e640000004800ULL,
0x0000002112217224ULL, 0x002fc800078e0220ULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002d20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000252e00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202f7faeULL, 0x0003e8000f101c4cULL, 0x010a18002b287984ULL, 0x000ea80000004800ULL,
0x010ac00028277984ULL, 0x004ea40000004800ULL, 0x0000002712277224ULL, 0x004fe200078e022aULL,
0x000000061a2a7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002d26267210ULL, 0x000fe40007fde0ffULL, 0x000000052a2d7c10ULL, 0x000fc6000fffe0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000252a00720cULL, 0x000fe20003fc6070ULL,
0x000000012d2c7824ULL, 0x040fe400078e0204ULL, 0x000000102d2d7824ULL, 0x000fca00078e00ffULL,
0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL, 0x0000c0002c217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e2000f101c4cULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000001004267824ULL, 0x000fe200078e00ffULL,
0x000000022b337810ULL, 0x000fe20007ffe0ffULL, 0x010a00002b257984ULL, 0x000e620000004800ULL,
0x0000004000287824ULL, 0x000fe400078e022bULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x00000001332a7824ULL, 0x000fc400078e0204ULL, 0x0000001033337824ULL, 0x000fca00078e00ffULL,
0xfffffff0332a7812ULL, 0x000fe400078ee22aULL, 0x000000042b337810ULL, 0x000fe20007ffe0ffULL,
0x010ac00025257984ULL, 0x002e640000004800ULL, 0x0000002512207224ULL, 0x002fc800078e0228ULL,
0x00005e0020207625ULL, 0x000fca00078e002dULL, 0x0000002f20267210ULL, 0x000fe20007fde0ffULL,
0x000000012b207824ULL, 0x000fc800078e0204ULL, 0x000000ffff277224ULL, 0x000fe400030e0621ULL,
0x000000102b217824ULL, 0x000fca00078e00ffULL, 0xfffffff021207812ULL, 0x000fc800078ee220ULL,
0x0000c00020317811ULL, 0x000fe400078e20ffULL, 0x0000000228207810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c4cULL,
0x010a08002b257984ULL, 0x000ea20000004800ULL, 0x0000c0002a317811ULL, 0x002fe200078e20ffULL,
0x00000001332a7824ULL, 0x040fe200078e0204ULL, 0x0000000428267810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fca00078e00ffULL, 0xfffffff0332a7812ULL, 0x000fe200078ee22aULL,
0x010ac00025257984ULL, 0x004e640000004800ULL, 0x0000002512207224ULL, 0x002fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fca00078e002dULL, 0x0000002f20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fca00030e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000b901c4cULL, 0x010a10002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fe400078e20ffULL, 0x0000000628207810ULL, 0x000fe20007ffe0ffULL,
0x010ac00025257984ULL, 0x004e640000004800ULL, 0x0000002512267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a18002b257984ULL, 0x000ea80000004800ULL,
0x010ac00025257984ULL, 0x004ea40000004800ULL, 0x0000002512207224ULL, 0x004fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fe200078e002dULL, 0x000000062b2d7810ULL, 0x000fc80007ffe0ffULL,
0x0000002f20207210ULL, 0x000fe20007fde0ffULL, 0x000000012d287824ULL, 0x040fe400078e0204ULL,
0x000000102d2d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x000fc600030e0621ULL,
0xfffffff02d287812ULL, 0x000fc800078ee228ULL, 0x0000c00028277811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020277faeULL, 0x0003e4000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8c00ff257984ULL, 0x000e620000000800ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000025ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000226300720cULL, 0x000fe20003fc4070ULL,
0x00000004ff257424ULL, 0x000fe200078e00ffULL, 0x00010a0013277811ULL, 0x000fe400078e10ffULL,
0x000000ff24207207ULL, 0x000fc40003000000ULL, 0x000000ff24247207ULL, 0x000fc60007000000ULL,
0x0000000123237824ULL, 0x000fc800078e0220ULL, 0x0000004023207824ULL, 0x040fe200078e00ffULL,
0x0000002223227211ULL, 0x000fc800078ff0ffULL, 0x000000c020217812ULL, 0x000fe400078ec0ffULL,
0x0000000a24207c10ULL, 0x000fc6000fffe0ffULL, 0x0000010022217824ULL, 0x000fca00078e0221ULL,
0x0000002021217810ULL, 0x000fca0007ffe0ffULL, 0x0000000113237824ULL, 0x100fe400078e0221ULL,
0x0000680020207a24ULL, 0x000fc600078e0221ULL, 0x000000662300720cULL, 0x000fe20003fc6070ULL,
0x0000000113207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020277faeULL, 0x0003e4000f12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff757224ULL, 0x002fe200078e0021ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000016ff17723eULL, 0x000fc800000000ffULL,
0x0000541017227816ULL, 0x000fe20000000017ULL, 0x0000f5d27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c22177589ULL, 0x0002a400000e0000ULL, 0x0000f6127f007947ULL, 0x000fea000b800000ULL,
0x00001f6b22187589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000106c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00009de000207802ULL, 0x000fc40000000f00ULL, 0x000100e000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x000000186c277810ULL, 0x002fe40007ffe0ffULL, 0x00009e3000207802ULL, 0x000fc40000000f00ULL,
0x0001009000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006e20783bULL, 0x00ae620000004200ULL,
0x0000a8006f247811ULL, 0x000fe200078e20ffULL, 0x0000062000017945ULL, 0x000fe20003800000ULL,
0x000000ff2900720cULL, 0x000fe20003fc5270ULL, 0x000000006d3c783bULL, 0x000fe80000004200ULL,
0x000000002448783bULL, 0x000ee80000000200ULL, 0x00000000712c783bULL, 0x000f280000004200ULL,
0x000000007244783bULL, 0x000ea20000004200ULL, 0x0000312020207816ULL, 0x002fc400000000ffULL,
0x0000312021217816ULL, 0x000fe400000000ffULL, 0x00000020ff26723eULL, 0x084fe400020006ffULL,
0x00000020ff28723eULL, 0x000fe400030006ffULL, 0x0000312022227816ULL, 0x000fe200000000ffULL,
0x000000174848b232ULL, 0x088fe20000000000ULL, 0x0000312023237816ULL, 0x000fe200000000ffULL,
0x000000174a4ab232ULL, 0x000fe20000000000ULL, 0x0000a80070207811ULL, 0x000fe200078e20ffULL,
0x000000184949b232ULL, 0x080fe20000000000ULL, 0x00000021ff27723eULL, 0x080fe200020006ffULL,
0x000000184b4bb232ULL, 0x000fe20000000000ULL, 0x00000021ff29723eULL, 0x000fc400030006ffULL,
0x00000022ff30723eULL, 0x080fe400020006ffULL, 0x00000023ff31723eULL, 0x080fe400020006ffULL,
0x00000022ff34723eULL, 0x000fe200030006ffULL, 0x000000264824723cULL, 0x000f6200000018ffULL,
0x00000023ff35723eULL, 0x000fe400030006ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fc400000000ffULL,
0x000031203e687816ULL, 0x000fe200000000ffULL, 0x000000284828723cULL, 0x040f6200000018ffULL,
0x000031203f697816ULL, 0x000fe400000000ffULL, 0x0000003cff38723eULL, 0x080fe400020006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe200030006ffULL,
0x000000304830723cULL, 0x000f6200000018ffULL, 0x0000003dff3d723eULL, 0x000fc400030006ffULL,
0x00000068ff40723eULL, 0x080fe400020006ffULL, 0x00000069ff41723eULL, 0x080fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200030006ffULL, 0x000000344834723cULL, 0x000f6200000018ffULL,
0x00000069ff69723eULL, 0x000fe400030006ffULL, 0x000031202e2e7816ULL, 0x010fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fc400000000ffULL, 0x0000312044447816ULL, 0x000fe200000000ffULL,
0x000000384838723cULL, 0x000f6200000018ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fc600000000ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x000000172020b232ULL, 0x082fe40000000000ULL,
0x000000172222b232ULL, 0x000fe40000000000ULL, 0x000000182121b232ULL, 0x000fc60000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x000000182323b232ULL, 0x000fce0000000000ULL,
0x000000684848723cULL, 0x000b6e00000018ffULL, 0x000031202c687816ULL, 0x020fe400000000ffULL,
0x000031202d697816ULL, 0x000fe400000000ffULL, 0x00000068ff2c723eULL, 0x000fc400020006ffULL,
0x00000069ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2024723cULL, 0x000b6e0000001824ULL,
0x00000068ff2c723eULL, 0x020fe400030006ffULL, 0x00000069ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2028723cULL, 0x000b6e0000001828ULL, 0x0000002eff2c723eULL, 0x020fe400020006ffULL,
0x0000002fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2030723cULL, 0x000b6e0000001830ULL,
0x0000002eff2c723eULL, 0x020fe400030006ffULL, 0x0000002fff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2034723cULL, 0x000b6e0000001834ULL, 0x00000044ff2c723eULL, 0x020fe400020006ffULL,
0x00000045ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2038723cULL, 0x000b6e0000001838ULL,
0x00000044ff2c723eULL, 0x020fe400030006ffULL, 0x00000045ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c203c723cULL, 0x000b6e000000183cULL, 0x00000046ff2c723eULL, 0x020fe400020006ffULL,
0x00000047ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2040723cULL, 0x000b6e0000001840ULL,
0x00000046ff2c723eULL, 0x020fe400030006ffULL, 0x00000047ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2048723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240b0b7221ULL, 0x000fe20000010000ULL,
0x000000250a0a7221ULL, 0x000fe20000010000ULL, 0x0000002807077221ULL, 0x000fe20000010000ULL,
0x0000002906067221ULL, 0x000fe20000010000ULL, 0x000000301f1f7221ULL, 0x000fe20000010000ULL,
0x000000314c4c7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x0000003550507221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003954547221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x000fe20000010000ULL,
0x0000003d58587221ULL, 0x000fe20000010000ULL, 0x000000405b5b7221ULL, 0x000fe20000010000ULL,
0x000000415c5c7221ULL, 0x000fe20000010000ULL, 0x000000485f5f7221ULL, 0x020fe20000010000ULL,
0x0000004960607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000002609097221ULL, 0x000fe20000010000ULL, 0x0000002708087221ULL, 0x000fe20000010000ULL,
0x0000002a05057221ULL, 0x000fe20000010000ULL, 0x0000002b1e1e7221ULL, 0x000fe20000010000ULL,
0x000000324d4d7221ULL, 0x000fe20000010000ULL, 0x000000334e4e7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003752527221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b56567221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x000fe20000010000ULL, 0x0000003f5a5a7221ULL, 0x000fe20000010000ULL,
0x000000425d5d7221ULL, 0x000fe20000010000ULL, 0x000000435e5e7221ULL, 0x000fe20000010000ULL,
0x0000004a61617221ULL, 0x020fe20000010000ULL, 0x0000004b62627221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000174747810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000737400720cULL, 0x000fe20003f06070ULL,
0x010b8800ff227f8cULL, 0x020e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffbd1000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008010217811ULL, 0x000fe200078e40ffULL, 0x010b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000662100720cULL, 0x000fda0003f06070ULL, 0x000086f000000947ULL, 0x000fea0003800000ULL,
0x000000ffff747224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x000fe20000011674ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000374227812ULL, 0x042fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000002174217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000221257810ULL, 0x000fc80007ffe0ffULL,
0x0000000325217812ULL, 0x040fe400078ec0ffULL, 0x0000001025207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804875ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000652400720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x000000051a297c10ULL, 0x000fe2000fffe0ffULL,
0x0000000420237824ULL, 0x000fe200078e0221ULL, 0x00000020002a7811ULL, 0x000fe200078e30ffULL,
0x00000100ff2c7424ULL, 0x000fe200078e00ffULL, 0x000000021a2e7810ULL, 0x000fe20007ffe0ffULL,
0x010a000029257984ULL, 0x000e620000004800ULL, 0x0000002023237811ULL, 0x000fe200078e30ffULL,
0x0000000129267824ULL, 0x040fe200078e022aULL, 0x000000052e2f7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000129277824ULL, 0x040fe200078e0204ULL, 0x0000002366247217ULL, 0x000fe20007800000ULL,
0x0000001029287824ULL, 0x000fc400078e00ffULL, 0x000000012f307824ULL, 0x000fe400078e0204ULL,
0x0000000124247824ULL, 0x000fe400078e0a23ULL, 0x0000001004237824ULL, 0x000fc600078e00ffULL,
0x0000000524247c17ULL, 0x000fe4000f800000ULL, 0x000000f0232b7812ULL, 0x000fe400078ec0ffULL,
0x8000000524237c10ULL, 0x000fc8000fffe0ffULL, 0x000000231a00720cULL, 0x000fe20003f06070ULL,
0x010ac00025257984ULL, 0x002e640000004800ULL, 0x0000002512267224ULL, 0x002fc800078e0226ULL,
0x00005e0026247625ULL, 0x000fca00078e002cULL, 0x0000002b24267210ULL, 0x000fe40007f3e0ffULL,
0xfffffff028247812ULL, 0x000fc600078ee227ULL, 0x000000ffff277224ULL, 0x000fe200008e0625ULL,
0x0000e000242d7811ULL, 0x000fe200078e20ffULL, 0x000000012f247824ULL, 0x040fe400078e022aULL,
0x000000102f2f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262d7faeULL, 0x0003e2000c101c4cULL, 0x000000232e00720cULL, 0x000fe40003f06070ULL,
0xfffffff02f307812ULL, 0x000fe200078ee230ULL, 0x010a080029287984ULL, 0x000ea20000004800ULL,
0x000000041a2e7810ULL, 0x000fc80007ffe0ffULL, 0x000000052e2f7c10ULL, 0x000fe4000fffe0ffULL,
0x0000e000302d7811ULL, 0x002fc600078e20ffULL, 0x000000012f307824ULL, 0x000fe200078e0204ULL,
0x010ac00028257984ULL, 0x004e640000004800ULL, 0x0000002512257224ULL, 0x002fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002cULL, 0x0000002b24267210ULL, 0x000fe20007f3e0ffULL,
0x000000012f247824ULL, 0x040fe400078e022aULL, 0x000000102f2f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc600008e0625ULL, 0xfffffff02f307812ULL, 0x000fe400078ee230ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e2000c101c4cULL,
0x000000232e00720cULL, 0x000fe40003f06070ULL, 0x000000061a2e7810ULL, 0x000fe20007ffe0ffULL,
0x010a100029287984ULL, 0x000ea60000004800ULL, 0x000000052e2f7c10ULL, 0x000fe4000fffe0ffULL,
0x0000e000302d7811ULL, 0x002fc600078e20ffULL, 0x000000012f2a7824ULL, 0x000fe200078e022aULL,
0x010ac00028257984ULL, 0x004e640000004800ULL, 0x0000002512257224ULL, 0x002fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002cULL, 0x0000002b24247210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff257224ULL, 0x000fca00008e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242d7faeULL, 0x0003e2000c101c4cULL, 0x000000232e00720cULL, 0x000fc60003f06070ULL,
0x010a180029287984ULL, 0x000ea80000004800ULL, 0x010ac00028277984ULL, 0x004ea40000004800ULL,
0x0000002712277224ULL, 0x004fe400078e022aULL, 0x000000012f2a7824ULL, 0x000fe400078e0204ULL,
0x00005e0027267625ULL, 0x000fc800078e002cULL, 0x000000102f2f7824ULL, 0x000fe200078e00ffULL,
0x0000002b26247210ULL, 0x002fc80007f3e0ffULL, 0xfffffff02f2a7812ULL, 0x000fe200078ee22aULL,
0x000000ffff257224ULL, 0x000fc600008e0627ULL, 0x0000e0002a237811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e2000c101c4cULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004257824ULL, 0x000fe200078e00ffULL, 0x00000020002a7811ULL, 0x000fe200078e30ffULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000022b297810ULL, 0x000fe20007ffe0ffULL,
0x010a00002b237984ULL, 0x000e620000004800ULL, 0x000000f0252f7812ULL, 0x000fe200078ec0ffULL,
0x000000012b247824ULL, 0x040fe400078e022aULL, 0x000000012b277824ULL, 0x000fc400078e0204ULL,
0x000000102b287824ULL, 0x000fe400078e00ffULL, 0x00000001292c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023237984ULL, 0x002e640000004800ULL, 0x0000002312247224ULL, 0x002fe200078e0224ULL,
0xfffffff028237812ULL, 0x000fc600078ee227ULL, 0x00005e0024247625ULL, 0x000fe200078e002dULL,
0x0000e00023317811ULL, 0x000fc800078e20ffULL, 0x0000002f24267210ULL, 0x000fe20007f1e0ffULL,
0x000000012a247824ULL, 0x000fe400078e0229ULL, 0x0000001029297824ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc600000e0625ULL, 0xfffffff0292c7812ULL, 0x000fe400078ee22cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c4cULL,
0x010a08002b237984ULL, 0x000ea20000004800ULL, 0x0000e0002c317811ULL, 0x002fe400078e20ffULL,
0x000000042b277810ULL, 0x000fca0007ffe0ffULL, 0x00000001272c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002312247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24287210ULL, 0x000fe20007f1e0ffULL,
0x000000012a247824ULL, 0x000fe400078e0227ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x000000ffff297224ULL, 0x000fc600000e0625ULL, 0xfffffff0272c7812ULL, 0x000fe400078ee22cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e8000b901c4cULL,
0x010a10002b237984ULL, 0x000ea20000004800ULL, 0x0000e0002c297811ULL, 0x002fe400078e20ffULL,
0x000000062b317810ULL, 0x000fca0007ffe0ffULL, 0x0000000131287824ULL, 0x000fe200078e0204ULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002312247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24267210ULL, 0x000fe20007f1e0ffULL,
0x000000012a247824ULL, 0x000fe400078e0231ULL, 0x0000001031317824ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc600000e0625ULL, 0xfffffff031287812ULL, 0x000fe400078ee228ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c4cULL,
0x010a18002b237984ULL, 0x000ea20000004800ULL, 0x0000e00028277811ULL, 0x002fc600078e20ffULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002312247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000206300720cULL, 0x000fe20003f04070ULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000032200780cULL, 0x000fda0003f25270ULL, 0x0000010000008947ULL, 0x000fea0000800000ULL,
0x000000031300780cULL, 0x000fe40003f04070ULL, 0x0000000111117810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000e620000002700ULL,
0x000000641100720cULL, 0x040fe20003f06070ULL, 0x00000004ff257424ULL, 0x000fe400078e00ffULL,
0x0000000424237824ULL, 0x002fe200078e0213ULL, 0x0000640011247a10ULL, 0x000fc60007ffe0ffULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac013237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000206300720cULL, 0x000fe40003f04070ULL,
0x0000000122227810ULL, 0x000fc80007ffe0ffULL, 0x0000000322237812ULL, 0x002fc800078ec0ffULL,
0x000000ff23237207ULL, 0x000fc60004000000ULL, 0x00000002ff228819ULL, 0x000fca0000011622ULL,
0x0000000121217824ULL, 0x000fc800078e0222ULL, 0x0000004021227824ULL, 0x040fe200078e00ffULL,
0x0000002021207211ULL, 0x000fc800078ff0ffULL, 0x000000c022217812ULL, 0x000fca00078ec0ffULL,
0x0000010020227824ULL, 0x000fe200078e0221ULL, 0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL,
0x00010a0013237811ULL, 0x040fe200078e10ffULL, 0x0000000113217824ULL, 0x100fe400078e0222ULL,
0x0000680020207a24ULL, 0x000fc600078e0222ULL, 0x000000662100720cULL, 0x000fe20003f06070ULL,
0x00000004ff217424ULL, 0x000fe400078e00ffULL, 0x0000000113207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fcc00078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7400720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff757224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b1800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff247224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b1c05ff157984ULL, 0x000e640008000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220227210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff157819ULL, 0x000fc80000011423ULL, 0x0000002215157211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0623ULL, 0x0000000215157819ULL, 0x000fc80000001222ULL,
0x000000150000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010b1c05ff157984ULL, 0x000e640008000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001004157824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011604ULL, 0x0000007015157812ULL, 0x000fe400078ec0ffULL,
0x0000000c20207812ULL, 0x000fca00078ec0ffULL, 0x0000000115277824ULL, 0x000fca00078e0220ULL,
0x0101000027227984ULL, 0x000e680000000800ULL, 0x0103000027237984ULL, 0x0004e20000000800ULL,
0x0000000f2200720bULL, 0x002fe20003f1d000ULL, 0x0000d4d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x0000ffff15287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff157424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e000fULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000020300780cULL, 0x000fe40003f05270ULL, 0x0000000f2200720bULL, 0x000fe20003f34000ULL,
0x0000d4927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x000000220f247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0105002427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000240f0f7221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f00297308ULL, 0x000e640000000800ULL, 0x000000290c0c7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000d3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c290f7589ULL, 0x0002a400000e0000ULL, 0x0000000f0b0b7220ULL, 0x084fe20000410000ULL,
0x0000000f0a0a7220ULL, 0x080fe20000410000ULL, 0x0000000f07077220ULL, 0x080fe20000410000ULL,
0x0000000f06067220ULL, 0x080fe20000410000ULL, 0x0000000f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000000f4f4f7220ULL, 0x080fe20000410000ULL,
0x0000000f50507220ULL, 0x080fe20000410000ULL, 0x0000000f53537220ULL, 0x080fe20000410000ULL,
0x0000000f54547220ULL, 0x080fe20000410000ULL, 0x0000000f57577220ULL, 0x080fe20000410000ULL,
0x0000000f58587220ULL, 0x080fe20000410000ULL, 0x0000000f5b5b7220ULL, 0x080fe20000410000ULL,
0x0000000f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000000f5f5f7220ULL, 0x080fe20000410000ULL,
0x0000000f60607220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000d2f27f007947ULL, 0x000fea000b800000ULL, 0x00001f6b290f7589ULL, 0x00046400000e0000ULL,
0x0000000f09097220ULL, 0x082fe20000410000ULL, 0x0000000f08087220ULL, 0x080fe20000410000ULL,
0x0000000f05057220ULL, 0x080fe20000410000ULL, 0x0000000f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000000f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000000f51517220ULL, 0x080fe20000410000ULL, 0x0000000f52527220ULL, 0x080fe20000410000ULL,
0x0000000f55557220ULL, 0x080fe20000410000ULL, 0x0000000f56567220ULL, 0x080fe20000410000ULL,
0x0000000f59597220ULL, 0x080fe20000410000ULL, 0x0000000f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000000f5d5d7220ULL, 0x080fe20000410000ULL, 0x0000000f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000000f61617220ULL, 0x080fe20000410000ULL, 0x0000000f62627220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002422220221ULL, 0x000fe20000010000ULL, 0x00007610ff150816ULL, 0x000fc60000000015ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x0000002200160308ULL, 0x000e640000000800ULL,
0x0000001623230220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000c230c7221ULL, 0x008fe20000010000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff15ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000016ff17723eULL, 0x000fc800000000ffULL, 0x0000541017227816ULL, 0x000fe20000000017ULL,
0x0000d1327f007947ULL, 0x000fea000b800000ULL, 0x00001f6c22177589ULL, 0x0002e400000e0000ULL,
0x0000d1727f007947ULL, 0x000fea000b800000ULL, 0x00001f6b22187589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000106c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000c49000207802ULL, 0x000fc40000000f00ULL,
0x0000da3000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x000000186c277810ULL, 0x002fe40007ffe0ffULL,
0x0000c4e000207802ULL, 0x000fc40000000f00ULL, 0x0000d9e000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001b20783bULL, 0x002e620000004200ULL, 0x0000b00019247811ULL, 0x000fe200078e20ffULL,
0x0000068000017945ULL, 0x000fe20003800000ULL, 0x000000746c00720cULL, 0x000fe20003f46070ULL,
0x00000000673c783bULL, 0x000fe20000004200ULL, 0x000000106300720cULL, 0x000fc40003fc3070ULL,
0x000000746b00720cULL, 0x000fe20003f26070ULL, 0x000000002448783bULL, 0x000f220000000200ULL,
0x000000106300720cULL, 0x000fc60003f03070ULL, 0x000000001d2c783bULL, 0x000ee80000004200ULL,
0x000000006a44783bULL, 0x000ea20000004200ULL, 0x0000312020207816ULL, 0x002fe400000000ffULL,
0x0000312021217816ULL, 0x000fe400000000ffULL, 0x00000020ff26723eULL, 0x084fe400020006ffULL,
0x00000020ff28723eULL, 0x000fc400030006ffULL, 0x0000312022227816ULL, 0x000fe200000000ffULL,
0x000000174848b232ULL, 0x098fe20000000000ULL, 0x0000312023237816ULL, 0x000fe200000000ffULL,
0x000000174a4ab232ULL, 0x000fe20000000000ULL, 0x0000b0001c207811ULL, 0x000fe200078e20ffULL,
0x000000184949b232ULL, 0x080fe20000000000ULL, 0x00000021ff27723eULL, 0x080fe200020006ffULL,
0x000000184b4bb232ULL, 0x000fe20000000000ULL, 0x00000021ff29723eULL, 0x000fe400030006ffULL,
0x00000022ff30723eULL, 0x000fc400020006ffULL, 0x00000023ff31723eULL, 0x080fe400020006ffULL,
0x00000022ff34723eULL, 0x000fe200030006ffULL, 0x000000264824723cULL, 0x040f6200000018ffULL,
0x00000023ff35723eULL, 0x000fe400030006ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e687816ULL, 0x000fe200000000ffULL, 0x000000284828723cULL, 0x000f6200000018ffULL,
0x000031203f697816ULL, 0x000fc400000000ffULL, 0x0000003cff38723eULL, 0x080fe400020006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe200030006ffULL,
0x000000304830723cULL, 0x000f6200000018ffULL, 0x0000003dff3d723eULL, 0x000fe400030006ffULL,
0x00000068ff40723eULL, 0x000fe400020006ffULL, 0x00000069ff41723eULL, 0x000fc400020006ffULL,
0x00000068ff68723eULL, 0x000fe200030006ffULL, 0x000000344834723cULL, 0x040f6200000018ffULL,
0x00000069ff69723eULL, 0x000fe400030006ffULL, 0x000031202e2e7816ULL, 0x000fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fe400000000ffULL, 0x0000312044447816ULL, 0x000fe200000000ffULL,
0x000000384838723cULL, 0x000f6200000018ffULL, 0x0000312045457816ULL, 0x000fc400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fc600000000ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x000000172020b232ULL, 0x082fe40000000000ULL,
0x000000172222b232ULL, 0x000fe40000000000ULL, 0x000000182121b232ULL, 0x000fc60000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x000000182323b232ULL, 0x000fce0000000000ULL,
0x000000684848723cULL, 0x000b6e00000018ffULL, 0x000031202c687816ULL, 0x020fe400000000ffULL,
0x000031202d697816ULL, 0x000fe400000000ffULL, 0x00000068ff2c723eULL, 0x000fc400020006ffULL,
0x00000069ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2024723cULL, 0x000b6e0000001824ULL,
0x00000068ff2c723eULL, 0x020fe400030006ffULL, 0x00000069ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2028723cULL, 0x000b6e0000001828ULL, 0x0000002eff2c723eULL, 0x020fe400020006ffULL,
0x0000002fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2030723cULL, 0x000b6e0000001830ULL,
0x0000002eff2c723eULL, 0x020fe400030006ffULL, 0x0000002fff2d723eULL, 0x000fe400030006ffULL,
0x00000001742e7810ULL, 0x000fc80007ffe0ffULL, 0x0000002e6c00720cULL, 0x080fe20005746470ULL,
0x0000002c2034723cULL, 0x000b620000001834ULL, 0x0000002e6b00720cULL, 0x000fcc0004f26470ULL,
0x00000044ff2c723eULL, 0x020fe400020006ffULL, 0x00000045ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2038723cULL, 0x000b6e0000001838ULL, 0x00000044ff2c723eULL, 0x020fe400030006ffULL,
0x00000045ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c203c723cULL, 0x000b6e000000183cULL,
0x00000046ff2c723eULL, 0x020fe400020006ffULL, 0x00000047ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2040723cULL, 0x000b6e0000001840ULL, 0x00000046ff2c723eULL, 0x020fe400030006ffULL,
0x00000047ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000240b0b7221ULL, 0x000fe20000010000ULL, 0x000000250a0a7221ULL, 0x000fe20000010000ULL,
0x0000002807077221ULL, 0x000fe20000010000ULL, 0x0000002906067221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314c4c7221ULL, 0x000fe20000010000ULL,
0x000000344f4f7221ULL, 0x000fe20000010000ULL, 0x0000003550507221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003954547221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x000fe20000010000ULL, 0x0000003d58587221ULL, 0x000fe20000010000ULL,
0x000000405b5b7221ULL, 0x000fe20000010000ULL, 0x000000415c5c7221ULL, 0x000fe20000010000ULL,
0x000000485f5f7221ULL, 0x020fe20000010000ULL, 0x0000004960607221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000002609097221ULL, 0x000fe20000010000ULL,
0x0000002708087221ULL, 0x000fe20000010000ULL, 0x0000002a05057221ULL, 0x000fe20000010000ULL,
0x0000002b1e1e7221ULL, 0x000fe20000010000ULL, 0x000000324d4d7221ULL, 0x000fe20000010000ULL,
0x000000334e4e7221ULL, 0x000fe20000010000ULL, 0x0000003651517221ULL, 0x000fe20000010000ULL,
0x0000003752527221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b56567221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x000fe20000010000ULL,
0x0000003f5a5a7221ULL, 0x000fe20000010000ULL, 0x000000425d5d7221ULL, 0x000fe20000010000ULL,
0x000000435e5e7221ULL, 0x000fe20000010000ULL, 0x0000004a61617221ULL, 0x020fe20000010000ULL,
0x0000004b62627221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x020e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe2000001162eULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000000106300720cULL, 0x000fc40003fc3070ULL, 0x000000232e237207ULL, 0x040fe40002800000ULL,
0x000000032e247812ULL, 0x000fe400078ec0ffULL, 0x0000000223257810ULL, 0x000fe40007ffe0ffULL,
0x000000106300720cULL, 0x000fe40003f03070ULL, 0x00000040ff297803ULL, 0x000fe40000000000ULL,
0x000000ff24247207ULL, 0x000fc40006800000ULL, 0x0000000325237812ULL, 0x040fe400078ec0ffULL,
0x0000001025227211ULL, 0x000fe200078ff0ffULL, 0x000000ffff287224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4875ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x010b8c00ff257984ULL, 0x000e620000000800ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000025ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000122207810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000652000720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004257824ULL, 0x000fe200078e00ffULL, 0x000000021a2e7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2c7424ULL, 0x000fe400078e00ffULL, 0x010a00002b267984ULL, 0x000e620000004800ULL,
0x000000f0252d7812ULL, 0x000fe200078ec0ffULL, 0x0000000422257824ULL, 0x000fe200078e0223ULL,
0x000000052e317c10ULL, 0x000fe2000fffe0ffULL, 0x00000040002a7824ULL, 0x000fe400078e022bULL,
0x0000004025257824ULL, 0x000fc400078e00ffULL, 0x000000102b287824ULL, 0x000fe400078e00ffULL,
0x0000000131307824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff031307812ULL, 0x000fe200078ee230ULL, 0x010ac00026217984ULL, 0x0022a40000004800ULL,
0x0000002566267217ULL, 0x002fca0007800000ULL, 0x0000000126267824ULL, 0x000fe400078e0a25ULL,
0x000000012b257824ULL, 0x000fc600078e0204ULL, 0x0000000526267c17ULL, 0x000fe4000f800000ULL,
0xfffffff028277812ULL, 0x000fe400078ee225ULL, 0x8000000526257c10ULL, 0x000fe4000fffe0ffULL,
0x0000c000272f7811ULL, 0x000fe400078e20ffULL, 0x000000022a267810ULL, 0x000fe20007ffe0ffULL,
0x0000002112217224ULL, 0x004fc800078e022aULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002d20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000251a00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202f7faeULL, 0x0003e8000f101c4cULL, 0x010a08002b287984ULL, 0x000ea20000004800ULL,
0x0000c000302f7811ULL, 0x002fe400078e20ffULL, 0x000000042a207810ULL, 0x040fe40007ffe0ffULL,
0x000000062a2a7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00028277984ULL, 0x004e640000004800ULL,
0x0000002712277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002d26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000252e00720cULL, 0x000fe40003fc6070ULL, 0x000000041a2e7810ULL, 0x000fc80007ffe0ffULL,
0x000000052e317c10ULL, 0x000fca000fffe0ffULL, 0x0000000131307824ULL, 0x040fe400078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000f101c4cULL,
0x0000001031317824ULL, 0x000fc600078e00ffULL, 0x010a10002b287984ULL, 0x000ea40000004800ULL,
0xfffffff031307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x002fe200078e20ffULL,
0x010ac00028217984ULL, 0x004e640000004800ULL, 0x0000002112217224ULL, 0x002fc800078e0220ULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002d20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x000000252e00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202f7faeULL, 0x0003e8000f101c4cULL,
0x010a18002b287984ULL, 0x000ea80000004800ULL, 0x010ac00028277984ULL, 0x004ea40000004800ULL,
0x0000002712277224ULL, 0x004fe200078e022aULL, 0x000000061a2a7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002d26267210ULL, 0x000fe40007fde0ffULL,
0x000000052a2d7c10ULL, 0x000fc6000fffe0ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000252a00720cULL, 0x000fe20003fc6070ULL, 0x000000012d2c7824ULL, 0x040fe400078e0204ULL,
0x000000102d2d7824ULL, 0x000fca00078e00ffULL, 0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL,
0x0000c0002c217811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026217faeULL, 0x0003e2000f101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000022b337810ULL, 0x000fe20007ffe0ffULL,
0x010a00002b257984ULL, 0x000e620000004800ULL, 0x0000004000287824ULL, 0x000fe400078e022bULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x00000001332a7824ULL, 0x000fc400078e0204ULL,
0x0000001033337824ULL, 0x000fca00078e00ffULL, 0xfffffff0332a7812ULL, 0x000fe400078ee22aULL,
0x000000042b337810ULL, 0x000fe20007ffe0ffULL, 0x010ac00025257984ULL, 0x002e640000004800ULL,
0x0000002512207224ULL, 0x002fc800078e0228ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20267210ULL, 0x000fe20007fde0ffULL, 0x000000012b207824ULL, 0x000fc800078e0204ULL,
0x000000ffff277224ULL, 0x000fe400030e0621ULL, 0x000000102b217824ULL, 0x000fca00078e00ffULL,
0xfffffff021207812ULL, 0x000fc800078ee220ULL, 0x0000c00020317811ULL, 0x000fe400078e20ffULL,
0x0000000228207810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a08002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fe200078e20ffULL, 0x00000001332a7824ULL, 0x040fe200078e0204ULL,
0x0000000428267810ULL, 0x000fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fca00078e00ffULL,
0xfffffff0332a7812ULL, 0x000fe200078ee22aULL, 0x010ac00025257984ULL, 0x004e640000004800ULL,
0x0000002512207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fca00030e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020317faeULL, 0x0003e8000b901c4cULL,
0x010a10002b257984ULL, 0x000ea20000004800ULL, 0x0000c0002a317811ULL, 0x002fe400078e20ffULL,
0x0000000628207810ULL, 0x000fe20007ffe0ffULL, 0x010ac00025257984ULL, 0x004e640000004800ULL,
0x0000002512267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c4cULL,
0x010a18002b257984ULL, 0x000ea80000004800ULL, 0x010ac00025257984ULL, 0x004ea40000004800ULL,
0x0000002512207224ULL, 0x004fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fe200078e002dULL,
0x000000062b2d7810ULL, 0x000fc80007ffe0ffULL, 0x0000002f20207210ULL, 0x000fe20007fde0ffULL,
0x000000012d287824ULL, 0x040fe400078e0204ULL, 0x000000102d2d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fc600030e0621ULL, 0xfffffff02d287812ULL, 0x000fc800078ee228ULL,
0x0000c00028277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e4000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8c00ff257984ULL, 0x000e620000000800ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000025ff7812ULL, 0x002fe200078c4828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe400078c4828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000226300720cULL, 0x000fe20003fc4070ULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x00010a0013277811ULL, 0x000fe400078e10ffULL, 0x000000ff24207207ULL, 0x000fc40003000000ULL,
0x000000ff24247207ULL, 0x000fc60007000000ULL, 0x0000000123237824ULL, 0x000fc800078e0220ULL,
0x0000004023207824ULL, 0x040fe200078e00ffULL, 0x0000002223227211ULL, 0x000fc800078ff0ffULL,
0x000000c020217812ULL, 0x000fe400078ec0ffULL, 0x0000000a24207c10ULL, 0x000fc6000fffe0ffULL,
0x0000010022217824ULL, 0x000fca00078e0221ULL, 0x0000002021217810ULL, 0x000fca0007ffe0ffULL,
0x0000000113237824ULL, 0x100fe400078e0221ULL, 0x0000680020207a24ULL, 0x000fc600078e0221ULL,
0x000000662300720cULL, 0x000fe20003fc6070ULL, 0x0000000113207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e4000f12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff207f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff757224ULL, 0x002fe200078e0021ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000016ff17723eULL, 0x000fc800000000ffULL, 0x0000541017227816ULL, 0x000fe20000000017ULL,
0x0000b5127f007947ULL, 0x000fea000b800000ULL, 0x00001f6c22177589ULL, 0x0002a400000e0000ULL,
0x0000b5527f007947ULL, 0x000fea000b800000ULL, 0x00001f6b22187589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000106c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000e17000207802ULL, 0x000fc40000000f00ULL,
0x0000bd5000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x000000186c277810ULL, 0x002fe40007ffe0ffULL,
0x0000e1c000207802ULL, 0x000fc40000000f00ULL, 0x0000bd0000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006e20783bULL, 0x00ae620000004200ULL, 0x0000b0006f247811ULL, 0x000fe200078e20ffULL,
0x0000062000017945ULL, 0x000fe20003800000ULL, 0x000000ff2900720cULL, 0x000fe20003fc5270ULL,
0x000000006d3c783bULL, 0x000fe80000004200ULL, 0x000000002448783bULL, 0x000ee80000000200ULL,
0x00000000712c783bULL, 0x000f280000004200ULL, 0x000000007244783bULL, 0x000ea20000004200ULL,
0x0000312020207816ULL, 0x002fc400000000ffULL, 0x0000312021217816ULL, 0x000fe400000000ffULL,
0x00000020ff26723eULL, 0x084fe400020006ffULL, 0x00000020ff28723eULL, 0x000fe400030006ffULL,
0x0000312022227816ULL, 0x000fe200000000ffULL, 0x000000174848b232ULL, 0x088fe20000000000ULL,
0x0000312023237816ULL, 0x000fe200000000ffULL, 0x000000174a4ab232ULL, 0x000fe20000000000ULL,
0x0000b00070207811ULL, 0x000fe200078e20ffULL, 0x000000184949b232ULL, 0x080fe20000000000ULL,
0x00000021ff27723eULL, 0x080fe200020006ffULL, 0x000000184b4bb232ULL, 0x000fe20000000000ULL,
0x00000021ff29723eULL, 0x000fc400030006ffULL, 0x00000022ff30723eULL, 0x080fe400020006ffULL,
0x00000023ff31723eULL, 0x080fe400020006ffULL, 0x00000022ff34723eULL, 0x000fe200030006ffULL,
0x000000264824723cULL, 0x000f6200000018ffULL, 0x00000023ff35723eULL, 0x000fe400030006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x000031203c3c7816ULL, 0x000fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fc400000000ffULL, 0x000031203e687816ULL, 0x000fe200000000ffULL,
0x000000284828723cULL, 0x040f6200000018ffULL, 0x000031203f697816ULL, 0x000fe400000000ffULL,
0x0000003cff38723eULL, 0x080fe400020006ffULL, 0x0000003dff39723eULL, 0x080fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe200030006ffULL, 0x000000304830723cULL, 0x000f6200000018ffULL,
0x0000003dff3d723eULL, 0x000fc400030006ffULL, 0x00000068ff40723eULL, 0x080fe400020006ffULL,
0x00000069ff41723eULL, 0x080fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe200030006ffULL,
0x000000344834723cULL, 0x000f6200000018ffULL, 0x00000069ff69723eULL, 0x000fe400030006ffULL,
0x000031202e2e7816ULL, 0x010fe400000000ffULL, 0x000031202f2f7816ULL, 0x000fc400000000ffULL,
0x0000312044447816ULL, 0x000fe200000000ffULL, 0x000000384838723cULL, 0x000f6200000018ffULL,
0x0000312045457816ULL, 0x000fe400000000ffULL, 0x0000312046467816ULL, 0x000fe400000000ffULL,
0x0000312047477816ULL, 0x000fc600000000ffULL, 0x0000003c483c723cULL, 0x000f6200000018ffULL,
0x000000172020b232ULL, 0x082fe40000000000ULL, 0x000000172222b232ULL, 0x000fe40000000000ULL,
0x000000182121b232ULL, 0x000fc60000000000ULL, 0x000000404840723cULL, 0x000f6200000018ffULL,
0x000000182323b232ULL, 0x000fce0000000000ULL, 0x000000684848723cULL, 0x000b6e00000018ffULL,
0x000031202c687816ULL, 0x020fe400000000ffULL, 0x000031202d697816ULL, 0x000fe400000000ffULL,
0x00000068ff2c723eULL, 0x000fc400020006ffULL, 0x00000069ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2024723cULL, 0x000b6e0000001824ULL, 0x00000068ff2c723eULL, 0x020fe400030006ffULL,
0x00000069ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2028723cULL, 0x000b6e0000001828ULL,
0x0000002eff2c723eULL, 0x020fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2030723cULL, 0x000b6e0000001830ULL, 0x0000002eff2c723eULL, 0x020fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2034723cULL, 0x000b6e0000001834ULL,
0x00000044ff2c723eULL, 0x020fe400020006ffULL, 0x00000045ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2038723cULL, 0x000b6e0000001838ULL, 0x00000044ff2c723eULL, 0x020fe400030006ffULL,
0x00000045ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c203c723cULL, 0x000b6e000000183cULL,
0x00000046ff2c723eULL, 0x020fe400020006ffULL, 0x00000047ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2040723cULL, 0x000b6e0000001840ULL, 0x00000046ff2c723eULL, 0x020fe400030006ffULL,
0x00000047ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000240b0b7221ULL, 0x000fe20000010000ULL, 0x000000250a0a7221ULL, 0x000fe20000010000ULL,
0x0000002807077221ULL, 0x000fe20000010000ULL, 0x0000002906067221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314c4c7221ULL, 0x000fe20000010000ULL,
0x000000344f4f7221ULL, 0x000fe20000010000ULL, 0x0000003550507221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003954547221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x000fe20000010000ULL, 0x0000003d58587221ULL, 0x000fe20000010000ULL,
0x000000405b5b7221ULL, 0x000fe20000010000ULL, 0x000000415c5c7221ULL, 0x000fe20000010000ULL,
0x000000485f5f7221ULL, 0x020fe20000010000ULL, 0x0000004960607221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000002609097221ULL, 0x000fe20000010000ULL,
0x0000002708087221ULL, 0x000fe20000010000ULL, 0x0000002a05057221ULL, 0x000fe20000010000ULL,
0x0000002b1e1e7221ULL, 0x000fe20000010000ULL, 0x000000324d4d7221ULL, 0x000fe20000010000ULL,
0x000000334e4e7221ULL, 0x000fe20000010000ULL, 0x0000003651517221ULL, 0x000fe20000010000ULL,
0x0000003752527221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b56567221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x000fe20000010000ULL,
0x0000003f5a5a7221ULL, 0x000fe20000010000ULL, 0x000000425d5d7221ULL, 0x000fe20000010000ULL,
0x000000435e5e7221ULL, 0x000fe20000010000ULL, 0x0000004a61617221ULL, 0x020fe20000010000ULL,
0x0000004b62627221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000174747810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000737400720cULL, 0x000fe20003f06070ULL, 0x010b8800ff227f8cULL, 0x020e58000c80043fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffbd1000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c010217811ULL, 0x000fe200078e40ffULL,
0x010b6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000662100720cULL, 0x000fda0003f06070ULL,
0x0000436000000947ULL, 0x000fea0003800000ULL, 0x000000ffff747224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x000fe20000011674ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000374227812ULL, 0x042fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000002174217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000321257810ULL, 0x000fc80007ffe0ffULL, 0x0000000325217812ULL, 0x040fe400078ec0ffULL,
0x0000001025207211ULL, 0x000fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x000fe20007ffe0ffULL, 0x0000099000017945ULL, 0x000fe60003800000ULL,
0x000000652400720cULL, 0x000fda0003f06070ULL, 0x0000052000008947ULL, 0x000fea0003800000ULL,
0x000000051a297c10ULL, 0x000fe2000fffe0ffULL, 0x0000000420237824ULL, 0x000fe200078e0221ULL,
0x00000020002a7811ULL, 0x000fe200078e30ffULL, 0x00000100ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000021a2e7810ULL, 0x000fe20007ffe0ffULL, 0x010a000029257984ULL, 0x000e620000004800ULL,
0x0000002023237811ULL, 0x000fe200078e30ffULL, 0x0000000129267824ULL, 0x040fe200078e022aULL,
0x000000052e2f7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000129277824ULL, 0x040fe200078e0204ULL,
0x0000002366247217ULL, 0x000fe20007800000ULL, 0x0000001029287824ULL, 0x000fc400078e00ffULL,
0x000000012f307824ULL, 0x000fe400078e0204ULL, 0x0000000124247824ULL, 0x000fe400078e0a23ULL,
0x0000001004237824ULL, 0x000fc600078e00ffULL, 0x0000000524247c17ULL, 0x000fe4000f800000ULL,
0x000000f0232b7812ULL, 0x000fe400078ec0ffULL, 0x8000000524237c10ULL, 0x000fc8000fffe0ffULL,
0x000000231a00720cULL, 0x000fe20003f06070ULL, 0x010ac00025257984ULL, 0x002e640000004800ULL,
0x0000002512267224ULL, 0x002fc800078e0226ULL, 0x00005e0026247625ULL, 0x000fca00078e002cULL,
0x0000002b24267210ULL, 0x000fe40007f3e0ffULL, 0xfffffff028247812ULL, 0x000fc600078ee227ULL,
0x000000ffff277224ULL, 0x000fe200008e0625ULL, 0x0000e000242d7811ULL, 0x000fe200078e20ffULL,
0x000000012f247824ULL, 0x040fe400078e022aULL, 0x000000102f2f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e2000c101c4cULL,
0x000000232e00720cULL, 0x000fe40003f06070ULL, 0xfffffff02f307812ULL, 0x000fe200078ee230ULL,
0x010a080029287984ULL, 0x000ea20000004800ULL, 0x000000041a2e7810ULL, 0x000fc80007ffe0ffULL,
0x000000052e2f7c10ULL, 0x000fe4000fffe0ffULL, 0x0000e000302d7811ULL, 0x002fc600078e20ffULL,
0x000000012f307824ULL, 0x000fe200078e0204ULL, 0x010ac00028257984ULL, 0x004e640000004800ULL,
0x0000002512257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002cULL,
0x0000002b24267210ULL, 0x000fe20007f3e0ffULL, 0x000000012f247824ULL, 0x040fe400078e022aULL,
0x000000102f2f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc600008e0625ULL,
0xfffffff02f307812ULL, 0x000fe400078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262d7faeULL, 0x0003e2000c101c4cULL, 0x000000232e00720cULL, 0x000fe40003f06070ULL,
0x000000061a2e7810ULL, 0x000fe20007ffe0ffULL, 0x010a100029287984ULL, 0x000ea60000004800ULL,
0x000000052e2f7c10ULL, 0x000fe4000fffe0ffULL, 0x0000e000302d7811ULL, 0x002fc600078e20ffULL,
0x000000012f2a7824ULL, 0x000fe200078e022aULL, 0x010ac00028257984ULL, 0x004e640000004800ULL,
0x0000002512257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002cULL,
0x0000002b24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242d7faeULL, 0x0003e2000c101c4cULL,
0x000000232e00720cULL, 0x000fc60003f06070ULL, 0x010a180029287984ULL, 0x000ea80000004800ULL,
0x010ac00028277984ULL, 0x004ea40000004800ULL, 0x0000002712277224ULL, 0x004fe400078e022aULL,
0x000000012f2a7824ULL, 0x000fe400078e0204ULL, 0x00005e0027267625ULL, 0x000fc800078e002cULL,
0x000000102f2f7824ULL, 0x000fe200078e00ffULL, 0x0000002b26247210ULL, 0x002fc80007f3e0ffULL,
0xfffffff02f2a7812ULL, 0x000fe200078ee22aULL, 0x000000ffff257224ULL, 0x000fc600008e0627ULL,
0x0000e0002a237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e2000c101c4cULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001004257824ULL, 0x000fe200078e00ffULL,
0x00000020002a7811ULL, 0x000fe200078e30ffULL, 0x00000100ff2d7424ULL, 0x000fe200078e00ffULL,
0x000000022b297810ULL, 0x000fe20007ffe0ffULL, 0x010a00002b237984ULL, 0x000e620000004800ULL,
0x000000f0252f7812ULL, 0x000fe200078ec0ffULL, 0x000000012b247824ULL, 0x040fe400078e022aULL,
0x000000012b277824ULL, 0x000fc400078e0204ULL, 0x000000102b287824ULL, 0x000fe400078e00ffULL,
0x00000001292c7824ULL, 0x000fe200078e0204ULL, 0x010ac00023237984ULL, 0x002e640000004800ULL,
0x0000002312247224ULL, 0x002fe200078e0224ULL, 0xfffffff028237812ULL, 0x000fc600078ee227ULL,
0x00005e0024247625ULL, 0x000fe200078e002dULL, 0x0000e00023317811ULL, 0x000fc800078e20ffULL,
0x0000002f24267210ULL, 0x000fe20007f1e0ffULL, 0x000000012a247824ULL, 0x000fe400078e0229ULL,
0x0000001029297824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc600000e0625ULL,
0xfffffff0292c7812ULL, 0x000fe400078ee22cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a08002b237984ULL, 0x000ea20000004800ULL,
0x0000e0002c317811ULL, 0x002fe400078e20ffULL, 0x000000042b277810ULL, 0x000fca0007ffe0ffULL,
0x00000001272c7824ULL, 0x000fe200078e0204ULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002312247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24287210ULL, 0x000fe20007f1e0ffULL, 0x000000012a247824ULL, 0x000fe400078e0227ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x000000ffff297224ULL, 0x000fc600000e0625ULL,
0xfffffff0272c7812ULL, 0x000fe400078ee22cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e8000b901c4cULL, 0x010a10002b237984ULL, 0x000ea20000004800ULL,
0x0000e0002c297811ULL, 0x002fe400078e20ffULL, 0x000000062b317810ULL, 0x000fca0007ffe0ffULL,
0x0000000131287824ULL, 0x000fe200078e0204ULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002312247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24267210ULL, 0x000fe20007f1e0ffULL, 0x000000012a247824ULL, 0x000fe400078e0231ULL,
0x0000001031317824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc600000e0625ULL,
0xfffffff031287812ULL, 0x000fe400078ee228ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c4cULL, 0x010a18002b237984ULL, 0x000ea20000004800ULL,
0x0000e00028277811ULL, 0x002fc600078e20ffULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002312247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e6000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000206300720cULL, 0x000fe20003f04070ULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000032200780cULL, 0x000fda0003f25270ULL,
0x0000010000008947ULL, 0x000fea0000800000ULL, 0x000000031300780cULL, 0x000fe40003f04070ULL,
0x0000000111117810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000247919ULL, 0x000e620000002700ULL, 0x000000641100720cULL, 0x040fe20003f06070ULL,
0x00000004ff257424ULL, 0x000fe400078e00ffULL, 0x0000000424237824ULL, 0x002fe200078e0213ULL,
0x0000640011247a10ULL, 0x000fc60007ffe0ffULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00010ac013237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000206300720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020227824ULL, 0x000fe200078e0221ULL,
0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL, 0x00010a0013237811ULL, 0x040fe200078e10ffULL,
0x0000000113217824ULL, 0x100fe400078e0222ULL, 0x0000680020207a24ULL, 0x000fc600078e0222ULL,
0x000000662100720cULL, 0x000fe20003f06070ULL, 0x00000004ff217424ULL, 0x000fe400078e00ffULL,
0x0000000113207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fcc00078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff7400720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff757224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b3800ff207f8cULL, 0x000e64000c800405ULL,
0x000000ffff247224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b3c05ff157984ULL, 0x000e640008000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220227210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff157819ULL, 0x000fc80000011423ULL,
0x0000002215157211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0623ULL,
0x0000000215157819ULL, 0x000fc80000001222ULL, 0x000000150000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010b3c05ff157984ULL, 0x000e640008000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001004157824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011604ULL,
0x0000007015157812ULL, 0x000fe400078ec0ffULL, 0x0000000c20207812ULL, 0x000fca00078ec0ffULL,
0x0000000115277824ULL, 0x000fca00078e0220ULL, 0x0101800027227984ULL, 0x000e680000000800ULL,
0x0103800027237984ULL, 0x0004e20000000800ULL, 0x0000000f2200720bULL, 0x002fe20003f1d000ULL,
0x000094127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x004fc800000e0100ULL,
0x0000ffff15287812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff157424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e000fULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000030300780cULL, 0x000fe40003f05270ULL,
0x0000000f2200720bULL, 0x000fe20003f34000ULL, 0x000093d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x000000220f247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0105802427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000240f0f7221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL, 0x0000000f00297308ULL, 0x000e640000000800ULL,
0x000000290c0c7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000093227f007947ULL, 0x000fea000b800000ULL, 0x00001f6c290f7589ULL, 0x0002a400000e0000ULL,
0x0000000f0b0b7220ULL, 0x084fe20000410000ULL, 0x0000000f0a0a7220ULL, 0x080fe20000410000ULL,
0x0000000f07077220ULL, 0x080fe20000410000ULL, 0x0000000f06067220ULL, 0x080fe20000410000ULL,
0x0000000f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000000f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000000f50507220ULL, 0x080fe20000410000ULL,
0x0000000f53537220ULL, 0x080fe20000410000ULL, 0x0000000f54547220ULL, 0x080fe20000410000ULL,
0x0000000f57577220ULL, 0x080fe20000410000ULL, 0x0000000f58587220ULL, 0x080fe20000410000ULL,
0x0000000f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000000f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000000f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000000f60607220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000092327f007947ULL, 0x000fea000b800000ULL,
0x00001f6b290f7589ULL, 0x00046400000e0000ULL, 0x0000000f09097220ULL, 0x082fe20000410000ULL,
0x0000000f08087220ULL, 0x080fe20000410000ULL, 0x0000000f05057220ULL, 0x080fe20000410000ULL,
0x0000000f1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000000f4e4e7220ULL, 0x080fe20000410000ULL, 0x0000000f51517220ULL, 0x080fe20000410000ULL,
0x0000000f52527220ULL, 0x080fe20000410000ULL, 0x0000000f55557220ULL, 0x080fe20000410000ULL,
0x0000000f56567220ULL, 0x080fe20000410000ULL, 0x0000000f59597220ULL, 0x080fe20000410000ULL,
0x0000000f5a5a7220ULL, 0x080fe20000410000ULL, 0x0000000f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000000f5e5e7220ULL, 0x080fe20000410000ULL, 0x0000000f61617220ULL, 0x080fe20000410000ULL,
0x0000000f62627220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff28ff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff150816ULL, 0x000fc60000000015ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200160308ULL, 0x000e640000000800ULL, 0x0000001623230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000c230c7221ULL, 0x008fe20000010000ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff15ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000016ff17723eULL, 0x000fc800000000ffULL,
0x0000541017227816ULL, 0x000fe20000000017ULL, 0x000090727f007947ULL, 0x000fea000b800000ULL,
0x00001f6c22177589ULL, 0x0002e400000e0000ULL, 0x000090b27f007947ULL, 0x000fea000b800000ULL,
0x00001f6b22187589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000106c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001082000207802ULL, 0x000fc40000000f00ULL, 0x000096a000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x000000186c277810ULL, 0x002fe40007ffe0ffULL, 0x0001087000207802ULL, 0x000fc40000000f00ULL,
0x0000965000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001b20783bULL, 0x002e620000004200ULL,
0x0000b80019247811ULL, 0x000fe200078e20ffULL, 0x0000068000017945ULL, 0x000fe20003800000ULL,
0x000000746c00720cULL, 0x000fe20003f46070ULL, 0x00000000673c783bULL, 0x000fe20000004200ULL,
0x000000106300720cULL, 0x000fc40003fc3070ULL, 0x000000746b00720cULL, 0x000fe20003f26070ULL,
0x000000002448783bULL, 0x000f220000000200ULL, 0x000000106300720cULL, 0x000fc60003f03070ULL,
0x000000001d2c783bULL, 0x000ee80000004200ULL, 0x000000006a44783bULL, 0x000ea20000004200ULL,
0x0000312020207816ULL, 0x002fe400000000ffULL, 0x0000312021217816ULL, 0x000fe400000000ffULL,
0x00000020ff26723eULL, 0x084fe400020006ffULL, 0x00000020ff28723eULL, 0x000fc400030006ffULL,
0x0000312022227816ULL, 0x000fe200000000ffULL, 0x000000174848b232ULL, 0x098fe20000000000ULL,
0x0000312023237816ULL, 0x000fe200000000ffULL, 0x000000174a4ab232ULL, 0x000fe20000000000ULL,
0x0000b8001c207811ULL, 0x000fe200078e20ffULL, 0x000000184949b232ULL, 0x080fe20000000000ULL,
0x00000021ff27723eULL, 0x080fe200020006ffULL, 0x000000184b4bb232ULL, 0x000fe20000000000ULL,
0x00000021ff29723eULL, 0x000fe400030006ffULL, 0x00000022ff30723eULL, 0x000fc400020006ffULL,
0x00000023ff31723eULL, 0x080fe400020006ffULL, 0x00000022ff34723eULL, 0x000fe200030006ffULL,
0x000000264824723cULL, 0x040f6200000018ffULL, 0x00000023ff35723eULL, 0x000fe400030006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x000031203c3c7816ULL, 0x000fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e687816ULL, 0x000fe200000000ffULL,
0x000000284828723cULL, 0x000f6200000018ffULL, 0x000031203f697816ULL, 0x000fc400000000ffULL,
0x0000003cff38723eULL, 0x080fe400020006ffULL, 0x0000003dff39723eULL, 0x080fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe200030006ffULL, 0x000000304830723cULL, 0x000f6200000018ffULL,
0x0000003dff3d723eULL, 0x000fe400030006ffULL, 0x00000068ff40723eULL, 0x000fe400020006ffULL,
0x00000069ff41723eULL, 0x000fc400020006ffULL, 0x00000068ff68723eULL, 0x000fe200030006ffULL,
0x000000344834723cULL, 0x040f6200000018ffULL, 0x00000069ff69723eULL, 0x000fe400030006ffULL,
0x000031202e2e7816ULL, 0x000fe400000000ffULL, 0x000031202f2f7816ULL, 0x000fe400000000ffULL,
0x0000312044447816ULL, 0x000fe200000000ffULL, 0x000000384838723cULL, 0x000f6200000018ffULL,
0x0000312045457816ULL, 0x000fc400000000ffULL, 0x0000312046467816ULL, 0x000fe400000000ffULL,
0x0000312047477816ULL, 0x000fc600000000ffULL, 0x0000003c483c723cULL, 0x000f6200000018ffULL,
0x000000172020b232ULL, 0x082fe40000000000ULL, 0x000000172222b232ULL, 0x000fe40000000000ULL,
0x000000182121b232ULL, 0x000fc60000000000ULL, 0x000000404840723cULL, 0x000f6200000018ffULL,
0x000000182323b232ULL, 0x000fce0000000000ULL, 0x000000684848723cULL, 0x000b6e00000018ffULL,
0x000031202c687816ULL, 0x020fe400000000ffULL, 0x000031202d697816ULL, 0x000fe400000000ffULL,
0x00000068ff2c723eULL, 0x000fc400020006ffULL, 0x00000069ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2024723cULL, 0x000b6e0000001824ULL, 0x00000068ff2c723eULL, 0x020fe400030006ffULL,
0x00000069ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2028723cULL, 0x000b6e0000001828ULL,
0x0000002eff2c723eULL, 0x020fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2030723cULL, 0x000b6e0000001830ULL, 0x0000002eff2c723eULL, 0x020fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fe400030006ffULL, 0x00000001742e7810ULL, 0x000fc80007ffe0ffULL,
0x0000002e6c00720cULL, 0x080fe20005746470ULL, 0x0000002c2034723cULL, 0x000b620000001834ULL,
0x0000002e6b00720cULL, 0x000fcc0004f26470ULL, 0x00000044ff2c723eULL, 0x020fe400020006ffULL,
0x00000045ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2038723cULL, 0x000b6e0000001838ULL,
0x00000044ff2c723eULL, 0x020fe400030006ffULL, 0x00000045ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c203c723cULL, 0x000b6e000000183cULL, 0x00000046ff2c723eULL, 0x020fe400020006ffULL,
0x00000047ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2040723cULL, 0x000b6e0000001840ULL,
0x00000046ff2c723eULL, 0x020fe400030006ffULL, 0x00000047ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2048723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240b0b7221ULL, 0x000fe20000010000ULL,
0x000000250a0a7221ULL, 0x000fe20000010000ULL, 0x0000002807077221ULL, 0x000fe20000010000ULL,
0x0000002906067221ULL, 0x000fe20000010000ULL, 0x000000301f1f7221ULL, 0x000fe20000010000ULL,
0x000000314c4c7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x0000003550507221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003954547221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x000fe20000010000ULL,
0x0000003d58587221ULL, 0x000fe20000010000ULL, 0x000000405b5b7221ULL, 0x000fe20000010000ULL,
0x000000415c5c7221ULL, 0x000fe20000010000ULL, 0x000000485f5f7221ULL, 0x020fe20000010000ULL,
0x0000004960607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000002609097221ULL, 0x000fe20000010000ULL, 0x0000002708087221ULL, 0x000fe20000010000ULL,
0x0000002a05057221ULL, 0x000fe20000010000ULL, 0x0000002b1e1e7221ULL, 0x000fe20000010000ULL,
0x000000324d4d7221ULL, 0x000fe20000010000ULL, 0x000000334e4e7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003752527221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b56567221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x000fe20000010000ULL, 0x0000003f5a5a7221ULL, 0x000fe20000010000ULL,
0x000000425d5d7221ULL, 0x000fe20000010000ULL, 0x000000435e5e7221ULL, 0x000fe20000010000ULL,
0x0000004a61617221ULL, 0x020fe20000010000ULL, 0x0000004b62627221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x020e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe2000001162eULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000000106300720cULL, 0x000fc40003fc3070ULL,
0x000000232e237207ULL, 0x040fe40002800000ULL, 0x000000032e247812ULL, 0x000fe400078ec0ffULL,
0x0000000323257810ULL, 0x000fe40007ffe0ffULL, 0x000000106300720cULL, 0x000fe40003f03070ULL,
0x00000040ff297803ULL, 0x000fe40000000000ULL, 0x000000ff24247207ULL, 0x000fc40006800000ULL,
0x0000000325237812ULL, 0x040fe400078ec0ffULL, 0x0000001025227211ULL, 0x000fe200078ff0ffULL,
0x000000ffff287224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8400ff267984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000026ff7812ULL, 0x002fe200078c4875ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8400ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe400078c4875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x010b8c00ff257984ULL, 0x000e620000000800ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000025ff7812ULL, 0x002fe200078c4828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe400078c4828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000122207810ULL, 0x000fe20007ffe0ffULL, 0x0000097000017945ULL, 0x000fe60003800000ULL,
0x000000652000720cULL, 0x000fda0003fc6070ULL, 0x000005100000e947ULL, 0x000fea0003800000ULL,
0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001004257824ULL, 0x000fe200078e00ffULL,
0x000000021a2e7810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2c7424ULL, 0x000fe400078e00ffULL,
0x010a00002b267984ULL, 0x000e620000004800ULL, 0x000000f0252d7812ULL, 0x000fe200078ec0ffULL,
0x0000000422257824ULL, 0x000fe200078e0223ULL, 0x000000052e317c10ULL, 0x000fe2000fffe0ffULL,
0x00000040002a7824ULL, 0x000fe400078e022bULL, 0x0000004025257824ULL, 0x000fc400078e00ffULL,
0x000000102b287824ULL, 0x000fe400078e00ffULL, 0x0000000131307824ULL, 0x040fe400078e0204ULL,
0x0000001031317824ULL, 0x000fca00078e00ffULL, 0xfffffff031307812ULL, 0x000fe200078ee230ULL,
0x010ac00026217984ULL, 0x0022a40000004800ULL, 0x0000002566267217ULL, 0x002fca0007800000ULL,
0x0000000126267824ULL, 0x000fe400078e0a25ULL, 0x000000012b257824ULL, 0x000fc600078e0204ULL,
0x0000000526267c17ULL, 0x000fe4000f800000ULL, 0xfffffff028277812ULL, 0x000fe400078ee225ULL,
0x8000000526257c10ULL, 0x000fe4000fffe0ffULL, 0x0000c000272f7811ULL, 0x000fe400078e20ffULL,
0x000000022a267810ULL, 0x000fe20007ffe0ffULL, 0x0000002112217224ULL, 0x004fc800078e022aULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002d20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x000000251a00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202f7faeULL, 0x0003e8000f101c4cULL,
0x010a08002b287984ULL, 0x000ea20000004800ULL, 0x0000c000302f7811ULL, 0x002fe400078e20ffULL,
0x000000042a207810ULL, 0x040fe40007ffe0ffULL, 0x000000062a2a7810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028277984ULL, 0x004e640000004800ULL, 0x0000002712277224ULL, 0x002fc800078e0226ULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000252e00720cULL, 0x000fe40003fc6070ULL,
0x000000041a2e7810ULL, 0x000fc80007ffe0ffULL, 0x000000052e317c10ULL, 0x000fca000fffe0ffULL,
0x0000000131307824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c4cULL, 0x0000001031317824ULL, 0x000fc600078e00ffULL,
0x010a10002b287984ULL, 0x000ea40000004800ULL, 0xfffffff031307812ULL, 0x000fc800078ee230ULL,
0x0000c000302f7811ULL, 0x002fe200078e20ffULL, 0x010ac00028217984ULL, 0x004e640000004800ULL,
0x0000002112217224ULL, 0x002fc800078e0220ULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002d20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000252e00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202f7faeULL, 0x0003e8000f101c4cULL, 0x010a18002b287984ULL, 0x000ea80000004800ULL,
0x010ac00028277984ULL, 0x004ea40000004800ULL, 0x0000002712277224ULL, 0x004fe200078e022aULL,
0x000000061a2a7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002d26267210ULL, 0x000fe40007fde0ffULL, 0x000000052a2d7c10ULL, 0x000fc6000fffe0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000252a00720cULL, 0x000fe20003fc6070ULL,
0x000000012d2c7824ULL, 0x040fe400078e0204ULL, 0x000000102d2d7824ULL, 0x000fca00078e00ffULL,
0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL, 0x0000c0002c217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e2000f101c4cULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051a2b7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000001004267824ULL, 0x000fe200078e00ffULL,
0x000000022b337810ULL, 0x000fe20007ffe0ffULL, 0x010a00002b257984ULL, 0x000e620000004800ULL,
0x0000004000287824ULL, 0x000fe400078e022bULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x00000001332a7824ULL, 0x000fc400078e0204ULL, 0x0000001033337824ULL, 0x000fca00078e00ffULL,
0xfffffff0332a7812ULL, 0x000fe400078ee22aULL, 0x000000042b337810ULL, 0x000fe20007ffe0ffULL,
0x010ac00025257984ULL, 0x002e640000004800ULL, 0x0000002512207224ULL, 0x002fc800078e0228ULL,
0x00005e0020207625ULL, 0x000fca00078e002dULL, 0x0000002f20267210ULL, 0x000fe20007fde0ffULL,
0x000000012b207824ULL, 0x000fc800078e0204ULL, 0x000000ffff277224ULL, 0x000fe400030e0621ULL,
0x000000102b217824ULL, 0x000fca00078e00ffULL, 0xfffffff021207812ULL, 0x000fc800078ee220ULL,
0x0000c00020317811ULL, 0x000fe400078e20ffULL, 0x0000000228207810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c4cULL,
0x010a08002b257984ULL, 0x000ea20000004800ULL, 0x0000c0002a317811ULL, 0x002fe200078e20ffULL,
0x00000001332a7824ULL, 0x040fe200078e0204ULL, 0x0000000428267810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fca00078e00ffULL, 0xfffffff0332a7812ULL, 0x000fe200078ee22aULL,
0x010ac00025257984ULL, 0x004e640000004800ULL, 0x0000002512207224ULL, 0x002fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fca00078e002dULL, 0x0000002f20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fca00030e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000b901c4cULL, 0x010a10002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fe400078e20ffULL, 0x0000000628207810ULL, 0x000fe20007ffe0ffULL,
0x010ac00025257984ULL, 0x004e640000004800ULL, 0x0000002512267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a18002b257984ULL, 0x000ea80000004800ULL,
0x010ac00025257984ULL, 0x004ea40000004800ULL, 0x0000002512207224ULL, 0x004fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fe200078e002dULL, 0x000000062b2d7810ULL, 0x000fc80007ffe0ffULL,
0x0000002f20207210ULL, 0x000fe20007fde0ffULL, 0x000000012d287824ULL, 0x040fe400078e0204ULL,
0x000000102d2d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x000fc600030e0621ULL,
0xfffffff02d287812ULL, 0x000fc800078ee228ULL, 0x0000c00028277811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020277faeULL, 0x0003e4000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8c00ff257984ULL, 0x000e620000000800ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000025ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000226300720cULL, 0x000fe20003fc4070ULL,
0x00000004ff257424ULL, 0x000fe200078e00ffULL, 0x00010a0013277811ULL, 0x000fe400078e10ffULL,
0x000000ff24207207ULL, 0x000fc40003000000ULL, 0x000000ff24247207ULL, 0x000fc60007000000ULL,
0x0000000123237824ULL, 0x000fc800078e0220ULL, 0x0000004023207824ULL, 0x040fe200078e00ffULL,
0x0000002223227211ULL, 0x000fc800078ff0ffULL, 0x000000c020217812ULL, 0x000fe400078ec0ffULL,
0x0000000a24207c10ULL, 0x000fc6000fffe0ffULL, 0x0000010022217824ULL, 0x000fca00078e0221ULL,
0x0000002021217810ULL, 0x000fca0007ffe0ffULL, 0x0000000113237824ULL, 0x100fe400078e0221ULL,
0x0000680020207a24ULL, 0x000fc600078e0221ULL, 0x000000662300720cULL, 0x000fe20003fc6070ULL,
0x0000000113207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020277faeULL, 0x0003e4000f12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff757224ULL, 0x002fe200078e0021ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000016ff17723eULL, 0x000fc800000000ffULL,
0x0000541017227816ULL, 0x000fe20000000017ULL, 0x000074527f007947ULL, 0x000fea000b800000ULL,
0x00001f6c22177589ULL, 0x0002a400000e0000ULL, 0x000074927f007947ULL, 0x000fea000b800000ULL,
0x00001f6b22187589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000106c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001250000207802ULL, 0x000fc40000000f00ULL, 0x000079c000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x000000186c277810ULL, 0x002fe40007ffe0ffULL, 0x0001255000207802ULL, 0x000fc40000000f00ULL,
0x0000797000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006e20783bULL, 0x00ae620000004200ULL,
0x0000b8006f247811ULL, 0x000fe200078e20ffULL, 0x0000062000017945ULL, 0x000fe20003800000ULL,
0x000000ff2900720cULL, 0x000fe20003fc5270ULL, 0x000000006d3c783bULL, 0x000fe80000004200ULL,
0x000000002448783bULL, 0x000ee80000000200ULL, 0x00000000712c783bULL, 0x000f280000004200ULL,
0x000000007244783bULL, 0x000ea20000004200ULL, 0x0000312020207816ULL, 0x002fc400000000ffULL,
0x0000312021217816ULL, 0x000fe400000000ffULL, 0x00000020ff26723eULL, 0x084fe400020006ffULL,
0x00000020ff28723eULL, 0x000fe400030006ffULL, 0x0000312022227816ULL, 0x000fe200000000ffULL,
0x000000174848b232ULL, 0x088fe20000000000ULL, 0x0000312023237816ULL, 0x000fe200000000ffULL,
0x000000174a4ab232ULL, 0x000fe20000000000ULL, 0x0000b80070207811ULL, 0x000fe200078e20ffULL,
0x000000184949b232ULL, 0x080fe20000000000ULL, 0x00000021ff27723eULL, 0x080fe200020006ffULL,
0x000000184b4bb232ULL, 0x000fe20000000000ULL, 0x00000021ff29723eULL, 0x000fc400030006ffULL,
0x00000022ff30723eULL, 0x080fe400020006ffULL, 0x00000023ff31723eULL, 0x080fe400020006ffULL,
0x00000022ff34723eULL, 0x000fe200030006ffULL, 0x000000264824723cULL, 0x000f6200000018ffULL,
0x00000023ff35723eULL, 0x000fe400030006ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fc400000000ffULL,
0x000031203e687816ULL, 0x000fe200000000ffULL, 0x000000284828723cULL, 0x040f6200000018ffULL,
0x000031203f697816ULL, 0x000fe400000000ffULL, 0x0000003cff38723eULL, 0x080fe400020006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe200030006ffULL,
0x000000304830723cULL, 0x000f6200000018ffULL, 0x0000003dff3d723eULL, 0x000fc400030006ffULL,
0x00000068ff40723eULL, 0x080fe400020006ffULL, 0x00000069ff41723eULL, 0x080fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200030006ffULL, 0x000000344834723cULL, 0x000f6200000018ffULL,
0x00000069ff69723eULL, 0x000fe400030006ffULL, 0x000031202e2e7816ULL, 0x010fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fc400000000ffULL, 0x0000312044447816ULL, 0x000fe200000000ffULL,
0x000000384838723cULL, 0x000f6200000018ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fc600000000ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x000000172020b232ULL, 0x082fe40000000000ULL,
0x000000172222b232ULL, 0x000fe40000000000ULL, 0x000000182121b232ULL, 0x000fc60000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x000000182323b232ULL, 0x000fce0000000000ULL,
0x000000684848723cULL, 0x000b6e00000018ffULL, 0x000031202c687816ULL, 0x020fe400000000ffULL,
0x000031202d697816ULL, 0x000fe400000000ffULL, 0x00000068ff2c723eULL, 0x000fc400020006ffULL,
0x00000069ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2024723cULL, 0x000b6e0000001824ULL,
0x00000068ff2c723eULL, 0x020fe400030006ffULL, 0x00000069ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2028723cULL, 0x000b6e0000001828ULL, 0x0000002eff2c723eULL, 0x020fe400020006ffULL,
0x0000002fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2030723cULL, 0x000b6e0000001830ULL,
0x0000002eff2c723eULL, 0x020fe400030006ffULL, 0x0000002fff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2034723cULL, 0x000b6e0000001834ULL, 0x00000044ff2c723eULL, 0x020fe400020006ffULL,
0x00000045ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2038723cULL, 0x000b6e0000001838ULL,
0x00000044ff2c723eULL, 0x020fe400030006ffULL, 0x00000045ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c203c723cULL, 0x000b6e000000183cULL, 0x00000046ff2c723eULL, 0x020fe400020006ffULL,
0x00000047ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2040723cULL, 0x000b6e0000001840ULL,
0x00000046ff2c723eULL, 0x020fe400030006ffULL, 0x00000047ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2048723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240b0b7221ULL, 0x000fe20000010000ULL,
0x000000250a0a7221ULL, 0x000fe20000010000ULL, 0x0000002807077221ULL, 0x000fe20000010000ULL,
0x0000002906067221ULL, 0x000fe20000010000ULL, 0x000000301f1f7221ULL, 0x000fe20000010000ULL,
0x000000314c4c7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x0000003550507221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003954547221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x000fe20000010000ULL,
0x0000003d58587221ULL, 0x000fe20000010000ULL, 0x000000405b5b7221ULL, 0x000fe20000010000ULL,
0x000000415c5c7221ULL, 0x000fe20000010000ULL, 0x000000485f5f7221ULL, 0x020fe20000010000ULL,
0x0000004960607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000002609097221ULL, 0x000fe20000010000ULL, 0x0000002708087221ULL, 0x000fe20000010000ULL,
0x0000002a05057221ULL, 0x000fe20000010000ULL, 0x0000002b1e1e7221ULL, 0x000fe20000010000ULL,
0x000000324d4d7221ULL, 0x000fe20000010000ULL, 0x000000334e4e7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003752527221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b56567221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x000fe20000010000ULL, 0x0000003f5a5a7221ULL, 0x000fe20000010000ULL,
0x000000425d5d7221ULL, 0x000fe20000010000ULL, 0x000000435e5e7221ULL, 0x000fe20000010000ULL,
0x0000004a61617221ULL, 0x020fe20000010000ULL, 0x0000004b62627221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000174747810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000737400720cULL, 0x000fe20003f06070ULL,
0x010b8800ff227f8cULL, 0x020e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffbd1000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000000110107810ULL, 0x000fc80007ffe0ffULL,
0x000000651000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffeedf000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6500720cULL, 0x000fe20003f05270ULL, 0x000000ffff117224ULL, 0x000fe400078e0005ULL,
0x000000ffff107224ULL, 0x000fe400078e0008ULL, 0x000000ffff0f7224ULL, 0x000fd000078e0009ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x018000000c007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x00012f0000047802ULL, 0x000fc40000000f00ULL, 0x00006e1000007944ULL, 0x002fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000c00037308ULL, 0x000ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc8000000000cULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff057624ULL, 0x000fe400078e00ffULL, 0x00006e00ff047624ULL, 0x000fca00078e00ffULL,
0x0000000c04057981ULL, 0x000f28000c1e9900ULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x00000002ff277819ULL, 0x008fe20000011603ULL, 0x0000000005037220ULL, 0x014fe20000410000ULL,
0x000069c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2703007589ULL, 0x0004e400000e0000ULL,
0x0000000000047919ULL, 0x000f220000000000ULL, 0x0000000b000b7220ULL, 0x048fe20000410000ULL,
0x0000000a000a7220ULL, 0x040fe20000410000ULL, 0x0000000700077220ULL, 0x040fe20000410000ULL,
0x0000000600067220ULL, 0x040fe20000410000ULL, 0x0000001f001f7220ULL, 0x040fe20000410000ULL,
0x0000004c004c7220ULL, 0x040fe20000410000ULL, 0x0000004f004f7220ULL, 0x040fe20000410000ULL,
0x0000005000507220ULL, 0x040fe20000410000ULL, 0x0000005300537220ULL, 0x040fe20000410000ULL,
0x0000005400547220ULL, 0x040fe20000410000ULL, 0x0000005700577220ULL, 0x040fe20000410000ULL,
0x0000005800587220ULL, 0x040fe20000410000ULL, 0x0000005b005b7220ULL, 0x040fe20000410000ULL,
0x0000005c005c7220ULL, 0x040fe20000410000ULL, 0x0000005f005f7220ULL, 0x040fe20000410000ULL,
0x0000006000607220ULL, 0x000fe20000410000ULL, 0x0000000804277811ULL, 0x016fe200078ff0ffULL,
0x000068d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2703007589ULL, 0x0002a400000e0000ULL,
0x0000000f000f7220ULL, 0x044fe20000410000ULL, 0x0000001000107220ULL, 0x040fe20000410000ULL,
0x0000001100117220ULL, 0x040fe20000410000ULL, 0x0000001e001e7220ULL, 0x040fe20000410000ULL,
0x0000004d004d7220ULL, 0x040fe20000410000ULL, 0x0000004e004e7220ULL, 0x040fe20000410000ULL,
0x0000005100517220ULL, 0x040fe20000410000ULL, 0x0000005200527220ULL, 0x040fe20000410000ULL,
0x0000005500557220ULL, 0x040fe20000410000ULL, 0x0000005600567220ULL, 0x040fe20000410000ULL,
0x0000005900597220ULL, 0x040fe20000410000ULL, 0x0000005a005a7220ULL, 0x040fe20000410000ULL,
0x0000005d005d7220ULL, 0x040fe20000410000ULL, 0x0000005e005e7220ULL, 0x040fe20000410000ULL,
0x0000006100617220ULL, 0x040fe20000410000ULL, 0x0000006200627220ULL, 0x000fc20000410000ULL,
0x0000000000217919ULL, 0x000ea20000002600ULL, 0x0000000b0a00723eULL, 0x000fe200000000ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000070603723eULL, 0x002fc400000000ffULL,
0x0000000f100a723eULL, 0x000fe400000000ffULL, 0x000000111e0b723eULL, 0x000fe400000000ffULL,
0x0000001f4c04723eULL, 0x000fe400000000ffULL, 0x0000004f5005723eULL, 0x000fe400000000ffULL,
0x000000535406723eULL, 0x000fe400000000ffULL, 0x000000575807723eULL, 0x000fc400000000ffULL,
0x0000005b5c08723eULL, 0x000fe400000000ffULL, 0x0000005f6009723eULL, 0x000fe400000000ffULL,
0x0000004d4e0c723eULL, 0x000fe400000000ffULL, 0x00000051520d723eULL, 0x000fe400000000ffULL,
0x00000055560e723eULL, 0x000fe400000000ffULL, 0x000000595a0f723eULL, 0x000fc400000000ffULL,
0x0000005d5e10723eULL, 0x000fe400000000ffULL, 0x000000616211723eULL, 0x000fc400000000ffULL,
0x0000000000157919ULL, 0x004e620000000000ULL, 0x0000a00008087891ULL, 0x000fe2000f8e583fULL,
0x00005410001a7816ULL, 0x000fe40000000003ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000815137811ULL, 0x002fc400078ff0ffULL, 0x0000000215127812ULL, 0x000fc600078ec0ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000001312147211ULL, 0x040fe200078ff8ffULL,
0x0000000815137824ULL, 0x000fe200078e00ffULL, 0x00000002ff157819ULL, 0x000fe40000011615ULL,
0xfffffff817177812ULL, 0x000fe400078ee214ULL, 0x0000000813147812ULL, 0x000fe200078ec0ffULL,
0x0000000815137824ULL, 0x040fe200078e00ffULL, 0x0000001512127211ULL, 0x000fe200078ff8ffULL,
0x0000000815187824ULL, 0x000fc400078e00ffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee212ULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0x0000000212157810ULL, 0x040fe40007ffe0ffULL, 0x0000000412167810ULL, 0x040fe40007ffe0ffULL,
0x0000000612127810ULL, 0x000fe40007ffe0ffULL, 0x0000000813137c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff818157812ULL, 0x000fc400078ee215ULL, 0xfffffff819167812ULL, 0x000fe200078ee216ULL,
0x0000000113137824ULL, 0x000fe200078e0214ULL, 0xfffffff81b127812ULL, 0x000fe400078ee212ULL,
0x00007632001b7816ULL, 0x000fe40000000003ULL, 0x0000000815157c11ULL, 0x000fe4000f8e20ffULL,
0x0000000816037c11ULL, 0x000fe2000f8e20ffULL, 0x0000001a13007388ULL, 0x0003e20000000a00ULL,
0x0000000817197c11ULL, 0x000fe2000f8e20ffULL, 0x0000000114157824ULL, 0x000fe200078e0215ULL,
0x0000000812177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000114037824ULL, 0x000fe200078e0203ULL,
0x0000541004127816ULL, 0x000fe20000000005ULL, 0x0000000114197824ULL, 0x000fc400078e0219ULL,
0x0000000114177824ULL, 0x000fe200078e0217ULL, 0x0000763204137816ULL, 0x002fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x0000001215007388ULL, 0x000fe20000000a00ULL, 0x000054100a067816ULL, 0x140fe4000000000bULL,
0x000076320a077816ULL, 0x000fe2000000000bULL, 0x0000000403007388ULL, 0x0003e40000000a00ULL,
0x0000541008047816ULL, 0x002fc40000000009ULL, 0x0000763208057816ULL, 0x000fca0000000009ULL,
0x0000000417007388ULL, 0x0003e80000000a00ULL, 0x0000000619007388ULL, 0x0005e20000000a00ULL,
0x000054100c047816ULL, 0x142fe4000000000dULL, 0x000076320c057816ULL, 0x000fe4000000000dULL,
0x000054100e067816ULL, 0x144fe4000000000fULL, 0x000076320e077816ULL, 0x000fe2000000000fULL,
0x0004000415007388ULL, 0x0003e80000000a00ULL, 0x0004000603007388ULL, 0x0005e20000000a00ULL,
0x0000541010047816ULL, 0x002fc40000000011ULL, 0x0000763210057816ULL, 0x000fca0000000011ULL,
0x0004000417007388ULL, 0x0005e20000000a00ULL, 0x0000002000007947ULL, 0x000fea0003800000ULL,
0x00013700001c7802ULL, 0x000fc40000000f00ULL, 0x0000686000007944ULL, 0x004fea0003c00000ULL,
0x0000000000097919ULL, 0x000e620000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x00000005ff087e24ULL, 0x000fe2000f8e00ffULL,
0x000000040b0472a4ULL, 0x000fcc000f8e023fULL, 0x00000004ff037e24ULL, 0x004fe2000f8e00ffULL,
0x00000003ff007819ULL, 0x002fca0000011609ULL, 0x0000000100027824ULL, 0x040fe400078e0209ULL,
0x0000580000007a24ULL, 0x000fc600078e0221ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000003007211ULL, 0x000fe400078010ffULL, 0x0ffffff802047812ULL, 0x000fe400078ef809ULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fe400078048ffULL, 0x0000000804047984ULL, 0x000e62000800cc00ULL,
0x1ffffff809097812ULL, 0x000fc400078ef808ULL, 0x00005b0000037a11ULL, 0x000fca00000f4c03ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d0cULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000608057899ULL, 0x000fe2000800063fULL,
0x000000200f057810ULL, 0x000fca0007ffe0ffULL, 0x000000050f037c10ULL, 0x000fe2000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000680000047ab9ULL, 0x000fe20000000800ULL,
0x0000000505077c10ULL, 0x000fe2000fffe0ffULL, 0x000000040a0472a4ULL, 0x000fe2000f8e0205ULL,
0x000000660300720cULL, 0x080fe20003f06070ULL, 0x0000000808067899ULL, 0x000fe2000800063fULL,
0x000000660700720cULL, 0x000fe20003f26070ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0x010ad000ff0a7f8cULL, 0x000e62000c80043fULL, 0x000000040f047c10ULL, 0x000fe2000fffe0ffULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000000405067c10ULL, 0x000fe2000fffe0ffULL,
0x00006e00ff087624ULL, 0x000fe200078e00ffULL, 0x000000060f037c11ULL, 0x040fe2000f8e10ffULL,
0x0000660004047625ULL, 0x000fe200078e000dULL, 0x000000030f00780cULL, 0x000fc60003f44070ULL,
0x0000660006067625ULL, 0x000fe200078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1060000004037faeULL, 0x0005e6000c12184cULL, 0x00006f00ff097624ULL, 0x000fe200078e00ffULL,
0x1068000006037faeULL, 0x0005ea000c92184cULL, 0x000000a000002947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x004ea20000002700ULL, 0x0000000864007c0cULL, 0x000fe2000bf03070ULL,
0x0000000404037824ULL, 0x004fc400078e020fULL, 0x00000008ff047e24ULL, 0x000fe4000f8e00ffULL,
0x0000000203037824ULL, 0x000fe400078e00ffULL, 0x0000000404077824ULL, 0x000fe400078e020fULL,
0x0000640003037a24ULL, 0x000fc600078e0204ULL, 0x00010a8007077811ULL, 0x000fe200078e10ffULL,
0x0000600003047625ULL, 0x000fca00078e000dULL, 0x0000000004077faeULL, 0x0005e4000c12184cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000c08037981ULL, 0x004528000c1e9900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000ffff057224ULL, 0x002fe200078e000bULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000008a000000947ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x004e620000000000ULL, 0x00010a8008077891ULL, 0x000fe2000f8e203fULL,
0x0000000566047c17ULL, 0x000fe2000f800000ULL, 0x00000100ff157424ULL, 0x000fe200078e00ffULL,
0x0000200008097891ULL, 0x000fe4000f8e683fULL, 0x8000000504047c10ULL, 0x000fe4000fffe0ffULL,
0x00000002ff137819ULL, 0x002fe2000001160bULL, 0x000000100b117824ULL, 0x040fe200078e00ffULL,
0x0000000b0b087211ULL, 0x000fc400078fe8ffULL, 0x000000041300720cULL, 0x000fe20003f06070ULL,
0x0106000613097984ULL, 0x000e620008004800ULL, 0x00000040000e7824ULL, 0x000fe200078e0213ULL,
0x0000003011117812ULL, 0x000fe400078ec0ffULL, 0x00000003080c7812ULL, 0x000fe200078ec0ffULL,
0x0000000709097984ULL, 0x002e640008004800ULL, 0x0000000409067c24ULL, 0x002fc8000f8e020eULL,
0x00005e0006067625ULL, 0x000fca00078e0015ULL, 0x0000001106087210ULL, 0x000fe40007f3e0ffULL,
0x0ffffffc0c067812ULL, 0x000fe400078ef80bULL, 0x00000008130b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000080e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4cULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x01062006130f7984ULL, 0x000ea20008004800ULL,
0x0000001013097810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000011060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000100e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c4cULL, 0x000000040900720cULL, 0x040fe20003f06070ULL,
0x0000000409097824ULL, 0x000fe400078e00ffULL, 0x01064006130f7984ULL, 0x000ea20008004800ULL,
0x00000018130b7810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001106087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000180e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4cULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x01066006130f7984ULL, 0x000ea20008004800ULL,
0x0000002013097810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000011060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000200e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c4cULL, 0x000000040900720cULL, 0x040fe20003f06070ULL,
0x0000000409097824ULL, 0x000fe400078e00ffULL, 0x01068006130f7984ULL, 0x000ea20008004800ULL,
0x00000028130b7810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001106087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000280e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4cULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x0106a006130f7984ULL, 0x000ea20008004800ULL,
0x0000003013097810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000011060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000300e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c4cULL, 0x000000040900720cULL, 0x040fe20003f06070ULL,
0x0000000409097824ULL, 0x000fe400078e00ffULL, 0x0106c006130f7984ULL, 0x000ea20008004800ULL,
0x00000038130d7810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001106087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x00000009060b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000380e077810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c4cULL, 0x000000040d00720cULL, 0x040fe20003f06070ULL,
0x000000040d0d7824ULL, 0x000fe400078e00ffULL, 0x0106e006130a7984ULL, 0x000ea60008004800ULL,
0xfffffffc0d0c7812ULL, 0x000fc800078ee20cULL, 0x000000090c097c11ULL, 0x002fe2000f8e20ffULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0015ULL, 0x0000001106067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c4cULL, 0x000007f000007947ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x004e620000000000ULL, 0x00010a8008077891ULL, 0x000fe2000f8e203fULL,
0x00000100ff117424ULL, 0x000fe200078e00ffULL, 0x0000200008097891ULL, 0x000fe2000f8e683fULL,
0x00000002ff0d7819ULL, 0x002fe20000011609ULL, 0x00000010090a7824ULL, 0x040fe200078e00ffULL,
0x0000000909087211ULL, 0x000fc600078fe8ffULL, 0x010600060d047984ULL, 0x000e620008004800ULL,
0x00000040000f7824ULL, 0x000fe200078e020dULL, 0x000000300a137812ULL, 0x000fe400078ec0ffULL,
0x00000003080c7812ULL, 0x000fe400078ec0ffULL, 0x000000080d0a7810ULL, 0x000fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000704047984ULL, 0x002e640008004800ULL,
0x0000000404067c24ULL, 0x002fe2000f8e020fULL, 0x0ffffffc0c047812ULL, 0x000fc600078ef809ULL,
0x00005e0006067625ULL, 0x000fe200078e0011ULL, 0x0000000904157c11ULL, 0x000fc8000f8e20ffULL,
0x0000001306087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x000000080f077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e8000b901c4cULL, 0x010620060d047984ULL, 0x000ea20008004800ULL,
0x000000100d087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x0000000704047984ULL, 0x004e640008004800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20cULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000906157c11ULL, 0x000fe4000f8e20ffULL, 0x000000100f077810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a157faeULL, 0x0003e8000b901c4cULL,
0x010640060d047984ULL, 0x000ea20008004800ULL, 0x000000180d0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000704047984ULL, 0x004e640008004800ULL,
0x0000000404067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0011ULL,
0x0000001306087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000000906157c11ULL, 0x000fe4000f8e20ffULL,
0x000000180f077810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e8000b901c4cULL, 0x010660060d047984ULL, 0x000ea20008004800ULL,
0x000000200d087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x0000000704047984ULL, 0x004e640008004800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20cULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000906157c11ULL, 0x000fe4000f8e20ffULL, 0x000000200f077810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a157faeULL, 0x0003e8000b901c4cULL,
0x010680060d047984ULL, 0x000ea20008004800ULL, 0x000000280d0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000704047984ULL, 0x004e640008004800ULL,
0x0000000404067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0011ULL,
0x0000001306087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000000906157c11ULL, 0x000fe4000f8e20ffULL,
0x000000280f077810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e8000b901c4cULL, 0x0106a0060d047984ULL, 0x000ea20008004800ULL,
0x000000300d087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x0000000704047984ULL, 0x004e640008004800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20cULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000906157c11ULL, 0x000fe4000f8e20ffULL, 0x000000300f077810ULL, 0x040fe40007ffe0ffULL,
0x000000380f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e8000b901c4cULL, 0x0106c0060d047984ULL, 0x000ea20008004800ULL,
0x000000380d0a7810ULL, 0x002fc60007ffe0ffULL, 0x0000000704047984ULL, 0x004e640008004800ULL,
0x0000000404067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0011ULL,
0x0000001306087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x00000009060b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c4cULL,
0x0106e0060d047984ULL, 0x000ea80008004800ULL, 0x0000000704047984ULL, 0x004ea40008004800ULL,
0x0000000404067c24ULL, 0x004fc4000f8e020fULL, 0x000000040a0f7824ULL, 0x000fe400078e00ffULL,
0x00005e0006067625ULL, 0x000fc600078e0011ULL, 0xfffffffc0f0c7812ULL, 0x000fe400078ee20cULL,
0x0000001306067210ULL, 0x000fe40007f1e0ffULL, 0x000000090c097c11ULL, 0x002fc6000f8e20ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e6000b901c4cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x010ad400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010ad400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00000008ff057e24ULL, 0x000fc8000f8e00ffULL,
0x0000002005047824ULL, 0x002fca00078e0204ULL, 0x00000003ff067819ULL, 0x000fe40000011604ULL,
0x0000000f04047812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL,
0x0000000104067810ULL, 0x040fe20007ffe0ffULL, 0x00000020040a7824ULL, 0x040fe400078e00ffULL,
0x0000000104087824ULL, 0x040fe400078e0207ULL, 0x0000000107097824ULL, 0x040fe200078e0206ULL,
0x0000001007077810ULL, 0x000fe20007ffe0ffULL, 0x00000020040b7824ULL, 0x000fe200078e00ffULL,
0x0000001f08087812ULL, 0x000fc400078ec0ffULL, 0x0000001f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000001e00b087812ULL, 0x040fe400078ee208ULL,
0x000001e00a097812ULL, 0x000fe200078ee209ULL, 0x00000001040a7824ULL, 0x000fe200078e0207ULL,
0x0000001f06067812ULL, 0x000fe200078ec0ffULL, 0x0000000008107984ULL, 0x000e62000000cc00ULL,
0x0000002004077824ULL, 0x000fe400078e00ffULL, 0x0000001f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000000090c7984ULL, 0x000ea2000000cc00ULL, 0x000001e00b067812ULL, 0x000fc400078ee206ULL,
0x000001e0070a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001408007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff187224ULL, 0x000fc400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x0000001809007388ULL, 0x000fe8000000cc00ULL, 0x00000000060c7984ULL, 0x000e68000000cc00ULL,
0x000000000a107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c0a007388ULL, 0x0003e8000000cc00ULL, 0x0000000c06007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad000ff067f8cULL, 0x002e62000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0d7224ULL, 0x002fc400078e0007ULL,
0x0000000000067805ULL, 0x000fca0000015200ULL, 0x010ad400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010ad400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00005800ff087624ULL, 0x000fe200078e00ffULL,
0x3d80000003037820ULL, 0x010fe20000410000ULL, 0x00010b5805587811ULL, 0x000fe200078e18ffULL,
0x000000ffff567224ULL, 0x000fe200078e00ffULL, 0xffffffff65597810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00010ad805577811ULL, 0x000fe200078e28ffULL,
0x00000008ff077e24ULL, 0x000fe4000f8e00ffULL, 0x0000004008087824ULL, 0x000fc400078e00ffULL,
0x00000005565d7c11ULL, 0x000fe2000f8e40ffULL, 0x0000000000007946ULL, 0x000fe60003800000ULL,
0x0000005d6600720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x00000004ff5e7424ULL, 0x000fe200078e00ffULL, 0x000000566300720cULL, 0x000fe20003f44070ULL,
0x000000ffff6d7224ULL, 0x000fc600078e00ffULL, 0x000000015e5e7807ULL, 0x000fc40005000000ULL,
0x000000ffff187224ULL, 0x000fe200078e0006ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff5f7224ULL, 0x000fe200078e006dULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff607224ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fc4000001ff00ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x000000237f007947ULL, 0x000fea000b800000ULL, 0x00015690001c7802ULL, 0x000fc40000000f00ULL,
0x000048d000007944ULL, 0x002fea0003c00000ULL, 0x0000000160627810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000006d62197211ULL, 0x040fe200078ff0ffULL,
0x0000104000007945ULL, 0x000fe20003800000ULL, 0x0000000362617812ULL, 0x000fe400078ec0ffULL,
0x00000003191b7812ULL, 0x000fe400078ec0ffULL, 0x00000002ff19a819ULL, 0x000fca0000011619ULL,
0x00000001191a7824ULL, 0x000fe200078e0256ULL, 0x000000ff1b197207ULL, 0x000fc80005000000ULL,
0x000000011a067810ULL, 0x000fc80007ffe0ffULL, 0x000000650600720cULL, 0x000fe40003f06070ULL,
0x0000000118067812ULL, 0x000fd600078e0cffULL, 0x0000083000008947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x002fe20000011604ULL, 0x00010a8008047891ULL, 0x000fe2000f8e203fULL,
0x000000051a1b7c11ULL, 0x000fe2000f8e40ffULL, 0x00000004611d7824ULL, 0x000fe200078e00ffULL,
0x0000000404237211ULL, 0x000fe200078fe8ffULL, 0x01060006211c7984ULL, 0x000e620008004800ULL,
0x0000001b66207217ULL, 0x000fe20007800000ULL, 0x0000004000417824ULL, 0x000fe200078e0221ULL,
0x0000000323237812ULL, 0x000fe200078ec0ffULL, 0x0000000205407824ULL, 0x000fe200078e0206ULL,
0x0000000821677810ULL, 0x000fe20007ffe0ffULL, 0x0000000120207824ULL, 0x000fe200078e0a1bULL,
0xfffffffc1d1b7812ULL, 0x000fe200078ee204ULL, 0x00000100ff227424ULL, 0x000fe200078e00ffULL,
0x0000200040407811ULL, 0x000fe200078e60ffULL, 0x0000000467687824ULL, 0x000fe200078e00ffULL,
0x000000202100720cULL, 0x000fc40003f06070ULL, 0x0ffffffc23437812ULL, 0x000fe400078ef804ULL,
0x00000008411e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001043437824ULL, 0x000fe200078e0240ULL,
0x000000041c1c7984ULL, 0x002e640008004800ULL, 0x0000001c081d7224ULL, 0x002fc800078e0241ULL,
0x00005e001d1c7625ULL, 0x000fcc00078e0022ULL, 0x000000101b1c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c437faeULL, 0x0003e2000c101c4cULL,
0x000000206700720cULL, 0x000fe40003f06070ULL, 0xfffffffc68677812ULL, 0x000fe200078ee223ULL,
0x0106200621427984ULL, 0x000ea80008004800ULL, 0x0000001067677824ULL, 0x000fe200078e0240ULL,
0x00000010411c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001021437810ULL, 0x000fca0007ffe0ffULL,
0x0000000443687824ULL, 0x000fe200078e00ffULL, 0x00000004421f7984ULL, 0x004e640008004800ULL,
0x0000001f081f7224ULL, 0x002fc800078e021eULL, 0x00005e001f1e7625ULL, 0x000fcc00078e0022ULL,
0x000000101b1e7825ULL, 0x000fca00078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e677faeULL, 0x0003e2000c101c4cULL, 0x000000204300720cULL, 0x000fe40003f06070ULL,
0xfffffffc68437812ULL, 0x000fe200078ee223ULL, 0x0106400621427984ULL, 0x000ea80008004800ULL,
0x0000001043437824ULL, 0x000fe200078e0240ULL, 0x00000018411e7810ULL, 0x002fe40007ffe0ffULL,
0x0000001821677810ULL, 0x000fca0007ffe0ffULL, 0x0000000467687824ULL, 0x000fe200078e00ffULL,
0x00000004421d7984ULL, 0x004e640008004800ULL, 0x0000001d081d7224ULL, 0x002fc800078e021cULL,
0x00005e001d1c7625ULL, 0x000fcc00078e0022ULL, 0x000000101b1c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c437faeULL, 0x0003e2000c101c4cULL,
0x000000206700720cULL, 0x000fe40003f06070ULL, 0xfffffffc68677812ULL, 0x000fe200078ee223ULL,
0x0106600621427984ULL, 0x000ea80008004800ULL, 0x0000001067677824ULL, 0x000fe200078e0240ULL,
0x00000020411c7810ULL, 0x002fe40007ffe0ffULL, 0x0000002021437810ULL, 0x000fca0007ffe0ffULL,
0x0000000443687824ULL, 0x000fe200078e00ffULL, 0x00000004421f7984ULL, 0x004e640008004800ULL,
0x0000001f081f7224ULL, 0x002fc800078e021eULL, 0x00005e001f1e7625ULL, 0x000fcc00078e0022ULL,
0x000000101b1e7825ULL, 0x000fca00078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e677faeULL, 0x0003e2000c101c4cULL, 0x000000204300720cULL, 0x000fe40003f06070ULL,
0xfffffffc68437812ULL, 0x000fe200078ee223ULL, 0x0106800621427984ULL, 0x000ea80008004800ULL,
0x0000001043437824ULL, 0x000fe200078e0240ULL, 0x00000028411e7810ULL, 0x002fe40007ffe0ffULL,
0x0000002821677810ULL, 0x000fca0007ffe0ffULL, 0x0000000467687824ULL, 0x000fe200078e00ffULL,
0x00000004421d7984ULL, 0x004e640008004800ULL, 0x0000001d081d7224ULL, 0x002fc800078e021cULL,
0x00005e001d1c7625ULL, 0x000fcc00078e0022ULL, 0x000000101b1c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c437faeULL, 0x0003e2000c101c4cULL,
0x000000206700720cULL, 0x000fe40003f06070ULL, 0xfffffffc68677812ULL, 0x000fe200078ee223ULL,
0x0106a00621427984ULL, 0x000ea80008004800ULL, 0x0000001067677824ULL, 0x000fe200078e0240ULL,
0x00000030411c7810ULL, 0x002fe40007ffe0ffULL, 0x0000003021437810ULL, 0x000fca0007ffe0ffULL,
0x0000000443687824ULL, 0x000fe200078e00ffULL, 0x00000004421f7984ULL, 0x004e640008004800ULL,
0x0000001f081f7224ULL, 0x002fc800078e021eULL, 0x00005e001f1e7625ULL, 0x000fcc00078e0022ULL,
0x000000101b1e7825ULL, 0x000fca00078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e677faeULL, 0x0003e2000c101c4cULL, 0x000000204300720cULL, 0x000fe40003f06070ULL,
0xfffffffc68437812ULL, 0x000fe200078ee223ULL, 0x0106c00621427984ULL, 0x000ea80008004800ULL,
0x0000001043437824ULL, 0x000fe200078e0240ULL, 0x00000038411e7810ULL, 0x002fe40007ffe0ffULL,
0x0000003821417810ULL, 0x000fca0007ffe0ffULL, 0x0000000441687824ULL, 0x000fca00078e00ffULL,
0xfffffffc68237812ULL, 0x000fca00078ee223ULL, 0x0000001023237824ULL, 0x000fe200078e0240ULL,
0x00000004421d7984ULL, 0x004e640008004800ULL, 0x0000001d081d7224ULL, 0x002fc800078e021cULL,
0x00005e001d1c7625ULL, 0x000fcc00078e0022ULL, 0x000000101b1c7825ULL, 0x000fca00078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c437faeULL, 0x0003e2000c101c4cULL,
0x000000204100720cULL, 0x000fc60003f06070ULL, 0x0106e00621427984ULL, 0x000ea80008004800ULL,
0x00000004421f7984ULL, 0x004ea40008004800ULL, 0x0000001f081f7224ULL, 0x004fc800078e021eULL,
0x00005e001f1e7625ULL, 0x000fcc00078e0022ULL, 0x000000101b1e7825ULL, 0x000fca00078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e237faeULL, 0x0003e2000c101c4cULL,
0x0000077000007947ULL, 0x000fea0003800000ULL, 0x00000002ff217819ULL, 0x002fe20000011604ULL,
0x00010a8008047891ULL, 0x000fe2000f8e203fULL, 0x00000004041b7211ULL, 0x000fe200078fe8ffULL,
0x0000000205207824ULL, 0x000fe400078e0206ULL, 0x0106000621227984ULL, 0x000e620008004800ULL,
0x0000004000237824ULL, 0x000fe200078e0221ULL, 0x000000031b1b7812ULL, 0x000fe200078ec0ffULL,
0x00000004611f7824ULL, 0x000fe200078e00ffULL, 0x0000200020207811ULL, 0x000fe200078e60ffULL,
0x00000100ff1e7424ULL, 0x000fe200078e00ffULL, 0x0ffffffc1b417812ULL, 0x000fc400078ef804ULL,
0xfffffffc1f1f7812ULL, 0x000fe400078ee204ULL, 0x0000000823427810ULL, 0x000fe20007ffe0ffULL,
0x0000001041677824ULL, 0x000fe200078e0220ULL, 0x0000000422227984ULL, 0x002e640008004800ULL,
0x00000022081d7224ULL, 0x002fc800078e0223ULL, 0x00005e001d1c7625ULL, 0x000fcc00078e001eULL,
0x000000101f407825ULL, 0x000fe200078e001cULL, 0x00000008211c7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040677faeULL, 0x0003e8000b901c4cULL,
0x0106200621227984ULL, 0x000ea80008004800ULL, 0x00000004221d7984ULL, 0x004ea40008004800ULL,
0x0000001d081d7224ULL, 0x004fc400078e0242ULL, 0x000000041c427824ULL, 0x000fe400078e00ffULL,
0x00005e001d1c7625ULL, 0x000fc600078e001eULL, 0xfffffffc42437812ULL, 0x000fca00078ee21bULL,
0x0000001043697824ULL, 0x000fe400078e0220ULL, 0x000000101f427825ULL, 0x000fe200078e001cULL,
0x00000010211c7810ULL, 0x000fe40007ffe0ffULL, 0x00000010231d7810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042697faeULL, 0x0005e2000b901c4cULL,
0x000000041c227824ULL, 0x000fc600078e00ffULL, 0x0106400621677984ULL, 0x002e640008004800ULL,
0xfffffffc22417812ULL, 0x000fca00078ee21bULL, 0x00000010416b7824ULL, 0x000fe200078e0220ULL,
0x0000001823427810ULL, 0x004fe20007ffe0ffULL, 0x0000000467677984ULL, 0x002e640008004800ULL,
0x00000067081d7224ULL, 0x002fc800078e021dULL, 0x00005e001d1c7625ULL, 0x000fcc00078e001eULL,
0x000000101f407825ULL, 0x000fe200078e001cULL, 0x00000018211c7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000406b7faeULL, 0x0003e8000b901c4cULL,
0x0106600621227984ULL, 0x000ea80008004800ULL, 0x00000004221d7984ULL, 0x004ea40008004800ULL,
0x0000001d081d7224ULL, 0x004fc400078e0242ULL, 0x000000041c427824ULL, 0x000fe400078e00ffULL,
0x00005e001d1c7625ULL, 0x000fc600078e001eULL, 0xfffffffc42437812ULL, 0x000fca00078ee21bULL,
0x0000001043697824ULL, 0x000fe400078e0220ULL, 0x000000101f427825ULL, 0x000fe200078e001cULL,
0x00000020211c7810ULL, 0x000fe40007ffe0ffULL, 0x00000020231d7810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042697faeULL, 0x0005e2000b901c4cULL,
0x000000041c227824ULL, 0x000fc600078e00ffULL, 0x0106800621677984ULL, 0x000ee40008004800ULL,
0xfffffffc22417812ULL, 0x002fca00078ee21bULL, 0x00000010416b7824ULL, 0x000fe200078e0220ULL,
0x0000002823427810ULL, 0x004fe20007ffe0ffULL, 0x0000000467677984ULL, 0x008e640008004800ULL,
0x00000067081d7224ULL, 0x002fc800078e021dULL, 0x00005e001d1c7625ULL, 0x000fcc00078e001eULL,
0x000000101f407825ULL, 0x000fe200078e001cULL, 0x00000028211c7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000406b7faeULL, 0x0003e8000b901c4cULL,
0x0106a00621227984ULL, 0x000ea80008004800ULL, 0x00000004221d7984ULL, 0x0044e40008004800ULL,
0x0000003023227810ULL, 0x004fc40007ffe0ffULL, 0x0000003823237810ULL, 0x000fe20007ffe0ffULL,
0x0000001d081d7224ULL, 0x008fe400078e0242ULL, 0x000000041c427824ULL, 0x000fe400078e00ffULL,
0x00005e001d1c7625ULL, 0x000fc600078e001eULL, 0xfffffffc42437812ULL, 0x000fca00078ee21bULL,
0x0000001043677824ULL, 0x000fe400078e0220ULL, 0x000000101f427825ULL, 0x000fe200078e001cULL,
0x00000030211c7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042677faeULL, 0x0005e8000b901c4cULL, 0x0106c00621407984ULL, 0x002e680008004800ULL,
0x00000004401d7984ULL, 0x002e640008004800ULL, 0x0000001d081d7224ULL, 0x002fc400078e0222ULL,
0x000000041c227824ULL, 0x000fe400078e00ffULL, 0x00005e001d1c7625ULL, 0x000fc600078e001eULL,
0xfffffffc22417812ULL, 0x000fe400078ee21bULL, 0x0000003821227810ULL, 0x000fe20007ffe0ffULL,
0x000000101f1c7825ULL, 0x000fc800078e001cULL, 0x0000001041697824ULL, 0x000fe400078e0220ULL,
0x0000000422407824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c697faeULL, 0x0005e4000b901c4cULL, 0xfffffffc401b7812ULL, 0x000fe400078ee21bULL,
0x0106e00621417984ULL, 0x000e660008004800ULL, 0x000000101b1b7824ULL, 0x000fe200078e0220ULL,
0x0000000441417984ULL, 0x002e640008004800ULL, 0x0000004108237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e001eULL, 0x000000101f227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221b7faeULL, 0x0005e4000b901c4cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x00016740001c7802ULL, 0x006fc40000000f00ULL, 0x0000382000007944ULL, 0x000fea0003c00000ULL,
0x000000036100780cULL, 0x000fe20003f05270ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000031000007945ULL, 0x000fec0003800000ULL, 0x000002f000000947ULL, 0x000fea0003800000ULL,
0x00000001191b7810ULL, 0x004fe20007ffe0ffULL, 0x0000028000017945ULL, 0x000fe20003800000ULL,
0x0000001a6300720cULL, 0x000fe40003f04070ULL, 0x00000002ff1c7819ULL, 0x002fc4000001161bULL,
0x000000031b1b7812ULL, 0x000fe400078ec0ffULL, 0x000000011c1d7807ULL, 0x000fe40004000000ULL,
0x000000ff1b1b7207ULL, 0x000fe40004000000ULL, 0x00000020041e7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a1d7824ULL, 0x000fe200078e021dULL, 0x0000001a6300720cULL, 0x000fe40003f04070ULL,
0x000000031900780cULL, 0x000fc40003f85270ULL, 0x000000051d1d7c11ULL, 0x000fe4000f8e40ffULL,
0x0000000a1b1c7c10ULL, 0x000fe4000fffe0ffULL, 0x0000000604217c11ULL, 0x000fe2000f8e10ffULL,
0x000000011e1f7824ULL, 0x100fe400078e021dULL, 0x000000011d1b7824ULL, 0x100fe400078e0204ULL,
0x000068001c1d7a24ULL, 0x000fe200078e021dULL, 0x000000661f00720cULL, 0x080fe20003f66070ULL,
0x00000004ff1f7424ULL, 0x000fe200078e00ffULL, 0x000000661b00720cULL, 0x000fe20003f26070ULL,
0x000000011d1a7824ULL, 0x000fc400078e0204ULL, 0x000000011e1e7824ULL, 0x000fe400078e021dULL,
0x000066001a1a7625ULL, 0x000fc800078e001fULL, 0x000066001e1e7625ULL, 0x000fe200078e001fULL,
0x0000010000008947ULL, 0x000fea0002000000ULL, 0x000000030400780cULL, 0x000fe40003f04070ULL,
0x0000000407077810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x000e620000002700ULL, 0x000000640700720cULL, 0x000fe20003f06070ULL,
0x00000004ff1d7424ULL, 0x000fe400078e00ffULL, 0x0000000419197824ULL, 0x002fc800078e0204ULL,
0x00000002191c7824ULL, 0x000fe400078e00ffULL, 0x0000000405197824ULL, 0x000fe400078e0204ULL,
0x000064001c1c7a24ULL, 0x000fc600078e0207ULL, 0x00010a8019197811ULL, 0x000fe200078e10ffULL,
0x000060001c1c7625ULL, 0x000fca00078e001dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c197faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x106000001a217faeULL, 0x0005e8000c92184cULL,
0x106800001e217faeULL, 0x0005e4000d92184cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002004197810ULL, 0x042fe20007ffe0ffULL,
0x0000000205697824ULL, 0x004fe200078e0218ULL, 0xfffffff804677812ULL, 0x040fe200078ec0ffULL,
0x000000ffff617224ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe400078ec0ffULL,
0x00000007041b7812ULL, 0x000fc400078ec0ffULL, 0x0000000767677812ULL, 0x100fe400078ef804ULL,
0x0000000719687812ULL, 0x100fe400078ef804ULL, 0x0000200069697811ULL, 0x000fe400078e60ffULL,
0x000000081b6c7812ULL, 0x000fe400078ef804ULL, 0x00000001ff6e7819ULL, 0x000fe40000011667ULL,
0x00000001ff707819ULL, 0x000fc40000011668ULL, 0x00000004601f7824ULL, 0x100fe200078e0261ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000016e187824ULL, 0x020fe200078e0261ULL,
0x00000001616f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000467197824ULL, 0x000fc400078e00ffULL,
0x000000021f1f7824ULL, 0x000fe400078e00ffULL, 0x000000206c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc19187812ULL, 0x000fe200078ee218ULL, 0x00000004681d7824ULL, 0x000fe200078e00ffULL,
0x0000001f04197211ULL, 0x000fe400078fe0ffULL, 0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010181a7824ULL, 0x000fe400078e0269ULL, 0x000000016c197824ULL, 0x000fe200078e0219ULL,
0x0000001f041f7211ULL, 0x000fc800078fe0ffULL, 0xffffffe01c1c7812ULL, 0x000fe200078ee219ULL,
0x000000016c1f7824ULL, 0x000fe200078e021fULL, 0x000000001a18783bULL, 0x000e660000000200ULL,
0x000000101c207824ULL, 0x000fe400078e00ffULL, 0x00000001701c7824ULL, 0x000fe200078e0261ULL,
0x0000000261617810ULL, 0x000fc60007ffe0ffULL, 0x000000002020783bULL, 0x000ea20000000200ULL,
0xfffffffc1d1c7812ULL, 0x000fe400078ee21cULL, 0x000000046100780cULL, 0x000fc60003f05270ULL,
0x000000101c407824ULL, 0x000fcc00078e0269ULL, 0x000000004040783bULL, 0x000ee20000000200ULL,
0x00000018ff1c723eULL, 0x082fe400020006ffULL, 0x00000018ff1d723eULL, 0x000fe400030006ffULL,
0x00000019ff18723eULL, 0x080fe400020006ffULL, 0x00000019ff19723eULL, 0x000fc600030006ffULL,
0x0000001c203c723cULL, 0x044b6e000000183cULL, 0x00000004671d7824ULL, 0x020fe200078e00ffULL,
0x000000182038723cULL, 0x000b620000001838ULL, 0x00000040ff6a723eULL, 0x088fe400020006ffULL,
0x00000040ff6b723eULL, 0x000fc800030006ffULL, 0x0000001aff18723eULL, 0x0a0fe400020006ffULL,
0x0000001aff19723eULL, 0x000fe200030006ffULL, 0x000000016e1a7824ULL, 0x100fe200078e026fULL,
0x00000041ff40723eULL, 0x080fe200020006ffULL, 0x0000006a2028723cULL, 0x000be20000001828ULL,
0x00000041ff41723eULL, 0x000fe200030006ffULL, 0x00000001706f7824ULL, 0x000fe200078e026fULL,
0xfffffffc1d1c7812ULL, 0x000fe400078ee21aULL, 0x0000001bff1a723eULL, 0x000fc400020006ffULL,
0x0000001bff1b723eULL, 0x000fe200030006ffULL, 0x000000182034723cULL, 0x000b620000001834ULL,
0x000000101c1c7824ULL, 0x000fe200078e0269ULL, 0x00000043ff6b723eULL, 0x020fe200030006ffULL,
0x00000004686a7824ULL, 0x000fc800078e00ffULL, 0x000000206c187824ULL, 0x000fe200078e00ffULL,
0x00000040202c723cULL, 0x040be8000000182cULL, 0xffffffe018187812ULL, 0x000fe400078ee21fULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x00000042ff40723eULL, 0x0a0fe200020006ffULL,
0x0000001a2014723cULL, 0x000b620000001814ULL, 0x0000001018187824ULL, 0x000fe200078e00ffULL,
0x00000042ff41723eULL, 0x000fc400030006ffULL, 0xfffffffc6a427812ULL, 0x000fe400078ee26fULL,
0x00000043ff6a723eULL, 0x000fe200020006ffULL, 0x000000001818783bULL, 0x020ea40000000200ULL,
0x0000001042427824ULL, 0x000fe200078e0269ULL, 0x000000402030723cULL, 0x040b6a0000001830ULL,
0x000000004240783bULL, 0x020ee60000000200ULL, 0x0000006a2024723cULL, 0x000b6e0000001824ULL,
0x0000001cff20723eULL, 0x022fc400020006ffULL, 0x0000001cff21723eULL, 0x000fe400030006ffULL,
0x0000001dff1c723eULL, 0x080fe400020006ffULL, 0x0000001dff1d723eULL, 0x000fc600030006ffULL,
0x00000020183c723cULL, 0x044f70000000183cULL, 0x0000001c1838723cULL, 0x000b6e0000001838ULL,
0x0000001eff1c723eULL, 0x020fc400020006ffULL, 0x0000001eff1d723eULL, 0x000fe400030006ffULL,
0x0000001fff1e723eULL, 0x080fe400020006ffULL, 0x0000001fff1f723eULL, 0x000fc600030006ffULL,
0x0000001c1834723cULL, 0x040b6e0000001834ULL, 0x00000040ff1c723eULL, 0x0a8fe200020006ffULL,
0x0000001e1814723cULL, 0x000f620000001814ULL, 0x00000040ff1d723eULL, 0x000fe400030006ffULL,
0x00000041ff40723eULL, 0x000fc400020006ffULL, 0x00000041ff41723eULL, 0x000fc600030006ffULL,
0x0000001c1828723cULL, 0x040b6e0000001828ULL, 0x00000042ff1c723eULL, 0x0a0fe200020006ffULL,
0x00000040182c723cULL, 0x000b62000000182cULL, 0x00000042ff1d723eULL, 0x000fe400030006ffULL,
0x00000043ff42723eULL, 0x000fc400020006ffULL, 0x00000043ff43723eULL, 0x000fc600030006ffULL,
0x0000001c1830723cULL, 0x040b700000001830ULL, 0x000000421824723cULL, 0x000b620000001824ULL,
0xfffffa8000000947ULL, 0x000fce000383ffffULL, 0x000000046200780cULL, 0x000fe20003f06070ULL,
0x000000ffff607224ULL, 0x000fc400078e0062ULL, 0x000000ffff187224ULL, 0x020fd400078e0006ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe53000007947ULL, 0x000fea000383ffffULL,
0x00000002ff427819ULL, 0x000fc80000011604ULL, 0x0000006d4200720cULL, 0x040fe40003f06070ULL,
0x000000016d6d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000842407810ULL, 0x040fe40007ffe0ffULL,
0x0000006d4200720cULL, 0x000fe40004706470ULL, 0x0000005f4000720cULL, 0x000fe40003f26070ULL,
0x000000566300720cULL, 0x000fc40000703070ULL, 0x0000006d4000720cULL, 0x000fc80000f21070ULL,
0x000000566300720cULL, 0x000fc80000f24470ULL, 0x0000005c275c7208ULL, 0x000fe40000800000ULL,
0x0000004726477208ULL, 0x000fe20000800000ULL, 0x000000ffff5b8224ULL, 0x000fe200078e0025ULL,
0x0000004833487208ULL, 0x000fe20000800000ULL, 0x000000ffff5a8224ULL, 0x000fe200078e0024ULL,
0x0000004932497208ULL, 0x000fe20000800000ULL, 0x000000ffff0a8224ULL, 0x000fe200078e0031ULL,
0x0000004a2f4a7208ULL, 0x000fe20000800000ULL, 0x000000ffff098224ULL, 0x000fe200078e0030ULL,
0x0000004b2e4b7208ULL, 0x000fe20000800000ULL, 0x000000ffff0c8224ULL, 0x000fe200078e002dULL,
0x0000004c2b4c7208ULL, 0x000fe20000800000ULL, 0x000000ffff0b8224ULL, 0x000fe200078e002cULL,
0x0000004d2a4d7208ULL, 0x000fe20000800000ULL, 0x000000ffff0e8224ULL, 0x000fe200078e0029ULL,
0x0000004e174e7208ULL, 0x000fe20000800000ULL, 0x000000ffff0d8224ULL, 0x000fe200078e0028ULL,
0x0000004f164f7208ULL, 0x000fe20000800000ULL, 0x000000ffff108224ULL, 0x000fe200078e0015ULL,
0x0000005037507208ULL, 0x000fe20000800000ULL, 0x000000ffff0f8224ULL, 0x000fe200078e0014ULL,
0x0000005136517208ULL, 0x000fe20000800000ULL, 0x000000ffff128224ULL, 0x000fe200078e0035ULL,
0x000000523b527208ULL, 0x000fe20000800000ULL, 0x000000ffff118224ULL, 0x000fe200078e0034ULL,
0x000000533a537208ULL, 0x000fe20000800000ULL, 0x000000ffff448224ULL, 0x000fe200078e0039ULL,
0x000000543f547208ULL, 0x000fe20000800000ULL, 0x000000ffff138224ULL, 0x000fe200078e0038ULL,
0x000000553e557208ULL, 0x000fe20000800000ULL, 0x000000ffff468224ULL, 0x000fc400078e003dULL,
0x000000ffff458224ULL, 0x000fe200078e003cULL, 0x0000005e6d00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe14000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000058147f8cULL, 0x000e62000c80043fULL,
0x0000000345217220ULL, 0x080fe20000410000ULL, 0x0000000346207220ULL, 0x080fe20000410000ULL,
0x0000000313137220ULL, 0x080fe20000410000ULL, 0x00000003441f7220ULL, 0x080fe20000410000ULL,
0x0000000311117220ULL, 0x080fe20000410000ULL, 0x0000000312127220ULL, 0x080fe20000410000ULL,
0x000000030f1e7220ULL, 0x080fe20000410000ULL, 0x0000000310107220ULL, 0x080fe20000410000ULL,
0x000000030d1d7220ULL, 0x080fe20000410000ULL, 0x000000030e1c7220ULL, 0x080fe20000410000ULL,
0x000000030b0b7220ULL, 0x080fe20000410000ULL, 0x000000030c1b7220ULL, 0x080fe20000410000ULL,
0x0000000309097220ULL, 0x080fe20000410000ULL, 0x000000030a0a7220ULL, 0x080fe20000410000ULL,
0x000000035a1a7220ULL, 0x080fe20000410000ULL, 0x000000035b197220ULL, 0x080fe20000410000ULL,
0x0000000355327220ULL, 0x080fe20000410000ULL, 0x0000000354337220ULL, 0x080fe20000410000ULL,
0x0000000353317220ULL, 0x080fe20000410000ULL, 0x00000003522f7220ULL, 0x080fe20000410000ULL,
0x00000003512e7220ULL, 0x080fe20000410000ULL, 0x00000003502b7220ULL, 0x080fe20000410000ULL,
0x000000034f2a7220ULL, 0x080fe20000410000ULL, 0x000000ffff177224ULL, 0x002fe200078e0015ULL,
0x000000034e297220ULL, 0x080fe20000410000ULL, 0x000000034d287220ULL, 0x080fe20000410000ULL,
0x000000034c277220ULL, 0x080fe20000410000ULL, 0x000000034b267220ULL, 0x080fe20000410000ULL,
0x000000034a257220ULL, 0x080fe20000410000ULL, 0x0000000349247220ULL, 0x080fe20000410000ULL,
0x0000000348237220ULL, 0x080fe20000410000ULL, 0x0000000347227220ULL, 0x080fe20000410000ULL,
0x000000035c187220ULL, 0x000fc20000410000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x00000400580e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000150e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400580e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000404177824ULL, 0x000fe200078e00ffULL, 0x000000595600720cULL, 0x000fc80003f05270ULL,
0xfffffff0172c7812ULL, 0x000fca00078ec0ffULL, 0x00000080052c7824ULL, 0x000fca00078e022cULL,
0x010400002c0c7984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000204147824ULL, 0x000fe400078e00ffULL, 0x00000001665d7824ULL, 0x000fc600078e0a5dULL,
0x0000000614147812ULL, 0x000fc800078ec0ffULL, 0x0000000114167812ULL, 0x040fe400078efcffULL,
0x0000000814307812ULL, 0x000fe400078efcffULL, 0x0000005d1600720cULL, 0x080fe40003f26070ULL,
0x0000001014167812ULL, 0x000fe400078efcffULL, 0x0000005d3000720cULL, 0x080fe40003f06070ULL,
0x0000005d1600720cULL, 0x000fc40003fc6070ULL, 0x0000001114307812ULL, 0x040fe400078efcffULL,
0x0000001814167812ULL, 0x040fe400078efcffULL, 0x0000005d1400720cULL, 0x080fe40003f46070ULL,
0x0000005d3000720cULL, 0x080fe40003fa6070ULL, 0x0000005d1600720cULL, 0x000fe40003f66070ULL,
0x0000000914347812ULL, 0x000fc400078efcffULL, 0x0000001914307812ULL, 0x040fe400078efcffULL,
0x0000002014167812ULL, 0x000fe400078efcffULL, 0xff80000032327808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40005000000ULL, 0xff80000033337808ULL, 0x000fe40004800000ULL,
0xff80000020207808ULL, 0x000fc40004800000ULL, 0x0000005d3400720cULL, 0x080fe40003f86070ULL,
0x0000005d3000720cULL, 0x080fe40003f46070ULL, 0x0000005d1600720cULL, 0x000fe40003f26070ULL,
0x0000002114307812ULL, 0x040fe400078efcffULL, 0x0000002814167812ULL, 0x000fe400078efcffULL,
0xff80000031317808ULL, 0x000fc40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff8000002f2f7808ULL, 0x000fe40006000000ULL, 0xff8000001f1f7808ULL, 0x000fe40006000000ULL,
0x0000005d3000720cULL, 0x080fe40003f06070ULL, 0x0000005d1600720cULL, 0x000fe40003f86070ULL,
0x0000002914307812ULL, 0x000fc400078efcffULL, 0x0000003014167812ULL, 0x000fe400078efcffULL,
0xff8000002e2e7808ULL, 0x000fe40007000000ULL, 0xff80000011117808ULL, 0x000fe40007000000ULL,
0xff8000002b2b7808ULL, 0x000fe40006800000ULL, 0xff80000012127808ULL, 0x000fe40006800000ULL,
0x0000005d3000720cULL, 0x000fc40003fc6070ULL, 0x0000005d1600720cULL, 0x000fe40003fa6070ULL,
0x0000003114307812ULL, 0x040fe400078efcffULL, 0x0000003814167812ULL, 0x040fe400078efcffULL,
0x0000003914147812ULL, 0x000fe400078efcffULL, 0xff8000002a2a7808ULL, 0x000fe40005800000ULL,
0xff8000001e1e7808ULL, 0x000fc40005800000ULL, 0xff80000029297808ULL, 0x000fe40005000000ULL,
0xff80000010107808ULL, 0x000fe40005000000ULL, 0xff80000028287808ULL, 0x000fe40004800000ULL,
0xff8000001d1d7808ULL, 0x000fe40004800000ULL, 0x0000005d3000720cULL, 0x080fe40003f66070ULL,
0x0000005d1600720cULL, 0x000fc40003f46070ULL, 0x0000005d1400720cULL, 0x000fe40003f26070ULL,
0xff80000027277808ULL, 0x000fe40004000000ULL, 0xff8000001c1c7808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff8000000b0b7808ULL, 0x000fe40006000000ULL,
0xff80000025257808ULL, 0x000fc40007000000ULL, 0xff8000001b1b7808ULL, 0x000fe40007000000ULL,
0xff80000024247808ULL, 0x000fe40006800000ULL, 0xff80000009097808ULL, 0x000fe40006800000ULL,
0xff80000023237808ULL, 0x000fe40005800000ULL, 0xff8000000a0a7808ULL, 0x000fe40005800000ULL,
0xff80000022227808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff80000018187808ULL, 0x000fe40004800000ULL, 0xff80000019197808ULL, 0x000fc40004800000ULL,
0x000000210c00720bULL, 0x004fe20003f1e000ULL, 0x0000001fff387424ULL, 0x000fe200078e00ffULL,
0x000000320d00720bULL, 0x000fe20003f3e000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x0000000c21157208ULL, 0x000fe40004000000ULL, 0x0000000d320c7208ULL, 0x000fc40004800000ULL,
0x000000201500720bULL, 0x000fe40003f1e000ULL, 0x000000330c00720bULL, 0x000fe40003f3e000ULL,
0x0000001520147208ULL, 0x000fe40004000000ULL, 0x0000000c330c7208ULL, 0x000fe40004800000ULL,
0x000000131400720bULL, 0x000fe40003f1e000ULL, 0x000000310c00720bULL, 0x000fc40003f3e000ULL,
0x0000001413147208ULL, 0x000fe40004000000ULL, 0x0000000c310c7208ULL, 0x000fe40004800000ULL,
0x0000001f1400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0c00720bULL, 0x000fe40003f3e000ULL,
0x000000141f147208ULL, 0x000fe40004000000ULL, 0x0000000c2f0d7208ULL, 0x000fc40004800000ULL,
0x000000111400720bULL, 0x000fe40003f1e000ULL, 0x0000002e0d00720bULL, 0x000fe40003f3e000ULL,
0x0000001411157208ULL, 0x000fe40004000000ULL, 0x0000000d2e0c7208ULL, 0x000fe40004800000ULL,
0x000000121500720bULL, 0x000fe40003f1e000ULL, 0x0000002b0c00720bULL, 0x000fc40003f3e000ULL,
0x0000001512157208ULL, 0x000fe40004000000ULL, 0x0000000c2b0d7208ULL, 0x000fe40004800000ULL,
0x0000001e1500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0d00720bULL, 0x000fe40003f3e000ULL,
0x000000151e157208ULL, 0x000fe40004000000ULL, 0x0000000d2a0c7208ULL, 0x000fc40004800000ULL,
0x000000101500720bULL, 0x000fe40003f1e000ULL, 0x000000290c00720bULL, 0x000fe40003f3e000ULL,
0x0000001510147208ULL, 0x000fe40004000000ULL, 0x0000000c290d7208ULL, 0x000fe40004800000ULL,
0x0000001d1400720bULL, 0x000fe40003f1e000ULL, 0x000000280d00720bULL, 0x000fc40003f3e000ULL,
0x000000141d157208ULL, 0x000fe40004000000ULL, 0x0000000d280c7208ULL, 0x000fe40004800000ULL,
0x0000001c1500720bULL, 0x000fe40003f1e000ULL, 0x000000270c00720bULL, 0x000fe40003f3e000ULL,
0x000000151c147208ULL, 0x000fe40004000000ULL, 0x0000000c270d7208ULL, 0x000fc40004800000ULL,
0x0000000b1400720bULL, 0x000fe40003f1e000ULL, 0x000000260d00720bULL, 0x000fe40003f3e000ULL,
0x000000140b147208ULL, 0x000fe40004000000ULL, 0x0000000d260c7208ULL, 0x000fe40004800000ULL,
0x0000001b1400720bULL, 0x000fe40003f1e000ULL, 0x000000250c00720bULL, 0x000fc40003f3e000ULL,
0x000000141b147208ULL, 0x000fe40004000000ULL, 0x0000000c250d7208ULL, 0x000fe40004800000ULL,
0x000000091400720bULL, 0x000fe40003f1e000ULL, 0x000000240d00720bULL, 0x000fe40003f3e000ULL,
0x0000001409157208ULL, 0x000fe40004000000ULL, 0x0000000d240c7208ULL, 0x000fc40004800000ULL,
0x0000000a1500720bULL, 0x000fe40003f1e000ULL, 0x000000230c00720bULL, 0x000fe40003f3e000ULL,
0x000000150a157208ULL, 0x000fe40004000000ULL, 0x0000000c230d7208ULL, 0x000fe40004800000ULL,
0x0000001a1500720bULL, 0x000fe40003f1e000ULL, 0x000000220d00720bULL, 0x000fc40003f3e000ULL,
0x000000151a0c7208ULL, 0x000fe40004000000ULL, 0x0000000d220d7208ULL, 0x000fe40004800000ULL,
0x000000190c00720bULL, 0x000fe40003f1e000ULL, 0x000000180d00720bULL, 0x000fe40003f3e000ULL,
0x0000000c19347208ULL, 0x000fe40004000000ULL, 0x0000000d182d7208ULL, 0x000fe20004800000ULL,
0x000019027f007947ULL, 0x000fec000b800000ULL, 0x0c401f00340c7f89ULL, 0x0004e400000e0000ULL,
0x0000000c3400720bULL, 0x008fc80003f1e000ULL, 0x000000340c367208ULL, 0x000fe20004000000ULL,
0x000019127f007947ULL, 0x000fea000b800000ULL, 0x0c401f002d0c7f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL, 0x0c401f000f147f89ULL, 0x000e6800000e0000ULL,
0x0c201f0036157f89ULL, 0x000ea200000e0000ULL, 0x0000000c2d00720bULL, 0x008fc40003f1e000ULL,
0x0000000d0e00720bULL, 0x010fe40003f3e000ULL, 0x0000002d0c0c7208ULL, 0x000fe40004000000ULL,
0x0000000e0d0d7208ULL, 0x000fe40004800000ULL, 0x000000140f00720bULL, 0x002fe20003f1e000ULL,
0x0c201f000c357f89ULL, 0x000e6600000e0000ULL, 0x0000000f142d7208ULL, 0x000fe20004000000ULL,
0x0c201f000d167f89ULL, 0x000ee200000e0000ULL, 0x000000153600720bULL, 0x004fc60003f1e000ULL,
0x0c201f002d307f89ULL, 0x0004a200000e0000ULL, 0x0000003615147208ULL, 0x000fe40004000000ULL,
0x000000350c00720bULL, 0x002fe40003f3e000ULL, 0x000000160d00720bULL, 0x008fe40003f5e000ULL,
0x0000000c35157208ULL, 0x000fe40004800000ULL, 0x0000000d16167208ULL, 0x000fc60005000000ULL,
0x3fb8aa3b15347820ULL, 0x006fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000842367824ULL, 0x000fe200078e00ffULL, 0x0000a00008047891ULL, 0x000fe2000f8e583fULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010834ULL,
0x0000003200557308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL,
0x0000003300547308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14327820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b23237823ULL, 0x000fe20000010834ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010832ULL, 0x0000003100537308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1e0f7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b10107823ULL, 0x000fe20000010832ULL,
0x3fb8aa3b22227823ULL, 0x000fe20000010834ULL, 0x3fb8aa3b1d0d7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1c0e7823ULL, 0x100fe20000010832ULL, 0x0000002f00527308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1b0c7823ULL, 0x100fe20000010832ULL,
0x00000008421c7824ULL, 0x040fe200078e00ffULL, 0x00000001421b7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010832ULL, 0x0000002100457308ULL, 0x000fe20000000800ULL,
0x3c003c00ff2f7424ULL, 0x002fe200078e00ffULL, 0x3fb8aa3b19197823ULL, 0x000fe20000010832ULL,
0xfffffff81c327812ULL, 0x000fe200078ee21bULL, 0x3fb8aa3b18187823ULL, 0x000fe20000010834ULL,
0x0000000842337824ULL, 0x040fe200078e00ffULL, 0x0000000442317810ULL, 0x040fe20007ffe0ffULL,
0x0000000842347824ULL, 0x040fe200078e00ffULL, 0x0000002000467308ULL, 0x000fe20000000800ULL,
0x0000000842387824ULL, 0x040fe200078e00ffULL, 0x00000003421b7810ULL, 0x040fe20007ffe0ffULL,
0x00000008423a7824ULL, 0x000fe200078e00ffULL, 0xfffffff836357812ULL, 0x000fe200078ee231ULL,
0x0000000842317824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee21bULL,
0x0000000842397824ULL, 0x040fe200078e00ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0000000642377810ULL, 0x000fe20007ffe0ffULL, 0x00000008403b7824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fc400078ee242ULL, 0xfffffff83a377812ULL, 0x000fe400078ee237ULL,
0x0000000431317c11ULL, 0x000fe2000f8e20ffULL, 0x0000001f00447308ULL, 0x000e620000000800ULL,
0xfffffff83b407812ULL, 0x000fe400078ee240ULL, 0x0000000435357c11ULL, 0x000fe4000f8e20ffULL,
0x0000000437377c11ULL, 0x000fe4000f8e20ffULL, 0x00000004403b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000002e00517308ULL, 0x0007e20000000800ULL, 0x0000000304ff7812ULL, 0x000fc4000780c0ffULL,
0x000000302d00720bULL, 0x000fca0003f3e000ULL, 0x00000027004c7308ULL, 0x0005e20000000800ULL,
0x3c003c00ff2e7424ULL, 0x008fce00078e00ffULL, 0x00000026004b7308ULL, 0x0003e20000000800ULL,
0x000000535227723eULL, 0x004fce00000000ffULL, 0x00000025004a7308ULL, 0x0004e20000000800ULL,
0x000000134426723eULL, 0x002fce00000000ffULL, 0x0000002400497308ULL, 0x0003e20000000800ULL,
0x000000555425723eULL, 0x004fce00000000ffULL, 0x0000002b00507308ULL, 0x000ea20000000800ULL,
0x000000454624723eULL, 0x002fe400000000ffULL, 0x0000004b4a1f723eULL, 0x008fca00000000ffULL,
0x0000002a004f7308ULL, 0x000ff00000000800ULL, 0x00000029004e7308ULL, 0x000fe20000000800ULL,
0x000000515021723eULL, 0x004fce00000000ffULL, 0x00000028004d7308ULL, 0x0002b00000000800ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x0000002e2428723cULL, 0x002f6e00000018ffULL,
0x0000001200127308ULL, 0x000e620000000800ULL, 0x0000004d4c1d723eULL, 0x004fce00000000ffULL,
0x0000000f000f7308ULL, 0x000ff00000000800ULL, 0x0000001000107308ULL, 0x000ea20000000800ULL,
0x000000111220723eULL, 0x002fce00000000ffULL, 0x0000002300487308ULL, 0x0003f00000000800ULL,
0x0000002200477308ULL, 0x0005e20000000800ULL, 0x0000004f4e23723eULL, 0x002fce00000000ffULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x0000000f1022723eULL, 0x004fce00000000ffULL,
0x0000002e2028723cULL, 0x020f620000001828ULL, 0x0000000e000e7308ULL, 0x000e700000000800ULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000000c000c7308ULL, 0x000ea20000000800ULL,
0x0000000d0e1c723eULL, 0x002fce00000000ffULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x0000000b0c1e723eULL, 0x004fce00000000ffULL, 0x0000000a000a7308ULL, 0x000e620000000800ULL,
0x0000002e1c28723cULL, 0x020f6e0000001828ULL, 0x0000001a005a7308ULL, 0x0005f00000000800ULL,
0x00000019005b7308ULL, 0x0007220000000800ULL, 0x00000002421a7810ULL, 0x004fc80007ffe0ffULL,
0xfffffff833337812ULL, 0x000fc600078ee21aULL, 0x00000018005c7308ULL, 0x0002a20000000800ULL,
0x0000000542197810ULL, 0x008fe40007ffe0ffULL, 0x0000000433337c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff838367812ULL, 0x000fe400078ee219ULL, 0x000000494819723eULL, 0x000fe400000000ffULL,
0x000000090a18723eULL, 0x002fe400000000ffULL, 0x0000005a5b1a723eULL, 0x010fc400000000ffULL,
0xffffffff42387810ULL, 0x000fe40007ffe0ffULL, 0x000000475c1b723eULL, 0x004fe400000000ffULL,
0xfffffff839387812ULL, 0x000fc800078ee238ULL, 0x0000000438397c11ULL, 0x000fe2000f8e20ffULL,
0x0000002e1828723cULL, 0x020b6e0000001828ULL, 0x0000000c172e7812ULL, 0x020fe400078ec0ffULL,
0x0000000432177c11ULL, 0x000fc4000f8e20ffULL, 0x00000004362f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000131317824ULL, 0x000fe400078e022eULL, 0x000000012e337824ULL, 0x040fe400078e0233ULL,
0x000000012e357824ULL, 0x040fe200078e0235ULL, 0x0000002431007388ULL, 0x0003e20000000800ULL,
0x000000012e2f7824ULL, 0x000fe400078e022fULL, 0x00000004342b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000012e297824ULL, 0x000fe200078e0217ULL, 0x0000002d30177208ULL, 0x000fe20004800000ULL,
0x000000012e377824ULL, 0x000fc400078e0237ULL, 0x000000012e2b7824ULL, 0x040fe200078e022bULL,
0x0000002629007388ULL, 0x0005e20000000800ULL, 0x000000012e397824ULL, 0x040fe400078e0239ULL,
0x000000012e2e7824ULL, 0x000fe200078e023bULL, 0x0000002033007388ULL, 0x0005e20000000800ULL,
0x000000ffff307224ULL, 0x000fe400078e0028ULL, 0x000000ffff317224ULL, 0x002fe200078e002aULL,
0x000000222b007388ULL, 0x0005e80000000800ULL, 0x0000001c35007388ULL, 0x0005e80000000800ULL,
0x0000001e2f007388ULL, 0x0005e80000000800ULL, 0x0000001837007388ULL, 0x0005e80000000800ULL,
0x0000001a39007388ULL, 0x0005e80000000800ULL, 0x000000252e007388ULL, 0x0005e80000000800ULL,
0x0004002729007388ULL, 0x0005e80000000800ULL, 0x0004002133007388ULL, 0x0005e80000000800ULL,
0x000400232b007388ULL, 0x0005e80000000800ULL, 0x0004001d35007388ULL, 0x0005e80000000800ULL,
0x0004001f2f007388ULL, 0x0005e80000000800ULL, 0x0004001937007388ULL, 0x0005e80000000800ULL,
0x0004001b39007388ULL, 0x0005e80000000800ULL, 0x010000142c008388ULL, 0x0005e80000000c00ULL,
0x010200302c008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000057ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080057ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100057ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000156567810ULL, 0x000fe20007ffe0ffULL, 0x0000180057ff7f8cULL, 0x0003e6000c80043fULL,
0x000000655600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffc67000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff217807ULL, 0x008fe40004000000ULL, 0x00018e7000207802ULL, 0x000fc40000000f00ULL,
0x0000109000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0025ULL,
0xfffea63000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x000fe40004800000ULL,
0x00018ec000207802ULL, 0x000fc40000000f00ULL, 0x0000104000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0025ULL, 0xfffea67000007947ULL, 0x000fea000383ffffULL,
0x000000ffff277224ULL, 0x000fe200078e000fULL, 0x00018f2000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fc400078e001aULL, 0x00000fa000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0026ULL, 0xfffea71000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00018f8000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e000fULL, 0x00000f4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0026ULL, 0xfffea81000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0019ULL, 0x00018fe000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e001aULL, 0x00000ee000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0026ULL, 0xfffea9e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff277224ULL, 0x002fe200078e0018ULL, 0x0001904000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fc400078e0019ULL, 0x00000e8000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0026ULL, 0xfffea9b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000190a000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x00000e2000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0026ULL, 0xfffec80000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001910000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x00000dc000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0026ULL, 0xfffec7c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x004fe40004000000ULL, 0x0001915000207802ULL, 0x000fc40000000f00ULL,
0x00000db000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0025ULL,
0xfffeea3000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x000fe40004800000ULL,
0x000191a000207802ULL, 0x000fc40000000f00ULL, 0x00000d6000007944ULL, 0x008fea0003c00000ULL,
0xfffeea8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x000191f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x00000cd000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0026ULL,
0xfffeeb1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x0001925000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x00000c7000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0026ULL,
0xfffeec0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000192b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x00000c1000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0026ULL,
0xfffeedc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001931000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x00000bb000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0026ULL,
0xfffeed8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001937000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x00000b5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0026ULL,
0xffff09e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000193d000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x00000af000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0026ULL,
0xffff09a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x004fe40004000000ULL,
0x0001942000207802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0025ULL, 0xffff2af000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x000fe40004800000ULL, 0x0001947000207802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x008fea0003c00000ULL, 0xffff2b4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x000194c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x00000a0000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0026ULL, 0xffff2bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0001952000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x000009a000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0026ULL, 0xffff2cc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001958000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x0000094000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0026ULL, 0xffff2e8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000195e000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x000008e000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0026ULL, 0xffff2e4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001964000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x0000088000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0026ULL, 0xffff4aa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000196a000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x0000082000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0026ULL, 0xffff4a6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x004fe40004000000ULL, 0x000196f000207802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0025ULL,
0xffff6bb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x000fe40004800000ULL,
0x0001974000207802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x008fea0003c00000ULL,
0xffff6c0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x0001979000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x0000073000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0026ULL,
0xffff6c9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x000197f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x000006d000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0026ULL,
0xffff6d8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001985000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x0000067000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0026ULL,
0xffff6f4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000198b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x0000061000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0026ULL,
0xffff6f0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001991000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x000005b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0026ULL,
0xffff8b6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001997000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x0000055000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0026ULL,
0xffff8b2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x000199c000207802ULL, 0x000fc40000000f00ULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0026ULL, 0xffff960000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x00019a1000207802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0026ULL,
0xffff96f000007947ULL, 0x000fea000383ffffULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x00019a60000c7802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0030ULL, 0xffffe6c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x006fe200078e002dULL, 0x00019ac0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x000000302d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e000eULL,
0x00019b20000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x0000002d30157208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000300e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e000fULL,
0x00019b80000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x0000000e30377208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000300f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0036ULL,
0x00019be0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000000f302d7208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000303600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0015ULL,
0x00019c40000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000003630147208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000301500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0037ULL,
0x00019ca0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000001530157208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000303700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e002dULL,
0x00019d00000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000003730167208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffe59000007947ULL, 0x000fea000383ffffULL, 0x018000000c007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000c00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0cff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000c037812ULL, 0x000fd600078ec0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000c00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe618004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003900007348ULL, 0x000fe80003800000ULL,
0x0c00003534307389ULL, 0x0002a200000e0038ULL, 0xfffe61400c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff217424ULL, 0x000fe200078e00ffULL, 0x0000000e00007348ULL, 0x000fe80003800000ULL,
0x0000002726267389ULL, 0x0002a200000e000dULL, 0xfffe610020007950ULL, 0x000fea0003c3ffffULL,
0x000000012100780cULL, 0x000fe20003f25070ULL, 0x0000001400007348ULL, 0x000fd80003800000ULL,
0x0000000000217806ULL, 0x000fc800048e0100ULL, 0x0000001421257212ULL, 0x000fe200078ec0ffULL,
0x00000000ff217424ULL, 0x000fc800078e00ffULL, 0xfffe60a020007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000000200007348ULL, 0x000fe80003800000ULL,
0xfffe60701c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x0000000000000603ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000760ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a00ULL, 0x00000000000002f0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cf0ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd4ULL, 0x0000000000000c3cULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001a10ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001a20ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001ad0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001ad4ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001d00ULL, 0x000000000001a080ULL, 0x7900001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001bd80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001bdd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001c150ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001ad0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001a2b0ULL, 0x000000000001a2b0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001bd80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001c150ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_e4m3_pagedKV_64_nqpkv_1_m_1_sm_89_cubin_len = 115248;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
