/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_e4m3_pagedKV_64_nqpkv_1_m_1_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b048ULL, 0x000000000001acc8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL, 0x326a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45346aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x5f24000000000000ULL,
0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL, 0x5f6e725f7063725fULL,
0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL, 0x656e72656b2e7478ULL,
0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x72656b240061686dULL,
0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL, 0x656d6172665f6775ULL,
0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL, 0x72665f6775626564ULL,
0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x0000000061686d5fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000036eULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000003b5ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000403ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000448ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000004a3ULL, 0x00000000000192b0ULL, 0x0000000000000250ULL, 0x0004000300000519ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000019500ULL, 0x000d000300000549ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000192b000000000ULL, 0x0000700400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL, 0x000192b000000000ULL,
0x0000025000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000001600082f04ULL, 0x0008230400000072ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL, 0x000c17040021f000ULL,
0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL, 0x000c17040061f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x00c82804ffffffffULL, 0x00000100000000e0ULL, 0x0000331000000790ULL,
0x0000343000003370ULL, 0x0000382000003570ULL, 0x0000541000003830ULL, 0x0000733000005420ULL,
0x00007450000073a0ULL, 0x0000775000007580ULL, 0x0000918000007760ULL, 0x0000afc000009190ULL,
0x0000b0e00000b030ULL, 0x0000b3e00000b210ULL, 0x0000ce100000b3f0ULL, 0x0000ec500000ce20ULL,
0x0000ed700000ecc0ULL, 0x0000f0700000eea0ULL, 0x00010aa00000f080ULL, 0x000114a000010ab0ULL,
0x00011bf0000114b0ULL, 0x0001434000011f30ULL, 0x00016fd000014d40ULL, 0x00018690000184f0ULL,
0x0001880000018750ULL, 0x00018a9000018a50ULL, 0x00018d5000018b10ULL, 0x0000021007d03904ULL,
0x00018ad0000000ffULL, 0x000002f000040100ULL, 0x00018ad800000008ULL, 0x00000400003f0100ULL,
0x00018b5800000008ULL, 0x00000520003f0100ULL, 0x00018b7800000002ULL, 0x00000610003f0100ULL,
0x00018b88000000ffULL, 0x000008f000040100ULL, 0x00018ad0000000ffULL, 0x00000b6000060107ULL,
0x00018b580000005bULL, 0x00000bb000060101ULL, 0x00018b88000000ffULL, 0x00000be000060101ULL,
0x00018b88000000ffULL, 0x00000d5000060109ULL, 0x00018b88000000ffULL, 0x000017c000060109ULL,
0x00018b88000000ffULL, 0x000017f000060101ULL, 0x00018b88000000ffULL, 0x0000196000060109ULL,
0x00018b88000000ffULL, 0x00001ac000060109ULL, 0x00018b78000000ffULL, 0x00001b0000060107ULL,
0x00018b78000000ffULL, 0x00001b8000060101ULL, 0x00018b88000000ffULL, 0x00001da000060101ULL,
0x00018b78000000ffULL, 0x00001f1000060109ULL, 0x00018b78000000ffULL, 0x00001f4000060109ULL,
0x00018b88000000ffULL, 0x000020b000060109ULL, 0x00018b88000000ffULL, 0x00002b4000060109ULL,
0x00018b88000000ffULL, 0x00002b7000060101ULL, 0x00018b88000000ffULL, 0x00002ce000060109ULL,
0x00018b88000000ffULL, 0x0000305000060109ULL, 0x00018b80000000ffULL, 0x0000309000060107ULL,
0x00018b80000000ffULL, 0x000030b000060101ULL, 0x00018ad80000005bULL, 0x000030e000060101ULL,
0x00018ad80000005bULL, 0x0000325000060109ULL, 0x00018ad80000005bULL, 0x000041b000060109ULL,
0x00018b88000000ffULL, 0x0000427000060101ULL, 0x00018b80000000ffULL, 0x000043e000060109ULL,
0x00018b80000000ffULL, 0x0000441000060109ULL, 0x00018b88000000ffULL, 0x0000458000060109ULL,
0x00018b88000000ffULL, 0x00004fe000060109ULL, 0x00018b88000000ffULL, 0x0000501000060101ULL,
0x00018b88000000ffULL, 0x0000518000060109ULL, 0x00018b88000000ffULL, 0x0000537000060109ULL,
0x00000000000000ffULL, 0x000053d000090107ULL, 0x00018b78000000ffULL, 0x00005cc000060101ULL,
0x00018b88000000ffULL, 0x00005d2000060101ULL, 0x00018b58000000ffULL, 0x00005df000060101ULL,
0x00018b78000000ffULL, 0x00005f6000060109ULL, 0x00018b78000000ffULL, 0x00005f9000060109ULL,
0x00018b88000000ffULL, 0x0000610000060109ULL, 0x00018b88000000ffULL, 0x00006b9000060109ULL,
0x00018b88000000ffULL, 0x00006bc000060101ULL, 0x00018b88000000ffULL, 0x00006d3000060109ULL,
0x00018b88000000ffULL, 0x0000707000060109ULL, 0x00000000000000ffULL, 0x000070a0000a0107ULL,
0x00018b80000000ffULL, 0x000070e000060101ULL, 0x00018af80000005bULL, 0x0000711000060101ULL,
0x00018af80000005bULL, 0x0000728000060109ULL, 0x00018af80000005bULL, 0x00007f7000060109ULL,
0x00018b88000000ffULL, 0x0000804000060101ULL, 0x00018b80000000ffULL, 0x000081b000060109ULL,
0x00018b80000000ffULL, 0x000081e000060109ULL, 0x00018b88000000ffULL, 0x0000835000060109ULL,
0x00018b88000000ffULL, 0x00008db000060109ULL, 0x00018b88000000ffULL, 0x00008de000060101ULL,
0x00018b88000000ffULL, 0x00008f5000060109ULL, 0x00018b88000000ffULL, 0x0000911000060109ULL,
0x00000000000000ffULL, 0x0000914000090107ULL, 0x00018b78000000ffULL, 0x0000996000060101ULL,
0x00018b88000000ffULL, 0x000099b000060101ULL, 0x00018b60000000ffULL, 0x00009a8000060101ULL,
0x00018b78000000ffULL, 0x00009bf000060109ULL, 0x00018b78000000ffULL, 0x00009c2000060109ULL,
0x00018b88000000ffULL, 0x00009d9000060109ULL, 0x00018b88000000ffULL, 0x0000a82000060109ULL,
0x00018b88000000ffULL, 0x0000a85000060101ULL, 0x00018b88000000ffULL, 0x0000a9c000060109ULL,
0x00018b88000000ffULL, 0x0000ad0000060109ULL, 0x00000000000000ffULL, 0x0000ad30000a0107ULL,
0x00018b80000000ffULL, 0x0000ad7000060101ULL, 0x00018b180000005bULL, 0x0000ada000060101ULL,
0x00018b180000005bULL, 0x0000af1000060109ULL, 0x00018b180000005bULL, 0x0000bc0000060109ULL,
0x00018b88000000ffULL, 0x0000bcd000060101ULL, 0x00018b80000000ffULL, 0x0000be4000060109ULL,
0x00018b80000000ffULL, 0x0000be7000060109ULL, 0x00018b88000000ffULL, 0x0000bfe000060109ULL,
0x00018b88000000ffULL, 0x0000ca4000060109ULL, 0x00018b88000000ffULL, 0x0000ca7000060101ULL,
0x00018b88000000ffULL, 0x0000cbe000060109ULL, 0x00018b88000000ffULL, 0x0000cda000060109ULL,
0x00000000000000ffULL, 0x0000cdd000090107ULL, 0x00018b78000000ffULL, 0x0000d5f000060101ULL,
0x00018b88000000ffULL, 0x0000d64000060101ULL, 0x00018b68000000ffULL, 0x0000d71000060101ULL,
0x00018b78000000ffULL, 0x0000d88000060109ULL, 0x00018b78000000ffULL, 0x0000d8b000060109ULL,
0x00018b88000000ffULL, 0x0000da2000060109ULL, 0x00018b88000000ffULL, 0x0000e4b000060109ULL,
0x00018b88000000ffULL, 0x0000e4e000060101ULL, 0x00018b88000000ffULL, 0x0000e65000060109ULL,
0x00018b88000000ffULL, 0x0000e99000060109ULL, 0x00000000000000ffULL, 0x0000e9c0000a0107ULL,
0x00018b80000000ffULL, 0x0000ea0000060101ULL, 0x00018b380000005bULL, 0x0000ea3000060101ULL,
0x00018b380000005bULL, 0x0000eba000060109ULL, 0x00018b380000005bULL, 0x0000f89000060109ULL,
0x00018b88000000ffULL, 0x0000f96000060101ULL, 0x00018b80000000ffULL, 0x0000fad000060109ULL,
0x00018b80000000ffULL, 0x0000fb0000060109ULL, 0x00018b88000000ffULL, 0x0000fc7000060109ULL,
0x00018b88000000ffULL, 0x000106d000060109ULL, 0x00018b88000000ffULL, 0x0001070000060101ULL,
0x00018b88000000ffULL, 0x0001087000060109ULL, 0x00018b88000000ffULL, 0x00010a3000060109ULL,
0x00000000000000ffULL, 0x00010a6000090107ULL, 0x00018b78000000ffULL, 0x0001128000060101ULL,
0x00018b88000000ffULL, 0x000112c000060101ULL, 0x00018b70000000ffULL, 0x00011e7000060101ULL,
0x00018ad0000000ffULL, 0x0001437000060101ULL, 0x00018ad0000000ffULL, 0x000144e000060109ULL,
0x00018ad0000000ffULL, 0x0001483000060109ULL, 0x00018ad0000000ffULL, 0x0001486000060101ULL,
0x00018ad0000000ffULL, 0x000149d000060109ULL, 0x00018ad0000000ffULL, 0x00017c4000060109ULL,
0x00018b5800000048ULL, 0x00017e20003f0101ULL, 0x00018b5800000048ULL, 0x00017f90003f0109ULL,
0x00018b5800000048ULL, 0x00019250003f0109ULL, 0x00018ad800000000ULL, 0x00019260003f0101ULL,
0x00018ae000000000ULL, 0x00019270003f0101ULL, 0x00018ae800000000ULL, 0x00019280003f0101ULL,
0x00018af000000000ULL, 0x00053803003f0101ULL, 0x00011ca000101c04ULL, 0x00014ae000014a00ULL,
0x000c0504000192a0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0068190300000000ULL,
0x0000001700080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL, 0x0000001600000002ULL,
0x00000000000192b0ULL, 0x0000000000000044ULL, 0x0000001600000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000018c00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008800ff067b82ULL, 0x000ee20000000a00ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x00000000005f7919ULL, 0x000f220000002100ULL, 0x0000000000137919ULL, 0x000ee20000002600ULL,
0x0000000000127919ULL, 0x000ee20000002700ULL, 0x0000000404007c24ULL, 0x004fe2000f8e0203ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000000400027c24ULL, 0x110fe2000f8e025fULL, 0x00000005ff5f7819ULL, 0x000fe2000001165fULL,
0x00001fff04007589ULL, 0x000fe600000e0000ULL, 0x0000007f0200780cULL, 0x000fc40003f64070ULL,
0x00001fff5f5f7589ULL, 0x000ea200000e0000ULL, 0x000000ff0200720cULL, 0x040fe40003f45270ULL,
0x0000000f0200780cULL, 0x040fe40003f04070ULL, 0x000000030200780cULL, 0x040fe40003fa4070ULL,
0x000000010200780cULL, 0x000fc80003f84070ULL, 0x000000000008b919ULL, 0x000f220000008800ULL,
0x000004000005b802ULL, 0x000fe20000000f00ULL, 0xff317217ff09b424ULL, 0x000fc600078e00ffULL,
0x00000654080bb816ULL, 0x012fe20000000005ULL, 0x0000000400057824ULL, 0x004fc800078e025fULL,
0x000000040204b824ULL, 0x000fe200078e020bULL, 0x0000000000242947ULL, 0x008fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x018ad006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x018ad804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000402087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b5804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018400090400b388ULL, 0x0003e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b7804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x018b8806043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000000205057824ULL, 0x000fe200078e00ffULL, 0x0000000204067899ULL, 0x000fe2000800063fULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0x00000001050c7836ULL, 0x000fe20000000000ULL, 0x0000000405047848ULL, 0x002fe20007fe0000ULL,
0x0000000105087824ULL, 0x040fe200078e0203ULL, 0x000001f00e0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000612027c24ULL, 0x040fe2000f8e0213ULL, 0x0000040000067882ULL, 0x000fe20000000000ULL,
0x00000020050d7824ULL, 0x000fe200078e00ffULL, 0x00000002125d7819ULL, 0x000fe200000006ffULL,
0x0000000104097824ULL, 0x000fc400078e0a05ULL, 0x0000000405057c24ULL, 0x100fe4000f8e0202ULL,
0x000000040c0b7c24ULL, 0x040fe2000f8e0202ULL, 0xffffffe00d027812ULL, 0x000fe200078ee208ULL,
0x0000020005047825ULL, 0x100fe200078e0006ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000002000b067825ULL, 0x000fe200078e0006ULL, 0x000000ff0900720cULL, 0x040fe20003f03070ULL,
0x0000065405067896ULL, 0x004fe20008000006ULL, 0x000000010900780cULL, 0x000fe20003f23070ULL,
0x000000010c0d7824ULL, 0x040fe200078e0203ULL, 0x0000000f04087210ULL, 0x000fe20007f5e0ffULL,
0x000000200c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000f06067210ULL, 0x000fe20007f7e0ffULL,
0x00018ad006057890ULL, 0x000fc4000fffe03fULL, 0x00000006020f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff097224ULL, 0x000fe200010e0605ULL, 0xffffffe00c0d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff077224ULL, 0x000fe200018e0607ULL, 0x00008e00ff0a7b82ULL, 0x000e640000000a00ULL,
0x000000060d117c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x000fe8000c101c4eULL, 0x0000000006117faeULL, 0x0005e2000c901c4eULL,
0x00009600ff0c7b82ULL, 0x000ee20000000a00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200405ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a85ULL,
0x000000045d047825ULL, 0x002fe200078e000aULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000000e04047981ULL, 0x000f22000c1e1900ULL, 0x000000045d067825ULL, 0x00cfcc00078e000cULL,
0x0000000e06067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fe40003f05270ULL,
0x00000000040d72caULL, 0x010fe400000e0000ULL, 0x00000008ff5c7819ULL, 0x004fd60000011606ULL,
0x0000003f0d077890ULL, 0x000fe4000fffe03fULL, 0x000000ff0d057890ULL, 0x000fe4000fffe03fULL,
0x000000063f077899ULL, 0x000fe40008011607ULL, 0x000000083f107899ULL, 0x000fe20008011605ULL,
0x0000011000b08947ULL, 0x000ff60003800000ULL, 0x000000205f007824ULL, 0x040fe400078e0203ULL,
0x000000085f5b7824ULL, 0x000fc600078e00ffULL, 0x000000030000780cULL, 0x040fe40003f44070ULL,
0x0000001f0000780cULL, 0x000fd60003f04070ULL, 0x00009000ff09ab82ULL, 0x000e620000000800ULL,
0x000000041206a824ULL, 0x000fe200078e0200ULL, 0x0000000d00008c0cULL, 0x000fe4000bf26070ULL,
0x00000007ff00ac0cULL, 0x000fe2000bf65270ULL, 0x000000020606a824ULL, 0x000fe200078e00ffULL,
0x00000006000bac11ULL, 0x000fe4000f8e10ffULL, 0x00009400ff078b82ULL, 0x000eb00000000800ULL,
0x00008c00ff04ab82ULL, 0x000ef00000000a00ULL, 0x00009200ff028b82ULL, 0x000f220000000a00ULL,
0x000000090609a224ULL, 0x002fc400078e0209ULL, 0x00000004ff067424ULL, 0x000fe400078e00ffULL,
0x000000075d078224ULL, 0x004fe400078e0200ULL, 0x000000040904a825ULL, 0x008fe200078e0004ULL,
0x0000000600098c11ULL, 0x000fc6000f8e10ffULL, 0x0000000407028825ULL, 0x010fca00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000002098faeULL, 0x0003e2000c92184eULL,
0x018b58065bff79a7ULL, 0x0005e60008500006ULL, 0x18ac0000040bafaeULL, 0x0007e8000992184eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff067424ULL, 0x004fe200078e00ffULL,
0x000080000000791aULL, 0x000fca0000000000ULL, 0x018b8806ff0679a7ULL, 0x000ea40008500006ULL,
0x000000ffff087224ULL, 0x004fe200078e0007ULL, 0x0000000000027805ULL, 0x002fc60000015200ULL,
0x018b8808ff0075a7ULL, 0x000e640008000146ULL, 0x00000000005c0947ULL, 0x00afea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x018b8808ff0075a7ULL, 0x000e640008000146ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001ff0500788cULL, 0x000fe2000bf04070ULL,
0x0000840000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fc6000800063fULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000400540947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0x00008a00ff067b82ULL, 0x000ea20000000a00ULL,
0x0001400006057890ULL, 0x000fe2000fffe03fULL, 0x00000004ff087819ULL, 0x002fe40000011611ULL,
0x00000004110f7819ULL, 0x000fc600000006ffULL, 0x000000015b047824ULL, 0x000fe200078e0208ULL,
0x000000f00f0f7812ULL, 0x000fc600078ec0ffULL, 0x00000040130b7824ULL, 0x000fe200078e0204ULL,
0x0000000604097c11ULL, 0x040fe2000f8e10ffULL, 0x0000000104057824ULL, 0x000fc800078e0211ULL,
0x018a000009007984ULL, 0x000e640000000800ULL, 0x00000006000a7c11ULL, 0x002fe4000f8e10ffULL,
0x0000000d5b007c48ULL, 0x000fc6000ffe0000ULL, 0x018ac0000a027984ULL, 0x0002e40000000800ULL,
0x0000000100007824ULL, 0x000fca00078e0a5bULL, 0x000000000800720cULL, 0x000fe20003f06070ULL,
0x00000010040a7824ULL, 0x002fe400078e00ffULL, 0x0000000402037c24ULL, 0x008fc8000f8e020bULL,
0x0000010003027825ULL, 0x004fc600078e0006ULL, 0x0000000f02047210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a027812ULL, 0x000fe200078ee205ULL, 0x000000020b0a7836ULL, 0x000fe40000000000ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x00000005020d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c101c4eULL,
0x018a080009027984ULL, 0x000ea40000000800ULL, 0x00000006020e7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000208027836ULL, 0x000fc80000000000ULL, 0x018ac0000e037984ULL, 0x000ea20000000800ULL,
0x000000000200720cULL, 0x000fe20003f06070ULL, 0x0000000403037c24ULL, 0x004fe4000f8e020aULL,
0x000000015b0a7824ULL, 0x000fe400078e0202ULL, 0x0000010003027825ULL, 0x000fc800078e0006ULL,
0x000000010a0c7824ULL, 0x040fe200078e0211ULL, 0x0000000f02047210ULL, 0x002fe20007f3e0ffULL,
0x000000100a057824ULL, 0x000fe400078e00ffULL, 0x000000040b0a7836ULL, 0x000fe40000000000ULL,
0x000000060b0b7836ULL, 0x000fe20000000000ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fc600008e0603ULL, 0x000000050c0d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c101c4eULL,
0x018a100009027984ULL, 0x000ea40000000800ULL, 0x00000006020e7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000408027836ULL, 0x000fe40000000000ULL, 0x0000000608087836ULL, 0x000fe40000000000ULL,
0x018ac0000e037984ULL, 0x000ea20000000800ULL, 0x000000000200720cULL, 0x000fe20003f06070ULL,
0x0000000403037c24ULL, 0x004fc4000f8e020aULL, 0x000000015b0a7824ULL, 0x000fe400078e0202ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0x000000110a0c7210ULL, 0x000fe20007ffe0ffULL,
0x000000100a057824ULL, 0x002fe200078e00ffULL, 0x0000000f02047210ULL, 0x000fe20007f3e0ffULL,
0x000000015b0a7824ULL, 0x000fc600078e0208ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fc600008e0603ULL, 0x000000050c0d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000c101c4eULL,
0x000000000800720cULL, 0x000fe20003f06070ULL, 0x000000010a007824ULL, 0x040fe400078e0211ULL,
0x018a180009097984ULL, 0x000ea20000000800ULL, 0x000000100a057824ULL, 0x002fca00078e00ffULL,
0xfffffff005007812ULL, 0x000fc800078ee200ULL, 0x0000000500057c11ULL, 0x000fe4000f8e20ffULL,
0x00000006090c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000e640000000800ULL,
0x0000000402037c24ULL, 0x002fc8000f8e020bULL, 0x0000010003027825ULL, 0x000fc600078e0006ULL,
0x0000000f02027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c4eULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0x00008a00ff087b82ULL, 0x000ea20000000a00ULL, 0x0001400006057890ULL, 0x000fe2000fffe03fULL,
0x0000005b0f007211ULL, 0x042fe200078fe0ffULL, 0x000000100f047824ULL, 0x000fc600078e00ffULL,
0x00000006000a7c11ULL, 0x000fe2000f8e10ffULL, 0x00000040130b7824ULL, 0x000fe200078e0200ULL,
0x000000f004117812ULL, 0x000fe200078ec0ffULL, 0x0000000100057824ULL, 0x040fe400078e020fULL,
0x018a00000a027984ULL, 0x000e620000000800ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x0000000602067c11ULL, 0x002fca000f8e10ffULL, 0x018ac00006027984ULL, 0x0002e40000000800ULL,
0x0000000200067836ULL, 0x002fc80000000000ULL, 0x0000000106077824ULL, 0x040fe400078e020fULL,
0x00000010060e7824ULL, 0x000fe400078e00ffULL, 0x0000000402037c24ULL, 0x008fc8000f8e020bULL,
0x0000010003027825ULL, 0x004fc600078e0008ULL, 0x0000001102047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00c027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x00000005020d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000020b037810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000b901c4eULL,
0x018a08000a027984ULL, 0x000ea20000000800ULL, 0x0000000400047836ULL, 0x002fe40000000000ULL,
0x0000000600007836ULL, 0x000fe40000000000ULL, 0x0000000104057824ULL, 0x000fe200078e020fULL,
0x00000006020c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000e640000000800ULL,
0x0000000402037c24ULL, 0x002fc8000f8e0203ULL, 0x0000010003027825ULL, 0x000fc600078e0008ULL,
0x0000001102067210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00e027812ULL, 0x000fe200078ee207ULL,
0x00000010040e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200000e0603ULL,
0x00000005020d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000040b037836ULL, 0x000fe40000000000ULL,
0x000000060b0b7836ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000b901c4eULL, 0x018a10000a027984ULL, 0x000ea20000000800ULL,
0x0000000100067824ULL, 0x002fe200078e020fULL, 0x00000006020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000001102047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x0000000502077c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000b901c4eULL, 0x018a18000a0a7984ULL, 0x000ea40000000800ULL,
0x000000060a0c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000ea40000000800ULL,
0x0000000402037c24ULL, 0x004fc8000f8e020bULL, 0x0000010003027825ULL, 0x000fc800078e0008ULL,
0x0000001000097824ULL, 0x000fe200078e00ffULL, 0x0000001102027210ULL, 0x000fc80007f1e0ffULL,
0xfffffff009067812ULL, 0x000fe400078ee206ULL, 0x00000003ff037210ULL, 0x000fe400007fe4ffULL,
0x0000000506057c11ULL, 0x002fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e4000b901c4eULL, 0x00000001ff027424ULL, 0x002fcc00078e00ffULL,
0x018b8802ff0279a7ULL, 0x000e640008500006ULL, 0x000000ffff067224ULL, 0x002fe200078e0003ULL,
0x0000000000027805ULL, 0x000fc60000015200ULL, 0x018b8806ff0075a7ULL, 0x000e640008000146ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x018b8806ff0075a7ULL, 0x000e640008000146ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000107919ULL, 0x000e620000000000ULL, 0x00018b7806097890ULL, 0x000fe2000fffe03fULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x000000205f007824ULL, 0x002fca00078e0210ULL, 0x0000001f0000780cULL, 0x000fda0003f04070ULL,
0x0000000000300947ULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x000e620000000a00ULL,
0x0000002000067836ULL, 0x000fe20000000000ULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x0000000600077c11ULL, 0x000fe2000f8e10ffULL, 0x000000045d057c24ULL, 0x000fe4000f8e0200ULL,
0x0000000d06007c0cULL, 0x000fe4000bf06070ULL, 0x0000002005057836ULL, 0x000fc80000000000ULL,
0x0000000405027825ULL, 0x002fce00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000002077faeULL, 0x0003e4000c12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000010ff007c0cULL, 0x000fe2000bf05270ULL,
0x018b7804ff0279a7ULL, 0x0026a20008500006ULL, 0x000000ffff5a7224ULL, 0x000fe200078e00ffULL,
0x0000000000587805ULL, 0x000fe4000001ff00ULL, 0x0000000000567805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x018b8804ff0479a7ULL, 0x008e620008500006ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x000000f400b08947ULL, 0x002fec0003800000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000000300157202ULL, 0x004fe20000000f00ULL, 0x000000ffff1d7224ULL, 0x002fe200078e0005ULL,
0x0000000604087899ULL, 0x000fe2000800063fULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fd00008000000ULL, 0x00000008040a7899ULL, 0x000fc8000800063fULL,
0x0000000d0a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x000000f400700947ULL, 0x002fea0003800000ULL, 0x000000ffff557224ULL, 0x000fce00078e00ffULL,
0x000000045c007c0cULL, 0x000fe4000bf04070ULL, 0x00000002ff007819ULL, 0x000fe40000011655ULL,
0x0000000355027812ULL, 0x040fe400078ec0ffULL, 0x0000000055057207ULL, 0x000fe40000000000ULL,
0x000000ff02007207ULL, 0x000fe40004000000ULL, 0x0000000305027812ULL, 0x000fc400078ec0ffULL,
0x0000000405057c11ULL, 0x000fe4000f8ff0ffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b7815ff0075a7ULL, 0x000e640008020146ULL, 0x00000000005c1947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f26270ULL,
0x0000000000449947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x00000018161b7210ULL, 0x000fca0007f3e1ffULL, 0x0000000119197824ULL, 0x000fe200008e0e17ULL,
0x003d09001b00780cULL, 0x000fc80003f26070ULL, 0x000000ff1900720cULL, 0x000fda0003f26310ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f26070ULL,
0x000000ff1900720cULL, 0x000fda0003f26310ULL, 0x00000000001c9947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011419ULL, 0x0000001b14147211ULL, 0x000fca00078310ffULL,
0x000000ffff197224ULL, 0x000fca00008e0619ULL, 0x0000000214147819ULL, 0x000fc80000001219ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x018b7815ff0075a7ULL, 0x000e640008020146ULL,
0xfffffffc00a89947ULL, 0x002fea000383ffffULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x018b881dff0075a7ULL, 0x000e640008020146ULL, 0x00000000005c1947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f26270ULL,
0x0000000000449947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f3e1ffULL, 0x0000000117177824ULL, 0x000fe200008e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f26070ULL, 0x000000ff1700720cULL, 0x000fda0003f26310ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f26070ULL,
0x000000ff1700720cULL, 0x000fda0003f26310ULL, 0x00000000001c9947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078310ffULL,
0x000000ffff177224ULL, 0x000fca00008e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b881dff0075a7ULL, 0x000e640008020146ULL,
0xfffffffc00a89947ULL, 0x002fea000383ffffULL, 0x0000000105147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bf26070ULL, 0x0000000400649947ULL, 0x000fea0003800000ULL,
0x00000004ff1e7819ULL, 0x000fe20000011610ULL, 0x0000000405167824ULL, 0x000fe200078e0202ULL,
0x00000020131b7811ULL, 0x000fe200078e30ffULL, 0x00000010101a7824ULL, 0x000fe200078e00ffULL,
0x0000001e5b197210ULL, 0x000fe20007ffe0ffULL, 0x00016000060a7890ULL, 0x000fe2000fffe03fULL,
0x0000002016167811ULL, 0x000fe200078e30ffULL, 0x000000021e207836ULL, 0x000fe20000000000ULL,
0x00000006191f7c11ULL, 0x040fe2000f8e10ffULL, 0x00000001191c7824ULL, 0x000fe200078e0210ULL,
0x0000000d16177c48ULL, 0x000fe2000ffe0000ULL, 0x000000015b227824ULL, 0x000fe200078e0220ULL,
0x000000f01a217812ULL, 0x000fe200078ec0ffULL, 0x018a00001f147984ULL, 0x000e640000000800ULL,
0x0000000117167824ULL, 0x000fc400078e0a16ULL, 0x0000000119177824ULL, 0x040fe400078e021bULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x000000165b167248ULL, 0x000fe20007fe0000ULL,
0x0000000122237824ULL, 0x000fc600078e0210ULL, 0xfffffff0191c7812ULL, 0x000fe200078ee21cULL,
0x00000001161a7824ULL, 0x000fc600078e0a5bULL, 0x0000000a1c1d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a1e00720cULL, 0x000fe40003f26070ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e680000000a00ULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe400010e0617ULL,
0x0000000122177824ULL, 0x040fe400078e021bULL, 0x0000001022227824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000c901c4eULL,
0x0000001a2000720cULL, 0x000fe20003f26070ULL, 0x000000041e207836ULL, 0x000fe40000000000ULL,
0x018a08001f167984ULL, 0x000ea20000000800ULL, 0x000000061e1e7836ULL, 0x000fe20000000000ULL,
0xfffffff0221d7812ULL, 0x002fe200078ee223ULL, 0x000000015b227824ULL, 0x000fc600078e0220ULL,
0x0000000a1d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000122237824ULL, 0x000fe200078e0210ULL,
0x00000006161c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001c167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116187210ULL, 0x000fc80007f5e0ffULL, 0x00000017ff197210ULL, 0x000fe200017fe4ffULL,
0x0000000122177824ULL, 0x040fe400078e021bULL, 0x0000001022227824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000c901c4eULL,
0x0000001a2000720cULL, 0x000fc60003f26070ULL, 0x018a10001f167984ULL, 0x000ea20000000800ULL,
0xfffffff022197812ULL, 0x002fc800078ee223ULL, 0x0000000a19197c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001c167984ULL, 0x0002a40000000800ULL,
0x000000015b1c7824ULL, 0x002fc800078e021eULL, 0x000000011c1b7824ULL, 0x040fe400078e021bULL,
0x000000011c1d7824ULL, 0x040fe400078e0210ULL, 0x000000101c1c7824ULL, 0x000fe400078e00ffULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e2000c901c4eULL,
0x0000001a1e00720cULL, 0x000fc60003f26070ULL, 0x018a18001f187984ULL, 0x000ea20000000800ULL,
0xfffffff01c177812ULL, 0x002fc800078ee21dULL, 0x0000000a17177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x00000008181b7c24ULL, 0x002fc8000f8e021bULL, 0x000001001b147825ULL, 0x000fc600078e0014ULL,
0x0000002114147210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c901c4eULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x0000005b101f7211ULL, 0x040fe200078fe0ffULL,
0x00016000060a7890ULL, 0x000fe2000fffe03fULL, 0x0000002013207811ULL, 0x000fe400078e30ffULL,
0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101f1a7824ULL, 0x040fe200078e00ffULL,
0x0000000410197819ULL, 0x000fe200000006ffULL, 0x000000011f177824ULL, 0x000fe400078e0220ULL,
0x018a00001e147984ULL, 0x000e620000000800ULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f197824ULL, 0x000fc400078e0210ULL, 0x000000021f1b7836ULL, 0x000fc60000000000ULL,
0xfffffff01a1d7812ULL, 0x000fe200078ee219ULL, 0x000000011b227824ULL, 0x000fc600078e0210ULL,
0x0000000a1d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116187210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe400008e0617ULL,
0x000000011b177824ULL, 0x040fe400078e0220ULL, 0x000000101b1b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e8000b901c4eULL,
0x018a08001e167984ULL, 0x000ea20000000800ULL, 0xfffffff01b197812ULL, 0x002fe200078ee222ULL,
0x000000041f1d7836ULL, 0x000fe20000000000ULL, 0x000000061f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000a19197c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001c167984ULL, 0x0002a40000000800ULL, 0x000000011d1c7824ULL, 0x002fe400078e0210ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x00000021161a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe400008e0617ULL,
0x000000011d177824ULL, 0x140fe400078e0220ULL, 0x000000101d1d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a197faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ea20000000800ULL, 0xfffffff01d197812ULL, 0x002fe200078ee21cULL,
0x000000011f1b7824ULL, 0x000fc400078e0220ULL, 0x000000011f1a7824ULL, 0x000fe200078e0210ULL,
0x0000000a19197c11ULL, 0x000fe2000f8e20ffULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000616187c11ULL, 0x004fca000f8e10ffULL, 0x018ac00018167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff177224ULL, 0x000fca00008e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea20000000800ULL, 0xfffffff01f177812ULL, 0x002fc800078ee21aULL,
0x0000000a17177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000008181b7c24ULL, 0x002fc8000f8e021bULL,
0x000001001b147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e6000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008020146ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f3e1ffULL,
0x0000000117177824ULL, 0x000fe200008e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f26070ULL,
0x000000ff1700720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f26070ULL, 0x000000ff1700720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078310ffULL, 0x000000ffff177224ULL, 0x000fca00008e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008020146ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x000000055c00720cULL, 0x080fe20003f44070ULL, 0x0000000100157836ULL, 0x000fe20000000000ULL,
0x000000030000780cULL, 0x000fe20003f85270ULL, 0x000000205f6c7824ULL, 0x000fe200078e0210ULL,
0x000000055c00720cULL, 0x000fe20003f64070ULL, 0x00018b80060a7890ULL, 0x000fe2000fffe03fULL,
0x0000000315147812ULL, 0x000fe200078ec0ffULL, 0x00000001ff6a7424ULL, 0x000fe200078e00ffULL,
0x0000001f6c00780cULL, 0x000fca0003f24070ULL, 0x00000002ff15a819ULL, 0x000fca0000011615ULL,
0x0000000102027824ULL, 0x000fca00078e0215ULL, 0x0000000602007819ULL, 0x040fe400000006ffULL,
0x0000000502027211ULL, 0x000fe400078ff0ffULL, 0x000000c000057812ULL, 0x000fca00078ec0ffULL,
0x0000010002177824ULL, 0x000fe200078e0205ULL, 0x000000ff14027207ULL, 0x000fe20005000000ULL,
0x000000000050b947ULL, 0x000fec0002000000ULL, 0x000000205f197824ULL, 0x000fe200078e0210ULL,
0x0000000105057890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x000000031900780cULL, 0x000fda0003f44070ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff167b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412007824ULL, 0x000fe200078e0219ULL, 0x0000000619197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000200057824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000516007c36ULL, 0x002fc80008000000ULL,
0x0000001605057224ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe80003800000ULL,
0x0000000000341947ULL, 0x000fea0003800000ULL, 0x00009200ff147b82ULL, 0x002e620000000a00ULL,
0x000000015d007824ULL, 0x000fe200078e0202ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000016c027824ULL, 0x100fe400078e0217ULL, 0x0000000b00057c24ULL, 0x000fe2000f8e0217ULL,
0x000000066c177c11ULL, 0x000fe4000f8e10ffULL, 0x0000000d02007c0cULL, 0x000fe2000bf46070ULL,
0x000000016c057824ULL, 0x000fc800078e0205ULL, 0x0000000405147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014177faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff5500720cULL, 0x000fe20003f45270ULL, 0x018b806aff6479a7ULL, 0x0004d80008500006ULL,
0x0000000400942947ULL, 0x004fea0003800000ULL, 0x018ad86a5b1479a7ULL, 0x002e640008500006ULL,
0x000000ffff027224ULL, 0x002fce00078e0015ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x018ad8025b0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff077224ULL, 0x000fce00078e00ffULL, 0x000000100700780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614057210ULL, 0x000fca0007f5e1ffULL, 0x0000000117167824ULL, 0x000fe200010e0e15ULL,
0x003d09000500780cULL, 0x000fc80003f46070ULL, 0x000000ff1600720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f46070ULL,
0x000000ff1600720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011416ULL, 0x0000000500007211ULL, 0x000fca00078510ffULL,
0x000000ffff057224ULL, 0x000fca00010e0616ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x000fce0007ffe0ffULL, 0x018ad8025b0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001010007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe20000011610ULL, 0x00000001ff077424ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200078e0008ULL, 0x0000007000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c02057812ULL, 0x000fc800078ec0ffULL, 0x0000000605007c10ULL, 0x000fca000fffe000ULL,
0x0180000000057984ULL, 0x000e680000000800ULL, 0x0182000000147984ULL, 0x0004a20000000800ULL,
0x000000080500720bULL, 0x002fda0003f5d000ULL, 0x0000000000027806ULL, 0x000fc800010e0100ULL,
0x0000ffff02167812ULL, 0x000fda000784c0ffULL, 0x0000000000e8a947ULL, 0x00cfea0003800000ULL,
0x000000080500720bULL, 0x000fe40003f54000ULL, 0x000000ff5f00720cULL, 0x000fe40003f65270ULL,
0x0000000508157209ULL, 0x000fd20007810000ULL, 0x0000000000177806ULL, 0x000fe400010e0100ULL,
0x018400150000b388ULL, 0x0003e40000000800ULL, 0x0000991017027816ULL, 0x000fc800000000ffULL,
0x000000ff0200720cULL, 0x000fda0003f45270ULL, 0x0000000000b0a947ULL, 0x002fea0003800000ULL,
0x8000001508007221ULL, 0x000fe20000010000ULL, 0x000000ff17ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0017ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000197308ULL, 0x0002ac0000000800ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc0000011610ULL, 0x00001f0019007589ULL, 0x004e6400000e0000ULL,
0x000000000b0b7220ULL, 0x082fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x0000000042427220ULL, 0x080fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000046467220ULL, 0x080fe20000410000ULL,
0x0000000049497220ULL, 0x080fe20000410000ULL, 0x000000004a4a7220ULL, 0x080fe20000410000ULL,
0x000000004d4d7220ULL, 0x080fe20000410000ULL, 0x000000004e4e7220ULL, 0x080fe20000410000ULL,
0x0000000051517220ULL, 0x080fe20000410000ULL, 0x0000000052527220ULL, 0x080fe20000410000ULL,
0x0000000057577220ULL, 0x080fe20000410000ULL, 0x0000000058587220ULL, 0x000fce0000410000ULL,
0x0000001909097220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000000810007811ULL, 0x002fcc00078ff0ffULL, 0x00001f0019007589ULL, 0x000e6400000e0000ULL,
0x000000000d0d7220ULL, 0x082fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000043437220ULL, 0x080fe20000410000ULL, 0x0000000044447220ULL, 0x080fe20000410000ULL,
0x0000000047477220ULL, 0x080fe20000410000ULL, 0x0000000048487220ULL, 0x080fe20000410000ULL,
0x000000004b4b7220ULL, 0x080fe20000410000ULL, 0x000000004c4c7220ULL, 0x080fe20000410000ULL,
0x000000004f4f7220ULL, 0x080fe20000410000ULL, 0x0000000050507220ULL, 0x080fe20000410000ULL,
0x0000000053537220ULL, 0x080fe20000410000ULL, 0x0000000056567220ULL, 0x080fe20000410000ULL,
0x0000000059597220ULL, 0x080fe20000410000ULL, 0x000000005a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fda0007846017ULL, 0x8000001505052221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b05052820ULL, 0x000fc80000410000ULL,
0x0000000500062308ULL, 0x000ea40000000800ULL, 0x0000000614142220ULL, 0x004fce0000410000ULL,
0x0000000914097221ULL, 0x000fe20000010000ULL, 0x000000ffff087224ULL, 0x000fce00078e0015ULL,
0x0000000710677812ULL, 0x040fe400078ec0ffULL, 0x000000ff07ff7812ULL, 0x000fe4000786c0ffULL,
0x00000004ff667819ULL, 0x000fe40000011610ULL, 0x0000000867677812ULL, 0x000fe400078ef810ULL,
0x00000008106b7812ULL, 0x000fe200078ec0ffULL, 0x000000045f6e7824ULL, 0x000fe400078e0266ULL,
0x0000000166547824ULL, 0x000fe200078e0267ULL, 0x000000076b6b7812ULL, 0x000fe200078ef810ULL,
0x0000000867057824ULL, 0x000fc800078e00ffULL, 0x000000016b027824ULL, 0x040fe200078e026eULL,
0xfffffff805057812ULL, 0x000fe200078ee254ULL, 0x000000106b177824ULL, 0x002fc600078e00ffULL,
0x0000000605057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000183947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011610ULL, 0x00000006ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000007816ULL, 0x000fca0000000000ULL,
0x00001f0300037589ULL, 0x0002a800000e0000ULL, 0x00001f1500047589ULL, 0x0002e400000e0000ULL,
0x01200000051c783bULL, 0x0002e20000000200ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x08cfe40000000000ULL, 0x000000031e1e7232ULL, 0x000fe40000000000ULL,
0x000000041d1d7232ULL, 0x080fe40000000000ULL, 0x000000041f1f7232ULL, 0x000fce0000000000ULL,
0x000000025f397811ULL, 0x000fe200078e10ffULL, 0x000000106b157824ULL, 0x042fe200078e00ffULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0xfffffff017027812ULL, 0x000fe400078ee202ULL,
0x0000000166647824ULL, 0x008fe200078e0239ULL, 0x000000106b3b7812ULL, 0x040fe400078efcffULL,
0x0000000b02027c11ULL, 0x000fe2000f8e20ffULL, 0x000000016b007824ULL, 0x000fe400078e0264ULL,
0x000000016e697824ULL, 0x000fc400078e023bULL, 0x000000000218783bULL, 0x000e620000004200ULL,
0xfffffff015007812ULL, 0x000fc800078ee200ULL, 0x0000000b00007c11ULL, 0x000fca000f8e20ffULL,
0x000000000014783bULL, 0x000ee20000004200ULL, 0x0000312019197816ULL, 0x002fe400000000ffULL,
0x0000312018187816ULL, 0x000fe400000000ffULL, 0x00000019ff3d723eULL, 0x000fe400020006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000000367197819ULL, 0x000fe400000006ffULL,
0x0000312014147816ULL, 0x008fc400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x00000014ff28723eULL, 0x000fe400020006ffULL, 0x00000014ff24723eULL, 0x000fe200030006ffULL,
0x0000000254147836ULL, 0x000fe20000000000ULL, 0x000031201b1b7816ULL, 0x000fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fc400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0xfffffff8195e7812ULL, 0x000fe400078ee214ULL,
0x00000018ff3c723eULL, 0x000fe400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x0000001aff30723eULL, 0x000fe400020006ffULL, 0x0000001bff31723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x000fe200000018ffULL, 0x0000001aff2c723eULL, 0x000fc400030006ffULL,
0x0000001bff2d723eULL, 0x000fe400030006ffULL, 0x00000015ff29723eULL, 0x000fe200020006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000015ff25723eULL, 0x000fe400030006ffULL,
0x00000016ff20723eULL, 0x000fe400020006ffULL, 0x00000017ff21723eULL, 0x000fe200020006ffULL,
0x000000301c30723cULL, 0x000fe200000018ffULL, 0x00000016ff14723eULL, 0x000fe200030006ffULL,
0x000000103b167824ULL, 0x000fe200078e00ffULL, 0x00000017ff15723eULL, 0x000fc400030006ffULL,
0x000000065e5e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0xfffffff016697812ULL, 0x000fc600078ee269ULL, 0x012000005e18783bULL, 0x0002e40000000200ULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000103947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x08cfe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x0000000b69617c11ULL, 0x000fe2000f8e20ffULL, 0x0000042000007945ULL, 0x000fe20003800000ULL,
0x000000393b687210ULL, 0x040fe20007ffe066ULL, 0x000000103b3b7824ULL, 0x000fe200078e00ffULL,
0x000000045c007c0cULL, 0x040fe2000bfc3070ULL, 0x000000006114783bULL, 0x000e620000004200ULL,
0x000000045c007c0cULL, 0x000fe4000bf43070ULL, 0xfffffff03b687812ULL, 0x000fc800078ee268ULL,
0x0000000b68607c11ULL, 0x000fca000f8e20ffULL, 0x000000006038783bULL, 0x000f220000004200ULL,
0x0000312014637816ULL, 0x002fe400000000ffULL, 0x00003120156d7816ULL, 0x000fe400000000ffULL,
0x00000063ff14723eULL, 0x000fe400020006ffULL, 0x0000006dff15723eULL, 0x000fe400020006ffULL,
0x0000312016627816ULL, 0x000fe400000000ffULL, 0x00003120176f7816ULL, 0x000fc400000000ffULL,
0x00000063ff16723eULL, 0x000fe200030006ffULL, 0x00000014183c723cULL, 0x008fe2000000183cULL,
0x0000006dff17723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x010fe400000000ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x00000062ff14723eULL, 0x000fe200020006ffULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x0000006fff15723eULL, 0x000fcc00020006ffULL,
0x00000062ff16723eULL, 0x000fe200030006ffULL, 0x000000141830723cULL, 0x000fe20000001830ULL,
0x0000006fff17723eULL, 0x000fe400030006ffULL, 0x00000002ff627819ULL, 0x000fc80000011610ULL,
0x00000038ff14723eULL, 0x000fe200020006ffULL, 0x00000016182c723cULL, 0x000fe2000000182cULL,
0x00000039ff15723eULL, 0x000fe200020006ffULL, 0x0000000862637836ULL, 0x000fe20000000000ULL,
0x000000556200720cULL, 0x000fc80003f86070ULL, 0x00000039ff17723eULL, 0x000fe200030006ffULL,
0x0000000155397836ULL, 0x000fe20000000000ULL, 0x00000038ff16723eULL, 0x000fe200030006ffULL,
0x000000141828723cULL, 0x000fe20000001828ULL, 0x000000556300720cULL, 0x040fe40003fa6070ULL,
0x000000396200720cULL, 0x080fe40006786470ULL, 0x000000396300720cULL, 0x000fe20006fa6470ULL,
0x000000161824723cULL, 0x000fe20000001824ULL, 0x000031203a147816ULL, 0x000fc400000000ffULL,
0x000031203b157816ULL, 0x000fc800000000ffULL, 0x00000014ff16723eULL, 0x000fe400020006ffULL,
0x00000015ff17723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fc600030006ffULL, 0x000000161820723cULL, 0x000fec0000001820ULL,
0x00000014181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000404947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x000000350e0e7221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000405947ULL, 0x000fea0001000000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b886aff1479a7ULL, 0x000e620008500006ULL,
0x000000045c007c0cULL, 0x040fe4000bf43070ULL, 0x00000003391a7812ULL, 0x000fe400078ec0ffULL,
0x000000045c007c0cULL, 0x000fe4000bfc3070ULL, 0x00000004ff387803ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000002ff147819ULL, 0x002fe20000011639ULL,
0x000000ffff187224ULL, 0x000fc600078e0015ULL, 0x0000001439147207ULL, 0x000fc80000000000ULL,
0x00000003141b7812ULL, 0x040fe400078ec0ffULL, 0x00000004141c7c11ULL, 0x000fce000f8ff0ffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8065ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8065ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fc800078510ffULL, 0x00000015ff157210ULL, 0x000fc800017fe4ffULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011c147836ULL, 0x000fca0000000000ULL, 0x0000001014007c0cULL, 0x000fda000bf46070ULL,
0x00000004005ca947ULL, 0x000fea0003800000ULL, 0x000000015b1d7824ULL, 0x000fe200078e0266ULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010187824ULL, 0x000fe400078e00ffULL,
0x0000004013217824ULL, 0x000fe200078e021dULL, 0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL,
0x000000101d1e7824ULL, 0x000fe200078e00ffULL, 0x000000f018237812ULL, 0x000fe200078ec0ffULL,
0x000000041c187824ULL, 0x000fe400078e021bULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000266207836ULL, 0x000fc40000000000ULL, 0x0000004018187824ULL, 0x000fe400078e00ffULL,
0x000000015b277824ULL, 0x000fe200078e0220ULL, 0x0000000614197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0007240000000800ULL,
0x0000000d18197c48ULL, 0x008fca000ffe0000ULL, 0x0000000119187824ULL, 0x000fe400078e0a18ULL,
0x000000011d197824ULL, 0x000fc600078e0210ULL, 0x000000185b187248ULL, 0x000fe40007fe0000ULL,
0xfffffff01e197812ULL, 0x000fc600078ee219ULL, 0x00000001181d7824ULL, 0x000fe200078e0a5bULL,
0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL, 0x0000000221197836ULL, 0x000fe40000000000ULL,
0x0000000816177c24ULL, 0x010fc8000f8e0221ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000001d6600720cULL, 0x000fda0003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000d101c4eULL, 0x018a08001f187984ULL, 0x000ee20000000800ULL,
0x0000000127167824ULL, 0x042fe400078e0210ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x0000000421177836ULL, 0x000fc60000000000ULL, 0xfffffff027167812ULL, 0x000fc800078ee216ULL,
0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL, 0x00000006181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fc80007f5e0ffULL,
0x00000019ff197210ULL, 0x000fe400017fe4ffULL, 0x0000001d2000720cULL, 0x000fe20003f46070ULL,
0x0000000466207836ULL, 0x000fe40000000000ULL, 0x0000000666667836ULL, 0x000fe40000000000ULL,
0x000000015b277824ULL, 0x000fd000078e0220ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018257faeULL, 0x0003e8000d101c4eULL, 0x018a10001f167984ULL, 0x000ee20000000800ULL,
0x0000000127187824ULL, 0x042fe400078e0210ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x0000000621197836ULL, 0x000fc60000000000ULL, 0xfffffff027187812ULL, 0x000fc800078ee218ULL,
0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000001d2000720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000d101c4eULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fe200078e0014ULL, 0x000000665b197210ULL, 0x000fe40007ffe0ffULL,
0x0000002314147210ULL, 0x000fc60007f5e0ffULL, 0x0000000119167824ULL, 0x042fe400078e0210ULL,
0x0000001019197824ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x0000001d6600720cULL, 0x000fe40003f46070ULL, 0xfffffff019167812ULL, 0x000fc800078ee216ULL,
0x0000000b16177c11ULL, 0x000fce000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4eULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015b667824ULL, 0x000fe200078e0266ULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010197824ULL, 0x000fe400078e00ffULL, 0x0000004013237824ULL, 0x000fe200078e0266ULL,
0x0000000666217c11ULL, 0x040fe2000f8e10ffULL, 0x00000010661e7824ULL, 0x040fe200078e00ffULL,
0x000000f019257812ULL, 0x000fe200078ec0ffULL, 0x0000000166197824ULL, 0x000fe400078e0210ULL,
0x018a000021147984ULL, 0x000e620000000800ULL, 0x00000002661d7836ULL, 0x000fc40000000000ULL,
0xfffffff01e197812ULL, 0x000fe400078ee219ULL, 0x000000011d1e7824ULL, 0x000fe400078e0210ULL,
0x0000000b19277c11ULL, 0x000fe2000f8e20ffULL, 0x0000000223197836ULL, 0x000fe40000000000ULL,
0x000000101d1d7824ULL, 0x000fca00078e00ffULL, 0xfffffff01d1e7812ULL, 0x000fc800078ee21eULL,
0x0000000b1e1d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000816177c24ULL, 0x008fc8000f8e0223ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002516167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016277faeULL, 0x0003e8000b901c4eULL,
0x018a080021187984ULL, 0x000ee20000000800ULL, 0x0000000423177810ULL, 0x002fe40007ffe0ffULL,
0x00000006181f7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001f187984ULL, 0x0002e40000000800ULL,
0x00000004661f7836ULL, 0x002fc80000000000ULL, 0x000000011f1e7824ULL, 0x040fe400078e0210ULL,
0x000000101f1f7824ULL, 0x000fca00078e00ffULL, 0xfffffff01f1e7812ULL, 0x000fe200078ee21eULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002518187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e8000b901c4eULL,
0x018a100021167984ULL, 0x000ee20000000800ULL, 0x0000000b1e197c11ULL, 0x002fe2000f8e20ffULL,
0x00000006231d7836ULL, 0x000fe20000000000ULL, 0x0000000616207c11ULL, 0x008fca000f8e10ffULL,
0x018ac00020167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002516167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4eULL, 0x018a180021187984ULL, 0x000ee40000000800ULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000ee40000000800ULL,
0x00000008181d7c24ULL, 0x008fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000006661d7836ULL, 0x000fe20000000000ULL, 0x0000002514147210ULL, 0x000fc60007f5e0ffULL,
0x000000011d187824ULL, 0x040fe400078e0210ULL, 0x000000101d1d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0xfffffff01d187812ULL, 0x000fc800078ee218ULL,
0x0000000b18177c11ULL, 0x002fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e4000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fc800078510ffULL, 0x00000015ff157210ULL, 0x000fc800017fe4ffULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000454147836ULL, 0x000fe20000000000ULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x0000000867157824ULL, 0x000fe400078e00ffULL, 0x000000016b6e7824ULL, 0x000fc600078e026eULL,
0xfffffff815667812ULL, 0x000fe200078ee214ULL, 0x0000000000581947ULL, 0x000fec0003800000ULL,
0x0000001c5c00720cULL, 0x000fe20003f44070ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000066c197c11ULL, 0x000fe4000f8e10ffULL, 0x000000ff1a147207ULL, 0x040fe40001000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60005000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000e620000000a00ULL, 0x000000015d177824ULL, 0x000fe400078e021aULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016167836ULL, 0x000fc80000000000ULL, 0x0000000b17177c24ULL, 0x100fe4000f8e0216ULL,
0x000000016c167824ULL, 0x040fe400078e0216ULL, 0x000000016c177824ULL, 0x000fc600078e0217ULL,
0x0000000d16007c0cULL, 0x000fe2000bf46070ULL, 0x0000000417147825ULL, 0x002fd800078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff6c7424ULL, 0x000fe200078e00ffULL, 0x0000000666667c11ULL, 0x000fe2000f8e20ffULL,
0x000000106b657824ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x018b786cff6c79a7ULL, 0x000e620008500006ULL,
0x0000000000103947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x004fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6214037589ULL, 0x0004e800000e0000ULL,
0x00001f6314047589ULL, 0x00046400000e0000ULL, 0x01200000661c783bULL, 0x0006a20000000200ULL,
0x0000000000103947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x082fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000646b647210ULL, 0x000fe20007ffe0ffULL,
0x000000106b6b7824ULL, 0x000fe200078e00ffULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0xfffffff065657812ULL, 0x000fe200078ee26eULL, 0x0000000654547836ULL, 0x000fe40000000000ULL,
0xfffffff06b647812ULL, 0x000fe200078ee264ULL, 0x0000000867677824ULL, 0x000fe200078e00ffULL,
0x0000000b65657c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b64647c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff867547812ULL, 0x000fe200078ee254ULL, 0x000000006518783bULL, 0x000f260000004200ULL,
0x0000000654677c11ULL, 0x000fe2000f8e20ffULL, 0x000000006414783bULL, 0x004ea20000004200ULL,
0x0000312018187816ULL, 0x010fe400000000ffULL, 0x0000312019197816ULL, 0x000fe400000000ffULL,
0x000031201a1a7816ULL, 0x000fc400000000ffULL, 0x000031201b1b7816ULL, 0x000fe400000000ffULL,
0x0000312014147816ULL, 0x004fe400000000ffULL, 0x0000312015157816ULL, 0x000fe400000000ffULL,
0x0000312016167816ULL, 0x000fe400000000ffULL, 0x0000312017177816ULL, 0x000fe400000000ffULL,
0x00000018ff3c723eULL, 0x000fc400020006ffULL, 0x00000019ff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff34723eULL, 0x000fe400030006ffULL, 0x00000019ff35723eULL, 0x000fe400030006ffULL,
0x0000001aff30723eULL, 0x000fe200020006ffULL, 0x0000003c1c3c723cULL, 0x000fe200000018ffULL,
0x0000001bff31723eULL, 0x000fe400020006ffULL, 0x0000001aff2c723eULL, 0x000fc400030006ffULL,
0x0000001bff2d723eULL, 0x000fe200030006ffULL, 0x000000341c34723cULL, 0x000fe200000018ffULL,
0x00000014ff28723eULL, 0x000fe200020006ffULL, 0x012000006718783bULL, 0x0004e20000000200ULL,
0x00000015ff29723eULL, 0x000fe400020006ffULL, 0x00000014ff24723eULL, 0x000fe200030006ffULL,
0x000000301c30723cULL, 0x000fe200000018ffULL, 0x00000015ff25723eULL, 0x000fe400030006ffULL,
0x00000016ff20723eULL, 0x000fc400020006ffULL, 0x00000017ff21723eULL, 0x000fe200020006ffULL,
0x0000002c1c2c723cULL, 0x000fe200000018ffULL, 0x00000016ff14723eULL, 0x000fe400030006ffULL,
0x00000017ff15723eULL, 0x000fc600030006ffULL, 0x000000281c28723cULL, 0x000fec00000018ffULL,
0x000000241c24723cULL, 0x000fec00000018ffULL, 0x000000201c20723cULL, 0x000fec00000018ffULL,
0x000000141c1c723cULL, 0x000fe200000018ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000103947ULL, 0x004fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000000000ULL,
0x000000031a1a7232ULL, 0x000fe40000000000ULL, 0x0000000419197232ULL, 0x082fe40000000000ULL,
0x000000041b1b7232ULL, 0x000fce0000000000ULL, 0x0000000b69697c11ULL, 0x000fe2000f8e20ffULL,
0x0000037000007945ULL, 0x000fe20003800000ULL, 0x0000000b68687c11ULL, 0x000fe4000f8e20ffULL,
0x000000ff3800720cULL, 0x000fe20003f45270ULL, 0x000000006914783bULL, 0x000ea80000004200ULL,
0x000000006838783bULL, 0x000f220000004200ULL, 0x00003120146a7816ULL, 0x004fc400000000ffULL,
0x00003120156b7816ULL, 0x000fe400000000ffULL, 0x0000006aff14723eULL, 0x000fe400020006ffULL,
0x0000006bff15723eULL, 0x000fe400020006ffULL, 0x0000312016547816ULL, 0x000fe400000000ffULL,
0x00003120176e7816ULL, 0x000fe400000000ffULL, 0x0000006aff16723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x0000006bff17723eULL, 0x000fc400030006ffULL,
0x0000312038387816ULL, 0x010fe400000000ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x00000054ff14723eULL, 0x000fe200020006ffULL, 0x000000161834723cULL, 0x000fe20000001834ULL,
0x0000006eff15723eULL, 0x000fcc00020006ffULL, 0x00000054ff16723eULL, 0x000fe200030006ffULL,
0x000000141830723cULL, 0x000fe20000001830ULL, 0x0000006eff17723eULL, 0x000fcc00030006ffULL,
0x00000038ff14723eULL, 0x000fe200020006ffULL, 0x00000016182c723cULL, 0x000fe2000000182cULL,
0x00000039ff15723eULL, 0x000fcc00020006ffULL, 0x00000038ff16723eULL, 0x000fe200030006ffULL,
0x000000141828723cULL, 0x000fe20000001828ULL, 0x00000039ff17723eULL, 0x000fcc00030006ffULL,
0x000031203a147816ULL, 0x000fe200000000ffULL, 0x000000161824723cULL, 0x000fe20000001824ULL,
0x000031203b157816ULL, 0x000fcc00000000ffULL, 0x00000014ff16723eULL, 0x000fe400020006ffULL,
0x00000015ff17723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fc600030006ffULL, 0x000000161820723cULL, 0x000fec0000001820ULL,
0x00000014181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000404947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x000000350e0e7221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x002fc600078e006dULL,
0x0000000000405947ULL, 0x000fea0003000000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0c0c7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002253537221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x0000000155557836ULL, 0x000fe40000000000ULL,
0x018b8814ff1679a7ULL, 0x000e620008500006ULL, 0x00000004146a7807ULL, 0x000fc80000000000ULL,
0x0000006a5500720cULL, 0x000fe20003f46070ULL, 0x000000ffff1d7224ULL, 0x002fd800078e0017ULL,
0xffffffc00004a947ULL, 0x000fea000383ffffULL, 0x00000040040b7891ULL, 0x000fe2000f8e403fULL,
0x018b5814ffff79a7ULL, 0x0003e60008500006ULL, 0x0000000d0b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f4f008ULL, 0x000000b4005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x00000002ff147819ULL, 0x000fe4000001166bULL,
0x000000036b1a7812ULL, 0x040fe400078ec0ffULL, 0x000000146b147207ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60004000000ULL, 0x0000000114147836ULL, 0x000fca0000000000ULL,
0x00000003141c7812ULL, 0x040fe400078ec0ffULL, 0x00000004141b7c11ULL, 0x000fe4000f8ff0ffULL,
0x0000000000187805ULL, 0x000fe20000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fce00078e00ffULL,
0x000000101e00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x00000016181f7210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e19ULL, 0x003d09001f00780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000001f14147211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011e1e7836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b881dff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ff00187202ULL, 0x000fce0000000f00ULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b881dff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011b147836ULL, 0x000fe20000000000ULL, 0x00000004ff6c7819ULL, 0x000fc80000011610ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x000000040060a947ULL, 0x000fea0003800000ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x000000041b167824ULL, 0x000fe200078e021cULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x00000010101d7824ULL, 0x000fe200078e00ffULL, 0x00000006191f7c11ULL, 0x000fe4000f8e10ffULL,
0x0000002016167811ULL, 0x000fe400078e30ffULL, 0x000000f01d217812ULL, 0x000fe200078ec0ffULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x0000000d16177c48ULL, 0x000fc4000ffe0000ULL,
0x000000026c227810ULL, 0x000fc60007ffe0ffULL, 0x0000000117167824ULL, 0x000fe400078e0a16ULL,
0x0000000119177824ULL, 0x000fe400078e0220ULL, 0x000000015b257824ULL, 0x000fe200078e0222ULL,
0x000000165b167248ULL, 0x000fc60007fe0000ULL, 0x0000000125247824ULL, 0x000fe400078e0210ULL,
0x00000001161d7824ULL, 0x000fca00078e0a5bULL, 0x0000001d6c00720cULL, 0x000fe40003f46070ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e680000000a00ULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818177c24ULL, 0x004fc4000f8e0217ULL,
0x0000000119187824ULL, 0x000fe400078e0210ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff019187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fe400018e0617ULL,
0x0000000125197824ULL, 0x040fe200078e0220ULL, 0x0000000b18237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001025257824ULL, 0x000fc800078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d2200720cULL, 0x000fe20003f46070ULL,
0x000000046c227836ULL, 0x000fe20000000000ULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x018a08001f187984ULL, 0x000ea40000000800ULL, 0x000000015b257824ULL, 0x000fe200078e0222ULL,
0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fc60003f46070ULL, 0x018a10001f187984ULL, 0x000ea20000000800ULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002a40000000800ULL,
0x000000066c1e7836ULL, 0x002fc80000000000ULL, 0x000000015b257824ULL, 0x000fe400078e021eULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe200018e0619ULL,
0x0000002025197210ULL, 0x000fe20007ffe0ffULL, 0x0000000125207824ULL, 0x040fe400078e0210ULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d1e00720cULL, 0x000fc60003f46070ULL,
0x018a18001f187984ULL, 0x000ea20000000800ULL, 0xfffffff025207812ULL, 0x000fc800078ee220ULL,
0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4eULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x000000015b1f7824ULL, 0x000fe200078e026cULL, 0x0000002013227811ULL, 0x000fe200078e30ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x000000101f1e7824ULL, 0x040fe200078e00ffULL, 0x000000061f207c11ULL, 0x040fe2000f8e10ffULL,
0x000000011f177824ULL, 0x000fe200078e0222ULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f197824ULL, 0x000fe400078e0210ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x000000021f237836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000123247824ULL, 0x000fe400078e0210ULL, 0x0000000b191d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000122197824ULL, 0x000fe400078e0223ULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000816177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161d7faeULL, 0x0003e8000b901c4eULL, 0x018a080020187984ULL, 0x000ea20000000800ULL,
0xfffffff0231d7812ULL, 0x002fe200078ee224ULL, 0x000000041f237836ULL, 0x000fe40000000000ULL,
0x000000061f1f7836ULL, 0x000fe20000000000ULL, 0x0000000b1d1d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000122177824ULL, 0x000fc400078e0223ULL, 0x0000000123247824ULL, 0x040fe400078e0210ULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x00000006181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fc80007f5e0ffULL,
0x00000019ff197210ULL, 0x000fca00017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181d7faeULL, 0x0003e8000b901c4eULL, 0x018a100020167984ULL, 0x000ea20000000800ULL,
0xfffffff023197812ULL, 0x002fe200078ee224ULL, 0x00000001221d7824ULL, 0x000fc600078e021fULL,
0x0000000b19197c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002a40000000800ULL, 0x000000101f1e7824ULL, 0x002fe400078e00ffULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4eULL,
0x018a180020187984ULL, 0x000ea40000000800ULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x00000008181d7c24ULL, 0x004fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x000000011f1d7824ULL, 0x000fe200078e0210ULL,
0x0000002114147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff01e177812ULL, 0x002fe200078ee21dULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000b17177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fc80007f5e1ffULL, 0x0000001517157210ULL, 0x000fe400017fe5ffULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1e7424ULL, 0x000fe200078e00ffULL, 0x000000031a00780cULL, 0x000fe20003f65270ULL,
0x000000205f6f7824ULL, 0x000fd800078e0210ULL, 0x00000000004ca947ULL, 0x000fea0001800000ULL,
0x000000036f00780cULL, 0x000fe20003f44070ULL, 0x0000000105057890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412167824ULL, 0x000fe200078e026fULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000517187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x000000011a157836ULL, 0x002fe20000000000ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000315167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16167207ULL, 0x000fc60005000000ULL, 0x00000002ff15a819ULL, 0x000fe40000011615ULL,
0x000000015d167824ULL, 0x000fc600078e0216ULL, 0x000000011c1c7824ULL, 0x000fe400078e0215ULL,
0x00009200ff147b82ULL, 0x000e640000000a00ULL, 0x000000401c177824ULL, 0x040fe200078e00ffULL,
0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c017187812ULL, 0x000fca00078ec0ffULL,
0x000001001b187824ULL, 0x000fc800078e0218ULL, 0x000000016f177824ULL, 0x100fe400078e0218ULL,
0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL, 0x0000000d17007c0cULL, 0x000fe4000bf46070ULL,
0x000000166f177210ULL, 0x000fca0007ffe0ffULL, 0x0000000417147825ULL, 0x002fcc00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801eff1479a7ULL, 0x000e620008500006ULL, 0x000000ff6b00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018af81e5b1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018af8185b0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018af8185b0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001010077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011610ULL,
0x000000ffff167224ULL, 0x000fc600078e0008ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000006141b7c10ULL, 0x000fca000fffe007ULL,
0x018080001b157984ULL, 0x000e680000000800ULL, 0x018280001b147984ULL, 0x0004a20000000800ULL,
0x000000081500720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000081500720bULL, 0x000fe40003f54000ULL,
0x000000015f00780cULL, 0x000fe40003f65270ULL, 0x0000001508167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018480161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001608087221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x00000008001a7308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f621a087589ULL, 0x006e6400000e0000ULL,
0x000000080b0b7220ULL, 0x082fe20000410000ULL, 0x000000080a0a7220ULL, 0x080fe20000410000ULL,
0x000000080f0f7220ULL, 0x080fe20000410000ULL, 0x000000080e0e7220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x0000000842427220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000846467220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x000000084a4a7220ULL, 0x080fe20000410000ULL,
0x000000084d4d7220ULL, 0x080fe20000410000ULL, 0x000000084e4e7220ULL, 0x080fe20000410000ULL,
0x0000000851517220ULL, 0x080fe20000410000ULL, 0x0000000852527220ULL, 0x080fe20000410000ULL,
0x0000000857577220ULL, 0x080fe20000410000ULL, 0x0000000858587220ULL, 0x000fce0000410000ULL,
0x0000001a09097220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f631a087589ULL, 0x002e6400000e0000ULL, 0x000000080d0d7220ULL, 0x082fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000843437220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000847477220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x000000084b4b7220ULL, 0x080fe20000410000ULL,
0x000000084c4c7220ULL, 0x080fe20000410000ULL, 0x000000084f4f7220ULL, 0x080fe20000410000ULL,
0x0000000850507220ULL, 0x080fe20000410000ULL, 0x0000000853537220ULL, 0x080fe20000410000ULL,
0x0000000856567220ULL, 0x080fe20000410000ULL, 0x0000000859597220ULL, 0x080fe20000410000ULL,
0x000000085a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001615152221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL, 0x0000001500062308ULL, 0x000ea40000000800ULL,
0x0000000614142220ULL, 0x004fce0000410000ULL, 0x0000000914097221ULL, 0x000fe20000010000ULL,
0x000000ffff087224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6214037589ULL, 0x0002a800000e0000ULL,
0x00001f6314047589ULL, 0x0002e400000e0000ULL, 0x01280000051c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x080fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x002fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x008fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x012800005e18783bULL, 0x0002e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x08cfe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006114783bULL, 0x000e620000004200ULL, 0x0000006b6200720cULL, 0x080fe20003f66070ULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x000000045c007c0cULL, 0x040fe2000bfc3070ULL,
0x000000006038783bULL, 0x000f220000004200ULL, 0x0000006b6300720cULL, 0x000fe40003f86070ULL,
0x000000045c007c0cULL, 0x000fe4000bfa3070ULL, 0x0000312014547816ULL, 0x002fe400000000ffULL,
0x0000312015557816ULL, 0x000fc400000000ffULL, 0x00000054ff14723eULL, 0x000fe400020006ffULL,
0x00000055ff15723eULL, 0x000fe400020006ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000054ff54723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x00000055ff55723eULL, 0x000fcc00030006ffULL,
0x00000016ff14723eULL, 0x000fe200020006ffULL, 0x000000541834723cULL, 0x000fe20000001834ULL,
0x00000017ff15723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe400030006ffULL,
0x00000017ff17723eULL, 0x000fc600030006ffULL, 0x000000141830723cULL, 0x000fec0000001830ULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x0000312038147816ULL, 0x010fe200000000ffULL,
0x000000016b387836ULL, 0x000fe20000000000ULL, 0x0000312039157816ULL, 0x000fc800000000ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fe400030006ffULL,
0x000000386200720cULL, 0x080fe20005f66470ULL, 0x000000161828723cULL, 0x000fe20000001828ULL,
0x000000386300720cULL, 0x000fca0006786470ULL, 0x000000141824723cULL, 0x000fee0000001824ULL,
0x000031203a147816ULL, 0x000fe400000000ffULL, 0x000031203b157816ULL, 0x000fe400000000ffULL,
0x00000014ff16723eULL, 0x000fc400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x000000350e0e7221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8816ff1479a7ULL, 0x000e620008500006ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000045c007c0cULL, 0x000fe4000bfc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x000000045c007c0cULL, 0x000fe2000bfa3070ULL, 0x0000000117177836ULL, 0x000fe20000000000ULL,
0x00000040ff387803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000004171c7c11ULL, 0x000fe4000f8ff0ffULL,
0x0000001500187202ULL, 0x002fce0000000f00ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000011c147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bfc6070ULL, 0x00000004005ce947ULL, 0x000fea0003800000ULL,
0x000000015b1d7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010187824ULL, 0x000fe400078e00ffULL, 0x0000004013217824ULL, 0x000fe200078e021dULL,
0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101d1e7824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x000000026c207836ULL, 0x000fe20000000000ULL,
0x0000001b1c187211ULL, 0x000fe200078e10ffULL, 0x018a00001f147984ULL, 0x000e640000000800ULL,
0x000000015b277824ULL, 0x000fc400078e0220ULL, 0x0000004018187824ULL, 0x000fe200078e00ffULL,
0x0000000614197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0007240000000800ULL, 0x0000000d18197c48ULL, 0x008fca000ffe0000ULL,
0x0000000119187824ULL, 0x000fe400078e0a18ULL, 0x000000011d197824ULL, 0x000fc600078e0210ULL,
0x000000185b187248ULL, 0x000fe40007fe0000ULL, 0xfffffff01e197812ULL, 0x000fc600078ee219ULL,
0x00000001181d7824ULL, 0x000fe200078e0a5bULL, 0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000221197836ULL, 0x000fe40000000000ULL, 0x0000000816177c24ULL, 0x010fc8000f8e0221ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d6c00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a08001f187984ULL, 0x000ee20000000800ULL, 0x0000000127167824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000421177836ULL, 0x000fc60000000000ULL,
0xfffffff027167812ULL, 0x000fc800078ee216ULL, 0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x0000001d2000720cULL, 0x000fe40003fc6070ULL, 0x000000046c207810ULL, 0x000fe20007ffe0ffULL,
0x000000066c6c7836ULL, 0x000fc80000000000ULL, 0x000000015b277824ULL, 0x000fcc00078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000f101c4eULL,
0x018a10001f167984ULL, 0x000ee20000000800ULL, 0x0000000127187824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000621197836ULL, 0x000fc60000000000ULL,
0xfffffff027187812ULL, 0x000fc800078ee218ULL, 0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d2000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a18001f187984ULL, 0x000ee40000000800ULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002314147210ULL, 0x000fc60007fde0ffULL,
0x0000000119167824ULL, 0x042fe400078e0210ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000001d6c00720cULL, 0x000fe20003fc6070ULL, 0x0000001019197824ULL, 0x000fca00078e00ffULL,
0xfffffff019167812ULL, 0x000fc800078ee216ULL, 0x0000000b16177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4eULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015b6c7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010197824ULL, 0x000fe400078e00ffULL,
0x00000040131f7824ULL, 0x000fe200078e026cULL, 0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000106c207824ULL, 0x000fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000026c257836ULL, 0x000fe20000000000ULL, 0x000000106c197210ULL, 0x000fe20007ffe0ffULL,
0x018a00001e147984ULL, 0x000e660000000800ULL, 0xfffffff020197812ULL, 0x000fe200078ee219ULL,
0x0000000125207824ULL, 0x000fc400078e0210ULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000021f197836ULL, 0x000fc60000000000ULL,
0xfffffff025207812ULL, 0x000fe200078ee220ULL, 0x000000046c257836ULL, 0x000fe20000000000ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000816177c24ULL, 0x008fc8000f8e021fULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a08001e187984ULL, 0x000ee20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000041f177836ULL, 0x000fe40000000000ULL,
0x0000000125207824ULL, 0x040fe400078e0210ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe400078ee220ULL, 0x00000006181d7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001d187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4eULL, 0x018a10001e167984ULL, 0x000ee20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000061f197836ULL, 0x000fe20000000000ULL,
0x00000006161d7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fe200078e0014ULL, 0x000000066c197810ULL, 0x000fe40007ffe0ffULL,
0x0000002114147210ULL, 0x000fc60007fde0ffULL, 0x00000001191d7824ULL, 0x040fe400078e0210ULL,
0x0000001019167824ULL, 0x002fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fc600030e0615ULL,
0xfffffff0161d7812ULL, 0x000fc800078ee21dULL, 0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff547424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5c00720cULL, 0x000fe20003fc4070ULL, 0x00009400000b7ab9ULL, 0x000fc60000000800ULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60007000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x000000015d177824ULL, 0x000fe400078e021aULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fca00078e0216ULL, 0x0000002016187810ULL, 0x000fca0007ffe0ffULL,
0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL, 0x000000016f177824ULL, 0x040fe400078e0216ULL,
0x000000016f167824ULL, 0x040fe200078e0218ULL, 0x000000066f6f7c11ULL, 0x000fe2000f8e10ffULL,
0x0000000417147825ULL, 0x002fc600078e0014ULL, 0x0000000d16007c0cULL, 0x000fda000bfc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a00000146f7faeULL, 0x0003e4000f12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b7854ff5479a7ULL, 0x000e620008500006ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x004fc800000000ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6214037589ULL, 0x0004e800000e0000ULL, 0x00001f6314047589ULL, 0x00046400000e0000ULL,
0x01280000661c783bULL, 0x0006a20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x08cfe40000000000ULL, 0x000000031e1e7232ULL, 0x000fe40000000000ULL,
0x000000041d1d7232ULL, 0x082fe40000000000ULL, 0x000000041f1f7232ULL, 0x000fce0000000000ULL,
0x000000006518783bULL, 0x000f280000004200ULL, 0x000000006414783bULL, 0x004ea20000004200ULL,
0x0000312018187816ULL, 0x010fe400000000ffULL, 0x0000312019197816ULL, 0x000fe400000000ffULL,
0x000031201a1a7816ULL, 0x000fe400000000ffULL, 0x000031201b1b7816ULL, 0x000fc400000000ffULL,
0x0000312014147816ULL, 0x004fe400000000ffULL, 0x0000312015157816ULL, 0x000fe400000000ffULL,
0x0000312016167816ULL, 0x000fe400000000ffULL, 0x0000312017177816ULL, 0x000fe400000000ffULL,
0x00000018ff3c723eULL, 0x000fe400020006ffULL, 0x00000019ff3d723eULL, 0x000fc400020006ffULL,
0x00000018ff34723eULL, 0x000fe400030006ffULL, 0x00000019ff35723eULL, 0x000fe400030006ffULL,
0x0000001aff30723eULL, 0x000fe200020006ffULL, 0x0000003c1c3c723cULL, 0x000fe200000018ffULL,
0x0000001bff31723eULL, 0x000fe400020006ffULL, 0x0000001aff2c723eULL, 0x000fe400030006ffULL,
0x0000001bff2d723eULL, 0x000fe200030006ffULL, 0x000000341c34723cULL, 0x000fe200000018ffULL,
0x00000014ff28723eULL, 0x000fe200020006ffULL, 0x012800006718783bULL, 0x0004e20000000200ULL,
0x00000015ff29723eULL, 0x000fc400020006ffULL, 0x00000014ff24723eULL, 0x000fe200030006ffULL,
0x000000301c30723cULL, 0x000fe200000018ffULL, 0x00000015ff25723eULL, 0x000fe400030006ffULL,
0x00000016ff20723eULL, 0x000fe400020006ffULL, 0x00000017ff21723eULL, 0x000fe200020006ffULL,
0x0000002c1c2c723cULL, 0x000fe200000018ffULL, 0x00000016ff14723eULL, 0x000fe400030006ffULL,
0x00000017ff15723eULL, 0x000fc600030006ffULL, 0x000000281c28723cULL, 0x000fec00000018ffULL,
0x000000241c24723cULL, 0x000fec00000018ffULL, 0x000000201c20723cULL, 0x000fec00000018ffULL,
0x000000141c1c723cULL, 0x000fe200000018ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000102947ULL, 0x004fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000000000ULL,
0x000000031a1a7232ULL, 0x000fe40000000000ULL, 0x0000000419197232ULL, 0x082fe40000000000ULL,
0x000000041b1b7232ULL, 0x000fce0000000000ULL, 0x000000006914783bULL, 0x000ea20000004200ULL,
0x000000ff3800720cULL, 0x000fe20003f45270ULL, 0x0000034000007945ULL, 0x000fe40003800000ULL,
0x000000006838783bULL, 0x000f220000004200ULL, 0x00003120146d7816ULL, 0x004fe400000000ffULL,
0x00003120156e7816ULL, 0x000fe400000000ffULL, 0x0000006dff14723eULL, 0x000fe400020006ffULL,
0x0000006eff15723eULL, 0x000fc400020006ffULL, 0x00003120166c7816ULL, 0x000fe400000000ffULL,
0x00003120176f7816ULL, 0x000fe400000000ffULL, 0x0000006dff16723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x0000006eff17723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x010fe400000000ffULL, 0x0000312039397816ULL, 0x000fc400000000ffULL,
0x0000006cff14723eULL, 0x000fe200020006ffULL, 0x000000161834723cULL, 0x000fe20000001834ULL,
0x0000006fff15723eULL, 0x000fcc00020006ffULL, 0x0000006cff16723eULL, 0x000fe200030006ffULL,
0x000000141830723cULL, 0x000fe20000001830ULL, 0x0000006fff17723eULL, 0x000fcc00030006ffULL,
0x00000038ff14723eULL, 0x000fe200020006ffULL, 0x00000016182c723cULL, 0x000fe2000000182cULL,
0x00000039ff15723eULL, 0x000fcc00020006ffULL, 0x00000038ff16723eULL, 0x000fe200030006ffULL,
0x000000141828723cULL, 0x000fe20000001828ULL, 0x00000039ff17723eULL, 0x000fcc00030006ffULL,
0x000031203a147816ULL, 0x000fe200000000ffULL, 0x000000161824723cULL, 0x000fe20000001824ULL,
0x000031203b157816ULL, 0x000fcc00000000ffULL, 0x00000014ff16723eULL, 0x000fe400020006ffULL,
0x00000015ff17723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fc600030006ffULL, 0x000000161820723cULL, 0x000fec0000001820ULL,
0x00000014181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x000000350e0e7221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x002fc600078e0055ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0c0c7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002253537221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x000000016b6b7836ULL, 0x000fe40000000000ULL,
0x018b8814ff1679a7ULL, 0x000e660008500006ULL, 0x0000006a6b00720cULL, 0x000fe20003f46070ULL,
0x000000ffff1d7224ULL, 0x002fd800078e0017ULL, 0xffffffc000f4a947ULL, 0x000fea000383ffffULL,
0x00000080040b7891ULL, 0x000fe2000f8e403fULL, 0x018b6014ffff79a7ULL, 0x0003e60008500006ULL,
0x0000000d0b00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f4f008ULL,
0x0000007800382947ULL, 0x002fea0003800000ULL, 0x000000ffff6b7224ULL, 0x000fce00078e00ffULL,
0x00000002ff147819ULL, 0x000fe4000001166bULL, 0x000000036b1a7812ULL, 0x040fe400078ec0ffULL,
0x000000146b147207ULL, 0x000fe40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60004000000ULL,
0x0000000214147836ULL, 0x000fca0000000000ULL, 0x00000003141c7812ULL, 0x040fe400078ec0ffULL,
0x00000004141b7c11ULL, 0x000fe4000f8ff0ffULL, 0x0000000000187805ULL, 0x000fe20000015200ULL,
0x018b7815ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fce00078e00ffULL, 0x000000101e00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x00000016181f7210ULL, 0x000fca0007f5e1ffULL, 0x0000000117177824ULL, 0x000fe200010e0e19ULL,
0x003d09001f00780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401f00780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011417ULL, 0x0000001f14147211ULL, 0x000fca00078510ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x0000000214147819ULL, 0x000fc80000001217ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011e1e7836ULL, 0x000fce0000000000ULL, 0x018b7815ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b881dff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fc80007f5e1ffULL, 0x0000001517157210ULL, 0x000fe400017fe5ffULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b881dff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011b147836ULL, 0x000fe20000000000ULL,
0x00000004ff6c7819ULL, 0x000fc80000011610ULL, 0x0000001014007c0cULL, 0x000fda000bf46070ULL,
0x000000040060a947ULL, 0x000fea0003800000ULL, 0x000000015b197824ULL, 0x000fe200078e026cULL,
0x0000002013207811ULL, 0x000fe200078e30ffULL, 0x000000041b167824ULL, 0x000fe200078e021cULL,
0x00016000060b7890ULL, 0x000fe2000fffe03fULL, 0x00000010101d7824ULL, 0x000fe200078e00ffULL,
0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL, 0x000000026c227836ULL, 0x000fe20000000000ULL,
0x0000002016167811ULL, 0x000fe400078e30ffULL, 0x000000f01d217812ULL, 0x000fe200078ec0ffULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x0000000d16177c48ULL, 0x000fc4000ffe0000ULL,
0x000000225b257210ULL, 0x000fc60007ffe0ffULL, 0x0000000117167824ULL, 0x000fe400078e0a16ULL,
0x0000000119177824ULL, 0x000fe400078e0220ULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x000000165b167248ULL, 0x000fca0007fe0000ULL, 0x00000001161d7824ULL, 0x000fca00078e0a5bULL,
0x0000001d6c00720cULL, 0x000fe40003f46070ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e680000000a00ULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818177c24ULL, 0x004fc4000f8e0217ULL, 0x0000000119187824ULL, 0x000fe400078e0210ULL,
0x0000010017167825ULL, 0x002fc800078e0014ULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0x0000002116167210ULL, 0x000fc80007f7e0ffULL, 0xfffffff019187812ULL, 0x000fe200078ee218ULL,
0x000000ffff177224ULL, 0x000fe400018e0617ULL, 0x0000000125197824ULL, 0x040fe200078e0220ULL,
0x0000000b18237c11ULL, 0x000fe2000f8e20ffULL, 0x0000001025257824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fe20003f46070ULL, 0x000000046c227836ULL, 0x000fe20000000000ULL,
0xfffffff025247812ULL, 0x000fe200078ee224ULL, 0x018a08001f187984ULL, 0x000ea40000000800ULL,
0x000000015b257824ULL, 0x000fe200078e0222ULL, 0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL,
0x0000000125247824ULL, 0x000fe200078e0210ULL, 0x00000006181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000125197824ULL, 0x040fe400078e0220ULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d2200720cULL, 0x000fc60003f46070ULL,
0x018a10001f187984ULL, 0x000ea20000000800ULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL, 0x00000006181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x000000066c1e7836ULL, 0x002fc80000000000ULL,
0x000000015b257824ULL, 0x000fe400078e021eULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000125197824ULL, 0x040fe200078e0220ULL,
0x0000001025207210ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d1e00720cULL, 0x000fc60003f46070ULL, 0x018a18001f187984ULL, 0x000ea20000000800ULL,
0xfffffff025207812ULL, 0x000fc800078ee220ULL, 0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc600078e0014ULL,
0x0000002114147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4eULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x000000015b1f7824ULL, 0x000fe200078e026cULL,
0x0000002013207811ULL, 0x000fe200078e30ffULL, 0x0000001010197824ULL, 0x000fe200078e00ffULL,
0x00016000060b7890ULL, 0x000fe2000fffe03fULL, 0x000000101f227824ULL, 0x040fe200078e00ffULL,
0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL, 0x000000011f177824ULL, 0x000fe200078e0220ULL,
0x000000f019217812ULL, 0x000fe200078ec0ffULL, 0x000000011f197824ULL, 0x000fe400078e0210ULL,
0x018a00001e147984ULL, 0x000e620000000800ULL, 0x000000021f257836ULL, 0x000fc40000000000ULL,
0xfffffff022197812ULL, 0x000fe400078ee219ULL, 0x0000000125227824ULL, 0x000fe400078e0210ULL,
0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000120197824ULL, 0x000fe400078e0225ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025227812ULL, 0x000fe400078ee222ULL,
0x000000041f257810ULL, 0x000fe20007ffe0ffULL, 0x000000061f1f7836ULL, 0x000fe20000000000ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000816177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a08001e187984ULL, 0x000ea20000000800ULL,
0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL, 0x0000000120177824ULL, 0x000fe400078e0225ULL,
0x0000000125227824ULL, 0x040fe400078e0210ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025227812ULL, 0x000fe400078ee222ULL, 0x00000006181d7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001d187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4eULL, 0x018a10001e167984ULL, 0x000ea20000000800ULL,
0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL, 0x0000000120197824ULL, 0x000fe400078e021fULL,
0x000000101f207824ULL, 0x000fe200078e00ffULL, 0x00000006161d7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001d167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a18001e187984ULL, 0x000ea40000000800ULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000011f197824ULL, 0x000fe200078e0210ULL, 0x0000002114147210ULL, 0x000fc80007f5e0ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x000000ffff157224ULL, 0x000fc600010e0615ULL,
0x0000000b19197c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e4000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fc800078510ffULL, 0x00000015ff157210ULL, 0x000fc800017fe4ffULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001b5c00720cULL, 0x000fe20003f44070ULL, 0x00000001ff1e7424ULL, 0x000fe200078e00ffULL,
0x000000031a00780cULL, 0x000fe20003f65270ULL, 0x000000205f6f7824ULL, 0x000fd800078e0210ULL,
0x00000000004ca947ULL, 0x000fea0001800000ULL, 0x000000036f00780cULL, 0x000fe20003f44070ULL,
0x0000000105057890ULL, 0x000fe2000fffe03fULL, 0x0000010000007945ULL, 0x000ff60003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00009000ff177b82ULL, 0x000e620000000800ULL,
0x000000070500728cULL, 0x000fe2000bf06070ULL, 0x0000000412167824ULL, 0x000fe200078e026fULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000216167824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x00008c00ff147b82ULL, 0x000ea20000000a00ULL,
0x0000000517187c36ULL, 0x002fc80008000000ULL, 0x0000001716177224ULL, 0x000fc800078e0218ULL,
0x0000000417147825ULL, 0x004fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18ac000014197faeULL, 0x0003e4000d12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000019000007945ULL, 0x000fe80003800000ULL, 0x00000000005c1947ULL, 0x000fea0003800000ULL,
0x0000001b5c00720cULL, 0x000fe20003f44070ULL, 0x000000011a157836ULL, 0x002fe20000000000ULL,
0x00009400000b7ab9ULL, 0x000fe20000000800ULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000315167812ULL, 0x000fc800078ec0ffULL, 0x000000ff16167207ULL, 0x000fc60005000000ULL,
0x00000002ff15a819ULL, 0x000fe40000011615ULL, 0x000000015d167824ULL, 0x000fc600078e0216ULL,
0x000000011c1c7824ULL, 0x000fe400078e0215ULL, 0x00009200ff147b82ULL, 0x000e640000000a00ULL,
0x000000401c177824ULL, 0x040fe200078e00ffULL, 0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c017187812ULL, 0x000fca00078ec0ffULL, 0x000001001b187824ULL, 0x000fc800078e0218ULL,
0x000000016f177824ULL, 0x100fe400078e0218ULL, 0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL,
0x0000000d17007c0cULL, 0x000fe2000bf46070ULL, 0x000000016f177824ULL, 0x000fc800078e0216ULL,
0x0000000417147825ULL, 0x002fd000078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000d12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4aULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b801eff1479a7ULL, 0x000e620008500006ULL,
0x000000ff6b00720cULL, 0x000fe40003f45270ULL, 0x00000015006d7202ULL, 0x002fd60000000f00ULL,
0x00000004008c2947ULL, 0x000fea0003800000ULL, 0x018b181e5b1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b18185b0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff197224ULL, 0x000fce00078e00ffULL, 0x000000101900780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416147210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011415ULL, 0x0000001407077211ULL, 0x000fca00078510ffULL,
0x000000ffff147224ULL, 0x000fca00010e0615ULL, 0x0000000207077819ULL, 0x000fc80000001214ULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000119197836ULL, 0x000fce0000000000ULL, 0x018b18185b0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001010077824ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011610ULL, 0x000000ffff167224ULL, 0x000fc600078e0008ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x00000006141b7c10ULL, 0x000fca000fffe007ULL, 0x018100001b157984ULL, 0x000e680000000800ULL,
0x018300001b147984ULL, 0x0004a20000000800ULL, 0x000000081500720bULL, 0x002fda0003f5d000ULL,
0x0000000000077806ULL, 0x000fc800010e0100ULL, 0x0000ffff07187812ULL, 0x000fe2000784c0ffULL,
0x00000001ff077424ULL, 0x000fd800078e00ffULL, 0x0000000000e0a947ULL, 0x004fea0003800000ULL,
0x000000081500720bULL, 0x000fe40003f54000ULL, 0x000000025f00780cULL, 0x000fe40003f65270ULL,
0x0000001508167209ULL, 0x000fd20007810000ULL, 0x0000000000197806ULL, 0x000fe400010e0100ULL,
0x018500161b00b388ULL, 0x0003e40000000800ULL, 0x0000991019177816ULL, 0x000fc800000000ffULL,
0x000000ff1700720cULL, 0x000fda0003f45270ULL, 0x0000000000a8a947ULL, 0x002fea0003800000ULL,
0x8000001608087221ULL, 0x000fe20000010000ULL, 0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x00000008001a7308ULL, 0x0002ac0000000800ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x00001f621a087589ULL, 0x006e6400000e0000ULL, 0x000000080b0b7220ULL, 0x082fe20000410000ULL,
0x000000080a0a7220ULL, 0x080fe20000410000ULL, 0x000000080f0f7220ULL, 0x080fe20000410000ULL,
0x000000080e0e7220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x0000000842427220ULL, 0x080fe20000410000ULL, 0x0000000845457220ULL, 0x080fe20000410000ULL,
0x0000000846467220ULL, 0x080fe20000410000ULL, 0x0000000849497220ULL, 0x080fe20000410000ULL,
0x000000084a4a7220ULL, 0x080fe20000410000ULL, 0x000000084d4d7220ULL, 0x080fe20000410000ULL,
0x000000084e4e7220ULL, 0x080fe20000410000ULL, 0x0000000851517220ULL, 0x080fe20000410000ULL,
0x0000000852527220ULL, 0x080fe20000410000ULL, 0x0000000857577220ULL, 0x080fe20000410000ULL,
0x0000000858587220ULL, 0x000fce0000410000ULL, 0x0000001a09097220ULL, 0x004fe20000410000ULL,
0x000000000044b947ULL, 0x000fec0003800000ULL, 0x00001f631a087589ULL, 0x002e6400000e0000ULL,
0x000000080d0d7220ULL, 0x082fe20000410000ULL, 0x000000080c0c7220ULL, 0x080fe20000410000ULL,
0x0000000811117220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000843437220ULL, 0x080fe20000410000ULL, 0x0000000844447220ULL, 0x080fe20000410000ULL,
0x0000000847477220ULL, 0x080fe20000410000ULL, 0x0000000848487220ULL, 0x080fe20000410000ULL,
0x000000084b4b7220ULL, 0x080fe20000410000ULL, 0x000000084c4c7220ULL, 0x080fe20000410000ULL,
0x000000084f4f7220ULL, 0x080fe20000410000ULL, 0x0000000850507220ULL, 0x080fe20000410000ULL,
0x0000000853537220ULL, 0x080fe20000410000ULL, 0x0000000856567220ULL, 0x080fe20000410000ULL,
0x0000000859597220ULL, 0x080fe20000410000ULL, 0x000000085a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff18ff7812ULL, 0x000fda0007846019ULL, 0x8000001615152221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL,
0x0000001500062308ULL, 0x000ea40000000800ULL, 0x0000000614142220ULL, 0x004fce0000410000ULL,
0x0000000914097221ULL, 0x000fe20000010000ULL, 0x000000ffff087224ULL, 0x002fce00078e0016ULL,
0x000000ff07ff7812ULL, 0x000fda000784c0ffULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000000ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6214037589ULL, 0x0002a800000e0000ULL, 0x00001f6314047589ULL, 0x0002e400000e0000ULL,
0x01300000051c783bULL, 0x0002e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x08cfe40000000000ULL, 0x000000031e1e7232ULL, 0x000fe40000000000ULL,
0x000000041d1d7232ULL, 0x080fe40000000000ULL, 0x000000041f1f7232ULL, 0x000fce0000000000ULL,
0x000000000218783bULL, 0x000f280000004200ULL, 0x000000000014783bULL, 0x002e620000004200ULL,
0x0000312018187816ULL, 0x010fe400000000ffULL, 0x0000312019197816ULL, 0x000fe400000000ffULL,
0x000031201a1a7816ULL, 0x000fe400000000ffULL, 0x000031201b1b7816ULL, 0x000fc400000000ffULL,
0x0000312014147816ULL, 0x002fe400000000ffULL, 0x0000312015157816ULL, 0x000fe400000000ffULL,
0x0000312016167816ULL, 0x000fe400000000ffULL, 0x0000312017177816ULL, 0x000fe400000000ffULL,
0x00000018ff3c723eULL, 0x000fe400020006ffULL, 0x00000019ff3d723eULL, 0x000fc400020006ffULL,
0x00000018ff34723eULL, 0x000fe400030006ffULL, 0x00000019ff35723eULL, 0x000fe400030006ffULL,
0x0000001aff30723eULL, 0x000fe200020006ffULL, 0x0000003c1c3c723cULL, 0x008fe200000018ffULL,
0x0000001bff31723eULL, 0x000fe400020006ffULL, 0x0000001aff2c723eULL, 0x000fe400030006ffULL,
0x0000001bff2d723eULL, 0x000fe200030006ffULL, 0x000000341c34723cULL, 0x000fe200000018ffULL,
0x00000014ff28723eULL, 0x000fe200020006ffULL, 0x013000005e18783bULL, 0x0002e20000000200ULL,
0x00000015ff29723eULL, 0x000fc400020006ffULL, 0x00000014ff24723eULL, 0x000fe200030006ffULL,
0x000000301c30723cULL, 0x000fe200000018ffULL, 0x00000015ff25723eULL, 0x000fe400030006ffULL,
0x00000016ff20723eULL, 0x000fe400020006ffULL, 0x00000017ff21723eULL, 0x000fe200020006ffULL,
0x0000002c1c2c723cULL, 0x000fe200000018ffULL, 0x00000016ff14723eULL, 0x000fe400030006ffULL,
0x00000017ff15723eULL, 0x000fc600030006ffULL, 0x000000281c28723cULL, 0x000fec00000018ffULL,
0x000000241c24723cULL, 0x000fec00000018ffULL, 0x000000201c20723cULL, 0x000fec00000018ffULL,
0x000000141c1c723cULL, 0x000fe200000018ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000102947ULL, 0x002fde0003800000ULL, 0x0000000318187232ULL, 0x08cfe40000000000ULL,
0x000000031a1a7232ULL, 0x000fe40000000000ULL, 0x0000000419197232ULL, 0x080fe40000000000ULL,
0x000000041b1b7232ULL, 0x000fce0000000000ULL, 0x000000006114783bULL, 0x000e620000004200ULL,
0x0000006b6200720cULL, 0x080fe20003f66070ULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x000000045c007c0cULL, 0x040fe2000bfc3070ULL, 0x000000006038783bULL, 0x000f220000004200ULL,
0x0000006b6300720cULL, 0x000fe40003f86070ULL, 0x000000045c007c0cULL, 0x000fe4000bfa3070ULL,
0x0000312014547816ULL, 0x002fe400000000ffULL, 0x0000312015557816ULL, 0x000fc400000000ffULL,
0x00000054ff14723eULL, 0x000fe400020006ffULL, 0x00000055ff15723eULL, 0x000fe400020006ffULL,
0x0000312016167816ULL, 0x000fe400000000ffULL, 0x0000312017177816ULL, 0x000fe400000000ffULL,
0x00000054ff54723eULL, 0x000fe200030006ffULL, 0x00000014183c723cULL, 0x008fe2000000183cULL,
0x00000055ff55723eULL, 0x000fcc00030006ffULL, 0x00000016ff14723eULL, 0x000fe200020006ffULL,
0x000000541834723cULL, 0x000fe20000001834ULL, 0x00000017ff15723eULL, 0x000fe400020006ffULL,
0x00000016ff16723eULL, 0x000fe400030006ffULL, 0x00000017ff17723eULL, 0x000fc600030006ffULL,
0x000000141830723cULL, 0x000fec0000001830ULL, 0x00000016182c723cULL, 0x000fe2000000182cULL,
0x0000312038147816ULL, 0x010fe200000000ffULL, 0x000000016b387836ULL, 0x000fe20000000000ULL,
0x0000312039157816ULL, 0x000fc800000000ffULL, 0x00000014ff16723eULL, 0x000fe400020006ffULL,
0x00000015ff17723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fe400030006ffULL, 0x000000386200720cULL, 0x080fe20005f66470ULL,
0x000000161828723cULL, 0x000fe20000001828ULL, 0x000000386300720cULL, 0x000fca0006786470ULL,
0x000000141824723cULL, 0x000fee0000001824ULL, 0x000031203a147816ULL, 0x000fe400000000ffULL,
0x000031203b157816ULL, 0x000fe400000000ffULL, 0x00000014ff16723eULL, 0x000fc400020006ffULL,
0x00000015ff17723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fc600030006ffULL, 0x000000161820723cULL, 0x000fec0000001820ULL,
0x00000014181c723cULL, 0x000fe2000000181cULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0a0a7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x000000350e0e7221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002051517221ULL, 0x000fe20000010000ULL, 0x0000002152527221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0c0c7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002253537221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8816ff1479a7ULL, 0x000e620008500006ULL, 0x00000002ff177819ULL, 0x000fe40000011638ULL,
0x000000045c007c0cULL, 0x000fe4000bfc3070ULL, 0x0000001738177207ULL, 0x040fe40000000000ULL,
0x00000003381a7812ULL, 0x000fe400078ec0ffULL, 0x000000045c007c0cULL, 0x000fe2000bfa3070ULL,
0x0000000217177836ULL, 0x000fe20000000000ULL, 0x00000040ff387803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000004171c7c11ULL, 0x000fe2000f8ff0ffULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ff001d7202ULL, 0x000fce0000000f00ULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000011c147836ULL, 0x000fca0000000000ULL, 0x0000001014007c0cULL, 0x000fda000bfc6070ULL,
0x00000004005ce947ULL, 0x000fea0003800000ULL, 0x000000015b1d7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010187824ULL, 0x000fe400078e00ffULL,
0x0000004013217824ULL, 0x000fe200078e021dULL, 0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL,
0x000000101d1e7824ULL, 0x000fe200078e00ffULL, 0x000000f018237812ULL, 0x000fe200078ec0ffULL,
0x000000041c187824ULL, 0x000fe400078e021bULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x000000026c207836ULL, 0x000fc40000000000ULL, 0x0000000618187819ULL, 0x000fe400000006ffULL,
0x000000015b277824ULL, 0x000fe200078e0220ULL, 0x0000000614197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0007240000000800ULL,
0x0000000d18197c48ULL, 0x008fca000ffe0000ULL, 0x0000000119187824ULL, 0x000fe400078e0a18ULL,
0x000000011d197824ULL, 0x000fc600078e0210ULL, 0x000000185b187248ULL, 0x000fe40007fe0000ULL,
0xfffffff01e197812ULL, 0x000fc600078ee219ULL, 0x00000001181d7824ULL, 0x000fe200078e0a5bULL,
0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL, 0x0000000221197836ULL, 0x000fe40000000000ULL,
0x0000000816177c24ULL, 0x010fc8000f8e0221ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d6c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a08001f187984ULL, 0x000ee20000000800ULL,
0x0000000127167824ULL, 0x042fe400078e0210ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x0000000421177836ULL, 0x000fc60000000000ULL, 0xfffffff027167812ULL, 0x000fc800078ee216ULL,
0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL, 0x00000006181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000001d2000720cULL, 0x000fe20003fc6070ULL,
0x000000046c207836ULL, 0x000fe40000000000ULL, 0x000000066c6c7836ULL, 0x000fc60000000000ULL,
0x000000205b277210ULL, 0x000fce0007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018257faeULL, 0x0003e8000f101c4eULL, 0x018a10001f167984ULL, 0x000ee20000000800ULL,
0x0000000127187824ULL, 0x042fe400078e0210ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x0000000621197836ULL, 0x000fc60000000000ULL, 0xfffffff027187812ULL, 0x000fc800078ee218ULL,
0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d2000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000015b197824ULL, 0x000fe200078e026cULL,
0x0000002314147210ULL, 0x000fc60007fde0ffULL, 0x0000000119167824ULL, 0x042fe400078e0210ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x0000001d6c00720cULL, 0x000fe20003fc6070ULL,
0x0000001019197824ULL, 0x000fca00078e00ffULL, 0xfffffff019167812ULL, 0x000fc800078ee216ULL,
0x0000000b16177c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000f101c4eULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015b6c7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010197824ULL, 0x000fe400078e00ffULL, 0x00000040131f7824ULL, 0x000fe200078e026cULL,
0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL, 0x000000026c257836ULL, 0x000fe20000000000ULL,
0x000000f019217812ULL, 0x000fe200078ec0ffULL, 0x000000016c197824ULL, 0x140fe200078e0210ULL,
0x000000046c207819ULL, 0x000fe200000006ffULL, 0x018a00001e147984ULL, 0x000e660000000800ULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000125207824ULL, 0x000fc400078e0210ULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x000000021f197836ULL, 0x000fc60000000000ULL, 0xfffffff025207812ULL, 0x000fe200078ee220ULL,
0x000000046c257836ULL, 0x000fe20000000000ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000816177c24ULL, 0x008fc8000f8e021fULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a08001e187984ULL, 0x000ee20000000800ULL, 0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL,
0x000000041f177836ULL, 0x000fe40000000000ULL, 0x0000000125207824ULL, 0x040fe400078e0210ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025207812ULL, 0x000fe400078ee220ULL,
0x00000006181d7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001d187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fca00030e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ee20000000800ULL, 0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL,
0x000000061f197836ULL, 0x000fe20000000000ULL, 0x00000006161d7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001d167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a18001e187984ULL, 0x000ee40000000800ULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000066c197836ULL, 0x000fe20000000000ULL, 0x0000002114147210ULL, 0x000fc60007fde0ffULL,
0x0000001019167824ULL, 0x002fe200078e00ffULL, 0x00000010191d7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fc600030e0615ULL, 0xfffffff0161d7812ULL, 0x000fc800078ee21dULL,
0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e4000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000001ff547424ULL, 0x000fc600078e00ffULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000001c5c00720cULL, 0x000fe20003fc4070ULL,
0x00009400000b7ab9ULL, 0x000fc60000000800ULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000e620000000a00ULL, 0x000000015d177824ULL, 0x000fe400078e021aULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016187836ULL, 0x000fc80000000000ULL, 0x0000000b17167c24ULL, 0x000fca000f8e0218ULL,
0x000000166f177210ULL, 0x000fe20007ffe0ffULL, 0x000000016f167824ULL, 0x040fe200078e0218ULL,
0x000000066f6f7c11ULL, 0x000fc6000f8e10ffULL, 0x0000000417147825ULL, 0x002fe200078e0014ULL,
0x0000000d16007c0cULL, 0x000fda000bfc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a00000146f7faeULL, 0x0003e4000f12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b7854ff5479a7ULL, 0x000e620008500006ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x004fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6214037589ULL, 0x0004e800000e0000ULL,
0x00001f6314047589ULL, 0x00046400000e0000ULL, 0x01300000661c783bULL, 0x0006a20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x082fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000006518783bULL, 0x000f280000004200ULL,
0x000000006414783bULL, 0x004ea20000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x004fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x000fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x013000006718783bULL, 0x0004e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x004fde0003800000ULL,
0x0000000318187232ULL, 0x088fe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x082fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006914783bULL, 0x000ea20000004200ULL, 0x000000ff3800720cULL, 0x000fe20003f45270ULL,
0x0000034000007945ULL, 0x000fe40003800000ULL, 0x000000006838783bULL, 0x000f220000004200ULL,
0x00003120146d7816ULL, 0x004fe400000000ffULL, 0x00003120156e7816ULL, 0x000fe400000000ffULL,
0x0000006dff14723eULL, 0x000fe400020006ffULL, 0x0000006eff15723eULL, 0x000fc400020006ffULL,
0x00003120166c7816ULL, 0x000fe400000000ffULL, 0x00003120176f7816ULL, 0x000fe400000000ffULL,
0x0000006dff16723eULL, 0x000fe200030006ffULL, 0x00000014183c723cULL, 0x008fe2000000183cULL,
0x0000006eff17723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x010fe400000000ffULL,
0x0000312039397816ULL, 0x000fc400000000ffULL, 0x0000006cff14723eULL, 0x000fe200020006ffULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x0000006fff15723eULL, 0x000fcc00020006ffULL,
0x0000006cff16723eULL, 0x000fe200030006ffULL, 0x000000141830723cULL, 0x000fe20000001830ULL,
0x0000006fff17723eULL, 0x000fcc00030006ffULL, 0x00000038ff14723eULL, 0x000fe200020006ffULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x00000039ff15723eULL, 0x000fcc00020006ffULL,
0x00000038ff16723eULL, 0x000fe200030006ffULL, 0x000000141828723cULL, 0x000fe20000001828ULL,
0x00000039ff17723eULL, 0x000fcc00030006ffULL, 0x000031203a147816ULL, 0x000fe200000000ffULL,
0x000000161824723cULL, 0x000fe20000001824ULL, 0x000031203b157816ULL, 0x000fcc00000000ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0001000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0a0a7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x000000350e0e7221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002051517221ULL, 0x000fe20000010000ULL, 0x0000002152527221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x002fc600078e0055ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x000000016b6b7836ULL, 0x000fe40000000000ULL, 0x018b8814ff1679a7ULL, 0x000e660008500006ULL,
0x0000006a6b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff1d7224ULL, 0x002fd800078e0017ULL,
0xffffffc000f4a947ULL, 0x000fea000383ffffULL, 0x000000c0040b7891ULL, 0x000fe2000f8e403fULL,
0x018b6814ffff79a7ULL, 0x0003e60008500006ULL, 0x0000000d0b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f4f008ULL, 0x0000003c00142947ULL, 0x002fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x00000002ff147819ULL, 0x000fe4000001166bULL,
0x000000036b1a7812ULL, 0x040fe400078ec0ffULL, 0x000000146b147207ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60004000000ULL, 0x0000000314147836ULL, 0x000fca0000000000ULL,
0x00000003141c7812ULL, 0x040fe400078ec0ffULL, 0x00000004141b7c11ULL, 0x000fe4000f8ff0ffULL,
0x0000000000187805ULL, 0x000fe20000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fce00078e00ffULL,
0x000000101e00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x00000016181f7210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e19ULL, 0x003d09001f00780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000001f14147211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011e1e7836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b881dff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fc800078510ffULL, 0x00000015ff157210ULL, 0x000fc800017fe4ffULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b881dff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011b147836ULL, 0x000fe20000000000ULL, 0x00000004ff6c7819ULL, 0x000fc80000011610ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x000000040060a947ULL, 0x000fea0003800000ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x000000041b167824ULL, 0x000fe200078e021cULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x00000010101d7824ULL, 0x000fe200078e00ffULL, 0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL,
0x000000026c227836ULL, 0x000fe20000000000ULL, 0x0000002016167811ULL, 0x000fe400078e30ffULL,
0x000000f01d217812ULL, 0x000fe200078ec0ffULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000d16177c48ULL, 0x000fe2000ffe0000ULL, 0x000000015b257824ULL, 0x000fc800078e0222ULL,
0x0000000117167824ULL, 0x000fe400078e0a16ULL, 0x0000000119177824ULL, 0x000fe400078e0220ULL,
0x0000000125247824ULL, 0x000fe200078e0210ULL, 0x000000165b167248ULL, 0x000fca0007fe0000ULL,
0x00000001161d7824ULL, 0x000fca00078e0a5bULL, 0x0000001d6c00720cULL, 0x000fe40003f46070ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e680000000a00ULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818177c24ULL, 0x004fc4000f8e0217ULL,
0x0000000119187824ULL, 0x000fe400078e0210ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff019187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fe200018e0617ULL,
0x0000002025197210ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x0000000b18237c11ULL, 0x000fc8000f8e20ffULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fe20003f46070ULL, 0x000000046c227836ULL, 0x000fe40000000000ULL,
0x018a08001f187984ULL, 0x000ea40000000800ULL, 0x000000015b257824ULL, 0x000fe200078e0222ULL,
0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fc60003f46070ULL, 0x018a10001f187984ULL, 0x000ea20000000800ULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002a40000000800ULL,
0x000000066c1e7836ULL, 0x002fc80000000000ULL, 0x000000015b257824ULL, 0x000fe400078e021eULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000000125207824ULL, 0x040fe200078e0210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d1e00720cULL, 0x000fe40003f46070ULL, 0x0000000425257819ULL, 0x000fe200000006ffULL,
0x018a18001f187984ULL, 0x000ea60000000800ULL, 0xfffffff025207812ULL, 0x000fc800078ee220ULL,
0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4eULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x000000015b1f7824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x000000101f227824ULL, 0x040fe200078e00ffULL, 0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000011f177824ULL, 0x000fe200078e0220ULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000021f257836ULL, 0x000fc40000000000ULL, 0xfffffff022197812ULL, 0x000fe400078ee219ULL,
0x0000000125227824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe400078e0225ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025227812ULL, 0x000fe200078ee222ULL, 0x000000041f257836ULL, 0x000fe40000000000ULL,
0x000000061f1f7836ULL, 0x000fe20000000000ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a08001e187984ULL, 0x000ea20000000800ULL, 0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL,
0x0000000125227824ULL, 0x040fe200078e0210ULL, 0x0000002520177210ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025227812ULL, 0x000fe400078ee222ULL,
0x00000006181d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ea20000000800ULL, 0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe400078e021fULL, 0x000000101f207824ULL, 0x000fe200078e00ffULL,
0x00000006161d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea40000000800ULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000011f197824ULL, 0x000fe200078e0210ULL,
0x0000002114147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff020197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000b19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7810ULL, 0x000fce0007ffe0ffULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1e7424ULL, 0x000fe200078e00ffULL, 0x000000031a00780cULL, 0x000fe20003f65270ULL,
0x000000205f6f7824ULL, 0x000fd800078e0210ULL, 0x00000000004ca947ULL, 0x000fea0001800000ULL,
0x000000036f00780cULL, 0x000fe20003f44070ULL, 0x0000000105057890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412167824ULL, 0x000fe200078e026fULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000517187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x000000011a157836ULL, 0x002fe20000000000ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000315167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16167207ULL, 0x000fc60005000000ULL, 0x00000002ff15a819ULL, 0x000fe40000011615ULL,
0x000000015d167824ULL, 0x000fc600078e0216ULL, 0x000000011c1c7824ULL, 0x000fe400078e0215ULL,
0x00009200ff147b82ULL, 0x000e640000000a00ULL, 0x000000401c177824ULL, 0x040fe200078e00ffULL,
0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c017187812ULL, 0x000fca00078ec0ffULL,
0x000001001b187824ULL, 0x000fc800078e0218ULL, 0x000000016f177824ULL, 0x100fe400078e0218ULL,
0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL, 0x0000000d17007c0cULL, 0x000fe2000bf46070ULL,
0x000000016f177824ULL, 0x000fc800078e0216ULL, 0x0000000417147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801eff1479a7ULL, 0x000e620008500006ULL, 0x000000ff6b00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018b381e5b1479a7ULL, 0x000e640008500006ULL, 0x0000001500187202ULL, 0x002fe40000000f00ULL,
0x0000000000167805ULL, 0x000fe40000015200ULL, 0x018b38185b0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018b38185b0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001010077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011610ULL,
0x000000ffff167224ULL, 0x000fc600078e0008ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000006141b7c10ULL, 0x000fca000fffe007ULL,
0x018180001b157984ULL, 0x000e680000000800ULL, 0x018380001b147984ULL, 0x0004a20000000800ULL,
0x000000081500720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000081500720bULL, 0x000fe40003f54000ULL,
0x000000035f00780cULL, 0x000fe40003f65270ULL, 0x0000001508167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018580161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001608087221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x00000008001a7308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f621a087589ULL, 0x006e6400000e0000ULL,
0x000000080b0b7220ULL, 0x082fe20000410000ULL, 0x000000080a0a7220ULL, 0x080fe20000410000ULL,
0x000000080f0f7220ULL, 0x080fe20000410000ULL, 0x000000080e0e7220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x0000000842427220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000846467220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x000000084a4a7220ULL, 0x080fe20000410000ULL,
0x000000084d4d7220ULL, 0x080fe20000410000ULL, 0x000000084e4e7220ULL, 0x080fe20000410000ULL,
0x0000000851517220ULL, 0x080fe20000410000ULL, 0x0000000852527220ULL, 0x080fe20000410000ULL,
0x0000000857577220ULL, 0x080fe20000410000ULL, 0x0000000858587220ULL, 0x000fce0000410000ULL,
0x0000001a09097220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f631a087589ULL, 0x002e6400000e0000ULL, 0x000000080d0d7220ULL, 0x082fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000843437220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000847477220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x000000084b4b7220ULL, 0x080fe20000410000ULL,
0x000000084c4c7220ULL, 0x080fe20000410000ULL, 0x000000084f4f7220ULL, 0x080fe20000410000ULL,
0x0000000850507220ULL, 0x080fe20000410000ULL, 0x0000000853537220ULL, 0x080fe20000410000ULL,
0x0000000856567220ULL, 0x080fe20000410000ULL, 0x0000000859597220ULL, 0x080fe20000410000ULL,
0x000000085a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001615152221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL, 0x0000001500062308ULL, 0x000ea40000000800ULL,
0x0000000614142220ULL, 0x004fce0000410000ULL, 0x0000000914097221ULL, 0x000fe20000010000ULL,
0x000000ffff087224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6214037589ULL, 0x0002a800000e0000ULL,
0x00001f6314047589ULL, 0x0002e400000e0000ULL, 0x01380000051c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x08cfe40000000000ULL,
0x000000031e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x080fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000312018187816ULL, 0x010fe400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x000031201a1a7816ULL, 0x000fe400000000ffULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000312014147816ULL, 0x002fe400000000ffULL,
0x0000312015157816ULL, 0x000fe400000000ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000018ff3c723eULL, 0x000fe400020006ffULL,
0x00000019ff3d723eULL, 0x000fc400020006ffULL, 0x00000018ff34723eULL, 0x000fe400030006ffULL,
0x00000019ff35723eULL, 0x000fe400030006ffULL, 0x0000001aff30723eULL, 0x000fe200020006ffULL,
0x0000003c1c3c723cULL, 0x008fe200000018ffULL, 0x0000001bff31723eULL, 0x000fe400020006ffULL,
0x0000001aff2c723eULL, 0x000fe400030006ffULL, 0x0000001bff2d723eULL, 0x000fe200030006ffULL,
0x000000341c34723cULL, 0x000fe200000018ffULL, 0x00000014ff28723eULL, 0x000fe200020006ffULL,
0x013800005e18783bULL, 0x0002e20000000200ULL, 0x00000015ff29723eULL, 0x000fc400020006ffULL,
0x00000014ff24723eULL, 0x000fe200030006ffULL, 0x000000301c30723cULL, 0x000fe200000018ffULL,
0x00000015ff25723eULL, 0x000fe400030006ffULL, 0x00000016ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff21723eULL, 0x000fe200020006ffULL, 0x0000002c1c2c723cULL, 0x000fe200000018ffULL,
0x00000016ff14723eULL, 0x000fe400030006ffULL, 0x00000017ff15723eULL, 0x000fc600030006ffULL,
0x000000281c28723cULL, 0x000fec00000018ffULL, 0x000000241c24723cULL, 0x000fec00000018ffULL,
0x000000201c20723cULL, 0x000fec00000018ffULL, 0x000000141c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x08cfe40000000000ULL, 0x000000031a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x000000006114783bULL, 0x000e620000004200ULL, 0x0000006b6200720cULL, 0x080fe20003f66070ULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x000000045c007c0cULL, 0x040fe2000bfc3070ULL,
0x000000006038783bULL, 0x000f220000004200ULL, 0x0000006b6300720cULL, 0x000fe40003f86070ULL,
0x000000045c007c0cULL, 0x000fe4000bfa3070ULL, 0x0000312014547816ULL, 0x002fe400000000ffULL,
0x0000312015557816ULL, 0x000fc400000000ffULL, 0x00000054ff14723eULL, 0x000fe400020006ffULL,
0x00000055ff15723eULL, 0x000fe400020006ffULL, 0x0000312016167816ULL, 0x000fe400000000ffULL,
0x0000312017177816ULL, 0x000fe400000000ffULL, 0x00000054ff54723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x00000055ff55723eULL, 0x000fcc00030006ffULL,
0x00000016ff14723eULL, 0x000fe200020006ffULL, 0x000000541834723cULL, 0x000fe20000001834ULL,
0x00000017ff15723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe400030006ffULL,
0x00000017ff17723eULL, 0x000fc600030006ffULL, 0x000000141830723cULL, 0x000fec0000001830ULL,
0x00000016182c723cULL, 0x000fe2000000182cULL, 0x0000312038147816ULL, 0x010fe200000000ffULL,
0x000000016b387836ULL, 0x000fe20000000000ULL, 0x0000312039157816ULL, 0x000fc800000000ffULL,
0x00000014ff16723eULL, 0x000fe400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fe400030006ffULL,
0x000000386200720cULL, 0x080fe20005f66470ULL, 0x000000161828723cULL, 0x000fe20000001828ULL,
0x000000386300720cULL, 0x000fca0006786470ULL, 0x000000141824723cULL, 0x000fee0000001824ULL,
0x000031203a147816ULL, 0x000fe400000000ffULL, 0x000031203b157816ULL, 0x000fe400000000ffULL,
0x00000014ff16723eULL, 0x000fc400020006ffULL, 0x00000015ff17723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400030006ffULL, 0x00000015ff15723eULL, 0x000fc600030006ffULL,
0x000000161820723cULL, 0x000fec0000001820ULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x000000350e0e7221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002253537221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8816ff1479a7ULL, 0x000e620008500006ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000045c007c0cULL, 0x000fe4000bfc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x000000045c007c0cULL, 0x000fe2000bfa3070ULL, 0x0000000317177836ULL, 0x000fe20000000000ULL,
0x00000040ff387803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000004171c7c11ULL, 0x000fe2000f8ff0ffULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fc80007fde1ffULL, 0x0000001517157210ULL, 0x000fe400037fe5ffULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000011c147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bfc6070ULL, 0x00000004005ce947ULL, 0x000fea0003800000ULL,
0x000000015b1d7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010187824ULL, 0x000fe400078e00ffULL, 0x0000004013217824ULL, 0x000fe200078e021dULL,
0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101d1e7824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x000000041c187824ULL, 0x000fe400078e021bULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x000000026c207836ULL, 0x000fc40000000000ULL,
0x0000004018187824ULL, 0x000fe400078e00ffULL, 0x000000015b277824ULL, 0x000fe200078e0220ULL,
0x0000000614197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0007240000000800ULL, 0x0000000d18197c48ULL, 0x008fc8000ffe0000ULL,
0x0000001918187210ULL, 0x000fe20007ffe1ffULL, 0x000000011d197824ULL, 0x000fc600078e0210ULL,
0x000000185b187248ULL, 0x000fe40007fe0000ULL, 0xfffffff01e197812ULL, 0x000fc600078ee219ULL,
0x00000001181d7824ULL, 0x000fe200078e0a5bULL, 0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000221197836ULL, 0x000fe40000000000ULL, 0x0000000816177c24ULL, 0x010fc8000f8e0221ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d6c00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a08001f187984ULL, 0x000ee20000000800ULL, 0x0000000127167824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000421177836ULL, 0x000fc60000000000ULL,
0xfffffff027167812ULL, 0x000fc800078ee216ULL, 0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x0000001d2000720cULL, 0x000fe20003fc6070ULL, 0x000000046c207836ULL, 0x000fe40000000000ULL,
0x000000066c6c7836ULL, 0x000fe40000000000ULL, 0x000000015b277824ULL, 0x000fd000078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000f101c4eULL,
0x018a10001f167984ULL, 0x000ee20000000800ULL, 0x0000001027187210ULL, 0x002fe20007ffe0ffULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000621197836ULL, 0x000fc60000000000ULL,
0xfffffff027187812ULL, 0x000fc800078ee218ULL, 0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d2000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a18001f187984ULL, 0x000ee40000000800ULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002314147210ULL, 0x000fc60007fde0ffULL,
0x0000000119167824ULL, 0x042fe400078e0210ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000001d6c00720cULL, 0x000fe20003fc6070ULL, 0x0000001019197824ULL, 0x000fca00078e00ffULL,
0xfffffff019167812ULL, 0x000fc800078ee216ULL, 0x0000000b16177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4eULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015b6c7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010197824ULL, 0x000fe400078e00ffULL,
0x00000040131f7824ULL, 0x000fe200078e026cULL, 0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000106c207824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000016c197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000026c257836ULL, 0x000fc40000000000ULL, 0xfffffff020197812ULL, 0x000fe400078ee219ULL,
0x0000000125207824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x000000021f197810ULL, 0x000fc80007ffe0ffULL,
0xfffffff025207812ULL, 0x000fe200078ee220ULL, 0x000000046c257836ULL, 0x000fe20000000000ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000816177c24ULL, 0x008fc8000f8e021fULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a08001e187984ULL, 0x000ee20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000041f177836ULL, 0x000fe40000000000ULL,
0x0000000125207824ULL, 0x040fe400078e0210ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe400078ee220ULL, 0x00000006181d7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001d187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4eULL, 0x018a10001e167984ULL, 0x000ee20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000061f197836ULL, 0x000fe20000000000ULL,
0x00000006161d7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000066c197836ULL, 0x000fe20000000000ULL,
0x0000002114147210ULL, 0x000fc60007fde0ffULL, 0x00000001191d7824ULL, 0x040fe200078e0210ULL,
0x0000000419167819ULL, 0x002fe200000006ffULL, 0x000000ffff157224ULL, 0x000fc600030e0615ULL,
0xfffffff0161d7812ULL, 0x000fc800078ee21dULL, 0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff547424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5c00720cULL, 0x000fe20003fc4070ULL, 0x00009400000b7ab9ULL, 0x000fc60000000800ULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60007000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x000000015d177824ULL, 0x000fe400078e021aULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016187836ULL, 0x000fc80000000000ULL,
0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL, 0x000000016f177824ULL, 0x040fe200078e0216ULL,
0x000000186f167210ULL, 0x000fe40007ffe0ffULL, 0x000000066f6f7c11ULL, 0x000fe2000f8e10ffULL,
0x0000000417147825ULL, 0x002fe200078e0014ULL, 0x0000000d16007c0cULL, 0x000fda000bfc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a00000146f7faeULL, 0x0003e4000f12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b7854ff5479a7ULL, 0x000e620008500006ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x004fc800000000ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6214037589ULL, 0x0004e800000e0000ULL, 0x00001f6314047589ULL, 0x00046400000e0000ULL,
0x01380000661c783bULL, 0x0006a20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x08cfe40000000000ULL, 0x000000031e1e7232ULL, 0x000fe40000000000ULL,
0x000000041d1d7232ULL, 0x082fe40000000000ULL, 0x000000041f1f7232ULL, 0x000fce0000000000ULL,
0x000000006518783bULL, 0x000f280000004200ULL, 0x000000006414783bULL, 0x004ea20000004200ULL,
0x0000312018187816ULL, 0x010fe400000000ffULL, 0x0000312019197816ULL, 0x000fe400000000ffULL,
0x000031201a1a7816ULL, 0x000fe400000000ffULL, 0x000031201b1b7816ULL, 0x000fc400000000ffULL,
0x0000312014147816ULL, 0x004fe400000000ffULL, 0x0000312015157816ULL, 0x000fe400000000ffULL,
0x0000312016167816ULL, 0x000fe400000000ffULL, 0x0000312017177816ULL, 0x000fe400000000ffULL,
0x00000018ff3c723eULL, 0x000fe400020006ffULL, 0x00000019ff3d723eULL, 0x000fc400020006ffULL,
0x00000018ff34723eULL, 0x000fe400030006ffULL, 0x00000019ff35723eULL, 0x000fe400030006ffULL,
0x0000001aff30723eULL, 0x000fe200020006ffULL, 0x0000003c1c3c723cULL, 0x000fe200000018ffULL,
0x0000001bff31723eULL, 0x000fe400020006ffULL, 0x0000001aff2c723eULL, 0x000fe400030006ffULL,
0x0000001bff2d723eULL, 0x000fe200030006ffULL, 0x000000341c34723cULL, 0x000fe200000018ffULL,
0x00000014ff28723eULL, 0x000fe200020006ffULL, 0x013800006718783bULL, 0x0004e20000000200ULL,
0x00000015ff29723eULL, 0x000fc400020006ffULL, 0x00000014ff24723eULL, 0x000fe200030006ffULL,
0x000000301c30723cULL, 0x000fe200000018ffULL, 0x00000015ff25723eULL, 0x000fe400030006ffULL,
0x00000016ff20723eULL, 0x000fe400020006ffULL, 0x00000017ff21723eULL, 0x000fe200020006ffULL,
0x0000002c1c2c723cULL, 0x000fe200000018ffULL, 0x00000016ff14723eULL, 0x000fe400030006ffULL,
0x00000017ff15723eULL, 0x000fc600030006ffULL, 0x000000281c28723cULL, 0x000fec00000018ffULL,
0x000000241c24723cULL, 0x000fec00000018ffULL, 0x000000201c20723cULL, 0x000fec00000018ffULL,
0x000000141c1c723cULL, 0x000fe200000018ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000102947ULL, 0x004fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000000000ULL,
0x000000031a1a7232ULL, 0x000fe40000000000ULL, 0x0000000419197232ULL, 0x082fe40000000000ULL,
0x000000041b1b7232ULL, 0x000fce0000000000ULL, 0x000000006914783bULL, 0x000ea20000004200ULL,
0x000000ff3800720cULL, 0x000fe20003f45270ULL, 0x0000034000007945ULL, 0x000fe40003800000ULL,
0x000000006838783bULL, 0x000f220000004200ULL, 0x00003120146d7816ULL, 0x004fe400000000ffULL,
0x00003120156e7816ULL, 0x000fe400000000ffULL, 0x0000006dff14723eULL, 0x000fe400020006ffULL,
0x0000006eff15723eULL, 0x000fc400020006ffULL, 0x00003120166c7816ULL, 0x000fe400000000ffULL,
0x00003120176f7816ULL, 0x000fe400000000ffULL, 0x0000006dff16723eULL, 0x000fe200030006ffULL,
0x00000014183c723cULL, 0x008fe2000000183cULL, 0x0000006eff17723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x010fe400000000ffULL, 0x0000312039397816ULL, 0x000fc400000000ffULL,
0x0000006cff14723eULL, 0x000fe200020006ffULL, 0x000000161834723cULL, 0x000fe20000001834ULL,
0x0000006fff15723eULL, 0x000fcc00020006ffULL, 0x0000006cff16723eULL, 0x000fe200030006ffULL,
0x000000141830723cULL, 0x000fe20000001830ULL, 0x0000006fff17723eULL, 0x000fcc00030006ffULL,
0x00000038ff14723eULL, 0x000fe200020006ffULL, 0x00000016182c723cULL, 0x000fe2000000182cULL,
0x00000039ff15723eULL, 0x000fcc00020006ffULL, 0x00000038ff16723eULL, 0x000fe200030006ffULL,
0x000000141828723cULL, 0x000fe20000001828ULL, 0x00000039ff17723eULL, 0x000fcc00030006ffULL,
0x000031203a147816ULL, 0x000fe200000000ffULL, 0x000000161824723cULL, 0x000fe20000001824ULL,
0x000031203b157816ULL, 0x000fcc00000000ffULL, 0x00000014ff16723eULL, 0x000fe400020006ffULL,
0x00000015ff17723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fc600030006ffULL, 0x000000161820723cULL, 0x000fec0000001820ULL,
0x00000014181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x000000350e0e7221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002051517221ULL, 0x000fe20000010000ULL,
0x0000002152527221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x002fc600078e0055ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0c0c7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002253537221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x000000016b6b7836ULL, 0x000fe40000000000ULL,
0x018b8814ff1679a7ULL, 0x000e660008500006ULL, 0x0000006a6b00720cULL, 0x000fe20003f46070ULL,
0x000000ffff1d7224ULL, 0x002fd800078e0017ULL, 0xffffffc000f4a947ULL, 0x000fea000383ffffULL,
0x018b7014ffff79a7ULL, 0x0003e40008500006ULL, 0x0000000104047890ULL, 0x000fc8000fffe03fULL,
0x000000100400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0xffffff0800708947ULL, 0x000fea000383ffffULL, 0x00000010ff007c0cULL, 0x000fe2000bf05270ULL,
0x000000ffff147224ULL, 0x002fe400078e0011ULL, 0x000000ffff107224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000cULL, 0x000000ffff0d7224ULL, 0x000fcc00078e000aULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x0180000009007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x000113e000047802ULL, 0x000fce0000000f00ULL, 0x0000007c00b47944ULL, 0x004fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000900007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x006fc80000000009ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f240000000a00ULL, 0x0000000e02037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x000f640000000000ULL, 0x00000002ff077819ULL, 0x022fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x01cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000000b040b7220ULL, 0x042fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000004204427220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004604467220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004a044a7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000004e044e7220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000005204527220ULL, 0x040fe20000410000ULL,
0x0000005704577220ULL, 0x040fe20000410000ULL, 0x0000005804587220ULL, 0x000fe20000410000ULL,
0x0000001005107220ULL, 0x044fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000004005407220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000004405447220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004805487220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004c054c7220ULL, 0x040fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005005507220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005905597220ULL, 0x040fe20000410000ULL, 0x0000005a055a7220ULL, 0x000fce0000410000ULL,
0x0000000000167919ULL, 0x000e620000000000ULL, 0x000000065f5f7c11ULL, 0x000fe2000f8e58ffULL,
0x00000000000479c3ULL, 0x000ee20000002600ULL, 0x0000004d4e4d723eULL, 0x000fce00000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000515251723eULL, 0x000fe400000000ffULL,
0x000000575857723eULL, 0x000fe400000000ffULL, 0x000000434443723eULL, 0x000fc400000000ffULL,
0x000000474847723eULL, 0x000fe400000000ffULL, 0x0000004b4c4b723eULL, 0x000fe400000000ffULL,
0x0000004f504f723eULL, 0x000fe400000000ffULL, 0x000000535653723eULL, 0x000fe400000000ffULL,
0x000000595a59723eULL, 0x000fe400000000ffULL, 0x000054104b4e7816ULL, 0x000fc4000000004fULL,
0x000076324b4f7816ULL, 0x000fe4000000004fULL, 0x0000541053587816ULL, 0x000fe40000000059ULL,
0x00000002ff077819ULL, 0x002fe40000011616ULL, 0x0000000216007812ULL, 0x040fe400078ec0ffULL,
0x0000000816057811ULL, 0x000fe200078ff0ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000000700027211ULL, 0x004fc400078ff8ffULL, 0x0000000500037211ULL, 0x000fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000307087819ULL, 0x040fe200000006ffULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000763253597816ULL, 0x000fe20000000059ULL,
0x0000000202007836ULL, 0x000fe20000000000ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL,
0x0000000402037836ULL, 0x000fe40000000000ULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0xfffffff805067812ULL, 0x000fc400078ee200ULL, 0x00000003ff057819ULL, 0x100fe40000011616ULL,
0xfffffff809007812ULL, 0x000fe200078ee202ULL, 0x0000000602027836ULL, 0x000fe20000000000ULL,
0xfffffff808087812ULL, 0x000fe200078ee203ULL, 0x0000000105047824ULL, 0x000fe400078e0216ULL,
0x000120005f037836ULL, 0x000fe20000000000ULL, 0xfffffff8070a7812ULL, 0x000fe200078ee202ULL,
0x0000000816027824ULL, 0x000fe200078e00ffULL, 0x0000000704077812ULL, 0x000fe200078ec0ffULL,
0x0000001000047824ULL, 0x000fc400078e0203ULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x0ffffff807007812ULL, 0x000fe200078ef816ULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x0000000716167812ULL, 0x000fe200078ec0ffULL, 0x0000001008087824ULL, 0x100fe400078e0203ULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0x0000000802037812ULL, 0x000fe200078ec0ffULL,
0x00000010005f7824ULL, 0x000fe200078e025fULL, 0x0000000b0d00723eULL, 0x000fe400000000ffULL,
0x0000000f0e02723eULL, 0x000fe200000000ffULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x0000000c030c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000103067824ULL, 0x040fe200078e0206ULL,
0x00005410000e7816ULL, 0x040fe20000000002ULL, 0x0000000103087824ULL, 0x040fe200078e0208ULL,
0x00007632000f7816ULL, 0x000fe20000000002ULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x000000414200723eULL, 0x000fc400000000ffULL, 0x000000454602723eULL, 0x000fe200000000ffULL,
0x0000000e04007388ULL, 0x0003e20000000a00ULL, 0x000000494a03723eULL, 0x000fe400000000ffULL,
0x0000541043467816ULL, 0x140fe40000000047ULL, 0x0000763243477816ULL, 0x000fe40000000047ULL,
0x1ffffff8165b7812ULL, 0x000fe400078ef85bULL, 0x00005410000e7816ULL, 0x002fc40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x000000101100723eULL, 0x000fe400000000ffULL,
0x000000144002723eULL, 0x000fe200000000ffULL, 0x0000000e06007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x142fe4000000004dULL, 0x00007632030f7816ULL, 0x000fca000000004dULL,
0x0000000e08007388ULL, 0x0003e40000000a00ULL, 0x00005410510e7816ULL, 0x142fe40000000057ULL,
0x00007632510f7816ULL, 0x000fca0000000057ULL, 0x0000000e0a007388ULL, 0x0003e40000000a00ULL,
0x00005410000e7816ULL, 0x142fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x00008400ff007b82ULL, 0x000e660000000800ULL, 0x0000000e0c007388ULL, 0x000fe80000000a00ULL,
0x0004004606007388ULL, 0x000fe80000000a00ULL, 0x0004004e08007388ULL, 0x000fe80000000a00ULL,
0x000400580a007388ULL, 0x000fe20000000a00ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x012000005f0c7984ULL, 0x000ea20000000c00ULL, 0x0000000012127224ULL, 0x082fe400078e02ffULL,
0x0000000405057e24ULL, 0x008fe2000f8e0200ULL, 0x0000860000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000512057211ULL, 0x000fca00078010ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000000405027c11ULL, 0x000fc8000f8048ffULL, 0x0000000505037c11ULL, 0x000fc600080f4c00ULL,
0x000000105b027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x004fe2000c101d0eULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000030300780cULL, 0x000fe20003f44070ULL,
0x00009200ff087b82ULL, 0x000e620000000a00ULL, 0x000000405f4c7824ULL, 0x040fe200078e00ffULL,
0x0000940000087ab9ULL, 0x000fe20000000800ULL, 0x0000002003057836ULL, 0x000fe20000000000ULL,
0x000000065f4a7c11ULL, 0x000fe2000f8e40ffULL, 0x000000085d007c24ULL, 0x000fe4000f8e024cULL,
0x000000014c067824ULL, 0x040fe200078e0203ULL, 0x00009a00ff0c7b82ULL, 0x000ea20000000a00ULL,
0x000000014c0f7824ULL, 0x000fc400078e0205ULL, 0x0000000100077824ULL, 0x100fe200078e0203ULL,
0x0000000d06007c0cULL, 0x000fe2000bf06070ULL, 0x000000041202a824ULL, 0x000fe200078e0203ULL,
0x0000000d0f007c0cULL, 0x000fe2000bf26070ULL, 0x0000000100057824ULL, 0x000fe200078e0205ULL,
0x00009000ff04ab82ULL, 0x000ee20000000800ULL, 0x000000020200a824ULL, 0x000fe200078e00ffULL,
0x000000075f00ac0cULL, 0x000fe4000bf66070ULL, 0x0000004a030f7211ULL, 0x000fe200078e10ffULL,
0x0000000407067825ULL, 0x002fc600078e0008ULL, 0x00008c00ff0aab82ULL, 0x000e620000000a00ULL,
0x0000000405087825ULL, 0x000fc800078e0008ULL, 0x000000040005a224ULL, 0x008fe200078e025fULL,
0x000000065f00ac11ULL, 0x000fe2000f8e20ffULL, 0x00000001ff047424ULL, 0x000fc800078e00ffULL,
0x000000040311a824ULL, 0x000fe400078e0200ULL, 0x0000000e0c007981ULL, 0x004522000c1e9900ULL,
0x00000004050aa825ULL, 0x002fe400078e000aULL, 0x018ad004ff0479a7ULL, 0x000ea20008500006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18600000060f7faeULL, 0x0005e8000c12184eULL,
0x18680000080f7faeULL, 0x0005e8000c92184eULL, 0x18a800000a11afaeULL, 0x0005e8000d92184eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000001ff0500788cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000001000a40947ULL, 0x004fea0003800000ULL, 0x00000003ff027819ULL, 0x100fe40000011603ULL,
0x000000065f087c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d4c0d7c48ULL, 0x000fe2000ffe0000ULL,
0x0000000402097824ULL, 0x000fe200078e024aULL, 0x000000700e047812ULL, 0x000fe200078ec0ffULL,
0x00000040130a7824ULL, 0x000fe200078e0202ULL, 0x000000065f0c7c11ULL, 0x000fe2000f8e70ffULL,
0x0000000102117824ULL, 0x000fe200078e0203ULL, 0x0186000009077984ULL, 0x000e620000000800ULL,
0x000000010d0d7824ULL, 0x000fc600078e0a4cULL, 0x0000000711147812ULL, 0x000fe400078ec0ffULL,
0x0000000d0200720cULL, 0x000fe40003f06070ULL, 0x0ffffff814147812ULL, 0x000fe200078ef803ULL,
0x0000000407107824ULL, 0x002fe400078e0208ULL, 0x00008a00ff067b82ULL, 0x000e660000000a00ULL,
0x018a8000100b7984ULL, 0x000ea40000000800ULL, 0x000000040b0b7c24ULL, 0x004fc8000f8e020aULL,
0x000001000b0e7825ULL, 0x002fc800078e0006ULL, 0x000020000c0b7836ULL, 0x000fe20000000000ULL,
0x0000000e04107210ULL, 0x000fe20007f3e0ffULL, 0x00000004020c7836ULL, 0x000fe40000000000ULL,
0x0000001014157824ULL, 0x000fe400078e020bULL, 0x000000ffff117224ULL, 0x000fe200008e060fULL,
0x000000030c177819ULL, 0x040fe200000006ffULL, 0x000000010c147824ULL, 0x000fc600078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000008020c7836ULL, 0x000fe20000000000ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x01861000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000040a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x0000000c020c7836ULL, 0x000fe40000000000ULL, 0x01862000090f7984ULL, 0x000ea60000000800ULL,
0x000000030c177819ULL, 0x000fe200000006ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000080a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000010020c7836ULL, 0x000fe40000000000ULL, 0x01863000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000000c0a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000014020c7836ULL, 0x000fe40000000000ULL, 0x01864000090f7984ULL, 0x000ea60000000800ULL,
0x000000030c177819ULL, 0x000fe200000006ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000100a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000018020c7836ULL, 0x000fe40000000000ULL, 0x01865000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000140a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x0000001c020c7836ULL, 0x000fe40000000000ULL, 0x01866000090f7984ULL, 0x000ea60000000800ULL,
0x000000030c177819ULL, 0x000fe200000006ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000180a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000020020c7836ULL, 0x000fe40000000000ULL, 0x01867000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000001c0a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000024020c7836ULL, 0x000fe40000000000ULL, 0x01868000090f7984ULL, 0x000ea60000000800ULL,
0x000000030c177819ULL, 0x000fe200000006ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000200a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000028020c7836ULL, 0x000fe40000000000ULL, 0x01869000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000240a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x0000002c020c7836ULL, 0x000fe40000000000ULL, 0x0186a000090f7984ULL, 0x000ea60000000800ULL,
0x000000030c177819ULL, 0x000fe200000006ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000280a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000030020c7836ULL, 0x000fe40000000000ULL, 0x0186b000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000002c0a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000034020c7836ULL, 0x000fe40000000000ULL, 0x0186c000090f7984ULL, 0x000ea60000000800ULL,
0x000000030c177819ULL, 0x000fe200000006ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000300a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000038020c7836ULL, 0x000fe40000000000ULL, 0x0186d000090f7984ULL, 0x000ea20000000800ULL,
0x0000003c02027836ULL, 0x000fe40000000000ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fc400078e0203ULL,
0x0000000102037824ULL, 0x000fc600078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000340a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fc60003f06070ULL,
0x0186e000090f7984ULL, 0x000ea20000000800ULL, 0x0000001014117824ULL, 0x002fe400078e020bULL,
0x0000003c0a157836ULL, 0x000fe40000000000ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000380a0f7836ULL, 0x000fe20000000000ULL, 0x00000003020a7819ULL, 0x000fe400000006ffULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e040e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e2000c101c4eULL, 0x0000000d0200720cULL, 0x000fc60003f06070ULL,
0x0186f00009097984ULL, 0x000ea40000000800ULL, 0x0000000409087824ULL, 0x004fcc00078e0208ULL,
0x018a800008087984ULL, 0x000ea40000000800ULL, 0x0000000408157c24ULL, 0x004fc8000f8e0215ULL,
0x0000010015067825ULL, 0x000fc600078e0006ULL, 0x0000000604027210ULL, 0x000fe40007f3e0ffULL,
0xfffffff80a047812ULL, 0x000fc600078ee203ULL, 0x000000ffff037224ULL, 0x000fe400008e0607ULL,
0x00000010040b7824ULL, 0x000fca00078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e2000c101c4eULL, 0x0000001000587947ULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x100fe40000011603ULL, 0x000000065f087c11ULL, 0x040fe4000f8e20ffULL,
0x000000065f0f7c11ULL, 0x000fe2000f8e70ffULL, 0x00000004040b7824ULL, 0x040fe400078e024aULL,
0x00000040130a7824ULL, 0x000fe400078e0204ULL, 0x0000000104027824ULL, 0x000fe200078e0203ULL,
0x018600000b077984ULL, 0x000e680000000800ULL, 0x0000000702147812ULL, 0x000fe200078ec0ffULL,
0x000020000f027836ULL, 0x000fc60000000000ULL, 0x0ffffff814117812ULL, 0x000fca00078ef803ULL,
0x0000001011157824ULL, 0x000fe400078e0202ULL, 0x0000000407107824ULL, 0x002fe400078e0208ULL,
0x00008a00ff067b82ULL, 0x000e660000000a00ULL, 0x018a800010097984ULL, 0x0004e40000000800ULL,
0x0000000404107836ULL, 0x004fc80000000000ULL, 0x0000000110117824ULL, 0x040fe200078e0203ULL,
0x0000000310167819ULL, 0x000fe200000006ffULL, 0x0000000409097c24ULL, 0x008fc8000f8e020aULL,
0x00000100090c7825ULL, 0x002fe200078e0006ULL, 0x000000700e097812ULL, 0x000fc800078ec0ffULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018610000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000008040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000040a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x018620000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000000c04107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe200078e0202ULL, 0x0000000310167819ULL, 0x040fe200000006ffULL,
0x0000000110117824ULL, 0x000fe400078e0203ULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000080a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018630000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000010040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x0000000c0a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x018640000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000001404107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe200078e0202ULL, 0x0000000310167819ULL, 0x040fe200000006ffULL,
0x0000000110117824ULL, 0x000fe400078e0203ULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000100a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018650000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000018040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000140a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x018660000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000001c04107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe200078e0202ULL, 0x0000000310167819ULL, 0x040fe200000006ffULL,
0x0000000110117824ULL, 0x000fe400078e0203ULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000180a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018670000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000020040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x0000001c0a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x018680000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000002404107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe200078e0202ULL, 0x0000000310167819ULL, 0x040fe200000006ffULL,
0x0000000110117824ULL, 0x000fe400078e0203ULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000200a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018690000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000028040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000240a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x0186a0000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000002c04107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe200078e0202ULL, 0x0000000310167819ULL, 0x040fe200000006ffULL,
0x0000000110117824ULL, 0x000fe400078e0203ULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000280a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x0186b0000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000030040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x0000002c0a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x0186c0000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000003404107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe200078e0202ULL, 0x0000000310117210ULL, 0x000fe20007ffe0ffULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000300a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x0186d0000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fca00078ee211ULL,
0x000000100f0f7824ULL, 0x000fe400078e0202ULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000340a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x0002a40000000800ULL,
0x0000003804147836ULL, 0x002fe20000000000ULL, 0x0000003c04047810ULL, 0x000fc60007ffe0ffULL,
0x0000000114157824ULL, 0x140fe400078e0203ULL, 0x0000000814147824ULL, 0x000fe400078e00ffULL,
0x0000000104037824ULL, 0x040fe400078e0203ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0xfffffff814157812ULL, 0x000fc800078ee215ULL, 0xfffffff804037812ULL, 0x000fe200078ee203ULL,
0x0000001015157824ULL, 0x000fc800078e0202ULL, 0x0000001003037824ULL, 0x000fe400078e0202ULL,
0x000000040c0d7c24ULL, 0x004fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff117224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e8000b901c4eULL,
0x0186e0000b0d7984ULL, 0x000ea20000000800ULL, 0x0000003c0a0f7836ULL, 0x002fe40000000000ULL,
0x000000040d0e7824ULL, 0x004fe400078e0208ULL, 0x000000380a0d7836ULL, 0x000fc60000000000ULL,
0x018a80000e0c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c0c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e8000b901c4eULL, 0x0186f0000b0b7984ULL, 0x000ea40000000800ULL,
0x000000040b087824ULL, 0x004fcc00078e0208ULL, 0x018a800008087984ULL, 0x000ea40000000800ULL,
0x00000004080f7c24ULL, 0x004fc8000f8e020fULL, 0x000001000f067825ULL, 0x000fc600078e0006ULL,
0x0000000906067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e6000b901c4eULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x002fce0000015200ULL, 0x018ad005ff0075a7ULL, 0x000e640008000146ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x0000000602097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011407ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000204047819ULL, 0x000fc80000001207ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x018ad005ff0075a7ULL, 0x000e640008000146ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x000000205f027824ULL, 0x002fca00078e0202ULL,
0x00000003ff037819ULL, 0x000fe40000011602ULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe03037812ULL, 0x000fc600078ec0ffULL, 0x0000000102047836ULL, 0x000fe20000000000ULL,
0x0000000302057210ULL, 0x000fe20007ffe0ffULL, 0x0000002002077824ULL, 0x040fe400078e00ffULL,
0x0000000103067824ULL, 0x000fe200078e0204ULL, 0x0000001f05057812ULL, 0x000fe200078ec0ffULL,
0x0000002002087824ULL, 0x000fe400078e00ffULL, 0x0000001003037836ULL, 0x000fe20000000000ULL,
0x0000001f06067812ULL, 0x000fe400078ec0ffULL, 0x000001e008057812ULL, 0x000fc400078ee205ULL,
0x000001e007067812ULL, 0x000fe200078ee206ULL, 0x0000000102077824ULL, 0x100fe200078e0203ULL,
0x0000000605057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000104037824ULL, 0x000fe200078e0203ULL,
0x0000000606067c11ULL, 0x000fe2000f8e20ffULL, 0x0000002002047824ULL, 0x040fe200078e00ffULL,
0x0000001f07077812ULL, 0x000fe200078ec0ffULL, 0x00000000050c7984ULL, 0x000e620000000c00ULL,
0x0000002002027824ULL, 0x000fe200078e00ffULL, 0x0000001f03037812ULL, 0x000fe400078ec0ffULL,
0x0000000006087984ULL, 0x000ea20000000c00ULL, 0x000001e004077812ULL, 0x000fc400078ee207ULL,
0x000001e002037812ULL, 0x000fe200078ee203ULL, 0x00000001ff027424ULL, 0x000fe200078e00ffULL,
0x0000000607077c11ULL, 0x000fe4000f8e20ffULL, 0x0000000603047c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff147224ULL, 0x002fe200078e000cULL, 0x0000000d00187202ULL, 0x000fe20000000f00ULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fc400078e000aULL, 0x000000ffff1a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fe200078e000bULL, 0x0000001405007388ULL, 0x000fe20000000c00ULL,
0x000000ffff197224ULL, 0x000fca00078e000fULL, 0x0000001806007388ULL, 0x000fe80000000c00ULL,
0x0000000004087984ULL, 0x000e680000000c00ULL, 0x00000000070c7984ULL, 0x000ea20000000c00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x004fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001c07007388ULL, 0x0003e80000000c00ULL,
0x0000000804007388ULL, 0x0003e20000000c00ULL, 0x018ad002ff0279a7ULL, 0x000ea40008500006ULL,
0x000000ffff067224ULL, 0x006fce00078e0003ULL, 0x0000000000027805ULL, 0x000fce0000015200ULL,
0x018ad006ff0075a7ULL, 0x000e640008000146ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fc800078110ffULL,
0x00000005ff057210ULL, 0x000fc800007fe4ffULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x018ad006ff0075a7ULL, 0x000e640008000146ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000010ff007c0cULL, 0x000fda000bf05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x3d80000000007820ULL, 0x010fe20000410000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000065f487c11ULL, 0x040fe2000f8e18ffULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x00000006040b7899ULL, 0x000fe2000800063fULL, 0x00000000001272caULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x000fe200078e005fULL, 0x000000065f007c11ULL, 0x000fe2000f8e28ffULL,
0xffffffff10117890ULL, 0x000fe2000fffe03fULL, 0x0000003f00047c82ULL, 0x000fd60008000000ULL,
0x0000010047617824ULL, 0x000fca00078e024cULL, 0x0000000d61007c0cULL, 0x000fda000bf01070ULL,
0x000000000000894dULL, 0x00afea0003800000ULL, 0x00000001ff657424ULL, 0x000fe200078e00ffULL,
0x000000475c00720cULL, 0x000fe20003f44070ULL, 0x0000003f00057c82ULL, 0x000fc60008000000ULL,
0x0000000465657807ULL, 0x000fd20001000000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fc4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000005000a7c82ULL, 0x000fe20008000000ULL, 0x0000000400087c82ULL, 0x000fca0008000000ULL,
0x0000000168087836ULL, 0x000fe20000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000005080a7c11ULL, 0x040fe2000f8ff8ffULL, 0x0000000108047892ULL, 0x000fe2000f8e0c3fULL,
0x000000ffff647224ULL, 0x000fe200078e0068ULL, 0x000000020800780cULL, 0x000fe20003f06070ULL,
0x000000ffff687224ULL, 0x000fe200078e0008ULL, 0x000000030a1c7812ULL, 0x000fe400078ec0ffULL,
0x00000002ff0aa819ULL, 0x000fe4000001160aULL, 0x00000001081a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1c1c7207ULL, 0x000fe20005000000ULL, 0x000000010a1b7824ULL, 0x000fc800078e0247ULL,
0x000000011b097836ULL, 0x000fca0000000000ULL, 0x0000001009007c0cULL, 0x000fe2000bf26070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000001000749947ULL, 0x000fea0003800000ULL,
0x00000003ff207819ULL, 0x002fe20000011603ULL, 0x000001001b1f7824ULL, 0x000fe200078e024cULL,
0x000000065f1e7c11ULL, 0x040fe2000f8e20ffULL, 0x000000081a247824ULL, 0x000fe200078e00ffULL,
0x000000065f0a7c11ULL, 0x000fe2000f8e70ffULL, 0x0000000420227824ULL, 0x000fe400078e024aULL,
0x0000004013217824ULL, 0x000fe200078e0220ULL, 0x000000000a0c72caULL, 0x000fe200000e0000ULL,
0x0000000420267836ULL, 0x000fe20000000000ULL, 0x0186000022097984ULL, 0x000e620000000800ULL,
0x0000000d1f0a7c48ULL, 0x000fc4000ffe0000ULL, 0xfffffff8241d7812ULL, 0x000fe200078ee203ULL,
0x0000000126257824ULL, 0x000fe400078e0203ULL, 0x000000010a1f7824ULL, 0x000fe400078e0a1fULL,
0x00000001200a7824ULL, 0x000fe400078e0203ULL, 0x0000000826627824ULL, 0x000fe200078e00ffULL,
0x0000000c04097291ULL, 0x000fe2000f8e683fULL, 0x0000001f2000720cULL, 0x000fc60003f26070ULL,
0x0000200009097890ULL, 0x000fe2000fffe03fULL, 0x0000001e09187211ULL, 0x002fe400078e10ffULL,
0x00008a00ff087b82ULL, 0x000e680000000a00ULL, 0x018a800018187984ULL, 0x000ea40000000800ULL,
0x0000000b180b7c24ULL, 0x004fe2000f8e0221ULL, 0x000000070a187812ULL, 0x000fc600078ec0ffULL,
0x000001000b0a7825ULL, 0x002fe200078e0008ULL, 0x0ffffff818187812ULL, 0x000fc800078ef803ULL,
0x0000000918237c11ULL, 0x000fe2000f8e20ffULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e2000c901c4eULL,
0x0000001f2600720cULL, 0x000fe20003f26070ULL, 0x0000000820267836ULL, 0x000fe40000000000ULL,
0x0186100022197984ULL, 0x000ea20000000800ULL, 0xfffffff862237812ULL, 0x002fe200078ee225ULL,
0x0000000126257824ULL, 0x040fe400078e0203ULL, 0x0000000826627824ULL, 0x000fe200078e00ffULL,
0x0000000923237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419247824ULL, 0x004fc400078e021eULL,
0x0000000421197836ULL, 0x000fc60000000000ULL, 0x018a800024187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e0008ULL,
0x000000101d187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000c901c4eULL, 0x0000001f2600720cULL, 0x000fe20003f26070ULL,
0x0000000c20267836ULL, 0x000fe40000000000ULL, 0x01862000220b7984ULL, 0x000ea20000000800ULL,
0xfffffff862237812ULL, 0x002fe200078ee225ULL, 0x0000000126257824ULL, 0x040fe400078e0203ULL,
0x0000000826627824ULL, 0x000fe200078e00ffULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b247824ULL, 0x004fe200078e021eULL, 0x00000008210b7810ULL, 0x000fc80007ffe0ffULL,
0x018a8000240a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e2000c901c4eULL,
0x0000001f2600720cULL, 0x000fe20003f26070ULL, 0x0000001020267836ULL, 0x000fe40000000000ULL,
0x0186300022197984ULL, 0x000ea20000000800ULL, 0xfffffff862237812ULL, 0x002fe200078ee225ULL,
0x0000000126257824ULL, 0x040fe400078e0203ULL, 0x0000000826627824ULL, 0x000fe200078e00ffULL,
0x0000000923237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419247824ULL, 0x004fc400078e021eULL,
0x0000000c21197836ULL, 0x000fc60000000000ULL, 0x018a800024187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e0008ULL,
0x000000101d187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000c901c4eULL, 0x0000001f2600720cULL, 0x000fe20003f26070ULL,
0x0000001420267836ULL, 0x000fe40000000000ULL, 0x01864000220b7984ULL, 0x000ea20000000800ULL,
0xfffffff862237812ULL, 0x002fe200078ee225ULL, 0x0000000126257824ULL, 0x040fe400078e0203ULL,
0x0000000826627824ULL, 0x000fe200078e00ffULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b247824ULL, 0x004fc400078e021eULL, 0x00000010210b7836ULL, 0x000fc60000000000ULL,
0x018a8000240a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e2000c901c4eULL,
0x0000001f2600720cULL, 0x000fe20003f26070ULL, 0x0000001820267836ULL, 0x000fe40000000000ULL,
0x0186500022197984ULL, 0x000ea20000000800ULL, 0xfffffff862237812ULL, 0x002fe200078ee225ULL,
0x0000000126257824ULL, 0x040fe400078e0203ULL, 0x0000000826627824ULL, 0x000fe200078e00ffULL,
0x0000000923237c11ULL, 0x000fe4000f8e20ffULL, 0x0000001e19247211ULL, 0x004fe200078e10ffULL,
0x0000001421197836ULL, 0x000fc80000000000ULL, 0x018a800024187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e0008ULL,
0x000000101d187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000c901c4eULL, 0x0000001f2600720cULL, 0x000fe20003f26070ULL,
0x0000001c20267836ULL, 0x000fe40000000000ULL, 0x01866000220b7984ULL, 0x000ea20000000800ULL,
0xfffffff862237812ULL, 0x002fe200078ee225ULL, 0x0000000826627824ULL, 0x000fe200078e00ffULL,
0x0000000326257210ULL, 0x000fe40007ffe0ffULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b247824ULL, 0x004fc400078e021eULL, 0x00000018210b7836ULL, 0x000fc60000000000ULL,
0x018a8000240a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e2000c901c4eULL,
0x0000001f2600720cULL, 0x000fe20003f26070ULL, 0x0000002020267836ULL, 0x000fe40000000000ULL,
0x0186700022197984ULL, 0x000ea20000000800ULL, 0xfffffff862237812ULL, 0x002fe200078ee225ULL,
0x0000000126257824ULL, 0x040fe400078e0203ULL, 0x0000000826627824ULL, 0x000fe200078e00ffULL,
0x0000000923237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419247824ULL, 0x004fc400078e021eULL,
0x0000001c21197836ULL, 0x000fc60000000000ULL, 0x018a800024187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e0008ULL,
0x000000101d187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000c901c4eULL, 0x0000001f2600720cULL, 0x000fe20003f26070ULL,
0x0000002420267836ULL, 0x000fe40000000000ULL, 0x01868000220b7984ULL, 0x000ea20000000800ULL,
0xfffffff862237812ULL, 0x002fe200078ee225ULL, 0x0000000126257824ULL, 0x040fe400078e0203ULL,
0x0000000826627824ULL, 0x000fe200078e00ffULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b247824ULL, 0x004fc400078e021eULL, 0x00000020210b7836ULL, 0x000fc60000000000ULL,
0x018a8000240a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e2000c901c4eULL,
0x0000001f2600720cULL, 0x000fe40003f26070ULL, 0x0000002820267810ULL, 0x000fe20007ffe0ffULL,
0x0186900022197984ULL, 0x000ea20000000800ULL, 0xfffffff862237812ULL, 0x002fc600078ee225ULL,
0x0000000126257824ULL, 0x040fe400078e0203ULL, 0x0000000826627824ULL, 0x000fe200078e00ffULL,
0x0000000923237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419247824ULL, 0x004fe400078e021eULL,
0x0000002421197836ULL, 0x000fc60000000000ULL, 0x018a800024187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e0008ULL,
0x000000101d187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000c901c4eULL, 0x0000001f2600720cULL, 0x000fe20003f26070ULL,
0x0000002c20267836ULL, 0x000fe40000000000ULL, 0x0186a000220b7984ULL, 0x000ea20000000800ULL,
0xfffffff862237812ULL, 0x002fe200078ee225ULL, 0x0000000126257824ULL, 0x040fe400078e0203ULL,
0x0000000826627824ULL, 0x000fe200078e00ffULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b247824ULL, 0x004fc400078e021eULL, 0x00000028210b7836ULL, 0x000fc60000000000ULL,
0x018a8000240a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e2000c901c4eULL,
0x0000001f2600720cULL, 0x000fe20003f26070ULL, 0x0000003020267836ULL, 0x000fe40000000000ULL,
0x0186b00022197984ULL, 0x000ea20000000800ULL, 0xfffffff862237812ULL, 0x002fe200078ee225ULL,
0x0000000126257824ULL, 0x040fe200078e0203ULL, 0x0000000326627819ULL, 0x000fe400000006ffULL,
0x0000000923237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419247824ULL, 0x004fc400078e021eULL,
0x0000002c21197836ULL, 0x000fc60000000000ULL, 0x018a800024187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e0008ULL,
0x000000101d187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000c901c4eULL, 0x0000001f2600720cULL, 0x000fe20003f26070ULL,
0x0000003420267836ULL, 0x000fe40000000000ULL, 0x0186c000220b7984ULL, 0x000ea20000000800ULL,
0xfffffff862237812ULL, 0x002fe200078ee225ULL, 0x0000000126257824ULL, 0x040fe400078e0203ULL,
0x0000000826627824ULL, 0x000fe200078e00ffULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b247824ULL, 0x004fc400078e021eULL, 0x00000030210b7836ULL, 0x000fc60000000000ULL,
0x018a8000240a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e2000c901c4eULL,
0x0000001f2600720cULL, 0x000fe20003f26070ULL, 0x0000003820267836ULL, 0x000fe40000000000ULL,
0x0186d00022197984ULL, 0x000ea20000000800ULL, 0x0000003c20207836ULL, 0x000fe20000000000ULL,
0xfffffff862237812ULL, 0x002fe200078ee225ULL, 0x0000000126257824ULL, 0x040fe400078e0203ULL,
0x0000000826627824ULL, 0x000fe200078e00ffULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419247824ULL, 0x004fc400078e021eULL, 0x0000003421197836ULL, 0x000fc60000000000ULL,
0x018a800024187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e0008ULL, 0x000000101d187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e2000c901c4eULL,
0x0000001f2600720cULL, 0x000fc60003f26070ULL, 0x0186e000220b7984ULL, 0x000ea20000000800ULL,
0xfffffff862197812ULL, 0x002fc800078ee225ULL, 0x0000000919197c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b247824ULL, 0x004fe400078e021eULL, 0x00000038210b7836ULL, 0x000fe20000000000ULL,
0x0000003c21217810ULL, 0x000fe40007ffe0ffULL, 0x018a8000240a7984ULL, 0x0002a40000000800ULL,
0x0000000820247824ULL, 0x002fe400078e00ffULL, 0x0000000b0a0b7c24ULL, 0x004fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e2000c901c4eULL,
0x0000001f2000720cULL, 0x000fc60003f26070ULL, 0x0186f00022237984ULL, 0x000ea40000000800ULL,
0x0000000423187824ULL, 0x004fe400078e021eULL, 0x0000000120237824ULL, 0x000fc800078e0203ULL,
0x018a800018187984ULL, 0x000ea20000000800ULL, 0xfffffff8240b7812ULL, 0x002fc800078ee223ULL,
0x000000090b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b18217c24ULL, 0x004fc8000f8e0221ULL,
0x0000010021087825ULL, 0x000fc800078e0008ULL, 0x000000101d087825ULL, 0x000fca00078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c901c4eULL,
0x0000001000247947ULL, 0x000fea0003800000ULL, 0x00000003ff207819ULL, 0x102fe20000011603ULL,
0x000000081a227824ULL, 0x000fe200078e00ffULL, 0x000000065f1e7c11ULL, 0x040fe4000f8e20ffULL,
0x000000065f0b7c11ULL, 0x000fe2000f8e70ffULL, 0x0000000420217824ULL, 0x040fe200078e024aULL,
0xfffffff8221d7812ULL, 0x000fe200078ee203ULL, 0x00000040131f7824ULL, 0x000fe200078e0220ULL,
0x000000000b0c72caULL, 0x000fe200000e0000ULL, 0x0000000120187824ULL, 0x000fe200078e0203ULL,
0x0186000021097984ULL, 0x000e620000000800ULL, 0x0000000420247836ULL, 0x000fc60000000000ULL,
0x0000000718187812ULL, 0x000fe200078ec0ffULL, 0x0000000124257824ULL, 0x040fe400078e0203ULL,
0x0000000824247824ULL, 0x000fe200078e00ffULL, 0x0ffffff818187812ULL, 0x000fc600078ef803ULL,
0x0000000c04097291ULL, 0x000fe2000f8e683fULL, 0xfffffff824257812ULL, 0x000fe200078ee225ULL,
0x0000000820247836ULL, 0x000fe40000000000ULL, 0x0000200009097890ULL, 0x000fcc000fffe03fULL,
0x0000000918237c11ULL, 0x000fe4000f8e20ffULL, 0x0000000925257c11ULL, 0x000fe2000f8e20ffULL,
0x00000004090a7824ULL, 0x002fe400078e021eULL, 0x00008a00ff087b82ULL, 0x000e680000000a00ULL,
0x018a80000a0a7984ULL, 0x000ea40000000800ULL, 0x0000000b0a0b7c24ULL, 0x004fc8000f8e021fULL,
0x000001000b0a7825ULL, 0x002fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e8000b901c4eULL,
0x0186100021197984ULL, 0x000ea20000000800ULL, 0x0000000124237824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824237812ULL, 0x000fe200078ee223ULL,
0x0000000c20247836ULL, 0x000fc60000000000ULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419227824ULL, 0x004fe400078e021eULL, 0x000000041f197836ULL, 0x000fc60000000000ULL,
0x018a800022187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e0008ULL, 0x000000101d187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4eULL,
0x01862000210b7984ULL, 0x000ea20000000800ULL, 0x0000000124257824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824257812ULL, 0x000fe200078ee225ULL,
0x0000001020247836ULL, 0x000fc60000000000ULL, 0x0000000925257c11ULL, 0x000fe4000f8e20ffULL,
0x0000001e0b227211ULL, 0x004fe200078e10ffULL, 0x000000081f0b7836ULL, 0x000fc80000000000ULL,
0x018a8000220a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e8000b901c4eULL,
0x0186300021197984ULL, 0x000ea20000000800ULL, 0x0000000324237210ULL, 0x002fe20007ffe0ffULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824237812ULL, 0x000fe200078ee223ULL,
0x0000001420247836ULL, 0x000fc60000000000ULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419227824ULL, 0x004fe400078e021eULL, 0x0000000c1f197836ULL, 0x000fc60000000000ULL,
0x018a800022187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e0008ULL, 0x000000101d187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4eULL,
0x01864000210b7984ULL, 0x000ea20000000800ULL, 0x0000000124257824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824257812ULL, 0x000fe200078ee225ULL,
0x0000001820247836ULL, 0x000fc60000000000ULL, 0x0000000925257c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b227824ULL, 0x004fe400078e021eULL, 0x000000101f0b7836ULL, 0x000fc60000000000ULL,
0x018a8000220a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e8000b901c4eULL,
0x0186500021197984ULL, 0x000ea20000000800ULL, 0x0000000124237824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824237812ULL, 0x000fe400078ee223ULL,
0x0000001c20247810ULL, 0x000fe40007ffe0ffULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419227824ULL, 0x004fe400078e021eULL, 0x000000141f197836ULL, 0x000fc60000000000ULL,
0x018a800022187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e0008ULL, 0x000000101d187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4eULL,
0x01866000210b7984ULL, 0x000ea20000000800ULL, 0x0000000124257824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824257812ULL, 0x000fe200078ee225ULL,
0x0000002020247836ULL, 0x000fc60000000000ULL, 0x0000000925257c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b227824ULL, 0x004fe400078e021eULL, 0x000000181f0b7836ULL, 0x000fc60000000000ULL,
0x018a8000220a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e8000b901c4eULL,
0x0186700021197984ULL, 0x000ea20000000800ULL, 0x0000000124237824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824237812ULL, 0x000fe200078ee223ULL,
0x0000002420247836ULL, 0x000fc60000000000ULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419227824ULL, 0x004fe400078e021eULL, 0x0000001c1f197836ULL, 0x000fc60000000000ULL,
0x018a800022187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e0008ULL, 0x000000101d187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4eULL,
0x01868000210b7984ULL, 0x000ea20000000800ULL, 0x0000000124257824ULL, 0x042fe200078e0203ULL,
0x0000000324247819ULL, 0x000fc800000006ffULL, 0xfffffff824257812ULL, 0x000fe200078ee225ULL,
0x0000002820247836ULL, 0x000fc60000000000ULL, 0x0000000925257c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b227824ULL, 0x004fe400078e021eULL, 0x000000201f0b7836ULL, 0x000fc60000000000ULL,
0x018a8000220a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e8000b901c4eULL,
0x0186900021197984ULL, 0x000ea20000000800ULL, 0x0000000124237824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824237812ULL, 0x000fe200078ee223ULL,
0x0000002c20247836ULL, 0x000fc60000000000ULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419227824ULL, 0x004fe400078e021eULL, 0x000000241f197836ULL, 0x000fc60000000000ULL,
0x018a800022187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e0008ULL, 0x000000101d187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4eULL,
0x0186a000210b7984ULL, 0x000ea20000000800ULL, 0x0000000124257824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824257812ULL, 0x000fe200078ee225ULL,
0x0000003020247836ULL, 0x000fc60000000000ULL, 0x0000000925257c11ULL, 0x000fe2000f8e20ffULL,
0x000000040b227824ULL, 0x004fe400078e021eULL, 0x000000281f0b7836ULL, 0x000fc60000000000ULL,
0x018a8000220a7984ULL, 0x000e640000000800ULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e8000b901c4eULL,
0x0186b00021197984ULL, 0x000ea20000000800ULL, 0x0000000124237824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824237812ULL, 0x000fe200078ee223ULL,
0x0000003420247836ULL, 0x000fc60000000000ULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419227824ULL, 0x004fe400078e021eULL, 0x0000002c1f197836ULL, 0x000fc60000000000ULL,
0x018a800022187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e0008ULL, 0x000000101d187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4eULL,
0x0186c000210b7984ULL, 0x000ea20000000800ULL, 0x0000000124257824ULL, 0x042fe400078e0203ULL,
0x0000000824247824ULL, 0x000fca00078e00ffULL, 0xfffffff824257812ULL, 0x000fe200078ee225ULL,
0x0000003820247836ULL, 0x000fe40000000000ULL, 0x0000003c20207836ULL, 0x000fe20000000000ULL,
0x0000000925257c11ULL, 0x000fe2000f8e20ffULL, 0x000000040b227824ULL, 0x004fe200078e021eULL,
0x000000301f0b7810ULL, 0x000fc80007ffe0ffULL, 0x018a8000220a7984ULL, 0x000e640000000800ULL,
0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL, 0x000001000b0a7825ULL, 0x000fc800078e0008ULL,
0x000000101d0a7825ULL, 0x000fca00078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a237faeULL, 0x0003e8000b901c4eULL, 0x0186d00021197984ULL, 0x000ea20000000800ULL,
0x0000000124237824ULL, 0x042fe400078e0203ULL, 0x0000000824247824ULL, 0x000fca00078e00ffULL,
0xfffffff824237812ULL, 0x000fc800078ee223ULL, 0x0000000923237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419227824ULL, 0x004fe400078e021eULL, 0x000000341f197836ULL, 0x000fc60000000000ULL,
0x018a800022187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e0008ULL, 0x000000101d187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4eULL,
0x0186e000210b7984ULL, 0x000ea20000000800ULL, 0x0000003c1f197836ULL, 0x002fe40000000000ULL,
0x000000040b227824ULL, 0x004fe400078e021eULL, 0x000000381f0b7836ULL, 0x000fe40000000000ULL,
0x00000001201f7824ULL, 0x040fe200078e0203ULL, 0x018a8000220a7984ULL, 0x000e620000000800ULL,
0x0000000820207824ULL, 0x000fca00078e00ffULL, 0xfffffff8201f7812ULL, 0x000fc800078ee21fULL,
0x000000091f1f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b0a0b7c24ULL, 0x002fc8000f8e020bULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e8000b901c4eULL,
0x0186f00021217984ULL, 0x000ea40000000800ULL, 0x0000001e21187211ULL, 0x004fcc00078e10ffULL,
0x018a800018187984ULL, 0x000ea40000000800ULL, 0x0000000b18197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019087825ULL, 0x000fc800078e0008ULL, 0x000000101d087825ULL, 0x000fca00078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000081f7faeULL, 0x0003e4000b901c4eULL,
0x000000ff1a00720cULL, 0x000fe20003f25270ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000000000bc9947ULL, 0x000fea0003800000ULL, 0x00009200ff087b82ULL, 0x002e620000000a00ULL,
0x000000011c0a7836ULL, 0x000fe20000000000ULL, 0x000000031c00780cULL, 0x000fe20003f85270ULL,
0x00000020031f7836ULL, 0x000fe20000000000ULL, 0x0000001b5c00720cULL, 0x0c0fe40003f64070ULL,
0x0000001b5c00720cULL, 0x000fe40003f24070ULL, 0x00000002ff0b7819ULL, 0x000fe4000001160aULL,
0x000000030a0a7812ULL, 0x000fc400078ec0ffULL, 0x000000010b187807ULL, 0x000fe40004800000ULL,
0x000000ff0a0a7207ULL, 0x000fc60004800000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0218ULL,
0x000000015d1d7824ULL, 0x000fe400078e020aULL, 0x000001001b187824ULL, 0x000fe200078e024cULL,
0x000000000044b947ULL, 0x000fec0002000000ULL, 0x000000030300780cULL, 0x000fe20003f24070ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000402027836ULL, 0x000fd60000000000ULL,
0x0000000000301947ULL, 0x000fea0003800000ULL, 0x00008c00ff0a7b82ULL, 0x000ea20000000a00ULL,
0x0000000412197824ULL, 0x000fe200078e0203ULL, 0x0000000702007c0cULL, 0x000fe2000bf26070ULL,
0x0000900000097ab9ULL, 0x000fe20000000800ULL, 0x0000001e031b7211ULL, 0x000fe200078e10ffULL,
0x0000000219197824ULL, 0x000fc800078e00ffULL, 0x0000000919197c24ULL, 0x000fc8000f8e0202ULL,
0x00000004190a7825ULL, 0x004fca00078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a800000a1b7faeULL, 0x0005e4000c92184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001180a7824ULL, 0x104fe200078e0203ULL, 0x0000940000097ab9ULL, 0x000fe20000000800ULL,
0x000000011f0b7824ULL, 0x100fe400078e0218ULL, 0x000000091d187c24ULL, 0x000fe2000f8e0218ULL,
0x0000000d0a007c0cULL, 0x000fe2000bf26070ULL, 0x00000004031b7824ULL, 0x000fe200078e024aULL,
0x0000000d0b007c0cULL, 0x000fe2000bf66070ULL, 0x00000001180b7824ULL, 0x000fe400078e0203ULL,
0x000000011f197824ULL, 0x000fc400078e0218ULL, 0x000000040b0a7825ULL, 0x002fc800078e0008ULL,
0x0000000419087825ULL, 0x000fe400078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x186000000a1b7faeULL, 0x0003e8000c92184eULL, 0x18680000081b7faeULL, 0x0003e4000d92184eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002003667836ULL, 0x000fe20000000000ULL,
0xfffffff803087812ULL, 0x042fe200078ec0ffULL, 0x0000000c08087291ULL, 0x000fe2000f8e683fULL,
0x0000000703627812ULL, 0x000fe200078ec0ffULL, 0x000000ffff697224ULL, 0x000fe200078e00ffULL,
0xfffffff866667812ULL, 0x000fe200078ec0ffULL, 0x0000200008087890ULL, 0x000fe2000fffe03fULL,
0x0000000708677812ULL, 0x000fe400078ef803ULL, 0x0000000862637812ULL, 0x000fc400078ef803ULL,
0x0000000766667812ULL, 0x000fce00078ef803ULL, 0x00000008640a7824ULL, 0x100fe400078e0269ULL,
0x0000000167087824ULL, 0x040fe400078e0269ULL, 0x0000000867097824ULL, 0x000fe400078e00ffULL,
0x000000020a0a7824ULL, 0x000fe400078e00ffULL, 0x00000020630b7824ULL, 0x000fe200078e00ffULL,
0xfffffff809097812ULL, 0x000fe200078ee208ULL, 0x00000001696a7836ULL, 0x000fe20000000000ULL,
0x0000000a03087211ULL, 0x000fe200078fe0ffULL, 0x000000020a0a7836ULL, 0x000fe20000000000ULL,
0x0000000809207c11ULL, 0x000fe2000f8e20ffULL, 0x0000000866097824ULL, 0x040fe200078e00ffULL,
0x0000000863087210ULL, 0x000fe20007ffe0ffULL, 0x00000008666b7824ULL, 0x000fe200078e00ffULL,
0x0000000a030a7211ULL, 0x000fc400078fe0ffULL, 0xffffffe00b087812ULL, 0x000fe200078ee208ULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x00000001670b7824ULL, 0x000fe400078e026aULL,
0x0000000608187c11ULL, 0x000fe2000f8e20ffULL, 0x0000000166087824ULL, 0x040fe400078e0269ULL,
0x00000001630a7824ULL, 0x000fe400078e020aULL, 0x00000001666a7824ULL, 0x000fe200078e026aULL,
0x000000001818783bULL, 0x000ea20000000200ULL, 0xfffffff809087812ULL, 0x000fe200078ee208ULL,
0x0000000269697836ULL, 0x000fc40000000000ULL, 0xfffffff86b6a7812ULL, 0x000fe400078ee26aULL,
0x00000008081c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000086900780cULL, 0x000fc80003f25270ULL,
0x000000001c1c783bULL, 0x000ee20000000200ULL, 0x00000020ff08723eULL, 0x002fe400020006ffULL,
0x00000020ff09723eULL, 0x000fe200030006ffULL, 0x0000000867207824ULL, 0x000fe200078e00ffULL,
0x00000022ff26723eULL, 0x000fe400020006ffULL, 0x00000022ff27723eULL, 0x000fe400030006ffULL,
0xfffffff8200b7812ULL, 0x000fe200078ee20bULL, 0x00000008183c723cULL, 0x004fe2000000183cULL,
0x00000021ff20723eULL, 0x000fc400020006ffULL, 0x000000080b0b7c11ULL, 0x000fe4000f8e20ffULL,
0x00000021ff21723eULL, 0x000fe200030006ffULL, 0x000000261834723cULL, 0x000fe20000001834ULL,
0x0000002063097824ULL, 0x000fe200078e00ffULL, 0x00000023ff25723eULL, 0x000fc800030006ffULL,
0xffffffe009247812ULL, 0x000fe200078ee20aULL, 0x000000201838723cULL, 0x000fe20000001838ULL,
0x000000000b08783bULL, 0x000e620000000200ULL, 0x0000001cff26723eULL, 0x008fe400020006ffULL,
0x0000001cff27723eULL, 0x000fe400030006ffULL, 0x0000001dff1c723eULL, 0x000fe400020006ffULL,
0x0000000624207c11ULL, 0x000fe4000f8e20ffULL, 0x00000023ff24723eULL, 0x000fe200020006ffULL,
0x00000026182c723cULL, 0x000fe2000000182cULL, 0x0000001dff1d723eULL, 0x000fc400030006ffULL,
0x000000002020783bULL, 0x000ea60000000200ULL, 0x000000241830723cULL, 0x000fec0000001830ULL,
0x0000001c1828723cULL, 0x000fe20000001828ULL, 0x000000086a247c11ULL, 0x000fcc000f8e20ffULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x0000001eff1c723eULL, 0x000fe400020006ffULL,
0x0000001eff1d723eULL, 0x000fe400030006ffULL, 0x0000001fff1e723eULL, 0x000fe400020006ffULL,
0x0000001fff1f723eULL, 0x000fc600030006ffULL, 0x0000001c180c723cULL, 0x000fec000000180cULL,
0x0000001e1814723cULL, 0x000fee0000001814ULL, 0x00000008ff18723eULL, 0x002fc400020006ffULL,
0x00000008ff19723eULL, 0x000fe400030006ffULL, 0x00000009ff08723eULL, 0x000fe400020006ffULL,
0x00000009ff09723eULL, 0x000fc600030006ffULL, 0x00000018203c723cULL, 0x004fec000000183cULL,
0x000000082038723cULL, 0x000fee0000001838ULL, 0x0000000aff08723eULL, 0x000fc400020006ffULL,
0x0000000aff09723eULL, 0x000fe400030006ffULL, 0x0000000bff0a723eULL, 0x000fe400020006ffULL,
0x0000000bff0b723eULL, 0x000fc600030006ffULL, 0x000000082034723cULL, 0x000fec0000001834ULL,
0x0000000a2030723cULL, 0x000fe20000001830ULL, 0x00000024ff08723eULL, 0x008fe400020006ffULL,
0x00000024ff09723eULL, 0x000fe400030006ffULL, 0x00000025ff24723eULL, 0x000fc400020006ffULL,
0x00000025ff25723eULL, 0x000fc600030006ffULL, 0x00000008202c723cULL, 0x000fec000000182cULL,
0x000000242028723cULL, 0x000fe20000001828ULL, 0x00000026ff08723eULL, 0x000fe400020006ffULL,
0x00000026ff09723eULL, 0x000fe400030006ffULL, 0x00000027ff26723eULL, 0x000fc400020006ffULL,
0x00000027ff27723eULL, 0x000fc600030006ffULL, 0x00000008200c723cULL, 0x000fec000000180cULL,
0x000000262014723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff800a01947ULL, 0x000fde000383ffffULL, 0x0000000400087c82ULL, 0x000fe20008000000ULL,
0xffffffd000cc8947ULL, 0x000fea000383ffffULL, 0x00000002ff087819ULL, 0x000fc80000011603ULL,
0x0000000508007c0cULL, 0x000fe2000bf06070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000508007c0cULL, 0x000fe2000c706470ULL, 0x0000000808087836ULL, 0x000fc60000000000ULL,
0x000000475c00720cULL, 0x000fe40000703070ULL, 0x0000000a08007c0cULL, 0x000fc8000bf26070ULL,
0x0000000508007c0cULL, 0x000fc80008f21070ULL, 0x000000475c00720cULL, 0x000fc60000f24470ULL,
0x00000015005a8202ULL, 0x000fe20000000f00ULL, 0x000000ffff578224ULL, 0x000fe200078e0014ULL,
0x00000038004b8202ULL, 0x000fe20000000f00ULL, 0x000000ffff588224ULL, 0x000fe200078e000dULL,
0x0000006017607208ULL, 0x000fe20000800000ULL, 0x000000ffff558224ULL, 0x000fe200078e000cULL,
0x0000005b165b7208ULL, 0x000fe20000800000ULL, 0x000000ffff568224ULL, 0x000fe200078e0029ULL,
0x0000005e0f5e7208ULL, 0x000fe20000800000ULL, 0x000000ffff538224ULL, 0x000fe200078e0028ULL,
0x000000590e597208ULL, 0x000fe20000800000ULL, 0x000000ffff548224ULL, 0x000fe200078e002dULL,
0x000000062b067208ULL, 0x000fe20000800000ULL, 0x000000ffff518224ULL, 0x000fe200078e002cULL,
0x000000072a077208ULL, 0x000fe20000800000ULL, 0x000000ffff528224ULL, 0x000fe200078e0031ULL,
0x000000102f107208ULL, 0x000fe20000800000ULL, 0x000000ffff4f8224ULL, 0x000fe200078e0030ULL,
0x000000112e117208ULL, 0x000fe20000800000ULL, 0x000000ffff508224ULL, 0x000fe200078e0035ULL,
0x0000004033407208ULL, 0x000fe20000800000ULL, 0x000000ffff4d8224ULL, 0x000fe200078e0034ULL,
0x0000004132417208ULL, 0x000fe20000800000ULL, 0x000000ffff4e8224ULL, 0x000fe200078e0039ULL,
0x0000004237427208ULL, 0x000fe20000800000ULL, 0x000000ffff498224ULL, 0x000fe200078e003dULL,
0x0000004336437208ULL, 0x000fe20000800000ULL, 0x000000ffff048224ULL, 0x000fe200078e003cULL,
0x0000000565007c0cULL, 0x000fc4000bf03070ULL, 0x000000443b447208ULL, 0x000fe40000800000ULL,
0x000000453a457208ULL, 0x000fe40000800000ULL, 0x000000463f467208ULL, 0x000fe40000800000ULL,
0x000000053e057208ULL, 0x000fca0000800000ULL, 0xffffffcc00d48947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001204097c20ULL, 0x000fe20008410000ULL,
0x0000001249497c20ULL, 0x000fe20008410000ULL, 0x000000124b4b7c20ULL, 0x000fe20008410000ULL,
0x000000124e4e7c20ULL, 0x000fe20008410000ULL, 0x000000124d4d7c20ULL, 0x000fe20008410000ULL,
0x018b580b480a79a7ULL, 0x000e62000850003fULL, 0x0000001250507c20ULL, 0x000fe20008410000ULL,
0x000000124f4f7c20ULL, 0x000fe20008410000ULL, 0x0000001252527c20ULL, 0x000fe20008410000ULL,
0x0000001251517c20ULL, 0x000fe20008410000ULL, 0x0000001254547c20ULL, 0x000fe20008410000ULL,
0x0000001253537c20ULL, 0x000fe20008410000ULL, 0x0000001256567c20ULL, 0x000fe20008410000ULL,
0x0000001255557c20ULL, 0x000fe20008410000ULL, 0x0000001258587c20ULL, 0x000fe20008410000ULL,
0x0000001257577c20ULL, 0x000fe20008410000ULL, 0x000000125a5a7c20ULL, 0x000fe20008410000ULL,
0x0000001205087c20ULL, 0x000fe20008410000ULL, 0x0000001246467c20ULL, 0x000fe20008410000ULL,
0x0000001245457c20ULL, 0x000fe20008410000ULL, 0x0000001244447c20ULL, 0x000fe20008410000ULL,
0x0000001243437c20ULL, 0x000fe20008410000ULL, 0x0000001242427c20ULL, 0x000fe20008410000ULL,
0x0000001241417c20ULL, 0x000fe20008410000ULL, 0x0000001240407c20ULL, 0x000fe20008410000ULL,
0x0000001211117c20ULL, 0x000fe20008410000ULL, 0x0000001210107c20ULL, 0x000fe20008410000ULL,
0x0000001207077c20ULL, 0x000fe20008410000ULL, 0x0000001206067c20ULL, 0x000fe20008410000ULL,
0x000000ffff0f7224ULL, 0x002fc400078e000bULL, 0x0000001259597c20ULL, 0x000fe20008410000ULL,
0x000000125e5e7c20ULL, 0x000fe20008410000ULL, 0x000000125b5b7c20ULL, 0x000fe20008410000ULL,
0x0000001260607c20ULL, 0x000fe20008410000ULL, 0x0000000000047805ULL, 0x000fe20000015200ULL,
0x018b580f480075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a040d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e05ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x018b580f480075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000403047824ULL, 0x000fe200078e00ffULL,
0x000000065f2c7c11ULL, 0x000fe4000f8e38ffULL, 0x0000001147007c0cULL, 0x000fe4000bf05270ULL,
0xfffffff004057812ULL, 0x000fca00078ec0ffULL, 0x000000012c2c7824ULL, 0x000fca00078e0205ULL,
0x018400002c187984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000203047824ULL, 0x000fe200078e00ffULL, 0x0000000d61617c10ULL, 0x000fc8000fffe1ffULL,
0x0000000604047812ULL, 0x000fc800078ec0ffULL, 0x00000001040a7812ULL, 0x040fe400078efcffULL,
0x00000008040c7812ULL, 0x000fe400078efcffULL, 0x000000610a00720cULL, 0x080fe40003f26070ULL,
0x00000010040a7812ULL, 0x000fe400078efcffULL, 0x000000610c00720cULL, 0x080fe40003f06070ULL,
0x000000610a00720cULL, 0x000fc40003fc6070ULL, 0x00000011040c7812ULL, 0x040fe400078efcffULL,
0x00000018040a7812ULL, 0x040fe400078efcffULL, 0x000000610400720cULL, 0x080fe40003f46070ULL,
0x000000610c00720cULL, 0x080fe40003fa6070ULL, 0x000000610a00720cULL, 0x000fe40003f66070ULL,
0x00000009040e7812ULL, 0x000fc400078efcffULL, 0x00000019040c7812ULL, 0x040fe400078efcffULL,
0x00000020040a7812ULL, 0x000fe400078efcffULL, 0xff80000008087808ULL, 0x000fe40005000000ULL,
0xff80000009097808ULL, 0x000fe40005000000ULL, 0xff80000046467808ULL, 0x000fe40004800000ULL,
0xff80000049497808ULL, 0x000fc40004800000ULL, 0x000000610e00720cULL, 0x080fe40003f86070ULL,
0x000000610c00720cULL, 0x080fe40003f46070ULL, 0x000000610a00720cULL, 0x000fe40003f26070ULL,
0x00000021040c7812ULL, 0x040fe400078efcffULL, 0x00000028040a7812ULL, 0x000fe400078efcffULL,
0xff80000045457808ULL, 0x000fc40004000000ULL, 0xff8000004b4b7808ULL, 0x000fe40004000000ULL,
0xff80000044447808ULL, 0x000fe40006000000ULL, 0xff8000004e4e7808ULL, 0x000fe40006000000ULL,
0x000000610c00720cULL, 0x080fe40003f06070ULL, 0x000000610a00720cULL, 0x000fe40003f86070ULL,
0x00000029040c7812ULL, 0x000fc400078efcffULL, 0x00000030040a7812ULL, 0x000fe400078efcffULL,
0xff80000043437808ULL, 0x000fe40007000000ULL, 0xff8000004d4d7808ULL, 0x000fe40007000000ULL,
0xff80000042427808ULL, 0x000fe40006800000ULL, 0xff80000050507808ULL, 0x000fe40006800000ULL,
0x000000610c00720cULL, 0x000fc40003fc6070ULL, 0x000000610a00720cULL, 0x000fe40003fa6070ULL,
0x00000031040c7812ULL, 0x040fe400078efcffULL, 0x00000038040a7812ULL, 0x040fe400078efcffULL,
0x0000003904047812ULL, 0x000fe400078efcffULL, 0xff80000041417808ULL, 0x000fe40005800000ULL,
0xff8000004f4f7808ULL, 0x000fc40005800000ULL, 0xff80000040407808ULL, 0x000fe40005000000ULL,
0xff80000052527808ULL, 0x000fe40005000000ULL, 0xff80000011117808ULL, 0x000fe40004800000ULL,
0xff80000051517808ULL, 0x000fe40004800000ULL, 0x000000610c00720cULL, 0x080fe40003f66070ULL,
0x000000610a00720cULL, 0x000fc40003f46070ULL, 0x000000610400720cULL, 0x000fe40003f26070ULL,
0xff80000010107808ULL, 0x000fe40004000000ULL, 0xff80000054547808ULL, 0x000fe40004000000ULL,
0xff80000007077808ULL, 0x000fe40006000000ULL, 0xff80000053537808ULL, 0x000fe40006000000ULL,
0xff80000006067808ULL, 0x000fc40007000000ULL, 0xff80000056567808ULL, 0x000fe40007000000ULL,
0xff80000059597808ULL, 0x000fe40006800000ULL, 0xff80000055557808ULL, 0x000fe40006800000ULL,
0xff8000005e5e7808ULL, 0x000fe40005800000ULL, 0xff80000058587808ULL, 0x000fe40005800000ULL,
0xff8000005b5b7808ULL, 0x000fc40005000000ULL, 0xff80000057577808ULL, 0x000fe40005000000ULL,
0xff80000060607808ULL, 0x000fe40004800000ULL, 0xff8000005a5a7808ULL, 0x000fce0004800000ULL,
0x000000091800720bULL, 0x004fe20003f1e000ULL, 0x3c003c00ff207424ULL, 0x000fe200078e00ffULL,
0x3c003c0000217802ULL, 0x000fe20000000f00ULL, 0x0000000147477836ULL, 0x000fe20000000000ULL,
0x0000001809187208ULL, 0x000fe40004000000ULL, 0x000000065f267c11ULL, 0x000fe4000f8e58ffULL,
0x000000491800720bULL, 0x000fc60003f1e000ULL, 0x0001200026317836ULL, 0x000fe20000000000ULL,
0x0000001849187208ULL, 0x000fc80004000000ULL, 0x0000004b1800720bULL, 0x000fc80003f1e000ULL,
0x000000184b057208ULL, 0x000fe40004000000ULL, 0x0c401f001b187f89ULL, 0x000fe400000e0000ULL,
0x0000004e0500720bULL, 0x000fc80003f1e000ULL, 0x000000054e047208ULL, 0x000fc80004000000ULL,
0x0000004d0400720bULL, 0x000fc80003f1e000ULL, 0x000000044d057208ULL, 0x000fc80004000000ULL,
0x000000500500720bULL, 0x000fc80003f1e000ULL, 0x0000000550047208ULL, 0x000fc80004000000ULL,
0x0000004f0400720bULL, 0x000fc80003f1e000ULL, 0x000000044f057208ULL, 0x000fc80004000000ULL,
0x000000520500720bULL, 0x000fc80003f1e000ULL, 0x0000000552047208ULL, 0x000fc80004000000ULL,
0x000000510400720bULL, 0x000fc80003f1e000ULL, 0x0000000451057208ULL, 0x000fc80004000000ULL,
0x000000540500720bULL, 0x000fc80003f1e000ULL, 0x0000000554047208ULL, 0x000fc80004000000ULL,
0x000000530400720bULL, 0x000fc80003f1e000ULL, 0x0000000453057208ULL, 0x000fe40004000000ULL,
0x000000081900720bULL, 0x000fe40003f1e000ULL, 0x000000560500720bULL, 0x000fe40003f3e000ULL,
0x0000001908197208ULL, 0x000fe40004000000ULL, 0x0000000556047208ULL, 0x000fe40004800000ULL,
0x000000461900720bULL, 0x000fc40003f1e000ULL, 0x000000550400720bULL, 0x000fc80003f3e000ULL,
0x0000000455057208ULL, 0x000fe40004800000ULL, 0x0000001946047208ULL, 0x000fe40004000000ULL,
0x000000580500720bULL, 0x000fe20003f3e000ULL, 0x0c401f001a197f89ULL, 0x000fe200000e0000ULL,
0x000000450400720bULL, 0x000fe40003f1e000ULL, 0x00000005580a7208ULL, 0x000fe40004800000ULL,
0x0000000445057208ULL, 0x000fc40004000000ULL, 0x000000570a00720bULL, 0x000fe40003f3e000ULL,
0x000000440500720bULL, 0x000fe40003f1e000ULL, 0x0000000a570b7208ULL, 0x000fe40004800000ULL,
0x0000000544047208ULL, 0x000fe40004000000ULL, 0x0000005a0b00720bULL, 0x000fe40003f3e000ULL,
0x000000430400720bULL, 0x000fc40003f1e000ULL, 0x0000000b5a0b7208ULL, 0x000fe40004800000ULL,
0x0000000443057208ULL, 0x000fc60004000000ULL, 0x0c401f000b0a7f89ULL, 0x000ea200000e0000ULL,
0x000000420500720bULL, 0x000fc80003f1e000ULL, 0x0000000542047208ULL, 0x000fc80004000000ULL,
0x000000410400720bULL, 0x000fc80003f1e000ULL, 0x0000000441057208ULL, 0x000fc80004000000ULL,
0x000000400500720bULL, 0x000fc80003f1e000ULL, 0x0000000540047208ULL, 0x000fe40004000000ULL,
0x0000000a0b00720bULL, 0x004fe40003f3e000ULL, 0x000000110400720bULL, 0x000fe40003f1e000ULL,
0x0000000b0a0a7208ULL, 0x000fe40004800000ULL, 0x0000000411057208ULL, 0x000fc60004000000ULL,
0x0c201f000a0b7f89ULL, 0x000ea200000e0000ULL, 0x000000100500720bULL, 0x000fc80003f1e000ULL,
0x0000000510047208ULL, 0x000fc80004000000ULL, 0x000000070400720bULL, 0x000fc80003f1e000ULL,
0x0000000407057208ULL, 0x000fc80004000000ULL, 0x000000060500720bULL, 0x000fc80003f1e000ULL,
0x0000000506047208ULL, 0x000fe40004000000ULL, 0x0000000b0a00720bULL, 0x004fe40003f3e000ULL,
0x000000590400720bULL, 0x000fe40003f1e000ULL, 0x0000000a0b287208ULL, 0x000fe40004800000ULL,
0x0000000459057208ULL, 0x000fe40004000000ULL, 0x000000181b00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b280c7820ULL, 0x000fe20000410000ULL, 0x0000005e0500720bULL, 0x000fc40003f1e000ULL,
0x0000001b182b7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b09047823ULL, 0x100fe2000001080cULL,
0x000000055e0a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b49497823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe2000001080cULL,
0x0000005b0a00720bULL, 0x000fe20003f1e000ULL, 0x0000000400047308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b50507823ULL, 0x100fe2000001080cULL,
0x0000000a5b057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b52527823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b51517823ULL, 0x100fe2000001080cULL,
0x000000600500720bULL, 0x000fe20003f1e000ULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b54547823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b53537823ULL, 0x100fe2000001080cULL,
0x0000000560057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b56567823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b55557823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b58587823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b57577823ULL, 0x100fe2000001080cULL, 0x0c401f00050a7f89ULL, 0x000ea200000e0000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b5a5a7823ULL, 0x000fe2000001080cULL,
0x00000003ff187819ULL, 0x000fe20000011603ULL, 0x0c201f002b2e7f89ULL, 0x000ee600000e0000ULL,
0x0000000318187812ULL, 0x000fc400078ec0ffULL, 0x0000004e004e7308ULL, 0x000ff00000000800ULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x0000000a0500720bULL, 0x004fce0003f1e000ULL,
0x0000005000507308ULL, 0x000ea20000000800ULL, 0x000000050a057208ULL, 0x000fe40004000000ULL,
0x0000002e2b00720bULL, 0x008fc60003f3e000ULL, 0x0c201f00050a7f89ULL, 0x000ee400000e0000ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x0000002b2e2b7208ULL, 0x000fe40004800000ULL,
0x0000004d500c723eULL, 0x004fca00000000ffULL, 0x0000005200527308ULL, 0x000eb00000000800ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x0000000a0500720bULL, 0x008fce0003f1e000ULL,
0x0000005400547308ULL, 0x000ee20000000800ULL, 0x0000004f520e723eULL, 0x004fe400000000ffULL,
0x000000050a297208ULL, 0x000fe40004000000ULL, 0x0000004b4e0a723eULL, 0x000fe400000000ffULL,
0x000000191a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b29237820ULL, 0x000fe20000410000ULL,
0x0000005300537308ULL, 0x000fe40000000800ULL, 0x0000001a192a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b08057823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010823ULL,
0x000000044908723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010823ULL,
0x0000000500057308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b07077823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b06067823ULL, 0x100fe20000010823ULL,
0x0000004600467308ULL, 0x000ea20000000800ULL, 0x000000515414723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b5e5e7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b60607823ULL, 0x000fe20000010823ULL,
0xfffffff8ff197812ULL, 0x000fe200078ee262ULL, 0x0c201f002a2d7f89ULL, 0x000ee200000e0000ULL,
0x0000004500457308ULL, 0x000fe60000000800ULL, 0x00000008191b7836ULL, 0x000fc40000000000ULL,
0x0000000819237824ULL, 0x040fe200078e00ffULL, 0x000000054609723eULL, 0x004fe400000000ffULL,
0x0000004400447308ULL, 0x000ea20000000800ULL, 0x0000000819277824ULL, 0x000fe400078e00ffULL,
0x0000000118227824ULL, 0x040fe400078e0219ULL, 0x0000000118257824ULL, 0x000fe400078e021bULL,
0x000000081b307824ULL, 0x040fe200078e00ffULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x000000081b2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee222ULL,
0x0000000422247836ULL, 0x000fe20000000000ULL, 0xfffffff830257812ULL, 0x000fe200078ee225ULL,
0x0000000c22227836ULL, 0x000fe20000000000ULL, 0x00000045440b723eULL, 0x004fc400000000ffULL,
0x0000004200427308ULL, 0x000ea20000000800ULL, 0x0000002d2a00720bULL, 0x008fe40003f1e000ULL,
0xfffffff827247812ULL, 0x000fe400078ee224ULL, 0x0000002a2d2a7208ULL, 0x000fe20004000000ULL,
0x00000020081c723cULL, 0x000fe200000018ffULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0xfffffff82f307812ULL, 0x000fe200078ee222ULL,
0x000000ffff227224ULL, 0x000fc400078e000cULL, 0x00000010252f7824ULL, 0x100fe400078e0231ULL,
0x0000001030307824ULL, 0x000fe200078e0231ULL, 0x00000043420d723eULL, 0x004fe200000000ffULL,
0x0000004000407308ULL, 0x000eb00000000800ULL, 0x0000005600567308ULL, 0x000ee20000000800ULL,
0x00000041400f723eULL, 0x004fce00000000ffULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x000000200c1c723cULL, 0x000fe2000000181cULL, 0x000000535616723eULL, 0x008fcc00000000ffULL,
0x0000001000107308ULL, 0x000ea20000000800ULL, 0x000000ffff257224ULL, 0x000fce00078e0016ULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x000000111015723eULL, 0x004fce00000000ffULL,
0x0000000600067308ULL, 0x000ea20000000800ULL, 0x000000ffff0c7224ULL, 0x000fce00078e0015ULL,
0x0000005500557308ULL, 0x000fe20000000800ULL, 0x000000070617723eULL, 0x004fce00000000ffULL,
0x0000005800587308ULL, 0x000ea20000000800ULL, 0x00000020141c723cULL, 0x000fee000000181cULL,
0x0000005700577308ULL, 0x000fe20000000800ULL, 0x00000001ff157424ULL, 0x000fe200078e00ffULL,
0x000000555818723eULL, 0x004fcc00000000ffULL, 0x0000005a005a7308ULL, 0x000ea20000000800ULL,
0x000000ffff267224ULL, 0x000fce00078e0018ULL, 0x0000005900597308ULL, 0x000fe20000000800ULL,
0x000000575a1a723eULL, 0x004fce00000000ffULL, 0x0000005e005e7308ULL, 0x000ea20000000800ULL,
0x000000ffff277224ULL, 0x000fce00078e001aULL, 0x0000005b005b7308ULL, 0x000fe20000000800ULL,
0x000000595e19723eULL, 0x004fce00000000ffULL, 0x0000006000607308ULL, 0x000ea40000000800ULL,
0x0000005b601b723eULL, 0x004fce00000000ffULL, 0x00000020181c723cULL, 0x000fee000000181cULL,
0x000000ffff207224ULL, 0x000fe400078e0008ULL, 0x000000ffff217224ULL, 0x000fe400078e000aULL,
0x000000ffff087224ULL, 0x000fc400078e0009ULL, 0x000000ffff097224ULL, 0x000fe200078e000bULL,
0x0000000f000b7202ULL, 0x000fe20000000f00ULL, 0x000000ffff0a7224ULL, 0x000fe400078e000dULL,
0x000000ffff0d7224ULL, 0x000fe400078e0017ULL, 0x000000ffff0f7224ULL, 0x000fe200078e001bULL,
0x00000031241f7211ULL, 0x000fe200078e20ffULL, 0x00000010231d7824ULL, 0x000fe400078e0231ULL,
0x000000ffff237224ULL, 0x000fc400078e000eULL, 0x000000ffff247224ULL, 0x000fe400078e0014ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0019ULL, 0x000000201d007844ULL, 0x0005e80000000200ULL,
0x000000241f007844ULL, 0x0007e80000000200ULL, 0x000000082f007844ULL, 0x0007e80000000200ULL,
0x0000000c30007844ULL, 0x0007e20000000200ULL, 0x000000ffff1d7224ULL, 0x004fc600078e001eULL,
0x018000282c008388ULL, 0x0007e80000000c00ULL, 0x0182001c2c008388ULL, 0x0007e20000000a00ULL,
0x0000001047007c0cULL, 0x000fe2000bf06070ULL, 0x018ad81500ff79a7ULL, 0x0007e2000850003fULL,
0x018ae01500ff79a7ULL, 0x0007e2000850003fULL, 0x018ae81500ff79a7ULL, 0x0007e2000850003fULL,
0x018af01500ff79a7ULL, 0x0007f2000850003fULL, 0xffffffb800088947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000009007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000900008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff09ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000009027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000900007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe6802f47950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000562ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006e0ULL, 0x0000000000000240ULL, 0x0000001600000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000920ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a00ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a54ULL, 0x0000000000000a38ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001490ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001490ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000014d8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001500ULL, 0x0000000000019500ULL, 0x0000001600000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x000000000001aa00ULL, 0x0000000000000044ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x000000000001aa50ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x000000000001aa50ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x000000000001b048ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x000000000001b048ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000014d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001500ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019500ULL, 0x0000000000019500ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001aa00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x000000000001aa50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_e4m3_pagedKV_64_nqpkv_1_m_1_sm_90_cubin_len = 111000;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
