/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_fp16_pagedKV_128_nqpkv_1_m_1_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000028640ULL, 0x00000000000282c0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4974613245453233ULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x45386a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x324545386a4c4536ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x746e695f5f240067ULL, 0x5f305f6c616e7265ULL, 0x5f616475635f5f24ULL,
0x7063725f30326d73ULL, 0x5f7a74665f6e725fULL, 0x776f6c735f323366ULL, 0x5f5f240068746170ULL,
0x6c616e7265746e69ULL, 0x75635f5f245f315fULL, 0x5f30376d735f6164ULL, 0x636e79736c666873ULL,
0x00705f796c66625fULL, 0x7265746e695f5f24ULL, 0x5f245f325f6c616eULL, 0x6d735f616475635fULL,
0x736c6668735f3037ULL, 0x5f7864695f636e79ULL, 0x746e695f5f240070ULL, 0x5f335f6c616e7265ULL,
0x5f616475635f5f24ULL, 0x746f765f30376d73ULL, 0x61625f636e797365ULL, 0x5f5f2400746f6c6cULL,
0x6c616e7265746e69ULL, 0x75635f5f245f345fULL, 0x5f30376d735f6164ULL, 0x636e797370726177ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001adULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002ceULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000363ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003a8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003eeULL, 0x00000000000261b0ULL, 0x0000000000000170ULL, 0x000b002200000421ULL,
0x0000000000026320ULL, 0x0000000000000040ULL, 0x000b00220000044cULL, 0x0000000000026360ULL,
0x0000000000000040ULL, 0x000b002200000476ULL, 0x00000000000263a0ULL, 0x0000000000000060ULL,
0x000b0022000004a1ULL, 0x0000000000026400ULL, 0x0000000000000100ULL, 0x000a000300000508ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000528ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000558ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000026500ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000261b000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x0096f80400288080ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8d082880808c0828ULL,
0x2880809408288080ULL, 0x809b082880809608ULL, 0x08288080a2082880ULL, 0x8080a808288080a7ULL,
0xb408288080a90828ULL, 0x2880808608288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808086ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x000261b000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL,
0x8c08288080860828ULL, 0x2880808d08288080ULL, 0x808f082880808e08ULL, 0x0828808094082880ULL,
0x80809b0828808096ULL, 0xb408288080a70828ULL, 0x2880808808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808088ULL, 0x0000001cffffffffULL, 0x0000011800000000ULL,
0x0002632000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080850828808081ULL, 0x8c08288080860828ULL, 0x2880808d08288080ULL, 0x808f082880808e08ULL,
0x0828808094082880ULL, 0x80809b0828808096ULL, 0xb408288080a70828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080b4920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x000001c000000000ULL, 0x0002636000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8c08288080860828ULL, 0x2880808d08288080ULL,
0x808f082880808e08ULL, 0x0828808094082880ULL, 0x80809b0828808096ULL, 0xb408288080a70828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b4920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000026800000000ULL, 0x000263a000000000ULL, 0x0000006000000000ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8808288080860828ULL,
0x2880808c08288080ULL, 0x8094082880808d08ULL, 0x0828808096082880ULL, 0x8080a2082880809bULL,
0xa908288080a70828ULL, 0x288080b408288080ULL, 0x828016288080a808ULL, 0x0000000003102880ULL,
0x8080a89200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000031000000000ULL,
0x0002640000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000c9ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL,
0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001900082304ULL,
0x0008120400000000ULL, 0x0000000000000019ULL, 0x0000001900081104ULL, 0x0004370400000000ULL,
0x000035010000007bULL, 0x0000001600080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL,
0x0021f00000600007ULL, 0x00000000000c1704ULL, 0x0021f00000580006ULL, 0x00000000000c1704ULL,
0x0011f00000500005ULL, 0x00000000000c1704ULL, 0x0061f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x020c290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x020c2804ffffffffULL, 0x0000013000000100ULL,
0x00004600000004b0ULL, 0x0000479000004690ULL, 0x00004b20000048f0ULL, 0x00004ba000004b50ULL,
0x0000712000004bf0ULL, 0x0000719000007140ULL, 0x00009af0000071e0ULL, 0x00009c7000009b80ULL,
0x00009fe000009dc0ULL, 0x0000a0500000a000ULL, 0x0000c2c00000a0a0ULL, 0x0000c3300000c2e0ULL,
0x0000ead00000c380ULL, 0x0000ec500000eb60ULL, 0x0000efc00000eda0ULL, 0x0000f0300000efe0ULL,
0x000112a00000f080ULL, 0x00011310000112c0ULL, 0x00013ab000011360ULL, 0x00013c3000013b40ULL,
0x00013fa000013d80ULL, 0x0001401000013fc0ULL, 0x0001628000014060ULL, 0x000162f0000162a0ULL,
0x00016b7000016340ULL, 0x0001732000016cb0ULL, 0x00018c8000017340ULL, 0x000192f000018ce0ULL,
0x000199c000019330ULL, 0x0001afd000019e00ULL, 0x0001b3700001b350ULL, 0x0001c4f00001c4d0ULL,
0x0001ca400001ca30ULL, 0x0001ddd00001db00ULL, 0x0001ec300001e9f0ULL, 0x0001f9900001f750ULL,
0x000206e0000204a0ULL, 0x00021460000211f0ULL, 0x0002255000021fb0ULL, 0x000245e000023280ULL,
0x0002463000024620ULL, 0x0002465000024640ULL, 0x000246d0000246b0ULL, 0x00025300000246f0ULL,
0x000253b000025350ULL, 0x0002547000025410ULL, 0x00025530000254d0ULL, 0x000255e000025590ULL,
0x0002568000025630ULL, 0x00025740000256e0ULL, 0x00025800000257a0ULL, 0x000258b000025860ULL,
0x0002595000025900ULL, 0x00025a10000259b0ULL, 0x00025ad000025a70ULL, 0x00025b8000025b30ULL,
0x00025c2000025bd0ULL, 0x00025ce000025c80ULL, 0x00025da000025d40ULL, 0x00025e5000025e00ULL,
0x00025ef000025ea0ULL, 0x00025fa000025f40ULL, 0x0002606000026000ULL, 0x00026120000260c0ULL,
0x07b0390400026180ULL, 0x000000ff000001f0ULL, 0x003f010000014ad0ULL, 0x0000000f00000260ULL,
0x003f012000014ad8ULL, 0x0000000f00000360ULL, 0x003f012000014b58ULL, 0x0000000f00000470ULL,
0x003f012000014b78ULL, 0x000000ff000004a0ULL, 0x003f010000014b88ULL, 0x000000ff00000520ULL,
0x003f010700014ad0ULL, 0x00000072000007a0ULL, 0x003f010200014b5cULL, 0x0000007200000800ULL,
0x003f010100014b58ULL, 0x000000ff00000960ULL, 0x003f010100014b88ULL, 0x000000ff000009a0ULL,
0x003f010500014b8cULL, 0x000000ff00000b60ULL, 0x003f010500014b8cULL, 0x000000ff00001e30ULL,
0x003f010100014b88ULL, 0x000000ff00001e60ULL, 0x003f010500014b8cULL, 0x000000ff00002030ULL,
0x003f010500014b8cULL, 0x000000ff000021a0ULL, 0x003f010700014b78ULL, 0x000000ff00002220ULL,
0x003f010100014b78ULL, 0x000000ff00002280ULL, 0x003f010100014b88ULL, 0x000000ff00002560ULL,
0x003f010500014b7cULL, 0x000000ff00002720ULL, 0x003f010500014b7cULL, 0x000000ff00002780ULL,
0x003f010500014b8cULL, 0x000000ff00002950ULL, 0x003f010500014b8cULL, 0x000000ff00003c20ULL,
0x003f010100014b88ULL, 0x000000ff00003c50ULL, 0x003f010500014b8cULL, 0x000000ff00003e20ULL,
0x003f010500014b8cULL, 0x000000ff000041f0ULL, 0x003f010700014b80ULL, 0x000000ff00004270ULL,
0x003f010100014b80ULL, 0x0000007200004320ULL, 0x003f010100014ad8ULL, 0x0000007200004350ULL,
0x003f010500014adcULL, 0x0000007200004520ULL, 0x003f010500014adcULL, 0x000000ff000054b0ULL,
0x003f010100014b88ULL, 0x000000ff00005590ULL, 0x003f010500014b84ULL, 0x000000ff00005750ULL,
0x003f010500014b84ULL, 0x000000ff000057b0ULL, 0x003f010500014b8cULL, 0x000000ff00005980ULL,
0x003f010500014b8cULL, 0x000000ff00006c50ULL, 0x003f010100014b88ULL, 0x000000ff00006c80ULL,
0x003f010500014b8cULL, 0x000000ff00006e50ULL, 0x003f010500014b8cULL, 0x000000ff00007030ULL,
0x003f010700014b78ULL, 0x000000ff000070b0ULL, 0x003f010100014b78ULL, 0x000000ff000078d0ULL,
0x003f010100014b88ULL, 0x000000ff000079a0ULL, 0x003f010100014b58ULL, 0x000000ff00007a90ULL,
0x003f010500014b7cULL, 0x000000ff00007c50ULL, 0x003f010500014b7cULL, 0x000000ff00007cb0ULL,
0x003f010500014b8cULL, 0x000000ff00007e80ULL, 0x003f010500014b8cULL, 0x000000ff00009150ULL,
0x003f010100014b88ULL, 0x000000ff00009180ULL, 0x003f010500014b8cULL, 0x000000ff00009350ULL,
0x003f010500014b8cULL, 0x000000ff000096f0ULL, 0x003f010700014b80ULL, 0x000000ff00009770ULL,
0x003f010100014b80ULL, 0x0000007200009810ULL, 0x003f010100014af8ULL, 0x0000007200009840ULL,
0x003f010500014afcULL, 0x0000007200009a10ULL, 0x003f010500014afcULL, 0x000000ff0000a640ULL,
0x003f010100014b88ULL, 0x000000ff0000a730ULL, 0x003f010500014b84ULL, 0x000000ff0000a8f0ULL,
0x003f010500014b84ULL, 0x000000ff0000a950ULL, 0x003f010500014b8cULL, 0x000000ff0000ab20ULL,
0x003f010500014b8cULL, 0x000000ff0000bdf0ULL, 0x003f010100014b88ULL, 0x000000ff0000be20ULL,
0x003f010500014b8cULL, 0x000000ff0000bff0ULL, 0x003f010500014b8cULL, 0x000000ff0000c1d0ULL,
0x003f010700014b78ULL, 0x000000ff0000c250ULL, 0x003f010100014b78ULL, 0x000000ff0000c8d0ULL,
0x003f010100014b88ULL, 0x000000ff0000c980ULL, 0x003f010100014b60ULL, 0x000000ff0000ca70ULL,
0x003f010500014b7cULL, 0x000000ff0000cc30ULL, 0x003f010500014b7cULL, 0x000000ff0000cc90ULL,
0x003f010500014b8cULL, 0x000000ff0000ce60ULL, 0x003f010500014b8cULL, 0x000000ff0000e130ULL,
0x003f010100014b88ULL, 0x000000ff0000e160ULL, 0x003f010500014b8cULL, 0x000000ff0000e330ULL,
0x003f010500014b8cULL, 0x000000ff0000e6d0ULL, 0x003f010700014b80ULL, 0x000000ff0000e750ULL,
0x003f010100014b80ULL, 0x000000720000e7f0ULL, 0x003f010100014b18ULL, 0x000000720000e820ULL,
0x003f010500014b1cULL, 0x000000720000e9f0ULL, 0x003f010500014b1cULL, 0x000000ff0000f620ULL,
0x003f010100014b88ULL, 0x000000ff0000f710ULL, 0x003f010500014b84ULL, 0x000000ff0000f8d0ULL,
0x003f010500014b84ULL, 0x000000ff0000f930ULL, 0x003f010500014b8cULL, 0x000000ff0000fb00ULL,
0x003f010500014b8cULL, 0x000000ff00010dd0ULL, 0x003f010100014b88ULL, 0x000000ff00010e00ULL,
0x003f010500014b8cULL, 0x000000ff00010fd0ULL, 0x003f010500014b8cULL, 0x000000ff000111b0ULL,
0x003f010700014b78ULL, 0x000000ff00011230ULL, 0x003f010100014b78ULL, 0x000000ff000118b0ULL,
0x003f010100014b88ULL, 0x000000ff00011960ULL, 0x003f010100014b68ULL, 0x000000ff00011a50ULL,
0x003f010500014b7cULL, 0x000000ff00011c10ULL, 0x003f010500014b7cULL, 0x000000ff00011c70ULL,
0x003f010500014b8cULL, 0x000000ff00011e40ULL, 0x003f010500014b8cULL, 0x000000ff00013110ULL,
0x003f010100014b88ULL, 0x000000ff00013140ULL, 0x003f010500014b8cULL, 0x000000ff00013310ULL,
0x003f010500014b8cULL, 0x000000ff000136b0ULL, 0x003f010700014b80ULL, 0x000000ff00013730ULL,
0x003f010100014b80ULL, 0x00000072000137d0ULL, 0x003f010100014b38ULL, 0x0000007200013800ULL,
0x003f010500014b3cULL, 0x00000072000139d0ULL, 0x003f010500014b3cULL, 0x000000ff00014600ULL,
0x003f010100014b88ULL, 0x000000ff000146f0ULL, 0x003f010500014b84ULL, 0x000000ff000148b0ULL,
0x003f010500014b84ULL, 0x000000ff00014910ULL, 0x003f010500014b8cULL, 0x000000ff00014ae0ULL,
0x003f010500014b8cULL, 0x000000ff00015db0ULL, 0x003f010100014b88ULL, 0x000000ff00015de0ULL,
0x003f010500014b8cULL, 0x000000ff00015fb0ULL, 0x003f010500014b8cULL, 0x000000ff00016190ULL,
0x003f010700014b78ULL, 0x000000ff00016210ULL, 0x003f010100014b78ULL, 0x000000ff00016890ULL,
0x003f010100014b88ULL, 0x000000ff00016930ULL, 0x003f010100014b70ULL, 0x000000ff00019c50ULL,
0x003f010100014ad0ULL, 0x000000ff0001b000ULL, 0x003f010500014ad4ULL, 0x000000ff0001b1d0ULL,
0x003f010500014ad4ULL, 0x0000007200023790ULL, 0x003f010100000000ULL, 0x0000007200023b20ULL,
0x003f010500000004ULL, 0x0000007200023cf0ULL, 0x003f010500000004ULL, 0x0000007100025160ULL,
0x003f010100014ad8ULL, 0x00000071000251c0ULL, 0x003f010100014ae0ULL, 0x0000007100025220ULL,
0x003f010100014ae8ULL, 0x0000007100025290ULL, 0x003f010100014af0ULL, 0x00101c0400053803ULL,
0x0001b23000019af0ULL, 0x000252d00001b2d0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000003acULL, 0x0000001900000002ULL, 0x00000000000002fcULL, 0x0000001900000002ULL,
0x0000000000000254ULL, 0x0000001900000002ULL, 0x00000000000001acULL, 0x0000001900000002ULL,
0x0000000000000104ULL, 0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL,
0x0000000000000384ULL, 0x0000001900000002ULL, 0x00000000000002d2ULL, 0x0000001900000002ULL,
0x000000000000022aULL, 0x0000001900000002ULL, 0x0000000000000187ULL, 0x0000001900000002ULL,
0x00000000000000dfULL, 0x0000001900000002ULL, 0x0000000000014c00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0x0000580000097a02ULL, 0x000fe20000000f00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000001000057300ULL, 0x000ee200000e0000ULL, 0x00000000000479c3ULL, 0x000f220000002500ULL,
0x00000004ff177424ULL, 0x000fe200078e00ffULL, 0x0000000000007919ULL, 0x000ea20000002200ULL,
0x0000000409097824ULL, 0x000fc600078e00ffULL, 0x0000000000157919ULL, 0x000ee20000000000ULL,
0x0000001000107309ULL, 0x000ea60000000000ULL, 0x0000000000067919ULL, 0x000ee80000000000ULL,
0x0000000000707919ULL, 0x000ee20000002600ULL, 0x00000005ff787819ULL, 0x002fcc000001160fULL,
0x00001fff78787589ULL, 0x000fe200000e0000ULL, 0x00000004ff7a7e24ULL, 0x010fe4000f8e00ffULL,
0x000001000d007a24ULL, 0x004fe400078e0200ULL, 0x00001fff0d0d7589ULL, 0x000e6400000e0000ULL,
0x00000000000f7a24ULL, 0x000fe400078e020fULL, 0x0000000000007919ULL, 0x000ea20000002700ULL,
0x000000060500720cULL, 0x008fc40003f02070ULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x0000000f0f00780cULL, 0x040fe40003f44070ULL, 0x0000007f0f00780cULL, 0x040fe40003f84070ULL,
0x000000030f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x000000040d047824ULL, 0x002fe400078e0278ULL,
0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL, 0x014ad002ff009388ULL, 0x0003e20000000a00ULL,
0x0000000204087824ULL, 0x000fe200078e00ffULL, 0x3fffff600006b802ULL, 0x000fe20000000f00ULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x0000000200777819ULL, 0x004fe200000006ffULL,
0x00000001080a7824ULL, 0x000fc400078e0215ULL, 0x00000020080b7824ULL, 0x040fe200078e00ffULL,
0x014ad8040f00a388ULL, 0x0005e20000008a00ULL, 0x0000000009097224ULL, 0x000fe200078e0270ULL,
0x0000000408037817ULL, 0x042fe20007800000ULL, 0xff317217ff0ec424ULL, 0x000fe200078e00ffULL,
0xffffffe00b0c7812ULL, 0x000fe200078ee20aULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x00000001080a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x000000010f00780cULL, 0x000fe20003f44070ULL, 0x0000580008027a24ULL, 0x000fe200078e0209ULL,
0x00000200000b7802ULL, 0x000fe20000000f00ULL, 0x000000010a087824ULL, 0x040fe200078e0215ULL,
0x0144000e0f00c388ULL, 0x0003e20000004800ULL, 0x000058000a057a24ULL, 0x044fe200078e0209ULL,
0x000000010300780cULL, 0x000fe20003f83070ULL, 0x000000200a097824ULL, 0x000fe200078e00ffULL,
0x014b58060f00b388ULL, 0x0005e20000008a00ULL, 0x0000001015047824ULL, 0x000fe200078e00ffULL,
0x000000ff0300720cULL, 0x000fe20003f63070ULL, 0x00005c0002027625ULL, 0x000fe200078e000bULL,
0xffffffe0090e7812ULL, 0x002fc600078ee208ULL, 0x3fffff80ff0a9424ULL, 0x000fe200078e00ffULL,
0x000001f004097812ULL, 0x000fe200078ec0ffULL, 0x00005c0005047625ULL, 0x000fc600078e000bULL,
0x0000000902027210ULL, 0x080fe20007fbe0ffULL, 0x7fffff00ff07a424ULL, 0x004fe200078e00ffULL,
0x3fffff000006a802ULL, 0x000fe20000000f00ULL, 0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL,
0x0000000904087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff037224ULL, 0x000fe400028e0603ULL,
0x000000100c117824ULL, 0x000fe200078e00ffULL, 0x00000005ff097210ULL, 0x000fe200037fe4ffULL,
0x000000100e137824ULL, 0x000fe200078e00ffULL, 0x014b78060f00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0a10ULL, 0x0000620077047625ULL, 0x0c0fe200078e0017ULL,
0x014b880aff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002117faeULL, 0x0003e2000d901c46ULL,
0x00006a0077067625ULL, 0x000fc600078e0017ULL, 0x0000000008137faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x014ad40cffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014ad000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604757981ULL, 0x000ea8000c1e1900ULL, 0x0000000606067981ULL, 0x000ee2000c1e1900ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0xffffffffff027424ULL, 0x002fe200078e00ffULL,
0x0000007f75767810ULL, 0x004fc40007ffe0ffULL, 0x000000ff75747810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff737819ULL, 0x008fe40000011606ULL, 0x00000007ff767819ULL, 0x000fe40000011676ULL,
0x00000008ff747819ULL, 0x000fc60000011674ULL, 0x000194c000008947ULL, 0x000fea0003800000ULL,
0x0000002078037824ULL, 0x040fe200078e0215ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000878727824ULL, 0x000fe200078e00ffULL, 0x0000000300097802ULL, 0x000fe20000000f00ULL,
0x000000027a717824ULL, 0x040fe200078e00ffULL, 0x0000001f0300780cULL, 0x040fe20003f04070ULL,
0x000001007a047824ULL, 0x000fe200078e00ffULL, 0x000000030300780cULL, 0x000fd60003f24070ULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0203ULL,
0x00014a0003057811ULL, 0x000fe200078e10ffULL, 0x0000680077067a24ULL, 0x000fc600078e0204ULL,
0x000000750800720cULL, 0x000fe20003f06070ULL, 0x0000000103067824ULL, 0x000fc800078e0206ULL,
0x0000660006067625ULL, 0x000fd000078e0017ULL, 0x0000000006057faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b5c0972ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b580072ff7f8cULL, 0x0007e2000c80043fULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000300057211ULL, 0x002fe400078e10ffULL,
0x0000640071067a10ULL, 0x040fe40007ffe0ffULL, 0x000000767100720cULL, 0x000fe20003f06070ULL,
0x0000000205057824ULL, 0x000fe200078e00ffULL, 0x00014ac003037811ULL, 0x000fc600078e10ffULL,
0x0000640005067a24ULL, 0x000fc800078e0206ULL, 0x0000600006067625ULL, 0x000fca00078e0017ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff067f8cULL, 0x002e62000c80043fULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x002fc400078e0007ULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x014b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x004fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fc800078110ffULL,
0x00000009ff087210ULL, 0x000fc800007fe4ffULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x014b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000017a037810ULL, 0x000fe20007ffe0ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000008070707824ULL, 0x000fe200078e00ffULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000740300720cULL, 0x000fda0003f06070ULL,
0x0000099000008947ULL, 0x000fea0003800000ULL, 0x0000000472057824ULL, 0x040fe200078e00ffULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0x0000000172077824ULL, 0x040fe200078e0270ULL,
0x00000001720d7810ULL, 0x040fe20007ffe0ffULL, 0x00000200ff0f7424ULL, 0x000fe200078e00ffULL,
0x014a000005037984ULL, 0x000f220000000800ULL, 0x00000020720c7824ULL, 0x000fe400078e00ffULL,
0x000000100e0a7824ULL, 0x002fe200078e00ffULL, 0x0000000e72097210ULL, 0x004fc80007ffe0ffULL,
0x000001f00a117812ULL, 0x000fe200078ec0ffULL, 0x000000010d0a7824ULL, 0x000fe400078e020eULL,
0x0000000403087824ULL, 0x010fe200078e00ffULL, 0x0000000475037217ULL, 0x000fc80007800000ULL,
0x014ac00008067984ULL, 0x000e620000000800ULL, 0x0000000304037210ULL, 0x000fc80007ffe1ffULL,
0x0000000372037217ULL, 0x000fca0007800000ULL, 0x0000000103037824ULL, 0x000fca00078e0a72ULL,
0x000000ff0300720cULL, 0x000fe20003f03070ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fe40007f3e0ffULL,
0xffffffe00c067812ULL, 0x000fc600078ee209ULL, 0x000000ffff097224ULL, 0x000fe200008e0607ULL,
0x0000c000060b7811ULL, 0x000fe200078e20ffULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fc600000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000010300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a040005067984ULL, 0x000ea20000000800ULL,
0x00000002720d7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000020300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a080005067984ULL, 0x000ea20000000800ULL,
0x00000003720d7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000030300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a0c0005067984ULL, 0x000ea20000000800ULL,
0x00000004720d7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000040300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a100005067984ULL, 0x000ea20000000800ULL,
0x00000005720d7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000050300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a140005067984ULL, 0x000ea20000000800ULL,
0x00000006720d7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000060300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a180005067984ULL, 0x000ea20000000800ULL,
0x00000007720d7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000070300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a1c0005057984ULL, 0x000ea60000000800ULL,
0x0000c0000a037811ULL, 0x000fe200078e20ffULL, 0x00000004050c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000ea40000000800ULL, 0x0000000406067c24ULL, 0x004fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e2000c101c46ULL, 0x0000084000007947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0x00000200ff107424ULL, 0x000fe200078e00ffULL,
0x000000720e037211ULL, 0x042fe200078fd8ffULL, 0x000000100e077824ULL, 0x000fc600078e00ffULL,
0x0000000e03097210ULL, 0x004fe20007ffe0ffULL, 0x014a000003057984ULL, 0x000e620000004800ULL,
0x0000000170067824ULL, 0x000fe200078e0203ULL, 0x000001f0070f7812ULL, 0x000fe200078ec0ffULL,
0x00000020030a7824ULL, 0x040fe200078e00ffULL, 0x00000001030b7810ULL, 0x000fc80007ffe0ffULL,
0x000000050b127819ULL, 0x040fe200000006ffULL, 0x000000010b0d7824ULL, 0x000fca00078e020eULL,
0xffffffe0120d7812ULL, 0x000fc800078ee20dULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x014ac00005057984ULL, 0x002e640000004800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e0010ULL, 0x0000000f06087210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00a067812ULL, 0x000fc600078ee209ULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000c00006057811ULL, 0x000fe200078e20ffULL, 0x0000000170077824ULL, 0x000fc800078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x014a0400030c7984ULL, 0x000ea20000004800ULL, 0x0000000203057810ULL, 0x002fca0007ffe0ffULL,
0x0000000105097824ULL, 0x040fe400078e020eULL, 0x0000002005127824ULL, 0x000fe200078e00ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe400000e0607ULL, 0x0000000170077824ULL, 0x000fe200078e0205ULL,
0xffffffe012057812ULL, 0x000fe400078ee209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e4000b901c46ULL, 0x0000c00005057811ULL, 0x000fe400078e20ffULL,
0x014a0800030c7984ULL, 0x000ea20000004800ULL, 0x00000003030b7810ULL, 0x002fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000200b127824ULL, 0x000fca00078e00ffULL,
0xffffffe0120d7812ULL, 0x000fc800078ee20dULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f06087210ULL, 0x000fc80007f1e0ffULL,
0x00000007ff097210ULL, 0x000fe200007fe4ffULL, 0x0000000170077824ULL, 0x000fc800078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x014a0c00030c7984ULL, 0x000ea20000004800ULL, 0x0000000403057810ULL, 0x002fca0007ffe0ffULL,
0x0000000105097824ULL, 0x040fe400078e020eULL, 0x0000002005127824ULL, 0x000fe200078e00ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000000570077210ULL, 0x000fe40007ffe0ffULL,
0xffffffe012057812ULL, 0x000fe400078ee209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e4000b901c46ULL, 0x0000c00005057811ULL, 0x000fe400078e20ffULL,
0x014a1000030c7984ULL, 0x000ea20000004800ULL, 0x00000005030b7810ULL, 0x002fc80007ffe0ffULL,
0x0000000e0b0d7210ULL, 0x040fe20007ffe0ffULL, 0x000000200b127824ULL, 0x000fca00078e00ffULL,
0xffffffe0120d7812ULL, 0x000fc800078ee20dULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f06087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe400000e0607ULL, 0x0000000170077824ULL, 0x000fc600078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x014a1400030c7984ULL, 0x000ea20000004800ULL, 0x0000000603057810ULL, 0x002fc80007ffe0ffULL,
0x0000000505127819ULL, 0x040fe200000006ffULL, 0x0000000105097824ULL, 0x000fe200078e020eULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe400000e0607ULL, 0x0000000170077824ULL, 0x000fe200078e0205ULL,
0xffffffe012057812ULL, 0x000fe400078ee209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e4000b901c46ULL, 0x0000c00005057811ULL, 0x000fe400078e20ffULL,
0x014a1800030c7984ULL, 0x000ea20000004800ULL, 0x00000007030b7810ULL, 0x002fc60007ffe0ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fe4000f8e0207ULL,
0x000000010b0c7824ULL, 0x000fe400078e020eULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x0000000f06087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe400000e0607ULL,
0x0000000170077824ULL, 0x000fe400078e020bULL, 0x000000200b0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x014a1c00030a7984ULL, 0x0005220000004800ULL, 0xffffffe00b0c7812ULL, 0x000fc800078ee20cULL,
0x0000c0000c037811ULL, 0x004fe200078e20ffULL, 0x014ac0000a0a7984ULL, 0x010ea40000004800ULL,
0x000000040a077c24ULL, 0x004fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x0000000f06067210ULL, 0x000fc80007f1e0ffULL, 0x00000007ff077210ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e8000b901c46ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff067f8cULL, 0x002e64000c80043fULL,
0x000000ffff0a7224ULL, 0x002fc400078e0007ULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x014b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x014b8c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000000378057211ULL, 0x002fc800078e28ffULL, 0x0000001f0500780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000002004047810ULL, 0x000fe20007ffe0ffULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0x00014a0005097811ULL, 0x000fc600078e10ffULL,
0x0000000105067824ULL, 0x100fe400078e0204ULL, 0x0000680077047a24ULL, 0x000fc600078e0204ULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000000105047824ULL, 0x000fc800078e0204ULL,
0x0000660004047625ULL, 0x000fd000078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b7800ff047f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff067f8cULL, 0x000ea2000c80043fULL, 0x000000747a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff897224ULL, 0x002fe200078e0005ULL, 0x00000000006c7805ULL, 0x000fe2000001ff00ULL,
0xff317217ff6f7424ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x0000001f001f7802ULL, 0x000fe20000000f00ULL,
0xffffffffff207424ULL, 0x000fe200078e00ffULL, 0x00000007003c7202ULL, 0x004fc40000000f00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0001457000000947ULL, 0x000fea0003800000ULL,
0x00005800ff217624ULL, 0x000fe200078e00ffULL, 0x0001455000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6e7224ULL, 0x000fe400078e00ffULL, 0xff317217ff6f7424ULL, 0x000fe200078e00ffULL,
0x0000000721217819ULL, 0x000fc400000006ffULL, 0x000001007a227824ULL, 0x000fca00078e00ffULL,
0x000000752200720cULL, 0x000fda0003f06070ULL, 0x000144a000000947ULL, 0x008fea0003800000ULL,
0x000000ffff887224ULL, 0x000fc600078e00ffULL, 0x0000007a7300720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff237819ULL, 0x000fe20000011688ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000000388287812ULL, 0x040fe400078ec0ffULL,
0x0000002388237207ULL, 0x000fe40002800000ULL, 0x000000ff28287207ULL, 0x000fe40006800000ULL,
0x00000002ff2b7819ULL, 0x000fc40000011623ULL, 0x0000000323297812ULL, 0x000fc600078ec0ffULL,
0x000003002b227a24ULL, 0x000fc400078e027aULL, 0x00000000002a7805ULL, 0x000fca0000015200ULL,
0x014b7c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x0000002f2c2c7211ULL, 0x000fc800078110ffULL,
0x0000002dff2d7210ULL, 0x000fc800007fe4ffULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b7c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fc40000015200ULL,
0x014b8c00ff2d7984ULL, 0x000e640000000800ULL, 0x800000002dff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e2bULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001142dULL,
0x0000002f2c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff2d7224ULL, 0x000fca00000e062dULL,
0x000000022c2c7819ULL, 0x000fc8000000122dULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff2d7984ULL, 0x000e640000000800ULL,
0x800000002dff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001222b7810ULL, 0x040fe20007ffe0ffULL, 0x00000004222a7824ULL, 0x000fe200078e0229ULL,
0x0000120000017945ULL, 0x000fe40003800000ULL, 0x000000742b00720cULL, 0x000fe40003f06070ULL,
0x000000202a2d7811ULL, 0x000fc800078e30ffULL, 0x00000060702b7812ULL, 0x000fce00078ef82dULL,
0x0000098000008947ULL, 0x000fea0003800000ULL, 0x0000000272347819ULL, 0x040fe200000006ffULL,
0x00000001722e7824ULL, 0x040fe400078e022bULL, 0x00000200ff377424ULL, 0x000fe400078e00ffULL,
0x014a0000342a7984ULL, 0x000e620000000800ULL, 0x0000000172357824ULL, 0x040fe400078e0203ULL,
0x0000002072367824ULL, 0x000fca00078e00ffULL, 0xffffffe036357812ULL, 0x000fe400078ee235ULL,
0x0000000172367810ULL, 0x000fe40007ffe0ffULL, 0x0001000035357811ULL, 0x000fc600078e20ffULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe400078e00ffULL,
0x000000042a2f7824ULL, 0x002fe200078e00ffULL, 0x0000002d752a7217ULL, 0x000fc80007800000ULL,
0x014ac0002f2c7984ULL, 0x000e620000000800ULL, 0x000000012a2d7824ULL, 0x000fe200078e0a2dULL,
0x00000004032a7819ULL, 0x000fc800000006ffULL, 0x0000002d722d7217ULL, 0x000fe40007800000ULL,
0x000001f02a397812ULL, 0x000fc600078ec0ffULL, 0x000000012d307824ULL, 0x000fca00078e0a72ULL,
0x000000ff3000720cULL, 0x000fe20003f03070ULL, 0x0000002c212c7224ULL, 0x002fc800078e022eULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000272367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000013000780cULL, 0x000fc60003f03070ULL,
0x014a0400342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe400078e20ffULL, 0x000000022a2a7819ULL, 0x004fcc00000006ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000372367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000023000780cULL, 0x000fc60003f03070ULL,
0x014a0800342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe400078e20ffULL, 0x000000022a2a7819ULL, 0x004fcc00000006ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000472367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000033000780cULL, 0x000fc60003f03070ULL,
0x014a0c00342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe400078e20ffULL, 0x000000022a2a7819ULL, 0x004fcc00000006ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000572367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000043000780cULL, 0x000fc60003f03070ULL,
0x014a1000342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe400078e20ffULL, 0x000000022a2a7819ULL, 0x004fcc00000006ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000672367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000053000780cULL, 0x000fc60003f03070ULL,
0x014a1400342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe400078e20ffULL, 0x000000022a2a7819ULL, 0x004fcc00000006ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000772367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fe400008e062dULL, 0x00000001362b7824ULL, 0x000fc600078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e357faeULL, 0x0003e2000c101c46ULL,
0x000000063000780cULL, 0x000fc60003f03070ULL, 0x014a1800342a7984ULL, 0x000ea20000000800ULL,
0xffffffe03b2f7812ULL, 0x002fe200078ee238ULL, 0x0000000136357824ULL, 0x040fe400078e0203ULL,
0x0000002036367824ULL, 0x000fe200078e00ffULL, 0x000100002f2f7811ULL, 0x000fe400078e20ffULL,
0x000000022a2a7819ULL, 0x004fcc00000006ffULL, 0x014ac0002a2a7984ULL, 0x000e640000000800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0037ULL,
0x000000392c2c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00008e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000073000780cULL, 0x000fc60003f03070ULL, 0x014a1c00342a7984ULL, 0x000ea20000000800ULL,
0xffffffe0362d7812ULL, 0x002fc800078ee235ULL, 0x000100002d2d7811ULL, 0x000fe400078e20ffULL,
0x000000022a2e7819ULL, 0x004fca00000006ffULL, 0x014ac0002e2a7984ULL, 0x000e640000000800ULL,
0x0000002a212a7224ULL, 0x002fc800078e022bULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00008e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0003e2000c101c46ULL,
0x0000083000007947ULL, 0x000fea0003800000ULL, 0x0000007203307211ULL, 0x040fe200078fd8ffULL,
0x00000010032d7824ULL, 0x000fe400078e00ffULL, 0x00000200ff397424ULL, 0x000fe200078e00ffULL,
0x0000002b302c7210ULL, 0x040fe20007ffe0ffULL, 0x014a0000302a7984ULL, 0x000e620000004800ULL,
0x000001f02d3b7812ULL, 0x000fe200078ec0ffULL, 0x00000001302f7824ULL, 0x040fe400078e0203ULL,
0x0000002030347824ULL, 0x000fca00078e00ffULL, 0xffffffe034377812ULL, 0x000fe400078ee22fULL,
0x0000000130347810ULL, 0x000fe40007ffe0ffULL, 0x0001000037377811ULL, 0x000fc600078e20ffULL,
0x0000000134357824ULL, 0x040fe400078e0203ULL, 0x0000002034367824ULL, 0x000fe200078e00ffULL,
0x014ac0002a2a7984ULL, 0x002e640000004800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0039ULL, 0x0000003b2c2e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001342c7824ULL, 0x000fc600078e022bULL, 0x0000002dff2f7210ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e377faeULL, 0x0003e8000b901c46ULL,
0x014a0400302a7984ULL, 0x000ea20000004800ULL, 0x00000002302e7810ULL, 0x002fca0007ffe0ffULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c347210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe200078ee235ULL,
0x000000202e367824ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fe200000e062dULL,
0x000100002c377811ULL, 0x000fe400078e20ffULL, 0x0000002b2e2c7210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e8000b901c46ULL,
0x014a0800302a7984ULL, 0x000ea20000004800ULL, 0x0000000330347810ULL, 0x002fc80007ffe0ffULL,
0x0000000334357210ULL, 0x000fe20007ffe0ffULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c2e7210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe200078ee22fULL,
0x0000002034367824ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e062dULL,
0x000100002c377811ULL, 0x000fe200078e20ffULL, 0x00000001342c7824ULL, 0x000fc800078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e377faeULL, 0x0003e8000b901c46ULL,
0x014a0c00302a7984ULL, 0x000ea20000004800ULL, 0x00000004302e7810ULL, 0x002fca0007ffe0ffULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c347210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe400078ee235ULL,
0x000000052e367819ULL, 0x000fe200000006ffULL, 0x000000ffff357224ULL, 0x000fe200000e062dULL,
0x000100002c377811ULL, 0x000fe200078e20ffULL, 0x000000012e2c7824ULL, 0x000fc800078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e8000b901c46ULL,
0x014a1000302a7984ULL, 0x000ea20000004800ULL, 0x0000000530347810ULL, 0x002fca0007ffe0ffULL,
0x0000000134357824ULL, 0x000fe200078e0203ULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c2e7210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe200078ee22fULL,
0x0000002034367824ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e062dULL,
0x000100002c377811ULL, 0x000fe200078e20ffULL, 0x00000001342c7824ULL, 0x000fc800078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e377faeULL, 0x0003e8000b901c46ULL,
0x014a1400302a7984ULL, 0x000ea20000004800ULL, 0x00000006302e7810ULL, 0x002fca0007ffe0ffULL,
0x000000202e377824ULL, 0x000fe200078e00ffULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c347210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe200078ee235ULL,
0x000000012e367824ULL, 0x000fe200078e0203ULL, 0x0000002dff357210ULL, 0x000fe400007fe4ffULL,
0x000100002c2f7811ULL, 0x000fe200078e20ffULL, 0x000000012e2c7824ULL, 0x000fe200078e022bULL,
0xffffffe037367812ULL, 0x000fc600078ee236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000342f7faeULL, 0x0003e8000b901c46ULL, 0x014a1800302a7984ULL, 0x000ea20000004800ULL,
0x00010000362f7811ULL, 0x002fe400078e20ffULL, 0x0000000730347810ULL, 0x000fc80007ffe0ffULL,
0x0000002b342b7210ULL, 0x040fe20007ffe0ffULL, 0x0000000134357824ULL, 0x040fe400078e0203ULL,
0x0000002034347824ULL, 0x000fca00078e00ffULL, 0xffffffe034357812ULL, 0x000fe200078ee235ULL,
0x014ac0002a2a7984ULL, 0x004e640000004800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0039ULL, 0x0000003b2c2c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff2d7224ULL, 0x000fca00000e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e8000b901c46ULL, 0x014a1c00302e7984ULL, 0x000ea20000004800ULL,
0x00010000352d7811ULL, 0x002fc600078e20ffULL, 0x014ac0002e2e7984ULL, 0x004e640000004800ULL,
0x0000002e212b7224ULL, 0x002fc800078e022bULL, 0x00005e002b2a7625ULL, 0x000fca00078e0039ULL,
0x0000003b2a2a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff2a7f8cULL, 0x002e64000c80043fULL, 0x000000ffff357224ULL, 0x002fc400078e002bULL,
0x00000000002a7805ULL, 0x000fca0000015200ULL, 0x014b8c00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ff002e7202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x0000002f2c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff2d7224ULL, 0x000fca00000e062dULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000227300720cULL, 0x0c0fe20003f24070ULL,
0x0000027000017945ULL, 0x000fe20003800000ULL, 0x00000001282a7810ULL, 0x000fe40007ffe0ffULL,
0x000000227300720cULL, 0x000fe40003f04070ULL, 0x000000032a2b7812ULL, 0x000fc400078ec0ffULL,
0x000000032800780cULL, 0x000fca0004705270ULL, 0x00000002ff2a9819ULL, 0x000fca000001162aULL,
0x00000001292a7824ULL, 0x000fe200078e022aULL, 0x0000000123297812ULL, 0x000fe200078ec0ffULL,
0x0000002078237824ULL, 0x000fc600078e0203ULL, 0x000000012900780cULL, 0x000fe40000705470ULL,
0x00000002ff2d7819ULL, 0x000fe4000001162aULL, 0x000000062a2a7819ULL, 0x000fe400000006ffULL,
0x0000001f2300780cULL, 0x000fe20003f84070ULL, 0x000003002d2d7a24ULL, 0x000fe200078e0222ULL,
0x000000c02a2a7812ULL, 0x000fca00078ec0ffULL, 0x000001002d2d7824ULL, 0x000fe200078e022aULL,
0x000000ff2b2a7207ULL, 0x000fe20004800000ULL, 0x0000015000000947ULL, 0x000fea0003800000ULL,
0x0000002078297824ULL, 0x000fe200078e0203ULL, 0x0000000171287812ULL, 0x000fe200078ec0ffULL,
0x00000300ff227624ULL, 0x000fc600078e00ffULL, 0x000000032900780cULL, 0x000fe40003f24070ULL,
0x000000012800780cULL, 0x000fe40003f05070ULL, 0xffffffff22227811ULL, 0x000fc800078e08ffULL,
0x0000000122227807ULL, 0x000fca0004000000ULL, 0x0000000171717824ULL, 0x000fe200078e0222ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0000002900227211ULL, 0x000fe200078e10ffULL,
0x00000004ff2f7424ULL, 0x000fe200078e00ffULL, 0x00006400712b7a10ULL, 0x040fe40007ffe0ffULL,
0x000000767100720cULL, 0x000fe20003f06070ULL, 0x0000000222227824ULL, 0x000fc800078e00ffULL,
0x0000640022227a24ULL, 0x000fe200078e022bULL, 0x00014ac0292b7811ULL, 0x000fc600078e10ffULL,
0x0000600022287625ULL, 0x000fca00078e002fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x0000000123287824ULL, 0x102fe200078e022dULL, 0x0000000400297802ULL, 0x000fe20000000f00ULL,
0x0000000177227824ULL, 0x000fe200078e022aULL, 0x00014a00232b7811ULL, 0x000fe400078e10ffULL,
0x000000752800720cULL, 0x000fe20003f06070ULL, 0x0000680022227a24ULL, 0x000fc800078e022dULL,
0x0000000123227824ULL, 0x000fc800078e0222ULL, 0x0000660022287625ULL, 0x000fca00078e0029ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8000ff287f8cULL, 0x002e62000c80043fULL,
0x000000ff8800720cULL, 0x000fe20003f05270ULL, 0x0000081000017945ULL, 0x000fe20003800000ULL,
0xffffffffff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff897224ULL, 0x002fd200078e0029ULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014ad80072287f8cULL, 0x000e64000c80043fULL, 0x000000ffff2f7224ULL, 0x002fc400078e0029ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x014adc0072247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ff002c7202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001142bULL, 0x0000002d24247211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x0000000224247819ULL, 0x000fc8000000122bULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x014adc0072247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003247824ULL, 0x000fe200078e00ffULL,
0x00000001ff287819ULL, 0x000fc80000011603ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c28297812ULL, 0x000fca00078ec0ffULL, 0x0000000124297824ULL, 0x000fca00078e0229ULL,
0x0140000029287984ULL, 0x000e680000000800ULL, 0x01420000292a7984ULL, 0x0004e20000000800ULL,
0x0000006f2800720bULL, 0x002fe20003f1d000ULL, 0x00020ce27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x004fc800000e0100ULL, 0x0000ffff242e7812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fd200078e006fULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff7800720cULL, 0x000fe40003f05270ULL, 0x0000006f2800720bULL, 0x000fe20003f34000ULL,
0x00020ca27f007947ULL, 0x000fd8000b800000ULL, 0x00000000002b7806ULL, 0x000fc400008e0100ULL,
0x000000286f2c7209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x000099102b2d7816ULL, 0x000fc600000000ffULL, 0x0144002c29008388ULL, 0x0003e20000000800ULL,
0x000000ff2d00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000002c6f297221ULL, 0x002fe20000010000ULL, 0x000000ff2bff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b29297820ULL, 0x000fc80000410000ULL,
0x0000002900307308ULL, 0x000e640000000800ULL, 0x000000301e1e7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011603ULL,
0x00020bf27f007947ULL, 0x000fea000b800000ULL, 0x00001f2930297589ULL, 0x0002a400000e0000ULL,
0x000000291d1d7220ULL, 0x084fe20000410000ULL, 0x000000291c1c7220ULL, 0x080fe20000410000ULL,
0x0000002919197220ULL, 0x080fe20000410000ULL, 0x0000002918187220ULL, 0x080fe20000410000ULL,
0x0000002915157220ULL, 0x080fe20000410000ULL, 0x0000002914147220ULL, 0x080fe20000410000ULL,
0x0000002911117220ULL, 0x080fe20000410000ULL, 0x0000002910107220ULL, 0x080fe20000410000ULL,
0x000000290d0d7220ULL, 0x080fe20000410000ULL, 0x000000290c0c7220ULL, 0x080fe20000410000ULL,
0x0000002909097220ULL, 0x080fe20000410000ULL, 0x0000002908087220ULL, 0x080fe20000410000ULL,
0x0000002905057220ULL, 0x080fe20000410000ULL, 0x0000002904047220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x000000296c6c7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff002bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803297811ULL, 0x000fe200078ff0ffULL,
0x00020af27f007947ULL, 0x000fea000b800000ULL, 0x00001f2930297589ULL, 0x00046400000e0000ULL,
0x000000291b1b7220ULL, 0x082fe20000410000ULL, 0x000000291a1a7220ULL, 0x080fe20000410000ULL,
0x0000002917177220ULL, 0x080fe20000410000ULL, 0x0000002916167220ULL, 0x080fe20000410000ULL,
0x0000002913137220ULL, 0x080fe20000410000ULL, 0x0000002912127220ULL, 0x080fe20000410000ULL,
0x000000290f0f7220ULL, 0x080fe20000410000ULL, 0x000000290e0e7220ULL, 0x080fe20000410000ULL,
0x000000290b0b7220ULL, 0x080fe20000410000ULL, 0x000000290a0a7220ULL, 0x080fe20000410000ULL,
0x0000002907077220ULL, 0x080fe20000410000ULL, 0x0000002906067220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x000000296d6d7220ULL, 0x080fe20000410000ULL, 0x000000296e6e7220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff2eff7812ULL, 0x000fda000780602bULL,
0x8000002c28280221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800250308ULL, 0x000e640000000800ULL,
0x000000252a2a0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001e2a1e7221ULL, 0x008fe20000010000ULL, 0x0000002c006f7202ULL, 0x000fc40000000f00ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000782c0ffULL,
0x0000014000017945ULL, 0x000fd80003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fe400000000ffULL, 0x00000002ff287819ULL, 0x000fe40000011603ULL,
0x0000541026297816ULL, 0x000fe20000000026ULL, 0x000209227f007947ULL, 0x000fea000b800000ULL,
0x00001f2829277589ULL, 0x0002a400000e0000ULL, 0x0000000828267810ULL, 0x000fe20007ffe0ffULL,
0x000209527f007947ULL, 0x000fea000b800000ULL, 0x00001f2629267589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010283b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0029ULL, 0x00004bb000347802ULL, 0x000fc40000000f00ULL,
0x000217b000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018283b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x004fe200078e0029ULL,
0x00004c0000347802ULL, 0x000fc40000000f00ULL, 0x0002176000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000703827812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000002722c7810ULL, 0x000fe20007ffe0ffULL,
0x000006e000017945ULL, 0x000fe20003800000ULL, 0x0000000882827812ULL, 0x000fc400078ef803ULL,
0x0000000803847812ULL, 0x040fe400078ec0ffULL, 0x00000004722a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000882287824ULL, 0x002fe200078e00ffULL, 0x0000002c03857211ULL, 0x040fe400078fe0ffULL,
0x00000006722c7810ULL, 0x000fe40007ffe0ffULL, 0x0000008203817211ULL, 0x000fe400078fe0ffULL,
0x0000000784847812ULL, 0x000fc400078ef803ULL, 0x0000002a03877211ULL, 0x040fe400078fe0ffULL,
0x0000002c038b7211ULL, 0x040fe200078fe0ffULL, 0x00000020842e7824ULL, 0x040fe200078e00ffULL,
0x0000007203837211ULL, 0x000fe200078fe0ffULL, 0x00000001842a7824ULL, 0x000fe200078e0285ULL,
0xfffffff828287812ULL, 0x000fe200078ee281ULL, 0x00000020842d7824ULL, 0x040fe200078e00ffULL,
0x0000008384297210ULL, 0x040fe20007ffe0ffULL, 0x00000001842b7824ULL, 0x000fe200078e0287ULL,
0x0000a00028347811ULL, 0x000fe200078e20ffULL, 0x00000001842c7824ULL, 0x000fe200078e028bULL,
0xffffffe02e297812ULL, 0x000fc400078ee229ULL, 0xffffffe02d2a7812ULL, 0x040fe400078ee22aULL,
0xffffffe02e2b7812ULL, 0x000fe200078ee22bULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0xffffffe02d2d7812ULL, 0x000fe400078ee22cULL, 0x0000c00029297811ULL, 0x000fe400078e20ffULL,
0x0000c0002a2a7811ULL, 0x000fe400078e20ffULL, 0x0000c0002b2b7811ULL, 0x000fe200078e20ffULL,
0x000000002950783bULL, 0x000f220000004200ULL, 0x0000c0002d2d7811ULL, 0x000fc400078e20ffULL,
0x00000003822f7819ULL, 0x000fe200000006ffULL, 0x000000002a5c783bULL, 0x000ee20000004200ULL,
0x00000002812e7810ULL, 0x000fe40007ffe0ffULL, 0x0000001084307812ULL, 0x004fe200078efcffULL,
0x000000002b64783bULL, 0x000fe20000004200ULL, 0xfffffff82f2c7812ULL, 0x000fe400078ee22eULL,
0x00000005302e7819ULL, 0x000fe200000006ffULL, 0x000000002d3c783bULL, 0x000fe20000004200ULL,
0x0000000183807824ULL, 0x100fe200078e0230ULL, 0x0000a0002c387811ULL, 0x000fe200078e20ffULL,
0x0000002030397824ULL, 0x040fe200078e00ffULL, 0x00000002ff7c7819ULL, 0x000fe20000011603ULL,
0x00000001857f7824ULL, 0x100fe200078e0230ULL, 0x0000007a7300720cULL, 0x000fe20003fc3070ULL,
0x00000001877e7824ULL, 0x000fe200078e0230ULL, 0xffffffe039807812ULL, 0x000fe200078ee280ULL,
0x00000020302f7824ULL, 0x000fe200078e00ffULL, 0xffffffe02e7f7812ULL, 0x000fe200078ee27fULL,
0x000000018b7d7824ULL, 0x000fe200078e0230ULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x0000002030447824ULL, 0x000fe200078e00ffULL, 0xffffffe02f7e7812ULL, 0x000fc400078ee27eULL,
0x0000c000802e7811ULL, 0x000fe400078e20ffULL, 0xffffffe0447d7812ULL, 0x000fe400078ee27dULL,
0x0000c0007f2f7811ULL, 0x000fe200078e20ffULL, 0x000000002e40783bULL, 0x000ea20000004200ULL,
0x0000c0007e307811ULL, 0x000fe200078e20ffULL, 0x0000002734349232ULL, 0x082fe20000000000ULL,
0x0000c0007d797811ULL, 0x000fe200078e20ffULL, 0x000000002f44783bULL, 0x000e620000004200ULL,
0x0000002736369232ULL, 0x000fe20000000000ULL, 0x000000887c00720cULL, 0x040fe20003f46070ULL,
0x0000002635359232ULL, 0x088fe20000000000ULL, 0x00000000304c783bULL, 0x000ee20000004200ULL,
0x0000002637379232ULL, 0x000fe20000000000ULL, 0x000000087c7b7810ULL, 0x000fc40007ffe0ffULL,
0x000000007954783bULL, 0x000e620000004200ULL, 0x0000007a7300720cULL, 0x000fe40003f03070ULL,
0x000000887b00720cULL, 0x000fe20003f66070ULL, 0x000000503448723cULL, 0x050f7000000018ffULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x0000002738389232ULL, 0x004fce0000000000ULL,
0x000000643460723cULL, 0x000fe200000018ffULL, 0x000000273a3a9232ULL, 0x000fe40000000000ULL,
0x0000002639399232ULL, 0x080fe40000000000ULL, 0x000000263b3b9232ULL, 0x000fc60000000000ULL,
0x000000523450723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040b6e00000018ffULL,
0x00000001883c7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000018ffULL,
0x0000003c7c00720cULL, 0x000fc40005746470ULL, 0x0000003c7b00720cULL, 0x000fc60005f66470ULL,
0x000000403848723cULL, 0x040b700000001848ULL, 0x000000423850723cULL, 0x040b700000001850ULL,
0x000000443858723cULL, 0x042b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x0000004c3860723cULL, 0x048b700000001860ULL, 0x0000004e3864723cULL, 0x040b700000001864ULL,
0x000000543868723cULL, 0x040b700000001868ULL, 0x000000563834723cULL, 0x020b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000481d1d7221ULL, 0x000fe20000010000ULL, 0x000000491c1c7221ULL, 0x000fe20000010000ULL,
0x0000005019197221ULL, 0x000fe20000010000ULL, 0x0000005118187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006904047221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x020fe20000010000ULL, 0x000000356c6c7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0000000000ULL, 0x0000004a1b1b7221ULL, 0x000fe20000010000ULL,
0x0000004b1a1a7221ULL, 0x000fe20000010000ULL, 0x0000005217177221ULL, 0x000fe20000010000ULL,
0x0000005316167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b32327221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x020fe20000010000ULL,
0x000000376e6e7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x00000002ff377819ULL, 0x000fe2000001163cULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000007a7300720cULL, 0x000fc40003f03070ULL, 0x000000373c377207ULL, 0x040fe40002800000ULL,
0x000000033c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000002ff397819ULL, 0x000fe40000011637ULL,
0x0000007a7300720cULL, 0x000fe40003fc3070ULL, 0x00000001ff407803ULL, 0x000fe40000000000ULL,
0x0000000337377812ULL, 0x000fc400078ec0ffULL, 0x00000035003f7202ULL, 0x002fe20000000f00ULL,
0x0000030039347a24ULL, 0x000fe200078e027aULL, 0x000000ff3c357207ULL, 0x000fc40006800000ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b8400ff367984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe20007804889ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff367984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000036ff7812ULL, 0x002fe2000780483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fc80007f1e1ffULL, 0x0000003b393b7210ULL, 0x000fe400007fe5ffULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc8000001143bULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x0000000236367819ULL, 0x000fc8000000123bULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001343b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000434367824ULL, 0x000fe200078e0237ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743b00720cULL, 0x000fe20003f06070ULL, 0x00000040363f7824ULL, 0x000fca00078e00ffULL,
0x0000004070397812ULL, 0x000fce00078ef83fULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x0000000472417824ULL, 0x040fe200078e00ffULL, 0x0000000172427810ULL, 0x040fe20007ffe0ffULL,
0x0000000172387824ULL, 0x000fe400078e0239ULL, 0x00000200ff437424ULL, 0x000fe200078e00ffULL,
0x014a000041367984ULL, 0x000e640000000800ULL, 0x00000002363e7819ULL, 0x002fca00000006ffULL,
0x014ac0003e367984ULL, 0x000e640000000800ULL, 0x0000003621367224ULL, 0x002fe400078e0238ULL,
0x0000001003387824ULL, 0x000fe400078e00ffULL, 0x00005e00363a7625ULL, 0x000fe200078e0043ULL,
0x0000003f75367217ULL, 0x000fe40007800000ULL, 0x000001f038457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL, 0x00000039423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000000363f3b7210ULL, 0x000fe20007ffe1ffULL,
0x0000000172367824ULL, 0x040fe400078e0203ULL, 0x00000020723f7824ULL, 0x040fe200078e00ffULL,
0x0000003b723b7217ULL, 0x000fc80007800000ULL, 0xffffffe03f387812ULL, 0x000fe200078ee236ULL,
0x000000013b367824ULL, 0x000fc600078e0a72ULL, 0x0000c00038477811ULL, 0x000fe400078e20ffULL,
0x000000ff3600720cULL, 0x000fda0003f03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000c101c46ULL, 0x014a040041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000000013600780cULL, 0x000fe20003f03070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000272427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe400078e20ffULL,
0x00000039423a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000c101c46ULL, 0x014a080041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000000023600780cULL, 0x000fe20003f03070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000372427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe400078e20ffULL,
0x00000039423a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000c101c46ULL, 0x014a0c0041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000000033600780cULL, 0x000fe20003f03070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000472427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe400078e20ffULL,
0x00000039423a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000c101c46ULL, 0x014a100041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000000043600780cULL, 0x000fe20003f03070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000572427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe400078e20ffULL,
0x00000039423a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000c101c46ULL, 0x014a140041387984ULL, 0x000ea20000000800ULL,
0x00000006723c7810ULL, 0x002fe20007ffe0ffULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001423a7824ULL, 0x000fc800078e0203ULL, 0x000000ffff3f7224ULL, 0x000fe200000e063bULL,
0x000000053600780cULL, 0x000fe20003f03070ULL, 0x00000020423b7824ULL, 0x000fe400078e00ffULL,
0x000000013c427824ULL, 0x000fc600078e0203ULL, 0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL,
0x0000c0003a3d7811ULL, 0x000fe400078e20ffULL, 0x000000393c3a7210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000c101c46ULL,
0x014a180041387984ULL, 0x000ea20000000800ULL, 0x000000203c3d7824ULL, 0x002fe200078e00ffULL,
0x00000007723e7810ULL, 0x000fc80007ffe0ffULL, 0xffffffe03d427812ULL, 0x000fe200078ee242ULL,
0x000000013e3f7824ULL, 0x040fe200078e0203ULL, 0x000000393e397210ULL, 0x040fe20007ffe0ffULL,
0x000000203e3e7824ULL, 0x000fe200078e00ffULL, 0x0000c000423d7811ULL, 0x000fc800078e20ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x0000c0003f3f7811ULL, 0x000fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x000000063600780cULL, 0x000fda0003f03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000c101c46ULL, 0x014a1c0041387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x0000004538387210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff397224ULL, 0x000fe200000e0639ULL,
0x000000073600780cULL, 0x000fda0003f03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203427211ULL, 0x040fe200078fd8ffULL, 0x00000010033c7824ULL, 0x000fe200078e00ffULL,
0x0000020000417802ULL, 0x000fe40000000f00ULL, 0x0000000142447810ULL, 0x040fe20007ffe0ffULL,
0x014a000042367984ULL, 0x000e620000004800ULL, 0x0000000142387824ULL, 0x000fe200078e0239ULL,
0x000001f03c437812ULL, 0x000fe400078ec0ffULL, 0x014ac00036367984ULL, 0x002e640000004800ULL,
0x0000003621387224ULL, 0x002fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x0000000142387824ULL, 0x000fe200078e0203ULL, 0x000000433a3c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe400000e063bULL, 0x00000020423b7824ULL, 0x000fca00078e00ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x000fe400078e20ffULL,
0x0000003944387210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a040042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe400000e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000242447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fc80007f1e0ffULL, 0x0000003bff3d7210ULL, 0x000fe200007fe4ffULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000342447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fe200078e0041ULL, 0x0000000344387210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe400000e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000442447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e063bULL,
0x00000005443b7819ULL, 0x000fe400000006ffULL, 0x0000000542447810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140042367984ULL, 0x000ea20000004800ULL,
0x00000006423c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621387224ULL, 0x002fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe400000e063bULL,
0x00000020443b7824ULL, 0x000fca00078e00ffULL, 0xffffffe03b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x000fe400078e20ffULL, 0x000000393c387210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180042367984ULL, 0x000ea80000004800ULL, 0x014ac00036367984ULL, 0x004ea40000004800ULL,
0x0000003621387224ULL, 0x004fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x000000013c387824ULL, 0x000fe200078e0203ULL, 0x000000433a3a7210ULL, 0x000fe40007f1e0ffULL,
0x00000007423c7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe045387812ULL, 0x000fe200078ee238ULL,
0x000000ffff3b7224ULL, 0x000fe400000e063bULL, 0x000000013c397824ULL, 0x000fe200078e0239ULL,
0x0000c000383d7811ULL, 0x002fe200078e20ffULL, 0x000000013c3e7824ULL, 0x000fc400078e0203ULL,
0x000000203c3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000b901c46ULL, 0xffffffe03f3e7812ULL, 0x000fe200078ee23eULL,
0x014a1c0042367984ULL, 0x000ea60000004800ULL, 0x0000c0003e3b7811ULL, 0x002fe200078e20ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621397224ULL, 0x002fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fc80007f1e0ffULL,
0x00000039ff397210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e8000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff367984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe2000780483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fc80007f1e1ffULL,
0x0000003b393b7210ULL, 0x000fe400007fe5ffULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe40003f04070ULL, 0x00014a0023397811ULL, 0x000fe400078e10ffULL,
0x000000ff35367207ULL, 0x000fc40000000000ULL, 0x000000ff35387207ULL, 0x000fc60004000000ULL,
0x0000000137367824ULL, 0x000fe400078e0236ULL, 0x00000004ff377424ULL, 0x000fc600078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011636ULL, 0x0000004036367824ULL, 0x000fc800078e00ffULL,
0x0000030035357a24ULL, 0x000fe200078e0234ULL, 0x000000c036367812ULL, 0x000fe400078ec0ffULL,
0x0000003877347210ULL, 0x000fc60007ffe0ffULL, 0x0000010035357824ULL, 0x000fca00078e0236ULL,
0x0000002035357810ULL, 0x000fca0007ffe0ffULL, 0x0000000123367824ULL, 0x100fe400078e0235ULL,
0x0000680034347a24ULL, 0x000fc600078e0235ULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff347f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff897224ULL, 0x002fe200078e0035ULL,
0x0000010000001947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000000ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x0001e3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002a400000e0000ULL, 0x0001e4227f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x000071a000347802ULL, 0x000fc40000000f00ULL, 0x0001f1c000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x000071f000347802ULL, 0x000fc40000000f00ULL,
0x0001f17000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000882357824ULL, 0x000fe200078e00ffULL, 0x0000000481867810ULL, 0x000fe20007ffe0ffULL,
0x00000001848b7824ULL, 0x040fe200078e028bULL, 0x0000008784877210ULL, 0x040fe20007ffe0ffULL,
0x0000000184857824ULL, 0x040fe200078e0285ULL, 0xfffffff835867812ULL, 0x000fe200078ee286ULL,
0x0000000184837824ULL, 0x040fe200078e0283ULL, 0x00000005843c7819ULL, 0x040fe200000006ffULL,
0x00000020843a7824ULL, 0x004fe200078e00ffULL, 0x0000a00086347811ULL, 0x000fe200078e20ffULL,
0x0000002084387824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000002084847824ULL, 0x000fe200078e00ffULL, 0xffffffe03a8b7812ULL, 0x000fe200078ee28bULL,
0x0000045000017945ULL, 0x000fe20003800000ULL, 0xffffffe038387812ULL, 0x000fe200078ee283ULL,
0x000000003434783bULL, 0x00ae620000000200ULL, 0xffffffe084847812ULL, 0x000fc400078ee285ULL,
0xffffffe03c837812ULL, 0x000fe400078ee287ULL, 0x0001000038857811ULL, 0x000fe200078e20ffULL,
0x0000000882387824ULL, 0x000fe200078e00ffULL, 0x0001000084847811ULL, 0x000fe400078e20ffULL,
0x0001000083837811ULL, 0x000fe200078e20ffULL, 0x000000008554783bULL, 0x000ea20000004200ULL,
0x000100008b827811ULL, 0x000fe400078e20ffULL, 0x0000000681817810ULL, 0x000fe20007ffe0ffULL,
0x00000000845c783bULL, 0x000ee20000004200ULL, 0x0001000080807811ULL, 0x000fc400078e20ffULL,
0xfffffff838817812ULL, 0x000fe200078ee281ULL, 0x000000008364783bULL, 0x000f220000004200ULL,
0x000100007f7f7811ULL, 0x000fe400078e20ffULL, 0x0000a00081387811ULL, 0x000fe200078e20ffULL,
0x00000000823c783bULL, 0x000fe20000004200ULL, 0x000100007e7e7811ULL, 0x000fe400078e20ffULL,
0x000100007d7d7811ULL, 0x000fe200078e20ffULL, 0x000000007f44783bULL, 0x000fe20000004200ULL,
0x000000ff4000720cULL, 0x000fc60003f05270ULL, 0x000000003838783bULL, 0x000f280000000200ULL,
0x000000008040783bULL, 0x000f280000004200ULL, 0x000000007e48783bULL, 0x000f220000004200ULL,
0x0000002734349232ULL, 0x002fc60000000000ULL, 0x000000007d4c783bULL, 0x000e620000004200ULL,
0x0000002736369232ULL, 0x000fe40000000000ULL, 0x0000002635359232ULL, 0x080fe40000000000ULL,
0x0000002637379232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x044f7000000018ffULL,
0x0000005c3458723cULL, 0x048ff000000018ffULL, 0x000000643460723cULL, 0x010fe200000018ffULL,
0x0000002738389232ULL, 0x000fc40000000000ULL, 0x000000273a3a9232ULL, 0x000fe40000000000ULL,
0x0000002639399232ULL, 0x080fe40000000000ULL, 0x000000263b3b9232ULL, 0x000fe20000000000ULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040f7000000018ffULL,
0x0000003e3434723cULL, 0x000f7000000018ffULL, 0x000000403850723cULL, 0x060b700000001850ULL,
0x000000423854723cULL, 0x040b700000001854ULL, 0x000000443858723cULL, 0x040b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x000000483860723cULL, 0x040b700000001860ULL,
0x0000004a3864723cULL, 0x040b700000001864ULL, 0x0000004c3868723cULL, 0x042b700000001868ULL,
0x0000004e3834723cULL, 0x000b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0000000000ULL, 0x000000501d1d7221ULL, 0x020fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x000fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003000000ULL,
0x000000521b1b7221ULL, 0x020fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x000fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000188887810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x00000004ff877424ULL, 0x000fca00078e00ffULL, 0x0000000187877807ULL, 0x000fc80006800000ULL,
0x000000878800720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffab7000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000407a347811ULL, 0x000fe200078e40ffULL,
0x014b5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000753400720cULL, 0x000fda0003f06070ULL,
0x0000ef7000000947ULL, 0x000fea0003800000ULL, 0x000000ff00887202ULL, 0x000fc80000000f00ULL,
0x00000002ff357819ULL, 0x000fe20000011688ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000388367812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000003588357207ULL, 0x000fe40002800000ULL, 0x000000ff36367207ULL, 0x000fe40006800000ULL,
0x0000000135377810ULL, 0x000fc80007ffe0ffULL, 0x00000002ff397819ULL, 0x000fe40000011637ULL,
0x0000000337357812ULL, 0x000fc600078ec0ffULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fc80007f1e1ffULL, 0x0000003b393b7210ULL, 0x000fe400007fe5ffULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000134397810ULL, 0x040fe20007ffe0ffULL,
0x0000000434387824ULL, 0x000fe200078e0235ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743900720cULL, 0x000fe40003f06070ULL, 0x00000020383b7811ULL, 0x000fc800078e30ffULL,
0x0000006070397812ULL, 0x000fce00078ef83bULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x00000004723f7824ULL, 0x040fe200078e00ffULL, 0x00000039723c7210ULL, 0x040fe20007ffe0ffULL,
0x00000200ff417424ULL, 0x000fe400078e00ffULL, 0x0000000172407824ULL, 0x040fe200078e0203ULL,
0x014a00003f387984ULL, 0x000e620000000800ULL, 0x0000002072457824ULL, 0x000fca00078e00ffULL,
0xffffffe045407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x000fe400078e20ffULL,
0x0000000172407810ULL, 0x000fc80007ffe0ffULL, 0x0000000340427210ULL, 0x040fe20007ffe0ffULL,
0x0000002040477824ULL, 0x000fca00078e00ffULL, 0xffffffe047427812ULL, 0x000fe200078ee242ULL,
0x00000004383d7824ULL, 0x002fe200078e00ffULL, 0x0000003b75387217ULL, 0x000fc80007800000ULL,
0x014ac0003d3a7984ULL, 0x000e620000000800ULL, 0x00000001383b7824ULL, 0x000fe400078e0a3bULL,
0x0000001003387824ULL, 0x000fc600078e00ffULL, 0x0000003b723b7217ULL, 0x000fe40007800000ULL,
0x000001f038437812ULL, 0x000fe400078ec0ffULL, 0x0000003b723e7210ULL, 0x000fc80007ffe1ffULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003a213a7224ULL, 0x002fc800078e023cULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000272407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fc60003f03070ULL, 0x014a04003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000372407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fc60003f03070ULL, 0x014a08003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000472407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000033e00780cULL, 0x000fc60003f03070ULL, 0x014a0c003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000572407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fc60003f03070ULL, 0x014a10003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000672407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fc60003f03070ULL, 0x014a14003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000772407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000000140397824ULL, 0x000fc600078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x014a18003f387984ULL, 0x000ea20000000800ULL,
0x00010000423d7811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fe20007ffe0ffULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x014a1c003f387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fc800078e0041ULL,
0x0000002040417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007f3e0ffULL,
0xffffffe041427812ULL, 0x000fe200078ee242ULL, 0x000000ffff397224ULL, 0x000fc600008e0639ULL,
0x00010000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203407211ULL, 0x040fe200078fd8ffULL, 0x00000010033b7824ULL, 0x000fe200078e00ffULL,
0x0000020000417802ULL, 0x000fc60000000f00ULL, 0x014a000040387984ULL, 0x000e620000004800ULL,
0x00000001403a7824ULL, 0x040fe200078e0239ULL, 0x000001f03b437812ULL, 0x000fe200078ec0ffULL,
0x00000001403d7824ULL, 0x040fe400078e0203ULL, 0x00000020403e7824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x002e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fe400078ee23dULL, 0x00000001403e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000033e3f7210ULL, 0x040fe20007ffe0ffULL, 0x000000013e3a7824ULL, 0x040fe400078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x000000203e427824ULL, 0x000fc600078e00ffULL, 0x014a040040387984ULL, 0x000ea20000004800ULL,
0x00000002403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe400078ee23fULL, 0x000000053c427819ULL, 0x000fe200000006ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080040387984ULL, 0x000ea20000004800ULL,
0x00000003403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0040387984ULL, 0x000ea20000004800ULL,
0x00000004403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe200078e00ffULL,
0x0000003bff3f7210ULL, 0x000fe400007fe4ffULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100040387984ULL, 0x000ea20000004800ULL,
0x00000005403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000393e3a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140040387984ULL, 0x000ea20000004800ULL,
0x00000006403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe400078ee23fULL, 0x000000033c427210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a3d7811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fe200078e0239ULL, 0xffffffe045427812ULL, 0x000fc600078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180040387984ULL, 0x000ea20000004800ULL, 0x00010000423d7811ULL, 0x002fe400078e20ffULL,
0x00000007403e7810ULL, 0x000fca0007ffe0ffULL, 0x000000013e397824ULL, 0x040fe400078e0239ULL,
0x000000013e3f7824ULL, 0x040fe200078e0203ULL, 0x000000053e3e7819ULL, 0x000fc800000006ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x000100003f3f7811ULL, 0x000fe200078e20ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000b901c46ULL, 0x014a1c00403c7984ULL, 0x000ea80000004800ULL,
0x014ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c21397224ULL, 0x004fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fc800078110ffULL, 0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000300ff377624ULL, 0x000fe200078e00ffULL,
0x0000000171387812ULL, 0x000fc800078ec0ffULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fca0004000000ULL,
0x0000000171717824ULL, 0x000fe200078e0238ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400377824ULL, 0x000fe200078e0223ULL, 0x0000640071387a10ULL, 0x040fe40007ffe0ffULL,
0x000000767100720cULL, 0x000fe20003f06070ULL, 0x0000000237377824ULL, 0x000fe200078e00ffULL,
0x0000000400397802ULL, 0x000fc60000000f00ULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x00014ac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000347300720cULL, 0x000fe40003f04070ULL,
0x0000000136367810ULL, 0x000fc80007ffe0ffULL, 0x0000000336377812ULL, 0x002fce00078ec0ffULL,
0x00000002ff368819ULL, 0x000fca0000011636ULL, 0x0000000135357824ULL, 0x000fe200078e0236ULL,
0x000000ff37367207ULL, 0x000fe40004000000ULL, 0x00014a0023377811ULL, 0x000fe400078e10ffULL,
0x00000002ff397819ULL, 0x000fe20000011635ULL, 0x0000004035357824ULL, 0x000fc800078e00ffULL,
0x0000030039397a24ULL, 0x000fe200078e0234ULL, 0x000000c035347812ULL, 0x000fe200078ec0ffULL,
0x00000004ff357424ULL, 0x000fc800078e00ffULL, 0x0000010039397824ULL, 0x000fe400078e0234ULL,
0x0000000177347824ULL, 0x000fc600078e0236ULL, 0x0000003923367210ULL, 0x000fe20007ffe0ffULL,
0x0000680034347a24ULL, 0x000fc600078e0239ULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8000ff347f8cULL, 0x000e62000c80043fULL,
0x000000ff8800720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff897224ULL, 0x002fd600078e0035ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014af80072347f8cULL, 0x000e64000c80043fULL,
0x000000ffff3b7224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x014afc0072247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ff00387202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011437ULL,
0x0000003924247211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000224247819ULL, 0x000fc80000001237ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x014afc0072247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003247824ULL, 0x000fe200078e00ffULL, 0x00000001ff347819ULL, 0x000fc80000011603ULL,
0x0000007024247812ULL, 0x000fe400078ec0ffULL, 0x0000000c34357812ULL, 0x000fca00078ec0ffULL,
0x00000001243b7824ULL, 0x000fca00078e0235ULL, 0x014080003b367984ULL, 0x000e680000000800ULL,
0x014280003b377984ULL, 0x0004e20000000800ULL, 0x0000006f3600720bULL, 0x002fe20003f1d000ULL,
0x0001bad27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x004fc800000e0100ULL,
0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fd200078e006fULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000017800780cULL, 0x000fe40003f05270ULL,
0x0000006f3600720bULL, 0x000fe20003f34000ULL, 0x0001ba927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000397806ULL, 0x000fc400008e0100ULL, 0x000000366f387209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991039347816ULL, 0x000fc600000000ffULL,
0x014480383b008388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000386f347221ULL, 0x002fe20000010000ULL,
0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003d7308ULL, 0x000e640000000800ULL,
0x0000003d1e1e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0001b9e27f007947ULL, 0x000fea000b800000ULL, 0x00001f7c3d347589ULL, 0x0002a400000e0000ULL,
0x000000341d1d7220ULL, 0x084fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x000000340c0c7220ULL, 0x080fe20000410000ULL,
0x0000003409097220ULL, 0x080fe20000410000ULL, 0x0000003408087220ULL, 0x080fe20000410000ULL,
0x0000003405057220ULL, 0x080fe20000410000ULL, 0x0000003404047220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0001b8f27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b3d347589ULL, 0x00046400000e0000ULL, 0x000000341b1b7220ULL, 0x082fe20000410000ULL,
0x000000341a1a7220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003413137220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x000000340f0f7220ULL, 0x080fe20000410000ULL,
0x000000340e0e7220ULL, 0x080fe20000410000ULL, 0x000000340b0b7220ULL, 0x080fe20000410000ULL,
0x000000340a0a7220ULL, 0x080fe20000410000ULL, 0x0000003407077220ULL, 0x080fe20000410000ULL,
0x0000003406067220ULL, 0x080fe20000410000ULL, 0x0000003431317220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x000000346d6d7220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fda0007806039ULL, 0x8000003836360221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600250308ULL, 0x000e640000000800ULL, 0x0000002537370220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001e371e7221ULL, 0x008fe20000010000ULL,
0x000000ffff6f7224ULL, 0x000fc400078e0038ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000000ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x0001b7327f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002e400000e0000ULL, 0x0001b7727f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0000a06000347802ULL, 0x000fc40000000f00ULL, 0x0001c30000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0000a0b000347802ULL, 0x000fc40000000f00ULL,
0x0001c2b000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000a80028347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002954783bULL, 0x000fe20000004200ULL, 0x0000a8002c387811ULL, 0x000fe200078e20ffULL,
0x000003b000017945ULL, 0x000fe20003800000ULL, 0x000000887c00720cULL, 0x000fe20003f46070ULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000887b00720cULL, 0x000fe20003f26070ULL, 0x000000002a5c783bULL, 0x000fe20000004200ULL,
0x0000007a7300720cULL, 0x000fc60003f03070ULL, 0x000000002b64783bULL, 0x000fe80000004200ULL,
0x000000002d3c783bULL, 0x004fe80000004200ULL, 0x000000003838783bULL, 0x000ea80000000200ULL,
0x000000002e40783bULL, 0x000f280000004200ULL, 0x000000002f44783bULL, 0x000ee80000004200ULL,
0x000000003048783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000273434b232ULL, 0x00afc40000000000ULL, 0x000000273636b232ULL, 0x000fe40000000000ULL,
0x000000263535b232ULL, 0x080fe40000000000ULL, 0x000000263737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000273838b232ULL, 0x084fe40000000000ULL,
0x000000273a3ab232ULL, 0x000fe40000000000ULL, 0x000000263939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000263b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040b6e00000018ffULL, 0x00000001883c7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000018ffULL, 0x0000003c7c00720cULL, 0x000fc40005746470ULL,
0x0000003c7b00720cULL, 0x000fc60004f26470ULL, 0x000000403850723cULL, 0x050b700000001850ULL,
0x000000423854723cULL, 0x040b700000001854ULL, 0x000000443858723cULL, 0x040b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x000000483860723cULL, 0x040b700000001860ULL,
0x0000004a3864723cULL, 0x040b700000001864ULL, 0x0000004c3868723cULL, 0x040b700000001868ULL,
0x0000004e3834723cULL, 0x020b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x000fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x020fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x000fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x020fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x00000002ff377819ULL, 0x000fe2000001163cULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000373c377207ULL, 0x040fe40002800000ULL, 0x000000033c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000000137377810ULL, 0x000fe40007ffe0ffULL, 0x0000007a7300720cULL, 0x000fe40003f03070ULL,
0x00000002ff397819ULL, 0x000fe40000011637ULL, 0x00000040ff407803ULL, 0x000fc40000000000ULL,
0x0000000337377812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x002fe200078e0035ULL,
0x000000ff3c357207ULL, 0x000fe20006800000ULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b8400ff367984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c4889ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fc80007fde1ffULL,
0x0000003b393b7210ULL, 0x000fe400037fe5ffULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c4889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff367984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000036ff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc8000001143bULL, 0x0000003d36367211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x0000000236367819ULL, 0x000fc8000000123bULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001343b7810ULL, 0x040fe20007ffe0ffULL,
0x0000121000017945ULL, 0x000fe20003800000ULL, 0x0000003734367211ULL, 0x000fe400078e10ffULL,
0x000000743b00720cULL, 0x000fc60003fc6070ULL, 0x00000040363f7824ULL, 0x000fca00078e00ffULL,
0x0000004070397812ULL, 0x000fca00078ef83fULL, 0x000009800000e947ULL, 0x000fea0003800000ULL,
0x0000000472417824ULL, 0x040fe200078e00ffULL, 0x0000020000437802ULL, 0x000fe20000000f00ULL,
0x0000000172387824ULL, 0x040fe200078e0239ULL, 0x0000000172427810ULL, 0x000fe40007ffe0ffULL,
0x014a000041367984ULL, 0x000e640000000800ULL, 0x00000004363e7824ULL, 0x002fca00078e00ffULL,
0x014ac0003e367984ULL, 0x000e640000000800ULL, 0x0000003621367224ULL, 0x002fe400078e0238ULL,
0x0000001003387824ULL, 0x000fe400078e00ffULL, 0x00005e00363a7625ULL, 0x000fe200078e0043ULL,
0x0000003f75367217ULL, 0x000fe40007800000ULL, 0x000001f038457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0239ULL,
0x000000ffff3d7224ULL, 0x000fe400030e063bULL, 0x00000001363b7824ULL, 0x000fe200078e0a3fULL,
0x00000005723f7819ULL, 0x040fe200000006ffULL, 0x0000000172367824ULL, 0x000fc600078e0203ULL,
0x0000003b723b7217ULL, 0x000fe40007800000ULL, 0xffffffe03f387812ULL, 0x000fc600078ee236ULL,
0x000000013b367824ULL, 0x000fe200078e0a72ULL, 0x0000c00038477811ULL, 0x000fc800078e20ffULL,
0x000000ff3600720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a040041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe40007fde0ffULL, 0x00000003423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000013600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000272427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a080041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe40007fde0ffULL, 0x00000003423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000023600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000372427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a0c0041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe40007fde0ffULL, 0x00000003423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000033600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000472427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a100041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe40007fde0ffULL, 0x00000003423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000043600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000572427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a140041387984ULL, 0x000ea20000000800ULL,
0x00000006723c7810ULL, 0x002fe20007ffe0ffULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe40007fde0ffULL,
0x00000003423a7210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0x000000053600780cULL, 0x000fe20003fc3070ULL, 0x00000020423b7824ULL, 0x000fe200078e00ffULL,
0x000000033c427210ULL, 0x000fc80007ffe0ffULL, 0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL,
0x0000c0003a3d7811ULL, 0x000fe200078e20ffULL, 0x000000013c3a7824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000f101c46ULL,
0x014a180041387984ULL, 0x000ea20000000800ULL, 0x000000203c3d7824ULL, 0x002fe200078e00ffULL,
0x00000007723e7810ULL, 0x000fc80007ffe0ffULL, 0xffffffe03d427812ULL, 0x000fe200078ee242ULL,
0x000000013e397824ULL, 0x040fe200078e0239ULL, 0x000000033e3f7210ULL, 0x040fe20007ffe0ffULL,
0x000000203e3e7824ULL, 0x000fe200078e00ffULL, 0x0000c000423d7811ULL, 0x000fc800078e20ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x0000c0003f3f7811ULL, 0x000fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e063bULL,
0x000000063600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x014a1c0041387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x0000004538387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203427211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe400078e00ffULL,
0x00000010033c7824ULL, 0x000fe200078e00ffULL, 0x0000000142447810ULL, 0x040fe20007ffe0ffULL,
0x014a000042367984ULL, 0x000e620000004800ULL, 0x0000000142387824ULL, 0x000fe400078e0239ULL,
0x000001f03c437812ULL, 0x000fe200078ec0ffULL, 0x014ac00036367984ULL, 0x002e640000004800ULL,
0x0000003621387224ULL, 0x002fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x0000000142387824ULL, 0x000fe200078e0203ULL, 0x000000433a3c7210ULL, 0x000fc80007fde0ffULL,
0x0000003bff3d7210ULL, 0x000fe200037fe4ffULL, 0x00000020423b7824ULL, 0x000fca00078e00ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x000fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a040042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fe200078e0041ULL, 0x0000000344387210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000242447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e063bULL,
0x00000005443b7819ULL, 0x000fe400000006ffULL, 0x0000000342447810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000442447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000003944387210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000542447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140042367984ULL, 0x000ea20000004800ULL,
0x00000006423c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621387224ULL, 0x002fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3f7210ULL, 0x000fe200037fe4ffULL,
0x00000020443b7824ULL, 0x000fca00078e00ffULL, 0xffffffe03b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x000fe200078e20ffULL, 0x000000013c387824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180042367984ULL, 0x000ea80000004800ULL, 0x014ac00036367984ULL, 0x004ea40000004800ULL,
0x0000003621387224ULL, 0x004fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fe200078e0041ULL,
0x000000033c387210ULL, 0x000fe40007ffe0ffULL, 0x00000007423c7810ULL, 0x000fe40007ffe0ffULL,
0x000000433a3a7210ULL, 0x000fe40007fde0ffULL, 0xffffffe045387812ULL, 0x000fe200078ee238ULL,
0x000000013c397824ULL, 0x040fe200078e0239ULL, 0x000000053c3f7819ULL, 0x002fe200000006ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e063bULL, 0x0000c000383d7811ULL, 0x000fe200078e20ffULL,
0x000000013c3e7824ULL, 0x000fc800078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e2000b901c46ULL, 0xffffffe03f3e7812ULL, 0x000fc600078ee23eULL,
0x014a1c0042367984ULL, 0x000ea20000004800ULL, 0x0000c0003e3b7811ULL, 0x002fc600078e20ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621397224ULL, 0x002fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fca00030e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff367984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe40003fc4070ULL, 0x00014a0023397811ULL, 0x000fe400078e10ffULL,
0x000000ff35367207ULL, 0x000fc40003000000ULL, 0x000000ff35387207ULL, 0x000fe40007000000ULL,
0x0000003637367210ULL, 0x000fe20007ffe0ffULL, 0x00000004ff377424ULL, 0x000fc600078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011636ULL, 0x0000004036367824ULL, 0x000fc800078e00ffULL,
0x0000030035357a24ULL, 0x000fe200078e0234ULL, 0x000000c036367812ULL, 0x000fe200078ec0ffULL,
0x0000000177347824ULL, 0x000fc800078e0238ULL, 0x0000010035357824ULL, 0x000fca00078e0236ULL,
0x0000002035357810ULL, 0x000fca0007ffe0ffULL, 0x0000000123367824ULL, 0x100fe400078e0235ULL,
0x0000680034347a24ULL, 0x000fc600078e0235ULL, 0x000000753600720cULL, 0x000fe40003fc6070ULL,
0x0000003423347210ULL, 0x000fca0007ffe0ffULL, 0x0000660034347625ULL, 0x000fcc00078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff347f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff897224ULL, 0x002fe200078e0035ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000000ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x000195127f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002a400000e0000ULL, 0x000195527f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0000c34000347802ULL, 0x000fc40000000f00ULL, 0x0001a02000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000036003a7202ULL, 0x004fe40000000f00ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0000c39000347802ULL, 0x000fc40000000f00ULL,
0x00019fd000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000a80086347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000a80081387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x00ae680000000200ULL, 0x00000000845c783bULL, 0x000fe80000004200ULL,
0x000000008364783bULL, 0x000fe80000004200ULL, 0x00000000823c783bULL, 0x000fe80000004200ULL,
0x000000003838783bULL, 0x004ea80000000200ULL, 0x000000008040783bULL, 0x000ee80000004200ULL,
0x000000007f44783bULL, 0x000f280000004200ULL, 0x000000007e48783bULL, 0x000ee80000004200ULL,
0x000000007d4c783bULL, 0x000ee20000004200ULL, 0x000000273434b232ULL, 0x002fc40000000000ULL,
0x000000273636b232ULL, 0x000fe40000000000ULL, 0x000000263535b232ULL, 0x080fe40000000000ULL,
0x000000263737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000273838b232ULL, 0x084fe40000000000ULL, 0x000000273a3ab232ULL, 0x000fe40000000000ULL,
0x000000263939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000263b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040f7000000018ffULL,
0x0000003e3434723cULL, 0x000f7000000018ffULL, 0x000000403850723cULL, 0x068b700000001850ULL,
0x000000423854723cULL, 0x040b700000001854ULL, 0x000000443858723cULL, 0x050b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x000000483860723cULL, 0x040b700000001860ULL,
0x0000004a3864723cULL, 0x040b700000001864ULL, 0x0000004c3868723cULL, 0x040b700000001868ULL,
0x0000004e3834723cULL, 0x000b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x020fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x000fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x020fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x000fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000188887810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000878800720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb0c000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000807a347811ULL, 0x000fe200078e40ffULL,
0x014b6000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000753400720cULL, 0x000fda0003f06070ULL,
0x00009f9000000947ULL, 0x000fea0003800000ULL, 0x000000ffff887224ULL, 0x000fca00078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011688ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000388367812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000003588357207ULL, 0x000fe40002800000ULL, 0x000000ff36367207ULL, 0x000fe40006800000ULL,
0x0000000235377810ULL, 0x000fc80007ffe0ffULL, 0x00000002ff397819ULL, 0x000fe40000011637ULL,
0x0000000337357812ULL, 0x000fc600078ec0ffULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fc800078110ffULL, 0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000134397810ULL, 0x040fe20007ffe0ffULL,
0x0000000434387824ULL, 0x000fe200078e0235ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743900720cULL, 0x000fe40003f06070ULL, 0x00000020383b7811ULL, 0x000fc800078e30ffULL,
0x0000006070397812ULL, 0x000fce00078ef83bULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x00000002723f7819ULL, 0x040fe200000006ffULL, 0x00000001723c7824ULL, 0x040fe400078e0239ULL,
0x00000200ff417424ULL, 0x000fe400078e00ffULL, 0x014a00003f387984ULL, 0x000e620000000800ULL,
0x0000000172407824ULL, 0x040fe400078e0203ULL, 0x0000002072457824ULL, 0x000fca00078e00ffULL,
0xffffffe045407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x000fe400078e20ffULL,
0x0000000172407810ULL, 0x000fca0007ffe0ffULL, 0x0000000140427824ULL, 0x040fe400078e0203ULL,
0x0000002040477824ULL, 0x000fca00078e00ffULL, 0xffffffe047427812ULL, 0x000fe200078ee242ULL,
0x00000004383d7824ULL, 0x002fe200078e00ffULL, 0x0000003b75387217ULL, 0x000fc80007800000ULL,
0x014ac0003d3a7984ULL, 0x000e620000000800ULL, 0x00000001383b7824ULL, 0x000fe200078e0a3bULL,
0x0000000403387819ULL, 0x000fc800000006ffULL, 0x0000003b723b7217ULL, 0x000fe40007800000ULL,
0x000001f038437812ULL, 0x000fc600078ec0ffULL, 0x000000013b3e7824ULL, 0x000fca00078e0a72ULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003a213a7224ULL, 0x002fc800078e023cULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000272407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fc60003f03070ULL, 0x014a04003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe400078ee242ULL, 0x0000000238387819ULL, 0x004fcc00000006ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000372407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fc60003f03070ULL, 0x014a08003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe400078ee242ULL, 0x0000000238387819ULL, 0x004fcc00000006ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000472407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000033e00780cULL, 0x000fc60003f03070ULL, 0x014a0c003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe400078ee242ULL, 0x0000000238387819ULL, 0x004fcc00000006ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000572407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fc60003f03070ULL, 0x014a10003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe400078ee242ULL, 0x0000000238387819ULL, 0x004fcc00000006ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000672407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fc60003f03070ULL, 0x014a14003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe400078ee242ULL, 0x0000000238387819ULL, 0x004fcc00000006ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000772407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000000140397824ULL, 0x000fc600078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x014a18003f387984ULL, 0x000ea20000000800ULL,
0x00010000423d7811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fe200078e0203ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x014a1c003f387984ULL, 0x000ea40000000800ULL,
0x00000002383c7819ULL, 0x004fca00000006ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fc800078e0041ULL,
0x0000002040417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007f3e0ffULL,
0xffffffe041427812ULL, 0x000fe200078ee242ULL, 0x000000ffff397224ULL, 0x000fc600008e0639ULL,
0x00010000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203407211ULL, 0x040fe200078fd8ffULL, 0x00000010033b7824ULL, 0x000fe400078e00ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x00000039403a7210ULL, 0x040fe20007ffe0ffULL,
0x014a000040387984ULL, 0x000e620000004800ULL, 0x000001f03b437812ULL, 0x000fe200078ec0ffULL,
0x00000001403d7824ULL, 0x040fe400078e0203ULL, 0x00000020403e7824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x002e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fe400078ee23dULL, 0x0000003bff3d7210ULL, 0x000fe400007fe4ffULL,
0x000100003a457811ULL, 0x000fe400078e20ffULL, 0x00000001403e7810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e4000b901c46ULL,
0x000000013e3a7824ULL, 0x040fe400078e0239ULL, 0x014a040040387984ULL, 0x000ea20000004800ULL,
0x000000013e3f7824ULL, 0x040fe400078e0203ULL, 0x000000203e427824ULL, 0x000fe200078e00ffULL,
0x00000002403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000393c3a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080040387984ULL, 0x000ea20000004800ULL,
0x00000003403e7810ULL, 0x002fc80007ffe0ffULL, 0x000000033e3f7210ULL, 0x000fe20007ffe0ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0040387984ULL, 0x000ea20000004800ULL,
0x00000004403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe400078ee23fULL, 0x000000053c427819ULL, 0x000fe200000006ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100040387984ULL, 0x000ea20000004800ULL,
0x00000005403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140040387984ULL, 0x000ea20000004800ULL,
0x00000006403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000013c427824ULL, 0x000fe200078e0203ULL,
0x0000003bff3f7210ULL, 0x000fe400007fe4ffULL, 0x000100003a3d7811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fe200078e0239ULL, 0xffffffe045427812ULL, 0x000fc600078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180040387984ULL, 0x000ea20000004800ULL, 0x00010000423d7811ULL, 0x002fe400078e20ffULL,
0x00000007403e7810ULL, 0x000fc80007ffe0ffULL, 0x000000393e397210ULL, 0x040fe20007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe400078e0203ULL, 0x000000203e3e7824ULL, 0x000fca00078e00ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x000100003f3f7811ULL, 0x000fe200078e20ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000b901c46ULL, 0x014a1c00403c7984ULL, 0x000ea80000004800ULL,
0x014ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c21397224ULL, 0x004fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ff003c7202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000300ff377624ULL, 0x000fe200078e00ffULL,
0x0000000171387812ULL, 0x000fc800078ec0ffULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fca0004000000ULL,
0x0000000171717824ULL, 0x000fe200078e0238ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000002300377211ULL, 0x000fe200078e10ffULL, 0x00000004ff397424ULL, 0x000fe200078e00ffULL,
0x0000640071387a10ULL, 0x040fe40007ffe0ffULL, 0x000000767100720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fc800078e00ffULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x00014ac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000347300720cULL, 0x000fe40003f04070ULL,
0x0000000136367810ULL, 0x000fc80007ffe0ffULL, 0x0000000336377812ULL, 0x002fce00078ec0ffULL,
0x00000002ff368819ULL, 0x000fca0000011636ULL, 0x0000000135357824ULL, 0x000fe200078e0236ULL,
0x000000ff37367207ULL, 0x000fe40004000000ULL, 0x00014a0023377811ULL, 0x000fe400078e10ffULL,
0x00000002ff397819ULL, 0x000fe20000011635ULL, 0x0000004035357824ULL, 0x000fc800078e00ffULL,
0x0000030039397a24ULL, 0x000fe200078e0234ULL, 0x000000c035347812ULL, 0x000fe200078ec0ffULL,
0x00000004ff357424ULL, 0x000fc600078e00ffULL, 0x0000003439397211ULL, 0x000fe200078e40ffULL,
0x0000000177347824ULL, 0x000fc800078e0236ULL, 0x0000000123367824ULL, 0x100fe400078e0239ULL,
0x0000680034347a24ULL, 0x000fc600078e0239ULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8000ff347f8cULL, 0x000e62000c80043fULL,
0x000000ff8800720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x0000003500897202ULL, 0x002fd60000000f00ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b180072347f8cULL, 0x000e64000c80043fULL,
0x000000ffff3b7224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x014b1c0072247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011437ULL,
0x0000003924247211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000224247819ULL, 0x000fc80000001237ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x014b1c0072247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000403247819ULL, 0x000fe400000006ffULL, 0x00000001ff347819ULL, 0x000fe40000011603ULL,
0x0000007024247812ULL, 0x000fe400078ec0ffULL, 0x0000000c34357812ULL, 0x000fca00078ec0ffULL,
0x00000001243b7824ULL, 0x000fca00078e0235ULL, 0x014100003b367984ULL, 0x000e680000000800ULL,
0x014300003b377984ULL, 0x0004e20000000800ULL, 0x0000006f3600720bULL, 0x002fe20003f1d000ULL,
0x00016dc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x004fc800000e0100ULL,
0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fd200078e006fULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000027800780cULL, 0x000fe40003f05270ULL,
0x0000006f3600720bULL, 0x000fe20003f34000ULL, 0x00016d827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000397806ULL, 0x000fc400008e0100ULL, 0x000000366f387209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991039347816ULL, 0x000fc600000000ffULL,
0x014500383b008388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000386f347221ULL, 0x002fe20000010000ULL,
0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003d7308ULL, 0x000e640000000800ULL,
0x0000003d1e1e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00016cd27f007947ULL, 0x000fea000b800000ULL, 0x00001f7c3d347589ULL, 0x0002a400000e0000ULL,
0x000000341d1d7220ULL, 0x084fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x000000340c0c7220ULL, 0x080fe20000410000ULL,
0x0000003409097220ULL, 0x080fe20000410000ULL, 0x0000003408087220ULL, 0x080fe20000410000ULL,
0x0000003405057220ULL, 0x080fe20000410000ULL, 0x0000003404047220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00016be27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b3d347589ULL, 0x00046400000e0000ULL, 0x000000341b1b7220ULL, 0x082fe20000410000ULL,
0x000000341a1a7220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003413137220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x000000340f0f7220ULL, 0x080fe20000410000ULL,
0x000000340e0e7220ULL, 0x080fe20000410000ULL, 0x000000340b0b7220ULL, 0x080fe20000410000ULL,
0x000000340a0a7220ULL, 0x080fe20000410000ULL, 0x0000003407077220ULL, 0x080fe20000410000ULL,
0x0000003406067220ULL, 0x080fe20000410000ULL, 0x0000003431317220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x000000346d6d7220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fda0007806039ULL, 0x8000003836360221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600250308ULL, 0x000e640000000800ULL, 0x0000002537370220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001e371e7221ULL, 0x008fe20000010000ULL,
0x000000ffff6f7224ULL, 0x000fc400078e0038ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000000ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x00016a227f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002e400000e0000ULL, 0x00016a627f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0000f04000347802ULL, 0x000fc40000000f00ULL, 0x0001732000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0000f09000347802ULL, 0x000fc40000000f00ULL,
0x000172d000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000b00028347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002954783bULL, 0x000fe20000004200ULL, 0x0000b0002c387811ULL, 0x000fe200078e20ffULL,
0x000003b000017945ULL, 0x000fe20003800000ULL, 0x000000887c00720cULL, 0x000fe20003f46070ULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000887b00720cULL, 0x000fe20003f26070ULL, 0x000000002a5c783bULL, 0x000fe20000004200ULL,
0x0000007a7300720cULL, 0x000fc60003f03070ULL, 0x000000002b64783bULL, 0x000fe80000004200ULL,
0x000000002d3c783bULL, 0x004fe80000004200ULL, 0x000000003838783bULL, 0x000ea80000000200ULL,
0x000000002e40783bULL, 0x000f280000004200ULL, 0x000000002f44783bULL, 0x000ee80000004200ULL,
0x000000003048783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000273434b232ULL, 0x00afc40000000000ULL, 0x000000273636b232ULL, 0x000fe40000000000ULL,
0x000000263535b232ULL, 0x080fe40000000000ULL, 0x000000263737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000273838b232ULL, 0x084fe40000000000ULL,
0x000000273a3ab232ULL, 0x000fe40000000000ULL, 0x000000263939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000263b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040b6e00000018ffULL, 0x00000001883c7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000018ffULL, 0x0000003c7c00720cULL, 0x000fc40005746470ULL,
0x0000003c7b00720cULL, 0x000fc60004f26470ULL, 0x000000403850723cULL, 0x050b700000001850ULL,
0x000000423854723cULL, 0x040b700000001854ULL, 0x000000443858723cULL, 0x040b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x000000483860723cULL, 0x040b700000001860ULL,
0x0000004a3864723cULL, 0x040b700000001864ULL, 0x0000004c3868723cULL, 0x040b700000001868ULL,
0x0000004e3834723cULL, 0x020b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x000fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x020fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x000fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x020fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x00000002ff377819ULL, 0x000fe2000001163cULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000373c377207ULL, 0x040fe40002800000ULL, 0x000000033c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000000237377810ULL, 0x000fe40007ffe0ffULL, 0x0000007a7300720cULL, 0x000fe40003f03070ULL,
0x00000002ff397819ULL, 0x000fe40000011637ULL, 0x00000040ff407803ULL, 0x000fc40000000000ULL,
0x0000000337377812ULL, 0x000fe400078ec0ffULL, 0x00000035003f7202ULL, 0x002fe20000000f00ULL,
0x0000030039347a24ULL, 0x000fe200078e027aULL, 0x000000ff3c357207ULL, 0x000fc40006800000ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b8400ff367984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c4889ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c4889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff367984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000036ff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fc80007fde1ffULL, 0x0000003b393b7210ULL, 0x000fe400037fe5ffULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc8000001143bULL, 0x0000003d36367211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x0000000236367819ULL, 0x000fc8000000123bULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001343b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000434367824ULL, 0x000fe200078e0237ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743b00720cULL, 0x000fe20003fc6070ULL, 0x00000040363f7824ULL, 0x000fca00078e00ffULL,
0x0000004070397812ULL, 0x000fce00078ef83fULL, 0x000009800000e947ULL, 0x000fea0003800000ULL,
0x0000000472417824ULL, 0x040fe200078e00ffULL, 0x0000000172427810ULL, 0x040fe20007ffe0ffULL,
0x0000000172387824ULL, 0x000fe400078e0239ULL, 0x00000200ff437424ULL, 0x000fe200078e00ffULL,
0x014a000041367984ULL, 0x000e640000000800ULL, 0x00000002363e7819ULL, 0x002fca00000006ffULL,
0x014ac0003e367984ULL, 0x000e640000000800ULL, 0x0000003621367224ULL, 0x002fe400078e0238ULL,
0x0000001003387824ULL, 0x000fe400078e00ffULL, 0x00005e00363a7625ULL, 0x000fe200078e0043ULL,
0x0000003f75367217ULL, 0x000fe40007800000ULL, 0x000001f038457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe40007fde0ffULL, 0x00000039423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000363f3b7210ULL, 0x000fe20007ffe1ffULL,
0x0000000172367824ULL, 0x040fe400078e0203ULL, 0x00000020723f7824ULL, 0x040fe200078e00ffULL,
0x0000003b723b7217ULL, 0x000fc80007800000ULL, 0xffffffe03f387812ULL, 0x000fe200078ee236ULL,
0x000000013b367824ULL, 0x000fc600078e0a72ULL, 0x0000c00038477811ULL, 0x000fe400078e20ffULL,
0x000000ff3600720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a040041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000013600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000272427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe400078e20ffULL,
0x00000039423a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a080041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000023600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000372427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe400078e20ffULL,
0x00000039423a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a0c0041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000033600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000472427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe400078e20ffULL,
0x00000039423a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a100041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000043600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000572427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe400078e20ffULL,
0x00000039423a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a140041387984ULL, 0x000ea20000000800ULL,
0x00000006723c7810ULL, 0x002fe20007ffe0ffULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001423a7824ULL, 0x000fc800078e0203ULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0x000000053600780cULL, 0x000fe20003fc3070ULL, 0x00000020423b7824ULL, 0x000fe400078e00ffULL,
0x000000013c427824ULL, 0x000fc600078e0203ULL, 0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL,
0x0000c0003a3d7811ULL, 0x000fe400078e20ffULL, 0x000000393c3a7210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000f101c46ULL,
0x014a180041387984ULL, 0x000ea20000000800ULL, 0x000000203c3d7824ULL, 0x002fe200078e00ffULL,
0x00000007723e7810ULL, 0x000fc80007ffe0ffULL, 0xffffffe03d427812ULL, 0x000fe200078ee242ULL,
0x000000013e3f7824ULL, 0x040fe200078e0203ULL, 0x000000393e397210ULL, 0x040fe20007ffe0ffULL,
0x000000203e3e7824ULL, 0x000fe200078e00ffULL, 0x0000c000423d7811ULL, 0x000fc800078e20ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x0000c0003f3f7811ULL, 0x000fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e063bULL,
0x000000063600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x014a1c0041387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x0000004538387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203427211ULL, 0x040fe200078fd8ffULL, 0x00000010033c7824ULL, 0x000fe200078e00ffULL,
0x0000020000417802ULL, 0x000fe40000000f00ULL, 0x0000000142447810ULL, 0x040fe20007ffe0ffULL,
0x014a000042367984ULL, 0x000e620000004800ULL, 0x0000000142387824ULL, 0x000fe200078e0239ULL,
0x000001f03c437812ULL, 0x000fe400078ec0ffULL, 0x014ac00036367984ULL, 0x002e640000004800ULL,
0x0000003621387224ULL, 0x002fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x0000000142387824ULL, 0x000fe200078e0203ULL, 0x000000433a3c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe400030e063bULL, 0x00000020423b7824ULL, 0x000fca00078e00ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x000fe400078e20ffULL,
0x0000003944387210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a040042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000242447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3d7210ULL, 0x000fe200037fe4ffULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000342447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fe200078e0041ULL, 0x0000000344387210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000442447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e063bULL,
0x00000005443b7819ULL, 0x000fe400000006ffULL, 0x0000000542447810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140042367984ULL, 0x000ea20000004800ULL,
0x00000006423c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621387224ULL, 0x002fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fca00078e00ffULL, 0xffffffe03b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x000fe400078e20ffULL, 0x000000393c387210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180042367984ULL, 0x000ea80000004800ULL, 0x014ac00036367984ULL, 0x004ea40000004800ULL,
0x0000003621387224ULL, 0x004fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x000000013c387824ULL, 0x000fe200078e0203ULL, 0x000000433a3a7210ULL, 0x000fe40007fde0ffULL,
0x00000007423c7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe045387812ULL, 0x000fe200078ee238ULL,
0x000000ffff3b7224ULL, 0x000fe400030e063bULL, 0x000000013c397824ULL, 0x000fe200078e0239ULL,
0x0000c000383d7811ULL, 0x002fe200078e20ffULL, 0x000000013c3e7824ULL, 0x000fc400078e0203ULL,
0x000000203c3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000b901c46ULL, 0xffffffe03f3e7812ULL, 0x000fe200078ee23eULL,
0x014a1c0042367984ULL, 0x000ea60000004800ULL, 0x0000c0003e3b7811ULL, 0x002fe200078e20ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621397224ULL, 0x002fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fc80007fde0ffULL,
0x00000039ff397210ULL, 0x000fca00037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e8000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff367984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fc80007fde1ffULL,
0x0000003b393b7210ULL, 0x000fe400037fe5ffULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe40003fc4070ULL, 0x00014a0023397811ULL, 0x000fe400078e10ffULL,
0x000000ff35367207ULL, 0x000fc40003000000ULL, 0x000000ff35387207ULL, 0x000fc60007000000ULL,
0x0000000137367824ULL, 0x000fe400078e0236ULL, 0x00000004ff377424ULL, 0x000fc600078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011636ULL, 0x0000004036367824ULL, 0x000fc800078e00ffULL,
0x0000030035357a24ULL, 0x000fe200078e0234ULL, 0x000000c036367812ULL, 0x000fe400078ec0ffULL,
0x0000003877347210ULL, 0x000fc60007ffe0ffULL, 0x0000010035357824ULL, 0x000fca00078e0236ULL,
0x0000002035357810ULL, 0x000fca0007ffe0ffULL, 0x0000000123367824ULL, 0x100fe400078e0235ULL,
0x0000680034347a24ULL, 0x000fc600078e0235ULL, 0x000000753600720cULL, 0x000fe20003fc6070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff347f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff897224ULL, 0x002fe200078e0035ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000000ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x000148027f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002a400000e0000ULL, 0x000148427f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0001132000347802ULL, 0x000fc40000000f00ULL, 0x0001504000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0001137000347802ULL, 0x000fc40000000f00ULL,
0x00014ff000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000b00086347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000b00081387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x00ae680000000200ULL, 0x00000000845c783bULL, 0x000fe80000004200ULL,
0x000000008364783bULL, 0x000fe80000004200ULL, 0x00000000823c783bULL, 0x000fe80000004200ULL,
0x000000003838783bULL, 0x004ea80000000200ULL, 0x000000008040783bULL, 0x000ee80000004200ULL,
0x000000007f44783bULL, 0x000f280000004200ULL, 0x000000007e48783bULL, 0x000ee80000004200ULL,
0x000000007d4c783bULL, 0x000ee20000004200ULL, 0x000000273434b232ULL, 0x002fc40000000000ULL,
0x000000273636b232ULL, 0x000fe40000000000ULL, 0x000000263535b232ULL, 0x080fe40000000000ULL,
0x000000263737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000273838b232ULL, 0x084fe40000000000ULL, 0x000000273a3ab232ULL, 0x000fe40000000000ULL,
0x000000263939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000263b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040f7000000018ffULL,
0x0000003e3434723cULL, 0x000f7000000018ffULL, 0x000000403850723cULL, 0x068b700000001850ULL,
0x000000423854723cULL, 0x040b700000001854ULL, 0x000000443858723cULL, 0x050b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x000000483860723cULL, 0x040b700000001860ULL,
0x0000004a3864723cULL, 0x040b700000001864ULL, 0x0000004c3868723cULL, 0x040b700000001868ULL,
0x0000004e3834723cULL, 0x000b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x020fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x000fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x020fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x000fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000188887810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000878800720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb0c000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c07a347811ULL, 0x000fe200078e40ffULL,
0x014b6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000753400720cULL, 0x000fda0003f06070ULL,
0x00004fb000000947ULL, 0x000fea0003800000ULL, 0x000000ffff887224ULL, 0x000fca00078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011688ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000388367812ULL, 0x040fe400078ec0ffULL, 0x0000003588357207ULL, 0x000fe40002800000ULL,
0x000000ff003e7202ULL, 0x000fe40000000f00ULL, 0x0000000335377810ULL, 0x000fe40007ffe0ffULL,
0x000000ff36367207ULL, 0x000fc40006800000ULL, 0x00000002ff397819ULL, 0x000fe40000011637ULL,
0x0000000337357812ULL, 0x000fc600078ec0ffULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fc800078110ffULL,
0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000134397810ULL, 0x040fe20007ffe0ffULL,
0x0000000434387824ULL, 0x000fe200078e0235ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743900720cULL, 0x000fe40003f06070ULL, 0x00000020383b7811ULL, 0x000fc800078e30ffULL,
0x0000006070397812ULL, 0x000fce00078ef83bULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x00000004723f7824ULL, 0x040fe200078e00ffULL, 0x0000000572457819ULL, 0x040fe200000006ffULL,
0x00000001723c7824ULL, 0x040fe400078e0239ULL, 0x00000200ff417424ULL, 0x000fe200078e00ffULL,
0x014a00003f387984ULL, 0x000e620000000800ULL, 0x0000000172407824ULL, 0x000fca00078e0203ULL,
0xffffffe045407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x000fe400078e20ffULL,
0x0000000172407810ULL, 0x000fc80007ffe0ffULL, 0x0000000540477819ULL, 0x040fe200000006ffULL,
0x0000000140427824ULL, 0x000fca00078e0203ULL, 0xffffffe047427812ULL, 0x000fe200078ee242ULL,
0x00000004383d7824ULL, 0x002fe200078e00ffULL, 0x0000003b75387217ULL, 0x000fc80007800000ULL,
0x014ac0003d3a7984ULL, 0x000e620000000800ULL, 0x000000383b3b7210ULL, 0x000fe20007ffe1ffULL,
0x0000001003387824ULL, 0x000fc600078e00ffULL, 0x0000003b723b7217ULL, 0x000fe40007800000ULL,
0x000001f038437812ULL, 0x000fc600078ec0ffULL, 0x000000013b3e7824ULL, 0x000fca00078e0a72ULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003a213a7224ULL, 0x002fc800078e023cULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000272407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e063bULL, 0x0000000540477819ULL, 0x000fc800000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fc60003f03070ULL, 0x014a04003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000372407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e063bULL, 0x0000000540477819ULL, 0x000fc800000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fc60003f03070ULL, 0x014a08003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000472407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e063bULL, 0x0000000540477819ULL, 0x000fc800000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000033e00780cULL, 0x000fc60003f03070ULL, 0x014a0c003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000572407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e063bULL, 0x0000000540477819ULL, 0x000fc800000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fc60003f03070ULL, 0x014a10003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000672407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e063bULL, 0x0000000540477819ULL, 0x000fc800000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fc60003f03070ULL, 0x014a14003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000772407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000000140397824ULL, 0x000fc600078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x014a18003f387984ULL, 0x000ea20000000800ULL,
0x00010000423d7811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fe400078e0203ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x014a1c003f387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x0000000540417819ULL, 0x000fc800000006ffULL, 0x0000004338387210ULL, 0x000fe40007f3e0ffULL,
0xffffffe041427812ULL, 0x000fc600078ee242ULL, 0x000000ffff397224ULL, 0x000fe200008e0639ULL,
0x00010000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203407211ULL, 0x040fe200078fd8ffULL, 0x00000010033b7824ULL, 0x000fe400078e00ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x00000003403d7210ULL, 0x040fe20007ffe0ffULL,
0x014a000040387984ULL, 0x000e620000004800ULL, 0x00000001403a7824ULL, 0x040fe200078e0239ULL,
0x000001f03b437812ULL, 0x000fe200078ec0ffULL, 0x00000020403e7824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x002e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fe400078ee23dULL, 0x00000001403e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000053e427819ULL, 0x040fe200000006ffULL, 0x000000013e3a7824ULL, 0x040fe400078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x000000013e3f7824ULL, 0x000fc600078e0203ULL, 0x014a040040387984ULL, 0x000ea20000004800ULL,
0x00000002403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080040387984ULL, 0x000ea20000004800ULL,
0x00000003403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fe400007fe4ffULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0040387984ULL, 0x000ea20000004800ULL,
0x00000004403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000393c3a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100040387984ULL, 0x000ea20000004800ULL,
0x00000005403e7810ULL, 0x002fc80007ffe0ffULL, 0x000000033e3f7210ULL, 0x000fe20007ffe0ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140040387984ULL, 0x000ea20000004800ULL,
0x00000006403c7810ULL, 0x002fc80007ffe0ffULL, 0x000000053c457819ULL, 0x000fe200000006ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000013c427824ULL, 0x000fe400078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a3d7811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fe200078e0239ULL, 0xffffffe045427812ULL, 0x000fc600078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180040387984ULL, 0x000ea20000004800ULL, 0x00010000423d7811ULL, 0x002fe400078e20ffULL,
0x00000007403e7810ULL, 0x000fca0007ffe0ffULL, 0x000000013e397824ULL, 0x040fe400078e0239ULL,
0x000000013e3f7824ULL, 0x040fe400078e0203ULL, 0x000000203e3e7824ULL, 0x000fca00078e00ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x000100003f3f7811ULL, 0x000fe200078e20ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000b901c46ULL, 0x014a1c00403c7984ULL, 0x000ea80000004800ULL,
0x014ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c21397224ULL, 0x004fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fc80007f1e0ffULL,
0x00000039ff397210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e8000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe40003f24070ULL, 0x0000000171387812ULL, 0x000fe400078ec0ffULL,
0x0000030000377a02ULL, 0x000fe40000000f00ULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fca0004000000ULL,
0x0000000171717824ULL, 0x000fe200078e0238ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400377824ULL, 0x000fe200078e0223ULL, 0x0000640071387a10ULL, 0x040fe20007ffe0ffULL,
0x00000004ff397424ULL, 0x000fe200078e00ffULL, 0x000000767100720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fc800078e00ffULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x00014ac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000347300720cULL, 0x000fe40003f04070ULL,
0x0000000136367810ULL, 0x000fc80007ffe0ffULL, 0x0000000336377812ULL, 0x002fce00078ec0ffULL,
0x00000002ff368819ULL, 0x000fc80000011636ULL, 0x0000003635357210ULL, 0x000fe40007ffe0ffULL,
0x000000ff37367207ULL, 0x000fe40004000000ULL, 0x00000002ff397819ULL, 0x000fe20000011635ULL,
0x0000004035357824ULL, 0x000fe200078e00ffULL, 0x00014a0023377811ULL, 0x000fc600078e10ffULL,
0x0000030039397a24ULL, 0x000fe200078e0234ULL, 0x000000c035347812ULL, 0x000fe400078ec0ffULL,
0x0000000400357802ULL, 0x000fc60000000f00ULL, 0x0000010039397824ULL, 0x000fe400078e0234ULL,
0x0000000177347824ULL, 0x000fe400078e0236ULL, 0x0000000123367824ULL, 0x100fe400078e0239ULL,
0x0000680034347a24ULL, 0x000fc600078e0239ULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8000ff347f8cULL, 0x000e62000c80043fULL,
0x000000ff8800720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff897224ULL, 0x002fd600078e0035ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b380072347f8cULL, 0x000e64000c80043fULL,
0x000000ffff3b7224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x014b3c0072247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fc80007f1e1ffULL,
0x0000003735377210ULL, 0x000fe400007fe5ffULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011437ULL,
0x0000003924247211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000224247819ULL, 0x000fc80000001237ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x014b3c0072247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003247824ULL, 0x000fe200078e00ffULL, 0x00000001ff347819ULL, 0x000fc80000011603ULL,
0x0000007024247812ULL, 0x000fe400078ec0ffULL, 0x0000000c34357812ULL, 0x000fca00078ec0ffULL,
0x00000001243b7824ULL, 0x000fca00078e0235ULL, 0x014180003b367984ULL, 0x000e680000000800ULL,
0x014380003b377984ULL, 0x0004e20000000800ULL, 0x0000006f3600720bULL, 0x002fe20003f1d000ULL,
0x000120b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x004fc800000e0100ULL,
0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x0000000100247802ULL, 0x000fe20000000f00ULL, 0x000000ffff387224ULL, 0x000fd400078e006fULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000037800780cULL, 0x000fe40003f05270ULL,
0x0000006f3600720bULL, 0x000fe20003f34000ULL, 0x000120727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000397806ULL, 0x000fc400008e0100ULL, 0x000000366f387209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991039347816ULL, 0x000fc600000000ffULL,
0x014580383b008388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000386f347221ULL, 0x002fe20000010000ULL,
0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003d7308ULL, 0x000e640000000800ULL,
0x0000003d1e1e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00011fc27f007947ULL, 0x000fea000b800000ULL, 0x00001f7c3d347589ULL, 0x0002a400000e0000ULL,
0x000000341d1d7220ULL, 0x084fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x000000340c0c7220ULL, 0x080fe20000410000ULL,
0x0000003409097220ULL, 0x080fe20000410000ULL, 0x0000003408087220ULL, 0x080fe20000410000ULL,
0x0000003405057220ULL, 0x080fe20000410000ULL, 0x0000003404047220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00011ed27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b3d347589ULL, 0x00046400000e0000ULL, 0x000000341b1b7220ULL, 0x082fe20000410000ULL,
0x000000341a1a7220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003413137220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x000000340f0f7220ULL, 0x080fe20000410000ULL,
0x000000340e0e7220ULL, 0x080fe20000410000ULL, 0x000000340b0b7220ULL, 0x080fe20000410000ULL,
0x000000340a0a7220ULL, 0x080fe20000410000ULL, 0x0000003407077220ULL, 0x080fe20000410000ULL,
0x0000003406067220ULL, 0x080fe20000410000ULL, 0x0000003431317220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x000000346d6d7220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fda0007806039ULL, 0x8000003836360221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600250308ULL, 0x000e640000000800ULL, 0x0000002537370220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001e371e7221ULL, 0x008fe20000010000ULL,
0x000000ffff6f7224ULL, 0x000fc400078e0038ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000000ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x00011d127f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002e400000e0000ULL, 0x00011d527f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe40007ffe0ffULL, 0x00000036003a7202ULL, 0x000fe40000000f00ULL,
0x0001402000347802ULL, 0x000fc40000000f00ULL, 0x0001234000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0001407000347802ULL, 0x000fc40000000f00ULL,
0x000122f000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000b80028347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002954783bULL, 0x000fe20000004200ULL, 0x0000b8002c387811ULL, 0x000fe200078e20ffULL,
0x000003b000017945ULL, 0x000fe20003800000ULL, 0x000000887c00720cULL, 0x000fe20003f46070ULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000887b00720cULL, 0x000fe20003f26070ULL, 0x000000002a5c783bULL, 0x000fe20000004200ULL,
0x0000007a7300720cULL, 0x000fc60003f03070ULL, 0x000000002b64783bULL, 0x000fe80000004200ULL,
0x000000002d3c783bULL, 0x004fe80000004200ULL, 0x000000003838783bULL, 0x000ea80000000200ULL,
0x000000002e40783bULL, 0x000f280000004200ULL, 0x000000002f44783bULL, 0x000ee80000004200ULL,
0x000000003048783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000273434b232ULL, 0x00afc40000000000ULL, 0x000000273636b232ULL, 0x000fe40000000000ULL,
0x000000263535b232ULL, 0x080fe40000000000ULL, 0x000000263737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000273838b232ULL, 0x084fe40000000000ULL,
0x000000273a3ab232ULL, 0x000fe40000000000ULL, 0x000000263939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000263b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040b6e00000018ffULL, 0x00000001883c7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000018ffULL, 0x0000003c7c00720cULL, 0x000fc40005746470ULL,
0x0000003c7b00720cULL, 0x000fc60004f26470ULL, 0x000000403850723cULL, 0x050b700000001850ULL,
0x000000423854723cULL, 0x040b700000001854ULL, 0x000000443858723cULL, 0x040b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x000000483860723cULL, 0x040b700000001860ULL,
0x0000004a3864723cULL, 0x040b700000001864ULL, 0x0000004c3868723cULL, 0x040b700000001868ULL,
0x0000004e3834723cULL, 0x020b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x000fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x020fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x000fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x020fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x00000002ff377819ULL, 0x000fe2000001163cULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000373c377207ULL, 0x040fe40002800000ULL, 0x000000033c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000000337377810ULL, 0x000fe40007ffe0ffULL, 0x0000007a7300720cULL, 0x000fe40003f03070ULL,
0x00000002ff397819ULL, 0x000fe40000011637ULL, 0x00000040ff407803ULL, 0x000fc40000000000ULL,
0x0000000337377812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x002fe200078e0035ULL,
0x000000ff3c357207ULL, 0x000fe20006800000ULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b8400ff367984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c4889ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fc800078d10ffULL, 0x0000003bff3b7210ULL, 0x000fc800037fe4ffULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c4889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff367984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000036ff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc8000001143bULL, 0x0000003d36367211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x0000000236367819ULL, 0x000fc8000000123bULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001343b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000434367824ULL, 0x000fe200078e0237ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743b00720cULL, 0x000fe40003fc6070ULL, 0x00000006363f7819ULL, 0x000fc800000006ffULL,
0x0000004070397812ULL, 0x000fce00078ef83fULL, 0x000009800000e947ULL, 0x000fea0003800000ULL,
0x0000000472417824ULL, 0x040fe200078e00ffULL, 0x0000000172427810ULL, 0x040fe20007ffe0ffULL,
0x0000000172387824ULL, 0x000fe400078e0239ULL, 0x00000200ff437424ULL, 0x000fe200078e00ffULL,
0x014a000041367984ULL, 0x000e640000000800ULL, 0x00000004363e7824ULL, 0x002fca00078e00ffULL,
0x014ac0003e367984ULL, 0x000e640000000800ULL, 0x0000003621367224ULL, 0x002fe200078e0238ULL,
0x0000000403387819ULL, 0x000fc600000006ffULL, 0x00005e00363a7625ULL, 0x000fe200078e0043ULL,
0x000001f038457812ULL, 0x000fe400078ec0ffULL, 0x0000003f75367217ULL, 0x000fe40007800000ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0239ULL,
0x000000ffff3d7224ULL, 0x000fe400030e063bULL, 0x00000001363b7824ULL, 0x000fe400078e0a3fULL,
0x0000000172367824ULL, 0x040fe400078e0203ULL, 0x00000020723f7824ULL, 0x040fe200078e00ffULL,
0x0000003b723b7217ULL, 0x000fc80007800000ULL, 0xffffffe03f387812ULL, 0x000fe400078ee236ULL,
0x0000003b72367210ULL, 0x000fe40007ffe1ffULL, 0x0000c00038477811ULL, 0x000fe400078e20ffULL,
0x000000ff3600720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a040041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x00000005423b7819ULL, 0x000fe400000006ffULL,
0x000000013600780cULL, 0x000fe40003fc3070ULL, 0xffffffe03b3a7812ULL, 0x000fe400078ee23aULL,
0x0000000272427810ULL, 0x000fe40007ffe0ffULL, 0x0000c0003a477811ULL, 0x002fc600078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a080041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x00000005423b7819ULL, 0x000fe400000006ffULL,
0x000000023600780cULL, 0x000fe40003fc3070ULL, 0xffffffe03b3a7812ULL, 0x000fe400078ee23aULL,
0x0000000372427810ULL, 0x000fe40007ffe0ffULL, 0x0000c0003a477811ULL, 0x002fc600078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a0c0041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x00000005423b7819ULL, 0x000fe400000006ffULL,
0x000000033600780cULL, 0x000fe40003fc3070ULL, 0xffffffe03b3a7812ULL, 0x000fe400078ee23aULL,
0x0000000472427810ULL, 0x000fe40007ffe0ffULL, 0x0000c0003a477811ULL, 0x002fc600078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a100041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x00000005423b7819ULL, 0x000fe400000006ffULL,
0x000000043600780cULL, 0x000fe40003fc3070ULL, 0xffffffe03b3a7812ULL, 0x000fe400078ee23aULL,
0x0000000572427810ULL, 0x000fe40007ffe0ffULL, 0x0000c0003a477811ULL, 0x002fc600078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a140041387984ULL, 0x000ea20000000800ULL,
0x00000006723c7810ULL, 0x002fe20007ffe0ffULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001423a7824ULL, 0x000fc800078e0203ULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0x00000005423b7819ULL, 0x000fe200000006ffULL, 0x000000013c427824ULL, 0x000fe200078e0203ULL,
0x000000053600780cULL, 0x000fe40003fc3070ULL, 0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL,
0x0000c0003a3d7811ULL, 0x000fe200078e20ffULL, 0x000000013c3a7824ULL, 0x000fcc00078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000f101c46ULL,
0x014a180041387984ULL, 0x000ea20000000800ULL, 0x000000053c3d7819ULL, 0x002fe400000006ffULL,
0x00000007723e7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe03d427812ULL, 0x000fc600078ee242ULL,
0x000000013e397824ULL, 0x000fe200078e0239ULL, 0x0000c000423d7811ULL, 0x000fe200078e20ffULL,
0x000000013e3f7824ULL, 0x040fe200078e0203ULL, 0x000000053e3e7819ULL, 0x000fc800000006ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x0000c0003f3f7811ULL, 0x000fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e063bULL,
0x000000063600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x014a1c0041387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x0000004538387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203427211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe400078e00ffULL,
0x00000010033c7824ULL, 0x000fe200078e00ffULL, 0x0000000142447810ULL, 0x040fe20007ffe0ffULL,
0x014a000042367984ULL, 0x000e620000004800ULL, 0x0000000142387824ULL, 0x000fe400078e0239ULL,
0x000001f03c437812ULL, 0x000fe200078ec0ffULL, 0x014ac00036367984ULL, 0x002e640000004800ULL,
0x0000003621387224ULL, 0x002fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fe200078e0041ULL,
0x0000000342387210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe400030e063bULL, 0x00000020423b7824ULL, 0x000fca00078e00ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x000fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a040042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0x00000005443b7819ULL, 0x000fe400000006ffULL, 0x0000000242447810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000342447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000003944387210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000442447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3d7210ULL, 0x000fe200037fe4ffULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000542447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140042367984ULL, 0x000ea20000004800ULL,
0x00000006423c7810ULL, 0x002fc80007ffe0ffULL, 0x000000053c457819ULL, 0x000fe200000006ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621387224ULL, 0x002fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fe200078e0041ULL, 0x0000000344387210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fca00078e00ffULL, 0xffffffe03b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x000fe200078e20ffULL, 0x000000013c387824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180042367984ULL, 0x000ea80000004800ULL, 0x014ac00036367984ULL, 0x004ea40000004800ULL,
0x0000003621387224ULL, 0x004fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x000000013c387824ULL, 0x000fe200078e0203ULL, 0x000000433a3a7210ULL, 0x000fe40007fde0ffULL,
0x00000007423c7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe045387812ULL, 0x000fe200078ee238ULL,
0x000000ffff3b7224ULL, 0x000fe400030e063bULL, 0x000000013c397824ULL, 0x000fe200078e0239ULL,
0x0000c000383d7811ULL, 0x002fe200078e20ffULL, 0x000000013c3e7824ULL, 0x000fc400078e0203ULL,
0x000000203c3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000b901c46ULL, 0xffffffe03f3e7812ULL, 0x000fe200078ee23eULL,
0x014a1c0042367984ULL, 0x000ea60000004800ULL, 0x0000c0003e3b7811ULL, 0x002fe200078e20ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621397224ULL, 0x002fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fca00030e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x00000039003f7202ULL, 0x002fc40000000f00ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff367984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe40003fc4070ULL, 0x00014a0023397811ULL, 0x000fe400078e10ffULL,
0x000000ff35367207ULL, 0x000fc40003000000ULL, 0x000000ff35387207ULL, 0x000fc60007000000ULL,
0x0000000137367824ULL, 0x000fe400078e0236ULL, 0x00000004ff377424ULL, 0x000fc600078e00ffULL,
0x00000002ff357819ULL, 0x000fe40000011636ULL, 0x0000000636367819ULL, 0x000fc600000006ffULL,
0x0000030035357a24ULL, 0x000fe200078e0234ULL, 0x000000c036367812ULL, 0x000fe200078ec0ffULL,
0x0000000177347824ULL, 0x000fc800078e0238ULL, 0x0000010035357824ULL, 0x000fca00078e0236ULL,
0x0000002035357810ULL, 0x000fc80007ffe0ffULL, 0x0000003523367210ULL, 0x000fe20007ffe0ffULL,
0x0000680034347a24ULL, 0x000fc600078e0235ULL, 0x000000753600720cULL, 0x000fe20003fc6070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff347f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff897224ULL, 0x002fe200078e0035ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000000ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x0000faf27f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002a400000e0000ULL, 0x0000fb327f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0001630000347802ULL, 0x000fc40000000f00ULL, 0x0001006000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0001635000347802ULL, 0x000fc40000000f00ULL,
0x0001001000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000b80086347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000b80081387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x00ae680000000200ULL, 0x00000000845c783bULL, 0x000fe80000004200ULL,
0x000000008364783bULL, 0x000fe80000004200ULL, 0x00000000823c783bULL, 0x000fe80000004200ULL,
0x000000003838783bULL, 0x004ea80000000200ULL, 0x000000008040783bULL, 0x000ee80000004200ULL,
0x000000007f44783bULL, 0x000f280000004200ULL, 0x000000007e48783bULL, 0x000ee80000004200ULL,
0x000000007d4c783bULL, 0x000ee20000004200ULL, 0x000000273434b232ULL, 0x002fc40000000000ULL,
0x000000273636b232ULL, 0x000fe40000000000ULL, 0x000000263535b232ULL, 0x080fe40000000000ULL,
0x000000263737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000273838b232ULL, 0x084fe40000000000ULL, 0x000000273a3ab232ULL, 0x000fe40000000000ULL,
0x000000263939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000263b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040f7000000018ffULL,
0x0000003e3434723cULL, 0x000f7000000018ffULL, 0x000000403850723cULL, 0x068b700000001850ULL,
0x000000423854723cULL, 0x040b700000001854ULL, 0x000000443858723cULL, 0x050b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x000000483860723cULL, 0x040b700000001860ULL,
0x0000004a3864723cULL, 0x040b700000001864ULL, 0x0000004c3868723cULL, 0x040b700000001868ULL,
0x0000004e3834723cULL, 0x000b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x020fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x000fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x020fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x000fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000188887810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000878800720cULL, 0x000fc40003f06070ULL, 0x00000035003c7202ULL, 0x002fd60000000f00ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb0c000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7000ffff7f8cULL, 0x000fe4000c80043fULL,
0x000003007a7a7a10ULL, 0x000fc80007ffe0ffULL, 0x000000747a00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffebaf000007947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000002a7919ULL, 0x000e620000002500ULL,
0x000000ffff297224ULL, 0x000fe200078e0005ULL, 0x0000000800257202ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x000fe200078e0004ULL, 0x0000000f00227202ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fe400078e0006ULL, 0x000000ffff267224ULL, 0x000fe400078e0007ULL,
0x000000ffff237224ULL, 0x000fe400078e0009ULL, 0x000000ffff217224ULL, 0x000fc400078e000aULL,
0x000000ffff247224ULL, 0x000fe400078e000bULL, 0x000000ffff057224ULL, 0x000fe200078e000eULL,
0x000000742a00720cULL, 0x002fda0003f06070ULL, 0x0000036000000947ULL, 0x000fea0003800000ULL,
0x018000001e037810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e001eULL,
0x00016ae000067802ULL, 0x000fc40000000f00ULL, 0x0000f6d000007944ULL, 0x008fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001e00037308ULL, 0x000e640000001000ULL,
0xbf80000003047423ULL, 0x002fc8000000001eULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000f240000000000ULL, 0x00000002ff3b7819ULL, 0x010fe20000011604ULL,
0x0000f2c27f007947ULL, 0x000fea000b800000ULL, 0x00001f3b03047589ULL, 0x00c4e400000e0000ULL,
0x0000000000067919ULL, 0x000f220000000000ULL, 0x0000001d041d7220ULL, 0x048fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000c040c7220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000006c046c7220ULL, 0x000fe20000410000ULL, 0x00000008063b7811ULL, 0x016fe200078ff0ffULL,
0x0000f1d27f007947ULL, 0x000fea000b800000ULL, 0x00001f3b03037589ULL, 0x0002a400000e0000ULL,
0x0000001b031b7220ULL, 0x044fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000000503057220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000002103217220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000006d036d7220ULL, 0x040fe20000410000ULL, 0x0000006e036e7220ULL, 0x000fc20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000151407723eULL, 0x000fc400000000ffULL,
0x000000111008723eULL, 0x000fe400000000ffULL, 0x0000000d0c09723eULL, 0x000fe400000000ffULL,
0x00000013120f723eULL, 0x000fe400000000ffULL, 0x0000001d1c03723eULL, 0x000fe400000000ffULL,
0x000000191806723eULL, 0x000fe400000000ffULL, 0x00000023250a723eULL, 0x000fc400000000ffULL,
0x00000029280b723eULL, 0x000fe400000000ffULL, 0x000000336c0c723eULL, 0x000fe400000000ffULL,
0x0000001b1a0d723eULL, 0x000fe400000000ffULL, 0x00000017160e723eULL, 0x000fe400000000ffULL,
0x000000220510723eULL, 0x000fe400000000ffULL, 0x000000242111723eULL, 0x000fc400000000ffULL,
0x000000262712723eULL, 0x000fe400000000ffULL, 0x000000313213723eULL, 0x000fe400000000ffULL,
0x0000006d6e14723eULL, 0x000fc400000000ffULL, 0x0000000000197919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff1b7819ULL, 0x004fc40000011619ULL,
0x0000000819287811ULL, 0x000fe400078ff0ffULL, 0x000000011b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b157824ULL, 0x040fe200078e00ffULL, 0x000000021b057810ULL, 0x040fe20007ffe0ffULL,
0x000000081b1a7824ULL, 0x040fe200078e00ffULL, 0x000000061b167810ULL, 0x040fe20007ffe0ffULL,
0x000000081b177824ULL, 0x000fe200078e00ffULL, 0xfffffff815187812ULL, 0x000fe200078ee204ULL,
0x000000081b1d7824ULL, 0x040fe200078e00ffULL, 0x000000031b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b207824ULL, 0x042fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL,
0x000000081b267824ULL, 0x040fe200078e00ffULL, 0x000000051b157810ULL, 0x000fc40007ffe0ffULL,
0x000000031b227819ULL, 0x000fe400000006ffULL, 0xfffffff8171c7812ULL, 0x000fe200078ee204ULL,
0x0000080078047824ULL, 0x000fe200078e00ffULL, 0xfffffff81d247812ULL, 0x000fe200078ee216ULL,
0x000000081b167824ULL, 0x040fe200078e00ffULL, 0x000000041b057810ULL, 0x000fe40007ffe0ffULL,
0xfffffff822227812ULL, 0x000fe200078ee215ULL, 0x0000000419157824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fc400078ee205ULL, 0xfffffff816167812ULL, 0x000fe400078ee21bULL,
0x0000a00004057810ULL, 0x000fe40007ffe0ffULL, 0xffffffff1b177810ULL, 0x000fe40007ffe0ffULL,
0x00000003281b7819ULL, 0x000fe200000006ffULL, 0x0000001016167824ULL, 0x100fe200078e0205ULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x0000001018187824ULL, 0x000fe200078e0205ULL,
0xfffffff826267812ULL, 0x000fe200078ee217ULL, 0x000000101a1a7824ULL, 0x100fe200078e0205ULL,
0x000000051c1c7211ULL, 0x000fe200078e20ffULL, 0x0000001020207824ULL, 0x000fe200078e0205ULL,
0xfffffff81b287812ULL, 0x000fe200078ee228ULL, 0x0000000116167824ULL, 0x000fc400078e0215ULL,
0x0000001022227824ULL, 0x100fe200078e0205ULL, 0x0000000528287211ULL, 0x000fe200078e20ffULL,
0x0000000115177824ULL, 0x040fe200078e0218ULL, 0x0000002015207210ULL, 0x040fe20007ffe0ffULL,
0x0000001024247824ULL, 0x100fe200078e0205ULL, 0x0000000316007388ULL, 0x0003e20000000800ULL,
0x00000001151a7824ULL, 0x040fe400078e021aULL, 0x0000001026267824ULL, 0x000fe200078e0205ULL,
0x0000000617007388ULL, 0x0003e20000000800ULL, 0x0000000115197824ULL, 0x000fc400078e021cULL,
0x00000001151b7824ULL, 0x040fe200078e0222ULL, 0x000000071a007388ULL, 0x0003e20000000800ULL,
0x0000000115247824ULL, 0x040fe400078e0224ULL, 0x00000001151d7824ULL, 0x040fe200078e0226ULL,
0x0000000819007388ULL, 0x0003e20000000800ULL, 0x0000000115287824ULL, 0x000fc600078e0228ULL,
0x0000000920007388ULL, 0x0003e80000000800ULL, 0x0000000a1b007388ULL, 0x0003e80000000800ULL,
0x0000000b24007388ULL, 0x0003e80000000800ULL, 0x0000000c1d007388ULL, 0x0003e80000000800ULL,
0x0000000d28007388ULL, 0x0003e80000000800ULL, 0x0004000e17007388ULL, 0x0003e80000000800ULL,
0x0004000f1a007388ULL, 0x0003e80000000800ULL, 0x0004001019007388ULL, 0x0003e80000000800ULL,
0x0004001120007388ULL, 0x0003e80000000800ULL, 0x000400121b007388ULL, 0x0003e80000000800ULL,
0x0004001324007388ULL, 0x0003e80000000800ULL, 0x000400141d007388ULL, 0x0003e20000000800ULL,
0x0000002000007947ULL, 0x000fea0003800000ULL, 0x0001733000287802ULL, 0x002fc40000000f00ULL,
0x0000f0d000007944ULL, 0x008fea0003c00000ULL, 0x0000030000187a02ULL, 0x000fe20000000f00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000011800780cULL, 0x000fda0003f05270ULL,
0x0000266000008947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x00005800ff027624ULL, 0x000fc600078e00ffULL, 0x00000000000b7919ULL, 0x000ea20000002600ULL,
0x00006c0002027a24ULL, 0x000fc800078e02ffULL, 0x0000030002097a24ULL, 0x040fe200078e02ffULL,
0x0000000f02037811ULL, 0x000fc800078e10ffULL, 0xfffffff0030c7812ULL, 0x000fca00078ec0ffULL,
0x00000080090e7824ULL, 0x000fc800078e020cULL, 0x0000008009097824ULL, 0x000fe400078e020eULL,
0x00000010070a7824ULL, 0x002fe400078e0204ULL, 0x0000580000067a24ULL, 0x004fe200078e020bULL,
0x0000007f09097810ULL, 0x000fe40007ffe0ffULL, 0x00a000000a107984ULL, 0x0002a20000000c00ULL,
0x00000300060f7a24ULL, 0x000fe200078e02ffULL, 0xffffff80090d7812ULL, 0x000fc800078ec0ffULL,
0x0000002a0f087210ULL, 0x000fe40007ffe0ffULL, 0x000070000d037a10ULL, 0x000fc80007f1e0ffULL,
0x0000000308027211ULL, 0x000fe200078258ffULL, 0x00007100ff037624ULL, 0x000fe200000e06ffULL,
0x000070000c147a10ULL, 0x000fc80007f1e0ffULL, 0x0000000308037211ULL, 0x000fe200008f5cffULL,
0x00007100ff167624ULL, 0x000fe200000e06ffULL, 0x000000ff7800720cULL, 0x000fc60003f25270ULL,
0x0000020078027825ULL, 0x000fcc00078e0002ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000011000001947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x002e620000000000ULL,
0x0000008008097824ULL, 0x000fe400078e00ffULL, 0x000000100a0b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff177819ULL, 0x000fe4000001160aULL, 0x00007000090a7a10ULL, 0x000fe40007b5e00eULL,
0x000000700b157812ULL, 0x000fe400078ec0ffULL, 0x00000019ff0b7819ULL, 0x000fc40000011608ULL,
0x0000000c17087812ULL, 0x000fe400078ec0ffULL, 0x0000001415097210ULL, 0x000fe4000791e009ULL,
0x000071000b177a10ULL, 0x000fe400017e64ffULL, 0x0000000a080a7210ULL, 0x040fe40007c7e015ULL,
0x0000000908087210ULL, 0x000fe40007f5e0ffULL, 0x00000016ff097210ULL, 0x000fc400007e240bULL,
0x00000017ff0b7210ULL, 0x000fe40001fe84ffULL, 0x00000009ff097210ULL, 0x000fca00017fe4ffULL,
0x0000006f08007986ULL, 0x0003e8000c101906ULL, 0x0000001e0a007986ULL, 0x0003e4000c101906ULL,
0x000000ff0700720cULL, 0x002fe20003f05270ULL, 0x0000001002007986ULL, 0x004fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff7800720cULL, 0x000fda0000705670ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0xffffffff18097810ULL, 0x000fc60007ffe0ffULL,
0x0000700006027625ULL, 0x000fe200078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009020279a8ULL, 0x000ea400099ee1c6ULL, 0x000000090200720cULL, 0x004fc80003f05270ULL,
0x00000001ff067807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000006ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x000ea40000000000ULL,
0x000000ff0200720cULL, 0x004fda0003f05270ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x000000ff7800720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001007037824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x002fe40000011607ULL,
0x000000140f027211ULL, 0x000fe400078038ffULL, 0x0000007003097812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fe400078ec0ffULL, 0x000000160f037211ULL, 0x000fe400000f3cffULL,
0x0000000206027210ULL, 0x000fc8000791e009ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602087981ULL, 0x000328000c1e1900ULL, 0x0000800602097981ULL, 0x000322000c1e1900ULL,
0x000000021800780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006020b7981ULL, 0x002322000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800602117981ULL, 0x002322000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000602137981ULL, 0x002322000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800602157981ULL, 0x002322000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081800780cULL, 0x002fe20003f06070ULL, 0x0003000602177981ULL, 0x000318000c1e1900ULL,
0x0003800602190981ULL, 0x000324000c1e1900ULL, 0x0000000718027810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff067819ULL, 0x000fc80000011602ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000c0f1d7211ULL, 0x000fe200078038ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1b7224ULL, 0x010fe200078e0008ULL, 0x000070001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0f0a7211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0a7a10ULL, 0x000fc400017e240aULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000406007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000810027810ULL, 0x040fe40007ffe0ffULL,
0x0000000110037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000407027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffc8006021b7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000910027810ULL, 0x042fe40007ffe0ffULL,
0x0000000210037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000908087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffd000602097981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000310037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fc80007f3e0ffULL,
0x0000000aff037210ULL, 0x000fca0000ffe4ffULL, 0xfffd8006020b7981ULL, 0x000328000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000410037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001108087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffe000602117981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000510037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffe800602137981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000610037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001508087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000407027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xffff000602157981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000710037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001708087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xffff800602177981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f10027810ULL, 0x002fe40007ffe0ffULL,
0x0000001908087209ULL, 0x000fe40007810000ULL, 0x0000030002007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fc80007f3e0ffULL,
0x0000000aff037210ULL, 0x000fca0000ffe4ffULL, 0x0000000602197981ULL, 0x000328000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e060aULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x000ea40000000000ULL, 0x0000001007027824ULL, 0x006fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000102037824ULL, 0x000fca00078e0203ULL,
0x0000000803007388ULL, 0x0103e40000000800ULL, 0x000070000d027a10ULL, 0x000fe20007f1e0ffULL,
0x0000020078417824ULL, 0x000fe200078e00ffULL, 0x00000017ff437819ULL, 0x000fe20000011678ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00007100ff037624ULL, 0x002fe200000e06ffULL,
0x000000070700780cULL, 0x040fe20003f04070ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000407067819ULL, 0x000fe200000006ffULL, 0x000008000f087825ULL, 0x000fe200078e0002ULL,
0x00000001ff0a7819ULL, 0x000fe20000011607ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000070000c447a10ULL, 0x000fe20007f5e0ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000004108087210ULL, 0x000fe20007f3e0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x00007100ff467624ULL, 0x000fe200010e06ffULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe200008e0643ULL,
0x000070000e407a10ULL, 0x000fe20007f3e0ffULL, 0x00001000780e7824ULL, 0x000fe200078e00ffULL,
0x000000440f0c8211ULL, 0x040fe200078438ffULL, 0x0000000106067824ULL, 0x000fe200078e020bULL,
0x00007100ff427a10ULL, 0x000fe20000ffe4ffULL, 0x0000001078138824ULL, 0x140fe200078e0207ULL,
0x000000400f0a8211ULL, 0x040fe200078238ffULL, 0x0000001078158824ULL, 0x000fe200078e0207ULL,
0x000000460f0d8211ULL, 0x000fe200010f3cffULL, 0x0000001007117824ULL, 0x000fe200078e020eULL,
0x000000420f0b8211ULL, 0x000fe200008f3cffULL, 0x0000001007087825ULL, 0x000fe200078e0008ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x0000000006067984ULL, 0x000e620000000800ULL,
0x0000458013138811ULL, 0x000fe200078e20ffULL, 0x00000010070a8825ULL, 0x000fe200078e000aULL,
0x0000418015158811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008117faeULL, 0x0005e2000b901c46ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000010070c8825ULL, 0x000fe200078e000cULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000000a138faeULL, 0x0009e2000b901c46ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000000c158faeULL, 0x0007e2000b901c46ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000ff00307202ULL, 0x000fe20000000f00ULL,
0x0000000000127805ULL, 0x010fe2000001ff00ULL, 0x0000000000147805ULL, 0x008fe2000001ff00ULL,
0x00000bb000009947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fc400078e00ffULL, 0x00000001ff457424ULL, 0x000fca00078e00ffULL,
0x0000030045007a0cULL, 0x000fda0003f06070ULL, 0x000001c000000947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f44070ULL, 0x000008000f087825ULL, 0x000fe200078e0002ULL,
0x00000001450d7812ULL, 0x000fc600078ec0ffULL, 0x00000800450a7824ULL, 0x000fe200078e00ffULL,
0x0000004108087210ULL, 0x000fc80007f1e0ffULL, 0x000008000a0b7812ULL, 0x000fe400078ec0ffULL,
0x0000004309097210ULL, 0x000fe200007fe4ffULL, 0x000000027834a824ULL, 0x140fe200078e020dULL,
0x000000400f0aa211ULL, 0x040fe200078038ffULL, 0x000000027836a824ULL, 0x000fe200078e020dULL,
0x000000440f0ca211ULL, 0x040fe200078238ffULL, 0x000000010e327824ULL, 0x000fe200078e020bULL,
0x000000420f0ba211ULL, 0x040fe200000f3cffULL, 0x000000083433a824ULL, 0x100fe200078e0207ULL,
0x000000460f0da211ULL, 0x000fe200008f3cffULL, 0x000000083635a824ULL, 0x000fe200078e0207ULL,
0x0000003207317211ULL, 0x040fe200078e20ffULL, 0x0000001007087825ULL, 0x000fe200078e0008ULL,
0x000045803333a811ULL, 0x000fc400078e20ffULL, 0x000041803535a811ULL, 0x000fe200078e20ffULL,
0x00000010070aa825ULL, 0x040fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008317faeULL, 0x0005e6000b901c46ULL, 0x00000010070ca825ULL, 0x000fe200078e000cULL,
0x000000000a33afaeULL, 0x0005e8000b901c46ULL, 0x000000000c35afaeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff45087810ULL, 0x004fe20007ffe0ffULL,
0x00000010070a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc40000011607ULL,
0x00000002ff3e7819ULL, 0x000fe20000011607ULL, 0x0000008008097824ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000080008087824ULL, 0x000fe200078e00ffULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000083e317824ULL, 0x040fe200078e00ffULL,
0x0000008009097812ULL, 0x000fe200078ec0ffULL, 0x000000083e327824ULL, 0x040fe200078e00ffULL,
0x000000083e487810ULL, 0x040fe20007ffe0ffULL, 0x000000083e347824ULL, 0x040fe200078e00ffULL,
0x000000013e0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010078097824ULL, 0x000fe200078e0209ULL,
0x000000043e337810ULL, 0x040fe20007ffe0ffULL, 0x000000083e387824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee20dULL, 0x000000083e3c7824ULL, 0x040fe200078e00ffULL,
0x000000090b0a7210ULL, 0x000fe20007ffe00aULL, 0x000000083e4a7824ULL, 0x000fe200078e00ffULL,
0x0000000207097819ULL, 0x000fe200000006ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180000a0b7984ULL, 0x000ea20000000800ULL, 0x0000000c093d7812ULL, 0x000fe400078ec0ffULL,
0x0000080008097812ULL, 0x000fe200078ec0ffULL, 0x004580000a0c7984ULL, 0x0007220000000800ULL,
0xfffffff831087812ULL, 0x000fe200078ee23eULL, 0x0000000848317824ULL, 0x000fe200078e00ffULL,
0x000001800e097810ULL, 0x000fe40007ffe009ULL, 0x000000023e0d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000908087211ULL, 0x000fc400078e20ffULL, 0xfffffff8310a7812ULL, 0x008fe400078ee248ULL,
0xfffffff834347812ULL, 0x000fe200078ee20dULL, 0x000000013d087824ULL, 0x040fe200078e0208ULL,
0x000000033e317810ULL, 0x000fe20007ffe0ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0209ULL,
0x000000033e3a7819ULL, 0x040fe400000006ffULL, 0x000000053e357810ULL, 0x000fe20007ffe0ffULL,
0x000000013d0d7824ULL, 0x000fe200078e020aULL, 0x0000000008087984ULL, 0x000ee20000000800ULL,
0x00000010320a7824ULL, 0x000fe200078e0209ULL, 0xfffffff838327812ULL, 0x000fc400078ee231ULL,
0x000000000d367984ULL, 0x0002e20000000800ULL, 0x000000013d0a7824ULL, 0x040fe200078e020aULL,
0xfffffff83a3a7812ULL, 0x000fe400078ee233ULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee235ULL,
0x000000063e337810ULL, 0x000fe20007ffe0ffULL, 0x000400000a377984ULL, 0x000fe20000000800ULL,
0x00000010320d7824ULL, 0x002fe200078e0209ULL, 0xffffffff3e357810ULL, 0x000fe40007ffe0ffULL,
0x000000093a327211ULL, 0x000fe200078e20ffULL, 0x000000013d317824ULL, 0x000fe200078e020dULL,
0x0000000b060b7221ULL, 0x004fe20000010100ULL, 0xfffffff84a3a7812ULL, 0x000fc400078ee235ULL,
0x000000013d327824ULL, 0x000fe200078e0232ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fe20000410000ULL,
0x0004000031397984ULL, 0x000fe20000000800ULL, 0x000000103a357824ULL, 0x000fe200078e0209ULL,
0x0000030045007a0cULL, 0x000fe40003f06070ULL, 0x00040000323a7984ULL, 0x000fe20000000800ULL,
0x0000000b000b7308ULL, 0x000f220000000800ULL, 0x000000013d357824ULL, 0x000fe200078e0235ULL,
0x000000010f0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000145457810ULL, 0x000fe20007ffe0ffULL,
0x0000000c0b3b7220ULL, 0x010fe20000410000ULL, 0x00000010340c7824ULL, 0x000fe200078e0209ULL,
0x000000000a0b7984ULL, 0x000fe20000000800ULL, 0x000000033e347819ULL, 0x000fe200000006ffULL,
0x000000303b307221ULL, 0x000fe20000010000ULL, 0x000000013d0c7824ULL, 0x000fe200078e020cULL,
0x00001f3e3b3e7589ULL, 0x000e6200000e0000ULL, 0xfffffff834347812ULL, 0x000fe200078ee233ULL,
0x000000103c337824ULL, 0x000fc400078e0209ULL, 0x000000000c0d7984ULL, 0x000fe20000000800ULL,
0x20000008ff3c7230ULL, 0x008fe40000004100ULL, 0x0000001034347824ULL, 0x000fe200078e0209ULL,
0x00001f483b3f7589ULL, 0x0004e200000e0000ULL, 0x000000333d337210ULL, 0x040fe40007ffe0ffULL,
0x000000013d347824ULL, 0x000fe200078e0234ULL, 0x00000000310a7984ULL, 0x000f220000000800ULL,
0x30000036ff3d7230ULL, 0x000fc60000004100ULL, 0x0000000032097984ULL, 0x000f220000000800ULL,
0x30000008ff3b7230ULL, 0x004fe40000004100ULL, 0x20000036ff087230ULL, 0x000fe20000004100ULL,
0x000400000c387984ULL, 0x000ea20000000800ULL, 0x0000003e3c2f7223ULL, 0x002fc6000001002fULL,
0x00000000330c7984ULL, 0x000e620000000800ULL, 0x20000037ff3c7230ULL, 0x100fe20000004100ULL,
0x0000003e3b2e7223ULL, 0x000fe2000001002eULL, 0x30000037ff377230ULL, 0x000fe20000004100ULL,
0x0004000033317984ULL, 0x000e620000000800ULL, 0x0000003f082d7223ULL, 0x008fc6000001002dULL,
0x0004000034327984ULL, 0x000ee20000000800ULL, 0x0000003f3c297223ULL, 0x080fe20000010029ULL,
0x0000003f37287223ULL, 0x080fe20000010028ULL, 0x2000000bff367230ULL, 0x100fe20000004100ULL,
0x0000000034087984ULL, 0x0008e20000000800ULL, 0x3000000bff0b7230ULL, 0x000fe20000004100ULL,
0x0000003f3d2c7223ULL, 0x000fe4000001002cULL, 0x0004000035337984ULL, 0x000ee20000000800ULL,
0x0000003e362b7223ULL, 0x080fe2000001002bULL, 0x0000003e0b2a7223ULL, 0x000fe2000001002aULL,
0x2000000dff367230ULL, 0x100fe20000004100ULL, 0x00000000350b7984ULL, 0x000ee20000000800ULL,
0x3000000dff0d7230ULL, 0x000fc60000004100ULL, 0x0000003e36277223ULL, 0x080fe40000010027ULL,
0x0000003e0d267223ULL, 0x080fe20000010026ULL, 0x2000000aff347230ULL, 0x110fe40000004100ULL,
0x3000000aff0d7230ULL, 0x000fe40000004100ULL, 0x20000009ff0a7230ULL, 0x100fe20000004100ULL,
0x0000003e34237223ULL, 0x080fe20000010023ULL, 0x30000009ff097230ULL, 0x000fe20000004100ULL,
0x0000003e0d227223ULL, 0x080fe20000010022ULL, 0x20000039ff347230ULL, 0x000fe20000004100ULL,
0x0000003e0a1f7223ULL, 0x080fe2000001001fULL, 0x20000038ff3c7230ULL, 0x004fe20000004100ULL,
0x0000003e091e7223ULL, 0x080fe2000001001eULL, 0x3000003aff097230ULL, 0x000fe20000004100ULL,
0x0000003f34217223ULL, 0x080fe20000010021ULL, 0x2000000cff0a7230ULL, 0x102fe20000004100ULL,
0x0000003f3c257223ULL, 0x080fe20000010025ULL, 0x3000000cff0c7230ULL, 0x000fe20000004100ULL,
0x0000003f091c7223ULL, 0x080fe2000001001cULL, 0x20000031ff0d7230ULL, 0x000fe20000004100ULL,
0x0000003e0a157223ULL, 0x080fe20000010015ULL, 0x30000038ff377230ULL, 0x000fe20000004100ULL,
0x0000003e0c1b7223ULL, 0x080fe2000001001bULL, 0x20000032ff097230ULL, 0x008fe20000004100ULL,
0x0000003f0d1a7223ULL, 0x080fe2000001001aULL, 0x30000039ff397230ULL, 0x000fe20000004100ULL,
0x0000003f37247223ULL, 0x080fe20000010024ULL, 0x20000008ff0a7230ULL, 0x000fe20000004100ULL,
0x0000003f09187223ULL, 0x080fe20000010018ULL, 0x2000003aff347230ULL, 0x000fe20000004100ULL,
0x0000003f39207223ULL, 0x080fe20000010020ULL, 0x20000033ff0d7230ULL, 0x000fe20000004100ULL,
0x0000003e0a117223ULL, 0x080fe20000010011ULL, 0x30000031ff0c7230ULL, 0x000fe20000004100ULL,
0x0000003f341d7223ULL, 0x080fe2000001001dULL, 0x2000000bff097230ULL, 0x100fe20000004100ULL,
0x0000003f0d127223ULL, 0x080fe20000010012ULL, 0x30000008ff087230ULL, 0x000fe20000004100ULL,
0x0000003f0c137223ULL, 0x080fe20000010013ULL, 0x30000032ff327230ULL, 0x000fe20000004100ULL,
0x0000003e09167223ULL, 0x080fe20000010016ULL, 0x3000000bff0b7230ULL, 0x000fe20000004100ULL,
0x0000003e08197223ULL, 0x000fe20000010019ULL, 0x30000033ff337230ULL, 0x000fe20000004100ULL,
0x0000003f32177223ULL, 0x000fc40000010017ULL, 0x0000003e0b147223ULL, 0x000fe40000010014ULL,
0x0000003f33107223ULL, 0x000fe20000010010ULL, 0xfffff48000008947ULL, 0x000fea000383ffffULL,
0x0180000030027810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000002027812ULL, 0x000fe200078ec0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0001922000067802ULL, 0x002fc40000000f00ULL, 0x0000cf9000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003000037308ULL, 0x000ea40000001000ULL, 0xbf80000003027423ULL, 0x004fc80000000030ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203027223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff0b7819ULL, 0x004fc40000011609ULL,
0x00000008090d7811ULL, 0x040fe200078ff0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x000000020b0c7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0b02067589ULL, 0x002e6200000e0000ULL,
0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000080b317824ULL, 0x040fe200078e00ffULL,
0x000000030b0e7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0d02077589ULL, 0x0004e200000e0000ULL,
0x000000080b327824ULL, 0x040fe200078e00ffULL, 0x000000030b307819ULL, 0x000fe200000006ffULL,
0x000000080d347824ULL, 0x000fe200078e00ffULL, 0xfffffff8310e7812ULL, 0x000fc400078ee20eULL,
0x0000000c09097812ULL, 0x000fe400078ec0ffULL, 0xfffffff834347812ULL, 0x000fe200078ee20dULL,
0x000000100e0e7824ULL, 0x000fc800078e0205ULL, 0x0000001034347824ULL, 0x000fe200078e0205ULL,
0x0000001906087220ULL, 0x042fe20000410000ULL, 0x0000002f062f7220ULL, 0x040fe20000410000ULL,
0x0000002e062e7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001b06027220ULL, 0x044fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001606167220ULL, 0x040fe20000410000ULL, 0x0000001406037220ULL, 0x000fe20000410000ULL,
0x000000080b197824ULL, 0x040fe200078e00ffULL, 0x000000010b067810ULL, 0x000fe20007ffe0ffULL,
0x0000002d072d7220ULL, 0x048fe20000410000ULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000002807287220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001807187220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001007077220ULL, 0x000fe20000410000ULL,
0x000000080b107824ULL, 0x040fe200078e00ffULL, 0x000000030b1b7819ULL, 0x040fe200000006ffULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0xfffffff8190a7812ULL, 0x000fe200078ee206ULL,
0x000000080b067824ULL, 0x000fe200078e00ffULL, 0xfffffff81b0c7812ULL, 0x000fc400078ee20cULL,
0xfffffff810107812ULL, 0x000fe400078ee20fULL, 0x000000050b0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0xffffffff0b1b7810ULL, 0x040fe20007ffe0ffULL,
0x0000001010107824ULL, 0x000fe200078e0205ULL, 0x000000060b197810ULL, 0x000fe40007ffe0ffULL,
0xfffffff806067812ULL, 0x000fe400078ee20bULL, 0xfffffff814147812ULL, 0x000fe200078ee20fULL,
0x00000001090f7824ULL, 0x040fe200078e020eULL, 0xfffffff832327812ULL, 0x000fe200078ee21bULL,
0x0000001006067824ULL, 0x000fe200078e0205ULL, 0xfffffff830307812ULL, 0x000fe200078ee219ULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x000000050a0a7211ULL, 0x080fe200078e20ffULL,
0x0000001032327824ULL, 0x000fe200078e0205ULL, 0x0000000530307211ULL, 0x000fe200078e20ffULL,
0x0000000106057824ULL, 0x000fe200078e0209ULL, 0x0000002f2e2e723eULL, 0x000fe200000000ffULL,
0x00000001090b7824ULL, 0x040fe200078e020aULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x0000000109147824ULL, 0x040fe200078e0214ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000002e05007388ULL, 0x0003e20000000800ULL, 0x0000000c090d7210ULL, 0x040fe20007ffe0ffULL,
0x0000000109307824ULL, 0x040fe200078e0230ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000002a0b007388ULL, 0x0003e20000000800ULL, 0x000000110808723eULL, 0x000fe200000000ffULL,
0x0000000109117824ULL, 0x000fe200078e0210ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x000000260d007388ULL, 0x0003e20000000800ULL, 0x000000150202723eULL, 0x000fc400000000ffULL,
0x000000160303723eULL, 0x000fe200000000ffULL, 0x000000220f007388ULL, 0x0003e20000000800ULL,
0x0000003209327210ULL, 0x040fe20007ffe0ffULL, 0x0000000109097824ULL, 0x000fe200078e0234ULL,
0x0000002d2c2c723eULL, 0x000fe200000000ffULL, 0x0000001e11007388ULL, 0x0003e20000000800ULL,
0x000000292828723eULL, 0x000fe400000000ffULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x0000000214007388ULL, 0x0003e20000000800ULL, 0x000000212020723eULL, 0x000fc400000000ffULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x0000000830007388ULL, 0x0003e20000000800ULL,
0x0000001a1313723eULL, 0x000fe400000000ffULL, 0x000000181717723eULL, 0x000fe200000000ffULL,
0x0000000332007388ULL, 0x0003e20000000800ULL, 0x000000120707723eULL, 0x000fc600000000ffULL,
0x0000002c09007388ULL, 0x0003e80000000800ULL, 0x000400280b007388ULL, 0x0003e80000000800ULL,
0x000400240d007388ULL, 0x0003e80000000800ULL, 0x000400200f007388ULL, 0x0003e80000000800ULL,
0x0004001c11007388ULL, 0x0003e80000000800ULL, 0x0004001314007388ULL, 0x0003e80000000800ULL,
0x0004001730007388ULL, 0x0003e80000000800ULL, 0x0004000732007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000087919ULL, 0x002e620000000000ULL,
0x0000580000007a24ULL, 0x000fc600078e02ffULL, 0x0000000000097919ULL, 0x000ea20000002600ULL,
0x00000003ff027819ULL, 0x002fca0000011608ULL, 0x0000000102037824ULL, 0x000fca00078e0208ULL,
0x0000000703037812ULL, 0x000fc800078ec0ffULL, 0x0ffffff803037812ULL, 0x000fca00078ef808ULL,
0x0000001003047824ULL, 0x000fe400078e0204ULL, 0x0000580002037a24ULL, 0x004fe200078e0209ULL,
0x0000000708097812ULL, 0x000fc600078ec0ffULL, 0x00a0000004047984ULL, 0x000e620000000c00ULL,
0x0000000300007211ULL, 0x000fe400078010ffULL, 0x1ffffff809097812ULL, 0x000fc600078ef872ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fc800078048ffULL,
0x00005b0000037a11ULL, 0x000fca00000f4c03ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000006787d7819ULL, 0x040fe200000006ffULL, 0x00000100787c7824ULL, 0x000fe200078e00ffULL,
0x0000002015067810ULL, 0x040fe40007ffe0ffULL, 0x000000031500780cULL, 0x000fe20003f44070ULL,
0x000001007a0a7824ULL, 0x000fe200078e027dULL, 0x00000001ff7b7819ULL, 0x000fc60000011678ULL,
0x000000010a047824ULL, 0x140fe400078e0215ULL, 0x0000680077037a24ULL, 0x000fe400078e020aULL,
0x000000010a087824ULL, 0x000fe200078e0206ULL, 0x000000750400720cULL, 0x080fe20003f06070ULL,
0x0000000103047824ULL, 0x040fe200078e0215ULL, 0x0000000603067210ULL, 0x000fe20007ffe0ffULL,
0x0000000415037824ULL, 0x000fe200078e027cULL, 0x000000750800720cULL, 0x000fe20003f26070ULL,
0x0000660004047625ULL, 0x000fc800078e0017ULL, 0x0000660006067625ULL, 0x000fe200078e0017ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ad000ff087f8cULL, 0x000e62000c80043fULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000027a7b7824ULL, 0x000fe400078e027bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1460000004037faeULL, 0x0005e8000c121846ULL,
0x1468000006037faeULL, 0x0005e2000c921846ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x0000000400047824ULL, 0x104fe200078e0215ULL, 0x000000767b00720cULL, 0x000fe20003f06070ULL,
0x0000000478037824ULL, 0x000fc600078e0215ULL, 0x0000000104047819ULL, 0x000fe400000006ffULL,
0x00014a8003037811ULL, 0x000fc600078e10ffULL, 0x0000640004047a24ULL, 0x000fc800078e027bULL,
0x0000600004047625ULL, 0x000fca00078e0017ULL, 0x0000000004037faeULL, 0x0005e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000017a037810ULL, 0x004fe20007ffe0ffULL, 0x0000008070067824ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x000000740300720cULL, 0x000fe20003f06070ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000ffff037224ULL, 0x002fe200078e0009ULL,
0x0000004006177812ULL, 0x000fe200078ef80aULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000093000008947ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000e620000000000ULL, 0x00014a80780f7811ULL, 0x040fe200078e20ffULL,
0x00000200ff127424ULL, 0x000fe200078e00ffULL, 0x0000200078117811ULL, 0x000fe400078e68ffULL,
0x00000002ff107819ULL, 0x002fe2000001160bULL, 0x000000100b157824ULL, 0x000fc800078e00ffULL,
0x00000004100d7824ULL, 0x000fe200078e027cULL, 0x0000003015157812ULL, 0x000fe200078ec0ffULL,
0x0000000117087824ULL, 0x000fc600078e0210ULL, 0x014600000d047984ULL, 0x000e640000000800ULL,
0x0000000f04097211ULL, 0x002fe400078e10ffULL, 0x0000000a75047217ULL, 0x000fc80007800000ULL,
0x0000000009097984ULL, 0x000e620000000800ULL, 0x0000000104077824ULL, 0x000fe200078e0a0aULL,
0x00000008100a7810ULL, 0x000fc80007ffe0ffULL, 0x000000071000720cULL, 0x000fe20003f06070ULL,
0x0000000409057c24ULL, 0x002fe2000f8e0208ULL, 0x0000000b0b087211ULL, 0x000fc600078fe8ffULL,
0x00005e0005047625ULL, 0x000fe200078e0012ULL, 0x00000003080c7812ULL, 0x000fc800078ec0ffULL,
0x0000001504087210ULL, 0x000fe40007f3e0ffULL, 0x0ffffffc0c047812ULL, 0x000fe200078ef80bULL,
0x000000040a0b7824ULL, 0x000fe200078e00ffULL, 0x00000005ff097210ULL, 0x000fe20000ffe4ffULL,
0x0000000117057824ULL, 0x000fe400078e020aULL, 0x0000001004137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0x000000070a00720cULL, 0x000fc60003f06070ULL, 0x014620000d047984ULL, 0x000ea20000000800ULL,
0x0000001010087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x00000004040e7824ULL, 0x004fcc00078e020fULL, 0x000000000e0e7984ULL, 0x000e640000000800ULL,
0x000000040e057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0012ULL,
0x00000015040a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b047812ULL, 0x000fe400078ee20cULL,
0x00000005ff0b7210ULL, 0x000fe20000ffe4ffULL, 0x0000000117057824ULL, 0x000fe400078e0208ULL,
0x0000001004137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x000000070800720cULL, 0x000fc60003f06070ULL,
0x014640000d047984ULL, 0x000ea20000000800ULL, 0x00000018100a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe400078e00ffULL, 0x00000004040e7824ULL, 0x004fcc00078e020fULL,
0x000000000e0e7984ULL, 0x000e640000000800ULL, 0x000000040e057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0012ULL, 0x0000001504087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc09047812ULL, 0x000fe400078ee20cULL, 0x00000005ff097210ULL, 0x000fe20000ffe4ffULL,
0x0000000117057824ULL, 0x000fe400078e020aULL, 0x0000001004137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0x000000070a00720cULL, 0x000fc60003f06070ULL, 0x014660000d047984ULL, 0x000ea20000000800ULL,
0x0000002010087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x00000004040e7824ULL, 0x004fcc00078e020fULL, 0x000000000e0e7984ULL, 0x000e640000000800ULL,
0x000000040e057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0012ULL,
0x00000015040a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b047812ULL, 0x000fe400078ee20cULL,
0x00000005ff0b7210ULL, 0x000fe20000ffe4ffULL, 0x0000000117057824ULL, 0x000fe400078e0208ULL,
0x0000001004137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x000000070800720cULL, 0x000fc60003f06070ULL,
0x014680000d047984ULL, 0x000ea20000000800ULL, 0x00000028100a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe400078e00ffULL, 0x00000004040e7824ULL, 0x004fcc00078e020fULL,
0x000000000e0e7984ULL, 0x000e640000000800ULL, 0x000000040e057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0012ULL, 0x0000001504087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc09047812ULL, 0x000fe400078ee20cULL, 0x00000005ff097210ULL, 0x000fe20000ffe4ffULL,
0x0000000117057824ULL, 0x000fe400078e020aULL, 0x0000001004137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0x000000070a00720cULL, 0x000fc60003f06070ULL, 0x0146a0000d047984ULL, 0x000ea20000000800ULL,
0x0000003010087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x00000004040e7824ULL, 0x004fcc00078e020fULL, 0x000000000e0e7984ULL, 0x000e640000000800ULL,
0x000000040e057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0012ULL,
0x00000015040a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b047812ULL, 0x000fe400078ee20cULL,
0x00000005ff0b7210ULL, 0x000fe20000ffe4ffULL, 0x0000000117057824ULL, 0x000fe400078e0208ULL,
0x0000001004137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x000000070800720cULL, 0x000fc60003f06070ULL,
0x0146c0000d047984ULL, 0x000ea20000000800ULL, 0x00000038100a7810ULL, 0x002fe20007ffe0ffULL,
0x00000004040e7824ULL, 0x004fcc00078e020fULL, 0x000000000e0e7984ULL, 0x000e640000000800ULL,
0x000000040e057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0012ULL,
0x0000001504087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09047812ULL, 0x000fe400078ee20cULL,
0x00000005ff097210ULL, 0x000fc60000ffe4ffULL, 0x00000010040b7824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x000000070a00720cULL, 0x040fe20003f06070ULL, 0x000000040a077824ULL, 0x000fe400078e00ffULL,
0x0146e0000d047984ULL, 0x000ea60000000800ULL, 0xfffffffc070c7812ULL, 0x000fca00078ee20cULL,
0x000000100c117824ULL, 0x000fe400078e0211ULL, 0x00000004040f7824ULL, 0x004fe400078e020fULL,
0x0000000117047824ULL, 0x000fc800078e020aULL, 0x000000000f0f7984ULL, 0x000ea40000000800ULL,
0x000000040f047c24ULL, 0x004fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0012ULL,
0x0000001504047210ULL, 0x000fc80007f3e0ffULL, 0x00000005ff057210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004117faeULL, 0x0003e2000c101c46ULL,
0x0000088000007947ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000e620000000000ULL,
0x00014a80780f7811ULL, 0x040fe400078e20ffULL, 0x0000020000117802ULL, 0x000fe40000000f00ULL,
0x0000200078157811ULL, 0x000fe400078e68ffULL, 0x00000002ff0c7819ULL, 0x002fe20000011609ULL,
0x00000010090a7824ULL, 0x040fe200078e00ffULL, 0x0000000909087211ULL, 0x000fc600078fe8ffULL,
0x000000040c0d7824ULL, 0x000fe200078e027cULL, 0x000000300a137812ULL, 0x000fe400078ec0ffULL,
0x00000003080e7812ULL, 0x000fe400078ec0ffULL, 0x014600000d047984ULL, 0x000e620000000800ULL,
0x000000080c0a7810ULL, 0x000fca0007ffe0ffULL, 0x000000040a0b7824ULL, 0x000fe400078e00ffULL,
0x0000000404077824ULL, 0x002fe400078e020fULL, 0x0000000117047824ULL, 0x000fc800078e020cULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304087210ULL, 0x000fe40007f1e0ffULL,
0x0ffffffc0e047812ULL, 0x000fc600078ef809ULL, 0x000000ffff097224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x014620000d047984ULL, 0x000ea20000000800ULL,
0x000000100c087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x0000000404077824ULL, 0x004fe200078e020fULL, 0x0000000a17047210ULL, 0x000fca0007ffe0ffULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x00000013040a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b047812ULL, 0x000fc600078ee20eULL, 0x000000ffff0b7224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e8000b901c46ULL, 0x014640000d047984ULL, 0x000ea20000000800ULL,
0x000000180c0a7810ULL, 0x002fca0007ffe0ffULL, 0x000000040a0b7824ULL, 0x000fe400078e00ffULL,
0x0000000404077824ULL, 0x004fe200078e020fULL, 0x0000000817047210ULL, 0x000fca0007ffe0ffULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20eULL, 0x000000ffff097224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x014660000d047984ULL, 0x000ea20000000800ULL,
0x000000200c087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x0000000404077824ULL, 0x004fe200078e020fULL, 0x0000000a17047210ULL, 0x000fca0007ffe0ffULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x00000013040a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b047812ULL, 0x000fc600078ee20eULL, 0x000000ffff0b7224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e8000b901c46ULL, 0x014680000d047984ULL, 0x000ea20000000800ULL,
0x000000280c0a7810ULL, 0x002fca0007ffe0ffULL, 0x000000040a0b7824ULL, 0x000fe400078e00ffULL,
0x0000000404077824ULL, 0x004fe200078e020fULL, 0x0000000817047210ULL, 0x000fca0007ffe0ffULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20eULL, 0x000000ffff097224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x0146a0000d047984ULL, 0x000ea20000000800ULL,
0x000000300c087810ULL, 0x042fe40007ffe0ffULL, 0x000000380c0c7810ULL, 0x000fc60007ffe0ffULL,
0x0000000408097824ULL, 0x000fe400078e00ffULL, 0x0000000404077824ULL, 0x004fe200078e020fULL,
0x0000000a17047210ULL, 0x000fca0007ffe0ffULL, 0x0000000007077984ULL, 0x000e640000000800ULL,
0x0000000407047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x00000013040a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc0b047812ULL, 0x000fc600078ee20eULL,
0x000000ffff0b7224ULL, 0x000fe400000e0605ULL, 0x0000001004197824ULL, 0x000fca00078e0215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x0146c0000d047984ULL, 0x000ea40000000800ULL, 0x0000000404077824ULL, 0x004fe200078e020fULL,
0x0000000817047210ULL, 0x000fca0007ffe0ffULL, 0x0000000007077984ULL, 0x000ea40000000800ULL,
0x0000000407047c24ULL, 0x004fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09047812ULL, 0x000fc600078ee20eULL,
0x000000ffff097224ULL, 0x000fe400000e0605ULL, 0x00000010040b7824ULL, 0x002fca00078e0215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c46ULL,
0x0146e0000d047984ULL, 0x000ea40000000800ULL, 0x0000000404077824ULL, 0x004fe200078e020fULL,
0x0000000c17047210ULL, 0x000fe20007ffe0ffULL, 0x000000040c0f7824ULL, 0x000fc800078e00ffULL,
0x0000000007077984ULL, 0x000ea20000000800ULL, 0xfffffffc0f0e7812ULL, 0x000fca00078ee20eULL,
0x000000100e157824ULL, 0x000fe400078e0215ULL, 0x0000000407047c24ULL, 0x004fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304047210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e6000b901c46ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x014ad400ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000804087210ULL, 0x000fc80007f1e1ffULL,
0x0000000905097210ULL, 0x000fe400007fe5ffULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011409ULL,
0x0000000807077211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000207077819ULL, 0x000fc80000001208ULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x014ad400ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000747a00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x00014b5878727811ULL, 0x040fe200078e18ffULL, 0x0000002078717824ULL, 0x000fe200078e00ffULL,
0xffffffff74797810ULL, 0x000fe20007ffe0ffULL, 0x0000008005057824ULL, 0x000fc400078e00ffULL,
0x0000007d7a047211ULL, 0x004fe200078e40ffULL, 0x0000000000007946ULL, 0x000fe60003800000ULL,
0x000000047500720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x0000007a7300720cULL, 0x000fe20003f44070ULL,
0x000000ffff707224ULL, 0x000fc600078e00ffULL, 0x0000000103037807ULL, 0x000fc40005000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x0001b36000287802ULL, 0x000fc40000000f00ULL, 0x0000b0a000007944ULL, 0x002fea0003c00000ULL,
0x00000002ff297819ULL, 0x000fe20000011670ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002970297207ULL, 0x000fe20001000000ULL, 0x0000111000007945ULL, 0x000fe80003800000ULL,
0x0000030029a47a24ULL, 0x000fc800078e027aULL, 0x00000100a4a27824ULL, 0x040fe200078e027dULL,
0x00000001a4297810ULL, 0x000fc80007ffe0ffULL, 0x000000742900720cULL, 0x000fe40003f06070ULL,
0x00000040a2297812ULL, 0x000fca00078ec0ffULL, 0x0000000106a67824ULL, 0x000fcc00078e0229ULL,
0x000008a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x002fe20000011607ULL,
0x00000200ff377424ULL, 0x000fe200078e00ffULL, 0x00014a8078357811ULL, 0x040fe400078e20ffULL,
0x0000007c31337211ULL, 0x040fe200078e10ffULL, 0x00000001312b7824ULL, 0x000fe200078e02a6ULL,
0x000000a275297217ULL, 0x000fe40007800000ULL, 0x00000007072d7211ULL, 0x000fe200078fe8ffULL,
0x0146000033287984ULL, 0x000e620000000800ULL, 0x00003000782e7811ULL, 0x000fe200078e68ffULL,
0x00000001292c7824ULL, 0x000fe200078e0aa2ULL, 0x000000032d327812ULL, 0x000fc800078ec0ffULL,
0x0000002c3100720cULL, 0x000fe40003f26070ULL, 0x0ffffffc322f7812ULL, 0x000fc800078ef807ULL,
0x0000002e2f2f7211ULL, 0x000fe200078e20ffULL, 0x00000004282a7824ULL, 0x002fe200078e0235ULL,
0x0000000307287812ULL, 0x000fc800078ec0ffULL, 0x00000004282d7812ULL, 0x000fe200078efcffULL,
0x000000002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a052b7224ULL, 0x002fc800078e022bULL,
0x00005e002b287625ULL, 0x000fe200078e0037ULL, 0x00000008312b7810ULL, 0x000fca0007ffe0ffULL,
0x000000102d287825ULL, 0x000fc800078e0028ULL, 0x000000042b397824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282f7faeULL, 0x0003e2000c901c46ULL,
0x0000002c2b00720cULL, 0x000fc60003f26070ULL, 0x01462000332a7984ULL, 0x000ea20000000800ULL,
0xfffffffc39397812ULL, 0x000fca00078ee232ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x0000001031297810ULL, 0x000fca0007ffe0ffULL, 0x0000000429397824ULL, 0x000fca00078e00ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x000000042a307824ULL, 0x004fe400078e0235ULL,
0x000000012b2a7824ULL, 0x000fc800078e02a6ULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x00000030052a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL,
0x000000102d2a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2900720cULL, 0x000fc60003f26070ULL,
0x0146400033287984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x00000018312b7810ULL, 0x000fca0007ffe0ffULL, 0x000000042b397824ULL, 0x000fca00078e00ffULL,
0xfffffffc39397812ULL, 0x000fe400078ee232ULL, 0x0000003528307211ULL, 0x004fe200078e10ffULL,
0x0000000129287824ULL, 0x000fca00078e02a6ULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2b00720cULL, 0x000fc60003f26070ULL,
0x01466000332a7984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x0000002031297810ULL, 0x000fc80007ffe0ffULL, 0x0000000229397819ULL, 0x000fc800000006ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x000000042a307824ULL, 0x004fe200078e0235ULL,
0x000000a62b2a7210ULL, 0x000fca0007ffe0ffULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x00000030052a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL,
0x000000102d2a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2900720cULL, 0x000fc60003f26070ULL,
0x0146800033287984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x00000028312b7810ULL, 0x000fca0007ffe0ffULL, 0x000000042b397824ULL, 0x000fca00078e00ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x0000000428307824ULL, 0x004fe400078e0235ULL,
0x0000000129287824ULL, 0x000fc800078e02a6ULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2b00720cULL, 0x000fc60003f26070ULL,
0x0146a000332a7984ULL, 0x000ea20000000800ULL, 0x0000002e392f7211ULL, 0x002fe400078e20ffULL,
0x0000003031297810ULL, 0x040fe40007ffe0ffULL, 0x0000003831317810ULL, 0x000fc60007ffe0ffULL,
0x0000000429397824ULL, 0x000fca00078e00ffULL, 0xfffffffc39397812ULL, 0x000fe200078ee232ULL,
0x000000042a307824ULL, 0x004fe400078e0235ULL, 0x000000012b2a7824ULL, 0x000fc800078e02a6ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL, 0x000000102d2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e2000c901c46ULL,
0x0000002c2900720cULL, 0x000fc60003f26070ULL, 0x0146c00033287984ULL, 0x000ea20000000800ULL,
0x00000010392f7824ULL, 0x002fe400078e022eULL, 0x0000000428307824ULL, 0x004fe400078e0235ULL,
0x0000000129287824ULL, 0x000fc800078e02a6ULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c3100720cULL, 0x000fc60003f26070ULL,
0x0146e000332a7984ULL, 0x000ea40000000800ULL, 0x000000352a307211ULL, 0x004fe200078e10ffULL,
0x00000001312a7824ULL, 0x040fe400078e02a6ULL, 0x0000000431357824ULL, 0x000fc600078e00ffULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0xfffffffc35317812ULL, 0x000fca00078ee232ULL,
0x0000001031297824ULL, 0x002fe400078e022eULL, 0x00000030052a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL, 0x000000102d2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a297faeULL, 0x0003e2000c901c46ULL,
0x000007f000007947ULL, 0x000fea0003800000ULL, 0x00000002ff2d7819ULL, 0x002fe20000011607ULL,
0x00000200ff337424ULL, 0x000fe200078e00ffULL, 0x00014a8078317811ULL, 0x000fe400078e20ffULL,
0x00000007072b7211ULL, 0x000fe200078fe8ffULL, 0x000000042d307824ULL, 0x000fe200078e027cULL,
0x0000000307297812ULL, 0x000fe400078ec0ffULL, 0x000000032b2e7812ULL, 0x000fe400078ec0ffULL,
0x0146000030287984ULL, 0x000e620000000800ULL, 0x00000004292f7812ULL, 0x000fc400078efcffULL,
0x0000300078327811ULL, 0x000fe400078e68ffULL, 0x0ffffffc2e2b7812ULL, 0x000fca00078ef807ULL,
0x000000102b357824ULL, 0x000fe200078e0232ULL, 0x000000082d2b7810ULL, 0x000fca0007ffe0ffULL,
0x000000042b377824ULL, 0x000fca00078e00ffULL, 0xfffffffc37377812ULL, 0x000fca00078ee22eULL,
0x0000001037377824ULL, 0x000fe200078e0232ULL, 0x00000031282a7211ULL, 0x002fe200078e10ffULL,
0x000000012d287824ULL, 0x000fca00078e02a6ULL, 0x000000002a2a7984ULL, 0x000e640000000800ULL,
0x0000002a05287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x01462000302a7984ULL, 0x000ea20000000800ULL,
0x000000102d297810ULL, 0x002fc80007ffe0ffULL, 0x0000000229357819ULL, 0x000fc800000006ffULL,
0xfffffffc35357812ULL, 0x000fca00078ee22eULL, 0x0000001035357824ULL, 0x000fe400078e0232ULL,
0x000000042a2c7824ULL, 0x004fe200078e0231ULL, 0x000000a62b2a7210ULL, 0x000fca0007ffe0ffULL,
0x000000002c2c7984ULL, 0x000e640000000800ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e8000b901c46ULL,
0x0146400030287984ULL, 0x000ea20000000800ULL, 0x000000182d2b7810ULL, 0x002fca0007ffe0ffULL,
0x000000042b377824ULL, 0x000fca00078e00ffULL, 0xfffffffc37377812ULL, 0x000fc800078ee22eULL,
0x0000003237377211ULL, 0x000fe200078e20ffULL, 0x00000004282c7824ULL, 0x004fe400078e0231ULL,
0x0000000129287824ULL, 0x000fc800078e02a6ULL, 0x000000002c2c7984ULL, 0x000e640000000800ULL,
0x0000002c05287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x01466000302a7984ULL, 0x000ea20000000800ULL,
0x000000202d297810ULL, 0x002fca0007ffe0ffULL, 0x0000000429357824ULL, 0x000fca00078e00ffULL,
0xfffffffc35357812ULL, 0x000fca00078ee22eULL, 0x0000001035357824ULL, 0x000fe400078e0232ULL,
0x000000042a2c7824ULL, 0x004fe400078e0231ULL, 0x000000012b2a7824ULL, 0x000fc800078e02a6ULL,
0x000000002c2c7984ULL, 0x000e640000000800ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e8000b901c46ULL,
0x0146800030287984ULL, 0x000ea20000000800ULL, 0x000000282d2b7810ULL, 0x002fca0007ffe0ffULL,
0x000000042b377824ULL, 0x000fca00078e00ffULL, 0xfffffffc37377812ULL, 0x000fca00078ee22eULL,
0x0000001037377824ULL, 0x000fe400078e0232ULL, 0x00000004282c7824ULL, 0x004fe400078e0231ULL,
0x0000000129287824ULL, 0x000fc800078e02a6ULL, 0x000000002c2c7984ULL, 0x000e640000000800ULL,
0x0000002c05287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x0146a000302a7984ULL, 0x000ea20000000800ULL,
0x000000302d297810ULL, 0x042fe40007ffe0ffULL, 0x000000382d2d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000429357824ULL, 0x000fca00078e00ffULL, 0xfffffffc35357812ULL, 0x000fca00078ee22eULL,
0x0000001035357824ULL, 0x000fe200078e0232ULL, 0x000000312a2c7211ULL, 0x004fe200078e10ffULL,
0x000000012b2a7824ULL, 0x000fca00078e02a6ULL, 0x000000002c2c7984ULL, 0x000e640000000800ULL,
0x0000002c052a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL,
0x000000102f2a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a377faeULL, 0x0003e8000b901c46ULL, 0x0146c00030287984ULL, 0x000ea40000000800ULL,
0x00000004282c7824ULL, 0x004fe200078e0231ULL, 0x000000a629287210ULL, 0x000fca0007ffe0ffULL,
0x000000002c2c7984ULL, 0x000ea40000000800ULL, 0x0000002c05287224ULL, 0x004fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fcc00078e0033ULL, 0x000000102f287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028357faeULL, 0x0005e8000b901c46ULL,
0x0146e000302a7984ULL, 0x002e640000000800ULL, 0x000000042a2c7824ULL, 0x002fe400078e0231ULL,
0x000000012d2a7824ULL, 0x040fe200078e02a6ULL, 0x000000022d2d7819ULL, 0x000fc600000006ffULL,
0x000000002c2c7984ULL, 0x000e620000000800ULL, 0xfffffffc2d2d7812ULL, 0x000fca00078ee22eULL,
0x000000102d2d7824ULL, 0x000fe400078e0232ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x0001c4e000287802ULL, 0x004fc40000000f00ULL, 0x00009f2000007944ULL, 0x002fea0003c00000ULL,
0x00000007072a7812ULL, 0x006fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000004ff297819ULL, 0x100fe20000011607ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000082a7e7812ULL, 0x000fe200078ef807ULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x000000017e807824ULL, 0x040fe400078e0229ULL, 0x000000207e2b7824ULL, 0x000fca00078e00ffULL,
0xffffffe02b287812ULL, 0x000fca00078ee280ULL, 0x0000001028287824ULL, 0x000fc400078e00ffULL,
0x0000000329297819ULL, 0x000fe200000006ffULL, 0x0000200078a77824ULL, 0x000fe200078e00ffULL,
0x00000003ff667819ULL, 0x000fe20000011607ULL, 0x000000002848783bULL, 0x000fe20000000200ULL,
0xfffffff8292a7812ULL, 0x000fe200078ee22aULL, 0x000000207e327824ULL, 0x000fe200078e00ffULL,
0x0000000166297812ULL, 0x000fe400078ec0ffULL, 0x000000102a2c7810ULL, 0x040fe20007ffe0ffULL,
0x000000042a647824ULL, 0x040fe200078e00ffULL, 0x000000202a2e7810ULL, 0x040fe20007ffe0ffULL,
0x000000042a337824ULL, 0x040fe200078e00ffULL, 0x000000302a307810ULL, 0x000fe20007ffe0ffULL,
0x000000042c5e7824ULL, 0x000fe200078e00ffULL, 0x000000292a2b7211ULL, 0x000fc400078ff8ffULL,
0x000000292c2d7211ULL, 0x080fe200078ff8ffULL, 0x00000004305c7824ULL, 0x000fe200078e00ffULL,
0x000000292e2f7211ULL, 0x0c0fe400078ff8ffULL, 0x000000022e887819ULL, 0x000fe400000006ffULL,
0x0000002930297211ULL, 0x000fe400078ff8ffULL, 0x00002000a75d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc64647812ULL, 0x000fc400078ee22bULL, 0xfffffffc5e5e7812ULL, 0x000fe400078ee22dULL,
0xfffffffc88887812ULL, 0x000fe200078ee22fULL, 0x0000001064a37824ULL, 0x000fe200078e025dULL,
0xfffffffc5c5c7812ULL, 0x000fe200078ee229ULL, 0x000000105ea17824ULL, 0x100fe200078e025dULL,
0x000000022b867810ULL, 0x000fe20007ffe0ffULL, 0x0000001088a07824ULL, 0x000fe200078e025dULL,
0x0000005d5c9f7211ULL, 0x000fe200078e20ffULL, 0x00000000a354783bULL, 0x000e620000000200ULL,
0x000000042c2b7824ULL, 0x000fe200078e00ffULL, 0x000000022d847810ULL, 0x000fe20007ffe0ffULL,
0x00000004302d7824ULL, 0x000fe200078e00ffULL, 0x00000000a150783bULL, 0x000ea20000000200ULL,
0x0000000280317810ULL, 0x000fc40007ffe0ffULL, 0xfffffffc2b847812ULL, 0x000fe200078ee284ULL,
0x00000000a04c783bULL, 0x000ee20000000200ULL, 0x000000042e2b7824ULL, 0x000fe200078e00ffULL,
0x000000022f827810ULL, 0x000fe40007ffe0ffULL, 0x000000009f58783bULL, 0x000f220000000200ULL,
0x0000000229c67810ULL, 0x000fe20007ffe0ffULL, 0x00000010849d7824ULL, 0x000fe200078e025dULL,
0xffffffe032317812ULL, 0x000fe400078ee231ULL, 0xfffffffc33867812ULL, 0x000fc400078ee286ULL,
0xfffffffc2b827812ULL, 0x000fe200078ee282ULL, 0x000000009d40783bULL, 0x000fe20000000200ULL,
0xfffffffc2dc67812ULL, 0x000fe200078ee2c6ULL, 0x00000010869e7824ULL, 0x100fe200078e025dULL,
0x0000000431317819ULL, 0x000fe200000006ffULL, 0x00000010829c7824ULL, 0x100fe400078e025dULL,
0x00000010c6857824ULL, 0x000fe200078e025dULL, 0x000000009e44783bULL, 0x000fe80000000200ULL,
0x000000003130783bULL, 0x000f280000000200ULL, 0x000000009c38783bULL, 0x000f280000000200ULL,
0x000000008528783bULL, 0x000f220000000200ULL, 0x000000544860723cULL, 0x002f6200000018ffULL,
0x000080000000791aULL, 0x000fce0000000000ULL, 0x00000050482c723cULL, 0x044f7000000018ffULL,
0x0000004c4834723cULL, 0x048f7000000018ffULL, 0x000000564854723cULL, 0x040f7000000018ffULL,
0x000000524850723cULL, 0x040f7000000018ffULL, 0x0000004e484c723cULL, 0x040f7000000018ffULL,
0x00000058483c723cULL, 0x050f7000000018ffULL, 0x0000005a4848723cULL, 0x000f7000000018ffULL,
0x000000443060723cULL, 0x060b700000001860ULL, 0x00000040302c723cULL, 0x040b70000000182cULL,
0x000000383034723cULL, 0x040b700000001834ULL, 0x000000463044723cULL, 0x040b700000001854ULL,
0x000000423040723cULL, 0x040b700000001850ULL, 0x0000003a3038723cULL, 0x040b70000000184cULL,
0x00000028303c723cULL, 0x040b70000000183cULL, 0x0000002a3030723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000002000007947ULL, 0x000fde0003800000ULL,
0x0001ca4000287802ULL, 0x020fce0000000f00ULL, 0x000099c000007944ULL, 0x000fea0003c00000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000108000007945ULL, 0x000fe20003800000ULL,
0x0000020000907802ULL, 0x000fe20000000f00ULL, 0x0000088000008947ULL, 0x000fea0003800000ULL,
0x00000002ff817819ULL, 0x100fe20000011607ULL, 0x0000000166b67824ULL, 0x000fe200078e0207ULL,
0x00014a8078917811ULL, 0x000fe400078e20ffULL, 0x000000a275297217ULL, 0x020fe20007800000ULL,
0x0000000481927824ULL, 0x000fe200078e027cULL, 0x0000000307a57812ULL, 0x000fe200078ec0ffULL,
0x0000000181b47824ULL, 0x000fe200078e02a6ULL, 0x00000029a24a7210ULL, 0x000fc40007ffe1ffULL,
0x0146000092287984ULL, 0x000e620000000800ULL, 0x00000003b6b67812ULL, 0x000fe400078ec0ffULL,
0x0000004a8100720cULL, 0x000fe40003f26070ULL, 0x00000008a5497812ULL, 0x000fe400078efcffULL,
0x0ffffffcb6c47812ULL, 0x000fe400078ef807ULL, 0x00000008817f7810ULL, 0x040fe40007ffe0ffULL,
0x00000010818f7810ULL, 0x040fe20007ffe0ffULL, 0x00000010c49b7824ULL, 0x000fe200078e025dULL,
0x00000018818e7810ULL, 0x000fe20007ffe0ffULL, 0x000000017fb27824ULL, 0x100fe200078e02a6ULL,
0x00000020818d7810ULL, 0x000fe20007ffe0ffULL, 0x000000047f4b7824ULL, 0x000fe200078e00ffULL,
0x00000028818c7810ULL, 0x000fe20007ffe0ffULL, 0x000000018fb07824ULL, 0x100fe200078e02a6ULL,
0x000000a68dac7210ULL, 0x000fe20007ffe0ffULL, 0x000000018eae7824ULL, 0x000fe200078e02a6ULL,
0xfffffffc4bc27812ULL, 0x000fe200078ee2b6ULL, 0x000000048f4b7824ULL, 0x000fe200078e00ffULL,
0x00000030818b7810ULL, 0x000fe20007ffe0ffULL, 0x000000018caa7824ULL, 0x000fe200078e02a6ULL,
0x0000005dc29a7211ULL, 0x000fc400078e20ffULL, 0xfffffffc4bc07812ULL, 0x000fe200078ee2b6ULL,
0x000000048e4b7824ULL, 0x000fe200078e00ffULL, 0x00000038818a7810ULL, 0x000fe20007ffe0ffULL,
0x000000018ba87824ULL, 0x000fe400078e02a6ULL, 0x00000010c0997824ULL, 0x100fe200078e025dULL,
0xfffffffc4bbe7812ULL, 0x000fe200078ee2b6ULL, 0x000000048d4b7824ULL, 0x000fe400078e00ffULL,
0x000000018aa67824ULL, 0x000fe400078e02a6ULL, 0x00000010be987824ULL, 0x000fe200078e025dULL,
0xfffffffc4bbc7812ULL, 0x000fe200078ee2b6ULL, 0x00000004282a7824ULL, 0x002fe200078e0291ULL,
0x000000028c4b7819ULL, 0x000fc600000006ffULL, 0x00000010bc977824ULL, 0x000fe200078e025dULL,
0xfffffffc4bba7812ULL, 0x000fe200078ee2b6ULL, 0x000000002a2a7984ULL, 0x000e620000000800ULL,
0x000000048b4b7824ULL, 0x000fc600078e00ffULL, 0x00000010ba967824ULL, 0x000fe400078e025dULL,
0xfffffffc4bb87812ULL, 0x000fe200078ee2b6ULL, 0x000000048a4b7824ULL, 0x000fc600078e00ffULL,
0x0000005db8957211ULL, 0x000fe400078e20ffULL, 0xfffffffc4bb67812ULL, 0x000fca00078ee2b6ULL,
0x00000010b6947824ULL, 0x000fe400078e025dULL, 0x0000002a05297224ULL, 0x002fc800078e02b4ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000289b7faeULL, 0x0003e2000c901c46ULL,
0x0000004a7f00720cULL, 0x000fc60003f26070ULL, 0x01462000922a7984ULL, 0x000ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02b2ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a9a7faeULL, 0x0005e2000c901c46ULL, 0x0000004a8f00720cULL, 0x000fc60003f26070ULL,
0x0146400092287984ULL, 0x002e640000000800ULL, 0x0000000428487824ULL, 0x002fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805297224ULL, 0x002fc800078e02b0ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028997faeULL, 0x0003e2000c901c46ULL,
0x0000004a8e00720cULL, 0x000fc60003f26070ULL, 0x01466000922a7984ULL, 0x004ea40000000800ULL,
0x000000912a487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02aeULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a987faeULL, 0x0005e2000c901c46ULL, 0x0000004a8d00720cULL, 0x000fc60003f26070ULL,
0x0146800092287984ULL, 0x002e640000000800ULL, 0x0000000428487824ULL, 0x002fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805297224ULL, 0x002fc800078e02acULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028977faeULL, 0x0003e2000c901c46ULL,
0x0000004a8c00720cULL, 0x000fc60003f26070ULL, 0x0146a000922a7984ULL, 0x004ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02aaULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a967faeULL, 0x0005e2000c901c46ULL, 0x0000004a8b00720cULL, 0x000fc60003f26070ULL,
0x0146c00092287984ULL, 0x002e640000000800ULL, 0x0000000428487824ULL, 0x002fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805297224ULL, 0x002fc800078e02a8ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x00000010492a7825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a957faeULL, 0x0003e2000c901c46ULL,
0x0000004a8a00720cULL, 0x000fc60003f26070ULL, 0x0146e00092287984ULL, 0x000ea40000000800ULL,
0x0000000428487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805297224ULL, 0x004fc800078e02a6ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028947faeULL, 0x0003e2000c901c46ULL, 0x000007d000007947ULL, 0x000fea0003800000ULL,
0x00000002ff817819ULL, 0x100fe20000011607ULL, 0x0000000166667824ULL, 0x000fe200078e0207ULL,
0x00014a8078917811ULL, 0x000fe400078e20ffULL, 0x0000007c81927211ULL, 0x040fe200078e10ffULL,
0x0000000181b47824ULL, 0x000fe200078e02a6ULL, 0x0000000307a57812ULL, 0x000fe400078ec0ffULL,
0x0000000366667812ULL, 0x000fe200078ec0ffULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x00000008a5497812ULL, 0x000fc400078efcffULL, 0x0ffffffc66c47812ULL, 0x000fe400078ef807ULL,
0x00000008817f7810ULL, 0x040fe40007ffe0ffULL, 0x00000010818f7810ULL, 0x040fe20007ffe0ffULL,
0x00000010c49b7824ULL, 0x000fe200078e025dULL, 0x00000018818e7810ULL, 0x000fe20007ffe0ffULL,
0x000000017fb27824ULL, 0x100fe200078e02a6ULL, 0x000000a68fb07210ULL, 0x000fe20007ffe0ffULL,
0x000000047f4b7824ULL, 0x000fe200078e00ffULL, 0x00000020818d7810ULL, 0x040fe20007ffe0ffULL,
0x000000018eae7824ULL, 0x000fe200078e02a6ULL, 0x00000028818c7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc4bc27812ULL, 0x000fe200078ee266ULL, 0x000000048f4b7824ULL, 0x000fe200078e00ffULL,
0x00000030818b7810ULL, 0x000fe20007ffe0ffULL, 0x000000018dac7824ULL, 0x000fe200078e02a6ULL,
0x00000038818a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010c29a7824ULL, 0x100fe200078e025dULL,
0xfffffffc4bc07812ULL, 0x000fe200078ee266ULL, 0x000000018caa7824ULL, 0x100fe200078e02a6ULL,
0x000000028e4b7819ULL, 0x000fe200000006ffULL, 0x000000018ba87824ULL, 0x000fe200078e02a6ULL,
0x000000a68aa67210ULL, 0x000fe20007ffe0ffULL, 0x00000010c0997824ULL, 0x000fe200078e025dULL,
0xfffffffc4bbe7812ULL, 0x000fe200078ee266ULL, 0x000000048d4b7824ULL, 0x000fc800078e00ffULL,
0x00000010be987824ULL, 0x000fe200078e025dULL, 0xfffffffc4bbc7812ULL, 0x000fe200078ee266ULL,
0x000000048c4b7824ULL, 0x000fc600078e00ffULL, 0x0000005dbc977211ULL, 0x000fe200078e20ffULL,
0x00000004282a7824ULL, 0x002fe200078e0291ULL, 0xfffffffc4bba7812ULL, 0x000fe200078ee266ULL,
0x000000048b4b7824ULL, 0x000fc800078e00ffULL, 0x000000002a2a7984ULL, 0x000e620000000800ULL,
0x00000010ba967824ULL, 0x000fe200078e025dULL, 0xfffffffc4bb87812ULL, 0x000fe200078ee266ULL,
0x000000048a4b7824ULL, 0x000fc800078e00ffULL, 0x00000010b8957824ULL, 0x000fe200078e025dULL,
0xfffffffc4bb67812ULL, 0x000fca00078ee266ULL, 0x00000010b6947824ULL, 0x000fe400078e025dULL,
0x0000002a05297224ULL, 0x002fc800078e02b4ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000289b7faeULL, 0x0003e8000b901c46ULL, 0x01462000922a7984ULL, 0x000ea40000000800ULL,
0x000000912a487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02b2ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a9a7faeULL, 0x0005e8000b901c46ULL, 0x0146400092287984ULL, 0x002e640000000800ULL,
0x0000000428487824ULL, 0x002fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805297224ULL, 0x002fc800078e02b0ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028997faeULL, 0x0003e8000b901c46ULL, 0x01466000922a7984ULL, 0x004ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02aeULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a987faeULL, 0x0005e8000b901c46ULL, 0x0146800092287984ULL, 0x002e640000000800ULL,
0x0000000428487824ULL, 0x002fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805297224ULL, 0x002fc800078e02acULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028977faeULL, 0x0003e8000b901c46ULL, 0x0146a000922a7984ULL, 0x004ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02aaULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a967faeULL, 0x0005e8000b901c46ULL, 0x0146c00092287984ULL, 0x002e640000000800ULL,
0x0000009128487211ULL, 0x002fcc00078e10ffULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805297224ULL, 0x002fc800078e02a8ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x004fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a957faeULL, 0x0003e8000b901c46ULL, 0x0146e00092287984ULL, 0x000ea40000000800ULL,
0x0000000428487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805297224ULL, 0x004fc800078e02a6ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028947faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000207e297824ULL, 0x002fe200078e00ffULL, 0x0000000480287810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00003000a7a77810ULL, 0x000fe20007ffe0ffULL,
0x000000207e2a7824ULL, 0x000fe200078e00ffULL, 0xffffffe029287812ULL, 0x000fe200078ee228ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000680297810ULL, 0x000fe20007ffe0ffULL,
0x0000001064937824ULL, 0x100fe200078e02a7ULL, 0x0000000428287819ULL, 0x000fe200000006ffULL,
0x000000105e897824ULL, 0x000fe200078e02a7ULL, 0xffffffe02a297812ULL, 0x000fe200078ee229ULL,
0x0000001088887824ULL, 0x100fe200078e02a7ULL, 0x00000000936c783bULL, 0x000fe20000000200ULL,
0x000000105c877824ULL, 0x100fe200078e02a7ULL, 0x000000a786867211ULL, 0x000fe200078e20ffULL,
0x0000001029487824ULL, 0x000fe200078e00ffULL, 0x000000002858783bULL, 0x000e620000000200ULL,
0x0000001084847824ULL, 0x100fe200078e02a7ULL, 0x00000db000007945ULL, 0x000fe20003800000ULL,
0x0000001082827824ULL, 0x100fe200078e02a7ULL, 0x000000008968783bULL, 0x000ea20000000200ULL,
0x00000010c6837824ULL, 0x000fc600078e02a7ULL, 0x000000008864783bULL, 0x000ee80000000200ULL,
0x00000000875c783bULL, 0x000f280000000200ULL, 0x000000008654783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000f280000000200ULL, 0x000000008450783bULL, 0x000f280000000200ULL,
0x00000000824c783bULL, 0x000f280000000200ULL, 0x000000008328783bULL, 0x000f220000000200ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000006c5860723cULL, 0x042f700000001860ULL,
0x00000068582c723cULL, 0x044f70000000182cULL, 0x000000645834723cULL, 0x048f700000001834ULL,
0x0000006e5844723cULL, 0x040f700000001844ULL, 0x0000006a5840723cULL, 0x040f700000001840ULL,
0x000000665838723cULL, 0x040f700000001838ULL, 0x0000005c583c723cULL, 0x050f70000000183cULL,
0x0000005e5830723cULL, 0x000f700000001830ULL, 0x000000544860723cULL, 0x060b700000001860ULL,
0x00000050482c723cULL, 0x040b70000000182cULL, 0x0000004c4834723cULL, 0x040b700000001834ULL,
0x000000564854723cULL, 0x040b700000001844ULL, 0x000000524850723cULL, 0x040b700000001840ULL,
0x0000004e484c723cULL, 0x040b700000001838ULL, 0x00000028483c723cULL, 0x040b70000000183cULL,
0x0000002a4848723cULL, 0x000b620000001830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000064000008947ULL, 0x000fca0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x000000a275297217ULL, 0x000fe20007800000ULL, 0x00000010c4b57824ULL, 0x100fe200078e02a7ULL,
0x0000000ca5317812ULL, 0x000fe200078efcffULL, 0x00000010c2b37824ULL, 0x100fe200078e02a7ULL,
0x000000a7bcad7211ULL, 0x000fe200078e20ffULL, 0x0000000129387824ULL, 0x000fe400078e0aa2ULL,
0x00000010c0b17824ULL, 0x100fe400078e02a7ULL, 0x00000010beaf7824ULL, 0x100fe200078e02a7ULL,
0x000000388100720cULL, 0x000fe20003f26070ULL, 0x00000010baab7824ULL, 0x000fc400078e02a7ULL,
0x00000010b8a97824ULL, 0x100fe400078e02a7ULL, 0x00000010b6a77824ULL, 0x000fe200078e02a7ULL,
0x0000009128287211ULL, 0x002fcc00078e10ffULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052b7224ULL, 0x002fc800078e02b4ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab57faeULL, 0x0003e2000c901c46ULL, 0x000000387f00720cULL, 0x000fc60003f26070ULL,
0x0146200092307984ULL, 0x000ea40000000800ULL, 0x0000000430307824ULL, 0x004fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b37faeULL, 0x0005e2000c901c46ULL,
0x000000388f00720cULL, 0x000fc60003f26070ULL, 0x0146400092327984ULL, 0x000ee40000000800ULL,
0x0000009132327211ULL, 0x008fcc00078e10ffULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02b0ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab17faeULL, 0x0003e2000c901c46ULL, 0x000000388e00720cULL, 0x000fc60003f26070ULL,
0x0146600092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028af7faeULL, 0x0005e2000c901c46ULL,
0x000000388d00720cULL, 0x000fc60003f26070ULL, 0x0146800092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02acULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aad7faeULL, 0x0003e2000c901c46ULL, 0x000000388c00720cULL, 0x000fc60003f26070ULL,
0x0146a00092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ab7faeULL, 0x0005e2000c901c46ULL,
0x000000388b00720cULL, 0x000fc60003f26070ULL, 0x0146c00092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02a8ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa97faeULL, 0x0003e2000c901c46ULL, 0x000000388a00720cULL, 0x000fc60003f26070ULL,
0x0146e00092307984ULL, 0x000ee40000000800ULL, 0x0000009130307211ULL, 0x008fcc00078e10ffULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a77faeULL, 0x0003e2000c901c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x0000000ca5397812ULL, 0x000fe200078efcffULL, 0x00000010c4b57824ULL, 0x100fe200078e02a7ULL,
0x000000a7c2b37211ULL, 0x080fe200078e20ffULL, 0x00000010c0b17824ULL, 0x100fe200078e02a7ULL,
0x000000a7b8a97211ULL, 0x000fe200078e20ffULL, 0x00000010beaf7824ULL, 0x100fe400078e02a7ULL,
0x00000010bcad7824ULL, 0x100fe400078e02a7ULL, 0x00000010baab7824ULL, 0x000fc400078e02a7ULL,
0x00000010b6a77824ULL, 0x000fe400078e02a7ULL, 0x0000000428287824ULL, 0x002fcc00078e0291ULL,
0x0000000028287984ULL, 0x000e640000000800ULL, 0x00000028052b7224ULL, 0x002fc800078e02b4ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010392a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab57faeULL, 0x0003e8000b901c46ULL,
0x0146200092307984ULL, 0x000ea40000000800ULL, 0x0000000430327824ULL, 0x004fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001039307825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b37faeULL, 0x0005e8000b901c46ULL,
0x0146400092287984ULL, 0x000ee40000000800ULL, 0x0000000428337824ULL, 0x008fcc00078e0291ULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305297224ULL, 0x008fc800078e02b0ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab17faeULL, 0x0003e8000b901c46ULL,
0x0146600092287984ULL, 0x000ee40000000800ULL, 0x0000000428327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ee40000000800ULL, 0x0000003205297224ULL, 0x008fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001039307825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030af7faeULL, 0x0005e8000b901c46ULL,
0x0146800092287984ULL, 0x000ee40000000800ULL, 0x0000009128337211ULL, 0x008fcc00078e10ffULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305297224ULL, 0x008fc800078e02acULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aad7faeULL, 0x0003e8000b901c46ULL,
0x0146a00092287984ULL, 0x000ee40000000800ULL, 0x0000000428327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ee40000000800ULL, 0x0000003205297224ULL, 0x008fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001039307825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030ab7faeULL, 0x0005e8000b901c46ULL,
0x0146c00092287984ULL, 0x000ee40000000800ULL, 0x0000000428337824ULL, 0x008fcc00078e0291ULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305297224ULL, 0x008fc800078e02a8ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa97faeULL, 0x0005e8000b901c46ULL,
0x0146e00092287984ULL, 0x000e640000000800ULL, 0x0000000428327824ULL, 0x002fcc00078e0291ULL,
0x0000000032327984ULL, 0x000e640000000800ULL, 0x0000003205297224ULL, 0x002fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001039287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a77faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000207e297824ULL, 0x006fe200078e00ffULL,
0x0000000880287810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe029287812ULL, 0x000fe200078ee228ULL, 0x00000000a36c783bULL, 0x000fe20000000200ULL,
0x0000000a80297810ULL, 0x000fe20007ffe0ffULL, 0x00000cf000007945ULL, 0x000fe20003800000ULL,
0x000000057e2a7819ULL, 0x000fe200000006ffULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x00000000a168783bULL, 0x000fe40000000200ULL, 0xffffffe02a297812ULL, 0x000fe400078ee229ULL,
0x000000002858783bULL, 0x000e660000000200ULL, 0x0000001029307824ULL, 0x000fe200078e00ffULL,
0x00000000a064783bULL, 0x000ea80000000200ULL, 0x000000009f5c783bULL, 0x000ee80000000200ULL,
0x000000009e44783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000f280000000200ULL,
0x000000009d40783bULL, 0x000ee80000000200ULL, 0x000000009c38783bULL, 0x000ee80000000200ULL,
0x000000008528783bULL, 0x000ee80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000006c5860723cULL, 0x042f700000001860ULL, 0x00000068582c723cULL, 0x040f70000000182cULL,
0x000000645834723cULL, 0x004f620000001834ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x0000006e5854723cULL, 0x040f700000001854ULL, 0x0000006a5850723cULL, 0x040f700000001850ULL,
0x00000066584c723cULL, 0x040f70000000184cULL, 0x0000005c583c723cULL, 0x048f70000000183cULL,
0x0000005e5848723cULL, 0x000f700000001848ULL, 0x000000443060723cULL, 0x070b700000001860ULL,
0x00000040302c723cULL, 0x040b70000000182cULL, 0x000000383034723cULL, 0x040b700000001834ULL,
0x000000463044723cULL, 0x040b700000001854ULL, 0x000000423040723cULL, 0x040b700000001850ULL,
0x0000003a3038723cULL, 0x040b70000000184cULL, 0x00000028303c723cULL, 0x040b70000000183cULL,
0x0000002a3030723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000005c000008947ULL, 0x000fca0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x000000a275297217ULL, 0x000fe40007800000ULL, 0x00000010a5497812ULL, 0x000fc600078efcffULL,
0x00000001294c7824ULL, 0x000fca00078e0aa2ULL, 0x0000004c8100720cULL, 0x000fe20003f26070ULL,
0x0000000428287824ULL, 0x002fcc00078e0291ULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052b7224ULL, 0x002fc800078e02b4ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a9b7faeULL, 0x0003e2000c901c46ULL, 0x0000004c7f00720cULL, 0x000fc60003f26070ULL,
0x0146200092487984ULL, 0x000ea40000000800ULL, 0x0000000448487824ULL, 0x004fcc00078e0291ULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000289a7faeULL, 0x0005e2000c901c46ULL,
0x0000004c8f00720cULL, 0x000fc60003f26070ULL, 0x01464000924a7984ULL, 0x000ee40000000800ULL,
0x000000914a4a7211ULL, 0x008fcc00078e10ffULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052b7224ULL, 0x002fc800078e02b0ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a997faeULL, 0x0003e2000c901c46ULL, 0x0000004c8e00720cULL, 0x000fc60003f26070ULL,
0x0146600092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028987faeULL, 0x0005e2000c901c46ULL,
0x0000004c8d00720cULL, 0x000fc60003f26070ULL, 0x01468000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052b7224ULL, 0x002fc800078e02acULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a977faeULL, 0x0003e2000c901c46ULL, 0x0000004c8c00720cULL, 0x000fc60003f26070ULL,
0x0146a00092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028967faeULL, 0x0005e2000c901c46ULL,
0x0000004c8b00720cULL, 0x000fc60003f26070ULL, 0x0146c000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052b7224ULL, 0x002fc800078e02a8ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a957faeULL, 0x0003e2000c901c46ULL, 0x0000004c8a00720cULL, 0x000fc60003f26070ULL,
0x0146e00092487984ULL, 0x000ee40000000800ULL, 0x0000009148487211ULL, 0x008fcc00078e10ffULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028947faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x00000010a54b7812ULL, 0x000fe200078efcffULL, 0x0000000428487824ULL, 0x002fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052b7224ULL, 0x002fc800078e02b4ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a9b7faeULL, 0x0003e8000b901c46ULL,
0x0146200092287984ULL, 0x000ea40000000800ULL, 0x0000000428497824ULL, 0x004fcc00078e0291ULL,
0x0000000049497984ULL, 0x000ea40000000800ULL, 0x0000004905297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000289a7faeULL, 0x0005e8000b901c46ULL,
0x0146400092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052b7224ULL, 0x002fc800078e02b0ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a997faeULL, 0x0003e8000b901c46ULL,
0x01466000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028987faeULL, 0x0005e8000b901c46ULL,
0x0146800092487984ULL, 0x000ee40000000800ULL, 0x0000009148487211ULL, 0x008fcc00078e10ffULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052b7224ULL, 0x002fc800078e02acULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a977faeULL, 0x0003e8000b901c46ULL,
0x0146a000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028967faeULL, 0x0005e8000b901c46ULL,
0x0146c00092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052b7224ULL, 0x002fc800078e02a8ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a957faeULL, 0x0003e8000b901c46ULL,
0x0146e000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028947faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000207e297824ULL, 0x002fe200078e00ffULL,
0x0000000c80287810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe029287812ULL, 0x000fe200078ee228ULL, 0x00000000936c783bULL, 0x000fe20000000200ULL,
0x000000207e2a7824ULL, 0x000fe200078e00ffULL, 0x0000000e80297810ULL, 0x000fe20007ffe0ffULL,
0x00000ce000007945ULL, 0x000fe20003800000ULL, 0x0000000428287819ULL, 0x000fe200000006ffULL,
0x000000008968783bULL, 0x000fe20000000200ULL, 0xffffffe02a297812ULL, 0x000fc600078ee229ULL,
0x000000002858783bULL, 0x000e640000000200ULL, 0x0000001029487824ULL, 0x000fe400078e00ffULL,
0x000000008864783bULL, 0x000ea80000000200ULL, 0x00000000875c783bULL, 0x000ee80000000200ULL,
0x000000008654783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000f280000000200ULL,
0x000000008450783bULL, 0x000ee80000000200ULL, 0x00000000824c783bULL, 0x000ee80000000200ULL,
0x000000008328783bULL, 0x000ee80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000006c5860723cULL, 0x042f700000001860ULL, 0x00000068582c723cULL, 0x040f70000000182cULL,
0x000000645834723cULL, 0x004f620000001834ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x0000006e5844723cULL, 0x040f700000001844ULL, 0x0000006a5840723cULL, 0x040f700000001840ULL,
0x000000665838723cULL, 0x040f700000001838ULL, 0x0000005c583c723cULL, 0x048f70000000183cULL,
0x0000005e5830723cULL, 0x000f700000001830ULL, 0x000000544860723cULL, 0x070b700000001860ULL,
0x00000050482c723cULL, 0x040b70000000182cULL, 0x0000004c4834723cULL, 0x040b700000001834ULL,
0x000000564854723cULL, 0x040b700000001844ULL, 0x000000524850723cULL, 0x040b700000001840ULL,
0x0000004e484c723cULL, 0x040b700000001838ULL, 0x00000028483c723cULL, 0x040b70000000183cULL,
0x0000002a4848723cULL, 0x000b620000001830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000005c000008947ULL, 0x000fca0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x000000a275297217ULL, 0x000fe40007800000ULL, 0x00000014a5317812ULL, 0x000fc600078efcffULL,
0x0000000129387824ULL, 0x000fca00078e0aa2ULL, 0x000000388100720cULL, 0x000fe20003f26070ULL,
0x0000000428287824ULL, 0x002fcc00078e0291ULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052b7224ULL, 0x002fc800078e02b4ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab57faeULL, 0x0003e2000c901c46ULL, 0x000000387f00720cULL, 0x000fc60003f26070ULL,
0x0146200092307984ULL, 0x000ea40000000800ULL, 0x0000009130307211ULL, 0x004fcc00078e10ffULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b37faeULL, 0x0005e2000c901c46ULL,
0x000000388f00720cULL, 0x000fc60003f26070ULL, 0x0146400092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02b0ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab17faeULL, 0x0003e2000c901c46ULL, 0x000000388e00720cULL, 0x000fc60003f26070ULL,
0x0146600092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028af7faeULL, 0x0005e2000c901c46ULL,
0x000000388d00720cULL, 0x000fc60003f26070ULL, 0x0146800092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02acULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aad7faeULL, 0x0003e2000c901c46ULL, 0x000000388c00720cULL, 0x000fc60003f26070ULL,
0x0146a00092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ab7faeULL, 0x0005e2000c901c46ULL,
0x000000388b00720cULL, 0x000fc60003f26070ULL, 0x0146c00092327984ULL, 0x000ee40000000800ULL,
0x0000009132327211ULL, 0x008fcc00078e10ffULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02a8ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa97faeULL, 0x0003e2000c901c46ULL, 0x000000388a00720cULL, 0x000fc60003f26070ULL,
0x0146e00092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a77faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x00000014a5337812ULL, 0x000fe200078efcffULL, 0x0000000428307824ULL, 0x002fcc00078e0291ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052b7224ULL, 0x002fc800078e02b4ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab57faeULL, 0x0003e8000b901c46ULL,
0x0146200092287984ULL, 0x000ea40000000800ULL, 0x0000000428317824ULL, 0x004fcc00078e0291ULL,
0x0000000031317984ULL, 0x000ea40000000800ULL, 0x0000003105297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b37faeULL, 0x0005e8000b901c46ULL,
0x0146400092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052b7224ULL, 0x002fc800078e02b0ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab17faeULL, 0x0003e8000b901c46ULL,
0x0146600092327984ULL, 0x000ee40000000800ULL, 0x0000009132327211ULL, 0x008fcc00078e10ffULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028af7faeULL, 0x0005e8000b901c46ULL,
0x0146800092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052b7224ULL, 0x002fc800078e02acULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aad7faeULL, 0x0003e8000b901c46ULL,
0x0146a00092327984ULL, 0x000ee40000000800ULL, 0x0000000432327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ab7faeULL, 0x0005e8000b901c46ULL,
0x0146c00092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052b7224ULL, 0x002fc800078e02a8ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa97faeULL, 0x0003e8000b901c46ULL,
0x0146e00092327984ULL, 0x000ee40000000800ULL, 0x0000000432327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a77faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001080287810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000057e297819ULL, 0x000fe200000006ffULL,
0x00000000a36c783bULL, 0x000fe20000000200ULL, 0x00000d0000007945ULL, 0x000fe40003800000ULL,
0xffffffe029287812ULL, 0x000fe200078ee228ULL, 0x00000000a168783bULL, 0x000fe80000000200ULL,
0x0000001028587824ULL, 0x000fe200078e00ffULL, 0x00000000a064783bULL, 0x000fe20000000200ULL,
0x0000001280287810ULL, 0x000fc60007ffe0ffULL, 0x000000009f5c783bULL, 0x000fe20000000200ULL,
0xffffffe029287812ULL, 0x000fc600078ee228ULL, 0x000000005858783bULL, 0x000e640000000200ULL,
0x0000001028407824ULL, 0x000fe400078e00ffULL, 0x000000009e28783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000ea80000000200ULL, 0x000000009d30783bULL, 0x000ee80000000200ULL,
0x000000009c38783bULL, 0x000f280000000200ULL, 0x000000008544783bULL, 0x000ea80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000006c5860723cULL, 0x042f700000001860ULL,
0x00000068582c723cULL, 0x000f62000000182cULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x000000645834723cULL, 0x040f700000001834ULL, 0x0000006e5854723cULL, 0x040f700000001854ULL,
0x0000006a5850723cULL, 0x040f700000001850ULL, 0x00000066584c723cULL, 0x040f70000000184cULL,
0x0000005c583c723cULL, 0x040f70000000183cULL, 0x0000005e5848723cULL, 0x000f700000001848ULL,
0x000000284060723cULL, 0x064b700000001860ULL, 0x00000030402c723cULL, 0x048b70000000182cULL,
0x000000384034723cULL, 0x050b700000001834ULL, 0x0000002a4028723cULL, 0x040b700000001854ULL,
0x000000324030723cULL, 0x040b700000001850ULL, 0x0000003a4038723cULL, 0x040b70000000184cULL,
0x00000044403c723cULL, 0x040b70000000183cULL, 0x000000464040723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000005c000008947ULL, 0x000fca0003800000ULL,
0x0146000092447984ULL, 0x020e620000000800ULL, 0x000000a275457217ULL, 0x000fe40007800000ULL,
0x00000018a5497812ULL, 0x000fc600078efcffULL, 0x00000001454c7824ULL, 0x000fca00078e0aa2ULL,
0x0000004c8100720cULL, 0x000fe20003f26070ULL, 0x0000000444447824ULL, 0x002fcc00078e0291ULL,
0x0000000044447984ULL, 0x000e640000000800ULL, 0x0000004405477224ULL, 0x002fc800078e02b4ULL,
0x00005e0047467625ULL, 0x000fcc00078e0090ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000469b7faeULL, 0x0003e2000c901c46ULL,
0x0000004c7f00720cULL, 0x000fc60003f26070ULL, 0x0146200092487984ULL, 0x000ea40000000800ULL,
0x0000009148487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805457224ULL, 0x004fc800078e02b2ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449a7faeULL, 0x0005e2000c901c46ULL, 0x0000004c8f00720cULL, 0x000fc60003f26070ULL,
0x01464000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05477224ULL, 0x002fc800078e02b0ULL,
0x00005e0047467625ULL, 0x000fcc00078e0090ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046997faeULL, 0x0003e2000c901c46ULL,
0x0000004c8e00720cULL, 0x000fc60003f26070ULL, 0x0146600092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805457224ULL, 0x004fc800078e02aeULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044987faeULL, 0x0005e2000c901c46ULL, 0x0000004c8d00720cULL, 0x000fc60003f26070ULL,
0x01468000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05477224ULL, 0x002fc800078e02acULL,
0x00005e0047467625ULL, 0x000fcc00078e0090ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046977faeULL, 0x0003e2000c901c46ULL,
0x0000004c8c00720cULL, 0x000fc60003f26070ULL, 0x0146a00092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805457224ULL, 0x004fc800078e02aaULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044967faeULL, 0x0005e2000c901c46ULL, 0x0000004c8b00720cULL, 0x000fc60003f26070ULL,
0x0146c000924a7984ULL, 0x000ee40000000800ULL, 0x000000914a4a7211ULL, 0x008fcc00078e10ffULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05477224ULL, 0x002fc800078e02a8ULL,
0x00005e0047467625ULL, 0x000fcc00078e0090ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046957faeULL, 0x0003e2000c901c46ULL,
0x0000004c8a00720cULL, 0x000fc60003f26070ULL, 0x0146e00092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805457224ULL, 0x004fc800078e02a6ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044947faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0146000092447984ULL, 0x020e620000000800ULL, 0x00000018a54b7812ULL, 0x000fe200078efcffULL,
0x0000000444487824ULL, 0x002fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805477224ULL, 0x002fc800078e02b4ULL, 0x00005e0047467625ULL, 0x000fcc00078e0090ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000469b7faeULL, 0x0003e8000b901c46ULL, 0x0146200092447984ULL, 0x000ea40000000800ULL,
0x0000000444497824ULL, 0x004fcc00078e0291ULL, 0x0000000049497984ULL, 0x000ea40000000800ULL,
0x0000004905457224ULL, 0x004fc800078e02b2ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449a7faeULL, 0x0005e8000b901c46ULL, 0x0146400092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805477224ULL, 0x002fc800078e02b0ULL, 0x00005e0047467625ULL, 0x000fcc00078e0090ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046997faeULL, 0x0003e8000b901c46ULL, 0x01466000924a7984ULL, 0x000ee40000000800ULL,
0x000000914a4a7211ULL, 0x008fcc00078e10ffULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05457224ULL, 0x004fc800078e02aeULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044987faeULL, 0x0005e8000b901c46ULL, 0x0146800092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805477224ULL, 0x002fc800078e02acULL, 0x00005e0047467625ULL, 0x000fcc00078e0090ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046977faeULL, 0x0003e8000b901c46ULL, 0x0146a000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05457224ULL, 0x004fc800078e02aaULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044967faeULL, 0x0005e8000b901c46ULL, 0x0146c00092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805477224ULL, 0x002fc800078e02a8ULL, 0x00005e0047467625ULL, 0x000fcc00078e0090ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046957faeULL, 0x0003e8000b901c46ULL, 0x0146e000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05457224ULL, 0x004fc800078e02a6ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044947faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001480447810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000057e457819ULL, 0x040fe200000006ffULL, 0x00000000894c783bULL, 0x000fe20000000200ULL,
0x000000207e597824ULL, 0x000fe200078e00ffULL, 0x0000001680587810ULL, 0x000fe20007ffe0ffULL,
0x00000d1000007945ULL, 0x000fe20003800000ULL, 0xffffffe045447812ULL, 0x000fe200078ee244ULL,
0x000000008850783bULL, 0x000fe20000000200ULL, 0xffffffe059587812ULL, 0x000fc600078ee258ULL,
0x0000001044487824ULL, 0x000fe200078e00ffULL, 0x000000008754783bULL, 0x000fe20000000200ULL,
0x00000010585c7824ULL, 0x000fc600078e00ffULL, 0x000000009344783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x000000008658783bULL, 0x000fe80000000200ULL,
0x000000005c5c783bULL, 0x000ea80000000200ULL, 0x00000000846c783bULL, 0x000ee80000000200ULL,
0x000000008268783bULL, 0x000f280000000200ULL, 0x000000008364783bULL, 0x000ea80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000444860723cULL, 0x042f700000001860ULL,
0x000000464828723cULL, 0x000f620000001828ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x0000004c482c723cULL, 0x040f70000000182cULL, 0x0000004e4830723cULL, 0x040f700000001830ULL,
0x000000504834723cULL, 0x040f700000001834ULL, 0x000000524838723cULL, 0x040f700000001838ULL,
0x00000054483c723cULL, 0x040f70000000183cULL, 0x000000564840723cULL, 0x000f700000001840ULL,
0x000000585c60723cULL, 0x064f700000001860ULL, 0x0000005a5c28723cULL, 0x040f700000001828ULL,
0x0000006c5c2c723cULL, 0x048f70000000182cULL, 0x0000006e5c30723cULL, 0x040f700000001830ULL,
0x000000685c34723cULL, 0x050f700000001834ULL, 0x0000006a5c38723cULL, 0x040f700000001838ULL,
0x000000645c3c723cULL, 0x040f70000000183cULL, 0x000000665c5c723cULL, 0x000b6e0000001840ULL,
0x0000000370427812ULL, 0x020fc800078ec0ffULL, 0x000000ff42427207ULL, 0x000fe20005000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000005c000008947ULL, 0x000fea0003800000ULL,
0x0146000092407984ULL, 0x000e620000000800ULL, 0x000000a275417217ULL, 0x000fe40007800000ULL,
0x0000001ca5a57812ULL, 0x000fe400078efcffULL, 0x00000041a2a27210ULL, 0x000fc80007ffe1ffULL,
0x000000a28100720cULL, 0x000fe20003f06070ULL, 0x0000000440437824ULL, 0x002fcc00078e0291ULL,
0x0000000043437984ULL, 0x000e640000000800ULL, 0x0000004305417224ULL, 0x002fc800078e02b4ULL,
0x00005e0041407625ULL, 0x000fcc00078e0090ULL, 0x00000010a5407825ULL, 0x000fca00078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040b57faeULL, 0x0003e2000c101c46ULL,
0x000000a27f00720cULL, 0x000fc60003f06070ULL, 0x0146200092447984ULL, 0x000ea40000000800ULL,
0x0000000444467824ULL, 0x004fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02b2ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044b37faeULL, 0x0005e2000c101c46ULL, 0x000000a28f00720cULL, 0x000fc60003f06070ULL,
0x0146400092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805417224ULL, 0x002fc800078e02b0ULL,
0x00005e0041407625ULL, 0x000fcc00078e0090ULL, 0x00000010a5407825ULL, 0x000fca00078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040b17faeULL, 0x0003e2000c101c46ULL,
0x000000a28e00720cULL, 0x000fc60003f06070ULL, 0x0146600092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02aeULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044af7faeULL, 0x0005e2000c101c46ULL, 0x000000a28d00720cULL, 0x000fc60003f06070ULL,
0x0146800092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805417224ULL, 0x002fc800078e02acULL,
0x00005e0041407625ULL, 0x000fcc00078e0090ULL, 0x00000010a5407825ULL, 0x000fca00078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040ad7faeULL, 0x0003e2000c101c46ULL,
0x000000a28c00720cULL, 0x000fc60003f06070ULL, 0x0146a00092467984ULL, 0x000ee40000000800ULL,
0x0000009146467211ULL, 0x008fcc00078e10ffULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02aaULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044ab7faeULL, 0x0005e2000c101c46ULL, 0x000000a28b00720cULL, 0x000fc60003f06070ULL,
0x0146c00092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805417224ULL, 0x002fc800078e02a8ULL,
0x00005e0041407625ULL, 0x000fcc00078e0090ULL, 0x00000010a5407825ULL, 0x000fca00078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040a97faeULL, 0x0003e2000c101c46ULL,
0x000000a28a00720cULL, 0x000fc60003f06070ULL, 0x0146e00092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02a6ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a77faeULL, 0x0003e2000c101c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0146000092407984ULL, 0x000e620000000800ULL, 0x0000001ca5a57812ULL, 0x000fe200078efcffULL,
0x0000000440437824ULL, 0x002fcc00078e0291ULL, 0x0000000043437984ULL, 0x000e640000000800ULL,
0x0000004305417224ULL, 0x002fc800078e02b4ULL, 0x00005e0041407625ULL, 0x000fcc00078e0090ULL,
0x00000010a5407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040b57faeULL, 0x0003e8000b901c46ULL, 0x0146200092447984ULL, 0x000ea40000000800ULL,
0x0000000444467824ULL, 0x004fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02b2ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044b37faeULL, 0x0005e8000b901c46ULL, 0x0146400092487984ULL, 0x000ee40000000800ULL,
0x0000009148487211ULL, 0x008fcc00078e10ffULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805417224ULL, 0x002fc800078e02b0ULL, 0x00005e0041407625ULL, 0x000fcc00078e0090ULL,
0x00000010a5407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040b17faeULL, 0x0003e8000b901c46ULL, 0x0146600092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02aeULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044af7faeULL, 0x0005e8000b901c46ULL, 0x0146800092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805417224ULL, 0x002fc800078e02acULL, 0x00005e0041407625ULL, 0x000fcc00078e0090ULL,
0x00000010a5407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040ad7faeULL, 0x0003e8000b901c46ULL, 0x0146a00092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02aaULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044ab7faeULL, 0x0005e8000b901c46ULL, 0x0146c00092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805417224ULL, 0x002fc800078e02a8ULL, 0x00005e0041407625ULL, 0x000fcc00078e0090ULL,
0x00000010a5407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040a97faeULL, 0x0003e8000b901c46ULL, 0x0146e00092467984ULL, 0x000ee40000000800ULL,
0x0000009146467211ULL, 0x008fcc00078e10ffULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02a6ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a77faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000142407810ULL, 0x002fe20007ffe0ffULL, 0x000000207e467824ULL, 0x000fe200078e00ffULL,
0x000000a47300720cULL, 0x000fe20003f04070ULL, 0x0000000407a57824ULL, 0x000fe200078e00ffULL,
0x00000002ff417819ULL, 0x000fe20000011640ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000141417807ULL, 0x000fe20004000000ULL, 0x0000028000007945ULL, 0x000fe20003800000ULL,
0x0000000340407812ULL, 0x000fe400078ec0ffULL, 0x000000a47300720cULL, 0x000fe20003f24070ULL,
0x0000030041447a24ULL, 0x000fe200078e02a4ULL, 0x000000ff40407207ULL, 0x000fe40004000000ULL,
0x000000034200780cULL, 0x000fe20003f85270ULL, 0x0000010044447824ULL, 0x000fe200078e027dULL,
0x0000002007457810ULL, 0x000fe20007ffe0ffULL, 0x0000000177417824ULL, 0x000fe200078e0240ULL,
0x0000001880437810ULL, 0x000fe20007ffe0ffULL, 0x0000000144427824ULL, 0x000fe200078e0207ULL,
0x0000000400477802ULL, 0x000fe20000000f00ULL, 0x0000680041407a24ULL, 0x000fe200078e0244ULL,
0xffffffe046437812ULL, 0x000fc400078ee243ULL, 0x000000754200720cULL, 0x000fe20003f06070ULL,
0x0000000145427824ULL, 0x040fe200078e0244ULL, 0x000000a57c497210ULL, 0x000fe20007ffe0ffULL,
0x0000000140447824ULL, 0x000fe400078e0207ULL, 0x0000000145467824ULL, 0x000fe200078e0240ULL,
0x000000754200720cULL, 0x000fe20003f66070ULL, 0x0000660044447625ULL, 0x000fc800078e0047ULL,
0x0000001043547824ULL, 0x000fe400078e00ffULL, 0x0000660046467625ULL, 0x000fe200078e0047ULL,
0x0000010000009947ULL, 0x000fea0002000000ULL, 0x000000030700780cULL, 0x000fe20003f24070ULL,
0x00000300ff407624ULL, 0x000fc800078e00ffULL, 0x00000002407b7824ULL, 0x000fd000078e027bULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0000000400407824ULL, 0x100fe200078e0207ULL,
0x000000767b00720cULL, 0x000fe20003f26070ULL, 0x0000000478427824ULL, 0x000fe400078e0207ULL,
0x00000004ff417424ULL, 0x000fe200078e00ffULL, 0x0000000140407819ULL, 0x000fe400000006ffULL,
0x00014a8042437811ULL, 0x000fc600078e10ffULL, 0x0000640040407a24ULL, 0x000fc800078e027bULL,
0x0000600040407625ULL, 0x000fca00078e0041ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040437faeULL, 0x0003e4000c921846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1460000044497faeULL, 0x0005e2000c121846ULL,
0x000000207e4b7824ULL, 0x000fe200078e00ffULL, 0x0000001a80487810ULL, 0x000fe20007ffe0ffULL,
0x00000fa000007945ULL, 0x000fe20003800000ULL, 0x1468000046497faeULL, 0x0005e4000d921846ULL,
0xffffffe04b487812ULL, 0x000fe400078ee248ULL, 0x000000005454783bULL, 0x000fe60000000200ULL,
0x00000010486c7824ULL, 0x000fe200078e00ffULL, 0x00000000a140783bULL, 0x002e680000000200ULL,
0x00000000a064783bULL, 0x000ee80000000200ULL, 0x000000009f58783bULL, 0x000f280000000200ULL,
0x000000006c44783bULL, 0x004fe80000000200ULL, 0x000000009c48783bULL, 0x0004e80000000200ULL,
0x00000000a368783bULL, 0x000f280000000200ULL, 0x000000009e50783bULL, 0x000fe20000000200ULL,
0x00000001709c7810ULL, 0x004fc60007ffe0ffULL, 0x000000009d4c783bULL, 0x000fe80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000040542c723cULL, 0x042ff0000000182cULL,
0x000000425430723cULL, 0x040be40000001830ULL, 0x000000008540783bULL, 0x020e6c0000000200ULL,
0x000000645434723cULL, 0x008f620000001834ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x00000058543c723cULL, 0x050f70000000183cULL, 0x0000005a545c723cULL, 0x000f70000000185cULL,
0x000000484434723cULL, 0x020bee0000001834ULL, 0x00000002ff497819ULL, 0x020fe2000001169cULL,
0x000000685460723cULL, 0x000f660000001860ULL, 0x000000499c497207ULL, 0x000fca0001000000ULL,
0x0000006a5428723cULL, 0x040f700000001828ULL, 0x000000665438723cULL, 0x000f700000001838ULL,
0x00000040443c723cULL, 0x042b6e000000183cULL, 0x0000030049407a24ULL, 0x020fe200078e027aULL,
0x00000042445c723cULL, 0x000b68000000185cULL, 0x0000007d40487211ULL, 0x000fc600078e40ffULL,
0x0000000140437810ULL, 0x020fe20007ffe0ffULL, 0x000000504460723cULL, 0x000b620000001860ULL,
0x0000004048417812ULL, 0x000fe400078ec0ffULL, 0x000000744300720cULL, 0x000fc60003f06070ULL,
0x0000000106407824ULL, 0x000fe400078e0241ULL, 0x000000524428723cULL, 0x040b700000001828ULL,
0x0000004c442c723cULL, 0x040b70000000182cULL, 0x0000004e4430723cULL, 0x040b700000001830ULL,
0x0000004a4438723cULL, 0x000b620000001838ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000006d000008947ULL, 0x000fca0003800000ULL, 0x0146000092427984ULL, 0x020e620000000800ULL,
0x0000004875417217ULL, 0x000fe20007800000ULL, 0x0000001007447824ULL, 0x000fc600078e00ffULL,
0x0000004148487210ULL, 0x000fe40007ffe1ffULL, 0x00000030444b7812ULL, 0x000fe400078ec0ffULL,
0x000000488100720cULL, 0x040fe20003f06070ULL, 0x0000000442467824ULL, 0x002fe400078e0291ULL,
0x0000000181427824ULL, 0x000fc800078e0240ULL, 0x0000000046467984ULL, 0x000e640000000800ULL,
0x0000004605437224ULL, 0x002fc800078e0242ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004b42447210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff457224ULL, 0x000fe400008e0643ULL,
0x000000017f437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449b7faeULL, 0x0003e2000c101c46ULL, 0x000000487f00720cULL, 0x000fc60003f06070ULL,
0x0146200092427984ULL, 0x000ea40000000800ULL, 0x0000000442417824ULL, 0x004fca00078e0291ULL,
0x0000000041427984ULL, 0x0004e40000000800ULL, 0x000000018f417824ULL, 0x004fe400078e0240ULL,
0x0000004205437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004b42467210ULL, 0x000fc80007f3e0ffULL, 0x00000043ff477210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000469a7faeULL, 0x0005e2000c101c46ULL,
0x000000488f00720cULL, 0x000fc60003f06070ULL, 0x0146400092427984ULL, 0x000ee40000000800ULL,
0x0000000442497824ULL, 0x008fca00078e0291ULL, 0x0000000049427984ULL, 0x000ee40000000800ULL,
0x0000004205417224ULL, 0x008fc800078e0241ULL, 0x00005e0041427625ULL, 0x000fca00078e0090ULL,
0x0000004b42447210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff457224ULL, 0x000fe400008e0643ULL,
0x000000018e437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044997faeULL, 0x0003e2000c101c46ULL, 0x000000488e00720cULL, 0x000fc60003f06070ULL,
0x0146600092427984ULL, 0x000ee40000000800ULL, 0x0000009142417211ULL, 0x008fca00078e10ffULL,
0x0000000041427984ULL, 0x0007240000000800ULL, 0x000000408d417210ULL, 0x008fe20007ffe0ffULL,
0x0000004205437224ULL, 0x010fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004b42467210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff477224ULL, 0x000fca00008e0643ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046987faeULL, 0x0005e2000c101c46ULL,
0x000000488d00720cULL, 0x000fc60003f06070ULL, 0x0146800092427984ULL, 0x000ee40000000800ULL,
0x0000000442497824ULL, 0x008fca00078e0291ULL, 0x0000000049427984ULL, 0x000ee40000000800ULL,
0x0000004205417224ULL, 0x008fc800078e0241ULL, 0x00005e0041427625ULL, 0x000fca00078e0090ULL,
0x0000004b42447210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff457224ULL, 0x000fe400008e0643ULL,
0x000000018c437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044977faeULL, 0x0003e2000c101c46ULL, 0x000000488c00720cULL, 0x000fc60003f06070ULL,
0x0146a00092427984ULL, 0x000ee40000000800ULL, 0x0000000442417824ULL, 0x008fca00078e0291ULL,
0x0000000041427984ULL, 0x0007240000000800ULL, 0x000000018b417824ULL, 0x108fe400078e0240ULL,
0x000000018a407824ULL, 0x000fe400078e0240ULL, 0x0000004205437224ULL, 0x010fc800078e0243ULL,
0x00005e0043427625ULL, 0x000fca00078e0090ULL, 0x0000004b42467210ULL, 0x004fc80007f3e0ffULL,
0x00000043ff477210ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046967faeULL, 0x0005e2000c101c46ULL, 0x000000488b00720cULL, 0x000fc60003f06070ULL,
0x0146c00092427984ULL, 0x000e640000000800ULL, 0x0000000442447824ULL, 0x002fcc00078e0291ULL,
0x0000000044447984ULL, 0x000e640000000800ULL, 0x0000004405417224ULL, 0x002fc800078e0241ULL,
0x00005e0041427625ULL, 0x000fca00078e0090ULL, 0x0000004b42427210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff437224ULL, 0x000fca00008e0643ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042957faeULL, 0x0003e2000c101c46ULL, 0x000000488a00720cULL, 0x000fc60003f06070ULL,
0x0146e00092467984ULL, 0x004ea40000000800ULL, 0x0000009146467211ULL, 0x004fcc00078e10ffULL,
0x0000000046467984ULL, 0x000ea40000000800ULL, 0x0000004605917224ULL, 0x004fc800078e0240ULL,
0x00005e0091907625ULL, 0x000fca00078e0090ULL, 0x0000004b90407210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff417224ULL, 0x000fca00008e0691ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040947faeULL, 0x0003e2000c101c46ULL, 0x0000062000007947ULL, 0x000fea0003800000ULL,
0x0146000092427984ULL, 0x020e620000000800ULL, 0x0000004081437210ULL, 0x000fe20007ffe0ffULL,
0x0000001007447824ULL, 0x000fca00078e00ffULL, 0x0000003044497812ULL, 0x000fe200078ec0ffULL,
0x0000000442417824ULL, 0x002fca00078e0291ULL, 0x0000000041427984ULL, 0x000e640000000800ULL,
0x0000004205437224ULL, 0x002fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942447210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e0643ULL,
0x000000407f437210ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449b7faeULL, 0x0003e8000b901c46ULL, 0x0146200092427984ULL, 0x000ea40000000800ULL,
0x0000000442487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805437224ULL, 0x004fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942467210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fe400000e0643ULL,
0x000000018f437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000469a7faeULL, 0x0005e8000b901c46ULL, 0x0146400092427984ULL, 0x000ee40000000800ULL,
0x0000000442417824ULL, 0x008fca00078e0291ULL, 0x0000000041427984ULL, 0x000ee40000000800ULL,
0x0000004205437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942447210ULL, 0x002fc80007f1e0ffULL, 0x00000043ff457210ULL, 0x000fe200007fe4ffULL,
0x000000018e437824ULL, 0x000fc800078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044997faeULL, 0x0003e8000b901c46ULL, 0x0146600092427984ULL, 0x000ee40000000800ULL,
0x0000000442487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ee40000000800ULL,
0x0000004805437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942467210ULL, 0x004fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fe400000e0643ULL,
0x000000018d437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046987faeULL, 0x0005e8000b901c46ULL, 0x0146800092427984ULL, 0x000ee40000000800ULL,
0x0000009142417211ULL, 0x008fca00078e10ffULL, 0x0000000041427984ULL, 0x000ee40000000800ULL,
0x0000004205437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942447210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e0643ULL,
0x000000408c437210ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044977faeULL, 0x0003e8000b901c46ULL, 0x0146a00092427984ULL, 0x000ee40000000800ULL,
0x0000000442487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ee40000000800ULL,
0x0000004805437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942467210ULL, 0x004fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fe400000e0643ULL,
0x000000018b437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046967faeULL, 0x0005e8000b901c46ULL, 0x0146c00092427984ULL, 0x000ee40000000800ULL,
0x0000000442417824ULL, 0x008fca00078e0291ULL, 0x0000000041427984ULL, 0x000ee40000000800ULL,
0x0000004205437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942427210ULL, 0x000fc80007f1e0ffULL, 0x00000043ff437210ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042957faeULL, 0x0005e8000b901c46ULL,
0x0146e00092447984ULL, 0x002e640000000800ULL, 0x0000000444447824ULL, 0x002fe400078e0291ULL,
0x000000018a917824ULL, 0x000fc800078e0240ULL, 0x0000000044447984ULL, 0x000e640000000800ULL,
0x0000004405917224ULL, 0x002fc800078e0291ULL, 0x00005e0091907625ULL, 0x000fca00078e0090ULL,
0x0000004990407210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff417224ULL, 0x000fca00000e0691ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040947faeULL, 0x0005e6000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001c80407810ULL, 0x006fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000057e417819ULL, 0x000fe200000006ffULL,
0x000000009358783bULL, 0x000fe20000000200ULL, 0x0000001e80807810ULL, 0x000fe40007ffe0ffULL,
0xffffffe041407812ULL, 0x040fe200078ee240ULL, 0x00000000896c783bULL, 0x000fe20000000200ULL,
0xffffffe041807812ULL, 0x000fe400078ee280ULL, 0x000000708100720cULL, 0x040fe20003f06070ULL,
0x0000001040547824ULL, 0x000fe200078e00ffULL, 0x000000008868783bULL, 0x000fe20000000200ULL,
0x0000001080407824ULL, 0x000fe200078e00ffULL, 0x0000009c8100720cULL, 0x000fc40004706470ULL,
0x000000008764783bULL, 0x000fe20000000200ULL, 0x000000707f00720cULL, 0x000fe20003f26070ULL,
0x000000ffff707224ULL, 0x000fe200078e009cULL, 0x0000007a7300720cULL, 0x000fe20000703070ULL,
0x000000005454783bULL, 0x000e620000000200ULL, 0x0000009c7f00720cULL, 0x000fc60000f21070ULL,
0x000000008644783bULL, 0x000fe20000000200ULL, 0x0000007a7300720cULL, 0x000fc60000f24470ULL,
0x000000004040783bULL, 0x000ea80000000200ULL, 0x000000008450783bULL, 0x000ee80000000200ULL,
0x00000000824c783bULL, 0x000f280000000200ULL, 0x000000008348783bULL, 0x000ea80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000005a5428723cULL, 0x042f700000001828ULL,
0x0000006c542c723cULL, 0x040f70000000182cULL, 0x000000685434723cULL, 0x040f700000001834ULL,
0x0000006a5438723cULL, 0x040f700000001838ULL, 0x00000064543c723cULL, 0x040ff0000000183cULL,
0x00000066545c723cULL, 0x040ff0000000185cULL, 0x0000006e5430723cULL, 0x040ff00000001830ULL,
0x000000585460723cULL, 0x000ff00000001860ULL, 0x000000464028723cULL, 0x064f700000001828ULL,
0x00000050402c723cULL, 0x048f70000000182cULL, 0x0000004c4034723cULL, 0x050f700000001834ULL,
0x0000004e4038723cULL, 0x000f640000001838ULL, 0x000000ffff128224ULL, 0x020fe200078e0029ULL,
0x0000002800138202ULL, 0x000fc40000000f00ULL, 0x000000222b227208ULL, 0x000fe40000800000ULL,
0x000000232a237208ULL, 0x000fe20000800000ULL, 0x00000048403c723cULL, 0x000f62000000183cULL,
0x000000ffff108224ULL, 0x000fe200078e002dULL, 0x000000202f207208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e002cULL, 0x000000212e217208ULL, 0x000fc80000800000ULL,
0x0000004a405c723cULL, 0x000f62000000185cULL, 0x000000ffff0c8224ULL, 0x000fe200078e0035ULL,
0x0000001c371c7208ULL, 0x000fe20000800000ULL, 0x000000ffff0d8224ULL, 0x000fe200078e0034ULL,
0x0000001d361d7208ULL, 0x000fc80000800000ULL, 0x000000524030723cULL, 0x040f620000001830ULL,
0x000000ffff0a8224ULL, 0x000fe200078e0039ULL, 0x00000038000b8202ULL, 0x000fe40000000f00ULL,
0x0000001a3b1a7208ULL, 0x000fe40000800000ULL, 0x0000001b3a1b7208ULL, 0x000fe40000800000ULL,
0x000000444060723cULL, 0x000f640000001860ULL, 0x000000ffff088224ULL, 0x020fe200078e003dULL,
0x000000183f187208ULL, 0x000fe20000800000ULL, 0x000000ffff098224ULL, 0x000fe200078e003cULL,
0x000000193e197208ULL, 0x000fc60000800000ULL, 0x000000ffff278224ULL, 0x000fe200078e005dULL,
0x0000005c00268202ULL, 0x000fe40000000f00ULL, 0x000000165f167208ULL, 0x000fe40000800000ULL,
0x000000175e177208ULL, 0x000fc60000800000ULL, 0x000000ffff0e8224ULL, 0x000fe200078e0031ULL,
0x00000030000f8202ULL, 0x000fe40000000f00ULL, 0x0000001e331e7208ULL, 0x000fe40000800000ULL,
0x0000001f321f7208ULL, 0x000fc60000800000ULL, 0x000000ffff148224ULL, 0x000fe200078e0061ULL,
0x0000002463247208ULL, 0x000fe20000800000ULL, 0x000000ffff158224ULL, 0x000fe200078e0060ULL,
0x000000039c00720cULL, 0x000fe40003f06070ULL, 0x0000002562257208ULL, 0x000fd60000800000ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff7be000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000072287f8cULL, 0x000e62000c80043fULL,
0x3d80000012127820ULL, 0x000fe20000410000ULL, 0x3d8000000d2a7820ULL, 0x000fe20000410000ULL,
0x3d800000082f7820ULL, 0x000fe20000410000ULL, 0x3d80000015157820ULL, 0x000fe20000410000ULL,
0x3d80000014147820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fe20000410000ULL,
0x3d80000011117820ULL, 0x000fe20000410000ULL, 0x3d8000000c2b7820ULL, 0x000fe20000410000ULL,
0x3d800000092e7820ULL, 0x000fe20000410000ULL, 0x3d80000027087820ULL, 0x000fe20000410000ULL,
0x3d80000025257820ULL, 0x000fe20000410000ULL, 0x3d80000021217820ULL, 0x000fe20000410000ULL,
0x3d8000001d1d7820ULL, 0x000fe20000410000ULL, 0x3d80000010037820ULL, 0x000fe20000410000ULL,
0x3d80000024247820ULL, 0x000fe20000410000ULL, 0x3d80000023237820ULL, 0x000fe20000410000ULL,
0x3d80000022227820ULL, 0x000fe20000410000ULL, 0x3d80000020207820ULL, 0x000fe20000410000ULL,
0x3d8000001f1f7820ULL, 0x000fe20000410000ULL, 0x3d8000001e1e7820ULL, 0x000fe20000410000ULL,
0x3d8000001c1c7820ULL, 0x000fe20000410000ULL, 0x3d8000001b097820ULL, 0x000fe20000410000ULL,
0x3d80000026337820ULL, 0x000fe20000410000ULL, 0x0000002900307202ULL, 0x002fe20000000f00ULL,
0x3d8000000f287820ULL, 0x000fe20000410000ULL, 0x3d8000000e297820ULL, 0x000fe20000410000ULL,
0x3d8000001a347820ULL, 0x000fe20000410000ULL, 0x3d80000019357820ULL, 0x000fe20000410000ULL,
0x000000ffff277224ULL, 0x000fe200078e0028ULL, 0x3d80000018367820ULL, 0x000fe20000410000ULL,
0x0000002900287202ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe200078e002aULL,
0x3d80000017377820ULL, 0x000fe20000410000ULL, 0x3d800000163c7820ULL, 0x000fe20000410000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0015ULL, 0x00000012000f7202ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0014ULL, 0x3d8000000b2c7820ULL, 0x000fe20000410000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0x3d8000000a2d7820ULL, 0x000fe20000410000ULL,
0x000000ffff107224ULL, 0x000fe200078e0011ULL, 0x0000002500127202ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe200078e002bULL, 0x0000002100157202ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0000001d001a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff117224ULL, 0x000fe400078e0024ULL,
0x000000ffff137224ULL, 0x000fe400078e0023ULL, 0x000000ffff147224ULL, 0x000fe400078e0022ULL,
0x000000ffff177224ULL, 0x000fe400078e0020ULL, 0x000000ffff187224ULL, 0x000fe400078e001fULL,
0x000000ffff197224ULL, 0x000fc400078e001eULL, 0x000000ffff1b7224ULL, 0x000fe400078e001cULL,
0x000000ffff2b7224ULL, 0x000fc400078e0009ULL, 0x0000000000087805ULL, 0x000fca0000015200ULL,
0x0000040072037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804830ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fc80007f1e1ffULL,
0x0000000b090b7210ULL, 0x000fe400007fe5ffULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140bULL,
0x0000000a03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000203037819ULL, 0x000fc8000000120aULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040072037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff0a5037812ULL, 0x000fe400078ec0ffULL, 0x000000797a00720cULL, 0x000fc60003f05270ULL,
0x0000008078037824ULL, 0x000fca00078e0203ULL, 0x0144000003087984ULL, 0x0002aa0000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002071c7824ULL, 0x000fe200078e00ffULL,
0x8000000475047210ULL, 0x000fc80007ffe0ffULL, 0x000000061c1d7812ULL, 0x000fc800078ec0ffULL,
0x000000011d1f7812ULL, 0x040fe400078efcffULL, 0x000000081d217812ULL, 0x000fe400078efcffULL,
0x000000041f00720cULL, 0x080fe40003f26070ULL, 0x000000101d1f7812ULL, 0x000fe400078efcffULL,
0x000000042100720cULL, 0x080fe40003f06070ULL, 0x000000041f00720cULL, 0x000fc40003fc6070ULL,
0x000000111d217812ULL, 0x040fe400078efcffULL, 0x000000181d1f7812ULL, 0x040fe400078efcffULL,
0x000000041d00720cULL, 0x080fe40003f46070ULL, 0x000000042100720cULL, 0x080fe40003fa6070ULL,
0x000000041f00720cULL, 0x000fe40003f66070ULL, 0x000000091d237812ULL, 0x000fc400078efcffULL,
0x000000191d217812ULL, 0x040fe400078efcffULL, 0x000000201d1f7812ULL, 0x000fe400078efcffULL,
0xff80000012127808ULL, 0x000fe40005000000ULL, 0xff8000000d0d7808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40004800000ULL, 0xff8000000c0c7808ULL, 0x000fc40004800000ULL,
0x000000042300720cULL, 0x080fe40003f86070ULL, 0x000000042100720cULL, 0x080fe40003f46070ULL,
0x000000041f00720cULL, 0x000fe40003f26070ULL, 0x000000211d217812ULL, 0x040fe400078efcffULL,
0x000000281d1f7812ULL, 0x000fe400078efcffULL, 0xff80000013137808ULL, 0x000fc40004000000ULL,
0xff8000000e0e7808ULL, 0x000fe40004000000ULL, 0xff80000014147808ULL, 0x000fe40006000000ULL,
0xff8000000f0f7808ULL, 0x000fe40006000000ULL, 0x000000042100720cULL, 0x080fe40003f06070ULL,
0x000000041f00720cULL, 0x000fe40003f86070ULL, 0x000000291d217812ULL, 0x000fc400078efcffULL,
0x000000301d1f7812ULL, 0x000fe400078efcffULL, 0xff80000015157808ULL, 0x000fe40007000000ULL,
0xff80000010107808ULL, 0x000fe40007000000ULL, 0xff80000017177808ULL, 0x000fe40006800000ULL,
0xff80000026267808ULL, 0x000fe40006800000ULL, 0x000000042100720cULL, 0x000fc40003fc6070ULL,
0x000000041f00720cULL, 0x000fe40003fa6070ULL, 0x000000311d217812ULL, 0x040fe400078efcffULL,
0x000000381d1f7812ULL, 0x040fe400078efcffULL, 0x000000391d1d7812ULL, 0x000fe400078efcffULL,
0xff80000018187808ULL, 0x000fe40005800000ULL, 0xff80000027277808ULL, 0x000fc40005800000ULL,
0xff80000019197808ULL, 0x000fe40005000000ULL, 0xff80000028287808ULL, 0x000fe40005000000ULL,
0xff8000001a1a7808ULL, 0x000fe40004800000ULL, 0xff80000029297808ULL, 0x000fe40004800000ULL,
0x000000042100720cULL, 0x080fe40003f66070ULL, 0x000000041f00720cULL, 0x000fc40003f46070ULL,
0x000000041d00720cULL, 0x000fe40003f26070ULL, 0xff8000001b1b7808ULL, 0x000fe40004000000ULL,
0xff8000002a2a7808ULL, 0x000fe40004000000ULL, 0xff8000002b2b7808ULL, 0x000fe40006000000ULL,
0xff8000002c2c7808ULL, 0x000fe40006000000ULL, 0xff80000034347808ULL, 0x000fc40007000000ULL,
0xff8000002d2d7808ULL, 0x000fe40007000000ULL, 0xff80000035357808ULL, 0x000fe40006800000ULL,
0xff8000002e2e7808ULL, 0x000fe40006800000ULL, 0xff80000036367808ULL, 0x000fe40005800000ULL,
0xff8000002f2f7808ULL, 0x000fe40005800000ULL, 0xff80000037377808ULL, 0x000fc40005000000ULL,
0xff80000033337808ULL, 0x000fe40005000000ULL, 0xff8000003c3c7808ULL, 0x000fe40004800000ULL,
0xff80000016167808ULL, 0x000fc40004800000ULL, 0x0000000d0800720bULL, 0x004fe20003f1e000ULL,
0x0000001fff1e7424ULL, 0x000fe200078e00ffULL, 0x000000120900720bULL, 0x000fe20003f3e000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x000000080d1d7208ULL, 0x000fe40004000000ULL,
0x0000000912047208ULL, 0x000fc40004800000ULL, 0x0000000c1d00720bULL, 0x000fe40003f1e000ULL,
0x000000110400720bULL, 0x000fe40003f3e000ULL, 0x0000001d0c1d7208ULL, 0x000fe40004000000ULL,
0x0000000411047208ULL, 0x000fe40004800000ULL, 0x0000000e1d00720bULL, 0x000fe40003f1e000ULL,
0x000000130400720bULL, 0x000fc40003f3e000ULL, 0x0000001d0e087208ULL, 0x000fe40004000000ULL,
0x0000000413097208ULL, 0x000fe40004800000ULL, 0x0000000f0800720bULL, 0x000fe40003f1e000ULL,
0x000000140900720bULL, 0x000fe40003f3e000ULL, 0x000000080f1d7208ULL, 0x000fe40004000000ULL,
0x0000000914047208ULL, 0x000fc40004800000ULL, 0x000000101d00720bULL, 0x000fe40003f1e000ULL,
0x000000150400720bULL, 0x000fe40003f3e000ULL, 0x0000001d101d7208ULL, 0x000fe40004000000ULL,
0x0000000415047208ULL, 0x000fe40004800000ULL, 0x000000261d00720bULL, 0x000fe40003f1e000ULL,
0x000000170400720bULL, 0x000fc40003f3e000ULL, 0x0000001d26087208ULL, 0x000fe40004000000ULL,
0x0000000417097208ULL, 0x000fe40004800000ULL, 0x000000270800720bULL, 0x000fe40003f1e000ULL,
0x000000180900720bULL, 0x000fe40003f3e000ULL, 0x00000008271d7208ULL, 0x000fe40004000000ULL,
0x0000000918047208ULL, 0x000fc40004800000ULL, 0x000000281d00720bULL, 0x000fe40003f1e000ULL,
0x000000190400720bULL, 0x000fe40003f3e000ULL, 0x0000001d28087208ULL, 0x000fe40004000000ULL,
0x0000000419097208ULL, 0x000fe40004800000ULL, 0x000000290800720bULL, 0x000fe40003f1e000ULL,
0x0000001a0900720bULL, 0x000fc40003f3e000ULL, 0x00000008291d7208ULL, 0x000fe40004000000ULL,
0x000000091a047208ULL, 0x000fe40004800000ULL, 0x0000002a1d00720bULL, 0x000fe40003f1e000ULL,
0x0000001b0400720bULL, 0x000fe40003f3e000ULL, 0x0000001d2a1d7208ULL, 0x000fe40004000000ULL,
0x000000041b047208ULL, 0x000fc40004800000ULL, 0x0000002c1d00720bULL, 0x000fe40003f1e000ULL,
0x0000002b0400720bULL, 0x000fe40003f3e000ULL, 0x0000001d2c087208ULL, 0x000fe40004000000ULL,
0x000000042b097208ULL, 0x000fe40004800000ULL, 0x0000002d0800720bULL, 0x000fe40003f1e000ULL,
0x000000340900720bULL, 0x000fc40003f3e000ULL, 0x000000082d1d7208ULL, 0x000fe40004000000ULL,
0x0000000934047208ULL, 0x000fe40004800000ULL, 0x0000002e1d00720bULL, 0x000fe40003f1e000ULL,
0x000000350400720bULL, 0x000fe40003f3e000ULL, 0x0000001d2e087208ULL, 0x000fe40004000000ULL,
0x0000000435097208ULL, 0x000fc40004800000ULL, 0x0000002f0800720bULL, 0x000fe40003f1e000ULL,
0x000000360900720bULL, 0x000fe40003f3e000ULL, 0x000000082f087208ULL, 0x000fe40004000000ULL,
0x0000000936047208ULL, 0x000fe40004800000ULL, 0x000000330800720bULL, 0x000fe40003f1e000ULL,
0x000000370400720bULL, 0x000fc40003f3e000ULL, 0x0000000833097208ULL, 0x000fe40004000000ULL,
0x00000004371d7208ULL, 0x000fe40004800000ULL, 0x000000160900720bULL, 0x000fe40003f1e000ULL,
0x0000003c1d00720bULL, 0x000fe40003f3e000ULL, 0x00000009161c7208ULL, 0x000fe40004000000ULL,
0x0000001d3c1f7208ULL, 0x000fe20004800000ULL, 0x000018f27f007947ULL, 0x000fec000b800000ULL,
0x0c401f001c047f89ULL, 0x0004e400000e0000ULL, 0x000000041c00720bULL, 0x00cfc80003f1e000ULL,
0x0000001c04217208ULL, 0x000fe20004000000ULL, 0x000018f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f001f047f89ULL, 0x000ea800000e0000ULL, 0x0c401f000a097f89ULL, 0x000ee800000e0000ULL,
0x0c401f000b087f89ULL, 0x000f2800000e0000ULL, 0x0c201f0021307f89ULL, 0x000e6200000e0000ULL,
0x000000041f00720bULL, 0x004fc40003f1e000ULL, 0x000000090a00720bULL, 0x008fe40003f3e000ULL,
0x0000001f04047208ULL, 0x000fe40004000000ULL, 0x0000000a09097208ULL, 0x000fe40004800000ULL,
0x000000080b00720bULL, 0x010fe20003f1e000ULL, 0x0c201f0004317f89ULL, 0x000ea600000e0000ULL,
0x0000000b08427208ULL, 0x000fe20004000000ULL, 0x0c201f0009327f89ULL, 0x000ee200000e0000ULL,
0x000000302100720bULL, 0x002fc60003f1e000ULL, 0x0c201f0042437f89ULL, 0x00026200000e0000ULL,
0x0000002130307208ULL, 0x000fe40004000000ULL, 0x000000310400720bULL, 0x004fe40003f3e000ULL,
0x000000320900720bULL, 0x008fe40003f5e000ULL, 0x0000000431317208ULL, 0x000fe40004800000ULL,
0x0000000932327208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b31047820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b303d7820ULL, 0x000fe20000410000ULL, 0x3c003c00ff407424ULL, 0x000fe200078e00ffULL,
0x3c003c0000417802ULL, 0x000fe20000000f00ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010804ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010804ULL, 0x0000001200257308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010804ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b1b1c7823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b2b1b7823ULL, 0x100fe20000010804ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010804ULL, 0x0000001300237308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b0f127823ULL, 0x102fe2000001083dULL, 0x3fb8aa3b191e7823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b270f7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b1a1d7823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b341a7823ULL, 0x100fe20000010804ULL, 0x3fb8aa3b35197823ULL, 0x000fe20000010804ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001400227308ULL, 0x000e620000000800ULL,
0x3fb8aa3b0e137823ULL, 0x104fe2000001083dULL, 0x3fb8aa3b280e7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b2c0b7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b2d0a7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b2e097823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b2f087823ULL, 0x100fe2000001083dULL,
0x0000000181277810ULL, 0x040fe20007ffe0ffULL, 0x0000001500217308ULL, 0x000fe20000000800ULL,
0x00000008813e7824ULL, 0x040fe200078e00ffULL, 0x3fb8aa3b16167823ULL, 0x000fe2000001083dULL,
0x0000000881487824ULL, 0x040fe200078e00ffULL, 0x00000003814a7819ULL, 0x040fe200000006ffULL,
0x0000000881467824ULL, 0x040fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee227ULL,
0x00000008814c7824ULL, 0x040fe200078e00ffULL, 0x0000001100247308ULL, 0x0004e20000000800ULL,
0x00000023222b723eULL, 0x002fe200000000ffULL, 0x00000008814e7824ULL, 0x040fe200078e00ffULL,
0x00000002813f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000881447824ULL, 0x000fe200078e00ffULL,
0x0000000ca5a57812ULL, 0x000fe200078ec0ffULL, 0x000000087f527824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee23fULL, 0x0000000d00157308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b10117823ULL, 0x104fe2000001083dULL, 0x3fb8aa3b26107823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b33267823ULL, 0x000fe2000001083dULL, 0x0000000381337810ULL, 0x000fc40007ffe0ffULL,
0x00000006813f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c00147308ULL, 0x0005220000000800ULL,
0x3fb8aa3b290d7823ULL, 0x002fe2000001083dULL, 0x000000252429723eULL, 0x008fe400000000ffULL,
0xfffffff848487812ULL, 0x000fe400078ee233ULL, 0x0000000481337810ULL, 0x040fe40007ffe0ffULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a0c7823ULL, 0x004fe2000001083dULL,
0x00000005813d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff84a4a7812ULL, 0x000fe400078ee233ULL,
0xfffffff84c4c7812ULL, 0x000fe400078ee23dULL, 0x0000001200127308ULL, 0x000e620000000800ULL,
0x000000151428723eULL, 0x010fe400000000ffULL, 0x0000a00078337811ULL, 0x000fe400078e58ffULL,
0x00000003813d7819ULL, 0x000fe400000006ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee23fULL,
0x0000001700207308ULL, 0x0004e20000000800ULL, 0xfffffff844447812ULL, 0x000fe200078ee281ULL,
0x000000104a477824ULL, 0x000fe200078e0233ULL, 0xfffffff852527812ULL, 0x000fc400078ee27fULL,
0x0000003346457211ULL, 0x080fe200078e20ffULL, 0x0000001044447824ULL, 0x100fe200078e0233ULL,
0x000000334e497211ULL, 0x000fe200078e20ffULL, 0x00000018001f7308ULL, 0x0009e20000000800ULL,
0x00000013122a723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b37177823ULL, 0x104fe20000010804ULL,
0x0000001048467824ULL, 0x100fe200078e0233ULL, 0x0000000307ff7812ULL, 0x000fe2000780c0ffULL,
0x000000104c487824ULL, 0x100fe200078e0233ULL, 0x000000434200720bULL, 0x000fe20003f3e000ULL,
0x00000010524b7824ULL, 0x000fe200078e0233ULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b36187823ULL, 0x110fe20000010804ULL, 0x00000021202d723eULL, 0x008fe200000000ffULL,
0x000000402834723cULL, 0x000f6200000018ffULL, 0x3fb8aa3b3c047823ULL, 0x000fe20000010804ULL,
0xffffffff813c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001a5457824ULL, 0x040fe200078e0245ULL,
0x00000048a5487210ULL, 0x000fe20007ffe0ffULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0xfffffff83d507812ULL, 0x000fe200078ee23cULL, 0x00000001a5467824ULL, 0x000fc400078e0246ULL,
0x00000001a5477824ULL, 0x040fe400078e0247ULL, 0x00000010504a7824ULL, 0x000fe400078e0233ULL,
0x0000001000107308ULL, 0x000ea20000000800ULL, 0x0000001f1e2f723eULL, 0x002fe200000000ffULL,
0x00000001a5497824ULL, 0x040fe400078e0249ULL, 0x00000001a54a7824ULL, 0x000fc800078e024aULL,
0x0000000f000f7308ULL, 0x000ff00000000800ULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x00000011102c723eULL, 0x004fce00000000ffULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x0000000f0e2e723eULL, 0x002fce00000000ffULL, 0x0000001c001c7308ULL, 0x000e620000000800ULL,
0x000000402c38723cULL, 0x020b6e0000001834ULL, 0x0000001b001b7308ULL, 0x000ff00000000800ULL,
0x0000001a001a7308ULL, 0x000ea20000000800ULL, 0x0000001d1c35723eULL, 0x022fce00000000ffULL,
0x0000000d000d7308ULL, 0x000ff00000000800ULL, 0x0000000c000c7308ULL, 0x000e620000000800ULL,
0x0000001b1a37723eULL, 0x004fce00000000ffULL, 0x0000000b000b7308ULL, 0x000ff00000000800ULL,
0x0000000a000a7308ULL, 0x000ea20000000800ULL, 0x0000000d0c34723eULL, 0x002fce00000000ffULL,
0x0000001600277308ULL, 0x000fe20000000800ULL, 0x0000000b0a36723eULL, 0x004fce00000000ffULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x000000403438723cULL, 0x000f6e0000001838ULL,
0x0000001800187308ULL, 0x000e700000000800ULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x00000019183d723eULL, 0x002fce00000000ffULL,
0x0000000800087308ULL, 0x000e700000000800ULL, 0x0000002600267308ULL, 0x000eb00000000800ULL,
0x0000000400167308ULL, 0x0007220000000800ULL, 0x00000009083c723eULL, 0x002fe200000000ffULL,
0x000000103e047824ULL, 0x008fe200078e0233ULL, 0x00000026273e723eULL, 0x004fe200000000ffULL,
0x00000001a5337824ULL, 0x000fc600078e0244ULL, 0x00000004a5047210ULL, 0x000fe40007ffe0ffULL,
0x00000017163f723eULL, 0x010fe200000000ffULL, 0x0000002833007388ULL, 0x0003e80000000800ULL,
0x0000002a04007388ULL, 0x0005e40000000800ULL, 0x000000403c38723cULL, 0x020b640000001838ULL,
0x0000002c45007388ULL, 0x0005e20000000800ULL, 0x0000004243337208ULL, 0x002fc60004800000ULL,
0x0000002e46007388ULL, 0x0005e20000000800ULL, 0x00000001a5407824ULL, 0x020fc600078e024bULL,
0x0000003447007388ULL, 0x0005e80000000800ULL, 0x0000003648007388ULL, 0x0005e80000000800ULL,
0x0000003c49007388ULL, 0x0005e80000000800ULL, 0x0000003e4a007388ULL, 0x0005e40000000800ULL,
0x0000003a00397202ULL, 0x000fc40000000f00ULL, 0x0000002940007388ULL, 0x0005e80000000800ULL,
0x0004002b04007388ULL, 0x0005e80000000800ULL, 0x0004002d45007388ULL, 0x0005e80000000800ULL,
0x0004002f46007388ULL, 0x0005e80000000800ULL, 0x0004003547007388ULL, 0x0005e80000000800ULL,
0x0004003748007388ULL, 0x0005e80000000800ULL, 0x0004003d49007388ULL, 0x0005e80000000800ULL,
0x0004003f4a007388ULL, 0x0005e80000000800ULL, 0x0140003003008388ULL, 0x0005e80000000c00ULL,
0x0142003803008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014ad80071ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014ae00071ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014ae80071ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000003007a7a7a10ULL, 0x000fe20007ffe0ffULL, 0x014af00071ff7f8cULL, 0x0003e6000c80043fULL,
0x000000747a00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff5fd000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff357807ULL, 0x004fe40004000000ULL, 0x0002531000347802ULL, 0x000fc40000000f00ULL,
0x0000109000007944ULL, 0x008fea0003c00000ULL, 0x0000003900247202ULL, 0x000fe20000000f00ULL,
0xfffdf2e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x000fe40004800000ULL,
0x0002536000347802ULL, 0x000fc40000000f00ULL, 0x0000104000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0039ULL, 0xfffdf32000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3b7224ULL, 0x000fe200078e0029ULL, 0x00000030003a7202ULL, 0x000fe40000000f00ULL,
0x000253c000347802ULL, 0x000fc40000000f00ULL, 0x00000fa000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff297224ULL, 0x004fe200078e003aULL, 0xfffdf3c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0030ULL, 0x0002542000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e0029ULL, 0x00000f4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff297224ULL, 0x004fe200078e003aULL, 0xfffdf4c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0029ULL, 0x0002548000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e0028ULL, 0x00000ee000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffdf69000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3b7224ULL, 0x002fe200078e0026ULL, 0x00000029003a7202ULL, 0x000fc40000000f00ULL,
0x000254e000347802ULL, 0x000fc40000000f00ULL, 0x00000e8000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffdf66000007947ULL, 0x000fea000383ffffULL,
0x00000036003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e007cULL,
0x0002554000347802ULL, 0x000fc40000000f00ULL, 0x00000e2000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe1bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x000255a000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007bULL, 0x00000dc000007944ULL, 0x004fea0003c00000ULL,
0x0000003a00267202ULL, 0x004fe20000000f00ULL, 0xfffe1b9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x004fe40004000000ULL, 0x000255f000347802ULL, 0x000fc40000000f00ULL,
0x00000db000007944ULL, 0x008fea0003c00000ULL, 0x0000003900247202ULL, 0x000fe20000000f00ULL,
0xfffe44f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x000fe40004800000ULL,
0x0002564000347802ULL, 0x000fc40000000f00ULL, 0x00000d6000007944ULL, 0x008fea0003c00000ULL,
0xfffe454000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x0002569000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x00000cd000007944ULL, 0x008fea0003c00000ULL, 0x0000003a00347202ULL, 0x004fe20000000f00ULL,
0xfffe45d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x000256f000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fc400078e007bULL,
0x00000c7000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffe46c000007947ULL, 0x000fea000383ffffULL, 0x00000036003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e007cULL, 0x0002575000347802ULL, 0x000fc40000000f00ULL,
0x00000c1000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffe488000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x000257b000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fc400078e007bULL,
0x00000bb000007944ULL, 0x00cfea0003c00000ULL, 0x0000003a00267202ULL, 0x004fe20000000f00ULL,
0xfffe484000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0002581000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x00000b5000007944ULL, 0x000fea0003c00000ULL, 0x0000003a00277202ULL, 0x004fe20000000f00ULL,
0xfffe6aa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0002587000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fc400078e007bULL,
0x00000af000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffe6a6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x004fe40004000000ULL,
0x000258c000347802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0039ULL, 0xfffe920000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x000fe40004800000ULL, 0x0002591000347802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x008fea0003c00000ULL, 0xfffe925000007947ULL, 0x000fea000383ffffULL,
0x0000003d003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e007cULL,
0x0002596000347802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffe92e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x000259c000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007bULL, 0x000009a000007944ULL, 0x008fea0003c00000ULL,
0x0000003a00347202ULL, 0x004fe20000000f00ULL, 0xfffe93d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x00025a2000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e007cULL, 0x0000094000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe959000007947ULL, 0x000fea000383ffffULL,
0x00000036003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fe200078e007bULL,
0x00025a8000347802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffe955000007947ULL, 0x000fea000383ffffULL,
0x00000036003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e007cULL,
0x00025ae000347802ULL, 0x000fc40000000f00ULL, 0x0000088000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffeb7b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x00025b4000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007bULL, 0x0000082000007944ULL, 0x004fea0003c00000ULL,
0x0000003a00267202ULL, 0x004fe20000000f00ULL, 0xfffeb77000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x004fe40004000000ULL, 0x00025b9000347802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffedf1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x000fe40004800000ULL,
0x00025be000347802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x008fea0003c00000ULL,
0xfffedf6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x00025c3000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x0000073000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffedff000007947ULL, 0x000fea000383ffffULL, 0x0000003d003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fe200078e007bULL, 0x00025c9000347802ULL, 0x000fc40000000f00ULL,
0x000006d000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffee0e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0000007c003b7202ULL, 0x000fc40000000f00ULL, 0x00025cf000347802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffee2a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x00025d5000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fc400078e007bULL,
0x0000061000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffee26000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x00025db000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x000005b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xffff04c000007947ULL, 0x000fea000383ffffULL, 0x00000036003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fe200078e007bULL, 0x00025e1000347802ULL, 0x000fc40000000f00ULL,
0x0000055000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xffff048000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x00cfe200078e0003ULL,
0x00025e6000347802ULL, 0x000fc40000000f00ULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e003aULL, 0xffff0d0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0003ULL, 0x00025eb000347802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x000fea0003c00000ULL, 0x0000003a00037202ULL, 0x004fe20000000f00ULL,
0xffff0df000007947ULL, 0x000fea000383ffffULL, 0x00000002ff1d7424ULL, 0x000fe200078e00ffULL,
0x00025f0000087802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x002fea0003c00000ULL,
0xffffe6e000007947ULL, 0x000fea000383ffffULL, 0x0000001f001c7202ULL, 0x002fe20000000f00ULL,
0x00000002ff1d7424ULL, 0x000fe200078e00ffULL, 0x00025f5000087802ULL, 0x000fc40000000f00ULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x000000041f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1c7224ULL, 0x002fe200078e000aULL, 0x00025fb000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000001f041f7208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000040a00720bULL, 0x004fe20003f1e000ULL,
0x00000002ff1d7424ULL, 0x002fe200078e00ffULL, 0x0000000b001c7202ULL, 0x000fc40000000f00ULL,
0x0000000a04237208ULL, 0x000fe40004000000ULL, 0x0002601000087802ULL, 0x000fc40000000f00ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000040b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1c7224ULL, 0x002fe200078e0021ULL, 0x0002607000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000000b04427208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000042100720bULL, 0x004fe20003f1e000ULL,
0x00000001ff1d7424ULL, 0x002fe200078e00ffULL, 0x0000001f001c7202ULL, 0x000fe40000000f00ULL,
0x0000002104307208ULL, 0x000fc40004000000ULL, 0x000260d000087802ULL, 0x000fc40000000f00ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000041f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1c7224ULL, 0x002fe200078e0023ULL, 0x0002613000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000001f04317208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000042300720bULL, 0x004fe20003f1e000ULL,
0x00000001ff1d7424ULL, 0x002fe200078e00ffULL, 0x00000042001c7202ULL, 0x000fe40000000f00ULL,
0x0000002304327208ULL, 0x000fe40004000000ULL, 0x0002619000087802ULL, 0x000fc40000000f00ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff437224ULL, 0x004fe200078e0004ULL,
0xffffe5a000007947ULL, 0x000fea000383ffffULL, 0x0180000030037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000003000038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff0a7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000030aff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff30ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000030077812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000030aff7212ULL, 0x000fda000780c0ffULL, 0x0080000007030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0007ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003000037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffd9ce006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000002500007348ULL, 0x000fe80003800000ULL,
0x0c00001d1c047389ULL, 0x0002a200000e001eULL, 0xfffd9ca008007950ULL, 0x000fea0003c3ffffULL,
0x0000000000357802ULL, 0x000fe20000000f00ULL, 0x0000002000007348ULL, 0x000fe80003800000ULL,
0x0000003b3a3a7389ULL, 0x0002a200000e001fULL, 0xfffd9c6034007950ULL, 0x000fea0003c3ffffULL,
0x000000013500780cULL, 0x000fe20003f25070ULL, 0x0000002200007348ULL, 0x000fd80003800000ULL,
0x0000000000357806ULL, 0x000fc800048e0100ULL, 0x0000002235397212ULL, 0x000fe200078ec0ffULL,
0x00000000ff357424ULL, 0x000fc800078e00ffULL, 0xfffd9c0034007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff297424ULL, 0x000fe200078e00ffULL, 0x0000000200007348ULL, 0x000fe80003800000ULL,
0xfffd9bd028007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000567ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x00000000000003c0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cf8ULL,
0x00000000000000e4ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ddcULL,
0x0000000000000cb0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001a90ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001aa0ULL,
0x00000000000000b0ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001b50ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001b54ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001d80ULL,
0x0000000000026500ULL, 0xc900001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000028280ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000282c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000028640ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001b50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000026730ULL,
0x0000000000026730ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000028280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000028640ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_fp16_pagedKV_128_nqpkv_1_m_1_sm_86_cubin_len = 165664;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
