/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_fp16_pagedKV_128_nqpkv_1_m_1_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000027d38ULL, 0x00000000000279b8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45346aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x32336a4c4545346aULL, 0x32454532336a4c45ULL,
0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45346a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x00000000676e6964ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x746e695f5f240000ULL, 0x5f305f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x7063725f30326d73ULL,
0x5f7a74665f6e725fULL, 0x776f6c735f323366ULL, 0x65722e0068746170ULL, 0x6b2e747865742e6cULL,
0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x5f6c656e72656b24ULL, 0x6d656d732461686dULL, 0x0066754265747942ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL, 0x756265642e616c65ULL,
0x00656d6172665f67ULL, 0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0001000001b1ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b000100000284ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000002d2ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b000100000320ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b000100000367ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000003acULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a002200000407ULL,
0x0000000000026040ULL, 0x0000000000000240ULL, 0x000400030000047dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000026280ULL,
0x000d0003000004adULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0002604000000000ULL, 0x0000200400000000ULL, 0x01f0288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808292ULL,
0x0000001cffffffffULL, 0x0000006000000000ULL, 0x0002604000000000ULL, 0x0000024000000000ULL,
0x0000000000000000ULL, 0x0000001400082f04ULL, 0x0008230400000080ULL, 0x0000000000000012ULL,
0x0000001200081204ULL, 0x00081104000000f0ULL, 0x000000f000000012ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x000000f000000014ULL, 0x0000001400081104ULL, 0x00043704000000f0ULL,
0x000c17040000007bULL, 0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL,
0x000c17040021f000ULL, 0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL,
0x000c17040061f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0x00000b7000143104ULL, 0x0001798000000b90ULL, 0x00018db000017e40ULL,
0xffffffff01082904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01082804ffffffffULL, 0x00000110000000c0ULL, 0x00000b7000000820ULL,
0x000049d000000b90ULL, 0x00004b0000004a40ULL, 0x00004ed000004c40ULL, 0x0000740000004ee0ULL,
0x00009b6000007410ULL, 0x00009c9000009be0ULL, 0x00009f9000009dc0ULL, 0x0000c17000009fa0ULL,
0x0000e7700000c180ULL, 0x0000e8a00000e7f0ULL, 0x0000eba00000e9d0ULL, 0x00010d800000ebb0ULL,
0x0001338000010d90ULL, 0x000134b000013400ULL, 0x000137b0000135e0ULL, 0x00015990000137c0ULL,
0x00016170000159a0ULL, 0x0001667000016180ULL, 0x00017e4000017980ULL, 0x0001828000018250ULL,
0x0001873000018700ULL, 0x00018db000018ba0ULL, 0x0001b40000018fe0ULL, 0x0001da000001b780ULL,
0x0001fbf00001e420ULL, 0x0002183000020270ULL, 0x00023b1000022150ULL, 0x00025380000252d0ULL,
0x0002564000025570ULL, 0x00025bc0000259b0ULL, 0x00025d3000025cf0ULL, 0x0000023007a03904ULL,
0x0001cad0000000ffULL, 0x0000031000040100ULL, 0x0001cad800000004ULL, 0x00000420003f0100ULL,
0x0001cb5800000004ULL, 0x00000540003f0100ULL, 0x0001cb7800000002ULL, 0x00000630003f0100ULL,
0x0001cb88000000ffULL, 0x0000095000040100ULL, 0x0001cad0000000ffULL, 0x00000d0000080107ULL,
0x0001cb5800000076ULL, 0x00000d4000080101ULL, 0x0001cb88000000ffULL, 0x00000d7000080101ULL,
0x0001cb88000000ffULL, 0x00000ee000080109ULL, 0x0001cb88000000ffULL, 0x0000239000080109ULL,
0x0001cb88000000ffULL, 0x000023c000080101ULL, 0x0001cb88000000ffULL, 0x0000253000080109ULL,
0x0001cb88000000ffULL, 0x000026b000080109ULL, 0x0001cb78000000ffULL, 0x000026e000080107ULL,
0x0001cb78000000ffULL, 0x0000276000080101ULL, 0x0001cb88000000ffULL, 0x000029b000080101ULL,
0x0001cb78000000ffULL, 0x00002b2000080109ULL, 0x0001cb78000000ffULL, 0x00002b5000080109ULL,
0x0001cb88000000ffULL, 0x00002cc000080109ULL, 0x0001cb88000000ffULL, 0x0000415000080109ULL,
0x0001cb88000000ffULL, 0x0000418000080101ULL, 0x0001cb88000000ffULL, 0x000042f000080109ULL,
0x0001cb88000000ffULL, 0x0000471000080109ULL, 0x0001cb80000000ffULL, 0x0000474000080107ULL,
0x0001cb80000000ffULL, 0x0000478000080101ULL, 0x0001cad800000076ULL, 0x000047b000080101ULL,
0x0001cad800000076ULL, 0x0000492000080109ULL, 0x0001cad800000076ULL, 0x0000571000080109ULL,
0x0001cb88000000ffULL, 0x000057f000080101ULL, 0x0001cb80000000ffULL, 0x0000596000080109ULL,
0x0001cb80000000ffULL, 0x0000599000080109ULL, 0x0001cb88000000ffULL, 0x00005b0000080109ULL,
0x0001cb88000000ffULL, 0x00006f9000080109ULL, 0x0001cb88000000ffULL, 0x00006fc000080101ULL,
0x0001cb88000000ffULL, 0x0000713000080109ULL, 0x0001cb88000000ffULL, 0x0000733000080109ULL,
0x00000000000000ffULL, 0x000073c0001d0107ULL, 0x0001cb78000000ffULL, 0x00007a5000080101ULL,
0x0001cb88000000ffULL, 0x00007ac000080101ULL, 0x0001cb58000000ffULL, 0x00007ba000080101ULL,
0x0001cb78000000ffULL, 0x00007d1000080109ULL, 0x0001cb78000000ffULL, 0x00007d4000080109ULL,
0x0001cb88000000ffULL, 0x00007eb000080109ULL, 0x0001cb88000000ffULL, 0x0000934000080109ULL,
0x0001cb88000000ffULL, 0x0000937000080101ULL, 0x0001cb88000000ffULL, 0x000094e000080109ULL,
0x0001cb88000000ffULL, 0x000098a000080109ULL, 0x00000000000000ffULL, 0x000098d0001e0107ULL,
0x0001cb80000000ffULL, 0x0000991000080101ULL, 0x0001caf800000076ULL, 0x0000994000080101ULL,
0x0001caf800000076ULL, 0x00009ab000080109ULL, 0x0001caf800000076ULL, 0x0000a50000080109ULL,
0x0001cb88000000ffULL, 0x0000a5f000080101ULL, 0x0001cb80000000ffULL, 0x0000a76000080109ULL,
0x0001cb80000000ffULL, 0x0000a79000080109ULL, 0x0001cb88000000ffULL, 0x0000a90000080109ULL,
0x0001cb88000000ffULL, 0x0000bd9000080109ULL, 0x0001cb88000000ffULL, 0x0000bdc000080101ULL,
0x0001cb88000000ffULL, 0x0000bf3000080109ULL, 0x0001cb88000000ffULL, 0x0000c10000080109ULL,
0x00000000000000ffULL, 0x0000c130001d0107ULL, 0x0001cb78000000ffULL, 0x0000c67000080101ULL,
0x0001cb88000000ffULL, 0x0000c6d000080101ULL, 0x0001cb60000000ffULL, 0x0000c7b000080101ULL,
0x0001cb78000000ffULL, 0x0000c92000080109ULL, 0x0001cb78000000ffULL, 0x0000c95000080109ULL,
0x0001cb88000000ffULL, 0x0000cac000080109ULL, 0x0001cb88000000ffULL, 0x0000df5000080109ULL,
0x0001cb88000000ffULL, 0x0000df8000080101ULL, 0x0001cb88000000ffULL, 0x0000e0f000080109ULL,
0x0001cb88000000ffULL, 0x0000e4b000080109ULL, 0x00000000000000ffULL, 0x0000e4e0001e0107ULL,
0x0001cb80000000ffULL, 0x0000e52000080101ULL, 0x0001cb1800000076ULL, 0x0000e55000080101ULL,
0x0001cb1800000076ULL, 0x0000e6c000080109ULL, 0x0001cb1800000076ULL, 0x0000f11000080109ULL,
0x0001cb88000000ffULL, 0x0000f20000080101ULL, 0x0001cb80000000ffULL, 0x0000f37000080109ULL,
0x0001cb80000000ffULL, 0x0000f3a000080109ULL, 0x0001cb88000000ffULL, 0x0000f51000080109ULL,
0x0001cb88000000ffULL, 0x000109a000080109ULL, 0x0001cb88000000ffULL, 0x000109d000080101ULL,
0x0001cb88000000ffULL, 0x00010b4000080109ULL, 0x0001cb88000000ffULL, 0x00010d1000080109ULL,
0x00000000000000ffULL, 0x00010d40001d0107ULL, 0x0001cb78000000ffULL, 0x0001128000080101ULL,
0x0001cb88000000ffULL, 0x000112e000080101ULL, 0x0001cb68000000ffULL, 0x000113c000080101ULL,
0x0001cb78000000ffULL, 0x0001153000080109ULL, 0x0001cb78000000ffULL, 0x0001156000080109ULL,
0x0001cb88000000ffULL, 0x000116d000080109ULL, 0x0001cb88000000ffULL, 0x00012b6000080109ULL,
0x0001cb88000000ffULL, 0x00012b9000080101ULL, 0x0001cb88000000ffULL, 0x00012d0000080109ULL,
0x0001cb88000000ffULL, 0x000130c000080109ULL, 0x00000000000000ffULL, 0x000130f0001e0107ULL,
0x0001cb80000000ffULL, 0x0001313000080101ULL, 0x0001cb3800000076ULL, 0x0001316000080101ULL,
0x0001cb3800000076ULL, 0x000132d000080109ULL, 0x0001cb3800000076ULL, 0x00013d2000080109ULL,
0x0001cb88000000ffULL, 0x00013e1000080101ULL, 0x0001cb80000000ffULL, 0x00013f8000080109ULL,
0x0001cb80000000ffULL, 0x00013fb000080109ULL, 0x0001cb88000000ffULL, 0x0001412000080109ULL,
0x0001cb88000000ffULL, 0x000155b000080109ULL, 0x0001cb88000000ffULL, 0x000155e000080101ULL,
0x0001cb88000000ffULL, 0x0001575000080109ULL, 0x0001cb88000000ffULL, 0x0001592000080109ULL,
0x00000000000000ffULL, 0x00015950001d0107ULL, 0x0001cb78000000ffULL, 0x00015e9000080101ULL,
0x0001cb88000000ffULL, 0x00015ee000080101ULL, 0x0001cb70000000ffULL, 0x00018f4000080101ULL,
0x0001cad0000000ffULL, 0x0001b43000080101ULL, 0x0001cad0000000ffULL, 0x0001b5a000080109ULL,
0x0001cad0000000ffULL, 0x000247c000080109ULL, 0x0001cb58000000ffULL, 0x0002498000040101ULL,
0x0001cb58000000ffULL, 0x00024af000040109ULL, 0x0001cb58000000ffULL, 0x00025fe000040109ULL,
0x0001cad8000000ffULL, 0x00025ff0000d0101ULL, 0x0001cae0000000ffULL, 0x00026000000d0101ULL,
0x0001cae8000000ffULL, 0x00026010000d0101ULL, 0x0001caf0000000ffULL, 0x00053803000d0101ULL,
0x00018ce000101c04ULL, 0x0001b6700001b5e0ULL, 0x000c050400026030ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0068190300000000ULL, 0x0000001500080a04ULL, 0x0000000000680210ULL,
0x00000000000000bcULL, 0x0000001400000002ULL, 0x0000000000026040ULL, 0x0000000000000044ULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001400000002ULL,
0x0000000000000000ULL, 0x000000000001cc00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000030000167ab9ULL, 0x000fe20000000800ULL, 0x0000010000047ab9ULL, 0x000fca0000000800ULL,
0x00000000001779c3ULL, 0x000ee20000002700ULL, 0x0000000000057919ULL, 0x000ea20000002200ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0xffffff1001017836ULL, 0x002fe20000000000ULL,
0x0000000000037919ULL, 0x000e680000002100ULL, 0x00000000000979c3ULL, 0x000ee20000002600ULL,
0x0000000404007c24ULL, 0x004fe2000f8e0205ULL, 0x0000000000047ab9ULL, 0x000fe20000000800ULL,
0x00001fff04047589ULL, 0x000ea400000e0000ULL, 0x0000000400027c24ULL, 0x102fe2000f8e0203ULL,
0x00000005ff007819ULL, 0x000fc40000011603ULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000007f0200780cULL, 0x040fe40003f64070ULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x000000ff0200720cULL, 0x040fe40003f45270ULL, 0x0000000f0200780cULL, 0x040fe40003f04070ULL,
0x000000030200780cULL, 0x040fe40003fa4070ULL, 0x000000010200780cULL, 0x000fc80003f84070ULL,
0x000000000006b919ULL, 0x000f220000008800ULL, 0x000004000005b802ULL, 0x000fe40000000f00ULL,
0x00000000041072caULL, 0x004fe400000e0000ULL, 0x00000000001572caULL, 0x002fe400000e0000ULL,
0x000006540607b816ULL, 0x010fe20000000005ULL, 0xff317217ff05b424ULL, 0x000fc800078e00ffULL,
0x000000040200b824ULL, 0x000fe200078e0207ULL, 0x0000000000242947ULL, 0x008fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01cad006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402047c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000040612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01cad804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000402047c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01cb5804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c400050000b388ULL, 0x0003e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01cb7804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01cb8806043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001510047291ULL, 0x000fe2000f8e103fULL, 0x00000000000f79c3ULL, 0x000ea20000008800ULL,
0x00008400000d7ab9ULL, 0x000fe20000000800ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0000000104057899ULL, 0x000fe4000800063fULL, 0x000000020d047899ULL, 0x000fe4000800063fULL,
0x000000040500788cULL, 0x000fe2000bf01070ULL, 0x000001f00c067812ULL, 0x000fe200078ec0ffULL,
0x00000017040472a4ULL, 0x000fe2000f8e0209ULL, 0x00000005ff027e24ULL, 0x000fe2000f8e00ffULL,
0x0000000405087887ULL, 0x000fc4000c000000ULL, 0x0000000503007c36ULL, 0x002fe20008000000ULL,
0x0000000105117890ULL, 0x000fe2000fffe03fULL, 0x0000002002057824ULL, 0x000fe200078e00ffULL,
0x00000008050a7290ULL, 0x000fe4000fffe13fULL, 0x0000000d050b72a4ULL, 0x000fe4000f8e0204ULL,
0x0000000d110c72a4ULL, 0x000fe4000f8e0204ULL, 0x0000001100047c02ULL, 0x000fe20008000f00ULL,
0x0000880000067ab9ULL, 0x000fe20000000a00ULL, 0x000000010a00788cULL, 0x000fe2000bf03070ULL,
0xffffffe005007812ULL, 0x000fe200078ee200ULL, 0x000002000b0478a5ULL, 0x000fe2000f8e0006ULL,
0x0000001103027c36ULL, 0x000fe20008000000ULL, 0x000002000c0678a5ULL, 0x000fe2000f8e0006ULL,
0x0000002004057824ULL, 0x000fe200078e00ffULL, 0x00000400000e7882ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000aff007c0cULL, 0x000fe2000bf06070ULL,
0x000006540f087896ULL, 0x004fe2000800000eULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x0000820000127ab9ULL, 0x000fe20000000a00ULL, 0x0000000406047c10ULL, 0x000fe2000ff3e0ffULL,
0x0001cad008047890ULL, 0x000fe2000fffe03fULL, 0x0000000606067c10ULL, 0x000fe2000ff5e0ffULL,
0x00000002171b7899ULL, 0x000fe2000800063fULL, 0xffffffe005027812ULL, 0x000fe200078ee202ULL,
0x00000005ff057e24ULL, 0x000fe200088e06ffULL, 0x0000000800097c11ULL, 0x000fe2000f8e20ffULL,
0x00000007ff077e24ULL, 0x000fe200090e06ffULL, 0x00000008020b7c11ULL, 0x000fc6000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000c101c52ULL,
0x00000000060b7faeULL, 0x0003e2000d901c52ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000960000067ab9ULL, 0x000fe20000000a00ULL, 0x000000041b0478a5ULL, 0x000fc4000f8e0004ULL,
0x000000041b0678a5ULL, 0x000fc8000f8e0006ULL, 0x00000004ff047e24ULL, 0x002fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000700077c02ULL, 0x000fe20008000f00ULL,
0x00000006ff067e24ULL, 0x000fc6000f8e00ffULL, 0x0000001204047981ULL, 0x000ea8000c1e1900ULL,
0x0000001206067981ULL, 0x000ee2000c1e1900ULL, 0x00000010ff007c0cULL, 0x000fe2000bf05270ULL,
0x00000000001979c3ULL, 0x000e620000002500ULL, 0x00000000041a72caULL, 0x004fe400000e0000ULL,
0x00000000060772caULL, 0x008fd600000e0000ULL, 0x0000007f1a067890ULL, 0x000fe4000fffe03fULL,
0x000000ff1a057890ULL, 0x000fe4000fffe03fULL, 0x000000083f077899ULL, 0x000fe40008011607ULL,
0x000000073f067899ULL, 0x000fe40008011606ULL, 0x000000083f057899ULL, 0x000fe20008011605ULL,
0x0000018000888947ULL, 0x002ff60003800000ULL, 0x00000015ff007e24ULL, 0x000fe2000f8e00ffULL,
0x0000000000797919ULL, 0x000e620000002700ULL, 0x0000000819107899ULL, 0x000fe4000800063fULL,
0x0000002000007824ULL, 0x000fe200078e0203ULL, 0x00000001191c7899ULL, 0x000fe4000800063fULL,
0x0000000315187899ULL, 0x000fe4000800063fULL, 0x000000030000780cULL, 0x040fe40003f44070ULL,
0x0000001f0000780cULL, 0x000fc40003f04070ULL, 0x00000018ff767e24ULL, 0x000fd2000f8e00ffULL,
0x00009000ff08ab82ULL, 0x000ea20000000800ULL, 0x00000000003f7886ULL, 0x000fe20001000000ULL,
0x0000001000078c36ULL, 0x000fe20008000000ULL, 0x00000000003f7886ULL, 0x000fe20000020000ULL,
0x00000008000bac11ULL, 0x000fe4000f8e10ffULL, 0x000000061c00828cULL, 0x000fe2000bf06070ULL,
0x0000001a07008c0cULL, 0x000fe2000bf26070ULL, 0x00008c00ff04ab82ULL, 0x000ee20000000a00ULL,
0x0000940000049ab9ULL, 0x000fe20000000800ULL, 0x000000047906a824ULL, 0x002fe200078e0200ULL,
0x000000041b0492a4ULL, 0x000fe2000f8e0210ULL, 0x000000000000781cULL, 0x000fc40003f6f008ULL,
0x000000020606a824ULL, 0x000fe400078e00ffULL, 0x00009200ff028b82ULL, 0x000e620000000a00ULL,
0x0000000400078c36ULL, 0x000fe40008000000ULL, 0x0000001c0809ac36ULL, 0x004fc80008000000ULL,
0x000000080609a224ULL, 0x000fe400078e0209ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000040904a825ULL, 0x008fe200078e0004ULL, 0x0000000800098c11ULL, 0x000fc6000f8e10ffULL,
0x0000000407028825ULL, 0x002fe200078e0002ULL, 0x0000000400077802ULL, 0x000fc80000000f00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1ca0000002098faeULL, 0x0003e2000c921852ULL,
0x01cb580776ff79a7ULL, 0x0005e60008500008ULL, 0x1cac0000040bafaeULL, 0x0007e8000d921852ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x01cb8806ff0679a7ULL, 0x004ea40008500008ULL, 0x000000ffff087224ULL, 0x004fe200078e0007ULL,
0x0000000000027805ULL, 0x002fc60000015200ULL, 0x01cb8808ff0075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x00afea0003800000ULL, 0x000000ffff067224ULL, 0x000fce00078e00ffULL,
0x000000100600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000106067836ULL, 0x000fce0000000000ULL,
0x01cb8808ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000119047890ULL, 0x000fe4000fffe03fULL, 0x0000000709097899ULL, 0x000fe4000800063fULL,
0x000000050400728cULL, 0x000fc6000bf06070ULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000800cc8947ULL, 0x000fea0003800000ULL, 0x0000000818117291ULL, 0x000fe2000f8e103fULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x000000101a00728cULL, 0x000fe2000bf01070ULL,
0x0000001800037c02ULL, 0x000fe20008000f00ULL, 0x00000009180e7290ULL, 0x000fe4000fffe03fULL,
0x000000101a0a7287ULL, 0x000fe4000c000000ULL, 0x0000002003037824ULL, 0x000fe200078e00ffULL,
0x01ca0011ff007984ULL, 0x000ea20008000800ULL, 0x0000000a100a7290ULL, 0x000fc4000fffe13fULL,
0x0001400008147890ULL, 0x000fe4000fffe03fULL, 0x0000000a1800728cULL, 0x000fe4000bf01070ULL,
0x00000001181d7890ULL, 0x000fe4000fffe03fULL, 0x0000000a180c7287ULL, 0x000fc6000c000000ULL,
0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000c180c7290ULL, 0x000fe2000fffe13fULL,
0x0000001dff087e24ULL, 0x000fc6000f8e00ffULL, 0x000000010c00788cULL, 0x000fe4000bf03070ULL,
0x0000000cff007c0cULL, 0x000fe2000bf06070ULL, 0x0000001006027824ULL, 0x002fca00078e00ffULL,
0x000001f002077812ULL, 0x000fe400078ec0ffULL, 0x0000000800007c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00000007984ULL, 0x000e640000000800ULL, 0x00000000000d72caULL, 0x002fe200000e0000ULL,
0x0000001806007c36ULL, 0x000fca0008000000ULL, 0xffffffe003007812ULL, 0x000fc800078ee200ULL,
0x0000001400057c11ULL, 0x000fc6000f8e20ffULL, 0x000000040d0e72a4ULL, 0x000fc8000f8e020eULL,
0x000002000e0e78a5ULL, 0x000fcc000f8e000aULL, 0x0000000e07027c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001d090e7290ULL, 0x000fc8000fffe03fULL, 0x0000000fff037e24ULL, 0x000fe200088e06ffULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000020c00788cULL, 0x000fc6000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000c101c52ULL,
0x01ca0411ff007984ULL, 0x000ea20008000800ULL, 0x0000002008037824ULL, 0x002fe200078e00ffULL,
0x0000000800047c11ULL, 0x004fe2000f8e10ffULL, 0x0000001d06007c36ULL, 0x000fe20008000000ULL,
0x00000002181d7890ULL, 0x000fc8000fffe03fULL, 0x01cac00004047984ULL, 0x000e620000000800ULL,
0xffffffe003007812ULL, 0x000fe200078ee200ULL, 0x0000001dff087e24ULL, 0x000fc6000f8e00ffULL,
0x0000001400057c11ULL, 0x000fe4000f8e20ffULL, 0x00000000040d72caULL, 0x002fda00000e0000ULL,
0x0000000d040e72a4ULL, 0x000fc8000f8e020eULL, 0x000002000e0e78a5ULL, 0x000fcc000f8e000aULL,
0x0000000e07027c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001d090e7290ULL, 0x000fc6000fffe03fULL,
0x0000000fff037c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000030c00788cULL, 0x000fe4000bf03070ULL, 0x01ca0811ff007984ULL, 0x000ea20008000800ULL,
0x0000002008037824ULL, 0x002fe200078e00ffULL, 0x0000000800047c11ULL, 0x004fe2000f8e10ffULL,
0x0000001d06007c36ULL, 0x000fe20008000000ULL, 0x00000003181d7890ULL, 0x000fc8000fffe03fULL,
0x01cac00004047984ULL, 0x000e620000000800ULL, 0xffffffe003007812ULL, 0x000fe200078ee200ULL,
0x0000001dff087e24ULL, 0x000fc6000f8e00ffULL, 0x0000001400057c11ULL, 0x000fe4000f8e20ffULL,
0x00000000040d72caULL, 0x002fda00000e0000ULL, 0x0000000d040e72a4ULL, 0x000fc8000f8e020eULL,
0x000002000e0e78a5ULL, 0x000fcc000f8e000aULL, 0x0000000e07027c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001d090e7290ULL, 0x000fc8000fffe03fULL, 0x0000000fff037e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000040c00788cULL, 0x000fe4000bf03070ULL,
0x01ca0c11ff007984ULL, 0x000ea20008000800ULL, 0x0000002008037824ULL, 0x002fe200078e00ffULL,
0x0000000800047c11ULL, 0x004fe2000f8e10ffULL, 0x0000001d06007c36ULL, 0x000fe20008000000ULL,
0x00000004181d7890ULL, 0x000fc8000fffe03fULL, 0x01cac00004047984ULL, 0x000e620000000800ULL,
0xffffffe003007812ULL, 0x000fe200078ee200ULL, 0x0000001dff087e24ULL, 0x000fc6000f8e00ffULL,
0x0000001400057c11ULL, 0x000fe4000f8e20ffULL, 0x00000000040d72caULL, 0x002fda00000e0000ULL,
0x0000000d040e72a4ULL, 0x000fc8000f8e020eULL, 0x000002000e0e78a5ULL, 0x000fcc000f8e000aULL,
0x0000000e07027c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001d090e7290ULL, 0x000fc6000fffe03fULL,
0x0000000fff037c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000050c00788cULL, 0x000fe4000bf03070ULL, 0x01ca1011ff007984ULL, 0x000ea20008000800ULL,
0x0000002008037824ULL, 0x002fe200078e00ffULL, 0x0000000800047c11ULL, 0x004fe2000f8e10ffULL,
0x0000001d06007c36ULL, 0x000fe20008000000ULL, 0x00000005181d7890ULL, 0x000fc8000fffe03fULL,
0x01cac00004047984ULL, 0x000e620000000800ULL, 0xffffffe003007812ULL, 0x000fe200078ee200ULL,
0x0000001dff087e24ULL, 0x000fc6000f8e00ffULL, 0x0000001400057c11ULL, 0x000fe4000f8e20ffULL,
0x00000000040d72caULL, 0x002fda00000e0000ULL, 0x0000000d040e72a4ULL, 0x000fc8000f8e020eULL,
0x000002000e0e78a5ULL, 0x000fcc000f8e000aULL, 0x0000000e07027c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001d090e7290ULL, 0x000fc8000fffe03fULL, 0x0000000fff037e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000060c00788cULL, 0x000fe4000bf03070ULL,
0x01ca1411ff007984ULL, 0x000ea20008000800ULL, 0x0000002008037824ULL, 0x002fe200078e00ffULL,
0x0000000800047c11ULL, 0x004fe2000f8e10ffULL, 0x0000001d06007c36ULL, 0x000fe20008000000ULL,
0x00000006181d7890ULL, 0x000fc8000fffe03fULL, 0x01cac00004047984ULL, 0x000e620000000800ULL,
0xffffffe003007812ULL, 0x000fe200078ee200ULL, 0x0000001dff087e24ULL, 0x000fc6000f8e00ffULL,
0x0000001400057c11ULL, 0x000fe4000f8e20ffULL, 0x00000000040d72caULL, 0x002fda00000e0000ULL,
0x0000000d040e72a4ULL, 0x000fc8000f8e020eULL, 0x000002000e0e78a5ULL, 0x000fcc000f8e000aULL,
0x0000000e07027c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001d090e7290ULL, 0x000fc6000fffe03fULL,
0x0000000fff037c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000070c00788cULL, 0x000fe4000bf03070ULL, 0x01ca1811ff007984ULL, 0x000ea20008000800ULL,
0x0000002008037824ULL, 0x002fe200078e00ffULL, 0x0000000800047c11ULL, 0x004fe2000f8e10ffULL,
0x0000001d06007c36ULL, 0x000fca0008000000ULL, 0x01cac00004047984ULL, 0x000e620000000800ULL,
0xffffffe003007812ULL, 0x000fc800078ee200ULL, 0x0000001400057c11ULL, 0x000fe4000f8e20ffULL,
0x00000000040d72caULL, 0x002fda00000e0000ULL, 0x0000000d040e72a4ULL, 0x000fc8000f8e020eULL,
0x000002000e0e78a5ULL, 0x000fcc000f8e000aULL, 0x0000000e07027c10ULL, 0x000fca000ff1e0ffULL,
0x0000000fff037e24ULL, 0x000fe200080e06ffULL, 0x00000007180f7890ULL, 0x000fc8000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c901c52ULL,
0x0000000f090e7290ULL, 0x000fe4000fffe03fULL, 0x0000000fff087e24ULL, 0x000fe2000f8e00ffULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x01ca1c11ff007984ULL, 0x000ea40008000800ULL,
0x0000002008037824ULL, 0x002fe200078e00ffULL, 0x0000000800047c11ULL, 0x004fe2000f8e10ffULL,
0x0000000f06007c36ULL, 0x000fca0008000000ULL, 0x01cac00004047984ULL, 0x000e620000000800ULL,
0xffffffe003007812ULL, 0x000fc800078ee200ULL, 0x0000001400057c11ULL, 0x000fe4000f8e20ffULL,
0x00000000040d72caULL, 0x002fda00000e0000ULL, 0x0000000d040d72a4ULL, 0x000fc8000f8e020eULL,
0x000002000d0a78a5ULL, 0x000fcc000f8e000aULL, 0x0000000a07027c10ULL, 0x000fc8000ff1e0ffULL,
0x0000000bff037c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c901c52ULL, 0x0000000800387947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00014000080a7890ULL, 0x000fe2000fffe03fULL,
0x000000180d007c11ULL, 0x042fe2000f8fd8ffULL, 0x000000100d067824ULL, 0x000fc600078e00ffULL,
0x00000008000a7c11ULL, 0x000fe2000f8e10ffULL, 0x0000000900057c36ULL, 0x000fe20008000000ULL,
0x000001f0060f7812ULL, 0x000fe200078ec0ffULL, 0x0000000100077824ULL, 0x040fe400078e020dULL,
0x01ca00000a027984ULL, 0x000e620000000800ULL, 0x00000020000c7824ULL, 0x000fe200078e00ffULL,
0x0000000802087c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff027b82ULL, 0x000e660000000a00ULL,
0x01cac00008047984ULL, 0x0004e40000000800ULL, 0x0000000100087836ULL, 0x004fc80000000000ULL,
0x00000020080e7824ULL, 0x000fe200078e00ffULL, 0x0000000d08097210ULL, 0x000fe20007ffe0ffULL,
0x0000000404057c24ULL, 0x008fc8000f8e0205ULL, 0x0000020005047825ULL, 0x002fc600078e0002ULL,
0x0000000f04067210ULL, 0x000fe40007f1e0ffULL, 0xffffffe00c047812ULL, 0x000fc600078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000000a040b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000908057c36ULL, 0x000fc80008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e8000b901c52ULL, 0x01ca04000a047984ULL, 0x000ea20000000800ULL,
0x0000000200067836ULL, 0x002fc80000000000ULL, 0x0000000106077824ULL, 0x000fe200078e020dULL,
0x00000008040c7c11ULL, 0x004fca000f8e10ffULL, 0x01cac0000c047984ULL, 0x000e640000000800ULL,
0x0000000404057c24ULL, 0x002fc8000f8e0205ULL, 0x0000020005047825ULL, 0x000fc600078e0002ULL,
0x0000000f04087210ULL, 0x000fe40007f1e0ffULL, 0xffffffe00e047812ULL, 0x000fe200078ee209ULL,
0x00000020060e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000000a040b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000906057c36ULL, 0x000fc80008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c52ULL,
0x01ca08000a047984ULL, 0x000ea20000000800ULL, 0x0000000300087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e020dULL, 0x00000008040c7c11ULL, 0x004fca000f8e10ffULL,
0x01cac0000c047984ULL, 0x000e640000000800ULL, 0x0000000404057c24ULL, 0x002fc8000f8e0205ULL,
0x0000020005047825ULL, 0x000fc600078e0002ULL, 0x0000000f04067210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00e047812ULL, 0x000fe200078ee207ULL, 0x00000020080e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000000a040b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000908057c36ULL, 0x000fc80008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e8000b901c52ULL, 0x01ca0c000a047984ULL, 0x000ea20000000800ULL,
0x0000000400067836ULL, 0x002fc80000000000ULL, 0x0000000106077824ULL, 0x000fe200078e020dULL,
0x00000008040c7c11ULL, 0x004fca000f8e10ffULL, 0x01cac0000c047984ULL, 0x000e640000000800ULL,
0x0000000404057c24ULL, 0x002fc8000f8e0205ULL, 0x0000020005047825ULL, 0x000fc600078e0002ULL,
0x0000000f04087210ULL, 0x000fe40007f1e0ffULL, 0xffffffe00e047812ULL, 0x000fe400078ee209ULL,
0x00000005060e7819ULL, 0x000fe200000006ffULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000000a040b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000906057c36ULL, 0x000fc80008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c52ULL,
0x01ca10000a047984ULL, 0x000ea20000000800ULL, 0x0000000500087836ULL, 0x002fc80000000000ULL,
0x0000000108097824ULL, 0x000fe200078e020dULL, 0x00000008040c7c11ULL, 0x004fca000f8e10ffULL,
0x01cac0000c047984ULL, 0x000e640000000800ULL, 0x0000000404057c24ULL, 0x002fc8000f8e0205ULL,
0x0000020005047825ULL, 0x000fc600078e0002ULL, 0x0000000f04067210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00e047812ULL, 0x000fe200078ee207ULL, 0x00000020080e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000000a040b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000908057c36ULL, 0x000fc80008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e8000b901c52ULL, 0x01ca14000a047984ULL, 0x000ea20000000800ULL,
0x0000000600067836ULL, 0x002fe40000000000ULL, 0x0000000700007836ULL, 0x000fe40000000000ULL,
0x00000001060b7824ULL, 0x000fe200078e020dULL, 0x00000008040c7c11ULL, 0x004fca000f8e10ffULL,
0x01cac0000c047984ULL, 0x000e640000000800ULL, 0x0000000404057c24ULL, 0x002fc8000f8e0205ULL,
0x0000020005047825ULL, 0x000fc600078e0002ULL, 0x0000000f04087210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00e047812ULL, 0x000fc600078ee209ULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000000a04077c11ULL, 0x000fe4000f8e20ffULL, 0x0000000906057c10ULL, 0x000fe2000fffe0ffULL,
0x0000002006067824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008077faeULL, 0x0003e6000b901c52ULL, 0xffffffe0060b7812ULL, 0x000fe200078ee20bULL,
0x01ca18000a047984ULL, 0x000ea60000000800ULL, 0x0000000a0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000900077c36ULL, 0x002fe20008000000ULL, 0x00000008040c7c11ULL, 0x004fca000f8e10ffULL,
0x01cac0000c047984ULL, 0x000e640000000800ULL, 0x0000000404057c24ULL, 0x002fc8000f8e0205ULL,
0x0000020005047825ULL, 0x000fc600078e0002ULL, 0x0000000f04047210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000b901c52ULL, 0x01ca1c000a0a7984ULL, 0x000ea40000000800ULL,
0x000000080a087c11ULL, 0x004fca000f8e10ffULL, 0x01cac00008067984ULL, 0x000ea40000000800ULL,
0x0000000406077c24ULL, 0x004fe4000f8e0207ULL, 0x0000000100067824ULL, 0x000fe400078e020dULL,
0x0000020007027825ULL, 0x000fc800078e0002ULL, 0x0000002000077824ULL, 0x000fe200078e00ffULL,
0x0000000f02027210ULL, 0x000fc80007f1e0ffULL, 0xffffffe007067812ULL, 0x000fe400078ee206ULL,
0x00000003ff037210ULL, 0x000fe400007fe4ffULL, 0x0000000a06057c11ULL, 0x002fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000b901c52ULL,
0x00000001ff027424ULL, 0x002fcc00078e00ffULL, 0x01cb8802ff0279a7ULL, 0x000e640008500008ULL,
0x000000ffff067224ULL, 0x002fe200078e0003ULL, 0x0000000000027805ULL, 0x000fc60000015200ULL,
0x01cb8806ff0075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01cb8806ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000000005a7919ULL, 0x000e620000000000ULL,
0x00000015ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0001cb78081d7890ULL, 0x000fe2000fffe03fULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x0000005a03007211ULL, 0x002fc800078e28ffULL, 0x0000001f0000780cULL, 0x000fda0003f04070ULL,
0x0000000000340947ULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x000e620000000a00ULL,
0x0000002010047890ULL, 0x000fe2000fffe03fULL, 0x0000000800077c11ULL, 0x000fe2000f8e10ffULL,
0x00009400000a7ab9ULL, 0x000fc80000000800ULL, 0x0000000400057c36ULL, 0x000fe20008000000ULL,
0x0000000a1b0472a4ULL, 0x000fc8000f8e0204ULL, 0x0000001a05007c0cULL, 0x000fe4000bf06070ULL,
0x0000000400057c36ULL, 0x000fc80008000000ULL, 0x0000000405027825ULL, 0x002fce00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1ca0000002077faeULL, 0x0003e4000c121852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a5dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x01cb7804ff0279a7ULL, 0x0024e20008500008ULL, 0x000000051900728cULL, 0x000fe2000bf06070ULL,
0xff317217ff117424ULL, 0x000fe200078e00ffULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000000000567805ULL, 0x000fe4000001ff00ULL,
0x0000000000547805ULL, 0x000fc4000001ff00ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x01cb8804ff0479a7ULL, 0x004ea20008500008ULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x000000ff004d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x0000000000487805ULL, 0x000fc4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000087805ULL, 0x000fe4000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff5c7224ULL, 0x008fe400078e0003ULL, 0x000000ffff037224ULL, 0x000fe400078e00ffULL,
0x000000ffff187224ULL, 0x004fe200078e0005ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000013400a80947ULL, 0x002fec0003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0xff317217ff117424ULL, 0x000fe200078e00ffULL,
0x000000070a0a7899ULL, 0x000fd8000800063fULL, 0x0000000819047899ULL, 0x000fc8000800063fULL,
0x0000001a0400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000013400780947ULL, 0x002fea0003800000ULL, 0x0000003f00047c82ULL, 0x000fca0008000000ULL,
0x000000023f0b7899ULL, 0x000fe40008011604ULL, 0x000000190700728cULL, 0x000fe4000bf24070ULL,
0x00000003040e7892ULL, 0x000fe4000f8ec03fULL, 0x0000000b040b7287ULL, 0x000fe40008800000ULL,
0x0000003f0e0e7287ULL, 0x000fe4000c800000ULL, 0x000000023f107899ULL, 0x000fc4000801160bULL,
0x000000030b0f7892ULL, 0x000fe4000f8ec03fULL, 0x00000016101072a4ULL, 0x000fe2000f8e0219ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb785cff0075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x002ff00003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fc800078110ffULL, 0x00000017ff177210ULL, 0x000fc800007fe4ffULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb785cff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb8818ff0075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb8818ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000001100d7890ULL, 0x000fe4000fffe03fULL, 0x0000000f100c7291ULL, 0x000fe4000f8e103fULL,
0x000000050d00728cULL, 0x000fe4000bf06070ULL, 0x000000200c147891ULL, 0x000fc8000f8e303fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000006009117892ULL, 0x000fd8000f8ef814ULL,
0x0000000800c88947ULL, 0x000fea0003800000ULL, 0x0000000818207291ULL, 0x000fe4000f8e103fULL,
0x00000018ff167e24ULL, 0x000fe2000f8e00ffULL, 0x000000141a00728cULL, 0x000fe2000bf01070ULL,
0x000000185a157c10ULL, 0x000fe2000fffe0ffULL, 0x00000011181f7290ULL, 0x000fe2000fffe03fULL,
0x0000002016167824ULL, 0x000fe200078e00ffULL, 0x000000141a0c7287ULL, 0x000fe4000c000000ULL,
0x0001800008217890ULL, 0x000fe2000fffe03fULL, 0x01ca0020ff147984ULL, 0x000e620008000800ULL,
0x0000000c14147290ULL, 0x000fe2000fffe13fULL, 0xffffffe016177812ULL, 0x000fe200078ee215ULL,
0x0000000118227890ULL, 0x000fc4000fffe03fULL, 0x000000141800728cULL, 0x000fe2000bf01070ULL,
0x0000002117177c11ULL, 0x000fe2000f8e20ffULL, 0x00008a00000c7ab9ULL, 0x000fe40000000a00ULL,
0x0000001418147287ULL, 0x000fe2000c000000ULL, 0x00000022ff197e24ULL, 0x000fc6000f8e00ffULL,
0x0000001418147290ULL, 0x000fe2000fffe13fULL, 0x00000020191a7824ULL, 0x000fc600078e00ffULL,
0x000000011400788cULL, 0x000fe4000bf03070ULL, 0x00000014ff007c0cULL, 0x000fe4000bf06070ULL,
0x0000000814147c11ULL, 0x002fcc000f8e10ffULL, 0x01cac00014147984ULL, 0x000e640000000800ULL,
0x00000000141e72caULL, 0x002fe200000e0000ULL, 0x000000105a147824ULL, 0x000fca00078e00ffULL,
0x000001f014187812ULL, 0x000fce00078ec0ffULL, 0x0000001e0a1e72a4ULL, 0x000fc8000f8e021fULL,
0x000002001e1e78a5ULL, 0x000fcc000f8e000cULL, 0x0000001e18147c10ULL, 0x000fca000ff3e0ffULL,
0x0000001fff157e24ULL, 0x000fe200088e06ffULL, 0x00000011221f7290ULL, 0x000fe2000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000021400788cULL, 0x000fe4000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000c101c52ULL,
0x01ca0420ff167984ULL, 0x000ea20008000800ULL, 0x000000225a157c36ULL, 0x002fe20008000000ULL,
0x0000000218227890ULL, 0x000fc8000fffe03fULL, 0xffffffe01a177812ULL, 0x000fe400078ee215ULL,
0x00000022ff197e24ULL, 0x000fe4000f8e00ffULL, 0x0000002117177c11ULL, 0x000fe4000f8e20ffULL,
0x00000020191a7824ULL, 0x000fe200078e00ffULL, 0x0000000816167c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00016167984ULL, 0x000e640000000800ULL, 0x00000000161e72caULL, 0x002fda00000e0000ULL,
0x0000001e0a1e72a4ULL, 0x000fc8000f8e021fULL, 0x000002001e1e78a5ULL, 0x000fcc000f8e000cULL,
0x0000001e18147c10ULL, 0x000fca000ff1e0ffULL, 0x0000001fff157e24ULL, 0x000fe200080e06ffULL,
0x00000011221f7290ULL, 0x000fc8000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000031400788cULL, 0x000fe4000bf03070ULL, 0x01ca0820ff167984ULL, 0x000ea20008000800ULL,
0x000000225a157c10ULL, 0x002fe2000fffe0ffULL, 0x0000000318227890ULL, 0x000fc6000fffe03fULL,
0xffffffe01a177812ULL, 0x000fc600078ee215ULL, 0x00000022ff197e24ULL, 0x000fe2000f8e00ffULL,
0x0000002117177c11ULL, 0x000fc6000f8e20ffULL, 0x00000020191a7824ULL, 0x000fe200078e00ffULL,
0x0000000816167c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00016167984ULL, 0x000e640000000800ULL,
0x00000000161e72caULL, 0x002fda00000e0000ULL, 0x0000001e0a1e72a4ULL, 0x000fc8000f8e021fULL,
0x000002001e1e78a5ULL, 0x000fcc000f8e000cULL, 0x0000001e18147c10ULL, 0x000fca000ff1e0ffULL,
0x0000001fff157e24ULL, 0x000fe200080e06ffULL, 0x00000011221f7290ULL, 0x000fc8000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000041400788cULL, 0x000fe4000bf03070ULL,
0x01ca0c20ff167984ULL, 0x000ea20008000800ULL, 0x000000225a157c36ULL, 0x002fe20008000000ULL,
0x0000000418227890ULL, 0x000fc8000fffe03fULL, 0xffffffe01a177812ULL, 0x000fe400078ee215ULL,
0x00000022ff197e24ULL, 0x000fe4000f8e00ffULL, 0x0000002117177c11ULL, 0x000fe4000f8e20ffULL,
0x00000020191a7824ULL, 0x000fe200078e00ffULL, 0x0000000816167c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00016167984ULL, 0x000e640000000800ULL, 0x00000000161e72caULL, 0x002fda00000e0000ULL,
0x0000001e0a1e72a4ULL, 0x000fc8000f8e021fULL, 0x000002001e1e78a5ULL, 0x000fcc000f8e000cULL,
0x0000001e18147c10ULL, 0x000fca000ff1e0ffULL, 0x0000001fff157e24ULL, 0x000fe200080e06ffULL,
0x00000011221f7290ULL, 0x000fc8000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000051400788cULL, 0x000fe4000bf03070ULL, 0x01ca1020ff167984ULL, 0x000ea20008000800ULL,
0x000000225a157c10ULL, 0x002fe2000fffe0ffULL, 0x0000000518227890ULL, 0x000fc6000fffe03fULL,
0xffffffe01a177812ULL, 0x000fc600078ee215ULL, 0x00000022ff197e24ULL, 0x000fe2000f8e00ffULL,
0x0000002117177c11ULL, 0x000fc6000f8e20ffULL, 0x00000020191a7824ULL, 0x000fe200078e00ffULL,
0x0000000816167c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00016167984ULL, 0x000e640000000800ULL,
0x00000000161e72caULL, 0x002fda00000e0000ULL, 0x0000001e0a1e72a4ULL, 0x000fc8000f8e021fULL,
0x000002001e1e78a5ULL, 0x000fcc000f8e000cULL, 0x0000001e18147c10ULL, 0x000fca000ff1e0ffULL,
0x0000001fff157e24ULL, 0x000fe200080e06ffULL, 0x00000011221f7290ULL, 0x000fc8000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000061400788cULL, 0x000fe4000bf03070ULL,
0x01ca1420ff167984ULL, 0x000ea20008000800ULL, 0x000000225a157c36ULL, 0x002fe20008000000ULL,
0x0000000618227890ULL, 0x000fc8000fffe03fULL, 0xffffffe01a177812ULL, 0x000fe400078ee215ULL,
0x00000022ff197e24ULL, 0x000fe4000f8e00ffULL, 0x0000002117177c11ULL, 0x000fe4000f8e20ffULL,
0x00000020191a7824ULL, 0x000fe200078e00ffULL, 0x0000000816167c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00016167984ULL, 0x000e640000000800ULL, 0x00000000161e72caULL, 0x002fda00000e0000ULL,
0x0000001e0a1e72a4ULL, 0x000fc8000f8e021fULL, 0x000002001e1e78a5ULL, 0x000fcc000f8e000cULL,
0x0000001e18147c10ULL, 0x000fca000ff1e0ffULL, 0x0000001fff157e24ULL, 0x000fe200080e06ffULL,
0x00000011221f7290ULL, 0x000fc8000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000071400788cULL, 0x000fe4000bf03070ULL, 0x01ca1820ff167984ULL, 0x000ea20008000800ULL,
0x000000225a157c10ULL, 0x002fc8000fffe0ffULL, 0xffffffe01a177812ULL, 0x000fc800078ee215ULL,
0x0000002117177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000816167c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00016167984ULL, 0x000e640000000800ULL, 0x00000000161e72caULL, 0x002fda00000e0000ULL,
0x0000001e0a1e72a4ULL, 0x000fc8000f8e021fULL, 0x000002001e1e78a5ULL, 0x000fcc000f8e000cULL,
0x0000001e18147c10ULL, 0x000fca000ff1e0ffULL, 0x0000001fff157e24ULL, 0x000fe200080e06ffULL,
0x00000007181f7890ULL, 0x000fc8000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c901c52ULL, 0x000000111f117290ULL, 0x000fe4000fffe03fULL,
0x0000001fff197e24ULL, 0x000fe2000f8e00ffULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x01ca1c20ff167984ULL, 0x000ea40008000800ULL, 0x00000020191a7824ULL, 0x000fe400078e00ffULL,
0x0000001f5a157c36ULL, 0x002fca0008000000ULL, 0xffffffe01a177812ULL, 0x000fc800078ee215ULL,
0x0000002117177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000816167c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00016167984ULL, 0x000e640000000800ULL, 0x00000000161e72caULL, 0x002fda00000e0000ULL,
0x0000001e0a1172a4ULL, 0x000fc8000f8e0211ULL, 0x00000200110c78a5ULL, 0x000fcc000f8e000cULL,
0x0000000c18147c10ULL, 0x000fca000ff1e0ffULL, 0x0000000dff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c901c52ULL,
0x0000000800347947ULL, 0x000fea0003800000ULL, 0x000000185a177c11ULL, 0x040fe2000f8fd8ffULL,
0x00018000080c7890ULL, 0x000fe2000fffe03fULL, 0x000000045a1a7819ULL, 0x000fe400000006ffULL,
0x0000000817187c11ULL, 0x040fe2000f8e10ffULL, 0x0000001117197c36ULL, 0x000fe40008000000ULL,
0x0000002017207824ULL, 0x000fe400078e00ffULL, 0x01ca000018147984ULL, 0x000e620000000800ULL,
0x00000001171f7836ULL, 0x000fc80000000000ULL, 0x000000011f217824ULL, 0x040fe400078e025aULL,
0x000000201f227824ULL, 0x000fe200078e00ffULL, 0x00000008141e7c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x01cac0001e167984ULL, 0x000ea40000000800ULL,
0x0000000a16197c24ULL, 0x004fe2000f8e0219ULL, 0x000001f01a167812ULL, 0x000fc600078ec0ffULL,
0x00000200191a7825ULL, 0x002fc800078e0014ULL, 0x0000000117197824ULL, 0x000fe200078e025aULL,
0x000000161a1c7210ULL, 0x000fc80007f1e0ffULL, 0xffffffe020197812ULL, 0x000fe200078ee219ULL,
0x000000ffff1d7224ULL, 0x000fe400000e061bULL, 0x000000111f1b7c36ULL, 0x000fe20008000000ULL,
0x0000000c19197c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c197faeULL, 0x0003e8000b901c52ULL, 0x01ca0400181a7984ULL, 0x000ea20000000800ULL,
0xffffffe022197812ULL, 0x002fe200078ee221ULL, 0x00000002171d7836ULL, 0x000fc60000000000ULL,
0x0000000c19197c11ULL, 0x000fe2000f8e20ffULL, 0x000000011d217824ULL, 0x040fe400078e025aULL,
0x000000201d227824ULL, 0x000fe200078e00ffULL, 0x000000081a207c11ULL, 0x004fca000f8e10ffULL,
0x01cac000201a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1b7c24ULL, 0x002fc8000f8e021bULL,
0x000002001b1a7825ULL, 0x000fc600078e0014ULL, 0x000000161a1e7210ULL, 0x000fc80007f1e0ffULL,
0x0000001bff1f7210ULL, 0x000fe200007fe4ffULL, 0x000000111d1b7c36ULL, 0x000fc80008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e197faeULL, 0x0003e8000b901c52ULL,
0x01ca0800181a7984ULL, 0x000ea20000000800ULL, 0xffffffe022197812ULL, 0x002fe200078ee221ULL,
0x00000003171f7836ULL, 0x000fc60000000000ULL, 0x0000000c19197c11ULL, 0x000fe2000f8e20ffULL,
0x000000201f227824ULL, 0x000fe200078e00ffULL, 0x0000005a1f217210ULL, 0x000fe40007ffe0ffULL,
0x000000081a207c11ULL, 0x004fca000f8e10ffULL, 0x01cac000201a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1b7c24ULL, 0x002fc8000f8e021bULL, 0x000002001b1a7825ULL, 0x000fc600078e0014ULL,
0x000000161a1c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fe400000e061bULL,
0x000000111f1b7c36ULL, 0x000fc60008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c197faeULL, 0x0003e8000b901c52ULL, 0x01ca0c00181a7984ULL, 0x000ea20000000800ULL,
0xffffffe022197812ULL, 0x002fe200078ee221ULL, 0x00000004171d7836ULL, 0x000fc60000000000ULL,
0x0000000c19197c11ULL, 0x000fe2000f8e20ffULL, 0x000000011d217824ULL, 0x040fe400078e025aULL,
0x000000201d227824ULL, 0x000fe200078e00ffULL, 0x000000081a207c11ULL, 0x004fca000f8e10ffULL,
0x01cac000201a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1b7c24ULL, 0x002fc8000f8e021bULL,
0x000002001b1a7825ULL, 0x000fc600078e0014ULL, 0x000000161a1e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe400000e061bULL, 0x000000111d1b7c36ULL, 0x000fc60008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e197faeULL, 0x0003e8000b901c52ULL,
0x01ca1000181a7984ULL, 0x000ea20000000800ULL, 0xffffffe022197812ULL, 0x002fe400078ee221ULL,
0x00000005171f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c19197c11ULL, 0x000fc6000f8e20ffULL,
0x000000011f217824ULL, 0x040fe400078e025aULL, 0x000000201f227824ULL, 0x000fe200078e00ffULL,
0x000000081a207c11ULL, 0x004fca000f8e10ffULL, 0x01cac000201a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1b7c24ULL, 0x002fc8000f8e021bULL, 0x000002001b1a7825ULL, 0x000fc600078e0014ULL,
0x000000161a1c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fe400000e061bULL,
0x000000111f1b7c36ULL, 0x000fc60008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c197faeULL, 0x0003e8000b901c52ULL, 0x01ca1400181a7984ULL, 0x000ea20000000800ULL,
0xffffffe022197812ULL, 0x002fe200078ee221ULL, 0x00000006171d7836ULL, 0x000fc60000000000ULL,
0x0000000c19197c11ULL, 0x000fe4000f8e20ffULL, 0x000000081a207c11ULL, 0x004fca000f8e10ffULL,
0x01cac000201a7984ULL, 0x0002a40000000800ULL, 0x000000011d207824ULL, 0x002fe400078e025aULL,
0x0000000a1a1b7c24ULL, 0x004fc8000f8e021bULL, 0x000002001b1a7825ULL, 0x000fc600078e0014ULL,
0x000000161a1e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe400000e061bULL,
0x000000111d1b7c36ULL, 0x000fe20008000000ULL, 0x000000051d1d7819ULL, 0x000fe400000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e197faeULL, 0x0003e8000b901c52ULL,
0x01ca1800181a7984ULL, 0x000ea20000000800ULL, 0xffffffe01d197812ULL, 0x002fe200078ee220ULL,
0x00000007171d7836ULL, 0x000fc60000000000ULL, 0x0000000c19197c11ULL, 0x000fe2000f8e20ffULL,
0x000000111d177c36ULL, 0x000fe40008000000ULL, 0x000000201d1e7824ULL, 0x000fe200078e00ffULL,
0x000000081a1c7c11ULL, 0x004fca000f8e10ffULL, 0x01cac0001c1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1b7c24ULL, 0x002fc8000f8e021bULL, 0x000002001b1a7825ULL, 0x000fc600078e0014ULL,
0x000000161a1a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a197faeULL, 0x0003e8000b901c52ULL,
0x01ca1c0018187984ULL, 0x000ea40000000800ULL, 0x00000008181c7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001c1c7984ULL, 0x000ea40000000800ULL, 0x0000000a1c177c24ULL, 0x004fc8000f8e0217ULL,
0x0000020017147825ULL, 0x000fc800078e0014ULL, 0x000000011d177824ULL, 0x000fe200078e025aULL,
0x0000001614167210ULL, 0x000fc80007f1e0ffULL, 0xffffffe01e147812ULL, 0x000fe200078ee217ULL,
0x000000ffff177224ULL, 0x000fc600000e0615ULL, 0x0000000c14157c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e4000b901c52ULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x01cb8814ff1479a7ULL, 0x000e640008500008ULL,
0x0000001500187202ULL, 0x002fe40000000f00ULL, 0x0000000000147805ULL, 0x000fe40000015200ULL,
0x01cb8818ff0075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb8818ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000100700728cULL, 0x000fe4000bf04070ULL,
0x000000010b0b7892ULL, 0x000fe4000f8ec03fULL, 0x000000030e00788cULL, 0x000fc8000c705270ULL,
0x000000010b00788cULL, 0x000fcc0008705470ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000680947ULL, 0x000fea0003800000ULL, 0x00000015ff157e24ULL, 0x000fe2000f8e00ffULL,
0x000000011c0c7892ULL, 0x000fe2000f8ec03fULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0xffffffff160b7891ULL, 0x000fe2000f8e083fULL, 0x0000002015167824ULL, 0x000fe200078e025aULL,
0x000000010c00788cULL, 0x000fc8000bf05070ULL, 0x000000031600780cULL, 0x000fe20003f04070ULL,
0x000000010b0b7887ULL, 0x000fc8000c000000ULL, 0x0000000b1c1c7290ULL, 0x000fd0000fffe03fULL,
0x00000000003c0947ULL, 0x000fea0003800000ULL, 0x00008c00ff147b82ULL, 0x000e620000000a00ULL,
0x00009000000b7ab9ULL, 0x000fe20000000800ULL, 0x000000061c00728cULL, 0x000fe2000bf06070ULL,
0x0000000479177824ULL, 0x000fe200078e0216ULL, 0x0000000b1c0c7290ULL, 0x000fe2000fffe03fULL,
0x0000000816197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000117177819ULL, 0x000fe400000006ffULL,
0x0000000cff187e24ULL, 0x000fe2000f8e00ffULL, 0x000000000000781cULL, 0x000fc60003f0f008ULL,
0x0000000b17177c24ULL, 0x000fc8000f8e0218ULL, 0x0000000417147825ULL, 0x002fcc00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1cac000014197faeULL, 0x0003e4000c121852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100700728cULL, 0x000fe2000bf04070ULL,
0x00000015ff677e24ULL, 0x000fe2000f8e00ffULL, 0x000000010e0e7890ULL, 0x000fe2000fffe03fULL,
0x000001c000007945ULL, 0x000fe20003800000ULL, 0x0001cb80081e7890ULL, 0x000fe2000fffe03fULL,
0x0000002067677824ULL, 0x000fe200078e025aULL, 0x000000030e0b7892ULL, 0x000fe2000f8ec03fULL,
0x00000001ff697424ULL, 0x000fc600078e00ffULL, 0x0000001f6700780cULL, 0x000fe20003f44070ULL,
0x000000023f0e8899ULL, 0x000fe4000801160eULL, 0x0000003f0b0d7287ULL, 0x000fe4000c000000ULL,
0x0000000e0f0e7290ULL, 0x000fc8000fffe03fULL, 0x000000023f0c7899ULL, 0x000fe4000801160eULL,
0x000000060e0e7899ULL, 0x000fe4000800063fULL, 0x000000160c0c72a4ULL, 0x000fe4000f8e0210ULL,
0x000000c00e0e7892ULL, 0x000fc8000f8ec03fULL, 0x0000000e0c0c7291ULL, 0x000fe2000f8e403fULL,
0x0000000000342947ULL, 0x000ff60003800000ULL, 0x00009200ff147b82ULL, 0x002e620000000a00ULL,
0x0000000d1b0b7290ULL, 0x000fe2000fffe03fULL, 0x0000000c67167c36ULL, 0x000fe20008000000ULL,
0x00009400000e7ab9ULL, 0x000fe20000000800ULL, 0x0000000867197c11ULL, 0x000fe2000f8e10ffULL,
0x0000000e0b0b72a4ULL, 0x000fe4000f8e020cULL, 0x0000001a16007c0cULL, 0x000fc8000bf06070ULL,
0x0000000b67177c36ULL, 0x000fc80008000000ULL, 0x0000000417147825ULL, 0x002fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1ca0000014197faeULL, 0x0003e4000c121852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a5eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x01cb8069ff1479a7ULL, 0x000e620008500008ULL, 0x00000004ff007c0cULL, 0x000fe2000bf05270ULL,
0x000000ffff4c7224ULL, 0x002fd800078e0015ULL, 0x0000000400940947ULL, 0x000fea0003800000ULL,
0x01cad869761479a7ULL, 0x000e640008500008ULL, 0x00000015001b7202ULL, 0x002fe40000000f00ULL,
0x0000000000147805ULL, 0x000fe40000015200ULL, 0x01cad81b760075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x01cad81b760075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000105a147824ULL, 0x000fe200078e00ffULL, 0x00000001ff157819ULL, 0x000fe2000001165aULL,
0x00000001ff657424ULL, 0x000fc600078e00ffULL, 0x0000007014147812ULL, 0x000fe400078ec0ffULL,
0x0000000c15157812ULL, 0x000fc800078ec0ffULL, 0x0000000815147c10ULL, 0x000fca000fffe014ULL,
0x01c0000014167984ULL, 0x000e680000000800ULL, 0x01c2000014177984ULL, 0x0004a20000000800ULL,
0x000000111600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15197812ULL, 0x000fe2000780c0ffULL, 0x000000ffff157224ULL, 0x000fd800078e0011ULL,
0x0000000000e88947ULL, 0x004fea0003800000ULL, 0x000000111600720bULL, 0x000fe40003f14000ULL,
0x00000015ff007c0cULL, 0x000fe4000bf25270ULL, 0x0000001611157209ULL, 0x000fd20007810000ULL,
0x00000000001a7806ULL, 0x000fe400000e0100ULL, 0x01c4001514009388ULL, 0x0003e40000000800ULL,
0x000099101a187816ULL, 0x000fc800000000ffULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000001511117221ULL, 0x000fe20000010000ULL,
0x000000ff1aff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001aff7812ULL, 0x000fe2000782c0ffULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100147308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x002fcc000001165aULL,
0x00001f1114117589ULL, 0x004e6400000e0000ULL, 0x0000001103037220ULL, 0x082fe20000410000ULL,
0x0000001104047220ULL, 0x080fe20000410000ULL, 0x0000001107077220ULL, 0x080fe20000410000ULL,
0x0000001108087220ULL, 0x080fe20000410000ULL, 0x000000110b0b7220ULL, 0x080fe20000410000ULL,
0x000000110c0c7220ULL, 0x080fe20000410000ULL, 0x000000110f0f7220ULL, 0x080fe20000410000ULL,
0x0000001112127220ULL, 0x080fe20000410000ULL, 0x0000001149497220ULL, 0x080fe20000410000ULL,
0x000000114a4a7220ULL, 0x080fe20000410000ULL, 0x000000114f4f7220ULL, 0x080fe20000410000ULL,
0x0000001150507220ULL, 0x080fe20000410000ULL, 0x0000001153537220ULL, 0x080fe20000410000ULL,
0x0000001154547220ULL, 0x080fe20000410000ULL, 0x0000001157577220ULL, 0x080fe20000410000ULL,
0x0000001158587220ULL, 0x000fce0000410000ULL, 0x000000145b5b7220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000085a117811ULL, 0x002fcc00078ff0ffULL,
0x00001f1114117589ULL, 0x000e6400000e0000ULL, 0x0000001105057220ULL, 0x082fe20000410000ULL,
0x0000001106067220ULL, 0x080fe20000410000ULL, 0x0000001109097220ULL, 0x080fe20000410000ULL,
0x000000110a0a7220ULL, 0x080fe20000410000ULL, 0x000000110d0d7220ULL, 0x080fe20000410000ULL,
0x000000110e0e7220ULL, 0x080fe20000410000ULL, 0x0000001113137220ULL, 0x080fe20000410000ULL,
0x0000001148487220ULL, 0x080fe20000410000ULL, 0x000000114d4d7220ULL, 0x080fe20000410000ULL,
0x000000114e4e7220ULL, 0x080fe20000410000ULL, 0x0000001151517220ULL, 0x080fe20000410000ULL,
0x0000001152527220ULL, 0x080fe20000410000ULL, 0x0000001155557220ULL, 0x080fe20000410000ULL,
0x0000001156567220ULL, 0x080fe20000410000ULL, 0x0000001159597220ULL, 0x080fe20000410000ULL,
0x0000001110107220ULL, 0x000fce0000410000ULL, 0x0000ffff19ff7812ULL, 0x000fda000780601aULL,
0x8000001516160221ULL, 0x000fe20000010000ULL, 0x00007610ff650816ULL, 0x000fc60000000065ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x00000016005e0308ULL, 0x000ea40000000800ULL,
0x0000005e17170220ULL, 0x004fce0000410000ULL, 0x0000005b175b7221ULL, 0x000fe20000010000ULL,
0x0000001500117202ULL, 0x002fce0000000f00ULL, 0x000000075a157812ULL, 0x040fe400078ec0ffULL,
0x000000ff65ff7812ULL, 0x000fe4000788c0ffULL, 0x0000000815647812ULL, 0x000fe400078ef85aULL,
0x000000085a4b7812ULL, 0x040fe400078ec0ffULL, 0x000000645a637211ULL, 0x000fe200078fe0ffULL,
0x0000000864147824ULL, 0x000fe200078e00ffULL, 0x000000185a687c11ULL, 0x000fc4000f8fe0ffULL,
0x000000074b4b7812ULL, 0x000fe400078ef85aULL, 0xfffffff814757812ULL, 0x000fc600078ee263ULL,
0x000000014b167824ULL, 0x000fe200078e0268ULL, 0x0000000875757c11ULL, 0x000fe2000f8e20ffULL,
0x0000000000184947ULL, 0x000fec0003800000ULL, 0x00000002ff177819ULL, 0x000fe4000001165aULL,
0x0000005eff00723eULL, 0x000fc600000000ffULL, 0x0000000817157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f1714027589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x01200000751c783bULL, 0x0002e20000000200ULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x000000021c1c7232ULL, 0x08cfe40000000000ULL,
0x000000021e1e7232ULL, 0x000fe40000000000ULL, 0x000000001d1d7232ULL, 0x080fe40000000000ULL,
0x000000001f1f7232ULL, 0x000fce0000000000ULL, 0x00000002180c7890ULL, 0x000fe2000fffe03fULL,
0x000000204b157824ULL, 0x042fe200078e00ffULL, 0x00000004180b7890ULL, 0x000fe2000fffe03fULL,
0x000000204b177824ULL, 0x040fe200078e00ffULL, 0x000000104b417812ULL, 0x040fe200078efcffULL,
0x000000204b187824ULL, 0x040fe200078e00ffULL, 0x0000000c5a5d7c11ULL, 0x040fe2000f8fe0ffULL,
0x00014000080c7890ULL, 0x000fe2000fffe03fULL, 0x0000000b5a5c7c11ULL, 0x000fe2000f8fe0ffULL,
0x00000006180b7890ULL, 0x000fe2000fffe03fULL, 0xffffffe015167812ULL, 0x000fe200078ee216ULL,
0x000000014b147824ULL, 0x000fe200078e025dULL, 0x0000005c4b157210ULL, 0x000fe20007ffe0ffULL,
0x0000000864197824ULL, 0x000fe200078e00ffULL, 0x0000000c16747c11ULL, 0x000fe2000f8e20ffULL,
0x0000000168627824ULL, 0x100fe200078e0241ULL, 0xffffffe017147812ULL, 0x000fe200078ee214ULL,
0x00000020411a7824ULL, 0x000fe200078e00ffULL, 0xffffffe018157812ULL, 0x000fe200078ee215ULL,
0x000000007434783bULL, 0x000e620000004200ULL, 0x0000000b5a667c11ULL, 0x000fe2000f8fe0ffULL,
0x0000000263187836ULL, 0x000fe20000000000ULL, 0x0000000c14737c11ULL, 0x000fe2000f8e20ffULL,
0x000000015d617824ULL, 0x100fe200078e0241ULL, 0x0000000c15727c11ULL, 0x000fe2000f8e20ffULL,
0x000000204b157824ULL, 0x040fe200078e00ffULL, 0xfffffff819187812ULL, 0x000fe200078ee218ULL,
0x000000014b147824ULL, 0x000fe200078e0266ULL, 0x00000000732c783bULL, 0x000f220000004200ULL,
0x0000002041197824ULL, 0x040fe200078e00ffULL, 0x00000005411b7819ULL, 0x000fe200000006ffULL,
0x000000015c607824ULL, 0x000fe200078e0241ULL, 0xffffffe015147812ULL, 0x000fe200078ee214ULL,
0x000000007224783bULL, 0x000f620000004200ULL, 0x0000000818707c11ULL, 0x000fc4000f8e20ffULL,
0x0000000c14717c11ULL, 0x000fe4000f8e20ffULL, 0xffffffe019627812ULL, 0x000fe400078ee262ULL,
0xffffffe01a617812ULL, 0x000fe200078ee261ULL, 0x000000007114783bULL, 0x000f620000004200ULL,
0xffffffe01b607812ULL, 0x000fc600078ee260ULL, 0x012000007018783bULL, 0x0003640000000200ULL,
0x000000341c44723cULL, 0x00afec00000018ffULL, 0x000000361c34723cULL, 0x000fec00000018ffULL,
0x0000002c1c30723cULL, 0x010fec00000018ffULL, 0x000000241c28723cULL, 0x020fec00000018ffULL,
0x0000002e1c2c723cULL, 0x000fec00000018ffULL, 0x000000261c24723cULL, 0x000fec00000018ffULL,
0x000000141c20723cULL, 0x004fec00000018ffULL, 0x000000161c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000104947ULL, 0x000fde0003800000ULL,
0x0000000218187232ULL, 0x080fe40000000000ULL, 0x000000021a1a7232ULL, 0x000fe40000000000ULL,
0x0000000019197232ULL, 0x080fe40000000000ULL, 0x000000001b1b7232ULL, 0x000fce0000000000ULL,
0x0000000c626f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002041407824ULL, 0x000fe200078e00ffULL,
0x0000000c616e7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001665f7824ULL, 0x000fe200078e0241ULL,
0x0000000c606d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000006f14783bULL, 0x000e620000004200ULL,
0x00000002ff787819ULL, 0x000fe2000001165aULL, 0x00000001040b7890ULL, 0x000fe2000fffe03fULL,
0xffffffe0405f7812ULL, 0x000fe200078ee25fULL, 0x000000006e38783bULL, 0x000ea20000004200ULL,
0x0000000478007c0cULL, 0x040fe2000bf06070ULL, 0x0000000878777836ULL, 0x000fe20000000000ULL,
0x0000000c5f6c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000006d3c783bULL, 0x000ee20000004200ULL,
0x0000000b78007c0cULL, 0x000fe2000c706470ULL, 0x0000022000007945ULL, 0x000fe20003800000ULL,
0x0000000477007c0cULL, 0x040fe2000bf26070ULL, 0x000000006c40783bULL, 0x000f260000004200ULL,
0x0000000b77007c0cULL, 0x000fe2000cf26470ULL, 0x000000141844723cULL, 0x002fec0000001844ULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x00000007ff147e24ULL, 0x000fc4000f8e00ffULL,
0x00000007ff157e24ULL, 0x000fc6000f8e00ffULL, 0x0000001914007c0cULL, 0x000fe2000bfa3070ULL,
0x000000381830723cULL, 0x004fe20000001830ULL, 0x0000001915007c0cULL, 0x000fca000bf63070ULL,
0x0000003a182c723cULL, 0x000fec000000182cULL, 0x0000003c1828723cULL, 0x008fec0000001828ULL,
0x0000003e1824723cULL, 0x000fec0000001824ULL, 0x000000401820723cULL, 0x010fec0000001820ULL,
0x00000042181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000400947ULL, 0x000fde0002800000ULL, 0x0000004403037221ULL, 0x000fe20000010000ULL,
0x0000004504047221ULL, 0x000fe20000010000ULL, 0x0000003407077221ULL, 0x000fe20000010000ULL,
0x0000003508087221ULL, 0x000fe20000010000ULL, 0x000000300b0b7221ULL, 0x000fe20000010000ULL,
0x000000310c0c7221ULL, 0x000fe20000010000ULL, 0x0000002c0f0f7221ULL, 0x000fe20000010000ULL,
0x0000002d12127221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244f4f7221ULL, 0x000fe20000010000ULL,
0x0000002550507221ULL, 0x000fe20000010000ULL, 0x0000002053537221ULL, 0x000fe20000010000ULL,
0x0000002154547221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000401947ULL, 0x000fea0001800000ULL,
0x0000004605057221ULL, 0x000fe20000010000ULL, 0x0000004706067221ULL, 0x000fe20000010000ULL,
0x0000003609097221ULL, 0x000fe20000010000ULL, 0x000000370a0a7221ULL, 0x000fe20000010000ULL,
0x000000320d0d7221ULL, 0x000fe20000010000ULL, 0x000000330e0e7221ULL, 0x000fe20000010000ULL,
0x0000002e13137221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4d4d7221ULL, 0x000fe20000010000ULL, 0x0000002b4e4e7221ULL, 0x000fe20000010000ULL,
0x0000002651517221ULL, 0x000fe20000010000ULL, 0x0000002752527221ULL, 0x000fe20000010000ULL,
0x0000002255557221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f10107221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01cb8869ff1479a7ULL, 0x000e620008500008ULL,
0x000000023f0c7899ULL, 0x000fe2000801160bULL, 0x00000007ff167e24ULL, 0x000fe2000f8e00ffULL,
0x000000030b0d7892ULL, 0x000fe4000f8ec03fULL, 0x0000000c0b0c7287ULL, 0x000fe40008800000ULL,
0x0000001916007c0cULL, 0x000fe2000bfc3070ULL, 0x0000003f0d0b7287ULL, 0x000fe4000c800000ULL,
0x000000023f0f7899ULL, 0x000fc4000801160cULL, 0x000000030c0e7892ULL, 0x000fe4000f8ec03fULL,
0x000000160f0f72a4ULL, 0x000fe2000f8e0219ULL, 0x0000000700147c02ULL, 0x002fe20008000f00ULL,
0x000000ffff187224ULL, 0x000fc600078e0015ULL, 0x0000001914007c0cULL, 0x000fe4000bfa3070ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb804cff0075a7ULL, 0x000e640008060148ULL,
0x00000000005c3947ULL, 0x002ff00003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f66270ULL, 0x000000000044b947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f7e1ffULL,
0x0000000117177824ULL, 0x000fe200018e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x000000000008b947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x00000000001cb947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078710ffULL, 0x000000ffff177224ULL, 0x000fca00018e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb804cff0075a7ULL, 0x000e640008060148ULL, 0xfffffffc00a8b947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb8818ff0075a7ULL, 0x000e640008060148ULL,
0x00000000005c3947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f66270ULL, 0x000000000044b947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fc80007f7e1ffULL,
0x0000001715177210ULL, 0x000fe40001ffe5ffULL, 0x003d09001900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x000000000008b947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x00000000001cb947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078710ffULL, 0x000000ffff177224ULL, 0x000fca00018e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb8818ff0075a7ULL, 0x000e640008060148ULL, 0xfffffffc00a8b947ULL, 0x002fea000383ffffULL,
0x000000010f0d7890ULL, 0x000fe4000fffe03fULL, 0x0000000e0f0c7291ULL, 0x000fe4000f8e103fULL,
0x000000050d00728cULL, 0x000fe4000bf06070ULL, 0x000000060c117899ULL, 0x000fc8000800063fULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x0000004009107892ULL, 0x000fd8000f8ef811ULL,
0x0000000800c8b947ULL, 0x000fea0003800000ULL, 0x0000000818227291ULL, 0x000fe2000f8e103fULL,
0x000000105a167824ULL, 0x000fe200078e00ffULL, 0x000000111a00728cULL, 0x000fe2000bf01070ULL,
0x00000018ff157e24ULL, 0x000fe2000f8e00ffULL, 0x00000010181f7290ULL, 0x000fe4000fffe03fULL,
0x000000185a177c36ULL, 0x000fe20008000000ULL, 0x000000111a0c7287ULL, 0x000fe2000c000000ULL,
0x000001f016167812ULL, 0x000fe200078ec0ffULL, 0x0000002015187824ULL, 0x000fe200078e00ffULL,
0x01ca0022ff147984ULL, 0x000e620008000800ULL, 0x0000000c11117290ULL, 0x000fc4000fffe13fULL,
0x0001400008237890ULL, 0x000fe2000fffe03fULL, 0xffffffe018177812ULL, 0x000fe200078ee217ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x000000111800728cULL, 0x000fe4000bf01070ULL,
0x0000000118247890ULL, 0x000fe2000fffe03fULL, 0x0000002317197c11ULL, 0x000fe2000f8e20ffULL,
0x0000001118117287ULL, 0x000fc8000c000000ULL, 0x0000001118117290ULL, 0x000fe2000fffe13fULL,
0x00000024001a7c02ULL, 0x000fe20008000f00ULL, 0x000000245a187c36ULL, 0x000fe40008000000ULL,
0x000000011100788cULL, 0x000fe2000bf03070ULL, 0x0000000814147c11ULL, 0x002fcc000f8e10ffULL,
0x01cac00014147984ULL, 0x000e640000000800ULL, 0x00000000141472caULL, 0x002fda00000e0000ULL,
0x000000140a1472a4ULL, 0x000fe4000f8e021fULL, 0x00000010241f7290ULL, 0x000fe4000fffe03fULL,
0x00000200142078a5ULL, 0x000fe4000f8e000cULL, 0x0000000218247890ULL, 0x000fc8000fffe03fULL,
0x0000002016147c10ULL, 0x000fca000ff7e0ffULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x00000011ff007c0cULL, 0x000fda000bf66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca0422ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe400078e00ffULL, 0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171472caULL, 0x002fda00000e0000ULL,
0x000000140a1472a4ULL, 0x000fe4000f8e021fULL, 0x00000010241f7290ULL, 0x000fe4000fffe03fULL,
0x00000200142078a5ULL, 0x000fe4000f8e000cULL, 0x0000000318247890ULL, 0x000fc8000fffe03fULL,
0x0000002016147c10ULL, 0x000fca000ff7e0ffULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000021100788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca0822ff177984ULL, 0x000ea20008000800ULL, 0x000000201a197824ULL, 0x002fe400078e00ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171472caULL, 0x002fda00000e0000ULL, 0x000000140a1472a4ULL, 0x000fe4000f8e021fULL,
0x00000010241f7290ULL, 0x000fe4000fffe03fULL, 0x00000200142078a5ULL, 0x000fe4000f8e000cULL,
0x0000000418247890ULL, 0x000fc8000fffe03fULL, 0x0000002016147c10ULL, 0x000fc8000ff7e0ffULL,
0x00000021ff157c10ULL, 0x000fe40009ffe4ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000031100788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca0c22ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe400078e00ffULL, 0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171472caULL, 0x002fda00000e0000ULL,
0x000000140a1472a4ULL, 0x000fe4000f8e021fULL, 0x00000010241f7290ULL, 0x000fe4000fffe03fULL,
0x00000200142078a5ULL, 0x000fe4000f8e000cULL, 0x0000000518247890ULL, 0x000fc8000fffe03fULL,
0x0000002016147c10ULL, 0x000fca000ff7e0ffULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000041100788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca1022ff177984ULL, 0x000ea20008000800ULL, 0x000000051a197819ULL, 0x002fe200000006ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171472caULL, 0x002fda00000e0000ULL, 0x000000140a1472a4ULL, 0x000fe4000f8e021fULL,
0x00000010241f7290ULL, 0x000fe4000fffe03fULL, 0x00000200142078a5ULL, 0x000fe4000f8e000cULL,
0x0000000618247890ULL, 0x000fc8000fffe03fULL, 0x0000002016147c10ULL, 0x000fca000ff7e0ffULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000051100788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1422ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe400078e00ffULL, 0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe4000f8e20ffULL,
0x000000245a187c10ULL, 0x000fe4000fffe0ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171472caULL, 0x002fda00000e0000ULL,
0x000000140a1472a4ULL, 0x000fe4000f8e021fULL, 0x00000010241f7290ULL, 0x000fe4000fffe03fULL,
0x00000200142078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fca000ff7e0ffULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000061100788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1822ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fca00078e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe4000f8e20ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171472caULL, 0x002fda00000e0000ULL,
0x000000140a1472a4ULL, 0x000fe4000f8e021fULL, 0x00000007181f7890ULL, 0x000fe4000fffe03fULL,
0x00000200142078a5ULL, 0x000fe4000f8e000cULL, 0x000000101f107290ULL, 0x000fe4000fffe03fULL,
0x0000001fff187e24ULL, 0x000fe4000f8e00ffULL, 0x0000002016147c10ULL, 0x000fca000ff7e0ffULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000071100788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1c22ff177984ULL, 0x000ea20008000800ULL,
0x0000002018197824ULL, 0x002fe200078e00ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171472caULL, 0x002fda00000e0000ULL,
0x000000140a1072a4ULL, 0x000fc8000f8e0210ULL, 0x00000200100c78a5ULL, 0x000fcc000f8e000cULL,
0x0000000c16147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001f5a167c36ULL, 0x000fc80008000000ULL,
0x0000000dff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe40003f6f008ULL,
0xffffffe019167812ULL, 0x000fc800078ee216ULL, 0x0000002316177c11ULL, 0x000fce000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d901c52ULL,
0x0000000800347947ULL, 0x000fea0003800000ULL, 0x000000185a197c11ULL, 0x040fe2000f8fd8ffULL,
0x00008a00ff167b82ULL, 0x000e620000000a00ULL, 0x000000105a1b7824ULL, 0x000fe200078e00ffULL,
0x00014000080c7890ULL, 0x000fe4000fffe03fULL, 0x0000000819187c11ULL, 0x040fe2000f8e10ffULL,
0x00000001191c7824ULL, 0x040fe200078e025aULL, 0x0000001019157c10ULL, 0x000fe2000fffe0ffULL,
0x00000020191d7824ULL, 0x000fe200078e00ffULL, 0x000001f01b1b7812ULL, 0x000fe200078ec0ffULL,
0x01ca000018147984ULL, 0x000ea20000000800ULL, 0x0000000119217836ULL, 0x000fc40000000000ULL,
0xffffffe01d1c7812ULL, 0x000fe400078ee21cULL, 0x00000010211d7c36ULL, 0x000fe40008000000ULL,
0x0000000c1c1f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000005a211c7210ULL, 0x000fe20007ffe0ffULL,
0x0000002021217824ULL, 0x000fca00078e00ffULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000219217836ULL, 0x000fe20000000000ULL, 0x00000008141a7c11ULL, 0x004fca000f8e10ffULL,
0x01cac0001a147984ULL, 0x000ea40000000800ULL, 0x0000000a14157c24ULL, 0x004fc8000f8e0215ULL,
0x0000020015147825ULL, 0x002fc600078e0016ULL, 0x0000001b14147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0400181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000010211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000319217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0800181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000010211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f7e0ffULL, 0x0000002021217824ULL, 0x000fc600078e00ffULL,
0x00000015ff157210ULL, 0x000fe40001ffe4ffULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000419217836ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0c00181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fe200078e0016ULL,
0x00000010211d7c10ULL, 0x000fc6000fffe0ffULL, 0x0000002021217824ULL, 0x000fe200078e00ffULL,
0x0000001b14147210ULL, 0x000fc80007f7e0ffULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x000000ffff157224ULL, 0x000fe400018e0615ULL, 0x0000000519217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1000181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000010211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe40007f7e0ffULL, 0x0000000521217819ULL, 0x000fc600000006ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000619217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1400181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000010211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0xffffffe0211c7812ULL, 0x000fc800078ee21cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1800181a7984ULL, 0x000ea20000000800ULL,
0x00000007191f7810ULL, 0x002fca0007ffe0ffULL, 0x000000101f197c36ULL, 0x000fe20008000000ULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fe200078e0016ULL,
0x0000000c1c1d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000201f1c7824ULL, 0x000fe200078e00ffULL,
0x0000001b14147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e8000b901c52ULL,
0x01ca1c0018187984ULL, 0x000ea40000000800ULL, 0x00000008181a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000ea40000000800ULL, 0x0000000a1a197c24ULL, 0x004fc8000f8e0219ULL,
0x0000020019167825ULL, 0x000fc800078e0016ULL, 0x000000011f197824ULL, 0x000fe200078e025aULL,
0x0000001b16147210ULL, 0x002fc80007f7e0ffULL, 0xffffffe01c197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600018e0617ULL, 0x0000000c19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c52ULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x01cb8814ff1479a7ULL, 0x000e640008500008ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000147805ULL, 0x000fc60000015200ULL,
0x01cb8818ff0075a7ULL, 0x000e640008060148ULL, 0x00000000005c3947ULL, 0x002fea0003800000ULL,
0x000000ff001a7202ULL, 0x000fce0000000f00ULL, 0x000000101a00780cULL, 0x000fda0003f66270ULL,
0x000000000044b947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f7e1ffULL, 0x0000000117177824ULL, 0x000fe200018e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x000000000008b947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x00000000001cb947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078710ffULL,
0x000000ffff177224ULL, 0x000fca00018e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb8818ff0075a7ULL, 0x000e640008060148ULL,
0xfffffffc00a8b947ULL, 0x002fea000383ffffULL, 0x0000000463147836ULL, 0x000fe20000000000ULL,
0x000001c000007945ULL, 0x000fe20003800000ULL, 0x00000008646b7824ULL, 0x000fe400078e00ffULL,
0x000000014b167824ULL, 0x000fc600078e025cULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee214ULL,
0x00000000005c2947ULL, 0x000fec0003800000ULL, 0x0000000f0700728cULL, 0x000fe2000bf04070ULL,
0x00009200ff147b82ULL, 0x000e620000000a00ULL, 0x0000000867197c11ULL, 0x000fe4000f8e10ffULL,
0x0000003f0b0c7287ULL, 0x000fc80008000000ULL, 0x0000000c0e0c7290ULL, 0x000fc8000fffe03fULL,
0x000000023f0d7899ULL, 0x000fe4000801160cULL, 0x000000060c0c7899ULL, 0x000fe4000800063fULL,
0x000000160d0d72a4ULL, 0x000fe4000f8e020fULL, 0x000000c00c0c7892ULL, 0x000fc8000f8ec03fULL,
0x0000000c0d0c7291ULL, 0x000fe4000f8e403fULL, 0x0000003f0b0d7287ULL, 0x000fe4000c000000ULL,
0x000000200c107890ULL, 0x000fe4000fffe03fULL, 0x0000000d1b0c7290ULL, 0x000fc6000fffe03fULL,
0x00009400000d7ab9ULL, 0x000fe20000000800ULL, 0x0000001067177c10ULL, 0x000fe2000fffe0ffULL,
0x0000000d0c0c72a4ULL, 0x000fc6000f8e0210ULL, 0x0000001a17007c0cULL, 0x000fc6000bf66070ULL,
0x0000000c67177c36ULL, 0x000fc80008000000ULL, 0x0000000417147825ULL, 0x002fcc00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1ca0000014197faeULL, 0x0003e4000d921852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000014b157824ULL, 0x000fe200078e025dULL, 0x000000086b6b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000014b687824ULL, 0x040fe200078e0268ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a5dULL,
0x00000001ff7a7424ULL, 0x000fe400078e00ffULL, 0x000000204b187824ULL, 0x040fe400078e00ffULL,
0x000000204b197824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x01cb787aff5c79a7ULL, 0x0002a20008500008ULL, 0x0000000000104947ULL, 0x000fea0003800000ULL,
0x0000005eff00723eULL, 0x000fc800000000ffULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f7814027589ULL, 0x00066800000e0000ULL, 0x00001f7714007589ULL, 0x0006a400000e0000ULL,
0x012000006b1c783bULL, 0x0006a20000000200ULL, 0x0000000000104947ULL, 0x000fea0003800000ULL,
0x000000021c1c7232ULL, 0x086fe40000000000ULL, 0x000000021e1e7232ULL, 0x000fe40000000000ULL,
0x000000001d1d7232ULL, 0x080fe40000000000ULL, 0x000000001f1f7232ULL, 0x000fce0000000000ULL,
0x000000054b177819ULL, 0x040fe200000006ffULL, 0x000000014b667824ULL, 0x040fe200078e0266ULL,
0x00018000080b7890ULL, 0x000fe2000fffe03fULL, 0x000000204b4b7824ULL, 0x000fe200078e00ffULL,
0xffffffe019687812ULL, 0x000fe200078ee268ULL, 0x0000000663637836ULL, 0x000fe20000000000ULL,
0xffffffe018157812ULL, 0x000fe200078ee215ULL, 0x00000008644c7824ULL, 0x000fe200078e00ffULL,
0xffffffe017167812ULL, 0x000fe400078ee216ULL, 0xffffffe04b667812ULL, 0x000fc400078ee266ULL,
0x0000000b686a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b15697c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b16687c11ULL, 0x000fe2000f8e20ffULL, 0x000000006a34783bULL, 0x000f220000004200ULL,
0x0000000b66667c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee263ULL,
0x00000000692c783bULL, 0x000f660000004200ULL, 0x000000084c4c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000006824783bULL, 0x000f680000004200ULL, 0x000000006614783bULL, 0x008ee80000004200ULL,
0x012000004c18783bULL, 0x0006e20000000200ULL, 0x000000341c44723cULL, 0x014fec00000018ffULL,
0x0000002c1c30723cULL, 0x020fec00000018ffULL, 0x000000241c28723cULL, 0x000fec00000018ffULL,
0x000000361c34723cULL, 0x000fec00000018ffULL, 0x0000002e1c2c723cULL, 0x000fec00000018ffULL,
0x000000261c24723cULL, 0x000fec00000018ffULL, 0x000000141c20723cULL, 0x008fec00000018ffULL,
0x000000161c1c723cULL, 0x000fe200000018ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000104947ULL, 0x002fde0003800000ULL, 0x0000000218187232ULL, 0x080fe40000000000ULL,
0x000000021a1a7232ULL, 0x000fe40000000000ULL, 0x0000000019197232ULL, 0x080fe40000000000ULL,
0x000000001b1b7232ULL, 0x000fce0000000000ULL, 0x0000000b62627c11ULL, 0x000fe2000f8e20ffULL,
0x0000022000007945ULL, 0x000fe20003800000ULL, 0x0000000b61617c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b60607c11ULL, 0x000fe2000f8e20ffULL, 0x000000006214783bULL, 0x000e620000004200ULL,
0x0000000b5f5f7c11ULL, 0x000fc6000f8e20ffULL, 0x000000006138783bULL, 0x000ea80000004200ULL,
0x00000000603c783bULL, 0x000ee80000004200ULL, 0x000000005f40783bULL, 0x000f220000004200ULL,
0x000000141844723cULL, 0x002fec0000001844ULL, 0x000000161834723cULL, 0x000fec0000001834ULL,
0x000000381830723cULL, 0x004fec0000001830ULL, 0x0000003a182c723cULL, 0x000fec000000182cULL,
0x0000003c1828723cULL, 0x008fec0000001828ULL, 0x0000003e1824723cULL, 0x000fec0000001824ULL,
0x000000401820723cULL, 0x010fec0000001820ULL, 0x00000042181c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000400947ULL, 0x000fde0002800000ULL,
0x0000004403037221ULL, 0x000fe20000010000ULL, 0x0000004504047221ULL, 0x000fe20000010000ULL,
0x0000003407077221ULL, 0x000fe20000010000ULL, 0x0000003508087221ULL, 0x000fe20000010000ULL,
0x000000300b0b7221ULL, 0x000fe20000010000ULL, 0x000000310c0c7221ULL, 0x000fe20000010000ULL,
0x0000002c0f0f7221ULL, 0x000fe20000010000ULL, 0x0000002d12127221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244f4f7221ULL, 0x000fe20000010000ULL, 0x0000002550507221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001000b7882ULL, 0x000fe20000000000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5c7224ULL, 0x000fc600078e005dULL,
0x0000000000401947ULL, 0x000fea0003000000ULL, 0x0000004605057221ULL, 0x000fe20000010000ULL,
0x0000004706067221ULL, 0x000fe20000010000ULL, 0x0000003609097221ULL, 0x000fe20000010000ULL,
0x000000370a0a7221ULL, 0x000fe20000010000ULL, 0x000000320d0d7221ULL, 0x000fe20000010000ULL,
0x000000330e0e7221ULL, 0x000fe20000010000ULL, 0x0000002e13137221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4d4d7221ULL, 0x000fe20000010000ULL,
0x0000002b4e4e7221ULL, 0x000fe20000010000ULL, 0x0000002651517221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f10107221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x01cb887aff1479a7ULL, 0x000e620008500008ULL,
0x000000040b0b7887ULL, 0x000fc80008800000ULL, 0x0000000b0400728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffac009c8947ULL, 0x000fea000383ffffULL, 0x0000004019047891ULL, 0x000fe2000f8e403fULL,
0x01cb587affff79a7ULL, 0x0003e60008500008ULL, 0x0000001a0400728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000e000fc0947ULL, 0x002fea0003800000ULL,
0x0000003f00047c82ULL, 0x000fca0008000000ULL, 0x000000023f0c7899ULL, 0x000fe40008011604ULL,
0x00000003040f7892ULL, 0x000fe4000f8ec03fULL, 0x0000000c040c7287ULL, 0x000fe40008800000ULL,
0x0000003f0f0f7287ULL, 0x000fe4000c800000ULL, 0x000000010c0e7890ULL, 0x000fc8000fffe03fULL,
0x000000023f107899ULL, 0x000fe4000801160eULL, 0x000000030e227892ULL, 0x000fe4000f8ec03fULL,
0x00000016101072a4ULL, 0x000fe2000f8e0219ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x01cb785cff0075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002ff00003800000ULL,
0x000000ff001a7202ULL, 0x000fce0000000f00ULL, 0x000000101a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb785cff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x01cb8818ff0075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7810ULL, 0x000fce0007ffe0ffULL, 0x01cb8818ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001100d7890ULL, 0x000fe4000fffe03fULL,
0x00000022100c7291ULL, 0x000fe4000f8e103fULL, 0x000000050d00728cULL, 0x000fe4000bf06070ULL,
0x000000200c147891ULL, 0x000fc8000f8e303fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000006009117892ULL, 0x000fd8000f8ef814ULL, 0x0000000800c88947ULL, 0x000fea0003800000ULL,
0x0000000818237291ULL, 0x000fe2000f8e103fULL, 0x000000105a167824ULL, 0x000fe200078e00ffULL,
0x000000141a00728cULL, 0x000fe2000bf01070ULL, 0x00000018ff177e24ULL, 0x000fe2000f8e00ffULL,
0x0000001118207290ULL, 0x000fe4000fffe03fULL, 0x000000185a157c36ULL, 0x000fe20008000000ULL,
0x000000141a0c7287ULL, 0x000fe2000c000000ULL, 0x0000002017187824ULL, 0x000fe200078e00ffULL,
0x000001f016167812ULL, 0x000fe200078ec0ffULL, 0x01ca0023ff147984ULL, 0x000e620008000800ULL,
0x0000000c14147290ULL, 0x000fc4000fffe13fULL, 0x0001800008247890ULL, 0x000fe2000fffe03fULL,
0xffffffe018177812ULL, 0x000fe200078ee215ULL, 0x000000141800728cULL, 0x000fe2000bf01070ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000118257890ULL, 0x000fe4000fffe03fULL,
0x0000002417197c11ULL, 0x000fe2000f8e20ffULL, 0x0000001418147287ULL, 0x000fc8000c000000ULL,
0x0000001418147290ULL, 0x000fe2000fffe13fULL, 0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL,
0x000000011400788cULL, 0x000fe2000bf03070ULL, 0x0000002018187824ULL, 0x000fe200078e00ffULL,
0x00000014ff007c0cULL, 0x000fe4000bf06070ULL, 0x0000000814147c11ULL, 0x002fcc000f8e10ffULL,
0x01cac00014147984ULL, 0x000e640000000800ULL, 0x00000000141f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001125207290ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200088e06ffULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000021400788cULL, 0x000fc6000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000c101c52ULL, 0x01ca0423ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c10ULL, 0x002fe2000fffe0ffULL, 0x0000000218257890ULL, 0x000fe2000fffe03fULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x0000002417197c11ULL, 0x000fe2000f8e20ffULL,
0x0000002018187824ULL, 0x000fcc00078e00ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000031400788cULL, 0x000fe4000bf03070ULL,
0x01ca0823ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c36ULL, 0x002fe20008000000ULL,
0x0000000318257890ULL, 0x000fe2000fffe03fULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fe400000e0000ULL,
0xffffffe018177812ULL, 0x000fe400078ee215ULL, 0x0000002500187c02ULL, 0x000fe40008000f00ULL,
0x0000002417197c11ULL, 0x000fc6000f8e20ffULL, 0x0000002018187824ULL, 0x000fc800078e00ffULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001125207290ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fca00080e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000041400788cULL, 0x000fe4000bf03070ULL, 0x01ca0c23ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c36ULL, 0x002fe20008000000ULL, 0x0000000418257890ULL, 0x000fe2000fffe03fULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x0000002417197c11ULL, 0x000fe2000f8e20ffULL,
0x0000002018187824ULL, 0x000fcc00078e00ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000051400788cULL, 0x000fe4000bf03070ULL,
0x01ca1023ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c36ULL, 0x002fe20008000000ULL,
0x0000000518257890ULL, 0x000fe2000fffe03fULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fe400000e0000ULL,
0xffffffe018177812ULL, 0x000fe200078ee215ULL, 0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL,
0x0000002417197c11ULL, 0x000fe2000f8e20ffULL, 0x0000002018187824ULL, 0x000fcc00078e00ffULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001125207290ULL, 0x000fc6000fffe03fULL,
0x00000021ff157c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000061400788cULL, 0x000fe4000bf03070ULL, 0x01ca1423ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c36ULL, 0x002fe20008000000ULL, 0x0000000618257890ULL, 0x000fe2000fffe03fULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x0000002417197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000518187819ULL, 0x000fca00000006ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000071400788cULL, 0x000fe4000bf03070ULL,
0x01ca1823ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c36ULL, 0x002fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fc800078ee215ULL,
0x0000002417197c11ULL, 0x000fce000f8e20ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000718207890ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200080e06ffULL,
0x0000001120117290ULL, 0x000fe4000fffe03fULL, 0x00000020ff187e24ULL, 0x000fe4000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000c901c52ULL,
0x0000002018187824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x01ca1c23ff177984ULL, 0x000ea20008000800ULL, 0x000000205a157c36ULL, 0x002fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a1172a4ULL, 0x000fc8000f8e0211ULL,
0x00000200110c78a5ULL, 0x000fcc000f8e000cULL, 0x0000000c16147c10ULL, 0x000fe4000ff1e0ffULL,
0xffffffe018167812ULL, 0x000fc600078ee215ULL, 0x0000000dff157e24ULL, 0x000fe200080e06ffULL,
0x0000002416177c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c901c52ULL, 0x0000000800347947ULL, 0x000fea0003800000ULL,
0x000000185a197c11ULL, 0x040fe2000f8fd8ffULL, 0x00008a00ff167b82ULL, 0x000e620000000a00ULL,
0x000000045a1b7819ULL, 0x000fe200000006ffULL, 0x00018000080c7890ULL, 0x000fe4000fffe03fULL,
0x0000000819187c11ULL, 0x000fe2000f8e10ffULL, 0x0000001119157c36ULL, 0x000fe20008000000ULL,
0x000001f01b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000001191c7824ULL, 0x040fe400078e025aULL,
0x01ca000018147984ULL, 0x000ea20000000800ULL, 0x00000020191d7824ULL, 0x000fc400078e00ffULL,
0x0000000119217836ULL, 0x000fc60000000000ULL, 0xffffffe01d1c7812ULL, 0x000fe200078ee21cULL,
0x00000011211d7c36ULL, 0x000fc60008000000ULL, 0x0000000c1c1f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x040fe200078e025aULL, 0x0000000521217819ULL, 0x000fc800000006ffULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000219217836ULL, 0x000fe20000000000ULL,
0x00000008141a7c11ULL, 0x004fca000f8e10ffULL, 0x01cac0001a147984ULL, 0x000ea40000000800ULL,
0x0000000a14157c24ULL, 0x004fc8000f8e0215ULL, 0x0000020015147825ULL, 0x002fc600078e0016ULL,
0x0000001b14147210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0400181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f1e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0xffffffe0211c7812ULL, 0x000fe400078ee21cULL,
0x0000000319217810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0800181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f1e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000419217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0c00181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe4000f8e20ffULL,
0x0000005a211c7210ULL, 0x000fe40007ffe0ffULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f1e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000519217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1000181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f1e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000619217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1400181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f1e0ffULL, 0x0000002021217824ULL, 0x000fc600078e00ffULL,
0x00000015ff157210ULL, 0x000fe400007fe4ffULL, 0xffffffe0211c7812ULL, 0x000fc600078ee21cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1800181a7984ULL, 0x000ea20000000800ULL, 0x00000007191f7836ULL, 0x002fca0000000000ULL,
0x000000111f197c10ULL, 0x000fe4000fffe0ffULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fe200078e0016ULL, 0x0000000c1c1d7c11ULL, 0x000fc6000f8e20ffULL,
0x000000201f1c7824ULL, 0x000fe200078e00ffULL, 0x0000001b14147210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e8000b901c52ULL, 0x01ca1c0018187984ULL, 0x000ea40000000800ULL,
0x00000008181a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000ea40000000800ULL,
0x0000000a1a197c24ULL, 0x004fc8000f8e0219ULL, 0x0000020019167825ULL, 0x000fc800078e0016ULL,
0x000000011f197824ULL, 0x000fe200078e025aULL, 0x0000001b16147210ULL, 0x002fc80007f1e0ffULL,
0xffffffe01c197812ULL, 0x000fe200078ee219ULL, 0x000000ffff157224ULL, 0x000fc600000e0617ULL,
0x0000000c19197c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e4000b901c52ULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x01cb8814ff1479a7ULL, 0x000e640008500008ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x01cb8818ff0075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fc80007f1e1ffULL,
0x0000001715177210ULL, 0x000fe400007fe5ffULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb8818ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000100700728cULL, 0x000fe2000bf04070ULL, 0x00000001ff5c7424ULL, 0x000fe200078e00ffULL,
0x000000010e0e7892ULL, 0x000fe4000f8ec03fULL, 0x000000030f00788cULL, 0x000fc8000c705270ULL,
0x000000010e00788cULL, 0x000fcc0008705470ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000600947ULL, 0x000fea0003800000ULL, 0x000000011c0d7892ULL, 0x000fe2000f8ec03fULL,
0x000000036700780cULL, 0x000fe20003f04070ULL, 0xffffffff160c7891ULL, 0x000fe2000f8e083fULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x000000010d00788cULL, 0x000fc8000bf05070ULL,
0x000000010c0c7887ULL, 0x000fc8000c000000ULL, 0x0000000c1c1c7290ULL, 0x000fe4000fffe03fULL,
0x00000000003c0947ULL, 0x000ff40003800000ULL, 0x00008c00ff147b82ULL, 0x000e620000000a00ULL,
0x00009000000c7ab9ULL, 0x000fe20000000800ULL, 0x000000061c00728cULL, 0x000fe2000bf06070ULL,
0x0000000479167824ULL, 0x000fe200078e0267ULL, 0x0000000c1c0d7290ULL, 0x000fe2000fffe03fULL,
0x0000000867197c11ULL, 0x000fe4000f8e10ffULL, 0x0000000216167824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x0000000dff177e24ULL, 0x000fc8000f8e00ffULL,
0x0000000c16177c24ULL, 0x000fc8000f8e0217ULL, 0x0000000417147825ULL, 0x002fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1cac000014197faeULL, 0x0003e4000c121852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001a000007945ULL, 0x000fe80003800000ULL,
0x0000000000602947ULL, 0x000fea0003800000ULL, 0x000000100700728cULL, 0x000fe2000bf04070ULL,
0x00009200ff147b82ULL, 0x002e620000000a00ULL, 0x000000010f0c7890ULL, 0x000fe2000fffe03fULL,
0x0000000867197c11ULL, 0x000fc6000f8e10ffULL, 0x000000030c0d7892ULL, 0x000fc8000f8ec03fULL,
0x0000003f0d0d7287ULL, 0x000fe4000c000000ULL, 0x000000023f0c8899ULL, 0x000fc8000801160cULL,
0x0000000c220c7290ULL, 0x000fc8000fffe03fULL, 0x000000023f0e7899ULL, 0x000fe4000801160cULL,
0x000000060c0c7899ULL, 0x000fe4000800063fULL, 0x000000160e0e72a4ULL, 0x000fe4000f8e0210ULL,
0x000000c00c0c7892ULL, 0x000fc8000f8ec03fULL, 0x0000000c0e0e7291ULL, 0x000fe4000f8e403fULL,
0x0000000d1b0c7290ULL, 0x000fc6000fffe03fULL, 0x00009400000d7ab9ULL, 0x000fe20000000800ULL,
0x0000000e67167c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d0c0c72a4ULL, 0x000fc6000f8e020eULL,
0x0000001a16007c0cULL, 0x000fc6000bf06070ULL, 0x0000000c67177c36ULL, 0x000fc80008000000ULL,
0x0000000417147825ULL, 0x002fcc00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1ca0000014197faeULL, 0x0003e4000c121852ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a5eULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x01cb805cff1479a7ULL, 0x000e620008500008ULL,
0x00000004ff007c0cULL, 0x000fe2000bf05270ULL, 0x000000ffff4b7224ULL, 0x002fd800078e0015ULL,
0x0000000400900947ULL, 0x000fea0003800000ULL, 0x01caf85c761479a7ULL, 0x000e640008500008ULL,
0x000000ffff1b7224ULL, 0x002fe200078e0015ULL, 0x0000000000147805ULL, 0x000fc60000015200ULL,
0x01caf81b760075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fce0007ffe0ffULL, 0x01caf81b760075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000105a147824ULL, 0x000fe200078e00ffULL,
0x00000001ff157819ULL, 0x000fe2000001165aULL, 0x00000001ff657424ULL, 0x000fc600078e00ffULL,
0x0000007014147812ULL, 0x000fe400078ec0ffULL, 0x0000000c15157812ULL, 0x000fc800078ec0ffULL,
0x00000008151a7c10ULL, 0x000fca000fffe014ULL, 0x01c080001a147984ULL, 0x000e680000000800ULL,
0x01c280001a167984ULL, 0x0004a20000000800ULL, 0x000000111400720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15187812ULL, 0x000fe2000780c0ffULL,
0x000000ffff157224ULL, 0x000fd800078e0011ULL, 0x0000000000e48947ULL, 0x004fea0003800000ULL,
0x000000011500788cULL, 0x000fe2000bf05270ULL, 0x000000111400720bULL, 0x000fe40003f14000ULL,
0x0000001411157209ULL, 0x000fc60007810000ULL, 0x000000000000781cULL, 0x000fd00003f2f008ULL,
0x0000000000197806ULL, 0x000fc800000e0100ULL, 0x0000991019177816ULL, 0x000fe200000000ffULL,
0x01c480151a009388ULL, 0x0003e60000000800ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x0000000000a88947ULL, 0x002fea0003800000ULL, 0x8000001511117221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000782c0ffULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x00000011001a7308ULL, 0x0002ac0000000800ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00001f781a117589ULL, 0x006e6400000e0000ULL,
0x0000001103037220ULL, 0x082fe20000410000ULL, 0x0000001104047220ULL, 0x080fe20000410000ULL,
0x0000001107077220ULL, 0x080fe20000410000ULL, 0x0000001108087220ULL, 0x080fe20000410000ULL,
0x000000110b0b7220ULL, 0x080fe20000410000ULL, 0x000000110c0c7220ULL, 0x080fe20000410000ULL,
0x000000110f0f7220ULL, 0x080fe20000410000ULL, 0x0000001112127220ULL, 0x080fe20000410000ULL,
0x0000001149497220ULL, 0x080fe20000410000ULL, 0x000000114a4a7220ULL, 0x080fe20000410000ULL,
0x000000114f4f7220ULL, 0x080fe20000410000ULL, 0x0000001150507220ULL, 0x080fe20000410000ULL,
0x0000001153537220ULL, 0x080fe20000410000ULL, 0x0000001154547220ULL, 0x080fe20000410000ULL,
0x0000001157577220ULL, 0x080fe20000410000ULL, 0x0000001158587220ULL, 0x000fce0000410000ULL,
0x0000001a5b5b7220ULL, 0x004fe20000410000ULL, 0x0000000000449947ULL, 0x000fec0003800000ULL,
0x00001f771a117589ULL, 0x002e6400000e0000ULL, 0x0000001105057220ULL, 0x082fe20000410000ULL,
0x0000001106067220ULL, 0x080fe20000410000ULL, 0x0000001109097220ULL, 0x080fe20000410000ULL,
0x000000110a0a7220ULL, 0x080fe20000410000ULL, 0x000000110d0d7220ULL, 0x080fe20000410000ULL,
0x000000110e0e7220ULL, 0x080fe20000410000ULL, 0x0000001113137220ULL, 0x080fe20000410000ULL,
0x0000001148487220ULL, 0x080fe20000410000ULL, 0x000000114d4d7220ULL, 0x080fe20000410000ULL,
0x000000114e4e7220ULL, 0x080fe20000410000ULL, 0x0000001151517220ULL, 0x080fe20000410000ULL,
0x0000001152527220ULL, 0x080fe20000410000ULL, 0x0000001155557220ULL, 0x080fe20000410000ULL,
0x0000001156567220ULL, 0x080fe20000410000ULL, 0x0000001159597220ULL, 0x080fe20000410000ULL,
0x0000001110107220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007806019ULL,
0x8000001514140221ULL, 0x000fe20000010000ULL, 0x00007610ff650816ULL, 0x000fc60000000065ULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x00000014005e0308ULL, 0x000ea40000000800ULL,
0x0000005e16160220ULL, 0x004fce0000410000ULL, 0x0000005b165b7221ULL, 0x000fe20000010000ULL,
0x000000ffff117224ULL, 0x002fce00078e0015ULL, 0x000000ff65ff7812ULL, 0x000fda000788c0ffULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x0000005eff00723eULL, 0x000fc800000000ffULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f7814027589ULL, 0x0002a800000e0000ULL,
0x00001f7714007589ULL, 0x0002e400000e0000ULL, 0x01280000751c783bULL, 0x0002e20000000200ULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x000000021c1c7232ULL, 0x08cfe40000000000ULL,
0x000000021e1e7232ULL, 0x000fe40000000000ULL, 0x000000001d1d7232ULL, 0x080fe40000000000ULL,
0x000000001f1f7232ULL, 0x000fce0000000000ULL, 0x000000007434783bULL, 0x000f280000004200ULL,
0x00000000732c783bULL, 0x000f680000004200ULL, 0x000000007224783bULL, 0x000f680000004200ULL,
0x000000007114783bULL, 0x002e680000004200ULL, 0x012800007018783bULL, 0x0002620000000200ULL,
0x000000341c44723cULL, 0x018fec00000018ffULL, 0x0000002c1c30723cULL, 0x020fec00000018ffULL,
0x000000241c28723cULL, 0x000fec00000018ffULL, 0x000000361c34723cULL, 0x000fec00000018ffULL,
0x0000002e1c2c723cULL, 0x000fec00000018ffULL, 0x000000261c24723cULL, 0x000fec00000018ffULL,
0x000000141c20723cULL, 0x002fec00000018ffULL, 0x000000161c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000104947ULL, 0x004fde0003800000ULL,
0x0000000218187232ULL, 0x080fe40000000000ULL, 0x000000021a1a7232ULL, 0x000fe40000000000ULL,
0x0000000019197232ULL, 0x080fe40000000000ULL, 0x000000001b1b7232ULL, 0x000fce0000000000ULL,
0x000000006f14783bULL, 0x000e620000004200ULL, 0x00000001040c7890ULL, 0x000fe4000fffe03fULL,
0x0000000478007c0cULL, 0x040fe2000bf06070ULL, 0x0000025000007945ULL, 0x000fe20003800000ULL,
0x000000006e38783bULL, 0x000ea20000004200ULL, 0x0000000477007c0cULL, 0x040fe4000bf26070ULL,
0x0000000c78007c0cULL, 0x000fe2000c706470ULL, 0x000000006d3c783bULL, 0x000ee20000004200ULL,
0x0000000c77007c0cULL, 0x000fc6000cf26470ULL, 0x000000006c40783bULL, 0x000f220000004200ULL,
0x000000141844723cULL, 0x002fec0000001844ULL, 0x000000161834723cULL, 0x000fe20000001834ULL,
0x00000007ff147e24ULL, 0x000fe4000f8e00ffULL, 0x00000007ff157e24ULL, 0x000fc6000f8e00ffULL,
0x0000001914007c0cULL, 0x000fe2000bfa3070ULL, 0x000000381830723cULL, 0x004fe20000001830ULL,
0x0000001915007c0cULL, 0x000fca000bf63070ULL, 0x0000003a182c723cULL, 0x000fec000000182cULL,
0x0000003c1828723cULL, 0x008fec0000001828ULL, 0x0000003e1824723cULL, 0x000fec0000001824ULL,
0x000000401820723cULL, 0x010fec0000001820ULL, 0x00000042181c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000400947ULL, 0x000fde0002800000ULL,
0x0000004403037221ULL, 0x000fe20000010000ULL, 0x0000004504047221ULL, 0x000fe20000010000ULL,
0x0000003407077221ULL, 0x000fe20000010000ULL, 0x0000003508087221ULL, 0x000fe20000010000ULL,
0x000000300b0b7221ULL, 0x000fe20000010000ULL, 0x000000310c0c7221ULL, 0x000fe20000010000ULL,
0x0000002c0f0f7221ULL, 0x000fe20000010000ULL, 0x0000002d12127221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244f4f7221ULL, 0x000fe20000010000ULL, 0x0000002550507221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000401947ULL, 0x000fea0001800000ULL, 0x0000004605057221ULL, 0x000fe20000010000ULL,
0x0000004706067221ULL, 0x000fe20000010000ULL, 0x0000003609097221ULL, 0x000fe20000010000ULL,
0x000000370a0a7221ULL, 0x000fe20000010000ULL, 0x000000320d0d7221ULL, 0x000fe20000010000ULL,
0x000000330e0e7221ULL, 0x000fe20000010000ULL, 0x0000002e13137221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4d4d7221ULL, 0x000fe20000010000ULL,
0x0000002b4e4e7221ULL, 0x000fe20000010000ULL, 0x0000002651517221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f10107221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01cb885cff1479a7ULL, 0x000e620008500008ULL, 0x000000023f0d7899ULL, 0x000fe2000801160cULL,
0x00000007ff167e24ULL, 0x000fe2000f8e00ffULL, 0x000000030c0e7892ULL, 0x000fe4000f8ec03fULL,
0x0000000d0c0d7287ULL, 0x000fe40008800000ULL, 0x0000001916007c0cULL, 0x000fe2000bfc3070ULL,
0x0000003f0e0e7287ULL, 0x000fe4000c800000ULL, 0x000000010d0d7890ULL, 0x000fc8000fffe03fULL,
0x000000023f107899ULL, 0x000fe4000801160dULL, 0x000000030d0f7892ULL, 0x000fe4000f8ec03fULL,
0x00000016101072a4ULL, 0x000fe2000f8e0219ULL, 0x0000000700147c02ULL, 0x002fe20008000f00ULL,
0x000000ffff187224ULL, 0x000fc600078e0015ULL, 0x0000001914007c0cULL, 0x000fe4000bfa3070ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb804bff0075a7ULL, 0x000e640008060148ULL,
0x00000000005c3947ULL, 0x002ff00003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f66270ULL, 0x000000000044b947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f7e1ffULL,
0x0000000117177824ULL, 0x000fe200018e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x000000000008b947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x00000000001cb947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078710ffULL, 0x000000ffff177224ULL, 0x000fca00018e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb804bff0075a7ULL, 0x000e640008060148ULL, 0xfffffffc00a8b947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb8818ff0075a7ULL, 0x000e640008060148ULL,
0x00000000005c3947ULL, 0x002fea0003800000ULL, 0x000000ff001a7202ULL, 0x000fce0000000f00ULL,
0x000000101a00780cULL, 0x000fda0003f66270ULL, 0x000000000044b947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f7e1ffULL,
0x0000000117177824ULL, 0x000fe200018e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x000000000008b947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x00000000001cb947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078710ffULL, 0x000000ffff177224ULL, 0x000fca00018e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb8818ff0075a7ULL, 0x000e640008060148ULL, 0xfffffffc00a8b947ULL, 0x002fea000383ffffULL,
0x00000001100d7890ULL, 0x000fe4000fffe03fULL, 0x0000000f100c7291ULL, 0x000fe4000f8e103fULL,
0x000000050d00728cULL, 0x000fe4000bf06070ULL, 0x000000060c147899ULL, 0x000fc8000800063fULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x0000004009117892ULL, 0x000fd8000f8ef814ULL,
0x0000000800c8b947ULL, 0x000fea0003800000ULL, 0x0000000818227291ULL, 0x000fe2000f8e103fULL,
0x000000105a167824ULL, 0x000fe200078e00ffULL, 0x000000141a00728cULL, 0x000fe2000bf01070ULL,
0x00000018ff157e24ULL, 0x000fe2000f8e00ffULL, 0x0000001118207290ULL, 0x000fe4000fffe03fULL,
0x000000185a177c36ULL, 0x000fe20008000000ULL, 0x000000141a0c7287ULL, 0x000fe2000c000000ULL,
0x000001f016167812ULL, 0x000fe200078ec0ffULL, 0x0001400008237890ULL, 0x000fe2000fffe03fULL,
0x01ca0022ff147984ULL, 0x000e620008000800ULL, 0x0000000c14147290ULL, 0x000fe2000fffe13fULL,
0x0000000515187819ULL, 0x000fe200000006ffULL, 0x0000000118247890ULL, 0x000fe2000fffe03fULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x000000141800728cULL, 0x000fe2000bf01070ULL,
0xffffffe018177812ULL, 0x000fc600078ee217ULL, 0x00000024ff1a7e24ULL, 0x000fe2000f8e00ffULL,
0x0000001418147287ULL, 0x000fe2000c000000ULL, 0x0000002317197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe40008000000ULL, 0x0000001418147290ULL, 0x000fc8000fffe13fULL,
0x000000011400788cULL, 0x000fe2000bf03070ULL, 0x0000000814147c11ULL, 0x002fcc000f8e10ffULL,
0x01cac00014147984ULL, 0x000e640000000800ULL, 0x00000000141f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fe4000fffe03fULL,
0x0000000218247890ULL, 0x000fe4000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x00000014ff007c0cULL, 0x000fda000bf66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca0422ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe400078e00ffULL, 0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe4000f8e20ffULL,
0x000000245a187c10ULL, 0x000fe4000fffe0ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fe4000fffe03fULL,
0x0000000318247890ULL, 0x000fe4000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000021400788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca0822ff177984ULL, 0x000ea20008000800ULL, 0x000000201a197824ULL, 0x002fe400078e00ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001124207290ULL, 0x000fe4000fffe03fULL, 0x0000000418247890ULL, 0x000fe4000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000031400788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca0c22ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe200078e00ffULL, 0x00000024001a7c02ULL, 0x000fc80008000f00ULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fe4000fffe03fULL,
0x0000000518247890ULL, 0x000fe4000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000041400788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca1022ff177984ULL, 0x000ea20008000800ULL, 0x000000201a197824ULL, 0x002fe400078e00ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001124207290ULL, 0x000fe4000fffe03fULL, 0x0000000618247890ULL, 0x000fe4000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000051400788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1422ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe400078e00ffULL, 0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fc6000fffe03fULL,
0x00000021ff157c10ULL, 0x000fe40009ffe4ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000061400788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1822ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fca00078e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe4000f8e20ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000718207890ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x0000001120117290ULL, 0x000fe4000fffe03fULL, 0x00000020ff187e24ULL, 0x000fe2000f8e00ffULL,
0x000000071400788cULL, 0x000fd2000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1c22ff177984ULL, 0x000ea20008000800ULL,
0x0000000518197819ULL, 0x002fe400000006ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a1172a4ULL, 0x000fc8000f8e0211ULL, 0x00000200110c78a5ULL, 0x000fcc000f8e000cULL,
0x0000000c16147c10ULL, 0x000fe2000ff7e0ffULL, 0x000000205a167c36ULL, 0x000fc80008000000ULL,
0x0000000dff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe40003f6f008ULL,
0xffffffe019167812ULL, 0x000fc800078ee216ULL, 0x0000002316177c11ULL, 0x000fce000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d901c52ULL,
0x0000000800347947ULL, 0x000fea0003800000ULL, 0x000000185a197c11ULL, 0x040fe2000f8fd8ffULL,
0x00008a00ff167b82ULL, 0x000e620000000a00ULL, 0x000000105a1b7824ULL, 0x000fe200078e00ffULL,
0x00014000080c7890ULL, 0x000fe4000fffe03fULL, 0x0000000819187c11ULL, 0x040fe2000f8e10ffULL,
0x0000001119157c36ULL, 0x000fe20008000000ULL, 0x0000000119217810ULL, 0x000fe20007ffe0ffULL,
0x00000001191c7824ULL, 0x000fe200078e025aULL, 0x000001f01b1b7812ULL, 0x000fe200078ec0ffULL,
0x01ca000018147984ULL, 0x000ea20000000800ULL, 0x00000020191d7824ULL, 0x000fca00078e00ffULL,
0xffffffe01d1c7812ULL, 0x000fe200078ee21cULL, 0x00000011211d7c36ULL, 0x000fc60008000000ULL,
0x0000000c1c1f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x040fe400078e025aULL,
0x0000002021217824ULL, 0x000fca00078e00ffULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000219217836ULL, 0x000fe20000000000ULL, 0x00000008141a7c11ULL, 0x004fca000f8e10ffULL,
0x01cac0001a147984ULL, 0x000ea40000000800ULL, 0x0000000a14157c24ULL, 0x004fc8000f8e0215ULL,
0x0000020015147825ULL, 0x002fc600078e0016ULL, 0x0000001b14147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0400181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000005a211c7210ULL, 0x000fe40007ffe0ffULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000319217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0800181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f7e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000419217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0c00181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000002021217824ULL, 0x000fc600078e00ffULL, 0x00000015ff157210ULL, 0x000fe40001ffe4ffULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000519217836ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1000181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fe200078e0016ULL, 0x00000011211d7c10ULL, 0x000fc6000fffe0ffULL,
0x0000002021217824ULL, 0x000fe200078e00ffULL, 0x0000001b14147210ULL, 0x000fc80007f7e0ffULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff157224ULL, 0x000fe400018e0615ULL,
0x0000000619217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1400181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe40007f7e0ffULL,
0x0000000521217819ULL, 0x000fc600000006ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0xffffffe0211c7812ULL, 0x000fc800078ee21cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1800181a7984ULL, 0x000ea20000000800ULL,
0x00000007191f7836ULL, 0x002fc80000000000ULL, 0x000000111f197c36ULL, 0x000fe20008000000ULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fe200078e0016ULL,
0x0000000c1c1d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000201f1c7824ULL, 0x000fe200078e00ffULL,
0x0000001b14147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e8000b901c52ULL,
0x01ca1c0018187984ULL, 0x000ea40000000800ULL, 0x00000008181a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000ea40000000800ULL, 0x0000000a1a197c24ULL, 0x004fc8000f8e0219ULL,
0x0000020019167825ULL, 0x000fc800078e0016ULL, 0x000000011f197824ULL, 0x000fe200078e025aULL,
0x0000001b16147210ULL, 0x002fc80007f7e0ffULL, 0xffffffe01c197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600018e0617ULL, 0x0000000c19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c52ULL,
0x0000000100147802ULL, 0x002fcc0000000f00ULL, 0x01cb8814ff1479a7ULL, 0x000e640008500008ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000147805ULL, 0x000fc60000015200ULL,
0x01cb8818ff0075a7ULL, 0x000e640008060148ULL, 0x00000000005c3947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f66270ULL,
0x000000000044b947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f7e1ffULL, 0x0000000117177824ULL, 0x000fe200018e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x000000000008b947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x00000000001cb947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078710ffULL,
0x000000ffff177224ULL, 0x000fca00018e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb8818ff0075a7ULL, 0x000e640008060148ULL,
0xfffffffc00a8b947ULL, 0x002fea000383ffffULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4b7424ULL, 0x000fc600078e00ffULL, 0x00000000005c2947ULL, 0x000fea0003800000ULL,
0x000000100700728cULL, 0x000fe2000bf04070ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x0000000867197c11ULL, 0x000fe4000f8e10ffULL, 0x0000003f0e0c7287ULL, 0x000fc80008000000ULL,
0x0000000c0f0c7290ULL, 0x000fc8000fffe03fULL, 0x000000023f0d7899ULL, 0x000fe4000801160cULL,
0x000000060c0c7899ULL, 0x000fe4000800063fULL, 0x000000160d0d72a4ULL, 0x000fe4000f8e0210ULL,
0x000000c00c0c7892ULL, 0x000fc8000f8ec03fULL, 0x0000000c0d0c7291ULL, 0x000fe4000f8e403fULL,
0x0000003f0e0d7287ULL, 0x000fe4000c000000ULL, 0x000000200c117890ULL, 0x000fe4000fffe03fULL,
0x0000000d1b0c7290ULL, 0x000fc6000fffe03fULL, 0x00009400000d7ab9ULL, 0x000fe20000000800ULL,
0x0000001167167c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d0c0c72a4ULL, 0x000fc6000f8e0211ULL,
0x0000001a16007c0cULL, 0x000fc6000bf66070ULL, 0x0000000c67177c36ULL, 0x000fc80008000000ULL,
0x0000000417147825ULL, 0x002fcc00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1ca0000014197faeULL, 0x0003e4000d921852ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a5dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x01cb784bff5c79a7ULL, 0x0002a20008500008ULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x0000005eff00723eULL, 0x000fc800000000ffULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f7814027589ULL, 0x00066800000e0000ULL,
0x00001f7714007589ULL, 0x0006a400000e0000ULL, 0x012800006b1c783bULL, 0x0006a20000000200ULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x000000021c1c7232ULL, 0x086fe40000000000ULL,
0x000000021e1e7232ULL, 0x000fe40000000000ULL, 0x000000001d1d7232ULL, 0x080fe40000000000ULL,
0x000000001f1f7232ULL, 0x000fce0000000000ULL, 0x000000006a34783bULL, 0x000f280000004200ULL,
0x00000000692c783bULL, 0x000f680000004200ULL, 0x000000006824783bULL, 0x000f680000004200ULL,
0x000000006614783bULL, 0x008ee80000004200ULL, 0x012800004c18783bULL, 0x0006e20000000200ULL,
0x000000341c44723cULL, 0x014fec00000018ffULL, 0x0000002c1c30723cULL, 0x020fec00000018ffULL,
0x000000241c28723cULL, 0x000fec00000018ffULL, 0x000000361c34723cULL, 0x000fec00000018ffULL,
0x0000002e1c2c723cULL, 0x000fec00000018ffULL, 0x000000261c24723cULL, 0x000fec00000018ffULL,
0x000000141c20723cULL, 0x008fec00000018ffULL, 0x000000161c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000104947ULL, 0x002fde0003800000ULL,
0x0000000218187232ULL, 0x080fe40000000000ULL, 0x000000021a1a7232ULL, 0x000fe40000000000ULL,
0x0000000019197232ULL, 0x080fe40000000000ULL, 0x000000001b1b7232ULL, 0x000fce0000000000ULL,
0x000000006214783bULL, 0x000e620000004200ULL, 0x000001e000007945ULL, 0x000fe60003800000ULL,
0x000000006138783bULL, 0x000ea80000004200ULL, 0x00000000603c783bULL, 0x000ee80000004200ULL,
0x000000005f40783bULL, 0x000f220000004200ULL, 0x000000141844723cULL, 0x002fec0000001844ULL,
0x000000161834723cULL, 0x000fec0000001834ULL, 0x000000381830723cULL, 0x004fec0000001830ULL,
0x0000003a182c723cULL, 0x000fec000000182cULL, 0x0000003c1828723cULL, 0x008fec0000001828ULL,
0x0000003e1824723cULL, 0x000fec0000001824ULL, 0x000000401820723cULL, 0x010fec0000001820ULL,
0x00000042181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000400947ULL, 0x000fde0002800000ULL, 0x0000004403037221ULL, 0x000fe20000010000ULL,
0x0000004504047221ULL, 0x000fe20000010000ULL, 0x0000003407077221ULL, 0x000fe20000010000ULL,
0x0000003508087221ULL, 0x000fe20000010000ULL, 0x000000300b0b7221ULL, 0x000fe20000010000ULL,
0x000000310c0c7221ULL, 0x000fe20000010000ULL, 0x0000002c0f0f7221ULL, 0x000fe20000010000ULL,
0x0000002d12127221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244f4f7221ULL, 0x000fe20000010000ULL,
0x0000002550507221ULL, 0x000fe20000010000ULL, 0x0000002053537221ULL, 0x000fe20000010000ULL,
0x0000002154547221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5c7224ULL, 0x000fc600078e005dULL,
0x0000000000401947ULL, 0x000fea0003000000ULL, 0x0000004605057221ULL, 0x000fe20000010000ULL,
0x0000004706067221ULL, 0x000fe20000010000ULL, 0x0000003609097221ULL, 0x000fe20000010000ULL,
0x000000370a0a7221ULL, 0x000fe20000010000ULL, 0x000000320d0d7221ULL, 0x000fe20000010000ULL,
0x000000330e0e7221ULL, 0x000fe20000010000ULL, 0x0000002e13137221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4d4d7221ULL, 0x000fe20000010000ULL,
0x0000002b4e4e7221ULL, 0x000fe20000010000ULL, 0x0000002651517221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f10107221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x01cb884bff1479a7ULL, 0x000e660008500008ULL,
0x0000000b0400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000ffff187224ULL, 0x002fd800078e0015ULL, 0xffffffb400148947ULL, 0x000fea000383ffffULL,
0x0000008019047891ULL, 0x000fe2000f8e403fULL, 0x01cb604bffff79a7ULL, 0x0003e60008500008ULL,
0x0000001a0400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000009400f80947ULL, 0x002fea0003800000ULL, 0x0000003f00047c82ULL, 0x000fca0008000000ULL,
0x000000023f0c7899ULL, 0x000fe40008011604ULL, 0x00000003040f7892ULL, 0x000fe4000f8ec03fULL,
0x0000000c040c7287ULL, 0x000fe40008800000ULL, 0x0000003f0f0f7287ULL, 0x000fe4000c800000ULL,
0x000000020c0e7890ULL, 0x000fc8000fffe03fULL, 0x000000023f107899ULL, 0x000fe4000801160eULL,
0x000000030e227892ULL, 0x000fe4000f8ec03fULL, 0x00000016101072a4ULL, 0x000fe2000f8e0219ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb785cff0075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x002ff00003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fce0007ffe0ffULL,
0x01cb785cff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb8818ff0075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb8818ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000001100d7890ULL, 0x000fe4000fffe03fULL, 0x00000022100c7291ULL, 0x000fe4000f8e103fULL,
0x000000050d00728cULL, 0x000fe4000bf06070ULL, 0x000000200c147891ULL, 0x000fc8000f8e303fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000006009117892ULL, 0x000fd8000f8ef814ULL,
0x0000000800c88947ULL, 0x000fea0003800000ULL, 0x0000000818237291ULL, 0x000fe2000f8e103fULL,
0x000000105a167824ULL, 0x000fe200078e00ffULL, 0x000000141a00728cULL, 0x000fe2000bf01070ULL,
0x00000018ff177e24ULL, 0x000fe2000f8e00ffULL, 0x0000001118207290ULL, 0x000fe4000fffe03fULL,
0x000000185a157c10ULL, 0x000fe2000fffe0ffULL, 0x000000141a0c7287ULL, 0x000fe2000c000000ULL,
0x0000002017187824ULL, 0x000fe200078e00ffULL, 0x000001f016167812ULL, 0x000fe200078ec0ffULL,
0x01ca0023ff147984ULL, 0x000e620008000800ULL, 0x0000000c14147290ULL, 0x000fc4000fffe13fULL,
0x0001800008247890ULL, 0x000fe2000fffe03fULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x000000141800728cULL, 0x000fe2000bf01070ULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000118257890ULL, 0x000fe4000fffe03fULL, 0x0000002417197c11ULL, 0x000fe2000f8e20ffULL,
0x0000001418147287ULL, 0x000fc8000c000000ULL, 0x0000001418147290ULL, 0x000fe2000fffe13fULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x000000011400788cULL, 0x000fe2000bf03070ULL,
0x0000002018187824ULL, 0x000fe200078e00ffULL, 0x00000014ff007c0cULL, 0x000fe4000bf06070ULL,
0x0000000814147c11ULL, 0x002fcc000f8e10ffULL, 0x01cac00014147984ULL, 0x000e640000000800ULL,
0x00000000141f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200088e06ffULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000021400788cULL, 0x000fc6000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000c101c52ULL,
0x01ca0423ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c36ULL, 0x002fe20008000000ULL,
0x0000000218257890ULL, 0x000fe2000fffe03fULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fe400000e0000ULL,
0xffffffe018177812ULL, 0x000fe400078ee215ULL, 0x0000002500187c02ULL, 0x000fe40008000f00ULL,
0x0000002417197c11ULL, 0x000fc6000f8e20ffULL, 0x0000002018187824ULL, 0x000fc800078e00ffULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001125207290ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fca00080e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000031400788cULL, 0x000fe4000bf03070ULL, 0x01ca0823ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c36ULL, 0x002fe20008000000ULL, 0x0000000318257890ULL, 0x000fe2000fffe03fULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x0000002417197c11ULL, 0x000fe2000f8e20ffULL,
0x0000002018187824ULL, 0x000fcc00078e00ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000041400788cULL, 0x000fe4000bf03070ULL,
0x01ca0c23ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c36ULL, 0x002fe20008000000ULL,
0x0000000418257890ULL, 0x000fe2000fffe03fULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fe400000e0000ULL,
0xffffffe018177812ULL, 0x000fe200078ee215ULL, 0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL,
0x0000002417197c11ULL, 0x000fe2000f8e20ffULL, 0x0000002018187824ULL, 0x000fcc00078e00ffULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001125207290ULL, 0x000fc6000fffe03fULL,
0x00000021ff157c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000051400788cULL, 0x000fe4000bf03070ULL, 0x01ca1023ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c36ULL, 0x002fe20008000000ULL, 0x0000000518257890ULL, 0x000fe2000fffe03fULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x0000002417197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000518187819ULL, 0x000fca00000006ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000061400788cULL, 0x000fe4000bf03070ULL,
0x01ca1423ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c36ULL, 0x002fe20008000000ULL,
0x0000000618257890ULL, 0x000fe2000fffe03fULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fe400000e0000ULL,
0xffffffe018177812ULL, 0x000fe200078ee215ULL, 0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL,
0x0000002417197c11ULL, 0x000fe2000f8e20ffULL, 0x0000002018187824ULL, 0x000fcc00078e00ffULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001125207290ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fca00080e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000071400788cULL, 0x000fe4000bf03070ULL, 0x01ca1823ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c36ULL, 0x002fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fe400000e0000ULL,
0xffffffe018177812ULL, 0x000fc800078ee215ULL, 0x0000002417197c11ULL, 0x000fce000f8e20ffULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000718207890ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200080e06ffULL, 0x0000001120117290ULL, 0x000fe4000fffe03fULL,
0x00000020ff187e24ULL, 0x000fe4000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e4000c901c52ULL, 0x0000002018187824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x01ca1c23ff177984ULL, 0x000ea20008000800ULL,
0x000000205a157c10ULL, 0x002fc4000fffe0ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a1172a4ULL, 0x000fc8000f8e0211ULL, 0x00000200110c78a5ULL, 0x000fcc000f8e000cULL,
0x0000000c16147c10ULL, 0x000fe4000ff1e0ffULL, 0xffffffe018167812ULL, 0x000fc600078ee215ULL,
0x0000000dff157e24ULL, 0x000fe200080e06ffULL, 0x0000002416177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c901c52ULL,
0x0000000800347947ULL, 0x000fea0003800000ULL, 0x000000185a197c11ULL, 0x040fe2000f8fd8ffULL,
0x00008a00ff167b82ULL, 0x000e620000000a00ULL, 0x000000105a1b7824ULL, 0x000fe200078e00ffULL,
0x00018000080c7890ULL, 0x000fe4000fffe03fULL, 0x0000000819187c11ULL, 0x040fe2000f8e10ffULL,
0x0000001119157c36ULL, 0x000fe40008000000ULL, 0x00000001191c7824ULL, 0x000fe200078e025aULL,
0x000001f01b1b7812ULL, 0x000fe200078ec0ffULL, 0x01ca000018147984ULL, 0x000ea20000000800ULL,
0x00000020191d7824ULL, 0x000fc400078e00ffULL, 0x0000000119217836ULL, 0x000fc60000000000ULL,
0xffffffe01d1c7812ULL, 0x000fe200078ee21cULL, 0x00000011211d7c36ULL, 0x000fc60008000000ULL,
0x0000000c1c1f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x040fe400078e025aULL,
0x0000002021217824ULL, 0x000fca00078e00ffULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000219217836ULL, 0x000fe20000000000ULL, 0x00000008141a7c11ULL, 0x004fca000f8e10ffULL,
0x01cac0001a147984ULL, 0x000ea40000000800ULL, 0x0000000a14157c24ULL, 0x004fc8000f8e0215ULL,
0x0000020015147825ULL, 0x002fc600078e0016ULL, 0x0000001b14147210ULL, 0x000fc80007f1e0ffULL,
0x00000015ff157210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0400181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fe200078e0016ULL,
0x00000011211d7c10ULL, 0x000fc6000fffe0ffULL, 0x0000002021217824ULL, 0x000fe200078e00ffULL,
0x0000001b14147210ULL, 0x000fc80007f1e0ffULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x000000ffff157224ULL, 0x000fe400000e0615ULL, 0x0000000319217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0800181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe40007f1e0ffULL, 0x0000000521217819ULL, 0x000fc600000006ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000419217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0c00181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f1e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0xffffffe0211c7812ULL, 0x000fe400078ee21cULL, 0x0000000519217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1000181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f1e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000619217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1400181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000005a211c7210ULL, 0x000fe40007ffe0ffULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f1e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0xffffffe0211c7812ULL, 0x000fc800078ee21cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1800181a7984ULL, 0x000ea20000000800ULL,
0x00000007191f7836ULL, 0x002fc80000000000ULL, 0x000000111f197c36ULL, 0x000fe20008000000ULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fe200078e0016ULL,
0x0000000c1c1d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000201f1c7824ULL, 0x000fe200078e00ffULL,
0x0000001b14147210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e8000b901c52ULL,
0x01ca1c0018187984ULL, 0x000ea40000000800ULL, 0x00000008181a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000ea40000000800ULL, 0x0000000a1a197c24ULL, 0x004fc8000f8e0219ULL,
0x0000020019167825ULL, 0x000fc800078e0016ULL, 0x000000011f197824ULL, 0x000fe200078e025aULL,
0x0000001b16147210ULL, 0x002fc80007f1e0ffULL, 0xffffffe01c197812ULL, 0x000fe400078ee219ULL,
0x00000017ff157210ULL, 0x000fe400007fe4ffULL, 0x0000000c19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c52ULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x01cb8814ff1479a7ULL, 0x000e640008500008ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000147805ULL, 0x000fc60000015200ULL,
0x01cb8818ff0075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb8818ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000100700728cULL, 0x000fe2000bf04070ULL,
0x00000001005c7802ULL, 0x000fe20000000f00ULL, 0x000000010e0e7892ULL, 0x000fe4000f8ec03fULL,
0x000000030f00788cULL, 0x000fc8000c705270ULL, 0x000000010e00788cULL, 0x000fcc0008705470ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000600947ULL, 0x000fea0003800000ULL,
0x000000011c0d7892ULL, 0x000fe2000f8ec03fULL, 0x000000036700780cULL, 0x000fe20003f04070ULL,
0xffffffff160c7891ULL, 0x000fe2000f8e083fULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x000000010d00788cULL, 0x000fc8000bf05070ULL, 0x000000010c0c7887ULL, 0x000fc8000c000000ULL,
0x0000000c1c1c7290ULL, 0x000fe4000fffe03fULL, 0x00000000003c0947ULL, 0x000ff40003800000ULL,
0x00008c00ff147b82ULL, 0x000e620000000a00ULL, 0x00009000000c7ab9ULL, 0x000fe20000000800ULL,
0x000000061c00728cULL, 0x000fe2000bf06070ULL, 0x0000000479167824ULL, 0x000fe200078e0267ULL,
0x0000000c1c0d7290ULL, 0x000fe2000fffe03fULL, 0x0000000867197c11ULL, 0x000fe4000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x0000000dff177e24ULL, 0x000fc8000f8e00ffULL, 0x0000000c16177c24ULL, 0x000fc8000f8e0217ULL,
0x0000000417147825ULL, 0x002fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1cac000014197faeULL, 0x0003e4000c121852ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001a000007945ULL, 0x000fe80003800000ULL, 0x0000000000602947ULL, 0x000fea0003800000ULL,
0x000000100700728cULL, 0x000fe2000bf04070ULL, 0x00009200ff147b82ULL, 0x002e620000000a00ULL,
0x000000010f0c7890ULL, 0x000fe2000fffe03fULL, 0x0000000867197c11ULL, 0x000fc6000f8e10ffULL,
0x000000030c0d7892ULL, 0x000fc8000f8ec03fULL, 0x0000003f0d0d7287ULL, 0x000fe4000c000000ULL,
0x000000023f0c8899ULL, 0x000fc8000801160cULL, 0x0000000c220c7290ULL, 0x000fc8000fffe03fULL,
0x000000023f0e7899ULL, 0x000fe4000801160cULL, 0x000000060c0c7899ULL, 0x000fe4000800063fULL,
0x000000160e0e72a4ULL, 0x000fe4000f8e0210ULL, 0x000000c00c0c7892ULL, 0x000fc8000f8ec03fULL,
0x0000000c0e0e7291ULL, 0x000fe4000f8e403fULL, 0x0000000d1b0c7290ULL, 0x000fc6000fffe03fULL,
0x00009400000d7ab9ULL, 0x000fe20000000800ULL, 0x0000000e67167c36ULL, 0x000fe20008000000ULL,
0x0000000d0c0c72a4ULL, 0x000fc8000f8e020eULL, 0x0000001a16007c0cULL, 0x000fe4000bf06070ULL,
0x0000000c67177c36ULL, 0x000fc80008000000ULL, 0x0000000417147825ULL, 0x002fce00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1ca0000014197faeULL, 0x0003e4000c121852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a5eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x01cb805cff1479a7ULL, 0x000e620008500008ULL, 0x00000004ff007c0cULL, 0x000fe2000bf05270ULL,
0x000000ffff4b7224ULL, 0x002fd800078e0015ULL, 0x0000000400900947ULL, 0x000fea0003800000ULL,
0x01cb185c761479a7ULL, 0x000e640008500008ULL, 0x00000015001b7202ULL, 0x002fe40000000f00ULL,
0x0000000000147805ULL, 0x000fe40000015200ULL, 0x01cb181b760075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x01cb181b760075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000105a147824ULL, 0x000fe200078e00ffULL, 0x00000001ff157819ULL, 0x000fe2000001165aULL,
0x00000001ff657424ULL, 0x000fc600078e00ffULL, 0x0000007014147812ULL, 0x000fe400078ec0ffULL,
0x0000000c15157812ULL, 0x000fc800078ec0ffULL, 0x00000008151a7c10ULL, 0x000fca000fffe014ULL,
0x01c100001a147984ULL, 0x000e680000000800ULL, 0x01c300001a167984ULL, 0x0004a20000000800ULL,
0x000000111400720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15187812ULL, 0x000fe4000780c0ffULL, 0x0000001100157202ULL, 0x000fd60000000f00ULL,
0x0000000000e48947ULL, 0x004fea0003800000ULL, 0x000000021500788cULL, 0x000fe2000bf05270ULL,
0x000000111400720bULL, 0x000fe40003f14000ULL, 0x0000001411157209ULL, 0x000fc60007810000ULL,
0x000000000000781cULL, 0x000fd00003f2f008ULL, 0x0000000000197806ULL, 0x000fc800000e0100ULL,
0x0000991019177816ULL, 0x000fe200000000ffULL, 0x01c500151a009388ULL, 0x0003e60000000800ULL,
0x000000ff1700720cULL, 0x000fda0003f05270ULL, 0x0000000000a88947ULL, 0x002fea0003800000ULL,
0x8000001511117221ULL, 0x000fe20000010000ULL, 0x000000ff19ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0019ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x00000011001a7308ULL, 0x0002ac0000000800ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00001f781a117589ULL, 0x006e6400000e0000ULL, 0x0000001103037220ULL, 0x082fe20000410000ULL,
0x0000001104047220ULL, 0x080fe20000410000ULL, 0x0000001107077220ULL, 0x080fe20000410000ULL,
0x0000001108087220ULL, 0x080fe20000410000ULL, 0x000000110b0b7220ULL, 0x080fe20000410000ULL,
0x000000110c0c7220ULL, 0x080fe20000410000ULL, 0x000000110f0f7220ULL, 0x080fe20000410000ULL,
0x0000001112127220ULL, 0x080fe20000410000ULL, 0x0000001149497220ULL, 0x080fe20000410000ULL,
0x000000114a4a7220ULL, 0x080fe20000410000ULL, 0x000000114f4f7220ULL, 0x080fe20000410000ULL,
0x0000001150507220ULL, 0x080fe20000410000ULL, 0x0000001153537220ULL, 0x080fe20000410000ULL,
0x0000001154547220ULL, 0x080fe20000410000ULL, 0x0000001157577220ULL, 0x080fe20000410000ULL,
0x0000001158587220ULL, 0x000fce0000410000ULL, 0x0000001a5b5b7220ULL, 0x004fe20000410000ULL,
0x0000000000449947ULL, 0x000fec0003800000ULL, 0x00001f771a117589ULL, 0x002e6400000e0000ULL,
0x0000001105057220ULL, 0x082fe20000410000ULL, 0x0000001106067220ULL, 0x080fe20000410000ULL,
0x0000001109097220ULL, 0x080fe20000410000ULL, 0x000000110a0a7220ULL, 0x080fe20000410000ULL,
0x000000110d0d7220ULL, 0x080fe20000410000ULL, 0x000000110e0e7220ULL, 0x080fe20000410000ULL,
0x0000001113137220ULL, 0x080fe20000410000ULL, 0x0000001148487220ULL, 0x080fe20000410000ULL,
0x000000114d4d7220ULL, 0x080fe20000410000ULL, 0x000000114e4e7220ULL, 0x080fe20000410000ULL,
0x0000001151517220ULL, 0x080fe20000410000ULL, 0x0000001152527220ULL, 0x080fe20000410000ULL,
0x0000001155557220ULL, 0x080fe20000410000ULL, 0x0000001156567220ULL, 0x080fe20000410000ULL,
0x0000001159597220ULL, 0x080fe20000410000ULL, 0x0000001110107220ULL, 0x000fce0000410000ULL,
0x0000ffff18ff7812ULL, 0x000fda0007806019ULL, 0x8000001514140221ULL, 0x000fe20000010000ULL,
0x00007610ff650816ULL, 0x000fc60000000065ULL, 0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL,
0x00000014005e0308ULL, 0x000ea40000000800ULL, 0x0000005e16160220ULL, 0x004fce0000410000ULL,
0x0000005b165b7221ULL, 0x000fe20000010000ULL, 0x000000ffff117224ULL, 0x002fce00078e0015ULL,
0x000000ff65ff7812ULL, 0x000fda000788c0ffULL, 0x0000000000104947ULL, 0x000fea0003800000ULL,
0x0000005eff00723eULL, 0x000fc800000000ffULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f7814027589ULL, 0x0002a800000e0000ULL, 0x00001f7714007589ULL, 0x0002e400000e0000ULL,
0x01300000751c783bULL, 0x0002e20000000200ULL, 0x0000000000104947ULL, 0x000fea0003800000ULL,
0x000000021c1c7232ULL, 0x08cfe40000000000ULL, 0x000000021e1e7232ULL, 0x000fe40000000000ULL,
0x000000001d1d7232ULL, 0x080fe40000000000ULL, 0x000000001f1f7232ULL, 0x000fce0000000000ULL,
0x000000007434783bULL, 0x000f280000004200ULL, 0x00000000732c783bULL, 0x000f680000004200ULL,
0x000000007224783bULL, 0x000f680000004200ULL, 0x000000007114783bULL, 0x002e680000004200ULL,
0x013000007018783bULL, 0x0002620000000200ULL, 0x000000341c44723cULL, 0x018fec00000018ffULL,
0x0000002c1c30723cULL, 0x020fec00000018ffULL, 0x000000241c28723cULL, 0x000fec00000018ffULL,
0x000000361c34723cULL, 0x000fec00000018ffULL, 0x0000002e1c2c723cULL, 0x000fec00000018ffULL,
0x000000261c24723cULL, 0x000fec00000018ffULL, 0x000000141c20723cULL, 0x002fec00000018ffULL,
0x000000161c1c723cULL, 0x000fe200000018ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000104947ULL, 0x004fde0003800000ULL, 0x0000000218187232ULL, 0x080fe40000000000ULL,
0x000000021a1a7232ULL, 0x000fe40000000000ULL, 0x0000000019197232ULL, 0x080fe40000000000ULL,
0x000000001b1b7232ULL, 0x000fce0000000000ULL, 0x000000006f14783bULL, 0x000e620000004200ULL,
0x00000001040c7890ULL, 0x000fe4000fffe03fULL, 0x0000000478007c0cULL, 0x040fe2000bf06070ULL,
0x0000025000007945ULL, 0x000fe20003800000ULL, 0x000000006e38783bULL, 0x000ea20000004200ULL,
0x0000000477007c0cULL, 0x040fe4000bf26070ULL, 0x0000000c78007c0cULL, 0x000fe2000c706470ULL,
0x000000006d3c783bULL, 0x000ee20000004200ULL, 0x0000000c77007c0cULL, 0x000fc6000cf26470ULL,
0x000000006c40783bULL, 0x000f220000004200ULL, 0x000000141844723cULL, 0x002fec0000001844ULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x00000007ff147e24ULL, 0x000fe4000f8e00ffULL,
0x00000007ff157e24ULL, 0x000fc6000f8e00ffULL, 0x0000001914007c0cULL, 0x000fe2000bfa3070ULL,
0x000000381830723cULL, 0x004fe20000001830ULL, 0x0000001915007c0cULL, 0x000fca000bf63070ULL,
0x0000003a182c723cULL, 0x000fec000000182cULL, 0x0000003c1828723cULL, 0x008fec0000001828ULL,
0x0000003e1824723cULL, 0x000fec0000001824ULL, 0x000000401820723cULL, 0x010fec0000001820ULL,
0x00000042181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000400947ULL, 0x000fde0002800000ULL, 0x0000004403037221ULL, 0x000fe20000010000ULL,
0x0000004504047221ULL, 0x000fe20000010000ULL, 0x0000003407077221ULL, 0x000fe20000010000ULL,
0x0000003508087221ULL, 0x000fe20000010000ULL, 0x000000300b0b7221ULL, 0x000fe20000010000ULL,
0x000000310c0c7221ULL, 0x000fe20000010000ULL, 0x0000002c0f0f7221ULL, 0x000fe20000010000ULL,
0x0000002d12127221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244f4f7221ULL, 0x000fe20000010000ULL,
0x0000002550507221ULL, 0x000fe20000010000ULL, 0x0000002053537221ULL, 0x000fe20000010000ULL,
0x0000002154547221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000401947ULL, 0x000fea0001800000ULL,
0x0000004605057221ULL, 0x000fe20000010000ULL, 0x0000004706067221ULL, 0x000fe20000010000ULL,
0x0000003609097221ULL, 0x000fe20000010000ULL, 0x000000370a0a7221ULL, 0x000fe20000010000ULL,
0x000000320d0d7221ULL, 0x000fe20000010000ULL, 0x000000330e0e7221ULL, 0x000fe20000010000ULL,
0x0000002e13137221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4d4d7221ULL, 0x000fe20000010000ULL, 0x0000002b4e4e7221ULL, 0x000fe20000010000ULL,
0x0000002651517221ULL, 0x000fe20000010000ULL, 0x0000002752527221ULL, 0x000fe20000010000ULL,
0x0000002255557221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f10107221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01cb885cff1479a7ULL, 0x000e620008500008ULL,
0x000000023f0d7899ULL, 0x000fe2000801160cULL, 0x00000007ff167e24ULL, 0x000fe2000f8e00ffULL,
0x000000030c0e7892ULL, 0x000fe4000f8ec03fULL, 0x0000000d0c0d7287ULL, 0x000fe40008800000ULL,
0x0000001916007c0cULL, 0x000fe2000bfc3070ULL, 0x0000003f0e0e7287ULL, 0x000fe4000c800000ULL,
0x000000020d0d7890ULL, 0x000fc8000fffe03fULL, 0x000000023f107899ULL, 0x000fe4000801160dULL,
0x000000030d0f7892ULL, 0x000fe4000f8ec03fULL, 0x00000016101072a4ULL, 0x000fe2000f8e0219ULL,
0x00000007ff147e24ULL, 0x002fe4000f8e00ffULL, 0x000000ffff187224ULL, 0x000fc600078e0015ULL,
0x0000001914007c0cULL, 0x000fe4000bfa3070ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x01cb804bff0075a7ULL, 0x000e640008060148ULL, 0x00000000005c3947ULL, 0x002ff00003800000ULL,
0x000000ff001a7202ULL, 0x000fce0000000f00ULL, 0x000000101a00780cULL, 0x000fda0003f66270ULL,
0x000000000044b947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f7e1ffULL, 0x0000000117177824ULL, 0x000fe200018e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x000000000008b947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x00000000001cb947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078710ffULL,
0x000000ffff177224ULL, 0x000fca00018e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb804bff0075a7ULL, 0x000e640008060148ULL,
0xfffffffc00a8b947ULL, 0x002fea000383ffffULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x01cb8818ff0075a7ULL, 0x000e640008060148ULL, 0x00000000005c3947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f66270ULL,
0x000000000044b947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f7e1ffULL, 0x0000000117177824ULL, 0x000fe200018e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x000000000008b947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x00000000001cb947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078710ffULL,
0x000000ffff177224ULL, 0x000fca00018e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7810ULL, 0x000fce0007ffe0ffULL, 0x01cb8818ff0075a7ULL, 0x000e640008060148ULL,
0xfffffffc00a8b947ULL, 0x002fea000383ffffULL, 0x00000001100d7890ULL, 0x000fe4000fffe03fULL,
0x0000000f100c7291ULL, 0x000fe4000f8e103fULL, 0x000000050d00728cULL, 0x000fe4000bf06070ULL,
0x000000060c147899ULL, 0x000fc8000800063fULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x0000004009117892ULL, 0x000fd8000f8ef814ULL, 0x0000000800c8b947ULL, 0x000fea0003800000ULL,
0x0000000818227291ULL, 0x000fe2000f8e103fULL, 0x000000105a167824ULL, 0x000fe200078e00ffULL,
0x000000141a00728cULL, 0x000fe2000bf01070ULL, 0x00000018ff157e24ULL, 0x000fe2000f8e00ffULL,
0x0000001118207290ULL, 0x000fe4000fffe03fULL, 0x000000185a177c36ULL, 0x000fe20008000000ULL,
0x000000141a0c7287ULL, 0x000fe2000c000000ULL, 0x000001f016167812ULL, 0x000fe200078ec0ffULL,
0x0000002015187824ULL, 0x000fe200078e00ffULL, 0x01ca0022ff147984ULL, 0x000e620008000800ULL,
0x0000000c14147290ULL, 0x000fc4000fffe13fULL, 0x0001400008237890ULL, 0x000fe2000fffe03fULL,
0xffffffe018177812ULL, 0x000fe200078ee217ULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x000000141800728cULL, 0x000fe4000bf01070ULL, 0x0000000118247890ULL, 0x000fe2000fffe03fULL,
0x0000002317197c11ULL, 0x000fe2000f8e20ffULL, 0x0000001418147287ULL, 0x000fc8000c000000ULL,
0x0000001418147290ULL, 0x000fe2000fffe13fULL, 0x00000024ff1a7e24ULL, 0x000fe2000f8e00ffULL,
0x000000245a187c10ULL, 0x000fe4000fffe0ffULL, 0x000000011400788cULL, 0x000fe2000bf03070ULL,
0x0000000814147c11ULL, 0x002fcc000f8e10ffULL, 0x01cac00014147984ULL, 0x000e640000000800ULL,
0x00000000141f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001124207290ULL, 0x000fe4000fffe03fULL, 0x0000000218247890ULL, 0x000fe4000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x00000014ff007c0cULL, 0x000fda000bf66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca0422ff177984ULL, 0x000ea20008000800ULL, 0x000000201a197824ULL, 0x002fe400078e00ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001124207290ULL, 0x000fe4000fffe03fULL, 0x0000000318247890ULL, 0x000fe4000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000021400788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca0822ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe200078e00ffULL, 0x00000024001a7c02ULL, 0x000fc80008000f00ULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fe4000fffe03fULL,
0x0000000418247890ULL, 0x000fe4000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000031400788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca0c22ff177984ULL, 0x000ea20008000800ULL, 0x000000201a197824ULL, 0x002fe400078e00ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001124207290ULL, 0x000fe4000fffe03fULL, 0x0000000518247890ULL, 0x000fe4000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000041400788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1022ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe400078e00ffULL, 0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fe4000fffe03fULL,
0x0000000618247890ULL, 0x000fe2000fffe03fULL, 0x00000021ff157c10ULL, 0x000fe40009ffe4ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000051400788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca1422ff177984ULL, 0x000ea20008000800ULL, 0x000000201a197824ULL, 0x002fe400078e00ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001124207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000061400788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca1822ff177984ULL, 0x000ea20008000800ULL, 0x000000051a197819ULL, 0x002fc800000006ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000718207890ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x0000001120117290ULL, 0x000fe4000fffe03fULL,
0x00000020ff187e24ULL, 0x000fe2000f8e00ffULL, 0x000000071400788cULL, 0x000fd2000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca1c22ff177984ULL, 0x000ea20008000800ULL, 0x0000002018197824ULL, 0x002fe200078e00ffULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a1172a4ULL, 0x000fc8000f8e0211ULL,
0x00000200110c78a5ULL, 0x000fcc000f8e000cULL, 0x0000000c16147c10ULL, 0x000fe2000ff7e0ffULL,
0x000000205a167c36ULL, 0x000fc80008000000ULL, 0x0000000dff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe40003f6f008ULL, 0xffffffe019167812ULL, 0x000fc800078ee216ULL,
0x0000002316177c11ULL, 0x000fce000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d901c52ULL, 0x0000000800347947ULL, 0x000fea0003800000ULL,
0x000000185a197c11ULL, 0x040fe2000f8fd8ffULL, 0x00008a00ff167b82ULL, 0x000e620000000a00ULL,
0x000000045a1b7819ULL, 0x000fe200000006ffULL, 0x00014000080c7890ULL, 0x000fe4000fffe03fULL,
0x0000000819187c11ULL, 0x000fe2000f8e10ffULL, 0x0000001119157c36ULL, 0x000fe20008000000ULL,
0x000001f01b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000001191c7824ULL, 0x040fe400078e025aULL,
0x01ca000018147984ULL, 0x000ea20000000800ULL, 0x00000020191d7824ULL, 0x000fc400078e00ffULL,
0x0000000119217836ULL, 0x000fc60000000000ULL, 0xffffffe01d1c7812ULL, 0x000fe200078ee21cULL,
0x00000011211d7c36ULL, 0x000fc60008000000ULL, 0x0000000c1c1f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x040fe200078e025aULL, 0x0000000521217819ULL, 0x000fc800000006ffULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000219217836ULL, 0x000fe20000000000ULL,
0x00000008141a7c11ULL, 0x004fca000f8e10ffULL, 0x01cac0001a147984ULL, 0x000ea40000000800ULL,
0x0000000a14157c24ULL, 0x004fc8000f8e0215ULL, 0x0000020015147825ULL, 0x002fc600078e0016ULL,
0x0000001b14147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0400181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f7e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0xffffffe0211c7812ULL, 0x000fe400078ee21cULL,
0x0000000319217810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0800181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000419217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0c00181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe4000f8e20ffULL,
0x0000005a211c7210ULL, 0x000fe40007ffe0ffULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f7e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000519217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1000181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000619217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1400181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f7e0ffULL, 0x0000002021217824ULL, 0x000fc600078e00ffULL,
0x00000015ff157210ULL, 0x000fe40001ffe4ffULL, 0xffffffe0211c7812ULL, 0x000fc600078ee21cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1800181a7984ULL, 0x000ea20000000800ULL, 0x00000007191f7836ULL, 0x002fca0000000000ULL,
0x000000111f197c10ULL, 0x000fe4000fffe0ffULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fe200078e0016ULL, 0x0000000c1c1d7c11ULL, 0x000fc6000f8e20ffULL,
0x000000201f1c7824ULL, 0x000fe200078e00ffULL, 0x0000001b14147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e8000b901c52ULL, 0x01ca1c0018187984ULL, 0x000ea40000000800ULL,
0x00000008181a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000ea40000000800ULL,
0x0000000a1a197c24ULL, 0x004fc8000f8e0219ULL, 0x0000020019167825ULL, 0x000fc800078e0016ULL,
0x000000011f197824ULL, 0x000fe200078e025aULL, 0x0000001b16147210ULL, 0x002fc80007f7e0ffULL,
0xffffffe01c197812ULL, 0x000fe200078ee219ULL, 0x000000ffff157224ULL, 0x000fc600018e0617ULL,
0x0000000c19197c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e4000b901c52ULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x01cb8814ff1479a7ULL, 0x000e640008500008ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x01cb8818ff0075a7ULL, 0x000e640008060148ULL,
0x00000000005c3947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f66270ULL, 0x000000000044b947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fc80007f7e1ffULL,
0x0000001715177210ULL, 0x000fe40001ffe5ffULL, 0x003d09001900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x000000000008b947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x00000000001cb947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078710ffULL, 0x000000ffff177224ULL, 0x000fca00018e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb8818ff0075a7ULL, 0x000e640008060148ULL, 0xfffffffc00a8b947ULL, 0x002fea000383ffffULL,
0x000001a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4b7424ULL, 0x000fc600078e00ffULL,
0x00000000005c2947ULL, 0x000fea0003800000ULL, 0x000000100700728cULL, 0x000fe2000bf04070ULL,
0x00009200ff147b82ULL, 0x000e620000000a00ULL, 0x0000000867197c11ULL, 0x000fe4000f8e10ffULL,
0x0000003f0e0c7287ULL, 0x000fc80008000000ULL, 0x0000000c0f0c7290ULL, 0x000fc8000fffe03fULL,
0x000000023f0d7899ULL, 0x000fe4000801160cULL, 0x000000060c0c7899ULL, 0x000fe4000800063fULL,
0x000000160d0d72a4ULL, 0x000fe4000f8e0210ULL, 0x000000c00c0c7892ULL, 0x000fc8000f8ec03fULL,
0x0000000c0d0c7291ULL, 0x000fe4000f8e403fULL, 0x0000003f0e0d7287ULL, 0x000fe4000c000000ULL,
0x000000200c117890ULL, 0x000fe4000fffe03fULL, 0x0000000d1b0c7290ULL, 0x000fc6000fffe03fULL,
0x00009400000d7ab9ULL, 0x000fe20000000800ULL, 0x0000001167167c36ULL, 0x000fe20008000000ULL,
0x0000000d0c0c72a4ULL, 0x000fc8000f8e0211ULL, 0x0000001a16007c0cULL, 0x000fe4000bf66070ULL,
0x0000000c67177c36ULL, 0x000fc80008000000ULL, 0x0000000417147825ULL, 0x002fce00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1ca0000014197faeULL, 0x0003e4000d921852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a5dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x01cb784bff5c79a7ULL, 0x0002a20008500008ULL, 0x0000000000104947ULL, 0x000fea0003800000ULL,
0x0000005eff00723eULL, 0x000fc800000000ffULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f7814027589ULL, 0x00066800000e0000ULL, 0x00001f7714007589ULL, 0x0006a400000e0000ULL,
0x013000006b1c783bULL, 0x0006a20000000200ULL, 0x0000000000104947ULL, 0x000fea0003800000ULL,
0x000000021c1c7232ULL, 0x086fe40000000000ULL, 0x000000021e1e7232ULL, 0x000fe40000000000ULL,
0x000000001d1d7232ULL, 0x080fe40000000000ULL, 0x000000001f1f7232ULL, 0x000fce0000000000ULL,
0x000000006a34783bULL, 0x000f280000004200ULL, 0x00000000692c783bULL, 0x000f680000004200ULL,
0x000000006824783bULL, 0x000f680000004200ULL, 0x000000006614783bULL, 0x008ee80000004200ULL,
0x013000004c18783bULL, 0x0006e20000000200ULL, 0x000000341c44723cULL, 0x014fec00000018ffULL,
0x0000002c1c30723cULL, 0x020fec00000018ffULL, 0x000000241c28723cULL, 0x000fec00000018ffULL,
0x000000361c34723cULL, 0x000fec00000018ffULL, 0x0000002e1c2c723cULL, 0x000fec00000018ffULL,
0x000000261c24723cULL, 0x000fec00000018ffULL, 0x000000141c20723cULL, 0x008fec00000018ffULL,
0x000000161c1c723cULL, 0x000fe200000018ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000104947ULL, 0x002fde0003800000ULL, 0x0000000218187232ULL, 0x080fe40000000000ULL,
0x000000021a1a7232ULL, 0x000fe40000000000ULL, 0x0000000019197232ULL, 0x080fe40000000000ULL,
0x000000001b1b7232ULL, 0x000fce0000000000ULL, 0x000000006214783bULL, 0x000e620000004200ULL,
0x000001e000007945ULL, 0x000fe60003800000ULL, 0x000000006138783bULL, 0x000ea80000004200ULL,
0x00000000603c783bULL, 0x000ee80000004200ULL, 0x000000005f40783bULL, 0x000f220000004200ULL,
0x000000141844723cULL, 0x002fec0000001844ULL, 0x000000161834723cULL, 0x000fec0000001834ULL,
0x000000381830723cULL, 0x004fec0000001830ULL, 0x0000003a182c723cULL, 0x000fec000000182cULL,
0x0000003c1828723cULL, 0x008fec0000001828ULL, 0x0000003e1824723cULL, 0x000fec0000001824ULL,
0x000000401820723cULL, 0x010fec0000001820ULL, 0x00000042181c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000400947ULL, 0x000fde0002800000ULL,
0x0000004403037221ULL, 0x000fe20000010000ULL, 0x0000004504047221ULL, 0x000fe20000010000ULL,
0x0000003407077221ULL, 0x000fe20000010000ULL, 0x0000003508087221ULL, 0x000fe20000010000ULL,
0x000000300b0b7221ULL, 0x000fe20000010000ULL, 0x000000310c0c7221ULL, 0x000fe20000010000ULL,
0x0000002c0f0f7221ULL, 0x000fe20000010000ULL, 0x0000002d12127221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244f4f7221ULL, 0x000fe20000010000ULL, 0x0000002550507221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5c7224ULL, 0x000fc600078e005dULL, 0x0000000000401947ULL, 0x000fea0003000000ULL,
0x0000004605057221ULL, 0x000fe20000010000ULL, 0x0000004706067221ULL, 0x000fe20000010000ULL,
0x0000003609097221ULL, 0x000fe20000010000ULL, 0x000000370a0a7221ULL, 0x000fe20000010000ULL,
0x000000320d0d7221ULL, 0x000fe20000010000ULL, 0x000000330e0e7221ULL, 0x000fe20000010000ULL,
0x0000002e13137221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4d4d7221ULL, 0x000fe20000010000ULL, 0x0000002b4e4e7221ULL, 0x000fe20000010000ULL,
0x0000002651517221ULL, 0x000fe20000010000ULL, 0x0000002752527221ULL, 0x000fe20000010000ULL,
0x0000002255557221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f10107221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x01cb884bff1479a7ULL, 0x000e660008500008ULL, 0x0000000b0400728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x0000001500187202ULL, 0x002fd60000000f00ULL,
0xffffffb400148947ULL, 0x000fea000383ffffULL, 0x000000c019047891ULL, 0x000fe2000f8e403fULL,
0x01cb684bffff79a7ULL, 0x0003e60008500008ULL, 0x0000001a0400728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000004800f40947ULL, 0x002fea0003800000ULL,
0x0000003f00047c82ULL, 0x000fca0008000000ULL, 0x000000023f0c7899ULL, 0x000fe40008011604ULL,
0x00000003040f7892ULL, 0x000fe4000f8ec03fULL, 0x0000000c040c7287ULL, 0x000fe40008800000ULL,
0x0000003f0f0f7287ULL, 0x000fe4000c800000ULL, 0x000000030c0e7890ULL, 0x000fc8000fffe03fULL,
0x000000023f107899ULL, 0x000fe4000801160eULL, 0x000000030e227892ULL, 0x000fe4000f8ec03fULL,
0x00000016101072a4ULL, 0x000fe2000f8e0219ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x01cb785cff0075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002ff00003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb785cff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x01cb8818ff0075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fc800078110ffULL,
0x00000017ff177210ULL, 0x000fc800007fe4ffULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb8818ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001100d7890ULL, 0x000fe4000fffe03fULL,
0x00000022100c7291ULL, 0x000fe4000f8e103fULL, 0x000000050d00728cULL, 0x000fe4000bf06070ULL,
0x000000200c147891ULL, 0x000fc8000f8e303fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000006009117892ULL, 0x000fd8000f8ef814ULL, 0x0000000800c88947ULL, 0x000fea0003800000ULL,
0x0000000818237291ULL, 0x000fe2000f8e103fULL, 0x000000105a167824ULL, 0x000fe200078e00ffULL,
0x000000141a00728cULL, 0x000fe2000bf01070ULL, 0x00000018ff177e24ULL, 0x000fe2000f8e00ffULL,
0x0000001118207290ULL, 0x000fe4000fffe03fULL, 0x000000185a157c36ULL, 0x000fe20008000000ULL,
0x000000141a0c7287ULL, 0x000fe2000c000000ULL, 0x0000002017187824ULL, 0x000fe200078e00ffULL,
0x000001f016167812ULL, 0x000fe200078ec0ffULL, 0x01ca0023ff147984ULL, 0x000e620008000800ULL,
0x0000000c14147290ULL, 0x000fc4000fffe13fULL, 0x0001800008247890ULL, 0x000fe2000fffe03fULL,
0xffffffe018177812ULL, 0x000fe200078ee215ULL, 0x000000141800728cULL, 0x000fe2000bf01070ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000118257890ULL, 0x000fe4000fffe03fULL,
0x0000002417197c11ULL, 0x000fe2000f8e20ffULL, 0x0000001418147287ULL, 0x000fc8000c000000ULL,
0x0000001418147290ULL, 0x000fe2000fffe13fULL, 0x0000002500187c02ULL, 0x000fc60008000f00ULL,
0x000000011400788cULL, 0x000fe4000bf03070ULL, 0x00000014ff007c0cULL, 0x000fe2000bf06070ULL,
0x0000002018187824ULL, 0x000fe200078e00ffULL, 0x0000000814147c11ULL, 0x002fcc000f8e10ffULL,
0x01cac00014147984ULL, 0x000e640000000800ULL, 0x00000000141f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001125207290ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200088e06ffULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000021400788cULL, 0x000fc6000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000c101c52ULL, 0x01ca0423ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c36ULL, 0x002fe20008000000ULL, 0x0000000218257890ULL, 0x000fe2000fffe03fULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x0000002417197c11ULL, 0x000fe2000f8e20ffULL,
0x0000002018187824ULL, 0x000fcc00078e00ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000031400788cULL, 0x000fe4000bf03070ULL,
0x01ca0823ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c36ULL, 0x002fe20008000000ULL,
0x0000000318257890ULL, 0x000fe2000fffe03fULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fe400000e0000ULL,
0xffffffe018177812ULL, 0x000fe200078ee215ULL, 0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL,
0x0000002417197c11ULL, 0x000fe2000f8e20ffULL, 0x0000002018187824ULL, 0x000fcc00078e00ffULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001125207290ULL, 0x000fc6000fffe03fULL,
0x00000021ff157c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000041400788cULL, 0x000fe4000bf03070ULL, 0x01ca0c23ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c36ULL, 0x002fe20008000000ULL, 0x0000000418257890ULL, 0x000fe2000fffe03fULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x0000002417197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000518187819ULL, 0x000fca00000006ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000051400788cULL, 0x000fe4000bf03070ULL,
0x01ca1023ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c36ULL, 0x002fe20008000000ULL,
0x0000000518257890ULL, 0x000fe2000fffe03fULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fe400000e0000ULL,
0xffffffe018177812ULL, 0x000fe200078ee215ULL, 0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL,
0x0000002417197c11ULL, 0x000fe2000f8e20ffULL, 0x0000002018187824ULL, 0x000fcc00078e00ffULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001125207290ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fca00080e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c52ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000061400788cULL, 0x000fe4000bf03070ULL, 0x01ca1423ff177984ULL, 0x000ea20008000800ULL,
0x000000255a157c36ULL, 0x002fe20008000000ULL, 0x0000000618257890ULL, 0x000fe2000fffe03fULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fe200078ee215ULL,
0x00000025ff187e24ULL, 0x000fc6000f8e00ffULL, 0x0000002417197c11ULL, 0x000fe2000f8e20ffULL,
0x0000002018187824ULL, 0x000fcc00078e00ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001125207290ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fca00080e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c52ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000071400788cULL, 0x000fe4000bf03070ULL,
0x01ca1823ff177984ULL, 0x000ea20008000800ULL, 0x000000255a157c10ULL, 0x002fe4000fffe0ffULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fe400000e0000ULL, 0xffffffe018177812ULL, 0x000fc800078ee215ULL,
0x0000002417197c11ULL, 0x000fce000f8e20ffULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000718207890ULL, 0x000fc8000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200080e06ffULL,
0x0000001120117290ULL, 0x000fe4000fffe03fULL, 0x00000020ff187e24ULL, 0x000fe4000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000c901c52ULL,
0x0000002018187824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x01ca1c23ff177984ULL, 0x000ea20008000800ULL, 0x000000205a157c36ULL, 0x002fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a1172a4ULL, 0x000fc8000f8e0211ULL,
0x00000200110c78a5ULL, 0x000fcc000f8e000cULL, 0x0000000c16147c10ULL, 0x000fe4000ff1e0ffULL,
0xffffffe018167812ULL, 0x000fc600078ee215ULL, 0x0000000dff157e24ULL, 0x000fe200080e06ffULL,
0x0000002416177c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c901c52ULL, 0x0000000800347947ULL, 0x000fea0003800000ULL,
0x000000185a197c11ULL, 0x040fe2000f8fd8ffULL, 0x00008a00ff167b82ULL, 0x000e620000000a00ULL,
0x000000105a1b7824ULL, 0x000fe200078e00ffULL, 0x00018000080c7890ULL, 0x000fe4000fffe03fULL,
0x0000000819187c11ULL, 0x040fe2000f8e10ffULL, 0x00000001191c7824ULL, 0x040fe200078e025aULL,
0x0000001119157c10ULL, 0x000fe2000fffe0ffULL, 0x00000020191d7824ULL, 0x000fe200078e00ffULL,
0x000001f01b1b7812ULL, 0x000fe200078ec0ffULL, 0x01ca000018147984ULL, 0x000ea20000000800ULL,
0x0000000119217836ULL, 0x000fc40000000000ULL, 0xffffffe01d1c7812ULL, 0x000fe400078ee21cULL,
0x00000011211d7c36ULL, 0x000fe40008000000ULL, 0x0000000c1c1f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000005a211c7210ULL, 0x000fe20007ffe0ffULL, 0x0000002021217824ULL, 0x000fca00078e00ffULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000219217836ULL, 0x000fe20000000000ULL,
0x00000008141a7c11ULL, 0x004fca000f8e10ffULL, 0x01cac0001a147984ULL, 0x000ea40000000800ULL,
0x0000000a14157c24ULL, 0x004fc8000f8e0215ULL, 0x0000020015147825ULL, 0x002fc600078e0016ULL,
0x0000001b14147210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0400181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f1e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000319217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0800181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f1e0ffULL,
0x0000002021217824ULL, 0x000fc600078e00ffULL, 0x00000015ff157210ULL, 0x000fe400007fe4ffULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000419217836ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0c00181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fe200078e0016ULL, 0x00000011211d7c10ULL, 0x000fc6000fffe0ffULL,
0x0000002021217824ULL, 0x000fe200078e00ffULL, 0x0000001b14147210ULL, 0x000fc80007f1e0ffULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff157224ULL, 0x000fe400000e0615ULL,
0x0000000519217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1000181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe40007f1e0ffULL,
0x0000000521217819ULL, 0x000fc600000006ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0xffffffe0211c7812ULL, 0x000fe200078ee21cULL, 0x0000000619217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1400181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f1e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0xffffffe0211c7812ULL, 0x000fc800078ee21cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1800181a7984ULL, 0x000ea20000000800ULL, 0x00000007191f7810ULL, 0x002fca0007ffe0ffULL,
0x000000111f197c36ULL, 0x000fe20008000000ULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fe200078e0016ULL, 0x0000000c1c1d7c11ULL, 0x000fc6000f8e20ffULL,
0x000000201f1c7824ULL, 0x000fe200078e00ffULL, 0x0000001b14147210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e8000b901c52ULL, 0x01ca1c0018187984ULL, 0x000ea40000000800ULL,
0x00000008181a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000ea40000000800ULL,
0x0000000a1a197c24ULL, 0x004fc8000f8e0219ULL, 0x0000020019167825ULL, 0x000fc800078e0016ULL,
0x000000011f197824ULL, 0x000fe200078e025aULL, 0x0000001b16147210ULL, 0x002fc80007f1e0ffULL,
0xffffffe01c197812ULL, 0x000fe200078ee219ULL, 0x000000ffff157224ULL, 0x000fc600000e0617ULL,
0x0000000c19197c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e4000b901c52ULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x01cb8814ff1479a7ULL, 0x000e640008500008ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x01cb8818ff0075a7ULL, 0x000e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ff001a7202ULL, 0x000fce0000000f00ULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb8818ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000100700728cULL, 0x000fe2000bf04070ULL, 0x00000001ff5c7424ULL, 0x000fe200078e00ffULL,
0x000000010e0e7892ULL, 0x000fe4000f8ec03fULL, 0x000000030f00788cULL, 0x000fc8000c705270ULL,
0x000000010e00788cULL, 0x000fcc0008705470ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000600947ULL, 0x000fea0003800000ULL, 0x000000011c0d7892ULL, 0x000fe2000f8ec03fULL,
0x000000036700780cULL, 0x000fe20003f04070ULL, 0xffffffff160c7891ULL, 0x000fe2000f8e083fULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x000000010d00788cULL, 0x000fc8000bf05070ULL,
0x000000010c0c7887ULL, 0x000fc8000c000000ULL, 0x0000000c1c1c7290ULL, 0x000fe4000fffe03fULL,
0x00000000003c0947ULL, 0x000ff40003800000ULL, 0x00008c00ff147b82ULL, 0x000e620000000a00ULL,
0x00009000000c7ab9ULL, 0x000fe20000000800ULL, 0x000000061c00728cULL, 0x000fe2000bf06070ULL,
0x0000000479167824ULL, 0x000fe200078e0267ULL, 0x0000000c1c0d7290ULL, 0x000fe2000fffe03fULL,
0x0000000867197c11ULL, 0x000fe4000f8e10ffULL, 0x0000000216167824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x0000000d00177c02ULL, 0x000fca0008000f00ULL,
0x0000000c16177c24ULL, 0x000fc8000f8e0217ULL, 0x0000000417147825ULL, 0x002fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1cac000014197faeULL, 0x0003e4000c121852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001a000007945ULL, 0x000fe80003800000ULL,
0x0000000000602947ULL, 0x000fea0003800000ULL, 0x000000100700728cULL, 0x000fe2000bf04070ULL,
0x00009200ff147b82ULL, 0x002e620000000a00ULL, 0x000000010f0c7890ULL, 0x000fe2000fffe03fULL,
0x0000000867197c11ULL, 0x000fc6000f8e10ffULL, 0x000000030c0d7892ULL, 0x000fc8000f8ec03fULL,
0x0000003f0d0d7287ULL, 0x000fe4000c000000ULL, 0x000000023f0c8899ULL, 0x000fc8000801160cULL,
0x0000000c220c7290ULL, 0x000fc8000fffe03fULL, 0x000000023f0e7899ULL, 0x000fe4000801160cULL,
0x000000060c0c7899ULL, 0x000fe4000800063fULL, 0x000000160e0e72a4ULL, 0x000fe4000f8e0210ULL,
0x000000c00c0c7892ULL, 0x000fc8000f8ec03fULL, 0x0000000c0e0e7291ULL, 0x000fe4000f8e403fULL,
0x0000000d1b0c7290ULL, 0x000fc6000fffe03fULL, 0x00009400000d7ab9ULL, 0x000fe20000000800ULL,
0x0000000e67167c36ULL, 0x000fe20008000000ULL, 0x0000000d0c0c72a4ULL, 0x000fc8000f8e020eULL,
0x0000001a16007c0cULL, 0x000fe4000bf06070ULL, 0x0000000c67177c36ULL, 0x000fc80008000000ULL,
0x0000000417147825ULL, 0x002fce00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1ca0000014197faeULL, 0x0003e4000c121852ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a5eULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x01cb805cff1479a7ULL, 0x000e620008500008ULL,
0x00000004ff007c0cULL, 0x000fe2000bf05270ULL, 0x000000ffff4b7224ULL, 0x002fd800078e0015ULL,
0x0000000400900947ULL, 0x000fea0003800000ULL, 0x01cb385c761479a7ULL, 0x000e640008500008ULL,
0x000000ffff1b7224ULL, 0x002fe200078e0015ULL, 0x0000000000147805ULL, 0x000fc60000015200ULL,
0x01cb381b760075a7ULL, 0x000e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fc800078110ffULL,
0x00000017ff177210ULL, 0x000fc800007fe4ffULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x01cb381b760075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000105a147824ULL, 0x000fe200078e00ffULL,
0x00000001ff157819ULL, 0x000fe2000001165aULL, 0x00000001ff657424ULL, 0x000fc600078e00ffULL,
0x0000007014147812ULL, 0x000fe400078ec0ffULL, 0x0000000c15157812ULL, 0x000fc800078ec0ffULL,
0x00000008151a7c10ULL, 0x000fca000fffe014ULL, 0x01c180001a147984ULL, 0x000e680000000800ULL,
0x01c380001a167984ULL, 0x0004a20000000800ULL, 0x000000111400720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15187812ULL, 0x000fe2000780c0ffULL,
0x000000ffff157224ULL, 0x000fd800078e0011ULL, 0x0000000000e48947ULL, 0x004fea0003800000ULL,
0x000000031500788cULL, 0x000fe2000bf05270ULL, 0x000000111400720bULL, 0x000fe40003f14000ULL,
0x0000001411157209ULL, 0x000fc60007810000ULL, 0x000000000000781cULL, 0x000fd00003f2f008ULL,
0x0000000000197806ULL, 0x000fc800000e0100ULL, 0x0000991019177816ULL, 0x000fe200000000ffULL,
0x01c580151a009388ULL, 0x0003e60000000800ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x0000000000a88947ULL, 0x002fea0003800000ULL, 0x8000001511117221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000782c0ffULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x00000011001a7308ULL, 0x0002ac0000000800ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00001f781a117589ULL, 0x006e6400000e0000ULL,
0x0000001103037220ULL, 0x082fe20000410000ULL, 0x0000001104047220ULL, 0x080fe20000410000ULL,
0x0000001107077220ULL, 0x080fe20000410000ULL, 0x0000001108087220ULL, 0x080fe20000410000ULL,
0x000000110b0b7220ULL, 0x080fe20000410000ULL, 0x000000110c0c7220ULL, 0x080fe20000410000ULL,
0x000000110f0f7220ULL, 0x080fe20000410000ULL, 0x0000001112127220ULL, 0x080fe20000410000ULL,
0x0000001149497220ULL, 0x080fe20000410000ULL, 0x000000114a4a7220ULL, 0x080fe20000410000ULL,
0x000000114f4f7220ULL, 0x080fe20000410000ULL, 0x0000001150507220ULL, 0x080fe20000410000ULL,
0x0000001153537220ULL, 0x080fe20000410000ULL, 0x0000001154547220ULL, 0x080fe20000410000ULL,
0x0000001157577220ULL, 0x080fe20000410000ULL, 0x0000001158587220ULL, 0x000fce0000410000ULL,
0x0000001a5b5b7220ULL, 0x004fe20000410000ULL, 0x0000000000449947ULL, 0x000fec0003800000ULL,
0x00001f771a117589ULL, 0x002e6400000e0000ULL, 0x0000001105057220ULL, 0x082fe20000410000ULL,
0x0000001106067220ULL, 0x080fe20000410000ULL, 0x0000001109097220ULL, 0x080fe20000410000ULL,
0x000000110a0a7220ULL, 0x080fe20000410000ULL, 0x000000110d0d7220ULL, 0x080fe20000410000ULL,
0x000000110e0e7220ULL, 0x080fe20000410000ULL, 0x0000001113137220ULL, 0x080fe20000410000ULL,
0x0000001148487220ULL, 0x080fe20000410000ULL, 0x000000114d4d7220ULL, 0x080fe20000410000ULL,
0x000000114e4e7220ULL, 0x080fe20000410000ULL, 0x0000001151517220ULL, 0x080fe20000410000ULL,
0x0000001152527220ULL, 0x080fe20000410000ULL, 0x0000001155557220ULL, 0x080fe20000410000ULL,
0x0000001156567220ULL, 0x080fe20000410000ULL, 0x0000001159597220ULL, 0x080fe20000410000ULL,
0x0000001110107220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007806019ULL,
0x8000001514140221ULL, 0x000fe20000010000ULL, 0x00007610ff650816ULL, 0x000fc60000000065ULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x00000014005e0308ULL, 0x000ea40000000800ULL,
0x0000005e16160220ULL, 0x004fce0000410000ULL, 0x0000005b165b7221ULL, 0x000fe20000010000ULL,
0x000000ffff117224ULL, 0x002fce00078e0015ULL, 0x000000ff65ff7812ULL, 0x000fda000788c0ffULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x0000005eff00723eULL, 0x000fc800000000ffULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f7814027589ULL, 0x0002a800000e0000ULL,
0x00001f7714007589ULL, 0x0002e400000e0000ULL, 0x01380000751c783bULL, 0x0002e20000000200ULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x000000021c1c7232ULL, 0x08cfe40000000000ULL,
0x000000021e1e7232ULL, 0x000fe40000000000ULL, 0x000000001d1d7232ULL, 0x080fe40000000000ULL,
0x000000001f1f7232ULL, 0x000fce0000000000ULL, 0x000000007434783bULL, 0x000f280000004200ULL,
0x00000000732c783bULL, 0x000f680000004200ULL, 0x000000007224783bULL, 0x000f680000004200ULL,
0x000000007114783bULL, 0x002e680000004200ULL, 0x013800007018783bULL, 0x0002620000000200ULL,
0x000000341c44723cULL, 0x018fec00000018ffULL, 0x0000002c1c30723cULL, 0x020fec00000018ffULL,
0x000000241c28723cULL, 0x000fec00000018ffULL, 0x000000361c34723cULL, 0x000fec00000018ffULL,
0x0000002e1c2c723cULL, 0x000fec00000018ffULL, 0x000000261c24723cULL, 0x000fec00000018ffULL,
0x000000141c20723cULL, 0x002fec00000018ffULL, 0x000000161c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000104947ULL, 0x004fde0003800000ULL,
0x0000000218187232ULL, 0x080fe40000000000ULL, 0x000000021a1a7232ULL, 0x000fe40000000000ULL,
0x0000000019197232ULL, 0x080fe40000000000ULL, 0x000000001b1b7232ULL, 0x000fce0000000000ULL,
0x000000006f14783bULL, 0x000e620000004200ULL, 0x00000001040c7890ULL, 0x000fe4000fffe03fULL,
0x0000000478007c0cULL, 0x040fe2000bf06070ULL, 0x0000025000007945ULL, 0x000fe20003800000ULL,
0x000000006e38783bULL, 0x000ea20000004200ULL, 0x0000000477007c0cULL, 0x040fe4000bf26070ULL,
0x0000000c78007c0cULL, 0x000fe2000c706470ULL, 0x000000006d3c783bULL, 0x000ee20000004200ULL,
0x0000000c77007c0cULL, 0x000fc6000cf26470ULL, 0x000000006c40783bULL, 0x000f220000004200ULL,
0x000000141844723cULL, 0x002fec0000001844ULL, 0x000000161834723cULL, 0x000fe20000001834ULL,
0x00000007ff147e24ULL, 0x000fe2000f8e00ffULL, 0x0000000700157c02ULL, 0x000fc80008000f00ULL,
0x0000001914007c0cULL, 0x000fe2000bfa3070ULL, 0x000000381830723cULL, 0x004fe20000001830ULL,
0x0000001915007c0cULL, 0x000fca000bf63070ULL, 0x0000003a182c723cULL, 0x000fec000000182cULL,
0x0000003c1828723cULL, 0x008fec0000001828ULL, 0x0000003e1824723cULL, 0x000fec0000001824ULL,
0x000000401820723cULL, 0x010fec0000001820ULL, 0x00000042181c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000400947ULL, 0x000fde0002800000ULL,
0x0000004403037221ULL, 0x000fe20000010000ULL, 0x0000004504047221ULL, 0x000fe20000010000ULL,
0x0000003407077221ULL, 0x000fe20000010000ULL, 0x0000003508087221ULL, 0x000fe20000010000ULL,
0x000000300b0b7221ULL, 0x000fe20000010000ULL, 0x000000310c0c7221ULL, 0x000fe20000010000ULL,
0x0000002c0f0f7221ULL, 0x000fe20000010000ULL, 0x0000002d12127221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244f4f7221ULL, 0x000fe20000010000ULL, 0x0000002550507221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000401947ULL, 0x000fea0001800000ULL, 0x0000004605057221ULL, 0x000fe20000010000ULL,
0x0000004706067221ULL, 0x000fe20000010000ULL, 0x0000003609097221ULL, 0x000fe20000010000ULL,
0x000000370a0a7221ULL, 0x000fe20000010000ULL, 0x000000320d0d7221ULL, 0x000fe20000010000ULL,
0x000000330e0e7221ULL, 0x000fe20000010000ULL, 0x0000002e13137221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4d4d7221ULL, 0x000fe20000010000ULL,
0x0000002b4e4e7221ULL, 0x000fe20000010000ULL, 0x0000002651517221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f10107221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01cb885cff1479a7ULL, 0x000e620008500008ULL, 0x000000023f0d7899ULL, 0x000fe2000801160cULL,
0x00000007ff167e24ULL, 0x000fe2000f8e00ffULL, 0x000000030c0e7892ULL, 0x000fe4000f8ec03fULL,
0x0000000d0c0d7287ULL, 0x000fe40008800000ULL, 0x0000001916007c0cULL, 0x000fe2000bfc3070ULL,
0x0000003f0e0e7287ULL, 0x000fe4000c800000ULL, 0x000000030d0d7890ULL, 0x000fc8000fffe03fULL,
0x000000023f107899ULL, 0x000fe4000801160dULL, 0x000000030d0f7892ULL, 0x000fe4000f8ec03fULL,
0x00000016101072a4ULL, 0x000fe2000f8e0219ULL, 0x00000007ff147e24ULL, 0x002fe4000f8e00ffULL,
0x000000ffff187224ULL, 0x000fc600078e0015ULL, 0x0000001914007c0cULL, 0x000fe4000bfa3070ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb804bff0075a7ULL, 0x000e640008060148ULL,
0x00000000005c3947ULL, 0x002ff00003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f66270ULL, 0x000000000044b947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f7e1ffULL,
0x0000000117177824ULL, 0x000fe200018e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x000000000008b947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x00000000001cb947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078710ffULL, 0x000000ffff177224ULL, 0x000fca00018e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fce0007ffe0ffULL,
0x01cb804bff0075a7ULL, 0x000e640008060148ULL, 0xfffffffc00a8b947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01cb8818ff0075a7ULL, 0x000e640008060148ULL,
0x00000000005c3947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f66270ULL, 0x000000000044b947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f7e1ffULL,
0x0000000117177824ULL, 0x000fe200018e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x000000000008b947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x00000000001cb947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078710ffULL, 0x000000ffff177224ULL, 0x000fca00018e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01cb8818ff0075a7ULL, 0x000e640008060148ULL, 0xfffffffc00a8b947ULL, 0x002fea000383ffffULL,
0x00000001100d7890ULL, 0x000fe4000fffe03fULL, 0x0000000f100c7291ULL, 0x000fe4000f8e103fULL,
0x000000050d00728cULL, 0x000fe4000bf06070ULL, 0x000000060c147899ULL, 0x000fc8000800063fULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x0000004009117892ULL, 0x000fd8000f8ef814ULL,
0x0000000800c8b947ULL, 0x000fea0003800000ULL, 0x0000000818227291ULL, 0x000fe2000f8e103fULL,
0x000000105a167824ULL, 0x000fe200078e00ffULL, 0x000000141a00728cULL, 0x000fe2000bf01070ULL,
0x00000018ff157e24ULL, 0x000fe2000f8e00ffULL, 0x0000001118207290ULL, 0x000fe4000fffe03fULL,
0x000000185a177c10ULL, 0x000fe2000fffe0ffULL, 0x000000141a0c7287ULL, 0x000fe2000c000000ULL,
0x000001f016167812ULL, 0x000fe200078ec0ffULL, 0x0000002015187824ULL, 0x000fe200078e00ffULL,
0x01ca0022ff147984ULL, 0x000e620008000800ULL, 0x0000000c14147290ULL, 0x000fc4000fffe13fULL,
0x0001400008237890ULL, 0x000fe2000fffe03fULL, 0xffffffe018177812ULL, 0x000fe200078ee217ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x000000141800728cULL, 0x000fe4000bf01070ULL,
0x0000000118247890ULL, 0x000fe2000fffe03fULL, 0x0000002317197c11ULL, 0x000fe2000f8e20ffULL,
0x0000001418147287ULL, 0x000fc8000c000000ULL, 0x0000001418147290ULL, 0x000fe2000fffe13fULL,
0x00000024ff1a7e24ULL, 0x000fe4000f8e00ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x000000011400788cULL, 0x000fe2000bf03070ULL, 0x0000000814147c11ULL, 0x002fcc000f8e10ffULL,
0x01cac00014147984ULL, 0x000e640000000800ULL, 0x00000000141f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fe4000fffe03fULL,
0x0000000218247890ULL, 0x000fe4000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x00000014ff007c0cULL, 0x000fda000bf66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca0422ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe200078e00ffULL, 0x00000024001a7c02ULL, 0x000fc80008000f00ULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fe4000fffe03fULL,
0x0000000318247890ULL, 0x000fe4000fffe03fULL, 0x00000021ff157e24ULL, 0x000fe200098e06ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000021400788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca0822ff177984ULL, 0x000ea20008000800ULL, 0x000000201a197824ULL, 0x002fe400078e00ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001124207290ULL, 0x000fe4000fffe03fULL, 0x0000000418247890ULL, 0x000fe4000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000031400788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca0c22ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fe400078e00ffULL, 0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fe4000fffe03fULL,
0x0000000518247890ULL, 0x000fe2000fffe03fULL, 0x00000021ff157c10ULL, 0x000fe40009ffe4ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x000000041400788cULL, 0x000fd8000bf03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e8000d901c52ULL,
0x01ca1022ff177984ULL, 0x000ea20008000800ULL, 0x000000201a197824ULL, 0x002fe400078e00ffULL,
0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe2000f8e20ffULL, 0x000000245a187c36ULL, 0x000fe20008000000ULL,
0x0000000817177c11ULL, 0x004fcc000f8e10ffULL, 0x01cac00017177984ULL, 0x000e640000000800ULL,
0x00000000171f72caULL, 0x002fda00000e0000ULL, 0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL,
0x00000200202078a5ULL, 0x000fcc000f8e000cULL, 0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001124207290ULL, 0x000fe4000fffe03fULL, 0x0000000618247890ULL, 0x000fe4000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000051400788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1422ff177984ULL, 0x000ea20008000800ULL,
0x000000051a197819ULL, 0x002fe200000006ffULL, 0x00000024ff1a7e24ULL, 0x000fc6000f8e00ffULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000002318197c11ULL, 0x000fe2000f8e20ffULL,
0x000000245a187c36ULL, 0x000fe20008000000ULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001124207290ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000061400788cULL, 0x000fd8000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1822ff177984ULL, 0x000ea20008000800ULL,
0x000000201a197824ULL, 0x002fca00078e00ffULL, 0xffffffe019187812ULL, 0x000fc800078ee218ULL,
0x0000002318197c11ULL, 0x000fe4000f8e20ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a2072a4ULL, 0x000fc8000f8e0220ULL, 0x00000200202078a5ULL, 0x000fcc000f8e000cULL,
0x0000002016147c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000718207890ULL, 0x000fc8000fffe03fULL,
0x00000021ff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x0000001120117290ULL, 0x000fe4000fffe03fULL, 0x00000020ff187e24ULL, 0x000fe2000f8e00ffULL,
0x000000071400788cULL, 0x000fd2000bf03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e8000d901c52ULL, 0x01ca1c22ff177984ULL, 0x000ea20008000800ULL,
0x0000002018197824ULL, 0x002fe200078e00ffULL, 0x0000000817177c11ULL, 0x004fcc000f8e10ffULL,
0x01cac00017177984ULL, 0x000e640000000800ULL, 0x00000000171f72caULL, 0x002fda00000e0000ULL,
0x0000001f0a1172a4ULL, 0x000fc8000f8e0211ULL, 0x00000200110c78a5ULL, 0x000fcc000f8e000cULL,
0x0000000c16147c10ULL, 0x000fe4000ff7e0ffULL, 0x000000205a167c10ULL, 0x000fc6000fffe0ffULL,
0x0000000dff157e24ULL, 0x000fe200098e06ffULL, 0x000000000000781cULL, 0x000fe40003f6f008ULL,
0xffffffe019167812ULL, 0x000fc800078ee216ULL, 0x0000002316177c11ULL, 0x000fce000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d901c52ULL,
0x0000000800347947ULL, 0x000fea0003800000ULL, 0x000000185a197c11ULL, 0x040fe2000f8fd8ffULL,
0x00008a00ff167b82ULL, 0x000e620000000a00ULL, 0x000000105a1b7824ULL, 0x000fe200078e00ffULL,
0x00014000080c7890ULL, 0x000fe4000fffe03fULL, 0x0000000819187c11ULL, 0x040fe2000f8e10ffULL,
0x0000001119157c36ULL, 0x000fe40008000000ULL, 0x00000001191c7824ULL, 0x000fe200078e025aULL,
0x000001f01b1b7812ULL, 0x000fe200078ec0ffULL, 0x01ca000018147984ULL, 0x000ea20000000800ULL,
0x00000020191d7824ULL, 0x000fc400078e00ffULL, 0x0000000119217836ULL, 0x000fc60000000000ULL,
0xffffffe01d1c7812ULL, 0x000fe200078ee21cULL, 0x00000011211d7c36ULL, 0x000fc60008000000ULL,
0x0000000c1c1f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x040fe400078e025aULL,
0x0000002021217824ULL, 0x000fca00078e00ffULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000219217836ULL, 0x000fe20000000000ULL, 0x00000008141a7c11ULL, 0x004fca000f8e10ffULL,
0x01cac0001a147984ULL, 0x000ea40000000800ULL, 0x0000000a14157c24ULL, 0x004fc8000f8e0215ULL,
0x0000020015147825ULL, 0x002fc600078e0016ULL, 0x0000001b14147210ULL, 0x000fc80007f7e0ffULL,
0x00000015ff157210ULL, 0x000fca0001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0400181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fe200078e0016ULL,
0x00000011211d7c10ULL, 0x000fc6000fffe0ffULL, 0x0000002021217824ULL, 0x000fe200078e00ffULL,
0x0000001b14147210ULL, 0x000fc80007f7e0ffULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x000000ffff157224ULL, 0x000fe400018e0615ULL, 0x0000000319217836ULL, 0x000fc60000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca0800181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe40007f7e0ffULL, 0x0000000521217819ULL, 0x000fc600000006ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000419217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca0c00181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL, 0x00000001211c7824ULL, 0x000fe200078e025aULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0xffffffe0211c7812ULL, 0x000fe400078ee21cULL, 0x0000000519217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e8000b901c52ULL,
0x01ca1000181a7984ULL, 0x000ea20000000800ULL, 0x0000000c1c1f7c11ULL, 0x002fe2000f8e20ffULL,
0x00000001211c7824ULL, 0x000fe200078e025aULL, 0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000e640000000800ULL, 0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000002001d147825ULL, 0x000fc800078e0016ULL, 0x00000011211d7c36ULL, 0x000fe20008000000ULL,
0x0000001b14147210ULL, 0x000fe20007f7e0ffULL, 0x0000002021217824ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0xffffffe0211c7812ULL, 0x000fe200078ee21cULL,
0x0000000619217836ULL, 0x000fc60000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1400181a7984ULL, 0x000ea20000000800ULL,
0x0000000c1c1f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000005a211c7210ULL, 0x000fe40007ffe0ffULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fc800078e0016ULL,
0x00000011211d7c36ULL, 0x000fe20008000000ULL, 0x0000001b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000002021217824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0xffffffe0211c7812ULL, 0x000fc800078ee21cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e8000b901c52ULL, 0x01ca1800181a7984ULL, 0x000ea20000000800ULL,
0x00000007191f7836ULL, 0x002fc80000000000ULL, 0x000000111f197c36ULL, 0x000fe20008000000ULL,
0x000000081a1a7c11ULL, 0x004fcc000f8e10ffULL, 0x01cac0001a1a7984ULL, 0x000e640000000800ULL,
0x0000000a1a1d7c24ULL, 0x002fc8000f8e021dULL, 0x000002001d147825ULL, 0x000fe200078e0016ULL,
0x0000000c1c1d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000201f1c7824ULL, 0x000fe200078e00ffULL,
0x0000001b14147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e8000b901c52ULL,
0x01ca1c0018187984ULL, 0x000ea40000000800ULL, 0x00000008181a7c11ULL, 0x004fcc000f8e10ffULL,
0x01cac0001a1a7984ULL, 0x000ea40000000800ULL, 0x0000000a1a197c24ULL, 0x004fc8000f8e0219ULL,
0x0000020019167825ULL, 0x000fc800078e0016ULL, 0x000000011f197824ULL, 0x000fe200078e025aULL,
0x0000001b16147210ULL, 0x002fc80007f7e0ffULL, 0xffffffe01c197812ULL, 0x000fe400078ee219ULL,
0x00000017ff157210ULL, 0x000fe40001ffe4ffULL, 0x0000000c19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c52ULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x01cb8814ff1479a7ULL, 0x000e640008500008ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000147805ULL, 0x000fc60000015200ULL,
0x01cb8818ff0075a7ULL, 0x000e640008060148ULL, 0x00000000005c3947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f66270ULL,
0x000000000044b947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f7e1ffULL, 0x0000000117177824ULL, 0x000fe200018e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f66070ULL, 0x000000ff1700720cULL, 0x000fda0003f66330ULL,
0x000000000008b947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f66070ULL,
0x000000ff1700720cULL, 0x000fda0003f66330ULL, 0x00000000001cb947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078710ffULL,
0x000000ffff177224ULL, 0x000fca00018e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01cb8818ff0075a7ULL, 0x000e640008060148ULL,
0xfffffffc00a8b947ULL, 0x002fea000383ffffULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x00000001004b7802ULL, 0x000fc60000000f00ULL, 0x00000000005c2947ULL, 0x000fea0003800000ULL,
0x000000100700728cULL, 0x000fe2000bf04070ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x0000000867197c11ULL, 0x000fe4000f8e10ffULL, 0x0000003f0e0c7287ULL, 0x000fc80008000000ULL,
0x0000000c0f0c7290ULL, 0x000fc8000fffe03fULL, 0x000000023f0d7899ULL, 0x000fe4000801160cULL,
0x000000060c0c7899ULL, 0x000fe4000800063fULL, 0x000000160d0d72a4ULL, 0x000fe4000f8e0210ULL,
0x000000c00c0c7892ULL, 0x000fc8000f8ec03fULL, 0x0000000c0d0c7291ULL, 0x000fe4000f8e403fULL,
0x0000003f0e0d7287ULL, 0x000fe4000c000000ULL, 0x000000200c117890ULL, 0x000fe4000fffe03fULL,
0x0000000d1b0c7290ULL, 0x000fc6000fffe03fULL, 0x00009400000d7ab9ULL, 0x000fe20000000800ULL,
0x0000001167167c36ULL, 0x000fe20008000000ULL, 0x0000000d0c0c72a4ULL, 0x000fc8000f8e0211ULL,
0x0000001a16007c0cULL, 0x000fe4000bf66070ULL, 0x0000000c67177c36ULL, 0x000fc80008000000ULL,
0x0000000417147825ULL, 0x002fce00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1ca0000014197faeULL, 0x0003e4000d921852ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a5dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x01cb784bff5c79a7ULL, 0x0002a20008500008ULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x0000005eff00723eULL, 0x000fc800000000ffULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f7814027589ULL, 0x00066800000e0000ULL,
0x00001f7714007589ULL, 0x0006a400000e0000ULL, 0x013800006b1c783bULL, 0x0006a20000000200ULL,
0x0000000000104947ULL, 0x000fea0003800000ULL, 0x000000021c1c7232ULL, 0x086fe40000000000ULL,
0x000000021e1e7232ULL, 0x000fe40000000000ULL, 0x000000001d1d7232ULL, 0x080fe40000000000ULL,
0x000000001f1f7232ULL, 0x000fce0000000000ULL, 0x000000006a34783bULL, 0x000f280000004200ULL,
0x00000000692c783bULL, 0x000f680000004200ULL, 0x000000006824783bULL, 0x000f680000004200ULL,
0x000000006614783bULL, 0x008ee80000004200ULL, 0x013800004c18783bULL, 0x0006e20000000200ULL,
0x000000341c44723cULL, 0x014fec00000018ffULL, 0x0000002c1c30723cULL, 0x020fec00000018ffULL,
0x000000241c28723cULL, 0x000fec00000018ffULL, 0x000000361c34723cULL, 0x000fec00000018ffULL,
0x0000002e1c2c723cULL, 0x000fec00000018ffULL, 0x000000261c24723cULL, 0x000fec00000018ffULL,
0x000000141c20723cULL, 0x008fec00000018ffULL, 0x000000161c1c723cULL, 0x000fe200000018ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000104947ULL, 0x002fde0003800000ULL,
0x0000000218187232ULL, 0x080fe40000000000ULL, 0x000000021a1a7232ULL, 0x000fe40000000000ULL,
0x0000000019197232ULL, 0x080fe40000000000ULL, 0x000000001b1b7232ULL, 0x000fce0000000000ULL,
0x000000006214783bULL, 0x000e620000004200ULL, 0x000001e000007945ULL, 0x000fe60003800000ULL,
0x000000006138783bULL, 0x000ea80000004200ULL, 0x00000000603c783bULL, 0x000ee80000004200ULL,
0x000000005f40783bULL, 0x000f220000004200ULL, 0x000000141844723cULL, 0x002fec0000001844ULL,
0x000000161834723cULL, 0x000fec0000001834ULL, 0x000000381830723cULL, 0x004fec0000001830ULL,
0x0000003a182c723cULL, 0x000fec000000182cULL, 0x0000003c1828723cULL, 0x008fec0000001828ULL,
0x0000003e1824723cULL, 0x000fec0000001824ULL, 0x000000401820723cULL, 0x010fec0000001820ULL,
0x00000042181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000400947ULL, 0x000fde0002800000ULL, 0x0000004403037221ULL, 0x000fe20000010000ULL,
0x0000004504047221ULL, 0x000fe20000010000ULL, 0x0000003407077221ULL, 0x000fe20000010000ULL,
0x0000003508087221ULL, 0x000fe20000010000ULL, 0x000000300b0b7221ULL, 0x000fe20000010000ULL,
0x000000310c0c7221ULL, 0x000fe20000010000ULL, 0x0000002c0f0f7221ULL, 0x000fe20000010000ULL,
0x0000002d12127221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244f4f7221ULL, 0x000fe20000010000ULL,
0x0000002550507221ULL, 0x000fe20000010000ULL, 0x0000002053537221ULL, 0x000fe20000010000ULL,
0x0000002154547221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5c7224ULL, 0x000fc600078e005dULL,
0x0000000000401947ULL, 0x000fea0003000000ULL, 0x0000004605057221ULL, 0x000fe20000010000ULL,
0x0000004706067221ULL, 0x000fe20000010000ULL, 0x0000003609097221ULL, 0x000fe20000010000ULL,
0x000000370a0a7221ULL, 0x000fe20000010000ULL, 0x000000320d0d7221ULL, 0x000fe20000010000ULL,
0x000000330e0e7221ULL, 0x000fe20000010000ULL, 0x0000002e13137221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4d4d7221ULL, 0x000fe20000010000ULL,
0x0000002b4e4e7221ULL, 0x000fe20000010000ULL, 0x0000002651517221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f10107221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x01cb884bff1479a7ULL, 0x000e660008500008ULL,
0x0000000b0400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000ffff187224ULL, 0x002fd800078e0015ULL, 0xffffffb400148947ULL, 0x000fea000383ffffULL,
0x01cb704bffff79a7ULL, 0x0003e40008500008ULL, 0x0000001916197290ULL, 0x000fc8000fffe03fULL,
0x000000051900728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0xfffffec800688947ULL, 0x000fea000383ffffULL, 0x00000000000f79c3ULL, 0x000ea20000002500ULL,
0x000000ffff197224ULL, 0x000fe200078e000fULL, 0x0000001200187202ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0x00000009000e7202ULL, 0x000fe20000000f00ULL,
0x000000ffff0f7224ULL, 0x000fe400078e000aULL, 0x000000ffff167224ULL, 0x000fe400078e000dULL,
0x000000ffff147224ULL, 0x000fe400078e000cULL, 0x000000ffff157224ULL, 0x000fc400078e000bULL,
0x000000ffff0a7224ULL, 0x000fe400078e0008ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0010ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0013ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0007ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0005ULL,
0x000000050f00728cULL, 0x004fe2000bf06070ULL, 0x000000ffff087224ULL, 0x000fc400078e0004ULL,
0x000000ffff097224ULL, 0x000fc600078e0003ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x018000005b007810ULL, 0x000fc80007ffe0ffULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e005bULL,
0x000160e000027802ULL, 0x000fce0000000f00ULL, 0x000000fc00d87944ULL, 0x002fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000005b00007308ULL, 0x000ea40000001000ULL,
0xbf80000000027423ULL, 0x004fc8000000005bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x00000002ff057819ULL, 0x010fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0500027589ULL, 0x000ea800000e0000ULL,
0x00001f0300037589ULL, 0x000ee200000e0000ULL, 0x0000000902097220ULL, 0x044fe20000410000ULL,
0x0000000802087220ULL, 0x040fe20000410000ULL, 0x0000000b020b7220ULL, 0x040fe20000410000ULL,
0x0000000a020a7220ULL, 0x040fe20000410000ULL, 0x0000001502157220ULL, 0x040fe20000410000ULL,
0x0000001402147220ULL, 0x040fe20000410000ULL, 0x0000001902197220ULL, 0x040fe20000410000ULL,
0x0000001802187220ULL, 0x040fe20000410000ULL, 0x0000004902497220ULL, 0x040fe20000410000ULL,
0x0000004a024a7220ULL, 0x040fe20000410000ULL, 0x0000004f024f7220ULL, 0x040fe20000410000ULL,
0x0000005002507220ULL, 0x040fe20000410000ULL, 0x0000005302537220ULL, 0x040fe20000410000ULL,
0x0000005402547220ULL, 0x040fe20000410000ULL, 0x0000005702577220ULL, 0x040fe20000410000ULL,
0x0000005802587220ULL, 0x000fe20000410000ULL, 0x0000000c030c7220ULL, 0x048fe20000410000ULL,
0x0000000d030d7220ULL, 0x040fe20000410000ULL, 0x0000000e030e7220ULL, 0x040fe20000410000ULL,
0x0000000f030f7220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000004803487220ULL, 0x040fe20000410000ULL, 0x0000004d034d7220ULL, 0x040fe20000410000ULL,
0x0000004e034e7220ULL, 0x040fe20000410000ULL, 0x0000005103517220ULL, 0x040fe20000410000ULL,
0x0000005203527220ULL, 0x040fe20000410000ULL, 0x0000005503557220ULL, 0x040fe20000410000ULL,
0x0000005603567220ULL, 0x040fe20000410000ULL, 0x0000005903597220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000815087291ULL, 0x000fe2000f8e583fULL, 0x0000000c0d0c723eULL, 0x000fe200000000ffULL,
0x000000011600788cULL, 0x000fe2000bf05270ULL, 0x0000000e0f0d723eULL, 0x000fe200000000ffULL,
0x0001200008117890ULL, 0x000fe2000fffe03fULL, 0x00000016170e723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000781cULL, 0x000fc40003f0f008ULL,
0x0000001a480f723eULL, 0x000fe400000000ffULL, 0x000000555616723eULL, 0x000fe400000000ffULL,
0x000000591c17723eULL, 0x000fe400000000ffULL, 0x00000003ff037819ULL, 0x004fe40000011600ULL,
0xfffffff8ff057812ULL, 0x000fe400078ee200ULL, 0x0000000303027812ULL, 0x000fc600078ec0ffULL,
0x0000000805077836ULL, 0x000fe40000000000ULL, 0x0000000805107824ULL, 0x040fe400078e00ffULL,
0x0000000805137824ULL, 0x000fe200078e00ffULL, 0x00000003071b7819ULL, 0x040fe200000006ffULL,
0x0000000102057824ULL, 0x040fe400078e0205ULL, 0x0000000102067824ULL, 0x000fe400078e0207ULL,
0x0000000405047836ULL, 0x000fe20000000000ULL, 0xfffffff810027812ULL, 0x000fe200078ee205ULL,
0x00000008071e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b127812ULL, 0x000fe200078ee206ULL,
0x0000000c05077836ULL, 0x000fe20000000000ULL, 0xfffffff813107812ULL, 0x000fc400078ee204ULL,
0x000000090804723eULL, 0x000fe400000000ffULL, 0xfffffff81e137812ULL, 0x000fe400078ee207ULL,
0x0000000b0a05723eULL, 0x000fe400000000ffULL, 0x000000151406723eULL, 0x000fe400000000ffULL,
0x000000191807723eULL, 0x000fe400000000ffULL, 0x0000001102027c11ULL, 0x000fc4000f8e20ffULL,
0x000000494a08723eULL, 0x000fe400000000ffULL, 0x0000004f5009723eULL, 0x000fe200000000ffULL,
0x0000000402007844ULL, 0x0005e20000000200ULL, 0x00000053540a723eULL, 0x000fe400000000ffULL,
0x00000057580b723eULL, 0x000fe400000000ffULL, 0x0000001110107c11ULL, 0x000fe4000f8e20ffULL,
0x0000001112127c11ULL, 0x000fc4000f8e20ffULL, 0x0000004d4e14723eULL, 0x000fe200000000ffULL,
0x0000000810007844ULL, 0x0005e20000000200ULL, 0x000000515215723eULL, 0x000fe400000000ffULL,
0x0000001113137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c12007844ULL, 0x0005e80000000200ULL,
0x0000001413007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002400488947ULL, 0x000fea0003800000ULL, 0x00000000000979c3ULL, 0x000ee20000002600ULL,
0x0000980000047ab9ULL, 0x000fe20000000800ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x00000015ff007c0cULL, 0x000fe2000bf05270ULL, 0x00000004050472a4ULL, 0x000fe2000f8e023fULL,
0x0000000800027c11ULL, 0x004fe2000f8e20ffULL, 0x00009c00000c7ab9ULL, 0x000fe40000000a00ULL,
0x0000000f04067891ULL, 0x000fe4000f8e103fULL, 0x00000016040472a4ULL, 0x000fc4000f8e023fULL,
0xfffffff006067892ULL, 0x000fc8000f8ec03fULL, 0x0000000c06147290ULL, 0x000fe4000ff1e03fULL,
0x0000000604197291ULL, 0x000fe4000f8e383fULL, 0x0000000d3f1c7290ULL, 0x000fe400087fe43fULL,
0x00000005170972a4ULL, 0x008fc8000f8e0209ULL, 0x00000016091072a4ULL, 0x000fc8000f8e023fULL,
0x0000000f100a7290ULL, 0x000fe2000fffe03fULL, 0x0000000000480947ULL, 0x000ff60003800000ULL,
0x000000070a057899ULL, 0x000fe2000800063fULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x000000193f077899ULL, 0x000fe2000801160aULL, 0x00000001ff057819ULL, 0x000fc60000011600ULL,
0x00000005ff077e24ULL, 0x000fe2000f8e00ffULL, 0x0000007004067812ULL, 0x000fe200078ec0ffULL,
0x0000000c05057290ULL, 0x000fe2000f91e019ULL, 0x0000000c05057812ULL, 0x000fe400078ec0ffULL,
0x0000001406047c10ULL, 0x000fe2000fa3e007ULL, 0x00000007ff077e24ULL, 0x000fe2000f8e00ffULL,
0x0000000d07077290ULL, 0x000fe200087e243fULL, 0x0000000505067c10ULL, 0x000fe4000fd9e006ULL,
0x0000000405047210ULL, 0x000fc40007f7e0ffULL, 0x0000001cff057c10ULL, 0x000fe40008fe4407ULL,
0x00000007ff077c10ULL, 0x000fe4000a7ea4ffULL, 0x00000005ff057210ULL, 0x000fca0001ffe4ffULL,
0x0000001104007986ULL, 0x0005e8000c101912ULL, 0x0000005b06007986ULL, 0x0005e4000c101912ULL,
0x0000001904047291ULL, 0x000fe2000f8e383fULL, 0x0120000002087984ULL, 0x000ee20000000c00ULL,
0x000000ff0000720cULL, 0x000fe20000705670ULL, 0x000002d000007945ULL, 0x000fe20003800000ULL,
0x0000007f04047890ULL, 0x000fc8000fffe03fULL, 0xffffff8004077892ULL, 0x000fc8000f8ec03fULL,
0x0000000c07047290ULL, 0x000fc8000ff1e03fULL, 0x0000000d3f057290ULL, 0x000fe400087fe43fULL,
0x000000040a047291ULL, 0x000fc8000f80583fULL, 0x000000050a057291ULL, 0x000fc800080f5c3fULL,
0x00000200150478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff047e24ULL, 0x004fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe4000f8e00ffULL, 0x0000001000047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0085e2000c101d12ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000007c0947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00009c0000047ab9ULL, 0x000fe20000000a00ULL, 0xffffffff160a7890ULL, 0x000fe4000fffe03fULL,
0x00000004090478a5ULL, 0x000fc8000f8e0004ULL, 0x0000000aff077e24ULL, 0x000fe4000f8e00ffULL,
0x00000004ff047e24ULL, 0x004fe4000f8e00ffULL, 0x00000005ff057e24ULL, 0x000fca000f8e00ffULL,
0x00000007040479a8ULL, 0x00052200099ee1d2ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x0000000a04007c0cULL, 0x010fc8000bf05270ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x008fd20008000004ULL, 0x00000002ff007988ULL, 0x0007e60008000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000f220000008800ULL,
0x0000040000097882ULL, 0x000fce0000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000065404097896ULL, 0x010fd20008000009ULL, 0x00000009ff027984ULL, 0x008ee40008000000ULL,
0x000000ff0200720cULL, 0x008fda0003f05270ULL, 0x0000001c00dc8947ULL, 0x000fea0003800000ULL,
0x00000015ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800f00947ULL, 0x000fea0003800000ULL,
0x00000016ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000848947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe20000011600ULL,
0x0000001410047291ULL, 0x000fc6000f80383fULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x0000001c10057291ULL, 0x000fe200080f3c3fULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000403027c10ULL, 0x000fc8000f91e002ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000001202047981ULL, 0x004528000c1e1900ULL, 0x0000801202057981ULL, 0x000522000c1e1900ULL,
0x000000021600788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000508947ULL, 0x004fea0003800000ULL, 0x0001001202077981ULL, 0x000522000c1e1900ULL,
0x000000041600788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000408947ULL, 0x004fea0003800000ULL, 0x0001801202097981ULL, 0x000522000c1e1900ULL,
0x000000041600788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000308947ULL, 0x004fea0003800000ULL, 0x00020012020b7981ULL, 0x000522000c1e1900ULL,
0x000000061600788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000208947ULL, 0x004fea0003800000ULL, 0x00028012020d7981ULL, 0x000522000c1e1900ULL,
0x000000061600788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000108947ULL, 0x004fea0003800000ULL, 0x000000081600788cULL, 0x000fe2000bf06070ULL,
0x00030012020f7981ULL, 0x00052a000c1e1900ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0003801202110981ULL, 0x000524000c1e1900ULL, 0x0000000716047890ULL, 0x000fc8000fffe03fULL,
0x000000033f0a7899ULL, 0x000fcc0008011604ULL, 0x0000000aff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800388947ULL, 0x000fea0003800000ULL, 0x00000006100b7291ULL, 0x000fe2000f80383fULL,
0x0000000400137202ULL, 0x010fe20000000f00ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x0000000c0b0b7290ULL, 0x000fe4000ff3e03fULL,
0x0000003f100e7291ULL, 0x000fe400080f3c3fULL, 0x000007800b0b7890ULL, 0x000fc8000ff1e03fULL,
0x0000000e3f0e7290ULL, 0x000fd800087e240dULL, 0x000000160400728cULL, 0x000fe4000bf06070ULL,
0x0000000105057890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000a0500728cULL, 0x000fd8000bf06070ULL, 0x0000000400f00947ULL, 0x014fea0003800000ULL,
0x00000008041a7890ULL, 0x000fe2000fffe03fULL, 0x0000001304047209ULL, 0x004fc60007810000ULL,
0x000000161a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL,
0x0000000eff037e24ULL, 0x000fca00080e06ffULL, 0xfffc801202137981ULL, 0x000526000c1e1900ULL,
0x00000001041a7890ULL, 0x000fc8000fffe03fULL, 0x000000161a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000400b00947ULL, 0x000fea0003800000ULL,
0x00000009041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000504047209ULL, 0x000fc60007810000ULL,
0x000000161a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL,
0x0000000eff037e24ULL, 0x000fca00080e06ffULL, 0xfffd001202057981ULL, 0x000526000c1e1900ULL,
0x00000002041a7890ULL, 0x000fc8000fffe03fULL, 0x000000161a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000400700947ULL, 0x000fea0003800000ULL,
0x0000000a041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000704047209ULL, 0x000fc60007810000ULL,
0x000000161a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL,
0x0000000eff037e24ULL, 0x000fca00080e06ffULL, 0xfffd801202077981ULL, 0x000526000c1e1900ULL,
0x00000003041a7890ULL, 0x000fc8000fffe03fULL, 0x000000161a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000400300947ULL, 0x000fea0003800000ULL,
0x0000000b041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000904047209ULL, 0x000fc60007810000ULL,
0x000000161a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000000400027819ULL, 0x004fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL,
0x0000000eff037e24ULL, 0x000fca00080e06ffULL, 0xfffe001202097981ULL, 0x000526000c1e1900ULL,
0x00000004041a7890ULL, 0x000fc8000fffe03fULL, 0x000000161a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000f00947ULL, 0x000fea0003800000ULL,
0x0000000c041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000b04047209ULL, 0x000fc60007810000ULL,
0x000000161a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL,
0x0000000eff037e24ULL, 0x000fca00080e06ffULL, 0xfffe8012020b7981ULL, 0x000526000c1e1900ULL,
0x00000005041a7890ULL, 0x000fc8000fffe03fULL, 0x000000161a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000b00947ULL, 0x000fea0003800000ULL,
0x0000000d041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000d04047209ULL, 0x000fc60007810000ULL,
0x000000161a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL,
0x0000000eff037e24ULL, 0x000fca00080e06ffULL, 0xffff0012020d7981ULL, 0x000526000c1e1900ULL,
0x00000006041a7890ULL, 0x000fc8000fffe03fULL, 0x000000161a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000700947ULL, 0x000fea0003800000ULL,
0x0000000e041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000f04047209ULL, 0x000fc60007810000ULL,
0x000000161a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000b02027c10ULL, 0x000fc8000ff1e0ffULL,
0x0000000eff037c10ULL, 0x000fca00087fe4ffULL, 0xffff8012020f7981ULL, 0x000528000c1e1900ULL,
0x00000007041a7890ULL, 0x000fc8000fffe03fULL, 0x000000161a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000300947ULL, 0x000fea0003800000ULL,
0x0000000f041a7890ULL, 0x000fe2000fffe03fULL, 0x0000001104047209ULL, 0x000fc60007810000ULL,
0x000000161a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL,
0x0000000eff037e24ULL, 0x000fca00080e06ffULL, 0x0000001202117981ULL, 0x000526000c1e1900ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000004000b0b7890ULL, 0x000fe4000ff3e03fULL,
0x0000000804047890ULL, 0x000fe4000fffe03fULL, 0x0000000e3f0e7290ULL, 0x000fd00008ffe43fULL,
0xfffffff400e88947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x0000001000027824ULL, 0x00cfe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000903037c10ULL, 0x000fca000fffe002ULL, 0x0000000403007388ULL, 0x0105e40000000800ULL,
0x00009c0000047ab9ULL, 0x000fe20000000a00ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x00000004071a7290ULL, 0x000fe2000ff3e03fULL, 0x00000010ff097e24ULL, 0x004fe2000f8e00ffULL,
0x0000000419237290ULL, 0x000fe2000ff1e03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000004060b7290ULL, 0x000fe2000ff5e03fULL, 0x00000001ff037819ULL, 0x000fe20000011600ULL,
0x000000053f1b7290ULL, 0x000fe20008ffe43fULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x000000053f247290ULL, 0x000fe200087fe43fULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x000000053f0e7290ULL, 0x000fe200097fe43fULL, 0x0000000c03037812ULL, 0x000fe200078ec0ffULL,
0x0000000915207899ULL, 0x000fe2000800063fULL, 0x0000002309068c11ULL, 0x040fe2000f8238ffULL,
0x00000800100478a5ULL, 0x000fe2000f8e001aULL, 0x0000000b09088c11ULL, 0x040fe2000f8438ffULL,
0x000000173f217899ULL, 0x000fe20008011615ULL, 0x0000002409078c11ULL, 0x040fe200088f3cffULL,
0x00000020041e7290ULL, 0x000fe2000ff1e03fULL, 0x00000016ff007c0cULL, 0x000fe2000bf25270ULL,
0x00000000003f7886ULL, 0x000fe20000020000ULL, 0x0000000e09098c11ULL, 0x000fe200090f3cffULL,
0x0000002105047290ULL, 0x000fe200087fe43fULL, 0x0000000903147c10ULL, 0x000fe2000fffe002ULL,
0x00000009151d7291ULL, 0x000fe2000f8e603fULL, 0x0000001eff047e24ULL, 0x000fe2000f8e00ffULL,
0x00000009150a9291ULL, 0x000fe2000f8e403fULL, 0x0000001000068825ULL, 0x040fe200078e0006ULL,
0x0000000400057c02ULL, 0x000fe20008000f00ULL, 0x0000000915059291ULL, 0x000fe2000f8e403fULL,
0x0000001d000b7c11ULL, 0x040fe2000f8e20ffULL, 0x0000001000088825ULL, 0x040fe200078e0008ULL,
0x0000000a000d8c11ULL, 0x040fe2000f8e20ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001000047825ULL, 0x040fe200078e0004ULL, 0x00000005000f8c11ULL, 0x000fe2000f8e20ffULL,
0x0000000014147984ULL, 0x000ea20000000800ULL, 0x0000000000167805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040b7faeULL, 0x0007e2000b901c52ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x04580000060d8faeULL, 0x0007e2000b901c52ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x04180000080f8faeULL, 0x0007e2000b901c52ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x002fe2000001ff00ULL,
0x0000000800749947ULL, 0x000fec0003800000ULL, 0x00000003ff047819ULL, 0x108fe20000011600ULL,
0x0000000915047291ULL, 0x000fe2000f8e403fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee200ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x00000001101e7890ULL, 0x000fe2000fffe03fULL, 0x00000002ff387819ULL, 0x000fe20000011600ULL,
0x0000000805077836ULL, 0x000fe20000000000ULL, 0x0000000305067819ULL, 0x040fe200000006ffULL,
0x0000000805377824ULL, 0x000fe200078e00ffULL, 0x00000001001f7882ULL, 0x000fe20000000000ULL,
0x0000000104367824ULL, 0x000fc400078e0207ULL, 0x0000000104047824ULL, 0x000fe400078e0205ULL,
0x0000000807097824ULL, 0x040fe400078e00ffULL, 0x0000000404397836ULL, 0x000fe20000000000ULL,
0xfffffff837377812ULL, 0x000fe200078ee204ULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0xfffffff809367812ULL, 0x000fe200078ee236ULL, 0x0000000c04047836ULL, 0x000fe20000000000ULL,
0xfffffff806397812ULL, 0x000fe200078ee239ULL, 0x00000004ff4f7e24ULL, 0x000fc4000f8e00ffULL,
0x0000000838517836ULL, 0x000fe20000000000ULL, 0xfffffff8074e7812ULL, 0x000fce00078ee204ULL,
0x000000161f00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x00000000008c0947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f44070ULL,
0x000008001e0478a5ULL, 0x000fe4000f8e001aULL, 0x0000001e00047c02ULL, 0x000fe20008000f00ULL,
0x000000011f257892ULL, 0x000fe4000f8ec03fULL, 0x0000002004227290ULL, 0x000fe4000ff1e03fULL,
0x0000000b1f0a7899ULL, 0x000fe4000800063fULL, 0x0000002105047290ULL, 0x000fe200087fe43fULL,
0x00000025ff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x000008000a0a7892ULL, 0x000fe2000f8ec03fULL,
0x00000000003f7886ULL, 0x000fe20001020000ULL, 0x000000230406ac11ULL, 0x000fc4000f8038ffULL,
0x0000000a1d0a7290ULL, 0x000fe2000fffe03fULL, 0x0000000b0408ac11ULL, 0x040fe2000f8238ffULL,
0x00000004ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000915059291ULL, 0x000fe2000f8e403fULL,
0x000000240407ac11ULL, 0x040fe200080f3cffULL, 0x0000000915259291ULL, 0x000fe2000f8e403fULL,
0x0000000e0409ac11ULL, 0x000fe200088f3cffULL, 0x00000022ff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a000b7c11ULL, 0x040fe2000f8e20ffULL, 0x00000005ff4fae24ULL, 0x000fe4000f8e00ffULL,
0x0000001000047825ULL, 0x000fc800078e0004ULL, 0x000000800a0da824ULL, 0x000fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040b7faeULL, 0x0003e2000b901c52ULL,
0x00000025ff4fae24ULL, 0x000fe4000f8e00ffULL, 0x000000100006a825ULL, 0x000fc600078e0006ULL,
0x0000004f0a0fa211ULL, 0x000fe200078e38ffULL, 0x00000010000da824ULL, 0x040fe400078e020dULL,
0x000000100008a825ULL, 0x000fc600078e0008ULL, 0x04580000060dafaeULL, 0x0003e2000b901c52ULL,
0x00000010000fa824ULL, 0x000fca00078e020fULL, 0x04180000080fafaeULL, 0x0003e4000b901c52ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff1f047890ULL, 0x000fe4000fffe03fULL,
0x000000161f00728cULL, 0x000fe4000bf06070ULL, 0x0000000704057899ULL, 0x000fe4000800063fULL,
0x0000000b04047899ULL, 0x000fe4000800063fULL, 0x0000008005057892ULL, 0x000fe2000f8ec03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000080004047892ULL, 0x000fc4000f8ec03fULL,
0x000000011e1e7890ULL, 0x000fe4000fffe03fULL, 0x0000000502047c10ULL, 0x002fe2000fffe04fULL,
0x000001801d047890ULL, 0x000fe4000fffe004ULL, 0x000000011f1f7890ULL, 0x000fe4000fffe03fULL,
0x00000001033a7824ULL, 0x000fe400078e0204ULL, 0x0000000437047c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003a0d7984ULL, 0x000e620000000800ULL,
0x0000000439087c11ULL, 0x000fe4000f8e20ffULL, 0x00000004360c7c11ULL, 0x000fe2000f8e20ffULL,
0x004580003a3b7984ULL, 0x000fe20000000800ULL, 0x000000044e107c11ULL, 0x000fc6000f8e20ffULL,
0x000000000404783bULL, 0x000ee80000000200ULL, 0x000000000808783bULL, 0x000f220000000200ULL,
0x0000000d14117221ULL, 0x006fc60000010100ULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x3fb8aa3b113e7820ULL, 0x000fc60000410000ULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x20000005ff3d7230ULL, 0x008fe40000004100ULL, 0x0000003e003e7308ULL, 0x000ee20000000800ULL,
0x30000005ff3a7230ULL, 0x000fe40000004100ULL, 0x20000007ff3f7230ULL, 0x000fe40000004100ULL,
0x30000007ff3c7230ULL, 0x000fe40000004100ULL, 0x20000009ff417230ULL, 0x010fc40000004100ULL,
0x2000000bff437230ULL, 0x000fe40000004100ULL, 0x3000000bff407230ULL, 0x000fe40000004100ULL,
0x20000006ff057230ULL, 0x000fe40000004100ULL, 0x0000003b3e4a7220ULL, 0x008fe20000410000ULL,
0x30000009ff3e7230ULL, 0x000fe40000004100ULL, 0x20000004ff3b7230ULL, 0x000fe40000004100ULL,
0x000000354a357221ULL, 0x000fe20000010000ULL, 0x00001f384a4c7589ULL, 0x000ee200000e0000ULL,
0x20000008ff077230ULL, 0x000fc40000004100ULL, 0x2000000aff097230ULL, 0x000fe20000004100ULL,
0x00001f514a4d7589ULL, 0x000f2200000e0000ULL, 0x30000004ff047230ULL, 0x000fe40000004100ULL,
0x30000006ff067230ULL, 0x000fe40000004100ULL, 0x30000008ff087230ULL, 0x000fe40000004100ULL,
0x3000000aff0a7230ULL, 0x000fe40000004100ULL, 0x2000000dff457230ULL, 0x002fc40000004100ULL,
0x3000000dff427230ULL, 0x000fe40000004100ULL, 0x2000000fff477230ULL, 0x000fe40000004100ULL,
0x3000000fff447230ULL, 0x000fe40000004100ULL, 0x20000011ff497230ULL, 0x004fe40000004100ULL,
0x30000011ff467230ULL, 0x000fe40000004100ULL, 0x0000004c3b347223ULL, 0x008fe20000010034ULL,
0x2000000cff0b7230ULL, 0x000fc40000004100ULL, 0x0000004c04337223ULL, 0x080fe20000010033ULL,
0x2000000eff0d7230ULL, 0x000fe40000004100ULL, 0x0000004c3d327223ULL, 0x080fe20000010032ULL,
0x20000010ff0f7230ULL, 0x000fe40000004100ULL, 0x0000004c3a317223ULL, 0x080fe20000010031ULL,
0x20000012ff117230ULL, 0x000fe40000004100ULL, 0x0000004c05307223ULL, 0x000fe20000010030ULL,
0x3000000cff0c7230ULL, 0x000fc40000004100ULL, 0x0000004c062f7223ULL, 0x080fe2000001002fULL,
0x3000000eff0e7230ULL, 0x000fe40000004100ULL, 0x0000004c3f2e7223ULL, 0x080fe2000001002eULL,
0x30000010ff107230ULL, 0x000fe40000004100ULL, 0x0000004c3c2d7223ULL, 0x080fe2000001002dULL,
0x30000012ff127230ULL, 0x000fe40000004100ULL, 0x0000004c072c7223ULL, 0x000fe2000001002cULL,
0x20000013ff4b7230ULL, 0x000fc40000004100ULL, 0x0000004c082b7223ULL, 0x080fe2000001002bULL,
0x30000013ff487230ULL, 0x000fe40000004100ULL, 0x0000004c412a7223ULL, 0x080fe2000001002aULL,
0x0000004c3e297223ULL, 0x080fe20000010029ULL, 0x0000004c09287223ULL, 0x080fe20000010028ULL,
0x0000004c0a277223ULL, 0x080fe20000010027ULL, 0x0000004c43267223ULL, 0x080fe20000010026ULL,
0x0000004c40257223ULL, 0x000fe20000010025ULL, 0x0000004d0b247223ULL, 0x090fe20000010024ULL,
0x0000004d0c237223ULL, 0x080fe20000010023ULL, 0x0000004d45227223ULL, 0x080fe20000010022ULL,
0x0000004d42217223ULL, 0x080fe20000010021ULL, 0x0000004d0d207223ULL, 0x080fe20000010020ULL,
0x0000004d0e1f7223ULL, 0x080fe2000001001fULL, 0x0000004d471e7223ULL, 0x080fe2000001001eULL,
0x0000004d441d7223ULL, 0x080fe2000001001dULL, 0x0000004d0f1c7223ULL, 0x080fe2000001001cULL,
0x0000004d101b7223ULL, 0x080fe2000001001bULL, 0x0000004d491a7223ULL, 0x080fe2000001001aULL,
0x0000004d46197223ULL, 0x080fe20000010019ULL, 0x0000004d11187223ULL, 0x080fe20000010018ULL,
0x0000004d12177223ULL, 0x080fe20000010017ULL, 0x0000004d4b167223ULL, 0x080fe20000010016ULL,
0x0000004d48157223ULL, 0x000fe20000010015ULL, 0xfffffff400e88947ULL, 0x000fec000383ffffULL,
0x0180000035007836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0001865000027802ULL, 0x000fce0000000f00ULL,
0x000000d8007c7944ULL, 0x00cfea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0000ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000003500027308ULL, 0x000e640000001000ULL,
0xbf80000002007423ULL, 0x002fc80000000035ULL, 0x800000ff00037221ULL, 0x000fc80000010100ULL,
0x0000000302027223ULL, 0x000fce0000000002ULL, 0x0000000000007919ULL, 0x000f240000000000ULL,
0x00000002ff037819ULL, 0x010fe40000011600ULL, 0x00000008000d7811ULL, 0x008fe400078ff0ffULL,
0xfffffff8ff0f7812ULL, 0x000fe200078ee200ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0302037589ULL, 0x000ee200000e0000ULL, 0x000000030f127819ULL, 0x000fe200000006ffULL,
0x000000080f117836ULL, 0x000fc40000000000ULL, 0x00001f0d020d7589ULL, 0x00096200000e0000ULL,
0x000000080f137824ULL, 0x000fe400078e00ffULL, 0x0000000811147824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003403047220ULL, 0x048fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000003203057220ULL, 0x040fe20000410000ULL,
0x0000003103067220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000002e03077220ULL, 0x040fe20000410000ULL,
0x0000002d03087220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002a03097220ULL, 0x040fe20000410000ULL,
0x0000002903027220ULL, 0x050fe20000410000ULL, 0x00000028030a7220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x00000026030b7220ULL, 0x040fe20000410000ULL,
0x00000025030c7220ULL, 0x000fe20000410000ULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x000000240d247220ULL, 0x062fe20000410000ULL, 0x000000230d237220ULL, 0x040fe20000410000ULL,
0x000000220d227220ULL, 0x000fe20000410000ULL, 0x00000003030e7812ULL, 0x000fe200078ec0ffULL,
0x000000210d217220ULL, 0x040fe20000410000ULL, 0x000000200d207220ULL, 0x040fe20000410000ULL,
0x0000001f0d1f7220ULL, 0x040fe20000410000ULL, 0x0000001e0d1e7220ULL, 0x000fe20000410000ULL,
0x000000010e0f7824ULL, 0x000fc400078e020fULL, 0x0000001d0d1d7220ULL, 0x040fe20000410000ULL,
0x0000001c0d1c7220ULL, 0x040fe20000410000ULL, 0x0000001b0d1b7220ULL, 0x040fe20000410000ULL,
0x0000001a0d1a7220ULL, 0x040fe20000410000ULL, 0x000000190d197220ULL, 0x040fe20000410000ULL,
0x000000180d187220ULL, 0x040fe20000410000ULL, 0x000000170d177220ULL, 0x040fe20000410000ULL,
0x000000160d167220ULL, 0x040fe20000410000ULL, 0x000000010e107824ULL, 0x000fe400078e0211ULL,
0x000000150d0d7220ULL, 0x000fe20000410000ULL, 0x000000040f0e7836ULL, 0x000fe20000000000ULL,
0x000000050605723eULL, 0x000fe200000000ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x0000000c0f117810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8120f7812ULL, 0x000fe400078ee20fULL,
0xfffffff8130e7812ULL, 0x000fe400078ee20eULL, 0xfffffff815107812ULL, 0x000fe400078ee210ULL,
0xfffffff814117812ULL, 0x000fe400078ee211ULL, 0x000000043304723eULL, 0x000fe400000000ffULL,
0x000000302f06723eULL, 0x000fc400000000ffULL, 0x000000070807723eULL, 0x000fe400000000ffULL,
0x000000110f0f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000002c2b08723eULL, 0x000fe400000000ffULL,
0x000000090209723eULL, 0x000fe200000000ffULL, 0x000000040f007844ULL, 0x0003e20000000200ULL,
0x0000000a270a723eULL, 0x000fe400000000ffULL, 0x0000000b0c0b723eULL, 0x000fc400000000ffULL,
0x000000110e0e7c11ULL, 0x000fe4000f8e20ffULL, 0x000000242324723eULL, 0x000fe400000000ffULL,
0x000000222125723eULL, 0x000fe200000000ffULL, 0x000000080e007844ULL, 0x0003e20000000200ULL,
0x000000201f26723eULL, 0x000fe400000000ffULL, 0x0000001e1d27723eULL, 0x000fe400000000ffULL,
0x0000001110107c11ULL, 0x000fc4000f8e20ffULL, 0x0000001c1b1c723eULL, 0x000fe400000000ffULL,
0x0000001a191d723eULL, 0x000fe200000000ffULL, 0x0000002410007844ULL, 0x0003e20000000200ULL,
0x00000018171e723eULL, 0x000fe400000000ffULL, 0x000000160d1f723eULL, 0x000fe400000000ffULL,
0x0000001111117c11ULL, 0x000fca000f8e20ffULL, 0x0000001c11007844ULL, 0x0003e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000103027824ULL, 0x004fe200078e0200ULL,
0x00000000000479c3ULL, 0x000ea20000002600ULL, 0x0000000700097812ULL, 0x002fe200078ec0ffULL,
0x00000018ff087e24ULL, 0x000fe4000f8e00ffULL, 0x0000000702057812ULL, 0x000fc600078ec0ffULL,
0x1ffffff809097812ULL, 0x000fe200078ef808ULL, 0x00008400ff027b82ULL, 0x000ea20000000800ULL,
0x0ffffff805057812ULL, 0x000fc800078ef800ULL, 0x0000000805057c11ULL, 0x000fcc000f8e20ffULL,
0x0120000005047984ULL, 0x000e620000000c00ULL, 0x0000000403037e24ULL, 0x004fe2000f8e0202ULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0x0000001702027c24ULL, 0x000fca000f8e02ffULL,
0x0000000302037211ULL, 0x000fca00078010ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fc8000f8048ffULL, 0x0000000503037c11ULL, 0x000fc600080f4c00ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d12ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000002700ULL,
0x000000030300780cULL, 0x000fe20003f44070ULL, 0x00009200ff087b82ULL, 0x000ea20000000a00ULL,
0x0000000615147899ULL, 0x000fe2000800063fULL, 0x0000002003027836ULL, 0x000fe20000000000ULL,
0x000000013f0a7899ULL, 0x000fe40008011615ULL, 0x00000014190b7291ULL, 0x000fe4000f8e403fULL,
0x0000000a190a7291ULL, 0x000fe2000f8e083fULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x0000000815177291ULL, 0x000fc4000f8e403fULL, 0x0000000b03057c36ULL, 0x000fe20008000000ULL,
0x00009000ff0dab82ULL, 0x000ee20000000800ULL, 0x00000000003f7886ULL, 0x000fe20001020000ULL,
0x0000000b02067c36ULL, 0x000fe20008000000ULL, 0x000000041b0472a4ULL, 0x000fe2000f8e020bULL,
0x0000001a05007c0cULL, 0x000fe2000bf06070ULL, 0x0000000709097899ULL, 0x000fe4000800063fULL,
0x000000060a00928cULL, 0x000fe2000bf06070ULL, 0x00008c00ff0aab82ULL, 0x000f220000000a00ULL,
0x0000001a06007c0cULL, 0x000fe2000bf26070ULL, 0x0000000403077c36ULL, 0x000fe20008000000ULL,
0x000000070d0d7899ULL, 0x000fe2000800063fULL, 0x0000000402057c36ULL, 0x000fe20008000000ULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x0000000815049291ULL, 0x000fe2000f8e203fULL,
0x0000000407067825ULL, 0x004fe200078e0008ULL, 0x00000040090c7892ULL, 0x000fc6000f8ef80bULL,
0x000000040004a824ULL, 0x002fe200078e0203ULL, 0x00000004030fac11ULL, 0x000fe2000f8e10ffULL,
0x0000000405087825ULL, 0x000fe200078e0008ULL, 0x0000000119047890ULL, 0x000fe4000fffe03fULL,
0x000000010404a819ULL, 0x000fe400000006ffULL, 0x000000050400728cULL, 0x000fc6000bf06070ULL,
0x0000000a040dae24ULL, 0x008fe4000f8e020dULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x000000040d0aa825ULL, 0x010fe200078e000aULL, 0x00000017030d7c11ULL, 0x000fc6000f8e10ffULL,
0x01cad004ff0479a7ULL, 0x000e640008500008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1c600000060d7faeULL, 0x0003e2000c121852ULL, 0x000000000000781cULL, 0x000fc60003f0f008ULL,
0x1c680000080d7faeULL, 0x0003e8000c921852ULL, 0x1ca800000a0fafaeULL, 0x0003e8000d921852ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000001000a88947ULL, 0x002fea0003800000ULL,
0x00000003ff027819ULL, 0x100fe20000011603ULL, 0x00000008150e7291ULL, 0x000fe4000f8e203fULL,
0x0000000b1a00728cULL, 0x000fe2000bf01070ULL, 0x0000001702047c11ULL, 0x040fe2000f8e10ffULL,
0x0000000c02097c36ULL, 0x000fe40008000000ULL, 0x0000000b1a047287ULL, 0x000fe2000c000000ULL,
0x00000001020e7824ULL, 0x000fe200078e0203ULL, 0x01c6000004067984ULL, 0x000e640000000800ULL,
0x000000040b047290ULL, 0x000fc4000fffe13fULL, 0x00000008150b7291ULL, 0x000fe2000f8e703fULL,
0x000000070e0e7812ULL, 0x000fc600078ec0ffULL, 0x0000000402007c0cULL, 0x000fe2000bf06070ULL,
0x000020000b0b7890ULL, 0x000fe2000fffe03fULL, 0x0000000e060d7c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff067b82ULL, 0x000e660000000a00ULL, 0x01ca80000d087984ULL, 0x000ea40000000800ULL,
0x0000000d08097c24ULL, 0x004fe2000f8e0209ULL, 0x000000700c087812ULL, 0x000fc600078ec0ffULL,
0x00000200090a7825ULL, 0x002fe200078e0006ULL, 0x0ffffff80e097812ULL, 0x000fc600078ef803ULL,
0x00000004020e7836ULL, 0x000fe20000000000ULL, 0x0000000a080c7210ULL, 0x000fe40007f3e0ffULL,
0x0000000b09097c11ULL, 0x000fe2000f8e20ffULL, 0x000000010e0f7824ULL, 0x000fe200078e0203ULL,
0x0000000bff0d7210ULL, 0x000fe20000ffe4ffULL, 0x0000000c0e0b7c36ULL, 0x000fc80008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x040fe2000bf06070ULL, 0x000000080e0e7824ULL, 0x000fe400078e00ffULL,
0x01c61000040a7984ULL, 0x000ea60000000800ULL, 0xfffffff80e0f7812ULL, 0x000fe200078ee20fULL,
0x00000008020e7836ULL, 0x000fc60000000000ULL, 0x0000000b0f0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e0a107c11ULL, 0x004fca000f8e10ffULL, 0x01ca8000100a7984ULL, 0x0004e40000000800ULL,
0x000000010e107824ULL, 0x004fe400078e0203ULL, 0x0000000d0a0b7c24ULL, 0x008fc8000f8e020bULL,
0x000002000b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a080c7210ULL, 0x002fe40007f3e0ffULL,
0x0000000c0e0a7c10ULL, 0x000fc6000fffe0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6200004097984ULL, 0x000ea40000000800ULL,
0x0000000e09117c11ULL, 0x004fca000f8e10ffULL, 0x01ca800011097984ULL, 0x000ea40000000800ULL,
0x0000000d09097c24ULL, 0x004fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x0000000c020e7836ULL, 0x000fc60000000000ULL, 0xfffffff809107812ULL, 0x000fe200078ee210ULL,
0x000000ffff0d7224ULL, 0x000fe400008e060bULL, 0x0000000c0e0b7c36ULL, 0x000fe20008000000ULL,
0x0000000b10097c11ULL, 0x000fe2000f8e20ffULL, 0x000000010e0f7824ULL, 0x000fc800078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x040fe4000bf06070ULL, 0x000000030e0e7819ULL, 0x000fe200000006ffULL,
0x01c63000040a7984ULL, 0x000ea60000000800ULL, 0xfffffff80e0f7812ULL, 0x000fe200078ee20fULL,
0x00000010020e7836ULL, 0x000fc60000000000ULL, 0x0000000b0f0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e0a107c11ULL, 0x004fca000f8e10ffULL, 0x01ca8000100a7984ULL, 0x0004e40000000800ULL,
0x000000010e107824ULL, 0x004fe400078e0203ULL, 0x0000000d0a0b7c24ULL, 0x008fc8000f8e020bULL,
0x000002000b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x0000000c0e0a7c36ULL, 0x000fc80008000000ULL, 0x000000ffff0d7224ULL, 0x000fca00008e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6400004097984ULL, 0x000ea40000000800ULL,
0x0000000e09117c11ULL, 0x004fca000f8e10ffULL, 0x01ca800011097984ULL, 0x000ea40000000800ULL,
0x0000000d09097c24ULL, 0x004fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0x0000000a080c7210ULL, 0x002fe40007f3e0ffULL,
0x00000014020e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff809107812ULL, 0x000fe200078ee210ULL,
0x000000ffff0d7224ULL, 0x000fe400008e060bULL, 0x0000000c0e0b7c36ULL, 0x000fe20008000000ULL,
0x0000000b10097c11ULL, 0x000fe2000f8e20ffULL, 0x000000010e0f7824ULL, 0x000fc800078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x040fe2000bf06070ULL, 0x000000080e0e7824ULL, 0x000fe400078e00ffULL,
0x01c65000040a7984ULL, 0x000ea60000000800ULL, 0xfffffff80e0f7812ULL, 0x000fe200078ee20fULL,
0x00000018020e7836ULL, 0x000fc60000000000ULL, 0x0000000b0f0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e0a107c11ULL, 0x004fca000f8e10ffULL, 0x01ca8000100a7984ULL, 0x0004e40000000800ULL,
0x000000030e107210ULL, 0x004fe20007ffe0ffULL, 0x0000000d0a0b7c24ULL, 0x008fc8000f8e020bULL,
0x000002000b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x0000000c0e0a7c36ULL, 0x000fc80008000000ULL, 0x000000ffff0d7224ULL, 0x000fca00008e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6600004097984ULL, 0x000ea40000000800ULL,
0x0000000e09117c11ULL, 0x004fca000f8e10ffULL, 0x01ca800011097984ULL, 0x000ea40000000800ULL,
0x0000000d09097c24ULL, 0x004fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x0000001c020e7836ULL, 0x000fc60000000000ULL, 0xfffffff809107812ULL, 0x000fe200078ee210ULL,
0x000000ffff0d7224ULL, 0x000fe400008e060bULL, 0x0000000c0e0b7c36ULL, 0x000fe20008000000ULL,
0x0000000b10097c11ULL, 0x000fe2000f8e20ffULL, 0x000000010e0f7824ULL, 0x000fc800078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x040fe2000bf06070ULL, 0x000000080e0e7824ULL, 0x000fe400078e00ffULL,
0x01c67000040a7984ULL, 0x000ea60000000800ULL, 0xfffffff80e0f7812ULL, 0x000fe200078ee20fULL,
0x00000020020e7836ULL, 0x000fc60000000000ULL, 0x0000000b0f0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e0a107c11ULL, 0x004fca000f8e10ffULL, 0x01ca8000100a7984ULL, 0x0004e40000000800ULL,
0x000000010e107824ULL, 0x004fe400078e0203ULL, 0x0000000d0a0b7c24ULL, 0x008fc8000f8e020bULL,
0x000002000b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x0000000c0e0a7c36ULL, 0x000fc60008000000ULL, 0x0000000bff0d7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6800004097984ULL, 0x000ea40000000800ULL,
0x0000000e09117c11ULL, 0x004fca000f8e10ffULL, 0x01ca800011097984ULL, 0x000ea40000000800ULL,
0x0000000d09097c24ULL, 0x004fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x00000024020e7836ULL, 0x000fc60000000000ULL, 0xfffffff809107812ULL, 0x000fe200078ee210ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x0000000c0e0b7c10ULL, 0x000fe2000fffe0ffULL,
0x000000010e0f7824ULL, 0x000fe200078e0203ULL, 0x0000000b10097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x040fe2000bf06070ULL, 0x000000080e0e7824ULL, 0x000fe400078e00ffULL,
0x01c69000040a7984ULL, 0x000ea60000000800ULL, 0xfffffff80e0f7812ULL, 0x000fe200078ee20fULL,
0x00000028020e7836ULL, 0x000fc60000000000ULL, 0x0000000b0f0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e0a107c11ULL, 0x004fca000f8e10ffULL, 0x01ca8000100a7984ULL, 0x0004e40000000800ULL,
0x000000010e107824ULL, 0x004fe400078e0203ULL, 0x0000000d0a0b7c24ULL, 0x008fc8000f8e020bULL,
0x000002000b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x0000000c0e0a7c36ULL, 0x000fc80008000000ULL, 0x000000ffff0d7224ULL, 0x000fca00008e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6a00004097984ULL, 0x000ea40000000800ULL,
0x0000000e09117c11ULL, 0x004fca000f8e10ffULL, 0x01ca800011097984ULL, 0x000ea40000000800ULL,
0x0000000d09097c24ULL, 0x004fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fe200078e0006ULL,
0x000000030e097819ULL, 0x000fc600000006ffULL, 0x0000002c020e7836ULL, 0x000fe20000000000ULL,
0x0000000a080c7210ULL, 0x002fe40007f3e0ffULL, 0xfffffff809107812ULL, 0x000fe200078ee210ULL,
0x000000010e0f7824ULL, 0x000fe400078e0203ULL, 0x000000ffff0d7224ULL, 0x000fe200008e060bULL,
0x0000000b10097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c0e0b7c36ULL, 0x000fc80008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x040fe2000bf06070ULL, 0x000000080e0e7824ULL, 0x000fe400078e00ffULL,
0x01c6b000040a7984ULL, 0x000ea60000000800ULL, 0xfffffff80e0f7812ULL, 0x000fe400078ee20fULL,
0x00000030020e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b0f0f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000e0a107c11ULL, 0x004fca000f8e10ffULL, 0x01ca8000100a7984ULL, 0x0004e40000000800ULL,
0x000000010e107824ULL, 0x004fe400078e0203ULL, 0x0000000d0a0b7c24ULL, 0x008fc8000f8e020bULL,
0x000002000b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x0000000c0e0a7c36ULL, 0x000fc80008000000ULL, 0x000000ffff0d7224ULL, 0x000fca00008e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6c00004097984ULL, 0x000ea40000000800ULL,
0x0000000e09117c11ULL, 0x004fca000f8e10ffULL, 0x01ca800011097984ULL, 0x000ea40000000800ULL,
0x0000000d09097c24ULL, 0x004fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x00000034020e7836ULL, 0x000fc60000000000ULL, 0xfffffff809107812ULL, 0x000fe200078ee210ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x000000030e0f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000c0e0b7c36ULL, 0x000fe20008000000ULL, 0x0000000b10097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x040fe2000bf06070ULL, 0x000000080e0e7824ULL, 0x000fe400078e00ffULL,
0x01c6d000040a7984ULL, 0x000ea60000000800ULL, 0xfffffff80e0f7812ULL, 0x000fe200078ee20fULL,
0x00000038020e7836ULL, 0x000fe40000000000ULL, 0x0000003c02027836ULL, 0x000fe20000000000ULL,
0x0000000b0f0f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000e0a107c11ULL, 0x004fca000f8e10ffULL,
0x01ca8000100a7984ULL, 0x0004e40000000800ULL, 0x000000010e107824ULL, 0x104fe400078e0203ULL,
0x0000000102037824ULL, 0x000fe400078e0203ULL, 0x0000000d0a0b7c24ULL, 0x008fc8000f8e020bULL,
0x000002000b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a080c7210ULL, 0x002fe20007f3e0ffULL,
0x0000000c0e0a7c36ULL, 0x000fc80008000000ULL, 0x000000ffff0d7224ULL, 0x000fca00008e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c52ULL,
0x000000040e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6e00004097984ULL, 0x000ea20000000800ULL,
0x0000000c020d7c36ULL, 0x002fe20008000000ULL, 0x0000000e09117c11ULL, 0x004fca000f8e10ffULL,
0x01ca800011097984ULL, 0x000e640000000800ULL, 0x0000000d09097c24ULL, 0x002fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fc800078e0006ULL, 0x000000080e097824ULL, 0x000fe200078e00ffULL,
0x0000000a080a7210ULL, 0x000fc80007f3e0ffULL, 0xfffffff809107812ULL, 0x000fe400078ee210ULL,
0x0000000bff0b7210ULL, 0x000fe40000ffe4ffULL, 0x0000000b10097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a097faeULL, 0x0003e2000c101c52ULL,
0x0000000402007c0cULL, 0x040fe2000bf06070ULL, 0x0000000802027824ULL, 0x000fe400078e00ffULL,
0x01c6f00004047984ULL, 0x000ea60000000800ULL, 0xfffffff802037812ULL, 0x000fc800078ee203ULL,
0x0000000b03037c11ULL, 0x000fe4000f8e20ffULL, 0x0000000e040c7c11ULL, 0x004fcc000f8e10ffULL,
0x01ca80000c0c7984ULL, 0x000ea40000000800ULL, 0x0000000d0c0d7c24ULL, 0x004fc8000f8e020dULL,
0x000002000d067825ULL, 0x000fc600078e0006ULL, 0x0000000608087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x002fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008037faeULL, 0x0003e2000c101c52ULL, 0x0000001000587947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fe20000011603ULL, 0x00000008150b7291ULL, 0x000fe2000f8e203fULL,
0x00008a00ff067b82ULL, 0x000e620000000a00ULL, 0x0000000815047291ULL, 0x000fe2000f8e703fULL,
0x0000001702087c11ULL, 0x000fe2000f8e10ffULL, 0x0000000c020b7c36ULL, 0x000fe20008000000ULL,
0x00000003020d7210ULL, 0x000fe20007ffe0ffULL, 0x0000200004047890ULL, 0x000fe4000fffe03fULL,
0x01c6000008047984ULL, 0x000ea20000000800ULL, 0x000000070d0e7812ULL, 0x000fc800078ec0ffULL,
0x0ffffff80e0e7812ULL, 0x000fc800078ef803ULL, 0x000000040e117c11ULL, 0x000fe2000f8e20ffULL,
0x00000004020e7836ULL, 0x000fc80000000000ULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x0000000b04097c11ULL, 0x004fca000f8e10ffULL, 0x01ca800009047984ULL, 0x000ea40000000800ULL,
0x0000000d040b7c24ULL, 0x004fe2000f8e020bULL, 0x000000700c047812ULL, 0x000fc600078ec0ffULL,
0x000002000b0a7825ULL, 0x002fc600078e0006ULL, 0x000000040a0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000c0e0a7c36ULL, 0x000fc80008000000ULL, 0x000000ffff0d7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c52ULL,
0x01c6100008097984ULL, 0x000ea20000000800ULL, 0x00000008020c7810ULL, 0x002fe40007ffe0ffULL,
0x0000000b09107c11ULL, 0x004fca000f8e10ffULL, 0x01ca800010097984ULL, 0x000e640000000800ULL,
0x0000000d09097c24ULL, 0x002fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000010e097824ULL, 0x000fe200078e0203ULL, 0x000000040a0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000c0c0a7c36ULL, 0x000fc60008000000ULL, 0xfffffff812097812ULL, 0x000fe200078ee209ULL,
0x000000ffff0f7224ULL, 0x000fe400000e060bULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0x0000000409117c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e8000b901c52ULL, 0x01c6200008097984ULL, 0x000ea20000000800ULL,
0x0000000c020e7836ULL, 0x002fe20000000000ULL, 0x0000000b09107c11ULL, 0x004fca000f8e10ffULL,
0x01ca800010097984ULL, 0x000e640000000800ULL, 0x0000000d09097c24ULL, 0x002fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fc800078e0006ULL, 0x000000010c097824ULL, 0x000fe200078e0203ULL,
0x000000040a0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000c0e0a7c36ULL, 0x000fc60008000000ULL,
0xfffffff812097812ULL, 0x000fe200078ee209ULL, 0x000000ffff0d7224ULL, 0x000fe400000e060bULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0x0000000409117c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c52ULL,
0x01c6300008097984ULL, 0x000ea20000000800ULL, 0x00000010020c7836ULL, 0x002fe20000000000ULL,
0x0000000b09107c11ULL, 0x004fca000f8e10ffULL, 0x01ca800010097984ULL, 0x000e640000000800ULL,
0x0000000d09097c24ULL, 0x002fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fe200078e0006ULL,
0x000000030e097210ULL, 0x000fe40007ffe0ffULL, 0x000000040a0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000c0c0a7c36ULL, 0x000fe20008000000ULL, 0xfffffff812097812ULL, 0x000fe200078ee209ULL,
0x000000080c127824ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060bULL,
0x0000000409117c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e8000b901c52ULL, 0x01c6400008097984ULL, 0x000ea20000000800ULL,
0x00000014020e7836ULL, 0x002fe20000000000ULL, 0x0000000b09107c11ULL, 0x004fca000f8e10ffULL,
0x01ca800010097984ULL, 0x000e640000000800ULL, 0x0000000d09097c24ULL, 0x002fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fc800078e0006ULL, 0x000000010c097824ULL, 0x000fe200078e0203ULL,
0x000000040a0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000c0e0a7c36ULL, 0x000fc60008000000ULL,
0xfffffff812097812ULL, 0x000fe200078ee209ULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x0000000bff0d7210ULL, 0x000fe400007fe4ffULL, 0x0000000409117c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c52ULL,
0x01c6500008097984ULL, 0x000ea20000000800ULL, 0x00000018020c7836ULL, 0x002fe20000000000ULL,
0x0000000b09107c11ULL, 0x004fca000f8e10ffULL, 0x01ca800010097984ULL, 0x000e640000000800ULL,
0x0000000d09097c24ULL, 0x002fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000010e097824ULL, 0x000fe200078e0203ULL, 0x000000040a0e7210ULL, 0x000fe40007f1e0ffULL,
0x0000000c0c0a7c10ULL, 0x000fe4000fffe0ffULL, 0xfffffff812097812ULL, 0x000fe200078ee209ULL,
0x000000ffff0f7224ULL, 0x000fe400000e060bULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0x0000000409117c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e8000b901c52ULL, 0x01c6600008097984ULL, 0x000ea20000000800ULL,
0x0000001c020e7836ULL, 0x002fe20000000000ULL, 0x0000000b09107c11ULL, 0x004fca000f8e10ffULL,
0x01ca800010097984ULL, 0x000e640000000800ULL, 0x0000000d09097c24ULL, 0x002fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fc800078e0006ULL, 0x000000010c097824ULL, 0x000fe200078e0203ULL,
0x000000040a0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000c0e0a7c36ULL, 0x000fc60008000000ULL,
0xfffffff812097812ULL, 0x000fe200078ee209ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060bULL,
0x000000030e127819ULL, 0x000fe400000006ffULL, 0x0000000409117c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c52ULL,
0x01c6700008097984ULL, 0x000ea20000000800ULL, 0x00000020020c7836ULL, 0x002fe20000000000ULL,
0x0000000b09107c11ULL, 0x004fca000f8e10ffULL, 0x01ca800010097984ULL, 0x000e640000000800ULL,
0x0000000d09097c24ULL, 0x002fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000010e097824ULL, 0x000fe200078e0203ULL, 0x000000040a0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000c0c0a7c36ULL, 0x000fc60008000000ULL, 0xfffffff812097812ULL, 0x000fe200078ee209ULL,
0x000000ffff0f7224ULL, 0x000fe400000e060bULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0x0000000409117c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e8000b901c52ULL, 0x01c6800008097984ULL, 0x000ea20000000800ULL,
0x00000024020e7810ULL, 0x002fe40007ffe0ffULL, 0x0000000b09107c11ULL, 0x004fca000f8e10ffULL,
0x01ca800010097984ULL, 0x000e640000000800ULL, 0x0000000d09097c24ULL, 0x002fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fc800078e0006ULL, 0x000000010c097824ULL, 0x000fe200078e0203ULL,
0x000000040a0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000c0e0a7c36ULL, 0x000fc60008000000ULL,
0xfffffff812097812ULL, 0x000fe200078ee209ULL, 0x000000ffff0d7224ULL, 0x000fe400000e060bULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0x0000000409117c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c52ULL,
0x01c6900008097984ULL, 0x000ea20000000800ULL, 0x00000028020c7836ULL, 0x002fe20000000000ULL,
0x0000000b09107c11ULL, 0x004fca000f8e10ffULL, 0x01ca800010097984ULL, 0x000e640000000800ULL,
0x0000000d09097c24ULL, 0x002fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000010e097824ULL, 0x000fe200078e0203ULL, 0x000000040a0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000c0c0a7c36ULL, 0x000fc60008000000ULL, 0xfffffff812097812ULL, 0x000fe200078ee209ULL,
0x000000ffff0f7224ULL, 0x000fe400000e060bULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0x0000000409117c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e8000b901c52ULL, 0x01c6a00008097984ULL, 0x000ea20000000800ULL,
0x0000002c020e7836ULL, 0x002fe20000000000ULL, 0x0000000b09107c11ULL, 0x004fca000f8e10ffULL,
0x01ca800010097984ULL, 0x000e640000000800ULL, 0x0000000d09097c24ULL, 0x002fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fe200078e0006ULL, 0x000000030c097210ULL, 0x000fe40007ffe0ffULL,
0x000000040a0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000c0e0a7c36ULL, 0x000fe20008000000ULL,
0xfffffff812097812ULL, 0x000fe200078ee209ULL, 0x000000080e127824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060bULL, 0x0000000409117c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c52ULL,
0x01c6b00008097984ULL, 0x000ea20000000800ULL, 0x00000030020c7836ULL, 0x002fe20000000000ULL,
0x0000000b09107c11ULL, 0x004fca000f8e10ffULL, 0x01ca800010097984ULL, 0x000e640000000800ULL,
0x0000000d09097c24ULL, 0x002fc8000f8e020aULL, 0x00000200090a7825ULL, 0x000fc800078e0006ULL,
0x000000010e097824ULL, 0x000fe200078e0203ULL, 0x000000040a0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000c0c0a7c36ULL, 0x000fc60008000000ULL, 0xfffffff812097812ULL, 0x000fe200078ee209ULL,
0x000000080c127824ULL, 0x000fe200078e00ffULL, 0x0000000bff0f7210ULL, 0x000fe400007fe4ffULL,
0x0000000409117c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e8000b901c52ULL, 0x01c6c00008097984ULL, 0x000ea20000000800ULL,
0x00000034020e7836ULL, 0x002fe20000000000ULL, 0x0000000b09107c11ULL, 0x004fca000f8e10ffULL,
0x01ca800010097984ULL, 0x000e640000000800ULL, 0x0000000d09097c24ULL, 0x002fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fc800078e0006ULL, 0x000000010c097824ULL, 0x000fe200078e0203ULL,
0x000000040a0c7210ULL, 0x000fe40007f1e0ffULL, 0x0000000c0e0a7c10ULL, 0x000fe4000fffe0ffULL,
0xfffffff812097812ULL, 0x000fe200078ee209ULL, 0x000000ffff0d7224ULL, 0x000fe400000e060bULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0x0000000409117c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c52ULL,
0x01c6d00008097984ULL, 0x000ea40000000800ULL, 0x0000000b09107c11ULL, 0x004fca000f8e10ffULL,
0x01ca800010097984ULL, 0x0004e40000000800ULL, 0x0000003802107836ULL, 0x004fe40000000000ULL,
0x0000003c02027836ULL, 0x000fe40000000000ULL, 0x0000000d09097c24ULL, 0x008fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fc800078e0006ULL, 0x000000010e097824ULL, 0x000fe200078e0203ULL,
0x000000040a0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000c100a7c36ULL, 0x000fc60008000000ULL,
0xfffffff812097812ULL, 0x000fe200078ee209ULL, 0x000000ffff0f7224ULL, 0x000fc600000e060bULL,
0x00000004090d7c11ULL, 0x002fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0003e8000b901c52ULL, 0x01c6e00008097984ULL, 0x000ea20000000800ULL,
0x0000000c020e7c36ULL, 0x002fe20008000000ULL, 0x0000000b090c7c11ULL, 0x004fca000f8e10ffULL,
0x01ca80000c097984ULL, 0x000e640000000800ULL, 0x0000000d09097c24ULL, 0x002fc8000f8e020aULL,
0x00000200090a7825ULL, 0x000fc800078e0006ULL, 0x0000000110097824ULL, 0x140fe200078e0203ULL,
0x0000000310107819ULL, 0x000fe200000006ffULL, 0x0000000102037824ULL, 0x000fe200078e0203ULL,
0x000000040a0a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff810097812ULL, 0x000fc600078ee209ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x00000004090d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e8000b901c52ULL,
0x01c6f00008087984ULL, 0x000ea40000000800ULL, 0x0000000b080c7c11ULL, 0x004fca000f8e10ffULL,
0x01ca80000c097984ULL, 0x000ea40000000800ULL, 0x0000000d09097c24ULL, 0x004fe4000f8e020eULL,
0x00000008020e7824ULL, 0x000fe400078e00ffULL, 0x0000020009067825ULL, 0x000fc600078e0006ULL,
0x0000000406027210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e047812ULL, 0x000fc600078ee203ULL,
0x000000ffff037224ULL, 0x000fe200000e0607ULL, 0x0000000404077c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e4000b901c52ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000027805ULL, 0x002fe20000015200ULL, 0x01cad005ff0075a7ULL, 0x000ea40008000148ULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ff00087202ULL, 0x000fce0000000f00ULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000602097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011407ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000204047819ULL, 0x000fc80000001207ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x01cad005ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000051900728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x00008400000b7ab9ULL, 0x000fe40000000800ULL, 0x000000070b0b7899ULL, 0x000fe2000800063fULL,
0x0000000400007824ULL, 0x002fc800078e0202ULL, 0x0000000200007824ULL, 0x000fce00078e00ffULL,
0x0000001419047291ULL, 0x000fc8000f8e403fULL, 0x000000041a00728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x004fea0003800000ULL,
0x000000190700728cULL, 0x000fe2000bf04070ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00008a00000e7ab9ULL, 0x000fe20000000a00ULL, 0x00009400001d7ab9ULL, 0x000fe20000000800ULL,
0x00009000001c7ab9ULL, 0x000fce0000000800ULL, 0x000000023f0c7899ULL, 0x000fe20008011604ULL,
0x0000000000177919ULL, 0x002e620000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000c040c7287ULL, 0x000fc80008000000ULL, 0x000000160c1072a4ULL, 0x000fc8000f8e0219ULL,
0x00000001100c7890ULL, 0x000fe4000fffe03fULL, 0x00000014100d7291ULL, 0x000fe4000f8e403fULL,
0x000000050c00728cULL, 0x000fe4000bf26070ULL, 0x000000400d0c7892ULL, 0x000fc8000f8ec03fULL,
0x000000000000781cULL, 0x000fe20003f0f018ULL, 0x0000000c09117290ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0000001000708947ULL, 0x002fea0003800000ULL,
0x00000003ff007819ULL, 0x100fe20000011617ULL, 0x00000008151f7291ULL, 0x000fe2000f8e203fULL,
0x0000000eff447e24ULL, 0x000fe2000f8e00ffULL, 0x0000000d1a00728cULL, 0x000fe2000bf21070ULL,
0x0000001700027c11ULL, 0x000fe2000f8e10ffULL, 0x00000011006b7c36ULL, 0x000fe20008000000ULL,
0x0000001700067210ULL, 0x000fe20007ffe0ffULL, 0x0000000d1a0c7287ULL, 0x000fe2000c800000ULL,
0x0000000fff457e24ULL, 0x000fe2000f8e00ffULL, 0x01c6000002037984ULL, 0x000e620000000800ULL,
0x0000000815187291ULL, 0x000fe2000f8e703fULL, 0x0000000717587812ULL, 0x000fe200078ec0ffULL,
0x0000000c0d0c7290ULL, 0x000fe2000fffe13fULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x00004000181e7890ULL, 0x000fe2000fffe03fULL, 0x0000000858127812ULL, 0x000fe200078efcffULL,
0x0000000400477836ULL, 0x000fe20000000000ULL, 0x0ffffff806557812ULL, 0x000fe200078ef817ULL,
0x0000003c00567836ULL, 0x000fe20000000000ULL, 0x0000000c00007c0cULL, 0x000fe2000bf26070ULL,
0x00000011476a7c36ULL, 0x000fe20008000000ULL, 0x0000001e556c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000147547824ULL, 0x040fe200078e0217ULL, 0x0000000800137810ULL, 0x000fe20007ffe0ffULL,
0x0000000847097824ULL, 0x000fc400078e00ffULL, 0x0000001156597c36ULL, 0x000fe40008000000ULL,
0x0000001113697c36ULL, 0x000fe20008000000ULL, 0xfffffff809547812ULL, 0x000fe200078ee254ULL,
0x0000000113537824ULL, 0x000fe400078e0217ULL, 0x0000000856167824ULL, 0x000fe200078e00ffULL,
0x0000001e546d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f03037c11ULL, 0x002fca000f8e10ffULL,
0x01ca800003047984ULL, 0x000e640000000800ULL, 0x0000000b04057c24ULL, 0x002fc8000f8e026bULL,
0x0000020005047825ULL, 0x000fc800078e0044ULL, 0x0000001012047825ULL, 0x000fca00078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000046c7faeULL, 0x0003e2000c901c52ULL,
0x0000000c47007c0cULL, 0x000fc6000bf26070ULL, 0x01c6100002037984ULL, 0x000ea40000000800ULL,
0x0000001f03087c11ULL, 0x004fca000f8e10ffULL, 0x01ca800008037984ULL, 0x0004e40000000800ULL,
0x0000000813087824ULL, 0x004fca00078e00ffULL, 0xfffffff808537812ULL, 0x000fc800078ee253ULL,
0x0000001e536e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b03037c24ULL, 0x008fc8000f8e026aULL,
0x0000020003067825ULL, 0x000fc800078e0044ULL, 0x0000001012067825ULL, 0x000fca00078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000066d7faeULL, 0x0005e2000c901c52ULL,
0x0000000c13007c0cULL, 0x000fc6000bf26070ULL, 0x01c6200002037984ULL, 0x000ee40000000800ULL,
0x0000001f03037c11ULL, 0x008fca000f8e10ffULL, 0x01ca800003047984ULL, 0x002e640000000800ULL,
0x0000000b04057c24ULL, 0x002fc8000f8e0269ULL, 0x0000020005047825ULL, 0x000fc800078e0044ULL,
0x0000001012047825ULL, 0x000fca00078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000046e7faeULL, 0x0003e8000c901c52ULL, 0x01c6300002037984ULL, 0x000ee40000000800ULL,
0x0000001f03087c11ULL, 0x008fe2000f8e10ffULL, 0x0000000c00037836ULL, 0x000fc80000000000ULL,
0x01ca800008067984ULL, 0x004ea20000000800ULL, 0x0000001103677c36ULL, 0x000fe20008000000ULL,
0x0000000303097819ULL, 0x040fe200000006ffULL, 0x0000000103527824ULL, 0x040fe200078e0217ULL,
0x0000000c03007c0cULL, 0x000fc8000bf26070ULL, 0xfffffff809527812ULL, 0x000fc800078ee252ULL,
0x0000001e526f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b06077c24ULL, 0x004fc8000f8e0267ULL,
0x0000020007067825ULL, 0x000fc800078e0044ULL, 0x0000001012067825ULL, 0x000fca00078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000066f7faeULL, 0x0005e8000c901c52ULL,
0x01c6400002047984ULL, 0x002e640000000800ULL, 0x0000001f040a7c11ULL, 0x002fe2000f8e10ffULL,
0x0000001000047836ULL, 0x000fc80000000000ULL, 0x01ca80000a057984ULL, 0x000e620000000800ULL,
0x0000001104647c36ULL, 0x000fe20008000000ULL, 0x0000000c04007c0cULL, 0x040fe2000bf26070ULL,
0x0000000104517824ULL, 0x040fe400078e0217ULL, 0x00000008040c7824ULL, 0x000fca00078e00ffULL,
0xfffffff80c517812ULL, 0x000fc800078ee251ULL, 0x0000001e51717c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b05057c24ULL, 0x002fc8000f8e0264ULL, 0x0000020005087825ULL, 0x000fc800078e0044ULL,
0x0000001012087825ULL, 0x000fca00078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008717faeULL, 0x0003e8000c901c52ULL, 0x01c6500002057984ULL, 0x000ee40000000800ULL,
0x0000001f050a7c11ULL, 0x008fe2000f8e10ffULL, 0x0000001400057836ULL, 0x000fc80000000000ULL,
0x01ca80000a067984ULL, 0x004ea20000000800ULL, 0x0000001105637c36ULL, 0x000fe20008000000ULL,
0x0000001705507210ULL, 0x000fe20007ffe0ffULL, 0x00000008050b7824ULL, 0x040fe200078e00ffULL,
0x0000000c05007c0cULL, 0x000fc8000bf26070ULL, 0xfffffff80b507812ULL, 0x000fc800078ee250ULL,
0x0000001e50737c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b06077c24ULL, 0x004fc8000f8e0263ULL,
0x0000020007067825ULL, 0x000fc800078e0044ULL, 0x0000001012067825ULL, 0x000fca00078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006737faeULL, 0x0005e8000c901c52ULL,
0x01c6600002087984ULL, 0x002e620000000800ULL, 0x0000001800067836ULL, 0x004fc80000000000ULL,
0x0000001106627c36ULL, 0x000fe20008000000ULL, 0x0000000c06007c0cULL, 0x040fe2000bf26070ULL,
0x00000001064f7824ULL, 0x040fe400078e0217ULL, 0x00000008060c7824ULL, 0x000fca00078e00ffULL,
0xfffffff80c4f7812ULL, 0x000fc800078ee24fULL, 0x0000001e4f757c11ULL, 0x000fe4000f8e20ffULL,
0x0000001f080a7c11ULL, 0x002fca000f8e10ffULL, 0x01ca80000a097984ULL, 0x000e640000000800ULL,
0x0000000b09097c24ULL, 0x002fc8000f8e0262ULL, 0x0000020009087825ULL, 0x000fc800078e0044ULL,
0x0000001012087825ULL, 0x000fca00078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008757faeULL, 0x0003e8000c901c52ULL, 0x01c6700002077984ULL, 0x000ea40000000800ULL,
0x0000001f070a7c11ULL, 0x004fe2000f8e10ffULL, 0x0000001c00077836ULL, 0x000fc80000000000ULL,
0x00000001074e7824ULL, 0x040fe200078e0217ULL, 0x01ca80000a0a7984ULL, 0x000ea20000000800ULL,
0x0000001107617c10ULL, 0x000fe2000fffe0ffULL, 0x00000008070d7824ULL, 0x040fe200078e00ffULL,
0x0000000c07007c0cULL, 0x000fc8000bf26070ULL, 0xfffffff80d4e7812ULL, 0x000fc800078ee24eULL,
0x0000001e4e747c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b0a0b7c24ULL, 0x004fc8000f8e0261ULL,
0x000002000b087825ULL, 0x002fc800078e0044ULL, 0x0000001012087825ULL, 0x000fca00078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008747faeULL, 0x0003e8000c901c52ULL,
0x01c68000020a7984ULL, 0x000ea20000000800ULL, 0x0000002000087836ULL, 0x002fc80000000000ULL,
0x0000001108607c36ULL, 0x000fe20008000000ULL, 0x0000000c08007c0cULL, 0x040fe2000bf26070ULL,
0x00000001084d7824ULL, 0x040fe400078e0217ULL, 0x00000008080e7824ULL, 0x000fca00078e00ffULL,
0xfffffff80e4d7812ULL, 0x000fc800078ee24dULL, 0x0000001e4d777c11ULL, 0x000fe4000f8e20ffULL,
0x0000001f0a0c7c11ULL, 0x004fca000f8e10ffULL, 0x01ca80000c0b7984ULL, 0x000e640000000800ULL,
0x0000000b0b0b7c24ULL, 0x002fc8000f8e0260ULL, 0x000002000b0a7825ULL, 0x000fc800078e0044ULL,
0x00000010120a7825ULL, 0x000fca00078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a777faeULL, 0x0003e8000c901c52ULL, 0x01c6900002097984ULL, 0x000ea40000000800ULL,
0x0000001f090c7c11ULL, 0x004fe4000f8e10ffULL, 0x0000002400097810ULL, 0x000fc80007ffe0ffULL,
0x01ca80000c0c7984ULL, 0x000ea20000000800ULL, 0x00000011095f7c36ULL, 0x000fe20008000000ULL,
0x0000000c09007c0cULL, 0x040fe2000bf26070ULL, 0x00000001094c7824ULL, 0x040fe400078e0217ULL,
0x00000008090f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f4c7812ULL, 0x000fc800078ee24cULL,
0x0000001e4c797c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b0c0d7c24ULL, 0x004fc8000f8e025fULL,
0x000002000d0a7825ULL, 0x002fc800078e0044ULL, 0x00000010120a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a797faeULL, 0x0003e8000c901c52ULL,
0x01c6a000020c7984ULL, 0x000ea20000000800ULL, 0x00000028000a7836ULL, 0x002fc80000000000ULL,
0x000000110a5e7c36ULL, 0x000fe20008000000ULL, 0x000000030a107819ULL, 0x040fe200000006ffULL,
0x000000010a4b7824ULL, 0x040fe200078e0217ULL, 0x0000000c0a007c0cULL, 0x000fc8000bf26070ULL,
0xfffffff8104b7812ULL, 0x000fc800078ee24bULL, 0x0000001e4b7b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001f0c0e7c11ULL, 0x004fca000f8e10ffULL, 0x01ca80000e0d7984ULL, 0x000e640000000800ULL,
0x0000000b0d0d7c24ULL, 0x002fc8000f8e025eULL, 0x000002000d0c7825ULL, 0x000fc800078e0044ULL,
0x00000010120c7825ULL, 0x000fca00078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c7b7faeULL, 0x0003e8000c901c52ULL, 0x01c6b000020b7984ULL, 0x000ea40000000800ULL,
0x0000001f0b0e7c11ULL, 0x004fe2000f8e10ffULL, 0x0000002c000b7836ULL, 0x000fc80000000000ULL,
0x000000110b5d7c36ULL, 0x000fe20008000000ULL, 0x01ca80000e0e7984ULL, 0x000ea20000000800ULL,
0x000000010b4a7824ULL, 0x040fe200078e0217ULL, 0x0000000c0b007c0cULL, 0x040fe2000bf26070ULL,
0x000000080b117824ULL, 0x000fca00078e00ffULL, 0xfffffff8114a7812ULL, 0x000fc800078ee24aULL,
0x0000001e4a7a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b0e0f7c24ULL, 0x004fc8000f8e025dULL,
0x000002000f0c7825ULL, 0x002fc800078e0044ULL, 0x00000010120c7825ULL, 0x000fca00078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c7a7faeULL, 0x0003e8000c901c52ULL,
0x01c6c000020e7984ULL, 0x000ea20000000800ULL, 0x00000030000c7836ULL, 0x002fc80000000000ULL,
0x000000110c5c7c36ULL, 0x000fe20008000000ULL, 0x000000170c497210ULL, 0x000fe20007ffe0ffULL,
0x000000080c147824ULL, 0x040fe200078e00ffULL, 0x0000000c0c007c0cULL, 0x000fc8000bf26070ULL,
0xfffffff814497812ULL, 0x000fc800078ee249ULL, 0x0000001e49787c11ULL, 0x000fe4000f8e20ffULL,
0x0000001f0e107c11ULL, 0x004fca000f8e10ffULL, 0x01ca8000100f7984ULL, 0x000e640000000800ULL,
0x0000000b0f0f7c24ULL, 0x002fc8000f8e025cULL, 0x000002000f0e7825ULL, 0x000fc800078e0044ULL,
0x00000010120e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e787faeULL, 0x0003e8000c901c52ULL, 0x01c6d000020d7984ULL, 0x000ea40000000800ULL,
0x0000001f0d107c11ULL, 0x004fe2000f8e10ffULL, 0x00000034000d7836ULL, 0x000fc80000000000ULL,
0x000000110d5b7c36ULL, 0x000fe20008000000ULL, 0x01ca800010107984ULL, 0x000ea20000000800ULL,
0x000000010d487824ULL, 0x040fe200078e0217ULL, 0x0000000c0d007c0cULL, 0x040fe2000bf26070ULL,
0x000000080d157824ULL, 0x000fca00078e00ffULL, 0xfffffff815487812ULL, 0x000fc800078ee248ULL,
0x0000001e48767c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b10117c24ULL, 0x004fc8000f8e025bULL,
0x00000200110e7825ULL, 0x002fc800078e0044ULL, 0x00000010120e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e767faeULL, 0x0003e8000c901c52ULL,
0x01c6e00002107984ULL, 0x000ea20000000800ULL, 0x00000038000e7836ULL, 0x002fc80000000000ULL,
0x000000010e467824ULL, 0x040fe200078e0217ULL, 0x000000110e5a7c10ULL, 0x000fe2000fffe0ffULL,
0x000000080e157824ULL, 0x040fe200078e00ffULL, 0x0000000c0e007c0cULL, 0x000fc8000bf26070ULL,
0xfffffff815467812ULL, 0x000fe200078ee246ULL, 0x0000000156157824ULL, 0x000fc600078e0217ULL,
0x0000001e46727c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f10147c11ULL, 0x004fca000f8e10ffULL,
0x01ca800014117984ULL, 0x000e640000000800ULL, 0x0000000b11117c24ULL, 0x002fc8000f8e025aULL,
0x0000020011107825ULL, 0x000fc800078e0044ULL, 0x0000001012107825ULL, 0x000fca00078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010727faeULL, 0x0003e2000c901c52ULL,
0x0000000c56007c0cULL, 0x000fc6000bf26070ULL, 0x01c6f000020f7984ULL, 0x000ea40000000800ULL,
0x0000001f0f147c11ULL, 0x004fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000ea40000000800ULL,
0x0000000b140f7c24ULL, 0x004fc8000f8e0259ULL, 0x000002000f107825ULL, 0x002fe200078e0044ULL,
0xfffffff8160f7812ULL, 0x000fc800078ee215ULL, 0x0000001e0f707c11ULL, 0x000fe2000f8e20ffULL,
0x0000001012107825ULL, 0x000fca00078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010707faeULL, 0x0003e2000c901c52ULL, 0x00000010001c7947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x100fe20000011617ULL, 0x00000008151f7291ULL, 0x000fe2000f8e203fULL,
0x00008a00ff447b82ULL, 0x000e620000000a00ULL, 0x0000000815187291ULL, 0x000fe2000f8e703fULL,
0x0000001700027c11ULL, 0x040fe2000f8e10ffULL, 0x0000000100067824ULL, 0x000fe200078e0217ULL,
0x00000011006b7c10ULL, 0x000fe2000fffe0ffULL, 0x00004000181e7890ULL, 0x000fe2000fffe03fULL,
0x0000000717587812ULL, 0x000fe200078ec0ffULL, 0x01c6000002037984ULL, 0x000ea20000000800ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000000400477836ULL, 0x000fe20000000000ULL,
0x0000000858127812ULL, 0x000fe200078efcffULL, 0x0000000800137836ULL, 0x000fe20000000000ULL,
0x0ffffff806557812ULL, 0x000fe200078ef817ULL, 0x00000011476a7c36ULL, 0x000fc40008000000ULL,
0x0000000147547824ULL, 0x100fe200078e0217ULL, 0x0000001e556c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000847097824ULL, 0x000fe200078e00ffULL, 0x0000001113697c10ULL, 0x000fe2000fffe0ffULL,
0x0000000113537824ULL, 0x000fe400078e0217ULL, 0x0000003c00567836ULL, 0x000fe20000000000ULL,
0xfffffff809547812ULL, 0x000fc600078ee254ULL, 0x0000001156597c36ULL, 0x000fe20008000000ULL,
0x0000001e546d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000856167824ULL, 0x000fe200078e00ffULL,
0x0000001f03037c11ULL, 0x004fca000f8e10ffULL, 0x01ca800003047984ULL, 0x000ea40000000800ULL,
0x0000000b04057c24ULL, 0x004fc8000f8e026bULL, 0x0000020005047825ULL, 0x002fc800078e0044ULL,
0x0000001012047825ULL, 0x000fca00078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000046c7faeULL, 0x0003e8000b901c52ULL, 0x01c6100002037984ULL, 0x000ea40000000800ULL,
0x0000001f03087c11ULL, 0x004fca000f8e10ffULL, 0x01ca800008037984ULL, 0x0004e40000000800ULL,
0x0000000813087824ULL, 0x004fca00078e00ffULL, 0xfffffff808537812ULL, 0x000fc800078ee253ULL,
0x0000001e536e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b03037c24ULL, 0x008fc8000f8e026aULL,
0x0000020003067825ULL, 0x000fc800078e0044ULL, 0x0000001012067825ULL, 0x000fca00078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000066d7faeULL, 0x0005e8000b901c52ULL,
0x01c6200002037984ULL, 0x000ee40000000800ULL, 0x0000001f03037c11ULL, 0x008fca000f8e10ffULL,
0x01ca800003047984ULL, 0x002e640000000800ULL, 0x0000000b04057c24ULL, 0x002fc8000f8e0269ULL,
0x0000020005047825ULL, 0x000fc800078e0044ULL, 0x0000001012047825ULL, 0x000fca00078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000046e7faeULL, 0x0003e8000b901c52ULL,
0x01c6300002037984ULL, 0x000ee40000000800ULL, 0x0000001f03087c11ULL, 0x008fe2000f8e10ffULL,
0x0000000c00037836ULL, 0x000fc80000000000ULL, 0x01ca800008067984ULL, 0x004ea20000000800ULL,
0x0000001103677c36ULL, 0x000fe40008000000ULL, 0x0000000103527824ULL, 0x040fe400078e0217ULL,
0x0000000803097824ULL, 0x000fca00078e00ffULL, 0xfffffff809527812ULL, 0x000fc800078ee252ULL,
0x0000001e526f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b06077c24ULL, 0x004fc8000f8e0267ULL,
0x0000020007067825ULL, 0x000fc800078e0044ULL, 0x0000001012067825ULL, 0x000fca00078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000066f7faeULL, 0x0005e8000b901c52ULL,
0x01c6400002047984ULL, 0x002e640000000800ULL, 0x0000001f040a7c11ULL, 0x002fe4000f8e10ffULL,
0x0000001000047810ULL, 0x000fc60007ffe0ffULL, 0x01ca80000a057984ULL, 0x000e640000000800ULL,
0x0000001104647c36ULL, 0x000fe40008000000ULL, 0x0000000104517824ULL, 0x040fe400078e0217ULL,
0x00000008040c7824ULL, 0x000fca00078e00ffULL, 0xfffffff80c517812ULL, 0x000fc800078ee251ULL,
0x0000001e51717c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b05057c24ULL, 0x002fc8000f8e0264ULL,
0x0000020005087825ULL, 0x000fc800078e0044ULL, 0x0000001012087825ULL, 0x000fca00078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008717faeULL, 0x0003e8000b901c52ULL,
0x01c6500002057984ULL, 0x000ee40000000800ULL, 0x0000001f050a7c11ULL, 0x008fe2000f8e10ffULL,
0x0000001400057836ULL, 0x000fc80000000000ULL, 0x01ca80000a067984ULL, 0x004ea20000000800ULL,
0x0000001105637c36ULL, 0x000fe20008000000ULL, 0x00000003050b7819ULL, 0x040fe200000006ffULL,
0x0000000105507824ULL, 0x000fca00078e0217ULL, 0xfffffff80b507812ULL, 0x000fc800078ee250ULL,
0x0000001e50737c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b06077c24ULL, 0x004fc8000f8e0263ULL,
0x0000020007067825ULL, 0x000fc800078e0044ULL, 0x0000001012067825ULL, 0x000fca00078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006737faeULL, 0x0005e8000b901c52ULL,
0x01c6600002087984ULL, 0x002e620000000800ULL, 0x0000001800067836ULL, 0x004fc80000000000ULL,
0x0000001106627c36ULL, 0x000fe40008000000ULL, 0x00000001064f7824ULL, 0x040fe400078e0217ULL,
0x00000008060c7824ULL, 0x000fca00078e00ffULL, 0xfffffff80c4f7812ULL, 0x000fc800078ee24fULL,
0x0000001e4f757c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f080a7c11ULL, 0x002fca000f8e10ffULL,
0x01ca80000a097984ULL, 0x000e640000000800ULL, 0x0000000b09097c24ULL, 0x002fc8000f8e0262ULL,
0x0000020009087825ULL, 0x000fc800078e0044ULL, 0x0000001012087825ULL, 0x000fca00078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008757faeULL, 0x0003e8000b901c52ULL,
0x01c6700002077984ULL, 0x000ea40000000800ULL, 0x0000001f070a7c11ULL, 0x004fe2000f8e10ffULL,
0x0000001c00077836ULL, 0x000fc80000000000ULL, 0x0000001107617c36ULL, 0x000fe20008000000ULL,
0x01ca80000a0a7984ULL, 0x000ea20000000800ULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x00000017074e7210ULL, 0x000fc80007ffe0ffULL, 0xfffffff80d4e7812ULL, 0x000fc800078ee24eULL,
0x0000001e4e747c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b0a0b7c24ULL, 0x004fc8000f8e0261ULL,
0x000002000b087825ULL, 0x002fc800078e0044ULL, 0x0000001012087825ULL, 0x000fca00078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008747faeULL, 0x0003e8000b901c52ULL,
0x01c68000020a7984ULL, 0x000ea20000000800ULL, 0x0000002000087836ULL, 0x002fc80000000000ULL,
0x0000001108607c36ULL, 0x000fe40008000000ULL, 0x00000001084d7824ULL, 0x040fe400078e0217ULL,
0x00000008080e7824ULL, 0x000fca00078e00ffULL, 0xfffffff80e4d7812ULL, 0x000fc800078ee24dULL,
0x0000001e4d777c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f0a0c7c11ULL, 0x004fca000f8e10ffULL,
0x01ca80000c0b7984ULL, 0x000e640000000800ULL, 0x0000000b0b0b7c24ULL, 0x002fc8000f8e0260ULL,
0x000002000b0a7825ULL, 0x000fc800078e0044ULL, 0x00000010120a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a777faeULL, 0x0003e8000b901c52ULL,
0x01c6900002097984ULL, 0x000ea40000000800ULL, 0x0000001f090c7c11ULL, 0x004fe2000f8e10ffULL,
0x0000002400097836ULL, 0x000fc80000000000ULL, 0x00000001094c7824ULL, 0x040fe200078e0217ULL,
0x01ca80000c0c7984ULL, 0x000ea20000000800ULL, 0x00000011095f7c10ULL, 0x000fe2000fffe0ffULL,
0x00000008090f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f4c7812ULL, 0x000fc800078ee24cULL,
0x0000001e4c797c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b0c0d7c24ULL, 0x004fc8000f8e025fULL,
0x000002000d0a7825ULL, 0x002fc800078e0044ULL, 0x00000010120a7825ULL, 0x000fca00078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a797faeULL, 0x0003e8000b901c52ULL,
0x01c6a000020c7984ULL, 0x000ea20000000800ULL, 0x00000028000a7836ULL, 0x002fc80000000000ULL,
0x000000110a5e7c36ULL, 0x000fe40008000000ULL, 0x000000010a4b7824ULL, 0x040fe400078e0217ULL,
0x000000080a107824ULL, 0x000fca00078e00ffULL, 0xfffffff8104b7812ULL, 0x000fc800078ee24bULL,
0x0000001e4b7b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f0c0e7c11ULL, 0x004fca000f8e10ffULL,
0x01ca80000e0d7984ULL, 0x000e640000000800ULL, 0x0000000b0d0d7c24ULL, 0x002fc8000f8e025eULL,
0x000002000d0c7825ULL, 0x000fc800078e0044ULL, 0x00000010120c7825ULL, 0x000fca00078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c7b7faeULL, 0x0003e8000b901c52ULL,
0x01c6b000020b7984ULL, 0x000ea40000000800ULL, 0x0000001f0b0e7c11ULL, 0x004fe4000f8e10ffULL,
0x0000002c000b7810ULL, 0x000fc80007ffe0ffULL, 0x01ca80000e0e7984ULL, 0x000ea20000000800ULL,
0x000000110b5d7c36ULL, 0x000fe40008000000ULL, 0x000000010b4a7824ULL, 0x040fe400078e0217ULL,
0x000000080b117824ULL, 0x000fca00078e00ffULL, 0xfffffff8114a7812ULL, 0x000fc800078ee24aULL,
0x0000001e4a7a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b0e0f7c24ULL, 0x004fc8000f8e025dULL,
0x000002000f0c7825ULL, 0x002fc800078e0044ULL, 0x00000010120c7825ULL, 0x000fca00078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c7a7faeULL, 0x0003e8000b901c52ULL,
0x01c6c000020e7984ULL, 0x000ea20000000800ULL, 0x00000030000c7836ULL, 0x002fc80000000000ULL,
0x000000110c5c7c36ULL, 0x000fe20008000000ULL, 0x000000030c147819ULL, 0x040fe200000006ffULL,
0x000000010c497824ULL, 0x000fca00078e0217ULL, 0xfffffff814497812ULL, 0x000fc800078ee249ULL,
0x0000001e49787c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f0e107c11ULL, 0x004fca000f8e10ffULL,
0x01ca8000100f7984ULL, 0x000e640000000800ULL, 0x0000000b0f0f7c24ULL, 0x002fc8000f8e025cULL,
0x000002000f0e7825ULL, 0x000fc800078e0044ULL, 0x00000010120e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e787faeULL, 0x0003e8000b901c52ULL,
0x01c6d000020d7984ULL, 0x000ea40000000800ULL, 0x0000001f0d107c11ULL, 0x004fe2000f8e10ffULL,
0x00000034000d7836ULL, 0x000fc80000000000ULL, 0x000000110d5b7c36ULL, 0x000fe20008000000ULL,
0x01ca800010107984ULL, 0x000ea20000000800ULL, 0x000000010d487824ULL, 0x040fe400078e0217ULL,
0x000000080d157824ULL, 0x000fca00078e00ffULL, 0xfffffff815487812ULL, 0x000fc800078ee248ULL,
0x0000001e48767c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b10117c24ULL, 0x004fc8000f8e025bULL,
0x00000200110e7825ULL, 0x002fc800078e0044ULL, 0x00000010120e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e767faeULL, 0x0003e8000b901c52ULL,
0x01c6e00002107984ULL, 0x000ea20000000800ULL, 0x00000038000e7836ULL, 0x002fc80000000000ULL,
0x000000110e5a7c36ULL, 0x000fe20008000000ULL, 0x000000170e467210ULL, 0x000fe20007ffe0ffULL,
0x000000080e157824ULL, 0x000fca00078e00ffULL, 0xfffffff815467812ULL, 0x000fe200078ee246ULL,
0x0000000156157824ULL, 0x000fc600078e0217ULL, 0x0000001e46727c11ULL, 0x000fe4000f8e20ffULL,
0x0000001f10147c11ULL, 0x004fca000f8e10ffULL, 0x01ca800014117984ULL, 0x000e640000000800ULL,
0x0000000b11117c24ULL, 0x002fc8000f8e025aULL, 0x0000020011107825ULL, 0x000fc800078e0044ULL,
0x0000001012107825ULL, 0x000fca00078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010727faeULL, 0x0003e8000b901c52ULL, 0x01c6f000020f7984ULL, 0x000ea40000000800ULL,
0x0000001f0f147c11ULL, 0x004fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000ea40000000800ULL,
0x0000000b140f7c24ULL, 0x004fc8000f8e0259ULL, 0x000002000f107825ULL, 0x002fe200078e0044ULL,
0xfffffff8160f7812ULL, 0x000fc800078ee215ULL, 0x0000001e0f707c11ULL, 0x000fe2000f8e20ffULL,
0x0000001012107825ULL, 0x000fca00078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010707faeULL, 0x0003e4000b901c52ULL, 0x00000004ff117819ULL, 0x002fe20000011617ULL,
0x0000200018187890ULL, 0x000fe2000fffe03fULL, 0x0000000858107812ULL, 0x000fe200078ef817ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000811577824ULL, 0x000fe200078e00ffULL,
0x0000000100147812ULL, 0x000fe200078ec0ffULL, 0x0000002010167824ULL, 0x000fe200078e00ffULL,
0x0000001110117210ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffff857577812ULL, 0x000fc400078ee258ULL, 0xffffffe016157812ULL, 0x000fe200078ee211ULL,
0x0000000211307836ULL, 0x000fe20000000000ULL, 0x0000003057657810ULL, 0x000fe20007ffe0ffULL,
0x0000000114127824ULL, 0x000fe200078e0257ULL, 0x0000000815157c11ULL, 0x000fe2000f8e20ffULL,
0x0000000857177824ULL, 0x000fe400078e00ffULL, 0x0000000212197836ULL, 0x000fe20000000000ULL,
0x0000003212347810ULL, 0x000fe20007ffe0ffULL, 0x00000000152c783bULL, 0x0003e20000000200ULL,
0xfffffff8177c7812ULL, 0x000fe200078ee212ULL, 0x0000002010177824ULL, 0x000fc400078e00ffULL,
0x0000001057687836ULL, 0x000fe20000000000ULL, 0x000000187c187c11ULL, 0x000fe2000f8e20ffULL,
0x0000002057667836ULL, 0x000fe20000000000ULL, 0xffffffe017307812ULL, 0x000fe200078ee230ULL,
0x00000001147d7824ULL, 0x000fe400078e0268ULL, 0x00000000181c783bULL, 0x000ea20000000200ULL,
0x0000000868177824ULL, 0x000fe200078e00ffULL, 0x0000000830307c11ULL, 0x000fe2000f8e20ffULL,
0x0000000114157824ULL, 0x002fe200078e0266ULL, 0x0000381801007387ULL, 0x0003e20000100800ULL,
0x0000000866167824ULL, 0x000fe200078e00ffULL, 0xfffffff8177d7812ULL, 0x000fe200078ee27dULL,
0x0000000114147824ULL, 0x000fe200078e0265ULL, 0x000000003030783bULL, 0x000fe20000000200ULL,
0x0000002212367836ULL, 0x000fe20000000000ULL, 0xfffffff8161b7812ULL, 0x000fe200078ee215ULL,
0x0000000865157824ULL, 0x000fe200078e00ffULL, 0x000000187d177c11ULL, 0x000fe2000f8e20ffULL,
0x0000000866377824ULL, 0x000fe200078e00ffULL, 0x0000000357187819ULL, 0x002fe200000006ffULL,
0x0000000865357824ULL, 0x000fe200078e00ffULL, 0x000000181b167c11ULL, 0x000fe2000f8e20ffULL,
0x00000000173c783bULL, 0x000e620000000200ULL, 0xfffffff8181a7812ULL, 0x000fc400078ee219ULL,
0xfffffff815147812ULL, 0x000fe200078ee214ULL, 0x000000001628783bULL, 0x000ee20000000200ULL,
0xfffffff8373a7812ULL, 0x000fe400078ee236ULL, 0xfffffff835397812ULL, 0x000fe200078ee234ULL,
0x00000c1a01007387ULL, 0x0009e20000100800ULL, 0x000000183a357c11ULL, 0x000fe4000f8e20ffULL,
0x0000001839347c11ULL, 0x000fe2000f8e20ffULL, 0x0000001b01007387ULL, 0x000fe20000100800ULL,
0x000000181a1a7c11ULL, 0x010fca000f8e20ffULL, 0x000000001a20783bULL, 0x000f280000000200ULL,
0x00006c1a01007387ULL, 0x0005e80000100800ULL, 0x00004c1701007387ULL, 0x000fe80000100800ULL,
0x0000541601007387ULL, 0x000fe20000100800ULL, 0x0000001c2c18723cULL, 0x004fe600000018ffULL,
0x0000041401007387ULL, 0x0005e60000100800ULL, 0x0000001e2c1c723cULL, 0x000fe200000018ffULL,
0x0000001814147c11ULL, 0x004fca000f8e20ffULL, 0x0000003c2c40723cULL, 0x002fe200000018ffULL,
0x00005c1401007387ULL, 0x000fea0000100800ULL, 0x000000282c24723cULL, 0x008fe200000018ffULL,
0x000000001414783bULL, 0x000e6a0000000200ULL, 0x0000003e2c3c723cULL, 0x000fec00000018ffULL,
0x000000203018723cULL, 0x010fec0000001818ULL, 0x000000223020723cULL, 0x000fec000000181cULL,
0x0000002a2c28723cULL, 0x000fe200000018ffULL, 0x00000012121c7836ULL, 0x000fc40000000000ULL,
0x00000008681d7824ULL, 0x000fca00078e00ffULL, 0xfffffff81d387812ULL, 0x000fca00078ee21cULL,
0x0000083801007387ULL, 0x0005e80000100800ULL, 0x0000103a01007387ULL, 0x000fe20000100800ULL,
0x000000142c1c723cULL, 0x002fe600000018ffULL, 0x0000143901007387ULL, 0x000fe20000100800ULL,
0x0000001838387c11ULL, 0x004fe4000f8e20ffULL, 0x000000162c2c723cULL, 0x000fe600000018ffULL,
0x0000583801007387ULL, 0x000fe80000100800ULL, 0x000000003814783bULL, 0x000e680000000200ULL,
0x000000003538783bULL, 0x000ea80000000200ULL, 0x0000643501007387ULL, 0x000fe80000100800ULL,
0x0000683401007387ULL, 0x000fe80000100800ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x000000143040723cULL, 0x002fec0000001840ULL, 0x00000016303c723cULL, 0x000fe2000000183cULL,
0x0000002010147824ULL, 0x000fc400078e00ffULL, 0x0000000411157836ULL, 0x000fc60000000000ULL,
0x000000383024723cULL, 0x004fe20000001824ULL, 0x0000000412167836ULL, 0x000fe20000000000ULL,
0xffffffe014147812ULL, 0x000fe400078ee215ULL, 0x0000000368157819ULL, 0x000fe400000006ffULL,
0x0000003a3028723cULL, 0x000fe20000001828ULL, 0x0000000857387824ULL, 0x000fe200078e00ffULL,
0x0000000814147c11ULL, 0x000fc8000f8e20ffULL, 0xfffffff838387812ULL, 0x000fe200078ee216ULL,
0x00000014123a7836ULL, 0x000fe20000000000ULL, 0x00000034301c723cULL, 0x008fe4000000181cULL,
0x00000018383b7c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff8153a7812ULL, 0x000fe400078ee23aULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x000000001430783bULL, 0x000fe20000000200ULL,
0x000000183a397c11ULL, 0x000fc6000f8e20ffULL, 0x000000003b14783bULL, 0x000e680000000200ULL,
0x0000603901007387ULL, 0x000fe80000100800ULL, 0x000000003934783bULL, 0x0004e40000000200ULL,
0x0000002412397836ULL, 0x004fe20000000000ULL, 0x000000143018723cULL, 0x002fec0000001818ULL,
0x000000163020723cULL, 0x000fe20000001820ULL, 0x0000000866147824ULL, 0x000fca00078e00ffULL,
0xfffffff814397812ULL, 0x000fe200078ee239ULL, 0x000000343040723cULL, 0x008fe60000001840ULL,
0x0000001839157c11ULL, 0x000fc6000f8e20ffULL, 0x00000036303c723cULL, 0x000fe2000000183cULL,
0x0000003412357836ULL, 0x000fe20000000000ULL, 0x0000501501007387ULL, 0x000fe80000100800ULL,
0x000000001514783bULL, 0x000e620000000200ULL, 0x0000000868367824ULL, 0x000fe400078e00ffULL,
0x0000000866377824ULL, 0x000fe400078e00ffULL, 0x0000000865687824ULL, 0x040fe200078e00ffULL,
0x000000143024723cULL, 0x002fec0000001824ULL, 0x000000163028723cULL, 0x000fe20000001828ULL,
0x0000000865147824ULL, 0x000fca00078e00ffULL, 0xfffffff814357812ULL, 0x000fc800078ee235ULL,
0x0000001835347c11ULL, 0x000fca000f8e20ffULL, 0x000000003414783bULL, 0x000e680000000200ULL,
0x0000403401007387ULL, 0x0005e40000100800ULL, 0x0000000357347819ULL, 0x004fe200000006ffULL,
0x00000014301c723cULL, 0x002fec000000181cULL, 0x00000016302c723cULL, 0x000fe2000000182cULL,
0x0000002010147824ULL, 0x000fc400078e00ffULL, 0x0000000611157836ULL, 0x000fca0000000000ULL,
0xffffffe014147812ULL, 0x000fe200078ee215ULL, 0x0000000612157836ULL, 0x000fc60000000000ULL,
0x0000000814147c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff834347812ULL, 0x000fe200078ee215ULL,
0x0000001612157836ULL, 0x000fc60000000000ULL, 0x0000001834337c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff836367812ULL, 0x000fe200078ee215ULL, 0x0000002612157836ULL, 0x000fe20000000000ULL,
0x0000003612127810ULL, 0x000fe20007ffe0ffULL, 0x0000483301007387ULL, 0x000fe60000100800ULL,
0xfffffff837377812ULL, 0x000fe200078ee215ULL, 0x000000003330783bULL, 0x000fe20000000200ULL,
0xfffffff868687812ULL, 0x000fc400078ee212ULL, 0x0000001836127c11ULL, 0x000fe2000f8e20ffULL,
0x000000001414783bULL, 0x000e680000000200ULL, 0x0000441201007387ULL, 0x000fe20000100800ULL,
0x000000301418723cULL, 0x002fec0000001818ULL, 0x000000321420723cULL, 0x000fe20000001820ULL,
0x000000001230783bULL, 0x0002a40000000200ULL, 0x0000001837127c11ULL, 0x002fca000f8e20ffULL,
0x00003c1201007387ULL, 0x000fe20000100800ULL, 0x000000301440723cULL, 0x004fec0000001840ULL,
0x00000032143c723cULL, 0x000fe2000000183cULL, 0x000000001230783bULL, 0x0002a40000000200ULL,
0x0000001868127c11ULL, 0x002fca000f8e20ffULL, 0x0000341201007387ULL, 0x000fe20000100800ULL,
0x000000301424723cULL, 0x004fec0000001824ULL, 0x000000321428723cULL, 0x000fe20000001828ULL,
0x000000001230783bULL, 0x000e620000000200ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000030141c723cULL, 0x002fec000000181cULL, 0x00000032142c723cULL, 0x000fe2000000182cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000c00148947ULL, 0x000fde0003800000ULL, 0x01c6000002127984ULL, 0x000e620000000800ULL,
0x0000000d1a00728cULL, 0x000fe2000bf21070ULL, 0x0000001058167812ULL, 0x000fe400078efcffULL,
0x0000001855667c11ULL, 0x000fe2000f8e20ffULL, 0x0000000d1a0c7287ULL, 0x000fe2000c800000ULL,
0x0000001854657c11ULL, 0x000fe4000f8e20ffULL, 0x0000001853577c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c0d0c7290ULL, 0x000fe2000fffe13fULL, 0x0000001852557c11ULL, 0x000fc4000f8e20ffULL,
0x0000001851547c11ULL, 0x000fe4000f8e20ffULL, 0x0000001850537c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c00007c0cULL, 0x000fe4000bf26070ULL, 0x000000184f527c11ULL, 0x000fe4000f8e20ffULL,
0x000000184e517c11ULL, 0x000fe4000f8e20ffULL, 0x000000184d507c11ULL, 0x000fc4000f8e20ffULL,
0x000000184c4f7c11ULL, 0x000fe4000f8e20ffULL, 0x000000184b4e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000184a4d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000018494c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001846467c11ULL, 0x000fe4000f8e20ffULL, 0x000000180f0f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000001f12127c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800012127984ULL, 0x000e640000000800ULL,
0x0000000b12127c24ULL, 0x002fc8000f8e026bULL, 0x0000020012147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014667faeULL, 0x0003e2000c901c52ULL, 0x0000000c47007c0cULL, 0x000fc6000bf26070ULL,
0x01c6100002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e026aULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014657faeULL, 0x0003e2000c901c52ULL,
0x0000000c13007c0cULL, 0x000fc6000bf26070ULL, 0x01c6200002127984ULL, 0x000ea40000000800ULL,
0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL, 0x01ca800012127984ULL, 0x000ea40000000800ULL,
0x0000000b12127c24ULL, 0x004fc8000f8e0269ULL, 0x0000020012147825ULL, 0x002fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014577faeULL, 0x0003e2000c901c52ULL, 0x0000000c03007c0cULL, 0x000fc6000bf26070ULL,
0x01c6300002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0267ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014557faeULL, 0x0003e2000c901c52ULL,
0x0000000c04007c0cULL, 0x000fc6000bf26070ULL, 0x01c6400002127984ULL, 0x000ea40000000800ULL,
0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL, 0x01ca800012127984ULL, 0x000ea40000000800ULL,
0x0000000b12127c24ULL, 0x004fc8000f8e0264ULL, 0x0000020012147825ULL, 0x002fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014547faeULL, 0x0003e2000c901c52ULL, 0x0000000c05007c0cULL, 0x000fc6000bf26070ULL,
0x01c6500002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0263ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014537faeULL, 0x0003e2000c901c52ULL,
0x0000000c06007c0cULL, 0x000fc6000bf26070ULL, 0x01c6600002127984ULL, 0x000ea40000000800ULL,
0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL, 0x01ca800012127984ULL, 0x000ea40000000800ULL,
0x0000000b12127c24ULL, 0x004fc8000f8e0262ULL, 0x0000020012147825ULL, 0x002fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014527faeULL, 0x0003e2000c901c52ULL, 0x0000000c07007c0cULL, 0x000fc6000bf26070ULL,
0x01c6700002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0261ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014517faeULL, 0x0003e2000c901c52ULL,
0x0000000c08007c0cULL, 0x000fc6000bf26070ULL, 0x01c6800002127984ULL, 0x000ea40000000800ULL,
0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL, 0x01ca800012127984ULL, 0x000ea40000000800ULL,
0x0000000b12127c24ULL, 0x004fc8000f8e0260ULL, 0x0000020012147825ULL, 0x002fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014507faeULL, 0x0003e2000c901c52ULL, 0x0000000c09007c0cULL, 0x000fc6000bf26070ULL,
0x01c6900002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e025fULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000144f7faeULL, 0x0003e2000c901c52ULL,
0x0000000c0a007c0cULL, 0x000fc6000bf26070ULL, 0x01c6a00002127984ULL, 0x000ea40000000800ULL,
0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL, 0x01ca800012127984ULL, 0x000ea40000000800ULL,
0x0000000b12127c24ULL, 0x004fc8000f8e025eULL, 0x0000020012147825ULL, 0x002fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000144e7faeULL, 0x0003e2000c901c52ULL, 0x0000000c0b007c0cULL, 0x000fc6000bf26070ULL,
0x01c6b00002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e025dULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000144d7faeULL, 0x0003e2000c901c52ULL,
0x0000000c0c007c0cULL, 0x000fc6000bf26070ULL, 0x01c6c00002127984ULL, 0x000ea40000000800ULL,
0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL, 0x01ca800012127984ULL, 0x000ea40000000800ULL,
0x0000000b12127c24ULL, 0x004fc8000f8e025cULL, 0x0000020012147825ULL, 0x002fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000144c7faeULL, 0x0003e2000c901c52ULL, 0x0000000c0d007c0cULL, 0x000fc6000bf26070ULL,
0x01c6d00002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e025bULL,
0x0000020012147825ULL, 0x002fe200078e0044ULL, 0x0000001848127c11ULL, 0x000fc6000f8e20ffULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014127faeULL, 0x0003e2000c901c52ULL, 0x0000000c0e007c0cULL, 0x000fc6000bf26070ULL,
0x01c6e00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025aULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014467faeULL, 0x0003e2000c901c52ULL,
0x0000000c56007c0cULL, 0x000fc6000bf26070ULL, 0x01c6f00002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e0259ULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140f7faeULL, 0x0003e2000c901c52ULL, 0x0000000800c47947ULL, 0x000fea0003800000ULL,
0x01c6000002127984ULL, 0x000e620000000800ULL, 0x0000001058167812ULL, 0x000fe400078efcffULL,
0x0000001855667c11ULL, 0x000fe4000f8e20ffULL, 0x0000001854657c11ULL, 0x000fe4000f8e20ffULL,
0x0000001853577c11ULL, 0x000fe4000f8e20ffULL, 0x0000001852557c11ULL, 0x000fe4000f8e20ffULL,
0x0000001851547c11ULL, 0x000fc4000f8e20ffULL, 0x0000001850537c11ULL, 0x000fe4000f8e20ffULL,
0x000000184f527c11ULL, 0x000fe4000f8e20ffULL, 0x000000184e517c11ULL, 0x000fe4000f8e20ffULL,
0x000000184d507c11ULL, 0x000fe4000f8e20ffULL, 0x000000184c4f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000184b4e7c11ULL, 0x000fc4000f8e20ffULL, 0x000000184a4d7c11ULL, 0x000fe4000f8e20ffULL,
0x00000018494c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001846467c11ULL, 0x000fe4000f8e20ffULL,
0x000000180f0f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f12127c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000e640000000800ULL, 0x0000000b12127c24ULL, 0x002fc8000f8e026bULL,
0x0000020012147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014667faeULL, 0x0003e8000b901c52ULL,
0x01c6100002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e026aULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014657faeULL, 0x0003e8000b901c52ULL,
0x01c6200002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0269ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014577faeULL, 0x0003e8000b901c52ULL,
0x01c6300002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0267ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014557faeULL, 0x0003e8000b901c52ULL,
0x01c6400002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0264ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014547faeULL, 0x0003e8000b901c52ULL,
0x01c6500002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0263ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014537faeULL, 0x0003e8000b901c52ULL,
0x01c6600002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0262ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014527faeULL, 0x0003e8000b901c52ULL,
0x01c6700002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0261ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014517faeULL, 0x0003e8000b901c52ULL,
0x01c6800002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e0260ULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014507faeULL, 0x0003e8000b901c52ULL,
0x01c6900002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e025fULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000144f7faeULL, 0x0003e8000b901c52ULL,
0x01c6a00002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e025eULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000144e7faeULL, 0x0003e8000b901c52ULL,
0x01c6b00002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e025dULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000144d7faeULL, 0x0003e8000b901c52ULL,
0x01c6c00002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e025cULL,
0x0000020012147825ULL, 0x002fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000144c7faeULL, 0x0003e8000b901c52ULL,
0x01c6d00002127984ULL, 0x000ea40000000800ULL, 0x0000001f12127c11ULL, 0x004fcc000f8e10ffULL,
0x01ca800012127984ULL, 0x000ea40000000800ULL, 0x0000000b12127c24ULL, 0x004fc8000f8e025bULL,
0x0000020012147825ULL, 0x002fe200078e0044ULL, 0x0000001848127c11ULL, 0x000fc6000f8e20ffULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014127faeULL, 0x0003e8000b901c52ULL, 0x01c6e00002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e025aULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014467faeULL, 0x0003e8000b901c52ULL, 0x01c6f00002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e0259ULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140f7faeULL, 0x0003e4000b901c52ULL, 0x0000000811147836ULL, 0x002fe20000000000ULL,
0x00000c00014b7983ULL, 0x000ea20000300800ULL, 0x0000002010157824ULL, 0x000fe200078e00ffULL,
0x0000001e7c307c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0xffffffe015147812ULL, 0x000fe200078ee214ULL, 0x00000800014a7983ULL, 0x000ee60000300800ULL,
0x0000000814147c11ULL, 0x000fe2000f8e20ffULL, 0x0000100001497983ULL, 0x000f280000300800ULL,
0x00000400017c7983ULL, 0x000f680000300800ULL, 0x0000303001007387ULL, 0x000fe80000100800ULL,
0x000000001414783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000e680000000200ULL,
0x0000140001487983ULL, 0x000f620000300800ULL, 0x0000001e38387c11ULL, 0x000fc4000f8e20ffULL,
0x0000001e35357c11ULL, 0x000fe2000f8e20ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000301418723cULL, 0x002fec0000001818ULL, 0x000000321420723cULL, 0x000fe20000001820ULL,
0x0000001e7d317c11ULL, 0x000fe4000f8e20ffULL, 0x00000000017d7983ULL, 0x000f620000300800ULL,
0x0000001e34347c11ULL, 0x000fe2000f8e20ffULL, 0x00000003040c7892ULL, 0x000fe2000f8ec03fULL,
0x0000001e68687c11ULL, 0x000fe2000f8e20ffULL, 0x00002c3101007387ULL, 0x000fe40000100800ULL,
0x0000003f0c0c7287ULL, 0x000fc4000c000000ULL, 0x000000003130783bULL, 0x000e640000000200ULL,
0x000000301440723cULL, 0x002fec0000001840ULL, 0x00000032143c723cULL, 0x000fe2000000183cULL,
0x0000001e4b4b7c11ULL, 0x004fe4000f8e20ffULL, 0x0000001e4a4a7c11ULL, 0x008fc4000f8e20ffULL,
0x0000001e49497c11ULL, 0x010fe4000f8e20ffULL, 0x0000001e7c7c7c11ULL, 0x020fe4000f8e20ffULL,
0x0000001e48487c11ULL, 0x000fe4000f8e20ffULL, 0x0000001e7d7d7c11ULL, 0x000fca000f8e20ffULL,
0x000000007d30783bULL, 0x000e680000000200ULL, 0x0000287d01007387ULL, 0x0005e80000100800ULL,
0x0000247c01007387ULL, 0x000fe80000100800ULL, 0x0000204b01007387ULL, 0x000fe20000100800ULL,
0x0000001e367d7c11ULL, 0x004fc6000f8e20ffULL, 0x00001c4a01007387ULL, 0x000fe80000100800ULL,
0x0000184901007387ULL, 0x000fe80000100800ULL, 0x0000144801007387ULL, 0x000fe80000100800ULL,
0x0000103801007387ULL, 0x000fe20000100800ULL, 0x000000301424723cULL, 0x002fec0000001824ULL,
0x000000321428723cULL, 0x000fe20000001828ULL, 0x000000007c30783bULL, 0x0002a40000000200ULL,
0x0000001e377c7c11ULL, 0x002fc6000f8e20ffULL, 0x00000030141c723cULL, 0x004fec000000181cULL,
0x00000032142c723cULL, 0x000fe2000000182cULL, 0x000000004b30783bULL, 0x000fec0000000200ULL,
0x0000000a11147836ULL, 0x000fc40000000000ULL, 0x0000002010157824ULL, 0x000fca00078e00ffULL,
0xffffffe015147812ULL, 0x000fc800078ee214ULL, 0x0000000814147c11ULL, 0x000fcc000f8e20ffULL,
0x000000001414783bULL, 0x000e640000000200ULL, 0x000000301418723cULL, 0x002fec0000001818ULL,
0x000000321420723cULL, 0x000fe20000001820ULL, 0x000000004a30783bULL, 0x000e6a0000000200ULL,
0x000000301440723cULL, 0x002fec0000001840ULL, 0x00000032143c723cULL, 0x000fe2000000183cULL,
0x000000004930783bULL, 0x000e6a0000000200ULL, 0x000000301424723cULL, 0x002fec0000001824ULL,
0x000000321428723cULL, 0x000fe20000001828ULL, 0x000000004830783bULL, 0x000e6a0000000200ULL,
0x00000030141c723cULL, 0x002fec000000181cULL, 0x00000032142c723cULL, 0x000fe2000000182cULL,
0x000000003830783bULL, 0x0003ec0000000200ULL, 0x0000000c11147836ULL, 0x000fc40000000000ULL,
0x0000002010157824ULL, 0x000fe200078e00ffULL, 0x0000001e3a387c11ULL, 0x002fc8000f8e20ffULL,
0xffffffe015147812ULL, 0x000fe200078ee214ULL, 0x00000c3801007387ULL, 0x000fe60000100800ULL,
0x0000000814147c11ULL, 0x000fcc000f8e20ffULL, 0x000000001414783bULL, 0x000e640000000200ULL,
0x000000301418723cULL, 0x002fec0000001818ULL, 0x000000321420723cULL, 0x000fe20000001820ULL,
0x000000003830783bULL, 0x0002a40000000200ULL, 0x0000001e39387c11ULL, 0x002fca000f8e20ffULL,
0x0000083801007387ULL, 0x000fe80000100800ULL, 0x0000043501007387ULL, 0x000fe80000100800ULL,
0x0000003401007387ULL, 0x000fe20000100800ULL, 0x000000301440723cULL, 0x004fec0000001840ULL,
0x00000032143c723cULL, 0x000fe2000000183cULL, 0x000000003830783bULL, 0x000e6a0000000200ULL,
0x000000301424723cULL, 0x002fec0000001824ULL, 0x000000321428723cULL, 0x000fe20000001828ULL,
0x000000003530783bULL, 0x000e6a0000000200ULL, 0x00000030141c723cULL, 0x002fec000000181cULL,
0x00000032142c723cULL, 0x000fe2000000182cULL, 0x000000003430783bULL, 0x000fec0000000200ULL,
0x0000002010157824ULL, 0x000fe200078e00ffULL, 0x0000000e11147810ULL, 0x000fc80007ffe0ffULL,
0xffffffe015147812ULL, 0x000fc800078ee214ULL, 0x0000000814147c11ULL, 0x000fcc000f8e20ffULL,
0x000000001414783bULL, 0x000e640000000200ULL, 0x000000301418723cULL, 0x002fec0000001818ULL,
0x000000321420723cULL, 0x000fe20000001820ULL, 0x000000007d30783bULL, 0x000e6a0000000200ULL,
0x000000301440723cULL, 0x002fec0000001840ULL, 0x00000032143c723cULL, 0x000fe2000000183cULL,
0x000000007c30783bULL, 0x000e6a0000000200ULL, 0x000000301424723cULL, 0x002fec0000001824ULL,
0x000000321428723cULL, 0x000fe20000001828ULL, 0x000000006830783bULL, 0x000e620000000200ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000030141c723cULL, 0x002fec000000181cULL,
0x00000032142c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000800d48947ULL, 0x000fde0003800000ULL,
0x01c6000002147984ULL, 0x000e620000000800ULL, 0x0000000d1a00728cULL, 0x000fe2000bf21070ULL,
0x0000001858167812ULL, 0x000fc600078efcffULL, 0x0000000d1a117287ULL, 0x000fc8000c800000ULL,
0x000000110d117290ULL, 0x000fcc000fffe13fULL, 0x0000001100007c0cULL, 0x000fe4000bf06070ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e026bULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000146c7faeULL, 0x0003e2000c101c52ULL, 0x0000001147007c0cULL, 0x000fc6000bf06070ULL,
0x01c6100002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e026aULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000146d7faeULL, 0x0003e2000c101c52ULL,
0x0000001113007c0cULL, 0x000fc6000bf06070ULL, 0x01c6200002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e0269ULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000146e7faeULL, 0x0003e2000c101c52ULL, 0x0000001103007c0cULL, 0x000fc6000bf06070ULL,
0x01c6300002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0267ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000146f7faeULL, 0x0003e2000c101c52ULL,
0x0000001104007c0cULL, 0x000fc6000bf06070ULL, 0x01c6400002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e0264ULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014717faeULL, 0x0003e2000c101c52ULL, 0x0000001105007c0cULL, 0x000fc6000bf06070ULL,
0x01c6500002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0263ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014737faeULL, 0x0003e2000c101c52ULL,
0x0000001106007c0cULL, 0x000fc6000bf06070ULL, 0x01c6600002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e0262ULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014757faeULL, 0x0003e2000c101c52ULL, 0x0000001107007c0cULL, 0x000fc6000bf06070ULL,
0x01c6700002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0261ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014747faeULL, 0x0003e2000c101c52ULL,
0x0000001108007c0cULL, 0x000fc6000bf06070ULL, 0x01c6800002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e0260ULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014777faeULL, 0x0003e2000c101c52ULL, 0x0000001109007c0cULL, 0x000fc6000bf06070ULL,
0x01c6900002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025fULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014797faeULL, 0x0003e2000c101c52ULL,
0x000000110a007c0cULL, 0x000fc6000bf06070ULL, 0x01c6a00002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e025eULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000147b7faeULL, 0x0003e2000c101c52ULL, 0x000000110b007c0cULL, 0x000fc6000bf06070ULL,
0x01c6b00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025dULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000147a7faeULL, 0x0003e2000c101c52ULL,
0x000000110c007c0cULL, 0x000fc6000bf06070ULL, 0x01c6c00002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e025cULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014787faeULL, 0x0003e2000c101c52ULL, 0x000000110d007c0cULL, 0x000fc6000bf06070ULL,
0x01c6d00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025bULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014767faeULL, 0x0003e2000c101c52ULL,
0x000000110e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6e00002147984ULL, 0x002e640000000800ULL,
0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL, 0x01ca800014147984ULL, 0x000e640000000800ULL,
0x0000000b14147c24ULL, 0x002fc8000f8e025aULL, 0x0000020014147825ULL, 0x000fc800078e0044ULL,
0x0000001016147825ULL, 0x000fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014727faeULL, 0x0003e2000c101c52ULL, 0x0000001156007c0cULL, 0x000fc6000bf06070ULL,
0x01c6f00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0259ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014707faeULL, 0x0003e2000c101c52ULL,
0x0000000800847947ULL, 0x000fea0003800000ULL, 0x01c6000002147984ULL, 0x000e620000000800ULL,
0x0000001858167812ULL, 0x000fe400078efcffULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e026bULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000146c7faeULL, 0x0003e8000b901c52ULL,
0x01c6100002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e026aULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000146d7faeULL, 0x0003e8000b901c52ULL,
0x01c6200002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0269ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000146e7faeULL, 0x0003e8000b901c52ULL,
0x01c6300002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0267ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000146f7faeULL, 0x0003e8000b901c52ULL,
0x01c6400002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0264ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014717faeULL, 0x0003e8000b901c52ULL,
0x01c6500002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0263ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014737faeULL, 0x0003e8000b901c52ULL,
0x01c6600002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0262ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014757faeULL, 0x0003e8000b901c52ULL,
0x01c6700002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0261ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014747faeULL, 0x0003e8000b901c52ULL,
0x01c6800002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0260ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014777faeULL, 0x0003e8000b901c52ULL,
0x01c6900002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025fULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014797faeULL, 0x0003e8000b901c52ULL,
0x01c6a00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025eULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000147b7faeULL, 0x0003e8000b901c52ULL,
0x01c6b00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025dULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000147a7faeULL, 0x0003e8000b901c52ULL,
0x01c6c00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025cULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014787faeULL, 0x0003e8000b901c52ULL,
0x01c6d00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025bULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014767faeULL, 0x0003e8000b901c52ULL,
0x01c6e00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e025aULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014727faeULL, 0x0003e8000b901c52ULL,
0x01c6f00002147984ULL, 0x002e640000000800ULL, 0x0000001f14147c11ULL, 0x002fcc000f8e10ffULL,
0x01ca800014147984ULL, 0x000e640000000800ULL, 0x0000000b14147c24ULL, 0x002fc8000f8e0259ULL,
0x0000020014147825ULL, 0x000fc800078e0044ULL, 0x0000001016147825ULL, 0x000fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014707faeULL, 0x0003e4000b901c52ULL,
0x000000100700728cULL, 0x000fe2000bf24070ULL, 0x0000000cff147e24ULL, 0x002fe2000f8e00ffULL,
0x00000000005a7919ULL, 0x000e620000000000ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x000000031400780cULL, 0x000fe40003f25270ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000508947ULL, 0x000fea0000800000ULL, 0x000000035a00780cULL, 0x002fe20003f04070ULL,
0x0000000a160a7291ULL, 0x000fe2000f8e083fULL, 0x0000011000007945ULL, 0x000ff60003800000ULL,
0x00000000003c0947ULL, 0x000fea0003800000ULL, 0x0000000000307919ULL, 0x000e620000000000ULL,
0x00008c00ff167b82ULL, 0x000ea20000000a00ULL, 0x000000060a00728cULL, 0x000fe2000bf26070ULL,
0x0000001cff147e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000157919ULL, 0x000e680000002700ULL,
0x000000000000781cULL, 0x000fe20003f0f018ULL, 0x0000000415157824ULL, 0x002fc800078e0230ULL,
0x0000000215157824ULL, 0x000fc800078e00ffULL, 0x0000000a15147e24ULL, 0x000fc8000f8e0214ULL,
0x0000000414147825ULL, 0x004fe200078e0016ULL, 0x0000001f5a167c11ULL, 0x000fca000f8e10ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1ca8000014167faeULL, 0x0003e4000c121852ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000380001327983ULL, 0x000ea20000300800ULL,
0x000000010c0c7890ULL, 0x000fe2000fffe03fULL, 0x00009200ff307b82ULL, 0x000ee40000000a00ULL,
0x00004c0001377983ULL, 0x000f280000300800ULL, 0x0000540001367983ULL, 0x000f680000300800ULL,
0x00005c0001357983ULL, 0x000f280000300800ULL, 0x00006c0001347983ULL, 0x000f280000300800ULL,
0x0000580001487983ULL, 0x000f220000300800ULL, 0x000000100700728cULL, 0x000fc4000bf24070ULL,
0x000000023f0d7899ULL, 0x000fe2000801160cULL, 0x000000025a597819ULL, 0x002fe200000006ffULL,
0x000000205a177836ULL, 0x000fe20000000000ULL, 0x00006400013a7983ULL, 0x000f220000300800ULL,
0x000000010d0d7887ULL, 0x000fe4000c800000ULL, 0x000000030c0c7892ULL, 0x000fe2000f8ec03fULL,
0x0000001759167c36ULL, 0x000fe20008000000ULL, 0x000000160d0d72a4ULL, 0x000fe2000f8e0210ULL,
0x0000680001397983ULL, 0x000f220000300800ULL, 0x0000003f0c0c7287ULL, 0x000fc4000c800000ULL,
0x000000140d0d7291ULL, 0x000fe2000f8e403fULL, 0x0000600001387983ULL, 0x000f220000300800ULL,
0x0000000c1b0c7290ULL, 0x000fc6000fffe03fULL, 0x00005000015c7983ULL, 0x000f220000300800ULL,
0x0000000d5a147c36ULL, 0x000fe20008000000ULL, 0x0000001d0c0c72a4ULL, 0x000fe4000f8e020dULL,
0x00004000015b7983ULL, 0x000f240000300800ULL, 0x0000001a14007c0cULL, 0x000fe4000bf06070ULL,
0x0000000c5a147c36ULL, 0x000fe20008000000ULL, 0x00004800014b7983ULL, 0x000f660000300800ULL,
0x0000000414147825ULL, 0x008fe200078e0030ULL, 0x00004400014a7983ULL, 0x000ee80000300800ULL,
0x00003c0001497983ULL, 0x000ee80000300800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1c60000014167faeULL, 0x0003e4000c121852ULL, 0x0000000c17147c36ULL, 0x002fc40008000000ULL,
0x0000000d17177c36ULL, 0x000fe40008000000ULL, 0x0000000414147825ULL, 0x000fc600078e0030ULL,
0x0000001a17007c0cULL, 0x000fda000bf06070ULL, 0x1c68000014167faeULL, 0x0003e2000c121852ULL,
0x00000001040d7890ULL, 0x000fc6000fffe03fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001011147836ULL, 0x002fe20000000000ULL, 0x0000000510157819ULL, 0x000fc800000006ffULL,
0xffffffe015147812ULL, 0x000fc800078ee214ULL, 0x0000000814147c11ULL, 0x000fcc000f8e20ffULL,
0x000000001414783bULL, 0x000fe80000000200ULL, 0x000000003230783bULL, 0x004e640000000200ULL,
0x000000301418723cULL, 0x002fec0000001818ULL, 0x000000321420723cULL, 0x000fe20000001820ULL,
0x000000003730783bULL, 0x010e6a0000000200ULL, 0x000000301440723cULL, 0x002fec0000001840ULL,
0x00000032143c723cULL, 0x000fe2000000183cULL, 0x000000003630783bULL, 0x020e6a0000000200ULL,
0x000000301424723cULL, 0x002fec0000001824ULL, 0x000000321428723cULL, 0x000fe20000001828ULL,
0x000000003530783bULL, 0x000e680000000200ULL, 0x000000003434783bULL, 0x000fe20000000200ULL,
0x00000030141c723cULL, 0x002fec000000181cULL, 0x00000032142c723cULL, 0x000fe2000000182cULL,
0x000000004830783bULL, 0x0003e80000000200ULL, 0x0000340001487983ULL, 0x002ea40000300800ULL,
0x0000001211147836ULL, 0x000fc40000000000ULL, 0x0000002010157824ULL, 0x000fca00078e00ffULL,
0xffffffe015147812ULL, 0x000fc800078ee214ULL, 0x0000000814147c11ULL, 0x000fcc000f8e20ffULL,
0x000000001414783bULL, 0x000e640000000200ULL, 0x000000341418723cULL, 0x002fec0000001818ULL,
0x000000361420723cULL, 0x000fe20000001820ULL, 0x000000003a34783bULL, 0x000e6a0000000200ULL,
0x000000301440723cULL, 0x000fec0000001840ULL, 0x00000032143c723cULL, 0x000fe2000000183cULL,
0x000000003930783bULL, 0x000f2a0000000200ULL, 0x000000341424723cULL, 0x002fec0000001824ULL,
0x000000361428723cULL, 0x000fe20000001828ULL, 0x000000005b34783bULL, 0x000fea0000000200ULL,
0x00000030141c723cULL, 0x010fec000000181cULL, 0x00000032142c723cULL, 0x000fe2000000182cULL,
0x000000003b30783bULL, 0x000fe80000000200ULL, 0x000000003838783bULL, 0x000fe40000000200ULL,
0x0000001411147836ULL, 0x000fc40000000000ULL, 0x0000002010157824ULL, 0x000fca00078e00ffULL,
0xffffffe015147812ULL, 0x000fc800078ee214ULL, 0x0000000814147c11ULL, 0x000fcc000f8e20ffULL,
0x000000001414783bULL, 0x000e640000000200ULL, 0x000000301418723cULL, 0x002fec0000001818ULL,
0x000000321430723cULL, 0x000fe20000001820ULL, 0x000000005c20783bULL, 0x000e6a0000000200ULL,
0x000000381440723cULL, 0x000fec0000001840ULL, 0x0000003a143c723cULL, 0x000fe2000000183cULL,
0x000000004938783bULL, 0x008fea0000000200ULL, 0x00000034141c723cULL, 0x000fec000000181cULL,
0x00000036142c723cULL, 0x000fe2000000182cULL, 0x000000004a34783bULL, 0x000fea0000000200ULL,
0x000000201424723cULL, 0x002fee0000001824ULL, 0x0000001611207836ULL, 0x000fc40000000000ULL,
0x0000002010217824ULL, 0x000fca00078e00ffULL, 0xffffffe021207812ULL, 0x000fc800078ee220ULL,
0x0000000820207c11ULL, 0x000fe2000f8e20ffULL, 0x000000221428723cULL, 0x000fe20000001828ULL,
0x000000004b14783bULL, 0x000fe80000000200ULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000000023f0c7899ULL, 0x000fc8000801160dULL, 0x0000000c0d0c7287ULL, 0x000fc80008000000ULL,
0x000000160c0c72a4ULL, 0x000fc8000f8e0219ULL, 0x000000010c117890ULL, 0x000fc8000fffe03fULL,
0x000000051100728cULL, 0x000fe2000bf26070ULL, 0x000000004848783bULL, 0x004eaa0000000200ULL,
0x000000000000781cULL, 0x000fe20003f0f018ULL, 0x000000140c107291ULL, 0x000fe2000f8e403fULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000040100c7892ULL, 0x000fe2000f8ec03fULL,
0x000000142018723cULL, 0x002fe60000001818ULL, 0x0000000c09117290ULL, 0x000fc6000fffe03fULL,
0x000000162030723cULL, 0x000fec0000001830ULL, 0x000000342040723cULL, 0x000fec0000001840ULL,
0x00000036203c723cULL, 0x000fec000000183cULL, 0x000000382024723cULL, 0x000fec0000001824ULL,
0x0000003a2028723cULL, 0x000fec0000001828ULL, 0x00000048201c723cULL, 0x004fec000000181cULL,
0x0000004a202c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000c00588947ULL, 0x000fde0003800000ULL,
0x01c6000002147984ULL, 0x000e620000000800ULL, 0x0000001100157c10ULL, 0x000fe2000fffe0ffULL,
0x000000105a167824ULL, 0x000fe200078e00ffULL, 0x000000101a00728cULL, 0x000fe2000bf21070ULL,
0x0000001147207c36ULL, 0x000fc60008000000ULL, 0x000000101a0c7287ULL, 0x000fe2000c800000ULL,
0x0000007016167812ULL, 0x000fc600078ec0ffULL, 0x0000000c100c7290ULL, 0x000fe2000fffe13fULL,
0x0000001f14177c11ULL, 0x002fca000f8e10ffULL, 0x01ca800017147984ULL, 0x000e640000000800ULL,
0x0000000b14157c24ULL, 0x002fc8000f8e0215ULL, 0x0000020015147825ULL, 0x000fc600078e0044ULL,
0x0000001416147210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000000c00007c0cULL, 0x000fda000bf06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014667faeULL, 0x0003e2000c101c52ULL, 0x0000000c47007c0cULL, 0x000fc6000bf06070ULL,
0x01c6100002177984ULL, 0x000ea40000000800ULL, 0x0000001f17217c11ULL, 0x004fca000f8e10ffULL,
0x01ca800021177984ULL, 0x000ea40000000800ULL, 0x0000000b17177c24ULL, 0x004fe4000f8e0220ULL,
0x0000001113207c36ULL, 0x000fe40008000000ULL, 0x0000020017147825ULL, 0x002fc600078e0044ULL,
0x0000001416147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014657faeULL, 0x0003e2000c101c52ULL,
0x0000000c13007c0cULL, 0x000fc6000bf06070ULL, 0x01c6200002177984ULL, 0x000ea40000000800ULL,
0x0000001f17227c11ULL, 0x004fca000f8e10ffULL, 0x01ca800022177984ULL, 0x000ea40000000800ULL,
0x0000000b17177c24ULL, 0x004fe2000f8e0220ULL, 0x0000001103207c10ULL, 0x000fc6000fffe0ffULL,
0x0000020017147825ULL, 0x002fc600078e0044ULL, 0x0000001416147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014577faeULL, 0x0003e2000c101c52ULL, 0x0000000c03007c0cULL, 0x000fc6000bf06070ULL,
0x01c6300002137984ULL, 0x000ea40000000800ULL, 0x0000001f13177c11ULL, 0x004fca000f8e10ffULL,
0x01ca800017137984ULL, 0x000ea40000000800ULL, 0x0000000b13137c24ULL, 0x004fe4000f8e0220ULL,
0x0000001104207c36ULL, 0x000fe40008000000ULL, 0x0000020013147825ULL, 0x002fc600078e0044ULL,
0x0000001416147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014557faeULL, 0x0003e2000c101c52ULL,
0x0000000c04007c0cULL, 0x000fe2000bf06070ULL, 0x0000001105047c36ULL, 0x000fe40008000000ULL,
0x01c6400002037984ULL, 0x000ea40000000800ULL, 0x0000001f03137c11ULL, 0x004fca000f8e10ffULL,
0x01ca800013037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fc8000f8e0220ULL,
0x0000020003147825ULL, 0x002fc600078e0044ULL, 0x0000001416147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014547faeULL, 0x0003e2000c101c52ULL, 0x0000000c05007c0cULL, 0x000fc6000bf06070ULL,
0x01c6500002037984ULL, 0x000ea40000000800ULL, 0x0000001f03177c11ULL, 0x004fca000f8e10ffULL,
0x01ca800017037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fc8000f8e0204ULL,
0x0000020003147825ULL, 0x002fc600078e0044ULL, 0x0000001416047210ULL, 0x000fe20007f3e0ffULL,
0x0000001106147c36ULL, 0x000fc80008000000ULL, 0x000000ffff057224ULL, 0x000fca00008e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004537faeULL, 0x0003e2000c101c52ULL,
0x0000000c06007c0cULL, 0x000fe2000bf06070ULL, 0x0000001107067c36ULL, 0x000fe40008000000ULL,
0x01c6600002037984ULL, 0x000ea40000000800ULL, 0x0000001f03137c11ULL, 0x004fca000f8e10ffULL,
0x01ca800013037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fc8000f8e0214ULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fc80007f3e0ffULL,
0x00000005ff057210ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004527faeULL, 0x0003e2000c101c52ULL, 0x0000000c07007c0cULL, 0x000fc6000bf06070ULL,
0x01c6700002037984ULL, 0x000ea40000000800ULL, 0x0000001f03147c11ULL, 0x004fca000f8e10ffULL,
0x01ca800014037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fe4000f8e0206ULL,
0x0000001108067c36ULL, 0x000fe40008000000ULL, 0x0000020003047825ULL, 0x002fc600078e0044ULL,
0x0000000416047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004517faeULL, 0x0003e2000c101c52ULL,
0x0000000c08007c0cULL, 0x000fc6000bf06070ULL, 0x01c6800002037984ULL, 0x000ea40000000800ULL,
0x0000001f03077c11ULL, 0x004fca000f8e10ffULL, 0x01ca800007037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fe4000f8e0206ULL, 0x0000001109067c36ULL, 0x000fe40008000000ULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004507faeULL, 0x0003e2000c101c52ULL, 0x0000000c09007c0cULL, 0x000fc6000bf06070ULL,
0x01c6900002037984ULL, 0x000ea40000000800ULL, 0x0000001f03087c11ULL, 0x004fca000f8e10ffULL,
0x01ca800008037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fe2000f8e0206ULL,
0x000000110a067c10ULL, 0x000fc6000fffe0ffULL, 0x0000020003047825ULL, 0x002fc600078e0044ULL,
0x0000000416047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000044f7faeULL, 0x0003e2000c101c52ULL,
0x0000000c0a007c0cULL, 0x000fc6000bf06070ULL, 0x01c6a00002037984ULL, 0x000ea40000000800ULL,
0x0000001f03077c11ULL, 0x004fca000f8e10ffULL, 0x01ca800007037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fe4000f8e0206ULL, 0x000000110b067c36ULL, 0x000fe40008000000ULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000044e7faeULL, 0x0003e2000c101c52ULL, 0x0000000c0b007c0cULL, 0x000fc6000bf06070ULL,
0x01c6b00002037984ULL, 0x000ea40000000800ULL, 0x0000001f03087c11ULL, 0x004fca000f8e10ffULL,
0x01ca800008037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fe4000f8e0206ULL,
0x000000110c067c36ULL, 0x000fe40008000000ULL, 0x0000020003047825ULL, 0x002fc600078e0044ULL,
0x0000000416047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000044d7faeULL, 0x0003e2000c101c52ULL,
0x0000000c0c007c0cULL, 0x000fc6000bf06070ULL, 0x01c6c00002037984ULL, 0x000ea40000000800ULL,
0x0000001f03077c11ULL, 0x004fca000f8e10ffULL, 0x01ca800007037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fe4000f8e0206ULL, 0x000000110d067c36ULL, 0x000fe40008000000ULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000044c7faeULL, 0x0003e2000c101c52ULL, 0x0000000c0d007c0cULL, 0x000fc6000bf06070ULL,
0x01c6d00002037984ULL, 0x000ea40000000800ULL, 0x0000001f03087c11ULL, 0x004fca000f8e10ffULL,
0x01ca800008037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fe4000f8e0206ULL,
0x000000110e067c36ULL, 0x000fe40008000000ULL, 0x0000020003047825ULL, 0x002fc600078e0044ULL,
0x0000000416047210ULL, 0x000fc80007f3e0ffULL, 0x00000005ff057210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004127faeULL, 0x0003e2000c101c52ULL,
0x0000000c0e007c0cULL, 0x000fc6000bf06070ULL, 0x01c6e00002037984ULL, 0x000ea40000000800ULL,
0x0000001f03077c11ULL, 0x004fca000f8e10ffULL, 0x01ca800007037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fe4000f8e0206ULL, 0x0000001156067c36ULL, 0x000fe40008000000ULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004467faeULL, 0x0003e2000c101c52ULL, 0x0000000c56007c0cULL, 0x000fc6000bf06070ULL,
0x01c6f00002037984ULL, 0x000ea40000000800ULL, 0x0000001f03087c11ULL, 0x004fca000f8e10ffULL,
0x01ca800008037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fc8000f8e0206ULL,
0x0000020003447825ULL, 0x000fc600078e0044ULL, 0x0000004416167210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff177224ULL, 0x000fca00008e0645ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000160f7faeULL, 0x0003e2000c101c52ULL, 0x0000000c00087947ULL, 0x000fea0003800000ULL,
0x01c6000002147984ULL, 0x000e620000000800ULL, 0x0000001100157c36ULL, 0x000fe20008000000ULL,
0x0000001104047c10ULL, 0x000fe2000fffe0ffULL, 0x000000105a167824ULL, 0x000fe400078e00ffULL,
0x0000001113227c36ULL, 0x000fe40008000000ULL, 0x0000001106067c36ULL, 0x000fe20008000000ULL,
0x0000007016167812ULL, 0x000fe200078ec0ffULL, 0x0000001108087c36ULL, 0x000fe40008000000ULL,
0x000000110a0a7c36ULL, 0x000fc40008000000ULL, 0x000000110c0c7c36ULL, 0x000fe40008000000ULL,
0x000000110e0e7c36ULL, 0x000fe40008000000ULL, 0x0000001156567c36ULL, 0x000fe20008000000ULL,
0x0000001f14207c11ULL, 0x002fca000f8e10ffULL, 0x01ca800020147984ULL, 0x0002a40000000800ULL,
0x0000001147207c36ULL, 0x002fe40008000000ULL, 0x0000000b14157c24ULL, 0x004fc8000f8e0215ULL,
0x0000020015147825ULL, 0x000fc600078e0044ULL, 0x0000001416147210ULL, 0x000fc80007f1e0ffULL,
0x00000015ff157210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014667faeULL, 0x0003e8000b901c52ULL, 0x01c6100002177984ULL, 0x000ea40000000800ULL,
0x0000001f17217c11ULL, 0x004fca000f8e10ffULL, 0x01ca800021177984ULL, 0x000ea40000000800ULL,
0x0000000b17177c24ULL, 0x004fc8000f8e0220ULL, 0x0000020017147825ULL, 0x002fc600078e0044ULL,
0x0000001416147210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014657faeULL, 0x0003e8000b901c52ULL,
0x01c6200002177984ULL, 0x000ea40000000800ULL, 0x0000001f17207c11ULL, 0x004fca000f8e10ffULL,
0x01ca800020177984ULL, 0x000ea40000000800ULL, 0x0000000b17177c24ULL, 0x004fe4000f8e0222ULL,
0x0000001103227c36ULL, 0x000fe40008000000ULL, 0x0000020017147825ULL, 0x002fc600078e0044ULL,
0x0000001416147210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014577faeULL, 0x0003e8000b901c52ULL,
0x01c6300002137984ULL, 0x000ea40000000800ULL, 0x0000001f13177c11ULL, 0x004fca000f8e10ffULL,
0x01ca800017137984ULL, 0x000ea40000000800ULL, 0x0000000b13137c24ULL, 0x004fc8000f8e0222ULL,
0x0000020013147825ULL, 0x002fc600078e0044ULL, 0x0000001416147210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014557faeULL, 0x0003e8000b901c52ULL, 0x01c6400002037984ULL, 0x000ea40000000800ULL,
0x0000001f03137c11ULL, 0x004fca000f8e10ffULL, 0x01ca800013037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fe4000f8e0204ULL, 0x0000001105047c36ULL, 0x000fe40008000000ULL,
0x0000020003147825ULL, 0x002fc600078e0044ULL, 0x0000001416147210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014547faeULL, 0x0003e8000b901c52ULL, 0x01c6500002037984ULL, 0x000ea20000000800ULL,
0x0000001107147c36ULL, 0x002fe20008000000ULL, 0x0000001f03177c11ULL, 0x004fca000f8e10ffULL,
0x01ca800017037984ULL, 0x000e640000000800ULL, 0x0000000b03037c24ULL, 0x002fc8000f8e0204ULL,
0x0000020003047825ULL, 0x000fc600078e0044ULL, 0x0000000416047210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004537faeULL, 0x0003e8000b901c52ULL, 0x01c6600002037984ULL, 0x000ea40000000800ULL,
0x0000001f03137c11ULL, 0x004fca000f8e10ffULL, 0x01ca800013037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fc8000f8e0206ULL, 0x0000020003047825ULL, 0x002fc600078e0044ULL,
0x0000000416047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004527faeULL, 0x0003e8000b901c52ULL,
0x01c6700002037984ULL, 0x000ea40000000800ULL, 0x0000001f03067c11ULL, 0x004fca000f8e10ffULL,
0x01ca800006037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fc8000f8e0214ULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fc80007f1e0ffULL,
0x00000005ff057210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004517faeULL, 0x0003e8000b901c52ULL, 0x01c6800002037984ULL, 0x000ea40000000800ULL,
0x0000001f03077c11ULL, 0x004fca000f8e10ffULL, 0x01ca800007037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fe4000f8e0208ULL, 0x0000001109087c36ULL, 0x000fe40008000000ULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004507faeULL, 0x0003e8000b901c52ULL, 0x01c6900002037984ULL, 0x000ea40000000800ULL,
0x0000001f03067c11ULL, 0x004fca000f8e10ffULL, 0x01ca800006037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fe2000f8e0208ULL, 0x000000110b087c10ULL, 0x000fc6000fffe0ffULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000044f7faeULL, 0x0003e8000b901c52ULL, 0x01c6a00002037984ULL, 0x000ea40000000800ULL,
0x0000001f03077c11ULL, 0x004fca000f8e10ffULL, 0x01ca800007037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fc8000f8e020aULL, 0x0000020003047825ULL, 0x002fc600078e0044ULL,
0x0000000416047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000044e7faeULL, 0x0003e8000b901c52ULL,
0x01c6b00002037984ULL, 0x000ea40000000800ULL, 0x0000001f03067c11ULL, 0x004fca000f8e10ffULL,
0x01ca800006037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fe4000f8e0208ULL,
0x000000110d087c36ULL, 0x000fe40008000000ULL, 0x0000020003047825ULL, 0x002fc600078e0044ULL,
0x0000000416047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000044d7faeULL, 0x0003e8000b901c52ULL,
0x01c6c00002037984ULL, 0x000ea40000000800ULL, 0x0000001f03077c11ULL, 0x004fca000f8e10ffULL,
0x01ca800007037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fc8000f8e020cULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000044c7faeULL, 0x0003e8000b901c52ULL, 0x01c6d00002037984ULL, 0x000ea40000000800ULL,
0x0000001f03067c11ULL, 0x004fca000f8e10ffULL, 0x01ca800006037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fc8000f8e0208ULL, 0x0000020003047825ULL, 0x002fc600078e0044ULL,
0x0000000416047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004127faeULL, 0x0003e8000b901c52ULL,
0x01c6e00002037984ULL, 0x000ea40000000800ULL, 0x0000001f03077c11ULL, 0x004fca000f8e10ffULL,
0x01ca800007037984ULL, 0x000ea40000000800ULL, 0x0000000b03037c24ULL, 0x004fc8000f8e020eULL,
0x0000020003047825ULL, 0x002fc600078e0044ULL, 0x0000000416047210ULL, 0x000fc80007f1e0ffULL,
0x00000005ff057210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004467faeULL, 0x0003e8000b901c52ULL, 0x01c6f00002037984ULL, 0x000ea40000000800ULL,
0x0000001f03067c11ULL, 0x004fca000f8e10ffULL, 0x01ca800006037984ULL, 0x000ea40000000800ULL,
0x0000000b03037c24ULL, 0x004fc8000f8e0256ULL, 0x0000020003447825ULL, 0x000fc600078e0044ULL,
0x0000004416167210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff177224ULL, 0x000fca00000e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000160f7faeULL, 0x0003e6000b901c52ULL,
0x0000300001047983ULL, 0x002ea20000300800ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00002c00010c7983ULL, 0x000ee80000300800ULL, 0x0000280001127983ULL, 0x000f280000300800ULL,
0x0000240001207983ULL, 0x000f680000300800ULL, 0x0000200001137983ULL, 0x000f680000300800ULL,
0x00001c0001447983ULL, 0x000f680000300800ULL, 0x00001800014d7983ULL, 0x000f680000300800ULL,
0x00001400014b7983ULL, 0x000f620000300800ULL, 0x0000001811027836ULL, 0x000fc40000000000ULL,
0x0000002010037824ULL, 0x000fe200078e00ffULL, 0x00001000014a7983ULL, 0x000f680000300800ULL,
0x00000c0001497983ULL, 0x000f620000300800ULL, 0xffffffe003027812ULL, 0x000fc600078ee202ULL,
0x0000080001487983ULL, 0x000f620000300800ULL, 0x0000000802027c11ULL, 0x000fc6000f8e20ffULL,
0x00000400014c7983ULL, 0x000f680000300800ULL, 0x000000000208783bULL, 0x0003e20000000200ULL,
0x0000001a11037836ULL, 0x000fc60000000000ULL, 0x000000006868783bULL, 0x000fe20000000200ULL,
0x0000001c11027810ULL, 0x002fc60007ffe0ffULL, 0x00000000000079afULL, 0x000e280000000000ULL,
0x000000000404783bULL, 0x004fe80000000200ULL, 0x000000000c0c783bULL, 0x008e680000000200ULL,
0x000000001214783bULL, 0x010fe80000000200ULL, 0x000000002020783bULL, 0x020ea80000000200ULL,
0x000000001338783bULL, 0x0007e80000000200ULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x0000000001137983ULL, 0x008ee20000300800ULL, 0x0000002010127824ULL, 0x000fc400078e00ffULL,
0x0000001e11117836ULL, 0x000fe20000000000ULL, 0x0000ec0001507983ULL, 0x0009640000100800ULL,
0xffffffe012037812ULL, 0x000fe400078ee203ULL, 0x0000e00001537983ULL, 0x0009240000100800ULL,
0x0000000803037c11ULL, 0x000fe4000f8e20ffULL, 0x0000e40001527983ULL, 0x0005280000100800ULL,
0x000000000334783bULL, 0x0004a20000000200ULL, 0x0000000c0840723cULL, 0x002fe60000001840ULL,
0x0000e80001517983ULL, 0x0005260000100800ULL, 0x0000000e083c723cULL, 0x000fe2000000183cULL,
0x000000004b0c783bULL, 0x000e6a0000000200ULL, 0x000000040818723cULL, 0x000fe20000001818ULL,
0x0000002010037824ULL, 0x004fca00078e00ffULL, 0x000000060830723cULL, 0x000fe20000001830ULL,
0x000000004d04783bULL, 0x000ea20000000200ULL, 0xffffffe003027812ULL, 0x000fc800078ee202ULL,
0x00000020081c723cULL, 0x000fe2000000181cULL, 0x0000000802027c11ULL, 0x000fca000f8e20ffULL,
0x000000160828723cULL, 0x000fec0000001828ULL, 0x000000140824723cULL, 0x000fec0000001824ULL,
0x00000022082c723cULL, 0x000fe2000000182cULL, 0x000000004a14783bULL, 0x000fe80000000200ULL,
0x000000000208783bULL, 0x000fe80000000200ULL, 0x000000004920783bULL, 0x000ea20000000200ULL,
0x0000002010107824ULL, 0x000fc600078e00ffULL, 0x000000004848783bULL, 0x000ea40000000200ULL,
0xffffffe010117812ULL, 0x000fe200078ee211ULL, 0x000000443440723cULL, 0x000fe20000001840ULL,
0x000000004c4c783bULL, 0x000fea0000000200ULL, 0x00000046343c723cULL, 0x000fe2000000183cULL,
0x000000007d44783bULL, 0x000fea0000000200ULL, 0x0000000c341c723cULL, 0x002fee000000181cULL,
0x00000008110c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000003a3430723cULL, 0x000fe20000001830ULL,
0x0000a800013b7983ULL, 0x000f2a0000300800ULL, 0x000000063428723cULL, 0x004fe20000001828ULL,
0x0000ac00013a7983ULL, 0x000eaa0000300800ULL, 0x0000000e342c723cULL, 0x000fe2000000182cULL,
0x000000000c0c783bULL, 0x000e6a0000000200ULL, 0x000000043424723cULL, 0x000fe20000001824ULL,
0x000000007c04783bULL, 0x000eea0000000200ULL, 0x000000200840723cULL, 0x000fe20000001840ULL,
0x0000c00001217983ULL, 0x0004aa0000100800ULL, 0x00000022083c723cULL, 0x000fe2000000183cULL,
0x0000c40001207983ULL, 0x0004a80000100800ULL, 0x0000b80001237983ULL, 0x0004a20000100800ULL,
0x000000383418723cULL, 0x000fe60000001818ULL, 0x0000bc0001227983ULL, 0x0004a60000100800ULL,
0x000000160830723cULL, 0x000fe20000001830ULL, 0x0000d00001397983ULL, 0x0004a80000100800ULL,
0x0000d40001387983ULL, 0x0004a20000100800ULL, 0x0000004a0828723cULL, 0x000fe60000001828ULL,
0x0000d80001177983ULL, 0x0004a60000100800ULL, 0x000000440c40723cULL, 0x002fe20000001840ULL,
0x0000dc0001167983ULL, 0x0002a80000100800ULL, 0x0000c80001457983ULL, 0x0002a20000100800ULL,
0x000000460c3c723cULL, 0x000fe6000000183cULL, 0x0000b00001477983ULL, 0x0002a60000100800ULL,
0x000000140818723cULL, 0x000fe20000001818ULL, 0x0000b40001467983ULL, 0x0002a80000100800ULL,
0x0000cc0001447983ULL, 0x0002a80000100800ULL, 0x0000700001377983ULL, 0x000ea20000300800ULL,
0x000000060c28723cULL, 0x008fe60000001828ULL, 0x0000740001157983ULL, 0x000ee80000300800ULL,
0x0000780001147983ULL, 0x000ee20000300800ULL, 0x0000004c081c723cULL, 0x000fec000000181cULL,
0x0000004e082c723cULL, 0x000fec000000182cULL, 0x000000480824723cULL, 0x000fe20000001824ULL,
0x000000001310783bULL, 0x000f6a0000000200ULL, 0x000000120c30723cULL, 0x020fe20000001830ULL,
0x00007c0001137983ULL, 0x000f680000300800ULL, 0x0000800001367983ULL, 0x000f680000300800ULL,
0x0000840001077983ULL, 0x000f680000300800ULL, 0x0000880001067983ULL, 0x000f680000300800ULL,
0x00008c0001357983ULL, 0x000f680000300800ULL, 0x0000900001347983ULL, 0x000f680000300800ULL,
0x0000940001127983ULL, 0x000f680000300800ULL, 0x00009800010b7983ULL, 0x000f680000300800ULL,
0x00009c00010a7983ULL, 0x000f680000300800ULL, 0x0000a00001097983ULL, 0x000f680000300800ULL,
0x0000a40001087983ULL, 0x000f620000300800ULL, 0x00000002ff027819ULL, 0x000fe2000001165aULL,
0x0000006a0c2c723cULL, 0x000fe6000000182cULL, 0x0000000402007c0cULL, 0x000fc6000bf06070ULL,
0x000000680c1c723cULL, 0x000fe2000000181cULL, 0x00000007ff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000d02007c0cULL, 0x000fc8000c706470ULL, 0x000000040c24723cULL, 0x000fe20000001824ULL,
0x0000001903007c0cULL, 0x000fca0008703070ULL, 0x000000100c18723cULL, 0x000fe20000001818ULL,
0x0000000802027836ULL, 0x000fca0000000000ULL, 0x0000000402007c0cULL, 0x000fe4000bf26070ULL,
0x0000002d00508202ULL, 0x000fe20000000f00ULL, 0x000000ffff518224ULL, 0x010fc600078e002cULL,
0x000000ffff528224ULL, 0x000fe400078e001dULL, 0x000000ffff538224ULL, 0x000fe200078e001cULL,
0x0000ec5001008387ULL, 0x0003e20000100800ULL, 0x0000000d02007c0cULL, 0x000fe20008f21070ULL,
0x00000007ff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000e85101008387ULL, 0x0003e80000100800ULL,
0x0000e45201008387ULL, 0x0003e20000100800ULL, 0x000000ffff218224ULL, 0x004fc600078e0040ULL,
0x0000e05301008387ULL, 0x0003e20000100800ULL, 0x000000ffff208224ULL, 0x000fe200078e0041ULL,
0x0000001902007c0cULL, 0x000fe20008f24470ULL, 0x000000ffff238224ULL, 0x000fe200078e0030ULL,
0x0000002400398202ULL, 0x000fe20000000f00ULL, 0x000000ffff388224ULL, 0x000fe400078e0025ULL,
0x000000ffff178224ULL, 0x000fe400078e0028ULL, 0x000000ffff168224ULL, 0x000fe400078e0029ULL,
0x000000ffff458224ULL, 0x000fc600078e003cULL, 0x0000dc1601008387ULL, 0x0003e20000100800ULL,
0x000000ffff228224ULL, 0x000fc600078e0031ULL, 0x0000d81701008387ULL, 0x0003e80000100800ULL,
0x0000d43801008387ULL, 0x0003e20000100800ULL, 0x000000ffff448224ULL, 0x000fc600078e003dULL,
0x0000d03901008387ULL, 0x0003e20000100800ULL, 0x0000001900468202ULL, 0x000fe20000000f00ULL,
0x000000ffff478224ULL, 0x000fe400078e0018ULL, 0x0000cc4401008387ULL, 0x0003e20000100800ULL,
0x0000003a2f3a7208ULL, 0x000fc60000800000ULL, 0x0000c84501008387ULL, 0x0003e20000100800ULL,
0x0000003b2e3b7208ULL, 0x000fc60000800000ULL, 0x0000c42001008387ULL, 0x0003e80000100800ULL,
0x0000c02101008387ULL, 0x0003e80000100800ULL, 0x0000bc2201008387ULL, 0x0003e80000100800ULL,
0x0000b82301008387ULL, 0x0003e80000100800ULL, 0x0000b44601008387ULL, 0x0003e80000100800ULL,
0x0000b04701008387ULL, 0x0003e80000100800ULL, 0x0000ac3a01007387ULL, 0x0003e80000100800ULL,
0x0000a83b01007387ULL, 0x0003e20000100800ULL, 0x0000000100047882ULL, 0x000fe20000000000ULL,
0x0000001432147208ULL, 0x008fe20000800000ULL, 0x0000000404047887ULL, 0x000fe20008000000ULL,
0x000000151b157208ULL, 0x000fc40000800000ULL, 0x000000371a377208ULL, 0x000fe20000800000ULL,
0x000000040d00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fe20003f0f018ULL,
0x0000000d00047c82ULL, 0x000fe20008000000ULL, 0x0000001333137208ULL, 0x020fe40000800000ULL,
0x0000003642367208ULL, 0x000fe40000800000ULL, 0x0000000743077208ULL, 0x000fe40000800000ULL,
0x000000063e067208ULL, 0x000fe40000800000ULL, 0x000000353f357208ULL, 0x000fc40000800000ULL,
0x0000003426347208ULL, 0x000fe40000800000ULL, 0x0000001227127208ULL, 0x000fe40000800000ULL,
0x0000000b2a0b7208ULL, 0x000fe40000800000ULL, 0x0000000a2b0a7208ULL, 0x000fe40000800000ULL,
0x000000091e097208ULL, 0x000fe40000800000ULL, 0x000000081f087208ULL, 0x000fca0000800000ULL,
0x0000a40801007387ULL, 0x0003e80000100800ULL, 0x0000a00901007387ULL, 0x0003e80000100800ULL,
0x00009c0a01007387ULL, 0x0003e80000100800ULL, 0x0000980b01007387ULL, 0x0003e80000100800ULL,
0x0000941201007387ULL, 0x0003e80000100800ULL, 0x0000903401007387ULL, 0x0003e80000100800ULL,
0x00008c3501007387ULL, 0x0003e80000100800ULL, 0x0000880601007387ULL, 0x0003e80000100800ULL,
0x0000840701007387ULL, 0x0003e80000100800ULL, 0x0000803601007387ULL, 0x0003e80000100800ULL,
0x00007c1301007387ULL, 0x0003e80000100800ULL, 0x0000781401007387ULL, 0x0003e80000100800ULL,
0x0000741501007387ULL, 0x0003e80000100800ULL, 0x0000703701007387ULL, 0x0003e20000100800ULL,
0xffffff6c00e88947ULL, 0x000fea000383ffffULL, 0x0000000815047291ULL, 0x000fe2000f8e183fULL,
0x00000001ff027424ULL, 0x000fe400078e00ffULL, 0x3d800000171b7820ULL, 0x000fe20000410000ULL,
0x3d800000161a7820ULL, 0x000fe20000410000ULL, 0x3d800000120d7820ULL, 0x000fe20000410000ULL,
0x3d80000047257820ULL, 0x000fe20000410000ULL, 0x3d80000046247820ULL, 0x000fe20000410000ULL,
0x3d80000023237820ULL, 0x002fe20000410000ULL, 0x3d80000022227820ULL, 0x000fe20000410000ULL,
0x01cb5802ff0279a7ULL, 0x000e620008500004ULL, 0x3d80000021217820ULL, 0x000fe20000410000ULL,
0x3d80000020207820ULL, 0x000fe20000410000ULL, 0x3d800000451f7820ULL, 0x000fe20000410000ULL,
0x3d800000441e7820ULL, 0x000fe20000410000ULL, 0x3d800000391d7820ULL, 0x000fe20000410000ULL,
0x3d800000381c7820ULL, 0x000fe20000410000ULL, 0x3d80000053197820ULL, 0x000fe20000410000ULL,
0x3d80000052187820ULL, 0x000fe20000410000ULL, 0x3d80000051177820ULL, 0x000fe20000410000ULL,
0x3d80000050167820ULL, 0x000fe20000410000ULL, 0x3d80000037047820ULL, 0x000fe20000410000ULL,
0x3d80000015157820ULL, 0x000fe20000410000ULL, 0x3d80000014147820ULL, 0x000fe20000410000ULL,
0x3d80000013137820ULL, 0x000fe20000410000ULL, 0x3d800000360f7820ULL, 0x000fe20000410000ULL,
0x3d80000007077820ULL, 0x000fe20000410000ULL, 0x3d80000006067820ULL, 0x000fe20000410000ULL,
0x3d80000035057820ULL, 0x000fe20000410000ULL, 0x3d800000340e7820ULL, 0x000fe20000410000ULL,
0x3d8000000b0c7820ULL, 0x000fe20000410000ULL, 0x3d8000000a127820ULL, 0x000fe20000410000ULL,
0x3d80000009117820ULL, 0x000fe20000410000ULL, 0x3d80000008107820ULL, 0x000fe20000410000ULL,
0x000000ffff267224ULL, 0x002fc400078e0003ULL, 0x3d8000003b037820ULL, 0x000fe20000410000ULL,
0x3d8000003a027820ULL, 0x000fe20000410000ULL, 0x0000000000087805ULL, 0x000fe20000015200ULL,
0x01cb5826ff0075a7ULL, 0x000e640008000144ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff287224ULL, 0x000fce00078e00ffULL, 0x000000102800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08277210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x000000270a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fce0007ffe0ffULL, 0x01cb5826ff0075a7ULL, 0x000e640008000144ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0xffffffff05047890ULL, 0x000fe2000fffe03fULL,
0x00000000002a7919ULL, 0x000e620000000000ULL, 0x00000008150c7291ULL, 0x000fe2000f8e383fULL,
0xfffffff059597812ULL, 0x000fe200078ec0ffULL, 0x000000041900728cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x01c4000c59087984ULL, 0x0004d80008000c00ULL,
0x00000004000c0947ULL, 0x004fea0003800000ULL, 0x000000022a267824ULL, 0x002fe200078e00ffULL,
0x0000001419047291ULL, 0x000fc8000f8e403fULL, 0x0000000626267812ULL, 0x000fe200078ec0ffULL,
0x800000041a047290ULL, 0x000fc6000fffe03fULL, 0x0000000126277812ULL, 0x040fe400078efcffULL,
0x0000000826287812ULL, 0x040fe400078efcffULL, 0x0000000427007c0cULL, 0x000fe4000bf26070ULL,
0x0000001026277812ULL, 0x000fe400078efcffULL, 0x0000000428007c0cULL, 0x000fe4000bf06070ULL,
0x0000000427007c0cULL, 0x000fc4000bfc6070ULL, 0x0000001126287812ULL, 0x040fe400078efcffULL,
0x0000001826277812ULL, 0x040fe400078efcffULL, 0x0000000426007c0cULL, 0x000fe4000bf46070ULL,
0x0000000428007c0cULL, 0x000fe4000bfa6070ULL, 0x0000000427007c0cULL, 0x000fe4000bf66070ULL,
0x0000000926297812ULL, 0x000fc400078efcffULL, 0x0000001926287812ULL, 0x040fe400078efcffULL,
0x0000002026277812ULL, 0x000fe400078efcffULL, 0xff80000004047808ULL, 0x000fe40005000000ULL,
0xff80000025257808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40004800000ULL,
0xff80000024247808ULL, 0x000fc40004800000ULL, 0x0000000429007c0cULL, 0x000fe4000bf86070ULL,
0x0000000428007c0cULL, 0x000fe4000bf46070ULL, 0x0000000427007c0cULL, 0x000fe4000bf26070ULL,
0x0000002126287812ULL, 0x040fe400078efcffULL, 0x0000002826277812ULL, 0x000fe400078efcffULL,
0xff80000014147808ULL, 0x000fc40004000000ULL, 0xff80000023237808ULL, 0x000fe40004000000ULL,
0xff80000013137808ULL, 0x000fe40006000000ULL, 0xff80000022227808ULL, 0x000fe40006000000ULL,
0x0000000428007c0cULL, 0x000fe4000bf06070ULL, 0x0000000427007c0cULL, 0x000fe4000bf86070ULL,
0x0000002926287812ULL, 0x000fc400078efcffULL, 0x0000003026277812ULL, 0x000fe400078efcffULL,
0xff8000000f0f7808ULL, 0x000fe40007000000ULL, 0xff80000021217808ULL, 0x000fe40007000000ULL,
0xff80000007077808ULL, 0x000fe40006800000ULL, 0xff80000020207808ULL, 0x000fe40006800000ULL,
0x0000000428007c0cULL, 0x000fc4000bfc6070ULL, 0x0000000427007c0cULL, 0x000fe4000bfa6070ULL,
0x0000003126287812ULL, 0x040fe400078efcffULL, 0x0000003826277812ULL, 0x040fe400078efcffULL,
0x0000003926267812ULL, 0x000fe400078efcffULL, 0xff80000006067808ULL, 0x000fe40005800000ULL,
0xff8000001f1f7808ULL, 0x000fc40005800000ULL, 0xff80000005057808ULL, 0x000fe40005000000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004800000ULL,
0xff8000001d1d7808ULL, 0x000fe40004800000ULL, 0x0000000428007c0cULL, 0x000fe4000bf66070ULL,
0x0000000427007c0cULL, 0x000fc4000bf46070ULL, 0x0000000426007c0cULL, 0x000fe4000bf26070ULL,
0xff8000000d0d7808ULL, 0x000fe40004000000ULL, 0xff8000001c1c7808ULL, 0x000fe40004000000ULL,
0xff8000000c0c7808ULL, 0x000fe40006000000ULL, 0xff8000001b1b7808ULL, 0x000fe40006000000ULL,
0xff80000012127808ULL, 0x000fc40007000000ULL, 0xff8000001a1a7808ULL, 0x000fe40007000000ULL,
0xff80000011117808ULL, 0x000fe40006800000ULL, 0xff80000019197808ULL, 0x000fe40006800000ULL,
0xff80000010107808ULL, 0x000fe40005800000ULL, 0xff80000018187808ULL, 0x000fe40005800000ULL,
0xff80000003037808ULL, 0x000fc40005000000ULL, 0xff80000017177808ULL, 0x000fe40005000000ULL,
0xff80000002027808ULL, 0x000fe40004800000ULL, 0xff80000016167808ULL, 0x000fce0004800000ULL,
0x000000250800720bULL, 0x008fe20003f1e000ULL, 0x0000000815047291ULL, 0x000fe2000f8e583fULL,
0xfffffff8ff587812ULL, 0x000fe200078ee258ULL, 0x0000001916197290ULL, 0x000fe2000fffe03fULL,
0x0000000825277208ULL, 0x000fe20004000000ULL, 0x0001200004047890ULL, 0x000fe4000fffe03fULL,
0x000000051900728cULL, 0x000fe2000bf06070ULL, 0x000000242700720bULL, 0x000fe20003f1e000ULL,
0x00000008150d7291ULL, 0x000fc6000f8e283fULL, 0x0000002724087208ULL, 0x000fc80004000000ULL,
0x000000230800720bULL, 0x000fc80003f1e000ULL, 0x0000000823277208ULL, 0x000fc80004000000ULL,
0x000000222700720bULL, 0x000fc80003f1e000ULL, 0x0000002722087208ULL, 0x000fc80004000000ULL,
0x000000210800720bULL, 0x000fc80003f1e000ULL, 0x0000000821277208ULL, 0x000fc80004000000ULL,
0x000000202700720bULL, 0x000fc80003f1e000ULL, 0x0000002720087208ULL, 0x000fc80004000000ULL,
0x0000001f0800720bULL, 0x000fc80003f1e000ULL, 0x000000081f277208ULL, 0x000fc80004000000ULL,
0x0000001e2700720bULL, 0x000fc80003f1e000ULL, 0x000000271e087208ULL, 0x000fc80004000000ULL,
0x0000001d0800720bULL, 0x000fc80003f1e000ULL, 0x000000081d277208ULL, 0x000fc80004000000ULL,
0x0000001c2700720bULL, 0x000fc80003f1e000ULL, 0x000000271c087208ULL, 0x000fc80004000000ULL,
0x0000001b0800720bULL, 0x000fc80003f1e000ULL, 0x000000081b277208ULL, 0x000fe40004000000ULL,
0x000000040900720bULL, 0x000fe40003f1e000ULL, 0x0000001a2700720bULL, 0x000fe40003f3e000ULL,
0x0000000904087208ULL, 0x000fe40004000000ULL, 0x000000271a267208ULL, 0x000fe40004800000ULL,
0x000000150800720bULL, 0x000fc40003f1e000ULL, 0x000000192600720bULL, 0x000fe40003f3e000ULL,
0x0000000815097208ULL, 0x000fe40004000000ULL, 0x0000002619277208ULL, 0x000fe40004800000ULL,
0x000000140900720bULL, 0x000fe40003f1e000ULL, 0x000000182700720bULL, 0x000fe40003f3e000ULL,
0x0000000914087208ULL, 0x000fc40004000000ULL, 0x0000002718267208ULL, 0x000fe40004800000ULL,
0x000000130800720bULL, 0x000fe40003f1e000ULL, 0x000000172600720bULL, 0x000fe40003f3e000ULL,
0x0000000813087208ULL, 0x000fe40004000000ULL, 0x0000002617097208ULL, 0x000fe40004800000ULL,
0x0000000f0800720bULL, 0x000fc40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x000000080f087208ULL, 0x000fe40004000000ULL, 0x0000000916267208ULL, 0x000fe40004800000ULL,
0x000000070800720bULL, 0x000fc60003f1e000ULL, 0x0c401f0026277f89ULL, 0x000ea200000e0000ULL,
0x0000000807097208ULL, 0x000fc80004000000ULL, 0x000000060900720bULL, 0x000fc80003f1e000ULL,
0x0000000906087208ULL, 0x000fc80004000000ULL, 0x000000050800720bULL, 0x000fc80003f1e000ULL,
0x0000000805097208ULL, 0x000fc80004000000ULL, 0x0000000e0900720bULL, 0x000fe40003f1e000ULL,
0x000000272600720bULL, 0x004fe40003f3e000ULL, 0x000000090e087208ULL, 0x000fe40004000000ULL,
0x0000002627277208ULL, 0x000fe40004800000ULL, 0x0000000d0800720bULL, 0x000fc60003f1e000ULL,
0x0c201f0027287f89ULL, 0x000ea200000e0000ULL, 0x000000080d097208ULL, 0x000fc80004000000ULL,
0x0000000c0900720bULL, 0x000fc80003f1e000ULL, 0x000000090c097208ULL, 0x000fc80004000000ULL,
0x000000120900720bULL, 0x000fc80003f1e000ULL, 0x0000000912267208ULL, 0x000fc80004000000ULL,
0x000000112600720bULL, 0x000fe40003f1e000ULL, 0x000000282700720bULL, 0x004fe40003f3e000ULL,
0x0000002611097208ULL, 0x000fe40004000000ULL, 0x0000002728087208ULL, 0x000fe40004800000ULL,
0x000000100900720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b08277820ULL, 0x000fe20000410000ULL,
0x0000000910267208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010827ULL,
0x000000032600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010827ULL, 0x0000002100387308ULL, 0x0005e20000000800ULL,
0x0000002603097208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b22267823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010827ULL,
0x000000020900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010827ULL, 0x0000001e00377308ULL, 0x000fe20000000800ULL,
0x0000000902097208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1c217823ULL, 0x104fe20000010827ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010827ULL, 0x0c401f0009227f89ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010827ULL, 0x0000002500407308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fca0000010827ULL, 0x0000002400417308ULL, 0x000f220000000800ULL,
0x0000b04001007387ULL, 0x008fee0000100800ULL, 0x00000023003e7308ULL, 0x000ee20000000800ULL,
0x000000220900720bULL, 0x004fe20003f1e000ULL, 0x0000b44101007387ULL, 0x010fec0000100800ULL,
0x00000026003f7308ULL, 0x000ea20000000800ULL, 0x0000000922097208ULL, 0x000fca0004000000ULL,
0x0c201f00091c7f89ULL, 0x000f2400000e0000ULL, 0x0000001700297308ULL, 0x000fe40000000800ULL,
0x0000b83e01007387ULL, 0x008fe80000100800ULL, 0x0000bc3f01007387ULL, 0x004fe40000100800ULL,
0x00000016002b7308ULL, 0x000fe40000000800ULL, 0x0000c03801007387ULL, 0x000fec0000100800ULL,
0x0000001d00307308ULL, 0x0005e20000000800ULL, 0x0000001c0900720bULL, 0x010fce0003f1e000ULL,
0x0000001b002e7308ULL, 0x000fe20000000800ULL, 0x3c003c00ff1d7424ULL, 0x004fe200078e00ffULL,
0x000000091c097208ULL, 0x000fe20004000000ULL, 0x3c003c00ff1c7424ULL, 0x000fc800078e00ffULL,
0x3fb8aa3b091e7820ULL, 0x000fe20000410000ULL, 0x0000001a002f7308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b04047823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b07167823ULL, 0x100fe2000001081eULL, 0x00000004003c7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b06177823ULL, 0x100fe2000001081eULL, 0x0000003e3f06723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b03037823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b02027823ULL, 0x000fc6000001081eULL, 0x00000015003d7308ULL, 0x0007220000000800ULL,
0x000000404104723eULL, 0x004fce00000000ffULL, 0x00000014003a7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b05157823ULL, 0x008fe2000001081eULL, 0x0000003c3d05723eULL, 0x010fcc00000000ffULL,
0x00000013003b7308ULL, 0x0007220000000800ULL, 0x3fb8aa3b0d147823ULL, 0x004fce000001081eULL,
0x00000019002c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0e137823ULL, 0x008fe2000001081eULL,
0x0000003a3b07723eULL, 0x010fcc00000000ffULL, 0x00000018002d7308ULL, 0x0005f00000000800ULL,
0x0000002000397308ULL, 0x000ee20000000800ULL, 0x0000001c0418723cULL, 0x004fee00000018ffULL,
0x0000001f00367308ULL, 0x0005220000000800ULL, 0x0000c43901007387ULL, 0x008fee0000100800ULL,
0x0000000f00347308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b111f7823ULL, 0x004fe2000001081eULL,
0x00000036370e723eULL, 0x010fcc00000000ffULL, 0x0000001600357308ULL, 0x0004e20000000800ULL,
0x0000c83601007387ULL, 0x000fe80000100800ULL, 0x0000cc3701007387ULL, 0x000fe60000100800ULL,
0x0000001700327308ULL, 0x0009e20000000800ULL, 0x3fb8aa3b0c167823ULL, 0x004fe2000001081eULL,
0x00000038390c723eULL, 0x000fe200000000ffULL, 0x0000d03001007387ULL, 0x000fe20000100800ULL,
0x00000034350d723eULL, 0x008fc800000000ffULL, 0x0000001500337308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b12177823ULL, 0x010fe2000001081eULL, 0x0000002e2f12723eULL, 0x000fcc00000000ffULL,
0x0000002100317308ULL, 0x000f220000000800ULL, 0x0c401f000a157f89ULL, 0x004ea200000e0000ULL,
0x00000032330f723eULL, 0x008fcc00000000ffULL, 0x0000001300217308ULL, 0x000fe20000000800ULL,
0x0000001c0c18723cULL, 0x000fe20000001818ULL, 0x0000d43101007387ULL, 0x010fec0000100800ULL,
0x0000001400227308ULL, 0x000ee20000000800ULL, 0x0000d82e01007387ULL, 0x000fe80000100800ULL,
0x0000dc2f01007387ULL, 0x000fe60000100800ULL, 0x0000001600207308ULL, 0x0009e20000000800ULL,
0x000000150a00720bULL, 0x004fe20003f1e000ULL, 0x0000e02c01007387ULL, 0x000fe60000100800ULL,
0x0000000a150a7208ULL, 0x000fe20004000000ULL, 0x0000e42d01007387ULL, 0x000fe40000100800ULL,
0x0000001700137308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b10167823ULL, 0x010fe2000001081eULL,
0x000000303110723eULL, 0x000fe200000000ffULL, 0x0000e82901007387ULL, 0x000fe20000100800ULL,
0x000000212211723eULL, 0x008fc600000000ffULL, 0x0000ec2b01007387ULL, 0x000fe20000100800ULL,
0x0000001f00247308ULL, 0x000fe60000000800ULL, 0x0000703c01007387ULL, 0x000fe80000100800ULL,
0x0000743d01007387ULL, 0x000fe20000100800ULL, 0x0000001600257308ULL, 0x0004e60000000800ULL,
0x0000783a01007387ULL, 0x000fe80000100800ULL, 0x00007c3b01007387ULL, 0x000fe20000100800ULL,
0x0000000300177308ULL, 0x000f220000000800ULL, 0x000000292b16723eULL, 0x004fc400000000ffULL,
0x0000803401007387ULL, 0x000fe80000100800ULL, 0x0000843501007387ULL, 0x000fe20000100800ULL,
0x0000000200237308ULL, 0x000ea20000000800ULL, 0x000000242515723eULL, 0x008fe400000000ffULL,
0x0000883201007387ULL, 0x000fe80000100800ULL, 0x00008c3301007387ULL, 0x000fe80000100800ULL,
0x0c401f000b147f89ULL, 0x000ee800000e0000ULL, 0x0000902101007387ULL, 0x000be80000100800ULL,
0x0000942201007387ULL, 0x0005e80000100800ULL, 0x0000982001007387ULL, 0x000fe20000100800ULL,
0x0000000300217812ULL, 0x022fc600078ec0ffULL, 0x00009c1301007387ULL, 0x0003e20000100800ULL,
0x0000000858227824ULL, 0x004fc600078e00ffULL, 0x0000a02401007387ULL, 0x0005e20000100800ULL,
0x00000001211e7824ULL, 0x000fe200078e0258ULL, 0x000000140b00720bULL, 0x008fe40003f3e000ULL,
0x0000a42501007387ULL, 0x000fe20000100800ULL, 0x000000201313723eULL, 0x002fe200000000ffULL,
0x000000041e1f7836ULL, 0x000fe20000000000ULL, 0x0000000b140b7208ULL, 0x000fe20004800000ULL,
0x0000a81701007387ULL, 0x0103e20000100800ULL, 0x0000002c2d14723eULL, 0x000fe200000000ffULL,
0x0000000858207836ULL, 0x000fe20000000000ULL, 0xfffffff8221f7812ULL, 0x000fe200078ee21fULL,
0x0000001c1018723cULL, 0x000fe20000001818ULL, 0x0c201f000a037f89ULL, 0x000ee200000e0000ULL,
0x0000000820247824ULL, 0x044fe200078e00ffULL, 0x0000002021217210ULL, 0x000fe20007ffe0ffULL,
0x0000000820267824ULL, 0x000fe200078e00ffULL, 0x0c201f000b007f89ULL, 0x000ea200000e0000ULL,
0x000000172317723eULL, 0x002fe200000000ffULL, 0x000000ffff207224ULL, 0x000fe200078e0010ULL,
0xfffffff824247812ULL, 0x000fe200078ee221ULL, 0x0000ac2301007387ULL, 0x0003e20000100800ULL,
0x000000ffff217224ULL, 0x000fc400078e0012ULL, 0x000000ffff227224ULL, 0x000fe200078e0014ULL,
0x0000000424247c11ULL, 0x000fe2000f8e20ffULL, 0x0000000858237824ULL, 0x002fd400078e00ffULL,
0x0000001c1418723cULL, 0x000fe20000001818ULL, 0x000000030a00720bULL, 0x008fe40003f1e000ULL,
0xfffffff823027812ULL, 0x000fc600078ee21eULL, 0x000000ffff237224ULL, 0x000fe200078e0016ULL,
0x0000000a030a7208ULL, 0x000fe40004000000ULL, 0x000000032aff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0004ULL, 0x0000000402027c11ULL, 0x000fe4000f8e20ffULL,
0x00000006001d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff067224ULL, 0x000fe200078e000dULL,
0x000000000b00720bULL, 0x004fe20003f3e000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000000500047202ULL, 0x000fe20000000f00ULL, 0x000000ffff057224ULL, 0x000fe200078e0007ULL,
0x0000000b000b7208ULL, 0x000fe20004800000ULL, 0x000000ffff077224ULL, 0x000fe200078e000fULL,
0x00000017000f7202ULL, 0x000fe20000000f00ULL, 0x0000000c1e1b7836ULL, 0x000fe20000000000ULL,
0x000000041f197c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff1f7224ULL, 0x000fe200078e000eULL, 0xfffffff8261b7812ULL, 0x000fe200078ee21bULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0015ULL,
0x0000001c02007844ULL, 0x000fe20000000200ULL, 0x000000041b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff007424ULL, 0x000fe400078e00ffULL, 0x0000002019007844ULL, 0x0003e80000000200ULL,
0x0000000424007844ULL, 0x0005e80000000200ULL, 0x0000000c1b007844ULL, 0x0005e80000000200ULL,
0x01c0000859008988ULL, 0x0005e20008000c0cULL, 0x000000ffff197224ULL, 0x002fca00078e001aULL,
0x01c2001859008988ULL, 0x0005e20008000a0cULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x01cad800ffff79a7ULL, 0x0005e2000850000dULL, 0x01cae000ffff79a7ULL, 0x0005e2000850000dULL,
0x01cae800ffff79a7ULL, 0x0005e2000850000dULL, 0x01caf000ffff79a7ULL, 0x0005f2000850000dULL,
0xffffff5400848947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000035007836ULL, 0x000fe20000000000ULL, 0x0000013000007945ULL, 0x000fe80003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003500008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff35ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000035037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000003500007308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffd9c02947950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004c6ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000648ULL, 0x0000000000000210ULL,
0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000858ULL, 0x00000000000000d0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000928ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000097cULL, 0x0000000000000aa0ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001420ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001420ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000007bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001468ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001480ULL, 0x0000000000026280ULL,
0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000008dULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000027700ULL, 0x000000000000003cULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000027740ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000027740ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000027d38ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000027d38ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001468ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001480ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000026280ULL, 0x0000000000026280ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000027700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000027740ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_fp16_pagedKV_128_nqpkv_1_m_1_sm_90_cubin_len = 163464;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
