/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_fp16_pagedKV_64_nqpkv_1_m_1_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000028340ULL, 0x0000000000027fc0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4974613245453233ULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x45386a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x324545386a4c4536ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x746e695f5f240067ULL, 0x5f305f6c616e7265ULL, 0x5f616475635f5f24ULL,
0x7063725f30326d73ULL, 0x5f7a74665f6e725fULL, 0x776f6c735f323366ULL, 0x5f5f240068746170ULL,
0x6c616e7265746e69ULL, 0x75635f5f245f315fULL, 0x5f30376d735f6164ULL, 0x636e79736c666873ULL,
0x00705f796c66625fULL, 0x7265746e695f5f24ULL, 0x5f245f325f6c616eULL, 0x6d735f616475635fULL,
0x736c6668735f3037ULL, 0x5f7864695f636e79ULL, 0x746e695f5f240070ULL, 0x5f335f6c616e7265ULL,
0x5f616475635f5f24ULL, 0x746f765f30376d73ULL, 0x61625f636e797365ULL, 0x5f5f2400746f6c6cULL,
0x6c616e7265746e69ULL, 0x75635f5f245f345fULL, 0x5f30376d735f6164ULL, 0x636e797370726177ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001adULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002ceULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000363ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003a8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003eeULL, 0x0000000000025f40ULL, 0x0000000000000170ULL, 0x000b002200000421ULL,
0x00000000000260b0ULL, 0x0000000000000040ULL, 0x000b00220000044cULL, 0x00000000000260f0ULL,
0x0000000000000040ULL, 0x000b002200000476ULL, 0x0000000000026130ULL, 0x0000000000000060ULL,
0x000b0022000004a1ULL, 0x0000000000026190ULL, 0x00000000000000f0ULL, 0x000a000300000508ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000528ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000558ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000026280ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00025f4000000000ULL, 0x0000040400000000ULL, 0x810c000001680400ULL, 0x0096580400288080ULL,
0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8d082880808c0828ULL,
0x2880809408288080ULL, 0x80a708288080a208ULL, 0x08288080a8082880ULL, 0x8080b408288080a9ULL,
0x8016288080860828ULL, 0x0000000310288082ULL, 0x8086920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00025f4000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8c08288080860828ULL,
0x2880808d08288080ULL, 0x808f082880808e08ULL, 0x0828808094082880ULL, 0x8080b408288080a7ULL,
0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000011000000000ULL, 0x000260b000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8c08288080860828ULL,
0x2880808d08288080ULL, 0x808f082880808e08ULL, 0x0828808094082880ULL, 0x8080b408288080a7ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080b492ULL, 0x0000001cffffffffULL,
0x000001b000000000ULL, 0x000260f000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8c08288080860828ULL, 0x2880808d08288080ULL,
0x808f082880808e08ULL, 0x0828808094082880ULL, 0x8080b408288080a7ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080b492ULL, 0x0000001cffffffffULL, 0x0000024800000000ULL,
0x0002613000000000ULL, 0x0000006000000000ULL, 0x0000000000000000ULL, 0x0000006cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080850828808081ULL, 0x8c08288080860828ULL, 0x2880808d08288080ULL, 0x80a2082880809408ULL,
0x08288080a7082880ULL, 0x8080b408288080a9ULL, 0x8016288080a80828ULL, 0x0000000310288082ULL,
0x80a8920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000002e000000000ULL,
0x0002619000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000c6ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL,
0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001900082304ULL,
0x0008120400000000ULL, 0x0000000000000019ULL, 0x0000001900081104ULL, 0x0004370400000000ULL,
0x00080a040000007bULL, 0x0068016000000016ULL, 0x000c170400681903ULL, 0x0060000700000000ULL,
0x000c17040021f000ULL, 0x0058000600000000ULL, 0x000c17040021f000ULL, 0x0050000500000000ULL,
0x000c17040011f000ULL, 0x0038000400000000ULL, 0x000c17040061f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff020c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000e0020c2804ULL, 0x00000480000000f0ULL,
0x00004670000045e0ULL, 0x000048d000004770ULL, 0x00004b3000004b00ULL, 0x00004bd000004b80ULL,
0x00007110000070f0ULL, 0x000071b000007160ULL, 0x00009b3000009aa0ULL, 0x00009d7000009c20ULL,
0x00009fb000009f90ULL, 0x0000a0500000a000ULL, 0x0000c2700000c250ULL, 0x0000c3100000c2c0ULL,
0x0000ead00000ea40ULL, 0x0000ed100000ebc0ULL, 0x0000ef500000ef30ULL, 0x0000eff00000efa0ULL,
0x00011210000111f0ULL, 0x000112b000011260ULL, 0x00013a70000139e0ULL, 0x00013cb000013b60ULL,
0x00013ef000013ed0ULL, 0x00013f9000013f40ULL, 0x000161b000016190ULL, 0x0001625000016200ULL,
0x00016bb000016a70ULL, 0x0001724000017220ULL, 0x00018c8000018b50ULL, 0x0001924000019200ULL,
0x00019ce0000198d0ULL, 0x0001b2300001aeb0ULL, 0x0001c3900001b250ULL, 0x0001c8f00001c3b0ULL,
0x0001d9c00001c900ULL, 0x0001e8a00001dc90ULL, 0x0001f6100001eaf0ULL, 0x000203600001f850ULL,
0x000210c0000205a0ULL, 0x00021e5000021320ULL, 0x00023020000223d0ULL, 0x000243b000024370ULL,
0x000243d0000243c0ULL, 0x00024440000243e0ULL, 0x0002448000024460ULL, 0x000250e000025090ULL,
0x000251a000025140ULL, 0x0002526000025200ULL, 0x00025320000252c0ULL, 0x000253c000025370ULL,
0x0002547000025410ULL, 0x00025530000254d0ULL, 0x000255f000025590ULL, 0x0002569000025640ULL,
0x00025740000256e0ULL, 0x00025800000257a0ULL, 0x000258c000025860ULL, 0x0002596000025910ULL,
0x00025a10000259b0ULL, 0x00025ad000025a70ULL, 0x00025b9000025b30ULL, 0x00025c3000025be0ULL,
0x00025cd000025c80ULL, 0x00025d9000025d30ULL, 0x00025e5000025df0ULL, 0x00025f1000025eb0ULL,
0x0000021007b03904ULL, 0x00014ad0000000ffULL, 0x00000280003f0100ULL, 0x00014ad800000011ULL,
0x000002f0003f0120ULL, 0x00014b5800000011ULL, 0x00000420003f0120ULL, 0x00014b7800000011ULL,
0x00000450003f0120ULL, 0x00014b88000000ffULL, 0x00000520003f0100ULL, 0x00014ad0000000ffULL,
0x000007b0003f0107ULL, 0x00014b5c00000073ULL, 0x00000810003f0102ULL, 0x00014b5800000073ULL,
0x00000970003f0101ULL, 0x00014b88000000ffULL, 0x000009b0003f0101ULL, 0x00014b8c000000ffULL,
0x00000b70003f0105ULL, 0x00014b8c000000ffULL, 0x00001e30003f0105ULL, 0x00014b88000000ffULL,
0x00001e60003f0101ULL, 0x00014b8c000000ffULL, 0x00002030003f0105ULL, 0x00014b8c000000ffULL,
0x000021a0003f0105ULL, 0x00014b78000000ffULL, 0x00002220003f0107ULL, 0x00014b78000000ffULL,
0x00002280003f0101ULL, 0x00014b88000000ffULL, 0x00002570003f0101ULL, 0x00014b7c000000ffULL,
0x00002730003f0105ULL, 0x00014b7c000000ffULL, 0x00002790003f0105ULL, 0x00014b8c000000ffULL,
0x00002960003f0105ULL, 0x00014b8c000000ffULL, 0x00003c40003f0105ULL, 0x00014b88000000ffULL,
0x00003c70003f0101ULL, 0x00014b8c000000ffULL, 0x00003e40003f0105ULL, 0x00014b8c000000ffULL,
0x000041e0003f0105ULL, 0x00014b80000000ffULL, 0x00004270003f0107ULL, 0x00014b80000000ffULL,
0x00004300003f0101ULL, 0x00014ad800000073ULL, 0x00004330003f0101ULL, 0x00014adc00000073ULL,
0x00004500003f0105ULL, 0x00014adc00000073ULL, 0x000054a0003f0105ULL, 0x00014b88000000ffULL,
0x00005580003f0101ULL, 0x00014b84000000ffULL, 0x00005740003f0105ULL, 0x00014b84000000ffULL,
0x000057a0003f0105ULL, 0x00014b8c000000ffULL, 0x00005970003f0105ULL, 0x00014b8c000000ffULL,
0x00006c30003f0105ULL, 0x00014b88000000ffULL, 0x00006c60003f0101ULL, 0x00014b8c000000ffULL,
0x00006e30003f0105ULL, 0x00014b8c000000ffULL, 0x00007010003f0105ULL, 0x00014b78000000ffULL,
0x00007090003f0107ULL, 0x00014b78000000ffULL, 0x000078a0003f0101ULL, 0x00014b88000000ffULL,
0x00007970003f0101ULL, 0x00014b58000000ffULL, 0x00007a60003f0101ULL, 0x00014b7c000000ffULL,
0x00007c20003f0105ULL, 0x00014b7c000000ffULL, 0x00007c80003f0105ULL, 0x00014b8c000000ffULL,
0x00007e50003f0105ULL, 0x00014b8c000000ffULL, 0x00009130003f0105ULL, 0x00014b88000000ffULL,
0x00009160003f0101ULL, 0x00014b8c000000ffULL, 0x00009330003f0105ULL, 0x00014b8c000000ffULL,
0x000096b0003f0105ULL, 0x00014b80000000ffULL, 0x00009740003f0107ULL, 0x00014b80000000ffULL,
0x000097c0003f0101ULL, 0x00014af800000073ULL, 0x000097f0003f0101ULL, 0x00014afc00000073ULL,
0x000099c0003f0105ULL, 0x00014afc00000073ULL, 0x0000a5f0003f0105ULL, 0x00014b88000000ffULL,
0x0000a6e0003f0101ULL, 0x00014b84000000ffULL, 0x0000a8a0003f0105ULL, 0x00014b84000000ffULL,
0x0000a900003f0105ULL, 0x00014b8c000000ffULL, 0x0000aad0003f0105ULL, 0x00014b8c000000ffULL,
0x0000bd90003f0105ULL, 0x00014b88000000ffULL, 0x0000bdc0003f0101ULL, 0x00014b8c000000ffULL,
0x0000bf90003f0105ULL, 0x00014b8c000000ffULL, 0x0000c170003f0105ULL, 0x00014b78000000ffULL,
0x0000c1f0003f0107ULL, 0x00014b78000000ffULL, 0x0000c860003f0101ULL, 0x00014b88000000ffULL,
0x0000c910003f0101ULL, 0x00014b60000000ffULL, 0x0000ca00003f0101ULL, 0x00014b7c000000ffULL,
0x0000cbc0003f0105ULL, 0x00014b7c000000ffULL, 0x0000cc20003f0105ULL, 0x00014b8c000000ffULL,
0x0000cdf0003f0105ULL, 0x00014b8c000000ffULL, 0x0000e0d0003f0105ULL, 0x00014b88000000ffULL,
0x0000e100003f0101ULL, 0x00014b8c000000ffULL, 0x0000e2d0003f0105ULL, 0x00014b8c000000ffULL,
0x0000e650003f0105ULL, 0x00014b80000000ffULL, 0x0000e6e0003f0107ULL, 0x00014b80000000ffULL,
0x0000e760003f0101ULL, 0x00014b1800000073ULL, 0x0000e790003f0101ULL, 0x00014b1c00000073ULL,
0x0000e960003f0105ULL, 0x00014b1c00000073ULL, 0x0000f590003f0105ULL, 0x00014b88000000ffULL,
0x0000f680003f0101ULL, 0x00014b84000000ffULL, 0x0000f840003f0105ULL, 0x00014b84000000ffULL,
0x0000f8a0003f0105ULL, 0x00014b8c000000ffULL, 0x0000fa70003f0105ULL, 0x00014b8c000000ffULL,
0x00010d30003f0105ULL, 0x00014b88000000ffULL, 0x00010d60003f0101ULL, 0x00014b8c000000ffULL,
0x00010f30003f0105ULL, 0x00014b8c000000ffULL, 0x00011110003f0105ULL, 0x00014b78000000ffULL,
0x00011190003f0107ULL, 0x00014b78000000ffULL, 0x00011800003f0101ULL, 0x00014b88000000ffULL,
0x000118b0003f0101ULL, 0x00014b68000000ffULL, 0x000119a0003f0101ULL, 0x00014b7c000000ffULL,
0x00011b60003f0105ULL, 0x00014b7c000000ffULL, 0x00011bc0003f0105ULL, 0x00014b8c000000ffULL,
0x00011d90003f0105ULL, 0x00014b8c000000ffULL, 0x00013070003f0105ULL, 0x00014b88000000ffULL,
0x000130a0003f0101ULL, 0x00014b8c000000ffULL, 0x00013270003f0105ULL, 0x00014b8c000000ffULL,
0x000135f0003f0105ULL, 0x00014b80000000ffULL, 0x00013680003f0107ULL, 0x00014b80000000ffULL,
0x00013700003f0101ULL, 0x00014b3800000073ULL, 0x00013730003f0101ULL, 0x00014b3c00000073ULL,
0x00013900003f0105ULL, 0x00014b3c00000073ULL, 0x00014530003f0105ULL, 0x00014b88000000ffULL,
0x00014620003f0101ULL, 0x00014b84000000ffULL, 0x000147e0003f0105ULL, 0x00014b84000000ffULL,
0x00014840003f0105ULL, 0x00014b8c000000ffULL, 0x00014a10003f0105ULL, 0x00014b8c000000ffULL,
0x00015cd0003f0105ULL, 0x00014b88000000ffULL, 0x00015d00003f0101ULL, 0x00014b8c000000ffULL,
0x00015ed0003f0105ULL, 0x00014b8c000000ffULL, 0x000160b0003f0105ULL, 0x00014b78000000ffULL,
0x00016130003f0107ULL, 0x00014b78000000ffULL, 0x000167a0003f0101ULL, 0x00014b88000000ffULL,
0x00016840003f0101ULL, 0x00014b70000000ffULL, 0x00019b50003f0101ULL, 0x00014ad0000000ffULL,
0x0001aee0003f0101ULL, 0x00014ad4000000ffULL, 0x0001b0b0003f0105ULL, 0x00014ad4000000ffULL,
0x00023520003f0105ULL, 0x0000000000000073ULL, 0x000238b0003f0101ULL, 0x0000000400000073ULL,
0x00023a80003f0105ULL, 0x0000000400000073ULL, 0x00024ef0003f0105ULL, 0x00014ad800000071ULL,
0x00024f50003f0101ULL, 0x00014ae000000071ULL, 0x00024fb0003f0101ULL, 0x00014ae800000071ULL,
0x00025020003f0101ULL, 0x00014af000000071ULL, 0x00053803003f0101ULL, 0x00019a0000101c04ULL,
0x0001b1b00001b110ULL, 0x0000040100025060ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000036cULL,
0x0000001900000002ULL, 0x00000000000002ccULL, 0x0000001900000002ULL, 0x0000000000000234ULL,
0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL, 0x00000000000000fcULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000345ULL,
0x0000001900000002ULL, 0x00000000000002a8ULL, 0x0000001900000002ULL, 0x0000000000000210ULL,
0x0000001900000002ULL, 0x0000000000000175ULL, 0x0000001900000002ULL, 0x00000000000000d5ULL,
0x0000001900000002ULL, 0x0000000000014c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000117919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000200ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001300057300ULL, 0x000ee200000e0000ULL, 0x0000000204047899ULL, 0x000fe4000800063fULL,
0x0000000000037919ULL, 0x000f220000002200ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x0000000000147919ULL, 0x000ee20000000000ULL, 0x0000001300137309ULL, 0x000ee60000000000ULL,
0x0000000000067919ULL, 0x000ee20000000000ULL, 0x00000005ff797819ULL, 0x002fc60000011611ULL,
0x00001fff04027589ULL, 0x004fe800000e0000ULL, 0x00001fff79797589ULL, 0x000e6200000e0000ULL,
0x0000010004007a24ULL, 0x010fc600078e0203ULL, 0x0000000000037919ULL, 0x000ea20000002600ULL,
0x0000000000117a24ULL, 0x000fc600078e0211ULL, 0x0000000000007919ULL, 0x000ea20000002700ULL,
0x000000060500720cULL, 0x008fe40003f02070ULL, 0x000000ff1100720cULL, 0x040fe40003f25270ULL,
0x0000000f1100780cULL, 0x040fe40003f44070ULL, 0x000000031100780cULL, 0x040fe40003f64070ULL,
0x0000007f1100780cULL, 0x000fe20003f84070ULL, 0x0000000402047824ULL, 0x002fcc00078e0279ULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x3fffffc00006a802ULL, 0x000fe20000000f00ULL,
0x00000002040b7824ULL, 0x000fe400078e00ffULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x000000010b0a7824ULL, 0x040fe200078e0214ULL, 0x000000040b0c7817ULL, 0x040fe20007800000ULL,
0x000000200b0d7824ULL, 0x040fe200078e00ffULL, 0x014ad004ff009388ULL, 0x0003e20000000a00ULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x0000000c0b0c7210ULL, 0x000fe20007ffe1ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0xffffffe00d107812ULL, 0x000fe200078ee20aULL,
0x00000004000a7c24ULL, 0x044fe2000f8e0203ULL, 0x000000010b0d7810ULL, 0x000fe20007ffe0ffULL,
0x014ad8061100a388ULL, 0x0005e20000008a00ULL, 0x000000011100780cULL, 0x000fe20003f44070ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000010d057824ULL, 0x042fe200078e0214ULL, 0x0000000200777819ULL, 0x000fe200000006ffULL,
0x000000200d127824ULL, 0x000fe200078e00ffULL, 0x014b58081100b388ULL, 0x0003e20000008a00ULL,
0x000058000b047a24ULL, 0x000fe200078e020aULL, 0x000000ff0c00720cULL, 0x000fe20003f63070ULL,
0xff317217ff0ec424ULL, 0x000fe200078e00ffULL, 0xffffffe012127812ULL, 0x000fe200078ee205ULL,
0x0000001014067824ULL, 0x004fc400078e00ffULL, 0x000058000d077a24ULL, 0x000fe200078e020aULL,
0x0144000e1100c388ULL, 0x0005e20000004800ULL, 0x00005c0004047625ULL, 0x080fe200078e000fULL,
0x000001f0060b7812ULL, 0x000fe400078ec0ffULL, 0x000000010c00780cULL, 0x000fe20003f83070ULL,
0x00005c0007067625ULL, 0x000fe200078e000fULL, 0x0000000b04087210ULL, 0x082fe40007fbe0ffULL,
0x7fffff80000f9802ULL, 0x000fe20000000f00ULL, 0x3fffff00ff0ca424ULL, 0x000fe200078e00ffULL,
0x0000000b060a7210ULL, 0x000fe20007fde0ffULL, 0x7fffff00ff0da424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff0e9424ULL, 0x004fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e0607ULL,
0x014b780c1100a388ULL, 0x000fe20000008a00ULL, 0x000000ffff047224ULL, 0x000fe400078e0a13ULL,
0x000000ffff097224ULL, 0x000fe200028e0605ULL, 0x014b880eff009388ULL, 0x000fe20000000a00ULL,
0x0000001010077824ULL, 0x000fe400078e00ffULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0003e2000d901c46ULL,
0x00000004ff107424ULL, 0x000fc400078e00ffULL, 0x00000004ff7b7e24ULL, 0x008fe2000f8e00ffULL,
0x000000000a137faeULL, 0x0005e2000e101c46ULL, 0x0000620077047625ULL, 0x000fc600078e0010ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x014ad40cffff038cULL, 0x0005e20000000200ULL,
0x00006a0077067625ULL, 0x002fc600078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x014ad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000604757981ULL, 0x000ee8000c1e1900ULL,
0x0000000606067981ULL, 0x000f22000c1e1900ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x0000003f75767810ULL, 0x048fe40007ffe0ffULL,
0x000000ff75747810ULL, 0x000fc40007ffe0ffULL, 0x00000008ff727819ULL, 0x010fe40000011606ULL,
0x00000006ff767819ULL, 0x000fe40000011676ULL, 0x00000008ff747819ULL, 0x000fc60000011674ULL,
0x000193c000008947ULL, 0x000fea0003800000ULL, 0x0000002079077824ULL, 0x040fe200078e0214ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000879737824ULL, 0x000fe200078e00ffULL,
0x000000027b717819ULL, 0x000fe200000006ffULL, 0x00000003ff0a7424ULL, 0x004fe200078e00ffULL,
0x0000001f0700780cULL, 0x000fe20003f04070ULL, 0x000001007b067824ULL, 0x000fe200078e00ffULL,
0x000000030700780cULL, 0x000fd60003f24070ULL, 0x0000007000000947ULL, 0x000fea0003800000ULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x00014a0007097811ULL, 0x000fe200078e10ffULL,
0x0000680077047a24ULL, 0x000fc600078e0206ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000107047824ULL, 0x000fc800078e0204ULL, 0x0000660004047625ULL, 0x000fd000078e0010ULL,
0x0000000004097faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b5c0a73ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b580073ff7f8cULL, 0x0007e2000c80043fULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000b000001947ULL, 0x000fea0003800000ULL,
0x0000000400047824ULL, 0x002fe200078e0207ULL, 0x0000640071057a10ULL, 0x040fe40007ffe0ffULL,
0x000000767100720cULL, 0x000fe20003f06070ULL, 0x0000000204047824ULL, 0x000fe200078e00ffULL,
0x00014ac007077811ULL, 0x000fc600078e10ffULL, 0x0000640004047a24ULL, 0x000fc800078e0205ULL,
0x0000600004047625ULL, 0x000fca00078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff047f8cULL, 0x002e62000c80043fULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x00000005000a7202ULL, 0x006fc40000000f00ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x014b8c00ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000804087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011409ULL,
0x0000000807077211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000207077819ULL, 0x000fc80000001208ULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x014b8c00ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000017b057810ULL, 0x000fe20007ffe0ffULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000740500720cULL, 0x000fda0003f06070ULL,
0x0000099000008947ULL, 0x000fea0003800000ULL, 0x00000004730a7824ULL, 0x000fe200078e00ffULL,
0x0000000000107919ULL, 0x000e620000000000ULL, 0x0000000675057217ULL, 0x000fe20007800000ULL,
0x00000040030c7824ULL, 0x000fe200078e0273ULL, 0x0000020000117802ULL, 0x000fe20000000f00ULL,
0x014a00000a047984ULL, 0x000ea20000000800ULL, 0x00000020730e7824ULL, 0x040fe200078e00ffULL,
0x00000001730d7810ULL, 0x040fe20007ffe0ffULL, 0x00000010100b7824ULL, 0x002fe400078e00ffULL,
0x0000000173097824ULL, 0x000fc600078e0210ULL, 0x000001f00b137812ULL, 0x000fe200078ec0ffULL,
0x0000000404087824ULL, 0x004fe400078e00ffULL, 0x0000000105047824ULL, 0x000fc600078e0a06ULL,
0x014ac00008077984ULL, 0x000e640000000800ULL, 0x0000000473047217ULL, 0x000fe20007800000ULL,
0x0000000407057c24ULL, 0x002fc8000f8e020cULL, 0x0000000104077824ULL, 0x000fe400078e0a73ULL,
0x00005e0005047625ULL, 0x000fc600078e0011ULL, 0x000000ff0700720cULL, 0x000fe40003f03070ULL,
0x0000001304087210ULL, 0x000fe40007f3e0ffULL, 0xffffffe00e047812ULL, 0x000fe400078ee209ULL,
0x000000100d0e7210ULL, 0x040fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x0000c000040b7811ULL, 0x000fe200078e20ffULL, 0x000000200d0d7824ULL, 0x000fe200078e00ffULL,
0x000000010c057810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000010700780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0e7812ULL, 0x000fe200078ee20eULL, 0x014a04000a047984ULL, 0x000ea20000000800ULL,
0x00000002730d7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0000e0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0e7824ULL, 0x040fe400078e0210ULL, 0x000000200d0d7824ULL, 0x000fca00078e00ffULL,
0xffffffe00d0e7812ULL, 0x000fe400078ee20eULL, 0x00000003730d7810ULL, 0x000fe20007ffe0ffULL,
0x00000004040f7824ULL, 0x004fca00078e00ffULL, 0x014ac0000f047984ULL, 0x000e640000000800ULL,
0x0000000404047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000020c057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000020700780cULL, 0x000fc60003f03070ULL,
0x014a08000a047984ULL, 0x000ea20000000800ULL, 0x0000c0000e0b7811ULL, 0x002fe200078e20ffULL,
0x000000010d0e7824ULL, 0x040fe400078e0210ULL, 0x000000200d0d7824ULL, 0x000fca00078e00ffULL,
0xffffffe00d0e7812ULL, 0x000fe400078ee20eULL, 0x00000004730d7810ULL, 0x000fe20007ffe0ffULL,
0x00000004040f7824ULL, 0x004fca00078e00ffULL, 0x014ac0000f047984ULL, 0x000e640000000800ULL,
0x0000000404047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000030c057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000030700780cULL, 0x000fc60003f03070ULL,
0x014a0c000a047984ULL, 0x000ea20000000800ULL, 0x0000c0000e0b7811ULL, 0x002fe200078e20ffULL,
0x000000010d0e7824ULL, 0x040fe400078e0210ULL, 0x000000200d0d7824ULL, 0x000fca00078e00ffULL,
0xffffffe00d0e7812ULL, 0x000fe400078ee20eULL, 0x00000005730d7810ULL, 0x000fe40007ffe0ffULL,
0x00000002040f7819ULL, 0x004fca00000006ffULL, 0x014ac0000f047984ULL, 0x000e640000000800ULL,
0x0000000404047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000040c057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000040700780cULL, 0x000fc60003f03070ULL,
0x014a10000a047984ULL, 0x000ea20000000800ULL, 0x0000c0000e0b7811ULL, 0x002fe200078e20ffULL,
0x000000010d0e7824ULL, 0x040fe400078e0210ULL, 0x000000200d0d7824ULL, 0x000fca00078e00ffULL,
0xffffffe00d0e7812ULL, 0x000fe400078ee20eULL, 0x00000006730d7810ULL, 0x000fe20007ffe0ffULL,
0x00000004040f7824ULL, 0x004fca00078e00ffULL, 0x014ac0000f047984ULL, 0x000e640000000800ULL,
0x0000000404047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fc80007f3e0ffULL, 0x00000005ff097210ULL, 0x000fe40000ffe4ffULL,
0x000000050c057810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000050700780cULL, 0x000fc60003f03070ULL,
0x014a14000a047984ULL, 0x000ea20000000800ULL, 0x0000c0000e0b7811ULL, 0x002fe200078e20ffULL,
0x000000010d0e7824ULL, 0x040fe200078e0210ULL, 0x000000050d0d7819ULL, 0x000fc800000006ffULL,
0xffffffe00d0e7812ULL, 0x000fe200078ee20eULL, 0x00000004040f7824ULL, 0x004fca00078e00ffULL,
0x014ac0000f047984ULL, 0x000e640000000800ULL, 0x0000000404047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0605ULL, 0x000000060c057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x000000060700780cULL, 0x000fc60003f03070ULL, 0x014a18000a047984ULL, 0x000ea20000000800ULL,
0x0000c0000e0b7811ULL, 0x002fe200078e20ffULL, 0x00000004040f7824ULL, 0x004fca00078e00ffULL,
0x014ac0000f047984ULL, 0x000e640000000800ULL, 0x0000000404047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0605ULL, 0x000000070c057810ULL, 0x000fe40007ffe0ffULL,
0x00000007730c7810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000070700780cULL, 0x000fe40003f03070ULL,
0x000000010c0d7824ULL, 0x040fe200078e0210ULL, 0x014a1c000a0a7984ULL, 0x000ea20000000800ULL,
0x000000200c0c7824ULL, 0x000fca00078e00ffULL, 0xffffffe00c0d7812ULL, 0x000fc800078ee20dULL,
0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL, 0x000000040a0e7824ULL, 0x004fca00078e00ffULL,
0x014ac0000e047984ULL, 0x000ea40000000800ULL, 0x0000000404047c24ULL, 0x004fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000c101c46ULL, 0x0000084000007947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x000e620000000000ULL, 0x0000020000117802ULL, 0x000fe40000000f00ULL,
0x000000730f0c7211ULL, 0x042fe200078fd8ffULL, 0x000000100f057824ULL, 0x000fc800078e00ffULL,
0x014a00000c077984ULL, 0x000e620000004800ULL, 0x00000040030e7824ULL, 0x000fe200078e020cULL,
0x000001f005137812ULL, 0x000fe200078ec0ffULL, 0x000000010c097824ULL, 0x040fe400078e020fULL,
0x000000200c0a7824ULL, 0x000fe200078e00ffULL, 0x014ac00007077984ULL, 0x002e640000004800ULL,
0x0000000407047c24ULL, 0x002fc8000f8e020eULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fe40007f1e0ffULL, 0xffffffe00a047812ULL, 0x000fe400078ee209ULL,
0x000000010c0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000c00004077811ULL, 0x000fe400078e20ffULL, 0x000000010e047810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x040fe400078e020fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008077faeULL, 0x0003e2000b901c46ULL, 0x000000200a107824ULL, 0x000fc600078e00ffULL,
0x014a04000c0d7984ULL, 0x000ea20000004800ULL, 0x000000020c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e020fULL, 0x014ac0000d0d7984ULL, 0x004e640000004800ULL,
0x000000040d047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x00000013040a7210ULL, 0x000fe40007f1e0ffULL, 0xffffffe010047812ULL, 0x000fe200078ee20bULL,
0x0000002008107824ULL, 0x000fe200078e00ffULL, 0x00000005ff0b7210ULL, 0x000fe400007fe4ffULL,
0x0000c00004077811ULL, 0x000fe400078e20ffULL, 0x000000020e047810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a077faeULL, 0x0003e8000b901c46ULL,
0x014a08000c0d7984ULL, 0x000ea20000004800ULL, 0x000000030c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e020fULL, 0x014ac0000d0d7984ULL, 0x004e640000004800ULL,
0x000000040d047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fe40007f1e0ffULL, 0xffffffe010047812ULL, 0x000fe200078ee209ULL,
0x000000200a107824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000c00004077811ULL, 0x000fe400078e20ffULL, 0x000000030e047810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0003e8000b901c46ULL,
0x014a0c000c0d7984ULL, 0x000ea20000004800ULL, 0x000000040c087810ULL, 0x002fc80007ffe0ffULL,
0x0000000f08097210ULL, 0x000fe20007ffe0ffULL, 0x014ac0000d0d7984ULL, 0x004e640000004800ULL,
0x000000040d047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x00000013040a7210ULL, 0x000fe40007f1e0ffULL, 0xffffffe010047812ULL, 0x000fe200078ee20bULL,
0x0000002008107824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000c00004077811ULL, 0x000fe400078e20ffULL, 0x000000040e047810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a077faeULL, 0x0003e8000b901c46ULL,
0x014a10000c0d7984ULL, 0x000ea20000004800ULL, 0x000000050c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e020fULL, 0x014ac0000d0d7984ULL, 0x004e640000004800ULL,
0x000000040d047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fe40007f1e0ffULL, 0xffffffe010047812ULL, 0x000fe200078ee209ULL,
0x000000200a107824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000c00004077811ULL, 0x000fe400078e20ffULL, 0x000000050e047810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0003e8000b901c46ULL,
0x014a14000c0d7984ULL, 0x000ea20000004800ULL, 0x000000060c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e020fULL, 0x014ac0000d0d7984ULL, 0x004e640000004800ULL,
0x000000040d047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x00000013040a7210ULL, 0x000fe40007f1e0ffULL, 0xffffffe010047812ULL, 0x000fe400078ee20bULL,
0x0000000508107819ULL, 0x000fe200000006ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000c00004077811ULL, 0x000fe400078e20ffULL, 0x000000060e047810ULL, 0x040fe40007ffe0ffULL,
0x000000070e0e7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a077faeULL, 0x0003e8000b901c46ULL, 0x014a18000c0d7984ULL, 0x000ea20000004800ULL,
0x000000070c0a7810ULL, 0x002fc60007ffe0ffULL, 0x014ac0000d0d7984ULL, 0x004e640000004800ULL,
0x000000040d047c24ULL, 0x002fe4000f8e0204ULL, 0x000000010a0d7824ULL, 0x000fe400078e020fULL,
0x00005e0004047625ULL, 0x000fc800078e0011ULL, 0x000000200a0a7824ULL, 0x000fe200078e00ffULL,
0x0000001304087210ULL, 0x000fe40007f1e0ffULL, 0xffffffe010047812ULL, 0x000fe400078ee209ULL,
0xffffffe00a0d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000c00004077811ULL, 0x000fe400078e20ffULL, 0x0000c0000d0d7811ULL, 0x000fc600078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0003e8000b901c46ULL,
0x014a1c000c0b7984ULL, 0x000ea80000004800ULL, 0x014ac0000b0b7984ULL, 0x004ea40000004800ULL,
0x000000040b047c24ULL, 0x004fc8000f8e020eULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e6000b901c46ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff047f8cULL, 0x002e64000c80043fULL,
0x000000ffff0a7224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x014b8c00ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000804087210ULL, 0x000fc80007f1e1ffULL,
0x0000000905097210ULL, 0x000fe400007fe5ffULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011409ULL,
0x0000000807077211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000207077819ULL, 0x000fc80000001208ULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x014b8c00ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002079057824ULL, 0x002fca00078e0204ULL, 0x0000001f0500780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000002006067810ULL, 0x000fe20007ffe0ffULL,
0x00000004ff077424ULL, 0x000fc800078e00ffULL, 0x0000000105087824ULL, 0x100fe400078e0206ULL,
0x0000680077067a24ULL, 0x000fc600078e0206ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000105067824ULL, 0x040fe200078e0206ULL, 0x00014a0005057811ULL, 0x000fc600078e10ffULL,
0x0000660006067625ULL, 0x000fd000078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b7800ff067f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff087f8cULL, 0x000ea2000c80043fULL, 0x000000747b00720cULL, 0x000fe20003f06070ULL,
0x000000ffff897224ULL, 0x002fe200078e0007ULL, 0x00000000006c7805ULL, 0x000fe2000001ff00ULL,
0xff317217ff6f7424ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x0000001f001f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff207424ULL, 0x000fe200078e00ffULL,
0x0000000900377202ULL, 0x004fc40000000f00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0001447000000947ULL, 0x000fea0003800000ULL, 0x00005800ff217624ULL, 0x000fe200078e00ffULL,
0x0001445000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe400078e00ffULL,
0xff317217ff6f7424ULL, 0x000fe400078e00ffULL, 0x0000004021217824ULL, 0x000fc400078e00ffULL,
0x000001007b227824ULL, 0x000fca00078e00ffULL, 0x000000752200720cULL, 0x000fda0003f06070ULL,
0x000143a000000947ULL, 0x008fea0003800000ULL, 0x000000ff008b7202ULL, 0x000fc40000000f00ULL,
0x0000007b7200720cULL, 0x000fe20003fa4070ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000002ff227819ULL, 0x000fe2000001168bULL, 0x000000ffff2e7224ULL, 0x000fc600078e00ffULL,
0x000000228b287207ULL, 0x040fe40002800000ULL, 0x000000038b227812ULL, 0x000fe400078ec0ffULL,
0x00000002ff2a7819ULL, 0x000fe40000011628ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000328287812ULL, 0x000fe200078ec0ffULL, 0x000003002a297a24ULL, 0x000fc400078e027bULL,
0x00000000002a7805ULL, 0x000fca0000015200ULL, 0x014b7c00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fc40007804889ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c2a2c7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e2bULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc8000001142dULL,
0x0000002c23237211ULL, 0x000fca00078110ffULL, 0x000000ffff2c7224ULL, 0x000fca00000e062dULL,
0x0000000223237819ULL, 0x000fc8000000122cULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b7c00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fc40000015200ULL, 0x014b8c00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2c7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001142dULL, 0x0000002c23237211ULL, 0x000fca00078110ffULL,
0x000000ffff2c7224ULL, 0x000fca00000e062dULL, 0x0000000223237819ULL, 0x000fc8000000122cULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000129237810ULL, 0x000fe20007ffe0ffULL,
0x0000122000017945ULL, 0x000fe60003800000ULL, 0x000000742300720cULL, 0x000fda0003f06070ULL,
0x000009b000008947ULL, 0x000fea0003800000ULL, 0x0000000273347819ULL, 0x000fe200000006ffULL,
0x00000004292a7824ULL, 0x000fe200078e0228ULL, 0x00000020032e7811ULL, 0x000fe200078e30ffULL,
0x00000200ff357424ULL, 0x000fe200078e00ffULL, 0x00000004732f7210ULL, 0x040fe20007ffe0ffULL,
0x014a000034237984ULL, 0x000e620000000800ULL, 0x000000202a2a7811ULL, 0x000fe200078e30ffULL,
0x00000001732b7824ULL, 0x040fe200078e022eULL, 0x0000000173397810ULL, 0x040fe20007ffe0ffULL,
0x00000010042d7824ULL, 0x000fe400078e00ffULL, 0x0000002073307824ULL, 0x000fc400078e00ffULL,
0x0000000139367824ULL, 0x000fe200078e0204ULL, 0x000001f02d377812ULL, 0x000fe400078ec0ffULL,
0xffffffe0302f7812ULL, 0x000fc800078ee22fULL, 0x000100002f2f7811ULL, 0x000fe200078e20ffULL,
0x00000004232c7824ULL, 0x002fe200078e00ffULL, 0x0000002a75237217ULL, 0x000fca0007800000ULL,
0x014ac0002c2c7984ULL, 0x000e620000000800ULL, 0x00000001232a7824ULL, 0x000fca00078e0a2aULL,
0x0000002a732a7217ULL, 0x000fca0007800000ULL, 0x000000012a237824ULL, 0x000fca00078e0a73ULL,
0x000000ff2300720cULL, 0x000fe20003f03070ULL, 0x0000002c212b7224ULL, 0x002fc800078e022bULL,
0x00005e002b2a7625ULL, 0x000fca00078e0035ULL, 0x000000372a2c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe400008e062bULL, 0x00000001392b7824ULL, 0x040fe200078e022eULL,
0x0000000539397819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e2000c101c46ULL, 0x000000012300780cULL, 0x000fc60003f03070ULL,
0x014a0400342a7984ULL, 0x000ea20000000800ULL, 0xffffffe0392f7812ULL, 0x002fe400078ee236ULL,
0x0000000273397810ULL, 0x000fe40007ffe0ffULL, 0x000100002f2f7811ULL, 0x000fc600078e20ffULL,
0x0000000139367824ULL, 0x000fe400078e0204ULL, 0x000000042a307824ULL, 0x004fca00078e00ffULL,
0x014ac000302a7984ULL, 0x000e640000000800ULL, 0x0000002a212a7224ULL, 0x002fc800078e022bULL,
0x00005e002a2a7625ULL, 0x000fca00078e0035ULL, 0x000000372a2c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe400008e062bULL, 0x00000001392b7824ULL, 0x040fe400078e022eULL,
0x0000002039397824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e2000c101c46ULL, 0x000000022300780cULL, 0x000fc60003f03070ULL,
0x014a0800342a7984ULL, 0x000ea20000000800ULL, 0xffffffe0392f7812ULL, 0x002fe400078ee236ULL,
0x0000000373397810ULL, 0x000fe40007ffe0ffULL, 0x000100002f2f7811ULL, 0x000fc600078e20ffULL,
0x0000000139367824ULL, 0x000fe400078e0204ULL, 0x000000042a307824ULL, 0x004fca00078e00ffULL,
0x014ac000302a7984ULL, 0x000e640000000800ULL, 0x0000002a212a7224ULL, 0x002fc800078e022bULL,
0x00005e002a2a7625ULL, 0x000fca00078e0035ULL, 0x000000372a2c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe400008e062bULL, 0x00000001392b7824ULL, 0x040fe400078e022eULL,
0x0000002039397824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e2000c101c46ULL, 0x000000032300780cULL, 0x000fc60003f03070ULL,
0x014a0c00342a7984ULL, 0x000ea20000000800ULL, 0xffffffe0392f7812ULL, 0x002fe400078ee236ULL,
0x0000000473397810ULL, 0x000fe40007ffe0ffULL, 0x000100002f2f7811ULL, 0x000fe400078e20ffULL,
0x0000000439367210ULL, 0x000fe40007ffe0ffULL, 0x000000022a307819ULL, 0x004fca00000006ffULL,
0x014ac000302a7984ULL, 0x000e640000000800ULL, 0x0000002a212a7224ULL, 0x002fc800078e022bULL,
0x00005e002a2a7625ULL, 0x000fca00078e0035ULL, 0x000000372a2c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe400008e062bULL, 0x00000001392b7824ULL, 0x040fe400078e022eULL,
0x0000002039397824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e2000c101c46ULL, 0x000000042300780cULL, 0x000fc60003f03070ULL,
0x014a1000342a7984ULL, 0x000ea20000000800ULL, 0xffffffe0392f7812ULL, 0x002fe400078ee236ULL,
0x0000000573397810ULL, 0x000fe40007ffe0ffULL, 0x000100002f2f7811ULL, 0x000fc600078e20ffULL,
0x0000000139367824ULL, 0x000fe400078e0204ULL, 0x000000042a307824ULL, 0x004fca00078e00ffULL,
0x014ac000302a7984ULL, 0x000e640000000800ULL, 0x0000002a212a7224ULL, 0x002fc800078e022bULL,
0x00005e002a2a7625ULL, 0x000fca00078e0035ULL, 0x000000372a2c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe400008e062bULL, 0x00000001392b7824ULL, 0x040fe400078e022eULL,
0x0000002039397824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e2000c101c46ULL, 0x000000052300780cULL, 0x000fc60003f03070ULL,
0x014a1400342a7984ULL, 0x000ea20000000800ULL, 0xffffffe0392f7812ULL, 0x002fe400078ee236ULL,
0x0000000673397810ULL, 0x000fe40007ffe0ffULL, 0x000100002f2f7811ULL, 0x000fc600078e20ffULL,
0x0000000139367824ULL, 0x000fe400078e0204ULL, 0x000000042a307824ULL, 0x004fca00078e00ffULL,
0x014ac000302a7984ULL, 0x000e640000000800ULL, 0x0000002a212a7224ULL, 0x002fc800078e022bULL,
0x00005e002a2a7625ULL, 0x000fca00078e0035ULL, 0x000000372a2c7210ULL, 0x000fc80007f3e0ffULL,
0x0000002bff2d7210ULL, 0x000fe20000ffe4ffULL, 0x00000001392b7824ULL, 0x040fe400078e022eULL,
0x0000002039397824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e2000c101c46ULL, 0x000000062300780cULL, 0x000fc60003f03070ULL,
0x014a1800342a7984ULL, 0x000ea20000000800ULL, 0xffffffe0392f7812ULL, 0x002fe400078ee236ULL,
0x0000000773397810ULL, 0x000fe40007ffe0ffULL, 0x000100002f2f7811ULL, 0x000fe400078e20ffULL,
0x0000002e392e7210ULL, 0x000fe20007ffe0ffULL, 0x000000042a307824ULL, 0x004fca00078e00ffULL,
0x014ac000302a7984ULL, 0x000e640000000800ULL, 0x0000002a212a7224ULL, 0x002fc800078e022bULL,
0x00005e002a2a7625ULL, 0x000fca00078e0035ULL, 0x000000372a2c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fca00008e062bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e2000c101c46ULL, 0x000000072300780cULL, 0x000fe20003f03070ULL,
0x0000002039237824ULL, 0x000fe400078e00ffULL, 0x014a1c00342a7984ULL, 0x000ea40000000800ULL,
0x000000042a307824ULL, 0x004fca00078e00ffULL, 0x014ac000302a7984ULL, 0x000ea40000000800ULL,
0x0000002a212a7224ULL, 0x004fe400078e022eULL, 0x00000001392e7824ULL, 0x000fe400078e0204ULL,
0x00005e002a2a7625ULL, 0x000fc600078e0035ULL, 0xffffffe023237812ULL, 0x000fe400078ee22eULL,
0x000000372a2a7210ULL, 0x000fe40007f3e0ffULL, 0x0001000023237811ULL, 0x000fc600078e20ffULL,
0x000000ffff2b7224ULL, 0x000fca00008e062bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a237faeULL, 0x0003e2000c101c46ULL, 0x0000084000007947ULL, 0x000fea0003800000ULL,
0x0000007304357211ULL, 0x040fe200078fd8ffULL, 0x00000010042c7824ULL, 0x000fe200078e00ffULL,
0x0000002003347811ULL, 0x000fe200078e30ffULL, 0x00000200ff377424ULL, 0x000fe200078e00ffULL,
0x00000004352d7210ULL, 0x040fe20007ffe0ffULL, 0x014a000035237984ULL, 0x000e620000004800ULL,
0x000001f02c397812ULL, 0x000fe200078ec0ffULL, 0x00000001352b7824ULL, 0x040fe200078e0234ULL,
0x00000001352f7810ULL, 0x040fe20007ffe0ffULL, 0x00000020352e7824ULL, 0x000fc800078e00ffULL,
0x000000012f367824ULL, 0x000fe200078e0204ULL, 0x014ac000232a7984ULL, 0x0022a40000004800ULL,
0xffffffe02e237812ULL, 0x002fc800078ee22dULL, 0x0001000023237811ULL, 0x000fe200078e20ffULL,
0x0000002a212a7224ULL, 0x004fc800078e022bULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012f2a7824ULL, 0x040fe400078e0234ULL,
0x000000202f2f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fc600000e062bULL,
0xffffffe02f367812ULL, 0x000fe400078ee236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c237faeULL, 0x0003e8000b901c46ULL, 0x014a040035307984ULL, 0x000ea20000004800ULL,
0x0001000036237811ULL, 0x002fe400078e20ffULL, 0x00000002352d7810ULL, 0x000fca0007ffe0ffULL,
0x000000012d367824ULL, 0x000fe200078e0204ULL, 0x014ac00030307984ULL, 0x004e640000004800ULL,
0x00000030212a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2e7210ULL, 0x000fe40007f1e0ffULL, 0x000000342d2a7210ULL, 0x040fe20007ffe0ffULL,
0x000000202d2d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fc600000e062bULL,
0xffffffe02d367812ULL, 0x000fe400078ee236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e237faeULL, 0x0003e8000b901c46ULL, 0x014a080035307984ULL, 0x000ea20000004800ULL,
0x0001000036237811ULL, 0x002fe400078e20ffULL, 0x00000003352f7810ULL, 0x000fca0007ffe0ffULL,
0x000000012f367824ULL, 0x000fe200078e0204ULL, 0x014ac00030307984ULL, 0x004e640000004800ULL,
0x00000030212a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012f2a7824ULL, 0x040fe400078e0234ULL,
0x000000202f2f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fc600000e062bULL,
0xffffffe02f367812ULL, 0x000fe400078ee236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c237faeULL, 0x0003e8000b901c46ULL, 0x014a0c0035307984ULL, 0x000ea20000004800ULL,
0x0001000036237811ULL, 0x002fe400078e20ffULL, 0x00000004352d7810ULL, 0x000fca0007ffe0ffULL,
0x000000012d367824ULL, 0x000fe200078e0204ULL, 0x014ac00030307984ULL, 0x004e640000004800ULL,
0x00000030212a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000012d2a7824ULL, 0x040fe400078e0234ULL,
0x000000202d2d7824ULL, 0x000fe200078e00ffULL, 0x0000002bff2f7210ULL, 0x000fc800007fe4ffULL,
0xffffffe02d367812ULL, 0x000fe200078ee236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e237faeULL, 0x0003e8000b901c46ULL, 0x014a100035307984ULL, 0x000ea20000004800ULL,
0x0001000036237811ULL, 0x002fe400078e20ffULL, 0x00000005352f7810ULL, 0x000fca0007ffe0ffULL,
0x000000012f367824ULL, 0x000fe200078e0204ULL, 0x014ac00030307984ULL, 0x004e640000004800ULL,
0x00000030212a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012f2a7824ULL, 0x040fe200078e0234ULL,
0x000000052f2f7819ULL, 0x000fc600000006ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e062bULL,
0xffffffe02f367812ULL, 0x000fc800078ee236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c237faeULL, 0x0003e8000b901c46ULL, 0x014a140035307984ULL, 0x000ea20000004800ULL,
0x0001000036237811ULL, 0x002fe400078e20ffULL, 0x00000006352d7810ULL, 0x000fca0007ffe0ffULL,
0x000000012d367824ULL, 0x000fe200078e0204ULL, 0x014ac00030307984ULL, 0x004e640000004800ULL,
0x00000030212a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000012d2a7824ULL, 0x040fe400078e0234ULL,
0x000000202d2d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fc600000e062bULL,
0xffffffe02d367812ULL, 0x000fe400078ee236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e237faeULL, 0x0003e8000b901c46ULL, 0x014a180035307984ULL, 0x000ea20000004800ULL,
0x0001000036237811ULL, 0x002fe400078e20ffULL, 0x00000007352f7810ULL, 0x000fe20007ffe0ffULL,
0x014ac00030307984ULL, 0x004e640000004800ULL, 0x00000030212a7224ULL, 0x002fe200078e022aULL,
0x000000042f307210ULL, 0x000fc60007ffe0ffULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012f2a7824ULL, 0x040fe400078e0234ULL,
0x000000202f2f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fc600000e062bULL,
0xffffffe02f307812ULL, 0x000fe400078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c237faeULL, 0x0003e8000b901c46ULL, 0x014a1c00352e7984ULL, 0x000ea20000004800ULL,
0x0001000030237811ULL, 0x002fc600078e20ffULL, 0x014ac0002e2e7984ULL, 0x004e640000004800ULL,
0x0000002e212a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a237faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff2a7f8cULL, 0x002e64000c80043fULL, 0x000000ffff2e7224ULL, 0x002fc400078e002bULL,
0x00000000002a7805ULL, 0x000fca0000015200ULL, 0x014b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2c7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001142dULL, 0x0000002c23237211ULL, 0x000fca00078110ffULL,
0x000000ffff2c7224ULL, 0x000fca00000e062dULL, 0x0000000223237819ULL, 0x000fc8000000122cULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012f2f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000297200720cULL, 0x000fe20003f04070ULL,
0x00000004ff2e7424ULL, 0x000fe200078e00ffULL, 0x00000001222b7810ULL, 0x040fe20007ffe0ffULL,
0x00000300ff2d7624ULL, 0x000fe200078e00ffULL, 0x000000032200780cULL, 0x000fe20003f45270ULL,
0x000001f000017945ULL, 0x000fe20003800000ULL, 0x000000032b2a7812ULL, 0x000fc400078ec0ffULL,
0x000000297200720cULL, 0x000fe40003f24070ULL, 0x0000000479237211ULL, 0x000fc600078e28ffULL,
0x00000002ff2b8819ULL, 0x000fe4000001162bULL, 0x0000001f2300780cULL, 0x000fc60003f84070ULL,
0x0000000128287824ULL, 0x000fca00078e022bULL, 0x00000002ff227819ULL, 0x000fe20000011628ULL,
0x0000004028287824ULL, 0x000fc800078e00ffULL, 0x00000300222b7a24ULL, 0x000fe200078e0229ULL,
0x000000c0282c7812ULL, 0x000fe200078ec0ffULL, 0xfffffffd2e227424ULL, 0x000fe200078e022dULL,
0x0000012000009947ULL, 0x000fea0001000000ULL, 0x0000002079297824ULL, 0x000fe200078e0204ULL,
0x0000000371287812ULL, 0x000fc800078ec0ffULL, 0x000000032900780cULL, 0x000fe40003f44070ULL,
0x000000032800780cULL, 0x000fc80003f25270ULL, 0x0000000122227807ULL, 0x000fca0004800000ULL,
0x0000000171717824ULL, 0x000fe400078e0222ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000002900227211ULL, 0x000fe400078e10ffULL, 0x00006400712d7a10ULL, 0x040fe40007ffe0ffULL,
0x000000767100720cULL, 0x000fe20003f26070ULL, 0x0000000222227824ULL, 0x000fe200078e00ffULL,
0x00014ac0292f7811ULL, 0x000fc600078e10ffULL, 0x00006400222d7a24ULL, 0x000fc800078e022dULL,
0x000060002d287625ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e4000c921846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000f000017945ULL, 0x000fe20003800000ULL, 0x000001002b2b7824ULL, 0x000fe200078e022cULL,
0x000000ff2a227207ULL, 0x000fe20004000000ULL, 0x000000b000004947ULL, 0x000fea0003800000ULL,
0x0000000123287824ULL, 0x002fe400078e022bULL, 0x0000000177227824ULL, 0x000fc600078e0222ULL,
0x000000752800720cULL, 0x000fe20003f06070ULL, 0x0000680022227a24ULL, 0x000fe200078e022bULL,
0x00014a00232b7811ULL, 0x000fc600078e10ffULL, 0x0000000123227824ULL, 0x000fc800078e0222ULL,
0x0000660022287625ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff8b00720cULL, 0x000fe20003f05270ULL, 0x014b8000ff887f8cULL, 0x000ea2000c80043fULL,
0x0000080000017945ULL, 0x000fe20003800000ULL, 0xffffffffff227424ULL, 0x000fd400078e00ffULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014ad80073287f8cULL, 0x002e64000c80043fULL, 0x00000029002f7202ULL, 0x002fc40000000f00ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x014adc0073247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001142bULL, 0x0000002d24247211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x0000000224247819ULL, 0x000fc8000000122bULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x014adc0073247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001004247824ULL, 0x000fe200078e00ffULL,
0x00000001ff287819ULL, 0x000fc80000011604ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c28297812ULL, 0x000fca00078ec0ffULL, 0x0000000124297824ULL, 0x000fca00078e0229ULL,
0x0140000029287984ULL, 0x000e680000000800ULL, 0x01420000292a7984ULL, 0x0006a20000000800ULL,
0x0000006f2800720bULL, 0x002fe20003f1d000ULL, 0x00020a927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff242e7812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x0000000100247802ULL, 0x000fe20000000f00ULL,
0x000000ffff2c7224ULL, 0x000fd400078e006fULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff7900720cULL, 0x000fe40003f05270ULL, 0x0000006f2800720bULL, 0x000fe20003f34000ULL,
0x00020a527f007947ULL, 0x000fd8000b800000ULL, 0x00000000002b7806ULL, 0x000fc400008e0100ULL,
0x000000286f2c7209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x000099102b2d7816ULL, 0x000fc600000000ffULL, 0x0144002c29008388ULL, 0x0003e20000000800ULL,
0x000000ff2d00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000002c6f297221ULL, 0x002fe20000010000ULL, 0x000000ff2bff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b29297820ULL, 0x000fc80000410000ULL,
0x0000002900307308ULL, 0x000e640000000800ULL, 0x000000301e1e7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011604ULL,
0x000209a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2930297589ULL, 0x0002e400000e0000ULL,
0x000000291d1d7220ULL, 0x088fe20000410000ULL, 0x000000291c1c7220ULL, 0x080fe20000410000ULL,
0x0000002919197220ULL, 0x080fe20000410000ULL, 0x0000002918187220ULL, 0x080fe20000410000ULL,
0x0000002915157220ULL, 0x080fe20000410000ULL, 0x0000002914147220ULL, 0x080fe20000410000ULL,
0x0000002911117220ULL, 0x080fe20000410000ULL, 0x0000002910107220ULL, 0x080fe20000410000ULL,
0x000000290d0d7220ULL, 0x080fe20000410000ULL, 0x000000290c0c7220ULL, 0x080fe20000410000ULL,
0x0000002909097220ULL, 0x080fe20000410000ULL, 0x0000002908087220ULL, 0x080fe20000410000ULL,
0x0000002905057220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x000000296e6e7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff002bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000804297811ULL, 0x000fe200078ff0ffULL,
0x000208a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2930297589ULL, 0x00066400000e0000ULL,
0x000000291b1b7220ULL, 0x082fe20000410000ULL, 0x000000291a1a7220ULL, 0x080fe20000410000ULL,
0x0000002917177220ULL, 0x080fe20000410000ULL, 0x0000002916167220ULL, 0x080fe20000410000ULL,
0x0000002913137220ULL, 0x080fe20000410000ULL, 0x0000002912127220ULL, 0x080fe20000410000ULL,
0x000000290f0f7220ULL, 0x080fe20000410000ULL, 0x000000290e0e7220ULL, 0x080fe20000410000ULL,
0x000000290b0b7220ULL, 0x080fe20000410000ULL, 0x000000290a0a7220ULL, 0x080fe20000410000ULL,
0x0000002907077220ULL, 0x080fe20000410000ULL, 0x0000002906067220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x000000296c6c7220ULL, 0x080fe20000410000ULL,
0x000000296d6d7220ULL, 0x080fe20000410000ULL, 0x0000002970707220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff2eff7812ULL, 0x000fda000780602bULL,
0x8000002c28280221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800250308ULL, 0x000e640000000800ULL,
0x000000252a2a0220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001e2a1e7221ULL, 0x004fe20000010000ULL, 0x000000ffff6f7224ULL, 0x000fc400078e002cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000782c0ffULL,
0x0000014000017945ULL, 0x000fd80003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fe400000000ffULL, 0x00000002ff287819ULL, 0x002fe40000011604ULL,
0x0000541026297816ULL, 0x000fe20000000026ULL, 0x000206d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2829277589ULL, 0x0002e400000e0000ULL, 0x0000000828267810ULL, 0x000fe20007ffe0ffULL,
0x000207027f007947ULL, 0x000fea000b800000ULL, 0x00001f2629267589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010283b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0029ULL, 0x00004b9000347802ULL, 0x000fc40000000f00ULL,
0x0002156000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018283b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x004fe200078e0029ULL,
0x00004be000347802ULL, 0x000fc40000000f00ULL, 0x0002151000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000704817812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000804297812ULL, 0x002fe200078ec0ffULL,
0x000006f000017945ULL, 0x000fe20003800000ULL, 0x0000000881817812ULL, 0x000fc400078ef804ULL,
0x0000000473877810ULL, 0x000fe40007ffe0ffULL, 0x0000008104827211ULL, 0x040fe200078fe0ffULL,
0x00000008812b7824ULL, 0x040fe200078e00ffULL, 0x0000007304837211ULL, 0x040fe200078fe0ffULL,
0x00000008812f7824ULL, 0x000fe200078e00ffULL, 0x0000000729847812ULL, 0x000fe400078ef804ULL,
0x0000008704877211ULL, 0x000fe400078fe0ffULL, 0x00000006738d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000184297824ULL, 0x040fe200078e0283ULL, 0x0000000273857810ULL, 0x000fe20007ffe0ffULL,
0x00000020842a7824ULL, 0x040fe200078e00ffULL, 0xfffffff82b287812ULL, 0x000fe200078ee282ULL,
0x00000001842b7824ULL, 0x000fe200078e0287ULL, 0x0000008d048d7211ULL, 0x000fe200078fe0ffULL,
0x00000020842c7824ULL, 0x000fe200078e00ffULL, 0x0000008504857211ULL, 0x000fe200078fe0ffULL,
0x00000020842d7824ULL, 0x000fe200078e00ffULL, 0xffffffe02a297812ULL, 0x000fc400078ee229ULL,
0xffffffe02c2b7812ULL, 0x000fe200078ee22bULL, 0x00000001842c7824ULL, 0x000fe200078e028dULL,
0x0000a00028347811ULL, 0x000fe400078e20ffULL, 0x00000085842a7210ULL, 0x000fe40007ffe0ffULL,
0x0000c00029297811ULL, 0x000fe400078e20ffULL, 0xffffffe02d2a7812ULL, 0x040fe200078ee22aULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0xffffffe02d2d7812ULL, 0x000fc400078ee22cULL,
0x0000c0002a2a7811ULL, 0x000fe200078e20ffULL, 0x000000002950783bULL, 0x000f220000004200ULL,
0x0000c0002b2b7811ULL, 0x000fe400078e20ffULL, 0x0000c0002d2d7811ULL, 0x000fe200078e20ffULL,
0x000000002a5c783bULL, 0x000ee20000004200ULL, 0x00000002822e7810ULL, 0x000fe40007ffe0ffULL,
0x0000001084307812ULL, 0x008fe200078efcffULL, 0x000000002b64783bULL, 0x000fe20000004200ULL,
0xfffffff82f2c7812ULL, 0x000fc400078ee22eULL, 0x0000000530397819ULL, 0x000fe200000006ffULL,
0x000000002d3c783bULL, 0x000fe20000004200ULL, 0x0000000183807824ULL, 0x100fe200078e0230ULL,
0x0000a0002c387811ULL, 0x000fe200078e20ffULL, 0x00000001857f7824ULL, 0x000fe200078e0230ULL,
0x00000002ff7c7819ULL, 0x000fe20000011604ULL, 0x00000020302e7824ULL, 0x040fe200078e00ffULL,
0xffffffe039807812ULL, 0x000fe200078ee280ULL, 0x00000001877e7824ULL, 0x100fe200078e0230ULL,
0x000000003838783bULL, 0x004ea20000000200ULL, 0x00000020302f7824ULL, 0x000fe200078e00ffULL,
0xffffffe02e7f7812ULL, 0x000fe200078ee27fULL, 0x000000018d7d7824ULL, 0x000fe200078e0230ULL,
0x0000c000802e7811ULL, 0x000fe200078e20ffULL, 0x0000002030447824ULL, 0x000fe200078e00ffULL,
0xffffffe02f7e7812ULL, 0x000fc400078ee27eULL, 0x0000c0007f2f7811ULL, 0x000fe200078e20ffULL,
0x000000002e40783bULL, 0x000ee20000004200ULL, 0xffffffe0447d7812ULL, 0x000fe400078ee27dULL,
0x0000c0007e307811ULL, 0x000fe200078e20ffULL, 0x000000002f44783bULL, 0x000ee20000004200ULL,
0x0000c0007d787811ULL, 0x000fe200078e20ffULL, 0x0000002734349232ULL, 0x082fe40000000000ULL,
0x00000000304c783bULL, 0x000e620000004200ULL, 0x0000002736369232ULL, 0x000fe20000000000ULL,
0x0000008b7c00720cULL, 0x000fe20003f46070ULL, 0x0000002635359232ULL, 0x080fe20000000000ULL,
0x000000007854783bULL, 0x000e620000004200ULL, 0x0000002637379232ULL, 0x000fe20000000000ULL,
0x0000007b7200720cULL, 0x000fc40003fc3070ULL, 0x000000087c7a7810ULL, 0x000fe40007ffe0ffULL,
0x0000007b7200720cULL, 0x000fe40003f03070ULL, 0x000000503448723cULL, 0x010f6200000018ffULL,
0x0000008b7a00720cULL, 0x000fce0003f66070ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x0000002738389232ULL, 0x084fe40000000000ULL, 0x000000273a3a9232ULL, 0x000fe40000000000ULL,
0x0000002639399232ULL, 0x000fc60000000000ULL, 0x000000643460723cULL, 0x000fe200000018ffULL,
0x000000263b3b9232ULL, 0x000fce0000000000ULL, 0x000000523450723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040b6e00000018ffULL, 0x000000018b3d7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000018ffULL, 0x0000003d7c00720cULL, 0x000fc40005746470ULL,
0x0000003d7a00720cULL, 0x000fc60005f66470ULL, 0x000000403848723cULL, 0x048b700000001848ULL,
0x000000423850723cULL, 0x040b700000001850ULL, 0x000000443858723cULL, 0x040b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x0000004c3860723cULL, 0x042b700000001860ULL,
0x0000004e3864723cULL, 0x040b700000001864ULL, 0x000000543868723cULL, 0x040b700000001868ULL,
0x000000563834723cULL, 0x020b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000481d1d7221ULL, 0x000fe20000010000ULL,
0x000000491c1c7221ULL, 0x000fe20000010000ULL, 0x0000005019197221ULL, 0x000fe20000010000ULL,
0x0000005118187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006932327221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x020fe20000010000ULL,
0x000000356e6e7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x0000004a1b1b7221ULL, 0x000fe20000010000ULL, 0x0000004b1a1a7221ULL, 0x000fe20000010000ULL,
0x0000005217177221ULL, 0x000fe20000010000ULL, 0x0000005316167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b6c6c7221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x020fe20000010000ULL, 0x0000003770707221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x0000007b7200720cULL, 0x000fc40003f03070ULL,
0x0000007b7200720cULL, 0x000fe40003fc3070ULL, 0x00000001ff3f7803ULL, 0x000fe40000000000ULL,
0x00000002ff347819ULL, 0x002fe4000001163dULL, 0x00000035003c7202ULL, 0x000fe40000000f00ULL,
0x000000343d367207ULL, 0x040fe40002800000ULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fc40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e027bULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe20007804889ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x014b8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe2000780483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000120000017945ULL, 0x000fe60003800000ULL,
0x000000743700720cULL, 0x000fda0003f06070ULL, 0x000009a000008947ULL, 0x000fea0003800000ULL,
0x0000000273407819ULL, 0x000fe200000006ffULL, 0x0000004003417824ULL, 0x000fe400078e0273ULL,
0x00000200ff437424ULL, 0x000fe400078e00ffULL, 0x014a000040377984ULL, 0x000e620000000800ULL,
0x00000010043a7824ULL, 0x000fe400078e00ffULL, 0x00000020733c7824ULL, 0x000fc600078e00ffULL,
0x000001f03a457812ULL, 0x000fe200078ec0ffULL, 0x0000000437377824ULL, 0x002fca00078e00ffULL,
0x014ac00037387984ULL, 0x000e640000000800ULL, 0x0000003821387224ULL, 0x002fc800078e0241ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000435387824ULL, 0x000fc800078e0236ULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x0000000638387819ULL, 0x000fc800000006ffULL, 0x0000003875377217ULL, 0x000fca0007800000ULL,
0x0000000137387824ULL, 0x000fe400078e0a38ULL, 0x0000000173377824ULL, 0x000fc600078e0204ULL,
0x0000003873387217ULL, 0x000fe40007800000ULL, 0xffffffe03c397812ULL, 0x000fc600078ee237ULL,
0x0000000138377824ULL, 0x000fe200078e0a73ULL, 0x0000c00039477811ULL, 0x000fe400078e20ffULL,
0x0000000141397810ULL, 0x000fe40007ffe0ffULL, 0x000000ff3700720cULL, 0x000fda0003f03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000c101c46ULL,
0x014a040040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0639ULL, 0x0000000173397810ULL, 0x000fe40007ffe0ffULL,
0x000000013700780cULL, 0x000fe40003f03070ULL, 0x0000000439387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000241397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000c101c46ULL,
0x014a080040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0x0000000273397810ULL, 0x000fe40007ffe0ffULL,
0x000000023700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000341397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000c101c46ULL,
0x014a0c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fc80007f1e0ffULL,
0x00000039ff3d7210ULL, 0x000fe400007fe4ffULL, 0x0000000373397810ULL, 0x000fe40007ffe0ffULL,
0x000000033700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000441397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000c101c46ULL,
0x014a100040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0x0000000473397810ULL, 0x000fe40007ffe0ffULL,
0x000000043700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000541397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000c101c46ULL,
0x014a140040387984ULL, 0x000ea40000000800ULL, 0x00000002383e7819ULL, 0x004fca00000006ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0639ULL, 0x0000000573397810ULL, 0x000fe40007ffe0ffULL,
0x000000053700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000641397810ULL, 0x040fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fe400078e20ffULL,
0x0000000741417810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000c101c46ULL, 0x014a180040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fca00078e00ffULL, 0x014ac0003e387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x00000045383a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x0000000673397810ULL, 0x000fe40007ffe0ffULL, 0x000000063700780cULL, 0x000fc60003f03070ULL,
0x0000000139387824ULL, 0x040fe200078e0204ULL, 0x0000000539397819ULL, 0x000fc800000006ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000c101c46ULL,
0x014a1c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383c7824ULL, 0x004fca00078e00ffULL,
0x014ac0003c387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fe200078e0241ULL,
0x0000000773417810ULL, 0x000fc60007ffe0ffULL, 0x00005e0038387625ULL, 0x000fc800078e0043ULL,
0x00000001413e7824ULL, 0x040fe200078e0204ULL, 0x0000004538387210ULL, 0x000fe20007f1e0ffULL,
0x0000002041417824ULL, 0x000fc800078e00ffULL, 0x000000ffff397224ULL, 0x000fe200000e0639ULL,
0x000000073700780cULL, 0x000fe40003f03070ULL, 0xffffffe0413e7812ULL, 0x000fc800078ee23eULL,
0x0000c0003e3b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x00000073043e7211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe200078e00ffULL,
0x00000004043a7819ULL, 0x000fc600000006ffULL, 0x014a00003e377984ULL, 0x000e620000004800ULL,
0x0000004003407824ULL, 0x000fe200078e023eULL, 0x000001f03a437812ULL, 0x000fe400078ec0ffULL,
0x014ac00037387984ULL, 0x002e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013e387824ULL, 0x000fc800078e0204ULL, 0x000000ffff3b7224ULL, 0x000fe400000e0639ULL,
0x000000203e397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000140397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a04003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x000000013e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000240397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x014a08003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fc80007f1e0ffULL, 0x00000039ff3b7210ULL, 0x000fe400007fe4ffULL,
0x000000023e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000340397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a0c003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x000000033e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000440397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x014a10003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x000000043e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000439387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000540397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a14003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x000000053e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000640397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000000740407810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a18003e377984ULL, 0x000ea80000004800ULL,
0x014ac00037387984ULL, 0x004ea40000004800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0x000000063e397810ULL, 0x000fca0007ffe0ffULL,
0x0000000139387824ULL, 0x040fe200078e0204ULL, 0x0000000539397819ULL, 0x000fc800000006ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x014a1c003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0240ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x000000073e417810ULL, 0x000fc80007ffe0ffULL, 0x0000004338387210ULL, 0x000fe20007f1e0ffULL,
0x00000001413c7824ULL, 0x040fe400078e0204ULL, 0x0000002041417824ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fc600000e0639ULL, 0xffffffe0413c7812ULL, 0x000fc800078ee23cULL,
0x0000c0003c3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000037ff7812ULL, 0x002fe2000780483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fc800078110ffULL, 0x0000003bff3a7210ULL, 0x000fc800007fe4ffULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000357200720cULL, 0x000fc80003f04070ULL, 0x000000ff34377207ULL, 0x040fe40000000000ULL,
0x000000ff34387207ULL, 0x000fc60004000000ULL, 0x0000000136377824ULL, 0x000fca00078e0237ULL,
0x00000002ff347819ULL, 0x000fe20000011637ULL, 0x0000004037377824ULL, 0x000fc800078e00ffULL,
0x0000030034347a24ULL, 0x000fe200078e0235ULL, 0x000000c037377812ULL, 0x000fe200078ec0ffULL,
0x0000000177357824ULL, 0x000fc800078e0238ULL, 0x0000010034347824ULL, 0x000fe200078e0237ULL,
0x00014a0023377811ULL, 0x000fc800078e10ffULL, 0x0000002034367810ULL, 0x000fca0007ffe0ffULL,
0x0000680035347a24ULL, 0x000fe200078e0236ULL, 0x0000003623367210ULL, 0x040fe20007ffe0ffULL,
0x00000004ff357424ULL, 0x000fe400078e00ffULL, 0x0000000123347824ULL, 0x000fe200078e0234ULL,
0x000000753600720cULL, 0x000fc60003f06070ULL, 0x0000660034347625ULL, 0x000fd400078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff887f8cULL, 0x000e62000c80043fULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x0001e1a27f007947ULL, 0x000fea000b800000ULL, 0x00001f7c37277589ULL, 0x0004e400000e0000ULL,
0x0001e1e27f007947ULL, 0x000fea000b800000ULL, 0x00001f7a37267589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000107c3b7810ULL, 0x002fe40007ffe0ffULL,
0x00000037003a7202ULL, 0x000fe40000000f00ULL, 0x0000717000347802ULL, 0x000fc40000000f00ULL,
0x0001ef8000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL,
0x000071c000347802ULL, 0x000fc40000000f00ULL, 0x0001ef3000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000881357824ULL, 0x000fe200078e00ffULL,
0x0000000482867810ULL, 0x000fe20007ffe0ffULL, 0x00000001848d7824ULL, 0x040fe200078e028dULL,
0x00000005843a7819ULL, 0x044fe200000006ffULL, 0x0000000184877824ULL, 0x040fe200078e0287ULL,
0xfffffff835867812ULL, 0x000fe200078ee286ULL, 0x0000000184857824ULL, 0x040fe200078e0285ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000184837824ULL, 0x000fe200078e0283ULL,
0x0000a00086347811ULL, 0x000fe200078e20ffULL, 0x0000002084387824ULL, 0x000fe200078e00ffULL,
0xffffffe03a8d7812ULL, 0x000fe200078ee28dULL, 0x00000020843c7824ULL, 0x040fe200078e00ffULL,
0x000000ff3f00720cULL, 0x000fe20003f05270ULL, 0x0000002084847824ULL, 0x000fe200078e00ffULL,
0xffffffe038387812ULL, 0x000fe200078ee283ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0xffffffe03c837812ULL, 0x000fe200078ee287ULL, 0x0000000881817824ULL, 0x000fe200078e00ffULL,
0xffffffe084847812ULL, 0x000fe200078ee285ULL, 0x000003f000017945ULL, 0x000fe20003800000ULL,
0x0001000038857811ULL, 0x000fc400078e20ffULL, 0x0000000682387810ULL, 0x000fe40007ffe0ffULL,
0x0001000084847811ULL, 0x000fe200078e20ffULL, 0x000000008554783bULL, 0x000f220000004200ULL,
0x0001000083837811ULL, 0x000fe400078e20ffULL, 0x000100008d827811ULL, 0x000fe200078e20ffULL,
0x00000000845c783bULL, 0x000ee20000004200ULL, 0xfffffff881817812ULL, 0x000fe400078ee238ULL,
0x0001000080807811ULL, 0x000fe200078e20ffULL, 0x000000008364783bULL, 0x000fe20000004200ULL,
0x0000a00081387811ULL, 0x000fc400078e20ffULL, 0x000100007f7f7811ULL, 0x000fe200078e20ffULL,
0x00000000823c783bULL, 0x000fe20000004200ULL, 0x000100007e7e7811ULL, 0x000fe400078e20ffULL,
0x000100007d7d7811ULL, 0x000fe200078e20ffULL, 0x000000003838783bULL, 0x002e680000000200ULL,
0x000000008040783bULL, 0x000e680000004200ULL, 0x000000007f44783bULL, 0x000e680000004200ULL,
0x000000007e48783bULL, 0x000e620000004200ULL, 0x0000002734349232ULL, 0x00cfc60000000000ULL,
0x000000007d4c783bULL, 0x000ea20000004200ULL, 0x0000002736369232ULL, 0x000fe40000000000ULL,
0x0000002635359232ULL, 0x080fe40000000000ULL, 0x0000002637379232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x050f7000000018ffULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x0000002738389232ULL, 0x082fe40000000000ULL, 0x000000273a3a9232ULL, 0x000fca0000000000ULL,
0x000000643460723cULL, 0x000fe200000018ffULL, 0x0000002639399232ULL, 0x080fe40000000000ULL,
0x000000263b3b9232ULL, 0x000fca0000000000ULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040f7000000018ffULL, 0x0000003e3434723cULL, 0x000f7000000018ffULL,
0x000000403850723cULL, 0x060b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x040b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x044b700000001868ULL, 0x0000004e3834723cULL, 0x000b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000000000ULL,
0x000000501d1d7221ULL, 0x020fe20000010000ULL, 0x000000511c1c7221ULL, 0x000fe20000010000ULL,
0x0000005419197221ULL, 0x000fe20000010000ULL, 0x0000005518187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006932327221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x000fe20000010000ULL, 0x000000356e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x000000521b1b7221ULL, 0x020fe20000010000ULL,
0x000000531a1a7221ULL, 0x000fe20000010000ULL, 0x0000005617177221ULL, 0x000fe20000010000ULL,
0x0000005716167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b6c6c7221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x000fe20000010000ULL,
0x0000003770707221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000018b8b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x00000004ff877424ULL, 0x000fca00078e00ffULL,
0x0000000187877807ULL, 0x000fc80006800000ULL, 0x000000878b00720cULL, 0x000fe20003f06070ULL,
0x000000ffff377224ULL, 0x002fd800078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffabb000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000407b347811ULL, 0x000fe200078e40ffULL, 0x014b5800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000753400720cULL, 0x000fda0003f06070ULL, 0x0000eeb000000947ULL, 0x000fea0003800000ULL,
0x000000ff008b7202ULL, 0x000fc80000000f00ULL, 0x00000002ff347819ULL, 0x000fe2000001168bULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000038b367812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000000348b347207ULL, 0x000fe40002800000ULL,
0x000000ff36367207ULL, 0x000fe40006800000ULL, 0x0000000134347810ULL, 0x000fc80007ffe0ffULL,
0x00000002ff387819ULL, 0x000fe40000011634ULL, 0x0000000334347812ULL, 0x000fc600078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e027bULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000122000017945ULL, 0x000fe60003800000ULL,
0x000000743700720cULL, 0x000fda0003f06070ULL, 0x000009b000008947ULL, 0x000fea0003800000ULL,
0x00000002733d7819ULL, 0x000fe200000006ffULL, 0x0000000435387824ULL, 0x000fe200078e0234ULL,
0x00000020033e7811ULL, 0x000fe200078e30ffULL, 0x00000200ff3f7424ULL, 0x000fe200078e00ffULL,
0x00000004733c7210ULL, 0x040fe20007ffe0ffULL, 0x014a00003d377984ULL, 0x000e620000000800ULL,
0x0000002038387811ULL, 0x000fe200078e30ffULL, 0x0000000173397824ULL, 0x040fe200078e023eULL,
0x0000000173457810ULL, 0x040fe20007ffe0ffULL, 0x00000010043b7824ULL, 0x000fe400078e00ffULL,
0x0000002073437824ULL, 0x000fc400078e00ffULL, 0x0000000145407824ULL, 0x000fe200078e0204ULL,
0x000001f03b417812ULL, 0x000fe400078ec0ffULL, 0xffffffe0433c7812ULL, 0x000fc800078ee23cULL,
0x000100003c437811ULL, 0x000fe200078e20ffULL, 0x00000004373a7824ULL, 0x002fe200078e00ffULL,
0x0000003875377217ULL, 0x000fca0007800000ULL, 0x014ac0003a3a7984ULL, 0x000e620000000800ULL,
0x0000000137387824ULL, 0x000fca00078e0a38ULL, 0x0000003873387217ULL, 0x000fca0007800000ULL,
0x0000000138377824ULL, 0x000fca00078e0a73ULL, 0x000000ff3700720cULL, 0x000fe20003f03070ULL,
0x0000003a21397224ULL, 0x002fc800078e0239ULL, 0x00005e0039387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe200078e023eULL, 0x0000000545457819ULL, 0x000fe400000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000013700780cULL, 0x000fe40003f03070ULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x014a04003d387984ULL, 0x000ea20000000800ULL, 0x0000000273457810ULL, 0x000fc40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000023700780cULL, 0x000fc60003f03070ULL, 0x014a08003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000373457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000033700780cULL, 0x000fc60003f03070ULL, 0x014a0c003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000473457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fe400078e20ffULL, 0x0000000445407210ULL, 0x000fe40007ffe0ffULL,
0x00000002383c7819ULL, 0x004fca00000006ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000043700780cULL, 0x000fc60003f03070ULL, 0x014a10003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000573457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000053700780cULL, 0x000fc60003f03070ULL, 0x014a14003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000673457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fc80007f3e0ffULL, 0x00000039ff3b7210ULL, 0x000fe20000ffe4ffULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000063700780cULL, 0x000fe40003f03070ULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x014a18003d387984ULL, 0x000ea20000000800ULL, 0x0000000773457810ULL, 0x000fc80007ffe0ffULL,
0x0000003e453e7210ULL, 0x000fe40007ffe0ffULL, 0x0001000040437811ULL, 0x002fe200078e20ffULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000073700780cULL, 0x000fc60003f03070ULL, 0x014a1c003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fe400078e023eULL, 0x00000001453e7824ULL, 0x000fe400078e0204ULL,
0x00005e0038387625ULL, 0x000fc800078e003fULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x0000004138387210ULL, 0x000fc80007f3e0ffULL, 0xffffffe0453e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff397224ULL, 0x000fc600008e0639ULL, 0x000100003e377811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e2000c101c46ULL,
0x0000084000007947ULL, 0x000fea0003800000ULL, 0x00000073043f7211ULL, 0x040fe200078fd8ffULL,
0x00000010043a7824ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x000000043f3b7210ULL, 0x040fe20007ffe0ffULL,
0x014a00003f377984ULL, 0x000e620000004800ULL, 0x000001f03a437812ULL, 0x000fe200078ec0ffULL,
0x000000013f397824ULL, 0x040fe200078e023eULL, 0x000000013f3d7810ULL, 0x040fe20007ffe0ffULL,
0x000000203f3c7824ULL, 0x000fc800078e00ffULL, 0x000000013d407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x0022a40000004800ULL, 0xffffffe03c377812ULL, 0x002fc800078ee23bULL,
0x0001000037457811ULL, 0x000fe200078e20ffULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x000000013d397824ULL, 0x040fe400078e023eULL,
0x000000203d3d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000b901c46ULL, 0x014a04003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03d407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000023f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0639ULL, 0x0000003e3b397210ULL, 0x040fe20007ffe0ffULL,
0x000000203b3b7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e4000b901c46ULL, 0xffffffe03b407812ULL, 0x000fe400078ee240ULL,
0x014a08003f377984ULL, 0x000ea40000004800ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000033f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x000000013d397824ULL, 0x040fe400078e023eULL,
0x000000203d3d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000b901c46ULL, 0x014a0c003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03d407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000043f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fc80007f1e0ffULL,
0x00000039ff3d7210ULL, 0x000fe200007fe4ffULL, 0x000000013b397824ULL, 0x040fe400078e023eULL,
0x000000203b3b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e6000b901c46ULL, 0xffffffe03b407812ULL, 0x000fe200078ee240ULL,
0x014a10003f377984ULL, 0x000ea60000004800ULL, 0x0001000040457811ULL, 0x002fc400078e20ffULL,
0x000000053f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x000000013d397824ULL, 0x040fe200078e023eULL,
0x000000053d3d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e4000b901c46ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x014a14003f377984ULL, 0x000ea40000004800ULL, 0x0001000040457811ULL, 0x002fc400078e20ffULL,
0x000000063f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe400000e0639ULL, 0x000000013b397824ULL, 0x040fe400078e023eULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a18003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03b407812ULL, 0x000fc800078ee240ULL, 0x00010000403d7811ULL, 0x002fe400078e20ffULL,
0x000000073f457810ULL, 0x000fc80007ffe0ffULL, 0x00000004453c7210ULL, 0x040fe20007ffe0ffULL,
0x00000001453e7824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fca00078e00ffULL,
0xffffffe0453c7812ULL, 0x000fe200078ee23cULL, 0x014ac00037387984ULL, 0x004e640000004800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x014a1c003f377984ULL, 0x000ea20000004800ULL, 0x000100003c3b7811ULL, 0x002fc600078e20ffULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e023eULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000357200720cULL, 0x000fe20003f04070ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000033600780cULL, 0x000fda0003f25270ULL, 0x0000014000008947ULL, 0x000fea0000800000ULL,
0x0000000400387802ULL, 0x000fe20000000f00ULL, 0x00000300ff377624ULL, 0x000fe200078e00ffULL,
0x000000032300780cULL, 0x000fe40003f24070ULL, 0x0000000371397812ULL, 0x000fe200078ec0ffULL,
0xfffffffd38377424ULL, 0x000fc600078e0237ULL, 0x000000033900780cULL, 0x000fc80003f05270ULL,
0x00000001373a7807ULL, 0x000fca0004000000ULL, 0x0000000171717824ULL, 0x000fe200078e023aULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400377824ULL, 0x000fe200078e0223ULL,
0x00006400713a7a10ULL, 0x040fe40007ffe0ffULL, 0x000000767100720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fe200078e00ffULL, 0x00014ac0233b7811ULL, 0x000fc600078e10ffULL,
0x0000640037377a24ULL, 0x000fc800078e023aULL, 0x0000600037387625ULL, 0x000fca00078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000357200720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x000fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fca0000011637ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0x00014a0023377811ULL, 0x000fc800078e10ffULL, 0x00000002ff387819ULL, 0x002fe20000011634ULL,
0x0000004034347824ULL, 0x000fc800078e00ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fe40004000000ULL,
0x0000003538357211ULL, 0x000fc600078e40ffULL, 0x0000000177347824ULL, 0x000fe400078e0234ULL,
0x0000000123367824ULL, 0x140fe400078e0235ULL, 0x0000680034347a24ULL, 0x000fe400078e0235ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8b00720cULL, 0x000fe20003f05270ULL,
0x014b8000ff887f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014af80073347f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3b7224ULL, 0x004fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x014afc0073247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fc80007f1e1ffULL, 0x0000003735377210ULL, 0x000fe400007fe5ffULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x014afc0073247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001004247824ULL, 0x000fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fc80000011604ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fca00078ec0ffULL, 0x00000001243b7824ULL, 0x000fca00078e0235ULL,
0x014080003b367984ULL, 0x000ea80000000800ULL, 0x014280003b377984ULL, 0x0006620000000800ULL,
0x0000006f3600720bULL, 0x004fe20003f1d000ULL, 0x0001b8b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff387224ULL, 0x000fd200078e006fULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000017900780cULL, 0x000fe40003f05270ULL, 0x0000006f3600720bULL, 0x000fe20003f34000ULL,
0x0001b8727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x000000366f387209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x014480383b008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000386f347221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x000ea40000000800ULL, 0x0000003d1e1e7220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0001b7c27f007947ULL, 0x000fea000b800000ULL,
0x00001f7c3d347589ULL, 0x0004e400000e0000ULL, 0x000000341d1d7220ULL, 0x088fe20000410000ULL,
0x000000341c1c7220ULL, 0x080fe20000410000ULL, 0x0000003419197220ULL, 0x080fe20000410000ULL,
0x0000003418187220ULL, 0x080fe20000410000ULL, 0x0000003415157220ULL, 0x080fe20000410000ULL,
0x0000003414147220ULL, 0x080fe20000410000ULL, 0x0000003411117220ULL, 0x080fe20000410000ULL,
0x0000003410107220ULL, 0x080fe20000410000ULL, 0x000000340d0d7220ULL, 0x080fe20000410000ULL,
0x000000340c0c7220ULL, 0x080fe20000410000ULL, 0x0000003409097220ULL, 0x080fe20000410000ULL,
0x0000003408087220ULL, 0x080fe20000410000ULL, 0x0000003405057220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x0000003433337220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0001b6d27f007947ULL, 0x000fea000b800000ULL, 0x00001f7a3d347589ULL, 0x0006a400000e0000ULL,
0x000000341b1b7220ULL, 0x084fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x000000340e0e7220ULL, 0x080fe20000410000ULL,
0x000000340b0b7220ULL, 0x080fe20000410000ULL, 0x000000340a0a7220ULL, 0x080fe20000410000ULL,
0x0000003407077220ULL, 0x080fe20000410000ULL, 0x0000003406067220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x080fe20000410000ULL,
0x000000346d6d7220ULL, 0x080fe20000410000ULL, 0x0000003470707220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fda0007806039ULL,
0x8000003836360221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600250308ULL, 0x000ea40000000800ULL,
0x0000002537370220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001e371e7221ULL, 0x002fe20000010000ULL, 0x000000ffff6f7224ULL, 0x000fc400078e0038ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x0001b5127f007947ULL, 0x000fea000b800000ULL, 0x00001f7c37277589ULL, 0x0004e400000e0000ULL,
0x0001b5527f007947ULL, 0x000fea000b800000ULL, 0x00001f7a37267589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000a01000347802ULL, 0x000fc40000000f00ULL,
0x0001c0e000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000037003a7202ULL, 0x004fe40000000f00ULL, 0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL,
0x0000a06000347802ULL, 0x000fc40000000f00ULL, 0x0001c09000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000a80028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x0000a8002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x0000008b7c00720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x0000007b7200720cULL, 0x000fc40003fc3070ULL, 0x0000008b7a00720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x0000007b7200720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x008fe80000004200ULL,
0x000000003838783bULL, 0x002e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000784c783bULL, 0x000ee20000004200ULL, 0x000000273434b232ULL, 0x004fc40000000000ULL,
0x000000273636b232ULL, 0x000fe40000000000ULL, 0x000000263535b232ULL, 0x080fe40000000000ULL,
0x000000263737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000273838b232ULL, 0x082fe40000000000ULL, 0x000000273a3ab232ULL, 0x000fe40000000000ULL,
0x000000263939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000263b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040b6e00000018ffULL,
0x000000018b3d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000018ffULL,
0x0000003d7c00720cULL, 0x000fc40005746470ULL, 0x0000003d7a00720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x050b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x020b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000501d1d7221ULL, 0x000fe20000010000ULL, 0x000000511c1c7221ULL, 0x000fe20000010000ULL,
0x0000005419197221ULL, 0x000fe20000010000ULL, 0x0000005518187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006932327221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x020fe20000010000ULL, 0x000000356e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521b1b7221ULL, 0x000fe20000010000ULL,
0x000000531a1a7221ULL, 0x000fe20000010000ULL, 0x0000005617177221ULL, 0x000fe20000010000ULL,
0x0000005716167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b6c6c7221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x020fe20000010000ULL,
0x0000003770707221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x0000007b7200720cULL, 0x000fc40003fc3070ULL, 0x0000007b7200720cULL, 0x000fe40003f03070ULL,
0x00000040ff3f7803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe2000001163dULL,
0x000000ffff3c7224ULL, 0x000fc600078e0035ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000134367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e027bULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4889ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x014b8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fc800078d10ffULL, 0x0000003bff3a7210ULL, 0x000fc800037fe4ffULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000120000017945ULL, 0x000fe60003800000ULL,
0x000000743700720cULL, 0x000fda0003fc6070ULL, 0x000009a00000e947ULL, 0x000fea0003800000ULL,
0x0000000473407824ULL, 0x000fe400078e00ffULL, 0x0000004003417824ULL, 0x000fe400078e0273ULL,
0x00000200ff437424ULL, 0x000fe200078e00ffULL, 0x014a000040377984ULL, 0x000e620000000800ULL,
0x00000010043a7824ULL, 0x000fe400078e00ffULL, 0x00000020733c7824ULL, 0x000fc600078e00ffULL,
0x000001f03a457812ULL, 0x000fe200078ec0ffULL, 0x0000000437377824ULL, 0x002fca00078e00ffULL,
0x014ac00037387984ULL, 0x000e640000000800ULL, 0x0000003821387224ULL, 0x002fc800078e0241ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fe40007fde0ffULL,
0x0000003635387211ULL, 0x000fc600078e10ffULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x0000004038387824ULL, 0x000fca00078e00ffULL, 0x0000003875377217ULL, 0x000fca0007800000ULL,
0x0000000137387824ULL, 0x000fe400078e0a38ULL, 0x0000000173377824ULL, 0x000fc600078e0204ULL,
0x0000003873387217ULL, 0x000fe40007800000ULL, 0xffffffe03c397812ULL, 0x000fc600078ee237ULL,
0x0000000138377824ULL, 0x000fe200078e0a73ULL, 0x0000c00039477811ULL, 0x000fe400078e20ffULL,
0x0000000141397810ULL, 0x000fe40007ffe0ffULL, 0x000000ff3700720cULL, 0x000fda0003fc3070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a040040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fc80007fde0ffULL,
0x00000039ff3d7210ULL, 0x000fe400037fe4ffULL, 0x0000000173397810ULL, 0x000fe40007ffe0ffULL,
0x000000013700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000241397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x014a080040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000000273397810ULL, 0x000fe40007ffe0ffULL,
0x000000023700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000341397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a0c0040387984ULL, 0x000ea40000000800ULL, 0x00000002383e7819ULL, 0x004fca00000006ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000000373397810ULL, 0x000fe40007ffe0ffULL,
0x000000033700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000441397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x014a100040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000000473397810ULL, 0x000fe40007ffe0ffULL,
0x000000043700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe200078e0204ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000541397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a140040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000000573397810ULL, 0x000fe40007ffe0ffULL,
0x000000053700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000641397810ULL, 0x040fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fe400078e20ffULL,
0x0000000741417810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a180040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fca00078e00ffULL, 0x014ac0003e387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x00000045383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x0000000673397810ULL, 0x000fe40007ffe0ffULL, 0x000000063700780cULL, 0x000fe40003fc3070ULL,
0x0000000439387210ULL, 0x040fe20007ffe0ffULL, 0x0000002039397824ULL, 0x000fca00078e00ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000f101c46ULL,
0x014a1c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383c7824ULL, 0x004fca00078e00ffULL,
0x014ac0003c387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fe200078e0241ULL,
0x0000000773417810ULL, 0x000fc60007ffe0ffULL, 0x00005e0038387625ULL, 0x000fc800078e0043ULL,
0x00000001413e7824ULL, 0x040fe200078e0204ULL, 0x0000004538387210ULL, 0x000fe20007fde0ffULL,
0x0000002041417824ULL, 0x000fc800078e00ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073700780cULL, 0x000fe40003fc3070ULL, 0xffffffe0413e7812ULL, 0x000fc800078ee23eULL,
0x0000c0003e3b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x00000073043e7211ULL, 0x040fe200078fd8ffULL, 0x00000010043a7824ULL, 0x000fe200078e00ffULL,
0x0000020000417802ULL, 0x000fc60000000f00ULL, 0x014a00003e377984ULL, 0x000e620000004800ULL,
0x0000004003407824ULL, 0x000fe200078e023eULL, 0x000001f03a437812ULL, 0x000fe400078ec0ffULL,
0x014ac00037387984ULL, 0x002e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013e387824ULL, 0x000fc800078e0204ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000203e397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000140397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a04003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000013e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe200078e0204ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000240397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x014a08003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000023e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000340397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a0c003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000033e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000440397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x014a10003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fc80007fde0ffULL, 0x00000039ff3b7210ULL, 0x000fe400037fe4ffULL,
0x000000043e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000540397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a14003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000053e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000640397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000000740407810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a18003e377984ULL, 0x000ea80000004800ULL,
0x014ac00037387984ULL, 0x004ea40000004800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000063e397810ULL, 0x000fc80007ffe0ffULL,
0x0000000439387210ULL, 0x040fe20007ffe0ffULL, 0x0000002039397824ULL, 0x000fca00078e00ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x014a1c003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0240ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x000000073e417810ULL, 0x000fc80007ffe0ffULL, 0x0000004338387210ULL, 0x000fe20007fde0ffULL,
0x00000001413c7824ULL, 0x040fe400078e0204ULL, 0x0000002041417824ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fc600030e0639ULL, 0xffffffe0413c7812ULL, 0x000fc800078ee23cULL,
0x0000c0003c3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fc80007fde1ffULL,
0x0000003b393b7210ULL, 0x000fe400037fe5ffULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000357200720cULL, 0x000fc80003fc4070ULL, 0x000000ff34377207ULL, 0x040fe40003000000ULL,
0x000000ff34387207ULL, 0x000fc60007000000ULL, 0x0000000136377824ULL, 0x000fca00078e0237ULL,
0x00000002ff347819ULL, 0x000fe20000011637ULL, 0x0000004037377824ULL, 0x000fc800078e00ffULL,
0x0000030034347a24ULL, 0x000fe200078e0235ULL, 0x000000c037377812ULL, 0x000fe200078ec0ffULL,
0x0000000177357824ULL, 0x000fc800078e0238ULL, 0x0000010034347824ULL, 0x000fe200078e0237ULL,
0x00014a0023377811ULL, 0x000fc800078e10ffULL, 0x0000002034367810ULL, 0x000fca0007ffe0ffULL,
0x0000680035347a24ULL, 0x100fe400078e0236ULL, 0x0000000123367824ULL, 0x040fe400078e0236ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x0000003423347210ULL, 0x000fe40007ffe0ffULL,
0x000000753600720cULL, 0x000fc60003fc6070ULL, 0x0000660034347625ULL, 0x000fd400078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff887f8cULL, 0x000e62000c80043fULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x000193127f007947ULL, 0x000fea000b800000ULL, 0x00001f7c37277589ULL, 0x0004e400000e0000ULL,
0x000193527f007947ULL, 0x000fea000b800000ULL, 0x00001f7a37267589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000c2d000347802ULL, 0x000fc40000000f00ULL,
0x00019e2000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL,
0x0000c32000347802ULL, 0x000fc40000000f00ULL, 0x00019dd000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000a80086347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000ff3f00720cULL, 0x000fe20003fc5270ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000a80081387811ULL, 0x000fe200078e20ffULL,
0x0000034000017945ULL, 0x000fe40003800000ULL, 0x000000003434783bULL, 0x004ea80000000200ULL,
0x00000000845c783bULL, 0x000fe80000004200ULL, 0x000000008364783bULL, 0x000fe80000004200ULL,
0x00000000823c783bULL, 0x000fe80000004200ULL, 0x000000003838783bULL, 0x002e680000000200ULL,
0x000000008040783bULL, 0x000f280000004200ULL, 0x000000007f44783bULL, 0x000ee80000004200ULL,
0x000000007e48783bULL, 0x000ee80000004200ULL, 0x000000007d4c783bULL, 0x000ee40000004200ULL,
0x000000273434b232ULL, 0x00cfc40000000000ULL, 0x000000273636b232ULL, 0x000fe40000000000ULL,
0x000000263535b232ULL, 0x080fe40000000000ULL, 0x000000263737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000273838b232ULL, 0x082fe40000000000ULL,
0x000000273a3ab232ULL, 0x000fe40000000000ULL, 0x000000263939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000263b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040f7000000018ffULL, 0x0000003e3434723cULL, 0x000f7000000018ffULL,
0x000000403850723cULL, 0x070b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x040b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x000b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000501d1d7221ULL, 0x020fe20000010000ULL, 0x000000511c1c7221ULL, 0x000fe20000010000ULL,
0x0000005419197221ULL, 0x000fe20000010000ULL, 0x0000005518187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006932327221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x000fe20000010000ULL, 0x000000356e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521b1b7221ULL, 0x020fe20000010000ULL,
0x000000531a1a7221ULL, 0x000fe20000010000ULL, 0x0000005617177221ULL, 0x000fe20000010000ULL,
0x0000005716167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b6c6c7221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x000fe20000010000ULL,
0x0000003770707221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000018b8b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x000000878b00720cULL, 0x000fe20003f06070ULL,
0x000000ffff377224ULL, 0x002fd800078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffb10000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000807b347811ULL, 0x000fe200078e40ffULL, 0x014b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000753400720cULL, 0x000fda0003f06070ULL, 0x00009f1000000947ULL, 0x000fea0003800000ULL,
0x000000ffff8b7224ULL, 0x000fca00078e00ffULL, 0x00000002ff347819ULL, 0x000fe2000001168bULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000038b367812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000000348b347207ULL, 0x000fe40002800000ULL,
0x000000ff36367207ULL, 0x000fe40006800000ULL, 0x0000000234347810ULL, 0x000fc80007ffe0ffULL,
0x00000002ff387819ULL, 0x000fe40000011634ULL, 0x0000000334347812ULL, 0x000fc600078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e027bULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fc800078110ffULL,
0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000122000017945ULL, 0x000fe60003800000ULL,
0x000000743700720cULL, 0x000fda0003f06070ULL, 0x000009b000008947ULL, 0x000fea0003800000ULL,
0x00000004733d7824ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x0000000435387824ULL, 0x000fe200078e0234ULL, 0x0000000173457810ULL, 0x040fe20007ffe0ffULL,
0x00000200ff3f7424ULL, 0x000fe200078e00ffULL, 0x014a00003d377984ULL, 0x000e620000000800ULL,
0x0000003e73397210ULL, 0x040fe20007ffe0ffULL, 0x00000010043b7824ULL, 0x000fe200078e00ffULL,
0x0000002038387811ULL, 0x000fe200078e30ffULL, 0x00000001733c7824ULL, 0x140fe400078e0204ULL,
0x0000002073437824ULL, 0x000fe200078e00ffULL, 0x000001f03b417812ULL, 0x000fe200078ec0ffULL,
0x0000000145407824ULL, 0x000fc600078e0204ULL, 0xffffffe0433c7812ULL, 0x000fc800078ee23cULL,
0x000100003c437811ULL, 0x000fe200078e20ffULL, 0x00000004373a7824ULL, 0x002fe200078e00ffULL,
0x0000003875377217ULL, 0x000fca0007800000ULL, 0x014ac0003a3a7984ULL, 0x000e620000000800ULL,
0x0000000137387824ULL, 0x000fca00078e0a38ULL, 0x0000003873387217ULL, 0x000fca0007800000ULL,
0x0000000138377824ULL, 0x000fca00078e0a73ULL, 0x000000ff3700720cULL, 0x000fe20003f03070ULL,
0x0000003a21397224ULL, 0x002fc800078e0239ULL, 0x00005e0039387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fc80007f3e0ffULL, 0x00000039ff3b7210ULL, 0x000fe20000ffe4ffULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000013700780cULL, 0x000fe40003f03070ULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x014a04003d387984ULL, 0x000ea20000000800ULL, 0x0000000273457810ULL, 0x000fc40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e0639ULL,
0x0000003e45397210ULL, 0x040fe20007ffe0ffULL, 0x0000002045457824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000023700780cULL, 0x000fe40003f03070ULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x014a08003d387984ULL, 0x000ea20000000800ULL, 0x0000000373457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe200078e023eULL, 0x0000000545457819ULL, 0x000fe400000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000033700780cULL, 0x000fe40003f03070ULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x014a0c003d387984ULL, 0x000ea20000000800ULL, 0x0000000473457810ULL, 0x000fc40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000043700780cULL, 0x000fc60003f03070ULL, 0x014a10003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000573457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000053700780cULL, 0x000fc60003f03070ULL, 0x014a14003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000673457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fe400078e20ffULL, 0x0000000445407210ULL, 0x000fe40007ffe0ffULL,
0x00000002383c7819ULL, 0x004fca00000006ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000063700780cULL, 0x000fc60003f03070ULL, 0x014a18003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000773457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x00000001453e7824ULL, 0x000fe400078e023eULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000073700780cULL, 0x000fc60003f03070ULL, 0x014a1c003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fe400078e023eULL, 0x00000001453e7824ULL, 0x000fe400078e0204ULL,
0x00005e0038387625ULL, 0x000fc800078e003fULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x0000004138387210ULL, 0x000fc80007f3e0ffULL, 0xffffffe0453e7812ULL, 0x000fe400078ee23eULL,
0x00000039ff397210ULL, 0x000fe40000ffe4ffULL, 0x000100003e377811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e2000c101c46ULL,
0x0000084000007947ULL, 0x000fea0003800000ULL, 0x00000073043f7211ULL, 0x040fe200078fd8ffULL,
0x00000010043a7824ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x000000013f3d7810ULL, 0x040fe20007ffe0ffULL,
0x014a00003f377984ULL, 0x000e620000004800ULL, 0x000001f03a437812ULL, 0x000fe200078ec0ffULL,
0x000000013f397824ULL, 0x040fe400078e023eULL, 0x000000013f3b7824ULL, 0x000fc400078e0204ULL,
0x000000203f3c7824ULL, 0x000fe400078e00ffULL, 0x000000013d407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x0022a40000004800ULL, 0xffffffe03c377812ULL, 0x002fc800078ee23bULL,
0x0001000037457811ULL, 0x000fe200078e20ffULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0x0000003e3d397210ULL, 0x040fe20007ffe0ffULL,
0x000000203d3d7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e4000b901c46ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x014a04003f377984ULL, 0x000ea40000004800ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000023f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe400000e0639ULL, 0x000000013b397824ULL, 0x040fe400078e023eULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a08003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03b407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000033f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fc80007f1e0ffULL,
0x00000039ff3b7210ULL, 0x000fe200007fe4ffULL, 0x000000013d397824ULL, 0x040fe400078e023eULL,
0x000000203d3d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e6000b901c46ULL, 0xffffffe03d407812ULL, 0x000fe200078ee240ULL,
0x014a0c003f377984ULL, 0x000ea60000004800ULL, 0x0001000040457811ULL, 0x002fc400078e20ffULL,
0x000000043f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe400000e0639ULL, 0x000000013b397824ULL, 0x040fe200078e023eULL,
0x000000053b3b7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e4000b901c46ULL, 0xffffffe03b407812ULL, 0x000fe400078ee240ULL,
0x014a10003f377984ULL, 0x000ea40000004800ULL, 0x0001000040457811ULL, 0x002fc400078e20ffULL,
0x000000053f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x000000013d397824ULL, 0x040fe400078e023eULL,
0x000000203d3d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000b901c46ULL, 0x014a14003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03d407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000063f3b7810ULL, 0x000fc80007ffe0ffULL, 0x000000043b407210ULL, 0x000fe20007ffe0ffULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe400000e0639ULL, 0x000000013b397824ULL, 0x040fe400078e023eULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a18003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03b407812ULL, 0x000fc800078ee240ULL, 0x00010000403d7811ULL, 0x002fe400078e20ffULL,
0x000000073f457810ULL, 0x000fca0007ffe0ffULL, 0x00000001453e7824ULL, 0x040fe400078e023eULL,
0x00000001453c7824ULL, 0x040fe400078e0204ULL, 0x0000002045457824ULL, 0x000fca00078e00ffULL,
0xffffffe0453c7812ULL, 0x000fe200078ee23cULL, 0x014ac00037387984ULL, 0x004e640000004800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x014a1c003f377984ULL, 0x000ea20000004800ULL, 0x000100003c3b7811ULL, 0x002fc600078e20ffULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e023eULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x00000039003c7202ULL, 0x002fc40000000f00ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000357200720cULL, 0x000fe20003f04070ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000033600780cULL, 0x000fda0003f25270ULL, 0x0000014000008947ULL, 0x000fea0000800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000004ff387424ULL, 0x000fe200078e00ffULL,
0x0000000371397812ULL, 0x000fe200078ec0ffULL, 0x00000300ff377624ULL, 0x000fc600078e00ffULL,
0x000000033900780cULL, 0x000fe20003f05270ULL, 0xfffffffd38377424ULL, 0x000fca00078e0237ULL,
0x00000001373a7807ULL, 0x000fca0004000000ULL, 0x0000000171717824ULL, 0x000fe200078e023aULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000002300377211ULL, 0x000fe400078e10ffULL,
0x00006400713a7a10ULL, 0x040fe40007ffe0ffULL, 0x000000767100720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fe200078e00ffULL, 0x00014ac0233b7811ULL, 0x000fc600078e10ffULL,
0x0000640037377a24ULL, 0x000fc800078e023aULL, 0x0000600037387625ULL, 0x000fca00078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000357200720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x000fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fca0000011637ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0x00014a0023377811ULL, 0x000fc800078e10ffULL, 0x00000002ff387819ULL, 0x002fe20000011634ULL,
0x0000004034347824ULL, 0x000fc800078e00ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fc60004000000ULL,
0x0000010038357824ULL, 0x000fe400078e0235ULL, 0x0000000177347824ULL, 0x000fe400078e0234ULL,
0x0000000123367824ULL, 0x140fe400078e0235ULL, 0x0000680034347a24ULL, 0x000fe200078e0235ULL,
0x0000000400357802ULL, 0x000fe40000000f00ULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8b00720cULL, 0x000fe20003f05270ULL,
0x014b8000ff887f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b180073347f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3b7224ULL, 0x004fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x014b1c0073247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x014b1c0073247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001004247824ULL, 0x000fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fc80000011604ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fc800078ec0ffULL, 0x00000035243b7210ULL, 0x000fca0007ffe0ffULL,
0x014100003b367984ULL, 0x000ea80000000800ULL, 0x014300003b377984ULL, 0x0006620000000800ULL,
0x0000006f3600720bULL, 0x004fe20003f1d000ULL, 0x00016be27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff387224ULL, 0x000fd200078e006fULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000027900780cULL, 0x000fe40003f05270ULL, 0x0000006f3600720bULL, 0x000fe20003f34000ULL,
0x00016ba27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x000000366f387209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x014500383b008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000386f347221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x000ea40000000800ULL, 0x0000003d1e1e7220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00016af27f007947ULL, 0x000fea000b800000ULL,
0x00001f7c3d347589ULL, 0x0004e400000e0000ULL, 0x000000341d1d7220ULL, 0x088fe20000410000ULL,
0x000000341c1c7220ULL, 0x080fe20000410000ULL, 0x0000003419197220ULL, 0x080fe20000410000ULL,
0x0000003418187220ULL, 0x080fe20000410000ULL, 0x0000003415157220ULL, 0x080fe20000410000ULL,
0x0000003414147220ULL, 0x080fe20000410000ULL, 0x0000003411117220ULL, 0x080fe20000410000ULL,
0x0000003410107220ULL, 0x080fe20000410000ULL, 0x000000340d0d7220ULL, 0x080fe20000410000ULL,
0x000000340c0c7220ULL, 0x080fe20000410000ULL, 0x0000003409097220ULL, 0x080fe20000410000ULL,
0x0000003408087220ULL, 0x080fe20000410000ULL, 0x0000003405057220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x0000003433337220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00016a027f007947ULL, 0x000fea000b800000ULL, 0x00001f7a3d347589ULL, 0x0006a400000e0000ULL,
0x000000341b1b7220ULL, 0x084fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x000000340e0e7220ULL, 0x080fe20000410000ULL,
0x000000340b0b7220ULL, 0x080fe20000410000ULL, 0x000000340a0a7220ULL, 0x080fe20000410000ULL,
0x0000003407077220ULL, 0x080fe20000410000ULL, 0x0000003406067220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x080fe20000410000ULL,
0x000000346d6d7220ULL, 0x080fe20000410000ULL, 0x0000003470707220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fda0007806039ULL,
0x8000003836360221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600250308ULL, 0x000ea40000000800ULL,
0x0000002537370220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001e371e7221ULL, 0x002fe20000010000ULL, 0x000000ffff6f7224ULL, 0x000fc400078e0038ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x000168427f007947ULL, 0x000fea000b800000ULL, 0x00001f7c37277589ULL, 0x0004e400000e0000ULL,
0x000168827f007947ULL, 0x000fea000b800000ULL, 0x00001f7a37267589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000efb000347802ULL, 0x000fc40000000f00ULL,
0x0001714000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL,
0x0000f00000347802ULL, 0x000fc40000000f00ULL, 0x000170f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000b00028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x0000b0002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x0000008b7c00720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x0000007b7200720cULL, 0x000fc40003fc3070ULL, 0x0000008b7a00720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x0000007b7200720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x008fe80000004200ULL,
0x000000003838783bULL, 0x002e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000784c783bULL, 0x000ee20000004200ULL, 0x000000273434b232ULL, 0x004fc40000000000ULL,
0x000000273636b232ULL, 0x000fe40000000000ULL, 0x000000263535b232ULL, 0x080fe40000000000ULL,
0x000000263737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000273838b232ULL, 0x082fe40000000000ULL, 0x000000273a3ab232ULL, 0x000fe40000000000ULL,
0x000000263939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000263b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040b6e00000018ffULL,
0x000000018b3d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000018ffULL,
0x0000003d7c00720cULL, 0x000fc40005746470ULL, 0x0000003d7a00720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x050b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x020b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000501d1d7221ULL, 0x000fe20000010000ULL, 0x000000511c1c7221ULL, 0x000fe20000010000ULL,
0x0000005419197221ULL, 0x000fe20000010000ULL, 0x0000005518187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006932327221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x020fe20000010000ULL, 0x000000356e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521b1b7221ULL, 0x000fe20000010000ULL,
0x000000531a1a7221ULL, 0x000fe20000010000ULL, 0x0000005617177221ULL, 0x000fe20000010000ULL,
0x0000005716167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b6c6c7221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x020fe20000010000ULL,
0x0000003770707221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x0000007b7200720cULL, 0x000fc40003fc3070ULL, 0x0000007b7200720cULL, 0x000fe40003f03070ULL,
0x00000040ff3f7803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe2000001163dULL,
0x000000ffff3c7224ULL, 0x000fc600078e0035ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000234367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e027bULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4889ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fc80007fde1ffULL, 0x0000003b393b7210ULL, 0x000fe400037fe5ffULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x014b8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000120000017945ULL, 0x000fe60003800000ULL,
0x000000743700720cULL, 0x000fda0003fc6070ULL, 0x000009a00000e947ULL, 0x000fea0003800000ULL,
0x0000000473407824ULL, 0x000fe200078e00ffULL, 0x0000007303417211ULL, 0x000fe200078e30ffULL,
0x00000200ff437424ULL, 0x000fe400078e00ffULL, 0x00000010043a7824ULL, 0x000fe200078e00ffULL,
0x014a000040377984ULL, 0x000e620000000800ULL, 0x00000020733c7824ULL, 0x000fc600078e00ffULL,
0x000001f03a457812ULL, 0x000fe200078ec0ffULL, 0x0000000437377824ULL, 0x002fca00078e00ffULL,
0x014ac00037387984ULL, 0x000e640000000800ULL, 0x0000003821387224ULL, 0x002fc800078e0241ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fe20007fde0ffULL,
0x0000000435387824ULL, 0x000fc800078e0236ULL, 0x0000004038387824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600030e0639ULL, 0x0000003875377217ULL, 0x000fca0007800000ULL,
0x0000000137387824ULL, 0x000fe200078e0a38ULL, 0x0000000473377210ULL, 0x000fc80007ffe0ffULL,
0x0000003873387217ULL, 0x000fe40007800000ULL, 0xffffffe03c397812ULL, 0x000fc600078ee237ULL,
0x0000000138377824ULL, 0x000fe200078e0a73ULL, 0x0000c00039477811ULL, 0x000fe400078e20ffULL,
0x0000000141397810ULL, 0x000fe40007ffe0ffULL, 0x000000ff3700720cULL, 0x000fda0003fc3070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a040040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000000173397810ULL, 0x000fe40007ffe0ffULL,
0x000000013700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000241397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x014a080040387984ULL, 0x000ea40000000800ULL, 0x00000002383e7819ULL, 0x004fca00000006ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000000273397810ULL, 0x000fe40007ffe0ffULL,
0x000000023700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000341397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a0c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000000373397810ULL, 0x000fe40007ffe0ffULL,
0x000000033700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe200078e0204ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000441397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x014a100040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000000473397810ULL, 0x000fe40007ffe0ffULL,
0x000000043700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000541397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a140040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000000573397810ULL, 0x000fe40007ffe0ffULL,
0x000000053700780cULL, 0x000fe40003fc3070ULL, 0x0000000439387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000641397810ULL, 0x040fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fe400078e20ffULL,
0x0000000741417810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a180040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fca00078e00ffULL, 0x014ac0003e387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x00000045383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x0000000673397810ULL, 0x000fe40007ffe0ffULL, 0x000000063700780cULL, 0x000fc60003fc3070ULL,
0x0000000139387824ULL, 0x040fe400078e0204ULL, 0x0000002039397824ULL, 0x000fca00078e00ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000f101c46ULL,
0x014a1c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383c7824ULL, 0x004fca00078e00ffULL,
0x014ac0003c387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fe200078e0241ULL,
0x0000000773417810ULL, 0x000fc60007ffe0ffULL, 0x00005e0038387625ULL, 0x000fc800078e0043ULL,
0x00000001413e7824ULL, 0x040fe200078e0204ULL, 0x0000004538387210ULL, 0x000fe20007fde0ffULL,
0x0000002041417824ULL, 0x000fc600078e00ffULL, 0x00000039ff397210ULL, 0x000fe400037fe4ffULL,
0x000000073700780cULL, 0x000fe40003fc3070ULL, 0xffffffe0413e7812ULL, 0x000fc800078ee23eULL,
0x0000c0003e3b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x00000073043e7211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe400078e00ffULL,
0x00000010043a7824ULL, 0x000fe400078e00ffULL, 0x014a00003e377984ULL, 0x000e620000004800ULL,
0x0000004003407824ULL, 0x000fe400078e023eULL, 0x000001f03a437812ULL, 0x000fe200078ec0ffULL,
0x014ac00037387984ULL, 0x002e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe40007fde0ffULL,
0x000000043e387210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000203e397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000140397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a04003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000013e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000240397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x014a08003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000023e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe200078e0204ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000340397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a0c003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000033e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000440397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x014a10003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000043e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000540397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a14003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fc80007fde0ffULL, 0x00000039ff3d7210ULL, 0x000fe400037fe4ffULL,
0x000000053e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000640397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000000740407810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a18003e377984ULL, 0x000ea80000004800ULL,
0x014ac00037387984ULL, 0x004ea40000004800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000063e397810ULL, 0x000fca0007ffe0ffULL,
0x0000000139387824ULL, 0x040fe400078e0204ULL, 0x0000002039397824ULL, 0x000fca00078e00ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x014a1c003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0240ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x000000073e417810ULL, 0x000fc80007ffe0ffULL, 0x00000004413c7210ULL, 0x040fe20007ffe0ffULL,
0x0000002041417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007fde0ffULL,
0xffffffe0413c7812ULL, 0x000fe200078ee23cULL, 0x000000ffff397224ULL, 0x000fc600030e0639ULL,
0x0000c0003c3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000357200720cULL, 0x000fc80003fc4070ULL, 0x000000ff34377207ULL, 0x040fe40003000000ULL,
0x000000ff34387207ULL, 0x000fc60007000000ULL, 0x0000000136377824ULL, 0x000fca00078e0237ULL,
0x00000002ff347819ULL, 0x000fe40000011637ULL, 0x0000000637377819ULL, 0x000fc600000006ffULL,
0x0000030034347a24ULL, 0x000fe200078e0235ULL, 0x000000c037377812ULL, 0x000fe200078ec0ffULL,
0x0000000177357824ULL, 0x000fc800078e0238ULL, 0x0000010034347824ULL, 0x000fe200078e0237ULL,
0x00014a0023377811ULL, 0x000fc800078e10ffULL, 0x0000002034367810ULL, 0x000fca0007ffe0ffULL,
0x0000680035347a24ULL, 0x100fe400078e0236ULL, 0x0000000123367824ULL, 0x040fe400078e0236ULL,
0x00000004ff357424ULL, 0x000fe400078e00ffULL, 0x0000000123347824ULL, 0x000fe200078e0234ULL,
0x000000753600720cULL, 0x000fc60003fc6070ULL, 0x0000660034347625ULL, 0x000fd400078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff887f8cULL, 0x000e62000c80043fULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x000146427f007947ULL, 0x000fea000b800000ULL, 0x00001f7c37277589ULL, 0x0004e400000e0000ULL,
0x000146827f007947ULL, 0x000fea000b800000ULL, 0x00001f7a37267589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0001127000347802ULL, 0x000fc40000000f00ULL,
0x00014e8000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL,
0x000112c000347802ULL, 0x000fc40000000f00ULL, 0x00014e3000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000b00086347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000ff3f00720cULL, 0x000fe20003fc5270ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000b00081387811ULL, 0x000fe200078e20ffULL,
0x0000034000017945ULL, 0x000fe40003800000ULL, 0x000000003434783bULL, 0x004ea80000000200ULL,
0x00000000845c783bULL, 0x000fe80000004200ULL, 0x000000008364783bULL, 0x000fe80000004200ULL,
0x00000000823c783bULL, 0x000fe80000004200ULL, 0x000000003838783bULL, 0x002e680000000200ULL,
0x000000008040783bULL, 0x000f280000004200ULL, 0x000000007f44783bULL, 0x000ee80000004200ULL,
0x000000007e48783bULL, 0x000ee80000004200ULL, 0x000000007d4c783bULL, 0x000ee40000004200ULL,
0x000000273434b232ULL, 0x00cfc40000000000ULL, 0x000000273636b232ULL, 0x000fe40000000000ULL,
0x000000263535b232ULL, 0x080fe40000000000ULL, 0x000000263737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000273838b232ULL, 0x082fe40000000000ULL,
0x000000273a3ab232ULL, 0x000fe40000000000ULL, 0x000000263939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000263b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040f7000000018ffULL, 0x0000003e3434723cULL, 0x000f7000000018ffULL,
0x000000403850723cULL, 0x070b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x040b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x000b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000501d1d7221ULL, 0x020fe20000010000ULL, 0x000000511c1c7221ULL, 0x000fe20000010000ULL,
0x0000005419197221ULL, 0x000fe20000010000ULL, 0x0000005518187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006932327221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x000fe20000010000ULL, 0x000000356e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521b1b7221ULL, 0x020fe20000010000ULL,
0x000000531a1a7221ULL, 0x000fe20000010000ULL, 0x0000005617177221ULL, 0x000fe20000010000ULL,
0x0000005716167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b6c6c7221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x000fe20000010000ULL,
0x0000003770707221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000018b8b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x000000878b00720cULL, 0x000fc40003f06070ULL,
0x0000003500377202ULL, 0x002fd60000000f00ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffb10000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c07b347811ULL, 0x000fe200078e40ffULL, 0x014b6800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000753400720cULL, 0x000fda0003f06070ULL, 0x00004f7000000947ULL, 0x000fea0003800000ULL,
0x000000ffff8b7224ULL, 0x000fca00078e00ffULL, 0x00000002ff347819ULL, 0x000fe2000001168bULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000038b367812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000000348b347207ULL, 0x000fe40002800000ULL,
0x000000ff36367207ULL, 0x000fe40006800000ULL, 0x0000000334347810ULL, 0x000fc80007ffe0ffULL,
0x00000002ff387819ULL, 0x000fe40000011634ULL, 0x0000000334347812ULL, 0x000fc600078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e027bULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fc800078110ffULL, 0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000122000017945ULL, 0x000fe60003800000ULL,
0x000000743700720cULL, 0x000fda0003f06070ULL, 0x000009b000008947ULL, 0x000fea0003800000ULL,
0x00000004733d7824ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x0000000435387824ULL, 0x000fe200078e0234ULL, 0x00000004043b7819ULL, 0x000fe200000006ffULL,
0x00000200ff3f7424ULL, 0x000fe200078e00ffULL, 0x014a00003d377984ULL, 0x000e620000000800ULL,
0x0000000173397824ULL, 0x040fe200078e023eULL, 0x0000002038387811ULL, 0x000fe200078e30ffULL,
0x00000001733c7824ULL, 0x000fe200078e0204ULL, 0x000001f03b417812ULL, 0x000fe200078ec0ffULL,
0x0000002073437824ULL, 0x040fe200078e00ffULL, 0x0000000173457810ULL, 0x000fc80007ffe0ffULL,
0xffffffe0433c7812ULL, 0x000fe400078ee23cULL, 0x0000000445407210ULL, 0x000fe40007ffe0ffULL,
0x000100003c437811ULL, 0x000fe200078e20ffULL, 0x00000004373a7824ULL, 0x002fe200078e00ffULL,
0x0000003875377217ULL, 0x000fca0007800000ULL, 0x014ac0003a3a7984ULL, 0x000e620000000800ULL,
0x0000000137387824ULL, 0x000fca00078e0a38ULL, 0x0000003873387217ULL, 0x000fca0007800000ULL,
0x0000000138377824ULL, 0x000fca00078e0a73ULL, 0x000000ff3700720cULL, 0x000fe20003f03070ULL,
0x0000003a21397224ULL, 0x002fc800078e0239ULL, 0x00005e0039387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000013700780cULL, 0x000fc60003f03070ULL, 0x014a04003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000273457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000023700780cULL, 0x000fc60003f03070ULL, 0x014a08003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000373457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fc80007f3e0ffULL, 0x00000039ff3b7210ULL, 0x000fe20000ffe4ffULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000033700780cULL, 0x000fe40003f03070ULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x014a0c003d387984ULL, 0x000ea20000000800ULL, 0x0000000473457810ULL, 0x000fc40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e0639ULL,
0x0000003e45397210ULL, 0x040fe20007ffe0ffULL, 0x0000002045457824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000043700780cULL, 0x000fe40003f03070ULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x014a10003d387984ULL, 0x000ea20000000800ULL, 0x0000000573457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe200078e023eULL, 0x0000000545457819ULL, 0x000fe400000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000053700780cULL, 0x000fe40003f03070ULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x014a14003d387984ULL, 0x000ea20000000800ULL, 0x0000000673457810ULL, 0x000fc40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x0000000145407824ULL, 0x000fe400078e0204ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x0000000145397824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000063700780cULL, 0x000fc60003f03070ULL, 0x014a18003d387984ULL, 0x000ea20000000800ULL,
0xffffffe045407812ULL, 0x000fe400078ee240ULL, 0x0000000773457810ULL, 0x000fe40007ffe0ffULL,
0x0001000040437811ULL, 0x002fc600078e20ffULL, 0x00000001453e7824ULL, 0x000fe400078e023eULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000e640000000800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e003fULL,
0x00000041383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000c101c46ULL,
0x000000073700780cULL, 0x000fc60003f03070ULL, 0x014a1c003d387984ULL, 0x000ea40000000800ULL,
0x00000002383c7819ULL, 0x004fca00000006ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fe400078e023eULL, 0x00000001453e7824ULL, 0x000fe400078e0204ULL,
0x00005e0038387625ULL, 0x000fc800078e003fULL, 0x0000002045457824ULL, 0x000fe200078e00ffULL,
0x0000004138387210ULL, 0x000fc80007f3e0ffULL, 0xffffffe0453e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff397224ULL, 0x000fc600008e0639ULL, 0x000100003e377811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e2000c101c46ULL,
0x0000084000007947ULL, 0x000fea0003800000ULL, 0x00000073043f7211ULL, 0x040fe200078fd8ffULL,
0x00000010043a7824ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe400078e30ffULL,
0x0000020000417802ULL, 0x000fe20000000f00ULL, 0x014a00003f377984ULL, 0x000e620000004800ULL,
0x000001f03a437812ULL, 0x000fe200078ec0ffULL, 0x000000013f397824ULL, 0x040fe200078e023eULL,
0x000000013f3d7810ULL, 0x040fe20007ffe0ffULL, 0x000000013f3b7824ULL, 0x000fc400078e0204ULL,
0x000000203f3c7824ULL, 0x000fe400078e00ffULL, 0x000000013d407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x0022a40000004800ULL, 0xffffffe03c377812ULL, 0x002fc800078ee23bULL,
0x0001000037457811ULL, 0x000fe200078e20ffULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x000000013d397824ULL, 0x040fe400078e023eULL,
0x000000203d3d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000b901c46ULL, 0x014a04003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03d407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000023f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fc80007f1e0ffULL,
0x00000039ff3d7210ULL, 0x000fe200007fe4ffULL, 0x000000013b397824ULL, 0x040fe400078e023eULL,
0x000000203b3b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e6000b901c46ULL, 0xffffffe03b407812ULL, 0x000fe200078ee240ULL,
0x014a08003f377984ULL, 0x000ea60000004800ULL, 0x0001000040457811ULL, 0x002fc400078e20ffULL,
0x000000033f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x000000013d397824ULL, 0x040fe200078e023eULL,
0x000000053d3d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e4000b901c46ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x014a0c003f377984ULL, 0x000ea40000004800ULL, 0x0001000040457811ULL, 0x002fc400078e20ffULL,
0x000000043f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe400000e0639ULL, 0x000000013b397824ULL, 0x040fe400078e023eULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a10003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03b407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000053f3d7810ULL, 0x000fc80007ffe0ffULL, 0x000000043d407210ULL, 0x000fe20007ffe0ffULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x000000013d397824ULL, 0x040fe400078e023eULL,
0x000000203d3d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000b901c46ULL, 0x014a14003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03d407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x002fe400078e20ffULL,
0x000000063f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0204ULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe400000e0639ULL, 0x000000013b397824ULL, 0x040fe400078e023eULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a18003f377984ULL, 0x000ea20000004800ULL,
0xffffffe03b407812ULL, 0x000fc800078ee240ULL, 0x00010000403d7811ULL, 0x002fe400078e20ffULL,
0x000000073f457810ULL, 0x000fc80007ffe0ffULL, 0x0000003e453e7210ULL, 0x040fe20007ffe0ffULL,
0x00000001453c7824ULL, 0x040fe400078e0204ULL, 0x0000002045457824ULL, 0x000fca00078e00ffULL,
0xffffffe0453c7812ULL, 0x000fe200078ee23cULL, 0x014ac00037387984ULL, 0x004e640000004800ULL,
0x0000003821387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x014a1c003f377984ULL, 0x000ea20000004800ULL, 0x000100003c3b7811ULL, 0x002fc600078e20ffULL,
0x014ac00037387984ULL, 0x004e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e023eULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fc800078110ffULL, 0x0000003bff3a7210ULL, 0x000fc800007fe4ffULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000357200720cULL, 0x000fe20003f04070ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000033600780cULL, 0x000fda0003f25270ULL, 0x0000014000008947ULL, 0x000fea0000800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000004ff387424ULL, 0x000fe200078e00ffULL,
0x0000000371397812ULL, 0x000fe200078ec0ffULL, 0x00000300ff377624ULL, 0x000fc600078e00ffULL,
0x000000033900780cULL, 0x000fe20003f05270ULL, 0xfffffffd38377424ULL, 0x000fca00078e0237ULL,
0x00000001373a7807ULL, 0x000fca0004000000ULL, 0x0000000171717824ULL, 0x000fe200078e023aULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400377824ULL, 0x000fe200078e0223ULL,
0x00006400713a7a10ULL, 0x040fe40007ffe0ffULL, 0x000000767100720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fe200078e00ffULL, 0x00014ac0233b7811ULL, 0x000fc600078e10ffULL,
0x0000640037377a24ULL, 0x000fc800078e023aULL, 0x0000600037387625ULL, 0x000fca00078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000357200720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x000fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fca0000011637ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0x00014a0023377811ULL, 0x000fc800078e10ffULL, 0x00000002ff387819ULL, 0x002fe40000011634ULL,
0x0000000634347819ULL, 0x000fc600000006ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fc60004000000ULL,
0x0000010038357824ULL, 0x000fe400078e0235ULL, 0x0000000177347824ULL, 0x000fe400078e0234ULL,
0x0000000123367824ULL, 0x140fe400078e0235ULL, 0x0000680034347a24ULL, 0x000fe400078e0235ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8b00720cULL, 0x000fe20003f05270ULL,
0x014b8000ff887f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b380073347f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3b7224ULL, 0x004fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x014b3c0073247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ff00387202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x014b3c0073247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001004247824ULL, 0x000fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fc80000011604ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fca00078ec0ffULL, 0x00000001243b7824ULL, 0x000fca00078e0235ULL,
0x014180003b367984ULL, 0x000ea80000000800ULL, 0x014380003b377984ULL, 0x0006620000000800ULL,
0x0000006f3600720bULL, 0x004fe20003f1d000ULL, 0x00011f127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe200078e00ffULL,
0x0000006f00387202ULL, 0x000fd40000000f00ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000037900780cULL, 0x000fe40003f05270ULL, 0x0000006f3600720bULL, 0x000fe20003f34000ULL,
0x00011ed27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x000000366f387209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x014580383b008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000386f347221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x000ea40000000800ULL, 0x0000003d1e1e7220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00011e227f007947ULL, 0x000fea000b800000ULL,
0x00001f7c3d347589ULL, 0x0004e400000e0000ULL, 0x000000341d1d7220ULL, 0x088fe20000410000ULL,
0x000000341c1c7220ULL, 0x080fe20000410000ULL, 0x0000003419197220ULL, 0x080fe20000410000ULL,
0x0000003418187220ULL, 0x080fe20000410000ULL, 0x0000003415157220ULL, 0x080fe20000410000ULL,
0x0000003414147220ULL, 0x080fe20000410000ULL, 0x0000003411117220ULL, 0x080fe20000410000ULL,
0x0000003410107220ULL, 0x080fe20000410000ULL, 0x000000340d0d7220ULL, 0x080fe20000410000ULL,
0x000000340c0c7220ULL, 0x080fe20000410000ULL, 0x0000003409097220ULL, 0x080fe20000410000ULL,
0x0000003408087220ULL, 0x080fe20000410000ULL, 0x0000003405057220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x0000003433337220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00011d327f007947ULL, 0x000fea000b800000ULL, 0x00001f7a3d347589ULL, 0x0006a400000e0000ULL,
0x000000341b1b7220ULL, 0x084fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x000000340e0e7220ULL, 0x080fe20000410000ULL,
0x000000340b0b7220ULL, 0x080fe20000410000ULL, 0x000000340a0a7220ULL, 0x080fe20000410000ULL,
0x0000003407077220ULL, 0x080fe20000410000ULL, 0x0000003406067220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x080fe20000410000ULL,
0x000000346d6d7220ULL, 0x080fe20000410000ULL, 0x0000003470707220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fda0007806039ULL,
0x8000003836360221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600250308ULL, 0x000ea40000000800ULL,
0x0000002537370220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001e371e7221ULL, 0x002fe20000010000ULL, 0x00000038006f7202ULL, 0x000fc40000000f00ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x00011b727f007947ULL, 0x000fea000b800000ULL, 0x00001f7c37277589ULL, 0x0004e400000e0000ULL,
0x00011bb27f007947ULL, 0x000fea000b800000ULL, 0x00001f7a37267589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000107c3b7810ULL, 0x002fe40007ffe0ffULL,
0x00000037003a7202ULL, 0x000fe40000000f00ULL, 0x00013f5000347802ULL, 0x000fc40000000f00ULL,
0x000121a000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL,
0x00013fa000347802ULL, 0x000fc40000000f00ULL, 0x0001215000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000b80028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x0000b8002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x0000008b7c00720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x0000007b7200720cULL, 0x000fc40003fc3070ULL, 0x0000008b7a00720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x0000007b7200720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x008fe80000004200ULL,
0x000000003838783bULL, 0x002e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000784c783bULL, 0x000ee20000004200ULL, 0x000000273434b232ULL, 0x004fc40000000000ULL,
0x000000273636b232ULL, 0x000fe40000000000ULL, 0x000000263535b232ULL, 0x080fe40000000000ULL,
0x000000263737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000273838b232ULL, 0x082fe40000000000ULL, 0x000000273a3ab232ULL, 0x000fe40000000000ULL,
0x000000263939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000263b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040b6e00000018ffULL,
0x000000018b3d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000018ffULL,
0x0000003d7c00720cULL, 0x000fc40005746470ULL, 0x0000003d7a00720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x050b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x020b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000501d1d7221ULL, 0x000fe20000010000ULL, 0x000000511c1c7221ULL, 0x000fe20000010000ULL,
0x0000005419197221ULL, 0x000fe20000010000ULL, 0x0000005518187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006932327221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x020fe20000010000ULL, 0x000000356e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521b1b7221ULL, 0x000fe20000010000ULL,
0x000000531a1a7221ULL, 0x000fe20000010000ULL, 0x0000005617177221ULL, 0x000fe20000010000ULL,
0x0000005716167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b6c6c7221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x020fe20000010000ULL,
0x0000003770707221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x0000007b7200720cULL, 0x000fc40003fc3070ULL, 0x0000007b7200720cULL, 0x000fe40003f03070ULL,
0x00000040ff3f7803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe2000001163dULL,
0x000000ffff3c7224ULL, 0x000fc600078e0035ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000334367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e027bULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4889ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x014b8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fc80007fde1ffULL,
0x0000003b393b7210ULL, 0x000fe400037fe5ffULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000120000017945ULL, 0x000fe60003800000ULL,
0x000000743700720cULL, 0x000fda0003fc6070ULL, 0x000009a00000e947ULL, 0x000fea0003800000ULL,
0x0000000473407824ULL, 0x000fe400078e00ffULL, 0x0000004003417824ULL, 0x000fe400078e0273ULL,
0x00000200ff437424ULL, 0x000fe200078e00ffULL, 0x014a000040377984ULL, 0x000e620000000800ULL,
0x00000010043a7824ULL, 0x000fe400078e00ffULL, 0x00000020733c7824ULL, 0x000fc600078e00ffULL,
0x000001f03a457812ULL, 0x000fe200078ec0ffULL, 0x0000000437377824ULL, 0x002fca00078e00ffULL,
0x014ac00037387984ULL, 0x000e640000000800ULL, 0x0000003821387224ULL, 0x002fc800078e0241ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fe20007fde0ffULL,
0x0000000435387824ULL, 0x000fc600078e0236ULL, 0x00000039ff3b7210ULL, 0x000fe200037fe4ffULL,
0x0000004038387824ULL, 0x000fca00078e00ffULL, 0x0000003875377217ULL, 0x000fca0007800000ULL,
0x0000000137387824ULL, 0x000fe400078e0a38ULL, 0x0000000173377824ULL, 0x000fc600078e0204ULL,
0x0000003873387217ULL, 0x040fe40007800000ULL, 0xffffffe03c397812ULL, 0x000fe400078ee237ULL,
0x0000003873377210ULL, 0x000fe40007ffe1ffULL, 0x0000c00039477811ULL, 0x000fe400078e20ffULL,
0x000000ff3700720cULL, 0x000fe40003fc3070ULL, 0x0000000141397810ULL, 0x000fd60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a040040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000000173397810ULL, 0x000fe40007ffe0ffULL,
0x000000013700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000241397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x014a080040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fc80007fde0ffULL,
0x00000039ff3b7210ULL, 0x000fe400037fe4ffULL, 0x0000000273397810ULL, 0x000fe40007ffe0ffULL,
0x000000023700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000341397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a0c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000000373397810ULL, 0x000fe40007ffe0ffULL,
0x000000033700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe200078e0204ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000441397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x014a100040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000000473397810ULL, 0x000fe40007ffe0ffULL,
0x000000043700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000541397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x014a140040387984ULL, 0x000ea40000000800ULL, 0x00000004383e7824ULL, 0x004fca00078e00ffULL,
0x014ac0003e387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x00000045383c7210ULL, 0x000fc80007fde0ffULL,
0x00000039ff3d7210ULL, 0x000fe400037fe4ffULL, 0x0000000573397810ULL, 0x000fe40007ffe0ffULL,
0x000000053700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000641397810ULL, 0x040fe40007ffe0ffULL, 0x0000c00038477811ULL, 0x002fe400078e20ffULL,
0x0000000741417810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a180040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fca00078e00ffULL, 0x014ac0003e387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x00000045383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x0000000673397810ULL, 0x000fe40007ffe0ffULL, 0x000000063700780cULL, 0x000fc60003fc3070ULL,
0x0000000139387824ULL, 0x040fe200078e0204ULL, 0x0000000539397819ULL, 0x000fc800000006ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000f101c46ULL,
0x014a1c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383c7824ULL, 0x004fca00078e00ffULL,
0x014ac0003c387984ULL, 0x000ea40000000800ULL, 0x0000003821387224ULL, 0x004fe200078e0241ULL,
0x0000000773417810ULL, 0x000fc60007ffe0ffULL, 0x00005e0038387625ULL, 0x000fc800078e0043ULL,
0x00000001413e7824ULL, 0x040fe200078e0204ULL, 0x0000004538387210ULL, 0x000fe20007fde0ffULL,
0x0000002041417824ULL, 0x000fc800078e00ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073700780cULL, 0x000fe40003fc3070ULL, 0xffffffe0413e7812ULL, 0x000fc800078ee23eULL,
0x0000c0003e3b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x00000073043e7211ULL, 0x040fe200078fd8ffULL, 0x00000010043a7824ULL, 0x000fe200078e00ffULL,
0x0000020000417802ULL, 0x000fc60000000f00ULL, 0x014a00003e377984ULL, 0x000e620000004800ULL,
0x0000004003407824ULL, 0x000fe200078e023eULL, 0x000001f03a437812ULL, 0x000fe400078ec0ffULL,
0x014ac00037387984ULL, 0x002e640000004800ULL, 0x0000003821387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013e387824ULL, 0x000fc800078e0204ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000203e397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000140397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a04003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000013e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000439387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000240397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x014a08003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000023e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000340397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a0c003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000033e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000439387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000440397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x014a10003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000043e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0204ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000540397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x014a14003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000053e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000439387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fe400078ee238ULL,
0x0000000640397810ULL, 0x000fe40007ffe0ffULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000000740407810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a18003e377984ULL, 0x000ea80000004800ULL,
0x014ac00037387984ULL, 0x004ea40000004800ULL, 0x0000003821387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000063e397810ULL, 0x000fca0007ffe0ffULL,
0x0000000139387824ULL, 0x040fe400078e0204ULL, 0x0000002039397824ULL, 0x000fca00078e00ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x014a1c003e377984ULL, 0x000ea80000004800ULL, 0x014ac00037387984ULL, 0x004ea40000004800ULL,
0x0000003821387224ULL, 0x004fc800078e0240ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x000000073e417810ULL, 0x000fc80007ffe0ffULL, 0x00000004413c7210ULL, 0x040fe20007ffe0ffULL,
0x0000002041417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007fde0ffULL,
0xffffffe0413c7812ULL, 0x000fe200078ee23cULL, 0x000000ffff397224ULL, 0x000fc600030e0639ULL,
0x0000c0003c3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000357200720cULL, 0x000fc80003fc4070ULL, 0x000000ff34377207ULL, 0x040fe40003000000ULL,
0x000000ff34387207ULL, 0x000fe40007000000ULL, 0x0000003736377210ULL, 0x000fc80007ffe0ffULL,
0x00000002ff347819ULL, 0x000fe20000011637ULL, 0x0000004037377824ULL, 0x000fc800078e00ffULL,
0x0000030034347a24ULL, 0x000fe200078e0235ULL, 0x000000c037377812ULL, 0x000fe200078ec0ffULL,
0x0000000177357824ULL, 0x000fc800078e0238ULL, 0x0000010034347824ULL, 0x000fe200078e0237ULL,
0x00014a0023377811ULL, 0x000fc800078e10ffULL, 0x0000002034367810ULL, 0x000fca0007ffe0ffULL,
0x0000680035347a24ULL, 0x000fe200078e0236ULL, 0x0000003623367210ULL, 0x040fe20007ffe0ffULL,
0x00000004ff357424ULL, 0x000fe400078e00ffULL, 0x0000000123347824ULL, 0x000fe200078e0234ULL,
0x000000753600720cULL, 0x000fc60003fc6070ULL, 0x0000660034347625ULL, 0x000fd400078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff887f8cULL, 0x000e62000c80043fULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x0000f9727f007947ULL, 0x000fea000b800000ULL, 0x00001f7c37277589ULL, 0x0004e400000e0000ULL,
0x0000f9b27f007947ULL, 0x000fea000b800000ULL, 0x00001f7a37267589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0001621000347802ULL, 0x000fc40000000f00ULL,
0x0000fee000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL,
0x0001626000347802ULL, 0x000fc40000000f00ULL, 0x0000fe9000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000b80086347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000ff3f00720cULL, 0x000fe20003fc5270ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000b80081387811ULL, 0x000fe200078e20ffULL,
0x0000034000017945ULL, 0x000fe40003800000ULL, 0x000000003434783bULL, 0x004ea80000000200ULL,
0x00000000845c783bULL, 0x000fe80000004200ULL, 0x000000008364783bULL, 0x000fe80000004200ULL,
0x00000000823c783bULL, 0x000fe80000004200ULL, 0x000000003838783bULL, 0x002e680000000200ULL,
0x000000008040783bULL, 0x000f280000004200ULL, 0x000000007f44783bULL, 0x000ee80000004200ULL,
0x000000007e48783bULL, 0x000ee80000004200ULL, 0x000000007d4c783bULL, 0x000ee40000004200ULL,
0x000000273434b232ULL, 0x00cfc40000000000ULL, 0x000000273636b232ULL, 0x000fe40000000000ULL,
0x000000263535b232ULL, 0x080fe40000000000ULL, 0x000000263737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000273838b232ULL, 0x082fe40000000000ULL,
0x000000273a3ab232ULL, 0x000fe40000000000ULL, 0x000000263939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000263b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040f7000000018ffULL, 0x0000003e3434723cULL, 0x000f7000000018ffULL,
0x000000403850723cULL, 0x070b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x040b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x000b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000501d1d7221ULL, 0x020fe20000010000ULL, 0x000000511c1c7221ULL, 0x000fe20000010000ULL,
0x0000005419197221ULL, 0x000fe20000010000ULL, 0x0000005518187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006932327221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x000fe20000010000ULL, 0x000000356e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521b1b7221ULL, 0x020fe20000010000ULL,
0x000000531a1a7221ULL, 0x000fe20000010000ULL, 0x0000005617177221ULL, 0x000fe20000010000ULL,
0x0000005716167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b6c6c7221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x000fe20000010000ULL,
0x0000003770707221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000018b8b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x000000878b00720cULL, 0x000fe20003f06070ULL,
0x000000ffff377224ULL, 0x002fd800078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffb10000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x000003007b7b7a10ULL, 0x000fc80007ffe0ffULL,
0x000000747b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffebbf000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000002a7919ULL, 0x000e620000002500ULL, 0x000000ffff297224ULL, 0x000fe200078e0005ULL,
0x0000000700267202ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe200078e0006ULL,
0x0000000f00227202ULL, 0x000fe20000000f00ULL, 0x000000ffff257224ULL, 0x000fe400078e0008ULL,
0x000000ffff237224ULL, 0x000fe400078e0009ULL, 0x000000ffff217224ULL, 0x000fe400078e000aULL,
0x000000ffff247224ULL, 0x000fc400078e000bULL, 0x000000ffff057224ULL, 0x000fe200078e000eULL,
0x000000742a00720cULL, 0x002fda0003f06070ULL, 0x0000036000000947ULL, 0x000fea0003800000ULL,
0x018000001e037810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e001eULL,
0x000169e000067802ULL, 0x000fc40000000f00ULL, 0x0000f56000007944ULL, 0x008fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001e00037308ULL, 0x000e640000001000ULL,
0xbf80000003047423ULL, 0x002fc8000000001eULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000f240000000000ULL, 0x00000002ff3b7819ULL, 0x010fe20000011604ULL,
0x0000f1527f007947ULL, 0x000fea000b800000ULL, 0x00001f3b03047589ULL, 0x00c4e400000e0000ULL,
0x0000000000067919ULL, 0x000f220000000000ULL, 0x0000001d041d7220ULL, 0x048fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000c040c7220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000006e046e7220ULL, 0x000fe20000410000ULL, 0x00000008063b7811ULL, 0x016fe200078ff0ffULL,
0x0000f0627f007947ULL, 0x000fea000b800000ULL, 0x00001f3b03037589ULL, 0x0002a400000e0000ULL,
0x0000001b031b7220ULL, 0x044fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000000503057220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000002103217220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x040fe20000410000ULL, 0x0000006c036c7220ULL, 0x040fe20000410000ULL,
0x0000006d036d7220ULL, 0x040fe20000410000ULL, 0x0000007003707220ULL, 0x000fc20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000151407723eULL, 0x000fc400000000ffULL,
0x000000111008723eULL, 0x000fe400000000ffULL, 0x0000000d0c09723eULL, 0x000fe400000000ffULL,
0x00000013120f723eULL, 0x000fe400000000ffULL, 0x0000001d1c03723eULL, 0x000fe400000000ffULL,
0x000000191806723eULL, 0x000fe400000000ffULL, 0x00000023250a723eULL, 0x000fc400000000ffULL,
0x00000029320b723eULL, 0x000fe400000000ffULL, 0x000000336e0c723eULL, 0x000fe400000000ffULL,
0x0000001b1a0d723eULL, 0x000fe400000000ffULL, 0x00000017160e723eULL, 0x000fe400000000ffULL,
0x000000220510723eULL, 0x000fe400000000ffULL, 0x000000242111723eULL, 0x000fc400000000ffULL,
0x000000262712723eULL, 0x000fe400000000ffULL, 0x000000316c13723eULL, 0x000fe400000000ffULL,
0x0000006d7014723eULL, 0x000fc400000000ffULL, 0x0000000000197919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff1b7819ULL, 0x004fc40000011619ULL,
0x0000000819287811ULL, 0x000fe400078ff0ffULL, 0x000000011b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b1a7824ULL, 0x040fe200078e00ffULL, 0x000000031b157819ULL, 0x040fe200000006ffULL,
0x000000081b177824ULL, 0x040fe200078e00ffULL, 0x000000021b057810ULL, 0x040fe20007ffe0ffULL,
0x000000081b1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff815187812ULL, 0x000fe200078ee204ULL,
0x000000081b227824ULL, 0x040fe200078e00ffULL, 0x000000031b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b207824ULL, 0x042fe200078e00ffULL, 0x000000061b167810ULL, 0x040fe20007ffe0ffULL,
0x000000081b267824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fc400078ee205ULL,
0x000000051b157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8171c7812ULL, 0x000fe200078ee204ULL,
0x0000080079047824ULL, 0x000fe200078e00ffULL, 0x000000041b057810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81d247812ULL, 0x000fe400078ee216ULL, 0x000000031b167819ULL, 0x000fe400000006ffULL,
0xfffffff822227812ULL, 0x000fe200078ee215ULL, 0x0000000419157824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fc400078ee205ULL, 0xfffffff816167812ULL, 0x000fe400078ee21bULL,
0x0000a00004057810ULL, 0x000fe40007ffe0ffULL, 0xffffffff1b177810ULL, 0x000fe20007ffe0ffULL,
0x00000008281b7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x0000001016167824ULL, 0x100fe200078e0205ULL, 0x0000000518187211ULL, 0x080fe200078e20ffULL,
0x000000101a1a7824ULL, 0x000fe200078e0205ULL, 0xfffffff826267812ULL, 0x000fe200078ee217ULL,
0x000000101c1c7824ULL, 0x100fe200078e0205ULL, 0xfffffff81b287812ULL, 0x000fe200078ee228ULL,
0x0000001020207824ULL, 0x000fe200078e0205ULL, 0x0000000526267211ULL, 0x000fe200078e20ffULL,
0x0000000116167824ULL, 0x000fc400078e0215ULL, 0x0000001022227824ULL, 0x100fe200078e0205ULL,
0x0000002015207210ULL, 0x040fe20007ffe0ffULL, 0x0000000115177824ULL, 0x040fe200078e0218ULL,
0x0000000316007388ULL, 0x0003e20000000800ULL, 0x0000001024247824ULL, 0x100fe400078e0205ULL,
0x00000001151a7824ULL, 0x040fe200078e021aULL, 0x0000000617007388ULL, 0x0003e20000000800ULL,
0x0000000115197824ULL, 0x040fe400078e021cULL, 0x0000001028287824ULL, 0x000fe200078e0205ULL,
0x000000071a007388ULL, 0x0003e20000000800ULL, 0x00000001151b7824ULL, 0x000fc400078e0222ULL,
0x0000000115247824ULL, 0x040fe200078e0224ULL, 0x0000000819007388ULL, 0x0003e20000000800ULL,
0x00000001151d7824ULL, 0x040fe400078e0226ULL, 0x0000000115287824ULL, 0x000fe200078e0228ULL,
0x0000000920007388ULL, 0x0003e80000000800ULL, 0x0000000a1b007388ULL, 0x0003e80000000800ULL,
0x0000000b24007388ULL, 0x0003e80000000800ULL, 0x0000000c1d007388ULL, 0x0003e80000000800ULL,
0x0000000d28007388ULL, 0x0003e80000000800ULL, 0x0004000e17007388ULL, 0x0003e80000000800ULL,
0x0004000f1a007388ULL, 0x0003e80000000800ULL, 0x0004001019007388ULL, 0x0003e80000000800ULL,
0x0004001120007388ULL, 0x0003e80000000800ULL, 0x000400121b007388ULL, 0x0003e80000000800ULL,
0x0004001324007388ULL, 0x0003e80000000800ULL, 0x000400141d007388ULL, 0x0003e20000000800ULL,
0x0000002000007947ULL, 0x000fea0003800000ULL, 0x0001723000287802ULL, 0x002fc40000000f00ULL,
0x0000ef6000007944ULL, 0x008fea0003c00000ULL, 0x00000300ff187624ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000011800780cULL, 0x000fda0003f05270ULL,
0x0000267000008947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x002e620000000000ULL,
0x0000580000027a02ULL, 0x000fc60000000f00ULL, 0x00000000000b7919ULL, 0x000ea40000002600ULL,
0x00006c0002027a24ULL, 0x000fc800078e02ffULL, 0x0000030002077a24ULL, 0x040fe200078e02ffULL,
0x0000000f02037811ULL, 0x000fc800078e10ffULL, 0xfffffff0030c7812ULL, 0x000fca00078ec0ffULL,
0x00000080070e7824ULL, 0x040fe400078e020cULL, 0x0000001006097824ULL, 0x002fe400078e0204ULL,
0x0000008007027824ULL, 0x000fe400078e020eULL, 0x0000580000077a24ULL, 0x004fe200078e020bULL,
0x00a0000009107984ULL, 0x0002a40000000c00ULL, 0x0000007f02027810ULL, 0x000fe20007ffe0ffULL,
0x00000300070f7a24ULL, 0x000fc600078e02ffULL, 0xffffff80020d7812ULL, 0x000fe200078ec0ffULL,
0x000000010f087824ULL, 0x000fc600078e022aULL, 0x000070000d037a10ULL, 0x000fc80007f1e0ffULL,
0x0000000308027211ULL, 0x000fe200078258ffULL, 0x00007100ff037624ULL, 0x000fe200000e06ffULL,
0x000070000c147a10ULL, 0x000fc80007f1e0ffULL, 0x0000000308037211ULL, 0x000fe400008f5cffULL,
0x000000ff7900720cULL, 0x040fe40003f25270ULL, 0x00007100ff167a10ULL, 0x000fe200007fe4ffULL,
0x0000020079027825ULL, 0x000fcc00078e0002ULL, 0x0000001006027825ULL, 0x000fc800078e0002ULL,
0x0000011000001947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x002e620000000000ULL,
0x0000008008097824ULL, 0x000fe400078e00ffULL, 0x000000100a0b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff177819ULL, 0x000fe4000001160aULL, 0x00007000090a7a10ULL, 0x000fe40007b5e00eULL,
0x000000700b157812ULL, 0x000fe400078ec0ffULL, 0x00000019ff0b7819ULL, 0x000fc40000011608ULL,
0x0000000c17087812ULL, 0x000fe400078ec0ffULL, 0x0000001415097210ULL, 0x000fe4000791e009ULL,
0x000071000b177a10ULL, 0x000fe400017e64ffULL, 0x0000000a080a7210ULL, 0x040fe40007c7e015ULL,
0x0000000908087210ULL, 0x000fe40007f5e0ffULL, 0x00000016ff097210ULL, 0x000fc400007e240bULL,
0x00000017ff0b7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff097224ULL, 0x000fca00010e0609ULL,
0x0000006f08007986ULL, 0x0003e8000c101906ULL, 0x0000001e0a007986ULL, 0x0003e4000c101906ULL,
0x000000ff0600720cULL, 0x002fe20003f05270ULL, 0x0000001002007986ULL, 0x004fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff7900720cULL, 0x000fda0000705670ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff027424ULL, 0x000fe200078e00ffULL, 0xffffffff18097810ULL, 0x000fc60007ffe0ffULL,
0x0000700007027625ULL, 0x000fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009020279a8ULL, 0x000ea400099ee1c6ULL, 0x000000090200720cULL, 0x004fc80003f05270ULL,
0x00000001ff077807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000007ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x000ea40000000000ULL,
0x000000ff0200720cULL, 0x004fda0003f05270ULL, 0x0000220000008947ULL, 0x000fea0003800000ULL,
0x000000ff7900720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001006037824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe40000011606ULL,
0x000000140f027211ULL, 0x000fe400078038ffULL, 0x0000007003077812ULL, 0x002fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fe400078ec0ffULL, 0x000000160f037211ULL, 0x000fe400000f3cffULL,
0x0000000208027210ULL, 0x000fc8000791e007ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602087981ULL, 0x000328000c1e1900ULL, 0x0000800602097981ULL, 0x000322000c1e1900ULL,
0x000000021800780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006020b7981ULL, 0x002322000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800602117981ULL, 0x002322000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000602137981ULL, 0x002322000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800602157981ULL, 0x002322000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081800780cULL, 0x002fe20003f06070ULL, 0x0003000602177981ULL, 0x000318000c1e1900ULL,
0x0003800602190981ULL, 0x000324000c1e1900ULL, 0x0000000718027810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff077819ULL, 0x000fc80000011602ULL, 0x000000ff0700720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000c0f1d7211ULL, 0x000fe200078038ffULL,
0x000000ffff1b7224ULL, 0x010fe200078e0008ULL, 0x000000ff00107202ULL, 0x000fe20000000f00ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000070001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0f0a7211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0a7a10ULL, 0x000fc400017e240aULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000407007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000810027810ULL, 0x040fe40007ffe0ffULL,
0x0000000110037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffc8006021b7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000910027810ULL, 0x042fe40007ffe0ffULL,
0x0000000210037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000908087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffd000602097981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000310037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffd8006020b7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000410037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001108087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffe000602117981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000510037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffe800602137981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000610037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001508087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xffff000602157981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000710037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001708087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xffff800602177981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f10027810ULL, 0x002fe40007ffe0ffULL,
0x0000001908087209ULL, 0x000fe40007810000ULL, 0x0000030002007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0x0000000602197981ULL, 0x000326000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fe40007ffe0ffULL,
0x0000000aff0a7210ULL, 0x000fe20000ffe4ffULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x000ea40000000000ULL, 0x0000001006027824ULL, 0x006fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000102037824ULL, 0x000fca00078e0203ULL,
0x0000000803007388ULL, 0x0103e40000000800ULL, 0x000070000d027a10ULL, 0x000fe20007f1e0ffULL,
0x0000020079417824ULL, 0x040fe200078e00ffULL, 0x00000017ff437819ULL, 0x000fe20000011679ULL,
0x0000001006077824ULL, 0x042fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011606ULL,
0x00007100ff037624ULL, 0x000fe200000e06ffULL, 0x000000070600780cULL, 0x000fe20003f04070ULL,
0x0000100079117824ULL, 0x000fe200078e00ffULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x000008000f087825ULL, 0x000fe200078e0002ULL, 0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000004108087210ULL, 0x000fe20007f3e0ffULL,
0x0000001006137824ULL, 0x000fe200078e0211ULL, 0x000070000c447a10ULL, 0x000fe20007f5e0ffULL,
0x0000001079158824ULL, 0x000fe200078e0206ULL, 0x0000000a07077210ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200008e0643ULL, 0x000070000e407a10ULL, 0x000fe20007f3e0ffULL,
0x00007100ff467624ULL, 0x000fe200010e06ffULL, 0x000000440f0c8211ULL, 0x000fe200078438ffULL,
0x0000001006087825ULL, 0x040fe200078e0008ULL, 0x0000000679178211ULL, 0x000fe200078e20ffULL,
0x0000000007077984ULL, 0x000e620000000800ULL, 0x000000460f0d8211ULL, 0x040fe200010f3cffULL,
0x00007100ff427624ULL, 0x000fe200008e06ffULL, 0x000000400f0a8211ULL, 0x000fe200078238ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008137faeULL, 0x0005e2000b901c46ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x00000010060c8825ULL, 0x040fe200078e000cULL,
0x000000420f0b8211ULL, 0x000fe200008f3cffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x0000418017178811ULL, 0x000fe200078e20ffULL, 0x00000010060a8825ULL, 0x000fe200078e000aULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000000000a158faeULL, 0x0009e2000b901c46ULL, 0x0000000000127805ULL, 0x004fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000000c178faeULL, 0x0005e2000b901c46ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x010fe2000001ff00ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x004fe2000001ff00ULL, 0x00000bb000009947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x0000000100477802ULL, 0x000fc80000000f00ULL, 0x0000030047007a0cULL, 0x000fda0003f06070ULL,
0x000001c000000947ULL, 0x000fea0003800000ULL, 0x000000070600780cULL, 0x000fe20003f44070ULL,
0x000008000f087825ULL, 0x000fe200078e0002ULL, 0x00000001470c7812ULL, 0x000fc600078ec0ffULL,
0x00000800470a7824ULL, 0x000fe200078e00ffULL, 0x0000004108087210ULL, 0x000fc80007f1e0ffULL,
0x000008000a327812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe400000e0643ULL,
0x00000002790ba824ULL, 0x100fe200078e020cULL, 0x000000400f0aa211ULL, 0x000fe200078038ffULL,
0x00000002790da824ULL, 0x000fe200078e020cULL, 0x000000440f0ca211ULL, 0x000fe200078238ffULL,
0x0000000111317824ULL, 0x000fe200078e0232ULL, 0x000000060b33a211ULL, 0x000fe200078e18ffULL,
0x000000080d35a824ULL, 0x000fe200078e0206ULL, 0x000000420f0ba211ULL, 0x040fe200000f3cffULL,
0x0000001006317824ULL, 0x040fe200078e0231ULL, 0x000000460f0da211ULL, 0x000fe200008f3cffULL,
0x0000001006087825ULL, 0x000fe200078e0008ULL, 0x000045803333a811ULL, 0x000fc400078e20ffULL,
0x000041803535a811ULL, 0x000fe200078e20ffULL, 0x00000010060aa825ULL, 0x040fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008317faeULL, 0x0005e6000b901c46ULL,
0x00000010060ca825ULL, 0x000fe200078e000cULL, 0x000000000a33afaeULL, 0x0005e8000b901c46ULL,
0x000000000c35afaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff47087810ULL, 0x004fe20007ffe0ffULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fc40000011606ULL, 0x00000002ff3a7819ULL, 0x000fe20000011606ULL,
0x0000008008097824ULL, 0x040fe200078e00ffULL, 0x000000700b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000080008087824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000083a387824ULL, 0x000fe200078e00ffULL, 0x00000080090a7812ULL, 0x000fe200078ec0ffULL,
0x0000000406097824ULL, 0x000fe200078e00ffULL, 0x000000033a327819ULL, 0x040fe200000006ffULL,
0x000000083a377824ULL, 0x040fe200078e00ffULL, 0x000000083a3e7810ULL, 0x040fe20007ffe0ffULL,
0x00000100790a7824ULL, 0x000fe200078e020aULL, 0x0000000c093c7812ULL, 0x000fe200078ec0ffULL,
0x000000083a097824ULL, 0x000fe200078e00ffULL, 0x0000080008087812ULL, 0x000fe200078ec0ffULL,
0x000000083a457824ULL, 0x000fe200078e00ffULL, 0x0000000a0c0a7210ULL, 0x000fe20007ffe00bULL,
0x000000083a487824ULL, 0x040fe200078e00ffULL, 0x000000013a0b7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000a0c7984ULL, 0x000ea20000000800ULL,
0xfffffff832337812ULL, 0x000fe200078ee20bULL, 0x000000083e0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff809097812ULL, 0x000fe200078ee23aULL, 0x004580000a317984ULL, 0x0008e20000000800ULL,
0x0000018011087810ULL, 0x000fe40007ffe008ULL, 0xfffffff80b0b7812ULL, 0x000fe400078ee23eULL,
0x0000000809097211ULL, 0x000fe400078e20ffULL, 0x000000023a0d7810ULL, 0x040fe20007ffe0ffULL,
0x000000083a0a7824ULL, 0x050fe200078e00ffULL, 0x000000033a327810ULL, 0x000fe20007ffe0ffULL,
0x000000013c097824ULL, 0x000fe200078e0209ULL, 0x000000053a347810ULL, 0x000fe20007ffe0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e0208ULL, 0xfffffff80a357812ULL, 0x000fc400078ee20dULL,
0x00000008330a7211ULL, 0x000fe200078e20ffULL, 0x000000013c0d7824ULL, 0x000fe200078e020bULL,
0x0000000009097984ULL, 0x000f220000000800ULL, 0x000000043a0b7810ULL, 0x000fe40007ffe0ffULL,
0x000000013c0a7824ULL, 0x000fe200078e020aULL, 0x000000000d367984ULL, 0x0003e20000000800ULL,
0xfffffff838397812ULL, 0x000fe400078ee20bULL, 0xfffffff837337812ULL, 0x000fe200078ee232ULL,
0x000000000a0b7984ULL, 0x000fe20000000800ULL, 0xfffffff845457812ULL, 0x000fe200078ee234ULL,
0x0000001039327824ULL, 0x100fe200078e0208ULL, 0x000000063a347810ULL, 0x040fe20007ffe0ffULL,
0x00000010330d7824ULL, 0x002fe200078e0208ULL, 0xffffffff3a337810ULL, 0x000fe20007ffe0ffULL,
0x000000013c327824ULL, 0x000fe200078e0232ULL, 0x000400000a377984ULL, 0x000fe20000000800ULL,
0x0000030047007a0cULL, 0x000fc40003f06070ULL, 0xfffffff848397812ULL, 0x000fe200078ee233ULL,
0x0000000c070c7221ULL, 0x004fe20000010100ULL, 0x0000001045337824ULL, 0x000fe200078e0208ULL,
0x000000010f0f7810ULL, 0x000fe40007ffe0ffULL, 0x3fb8aa3b0c0c7820ULL, 0x000fe20000410000ULL,
0x000000013c337824ULL, 0x000fe200078e0233ULL, 0x0000000147477810ULL, 0x000fc80007ffe0ffULL,
0x0000000c000c7308ULL, 0x000ee40000000800ULL, 0x000000310c3b7220ULL, 0x008fe20000410000ULL,
0x00000010350c7824ULL, 0x000fe400078e0208ULL, 0x000000083a357824ULL, 0x000fe200078e00ffULL,
0x000000303b307221ULL, 0x000fe20000010000ULL, 0x00001f3a3b3d7589ULL, 0x000e6200000e0000ULL,
0x0000000c3c0c7210ULL, 0x040fe20007ffe0ffULL, 0x000000013c317824ULL, 0x000fe200078e020dULL,
0xfffffff835357812ULL, 0x000fe200078ee234ULL, 0x00040000323a7984ULL, 0x000fe60000000800ULL,
0x0000000835347211ULL, 0x000fe200078e20ffULL, 0x000000000c0d7984ULL, 0x000ea20000000800ULL,
0x0000001039357824ULL, 0x000fc600078e0208ULL, 0x00000000310a7984ULL, 0x000fe20000000800ULL,
0x000000013c347824ULL, 0x040fe400078e0234ULL, 0x000000013c357824ULL, 0x000fe200078e0235ULL,
0x0000000032087984ULL, 0x000fe20000000800ULL, 0x20000009ff3c7230ULL, 0x110fe40000004100ULL,
0x30000009ff097230ULL, 0x000fe20000004100ULL, 0x000400000c387984ULL, 0x000fe80000000800ULL,
0x00000000330c7984ULL, 0x000fe20000000800ULL, 0x0000003d092e7223ULL, 0x082fe2000001002eULL,
0x0000003d3c2f7223ULL, 0x000fe2000001002fULL, 0x20000037ff3c7230ULL, 0x100fe20000004100ULL,
0x00001f3e3b3f7589ULL, 0x0002e200000e0000ULL, 0x30000037ff377230ULL, 0x000fc60000004100ULL,
0x0000000034097984ULL, 0x000f280000000800ULL, 0x0004000034327984ULL, 0x0005220000000800ULL,
0x20000036ff3e7230ULL, 0x102fe40000004100ULL, 0x30000036ff3b7230ULL, 0x000fe20000004100ULL,
0x0004000031397984ULL, 0x000e620000000800ULL, 0x2000000bff367230ULL, 0x100fe40000004100ULL,
0x3000000bff0b7230ULL, 0x000fe20000004100ULL, 0x0004000033317984ULL, 0x000e640000000800ULL,
0x0000003d362b7223ULL, 0x080fe2000001002bULL, 0x2000000dff367230ULL, 0x104fe20000004100ULL,
0x0000003d0b2a7223ULL, 0x000fe2000001002aULL, 0x0004000035337984ULL, 0x000ea20000000800ULL,
0x3000000dff0d7230ULL, 0x000fe20000004100ULL, 0x0000003f3c297223ULL, 0x088fe20000010029ULL,
0x2000000aff347230ULL, 0x100fe20000004100ULL, 0x00000000350b7984ULL, 0x0006a20000000800ULL,
0x0000003f37287223ULL, 0x000fe20000010028ULL, 0x0000003d0d267223ULL, 0x080fe20000010026ULL,
0x3000000aff0d7230ULL, 0x000fe20000004100ULL, 0x0000003d34237223ULL, 0x000fe20000010023ULL,
0x20000008ff0a7230ULL, 0x000fe20000004100ULL, 0x0000003f3e2d7223ULL, 0x000fe2000001002dULL,
0x20000038ff3c7230ULL, 0x000fe20000004100ULL, 0x0000003d0d227223ULL, 0x080fe20000010022ULL,
0x30000008ff357230ULL, 0x008fe20000004100ULL, 0x0000003d0a1f7223ULL, 0x000fe2000001001fULL,
0x2000003aff0a7230ULL, 0x000fe20000004100ULL, 0x0000003f3b2c7223ULL, 0x000fe2000001002cULL,
0x2000000cff087230ULL, 0x000fe20000004100ULL, 0x0000003d351e7223ULL, 0x000fe2000001001eULL,
0x3000003aff0d7230ULL, 0x000fe20000004100ULL, 0x0000003f0a1d7223ULL, 0x000fe2000001001dULL,
0x3000000cff0c7230ULL, 0x000fe20000004100ULL, 0x0000003d08177223ULL, 0x000fe20000010017ULL,
0x20000009ff087230ULL, 0x110fe20000004100ULL, 0x0000003f0d1c7223ULL, 0x000fe2000001001cULL,
0x30000009ff0a7230ULL, 0x000fe20000004100ULL, 0x0000003d0c1b7223ULL, 0x080fe2000001001bULL,
0x20000032ff097230ULL, 0x100fe20000004100ULL, 0x0000003d36277223ULL, 0x000fe20000010027ULL,
0x30000032ff0d7230ULL, 0x000fe20000004100ULL, 0x0000003f3c257223ULL, 0x080fe20000010025ULL,
0x20000039ff347230ULL, 0x102fe20000004100ULL, 0x0000003f09187223ULL, 0x080fe20000010018ULL,
0x30000038ff377230ULL, 0x000fe20000004100ULL, 0x0000003f0d167223ULL, 0x080fe20000010016ULL,
0x30000039ff397230ULL, 0x000fe20000004100ULL, 0x0000003f34217223ULL, 0x080fe20000010021ULL,
0x20000031ff357230ULL, 0x100fe20000004100ULL, 0x0000003f37247223ULL, 0x080fe20000010024ULL,
0x30000031ff0c7230ULL, 0x000fe20000004100ULL, 0x0000003f39207223ULL, 0x080fe20000010020ULL,
0x20000033ff0d7230ULL, 0x104fe20000004100ULL, 0x0000003f351a7223ULL, 0x080fe2000001001aULL,
0x30000033ff337230ULL, 0x000fe20000004100ULL, 0x0000003f0c157223ULL, 0x000fe20000010015ULL,
0x2000000bff097230ULL, 0x100fe20000004100ULL, 0x0000003d08137223ULL, 0x080fe20000010013ULL,
0x3000000bff0b7230ULL, 0x000fe20000004100ULL, 0x0000003d0a197223ULL, 0x000fe20000010019ULL,
0x0000003f0d107223ULL, 0x000fe20000010010ULL, 0x0000003d09147223ULL, 0x000fe20000010014ULL,
0x0000003f330e7223ULL, 0x000fe2000001000eULL, 0x0000003d0b127223ULL, 0x000fe20000010012ULL,
0xfffff48000008947ULL, 0x000fea000383ffffULL, 0x0180000030027810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x7f80000002027812ULL, 0x000fe200078ec0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0001913000067802ULL, 0x000fc40000000f00ULL,
0x0000ce1000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003000037308ULL, 0x000ea40000001000ULL,
0xbf80000003027423ULL, 0x004fc80000000030ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff0b7819ULL, 0x004fc4000001160aULL, 0x000000080a0d7811ULL, 0x040fe200078ff0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x000000030b0f7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0b02067589ULL, 0x000ea200000e0000ULL, 0x000000040b117810ULL, 0x040fe20007ffe0ffULL,
0x000000080b307824ULL, 0x042fe200078e00ffULL, 0x000000030b327819ULL, 0x040fe200000006ffULL,
0x00001f0d02077589ULL, 0x00032200000e0000ULL, 0x000000080b347824ULL, 0x000fe400078e00ffULL,
0x000000080d367824ULL, 0x000fca00078e00ffULL, 0xfffffff836367812ULL, 0x000fc800078ee20dULL,
0x0000000536367211ULL, 0x000fe200078e20ffULL, 0x0000002f062f7220ULL, 0x044fe20000410000ULL,
0x0000002e062e7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001706177220ULL, 0x040fe20000410000ULL,
0x0000001b06027220ULL, 0x042fe20000410000ULL, 0x0000001306137220ULL, 0x040fe20000410000ULL,
0x0000001906087220ULL, 0x040fe20000410000ULL, 0x0000001406147220ULL, 0x040fe20000410000ULL,
0x0000001206037220ULL, 0x000fe20000410000ULL, 0x000000010b067810ULL, 0x000fe20007ffe0ffULL,
0x0000001607097220ULL, 0x010fe20000410000ULL, 0x000000030b197819ULL, 0x040fe200000006ffULL,
0x000000080b127824ULL, 0x000fe200078e00ffULL, 0x0000002d072d7220ULL, 0x000fe20000410000ULL,
0x000000080b167824ULL, 0x000fe200078e00ffULL, 0xfffffff8190c7812ULL, 0x000fe200078ee206ULL,
0x000000080b067824ULL, 0x000fe200078e00ffULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000002807287220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x0000001807187220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000e07077220ULL, 0x000fe20000410000ULL, 0x000000080b1b7824ULL, 0x040fe200078e00ffULL,
0x000000020b0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0xfffffff812127812ULL, 0x000fc400078ee20fULL, 0xfffffff816167812ULL, 0x000fe400078ee211ULL,
0x000000050b0f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001012127824ULL, 0x100fe200078e0205ULL,
0x000000060b117810ULL, 0x040fe20007ffe0ffULL, 0x0000001016167824ULL, 0x000fe200078e0205ULL,
0xffffffff0b197810ULL, 0x000fe40007ffe0ffULL, 0xfffffff806067812ULL, 0x000fe400078ee20bULL,
0xfffffff81b0e7812ULL, 0x000fc400078ee20eULL, 0xfffffff830307812ULL, 0x000fe200078ee20fULL,
0x0000001006067824ULL, 0x000fe200078e0205ULL, 0xfffffff832327812ULL, 0x000fe400078ee211ULL,
0xfffffff834347812ULL, 0x000fe200078ee219ULL, 0x0000001030307824ULL, 0x100fe200078e0205ULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001032327824ULL, 0x100fe200078e0205ULL,
0x000000050e0e7211ULL, 0x000fe200078e20ffULL, 0x0000001034347824ULL, 0x000fe200078e0205ULL,
0x0000002f2e2e723eULL, 0x000fe200000000ffULL, 0x0000000106057824ULL, 0x000fe200078e020bULL,
0x0000002b2a2a723eULL, 0x000fe200000000ffULL, 0x000000010b0d7824ULL, 0x040fe200078e020cULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x000000010b0f7824ULL, 0x040fe200078e020eULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x000000010b117824ULL, 0x040fe200078e0212ULL,
0x000000130808723eULL, 0x000fe200000000ffULL, 0x000000010b137824ULL, 0x040fe200078e0216ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000002e05007388ULL, 0x0003e20000000800ULL,
0x000000170202723eULL, 0x000fe200000000ffULL, 0x000000010b327824ULL, 0x040fe200078e0232ULL,
0x000000300b307210ULL, 0x000fe20007ffe0ffULL, 0x0000002a0d007388ULL, 0x0003e20000000800ULL,
0x000000140303723eULL, 0x000fe200000000ffULL, 0x000000010b347824ULL, 0x040fe200078e0234ULL,
0x0000002d2c2c723eULL, 0x000fe200000000ffULL, 0x000000260f007388ULL, 0x0003e20000000800ULL,
0x000000010b0b7824ULL, 0x000fe200078e0236ULL, 0x000000292828723eULL, 0x000fc400000000ffULL,
0x0000002211007388ULL, 0x0003e20000000800ULL, 0x000000252424723eULL, 0x000fe400000000ffULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000001e13007388ULL, 0x0003e20000000800ULL,
0x0000001d1c1c723eULL, 0x000fe400000000ffULL, 0x0000001a1515723eULL, 0x000fe200000000ffULL,
0x0000000230007388ULL, 0x0003e20000000800ULL, 0x000000180909723eULL, 0x000fe400000000ffULL,
0x000000100707723eULL, 0x000fe200000000ffULL, 0x0000000832007388ULL, 0x0003e80000000800ULL,
0x0000000334007388ULL, 0x0003e80000000800ULL, 0x0000002c0b007388ULL, 0x0003e80000000800ULL,
0x000400280d007388ULL, 0x0003e80000000800ULL, 0x000400240f007388ULL, 0x0003e80000000800ULL,
0x0004002011007388ULL, 0x0003e80000000800ULL, 0x0004001c13007388ULL, 0x0003e80000000800ULL,
0x0004001530007388ULL, 0x0003e80000000800ULL, 0x0004000932007388ULL, 0x0003e80000000800ULL,
0x0004000734007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000087919ULL, 0x002e620000000000ULL, 0x0000580000007a24ULL, 0x000fc600078e02ffULL,
0x0000000000097919ULL, 0x000ea20000002600ULL, 0x00000003ff027819ULL, 0x002fca0000011608ULL,
0x0000000102037824ULL, 0x000fca00078e0208ULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe400078ef808ULL, 0x0000000708087812ULL, 0x000fc600078ec0ffULL,
0x0000001003047824ULL, 0x000fe200078e0204ULL, 0x1ffffff808737812ULL, 0x008fe200078ef873ULL,
0x0000580002037a24ULL, 0x004fc800078e0209ULL, 0x00a0000004047984ULL, 0x000e620000000c00ULL,
0x0000000300007211ULL, 0x000fc800078010ffULL, 0x000000ffff037210ULL, 0x000fe400007fe4ffULL,
0x00005a0000027a11ULL, 0x000fc800078048ffULL, 0x00005b0000037a11ULL, 0x000fca00000f4c03ULL,
0x0000001073027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000040797c7824ULL, 0x040fe200078e00ffULL,
0x0000002014077810ULL, 0x040fe20007ffe0ffULL, 0x00000100797a7824ULL, 0x000fe200078e00ffULL,
0x000000031400780cULL, 0x040fe20003f44070ULL, 0x000001007b0a7824ULL, 0x004fe400078e027cULL,
0x00000004140b7824ULL, 0x000fe400078e027aULL, 0x0000680077047a24ULL, 0x000fe400078e020aULL,
0x000000010a067824ULL, 0x000fc400078e0214ULL, 0x000000010a087824ULL, 0x100fe200078e0207ULL,
0x0000001404057210ULL, 0x040fe20007ffe0ffULL, 0x0000000104077824ULL, 0x000fe200078e0207ULL,
0x000000750600720cULL, 0x080fe40003f06070ULL, 0x000000750800720cULL, 0x000fe20003f26070ULL,
0x0000660005047625ULL, 0x000fc800078e0010ULL, 0x0000660007067625ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ad000ff087f8cULL, 0x000e62000c80043fULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000047b7d7824ULL, 0x000fe400078e0279ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x14600000040b7faeULL, 0x0005e8000c121846ULL,
0x14680000060b7faeULL, 0x0005e2000c921846ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x0000000400047824ULL, 0x004fe200078e0214ULL, 0x000000767d00720cULL, 0x000fc40003f06070ULL,
0x0000001479077211ULL, 0x000fe200078e10ffULL, 0x0000000204047824ULL, 0x000fc600078e00ffULL,
0x00014a8007077811ULL, 0x000fe200078e10ffULL, 0x0000640004047a24ULL, 0x000fc800078e027dULL,
0x0000600004047625ULL, 0x000fca00078e0010ULL, 0x0000000004077faeULL, 0x0005e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000017b057810ULL, 0x004fe20007ffe0ffULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000740500720cULL, 0x000fe20003f06070ULL,
0x000000ffff057224ULL, 0x002fe200078e0009ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000093000008947ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000e620000000000ULL, 0x00014a80790f7811ULL, 0x040fe200078e20ffULL,
0x00000200ff127424ULL, 0x000fe200078e00ffULL, 0x0000200079117811ULL, 0x000fe400078e68ffULL,
0x00000002ff177819ULL, 0x002fe4000001160bULL, 0x000000040b157819ULL, 0x040fe400000006ffULL,
0x0000000b0b087211ULL, 0x000fe200078fe8ffULL, 0x00000004170d7824ULL, 0x000fe200078e027aULL,
0x0000003015157812ULL, 0x000fe200078ec0ffULL, 0x00000040030e7824ULL, 0x000fe200078e0217ULL,
0x00000003080c7812ULL, 0x000fc400078ec0ffULL, 0x014600000d047984ULL, 0x000e640000000800ULL,
0x0000000404097824ULL, 0x002fe200078e020fULL, 0x0000000a75047217ULL, 0x000fca0007800000ULL,
0x0000000009097984ULL, 0x000e620000000800ULL, 0x0000000104047824ULL, 0x000fca00078e0a0aULL,
0x000000041700720cULL, 0x000fe20003f06070ULL, 0x0000000409067c24ULL, 0x002fc8000f8e020eULL,
0x00005e0006067625ULL, 0x000fca00078e0012ULL, 0x0000001506087210ULL, 0x000fe40007f3e0ffULL,
0x0ffffffc0c067812ULL, 0x000fe400078ef80bULL, 0x00000008170b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000080e077810ULL, 0x000fe20007ffe0ffULL,
0x0000001006137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x014620000d067984ULL, 0x000ea20000000800ULL,
0x0000001017097810ULL, 0x002fe20007ffe0ffULL, 0x0000000406107824ULL, 0x004fcc00078e020fULL,
0x0000000010107984ULL, 0x000e640000000800ULL, 0x0000000410077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x00000015060a7210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc0b067812ULL, 0x000fe400078ee20cULL, 0x00000007ff0b7210ULL, 0x000fe40000ffe4ffULL,
0x000000100e077810ULL, 0x000fe20007ffe0ffULL, 0x0000001006137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x000000040900720cULL, 0x040fe20003f06070ULL, 0x0000000409097824ULL, 0x000fe400078e00ffULL,
0x014640000d067984ULL, 0x000ea20000000800ULL, 0x00000018170b7810ULL, 0x002fe20007ffe0ffULL,
0x0000000406107824ULL, 0x004fcc00078e020fULL, 0x0000000010107984ULL, 0x000e640000000800ULL,
0x0000000410077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0012ULL,
0x0000001506087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000180e077810ULL, 0x000fe20007ffe0ffULL,
0x0000001006137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x014660000d067984ULL, 0x000ea20000000800ULL,
0x0000002017097810ULL, 0x002fe40007ffe0ffULL, 0x0000000f06107211ULL, 0x004fcc00078e10ffULL,
0x0000000010107984ULL, 0x000e640000000800ULL, 0x0000000410077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x00000015060a7210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20cULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x000000200e077810ULL, 0x000fe20007ffe0ffULL, 0x0000001006137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x000000040900720cULL, 0x040fe20003f06070ULL, 0x0000000409097824ULL, 0x000fe400078e00ffULL,
0x014680000d067984ULL, 0x000ea20000000800ULL, 0x00000028170b7810ULL, 0x002fe20007ffe0ffULL,
0x0000000406107824ULL, 0x004fcc00078e020fULL, 0x0000000010107984ULL, 0x000e640000000800ULL,
0x0000000410077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0012ULL,
0x0000001506087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09067812ULL, 0x000fe400078ee20cULL,
0x00000007ff097210ULL, 0x000fe40000ffe4ffULL, 0x000000280e077810ULL, 0x000fe20007ffe0ffULL,
0x0000001006137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x0146a0000d067984ULL, 0x000ea20000000800ULL,
0x0000003017097810ULL, 0x002fe20007ffe0ffULL, 0x0000000406107824ULL, 0x004fcc00078e020fULL,
0x0000000010107984ULL, 0x000e640000000800ULL, 0x0000000410077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x00000015060a7210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20cULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x000000300e077810ULL, 0x000fe20007ffe0ffULL, 0x0000001006137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x000000040900720cULL, 0x040fe20003f06070ULL, 0x0000000409097824ULL, 0x000fe400078e00ffULL,
0x0146c0000d067984ULL, 0x000ea40000000800ULL, 0x0000000f06107211ULL, 0x004fcc00078e10ffULL,
0x0000000010107984ULL, 0x000ea40000000800ULL, 0x0000000410077c24ULL, 0x004fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000001506087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc09067812ULL, 0x000fc600078ee20cULL, 0x000000ffff097224ULL, 0x000fe200008e0607ULL,
0x000000380e077810ULL, 0x000fe20007ffe0ffULL, 0x00000010060b7824ULL, 0x002fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000c101c46ULL,
0x0146e0000d067984ULL, 0x000ea40000000800ULL, 0x00000004060a7824ULL, 0x004fe200078e020fULL,
0x00000038170f7810ULL, 0x000fc80007ffe0ffULL, 0x000000040f00720cULL, 0x040fe20003f06070ULL,
0x000000000a0a7984ULL, 0x000ea20000000800ULL, 0x000000040f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffffc0f0c7812ULL, 0x000fca00078ee20cULL, 0x000000100c117824ULL, 0x000fe400078e0211ULL,
0x000000040a077c24ULL, 0x004fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0012ULL,
0x0000001506067210ULL, 0x000fc80007f3e0ffULL, 0x00000007ff077210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e2000c101c46ULL,
0x0000088000007947ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000e620000000000ULL,
0x00014a80790f7811ULL, 0x040fe200078e20ffULL, 0x00000200ff137424ULL, 0x000fe200078e00ffULL,
0x0000200079177811ULL, 0x000fe400078e68ffULL, 0x00000002ff0c7819ULL, 0x002fe40000011609ULL,
0x00000004090a7819ULL, 0x040fe400000006ffULL, 0x0000000909087211ULL, 0x000fe200078fe8ffULL,
0x000000040c0d7824ULL, 0x000fe200078e027aULL, 0x000000300a157812ULL, 0x000fe200078ec0ffULL,
0x0000004003117824ULL, 0x000fe200078e020cULL, 0x00000003080e7812ULL, 0x000fc400078ec0ffULL,
0x014600000d047984ULL, 0x000e620000000800ULL, 0x000000080c0a7810ULL, 0x000fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe400078e00ffULL, 0x0000000404047824ULL, 0x002fcc00078e020fULL,
0x0000000004047984ULL, 0x000e640000000800ULL, 0x0000000404067c24ULL, 0x002fe2000f8e0211ULL,
0x0ffffffc0e047812ULL, 0x000fc600078ef809ULL, 0x00005e0006067625ULL, 0x000fc800078e0013ULL,
0x0000001004197824ULL, 0x000fe200078e0217ULL, 0x0000001506087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000000811077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008197faeULL, 0x0003e8000b901c46ULL,
0x014620000d047984ULL, 0x000ea20000000800ULL, 0x000000100c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000408097824ULL, 0x000fe400078e00ffULL, 0x0000000404047824ULL, 0x004fcc00078e020fULL,
0x0000000004047984ULL, 0x000e640000000800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20eULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000001706197211ULL, 0x000fe400078e20ffULL, 0x0000001011077810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x014640000d047984ULL, 0x000ea20000000800ULL, 0x000000180c0a7810ULL, 0x002fc80007ffe0ffULL,
0x000000020a0b7819ULL, 0x000fe200000006ffULL, 0x0000000404047824ULL, 0x004fcc00078e020fULL,
0x0000000004047984ULL, 0x000e640000000800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x0000001506087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09067812ULL, 0x000fc600078ee20eULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000001811077810ULL, 0x000fe20007ffe0ffULL, 0x0000001006197824ULL, 0x000fca00078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008197faeULL, 0x0003e8000b901c46ULL,
0x014660000d047984ULL, 0x000ea20000000800ULL, 0x000000200c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000408097824ULL, 0x000fe400078e00ffULL, 0x0000000404047824ULL, 0x004fcc00078e020fULL,
0x0000000004047984ULL, 0x000e640000000800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20eULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000002011077810ULL, 0x000fe20007ffe0ffULL, 0x0000001006197824ULL, 0x000fca00078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x014680000d047984ULL, 0x000ea20000000800ULL, 0x000000280c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe400078e00ffULL, 0x0000000404047824ULL, 0x004fcc00078e020fULL,
0x0000000004047984ULL, 0x000e640000000800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x0000001506087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09067812ULL, 0x000fc600078ee20eULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000001706197211ULL, 0x000fe400078e20ffULL, 0x0000002811077810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008197faeULL, 0x0003e8000b901c46ULL,
0x0146a0000d047984ULL, 0x000ea20000000800ULL, 0x000000300c087810ULL, 0x042fe40007ffe0ffULL,
0x000000380c0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000208097819ULL, 0x000fe200000006ffULL,
0x0000000404047824ULL, 0x004fcc00078e020fULL, 0x0000000004047984ULL, 0x000e640000000800ULL,
0x0000000404067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x00000015060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20eULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000003011077810ULL, 0x040fe20007ffe0ffULL,
0x0000001006197824ULL, 0x000fe200078e0217ULL, 0x0000003811117810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x0146c0000d047984ULL, 0x000ea40000000800ULL, 0x0000000404047824ULL, 0x004fcc00078e020fULL,
0x0000000004047984ULL, 0x000ea40000000800ULL, 0x0000000404067c24ULL, 0x004fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x0000001506087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09067812ULL, 0x000fc600078ee20eULL, 0x000000ffff097224ULL, 0x000fe400000e0607ULL,
0x00000010060b7824ULL, 0x002fca00078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e8000b901c46ULL, 0x0146e0000d047984ULL, 0x000ea40000000800ULL,
0x0000000404047824ULL, 0x004fe400078e020fULL, 0x000000040c0f7824ULL, 0x000fc800078e00ffULL,
0x0000000004047984ULL, 0x000ea20000000800ULL, 0xfffffffc0f0e7812ULL, 0x000fc800078ee20eULL,
0x000000170e177211ULL, 0x000fe200078e20ffULL, 0x0000000404067c24ULL, 0x004fc8000f8e0211ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x0000001506067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006177faeULL, 0x0003e6000b901c46ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x014ad400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x014ad400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000747b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x00014b5879737811ULL, 0x040fe200078e18ffULL, 0x0000002079717824ULL, 0x000fe200078e00ffULL,
0xffffffff74787810ULL, 0x000fe40007ffe0ffULL, 0x0000000605057819ULL, 0x000fc400000006ffULL,
0x000001007b067824ULL, 0x004fe200078e027cULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000067500720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x00000004ff047424ULL, 0x000fe200078e00ffULL, 0x0000007b7200720cULL, 0x000fe20003f44070ULL,
0x000000ffff707224ULL, 0x000fc600078e00ffULL, 0x0000000104047807ULL, 0x000fc40005000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x0001b24000287802ULL, 0x000fc40000000f00ULL, 0x0000af5000007944ULL, 0x002fea0003c00000ULL,
0x00000002ff297819ULL, 0x000fe20000011670ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002970287207ULL, 0x000fe20001000000ULL, 0x000010f000007945ULL, 0x000fe80003800000ULL,
0x0000030028ab7a24ULL, 0x000fc800078e027bULL, 0x00000100abaa7824ULL, 0x040fe200078e027cULL,
0x00000001ab297810ULL, 0x000fc80007ffe0ffULL, 0x000000742900720cULL, 0x000fda0003f06070ULL,
0x000008a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x002fe20000011607ULL,
0x00000200ff377424ULL, 0x000fe200078e00ffULL, 0x00014a8079357811ULL, 0x000fe400078e20ffULL,
0x000000aa75297217ULL, 0x000fe20007800000ULL, 0x0000000431337824ULL, 0x000fe200078e027aULL,
0x00000007072b7211ULL, 0x000fe200078fe8ffULL, 0x0000004003347824ULL, 0x000fe200078e0231ULL,
0x00003000792e7811ULL, 0x000fe200078e68ffULL, 0x00000001292c7824ULL, 0x000fe200078e0aaaULL,
0x0146000033287984ULL, 0x000e620000000800ULL, 0x000000032b327812ULL, 0x000fc400078ec0ffULL,
0x00000008312b7810ULL, 0x040fe40007ffe0ffULL, 0x0000002c3100720cULL, 0x000fe40003f26070ULL,
0x0ffffffc322f7812ULL, 0x000fe400078ef807ULL, 0x000000022b397819ULL, 0x000fc600000006ffULL,
0x000000102f2f7824ULL, 0x000fe200078e022eULL, 0xfffffffc39397812ULL, 0x000fe400078ee232ULL,
0x00000035282a7211ULL, 0x002fe400078e10ffULL, 0x0000000307287812ULL, 0x000fc800078ec0ffULL,
0x000000002a2a7984ULL, 0x000e620000000800ULL, 0x00000004282d7812ULL, 0x000fe200078efcffULL,
0x0000002a05297224ULL, 0x002fc800078e0234ULL, 0x00005e0029287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2b00720cULL, 0x000fc60003f26070ULL,
0x01462000332a7984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x0000001031297810ULL, 0x000fca0007ffe0ffULL, 0x0000000429397824ULL, 0x000fca00078e00ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x000000042a307824ULL, 0x004fe200078e0235ULL,
0x00000008342a7810ULL, 0x000fca0007ffe0ffULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x00000030052a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL,
0x000000102d2a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2900720cULL, 0x000fc60003f26070ULL,
0x0146400033287984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x00000018312b7810ULL, 0x000fc80007ffe0ffULL, 0x000000022b397819ULL, 0x000fc800000006ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x0000000428307824ULL, 0x004fe200078e0235ULL,
0x0000001034287810ULL, 0x000fca0007ffe0ffULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2b00720cULL, 0x000fc60003f26070ULL,
0x01466000332a7984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x0000002031297810ULL, 0x000fca0007ffe0ffULL, 0x0000000429397824ULL, 0x000fca00078e00ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x000000042a307824ULL, 0x004fe200078e0235ULL,
0x00000018342a7810ULL, 0x000fca0007ffe0ffULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x00000030052a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL,
0x000000102d2a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2900720cULL, 0x000fc60003f26070ULL,
0x0146800033287984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x00000028312b7810ULL, 0x000fc80007ffe0ffULL, 0x000000022b397819ULL, 0x000fc800000006ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x0000000428307824ULL, 0x004fe200078e0235ULL,
0x0000002034287810ULL, 0x000fca0007ffe0ffULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2b00720cULL, 0x000fc60003f26070ULL,
0x0146a000332a7984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x0000003031297810ULL, 0x040fe40007ffe0ffULL, 0x0000003831317810ULL, 0x000fc60007ffe0ffULL,
0x0000000429397824ULL, 0x000fca00078e00ffULL, 0xfffffffc39397812ULL, 0x000fe200078ee232ULL,
0x000000042a307824ULL, 0x004fe200078e0235ULL, 0x00000028342a7810ULL, 0x000fca0007ffe0ffULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL, 0x000000102d2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e2000c901c46ULL,
0x0000002c2900720cULL, 0x000fc60003f26070ULL, 0x0146c00033287984ULL, 0x000ea20000000800ULL,
0x00000010392f7824ULL, 0x002fe400078e022eULL, 0x0000000428307824ULL, 0x004fe200078e0235ULL,
0x0000003034287810ULL, 0x000fca0007ffe0ffULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c3100720cULL, 0x000fc60003f26070ULL,
0x0146e000332a7984ULL, 0x000ea40000000800ULL, 0x000000042a307824ULL, 0x004fe200078e0235ULL,
0x00000038342a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000231357819ULL, 0x000fc600000006ffULL,
0x0000000030307984ULL, 0x000ea20000000800ULL, 0xfffffffc35317812ULL, 0x000fca00078ee232ULL,
0x0000001031297824ULL, 0x002fe400078e022eULL, 0x00000030052a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL, 0x000000102d2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a297faeULL, 0x0003e2000c901c46ULL,
0x000007f000007947ULL, 0x000fea0003800000ULL, 0x00000002ff2d7819ULL, 0x002fe20000011607ULL,
0x00000200ff337424ULL, 0x000fe200078e00ffULL, 0x00014a8079317811ULL, 0x000fe400078e20ffULL,
0x00000007072b7211ULL, 0x000fe200078fe8ffULL, 0x000000042d307824ULL, 0x000fe200078e027aULL,
0x0000000307297812ULL, 0x000fe200078ec0ffULL, 0x0000004003327824ULL, 0x000fe200078e022dULL,
0x000000032b2e7812ULL, 0x000fe400078ec0ffULL, 0x0146000030287984ULL, 0x000e620000000800ULL,
0x00000004292f7812ULL, 0x000fc400078efcffULL, 0x0000300079347811ULL, 0x000fe400078e68ffULL,
0x0ffffffc2e2b7812ULL, 0x000fc800078ef807ULL, 0x000000342b357211ULL, 0x000fe400078e20ffULL,
0x000000082d2b7810ULL, 0x000fca0007ffe0ffULL, 0x000000042b377824ULL, 0x000fca00078e00ffULL,
0xfffffffc37377812ULL, 0x000fca00078ee22eULL, 0x0000001037377824ULL, 0x000fe400078e0234ULL,
0x00000004282a7824ULL, 0x002fcc00078e0231ULL, 0x000000002a2a7984ULL, 0x000e640000000800ULL,
0x0000002a05287224ULL, 0x002fc800078e0232ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x01462000302a7984ULL, 0x000ea20000000800ULL,
0x000000102d297810ULL, 0x002fca0007ffe0ffULL, 0x0000000429357824ULL, 0x000fca00078e00ffULL,
0xfffffffc35357812ULL, 0x000fc800078ee22eULL, 0x0000003435357211ULL, 0x000fe200078e20ffULL,
0x000000042a2c7824ULL, 0x004fe200078e0231ULL, 0x00000008322a7810ULL, 0x000fca0007ffe0ffULL,
0x000000002c2c7984ULL, 0x000e640000000800ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e8000b901c46ULL,
0x0146400030287984ULL, 0x000ea20000000800ULL, 0x000000182d2b7810ULL, 0x002fca0007ffe0ffULL,
0x000000042b377824ULL, 0x000fca00078e00ffULL, 0xfffffffc37377812ULL, 0x000fca00078ee22eULL,
0x0000001037377824ULL, 0x000fe400078e0234ULL, 0x00000004282c7824ULL, 0x004fe200078e0231ULL,
0x0000001032287810ULL, 0x000fca0007ffe0ffULL, 0x000000002c2c7984ULL, 0x000e640000000800ULL,
0x0000002c05287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x01466000302a7984ULL, 0x000ea20000000800ULL,
0x000000202d297810ULL, 0x002fca0007ffe0ffULL, 0x0000000429357824ULL, 0x000fca00078e00ffULL,
0xfffffffc35357812ULL, 0x000fc800078ee22eULL, 0x0000003435357211ULL, 0x000fe200078e20ffULL,
0x000000042a2c7824ULL, 0x004fe200078e0231ULL, 0x00000018322a7810ULL, 0x000fca0007ffe0ffULL,
0x000000002c2c7984ULL, 0x000e640000000800ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e8000b901c46ULL,
0x0146800030287984ULL, 0x000ea20000000800ULL, 0x000000282d2b7810ULL, 0x002fca0007ffe0ffULL,
0x000000042b377824ULL, 0x000fca00078e00ffULL, 0xfffffffc37377812ULL, 0x000fca00078ee22eULL,
0x0000001037377824ULL, 0x000fe400078e0234ULL, 0x00000004282c7824ULL, 0x004fe200078e0231ULL,
0x0000002032287810ULL, 0x000fca0007ffe0ffULL, 0x000000002c2c7984ULL, 0x000e640000000800ULL,
0x0000002c05287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x0146a000302a7984ULL, 0x000ea20000000800ULL,
0x000000302d297810ULL, 0x042fe40007ffe0ffULL, 0x000000382d2d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000429357824ULL, 0x000fe400078e00ffULL, 0x000000042d2d7824ULL, 0x000fc600078e00ffULL,
0xfffffffc35357812ULL, 0x100fe400078ee22eULL, 0xfffffffc2d2d7812ULL, 0x000fe400078ee22eULL,
0x0000003435357211ULL, 0x000fc600078e20ffULL, 0x000000102d2d7824ULL, 0x000fe400078e0234ULL,
0x000000042a2c7824ULL, 0x004fe200078e0231ULL, 0x00000028322a7810ULL, 0x000fca0007ffe0ffULL,
0x000000002c2c7984ULL, 0x000e640000000800ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e8000b901c46ULL,
0x0146c00030287984ULL, 0x000ea40000000800ULL, 0x00000004282c7824ULL, 0x004fe200078e0231ULL,
0x0000003032287810ULL, 0x000fca0007ffe0ffULL, 0x000000002c2c7984ULL, 0x000ea40000000800ULL,
0x0000002c05287224ULL, 0x004fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0005e8000b901c46ULL, 0x0146e000302a7984ULL, 0x002e640000000800ULL,
0x000000042a2c7824ULL, 0x002fe200078e0231ULL, 0x00000038322a7810ULL, 0x000fca0007ffe0ffULL,
0x000000002c2c7984ULL, 0x000e640000000800ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x0001c3a000287802ULL, 0x004fc40000000f00ULL, 0x00009df000007944ULL, 0x002fea0003c00000ULL,
0x00000007072a7812ULL, 0x006fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000004ff297819ULL, 0x100fe20000011607ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000082a7e7812ULL, 0x000fe200078ef807ULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x000000017e807824ULL, 0x040fe400078e0229ULL, 0x000000207e2b7824ULL, 0x000fca00078e00ffULL,
0xffffffe02b287812ULL, 0x000fc800078ee280ULL, 0x0000000428287819ULL, 0x000fc400000006ffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x00000003ff5c7819ULL, 0x000fe20000011607ULL,
0x0000200079ae7824ULL, 0x000fe200078e00ffULL, 0x000000002848783bULL, 0x000fe20000000200ULL,
0x000000207e387824ULL, 0x000fe200078e00ffULL, 0xfffffff8292a7812ULL, 0x000fe400078ee22aULL,
0x000000015c297812ULL, 0x000fe400078ec0ffULL, 0x000000102a2c7810ULL, 0x040fe20007ffe0ffULL,
0x000000042a327824ULL, 0x040fe200078e00ffULL, 0x000000292a2b7211ULL, 0x000fc400078ff8ffULL,
0x000000302a307810ULL, 0x040fe40007ffe0ffULL, 0x000000202a2e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc329d7812ULL, 0x000fe200078ee22bULL, 0x000000042c327824ULL, 0x040fe200078e00ffULL,
0x000000292c2d7211ULL, 0x080fe200078ff8ffULL, 0x0000000430367824ULL, 0x000fe200078e00ffULL,
0x000000292e2f7211ULL, 0x080fe200078ff8ffULL, 0x000000042c2c7824ULL, 0x000fe200078e00ffULL,
0x000000022e347819ULL, 0x040fe200000006ffULL, 0x000000042e2e7824ULL, 0x000fe200078e00ffULL,
0x0000002930297211ULL, 0x040fe200078ff8ffULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0x00002000ae9e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffffc325d7812ULL, 0x000fe400078ee22dULL,
0xfffffffc34897812ULL, 0x000fe200078ee22fULL, 0x000000109dac7824ULL, 0x100fe200078e029eULL,
0xfffffffc36877812ULL, 0x000fe200078ee229ULL, 0x000000105da97824ULL, 0x100fe200078e029eULL,
0x0000000280317810ULL, 0x000fe20007ffe0ffULL, 0x0000001089a87824ULL, 0x100fe200078e029eULL,
0x00000000ac54783bULL, 0x000e620000000200ULL, 0x0000001087a77824ULL, 0x000fe200078e029eULL,
0x000000022a2a7819ULL, 0x000fc400000006ffULL, 0x00000000a950783bULL, 0x000ea20000000200ULL,
0x000000022bc37810ULL, 0x000fe40007ffe0ffULL, 0x000000022fbf7810ULL, 0x000fe20007ffe0ffULL,
0x00000000a84c783bULL, 0x000ee20000000200ULL, 0x000000022dc17810ULL, 0x000fe40007ffe0ffULL,
0x0000000229837810ULL, 0x000fe20007ffe0ffULL, 0x00000000a758783bULL, 0x000f220000000200ULL,
0xffffffe038317812ULL, 0x000fe400078ee231ULL, 0xfffffffc2ac37812ULL, 0x000fc400078ee2c3ULL,
0xfffffffc2ebf7812ULL, 0x000fe200078ee2bfULL, 0x0000001031317824ULL, 0x000fe200078e00ffULL,
0xfffffffc2cc17812ULL, 0x000fe200078ee2c1ULL, 0x00000010c3a67824ULL, 0x100fe200078e029eULL,
0xfffffffc30837812ULL, 0x000fe200078ee283ULL, 0x00000010bf887824ULL, 0x100fe200078e029eULL,
0x0000009ec18b7211ULL, 0x000fe200078e20ffULL, 0x000000003130783bULL, 0x000fe40000000200ULL,
0x0000001083857824ULL, 0x000fe400078e029eULL, 0x00000000a644783bULL, 0x000f280000000200ULL,
0x000000008b40783bULL, 0x000f280000000200ULL, 0x000000008838783bULL, 0x000f280000000200ULL,
0x000000008528783bULL, 0x000f220000000200ULL, 0x000000544860723cULL, 0x002f6200000018ffULL,
0x000080000000791aULL, 0x000fce0000000000ULL, 0x00000050482c723cULL, 0x044f7000000018ffULL,
0x0000004c4834723cULL, 0x048f7000000018ffULL, 0x000000564854723cULL, 0x040f7000000018ffULL,
0x000000524850723cULL, 0x040f7000000018ffULL, 0x0000004e484c723cULL, 0x040f7000000018ffULL,
0x00000058483c723cULL, 0x050f7000000018ffULL, 0x0000005a4848723cULL, 0x000f7000000018ffULL,
0x000000443060723cULL, 0x060b700000001860ULL, 0x00000040302c723cULL, 0x040b70000000182cULL,
0x000000383034723cULL, 0x040b700000001834ULL, 0x000000463044723cULL, 0x040b700000001854ULL,
0x000000423040723cULL, 0x040b700000001850ULL, 0x0000003a3038723cULL, 0x040b70000000184cULL,
0x00000028303c723cULL, 0x040b70000000183cULL, 0x0000002a3030723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000002000007947ULL, 0x000fde0003800000ULL,
0x0001c90000287802ULL, 0x020fce0000000f00ULL, 0x0000989000007944ULL, 0x000fea0003c00000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000108000007945ULL, 0x000fe20003800000ULL,
0x00000200ff997424ULL, 0x000fe200078e00ffULL, 0x0000088000008947ULL, 0x000fea0003800000ULL,
0x00000002ff817819ULL, 0x100fe20000011607ULL, 0x000000015c487824ULL, 0x020fe200078e0207ULL,
0x00014a80799b7811ULL, 0x000fe400078e20ffULL, 0x000000aa75297217ULL, 0x000fe20007800000ULL,
0x00000004819c7824ULL, 0x000fe200078e027aULL, 0x00000081039a7211ULL, 0x000fe400078e30ffULL,
0x0000000307ad7812ULL, 0x000fe200078ec0ffULL, 0x00000001294c7824ULL, 0x000fe200078e0aaaULL,
0x014600009c287984ULL, 0x000e620000000800ULL, 0x0000000348487812ULL, 0x000fc400078ec0ffULL,
0x00000008ad497812ULL, 0x000fe400078efcffULL, 0x0000004c8100720cULL, 0x040fe40003f26070ULL,
0x0ffffffc48b57812ULL, 0x000fe400078ef807ULL, 0x000000089a987810ULL, 0x040fe40007ffe0ffULL,
0x00000008817f7810ULL, 0x000fe20007ffe0ffULL, 0x00000010b5a57824ULL, 0x000fe200078e029eULL,
0x000000109a967810ULL, 0x000fc40007ffe0ffULL, 0x0000001081977810ULL, 0x000fe20007ffe0ffULL,
0x000000047fbd7824ULL, 0x000fe200078e00ffULL, 0x000000189a947810ULL, 0x040fe40007ffe0ffULL,
0x0000001881957810ULL, 0x000fe20007ffe0ffULL, 0x0000000497b37824ULL, 0x000fe200078e00ffULL,
0xfffffffcbdbd7812ULL, 0x000fe400078ee248ULL, 0x000000209a927810ULL, 0x000fe20007ffe0ffULL,
0x0000000495bb7824ULL, 0x000fe200078e00ffULL, 0x0000009ebda47211ULL, 0x000fc400078e20ffULL,
0xfffffffcb3b37812ULL, 0x100fe400078ee248ULL, 0xfffffffcbbbb7812ULL, 0x000fe400078ee248ULL,
0x0000002081937810ULL, 0x000fe20007ffe0ffULL, 0x00000010b3a37824ULL, 0x000fe200078e029eULL,
0x0000009ebba27211ULL, 0x000fe400078e20ffULL, 0x000000289a907810ULL, 0x000fe20007ffe0ffULL,
0x0000000493b17824ULL, 0x000fe200078e00ffULL, 0x0000002881917810ULL, 0x000fc40007ffe0ffULL,
0x000000309a8e7810ULL, 0x000fe20007ffe0ffULL, 0x00000004282a7824ULL, 0x002fe200078e029bULL,
0xfffffffcb1b17812ULL, 0x000fe200078ee248ULL, 0x0000000491b97824ULL, 0x000fe200078e00ffULL,
0x00000030818f7810ULL, 0x000fe40007ffe0ffULL, 0x000000389a8c7810ULL, 0x000fe20007ffe0ffULL,
0x000000002a2a7984ULL, 0x000e620000000800ULL, 0x00000010b1a17824ULL, 0x000fe200078e029eULL,
0xfffffffcb9b97812ULL, 0x000fe200078ee248ULL, 0x000000048faf7824ULL, 0x000fe200078e00ffULL,
0x00000038818d7810ULL, 0x000fc40007ffe0ffULL, 0x0000009eb9a07211ULL, 0x000fe400078e20ffULL,
0xfffffffcafaf7812ULL, 0x000fe200078ee248ULL, 0x000000048db77824ULL, 0x000fc800078e00ffULL,
0x00000010af9f7824ULL, 0x000fe200078e029eULL, 0xfffffffcb7b77812ULL, 0x000fc800078ee248ULL,
0x0000009eb79e7211ULL, 0x000fe200078e20ffULL, 0x0000002a05287224ULL, 0x002fc800078e029aULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a57faeULL, 0x0003e2000c901c46ULL,
0x0000004c7f00720cULL, 0x000fc60003f26070ULL, 0x014620009c2a7984ULL, 0x000ea40000000800ULL,
0x000000042a4a7824ULL, 0x004fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a052a7224ULL, 0x004fc800078e0298ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa47faeULL, 0x0005e2000c901c46ULL, 0x0000004c9700720cULL, 0x000fc60003f26070ULL,
0x014640009c287984ULL, 0x002e640000000800ULL, 0x00000004284a7824ULL, 0x002fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05287224ULL, 0x002fc800078e0296ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a37faeULL, 0x0003e2000c901c46ULL,
0x0000004c9500720cULL, 0x000fc60003f26070ULL, 0x014660009c2a7984ULL, 0x004ea40000000800ULL,
0x000000042a4a7824ULL, 0x004fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a052a7224ULL, 0x004fc800078e0294ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa27faeULL, 0x0005e2000c901c46ULL, 0x0000004c9300720cULL, 0x000fc60003f26070ULL,
0x014680009c287984ULL, 0x002e640000000800ULL, 0x00000004284a7824ULL, 0x002fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05287224ULL, 0x002fc800078e0292ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a17faeULL, 0x0003e2000c901c46ULL,
0x0000004c9100720cULL, 0x000fc60003f26070ULL, 0x0146a0009c2a7984ULL, 0x004ea40000000800ULL,
0x000000042a4a7824ULL, 0x004fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a052a7224ULL, 0x004fc800078e0290ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa07faeULL, 0x0005e2000c901c46ULL, 0x0000004c8f00720cULL, 0x000fc60003f26070ULL,
0x0146c0009c287984ULL, 0x002e640000000800ULL, 0x00000004284a7824ULL, 0x002fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05287224ULL, 0x002fc800078e028eULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x00000010492a7825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a9f7faeULL, 0x0003e2000c901c46ULL,
0x0000004c8d00720cULL, 0x000fc60003f26070ULL, 0x0146e0009c287984ULL, 0x000ea40000000800ULL,
0x00000004284a7824ULL, 0x004fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05287224ULL, 0x004fc800078e028cULL, 0x00005e0028287625ULL, 0x000fcc00078e0099ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000289e7faeULL, 0x0003e2000c901c46ULL, 0x000007d000007947ULL, 0x000fea0003800000ULL,
0x00000002ff817819ULL, 0x100fe20000011607ULL, 0x000000015c5c7824ULL, 0x000fe200078e0207ULL,
0x00014a80799b7811ULL, 0x000fe400078e20ffULL, 0x0000000307ad7812ULL, 0x000fe200078ec0ffULL,
0x00000004819c7824ULL, 0x000fe200078e027aULL, 0x000000035c5c7812ULL, 0x000fe200078ec0ffULL,
0x00000040039a7824ULL, 0x000fe200078e0281ULL, 0x00000008ad497812ULL, 0x020fe400078efcffULL,
0x014600009c287984ULL, 0x000e620000000800ULL, 0x0ffffffc5cb57812ULL, 0x000fc400078ef807ULL,
0x000000089a987810ULL, 0x040fe40007ffe0ffULL, 0x00000008817f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010b5a57824ULL, 0x000fe200078e029eULL, 0x000000109a967810ULL, 0x040fe40007ffe0ffULL,
0x0000001081977810ULL, 0x000fe20007ffe0ffULL, 0x000000047fbd7824ULL, 0x000fe200078e00ffULL,
0x000000189a947810ULL, 0x000fe40007ffe0ffULL, 0x0000001881957810ULL, 0x000fe20007ffe0ffULL,
0x0000000497b37824ULL, 0x000fe200078e00ffULL, 0xfffffffcbdbd7812ULL, 0x000fc400078ee25cULL,
0x000000209a927810ULL, 0x040fe20007ffe0ffULL, 0x0000000495bb7824ULL, 0x000fe200078e00ffULL,
0xfffffffcb3b37812ULL, 0x000fe200078ee25cULL, 0x00000010bda47824ULL, 0x000fe200078e029eULL,
0x0000002081937810ULL, 0x000fe40007ffe0ffULL, 0xfffffffcbbbb7812ULL, 0x000fe200078ee25cULL,
0x00000010b3a37824ULL, 0x100fe200078e029eULL, 0x000000289a907810ULL, 0x040fe20007ffe0ffULL,
0x0000000493b17824ULL, 0x000fe200078e00ffULL, 0x0000002881917810ULL, 0x000fe20007ffe0ffULL,
0x00000010bba27824ULL, 0x000fe200078e029eULL, 0x000000309a8e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffcb1b17812ULL, 0x000fe200078ee25cULL, 0x0000000491b97824ULL, 0x000fe200078e00ffULL,
0x00000030818f7810ULL, 0x000fe40007ffe0ffULL, 0x000000389a8c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010b1a17824ULL, 0x000fe200078e029eULL, 0xfffffffcb9b97812ULL, 0x000fe200078ee25cULL,
0x000000048faf7824ULL, 0x000fe200078e00ffULL, 0x00000038818d7810ULL, 0x000fe20007ffe0ffULL,
0x00000004282a7824ULL, 0x002fe400078e029bULL, 0x00000010b9a07824ULL, 0x000fe200078e029eULL,
0xfffffffcafaf7812ULL, 0x000fe200078ee25cULL, 0x000000048db77824ULL, 0x000fc400078e00ffULL,
0x000000002a2a7984ULL, 0x000e640000000800ULL, 0x00000010af9f7824ULL, 0x000fe200078e029eULL,
0xfffffffcb7b77812ULL, 0x000fca00078ee25cULL, 0x00000010b79e7824ULL, 0x000fe400078e029eULL,
0x0000002a05287224ULL, 0x002fc800078e029aULL, 0x00005e0028287625ULL, 0x000fcc00078e0099ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028a57faeULL, 0x0003e8000b901c46ULL, 0x014620009c2a7984ULL, 0x000ea40000000800ULL,
0x0000009b2a487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052a7224ULL, 0x004fc800078e0298ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa47faeULL, 0x0005e8000b901c46ULL, 0x014640009c287984ULL, 0x002e640000000800ULL,
0x0000000428487824ULL, 0x002fcc00078e029bULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805287224ULL, 0x002fc800078e0296ULL, 0x00005e0028287625ULL, 0x000fcc00078e0099ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028a37faeULL, 0x0003e8000b901c46ULL, 0x014660009c2a7984ULL, 0x004ea40000000800ULL,
0x0000009b2a487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052a7224ULL, 0x004fc800078e0294ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa27faeULL, 0x0005e8000b901c46ULL, 0x014680009c287984ULL, 0x002e640000000800ULL,
0x0000000428487824ULL, 0x002fcc00078e029bULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805287224ULL, 0x002fc800078e0292ULL, 0x00005e0028287625ULL, 0x000fcc00078e0099ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028a17faeULL, 0x0003e8000b901c46ULL, 0x0146a0009c2a7984ULL, 0x004ea40000000800ULL,
0x0000009b2a487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052a7224ULL, 0x004fc800078e0290ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa07faeULL, 0x0005e8000b901c46ULL, 0x0146c0009c287984ULL, 0x002e640000000800ULL,
0x0000000428487824ULL, 0x002fcc00078e029bULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805287224ULL, 0x002fc800078e028eULL, 0x00005e0028287625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x004fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a9f7faeULL, 0x0003e8000b901c46ULL, 0x0146e0009c287984ULL, 0x000ea40000000800ULL,
0x0000009b28487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805287224ULL, 0x004fc800078e028cULL, 0x00005e0028287625ULL, 0x000fcc00078e0099ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000289e7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000207e297824ULL, 0x002fe200078e00ffULL, 0x0000000480287810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00003000aeae7810ULL, 0x000fe20007ffe0ffULL,
0x000000207e2a7824ULL, 0x000fe200078e00ffULL, 0xffffffe029287812ULL, 0x000fe200078ee228ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ae5d8a7211ULL, 0x080fe200078e20ffULL,
0x000000109d9d7824ULL, 0x100fe200078e02aeULL, 0x0000000680297810ULL, 0x000fe20007ffe0ffULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x000000aec1847211ULL, 0x000fe200078e20ffULL,
0x0000001089897824ULL, 0x100fe200078e02aeULL, 0x000000009d6c783bULL, 0x000fe20000000200ULL,
0x0000001087877824ULL, 0x100fe200078e02aeULL, 0xffffffe02a297812ULL, 0x000fe200078ee229ULL,
0x00000010c3867824ULL, 0x100fe200078e02aeULL, 0x000000002858783bULL, 0x000e620000000200ULL,
0x00000010bf827824ULL, 0x100fe200078e02aeULL, 0x00000db000007945ULL, 0x000fe20003800000ULL,
0x0000001029487824ULL, 0x000fe200078e00ffULL, 0x000000008a68783bULL, 0x000ea20000000200ULL,
0x0000001083837824ULL, 0x000fc600078e02aeULL, 0x000000008964783bULL, 0x000ee80000000200ULL,
0x00000000875c783bULL, 0x000f280000000200ULL, 0x000000008654783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000f280000000200ULL, 0x000000008450783bULL, 0x000f280000000200ULL,
0x00000000824c783bULL, 0x000f280000000200ULL, 0x000000008328783bULL, 0x000f220000000200ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000006c5860723cULL, 0x042f700000001860ULL,
0x00000068582c723cULL, 0x044f70000000182cULL, 0x000000645834723cULL, 0x048f700000001834ULL,
0x0000006e5844723cULL, 0x040f700000001844ULL, 0x0000006a5840723cULL, 0x040f700000001840ULL,
0x000000665838723cULL, 0x040f700000001838ULL, 0x0000005c583c723cULL, 0x050f70000000183cULL,
0x0000005e5830723cULL, 0x000f700000001830ULL, 0x000000544860723cULL, 0x060b700000001860ULL,
0x00000050482c723cULL, 0x040b70000000182cULL, 0x0000004c4834723cULL, 0x040b700000001834ULL,
0x000000564854723cULL, 0x040b700000001844ULL, 0x000000524850723cULL, 0x040b700000001840ULL,
0x0000004e484c723cULL, 0x040b700000001838ULL, 0x00000028483c723cULL, 0x040b70000000183cULL,
0x0000002a4848723cULL, 0x000b620000001830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000064000008947ULL, 0x000fca0003800000ULL, 0x014600009c287984ULL, 0x020e620000000800ULL,
0x000000aa75297217ULL, 0x000fe20007800000ULL, 0x00000010b5b57824ULL, 0x100fe200078e02aeULL,
0x0000000cad317812ULL, 0x000fe200078efcffULL, 0x00000010bdb47824ULL, 0x000fe400078e02aeULL,
0x0000000129387824ULL, 0x000fe400078e0aaaULL, 0x00000010b3b37824ULL, 0x100fe400078e02aeULL,
0x00000010bbb27824ULL, 0x100fe200078e02aeULL, 0x000000388100720cULL, 0x000fe20003f26070ULL,
0x00000010b1b17824ULL, 0x000fc400078e02aeULL, 0x00000010b9b07824ULL, 0x100fe400078e02aeULL,
0x00000010afaf7824ULL, 0x100fe400078e02aeULL, 0x00000010b7ae7824ULL, 0x000fe400078e02aeULL,
0x0000000428287824ULL, 0x002fcc00078e029bULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052a7224ULL, 0x002fc800078e029aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab57faeULL, 0x0003e2000c901c46ULL, 0x000000387f00720cULL, 0x000fc60003f26070ULL,
0x014620009c307984ULL, 0x000ea40000000800ULL, 0x0000009b30307211ULL, 0x004fcc00078e10ffULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005287224ULL, 0x004fc800078e0298ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b47faeULL, 0x0005e2000c901c46ULL,
0x000000389700720cULL, 0x000fc60003f26070ULL, 0x014640009c327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e029bULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052a7224ULL, 0x002fc800078e0296ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab37faeULL, 0x0003e2000c901c46ULL, 0x000000389500720cULL, 0x000fc60003f26070ULL,
0x014660009c307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e029bULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005287224ULL, 0x004fc800078e0294ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b27faeULL, 0x0005e2000c901c46ULL,
0x000000389300720cULL, 0x000fc60003f26070ULL, 0x014680009c327984ULL, 0x000ee40000000800ULL,
0x0000009b32327211ULL, 0x008fcc00078e10ffULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052a7224ULL, 0x002fc800078e0292ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab17faeULL, 0x0003e2000c901c46ULL, 0x000000389100720cULL, 0x000fc60003f26070ULL,
0x0146a0009c307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e029bULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005287224ULL, 0x004fc800078e0290ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b07faeULL, 0x0005e2000c901c46ULL,
0x000000388f00720cULL, 0x000fc60003f26070ULL, 0x0146c0009c327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e029bULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052a7224ULL, 0x002fc800078e028eULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aaf7faeULL, 0x0003e2000c901c46ULL, 0x000000388d00720cULL, 0x000fc60003f26070ULL,
0x0146e0009c307984ULL, 0x000ee40000000800ULL, 0x0000009b30307211ULL, 0x008fcc00078e10ffULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005287224ULL, 0x004fc800078e028cULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ae7faeULL, 0x0003e2000c901c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x014600009c287984ULL, 0x020e620000000800ULL,
0x0000000cad397812ULL, 0x000fe200078efcffULL, 0x00000010b5b57824ULL, 0x100fe400078e02aeULL,
0x00000010bdb47824ULL, 0x100fe400078e02aeULL, 0x00000010b3b37824ULL, 0x100fe400078e02aeULL,
0x00000010bbb27824ULL, 0x100fe400078e02aeULL, 0x00000010b1b17824ULL, 0x000fc400078e02aeULL,
0x00000010b9b07824ULL, 0x100fe400078e02aeULL, 0x00000010afaf7824ULL, 0x100fe400078e02aeULL,
0x00000010b7ae7824ULL, 0x000fe400078e02aeULL, 0x0000000428287824ULL, 0x002fcc00078e029bULL,
0x0000000028287984ULL, 0x000e640000000800ULL, 0x00000028052a7224ULL, 0x002fc800078e029aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x00000010392a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab57faeULL, 0x0003e8000b901c46ULL,
0x014620009c307984ULL, 0x000ea40000000800ULL, 0x0000000430327824ULL, 0x004fcc00078e029bULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205307224ULL, 0x004fc800078e0298ULL,
0x00005e0030287625ULL, 0x000fcc00078e0099ULL, 0x0000001039307825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b47faeULL, 0x0005e8000b901c46ULL,
0x014640009c287984ULL, 0x000ee40000000800ULL, 0x0000009b28337211ULL, 0x008fcc00078e10ffULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305287224ULL, 0x008fc800078e0296ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab37faeULL, 0x0003e8000b901c46ULL,
0x014660009c287984ULL, 0x000ee40000000800ULL, 0x0000000428327824ULL, 0x008fcc00078e029bULL,
0x0000000032327984ULL, 0x000ee40000000800ULL, 0x0000003205287224ULL, 0x008fc800078e0294ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001039307825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b27faeULL, 0x0005e8000b901c46ULL,
0x014680009c287984ULL, 0x000ee40000000800ULL, 0x0000000428337824ULL, 0x008fcc00078e029bULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305287224ULL, 0x008fc800078e0292ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab17faeULL, 0x0003e8000b901c46ULL,
0x0146a0009c287984ULL, 0x000ee40000000800ULL, 0x0000009b28327211ULL, 0x008fcc00078e10ffULL,
0x0000000032327984ULL, 0x000ee40000000800ULL, 0x0000003205287224ULL, 0x008fc800078e0290ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001039307825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b07faeULL, 0x0005e8000b901c46ULL,
0x0146c0009c287984ULL, 0x000ee40000000800ULL, 0x0000000428337824ULL, 0x008fcc00078e029bULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305287224ULL, 0x008fc800078e028eULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aaf7faeULL, 0x0005e8000b901c46ULL,
0x0146e0009c287984ULL, 0x000e640000000800ULL, 0x0000000428327824ULL, 0x002fcc00078e029bULL,
0x0000000032327984ULL, 0x000e640000000800ULL, 0x0000003205287224ULL, 0x002fc800078e028cULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001039287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ae7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000880287810ULL, 0x006fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000057e297819ULL, 0x040fe200000006ffULL,
0x00000000ac6c783bULL, 0x000fe20000000200ULL, 0x000000207e2a7824ULL, 0x000fe200078e00ffULL,
0x00000d0000007945ULL, 0x000fe20003800000ULL, 0xffffffe029287812ULL, 0x000fe200078ee228ULL,
0x00000000a968783bULL, 0x000fe20000000200ULL, 0x0000000a80297810ULL, 0x000fc60007ffe0ffULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x00000000a864783bULL, 0x000fe20000000200ULL,
0xffffffe02a297812ULL, 0x000fc600078ee229ULL, 0x000000002858783bULL, 0x000e640000000200ULL,
0x0000001029307824ULL, 0x000fe400078e00ffULL, 0x00000000a75c783bULL, 0x000ea80000000200ULL,
0x00000000a644783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000ee80000000200ULL,
0x000000008b40783bULL, 0x000f280000000200ULL, 0x000000008838783bULL, 0x000ea80000000200ULL,
0x000000008528783bULL, 0x000ea80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000006c5860723cULL, 0x042f700000001860ULL, 0x00000068582c723cULL, 0x000f62000000182cULL,
0x000080000000791aULL, 0x000fce0000000000ULL, 0x000000645834723cULL, 0x040f700000001834ULL,
0x0000006e5854723cULL, 0x040f700000001854ULL, 0x0000006a5850723cULL, 0x040f700000001850ULL,
0x00000066584c723cULL, 0x040f70000000184cULL, 0x0000005c583c723cULL, 0x044f70000000183cULL,
0x0000005e5848723cULL, 0x000f700000001848ULL, 0x000000443060723cULL, 0x068b700000001860ULL,
0x00000040302c723cULL, 0x050b70000000182cULL, 0x000000383034723cULL, 0x040b700000001834ULL,
0x000000463044723cULL, 0x040b700000001854ULL, 0x000000423040723cULL, 0x040b700000001850ULL,
0x0000003a3038723cULL, 0x040b70000000184cULL, 0x00000028303c723cULL, 0x040b70000000183cULL,
0x0000002a3030723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000005c000008947ULL, 0x000fca0003800000ULL, 0x014600009c287984ULL, 0x020e620000000800ULL,
0x000000aa75297217ULL, 0x000fe40007800000ULL, 0x00000010ad497812ULL, 0x000fc600078efcffULL,
0x00000001294c7824ULL, 0x000fca00078e0aaaULL, 0x0000004c8100720cULL, 0x000fe20003f26070ULL,
0x0000000428287824ULL, 0x002fcc00078e029bULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052a7224ULL, 0x002fc800078e029aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa57faeULL, 0x0003e2000c901c46ULL, 0x0000004c7f00720cULL, 0x000fc60003f26070ULL,
0x014620009c487984ULL, 0x000ea40000000800ULL, 0x0000009b48487211ULL, 0x004fcc00078e10ffULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805287224ULL, 0x004fc800078e0298ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a47faeULL, 0x0005e2000c901c46ULL,
0x0000004c9700720cULL, 0x000fc60003f26070ULL, 0x014640009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052a7224ULL, 0x002fc800078e0296ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa37faeULL, 0x0003e2000c901c46ULL, 0x0000004c9500720cULL, 0x000fc60003f26070ULL,
0x014660009c487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e029bULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805287224ULL, 0x004fc800078e0294ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a27faeULL, 0x0005e2000c901c46ULL,
0x0000004c9300720cULL, 0x000fc60003f26070ULL, 0x014680009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052a7224ULL, 0x002fc800078e0292ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa17faeULL, 0x0003e2000c901c46ULL, 0x0000004c9100720cULL, 0x000fc60003f26070ULL,
0x0146a0009c487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e029bULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805287224ULL, 0x004fc800078e0290ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a07faeULL, 0x0005e2000c901c46ULL,
0x0000004c8f00720cULL, 0x000fc60003f26070ULL, 0x0146c0009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052a7224ULL, 0x002fc800078e028eULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a9f7faeULL, 0x0003e2000c901c46ULL, 0x0000004c8d00720cULL, 0x000fc60003f26070ULL,
0x0146e0009c487984ULL, 0x000ee40000000800ULL, 0x0000009b48487211ULL, 0x008fcc00078e10ffULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805287224ULL, 0x004fc800078e028cULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000289e7faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x014600009c287984ULL, 0x020e620000000800ULL,
0x00000010ad4b7812ULL, 0x000fe200078efcffULL, 0x0000000428487824ULL, 0x002fcc00078e029bULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052a7224ULL, 0x002fc800078e029aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa57faeULL, 0x0003e8000b901c46ULL,
0x014620009c287984ULL, 0x000ea40000000800ULL, 0x0000000428497824ULL, 0x004fcc00078e029bULL,
0x0000000049497984ULL, 0x000ea40000000800ULL, 0x0000004905287224ULL, 0x004fc800078e0298ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a47faeULL, 0x0005e8000b901c46ULL,
0x014640009c487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e029bULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052a7224ULL, 0x002fc800078e0296ULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa37faeULL, 0x0003e8000b901c46ULL,
0x014660009c4a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05287224ULL, 0x004fc800078e0294ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a27faeULL, 0x0005e8000b901c46ULL,
0x014680009c487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e029bULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052a7224ULL, 0x002fc800078e0292ULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa17faeULL, 0x0003e8000b901c46ULL,
0x0146a0009c4a7984ULL, 0x000ee40000000800ULL, 0x0000009b4a4a7211ULL, 0x008fcc00078e10ffULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05287224ULL, 0x004fc800078e0290ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a07faeULL, 0x0005e8000b901c46ULL,
0x0146c0009c487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e029bULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052a7224ULL, 0x002fc800078e028eULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a9f7faeULL, 0x0003e8000b901c46ULL,
0x0146e0009c4a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05287224ULL, 0x004fc800078e028cULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000289e7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000207e297824ULL, 0x002fe200078e00ffULL,
0x0000000c80287810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe029287812ULL, 0x000fe200078ee228ULL, 0x000000009d6c783bULL, 0x000fe20000000200ULL,
0x000000207e2a7824ULL, 0x000fe200078e00ffULL, 0x0000000e80297810ULL, 0x000fe20007ffe0ffULL,
0x00000ce000007945ULL, 0x000fe20003800000ULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x000000008a68783bULL, 0x000fe20000000200ULL, 0xffffffe02a297812ULL, 0x000fc600078ee229ULL,
0x000000002858783bULL, 0x000e620000000200ULL, 0x0000000429487819ULL, 0x000fc600000006ffULL,
0x000000008964783bULL, 0x000ea80000000200ULL, 0x00000000875c783bULL, 0x000ee80000000200ULL,
0x000000008654783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000f280000000200ULL,
0x000000008450783bULL, 0x000ee80000000200ULL, 0x00000000824c783bULL, 0x000ee80000000200ULL,
0x000000008328783bULL, 0x000ee80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000006c5860723cULL, 0x042f700000001860ULL, 0x00000068582c723cULL, 0x040f70000000182cULL,
0x000000645834723cULL, 0x004f620000001834ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x0000006e5844723cULL, 0x040f700000001844ULL, 0x0000006a5840723cULL, 0x040f700000001840ULL,
0x000000665838723cULL, 0x040f700000001838ULL, 0x0000005c583c723cULL, 0x048f70000000183cULL,
0x0000005e5830723cULL, 0x000f700000001830ULL, 0x000000544860723cULL, 0x070b700000001860ULL,
0x00000050482c723cULL, 0x040b70000000182cULL, 0x0000004c4834723cULL, 0x040b700000001834ULL,
0x000000564854723cULL, 0x040b700000001844ULL, 0x000000524850723cULL, 0x040b700000001840ULL,
0x0000004e484c723cULL, 0x040b700000001838ULL, 0x00000028483c723cULL, 0x040b70000000183cULL,
0x0000002a4848723cULL, 0x000b620000001830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000005c000008947ULL, 0x000fca0003800000ULL, 0x014600009c287984ULL, 0x020e620000000800ULL,
0x000000aa75297217ULL, 0x000fe40007800000ULL, 0x00000014ad317812ULL, 0x000fc600078efcffULL,
0x0000000129387824ULL, 0x000fca00078e0aaaULL, 0x000000388100720cULL, 0x000fe20003f26070ULL,
0x0000000428287824ULL, 0x002fcc00078e029bULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052a7224ULL, 0x002fc800078e029aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab57faeULL, 0x0003e2000c901c46ULL, 0x000000387f00720cULL, 0x000fc60003f26070ULL,
0x014620009c307984ULL, 0x000ea40000000800ULL, 0x0000000430307824ULL, 0x004fcc00078e029bULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005287224ULL, 0x004fc800078e0298ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b47faeULL, 0x0005e2000c901c46ULL,
0x000000389700720cULL, 0x000fc60003f26070ULL, 0x014640009c327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e029bULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052a7224ULL, 0x002fc800078e0296ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab37faeULL, 0x0003e2000c901c46ULL, 0x000000389500720cULL, 0x000fc60003f26070ULL,
0x014660009c307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e029bULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005287224ULL, 0x004fc800078e0294ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b27faeULL, 0x0005e2000c901c46ULL,
0x000000389300720cULL, 0x000fc60003f26070ULL, 0x014680009c327984ULL, 0x000ee40000000800ULL,
0x0000009b32327211ULL, 0x008fcc00078e10ffULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052a7224ULL, 0x002fc800078e0292ULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab17faeULL, 0x0003e2000c901c46ULL, 0x000000389100720cULL, 0x000fc60003f26070ULL,
0x0146a0009c307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e029bULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005287224ULL, 0x004fc800078e0290ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b07faeULL, 0x0005e2000c901c46ULL,
0x000000388f00720cULL, 0x000fc60003f26070ULL, 0x0146c0009c327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e029bULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052a7224ULL, 0x002fc800078e028eULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aaf7faeULL, 0x0003e2000c901c46ULL, 0x000000388d00720cULL, 0x000fc60003f26070ULL,
0x0146e0009c307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e029bULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005287224ULL, 0x004fc800078e028cULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ae7faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x014600009c287984ULL, 0x020e620000000800ULL,
0x00000014ad337812ULL, 0x000fe200078efcffULL, 0x0000000428307824ULL, 0x002fcc00078e029bULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052a7224ULL, 0x002fc800078e029aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab57faeULL, 0x0003e8000b901c46ULL,
0x014620009c287984ULL, 0x000ea40000000800ULL, 0x0000000428317824ULL, 0x004fcc00078e029bULL,
0x0000000031317984ULL, 0x000ea40000000800ULL, 0x0000003105287224ULL, 0x004fc800078e0298ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b47faeULL, 0x0005e8000b901c46ULL,
0x014640009c307984ULL, 0x000ee40000000800ULL, 0x0000009b30307211ULL, 0x008fcc00078e10ffULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052a7224ULL, 0x002fc800078e0296ULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab37faeULL, 0x0003e8000b901c46ULL,
0x014660009c327984ULL, 0x000ee40000000800ULL, 0x0000000432327824ULL, 0x008fcc00078e029bULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205287224ULL, 0x004fc800078e0294ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b27faeULL, 0x0005e8000b901c46ULL,
0x014680009c307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e029bULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052a7224ULL, 0x002fc800078e0292ULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab17faeULL, 0x0003e8000b901c46ULL,
0x0146a0009c327984ULL, 0x000ee40000000800ULL, 0x0000000432327824ULL, 0x008fcc00078e029bULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205287224ULL, 0x004fc800078e0290ULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b07faeULL, 0x0005e8000b901c46ULL,
0x0146c0009c307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e029bULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052a7224ULL, 0x002fc800078e028eULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0099ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aaf7faeULL, 0x0003e8000b901c46ULL,
0x0146e0009c327984ULL, 0x000ee40000000800ULL, 0x0000000432327824ULL, 0x008fcc00078e029bULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205287224ULL, 0x004fc800078e028cULL,
0x00005e0028287625ULL, 0x000fcc00078e0099ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ae7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001080287810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000057e297819ULL, 0x000fe200000006ffULL,
0x00000000ac6c783bULL, 0x000fe20000000200ULL, 0x00000d0000007945ULL, 0x000fe40003800000ULL,
0xffffffe029287812ULL, 0x000fe200078ee228ULL, 0x00000000a968783bULL, 0x000fe80000000200ULL,
0x0000001028587824ULL, 0x000fe200078e00ffULL, 0x00000000a864783bULL, 0x000fe20000000200ULL,
0x0000001280287810ULL, 0x000fc60007ffe0ffULL, 0x00000000a75c783bULL, 0x000fe20000000200ULL,
0xffffffe029287812ULL, 0x000fc600078ee228ULL, 0x000000005858783bULL, 0x000e640000000200ULL,
0x0000001028407824ULL, 0x000fe400078e00ffULL, 0x00000000a628783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000ea80000000200ULL, 0x000000008b30783bULL, 0x000ee80000000200ULL,
0x000000008838783bULL, 0x000f280000000200ULL, 0x000000008544783bULL, 0x000ea80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000006c5860723cULL, 0x042f700000001860ULL,
0x00000068582c723cULL, 0x000f62000000182cULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x000000645834723cULL, 0x040f700000001834ULL, 0x0000006e5854723cULL, 0x040f700000001854ULL,
0x0000006a5850723cULL, 0x040f700000001850ULL, 0x00000066584c723cULL, 0x040f70000000184cULL,
0x0000005c583c723cULL, 0x040f70000000183cULL, 0x0000005e5848723cULL, 0x000f700000001848ULL,
0x000000284060723cULL, 0x064b700000001860ULL, 0x00000030402c723cULL, 0x048b70000000182cULL,
0x000000384034723cULL, 0x050b700000001834ULL, 0x0000002a4028723cULL, 0x040b700000001854ULL,
0x000000324030723cULL, 0x040b700000001850ULL, 0x0000003a4038723cULL, 0x040b70000000184cULL,
0x00000044403c723cULL, 0x040b70000000183cULL, 0x000000464040723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000005c000008947ULL, 0x000fca0003800000ULL,
0x014600009c447984ULL, 0x020e620000000800ULL, 0x000000aa75457217ULL, 0x000fe40007800000ULL,
0x00000018ad497812ULL, 0x000fc600078efcffULL, 0x00000001454c7824ULL, 0x000fca00078e0aaaULL,
0x0000004c8100720cULL, 0x000fe20003f26070ULL, 0x0000000444447824ULL, 0x002fcc00078e029bULL,
0x0000000044447984ULL, 0x000e640000000800ULL, 0x0000004405467224ULL, 0x002fc800078e029aULL,
0x00005e0046467625ULL, 0x000fcc00078e0099ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a57faeULL, 0x0003e2000c901c46ULL,
0x0000004c7f00720cULL, 0x000fc60003f26070ULL, 0x014620009c487984ULL, 0x000ea40000000800ULL,
0x0000000448487824ULL, 0x004fcc00078e029bULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805447224ULL, 0x004fc800078e0298ULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a47faeULL, 0x0005e2000c901c46ULL, 0x0000004c9700720cULL, 0x000fc60003f26070ULL,
0x014640009c4a7984ULL, 0x000ee40000000800ULL, 0x0000009b4a4a7211ULL, 0x008fcc00078e10ffULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05467224ULL, 0x002fc800078e0296ULL,
0x00005e0046467625ULL, 0x000fcc00078e0099ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a37faeULL, 0x0003e2000c901c46ULL,
0x0000004c9500720cULL, 0x000fc60003f26070ULL, 0x014660009c487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e029bULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805447224ULL, 0x004fc800078e0294ULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a27faeULL, 0x0005e2000c901c46ULL, 0x0000004c9300720cULL, 0x000fc60003f26070ULL,
0x014680009c4a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05467224ULL, 0x002fc800078e0292ULL,
0x00005e0046467625ULL, 0x000fcc00078e0099ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a17faeULL, 0x0003e2000c901c46ULL,
0x0000004c9100720cULL, 0x000fc60003f26070ULL, 0x0146a0009c487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e029bULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805447224ULL, 0x004fc800078e0290ULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a07faeULL, 0x0005e2000c901c46ULL, 0x0000004c8f00720cULL, 0x000fc60003f26070ULL,
0x0146c0009c4a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05467224ULL, 0x002fc800078e028eULL,
0x00005e0046467625ULL, 0x000fcc00078e0099ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000469f7faeULL, 0x0003e2000c901c46ULL,
0x0000004c8d00720cULL, 0x000fc60003f26070ULL, 0x0146e0009c487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e029bULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805447224ULL, 0x004fc800078e028cULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449e7faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x014600009c447984ULL, 0x020e620000000800ULL, 0x00000018ad4b7812ULL, 0x000fe400078efcffULL,
0x0000009b44487211ULL, 0x002fcc00078e10ffULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805467224ULL, 0x002fc800078e029aULL, 0x00005e0046467625ULL, 0x000fcc00078e0099ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046a57faeULL, 0x0003e8000b901c46ULL, 0x014620009c447984ULL, 0x000ea40000000800ULL,
0x0000000444497824ULL, 0x004fcc00078e029bULL, 0x0000000049497984ULL, 0x000ea40000000800ULL,
0x0000004905447224ULL, 0x004fc800078e0298ULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a47faeULL, 0x0005e8000b901c46ULL, 0x014640009c487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e029bULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805467224ULL, 0x002fc800078e0296ULL, 0x00005e0046467625ULL, 0x000fcc00078e0099ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046a37faeULL, 0x0003e8000b901c46ULL, 0x014660009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05447224ULL, 0x004fc800078e0294ULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a27faeULL, 0x0005e8000b901c46ULL, 0x014680009c487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e029bULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805467224ULL, 0x002fc800078e0292ULL, 0x00005e0046467625ULL, 0x000fcc00078e0099ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046a17faeULL, 0x0003e8000b901c46ULL, 0x0146a0009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05447224ULL, 0x004fc800078e0290ULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a07faeULL, 0x0005e8000b901c46ULL, 0x0146c0009c487984ULL, 0x000ee40000000800ULL,
0x0000009b48487211ULL, 0x008fcc00078e10ffULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805467224ULL, 0x002fc800078e028eULL, 0x00005e0046467625ULL, 0x000fcc00078e0099ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000469f7faeULL, 0x0003e8000b901c46ULL, 0x0146e0009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05447224ULL, 0x004fc800078e028cULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449e7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000207e457824ULL, 0x002fe200078e00ffULL, 0x0000001480447810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe045447812ULL, 0x000fe200078ee244ULL,
0x000000008a4c783bULL, 0x000fe20000000200ULL, 0x000000207e597824ULL, 0x000fe200078e00ffULL,
0x0000001680587810ULL, 0x000fe20007ffe0ffULL, 0x00000d0000007945ULL, 0x000fe20003800000ULL,
0x0000001044487824ULL, 0x000fe200078e00ffULL, 0x000000008950783bULL, 0x000fe20000000200ULL,
0xffffffe059587812ULL, 0x000fc600078ee258ULL, 0x000000009d44783bULL, 0x000fe40000000200ULL,
0x00000010585c7824ULL, 0x000fe400078e00ffULL, 0x000000004848783bULL, 0x000e680000000200ULL,
0x000000008754783bULL, 0x000ea80000000200ULL, 0x000000008658783bULL, 0x000fe80000000200ULL,
0x000000005c5c783bULL, 0x000ee80000000200ULL, 0x00000000846c783bULL, 0x000f280000000200ULL,
0x000000008268783bULL, 0x000ea80000000200ULL, 0x000000008364783bULL, 0x000ea80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000444860723cULL, 0x042f700000001860ULL,
0x000000464828723cULL, 0x000b620000001828ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x0000004c482c723cULL, 0x000f64000000182cULL, 0x0000000370467812ULL, 0x020fc800078ec0ffULL,
0x000000ff46467207ULL, 0x000fe40005000000ULL, 0x0000004e4830723cULL, 0x040f700000001830ULL,
0x000000504834723cULL, 0x040f700000001834ULL, 0x000000524838723cULL, 0x040f700000001838ULL,
0x00000054483c723cULL, 0x044f70000000183cULL, 0x000000564840723cULL, 0x000f700000001840ULL,
0x000000585c60723cULL, 0x048b700000001860ULL, 0x0000005a5c28723cULL, 0x040b700000001828ULL,
0x0000006c5c2c723cULL, 0x050b70000000182cULL, 0x0000006e5c30723cULL, 0x060b700000001830ULL,
0x000000685c34723cULL, 0x040b700000001834ULL, 0x0000006a5c38723cULL, 0x040b700000001838ULL,
0x000000645c3c723cULL, 0x040b70000000183cULL, 0x000000665c40723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000005c000008947ULL, 0x000fca0003800000ULL,
0x014600009c447984ULL, 0x020e620000000800ULL, 0x000000aa75457217ULL, 0x000fe40007800000ULL,
0x0000001cadad7812ULL, 0x000fc600078efcffULL, 0x0000000145aa7824ULL, 0x000fca00078e0aaaULL,
0x000000aa8100720cULL, 0x000fe40003f06070ULL, 0x0000009b44477211ULL, 0x002fcc00078e10ffULL,
0x0000000047477984ULL, 0x000e640000000800ULL, 0x0000004705447224ULL, 0x002fc800078e029aULL,
0x00005e0044447625ULL, 0x000fcc00078e0099ULL, 0x00000010ad447825ULL, 0x000fca00078e0044ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044b57faeULL, 0x0003e2000c101c46ULL,
0x000000aa7f00720cULL, 0x000fc60003f06070ULL, 0x014620009c487984ULL, 0x000ea40000000800ULL,
0x00000004484a7824ULL, 0x004fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05487224ULL, 0x004fc800078e0298ULL, 0x00005e0048487625ULL, 0x000fcc00078e0099ULL,
0x00000010ad487825ULL, 0x000fca00078e0048ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048b47faeULL, 0x0005e2000c101c46ULL, 0x000000aa9700720cULL, 0x000fc60003f06070ULL,
0x014640009c4c7984ULL, 0x000ee40000000800ULL, 0x000000044c4c7824ULL, 0x008fcc00078e029bULL,
0x000000004c4c7984ULL, 0x000e640000000800ULL, 0x0000004c05447224ULL, 0x002fc800078e0296ULL,
0x00005e0044447625ULL, 0x000fcc00078e0099ULL, 0x00000010ad447825ULL, 0x000fca00078e0044ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044b37faeULL, 0x0003e2000c101c46ULL,
0x000000aa9500720cULL, 0x000fc60003f06070ULL, 0x014660009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05487224ULL, 0x004fc800078e0294ULL, 0x00005e0048487625ULL, 0x000fcc00078e0099ULL,
0x00000010ad487825ULL, 0x000fca00078e0048ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048b27faeULL, 0x0005e2000c101c46ULL, 0x000000aa9300720cULL, 0x000fc60003f06070ULL,
0x014680009c4c7984ULL, 0x000ee40000000800ULL, 0x000000044c4c7824ULL, 0x008fcc00078e029bULL,
0x000000004c4c7984ULL, 0x000e640000000800ULL, 0x0000004c05447224ULL, 0x002fc800078e0292ULL,
0x00005e0044447625ULL, 0x000fcc00078e0099ULL, 0x00000010ad447825ULL, 0x000fca00078e0044ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044b17faeULL, 0x0003e2000c101c46ULL,
0x000000aa9100720cULL, 0x000fc60003f06070ULL, 0x0146a0009c4a7984ULL, 0x000ee40000000800ULL,
0x0000009b4a4a7211ULL, 0x008fcc00078e10ffULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05487224ULL, 0x004fc800078e0290ULL, 0x00005e0048487625ULL, 0x000fcc00078e0099ULL,
0x00000010ad487825ULL, 0x000fca00078e0048ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048b07faeULL, 0x0005e2000c101c46ULL, 0x000000aa8f00720cULL, 0x000fc60003f06070ULL,
0x0146c0009c4c7984ULL, 0x000ee40000000800ULL, 0x000000044c4c7824ULL, 0x008fcc00078e029bULL,
0x000000004c4c7984ULL, 0x000e640000000800ULL, 0x0000004c05447224ULL, 0x002fc800078e028eULL,
0x00005e0044447625ULL, 0x000fcc00078e0099ULL, 0x00000010ad447825ULL, 0x000fca00078e0044ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044af7faeULL, 0x0003e2000c101c46ULL,
0x000000aa8d00720cULL, 0x000fc60003f06070ULL, 0x0146e0009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05487224ULL, 0x004fc800078e028cULL, 0x00005e0048487625ULL, 0x000fcc00078e0099ULL,
0x00000010ad487825ULL, 0x000fca00078e0048ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048ae7faeULL, 0x0003e2000c101c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x014600009c447984ULL, 0x020e620000000800ULL, 0x0000001cadad7812ULL, 0x000fe200078efcffULL,
0x0000000444477824ULL, 0x002fcc00078e029bULL, 0x0000000047477984ULL, 0x000e640000000800ULL,
0x0000004705447224ULL, 0x002fc800078e029aULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x00000010ad447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044b57faeULL, 0x0003e8000b901c46ULL, 0x014620009c487984ULL, 0x000ea40000000800ULL,
0x00000004484a7824ULL, 0x004fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05487224ULL, 0x004fc800078e0298ULL, 0x00005e0048487625ULL, 0x000fcc00078e0099ULL,
0x00000010ad487825ULL, 0x000fca00078e0048ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048b47faeULL, 0x0005e8000b901c46ULL, 0x014640009c4c7984ULL, 0x000ee40000000800ULL,
0x000000044c4c7824ULL, 0x008fcc00078e029bULL, 0x000000004c4c7984ULL, 0x000e640000000800ULL,
0x0000004c05447224ULL, 0x002fc800078e0296ULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x00000010ad447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044b37faeULL, 0x0003e8000b901c46ULL, 0x014660009c4a7984ULL, 0x000ee40000000800ULL,
0x0000009b4a4a7211ULL, 0x008fcc00078e10ffULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05487224ULL, 0x004fc800078e0294ULL, 0x00005e0048487625ULL, 0x000fcc00078e0099ULL,
0x00000010ad487825ULL, 0x000fca00078e0048ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048b27faeULL, 0x0005e8000b901c46ULL, 0x014680009c4c7984ULL, 0x000ee40000000800ULL,
0x000000044c4c7824ULL, 0x008fcc00078e029bULL, 0x000000004c4c7984ULL, 0x000e640000000800ULL,
0x0000004c05447224ULL, 0x002fc800078e0292ULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x00000010ad447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044b17faeULL, 0x0003e8000b901c46ULL, 0x0146a0009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05487224ULL, 0x004fc800078e0290ULL, 0x00005e0048487625ULL, 0x000fcc00078e0099ULL,
0x00000010ad487825ULL, 0x000fca00078e0048ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048b07faeULL, 0x0005e8000b901c46ULL, 0x0146c0009c4c7984ULL, 0x000ee40000000800ULL,
0x000000044c4c7824ULL, 0x008fcc00078e029bULL, 0x000000004c4c7984ULL, 0x000e640000000800ULL,
0x0000004c05447224ULL, 0x002fc800078e028eULL, 0x00005e0044447625ULL, 0x000fcc00078e0099ULL,
0x00000010ad447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044af7faeULL, 0x0003e8000b901c46ULL, 0x0146e0009c4a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e029bULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05487224ULL, 0x004fc800078e028cULL, 0x00005e0048487625ULL, 0x000fcc00078e0099ULL,
0x00000010ad487825ULL, 0x000fca00078e0048ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048ae7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000146447810ULL, 0x002fe20007ffe0ffULL, 0x00000004ff537424ULL, 0x000fe200078e00ffULL,
0x000000ab7200720cULL, 0x000fe20003f04070ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000002ff457819ULL, 0x000fe20000011644ULL, 0x0000029000007945ULL, 0x000fe20003800000ULL,
0x0000000344447812ULL, 0x000fe400078ec0ffULL, 0x0000000145487807ULL, 0x000fe40004000000ULL,
0x000000ff44447207ULL, 0x000fe40004000000ULL, 0x000000ab7200720cULL, 0x000fe20003f24070ULL,
0x0000030048457a24ULL, 0x000fe200078e02abULL, 0x000000034600780cULL, 0x000fe20003f85270ULL,
0x0000000407ab7824ULL, 0x040fe200078e00ffULL, 0x0000002007497810ULL, 0x000fe20007ffe0ffULL,
0x0000010045487824ULL, 0x000fe200078e027cULL, 0x0000001880477810ULL, 0x000fe20007ffe0ffULL,
0x0000000177457824ULL, 0x000fe200078e0244ULL, 0x000000057e4a7819ULL, 0x000fe200000006ffULL,
0x0000000148467824ULL, 0x000fc400078e0207ULL, 0x0000680045447a24ULL, 0x100fe200078e0248ULL,
0xffffffe04a477812ULL, 0x000fe200078ee247ULL, 0x0000000149487824ULL, 0x040fe200078e0248ULL,
0x000000754600720cULL, 0x000fe20003f06070ULL, 0x0000000149527824ULL, 0x000fe200078e0244ULL,
0x0000000744507210ULL, 0x000fe20007ffe0ffULL, 0x000000017a557824ULL, 0x000fe200078e02abULL,
0x000000754800720cULL, 0x000fe20003f66070ULL, 0x0000001047477824ULL, 0x000fe400078e00ffULL,
0x0000660050507625ULL, 0x000fc800078e0053ULL, 0x0000660052527625ULL, 0x000fe200078e0053ULL,
0x000000f000009947ULL, 0x000fea0002000000ULL, 0x000000030700780cULL, 0x000fe20003f24070ULL,
0x00000004ff447424ULL, 0x000fc800078e00ffULL, 0x00000300447d7a24ULL, 0x000fd000078e027dULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400457824ULL, 0x100fe200078e0207ULL,
0x000000767d00720cULL, 0x000fe20003f26070ULL, 0x0000000479487824ULL, 0x000fc600078e0207ULL,
0x0000000145467819ULL, 0x000fe400000006ffULL, 0x00014a8048497811ULL, 0x000fc600078e10ffULL,
0x0000640046457a24ULL, 0x000fc800078e027dULL, 0x0000600045447625ULL, 0x000fca00078e0044ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044497faeULL, 0x0003e4000c921846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1460000050557faeULL, 0x0005e2000c121846ULL, 0x000000207e577824ULL, 0x000fe200078e00ffULL,
0x0000001a80547810ULL, 0x000fe20007ffe0ffULL, 0x00000e8000007945ULL, 0x000fe20003800000ULL,
0x1468000052557faeULL, 0x0007e4000d921846ULL, 0xffffffe057547812ULL, 0x000fe400078ee254ULL,
0x00000000ac4c783bULL, 0x000fe80000000200ULL, 0x000000004744783bULL, 0x002e620000000200ULL,
0x0000001054507824ULL, 0x004fc600078e00ffULL, 0x00000000a95c783bULL, 0x000ea80000000200ULL,
0x00000000a848783bULL, 0x000f280000000200ULL, 0x00000000a658783bULL, 0x000fe80000000200ULL,
0x000000005050783bULL, 0x008ee80000000200ULL, 0x000000008b54783bULL, 0x000fe80000000200ULL,
0x000000008564783bULL, 0x000fe80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000004c4460723cULL, 0x042f700000001860ULL, 0x0000004e4428723cULL, 0x040b640000001828ULL,
0x00000000a74c783bULL, 0x020e6c0000000200ULL, 0x0000005c442c723cULL, 0x044f70000000182cULL,
0x0000005e4430723cULL, 0x000b640000001830ULL, 0x00000000885c783bULL, 0x0204620000000200ULL,
0x000080000000791aULL, 0x000fca0000000000ULL, 0x000000484434723cULL, 0x010f620000001834ULL,
0x0000000170887810ULL, 0x004fce0007ffe0ffULL, 0x0000004a4438723cULL, 0x000f700000001838ULL,
0x000000585060723cULL, 0x008ff00000001860ULL, 0x0000004c443c723cULL, 0x042f70000000183cULL,
0x0000004e4440723cULL, 0x000b6e0000001840ULL, 0x00000002ff457819ULL, 0x020fe20000011688ULL,
0x0000005a5028723cULL, 0x000b660000001828ULL, 0x0000004588447207ULL, 0x000fca0001000000ULL,
0x0000030044477a24ULL, 0x000fe200078e027bULL, 0x00000054502c723cULL, 0x000b68000000182cULL,
0x0000000147457810ULL, 0x000fc80007ffe0ffULL, 0x000000744500720cULL, 0x000fe20003f06070ULL,
0x000000565030723cULL, 0x040b700000001830ULL, 0x0000005c5034723cULL, 0x040b700000001834ULL,
0x0000005e5038723cULL, 0x040b700000001838ULL, 0x00000064503c723cULL, 0x040b70000000183cULL,
0x000000665040723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000066000008947ULL, 0x000fca0003800000ULL, 0x014600009c447984ULL, 0x020e620000000800ULL,
0x0000000407467819ULL, 0x000fc800000006ffULL, 0x00000030464d7812ULL, 0x000fe200078ec0ffULL,
0x0000000444487824ULL, 0x002fe400078e029bULL, 0x0000010047447824ULL, 0x000fc800078e027cULL,
0x0000000048487984ULL, 0x000e620000000800ULL, 0x0000004475457217ULL, 0x000fca0007800000ULL,
0x00000001454a7824ULL, 0x000fca00078e0a44ULL, 0x0000004a8100720cULL, 0x000fe20003f06070ULL,
0x00000048059a7224ULL, 0x002fc800078e029aULL, 0x00005e009a447625ULL, 0x000fca00078e0099ULL,
0x0000004d44467210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff477224ULL, 0x000fca00008e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a57faeULL, 0x0003e2000c101c46ULL,
0x0000004a7f00720cULL, 0x000fc60003f06070ULL, 0x014620009c447984ULL, 0x000ea40000000800ULL,
0x00000004444b7824ULL, 0x004fcc00078e029bULL, 0x000000004b4b7984ULL, 0x000ea40000000800ULL,
0x0000004b05447224ULL, 0x004fc800078e0298ULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44487210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff497224ULL, 0x000fca00008e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048a47faeULL, 0x0005e2000c101c46ULL,
0x0000004a9700720cULL, 0x000fc60003f06070ULL, 0x014640009c447984ULL, 0x000ee40000000800ULL,
0x00000004444c7824ULL, 0x008fcc00078e029bULL, 0x000000004c4c7984ULL, 0x000ee40000000800ULL,
0x0000004c05447224ULL, 0x008fc800078e0296ULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44467210ULL, 0x002fc80007f3e0ffULL, 0x00000045ff477210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a37faeULL, 0x0003e2000c101c46ULL,
0x0000004a9500720cULL, 0x000fc60003f06070ULL, 0x014660009c447984ULL, 0x000ee40000000800ULL,
0x00000004444b7824ULL, 0x008fcc00078e029bULL, 0x000000004b4b7984ULL, 0x000ee40000000800ULL,
0x0000004b05447224ULL, 0x008fc800078e0294ULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44487210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff497224ULL, 0x000fca00008e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048a27faeULL, 0x0005e2000c101c46ULL,
0x0000004a9300720cULL, 0x000fc60003f06070ULL, 0x014680009c447984ULL, 0x000ee40000000800ULL,
0x00000004444c7824ULL, 0x008fcc00078e029bULL, 0x000000004c4c7984ULL, 0x000ee40000000800ULL,
0x0000004c05447224ULL, 0x008fc800078e0292ULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44467210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff477224ULL, 0x000fca00008e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a17faeULL, 0x0003e2000c101c46ULL,
0x0000004a9100720cULL, 0x000fc60003f06070ULL, 0x0146a0009c447984ULL, 0x000ee40000000800ULL,
0x00000004444b7824ULL, 0x008fcc00078e029bULL, 0x000000004b4b7984ULL, 0x000ee40000000800ULL,
0x0000004b05447224ULL, 0x008fc800078e0290ULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44487210ULL, 0x004fc80007f3e0ffULL, 0x00000045ff497210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048a07faeULL, 0x0005e2000c101c46ULL,
0x0000004a8f00720cULL, 0x000fc60003f06070ULL, 0x0146c0009c447984ULL, 0x000ee40000000800ULL,
0x00000004444c7824ULL, 0x008fcc00078e029bULL, 0x000000004c4c7984ULL, 0x000ee40000000800ULL,
0x0000004c05447224ULL, 0x008fc800078e028eULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44467210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff477224ULL, 0x000fca00008e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000469f7faeULL, 0x0005e2000c101c46ULL,
0x0000004a8d00720cULL, 0x000fc60003f06070ULL, 0x0146e0009c447984ULL, 0x000e640000000800ULL,
0x00000004449b7824ULL, 0x002fcc00078e029bULL, 0x000000009b9b7984ULL, 0x000e640000000800ULL,
0x0000009b05447224ULL, 0x002fc800078e028cULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44447210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff457224ULL, 0x000fca00008e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000449e7faeULL, 0x0005e2000c101c46ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x014600009c447984ULL, 0x020e620000000800ULL,
0x0000000407467819ULL, 0x000fc800000006ffULL, 0x00000030464d7812ULL, 0x000fe200078ec0ffULL,
0x0000000444487824ULL, 0x002fcc00078e029bULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805447224ULL, 0x002fc800078e029aULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44467210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fca00000e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a57faeULL, 0x0003e8000b901c46ULL,
0x014620009c447984ULL, 0x000ea40000000800ULL, 0x00000004444a7824ULL, 0x004fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05447224ULL, 0x004fc800078e0298ULL,
0x00005e0044447625ULL, 0x000fca00078e0099ULL, 0x0000004d44487210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff497224ULL, 0x000fca00000e0645ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048a47faeULL, 0x0005e8000b901c46ULL, 0x014640009c447984ULL, 0x000ee40000000800ULL,
0x00000004444b7824ULL, 0x008fcc00078e029bULL, 0x000000004b4b7984ULL, 0x000ee40000000800ULL,
0x0000004b05447224ULL, 0x008fc800078e0296ULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44467210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fca00000e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a37faeULL, 0x0003e8000b901c46ULL,
0x014660009c447984ULL, 0x000ee40000000800ULL, 0x0000009b444a7211ULL, 0x008fcc00078e10ffULL,
0x000000004a4a7984ULL, 0x000ee40000000800ULL, 0x0000004a05447224ULL, 0x008fc800078e0294ULL,
0x00005e0044447625ULL, 0x000fca00078e0099ULL, 0x0000004d44487210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff497224ULL, 0x000fca00000e0645ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048a27faeULL, 0x0005e8000b901c46ULL, 0x014680009c447984ULL, 0x000ee40000000800ULL,
0x00000004444b7824ULL, 0x008fcc00078e029bULL, 0x000000004b4b7984ULL, 0x000ee40000000800ULL,
0x0000004b05447224ULL, 0x008fc800078e0292ULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44467210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fca00000e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046a17faeULL, 0x0003e8000b901c46ULL,
0x0146a0009c447984ULL, 0x000ee40000000800ULL, 0x00000004444a7824ULL, 0x008fcc00078e029bULL,
0x000000004a4a7984ULL, 0x000ee40000000800ULL, 0x0000004a05447224ULL, 0x008fc800078e0290ULL,
0x00005e0044447625ULL, 0x000fca00078e0099ULL, 0x0000004d44487210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff497224ULL, 0x000fca00000e0645ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048a07faeULL, 0x0005e8000b901c46ULL, 0x0146c0009c447984ULL, 0x000ee40000000800ULL,
0x0000009b444b7211ULL, 0x008fcc00078e10ffULL, 0x000000004b4b7984ULL, 0x000ee40000000800ULL,
0x0000004b05447224ULL, 0x008fc800078e028eULL, 0x00005e0044447625ULL, 0x000fca00078e0099ULL,
0x0000004d44467210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fca00000e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000469f7faeULL, 0x0005e8000b901c46ULL,
0x0146e0009c447984ULL, 0x000e640000000800ULL, 0x00000004449b7824ULL, 0x002fcc00078e029bULL,
0x000000009b9b7984ULL, 0x000e640000000800ULL, 0x0000009b05447224ULL, 0x002fc800078e028cULL,
0x00005e0044447625ULL, 0x000fca00078e0099ULL, 0x0000004d44447210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff457224ULL, 0x000fca00000e0645ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449e7faeULL, 0x0005e6000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000207e457824ULL, 0x004fe200078e00ffULL, 0x0000001c80447810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe045447812ULL, 0x000fe200078ee244ULL,
0x000000009d5c783bULL, 0x000fe20000000200ULL, 0x0000001e80807810ULL, 0x000fe40007ffe0ffULL,
0x000000708100720cULL, 0x000fe20003f06070ULL, 0x0000001044587824ULL, 0x000fe200078e00ffULL,
0x000000008a6c783bULL, 0x000fe20000000200ULL, 0xffffffe045807812ULL, 0x000fe400078ee280ULL,
0x000000888100720cULL, 0x000fe20004706470ULL, 0x000000008968783bULL, 0x000fe20000000200ULL,
0x0000000480447819ULL, 0x000fc400000006ffULL, 0x0000007b7200720cULL, 0x000fe20000703070ULL,
0x000000005858783bULL, 0x000e620000000200ULL, 0x000000707f00720cULL, 0x040fe20003f26070ULL,
0x000000ffff707224ULL, 0x000fe400078e0088ULL, 0x000000008764783bULL, 0x000ea20000000200ULL,
0x000000887f00720cULL, 0x000fc60000f21070ULL, 0x000000008648783bULL, 0x000fe20000000200ULL,
0x0000007b7200720cULL, 0x000fc60000f24470ULL, 0x000000004444783bULL, 0x000ee80000000200ULL,
0x000000008454783bULL, 0x000f280000000200ULL, 0x000000008250783bULL, 0x000ea80000000200ULL,
0x00000000834c783bULL, 0x000ea80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000005e5828723cULL, 0x042f700000001828ULL, 0x0000006c582c723cULL, 0x040f70000000182cULL,
0x000000685834723cULL, 0x040f700000001834ULL, 0x0000006a5838723cULL, 0x040f700000001838ULL,
0x00000064583c723cULL, 0x044ff0000000183cULL, 0x000000665840723cULL, 0x040ff00000001840ULL,
0x0000006e5830723cULL, 0x040ff00000001830ULL, 0x0000005c5860723cULL, 0x000ff00000001860ULL,
0x0000004a4428723cULL, 0x068f700000001828ULL, 0x00000054442c723cULL, 0x050f70000000182cULL,
0x000000504434723cULL, 0x040f700000001834ULL, 0x000000524438723cULL, 0x000f640000001838ULL,
0x000000ffff128224ULL, 0x020fe200078e0029ULL, 0x000000222b227208ULL, 0x000fe20000800000ULL,
0x000000ffff138224ULL, 0x000fe200078e0028ULL, 0x000000232a237208ULL, 0x000fc60000800000ULL,
0x0000004c443c723cULL, 0x040f62000000183cULL, 0x000000ffff108224ULL, 0x000fe200078e002dULL,
0x0000002c00118202ULL, 0x000fe40000000f00ULL, 0x000000202f207208ULL, 0x000fe40000800000ULL,
0x000000212e217208ULL, 0x000fe40000800000ULL, 0x0000004e4440723cULL, 0x000f620000001840ULL,
0x000000ffff0c8224ULL, 0x000fe200078e0035ULL, 0x0000001c371c7208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e0034ULL, 0x0000001d361d7208ULL, 0x000fc80000800000ULL,
0x000000564430723cULL, 0x040f620000001830ULL, 0x000000ffff0a8224ULL, 0x000fe200078e0039ULL,
0x00000038000b8202ULL, 0x000fe40000000f00ULL, 0x0000001a3b1a7208ULL, 0x000fe40000800000ULL,
0x0000001b3a1b7208ULL, 0x000fe40000800000ULL, 0x000000484460723cULL, 0x000f640000001860ULL,
0x000000ffff088224ULL, 0x020fe200078e003dULL, 0x000000183f187208ULL, 0x000fe20000800000ULL,
0x000000ffff098224ULL, 0x000fe200078e003cULL, 0x000000193e197208ULL, 0x000fc60000800000ULL,
0x000000ffff278224ULL, 0x000fe200078e0041ULL, 0x0000001643167208ULL, 0x000fe20000800000ULL,
0x000000ffff268224ULL, 0x000fe200078e0040ULL, 0x0000001742177208ULL, 0x000fca0000800000ULL,
0x000000ffff0e8224ULL, 0x000fe200078e0031ULL, 0x0000001e331e7208ULL, 0x000fe20000800000ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0030ULL, 0x0000001f321f7208ULL, 0x000fca0000800000ULL,
0x000000ffff148224ULL, 0x000fe200078e0061ULL, 0x0000002463247208ULL, 0x000fe20000800000ULL,
0x000000ffff158224ULL, 0x000fe200078e0060ULL, 0x000000048800720cULL, 0x000fe40003f06070ULL,
0x0000002562257208ULL, 0x000fd60000800000ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff7d3000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000073287f8cULL, 0x000e62000c80043fULL, 0x3d8000000d2a7820ULL, 0x000fe20000410000ULL,
0x3d800000082f7820ULL, 0x000fe20000410000ULL, 0x3d80000015157820ULL, 0x000fe20000410000ULL,
0x3d80000014147820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fe20000410000ULL,
0x3d80000012127820ULL, 0x000fe20000410000ULL, 0x3d80000011117820ULL, 0x000fe20000410000ULL,
0x3d80000010047820ULL, 0x000fe20000410000ULL, 0x3d8000000c2b7820ULL, 0x000fe20000410000ULL,
0x3d800000092e7820ULL, 0x000fe20000410000ULL, 0x3d80000027087820ULL, 0x000fe20000410000ULL,
0x3d80000025257820ULL, 0x000fe20000410000ULL, 0x3d8000001f1f7820ULL, 0x000fe20000410000ULL,
0x3d80000024247820ULL, 0x000fe20000410000ULL, 0x3d80000023237820ULL, 0x000fe20000410000ULL,
0x3d80000022227820ULL, 0x000fe20000410000ULL, 0x3d80000021217820ULL, 0x000fe20000410000ULL,
0x3d80000020207820ULL, 0x000fe20000410000ULL, 0x3d8000001e1e7820ULL, 0x000fe20000410000ULL,
0x3d8000001d1d7820ULL, 0x000fe20000410000ULL, 0x3d8000001c1c7820ULL, 0x000fe20000410000ULL,
0x3d8000001b097820ULL, 0x000fe20000410000ULL, 0x3d80000026337820ULL, 0x000fe20000410000ULL,
0x0000002900317202ULL, 0x002fe20000000f00ULL, 0x3d8000000f287820ULL, 0x000fe20000410000ULL,
0x3d8000000e297820ULL, 0x000fe20000410000ULL, 0x3d8000001a347820ULL, 0x000fe20000410000ULL,
0x3d80000019357820ULL, 0x000fe20000410000ULL, 0x000000ffff277224ULL, 0x000fe200078e0028ULL,
0x3d80000018367820ULL, 0x000fe20000410000ULL, 0x000000ffff287224ULL, 0x000fe200078e0029ULL,
0x3d80000017377820ULL, 0x000fe20000410000ULL, 0x000000ffff297224ULL, 0x000fe200078e002aULL,
0x3d800000163c7820ULL, 0x000fe20000410000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0015ULL,
0x3d8000000b2c7820ULL, 0x000fe20000410000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0014ULL,
0x3d8000000a2d7820ULL, 0x000fe20000410000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0013ULL,
0x0000000400267202ULL, 0x000fe20000000f00ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0012ULL,
0x0000002500127202ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe200078e0011ULL,
0x0000001f00187202ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fc400078e002bULL,
0x000000ffff167224ULL, 0x000fe400078e0008ULL, 0x000000ffff117224ULL, 0x000fe400078e0024ULL,
0x000000ffff137224ULL, 0x000fe400078e0023ULL, 0x000000ffff147224ULL, 0x000fe400078e0022ULL,
0x000000ffff157224ULL, 0x000fe400078e0021ULL, 0x000000ffff177224ULL, 0x000fc400078e0020ULL,
0x000000ffff197224ULL, 0x000fe400078e001eULL, 0x000000ffff1a7224ULL, 0x000fe400078e001dULL,
0x000000ffff1b7224ULL, 0x000fe400078e001cULL, 0x000000ffff2b7224ULL, 0x000fc400078e0009ULL,
0x0000000000087805ULL, 0x000fca0000015200ULL, 0x0000040073047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a081d7210ULL, 0x000fc80007f1e1ffULL, 0x0000000b090b7210ULL, 0x000fe400007fe5ffULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140bULL, 0x0000001d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000204047819ULL, 0x000fc8000000120bULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040073047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff0ab047812ULL, 0x000fe400078ec0ffULL,
0x000000787b00720cULL, 0x000fc60003f05270ULL, 0x0000008079047824ULL, 0x000fca00078e0204ULL,
0x0144000004087984ULL, 0x0002aa0000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002071c7824ULL, 0x000fe400078e00ffULL, 0x0000000175067824ULL, 0x000fc600078e0a06ULL,
0x000000061c1d7812ULL, 0x000fc800078ec0ffULL, 0x000000011d1f7812ULL, 0x040fe400078efcffULL,
0x000000081d217812ULL, 0x000fe400078efcffULL, 0x000000061f00720cULL, 0x080fe40003f26070ULL,
0x000000101d1f7812ULL, 0x000fe400078efcffULL, 0x000000062100720cULL, 0x080fe40003f06070ULL,
0x000000061f00720cULL, 0x000fc40003fc6070ULL, 0x000000111d217812ULL, 0x040fe400078efcffULL,
0x000000181d1f7812ULL, 0x040fe400078efcffULL, 0x000000061d00720cULL, 0x080fe40003f46070ULL,
0x000000062100720cULL, 0x080fe40003fa6070ULL, 0x000000061f00720cULL, 0x000fe40003f66070ULL,
0x000000091d237812ULL, 0x000fc400078efcffULL, 0x000000191d217812ULL, 0x040fe400078efcffULL,
0x000000201d1f7812ULL, 0x000fe400078efcffULL, 0xff80000012127808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000011117808ULL, 0x000fe40004800000ULL,
0xff8000000c0c7808ULL, 0x000fc40004800000ULL, 0x000000062300720cULL, 0x080fe40003f86070ULL,
0x000000062100720cULL, 0x080fe40003f46070ULL, 0x000000061f00720cULL, 0x000fe40003f26070ULL,
0x000000211d217812ULL, 0x040fe400078efcffULL, 0x000000281d1f7812ULL, 0x000fe400078efcffULL,
0xff80000013137808ULL, 0x000fc40004000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004000000ULL,
0xff80000014147808ULL, 0x000fe40006000000ULL, 0xff8000000f0f7808ULL, 0x000fe40006000000ULL,
0x000000062100720cULL, 0x080fe40003f06070ULL, 0x000000061f00720cULL, 0x000fe40003f86070ULL,
0x000000291d217812ULL, 0x000fc400078efcffULL, 0x000000301d1f7812ULL, 0x000fe400078efcffULL,
0xff80000015157808ULL, 0x000fe40007000000ULL, 0xff80000010107808ULL, 0x000fe40007000000ULL,
0xff80000017177808ULL, 0x000fe40006800000ULL, 0xff80000026267808ULL, 0x000fe40006800000ULL,
0x000000062100720cULL, 0x000fc40003fc6070ULL, 0x000000061f00720cULL, 0x000fe40003fa6070ULL,
0x000000311d217812ULL, 0x040fe400078efcffULL, 0x000000381d1f7812ULL, 0x040fe400078efcffULL,
0x000000391d1d7812ULL, 0x000fe400078efcffULL, 0xff80000018187808ULL, 0x000fe40005800000ULL,
0xff80000027277808ULL, 0x000fc40005800000ULL, 0xff80000019197808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40004800000ULL,
0xff80000029297808ULL, 0x000fe40004800000ULL, 0x000000062100720cULL, 0x080fe40003f66070ULL,
0x000000061f00720cULL, 0x000fc40003f46070ULL, 0x000000061d00720cULL, 0x000fe40003f26070ULL,
0xff8000001b1b7808ULL, 0x000fe40004000000ULL, 0xff8000002a2a7808ULL, 0x000fe40004000000ULL,
0xff8000002b2b7808ULL, 0x000fe40006000000ULL, 0xff8000002c2c7808ULL, 0x000fe40006000000ULL,
0xff80000034347808ULL, 0x000fc40007000000ULL, 0xff8000002d2d7808ULL, 0x000fe40007000000ULL,
0xff80000035357808ULL, 0x000fe40006800000ULL, 0xff8000002e2e7808ULL, 0x000fe40006800000ULL,
0xff80000036367808ULL, 0x000fe40005800000ULL, 0xff8000002f2f7808ULL, 0x000fe40005800000ULL,
0xff80000037377808ULL, 0x000fc40005000000ULL, 0xff80000033337808ULL, 0x000fe40005000000ULL,
0xff8000003c3c7808ULL, 0x000fe40004800000ULL, 0xff80000016167808ULL, 0x000fc40004800000ULL,
0x0000000d0800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff1e7424ULL, 0x000fe200078e00ffULL,
0x000000120900720bULL, 0x000fe40003f3e000ULL, 0x000000080d1d7208ULL, 0x000fe40004000000ULL,
0x0000000912067208ULL, 0x000fc40004800000ULL, 0x0000000c1d00720bULL, 0x000fe40003f1e000ULL,
0x000000110600720bULL, 0x000fe40003f3e000ULL, 0x0000001d0c1d7208ULL, 0x000fe40004000000ULL,
0x0000000611067208ULL, 0x000fe40004800000ULL, 0x0000000e1d00720bULL, 0x000fe40003f1e000ULL,
0x000000130600720bULL, 0x000fc40003f3e000ULL, 0x0000001d0e087208ULL, 0x000fe40004000000ULL,
0x0000000613097208ULL, 0x000fe40004800000ULL, 0x0000000f0800720bULL, 0x000fe40003f1e000ULL,
0x000000140900720bULL, 0x000fe40003f3e000ULL, 0x000000080f1d7208ULL, 0x000fe40004000000ULL,
0x0000000914067208ULL, 0x000fc40004800000ULL, 0x000000101d00720bULL, 0x000fe40003f1e000ULL,
0x000000150600720bULL, 0x000fe40003f3e000ULL, 0x0000001d101d7208ULL, 0x000fe40004000000ULL,
0x0000000615067208ULL, 0x000fe40004800000ULL, 0x000000261d00720bULL, 0x000fe40003f1e000ULL,
0x000000170600720bULL, 0x000fc40003f3e000ULL, 0x0000001d26087208ULL, 0x000fe40004000000ULL,
0x0000000617097208ULL, 0x000fe40004800000ULL, 0x000000270800720bULL, 0x000fe40003f1e000ULL,
0x000000180900720bULL, 0x000fe40003f3e000ULL, 0x00000008271d7208ULL, 0x000fe40004000000ULL,
0x0000000918067208ULL, 0x000fc40004800000ULL, 0x000000281d00720bULL, 0x000fe40003f1e000ULL,
0x000000190600720bULL, 0x000fe40003f3e000ULL, 0x0000001d28087208ULL, 0x000fe40004000000ULL,
0x0000000619097208ULL, 0x000fe40004800000ULL, 0x000000290800720bULL, 0x000fe40003f1e000ULL,
0x0000001a0900720bULL, 0x000fc40003f3e000ULL, 0x00000008291d7208ULL, 0x000fe40004000000ULL,
0x000000091a067208ULL, 0x000fe40004800000ULL, 0x0000002a1d00720bULL, 0x000fe40003f1e000ULL,
0x0000001b0600720bULL, 0x000fe40003f3e000ULL, 0x0000001d2a1d7208ULL, 0x000fe40004000000ULL,
0x000000061b067208ULL, 0x000fc40004800000ULL, 0x0000002c1d00720bULL, 0x000fe40003f1e000ULL,
0x0000002b0600720bULL, 0x000fe40003f3e000ULL, 0x0000001d2c087208ULL, 0x000fe40004000000ULL,
0x000000062b097208ULL, 0x000fe40004800000ULL, 0x0000002d0800720bULL, 0x000fe40003f1e000ULL,
0x000000340900720bULL, 0x000fc40003f3e000ULL, 0x000000082d1d7208ULL, 0x000fe40004000000ULL,
0x0000000934067208ULL, 0x000fe40004800000ULL, 0x0000002e1d00720bULL, 0x000fe40003f1e000ULL,
0x000000350600720bULL, 0x000fe40003f3e000ULL, 0x0000001d2e087208ULL, 0x000fe40004000000ULL,
0x0000000635097208ULL, 0x000fc40004800000ULL, 0x0000002f0800720bULL, 0x000fe40003f1e000ULL,
0x000000360900720bULL, 0x000fe40003f3e000ULL, 0x000000082f087208ULL, 0x000fe40004000000ULL,
0x0000000936067208ULL, 0x000fe40004800000ULL, 0x000000330800720bULL, 0x000fe40003f1e000ULL,
0x000000370600720bULL, 0x000fc40003f3e000ULL, 0x0000000833097208ULL, 0x000fe40004000000ULL,
0x00000006371d7208ULL, 0x000fe40004800000ULL, 0x000000160900720bULL, 0x000fe40003f1e000ULL,
0x0000003c1d00720bULL, 0x000fe40003f3e000ULL, 0xffffffff00257802ULL, 0x000fe40000000f00ULL,
0x00000009161c7208ULL, 0x000fc40004000000ULL, 0x0000001d3c1f7208ULL, 0x000fe20004800000ULL,
0x000018f27f007947ULL, 0x000fea000b800000ULL, 0x0c401f001c067f89ULL, 0x0004e400000e0000ULL,
0x000000061c00720bULL, 0x00cfc80003f1e000ULL, 0x0000001c06217208ULL, 0x000fe20004000000ULL,
0x000018f27f007947ULL, 0x000fea000b800000ULL, 0x0c401f001f067f89ULL, 0x000ea800000e0000ULL,
0x0c401f000a097f89ULL, 0x000ee800000e0000ULL, 0x0c401f000b087f89ULL, 0x000f2800000e0000ULL,
0x0c201f0021307f89ULL, 0x000e6200000e0000ULL, 0x000000061f00720bULL, 0x004fc40003f1e000ULL,
0x000000090a00720bULL, 0x008fe40003f3e000ULL, 0x0000001f06067208ULL, 0x000fe40004000000ULL,
0x0000000a09097208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x010fe20003f1e000ULL,
0x0c201f0006317f89ULL, 0x000ea600000e0000ULL, 0x0000000b08427208ULL, 0x000fe20004000000ULL,
0x0c201f0009327f89ULL, 0x000ee200000e0000ULL, 0x000000302100720bULL, 0x002fc60003f1e000ULL,
0x0c201f0042437f89ULL, 0x00026200000e0000ULL, 0x0000002130307208ULL, 0x000fe40004000000ULL,
0x000000310600720bULL, 0x004fe40003f3e000ULL, 0x000000320900720bULL, 0x008fe40003f5e000ULL,
0x0000000631317208ULL, 0x000fe40004800000ULL, 0x0000000932327208ULL, 0x000fc60005000000ULL,
0x3fb8aa3b31067820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b303d7820ULL, 0x000fe20000410000ULL,
0x3c003c00ff407424ULL, 0x000fe200078e00ffULL, 0x3c003c0000417802ULL, 0x000fe20000000f00ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010806ULL,
0x0000001200257308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b1b1c7823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b2b1b7823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010806ULL,
0x0000001300237308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b0f127823ULL, 0x102fe2000001083dULL,
0x3fb8aa3b191e7823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b270f7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b1a1d7823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b341a7823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b35197823ULL, 0x000fe20000010806ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001400227308ULL, 0x000e620000000800ULL, 0x3fb8aa3b0e137823ULL, 0x104fe2000001083dULL,
0x3fb8aa3b280e7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b2c0b7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b2d0a7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b2e097823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b2f087823ULL, 0x100fe2000001083dULL, 0x0000000181277810ULL, 0x040fe20007ffe0ffULL,
0x0000001500217308ULL, 0x000fe20000000800ULL, 0x00000008813e7824ULL, 0x040fe200078e00ffULL,
0x3fb8aa3b16167823ULL, 0x000fe2000001083dULL, 0x0000000881487824ULL, 0x040fe200078e00ffULL,
0x00000002813f7810ULL, 0x040fe20007ffe0ffULL, 0x00000008814a7824ULL, 0x040fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee227ULL, 0x00000008814c7824ULL, 0x040fe200078e00ffULL,
0x0000001100247308ULL, 0x0004e20000000800ULL, 0x00000023222b723eULL, 0x002fe200000000ffULL,
0x0000000881467824ULL, 0x040fe200078e00ffULL, 0x00000003814e7819ULL, 0x040fe200000006ffULL,
0x0000000881447824ULL, 0x000fe200078e00ffULL, 0x0000000cabab7812ULL, 0x000fe200078ec0ffULL,
0x000000087f527824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee23fULL,
0x0000000d00157308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b10117823ULL, 0x104fe2000001083dULL,
0x3fb8aa3b26107823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b33267823ULL, 0x000fe2000001083dULL,
0x0000000381337810ULL, 0x000fc40007ffe0ffULL, 0x00000006813f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c00147308ULL, 0x0005220000000800ULL, 0x3fb8aa3b290d7823ULL, 0x002fe2000001083dULL,
0x000000252429723eULL, 0x008fe400000000ffULL, 0xfffffff848487812ULL, 0x000fe400078ee233ULL,
0x0000000481337810ULL, 0x040fe40007ffe0ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a0c7823ULL, 0x004fe2000001083dULL, 0x00000005813d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff84a4a7812ULL, 0x000fe400078ee233ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee23dULL,
0x00000008813d7824ULL, 0x000fe200078e00ffULL, 0x0000001200127308ULL, 0x000e620000000800ULL,
0x000000151428723eULL, 0x010fe400000000ffULL, 0x0000a00079337811ULL, 0x000fe400078e58ffULL,
0xfffffff84e4e7812ULL, 0x000fe400078ee23fULL, 0xfffffff844447812ULL, 0x000fe200078ee281ULL,
0x0000001700207308ULL, 0x0004e20000000800ULL, 0xfffffff852527812ULL, 0x000fe200078ee27fULL,
0x000000104a477824ULL, 0x100fe200078e0233ULL, 0x0000003346457211ULL, 0x080fe200078e20ffULL,
0x0000001044447824ULL, 0x100fe200078e0233ULL, 0x00000033524b7211ULL, 0x000fe200078e20ffULL,
0x0000001048467824ULL, 0x100fe200078e0233ULL, 0x0000000307ff7812ULL, 0x000fe2000780c0ffULL,
0x00000018001f7308ULL, 0x0009e20000000800ULL, 0x00000013122a723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b37177823ULL, 0x004fe20000010806ULL, 0x000000104c487824ULL, 0x100fe200078e0233ULL,
0x000000434200720bULL, 0x000fe20003f3e000ULL, 0x000000104e497824ULL, 0x000fc400078e0233ULL,
0x00000001ab457824ULL, 0x000fe200078e0245ULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b36187823ULL, 0x110fe20000010806ULL, 0x00000021202d723eULL, 0x008fe200000000ffULL,
0x000000402834723cULL, 0x000f6200000018ffULL, 0x3fb8aa3b3c067823ULL, 0x000fe20000010806ULL,
0xffffffff813c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001ab467824ULL, 0x040fe200078e0246ULL,
0x00000048ab487210ULL, 0x000fe20007ffe0ffULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0xfffffff83d507812ULL, 0x000fe200078ee23cULL, 0x00000001ab477824ULL, 0x000fc400078e0247ULL,
0x00000001ab497824ULL, 0x040fe400078e0249ULL, 0x00000010504a7824ULL, 0x000fe400078e0233ULL,
0x0000001000107308ULL, 0x000ea20000000800ULL, 0x0000001f1e2f723eULL, 0x002fe200000000ffULL,
0x00000001ab4a7824ULL, 0x000fcc00078e024aULL, 0x0000000f000f7308ULL, 0x000ff00000000800ULL,
0x0000000e000e7308ULL, 0x000e620000000800ULL, 0x00000011102c723eULL, 0x004fce00000000ffULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x0000000f0e2e723eULL, 0x002fce00000000ffULL,
0x0000001c001c7308ULL, 0x000e620000000800ULL, 0x000000402c38723cULL, 0x020b6e0000001834ULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x0000001d1c35723eULL, 0x022fce00000000ffULL, 0x0000000d000d7308ULL, 0x000ff00000000800ULL,
0x0000000c000c7308ULL, 0x000e620000000800ULL, 0x0000001b1a37723eULL, 0x004fce00000000ffULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000000a000a7308ULL, 0x000ea20000000800ULL,
0x0000000d0c34723eULL, 0x002fce00000000ffULL, 0x0000001600277308ULL, 0x000fe20000000800ULL,
0x0000000b0a36723eULL, 0x004fce00000000ffULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x000000403438723cULL, 0x000f6e0000001838ULL, 0x0000001800187308ULL, 0x000e700000000800ULL,
0x0000001700177308ULL, 0x000ff00000000800ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x00000019183d723eULL, 0x002fce00000000ffULL, 0x0000000800087308ULL, 0x000e700000000800ULL,
0x0000002600267308ULL, 0x000eb00000000800ULL, 0x0000000600167308ULL, 0x0007220000000800ULL,
0x00000009083c723eULL, 0x002fe200000000ffULL, 0x000000103e067824ULL, 0x008fe200078e0233ULL,
0x00000026273e723eULL, 0x004fe200000000ffULL, 0x00000001ab337824ULL, 0x000fc400078e0244ULL,
0x00000001ab067824ULL, 0x000fe200078e0206ULL, 0x00000017163f723eULL, 0x010fe400000000ffULL,
0x0000002833007388ULL, 0x0003e80000000800ULL, 0x0000002a06007388ULL, 0x0005e20000000800ULL,
0x000000403c38723cULL, 0x020b660000001838ULL, 0x0000002c45007388ULL, 0x0005e20000000800ULL,
0x0000004243337208ULL, 0x002fc60004800000ULL, 0x0000002e46007388ULL, 0x0005e20000000800ULL,
0x00000001ab407824ULL, 0x020fc600078e024bULL, 0x0000003447007388ULL, 0x0005e80000000800ULL,
0x0000003648007388ULL, 0x0005e80000000800ULL, 0x0000003c49007388ULL, 0x0005e80000000800ULL,
0x0000003e4a007388ULL, 0x0005e20000000800ULL, 0x000000ffff397224ULL, 0x000fc600078e003aULL,
0x0000002940007388ULL, 0x0005e80000000800ULL, 0x0004002b06007388ULL, 0x0005e80000000800ULL,
0x0004002d45007388ULL, 0x0005e80000000800ULL, 0x0004002f46007388ULL, 0x0005e80000000800ULL,
0x0004003547007388ULL, 0x0005e80000000800ULL, 0x0004003748007388ULL, 0x0005e80000000800ULL,
0x0004003d49007388ULL, 0x0005e80000000800ULL, 0x0004003f4a007388ULL, 0x0005e80000000800ULL,
0x0140003004008388ULL, 0x0005e80000000c00ULL, 0x0142003804008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ad80071ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ae00071ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ae80071ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000003007b7b7a10ULL, 0x000fe20007ffe0ffULL,
0x014af00071ff7f8cULL, 0x0003e6000c80043fULL, 0x000000747b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff612000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff357807ULL, 0x008fe40004000000ULL,
0x000250a000347802ULL, 0x000fc40000000f00ULL, 0x0000109000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0039ULL, 0xfffdf53000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x000fe40004800000ULL, 0x000250f000347802ULL, 0x000fc40000000f00ULL,
0x0000104000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0039ULL,
0xfffdf57000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3b7224ULL, 0x000fe200078e0029ULL,
0x0002515000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3a7224ULL, 0x000fc400078e0030ULL,
0x00000fa000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e003aULL,
0xfffdf61000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0030ULL,
0x00000029003b7202ULL, 0x002fc40000000f00ULL, 0x000251b000347802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e003aULL,
0xfffdf71000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0029ULL,
0x0002521000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e0028ULL,
0x00000ee000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffdf8e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3b7224ULL, 0x002fe200078e0026ULL,
0x00000029003a7202ULL, 0x000fe40000000f00ULL, 0x0002527000347802ULL, 0x000fc40000000f00ULL,
0x00000e8000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffdf8b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x000252d000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x00000e2000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffe1e1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x0002533000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fc400078e007aULL,
0x00000dc000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffe1dd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x008fe40004000000ULL,
0x0002538000347802ULL, 0x000fc40000000f00ULL, 0x00000db000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0039ULL, 0xfffe471000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x000fe40004800000ULL, 0x000253d000347802ULL, 0x000fc40000000f00ULL,
0x00000d6000007944ULL, 0x002fea0003c00000ULL, 0xfffe476000007947ULL, 0x000fea000383ffffULL,
0x0000003d003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e007cULL,
0x0002542000347802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffe47f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x0002548000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007aULL, 0x00000c7000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffe48e000007947ULL, 0x000fea000383ffffULL,
0x00000037003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e007cULL,
0x000254e000347802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe4aa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0002554000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007aULL, 0x00000bb000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffe4a6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x000255a000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e007cULL, 0x00000b5000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe6ca000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0002560000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007aULL, 0x00000af000007944ULL, 0x00cfea0003c00000ULL,
0x0000003a00267202ULL, 0x004fe20000000f00ULL, 0xfffe6c6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x008fe40004000000ULL, 0x0002565000347802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffe93e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x000fe40004800000ULL,
0x000256a000347802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x002fea0003c00000ULL,
0xfffe943000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x000256f000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x00000a0000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffe94c000007947ULL, 0x000fea000383ffffULL, 0x0000003d003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fe200078e007aULL, 0x0002575000347802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffe95b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x000257b000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x0000094000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffe977000007947ULL, 0x000fea000383ffffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fe200078e007aULL, 0x0002581000347802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffe973000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x0000007c003b7202ULL, 0x000fc40000000f00ULL, 0x0002587000347802ULL, 0x000fc40000000f00ULL,
0x0000088000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffeb97000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x000258d000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fc400078e007aULL,
0x0000082000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffeb93000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x008fe40004000000ULL,
0x0002592000347802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0039ULL, 0xfffee0b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x000fe40004800000ULL, 0x0002597000347802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x002fea0003c00000ULL, 0xfffee10000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x000259c000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e007cULL, 0x0000073000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffee19000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x00025a2000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007aULL, 0x000006d000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffee28000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x00025a8000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e007cULL, 0x0000067000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffee44000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x00025ae000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007aULL, 0x0000061000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffee40000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x00025b4000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e007cULL, 0x000005b000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xffff064000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x00025ba000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007aULL, 0x0000055000007944ULL, 0x00cfea0003c00000ULL,
0x0000003a00267202ULL, 0x004fe20000000f00ULL, 0xffff060000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x00cfe200078e0003ULL, 0x00025bf000347802ULL, 0x000fc40000000f00ULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e003aULL,
0xffff0e7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0003ULL,
0x00025c4000347802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e003aULL, 0xffff0f6000007947ULL, 0x000fea000383ffffULL,
0x00000002ff1d7424ULL, 0x000fe200078e00ffULL, 0x00025c9000087802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x002fea0003c00000ULL, 0xffffe6e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x002fe200078e001fULL, 0x00025ce000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff1d7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000061f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff1c7224ULL, 0x002fe200078e000aULL,
0x00025d4000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff1d7424ULL, 0x000fe200078e00ffULL,
0x0000001f061f7208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000060a00720bULL, 0x004fe20003f1e000ULL, 0x00000002ff1d7424ULL, 0x002fe200078e00ffULL,
0x0000000b001c7202ULL, 0x000fc40000000f00ULL, 0x0000000a06237208ULL, 0x000fe40004000000ULL,
0x00025da000087802ULL, 0x000fc40000000f00ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000060b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff1c7224ULL, 0x002fe200078e0021ULL,
0x00025e0000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff1d7424ULL, 0x000fe200078e00ffULL,
0x0000000b06427208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000062100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff1c7224ULL, 0x002fe200078e001fULL,
0x00025e6000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff1d7424ULL, 0x000fe200078e00ffULL,
0x0000002106307208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000061f00720bULL, 0x004fe20003f1e000ULL, 0x00000001ff1d7424ULL, 0x002fe200078e00ffULL,
0x00000023001c7202ULL, 0x000fc40000000f00ULL, 0x0000001f06317208ULL, 0x000fe40004000000ULL,
0x00025ec000087802ULL, 0x000fc40000000f00ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000062300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff1c7224ULL, 0x002fe200078e0042ULL,
0x00025f2000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff1d7424ULL, 0x000fe200078e00ffULL,
0x0000002306327208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff437224ULL, 0x004fe200078e0006ULL, 0xffffe5a000007947ULL, 0x000fea000383ffffULL,
0x0180000030037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000003000038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff0a7807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x000000030aff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff30ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000030077812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x000000030aff7212ULL, 0x000fda000780c0ffULL,
0x0080000007030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0007ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003000037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000077802ULL, 0x000fc80000000f00ULL,
0xfffd9f5006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000002500007348ULL, 0x000fe80003800000ULL, 0x0c00001d1c067389ULL, 0x0002a200000e001eULL,
0xfffd9f1008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff357424ULL, 0x000fe200078e00ffULL,
0x0000002000007348ULL, 0x000fe80003800000ULL, 0x0000003b3a3a7389ULL, 0x0002a200000e001fULL,
0xfffd9ed034007950ULL, 0x000fea0003c3ffffULL, 0x000000013500780cULL, 0x000fe20003f25070ULL,
0x0000002200007348ULL, 0x000fd80003800000ULL, 0x0000000000357806ULL, 0x000fc800048e0100ULL,
0x0000002235397212ULL, 0x000fe200078ec0ffULL, 0x00000000ff357424ULL, 0x000fc800078e00ffULL,
0xfffd9e7034007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000000200007348ULL, 0x000fe80003800000ULL, 0xfffd9e4028007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000567ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000380ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cb8ULL,
0x00000000000000e4ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d9cULL,
0x0000000000000cacULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001a48ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001a58ULL,
0x00000000000000b0ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001b08ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001b0cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001d00ULL,
0x0000000000026280ULL, 0xc600001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000027f80ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000027fc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000028340ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001b08ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000026478ULL,
0x0000000000026478ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000027f80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000028340ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_fp16_pagedKV_64_nqpkv_1_m_1_sm_89_cubin_len = 164896;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
