/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000020248ULL, 0x000000000001fec8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL, 0x326a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45346aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x5f24000000000000ULL,
0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL, 0x5f6e725f7063725fULL,
0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL, 0x656e72656b2e7478ULL,
0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x72656b240061686dULL,
0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL, 0x656d6172665f6775ULL,
0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL, 0x72665f6775626564ULL,
0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x0000000061686d5fULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000036eULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000003b5ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000403ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000448ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000004a3ULL, 0x000000000001e4d0ULL, 0x0000000000000230ULL, 0x0004000300000519ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x000000000001e700ULL, 0x000d000300000549ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001e4d000000000ULL, 0x0000700400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL, 0x0001e4d000000000ULL,
0x0000023000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000001600082f04ULL, 0x000823040000007eULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL, 0x000c17040021f000ULL,
0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL, 0x000c17040061f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x00c82804ffffffffULL, 0x00000100000000e0ULL, 0x0000331000000780ULL,
0x0000343000003370ULL, 0x0000382000003570ULL, 0x00005d2000003830ULL, 0x0000855000005d30ULL,
0x00008670000085c0ULL, 0x00008970000087a0ULL, 0x0000aca000008980ULL, 0x0000d3d00000acb0ULL,
0x0000d4f00000d440ULL, 0x0000d7f00000d620ULL, 0x0000fb200000d800ULL, 0x000122500000fb30ULL,
0x00012370000122c0ULL, 0x00012670000124a0ULL, 0x000149a000012680ULL, 0x00015c90000149b0ULL,
0x000163e000015ca0ULL, 0x00018b3000016720ULL, 0x0001b7c000019530ULL, 0x0001d8b00001d710ULL,
0x0001da200001d970ULL, 0x0001dcb00001dc70ULL, 0x0001df700001dd30ULL, 0x0000021007d03904ULL,
0x00018ad0000000ffULL, 0x000002f000040100ULL, 0x00018ad800000008ULL, 0x00000400003f0100ULL,
0x00018b5800000008ULL, 0x00000520003f0100ULL, 0x00018b7800000002ULL, 0x00000610003f0100ULL,
0x00018b88000000ffULL, 0x000008f000040100ULL, 0x00018ad0000000ffULL, 0x00000b6000060107ULL,
0x00018b580000005bULL, 0x00000bb000060101ULL, 0x00018b88000000ffULL, 0x00000be000060101ULL,
0x00018b88000000ffULL, 0x00000d5000060109ULL, 0x00018b88000000ffULL, 0x000017c000060109ULL,
0x00018b88000000ffULL, 0x000017f000060101ULL, 0x00018b88000000ffULL, 0x0000196000060109ULL,
0x00018b88000000ffULL, 0x00001ac000060109ULL, 0x00018b78000000ffULL, 0x00001b0000060107ULL,
0x00018b78000000ffULL, 0x00001b8000060101ULL, 0x00018b88000000ffULL, 0x00001da000060101ULL,
0x00018b78000000ffULL, 0x00001f1000060109ULL, 0x00018b78000000ffULL, 0x00001f4000060109ULL,
0x00018b88000000ffULL, 0x000020b000060109ULL, 0x00018b88000000ffULL, 0x00002b4000060109ULL,
0x00018b88000000ffULL, 0x00002b7000060101ULL, 0x00018b88000000ffULL, 0x00002ce000060109ULL,
0x00018b88000000ffULL, 0x0000305000060109ULL, 0x00018b80000000ffULL, 0x0000309000060107ULL,
0x00018b80000000ffULL, 0x000030b000060101ULL, 0x00018ad80000005bULL, 0x000030e000060101ULL,
0x00018ad80000005bULL, 0x0000325000060109ULL, 0x00018ad80000005bULL, 0x00004ac000060109ULL,
0x00018b88000000ffULL, 0x00004b8000060101ULL, 0x00018b80000000ffULL, 0x00004cf000060109ULL,
0x00018b80000000ffULL, 0x00004d2000060109ULL, 0x00018b88000000ffULL, 0x00004e9000060109ULL,
0x00018b88000000ffULL, 0x000058f000060109ULL, 0x00018b88000000ffULL, 0x0000592000060101ULL,
0x00018b88000000ffULL, 0x00005a9000060109ULL, 0x00018b88000000ffULL, 0x00005c8000060109ULL,
0x00000000000000ffULL, 0x00005ce000090107ULL, 0x00018b78000000ffULL, 0x00006ee000060101ULL,
0x00018b88000000ffULL, 0x00006f4000060101ULL, 0x00018b58000000ffULL, 0x0000701000060101ULL,
0x00018b78000000ffULL, 0x0000718000060109ULL, 0x00018b78000000ffULL, 0x000071b000060109ULL,
0x00018b88000000ffULL, 0x0000732000060109ULL, 0x00018b88000000ffULL, 0x00007db000060109ULL,
0x00018b88000000ffULL, 0x00007de000060101ULL, 0x00018b88000000ffULL, 0x00007f5000060109ULL,
0x00018b88000000ffULL, 0x0000829000060109ULL, 0x00000000000000ffULL, 0x000082c0000a0107ULL,
0x00018b80000000ffULL, 0x0000830000060101ULL, 0x00018af80000005bULL, 0x0000833000060101ULL,
0x00018af80000005bULL, 0x000084a000060109ULL, 0x00018af80000005bULL, 0x00009a9000060109ULL,
0x00018b88000000ffULL, 0x00009b6000060101ULL, 0x00018b80000000ffULL, 0x00009cd000060109ULL,
0x00018b80000000ffULL, 0x00009d0000060109ULL, 0x00018b88000000ffULL, 0x00009e7000060109ULL,
0x00018b88000000ffULL, 0x0000a8d000060109ULL, 0x00018b88000000ffULL, 0x0000a90000060101ULL,
0x00018b88000000ffULL, 0x0000aa7000060109ULL, 0x00018b88000000ffULL, 0x0000ac3000060109ULL,
0x00000000000000ffULL, 0x0000ac6000090107ULL, 0x00018b78000000ffULL, 0x0000bd7000060101ULL,
0x00018b88000000ffULL, 0x0000bdc000060101ULL, 0x00018b60000000ffULL, 0x0000be9000060101ULL,
0x00018b78000000ffULL, 0x0000c00000060109ULL, 0x00018b78000000ffULL, 0x0000c03000060109ULL,
0x00018b88000000ffULL, 0x0000c1a000060109ULL, 0x00018b88000000ffULL, 0x0000cc3000060109ULL,
0x00018b88000000ffULL, 0x0000cc6000060101ULL, 0x00018b88000000ffULL, 0x0000cdd000060109ULL,
0x00018b88000000ffULL, 0x0000d11000060109ULL, 0x00000000000000ffULL, 0x0000d140000a0107ULL,
0x00018b80000000ffULL, 0x0000d18000060101ULL, 0x00018b180000005bULL, 0x0000d1b000060101ULL,
0x00018b180000005bULL, 0x0000d32000060109ULL, 0x00018b180000005bULL, 0x0000e91000060109ULL,
0x00018b88000000ffULL, 0x0000e9e000060101ULL, 0x00018b80000000ffULL, 0x0000eb5000060109ULL,
0x00018b80000000ffULL, 0x0000eb8000060109ULL, 0x00018b88000000ffULL, 0x0000ecf000060109ULL,
0x00018b88000000ffULL, 0x0000f75000060109ULL, 0x00018b88000000ffULL, 0x0000f78000060101ULL,
0x00018b88000000ffULL, 0x0000f8f000060109ULL, 0x00018b88000000ffULL, 0x0000fab000060109ULL,
0x00000000000000ffULL, 0x0000fae000090107ULL, 0x00018b78000000ffULL, 0x00010bf000060101ULL,
0x00018b88000000ffULL, 0x00010c4000060101ULL, 0x00018b68000000ffULL, 0x00010d1000060101ULL,
0x00018b78000000ffULL, 0x00010e8000060109ULL, 0x00018b78000000ffULL, 0x00010eb000060109ULL,
0x00018b88000000ffULL, 0x0001102000060109ULL, 0x00018b88000000ffULL, 0x00011ab000060109ULL,
0x00018b88000000ffULL, 0x00011ae000060101ULL, 0x00018b88000000ffULL, 0x00011c5000060109ULL,
0x00018b88000000ffULL, 0x00011f9000060109ULL, 0x00000000000000ffULL, 0x00011fc0000a0107ULL,
0x00018b80000000ffULL, 0x0001200000060101ULL, 0x00018b380000005bULL, 0x0001203000060101ULL,
0x00018b380000005bULL, 0x000121a000060109ULL, 0x00018b380000005bULL, 0x0001379000060109ULL,
0x00018b88000000ffULL, 0x0001386000060101ULL, 0x00018b80000000ffULL, 0x000139d000060109ULL,
0x00018b80000000ffULL, 0x00013a0000060109ULL, 0x00018b88000000ffULL, 0x00013b7000060109ULL,
0x00018b88000000ffULL, 0x000145d000060109ULL, 0x00018b88000000ffULL, 0x0001460000060101ULL,
0x00018b88000000ffULL, 0x0001477000060109ULL, 0x00018b88000000ffULL, 0x0001493000060109ULL,
0x00000000000000ffULL, 0x0001496000090107ULL, 0x00018b78000000ffULL, 0x00015a7000060101ULL,
0x00018b88000000ffULL, 0x00015ab000060101ULL, 0x00018b70000000ffULL, 0x0001666000060101ULL,
0x00018ad0000000ffULL, 0x00018b6000060101ULL, 0x00018ad0000000ffULL, 0x00018cd000060109ULL,
0x00018ad0000000ffULL, 0x0001902000060109ULL, 0x00018ad0000000ffULL, 0x0001905000060101ULL,
0x00018ad0000000ffULL, 0x000191c000060109ULL, 0x00018ad0000000ffULL, 0x0001ce6000060109ULL,
0x00018b5800000044ULL, 0x0001d040003f0101ULL, 0x00018b5800000044ULL, 0x0001d1b0003f0109ULL,
0x00018b5800000044ULL, 0x0001e470003f0109ULL, 0x00018ad800000000ULL, 0x0001e480003f0101ULL,
0x00018ae000000000ULL, 0x0001e490003f0101ULL, 0x00018ae800000000ULL, 0x0001e4a0003f0101ULL,
0x00018af000000000ULL, 0x00053803003f0101ULL, 0x0001649000101c04ULL, 0x000192d0000191f0ULL,
0x000c05040001e4c0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0068190300000000ULL,
0x0000001700080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL, 0x0000001600000002ULL,
0x000000000001e4d0ULL, 0x0000000000000044ULL, 0x0000001600000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000018c00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008800ff067b82ULL, 0x000ee20000000a00ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x00000000005f7919ULL, 0x000f220000002100ULL, 0x0000000000137919ULL, 0x000ee20000002600ULL,
0x0000000000127919ULL, 0x000ee20000002700ULL, 0x0000000404007c24ULL, 0x004fe2000f8e0203ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000000400027c24ULL, 0x110fe2000f8e025fULL, 0x00000005ff5f7819ULL, 0x000fe2000001165fULL,
0x00001fff04007589ULL, 0x000fe600000e0000ULL, 0x0000007f0200780cULL, 0x000fc40003f64070ULL,
0x00001fff5f5f7589ULL, 0x000ea200000e0000ULL, 0x000000ff0200720cULL, 0x040fe40003f45270ULL,
0x0000000f0200780cULL, 0x040fe40003f04070ULL, 0x000000030200780cULL, 0x040fe40003fa4070ULL,
0x000000010200780cULL, 0x000fc80003f84070ULL, 0x000000000008b919ULL, 0x000f220000008800ULL,
0x000004000005b802ULL, 0x000fe20000000f00ULL, 0xff317217ff09b424ULL, 0x000fc600078e00ffULL,
0x00000654080bb816ULL, 0x012fe20000000005ULL, 0x0000000400057824ULL, 0x004fc800078e025fULL,
0x000000040204b824ULL, 0x000fe200078e020bULL, 0x0000000000242947ULL, 0x008fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x018ad006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x018ad804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000402087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b5804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018400090400b388ULL, 0x0003e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b7804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x018b8806043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000000205057824ULL, 0x000fe200078e00ffULL, 0x0000000204067899ULL, 0x000fe2000800063fULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0x00000001050c7836ULL, 0x000fe20000000000ULL, 0x0000000405047848ULL, 0x002fe20007fe0000ULL,
0x0000000105087824ULL, 0x040fe200078e0203ULL, 0x000001f00e0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000612027c24ULL, 0x000fe2000f8e0213ULL, 0x0000040000067882ULL, 0x000fe20000000000ULL,
0x00000020050d7824ULL, 0x000fc400078e00ffULL, 0x0000000104097824ULL, 0x000fe400078e0a05ULL,
0x0000000405057c24ULL, 0x100fe4000f8e0202ULL, 0x000000040c0b7c24ULL, 0x040fe2000f8e0202ULL,
0xffffffe00d027812ULL, 0x000fe200078ee208ULL, 0x0000020005047825ULL, 0x100fe200078e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002000b067825ULL, 0x000fe200078e0006ULL,
0x000000ff0900720cULL, 0x040fe20003f03070ULL, 0x0000065405067896ULL, 0x004fe20008000006ULL,
0x000000010900780cULL, 0x000fe20003f23070ULL, 0x000000010c0d7824ULL, 0x040fe200078e0203ULL,
0x0000000f04087210ULL, 0x000fe20007f5e0ffULL, 0x000000200c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000f06067210ULL, 0x000fe20007f7e0ffULL, 0x00018ad006057890ULL, 0x000fc4000fffe03fULL,
0x00000006020f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0605ULL,
0xffffffe00c0d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff077224ULL, 0x000fe200018e0607ULL,
0x00008e00ff0a7b82ULL, 0x000e620000000a00ULL, 0x00000004125d7824ULL, 0x000fe200078e00ffULL,
0x000000060d117c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x000fe8000c101c4eULL, 0x0000000006117faeULL, 0x0005e2000c901c4eULL,
0x00009600ff0c7b82ULL, 0x000ee20000000a00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200405ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a85ULL,
0x000000045d047825ULL, 0x002fe200078e000aULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000000e04047981ULL, 0x000f22000c1e1900ULL, 0x000000045d067825ULL, 0x00cfcc00078e000cULL,
0x0000000e06067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fe40003f05270ULL,
0x00000000040d72caULL, 0x010fe400000e0000ULL, 0x00000008ff5c7819ULL, 0x004fd60000011606ULL,
0x0000003f0d077890ULL, 0x000fe4000fffe03fULL, 0x000000ff0d057890ULL, 0x000fe4000fffe03fULL,
0x000000063f077899ULL, 0x000fe40008011607ULL, 0x000000083f107899ULL, 0x000fe20008011605ULL,
0x0000015800ac8947ULL, 0x000ff60003800000ULL, 0x000000205f007824ULL, 0x040fe400078e0203ULL,
0x000000085f5b7824ULL, 0x000fc600078e00ffULL, 0x000000030000780cULL, 0x040fe40003f44070ULL,
0x0000001f0000780cULL, 0x000fd60003f04070ULL, 0x00009000ff09ab82ULL, 0x000e620000000800ULL,
0x000000041206a824ULL, 0x000fe200078e0200ULL, 0x0000000d00008c0cULL, 0x000fe4000bf26070ULL,
0x00000007ff00ac0cULL, 0x000fe2000bf65270ULL, 0x000000020606a824ULL, 0x000fe200078e00ffULL,
0x00000006000bac11ULL, 0x000fe4000f8e10ffULL, 0x00009400ff078b82ULL, 0x000eb00000000800ULL,
0x00008c00ff04ab82ULL, 0x000ef00000000a00ULL, 0x00009200ff028b82ULL, 0x000f220000000a00ULL,
0x000000090609a224ULL, 0x002fc400078e0209ULL, 0x00000004ff067424ULL, 0x000fe400078e00ffULL,
0x000000075d078224ULL, 0x004fe400078e0200ULL, 0x000000040904a825ULL, 0x008fe200078e0004ULL,
0x0000000600098c11ULL, 0x000fc6000f8e10ffULL, 0x0000000407028825ULL, 0x010fca00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000002098faeULL, 0x0003e2000c92184eULL,
0x018b58065bff79a7ULL, 0x0005e60008500006ULL, 0x18ac0000040bafaeULL, 0x0007e8000992184eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff067424ULL, 0x004fe200078e00ffULL,
0x000080000000791aULL, 0x000fca0000000000ULL, 0x018b8806ff0679a7ULL, 0x000ea40008500006ULL,
0x000000ffff087224ULL, 0x004fe200078e0007ULL, 0x0000000000027805ULL, 0x002fc60000015200ULL,
0x018b8808ff0075a7ULL, 0x000e640008000146ULL, 0x00000000005c0947ULL, 0x00afea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x018b8808ff0075a7ULL, 0x000e640008000146ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001ff0500788cULL, 0x000fe2000bf04070ULL,
0x0000840000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fc6000800063fULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000400540947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0x00008a00ff067b82ULL, 0x000ea20000000a00ULL,
0x0001400006057890ULL, 0x000fe2000fffe03fULL, 0x00000004ff087819ULL, 0x002fe20000011611ULL,
0x00000010110f7824ULL, 0x000fc800078e00ffULL, 0x000000015b047824ULL, 0x000fe200078e0208ULL,
0x000000f00f0f7812ULL, 0x000fc600078ec0ffULL, 0x00000040130b7824ULL, 0x000fe200078e0204ULL,
0x0000000604097c11ULL, 0x040fe2000f8e10ffULL, 0x0000000104057824ULL, 0x000fc800078e0211ULL,
0x018a000009007984ULL, 0x000e640000000800ULL, 0x00000006000a7c11ULL, 0x002fe4000f8e10ffULL,
0x0000000d5b007c48ULL, 0x000fc6000ffe0000ULL, 0x018ac0000a027984ULL, 0x0002e40000000800ULL,
0x0000000100007824ULL, 0x000fca00078e0a5bULL, 0x000000000800720cULL, 0x000fe20003f06070ULL,
0x00000010040a7824ULL, 0x002fe400078e00ffULL, 0x0000000402037c24ULL, 0x008fc8000f8e020bULL,
0x0000010003027825ULL, 0x004fc600078e0006ULL, 0x0000000f02047210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a027812ULL, 0x000fe200078ee205ULL, 0x000000020b0a7836ULL, 0x000fe40000000000ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x00000005020d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c101c4eULL,
0x018a080009027984ULL, 0x000ea40000000800ULL, 0x00000006020e7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000208027836ULL, 0x000fc80000000000ULL, 0x018ac0000e037984ULL, 0x000ea20000000800ULL,
0x000000000200720cULL, 0x000fe20003f06070ULL, 0x0000000403037c24ULL, 0x004fe4000f8e020aULL,
0x000000015b0a7824ULL, 0x000fe400078e0202ULL, 0x0000010003027825ULL, 0x000fc800078e0006ULL,
0x000000010a0c7824ULL, 0x040fe200078e0211ULL, 0x0000000f02047210ULL, 0x002fe20007f3e0ffULL,
0x000000100a057824ULL, 0x000fe400078e00ffULL, 0x000000040b0a7836ULL, 0x000fe40000000000ULL,
0x000000060b0b7836ULL, 0x000fe20000000000ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fc600008e0603ULL, 0x000000050c0d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c101c4eULL,
0x018a100009027984ULL, 0x000ea40000000800ULL, 0x00000006020e7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000408027836ULL, 0x000fe40000000000ULL, 0x0000000608087836ULL, 0x000fe40000000000ULL,
0x018ac0000e037984ULL, 0x000ea20000000800ULL, 0x000000000200720cULL, 0x000fe20003f06070ULL,
0x0000000403037c24ULL, 0x004fc4000f8e020aULL, 0x000000015b0a7824ULL, 0x000fe400078e0202ULL,
0x0000010003027825ULL, 0x000fc800078e0006ULL, 0x000000010a0c7824ULL, 0x040fe200078e0211ULL,
0x0000000f02047210ULL, 0x002fe20007f3e0ffULL, 0x000000100a057824ULL, 0x000fe400078e00ffULL,
0x000000015b0a7824ULL, 0x000fc600078e0208ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fc600008e0603ULL, 0x000000050c0d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000c101c4eULL,
0x000000000800720cULL, 0x000fe20003f06070ULL, 0x000000010a007824ULL, 0x040fe400078e0211ULL,
0x018a180009097984ULL, 0x000ea20000000800ULL, 0x000000100a057824ULL, 0x002fca00078e00ffULL,
0xfffffff005007812ULL, 0x000fc800078ee200ULL, 0x0000000500057c11ULL, 0x000fe4000f8e20ffULL,
0x00000006090c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000e640000000800ULL,
0x0000000402037c24ULL, 0x002fc8000f8e020bULL, 0x0000010003027825ULL, 0x000fc600078e0006ULL,
0x0000000f02027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c4eULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0x00008a00ff087b82ULL, 0x000ea20000000a00ULL, 0x0001400006057890ULL, 0x000fe2000fffe03fULL,
0x0000005b0f007211ULL, 0x042fe200078fe0ffULL, 0x000000100f047824ULL, 0x000fc600078e00ffULL,
0x00000006000a7c11ULL, 0x000fe2000f8e10ffULL, 0x00000040130b7824ULL, 0x000fe200078e0200ULL,
0x000000f004117812ULL, 0x000fe200078ec0ffULL, 0x0000000100057824ULL, 0x040fe400078e020fULL,
0x018a00000a027984ULL, 0x000e620000000800ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x0000000602067c11ULL, 0x002fca000f8e10ffULL, 0x018ac00006027984ULL, 0x0002e40000000800ULL,
0x0000000200067836ULL, 0x002fc80000000000ULL, 0x0000000106077824ULL, 0x040fe400078e020fULL,
0x00000010060e7824ULL, 0x000fe400078e00ffULL, 0x0000000402037c24ULL, 0x008fc8000f8e020bULL,
0x0000010003027825ULL, 0x004fc600078e0008ULL, 0x0000001102047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00c027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x00000005020d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000020b037836ULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000b901c4eULL,
0x018a08000a027984ULL, 0x000ea20000000800ULL, 0x0000000400047836ULL, 0x002fe40000000000ULL,
0x0000000600007836ULL, 0x000fe40000000000ULL, 0x0000000104057824ULL, 0x000fe200078e020fULL,
0x00000006020c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000e640000000800ULL,
0x0000000402037c24ULL, 0x002fc8000f8e0203ULL, 0x0000010003027825ULL, 0x000fc600078e0008ULL,
0x0000001102067210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00e027812ULL, 0x000fe200078ee207ULL,
0x00000010040e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200000e0603ULL,
0x00000005020d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000040b037836ULL, 0x000fe40000000000ULL,
0x000000060b0b7836ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000b901c4eULL, 0x018a10000a027984ULL, 0x000ea20000000800ULL,
0x0000000100067824ULL, 0x002fe200078e020fULL, 0x00000006020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000001102047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x0000000502077c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000b901c4eULL, 0x018a18000a0a7984ULL, 0x000ea40000000800ULL,
0x000000060a0c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000ea40000000800ULL,
0x0000000402037c24ULL, 0x004fc8000f8e020bULL, 0x0000010003027825ULL, 0x000fc800078e0008ULL,
0x0000001000097824ULL, 0x000fe200078e00ffULL, 0x0000001102027210ULL, 0x000fc80007f1e0ffULL,
0xfffffff009067812ULL, 0x000fe200078ee206ULL, 0x000000ffff037224ULL, 0x000fc600000e0603ULL,
0x0000000506057c11ULL, 0x002fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e4000b901c4eULL, 0x00000001ff027424ULL, 0x002fcc00078e00ffULL,
0x018b8802ff0279a7ULL, 0x000e640008500006ULL, 0x000000ffff067224ULL, 0x002fe200078e0003ULL,
0x0000000000027805ULL, 0x000fc60000015200ULL, 0x018b8806ff0075a7ULL, 0x000e640008000146ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x018b8806ff0075a7ULL, 0x000e640008000146ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000107919ULL, 0x000e620000000000ULL, 0x00018b7806097890ULL, 0x000fe2000fffe03fULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x000000205f007824ULL, 0x002fca00078e0210ULL, 0x0000001f0000780cULL, 0x000fda0003f04070ULL,
0x0000000000300947ULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x000e620000000a00ULL,
0x0000002000067836ULL, 0x000fe20000000000ULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x0000000600077c11ULL, 0x000fe2000f8e10ffULL, 0x000000045d057c24ULL, 0x000fe4000f8e0200ULL,
0x0000000d06007c0cULL, 0x000fe4000bf06070ULL, 0x0000002005057836ULL, 0x000fc80000000000ULL,
0x0000000405027825ULL, 0x002fce00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000002077faeULL, 0x0003e4000c12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000010ff007c0cULL, 0x000fe2000bf05270ULL,
0x018b7804ff0279a7ULL, 0x0026a20008500006ULL, 0x000000ffff5a7224ULL, 0x000fe200078e00ffULL,
0x0000000000587805ULL, 0x000fe4000001ff00ULL, 0x0000000000567805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x018b8804ff0479a7ULL, 0x008e620008500006ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x0000013c00ac8947ULL, 0x002fec0003800000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff717224ULL, 0x004fe200078e0003ULL, 0x0000000604087899ULL, 0x000fe2000800063fULL,
0x000000ffff187224ULL, 0x002fe200078e0005ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff5a7224ULL, 0x000fce00078e00ffULL, 0x00000008040a7899ULL, 0x000fc8000800063fULL,
0x0000000d0a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000013c006c0947ULL, 0x002fea0003800000ULL, 0x000000ffff6b7224ULL, 0x000fce00078e00ffULL,
0x000000045c007c0cULL, 0x000fe4000bf04070ULL, 0x00000002ff007819ULL, 0x000fe4000001166bULL,
0x000000036b027812ULL, 0x040fe400078ec0ffULL, 0x000000006b057207ULL, 0x000fe40000000000ULL,
0x000000ff02007207ULL, 0x000fe40004000000ULL, 0x0000000305027812ULL, 0x000fc400078ec0ffULL,
0x0000000405057c11ULL, 0x000fe4000f8ff0ffULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x018b7871ff0075a7ULL, 0x000e640008020146ULL, 0x00000000005c1947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f26270ULL,
0x0000000000449947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f3e1ffULL, 0x0000000117177824ULL, 0x000fe200008e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f26070ULL, 0x000000ff1700720cULL, 0x000fda0003f26310ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f26070ULL,
0x000000ff1700720cULL, 0x000fda0003f26310ULL, 0x00000000001c9947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fc800078310ffULL,
0x00000017ff177210ULL, 0x000fc80000ffe4ffULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x018b7871ff0075a7ULL, 0x000e640008020146ULL,
0xfffffffc00a89947ULL, 0x002fea000383ffffULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008020146ULL, 0x00000000005c1947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f26270ULL,
0x0000000000449947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f3e1ffULL, 0x0000000117177824ULL, 0x000fe200008e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f26070ULL, 0x000000ff1700720cULL, 0x000fda0003f26310ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f26070ULL,
0x000000ff1700720cULL, 0x000fda0003f26310ULL, 0x00000000001c9947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078310ffULL,
0x000000ffff177224ULL, 0x000fca00008e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008020146ULL,
0xfffffffc00a89947ULL, 0x002fea000383ffffULL, 0x0000000105147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bf26070ULL, 0x0000000400649947ULL, 0x000fea0003800000ULL,
0x00000004ff1e7819ULL, 0x000fe20000011610ULL, 0x0000000405167824ULL, 0x000fe200078e0202ULL,
0x00000020131b7811ULL, 0x000fe200078e30ffULL, 0x00000010101a7824ULL, 0x000fe200078e00ffULL,
0x00016000060a7890ULL, 0x000fe2000fffe03fULL, 0x000000015b197824ULL, 0x000fe200078e021eULL,
0x0000002016167811ULL, 0x000fe200078e30ffULL, 0x000000021e207836ULL, 0x000fe20000000000ULL,
0x000000f01a217812ULL, 0x000fe200078ec0ffULL, 0x00000001191c7824ULL, 0x040fe200078e0210ULL,
0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL, 0x000000015b227824ULL, 0x000fe200078e0220ULL,
0x0000000d16177c48ULL, 0x000fc6000ffe0000ULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000122237824ULL, 0x000fe400078e0210ULL, 0x0000000117167824ULL, 0x000fe400078e0a16ULL,
0x0000000119177824ULL, 0x040fe400078e021bULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0x000000165b167248ULL, 0x000fc80007fe0000ULL, 0xfffffff0191c7812ULL, 0x000fe200078ee21cULL,
0x00000001161a7824ULL, 0x000fc600078e0a5bULL, 0x0000000a1c1d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a1e00720cULL, 0x000fe40003f26070ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e680000000a00ULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe400010e0617ULL,
0x0000000122177824ULL, 0x040fe400078e021bULL, 0x0000001022227824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000c901c4eULL,
0x0000001a2000720cULL, 0x000fe20003f26070ULL, 0x000000041e207836ULL, 0x000fe40000000000ULL,
0x018a08001f167984ULL, 0x000ea20000000800ULL, 0x000000061e1e7836ULL, 0x000fe20000000000ULL,
0xfffffff0221d7812ULL, 0x002fe200078ee223ULL, 0x000000015b227824ULL, 0x000fc600078e0220ULL,
0x0000000a1d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000122237824ULL, 0x000fe200078e0210ULL,
0x00000006161c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001c167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe400010e0617ULL,
0x0000000122177824ULL, 0x040fe400078e021bULL, 0x0000001022227824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000c901c4eULL,
0x0000001a2000720cULL, 0x000fc60003f26070ULL, 0x018a10001f167984ULL, 0x000ea20000000800ULL,
0xfffffff022197812ULL, 0x002fc800078ee223ULL, 0x0000000a19197c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001c167984ULL, 0x0002a40000000800ULL,
0x000000015b1c7824ULL, 0x002fc800078e021eULL, 0x000000011c1b7824ULL, 0x040fe400078e021bULL,
0x000000011c1d7824ULL, 0x040fe400078e0210ULL, 0x000000101c1c7824ULL, 0x000fe400078e00ffULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e2000c901c4eULL,
0x0000001a1e00720cULL, 0x000fc60003f26070ULL, 0x018a18001f187984ULL, 0x000ea20000000800ULL,
0xfffffff01c177812ULL, 0x002fc800078ee21dULL, 0x0000000a17177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x00000008181b7c24ULL, 0x002fc8000f8e021bULL, 0x000001001b147825ULL, 0x000fc600078e0014ULL,
0x0000002114147210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c901c4eULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x0000005b101f7211ULL, 0x040fe200078fe0ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x00016000060a7890ULL, 0x000fe4000fffe03fULL, 0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000101f1a7824ULL, 0x000fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f177824ULL, 0x040fe400078e0220ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000011f197824ULL, 0x000fc400078e0210ULL, 0x000000021f1b7836ULL, 0x000fc60000000000ULL,
0xfffffff01a1d7812ULL, 0x000fe200078ee219ULL, 0x000000011b227824ULL, 0x000fc600078e0210ULL,
0x0000000a1d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116187210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe400008e0617ULL,
0x000000011b177824ULL, 0x040fe400078e0220ULL, 0x000000101b1b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e8000b901c4eULL,
0x018a08001e167984ULL, 0x000ea20000000800ULL, 0xfffffff01b197812ULL, 0x002fe200078ee222ULL,
0x000000041f1d7836ULL, 0x000fc40000000000ULL, 0x000000061f1f7836ULL, 0x000fe20000000000ULL,
0x0000000a19197c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001c167984ULL, 0x0002a40000000800ULL, 0x000000011d1c7824ULL, 0x002fe400078e0210ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x00000021161a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe400008e0617ULL,
0x000000011d177824ULL, 0x140fe400078e0220ULL, 0x000000101d1d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a197faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ea20000000800ULL, 0xfffffff01d197812ULL, 0x002fe200078ee21cULL,
0x000000011f1b7824ULL, 0x000fc400078e0220ULL, 0x000000011f1a7824ULL, 0x000fe200078e0210ULL,
0x0000000a19197c11ULL, 0x000fe2000f8e20ffULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000616187c11ULL, 0x004fca000f8e10ffULL, 0x018ac00018167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff177224ULL, 0x000fca00008e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea20000000800ULL, 0xfffffff01f177812ULL, 0x002fc800078ee21aULL,
0x0000000a17177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000008181b7c24ULL, 0x002fc8000f8e021bULL,
0x000001001b147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e6000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008020146ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f3e1ffULL,
0x0000000117177824ULL, 0x000fe200008e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f26070ULL,
0x000000ff1700720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f26070ULL, 0x000000ff1700720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078310ffULL, 0x000000ffff177224ULL, 0x000fca00008e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008020146ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x000000055c00720cULL, 0x080fe20003f44070ULL, 0x0000000100157836ULL, 0x000fe20000000000ULL,
0x000000030000780cULL, 0x000fe20003f85270ULL, 0x000000205f6e7824ULL, 0x000fe200078e0210ULL,
0x000000055c00720cULL, 0x000fe20003f64070ULL, 0x00018b80060a7890ULL, 0x000fe2000fffe03fULL,
0x0000000315147812ULL, 0x000fe200078ec0ffULL, 0x00000001ff6c7424ULL, 0x000fe200078e00ffULL,
0x0000001f6e00780cULL, 0x000fca0003f24070ULL, 0x00000002ff15a819ULL, 0x000fca0000011615ULL,
0x0000000102027824ULL, 0x000fc800078e0215ULL, 0x0000004002007824ULL, 0x040fe200078e00ffULL,
0x0000000502027211ULL, 0x000fc800078ff0ffULL, 0x000000c000057812ULL, 0x000fca00078ec0ffULL,
0x0000010002177824ULL, 0x000fe200078e0205ULL, 0x000000ff14027207ULL, 0x000fe20005000000ULL,
0x000000000050b947ULL, 0x000fec0002000000ULL, 0x000000205f197824ULL, 0x000fe200078e0210ULL,
0x0000000105057890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x000000031900780cULL, 0x000fda0003f44070ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff167b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412007824ULL, 0x000fe200078e0219ULL, 0x0000000619197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000200057824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000516007c36ULL, 0x002fc80008000000ULL,
0x0000001605057224ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe80003800000ULL,
0x0000000000341947ULL, 0x000fea0003800000ULL, 0x00009200ff147b82ULL, 0x002e620000000a00ULL,
0x000000015d007824ULL, 0x000fe200078e0202ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000016e027824ULL, 0x100fe400078e0217ULL, 0x0000000b00057c24ULL, 0x000fe2000f8e0217ULL,
0x000000066e177c11ULL, 0x000fe4000f8e10ffULL, 0x0000000d02007c0cULL, 0x000fe2000bf46070ULL,
0x000000016e057824ULL, 0x000fc800078e0205ULL, 0x0000000405147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014177faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff6b00720cULL, 0x000fe20003f45270ULL, 0x018b806cff6479a7ULL, 0x0004d80008500006ULL,
0x0000000400942947ULL, 0x004fea0003800000ULL, 0x018ad86c5b1479a7ULL, 0x002e640008500006ULL,
0x000000ffff027224ULL, 0x002fce00078e0015ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x018ad8025b0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff077224ULL, 0x000fce00078e00ffULL, 0x000000100700780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614057210ULL, 0x000fca0007f5e1ffULL, 0x0000000117167824ULL, 0x000fe200010e0e15ULL,
0x003d09000500780cULL, 0x000fc80003f46070ULL, 0x000000ff1600720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f46070ULL,
0x000000ff1600720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011416ULL, 0x0000000500007211ULL, 0x000fca00078510ffULL,
0x000000ffff057224ULL, 0x000fca00010e0616ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000107077836ULL, 0x000fce0000000000ULL, 0x018ad8025b0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001010007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe20000011610ULL, 0x00000001ff077424ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200078e0008ULL, 0x0000007000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c02057812ULL, 0x000fc800078ec0ffULL, 0x0000000605007c10ULL, 0x000fca000fffe000ULL,
0x0180000000057984ULL, 0x000e680000000800ULL, 0x0182000000147984ULL, 0x0004a20000000800ULL,
0x000000080500720bULL, 0x002fda0003f5d000ULL, 0x0000000000027806ULL, 0x000fc800010e0100ULL,
0x0000ffff02167812ULL, 0x000fda000784c0ffULL, 0x0000000000e8a947ULL, 0x00cfea0003800000ULL,
0x000000080500720bULL, 0x000fe40003f54000ULL, 0x000000ff5f00720cULL, 0x000fe40003f65270ULL,
0x0000000508157209ULL, 0x000fd20007810000ULL, 0x0000000000177806ULL, 0x000fe400010e0100ULL,
0x018400150000b388ULL, 0x0003e40000000800ULL, 0x0000991017027816ULL, 0x000fc800000000ffULL,
0x000000ff0200720cULL, 0x000fda0003f45270ULL, 0x0000000000b0a947ULL, 0x002fea0003800000ULL,
0x8000001508007221ULL, 0x000fe20000010000ULL, 0x000000ff17ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0017ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000197308ULL, 0x0002ac0000000800ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc0000011610ULL, 0x00001f0019007589ULL, 0x004e6400000e0000ULL,
0x000000000b0b7220ULL, 0x082fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x0000000042427220ULL, 0x080fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000046467220ULL, 0x080fe20000410000ULL,
0x0000000049497220ULL, 0x080fe20000410000ULL, 0x000000004a4a7220ULL, 0x080fe20000410000ULL,
0x000000004d4d7220ULL, 0x080fe20000410000ULL, 0x000000004e4e7220ULL, 0x080fe20000410000ULL,
0x0000000051517220ULL, 0x080fe20000410000ULL, 0x0000000052527220ULL, 0x080fe20000410000ULL,
0x0000000057577220ULL, 0x080fe20000410000ULL, 0x0000000058587220ULL, 0x000fce0000410000ULL,
0x0000001909097220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000000810007811ULL, 0x002fcc00078ff0ffULL, 0x00001f0019007589ULL, 0x000e6400000e0000ULL,
0x000000000d0d7220ULL, 0x082fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000043437220ULL, 0x080fe20000410000ULL, 0x0000000044447220ULL, 0x080fe20000410000ULL,
0x0000000047477220ULL, 0x080fe20000410000ULL, 0x0000000048487220ULL, 0x080fe20000410000ULL,
0x000000004b4b7220ULL, 0x080fe20000410000ULL, 0x000000004c4c7220ULL, 0x080fe20000410000ULL,
0x000000004f4f7220ULL, 0x080fe20000410000ULL, 0x0000000050507220ULL, 0x080fe20000410000ULL,
0x0000000053537220ULL, 0x080fe20000410000ULL, 0x0000000056567220ULL, 0x080fe20000410000ULL,
0x0000000059597220ULL, 0x080fe20000410000ULL, 0x000000005a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fda0007846017ULL, 0x8000001505052221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b05052820ULL, 0x000fc80000410000ULL,
0x0000000500062308ULL, 0x000ea40000000800ULL, 0x0000000614142220ULL, 0x004fce0000410000ULL,
0x0000000914097221ULL, 0x000fe20000010000ULL, 0x000000ffff087224ULL, 0x000fce00078e0015ULL,
0x0000000710057812ULL, 0x040fe400078ec0ffULL, 0x000000ff07ff7812ULL, 0x000fe4000786c0ffULL,
0x00000004ff667819ULL, 0x000fe40000011610ULL, 0x00000008056a7812ULL, 0x000fe400078ef810ULL,
0x00000008106d7812ULL, 0x000fe200078ec0ffULL, 0x000000045f707824ULL, 0x000fe400078e0266ULL,
0x0000000166677824ULL, 0x000fe200078e026aULL, 0x000000076d6d7812ULL, 0x000fe200078ef810ULL,
0x000000086a007824ULL, 0x002fc600078e00ffULL, 0x000000046d177819ULL, 0x040fe200000006ffULL,
0x000000016d027824ULL, 0x000fe200078e0270ULL, 0xfffffff800057812ULL, 0x000fc800078ee267ULL,
0x0000000605057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000183947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011610ULL, 0x00000006ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000007816ULL, 0x000fca0000000000ULL,
0x00001f0300037589ULL, 0x0002a800000e0000ULL, 0x00001f1500047589ULL, 0x0002e400000e0000ULL,
0x01200000052c783bULL, 0x0002e20000000200ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x08cfe40000000000ULL, 0x000000032e2e7232ULL, 0x000fe40000000000ULL,
0x000000042d2d7232ULL, 0x080fe40000000000ULL, 0x000000042f2f7232ULL, 0x000fce0000000000ULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0xfffffff017027812ULL, 0x000fe200078ee202ULL,
0x000000106d197824ULL, 0x000fe200078e00ffULL, 0x000000025f397811ULL, 0x000fc600078e10ffULL,
0x0000000b02027c11ULL, 0x000fe4000f8e20ffULL, 0x0000000166647824ULL, 0x008fc600078e0239ULL,
0x000000000214783bULL, 0x002e620000004200ULL, 0x000000016d007824ULL, 0x000fca00078e0264ULL,
0xfffffff019007812ULL, 0x000fc800078ee200ULL, 0x0000000b00007c11ULL, 0x000fca000f8e20ffULL,
0x00000000001c783bULL, 0x000ee20000004200ULL, 0x00000018ff197819ULL, 0x002fe20000011414ULL,
0x00000100141a7824ULL, 0x040fe200078e00ffULL, 0x00008880143c7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00008880153d7816ULL, 0x040fe200000000ffULL,
0x00000100151b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x0000010017237824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000001900197306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fe2000001141bULL,
0x00000100161b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fc40000011417ULL,
0x0000888017327816ULL, 0x040fe200000000ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011423ULL, 0x0000001400147306ULL, 0x000e620000200c00ULL,
0x00000018ff217819ULL, 0x000fe40000011416ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff187819ULL, 0x000fe20000011415ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x000088801c237816ULL, 0x008fe200000000ffULL, 0x0000001a00357306ULL, 0x0007e20000200c00ULL,
0x00000018ff247819ULL, 0x000fc4000001141cULL, 0x00000018ff257819ULL, 0x000fe4000001141dULL,
0x000088801d347816ULL, 0x000fe400000000ffULL, 0x0000541014147816ULL, 0x002fe20000000019ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00008880161a7816ULL, 0x048fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe2000001141eULL,
0x000001001f197824ULL, 0x000fe200078e00ffULL, 0x000088801e287816ULL, 0x000fc400000000ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000003600367306ULL, 0x000e620000200c00ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x00000018ff317819ULL, 0x000fc6000001141fULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x000054103d3d7816ULL, 0x002fce0000000036ULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x00000018ff367819ULL, 0x000fce0000011419ULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x0000541032197816ULL, 0x002fce0000000037ULL, 0x00000017002b7306ULL, 0x0003e20000200c00ULL,
0x000100001f327824ULL, 0x000fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000001600227306ULL, 0x0009e20000200c00ULL, 0x000001001d177824ULL, 0x042fe200078e00ffULL,
0x000054103c3c7816ULL, 0x008fe20000000035ULL, 0x000100001d1d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x000001001c167824ULL, 0x050fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x0000003c2c3c723cULL, 0x000fe400000018ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000017003b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fce000001141cULL, 0x00000016002a7306ULL, 0x0007e20000200c00ULL,
0x000088801f177816ULL, 0x002fca00000000ffULL, 0x000000ffff357224ULL, 0x000fe400078e0017ULL,
0x0000002300237306ULL, 0x000fe20000200c00ULL, 0x000001001e167824ULL, 0x048fe400078e00ffULL,
0x000100001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000001800187306ULL, 0x000ff00000200c00ULL,
0x0000002100217306ULL, 0x000ff00000200c00ULL, 0x0000001500157306ULL, 0x000e700000200c00ULL,
0x0000002800287306ULL, 0x000fe20000200c00ULL, 0x0000541015157816ULL, 0x002fce0000000018ULL,
0x0000001600297306ULL, 0x0002f00000200c00ULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x000000142c14723cULL, 0x002fe200000018ffULL, 0x0000541028287816ULL, 0x008fcc0000000029ULL,
0x0000002500257306ULL, 0x000ff00000200c00ULL, 0x0000001a001a7306ULL, 0x000ff00000200c00ULL,
0x0000001b001b7306ULL, 0x000e700000200c00ULL, 0x0000001c00277306ULL, 0x0007220000200c00ULL,
0x000054101a187816ULL, 0x002fce000000001bULL, 0x0000003400347306ULL, 0x000e620000200c00ULL,
0x00005410221c7816ULL, 0x008fe20000000021ULL, 0x000000182c18723cULL, 0x000fe200000018ffULL,
0x0000541027247816ULL, 0x010fca0000000024ULL, 0x0000001d00267306ULL, 0x0007220000200c00ULL,
0x0000541034217816ULL, 0x002fce000000003bULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x000054102b1d7816ULL, 0x008fe20000000020ULL, 0x000000086a2b7824ULL, 0x000fe200078e00ffULL,
0x0000541023207816ULL, 0x000fe2000000002aULL, 0x00000002672a7836ULL, 0x000fe20000000000ULL,
0x000000106d3b7812ULL, 0x000fe400078efcffULL, 0x0000541026257816ULL, 0x010fe20000000025ULL,
0x0000003600367306ULL, 0x000e620000200c00ULL, 0xfffffff82b5e7812ULL, 0x000fe200078ee22aULL,
0x000000202c20723cULL, 0x000fe200000018ffULL, 0x0000000170697824ULL, 0x000fc400078e023bULL,
0x000000065e5e7c11ULL, 0x000fe2000f8e20ffULL, 0x000000103b347824ULL, 0x000fe400078e00ffULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x000000242c24723cULL, 0x000fe400000018ffULL,
0xfffffff034697812ULL, 0x000fe400078ee269ULL, 0x0000541035297816ULL, 0x002fc60000000036ULL,
0x0000003100317306ULL, 0x000fe80000200c00ULL, 0x000000282c28723cULL, 0x000fe800000018ffULL,
0x0000001e00337306ULL, 0x0002f00000200c00ULL, 0x0000003200327306ULL, 0x000f220000200c00ULL,
0x0000001c2c1c723cULL, 0x002fe200000018ffULL, 0x0000541033307816ULL, 0x008fc40000000030ULL,
0x0000541032317816ULL, 0x010fce0000000031ULL, 0x000000302c2c723cULL, 0x000fe200000018ffULL,
0x012000005e30783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000103947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000431317232ULL, 0x080fe40000000000ULL,
0x0000000433337232ULL, 0x000fce0000000000ULL, 0x0000000b69617c11ULL, 0x000fe2000f8e20ffULL,
0x000008a000007945ULL, 0x000fe20003800000ULL, 0x000000393b687210ULL, 0x040fe20007ffe066ULL,
0x000000103b3b7824ULL, 0x000fe200078e00ffULL, 0x000000045c007c0cULL, 0x040fe2000bfc3070ULL,
0x000000006134783bULL, 0x000f220000004200ULL, 0x000000045c007c0cULL, 0x000fe4000bf43070ULL,
0xfffffff03b687812ULL, 0x000fc800078ee268ULL, 0x0000000b68607c11ULL, 0x000fca000f8e20ffULL,
0x000000006038783bULL, 0x000f620000004200ULL, 0x00000018ff737819ULL, 0x010fe20000011434ULL,
0x0000010034557824ULL, 0x040fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011435ULL,
0x0000010035627824ULL, 0x040fe200078e00ffULL, 0x0000888034547816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888035747816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff757819ULL, 0x000fe20000011462ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x000fe40000011436ULL,
0x00000018ff637819ULL, 0x000fe40000011437ULL, 0x00000018ff627819ULL, 0x022fc40000011439ULL,
0x00000018ff6f7819ULL, 0x000fe20000011438ULL, 0x0000003400347306ULL, 0x000e700000200c00ULL,
0x0000003500357306ULL, 0x000f220000200c00ULL, 0x0000541034347816ULL, 0x002fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000e640000200c00ULL,
0x000000343014723cULL, 0x008fec0000001814ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000010037347824ULL, 0x040fe200078e00ffULL, 0x0000888037357816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fca00078e00ffULL, 0x0000007500757306ULL, 0x000ee20000200c00ULL,
0x0000541054547816ULL, 0x002fe40000000055ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff787819ULL, 0x000fe40000011437ULL, 0x0000888038377816ULL, 0x000fe200000000ffULL,
0x0000007300727306ULL, 0x000fe20000200c00ULL, 0x0000541074557816ULL, 0x008fe20000000075ULL,
0x0000010036747824ULL, 0x000fcc00078e00ffULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe6000000183cULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000007400757306ULL, 0x0002e40000200c00ULL, 0x00000018ff547819ULL, 0x000fc4000001143bULL,
0x00000018ff557819ULL, 0x000fc8000001143aULL, 0x0000003400767306ULL, 0x0007220000200c00ULL,
0x0000888039747816ULL, 0x002fce00000000ffULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541072347816ULL, 0x008fe20000000075ULL, 0x0000010038727824ULL, 0x040fe400078e00ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x0000541035357816ULL, 0x010fc60000000076ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000018ff767819ULL, 0x000fe40000011472ULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000000343018723cULL, 0x000fe80000001818ULL,
0x0000003600367306ULL, 0x000fe60000200c00ULL, 0x0000010039347824ULL, 0x000fc400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000003400757306ULL, 0x0007e20000200c00ULL, 0x0000541078357816ULL, 0x002fce0000000063ULL,
0x0000003700377306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x008fe20000000071ULL,
0x000001003a637824ULL, 0x040fe200078e00ffULL, 0x000088803a367816ULL, 0x000fe400000000ffULL,
0x000088803b717816ULL, 0x040fe400000000ffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x00000034301c723cULL, 0x000fe2000000181cULL, 0x0000007600767306ULL, 0x000fec0000200c00ULL,
0x000001003b347824ULL, 0x000fc400078e00ffULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x000100003b3b7824ULL, 0x000fe400078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011434ULL,
0x000100003a347824ULL, 0x000fe400078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x000fce0000011434ULL,
0x0000006200627306ULL, 0x000ff00000200c00ULL, 0x0000003800727306ULL, 0x000ef00000200c00ULL,
0x0000003900397306ULL, 0x000f300000200c00ULL, 0x00000035003a7306ULL, 0x0003f00000200c00ULL,
0x0000003400387306ULL, 0x000be20000200c00ULL, 0x0000541074357816ULL, 0x002fce0000000075ULL,
0x0000003600367306ULL, 0x000fe20000200c00ULL, 0x0000541037347816ULL, 0x024fe20000000076ULL,
0x000000016b377836ULL, 0x000fcc0000000000ULL, 0x0000006300737306ULL, 0x0002a20000200c00ULL,
0x000000343020723cULL, 0x000fee0000001820ULL, 0x0000007100717306ULL, 0x000f620000200c00ULL,
0x0000541072347816ULL, 0x008fe4000000006fULL, 0x0000541039357816ULL, 0x010fc40000000062ULL,
0x00000002ff637819ULL, 0x002fc60000011610ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x0000006b6300720cULL, 0x040fe20003f86070ULL, 0x000000343024723cULL, 0x000fe20000001824ULL,
0x0000000863627836ULL, 0x000fe40000000000ULL, 0x000000376300720cULL, 0x000fc60006786470ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x004fe40000000073ULL,
0x0000541071357816ULL, 0x020fe4000000003aULL, 0x0000006b6200720cULL, 0x000fc60003fa6070ULL,
0x0000003b003b7306ULL, 0x000ea20000200c00ULL, 0x000000376200720cULL, 0x000fe20006fa6470ULL,
0x000000343028723cULL, 0x000fee0000001828ULL, 0x0000541038347816ULL, 0x002fe40000000055ULL,
0x000054103b357816ULL, 0x004fce0000000054ULL, 0x00000034302c723cULL, 0x000fe2000000182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000404947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0a0a7221ULL, 0x000fe20000010000ULL,
0x000000140f0f7221ULL, 0x000fe20000010000ULL, 0x000000150e0e7221ULL, 0x000fe20000010000ULL,
0x0000001841417221ULL, 0x000fe20000010000ULL, 0x0000001942427221ULL, 0x000fe20000010000ULL,
0x0000001c45457221ULL, 0x000fe20000010000ULL, 0x0000001d46467221ULL, 0x000fe20000010000ULL,
0x0000002049497221ULL, 0x000fe20000010000ULL, 0x000000214a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002851517221ULL, 0x000fe20000010000ULL, 0x0000002952527221ULL, 0x000fe20000010000ULL,
0x0000002c57577221ULL, 0x000fe20000010000ULL, 0x0000002d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000405947ULL, 0x000fea0001000000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0c0c7221ULL, 0x000fe20000010000ULL, 0x0000001611117221ULL, 0x000fe20000010000ULL,
0x0000001740407221ULL, 0x000fe20000010000ULL, 0x0000001a43437221ULL, 0x000fe20000010000ULL,
0x0000001b44447221ULL, 0x000fe20000010000ULL, 0x0000001e47477221ULL, 0x000fe20000010000ULL,
0x0000001f48487221ULL, 0x000fe20000010000ULL, 0x000000224b4b7221ULL, 0x000fe20000010000ULL,
0x000000234c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002a53537221ULL, 0x000fe20000010000ULL,
0x0000002b56567221ULL, 0x000fe20000010000ULL, 0x0000002e59597221ULL, 0x000fe20000010000ULL,
0x0000002f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b886cff1479a7ULL, 0x000e620008500006ULL, 0x000000045c007c0cULL, 0x040fe4000bf43070ULL,
0x00000003371a7812ULL, 0x000fe400078ec0ffULL, 0x000000045c007c0cULL, 0x000fe4000bfc3070ULL,
0x00000004ff347803ULL, 0x000fe40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000002ff147819ULL, 0x002fe20000011637ULL, 0x000000ffff187224ULL, 0x000fc600078e0015ULL,
0x0000001437147207ULL, 0x000fc80000000000ULL, 0x00000003141b7812ULL, 0x040fe400078ec0ffULL,
0x00000004141c7c11ULL, 0x000fe4000f8ff0ffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b8065ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8065ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011c147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x00000004005ca947ULL, 0x000fea0003800000ULL,
0x000000015b1d7824ULL, 0x000fe200078e0266ULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010187824ULL, 0x000fe400078e00ffULL, 0x0000004013217824ULL, 0x000fe200078e021dULL,
0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101d1e7824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x000000041c187824ULL, 0x000fe400078e021bULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x0000000266207836ULL, 0x000fc40000000000ULL,
0x0000004018187824ULL, 0x000fe400078e00ffULL, 0x000000015b277824ULL, 0x000fe200078e0220ULL,
0x0000000614197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0004e40000000800ULL, 0x0000000d18197c48ULL, 0x004fca000ffe0000ULL,
0x0000000119187824ULL, 0x000fe400078e0a18ULL, 0x000000011d197824ULL, 0x000fc600078e0210ULL,
0x000000185b187248ULL, 0x000fe40007fe0000ULL, 0xfffffff01e197812ULL, 0x000fc600078ee219ULL,
0x00000001181d7824ULL, 0x000fe200078e0a5bULL, 0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000221197836ULL, 0x000fe40000000000ULL, 0x0000000816177c24ULL, 0x008fc8000f8e0221ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000001d6600720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000d101c4eULL,
0x018a08001f187984ULL, 0x000ea20000000800ULL, 0x0000000127167824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000421177836ULL, 0x000fc60000000000ULL,
0xfffffff027167812ULL, 0x000fc800078ee216ULL, 0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000001d2000720cULL, 0x000fe20003f46070ULL, 0x0000000466207836ULL, 0x000fe40000000000ULL,
0x0000000666667836ULL, 0x000fe40000000000ULL, 0x000000015b277824ULL, 0x000fd000078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000d101c4eULL,
0x018a10001f167984ULL, 0x000ea20000000800ULL, 0x0000000127187824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000621197836ULL, 0x000fc60000000000ULL,
0xfffffff027187812ULL, 0x000fc800078ee218ULL, 0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000001d2000720cULL, 0x000fda0003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000d101c4eULL, 0x018a18001f187984ULL, 0x000ea40000000800ULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000015b197824ULL, 0x000fe200078e0266ULL, 0x0000002314147210ULL, 0x000fc60007f5e0ffULL,
0x0000000119167824ULL, 0x042fe400078e0210ULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x0000001d6600720cULL, 0x000fe20003f46070ULL, 0x0000001019197824ULL, 0x000fca00078e00ffULL,
0xfffffff019167812ULL, 0x000fc800078ee216ULL, 0x0000000b16177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4eULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015b667824ULL, 0x000fe200078e0266ULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010197824ULL, 0x000fe400078e00ffULL,
0x0000004013237824ULL, 0x000fe200078e0266ULL, 0x0000000666217c11ULL, 0x040fe2000f8e10ffULL,
0x00000010661e7824ULL, 0x040fe200078e00ffULL, 0x000000f019257812ULL, 0x000fe200078ec0ffULL,
0x0000000166197824ULL, 0x000fe400078e0210ULL, 0x018a000021147984ULL, 0x000e620000000800ULL,
0x00000002661d7836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x000000011d1e7824ULL, 0x000fe400078e0210ULL, 0x0000000b19277c11ULL, 0x000fe2000f8e20ffULL,
0x0000000223197836ULL, 0x000fe40000000000ULL, 0x000000101d1d7824ULL, 0x000fca00078e00ffULL,
0xfffffff01d1e7812ULL, 0x000fc800078ee21eULL, 0x0000000b1e1d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000816177c24ULL, 0x004fc8000f8e0223ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002516167210ULL, 0x000fc80007f5e0ffULL,
0x00000017ff177210ULL, 0x000fca00017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016277faeULL, 0x0003e8000b901c4eULL, 0x018a080021187984ULL, 0x000ea20000000800ULL,
0x0000000423177836ULL, 0x002fe20000000000ULL, 0x00000006181f7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001f187984ULL, 0x0002a40000000800ULL, 0x00000004661f7836ULL, 0x002fc80000000000ULL,
0x000000011f1e7824ULL, 0x040fe400078e0210ULL, 0x000000101f1f7824ULL, 0x000fca00078e00ffULL,
0xfffffff01f1e7812ULL, 0x000fe200078ee21eULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181d7faeULL, 0x0003e8000b901c4eULL, 0x018a100021167984ULL, 0x000ea20000000800ULL,
0x0000000b1e197c11ULL, 0x002fe2000f8e20ffULL, 0x00000006231d7836ULL, 0x000fe20000000000ULL,
0x0000000616207c11ULL, 0x004fca000f8e10ffULL, 0x018ac00020167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002516167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4eULL,
0x018a180021187984ULL, 0x000ea40000000800ULL, 0x00000006181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000ea40000000800ULL, 0x00000008181d7c24ULL, 0x004fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x00000006661d7836ULL, 0x000fe20000000000ULL,
0x0000002514147210ULL, 0x000fc60007f5e0ffULL, 0x000000011d187824ULL, 0x040fe400078e0210ULL,
0x000000101d1d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fc600010e0615ULL,
0xfffffff01d187812ULL, 0x000fc800078ee218ULL, 0x0000000b18177c11ULL, 0x002fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000467147836ULL, 0x000fe20000000000ULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x000000086a157824ULL, 0x000fe400078e00ffULL,
0x000000016d707824ULL, 0x000fc600078e0270ULL, 0xfffffff815667812ULL, 0x000fe200078ee214ULL,
0x0000000000581947ULL, 0x000fec0003800000ULL, 0x0000001c5c00720cULL, 0x000fe20003f44070ULL,
0x00009400000b7ab9ULL, 0x000fe20000000800ULL, 0x000000066e197c11ULL, 0x000fe4000f8e10ffULL,
0x000000ff1a147207ULL, 0x040fe40001000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60005000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x000000015d177824ULL, 0x000fe400078e021aULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016167836ULL, 0x000fc80000000000ULL,
0x0000000b17177c24ULL, 0x100fe4000f8e0216ULL, 0x000000016e167824ULL, 0x040fe400078e0216ULL,
0x000000016e177824ULL, 0x000fc600078e0217ULL, 0x0000000d16007c0cULL, 0x000fe2000bf46070ULL,
0x0000000417147825ULL, 0x002fd800078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000d12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff6e7424ULL, 0x000fe200078e00ffULL,
0x0000000666667c11ULL, 0x000fe2000f8e20ffULL, 0x000000106d657824ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x018b786eff6e79a7ULL, 0x000e620008500006ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000000ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6314037589ULL, 0x0004e800000e0000ULL, 0x00001f6214047589ULL, 0x00046400000e0000ULL,
0x01200000662c783bULL, 0x0004e20000000200ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x088fe40000000000ULL, 0x000000032e2e7232ULL, 0x000fe40000000000ULL,
0x000000042d2d7232ULL, 0x082fe40000000000ULL, 0x000000042f2f7232ULL, 0x000fce0000000000ULL,
0x00016000060b7890ULL, 0x000fe2000fffe03fULL, 0xfffffff065657812ULL, 0x000fe200078ee270ULL,
0x000000016d647824ULL, 0x040fe400078e0264ULL, 0x000000106d6d7824ULL, 0x000fe400078e00ffULL,
0x0000000b65657c11ULL, 0x000fe2000f8e20ffULL, 0x0000000667677836ULL, 0x000fe40000000000ULL,
0xfffffff06d647812ULL, 0x000fe200078ee264ULL, 0x000000086a6a7824ULL, 0x000fe200078e00ffULL,
0x000000006514783bULL, 0x004ea40000004200ULL, 0x0000000b64647c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff86a677812ULL, 0x000fc600078ee267ULL, 0x000000006418783bULL, 0x000f220000004200ULL,
0x0000000667677c11ULL, 0x000fe4000f8e20ffULL, 0x00000018ff1e7819ULL, 0x004fe20000011414ULL,
0x0000010014207824ULL, 0x040fe200078e00ffULL, 0x00008880143c7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe40000011415ULL,
0x00008880153d7816ULL, 0x040fe200000000ffULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff377819ULL, 0x000fe20000011414ULL, 0x0000010015147824ULL, 0x040fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc40000011416ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000002000297306ULL, 0x0005e20000200c00ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00008880162a7816ULL, 0x040fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe40000011417ULL,
0x0000888017387816ULL, 0x000fe200000000ffULL, 0x0000001500367306ULL, 0x000be20000200c00ULL,
0x0000010016207824ULL, 0x044fe200078e00ffULL, 0x00000018ff247819ULL, 0x010fe20000011418ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fc40000011419ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000010017157824ULL, 0x068fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000888019217816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001400147306ULL, 0x000ea20000200c00ULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x00000018ff307819ULL, 0x000fe4000001141aULL,
0x000088801a287816ULL, 0x000fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe2000001141bULL,
0x0000003700377306ULL, 0x000ee20000200c00ULL, 0x000054103d3d7816ULL, 0x004fce0000000014ULL,
0x0000003c003c7306ULL, 0x000ea20000200c00ULL, 0x0000541037147816ULL, 0x008fce000000001eULL,
0x0000002000397306ULL, 0x0007e20000200c00ULL, 0x000100001b1e7824ULL, 0x000fe200078e00ffULL,
0x000054103c3c7816ULL, 0x004fcc0000000029ULL, 0x0000001600357306ULL, 0x0005e20000200c00ULL,
0x0000888018207816ULL, 0x048fe200000000ffULL, 0x0000003c2c3c723cULL, 0x000fec00000018ffULL,
0x00000015003b7306ULL, 0x0007e20000200c00ULL, 0x0000010018167824ULL, 0x044fe400078e00ffULL,
0x0001000018187824ULL, 0x000fc600078e00ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000002a002a7306ULL, 0x000fe20000200c00ULL, 0x0000010019157824ULL, 0x048fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0001000019197824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff197819ULL, 0x000fce0000011419ULL, 0x0000001d001d7306ULL, 0x000ff00000200c00ULL,
0x0000001700327306ULL, 0x000eb00000200c00ULL, 0x0000001600237306ULL, 0x0007e20000200c00ULL,
0x00005410321d7816ULL, 0x004fce000000001dULL, 0x0000001800277306ULL, 0x0005e20000200c00ULL,
0x000001001a167824ULL, 0x048fe400078e00ffULL, 0x000100001a1a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000001500227306ULL, 0x0007e20000200c00ULL,
0x000088801b187816ULL, 0x004fe400000000ffULL, 0x00000018ff1a7819ULL, 0x000fca000001141aULL,
0x0000001800297306ULL, 0x0005e20000200c00ULL, 0x000001001b157824ULL, 0x008fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011415ULL, 0x0000541036157816ULL, 0x000fe2000000001fULL,
0x0000001c001c7306ULL, 0x000ee20000200c00ULL, 0x000054102a187816ULL, 0x004fe40000000039ULL,
0x00000018ff2a7819ULL, 0x000fca000001141eULL, 0x0000002400247306ULL, 0x000ea20000200c00ULL,
0x00005410351c7816ULL, 0x008fce000000001cULL, 0x0000002500257306ULL, 0x000fe20000200c00ULL,
0x0000001c2c1c723cULL, 0x000fe200000018ffULL, 0x0000541027247816ULL, 0x004fcc0000000024ULL,
0x0000003800387306ULL, 0x000ff00000200c00ULL, 0x0000002000207306ULL, 0x000eb00000200c00ULL,
0x0000002100217306ULL, 0x000ee20000200c00ULL, 0x0000541020207816ULL, 0x004fce0000000023ULL,
0x0000001900267306ULL, 0x0005220000200c00ULL, 0x0000541021217816ULL, 0x008fce0000000022ULL,
0x0000002800287306ULL, 0x000fe20000200c00ULL, 0x0000541038197816ULL, 0x004fe2000000003bULL,
0x000000202c20723cULL, 0x000fe200000018ffULL, 0x0000541026257816ULL, 0x010fca0000000025ULL,
0x00000016002b7306ULL, 0x0004e40000200c00ULL, 0x000000242c24723cULL, 0x000fec00000018ffULL,
0x0000003700367306ULL, 0x000f220000200c00ULL, 0x000000142c14723cULL, 0x004fe200000018ffULL,
0x0000541028287816ULL, 0x008fcc000000002bULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x0000541029297816ULL, 0x010fce0000000036ULL, 0x0000003100317306ULL, 0x000ff00000200c00ULL,
0x0000001a00337306ULL, 0x0004f00000200c00ULL, 0x0000002a00327306ULL, 0x0009620000200c00ULL,
0x000000182c18723cULL, 0x004fe200000018ffULL, 0x0000541033307816ULL, 0x008fca0000000030ULL,
0x000000282c28723cULL, 0x010fe200000018ffULL, 0x0000541032317816ULL, 0x022fce0000000031ULL,
0x000000302c2c723cULL, 0x000fe200000018ffULL, 0x012000006730783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000103947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000431317232ULL, 0x080fe40000000000ULL, 0x0000000433337232ULL, 0x000fce0000000000ULL,
0x0000000b69697c11ULL, 0x000fe2000f8e20ffULL, 0x0000080000007945ULL, 0x000fe20003800000ULL,
0x000000ff3400720cULL, 0x000fe40003f45270ULL, 0x0000000b68687c11ULL, 0x000fe2000f8e20ffULL,
0x000000006934783bULL, 0x000ee80000004200ULL, 0x000000006838783bULL, 0x000f220000004200ULL,
0x00000018ff737819ULL, 0x008fe20000011434ULL, 0x0000010034557824ULL, 0x040fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011435ULL, 0x00000100356c7824ULL, 0x040fe200078e00ffULL,
0x0000888034547816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00008880356a7816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff747819ULL, 0x000fe4000001146cULL, 0x00000018ff717819ULL, 0x000fe20000011436ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011437ULL,
0x00000018ff6d7819ULL, 0x010fe40000011438ULL, 0x00000018ff6c7819ULL, 0x000fc60000011439ULL,
0x0000003400347306ULL, 0x000ef00000200c00ULL, 0x0000003500357306ULL, 0x000f220000200c00ULL,
0x0000541034347816ULL, 0x008fce0000000073ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000010036737824ULL, 0x000fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x0000541035357816ULL, 0x010fce0000000072ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000000343014723cULL, 0x004fe20000001814ULL,
0x0000541054547816ULL, 0x008fcc0000000055ULL, 0x0000007400757306ULL, 0x0004e20000200c00ULL,
0x0000010037347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000007300727306ULL, 0x0009e20000200c00ULL, 0x0000888037747816ULL, 0x044fe200000000ffULL,
0x0001000037377824ULL, 0x000fc800078e00ffULL, 0x000000ffff357224ULL, 0x000fe200078e0074ULL,
0x000054106a557816ULL, 0x008fe20000000075ULL, 0x0000003400747306ULL, 0x000fe20000200c00ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000888038737816ULL, 0x010fe400000000ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001143aULL, 0x00000054303c723cULL, 0x000fe4000000183cULL,
0x0000003500357306ULL, 0x000eaa0000200c00ULL, 0x0000888036557816ULL, 0x040fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe2000001143bULL,
0x0000007100717306ULL, 0x000fe60000200c00ULL, 0x00000018ff367819ULL, 0x000fc40000011436ULL,
0x0000541035357816ULL, 0x004fc60000000074ULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x0000888039747816ULL, 0x000fce00000000ffULL, 0x0000003600367306ULL, 0x000ee20000200c00ULL,
0x0000541055347816ULL, 0x004fce0000000072ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000010038557824ULL, 0x040fe400078e00ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x000000343018723cULL, 0x000fe40000001818ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000003700377306ULL, 0x000ea20000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000010039347824ULL, 0x040fe200078e00ffULL, 0x000088803a357816ULL, 0x000fe200000000ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x0000007300727306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000003400757306ULL, 0x0007f00000200c00ULL, 0x0000005500557306ULL, 0x000f220000200c00ULL,
0x0000541036347816ULL, 0x008fe20000000071ULL, 0x000001003a717824ULL, 0x000fc400078e00ffULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011471ULL,
0x0000003500367306ULL, 0x0005e20000200c00ULL, 0x00000018ff3a7819ULL, 0x000fce000001143aULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x0000541037357816ULL, 0x004fe40000000070ULL,
0x000088803b707816ULL, 0x000fca00000000ffULL, 0x00000034301c723cULL, 0x000fe2000000181cULL,
0x0000006d006d7306ULL, 0x000fec0000200c00ULL, 0x000001003b347824ULL, 0x040fe400078e00ffULL,
0x000100003b357824ULL, 0x000fe200078e00ffULL, 0x0000006c006c7306ULL, 0x000fe40000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x0000003800387306ULL, 0x000eb00000200c00ULL, 0x0000003900737306ULL, 0x000f700000200c00ULL,
0x0000003400717306ULL, 0x0009f00000200c00ULL, 0x0000003500397306ULL, 0x0007e20000200c00ULL,
0x0000541072347816ULL, 0x010fce0000000055ULL, 0x0000007600377306ULL, 0x000f220000200c00ULL,
0x0000541074357816ULL, 0x008fce0000000075ULL, 0x0000007000707306ULL, 0x000ee20000200c00ULL,
0x000000343020723cULL, 0x000fee0000001820ULL, 0x0000541038347816ULL, 0x004fe2000000006dULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541073357816ULL, 0x022fce000000006cULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x000000343024723cULL, 0x000fee0000001824ULL,
0x0000003a003b7306ULL, 0x000e620000200c00ULL, 0x0000541036347816ULL, 0x010fe40000000037ULL,
0x0000541070357816ULL, 0x008fce0000000071ULL, 0x000000343028723cULL, 0x000fee0000001828ULL,
0x000054103b347816ULL, 0x002fe4000000006aULL, 0x0000541039357816ULL, 0x000fce0000000054ULL,
0x00000034302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000404947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x000000150e0e7221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fc600078e006fULL,
0x0000000000405947ULL, 0x000fea0003000000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0c0c7221ULL, 0x000fe20000010000ULL, 0x0000001611117221ULL, 0x000fe20000010000ULL,
0x0000001740407221ULL, 0x000fe20000010000ULL, 0x0000001a43437221ULL, 0x000fe20000010000ULL,
0x0000001b44447221ULL, 0x000fe20000010000ULL, 0x0000001e47477221ULL, 0x000fe20000010000ULL,
0x0000001f48487221ULL, 0x000fe20000010000ULL, 0x000000224b4b7221ULL, 0x000fe20000010000ULL,
0x000000234c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002a53537221ULL, 0x000fe20000010000ULL,
0x0000002b56567221ULL, 0x000fe20000010000ULL, 0x0000002e59597221ULL, 0x000fe20000010000ULL,
0x0000002f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff167424ULL, 0x000fe400078e00ffULL, 0x000000016b6b7836ULL, 0x000fe40000000000ULL,
0x018b8816ff1479a7ULL, 0x000e620008500006ULL, 0x00000004166a7807ULL, 0x000fc80000000000ULL,
0x0000006a6b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffac007ca947ULL, 0x000fea000383ffffULL, 0x00000040040b7891ULL, 0x000fe2000f8e403fULL,
0x018b5816ffff79a7ULL, 0x0003e60008500006ULL, 0x0000000d0b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f4f008ULL, 0x000000e800d02947ULL, 0x002fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x00000002ff147819ULL, 0x000fe4000001166bULL,
0x000000036b1a7812ULL, 0x040fe400078ec0ffULL, 0x000000146b147207ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60004000000ULL, 0x0000000114147836ULL, 0x000fca0000000000ULL,
0x00000003141c7812ULL, 0x040fe400078ec0ffULL, 0x00000004141b7c11ULL, 0x000fe4000f8ff0ffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b7871ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b7871ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7810ULL, 0x000fce0007ffe0ffULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011b147836ULL, 0x000fe20000000000ULL, 0x00000004ff6c7819ULL, 0x000fc80000011610ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x000000040060a947ULL, 0x000fea0003800000ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x000000041b167824ULL, 0x000fe200078e021cULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x00000010101d7824ULL, 0x000fe200078e00ffULL, 0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL,
0x000000026c227836ULL, 0x000fe20000000000ULL, 0x0000002016167811ULL, 0x000fe400078e30ffULL,
0x000000f01d217812ULL, 0x000fe200078ec0ffULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000d16177c48ULL, 0x000fe2000ffe0000ULL, 0x000000015b257824ULL, 0x000fc800078e0222ULL,
0x0000000117167824ULL, 0x000fe400078e0a16ULL, 0x0000000119177824ULL, 0x000fe400078e0220ULL,
0x0000000125247824ULL, 0x000fe200078e0210ULL, 0x000000165b167248ULL, 0x000fca0007fe0000ULL,
0x00000001161d7824ULL, 0x000fca00078e0a5bULL, 0x0000001d6c00720cULL, 0x000fe40003f46070ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e680000000a00ULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818177c24ULL, 0x004fc4000f8e0217ULL,
0x0000000119187824ULL, 0x000fe400078e0210ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff019187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fe400018e0617ULL,
0x0000000125197824ULL, 0x040fe200078e0220ULL, 0x0000000b18237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001025257824ULL, 0x000fc800078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d2200720cULL, 0x000fe20003f46070ULL,
0x000000046c227836ULL, 0x000fe20000000000ULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x018a08001f187984ULL, 0x000ea40000000800ULL, 0x000000015b257824ULL, 0x000fe200078e0222ULL,
0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fc60003f46070ULL, 0x018a10001f187984ULL, 0x000ea20000000800ULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002a40000000800ULL,
0x000000066c1e7836ULL, 0x002fc80000000000ULL, 0x000000015b257824ULL, 0x000fe400078e021eULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000000125207824ULL, 0x040fe200078e0210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x0000001d1e00720cULL, 0x000fe40003f46070ULL,
0x018a18001f187984ULL, 0x000ea40000000800ULL, 0xfffffff025207812ULL, 0x000fc800078ee220ULL,
0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4eULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x000000015b1f7824ULL, 0x000fe200078e026cULL, 0x0000002013227811ULL, 0x000fe200078e30ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x000000101f1e7824ULL, 0x040fe200078e00ffULL, 0x000000061f207c11ULL, 0x040fe2000f8e10ffULL,
0x000000011f177824ULL, 0x000fe200078e0222ULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f197824ULL, 0x000fe400078e0210ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x000000021f237836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000123247824ULL, 0x000fe400078e0210ULL, 0x0000000b191d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000122197824ULL, 0x000fe400078e0223ULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000816177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161d7faeULL, 0x0003e8000b901c4eULL, 0x018a080020187984ULL, 0x000ea20000000800ULL,
0xfffffff0231d7812ULL, 0x002fe200078ee224ULL, 0x000000041f237836ULL, 0x000fe40000000000ULL,
0x000000061f1f7836ULL, 0x000fe20000000000ULL, 0x0000000b1d1d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000122177824ULL, 0x000fc400078e0223ULL, 0x0000000123247824ULL, 0x040fe400078e0210ULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x00000006181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181d7faeULL, 0x0003e8000b901c4eULL, 0x018a100020167984ULL, 0x000ea20000000800ULL,
0xfffffff023197812ULL, 0x002fe200078ee224ULL, 0x00000001221d7824ULL, 0x000fc600078e021fULL,
0x0000000b19197c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002a40000000800ULL, 0x000000101f1e7824ULL, 0x002fe400078e00ffULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4eULL,
0x018a180020187984ULL, 0x000ea40000000800ULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x00000008181d7c24ULL, 0x004fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x000000011f1d7824ULL, 0x000fe200078e0210ULL,
0x0000002114147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff01e177812ULL, 0x002fe200078ee21dULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000b17177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1e7424ULL, 0x000fe200078e00ffULL, 0x000000031a00780cULL, 0x000fe20003f65270ULL,
0x000000205f6f7824ULL, 0x000fd800078e0210ULL, 0x00000000004ca947ULL, 0x000fea0001800000ULL,
0x000000036f00780cULL, 0x000fe20003f44070ULL, 0x0000000105057890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412167824ULL, 0x000fe200078e026fULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000517187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x000000011a157836ULL, 0x002fe20000000000ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000315167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16167207ULL, 0x000fc60005000000ULL, 0x00000002ff15a819ULL, 0x000fe40000011615ULL,
0x000000015d167824ULL, 0x000fc600078e0216ULL, 0x000000011c1c7824ULL, 0x000fe400078e0215ULL,
0x00009200ff147b82ULL, 0x000e640000000a00ULL, 0x000000401c177824ULL, 0x040fe200078e00ffULL,
0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c017187812ULL, 0x000fca00078ec0ffULL,
0x000001001b187824ULL, 0x000fc800078e0218ULL, 0x000000016f177824ULL, 0x100fe400078e0218ULL,
0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL, 0x0000000d17007c0cULL, 0x000fe2000bf46070ULL,
0x000000016f177824ULL, 0x000fc800078e0216ULL, 0x0000000417147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801eff1479a7ULL, 0x000e620008500006ULL, 0x000000ff6b00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018af81e5b1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018af8185b0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018af8185b0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001010077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011610ULL,
0x000000ffff167224ULL, 0x000fc600078e0008ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000006141b7c10ULL, 0x000fca000fffe007ULL,
0x018080001b157984ULL, 0x000e680000000800ULL, 0x018280001b147984ULL, 0x0004a20000000800ULL,
0x000000081500720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000081500720bULL, 0x000fe40003f54000ULL,
0x000000015f00780cULL, 0x000fe40003f65270ULL, 0x0000001508167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018480161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001608087221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x00000008001a7308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f631a087589ULL, 0x006e6400000e0000ULL,
0x000000080b0b7220ULL, 0x082fe20000410000ULL, 0x000000080a0a7220ULL, 0x080fe20000410000ULL,
0x000000080f0f7220ULL, 0x080fe20000410000ULL, 0x000000080e0e7220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x0000000842427220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000846467220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x000000084a4a7220ULL, 0x080fe20000410000ULL,
0x000000084d4d7220ULL, 0x080fe20000410000ULL, 0x000000084e4e7220ULL, 0x080fe20000410000ULL,
0x0000000851517220ULL, 0x080fe20000410000ULL, 0x0000000852527220ULL, 0x080fe20000410000ULL,
0x0000000857577220ULL, 0x080fe20000410000ULL, 0x0000000858587220ULL, 0x000fce0000410000ULL,
0x0000001a09097220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f621a087589ULL, 0x002e6400000e0000ULL, 0x000000080d0d7220ULL, 0x082fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000843437220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000847477220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x000000084b4b7220ULL, 0x080fe20000410000ULL,
0x000000084c4c7220ULL, 0x080fe20000410000ULL, 0x000000084f4f7220ULL, 0x080fe20000410000ULL,
0x0000000850507220ULL, 0x080fe20000410000ULL, 0x0000000853537220ULL, 0x080fe20000410000ULL,
0x0000000856567220ULL, 0x080fe20000410000ULL, 0x0000000859597220ULL, 0x080fe20000410000ULL,
0x000000085a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001615152221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL, 0x0000001500062308ULL, 0x000ea40000000800ULL,
0x0000000614142220ULL, 0x004fce0000410000ULL, 0x0000000914097221ULL, 0x000fe20000010000ULL,
0x000000ffff087224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0002a800000e0000ULL,
0x00001f6214047589ULL, 0x0002e400000e0000ULL, 0x01280000052c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000032c2c7232ULL, 0x08cfe40000000000ULL,
0x000000032e2e7232ULL, 0x000fe40000000000ULL, 0x000000042d2d7232ULL, 0x080fe40000000000ULL,
0x000000042f2f7232ULL, 0x000fce0000000000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000010018207824ULL, 0x010fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe20000011419ULL, 0x0000010019217824ULL, 0x040fe200078e00ffULL,
0x00008880193d7816ULL, 0x040fe200000000ffULL, 0x000100001a227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x000100001b237824ULL, 0x000fe200078e00ffULL,
0x0000002000397306ULL, 0x0009e20000200c00ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000017387824ULL, 0x002fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fc40000011419ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141aULL, 0x00000018ff1d7819ULL, 0x000fe2000001141bULL,
0x00000021002a7306ULL, 0x0003e20000200c00ULL, 0x000001001a207824ULL, 0x050fe200078e00ffULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x000088801b347816ULL, 0x040fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002200357306ULL, 0x0009e20000200c00ULL,
0x000001001b217824ULL, 0x002fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fc40000011423ULL,
0x00000018ff247819ULL, 0x000fe40000011414ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000020001a7306ULL, 0x0003e20000200c00ULL, 0x0000000814227819ULL, 0x050fe400000006ffULL,
0x00000018ff257819ULL, 0x000fe40000011415ULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe20000011418ULL,
0x00000021001b7306ULL, 0x0009e20000200c00ULL, 0x0000888014207816ULL, 0x042fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00008880183c7816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fc40000011416ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000888016287816ULL, 0x000fe400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001400277306ULL, 0x0009e20000200c00ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x0000888017297816ULL, 0x000fe400000000ffULL,
0x00000018ff317819ULL, 0x000fe40000011417ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000001500267306ULL, 0x000be20000200c00ULL, 0x0000010016147824ULL, 0x050fe200078e00ffULL,
0x000054103d3d7816ULL, 0x002fe2000000002aULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x028fe200078e00ffULL, 0x0000001f001f7306ULL, 0x000fe80000200c00ULL,
0x00000018ff367819ULL, 0x000fc80000011415ULL, 0x0000001800187306ULL, 0x000ff00000200c00ULL,
0x0000001900197306ULL, 0x000ff00000200c00ULL, 0x0000001e001e7306ULL, 0x000ff00000200c00ULL,
0x0000001c001c7306ULL, 0x000e700000200c00ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000200c00ULL,
0x0000002500257306ULL, 0x000ee20000200c00ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x0000541026257816ULL, 0x008fce0000000025ULL,
0x0000003700377306ULL, 0x000ee20000200c00ULL, 0x000000242c24723cULL, 0x000fe200000018ffULL,
0x000054103c3c7816ULL, 0x002fcc0000000039ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x0000003c2c3c723cULL, 0x000fe200000018ffULL, 0x0000541037157816ULL, 0x008fcc000000001eULL,
0x0000003200327306ULL, 0x000e700000200c00ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x00005410321d7816ULL, 0x002fce000000001dULL, 0x0000002300237306ULL, 0x000e700000200c00ULL,
0x0000002100217306ULL, 0x000fe20000200c00ULL, 0x0000541020207816ULL, 0x002fce0000000023ULL,
0x0000002200227306ULL, 0x000e700000200c00ULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x0000541021217816ULL, 0x002fce0000000022ULL, 0x00000014002b7306ULL, 0x0002e20000200c00ULL,
0x000000202c20723cULL, 0x000fee00000018ffULL, 0x0000002900297306ULL, 0x000fe20000200c00ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x000fe2000000001aULL,
0x0000001c2c1c723cULL, 0x000fe200000018ffULL, 0x0000541034197816ULL, 0x000fc4000000001bULL,
0x0000541028287816ULL, 0x008fe2000000002bULL, 0x00000036002a7306ULL, 0x000e680000200c00ULL,
0x000000182c18723cULL, 0x000fe800000018ffULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x0000541029297816ULL, 0x002fce000000002aULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000000282c28723cULL, 0x000fee00000018ffULL, 0x0000001600337306ULL, 0x0002f00000200c00ULL,
0x0000003800387306ULL, 0x000f220000200c00ULL, 0x000000142c14723cULL, 0x002fe200000018ffULL,
0x0000541033307816ULL, 0x008fc40000000030ULL, 0x0000541038317816ULL, 0x010fce0000000031ULL,
0x000000302c2c723cULL, 0x000fe200000018ffULL, 0x012800005e30783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000431317232ULL, 0x080fe40000000000ULL, 0x0000000433337232ULL, 0x000fce0000000000ULL,
0x000000006134783bULL, 0x000f220000004200ULL, 0x0000006b6300720cULL, 0x080fe20003f66070ULL,
0x0000083000007945ULL, 0x000fe20003800000ULL, 0x000000045c007c0cULL, 0x000fe2000bfc3070ULL,
0x000000006038783bULL, 0x000f620000004200ULL, 0x0000006b6200720cULL, 0x000fe40003f86070ULL,
0x000000045c007c0cULL, 0x000fe4000bfa3070ULL, 0x00000018ff737819ULL, 0x010fe20000011434ULL,
0x0000010034557824ULL, 0x040fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011435ULL,
0x00000100356e7824ULL, 0x040fe200078e00ffULL, 0x0000888034547816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888035747816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff757819ULL, 0x000fe2000001146eULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011437ULL,
0x00000018ff717819ULL, 0x000fe40000011436ULL, 0x00000018ff6e7819ULL, 0x022fc40000011438ULL,
0x0000888038777816ULL, 0x000fe200000000ffULL, 0x0000003400347306ULL, 0x000e700000200c00ULL,
0x0000003500357306ULL, 0x000f220000200c00ULL, 0x0000541034347816ULL, 0x002fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000e640000200c00ULL,
0x000000343014723cULL, 0x008fec0000001814ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000010037347824ULL, 0x000fe200078e00ffULL, 0x0000541054547816ULL, 0x002fcc0000000055ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000018ff767819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fcc00078e00ffULL, 0x0000007300727306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541074557816ULL, 0x002fe20000000075ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x0000888037757816ULL, 0x000fc600000000ffULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe4000001143bULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000000183cULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000007400357306ULL, 0x0002e80000200c00ULL, 0x00000018ff557819ULL, 0x000fc40000011439ULL,
0x00000018ff547819ULL, 0x000fe4000001143aULL, 0x0000007500757306ULL, 0x000f220000200c00ULL,
0x0000888039747816ULL, 0x002fce00000000ffULL, 0x0000003400787306ULL, 0x0007f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541072347816ULL, 0x008fe40000000035ULL,
0x0000541075357816ULL, 0x010fca0000000076ULL, 0x0000007000707306ULL, 0x000fe40000200c00ULL,
0x000000343018723cULL, 0x000fec0000001818ULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000010038357824ULL, 0x000fe400078e00ffULL, 0x0000010039347824ULL, 0x000fc400078e00ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe20000011434ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe20000011438ULL, 0x0001000039387824ULL, 0x000fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000003500767306ULL, 0x0003f00000200c00ULL,
0x0000003400397306ULL, 0x0007e20000200c00ULL, 0x0000541037357816ULL, 0x002fc40000000070ULL,
0x000088803b707816ULL, 0x000fca00000000ffULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541078347816ULL, 0x008fe40000000071ULL, 0x000088803a717816ULL, 0x000fca00000000ffULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000034301c723cULL, 0x000fee000000181cULL,
0x000001003a357824ULL, 0x000fe200078e00ffULL, 0x0000006e006e7306ULL, 0x000ee20000200c00ULL,
0x000001003b347824ULL, 0x000fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff377819ULL, 0x000fe4000001143aULL, 0x00000018ff3b7819ULL, 0x000fca000001143bULL,
0x0000003800387306ULL, 0x000f300000200c00ULL, 0x0000003500727306ULL, 0x0003f00000200c00ULL,
0x0000003400737306ULL, 0x000be20000200c00ULL, 0x0000541074357816ULL, 0x002fce0000000075ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x0000541077347816ULL, 0x024fce0000000076ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x000000343020723cULL, 0x000fee0000001820ULL,
0x0000541039347816ULL, 0x008fe2000000006eULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541038357816ULL, 0x010fe20000000055ULL, 0x000000016b387836ULL, 0x000fca0000000000ULL,
0x000000386300720cULL, 0x080fe20005f66470ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x000000343024723cULL, 0x000fe20000001824ULL, 0x000000386200720cULL, 0x000fcc0006786470ULL,
0x0000003700377306ULL, 0x000ee20000200c00ULL, 0x0000541071347816ULL, 0x002fe40000000072ULL,
0x0000541070357816ULL, 0x004fca0000000073ULL, 0x0000003b003b7306ULL, 0x000e640000200c00ULL,
0x000000343028723cULL, 0x000fee0000001828ULL, 0x0000541037347816ULL, 0x008fe40000000054ULL,
0x000054103b357816ULL, 0x002fe20000000036ULL, 0x00000001ff367424ULL, 0x000fcc00078e00ffULL,
0x00000034302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x000000150e0e7221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8836ff1479a7ULL, 0x000e620008500006ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000045c007c0cULL, 0x000fe4000bfc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x000000045c007c0cULL, 0x000fe2000bfa3070ULL, 0x0000000117177836ULL, 0x000fe20000000000ULL,
0x00000040ff347803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000004171c7c11ULL, 0x000fe2000f8ff0ffULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000011c147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bfc6070ULL, 0x00000004005ce947ULL, 0x000fea0003800000ULL,
0x000000015b1d7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010187824ULL, 0x000fe400078e00ffULL, 0x0000004013217824ULL, 0x000fe200078e021dULL,
0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101d1e7824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x000000041c187824ULL, 0x000fe400078e021bULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x000000026c207836ULL, 0x000fc40000000000ULL,
0x0000004018187824ULL, 0x000fe400078e00ffULL, 0x000000015b277824ULL, 0x000fe200078e0220ULL,
0x0000000614197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0004e40000000800ULL, 0x0000000d18197c48ULL, 0x004fca000ffe0000ULL,
0x0000000119187824ULL, 0x000fe400078e0a18ULL, 0x000000011d197824ULL, 0x000fc600078e0210ULL,
0x000000185b187248ULL, 0x000fe40007fe0000ULL, 0xfffffff01e197812ULL, 0x000fc600078ee219ULL,
0x00000001181d7824ULL, 0x000fe200078e0a5bULL, 0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000221197836ULL, 0x000fe40000000000ULL, 0x0000000816177c24ULL, 0x008fc8000f8e0221ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d6c00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a08001f187984ULL, 0x000ea20000000800ULL, 0x0000000127167824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000421177836ULL, 0x000fc60000000000ULL,
0xfffffff027167812ULL, 0x000fc800078ee216ULL, 0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x0000001d2000720cULL, 0x000fe20003fc6070ULL, 0x000000046c207836ULL, 0x000fe40000000000ULL,
0x000000066c6c7836ULL, 0x000fe40000000000ULL, 0x000000015b277824ULL, 0x000fd000078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000f101c4eULL,
0x018a10001f167984ULL, 0x000ea20000000800ULL, 0x0000000127187824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000621197836ULL, 0x000fc60000000000ULL,
0xfffffff027187812ULL, 0x000fc800078ee218ULL, 0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d2000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a18001f187984ULL, 0x000ea40000000800ULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002314147210ULL, 0x000fc60007fde0ffULL,
0x0000000119167824ULL, 0x042fe400078e0210ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000001d6c00720cULL, 0x000fe20003fc6070ULL, 0x0000001019197824ULL, 0x000fca00078e00ffULL,
0xfffffff019167812ULL, 0x000fc800078ee216ULL, 0x0000000b16177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4eULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015b6c7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010197824ULL, 0x000fe400078e00ffULL,
0x00000040131f7824ULL, 0x000fe200078e026cULL, 0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000106c207824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000016c197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000026c257836ULL, 0x000fc40000000000ULL, 0xfffffff020197812ULL, 0x000fe400078ee219ULL,
0x0000000125207824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x000000021f197836ULL, 0x000fe40000000000ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe200078ee220ULL, 0x000000046c257836ULL, 0x000fe20000000000ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000816177c24ULL, 0x004fc8000f8e021fULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a08001e187984ULL, 0x000ea20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000041f177836ULL, 0x000fe40000000000ULL,
0x0000000125207824ULL, 0x040fe400078e0210ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe400078ee220ULL, 0x00000006181d7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001d187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4eULL, 0x018a10001e167984ULL, 0x000ea20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000061f197836ULL, 0x000fe20000000000ULL,
0x00000006161d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea40000000800ULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000066c197836ULL, 0x000fe20000000000ULL,
0x0000002114147210ULL, 0x000fc60007fde0ffULL, 0x00000001191d7824ULL, 0x040fe400078e0210ULL,
0x0000001019167824ULL, 0x002fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fc600030e0615ULL,
0xfffffff0161d7812ULL, 0x000fc800078ee21dULL, 0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4eULL,
0x0000000100147802ULL, 0x002fcc0000000f00ULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5c00720cULL, 0x000fe20003fc4070ULL, 0x00009400000b7ab9ULL, 0x000fc60000000800ULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60007000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x000000015d177824ULL, 0x000fe400078e021aULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016187836ULL, 0x000fc80000000000ULL,
0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL, 0x000000016f177824ULL, 0x040fe400078e0216ULL,
0x000000016f167824ULL, 0x040fe200078e0218ULL, 0x000000066f6f7c11ULL, 0x000fe2000f8e10ffULL,
0x0000000417147825ULL, 0x002fc600078e0014ULL, 0x0000000d16007c0cULL, 0x000fda000bfc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a00000146f7faeULL, 0x0003e4000f12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b7870ff7079a7ULL, 0x000e620008500006ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000000ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6314037589ULL, 0x0004e800000e0000ULL, 0x00001f6214047589ULL, 0x00046400000e0000ULL,
0x01280000662c783bULL, 0x0004e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x088fe40000000000ULL, 0x000000032e2e7232ULL, 0x000fe40000000000ULL,
0x000000042d2d7232ULL, 0x082fe40000000000ULL, 0x000000042f2f7232ULL, 0x000fce0000000000ULL,
0x000000006518783bULL, 0x000f280000004200ULL, 0x000000006414783bULL, 0x004ea20000004200ULL,
0x0000010018207824ULL, 0x010fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011419ULL,
0x0000010019217824ULL, 0x040fe200078e00ffULL, 0x00008880193d7816ULL, 0x040fe200000000ffULL,
0x000100001a227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x000100001b237824ULL, 0x000fe200078e00ffULL, 0x0000002000397306ULL, 0x0009e20000200c00ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x00008880183c7816ULL, 0x040fe400000000ffULL,
0x00000018ff1f7819ULL, 0x000fe20000011418ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011419ULL, 0x00000021002a7306ULL, 0x000be20000200c00ULL,
0x000001001a207824ULL, 0x050fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141aULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x0000002200357306ULL, 0x0009e20000200c00ULL, 0x000001001b217824ULL, 0x028fe200078e00ffULL,
0x00000018ff247819ULL, 0x004fe40000011414ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141bULL,
0x000088801b367816ULL, 0x000fe400000000ffULL, 0x00000018ff327819ULL, 0x000fe40000011423ULL,
0x00000020001a7306ULL, 0x0007e20000200c00ULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff307819ULL, 0x000fe40000011416ULL, 0x0000888016287816ULL, 0x000fe200000000ffULL,
0x00000021001b7306ULL, 0x0009e20000200c00ULL, 0x0000888014207816ULL, 0x048fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x004fe20000000039ULL,
0x0001000017397824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000888017297816ULL, 0x000fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe40000011417ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000003d003d7306ULL, 0x000eb00000200c00ULL,
0x0000001900197306ULL, 0x000ee20000200c00ULL, 0x000054103d3d7816ULL, 0x004fce000000002aULL,
0x0000003600367306ULL, 0x000ea20000200c00ULL, 0x0000003c2c3c723cULL, 0x000fee00000018ffULL,
0x0000001400277306ULL, 0x0009f00000200c00ULL, 0x0000001500267306ULL, 0x000be20000200c00ULL,
0x0000010016147824ULL, 0x010fc400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x022fe200078e00ffULL, 0x00000014002b7306ULL, 0x0003e80000200c00ULL,
0x00000018ff387819ULL, 0x000fc80000011415ULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x008fe4000000001aULL,
0x0000541036197816ULL, 0x004fc6000000001bULL, 0x0000001c001c7306ULL, 0x000e680000200c00ULL,
0x000000182c18723cULL, 0x000fe800000018ffULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000200c00ULL,
0x0000002500257306ULL, 0x000ea20000200c00ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003700377306ULL, 0x000e620000200c00ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003200327306ULL, 0x000ea20000200c00ULL, 0x000000242c24723cULL, 0x000fe200000018ffULL,
0x0000541037157816ULL, 0x002fcc000000001eULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x00005410321d7816ULL, 0x004fce000000001dULL, 0x0000002300237306ULL, 0x000e620000200c00ULL,
0x0000001c2c1c723cULL, 0x000fee00000018ffULL, 0x0000002100217306ULL, 0x000fe20000200c00ULL,
0x0000541020207816ULL, 0x002fce0000000023ULL, 0x0000002200227306ULL, 0x000e700000200c00ULL,
0x0000002800287306ULL, 0x000ea20000200c00ULL, 0x0000541021217816ULL, 0x002fce0000000022ULL,
0x0000002900297306ULL, 0x000fe20000200c00ULL, 0x000000202c20723cULL, 0x000fe200000018ffULL,
0x0000541028287816ULL, 0x004fcc000000002bULL, 0x00000038002a7306ULL, 0x000e700000200c00ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x0000541029297816ULL, 0x002fce000000002aULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x000000282c28723cULL, 0x000fee00000018ffULL,
0x0000001600337306ULL, 0x0002b00000200c00ULL, 0x0000003900367306ULL, 0x000ee20000200c00ULL,
0x000000142c14723cULL, 0x002fe200000018ffULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x0000541036317816ULL, 0x008fce0000000031ULL, 0x000000302c2c723cULL, 0x000fe200000018ffULL,
0x012800006730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000431317232ULL, 0x080fe40000000000ULL,
0x0000000433337232ULL, 0x000fce0000000000ULL, 0x000000ff3400720cULL, 0x000fe20003f45270ULL,
0x000000006838783bULL, 0x000ee20000004200ULL, 0x000007c000007945ULL, 0x000fe60003800000ULL,
0x000000006934783bULL, 0x000f220000004200ULL, 0x00000018ff6d7819ULL, 0x008fe40000011438ULL,
0x00000018ff737819ULL, 0x010fe20000011434ULL, 0x0000010034557824ULL, 0x040fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011435ULL, 0x00000100356c7824ULL, 0x040fe200078e00ffULL,
0x0000888034547816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888035747816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe2000001146cULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff6f7819ULL, 0x000fe40000011436ULL, 0x00000018ff6e7819ULL, 0x000fe40000011437ULL,
0x00000018ff6c7819ULL, 0x000fc60000011439ULL, 0x0000003400347306ULL, 0x000ef00000200c00ULL,
0x0000003500357306ULL, 0x000f220000200c00ULL, 0x0000541034347816ULL, 0x008fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000ee40000200c00ULL,
0x000000343014723cULL, 0x004fec0000001814ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000010037347824ULL, 0x040fe200078e00ffULL, 0x0000888037357816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fca00078e00ffULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x0000541054547816ULL, 0x008fe40000000055ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff377819ULL, 0x000fc60000011437ULL, 0x0000007300727306ULL, 0x0007e20000200c00ULL,
0x0000541074557816ULL, 0x004fe20000000075ULL, 0x0000010036747824ULL, 0x000fcc00078e00ffULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x0001000036367824ULL, 0x000fe400078e00ffULL,
0x0000010038737824ULL, 0x008fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000000183cULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000007400757306ULL, 0x000ea20000200c00ULL, 0x00000018ff737819ULL, 0x000fc60000011473ULL,
0x00000018ff557819ULL, 0x000fe4000001143aULL, 0x00000018ff547819ULL, 0x000fe4000001143bULL,
0x0000003400767306ULL, 0x0004f00000200c00ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000541072347816ULL, 0x004fc40000000075ULL, 0x0000888038727816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x0000888039757816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x008fe20000000076ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x000000343018723cULL, 0x000fe40000001818ULL,
0x0000003600367306ULL, 0x000fea0000200c00ULL, 0x0000010039347824ULL, 0x040fe400078e00ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x0000003700377306ULL, 0x000ea40000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff397819ULL, 0x000fc80000011439ULL,
0x0000003400767306ULL, 0x0007e20000200c00ULL, 0x0000541037357816ULL, 0x004fce000000006eULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x008fe2000000006fULL,
0x000001003a377824ULL, 0x040fe200078e00ffULL, 0x000088803a367816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000088803b6e7816ULL, 0x040fe400000000ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000007300777306ULL, 0x000fe20000200c00ULL,
0x00000034301c723cULL, 0x000fee000000181cULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x000001003b347824ULL, 0x000fc400078e00ffULL, 0x000100003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000541075357816ULL, 0x004fca0000000076ULL,
0x0000006c006c7306ULL, 0x000ff00000200c00ULL, 0x0000003800747306ULL, 0x0004f00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x00000018ff387819ULL, 0x004fce000001143aULL,
0x00000034006f7306ULL, 0x0005f00000200c00ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0000541072347816ULL, 0x004fce0000000077ULL, 0x0000003700737306ULL, 0x000ea20000200c00ULL,
0x000000343020723cULL, 0x000fee0000001820ULL, 0x0000006e006e7306ULL, 0x000f620000200c00ULL,
0x0000541074347816ULL, 0x008fe4000000006dULL, 0x0000541039357816ULL, 0x010fca000000006cULL,
0x0000005500557306ULL, 0x000fe40000200c00ULL, 0x000000343024723cULL, 0x000fec0000001824ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x004fe40000000073ULL,
0x000054106e357816ULL, 0x022fca000000006fULL, 0x0000003800387306ULL, 0x000e640000200c00ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x0000003b00377306ULL, 0x000ea20000200c00ULL,
0x0000541038347816ULL, 0x002fe40000000055ULL, 0x0000541037357816ULL, 0x004fce0000000054ULL,
0x00000034302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x000000150e0e7221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000016b6b7836ULL, 0x000fe40000000000ULL, 0x018b8816ff1479a7ULL, 0x000e660008500006ULL,
0x0000006a6b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffb00078a947ULL, 0x000fea000383ffffULL, 0x00000080040b7891ULL, 0x000fe2000f8e403fULL,
0x018b6016ffff79a7ULL, 0x0003e60008500006ULL, 0x0000000d0b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f4f008ULL, 0x0000009c00302947ULL, 0x002fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x00000002ff147819ULL, 0x000fe4000001166bULL,
0x000000036b1a7812ULL, 0x040fe400078ec0ffULL, 0x000000146b147207ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60004000000ULL, 0x0000000214147836ULL, 0x000fca0000000000ULL,
0x00000003141c7812ULL, 0x040fe400078ec0ffULL, 0x00000004141b7c11ULL, 0x000fe4000f8ff0ffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b7871ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b7871ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011b147836ULL, 0x000fe20000000000ULL, 0x00000004ff6c7819ULL, 0x000fc80000011610ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x000000040060a947ULL, 0x000fea0003800000ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x000000041b167824ULL, 0x000fe200078e021cULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x00000010101d7824ULL, 0x000fe200078e00ffULL, 0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL,
0x000000026c227836ULL, 0x000fe20000000000ULL, 0x0000002016167811ULL, 0x000fe400078e30ffULL,
0x000000f01d217812ULL, 0x000fe200078ec0ffULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000d16177c48ULL, 0x000fe2000ffe0000ULL, 0x000000015b257824ULL, 0x000fc800078e0222ULL,
0x0000000117167824ULL, 0x000fe400078e0a16ULL, 0x0000000119177824ULL, 0x000fe400078e0220ULL,
0x0000000125247824ULL, 0x000fe200078e0210ULL, 0x000000165b167248ULL, 0x000fca0007fe0000ULL,
0x00000001161d7824ULL, 0x000fca00078e0a5bULL, 0x0000001d6c00720cULL, 0x000fe40003f46070ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e680000000a00ULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818177c24ULL, 0x004fc4000f8e0217ULL,
0x0000000119187824ULL, 0x000fe400078e0210ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff019187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fe400018e0617ULL,
0x0000000125197824ULL, 0x040fe200078e0220ULL, 0x0000000b18237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001025257824ULL, 0x000fc800078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d2200720cULL, 0x000fe20003f46070ULL,
0x000000046c227836ULL, 0x000fe20000000000ULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x018a08001f187984ULL, 0x000ea40000000800ULL, 0x000000015b257824ULL, 0x000fe200078e0222ULL,
0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fc60003f46070ULL, 0x018a10001f187984ULL, 0x000ea20000000800ULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002a40000000800ULL,
0x000000066c1e7836ULL, 0x002fc80000000000ULL, 0x000000015b257824ULL, 0x000fe400078e021eULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000000125207824ULL, 0x040fe200078e0210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x0000001d1e00720cULL, 0x000fe40003f46070ULL,
0x018a18001f187984ULL, 0x000ea40000000800ULL, 0xfffffff025207812ULL, 0x000fc800078ee220ULL,
0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fc80007f7e0ffULL,
0x00000015ff157210ULL, 0x000fca0001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4eULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x000000015b1f7824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x000000101f227824ULL, 0x040fe200078e00ffULL, 0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000011f177824ULL, 0x000fe200078e0220ULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000021f257836ULL, 0x000fc40000000000ULL, 0xfffffff022197812ULL, 0x000fe400078ee219ULL,
0x0000000125227824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe400078e0225ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025227812ULL, 0x000fe200078ee222ULL, 0x000000041f257836ULL, 0x000fe40000000000ULL,
0x000000061f1f7836ULL, 0x000fe20000000000ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a08001e187984ULL, 0x000ea20000000800ULL, 0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL,
0x0000000120177824ULL, 0x000fe400078e0225ULL, 0x0000000125227824ULL, 0x040fe400078e0210ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025227812ULL, 0x000fe400078ee222ULL,
0x00000006181d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ea20000000800ULL, 0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe400078e021fULL, 0x000000101f207824ULL, 0x000fe200078e00ffULL,
0x00000006161d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea40000000800ULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000011f197824ULL, 0x000fe200078e0210ULL,
0x0000002114147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff020197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000b19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1e7424ULL, 0x000fe200078e00ffULL, 0x000000031a00780cULL, 0x000fe20003f65270ULL,
0x000000205f6f7824ULL, 0x000fd800078e0210ULL, 0x00000000004ca947ULL, 0x000fea0001800000ULL,
0x000000036f00780cULL, 0x000fe20003f44070ULL, 0x0000000105057890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412167824ULL, 0x000fe200078e026fULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000517187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x000000011a157836ULL, 0x002fe20000000000ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000315167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16167207ULL, 0x000fc60005000000ULL, 0x00000002ff15a819ULL, 0x000fe40000011615ULL,
0x000000015d167824ULL, 0x000fc600078e0216ULL, 0x000000011c1c7824ULL, 0x000fe400078e0215ULL,
0x00009200ff147b82ULL, 0x000e640000000a00ULL, 0x000000401c177824ULL, 0x040fe200078e00ffULL,
0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c017187812ULL, 0x000fca00078ec0ffULL,
0x000001001b187824ULL, 0x000fc800078e0218ULL, 0x000000016f177824ULL, 0x100fe400078e0218ULL,
0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL, 0x0000000d17007c0cULL, 0x000fe2000bf46070ULL,
0x000000016f177824ULL, 0x000fc800078e0216ULL, 0x0000000417147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801eff1479a7ULL, 0x000e620008500006ULL, 0x000000ff6b00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018b181e5b1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018b18185b0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018b18185b0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001010077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011610ULL,
0x000000ffff167224ULL, 0x000fc600078e0008ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000006141b7c10ULL, 0x000fca000fffe007ULL,
0x018100001b157984ULL, 0x000e680000000800ULL, 0x018300001b147984ULL, 0x0004a20000000800ULL,
0x000000081500720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000081500720bULL, 0x000fe40003f54000ULL,
0x000000025f00780cULL, 0x000fe40003f65270ULL, 0x0000001508167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018500161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001608087221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x00000008001a7308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f631a087589ULL, 0x006e6400000e0000ULL,
0x000000080b0b7220ULL, 0x082fe20000410000ULL, 0x000000080a0a7220ULL, 0x080fe20000410000ULL,
0x000000080f0f7220ULL, 0x080fe20000410000ULL, 0x000000080e0e7220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x0000000842427220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000846467220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x000000084a4a7220ULL, 0x080fe20000410000ULL,
0x000000084d4d7220ULL, 0x080fe20000410000ULL, 0x000000084e4e7220ULL, 0x080fe20000410000ULL,
0x0000000851517220ULL, 0x080fe20000410000ULL, 0x0000000852527220ULL, 0x080fe20000410000ULL,
0x0000000857577220ULL, 0x080fe20000410000ULL, 0x0000000858587220ULL, 0x000fce0000410000ULL,
0x0000001a09097220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f621a087589ULL, 0x002e6400000e0000ULL, 0x000000080d0d7220ULL, 0x082fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000843437220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000847477220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x000000084b4b7220ULL, 0x080fe20000410000ULL,
0x000000084c4c7220ULL, 0x080fe20000410000ULL, 0x000000084f4f7220ULL, 0x080fe20000410000ULL,
0x0000000850507220ULL, 0x080fe20000410000ULL, 0x0000000853537220ULL, 0x080fe20000410000ULL,
0x0000000856567220ULL, 0x080fe20000410000ULL, 0x0000000859597220ULL, 0x080fe20000410000ULL,
0x000000085a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001615152221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL, 0x0000001500062308ULL, 0x000ea40000000800ULL,
0x0000000614142220ULL, 0x004fce0000410000ULL, 0x0000000914097221ULL, 0x000fe20000010000ULL,
0x000000ffff087224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0002a800000e0000ULL,
0x00001f6214047589ULL, 0x0002e400000e0000ULL, 0x01300000052c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000032c2c7232ULL, 0x08cfe40000000000ULL,
0x000000032e2e7232ULL, 0x000fe40000000000ULL, 0x000000042d2d7232ULL, 0x080fe40000000000ULL,
0x000000042f2f7232ULL, 0x000fce0000000000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000010018207824ULL, 0x010fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe20000011419ULL, 0x0000010019217824ULL, 0x040fe200078e00ffULL,
0x00008880193d7816ULL, 0x040fe200000000ffULL, 0x000100001a227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x000100001b237824ULL, 0x000fe200078e00ffULL,
0x0000002000397306ULL, 0x0009e20000200c00ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000017387824ULL, 0x002fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fc40000011419ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141aULL, 0x00000018ff1d7819ULL, 0x000fe2000001141bULL,
0x00000021002a7306ULL, 0x0003e20000200c00ULL, 0x000001001a207824ULL, 0x050fe200078e00ffULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x000088801b347816ULL, 0x040fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002200357306ULL, 0x0009e20000200c00ULL,
0x000001001b217824ULL, 0x002fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fc40000011423ULL,
0x00000018ff247819ULL, 0x000fe40000011414ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000020001a7306ULL, 0x0003e20000200c00ULL, 0x0000010014227824ULL, 0x050fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011415ULL, 0x00000018ff1f7819ULL, 0x000fe40000011418ULL,
0x00000018ff237819ULL, 0x000fe20000011422ULL, 0x0000010015227824ULL, 0x000fe200078e00ffULL,
0x00000021001b7306ULL, 0x0009e20000200c00ULL, 0x0000888014207816ULL, 0x042fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00008880183c7816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fc40000011416ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000888016287816ULL, 0x000fe400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001400277306ULL, 0x0009e20000200c00ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x0000888017297816ULL, 0x000fe400000000ffULL,
0x00000018ff317819ULL, 0x000fe40000011417ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000001500267306ULL, 0x000be20000200c00ULL, 0x0000010016147824ULL, 0x050fe200078e00ffULL,
0x000054103d3d7816ULL, 0x002fe2000000002aULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x028fe200078e00ffULL, 0x0000001f001f7306ULL, 0x000fe80000200c00ULL,
0x00000018ff367819ULL, 0x000fc80000011415ULL, 0x0000001800187306ULL, 0x000ff00000200c00ULL,
0x0000001900197306ULL, 0x000ff00000200c00ULL, 0x0000001e001e7306ULL, 0x000ff00000200c00ULL,
0x0000001c001c7306ULL, 0x000e700000200c00ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000200c00ULL,
0x0000002500257306ULL, 0x000ee20000200c00ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x0000541026257816ULL, 0x008fce0000000025ULL,
0x0000003700377306ULL, 0x000ee20000200c00ULL, 0x000000242c24723cULL, 0x000fe200000018ffULL,
0x000054103c3c7816ULL, 0x002fcc0000000039ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x0000003c2c3c723cULL, 0x000fe200000018ffULL, 0x0000541037157816ULL, 0x008fcc000000001eULL,
0x0000003200327306ULL, 0x000e700000200c00ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x00005410321d7816ULL, 0x002fce000000001dULL, 0x0000002300237306ULL, 0x000e700000200c00ULL,
0x0000002100217306ULL, 0x000fe20000200c00ULL, 0x0000541020207816ULL, 0x002fce0000000023ULL,
0x0000002200227306ULL, 0x000e700000200c00ULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x0000541021217816ULL, 0x002fce0000000022ULL, 0x00000014002b7306ULL, 0x0002e20000200c00ULL,
0x000000202c20723cULL, 0x000fee00000018ffULL, 0x0000002900297306ULL, 0x000fe20000200c00ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x000fe2000000001aULL,
0x0000001c2c1c723cULL, 0x000fe200000018ffULL, 0x0000541034197816ULL, 0x000fc4000000001bULL,
0x0000541028287816ULL, 0x008fe2000000002bULL, 0x00000036002a7306ULL, 0x000e680000200c00ULL,
0x000000182c18723cULL, 0x000fe800000018ffULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x0000541029297816ULL, 0x002fce000000002aULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000000282c28723cULL, 0x000fee00000018ffULL, 0x0000001600337306ULL, 0x0002f00000200c00ULL,
0x0000003800387306ULL, 0x000f220000200c00ULL, 0x000000142c14723cULL, 0x002fe200000018ffULL,
0x0000541033307816ULL, 0x008fc40000000030ULL, 0x0000541038317816ULL, 0x010fce0000000031ULL,
0x000000302c2c723cULL, 0x000fe200000018ffULL, 0x013000005e30783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000431317232ULL, 0x080fe40000000000ULL, 0x0000000433337232ULL, 0x000fce0000000000ULL,
0x000000006134783bULL, 0x000f220000004200ULL, 0x0000006b6300720cULL, 0x080fe20003f66070ULL,
0x0000083000007945ULL, 0x000fe20003800000ULL, 0x000000045c007c0cULL, 0x000fe2000bfc3070ULL,
0x000000006038783bULL, 0x000f620000004200ULL, 0x0000006b6200720cULL, 0x000fe40003f86070ULL,
0x000000045c007c0cULL, 0x000fe4000bfa3070ULL, 0x00000018ff737819ULL, 0x010fe20000011434ULL,
0x0000010034557824ULL, 0x040fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011435ULL,
0x00000100356e7824ULL, 0x040fe200078e00ffULL, 0x0000888034547816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888035747816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff757819ULL, 0x000fe2000001146eULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011437ULL,
0x00000018ff717819ULL, 0x000fe40000011436ULL, 0x00000018ff6e7819ULL, 0x022fc40000011438ULL,
0x0000888038777816ULL, 0x000fe200000000ffULL, 0x0000003400347306ULL, 0x000e700000200c00ULL,
0x0000003500357306ULL, 0x000f220000200c00ULL, 0x0000541034347816ULL, 0x002fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000e640000200c00ULL,
0x000000343014723cULL, 0x008fec0000001814ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000010037347824ULL, 0x000fe200078e00ffULL, 0x0000541054547816ULL, 0x002fcc0000000055ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000018ff767819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fcc00078e00ffULL, 0x0000007300727306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541074557816ULL, 0x002fe20000000075ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x0000888037757816ULL, 0x000fc600000000ffULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe4000001143bULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000000183cULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000007400357306ULL, 0x0002e80000200c00ULL, 0x00000018ff557819ULL, 0x000fc40000011439ULL,
0x00000018ff547819ULL, 0x000fe4000001143aULL, 0x0000007500757306ULL, 0x000f220000200c00ULL,
0x0000888039747816ULL, 0x002fce00000000ffULL, 0x0000003400787306ULL, 0x0007f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541072347816ULL, 0x008fe40000000035ULL,
0x0000541075357816ULL, 0x010fca0000000076ULL, 0x0000007000707306ULL, 0x000fe40000200c00ULL,
0x000000343018723cULL, 0x000fec0000001818ULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000010038357824ULL, 0x000fe400078e00ffULL, 0x0000010039347824ULL, 0x000fc400078e00ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe20000011434ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe20000011438ULL, 0x0001000039387824ULL, 0x000fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000003500767306ULL, 0x0003f00000200c00ULL,
0x0000003400397306ULL, 0x0007e20000200c00ULL, 0x0000541037357816ULL, 0x002fc40000000070ULL,
0x000088803b707816ULL, 0x000fca00000000ffULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541078347816ULL, 0x008fe40000000071ULL, 0x000088803a717816ULL, 0x000fca00000000ffULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000034301c723cULL, 0x000fee000000181cULL,
0x000001003a357824ULL, 0x000fe200078e00ffULL, 0x0000006e006e7306ULL, 0x000ee20000200c00ULL,
0x000001003b347824ULL, 0x000fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff377819ULL, 0x000fe4000001143aULL, 0x00000018ff3b7819ULL, 0x000fca000001143bULL,
0x0000003800387306ULL, 0x000f300000200c00ULL, 0x0000003500727306ULL, 0x0003f00000200c00ULL,
0x0000003400737306ULL, 0x000be20000200c00ULL, 0x0000541074357816ULL, 0x002fce0000000075ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x0000541077347816ULL, 0x024fce0000000076ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x000000343020723cULL, 0x000fee0000001820ULL,
0x0000541039347816ULL, 0x008fe2000000006eULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541038357816ULL, 0x010fe20000000055ULL, 0x000000016b387836ULL, 0x000fca0000000000ULL,
0x000000386300720cULL, 0x080fe20005f66470ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x000000343024723cULL, 0x000fe20000001824ULL, 0x000000386200720cULL, 0x000fcc0006786470ULL,
0x0000003700377306ULL, 0x000ee20000200c00ULL, 0x0000541071347816ULL, 0x002fe40000000072ULL,
0x0000541070357816ULL, 0x004fca0000000073ULL, 0x0000003b003b7306ULL, 0x000e640000200c00ULL,
0x000000343028723cULL, 0x000fee0000001828ULL, 0x0000541037347816ULL, 0x008fe40000000054ULL,
0x000054103b357816ULL, 0x002fe20000000036ULL, 0x00000001ff367424ULL, 0x000fcc00078e00ffULL,
0x00000034302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x000000150e0e7221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8836ff1479a7ULL, 0x000e620008500006ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000045c007c0cULL, 0x000fe4000bfc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x000000045c007c0cULL, 0x000fe2000bfa3070ULL, 0x0000000217177836ULL, 0x000fe20000000000ULL,
0x00000040ff347803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000004171c7c11ULL, 0x000fe2000f8ff0ffULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ff001d7202ULL, 0x000fce0000000f00ULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000011c147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bfc6070ULL, 0x00000004005ce947ULL, 0x000fea0003800000ULL,
0x000000015b1d7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010187824ULL, 0x000fe400078e00ffULL, 0x0000004013217824ULL, 0x000fe200078e021dULL,
0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101d1e7824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x000000041c187824ULL, 0x000fe400078e021bULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x000000026c207836ULL, 0x000fc40000000000ULL,
0x0000004018187824ULL, 0x000fe400078e00ffULL, 0x000000015b277824ULL, 0x000fe200078e0220ULL,
0x0000000614197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0004e40000000800ULL, 0x0000000d18197c48ULL, 0x004fca000ffe0000ULL,
0x0000000119187824ULL, 0x000fe400078e0a18ULL, 0x000000011d197824ULL, 0x000fc600078e0210ULL,
0x000000185b187248ULL, 0x000fe40007fe0000ULL, 0xfffffff01e197812ULL, 0x000fc600078ee219ULL,
0x00000001181d7824ULL, 0x000fe200078e0a5bULL, 0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000221197836ULL, 0x000fe40000000000ULL, 0x0000000816177c24ULL, 0x008fc8000f8e0221ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d6c00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a08001f187984ULL, 0x000ea20000000800ULL, 0x0000000127167824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000421177836ULL, 0x000fc60000000000ULL,
0xfffffff027167812ULL, 0x000fc800078ee216ULL, 0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x0000001d2000720cULL, 0x000fe20003fc6070ULL, 0x000000046c207836ULL, 0x000fe40000000000ULL,
0x000000066c6c7836ULL, 0x000fe40000000000ULL, 0x000000015b277824ULL, 0x000fd000078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000f101c4eULL,
0x018a10001f167984ULL, 0x000ea20000000800ULL, 0x0000000127187824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000621197836ULL, 0x000fc60000000000ULL,
0xfffffff027187812ULL, 0x000fc800078ee218ULL, 0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d2000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a18001f187984ULL, 0x000ea40000000800ULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002314147210ULL, 0x000fc60007fde0ffULL,
0x0000000119167824ULL, 0x042fe400078e0210ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000001d6c00720cULL, 0x000fe20003fc6070ULL, 0x0000001019197824ULL, 0x000fca00078e00ffULL,
0xfffffff019167812ULL, 0x000fc800078ee216ULL, 0x0000000b16177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4eULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015b6c7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010197824ULL, 0x000fe400078e00ffULL,
0x00000040131f7824ULL, 0x000fe200078e026cULL, 0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000106c207824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000016c197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000026c257836ULL, 0x000fc40000000000ULL, 0xfffffff020197812ULL, 0x000fe400078ee219ULL,
0x0000000125207824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x000000021f197836ULL, 0x000fe40000000000ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe200078ee220ULL, 0x000000046c257836ULL, 0x000fe20000000000ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000816177c24ULL, 0x004fc8000f8e021fULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a08001e187984ULL, 0x000ea20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000041f177836ULL, 0x000fe40000000000ULL,
0x0000000125207824ULL, 0x040fe400078e0210ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe400078ee220ULL, 0x00000006181d7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001d187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4eULL, 0x018a10001e167984ULL, 0x000ea20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000061f197836ULL, 0x000fe20000000000ULL,
0x00000006161d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea40000000800ULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000066c197836ULL, 0x000fe20000000000ULL,
0x0000002114147210ULL, 0x000fc60007fde0ffULL, 0x00000001191d7824ULL, 0x040fe400078e0210ULL,
0x0000001019167824ULL, 0x002fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fc600030e0615ULL,
0xfffffff0161d7812ULL, 0x000fc800078ee21dULL, 0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5c00720cULL, 0x000fe20003fc4070ULL, 0x00009400000b7ab9ULL, 0x000fc60000000800ULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60007000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x000000015d177824ULL, 0x000fe400078e021aULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016187836ULL, 0x000fc80000000000ULL,
0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL, 0x000000016f177824ULL, 0x040fe400078e0216ULL,
0x000000016f167824ULL, 0x040fe200078e0218ULL, 0x000000066f6f7c11ULL, 0x000fe2000f8e10ffULL,
0x0000000417147825ULL, 0x002fc600078e0014ULL, 0x0000000d16007c0cULL, 0x000fda000bfc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a00000146f7faeULL, 0x0003e4000f12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b7870ff7079a7ULL, 0x000e620008500006ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000000ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6314037589ULL, 0x0004e800000e0000ULL, 0x00001f6214047589ULL, 0x00046400000e0000ULL,
0x01300000662c783bULL, 0x0004e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x088fe40000000000ULL, 0x000000032e2e7232ULL, 0x000fe40000000000ULL,
0x000000042d2d7232ULL, 0x082fe40000000000ULL, 0x000000042f2f7232ULL, 0x000fce0000000000ULL,
0x000000006518783bULL, 0x000f280000004200ULL, 0x000000006414783bULL, 0x004ea20000004200ULL,
0x0000010018207824ULL, 0x010fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011419ULL,
0x0000010019217824ULL, 0x040fe200078e00ffULL, 0x00008880193d7816ULL, 0x040fe200000000ffULL,
0x000100001a227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x000100001b237824ULL, 0x000fe200078e00ffULL, 0x0000002000397306ULL, 0x0009e20000200c00ULL,
0x00008880183c7816ULL, 0x000fc400000000ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff1f7819ULL, 0x000fe20000011418ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011419ULL, 0x00000021002a7306ULL, 0x000be20000200c00ULL,
0x000001001a207824ULL, 0x050fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141aULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x0000002200357306ULL, 0x0009e20000200c00ULL, 0x000001001b217824ULL, 0x028fe200078e00ffULL,
0x00000018ff247819ULL, 0x004fe40000011414ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141bULL,
0x000088801b367816ULL, 0x000fe400000000ffULL, 0x00000018ff327819ULL, 0x000fe40000011423ULL,
0x00000020001a7306ULL, 0x0007e20000200c00ULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff307819ULL, 0x000fe40000011416ULL, 0x0000888016287816ULL, 0x000fe200000000ffULL,
0x00000021001b7306ULL, 0x0009e20000200c00ULL, 0x0000888014207816ULL, 0x048fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x004fe20000000039ULL,
0x0001000017397824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000888017297816ULL, 0x000fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe40000011417ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000003d003d7306ULL, 0x000eb00000200c00ULL,
0x0000001900197306ULL, 0x000ee20000200c00ULL, 0x000054103d3d7816ULL, 0x004fce000000002aULL,
0x0000003600367306ULL, 0x000ea20000200c00ULL, 0x0000003c2c3c723cULL, 0x000fee00000018ffULL,
0x0000001400277306ULL, 0x0009f00000200c00ULL, 0x0000001500267306ULL, 0x000be20000200c00ULL,
0x0000010016147824ULL, 0x010fc400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000001e001e7306ULL, 0x000fe20000200c00ULL, 0x0000000817157819ULL, 0x022fc800000006ffULL,
0x00000018ff387819ULL, 0x000fc60000011415ULL, 0x00000014002b7306ULL, 0x0003f00000200c00ULL,
0x0000001c001c7306ULL, 0x000f220000200c00ULL, 0x0000541018147816ULL, 0x002fe4000000001fULL,
0x0000541019187816ULL, 0x008fc4000000001aULL, 0x0000541036197816ULL, 0x004fc6000000001bULL,
0x0000001d001d7306ULL, 0x000fe80000200c00ULL, 0x000000182c18723cULL, 0x000fe200000018ffULL,
0x00005410351c7816ULL, 0x010fc6000000001cULL, 0x0000002400247306ULL, 0x000e700000200c00ULL,
0x0000002500257306ULL, 0x000ea20000200c00ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003700377306ULL, 0x000e620000200c00ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003200327306ULL, 0x000ea20000200c00ULL, 0x000000242c24723cULL, 0x000fe200000018ffULL,
0x0000541037157816ULL, 0x002fcc000000001eULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x00005410321d7816ULL, 0x004fce000000001dULL, 0x0000002300237306ULL, 0x000e620000200c00ULL,
0x0000001c2c1c723cULL, 0x000fee00000018ffULL, 0x0000002100217306ULL, 0x000fe20000200c00ULL,
0x0000541020207816ULL, 0x002fce0000000023ULL, 0x0000002200227306ULL, 0x000e700000200c00ULL,
0x0000002800287306ULL, 0x000ea20000200c00ULL, 0x0000541021217816ULL, 0x002fce0000000022ULL,
0x0000002900297306ULL, 0x000fe20000200c00ULL, 0x000000202c20723cULL, 0x000fe200000018ffULL,
0x0000541028287816ULL, 0x004fcc000000002bULL, 0x00000038002a7306ULL, 0x000e700000200c00ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x0000541029297816ULL, 0x002fce000000002aULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x000000282c28723cULL, 0x000fee00000018ffULL,
0x0000001600337306ULL, 0x0002b00000200c00ULL, 0x0000003900367306ULL, 0x000ee20000200c00ULL,
0x000000142c14723cULL, 0x002fe200000018ffULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x0000541036317816ULL, 0x008fce0000000031ULL, 0x000000302c2c723cULL, 0x000fe200000018ffULL,
0x013000006730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000431317232ULL, 0x080fe40000000000ULL,
0x0000000433337232ULL, 0x000fce0000000000ULL, 0x000000ff3400720cULL, 0x000fe20003f45270ULL,
0x000000006838783bULL, 0x000ee20000004200ULL, 0x000007c000007945ULL, 0x000fe60003800000ULL,
0x000000006934783bULL, 0x000f220000004200ULL, 0x00000018ff6d7819ULL, 0x008fe40000011438ULL,
0x00000018ff737819ULL, 0x010fe20000011434ULL, 0x0000010034557824ULL, 0x040fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011435ULL, 0x00000100356c7824ULL, 0x040fe200078e00ffULL,
0x0000888034547816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888035747816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe2000001146cULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff6f7819ULL, 0x000fe40000011436ULL, 0x00000018ff6e7819ULL, 0x000fe40000011437ULL,
0x00000018ff6c7819ULL, 0x000fc60000011439ULL, 0x0000003400347306ULL, 0x000ef00000200c00ULL,
0x0000003500357306ULL, 0x000f220000200c00ULL, 0x0000541034347816ULL, 0x008fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000ee40000200c00ULL,
0x000000343014723cULL, 0x004fec0000001814ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000010037347824ULL, 0x040fe200078e00ffULL, 0x0000888037357816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fca00078e00ffULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x0000541054547816ULL, 0x008fe40000000055ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff377819ULL, 0x000fc60000011437ULL, 0x0000007300727306ULL, 0x0007e20000200c00ULL,
0x0000541074557816ULL, 0x004fe20000000075ULL, 0x0000010036747824ULL, 0x000fcc00078e00ffULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x0001000036367824ULL, 0x000fe400078e00ffULL,
0x0000010038737824ULL, 0x008fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000000183cULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000007400757306ULL, 0x000ea20000200c00ULL, 0x00000018ff737819ULL, 0x000fc60000011473ULL,
0x00000018ff557819ULL, 0x000fe4000001143aULL, 0x00000018ff547819ULL, 0x000fe4000001143bULL,
0x0000003400767306ULL, 0x0004f00000200c00ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000541072347816ULL, 0x004fc40000000075ULL, 0x0000888038727816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x0000888039757816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x008fe20000000076ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x000000343018723cULL, 0x000fe40000001818ULL,
0x0000003600367306ULL, 0x000fea0000200c00ULL, 0x0000010039347824ULL, 0x040fe400078e00ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x0000003700377306ULL, 0x000ea40000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff397819ULL, 0x000fc80000011439ULL,
0x0000003400767306ULL, 0x0007e20000200c00ULL, 0x0000541037357816ULL, 0x004fce000000006eULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x008fe2000000006fULL,
0x000001003a377824ULL, 0x040fe200078e00ffULL, 0x000088803a367816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000088803b6e7816ULL, 0x040fe400000000ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000007300777306ULL, 0x000fe20000200c00ULL,
0x00000034301c723cULL, 0x000fee000000181cULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x000001003b347824ULL, 0x000fc400078e00ffULL, 0x000100003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000541075357816ULL, 0x004fca0000000076ULL,
0x0000006c006c7306ULL, 0x000ff00000200c00ULL, 0x0000003800747306ULL, 0x0004f00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x00000018ff387819ULL, 0x004fce000001143aULL,
0x00000034006f7306ULL, 0x0005f00000200c00ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0000541072347816ULL, 0x004fce0000000077ULL, 0x0000003700737306ULL, 0x000ea20000200c00ULL,
0x000000343020723cULL, 0x000fee0000001820ULL, 0x0000006e006e7306ULL, 0x000f620000200c00ULL,
0x0000541074347816ULL, 0x008fe4000000006dULL, 0x0000541039357816ULL, 0x010fca000000006cULL,
0x0000005500557306ULL, 0x000fe40000200c00ULL, 0x000000343024723cULL, 0x000fec0000001824ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x004fe40000000073ULL,
0x000054106e357816ULL, 0x022fca000000006fULL, 0x0000003800387306ULL, 0x000e640000200c00ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x0000003b00377306ULL, 0x000ea20000200c00ULL,
0x0000541038347816ULL, 0x002fe40000000055ULL, 0x0000541037357816ULL, 0x004fce0000000054ULL,
0x00000034302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x000000150e0e7221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000016b6b7836ULL, 0x000fe40000000000ULL, 0x018b8816ff1479a7ULL, 0x000e660008500006ULL,
0x0000006a6b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffb00078a947ULL, 0x000fea000383ffffULL, 0x000000c0040b7891ULL, 0x000fe2000f8e403fULL,
0x018b6816ffff79a7ULL, 0x0003e60008500006ULL, 0x0000000d0b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f4f008ULL, 0x0000004c00902947ULL, 0x002fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x00000002ff147819ULL, 0x000fe4000001166bULL,
0x000000036b1a7812ULL, 0x040fe400078ec0ffULL, 0x000000146b147207ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60004000000ULL, 0x0000000314147836ULL, 0x000fca0000000000ULL,
0x00000003141c7812ULL, 0x040fe400078ec0ffULL, 0x00000004141b7c11ULL, 0x000fe4000f8ff0ffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b7871ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b7871ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011b147836ULL, 0x000fe20000000000ULL, 0x00000004ff6c7819ULL, 0x000fc80000011610ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x000000040060a947ULL, 0x000fea0003800000ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x000000041b167824ULL, 0x000fe200078e021cULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x00000010101d7824ULL, 0x000fe200078e00ffULL, 0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL,
0x000000026c227836ULL, 0x000fe20000000000ULL, 0x0000002016167811ULL, 0x000fe400078e30ffULL,
0x000000f01d217812ULL, 0x000fe200078ec0ffULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000d16177c48ULL, 0x000fe2000ffe0000ULL, 0x000000015b257824ULL, 0x000fc800078e0222ULL,
0x0000000117167824ULL, 0x000fe400078e0a16ULL, 0x0000000119177824ULL, 0x000fe400078e0220ULL,
0x0000000125247824ULL, 0x000fe200078e0210ULL, 0x000000165b167248ULL, 0x000fca0007fe0000ULL,
0x00000001161d7824ULL, 0x000fca00078e0a5bULL, 0x0000001d6c00720cULL, 0x000fe40003f46070ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e680000000a00ULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818177c24ULL, 0x004fc4000f8e0217ULL,
0x0000000119187824ULL, 0x000fe400078e0210ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff019187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fe400018e0617ULL,
0x0000000125197824ULL, 0x040fe200078e0220ULL, 0x0000000b18237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001025257824ULL, 0x000fc800078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d2200720cULL, 0x000fe20003f46070ULL,
0x000000046c227836ULL, 0x000fe20000000000ULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x018a08001f187984ULL, 0x000ea40000000800ULL, 0x000000015b257824ULL, 0x000fe200078e0222ULL,
0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fc60003f46070ULL, 0x018a10001f187984ULL, 0x000ea20000000800ULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002a40000000800ULL,
0x000000066c1e7836ULL, 0x002fc80000000000ULL, 0x000000015b257824ULL, 0x000fe400078e021eULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000000125207824ULL, 0x040fe200078e0210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x0000001d1e00720cULL, 0x000fe40003f46070ULL,
0x018a18001f187984ULL, 0x000ea40000000800ULL, 0xfffffff025207812ULL, 0x000fc800078ee220ULL,
0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4eULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x000000015b1f7824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x000000101f227824ULL, 0x040fe200078e00ffULL, 0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000011f177824ULL, 0x000fe200078e0220ULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000021f257836ULL, 0x000fc40000000000ULL, 0xfffffff022197812ULL, 0x000fe400078ee219ULL,
0x0000000125227824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe400078e0225ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025227812ULL, 0x000fe200078ee222ULL, 0x000000041f257836ULL, 0x000fe40000000000ULL,
0x000000061f1f7836ULL, 0x000fe20000000000ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a08001e187984ULL, 0x000ea20000000800ULL, 0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL,
0x0000000120177824ULL, 0x000fe400078e0225ULL, 0x0000000125227824ULL, 0x040fe400078e0210ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025227812ULL, 0x000fe400078ee222ULL,
0x00000006181d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ea20000000800ULL, 0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe400078e021fULL, 0x000000101f207824ULL, 0x000fe200078e00ffULL,
0x00000006161d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea40000000800ULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000011f197824ULL, 0x000fe200078e0210ULL,
0x0000002114147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff020197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000b19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x000000205f6f7824ULL, 0x000fe200078e0210ULL, 0x000000031a00780cULL, 0x000fe40003f65270ULL,
0x00000001001e7802ULL, 0x000fd60000000f00ULL, 0x00000000004ca947ULL, 0x000fea0001800000ULL,
0x000000036f00780cULL, 0x000fe20003f44070ULL, 0x0000000105057890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412167824ULL, 0x000fe200078e026fULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000517187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x000000011a157836ULL, 0x002fe20000000000ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000315167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16167207ULL, 0x000fc60005000000ULL, 0x00000002ff15a819ULL, 0x000fe40000011615ULL,
0x000000015d167824ULL, 0x000fc600078e0216ULL, 0x000000011c1c7824ULL, 0x000fe400078e0215ULL,
0x00009200ff147b82ULL, 0x000e640000000a00ULL, 0x000000401c177824ULL, 0x040fe200078e00ffULL,
0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c017187812ULL, 0x000fca00078ec0ffULL,
0x000001001b187824ULL, 0x000fc800078e0218ULL, 0x000000016f177824ULL, 0x100fe400078e0218ULL,
0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL, 0x0000000d17007c0cULL, 0x000fe2000bf46070ULL,
0x000000016f177824ULL, 0x000fc800078e0216ULL, 0x0000000417147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801eff1479a7ULL, 0x000e620008500006ULL, 0x000000ff6b00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018b381e5b1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018b38185b0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018b38185b0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001010077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011610ULL,
0x000000ffff167224ULL, 0x000fc600078e0008ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000006141b7c10ULL, 0x000fca000fffe007ULL,
0x018180001b157984ULL, 0x000e680000000800ULL, 0x018380001b147984ULL, 0x0004a20000000800ULL,
0x000000081500720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000081500720bULL, 0x000fe40003f54000ULL,
0x000000035f00780cULL, 0x000fe40003f65270ULL, 0x0000001508167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018580161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001608087221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x00000008001a7308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f631a087589ULL, 0x006e6400000e0000ULL,
0x000000080b0b7220ULL, 0x082fe20000410000ULL, 0x000000080a0a7220ULL, 0x080fe20000410000ULL,
0x000000080f0f7220ULL, 0x080fe20000410000ULL, 0x000000080e0e7220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x0000000842427220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000846467220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x000000084a4a7220ULL, 0x080fe20000410000ULL,
0x000000084d4d7220ULL, 0x080fe20000410000ULL, 0x000000084e4e7220ULL, 0x080fe20000410000ULL,
0x0000000851517220ULL, 0x080fe20000410000ULL, 0x0000000852527220ULL, 0x080fe20000410000ULL,
0x0000000857577220ULL, 0x080fe20000410000ULL, 0x0000000858587220ULL, 0x000fce0000410000ULL,
0x0000001a09097220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f621a087589ULL, 0x002e6400000e0000ULL, 0x000000080d0d7220ULL, 0x082fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000843437220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000847477220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x000000084b4b7220ULL, 0x080fe20000410000ULL,
0x000000084c4c7220ULL, 0x080fe20000410000ULL, 0x000000084f4f7220ULL, 0x080fe20000410000ULL,
0x0000000850507220ULL, 0x080fe20000410000ULL, 0x0000000853537220ULL, 0x080fe20000410000ULL,
0x0000000856567220ULL, 0x080fe20000410000ULL, 0x0000000859597220ULL, 0x080fe20000410000ULL,
0x000000085a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001615152221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL, 0x0000001500062308ULL, 0x000ea40000000800ULL,
0x0000000614142220ULL, 0x004fce0000410000ULL, 0x0000000914097221ULL, 0x000fe20000010000ULL,
0x000000ffff087224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000000ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6314037589ULL, 0x0002a800000e0000ULL,
0x00001f6214047589ULL, 0x0002e400000e0000ULL, 0x01380000052c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000032c2c7232ULL, 0x08cfe40000000000ULL,
0x000000032e2e7232ULL, 0x000fe40000000000ULL, 0x000000042d2d7232ULL, 0x080fe40000000000ULL,
0x000000042f2f7232ULL, 0x000fce0000000000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000010018207824ULL, 0x010fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe20000011419ULL, 0x0000010019217824ULL, 0x040fe200078e00ffULL,
0x00008880193d7816ULL, 0x040fe200000000ffULL, 0x000100001a227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x000100001b237824ULL, 0x000fe200078e00ffULL,
0x0000002000397306ULL, 0x0009e20000200c00ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000017387824ULL, 0x002fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fc40000011419ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141aULL, 0x00000018ff1d7819ULL, 0x000fe2000001141bULL,
0x00000021002a7306ULL, 0x0003e20000200c00ULL, 0x000001001a207824ULL, 0x050fe200078e00ffULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x000088801b347816ULL, 0x040fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002200357306ULL, 0x0009e20000200c00ULL,
0x000001001b217824ULL, 0x002fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fc40000011423ULL,
0x00000018ff247819ULL, 0x000fe40000011414ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000020001a7306ULL, 0x0003e20000200c00ULL, 0x0000010014227824ULL, 0x050fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011415ULL, 0x00000018ff1f7819ULL, 0x000fe40000011418ULL,
0x00000018ff237819ULL, 0x000fe20000011422ULL, 0x0000010015227824ULL, 0x000fe200078e00ffULL,
0x00000021001b7306ULL, 0x0009e20000200c00ULL, 0x0000888014207816ULL, 0x042fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00008880183c7816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fc40000011416ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000888016287816ULL, 0x000fe400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001400277306ULL, 0x0009e20000200c00ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x0000888017297816ULL, 0x000fe400000000ffULL,
0x00000018ff317819ULL, 0x000fe40000011417ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000001500267306ULL, 0x000be20000200c00ULL, 0x0000010016147824ULL, 0x050fe200078e00ffULL,
0x000054103d3d7816ULL, 0x002fe2000000002aULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x028fe200078e00ffULL, 0x0000001f001f7306ULL, 0x000fe80000200c00ULL,
0x00000018ff367819ULL, 0x000fc80000011415ULL, 0x0000001800187306ULL, 0x000ff00000200c00ULL,
0x0000001900197306ULL, 0x000ff00000200c00ULL, 0x0000001e001e7306ULL, 0x000ff00000200c00ULL,
0x0000001c001c7306ULL, 0x000e700000200c00ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000200c00ULL,
0x0000002500257306ULL, 0x000ee20000200c00ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x0000541026257816ULL, 0x008fce0000000025ULL,
0x0000003700377306ULL, 0x000ee20000200c00ULL, 0x000000242c24723cULL, 0x000fe200000018ffULL,
0x000054103c3c7816ULL, 0x002fcc0000000039ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x0000003c2c3c723cULL, 0x000fe200000018ffULL, 0x0000541037157816ULL, 0x008fcc000000001eULL,
0x0000003200327306ULL, 0x000e700000200c00ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x00005410321d7816ULL, 0x002fce000000001dULL, 0x0000002300237306ULL, 0x000e700000200c00ULL,
0x0000002100217306ULL, 0x000fe20000200c00ULL, 0x0000541020207816ULL, 0x002fce0000000023ULL,
0x0000002200227306ULL, 0x000e700000200c00ULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x0000541021217816ULL, 0x002fce0000000022ULL, 0x00000014002b7306ULL, 0x0002e20000200c00ULL,
0x000000202c20723cULL, 0x000fee00000018ffULL, 0x0000002900297306ULL, 0x000fe20000200c00ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x000fe2000000001aULL,
0x0000001c2c1c723cULL, 0x000fe200000018ffULL, 0x0000541034197816ULL, 0x000fc4000000001bULL,
0x0000541028287816ULL, 0x008fe2000000002bULL, 0x00000036002a7306ULL, 0x000e680000200c00ULL,
0x000000182c18723cULL, 0x000fe800000018ffULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x0000541029297816ULL, 0x002fce000000002aULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000000282c28723cULL, 0x000fee00000018ffULL, 0x0000001600337306ULL, 0x0002f00000200c00ULL,
0x0000003800387306ULL, 0x000f220000200c00ULL, 0x000000142c14723cULL, 0x002fe200000018ffULL,
0x0000541033307816ULL, 0x008fc40000000030ULL, 0x0000541038317816ULL, 0x010fce0000000031ULL,
0x000000302c2c723cULL, 0x000fe200000018ffULL, 0x013800005e30783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000431317232ULL, 0x080fe40000000000ULL, 0x0000000433337232ULL, 0x000fce0000000000ULL,
0x000000006134783bULL, 0x000f220000004200ULL, 0x0000006b6300720cULL, 0x080fe20003f66070ULL,
0x0000083000007945ULL, 0x000fe20003800000ULL, 0x000000045c007c0cULL, 0x000fe2000bfc3070ULL,
0x000000006038783bULL, 0x000f620000004200ULL, 0x0000006b6200720cULL, 0x000fe40003f86070ULL,
0x000000045c007c0cULL, 0x000fe4000bfa3070ULL, 0x00000018ff737819ULL, 0x010fe20000011434ULL,
0x0000010034557824ULL, 0x040fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011435ULL,
0x00000100356e7824ULL, 0x040fe200078e00ffULL, 0x0000888034547816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888035747816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff757819ULL, 0x000fe2000001146eULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011437ULL,
0x00000018ff717819ULL, 0x000fe40000011436ULL, 0x00000018ff6e7819ULL, 0x022fc40000011438ULL,
0x0000888038777816ULL, 0x000fe200000000ffULL, 0x0000003400347306ULL, 0x000e700000200c00ULL,
0x0000003500357306ULL, 0x000f220000200c00ULL, 0x0000541034347816ULL, 0x002fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000e640000200c00ULL,
0x000000343014723cULL, 0x008fec0000001814ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000010037347824ULL, 0x000fe200078e00ffULL, 0x0000541054547816ULL, 0x002fcc0000000055ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000018ff767819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fcc00078e00ffULL, 0x0000007300727306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541074557816ULL, 0x002fe20000000075ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x0000888037757816ULL, 0x000fc600000000ffULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe4000001143bULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000000183cULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000007400357306ULL, 0x0002e80000200c00ULL, 0x00000018ff557819ULL, 0x000fc40000011439ULL,
0x00000018ff547819ULL, 0x000fe4000001143aULL, 0x0000007500757306ULL, 0x000f220000200c00ULL,
0x0000888039747816ULL, 0x002fce00000000ffULL, 0x0000003400787306ULL, 0x0007f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541072347816ULL, 0x008fe40000000035ULL,
0x0000541075357816ULL, 0x010fca0000000076ULL, 0x0000007000707306ULL, 0x000fe40000200c00ULL,
0x000000343018723cULL, 0x000fec0000001818ULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000010038357824ULL, 0x000fe400078e00ffULL, 0x0000010039347824ULL, 0x000fc400078e00ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe20000011434ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe20000011438ULL, 0x0001000039387824ULL, 0x000fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000003500767306ULL, 0x0003f00000200c00ULL,
0x0000003400397306ULL, 0x0007e20000200c00ULL, 0x0000541037357816ULL, 0x002fc40000000070ULL,
0x000088803b707816ULL, 0x000fca00000000ffULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541078347816ULL, 0x008fe40000000071ULL, 0x000088803a717816ULL, 0x000fca00000000ffULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000034301c723cULL, 0x000fee000000181cULL,
0x000001003a357824ULL, 0x000fe200078e00ffULL, 0x0000006e006e7306ULL, 0x000ee20000200c00ULL,
0x000001003b347824ULL, 0x000fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff377819ULL, 0x000fe4000001143aULL, 0x00000018ff3b7819ULL, 0x000fca000001143bULL,
0x0000003800387306ULL, 0x000f300000200c00ULL, 0x0000003500727306ULL, 0x0003f00000200c00ULL,
0x0000003400737306ULL, 0x000be20000200c00ULL, 0x0000541074357816ULL, 0x002fce0000000075ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x0000541077347816ULL, 0x024fce0000000076ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x000000343020723cULL, 0x000fee0000001820ULL,
0x0000541039347816ULL, 0x008fe2000000006eULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541038357816ULL, 0x010fe20000000055ULL, 0x000000016b387836ULL, 0x000fca0000000000ULL,
0x000000386300720cULL, 0x080fe20005f66470ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x000000343024723cULL, 0x000fe20000001824ULL, 0x000000386200720cULL, 0x000fcc0006786470ULL,
0x0000003700377306ULL, 0x000ee20000200c00ULL, 0x0000541071347816ULL, 0x002fe40000000072ULL,
0x0000541070357816ULL, 0x004fca0000000073ULL, 0x0000003b003b7306ULL, 0x000e640000200c00ULL,
0x000000343028723cULL, 0x000fee0000001828ULL, 0x0000541037347816ULL, 0x008fe40000000054ULL,
0x000054103b357816ULL, 0x002fe20000000036ULL, 0x00000001ff367424ULL, 0x000fcc00078e00ffULL,
0x00000034302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x000000150e0e7221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8836ff1479a7ULL, 0x000e620008500006ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000045c007c0cULL, 0x000fe4000bfc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x000000045c007c0cULL, 0x000fe2000bfa3070ULL, 0x0000000317177836ULL, 0x000fe20000000000ULL,
0x00000040ff347803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000004171c7c11ULL, 0x000fe2000f8ff0ffULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000011c147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bfc6070ULL, 0x00000004005ce947ULL, 0x000fea0003800000ULL,
0x000000015b1d7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010187824ULL, 0x000fe400078e00ffULL, 0x0000004013217824ULL, 0x000fe200078e021dULL,
0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101d1e7824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x000000041c187824ULL, 0x000fe400078e021bULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x000000026c207836ULL, 0x000fc40000000000ULL,
0x0000004018187824ULL, 0x000fe400078e00ffULL, 0x000000015b277824ULL, 0x000fe200078e0220ULL,
0x0000000614197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0004e40000000800ULL, 0x0000000d18197c48ULL, 0x004fca000ffe0000ULL,
0x0000000119187824ULL, 0x000fe400078e0a18ULL, 0x000000011d197824ULL, 0x000fc600078e0210ULL,
0x000000185b187248ULL, 0x000fe40007fe0000ULL, 0xfffffff01e197812ULL, 0x000fc600078ee219ULL,
0x00000001181d7824ULL, 0x000fe200078e0a5bULL, 0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000221197836ULL, 0x000fe40000000000ULL, 0x0000000816177c24ULL, 0x008fc8000f8e0221ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d6c00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a08001f187984ULL, 0x000ea20000000800ULL, 0x0000000127167824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000421177836ULL, 0x000fc60000000000ULL,
0xfffffff027167812ULL, 0x000fc800078ee216ULL, 0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x0000001d2000720cULL, 0x000fe20003fc6070ULL, 0x000000046c207836ULL, 0x000fe40000000000ULL,
0x000000066c6c7836ULL, 0x000fc60000000000ULL, 0x000000205b277210ULL, 0x000fce0007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000f101c4eULL,
0x018a10001f167984ULL, 0x000ea20000000800ULL, 0x0000000127187824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000621197836ULL, 0x000fc60000000000ULL,
0xfffffff027187812ULL, 0x000fc800078ee218ULL, 0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d2000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a18001f187984ULL, 0x000ea40000000800ULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002314147210ULL, 0x000fc60007fde0ffULL,
0x0000000119167824ULL, 0x042fe400078e0210ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000001d6c00720cULL, 0x000fe20003fc6070ULL, 0x0000001019197824ULL, 0x000fca00078e00ffULL,
0xfffffff019167812ULL, 0x000fc800078ee216ULL, 0x0000000b16177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4eULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015b6c7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010197824ULL, 0x000fe400078e00ffULL,
0x00000040131f7824ULL, 0x000fe200078e026cULL, 0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000106c207824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000016c197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000026c257836ULL, 0x000fc40000000000ULL, 0xfffffff020197812ULL, 0x000fe400078ee219ULL,
0x0000000125207824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x000000021f197836ULL, 0x000fe40000000000ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe200078ee220ULL, 0x000000046c257836ULL, 0x000fe20000000000ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000816177c24ULL, 0x004fc8000f8e021fULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a08001e187984ULL, 0x000ea20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000041f177836ULL, 0x000fe40000000000ULL,
0x0000000125207824ULL, 0x040fe400078e0210ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe400078ee220ULL, 0x00000006181d7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001d187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4eULL, 0x018a10001e167984ULL, 0x000ea20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000061f197836ULL, 0x000fe20000000000ULL,
0x00000006161d7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea40000000800ULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000066c197836ULL, 0x000fe20000000000ULL,
0x0000002114147210ULL, 0x000fc60007fde0ffULL, 0x00000001191d7824ULL, 0x040fe400078e0210ULL,
0x0000001019167824ULL, 0x002fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fc600030e0615ULL,
0xfffffff0161d7812ULL, 0x000fc800078ee21dULL, 0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5c00720cULL, 0x000fe20003fc4070ULL, 0x00009400000b7ab9ULL, 0x000fc60000000800ULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60007000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x000000015d177824ULL, 0x000fe400078e021aULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016187836ULL, 0x000fc80000000000ULL,
0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL, 0x000000016f177824ULL, 0x040fe400078e0216ULL,
0x000000016f167824ULL, 0x040fe200078e0218ULL, 0x000000066f6f7c11ULL, 0x000fe2000f8e10ffULL,
0x0000000417147825ULL, 0x002fc600078e0014ULL, 0x0000000d16007c0cULL, 0x000fda000bfc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a00000146f7faeULL, 0x0003e4000f12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b7870ff7079a7ULL, 0x000e620008500006ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000000ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6314037589ULL, 0x0004e800000e0000ULL, 0x00001f6214047589ULL, 0x00046400000e0000ULL,
0x01380000662c783bULL, 0x0004e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x088fe40000000000ULL, 0x000000032e2e7232ULL, 0x000fe40000000000ULL,
0x000000042d2d7232ULL, 0x082fe40000000000ULL, 0x000000042f2f7232ULL, 0x000fce0000000000ULL,
0x000000006518783bULL, 0x000f280000004200ULL, 0x000000006414783bULL, 0x004ea20000004200ULL,
0x0000010018207824ULL, 0x010fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011419ULL,
0x0000010019217824ULL, 0x040fe200078e00ffULL, 0x00008880193d7816ULL, 0x040fe200000000ffULL,
0x000100001a227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x000100001b237824ULL, 0x000fe200078e00ffULL, 0x0000002000397306ULL, 0x0009e20000200c00ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x00008880183c7816ULL, 0x040fe400000000ffULL,
0x00000018ff1f7819ULL, 0x000fe20000011418ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011419ULL, 0x00000021002a7306ULL, 0x000be20000200c00ULL,
0x000001001a207824ULL, 0x050fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141aULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x0000002200357306ULL, 0x0009e20000200c00ULL, 0x000001001b217824ULL, 0x028fe200078e00ffULL,
0x00000018ff247819ULL, 0x004fe40000011414ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141bULL,
0x000088801b367816ULL, 0x000fe400000000ffULL, 0x00000018ff327819ULL, 0x000fe40000011423ULL,
0x00000020001a7306ULL, 0x0007e20000200c00ULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff307819ULL, 0x000fe40000011416ULL, 0x0000888016287816ULL, 0x000fe200000000ffULL,
0x00000021001b7306ULL, 0x0009e20000200c00ULL, 0x0000888014207816ULL, 0x048fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x004fe20000000039ULL,
0x0001000017397824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000888017297816ULL, 0x000fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe40000011417ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000003d003d7306ULL, 0x000eb00000200c00ULL,
0x0000001900197306ULL, 0x000ee20000200c00ULL, 0x000054103d3d7816ULL, 0x004fce000000002aULL,
0x0000003600367306ULL, 0x000ea20000200c00ULL, 0x0000003c2c3c723cULL, 0x000fee00000018ffULL,
0x0000001400277306ULL, 0x0009f00000200c00ULL, 0x0000001500267306ULL, 0x000be20000200c00ULL,
0x0000010016147824ULL, 0x010fc400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x022fe200078e00ffULL, 0x00000014002b7306ULL, 0x0003e80000200c00ULL,
0x00000018ff387819ULL, 0x000fc80000011415ULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x008fe4000000001aULL,
0x0000541036197816ULL, 0x004fc6000000001bULL, 0x0000001c001c7306ULL, 0x000e680000200c00ULL,
0x000000182c18723cULL, 0x000fe800000018ffULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000200c00ULL,
0x0000002500257306ULL, 0x000ea20000200c00ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003700377306ULL, 0x000e620000200c00ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003200327306ULL, 0x000ea20000200c00ULL, 0x000000242c24723cULL, 0x000fe200000018ffULL,
0x0000541037157816ULL, 0x002fcc000000001eULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x00005410321d7816ULL, 0x004fce000000001dULL, 0x0000002300237306ULL, 0x000e620000200c00ULL,
0x0000001c2c1c723cULL, 0x000fee00000018ffULL, 0x0000002100217306ULL, 0x000fe20000200c00ULL,
0x0000541020207816ULL, 0x002fce0000000023ULL, 0x0000002200227306ULL, 0x000e700000200c00ULL,
0x0000002800287306ULL, 0x000ea20000200c00ULL, 0x0000541021217816ULL, 0x002fce0000000022ULL,
0x0000002900297306ULL, 0x000fe20000200c00ULL, 0x000000202c20723cULL, 0x000fe200000018ffULL,
0x0000541028287816ULL, 0x004fcc000000002bULL, 0x00000038002a7306ULL, 0x000e700000200c00ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x0000541029297816ULL, 0x002fce000000002aULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x000000282c28723cULL, 0x000fee00000018ffULL,
0x0000001600337306ULL, 0x0002b00000200c00ULL, 0x0000003900367306ULL, 0x000ee20000200c00ULL,
0x000000142c14723cULL, 0x002fe200000018ffULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x0000541036317816ULL, 0x008fce0000000031ULL, 0x000000302c2c723cULL, 0x000fe200000018ffULL,
0x013800006730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000431317232ULL, 0x080fe40000000000ULL,
0x0000000433337232ULL, 0x000fce0000000000ULL, 0x000000ff3400720cULL, 0x000fe20003f45270ULL,
0x000000006838783bULL, 0x000ee20000004200ULL, 0x000007c000007945ULL, 0x000fe60003800000ULL,
0x000000006934783bULL, 0x000f220000004200ULL, 0x00000018ff6d7819ULL, 0x008fe40000011438ULL,
0x00000018ff737819ULL, 0x010fe20000011434ULL, 0x0000010034557824ULL, 0x040fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011435ULL, 0x00000100356c7824ULL, 0x040fe200078e00ffULL,
0x0000888034547816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888035747816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe2000001146cULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff6f7819ULL, 0x000fe40000011436ULL, 0x00000018ff6e7819ULL, 0x000fe40000011437ULL,
0x00000018ff6c7819ULL, 0x000fc60000011439ULL, 0x0000003400347306ULL, 0x000ef00000200c00ULL,
0x0000003500357306ULL, 0x000f220000200c00ULL, 0x0000541034347816ULL, 0x008fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000ee40000200c00ULL,
0x000000343014723cULL, 0x004fec0000001814ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000010037347824ULL, 0x040fe200078e00ffULL, 0x0000888037357816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fca00078e00ffULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x0000541054547816ULL, 0x008fe40000000055ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff377819ULL, 0x000fc60000011437ULL, 0x0000007300727306ULL, 0x0007e20000200c00ULL,
0x0000541074557816ULL, 0x004fe20000000075ULL, 0x0000010036747824ULL, 0x000fcc00078e00ffULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x0001000036367824ULL, 0x000fe400078e00ffULL,
0x0000010038737824ULL, 0x008fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000000183cULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000007400757306ULL, 0x000ea20000200c00ULL, 0x00000018ff737819ULL, 0x000fc60000011473ULL,
0x00000018ff557819ULL, 0x000fe4000001143aULL, 0x00000018ff547819ULL, 0x000fe4000001143bULL,
0x0000003400767306ULL, 0x0004f00000200c00ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000541072347816ULL, 0x004fc40000000075ULL, 0x0000888038727816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x0000888039757816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x008fe20000000076ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x000000343018723cULL, 0x000fe40000001818ULL,
0x0000003600367306ULL, 0x000fea0000200c00ULL, 0x0000010039347824ULL, 0x040fe400078e00ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x0000003700377306ULL, 0x000ea40000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff397819ULL, 0x000fc80000011439ULL,
0x0000003400767306ULL, 0x0007e20000200c00ULL, 0x0000541037357816ULL, 0x004fce000000006eULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x008fe2000000006fULL,
0x000001003a377824ULL, 0x040fe200078e00ffULL, 0x000088803a367816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000088803b6e7816ULL, 0x040fe400000000ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000007300777306ULL, 0x000fe20000200c00ULL,
0x00000034301c723cULL, 0x000fee000000181cULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x000001003b347824ULL, 0x000fc400078e00ffULL, 0x000100003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000541075357816ULL, 0x004fca0000000076ULL,
0x0000006c006c7306ULL, 0x000ff00000200c00ULL, 0x0000003800747306ULL, 0x0004f00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x00000018ff387819ULL, 0x004fce000001143aULL,
0x00000034006f7306ULL, 0x0005f00000200c00ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0000541072347816ULL, 0x004fce0000000077ULL, 0x0000003700737306ULL, 0x000ea20000200c00ULL,
0x000000343020723cULL, 0x000fee0000001820ULL, 0x0000006e006e7306ULL, 0x000f620000200c00ULL,
0x0000541074347816ULL, 0x008fe4000000006dULL, 0x0000541039357816ULL, 0x010fca000000006cULL,
0x0000005500557306ULL, 0x000fe40000200c00ULL, 0x000000343024723cULL, 0x000fec0000001824ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x004fe40000000073ULL,
0x000054106e357816ULL, 0x022fca000000006fULL, 0x0000003800387306ULL, 0x000e640000200c00ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x0000003b00377306ULL, 0x000ea20000200c00ULL,
0x0000541038347816ULL, 0x002fe40000000055ULL, 0x0000541037357816ULL, 0x004fce0000000054ULL,
0x00000034302c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x000000150e0e7221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000016b6b7836ULL, 0x000fe40000000000ULL, 0x018b8816ff1479a7ULL, 0x000e660008500006ULL,
0x0000006a6b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffb00078a947ULL, 0x000fea000383ffffULL, 0x018b7016ffff79a7ULL, 0x0003e40008500006ULL,
0x0000000104047890ULL, 0x000fc8000fffe03fULL, 0x000000100400728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0xfffffec000748947ULL, 0x000fea000383ffffULL,
0x00000010ff007c0cULL, 0x000fe2000bf05270ULL, 0x000000ffff147224ULL, 0x000fe400078e0011ULL,
0x000000ffff107224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000cULL,
0x000000ffff0d7224ULL, 0x000fcc00078e000aULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000009007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x00015bd000047802ULL, 0x002fce0000000f00ULL,
0x0000008800407944ULL, 0x004fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00cfc80000000009ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009a00ff027b82ULL, 0x000f240000000a00ULL,
0x0000000e02037981ULL, 0x010f22000c1e9900ULL, 0x0000000000057919ULL, 0x002e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000000b040b7220ULL, 0x042fe20000410000ULL,
0x0000000d040d7220ULL, 0x040fe20000410000ULL, 0x0000000f040f7220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000004204427220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004604467220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000004a044a7220ULL, 0x040fe20000410000ULL, 0x0000004d044d7220ULL, 0x040fe20000410000ULL,
0x0000004e044e7220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000005204527220ULL, 0x040fe20000410000ULL, 0x0000005704577220ULL, 0x040fe20000410000ULL,
0x0000005804587220ULL, 0x000fe20000410000ULL, 0x0000001005107220ULL, 0x044fe20000410000ULL,
0x0000001105117220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000004005407220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000004405447220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004805487220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000004c054c7220ULL, 0x040fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000005005507220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000005605567220ULL, 0x040fe20000410000ULL, 0x0000005905597220ULL, 0x040fe20000410000ULL,
0x0000005a055a7220ULL, 0x000fce0000410000ULL, 0x0000000000167919ULL, 0x002e620000000000ULL,
0x000000065f5f7c11ULL, 0x000fe2000f8e58ffULL, 0x00000000000479c3ULL, 0x000ee20000002600ULL,
0x0000004d4e4d723eULL, 0x000fce00000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000515251723eULL, 0x000fe400000000ffULL, 0x000000575857723eULL, 0x000fe400000000ffULL,
0x000000434443723eULL, 0x000fc400000000ffULL, 0x000000474847723eULL, 0x000fe400000000ffULL,
0x0000004b4c4b723eULL, 0x000fe400000000ffULL, 0x0000004f504f723eULL, 0x000fe400000000ffULL,
0x000000535653723eULL, 0x000fe400000000ffULL, 0x000000595a59723eULL, 0x000fe400000000ffULL,
0x000054104b4e7816ULL, 0x000fc4000000004fULL, 0x000076324b4f7816ULL, 0x000fe4000000004fULL,
0x0000541053587816ULL, 0x100fe40000000059ULL, 0x00000002ff077819ULL, 0x002fe40000011616ULL,
0x0000000216007812ULL, 0x040fe400078ec0ffULL, 0x0000000816057811ULL, 0x000fe200078ff0ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x044fe200078ff8ffULL,
0x0000000807087824ULL, 0x000fe200078e00ffULL, 0x0000000500037211ULL, 0x000fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe20007ffe0ffULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000763253597816ULL, 0x000fe20000000059ULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL,
0x0000000402037836ULL, 0x000fe20000000000ULL, 0xfffffff805067812ULL, 0x000fc400078ee200ULL,
0x00000003ff057819ULL, 0x100fe40000011616ULL, 0xfffffff809007812ULL, 0x000fe200078ee202ULL,
0x0000000602027836ULL, 0x000fe20000000000ULL, 0xfffffff808087812ULL, 0x000fe200078ee203ULL,
0x0000000105047824ULL, 0x000fe400078e0216ULL, 0x000120005f037836ULL, 0x000fe20000000000ULL,
0xfffffff8070a7812ULL, 0x000fe200078ee202ULL, 0x0000000816027824ULL, 0x000fe200078e00ffULL,
0x0000000704077812ULL, 0x000fe200078ec0ffULL, 0x0000001000047824ULL, 0x000fc400078e0203ULL,
0x000000100c0c7824ULL, 0x100fe200078e0203ULL, 0x0ffffff807007812ULL, 0x000fe200078ef816ULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x0000000716167812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe400078e0203ULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0x0000000802037812ULL, 0x000fe200078ec0ffULL, 0x00000010005f7824ULL, 0x000fe200078e025fULL,
0x0000000b0d00723eULL, 0x000fe400000000ffULL, 0x0000000f0e02723eULL, 0x000fe200000000ffULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x1ffffff8165b7812ULL, 0x000fe200078ef85bULL,
0x0000000103067824ULL, 0x040fe200078e0206ULL, 0x00005410000e7816ULL, 0x040fe20000000002ULL,
0x00000001030c7824ULL, 0x040fe200078e020cULL, 0x00007632000f7816ULL, 0x000fe20000000002ULL,
0x0000000103087824ULL, 0x040fe200078e0208ULL, 0x000000414200723eULL, 0x000fe200000000ffULL,
0x00000001030a7824ULL, 0x000fe200078e020aULL, 0x000000454602723eULL, 0x000fe200000000ffULL,
0x0000000e04007388ULL, 0x0003e20000000a00ULL, 0x000000494a03723eULL, 0x000fc400000000ffULL,
0x0000541043467816ULL, 0x140fe40000000047ULL, 0x0000763243477816ULL, 0x000fe40000000047ULL,
0x00005410000e7816ULL, 0x142fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x000000101100723eULL, 0x000fe400000000ffULL, 0x000000144002723eULL, 0x000fe200000000ffULL,
0x0000000e06007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x002fc4000000004dULL,
0x00007632030f7816ULL, 0x000fca000000004dULL, 0x0000000e08007388ULL, 0x0003e40000000a00ULL,
0x00005410510e7816ULL, 0x142fe40000000057ULL, 0x00007632510f7816ULL, 0x000fca0000000057ULL,
0x0000000e0a007388ULL, 0x0003e40000000a00ULL, 0x00005410000e7816ULL, 0x142fe40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x00008400ff007b82ULL, 0x000e660000000800ULL,
0x0000000e0c007388ULL, 0x000fe80000000a00ULL, 0x0004004606007388ULL, 0x000fe80000000a00ULL,
0x0004004e08007388ULL, 0x000fe80000000a00ULL, 0x000400580a007388ULL, 0x000fe20000000a00ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x012000005f0c7984ULL, 0x000ea20000000c00ULL,
0x0000000012127224ULL, 0x082fe400078e02ffULL, 0x0000000405057e24ULL, 0x008fe2000f8e0200ULL,
0x0000860000047ab9ULL, 0x000fc80000000a00ULL, 0x0000000512057211ULL, 0x000fca00078010ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x0000000405027c11ULL, 0x000fc8000f8048ffULL,
0x0000000505037c11ULL, 0x000fc600080f4c00ULL, 0x000000105b027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x004fe2000c101d0eULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000030300780cULL, 0x000fe20003f44070ULL, 0x00009200ff087b82ULL, 0x000e620000000a00ULL,
0x000000405f487824ULL, 0x040fe200078e00ffULL, 0x0000940000087ab9ULL, 0x000fe20000000800ULL,
0x0000002003057836ULL, 0x000fe20000000000ULL, 0x000000065f467c11ULL, 0x000fe2000f8e40ffULL,
0x000000085d007c24ULL, 0x000fe4000f8e0248ULL, 0x0000000148067824ULL, 0x040fe200078e0203ULL,
0x00009a00ff0c7b82ULL, 0x000ea20000000a00ULL, 0x00000001480f7824ULL, 0x000fc400078e0205ULL,
0x0000000100077824ULL, 0x100fe200078e0203ULL, 0x0000000d06007c0cULL, 0x000fe2000bf06070ULL,
0x000000041202a824ULL, 0x000fe200078e0203ULL, 0x0000000d0f007c0cULL, 0x000fe2000bf26070ULL,
0x0000000100057824ULL, 0x000fe200078e0205ULL, 0x00009000ff04ab82ULL, 0x000ee20000000800ULL,
0x000000020200a824ULL, 0x000fe200078e00ffULL, 0x000000075f00ac0cULL, 0x000fe2000bf66070ULL,
0x00000004030f7824ULL, 0x000fe400078e0246ULL, 0x0000000407067825ULL, 0x002fc600078e0008ULL,
0x00008c00ff0aab82ULL, 0x000e620000000a00ULL, 0x0000000405087825ULL, 0x000fc800078e0008ULL,
0x000000040005a224ULL, 0x008fe200078e025fULL, 0x000000065f00ac11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff047424ULL, 0x000fc800078e00ffULL, 0x000000040311a824ULL, 0x000fe400078e0200ULL,
0x0000000e0c007981ULL, 0x004522000c1e9900ULL, 0x00000004050aa825ULL, 0x002fe400078e000aULL,
0x018ad004ff0479a7ULL, 0x000ea20008500006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18600000060f7faeULL, 0x0005e8000c12184eULL, 0x18680000080f7faeULL, 0x0005e8000c92184eULL,
0x18a800000a11afaeULL, 0x0005e8000d92184eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000001ff0500788cULL, 0x000fcc000bf04070ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000001000a40947ULL, 0x004fea0003800000ULL,
0x00000003ff027819ULL, 0x100fe40000011603ULL, 0x000000065f087c11ULL, 0x000fe4000f8e20ffULL,
0x0000000d480d7c48ULL, 0x000fe2000ffe0000ULL, 0x0000000402097824ULL, 0x000fe200078e0246ULL,
0x000000700e047812ULL, 0x000fe200078ec0ffULL, 0x00000040130a7824ULL, 0x000fe200078e0202ULL,
0x000000065f0c7c11ULL, 0x000fe2000f8e70ffULL, 0x0000000102117824ULL, 0x000fe200078e0203ULL,
0x0186000009077984ULL, 0x000e620000000800ULL, 0x000000010d0d7824ULL, 0x000fc600078e0a48ULL,
0x0000000711147812ULL, 0x000fe400078ec0ffULL, 0x0000000d0200720cULL, 0x000fe40003f06070ULL,
0x0ffffff814147812ULL, 0x000fe200078ef803ULL, 0x0000000407107824ULL, 0x002fe400078e0208ULL,
0x00008a00ff067b82ULL, 0x000e660000000a00ULL, 0x018a8000100b7984ULL, 0x000ea40000000800ULL,
0x000000040b0b7c24ULL, 0x004fc8000f8e020aULL, 0x000001000b0e7825ULL, 0x002fc800078e0006ULL,
0x000020000c0b7836ULL, 0x000fe20000000000ULL, 0x0000000e04107210ULL, 0x000fe20007f3e0ffULL,
0x00000004020c7836ULL, 0x000fe40000000000ULL, 0x0000001014157824ULL, 0x000fe400078e020bULL,
0x000000ffff117224ULL, 0x000fe400008e060fULL, 0x000000010c147824ULL, 0x040fe400078e0203ULL,
0x000000080c177824ULL, 0x040fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000008020c7836ULL, 0x000fc40000000000ULL, 0x01861000090f7984ULL, 0x000ea20000000800ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000080c177824ULL, 0x000fc800078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000040a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x0000000c020c7836ULL, 0x000fe40000000000ULL,
0x01862000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000080a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000010020c7836ULL, 0x000fe40000000000ULL,
0x01863000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x0000000c0a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000014020c7836ULL, 0x000fe40000000000ULL,
0x01864000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000100a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000018020c7836ULL, 0x000fe40000000000ULL,
0x01865000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000140a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x0000001c020c7836ULL, 0x000fe40000000000ULL,
0x01866000090f7984ULL, 0x000ea60000000800ULL, 0x000000030c177819ULL, 0x000fe200000006ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000180a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000020020c7836ULL, 0x000fe40000000000ULL,
0x01867000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x0000001c0a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000024020c7836ULL, 0x000fe40000000000ULL,
0x01868000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000200a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000028020c7836ULL, 0x000fe40000000000ULL,
0x01869000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000240a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x0000002c020c7836ULL, 0x000fe40000000000ULL,
0x0186a000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000280a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000030020c7836ULL, 0x000fe40000000000ULL,
0x0186b000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x0000002c0a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000034020c7836ULL, 0x000fe40000000000ULL,
0x0186c000090f7984ULL, 0x000ea40000000800ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fca00078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000300a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000038020c7836ULL, 0x000fe40000000000ULL,
0x0186d000090f7984ULL, 0x000ea20000000800ULL, 0x0000003c02027836ULL, 0x000fe40000000000ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fc400078e0203ULL, 0x0000000102037824ULL, 0x000fc600078e0203ULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000340a0f7836ULL, 0x000fc60000000000ULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e04107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fc60003f06070ULL, 0x0186e000090f7984ULL, 0x000ea20000000800ULL,
0x0000001014117824ULL, 0x002fe400078e020bULL, 0x0000003c0a157836ULL, 0x000fe40000000000ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000380a0f7836ULL, 0x000fe40000000000ULL,
0x00000008020a7824ULL, 0x000fe200078e00ffULL, 0x018a8000160e7984ULL, 0x000e640000000800ULL,
0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc600078e0006ULL,
0x0000000e040e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e2000c101c4eULL,
0x0000000d0200720cULL, 0x000fc60003f06070ULL, 0x0186f00009097984ULL, 0x000ea40000000800ULL,
0x0000000409087824ULL, 0x004fcc00078e0208ULL, 0x018a800008087984ULL, 0x000ea40000000800ULL,
0x0000000408157c24ULL, 0x004fc8000f8e0215ULL, 0x0000010015067825ULL, 0x000fc600078e0006ULL,
0x0000000604027210ULL, 0x000fe40007f3e0ffULL, 0xfffffff80a047812ULL, 0x000fc600078ee203ULL,
0x000000ffff037224ULL, 0x000fe400008e0607ULL, 0x00000010040b7824ULL, 0x000fca00078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e2000c101c4eULL,
0x0000001000587947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x100fe40000011603ULL,
0x000000065f087c11ULL, 0x040fe4000f8e20ffULL, 0x000000065f0f7c11ULL, 0x000fe2000f8e70ffULL,
0x00000004040b7824ULL, 0x040fe400078e0246ULL, 0x00000040130a7824ULL, 0x000fe400078e0204ULL,
0x0000000104027824ULL, 0x000fe200078e0203ULL, 0x018600000b077984ULL, 0x000e680000000800ULL,
0x0000000702147812ULL, 0x000fe200078ec0ffULL, 0x000020000f027836ULL, 0x000fc60000000000ULL,
0x0ffffff814117812ULL, 0x000fca00078ef803ULL, 0x0000001011157824ULL, 0x000fe400078e0202ULL,
0x0000000407107824ULL, 0x002fe400078e0208ULL, 0x00008a00ff067b82ULL, 0x000e660000000a00ULL,
0x018a800010097984ULL, 0x0004e40000000800ULL, 0x0000000404107836ULL, 0x004fc80000000000ULL,
0x0000000110117824ULL, 0x040fe400078e0203ULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x0000000409097c24ULL, 0x008fc8000f8e020aULL, 0x00000100090c7825ULL, 0x002fe200078e0006ULL,
0x000000700e097812ULL, 0x000fc800078ec0ffULL, 0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e8000b901c4eULL, 0x018610000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff8160f7812ULL, 0x002fe200078ee211ULL, 0x00000008040e7836ULL, 0x000fc80000000000ULL,
0x000000100f157824ULL, 0x000fe400078e0202ULL, 0x000000010e0f7824ULL, 0x040fe400078e0203ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000040a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff117224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e8000b901c4eULL,
0x018620000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff816117812ULL, 0x002fe200078ee20fULL,
0x0000000c04107836ULL, 0x000fc80000000000ULL, 0x0000001011157824ULL, 0x000fe400078e0202ULL,
0x0000000110117824ULL, 0x040fe400078e0203ULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000080a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e8000b901c4eULL, 0x018630000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff8160f7812ULL, 0x002fe200078ee211ULL, 0x00000010040e7836ULL, 0x000fc60000000000ULL,
0x000000020f157211ULL, 0x000fe200078e20ffULL, 0x000000010e0f7824ULL, 0x040fe400078e0203ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x0000000c0a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff117224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e8000b901c4eULL,
0x018640000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff816117812ULL, 0x002fe200078ee20fULL,
0x0000001404107836ULL, 0x000fc80000000000ULL, 0x0000001011157824ULL, 0x000fe400078e0202ULL,
0x0000000110117824ULL, 0x040fe400078e0203ULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000100a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e8000b901c4eULL, 0x018650000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff8160f7812ULL, 0x002fe200078ee211ULL, 0x00000018040e7836ULL, 0x000fc80000000000ULL,
0x000000100f157824ULL, 0x000fe400078e0202ULL, 0x000000010e0f7824ULL, 0x040fe400078e0203ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000140a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff117224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e8000b901c4eULL,
0x018660000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff816117812ULL, 0x002fe200078ee20fULL,
0x0000001c04107836ULL, 0x000fc80000000000ULL, 0x0000001011157824ULL, 0x000fe400078e0202ULL,
0x0000000110117824ULL, 0x040fe400078e0203ULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000180a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e8000b901c4eULL, 0x018670000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff8160f7812ULL, 0x002fe200078ee211ULL, 0x00000020040e7836ULL, 0x000fc80000000000ULL,
0x000000100f157824ULL, 0x000fe400078e0202ULL, 0x000000010e0f7824ULL, 0x040fe400078e0203ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x0000001c0a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff117224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e8000b901c4eULL,
0x018680000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff816117812ULL, 0x002fe200078ee20fULL,
0x0000002404107836ULL, 0x000fc80000000000ULL, 0x0000001011157824ULL, 0x000fe400078e0202ULL,
0x0000000110117824ULL, 0x040fe400078e0203ULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000200a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e8000b901c4eULL, 0x018690000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff8160f7812ULL, 0x002fe200078ee211ULL, 0x00000028040e7836ULL, 0x000fc80000000000ULL,
0x000000100f157824ULL, 0x000fe400078e0202ULL, 0x000000010e0f7824ULL, 0x040fe400078e0203ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000240a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff117224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e8000b901c4eULL,
0x0186a0000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff816117812ULL, 0x002fe200078ee20fULL,
0x0000002c04107836ULL, 0x000fc80000000000ULL, 0x0000001011157824ULL, 0x000fe400078e0202ULL,
0x0000000110117824ULL, 0x040fe400078e0203ULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000280a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e8000b901c4eULL, 0x0186b0000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff8160f7812ULL, 0x002fe200078ee211ULL, 0x00000030040e7836ULL, 0x000fc80000000000ULL,
0x000000100f157824ULL, 0x000fe400078e0202ULL, 0x000000010e0f7824ULL, 0x040fe400078e0203ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x0000002c0a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff117224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e8000b901c4eULL,
0x0186c0000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff816117812ULL, 0x002fe200078ee20fULL,
0x0000003404107836ULL, 0x000fc80000000000ULL, 0x0000001011157824ULL, 0x000fe400078e0202ULL,
0x0000000110117824ULL, 0x040fe400078e0203ULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000300a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e8000b901c4eULL, 0x0186d0000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff8160f7812ULL, 0x002fca00078ee211ULL, 0x000000100f0f7824ULL, 0x000fe400078e0202ULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000340a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x0002a40000000800ULL, 0x0000003804147836ULL, 0x002fe40000000000ULL,
0x0000003c04047836ULL, 0x000fe40000000000ULL, 0x0000000114157824ULL, 0x140fe400078e0203ULL,
0x0000000814147824ULL, 0x000fe400078e00ffULL, 0x0000000104037824ULL, 0x000fc400078e0203ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0xfffffff814157812ULL, 0x000fc800078ee215ULL,
0xfffffff804037812ULL, 0x000fe200078ee203ULL, 0x0000001015157824ULL, 0x000fc800078e0202ULL,
0x0000001003037824ULL, 0x000fe400078e0202ULL, 0x000000040c0d7c24ULL, 0x004fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e8000b901c4eULL, 0x0186e0000b0d7984ULL, 0x000ea20000000800ULL,
0x0000003c0a0f7836ULL, 0x002fe40000000000ULL, 0x000000040d0e7824ULL, 0x004fe400078e0208ULL,
0x000000380a0d7836ULL, 0x000fc60000000000ULL, 0x018a80000e0c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c157faeULL, 0x0003e8000b901c4eULL,
0x0186f0000b0b7984ULL, 0x000ea40000000800ULL, 0x000000040b087824ULL, 0x004fcc00078e0208ULL,
0x018a800008087984ULL, 0x000ea40000000800ULL, 0x00000004080f7c24ULL, 0x004fc8000f8e020fULL,
0x000001000f067825ULL, 0x000fc600078e0006ULL, 0x0000000906067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e6000b901c4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000027805ULL, 0x002fce0000015200ULL,
0x018ad005ff0075a7ULL, 0x000e640008000146ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0000000602097210ULL, 0x000fc80007f1e1ffULL, 0x0000000703077210ULL, 0x000fe400007fe5ffULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011407ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000204047819ULL, 0x000fc80000001207ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x018ad005ff0075a7ULL, 0x000e640008000146ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x000000205f027824ULL, 0x002fca00078e0202ULL, 0x00000003ff037819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe03037812ULL, 0x000fc600078ec0ffULL,
0x0000000102047836ULL, 0x000fe40000000000ULL, 0x0000000102057824ULL, 0x040fe400078e0203ULL,
0x0000000103067824ULL, 0x000fe400078e0204ULL, 0x0000002002077824ULL, 0x040fe200078e00ffULL,
0x0000001f05057812ULL, 0x000fe200078ec0ffULL, 0x0000002002087824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fe200078ec0ffULL, 0x0000001003037836ULL, 0x000fc60000000000ULL,
0x000001e007067812ULL, 0x000fe200078ee206ULL, 0x0000000102077824ULL, 0x100fe200078e0203ULL,
0x000001e008057812ULL, 0x000fe200078ee205ULL, 0x0000000104037824ULL, 0x000fe200078e0203ULL,
0x0000000606067c11ULL, 0x000fe2000f8e20ffULL, 0x0000002002047824ULL, 0x040fe200078e00ffULL,
0x0000000605057c11ULL, 0x000fe2000f8e20ffULL, 0x0000002002027824ULL, 0x000fe200078e00ffULL,
0x0000001f03037812ULL, 0x000fe200078ec0ffULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000001f07077812ULL, 0x000fc400078ec0ffULL, 0x000001e002037812ULL, 0x000fe200078ee203ULL,
0x00000000050c7984ULL, 0x000ea20000000c00ULL, 0x000001e004077812ULL, 0x000fe200078ee207ULL,
0x00000001ff027424ULL, 0x000fe200078e00ffULL, 0x0000000603047c11ULL, 0x000fe4000f8e20ffULL,
0x0000000607077c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff167224ULL, 0x002fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff147224ULL, 0x004fc400078e000cULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fe200078e000bULL, 0x0000001405007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fca00078e000fULL,
0x0000001806007388ULL, 0x000fe80000000c00ULL, 0x0000000004087984ULL, 0x000e680000000c00ULL,
0x00000000070c7984ULL, 0x000ea20000000c00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000aULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1c7224ULL, 0x004fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000001c07007388ULL, 0x0003e80000000c00ULL, 0x0000000804007388ULL, 0x0003e20000000c00ULL,
0x018ad002ff0279a7ULL, 0x000ea40008500006ULL, 0x000000ffff067224ULL, 0x006fce00078e0003ULL,
0x0000000000027805ULL, 0x000fce0000015200ULL, 0x018ad006ff0075a7ULL, 0x000e640008000146ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fce0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x018ad006ff0075a7ULL, 0x000e640008000146ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000010ff007c0cULL, 0x000fda000bf05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x3d80000000007820ULL, 0x010fe20000410000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000065f447c11ULL, 0x040fe2000f8e18ffULL,
0x000000ffff437224ULL, 0x000fe200078e00ffULL, 0x00000006040b7899ULL, 0x000fe2000800063fULL,
0x00000000001272caULL, 0x000fe200000e0000ULL, 0x000000ffff027224ULL, 0x000fe200078e005fULL,
0x000000065f007c11ULL, 0x000fe2000f8e28ffULL, 0xffffffff10117890ULL, 0x000fe2000fffe03fULL,
0x0000003f00047c82ULL, 0x000fd60008000000ULL, 0x0000010043597824ULL, 0x000fca00078e0248ULL,
0x0000000d59007c0cULL, 0x000fda000bf01070ULL, 0x000000000000894dULL, 0x00afea0003800000ULL,
0x00000001ff617424ULL, 0x000fe200078e00ffULL, 0x000000435c00720cULL, 0x000fe20003f44070ULL,
0x0000003f00057c82ULL, 0x000fc60008000000ULL, 0x0000000461617807ULL, 0x000fd20001000000ULL,
0x000000ffff647224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fc4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000005000a7c82ULL, 0x000fe20008000000ULL,
0x0000000400087c82ULL, 0x000fca0008000000ULL, 0x0000000164287836ULL, 0x000fe20000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000005282a7c11ULL, 0x040fe2000f8ff8ffULL,
0x0000000108047892ULL, 0x000fe2000f8e0c3fULL, 0x000000ffff607224ULL, 0x000fe200078e0064ULL,
0x000000022800780cULL, 0x000fe20003f06070ULL, 0x000000ffff647224ULL, 0x000fe200078e0028ULL,
0x000000032a387812ULL, 0x000fe400078ec0ffULL, 0x00000002ff2aa819ULL, 0x000fe4000001162aULL,
0x0000000128367812ULL, 0x000fe400078ec0ffULL, 0x000000ff38387207ULL, 0x000fe20005000000ULL,
0x000000012a377824ULL, 0x000fc800078e0243ULL, 0x0000000137297836ULL, 0x000fca0000000000ULL,
0x0000001029007c0cULL, 0x000fe2000bf26070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000001000749947ULL, 0x000fea0003800000ULL, 0x00000003ff3c7819ULL, 0x002fe20000011603ULL,
0x00000100373b7824ULL, 0x000fe200078e0248ULL, 0x000000065f3a7c11ULL, 0x040fe2000f8e20ffULL,
0x00000008365e7824ULL, 0x000fe200078e00ffULL, 0x000000065f2a7c11ULL, 0x000fe2000f8e70ffULL,
0x000000043c3e7824ULL, 0x000fe400078e0246ULL, 0x00000040133d7824ULL, 0x000fe200078e023cULL,
0x000000002a0c72caULL, 0x000fe400000e0000ULL, 0x018600003e297984ULL, 0x000e620000000800ULL,
0x0000000d3b2a7c48ULL, 0x000fc4000ffe0000ULL, 0xfffffff85e397812ULL, 0x000fe200078ee203ULL,
0x000000043c5e7836ULL, 0x000fe40000000000ULL, 0x000000012a3b7824ULL, 0x000fe400078e0a3bULL,
0x000000013c2a7824ULL, 0x100fe400078e0203ULL, 0x000000015e627824ULL, 0x000fe200078e0203ULL,
0x0000000c04097291ULL, 0x000fe2000f8e683fULL, 0x0000003b3c00720cULL, 0x000fe20003f26070ULL,
0x000000085e637824ULL, 0x000fc400078e00ffULL, 0x0000200009097890ULL, 0x000fe2000fffe03fULL,
0x0000000429347824ULL, 0x002fe400078e023aULL, 0x00008a00ff287b82ULL, 0x000e680000000a00ULL,
0x018a800034347984ULL, 0x000ea40000000800ULL, 0x0000000b342b7c24ULL, 0x004fe2000f8e023dULL,
0x000000072a347812ULL, 0x000fc600078ec0ffULL, 0x000001002b2a7825ULL, 0x002fe200078e0028ULL,
0x0ffffff834347812ULL, 0x000fc800078ef803ULL, 0x00000009343f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b5e00720cULL, 0x000fe20003f26070ULL,
0x000000083c5e7836ULL, 0x000fe40000000000ULL, 0x018610003e357984ULL, 0x000ea20000000800ULL,
0xfffffff8633f7812ULL, 0x002fe200078ee262ULL, 0x000000015e627824ULL, 0x040fe400078e0203ULL,
0x000000085e637824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004355b7824ULL, 0x004fc400078e023aULL, 0x000000043d357836ULL, 0x000fc60000000000ULL,
0x018a80005b347984ULL, 0x000e640000000800ULL, 0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0028ULL, 0x0000001039347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b5e00720cULL, 0x000fe20003f26070ULL, 0x0000000c3c5e7836ULL, 0x000fe40000000000ULL,
0x018620003e2b7984ULL, 0x000ea20000000800ULL, 0xfffffff8633f7812ULL, 0x002fe200078ee262ULL,
0x000000015e627824ULL, 0x040fe400078e0203ULL, 0x000000085e637824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b5b7824ULL, 0x004fc400078e023aULL,
0x000000083d2b7836ULL, 0x000fc60000000000ULL, 0x018a80005b2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b5e00720cULL, 0x000fe20003f26070ULL,
0x000000103c5e7836ULL, 0x000fe40000000000ULL, 0x018630003e357984ULL, 0x000ea20000000800ULL,
0xfffffff8633f7812ULL, 0x002fe200078ee262ULL, 0x000000015e627824ULL, 0x040fe400078e0203ULL,
0x000000085e637824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004355b7824ULL, 0x004fc400078e023aULL, 0x0000000c3d357836ULL, 0x000fc60000000000ULL,
0x018a80005b347984ULL, 0x000e640000000800ULL, 0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0028ULL, 0x0000001039347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b5e00720cULL, 0x000fe20003f26070ULL, 0x000000143c5e7836ULL, 0x000fe40000000000ULL,
0x018640003e2b7984ULL, 0x000ea20000000800ULL, 0xfffffff8633f7812ULL, 0x002fe200078ee262ULL,
0x000000015e627824ULL, 0x040fe400078e0203ULL, 0x000000085e637824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b5b7824ULL, 0x004fc400078e023aULL,
0x000000103d2b7836ULL, 0x000fc60000000000ULL, 0x018a80005b2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b5e00720cULL, 0x000fe20003f26070ULL,
0x000000183c5e7836ULL, 0x000fe40000000000ULL, 0x018650003e357984ULL, 0x000ea20000000800ULL,
0xfffffff8633f7812ULL, 0x002fe200078ee262ULL, 0x000000015e627824ULL, 0x040fe400078e0203ULL,
0x000000085e637824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004355b7824ULL, 0x004fc400078e023aULL, 0x000000143d357836ULL, 0x000fc60000000000ULL,
0x018a80005b347984ULL, 0x000e640000000800ULL, 0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0028ULL, 0x0000001039347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b5e00720cULL, 0x000fe20003f26070ULL, 0x0000001c3c5e7836ULL, 0x000fe40000000000ULL,
0x018660003e2b7984ULL, 0x000ea20000000800ULL, 0xfffffff8633f7812ULL, 0x002fe200078ee262ULL,
0x000000015e627824ULL, 0x040fe200078e0203ULL, 0x000000035e637819ULL, 0x000fe400000006ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b5b7824ULL, 0x004fc400078e023aULL,
0x000000183d2b7836ULL, 0x000fc60000000000ULL, 0x018a80005b2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b5e00720cULL, 0x000fe20003f26070ULL,
0x000000203c5e7836ULL, 0x000fe40000000000ULL, 0x018670003e357984ULL, 0x000ea20000000800ULL,
0xfffffff8633f7812ULL, 0x002fe200078ee262ULL, 0x000000015e627824ULL, 0x040fe400078e0203ULL,
0x000000085e637824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004355b7824ULL, 0x004fc400078e023aULL, 0x0000001c3d357836ULL, 0x000fc60000000000ULL,
0x018a80005b347984ULL, 0x000e640000000800ULL, 0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0028ULL, 0x0000001039347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b5e00720cULL, 0x000fe20003f26070ULL, 0x000000243c5e7836ULL, 0x000fe40000000000ULL,
0x018680003e2b7984ULL, 0x000ea20000000800ULL, 0xfffffff8633f7812ULL, 0x002fe200078ee262ULL,
0x000000015e627824ULL, 0x040fe400078e0203ULL, 0x000000085e637824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b5b7824ULL, 0x004fc400078e023aULL,
0x000000203d2b7836ULL, 0x000fc60000000000ULL, 0x018a80005b2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b5e00720cULL, 0x000fe20003f26070ULL,
0x000000283c5e7836ULL, 0x000fe40000000000ULL, 0x018690003e357984ULL, 0x000ea20000000800ULL,
0xfffffff8633f7812ULL, 0x002fe200078ee262ULL, 0x000000015e627824ULL, 0x040fe400078e0203ULL,
0x000000085e637824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004355b7824ULL, 0x004fc400078e023aULL, 0x000000243d357836ULL, 0x000fc60000000000ULL,
0x018a80005b347984ULL, 0x000e640000000800ULL, 0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0028ULL, 0x0000001039347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b5e00720cULL, 0x000fe20003f26070ULL, 0x0000002c3c5e7836ULL, 0x000fe40000000000ULL,
0x0186a0003e2b7984ULL, 0x000ea20000000800ULL, 0xfffffff8633f7812ULL, 0x002fe200078ee262ULL,
0x000000015e627824ULL, 0x040fe400078e0203ULL, 0x000000085e637824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b5b7824ULL, 0x004fc400078e023aULL,
0x000000283d2b7836ULL, 0x000fc60000000000ULL, 0x018a80005b2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b5e00720cULL, 0x000fe20003f26070ULL,
0x000000303c5e7836ULL, 0x000fe40000000000ULL, 0x0186b0003e357984ULL, 0x000ea20000000800ULL,
0xfffffff8633f7812ULL, 0x002fe200078ee262ULL, 0x000000015e627824ULL, 0x040fe400078e0203ULL,
0x000000085e637824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004355b7824ULL, 0x004fc400078e023aULL, 0x0000002c3d357836ULL, 0x000fc60000000000ULL,
0x018a80005b347984ULL, 0x000e640000000800ULL, 0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0028ULL, 0x0000001039347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b5e00720cULL, 0x000fe20003f26070ULL, 0x000000343c5e7836ULL, 0x000fe40000000000ULL,
0x0186c0003e2b7984ULL, 0x000ea20000000800ULL, 0xfffffff8633f7812ULL, 0x002fe200078ee262ULL,
0x000000015e627824ULL, 0x040fe400078e0203ULL, 0x000000085e637824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b5b7824ULL, 0x004fc400078e023aULL,
0x000000303d2b7836ULL, 0x000fc60000000000ULL, 0x018a80005b2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b5e00720cULL, 0x000fe20003f26070ULL,
0x000000383c5e7836ULL, 0x000fe40000000000ULL, 0x0186d0003e357984ULL, 0x000ea20000000800ULL,
0x0000003c3c3c7836ULL, 0x000fe20000000000ULL, 0xfffffff8633f7812ULL, 0x002fe200078ee262ULL,
0x000000015e627824ULL, 0x040fe400078e0203ULL, 0x000000085e637824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004355b7824ULL, 0x004fc400078e023aULL,
0x000000343d357836ULL, 0x000fc60000000000ULL, 0x018a80005b347984ULL, 0x000e640000000800ULL,
0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000001039347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000343f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b5e00720cULL, 0x000fe20003f26070ULL,
0x000000083c5e7824ULL, 0x000fe400078e00ffULL, 0x0186e0003e2b7984ULL, 0x000ea20000000800ULL,
0xfffffff863357812ULL, 0x002fc800078ee262ULL, 0x0000000935357c11ULL, 0x000fe2000f8e20ffULL,
0x000000042b5b7824ULL, 0x004fe400078e023aULL, 0x000000383d2b7836ULL, 0x000fe40000000000ULL,
0x0000003c3d3d7836ULL, 0x000fe20000000000ULL, 0x018a80005b2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0003e2000c901c4eULL, 0x0000003b3c00720cULL, 0x000fc60003f26070ULL,
0x0186f0003e3f7984ULL, 0x000ea40000000800ULL, 0x000000043f347824ULL, 0x004fe400078e023aULL,
0x000000013c3f7824ULL, 0x000fc800078e0203ULL, 0x018a800034347984ULL, 0x000ea20000000800ULL,
0xfffffff85e2b7812ULL, 0x002fc800078ee23fULL, 0x000000092b2b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b343d7c24ULL, 0x004fc8000f8e023dULL, 0x000001003d287825ULL, 0x000fc800078e0028ULL,
0x0000001039287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e2000c901c4eULL, 0x0000001000247947ULL, 0x000fea0003800000ULL,
0x00000003ff3c7819ULL, 0x102fe20000011603ULL, 0x00000008363e7824ULL, 0x000fe200078e00ffULL,
0x000000065f3a7c11ULL, 0x040fe4000f8e20ffULL, 0x000000065f2b7c11ULL, 0x000fe2000f8e70ffULL,
0x000000043c3d7824ULL, 0x040fe200078e0246ULL, 0xfffffff83e397812ULL, 0x000fe200078ee203ULL,
0x00000040133b7824ULL, 0x000fe200078e023cULL, 0x000000002b0c72caULL, 0x000fe200000e0000ULL,
0x000000013c347824ULL, 0x000fe200078e0203ULL, 0x018600003d297984ULL, 0x000e620000000800ULL,
0x000000043c5e7836ULL, 0x000fc60000000000ULL, 0x0000000734347812ULL, 0x000fe200078ec0ffULL,
0x000000015e5b7824ULL, 0x040fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fe200078e00ffULL,
0x0ffffff834347812ULL, 0x000fc600078ef803ULL, 0x0000000c04097291ULL, 0x000fe2000f8e683fULL,
0xfffffff85e5b7812ULL, 0x000fe200078ee25bULL, 0x000000083c5e7836ULL, 0x000fe40000000000ULL,
0x0000200009097890ULL, 0x000fcc000fffe03fULL, 0x00000009343f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000095b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004292a7824ULL, 0x002fe400078e023aULL,
0x00008a00ff287b82ULL, 0x000e680000000a00ULL, 0x018a80002a2a7984ULL, 0x000ea40000000800ULL,
0x0000000b2a2b7c24ULL, 0x004fc8000f8e023bULL, 0x000001002b2a7825ULL, 0x002fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c4eULL, 0x018610003d357984ULL, 0x000ea20000000800ULL,
0x000000015e3f7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e3f7812ULL, 0x000fe200078ee23fULL, 0x0000000c3c5e7836ULL, 0x000fc60000000000ULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004353e7824ULL, 0x004fe400078e023aULL,
0x000000043b357836ULL, 0x000fc60000000000ULL, 0x018a80003e347984ULL, 0x000e640000000800ULL,
0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000001039347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345b7faeULL, 0x0003e8000b901c4eULL, 0x018620003d2b7984ULL, 0x000ea20000000800ULL,
0x000000015e5b7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e5b7812ULL, 0x000fe200078ee25bULL, 0x000000103c5e7836ULL, 0x000fc60000000000ULL,
0x000000095b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b3e7824ULL, 0x004fe400078e023aULL,
0x000000083b2b7836ULL, 0x000fc60000000000ULL, 0x018a80003e2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c4eULL, 0x018630003d357984ULL, 0x000ea20000000800ULL,
0x000000015e3f7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e3f7812ULL, 0x000fe200078ee23fULL, 0x000000143c5e7836ULL, 0x000fc60000000000ULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004353e7824ULL, 0x004fe400078e023aULL,
0x0000000c3b357836ULL, 0x000fc60000000000ULL, 0x018a80003e347984ULL, 0x000e640000000800ULL,
0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000001039347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345b7faeULL, 0x0003e8000b901c4eULL, 0x018640003d2b7984ULL, 0x000ea20000000800ULL,
0x000000015e5b7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e5b7812ULL, 0x000fe200078ee25bULL, 0x000000183c5e7836ULL, 0x000fc60000000000ULL,
0x000000095b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b3e7824ULL, 0x004fe400078e023aULL,
0x000000103b2b7836ULL, 0x000fc60000000000ULL, 0x018a80003e2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c4eULL, 0x018650003d357984ULL, 0x000ea20000000800ULL,
0x000000015e3f7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e3f7812ULL, 0x000fe200078ee23fULL, 0x0000001c3c5e7836ULL, 0x000fc60000000000ULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004353e7824ULL, 0x004fe400078e023aULL,
0x000000143b357836ULL, 0x000fc60000000000ULL, 0x018a80003e347984ULL, 0x000e640000000800ULL,
0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000001039347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345b7faeULL, 0x0003e8000b901c4eULL, 0x018660003d2b7984ULL, 0x000ea20000000800ULL,
0x000000015e5b7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e5b7812ULL, 0x000fe200078ee25bULL, 0x000000203c5e7836ULL, 0x000fc60000000000ULL,
0x000000095b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b3e7824ULL, 0x004fe400078e023aULL,
0x000000183b2b7836ULL, 0x000fc60000000000ULL, 0x018a80003e2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c4eULL, 0x018670003d357984ULL, 0x000ea20000000800ULL,
0x000000015e3f7824ULL, 0x042fe200078e0203ULL, 0x000000035e5e7819ULL, 0x000fc800000006ffULL,
0xfffffff85e3f7812ULL, 0x000fe200078ee23fULL, 0x000000243c5e7836ULL, 0x000fc60000000000ULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004353e7824ULL, 0x004fe400078e023aULL,
0x0000001c3b357836ULL, 0x000fc60000000000ULL, 0x018a80003e347984ULL, 0x000e640000000800ULL,
0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000001039347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345b7faeULL, 0x0003e8000b901c4eULL, 0x018680003d2b7984ULL, 0x000ea20000000800ULL,
0x000000015e5b7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e5b7812ULL, 0x000fe200078ee25bULL, 0x000000283c5e7836ULL, 0x000fc60000000000ULL,
0x000000095b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b3e7824ULL, 0x004fe400078e023aULL,
0x000000203b2b7836ULL, 0x000fc60000000000ULL, 0x018a80003e2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c4eULL, 0x018690003d357984ULL, 0x000ea20000000800ULL,
0x000000015e3f7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e3f7812ULL, 0x000fe200078ee23fULL, 0x0000002c3c5e7836ULL, 0x000fc60000000000ULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004353e7824ULL, 0x004fe400078e023aULL,
0x000000243b357836ULL, 0x000fc60000000000ULL, 0x018a80003e347984ULL, 0x000e640000000800ULL,
0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000001039347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345b7faeULL, 0x0003e8000b901c4eULL, 0x0186a0003d2b7984ULL, 0x000ea20000000800ULL,
0x000000015e5b7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e5b7812ULL, 0x000fe200078ee25bULL, 0x000000303c5e7836ULL, 0x000fc60000000000ULL,
0x000000095b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000042b3e7824ULL, 0x004fe400078e023aULL,
0x000000283b2b7836ULL, 0x000fc60000000000ULL, 0x018a80003e2a7984ULL, 0x000e640000000800ULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c4eULL, 0x0186b0003d357984ULL, 0x000ea20000000800ULL,
0x000000015e3f7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e3f7812ULL, 0x000fe200078ee23fULL, 0x000000343c5e7836ULL, 0x000fc60000000000ULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004353e7824ULL, 0x004fe400078e023aULL,
0x0000002c3b357836ULL, 0x000fc60000000000ULL, 0x018a80003e347984ULL, 0x000e640000000800ULL,
0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000001039347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345b7faeULL, 0x0003e8000b901c4eULL, 0x0186c0003d2b7984ULL, 0x000ea20000000800ULL,
0x000000015e5b7824ULL, 0x042fe400078e0203ULL, 0x000000085e5e7824ULL, 0x000fca00078e00ffULL,
0xfffffff85e5b7812ULL, 0x000fe200078ee25bULL, 0x000000383c5e7836ULL, 0x000fe40000000000ULL,
0x0000003c3c3c7836ULL, 0x000fe20000000000ULL, 0x000000095b5b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000042b3e7824ULL, 0x004fe400078e023aULL, 0x000000303b2b7836ULL, 0x000fc60000000000ULL,
0x018a80003e2a7984ULL, 0x000e640000000800ULL, 0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL,
0x000001002b2a7825ULL, 0x000fc800078e0028ULL, 0x00000010392a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a3f7faeULL, 0x0003e8000b901c4eULL,
0x0186d0003d357984ULL, 0x000ea20000000800ULL, 0x000000015e3f7824ULL, 0x042fe400078e0203ULL,
0x000000085e5e7824ULL, 0x000fca00078e00ffULL, 0xfffffff85e3f7812ULL, 0x000fc800078ee23fULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000004353e7824ULL, 0x004fe400078e023aULL,
0x000000343b357836ULL, 0x000fc60000000000ULL, 0x018a80003e347984ULL, 0x000e640000000800ULL,
0x0000000b34357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000001039347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345b7faeULL, 0x0003e8000b901c4eULL, 0x0186e0003d2b7984ULL, 0x000ea20000000800ULL,
0x0000003c3b357836ULL, 0x002fe40000000000ULL, 0x000000042b3e7824ULL, 0x004fe400078e023aULL,
0x000000383b2b7836ULL, 0x000fe40000000000ULL, 0x000000013c3b7824ULL, 0x040fe200078e0203ULL,
0x018a80003e2a7984ULL, 0x000e620000000800ULL, 0x000000083c3c7824ULL, 0x000fca00078e00ffULL,
0xfffffff83c3b7812ULL, 0x000fc800078ee23bULL, 0x000000093b3b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b2a2b7c24ULL, 0x002fc8000f8e022bULL, 0x000001002b2a7825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c4eULL, 0x0186f0003d3d7984ULL, 0x000ea40000000800ULL,
0x000000043d347824ULL, 0x004fcc00078e023aULL, 0x018a800034347984ULL, 0x000ea40000000800ULL,
0x0000000b34357c24ULL, 0x004fc8000f8e0235ULL, 0x0000010035287825ULL, 0x000fc800078e0028ULL,
0x0000001039287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000283b7faeULL, 0x0003e4000b901c4eULL, 0x000000ff3600720cULL, 0x000fe20003f25270ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000000bc9947ULL, 0x000fea0003800000ULL,
0x00009200ff287b82ULL, 0x002e620000000a00ULL, 0x00000001382a7836ULL, 0x000fe20000000000ULL,
0x000000033800780cULL, 0x000fe20003f85270ULL, 0x00000020033b7836ULL, 0x000fe20000000000ULL,
0x000000375c00720cULL, 0x0c0fe40003f64070ULL, 0x000000375c00720cULL, 0x000fe40003f24070ULL,
0x00000002ff2b7819ULL, 0x000fe4000001162aULL, 0x000000032a2a7812ULL, 0x000fc400078ec0ffULL,
0x000000012b347807ULL, 0x000fe40004800000ULL, 0x000000ff2a2a7207ULL, 0x000fc60004800000ULL,
0x0000000137377824ULL, 0x000fe400078e0234ULL, 0x000000015d397824ULL, 0x000fe400078e022aULL,
0x0000010037347824ULL, 0x000fe200078e0248ULL, 0x000000000044b947ULL, 0x000fec0002000000ULL,
0x000000030300780cULL, 0x000fe20003f24070ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000402027836ULL, 0x000fd60000000000ULL, 0x0000000000301947ULL, 0x000fea0003800000ULL,
0x00008c00ff2a7b82ULL, 0x000ea20000000a00ULL, 0x0000000412357824ULL, 0x000fe200078e0203ULL,
0x0000000702007c0cULL, 0x000fe2000bf26070ULL, 0x0000900000097ab9ULL, 0x000fe20000000800ULL,
0x0000000403377824ULL, 0x000fe400078e023aULL, 0x0000000235357824ULL, 0x000fc800078e00ffULL,
0x0000000935357c24ULL, 0x000fc8000f8e0202ULL, 0x00000004352a7825ULL, 0x004fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a800002a377faeULL, 0x0005e4000c92184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001342a7824ULL, 0x104fe200078e0203ULL,
0x0000940000097ab9ULL, 0x000fe20000000800ULL, 0x000000013b2b7824ULL, 0x100fe400078e0234ULL,
0x0000000939347c24ULL, 0x000fe2000f8e0234ULL, 0x0000000d2a007c0cULL, 0x000fe2000bf26070ULL,
0x0000000403377824ULL, 0x000fe200078e0246ULL, 0x0000000d2b007c0cULL, 0x000fe2000bf66070ULL,
0x00000001342b7824ULL, 0x000fe400078e0203ULL, 0x000000013b357824ULL, 0x000fc400078e0234ULL,
0x000000042b2a7825ULL, 0x002fc800078e0028ULL, 0x0000000435287825ULL, 0x000fe400078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x186000002a377faeULL, 0x0003e8000c92184eULL,
0x1868000028377faeULL, 0x0003e4000d92184eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002003627836ULL, 0x000fe20000000000ULL, 0xfffffff803287812ULL, 0x042fe200078ec0ffULL,
0x0000000c08087291ULL, 0x000fe2000f8e683fULL, 0x00000007035e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff657224ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ec0ffULL,
0x0000200008087890ULL, 0x000fe2000fffe03fULL, 0x0000000728637812ULL, 0x000fe400078ef803ULL,
0x000000085e5b7812ULL, 0x000fc400078ef803ULL, 0x0000000762627812ULL, 0x000fce00078ef803ULL,
0x0000000163287824ULL, 0x140fe400078e0265ULL, 0x0000000863297824ULL, 0x000fe400078e00ffULL,
0x00000008622a7824ULL, 0x000fe400078e00ffULL, 0x0000000860667824ULL, 0x100fe200078e0265ULL,
0xfffffff829287812ULL, 0x000fe200078ee228ULL, 0x0000000162297824ULL, 0x000fe400078e0265ULL,
0x0000000266667824ULL, 0x000fe200078e00ffULL, 0x0000000828287c11ULL, 0x000fe2000f8e20ffULL,
0x0000000862787824ULL, 0x000fe200078e00ffULL, 0xfffffff82a297812ULL, 0x000fc600078ee229ULL,
0x000000002834783bULL, 0x000e620000000200ULL, 0x0000000829297c11ULL, 0x000fca000f8e20ffULL,
0x00000000293c783bULL, 0x0004e20000000200ULL, 0x0001000034287824ULL, 0x042fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011434ULL, 0x0000010034297824ULL, 0x044fe200078e00ffULL,
0x0000888034737816ULL, 0x000fe200000000ffULL, 0x00010000352a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x000001003c767824ULL, 0x008fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff2a7819ULL, 0x000fc4000001142aULL, 0x00000018ff387819ULL, 0x000fe40000011435ULL,
0x0000888035747816ULL, 0x040fe200000000ffULL, 0x0000010035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011436ULL, 0x0000002800347306ULL, 0x0003e20000200c00ULL,
0x0000888036397816ULL, 0x000fe400000000ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff6b7819ULL, 0x000fc40000011437ULL, 0x00008880376f7816ULL, 0x000fe200000000ffULL,
0x0000002900777306ULL, 0x0005e20000200c00ULL, 0x0001000036287824ULL, 0x042fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe2000001143cULL, 0x0000010036367824ULL, 0x000fe200078e00ffULL,
0x000088803c697816ULL, 0x000fe400000000ffULL, 0x00000018ff3a7819ULL, 0x000fe40000011428ULL,
0x0000006603287211ULL, 0x000fe200078fe0ffULL, 0x000000205b297824ULL, 0x044fe200078e00ffULL,
0x0000002a00757306ULL, 0x0003e20000200c00ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000000266667836ULL, 0x000fe20000000000ULL, 0x00000018ff6d7819ULL, 0x000fe2000001143dULL,
0x000000015b287824ULL, 0x000fe200078e0228ULL, 0x00000018ff767819ULL, 0x000fc40000011476ULL,
0x00000018ff6a7819ULL, 0x000fe2000001143eULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0xffffffe029287812ULL, 0x000fe400078ee228ULL, 0x00000018ff687819ULL, 0x000fe4000001143fULL,
0x0000000628287c11ULL, 0x000fe4000f8e20ffULL, 0x0000006603667211ULL, 0x000fe200078fe0ffULL,
0x00000035003b7306ULL, 0x0007e60000200c00ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x000000015b667824ULL, 0x000fe200078e0266ULL, 0x0000541073347816ULL, 0x004fc60000000034ULL,
0x0000007400747306ULL, 0x000ea20000200c00ULL, 0x0001000037357824ULL, 0x048fe400078e00ffULL,
0x0000010037377824ULL, 0x000fe400078e00ffULL, 0x0000000165737836ULL, 0x000fe20000000000ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000000265657836ULL, 0x000fe20000000000ULL,
0x0000003600717306ULL, 0x0007e20000200c00ULL, 0x00000018ff377819ULL, 0x000fc60000011437ULL,
0x000000086500780cULL, 0x000fc80003f25270ULL, 0x0000003500727306ULL, 0x0009e20000200c00ULL,
0x000100003c367824ULL, 0x008fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003800387306ULL, 0x000ee20000200c00ULL, 0x0000541077357816ULL, 0x010fe4000000006cULL,
0x000088803e777816ULL, 0x000fca00000000ffULL, 0x00000037006e7306ULL, 0x0009e20000200c00ULL,
0x00000034281c723cULL, 0x002fee000000181cULL, 0x00000036003c7306ULL, 0x0005e20000200c00ULL,
0x000088803d377816ULL, 0x050fe200000000ffULL, 0x000100003d357824ULL, 0x000fc400078e00ffULL,
0x000001003d3d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fe200078e0037ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x0000541074367816ULL, 0x004fe20000000075ULL, 0x0000000863747824ULL, 0x040fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000000163377824ULL, 0x000fc800078e0273ULL,
0x0000003a003a7306ULL, 0x000e620000200c00ULL, 0xfffffff874747812ULL, 0x000fe400078ee237ULL,
0x000054103b377816ULL, 0x008fe40000000038ULL, 0x0000000874387c11ULL, 0x000fc6000f8e20ffULL,
0x0000003400757306ULL, 0x0003e40000200c00ULL, 0x000000362818723cULL, 0x000fec0000001818ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541039347816ULL, 0x002fe2000000003aULL,
0x000100003e377824ULL, 0x040fe200078e00ffULL, 0x000000003838783bULL, 0x000e620000000200ULL,
0x000001003e3e7824ULL, 0x000fc400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e0077ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000006900697306ULL, 0x000eb00000200c00ULL, 0x00000076006c7306ULL, 0x000fe20000200c00ULL,
0x00005410693c7816ULL, 0x004fce000000003cULL, 0x0000003d00747306ULL, 0x0005f00000200c00ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000100003f3d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003500767306ULL, 0x0005f00000200c00ULL,
0x0000006b006b7306ULL, 0x000ee20000200c00ULL, 0x0000541071357816ULL, 0x004fe20000000070ULL,
0x0000000162717824ULL, 0x000fe200078e0273ULL, 0x00000018ff737819ULL, 0x000fc80000011437ULL,
0xfffffff878717812ULL, 0x000fe200078ee271ULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x00000034282c723cULL, 0x000fe2000000182cULL, 0x000054106e377816ULL, 0x008fcc000000006bULL,
0x0000003d007b7306ULL, 0x0007e20000200c00ULL, 0x0000000871347c11ULL, 0x000fe4000f8e20ffULL,
0x00000018ff6e7819ULL, 0x002fe40000011439ULL, 0x00000018ff6b7819ULL, 0x000fc6000001143bULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054106c3d7816ULL, 0x008fe40000000067ULL,
0x00000018ff6c7819ULL, 0x000fca000001143aULL, 0x0000003600707306ULL, 0x0005e20000200c00ULL,
0x0000003c2814723cULL, 0x000fee0000001814ULL, 0x0000007300737306ULL, 0x000e620000200c00ULL,
0x00005410753c7816ULL, 0x000fe40000000076ULL, 0x00005410743d7816ULL, 0x000fc4000000006dULL,
0x000054106f367816ULL, 0x004fe40000000072ULL, 0x000088803f727816ULL, 0x040fe200000000ffULL,
0x0000003e00777306ULL, 0x000ea20000200c00ULL, 0x000001003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000003c2824723cULL, 0x000fe20000001824ULL, 0x00000018ff6f7819ULL, 0x000fe40000011438ULL,
0x0000888038767816ULL, 0x040fe400000000ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000000362830723cULL, 0x000fe20000001830ULL, 0x00010000383c7824ULL, 0x040fe200078e00ffULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000010038387824ULL, 0x000fe200078e00ffULL,
0x0000006800687306ULL, 0x000fe40000200c00ULL, 0x00000018ff797819ULL, 0x000fc4000001143cULL,
0x00005410703c7816ULL, 0x002fe40000000073ULL, 0x00005410773d7816ULL, 0x004fe4000000006aULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00008880396a7816ULL, 0x040fe400000000ffULL, 0x0000003c280c723cULL, 0x000fe6000000180cULL,
0x0000003f00717306ULL, 0x000e680000200c00ULL, 0x00010000393d7824ULL, 0x040fe200078e00ffULL,
0x0000006a003c7202ULL, 0x000fe20000000f00ULL, 0x0000010039397824ULL, 0x000fc400078e00ffULL,
0x0000003800787306ULL, 0x0005e20000200c00ULL, 0x00000018ff777819ULL, 0x000fe4000001143dULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3d7816ULL, 0x000fc600000000ffULL,
0x0000003900757306ULL, 0x0003e20000200c00ULL, 0x000100003a387824ULL, 0x044fe400078e00ffULL,
0x000001003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000541071397816ULL, 0x002fe40000000068ULL,
0x00000018ff697819ULL, 0x008fe40000011434ULL, 0x0000888034707816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe20000011435ULL, 0x00000038006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fc4000001143aULL, 0x00000018ff3f7819ULL, 0x000fe40000011436ULL,
0x00000018ff3e7819ULL, 0x000fc60000011437ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x0000541072387816ULL, 0x002fe4000000007bULL, 0x000088803b727816ULL, 0x000fca00000000ffULL,
0x000000382820723cULL, 0x000fe20000001820ULL, 0x0000007900797306ULL, 0x000e6c0000200c00ULL,
0x000100003b287824ULL, 0x000fe200078e00ffULL, 0x0000888035387816ULL, 0x000fe200000000ffULL,
0x000000205b297824ULL, 0x000fe200078e00ffULL, 0x0000003a006d7306ULL, 0x0007e20000200c00ULL,
0x0001000035397824ULL, 0x040fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000010035357824ULL, 0x000fe200078e00ffULL, 0xffffffe029667812ULL, 0x000fe200078ee266ULL,
0x0001000034297824ULL, 0x040fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000010034347824ULL, 0x000fe200078e00ffULL, 0x0000002800737306ULL, 0x0009e20000200c00ULL,
0x000001003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fc40000011429ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff3a7819ULL, 0x008fe40000011435ULL,
0x0000003400687306ULL, 0x0003e20000200c00ULL, 0x0000000666287c11ULL, 0x010fe4000f8e20ffULL,
0x0000541078357816ULL, 0x004fe4000000006fULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541076347816ULL, 0x002fce0000000079ULL, 0x0000007700777306ULL, 0x000e700000200c00ULL,
0x0000006e006e7306ULL, 0x000ef00000200c00ULL, 0x0000003b00747306ULL, 0x0009f00000200c00ULL,
0x0000006c006c7306ULL, 0x000f620000200c00ULL, 0x00008880363b7816ULL, 0x050fe200000000ffULL,
0x00000034281c723cULL, 0x004fec000000181cULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x0001000036347824ULL, 0x000fc400078e00ffULL, 0x0000010036367824ULL, 0x000fca00078e00ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011436ULL, 0x0000888037367816ULL, 0x000fc600000000ffULL,
0x0000003400667306ULL, 0x0003f00000200c00ULL, 0x0000007200727306ULL, 0x000f220000200c00ULL,
0x000054103c347816ULL, 0x002fce0000000077ULL, 0x00000035003c7306ULL, 0x0007f00000200c00ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000541075357816ULL, 0x008fe2000000006eULL,
0x00010000376e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001146eULL,
0x000000342818723cULL, 0x000fe20000001818ULL, 0x0000007000707306ULL, 0x000fec0000200c00ULL,
0x0000010037347824ULL, 0x000fe200078e00ffULL, 0x000054106d357816ULL, 0x020fe2000000006cULL,
0x0000007100717306ULL, 0x000e660000200c00ULL, 0x00000018ff6f7819ULL, 0x000fc40000011434ULL,
0x000054103d347816ULL, 0x004fc6000000006aULL, 0x0000006700677306ULL, 0x000fe80000200c00ULL,
0x00000034282c723cULL, 0x000fe8000000182cULL, 0x0000003800387306ULL, 0x000fe60000200c00ULL,
0x0000541072347816ULL, 0x010fc40000000073ULL, 0x0000541074357816ULL, 0x000fc6000000006bULL,
0x0000003900397306ULL, 0x000ea80000200c00ULL, 0x000000342830723cULL, 0x000fe80000001830ULL,
0x0000003a003a7306ULL, 0x000ee60000200c00ULL, 0x0000541070347816ULL, 0x002fc40000000071ULL,
0x0000541068357816ULL, 0x000fc60000000069ULL, 0x0000003f003f7306ULL, 0x000fe80000200c00ULL,
0x000000342814723cULL, 0x000fe80000001814ULL, 0x0000003b003b7306ULL, 0x000e660000200c00ULL,
0x0000541038347816ULL, 0x004fc40000000039ULL, 0x000054103a357816ULL, 0x008fc60000000067ULL,
0x0000003e003e7306ULL, 0x000fe80000200c00ULL, 0x000000342824723cULL, 0x000fe80000001824ULL,
0x0000003600367306ULL, 0x000fe60000200c00ULL, 0x000054103b347816ULL, 0x002fc40000000066ULL,
0x000054103c357816ULL, 0x000fc6000000003fULL, 0x0000006e00377306ULL, 0x000e680000200c00ULL,
0x00000034280c723cULL, 0x000fe8000000180cULL, 0x0000006f003d7306ULL, 0x000ea60000200c00ULL,
0x0000541036347816ULL, 0x002fc40000000037ULL, 0x000054103d357816ULL, 0x004fce000000003eULL,
0x000000342820723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff000141947ULL, 0x000fde000383ffffULL, 0x0000000400087c82ULL, 0x000fe20008000000ULL,
0xffffffc800408947ULL, 0x000fea000383ffffULL, 0x00000002ff287819ULL, 0x000fc80000011603ULL,
0x0000000528007c0cULL, 0x000fe2000bf06070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000528007c0cULL, 0x000fe2000c706470ULL, 0x0000000828287836ULL, 0x000fc60000000000ULL,
0x000000435c00720cULL, 0x000fe40000703070ULL, 0x0000000a28007c0cULL, 0x000fc8000bf26070ULL,
0x0000000528007c0cULL, 0x000fc80008f21070ULL, 0x000000435c00720cULL, 0x000fc60000f24470ULL,
0x000000ffff568224ULL, 0x000fe200078e0021ULL, 0x0000005a235a7208ULL, 0x000fe20000800000ULL,
0x000000ffff538224ULL, 0x000fe200078e0020ULL, 0x0000005722577208ULL, 0x000fe20000800000ULL,
0x000000ffff548224ULL, 0x000fe200078e000dULL, 0x000000580f587208ULL, 0x000fe20000800000ULL,
0x000000ffff518224ULL, 0x000fe200078e000cULL, 0x000000550e557208ULL, 0x000fe20000800000ULL,
0x000000ffff528224ULL, 0x000fe200078e0025ULL, 0x0000000627067208ULL, 0x000fe20000800000ULL,
0x000000ffff4f8224ULL, 0x000fe200078e0024ULL, 0x0000000726077208ULL, 0x000fe20000800000ULL,
0x000000ffff508224ULL, 0x000fe200078e0015ULL, 0x0000000817087208ULL, 0x000fe20000800000ULL,
0x000000ffff4d8224ULL, 0x000fe200078e0014ULL, 0x0000000916097208ULL, 0x000fe20000800000ULL,
0x000000ffff4e8224ULL, 0x000fe200078e0031ULL, 0x0000000a330a7208ULL, 0x000fe20000800000ULL,
0x000000ffff4b8224ULL, 0x000fe200078e0030ULL, 0x0000000b320b7208ULL, 0x000fe20000800000ULL,
0x000000ffff4c8224ULL, 0x000fe200078e002dULL, 0x000000102f107208ULL, 0x000fe20000800000ULL,
0x000000ffff498224ULL, 0x000fe200078e002cULL, 0x000000112e117208ULL, 0x000fe20000800000ULL,
0x000000ffff4a8224ULL, 0x000fe200078e0019ULL, 0x000000401b407208ULL, 0x000fe20000800000ULL,
0x000000ffff478224ULL, 0x000fe200078e0018ULL, 0x000000411a417208ULL, 0x000fe20000800000ULL,
0x000000ffff458224ULL, 0x000fe200078e001dULL, 0x000000421f427208ULL, 0x000fe20000800000ULL,
0x000000ffff048224ULL, 0x000fe200078e001cULL, 0x0000000561007c0cULL, 0x000fc4000bf03070ULL,
0x000000051e057208ULL, 0x000fd60000800000ULL, 0xffffffc400488947ULL, 0x000fea000383ffffULL,
0x00000001ff0f7424ULL, 0x000fe400078e00ffULL, 0x00000012040d7c20ULL, 0x000fe20008410000ULL,
0x0000001245457c20ULL, 0x000fe20008410000ULL, 0x0000001247477c20ULL, 0x000fe20008410000ULL,
0x000000124a4a7c20ULL, 0x000fe20008410000ULL, 0x0000001249497c20ULL, 0x000fe20008410000ULL,
0x018b580f440e79a7ULL, 0x000e62000850003fULL, 0x000000124c4c7c20ULL, 0x000fe20008410000ULL,
0x000000124b4b7c20ULL, 0x000fe20008410000ULL, 0x000000124e4e7c20ULL, 0x000fe20008410000ULL,
0x000000124d4d7c20ULL, 0x000fe20008410000ULL, 0x0000001250507c20ULL, 0x000fe20008410000ULL,
0x000000124f4f7c20ULL, 0x000fe20008410000ULL, 0x0000001252527c20ULL, 0x000fe20008410000ULL,
0x0000001251517c20ULL, 0x000fe20008410000ULL, 0x0000001254547c20ULL, 0x000fe20008410000ULL,
0x0000001253537c20ULL, 0x000fe20008410000ULL, 0x0000001256567c20ULL, 0x000fe20008410000ULL,
0x00000012050c7c20ULL, 0x000fe20008410000ULL, 0x0000001242427c20ULL, 0x000fe20008410000ULL,
0x0000001241417c20ULL, 0x000fe20008410000ULL, 0x0000001240407c20ULL, 0x000fe20008410000ULL,
0x0000001211117c20ULL, 0x000fe20008410000ULL, 0x0000001210107c20ULL, 0x000fe20008410000ULL,
0x000000120b0b7c20ULL, 0x000fe20008410000ULL, 0x000000120a0a7c20ULL, 0x000fe20008410000ULL,
0x0000001209097c20ULL, 0x000fe20008410000ULL, 0x0000001208087c20ULL, 0x000fe20008410000ULL,
0x0000001207077c20ULL, 0x000fe20008410000ULL, 0x0000001206067c20ULL, 0x000fe20008410000ULL,
0x000000ffff177224ULL, 0x002fc400078e000fULL, 0x0000001255557c20ULL, 0x000fe20008410000ULL,
0x0000001258587c20ULL, 0x000fe20008410000ULL, 0x0000001257577c20ULL, 0x000fe20008410000ULL,
0x000000125a5a7c20ULL, 0x000fe20008410000ULL, 0x0000000000047805ULL, 0x000fe20000015200ULL,
0x018b5817440075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff147224ULL, 0x000fce00078e00ffULL, 0x000000101400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e04157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e05ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000114147836ULL, 0x000fce0000000000ULL, 0x018b5817440075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000403047824ULL, 0x000fe200078e00ffULL,
0x000000065f307c11ULL, 0x000fe4000f8e38ffULL, 0x0000001143007c0cULL, 0x000fe4000bf05270ULL,
0xfffffff004057812ULL, 0x000fca00078ec0ffULL, 0x0000000130307824ULL, 0x000fca00078e0205ULL,
0x01840000301c7984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000203047824ULL, 0x000fe200078e00ffULL, 0x0000000d59597c10ULL, 0x000fc8000fffe1ffULL,
0x0000000604047812ULL, 0x000fc800078ec0ffULL, 0x00000001040e7812ULL, 0x040fe400078efcffULL,
0x0000000804147812ULL, 0x000fe400078efcffULL, 0x000000590e00720cULL, 0x080fe40003f26070ULL,
0x00000010040e7812ULL, 0x000fe400078efcffULL, 0x000000591400720cULL, 0x080fe40003f06070ULL,
0x000000590e00720cULL, 0x000fc40003fc6070ULL, 0x0000001104147812ULL, 0x040fe400078efcffULL,
0x00000018040e7812ULL, 0x040fe400078efcffULL, 0x000000590400720cULL, 0x080fe40003f46070ULL,
0x000000591400720cULL, 0x080fe40003fa6070ULL, 0x000000590e00720cULL, 0x000fe40003f66070ULL,
0x0000000904167812ULL, 0x000fc400078efcffULL, 0x0000001904147812ULL, 0x040fe400078efcffULL,
0x00000020040e7812ULL, 0x000fe400078efcffULL, 0xff8000000c0c7808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000042427808ULL, 0x000fe40004800000ULL,
0xff80000045457808ULL, 0x000fc40004800000ULL, 0x000000591600720cULL, 0x080fe40003f86070ULL,
0x000000591400720cULL, 0x080fe40003f46070ULL, 0x000000590e00720cULL, 0x000fe40003f26070ULL,
0x0000002104147812ULL, 0x040fe400078efcffULL, 0x00000028040e7812ULL, 0x000fe400078efcffULL,
0xff80000041417808ULL, 0x000fc40004000000ULL, 0xff80000047477808ULL, 0x000fe40004000000ULL,
0xff80000040407808ULL, 0x000fe40006000000ULL, 0xff8000004a4a7808ULL, 0x000fe40006000000ULL,
0x000000591400720cULL, 0x080fe40003f06070ULL, 0x000000590e00720cULL, 0x000fe40003f86070ULL,
0x0000002904147812ULL, 0x000fc400078efcffULL, 0x00000030040e7812ULL, 0x000fe400078efcffULL,
0xff80000011117808ULL, 0x000fe40007000000ULL, 0xff80000049497808ULL, 0x000fe40007000000ULL,
0xff80000010107808ULL, 0x000fe40006800000ULL, 0xff8000004c4c7808ULL, 0x000fe40006800000ULL,
0x000000591400720cULL, 0x000fc40003fc6070ULL, 0x000000590e00720cULL, 0x000fe40003fa6070ULL,
0x0000003104147812ULL, 0x040fe400078efcffULL, 0x00000038040e7812ULL, 0x040fe400078efcffULL,
0x0000003904047812ULL, 0x000fe400078efcffULL, 0xff8000000b0b7808ULL, 0x000fe40005800000ULL,
0xff8000004b4b7808ULL, 0x000fc40005800000ULL, 0xff8000000a0a7808ULL, 0x000fe40005000000ULL,
0xff8000004e4e7808ULL, 0x000fe40005000000ULL, 0xff80000009097808ULL, 0x000fe40004800000ULL,
0xff8000004d4d7808ULL, 0x000fe40004800000ULL, 0x000000591400720cULL, 0x080fe40003f66070ULL,
0x000000590e00720cULL, 0x000fc40003f46070ULL, 0x000000590400720cULL, 0x000fe40003f26070ULL,
0xff80000008087808ULL, 0x000fe40004000000ULL, 0xff80000050507808ULL, 0x000fe40004000000ULL,
0xff80000007077808ULL, 0x000fe40006000000ULL, 0xff8000004f4f7808ULL, 0x000fe40006000000ULL,
0xff80000006067808ULL, 0x000fc40007000000ULL, 0xff80000052527808ULL, 0x000fe40007000000ULL,
0xff80000055557808ULL, 0x000fe40006800000ULL, 0xff80000051517808ULL, 0x000fe40006800000ULL,
0xff80000058587808ULL, 0x000fe40005800000ULL, 0xff80000054547808ULL, 0x000fe40005800000ULL,
0xff80000057577808ULL, 0x000fc40005000000ULL, 0xff80000053537808ULL, 0x000fe40005000000ULL,
0xff8000005a5a7808ULL, 0x000fe40004800000ULL, 0xff80000056567808ULL, 0x000fce0004800000ULL,
0x0000000d1c00720bULL, 0x004fe20003f1e000ULL, 0x3c003c00ff247424ULL, 0x000fe200078e00ffULL,
0x000000065f2a7c11ULL, 0x000fe2000f8e58ffULL, 0x3c003c00ff257424ULL, 0x000fe200078e00ffULL,
0x0000001c0d1c7208ULL, 0x000fe20004000000ULL, 0x0000000143437836ULL, 0x000fe40000000000ULL,
0x000120002a357836ULL, 0x000fe20000000000ULL, 0x000000451c00720bULL, 0x000fc80003f1e000ULL,
0x0000001c451c7208ULL, 0x000fc80004000000ULL, 0x000000471c00720bULL, 0x000fc80003f1e000ULL,
0x0000001c47057208ULL, 0x000fe40004000000ULL, 0x0c401f001f1c7f89ULL, 0x000fe400000e0000ULL,
0x0000004a0500720bULL, 0x000fc80003f1e000ULL, 0x000000054a047208ULL, 0x000fc80004000000ULL,
0x000000490400720bULL, 0x000fc80003f1e000ULL, 0x0000000449057208ULL, 0x000fc80004000000ULL,
0x0000004c0500720bULL, 0x000fc80003f1e000ULL, 0x000000054c047208ULL, 0x000fc80004000000ULL,
0x0000004b0400720bULL, 0x000fc80003f1e000ULL, 0x000000044b057208ULL, 0x000fc80004000000ULL,
0x0000004e0500720bULL, 0x000fc80003f1e000ULL, 0x000000054e047208ULL, 0x000fc80004000000ULL,
0x0000004d0400720bULL, 0x000fc80003f1e000ULL, 0x000000044d057208ULL, 0x000fc80004000000ULL,
0x000000500500720bULL, 0x000fc80003f1e000ULL, 0x0000000550047208ULL, 0x000fc80004000000ULL,
0x0000004f0400720bULL, 0x000fc80003f1e000ULL, 0x000000044f057208ULL, 0x000fe40004000000ULL,
0x0000000c1d00720bULL, 0x000fe40003f1e000ULL, 0x000000520500720bULL, 0x000fe40003f3e000ULL,
0x0000001d0c1d7208ULL, 0x000fe40004000000ULL, 0x0000000552047208ULL, 0x000fe40004800000ULL,
0x000000421d00720bULL, 0x000fc40003f1e000ULL, 0x000000510400720bULL, 0x000fc80003f3e000ULL,
0x0000000451057208ULL, 0x000fe40004800000ULL, 0x0000001d42047208ULL, 0x000fe40004000000ULL,
0x000000540500720bULL, 0x000fe20003f3e000ULL, 0x0c401f001e1d7f89ULL, 0x000fe200000e0000ULL,
0x000000410400720bULL, 0x000fe40003f1e000ULL, 0x00000005540e7208ULL, 0x000fe40004800000ULL,
0x0000000441057208ULL, 0x000fc40004000000ULL, 0x000000530e00720bULL, 0x000fe40003f3e000ULL,
0x000000400500720bULL, 0x000fe40003f1e000ULL, 0x0000000e530f7208ULL, 0x000fe40004800000ULL,
0x0000000540047208ULL, 0x000fe40004000000ULL, 0x000000560f00720bULL, 0x000fe40003f3e000ULL,
0x000000110400720bULL, 0x000fc40003f1e000ULL, 0x0000000f560f7208ULL, 0x000fe40004800000ULL,
0x0000000411057208ULL, 0x000fc60004000000ULL, 0x0c401f000f0e7f89ULL, 0x000ea200000e0000ULL,
0x000000100500720bULL, 0x000fc80003f1e000ULL, 0x0000000510047208ULL, 0x000fc80004000000ULL,
0x0000000b0400720bULL, 0x000fc80003f1e000ULL, 0x000000040b057208ULL, 0x000fc80004000000ULL,
0x0000000a0500720bULL, 0x000fc80003f1e000ULL, 0x000000050a047208ULL, 0x000fe40004000000ULL,
0x0000000e0f00720bULL, 0x004fe40003f3e000ULL, 0x000000090400720bULL, 0x000fe40003f1e000ULL,
0x0000000f0e0e7208ULL, 0x000fe40004800000ULL, 0x0000000409057208ULL, 0x000fc60004000000ULL,
0x0c201f000e0f7f89ULL, 0x000ea200000e0000ULL, 0x000000080500720bULL, 0x000fc80003f1e000ULL,
0x0000000508047208ULL, 0x000fc80004000000ULL, 0x000000070400720bULL, 0x000fc80003f1e000ULL,
0x0000000407057208ULL, 0x000fc80004000000ULL, 0x000000060500720bULL, 0x000fc80003f1e000ULL,
0x0000000506047208ULL, 0x000fe40004000000ULL, 0x0000000f0e00720bULL, 0x004fe40003f3e000ULL,
0x000000550400720bULL, 0x000fe40003f1e000ULL, 0x0000000e0f2c7208ULL, 0x000fe40004800000ULL,
0x0000000455057208ULL, 0x000fe40004000000ULL, 0x0000001c1f00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b2c147820ULL, 0x000fe20000410000ULL, 0x000000580500720bULL, 0x000fc40003f1e000ULL,
0x0000001f1c2f7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b0d047823ULL, 0x100fe20000010814ULL,
0x00000005580e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010814ULL,
0x000000570e00720bULL, 0x000fe20003f1e000ULL, 0x0000000400047308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010814ULL,
0x0000000e57057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010814ULL,
0x0000005a0500720bULL, 0x000fe20003f1e000ULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010814ULL,
0x000000055a057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b52527823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010814ULL, 0x0c401f00050e7f89ULL, 0x000ea200000e0000ULL,
0x0000004700477308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b56567823ULL, 0x000fe20000010814ULL,
0x00000003ff1c7819ULL, 0x000fe20000011603ULL, 0x0c201f002f327f89ULL, 0x000ee600000e0000ULL,
0x000000031c1c7812ULL, 0x000fc400078ec0ffULL, 0x0000004a004a7308ULL, 0x000ff00000000800ULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x0000000e0500720bULL, 0x004fce0003f1e000ULL,
0x0000004c004c7308ULL, 0x000ea20000000800ULL, 0x000000050e057208ULL, 0x000fe40004000000ULL,
0x000000322f00720bULL, 0x008fc60003f3e000ULL, 0x0c201f00050e7f89ULL, 0x000ee400000e0000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000002f322f7208ULL, 0x000fe40004800000ULL,
0x000000494c14723eULL, 0x004fca00000000ffULL, 0x0000004e004e7308ULL, 0x000eb00000000800ULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x0000000e0500720bULL, 0x008fce0003f1e000ULL,
0x0000005000507308ULL, 0x000ee20000000800ULL, 0x0000004b4e16723eULL, 0x004fe400000000ffULL,
0x000000050e2d7208ULL, 0x000fe40004000000ULL, 0x000000474a0e723eULL, 0x000fe400000000ffULL,
0x0000001d1e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d277820ULL, 0x000fe20000410000ULL,
0x0000004f004f7308ULL, 0x000fe40000000800ULL, 0x0000001e1d2e7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b0c057823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010827ULL,
0x00000004450c723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010827ULL,
0x0000000500057308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b07077823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b06067823ULL, 0x100fe20000010827ULL,
0x0000004200427308ULL, 0x000ea20000000800ULL, 0x0000004d5018723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b5a5a7823ULL, 0x000fe20000010827ULL,
0xfffffff8ff1d7812ULL, 0x000fe200078ee25eULL, 0x0c201f002e317f89ULL, 0x000ee200000e0000ULL,
0x0000004100417308ULL, 0x000fe60000000800ULL, 0x000000081d1f7836ULL, 0x000fc40000000000ULL,
0x000000081d277824ULL, 0x040fe200078e00ffULL, 0x00000005420d723eULL, 0x004fe400000000ffULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x000000081d2b7824ULL, 0x000fe400078e00ffULL,
0x000000011c267824ULL, 0x040fe400078e021dULL, 0x000000011c297824ULL, 0x000fe400078e021fULL,
0x000000081f347824ULL, 0x040fe200078e00ffULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x000000081f337824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee226ULL,
0x0000000426287836ULL, 0x000fe20000000000ULL, 0xfffffff834297812ULL, 0x000fe200078ee229ULL,
0x0000000c26267836ULL, 0x000fe20000000000ULL, 0x00000041400f723eULL, 0x004fc400000000ffULL,
0x0000001000107308ULL, 0x000ea20000000800ULL, 0x000000312e00720bULL, 0x008fe40003f1e000ULL,
0xfffffff82b287812ULL, 0x000fe400078ee228ULL, 0x0000002e312e7208ULL, 0x000fe20004000000ULL,
0x000000240c20723cULL, 0x000fe200000018ffULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0xfffffff833347812ULL, 0x000fe200078ee226ULL,
0x000000ffff267224ULL, 0x000fc400078e0014ULL, 0x0000001029337824ULL, 0x100fe400078e0235ULL,
0x0000001034347824ULL, 0x000fe200078e0235ULL, 0x000000111015723eULL, 0x004fe200000000ffULL,
0x0000000a000a7308ULL, 0x000eb00000000800ULL, 0x0000005200527308ULL, 0x000ee20000000800ULL,
0x0000000b0a17723eULL, 0x004fce00000000ffULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x000000241420723cULL, 0x000fe20000001820ULL, 0x0000004f521a723eULL, 0x008fcc00000000ffULL,
0x0000000800087308ULL, 0x000ea20000000800ULL, 0x000000ffff297224ULL, 0x000fce00078e001aULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x000000090819723eULL, 0x004fce00000000ffULL,
0x0000000600067308ULL, 0x000ea20000000800ULL, 0x000000ffff147224ULL, 0x000fce00078e0019ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x00000007061b723eULL, 0x004fce00000000ffULL,
0x0000005400547308ULL, 0x000ea20000000800ULL, 0x000000241820723cULL, 0x000fee0000001820ULL,
0x0000005300537308ULL, 0x000fe20000000800ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x00000051541c723eULL, 0x004fcc00000000ffULL, 0x0000005600567308ULL, 0x000ea20000000800ULL,
0x000000ffff2a7224ULL, 0x000fce00078e001cULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x00000053561e723eULL, 0x004fce00000000ffULL, 0x0000005800587308ULL, 0x000ea20000000800ULL,
0x000000ffff2b7224ULL, 0x000fce00078e001eULL, 0x0000005700577308ULL, 0x000fe20000000800ULL,
0x00000055581d723eULL, 0x004fce00000000ffULL, 0x0000005a005a7308ULL, 0x000ea40000000800ULL,
0x000000575a1f723eULL, 0x004fce00000000ffULL, 0x000000241c20723cULL, 0x000fee0000001820ULL,
0x000000ffff247224ULL, 0x000fe400078e000cULL, 0x000000ffff257224ULL, 0x000fe400078e000eULL,
0x000000ffff0c7224ULL, 0x000fc400078e000dULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff0e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0017ULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x0000001027217824ULL, 0x000fe400078e0235ULL,
0x000000ffff277224ULL, 0x000fc400078e0016ULL, 0x0000001028237824ULL, 0x000fe400078e0235ULL,
0x000000ffff287224ULL, 0x000fe200078e0018ULL, 0x0000002421007844ULL, 0x0005e20000000200ULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x000000ffff177224ULL, 0x000fe200078e001fULL,
0x0000002823007844ULL, 0x0007e80000000200ULL, 0x0000000c33007844ULL, 0x0007e80000000200ULL,
0x0000001434007844ULL, 0x0007e20000000200ULL, 0x000000ffff217224ULL, 0x004fc600078e0022ULL,
0x0180002c30008388ULL, 0x0007e80000000c00ULL, 0x0182002030008388ULL, 0x0007e20000000a00ULL,
0x0000001043007c0cULL, 0x000fe2000bf06070ULL, 0x018ad81900ff79a7ULL, 0x0007e2000850003fULL,
0x018ae01900ff79a7ULL, 0x0007e2000850003fULL, 0x018ae81900ff79a7ULL, 0x0007e2000850003fULL,
0x018af01900ff79a7ULL, 0x0007f2000850003fULL, 0xffffffac007c8947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000009007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000900008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff09ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000009027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000900007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe18026c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000562ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006e0ULL, 0x0000000000000240ULL, 0x0000001600000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000920ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a00ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a54ULL, 0x0000000000000a38ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001490ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001490ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000014d8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001500ULL, 0x000000000001e700ULL, 0x0000001600000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x000000000001fc00ULL, 0x0000000000000044ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x000000000001fc50ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x000000000001fc50ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000020248ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000020248ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000014d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001500ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001e700ULL, 0x000000000001e700ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001fc00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x000000000001fc50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_90_cubin_len = 131992;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
