
import itertools
import shutil
from evaluation.experiments import ROOT_PATH, separate_slakh_weakly
from evaluation.evaluate_separation import evaluate_separations


hparams = itertools.product([0.0,1.0, 20.0, 40.0], [0,1,2,3], [1])
output_prefix = "weakly-slakh-dirac"
for exp_i, (s_churn, source_id, num_resample) in enumerate(hparams):
    output_dir = ROOT_PATH/"separations"/f"{output_prefix}_{exp_i}"

    separate_slakh_weakly(
        num_samples=100,
        output_dir=str(output_dir),
        s_churn=s_churn,
        source_id=source_id, 
        num_steps=150,
        batch_size=128,
        num_resamples=num_resample,
    )
    
    results = evaluate_separations(output_dir/"sep_round_0",22050,eps=1e-8)
    results.to_csv(output_dir/"metrics.csv")
    shutil.rmtree(str(output_dir))
