
import itertools
import shutil
from evaluation.experiments import ROOT_PATH, separate_slakh_weakly
from evaluation.evaluate_separation import evaluate_separations


hparams = itertools.product([0.0, 1.0, 20.0, 40.0], [0.25, 0.5, 0.75, 1.0, 1.25], [1])
output_prefix = "weakly-slakh-gaussian"
for exp_i, (s_churn, gamma, num_resample) in enumerate(hparams):
    output_dir = ROOT_PATH/"separations"/f"{output_prefix}_{exp_i}"
    
    separate_slakh_weakly(
        num_samples=100,
        output_dir=str(output_dir),
        gamma=gamma,
        s_churn=s_churn,
        num_steps=150,
        batch_size=128,
        num_resamples=num_resample,
        use_gaussian=True,
    )

    results = evaluate_separations(output_dir,22050,eps=1e-8)
    results.to_csv(output_dir/"metrics.csv")
    shutil.rmtree(str(output_dir))
