import shutil
from evaluation.experiments import ROOT_PATH, separate_slakh_weakly
from evaluation.evaluate_separation import evaluate_separations

output_dir = ROOT_PATH/"separations/weakly-slakh-dirac-full"
    
separate_slakh_weakly(
        output_dir=str(output_dir),
        s_churn=40.0,
        source_id=0, 
        num_steps=150,
        batch_size=50,
        num_resamples=2,
)

results = evaluate_separations(output_dir, 22050, eps=1e-8)
results.to_csv(output_dir/"metrics.csv")
shutil.rmtree(str(output_dir))

