import openai
from openai import OpenAI
import tiktoken
from prompts import debt_prompt,simple_fee_prompt,undefined_type_net_prompt, special_case_prompt, remedy_sys_prompt ,assign_types_intro, balance_prompt, goal_test, goal, clarify_output, mark_output, refine_output, all_input, single_goal, single_clarify_output, single_mark_output, single_all_input, QuestionPrompts, price_prompt, reserve_prompt, interest_prompt, only_name_goal
import tcheck_help
from tcheck_help import eprint, einput, f_type_name, f_type_num, read_single, is_convertible_to_int, update_llm_requests, update_llm_tokens, update_llm_tokens_2
from datetime import datetime
import time
import os
import copy
import sys
base_dir = os.path.abspath(os.path.join(os.path.dirname(__file__), '../../../'))

# Add that directory to the system path
sys.path.insert(0, base_dir)
from my_api_key import _get_api_key

tmp = _get_api_key()
if tmp is None:
    print("No key")
    exit(0)
#exit(0)

os.environ["OPENAI_API_KEY"] = tmp 
client = OpenAI(
    # This is the default and can be omitted
    api_key=os.environ.get("OPENAI_API_KEY"),
)
#openai.api_key = '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'
encoding = tiktoken.get_encoding("cl100k_base")
total_tokens = 0
discarded_tokens = 0
message_buffer = 10
token_lengths = []
empty_message = {"role": "user", "content": ""}
tokens_in_minute = 0
last_minute = -1
time_since_last_minute = 0
ERR = 1234

#Global variable for storing financial type prompts
ftype_prompts = {}

#Base messages contain base for all messages, append examples onto the base
base_messages = None

qp = QuestionPrompts()

#SECTION: PREPPING INPUT/PARSING OUTPUT=============================================================================
def read_lines_from_file(file_name, start_line, end_line):
    result = "" 
    if(start_line == None):
        #For global
        return result
    try:
        with open(file_name, 'r') as file:
            lines = file.readlines()
            
            # Ensure start and end lines are within the valid range
            start_line = max(1, min(len(lines), start_line))
            end_line = max(1, min(len(lines), end_line))
            
            # Adjust indices to Python's 0-based indexing
            start_index = start_line - 1
            end_index = end_line
            
            # Extract lines from start to end
            result = ''.join(lines[start_index:end_index])
    except FileNotFoundError:
        eprint(f"Error: File '{file_name}' not found.")
    except Exception as e:
        eprint(f"Error: {e}")
    
    return result

def _get_ftype_for_var(input_str, use_custom, _messages, types):
    global ftype_prompts
    global token_clear
    for ftype in types:
        #TODO: expand possiblities list
        if(ftype not in {"special", "raw balance", "reserve", "price", "interest", "fee", "debt"}):
            continue
        temp_token_clear = token_clear
        if(ftype not in ftype_prompts):
            #Make a copy of _messages to apply prompts to (Only do this once, store in global variable)
            __messages = copy.deepcopy(_messages)
            initialize_single_label(label = ftype, base_messages = __messages)
            for msg in __messages:
                token_clear += 1
            ftype_prompts[ftype] = (__messages, token_clear)
        prompt_message, token_clear = ftype_prompts[ftype]
        ftype_result = ask_message(input_str, use_custom = use_custom, _messages = prompt_message)
        #with open("raw_llm_response.txt", "a") as file:
        #    #file.write("Message: {}\n AI Response (Remedy): {}\n\n".format(message, reply))
        #    file.write("Ftype result: {}\n\n".format(reply))
        token_clear = temp_token_clear
        #Don't need fewshot?
        if((ftype == "special" and ftype_result != -2 ) or (ftype != "special" and ftype_result != -1)):
            #TODO: Determine whether first assignment or all assignment is better
            return(ftype_result)
    return (-1)


#USAGE: Applies the net
def apply_net(_trace):
    #Empty messages
    net_messages = []

    net_sys_prompt = undefined_type_net_prompt
    net_messages.append(pack_system_message(net_sys_prompt))

    #Load trace
    trace, rel_vars = _trace

    while(True):
        llm_response = ask_message(trace + "\n" + str(rel_vars), use_custom = "No template", _messages = net_messages)

        with open("net_output.txt", "a") as file:
            file.write("llm_response")

#USAGE: Remedy implementation
def apply_remedy(_trace):
    # Clear messages
    remedy_messages = []
    #TODO 51

    # Load prompt
    remedy_system_prompt = remedy_sys_prompt
    remedy_messages.append(pack_system_message(remedy_system_prompt))

    # Load trace
    trace, rel_vars = _trace

    new_dict = None

    while(True):
        #Get response
        llm_response = ask_message(trace + "\n" + str(rel_vars), use_custom = "No template", _messages = remedy_messages)

        with open("finance_errors.txt", "a") as file:
            file.write("LLM Response: {}\n".format(llm_response))

        # Parse response
        new_dict = parse_remedy_response(llm_response)
        if(new_dict != ERR):
            eprint(new_dict)
            break

    return new_dict

#USAGE: parses net, returns ERR if ba
def parse_net_response(_response):
    '''
    Net format:
    [Type]:::variable_name:::Reason
    '''
    sanity_check = False
    

#USAGE: parses remedy, returns ERR if bad parse
def parse_remedy_response(_response):
    '''
    #Remedy format:

    Name:XXX
    IFType:XXX
    NFType:XXX
    Reason: XXX

    Name:...

    New_Dict{XXX}

    #Sanity check: compare new_dict with remedy
    '''
    sanity_check = False
    new_dict = {}

    #Split names with new_dict
    _split_dict_response = _response.split("New_Dict")
    if(len(_split_dict_response) != 2):
        eprint("[LLM-Remedy] Parse: Bad split on new dict")
        if(sanity_check):
            return ERR
    
    _var_section = _split_dict_response[0]
    _split_var_section = _var_section.split("Name")
    eprint(_split_var_section)
    _split_var_section = _split_var_section[1:]

    for var_remedy in _split_var_section:
        parsed_var = process_single_remedy(var_remedy, sanity_check)
        eprint("Parsed: {}".format(parsed_var))
        if(parsed_var == ERR):
            if(sanity_check):
                return ERR
            return ERR
        else:
            new_dict[parsed_var[0]] = parsed_var
    
    return new_dict
        
        

#USAGE: Processes a singular variable for remedy
def process_single_remedy(_var_remedy, sanity_check):
    '''
    :XXX
    IFType:XXX
    NFType:XXX
    Reason:XXX
    '''
    _split_nl_remedy = _var_remedy.split("\n")

    if(len(_split_nl_remedy) < 4):
        eprint("[LLM-Remedy] Parse: Bad single variable nl split")
        if(sanity_check):
            eprint("[*LLM-Remedy] {}".format(_split_nl_remedy))
        return ERR

    _var_name = _split_nl_remedy[0]
    _old_ftype = _split_nl_remedy[1]
    _new_ftype = _split_nl_remedy[2]
    _reason = ''.join(_split_nl_remedy[3:])

    try:
        var_name = _var_name.split(":")[1].strip()
        old_ftype = int(_old_ftype.split(":")[1].strip())
        new_ftype = int(_new_ftype.split(":")[1].strip())
        reason = _reason.strip()

        return((var_name, old_ftype, new_ftype, reason))
    except Exception as e:
        eprint("[LLM-Remedy] Parse: Bad single variable ':' split, Error {}".format(e))
        if(sanity_check):
            eprint("[*LLM-Remedy] {}".format(_split_nl_remedy))
        return ERR


#USAGE: given a variable name and a function, do single analysis
def get_finance_types_for_variable(variable_name, filename, function, start_line, end_line, print_output = True):
    global base_messages
    global token_clear
    if(not(read_single)):
        return None
    #Load function
    function_str = read_lines_from_file(filename, start_line, end_line)
    input_str = "Var: " + variable_name + "\n" + "Code: " + function_str

    if(not(variable_name in function_str)):
        eprint("[AI-pp] Did not find in code")
        #NOTE Gets the suffix of a field
        if("." in variable_name):
            var_fields = variable_name.split(".")
            eprint(var_fields[1:])
        return -1

    '''
    code = []
    prompt = "Uninitialized"
    prompt, code = qp.get_prompt(code)
    while(prompt != None):
        eprint("Testing QA instead of few-shot")
        result = ask_message(input_str+"\n"+prompt, use_custom = True)
        code.append(result)
        eprint("_________result:{} code:{}".format(result, code))
        prompt, code = qp.get_prompt(code)

    return {variable_name: _qa_process_code(code)}
    '''
    #few shot

    final_result = -1
    '''
    _messages = copy.deepcopy(base_messages)

    #Initialize single and aggregate response
    initialize_single_label(label = "interest", base_messages = _messages)
    interest_result = ask_message(input_str, use_custom = True, _messages = _messages)
    final_result = interest_result

    if(final_result != -1):
        _messages = copy.deepcopy(base_messages)

        #Initialize raw balance and get response
        initialize_single_label(label = "balance", base_messages = _messages)
        balance_result = ask_message(input_str, use_custom = True, _messages = _messages)
    '''
    approach1_result = _get_ftype_for_var(input_str, True, base_messages, ["special", "raw balance", "price", "interest", "reserve", "fee", "debt"])
    eprint("Approach 1 result: {}".format(approach1_result))
    #exit(1)
    #for msg in _messages:
        #curlen = len(encoding.encode(msg["content"])) + message_buffer
        #token_lengths.append(curlen)
        #total_tokens+=curlen
    #    token_clear+=1
    user_message = False
    message_location = None

    if(user_message == True):
        #Try with user input
        if(message_location):
            while(True):
                try:
                    fp = open(message_location, "r")
                except FileNotFoundError as fnf:
                    eprint("File not found, input new file path:")
                    message_location = einput()
                    if(message_location == "stop"):
                        break
                content = fp.read()
        else:
            content = einput()
        ask_message(content, use_custom = True, _messages = _messages)

            
    return(approach1_result)

#USAGE: given a code, determine the next actions that should be taken
def _qa_process_code(code):
    _result = qp.get_type(code)
    result = _result

    if(_result == -404):
        #-404, ask the user for help on this one, or is not

        if(len(code) == 1):
            #TODO Add something to toggle this
            result = -1

        else:
            eprint("ChatGPT unsure, asking for help (Code: {})\n".format(code))
        
            result = _user_input(task = "Provide type")
    
    elif(_result == -405):
        #-405, do not provide any output

        result = None

    elif(_result == 40):
        #Ask user price of what?

        result = 40

    return result

#USAGE: helper function that asks the user for input
def _user_input(task = None):
    output = None
    if(task == "Provide type"):
        while(True):
            user_input = einput("Appropriate Type:")
            if(user_input == "help"):
                eprint("*"*20)
                eprint("Printing financial type table: {}".format(f_type_name))
                eprint("*"*20)
            else:
                _user_input = is_convertible_to_int(user_input.strip())
                eprint(_user_input)
                if(_user_input and (_user_input in f_type_num)):
                    output = _user_input
                    break
                else:
                    eprint("Please provide a valid financial type. Type 'help' for the table")
    elif(task == "Custom"):
        #TODO
        output = "TODO"

    return output

#USAGE: asks chatgpt for the finance types of a function.
#
def get_finance_types_for_function(filename, function, start_line, end_line, print_output = True):
    if(read_single):
        return None
    #Load the string for the function:
    function_str = read_lines_from_file(filename, start_line, end_line)
    #if(print_output):
    #    print(function_str)
    #query = pack_user_message(function_str)
    return(ask_message(function_str))


#SECTION: CHATGPT===================================================================================================

messages = [ {"role": "system", "content": assign_types_intro} ]

#def initialize_chatgpt():
def pack_system_message(message_str):
    return {"role": "system", "content": message_str}

def pack_user_message(message_str):
    return {"role": "user", "content": message_str}


#TODO: Remove specific type initializations,

def initialize_single_label(label = None, base_messages = None):
    if(base_messages == None):
        #BAD
        exit(0)
        
    if(label == "interest"):
        initialize_interest(ex_subset = [1, 2, 3], _messages = base_messages)
    elif(label == "raw balance"):
        initialize_balance(ex_subset = [2, 3, 4, 5, 6, 9], _messages = base_messages)
    elif(label == "price"):
        initialize_price(ex_subset = [1, 2, 3], _messages = base_messages)
    elif(label == "fee"):
        #TODO implement fee examples
        initialize_fee(ex_subset = [1, 2, 3], _messages = base_messages)
    elif(label == "reserve"):
        #TODO get 3 examples
        initialize_reserve(ex_subset = [1, 2, 3], _messages = base_messages)
    elif(label == "special"):
        initialize_special(_messages = base_messages)
    elif(label == "debt"):
        #TODO implemetn debt examples
        initialize_debt(ex_subset = [], _messages = base_messages)

    _begin = pack_user_message("BEGIN")
    base_messages.append(_begin)

def initialize_chatgpt(disable_fewshot = False):
    global total_tokens
    global token_clear
    global token_lengths
    global messages
    global read_single
    global base_messages
    #Reset everything
    total_tokens = 0
    token_clear = 0
    token_lengths = []
    messages = []
    eprint(f"Reset: ", total_tokens)
    #eprint(f"[I] Reading singles or all? ", read_single)
    if(read_single):
        _system_output = pack_system_message(single_mark_output)
        _all = pack_user_message(single_all_input)

    else:
        _system_output = pack_system_message(mark_output)
        _all = pack_user_message(all_input)
    #message.append(_system_output)
    if(disable_fewshot == True):
        return
    messages.append(_all)
    base_messages = copy.deepcopy(messages)
    #initialize_balance(ex_subset = [2, 3, 4, 5, 9])
    #initialize_price(ex_subset = [1])
    #initialize_reserve(ex_subset = [1])
    #initialize_interest(ex_subset = [1, 2, 3])
    #_begin = pack_user_message("BEGIN")
    #messages.append(_begin)
    #Update global token length
    #eprint("[I] Initial Messages: ", messages)
    #move token clear
    '''
    for msg in messages:
        #curlen = len(encoding.encode(msg["content"])) + message_buffer
        #token_lengths.append(curlen)
        #total_tokens+=curlen
        token_clear+=1
    '''
    #_goal = pack_system_message(goal)
    #goal = pack_system_message(goal_test)
    #messages.append(_goal)
    #_output = pack_system_message(clarify_output)
    #messages.append(_output)

def pack_prompt_messages(prompt_dict, subset, _messages = None):
    global messages
    if(subset == None):
        return
    if(_messages == None):
        _messages = messages
    for i in subset:
        name = "ex" + str(i)
        if(not(name in prompt_dict)):
            print(f" {name} not in dict {prompt_dict['name']}")
            continue
        prompt_message = prompt_dict[name]
        #Test everything is user
        packed_prompt_message = pack_user_message(prompt_message)
        _messages.append(packed_prompt_message)

#Packs the messages the handle special cases
def initialize_special(_messages = None):

    if _messages is not None:
        _messages.append(pack_user_message(special_case_prompt))

#Packs the messages that initialize the balance
def initialize_balance(ex_subset = None, _messages = None):
    balance_introp1 = pack_user_message(balance_prompt["definition"])
    if(_messages == None):
        _messages = messages
    _messages.append(balance_introp1)
    #balance_introp2 = pack_user_message(balance_prompt["introp2"])
    #messages.append(balance_introp2)
    if(ex_subset):
        pack_prompt_messages(balance_prompt, ex_subset, _messages)
    #messages.append(balance_introp1)

#Packs the messages that initialize the balance
def initialize_debt(ex_subset = None, _messages = None):
    debt_introp1 = pack_user_message(debt_prompt["definition"])
    if(_messages == None):
        _messages = messages
    _messages.append(debt_introp1)
    #balance_introp2 = pack_user_message(balance_prompt["introp2"])
    #messages.append(balance_introp2)
    if(ex_subset):
        pack_prompt_messages(debt_prompt, ex_subset, _messages)
    #messages.append(balance_introp1)

#Packs the messages that initialize the price
def initialize_price(ex_subset = None, _messages = None):
    price_definition = pack_user_message(price_prompt["definition"])
    if(_messages == None):
        _messages = messages
    messages.append(price_definition)
    if(ex_subset):
        pack_prompt_messages(price_prompt, ex_subset, _messages)

#Packs the messages that initialize
def initialize_reserve(ex_subset = None, _messages = None):
    reserve_definition = pack_user_message(reserve_prompt["definition"])
    if(_messages == None):
        _messages = messages
    messages.append(reserve_definition)
    if(ex_subset):
        pack_prompt_messages(reserve_prompt, ex_subset, _messages)

def initialize_fee(ex_subset = None, _messages = None):
    fee_definition = pack_user_message(simple_fee_prompt["definition"])
    if(_messages == None):
        _messages = messages
    _messages.append(fee_definition)
    if(ex_subset):
        pack_prompt_messages(simple_fee_prompt, ex_subset, _messages)


def initialize_interest(ex_subset = None, _messages = None):
    global messages
    #Backwards compatibility
    if(_messages == None):
        _messages = messages
    interest_definition = pack_user_message(interest_prompt["definition_v2"])
    _messages.append(interest_definition)
    if(ex_subset):
        pack_prompt_messages(interest_prompt, ex_subset, _messages)

#USAGE: Provides feedback to chatgpt, main usage in clarifying user/chatgpt conflicts
#RETURNS: Does not return anythnig
def provide_feedback(_message):
    ask_message(_message, is_feedback = True, use_custom = True)

#USAGE: given the IR of a variable, output its type solely based on the name
def id_from_name(ir_extok):
    global messages
    #TODO 315
    base_messages = copy.deepcopy(messages)
    _ir = ir_extok
    var_name = _ir.name

    only_name_prompt = pack_user_message(only_name_goal)
    base_messages.append(only_name_prompt)
    
    input_str = "Variable name: " + var_name
    result = ask_message(input_str, use_custom = True, _messages = base_messages)
    return(result)


def get_response_tokens(_messages):
    t = 0
    for message in _messages:
        t+=len(encoding.encode(message['content']))
    return t

#USAGE: Asks chatgpt a message, ask all messages through this function
def ask_message(_message, save_message = True, debug_out = True, is_feedback = False, use_custom = False, _messages = None):

    global total_tokens
    global discarded_tokens
    global token_clear
    global token_lengths
    global last_minute
    global tokens_in_minute
    if(_messages == None):
        _messages = messages
    new_message = []
    #eprint(_message)
    update_llm_requests()
    if(isinstance(use_custom, str)):
        _message = _message
    elif(use_custom):
        _message = refine_output + "\n" + _message
    elif(read_single):
        _message = clarify_output + "\n" + refine_output + "\n" + _message
    else:
        _message = single_clarify_output + "\n" + refine_output + "\n" + _message

    #eprint(f"Single message length: ", len(_message))
    #eprint("Message: {}".format(_message))
    #eprint("All Messages: {}".format(messages))
    message = {"role": "user", "content": _message}
    _messages.append(message)
    '''if(save_message):
        messages.append(message)
        new_message = messages
    else:
        new_message.append(message)'''
    #eprint(f"Before tokens: ", total_tokens, " list: ", token_lengths)
    

    curlen = len(encoding.encode(_message))
    token_lengths.append(curlen)
    total_tokens+=curlen
    update_llm_tokens(total_tokens - discarded_tokens)
    pos = 0
    for _tmessage in _messages:
        if(_tmessage['role'] == 'user' and _tmessage['content'].startswith('[H]')):
            token_clear = pos
            break
        pos+=1


    #eprint(f"Current token length: ", curlen)
    #eprint(f"Tiktoken token length: ", total_tokens)
    #Max token length is 4097, but allow 97 for buffer
    """
    _time = datetime.now()
    #Time manipulation so ChatGPT TPM does not hit 60000
    #   No change since last minute
    eprint(f"Tokens in current minute: ", tokens_in_minute)
    if(_time.minute == last_minute):
        tokens_in_minute+=total_tokens
        if(tokens_in_minute >= 60000):
            time.sleep(60 - _time.second)
            tokens_in_minute = total_tokens
            eprint("Evading API TPM limits...")
    else:
        last_minute = _time.minute
        tokens_in_minute = total_tokens
    """

    #eprint("Time: ", datetime.now())


    #TODO change this to try-except block
    '''
    #Deprecated
    while(total_tokens > 4000 and token_clear < len(messages)):
        total_tokens -= token_lengths[token_clear]
        #eprint(f"Old: ", messages[token_clear])
        messages[token_clear] = empty_message
        #eprint(f"New: ", messages[token_clear])
        token_clear += 1
    #eprint(total_tokens)
    if(total_tokens > 4000):
        #Cannot parse this message
        eprint(f"Could not parse this message (too large)")
        #Remove message
        messages.pop()
        return
    '''
    while(True):
        try:
            tokens = get_response_tokens(_messages)
            update_llm_tokens_2(tokens)
            chat = client.chat.completions.create(
                model="gpt-3.5-turbo", messages=_messages, temperature = 0
            )
            reply = chat.choices[0].message.content
            debug_out = True
            if(debug_out):
                eprint(f" [AI] Chatgpt Reply: {reply}")
            #eprint(f"After tokens: ", token_lengths)
            #eprint(parse_chatgpt_response(reply))
            if(isinstance(use_custom, str)):
                with open("raw_llm_response.txt", "a") as file:
                    #file.write("Message: {}\n AI Response (Remedy): {}\n\n".format(message, reply))
                    file.write("AI Response (Remedy): {}\n\n".format(reply))
                return reply
            if(save_message == False):
                _messages.pop()
            if(not (is_feedback)):
                result = parse_chatgpt_response(reply, use_custom)
                if(result != None):
                    with open("raw_llm_response.txt", "a") as file:
                        #file.write("Message: {}\nAI Response (Normal): {}\n\n".format(message, reply))
                        file.write("AI Response (Normal): {}\n\n".format(reply))
                    if("SANCHK" in reply):
                        return -2
                    return result
                else:
                    continue
            return
        except openai.BadRequestError as e:

            #Message too long
            eprint("All messages: {}".format(_messages))
            
            _messages[token_clear] = empty_message
            discarded_tokens+=token_lengths[token_clear]
            token_clear+=1

            #

        except openai.RateLimitError as e:

            #Too many requests

            seconds_past_last_min = datetime.now().second
            total_sleep_time = 60 - seconds_past_last_min
            time_rem = total_sleep_time%10
            for i in range(int(total_sleep_time/10)+1):
                time.sleep(10)
                eprint("Sleeping for 10 seconds (API rpm)")
            time.sleep(time_rem)
            #time.sleep(60 - seconds_past_last_min)
            eprint("Evading API TPM limits...")
        except openai.APIConnectionError as e:
            eprint("Bad connection...")
            time.sleep(10)
        except openai.APIError as e:
            eprint(e)
            if(e.status == 502):
                #Bad Gateway
                time.sleep(2)
                eprint("Bad Gateway'd")


def get_first_number(s):
    num_str = ""
    
    for char in s:
        if char.isdigit() or (char == '-' and not num_str):  # Consider negative numbers
            num_str += char
        elif num_str:
            break  # Stop when a non-digit character is encountered after finding the number

    if (num_str and num_str != '-'):
        eprint(int(num_str))
        return int(num_str)
    else:
        return None  # Return None if no number is found

#USAGE: Parses a chatgpt response
def parse_chatgpt_response(reply, use_custom = False):
    lines = reply.split("\n")
    #print("x")
    output = {}
    if(use_custom == True):
        num = get_first_number(reply)
        if(num != None):
            return num
        else:
            return None
    for _line in lines:
        #eprint(f"line:", _line)
        line_elements = _line.split(':')
        #eprint(f"line_elements: ", line_elements)
        #eprint(len(line_elements))
        if(len(line_elements) < 2):
            continue
        #Match first element
        key = line_elements[0].replace('"', '')
        line_elements = line_elements[1].split(',')
        #eprint(f" key:", key, " line elements: ", line_elements)
        #item = translate_string_to_f_type(key)
        if(key in f_type_name):
            #item = 
            #eprint("In")
            for _special_variable in line_elements:
                #Strip " and [SPACE] characters
                special_variable = _special_variable.replace('"', '')
                special_variable = special_variable.strip(' ')
                if(special_variable == "END"):
                    continue
                if(special_variable != key):
                    eprint(f"[AI] adding special variable: ", special_variable, "as ", key)
                    output[special_variable] = f_type_name[key]
    return output

def translate_string_to_f_type(str):
    #print(f"str: ", repr(str), "list: ", list(str), "list_comp: ", list("raw balance"), " strcmp:", str.__eq__("raw balance"))
    #eprint(str == "raw balance")
    if(str == "raw balance"):
        #eprint("xxxx")
        return 1
    return -1

#USAGE: Place in Cache for typecheck to pickup


#initialize_chatgpt()
#ask_message("my_balance")
#ask_message("fee")
#ask_message("reserve_amount")
#ask_message("a")