# Comparison of annotations

In this section, we compare the annotations produced by ABAuditor and those produced by human annotations.

This file should be the first file you are referred to from the README.md in the home directory.

We first go over the human annotations. 
Then, we go over the initial annotations produced (i.e. with no reasoning trace feedback loop).  
We explain how they cause the reasoning trace feedback loop to be triggered.
Finally, we go over the final annotation produced (i.e. after the feedback loop is triggered) and compare the two results.

## Human annotations

The human annotations can be found in the file `human_annotation_types.txt`.
In particular, the contents are:
```
[t*], global, hourlyBondAccounts, amount, f: raw balance
[t*], updateHourlyBondAmount, bond, yieldQuotientFP,f: interest rate
[t*], updateHourlyBondAmount, bond, amount, f: raw balance
```

This means that the global variable `hourlyBondAccounts.amount` is a raw balance, variable `bond.yieldQuotientFP` in function `updateHourlyBondAmount()` is an interest rate, and variable `bond.amount` in function `updateHourlyBondAmount()` is a raw balance.

## Initial Annotations by GPT

When initial annotations are performed by GPT, we find that there is a misclassifications.
Namely, variable `bond.amount` was misclassified from a raw balance to a debt.
Refer to file `raw_llm_responses.md` for detail on the specific responses from GPT.

The annotations can be found in the file `no_remedy` in the directory `llm_caches`.
The contents are:
```
[t*], global, hourlyBondAccounts, amount, f: raw balance
[t*], updateHourlyBondAmount, bond, yieldQuotientFP,f: interest rate
[t*], updateHourlyBondAmount, bond, amount, f: debt
```
## Annotations at triggering of feedback loop

The mislabelled annotations eventually cause an accounting bug warning.
Therefore, the reasoning trace feedback loop is triggered.
The assignments at the time of the feedback loop can be found in file `llm_cache_1` in the directory `llm_caches`.
The contents are:
```
[t*], global, hourlyBondAccounts, amount, f: raw balance
[t], applyInterest, balance, f:debt
[t], applyInterest, yieldQuotientFP, f:interest rate
[t*], updateHourlyBondAmount, bond, yieldQuotientFP, f: interest rate
[t*], updateHourlyBondAmount, bond, amount, f: debt
```
Note how there are two extra variables, variable `balance` in function `applyInterest()`, which has financial meaning of debt and variable `yieldQuotientFP` in function `applyInterest()` which has financial meaning of interest rate.
These variables were not assigned by the LLM.
They are instead the result of propagation of the (incorrect) financial meaning of variable `bond.amount`, and the financial meaning of variable `bond.yieldQuotientFP`.

The response from the reasoning trace can be found in file `remedy_response.md`.
In particular, it reclassified the annotation of `bond.amount` to that of raw balance.

## Final annotations

Once the analysis by ABAuditor finishes, the final annotations can be found in file `llm_cache_2` in the directory `llm_caches`.
The contents are:
```
[t*], global, hourlyBondAccounts, amount, f: raw balance
[t*], updateHourlyBondAmount, bond, amount, f: raw balance
[t*], updateHourlyBondAmount, bond, yieldQuotientFP, f: interest rate
```

The annotations are exactly the same as those produced by humans in the early section.
