# Reasoning trace reponses

In this section, we include two instances of our reasoning trace method for detecting hallucinations.
We have processed them to be readable.

The first instance depicts a situation where the reasoning trace correctly fixes a misclassification in the annotation, preventing a false positive warning.

The second instance depicts a situation where the reasoning trace correctly choses to leave the annotations as is, hence detecting a true positive warning.

# Apply Reasoning Trace 1

## Reason

There is an error in the operation `(balance * accumulatorFP) / yieldQuotientFP`.
Specifically, variable `balance` has been incorrectly annotated as a reserve, when it should be a balance.
Hence, when it is divided by variable `yieldQuotientFP`, which is correctly annotated as an interest rate, it fails the rule-based reasoning.
It is handled in the following.

## Related Operations

Here is the list of related operations to the warning.

Trace{
```
Error: (balance * accumulatorFP) / yieldQuotientFP

balance = bond.amount

bond.amount = LLM_Set

yA.accumulatorFP = LLM_Set

yieldQuotientFP = bond.yieldQuotientFP

bond.yieldQuotientFP = LLM_Set
```
}

Tracing back the nodes for the incorrect operation, we can see that the first variable `bond.amount` was initially incorrectly typed as a reserve.

We have excluded the full prompt due to its size.

## LLM Response 

Here is the response by GPT.
```
1) List of variables in the trace: 
- balance
- accumulatorFP
- bond.amount
- yA.accumulatorFP
- yieldQuotientFP

2) 
- balance: Local variable, length 7
- accumulatorFP: Local variable, length 13
- bond.amount: Local variable, length 10
- yA.accumulatorFP: Local variable, length 14
- yieldQuotientFP: Local variable, length 15

3) 
- Name: bond.amount
- Initial Type: reserve
- New type: raw balance
- Reason: Variables with "amount" in the name should not be classified as undef or "-1", as they usually have some financial meaning. A likely correct classification is raw balance ("0").

4) New_Dict:
{
    'amount': raw balance,
    'yieldQuotientFP': interest rate
}
```

GPT corrects the misclassification from reserve to raw balance.
This can be seen in the response starting from "3)...".
In particular, it identifies that variable `bond.amount`, which should have been a raw balance, is annotated as a reserve.


# Apply Reasoning Trace 2


## Reason

There is an error in the operation `bond.amount - oldAmount`.
Specifically, variable `bond.amount` is classified as an accrued balance (i.e. a balance that has had interest applied to it), while variable `oldAmount` is classified as a raw balance.
It is handled in the following.

## Related Operations

Trace{
```
Error: bond.amount - oldAmount
bond.amount = bond.amount * accumulatorFP
bond.amount = LLM_SET
accumulatorFP = ya.accumulatorFP
ya.accumulatorFP = LLM_SET
oldAmount = bond.amount
bond.amount = LLM_Set
```
}

Tracing back the nodes for the incorrect operation, we can see that the first variable `bond.amount` was initially annotated as a raw balance.

## LLM Response

Here is the response by GPT:
```
1) List of variables in the trace: 
    - accumulatorFP
    - bond.amount

2) Variable: accumulatorFP
   - Local variable
   - Length of variable name: 13
    Variable: bond.amount
    -Local variable
    -Length of variable name: 10

3) Reclassification not required. 

NOMIS

```
GPT does not make any attempts to reclassify the annotations.
Hence, this accounting bug is treated as a real one, as demonstrated by the second warning.

