# Gradient-Based Transfer Learning: README

### Experiments

We provide the general command below to run the different models. The important arguments are `--model` and `--set-encoder` which define which method to use and `--dataset` to specify the dataset. 

```
python main.py --model-name meta-fun --model meta-fun --set-encoder none --dataset ${DATASET} --epochs 100 --support-size 20 --dataset-size 100 --seed 1 --num-hypernet-layers 1
python main.py --model-name cavia --model cavia --set-encoder none --dataset ${DATASET}  --epochs 100 --support-size 20 --dataset-size 100 --seed 1 --num-hypernet-layers 1
python main.py --model-name leo --model leo --set-encoder none --dataset ${DATASET}  --epochs 100 --support-size 20 --dataset-size 100 --seed 1 --num-hypernet-layers 1
python main.py --model-name linear --model hyper --set-encoder gradient --dataset ${DATASET}  --epochs 100 --support-size 20 --dataset-size 100 --seed 1 --num-hypernet-layers 1
python main.py --model-name pointnet --model hyper --set-encoder pointnet --dataset ${DATASET}  --epochs 100 --support-size 20 --dataset-size 100 --seed 1 --num-hypernet-layers 1
python main.py --model-name deepsets --model hyper --set-encoder deepsets --dataset ${DATASET}  --epochs 100 --support-size 20 --dataset-size 100 --seed 1 --num-hypernet-layers 1
python main.py --model-name transformer --model hyper --set-encoder set-transformer --dataset ${DATASET}  --epochs 100 --support-size 20 --dataset-size 100 --seed 1 --num-hypernet-layers 1
```

### Datasets
The different datasets used are defined by these arguments:

Cosine-sine experiment: `--dataset shift` 
Pendulum experiment: `--dataset double-pendulum` 
Mujoco Ant experiment: `--dataset ant` 
Maze experiment: `--dataset maze` 

### Data:
The data for the pendulum and maze experiment can be found here: https://drive.google.com/file/d/1V06TsEhp8SxlVpeJzQaUzPA0bcPc-Fqn/view?usp=sharing
Unzip the file in the root directory to create a directory named "data" with the necessary datasets. 

