import numpy as np
import matplotlib.pyplot as plt
import os
from tqdm import tqdm
from PIL import Image


def get_image(env):
    pil_img = Image.fromarray(env.render(mode='rgb_array'))
    resized = pil_img.resize((64, 64))
    return np.asarray(resized)

def change_xml(xml_file, ant_xml_dir, params):
    file_name_to_read = os.path.join(ant_xml_dir,'ant_tmp.xml')
    file_name_to_write = xml_file

    var_dict = create_var_dict(*params)
    replace_variables(var_dict, file_name_to_read, file_name_to_write)

def get_vars(leg_size, ankle_size):
    return leg_size, ankle_size, leg_size, ankle_size, leg_size, ankle_size, leg_size, ankle_size
        
def create_var_dict(front_left_leg, ankle_1, front_right_leg, ankle_2, back_leg, ankle_3, right_back_leg, ankle_4):
    var_dict = {
        "{LENGTH_FRONT_LEFT_LEG}": front_left_leg,
        "{LENGTH_ANKLE_1}": ankle_1,

        "{LENGTH_FRONT_RIGHT_LEG}": front_right_leg,
        "{LENGTH_ANKLE_2}": ankle_2,

        "{LENGTH_BACK_LEG}": back_leg,
        "{LENGTH_ANKLE_3}": ankle_3,

        "{LENGTH_BACK_RIGHT_LEG}": right_back_leg,
        "{LENGTH_ANKLE_4}": ankle_4
    }
    
    return var_dict

def replace_single_variable(file_name_to_read, file_name_to_write, variable_name, variable_value):
    with open(file_name_to_read, 'r') as f:
        filedata = f.read()
    filedata = filedata.replace(variable_name, str(variable_value))
    with open(file_name_to_write, 'w') as file:
        file.write(filedata)

def replace_variables(var_dict, file_name_to_read, file_name_to_write):
    for ix, (key, value) in enumerate(var_dict.items()):
        if ix == 1:
            file_name_to_read = file_name_to_write
            
        replace_single_variable(file_name_to_read, file_name_to_write, key, value)
        
    #print("Done! New file: ", file_name_to_write)

