#!/usr/bin/env bash
# set -e

# ========= Config you can tweak =========
C_TAGS=("q0.5" "l1")
J_TAGS=("l" "q" "m" "l70")
DATASETS=("Jigsaw" "HSO")
MS=(25 100)

B=1000
N_TEST=5000
ZETA=0.05
PY=python3
# =======================================

for DATASET in "${DATASETS[@]}"; do
  for C_TAG in "${C_TAGS[@]}"; do
    for J_TAG in "${J_TAGS[@]}"; do
      FILE="./data/${DATASET}/${C_TAG}_${J_TAG}.jsonl"
      if [[ ! -f "$FILE" ]]; then
        echo "[SKIP] Missing file: $FILE"
        continue
      fi
      for M in "${MS[@]}"; do
        echo "=== ${DATASET}  C=${C_TAG}  J=${J_TAG}  m=${M} ==="
        $PY NHT.py \
          --dataset "${DATASET}" \
          --m ${M} \
          --c "${C_TAG}" \
          --j "${J_TAG}" \
          --B ${B} \
          --n_test ${N_TEST} \
          --zeta ${ZETA} || true
      done
    done
  done
done