import os
import subprocess
from pathlib import Path


# This script builds the library as a docker container and then runs
# the tests inside the container.


SCRIPT_PATH = Path(__file__).parent.resolve()
CONTAINER_NAME = "lib_llm_test"
CONTAINER_HOME_DIR = Path("/home/exp")
VOLUMES = [
    "lib_llm",
    "tests",
    "examples",
]


def run_docker():
    build_command = [
        "docker",
        "build",
        "-t",
        f"{CONTAINER_NAME}:latest",
        "-f",
        str(SCRIPT_PATH / "Dockerfile"),
        str(SCRIPT_PATH.parent.parent),
    ]
    volumes = [
        f"./{volume}:{CONTAINER_HOME_DIR / volume}" for volume in VOLUMES
    ]
    # Insert -v before every volume
    volumes = [
        item
        for sublist in zip(["-v"] * len(volumes), volumes)
        for item in sublist
    ]
    exec_command = [
        "docker",
        "run",
        "--rm",
        *volumes,
        "--shm-size",
        "1gb",
        f"{CONTAINER_NAME}:latest",
        # "echo 'Running typechecks with mypy...'",
        # "poetry run mypy lib_llm --exclude lib_llm/training/",
        # "&&",
        "poetry run pytest ./tests ./examples/inference.py",
    ]
    os.environ["CONTAINER_NAME"] = CONTAINER_NAME
    os.environ["HOST_UID"] = str(os.getuid())
    os.environ["HOST_GID"] = str(os.getgid())

    return subprocess.run(
        " ".join(build_command + ["&&"] + exec_command),
        shell=True,
    ).returncode


if __name__ == "__main__":
    exit(run_docker())
