import os
import sys

import hydra


# Add the shared library to the path, else the modules in the
# library will not be able to import from each other
sys.path.insert(0, os.path.dirname(__file__) + "/lib_llm")
sys.path.insert(0, os.path.dirname(__file__) + "/lib_project")
sys.path.insert(0, os.path.dirname(__file__) + "/lib_dl_base")

from experiments.conditional_prob_mem_dynamics.config import CPMDHandle
from experiments.hyperparameter_search.config import HSHandle
from experiments.in_context_effect.config import ICEFHandle
from experiments.in_context_emergence.config import ICEHandle
from experiments.mechanisms.config import MechHandle
from experiments.memorability.icl_memorization_conflict.config import IMCHandle
from experiments.memorability.icl_memorization_relationship.config import (
    IMRHandle,
)
from experiments.memorability.repeated_strings.config import RSHandle
from experiments.memorability.repeated_tokens.config import RTokHandle
from experiments.memorization_dynamics.config import MDHandle
from experiments.practical_memorization_dynamics.config import PMDHandle
from experiments.prefix_mappings.config import PMHandle
from experiments.random_facts.config import RFHandle
from experiments.repeated_training.config import RTHandle
from lib_project.project import ProjectConfig, run_project, setup_project


EXPERIMENT_HANDLES = [
    HSHandle,
    MDHandle,
    PMHandle,
    ICEHandle,
    RSHandle,
    RTHandle,
    ICEFHandle,
    RTokHandle,
    RSHandle,
    IMRHandle,
    IMCHandle,
    PMDHandle,
    CPMDHandle,
    MechHandle,
    RFHandle,
]


@hydra.main(
    version_base=None,
    config_path="../",
    config_name="project_config",
)
def main(cfg: ProjectConfig) -> None:
    run_project(
        cfg,
        EXPERIMENT_HANDLES,
    )


if __name__ == "__main__":
    setup_project(EXPERIMENT_HANDLES)
    main()
