#!/usr/bin/env python3

import sys
from pathlib import Path


ROOT_PATH = Path(__file__).parent.resolve()
sys.path.insert(0, str(ROOT_PATH / "src/lib_project/"))

from lib_project.dev_ops.actions import ProjectDefaults, run_actions


PROJECT_DEFAULTS = ProjectDefaults(
    project_name="llm_memorization",
    dockerfile="scripts/Dockerfile",
    docker_image_storage_dir="/ANONYMOUS/llm-1/nobackup/ANONYMOUS/containers",
    docker_volumes=[
        "/ANONYMOUS/llm-1/nobackup/ANONYMOUS/llm_base_models:/home/exp/base_models",
        "./.cache/huggingface:/home/exp/.cache/huggingface",
        # "./.cache/deepspeed:/home/exp/.cache/deepspeed",
        "./figures:/home/exp/figures",
    ],
    docker_environment=[
        "HF_HOME=/home/exp/.cache/huggingface/hub",
        "HF_DATASETS_CACHE=/home/exp/.cache/huggingface/datasets",
        # "TORCH_EXTEANONYMOUSIOANONYMOUS_DIR=/home/exp/.cache/deepspeed",
    ],
    docker_env_file=[
        "{home}/.config/dot_envs/wandb.env",
    ],
    notice="""If you are using Docker containers, to enjoy full functionality, please perform the following steps:
- To enable Huggingface caching over container runs, create the following link:
    - mkdir .cache
    - On the ANONYMOUS cluster: mkdir -p /ANONYMOUS/llm-1/nobackup/{username}/huggingface_cache && ln -s /ANONYMOUS/llm-1/nobackup/{username}/huggingface_cache .cache/huggingface
    - On your local machine: ln -s $HOME/.cache/huggingface .cache/huggingface
- To use W&B, create a file at $HOME/.config/dot_envs/wandb.env with the following contents:
    WANDB_API_KEY=<your_key> (API keys can be created at https://wandb.ai/settings)
- Optionally: create a link from a paper figures directory to ./figures to be able to export figures directly to the paper.
    """,
)


if __name__ == "__main__":
    run_actions(defaults=PROJECT_DEFAULTS)
