import matplotlib
matplotlib.rcParams['pdf.fonttype'] = 42
matplotlib.rcParams['ps.fonttype'] = 42
import matplotlib.pyplot as plt
import numpy as np

x_labels = ['$ϵ=1$', '$ϵ=2$', '$ϵ=4$', '$ϵ=8$']
legend_labels = ['R-50 Head', 'ViT-B Head', 'R-50 FiLM', 'ViT-B FiLM', 'R-50 All', 'ViT-B All']
colors = ['gray', 'gray', 'gray', 'gray', 'gray', 'gray']
colors_pr = [
    '#1f77b4',
    '#1f77b4',
    '#ff7f0e',
    '#ff7f0e',
    '#2ca02c',
    '#2ca02c',
]
alphas = [0.2, 0.2, 0.2, 0.2, 0.2, 0.2]
alphas_pr = [1.0, 0.5, 1.0, 0.5, 1.0, 0.5]


def autolabel(ax, rects):
    """Attach a text label above each bar in *rects*, displaying its height."""
    for rect in rects:
        height = rect.get_height()
        ax.annotate('{}'.format(height),
                    xy=(rect.get_x() + rect.get_width() / 2, height),
                    xytext=(0, 1),  # 3 points vertical offset
                    textcoords="offset points",
                    ha='center', va='bottom', rotation=90, fontsize='small')


def plot(ax, file):
    data = np.genfromtxt(file, delimiter=',', skip_header=1, usecols=(1, 2, 3, 4, 5))

    x = np.arange(len(x_labels))  # the label locations
    width = 0.13  # the width of the bars

    rects1 = ax.bar(x - width * 5 / 2, data[0, 4:], width, color=colors[0], alpha=alphas[0])
    rects2 = ax.bar(x - width * 3 / 2, data[1, 4:], width, color=colors[1], alpha=alphas[1])
    rects3 = ax.bar(x - width / 2, data[2, 4:], width, color=colors[2], alpha=alphas[2])
    rects4 = ax.bar(x + width / 2, data[3, 4:], width, color=colors[3], alpha=alphas[3])
    rects5 = ax.bar(x + width * 3 / 2, data[4, 4:], width, color=colors[4], alpha=alphas[4])
    rects6 = ax.bar(x + width * 5 / 2, data[5, 4:], width, color=colors[5], alpha=alphas[5])

    width_pr = 0.13
    rects1_pr = ax.bar(x - width * 5 / 2, data[0, 0:4], width_pr, label=legend_labels[0], color=colors_pr[0], alpha=alphas_pr[0])
    rects2_pr = ax.bar(x - width * 3 / 2, data[1, 0:4], width_pr, label=legend_labels[1], color=colors_pr[1], alpha=alphas_pr[1])
    rects3_pr = ax.bar(x - width / 2, data[2, 0:4], width_pr, label=legend_labels[2], color=colors_pr[2], alpha=alphas_pr[2])
    rects4_pr = ax.bar(x + width / 2, data[3, 0:4], width_pr, label=legend_labels[3], color=colors_pr[3], alpha=alphas_pr[3])
    rects5_pr = ax.bar(x + width * 3 / 2, data[4, 0:4], width_pr, label=legend_labels[4], color=colors_pr[4], alpha=alphas_pr[4])
    rects6_pr = ax.bar(x + width * 5 / 2, data[5, 0:4], width_pr, label=legend_labels[5], color=colors_pr[5], alpha=alphas_pr[5])

    right_side = ax.spines["right"]
    right_side.set_visible(False)
    top = ax.spines["top"]
    top.set_visible(False)

    ax.set_xticks(x)
    ax.set_xticklabels(x_labels, fontsize='x-large', rotation=0)
    ax.set_ylim(15, 75)

    autolabel(ax, rects1)
    autolabel(ax, rects2)
    autolabel(ax, rects3)
    autolabel(ax, rects4)
    autolabel(ax, rects5)
    autolabel(ax, rects6)

    autolabel(ax, rects1_pr)
    autolabel(ax, rects2_pr)
    autolabel(ax, rects3_pr)
    autolabel(ax, rects4_pr)
    autolabel(ax, rects5_pr)
    autolabel(ax, rects6_pr)


def main():
    files = [
        './vtab_data.txt'
    ]

    fig, axs = plt.subplots(sharey=True, figsize=(9, 2.7))
    fig.set_dpi(300)

    for file, ax in zip(files, [axs]):
        plot(ax, file)

    fig.legend(loc='upper left', bbox_to_anchor=(-0.18, 0.8), fontsize='medium')
    fig.text(-0.01, 0.53, 'Accuracy (%)', va='center', rotation='vertical', fontsize='x-large')
    fig.tight_layout()

    plt.savefig('./plots/vtab_bar_chart.pdf', bbox_inches='tight')


if __name__ == '__main__':
    main()