from sklearn.feature_selection import mutual_info_classif, RFECV, SelectKBest, chi2
from make_data import *
from sklearn.linear_model import Lasso
from sklearn.feature_selection import SelectFromModel
from sklearn.svm import SVC
from sklearn.model_selection import StratifiedKFold
from sklearn.ensemble import ExtraTreesClassifier
import matplotlib.pyplot as plt
from svsvr import *
import pandas as pd

 #

exp_no = 10

importance_mi = np.zeros((exp_no,10))
importance_lasso = np.zeros((exp_no,10))
orders_rfecv = np.zeros((exp_no,10))
importance_k_best = np.zeros((exp_no,10))
importance_ensemble = np.zeros((exp_no,10))
importance_sv2l = np.zeros((exp_no,10))
for i in range(exp_no):
    X, y, dtype, tif = generate_data(n=50, datatype='orange_skin')
    y = y > 0.5

    ## Mutual Informmation Importance
    importance_mi[i,:] = mutual_info_classif(X,y)
    
    ## Lasso importance
    lasso = Lasso().fit(X, y)
    importance_lasso[i,:] = np.abs(lasso.coef_)

    #Recursive elimination
    svc = SVC(kernel="linear")
    rfecv = RFECV(estimator=svc, step=1, cv=StratifiedKFold(2), scoring='accuracy')
    rfecv.fit(X, y)
    orders_rfecv[i,:] = rfecv.ranking_

    ## K best
    bestfeatures = SelectKBest(k='all')
    fit = bestfeatures.fit(X,y)
    importance_k_best[i,:] = fit.scores_

    ## Tree ensemble 
    model = ExtraTreesClassifier()
    model.fit(X,y)
    importance_ensemble[i,:] = model.feature_importances_

    ## SVSVL 
    sv2c = SVSVC(q_additivity=10)
    sv2c.fit(X,y)
    sv_ind = sv2c.support_
    alpha_hat_eta = sv2c.dual_coef_ 
    importance_sv2l[i,:] = Shapley_value(X, alpha_hat_eta, sv_ind, q_additivity = 10, method='dp')

ranking_mi = create_rank(importance_mi)
ranking_lasso = create_rank(importance_lasso)
ranking_k_best = create_rank(importance_k_best)
ranking_ensemble = create_rank(importance_ensemble)
ranking_rfecv = create_rank(orders_rfecv)
ranking_sv2l = create_rank(np.abs(importance_sv2l))

avg_mi = np.mean(ranking_mi[:,tif],axis=1)
avg_lasso = np.mean(ranking_lasso[:,tif],axis=1)
avg_k_best = np.mean(ranking_k_best[:,tif],axis=1)
avg_ensemble = np.mean(ranking_ensemble[:,tif],axis=1)
avg_rfecv = np.mean(ranking_rfecv[:,tif],axis=1)
avg_sv2l = np.mean(ranking_sv2l[:,tif],axis=1)

 
# Creating dataset
data = [avg_mi, avg_k_best, avg_rfecv, avg_ensemble, avg_lasso, avg_sv2l]

# import plotly.express as px

# fig = px.box(df)
# fig.show()


df = pd.DataFrame(np.array(data).T,
                  columns=['MI', 'K-Best', 'RE', 'RF', 'lasso', 'SVSVL'])

ax = df.boxplot(grid=False, fontsize=12, notch=True, patch_artist=True, vert=True)




print('done')

