from sklearn.datasets import load_wine
from sklearn.linear_model import LogisticRegression

from lime.lime_tabular import LimeTabularExplainer
from explainer.SvsvlExp_tabular import SvsvlTabularExplainer

wines = load_wine()
X, y = wines['data'], wines['target']
X = X[y < 2]
y = y[y < 2]
lr = LogisticRegression(random_state=0).fit(X,y)


explainer = LimeTabularExplainer(training_data = X, mode='classification')
i = 1
exp = explainer.explain_instance(X[i,:], lr.predict_proba, num_features=5)
exp.save_to_file("test_lime.html")

svsvlexp = SvsvlTabularExplainer(training_data = X, mode='classification')
svsvlexplanation = svsvlexp.explain_instance(X[i,:], lr.predict_proba, num_features=5)
svsvlexplanation.as_list(type="full")
svsvlexplanation.save_to_file("test_SVSVL.html", interacting_features=2, plot_features=5)

print("Done!")




