import numpy as np
from svsvr import *
import time
import pandas as pd 
import matplotlib.pyplot as plt

sample_size = 1000
feature_size = [10, 12, 15, 18, 20, 22, 25]

plot_only = True
if plot_only == True:
    df = pd.read_csv('time.csv')
    full_bf = df.iloc[:,1]
    shapley_bf = df.iloc[:,2]
    full_dp = df.iloc[:,3]
    shapley_binary = df.iloc[:, 4]

    fig, ax = plt.subplots()

    ax.plot(feature_size[:5], full_bf, label="full  bf")
    ax.plot(feature_size[:5], shapley_bf, label='Shapley bf')
    ax.plot(feature_size[:5], full_dp, label='full dp')
    ax.plot(feature_size[:5], shapley_binary, label='Shapley binary')
    legend = ax.legend(loc='upper center', shadow=True, fontsize='x-large')

    plt.xlabel('#Features')
    plt.ylabel('Time (seconds)')
    plt.show()


exp_size = len(feature_size)
results = np.zeros((exp_size, 4))

for i in range(exp_size):
    print(i)
    X = np.random.randint(2, size=(sample_size,feature_size[i]))
    y = np.random.randint(2, size=(sample_size,))
    q_add = i
    
    start_time = time.time()
    svsvc = SVSVC(q_additivity = feature_size[i], kernel_computation='bf')
    svsvc.fit(X,y)
    shap_vals = svsvc.shapley(method='bf')

    results[i,0] = time.time() - start_time

    start_time = time.time()
    svsvc = SVSVC(q_additivity = feature_size[i], kernel_computation='formula')
    svsvc.fit(X,y)
    train_time = time.time() - start_time

    shap_vals = svsvc.shapley(method='bf')
    results[i,1] = time.time() - start_time

    start_time = time.time()
    shap_vals = svsvc.shapley(method='dp')
    results[i,2] = time.time() - start_time + train_time

    start_time = time.time()
    shap_vals = svsvc.shapley(method='dp', feature_type='binary')
    results[i,3] = time.time() - start_time + train_time

    df = pd.DataFrame(results, columns=['full brute-force', 'Shapley brute-force', 'full dynamic programming', 'binary'])
    df.to_csv('time.csv')



print('done')

    
    

