from diffusers import StableDiffusionPipeline, DiffusionPipeline, DDIMScheduler
from diffusers.loaders import LoraLoaderMixin
import torch

model_path = "xxx"
#pipe = StableDiffusionPipeline.from_pretrained("stabilityai/stable-diffusion-2-1-base", torch_dtype=torch.float16)
pipe = DiffusionPipeline.from_pretrained("stabilityai/stable-diffusion-2-1-base", torch_dtype=torch.float16)
pipe.scheduler = DDIMScheduler(
    beta_start=0.00085,
    beta_end=0.012,
    beta_schedule="scaled_linear",
    clip_sample=False,
    set_alpha_to_one=False,
)
#pipe.load_lora_weights(model_path)

lora_state_dict, network_alphas = LoraLoaderMixin.lora_state_dict(model_path)
LoraLoaderMixin.load_lora_into_unet(lora_state_dict, network_alphas=network_alphas, unet=pipe.unet)
LoraLoaderMixin.load_lora_into_text_encoder(lora_state_dict, network_alphas=network_alphas, text_encoder=pipe.text_encoder)

pipe.to("cuda:0")

prompt = "xxx"
generator = None
image = pipe(prompt, num_inference_steps=50, guidance_scale=7.5, generator=generator).images[0]
image.save("img.png")