#!/bin/bash
for i in $(seq 0 0); do
    CUDA_VISIBLE_DEVICES=0 accelerate launch train_merge_patchall.py \
      --pretrained_model_name_or_path="stabilityai/stable-diffusion-2-1-base" \
      --output_dir="merge_ckpt/" \
      --lora_path_img="img_ckpt/" \
      --instance_datadir_img="img_data/" \
      --lora_path_ref="ref_ckpt/" \
      --instance_prompt_ref="a photo of <asset0>" \
      --instance_datadir_ref="ref_data/" \
      --label_path="annotation.txt" \
      --resolution=512 \
      --train_batch_size=1 \
      --num_train_epochs=100 --checkpointing_steps=5000 \
      --learning_rate=5e-2 --lr_scheduler="constant" --lr_warmup_steps=0 \
      --seed=42 \
      --interval_num=20 \
      --sample_index=$i
done