#!/bin/bash
for i in $(seq 0 0); do
CUDA_VISIBLE_DEVICES=0 accelerate launch --mixed_precision="fp16" train_img.py \
  --pretrained_model_name_or_path="stabilityai/stable-diffusion-2-1-base" \
  --train_data_dir="img_data/" --caption_column="text" \
  --resolution=512 \
  --train_batch_size=1 \
  --num_train_epochs=800 --checkpointing_steps=5000 \
  --learning_rate=1e-04 --lr_scheduler="constant" --lr_warmup_steps=0 \
  --seed=42 \
  --output_dir="img_ckpt/" \
  --train_text_encoder \
  --urank=128 \
  --sample_index=$i 
done