# VisualPrompter  
Training-Free Prompt Engineering for High-Fidelity Text-to-Image Generation

> **Note:** Benchmark CSV files are **not included** in this project due to file size limitations. It will be released in alternative formats in the future. 

## About
VisualPrompter is a **training-free** prompt-engineering framework that bridges the gap between **user-provided prompts** and **model-preferred prompts** for text-to-image generation. Unlike approaches that focus solely on aesthetics, VisualPrompter explicitly maintains **semantic alignment** between generated images and textual descriptions through:

1. **Automatic Self-Reflection** - Identifies missing concepts in initial image generations
2. **Target-Specific Optimization** - Refines prompts via fine-grained concept revision

Achieving state-of-the-art text-image alignment with a **plug-and-play design** compatible with various generative models.

## Quick Start
1. Install dependencies:
```bash
pip install -r requirements.txt
```

### 1. Full Generation Pipeline
```bash
python pipeline.py \
  --model_name "sd15" \
  --data_file "your data file path" \
  --output_file "your output file path" \
```

### 2. Evaluate Semantic Consistency
```bash
python evaluate_semantic_gqa.py \
  --data_file "your results with pipeline" \
```

### 3. Evaluate Overall Score
```bash
python evaluate_score.py \
  --data_file "your results with pipeline" \
  --image_dir "your image path" \
  --metric "clipscore" \
```