function [Xt, info] = FW_K(gradf, subgradg, lmo, maxit, tol, x0, C0)


Xt = x0;

% initialize counters
counter_lmo = 0;
counter_gradf = 0;
counter_subgradg = 0;
timer = tic; 

for t = 1:maxit

    ut = subgradg(Xt);
    Ht = gradf(Xt) - ut;
    
    counter_subgradg = counter_subgradg + 1;
    counter_gradf = counter_gradf + 1;

    St = lmo(Ht);
    counter_lmo = counter_lmo + 1;
    
    Dt = Xt - St;
    gap = Ht(:)'*Dt(:);

    
    info.t(t) = t;
    info.counter_lmo(t) = counter_lmo;
    info.counter_gradf(t) = counter_gradf;
    info.counter_subgradg(t) = counter_subgradg;
    info.gap(t) = gap;
    info.time(t) = toc(timer);

    % Display progress every 10 iterations
    if mod(t, 100) == 0 || t == 1 || gap <= tol
        fprintf('Iteration %d: Gap = %.6f\n', t, gap);
    end

    if gap <= tol
        break;
    end
    
    % Khamaru-Wainwright original step-size
    eta = min(gap/C0, 1);

    Xt = Xt*(1-eta) + eta*St;

end

end

