function X = newton_schulz5(G, steps)
% Newton-Schulz Approximation in MATLAB
% G: Input matrix
% steps: Number of iterative steps (default: 5)
% X: Approximate inverse square root of G

if nargin < 2
    steps = 5;
end

% Constants
a = 3.4445;
b = -4.7750;
c = 2.0315;
eps = 1e-7;

% Normalize G
X = G / (norm(G,'fro') + eps);

% Adjust matrix orientation if necessary
if size(G, 1) > size(G, 2)
    X = X.';
end

% Iterative approximation
for i = 1:steps
    A = X * X.';
    B = b * A + c * A * A;
    X = a * X + B * X;
end

% Adjust matrix orientation back if necessary
if size(G, 1) > size(G, 2)
    X = X.';
end

end