import os
import argparse
import re
import pandas as pd
import openai

game_type = "celebrities"  # Change this as needed

yes_translations = {
    "english": "yes",
    "hindi": "हां",
    "mandarin": "是",  # Mandarin does not have case distinction
    "spanish": "sí",
    "japanese": "はい",  # Japanese does not have case distinction
    "turkish": "evet",
    "french": "oui",
}


#Function for the API calls
def api_call_openai(model_name, prompt, temp, max_tokens):

    # Create messages list using prompt
    messages = [
        {
            "role": "user",
            "content": f"{prompt}",
        }
    ]

    try:
        openai.api_base = "https://api.openai.com/v1"
        response = openai.ChatCompletion.create(
            model=model_name,
            messages=messages,
            max_tokens=max_tokens,
            n=1,
            stop=None,
            temperature=temp,
        )
        return response.choices[0].message.to_dict()["content"].strip().strip("**").strip("*").strip()
        
    except Exception as e:
        return None


def prompt_to_openai_for_giveup_check(game_type, conversation_text):
    if game_type == "celebrities":
        openai_prompt = f"""
        You are analyzing an assistant's response in a 20-questions guessing game. The assitant is attempting to guess the name of a **celebrity**.

        Below is the complete conversation:

        ```
        {conversation_text}
        ```


        Task:
        - Identify the **exact turn number** at which the assistant explicitly or implicitly **gave up** (i.e., admitted they are unable to guess the celebrity).  
        - If the assistant **never gives up**, return `0` as the turn number.

        Important Note:
        - The response **can be in any language**

        A response should be considered as "giving up" if it:
        - Clearly states **inability to make a guess** and doesn't proceed to guess or ask question in the same response (e.g., "I don’t know," "I give up," "I can't figure it out," "No idea").  
        - Asks the other party to **reveal the answer** (e.g., "Tell me the answer").  
        - Uses words or phrases that strongly imply defeat or frustration and doesn't proceed to guess or ask question in the same response (e.g., "I surrender," "I have no guess," "I quit").  
        - Doesn't make a guess and asks a question/responds with something not related to the game (e.g., "What's the weather like?").

        A response should NOT be considered as "giving up" if it:
        - Makes an actual guess and asks if it is correct (e.g., "Is it Brad Pitt?").  
        - Asks a clarifying question to narrow down the options (e.g., "Is the person alive?").
        - Expresses uncertainty but still attempts to reason (e.g., "Not sure, but is it a musician?").
        - Clearly states **inability to make a guess** but proceeds to guess or ask question in the same response ("I can't figure it out, but is it a singer?").
        - Uses words or phrases that strongly imply defeat or frustration but proceeds to guess or ask question in the same response (e.g. "I have no guess, but is it Lionel Messi?").

        If the assistant **gives up**, respond with the **exact turn number** at which this occurs. If the assistant **never gives up**, respond with Turn Number as 0.

        Strictly respond in the following format:
        Response: Turn Number (Give only the integer value)
        """

    elif game_type == "things":
        openai_prompt = f"""
        You are analyzing an assistant's response in a 20-questions guessing game. The assitant is attempting to guess the name of a **thing**.

        Below is the complete conversation:
        
        ```
        {conversation_text}
        ```

        Task:
        - Identify the **exact turn number** at which the assistant explicitly or implicitly **gave up** (i.e., admitted they are unable to guess the thing).
        - If the assistant **never gives up**, return `0` as the turn number.

        Important Note:
        - The response **can be in any language**

        A response should be considered as "giving up" if it:
        - Clearly states **inability to make a guess** and doesn't proceed to guess or ask question in the same response (e.g., "I don’t know," "I give up," "I can't figure it out," "No idea").
        - Asks the other party to **reveal the answer** (e.g., "Tell me the answer").
        - Uses words or phrases that strongly imply defeat or frustration and doesn't proceed to guess or ask question in the same response (e.g., "I surrender," "I have no guess," "I quit").
        - Doesn't make a guess and asks a question/responds with something not related to the game (e.g., "What's the weather like?").

        A response should NOT be considered as "giving up" if it:
        - Makes an actual guess and asks if it is correct (e.g., "Is it a chair?").
        - Asks a clarifying question to narrow down the options (e.g., "Is it a living thing?").
        - Expresses uncertainty but still attempts to reason (e.g., "Not sure, but is it a living thing?").
        - Clearly states **inability to make a guess** but proceeds to guess or ask question in the same response ("I can't figure it out, but is it a living thing?").
        - Uses words or phrases that strongly imply defeat or frustration but proceeds to guess or ask question in the same response (e.g. "I have no guess, but is it a chair?").

        If the assistant **gives up**, respond with the **exact turn number** at which this occurs. If the assistant **never gives up**, respond with Turn Number as 0.

        Strictly respond in the following format:
        Response: Turn Number (Give only the integer value)
        """

    return openai_prompt

def compute_metric(file_path, max_turns, language):
    print(file_path)
    with open(file_path, "r") as txt_file:
        lines = txt_file.readlines()

    
    lines = lines[2:]
    lines = [line.strip() for line in lines if line.strip()]

    num_turns_to_answer = 0
    num_yes = 0
    success = 0
    score = 0
    turn_at_which_given_up = 0

    

    # We need to count turns in pairs of lines (Assistant and User)
    turn_count = 0  # This will track the actual turn number


    # Check if 'Bingo' is found in the last relevant line (User's response or Assistant's turn)
    if "bingo" in lines[min(2 * max_turns, len(lines)) - 1].lower():
        success = 1

     
    for i in range(0, min(2 * max_turns, len(lines)), 2):  # Every two lines represent a turn (Assistant + User)
        # Extract turn number from the Assistant's line (odd index lines in pairs)
        match = re.search(r"Turn (\d+)", lines[i])

        if match:
            turn_count = int(match.group(1))  # Extract turn number from the Assistant's line
        
        print("Turn Count: " + str(turn_count))
        print("File Path" + file_path)
        print("i value: " + str(i))
        print("Lines i: " + str(lines[i]))
        # print("Lines: " + str(lines[i + 1]))
        # Check if the User's response is 'Yes'
        if "User:" in lines[i + 1]:
            if yes_translations[language] in lines[i + 1].lower():
                num_yes += 1
            
            if "You have given up" in lines[i + 1]:
                turn_at_which_given_up = turn_count

    num_turns_to_answer = min(turn_count, max_turns) if success == 1 else 0
    score = (1 - max(num_turns_to_answer - 5, 0) * 0.02) if success == 1 else 0
    return num_turns_to_answer, success, num_yes, score, turn_at_which_given_up

def eval_q20(directory, turn_subsets, language):
    data = []
    print(directory)
    for root, _, files in os.walk(directory):
        for file in files:
            if file.endswith(".txt"):
                file_path = os.path.join(root, file)
                print(f"Computing {file_path}:")
                
                # Extract the celebrity name (file name without the extension)
                entity_name = file[:-4]  # Assuming the format is something like "celebrity_name.txt"

                file_metrics = {'File': entity_name}  # Set the file/celebrity name as the 'File' column

                # # Read the txt file
                # with open(file_path, "r") as txt_file:
                #     lines = txt_file.readlines()

                # # Skip the first and second line
                # first_two_lines = lines[:2]

                # lines = lines[2:]

                # # Make a conversation txt from the lines
                # conversation_text = "".join(lines)

                
                # # Check if bingo is in the last relevant line User's response or Assistant's turn)
                # if "bingo" not in lines[len(lines) - 1].lower() and "You have given up" not in lines[len(lines) - 1]:

                #     times_runned = 0

                #     while(times_runned<5):

                #         response_from_openai_check_giveup = api_call_openai("gpt-4o-mini-2024-07-18",  prompt_to_openai_for_giveup_check(game_type, conversation_text), 0.2, 30)
                #         if response_from_openai_check_giveup is None:
                #             print("Response is None! Retrying")
                #             times_runned += 1
                #             if (times_runned == 5):
                #                 response_from_openai_check_giveup = "N/A"
                #                 print("Response from OpenAI is None! Breaking the loop")
                #                 break
                #             continue
                            
                #         if response_from_openai_check_giveup.startswith("Response:") or response_from_openai_check_giveup.startswith("***Response:***") or response_from_openai_check_giveup.startswith("**Response:**"):
                #             response_from_openai_check_giveup = response_from_openai_check_giveup.split(":")[1].strip().lower().strip('"').strip()
                #             # Check if the response is only an integer
                #             if response_from_openai_check_giveup.isdigit():
                #                 # Check if the turn number given is 0
                #                 if int(response_from_openai_check_giveup) == 0:
                #                     break

                #                 if int(response_from_openai_check_giveup) > 0:
                #                     # Change the user response of the corresponding turn number at which given up to "You have given up!"
                #                     lines[(int(response_from_openai_check_giveup) - 1) * 2 + 1] = f"Turn {int(response_from_openai_check_giveup)}, User: You have given up!"
                #                     # Remove the below part
                #                     lines =  lines[:(int(response_from_openai_check_giveup) - 1) * 2 + 2]
                #                     # Write make to the txt file
                #                     with open(file_path, "w") as txt_file:
                #                         txt_file.writelines(first_two_lines + lines)
                #                     break
                                    
                #             else:
                #                 times_runned += 1
                #                 if (times_runned == 5):
                #                     response_from_openai_check_giveup = "N/A"
                #                     print("Response from OpenAI is not containing a digit Breaking the loop")
                #                     break
                #                 continue

                #         if not response_from_openai_check_giveup.startswith("Response:") or not response_from_openai_check_giveup.startswith("***Response:***") or not response_from_openai_check_giveup.startswith("**Response:**"):
                #             times_runned += 1
                #             if (times_runned == 5):
                #                 response_from_openai_check_giveup = "N/A"
                #                 print("Response from OpenAI is not in starting with response! Breaking the loop")
                #                 break
                #             continue

    
                for turns in turn_subsets:  # Iterate through different turn subsets
                    num_turns_to_answer, success, num_yes, score, turn_at_which_given_up = compute_metric(file_path, turns, language)
                    file_metrics[f'Num_Turns_To_Answer_{turns}_questions'] = num_turns_to_answer
                    file_metrics[f'Success_{turns}_questions'] = success
                    file_metrics[f'Num_Yes_{turns}_questions'] = num_yes
                    file_metrics[f'Score_{turns}_questions'] = score
                    file_metrics[f'Turn_At_Which_Given_Up_{turns}_questions'] = turn_at_which_given_up
                data.append(file_metrics)

    df = pd.DataFrame(data)

   # Calculate the average metrics for each column
    avg_metrics = {}
    for column in df.columns:
        if "Num_Turns_To_Answer" in column or "Turn_At_Which_Given_Up" in column:
            # Check if there are any non-zero values in the column
            non_zero_values = df[df[column] != 0][column]
            if non_zero_values.empty:
                avg_metrics[column] = 0  # Set average to 0 if all values are 0
            else:
                avg_metrics[column] = non_zero_values.mean()  # Calculate mean excluding zeros
        elif column != "File":
            avg_metrics[column] = df[column].mean()
            
    avg_metrics['File'] = 'Average'

    # Insert the average metrics as the first row
    df = pd.concat([pd.DataFrame([avg_metrics]), df], ignore_index=True)

    # Insert 'File' column at the beginning
    df = df[['File'] + [col for col in df.columns if col != 'File']]

    # Save DataFrame to a CSV file
    output_csv = os.path.join(args.dir, 'metrics.csv')
    # Generate column names dynamically based on turn_subsets
    round_columns = {}
    for turns in turn_subsets:
        round_columns[f'Num_Turns_To_Answer_{turns}_questions'] = 3
        round_columns[f'Success_{turns}_questions'] = 3
        round_columns[f'Num_Yes_{turns}_questions'] = 3
        round_columns[f'Score_{turns}_questions'] = 3
        round_columns[f'Turn_At_Which_Given_Up_{turns}_questions'] = 3

    # Round the specified columns and save to CSV
    df.round(decimals=round_columns).to_csv(output_csv, index=False)
    print(f"Metrics saved to {output_csv}")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Eval Q20")
    parser.add_argument("--dir", type=str, help="Path to the directory containing TXT files.")
    #Add language input in arguments
    parser.add_argument("--language", type=str, help="Language of the responses in the TXT files.")
    args = parser.parse_args()
    turns = 150   # Maximum number of turns
    language = args.language
    # Define the turn subsets: 20, 30, ..., turns
    turn_subsets = list(range(20, turns+1, 10))  # Change this as needed

    eval_q20(args.dir, turn_subsets, language)
